/*
Project: angular-gantt v1.2.5 - Gantt chart component for AngularJS
Authors: Marco Schweighauser, Rémi Alvergnat
License: MIT
Homepage: http://www.angular-gantt.com
Github: https://github.com/angular-gantt/angular-gantt.git
*/

!function(){"use strict";angular.module("gantt",["gantt.templates","angularMoment"]).directive("gantt",["Gantt","ganttEnableNgAnimate","$timeout","$templateCache",function(a,b,c,d){return{restrict:"A",transclude:!0,templateUrl:function(a,b){var c;return c=void 0===b.templateUrl?"template/gantt.tmpl.html":b.templateUrl,void 0!==b.template&&d.put(c,b.template),c},scope:{sortMode:"=?",filterTask:"=?",filterTaskComparator:"=?",filterRow:"=?",filterRowComparator:"=?",viewScale:"=?",columnWidth:"=?",expandToFit:"=?",shrinkToFit:"=?",showSide:"=?",allowSideResizing:"=?",fromDate:"=?",toDate:"=?",currentDateValue:"=?",currentDate:"=?",daily:"=?",autoExpand:"=?",taskOutOfRange:"=?",taskContent:"=?",rowContent:"=?",maxHeight:"=?",sideWidth:"=?",headers:"=?",headersFormats:"=?",timeFrames:"=?",dateFrames:"=?",timeFramesWorkingMode:"=?",timeFramesNonWorkingMode:"=?",timespans:"=?",columnMagnet:"=?",shiftColumnMagnet:"=?",timeFramesMagnet:"=?",data:"=?",api:"=?",options:"=?"},controller:["$scope","$element",function(c,d){for(var e in c.options)c[e]=c.options[e];b(!1,d),c.gantt=new a(c,d),this.gantt=c.gantt}],link:function(a,b){a.gantt.api.directives.raise["new"]("gantt",a,b),a.$on("$destroy",function(){a.gantt.api.directives.raise.destroy("gantt",a,b)}),c(function(){a.gantt.initialized()})}}}])}(),function(){"use strict";angular.module("gantt").factory("GanttApi",["$q","$rootScope","ganttUtils",function(a,b,c){function d(a,c,d,e){return b.$on(a,function(){var a=Array.prototype.slice.call(arguments);a.splice(0,1),c.apply(e?e:d.api,a)})}var e=function(a){this.gantt=a,this.listeners=[],this.apiId=c.newId()};return e.prototype.suppressEvents=function(a,b){var c=this,e=angular.isArray(a)?a:[a],f=[];e.forEach(function(a){f=c.listeners.filter(function(b){return a===b.handler})}),f.forEach(function(a){a.dereg()}),b(),f.forEach(function(a){a.dereg=d(a.eventId,a.handler,c.gantt,a._this)})},e.prototype.registerEvent=function(a,c){var e=this;e[a]||(e[a]={});var f=e[a];f.on||(f.on={},f.raise={});var g="event:gantt:"+this.apiId+":"+a+":"+c;f.raise[c]=function(){b.$emit.apply(b,[g].concat(Array.prototype.slice.call(arguments)))},f.on[c]=function(a,b,c){var f=d(g,b,e.gantt,c),h={handler:b,dereg:f,eventId:g,scope:a,_this:c};e.listeners.push(h);var i=function(){h.dereg();var a=e.listeners.indexOf(h);e.listeners.splice(a,1)};return a.$on("$destroy",function(){i()}),i}},e.prototype.registerEventsFromObject=function(a){var b=this,c=[];angular.forEach(a,function(a,b){var d={name:b,events:[]};angular.forEach(a,function(a,b){d.events.push(b)}),c.push(d)}),c.forEach(function(a){a.events.forEach(function(c){b.registerEvent(a.name,c)})})},e.prototype.registerMethod=function(a,b,d,e){this[a]||(this[a]={});var f=this[a];f[b]=c.createBoundedWrapper(e||this.gantt,d)},e.prototype.registerMethodsFromObject=function(a,b){var c=this,d=[];angular.forEach(a,function(a,b){var c={name:b,methods:[]};angular.forEach(a,function(a,b){c.methods.push({name:b,fn:a})}),d.push(c)}),d.forEach(function(a){a.methods.forEach(function(d){c.registerMethod(a.name,d.name,d.fn,b)})})},e}])}(),function(){"use strict";angular.module("gantt").factory("GanttOptions",[function(){var a=function(a,b){this.defaultValues=b,this.values=a,this.defaultValue=function(a){var b=this.defaultValues[a];return angular.isFunction(b)&&(b=b()),b},this.sanitize=function(a,b){if(!b){var c=this.defaultValue(a);if(void 0!==c)return void 0!==b&&"boolean"==typeof c?b:c}return b},this.value=function(a){return this.sanitize(a,this.values[a])},this.set=function(a,b){this.values[a]=b},this.initialize=function(){for(var a in this.values){var b=this.values[a];this.values.hasOwnProperty(a)&&(this.values[a]=this.value(a,b))}return this.values}};return a}])}(),function(){"use strict";angular.module("gantt").factory("GanttCalendar",["$filter","moment",function(a,b){var c=function(a){void 0===a&&(a={}),this.start=a.start,this.end=a.end,this.working=a.working,this.magnet=void 0!==a.magnet?a.magnet:!0,this["default"]=a["default"],this.color=a.color,this.classes=a.classes};c.prototype.updateView=function(){if(this.$element){var a={};a.left=void 0!==this.left?this.left+"px":"",a.width=void 0!==this.width?this.width+"px":"",a["background-color"]=void 0!==this.color?this.color:"",this.$element.css(a);var b=["gantt-timeframe"+(this.working?"":"-non")+"-working"];this.classes&&(b=b.concat(this.classes));for(var c=0,d=b.length;d>c;c++)this.$element.toggleClass(b[c],!0)}},c.prototype.getDuration=function(){return void 0!==this.end&&void 0!==this.start?this.end.diff(this.start,"milliseconds"):void 0},c.prototype.clone=function(){return new c(this)};var d=function(a){this.func=a};d.prototype.getTimeFrames=function(a){var b=this.func(a);return b instanceof Array||(b=[b]),b},d.prototype.clone=function(){return new d(this.func)};var e=function(a){this.evaluator=a.evaluator,a.date?(this.start=b(a.date).startOf("day"),this.end=b(a.date).endOf("day")):(this.start=a.start,this.end=a.end),this.targets=a.targets instanceof Array?a.targets:[a.targets],this["default"]=a["default"]};e.prototype.dateMatch=function(a){return this.evaluator?this.evaluator(a):this.start&&this.end?a>=this.start&&a<=this.end:!1},e.prototype.clone=function(){return new e(this)};var f=function(){this.timeFrames={},this.timeFrameMappings={},this.dateFrames={}};f.prototype.clear=function(){this.timeFrames={},this.timeFrameMappings={},this.dateFrames={}},f.prototype.registerTimeFrames=function(a){angular.forEach(a,function(a,b){this.timeFrames[b]=new c(a)},this)},f.prototype.removeTimeFrames=function(a){angular.forEach(a,function(a){delete this.timeFrames[a]},this)},f.prototype.clearTimeFrames=function(){this.timeFrames={}},f.prototype.registerTimeFrameMappings=function(a){angular.forEach(a,function(a,b){this.timeFrameMappings[b]=new d(a)},this)},f.prototype.removeTimeFrameMappings=function(a){angular.forEach(a,function(a){delete this.timeFrameMappings[a]},this)},f.prototype.clearTimeFrameMappings=function(){this.timeFrameMappings={}},f.prototype.registerDateFrames=function(a){angular.forEach(a,function(a,b){this.dateFrames[b]=new e(a)},this)},f.prototype.removeDateFrames=function(a){angular.forEach(a,function(a){delete this.dateFrames[a]},this)},f.prototype.clearDateFrames=function(){this.dateFrames={}};var g=function(a,b){var c=[];return angular.forEach(a,function(a){a.dateMatch(b)&&c.push(a)}),0===c.length&&angular.forEach(a,function(a){a["default"]&&c.push(a)}),c};return f.prototype.getTimeFrames=function(a){var c=[],d=g(this.dateFrames,a);angular.forEach(d,function(a){void 0!==a&&angular.forEach(a.targets,function(a){var b=this.timeFrameMappings[a];if(void 0!==b)c.push(b.getTimeFrames());else{var d=this.timeFrames[a];void 0!==d&&c.push(d)}},this)},this);var e=a.year(),f=a.month(),h=a.date(),i=[];return 0===c.length&&angular.forEach(this.timeFrames,function(a){a["default"]&&c.push(a)}),angular.forEach(c,function(a){a=a.clone(),void 0!==a.start&&(a.start.year(e),a.start.month(f),a.start.date(h)),void 0!==a.end&&(a.end.year(e),a.end.month(f),a.end.date(h),b(a.end).startOf("day")===a.end&&a.end.add(1,"day")),i.push(a)}),i},f.prototype.solve=function(d,e,f){var g,h,i,j,k=0===d.length;angular.forEach(d,function(a){(void 0===i||i>a.start)&&(i=a.start),(void 0===j||j<a.end)&&(j=a.end),void 0===g&&a.color&&(g=a.color),void 0!==a.classes&&(void 0===h&&(h=[]),h=h.concat(a.classes))}),void 0===e&&(e=i),void 0===f&&(f=j);var l=[new c({start:e,end:f,working:k,magnet:!1,color:g,classes:h})];d=a("filter")(d,function(a){return(void 0===a.start||a.start<f)&&(void 0===a.end||a.end>e)});var m=a("orderBy")(d,function(a){return-a.getDuration()});return angular.forEach(m,function(a){var c=l.slice(),d=0,e=!1,f=!1;angular.forEach(l,function(g){if(!f){if(a.end>g.start&&a.start<g.end){var h=g.clone();g.end=b(a.start),h.start=b(a.end),c.splice(d+1,0,a.clone(),h),f=!0,e=!1}else!e&&a.start<g.end?(g.end=b(a.start),c.splice(d+1,0,a.clone()),e=!0):e&&a.end>g.start&&(g.start=b(a.end),e=!1,f=!0);d++}}),l=c}),l=a("filter")(l,function(a){return(void 0===a.start||a.start<f)&&(void 0===a.end||a.end>e)})},f}])}(),function(){"use strict";angular.module("gantt").factory("GanttCurrentDateManager",["moment",function(a){var b=function(b){var c=this;this.gantt=b,this.date=void 0,this.position=void 0,this.currentDateColumnElement=void 0,this.gantt.$scope.simplifyMoment=function(b){return a.isMoment(b)?b.unix():b},this.gantt.$scope.$watchGroup(["currentDate","simplifyMoment(currentDateValue)"],function(a,b){a!==b&&c.setCurrentDate(c.gantt.options.value("currentDateValue"))})};return b.prototype.setCurrentDate=function(a){this.date=a;var b,c=this.currentDateColumnElement;if(void 0!==this.date&&"column"===this.gantt.options.value("currentDate")){var d=this.gantt.columnsManager.getColumnByDate(this.date,!0);void 0!==d&&void 0!==d.$element&&(b=d.$element)}this.currentDateColumnElement=b,c!==b&&(void 0!==c&&c.removeClass("gantt-foreground-col-current-date"),void 0!==b&&b.addClass("gantt-foreground-col-current-date")),this.position=this.gantt.getPositionByDate(this.date,!0)},b}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumn",["moment",function(a){var b=function(a,b,c,d,e,f,g){this.date=a,this.endDate=b,this.left=c,this.width=d,this.calendar=e,this.duration=this.endDate.diff(this.date,"milliseconds"),this.timeFramesWorkingMode=f,this.timeFramesNonWorkingMode=g,this.timeFrames=[],this.visibleTimeFrames=[],this.daysTimeFrames={},this.cropped=!1,this.originalSize={left:this.left,width:this.width},this.updateTimeFrames()},c=function(a){return a.year()+"-"+a.month()+"-"+a.date()};return b.prototype.updateView=function(){if(this.$element){this.$element.css({left:this.left+"px",width:this.width+"px"});for(var a=0,b=this.timeFrames.length;b>a;a++)this.timeFrames[a].updateView()}},b.prototype.updateTimeFrames=function(){var b=this;if(void 0!==b.calendar&&("hidden"!==b.timeFramesNonWorkingMode||"hidden"!==b.timeFramesWorkingMode)){for(var d=function(c,d,e){return function(f){var g=f.start;void 0===g&&(g=d);var h=f.end;void 0===h&&(h=e),g<b.date&&(g=b.date),h>b.endDate&&(h=b.endDate),f=f.clone(),f.start=a(g),f.end=a(h),c.push(f)}},e=b.date,f=a(e).startOf("day"),g=f.add(1,"day");e<b.endDate;){var h=b.calendar.getTimeFrames(e),i=a.min(g,b.endDate);h=b.calendar.solve(h,e,i);var j=[];angular.forEach(h,d(j,e,i)),b.timeFrames=b.timeFrames.concat(j);var k=c(e);b.daysTimeFrames[k]=j,e=i,f=a(e).startOf("day"),g=f.add(1,"day")}if(angular.forEach(b.timeFrames,function(a){var c=a.start.diff(b.date,"milliseconds"),d=c/b.duration*b.width,e=a.end.diff(a.start,"milliseconds"),f=e/b.duration*b.width,g=!1;a.working&&"visible"!==b.timeFramesWorkingMode?g=!0:a.working||"visible"===b.timeFramesNonWorkingMode||(g=!0),g||b.visibleTimeFrames.push(a),a.hidden=g,a.left=d,a.width=f,a.originalSize={left:a.left,width:a.width}}),"cropped"===b.timeFramesNonWorkingMode||"cropped"===b.timeFramesWorkingMode){var l=0;if(angular.forEach(b.timeFrames,function(a){(!a.working&&"cropped"!==b.timeFramesNonWorkingMode||a.working&&"cropped"!==b.timeFramesWorkingMode)&&(l+=a.width)}),l!==b.width){var m=b.width/l,n=0,o=0,p=!0;angular.forEach(b.timeFrames,function(a){!a.working&&"cropped"!==b.timeFramesNonWorkingMode||a.working&&"cropped"!==b.timeFramesWorkingMode?(a.left=(a.left-n)*m,a.width=a.width*m,a.originalSize.left=(a.originalSize.left-o)*m,a.originalSize.width=a.originalSize.width*m,a.cropped=!1,p=!1):(n+=a.width,o+=a.originalSize.width,a.left=void 0,a.width=0,a.originalSize={left:void 0,width:0},a.cropped=!0)}),b.cropped=p}else b.cropped=!1}}},b.prototype.clone=function(){return new b(a(this.date),a(this.endDate),this.left,this.width,this.calendar)},b.prototype.containsDate=function(a){return a>this.date&&a<=this.endDate},b.prototype.equals=function(a){return this.date===a.date},b.prototype.roundTo=function(a,b,c,d){"day"===b&&(b="date"),c=c||1;var e=a.get(b);switch(d){case"up":e=Math.ceil(e/c);break;case"down":e=Math.floor(e/c);break;default:e=Math.round(e/c)}var f=["millisecond","second","minute","hour","date","month","year"];a.set(b,e*c);for(var g=f.indexOf(b),h=0;g>h;h++)a.set(f[h],0);return a},b.prototype.getMagnetDate=function(b,c,d,e){if(c>0&&void 0!==d){var f=b;if(b=a(b),"column"===d){var g=this.getPositionByDate(b);b=a(g<this.width/2?this.date:this.endDate)}else b=this.roundTo(b,d,c),b<this.date?b=a(this.date):b>this.endDate&&(b=a(this.endDate));if(e)for(var h,i=Math.abs(f.diff(b,"milliseconds")),j=0;j<this.timeFrames.length;j++){var k=this.timeFrames[j];if(k.magnet){var l,m=this.timeFrames[j-1],n=this.timeFrames[j+1];(void 0===m||m.working!==k.working)&&(l=Math.abs(f.diff(k.start,"milliseconds")),i>l&&(void 0===h||h>l)&&(h=l,b=k.start)),(void 0===n||n.working!==k.working)&&(l=Math.abs(f.diff(k.end,"milliseconds")),i>l&&(void 0===h||h>l)&&(h=l,b=k.end))}}}return b},b.prototype.getDateByPositionUsingTimeFrames=function(b){for(var c=0,d=this.timeFrames.length;d>c;c++){var e=this.timeFrames[c];if(!e.cropped&&b>=e.left&&b<=e.left+e.width){var f=e.getDuration()/e.width*(b-e.left),g=a(e.start).add(f,"milliseconds");return g}}},b.prototype.getDateByPosition=function(b,c,d,e){var f,g;return 0>b&&(b=0),b>this.width&&(b=this.width),("cropped"===this.timeFramesNonWorkingMode||"cropped"===this.timeFramesWorkingMode)&&(g=this.getDateByPositionUsingTimeFrames(b)),void 0===g&&(f=this.duration/this.width*b,g=a(this.date).add(f,"milliseconds")),g=this.getMagnetDate(g,c,d,e)},b.prototype.getDayTimeFrame=function(a){var b=this.daysTimeFrames[c(a)];return void 0===b?[]:b},b.prototype.getPositionByDate=function(a){var b,c;if("cropped"===this.timeFramesNonWorkingMode||"cropped"===this.timeFramesWorkingMode)for(var d=a,e=this.getDayTimeFrame(d),f=0;f<e.length;f++){var g=e[f];if(d>=g.start&&d<=g.end){if(!g.cropped)return b=d.diff(g.start,"milliseconds"),c=b/g.getDuration()*g.width,this.left+g.left+c;d=e.length>f+1?e[f+1].start:g.end}}return b=a.diff(this.date,"milliseconds"),c=b/this.duration*this.width,0>c&&(c=0),c>this.width&&(c=this.width),this.left+c},b}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumnGenerator",["GanttColumn","moment",function(a,b){var c=function(c){var d=this;this.columnsManager=c,d.generate=function(c,g,h,i,j){if(!g&&!h)throw"to or maximumWidth must be defined";var k=d.columnsManager.gantt.options.value("viewScale");k=k.trim(),"s"===k.charAt(k.length-1)&&(k=k.substring(0,k.length-1));var l,m,n;k&&(n=k.split(" ")),n&&n.length>1?(l=parseFloat(n[0]),m=n[n.length-1]):(l=1,m=k);var o=d.columnsManager.gantt.calendar,p=d.columnsManager.gantt.options.value("timeFramesWorkingMode"),q=d.columnsManager.gantt.options.value("timeFramesNonWorkingMode"),r=d.columnsManager.getColumnsWidth(),s=!1;c=b(c).startOf(m),g&&(s=e(g),g=b(g).startOf(m));var t=b(c).startOf(m);j&&t.add(-l,m);for(var u=[],v=0;;){if(h&&Math.abs(v)>h+r)break;var w=b(t),x=b(w).add(l,m);f(m,w,x);var y=new a(w,x,i?v+i:v,r,o,p,q);if(!y.cropped&&(u.push(y),j?v-=r:v+=r,g))if(j){if(s&&g>t||!s&&g>=t)break}else if(s&&t>g||!s&&t>=g)break;j?(t.add(-l,m),f(m,t,w)):(t.add(l,m),f(m,w,t))}return j&&(e(c,l,m)&&u.shift(),u.reverse()),u};var e=function(a,c,d){return b(a).add(c,d).startOf(d)===a},f=function(a,b,c){var d=b.get(a),e=c.get(a),f=g(a);void 0!==f&&e!==f&&d>e&&c.set(a,f)},g=function(a){return["hour","minute","second","millisecond"].indexOf(a)>=0?0:void 0}};return c}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumnHeader",["moment","GanttColumn",function(a,b){var c=function(c,d,e,f,g,h){var i=a(c),j=a(i).add(d,e),k=new b(i,j,f,g);return k.unit=e,k.label=angular.isFunction(h)?h(k):i.format(h),k};return c}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumnsManager",["GanttColumnGenerator","GanttHeaderGenerator","$filter","$timeout","ganttLayout","ganttBinarySearch","moment",function(a,b,c,d,e,f,g){var h=function(a){var b=this;this.gantt=a,this.from=void 0,this.to=void 0,this.columns=[],this.visibleColumns=[],this.previousColumns=[],this.nextColumns=[],this.headers=[],this.visibleHeaders=[],this.scrollAnchor=void 0,this.gantt.$scope.$watchGroup(["viewScale","columnWidth","timeFramesWorkingMode","timeFramesNonWorkingMode","fromDate","toDate","autoExpand","taskOutOfRange"],function(a,c){a!==c&&b.gantt.rendered&&b.generateColumns()}),this.gantt.$scope.$watchCollection("headers",function(a,c){a!==c&&b.gantt.rendered&&b.generateColumns()}),this.gantt.$scope.$watchCollection("headersFormats",function(a,c){a!==c&&b.gantt.rendered&&b.generateColumns()}),this.gantt.$scope.$watchGroup(["ganttElementWidth","showSide","sideWidth","maxHeight","daily"],function(a,c){a!==c&&b.gantt.rendered&&b.updateColumnsMeta()}),this.gantt.api.data.on.load(this.gantt.$scope,function(){(void 0===b.from||void 0===b.to||b.from>b.gantt.rowsManager.getDefaultFrom()||b.to<b.gantt.rowsManager.getDefaultTo())&&b.gantt.rendered&&b.generateColumns(),b.gantt.rowsManager.sortRows()}),this.gantt.api.data.on.remove(this.gantt.$scope,function(){b.gantt.rowsManager.sortRows()}),this.gantt.api.registerMethod("columns","clear",this.clearColumns,this),this.gantt.api.registerMethod("columns","generate",this.generateColumns,this),this.gantt.api.registerMethod("columns","refresh",this.updateColumnsMeta,this),this.gantt.api.registerMethod("columns","getColumnsWidth",this.getColumnsWidth,this),this.gantt.api.registerMethod("columns","getColumnsWidthToFit",this.getColumnsWidthToFit,this),this.gantt.api.registerEvent("columns","clear"),this.gantt.api.registerEvent("columns","generate"),this.gantt.api.registerEvent("columns","refresh")};h.prototype.setScrollAnchor=function(){if(this.gantt.scroll.$element&&this.columns.length>0){var a=this.gantt.scroll.$element[0],b=a.scrollLeft+a.offsetWidth/2;this.scrollAnchor=this.gantt.getDateByPosition(b)}},h.prototype.scrollToScrollAnchor=function(){var a=this;this.columns.length>0&&void 0!==this.scrollAnchor&&this.gantt.$scope.$$postDigest(function(){a.gantt.api.scroll.toDate(a.scrollAnchor)})},h.prototype.clearColumns=function(){this.setScrollAnchor(),this.from=void 0,this.to=void 0,this.columns=[],this.visibleColumns=[],this.previousColumns=[],this.nextColumns=[],this.headers=[],this.visibleHeaders=[],this.gantt.api.columns.raise.clear()},h.prototype.generateColumns=function(c,d){if(c||(c=this.gantt.options.value("fromDate")),d||(d=this.gantt.options.value("toDate")),(!c||g.isMoment(c)&&!c.isValid())&&(c=this.gantt.rowsManager.getDefaultFrom(),!c))return!1;if((!d||g.isMoment(d)&&!d.isValid())&&(d=this.gantt.rowsManager.getDefaultTo(),!d))return!1;void 0===c||g.isMoment(c)||(c=g(c)),void 0===d||g.isMoment(d)||(d=g(d)),"expand"===this.gantt.options.value("taskOutOfRange")&&(c=this.gantt.rowsManager.getExpandedFrom(c),d=this.gantt.rowsManager.getExpandedTo(d)),this.setScrollAnchor(),this.from=c,this.to=d;var e=new a(this),f=new b(this);this.columns=e.generate(c,d),this.headers=f.generate(this.columns),this.previousColumns=[],this.nextColumns=[],this.updateColumnsMeta(),this.scrollToScrollAnchor(),this.gantt.api.columns.raise.generate(this.columns,this.headers)},h.prototype.updateColumnsMeta=function(){this.gantt.isRefreshingColumns=!0;var a=this.getLastColumn();this.gantt.originalWidth=void 0!==a?a.originalSize.left+a.originalSize.width:0;var b=this.updateColumnsWidths(this.columns,this.headers,this.previousColumns,this.nextColumns);this.gantt.width=void 0!==a?a.left+a.width:0;var c=this.gantt.options.value("showSide"),d=this.gantt.side.isShown(),e=c!==d;e&&!c&&this.gantt.side.show(!1),this.gantt.rowsManager.updateTasksPosAndSize(),this.gantt.timespansManager.updateTimespansPosAndSize(),this.updateVisibleColumns(b),this.gantt.rowsManager.updateVisibleObjects();var f=this.gantt.options.value("currentDateValue");this.gantt.currentDateManager.setCurrentDate(f),e&&c&&this.gantt.side.show(!0),this.gantt.isRefreshingColumns=!1,this.gantt.api.columns.raise.refresh(this.columns,this.headers)},h.prototype.getLastColumn=function(a){var b=this.columns;return a&&(b=this.nextColumns),b&&b.length>0?b[b.length-1]:void 0},h.prototype.getFirstColumn=function(a){var b=this.columns;return a&&(b=this.previousColumns),b&&b.length>0?b[0]:void 0},h.prototype.getColumnByDate=function(a,b){b||this.expandExtendedColumnsForDate(a);var c=this.previousColumns.concat(this.columns,this.nextColumns),d=f.get(c,a,function(a){return a.date},!0);return void 0!==d[0]?d[0]:d[1]},h.prototype.getColumnByPosition=function(a,b){b||this.expandExtendedColumnsForPosition(a);var c=this.previousColumns.concat(this.columns,this.nextColumns),d=f.get(c,a,function(a){return a.left},!0);return void 0===d[0]?d[1]:d[0]},h.prototype.updateColumnsWidths=function(a,b,c,d){var f=this.gantt.options.value("columnWidth"),g=this.gantt.options.value("expandToFit"),h=this.gantt.options.value("shrinkToFit");if(void 0===f||g||h){var i=this.gantt.getBodyAvailableWidth(),j=this.gantt.columnsManager.getLastColumn(!1);if(void 0!==j){var k=j.originalSize.left+j.originalSize.width;if(g&&i>k||h&&k>i||void 0===f){var l=i/k;return e.setColumnsWidthFactor(a,l),angular.forEach(b,function(a){e.setColumnsWidthFactor(a,l)}),c.splice(0,this.previousColumns.length),d.splice(0,this.nextColumns.length),!0}}}return!1},h.prototype.getColumnsWidth=function(){var a=this.gantt.options.value("columnWidth");return void 0===a&&(a=this.gantt.width<=0?20:this.gantt.width/this.columns.length),a},h.prototype.getColumnsWidthToFit=function(){return this.gantt.getBodyAvailableWidth()/this.columns.length},h.prototype.expandExtendedColumnsForPosition=function(b){if(0>b){var c=this.getFirstColumn(),d=c.date,e=this.getFirstColumn(!0);return(!e||e.left>b)&&(this.previousColumns=new a(this).generate(d,void 0,-b,-this.getColumnsWidth(),!0)),!0}if(b>this.gantt.width){var f=this.getLastColumn(),g=f.getDateByPosition(f.width),h=this.getLastColumn(!0);return(!h||h.left+h.width<b)&&(this.nextColumns=new a(this).generate(g,void 0,b-this.gantt.width,this.gantt.width,!1)),!0}return!1},h.prototype.expandExtendedColumnsForDate=function(b){var c,d=this.getFirstColumn();d&&(c=d.date);var e,f=this.getLastColumn();if(f&&(e=f.getDateByPosition(f.width)),c&&c>b){var g=this.getFirstColumn(!0);return(!g||g.date>b)&&(this.previousColumns=new a(this).generate(c,b,void 0,0,!0)),!0}if(e&&b>=e){var h=this.getLastColumn(!0);return(!h||h.date<e)&&(this.nextColumns=new a(this).generate(e,b,void 0,this.gantt.width,!1)),!0}return!1},h.prototype.getActiveHeadersCount=function(){return this.headers.length},h.prototype.updateVisibleColumns=function(a){this.visibleColumns=c("ganttColumnLimit")(this.columns,this.gantt),this.visibleHeaders=[],angular.forEach(this.headers,function(a){this.visibleHeaders.push(c("ganttColumnLimit")(a,this.gantt))},this),a&&(angular.forEach(this.visibleColumns,function(a){a.updateView()}),angular.forEach(this.visibleHeaders,function(a){angular.forEach(a,function(a){a.updateView()})}));var b=this.gantt.options.value("currentDateValue");this.gantt.currentDateManager.setCurrentDate(b)};var i={year:"YYYY",quarter:"[Q]Q YYYY",month:"MMMM YYYY",week:"w",day:"D",hour:"H",minute:"HH:mm"},j={day:"LL",hour:"H",minute:"HH:mm"},k={year:"YYYY",quarter:"[Q]Q",month:"MMMM"};return h.prototype.getHeaderFormat=function(a){var b,c=this.gantt.options.value("headersFormats");if(void 0!==c&&(b=c[a]),void 0===b){var d=this.gantt.options.value("viewScale");d=d.trim(),"s"===d.charAt(d.length-1)&&(d=d.substring(0,d.length-1));var e,f;d&&(f=d.split(" ")),e=f&&f.length>1?f[f.length-1]:d,["millisecond","second","minute","hour"].indexOf(e)>-1?b=j[a]:["month","quarter","year"].indexOf(e)>-1&&(b=k[a]),void 0===b&&(b=i[a])}return b},h}])}(),function(){"use strict";angular.module("gantt").factory("GanttHeaderGenerator",["GanttColumnHeader",function(a){var b=function(b,c,d){var e,f,g,h,i,j=[];d&&(i=d.split(" ")),i&&i.length>1?(g=parseFloat(i[0]),h=i[i.length-1]):(g=1,h=d);for(var k=0,l=c.length;l>k;k++){var m=c[k],n=m.date.get(h);if(0===k||f!==n){f=n;var o=b.getHeaderFormat(h);e=new a(m.date,g,h,m.originalSize.left,m.originalSize.width,o),e.left=m.left,e.width=m.width,j.push(e)}else e.originalSize.width+=m.originalSize.width,e.width+=m.width}return j};return function(a){this.generate=function(c){var d=[];if(void 0===a.gantt.options.value("headers")){var e=a.gantt.options.value("viewScale");e=e.trim(),"s"===e.charAt(e.length-1)&&(e=e.substring(0,e.length-1));var f,g;e&&(g=e.split(" ")),f=g&&g.length>1?g[g.length-1]:e,["quarter","month"].indexOf(f)>-1&&d.push("year"),["day","week"].indexOf(f)>-1&&d.push("month"),["day"].indexOf(f)>-1&&d.push("week"),["hour"].indexOf(f)>-1&&d.push("day"),["minute","second"].indexOf(f)>-1&&d.push("hour"),["second"].indexOf(f)>-1&&d.push("minute"),d.push(e)}else d=a.gantt.options.value("headers");var h=[];return angular.forEach(d,function(d){h.push(b(a,c,d))}),h}}}])}(),function(){"use strict";angular.module("gantt").factory("Gantt",["GanttApi","GanttOptions","GanttCalendar","GanttScroll","GanttBody","GanttRowHeader","GanttHeader","GanttSide","GanttObjectModel","GanttRowsManager","GanttColumnsManager","GanttTimespansManager","GanttCurrentDateManager","ganttArrays","moment","$document","$timeout",function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){var r=function(f,q){var r=this;this.$scope=f,this.$element=q,this.options=new b(f,{api:angular.noop,data:[],timespans:[],viewScale:"day",columnMagnet:"15 minutes",timeFramesMagnet:!0,showSide:!0,allowSideResizing:!0,currentDate:"line",currentDateValue:o,autoExpand:"none",taskOutOfRange:"truncate",taskContent:"{{task.model.name}}",rowContent:"{{row.model.name}}",maxHeight:0,timeFrames:[],dateFrames:[],timeFramesWorkingMode:"hidden",timeFramesNonWorkingMode:"visible"}),this.api=new a(this),this.api.registerEvent("core","ready"),this.api.registerEvent("core","rendered"),this.api.registerEvent("directives","controller"),this.api.registerEvent("directives","preLink"),this.api.registerEvent("directives","postLink"),this.api.registerEvent("directives","new"),this.api.registerEvent("directives","destroy"),this.api.registerEvent("data","change"),this.api.registerEvent("data","load"),this.api.registerEvent("data","remove"),this.api.registerEvent("data","clear"),this.api.registerMethod("core","getDateByPosition",this.getDateByPosition,this),this.api.registerMethod("core","getPositionByDate",this.getPositionByDate,this),this.api.registerMethod("data","load",this.loadData,this),this.api.registerMethod("data","remove",this.removeData,this),this.api.registerMethod("data","clear",this.clearData,this),this.api.registerMethod("data","get",this.getData,this),this.calendar=new c(this),this.calendar.registerTimeFrames(this.options.value("timeFrames")),this.calendar.registerDateFrames(this.options.value("dateFrames")),this.api.registerMethod("timeframes","registerTimeFrames",this.calendar.registerTimeFrames,this.calendar),this.api.registerMethod("timeframes","clearTimeframes",this.calendar.clearTimeFrames,this.calendar),this.api.registerMethod("timeframes","registerDateFrames",this.calendar.registerDateFrames,this.calendar),this.api.registerMethod("timeframes","clearDateFrames",this.calendar.clearDateFrames,this.calendar),this.api.registerMethod("timeframes","registerTimeFrameMappings",this.calendar.registerTimeFrameMappings,this.calendar),this.api.registerMethod("timeframes","clearTimeFrameMappings",this.calendar.clearTimeFrameMappings,this.calendar),f.$watchGroup(["timeFrames","dateFrames"],function(a,b){if(a!==b){var c=a[0],d=a[1],e=b[0],f=b[1],g=!1;angular.equals(c,e)||(r.calendar.clearTimeFrames(),r.calendar.registerTimeFrames(c),g=!0),angular.equals(d,f)||(r.calendar.clearDateFrames(),r.calendar.registerDateFrames(d),g=!0),g&&r.columnsManager.generateColumns()}}),f.$watch("columnMagnet",function(){var a,b=r.options.value("columnMagnet");b&&(a=b.trim().split(" ")),a&&a.length>1?(r.columnMagnetValue=parseFloat(a[0]),r.columnMagnetUnit=o.normalizeUnits(a[a.length-1])):(r.columnMagnetValue=1,r.columnMagnetUnit=o.normalizeUnits(b))}),f.$watchGroup(["shiftColumnMagnet","viewScale"],function(){var a,b=r.options.value("shiftColumnMagnet");b&&(a=b.trim().split(" ")),void 0!==a&&a.length>1?(r.shiftColumnMagnetValue=parseFloat(a[0]),r.shiftColumnMagnetUnit=o.normalizeUnits(a[a.length-1])):(r.shiftColumnMagnetValue=1,r.shiftColumnMagnetUnit=o.normalizeUnits(b))}),p.on("keyup keydown",function(a){return r.shiftKey=a.shiftKey,!0}),this.scroll=new d(this),this.body=new e(this),this.header=new g(this),this.side=new h(this),this.objectModel=new i(this.api),this.rowsManager=new j(this),this.columnsManager=new k(this),this.timespansManager=new l(this),this.currentDateManager=new m(this),this.originalWidth=0,this.width=0,angular.isFunction(this.$scope.api)&&this.$scope.api(this.api);var s=function(a,b){if(void 0===b||a.length!==b.length)return!0;for(var c=0,d=a.length;d>c;c++)if(a[c].id!==b[c].id)return!0;return!1};f.$watchCollection("data",function(a,b){if(void 0!==b){var c=n.getRemovedIds(a,b);if(c.length===b.length)r.rowsManager.removeAll(),r.api.data.raise.clear(r.$scope);else{for(var d=0,e=c.length;e>d;d++){var f=c[d];r.rowsManager.removeRow(f)}var g=[];angular.forEach(b,function(a){c.indexOf(a.id)>-1&&g.push(a)}),r.api.data.raise.remove(r.$scope,g)}}if(void 0!==a){var h=s(a,b);h&&r.rowsManager.resetNonModelLists();for(var i=0,j=a.length;j>i;i++){var k=a[i];r.rowsManager.addRow(k,h)}r.api.data.raise.change(r.$scope,a,b),r.api.data.raise.load(r.$scope,a)}})};return r.prototype.getDateByPosition=function(a,b,c){var d=this.columnsManager.getColumnByPosition(a,c);if(void 0!==d){var e,f;if(b)if(this.shiftKey)if(void 0!==this.shiftColumnMagnetValue&&void 0!==this.shiftColumnMagnetUnit)e=this.shiftColumnMagnetValue,f=this.shiftColumnMagnetUnit;else{var g=this.options.value("viewScale");g=g.trim();var h,i,j;g&&(j=g.split(" ")),j&&j.length>1?(h=parseFloat(j[0]),i=o.normalizeUnits(j[j.length-1])):(h=1,i=o.normalizeUnits(g)),e=.25*h,f=i}else e=this.columnMagnetValue,f=this.columnMagnetUnit;return d.getDateByPosition(a-d.left,e,f,this.options.value("timeFramesMagnet"))}return void 0},r.prototype.getBodyAvailableWidth=function(){var a=this.getWidth()-this.side.getWidth(),b=this.scroll.getBordersWidth(),c=a-(void 0!==b?this.scroll.getBordersWidth():0);return c-=1},r.prototype.getPositionByDate=function(a,b){if(void 0===a)return void 0;o.isMoment(o)||(a=o(a));var c=this.columnsManager.getColumnByDate(a,b);return void 0!==c?c.getPositionByDate(a):void 0},r.prototype.loadData=function(a){if(angular.isArray(a)||(a=void 0!==a?[a]:[]),void 0===this.$scope.data)this.$scope.data=a;else for(var b=0,c=a.length;c>b;b++){var d=a[b],e=n.indexOfId(this.$scope.data,d.id);e>-1?this.$scope.data[e]=d:this.$scope.data.push(d)}var f=this.side.getWidth();f>0&&this.options.set("sideWidth",f)},r.prototype.getData=function(){return this.$scope.data},r.prototype.removeData=function(a){if(angular.isArray(a)||(a=void 0!==a?[a]:[]),void 0!==this.$scope.data)for(var b=0,c=a.length;c>b;b++){var d=a[b],e=n.indexOfId(this.$scope.data,d.id);if(e>-1)if(void 0===d.tasks||0===d.tasks.length)this.$scope.data.splice(e,1);else for(var f=this.$scope.data[e],g=0,h=d.tasks.length;h>g;g++){var i=d.tasks[g],j=n.indexOfId(f.tasks,i.id);j>-1&&f.tasks.splice(j,1)}}},r.prototype.clearData=function(){this.$scope.data=void 0},r.prototype.getWidth=function(){return this.$scope.ganttElementWidth},r.prototype.initialized=function(){this.api.core.raise.ready(this.api),this.rendered=!0,this.columnsManager.generateColumns();var a=this,b=function(){var b=a.side.getWidth();b>0&&a.options.set("sideWidth",b),a.api.core.raise.rendered(a.api)};q(b)},r}])}(),function(){"use strict";angular.module("gantt").factory("GanttObjectModel",["ganttUtils","moment",function(a,b){var c=function(a){this.api=a,this.api.registerEvent("tasks","clean"),this.api.registerEvent("rows","clean"),this.api.registerEvent("timespans","clean")};return c.prototype.cleanTask=function(c){void 0===c.id&&(c.id=a.randomUuid()),void 0===c.from||b.isMoment(c.from)||(c.from=b(c.from)),void 0===c.to||b.isMoment(c.to)||(c.to=b(c.to)),this.api.tasks.raise.clean(c)},c.prototype.cleanRow=function(c){void 0===c.id&&(c.id=a.randomUuid()),void 0===c.from||b.isMoment(c.from)||(c.from=b(c.from)),void 0===c.to||b.isMoment(c.to)||(c.to=b(c.to)),this.api.rows.raise.clean(c)
},c.prototype.cleanTimespan=function(c){void 0===c.id&&(c.id=a.randomUuid()),void 0===c.from||b.isMoment(c.from)||(c.from=b(c.from)),void 0===c.to||b.isMoment(c.to)||(c.to=b(c.to)),this.api.timespans.raise.clean(c)},c}])}(),function(){"use strict";angular.module("gantt").factory("GanttRow",["GanttTask","moment","$filter",function(a,b,c){var d=function(a,b){this.rowsManager=a,this.model=b,this.from=void 0,this.to=void 0,this.tasksMap={},this.tasks=[],this.filteredTasks=[],this.visibleTasks=[]};return d.prototype.addTaskImpl=function(a,b){this.tasksMap[a.model.id]=a,this.tasks.push(a),this.filteredTasks.push(a),this.visibleTasks.push(a),b||(void 0===this.model.tasks&&(this.model.tasks=[]),-1===this.model.tasks.indexOf(a.model)&&this.model.tasks.push(a.model))},d.prototype.addTask=function(b,c){var d,e=!1;if(this.rowsManager.gantt.objectModel.cleanTask(b),b.id in this.tasksMap){if(d=this.tasksMap[b.id],d.model===b)return d;d.model=b,e=!0}else d=new a(this,b),this.addTaskImpl(d,c);return this.sortTasks(),this.setFromToByTask(d),c||(e?this.rowsManager.gantt.api.tasks.raise.change(d):this.rowsManager.gantt.api.tasks.raise.add(d)),d},d.prototype.moveTaskToRow=function(a,b){var c=a.row;c.removeTask(a.model.id,b,!0),a.row=this,this.addTaskImpl(a,b),this.sortTasks(),this.setFromToByTask(a),a.updatePosAndSize(),b||this.rowsManager.gantt.api.tasks.raise.rowChange(a,c)},d.prototype.updateVisibleTasks=function(){var a=this.rowsManager.gantt.options.value("filterTask");if(a){"object"==typeof a&&(a={model:a});var b=this.rowsManager.gantt.options.value("filterTaskComparator");"function"==typeof b&&(b=function(a,c){return b(a.model,c.model)}),this.filteredTasks=c("filter")(this.tasks,a,b)}else this.filteredTasks=this.tasks.slice(0);this.visibleTasks=c("ganttTaskLimit")(this.filteredTasks,this.rowsManager.gantt)},d.prototype.updateTasksPosAndSize=function(){for(var a=0,b=this.tasks.length;b>a;a++)this.tasks[a].updatePosAndSize()},d.prototype.removeTask=function(a,b,c){if(a in this.tasksMap){var d,e,f=this.tasksMap[a];for(e=this.tasks.length-1;e>=0;e--)if(d=this.tasks[e],d.model.id===a){this.tasks.splice(e,1),(this.from-d.model.from===0||this.to-d.model.to===0)&&this.setFromTo();break}for(e=this.filteredTasks.length-1;e>=0;e--)if(d=this.filteredTasks[e],d.model.id===a){this.filteredTasks.splice(e,1);break}for(e=this.visibleTasks.length-1;e>=0;e--)if(d=this.visibleTasks[e],d.model.id===a){this.visibleTasks.splice(e,1);break}if(!b){if(delete this.tasksMap[a],void 0!==this.model.tasks){var g=this.model.tasks.indexOf(f.model);g>-1&&this.model.tasks.splice(g,1)}c||this.rowsManager.gantt.api.tasks.raise.remove(f)}return f}},d.prototype.removeAllTasks=function(){this.from=void 0,this.to=void 0,this.tasksMap={},this.tasks=[],this.filteredTasks=[],this.visibleTasks=[]},d.prototype.setFromTo=function(){this.from=void 0,this.to=void 0;for(var a=0,b=this.tasks.length;b>a;a++)this.setFromToByTask(this.tasks[a])},d.prototype.setFromToByTask=function(a){this.setFromToByValues(a.model.from,a.model.to)},d.prototype.setFromToByValues=function(a,c){void 0!==a&&(void 0===this.from?this.from=b(a):a<this.from&&(this.from=b(a))),void 0!==c&&(void 0===this.to?this.to=b(c):c>this.to&&(this.to=b(c)))},d.prototype.sortTasks=function(){this.tasks.sort(function(a,b){return a.left-b.left})},d.prototype.clone=function(){for(var a=new d(this.rowsManager,angular.copy(this)),b=0,c=this.tasks.length;c>b;b++)a.addTask(this.tasks[b].model);return a},d}])}(),function(){"use strict";angular.module("gantt").factory("GanttRowHeader",[function(){var a=function(a){this.gantt=a};return a}])}(),function(){"use strict";angular.module("gantt").factory("GanttRowsManager",["GanttRow","ganttArrays","$filter","$timeout","moment",function(a,b,c,d,e){var f=function(a){var b=this;this.gantt=a,this.rowsMap={},this.rows=[],this.sortedRows=[],this.filteredRows=[],this.customFilteredRows=[],this.visibleRows=[],this.rowsTaskWatchers=[],this._defaultFilterImpl=function(a,b,d){return c("filter")(a,b,d)},this.filterImpl=this._defaultFilterImpl,this.customRowSorters=[],this.customRowFilters=[],this.gantt.$scope.$watchGroup(["filterTask","filterTaskComparator"],function(a,c){a!==c&&b.updateVisibleTasks()}),this.gantt.$scope.$watchGroup(["filterRow","filterRowComparator"],function(a,c){a!==c&&b.updateVisibleRows()}),this.gantt.$scope.$watch("sortMode",function(a,c){a!==c&&b.sortRows()});var e=this.gantt.scroll.isVScrollbarVisible();this.gantt.$scope.$watchGroup(["maxHeight","gantt.rowsManager.visibleRows.length"],function(a,c){a!==c&&d(function(){var a=b.gantt.scroll.isVScrollbarVisible();a!==e&&(e=a,b.gantt.columnsManager.updateColumnsMeta())})}),this.gantt.api.registerMethod("rows","sort",f.prototype.sortRows,this),this.gantt.api.registerMethod("rows","applySort",f.prototype.applySort,this),this.gantt.api.registerMethod("rows","refresh",f.prototype.updateVisibleObjects,this),this.gantt.api.registerMethod("rows","removeRowSorter",f.prototype.removeCustomRowSorter,this),this.gantt.api.registerMethod("rows","addRowSorter",f.prototype.addCustomRowSorter,this),this.gantt.api.registerMethod("rows","removeRowFilter",f.prototype.removeCustomRowFilter,this),this.gantt.api.registerMethod("rows","addRowFilter",f.prototype.addCustomRowFilter,this),this.gantt.api.registerMethod("rows","setFilterImpl",f.prototype.setFilterImpl,this),this.gantt.api.registerEvent("tasks","add"),this.gantt.api.registerEvent("tasks","change"),this.gantt.api.registerEvent("tasks","viewChange"),this.gantt.api.registerEvent("tasks","rowChange"),this.gantt.api.registerEvent("tasks","remove"),this.gantt.api.registerEvent("tasks","filter"),this.gantt.api.registerEvent("rows","add"),this.gantt.api.registerEvent("rows","change"),this.gantt.api.registerEvent("rows","remove"),this.gantt.api.registerEvent("rows","move"),this.gantt.api.registerEvent("rows","filter"),this.updateVisibleObjects()};return f.prototype.resetNonModelLists=function(){this.rows=[],this.sortedRows=[],this.filteredRows=[],this.customFilteredRows=[],this.visibleRows=[]},f.prototype.addRow=function(c,d){var e,f,g,h=!1;if(this.gantt.objectModel.cleanRow(c),c.id in this.rowsMap){if(e=this.rowsMap[c.id],d&&(this.rows.push(e),this.sortedRows.push(e),this.filteredRows.push(e),this.customFilteredRows.push(e),this.visibleRows.push(e)),e.model===c)return;var i=b.getRemovedIds(c.tasks,e.model.tasks);for(f=0,g=i.length;g>f;f++){var j=i[f];e.removeTask(j)}e.model=c,h=!0}else e=new a(this,c),this.rowsMap[c.id]=e,this.rows.push(e),this.sortedRows.push(e),this.filteredRows.push(e),this.customFilteredRows.push(e),this.visibleRows.push(e);if(void 0!==c.tasks&&c.tasks.length>0)for(f=0,g=c.tasks.length;g>f;f++){var k=c.tasks[f];e.addTask(k)}if(h?this.gantt.api.rows.raise.change(e):this.gantt.api.rows.raise.add(e),!h){var l=this.gantt.$scope.$watchCollection(function(){return c.tasks},function(a,c){if(a!==c){var d,f,g=b.getRemovedIds(a,c);for(d=0,f=g.length;f>d;d++){var h=g[d];e.removeTask(h)}if(void 0!==a)for(d=0,f=a.length;f>d;d++){var i=a[d];e.addTask(i)}}});this.rowsTaskWatchers.push(l)}return h},f.prototype.removeRow=function(a){if(a in this.rowsMap){delete this.rowsMap[a];var c,d,e=b.indexOfId(this.rows,a,["model","id"]);if(e>-1){c=this.rows.splice(e,1)[0];var f=this.rowsTaskWatchers.splice(e,1)[0];f()}return b.removeId(this.sortedRows,a,["model","id"]),b.removeId(this.filteredRows,a,["model","id"]),b.removeId(this.customFilteredRows,a,["model","id"]),b.removeId(this.visibleRows,a,["model","id"]),this.gantt.api.rows.raise.remove(c),d}return void 0},f.prototype.removeAll=function(){this.rowsMap={},this.rows=[],this.sortedRows=[],this.filteredRows=[],this.customFilteredRows=[],this.visibleRows=[];for(var a=0,b=this.rowsTaskWatchers.length;b>a;a++){var c=this.rowsTaskWatchers[a];c()}this.rowsTaskWatchers=[]},f.prototype.sortRows=function(){var a=this.gantt.options.value("sortMode");if(void 0!==a){var b=!1;angular.isString(a)&&"-"===a.charAt(0)&&(b=!0,a=a.substr(1));var d=c("orderBy");this.sortedRows=d(this.rows,a,b)}else this.sortedRows=this.rows.slice();this.sortedRows=this.applyCustomRowSorters(this.sortedRows),this.updateVisibleRows()},f.prototype.removeCustomRowSorter=function(a){var b=this.customRowSorters.indexOf(a);b>-1&&this.customRowSorters.splice(b,1)},f.prototype.addCustomRowSorter=function(a){this.customRowSorters.push(a)},f.prototype.applyCustomRowSorters=function(a){return angular.forEach(this.customRowSorters,function(b){a=b(a)}),a},f.prototype.applySort=function(){for(var a=this.gantt.$scope.data;a>0;)a.pop();for(var b=[],c=0,d=this.sortedRows.length;d>c;c++)a.push(this.sortedRows[c].model),b.push(this.sortedRows[c]);this.rows=b},f.prototype.moveRow=function(a,c){var d=this.gantt.options.value("sortMode");void 0!==d&&(this.applySort(),this.gantt.options.set("sortMode",void 0));var e=this.rows.indexOf(c),f=this.rows.indexOf(a);e>-1&&f>-1&&e!==f&&(b.moveToIndex(this.rows,f,e),b.moveToIndex(this.rowsTaskWatchers,f,e),b.moveToIndex(this.gantt.$scope.data,f,e),this.gantt.api.rows.raise.change(a),this.gantt.api.rows.raise.move(a,f,e),this.updateVisibleObjects(),this.sortRows())},f.prototype.updateVisibleObjects=function(){this.updateVisibleRows(),this.updateVisibleTasks()},f.prototype.updateVisibleRows=function(){var a=this.filteredRows,b=this.gantt.options.value("filterRow");if(b){"object"==typeof b&&(b={model:b});var c=this.gantt.options.value("filterRowComparator");if("function"==typeof c){var d=this.gantt;c=function(a,b){return d.options.value("filterRowComparator")(a,b)}}this.filteredRows=this.filterImpl(this.sortedRows,b,c)}else this.filteredRows=this.sortedRows.slice(0);var e=!angular.equals(a,this.filteredRows);this.customFilteredRows=this.applyCustomRowFilters(this.filteredRows),this.visibleRows=this.customFilteredRows,e&&this.gantt.api.rows.raise.filter(this.sortedRows,this.filteredRows)},f.prototype.removeCustomRowFilter=function(a){var b=this.customRowFilters.indexOf(a);b>-1&&this.customRowFilters.splice(b,1)},f.prototype.addCustomRowFilter=function(a){this.customRowFilters.push(a)},f.prototype.applyCustomRowFilters=function(a){return angular.forEach(this.customRowFilters,function(b){a=b(a)}),a},f.prototype.setFilterImpl=function(a){this.filterImpl=a?a:this._defaultFilterImpl},f.prototype.updateVisibleTasks=function(){var a=[],b=[],c=[];angular.forEach(this.rows,function(d){a=a.concat(d.filteredTasks),d.updateVisibleTasks(),b=b.concat(d.filteredTasks),c=c.concat(d.tasks)});var d=!angular.equals(a,b);d&&this.gantt.api.tasks.raise.filter(c,b)},f.prototype.updateTasksPosAndSize=function(){for(var a=0,b=this.rows.length;b>a;a++)this.rows[a].updateTasksPosAndSize()},f.prototype.getExpandedFrom=function(a){a=a?e(a):a;var b=a;return angular.forEach(this.rows,function(a){(void 0===b||b>a.from)&&(b=a.from)}),b&&(!a||a>b)?b:a},f.prototype.getExpandedTo=function(a){a=a?e(a):a;var b=a;angular.forEach(this.rows,function(a){(void 0===b||b<a.to)&&(b=a.to)});var c=this.gantt.options.value("toDate");return b&&(!c||b>c)?b:a},f.prototype.getDefaultFrom=function(){var a;return angular.forEach(this.rows,function(b){(void 0===a||b.from<a)&&(a=b.from)}),a},f.prototype.getDefaultTo=function(){var a;return angular.forEach(this.rows,function(b){(void 0===a||b.to>a)&&(a=b.to)}),a},f}])}(),function(){"use strict";angular.module("gantt").factory("GanttTask",["moment",function(a){var b=function(a,b){this.rowsManager=a.rowsManager,this.row=a,this.model=b,this.truncatedLeft=!1,this.truncatedRight=!1};return b.prototype.isMilestone=function(){return!this.model.to||this.model.from-this.model.to===0},b.prototype.isOutOfRange=function(){var a=this.rowsManager.gantt.columnsManager.getFirstColumn(),b=this.rowsManager.gantt.columnsManager.getLastColumn();return void 0===a||this.model.to<a.date||void 0===b||this.model.from>b.endDate},b.prototype.updatePosAndSize=function(){var b=this.left,c=this.width,d=this.truncatedRight,e=this.truncatedLeft;!this.isMoving&&this.isOutOfRange()?(this.modelLeft=void 0,this.modelWidth=void 0):(this.modelLeft=this.rowsManager.gantt.getPositionByDate(this.model.from),this.modelWidth=this.rowsManager.gantt.getPositionByDate(this.model.to)-this.modelLeft);var f=this.rowsManager.gantt.columnsManager.getLastColumn(),g=f?f.left+f.width:0,h=this.modelLeft,i=this.modelWidth;this.rowsManager.gantt.options.value("daily")&&(h=this.rowsManager.gantt.getPositionByDate(a(this.model.from).startOf("day")),i=this.rowsManager.gantt.getPositionByDate(a(this.model.to).endOf("day"))-h),void 0===h||void 0===i||0>h+i||h>g?(this.left=void 0,this.width=void 0):(this.left=Math.min(Math.max(h,0),this.rowsManager.gantt.width),0>h?(this.truncatedLeft=!0,i+h>this.rowsManager.gantt.width?(this.truncatedRight=!0,this.width=this.rowsManager.gantt.width):(this.truncatedRight=!1,this.width=i+h)):i+h>this.rowsManager.gantt.width?(this.truncatedRight=!0,this.truncatedLeft=!1,this.width=this.rowsManager.gantt.width-h):(this.truncatedLeft=!1,this.truncatedRight=!1,this.width=i),this.width<0&&(this.left=this.left+this.width,this.width=-this.width)),this.updateView(),this.rowsManager.gantt.isRefreshingColumns||b===this.left&&c===this.width&&d===this.truncatedRight&&e===this.truncatedLeft||this.rowsManager.gantt.api.tasks.raise.viewChange(this)},b.prototype.updateView=function(){this.$element&&(void 0===this.left||void 0===this.width?this.$element.css("display","none"):(this.$element.css({left:this.left+"px",width:this.width+"px",display:""}),this.model.priority>0&&this.$element.css("z-index",this.model.priority),this.$element.toggleClass("gantt-task-milestone",this.isMilestone())))},b.prototype.getBackgroundElement=function(){if(void 0!==this.$element){var a=this.$element[0].querySelector(".gantt-task-background");return void 0!==a&&(a=angular.element(a)),a}},b.prototype.getContentElement=function(){if(void 0!==this.$element){var a=this.$element[0].querySelector(".gantt-task-content");return void 0!==a&&(a=angular.element(a)),a}},b.prototype.getForegroundElement=function(){if(void 0!==this.$element){var a=this.$element[0].querySelector(".gantt-task-foreground");return void 0!==a&&(a=angular.element(a)),a}},b.prototype.setFrom=function(a,b){this.model.from=this.rowsManager.gantt.getDateByPosition(a,b),this.row.setFromTo(),this.updatePosAndSize()},b.prototype.setTo=function(a,b){this.model.to=this.rowsManager.gantt.getDateByPosition(a,b),this.row.setFromTo(),this.updatePosAndSize()},b.prototype.moveTo=function(a,b){var c,d;a>this.modelLeft?(this.model.to=this.rowsManager.gantt.getDateByPosition(a+this.modelWidth,b),c=this.rowsManager.gantt.getPositionByDate(this.model.to),d=c-this.modelWidth,this.model.from=this.rowsManager.gantt.getDateByPosition(d,!1)):(this.model.from=this.rowsManager.gantt.getDateByPosition(a,b),d=this.rowsManager.gantt.getPositionByDate(this.model.from),c=d+this.modelWidth,this.model.to=this.rowsManager.gantt.getDateByPosition(c,!1)),this.row.setFromTo(),this.updatePosAndSize()},b.prototype.clone=function(){return new b(this.row,angular.copy(this.model))},b}])}(),function(){"use strict";angular.module("gantt").factory("GanttBody",["GanttBodyColumns","GanttBodyRows","GanttBodyBackground","GanttBodyForeground",function(a,b,c,d){var e=function(e){this.gantt=e,this.background=new c(this),this.foreground=new d(this),this.columns=new a(this),this.rows=new b(this)};return e}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyBackground",[function(){var a=function(a){this.body=a};return a}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyColumns",[function(){var a=function(a){this.body=a};return a}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyForeground",[function(){var a=function(a){this.body=a};return a}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyRows",[function(){var a=function(a){this.body=a};return a}])}(),function(){"use strict";angular.module("gantt").factory("GanttHeader",["GanttHeaderColumns",function(a){var b=function(b){this.gantt=b,this.columns=new a(this),this.getHeight=function(){return this.$element[0].offsetHeight}};return b}])}(),function(){"use strict";angular.module("gantt").factory("GanttHeaderColumns",[function(){var a=function(a){this.$element=a};return a}])}(),function(){"use strict";angular.module("gantt").factory("GanttScroll",[function(){var a=function(b){this.gantt=b,this.gantt.api.registerEvent("scroll","scroll"),this.gantt.api.registerMethod("scroll","to",a.prototype.scrollTo,this),this.gantt.api.registerMethod("scroll","toDate",a.prototype.scrollToDate,this),this.gantt.api.registerMethod("scroll","left",a.prototype.scrollToLeft,this),this.gantt.api.registerMethod("scroll","right",a.prototype.scrollToRight,this),this.gantt.api.registerMethod("scroll","setWidth",a.prototype.setWidth,this)};return a.prototype.getScrollLeft=function(){return void 0===this.$element?void 0:(void 0===this.cachedScrollLeft&&(this.cachedScrollLeft=this.$element[0].scrollLeft),this.cachedScrollLeft)},a.prototype.getScrollWidth=function(){return void 0===this.$element?void 0:this.$element[0].scrollWidth},a.prototype.getWidth=function(){return void 0===this.$element?void 0:this.$element[0].offsetWidth},a.prototype.setWidth=function(a){this.$element[0]&&(this.$element[0].offsetWidth=a)},a.prototype.getBordersWidth=function(){return void 0===this.$element?void 0:this.$element[0].offsetWidth-this.$element[0].clientWidth},a.prototype.getBordersHeight=function(){return void 0===this.$element?void 0:this.$element[0].offsetHeight-this.$element[0].clientHeight},a.prototype.isVScrollbarVisible=function(){return void 0!==this.$element?this.$element[0].scrollHeight>this.$element[0].offsetHeight:void 0},a.prototype.isHScrollbarVisible=function(){return void 0!==this.$element?this.$element[0].scrollWidth>this.$element[0].offsetWidth:void 0},a.prototype.scrollTo=function(a){this.$element[0].scrollLeft=a,this.$element.triggerHandler("scroll")},a.prototype.scrollToLeft=function(a){this.$element[0].scrollLeft-=a,this.$element.triggerHandler("scroll")},a.prototype.scrollToRight=function(a){this.$element[0].scrollLeft+=a,this.$element.triggerHandler("scroll")},a.prototype.scrollToDate=function(a){var b=this.gantt.getPositionByDate(a);void 0!==b&&(this.$element[0].scrollLeft=b-this.$element[0].offsetWidth/2)},a}])}(),function(){"use strict";angular.module("gantt").factory("GanttSide",[function(){var a=function(a){this.gantt=a};return a.prototype.getWidth=function(){if(this.gantt.options.value("showSide")){var a=this.gantt.options.value("sideWidth");if(void 0===a&&void 0!==this.$element&&(void 0!==this.$element.css("width")&&this.$element.css("width",""),a=this.$element[0].offsetWidth),void 0!==a)return a}return 0},a.prototype.show=function(a){void 0!==this.$element&&this.$element.toggleClass("ng-hide",!a)},a.prototype.isShown=function(){return void 0!==this.$element?!this.$element.hasClass("ng-hide"):void 0},a}])}(),function(){"use strict";angular.module("gantt").factory("GanttTimespan",[function(){var a=function(a,b){this.gantt=a,this.model=b};return a.prototype.updatePosAndSize=function(){this.modelLeft=this.gantt.getPositionByDate(this.model.from),this.modelWidth=this.gantt.getPositionByDate(this.model.to)-this.modelLeft;var a=this.gantt.columnsManager.getLastColumn(),b=a?a.left+a.width:0;this.modelLeft+this.modelWidth<0||this.modelLeft>b?(this.left=void 0,this.width=void 0):(this.left=Math.min(Math.max(this.modelLeft,0),this.gantt.width),this.modelLeft<0?(this.truncatedLeft=!0,this.modelWidth+this.modelLeft>this.gantt.width?(this.truncatedRight=!0,this.width=this.gantt.width):(this.truncatedRight=!1,this.width=this.modelWidth+this.modelLeft)):this.modelWidth+this.modelLeft>this.gantt.width?(this.truncatedRight=!0,this.truncatedLeft=!1,this.width=this.gantt.width-this.modelLeft):(this.truncatedLeft=!1,this.truncatedRight=!1,this.width=this.modelWidth),this.width<0&&(this.left=this.left+this.width,this.width=-this.width)),this.updateView()},a.prototype.updateView=function(){this.$element&&(void 0===this.left||void 0===this.width?this.$element.css("display","none"):(this.$element.css("display",""),this.$element.css("left",this.left+"px"),this.$element.css("width",this.width+"px")))},a.prototype.setFrom=function(a){this.from=this.gantt.getDateByPosition(a),this.updatePosAndSize()},a.prototype.setTo=function(a){this.to=this.gantt.getDateByPosition(a),this.updatePosAndSize()},a.prototype.moveTo=function(a){this.from=this.gantt.getDateByPosition(a),this.to=this.gantt.getDateByPosition(a+this.width),this.updatePosAndSize()},a.prototype.clone=function(){return new a(this.gantt,angular.copy(this.model))},a}])}(),function(){"use strict";angular.module("gantt").factory("GanttTimespansManager",["GanttTimespan",function(a){var b=function(a){var b=this;this.gantt=a,this.timespansMap={},this.timespans=[],this.gantt.$scope.$watchCollection("timespans",function(a){b.clearTimespans(),b.loadTimespans(a)}),this.gantt.api.registerMethod("timespans","load",this.loadTimespans,this),this.gantt.api.registerMethod("timespans","remove",this.removeTimespans,this),this.gantt.api.registerMethod("timespans","clear",this.clearTimespans,this),this.gantt.api.registerEvent("timespans","add"),this.gantt.api.registerEvent("timespans","remove"),this.gantt.api.registerEvent("timespans","change")};return b.prototype.loadTimespans=function(a){angular.isArray(a)||(a=void 0!==a?[a]:[]),this.gantt.$scope.timespans=a;for(var b=0,c=a.length;c>b;b++){var d=a[b];this.gantt.objectModel.cleanTimespan(d),this.loadTimespan(d)}},b.prototype.loadTimespan=function(b){var c,d=!1;return b.id in this.timespansMap?(c=this.timespansMap[b.id],c.model=b,d=!0,this.gantt.api.timespans.raise.change(c)):(c=new a(this.gantt,b),this.timespansMap[b.id]=c,this.timespans.push(c),this.gantt.api.timespans.raise.add(c)),c.updatePosAndSize(),d},b.prototype.removeTimespans=function(a){angular.isArray(a)||(a=[a]);for(var b=0,c=a.length;c>b;b++){var d=a[b];this.removeTimespan(d.id)}this.updateVisibleObjects()},b.prototype.removeTimespan=function(a){if(a in this.timespansMap){delete this.timespansMap[a];for(var b,c,d=this.timespans.length-1;d>=0;d--)if(c=this.timespans[d],c.model.id===a){b=c,this.timespans.splice(d,1);break}return this.gantt.api.timespans.raise.remove(b),b}return void 0},b.prototype.clearTimespans=function(){this.timespansMap={},this.timespans=[]},b.prototype.updateTimespansPosAndSize=function(){for(var a=0,b=this.timespans.length;b>a;a++)this.timespans[a].updatePosAndSize()},b}])}(),function(){"use strict";angular.module("gantt").service("ganttArrays",[function(){return{moveToIndex:function(a,b,c){if(c>=a.length)for(var d=c-a.length;d--+1;)a.push(void 0);return a.splice(c,0,a.splice(b,1)[0]),a},getRemovedIds:function(a,b,c){void 0===c&&(c="id");var d,e,f=[];if(void 0!==b)for(d=0,e=b.length;e>d;d++)f.push(b[d][c]);if(void 0!==a)for(d=0,e=a.length;e>d;d++){var g=a[d];if(void 0!==g[c]){var h=f.indexOf(g[c]);h>-1&&f.splice(h,1)}}return f},indexOfId:function(a,b,c){var d;if(void 0===c)c="id";else if(c instanceof Array){for(d=a.length-1;d>=0;d--){for(var e=a[d],f=0,g=c.length;g>f;f++)e=e[c[f]];if(e===b)return d}return-1}for(d=a.length-1;d>=0;d--)if(a[d][c]===b)return d;return-1},removeId:function(a,b,c){var d=this.indexOfId(a,b,c);return d>-1?a.splice(d,1)[0]:void 0},remove:function(a,b){var c=a.indexOf(b);return c>-1?(a.splice(c,1),!0):!1}}}])}(),function(){"use strict";angular.module("gantt").service("ganttBinarySearch",[function(){return{getIndicesOnly:function(a,b,c,d){for(var e=-1,f=a.length;f-e>1;){var g=Math.floor((e+f)/2);(d?c(a[g])<b:c(a[g])<=b)?e=g:f=g}return d||void 0===a[e]||c(a[e])!==b||(f=e),[e,f]},get:function(a,b,c,d){var e=this.getIndicesOnly(a,b,c,d);return[a[e[0]],a[e[1]]]}}}])}(),function(){"use strict";angular.module("gantt").factory("GanttHierarchy",[function(){var a=function(){var a=this,b={},c={},d={},e={},f={},g={},h=function(a,b){if(void 0!==b){var c=d[a.model.name];void 0===c&&(c=[],d[a.model.name]=c),c.push(b);var h=e[a.model.id];void 0===h&&(h=[],e[a.model.id]=h),h.push(b),f[b.model.name]=a,g[b.model.id]=a}};this.refresh=function(i){b={},c={},d={},e={},f={},g={},angular.forEach(i,function(a){b[a.model.name]=a,c[a.model.id]=a}),angular.forEach(i,function(a){if(void 0!==a.model.parent){var d=b[a.model.parent];void 0===d&&(d=c[a.model.parent]),void 0!==d&&h(d,a)}void 0!==a.model.children&&angular.forEach(a.model.children,function(d){var e=b[d];void 0===e&&(e=c[d]),void 0!==e&&h(a,e)})});var j=[];return angular.forEach(i,function(b){void 0===a.parent(b)&&j.push(b)}),j},this.children=function(a){var b=e[a.model.id];return b},this.descendants=function(b){var c=[],d=a.children(b);return c.push.apply(c,d),void 0!==d&&angular.forEach(d,function(b){var d=a.descendants(b);c.push.apply(c,d)}),c},this.parent=function(a){var b=g[a.model.id];return b},this.ancestors=function(b){for(var c=[],d=a.parent(b);void 0!==d;)c.push(d),d=a.parent(d);return c}};return a}])}(),function(){"use strict";angular.module("gantt").service("ganttUtils",[function(){return{createBoundedWrapper:function(a,b){return function(){return b.apply(a,arguments)}},firstProperty:function(a,b,c){for(var d=0,e=a.length;e>d;d++){var f=a[d];if(void 0!==f&&b in f&&void 0!==f[b])return f[b]}return c},random4:function(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)},randomUuid:function(){return this.random4()+this.random4()+"-"+this.random4()+"-"+this.random4()+"-"+this.random4()+"-"+this.random4()+this.random4()+this.random4()},newId:function(){var a=(new Date).getTime();return function(){return a+=1}}()}}])}(),function(){"use strict";angular.module("gantt").filter("ganttColumnLimit",["ganttBinarySearch",function(a){var b=function(a){return a.left};return function(c,d){var e=d.scroll.getScrollLeft(),f=d.getWidth()-d.side.getWidth();if(f>0){var g=a.getIndicesOnly(c,e,b)[0],h=a.getIndicesOnly(c,e+f,b)[1];return c.slice(g,h)}return c.slice()}}])}(),function(){"use strict";angular.module("gantt").filter("ganttTaskLimit",[function(){return function(a,b){var c=b.columnsManager.getFirstColumn(),d=b.columnsManager.getLastColumn();if(void 0!==c&&void 0!==d){for(var e=c.date,f=d.endDate,g=[],h=b.scroll.getScrollLeft(),i=b.getWidth()-b.side.getWidth(),j=0,k=a.length;k>j;j++){var l=a[j];l.active?g.push(l):l.model.to>=e&&l.model.from<=f&&(void 0===l.left&&l.updatePosAndSize(),(!i||l.left>=h&&l.left<=h+i||l.left+l.width>=h&&l.left+l.width<=h+i||l.left<h&&l.left+l.width>h+i)&&g.push(l))}return g}return a.splice()}}])}(),function(){"use strict";angular.module("gantt").directive("ganttResizer",["$document","$parse","$timeout","ganttMouseOffset",function(a,b,c,d){return{restrict:"A",require:"^gantt",scope:{targetElement:"=ganttResizer",enabled:"@?ganttResizerEnabled"},link:function(e,f,g,h){function i(a){a.preventDefault(),m(void 0)}function j(b){b.preventDefault(),void 0!==p&&o[p].raise.resizeBegin(n()),a.on("mousemove",k),a.on("mouseup",l)}function k(a){e.$evalAsync(function(){var b=d.getOffsetForElement(e.targetElement[0],a),c=h.gantt.getWidth()-h.gantt.scroll.getBordersWidth(),f=Math.min(Math.max(b.x,0),c);m(f)})}function l(){void 0!==p&&o[p].raise.resizeEnd(n()),a.unbind("mousemove",k),a.unbind("mouseup",l)}function m(a){a!==n()&&(h.gantt.options.set(g.resizerWidth,a),void 0!==p&&o[p].raise.resize(a),c(function(){h.gantt.columnsManager.updateColumnsMeta()}))}function n(){return h.gantt.options.value(g.resizerWidth)}var o=h.gantt.api,p=g.ganttResizerEventTopic;void 0===e.enabled&&(e.enabled=!0),g.$observe("ganttResizerEnabled",function(a){e.enabled=b(a)()}),e.$watch("enabled",function(a){void 0===a&&(a=!0),f.toggleClass("gantt-resizer-enabled",a),a?(f.on("dblclick",i),f.on("mousedown",j)):(f.off("dblclick",i),f.off("mousedown",j))}),e.$watch(function(){return n()},function(a,b){a!==b&&(e.targetElement.css("width",a+"px"),e.targetElement[0].offsetWidth>0&&m(e.targetElement[0].offsetWidth))}),p&&(o.registerEvent(p,"resize"),o.registerEvent(p,"resizeBegin"),o.registerEvent(p,"resizeEnd"),o.registerMethod(p,"setWidth",m,this),o.registerMethod(p,"getWidth",n,this))}}}])}(),function(){"use strict";angular.module("gantt").directive("ganttHorizontalScrollReceiver",function(){return{restrict:"A",require:"^ganttScrollManager",link:function(a,b,c,d){d.registerHorizontalReceiver(b)}}})}(),function(){"use strict";angular.module("gantt").directive("ganttScrollManager",function(){return{restrict:"A",scope:{},controller:["$scope",function(a){a.horizontal=[],a.vertical=[],this.registerVerticalReceiver=function(b){b.css("position","relative"),a.vertical.push(b[0])},this.registerHorizontalReceiver=function(b){b.css("position","relative"),a.horizontal.push(b[0])},this.getHorizontalRecievers=function(){return a.horizontal},this.getVerticalRecievers=function(){return a.vertical}}]}})}(),function(){"use strict";angular.module("gantt").directive("ganttScrollSender",[function(){return{restrict:"A",require:["^gantt","^ganttScrollManager"],link:function(a,b,c,d){var e=b[0],f=function(){var a,b,c=d[1].getVerticalRecievers();for(a=0,b=c.length;b>a;a++){var f=c[a];f.parentNode.scrollTop!==e.scrollTop&&(f.parentNode.scrollTop=e.scrollTop)}var g=d[1].getHorizontalRecievers();for(a=0,b=g.length;b>a;a++){var h=g[a];h.parentNode.scrollLeft!==e.scrollLeft&&(h.parentNode.scrollLeft=e.scrollLeft)}};b.bind("scroll",f),a.$watch(function(){return d[0].gantt.width},function(a,b){if(a!==b)for(var c=d[1].getHorizontalRecievers(),e=0,f=c.length;f>e;e++){var g=c[e];g.style.width=a+"px"}})}}}])}(),function(){"use strict";angular.module("gantt").directive("ganttScrollable",["GanttDirectiveBuilder","$timeout","ganttDebounce","moment",function(a,b,c,d){var e=new a("ganttScrollable");return e.controller=function(a,e){a.gantt.scroll.$element=e;var f,g,h=500,i=function(c,e,f){var j=a.gantt.options.value("autoExpand");if("both"===j||j===!0||j===f){var k,l,m=a.gantt.options.value("viewScale");m=m.trim(),"s"===m.charAt(m.length-1)&&(m=m.substring(0,m.length-1));var n,o,p;m&&(p=m.split(" ")),p&&p.length>1?(n=parseFloat(p[0]),o=p[p.length-1]):(n=1,o=m),"left"===f?(k=d(e).add(-5*n,o),a.fromDate=k):(l=d(e).add(5*n,o),a.toDate=l),g=Date.now(),a.gantt.api.scroll.raise.scroll(c.scrollLeft,e,f),b(function(){var a,b;0===c.scrollLeft?(a="left",b=k):c.offsetWidth+c.scrollLeft>=c.scrollWidth-1&&(a="right",b=l),a===f&&i(c,b,f)},h)}};e.bind("scroll",c(function(){var b,c,d=e[0],g=d.scrollLeft;a.gantt.scroll.cachedScrollLeft=g,a.gantt.columnsManager.updateVisibleColumns(),a.gantt.rowsManager.updateVisibleTasks(),f>g&&0===g?(b="left",c=a.gantt.columnsManager.from):g>f&&d.offsetWidth+g>=d.scrollWidth-1&&(b="right",c=a.gantt.columnsManager.to),f=g,void 0!==c?i(d,c,b):a.gantt.api.scroll.raise.scroll(g)},5)),a.getScrollableCss=function(){var b={},c=a.gantt.options.value("maxHeight");c>0&&(b["max-height"]=c-a.gantt.header.getHeight()+"px",b["overflow-y"]="auto",a.gantt.scroll.isVScrollbarVisible()&&(b["border-right"]="none"));var d=this.gantt.options.value("columnWidth"),e=0===a.gantt.width?!1:a.gantt.width<a.gantt.getWidth()-a.gantt.side.getWidth();return void 0!==d&&e&&(b.width=a.gantt.width+this.gantt.scroll.getBordersWidth()+"px"),b}},e.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttVerticalScrollReceiver",function(){return{restrict:"A",require:"^ganttScrollManager",link:function(a,b,c,d){d.registerVerticalReceiver(b)}}})}(),function(){"use strict";angular.module("gantt").directive("ganttElementHeightListener",[function(){return{restrict:"A",controller:["$scope","$element","$attrs",function(a,b,c){var d=c.ganttElementHeightListener;""===d&&(d="ganttElementHeight");for(var e=a;0===d.indexOf("$parent.");)d=d.substring("$parent.".length),e=e.$parent;e.$watch(function(){return b[0].offsetHeight},function(a){a>0&&(e[d]=a)})}]}}])}(),function(){"use strict";angular.module("gantt").directive("ganttElementWidthListener",[function(){return{restrict:"A",controller:["$scope","$element","$attrs",function(a,b,c){var d=c.ganttElementWidthListener;""===d&&(d="ganttElementWidth");for(var e=a;0===d.indexOf("$parent.");)d=d.substring("$parent.".length),e=e.$parent;
e.$watch(function(){return b[0].offsetWidth},function(a){a>0&&(e[d]=a)})}]}}])}(),function(){"use strict";angular.module("gantt").directive("ganttBody",["GanttDirectiveBuilder",function(a){var b=new a("ganttBody");return b.controller=function(a,b){a.gantt.body.$element=b,a.gantt.body.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyBackground",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyBackground");return b.controller=function(a,b){a.gantt.body.background.$element=b,a.gantt.body.background.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyColumns",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyColumns");return b.controller=function(a,b){a.gantt.body.columns.$element=b,a.gantt.body.background.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyForeground",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyForeground");return b.controller=function(a,b){a.gantt.body.foreground.$element=b,a.gantt.body.foreground.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyRows",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyRows");return b.controller=function(a,b){a.gantt.body.rows.$element=b,a.gantt.body.rows.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttColumn",["GanttDirectiveBuilder",function(a){var b=new a("ganttColumn");return b.controller=function(a,b){a.column.$element=b,a.column.$scope=a,a.column.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttColumnHeader",["GanttDirectiveBuilder",function(a){var b=new a("ganttColumnHeader");return b.controller=function(a,b){a.column.$element=b,a.column.$scope=a,a.column.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttHeader",["GanttDirectiveBuilder",function(a){var b=new a("ganttHeader");return b.controller=function(a,b){a.gantt.header.$element=b,a.gantt.header.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttHeaderColumns",["GanttDirectiveBuilder",function(a){var b=new a("ganttHeaderColumns");return b.controller=function(a,b){a.gantt.header.columns.$element=b,a.gantt.header.columns.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttRow",["GanttDirectiveBuilder",function(a){var b=new a("ganttRow");return b.controller=function(a,b){a.row.$element=b,a.row.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttRowBackground",["GanttDirectiveBuilder",function(a){var b=new a("ganttRowBackground");return b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttRowLabel",["GanttDirectiveBuilder",function(a){var b=new a("ganttRowLabel");return b.restrict="A",b.templateUrl=void 0,b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttScrollableHeader",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttScrollableHeader");return c.controller=function(a){var c=b.getScrollBarWidth();a.getScrollableHeaderCss=function(){var b={},d=a.gantt.scroll.isVScrollbarVisible(),e=d?c:0,f=this.gantt.options.value("columnWidth"),g=0===a.gantt.width?!1:a.gantt.width<a.gantt.getWidth()-a.gantt.side.getWidth();return void 0!==f&&g?b.width=a.gantt.width-e+this.gantt.scroll.getBordersWidth()+"px":d&&(b.width=a.gantt.getWidth()-a.gantt.side.getWidth()-e+"px"),b}},c.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttSide",["GanttDirectiveBuilder",function(a){var b=new a("ganttSide");return b.controller=function(a,b){a.gantt.side.$element=b,a.gantt.side.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttSideBackground",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttSideBackground");return c.controller=function(a){var c=b.getScrollBarHeight();a.getMaxHeightCss=function(){var b={};if(a.maxHeight){var d=a.gantt.scroll.isHScrollbarVisible()?c:0;b["max-height"]=a.maxHeight-d-a.gantt.header.getHeight()+"px"}return b}},c.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttSideContent",["GanttDirectiveBuilder",function(a){var b=new a("ganttSideContent");return b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTask",["GanttDirectiveBuilder","moment",function(a,b){var c=new a("ganttTask");return c.controller=function(a,c){a.task.$element=c,a.task.$scope=a,a.getTaskContent=function(){return void 0!==a.task.model.content?a.task.model.content:a.task.rowsManager.gantt.options.value("taskContent")},a.simplifyMoment=function(a){return b.isMoment(a)?a.unix():a},a.$watchGroup(["simplifyMoment(task.model.from)","simplifyMoment(task.model.to)"],function(){a.task.updatePosAndSize()})},c.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskBackground",["GanttDirectiveBuilder",function(a){var b=new a("ganttTaskBackground");return b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskContent",["GanttDirectiveBuilder",function(a){var b=new a("ganttTaskContent");return b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskForeground",["GanttDirectiveBuilder",function(a){var b=new a("ganttTaskForeground");return b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTimeFrame",["GanttDirectiveBuilder",function(a){var b=new a("ganttTimeFrame");return b.controller=function(a,b){a.timeFrame.$element=b,a.timeFrame.$scope=a,a.timeFrame.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTimespan",["GanttDirectiveBuilder",function(a){var b=new a("ganttTimespan");return b.controller=function(a,b){a.timespan.$element=b,a.timespan.$scope=a,a.timespan.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").factory("ganttDebounce",["$timeout",function(a){function b(b,c,d){var e=0;return function(){var f=this,g=arguments;e++;var h=function(a){return function(){return a===e?b.apply(f,g):void 0}}(e);return a(h,c,void 0===d?!0:d)}}return b}])}(),function(){"use strict";angular.module("gantt").service("GanttDirectiveBuilder",["$templateCache",function(a){var b=function(b,c,d,e){var f=this;this.directiveName=b,this.templateUrl=void 0===c?"template/"+b+".tmpl.html":c,this.require=void 0===d?"^gantt":d,this.restrict=void 0===e?"E":e,this.scope=!1,this.transclude=!0,this.replace=!0,this.build=function(){var b=f.directiveName,c=f.templateUrl,d=f.controller,e={restrict:f.restrict,require:f.require,transclude:f.transclude,replace:f.replace,scope:f.scope,templateUrl:function(b,d){return void 0!==d.templateUrl&&(c=d.templateUrl),void 0!==d.template&&a.put(c,d.template),c},compile:function(){return{pre:function(a,c,d,e){a.gantt.api.directives.raise.preLink(b,a,c,d,e)},post:function(a,c,d,e){a.gantt.api.directives.raise.postLink(b,a,c,d,e)}}},controller:["$scope","$element","$attrs",function(a,c,e){var f=this;void 0!==d&&d(a,c,e,f),a.gantt.api.directives.raise.controller(b,a,c,e,f),a.$on("$destroy",function(){a.gantt.api.directives.raise.destroy(b,a,c,e,f)}),a.$evalAsync(function(){a.gantt.api.directives.raise["new"](b,a,c,e,f)})}]};return c||(delete e.templateUrl,delete e.replace,delete e.transclude),e}};return b}])}(),function(){"use strict";angular.module("gantt").service("ganttDom",["$document",function(a){return{elementFromPoint:function(b,c){return a[0].elementFromPoint(b,c)},elementsFromPoint:function(a,b,c){for(var d,e,f,g,h=[],i=[],j=0;(d=this.elementFromPoint(a,b))&&-1===h.indexOf(d)&&null!==d&&(void 0===c||c>j);)h.push(d),i.push({value:d.style.getPropertyValue("visibility"),priority:d.style.getPropertyPriority("visibility")}),d.style.setProperty("visibility","hidden","important"),j++;for(e=0,f=i.length;f>e;e++)g=i[e],h[e].style.setProperty("visibility",g.value?g.value:"",g.priority);return h},findElementFromPoint:function(a,b,c){for(var d,e,f,g,h,i=[],j=[],k=0;(d=this.elementFromPoint(a,b))&&-1===i.indexOf(d)&&null!==d;)if(i.push(d),j.push({value:d.style.getPropertyValue("visibility"),priority:d.style.getPropertyPriority("visibility")}),d.style.setProperty("visibility","hidden","important"),k++,c(d)){e=d;break}for(f=0,g=j.length;g>f;f++)h=j[f],i[f].style.setProperty("visibility",h.value?h.value:"",h.priority);return e}}}])}(),function(){"use strict";angular.module("gantt").service("ganttEnableNgAnimate",["$injector",function(a){var b;try{b=a.get("$animate")}catch(c){}return void 0!==b?function(a,c){b.enabled(!1,c)}:function(){}}])}(),function(){"use strict";angular.module("gantt").directive("ganttBindCompileHtml",["$compile",function(a){return{restrict:"A",require:"^gantt",link:function(b,c,d,e){b.scope=e.gantt.$scope.$parent,b.$watch(function(){return b.$eval(d.ganttBindCompileHtml)},function(d){c.html(d),a(c.contents())(b)})}}}])}(),function(){"use strict";angular.module("gantt").service("ganttLayout",["$document",function(a){return{getScrollBarWidth:function(){var b=a[0].createElement("p");b.style.width="100%",b.style.height="200px";var c=a[0].createElement("div");c.style.position="absolute",c.style.top="0px",c.style.left="0px",c.style.visibility="hidden",c.style.width="200px",c.style.height="150px",c.style.overflow="hidden",c.appendChild(b),a[0].body.appendChild(c);var d=b.offsetWidth;c.style.overflow="scroll";var e=b.offsetWidth;return d===e&&(e=c.clientWidth),a[0].body.removeChild(c),d-e},getScrollBarHeight:function(){var b=a[0].createElement("p");b.style.width="200px;",b.style.height="100%";var c=a[0].createElement("div");c.style.position="absolute",c.style.top="0px",c.style.left="0px",c.style.visibility="hidden",c.style.width="150px",c.style.height="200px",c.style.overflow="hidden",c.appendChild(b),a[0].body.appendChild(c);var d=b.offsetHeight;c.style.overflow="scroll";var e=b.offsetHeight;return d===e&&(e=c.clientHeight),a[0].body.removeChild(c),d-e},setColumnsWidthFactor:function(a,b,c){a&&(c||(c=0),angular.forEach(a,function(a){a.left=b*(a.originalSize.left+c)-c,a.width=b*a.originalSize.width,angular.forEach(a.timeFrames,function(a){a.left=b*a.originalSize.left,a.width=b*a.originalSize.width})}))}}}])}(),function(){"use strict";angular.module("gantt").service("ganttMouseButton",[function(){return{getButton:function(a){return a=a||window.event,a.which?a.which:void 0===a.button?1:a.button<2?1:4===a.button?2:3}}}])}(),function(){"use strict";angular.module("gantt").service("ganttMouseOffset",[function(){return{getTouch:function(a){return void 0!==a.touches?a.touches[0]:a},getOffset:function(a){return a.offsetX&&a.offsetY?{x:a.offsetX,y:a.offsetY}:a.layerX&&a.layerY?{x:a.layerX,y:a.layerY}:this.getOffsetForElement(a.target,a)},getOffsetForElement:function(a,b){var c=a.getBoundingClientRect();return{x:b.clientX-c.left,y:b.clientY-c.top}}}}])}(),function(){"use strict";angular.module("gantt").factory("ganttSmartEvent",[function(){function a(a,b,c,d){return a.$on("$destroy",function(){b.unbind(c,d)}),{bindOnce:function(){b.one(c,d)},bind:function(){b.bind(c,d)},unbind:function(){b.unbind(c,d)}}}return a}])}(),angular.module("gantt.templates",[]).run(["$templateCache",function(a){a.put("template/gantt.tmpl.html",'<div class="gantt unselectable" ng-cloak gantt-scroll-manager gantt-element-width-listener="ganttElementWidth">\n    <gantt-side>\n        <gantt-side-background>\n        </gantt-side-background>\n        <gantt-side-content>\n        </gantt-side-content>\n        <div gantt-resizer="gantt.side.$element" gantt-resizer-event-topic="side" gantt-resizer-enabled="{{$parent.gantt.options.value(\'allowSideResizing\')}}" resizer-width="sideWidth" class="gantt-resizer">\n            <div ng-show="$parent.gantt.options.value(\'allowSideResizing\')" class="gantt-resizer-display"></div>\n        </div>\n    </gantt-side>\n    <gantt-scrollable-header>\n        <gantt-header gantt-element-height-listener="$parent.ganttHeaderHeight">\n            <gantt-header-columns>\n                <div ng-repeat="header in gantt.columnsManager.visibleHeaders track by $index">\n                    <div class="gantt-header-row" ng-class="{\'gantt-header-row-last\': $last, \'gantt-header-row-first\': $first}">\n                        <gantt-column-header ng-repeat="column in header"></gantt-column-header>\n                    </div>\n                </div>\n            </gantt-header-columns>\n        </gantt-header>\n    </gantt-scrollable-header>\n    <gantt-scrollable>\n        <gantt-body>\n            <gantt-body-background>\n                <gantt-row-background ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id"></gantt-row-background>\n            </gantt-body-background>\n            <gantt-body-foreground>\n                <div class="gantt-current-date-line" ng-show="currentDate === \'line\' && gantt.currentDateManager.position >= 0 && gantt.currentDateManager.position <= gantt.width" ng-style="{\'left\': gantt.currentDateManager.position + \'px\' }"></div>\n            </gantt-body-foreground>\n            <gantt-body-columns>\n                <gantt-column ng-repeat="column in gantt.columnsManager.visibleColumns">\n                    <gantt-time-frame ng-repeat="timeFrame in column.visibleTimeFrames"></gantt-time-frame>\n                </gantt-column>\n            </gantt-body-columns>\n            <div ng-if="gantt.columnsManager.visibleColumns == 0" style="background-color: #808080"></div>\n            <gantt-body-rows>\n                <gantt-timespan ng-repeat="timespan in gantt.timespansManager.timespans track by timespan.model.id"></gantt-timespan>\n                <gantt-row ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id">\n                    <gantt-task ng-repeat="task in row.visibleTasks track by task.model.id">\n                    </gantt-task>\n                </gantt-row>\n            </gantt-body-rows>\n        </gantt-body>\n    </gantt-scrollable>\n\n    <!-- Plugins -->\n    <ng-transclude></ng-transclude>\n\n    <!--\n    ******* Inline templates *******\n    You can specify your own templates by either changing the default ones below or by\n    adding an attribute template-url="<url to your template>" on the specific element.\n    -->\n\n    <!-- Body template -->\n    <script type="text/ng-template" id="template/ganttBody.tmpl.html">\n        <div ng-transclude class="gantt-body" ng-style="{\'width\': gantt.width > 0 ? gantt.width +\'px\' : undefined}"></div>\n    </script>\n\n    <!-- Header template -->\n    <script type="text/ng-template" id="template/ganttHeader.tmpl.html">\n        <div ng-transclude class="gantt-header"\n             ng-show="gantt.columnsManager.columns.length > 0 && gantt.columnsManager.headers.length > 0"></div>\n    </script>\n\n    <!-- Side template -->\n    <script type="text/ng-template" id="template/ganttSide.tmpl.html">\n        <div ng-transclude class="gantt-side" style="width: auto;"></div>\n    </script>\n\n    <!-- Side content template-->\n    <script type="text/ng-template" id="template/ganttSideContent.tmpl.html">\n        <div class="gantt-side-content">\n        </div>\n    </script>\n\n    <!-- Header columns template -->\n    <script type="text/ng-template" id="template/ganttHeaderColumns.tmpl.html">\n        <div ng-transclude class="gantt-header-columns"\n              gantt-horizontal-scroll-receiver></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttColumnHeader.tmpl.html">\n        <div class="gantt-column-header" ng-class="{\'gantt-column-header-last\': $last, \'gantt-column-header-first\': $first}">{{::column.label}}</div>\n    </script>\n\n    <!-- Body background template -->\n    <script type="text/ng-template" id="template/ganttBodyBackground.tmpl.html">\n        <div ng-transclude class="gantt-body-background"></div>\n    </script>\n\n    <!-- Body foreground template -->\n    <script type="text/ng-template" id="template/ganttBodyForeground.tmpl.html">\n        <div ng-transclude class="gantt-body-foreground"></div>\n    </script>\n\n    <!-- Body columns template -->\n    <script type="text/ng-template" id="template/ganttBodyColumns.tmpl.html">\n        <div ng-transclude class="gantt-body-columns"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttColumn.tmpl.html">\n        <div ng-transclude class="gantt-column gantt-foreground-col" ng-class="{\'gantt-column-last\': $last, \'gantt-column-first\': $first}"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttTimeFrame.tmpl.html">\n        <div class="gantt-timeframe"></div>\n    </script>\n\n    <!-- Scrollable template -->\n    <script type="text/ng-template" id="template/ganttScrollable.tmpl.html">\n        <div ng-transclude class="gantt-scrollable" gantt-scroll-sender ng-style="getScrollableCss()"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttScrollableHeader.tmpl.html">\n        <div ng-transclude class="gantt-scrollable-header" ng-style="getScrollableHeaderCss()"></div>\n    </script>\n\n    <!-- Rows template -->\n    <script type="text/ng-template" id="template/ganttBodyRows.tmpl.html">\n        <div ng-transclude class="gantt-body-rows"></div>\n    </script>\n\n    <!-- Timespan template -->\n    <script type="text/ng-template" id="template/ganttTimespan.tmpl.html">\n        <div class="gantt-timespan" ng-class="timespan.model.classes">\n        </div>\n    </script>\n\n    <!-- Task template -->\n    <script type="text/ng-template" id="template/ganttTask.tmpl.html">\n        <div class="gantt-task" ng-class="task.model.classes">\n            <gantt-task-background></gantt-task-background>\n            <gantt-task-foreground></gantt-task-foreground>\n            <gantt-task-content></gantt-task-content>\n        </div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttTaskBackground.tmpl.html">\n        <div class="gantt-task-background" ng-style="{\'background-color\': task.model.color}"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttTaskForeground.tmpl.html">\n        <div class="gantt-task-foreground">\n            <div ng-if="task.truncatedRight" class="gantt-task-truncated-right">&gt;</div>\n            <div ng-if="task.truncatedLeft" class="gantt-task-truncated-left">&lt;</div>\n        </div>\n    </script>\n\n    <!-- Task content template -->\n    <script type="text/ng-template" id="template/ganttTaskContent.tmpl.html">\n        <div class="gantt-task-content" unselectable="on"><span unselectable="on" gantt-bind-compile-html="getTaskContent()"/></div>\n    </script>\n\n\n    <!-- Row background template -->\n    <script type="text/ng-template" id="template/ganttRowBackground.tmpl.html">\n        <div class="gantt-row gantt-row-height"\n             ng-class="row.model.classes"\n             ng-class-odd="\'gantt-row-odd\'"\n             ng-class-even="\'gantt-row-even\'"\n             ng-style="{\'height\': row.model.height}">\n            <div class="gantt-row-background"\n                 ng-style="{\'background-color\': row.model.color}">\n            </div>\n        </div>\n    </script>\n\n    <!-- Row template -->\n    <script type="text/ng-template" id="template/ganttRow.tmpl.html">\n        <div class="gantt-row gantt-row-height"\n             ng-class="row.model.classes"\n             ng-class-odd="\'gantt-row-odd\'"\n             ng-class-even="\'gantt-row-even\'"\n             ng-style="{\'height\': row.model.height}">\n            <div ng-transclude class="gantt-row-content"></div>\n        </div>\n    </script>\n\n    <!-- Side background template -->\n    <script type="text/ng-template" id="template/ganttSideBackground.tmpl.html">\n        <div class="gantt-side-background">\n            <div class="gantt-side-background-header" ng-style="{height: $parent.ganttHeaderHeight + \'px\'}">\n                <div ng-show="$parent.ganttHeaderHeight" class="gantt-header-row gantt-side-header-row"></div>\n            </div>\n            <div class="gantt-side-background-body" ng-style="getMaxHeightCss()">\n                <div gantt-vertical-scroll-receiver>\n                    <div class="gantt-row gantt-row-height "\n                         ng-class-odd="\'gantt-row-odd\'"\n                         ng-class-even="\'gantt-row-even\'"\n                         ng-class="row.model.classes"\n                         ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id"\n                         ng-style="{\'height\': row.model.height}">\n                        <div gantt-row-label class="gantt-row-label gantt-row-background"\n                             ng-style="{\'background-color\': row.model.color}">\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </script>\n</div>\n')}]);
//# sourceMappingURL=angular-gantt.min.js.map