/*
Project: angular-gantt v1.3.2 - Gantt chart component for AngularJS
Authors: Marco Schweighauser, Rémi Alvergnat
License: MIT
Homepage: https://www.angular-gantt.com
Github: https://github.com/angular-gantt/angular-gantt.git
*/

!function(){"use strict";angular.module("gantt.groups",["gantt","gantt.groups.templates"]).directive("ganttGroups",["ganttUtils","GanttHierarchy","$compile","$document",function(a,b,c,d){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",display:"=?"},link:function(a,e,f,g){function h(){a.hierarchy.refresh(g.gantt.rowsManager.filteredRows)}var i=g.gantt.api;if(a.options&&"object"==typeof a.options.groups)for(var j in a.options.groups)a[j]=a.options.groups[j];void 0===a.enabled&&(a.enabled=!0),void 0===a.display&&(a.display="group"),a.hierarchy=new b,g.gantt.api.registerMethod("groups","refresh",h,this),g.gantt.$scope.$watchCollection("gantt.rowsManager.filteredRows",function(){h()}),i.directives.on.new(a,function(b,e,g){if("ganttRow"===b){var h=e.$new();h.pluginScope=a;var i=d[0].createElement("div");angular.element(i).attr("data-ng-if","pluginScope.enabled");var j=d[0].createElement("gantt-task-group");void 0!==f.templateUrl&&angular.element(j).attr("data-template-url",f.templateUrl),void 0!==f.template&&angular.element(j).attr("data-template",f.template),angular.element(i).append(j),g.append(c(i)(h))}})}}}])}(),function(){"use strict";angular.module("gantt.groups").controller("GanttGroupController",["$scope","GanttTaskGroup","ganttUtils",function(a,b,c){var d=function(){var d=a.row.model.groups;"boolean"==typeof d&&(d={enabled:d}),c.firstProperty([d],"enabled",a.pluginScope.enabled)?(a.display=c.firstProperty([d],"display",a.pluginScope.display),a.taskGroup=new b(a.row,a.pluginScope),a.row.setFromTo(),a.row.setFromToByValues(a.taskGroup.from,a.taskGroup.to)):(a.taskGroup=void 0,a.display=void 0)};a.gantt.api.tasks.on.viewChange(a,function(b){if(void 0!==a.taskGroup)if(a.taskGroup.tasks.indexOf(b)>-1)d(),a.$$phase||a.$root.$$phase||a.$digest();else{var c=a.pluginScope.hierarchy.descendants(a.row);c.indexOf(b.row)>-1&&(d(),a.$$phase||a.$root.$$phase||a.$digest())}});var e=a.pluginScope.$watch("display",d);a.$watchCollection("gantt.rowsManager.filteredRows",d),a.gantt.api.columns.on.refresh(a,d),a.$on("$destroy",e)}])}(),function(){"use strict";angular.module("gantt.groups").directive("ganttTaskGroup",["GanttDirectiveBuilder",function(a){return new a("ganttTaskGroup","plugins/groups/taskGroup.tmpl.html").build()}])}(),function(){"use strict";angular.module("gantt").factory("GanttTaskGroup",["ganttUtils","GanttTask",function(a,b){return function(c,d){var e=this;e.row=c,e.pluginScope=d,e.descendants=e.pluginScope.hierarchy.descendants(e.row),e.tasks=[],e.overviewTasks=[],e.promotedTasks=[],e.showGrouping=!1;var f=e.row.model.groups;"boolean"==typeof f&&(f={enabled:f});for(var g=0;g<e.descendants.length;g++)for(var h=e.descendants[g].tasks,i=0;i<h.length;i++){var j=h[i],k=function(b){var c=b.model.groups;"boolean"==typeof c&&(c={enabled:c});var d=b.row.model.groups;if("boolean"==typeof d&&(d={enabled:d}),a.firstProperty([c,d,f],"enabled",e.pluginScope.enabled))return a.firstProperty([c,d,f],"display",e.pluginScope.display)}(j);if(void 0!==k){e.tasks.push(j);var l=new b(e.row,j.model);"overview"===k?e.overviewTasks.push(l):"promote"===k?e.promotedTasks.push(l):e.showGrouping=!0}}if(e.from=void 0,f&&(e.from=f.from),void 0===e.from)for(g=0;g<e.tasks.length;g++)(void 0===e.from||e.tasks[g].model.from<e.from)&&(e.from=e.tasks[g].model.from);if(e.to=void 0,f&&(e.to=f.to),void 0===e.to)for(g=0;g<e.tasks.length;g++)(void 0===e.to||e.tasks[g].model.to>e.to)&&(e.to=e.tasks[g].model.to);e.showGrouping&&(e.left=c.rowsManager.gantt.getPositionByDate(e.from),e.width=c.rowsManager.gantt.getPositionByDate(e.to)-e.left)}}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskOverview",["GanttDirectiveBuilder",function(a){var b=new a("ganttTaskOverview","plugins/groups/taskOverview.tmpl.html");return b.controller=function(a,b){a.task.$element=b,a.task.$scope=a,a.task.updatePosAndSize()},b.build()}])}(),angular.module("gantt.groups.templates",[]).run(["$templateCache",function(a){a.put("plugins/groups/taskGroup.tmpl.html",'<div ng-controller="GanttGroupController">\n    <div class="gantt-task-group-overview" ng-if="taskGroup.overviewTasks.length > 0">\n        <gantt-task-overview ng-repeat="task in taskGroup.overviewTasks"></gantt-task-overview>\n    </div>\n    <div class="gantt-task-group-promote" ng-if="taskGroup.row._collapsed && taskGroup.promotedTasks.length > 0">\n        <gantt-task ng-repeat="task in taskGroup.promotedTasks"></gantt-task>\n    </div>\n    <div class="gantt-task-group"\n         ng-if="taskGroup.showGrouping"\n         ng-style="{\'left\': taskGroup.left + \'px\', \'width\': taskGroup.width + \'px\'}">\n        <div class="gantt-task-group-left-main"></div>\n        <div class="gantt-task-group-right-main"></div>\n        <div class="gantt-task-group-left-symbol"></div>\n        <div class="gantt-task-group-right-symbol"></div>\n    </div>\n</div>\n\n'),a.put("plugins/groups/taskOverview.tmpl.html",'<div class="gantt-task gantt-task-overview" ng-class="task.model.classes">\n    <gantt-task-background></gantt-task-background>\n    <gantt-task-content></gantt-task-content>\n    <gantt-task-foreground></gantt-task-foreground>\n</div>\n\n')}]);
//# sourceMappingURL=angular-gantt-groups-plugin.min.js.map