/*
Project: angular-gantt v1.3.2 - Gantt chart component for AngularJS
Authors: Marco Schweighauser, Rémi Alvergnat
License: MIT
Homepage: https://www.angular-gantt.com
Github: https://github.com/angular-gantt/angular-gantt.git
*/

!function(){"use strict";angular.module("gantt.table",["gantt","gantt.table.templates"]).directive("ganttTable",["ganttUtils","$compile","$document",function(a,b,c){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",columns:"=?",headers:"=?",classes:"=?",contents:"=?",headerContents:"=?",formatters:"=?",headerFormatter:"=?"},link:function(a,d,e,f){var g=f.gantt.api;if(a.options&&"object"==typeof a.options.table)for(var h in a.options.table)a[h]=a.options.table[h];void 0===a.enabled&&(a.enabled=!0),void 0===a.columns&&(a.columns=["model.name"]),void 0===a.headers&&(a.headers={"model.name":"Name"}),void 0===a.contents&&(a.contents={}),void 0===a.headerContents&&(a.headerContents={}),void 0===a.classes&&(a.classes={}),void 0===a.formatters&&(a.formatters={}),g.directives.on.new(a,function(d,e,f){if("ganttSideContent"===d){var g=e.$new();g.pluginScope=a;var h=c[0].createElement("div");angular.element(h).attr("data-ng-if","pluginScope.enabled"),angular.element(h).addClass("side-element");var i=c[0].createElement("gantt-side-content-table");angular.element(h).append(i),f.append(b(h)(g))}})}}}])}(),function(){"use strict";angular.module("gantt.table").directive("ganttSideContentTable",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttSideContentTable","plugins/table/sideContentTable.tmpl.html");return c.controller=function(a){var c=b.getScrollBarHeight();a.getMaxHeightCss=function(){var b={},d=a.maxHeight;d||(d=a.gantt.getContainerHeight());var e=a.gantt.scroll.isHScrollbarVisible()?c:0;return b["max-height"]=d-e-a.gantt.header.getHeight()+"px",b}},c.build()}])}(),function(){"use strict";angular.module("gantt.table").controller("TableColumnController",["$scope",function(a){a.getHeader=function(){var b=a.pluginScope.headers[a.column];return void 0!==b?b:(void 0!==a.pluginScope.headerFormatter&&(b=a.pluginScope.headerFormatter(a.column)),b)},a.getHeaderContent=function(){var b=a.pluginScope.headerContents[a.column];return void 0===b?"{{getHeader()}}":b},a.getClass=function(){return a.pluginScope.classes[a.column]}}])}(),function(){"use strict";angular.module("gantt.table").controller("TableColumnRowController",["$scope",function(a){a.getValue=function(){var b=a.$eval(a.column,a.row),c=a.pluginScope.formatters[a.column];return void 0!==c&&(b=c(b,a.column,a.row)),b},a.getRowContent=function(){var b;return a.row.model.columnContents&&(b=a.row.model.columnContents[a.column]),void 0===b&&"model.name"===a.column&&(b=a.row.model.content),void 0===b&&(b=a.pluginScope.contents[a.column]),void 0===b&&"model.name"===a.column&&(b=a.row.rowsManager.gantt.options.value("rowContent")),void 0===b&&void 0!==a.pluginScope.content&&(b=a.pluginScope.content),void 0===b?"{{getValue()}}":b}}])}(),angular.module("gantt.table.templates",[]).run(["$templateCache",function(a){a.put("plugins/table/sideContentTable.tmpl.html",'<div class="gantt-side-content-table">\n\n    <div class="gantt-table-column {{getClass()}}" ng-repeat="column in pluginScope.columns" ng-controller="TableColumnController">\n\n        <div class="gantt-table-header" ng-style="{height: ganttHeaderHeight + \'px\'}">\n            <div ng-show="ganttHeaderHeight" class="gantt-row-label-header gantt-row-label gantt-table-row gantt-table-header-row">\n                <span class="gantt-label-text" gantt-bind-compile-html="getHeaderContent()"/>\n            </div>\n        </div>\n\n        <div class="gantt-table-content" ng-style="getMaxHeightCss()">\n            <div gantt-vertical-scroll-receiver>\n                <div class="gantt-table-row" ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id" ng-controller="TableColumnRowController">\n                    <div gantt-row-label class="gantt-row-label gantt-row-height" ng-class="row.model.classes" ng-style="{\'height\': row.model.height}">\n                        <div class="gantt-valign-container">\n                            <div class="gantt-valign-content">\n                                <span class="gantt-label-text" gantt-bind-compile-html="getRowContent()"></span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n    </div>\n</div>\n')}]);
//# sourceMappingURL=angular-gantt-table-plugin.min.js.map