/*
Project: angular-gantt v1.3.2 - Gantt chart component for AngularJS
Authors: Marco Schweighauser, Rémi Alvergnat
License: MIT
Homepage: https://www.angular-gantt.com
Github: https://github.com/angular-gantt/angular-gantt.git
*/

!function(){"use strict";angular.module("gantt.tree",["gantt","gantt.tree.templates","ui.tree"]).directive("ganttTree",["ganttUtils","$compile","$document",function(a,b,c){return{restrict:"E",require:"^gantt",scope:{enabled:"=?",header:"=?",content:"=?",headerContent:"=?",keepAncestorOnFilterRow:"=?"},link:function(a,d,e,f){var g=f.gantt.api;if(a.options&&"object"==typeof a.options.tree)for(var h in a.options.tree)a[h]=a.options.tree[h];void 0===a.enabled&&(a.enabled=!0),void 0===a.header&&(a.header="Name"),void 0===a.headerContent&&(a.headerContent="{{getHeader()}}"),void 0===a.keepAncestorOnFilterRow&&(a.keepAncestorOnFilterRow=!1),g.directives.on.new(a,function(d,e,f){if("ganttSideContent"===d){var g=e.$new();g.pluginScope=a;var h=c[0].createElement("div");angular.element(h).attr("data-ng-if","pluginScope.enabled"),angular.element(h).addClass("side-element");var i=c[0].createElement("gantt-side-content-tree");angular.element(h).append(i),f.append(b(h)(g))}})}}}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttRowTreeLabel",["GanttDirectiveBuilder",function(a){var b=new a("ganttRowTreeLabel");return b.restrict="A",b.templateUrl=void 0,b.build()}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttSideContentTree",["GanttDirectiveBuilder",function(a){return new a("ganttSideContentTree","plugins/tree/sideContentTree.tmpl.html").build()}])}(),function(){"use strict";angular.module("gantt.tree").controller("GanttTreeController",["$scope","$filter","GanttHierarchy",function(a,b,c){a.rootRows=[],a.getHeader=function(){return a.pluginScope.header};var d=new c;a.pluginScope.$watchGroup(["keepAncestorOnFilterRow","enabled"],function(c){if(c[0]&&c[1]){var e=function(a,c,e){d.refresh(a);for(var f=[],g=0;g<a.length;g++){var h=d.children(a[g]);h&&0!==h.length||f.push(a[g])}var i=b("filter")(f,c,e),j=function(a){if(i.indexOf(a)>-1)return!0;for(var b=d.descendants(a),c=0;c<b.length;c++)if(i.indexOf(b[c])>-1)return!0;return!1};return b("filter")(a,j,e)};a.gantt.rowsManager.setFilterImpl(e)}else a.gantt.rowsManager.setFilterImpl(!1)});var e=function(b){for(var c=a.parent(b);void 0!==c;){if(void 0!==c&&c._collapsed)return!1;c=a.parent(c)}return!0},f=function(a){return a.filter(function(a){return e(a)})},g=function(b){for(var c=[],d=[],e=0;e<b.length;e++){void 0===a.parent(b[e])?d.push(b[e]):!0}var f=function(d){c.push(d);var e=a.children(d);if(void 0!==e&&e.length>0)for(var g=e.sort(function(a,c){return b.indexOf(a)-b.indexOf(c)}),h=0;h<g.length;h++)f(g[h])};for(e=0;e<d.length;e++)f(d[e]);return c};a.gantt.api.rows.addRowSorter(g),a.gantt.api.rows.addRowFilter(f),a.$on("$destroy",function(){a.gantt.api.rows.removeRowSorter(g),a.gantt.api.rows.removeRowFilter(f)});var h=function(){a.rootRows=d.refresh(a.gantt.rowsManager.filteredRows),a.gantt.rowsManager.filteredRows.length>0&&(a.gantt.api.rows.sort(),a.gantt.api.rows.refresh())};a.gantt.api.rows.on.remove(a,h),a.gantt.api.rows.on.add(a,h);var i=function(b){var c;if(void 0!==(c="string"==typeof b?a.gantt.rowsManager.rowsMap[b]:b))return void 0!==c._collapsed&&c._collapsed},j=function(b){var c;if(void 0!==(c="string"==typeof b?a.gantt.rowsManager.rowsMap[b]:b)){var d=a.nodeScopes[c.model.id];d.collapsed&&d.toggle()}},k=function(b){var c;if(void 0!==(c="string"==typeof b?a.gantt.rowsManager.rowsMap[b]:b)){var d=a.nodeScopes[c.model.id];d.collapsed||d.toggle()}},l=function(){return d};a.getHeaderContent=function(){return a.pluginScope.headerContent},a.gantt.api.registerMethod("tree","refresh",h,this),a.gantt.api.registerMethod("tree","isCollapsed",i,this),a.gantt.api.registerMethod("tree","expand",j,this),a.gantt.api.registerMethod("tree","collapse",k,this),a.gantt.api.registerEvent("tree","collapsed"),a.gantt.api.registerMethod("tree","getHierarchy",l,this),a.$watchCollection("gantt.rowsManager.filteredRows",function(){h()}),a.children=function(b){return void 0===b?a.rootRows:d.children(b)},a.parent=function(a){return d.parent(a)},a.nodeScopes={}}]).controller("GanttUiTreeController",["$scope",function(a){var b=function(){a.$broadcast("angular-ui-tree:collapse-all")},c=function(){a.$broadcast("angular-ui-tree:expand-all")};a.gantt.api.registerMethod("tree","collapseAll",b,a),a.gantt.api.registerMethod("tree","expandAll",c,a)}]).controller("GanttTreeNodeController",["$scope",function(a){a.$parent.nodeScopes[a.row.model.id]=a,a.$on("$destroy",function(){delete a.$parent.nodeScopes[a.row.model.id]}),a.$watch("children(row)",function(b){if(b){for(var c=a.row.rowsManager.filteredRows,d=[],e=0;e<b.length;e++){var f=b[e];c.indexOf(f)>-1&&d.push(f)}a.$parent.childrenRows=d}else a.$parent.childrenRows=b}),a.isCollapseDisabled=function(){return!a.$parent.childrenRows||0===a.$parent.childrenRows.length},a.getValue=function(){return a.row.model.name},a.getRowContent=function(){if(void 0!==a.row.model.content)return a.row.model.content;if(void 0!==a.pluginScope.content)return a.pluginScope.content;var b=a.row.rowsManager.gantt.options.value("rowContent");return void 0===b&&(b="{{row.model.name}}"),b},a.$watch("collapsed",function(b){if(a.$modelValue._collapsed!==b){var c=a.$modelValue._collapsed;a.$modelValue._collapsed=b,void 0!==c&&b!==c&&(a.gantt.api.tree.raise.collapsed(a,a.$modelValue,b),a.gantt.api.rows.refresh())}})}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttTreeBody",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttTreeBody","plugins/tree/treeBody.tmpl.html");return c.controller=function(a){var c=b.getScrollBarHeight();a.getLabelsCss=function(){var b={},d=a.maxHeight;d||(d=a.gantt.getContainerHeight());var e=a.gantt.scroll.isHScrollbarVisible()?c:0;return b["max-height"]=d-e-a.gantt.header.getHeight()+"px",b}},c.build()}])}(),function(){"use strict";angular.module("gantt.tree").directive("ganttTreeHeader",["GanttDirectiveBuilder",function(a){return new a("ganttTreeHeader","plugins/tree/treeHeader.tmpl.html").build()}])}(),angular.module("gantt.tree.templates",[]).run(["$templateCache",function(a){a.put("plugins/tree/sideContentTree.tmpl.html",'<div class="gantt-side-content-tree" ng-controller="GanttTreeController">\n    <gantt-tree-header>\n    </gantt-tree-header>\n    <gantt-tree-body>\n    </gantt-tree-body>\n</div>\n'),a.put("plugins/tree/treeBody.tmpl.html",'<div class="gantt-tree-body" ng-style="getLabelsCss()">\n    <div gantt-vertical-scroll-receiver>\n        <div class="gantt-row-label-background">\n            <div class="gantt-row-label gantt-row-height"\n                 ng-class="row.model.classes"\n                 ng-style="{\'height\': row.model.height}"\n                 ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id">\n                &nbsp;\n            </div>\n        </div>\n        <div ui-tree ng-controller="GanttUiTreeController" data-drag-enabled="false" data-empty-place-holder-enabled="false">\n            <ol class="gantt-tree-root" ui-tree-nodes ng-model="rootRows">\n                <li ng-repeat="row in rootRows" ui-tree-node\n                    ng-include="\'plugins/tree/treeBodyChildren.tmpl.html\'">\n                </li>\n            </ol>\n        </div>\n    </div>\n</div>\n'),a.put("plugins/tree/treeBodyChildren.tmpl.html",'<div ng-controller="GanttTreeNodeController"\n     class="gantt-row-label gantt-row-height"\n     ng-class="row.model.classes"\n     ng-style="{\'height\': row.model.height}">\n    <div class="gantt-valign-container">\n        <div class="gantt-valign-content">\n            <a ng-disabled="isCollapseDisabled()" data-nodrag\n               class="gantt-tree-handle-button btn btn-xs"\n               ng-class="{\'gantt-tree-collapsed\': collapsed, \'gantt-tree-expanded\': !collapsed}"\n               ng-click="!isCollapseDisabled() && toggle()"><span\n                class="gantt-tree-handle glyphicon glyphicon-chevron-down"\n                ng-class="{\n                \'glyphicon-chevron-right\': collapsed, \'glyphicon-chevron-down\': !collapsed,\n                \'gantt-tree-collapsed\': collapsed, \'gantt-tree-expanded\': !collapsed}"></span>\n            </a>\n            <span gantt-row-label class="gantt-label-text" gantt-bind-compile-html="getRowContent()"/>\n        </div>\n    </div>\n</div>\n<ol ui-tree-nodes ng-class="{hidden: collapsed}" ng-model="childrenRows">\n    <li ng-repeat="row in childrenRows" ui-tree-node>\n        <div ng-include="\'plugins/tree/treeBodyChildren.tmpl.html\'"></div>\n    </li>\n</ol>\n'),a.put("plugins/tree/treeHeader.tmpl.html",'<div class="gantt-tree-header" ng-style="{height: $parent.ganttHeaderHeight + \'px\'}">\n    <div ng-if="$parent.ganttHeaderHeight" class="gantt-row-label gantt-row-label-header gantt-tree-row gantt-tree-header-row"><span class="gantt-label-text" gantt-bind-compile-html="getHeaderContent()"/></div>\n</div>\n')}]);
//# sourceMappingURL=angular-gantt-tree-plugin.min.js.map