/*
Project: angular-gantt v1.3.2 - Gantt chart component for AngularJS
Authors: Marco Schweighauser, Rémi Alvergnat
License: MIT
Homepage: https://www.angular-gantt.com
Github: https://github.com/angular-gantt/angular-gantt.git
*/

!function(){"use strict";angular.module("gantt",["gantt.templates","angularMoment"]).directive("gantt",["Gantt","ganttEnableNgAnimate","$timeout","$templateCache",function(a,b,c,d){return{restrict:"A",transclude:!0,templateUrl:function(a,b){var c;return c=void 0===b.templateUrl?"template/gantt.tmpl.html":b.templateUrl,void 0!==b.template&&d.put(c,b.template),c},scope:{sortMode:"=?",filterTask:"=?",filterTaskComparator:"=?",filterRow:"=?",filterRowComparator:"=?",viewScale:"=?",columnWidth:"=?",expandToFit:"=?",shrinkToFit:"=?",showSide:"=?",allowSideResizing:"=?",fromDate:"=?",toDate:"=?",currentDateValue:"=?",currentDate:"=?",daily:"=?",autoExpand:"=?",taskOutOfRange:"=?",taskContent:"=?",rowContent:"=?",maxHeight:"=?",sideWidth:"=?",headers:"=?",headersFormats:"=?",headersScales:"=?",timeFrames:"=?",dateFrames:"=?",timeFramesWorkingMode:"=?",timeFramesNonWorkingMode:"=?",timespans:"=?",columnMagnet:"=?",shiftColumnMagnet:"=?",timeFramesMagnet:"=?",data:"=?",api:"=?",options:"=?"},controller:["$scope","$element",function(c,d){for(var e in c.options)c[e]=c.options[e];b(d,!1),c.gantt=new a(c,d),this.gantt=c.gantt}],link:function(a,b){a.gantt.api.directives.raise.new("gantt",a,b),a.$on("$destroy",function(){a.gantt.api.directives.raise.destroy("gantt",a,b)}),c(function(){a.gantt.initialized()})}}}])}(),function(){"use strict";angular.module("gantt").factory("GanttApi",["$q","$rootScope","ganttUtils",function(a,b,c){function d(a,c,d,e){return b.$on(a,function(){var a=Array.prototype.slice.call(arguments);a.splice(0,1),c.apply(e||d.api,a)})}var e=function(a){this.gantt=a,this.listeners=[],this.apiId=c.newId()};return e.prototype.suppressEvents=function(a,b){var c=this,e=angular.isArray(a)?a:[a],f=[];e.forEach(function(a){f=c.listeners.filter(function(b){return a===b.handler})}),f.forEach(function(a){a.dereg()}),b(),f.forEach(function(a){a.dereg=d(a.eventId,a.handler,c.gantt,a._this)})},e.prototype.registerEvent=function(a,c){var e=this;e[a]||(e[a]={});var f=e[a];f.on||(f.on={},f.raise={});var g="event:gantt:"+this.apiId+":"+a+":"+c;f.raise[c]=function(){b.$emit.apply(b,[g].concat(Array.prototype.slice.call(arguments)))},f.on[c]=function(a,b,c){var f=d(g,b,e.gantt,c),h={handler:b,dereg:f,eventId:g,scope:a,_this:c};e.listeners.push(h);var i=function(){h.dereg();var a=e.listeners.indexOf(h);e.listeners.splice(a,1)};return a.$on("$destroy",function(){i()}),i}},e.prototype.registerEventsFromObject=function(a){var b=this,c=[];angular.forEach(a,function(a,b){var d={name:b,events:[]};angular.forEach(a,function(a,b){d.events.push(b)}),c.push(d)}),c.forEach(function(a){a.events.forEach(function(c){b.registerEvent(a.name,c)})})},e.prototype.registerMethod=function(a,b,d,e){this[a]||(this[a]={}),this[a][b]=c.createBoundedWrapper(e||this.gantt,d)},e.prototype.registerMethodsFromObject=function(a,b){var c=this,d=[];angular.forEach(a,function(a,b){var c={name:b,methods:[]};angular.forEach(a,function(a,b){c.methods.push({name:b,fn:a})}),d.push(c)}),d.forEach(function(a){a.methods.forEach(function(d){c.registerMethod(a.name,d.name,d.fn,b)})})},e}])}(),function(){"use strict";angular.module("gantt").factory("GanttOptions",[function(){return function(a,b){this.defaultValues=b,this.values=a,this.defaultValue=function(a){var b=this.defaultValues[a];return angular.isFunction(b)&&(b=b()),b},this.sanitize=function(a,b){if(!b){var c=this.defaultValue(a);if(void 0!==c)return void 0!==b&&"boolean"==typeof c?b:c}return b},this.value=function(a){return this.sanitize(a,this.values[a])},this.set=function(a,b){this.values[a]=b},this.initialize=function(){for(var a in this.values){var b=this.values[a];this.values.hasOwnProperty(a)&&(this.values[a]=this.value(a,b))}return this.values}}}])}(),function(){"use strict";angular.module("gantt").factory("GanttCalendar",["$filter","moment",function(a,b){var c=function(a){void 0===a&&(a={}),this.start=a.start,this.end=a.end,this.working=a.working,this.magnet=void 0===a.magnet||a.magnet,this.default=a.default,this.color=a.color,this.classes=a.classes,this.internal=a.internal};c.prototype.updateView=function(){if(this.$element){var a={};void 0!==this.left?a.left=this.left+"px":a.left="",void 0!==this.width?a.width=this.width+"px":a.width="",void 0!==this.color?a["background-color"]=this.color:a["background-color"]="",this.$element.css(a);var b=["gantt-timeframe"+(this.working?"":"-non")+"-working"];this.classes&&(b=b.concat(this.classes));for(var c=0,d=b.length;c<d;c++)this.$element.toggleClass(b[c],!0)}},c.prototype.getDuration=function(){if(void 0!==this.end&&void 0!==this.start)return this.end.diff(this.start,"milliseconds")},c.prototype.clone=function(){return new c(this)};var d=function(a){this.func=a};d.prototype.getTimeFrames=function(a){var b=this.func(a);return b instanceof Array||(b=[b]),b},d.prototype.clone=function(){return new d(this.func)};var e=function(a){this.evaluator=a.evaluator,a.date?(this.start=b(a.date).startOf("day"),this.end=b(a.date).endOf("day")):(this.start=a.start,this.end=a.end),a.targets instanceof Array?this.targets=a.targets:this.targets=[a.targets],this.default=a.default};e.prototype.dateMatch=function(a){return this.evaluator?this.evaluator(a):!(!this.start||!this.end)&&(a>=this.start&&a<=this.end)},e.prototype.clone=function(){return new e(this)};var f=function(){this.timeFrames={},this.timeFrameMappings={},this.dateFrames={}};f.prototype.clear=function(){this.timeFrames={},this.timeFrameMappings={},this.dateFrames={}},f.prototype.registerTimeFrames=function(a){angular.forEach(a,function(a,b){this.timeFrames[b]=new c(a)},this)},f.prototype.removeTimeFrames=function(a){angular.forEach(a,function(a){delete this.timeFrames[a]},this)},f.prototype.clearTimeFrames=function(){this.timeFrames={}},f.prototype.registerTimeFrameMappings=function(a){angular.forEach(a,function(a,b){this.timeFrameMappings[b]=new d(a)},this)},f.prototype.removeTimeFrameMappings=function(a){angular.forEach(a,function(a){delete this.timeFrameMappings[a]},this)},f.prototype.clearTimeFrameMappings=function(){this.timeFrameMappings={}},f.prototype.registerDateFrames=function(a){angular.forEach(a,function(a,b){this.dateFrames[b]=new e(a)},this)},f.prototype.removeDateFrames=function(a){angular.forEach(a,function(a){delete this.dateFrames[a]},this)},f.prototype.clearDateFrames=function(){this.dateFrames={}};var g=function(a,b){var c=[];return angular.forEach(a,function(a){a.dateMatch(b)&&c.push(a)}),0===c.length&&angular.forEach(a,function(a){a.default&&c.push(a)}),c};return f.prototype.getTimeFrames=function(a){for(var c=[],d=g(this.dateFrames,a),e=0;e<d.length;e++)if(void 0!==d[e])for(var f=d[e].targets,h=0;h<f.length;h++){var i=this.timeFrameMappings[f[h]];if(void 0!==i)c.push(i.getTimeFrames());else{var j=this.timeFrames[f[h]];void 0!==j&&c.push(j)}}var k=a.year(),l=a.month(),m=a.date(),n=[];for(0===c.length&&angular.forEach(this.timeFrames,function(a){a.default&&c.push(a)}),e=0;e<c.length;e++){var o=c[e].clone();void 0!==o.start&&(o.start.year(k),o.start.month(l),o.start.date(m)),void 0!==o.end&&(o.end.year(k),o.end.month(l),o.end.date(m),b(o.end).startOf("day")===o.end&&o.end.add(1,"day")),n.push(o)}return n},f.prototype.solve=function(d,e,f){for(var g,h,i,j,k=0;k<d.length;k++){var l=d[k];(void 0===i||i>l.start)&&(i=l.start),(void 0===j||j<l.end)&&(j=l.end),void 0===g&&l.color&&(g=l.color),void 0!==l.classes&&(void 0===h&&(h=[]),h=h.concat(l.classes))}void 0===e&&(e=i),void 0===f&&(f=j);var m=[new c({start:e,end:f,internal:!0})];for(d=a("filter")(d,function(a){return(void 0===a.start||a.start<f)&&(void 0===a.end||a.end>e)}),k=0;k<d.length;k++){var n=d[k];n.start||(n.start=e),n.end||(n.end=f)}var o,p=a("orderBy")(d,function(a){return-a.getDuration()});for(k=0;k<p.length;k++){var q=p[k],r=m.slice();o=0;for(var s=!1,t=!1,u=0;u<m.length;u++){var v=m[u];if(!t){if(q.end||q.start)if(q.end>v.start&&q.start<v.end){var w=v.clone();v.end=b(q.start),w.start=b(q.end),r.splice(o+1,0,q.clone(),w),t=!0,s=!1}else!s&&q.start<v.end?(v.end=b(q.start),r.splice(o+1,0,q.clone()),s=!0):s&&q.end>v.start&&(v.start=b(q.end),s=!1,t=!0);else r.splice(o,0,q),t=!0,s=!1;o++}}m=r}return m=a("filter")(m,function(a){return!a.internal&&(void 0===a.start||a.start<f)&&(void 0===a.end||a.end>e)})},f}])}(),function(){"use strict";angular.module("gantt").factory("GanttCurrentDateManager",["moment",function(a){var b=function(b){var c=this;this.gantt=b,this.date=void 0,this.position=void 0,this.currentDateColumn=void 0,this.gantt.$scope.simplifyMoment=function(b){return a.isMoment(b)?b.unix():b},this.gantt.$scope.$watchGroup(["currentDate","simplifyMoment(currentDateValue)"],function(a,b){a!==b&&c.setCurrentDate(c.gantt.options.value("currentDateValue"))})};return b.prototype.setCurrentDate=function(a){this.date=a;var b,c=this.currentDateColumn;void 0!==this.date&&"column"===this.gantt.options.value("currentDate")&&(b=this.gantt.columnsManager.getColumnByDate(this.date,!0)),this.currentDateColumn=b,c!==b&&(void 0!==c&&(c.currentDate=!1,c.updateView()),void 0!==b&&(b.currentDate=!0,b.updateView())),this.position=this.gantt.getPositionByDate(this.date,!0)},b}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumn",["moment",function(a){var b=function(a,b,c,d,e,f,g){this.date=a,this.endDate=b,this.left=c,this.width=d,this.calendar=e,this.duration=this.endDate.diff(this.date,"milliseconds"),this.timeFramesWorkingMode=f,this.timeFramesNonWorkingMode=g,this.timeFrames=[],this.currentDate=!1,this.visibleTimeFrames=[],this.daysTimeFrames={},this.cropped=!1,this.originalSize={left:this.left,width:this.width},this.updateTimeFrames()},c=function(a){return a.year()+"-"+a.month()+"-"+a.date()};return b.prototype.updateView=function(){if(this.$element){this.currentDate?this.$element.addClass("gantt-foreground-col-current-date"):this.$element.removeClass("gantt-foreground-col-current-date"),this.$element.css({left:this.left+"px",width:this.width+"px"});for(var a=0,b=this.timeFrames.length;a<b;a++)this.timeFrames[a].updateView()}},b.prototype.updateTimeFrames=function(){var b=this;if(void 0!==b.calendar&&("hidden"!==b.timeFramesNonWorkingMode||"hidden"!==b.timeFramesWorkingMode)){for(var d,e=b.date,f=a(e).startOf("day"),g=f.add(1,"day");e<b.endDate;){var h=b.calendar.getTimeFrames(e),i=a.min(g,b.endDate);h=b.calendar.solve(h,e,i);var j=[];for(d=0;d<h.length;d++){var k=h[d],l=k.start;void 0===l&&(l=e);var m=k.end;void 0===m&&(m=i),l<b.date&&(l=b.date),m>b.endDate&&(m=b.endDate),k=k.clone(),k.start=a(l),k.end=a(m),j.push(k)}b.timeFrames=b.timeFrames.concat(j);var n=c(e);b.daysTimeFrames[n]=j,e=i,f=a(e).startOf("day"),g=f.add(1,"day")}for(d=0;d<b.timeFrames.length;d++){var o=b.timeFrames[d],p=o.start.diff(b.date,"milliseconds"),q=p/b.duration*b.width,r=o.end.diff(o.start,"milliseconds"),s=r/b.duration*b.width,t=!1;o.working&&"visible"!==b.timeFramesWorkingMode?t=!0:o.working||"visible"===b.timeFramesNonWorkingMode||(t=!0),t||b.visibleTimeFrames.push(o),o.hidden=t,o.left=q,o.width=s,o.originalSize={left:o.left,width:o.width}}if("cropped"===b.timeFramesNonWorkingMode||"cropped"===b.timeFramesWorkingMode){for(var u=0,v=0;v<b.timeFrames.length;v++){var w=b.timeFrames[v];(!w.working&&"cropped"!==b.timeFramesNonWorkingMode||w.working&&"cropped"!==b.timeFramesWorkingMode)&&(u+=w.width)}if(u!==b.width){var x=b.width/u,y=0,z=0,A=!0;for(v=0;v<b.timeFrames.length;v++){var B=b.timeFrames[v];!B.working&&"cropped"!==b.timeFramesNonWorkingMode||B.working&&"cropped"!==b.timeFramesWorkingMode?(B.left=(B.left-y)*x,B.width=B.width*x,B.originalSize.left=(B.originalSize.left-z)*x,B.originalSize.width=B.originalSize.width*x,B.cropped=!1,A=!1):(y+=B.width,z+=B.originalSize.width,B.left=void 0,B.width=0,B.originalSize={left:void 0,width:0},B.cropped=!0)}b.cropped=A}else b.cropped=!1}}},b.prototype.clone=function(){return new b(a(this.date),a(this.endDate),this.left,this.width,this.calendar)},b.prototype.containsDate=function(a){return a>this.date&&a<=this.endDate},b.prototype.equals=function(a){return this.date===a.date},b.prototype.roundTo=function(a,b,c,d){"day"===b&&(b="date"),c=c||1;var e=a.get(b);switch(d){case"up":e=Math.ceil(e/c);break;case"down":e=Math.floor(e/c);break;default:e=Math.round(e/c)}var f=["millisecond","second","minute","hour","date","month","year"];a.set(b,e*c);for(var g=f.indexOf(b),h=0;h<g;h++)a.set(f[h],0);return a},b.prototype.getMagnetDate=function(b,c,d,e){if(c>0&&void 0!==d){var f=b;if(b=a(b),"column"===d){var g=this.getPositionByDate(b);b=a(g<this.width/2?this.date:this.endDate)}else b=this.roundTo(b,d,c),b<this.date?b=a(this.date):b>this.endDate&&(b=a(this.endDate));if(e)for(var h,i=Math.abs(f.diff(b,"milliseconds")),j=0;j<this.timeFrames.length;j++){var k=this.timeFrames[j];if(k.magnet){var l,m=this.timeFrames[j-1],n=this.timeFrames[j+1];void 0!==m&&m.working===k.working||(l=Math.abs(f.diff(k.start,"milliseconds")))<i&&(void 0===h||l<h)&&(h=l,b=k.start),void 0!==n&&n.working===k.working||(l=Math.abs(f.diff(k.end,"milliseconds")))<i&&(void 0===h||l<h)&&(h=l,b=k.end)}}}return b},b.prototype.getDateByPositionUsingTimeFrames=function(b){for(var c=0,d=this.timeFrames.length;c<d;c++){var e=this.timeFrames[c];if(!e.cropped&&b>=e.left&&b<=e.left+e.width){var f=e.getDuration()/e.width*(b-e.left);return a(e.start).add(f,"milliseconds")}}},b.prototype.getDateByPosition=function(b,c,d,e){var f,g;return b<0&&(b=0),b>this.width&&(b=this.width),"cropped"!==this.timeFramesNonWorkingMode&&"cropped"!==this.timeFramesWorkingMode||(g=this.getDateByPositionUsingTimeFrames(b)),void 0===g&&(f=this.duration/this.width*b,g=a(this.date).add(f,"milliseconds")),g=this.getMagnetDate(g,c,d,e)},b.prototype.getDayTimeFrame=function(a){var b=this.daysTimeFrames[c(a)];return void 0===b?[]:b},b.prototype.getPositionByDate=function(a){var b,c,d=a;if("cropped"===this.timeFramesNonWorkingMode||"cropped"===this.timeFramesWorkingMode)for(var e=this.getDayTimeFrame(d),f=0;f<e.length;f++){var g=e[f];if(d>=g.start&&d<=g.end){if(!g.cropped)return b=d.diff(g.start,"milliseconds"),c=b/g.getDuration()*g.width,this.left+g.left+c;d=e.length>f+1?e[f+1].start:g.end}}return b=d.diff(this.date,"milliseconds"),c=b/this.duration*this.width,c<0&&(c=0),c>this.width&&(c=this.width),this.left+c},b}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumnBuilder",["GanttColumn",function(a){var b=function(a){this.columnsManager=a};return b.prototype.newColumn=function(b,c,d,e){var f=this.columnsManager.gantt.calendar,g=this.columnsManager.gantt.options.value("timeFramesWorkingMode"),h=this.columnsManager.gantt.options.value("timeFramesNonWorkingMode");return new a(b,c,d,e,f,g,h)},b}])}(),function(){"use strict";angular.module("gantt").service("GanttColumnGenerator",["moment",function(a){var b=function(b,c,d){return a(b).add(c,d).startOf(d)===b},c=function(a){if(["hour","minute","second","millisecond"].indexOf(a)>=0)return 0},d=function(a,b,d){var e=b.get(a),f=d.get(a),g=c(a);void 0!==g&&f!==g&&f<e&&d.set(a,g)};this.generate=function(c,e,f,g,h,i,j,k){if(!f&&!i)throw"to or maximumWidth must be defined";g=g.trim(),"s"===g.charAt(g.length-1)&&(g=g.substring(0,g.length-1));var l,m,n;g&&(n=g.split(" ")),n&&n.length>1?(l=parseFloat(n[0]),m=n[n.length-1]):(l=1,m=g);var o=!1;e=a(e).startOf(m),f&&(o=b(f),f=a(f).startOf(m));var p=0,q=a(e).startOf(m);k&&(q.add(-l,m),p-=h);for(var r=[];;){if(i&&Math.abs(p)>i+h)break;var s=a(q),t=a(s).add(l,m);d(m,s,t);var u=c.newColumn(s,t,j?p+j:p,h);if(u.cropped||(r.push(u),k?p-=h:p+=h),f)if(k){if(o&&q<f||!o&&q<=f)break}else if(o&&q>f||!o&&q>=f)break;k?(q.add(-l,m),d(m,q,s)):(q.add(l,m),d(m,s,q))}return k&&(b(e,l,m)&&r.shift(),r.reverse()),r}}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumnHeader",["moment","GanttColumn",function(a,b){return function(c,d,e,f,g,h,i){c=a(c),d=a(d);var j=new b(c,d,f,g);return j.name=i,j.unit=e,j.label=angular.isFunction(h)?h(j):c.format(h),j}}])}(),function(){"use strict";angular.module("gantt").factory("GanttColumnsManager",["GanttColumnGenerator","GanttColumnBuilder","GanttHeadersGenerator","$filter","$timeout","ganttLayout","ganttBinarySearch","moment",function(a,b,c,d,e,f,g,h){var i=function(a){var c=this;this.gantt=a,this.from=void 0,this.to=void 0,this.columns=[],this.visibleColumns=[],this.previousColumns=[],this.nextColumns=[],this.headers=[],this.visibleHeaders=[],this.scrollAnchor=void 0,this.columnBuilder=new b(this),this.gantt.$scope.$watchGroup(["viewScale","columnWidth","timeFramesWorkingMode","timeFramesNonWorkingMode","fromDate","toDate","autoExpand","taskOutOfRange"],function(a,b){a!==b&&c.gantt.rendered&&c.generateColumns()}),this.gantt.$scope.$watchCollection("headers",function(a,b){a!==b&&c.gantt.rendered&&c.generateColumns()}),this.gantt.$scope.$watchCollection("headersFormats",function(a,b){a!==b&&c.gantt.rendered&&c.generateColumns()}),this.gantt.$scope.$watchGroup(["ganttElementWidth","showSide","sideWidth","maxHeight","daily"],function(a,b){a!==b&&c.gantt.rendered&&c.updateColumnsMeta()}),this.gantt.api.data.on.load(this.gantt.$scope,function(){(void 0===c.from||void 0===c.to||c.from>c.gantt.rowsManager.getDefaultFrom()||c.to<c.gantt.rowsManager.getDefaultTo())&&c.gantt.rendered&&c.generateColumns(),c.gantt.rowsManager.sortRows()}),this.gantt.api.data.on.remove(this.gantt.$scope,function(){c.gantt.rowsManager.sortRows()}),this.gantt.api.registerMethod("columns","clear",this.clearColumns,this),this.gantt.api.registerMethod("columns","generate",this.generateColumns,this),this.gantt.api.registerMethod("columns","refresh",this.updateColumnsMeta,this),this.gantt.api.registerMethod("columns","getColumnsWidth",this.getColumnsWidth,this),this.gantt.api.registerMethod("columns","getColumnsWidthToFit",this.getColumnsWidthToFit,this),this.gantt.api.registerMethod("columns","getDateRange",this.getDateRange,this),this.gantt.api.registerEvent("columns","clear"),this.gantt.api.registerEvent("columns","generate"),this.gantt.api.registerEvent("columns","refresh")};i.prototype.setScrollAnchor=function(){if(this.gantt.scroll.$element&&this.columns.length>0){var a=this.gantt.scroll.$element[0],b=a.scrollLeft+a.offsetWidth/2;this.scrollAnchor=this.gantt.getDateByPosition(b)}},i.prototype.scrollToScrollAnchor=function(){var a=this;this.columns.length>0&&void 0!==this.scrollAnchor&&this.gantt.$scope.$$postDigest(function(){a.gantt.api.scroll.toDate(a.scrollAnchor)})},i.prototype.clearColumns=function(){this.setScrollAnchor(),this.from=void 0,this.to=void 0,this.columns=[],this.visibleColumns=[],this.previousColumns=[],this.nextColumns=[],this.headers=[],this.visibleHeaders=[],this.gantt.api.columns.raise.clear()},i.prototype.generateColumns=function(b,d){return b||(b=this.gantt.options.value("fromDate")),d||(d=this.gantt.options.value("toDate")),!((!b||h.isMoment(b)&&!b.isValid())&&!(b=this.gantt.rowsManager.getDefaultFrom()))&&(!((!d||h.isMoment(d)&&!d.isValid())&&!(d=this.gantt.rowsManager.getDefaultTo()))&&(void 0===b||h.isMoment(b)||(b=h(b)),void 0===d||h.isMoment(d)||(d=h(d)),"expand"===this.gantt.options.value("taskOutOfRange")&&(b=this.gantt.rowsManager.getExpandedFrom(b),d=this.gantt.rowsManager.getExpandedTo(d)),this.setScrollAnchor(),this.from=b,this.to=d,this.columns=a.generate(this.columnBuilder,b,d,this.gantt.options.value("viewScale"),this.getColumnsWidth()),this.headers=c.generate(this),this.previousColumns=[],this.nextColumns=[],this.updateColumnsMeta(),this.scrollToScrollAnchor(),void this.gantt.api.columns.raise.generate(this.columns,this.headers)))},i.prototype.updateColumnsMeta=function(){this.gantt.isRefreshingColumns=!0;var a=this.getLastColumn();this.gantt.originalWidth=void 0!==a?a.originalSize.left+a.originalSize.width:0;var b=this.updateColumnsWidths(this.columns,this.headers,this.previousColumns,this.nextColumns);this.gantt.width=void 0!==a?a.left+a.width:0;var c=this.gantt.options.value("showSide"),d=this.gantt.side.isShown(),e=c!==d;e&&!c&&this.gantt.side.show(!1),this.gantt.rowsManager.updateTasksPosAndSize(),this.gantt.timespansManager.updateTimespansPosAndSize(),this.updateVisibleColumns(b),this.gantt.rowsManager.updateVisibleObjects();var f=this.gantt.options.value("currentDateValue");this.gantt.currentDateManager.setCurrentDate(f),e&&c&&this.gantt.side.show(!0),this.gantt.isRefreshingColumns=!1,this.gantt.api.columns.raise.refresh(this.columns,this.headers)},i.prototype.getLastColumn=function(a){var b=this.columns;return a&&(b=this.nextColumns),b&&b.length>0?b[b.length-1]:void 0},i.prototype.getFirstColumn=function(a){var b=this.columns;return a&&(b=this.previousColumns),b&&b.length>0?b[0]:void 0},i.prototype.getColumnByDate=function(a,b){b||this.expandExtendedColumnsForDate(a);var c=this.previousColumns.concat(this.columns,this.nextColumns),d=g.get(c,a,function(a){return a.date},!0);return void 0===d[0]?d[1]:d[0]},i.prototype.getColumnByPosition=function(a,b){b||this.expandExtendedColumnsForPosition(a);var c=this.previousColumns.concat(this.columns,this.nextColumns),d=g.get(c,a,function(a){return a.left},!0);return void 0===d[0]?d[1]:d[0]},i.prototype.updateColumnsWidths=function(a,b,c,d){var e=this.gantt.options.value("columnWidth"),g=this.gantt.options.value("expandToFit"),h=this.gantt.options.value("shrinkToFit");if(void 0===e||g||h){var i=this.gantt.getBodyAvailableWidth(),j=this.gantt.columnsManager.getLastColumn(!1);if(void 0!==j){var k=j.originalSize.left+j.originalSize.width;if(g&&k<i||h&&k>i||void 0===e){var l=i/k;f.setColumnsWidthFactor(a,l);for(var m=0;m<b.length;m++)f.setColumnsWidthFactor(b[m],l);return c.splice(0,this.previousColumns.length),d.splice(0,this.nextColumns.length),!0}}}return!1},i.prototype.getColumnsWidth=function(){var a=this.gantt.options.value("columnWidth");return void 0===a&&(a=!this.gantt.width||this.gantt.width<=0?20:this.gantt.width/this.columns.length),a},i.prototype.getColumnsWidthToFit=function(){return this.gantt.getBodyAvailableWidth()/this.columns.length},i.prototype.expandExtendedColumnsForPosition=function(b){var c;if(b<0){var d=this.getFirstColumn(),e=d.date,f=this.getFirstColumn(!0);return(!f||f.left>b)&&(c=this.gantt.options.value("viewScale"),this.previousColumns=a.generate(this.columnBuilder,e,void 0,c,this.getColumnsWidth(),-b,0,!0)),!0}if(b>this.gantt.width){var g=this.getLastColumn(),h=g.getDateByPosition(g.width),i=this.getLastColumn(!0);return(!i||i.left+i.width<b)&&(c=this.gantt.options.value("viewScale"),this.nextColumns=a.generate(this.columnBuilder,h,void 0,c,this.getColumnsWidth(),b-this.gantt.width,this.gantt.width,!1)),!0}return!1},i.prototype.expandExtendedColumnsForDate=function(b){var c,d=this.getFirstColumn();d&&(c=d.date);var e,f=this.getLastColumn();f&&(e=f.endDate);var g;if(c&&b<c){var h=this.getFirstColumn(!0);return(!h||h.date>b)&&(g=this.gantt.options.value("viewScale"),this.previousColumns=a.generate(this.columnBuilder,c,b,g,this.getColumnsWidth(),void 0,0,!0)),!0}if(e&&b>=e){var i=this.getLastColumn(!0);return(!i||i.date<e)&&(g=this.gantt.options.value("viewScale"),this.nextColumns=a.generate(this.columnBuilder,e,b,g,this.getColumnsWidth(),void 0,this.gantt.width,!1)),!0}return!1},i.prototype.getActiveHeadersCount=function(){return this.headers.length},i.prototype.updateVisibleColumns=function(a){var b,c=this.gantt.options.value("columnLimitThreshold");if(void 0===c||c>0&&this.columns.length>=c)for(this.visibleColumns=d("ganttColumnLimit")(this.columns,this.gantt),this.visibleHeaders=[],b=0;b<this.headers.length;b++)this.visibleHeaders.push(d("ganttColumnLimit")(this.headers[b],this.gantt));else this.visibleColumns=this.columns,this.visibleHeaders=this.headers;if(a){for(b=0;b<this.visibleColumns.length;b++)this.visibleColumns[b].updateView();for(b=0;b<this.visibleHeaders.length;b++)for(var e=this.visibleHeaders[b],f=0;f<e.length;f++)e[f].updateView()}var g=this.gantt.options.value("currentDateValue");this.gantt.currentDateManager.setCurrentDate(g)};var j={year:"YYYY",quarter:"[Q]Q YYYY",month:"MMMM YYYY",week:"w",day:"D",hour:"H",minute:"H:mm",second:"H:mm:ss",millisecond:"H:mm:ss:SSS"},k={day:"LL",hour:"H",minute:"H:mm",second:"H:mm:ss",millisecond:"H:mm:ss:SSS"},l={year:"YYYY",quarter:"[Q]Q",month:"MMMM"};return i.prototype.getHeaderFormat=function(a){var b,c=this.gantt.options.value("headersFormats");if(void 0!==c&&(b=c[a]),void 0===b){var d=this.gantt.options.value("viewScale");d=d.trim(),"s"===d.charAt(d.length-1)&&(d=d.substring(0,d.length-1));var e,f;d&&(f=d.split(" ")),e=f&&f.length>1?f[f.length-1]:d,["millisecond","second","minute","hour"].indexOf(e)>-1?b=k[a]:["month","quarter","year"].indexOf(e)>-1&&(b=l[a]),void 0===b&&(b=j[a])}return b},i.prototype.getHeaderScale=function(a){var b,c=this.gantt.options.value("headersScales");return void 0!==c&&(b=c[a]),void 0===b&&(b=a),-1===["millisecond","second","minute","hour","day","week","month","quarter","year"].indexOf(b)&&(b="day"),b},i.prototype.getDateRange=function(a){var b,c;return a?this.visibleColumns&&this.visibleColumns.length>0&&(b=this.visibleColumns[0],c=this.visibleColumns[this.visibleColumns.length-1]):(b=this.getFirstColumn(),c=this.getLastColumn()),b&&c?[b.date,c.endDate]:void 0},i}])}(),function(){"use strict";angular.module("gantt").service("GanttHeadersGenerator",["GanttColumnHeader","moment",function(a,b){var c=function(c,d){var e,f,g,h,i=[],j=c.getHeaderScale(d);if(j&&(h=j.split(" ")),h&&h.length>1?(f=parseFloat(h[0]),g=h[h.length-1]):(f=1,g=j),c.columns.length>0)for(var k=c.columns[0],l=b(k.date).startOf(g),m=b(c.columns[c.columns.length-1].endDate);;){var n=k.getPositionByDate(l),o=b.min(b(l).add(f,g),m),p=c.getColumnByDate(o),q=p.getPositionByDate(o),r=q-n;if(r>0){var s=c.getHeaderFormat(d);e=new a(l,o,g,n,r,s,d),i.push(e)}if(o.isSame(m)||o.isAfter(m))break;k=p,l=o}return i};this.generate=function(a){var b=[];if(void 0===a.gantt.options.value("headers")){var d=a.gantt.options.value("viewScale");d=d.trim(),"s"===d.charAt(d.length-1)&&(d=d.substring(0,d.length-1));var e,f;d&&(f=d.split(" ")),e=f&&f.length>1?f[f.length-1]:d,["quarter","month"].indexOf(e)>-1&&b.push("year"),["day","week"].indexOf(e)>-1&&b.push("month"),["day"].indexOf(e)>-1&&b.push("week"),["hour"].indexOf(e)>-1&&b.push("day"),["minute","second","millisecond"].indexOf(e)>-1&&b.push("hour"),["second","millisecond"].indexOf(e)>-1&&b.push("minute"),["millisecond"].indexOf(e)>-1&&b.push("second"),b.push(d)}else b=a.gantt.options.value("headers");for(var g=[],h=0;h<b.length;h++)g.push(c(a,b[h]));return g}}])}(),function(){"use strict";angular.module("gantt").factory("Gantt",["GanttApi","GanttOptions","GanttCalendar","GanttScroll","GanttBody","GanttRowHeader","GanttHeader","GanttSide","GanttObjectModel","GanttRowsManager","GanttColumnsManager","GanttTimespansManager","GanttCurrentDateManager","ganttArrays","moment","$document","$timeout",function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){var r=function(f,q){var r=this;this.$scope=f,this.$element=q,this.options=new b(f,{api:angular.noop,data:[],timespans:[],viewScale:"day",columnMagnet:"15 minutes",timeFramesMagnet:!0,showSide:!0,allowSideResizing:!0,currentDate:"line",currentDateValue:o,autoExpand:"none",taskOutOfRange:"truncate",taskContent:"{{task.model.name}}",rowContent:"{{row.model.name}}",maxHeight:0,timeFrames:[],dateFrames:[],timeFramesWorkingMode:"hidden",timeFramesNonWorkingMode:"visible",taskLimitThreshold:100,columnLimitThreshold:500}),this.api=new a(this),this.api.registerEvent("core","ready"),this.api.registerEvent("core","rendered"),this.api.registerEvent("directives","controller"),this.api.registerEvent("directives","preLink"),this.api.registerEvent("directives","postLink"),this.api.registerEvent("directives","new"),this.api.registerEvent("directives","destroy"),this.api.registerEvent("data","change"),this.api.registerEvent("data","load"),this.api.registerEvent("data","remove"),this.api.registerEvent("data","clear"),this.api.registerMethod("core","getDateByPosition",this.getDateByPosition,this),this.api.registerMethod("core","getPositionByDate",this.getPositionByDate,this),this.api.registerMethod("data","load",this.loadData,this),this.api.registerMethod("data","remove",this.removeData,this),this.api.registerMethod("data","clear",this.clearData,this),this.api.registerMethod("data","get",this.getData,this),this.calendar=new c(this),this.calendar.registerTimeFrames(this.options.value("timeFrames")),this.calendar.registerDateFrames(this.options.value("dateFrames")),this.api.registerMethod("timeframes","registerTimeFrames",this.calendar.registerTimeFrames,this.calendar),this.api.registerMethod("timeframes","clearTimeframes",this.calendar.clearTimeFrames,this.calendar),this.api.registerMethod("timeframes","registerDateFrames",this.calendar.registerDateFrames,this.calendar),this.api.registerMethod("timeframes","clearDateFrames",this.calendar.clearDateFrames,this.calendar),this.api.registerMethod("timeframes","registerTimeFrameMappings",this.calendar.registerTimeFrameMappings,this.calendar),this.api.registerMethod("timeframes","clearTimeFrameMappings",this.calendar.clearTimeFrameMappings,this.calendar),f.$watchGroup(["timeFrames","dateFrames"],function(a,b){if(a!==b){var c=a[0],d=a[1],e=b[0],f=b[1],g=!1;angular.equals(c,e)||(r.calendar.clearTimeFrames(),r.calendar.registerTimeFrames(c),g=!0),angular.equals(d,f)||(r.calendar.clearDateFrames(),r.calendar.registerDateFrames(d),g=!0),g&&r.columnsManager.generateColumns()}}),f.$watch("columnMagnet",function(){var a,b=r.options.value("columnMagnet");b&&(a=b.trim().split(" ")),a&&a.length>1?(r.columnMagnetValue=parseFloat(a[0]),r.columnMagnetUnit=o.normalizeUnits(a[a.length-1])):(r.columnMagnetValue=1,r.columnMagnetUnit=o.normalizeUnits(b))}),f.$watchGroup(["shiftColumnMagnet","viewScale"],function(){var a,b=r.options.value("shiftColumnMagnet");b&&(a=b.trim().split(" ")),void 0!==a&&a.length>1?(r.shiftColumnMagnetValue=parseFloat(a[0]),r.shiftColumnMagnetUnit=o.normalizeUnits(a[a.length-1])):(r.shiftColumnMagnetValue=1,r.shiftColumnMagnetUnit=o.normalizeUnits(b))});var s=function(a){return r.shiftKey=a.shiftKey,!0};p.on("keyup keydown",s),f.$on("$destroy",function(){p.off("keyup keydown",s)}),this.scroll=new d(this),this.body=new e(this),this.header=new g(this),this.side=new h(this),this.objectModel=new i(this.api),this.rowsManager=new j(this),this.columnsManager=new k(this),this.timespansManager=new l(this),this.currentDateManager=new m(this),this.originalWidth=0,this.width=0,angular.isFunction(this.$scope.api)&&this.$scope.api(this.api);var t=function(a,b){if(void 0===b||a.length!==b.length)return!0;for(var c=0,d=a.length;c<d;c++)if(a[c].id!==b[c].id)return!0;return!1};f.$watchCollection("data",function(a,b){if(void 0!==b){var c=n.getRemovedIds(a,b);if(c.length===b.length)r.rowsManager.removeAll(),r.api.data.raise.clear();else{for(var d=0,e=c.length;d<e;d++){var f=c[d];r.rowsManager.removeRow(f)}var g=[];for(d=0,e=b.length;d<e;d++)c.indexOf(b[d].id)>-1&&g.push(b[d]);r.api.data.raise.remove(g)}}if(void 0!==a){var h=t(a,b);h&&r.rowsManager.resetNonModelLists();for(var i=0,j=a.length;i<j;i++){var k=a[i];r.rowsManager.addRow(k,h)}r.api.data.raise.change(a,b),r.api.data.raise.load(a)}})};return r.prototype.getMagnetValueAndUnit=function(){if(this.shiftKey){if(void 0!==this.shiftColumnMagnetValue&&void 0!==this.shiftColumnMagnetUnit)return[this.shiftColumnMagnetValue,this.shiftColumnMagnetUnit];var a=this.options.value("viewScale");a=a.trim();var b,c,d;return a&&(d=a.split(" ")),d&&d.length>1?(b=parseFloat(d[0]),c=o.normalizeUnits(d[d.length-1])):(b=1,c=o.normalizeUnits(a)),[.25*b,c]}return[this.columnMagnetValue,this.columnMagnetUnit]},r.prototype.getMagnetDate=function(a,b){if(void 0!==a){o.isMoment(o)||(a=o(a));var c=this.columnsManager.getColumnByDate(a,b),d=this.getMagnetValueAndUnit(),e=d[0],f=d[1];return c.getMagnetDate(a,e,f,this.options.value("timeFramesMagnet"))}},r.prototype.getDateByPosition=function(a,b,c){var d=this.columnsManager.getColumnByPosition(a,c);if(void 0!==d){var e,f;if(b){var g=this.getMagnetValueAndUnit();e=g[0],f=g[1]}return d.getDateByPosition(a-d.left,e,f,this.options.value("timeFramesMagnet"))}},
r.prototype.getBodyAvailableWidth=function(){var a=this.getWidth()-this.side.getWidth(),b=this.scroll.getBordersWidth(),c=a-(void 0!==b?this.scroll.getBordersWidth():0);return c-=1},r.prototype.getPositionByDate=function(a,b){if(void 0!==a){o.isMoment(o)||(a=o(a));var c=this.columnsManager.getColumnByDate(a,b);return void 0!==c?c.getPositionByDate(a):void 0}},r.prototype.loadData=function(a){if(angular.isArray(a)||(a=void 0!==a?[a]:[]),void 0===this.$scope.data)this.$scope.data=a;else for(var b=0,c=a.length;b<c;b++){var d=a[b],e=n.indexOfId(this.$scope.data,d.id);e>-1?this.$scope.data[e]=d:this.$scope.data.push(d)}var f=this.side.getWidth();f>0&&this.options.set("sideWidth",f)},r.prototype.getData=function(){return this.$scope.data},r.prototype.removeData=function(a){if(angular.isArray(a)||(a=void 0!==a?[a]:[]),void 0!==this.$scope.data)for(var b=0,c=a.length;b<c;b++){var d=a[b],e=n.indexOfId(this.$scope.data,d.id);if(e>-1)if(void 0===d.tasks||0===d.tasks.length)this.$scope.data.splice(e,1);else for(var f=this.$scope.data[e],g=0,h=d.tasks.length;g<h;g++){var i=d.tasks[g],j=n.indexOfId(f.tasks,i.id);j>-1&&f.tasks.splice(j,1)}}},r.prototype.clearData=function(){this.$scope.data=void 0},r.prototype.getWidth=function(){return this.$scope.ganttElementWidth},r.prototype.getHeight=function(){return this.$scope.ganttElementHeight},r.prototype.getContainerWidth=function(){return this.$scope.ganttContainerWidth},r.prototype.getContainerHeight=function(){return this.$scope.ganttContainerHeight},r.prototype.initialized=function(){this.api.core.raise.ready(this.api),this.rendered=!0,this.columnsManager.generateColumns();var a=this;q(function(){var b=a.side.getWidth();b>0&&a.options.set("sideWidth",b),a.api.core.raise.rendered(a.api)})},r}])}(),function(){"use strict";angular.module("gantt").factory("GanttObjectModel",["ganttUtils","moment",function(a,b){var c=function(a){this.api=a,this.api.registerEvent("tasks","clean"),this.api.registerEvent("rows","clean"),this.api.registerEvent("timespans","clean")};return c.prototype.cleanTask=function(c){void 0===c.id&&(c.id=a.randomUuid()),void 0===c.from||b.isMoment(c.from)||(c.from=b(c.from)),void 0===c.to||b.isMoment(c.to)||(c.to=b(c.to)),this.api.tasks.raise.clean(c)},c.prototype.cleanRow=function(c){void 0===c.id&&(c.id=a.randomUuid()),void 0===c.from||b.isMoment(c.from)||(c.from=b(c.from)),void 0===c.to||b.isMoment(c.to)||(c.to=b(c.to)),this.api.rows.raise.clean(c)},c.prototype.cleanTimespan=function(c){void 0===c.id&&(c.id=a.randomUuid()),void 0===c.from||b.isMoment(c.from)||(c.from=b(c.from)),void 0===c.to||b.isMoment(c.to)||(c.to=b(c.to)),this.api.timespans.raise.clean(c)},c}])}(),function(){"use strict";angular.module("gantt").factory("GanttRow",["GanttTask","moment","$filter",function(a,b,c){var d=function(a,b){this.rowsManager=a,this.model=b,this.from=void 0,this.to=void 0,this.tasksMap={},this.tasks=[],this.filteredTasks=[],this.visibleTasks=[]};return d.prototype.addTaskImpl=function(a,b){this.tasksMap[a.model.id]=a,this.tasks.push(a),b||(void 0===this.model.tasks&&(this.model.tasks=[]),-1===this.model.tasks.indexOf(a.model)&&this.model.tasks.push(a.model))},d.prototype.addTask=function(b,c){var d,e=!1;if(this.rowsManager.gantt.objectModel.cleanTask(b),b.id in this.tasksMap){if(d=this.tasksMap[b.id],d.model===b)return d;d.model=b,e=!0}else d=new a(this,b),this.addTaskImpl(d,c);return this.sortTasks(),this.setFromToByTask(d),c||(e?this.rowsManager.gantt.api.tasks.raise.change(d):this.rowsManager.gantt.api.tasks.raise.add(d)),d},d.prototype.moveTaskToRow=function(a,b){this.rowsManager.gantt.api.tasks.raise.beforeViewRowChange(a,this),b||this.rowsManager.gantt.api.tasks.raise.beforeRowChange(a,this);var c=a.row;c.removeTask(a.model.id,b,!0),a.row=this,this.addTaskImpl(a,b),this.sortTasks(),this.setFromToByTask(a),a.updatePosAndSize(),this.updateVisibleTasks(),c.$scope.$digest(),a.row.$scope.$digest(),this.rowsManager.gantt.api.tasks.raise.viewRowChange(a,c),b||this.rowsManager.gantt.api.tasks.raise.rowChange(a,c)},d.prototype.updateVisibleTasks=function(){var a=this.rowsManager.gantt.options.value("filterTask");if(a){"object"==typeof a&&(a={model:a});var b=this.rowsManager.gantt.options.value("filterTaskComparator");"function"==typeof b&&(b=function(a,c){return b(a.model,c.model)}),this.filteredTasks=c("filter")(this.tasks,a,b)}else this.filteredTasks=this.tasks.slice(0);var d=this.rowsManager.gantt.options.value("taskLimitThreshold");void 0===d||d>0&&this.filteredTasks.length>=d?this.visibleTasks=c("ganttTaskLimit")(this.filteredTasks,this.rowsManager.gantt):this.visibleTasks=this.filteredTasks},d.prototype.updateTasksPosAndSize=function(){for(var a=0,b=this.tasks.length;a<b;a++)this.tasks[a].updatePosAndSize()},d.prototype.removeTask=function(a,b,c){if(a in this.tasksMap){var d,e,f=this.tasksMap[a];for(e=this.tasks.length-1;e>=0;e--)if(d=this.tasks[e],d.model.id===a){this.tasks.splice(e,1),this.from-d.model.from!=0&&this.to-d.model.to!=0||this.setFromTo();break}for(e=this.filteredTasks.length-1;e>=0;e--)if(d=this.filteredTasks[e],d.model.id===a){this.filteredTasks.splice(e,1);break}for(e=this.visibleTasks.length-1;e>=0;e--)if(d=this.visibleTasks[e],d.model.id===a){this.visibleTasks.splice(e,1);break}if(!b){if(delete this.tasksMap[a],void 0!==this.model.tasks){var g=this.model.tasks.indexOf(f.model);g>-1&&this.model.tasks.splice(g,1)}c||this.rowsManager.gantt.api.tasks.raise.remove(f)}return f}},d.prototype.removeAllTasks=function(){this.from=void 0,this.to=void 0,this.tasksMap={},this.tasks=[],this.filteredTasks=[],this.visibleTasks=[]},d.prototype.setFromTo=function(){this.from=void 0,this.to=void 0;for(var a=0,b=this.tasks.length;a<b;a++)this.setFromToByTask(this.tasks[a])},d.prototype.setFromToByTask=function(a){this.setFromToByValues(a.model.from,a.model.to)},d.prototype.setFromToByValues=function(a,c){void 0!==a&&(void 0===this.from?this.from=b(a):a<this.from&&(this.from=b(a))),void 0!==c&&(void 0===this.to?this.to=b(c):c>this.to&&(this.to=b(c)))},d.prototype.sortTasks=function(){this.tasks.sort(function(a,b){return a.left-b.left})},d.prototype.clone=function(){for(var a=new d(this.rowsManager,angular.copy(this)),b=0,c=this.tasks.length;b<c;b++)a.addTask(this.tasks[b].model);return a},d}])}(),function(){"use strict";angular.module("gantt").factory("GanttRowHeader",[function(){return function(a){this.gantt=a}}])}(),function(){"use strict";angular.module("gantt").factory("GanttRowsManager",["GanttRow","ganttArrays","$filter","$timeout","moment",function(a,b,c,d,e){var f=function(a){var b=this;this.gantt=a,this.rowsMap={},this.rows=[],this.sortedRows=[],this.filteredRows=[],this.customFilteredRows=[],this.visibleRows=[],this.rowsTaskWatchers=[],this._defaultFilterImpl=function(a,b,d){return c("filter")(a,b,d)},this.filterImpl=this._defaultFilterImpl,this.customRowSorters=[],this.customRowFilters=[],this.gantt.$scope.$watchGroup(["filterTask","filterTaskComparator"],function(a,c){a!==c&&b.updateVisibleTasks()}),this.gantt.$scope.$watchGroup(["filterRow","filterRowComparator"],function(a,c){a!==c&&b.updateVisibleRows()}),this.gantt.$scope.$watch("sortMode",function(a,c){a!==c&&b.sortRows()});var e=this.gantt.scroll.isVScrollbarVisible();this.gantt.$scope.$watchGroup(["maxHeight","gantt.rowsManager.visibleRows.length"],function(a,c){a!==c&&d(function(){var a=b.gantt.scroll.isVScrollbarVisible();a!==e&&(e=a,b.gantt.columnsManager.updateColumnsMeta())})}),this.gantt.api.registerMethod("rows","sort",f.prototype.sortRows,this),this.gantt.api.registerMethod("rows","applySort",f.prototype.applySort,this),this.gantt.api.registerMethod("rows","refresh",f.prototype.updateVisibleObjects,this),this.gantt.api.registerMethod("rows","removeRowSorter",f.prototype.removeCustomRowSorter,this),this.gantt.api.registerMethod("rows","addRowSorter",f.prototype.addCustomRowSorter,this),this.gantt.api.registerMethod("rows","removeRowFilter",f.prototype.removeCustomRowFilter,this),this.gantt.api.registerMethod("rows","addRowFilter",f.prototype.addCustomRowFilter,this),this.gantt.api.registerMethod("rows","setFilterImpl",f.prototype.setFilterImpl,this),this.gantt.api.registerEvent("tasks","add"),this.gantt.api.registerEvent("tasks","change"),this.gantt.api.registerEvent("tasks","viewChange"),this.gantt.api.registerEvent("tasks","beforeRowChange"),this.gantt.api.registerEvent("tasks","beforeViewRowChange"),this.gantt.api.registerEvent("tasks","rowChange"),this.gantt.api.registerEvent("tasks","viewRowChange"),this.gantt.api.registerEvent("tasks","remove"),this.gantt.api.registerEvent("tasks","filter"),this.gantt.api.registerEvent("tasks","displayed"),this.gantt.api.registerEvent("rows","add"),this.gantt.api.registerEvent("rows","change"),this.gantt.api.registerEvent("rows","remove"),this.gantt.api.registerEvent("rows","move"),this.gantt.api.registerEvent("rows","displayed"),this.gantt.api.registerEvent("rows","filter"),this.updateVisibleObjects()};return f.prototype.resetNonModelLists=function(){this.rows=[],this.sortedRows=[],this.filteredRows=[],this.customFilteredRows=[],this.visibleRows=[]},f.prototype.addRow=function(c,d){var e,f,g,h=!1;if(this.gantt.objectModel.cleanRow(c),c.id in this.rowsMap){if(e=this.rowsMap[c.id],d&&(this.rows.push(e),this.sortedRows.push(e),this.filteredRows.push(e),this.customFilteredRows.push(e),this.visibleRows.push(e)),e.model===c)return;var i=b.getRemovedIds(c.tasks,e.model.tasks);for(f=0,g=i.length;f<g;f++){var j=i[f];e.removeTask(j)}e.model=c,h=!0}else e=new a(this,c),this.rowsMap[c.id]=e,this.rows.push(e),this.sortedRows.push(e),this.filteredRows.push(e),this.customFilteredRows.push(e),this.visibleRows.push(e);if(void 0!==c.tasks&&c.tasks.length>0){for(f=0,g=c.tasks.length;f<g;f++){var k=c.tasks[f];e.addTask(k)}e.updateVisibleTasks()}if(h?this.gantt.api.rows.raise.change(e):this.gantt.api.rows.raise.add(e),!h){var l=this.gantt.$scope.$watchCollection(function(){return c.tasks},function(a,c){if(a!==c){var d,f,g=b.getRemovedIds(a,c);for(d=0,f=g.length;d<f;d++){var h=g[d];e.removeTask(h)}if(void 0!==a){for(d=0,f=a.length;d<f;d++){var i=a[d];e.addTask(i)}e.updateVisibleTasks()}}});this.rowsTaskWatchers.push(l)}return h},f.prototype.removeRow=function(a){if(a in this.rowsMap){delete this.rowsMap[a];var c,d=b.indexOfId(this.rows,a,["model","id"]);if(d>-1){c=this.rows.splice(d,1)[0];var e=this.rowsTaskWatchers.splice(d,1)[0];e&&e()}return b.removeId(this.sortedRows,a,["model","id"]),b.removeId(this.filteredRows,a,["model","id"]),b.removeId(this.customFilteredRows,a,["model","id"]),b.removeId(this.visibleRows,a,["model","id"]),void this.gantt.api.rows.raise.remove(c)}},f.prototype.removeAll=function(){this.rowsMap={},this.rows=[],this.sortedRows=[],this.filteredRows=[],this.customFilteredRows=[],this.visibleRows=[];for(var a=0,b=this.rowsTaskWatchers.length;a<b;a++){(0,this.rowsTaskWatchers[a])()}this.rowsTaskWatchers=[]},f.prototype.sortRows=function(){var a=this.gantt.options.value("sortMode");if(void 0!==a){var b=!1;angular.isString(a)&&"-"===a.charAt(0)&&(b=!0,a=a.substr(1));var d=c("orderBy");this.sortedRows=d(this.rows,a,b)}else this.sortedRows=this.rows.slice();this.sortedRows=this.applyCustomRowSorters(this.sortedRows),this.updateVisibleRows()},f.prototype.removeCustomRowSorter=function(a){var b=this.customRowSorters.indexOf(a);b>-1&&this.customRowSorters.splice(b,1)},f.prototype.addCustomRowSorter=function(a){this.customRowSorters.push(a)},f.prototype.applyCustomRowSorters=function(a){for(var b=0;b<this.customRowSorters.length;b++)a=this.customRowSorters[b](a);return a},f.prototype.applySort=function(){var a=this.gantt.$scope.data;a.splice(0,a.length);for(var b=[],c=0,d=this.sortedRows.length;c<d;c++)a.push(this.sortedRows[c].model),b.push(this.sortedRows[c]);this.rows=b},f.prototype.moveRow=function(a,c){void 0!==this.gantt.options.value("sortMode")&&(this.applySort(),this.gantt.options.set("sortMode",void 0));var d=this.rows.indexOf(c),e=this.rows.indexOf(a);d>-1&&e>-1&&d!==e&&(b.moveToIndex(this.rows,e,d),b.moveToIndex(this.rowsTaskWatchers,e,d),b.moveToIndex(this.gantt.$scope.data,e,d),this.gantt.api.rows.raise.change(a),this.gantt.api.rows.raise.move(a,e,d),this.updateVisibleObjects(),this.sortRows())},f.prototype.updateVisibleObjects=function(){this.updateVisibleRows(),this.updateVisibleTasks()},f.prototype.updateVisibleRows=function(){var a=this.filteredRows,b=this.gantt.options.value("filterRow");if(b){"object"==typeof b&&(b={model:b});var c=this.gantt.options.value("filterRowComparator");if("function"==typeof c){var d=this.gantt;c=function(a,b){return d.options.value("filterRowComparator")(a,b)}}this.filteredRows=this.filterImpl(this.sortedRows,b,c)}else this.filteredRows=this.sortedRows.slice(0);var e=!angular.equals(a,this.filteredRows);this.customFilteredRows=this.applyCustomRowFilters(this.filteredRows),this.visibleRows=this.customFilteredRows,this.gantt.api.rows.raise.displayed(this.sortedRows,this.filteredRows,this.visibleRows),e&&this.gantt.api.rows.raise.filter(this.sortedRows,this.filteredRows)},f.prototype.removeCustomRowFilter=function(a){var b=this.customRowFilters.indexOf(a);b>-1&&this.customRowFilters.splice(b,1)},f.prototype.addCustomRowFilter=function(a){this.customRowFilters.push(a)},f.prototype.applyCustomRowFilters=function(a){for(var b=0;b<this.customRowFilters.length;b++)a=this.customRowFilters[b](a);return a},f.prototype.setFilterImpl=function(a){this.filterImpl=a||this._defaultFilterImpl},f.prototype.updateVisibleTasks=function(){for(var a=[],b=[],c=[],d=[],e=0;e<this.rows.length;e++){var f=this.rows[e];a=a.concat(f.filteredTasks),f.updateVisibleTasks(),b=b.concat(f.filteredTasks),d=d.concat(f.visibleTasks),c=c.concat(f.tasks)}this.gantt.api.tasks.raise.displayed(c,b,d),!angular.equals(a,b)&&this.gantt.api.tasks.raise.filter(c,b,d)},f.prototype.updateTasksPosAndSize=function(){for(var a=0,b=this.rows.length;a<b;a++)this.rows[a].updateTasksPosAndSize()},f.prototype.getExpandedFrom=function(a){a=a?e(a):a;for(var b=a,c=0;c<this.rows.length;c++)(void 0===b||b>this.rows[c].from)&&(b=this.rows[c]);return b&&(!a||b<a)?b:a},f.prototype.getExpandedTo=function(a){a=a?e(a):a;for(var b=a,c=0;c<this.rows.length;c++)(void 0===b||b<this.rows[c].to)&&(b=this.rows[c].to);var d=this.gantt.options.value("toDate");return b&&(!d||b>d)?b:a},f.prototype.getDefaultFrom=function(){for(var a,b=0;b<this.rows.length;b++)(void 0===a||this.rows[b].from<a)&&(a=this.rows[b].from);return a},f.prototype.getDefaultTo=function(){for(var a,b=0;b<this.rows.length;b++)(void 0===a||this.rows[b].to>a)&&(a=this.rows[b].to);return a},f}])}(),function(){"use strict";angular.module("gantt").factory("GanttTask",["moment",function(a){var b=function(a,b){this.rowsManager=a.rowsManager,this.row=a,this.model=b,this.truncatedLeft=!1,this.truncatedRight=!1};return b.prototype.isMilestone=function(){return!this.model.to||this.model.from-this.model.to==0},b.prototype.isOutOfRange=function(){var a=this.rowsManager.gantt.columnsManager.getFirstColumn(),b=this.rowsManager.gantt.columnsManager.getLastColumn();return void 0===a||this.model.to<a.date||void 0===b||this.model.from>b.endDate},b.prototype.updatePosAndSize=function(){var b=this.left,c=this.width,d=this.truncatedRight,e=this.truncatedLeft;!this.isMoving&&this.isOutOfRange()?(this.modelLeft=void 0,this.modelWidth=void 0):(this.modelLeft=this.rowsManager.gantt.getPositionByDate(this.model.from),this.modelWidth=this.rowsManager.gantt.getPositionByDate(this.model.to)-this.modelLeft);var f=this.rowsManager.gantt.columnsManager.getLastColumn(),g=f?f.left+f.width:0,h=this.modelLeft,i=this.modelWidth;this.rowsManager.gantt.options.value("daily")&&(h=this.rowsManager.gantt.getPositionByDate(a(this.model.from).startOf("day")),i=this.rowsManager.gantt.getPositionByDate(a(this.model.to).endOf("day"))-h);var j=-i;h<j&&(h=j),h>g&&(h=g),void 0===h||void 0===i?(this.left=void 0,this.width=void 0):(this.left=h,this.width=i,h<0?(this.truncatedLeft=!0,this.truncatedLeftOffset=-h,this.truncatedRight=!1,this.truncatedRightOffset=void 0):i+h>this.rowsManager.gantt.width?(this.truncatedRight=!0,this.truncatedRightOffset=i+h-this.rowsManager.gantt.width,this.truncatedLeft=!1,this.truncatedLeftOffset=void 0):(this.truncatedLeft=!1,this.truncatedLeftOffset=void 0,this.truncatedRight=!1,this.truncatedRightOffset=i+h-this.rowsManager.gantt.width),this.width<0&&(this.left=this.left+this.width,this.width=-this.width)),this.updateView(),this.rowsManager.gantt.isRefreshingColumns||b===this.left&&c===this.width&&d===this.truncatedRight&&e===this.truncatedLeft||this.rowsManager.gantt.api.tasks.raise.viewChange(this)},b.prototype.updateView=function(){if(this.$element)if(void 0===this.left||void 0===this.width)this.$element.css("display","none");else{if(this.$element.css({left:this.left+"px",width:this.width+"px",display:""}),this.model.priority>0)for(var a=this.model.priority,b=this.$element.children(),c=0;c<b.length;c++)angular.element(b[c]).css("z-index",a);this.$element.toggleClass("gantt-task-milestone",this.isMilestone())}},b.prototype.getBackgroundElement=function(){if(void 0!==this.$element){var a=this.$element[0].querySelector(".gantt-task-background");return void 0!==a&&(a=angular.element(a)),a}},b.prototype.getContentElement=function(){if(void 0!==this.$element){var a=this.$element[0].querySelector(".gantt-task-content");return void 0!==a&&(a=angular.element(a)),a}},b.prototype.getForegroundElement=function(){if(void 0!==this.$element){var a=this.$element[0].querySelector(".gantt-task-foreground");return void 0!==a&&(a=angular.element(a)),a}},b.prototype.setFrom=function(a,b){this.model.from=this.rowsManager.gantt.getDateByPosition(a,b),this.row.setFromTo(),this.updatePosAndSize()},b.prototype.setTo=function(a,b){this.model.to=this.rowsManager.gantt.getDateByPosition(a,b),this.row.setFromTo(),this.updatePosAndSize()},b.prototype.moveTo=function(a,b){var c,d;a>this.modelLeft?(this.model.to=this.rowsManager.gantt.getDateByPosition(a+this.modelWidth,b),c=this.rowsManager.gantt.getPositionByDate(this.model.to),d=c-this.modelWidth,this.model.from=this.rowsManager.gantt.getDateByPosition(d,!1)):(this.model.from=this.rowsManager.gantt.getDateByPosition(a,b),d=this.rowsManager.gantt.getPositionByDate(this.model.from),c=d+this.modelWidth,this.model.to=this.rowsManager.gantt.getDateByPosition(c,!1)),this.row.setFromTo(),this.updatePosAndSize()},b.prototype.clone=function(){return new b(this.row,angular.copy(this.model))},b}])}(),function(){"use strict";angular.module("gantt").factory("GanttBody",["GanttBodyColumns","GanttBodyRows","GanttBodyBackground","GanttBodyForeground",function(a,b,c,d){return function(e){this.gantt=e,this.background=new c(this),this.foreground=new d(this),this.columns=new a(this),this.rows=new b(this)}}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyBackground",[function(){return function(a){this.body=a}}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyColumns",[function(){return function(a){this.body=a}}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyForeground",[function(){return function(a){this.body=a}}])}(),function(){"use strict";angular.module("gantt").factory("GanttBodyRows",[function(){return function(a){this.body=a}}])}(),function(){"use strict";angular.module("gantt").factory("GanttHeader",["GanttHeaderColumns",function(a){return function(b){this.gantt=b,this.columns=new a(this),this.getHeight=function(){return this.$element[0].offsetHeight}}}])}(),function(){"use strict";angular.module("gantt").factory("GanttHeaderColumns",[function(){return function(a){this.$element=a}}])}(),function(){"use strict";angular.module("gantt").factory("GanttScroll",[function(){var a=function(b){this.gantt=b,this.gantt.api.registerEvent("scroll","scroll"),this.gantt.api.registerMethod("scroll","to",a.prototype.scrollTo,this),this.gantt.api.registerMethod("scroll","toDate",a.prototype.scrollToDate,this),this.gantt.api.registerMethod("scroll","left",a.prototype.scrollToLeft,this),this.gantt.api.registerMethod("scroll","right",a.prototype.scrollToRight,this),this.gantt.api.registerMethod("scroll","setWidth",a.prototype.setWidth,this)};return a.prototype.getScrollLeft=function(){return void 0===this.$element?void 0:(void 0===this.cachedScrollLeft&&(this.cachedScrollLeft=this.$element[0].scrollLeft),this.cachedScrollLeft)},a.prototype.getScrollWidth=function(){return void 0===this.$element?void 0:this.$element[0].scrollWidth},a.prototype.getWidth=function(){return void 0===this.$element?void 0:this.$element[0].offsetWidth},a.prototype.setWidth=function(a){this.$element[0]&&(this.$element[0].offsetWidth=a)},a.prototype.getBordersWidth=function(){if(void 0!==this.$element){if(this.$element[0].clientWidth)return this.$element[0].offsetWidth-this.$element[0].clientWidth;var a=window.getComputedStyle(this.$element[0]).getPropertyValue("border-left-width")?window.getComputedStyle(this.$element[0]).getPropertyValue("border-left-width").match(/\d+/)[0]:0,b=window.getComputedStyle(this.$element[0]).getPropertyValue("border-right-width")?window.getComputedStyle(this.$element[0]).getPropertyValue("border-right-width").match(/\d+/)[0]:0;return parseInt(a)+parseInt(b)}},a.prototype.getBordersHeight=function(){return void 0===this.$element?void 0:this.$element[0].offsetHeight-this.$element[0].clientHeight},a.prototype.isVScrollbarVisible=function(){if(void 0!==this.$element)return this.$element[0].scrollHeight>this.$element[0].offsetHeight},a.prototype.isHScrollbarVisible=function(){if(void 0!==this.$element)return this.$element[0].scrollWidth>this.$element[0].offsetWidth},a.prototype.scrollTo=function(a){this.$element[0].scrollLeft=a,this.$element.triggerHandler("scroll")},a.prototype.scrollToLeft=function(a){this.$element[0].scrollLeft-=a,this.$element.triggerHandler("scroll")},a.prototype.scrollToRight=function(a){this.$element[0].scrollLeft+=a,this.$element.triggerHandler("scroll")},a.prototype.scrollToDate=function(a){var b=this.gantt.getPositionByDate(a);void 0!==b&&(this.$element[0].scrollLeft=b-this.$element[0].offsetWidth/2)},a}])}(),function(){"use strict";angular.module("gantt").factory("GanttSide",[function(){var a=function(a){this.gantt=a};return a.prototype.getWidth=function(){if(this.gantt.options.value("showSide")){var a=this.gantt.options.value("sideWidth");if(void 0===a&&void 0!==this.$element&&void 0!==this.$element.css("width")&&this.$element.css("width",""),void 0!==this.$element&&(a=this.$element[0].offsetWidth),void 0!==a)return a}return 0},a.prototype.show=function(a){void 0!==this.$element&&this.$element.toggleClass("ng-hide",!a)},a.prototype.isShown=function(){if(void 0!==this.$element)return!this.$element.hasClass("ng-hide")},a}])}(),function(){"use strict";angular.module("gantt").factory("GanttTimespan",[function(){var a=function(a,b){this.gantt=a,this.model=b};return a.prototype.updatePosAndSize=function(){this.modelLeft=this.gantt.getPositionByDate(this.model.from),this.modelWidth=this.gantt.getPositionByDate(this.model.to)-this.modelLeft;var a=this.gantt.columnsManager.getLastColumn(),b=a?a.left+a.width:0,c=this.modelLeft,d=this.modelWidth,e=-d;c<e&&(c=e),c>b&&(c=b),void 0===c||void 0===d?(this.left=void 0,this.width=void 0):(this.left=c,this.width=d,c<0?(this.truncatedLeft=!0,this.truncatedLeftOffset=-c,this.truncatedRight=!1,this.truncatedRightOffset=void 0):d+c>this.gantt.width?(this.truncatedRight=!0,this.truncatedRightOffset=d+c-this.gantt.width,this.truncatedLeft=!1,this.truncatedLeftOffset=void 0):(this.truncatedLeft=!1,this.truncatedLeftOffset=void 0,this.truncatedRight=!1,this.truncatedRightOffset=d+c-this.gantt.width),this.width<0&&(this.left=this.left+this.width,this.width=-this.width)),this.updateView()},a.prototype.updateView=function(){this.$element&&(void 0===this.left||void 0===this.width?this.$element.css("display","none"):(this.$element.css("display",""),this.$element.css("left",this.left+"px"),this.$element.css("width",this.width+"px")))},a.prototype.setFrom=function(a){this.from=this.gantt.getDateByPosition(a),this.updatePosAndSize()},a.prototype.setTo=function(a){this.to=this.gantt.getDateByPosition(a),this.updatePosAndSize()},a.prototype.moveTo=function(a){this.from=this.gantt.getDateByPosition(a),this.to=this.gantt.getDateByPosition(a+this.width),this.updatePosAndSize()},a.prototype.clone=function(){return new a(this.gantt,angular.copy(this.model))},a}])}(),function(){"use strict";angular.module("gantt").factory("GanttTimespansManager",["GanttTimespan",function(a){var b=function(a){var b=this;this.gantt=a,this.timespansMap={},this.timespans=[],this.gantt.$scope.$watchCollection("timespans",function(a){b.clearTimespans(),b.loadTimespans(a)}),this.gantt.api.registerMethod("timespans","load",this.loadTimespans,this),this.gantt.api.registerMethod("timespans","remove",this.removeTimespans,this),this.gantt.api.registerMethod("timespans","clear",this.clearTimespans,this),this.gantt.api.registerEvent("timespans","add"),this.gantt.api.registerEvent("timespans","remove"),this.gantt.api.registerEvent("timespans","change")};return b.prototype.loadTimespans=function(a){angular.isArray(a)||(a=void 0!==a?[a]:[]),this.gantt.$scope.timespans=a;for(var b=0,c=a.length;b<c;b++){var d=a[b];this.gantt.objectModel.cleanTimespan(d),this.loadTimespan(d)}},b.prototype.loadTimespan=function(b){var c,d=!1;return b.id in this.timespansMap?(c=this.timespansMap[b.id],c.model=b,d=!0,this.gantt.api.timespans.raise.change(c)):(c=new a(this.gantt,b),this.timespansMap[b.id]=c,this.timespans.push(c),this.gantt.api.timespans.raise.add(c)),c.updatePosAndSize(),d},b.prototype.removeTimespans=function(a){angular.isArray(a)||(a=[a]);for(var b=0,c=a.length;b<c;b++){var d=a[b];this.removeTimespan(d.id)}this.updateVisibleObjects()},b.prototype.removeTimespan=function(a){if(a in this.timespansMap){delete this.timespansMap[a];for(var b,c,d=this.timespans.length-1;d>=0;d--)if(c=this.timespans[d],c.model.id===a){b=c,this.timespans.splice(d,1);break}return this.gantt.api.timespans.raise.remove(b),b}},b.prototype.clearTimespans=function(){this.timespansMap={},this.timespans=[]},b.prototype.updateTimespansPosAndSize=function(){for(var a=0,b=this.timespans.length;a<b;a++)this.timespans[a].updatePosAndSize()},b}])}(),function(){"use strict";angular.module("gantt").service("ganttArrays",[function(){return{moveToIndex:function(a,b,c){if(c>=a.length)for(var d=c-a.length;1+d--;)a.push(void 0);return a.splice(c,0,a.splice(b,1)[0]),a},getRemovedIds:function(a,b,c){void 0===c&&(c="id");var d,e,f=[];if(void 0!==b)for(d=0,e=b.length;d<e;d++)f.push(b[d][c]);if(void 0!==a)for(d=0,e=a.length;d<e;d++){var g=a[d];if(void 0!==g[c]){var h=f.indexOf(g[c]);h>-1&&f.splice(h,1)}}return f},indexOfId:function(a,b,c){var d;if(void 0===c)c="id";else if(c instanceof Array){for(d=a.length-1;d>=0;d--){for(var e=a[d],f=0,g=c.length;f<g;f++)e=e[c[f]];if(e===b)return d}return-1}for(d=a.length-1;d>=0;d--)if(a[d][c]===b)return d;return-1},removeId:function(a,b,c){var d=this.indexOfId(a,b,c);if(d>-1)return a.splice(d,1)[0]},remove:function(a,b){var c=a.indexOf(b);return c>-1&&(a.splice(c,1),!0)}}}])}(),function(){"use strict";angular.module("gantt").service("ganttBinarySearch",[function(){return{getIndicesOnly:function(a,b,c,d){for(var e=-1,f=a.length;f-e>1;){var g=Math.floor((e+f)/2);(d?c(a[g])<b:c(a[g])<=b)?e=g:f=g}return d||void 0===a[e]||c(a[e])!==b||(f=e),[e,f]},get:function(a,b,c,d){var e=this.getIndicesOnly(a,b,c,d);return[a[e[0]],a[e[1]]]}}}])}(),function(){"use strict";angular.module("gantt").factory("GanttHierarchy",[function(){return function(){var a=this,b={},c={},d={},e={},f={},g={},h=function(a,b){if(void 0!==b){var c=d[a.model.name];void 0===c&&(c=[],d[a.model.name]=c),c.push(b);var h=e[a.model.id];void 0===h&&(h=[],e[a.model.id]=h),h.push(b),f[b.model.name]=a,g[b.model.id]=a}};this.refresh=function(i){b={},c={},d={},e={},f={},g={};for(var j,k=0;k<i.length;k++)j=i[k],b[j.model.name]=j,c[j.model.id]=j;for(k=0;k<i.length;k++){if(j=i[k],void 0!==j.model.parent){var l=b[j.model.parent];void 0===l&&(l=c[j.model.parent]),void 0!==l&&h(l,j)}if(void 0!==j.model.children)for(var m=j.model.children,n=0;n<m.length;n++){var o=m[n],p=b[o];void 0===p&&(p=c[o]),void 0!==p&&h(j,p)}}var q=[];for(k=0;k<i.length;k++)j=i[k],void 0===a.parent(j)&&q.push(j);return q},this.children=function(a){return e[a.model.id]},this.descendants=function(b){var c=[],d=a.children(b);if(c.push.apply(c,d),void 0!==d)for(var e=0;e<d.length;e++){var f=a.descendants(d[e]);c.push.apply(c,f)}return c},this.parent=function(a){return g[a.model.id]},this.ancestors=function(b){for(var c=[],d=a.parent(b);void 0!==d;)c.push(d),d=a.parent(d);return c}}}])}(),function(){"use strict";angular.module("gantt").service("ganttUtils",[function(){return{createBoundedWrapper:function(a,b){return function(){return b.apply(a,arguments)}},firstProperty:function(a,b,c){for(var d=0,e=a.length;d<e;d++){var f=a[d];if(void 0!==f&&b in f&&void 0!==f[b])return f[b]}return c},angularIndexOf:function(a,b){for(var c=0;c<a.length;c++)if(angular.equals(a[c],b))return c;return-1},random4:function(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)},randomUuid:function(){return this.random4()+this.random4()+"-"+this.random4()+"-"+this.random4()+"-"+this.random4()+"-"+this.random4()+this.random4()+this.random4()},newId:function(){var a=(new Date).getTime();return function(){return a+=1}}()}}])}(),function(){"use strict";angular.module("gantt").filter("ganttColumnLimit",["ganttBinarySearch",function(a){var b=function(a){return a.left};return function(c,d){var e=d.scroll.getScrollLeft(),f=d.getWidth()-d.side.getWidth();if(f>0){var g=a.getIndicesOnly(c,e,b)[0],h=a.getIndicesOnly(c,e+f,b)[1];return c.slice(g,h)}return c.slice()}}])}(),function(){"use strict";angular.module("gantt").filter("ganttTaskLimit",[function(){return function(a,b){var c=b.columnsManager.getFirstColumn(),d=b.columnsManager.getLastColumn();if(void 0!==c&&void 0!==d){for(var e=c.date,f=d.endDate,g=[],h=b.scroll.getScrollLeft(),i=b.getWidth()-b.side.getWidth(),j=0,k=a.length;j<k;j++){var l=a[j];l.active?g.push(l):l.model.to>=e&&l.model.from<=f&&(void 0===l.left&&l.updatePosAndSize(),(!i||l.left>=h&&l.left<=h+i||l.left+l.width>=h&&l.left+l.width<=h+i||l.left<h&&l.left+l.width>h+i)&&g.push(l))}return g}return a.splice()}}])}(),function(){"use strict";angular.module("gantt").directive("ganttResizer",["$document","$parse","$timeout","ganttMouseOffset",function(a,b,c,d){return{restrict:"A",require:"^gantt",scope:{targetElement:"=ganttResizer",enabled:"@?ganttResizerEnabled"},link:function(e,f,g,h){function i(){return h.gantt.options.value(g.resizerWidth)}function j(a){a!==i()&&(h.gantt.options.set(g.resizerWidth,a),void 0!==p&&o[p].raise.resize(a),c(function(){h.gantt.columnsManager.updateColumnsMeta()}))}function k(a){a.preventDefault(),j(void 0)}function l(a){e.$evalAsync(function(){var b=d.getOffsetForElement(e.targetElement[0],a),c=h.gantt.getWidth()-h.gantt.scroll.getBordersWidth();j(Math.min(Math.max(b.x,0),c))})}function m(){void 0!==p&&o[p].raise.resizeEnd(i()),a.unbind("mousemove",l),a.unbind("mouseup",m)}function n(b){b.preventDefault(),void 0!==p&&o[p].raise.resizeBegin(i()),a.on("mousemove",l),a.on("mouseup",m)}var o=h.gantt.api,p=g.ganttResizerEventTopic;void 0===e.enabled&&(e.enabled=!0),g.$observe("ganttResizerEnabled",function(a){e.enabled=b(a)()}),e.$watch("enabled",function(a){void 0===a&&(a=!0),f.toggleClass("gantt-resizer-enabled",a),a?(f.on("dblclick",k),f.on("mousedown",n)):(f.off("dblclick",k),f.off("mousedown",n))}),e.$watch(function(){return i()},function(a,b){a!==b&&(e.targetElement.css("width",a+"px"),e.targetElement[0].offsetWidth>0&&j(e.targetElement[0].offsetWidth))}),p&&(o.registerEvent(p,"resize"),o.registerEvent(p,"resizeBegin"),o.registerEvent(p,"resizeEnd"),o.registerMethod(p,"setWidth",j,this),o.registerMethod(p,"getWidth",i,this))}}}])}(),function(){"use strict";angular.module("gantt").directive("ganttHorizontalScrollReceiver",function(){return{
restrict:"A",require:"^ganttScrollManager",link:function(a,b,c,d){d.registerHorizontalReceiver(b)}}})}(),function(){"use strict";angular.module("gantt").directive("ganttScrollable",["GanttDirectiveBuilder","$timeout","ganttDebounce","moment",function(a,b,c,d){var e=new a("ganttScrollable");return e.controller=function(a,e){a.gantt.scroll.$element=e;var f,g,h=function(b,c,e){var f=a.gantt.options.value("autoExpand");if("both"===f||!0===f||f===e){var g,h,i=a.gantt.options.value("viewScale");i=i.trim(),"s"===i.charAt(i.length-1)&&(i=i.substring(0,i.length-1));var j,k,l;i&&(l=i.split(" ")),l&&l.length>1?(j=parseFloat(l[0]),k=l[l.length-1]):(j=1,k=i),"left"===e?(g=d(c).add(-5*j,k),a.fromDate=g):(h=d(c).add(5*j,k),a.toDate=h),a.gantt.api.scroll.raise.scroll(b.scrollLeft,c,e)}};e.bind("scroll",c(function(){var c,d,i=e[0],j=i.scrollLeft;a.gantt.scroll.cachedScrollLeft=j,a.gantt.columnsManager.updateVisibleColumns(),a.gantt.rowsManager.updateVisibleObjects(),j<f&&0===j?(c="left",d=a.gantt.columnsManager.from):j>f&&i.offsetWidth+j>=i.scrollWidth-1&&(c="right",d=a.gantt.columnsManager.to),f=j,void 0!==d?(g&&b.cancel(g),g=b(function(){h(i,d,c)},300)):a.gantt.api.scroll.raise.scroll(j)},5)),a.getScrollableCss=function(){var b={},c=a.gantt.options.value("maxHeight");c||(c=a.gantt.getContainerHeight()),c>0&&(b["max-height"]=c-a.gantt.header.getHeight()+"px",b["overflow-y"]="auto",a.gantt.scroll.isVScrollbarVisible()&&(b["border-right"]="none"));var d=this.gantt.options.value("columnWidth"),e=0!==a.gantt.width&&a.gantt.width<a.gantt.getWidth()-a.gantt.side.getWidth();return void 0!==d&&e&&(b.width=a.gantt.width+this.gantt.scroll.getBordersWidth()+"px"),b}},e.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttScrollManager",function(){return{restrict:"A",scope:{},controller:["$scope",function(a){a.horizontal=[],a.vertical=[],this.registerVerticalReceiver=function(b){b.css("position","relative"),a.vertical.push(b[0])},this.registerHorizontalReceiver=function(b){b.css("position","relative"),a.horizontal.push(b[0])},this.getHorizontalRecievers=function(){return a.horizontal},this.getVerticalRecievers=function(){return a.vertical}}]}})}(),function(){"use strict";angular.module("gantt").directive("ganttScrollSender",[function(){return{restrict:"A",require:["^gantt","^ganttScrollManager"],link:function(a,b,c,d){var e=b[0],f=function(){var a,b,c=d[1].getVerticalRecievers();for(a=0,b=c.length;a<b;a++){var f=c[a];f.parentNode.scrollTop!==e.scrollTop&&(f.parentNode.scrollTop=e.scrollTop)}var g=d[1].getHorizontalRecievers();for(a=0,b=g.length;a<b;a++){var h=g[a];h.parentNode.scrollLeft!==e.scrollLeft&&(h.parentNode.scrollLeft=e.scrollLeft)}};b.bind("scroll",f),a.$watch(function(){return d[0].gantt.width},function(a,b){if(a!==b)for(var c=d[1].getHorizontalRecievers(),e=0,f=c.length;e<f;e++){var g=c[e];g.style.width=a+"px"}})}}}])}(),function(){"use strict";angular.module("gantt").directive("ganttVerticalScrollReceiver",function(){return{restrict:"A",require:"^ganttScrollManager",link:function(a,b,c,d){d.registerVerticalReceiver(b)}}})}(),function(){"use strict";angular.module("gantt").directive("ganttContainerHeightListener",[function(){return{restrict:"A",controller:["$scope","$element","$attrs",function(a,b,c){var d=c.ganttContainerHeightListener;""===d&&(d="ganttContainerHeight");for(var e=a;0===d.indexOf("$parent.");)d=d.substring("$parent.".length),e=e.$parent;e.$watch(function(){var a=b[0].parentElement?b[0].parentElement.parentElement:void 0;if(a){var c=a.offsetHeight,d=getComputedStyle(a);return c=c-parseInt(d.marginTop)-parseInt(d.marginBottom)}return 0},function(a){a>0&&(e[d]=a)})}]}}])}(),function(){"use strict";angular.module("gantt").directive("ganttContainerWidthListener",[function(){return{restrict:"A",controller:["$scope","$element","$attrs",function(a,b,c){var d=c.ganttContainerWidthListener;""===d&&(d="ganttContainerWidth");for(var e=a;0===d.indexOf("$parent.");)d=d.substring("$parent.".length),e=e.$parent;e.$watch(function(){var a=b[0].parentElement?b[0].parentElement.parentElement:void 0;if(a){var c=a.offsetWidth,d=getComputedStyle(a);return c=c-parseInt(d.marginLeft)-parseInt(d.marginRight)}return 0},function(a){a>0&&(e[d]=a)})}]}}])}(),function(){"use strict";angular.module("gantt").directive("ganttElementHeightListener",[function(){return{restrict:"A",controller:["$scope","$element","$attrs",function(a,b,c){var d=c.ganttElementHeightListener;""===d&&(d="ganttElementHeight");for(var e=b[0],f=a;0===d.indexOf("$parent.");)d=d.substring("$parent.".length),f=f.$parent;f.$watch(function(){return e.clientHeight},function(a){a>0&&(f[d]=a)})}]}}])}(),function(){"use strict";angular.module("gantt").directive("ganttElementWidthListener",[function(){return{restrict:"A",controller:["$scope","$element","$attrs",function(a,b,c){var d=c.ganttElementWidthListener;""===d&&(d="ganttElementWidth");for(var e=b[0],f=a;0===d.indexOf("$parent.");)d=d.substring("$parent.".length),f=f.$parent;f.$watch(function(){return e.clientWidth},function(a){a>0&&(f[d]=a)})}]}}])}(),function(){"use strict";angular.module("gantt").directive("ganttBody",["GanttDirectiveBuilder",function(a){var b=new a("ganttBody");return b.controller=function(a,b){a.gantt.body.$element=b,a.gantt.body.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyBackground",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyBackground");return b.controller=function(a,b){a.gantt.body.background.$element=b,a.gantt.body.background.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyColumns",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyColumns");return b.controller=function(a,b){a.gantt.body.columns.$element=b,a.gantt.body.background.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyForeground",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyForeground");return b.controller=function(a,b){a.gantt.body.foreground.$element=b,a.gantt.body.foreground.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttBodyRows",["GanttDirectiveBuilder",function(a){var b=new a("ganttBodyRows");return b.controller=function(a,b){a.gantt.body.rows.$element=b,a.gantt.body.rows.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttColumn",["GanttDirectiveBuilder",function(a){var b=new a("ganttColumn");return b.controller=function(a,b){a.column.$element=b,a.column.$scope=a,a.column.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttColumnHeader",["GanttDirectiveBuilder",function(a){var b=new a("ganttColumnHeader");return b.controller=function(a,b){a.column.$element=b,a.column.$scope=a,a.column.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttHeader",["GanttDirectiveBuilder",function(a){var b=new a("ganttHeader");return b.controller=function(a,b){a.gantt.header.$element=b,a.gantt.header.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttHeaderColumns",["GanttDirectiveBuilder",function(a){var b=new a("ganttHeaderColumns");return b.controller=function(a,b){a.gantt.header.columns.$element=b,a.gantt.header.columns.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttRow",["GanttDirectiveBuilder",function(a){var b=new a("ganttRow");return b.controller=function(a,b){a.row.$element=b,a.row.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttRowBackground",["GanttDirectiveBuilder",function(a){return new a("ganttRowBackground").build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttRowLabel",["GanttDirectiveBuilder",function(a){var b=new a("ganttRowLabel");return b.restrict="A",b.templateUrl=void 0,b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttScrollableHeader",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttScrollableHeader");return c.controller=function(a){var c=b.getScrollBarWidth();a.getScrollableHeaderCss=function(){var b={},d=a.gantt.scroll.isVScrollbarVisible(),e=d?c:0,f=this.gantt.options.value("columnWidth"),g=0!==a.gantt.width&&a.gantt.width<a.gantt.getWidth()-a.gantt.side.getWidth();return void 0!==f&&g?b.width=a.gantt.width-e+this.gantt.scroll.getBordersWidth()+"px":d&&(b.width=a.gantt.getWidth()-a.gantt.side.getWidth()-e+"px"),b}},c.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttSide",["GanttDirectiveBuilder",function(a){var b=new a("ganttSide");return b.controller=function(a,b){a.gantt.side.$element=b,a.gantt.side.$scope=a},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttSideBackground",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttSideBackground");return c.controller=function(a){var c=b.getScrollBarHeight();a.getMaxHeightCss=function(){var b={},d=a.maxHeight;d||(d=a.gantt.getContainerHeight());var e=a.gantt.scroll.isHScrollbarVisible()?c:0;return b["max-height"]=d-e-a.gantt.header.getHeight()+"px",b}},c.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttSideContent",["GanttDirectiveBuilder","ganttLayout",function(a,b){var c=new a("ganttSideContent");return c.controller=function(a){var c=b.getScrollBarHeight();a.getSideCss=function(){var b={},d=a.maxHeight;d||(d=a.gantt.getContainerHeight());var e=a.gantt.scroll.isHScrollbarVisible()?c:0;return b["max-height"]=d-e+"px",b}},c.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTask",["GanttDirectiveBuilder","moment",function(a,b){var c=new a("ganttTask");return c.controller=function(a,c){a.task.$element=c,a.task.$scope=a,a.getTaskContent=function(){return void 0!==a.task.model.content?a.task.model.content:a.task.rowsManager.gantt.options.value("taskContent")},a.simplifyMoment=function(a){return b.isMoment(a)?a.unix():a},a.$watchGroup(["simplifyMoment(task.model.from)","simplifyMoment(task.model.to)"],function(){a.task.updatePosAndSize()})},c.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskBackground",["GanttDirectiveBuilder",function(a){return new a("ganttTaskBackground").build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskContent",["GanttDirectiveBuilder",function(a){return new a("ganttTaskContent").build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTaskForeground",["GanttDirectiveBuilder",function(a){return new a("ganttTaskForeground").build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTimeFrame",["GanttDirectiveBuilder",function(a){var b=new a("ganttTimeFrame");return b.controller=function(a,b){a.timeFrame.$element=b,a.timeFrame.$scope=a,a.timeFrame.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").directive("ganttTimespan",["GanttDirectiveBuilder",function(a){var b=new a("ganttTimespan");return b.controller=function(a,b){a.timespan.$element=b,a.timespan.$scope=a,a.timespan.updateView()},b.build()}])}(),function(){"use strict";angular.module("gantt").factory("ganttDebounce",["$timeout",function(a){function b(b,c,d){var e=0;return function(){var f=this,g=arguments;e++;var h=function(a){return function(){if(a===e)return b.apply(f,g)}}(e);return a(h,c,void 0===d||d)}}return b}])}(),function(){"use strict";angular.module("gantt").service("GanttDirectiveBuilder",["$templateCache",function(a){return function(b,c,d,e){var f=this;this.directiveName=b,this.templateUrl=void 0===c?"template/"+b+".tmpl.html":c,this.require=void 0===d?"^gantt":d,this.restrict=void 0===e?"E":e,this.scope=!1,this.transclude=!0,this.replace=!0,this.build=function(){var b=f.directiveName,c=f.templateUrl,d=f.controller,e={restrict:f.restrict,require:f.require,transclude:f.transclude,replace:f.replace,scope:f.scope,templateUrl:function(b,d){return void 0!==d.templateUrl&&(c=d.templateUrl),void 0!==d.template&&a.put(c,d.template),c},compile:function(){return{pre:function(a,c,d,e){a.gantt.api.directives.raise.preLink(b,a,c,d,e)},post:function(a,c,d,e){a.gantt.api.directives.raise.postLink(b,a,c,d,e)}}},controller:["$scope","$element","$attrs",function(a,c,e){var f=this;void 0!==d&&d(a,c,e,f),a.gantt.api.directives.raise.controller(b,a,c,e,f),a.$on("$destroy",function(){a.gantt.api.directives.raise.destroy(b,a,c,e,f)}),a.$applyAsync(function(){a.gantt.api.directives.raise.new(b,a,c,e,f)})}]};return c||(delete e.templateUrl,delete e.replace,delete e.transclude),e}}}])}(),function(){"use strict";angular.module("gantt").service("ganttDom",["$document",function(a){return{elementFromPoint:function(b,c){return a[0].elementFromPoint(b,c)},elementsFromPoint:function(a,b,c){for(var d,e,f,g,h=[],i=[],j=0;(d=this.elementFromPoint(a,b))&&-1===h.indexOf(d)&&null!==d&&(void 0===c||j<c);)h.push(d),i.push({value:d.style.getPropertyValue("visibility"),priority:d.style.getPropertyPriority("visibility")}),d.style.setProperty("visibility","hidden","important"),j++;for(e=0,f=i.length;e<f;e++)g=i[e],h[e].style.setProperty("visibility",g.value?g.value:"",g.priority);return h},findElementFromPoint:function(a,b,c){for(var d,e,f,g,h,i=[],j=[],k=0;(d=this.elementFromPoint(a,b))&&-1===i.indexOf(d)&&null!==d;)if(i.push(d),j.push({value:d.style.getPropertyValue("visibility"),priority:d.style.getPropertyPriority("visibility")}),d.style.setProperty("visibility","hidden","important"),k++,c(d)){e=d;break}for(f=0,g=j.length;f<g;f++)h=j[f],i[f].style.setProperty("visibility",h.value?h.value:"",h.priority);return e},isElementVisible:function(a){return void 0!==a.offsetParent&&null!==a.offsetParent}}}])}(),function(){"use strict";angular.module("gantt").service("ganttEnableNgAnimate",["$injector",function(a){var b;try{b=a.get("$animate")}catch(a){}return void 0!==b?function(a,c){angular.version.major>=1&&angular.version.minor>=4?b.enabled(a,c):b.enabled(c,a)}:angular.noop}])}(),function(){"use strict";angular.module("gantt").directive("ganttBindCompileHtml",["$compile",function(a){return{restrict:"A",require:"^gantt",link:function(b,c,d,e){b.scope=e.gantt.$scope.$parent,b.$watch(function(){return b.$eval(d.ganttBindCompileHtml)},function(d){c.html(d),a(c.contents())(b)})}}}])}(),function(){"use strict";angular.module("gantt").service("ganttLayout",["$document",function(a){return{getScrollBarWidth:function(){var b=a[0].createElement("p");b.style.width="100%",b.style.height="200px";var c=a[0].createElement("div");c.style.position="absolute",c.style.top="0px",c.style.left="0px",c.style.visibility="hidden",c.style.width="200px",c.style.height="150px",c.style.overflow="hidden",c.appendChild(b),a[0].body.appendChild(c);var d=b.offsetWidth;c.style.overflow="scroll";var e=b.offsetWidth;return d===e&&(e=c.clientWidth),a[0].body.removeChild(c),d-e},getScrollBarHeight:function(){var b=a[0].createElement("p");b.style.width="200px;",b.style.height="100%";var c=a[0].createElement("div");c.style.position="absolute",c.style.top="0px",c.style.left="0px",c.style.visibility="hidden",c.style.width="150px",c.style.height="200px",c.style.overflow="hidden",c.appendChild(b),a[0].body.appendChild(c);var d=b.offsetHeight;c.style.overflow="scroll";var e=b.offsetHeight;return d===e&&(e=c.clientHeight),a[0].body.removeChild(c),d-e},setColumnsWidthFactor:function(a,b,c){if(a){c||(c=0);for(var d=0;d<a.length;d++){var e=a[d];e.left=b*(e.originalSize.left+c)-c,e.width=b*e.originalSize.width;for(var f=0;f<e.timeFrames.length;f++){var g=e.timeFrames[f];g.left=b*g.originalSize.left,g.width=b*g.originalSize.width}}}}}}])}(),function(){"use strict";angular.module("gantt").service("ganttMouseButton",[function(){return{getButton:function(a){return a=a||window.event,a.which?a.which:void 0===a.button?1:a.button<2?1:4===a.button?2:3}}}])}(),function(){"use strict";angular.module("gantt").service("ganttMouseOffset",[function(){return{getTouch:function(a){return void 0!==a.touches?a.touches[0]:a},getOffset:function(a){return a.offsetX&&a.offsetY?{x:a.offsetX,y:a.offsetY}:a.layerX&&a.layerY?{x:a.layerX,y:a.layerY}:this.getOffsetForElement(a.target,a)},getOffsetForElement:function(a,b){var c=a.getBoundingClientRect();return{x:b.clientX-c.left,y:b.clientY-c.top}}}}])}(),function(){"use strict";angular.module("gantt").factory("ganttSmartEvent",[function(){function a(a,b,c,d){return a.$on("$destroy",function(){b.unbind(c,d)}),{bindOnce:function(){b.one(c,d)},bind:function(){b.bind(c,d)},unbind:function(){b.unbind(c,d)}}}return a}])}(),angular.module("gantt.templates",[]).run(["$templateCache",function(a){a.put("template/gantt.tmpl.html",'<div class="gantt unselectable" ng-cloak gantt-scroll-manager\n     gantt-container-height-listener="ganttContainerHeight"\n     gantt-container-width-listener="ganttContainerWidth"\n     gantt-element-height-listener="ganttElementHeight"\n     gantt-element-width-listener="ganttElementWidth">\n    <gantt-side>\n        <gantt-side-background>\n        </gantt-side-background>\n        <gantt-side-content>\n        </gantt-side-content>\n        <div gantt-resizer="gantt.side.$element" gantt-resizer-event-topic="side" gantt-resizer-enabled="{{$parent.gantt.options.value(\'allowSideResizing\')}}" resizer-width="sideWidth" class="gantt-resizer">\n            <div ng-show="$parent.gantt.options.value(\'allowSideResizing\')" class="gantt-resizer-display"></div>\n        </div>\n    </gantt-side>\n    <gantt-scrollable-header>\n        <gantt-header gantt-element-height-listener="$parent.ganttHeaderHeight">\n            <gantt-header-columns>\n                <div ng-repeat="header in gantt.columnsManager.visibleHeaders track by $index">\n                    <div class="gantt-header-row" ng-class="{\'gantt-header-row-last\': $last, \'gantt-header-row-first\': $first}">\n                        <gantt-column-header ng-repeat="column in header"></gantt-column-header>\n                    </div>\n                </div>\n            </gantt-header-columns>\n        </gantt-header>\n    </gantt-scrollable-header>\n    <gantt-scrollable>\n        <gantt-body>\n            <gantt-body-background>\n                <gantt-row-background ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id"></gantt-row-background>\n            </gantt-body-background>\n            <gantt-body-foreground>\n                <div class="gantt-current-date-line" ng-show="currentDate === \'line\' && gantt.currentDateManager.position >= 0 && gantt.currentDateManager.position <= gantt.width" ng-style="{\'left\': gantt.currentDateManager.position + \'px\' }"></div>\n            </gantt-body-foreground>\n            <gantt-body-columns>\n                <gantt-column ng-repeat="column in gantt.columnsManager.visibleColumns">\n                    <gantt-time-frame ng-repeat="timeFrame in column.visibleTimeFrames"></gantt-time-frame>\n                </gantt-column>\n            </gantt-body-columns>\n            <div ng-if="gantt.columnsManager.visibleColumns == 0" style="background-color: #808080"></div>\n            <gantt-body-rows>\n                <gantt-timespan ng-repeat="timespan in gantt.timespansManager.timespans track by timespan.model.id"></gantt-timespan>\n                <gantt-row ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id">\n                    <gantt-task ng-repeat="task in row.visibleTasks track by task.model.id">\n                    </gantt-task>\n                </gantt-row>\n            </gantt-body-rows>\n        </gantt-body>\n    </gantt-scrollable>\n\n    <!-- Plugins -->\n    <ng-transclude></ng-transclude>\n\n    <!--\n    ******* Inline templates *******\n    You can specify your own templates by either changing the default ones below or by\n    adding an attribute template-url="<url to your template>" on the specific element.\n    -->\n\n    <!-- Body template -->\n    <script type="text/ng-template" id="template/ganttBody.tmpl.html">\n        <div ng-transclude class="gantt-body" ng-style="{\'width\': gantt.width > 0 ? gantt.width +\'px\' : undefined}"></div>\n    </script>\n\n    <!-- Header template -->\n    <script type="text/ng-template" id="template/ganttHeader.tmpl.html">\n        <div ng-transclude class="gantt-header"\n             ng-show="gantt.columnsManager.columns.length > 0 && gantt.columnsManager.headers.length > 0"></div>\n    </script>\n\n    <!-- Side template -->\n    <script type="text/ng-template" id="template/ganttSide.tmpl.html">\n        <div ng-transclude class="gantt-side" style="width: auto;"></div>\n    </script>\n\n    <!-- Side content template-->\n    <script type="text/ng-template" id="template/ganttSideContent.tmpl.html">\n        <div class="gantt-side-content" ng-style="getSideCss()">\n        </div>\n    </script>\n\n    <!-- Header columns template -->\n    <script type="text/ng-template" id="template/ganttHeaderColumns.tmpl.html">\n        <div ng-transclude class="gantt-header-columns"\n              gantt-horizontal-scroll-receiver></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttColumnHeader.tmpl.html">\n        <div class="gantt-column-header" ng-class="{\'gantt-column-header-last\': $last, \'gantt-column-header-first\': $first}">{{::column.label}}</div>\n    </script>\n\n    <!-- Body background template -->\n    <script type="text/ng-template" id="template/ganttBodyBackground.tmpl.html">\n        <div ng-transclude class="gantt-body-background"></div>\n    </script>\n\n    <!-- Body foreground template -->\n    <script type="text/ng-template" id="template/ganttBodyForeground.tmpl.html">\n        <div ng-transclude class="gantt-body-foreground"></div>\n    </script>\n\n    <!-- Body columns template -->\n    <script type="text/ng-template" id="template/ganttBodyColumns.tmpl.html">\n        <div ng-transclude class="gantt-body-columns"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttColumn.tmpl.html">\n        <div ng-transclude class="gantt-column gantt-foreground-col" ng-class="{\'gantt-column-last\': $last, \'gantt-column-first\': $first}"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttTimeFrame.tmpl.html">\n        <div class="gantt-timeframe"></div>\n    </script>\n\n    <!-- Scrollable template -->\n    <script type="text/ng-template" id="template/ganttScrollable.tmpl.html">\n        <div ng-transclude class="gantt-scrollable" gantt-scroll-sender ng-style="getScrollableCss()"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttScrollableHeader.tmpl.html">\n        <div ng-transclude class="gantt-scrollable-header" ng-style="getScrollableHeaderCss()"></div>\n    </script>\n\n    <!-- Rows template -->\n    <script type="text/ng-template" id="template/ganttBodyRows.tmpl.html">\n        <div ng-transclude class="gantt-body-rows"></div>\n    </script>\n\n    <!-- Timespan template -->\n    <script type="text/ng-template" id="template/ganttTimespan.tmpl.html">\n        <div class="gantt-timespan" ng-class="timespan.model.classes">\n        </div>\n    </script>\n\n    <!-- Task template -->\n    <script type="text/ng-template" id="template/ganttTask.tmpl.html">\n        <div class="gantt-task" ng-class="task.model.classes">\n            <gantt-task-background></gantt-task-background>\n            <gantt-task-foreground></gantt-task-foreground>\n            <gantt-task-content></gantt-task-content>\n        </div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttTaskBackground.tmpl.html">\n        <div class="gantt-task-background" ng-style="{\'background-color\': task.model.color}"></div>\n    </script>\n\n    <script type="text/ng-template" id="template/ganttTaskForeground.tmpl.html">\n        <div class="gantt-task-foreground">\n            <div ng-if="task.truncatedRight" class="gantt-task-truncated-right" ng-style="{\'padding-right\': task.truncatedRightOffset + \'px\'}">&gt;</div>\n            <div ng-if="task.truncatedLeft" class="gantt-task-truncated-left" ng-style="{\'padding-left\': task.truncatedLeftOffset + \'px\'}">&lt;</div>\n        </div>\n    </script>\n\n    <!-- Task content template -->\n    <script type="text/ng-template" id="template/ganttTaskContent.tmpl.html">\n        <div class="gantt-task-content" unselectable="on"><span unselectable="on" gantt-bind-compile-html="getTaskContent()"/></div>\n    </script>\n\n\n    <!-- Row background template -->\n    <script type="text/ng-template" id="template/ganttRowBackground.tmpl.html">\n        <div class="gantt-row gantt-row-height"\n             ng-class="row.model.classes"\n             ng-class-odd="\'gantt-row-odd\'"\n             ng-class-even="\'gantt-row-even\'"\n             ng-style="{\'height\': row.model.height}">\n            <div class="gantt-row-background"\n                 ng-style="{\'background-color\': row.model.color}">\n            </div>\n        </div>\n    </script>\n\n    <!-- Row template -->\n    <script type="text/ng-template" id="template/ganttRow.tmpl.html">\n        <div class="gantt-row gantt-row-height"\n             ng-class="row.model.classes"\n             ng-class-odd="\'gantt-row-odd\'"\n             ng-class-even="\'gantt-row-even\'"\n             ng-style="{\'height\': row.model.height}">\n            <div ng-transclude class="gantt-row-content"></div>\n        </div>\n    </script>\n\n    <!-- Side background template -->\n    <script type="text/ng-template" id="template/ganttSideBackground.tmpl.html">\n        <div class="gantt-side-background">\n            <div class="gantt-side-background-header" ng-style="{height: $parent.ganttHeaderHeight + \'px\'}">\n                <div ng-show="$parent.ganttHeaderHeight" class="gantt-header-row gantt-side-header-row"></div>\n            </div>\n            <div class="gantt-side-background-body" ng-style="getMaxHeightCss()">\n                <div gantt-vertical-scroll-receiver>\n                    <div class="gantt-row gantt-row-height "\n                         ng-class-odd="\'gantt-row-odd\'"\n                         ng-class-even="\'gantt-row-even\'"\n                         ng-class="row.model.classes"\n                         ng-repeat="row in gantt.rowsManager.visibleRows track by row.model.id"\n                         ng-style="{\'height\': row.model.height}">\n                        <div class="gantt-row-label gantt-row-background"\n                             ng-style="{\'background-color\': row.model.color}">\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </script>\n</div>\n')}]);
//# sourceMappingURL=angular-gantt.min.js.map