### Submitting a PR
Excellent! You've chosen to help advance the project by either fixing a bug, or implementing a new feature.  Before you put forth any work on a PR, please follow these steps:

1. Ensure a similar PR has not already been opened or closed.
1. Clearly define the intent of the PR.  The more detail, the more likelihood of it getting merged.
1. Is this a feature that would benefit the **majority** of users?  This is a small library, and it intends to stay that way.  If you do not believe most users of the project will benefit from your work, it should probably be added in your own application. 
1. Be sure to include test cases that cover all newly introduced code.  This part is essential, as any PRs without tests will be closed.
1. Link any [issues](https://github.com/chieffancypants/angular-loading-bar/issues) that are addressed by the PR.

### Submitting a bug report
If you believe you've found a bug in the source code, and are unable to fix it yourself (by submitting a PR) please follow these steps:

1. Ensure the bug has not already been reported by searching the [issues](https://github.com/chieffancypants/angular-loading-bar/issues)
1. Submit a reduced test case that clearly demonstrates the bug. This means submitting a plunker or jsfiddle with the bare minimum of code necessary to reproduce the bug. Without this, your issue may be closed as invalid.
1. Include any relevant browser information
1. If you're unable to fix this bug yourself, but can point to why it is occuring, please send that information along (line# or commit)

