!function(){"use strict";angular.module("angular-mapbox",[])}(),function(){"use strict";function mapboxService(){function init(opts){opts=opts||{},L.mapbox.accessToken=opts.accessToken}function addMapInstance(map,mapOptions){mapOptions=mapOptions||{},_mapInstances.push(map),_mapOptions.push(mapOptions),_markers.push([])}function getMapInstances(){return _mapInstances}function addMarker(marker){var map=getMapInstances()[0];_markers[0].push(marker);var opts=getOptionsForMap(map);opts.scaleToFit&&fitMapToMarkers(map)}function removeMarker(map,marker){map.removeLayer(marker);for(var markerIndexToRemove,i=0,markers=getMarkers();markers[i];i++)markers[i]._leaflet_id===marker._leaflet_id&&(markerIndexToRemove=i);markers.splice(markerIndexToRemove,1);var opts=getOptionsForMap(map);opts.scaleToFit&&opts.scaleToFitAll&&fitMapToMarkers(map)}function debounce(func,wait,immediate){var timeout;return function(){var context=this,args=arguments,later=function(){timeout=null,immediate||func.apply(context,args)},callNow=immediate&&!timeout;clearTimeout(timeout),timeout=setTimeout(later,wait),callNow&&func.apply(context,args)}}function getMarkers(){return _markers[0]}function getOptionsForMap(){return _mapOptions[0]}var _mapInstances=[],_markers=[],_mapOptions=[],fitMapToMarkers=debounce(function(){var map=_mapInstances[0],group=new L.featureGroup(getMarkers());map.fitBounds(group.getBounds())},0),service={init:init,getMapInstances:getMapInstances,addMapInstance:addMapInstance,getMarkers:getMarkers,addMarker:addMarker,removeMarker:removeMarker,fitMapToMarkers:fitMapToMarkers,getOptionsForMap:getOptionsForMap};return service}angular.module("angular-mapbox").service("mapboxService",mapboxService)}(),function(){"use strict";angular.module("angular-mapbox").directive("featureLayer",function(){return{restrict:"E",require:"^mapbox",link:function(scope,element,attrs,controller){attrs.data?controller.getMap().then(function(map){var geojsonObject=scope.$eval(attrs.data),featureLayer=L.mapbox.featureLayer(geojsonObject).addTo(map);controller.$scope.featureLayers.push(featureLayer)}):attrs.url&&controller.getMap().then(function(map){var featureLayer=L.mapbox.featureLayer().addTo(map);featureLayer.loadURL(attrs.url),controller.$scope.featureLayers.push(featureLayer)})}}})}(),function(){"use strict";angular.module("angular-mapbox").directive("mapbox",["$compile","$q","mapboxService",function($compile,$q,mapboxService){var _mapboxMap;return{restrict:"E",transclude:!0,scope:!0,replace:!0,link:function(scope,element,attrs){scope.map=L.mapbox.map(element[0],attrs.mapId),_mapboxMap.resolve(scope.map);var mapOptions={clusterMarkers:void 0!==attrs.clusterMarkers,scaleToFit:void 0!==attrs.scaleToFit,scaleToFitAll:"all"===attrs.scaleToFit};mapboxService.addMapInstance(scope.map,mapOptions);var mapWidth=attrs.width||500,mapHeight=attrs.height||500;element.css("width",mapWidth+"px"),element.css("height",mapHeight+"px");var zoom=attrs.zoom||12;attrs.lat&&attrs.lng&&scope.map.setView([attrs.lat,attrs.lng],zoom),attrs.onReposition&&scope.map.on("dragend",function(){scope[attrs.onReposition](scope.map.getBounds())}),attrs.onZoom&&scope.map.on("zoomend",function(){scope[attrs.onZoom](scope.map.getBounds())})},template:'<div class="angular-mapbox-map" ng-transclude></div>',controller:["$scope","mapboxService",function($scope,mapboxService){$scope.markers=mapboxService.getMarkers(),$scope.featureLayers=[],_mapboxMap=$q.defer(),$scope.getMap=this.getMap=function(){return _mapboxMap.promise},L.MarkerClusterGroup&&($scope.clusterGroup=new L.MarkerClusterGroup,this.getMap().then(function(map){map.addLayer($scope.clusterGroup)})),this.$scope=$scope}]}}])}(),function(){"use strict";angular.module("angular-mapbox").directive("marker",["$compile","$timeout","mapboxService",function($compile,$timeout,mapboxService){function link(scope,element,attrs,controller,transclude){var _marker,_opts,_style;_opts={draggable:void 0!==attrs.draggable},_style=setStyleOptions(attrs),controller.getMap().then(function(map){transclude(scope,function(transcludedContent){var popupContentElement;if(transcludedContent){popupContentElement=document.createElement("span");for(var i=0;i<transcludedContent.length;i++)popupContentElement.appendChild(transcludedContent[i])}void 0!==attrs.currentLocation?(_style=setStyleOptions(_style,{"marker-color":"#000","marker-symbol":"star"}),_opts.excludeFromClustering=!0,map.on("locationfound",function(e){_marker=addMarker(scope,map,[e.latlng.lat,e.latlng.lng],popupContentElement,_opts,_style)}),map.locate()):_marker=addMarker(scope,map,[attrs.lat,attrs.lng],popupContentElement,_opts,_style)}),element.bind("$destroy",function(){mapboxService.getOptionsForMap(map).clusterMarkers?scope.clusterGroup.removeLayer(_marker):mapboxService.removeMarker(map,_marker)})})}function setStyleOptions(attrs,defaultOpts){var opts=defaultOpts||{};return attrs.size&&(opts["marker-size"]=attrs.size),attrs.color&&(opts["marker-color"]="#"===attrs.color[0]?attrs.color:_colors[attrs.color]||attrs.color),attrs.icon&&(opts["marker-symbol"]=attrs.icon),opts}function addMarker(scope,map,latlng,popupContent,opts,style){opts=opts||{};var marker=L.mapbox.marker.style({properties:style},latlng);return popupContent&&marker.bindPopup(popupContent),mapboxService.getOptionsForMap(map).clusterMarkers&&opts.excludeFromClustering!==!0?scope.clusterGroup.addLayer(marker):marker.addTo(map),opts.draggable&&marker.dragging.enable(),mapboxService.addMarker(marker),marker}var _colors={navy:"#001f3f",blue:"#0074d9",aqua:"#7fdbff",teal:"#39cccc",olive:"#3d9970",green:"#2ecc40",lime:"#01ff70",yellow:"#ffdc00",orange:"#ff851b",red:"#ff4136",fuchsia:"#f012be",purple:"#b10dc9",maroon:"#85144b",white:"white",silver:"#dddddd",gray:"#aaaaaa",black:"#111111"};return{restrict:"E",require:"^mapbox",transclude:!0,scope:!0,link:link}}])}();