/*!
 * Angular Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.0.0-rc7-master-f376178
 */
function VirtualRepeatContainerDirective(){return{controller:VirtualRepeatContainerController,template:virtualRepeatContainerTemplate,compile:function(t,e){t.addClass("md-virtual-repeat-container").addClass(e.hasOwnProperty("mdOrientHorizontal")?"md-orient-horizontal":"md-orient-vertical")}}}function virtualRepeatContainerTemplate(t){return'<div class="md-virtual-repeat-scroller"><div class="md-virtual-repeat-sizer"></div><div class="md-virtual-repeat-offsetter">'+t[0].innerHTML+"</div></div>"}function VirtualRepeatContainerController(t,e,i,r,s,n,o,a){this.$rootScope=r,this.$scope=n,this.$element=o,this.$attrs=a,this.size=0,this.scrollSize=0,this.scrollOffset=0,this.horizontal=this.$attrs.hasOwnProperty("mdOrientHorizontal"),this.repeater=null,this.autoShrink=this.$attrs.hasOwnProperty("mdAutoShrink"),this.autoShrinkMin=parseInt(this.$attrs.mdAutoShrinkMin,10)||0,this.originalSize=null,this.offsetSize=parseInt(this.$attrs.mdOffsetSize,10)||0,this.$attrs.mdTopIndex?(this.bindTopIndex=i(this.$attrs.mdTopIndex),this.topIndex=this.bindTopIndex(this.$scope),angular.isDefined(this.topIndex)||(this.topIndex=0,this.bindTopIndex.assign(this.$scope,0)),this.$scope.$watch(this.bindTopIndex,angular.bind(this,function(t){t!==this.topIndex&&this.scrollToIndex(t)}))):this.topIndex=0,this.scroller=o[0].getElementsByClassName("md-virtual-repeat-scroller")[0],this.sizer=this.scroller.getElementsByClassName("md-virtual-repeat-sizer")[0],this.offsetter=this.scroller.getElementsByClassName("md-virtual-repeat-offsetter")[0];var l=angular.bind(this,this.updateSize);t(angular.bind(this,function(){l();var t=e.debounce(l,10,null,!1),i=angular.element(s);this.size||t(),i.on("resize",t),n.$on("$destroy",function(){i.off("resize",t)}),n.$emit("$md-resize-enable"),n.$on("$md-resize",l)}))}function VirtualRepeatDirective(t){return{controller:VirtualRepeatController,priority:1e3,require:["mdVirtualRepeat","^^mdVirtualRepeatContainer"],restrict:"A",terminal:!0,transclude:"element",compile:function(e,i){var r=i.mdVirtualRepeat,s=r.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)\s*$/),n=s[1],o=t(s[2]),a=i.mdExtraName&&t(i.mdExtraName);return function(t,e,i,r,s){r[0].link_(r[1],s,n,o,a)}}}}function VirtualRepeatController(t,e,i,r,s,n,o){this.$scope=t,this.$element=e,this.$attrs=i,this.$browser=r,this.$document=s,this.$rootScope=n,this.$$rAF=o,this.onDemand=i.hasOwnProperty("mdOnDemand"),this.browserCheckUrlChange=r.$$checkUrlChange,this.newStartIndex=0,this.newEndIndex=0,this.newVisibleEnd=0,this.startIndex=0,this.endIndex=0,this.itemSize=t.$eval(i.mdItemSize)||null,this.isFirstRender=!0,this.isVirtualRepeatUpdating_=!1,this.itemsLength=0,this.unwatchItemSize_=angular.noop,this.blocks={},this.pooledBlocks=[]}function VirtualRepeatModelArrayLike(t){if(!angular.isFunction(t.getItemAtIndex)||!angular.isFunction(t.getLength))throw Error("When md-on-demand is enabled, the Object passed to md-virtual-repeat must implement functions getItemAtIndex() and getLength() ");this.model=t}function abstractMethod(){throw Error("Non-overridden abstract method called.")}goog.provide("ng.material.components.virtualRepeat"),goog.require("ng.material.components.showHide"),goog.require("ng.material.core"),angular.module("material.components.virtualRepeat",["material.core","material.components.showHide"]).directive("mdVirtualRepeatContainer",VirtualRepeatContainerDirective).directive("mdVirtualRepeat",VirtualRepeatDirective);var MAX_ELEMENT_SIZE=1533917,NUM_EXTRA=3;VirtualRepeatContainerController.$inject=["$$rAF","$mdUtil","$parse","$rootScope","$window","$scope","$element","$attrs"],VirtualRepeatContainerController.prototype.register=function(t){this.repeater=t,angular.element(this.scroller).on("scroll wheel touchmove touchend",angular.bind(this,this.handleScroll_))},VirtualRepeatContainerController.prototype.isHorizontal=function(){return this.horizontal},VirtualRepeatContainerController.prototype.getSize=function(){return this.size},VirtualRepeatContainerController.prototype.setSize_=function(t){this.size=t,this.$element[0].style[this.isHorizontal()?"width":"height"]=t+"px"},VirtualRepeatContainerController.prototype.updateSize=function(){this.originalSize||(this.size=this.isHorizontal()?this.$element[0].clientWidth:this.$element[0].clientHeight,this.repeater&&this.repeater.containerUpdated())},VirtualRepeatContainerController.prototype.getScrollSize=function(){return this.scrollSize},VirtualRepeatContainerController.prototype.sizeScroller_=function(t){var e=this.isHorizontal()?"width":"height",i=this.isHorizontal()?"height":"width";if(this.sizer.innerHTML="",MAX_ELEMENT_SIZE>t)this.sizer.style[e]=t+"px";else{this.sizer.style[e]="auto",this.sizer.style[i]="auto";var r=Math.floor(t/MAX_ELEMENT_SIZE),s=document.createElement("div");s.style[e]=MAX_ELEMENT_SIZE+"px",s.style[i]="1px";for(var n=0;r>n;n++)this.sizer.appendChild(s.cloneNode(!1));s.style[e]=t-r*MAX_ELEMENT_SIZE+"px",this.sizer.appendChild(s)}},VirtualRepeatContainerController.prototype.autoShrink_=function(t){var e=Math.max(t,this.autoShrinkMin*this.repeater.getItemSize());if(this.autoShrink&&e!==this.size){var i=this.originalSize||this.size;!i||i>e?(this.originalSize||(this.originalSize=this.size),this.setSize_(e)):this.originalSize&&(this.setSize_(this.originalSize),this.originalSize=null),this.repeater.containerUpdated()}},VirtualRepeatContainerController.prototype.setScrollSize=function(t){var e=t+this.offsetSize;this.scrollSize!==e&&(this.sizeScroller_(e),this.autoShrink_(e),this.scrollSize=e)},VirtualRepeatContainerController.prototype.getScrollOffset=function(){return this.scrollOffset},VirtualRepeatContainerController.prototype.scrollTo=function(t){this.scroller[this.isHorizontal()?"scrollLeft":"scrollTop"]=t,this.handleScroll_()},VirtualRepeatContainerController.prototype.scrollToIndex=function(t){var e=this.repeater.getItemSize(),i=this.repeater.itemsLength;t>i&&(t=i-1),this.scrollTo(e*t)},VirtualRepeatContainerController.prototype.resetScroll=function(){this.scrollTo(0)},VirtualRepeatContainerController.prototype.handleScroll_=function(){var t=this.isHorizontal()?this.scroller.scrollLeft:this.scroller.scrollTop;if(t!==this.scrollOffset){var e=this.repeater.getItemSize();if(e){var i=Math.max(0,Math.floor(t/e)-NUM_EXTRA),r=this.isHorizontal()?"translateX(":"translateY(";if(r+=i*e+"px)",this.scrollOffset=t,this.offsetter.style.webkitTransform=r,this.offsetter.style.transform=r,this.bindTopIndex){var s=Math.floor(t/e);s!==this.topIndex&&s<this.repeater.itemsLength&&(this.topIndex=s,this.bindTopIndex.assign(this.$scope,s),this.$rootScope.$$phase||this.$scope.$digest())}this.repeater.containerUpdated()}}},VirtualRepeatDirective.$inject=["$parse"],VirtualRepeatController.$inject=["$scope","$element","$attrs","$browser","$document","$rootScope","$$rAF"],VirtualRepeatController.Block,VirtualRepeatController.prototype.link_=function(t,e,i,r,s){this.container=t,this.transclude=e,this.repeatName=i,this.rawRepeatListExpression=r,this.extraName=s,this.sized=!1,this.repeatListExpression=angular.bind(this,this.repeatListExpression_),this.container.register(this)},VirtualRepeatController.prototype.readItemSize_=function(){if(!this.itemSize){this.items=this.repeatListExpression(this.$scope),this.parentNode=this.$element[0].parentNode;var t=this.getBlock_(0);t.element[0].parentNode||this.parentNode.appendChild(t.element[0]),this.itemSize=t.element[0][this.container.isHorizontal()?"offsetWidth":"offsetHeight"]||null,this.blocks[0]=t,this.poolBlock_(0),this.itemSize&&this.containerUpdated()}},VirtualRepeatController.prototype.repeatListExpression_=function(t){var e=this.rawRepeatListExpression(t);if(this.onDemand&&e){var i=new VirtualRepeatModelArrayLike(e);return i.$$includeIndexes(this.newStartIndex,this.newVisibleEnd),i}return e},VirtualRepeatController.prototype.containerUpdated=function(){return this.itemSize?(this.sized||(this.items=this.repeatListExpression(this.$scope)),this.sized||(this.unwatchItemSize_(),this.sized=!0,this.$scope.$watchCollection(this.repeatListExpression,angular.bind(this,function(t,e){this.isVirtualRepeatUpdating_||this.virtualRepeatUpdate_(t,e)}))),this.updateIndexes_(),void((this.newStartIndex!==this.startIndex||this.newEndIndex!==this.endIndex||this.container.getScrollOffset()>this.container.getScrollSize())&&(this.items instanceof VirtualRepeatModelArrayLike&&this.items.$$includeIndexes(this.newStartIndex,this.newEndIndex),this.virtualRepeatUpdate_(this.items,this.items)))):(this.unwatchItemSize_=this.$scope.$watchCollection(this.repeatListExpression,angular.bind(this,function(t){t&&t.length&&this.$$rAF(angular.bind(this,this.readItemSize_))})),void(this.$rootScope.$$phase||this.$scope.$digest()))},VirtualRepeatController.prototype.getItemSize=function(){return this.itemSize},VirtualRepeatController.prototype.virtualRepeatUpdate_=function(t,e){this.isVirtualRepeatUpdating_=!0;var i=t&&t.length||0,r=!1;if(this.items&&i<this.items.length&&0!==this.container.getScrollOffset())return this.items=t,void this.container.resetScroll();if(i!==this.itemsLength&&(r=!0,this.itemsLength=i),this.items=t,(t!==e||r)&&this.updateIndexes_(),this.parentNode=this.$element[0].parentNode,r&&this.container.setScrollSize(i*this.itemSize),this.isFirstRender){this.isFirstRender=!1;var s=this.$attrs.mdStartIndex?this.$scope.$eval(this.$attrs.mdStartIndex):this.container.topIndex;this.container.scrollToIndex(s)}Object.keys(this.blocks).forEach(function(t){var e=parseInt(t,10);(e<this.newStartIndex||e>=this.newEndIndex)&&this.poolBlock_(e)},this),this.$browser.$$checkUrlChange=angular.noop;var n,o,a=[],l=[];for(n=this.newStartIndex;n<this.newEndIndex&&null==this.blocks[n];n++)o=this.getBlock_(n),this.updateBlock_(o,n),a.push(o);for(;null!=this.blocks[n];n++)this.updateBlock_(this.blocks[n],n);for(var h=n-1;n<this.newEndIndex;n++)o=this.getBlock_(n),this.updateBlock_(o,n),l.push(o);a.length&&this.parentNode.insertBefore(this.domFragmentFromBlocks_(a),this.$element[0].nextSibling),l.length&&this.parentNode.insertBefore(this.domFragmentFromBlocks_(l),this.blocks[h]&&this.blocks[h].element[0].nextSibling),this.$browser.$$checkUrlChange=this.browserCheckUrlChange,this.startIndex=this.newStartIndex,this.endIndex=this.newEndIndex,this.isVirtualRepeatUpdating_=!1},VirtualRepeatController.prototype.getBlock_=function(t){if(this.pooledBlocks.length)return this.pooledBlocks.pop();var e;return this.transclude(angular.bind(this,function(i,r){e={element:i,"new":!0,scope:r},this.updateScope_(r,t),this.parentNode.appendChild(i[0])})),e},VirtualRepeatController.prototype.updateBlock_=function(t,e){this.blocks[e]=t,(t["new"]||t.scope.$index!==e||t.scope[this.repeatName]!==this.items[e])&&(t["new"]=!1,this.updateScope_(t.scope,e),this.$rootScope.$$phase||t.scope.$digest())},VirtualRepeatController.prototype.updateScope_=function(t,e){t.$index=e,t[this.repeatName]=this.items&&this.items[e],this.extraName&&(t[this.extraName(this.$scope)]=this.items[e])},VirtualRepeatController.prototype.poolBlock_=function(t){this.pooledBlocks.push(this.blocks[t]),this.parentNode.removeChild(this.blocks[t].element[0]),delete this.blocks[t]},VirtualRepeatController.prototype.domFragmentFromBlocks_=function(t){var e=this.$document[0].createDocumentFragment();return t.forEach(function(t){e.appendChild(t.element[0])}),e},VirtualRepeatController.prototype.updateIndexes_=function(){var t=this.items?this.items.length:0,e=Math.ceil(this.container.getSize()/this.itemSize);this.newStartIndex=Math.max(0,Math.min(t-e,Math.floor(this.container.getScrollOffset()/this.itemSize))),this.newVisibleEnd=this.newStartIndex+e+NUM_EXTRA,this.newEndIndex=Math.min(t,this.newVisibleEnd),this.newStartIndex=Math.max(0,this.newStartIndex-NUM_EXTRA)},VirtualRepeatModelArrayLike.prototype.$$includeIndexes=function(t,e){for(var i=t;e>i;i++)this.hasOwnProperty(i)||(this[i]=this.model.getItemAtIndex(i));this.length=this.model.getLength()},ng.material.components.virtualRepeat=angular.module("material.components.virtualRepeat");