/*!
 * Angular Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.1.0-rc4-master-88f2e3f
 */
goog.provide("ng.material.components.datepicker"),goog.require("ng.material.components.icon"),goog.require("ng.material.components.virtualRepeat"),goog.require("ng.material.core"),function(){"use strict";function t(){return{template:function(t,e){var a=e.hasOwnProperty("ngIf")?"":'ng-if="calendarCtrl.isInitialized"',n='<div ng-switch="calendarCtrl.currentView" '+a+'><md-calendar-year ng-switch-when="year"></md-calendar-year><md-calendar-month ng-switch-default></md-calendar-month></div>';return n},scope:{minDate:"=mdMinDate",maxDate:"=mdMaxDate",dateFilter:"=mdDateFilter"},require:["ngModel","mdCalendar"],controller:e,controllerAs:"calendarCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1];r.configureNgModel(i)}}}function e(t,e,a,i,r,l,s,d){l(t),this.$element=t,this.$scope=e,this.dateUtil=a,this.$mdUtil=i,this.keyCode=r.KEY_CODE,this.$$rAF=s,this.today=this.dateUtil.createDateAtMidnight(),this.ngModelCtrl=null,this.currentView="month",this.SELECTED_DATE_CLASS="md-calendar-selected-date",this.TODAY_CLASS="md-calendar-date-today",this.FOCUSED_DATE_CLASS="md-focus",this.id=n++,this.displayDate=null,this.selectedDate=null,this.isInitialized=!1,this.width=0,this.scrollbarWidth=0,d.tabindex||t.attr("tabindex","-1"),t.on("keydown",angular.bind(this,this.handleKeyEvent))}angular.module("material.components.datepicker",["material.core","material.components.icon","material.components.virtualRepeat"]).directive("mdCalendar",t);var a=340,n=0;e.$inject=["$element","$scope","$$mdDateUtil","$mdUtil","$mdConstant","$mdTheming","$$rAF","$attrs"],e.prototype.configureNgModel=function(t){var e=this;e.ngModelCtrl=t,e.$mdUtil.nextTick(function(){e.isInitialized=!0}),t.$render=function(){var t=this.$viewValue;e.$scope.$broadcast("md-calendar-parent-changed",t),e.selectedDate||(e.selectedDate=t),e.displayDate||(e.displayDate=e.selectedDate||e.today)}},e.prototype.setNgModelValue=function(t){var e=this.dateUtil.createDateAtMidnight(t);return this.focus(e),this.$scope.$emit("md-calendar-change",e),this.ngModelCtrl.$setViewValue(e),this.ngModelCtrl.$render(),e},e.prototype.setCurrentView=function(t,e){var a=this;a.$mdUtil.nextTick(function(){a.currentView=t,e&&(a.displayDate=angular.isDate(e)?e:new Date(e))})},e.prototype.focus=function(t){if(this.dateUtil.isValidDate(t)){var e=this.$element[0].querySelector(".md-focus");e&&e.classList.remove(this.FOCUSED_DATE_CLASS);var a=this.getDateId(t,this.currentView),n=document.getElementById(a);n&&(n.classList.add(this.FOCUSED_DATE_CLASS),n.focus(),this.displayDate=t)}else{var i=this.$element[0].querySelector("[ng-switch]");i&&i.focus()}},e.prototype.getActionFromKeyEvent=function(t){var e=this.keyCode;switch(t.which){case e.ENTER:return"select";case e.RIGHT_ARROW:return"move-right";case e.LEFT_ARROW:return"move-left";case e.DOWN_ARROW:return t.metaKey?"move-page-down":"move-row-down";case e.UP_ARROW:return t.metaKey?"move-page-up":"move-row-up";case e.PAGE_DOWN:return"move-page-down";case e.PAGE_UP:return"move-page-up";case e.HOME:return"start";case e.END:return"end";default:return null}},e.prototype.handleKeyEvent=function(t){var e=this;this.$scope.$apply(function(){if(t.which==e.keyCode.ESCAPE||t.which==e.keyCode.TAB)return e.$scope.$emit("md-calendar-close"),void(t.which==e.keyCode.TAB&&t.preventDefault());var a=e.getActionFromKeyEvent(t);a&&(t.preventDefault(),t.stopPropagation(),e.$scope.$broadcast("md-calendar-parent-action",a))})},e.prototype.hideVerticalScrollbar=function(t){function e(){var e=n.width||a,i=n.scrollbarWidth,l=t.calendarScroller;r.style.width=e+"px",l.style.width=e+i+"px",l.style.paddingRight=i+"px"}var n=this,i=t.$element[0],r=i.querySelector(".md-calendar-scroll-mask");n.width>0?e():n.$$rAF(function(){var a=t.calendarScroller;n.scrollbarWidth=a.offsetWidth-a.clientWidth,n.width=i.querySelector("table").offsetWidth,e()})},e.prototype.getDateId=function(t,e){if(!e)throw new Error("A namespace for the date id has to be specified.");return["md",this.id,e,t.getFullYear(),t.getMonth(),t.getDate()].join("-")}}(),function(){"use strict";function t(){return{template:'<table aria-hidden="true" class="md-calendar-day-header"><thead></thead></table><div class="md-calendar-scroll-mask"><md-virtual-repeat-container class="md-calendar-scroll-container" md-offset-size="'+(n-a)+'"><table role="grid" tabindex="0" class="md-calendar" aria-readonly="true"><tbody md-calendar-month-body role="rowgroup" md-virtual-repeat="i in monthCtrl.items" md-month-offset="$index" class="md-calendar-month" md-start-index="monthCtrl.getSelectedMonthIndex()" md-item-size="'+a+'"></tbody></table></md-virtual-repeat-container></div>',require:["^^mdCalendar","mdCalendarMonth"],controller:e,controllerAs:"monthCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1];r.initialize(i)}}}function e(t,e,a,n,i,r){this.$element=t,this.$scope=e,this.$animate=a,this.$q=n,this.dateUtil=i,this.dateLocale=r,this.calendarScroller=t[0].querySelector(".md-virtual-repeat-scroller"),this.firstRenderableDate=null,this.isInitialized=!1,this.isMonthTransitionInProgress=!1;var l=this;this.cellClickHandler=function(){var t=i.getTimestampFromNode(this);l.$scope.$apply(function(){l.calendarCtrl.setNgModelValue(t)})},this.headerClickHandler=function(){l.calendarCtrl.setCurrentView("year",i.getTimestampFromNode(this))}}angular.module("material.components.datepicker").directive("mdCalendarMonth",t);var a=265,n=45;e.$inject=["$element","$scope","$animate","$q","$$mdDateUtil","$mdDateLocale"],e.prototype.initialize=function(t){var e=t.minDate,a=t.maxDate;if(this.calendarCtrl=t,this.items={length:2e3},a&&e){var n=this.dateUtil.getMonthDistance(e,a)+1;n=Math.max(n,1),n+=1,this.items.length=n}if(this.firstRenderableDate=this.dateUtil.incrementMonths(t.today,-this.items.length/2),e&&e>this.firstRenderableDate)this.firstRenderableDate=e;else if(a){this.items.length-2;this.firstRenderableDate=this.dateUtil.incrementMonths(a,-(this.items.length-2))}this.attachScopeListeners(),t.ngModelCtrl&&t.ngModelCtrl.$render()},e.prototype.getSelectedMonthIndex=function(){var t=this.calendarCtrl;return this.dateUtil.getMonthDistance(this.firstRenderableDate,t.displayDate||t.selectedDate||t.today)},e.prototype.changeSelectedDate=function(t){var e=this,a=e.calendarCtrl,n=a.selectedDate;a.selectedDate=t,this.changeDisplayDate(t).then(function(){var e=a.SELECTED_DATE_CLASS,i="month";if(n){var r=document.getElementById(a.getDateId(n,i));r&&(r.classList.remove(e),r.setAttribute("aria-selected","false"))}if(t){var l=document.getElementById(a.getDateId(t,i));l&&(l.classList.add(e),l.setAttribute("aria-selected","true"))}})},e.prototype.changeDisplayDate=function(t){if(!this.isInitialized)return this.buildWeekHeader(),this.calendarCtrl.hideVerticalScrollbar(this),this.isInitialized=!0,this.$q.when();if(!this.dateUtil.isValidDate(t)||this.isMonthTransitionInProgress)return this.$q.when();this.isMonthTransitionInProgress=!0;var e=this.animateDateChange(t);this.calendarCtrl.displayDate=t;var a=this;return e.then(function(){a.isMonthTransitionInProgress=!1}),e},e.prototype.animateDateChange=function(t){if(this.dateUtil.isValidDate(t)){var e=this.dateUtil.getMonthDistance(this.firstRenderableDate,t);this.calendarScroller.scrollTop=e*a}return this.$q.when()},e.prototype.buildWeekHeader=function(){for(var t=this.dateLocale.firstDayOfWeek,e=this.dateLocale.shortDays,a=document.createElement("tr"),n=0;7>n;n++){var i=document.createElement("th");i.textContent=e[(n+t)%7],a.appendChild(i)}this.$element.find("thead").append(a)},e.prototype.attachScopeListeners=function(){var t=this;t.$scope.$on("md-calendar-parent-changed",function(e,a){t.changeSelectedDate(a)}),t.$scope.$on("md-calendar-parent-action",angular.bind(this,this.handleKeyEvent))},e.prototype.handleKeyEvent=function(t,e){var a=this.calendarCtrl,n=a.displayDate;if("select"===e)a.setNgModelValue(n);else{var i=null,r=this.dateUtil;switch(e){case"move-right":i=r.incrementDays(n,1);break;case"move-left":i=r.incrementDays(n,-1);break;case"move-page-down":i=r.incrementMonths(n,1);break;case"move-page-up":i=r.incrementMonths(n,-1);break;case"move-row-down":i=r.incrementDays(n,7);break;case"move-row-up":i=r.incrementDays(n,-7);break;case"start":i=r.getFirstDateOfMonth(n);break;case"end":i=r.getLastDateOfMonth(n)}i&&(i=this.dateUtil.clampDate(i,a.minDate,a.maxDate),this.changeDisplayDate(i).then(function(){a.focus(i)}))}}}(),function(){"use strict";function t(){return{require:["^^mdCalendar","^^mdCalendarMonth","mdCalendarMonthBody"],scope:{offset:"=mdMonthOffset"},controller:e,controllerAs:"mdMonthBodyCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1],l=n[2];l.calendarCtrl=i,l.monthCtrl=r,l.generateContent(),t.$watch(function(){return l.offset},function(t,e){t!=e&&l.generateContent()})}}}function e(t,e,a){this.$element=t,this.dateUtil=e,this.dateLocale=a,this.monthCtrl=null,this.calendarCtrl=null,this.offset=null,this.focusAfterAppend=null}angular.module("material.components.datepicker").directive("mdCalendarMonthBody",t),e.$inject=["$element","$$mdDateUtil","$mdDateLocale"],e.prototype.generateContent=function(){var t=this.dateUtil.incrementMonths(this.monthCtrl.firstRenderableDate,this.offset);this.$element.empty(),this.$element.append(this.buildCalendarForMonth(t)),this.focusAfterAppend&&(this.focusAfterAppend.classList.add(this.calendarCtrl.FOCUSED_DATE_CLASS),this.focusAfterAppend.focus(),this.focusAfterAppend=null)},e.prototype.buildDateCell=function(t){var e=this.monthCtrl,a=this.calendarCtrl,n=document.createElement("td");if(n.tabIndex=-1,n.classList.add("md-calendar-date"),n.setAttribute("role","gridcell"),t){n.setAttribute("tabindex","-1"),n.setAttribute("aria-label",this.dateLocale.longDateFormatter(t)),n.id=a.getDateId(t,"month"),n.setAttribute("data-timestamp",t.getTime()),this.dateUtil.isSameDay(t,a.today)&&n.classList.add(a.TODAY_CLASS),this.dateUtil.isValidDate(a.selectedDate)&&this.dateUtil.isSameDay(t,a.selectedDate)&&(n.classList.add(a.SELECTED_DATE_CLASS),n.setAttribute("aria-selected","true"));var i=this.dateLocale.dates[t.getDate()];if(this.isDateEnabled(t)){var r=document.createElement("span");r.classList.add("md-calendar-date-selection-indicator"),r.textContent=i,n.appendChild(r),n.addEventListener("click",e.cellClickHandler),a.displayDate&&this.dateUtil.isSameDay(t,a.displayDate)&&(this.focusAfterAppend=n)}else n.classList.add("md-calendar-date-disabled"),n.textContent=i}return n},e.prototype.isDateEnabled=function(t){return this.dateUtil.isDateWithinRange(t,this.calendarCtrl.minDate,this.calendarCtrl.maxDate)&&(!angular.isFunction(this.calendarCtrl.dateFilter)||this.calendarCtrl.dateFilter(t))},e.prototype.buildDateRow=function(t){var e=document.createElement("tr");return e.setAttribute("role","row"),e.setAttribute("aria-label",this.dateLocale.weekNumberFormatter(t)),e},e.prototype.buildCalendarForMonth=function(t){var e=this.dateUtil.isValidDate(t)?t:new Date,a=this.dateUtil.getFirstDateOfMonth(e),n=this.getLocaleDay_(a),i=this.dateUtil.getNumberOfDaysInMonth(e),r=document.createDocumentFragment(),l=1,s=this.buildDateRow(l);r.appendChild(s);var d=this.offset===this.monthCtrl.items.length-1,o=0,c=document.createElement("td");if(c.textContent=this.dateLocale.monthHeaderFormatter(e),c.classList.add("md-calendar-month-label"),this.calendarCtrl.maxDate&&a>this.calendarCtrl.maxDate?c.classList.add("md-calendar-month-label-disabled"):(c.addEventListener("click",this.monthCtrl.headerClickHandler),c.setAttribute("data-timestamp",a.getTime()),c.setAttribute("aria-label",this.dateLocale.monthFormatter(e))),2>=n){c.setAttribute("colspan","7");var h=this.buildDateRow();if(h.appendChild(c),r.insertBefore(h,s),d)return r}else o=2,c.setAttribute("colspan","2"),s.appendChild(c);for(var u=o;n>u;u++)s.appendChild(this.buildDateCell());for(var m=n,p=a,f=1;i>=f;f++){if(7===m){if(d)return r;m=0,l++,s=this.buildDateRow(l),r.appendChild(s)}p.setDate(f);var g=this.buildDateCell(p);s.appendChild(g),m++}for(;s.childNodes.length<7;)s.appendChild(this.buildDateCell());for(;r.childNodes.length<6;){for(var D=this.buildDateRow(),C=0;7>C;C++)D.appendChild(this.buildDateCell());r.appendChild(D)}return r},e.prototype.getLocaleDay_=function(t){return(t.getDay()+(7-this.dateLocale.firstDayOfWeek))%7}}(),function(){"use strict";function t(){return{template:'<div class="md-calendar-scroll-mask"><md-virtual-repeat-container class="md-calendar-scroll-container"><table role="grid" tabindex="0" class="md-calendar" aria-readonly="true"><tbody md-calendar-year-body role="rowgroup" md-virtual-repeat="i in yearCtrl.items" md-year-offset="$index" class="md-calendar-year" md-start-index="yearCtrl.getFocusedYearIndex()" md-item-size="'+a+'"></tbody></table></md-virtual-repeat-container></div>',require:["^^mdCalendar","mdCalendarYear"],controller:e,controllerAs:"yearCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1];r.initialize(i)}}}function e(t,e,a,n,i,r){this.$element=t,this.$scope=e,this.$animate=a,this.$q=n,this.dateUtil=i,this.$timeout=r,this.calendarScroller=t[0].querySelector(".md-virtual-repeat-scroller"),this.firstRenderableDate=null,this.isInitialized=!1,this.isMonthTransitionInProgress=!1;var l=this;this.cellClickHandler=function(){l.calendarCtrl.setCurrentView("month",i.getTimestampFromNode(this))}}angular.module("material.components.datepicker").directive("mdCalendarYear",t);var a=88;e.$inject=["$element","$scope","$animate","$q","$$mdDateUtil","$timeout"],e.prototype.initialize=function(t){var e=t.minDate,a=t.maxDate;if(this.calendarCtrl=t,this.items={length:400},a&&e){var n=this.dateUtil.getYearDistance(e,a)+1;this.items.length=Math.max(n,1)}this.firstRenderableDate=this.dateUtil.incrementYears(t.today,-(this.items.length/2)),e&&e>this.firstRenderableDate?this.firstRenderableDate=e:a&&(this.firstRenderableDate=this.dateUtil.incrementMonths(a,-(this.items.length-1))),(e||a)&&this.$timeout(),this.attachScopeListeners(),t.ngModelCtrl&&t.ngModelCtrl.$render()},e.prototype.getFocusedYearIndex=function(){var t=this.calendarCtrl;return this.dateUtil.getYearDistance(this.firstRenderableDate,t.displayDate||t.selectedDate||t.today)},e.prototype.changeDate=function(t){if(!this.isInitialized)return this.calendarCtrl.hideVerticalScrollbar(this),this.isInitialized=!0,this.$q.when();if(this.dateUtil.isValidDate(t)&&!this.isMonthTransitionInProgress){var e=this,a=this.animateDateChange(t);return e.isMonthTransitionInProgress=!0,e.calendarCtrl.displayDate=t,a.then(function(){e.isMonthTransitionInProgress=!1})}},e.prototype.animateDateChange=function(t){if(this.dateUtil.isValidDate(t)){var e=this.dateUtil.getYearDistance(this.firstRenderableDate,t);this.calendarScroller.scrollTop=e*a}return this.$q.when()},e.prototype.handleKeyEvent=function(t,e){var a=this.calendarCtrl,n=a.displayDate;if("select"===e)this.changeDate(n).then(function(){a.setCurrentView("month",n),a.focus(n)});else{var i=null,r=this.dateUtil;switch(e){case"move-right":i=r.incrementMonths(n,1);break;case"move-left":i=r.incrementMonths(n,-1);break;case"move-row-down":i=r.incrementMonths(n,6);break;case"move-row-up":i=r.incrementMonths(n,-6)}if(i){var l=a.minDate?r.incrementMonths(r.getFirstDateOfMonth(a.minDate),1):null,s=a.maxDate?r.getFirstDateOfMonth(a.maxDate):null;i=r.getFirstDateOfMonth(this.dateUtil.clampDate(i,l,s)),this.changeDate(i).then(function(){a.focus(i)})}}},e.prototype.attachScopeListeners=function(){var t=this;t.$scope.$on("md-calendar-parent-changed",function(e,a){t.changeDate(a)}),t.$scope.$on("md-calendar-parent-action",angular.bind(t,t.handleKeyEvent))}}(),function(){"use strict";function t(){return{require:["^^mdCalendar","^^mdCalendarYear","mdCalendarYearBody"],scope:{offset:"=mdYearOffset"},controller:e,controllerAs:"mdYearBodyCtrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1],l=n[2];l.calendarCtrl=i,l.yearCtrl=r,l.generateContent(),t.$watch(function(){return l.offset},function(t,e){t!=e&&l.generateContent()})}}}function e(t,e,a){this.$element=t,this.dateUtil=e,this.dateLocale=a,this.calendarCtrl=null,this.yearCtrl=null,this.offset=null,this.focusAfterAppend=null}angular.module("material.components.datepicker").directive("mdCalendarYearBody",t),e.$inject=["$element","$$mdDateUtil","$mdDateLocale"],e.prototype.generateContent=function(){var t=this.dateUtil.incrementYears(this.yearCtrl.firstRenderableDate,this.offset);this.$element.empty(),this.$element.append(this.buildCalendarForYear(t)),this.focusAfterAppend&&(this.focusAfterAppend.classList.add(this.calendarCtrl.FOCUSED_DATE_CLASS),this.focusAfterAppend.focus(),this.focusAfterAppend=null)},e.prototype.buildMonthCell=function(t,e){var a=this.calendarCtrl,n=this.yearCtrl,i=this.buildBlankCell(),r=new Date(t,e,1);i.setAttribute("aria-label",this.dateLocale.monthFormatter(r)),i.id=a.getDateId(r,"year"),i.setAttribute("data-timestamp",r.getTime()),this.dateUtil.isSameMonthAndYear(r,a.today)&&i.classList.add(a.TODAY_CLASS),this.dateUtil.isValidDate(a.selectedDate)&&this.dateUtil.isSameMonthAndYear(r,a.selectedDate)&&(i.classList.add(a.SELECTED_DATE_CLASS),i.setAttribute("aria-selected","true"));var l=this.dateLocale.shortMonths[e];if(this.dateUtil.isDateWithinRange(r,a.minDate,a.maxDate)){var s=document.createElement("span");s.classList.add("md-calendar-date-selection-indicator"),s.textContent=l,i.appendChild(s),i.addEventListener("click",n.cellClickHandler),a.displayDate&&this.dateUtil.isSameMonthAndYear(r,a.displayDate)&&(this.focusAfterAppend=i)}else i.classList.add("md-calendar-date-disabled"),i.textContent=l;return i},e.prototype.buildBlankCell=function(){var t=document.createElement("td");return t.tabIndex=-1,t.classList.add("md-calendar-date"),t.setAttribute("role","gridcell"),t.setAttribute("tabindex","-1"),t},e.prototype.buildCalendarForYear=function(t){var e,a=t.getFullYear(),n=document.createDocumentFragment(),i=document.createElement("tr"),r=document.createElement("td");for(r.className="md-calendar-month-label",r.textContent=a,i.appendChild(r),e=0;6>e;e++)i.appendChild(this.buildMonthCell(a,e));n.appendChild(i);var l=document.createElement("tr");for(l.appendChild(this.buildBlankCell()),e=6;12>e;e++)l.appendChild(this.buildMonthCell(a,e));return n.appendChild(l),n}}(),function(){"use strict";angular.module("material.components.datepicker").config(["$provide",function(t){function e(){this.months=null,this.shortMonths=null,this.days=null,this.shortDays=null,this.dates=null,this.firstDayOfWeek=0,this.formatDate=null,this.parseDate=null,this.monthHeaderFormatter=null,this.weekNumberFormatter=null,this.longDateFormatter=null,this.msgCalendar="",this.msgOpenCalendar=""}e.prototype.$get=function(t,e){function a(t){if(!t)return"";var a=t.toLocaleTimeString(),n=t;return 0!=t.getHours()||-1===a.indexOf("11:")&&-1===a.indexOf("23:")||(n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),1,0,0)),e("date")(n,"M/d/yyyy")}function n(t){return new Date(t)}function i(t){t=t.trim();var e=/^(([a-zA-Z]{3,}|[0-9]{1,4})([ \.,]+|[\/\-])){2}([a-zA-Z]{3,}|[0-9]{1,4})$/;return e.test(t)}function r(t){return p.shortMonths[t.getMonth()]+" "+t.getFullYear()}function l(t){return p.months[t.getMonth()]+" "+t.getFullYear()}function s(t){return"Week "+t}function d(t){return[p.days[t.getDay()],p.months[t.getMonth()],p.dates[t.getDate()],t.getFullYear()].join(" ")}for(var o=t.DATETIME_FORMATS.DAY.map(function(t){return t[0]}),c=Array(32),h=1;31>=h;h++)c[h]=h;var u="Calendar",m="Open calendar",p={months:this.months||t.DATETIME_FORMATS.MONTH,shortMonths:this.shortMonths||t.DATETIME_FORMATS.SHORTMONTH,days:this.days||t.DATETIME_FORMATS.DAY,shortDays:this.shortDays||o,dates:this.dates||c,firstDayOfWeek:this.firstDayOfWeek||0,formatDate:this.formatDate||a,parseDate:this.parseDate||n,isDateComplete:this.isDateComplete||i,monthHeaderFormatter:this.monthHeaderFormatter||r,monthFormatter:this.monthFormatter||l,weekNumberFormatter:this.weekNumberFormatter||s,longDateFormatter:this.longDateFormatter||d,msgCalendar:this.msgCalendar||u,msgOpenCalendar:this.msgOpenCalendar||m};return p},e.prototype.$get.$inject=["$locale","$filter"],t.provider("$mdDateLocale",new e)}])}(),function(){"use strict";function t(t){return{template:'<md-button class="md-datepicker-button md-icon-button" type="button" tabindex="-1" aria-hidden="true" ng-click="ctrl.openCalendarPane($event)"><md-icon class="md-datepicker-calendar-icon" aria-label="md-calendar" md-svg-src="'+t.mdCalendar+'"></md-icon></md-button><div class="md-datepicker-input-container" ng-class="{\'md-datepicker-focused\': ctrl.isFocused}"><input class="md-datepicker-input" aria-haspopup="true" ng-focus="ctrl.setFocused(true)" ng-blur="ctrl.setFocused(false)"><md-button type="button" md-no-ink class="md-datepicker-triangle-button md-icon-button" ng-click="ctrl.openCalendarPane($event)" aria-label="{{::ctrl.dateLocale.msgOpenCalendar}}"><div class="md-datepicker-expand-triangle"></div></md-button></div><div class="md-datepicker-calendar-pane md-whiteframe-z1"><div class="md-datepicker-input-mask"><div class="md-datepicker-input-mask-opaque"></div></div><div class="md-datepicker-calendar"><md-calendar role="dialog" aria-label="{{::ctrl.dateLocale.msgCalendar}}" md-min-date="ctrl.minDate" md-max-date="ctrl.maxDate"md-date-filter="ctrl.dateFilter"ng-model="ctrl.date" ng-if="ctrl.isCalendarOpen"></md-calendar></div></div>',require:["ngModel","mdDatepicker","?^mdInputContainer"],scope:{minDate:"=mdMinDate",maxDate:"=mdMaxDate",placeholder:"@mdPlaceholder",dateFilter:"=mdDateFilter"},controller:e,controllerAs:"ctrl",bindToController:!0,link:function(t,e,a,n){var i=n[0],r=n[1],l=n[2];if(l)throw Error("md-datepicker should not be placed inside md-input-container.");r.configureNgModel(i)}}}function e(t,e,a,n,i,r,l,s,d,o,c,h){this.$compile=n,this.$timeout=i,this.$window=r,this.dateLocale=o,this.dateUtil=c,this.$mdConstant=l,this.$mdUtil=d,this.$$rAF=h,this.documentElement=angular.element(document.documentElement),this.ngModelCtrl=null,this.inputElement=e[0].querySelector("input"),this.ngInputElement=angular.element(this.inputElement),this.inputContainer=e[0].querySelector(".md-datepicker-input-container"),this.calendarPane=e[0].querySelector(".md-datepicker-calendar-pane"),this.calendarButton=e[0].querySelector(".md-datepicker-button"),this.inputMask=e[0].querySelector(".md-datepicker-input-mask-opaque"),this.$element=e,this.$attrs=a,this.$scope=t,this.date=null,this.isFocused=!1,this.isDisabled,this.setDisabled(e[0].disabled||angular.isString(a.disabled)),this.isCalendarOpen=!1,this.openOnFocus=a.hasOwnProperty("mdOpenOnFocus"),this.calendarPaneOpenedFrom=null,this.calendarPane.id="md-date-pane"+d.nextUid(),s(e),this.bodyClickHandler=angular.bind(this,this.handleBodyClick),this.windowResizeHandler=d.debounce(angular.bind(this,this.closeCalendarPane),100),a.tabindex||e.attr("tabindex","-1"),this.installPropertyInterceptors(),this.attachChangeListeners(),this.attachInteractionListeners();var u=this;t.$on("$destroy",function(){u.detachCalendarPane()})}angular.module("material.components.datepicker").directive("mdDatepicker",t),t.$inject=["$$mdSvgRegistry"];var a=3,n="md-datepicker-invalid",i=500,r=368,l=360;e.$inject=["$scope","$element","$attrs","$compile","$timeout","$window","$mdConstant","$mdTheming","$mdUtil","$mdDateLocale","$$mdDateUtil","$$rAF"],e.prototype.configureNgModel=function(t){this.ngModelCtrl=t;var e=this;t.$render=function(){var t=e.ngModelCtrl.$viewValue;if(t&&!(t instanceof Date))throw Error("The ng-model for md-datepicker must be a Date instance. Currently the model is a: "+typeof t);e.date=t,e.inputElement.value=e.dateLocale.formatDate(t),e.resizeInputElement(),e.updateErrorState()}},e.prototype.attachChangeListeners=function(){var t=this;t.$scope.$on("md-calendar-change",function(e,a){t.ngModelCtrl.$setViewValue(a),t.date=a,t.inputElement.value=t.dateLocale.formatDate(a),t.closeCalendarPane(),t.resizeInputElement(),t.updateErrorState()}),t.ngInputElement.on("input",angular.bind(t,t.resizeInputElement)),t.ngInputElement.on("input",t.$mdUtil.debounce(t.handleInputEvent,i,t))},e.prototype.attachInteractionListeners=function(){var t=this,e=this.$scope,a=this.$mdConstant.KEY_CODE;t.ngInputElement.on("keydown",function(n){n.altKey&&n.keyCode==a.DOWN_ARROW&&(t.openCalendarPane(n),e.$digest())}),t.openOnFocus&&t.ngInputElement.on("focus",angular.bind(t,t.openCalendarPane)),e.$on("md-calendar-close",function(){t.closeCalendarPane()})},e.prototype.installPropertyInterceptors=function(){var t=this;if(this.$attrs.ngDisabled){var e=this.$scope.$parent;e&&e.$watch(this.$attrs.ngDisabled,function(e){t.setDisabled(e)})}Object.defineProperty(this,"placeholder",{get:function(){return t.inputElement.placeholder},set:function(e){t.inputElement.placeholder=e||""}})},e.prototype.setDisabled=function(t){this.isDisabled=t,this.inputElement.disabled=t,this.calendarButton.disabled=t},e.prototype.updateErrorState=function(t){var e=t||this.date;if(this.clearErrorState(),this.dateUtil.isValidDate(e)){if(e=this.dateUtil.createDateAtMidnight(e),this.dateUtil.isValidDate(this.minDate)){var a=this.dateUtil.createDateAtMidnight(this.minDate);this.ngModelCtrl.$setValidity("mindate",e>=a)}if(this.dateUtil.isValidDate(this.maxDate)){var i=this.dateUtil.createDateAtMidnight(this.maxDate);this.ngModelCtrl.$setValidity("maxdate",i>=e)}angular.isFunction(this.dateFilter)&&this.ngModelCtrl.$setValidity("filtered",this.dateFilter(e))}else this.ngModelCtrl.$setValidity("valid",null==e);this.ngModelCtrl.$valid||this.inputContainer.classList.add(n)},e.prototype.clearErrorState=function(){this.inputContainer.classList.remove(n),["mindate","maxdate","filtered","valid"].forEach(function(t){this.ngModelCtrl.$setValidity(t,!0)},this)},e.prototype.resizeInputElement=function(){this.inputElement.size=this.inputElement.value.length+a},e.prototype.handleInputEvent=function(){var t=this.inputElement.value,e=t?this.dateLocale.parseDate(t):null;this.dateUtil.setDateTimeToMidnight(e);var a=""==t||this.dateUtil.isValidDate(e)&&this.dateLocale.isDateComplete(t)&&this.isDateEnabled(e);a&&(this.ngModelCtrl.$setViewValue(e),this.date=e),this.updateErrorState(e)},e.prototype.isDateEnabled=function(t){return this.dateUtil.isDateWithinRange(t,this.minDate,this.maxDate)&&(!angular.isFunction(this.dateFilter)||this.dateFilter(t))},e.prototype.attachCalendarPane=function(){var t=this.calendarPane,e=document.body;t.style.transform="",this.$element.addClass("md-datepicker-open"),angular.element(e).addClass("md-datepicker-is-showing");var a=this.inputContainer.getBoundingClientRect(),n=e.getBoundingClientRect(),i=a.top-n.top,s=a.left-n.left,d=n.top<0&&0==document.body.scrollTop?-n.top:document.body.scrollTop,o=n.left<0&&0==document.body.scrollLeft?-n.left:document.body.scrollLeft,c=d+this.$window.innerHeight,h=o+this.$window.innerWidth;if(s+l>h){if(h-l>0)s=h-l;else{s=o;var u=this.$window.innerWidth/l;t.style.transform="scale("+u+")"}t.classList.add("md-datepicker-pos-adjusted")}i+r>c&&c-r>d&&(i=c-r,t.classList.add("md-datepicker-pos-adjusted")),t.style.left=s+"px",t.style.top=i+"px",document.body.appendChild(t),this.inputMask.style.left=a.width+"px",this.$$rAF(function(){t.classList.add("md-pane-open")})},e.prototype.detachCalendarPane=function(){this.$element.removeClass("md-datepicker-open"),angular.element(document.body).removeClass("md-datepicker-is-showing"),this.calendarPane.classList.remove("md-pane-open"),this.calendarPane.classList.remove("md-datepicker-pos-adjusted"),this.isCalendarOpen&&this.$mdUtil.enableScrolling(),this.calendarPane.parentNode&&this.calendarPane.parentNode.removeChild(this.calendarPane)},e.prototype.openCalendarPane=function(t){if(!this.isCalendarOpen&&!this.isDisabled){this.isCalendarOpen=!0,this.calendarPaneOpenedFrom=t.target,this.$mdUtil.disableScrollAround(this.calendarPane),this.attachCalendarPane(),this.focusCalendar();var e=this;this.$mdUtil.nextTick(function(){e.documentElement.on("click touchstart",e.bodyClickHandler)},!1),window.addEventListener("resize",this.windowResizeHandler)}},e.prototype.closeCalendarPane=function(){function t(){e.detachCalendarPane(),e.isCalendarOpen=!1,e.ngModelCtrl.$setTouched(),e.documentElement.off("click touchstart",e.bodyClickHandler),window.removeEventListener("resize",e.windowResizeHandler)}if(this.isCalendarOpen){var e=this;e.calendarPaneOpenedFrom.focus(),e.calendarPaneOpenedFrom=null,e.openOnFocus?this.$mdUtil.nextTick(t):t()}},e.prototype.getCalendarCtrl=function(){return angular.element(this.calendarPane.querySelector("md-calendar")).controller("mdCalendar")},e.prototype.focusCalendar=function(){var t=this;this.$mdUtil.nextTick(function(){t.getCalendarCtrl().focus()},!1)},e.prototype.setFocused=function(t){t||this.ngModelCtrl.$setTouched(),this.isFocused=t},e.prototype.handleBodyClick=function(t){if(this.isCalendarOpen){var e=this.$mdUtil.getClosest,a=e(t.target,"md-calendar-year")||e(t.target,"md-calendar-month");a||this.closeCalendarPane(),this.$scope.$digest()}}}(),function(){"use strict";angular.module("material.components.datepicker").factory("$$mdDateUtil",function(){function t(t){return new Date(t.getFullYear(),t.getMonth(),1)}function e(t){return new Date(t.getFullYear(),t.getMonth()+1,0).getDate()}function a(t){return new Date(t.getFullYear(),t.getMonth()+1,1)}function n(t){return new Date(t.getFullYear(),t.getMonth()-1,1)}function i(t,e){return t.getFullYear()===e.getFullYear()&&t.getMonth()===e.getMonth()}function r(t,e){return t.getDate()==e.getDate()&&i(t,e)}function l(t,e){var n=a(t);return i(n,e)}function s(t,e){var a=n(t);return i(e,a)}function d(t,e){return g((t.getTime()+e.getTime())/2)}function o(e){var a=t(e);return Math.floor((a.getDay()+e.getDate()-1)/7)}function c(t,e){return new Date(t.getFullYear(),t.getMonth(),t.getDate()+e)}function h(t,a){var n=new Date(t.getFullYear(),t.getMonth()+a,1),i=e(n);return i<t.getDate()?n.setDate(i):n.setDate(t.getDate()),n}function u(t,e){return 12*(e.getFullYear()-t.getFullYear())+(e.getMonth()-t.getMonth())}function m(t){return new Date(t.getFullYear(),t.getMonth(),e(t))}function p(t){return null!=t&&t.getTime&&!isNaN(t.getTime())}function f(t){p(t)&&t.setHours(0,0,0,0)}function g(t){var e;return e=angular.isUndefined(t)?new Date:new Date(t),f(e),e}function D(t,e,a){var n=g(t),i=p(e)?g(e):null,r=p(a)?g(a):null;return(!i||n>=i)&&(!r||r>=n)}function C(t,e){return h(t,12*e)}function y(t,e){return e.getFullYear()-t.getFullYear()}function v(t,e,a){var n=t;return e&&e>t&&(n=new Date(e.getTime())),a&&t>a&&(n=new Date(a.getTime())),n}function $(t){return t&&t.hasAttribute("data-timestamp")?Number(t.getAttribute("data-timestamp")):void 0}return{getFirstDateOfMonth:t,getNumberOfDaysInMonth:e,getDateInNextMonth:a,getDateInPreviousMonth:n,isInNextMonth:l,isInPreviousMonth:s,getDateMidpoint:d,isSameMonthAndYear:i,getWeekOfMonth:o,incrementDays:c,incrementMonths:h,getLastDateOfMonth:m,isSameDay:r,getMonthDistance:u,isValidDate:p,setDateTimeToMidnight:f,createDateAtMidnight:g,isDateWithinRange:D,incrementYears:C,getYearDistance:y,clampDate:v,getTimestampFromNode:$}})}(),ng.material.components.datepicker=angular.module("material.components.datepicker");