/**
 * angular-permission
 * Fully featured role and permission based access control for your angular applications
 * @version v4.0.6 - 2016-09-21
 * @link https://github.com/Narzerus/angular-permission
 * @author Rafael Vidaurre <narzerus@gmail.com> (http://www.rafaelvidaurre.com), Blazej Krysiak <blazej.krysiak@gmail.com>
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */


!function(a,angular,b){"use strict";function c(a){"ngInject";function b(b){var c=a.defer(),d=0,e=angular.isArray(b)?[]:{};return angular.forEach(b,function(b,f){d++,a.when(b).then(function(a){c.resolve(a)})["catch"](function(a){e[f]=a,--d||c.reject(a)})}),0===d&&c.reject(e),c.promise}return a.any=b,a}function d(){"ngInject";this.broadcastPermissionStartEvent=function(){throw new Error("Method broadcastPermissionStartEvent in PermTransitionEvents interface must be implemented")},this.broadcastPermissionAcceptedEvent=function(){throw new Error("Method broadcastPermissionAcceptedEvent in PermTransitionEvents interface must be implemented")},this.broadcastPermissionDeniedEvent=function(){throw new Error("Method broadcastPermissionDeniedEvent in PermTransitionEvents interface must be implemented")}}function e(a,b){"ngInject";function c(a,b){e(a,b),this.permissionName=a,this.validationFunction=b}function d(b,c){return b?a.resolve(c):a.reject(c)}function e(a,b){if(!angular.isString(a))throw new TypeError('Parameter "permissionName" name must be String');if(!angular.isFunction(b))throw new TypeError('Parameter "validationFunction" must be Function')}return c.prototype.validatePermission=function(){var a=this.validationFunction.call(null,this.permissionName,b);return angular.isFunction(a.then)||(a=d(a,this.permissionName)),a},c}function f(a,b,c){"ngInject";function d(a,b){f(a,b),this.roleName=a,this.validationFunction=b}function e(b,c){return b?a.resolve(c):a.reject(c)}function f(a,b){if(!angular.isString(a))throw new TypeError('Parameter "roleName" name must be String');if(!angular.isArray(b)&&!angular.isFunction(b))throw new TypeError('Parameter "validationFunction" must be array or function')}return d.prototype.validateRole=function(){if(angular.isFunction(this.validationFunction)){var d=this.validationFunction.call(null,this.roleName,c);return angular.isFunction(d.then)||(d=e(d,this.roleName)),d}if(angular.isArray(this.validationFunction)){var f=this.validationFunction.map(function(c){if(b.hasPermissionDefinition(c)){var d=b.getPermissionDefinition(c);return d.validatePermission()}return a.reject(c)});return a.all(f)}},d}function g(a){"ngInject";function b(b,c){i[b]=new a(b,c)}function c(a,c){if(!angular.isArray(a))throw new TypeError('Parameter "permissionNames" name must be Array');angular.forEach(a,function(a){b(a,c)})}function d(a){delete i[a]}function e(a){return angular.isDefined(i[a])}function f(a){return i[a]}function g(){return i}function h(){i={}}var i={};this.definePermission=b,this.defineManyPermissions=c,this.removePermissionDefinition=d,this.hasPermissionDefinition=e,this.getPermissionDefinition=f,this.getStore=g,this.clearStore=h}function h(a){"ngInject";function b(b,c){i[b]=new a(b,c)}function c(a){if(!angular.isObject(a))throw new TypeError('Parameter "roleNames" name must be object');angular.forEach(a,function(a,c){b(c,a)})}function d(a){delete i[a]}function e(a){return angular.isDefined(i[a])}function f(a){return i[a]}function g(){return i}function h(){i={}}var i={};this.defineRole=b,this.defineManyRoles=c,this.getRoleDefinition=f,this.hasRoleDefinition=e,this.removeRoleDefinition=d,this.getStore=g,this.clearStore=h}function i(a,b,c,d){"ngInject";return{restrict:"A",bindToController:{sref:"=?permissionSref",only:"=?permissionOnly",except:"=?permissionExcept",onAuthorized:"&?permissionOnAuthorized",onUnauthorized:"&?permissionOnUnauthorized"},controllerAs:"permission",controller:["$scope","$element",function(e,f){function g(){return b.has("$state")&&j.sref}function h(){angular.isFunction(j.onAuthorized)?j.onAuthorized()(f):d.showElement(f)}function i(){angular.isFunction(j.onUnauthorized)?j.onUnauthorized()(f):d.hideElement(f)}var j=this;e.$watchGroup(["permission.only","permission.except","sref"],function(){try{if(g()){var d=b.get("PermStateAuthorization");d.authorizeByStateName(j.sref).then(function(){h()})["catch"](function(){i()})}else{var e=b.get("PermAuthorization"),f=new c({only:j.only,except:j.except});e.authorizeByPermissionMap(f).then(function(){h()})["catch"](function(){i()})}}catch(k){i(),a.error(k.message)}})}]}}function j(a){"ngInject";function b(a){return c(a)}function c(b){var c=a.defer();return d(c,b),c.promise}function d(b,c){var d=c.resolvePropertyValidity(c.except);a.any(d).then(function(a){b.reject(a)})["catch"](function(){e(b,c)})}function e(b,c){if(!c.only.length)return void b.resolve();var d=c.resolvePropertyValidity(c.only);a.any(d).then(function(a){b.resolve(a)})["catch"](function(a){b.reject(a)})}this.authorizeByPermissionMap=b}function k(a,b,c,d,e){"ngInject";function f(a){a=a||{},this.only=i(a.only),this.except=i(a.except),this.redirectTo=a.redirectTo}function g(b,d){return a.when(b.call(null,d,c)).then(function(b){return angular.isString(b)?{state:b}:angular.isObject(b)?b:a.reject()})}function h(b,c){if(!angular.isDefined(b["default"]))throw new ReferenceError('When used "redirectTo" as object, property "default" must be defined');var d=b[c];return angular.isDefined(d)||(d=b["default"]),angular.isFunction(d)?g(d,c):angular.isObject(d)?a.resolve(d):angular.isString(d)?a.resolve({state:d}):void 0}function i(a){return angular.isString(a)?[a]:angular.isArray(a)?a:angular.isFunction(a)?a.call(null,c):[]}return f.prototype.resolveRedirectState=function(b){return angular.isFunction(this.redirectTo)?g(this.redirectTo,b):angular.isObject(this.redirectTo)?h(this.redirectTo,b):angular.isString(this.redirectTo)?a.resolve({state:this.redirectTo}):a.reject()},f.prototype.resolvePropertyValidity=function(c){return c.map(function(c){if(d.hasRoleDefinition(c)){var f=d.getRoleDefinition(c);return f.validateRole()}if(e.hasPermissionDefinition(c)){var g=e.getPermissionDefinition(c);return g.validatePermission()}return b.warn("Permission or role "+c+" was not defined."),a.reject(c)})},f}c.$inject=["$delegate"],e.$inject=["$q","PermTransitionProperties"],f.$inject=["$q","PermPermissionStore","PermTransitionProperties"],g.$inject=["PermPermission"],h.$inject=["PermRole"],i.$inject=["$log","$injector","PermPermissionMap","PermPermissionStrategies"],j.$inject=["$q"],k.$inject=["$q","$log","PermTransitionProperties","PermRoleStore","PermPermissionStore"];var l=angular.module("permission",[]);"undefined"!=typeof module&&"undefined"!=typeof exports&&module.exports===exports&&(module.exports=l.name),angular.module("permission").decorator("$q",c);var m={enableElement:function(a){a.removeAttr("disabled")},disableElement:function(a){a.attr("disabled","disabled")},showElement:function(a){a.removeClass("ng-hide")},hideElement:function(a){a.addClass("ng-hide")}};angular.module("permission").value("PermPermissionStrategies",m).value("PermissionStrategies",m);var n={};angular.module("permission").value("PermTransitionProperties",n),angular.module("permission").service("PermTransitionEvents",d),angular.module("permission").factory("PermPermission",e),angular.module("permission").factory("PermRole",f),angular.module("permission").service("PermPermissionStore",g),angular.module("permission").service("PermRoleStore",h),angular.module("permission").directive("permission",i),angular.module("permission").service("PermAuthorization",j),angular.module("permission").factory("PermPermissionMap",k)}(window,window.angular);
//# sourceMappingURL=angular-permission.min.js.map