/**
 * angular-permission
 * Fully featured role and permission based access control for your angular applications
 * @version v5.1.1 - 2017-01-31
 * @link https://github.com/Narzerus/angular-permission
 * @author Rafael Vidaurre <narzerus@gmail.com> (http://www.rafaelvidaurre.com), Blazej Krysiak <blazej.krysiak@gmail.com>
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */


!function(a,angular,b){"use strict";function c(a){"ngInject";function b(b){var c=a.defer(),d=0,e=angular.isArray(b)?[]:{};return angular.forEach(b,function(b,f){d++,a.when(b).then(function(a){c.resolve(a)}).catch(function(a){e[f]=a,--d||c.reject(a)})}),0===d&&c.reject(e),c.promise}return a.any=b,a}function d(){"ngInject";this.broadcastPermissionStartEvent=function(){throw new Error("Method broadcastPermissionStartEvent in PermTransitionEvents interface must be implemented")},this.broadcastPermissionAcceptedEvent=function(){throw new Error("Method broadcastPermissionAcceptedEvent in PermTransitionEvents interface must be implemented")},this.broadcastPermissionDeniedEvent=function(){throw new Error("Method broadcastPermissionDeniedEvent in PermTransitionEvents interface must be implemented")}}function e(a,b,c){"ngInject";function d(a,b){f(a,b),this.permissionName=a,this.validationFunction=g(b)}function e(b,c){return b?a.resolve(c):a.reject(c)}function f(a,b){if(!angular.isString(a))throw new TypeError('Parameter "permissionName" name must be String');if(!angular.isFunction(b)&&!angular.isArray(b))throw new TypeError('Parameter "validationFunction" must be Function or an injectable Function using explicit annotation')}function g(a){return angular.isArray(a.$inject||a)||(a=["permissionName","transitionProperties",a]),a}return d.prototype.validatePermission=function(){var a={permissionName:this.permissionName,transitionProperties:c},d=b.invoke(this.validationFunction,null,a);return angular.isFunction(d.then)||(d=e(d,this.permissionName)),d},d}function f(a,b,c,d){"ngInject";function e(a,b){g(a,b),this.roleName=a,this.validationFunction=h(b)}function f(b,c){return b?a.resolve(c):a.reject(c)}function g(a,b){if(!angular.isString(a))throw new TypeError('Parameter "roleName" name must be String');if(!angular.isArray(b)&&!angular.isFunction(b))throw new TypeError('Parameter "validationFunction" must be array or function')}function h(a){return angular.isArray(a)&&!angular.isFunction(a[a.length-1])?a=i(a):angular.isArray(a.$inject||a)||(a=["roleName","transitionProperties",a]),a}function i(b){return function(){var d=b.map(function(b){if(c.hasPermissionDefinition(b)){var d=c.getPermissionDefinition(b);return d.validatePermission()}return a.reject(b)});return a.all(d)}}return e.prototype.validateRole=function(){var a={roleName:this.roleName,transitionProperties:d},c=b.invoke(this.validationFunction,null,a);return angular.isFunction(c.then)||(c=f(c,this.roleName)),c},e}function g(a){"ngInject";function b(b,c){i[b]=new a(b,c)}function c(a,c){if(!angular.isArray(a))throw new TypeError('Parameter "permissionNames" name must be Array');angular.forEach(a,function(a){b(a,c)})}function d(a){delete i[a]}function e(a){return angular.isDefined(i[a])}function f(a){return i[a]}function g(){return i}function h(){i={}}var i={};this.definePermission=b,this.defineManyPermissions=c,this.removePermissionDefinition=d,this.hasPermissionDefinition=e,this.getPermissionDefinition=f,this.getStore=g,this.clearStore=h}function h(a){"ngInject";function b(b,c){i[b]=new a(b,c)}function c(a){if(!angular.isObject(a))throw new TypeError('Parameter "roleNames" name must be object');angular.forEach(a,function(a,c){b(c,a)})}function d(a){delete i[a]}function e(a){return angular.isDefined(i[a])}function f(a){return i[a]}function g(){return i}function h(){i={}}var i={};this.defineRole=b,this.defineManyRoles=c,this.getRoleDefinition=f,this.hasRoleDefinition=e,this.removeRoleDefinition=d,this.getStore=g,this.clearStore=h}function i(a,b,c,d){"ngInject";return{restrict:"A",bindToController:{sref:"=?permissionSref",only:"=?permissionOnly",except:"=?permissionExcept",onAuthorized:"&?permissionOnAuthorized",onUnauthorized:"&?permissionOnUnauthorized"},controllerAs:"permission",controller:["$scope","$element",function(e,f){function g(){return b.has("$state")&&j.sref}function h(){angular.isFunction(j.onAuthorized)?j.onAuthorized()(f):d.showElement(f)}function i(){angular.isFunction(j.onUnauthorized)?j.onUnauthorized()(f):d.hideElement(f)}var j=this;e.$watchGroup(["permission.only","permission.except","sref"],function(){try{if(g()){var d=b.get("PermStateAuthorization");d.authorizeByStateName(j.sref).then(function(){h()}).catch(function(){i()})}else{var e=b.get("PermAuthorization"),f=new c({only:j.only,except:j.except});e.authorizeByPermissionMap(f).then(function(){h()}).catch(function(){i()})}}catch(b){i(),a.error(b.message)}})}]}}function j(a){"ngInject";function b(b){var d=a.defer();return c(d,b),d.promise}function c(b,c){var e=c.resolvePropertyValidity(c.except);a.any(e).then(function(a){b.reject(a)}).catch(function(){d(b,c)})}function d(b,c){if(!c.only.length)return void b.resolve();var d=c.resolvePropertyValidity(c.only);a.any(d).then(function(a){b.resolve(a)}).catch(function(a){b.reject(a)})}this.authorizeByPermissionMap=b}function k(a,b,c,d,e,f){"ngInject";function g(a){a=a||{},this.only=i(a.only),this.except=i(a.except),this.redirectTo=j(a.redirectTo)}function h(b,e){return a.when(c.invoke(b,null,{rejectedPermission:e,transitionProperties:d})).then(function(b){return angular.isString(b)?{state:b}:angular.isObject(b)?b:a.reject()})}function i(a){return angular.isString(a)?[a]:angular.isArray(a)?a:angular.isFunction(a)?a.call(null,d):[]}function j(a){if(angular.isDefined(a)){if(o(a)||angular.isFunction(a))return p(a);if(angular.isObject(a))return l(a)?m(a):n(a);if(angular.isString(a))return k(a);throw new ReferenceError('Property "redirectTo" must be String, Function, Array or Object')}}function k(a){var b={};return b.default=function(){return{state:a}},b.default.$inject=["rejectedPermission","transitionProperties"],b}function l(a){return angular.isDefined(a.state)}function m(a){var b={};return b.default=function(){return a},b}function n(a){var b={};return angular.forEach(a,function(a,c){o(a)?b[c]=a:angular.isFunction(a)&&(b[c]=a,b[c].$inject=[]),angular.isObject(a)&&(b[c]=function(){return a},b[c].$inject=[]),angular.isString(a)&&(b[c]=function(){return{state:a}},b[c].$inject=[])}),b}function o(a){return angular.isArray(a)||angular.isFunction(a)&&angular.isArray(a.$inject)}function p(a){var b={};return b.default=a,angular.isDefined(a.$inject)||(b.default.$inject=["rejectedPermission","transitionProperties"]),b}return g.prototype.resolveRedirectState=function(b){if(!angular.isDefined(this.redirectTo))return a.reject();var c=this.redirectTo[b]||this.redirectTo.default;return h(c,b)},g.prototype.resolvePropertyValidity=function(c){return c.map(function(c){if(e.hasRoleDefinition(c)){var d=e.getRoleDefinition(c);return d.validateRole()}if(f.hasPermissionDefinition(c)){var g=f.getPermissionDefinition(c);return g.validatePermission()}return b.warn("Permission or role "+c+" was not defined."),a.reject(c)})},g}c.$inject=["$delegate"],e.$inject=["$q","$injector","PermTransitionProperties"],f.$inject=["$q","$injector","PermPermissionStore","PermTransitionProperties"],g.$inject=["PermPermission"],h.$inject=["PermRole"],i.$inject=["$log","$injector","PermPermissionMap","PermPermissionStrategies"],j.$inject=["$q"],k.$inject=["$q","$log","$injector","PermTransitionProperties","PermRoleStore","PermPermissionStore"];var l=angular.module("permission",[]);"undefined"!=typeof module&&"undefined"!=typeof exports&&module.exports===exports&&(module.exports=l.name),angular.module("permission").decorator("$q",c);var m={enableElement:function(a){a.removeAttr("disabled")},disableElement:function(a){a.attr("disabled","disabled")},showElement:function(a){a.removeClass("ng-hide")},hideElement:function(a){a.addClass("ng-hide")}};angular.module("permission").value("PermPermissionStrategies",m).value("PermissionStrategies",m);var n={};angular.module("permission").value("PermTransitionProperties",n),angular.module("permission").service("PermTransitionEvents",d),angular.module("permission").factory("PermPermission",e),angular.module("permission").factory("PermRole",f),angular.module("permission").service("PermPermissionStore",g),angular.module("permission").service("PermRoleStore",h),angular.module("permission").directive("permission",i),angular.module("permission").service("PermAuthorization",j),angular.module("permission").factory("PermPermissionMap",k)}(window,window.angular);
//# sourceMappingURL=angular-permission.min.js.map