/**
 * AngularJS service to implement a finite state machine.
 * @version v1.2.1 - 2015-08-13
 * @link https://github.com/tafax/angular-state-machine
 * @author Matteo Tafani Alunno <matteo.tafanialunno@gmail.com>
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */
"use strict";function MachineConfiguration(a){var b={},c=[],d={};this.getStates=function(){return b},this.getMessages=function(){return c},this.getTransitions=function(){return d},this.extend=function(b){a=angular.merge(a,b)},this.configure=function(){if(!a.hasOwnProperty("init"))throw"You have to create 'init' state.";for(var e in a)if(a.hasOwnProperty(e)){var f=a[e];f.name=e;var g={};if(f.hasOwnProperty("transitions")){g=f.transitions;for(var h in g)g.hasOwnProperty(h)&&c.indexOf(h)<0&&c.push(h);delete f.transitions}d.hasOwnProperty(e)||(d[e]={}),angular.extend(d[e],g),b.hasOwnProperty(e)||(b[e]={}),angular.extend(b[e],f)}}}function StateMachine(a,b){this.initialize=function(){a.initialize(b)},this.getCurrentState=function(){return a.getCurrentState()},this.getStates=function(){return a.getStates(b)},this.getMessages=function(){return a.getMessages(b)},this.hasMessage=function(c){return a.hasMessage(b,c)},this.isAvailable=function(c){return a.isAvailable(b,c)},this.available=function(){return a.available(b)},this.send=function(c,d){return a.send(b,c,d)}}function MachineStrategy(){}function SyncStrategy(a,b){MachineStrategy.call(this),this.currentState=null,this.$q=a,this.$injector=b,this.lastPromise=null}var FSM=angular.module("FSM",[]);FSM.provider("stateMachine",function(){var a;this.config=function(b){a=b},this.$get=["$q","$injector",function(b,c){return new StateMachine(new SyncStrategy(b,c),new MachineConfiguration(a))}]}),MachineStrategy.prototype.initialize=function(a){},MachineStrategy.prototype.getCurrentState=function(){},MachineStrategy.prototype.getStates=function(a){},MachineStrategy.prototype.getMessages=function(a){},MachineStrategy.prototype.hasMessage=function(a,b){},MachineStrategy.prototype.isAvailable=function(a,b){},MachineStrategy.prototype.available=function(a){},MachineStrategy.prototype.send=function(a,b,c,d){},MachineStrategy.prototype=new MachineStrategy,SyncStrategy.prototype.initialize=function(a){a.configure();var b=a.getStates();this.currentState=b.init,this.currentState.params={}},SyncStrategy.prototype.getCurrentState=function(){var a=this;return this.$q.when(this.lastPromise).then(function(){return a.currentState.name})["catch"](function(){return a.$q.when(a.currentState.name)})},SyncStrategy.prototype.getStates=function(a){return Object.keys(a.getStates())},SyncStrategy.prototype.getMessages=function(a){return a.getMessages()},SyncStrategy.prototype.hasMessage=function(a,b){var c=a.getMessages();return c.indexOf(b)>=0},SyncStrategy.prototype.isAvailable=function(a,b){var c=this,d=a.getTransitions();return this.$q.when(this.lastPromise).then(function(){var a=d[c.currentState.name];return a.hasOwnProperty(b)})["catch"](function(){var a=d[c.currentState.name];return c.$q.when(a.hasOwnProperty(b))})},SyncStrategy.prototype.available=function(a){var b=this,c=a.getTransitions();return this.$q.when(this.lastPromise).then(function(){var a=c[b.currentState.name];return Object.keys(a)})["catch"](function(){var a=c[b.currentState.name];return b.$q.when(Object.keys(a))})},SyncStrategy.prototype.send=function(a,b,c){var d=this;return this.lastPromise=this.$q.when(this.lastPromise).then(function(){var e=a.getTransitions(),f=e[d.currentState.name];if(!d.hasMessage(a,b)||!f.hasOwnProperty(b))return d.lastPromise=null,d.$q.reject();var g=f[b];if(g instanceof Array){var h=[];for(var i in g){var j=g[i];d.$injector.invoke(j.predicate,this,d.currentState)&&h.push(j.to)}if(h.length>1)throw"Unable to execute transition in state '"+d.currentState.name+"'. More than one predicate is passed.";g=h[0]}var k=a.getStates(),l=k[g],m={};m=angular.merge(m,d.currentState),delete m.action,c&&angular.merge(m.params,c);var n=void 0;return!l.action||"function"!=typeof l.action&&"[object Array]"!==Object.prototype.toString.call(l.action)||(n=d.$injector.invoke(l.action,d,m)),d.$q.when(n).then(function(a){!a&&d.currentState.params?l.params=d.currentState.params:(l.hasOwnProperty("params")||(l.params={}),angular.merge(l.params,a)),d.currentState=l})["catch"](function(){return d.lastPromise=null,d.$q.reject()})}),this.lastPromise};