/*! angular-toolbelt 02-06-2015 */
angular.module("sysen.toolbelt",["sysen.toolbelt.services","sysen.toolbelt.filters","sysen.toolbelt.directives","sysen.toolbelt.tpls"]),angular.module("sysen.toolbelt.services",["toolbelt.platform"]),angular.module("sysen.toolbelt.filters",["toolbelt.bytes","toolbelt.prettyDate"]),angular.module("sysen.toolbelt.directives",["toolbelt.growl","toolbelt.infiniteScroll","toolbelt.markdown","toolbelt.navbar","toolbelt.scroll","toolbelt.strength","toolbelt.fileInput"]),angular.module("sysen.toolbelt.tpls",["toolbelt.growl.tpl","toolbelt.strength.tpl","toolbelt.fileInput.tpl"]),angular.module("toolbelt.navbar",[]).directive("sysActiveNavbar",["$location",function(a){function b(b){var f;angular.forEach(b.find("a"),function(b){var c=angular.element(b),g=c.attr("data-route")||"",h=new RegExp("^"+g.replace("/","\\/")+"$",["i"]);h.test(a.path())?f=c:d(c,e)}),void 0!==f&&c(f,e)}function c(a,b){for(;void 0===a.attr("data-sys-active-navbar")&&"BODY"!==a.prop("tagName");)a.hasClass(b)||a.addClass(b),a=a.parent()}function d(a,b){for(;void 0===a.attr("data-sys-active-navbar")&&"BODY"!==a.prop("tagName");)a.hasClass(b)&&a.removeClass(b),a=a.parent()}var e="active";return{link:function(c,d,f){e=f.sysActiveNavbar||e,c.$watch(function(){return a.path()},function(){b(d)})}}}]),angular.module("toolbelt.fileInput",["ngResource"]).directive("sysFileInput",["$resource",function(a){return{require:"ngModel",scope:{model:"=ngModel"},replace:!0,templateUrl:"template/toolbelt/file-input.html",link:function(b,c,d){function e(a){a.preventDefault(),b.$apply(function(){b.dropState=b.files.length>0?"drop":"exit"})}function f(a){a.preventDefault();var c=a.dataTransfer&&a.dataTransfer.types&&a.dataTransfer.types.indexOf("Files")>=0;b.$apply(function(){b.dropState=c?"over":"invalid"})}function g(a){a.preventDefault(),b.$apply(function(){b.dropState="drop"});var c=a.dataTransfer.files,e=d.behaviour||"replace";"replace"==e&&(b.files=[]),c.length>0&&c.length<=j&&b.files.length+c.length<=j?b.$apply(function(){angular.forEach(c,function(a){var c=new FileReader,d={raw:a,data:{name:a.name,size:a.size,type:a.type,lastModified:a.lastModifiedDate}};0===a.type.indexOf("text")?(c.onload=function(a){b.$apply(function(){d.content=a.target.result})},c.readAsText(a,"UTF-8")):0===a.type.indexOf("image")?(c.onload=function(a){b.$apply(function(){d.image=a.target.result})},c.readAsDataURL(a)):(c.onload=function(a){b.$apply(function(){d.binary=a.target.result})},c.readAsBinaryString(a)),b.files.push(d),b.model=b.files,h(d)})}):b.$apply(function(){b.dropState="invalid",b.error={message:"Drop ignored, exceeds maximum limit of "+j}})}function h(c){if(d.api){var e=a(d.api,null,{upload:{method:"POST",headers:{"Content-Type":void 0},transformRequest:function(a){var b=new FormData;return b.append("upload",a.file),b}}});c.saving=!0,e.upload({file:c.raw},function(a){c.saved=!0,c.response=a},function(a){c.error=a.data,b.dropState="warning",b.error={message:"Some files failed to save"}})}}var i=c.inheritedData("$formController"),j=parseInt(d.sysFileInput)||10;b.model=[],b.files=[],b.$watch("model",function(a,c){0==b.model.length&&(b.files=[],c.length>0&&(b.error="",b.dropState="exit")),d.required&&i.hasFiles&&i.hasFiles.$setValidity("files",b.model.length>0)}),c.on("dragenter",e),c.on("dragleave",e),c.on("dragover",f),c.on("drop",g)}}}]),angular.module("toolbelt.growl",["ngSanitize"]).directive("sysGrowl",["$rootScope","$timeout",function(a,b){return{replace:!1,templateUrl:"template/toolbelt/growl.html",link:function(c,d,e){c.limit=parseInt(e.sysGrowl,10)||5,c.growls=[],c.dismiss=function(b){var d=c.growls.indexOf(b);c.growls.splice(d,1),a.$broadcast("_removeGrowl",b)},a.$on("_addGrowl",function(a,d){void 0===d.type&&(d.type="info"),c.growls.unshift(d),e.timeout&&b(function(){c.dismiss(d)},1e3*e.timeout)})}}}]),angular.module("toolbelt.infiniteScroll",[]).directive("sysInfiniteScroll",["$rootScope","$window","$timeout",function(a,b,c){return{link:function(d,e,f){var g=f.timeout||1e3;d.dataLoad=!1,d.stopped=!1;var h=function(){var f=d.dataLoad||d.stopped;if(!f){var h=e.prop("offsetTop")+e.prop("offsetHeight"),i=b.scrollY+b.innerHeight;h&&i-h>=0&&(d.dataLoad=!0,d.timeout=c(function(){d.dataLoad=!1},g),a.$broadcast("_infiniteScroll","DATA_LOAD"))}};a.$on("_infiniteScroll",function(a,b){switch(b){case"STOP":d.stopped=!0;break;case"START":d.stopped=!1;break;case"CONTINUE":d.dataLoad=!1,c.cancel(d.timeout)}}),angular.element(b).bind("scroll",h)}}}]),angular.module("toolbelt.markdown",[]).provider("markdownConverter",function(){var a=this;a.setOptions=function(a){this.defaults=a},a.$get=["$window",function(b){if(b.marked){var c=b.marked;return a.setOptions=c.setOptions,b.hljs&&c.setOptions({highlight:function(a){return b.hljs.highlightAuto(a).value}}),c.setOptions(a.defaults),c}}]}).directive("sysMarkdown",["markdownConverter",function(a){return{restrict:"AE",replace:!0,scope:{options:"=",sysMarkdown:"="},link:function(b,c,d){function e(d){a?c.html(a(d||"",b.options||null)):f||(c.html("Markdown parser not found! Please include library found at: https://github.com/chjj/marked"),f=!0)}var f=!1;e(b.sysMarkdown||c.text()||""),d.sysMarkdown&&b.$watch("sysMarkdown",e)}}}]),angular.module("toolbelt.scroll",[]).directive("sysScroll",["$rootScope","$window","$interval",function(a,b,c){var d=function(){return b.pageYOffset?b.pageYOffset:b.document.body.scrollTop?b.document.body.scrollTop:0},e=function(a,c){var d=b.document.getElementById(a);return d?d.offsetTop-c:0},f=function(a,f,g){var h,i=d(),j=e(f,g);if(h=j-i,0!==h)switch(a){case"smooth":var k=1,l=20,m=0;0>h&&(h=-h,m=1);var n=Math.ceil(h/l);c(function(){m>0?(i-=l,j>i&&(i=j)):(i+=l,i>j&&(i=j)),b.scrollTo(0,i)},k,n);break;default:b.scrollTo(0,i+h)}};return{link:function(c,d,e){var g=0;d.on("click",function(){if(e.target){var a=e.sysScroll||"normal",b=e.target,c=e.offset||g;f(a,b,c)}}),angular.element(b).bind("scroll",function(){a.$broadcast("_scroll",b.pageYOffset)}),a.$on("_pageScroll",function(a,b,c){c=c||g,f("none",b,c)})}}}]),angular.module("toolbelt.strength",["ngSanitize"]).directive("sysStrength",function(){function a(a){return/[a-z]+/.test(a)}function b(a){return/[A-Z]+/.test(a)}function c(a){return/[0-9]+/.test(a)}function d(a){return/[@$-/:-?{-~!"^_`\[\]]/g.test(a)}function e(a){var b=100*a/20,c=20>b?i[2]:35>b?i[3]:50>b?i[4]:65>b?i[5]:90>b?i[6]:i[7],d=f-c.rank;return d>=h.length?d=h.length-1:0>d&&(d=0),c.label=h[d],c}var f,g,h=["success","warning","danger"],i=[{rank:1,complexity:"Too short",label:"danger"},{rank:2,complexity:"Too few character types",label:"warning"},{rank:3,complexity:"Very Weak"},{rank:4,complexity:"Weak"},{rank:5,complexity:"Poor"},{rank:6,complexity:"Good"},{rank:7,complexity:"Strong"},{rank:8,complexity:"Very Strong"}];return{require:"ngModel",scope:{model:"=ngModel",target:"@"},replace:!0,templateUrl:"template/toolbelt/strength.html",link:function(h,j,k){var l=parseInt(k.minLength)||6,m=j.inheritedData("$formController");f=parseInt(k.complexity)>8?8:parseInt(k.complexity)||6,g=parseInt(k.charsets)>4?4:parseInt(k.charsets)||1;var n=function(j){var k=0,n=0;j?(a(j)&&k++,b(j)&&k++,c(j)&&k++,d(j)&&k++,n=k*(j.length/2),h.result=j.length>=l?k>=g?e(n):i[1]:i[0]):h.result=i[0],m[h.target].$setValidity("strength",f<=h.result.rank&&k>=g)};h.$watch("model",n)}}}),angular.module("toolbelt.bytes",[]).filter("bytes",function(){return function(a,b){if(0===a||isNaN(parseFloat(a))||!isFinite(a))return"-";"undefined"==typeof b&&(b=1);var c=["bytes","KB","MB","GB","TB","PB"],d=Math.floor(Math.log(a)/Math.log(1024));return(a/Math.pow(1024,Math.floor(d))).toFixed(b)+" "+c[d]}}),angular.module("toolbelt.prettyDate",[]).filter("prettyDate",function(){return function(a){a instanceof Date==!1&&(a=new Date(a));var b=new Date,c=Math.floor((b.getTime()-a.getTime())/1e3);return 1==c?c+" second ago":60>c?c+" seconds ago":120>c?Math.floor(c/60)+" minute ago":3600>c?Math.floor(c/60)+" minutes ago":7200>c?Math.floor(c/3600)+" hour ago":86400>c?Math.floor(c/3600)+" hours ago":172800>c?Math.floor(c/86400)+" day ago":604800>c?Math.floor(c/86400)+" days ago":a.toDateString()}}),angular.module("toolbelt.platform",[]).provider("$detectPlatform",function(){function a(a){var b,c,d,e=a.navigator.userAgent,f=e.match(/(windows|macintosh|linux)/i)||[];if(b=f[0],!b)return{name:"Unknown",version:"0"};switch(b.toLowerCase()){case"windows":d=e.match(/windows\snt\s([^;)]*)/i),c=d[1];break;case"macintosh":d=e.match(/(mac\sos\s?x)\s([^;)]*)/i),b=d[1],c=d[2].replace(/_/g,".");break;case"linux":d=e.match(/ubuntu|linux/i),c=d[0]}return{name:b,version:c}}function b(a){var b,c,d,e=a.navigator.userAgent,f=e.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+(\.\d+)?(\.\d+)?)/i)||[];return/trident/i.test(f[1])?(d=/\brv[ :]+(\d+(\.\d+)?(\.\d+)?)/g.exec(e),b="MSIE",c=d[1]):"Chrome"===f[1]&&(d=e.match(/\bOPR\/(\d+(\.\d+)?(\.\d+)?)/),null!==d&&(b="Opera",c=d[1])),b||c||(f=f[2]?[f[1],f[2]]:[a.navigator.appName,a.navigator.appVersion,"-?"],null!==(d=e.match(/version\/(\d+(\.\d+)?(\.\d+)?)/i))&&f.splice(1,1,d[1]),b=f[0],c=f[1]),{name:b||"Unknown",version:c||"0"}}var c=this;c.approvedBrowsers=[],c.allowBrowser=function(a,b){return this.approvedBrowsers.push({name:a,version:b||0}),c},c.$get=["$window",function(d){var e=a(d),f=b(d);return{language:d.navigator.language,system:{name:e.name,version:e.version,matches:function(a,b){return b?this.name&&this.name==a&&this.version==b:this.name&&this.name==a}},browser:{name:f.name,version:f.version,matches:function(a,b){return b?this.name&&this.name==a&&this.version==b:this.name&&this.name==a},isAllowed:function(){for(var a=0;a<c.approvedBrowsers.length;a++)if(this.name==c.approvedBrowsers[a].name&&parseFloat(this.version)>=parseFloat(c.approvedBrowsers[a].version))return!0;return!1}}}}]}),angular.module("toolbelt.fileInput.tpl",[]).run(["$templateCache",function(a){a.put("template/toolbelt/file-input.html",['<div class="file-input"> <div class="jumbotron" data-ng-class="{ valid: dropState == \'over\' || dropState == \'drop\', invalid: dropState == \'invalid\', warning: dropState == \'warning\' }">  <h3 data-ng-switch on="dropState" style="pointer-events: none">   <span data-ng-switch-when="over">Drop file(s)</span>   <span data-ng-switch-when="drop">{{ files.length }} file(s) dropped, drop again to change</span>   <span data-ng-switch-when="invalid">Invalid file drop detected</span>   <span data-ng-switch-when="warning">{{ files.length }} file(s) dropped, with warnings, drop to try again</span>   <span data-ng-switch-default>Drag file(s) here</span>  </h3>  <p data-ng-if="!files.length">No files currently added</p>  <p data-ng-if="error">{{ error.message }}</p> </div> <div class="row" data-ng-if="files.length">  <div class="col-xs-6 col-sm-4 preview" data-ng-repeat="file in files">   <img class="img-responsive" data-ng-src="{{ file.image }}" data-ng-if="file.image" />   <pre data-ng-bind="file.content" data-ng-if="file.content"></pre>   <i class="fa fa-3x fa-file" data-ng-if="file.binary"></i>   <h4 data-ng-bind="file.data.name"></h4>   <div data-ng-bind="file.data.size | bytes"></div>   <div data-ng-if="file.saving">    <p class="text-center"><span data-ng-bind="file.saved ? \'Saved\' : \'Saving\'"></span> <i class="fa" data-ng-class="{ true: \'fa-check\' }[ file.saved ]"></i></p>   </div>  </div> </div> <input id="hasFiles" name="hasFiles" type="hidden" data-ng-model="hasFiles" /></div>'].join("\n"))}]),angular.module("toolbelt.growl.tpl",[]).run(["$templateCache",function(a){a.put("template/toolbelt/growl.html",['<article data-ng-repeat="growl in growls | limitTo: limit">','    <div class="alert alert-{{ growl.type }} alert-dismissable">','        <button type="button" class="close" data-ng-click="dismiss(growl)">&times;</button>',"        <h4>{{ growl.title }}</h4>",'        <p data-ng-bind-html="growl.content"></p>',"    </div>","</article>"].join("\n"))}]),angular.module("toolbelt.strength.tpl",[]).run(["$templateCache",function(a){a.put("template/toolbelt/strength.html",'<span class="label label-{{ result.label }}">{{ result.complexity }}</span>')}]);