/**
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
/**
 * Implementing TreeDnD & Event DrapnDrop (allow drag multi tree-table include all type: table, ol, ul)
 * Demo: http://thienhung1989.github.io/angular-tree-dnd
 * Github: https://github.com/thienhung1989/angular-tree-dnd
 * @version 3.1.0
 * (c) 2015 Nguyuễn Thiện Hùng - <nguyenthienhung1989@gmail.com>
 */
(function(){"use strict";angular.isUndefinedOrNull=function(e){return angular.isUndefined(e)||null===e},angular.isDefined=function(e){return!(angular.isUndefined(e)||null===e)},angular.module("ntt.TreeDnD",["template/TreeDnD/TreeDnD.html"]).constant("$TreeDnDClass",{tree:"tree-dnd",empty:"tree-dnd-empty",hidden:"tree-dnd-hidden",node:"tree-dnd-node",nodes:"tree-dnd-nodes",handle:"tree-dnd-handle",place:"tree-dnd-placeholder",drag:"tree-dnd-drag",status:"tree-dnd-status",icon:{1:"glyphicon glyphicon-minus",0:"glyphicon glyphicon-plus","-1":"glyphicon glyphicon-file"}}).directive("compile",["$compile",function(e){return{restrict:"A",link:function(n,t,a){n.$watch(a.compile,function(a){if(a){var l=e(a),r=l(n);angular.isFunction(t.empty)?t.empty():t.html(""),t.append(r)}})}}}]).directive("compileReplace",["$compile",function(e){return{restrict:"A",link:function(n,t,a){n.$watch(a.compileReplace,function(a){if(a){var l=e(a),r=l(n);t.replaceWith(r)}})}}}]).directive("treeDndNodeHandle",function(){return{restrict:"A",scope:!0,link:function(e,n,t){e.$element=n,e.$type="TreeDnDNodeHandle",e.$class.handle&&n.addClass(e.$class.handle)}}}).directive("treeDndNode",function(){return{restrict:"A",replace:!0,link:function(e,n,t){var a="boolean"==typeof e.dragEnabled||"boolean"==typeof e.dropEnabled;e.$modelValue=null,e.$icon_class="",e.$node_class="",e.$class.node&&(n.addClass(e.$class.node),e.$node_class=e.$class.node),e.$watch(t.treeDndNode,function(e,n,t){a&&t.setScope(t,e),t.$modelValue=e,t.$icon_class=t.$class.icon[e.__icon__]},!0),a&&(e.$element=n,e.$type="TreeDnDNode",e.getScopeNode=function(){return e},e.getData=function(){return e.$modelValue},e.getElementChilds=function(){return angular.element(n[0].querySelector("[tree-dnd-nodes]"))})}}}).directive("treeDndNodes",function(){return{restrict:"A",replace:!0,link:function(e,n,t){e.nodes=[],e.$nodes_class="",e.$type="TreeDnDNodes",e.$element=n,e.getScopeNode=null,e.$watch(t.treeDndNodes,function(e,n,t){t.nodes=e},!0),e.$class.nodes&&(n.addClass(e.$class.nodes),e.$nodes_class=e.$class.nodes)}}}).directive("treeDnd",["$injector","$timeout","$http","$compile","$window","$document","$templateCache","$TreeDnDTemplate","$TreeDnDClass","$TreeDnDHelper","$TreeDnDPlugin",function(e,n,t,a,l,r,o,i,d,s,c){return{restrict:"E",scope:!0,replace:!0,controller:["$scope","$element","$attrs",function(e,n,t){e.indent=20,e.indent_plus=15,e.indent_unit="px",e.$tree_class="table",e.primary_key="__uid__",e.$type="TreeDnD",e.colDefinitions=[],e.$globals={},e.$class={},e.treeData=[],e.tree_nodes=[],e.sycning=!1,e.$class=angular.copy(d),angular.extend(e.$class.icon,{1:t.iconExpand||"glyphicon glyphicon-minus",0:t.iconCollapse||"glyphicon glyphicon-plus","-1":t.iconLeaf||"glyphicon glyphicon-file"}),e.for_all_descendants=function(n,t){if(angular.isFunction(t)){var a,l,r;if(t(n))return!1;for(r=n.__children__,l=r.length,a=0;l>a;a++)if(!e.for_all_descendants(r[a],t))return!1}return!0},e.getLastDescendant=function(n){var t,a;return n||(n=e.tree?e.tree.selected_node:!1),n===!1?!1:(a=n.__children__.length,0===a?n:(t=n.__children__[a-1],e.getLastDescendant(t)))},e.getElementChilds=function(){return angular.element(n[0].querySelector("[tree-dnd-nodes]"))},e.onClick=function(n){angular.isDefined(e.tree)&&angular.isFunction(e.tree.on_click)&&setTimeout(function(){e.tree.on_click(n)},0)},e.onSelect=function(n){angular.isDefined(e.tree)&&(n!==e.tree.selected_node&&e.tree.select_node(n),angular.isFunction(e.tree.on_select)&&setTimeout(function(){e.tree.on_select(n)},0))};var a,o;e.toggleExpand=function(n,t){a=!0,angular.isFunction(t)&&!t(n)?a=!1:angular.isFunction(e.$callbacks.expand)&&!e.$callbacks.expand(n)&&(a=!1),a&&n.__children__.length>0&&(n.__expanded__=!n.__expanded__)},e.getHash=function(n){return"__uid__"===e.primary_key?"#"+n.__parent__+"#"+n.__uid__:"#"+n.__parent__+"#"+n[e.primary_key]},e.$callbacks={for_all_descendants:e.for_all_descendants,expand:function(e){return!0},accept:function(n,t,a){return e.dropEnabled===!0},calsIndent:function(n,t,a){var l=0,r=a?0:e.indent_plus;return t||(l=e.indent_unit?e.indent_unit:"px"),1>n-1?r+l:e.indent*(n-1)+r+l},droppable:function(){return e.dropEnabled===!0},draggable:function(){return e.dragEnabled===!0},beforeDrop:function(e){return!0},changeKey:function(n){var t=n.__uid__;n.__uid__=Math.random(),n.__selected__&&delete n.__selected__,"__uid__"!==e.primary_key&&(t=""+n[e.primary_key],t=t.replace(/_#.+$/g,"")+"_#"+n.__uid__,n[e.primary_key]=t)},clone:function(e,n){return o=angular.copy(e),this.for_all_descendants(o,this.changeKey),o},remove:function(e,n,t){return n.splice(e.__index__,1)[0]},add:function(e,n,t,a){t&&(t.length>-1&&n>-1?t.splice(n,0,e):t.push(e))}},(t.enableDrag||t.enableDrop)&&(e.placeElm=null,e.dragEnabled=null,e.dropEnabled=null,e.horizontal=null,t.enableDrag&&(e.dragDelay=0,e.enabledMove=!0,e.statusMove=!0,e.enabledHotkey=!1,e.enabledCollapse=null,e.statusElm=null,e.dragging=null,angular.extend(e.$callbacks,{beforeDrag:function(e){return!0},dragStop:function(e,n){},dropped:function(e,n,t){if(!e)return null;if(!e.changed&&t)return!1;var a=e.node,l=null,r=e.move,o=null,i=e.parent||e.drag.treeData,d=r.parent||e.target.treeData;return e.target.$callbacks.accept(e,e.move,e.changed)?(t?(o=i,angular.isDefined(o.__children__)&&(o=o.__children__),l=e.drag.$callbacks.remove(a,o,e.drag.$callbacks)):l=e.drag.$callbacks.clone(a,e.drag.$callbacks),t&&e.drag===e.target&&i===d&&r.pos>=e.node.__index__&&r.pos--,o=d,o.__children__&&(o=o.__children__),e.target.$callbacks.add(l,r.pos,o,e.drag.$callbacks),!0):!1},dragStart:function(e){},dragMove:function(e){}}),e.setDragging=function(n){e.dragging=n},e.enableMove=function(n){e.enabledMove="boolean"==typeof n?n:!0},t.enableStatus&&(e.enabledStatus=!1,e.hideStatus=function(){e.statusElm&&e.statusElm.addClass(e.$class.hidden)},e.refreshStatus=function(){if(e.dragging&&e.enabledStatus){var n=e.statusElm;e.statusElm=angular.element(e.enabledMove?i.getMove(e):i.getCopy(e)),n!==e.statusElm&&(n&&(e.statusElm.attr("class",n.attr("class")),e.statusElm.attr("style",n.attr("style")),n.remove()),r.find("body").append(e.statusElm)),e.statusElm.removeClass(e.$class.hidden)}},e.setPositionStatus=function(n){e.statusElm&&(e.statusElm.css({left:n.pageX+10+"px",top:n.pageY+15+"px","z-index":9999}),e.statusElm.addClass(e.$class.status))})),e.targeting=!1,e.getPrevSibling=function(n){if(n&&n.__index__>0){var t,a=n.__index__-1;return angular.isDefined(n.__parent_real__)?(t=e.tree_nodes[n.__parent_real__],t.__children__[a]):e.treeData[a]}return null},e.getNode=function(n){return angular.isUndefinedOrNull(n)?null:e.tree_nodes[n]},e.setScope=function(n,t){var a=e.getHash(t);e.$globals[a]!==n&&(e.$globals[a]=n)},e.getScope=function(n){return n?e.$globals[e.getHash(n)]:e},e.initPlace=function(n,t){var a=null,r=!1;if(n?(a=n.prop("tagName").toLowerCase(),r="tr"===a||"td"===a):(a=e.getElementChilds().prop("tagName").toLowerCase(),r="tbody"===a||"table"===a),!e.placeElm)if(r){e.placeElm=angular.element(l.document.createElement("tr"));var o=e.colDefinitions.length;for(e.placeElm.append(angular.element(l.document.createElement("td")).addClass(e.$class.empty).addClass("indented").addClass(e.$class.place));o-->0;)e.placeElm.append(angular.element(l.document.createElement("td")).addClass(e.$class.empty).addClass(e.$class.place))}else e.placeElm=angular.element(l.document.createElement("li")).addClass(e.$class.empty).addClass(e.$class.place);return t&&e.placeElm.css("height",s.height(t)+"px"),n?n[0].parentNode.insertBefore(e.placeElm[0],n[0]):e.getElementChilds().append(e.placeElm),e.placeElm},e.hidePlace=function(){e.placeElm&&e.placeElm.addClass(e.$class.hidden)},e.showPlace=function(){e.placeElm&&e.placeElm.removeClass(e.$class.hidden)},e.getScopeTree=function(){return e}),e.$safeApply=function(e){var n=this.$root.$$phase;"$apply"===n||"$digest"===n?e&&"function"==typeof e&&e():this.$apply(e)}}],compile:function(e,n){var d="",s=e.html().trim();return s.length>0&&(d=s,e.html("")),function(e,s,u){var _,g,p,f,m,h,$,b,y,v,D,E,x,w,C,S,k=function(){if(e.treeData&&e.treeData.length){var n,t,a=e.treeData[0],l=Object.keys(a),r=new RegExp("^__([a-zA-Z0-9_-]*)__$");for(t=0,n=l.length;n>t;t++)if("string"==typeof a[l[t]]&&!r.test(l[t]))return void(e.expandingProperty=l[t]);angular.isUndefinedOrNull(e.expandingProperty)&&(e.expandingProperty=l[0])}},T=function(){if(e.treeData.length){var n,t,a=[],l=e.treeData[0],r=new RegExp("(^__([a-zA-Z0-9_-]*)__$|^"+e.expandingProperty+"$)"),o=Object.keys(l);for(n=0,t=o.length;t>n;n++)"string"!=typeof l[o[n]]||r.test(o[n])||a.push({field:o[n]});e.colDefinitions=a}},A=function(n,t,a,l,r,o,i){var d,s,c,u,_,g;if(angular.isArray(t.__children__)||(t.__children__=[]),t.__parent_real__=l,t.__parent__=a,s=t.__children__.length,angular.isUndefinedOrNull(t.__expanded__)&&s>0&&(t.__expanded__=r<e.expandLevel),c=0===s?-1:t.__expanded__?1:0,u=n.length,t.__index__=i,t.__index_real__=u,t.__level__=r,t.__icon__=c,t.__visible__=!!o,angular.isUndefinedOrNull(t.__uid__)&&(t.__uid__=""+Math.random()),n.push(t),_=1,s>0)for(d=0;s>d;d++)_+=A(n,t.__children__[d],"__uid__"===e.primary_key?t.__uid__:t[e.primary_key],u,r+1,o&&t.__expanded__,d);return g=e.getHash(t),(angular.isUndefinedOrNull(t.__hashKey__)||t.__hashKey__!==g)&&(t.__hashKey__=g),t.__dept__=_,_},P=function(n){var t,a,l=[];if(console.log("---------"),angular.isDefined(n)){if(!angular.isArray(n)||0===n.length)return[];t=n}else{if(!angular.isArray(e.treeData)||0===e.treeData.length)return[];t=e.treeData}if(u.expandOn||k(),u.columnDefs||T(),angular.isDefined(e.orderBy)&&(angular.isFunction(g)||(g=c("$TreeDnDOrderBy")),angular.isFunction(g)&&(t=g(t,e.orderBy))),angular.isDefined(e.filter)&&(angular.isFunction(_)||(_=c("$TreeDnDFilter")),angular.isFunction(_)&&(t=_(t,e.filter,e.filterOptions))),a=t.length,a>0){var r,o,i,d,s,p=0;for(r=0;a>r;r++)p+=A(l,t[r],null,null,1,!0,r);if(s=Object.keys(e.$globals),a=e.$globals.length,o=a-p,0!==o)for(i=a-o,d=i-Math.abs(o),r=d;i>r;r++)delete e.$globals[s[r]]}return angular.isDefined(e.tree_nodes)&&delete e.tree_nodes,e.tree_nodes=l,l},M={showParent:!0,showChild:!1,beginAnd:!0},Y=function(e,n,t){return angular.isUndefinedOrNull(n)?!1:"*"!==n&&angular.isUndefined(e[n])?angular.isArray(n)?X(e,n,t):void 0:!0},X=function(e,n,t){var a,l=n.length,r=!1;if(0===l)return null;for(a=0;l>a;a++)if(Y(e,n[a],!t)){if(r=!0,!t)return!0}else if(t)return!1;return r},N=function(t,a,l,r,o,i,d){if(r=r||a,"string"==typeof t||angular.isArray(t)){if(angular.isFunction(d)&&d())return;"string"==typeof n[a]?e.$watch(n[a],function(e,n,a){a[r]="string"==typeof t&&typeof e===t||angular.isArray(t)&&t.indexOf(typeof e)>-1?e:angular.isFunction(l)?l(e):l,angular.isFunction(i)&&i(a[r],a)},!0):angular.isFunction(o)?e[r]=o():angular.isUndefined(o)||(e[r]=o)}},O=[["enableDrag",[["boolean","enableStatus",null,"enabledStatus"],["boolean","enableMove",null,"enabledMove"],["number","dragDelay",0,null,0],["boolean","enableCollapse",null,"enabledCollapse"],["boolean","enableHotkey",null,"enabledHotkey",null,function(n){e.enabledMove=n?!1:e.statusMove}]]],[["enableDrag","enableStatus"],[["string","templateCopy",u.templateCopy,"templateCopy",null,function(n){n&&o.get(n)&&i.setCopy(n,e)}],["string","templateMove",u.templateMove,"templateMove",null,function(n){n&&o.get(n)&&i.setMove(n,e)}]]],[[["enableDrag","enableDrop"]],[["number","dragBorder",30,"dragBorder",30]]],["*",[["boolean","horizontal"],["callback","treeClass",function(n){switch(typeof n){case"string":e.$tree_class=n;break;case"object":angular.extend(e.$class,n),e.$tree_class=e.$class.tree;break;default:e.$tree_class=u.treeClass}},"treeClass",function(){e.$tree_class=e.$class.tree+" table"},null,function(){return/^(\s+[\w\-]+){2,}$/g.test(" "+u.treeClass)?(e.$tree_class=u.treeClass.trim(),!0):void 0}],[["object","string"],"expandOn",k,"expandingProperty",k,function(n){angular.isUndefinedOrNull(n)&&(e.expandingProperty=u.expandOn)}],["object","treeControl",angular.isDefined(e.tree)?e.tree:{},"tree",null,function(n){angular.isFunction(p)||(p=c("$TreeDnDControl")),angular.isFunction(p)&&(m=angular.extend(n,p(e)))}],[["array","object"],"columnDefs",T,"colDefinitions",T,function(n){(angular.isUndefinedOrNull(n)||!angular.isArray(n))&&(e.colDefinitions=T())}],[["object","string","array","function"],"orderBy",u.orderBy],[["object","array"],"filter",null,"filter",null,function(n){var t=!1;if(angular.isDefined(n)&&!angular.isArray(n)){var a,l=Object.keys(n),r=l.length;if(r>0)for(a=0;r>a;a++)if("string"!=typeof n[l[a]]||0!==n[l[a]].length){t=!0;break}}e.enabledFilter=t,P()}],["object","filterOptions",M,"filterOptions",M,function(n){"object"==typeof n&&(e.filterOptions=angular.extend(M,n))}],["string","primaryKey",u.primaryKey,"primary_key","__uid__"],["string","indentUnit",u.indentUnit,"indent_unit"],["number","indent",30,null,30],["number","indentPlus",20,null,20],["null","callbacks",function(n){return angular.forEach(n,function(n,t){"function"==typeof n&&e.$callbacks[t]&&(e.$callbacks[t]=n)}),e.$callbacks},"$callbacks"],["number","expandLevel",3,"expandLevel",3,function(){P()}],["boolean","enableDrag",null,"dragEnabled"],["boolean","enableDrop",null,"dropEnabled"]]]],I=O.length;for(h=0;I>h;h++)if(Y(u,O[h][0],!0))for(y=O[h][1],$=0,b=y.length;b>$;$++)v=y[$][0],D=y[$][1],E=y[$][2],x=y[$][3],w=y[$][4],C=y[$][5],S=y[$][6],N(v,D,E,x,w,C,S);u.treeData&&e.$watch(u.treeData,function(n){e.treeData=n},!0),e.$watch("treeData",function(e){P(e)},!0),e.reload_data=P,u.enableDrag&&(f=c("$TreeDnDDrag"),angular.isFunction(f)&&f(e,s,l,r)),e.$safeApply(function(){d.length>0?s.append(a(d)(e)):t.get(u.templateUrl||i.getPath(),{cache:o}).success(function(n){s.append(a(n.trim())(e))})})}}}}]).factory("$TreeDnDConvert",function(){var e={line2tree:function(e,n,t){if(!e||0===e.length||!n||!t)return[];for(var a,l,r=[],o=[],i=e[0],d=i[n],s={},c=e.length,u=0;c>u;)i=e[u++],d=i[n],s[d]=i,a=i[t],a?(l=s[a],l.__children__?l.__children__.push(i):l.__children__=[i]):o.push(d);for(c=o.length,u=0;c>u;u++)r.push(s[o[u]]);return r},tree2tree:function(e,n){var t=function(e){var a,l,r,o=[],i=e.length;for(a=0;i>a;a++)l=angular.copy(e[a]),angular.isArray(l[n])&&l[n].length>0&&(r=t(l[n]),delete l[n],l.__children__=r),o.push(l);return o};return t(e)}};return e}).factory("$TreeDnDHelper",["$document","$window",function(e,n){var t={nodrag:function(e){return"undefined"!=typeof e.attr("data-nodrag")},eventObj:function(e){var n=e;return void 0!==e.targetTouches?n=e.targetTouches.item(0):void 0!==e.originalEvent&&void 0!==e.originalEvent.targetTouches&&(n=e.originalEvent.targetTouches.item(0)),n},dragInfo:function(e){var n=e.getData(),t=e.getScopeTree(),a=e.getNode(n.__parent_real__);return{node:n,parent:a,move:{parent:a,pos:n.__index__},scope:e,target:t,drag:t,drop:e.getPrevSibling(n),changed:!1}},height:function(e){return e.prop("scrollHeight")},width:function(e){return e.prop("scrollWidth")},offset:function(t){var a=t[0].getBoundingClientRect();return{width:t.prop("offsetWidth"),height:t.prop("offsetHeight"),top:a.top+(n.pageYOffset||e[0].body.scrollTop||e[0].documentElement.scrollTop),left:a.left+(n.pageXOffset||e[0].body.scrollLeft||e[0].documentElement.scrollLeft)}},positionStarted:function(e,n){var t={};return t.offsetX=e.pageX-this.offset(n).left,t.offsetY=e.pageY-this.offset(n).top,t.startX=t.lastX=e.pageX,t.startY=t.lastY=e.pageY,t.nowX=t.nowY=t.distX=t.distY=t.dirAx=0,t.dirX=t.dirY=t.lastDirX=t.lastDirY=t.distAxX=t.distAxY=0,t},positionMoved:function(e,n,t){n.lastX=n.nowX,n.lastY=n.nowY,n.nowX=e.pageX,n.nowY=e.pageY,n.distX=n.nowX-n.lastX,n.distY=n.nowY-n.lastY,n.lastDirX=n.dirX,n.lastDirY=n.dirY,n.dirX=0===n.distX?0:n.distX>0?1:-1,n.dirY=0===n.distY?0:n.distY>0?1:-1;var a=Math.abs(n.distX)>Math.abs(n.distY)?1:0;return t?(n.dirAx=a,void(n.moving=!0)):(n.dirAx!==a?(n.distAxX=0,n.distAxY=0):(n.distAxX+=Math.abs(n.distX),0!==n.dirX&&n.dirX!==n.lastDirX&&(n.distAxX=0),n.distAxY+=Math.abs(n.distY),0!==n.dirY&&n.dirY!==n.lastDirY&&(n.distAxY=0)),void(n.dirAx=a))},replaceIndent:function(e,n,t,a){a=a?a:"left",angular.element(n.children()[0]).css(a,e.$callbacks.calsIndent(t))}};return t}]).factory("$TreeDnDPlugin",["$injector",function(e){var n=function(n){return angular.isDefined(e)&&e.has(n)?e.get(n):null};return n}]).factory("$TreeDnDTemplate",["$templateCache",function(e){var n,t="template/TreeDnD/TreeDnD.html",a="template/TreeDnD/TreeDnDStatusCopy.html",l="template/TreeDnD/TreeDnDStatusMove.html",r={},o={setMove:function(e,n){r[n.$id]||(r[n.$id]={}),r[n.$id].movePath=e},setCopy:function(e,n){r[n.$id]||(r[n.$id]={}),r[n.$id].copyPath=e},getPath:function(){return t},getCopy:function(t){return r[t.$id]&&r[t.$id].copyPath&&(n=e.get(r[t.$id].copyPath))?n:e.get(a)},getMove:function(t){return r[t.$id]&&r[t.$id].movePath&&(n=e.get(r[t.$id].movePath))?n:e.get(l)}};return o}]).factory("$TreeDnDFilter",["$filter",function(e){var n,t,a,l,r,o=function p(e,n,t,a,l,r){if(!angular.isFunction(a))return null;var o,i,d,s=a(e,n),c=!1;if(angular.isDefined(n[t]))for(d=n[t],i=d.length,o=0;i>o;o++)c=p(e,d[o],t,a,l,s||r)||c;return angular.isFunction(l)&&l(e,n,s===!0,c===!0,r===!0),s||c},i=function(n,t){if(angular.isUndefinedOrNull(t)||angular.isArray(t))return null;if(angular.isFunction(n))return n(t,e);if("boolean"==typeof n)return t=!!t,t===n;if(!angular.isDefined(n))return null;try{var a=new RegExp(n);return a.test(t)}catch(l){return"string"==typeof t?t.indexOf(n)>-1:null}},d=function(e,n,t){if(angular.isArray(n))return s(e,n,t);var a,l,r,o=n.field,d=n.callback;if("_$"===o){for(l=Object.keys(e),r=l.length,a=0;r>a;a++)if(i(d,e[l[a]]))return!0}else if(angular.isDefined(e[o]))return i(d,e[o])},s=function(e,n,t){var a,l=n.length,r=!1;if(0===l)return null;for(a=0;l>a;a++)if(d(e,n[a],!t)){if(r=!0,!t)return!0}else if(t)return!1;return r},c=function(e,n,t,a,l){return t===!0?(n.__filtered__=!0,void(n.__filtered_visible__=!0)):a===!0&&e.showParent===!0||l===!0&&e.showChild===!0?(n.__filtered__=!1,void(n.__filtered_visible__=!0)):(delete n.__filtered__,void delete n.__filtered_visible__)},u=function(e,n){return 0===e.filter.length?!0:d(n,e.filter,e.beginAnd||!1)},_=function f(e){if(angular.isObject(e)&&!angular.isArray(e)){if(a=Object.keys(e),t=a.length,l=[],t>0)for(n=0;t>n;n++)("string"!=typeof e[a[n]]||0!==e[a[n]].length)&&(r=angular.isArray(e[a[n]])?e[a[n]]:angular.isObject(e[a[n]])?f(e[a[n]]):{field:a[n],callback:e[a[n]]},l.push(r));return r=null,l}return e},g=function(e,n,t){if(!angular.isArray(e)||0===e.length||!angular.isArray(n)&&!angular.isObject(n)||0===n.length)return e;var a,l,r;if(r=_(n),!angular.isArray(r)&&!angular.isObject(r)||0===r.length)return e;for(t.filter=r,a=0,l=e.length;l>a;a++)o(t,e[a],"__children__",u,c);return e};return g}]).factory("$TreeDnDOrderBy",["$filter",function(e){var n=e("orderBy"),t=function r(e,n,t,a){var l,o,i;if(angular.isDefined(n[t])){for(i=n[t],o=i.length,l=0;o>l;l++)i[l]=r(e,i[l],t,a);n[t]=a(n[t],e)}return n},a=function(e,t){return n(e,t)},l=function(e,n){if(!angular.isArray(e)||0===e.length||!(angular.isArray(n)||angular.isObject(n)||angular.isString(n)||angular.isFunction(n))||0===n.length&&!angular.isFunction(n))return e;var l,r;for(l=0,r=e.length;r>l;l++)e[l]=t(n,e[l],"__children__",a);return e=a(e,n)};return l}]).factory("$TreeDnDDrag",["$timeout","$TreeDnDHelper",function(e,n){var t,a=function(e,a){return a.placeElm&&(t=n.offset(a.placeElm),t.top<=e.pageY&&e.pageY<=t.top+t.height&&t.left<=e.pageX&&e.pageX<=t.left+t.width)?!0:!1},l=function(e,t){if((t.hasTouch||2!==e.button&&3!==e.which)&&!(e.uiTreeDragging||e.originalEvent&&e.originalEvent.uiTreeDragging)){var a=angular.element(e.target),l=a.scope();if(l&&l.$type&&"TreeDnDNodeHandle"===l.$type){var r,o=a.prop("tagName").toLowerCase(),i=t.$scope;if("input"!==o&&"textarea"!==o&&"button"!==o&&"select"!==o){for(;a&&a[0]&&a[0]!==t.element;){if(n.nodrag(a))return;a=a.parent()}if(e.uiTreeDragging=!0,e.originalEvent&&(e.originalEvent.uiTreeDragging=!0),e.preventDefault(),r=l.getScopeNode(),t.firstMoving=!0,i.$callbacks.beforeDrag(r)){var d=n.eventObj(e),s=r.$element.prop("tagName").toLowerCase(),c="tr"===s;t.dragInfo=n.dragInfo(r),i.setDragging(t.dragInfo),t.pos=n.positionStarted(d,r.$element),t.dragElm=c?angular.element(t.$window.document.createElement("table")).addClass(i.$class.tree).addClass(i.$class.drag).addClass(i.$tree_class):angular.element(t.$window.document.createElement("ul")).addClass(i.$class.drag).addClass("tree-dnd-nodes").addClass(i.$tree_class),t.dragElm.css({width:n.width(r.$element)+"px","z-index":9995}),t.offsetEdge=0;var u=n.width(r.$element),_=r,g=_.$element,p=null,f=!!i.enabledCollapse,m=!1,h=null;if(c)t.offsetEdge=t.dragInfo.node.__level__-1,h=angular.element(t.$window.document.createElement("tbody")),i.for_all_descendants(t.dragInfo.node,function(e){_=i.getScope(e),g=_.$element,m||(p=g.clone(),n.replaceIndent(_,p,e.__level__-t.offsetEdge,"padding-left"),h.append(p),f&&(m=!0)),i.enabledMove&&i.$class.hidden&&g.addClass(i.$class.hidden)}),t.dragElm.append(h);else{if(f){var $=_.getElementChilds(),b=angular.element("<swaped />");$.after(angular.element("<holder />")),b.append($),p=g.clone(),p.find("holder").remove(),g.find("holder").replaceWith($),b.remove(),$=null}else p=g.clone();t.dragElm.append(p),i.enabledMove&&i.$class.hidden&&g.addClass(i.$class.hidden)}t.dragElm.css({left:d.pageX-t.pos.offsetX+i.$callbacks.calsIndent(t.offsetEdge+1,!0,!0)+"px",top:d.pageY-t.pos.offsetY+"px"}),t.$document.find("body").append(t.dragElm),i.$callbacks.droppable()&&(t.placeElm=i.initPlace(r.$element,t.dragElm),c&&n.replaceIndent(i,t.placeElm,t.dragInfo.node.__level__),t.placeElm.css("width",u)),i.showPlace(),i.targeting=!0,i.enabledStatus&&(i.refreshStatus(),i.setPositionStatus(e)),angular.element(t.$document).bind("touchend",t.dragEndEvent),angular.element(t.$document).bind("touchcancel",t.dragEndEvent),angular.element(t.$document).bind("touchmove",t.dragMoveEvent),angular.element(t.$document).bind("mouseup",t.dragEndEvent),angular.element(t.$document).bind("mousemove",t.dragMoveEvent),angular.element(t.$document).bind("mouseleave",t.dragCancelEvent),t.document_height=Math.max(t.body.scrollHeight,t.body.offsetHeight,t.html.clientHeight,t.html.scrollHeight,t.html.offsetHeight),t.document_width=Math.max(t.body.scrollWidth,t.body.offsetWidth,t.html.clientWidth,t.html.scrollWidth,t.html.offsetWidth)}}}}},r=function(e,t){var l=t.$scope;if(!t.dragStarted)return void(t.dragDelaying||(t.dragStarted=!0,l.$safeApply(function(){l.$callbacks.dragStart(t.dragInfo)})));if(t.dragElm){e.preventDefault(),t.$window.getSelection?t.$window.getSelection().removeAllRanges():t.$window.document.selection&&t.$window.document.selection.empty();var r=n.eventObj(e),o=r.pageX-t.pos.offsetX,i=r.pageY-t.pos.offsetY;0>o&&(o=0),0>i&&(i=0),i+10>t.document_height&&(i=t.document_height-10),o+10>t.document_width&&(o=t.document_width-10),t.dragElm.css({left:o+l.$callbacks.calsIndent(t.offsetEdge+1,!0,!0)+"px",top:i+"px"}),l.enabledStatus&&l.setPositionStatus(e);var d=window.pageYOffset||t.$window.document.documentElement.scrollTop,s=d+(window.innerHeight||t.$window.document.clientHeight||t.$window.document.clientHeight);if(s<r.pageY&&s<=t.document_height&&window.scrollBy(0,10),d>r.pageY&&window.scrollBy(0,-10),n.positionMoved(e,t.pos,t.firstMoving),t.firstMoving)return void(t.firstMoving=!1);var c,u,_,g,p,f,m,h,$,b,y,v,D=r.pageX-t.$window.document.body.scrollLeft,E=r.pageY-(window.pageYOffset||t.$window.document.documentElement.scrollTop),x=!0,w=!0,C=t.dragInfo,S=C.move,k=C.node,T=C.drop,A=C.target,P=a(e,t);if(!P){if(c=angular.element(t.$window.document.elementFromPoint(D,E)),u=c.scope(),!u)return;if(v=function(){if(A=u.getScopeTree(),b=C.target,C.target!==A){if(!A.$callbacks.droppable())return!1;b.hidePlace(),b.targeting=!1,A.targeting=!0,C.target=A,t.placeElm=A.initPlace(u.$element,t.dragElm),b=null,h=!0}return!0},angular.isFunction(u.getScopeNode)){if(u=u.getScopeNode(),!v())return}else{if("TreeDnDNodes"!==u.$type&&"TreeDnD"!==u.$type)return;if(!u.tree_nodes)return;if(0===u.tree_nodes.length){if(!v())return;m=!0}}}if((t.pos.dirAx&&!h||P)&&(w=!1,u=C.scope),!u.$element&&!u)return;if(p=u.$element.prop("tagName").toLowerCase(),f="tbody"===p||"table"===p||"tr"===p||"td"===p,m)S.parent=null,S.pos=0,T=null;else if(w){if(c=u.$element,g=n.offset(c),u.horizontal&&!f)_=r.pageX<g.left+n.width(c)/2;else if(f)_=r.pageY<g.top+n.height(c)/2;else{var M=n.height(c);if(u.getElementChilds()&&(M-=-n.height(u.getElementChilds())),r.pageY>g.top+M)return;_=r.pageY<g.top+M/2}if(!angular.isFunction(u.getData))return;if(b=u.getData(),y=u.getNode(b.__parent_real__),_){var Y=u.getPrevSibling(b);S.parent=y,S.pos=angular.isDefined(Y)?Y.__index__+1:0,T=Y}else!b.__expanded__||1===b.__children__.length&&b.__index_real__===k.__parent_real__?(S.parent=y,S.pos=b.__index__+1,T=b):(S.parent=b,S.pos=0,T=null)}else{if(!(t.pos.dirAx&&t.pos.distAxX>=A.dragBorder))return;if(t.pos.distAxX=0,t.pos.distX>0){if(y=T,!y){if(!(S.pos-1>=0))return;y=S.parent.__children__[S.pos-1]}if(C.drag===C.target&&y===k&&l.enabledMove&&(y=A.getPrevSibling(y)),!y||!y.__visible__)return;var X=y.__children__.length;S.parent=y,S.pos=X,T=X>0?y.__children__[X-1]:null}else{if(!(t.pos.distX<0))return;if(b=S.parent,!b||!(0===b.__children__.length||b.__children__.length-1<S.pos||C.drag===C.target&&b.__index_real__===k.__parent_real__&&b.__children__.length-1===k.__index__&&l.enabledMove))return;y=A.getNode(b.__parent_real__),S.parent=y,S.pos=b.__index__+1,T=b}}C.drag===C.target&&S.parent&&k.__parent_real__===S.parent.__index_real__&&k.__index__===S.pos&&(x=!1),A.$callbacks.accept(C,S,x)&&(C.move=S,C.drop=T,C.changed=x,C.scope=u,f?(n.replaceIndent(A,t.placeElm,angular.isUndefinedOrNull(S.parent)?1:S.parent.__level__+1),T?(y=(S.parent?S.parent.__children__:null)||C.target.treeData,T.__index__<y.length-1?(T=y[T.__index__+1],$=C.target.getScope(T),$.$element[0].parentNode.insertBefore(t.placeElm[0],$.$element[0])):(b=C.target.getLastDescendant(T),$=C.target.getScope(b),$.$element.after(t.placeElm))):($=C.target.getScope(S.parent),$&&(S.parent?$.$element.after(t.placeElm):$.getElementChilds().prepend(t.placeElm)))):($=C.target.getScope(T||S.parent),T?$.$element.after(t.placeElm):$.getElementChilds().prepend(t.placeElm)),A.showPlace(),l.$safeApply(function(){l.$callbacks.dragMove(C)}))}},o=function(e,n){if(e.preventDefault(),n.dragElm){var t=!1,a=n.$scope,l=a.getScope(n.dragInfo.node),r=l.$element.prop("tagName").toLowerCase(),o="tr"===r,i=l.$element;a.$safeApply(function(){t=a.$callbacks.beforeDrop(n.dragInfo)}),o?a.for_all_descendants(n.dragInfo.node,function(e){l=a.getScope(e),i=l.$element,l.$class.hidden&&i.removeClass(a.$class.hidden)}):a.$class.hidden&&i.removeClass(a.$class.hidden),n.dragElm.remove(),n.dragElm=null,a.enabledStatus&&a.hideStatus();var s=!1;a.$$apply?a.$safeApply(function(){s=a.$callbacks.dropped(n.dragInfo,t,a.enabledMove)}):d(n),a.$safeApply(function(){a.$callbacks.dragStop(n.dragInfo,s)}),n.dragInfo.target.hidePlace(),n.dragInfo.target.targeting=!1,n.dragInfo=null,a.$$apply=!1,a.setDragging(null)}angular.element(n.$document).unbind("touchend",n.dragEndEvent),angular.element(n.$document).unbind("touchcancel",n.dragEndEvent),angular.element(n.$document).unbind("touchmove",n.dragMoveEvent),angular.element(n.$document).unbind("mouseup",n.dragEndEvent),angular.element(n.$document).unbind("mousemove",n.dragMoveEvent),angular.element(n.$window.document.body).unbind("mouseleave",n.dragCancelEvent)},i=function(e,n){n.$scope.$callbacks.draggable()&&l(e,n)},d=function(n){n.element.bind("touchstart mousedown",function(t){n.dragDelaying=!0,n.dragStarted=!1,i(t,n),n.dragTimer=e(function(){n.dragDelaying=!1},n.$scope.dragDelay)}),n.element.bind("touchend touchcancel mouseup",function(){e.cancel(n.dragTimer)})},s=function(e,n){var t=n.$scope;if(27===e.keyCode)t.enabledStatus&&t.hideStatus(),t.$$apply=!1,o(e,n);else if(t.enabledHotkey&&e.shiftKey){if(t.enableMove(!0),t.enabledStatus&&t.refreshStatus(),!n.dragInfo)return;var a=t.getScope(n.dragInfo.node),l=a.$element.prop("tagName").toLowerCase(),r=a.$element;"tr"===l?t.for_all_descendants(n.dragInfo.node,function(e){a=t.getScope(e),r=a.$element,t.$class.hidden&&r.addClass(t.$class.hidden)}):t.$class.hidden&&r.addClass(t.$class.hidden)}},c=function(e,n){var t=n.$scope;if(t.enabledHotkey&&!e.shiftKey){if(t.enableMove(!1),t.enabledStatus&&t.refreshStatus(),!n.dragInfo)return;var a=t.getScope(n.dragInfo.node),l=a.$element.prop("tagName").toLowerCase(),r=a.$element;"tr"===l?t.for_all_descendants(n.dragInfo.node,function(e){a=t.getScope(e),r=a.$element,t.$class.hidden&&r.removeClass(t.$class.hidden)}):t.$class.hidden&&r.removeClass(t.$class.hidden)}},u=function(e,n,t,a){var l={hasTouch:"ontouchstart"in window,firstMoving:null,dragInfo:null,pos:null,placeElm:null,dragElm:null,dragDelaying:!0,dragStarted:!1,dragTimer:null,body:document.body,html:document.documentElement,document_height:null,document_width:null,offsetEdge:null,$scope:e,$window:t,$document:a,element:n,bindDrag:function(){d(l)},dragEnd:function(e){o(e,l)},dragMoveEvent:function(e){r(e,l)},dragEndEvent:function(n){e.$$apply=!0,o(n,l)},dragCancelEvent:function(e){o(e,l)}},i=function(e){return s(e,l)},u=function(e){return c(e,l)};e.dragEnd=function(e){l.dragEnd(e)},l.bindDrag(),angular.element(t.document.body).bind("keydown",i),angular.element(t.document.body).bind("keyup",u),e.$on("$destroy",function(){angular.element(t.document.body).unbind("keydown",i),angular.element(t.document.body).unbind("keyup",u),e.statusElm&&e.statusElm.remove(),e.placeElm&&e.placeElm.remove()})};return u}]).factory("$TreeDnDControl",function(){var e,n,t,a,l=function(e){e.__expanded__=!1},r=function(e){e.__expanded__=!0},o=function(o){var i,d={selected_node:null,for_all_descendants:o.for_all_descendants,select_node:function(e){return e?(e!==d.selected_node&&(d.selected_node&&delete d.selected_node.__selected__,e.__selected__=!0,d.selected_node=e,d.expand_all_parents(e),angular.isFunction(d.on_select)&&d.on_select(e)),e):(d.selected_node&&delete d.selected_node.__selected__,d.selected_node=null,null)},deselect_node:function(){return e=null,d.selected_node&&(delete d.selected_node.__selected__,e=d.selected_node,d.selected_node=null),e},get_parent:function(e){return e&&null!==e.__parent_real__?o.tree_nodes[e.__parent_real__]:null},for_all_ancestors:function(e,t){return n=d.get_parent(e),n?t(n)?!1:d.for_all_ancestors(n,t):!0},expand_all_parents:function(e){return d.for_all_ancestors(e,r)},reload_data:function(){return o.reload_data()},add_node:function(e,n,t){return"number"!=typeof t?e?(e.__children__.push(n),e.__expanded__=!0):o.treeData.push(n):e?(e.__children__.splice(t,0,n),e.__expanded__=!0):o.treeData.splice(t,0,n),n},add_node_root:function(e){return d.add_node(null,e),e},expand_all:function(){for(a=o.treeData.length,t=0;a>t;t++)d.for_all_descendants(o.treeData[t],r)},collapse_all:function(){for(a=o.treeData.length,t=0;a>t;t++)d.for_all_descendants(o.treeData[t],l)},remove_node:function(e){e=e||d.selected_node,e&&(n=e.__parent_real__?d.get_parent(e).__children__:o.treeData,n.splice(e.__index__,1),d.selected_node===e&&(d.selected_node=null))},expand_node:function(e){return e=e||d.selected_node,e?(e.__expanded__=!0,e):void 0},collapse_node:function(e){return e=e||d.selected_node,e?(e.__expanded__=!1,e):void 0},get_selected_node:function(){return d.selected_node},get_first_node:function(){return a=o.treeData.length,a>0?o.treeData[0]:null},get_children:function(e){return e.__children__},get_siblings:function(t){return t=t||d.selected_node,t?(n=d.get_parent(t),e=n?n.__children__:o.treeData):void 0},get_next_sibling:function(n){return n=n||d.selected_node,n&&(e=d.get_siblings(n),i=e.length,n.__index__<i)?e[n.__index__+1]:void 0},get_prev_sibling:function(n){return n=n||d.selected_node,e=d.get_siblings(n),n.__index__>0?e[n.__index__-1]:void 0},get_first_child:function(n){return n=n||d.selected_node,n&&(e=n.__children__,e&&e.length>0)?n.__children__[0]:null},get_closest_ancestor_next_sibling:function(t){return t=t||d.selected_node,(e=d.get_next_sibling(t))?e:(n=d.get_parent(t),
d.get_closest_ancestor_next_sibling(n))},get_next_node:function(n){return n=n||d.selected_node,n?(e=d.get_first_child(n),e?e:d.get_closest_ancestor_next_sibling(n)):void 0},get_prev_node:function(t){return t=t||d.selected_node,t?(e=d.get_prev_sibling(t))?d.get_last_descendant(e):n=d.get_parent(t):void 0},get_last_descendant:o.getLastDescendant,select_parent_node:function(e){return e=e||d.selected_node,e&&(n=d.get_parent(e))?d.select_node(n):void 0},select_first_node:function(){return d.select_node(d.get_first_node())},select_next_sibling:function(n){return n=n||d.selected_node,n&&(e=d.get_next_sibling(n))?d.select_node(e):void 0},select_prev_sibling:function(n){return n=n||d.selected_node,n&&(e=d.get_prev_sibling(n))?d.select_node(e):void 0},select_next_node:function(n){return n=n||d.selected_node,n&&(e=d.get_next_node(n))?d.select_node(e):void 0},select_prev_node:function(n){return n=n||d.selected_node,n&&(e=d.get_prev_node(n))?d.select_node(e):void 0}};return angular.extend(o.tree,d),o.tree};return o}),angular.module("template/TreeDnD/TreeDnD.html",[]).run(["$templateCache",function(e){e.put("template/TreeDnD/TreeDnD.html",['<table ng-class="$tree_class">',"    <thead>","  <tr>",'     <th ng-class="expandingProperty.titleClass" ng-style="expandingProperty.titleStyle">',"         {{expandingProperty.displayName || expandingProperty.field || expandingProperty}}","        </th>",'        <th ng-repeat="col in colDefinitions" ng-class="col.titleClass" ng-style="col.titleStyle">',"         {{col.displayName || col.field}}","     </th>","    </tr>","    </thead>",' <tbody tree-dnd-nodes="tree_nodes">','  <tr tree-dnd-node="node" ng-repeat="node in nodes track by node.__hashKey__ " ng-show="node.__visible__"',"       ng-click=\"onSelect(node)\" ng-class=\"(node.__selected__ ? ' active':'')\">",'        <td ng-if="!expandingProperty.template" tree-dnd-node-handle',"         ng-style=\"expandingProperty.cellStyle ? expandingProperty.cellStyle : {'padding-left': $callbacks.calsIndent(node.__level__)}\"",'          ng-class="expandingProperty.cellClass"','            compile="expandingProperty.cellTemplate">',"              <a data-nodrag>",'                  <i ng-class="$icon_class" ng-click="toggleExpand(node)"','                     class="tree-icon"></i>',"              </a>","             {{node[expandingProperty.field] || node[expandingProperty]}}","       </td>",'        <td ng-if="expandingProperty.template" compile="expandingProperty.template"></td>','        <td ng-repeat="col in colDefinitions" ng-class="col.cellClass" ng-style="col.cellStyle"','            compile="col.cellTemplate">',"            {{node[col.field]}}","       </td>","    </tr>","    </tbody>","</table>"].join("")),e.put("template/TreeDnD/TreeDnDStatusCopy.html",'<label><i class="fa fa-copy"></i>&nbsp;<b>Copying</b></label>'),e.put("template/TreeDnD/TreeDnDStatusMove.html",'<label><i class="fa fa-file-text"></i>&nbsp;<b>Moving</b></label>')}])}).call(window);
//# sourceMappingURL=/ng-tree-dnd.min.js.map