/*!
 * ui-grid - v4.4.10 - 2018-05-15
 * Copyright (c) 2018 ; License: MIT 
 */


!function(){"use strict";var e=angular.module("ui.grid.importer",["ui.grid"]);e.constant("uiGridImporterConstants",{featureName:"importer"}),e.service("uiGridImporterService",["$q","uiGridConstants","uiGridImporterConstants","gridUtil","$compile","$interval","i18nService","$window",function(e,i,r,n,t,o,a,s){var l={initializeGrid:function(e,r){r.importer={$scope:e},this.defaultGridOptions(r.options);var t={events:{importer:{}},methods:{importer:{importFile:function(e){l.importThisFile(r,e)}}}};r.api.registerEventsFromObject(t.events),r.api.registerMethodsFromObject(t.methods),r.options.enableImporter&&r.options.importerShowMenu&&(r.api.core.addToGridMenu?l.addToMenu(r):o(function(){r.api.core.addToGridMenu&&l.addToMenu(r)},100,1))},defaultGridOptions:function(e){e.enableImporter||void 0===e.enableImporter?s.hasOwnProperty("File")&&s.hasOwnProperty("FileReader")&&s.hasOwnProperty("FileList")&&s.hasOwnProperty("Blob")?e.enableImporter=!0:(n.logError("The File APIs are not fully supported in this browser, grid importer cannot be used."),e.enableImporter=!1):e.enableImporter=!1,e.importerProcessHeaders=e.importerProcessHeaders||l.processHeaders,e.importerHeaderFilter=e.importerHeaderFilter||function(e){return e},e.importerErrorCallback&&"function"==typeof e.importerErrorCallback||delete e.importerErrorCallback,!0!==e.enableImporter||e.importerDataAddCallback||(n.logError("You have not set an importerDataAddCallback, importer is disabled"),e.enableImporter=!1),e.importerShowMenu=!1!==e.importerShowMenu,e.importerObjectCallback=e.importerObjectCallback||function(e,r){return r}},addToMenu:function(r){r.api.core.addToGridMenu(r,[{title:a.getSafeText("gridMenu.importerTitle"),order:150},{templateUrl:"ui-grid/importerMenuItemContainer",action:function(e){this.grid.api.importer.importAFile(r)},order:151}])},importThisFile:function(e,r){if(r){var t=new FileReader;switch(r.type){case"application/json":t.onload=l.importJsonClosure(e);break;default:t.onload=l.importCsvClosure(e)}t.readAsText(r)}else n.logError("No file object provided to importThisFile, should be impossible, aborting")},importJsonClosure:function(i){return function(e){var t,o=[],r=l.parseJson(i,e);null!==r&&(r.forEach(function(e,r){t=l.newObject(i),angular.extend(t,e),t=i.options.importerObjectCallback(i,t),o.push(t)}),l.addObjects(i,o))}},parseJson:function(r,t){var e;try{e=JSON.parse(t.target.result)}catch(e){return void l.alertError(r,"importer.invalidJson","File could not be processed, is it valid json? Content was: ",t.target.result)}return Array.isArray(e)?e:(l.alertError(r,"importer.jsonNotarray","Import failed, file is not an array, file was: ",t.target.result),[])},importCsvClosure:function(o){return function(e){var r=l.parseCsv(e);if(!r||r.length<1)l.alertError(o,"importer.invalidCsv","File could not be processed, is it valid csv? Content was: ",e.target.result);else{var t=l.createCsvObjects(o,r);t&&0!==t.length?l.addObjects(o,t):l.alertError(o,"importer.noObjects","Objects were not able to be derived, content was: ",e.target.result)}}},parseCsv:function(e){var r=e.target.result;return CSV.parse(r)},createCsvObjects:function(t,e){var o=t.options.importerProcessHeaders(t,e.shift());if(!o||0===o.length)return l.alertError(t,"importer.noHeaders","Column names could not be derived, content was: ",e),[];var i,n=[];return e.forEach(function(e,r){i=l.newObject(t),null!==e&&e.forEach(function(e,r){null!==o[r]&&(i[o[r]]=e)}),i=t.options.importerObjectCallback(t,i),n.push(i)}),n},processHeaders:function(e,r){var t=[];if(e.options.columnDefs&&0!==e.options.columnDefs.length){var o=l.flattenColumnDefs(e,e.options.columnDefs);return r.forEach(function(e,r){o[e]?t.push(o[e]):o[e.toLowerCase()]?t.push(o[e.toLowerCase()]):t.push(null)}),t}return r.forEach(function(e,r){t.push(e.replace(/[^0-9a-zA-Z\-_]/g,"_"))}),t},flattenColumnDefs:function(t,e){var o={};return e.forEach(function(e,r){e.name&&(o[e.name]=e.field||e.name,o[e.name.toLowerCase()]=e.field||e.name),e.field&&(o[e.field]=e.field||e.name,o[e.field.toLowerCase()]=e.field||e.name),e.displayName&&(o[e.displayName]=e.field||e.name,o[e.displayName.toLowerCase()]=e.field||e.name),e.displayName&&t.options.importerHeaderFilter&&(o[t.options.importerHeaderFilter(e.displayName)]=e.field||e.name,o[t.options.importerHeaderFilter(e.displayName).toLowerCase()]=e.field||e.name)}),o},addObjects:function(e,r,t){if(e.api.rowEdit){var o=e.registerDataChangeCallback(function(){e.api.rowEdit.setRowsDirty(r),o()},[i.dataChange.ROW]);e.importer.$scope.$on("$destroy",o)}e.importer.$scope.$apply(e.options.importerDataAddCallback(e,r))},newObject:function(e){return void 0!==e.options&&void 0!==e.options.importerNewObject?new e.options.importerNewObject:{}},alertError:function(e,r,t,o){e.options.importerErrorCallback?e.options.importerErrorCallback(e,r,t,o):(s.alert(a.getSafeText(r)),n.logError(t+o))}};return l}]),e.directive("uiGridImporter",["uiGridImporterConstants","uiGridImporterService","gridUtil","$compile",function(e,i,r,t){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(e,r,t,o){i.initializeGrid(e,o.grid)}}}]),e.directive("uiGridImporterMenuItem",["uiGridImporterConstants","uiGridImporterService","gridUtil","$compile",function(e,a,s,r){return{replace:!0,priority:0,require:"?^uiGrid",scope:!1,templateUrl:"ui-grid/importerMenuItem",link:function(e,r,t,o){var i;var n=r[0].querySelectorAll(".ui-grid-importer-file-chooser");1!==n.length?s.logError("Found > 1 or < 1 file choosers within the menu item, error, cannot continue"):n[0].addEventListener("change",function(e){var r=e.srcElement||e.target;if(r&&r.files&&1===r.files.length){var t=r.files[0];void 0!==o&&o?(i=o.grid,a.importThisFile(i,t),r.form.reset()):s.logError("Could not import file because UI Grid was not found.")}},!1)}}}])}();