/*!
 * ui-grid - v4.4.3 - 2018-03-21
 * Copyright (c) 2018 ; License: MIT 
 */

!function(){"use strict";var a=angular.module("ui.grid.exporter",["ui.grid"]);a.constant("uiGridExporterConstants",{featureName:"exporter",ALL:"all",VISIBLE:"visible",SELECTED:"selected",CSV_CONTENT:"CSV_CONTENT",BUTTON_LABEL:"BUTTON_LABEL",FILE_NAME:"FILE_NAME"}),a.service("uiGridExporterService",["$q","uiGridExporterConstants","gridUtil","$compile","$interval","i18nService",function(a,b,c,d,e,f){var g={delay:100,initializeGrid:function(a){a.exporter={},this.defaultGridOptions(a.options);var b={events:{exporter:{}},methods:{exporter:{csvExport:function(b,c){g.csvExport(a,b,c)},pdfExport:function(b,c){g.pdfExport(a,b,c)},excelExport:function(b,c){g.excelExport(a,b,c)}}}};a.api.registerEventsFromObject(b.events),a.api.registerMethodsFromObject(b.methods),a.api.core.addToGridMenu?g.addToMenu(a):e(function(){a.api.core.addToGridMenu&&g.addToMenu(a)},this.delay,1)},defaultGridOptions:function(a){a.exporterSuppressMenu=a.exporterSuppressMenu===!0,a.exporterMenuLabel=a.exporterMenuLabel?a.exporterMenuLabel:"Export",a.exporterSuppressColumns=a.exporterSuppressColumns?a.exporterSuppressColumns:[],a.exporterCsvColumnSeparator=a.exporterCsvColumnSeparator?a.exporterCsvColumnSeparator:",",a.exporterCsvFilename=a.exporterCsvFilename?a.exporterCsvFilename:"download.csv",a.exporterPdfFilename=a.exporterPdfFilename?a.exporterPdfFilename:"download.pdf",a.exporterOlderExcelCompatibility=a.exporterOlderExcelCompatibility===!0,a.exporterIsExcelCompatible=a.exporterIsExcelCompatible===!0,a.exporterMenuItemOrder=a.exporterMenuItemOrder?a.exporterMenuItemOrder:200,a.exporterPdfDefaultStyle=a.exporterPdfDefaultStyle?a.exporterPdfDefaultStyle:{fontSize:11},a.exporterPdfTableStyle=a.exporterPdfTableStyle?a.exporterPdfTableStyle:{margin:[0,5,0,15]},a.exporterPdfTableHeaderStyle=a.exporterPdfTableHeaderStyle?a.exporterPdfTableHeaderStyle:{bold:!0,fontSize:12,color:"black"},a.exporterPdfHeader=a.exporterPdfHeader?a.exporterPdfHeader:null,a.exporterPdfFooter=a.exporterPdfFooter?a.exporterPdfFooter:null,a.exporterPdfOrientation=a.exporterPdfOrientation?a.exporterPdfOrientation:"landscape",a.exporterPdfPageSize=a.exporterPdfPageSize?a.exporterPdfPageSize:"A4",a.exporterPdfMaxGridWidth=a.exporterPdfMaxGridWidth?a.exporterPdfMaxGridWidth:720,a.exporterMenuAllData=void 0!==a.exporterMenuAllData?a.exporterMenuAllData:!0,a.exporterMenuVisibleData=void 0!==a.exporterMenuVisibleData?a.exporterMenuVisibleData:!0,a.exporterMenuSelectedData=void 0!==a.exporterMenuSelectedData?a.exporterMenuSelectedData:!0,a.exporterMenuCsv=void 0!==a.exporterMenuCsv?a.exporterMenuCsv:!0,a.exporterMenuPdf=void 0!==a.exporterMenuPdf?a.exporterMenuPdf:!0,a.exporterMenuExcel=void 0!==a.exporterMenuExcel?a.exporterMenuExcel:!0,a.exporterPdfCustomFormatter=a.exporterPdfCustomFormatter&&"function"==typeof a.exporterPdfCustomFormatter?a.exporterPdfCustomFormatter:function(a){return a},a.exporterHeaderFilterUseName=a.exporterHeaderFilterUseName===!0,a.exporterFieldCallback=a.exporterFieldCallback?a.exporterFieldCallback:function(a,b,c,d){return d},a.exporterFieldFormatCallback=a.exporterFieldFormatCallback?a.exporterFieldFormatCallback:function(a,b,c,d){return null},a.exporterFieldApplyFilters=a.exporterFieldApplyFilters===!0,a.exporterAllDataFn=a.exporterAllDataFn?a.exporterAllDataFn:null,null===a.exporterAllDataFn&&a.exporterAllDataPromise&&(a.exporterAllDataFn=a.exporterAllDataPromise)},addToMenu:function(a){a.api.core.addToGridMenu(a,[{title:f.getSafeText("gridMenu.exporterAllAsCsv"),action:function(c){a.api.exporter.csvExport(b.ALL,b.ALL)},shown:function(){return a.options.exporterMenuCsv&&a.options.exporterMenuAllData},order:a.options.exporterMenuItemOrder},{title:f.getSafeText("gridMenu.exporterVisibleAsCsv"),action:function(c){a.api.exporter.csvExport(b.VISIBLE,b.VISIBLE)},shown:function(){return a.options.exporterMenuCsv&&a.options.exporterMenuVisibleData},order:a.options.exporterMenuItemOrder+1},{title:f.getSafeText("gridMenu.exporterSelectedAsCsv"),action:function(c){a.api.exporter.csvExport(b.SELECTED,b.VISIBLE)},shown:function(){return a.options.exporterMenuCsv&&a.options.exporterMenuSelectedData&&a.api.selection&&a.api.selection.getSelectedRows().length>0},order:a.options.exporterMenuItemOrder+2},{title:f.getSafeText("gridMenu.exporterAllAsPdf"),action:function(c){a.api.exporter.pdfExport(b.ALL,b.ALL)},shown:function(){return a.options.exporterMenuPdf&&a.options.exporterMenuAllData},order:a.options.exporterMenuItemOrder+3},{title:f.getSafeText("gridMenu.exporterVisibleAsPdf"),action:function(c){a.api.exporter.pdfExport(b.VISIBLE,b.VISIBLE)},shown:function(){return a.options.exporterMenuPdf&&a.options.exporterMenuVisibleData},order:a.options.exporterMenuItemOrder+4},{title:f.getSafeText("gridMenu.exporterSelectedAsPdf"),action:function(c){a.api.exporter.pdfExport(b.SELECTED,b.VISIBLE)},shown:function(){return a.options.exporterMenuPdf&&a.options.exporterMenuSelectedData&&a.api.selection&&a.api.selection.getSelectedRows().length>0},order:a.options.exporterMenuItemOrder+5},{title:f.getSafeText("gridMenu.exporterAllAsExcel"),action:function(c){a.api.exporter.excelExport(b.ALL,b.ALL)},shown:function(){return a.options.exporterMenuExcel&&a.options.exporterMenuAllData},order:a.options.exporterMenuItemOrder+6},{title:f.getSafeText("gridMenu.exporterVisibleAsExcel"),action:function(c){a.api.exporter.excelExport(b.VISIBLE,b.VISIBLE)},shown:function(){return a.options.exporterMenuExcel&&a.options.exporterMenuVisibleData},order:a.options.exporterMenuItemOrder+7},{title:f.getSafeText("gridMenu.exporterSelectedAsExcel"),action:function(c){a.api.exporter.excelExport(b.SELECTED,b.VISIBLE)},shown:function(){return a.options.exporterMenuExcel&&a.options.exporterMenuSelectedData&&a.api.selection&&a.api.selection.getSelectedRows().length>0},order:a.options.exporterMenuItemOrder+8}])},csvExport:function(a,b,c){var d=this;this.loadAllDataIfNeeded(a,b,c).then(function(){var e=a.options.showHeader?d.getColumnHeaders(a,c):[],f=d.getData(a,b,c),g=d.formatAsCsv(e,f,a.options.exporterCsvColumnSeparator);d.downloadFile(a.options.exporterCsvFilename,g,a.options.exporterCsvColumnSeparator,a.options.exporterOlderExcelCompatibility,a.options.exporterIsExcelCompatible)})},loadAllDataIfNeeded:function(c,d,e){if(d===b.ALL&&c.rows.length!==c.options.totalItems&&c.options.exporterAllDataFn)return c.options.exporterAllDataFn().then(function(a){c.modifyRows(a)});var f=a.defer();return f.resolve(),f.promise},getColumnHeaders:function(a,c){var d,e=[];if(c===b.ALL)d=a.columns;else{var f=a.renderContainers.left?a.renderContainers.left.visibleColumnCache.filter(function(a){return a.visible}):[],g=a.renderContainers.body?a.renderContainers.body.visibleColumnCache.filter(function(a){return a.visible}):[],h=a.renderContainers.right?a.renderContainers.right.visibleColumnCache.filter(function(a){return a.visible}):[];d=f.concat(g,h)}return d.forEach(function(b,c){if(b.colDef.exporterSuppressExport!==!0&&"$$hashKey"!==b.field&&-1===a.options.exporterSuppressColumns.indexOf(b.name)){var d={name:b.field,displayName:a.options.exporterHeaderFilter?a.options.exporterHeaderFilterUseName?a.options.exporterHeaderFilter(b.name):a.options.exporterHeaderFilter(b.displayName):b.displayName,width:b.drawnWidth?b.drawnWidth:b.width,align:b.colDef.align?b.colDef.align:"number"===b.colDef.type?"right":"left"};e.push(d)}}),e},getRowsFromNode:function(a){for(var b=[],c=0;c<a.children.length;c++)if(a.children[c].children&&0===a.children[c].children.length)b.push(a.children[c]);else{var d=this.getRowsFromNode(a.children[c]);b=b.concat(d)}return b},getDataSorted:function(a,b,c,d){if(!a.treeBase||0===a.treeBase.numberLevels)return a.rows;for(var e=[],f=0;f<a.treeBase.tree.length;f++)for(var g=this.getRowsFromNode(a.treeBase.tree[f]),h=0;h<g.length;h++)e.push(g[h].row);return e},getData:function(a,d,e,f){var g,h,i=[];switch(d){case b.ALL:g=this.getDataSorted(a,d,e,f);break;case b.VISIBLE:g=a.getVisibleRows();break;case b.SELECTED:a.api.selection?g=a.api.selection.getSelectedGridRows():c.logError("selection feature must be enabled to allow selected rows to be exported")}if(e===b.ALL)h=a.columns;else{var j=a.renderContainers.left?a.renderContainers.left.visibleColumnCache.filter(function(a){return a.visible}):[],k=a.renderContainers.body?a.renderContainers.body.visibleColumnCache.filter(function(a){return a.visible}):[],l=a.renderContainers.right?a.renderContainers.right.visibleColumnCache.filter(function(a){return a.visible}):[];h=j.concat(k,l)}return g.forEach(function(c,d){if(c.exporterEnableExporting!==!1){var g=[];h.forEach(function(d,h){if((d.visible||e===b.ALL)&&d.colDef.exporterSuppressExport!==!0&&"$$hashKey"!==d.field&&-1===a.options.exporterSuppressColumns.indexOf(d.name)){var i=f?a.getCellDisplayValue(c,d):a.getCellValue(c,d),j={value:a.options.exporterFieldCallback(a,c,d,i)},k=a.options.exporterFieldFormatCallback(a,c,d,i);k&&Object.assign(j,k),d.colDef.exporterPdfAlign&&(j.alignment=d.colDef.exporterPdfAlign),g.push(j)}}),i.push(g)}}),i},formatAsCsv:function(a,b,c){var d=this,e=a.map(function(a){return{value:a.displayName}}),f=e.length>0?d.formatRowAsCsv(this,c)(e)+"\n":"";return f+=b.map(this.formatRowAsCsv(this,c)).join("\n")},formatRowAsCsv:function(a,b){return function(c){return c.map(a.formatFieldAsCsv).join(b)}},formatFieldAsCsv:function(a){return null==a.value?"":"number"==typeof a.value?a.value:"boolean"==typeof a.value?a.value?"TRUE":"FALSE":"string"==typeof a.value?'"'+a.value.replace(/"/g,'""')+'"':JSON.stringify(a.value)},isIE:function(){var a=navigator.userAgent.search(/(?:Edge|MSIE|Trident\/.*; rv:)/),b=!1;return-1!==a&&(b=!0),b},downloadFile:function(a,b,c,d,e){var f,g=document,h=g.createElement("a"),i="application/octet-stream;charset=utf-8",j=this.isIE();if(e&&(b="sep="+c+"\r\n"+b),navigator.msSaveBlob)return navigator.msSaveOrOpenBlob(new Blob([d?"\ufeff":"",b],{type:i}),a);if(j){var k=g.createElement("iframe");return document.body.appendChild(k),k.contentWindow.document.open("text/html","replace"),k.contentWindow.document.write(b),k.contentWindow.document.close(),k.contentWindow.focus(),k.contentWindow.document.execCommand("SaveAs",!0,a),document.body.removeChild(k),!0}if("download"in h){var l=new Blob([d?"\ufeff":"",b],{type:i});f=URL.createObjectURL(l),h.setAttribute("download",a)}else f="data:"+i+","+encodeURIComponent(b),h.setAttribute("target","_blank");h.href=f,h.setAttribute("style","display:none;"),g.body.appendChild(h),setTimeout(function(){if(h.click)h.click();else if(document.createEvent){var a=document.createEvent("MouseEvents");a.initEvent("click",!0,!0),h.dispatchEvent(a)}g.body.removeChild(h)},this.delay)},pdfExport:function(a,b,c){var d=this;this.loadAllDataIfNeeded(a,b,c).then(function(){var e=d.getColumnHeaders(a,c),f=d.getData(a,b,c),g=d.prepareAsPdf(a,e,f);d.isIE()||-1!==navigator.appVersion.indexOf("Edge")?d.downloadPDF(a.options.exporterPdfFilename,g):pdfMake.createPdf(g).open()})},downloadPDF:function(a,b){var c,d=document;d.createElement("a");c=this.isIE();var e,f=pdfMake.createPdf(b);f.getBuffer(function(b){if(e=new Blob([b]),navigator.msSaveBlob)return navigator.msSaveBlob(e,a);if(c){var f=d.createElement("iframe");return document.body.appendChild(f),f.contentWindow.document.open("text/html","replace"),f.contentWindow.document.write(e),f.contentWindow.document.close(),f.contentWindow.focus(),f.contentWindow.document.execCommand("SaveAs",!0,a),document.body.removeChild(f),!0}})},prepareAsPdf:function(a,b,c){var d=this.calculatePdfHeaderWidths(a,b),e=b.map(function(a){return{text:a.displayName,style:"tableHeader"}}),f=c.map(this.formatRowAsPdf(this)),g=[e].concat(f),h={pageOrientation:a.options.exporterPdfOrientation,pageSize:a.options.exporterPdfPageSize,content:[{style:"tableStyle",table:{headerRows:1,widths:d,body:g}}],styles:{tableStyle:a.options.exporterPdfTableStyle,tableHeader:a.options.exporterPdfTableHeaderStyle},defaultStyle:a.options.exporterPdfDefaultStyle};return a.options.exporterPdfLayout&&(h.layout=a.options.exporterPdfLayout),a.options.exporterPdfHeader&&(h.header=a.options.exporterPdfHeader),a.options.exporterPdfFooter&&(h.footer=a.options.exporterPdfFooter),a.options.exporterPdfCustomFormatter&&(h=a.options.exporterPdfCustomFormatter(h)),h},calculatePdfHeaderWidths:function(a,b){var c=0;b.forEach(function(a){"number"==typeof a.width&&(c+=a.width)});var d=0;b.forEach(function(a){if("*"===a.width&&(d+=100),"string"==typeof a.width&&a.width.match(/(\d)*%/)){var b=parseInt(a.width.match(/(\d)*%/)[0]);a.width=c*b/100,d+=a.width}});var e=c+d;return b.map(function(b){return"*"===b.width?b.width:b.width*a.options.exporterPdfMaxGridWidth/e})},formatRowAsPdf:function(a){return function(b){return b.map(a.formatFieldAsPdfString)}},formatFieldAsPdfString:function(a){var b;return b=null==a.value?"":"number"==typeof a.value?a.value.toString():"boolean"==typeof a.value?a.value?"TRUE":"FALSE":"string"==typeof a.value?a.value.replace(/"/g,'""'):a.value instanceof Date?JSON.stringify(a.value).replace(/^"/,"").replace(/"$/,""):"object"==typeof a.value?a.value:JSON.stringify(a.value).replace(/^"/,"").replace(/"$/,""),a.alignment&&"string"==typeof a.alignment&&(b={text:b,alignment:a.alignment}),b},formatAsExcel:function(a,b,c,d,e){for(var f=a.map(function(a){return{value:a.displayName}}),g=[],h=[],i=0;i<f.length;i++){var j="header";switch(a[i].align){case"center":j="headerCenter";break;case"right":j="headerRight"}var k=e.styles&&e.styles[j]?{style:e.styles[j].id}:null;h.push({value:f[i].value,metadata:k})}g.push(h);for(var l=b.map(this.formatRowAsExcel(this,c,d)),m=0;m<l.length;m++)g.push(l[m]);return g},formatRowAsExcel:function(a,b,c){return function(d){for(var e=[],f=0;f<d.length;f++){var g=a.formatFieldAsExcel(d[f],b,c);e.push({value:g,metadata:d[f].metadata})}return e}},formatFieldAsExcel:function(a,b,c,d){return null==a.value?"":"number"==typeof a.value?a.value:"boolean"==typeof a.value?a.value?"TRUE":"FALSE":"string"==typeof a.value?a.value.replace(/"/g,'""'):JSON.stringify(a.value)},prepareAsExcel:function(a,b,c){var d={styles:{}};if(a.options.exporterExcelCustomFormatters&&(d=a.options.exporterExcelCustomFormatters(a,b,d)),a.options.exporterExcelHeader){if(angular.isFunction(a.options.exporterExcelHeader))a.options.exporterExcelHeader(a,b,c,d);else{var e=a.options.exporterExcelHeader.text,f=a.options.exporterExcelHeader.style;c.data.push([{value:e,metadata:{style:d.styles[f].id}}])}}return d},excelExport:function(a,b,c){var d=this;this.loadAllDataIfNeeded(a,b,c).then(function(){var e=a.options.showHeader?d.getColumnHeaders(a,c):[],f=new ExcelBuilder.Workbook,g=a.options.exporterExcelSheetName?a.options.exporterExcelSheetName:"Sheet1",h=new ExcelBuilder.Worksheet({name:g});f.addWorksheet(h);for(var i=d.prepareAsExcel(a,f,h),j=[],k=a.treeBase?a.treeBase.numberLevels:a.enableRowSelection!==!1?1:0,l=k;l<a.columns.length;l++)j.push({width:a.columns[l].drawnWidth/75*10});h.setColumns(j);var m=d.getData(a,b,c,a.options.exporterFieldApplyFilters),n=d.formatAsExcel(e,m,f,h,i);h.setData(h.data.concat(n)),ExcelBuilder.Builder.createFile(f,{type:"blob"}).then(function(b){d.downloadFile(a.options.exporterExcelFilename,b,a.options.exporterCsvColumnSeparator,a.options.exporterOlderExcelCompatibility)})})}};return g}]),a.directive("uiGridExporter",["uiGridExporterConstants","uiGridExporterService","gridUtil","$compile",function(a,b,c,d){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(a,c,d,e){b.initializeGrid(e.grid),e.grid.exporter.$scope=a}}}])}();