/*!
 * ui-grid - v4.4.7 - 2018-04-20
 * Copyright (c) 2018 ; License: MIT 
 */

!function(){"use strict";var a=angular.module("ui.grid.exporter",["ui.grid"]);a.constant("uiGridExporterConstants",{featureName:"exporter",rowHeaderColName:"treeBaseRowHeaderCol",selectionRowHeaderColName:"selectionRowHeaderCol",ALL:"all",VISIBLE:"visible",SELECTED:"selected",CSV_CONTENT:"CSV_CONTENT",BUTTON_LABEL:"BUTTON_LABEL",FILE_NAME:"FILE_NAME"}),a.service("uiGridExporterService",["$filter","$q","uiGridExporterConstants","gridUtil","$compile","$interval","i18nService",function(a,b,c,d,e,f,g){function h(b,c){return b.options.exporterHeaderFilter?b.options.exporterHeaderFilterUseName?b.options.exporterHeaderFilter(c.name):b.options.exporterHeaderFilter(c.displayName):c.headerCellFilter?a(c.headerCellFilter)(c.displayName):c.displayName}function i(b,c,d,e){return d.cellFilter?a(d.cellFilter.split(":")[0].trim())(e):e}var j={delay:100,initializeGrid:function(a){a.exporter={},this.defaultGridOptions(a.options);var b={events:{exporter:{}},methods:{exporter:{csvExport:function(b,c){j.csvExport(a,b,c)},pdfExport:function(b,c){j.pdfExport(a,b,c)},excelExport:function(b,c){j.excelExport(a,b,c)}}}};a.api.registerEventsFromObject(b.events),a.api.registerMethodsFromObject(b.methods),a.api.core.addToGridMenu?j.addToMenu(a):f(function(){a.api.core.addToGridMenu&&j.addToMenu(a)},this.delay,1)},defaultGridOptions:function(a){a.exporterSuppressMenu=a.exporterSuppressMenu===!0,a.exporterMenuLabel=a.exporterMenuLabel?a.exporterMenuLabel:"Export",a.exporterSuppressColumns=a.exporterSuppressColumns?a.exporterSuppressColumns:[],a.exporterCsvColumnSeparator=a.exporterCsvColumnSeparator?a.exporterCsvColumnSeparator:",",a.exporterCsvFilename=a.exporterCsvFilename?a.exporterCsvFilename:"download.csv",a.exporterPdfFilename=a.exporterPdfFilename?a.exporterPdfFilename:"download.pdf",a.exporterOlderExcelCompatibility=a.exporterOlderExcelCompatibility===!0,a.exporterIsExcelCompatible=a.exporterIsExcelCompatible===!0,a.exporterMenuItemOrder=a.exporterMenuItemOrder?a.exporterMenuItemOrder:200,a.exporterPdfDefaultStyle=a.exporterPdfDefaultStyle?a.exporterPdfDefaultStyle:{fontSize:11},a.exporterPdfTableStyle=a.exporterPdfTableStyle?a.exporterPdfTableStyle:{margin:[0,5,0,15]},a.exporterPdfTableHeaderStyle=a.exporterPdfTableHeaderStyle?a.exporterPdfTableHeaderStyle:{bold:!0,fontSize:12,color:"black"},a.exporterPdfHeader=a.exporterPdfHeader?a.exporterPdfHeader:null,a.exporterPdfFooter=a.exporterPdfFooter?a.exporterPdfFooter:null,a.exporterPdfOrientation=a.exporterPdfOrientation?a.exporterPdfOrientation:"landscape",a.exporterPdfPageSize=a.exporterPdfPageSize?a.exporterPdfPageSize:"A4",a.exporterPdfMaxGridWidth=a.exporterPdfMaxGridWidth?a.exporterPdfMaxGridWidth:720,a.exporterMenuAllData=void 0!==a.exporterMenuAllData?a.exporterMenuAllData:!0,a.exporterMenuVisibleData=void 0!==a.exporterMenuVisibleData?a.exporterMenuVisibleData:!0,a.exporterMenuSelectedData=void 0!==a.exporterMenuSelectedData?a.exporterMenuSelectedData:!0,a.exporterMenuCsv=void 0!==a.exporterMenuCsv?a.exporterMenuCsv:!0,a.exporterMenuPdf=void 0!==a.exporterMenuPdf?a.exporterMenuPdf:!0,a.exporterMenuExcel=void 0!==a.exporterMenuExcel?a.exporterMenuExcel:!0,a.exporterPdfCustomFormatter=a.exporterPdfCustomFormatter&&"function"==typeof a.exporterPdfCustomFormatter?a.exporterPdfCustomFormatter:function(a){return a},a.exporterHeaderFilterUseName=a.exporterHeaderFilterUseName===!0,a.exporterFieldCallback=a.exporterFieldCallback?a.exporterFieldCallback:i,a.exporterFieldFormatCallback=a.exporterFieldFormatCallback?a.exporterFieldFormatCallback:function(a,b,c,d){return null},a.exporterColumnScaleFactor=a.exporterColumnScaleFactor?a.exporterColumnScaleFactor:3.5,a.exporterFieldApplyFilters=a.exporterFieldApplyFilters===!0,a.exporterAllDataFn=a.exporterAllDataFn?a.exporterAllDataFn:null,null===a.exporterAllDataFn&&a.exporterAllDataPromise&&(a.exporterAllDataFn=a.exporterAllDataPromise)},addToMenu:function(a){a.api.core.addToGridMenu(a,[{title:g.getSafeText("gridMenu.exporterAllAsCsv"),action:function(b){a.api.exporter.csvExport(c.ALL,c.ALL)},shown:function(){return a.options.exporterMenuCsv&&a.options.exporterMenuAllData},order:a.options.exporterMenuItemOrder},{title:g.getSafeText("gridMenu.exporterVisibleAsCsv"),action:function(b){a.api.exporter.csvExport(c.VISIBLE,c.VISIBLE)},shown:function(){return a.options.exporterMenuCsv&&a.options.exporterMenuVisibleData},order:a.options.exporterMenuItemOrder+1},{title:g.getSafeText("gridMenu.exporterSelectedAsCsv"),action:function(b){a.api.exporter.csvExport(c.SELECTED,c.VISIBLE)},shown:function(){return a.options.exporterMenuCsv&&a.options.exporterMenuSelectedData&&a.api.selection&&a.api.selection.getSelectedRows().length>0},order:a.options.exporterMenuItemOrder+2},{title:g.getSafeText("gridMenu.exporterAllAsPdf"),action:function(b){a.api.exporter.pdfExport(c.ALL,c.ALL)},shown:function(){return a.options.exporterMenuPdf&&a.options.exporterMenuAllData},order:a.options.exporterMenuItemOrder+3},{title:g.getSafeText("gridMenu.exporterVisibleAsPdf"),action:function(b){a.api.exporter.pdfExport(c.VISIBLE,c.VISIBLE)},shown:function(){return a.options.exporterMenuPdf&&a.options.exporterMenuVisibleData},order:a.options.exporterMenuItemOrder+4},{title:g.getSafeText("gridMenu.exporterSelectedAsPdf"),action:function(b){a.api.exporter.pdfExport(c.SELECTED,c.VISIBLE)},shown:function(){return a.options.exporterMenuPdf&&a.options.exporterMenuSelectedData&&a.api.selection&&a.api.selection.getSelectedRows().length>0},order:a.options.exporterMenuItemOrder+5},{title:g.getSafeText("gridMenu.exporterAllAsExcel"),action:function(b){a.api.exporter.excelExport(c.ALL,c.ALL)},shown:function(){return a.options.exporterMenuExcel&&a.options.exporterMenuAllData},order:a.options.exporterMenuItemOrder+6},{title:g.getSafeText("gridMenu.exporterVisibleAsExcel"),action:function(b){a.api.exporter.excelExport(c.VISIBLE,c.VISIBLE)},shown:function(){return a.options.exporterMenuExcel&&a.options.exporterMenuVisibleData},order:a.options.exporterMenuItemOrder+7},{title:g.getSafeText("gridMenu.exporterSelectedAsExcel"),action:function(b){a.api.exporter.excelExport(c.SELECTED,c.VISIBLE)},shown:function(){return a.options.exporterMenuExcel&&a.options.exporterMenuSelectedData&&a.api.selection&&a.api.selection.getSelectedRows().length>0},order:a.options.exporterMenuItemOrder+8}])},csvExport:function(a,b,c){var d=this;this.loadAllDataIfNeeded(a,b,c).then(function(){var e=a.options.showHeader?d.getColumnHeaders(a,c):[],f=d.getData(a,b,c),g=d.formatAsCsv(e,f,a.options.exporterCsvColumnSeparator);d.downloadFile(a.options.exporterCsvFilename,g,a.options.exporterCsvColumnSeparator,a.options.exporterOlderExcelCompatibility,a.options.exporterIsExcelCompatible)})},loadAllDataIfNeeded:function(a,d,e){if(d===c.ALL&&a.rows.length!==a.options.totalItems&&a.options.exporterAllDataFn)return a.options.exporterAllDataFn().then(function(b){a.modifyRows(b)});var f=b.defer();return f.resolve(),f.promise},getColumnHeaders:function(a,b){var d,e=[];if(b===c.ALL)d=a.columns;else{var f=a.renderContainers.left?a.renderContainers.left.visibleColumnCache.filter(function(a){return a.visible}):[],g=a.renderContainers.body?a.renderContainers.body.visibleColumnCache.filter(function(a){return a.visible}):[],i=a.renderContainers.right?a.renderContainers.right.visibleColumnCache.filter(function(a){return a.visible}):[];d=f.concat(g,i)}return d.forEach(function(b){if(b.colDef.exporterSuppressExport!==!0&&"$$hashKey"!==b.field&&-1===a.options.exporterSuppressColumns.indexOf(b.name)){var c={name:b.field,displayName:h(a,b),width:b.drawnWidth?b.drawnWidth:b.width,align:b.colDef.align?b.colDef.align:"number"===b.colDef.type?"right":"left"};e.push(c)}}),e},getRowsFromNode:function(a){for(var b=[],c=0;c<a.children.length;c++)if(a.children[c].children&&0===a.children[c].children.length)b.push(a.children[c]);else{var d=this.getRowsFromNode(a.children[c]);b=b.concat(d)}return b},getDataSorted:function(a,b,c,d){if(!a.treeBase||0===a.treeBase.numberLevels)return a.rows;for(var e=[],f=0;f<a.treeBase.tree.length;f++)for(var g=this.getRowsFromNode(a.treeBase.tree[f]),h=0;h<g.length;h++)e.push(g[h].row);return e},getData:function(a,b,e,f){var g,h,i=[];switch(b){case c.ALL:g=this.getDataSorted(a,b,e,f);break;case c.VISIBLE:g=a.getVisibleRows();break;case c.SELECTED:a.api.selection?g=a.api.selection.getSelectedGridRows():d.logError("selection feature must be enabled to allow selected rows to be exported")}if(e===c.ALL)h=a.columns;else{var j=a.renderContainers.left?a.renderContainers.left.visibleColumnCache.filter(function(a){return a.visible}):[],k=a.renderContainers.body?a.renderContainers.body.visibleColumnCache.filter(function(a){return a.visible}):[],l=a.renderContainers.right?a.renderContainers.right.visibleColumnCache.filter(function(a){return a.visible}):[];h=j.concat(k,l)}return g.forEach(function(b,d){if(b.exporterEnableExporting!==!1){var g=[];h.forEach(function(d,h){if((d.visible||e===c.ALL)&&d.colDef.exporterSuppressExport!==!0&&"$$hashKey"!==d.field&&-1===a.options.exporterSuppressColumns.indexOf(d.name)){var i=f?a.getCellDisplayValue(b,d):a.getCellValue(b,d),j={value:a.options.exporterFieldCallback(a,b,d,i)},k=a.options.exporterFieldFormatCallback(a,b,d,i);k&&Object.assign(j,k),d.colDef.exporterPdfAlign&&(j.alignment=d.colDef.exporterPdfAlign),g.push(j)}}),i.push(g)}}),i},formatAsCsv:function(a,b,c){var d=this,e=a.map(function(a){return{value:a.displayName}}),f=e.length>0?d.formatRowAsCsv(this,c)(e)+"\n":"";return f+=b.map(this.formatRowAsCsv(this,c)).join("\n")},formatRowAsCsv:function(a,b){return function(c){return c.map(a.formatFieldAsCsv).join(b)}},formatFieldAsCsv:function(a){return null==a.value?"":"number"==typeof a.value?a.value:"boolean"==typeof a.value?a.value?"TRUE":"FALSE":"string"==typeof a.value?'"'+a.value.replace(/"/g,'""')+'"':JSON.stringify(a.value)},isIE:function(){var a=navigator.userAgent.search(/(?:Edge|MSIE|Trident\/.*; rv:)/),b=!1;return-1!==a&&(b=!0),b},downloadFile:function(a,b,c,d,e){var f,g=document,h=g.createElement("a"),i="application/octet-stream;charset=utf-8",j=this.isIE();if(e&&(b="sep="+c+"\r\n"+b),navigator.msSaveBlob)return navigator.msSaveOrOpenBlob(new Blob([d?"\ufeff":"",b],{type:i}),a);if(j){var k=g.createElement("iframe");return document.body.appendChild(k),k.contentWindow.document.open("text/html","replace"),k.contentWindow.document.write(b),k.contentWindow.document.close(),k.contentWindow.focus(),k.contentWindow.document.execCommand("SaveAs",!0,a),document.body.removeChild(k),!0}if("download"in h){var l=new Blob([d?"\ufeff":"",b],{type:i});f=URL.createObjectURL(l),h.setAttribute("download",a)}else f="data:"+i+","+encodeURIComponent(b),h.setAttribute("target","_blank");h.href=f,h.setAttribute("style","display:none;"),g.body.appendChild(h),setTimeout(function(){if(h.click)h.click();else if(document.createEvent){var a=document.createEvent("MouseEvents");a.initEvent("click",!0,!0),h.dispatchEvent(a)}g.body.removeChild(h)},this.delay)},pdfExport:function(a,b,c){var d=this;this.loadAllDataIfNeeded(a,b,c).then(function(){var e=d.getColumnHeaders(a,c),f=d.getData(a,b,c),g=d.prepareAsPdf(a,e,f);d.isIE()||-1!==navigator.appVersion.indexOf("Edge")?d.downloadPDF(a.options.exporterPdfFilename,g):pdfMake.createPdf(g).open()})},downloadPDF:function(a,b){var c,d=document;d.createElement("a");c=this.isIE();var e,f=pdfMake.createPdf(b);f.getBuffer(function(b){if(e=new Blob([b]),navigator.msSaveBlob)return navigator.msSaveBlob(e,a);if(c){var f=d.createElement("iframe");return document.body.appendChild(f),f.contentWindow.document.open("text/html","replace"),f.contentWindow.document.write(e),f.contentWindow.document.close(),f.contentWindow.focus(),f.contentWindow.document.execCommand("SaveAs",!0,a),document.body.removeChild(f),!0}})},prepareAsPdf:function(a,b,c){var d=this.calculatePdfHeaderWidths(a,b),e=b.map(function(a){return{text:a.displayName,style:"tableHeader"}}),f=c.map(this.formatRowAsPdf(this)),g=[e].concat(f),h={pageOrientation:a.options.exporterPdfOrientation,pageSize:a.options.exporterPdfPageSize,content:[{style:"tableStyle",table:{headerRows:1,widths:d,body:g}}],styles:{tableStyle:a.options.exporterPdfTableStyle,tableHeader:a.options.exporterPdfTableHeaderStyle},defaultStyle:a.options.exporterPdfDefaultStyle};return a.options.exporterPdfLayout&&(h.layout=a.options.exporterPdfLayout),a.options.exporterPdfHeader&&(h.header=a.options.exporterPdfHeader),a.options.exporterPdfFooter&&(h.footer=a.options.exporterPdfFooter),a.options.exporterPdfCustomFormatter&&(h=a.options.exporterPdfCustomFormatter(h)),h},calculatePdfHeaderWidths:function(a,b){var c=0;b.forEach(function(a){"number"==typeof a.width&&(c+=a.width)});var d=0;b.forEach(function(a){if("*"===a.width&&(d+=100),"string"==typeof a.width&&a.width.match(/(\d)*%/)){var b=parseInt(a.width.match(/(\d)*%/)[0]);a.width=c*b/100,d+=a.width}});var e=c+d;return b.map(function(b){return"*"===b.width?b.width:b.width*a.options.exporterPdfMaxGridWidth/e})},formatRowAsPdf:function(a){return function(b){return b.map(a.formatFieldAsPdfString)}},formatFieldAsPdfString:function(a){var b;return b=null==a.value?"":"number"==typeof a.value?a.value.toString():"boolean"==typeof a.value?a.value?"TRUE":"FALSE":"string"==typeof a.value?a.value.replace(/"/g,'""'):a.value instanceof Date?JSON.stringify(a.value).replace(/^"/,"").replace(/"$/,""):"object"==typeof a.value?a.value:JSON.stringify(a.value).replace(/^"/,"").replace(/"$/,""),a.alignment&&"string"==typeof a.alignment&&(b={text:b,alignment:a.alignment}),b},formatAsExcel:function(a,b,c,d,e){for(var f=a.map(function(a){return{value:a.displayName}}),g=[],h=[],i=0;i<f.length;i++){var j="header";switch(a[i].align){case"center":j="headerCenter";break;case"right":j="headerRight"}var k=e.styles&&e.styles[j]?{style:e.styles[j].id}:null;h.push({value:f[i].value,metadata:k})}g.push(h);for(var l=b.map(this.formatRowAsExcel(this,c,d)),m=0;m<l.length;m++)g.push(l[m]);return g},formatRowAsExcel:function(a,b,c){return function(d){for(var e=[],f=0;f<d.length;f++){var g=a.formatFieldAsExcel(d[f],b,c);e.push({value:g,metadata:d[f].metadata})}return e}},formatFieldAsExcel:function(a,b,c,d){return null==a.value?"":"number"==typeof a.value?a.value:"boolean"==typeof a.value?a.value?"TRUE":"FALSE":"string"==typeof a.value?a.value.replace(/"/g,'""'):JSON.stringify(a.value)},prepareAsExcel:function(a,b,c){var d={styles:{}};if(a.options.exporterExcelCustomFormatters&&(d=a.options.exporterExcelCustomFormatters(a,b,d)),a.options.exporterExcelHeader)if(angular.isFunction(a.options.exporterExcelHeader))a.options.exporterExcelHeader(a,b,c,d);else{var e=a.options.exporterExcelHeader.text,f=a.options.exporterExcelHeader.style;c.data.push([{value:e,metadata:{style:d.styles[f].id}}])}return d},excelExport:function(a,b,d){var e=this;this.loadAllDataIfNeeded(a,b,d).then(function(){var f=a.options.showHeader?e.getColumnHeaders(a,d):[],g=new ExcelBuilder.Workbook,h=a.options.exporterExcelSheetName?a.options.exporterExcelSheetName:"Sheet1",i=new ExcelBuilder.Worksheet({name:h});g.addWorksheet(i);for(var j=e.prepareAsExcel(a,g,i),k=[],l=a.treeBase?a.treeBase.numberLevels:a.enableRowSelection?1:0,m=l;m<a.columns.length;m++)a.columns[m].field!==c.rowHeaderColName&&a.columns[m].field!==c.selectionRowHeaderColName&&k.push({width:a.columns[m].drawnWidth/a.options.exporterColumnScaleFactor});i.setColumns(k);var n=e.getData(a,b,d,a.options.exporterFieldApplyFilters),o=e.formatAsExcel(f,n,g,i,j);i.setData(i.data.concat(o)),ExcelBuilder.Builder.createFile(g,{type:"blob"}).then(function(b){e.downloadFile(a.options.exporterExcelFilename,b,a.options.exporterCsvColumnSeparator,a.options.exporterOlderExcelCompatibility)})})}};return j}]),a.directive("uiGridExporter",["uiGridExporterConstants","uiGridExporterService","gridUtil","$compile",function(a,b,c,d){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(a,c,d,e){b.initializeGrid(e.grid),e.grid.exporter.$scope=a}}}])}();