/*!
 * ui-grid - v4.4.9 - 2018-04-30
 * Copyright (c) 2018 ; License: MIT 
 */


!function(){"use strict";angular.module("ui.grid.i18n",[]),angular.module("ui.grid",["ui.grid.i18n"])}(),function(){"use strict";angular.module("ui.grid").constant("uiGridConstants",{LOG_DEBUG_MESSAGES:!0,LOG_WARN_MESSAGES:!0,LOG_ERROR_MESSAGES:!0,CUSTOM_FILTERS:/CUSTOM_FILTERS/g,COL_FIELD:/COL_FIELD/g,MODEL_COL_FIELD:/MODEL_COL_FIELD/g,TOOLTIP:/title=\"TOOLTIP\"/g,DISPLAY_CELL_TEMPLATE:/DISPLAY_CELL_TEMPLATE/g,TEMPLATE_REGEXP:/<.+>/,FUNC_REGEXP:/(\([^)]*\))?$/,DOT_REGEXP:/\./g,APOS_REGEXP:/'/g,BRACKET_REGEXP:/^(.*)((?:\s*\[\s*\d+\s*\]\s*)|(?:\s*\[\s*"(?:[^"\\]|\\.)*"\s*\]\s*)|(?:\s*\[\s*'(?:[^'\\]|\\.)*'\s*\]\s*))(.*)$/,COL_CLASS_PREFIX:"ui-grid-col",ENTITY_BINDING:"$$this",events:{GRID_SCROLL:"uiGridScroll",COLUMN_MENU_SHOWN:"uiGridColMenuShown",ITEM_DRAGGING:"uiGridItemDragStart",COLUMN_HEADER_CLICK:"uiGridColumnHeaderClick"},keymap:{TAB:9,STRG:17,CAPSLOCK:20,CTRL:17,CTRLRIGHT:18,CTRLR:18,SHIFT:16,RETURN:13,ENTER:13,BACKSPACE:8,BCKSP:8,ALT:18,ALTR:17,ALTRIGHT:17,SPACE:32,WIN:91,MAC:91,FN:null,PG_UP:33,PG_DOWN:34,UP:38,DOWN:40,LEFT:37,RIGHT:39,ESC:27,DEL:46,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123},ASC:"asc",DESC:"desc",filter:{STARTS_WITH:2,ENDS_WITH:4,EXACT:8,CONTAINS:16,GREATER_THAN:32,GREATER_THAN_OR_EQUAL:64,LESS_THAN:128,LESS_THAN_OR_EQUAL:256,NOT_EQUAL:512,SELECT:"select",INPUT:"input"},aggregationTypes:{sum:2,count:4,avg:8,min:16,max:32},CURRENCY_SYMBOLS:["¤","؋","Ar","Ƀ","฿","B/.","Br","Bs.","Bs.F.","GH₵","¢","c","Ch.","₡","C$","D","ден","دج",".د.ب","د.ع","JD","د.ك","ل.د","дин","د.ت","د.م.","د.إ","Db","$","₫","Esc","€","ƒ","Ft","FBu","FCFA","CFA","Fr","FRw","G","gr","₲","h","₴","₭","Kč","kr","kn","MK","ZK","Kz","K","L","Le","лв","E","lp","M","KM","MT","₥","Nfk","₦","Nu.","UM","T$","MOP$","₱","Pt.","£","ج.م.","LL","LS","P","Q","q","R","R$","ر.ع.","ر.ق","ر.س","៛","RM","p","Rf.","₹","₨","SRe","Rp","₪","Ksh","Sh.So.","USh","S/","SDR","сом","৳\t","WS$","₮","VT","₩","¥","zł"],scrollDirection:{UP:"up",DOWN:"down",LEFT:"left",RIGHT:"right",NONE:"none"},dataChange:{ALL:"all",EDIT:"edit",ROW:"row",COLUMN:"column",OPTIONS:"options"},scrollbars:{NEVER:0,ALWAYS:1,WHEN_NEEDED:2}})}(),angular.module("ui.grid").directive("uiGridCell",["$compile","$parse","gridUtil","uiGridConstants",function(l,e,a,c){return{priority:0,scope:!1,require:"?^uiGrid",compile:function(){return{pre:function(r,t,e,i){if(i&&r.col.compiledElementFn)(0,r.col.compiledElementFn)(r,function(e,r){t.append(e)});else if(i&&!r.col.compiledElementFn)r.col.getCompiledElementFn().then(function(e){e(r,function(e,r){t.append(e)})}).catch(angular.noop);else{var n=r.col.cellTemplate.replace(c.MODEL_COL_FIELD,"row.entity."+a.preEval(r.col.field)).replace(c.COL_FIELD,"grid.getCellValue(row, col)"),o=l(n)(r);t.append(o)}},post:function(i,n,e,r){var o,l=i.col.getColClass(!1);n.addClass(l);var a=function(e){var r=n;o&&(r.removeClass(o),o=null),o=angular.isFunction(i.col.cellClass)?i.col.cellClass(i.grid,i.row,i.col,i.rowRenderIndex,i.colRenderIndex):i.col.cellClass,r.addClass(o)};i.col.cellClass&&a();var t=i.grid.registerDataChangeCallback(a,[c.dataChange.COLUMN,c.dataChange.EDIT]),s=i.$watch("row",function(e,r){if(e!==r){(o||i.col.cellClass)&&a();var t=i.col.getColClass(!1);t!==l&&(n.removeClass(l),n.addClass(t),l=t)}}),d=function(){t(),s()};i.$on("$destroy",d),n.on("$destroy",d)}}}}}]),angular.module("ui.grid").service("uiGridColumnMenuService",["i18nService","uiGridConstants","gridUtil",function(e,t,g){var i={initialize:function(e,r){e.grid=r.grid,(r.columnMenuScope=e).menuShown=!1},setColMenuItemWatch:function(r){var e=r.$watch("col.menuItems",function(e){void 0!==e&&e&&angular.isArray(e)?(e.forEach(function(e){void 0!==e.context&&e.context||(e.context={}),e.context.col=r.col}),r.menuItems=r.defaultMenuItems.concat(e)):r.menuItems=r.defaultMenuItems});r.$on("$destroy",e)},sortable:function(e){return!!(e.grid.options.enableSorting&&void 0!==e.col&&e.col&&e.col.enableSorting)},isActiveSort:function(e,r){return void 0!==e.col&&void 0!==e.col.sort&&void 0!==e.col.sort.direction&&e.col.sort.direction===r},suppressRemoveSort:function(e){return!(!e.col||!e.col.suppressRemoveSort)},hideable:function(e){return void 0===e.col||!e.col||!e.col.colDef||!1!==e.col.colDef.enableHiding},getDefaultMenuItems:function(r){return[{title:function(){return e.getSafeText("sort.ascending")},icon:"ui-grid-icon-sort-alt-up",action:function(e){e.stopPropagation(),r.sortColumn(e,t.ASC)},shown:function(){return i.sortable(r)},active:function(){return i.isActiveSort(r,t.ASC)}},{title:function(){return e.getSafeText("sort.descending")},icon:"ui-grid-icon-sort-alt-down",action:function(e){e.stopPropagation(),r.sortColumn(e,t.DESC)},shown:function(){return i.sortable(r)},active:function(){return i.isActiveSort(r,t.DESC)}},{title:function(){return e.getSafeText("sort.remove")},icon:"ui-grid-icon-cancel",action:function(e){e.stopPropagation(),r.unsortColumn()},shown:function(){return i.sortable(r)&&void 0!==r.col&&void 0!==r.col.sort&&void 0!==r.col.sort.direction&&null!==r.col.sort.direction&&!i.suppressRemoveSort(r)}},{title:function(){return e.getSafeText("column.hide")},icon:"ui-grid-icon-cancel",shown:function(){return i.hideable(r)},action:function(e){e.stopPropagation(),r.hideColumn()}}]},getColumnElementPosition:function(e,r,t){var i={};return i.left=t[0].offsetLeft,i.top=t[0].offsetTop,i.parentLeft=t[0].offsetParent.offsetLeft,i.offset=0,r.grid.options.offsetLeft&&(i.offset=r.grid.options.offsetLeft),i.height=g.elementHeight(t,!0),i.width=g.elementWidth(t,!0),i},repositionMenu:function(e,r,t,i,n){var o=i[0].querySelectorAll(".ui-grid-menu"),l=g.closestElm(n,".ui-grid-render-container"),a=l.getBoundingClientRect().left-e.grid.element[0].getBoundingClientRect().left,s=l.querySelectorAll(".ui-grid-viewport")[0].scrollLeft,d=g.elementWidth(o,!0),c=r.lastMenuPaddingRight?r.lastMenuPaddingRight:e.lastMenuPaddingRight?e.lastMenuPaddingRight:10;0!==o.length&&0!==o[0].querySelectorAll(".ui-grid-menu-mid").length&&(c=parseInt(g.getStyles(angular.element(o)[0]).paddingRight,10),e.lastMenuPaddingRight=c,r.lastMenuPaddingRight=c);var u=t.left+a-s+t.parentLeft+t.width+c;u<t.offset+d&&(u=Math.max(t.left-s+t.parentLeft-c+d,t.offset+d)),i.css("left",u+"px"),i.css("top",t.top+t.height+"px")}};return i}]).directive("uiGridColumnMenu",["$timeout","gridUtil","uiGridConstants","uiGridColumnMenuService","$document",function(t,n,l,a,s){return{priority:0,scope:!0,require:"^uiGrid",templateUrl:"ui-grid/uiGridColumnMenu",replace:!0,link:function(o,i,e,r){a.initialize(o,r),o.defaultMenuItems=a.getDefaultMenuItems(o),o.menuItems=o.defaultMenuItems,a.setColMenuItemWatch(o),o.showMenu=function(e,r,t){o.col=e;var i=a.getColumnElementPosition(o,e,r);o.menuShown?(o.colElement=r,o.colElementPosition=i,o.hideThenShow=!0,o.$broadcast("hide-menu",{originalEvent:t})):(o.menuShown=!0,o.colElement=r,o.colElementPosition=i,o.$broadcast("show-menu",{originalEvent:t}))},o.hideMenu=function(e){o.menuShown=!1,e||o.$broadcast("hide-menu")},o.$on("menu-hidden",function(){var e=angular.element(i[0].querySelector(".ui-grid-menu-items"))[0];i[0].removeAttribute("style"),o.hideThenShow?(delete o.hideThenShow,o.$broadcast("show-menu"),o.menuShown=!0):(o.hideMenu(!0),o.col&&n.focus.bySelector(s,".ui-grid-header-cell."+o.col.getColClass()+" .ui-grid-column-menu-button",o.col.grid,!1)),e&&(e.onkeydown=null,angular.forEach(e.children,function(e){e.onkeydown=null}))}),o.$on("menu-shown",function(){t(function(){a.repositionMenu(o,o.col,o.colElementPosition,i,o.colElement),n.focus.bySelector(s,".ui-grid-menu-items .ui-grid-menu-item:not(.ng-hide)",!0),delete o.colElementPosition,delete o.columnElement,function(){var e,r=angular.element(i[0].querySelector(".ui-grid-menu-items"))[0],n=[];function t(e,r,t,i){e.keyCode===l.keymap.TAB&&(r?e.preventDefault():t&&(e.preventDefault(),n[i].focus()))}r&&(r.onkeydown=function(e){e.keyCode===l.keymap.ESC&&(e.preventDefault(),o.hideMenu())},e=r.querySelectorAll(".ui-grid-menu-item:not(.ng-hide)"),angular.forEach(e,function(e){null!==e.offsetParent&&this.push(e)},n),n.length&&(1===n.length?n[0].onkeydown=function(e){t(e,!0)}:(n[0].onkeydown=function(e){t(e,!1,e.shiftKey,n.length-1)},n[n.length-1].onkeydown=function(e){t(e,!1,!e.shiftKey,0)})))}()})}),o.sortColumn=function(e,r){e.stopPropagation(),o.grid.sortColumn(o.col,r,!0).then(function(){o.grid.refresh(),o.hideMenu()}).catch(angular.noop)},o.unsortColumn=function(){o.col.unsort(),o.grid.refresh(),o.hideMenu()},o.hideColumn=function(){o.col.colDef.visible=!1,o.col.visible=!1,o.grid.queueGridRefresh(),o.hideMenu(),o.grid.api.core.notifyDataChange(l.dataChange.COLUMN),o.grid.api.core.raise.columnVisibilityChanged(o.col),t(function(){var t,i,r=function(){return n.focus.byId("grid-menu",o.grid)};if(o.grid.columns.some(function(e,r){if(angular.equals(e,o.col))return t=r,!0}),o.grid.columns.some(function(e,r){if(!e.visible)return!1;if(r<t)i=e;else{if(t<r&&!i)return i=e,!0;if(t<r&&i)return!0}}),i){var e=i.getColClass();n.focus.bySelector(s,".ui-grid-header-cell."+e+" .ui-grid-header-cell-primary-focus",!0).then(angular.noop,function(e){if("canceled"!==e)return r()}).catch(angular.noop)}else r()})}},controller:["$scope",function(e){var r=this;e.$watch("menuItems",function(e){r.menuItems=e})}]}}]),function(){"use strict";angular.module("ui.grid").directive("uiGridFilter",["$compile","$templateCache","i18nService","gridUtil",function(n,e,o,l){return{compile:function(){return{pre:function(t,i,e,r){t.col.updateFilters=function(e){if(i.children().remove(),e){var r=t.col.filterHeaderTemplate;void 0===r&&""!==t.col.providedFilterHeaderTemplate?t.col.filterHeaderTemplatePromise&&t.col.filterHeaderTemplatePromise.then(function(){r=t.col.filterHeaderTemplate,i.append(n(r)(t))}):i.append(n(r)(t))}},t.$on("$destroy",function(){delete t.col.updateFilters})},post:function(e,t,r,i){e.aria=o.getSafeText("headerCell.aria"),e.removeFilter=function(e,r){e.term=null,l.focus.bySelector(t,".ui-grid-filter-input-"+r)}}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridFooterCell",["$timeout","gridUtil","uiGridConstants","$compile",function(e,r,s,o){return{priority:0,scope:{col:"=",row:"=",renderIndex:"="},replace:!0,require:"^uiGrid",compile:function(e,r,t){return{pre:function(e,r,t,i){var n=e.col.footerCellTemplate;void 0===n&&""!==e.col.providedFooterCellTemplate?e.col.footerCellTemplatePromise&&e.col.footerCellTemplatePromise.then(function(){n=e.col.footerCellTemplate,r.append(o(n)(e))}):r.append(o(n)(e))},post:function(t,i,e,r){t.grid=r.grid;var n,o=t.col.getColClass(!1);i.addClass(o);var l=function(e){var r=i;n&&(r.removeClass(n),n=null),n=angular.isFunction(t.col.footerCellClass)?t.col.footerCellClass(t.grid,t.row,t.col,t.rowRenderIndex,t.colRenderIndex):t.col.footerCellClass,r.addClass(n)};t.col.footerCellClass&&l(),t.col.updateAggregationValue();var a=t.grid.registerDataChangeCallback(l,[s.dataChange.COLUMN]);t.grid.api.core.on.rowsRendered(t,t.col.updateAggregationValue),t.grid.api.core.on.rowsRendered(t,l),t.$on("$destroy",a)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridFooter",["$templateCache","$compile","uiGridConstants","gridUtil","$timeout",function(e,a,r,s,t){return{restrict:"EA",replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:!0,compile:function(e,r){return{pre:function(n,o,e,r){var t=r[0],l=r[1];n.grid=t.grid,n.colContainer=l.colContainer,l.footer=o;var i=n.grid.options.footerTemplate;s.getTemplate(i).then(function(e){var r=angular.element(e),t=a(r)(n);if(o.append(t),l){var i=o[0].getElementsByClassName("ui-grid-footer-viewport")[0];i&&(l.footerViewport=i)}}).catch(angular.noop)},post:function(e,r,t,i){var n=i[0],o=i[1];n.grid;s.disableAnimations(r);var l=(o.footer=r)[0].getElementsByClassName("ui-grid-footer-viewport")[0];l&&(o.footerViewport=l)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridGridFooter",["$templateCache","$compile","uiGridConstants","gridUtil","$timeout",function(e,o,r,l,t){return{restrict:"EA",replace:!0,require:"^uiGrid",scope:!0,compile:function(e,r){return{pre:function(i,n,e,r){i.grid=r.grid;var t=i.grid.options.gridFooterTemplate;l.getTemplate(t).then(function(e){var r=angular.element(e),t=o(r)(i);n.append(t)}).catch(angular.noop)},post:function(e,r,t,i){}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridHeaderCell",["$compile","$timeout","$window","$document","gridUtil","uiGridConstants","ScrollEvent","i18nService",function(n,h,e,p,r,f,t,m){return{priority:0,scope:{col:"=",row:"=",renderIndex:"="},require:["^uiGrid","^uiGridRenderContainer"],replace:!0,compile:function(){return{pre:function(e,r,t){var i=e.col.headerCellTemplate;void 0===i&&""!==e.col.providedHeaderCellTemplate?e.col.headerCellTemplatePromise&&e.col.headerCellTemplatePromise.then(function(){i=e.col.headerCellTemplate,r.append(n(i)(e))}):r.append(n(i)(e))},post:function(i,n,e,r){var o=r[0],t=r[1];i.i18n={headerCell:m.getSafeText("headerCell"),sort:m.getSafeText("sort")},i.isSortPriorityVisible=function(){return angular.isNumber(i.col.sort.priority)&&i.grid.columns.some(function(e,r){return angular.isNumber(e.sort.priority)&&e!==i.col})},i.getSortDirectionAriaLabel=function(){var e=i.col,r=e.sort.direction===f.ASC?i.i18n.sort.ascending:e.sort.direction===f.DESC?i.i18n.sort.descending:i.i18n.sort.none;return i.isSortPriorityVisible()&&(r=r+". "+i.i18n.headerCell.priority+" "+(e.sort.priority+1)),r},i.grid=o.grid,i.renderContainer=o.grid.renderContainers[t.containerId];var l=i.col.getColClass(!1);n.addClass(l),i.menuShown=!1,i.asc=f.ASC,i.desc=f.DESC;angular.element(n[0].querySelectorAll(".ui-grid-header-cell-menu"));var a,s,d=angular.element(n[0].querySelectorAll(".ui-grid-cell-contents")),c=[];i.downFn=function(e){e.stopPropagation(),void 0!==e.originalEvent&&void 0!==e.originalEvent&&(e=e.originalEvent),e.button&&0!==e.button||(s=e.pageX,i.mousedownStartTime=(new Date).getTime(),i.mousedownTimeout=h(function(){},500),i.mousedownTimeout.then(function(){i.colMenu&&o.columnMenuScope.showMenu(i.col,n,e)}).catch(angular.noop),o.fireEvent(f.events.COLUMN_HEADER_CLICK,{event:e,columnName:i.col.colDef.name}),i.offAllEvents(),"touchstart"===e.type?(p.on("touchend",i.upFn),p.on("touchmove",i.moveFn)):"mousedown"===e.type&&(p.on("mouseup",i.upFn),p.on("mousemove",i.moveFn)))},i.upFn=function(e){e.stopPropagation(),h.cancel(i.mousedownTimeout),i.offAllEvents(),i.onDownEvents(e.type),500<(new Date).getTime()-i.mousedownStartTime||i.sortable&&i.handleClick(e)},i.handleKeyDown=function(e){32===e.keyCode&&e.preventDefault()},i.moveFn=function(e){0!==e.pageX-s&&(h.cancel(i.mousedownTimeout),i.offAllEvents(),i.onDownEvents(e.type))},i.clickFn=function(e){e.stopPropagation(),d.off("click",i.clickFn)},i.offAllEvents=function(){d.off("touchstart",i.downFn),d.off("mousedown",i.downFn),p.off("touchend",i.upFn),p.off("mouseup",i.upFn),p.off("touchmove",i.moveFn),p.off("mousemove",i.moveFn),d.off("click",i.clickFn)},i.onDownEvents=function(e){switch(e){case"touchmove":case"touchend":d.on("click",i.clickFn),d.on("touchstart",i.downFn),h(function(){d.on("mousedown",i.downFn)},500);break;case"mousemove":case"mouseup":d.on("click",i.clickFn),d.on("mousedown",i.downFn),h(function(){d.on("touchstart",i.downFn)},500);break;default:d.on("click",i.clickFn),d.on("touchstart",i.downFn),d.on("mousedown",i.downFn)}};var u=function(e){var r=n;a&&(r.removeClass(a),a=null),a=angular.isFunction(i.col.headerCellClass)?i.col.headerCellClass(i.grid,i.row,i.col,i.rowRenderIndex,i.colRenderIndex):i.col.headerCellClass,r.addClass(a),i.$applyAsync(function(){var e=i.grid.renderContainers.right&&i.grid.renderContainers.right.visibleColumnCache.length?i.grid.renderContainers.right:i.grid.renderContainers.body;i.isLastCol=o.grid.options&&o.grid.options.enableGridMenu&&i.col===e.visibleColumnCache[e.visibleColumnCache.length-1]}),i.sortable=Boolean(i.col.enableSorting);var t=i.filterable;i.filterable=Boolean(o.grid.options.enableFiltering&&i.col.enableFiltering),t!==i.filterable&&(void 0!==i.col.updateFilters&&i.col.updateFilters(i.filterable),i.filterable?(i.col.filters.forEach(function(e,r){c.push(i.$watch("col.filters["+r+"].term",function(e,r){e!==r&&(o.grid.api.core.raise.filterChanged(),o.grid.api.core.notifyDataChange(f.dataChange.COLUMN),o.grid.queueGridRefresh())}))}),i.$on("$destroy",function(){c.forEach(function(e){e()})})):c.forEach(function(e){e()})),i.col.grid.options&&!1!==i.col.grid.options.enableColumnMenus&&i.col.colDef&&!1!==i.col.colDef.enableColumnMenu?i.colMenu=!0:i.colMenu=!1,i.offAllEvents(),(i.sortable||i.colMenu)&&(i.onDownEvents(),i.$on("$destroy",function(){i.offAllEvents()}))};u();var g=i.grid.registerDataChangeCallback(u,[f.dataChange.COLUMN]);i.$on("$destroy",g),i.handleClick=function(e){var r=!1;e.shiftKey&&(r=!0),o.grid.sortColumn(i.col,r).then(function(){o.columnMenuScope&&o.columnMenuScope.hideMenu(),o.grid.refresh()}).catch(angular.noop)},i.headerCellArrowKeyDown=function(e){32!==e.keyCode&&13!==e.keyCode||(e.preventDefault(),i.toggleMenu(e))},i.toggleMenu=function(e){e.stopPropagation(),o.columnMenuScope.menuShown&&o.columnMenuScope.col===i.col?o.columnMenuScope.hideMenu():o.columnMenuScope.showMenu(i.col,n)}}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridHeader",["$templateCache","$compile","uiGridConstants","gridUtil","$timeout","ScrollEvent",function(e,c,r,u,t,g){return{restrict:"EA",replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:!0,compile:function(e,r){return{pre:function(n,o,e,r){var t,l=r[0],a=r[1];function s(){a.header=a.colContainer.header=o;var e=o[0].getElementsByClassName("ui-grid-header-canvas");0<e.length?a.headerCanvas=a.colContainer.headerCanvas=e[0]:a.headerCanvas=null}function d(e){if(!l.grid.isScrollingHorizontally){var r=u.normalizeScrollLeft(a.headerViewport,l.grid),t=a.colContainer.scrollHorizontal(r),i=new g(l.grid,null,a.colContainer,g.Sources.ViewPortScroll);i.newScrollLeft=r,-1<t&&(i.x={percentage:t}),l.grid.scrollContainers(null,i)}}n.grid=l.grid,n.colContainer=a.colContainer,s(),t=n.grid.options.showHeader?n.grid.options.headerTemplate?n.grid.options.headerTemplate:"ui-grid/ui-grid-header":"ui-grid/ui-grid-no-header",u.getTemplate(t).then(function(e){var r=angular.element(e),t=c(r)(n);if(o.replaceWith(t),o=t,s(),a){var i=o[0].getElementsByClassName("ui-grid-header-viewport")[0];i&&(a.headerViewport=i,angular.element(i).on("scroll",d),n.$on("$destroy",function(){angular.element(i).off("scroll",d)}))}n.grid.queueRefresh()}).catch(angular.noop)},post:function(e,r,t,i){var n=i[0],o=i[1];n.grid;u.disableAnimations(r);var l=(o.header=r)[0].getElementsByClassName("ui-grid-header-viewport")[0];l&&(o.headerViewport=l),n&&n.grid.registerStyleComputation({priority:15,func:function(){var e=o.colContainer.visibleColumnCache,r="",t=0;return e.forEach(function(e){r+=e.getColClassDefinition(),t+=e.drawnWidth}),o.colContainer.canvasWidth=t,r}})}}}}}])}(),angular.module("ui.grid").service("uiGridGridMenuService",["gridUtil","i18nService","uiGridConstants",function(n,l,r){var a={initialize:function(e,r){(r.gridMenuScope=e).grid=r,e.registeredMenuItems=[],e.$on("$destroy",function(){e.grid&&e.grid.gridMenuScope&&(e.grid.gridMenuScope=null),e.grid&&(e.grid=null),e.registeredMenuItems&&(e.registeredMenuItems=null)}),e.registeredMenuItems=[],r.api.registerMethod("core","addToGridMenu",a.addToGridMenu),r.api.registerMethod("core","removeFromGridMenu",a.removeFromGridMenu)},addToGridMenu:function(e,r){angular.isArray(r)?e.gridMenuScope?(e.gridMenuScope.registeredMenuItems=e.gridMenuScope.registeredMenuItems?e.gridMenuScope.registeredMenuItems:[],e.gridMenuScope.registeredMenuItems=e.gridMenuScope.registeredMenuItems.concat(r)):n.logError("Asked to addToGridMenu, but gridMenuScope not present.  Timing issue?  Please log issue with ui-grid"):n.logError("addToGridMenu: menuItems must be an array, and is not, not adding any items")},removeFromGridMenu:function(e,t){var i=-1;e&&e.gridMenuScope&&e.gridMenuScope.registeredMenuItems.forEach(function(e,r){e.id===t&&(-1<i?n.logError("removeFromGridMenu: found multiple items with the same id, removing only the last"):i=r)}),-1<i&&e.gridMenuScope.registeredMenuItems.splice(i,1)},getMenuItems:function(r){var e=[];r.grid.options.gridMenuCustomItems&&(angular.isArray(r.grid.options.gridMenuCustomItems)?e=e.concat(r.grid.options.gridMenuCustomItems):n.logError("gridOptions.gridMenuCustomItems must be an array, and is not"));var t=[{title:l.getSafeText("gridMenu.clearAllFilters"),action:function(e){r.grid.clearAllFilters()},shown:function(){return r.grid.options.enableFiltering},order:100}];return e=(e=e.concat(t)).concat(r.registeredMenuItems),!1!==r.grid.options.gridMenuShowHideColumns&&(e=e.concat(a.showHideColumns(r))),e.sort(function(e,r){return e.order-r.order}),e},showHideColumns:function(i){var n=[];if(!i.grid.options.columnDefs||0===i.grid.options.columnDefs.length||0===i.grid.columns.length)return n;function o(e){return!0===e.visible||void 0===e.visible}return n.push({title:l.getSafeText("gridMenu.columns"),order:300}),i.grid.options.gridMenuTitleFilter=i.grid.options.gridMenuTitleFilter?i.grid.options.gridMenuTitleFilter:function(e){return e},i.grid.options.columnDefs.forEach(function(e,r){if(!1!==e.enableHiding){var t={icon:o(e)?"ui-grid-icon-ok":"ui-grid-icon-cancel",action:function(e){e.stopPropagation(),a.toggleColumnVisibility(this.context.gridCol),e.target&&e.target.firstChild&&(e.target.firstChild.className=o(this.context.gridCol.colDef)?"ui-grid-icon-ok":"ui-grid-icon-cancel")},shown:function(){return!1!==this.context.gridCol.colDef.enableHiding},context:{gridCol:i.grid.getColumn(e.name||e.field)},leaveOpen:!0,order:301+r};a.setMenuItemTitle(t,e,i.grid),n.push(t)}}),n},setMenuItemTitle:function(r,e,t){var i=t.options.gridMenuTitleFilter(e.displayName||n.readableColumnName(e.name)||e.field);"string"==typeof i?r.title=i:i.then?(r.title="",i.then(function(e){r.title=e},function(e){r.title=e}).catch(angular.noop)):(n.logError("Expected gridMenuTitleFilter to return a string or a promise, it has returned neither, bad config"),r.title="badconfig")},toggleColumnVisibility:function(e){e.colDef.visible=!(!0===e.colDef.visible||void 0===e.colDef.visible),e.grid.refresh(),e.grid.api.core.notifyDataChange(r.dataChange.COLUMN),e.grid.api.core.raise.columnVisibilityChanged(e)}};return a}]).directive("uiGridMenuButton",["gridUtil","uiGridConstants","uiGridGridMenuService","i18nService",function(o,e,l,a){return{priority:0,scope:!0,require:["^uiGrid"],templateUrl:"ui-grid/ui-grid-menu-button",replace:!0,link:function(e,r,t,i){var n=i[0];e.i18n={aria:a.getSafeText("gridMenu.aria")},l.initialize(e,n.grid),e.shown=!1,e.toggleMenu=function(){e.shown?(e.$broadcast("hide-menu"),e.shown=!1):(e.menuItems=l.getMenuItems(e),e.$broadcast("show-menu"),e.shown=!0)},e.$on("menu-hidden",function(){e.shown=!1,o.focus.bySelector(r,".ui-grid-icon-container")})}}}]),angular.module("ui.grid").directive("uiGridMenu",["$compile","$timeout","$window","$document","gridUtil","uiGridConstants","i18nService",function(d,c,u,e,g,h,p){return{priority:0,scope:{menuItems:"=",autoHide:"=?"},require:"?^uiGrid",templateUrl:"ui-grid/uiGridMenu",replace:!1,link:function(i,o,e,t){if(i.dynamicStyles="",t&&t.grid&&t.grid.options&&t.grid.options.gridMenuTemplate){var r=t.grid.options.gridMenuTemplate;g.getTemplate(r).then(function(e){var r=angular.element(e),t=d(r)(i);o.replaceWith(t)}).catch(angular.noop)}var n=function(e){var r=e-t.grid.headerHeight-20;i.dynamicStyles=[".grid"+t.grid.id+" .ui-grid-menu-mid {","max-height: "+r+"px;","}"].join(" ")};t&&(n(t.grid.gridHeight),t.grid.api.core.on.gridDimensionChanged(i,function(e,r,t,i){n(t)})),i.i18n={close:p.getSafeText("columnMenu.close")},i.showMenu=function(e,r){i.shown?i.shownMid||(i.shownMid=!0,i.$emit("menu-shown")):(i.shown=!0,c(function(){i.shownMid=!0,i.$emit("menu-shown")}));var t="click";r&&r.originalEvent&&r.originalEvent.type&&"touchstart"===r.originalEvent.type&&(t=r.originalEvent.type),angular.element(document).off("click touchstart",l),o.off("keyup",a),o.off("keydown",s),c(function(){angular.element(document).on(t,l),o.on("keyup",a),o.on("keydown",s)})},i.hideMenu=function(e){i.shown&&(i.shownMid=!1,c(function(){i.shownMid||(i.shown=!1,i.$emit("menu-hidden"))},40)),angular.element(document).off("click touchstart",l),o.off("keyup",a),o.off("keydown",s)},i.$on("hide-menu",function(e,r){i.hideMenu(e,r)}),i.$on("show-menu",function(e,r){i.showMenu(e,r)});var l=function(){i.shown&&i.$apply(function(){i.hideMenu()})},a=function(e){27===e.keyCode&&i.hideMenu()},s=function(r){var e=function(e){return e.focus(),r.preventDefault(),!1};if(9===r.keyCode){var t,i,n=o[0].querySelectorAll("button:not(.ng-hide)");0<n.length&&(t=n[0],i=n[n.length-1],r.target!==i||r.shiftKey?r.target===t&&r.shiftKey&&e(i):e(t))}};void 0!==i.autoHide&&void 0!==i.autoHide||(i.autoHide=!0),i.autoHide&&angular.element(u).on("resize",l),i.$on("$destroy",function(){angular.element(u).off("resize",l),angular.element(document).off("click touchstart",l),o.off("keyup",a),o.off("keydown",s)}),t&&i.$on("$destroy",t.grid.api.core.on.scrollBegin(i,l)),i.$on("$destroy",i.$on(h.events.ITEM_DRAGGING,l))}}}]).directive("uiGridMenuItem",["gridUtil","$compile","i18nService",function(l,o,i){return{priority:0,scope:{name:"=",active:"=",action:"=",icon:"=",shown:"=",context:"=",templateUrl:"=",leaveOpen:"=",screenReaderOnly:"="},require:["?^uiGrid"],templateUrl:"ui-grid/uiGridMenuItem",replace:!1,compile:function(){return{pre:function(i,n){i.templateUrl&&l.getTemplate(i.templateUrl).then(function(e){var r=angular.element(e),t=o(r)(i);n.replaceWith(t)}).catch(angular.noop)},post:function(n,e,r,t){var o=t[0];void 0!==n.shown&&null!==n.shown||(n.shown=function(){return!0}),n.itemShown=function(){var e={};return n.context&&(e.context=n.context),void 0!==o&&o&&(e.grid=o.grid),n.shown.call(e)},n.itemAction=function(e,r){if(e.stopPropagation(),"function"==typeof n.action){var t={};if(n.context&&(t.context=n.context),void 0!==o&&o&&(t.grid=o.grid),n.action.call(t,e,r),n.leaveOpen){var i=e.target.parentElement;"I"===angular.element(e.target)[0].nodeName&&(i=i.parentElement),l.focus.bySelector(i,"button[type=button]",!0)}else n.$emit("hide-menu")}},n.label=function(){var e=n.name;return"function"==typeof n.name&&(e=n.name.call()),e},n.i18n=i.get()}}}}}]),function(){"use strict";var r=angular.module("ui.grid");angular.forEach([{tag:"Src",method:"attr"},{tag:"Text",method:"text"},{tag:"Href",method:"attr"},{tag:"Class",method:"addClass"},{tag:"Html",method:"html"},{tag:"Alt",method:"attr"},{tag:"Style",method:"css"},{tag:"Value",method:"attr"},{tag:"Id",method:"attr"},{tag:"Id",directiveName:"IdGrid",method:"attr",appendGridId:!0},{tag:"Title",method:"attr"},{tag:"Label",method:"attr",aria:!0},{tag:"Labelledby",method:"attr",aria:!0},{tag:"Labelledby",directiveName:"LabelledbyGrid",appendGridId:!0,method:"attr",aria:!0},{tag:"Describedby",method:"attr",aria:!0},{tag:"Describedby",directiveName:"DescribedbyGrid",appendGridId:!0,method:"attr",aria:!0}],function(d){var e="uiGridOneBind",c=(d.aria?e+"Aria":e)+(d.directiveName?d.directiveName:d.tag);r.directive(c,["gridUtil",function(s){return{restrict:"A",require:["?uiGrid","?^uiGrid"],link:function(n,o,e,l){var a=n.$watch(e[c],function(e){if(e){if(d.appendGridId){var r=null;angular.forEach(e.split(" "),function(e){r=(r?r+" ":"")+function(e){var r;if(n.grid)r=n.grid;else if(n.col&&n.col.grid)r=n.col.grid;else if(!l.some(function(e){if(e&&e.grid)return r=e.grid,!0}))throw s.logError("["+c+"] A valid grid could not be found to bind id. Are you using this directive within the correct scope? Trying to generate id: [gridID]-"+e),new Error("No valid grid could be found");r&&(new RegExp(r.id.toString()).test(e)||(e=r.id.toString()+"-"+e));return e}(e)}),e=r}switch(d.method){case"attr":d.aria?o[d.method]("aria-"+d.tag.toLowerCase(),e):o[d.method](d.tag.toLowerCase(),e);break;case"addClass":if(angular.isObject(e)&&!angular.isArray(e)){var t=[],i=!1;if(angular.forEach(e,function(e,r){null!=e&&(i=!0,e&&t.push(r))}),!i)return;e=t}if(!e)return;o.addClass(angular.isArray(e)?e.join(" "):e);break;default:o[d.method](e)}a()}},!0)}}}])})}(),function(){"use strict";var e=angular.module("ui.grid");e.directive("uiGridRenderContainer",["$timeout","$document","uiGridConstants","gridUtil","ScrollEvent",function(e,r,t,f,m){return{replace:!0,transclude:!0,templateUrl:"ui-grid/uiGridRenderContainer",require:["^uiGrid","uiGridRenderContainer"],scope:{containerId:"=",rowContainerName:"=",colContainerName:"=",bindScrollHorizontal:"=",bindScrollVertical:"=",enableVerticalScrollbar:"=",enableHorizontalScrollbar:"="},controller:"uiGridRenderContainer as RenderContainer",compile:function(){return{pre:function(e,r,t,i){var n=i[0],o=i[1],l=e.grid=n.grid;if(!e.rowContainerName)throw new Error("No row render container name specified");if(!e.colContainerName)throw new Error("No column render container name specified");if(!l.renderContainers[e.rowContainerName])throw new Error("Row render container '"+e.rowContainerName+"' is not registered.");if(!l.renderContainers[e.colContainerName])throw new Error("Column render container '"+e.colContainerName+"' is not registered.");var a=e.rowContainer=l.renderContainers[e.rowContainerName],s=e.colContainer=l.renderContainers[e.colContainerName];o.containerId=e.containerId,o.rowContainer=a,o.colContainer=s},post:function(s,r,e,t){var d=t[0],l=t[1],c=d.grid,u=l.rowContainer,g=l.colContainer,a=null,h=null,p=c.renderContainers[s.containerId];r.addClass("ui-grid-render-container-"+s.containerId),f.on.mousewheel(r,function(e){var r=new m(c,u,g,m.Sources.RenderContainerMouseWheel);if(0!==e.deltaY){var t=-1*e.deltaY*e.deltaFactor;a=l.viewport[0].scrollTop,r.verticalScrollLength=u.getVerticalScrollLength();var i=(a+t)/r.verticalScrollLength;1<=i&&a<r.verticalScrollLength&&(l.viewport[0].scrollTop=r.verticalScrollLength),i<0?i=0:1<i&&(i=1),r.y={percentage:i,pixels:t}}if(0!==e.deltaX){var n=e.deltaX*e.deltaFactor;h=f.normalizeScrollLeft(l.viewport,c),r.horizontalScrollLength=g.getCanvasWidth()-g.getViewportWidth();var o=(h+n)/r.horizontalScrollLength;o<0?o=0:1<o&&(o=1),r.x={percentage:o,pixels:n}}0!==e.deltaY&&(r.atTop(a)||r.atBottom(a))||0!==e.deltaX&&(r.atLeft(h)||r.atRight(h))||(e.preventDefault(),e.stopPropagation(),r.fireThrottledScrollingEvent("",r))}),r.bind("$destroy",function(){r.unbind("keydown"),["touchstart","touchmove","touchend","keydown","wheel","mousewheel","DomMouseScroll","MozMousePixelScroll"].forEach(function(e){r.unbind(e)})}),d.grid.registerStyleComputation({priority:6,func:function(){var e,r,t="",i=g.canvasWidth,n=g.getViewportWidth(),o=u.getCanvasHeight(),l=u.getViewportHeight();if(g.needsHScrollbarPlaceholder()&&(l-=c.scrollbarHeight),e=r=g.getHeaderViewportWidth(),t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-canvas { width: "+i+"px; height: "+o+"px; }",t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-header-canvas { width: "+(i+c.scrollbarWidth)+"px; }",p.explicitHeaderCanvasHeight){var a=document.querySelector(".grid"+d.grid.id+" .ui-grid-render-container-body .ui-grid-header-canvas");a&&(p.explicitHeaderCanvasHeight=a.offsetHeight),t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-header-canvas { height: "+p.explicitHeaderCanvasHeight+"px; }"}else t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-header-canvas { height: inherit; }";return t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-viewport { width: "+n+"px; height: "+l+"px; }",t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-header-viewport { width: "+e+"px; }",t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-footer-canvas { width: "+(i+c.scrollbarWidth)+"px; }",t+="\n .grid"+d.grid.id+" .ui-grid-render-container-"+s.containerId+" .ui-grid-footer-viewport { width: "+r+"px; }"}})}}}}}]),e.controller("uiGridRenderContainer",["$scope","gridUtil",function(e,r){}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridRow",["gridUtil",function(e){return{replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:{row:"=uiGridRow",rowRenderIndex:"="},compile:function(){return{pre:function(r,i,e,t){var n,o,l=t[0],a=t[1];l.grid;function s(){r.row.getRowTemplateFn.then(function(e){var t=r.$new();e(t,function(e,r){n&&(n.remove(),o.$destroy()),i.empty().append(e),n=e,o=t})}).catch(angular.noop)}r.grid=l.grid,r.colContainer=a.colContainer,s(),r.$watch("row.getRowTemplateFn",function(e,r){e!==r&&s()})},post:function(e,r,t,i){}}}}}])}(),angular.module("ui.grid").directive("uiGridStyle",["gridUtil","$interpolate",function(e,o){return{link:function(e,r,t,i){var n=o(r.text(),!0);n&&e.$watch(n,function(e){r.text(e)})}}}]),function(){"use strict";angular.module("ui.grid").directive("uiGridViewport",["gridUtil","ScrollEvent","uiGridConstants","$log",function(u,g,e,r){return{replace:!0,scope:{},controllerAs:"Viewport",templateUrl:"ui-grid/uiGridViewport",require:["^uiGrid","^uiGridRenderContainer"],link:function(l,a,e,r){var t=r[0],i=r[1],s=(l.containerCtrl=i).rowContainer,d=i.colContainer,c=t.grid;l.grid=t.grid,l.rowContainer=i.rowContainer,l.colContainer=i.colContainer,i.viewport=a,c&&c.options&&c.options.customScroller?c.options.customScroller(a,n):a.on("scroll",n);function n(e){var r=a[0].scrollTop,t=u.normalizeScrollLeft(a,c),i=s.scrollVertical(r),n=d.scrollHorizontal(t),o=new g(c,s,d,g.Sources.ViewPortScroll);o.newScrollLeft=t,o.newScrollTop=r,-1<n&&(o.x={percentage:n}),-1<i&&(o.y={percentage:i}),c.scrollContainers(l.$parent.containerId,o)}l.$parent.bindScrollVertical&&c.addVerticalScrollSync(l.$parent.containerId,function(e){var r=(i.prevScrollArgs=e).getNewScrollTop(s,i.viewport);a[0].scrollTop=r}),l.$parent.bindScrollHorizontal&&(c.addHorizontalScrollSync(l.$parent.containerId,function(e){var r=(i.prevScrollArgs=e).getNewScrollLeft(d,i.viewport);a[0].scrollLeft=u.denormalizeScrollLeft(i.viewport,r,c)}),c.addHorizontalScrollSync(l.$parent.containerId+"header",function(e){var r=e.getNewScrollLeft(d,i.viewport);i.headerViewport&&(i.headerViewport.scrollLeft=u.denormalizeScrollLeft(i.viewport,r,c))}),c.addHorizontalScrollSync(l.$parent.containerId+"footer",function(e){var r=e.getNewScrollLeft(d,i.viewport);i.footerViewport&&(i.footerViewport.scrollLeft=u.denormalizeScrollLeft(i.viewport,r,c))})),l.$on("$destroy",function(){a.off()})},controller:["$scope",function(o){this.rowStyle=function(e){var r=o.rowContainer,t=o.colContainer,i={};if(0!==r.currentTopRow){var n="translateY("+r.currentTopRow*r.grid.options.rowHeight+"px)";i.transform=n,i["-webkit-transform"]=n,i["-ms-transform"]=n}return 0!==t.currentFirstColumn&&(t.grid.isRTL()?i["margin-right"]=t.columnOffset+"px":i["margin-left"]=t.columnOffset+"px"),i}}]}}])}(),angular.module("ui.grid").directive("uiGridVisible",function(){return function(e,r,t){e.$watch(t.uiGridVisible,function(e){r[e?"removeClass":"addClass"]("ui-grid-invisible")})}}),function(){"use strict";function e(g,h,p){return{templateUrl:"ui-grid/ui-grid",scope:{uiGrid:"="},replace:!0,transclude:!0,controller:"uiGridController",compile:function(){return{post:function(a,s,e,r){var d=r.grid;r.scrollbars=[],d.element=s;var t,i,n=100,o=20,l=0;function c(){d.gridWidth=a.gridWidth=h.elementWidth(s),d.canvasWidth=r.grid.gridWidth,d.gridHeight=a.gridHeight=h.elementHeight(s),d.gridHeight-d.scrollbarHeight<=d.options.rowHeight&&d.options.enableMinHeightCheck&&function(){var e=d.options.minRowsToShow*d.options.rowHeight,r=d.options.showHeader?d.options.headerRowHeight:0,t=d.calcFooterHeight(),i=0;d.options.enableHorizontalScrollbar===p.scrollbars.ALWAYS&&(i=h.getScrollbarWidth());var n=0;if(angular.forEach(d.options.columnDefs,function(e){e.hasOwnProperty("filter")?n<1&&(n=1):e.hasOwnProperty("filters")&&n<e.filters.length&&(n=e.filters.length)}),d.options.enableFiltering&&!n){var o=d.options.columnDefs.length&&d.options.columnDefs.every(function(e){return!1===e.enableFiltering});o||(n=1)}var l=r+e+t+i+n*r;s.css("height",l+"px"),d.gridHeight=a.gridHeight=h.elementHeight(s)}(),d.refreshCanvas(!0)}function u(){d.gridWidth=a.gridWidth=h.elementWidth(s),d.gridHeight=a.gridHeight=h.elementHeight(s),d.refreshCanvas(!0)}angular.element(g).on("resize",u),s.on("$destroy",function(){angular.element(g).off("resize",u),t(),i()}),t=a.$watch(function(){return d.hasLeftContainer()},function(e,r){e!==r&&d.refreshCanvas(!0)}),i=a.$watch(function(){return d.hasRightContainer()},function(e,r){e!==r&&d.refreshCanvas(!0)}),c(),d.renderingComplete(),function e(){s[0].offsetWidth<=0&&l<o?(setTimeout(e,n),l++):a.$applyAsync(c)}()}}}}}angular.module("ui.grid").controller("uiGridController",["$scope","$element","$attrs","gridUtil","$q","uiGridConstants","gridClassFactory","$parse","$compile",function(i,e,n,r,o,l,t,a,s){var d,c=this,u=[];function g(e){return e?e.length:0}function h(e,r){e&&e!==r&&(c.grid.options.columnDefs=i.uiGrid.columnDefs,c.grid.callDataChangeCallbacks(l.dataChange.COLUMN,{orderByColumnDefs:!0,preCompileCellTemplates:!0}))}function p(e){var r=[];if(c.grid.options.fastWatch&&(e=angular.isString(i.uiGrid.data)?c.grid.appScope.$eval(i.uiGrid.data):i.uiGrid.data),d=e){var t=c.grid.columns.length>(c.grid.rowHeaderColumns?c.grid.rowHeaderColumns.length:0);!t&&!n.uiGridColumns&&0===c.grid.options.columnDefs.length&&0<e.length&&c.grid.buildColumnDefsFromData(e),!t&&(0<c.grid.options.columnDefs.length||0<e.length)&&r.push(c.grid.buildColumns().then(function(){c.grid.preCompileCellTemplates()}).catch(angular.noop)),o.all(r).then(function(){c.grid.modifyRows(d).then(function(){c.grid.redrawInPlace(!0),i.$evalAsync(function(){c.grid.refreshCanvas(!0),c.grid.callDataChangeCallbacks(l.dataChange.ROW)})}).catch(angular.noop)}).catch(angular.noop)}}c.grid=t.createGrid(i.uiGrid),c.grid.appScope=c.grid.appScope||i.$parent,e.addClass("grid"+c.grid.id),c.grid.rtl="rtl"===r.getStyles(e[0]).direction,i.grid=c.grid,n.uiGridColumns&&u.push(n.$observe("uiGridColumns",function(e){c.grid.options.columnDefs=angular.isString(e)?angular.fromJson(e):e,c.grid.buildColumns().then(function(){c.grid.preCompileCellTemplates(),c.grid.refreshCanvas(!0)}).catch(angular.noop)})),c.grid.options.fastWatch?(c.uiGrid=i.uiGrid,angular.isString(i.uiGrid.data)?(u.push(i.$parent.$watch(i.uiGrid.data,p)),u.push(i.$parent.$watch(function(){return c.grid.appScope[i.uiGrid.data]?c.grid.appScope[i.uiGrid.data].length:void 0},p))):(u.push(i.$parent.$watch(function(){return i.uiGrid.data},p)),u.push(i.$parent.$watch(function(){return g(i.uiGrid.data)},function(){p(i.uiGrid.data)}))),u.push(i.$parent.$watch(function(){return i.uiGrid.columnDefs},h)),u.push(i.$parent.$watch(function(){return g(i.uiGrid.columnDefs)},function(){h(i.uiGrid.columnDefs)}))):(angular.isString(i.uiGrid.data)?u.push(i.$parent.$watchCollection(i.uiGrid.data,p)):u.push(i.$parent.$watchCollection(function(){return i.uiGrid.data},p)),u.push(i.$parent.$watchCollection(function(){return i.uiGrid.columnDefs},h)));var f=i.$watch(function(){return c.grid.styleComputations},function(){c.grid.refreshCanvas(!0)});i.$on("$destroy",function(){u.forEach(function(e){e()}),f()}),c.fireEvent=function(e,r){r=r||{},angular.isUndefined(r.grid)&&(r.grid=c.grid),i.$broadcast(e,r)},c.innerCompile=function(e){s(e)(i)}}]),angular.module("ui.grid").directive("uiGrid",e),e.$inject=["$window","gridUtil","uiGridConstants"]}(),function(){"use strict";angular.module("ui.grid").directive("uiGridPinnedContainer",["gridUtil",function(e){return{restrict:"EA",replace:!0,template:'<div class="ui-grid-pinned-container"><div ui-grid-render-container container-id="side" row-container-name="\'body\'" col-container-name="side" bind-scroll-vertical="true" class="{{ side }} ui-grid-render-container-{{ side }}"></div></div>',scope:{side:"=uiGridPinnedContainer"},require:"^uiGrid",compile:function(){return{post:function(n,r,e,t){var o=t.grid,i=0;function l(){if("left"===n.side||"right"===n.side){for(var e=o.renderContainers[n.side].visibleColumnCache,r=0,t=0;t<e.length;t++){var i=e[t];r+=i.drawnWidth||i.width||0}return r}}r.addClass("ui-grid-pinned-container-"+n.side),"left"!==n.side&&"right"!==n.side||(o.renderContainers[n.side].getViewportWidth=function(){var r=0;this.visibleColumnCache.forEach(function(e){r+=e.drawnWidth});var e=this.getViewportAdjustment();return r+=e.width}),o.renderContainers.body.registerViewportAdjuster(function(e){return i=l(),e.width-=i,e.side=n.side,e}),o.registerStyleComputation({priority:15,func:function(){var e="";return"left"!==n.side&&"right"!==n.side||(i=l(),r.attr("style",null),e+=".grid"+o.id+" .ui-grid-pinned-container-"+n.side+", .grid"+o.id+" .ui-grid-pinned-container-"+n.side+" .ui-grid-render-container-"+n.side+" .ui-grid-viewport { width: "+i+"px; } "),e}})}}}}}])}(),angular.module("ui.grid").factory("Grid",["$q","$compile","$parse","gridUtil","uiGridConstants","GridOptions","GridColumn","GridRow","GridApi","rowSorter","rowSearcher","GridRenderContainer","$timeout","ScrollEvent",function(S,t,o,f,s,d,c,u,g,h,r,p,i,E){var e=function(e){var t=this;if(void 0===e||void 0===e.id||!e.id)throw new Error("No ID provided. An ID must be given when creating a grid.");if(!/^[_a-zA-Z0-9-]+$/.test(e.id))throw new Error("Grid id '"+e.id+'" is invalid. It must follow CSS selector syntax rules.');function r(e){t.isScrollingVertically=!1,t.api.core.raise.scrollEnd(e),t.scrollDirection=s.scrollDirection.NONE}t.id=e.id,delete e.id,t.options=d.initialize(e),t.appScope=t.options.appScopeProvider,t.headerHeight=t.options.headerRowHeight,t.footerHeight=t.calcFooterHeight(),t.columnFooterHeight=t.calcColumnFooterHeight(),t.rtl=!1,t.gridHeight=0,t.gridWidth=0,t.columnBuilders=[],t.rowBuilders=[],t.rowsProcessors=[],t.columnsProcessors=[],t.styleComputations=[],t.viewportAdjusters=[],t.rowHeaderColumns=[],t.dataChangeCallbacks={},t.verticalScrollSyncCallBackFns={},t.horizontalScrollSyncCallBackFns={},t.renderContainers={},t.renderContainers.body=new p("body",t),t.cellValueGetterCache={},t.getRowTemplateFn=null,t.rows=[],t.columns=[],t.isScrollingVertically=!1,t.isScrollingHorizontally=!1,t.scrollDirection=s.scrollDirection.NONE,t.disableScrolling=!1;var i=f.debounce(r,t.options.scrollDebounce),n=f.debounce(r,0);function o(e){t.isScrollingHorizontally=!1,t.api.core.raise.scrollEnd(e),t.scrollDirection=s.scrollDirection.NONE}var l=f.debounce(o,t.options.scrollDebounce),a=f.debounce(o,0);t.flagScrollingVertically=function(e){t.isScrollingVertically||t.isScrollingHorizontally||t.api.core.raise.scrollBegin(e),t.isScrollingVertically=!0,0!==t.options.scrollDebounce&&e.withDelay?i(e):n(e)},t.flagScrollingHorizontally=function(e){t.isScrollingVertically||t.isScrollingHorizontally||t.api.core.raise.scrollBegin(e),t.isScrollingHorizontally=!0,0!==t.options.scrollDebounce&&e.withDelay?l(e):a(e)},t.scrollbarHeight=0,t.scrollbarWidth=0,t.options.enableHorizontalScrollbar!==s.scrollbars.NEVER&&(t.scrollbarHeight=f.getScrollbarWidth()),t.options.enableVerticalScrollbar!==s.scrollbars.NEVER&&(t.scrollbarWidth=f.getScrollbarWidth()),t.api=new g(t),t.api.registerMethod("core","refresh",this.refresh),t.api.registerMethod("core","queueGridRefresh",this.queueGridRefresh),t.api.registerMethod("core","refreshRows",this.refreshRows),t.api.registerMethod("core","queueRefresh",this.queueRefresh),t.api.registerMethod("core","handleWindowResize",this.handleWindowResize),t.api.registerMethod("core","addRowHeaderColumn",this.addRowHeaderColumn),t.api.registerMethod("core","scrollToIfNecessary",function(e,r){return t.scrollToIfNecessary(e,r)}),t.api.registerMethod("core","scrollTo",function(e,r){return t.scrollTo(e,r)}),t.api.registerMethod("core","registerRowsProcessor",this.registerRowsProcessor),t.api.registerMethod("core","registerColumnsProcessor",this.registerColumnsProcessor),t.api.registerMethod("core","sortHandleNulls",h.handleNulls),t.api.registerEvent("core","sortChanged"),t.api.registerEvent("core","columnVisibilityChanged"),t.api.registerMethod("core","notifyDataChange",this.notifyDataChange),t.api.registerMethod("core","clearAllFilters",this.clearAllFilters),t.registerDataChangeCallback(t.columnRefreshCallback,[s.dataChange.COLUMN]),t.registerDataChangeCallback(t.processRowsCallback,[s.dataChange.EDIT]),t.registerDataChangeCallback(t.updateFooterHeightCallback,[s.dataChange.OPTIONS]),t.registerStyleComputation({priority:10,func:t.getFooterStyles})};e.prototype.calcFooterHeight=function(){if(!this.hasFooter())return 0;var e=0;return this.options.showGridFooter&&(e+=this.options.gridFooterHeight),e+=this.calcColumnFooterHeight()},e.prototype.calcColumnFooterHeight=function(){var e=0;return this.options.showColumnFooter&&(e+=this.options.columnFooterHeight),e},e.prototype.getFooterStyles=function(){var e=".grid"+this.id+" .ui-grid-footer-aggregates-row { height: "+this.options.columnFooterHeight+"px; }";return e+=" .grid"+this.id+" .ui-grid-footer-info { height: "+this.options.gridFooterHeight+"px; }"},e.prototype.hasFooter=function(){return this.options.showGridFooter||this.options.showColumnFooter},e.prototype.isRTL=function(){return this.rtl},e.prototype.registerColumnBuilder=function(e){this.columnBuilders.push(e)},e.prototype.buildColumnDefsFromData=function(e){this.options.columnDefs=f.getColumnsFromData(e,this.options.excludeProperties)},e.prototype.registerRowBuilder=function(e){this.rowBuilders.push(e)},e.prototype.registerDataChangeCallback=function(e,r,t){var i=f.nextUid();r||(r=[s.dataChange.ALL]),Array.isArray(r)||f.logError("Expected types to be an array or null in registerDataChangeCallback, value passed was: "+r),this.dataChangeCallbacks[i]={callback:e,types:r,_this:t};var n=this;return function(){delete n.dataChangeCallbacks[i]}},e.prototype.callDataChangeCallbacks=function(t,i){angular.forEach(this.dataChangeCallbacks,function(e,r){-1===e.types.indexOf(s.dataChange.ALL)&&-1===e.types.indexOf(t)&&t!==s.dataChange.ALL||(e._this?e.callback.apply(e._this,this,i):e.callback(this,i))},this)},e.prototype.notifyDataChange=function(e){var r=s.dataChange;e===r.ALL||e===r.COLUMN||e===r.EDIT||e===r.ROW||e===r.OPTIONS?this.callDataChangeCallbacks(e):f.logError("Notified of a data change, but the type was not recognised, so no action taken, type was: "+e)},e.prototype.columnRefreshCallback=function(e,r){e.buildColumns(r),e.queueGridRefresh()},e.prototype.processRowsCallback=function(e){e.queueGridRefresh()},e.prototype.updateFooterHeightCallback=function(e){e.footerHeight=e.calcFooterHeight(),e.columnFooterHeight=e.calcColumnFooterHeight()},e.prototype.getColumn=function(r){var e=this.columns.filter(function(e){return e.colDef.name===r});return 0<e.length?e[0]:null},e.prototype.getColDef=function(r){var e=this.options.columnDefs.filter(function(e){return e.name===r});return 0<e.length?e[0]:null},e.prototype.assignTypes=function(){var n=this;n.options.columnDefs.forEach(function(e,r){if(!e.type){var t=new c(e,r,n),i=0<n.rows.length?n.rows[0]:null;e.type=i?f.guessType(n.getCellValue(i,t)):"string"}})},e.prototype.isRowHeaderColumn=function(e){return-1!==this.rowHeaderColumns.indexOf(e)},e.prototype.addRowHeaderColumn=function(e,r,t){var i=this;void 0===r&&(r=0);var n=new c(e,f.nextUid(),i);n.isRowHeader=!0,i.isRTL()?(i.createRightContainer(),n.renderContainer="right"):(i.createLeftContainer(),n.renderContainer="left"),i.columnBuilders[0](e,n,i.options).then(function(){n.enableFiltering=!1,n.enableSorting=!1,n.enableHiding=!1,n.headerPriority=r,i.rowHeaderColumns.push(n),i.rowHeaderColumns=i.rowHeaderColumns.sort(function(e,r){return e.headerPriority-r.headerPriority}),t||i.buildColumns().then(function(){i.preCompileCellTemplates(),i.queueGridRefresh()}).catch(angular.noop)}).catch(angular.noop)},e.prototype.getOnlyDataColumns=function(){var r=this,t=[];return r.columns.forEach(function(e){-1===r.rowHeaderColumns.indexOf(e)&&t.push(e)}),t},e.prototype.buildColumns=function(e){var r={orderByColumnDefs:!1};angular.extend(r,e);var t,i=this,n=[],o=i.rowHeaderColumns.length;for(t=0;t<i.columns.length;t++)i.getColDef(i.columns[t].name)||(i.columns.splice(t,1),t--);for(var l=i.rowHeaderColumns.length-1;0<=l;l--)i.columns.unshift(i.rowHeaderColumns[l]);if(i.options.columnDefs.forEach(function(r,e){i.preprocessColDef(r);var t=i.getColumn(r.name);t?t.updateColumnDef(r,!1):(t=new c(r,f.nextUid(),i),i.columns.splice(e+o,0,t)),i.columnBuilders.forEach(function(e){n.push(e.call(i,r,t,i.options))})}),r.orderByColumnDefs){var a=i.columns.slice(0),s=Math.min(i.options.columnDefs.length,i.columns.length);for(t=0;t<s;t++)i.columns[t+o].name!==i.options.columnDefs[t].name?a[t+o]=i.getColumn(i.options.columnDefs[t].name):a[t+o]=i.columns[t+o];i.columns.length=0,Array.prototype.splice.apply(i.columns,[0,0].concat(a))}return S.all(n).then(function(){0<i.rows.length&&i.assignTypes(),r.preCompileCellTemplates&&i.preCompileCellTemplates()}).catch(angular.noop)},e.prototype.preCompileCellTemplate=function(e){var r=e.cellTemplate.replace(s.MODEL_COL_FIELD,this.getQualifiedColField(e));r=r.replace(s.COL_FIELD,"grid.getCellValue(row, col)"),e.compiledElementFn=t(r),e.compiledElementFnDefer&&e.compiledElementFnDefer.resolve(e.compiledElementFn)},e.prototype.preCompileCellTemplates=function(){var r=this;r.columns.forEach(function(e){e.cellTemplate?r.preCompileCellTemplate(e):e.cellTemplatePromise&&e.cellTemplatePromise.then(function(){r.preCompileCellTemplate(e)}).catch(angular.noop)})},e.prototype.getQualifiedColField=function(e){var r="row.entity";return e.field===s.ENTITY_BINDING?r:f.preEval(r+"."+e.field)},e.prototype.createLeftContainer=function(){this.hasLeftContainer()||(this.renderContainers.left=new p("left",this,{disableColumnOffset:!0}))},e.prototype.createRightContainer=function(){this.hasRightContainer()||(this.renderContainers.right=new p("right",this,{disableColumnOffset:!0}))},e.prototype.hasLeftContainer=function(){return void 0!==this.renderContainers.left},e.prototype.hasRightContainer=function(){return void 0!==this.renderContainers.right},e.prototype.preprocessColDef=function(e){if(!e.field&&!e.name)throw new Error("colDef.name or colDef.field property is required");if(void 0===e.name&&void 0!==e.field){for(var r=e.field,t=2;this.getColumn(r);)r=e.field+t.toString(),t++;e.name=r}},e.prototype.newInN=function(e,r,t,i){for(var n=[],o=0;o<r.length;o++){for(var l=i?r[o][i]:r[o],a=!1,s=0;s<e.length;s++){var d=t?e[s][t]:e[s];if(this.options.rowEquality(l,d)){a=!0;break}}a||n.push(l)}return n},e.prototype.getRow=function(r,e){var t=this,i=(e=void 0===e?t.rows:e).filter(function(e){return t.options.rowEquality(e.entity,r)});return 0<i.length?i[0]:null},e.prototype.modifyRows=function(e){var n=this,o=n.rows.slice(0),l=n.rowHashMap||n.createRowHashMap(),a=!0;n.rowHashMap=n.createRowHashMap(),n.rows.length=0,e.forEach(function(e,r){var t,i;(i=n.options.enableRowHashing?l.get(e):n.getRow(e,o))&&((t=i).entity=e),t||(t=n.processRowBuilders(new u(e,r,n))),n.rows.push(t),n.rowHashMap.put(e,t),t.isSelected||(a=!1)}),n.selection&&n.rows.length&&(n.selection.selectAll=a),n.assignTypes();var r=S.when(n.processRowsProcessors(n.rows)).then(function(e){return n.setVisibleRows(e)}).catch(angular.noop),t=S.when(n.processColumnsProcessors(n.columns)).then(function(e){return n.setVisibleColumns(e)}).catch(angular.noop);return S.all([r,t])},e.prototype.addRows=function(e){for(var r=this,t=r.rows.length,i=0;i<e.length;i++){var n=r.processRowBuilders(new u(e[i],i+t,r));if(r.options.enableRowHashing){var o=r.rowHashMap.get(n.entity);o&&(o.row=n)}r.rows.push(n)}},e.prototype.processRowBuilders=function(r){var t=this;return t.rowBuilders.forEach(function(e){e.call(t,r,t.options)}),r},e.prototype.registerStyleComputation=function(e){this.styleComputations.push(e)},e.prototype.registerRowsProcessor=function(e,r){if(!angular.isFunction(e))throw"Attempt to register non-function rows processor: "+e;this.rowsProcessors.push({processor:e,priority:r}),this.rowsProcessors.sort(function(e,r){return e.priority-r.priority})},e.prototype.removeRowsProcessor=function(t){var i=-1;this.rowsProcessors.forEach(function(e,r){e.processor===t&&(i=r)}),-1!==i&&this.rowsProcessors.splice(i,1)},e.prototype.processRowsProcessors=function(e){var n=this,r=e.slice(0);if(0===n.rowsProcessors.length)return S.when(r);var o=S.defer();return function r(t,e){var i=n.rowsProcessors[t].processor;return S.when(i.call(n,e,n.columns)).then(function(e){if(!e)throw"Processor at index "+t+" did not return a set of renderable rows";if(!angular.isArray(e))throw"Processor at index "+t+" did not return an array";if(++t<=n.rowsProcessors.length-1)return r(t,e);o.resolve(e)}).catch(function(e){throw e})}(0,r),o.promise},e.prototype.setVisibleRows=function(e){var r=this;for(var t in r.renderContainers){var i=r.renderContainers[t];i.canvasHeightShouldUpdate=!0,void 0===i.visibleRowCache?i.visibleRowCache=[]:i.visibleRowCache.length=0}for(var n=0;n<e.length;n++){var o=e[n],l=void 0!==o.renderContainer&&o.renderContainer?o.renderContainer:"body";o.visible&&r.renderContainers[l].visibleRowCache.push(o)}r.api.core.raise.rowsVisibleChanged(this.api),r.api.core.raise.rowsRendered(this.api)},e.prototype.registerColumnsProcessor=function(e,r){if(!angular.isFunction(e))throw"Attempt to register non-function rows processor: "+e;this.columnsProcessors.push({processor:e,priority:r}),this.columnsProcessors.sort(function(e,r){return e.priority-r.priority})},e.prototype.removeColumnsProcessor=function(e){var r=this.columnsProcessors.indexOf(e);void 0!==r&&void 0!==r&&this.columnsProcessors.splice(r,1)},e.prototype.processColumnsProcessors=function(e){var n=this,o=e.slice(0);if(0===n.columnsProcessors.length)return S.when(o);var l=S.defer();return function r(t,e){var i=n.columnsProcessors[t].processor;return S.when(i.call(n,e,n.rows)).then(function(e){if(!e)throw"Processor at index "+t+" did not return a set of renderable rows";if(!angular.isArray(e))throw"Processor at index "+t+" did not return an array";if(++t<=n.columnsProcessors.length-1)return r(t,o);l.resolve(o)}).catch(angular.noop)}(0,o),l.promise},e.prototype.setVisibleColumns=function(e){for(var r in this.renderContainers)this.renderContainers[r].visibleColumnCache.length=0;for(var t=0;t<e.length;t++){var i=e[t];i.visible&&(void 0!==i.renderContainer&&i.renderContainer?this.renderContainers[i.renderContainer].visibleColumnCache.push(i):this.renderContainers.body.visibleColumnCache.push(i))}},e.prototype.handleWindowResize=function(e){var r=this;return r.gridWidth=f.elementWidth(r.element),r.gridHeight=f.elementHeight(r.element),r.queueRefresh()},e.prototype.queueRefresh=function(){var e=this;return e.refreshCanceller&&i.cancel(e.refreshCanceller),e.refreshCanceller=i(function(){e.refreshCanvas(!0)}),e.refreshCanceller.then(function(){e.refreshCanceller=null}).catch(angular.noop),e.refreshCanceller},e.prototype.queueGridRefresh=function(){var e=this;return e.gridRefreshCanceller&&i.cancel(e.gridRefreshCanceller),e.gridRefreshCanceller=i(function(){e.refresh(!0)}),e.gridRefreshCanceller.then(function(){e.gridRefreshCanceller=null}).catch(angular.noop),e.gridRefreshCanceller},e.prototype.updateCanvasHeight=function(){for(var e in this.renderContainers)this.renderContainers.hasOwnProperty(e)&&(this.renderContainers[e].canvasHeightShouldUpdate=!0)},e.prototype.buildStyles=function(){var t=this;t.customStyles="",t.styleComputations.sort(function(e,r){return null===e.priority?1:null===r.priority?-1:null===e.priority&&null===r.priority?0:e.priority-r.priority}).forEach(function(e){var r=e.func.call(t);angular.isString(r)&&(t.customStyles+="\n"+r)})},e.prototype.minColumnsToRender=function(){var n=this,o=this.getViewportWidth(),l=0,a=0;return n.columns.forEach(function(e,r){if(a<o)a+=e.drawnWidth,l++;else{for(var t=0,i=r;r-l<=i;i--)t+=n.columns[i].drawnWidth;t<o&&l++}}),l},e.prototype.getBodyHeight=function(){return this.getViewportHeight()},e.prototype.getViewportHeight=function(){var e=this.gridHeight-this.headerHeight-this.footerHeight;return e+=this.getViewportAdjustment().height},e.prototype.getViewportWidth=function(){var e=this.gridWidth;return e+=this.getViewportAdjustment().width},e.prototype.getHeaderViewportWidth=function(){return this.getViewportWidth()},e.prototype.addVerticalScrollSync=function(e,r){this.verticalScrollSyncCallBackFns[e]=r},e.prototype.addHorizontalScrollSync=function(e,r){this.horizontalScrollSyncCallBackFns[e]=r},e.prototype.scrollContainers=function(e,r){if(r.y){var t=["body","left","right"];this.flagScrollingVertically(r),"body"===e?t=["left","right"]:"left"===e?t=["body","right"]:"right"===e&&(t=["body","left"]);for(var i=0;i<t.length;i++){var n=t[i];this.verticalScrollSyncCallBackFns[n]&&this.verticalScrollSyncCallBackFns[n](r)}}if(r.x){var o=["body","bodyheader","bodyfooter"];this.flagScrollingHorizontally(r),"body"===e&&(o=["bodyheader","bodyfooter"]);for(var l=0;l<o.length;l++){var a=o[l];this.horizontalScrollSyncCallBackFns[a]&&this.horizontalScrollSyncCallBackFns[a](r)}}},e.prototype.registerViewportAdjuster=function(e){this.viewportAdjusters.push(e)},e.prototype.removeViewportAdjuster=function(e){var r=this.viewportAdjusters.indexOf(e);void 0!==r&&void 0!==r&&this.viewportAdjusters.splice(r,1)},e.prototype.getViewportAdjustment=function(){var r={height:0,width:0};return this.viewportAdjusters.forEach(function(e){r=e.call(this,r)}),r},e.prototype.getVisibleRowCount=function(){return this.renderContainers.body.visibleRowCache.length},e.prototype.getVisibleRows=function(){return this.renderContainers.body.visibleRowCache},e.prototype.getVisibleColumnCount=function(){return this.renderContainers.body.visibleColumnCache.length},e.prototype.searchRows=function(e){return r.search(this,e,this.columns)},e.prototype.sortByColumn=function(e){return h.sort(this,e,this.columns)},e.prototype.getCellValue=function(e,r){return void 0!==e.entity["$$"+r.uid]?e.entity["$$"+r.uid].rendered:this.options.flatEntityAccess&&void 0!==r.field?e.entity[r.field]:(r.cellValueGetterCache||(r.cellValueGetterCache=o(e.getEntityQualifiedColField(r))),r.cellValueGetterCache(e))},e.prototype.getCellDisplayValue=function(e,r){if(!r.cellDisplayGetterCache){var t=r.cellFilter?" | "+r.cellFilter:"";if(void 0!==e.entity["$$"+r.uid])r.cellDisplayGetterCache=o(e.entity["$$"+r.uid].rendered+t);else if(this.options.flatEntityAccess&&void 0!==r.field){var i=r.field.replace(/(')|(\\)/g,"\\$&");r.cellDisplayGetterCache=o("entity['"+i+"']"+t)}else r.cellDisplayGetterCache=o(e.getEntityQualifiedColField(r)+t)}var n=angular.extend({},e,{col:r});return r.cellDisplayGetterCache(n)},e.prototype.getNextColumnSortPriority=function(){var r=0;return this.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>=r&&(r=e.sort.priority+1)}),r},e.prototype.resetColumnSorting=function(r){this.columns.forEach(function(e){e===r||e.suppressRemoveSort||(e.sort={})})},e.prototype.getColumnSorting=function(){var r=[];return this.columns.slice(0).sort(h.prioritySort).forEach(function(e){e.sort&&void 0!==e.sort.direction&&e.sort.direction&&(e.sort.direction===s.ASC||e.sort.direction===s.DESC)&&r.push(e)}),r},e.prototype.sortColumn=function(e,r,t){var i=this,n=null;if(void 0===e||!e)throw new Error("No column parameter provided");if("boolean"==typeof r?t=r:n=r,t?void 0===e.sort.priority&&(e.sort.priority=i.getNextColumnSortPriority()):(i.resetColumnSorting(e),e.sort.priority=void 0,e.sort.priority=i.getNextColumnSortPriority()),n)e.sort.direction=n;else{var o=e.sortDirectionCycle.indexOf(e.sort.direction?e.sort.direction:null);o=(o+1)%e.sortDirectionCycle.length,e.colDef&&e.suppressRemoveSort&&!e.sortDirectionCycle[o]&&(o=(o+1)%e.sortDirectionCycle.length),e.sortDirectionCycle[o]?e.sort.direction=e.sortDirectionCycle[o]:l(e,i)}return i.api.core.raise.sortChanged(i,i.getColumnSorting()),S.when(e)};var l=function(r,e){e.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>r.sort.priority&&(e.sort.priority-=1)}),r.sort={}};function n(e,r){var t=e/r;return t<=1?t:1}function T(e,r,t){if(n(e,r)!==t)return{percentage:n(e,r)}}function R(e,r,t){var i=e/r;if((i=1<i?1:i)!==t)return{percentage:i}}function a(){}return e.prototype.renderingComplete=function(){angular.isFunction(this.options.onRegisterApi)&&this.options.onRegisterApi(this.api),this.api.core.raise.renderingComplete(this.api)},e.prototype.createRowHashMap=function(){var e=new a;return e.grid=this,e},e.prototype.refresh=function(e){var r=this,t=r.processRowsProcessors(r.rows).then(function(e){r.setVisibleRows(e)}).catch(angular.noop),i=r.processColumnsProcessors(r.columns).then(function(e){r.setVisibleColumns(e)}).catch(angular.noop);return S.all([t,i]).then(function(){r.refreshCanvas(!0),r.redrawInPlace(e)}).catch(angular.noop)},e.prototype.refreshRows=function(){var r=this;return r.processRowsProcessors(r.rows).then(function(e){r.setVisibleRows(e),r.redrawInPlace(),r.refreshCanvas(!0)}).catch(angular.noop)},e.prototype.refreshCanvas=function(u){var g=this,h=S.defer(),p=[];for(var e in g.renderContainers)if(g.renderContainers.hasOwnProperty(e)){var r=g.renderContainers[e];if(null===r.canvasWidth||isNaN(r.canvasWidth))continue;(r.header||r.headerCanvas)&&(r.explicitHeaderHeight=r.explicitHeaderHeight||null,r.explicitHeaderCanvasHeight=r.explicitHeaderCanvasHeight||null,p.push(r))}return u&&g.buildStyles(),0<p.length?i(function(){var e,r,t=!1,i=0,n=0,o=function(e,r){return e!==r&&(t=!0),r};for(e=0;e<p.length;e++)if(null!==(r=p[e]).canvasWidth&&!isNaN(r.canvasWidth)){if(r.header){var l=r.headerHeight=o(r.headerHeight,f.outerElementHeight(r.header)),a=f.getBorderSize(r.header,"top"),s=f.getBorderSize(r.header,"bottom"),d=parseInt(l-a-s,10);d=d<0?0:d,r.innerHeaderHeight=d,!r.explicitHeaderHeight&&i<d&&(i=d)}if(r.headerCanvas){var c=r.headerCanvasHeight=o(r.headerCanvasHeight,parseInt(f.outerElementHeight(r.headerCanvas),10));!r.explicitHeaderCanvasHeight&&n<c&&(n=c)}}for(e=0;e<p.length;e++)r=p[e],0<i&&void 0!==r.headerHeight&&null!==r.headerHeight&&(r.explicitHeaderHeight||r.headerHeight<i)&&(r.explicitHeaderHeight=o(r.explicitHeaderHeight,i)),0<n&&void 0!==r.headerCanvasHeight&&null!==r.headerCanvasHeight&&(r.explicitHeaderCanvasHeight||r.headerCanvasHeight<n)&&(r.explicitHeaderCanvasHeight=o(r.explicitHeaderCanvasHeight,n));u&&t&&g.buildStyles(),h.resolve()}):i(function(){h.resolve()}),h.promise},e.prototype.redrawInPlace=function(e){for(var r in this.renderContainers){var t=this.renderContainers[r];e?(t.adjustRows(t.prevScrollTop,null),t.adjustColumns(t.prevScrollLeft,null)):(t.adjustRows(null,t.prevScrolltopPercentage),t.adjustColumns(null,t.prevScrollleftPercentage))}},e.prototype.hasLeftContainerColumns=function(){return this.hasLeftContainer()&&0<this.renderContainers.left.renderedColumns.length},e.prototype.hasRightContainerColumns=function(){return this.hasRightContainer()&&0<this.renderContainers.right.renderedColumns.length},e.prototype.scrollToIfNecessary=function(e,r){var t=this,i=new E(t,"uiGrid.scrollToIfNecessary"),n=t.renderContainers.body.visibleRowCache,o=t.renderContainers.body.visibleColumnCache,l=t.renderContainers.body.prevScrollTop+t.headerHeight;l=l<0?0:l;var a=t.renderContainers.body.prevScrollLeft,s=t.renderContainers.body.prevScrollTop+t.gridHeight-t.renderContainers.body.headerHeight-t.footerHeight-t.scrollbarHeight,d=t.renderContainers.body.prevScrollLeft+Math.ceil(t.renderContainers.body.getViewportWidth());if(null!==e){var c,u=n.indexOf(e),g=t.renderContainers.body.getCanvasHeight()-t.renderContainers.body.getViewportHeight(),h=u*t.options.rowHeight+t.headerHeight;(h=h<0?0:h)<Math.floor(l)?(c=t.renderContainers.body.prevScrollTop-(l-h),r&&r.colDef&&r.colDef.enableCellEditOnFocus&&(c=c-t.footerHeight-t.scrollbarHeight),i.y=T(c,g,t.renderContainers.body.prevScrolltopPercentage)):h>Math.ceil(s)&&(c=h-s+t.renderContainers.body.prevScrollTop,i.y=T(c,g,t.renderContainers.body.prevScrolltopPercentage))}if(null!==r){for(var p=o.indexOf(r),f=t.renderContainers.body.getCanvasWidth()-t.renderContainers.body.getViewportWidth(),m=0,v=0;v<p;v++)m+=o[v].drawnWidth;var C,w=(m=m<0?0:m)+r.drawnWidth;w=w<0?0:w,m<a?(C=t.renderContainers.body.prevScrollLeft-(a-m),i.x=R(C,f,t.renderContainers.body.prevScrollleftPercentage)):d<w&&(C=w-d+t.renderContainers.body.prevScrollLeft,i.x=R(C,f,t.renderContainers.body.prevScrollleftPercentage))}var y=S.defer();if(i.y||i.x){i.withDelay=!1,t.scrollContainers("",i);var b=t.api.core.on.scrollEnd(null,function(){y.resolve(i),b()})}else y.resolve();return y.promise},e.prototype.scrollTo=function(e,r){var t=null,i=null;return null!=e&&(t=this.getRow(e)),null!=r&&(i=this.getColumn(r.name?r.name:r.field)),this.scrollToIfNecessary(t,i)},e.prototype.clearAllFilters=function(e,r,t){if(void 0===e&&(e=!0),void 0===r&&(r=!1),void 0===t&&(t=!1),this.columns.forEach(function(e){e.filters.forEach(function(e){e.term=void 0,r&&(e.condition=void 0),t&&(e.flags=void 0)})}),e)return this.refreshRows()},a.prototype={put:function(e,r){this[this.grid.options.rowIdentity(e)]=r},get:function(e){return this[this.grid.options.rowIdentity(e)]},remove:function(e){var r=this[e=this.grid.options.rowIdentity(e)];return delete this[e],r}},e}]),angular.module("ui.grid").factory("GridApi",["$q","$rootScope","gridUtil","uiGridConstants","GridRow","uiGridGridMenuService",function(e,r,d,t,i,n){var o=function(e){this.grid=e,this.listeners=[],this.registerEvent("core","renderingComplete"),this.registerEvent("core","filterChanged"),this.registerMethod("core","setRowInvisible",i.prototype.setRowInvisible),this.registerMethod("core","clearRowInvisible",i.prototype.clearRowInvisible),this.registerMethod("core","getVisibleRows",this.grid.getVisibleRows),this.registerEvent("core","rowsVisibleChanged"),this.registerEvent("core","rowsRendered"),this.registerEvent("core","scrollBegin"),this.registerEvent("core","scrollEnd"),this.registerEvent("core","canvasHeightChanged"),this.registerEvent("core","gridDimensionChanged")};function c(e,t,i,n){return r.$on(e,function(e){var r=Array.prototype.slice.call(arguments);r.splice(0,1),t.apply(n||i.api,r)})}return o.prototype.suppressEvents=function(e,r){var t=this,i=angular.isArray(e)?e:[e],n=t.listeners.filter(function(r){return i.some(function(e){return r.handler===e})});n.forEach(function(e){e.dereg()}),r(),n.forEach(function(e){e.dereg=c(e.eventId,e.handler,t.grid,e._this)})},o.prototype.registerEvent=function(o,l){var a=this;a[o]||(a[o]={});var e=a[o];e.on||(e.on={},e.raise={});var s=a.grid.id+o+l;e.raise[l]=function(){r.$emit.apply(r,[s].concat(Array.prototype.slice.call(arguments)))},e.on[l]=function(e,r,t){if(null===e||void 0!==e.$on){var i={handler:r,dereg:c(s,r,a.grid,t),eventId:s,scope:e,_this:t};a.listeners.push(i);var n=function(){i.dereg();var e=a.listeners.indexOf(i);a.listeners.splice(e,1)};return e&&e.$on("$destroy",function(){n()}),n}d.logError("asked to listen on "+o+".on."+l+" but scope wasn't passed in the input parameters.  It is legitimate to pass null, but you've passed something else, so you probably forgot to provide scope rather than did it deliberately, not registering")}},o.prototype.registerEventsFromObject=function(e){var t=this,i=[];angular.forEach(e,function(e,r){var t={name:r,events:[]};angular.forEach(e,function(e,r){t.events.push(r)}),i.push(t)}),i.forEach(function(r){r.events.forEach(function(e){t.registerEvent(r.name,e)})})},o.prototype.registerMethod=function(e,r,t,i){this[e]||(this[e]={}),this[e][r]=d.createBoundedWrapper(i||this.grid,t)},o.prototype.registerMethodsFromObject=function(e,t){var i=this,n=[];angular.forEach(e,function(e,r){var t={name:r,methods:[]};angular.forEach(e,function(e,r){t.methods.push({name:r,fn:e})}),n.push(t)}),n.forEach(function(r){r.methods.forEach(function(e){i.registerMethod(r.name,e.name,e.fn,t)})})},o}]),angular.module("ui.grid").factory("GridColumn",["gridUtil","uiGridConstants","i18nService",function(d,c,e){function r(e,r,t){var n=this;n.grid=t,n.uid=r,n.updateColumnDef(e,!0),n.aggregationValue=void 0,n.updateAggregationValue=function(){if(n.aggregationType){var r=0,e=n.grid.getVisibleRows(),t=function(){var i=[];return e.forEach(function(e){var r=n.grid.getCellValue(e,n),t=Number(r);isNaN(t)||i.push(t)}),i};angular.isFunction(n.aggregationType)?n.aggregationValue=n.aggregationType(e,n):n.aggregationType===c.aggregationTypes.count?n.aggregationValue=n.grid.getVisibleRowCount():n.aggregationType===c.aggregationTypes.sum?(t().forEach(function(e){r+=e}),n.aggregationValue=r):n.aggregationType===c.aggregationTypes.avg?(t().forEach(function(e){r+=e}),r/=t().length,n.aggregationValue=r):n.aggregationType===c.aggregationTypes.min?n.aggregationValue=Math.min.apply(null,t()):n.aggregationType===c.aggregationTypes.max?n.aggregationValue=Math.max.apply(null,t()):n.aggregationValue=" "}else n.aggregationValue=void 0},this.getAggregationValue=function(){return n.aggregationValue}}return r.prototype.hideColumn=function(){this.colDef.visible=!1},r.prototype.setPropertyOrDefault=function(e,r,t){var i=this;void 0!==e[r]&&e[r]?i[r]=e[r]:void 0!==i[r]?i[r]=i[r]:i[r]=t||{}},r.prototype.updateColumnDef=function(i,e){var n=this;if(void 0===(n.colDef=i).name)throw new Error("colDef.name is required for column at index "+n.grid.options.columnDefs.indexOf(i));if(n.displayName=void 0===i.displayName?d.readableColumnName(i.name):i.displayName,!angular.isNumber(n.width)||!n.hasCustomWidth||i.allowCustomWidthOverride){var r=i.width,t="Cannot parse column width '"+r+"' for column named '"+i.name+"'";if(n.hasCustomWidth=!1,angular.isString(r)||angular.isNumber(r))if(angular.isString(r))if(d.endsWith(r,"%")){var o=r.replace(/%/g,""),l=parseInt(o,10);if(isNaN(l))throw new Error(t);n.width=r}else if(r.match(/^(\d+)$/))n.width=parseInt(r.match(/^(\d+)$/)[1],10);else{if(!r.match(/^\*+$/))throw new Error(t);n.width=r}else n.width=r;else n.width="*"}function a(e){return angular.isString(e)||angular.isNumber(e)}["minWidth","maxWidth"].forEach(function(e){var r=i[e],t="Cannot parse column "+e+" '"+r+"' for column named '"+i.name+"'";if("minWidth"===e&&!a(r)&&angular.isDefined(n.grid.options.minimumColumnSize)&&(r=n.grid.options.minimumColumnSize),a(r))if(angular.isString(r)){if(!r.match(/^(\d+)$/))throw new Error(t);n[e]=parseInt(r.match(/^(\d+)$/)[1],10)}else n[e]=r;else n[e]="minWidth"===e?30:9e3}),n.field=void 0===i.field?i.name:i.field,"string"!=typeof n.field&&d.logError("Field is not a string, this is likely to break the code, Field is: "+n.field),n.name=i.name,n.displayName=void 0===i.displayName?d.readableColumnName(i.name):i.displayName,n.aggregationType=angular.isDefined(i.aggregationType)?i.aggregationType:null,n.footerCellTemplate=angular.isDefined(i.footerCellTemplate)?i.footerCellTemplate:null,void 0===i.cellTooltip||!1===i.cellTooltip?n.cellTooltip=!1:!0===i.cellTooltip?n.cellTooltip=function(e,r){return n.grid.getCellValue(e,r)}:"function"==typeof i.cellTooltip?n.cellTooltip=i.cellTooltip:n.cellTooltip=function(e,r){return r.colDef.cellTooltip},void 0===i.headerTooltip||!1===i.headerTooltip?n.headerTooltip=!1:!0===i.headerTooltip?n.headerTooltip=function(e){return e.displayName}:"function"==typeof i.headerTooltip?n.headerTooltip=i.headerTooltip:n.headerTooltip=function(e){return e.colDef.headerTooltip},n.footerCellClass=i.footerCellClass,n.cellClass=i.cellClass,n.headerCellClass=i.headerCellClass,n.cellFilter=i.cellFilter?i.cellFilter:"",n.sortCellFiltered=!!i.sortCellFiltered,n.filterCellFiltered=!!i.filterCellFiltered,n.headerCellFilter=i.headerCellFilter?i.headerCellFilter:"",n.footerCellFilter=i.footerCellFilter?i.footerCellFilter:"",n.visible=d.isNullOrUndefined(i.visible)||i.visible,n.headerClass=i.headerClass,n.enableSorting=void 0!==i.enableSorting?i.enableSorting:n.grid.options.enableSorting,n.sortingAlgorithm=i.sortingAlgorithm,n.sortDirectionCycle=void 0!==i.sortDirectionCycle?i.sortDirectionCycle:[null,c.ASC,c.DESC],void 0===n.suppressRemoveSort&&(n.suppressRemoveSort=void 0!==i.suppressRemoveSort&&i.suppressRemoveSort),n.enableFiltering=void 0===i.enableFiltering||i.enableFiltering,n.setPropertyOrDefault(i,"menuItems",[]),e&&n.setPropertyOrDefault(i,"sort"),n.setPropertyOrDefault(i,"defaultSort");var s=[];i.filter?s.push(i.filter):i.filters?s=i.filters:s.push({}),e?(n.setPropertyOrDefault(i,"filter"),n.setPropertyOrDefault(i,"extraStyle"),n.setPropertyOrDefault(i,"filters",s)):n.filters.length===s.length&&n.filters.forEach(function(e,r){void 0!==s[r].placeholder&&(e.placeholder=s[r].placeholder),void 0!==s[r].ariaLabel&&(e.ariaLabel=s[r].ariaLabel),void 0!==s[r].flags&&(e.flags=s[r].flags),void 0!==s[r].type&&(e.type=s[r].type),void 0!==s[r].selectOptions&&(e.selectOptions=s[r].selectOptions)})},r.prototype.unsort=function(){var r=this.sort.priority;this.grid.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>r&&(e.sort.priority-=1)}),this.sort={},this.grid.api.core.raise.sortChanged(this.grid,this.grid.getColumnSorting())},r.prototype.getColClass=function(e){var r=c.COL_CLASS_PREFIX+this.uid;return e?"."+r:r},r.prototype.isPinnedLeft=function(){return"left"===this.renderContainer},r.prototype.isPinnedRight=function(){return"right"===this.renderContainer},r.prototype.getColClassDefinition=function(){return" .grid"+this.grid.id+" "+this.getColClass(!0)+" { min-width: "+this.drawnWidth+"px; max-width: "+this.drawnWidth+"px; }"},r.prototype.getRenderContainer=function(){var e=this.renderContainer;return null!==e&&""!==e&&void 0!==e||(e="body"),this.grid.renderContainers[e]},r.prototype.showColumn=function(){this.colDef.visible=!0},r.prototype.getAggregationText=function(){if(this.colDef.aggregationHideLabel)return"";if(this.colDef.aggregationLabel)return this.colDef.aggregationLabel;switch(this.colDef.aggregationType){case c.aggregationTypes.count:return e.getSafeText("aggregation.count");case c.aggregationTypes.sum:return e.getSafeText("aggregation.sum");case c.aggregationTypes.avg:return e.getSafeText("aggregation.avg");case c.aggregationTypes.min:return e.getSafeText("aggregation.min");case c.aggregationTypes.max:return e.getSafeText("aggregation.max");default:return""}},r.prototype.getCellTemplate=function(){return this.cellTemplatePromise},r.prototype.getCompiledElementFn=function(){return this.compiledElementFnDefer.promise},r}]),angular.module("ui.grid").factory("GridOptions",["gridUtil","uiGridConstants",function(r,t){return{initialize:function(e){return e.onRegisterApi=e.onRegisterApi||angular.noop(),e.data=e.data||[],e.columnDefs=e.columnDefs||[],e.excludeProperties=e.excludeProperties||["$$hashKey"],e.enableRowHashing=!1!==e.enableRowHashing,e.rowIdentity=e.rowIdentity||function(e){return r.hashKey(e)},e.getRowIdentity=e.getRowIdentity||function(e){return e.$$hashKey},e.flatEntityAccess=!0===e.flatEntityAccess,e.showHeader=void 0===e.showHeader||e.showHeader,e.showHeader?e.headerRowHeight=void 0!==e.headerRowHeight?e.headerRowHeight:30:e.headerRowHeight=0,"string"==typeof e.rowHeight?e.rowHeight=parseInt(e.rowHeight)||30:e.rowHeight=e.rowHeight||30,e.minRowsToShow=void 0!==e.minRowsToShow?e.minRowsToShow:10,e.showGridFooter=!0===e.showGridFooter,e.showColumnFooter=!0===e.showColumnFooter,e.columnFooterHeight=void 0!==e.columnFooterHeight?e.columnFooterHeight:30,e.gridFooterHeight=void 0!==e.gridFooterHeight?e.gridFooterHeight:30,e.columnWidth=void 0!==e.columnWidth?e.columnWidth:50,e.maxVisibleColumnCount=void 0!==e.maxVisibleColumnCount?e.maxVisibleColumnCount:200,e.virtualizationThreshold=void 0!==e.virtualizationThreshold?e.virtualizationThreshold:20,e.columnVirtualizationThreshold=void 0!==e.columnVirtualizationThreshold?e.columnVirtualizationThreshold:10,e.excessRows=void 0!==e.excessRows?e.excessRows:4,e.scrollThreshold=void 0!==e.scrollThreshold?e.scrollThreshold:4,e.excessColumns=void 0!==e.excessColumns?e.excessColumns:4,e.horizontalScrollThreshold=void 0!==e.horizontalScrollThreshold?e.horizontalScrollThreshold:2,e.aggregationCalcThrottle=void 0!==e.aggregationCalcThrottle?e.aggregationCalcThrottle:500,e.wheelScrollThrottle=void 0!==e.wheelScrollThrottle?e.wheelScrollThrottle:70,e.scrollDebounce=void 0!==e.scrollDebounce?e.scrollDebounce:300,e.enableSorting=!1!==e.enableSorting,e.enableFiltering=!0===e.enableFiltering,e.enableColumnMenus=!1!==e.enableColumnMenus,e.enableVerticalScrollbar=void 0!==e.enableVerticalScrollbar?e.enableVerticalScrollbar:t.scrollbars.ALWAYS,e.enableHorizontalScrollbar=void 0!==e.enableHorizontalScrollbar?e.enableHorizontalScrollbar:t.scrollbars.ALWAYS,e.enableMinHeightCheck=!1!==e.enableMinHeightCheck,e.minimumColumnSize=void 0!==e.minimumColumnSize?e.minimumColumnSize:30,e.rowEquality=e.rowEquality||function(e,r){return e===r},e.headerTemplate=e.headerTemplate||null,e.footerTemplate=e.footerTemplate||"ui-grid/ui-grid-footer",e.gridFooterTemplate=e.gridFooterTemplate||"ui-grid/ui-grid-grid-footer",e.rowTemplate=e.rowTemplate||"ui-grid/ui-grid-row",e.gridMenuTemplate=e.gridMenuTemplate||"ui-grid/uiGridMenu",e.appScopeProvider=e.appScopeProvider||null,e}}}]),angular.module("ui.grid").factory("GridRenderContainer",["gridUtil","uiGridConstants",function(y,n){function e(e,r,t){var i=this;i.name=e,i.grid=r,i.visibleRowCache=[],i.visibleColumnCache=[],i.renderedRows=[],i.renderedColumns=[],i.prevScrollTop=0,i.prevScrolltopPercentage=0,i.prevRowScrollIndex=0,i.prevScrollLeft=0,i.prevScrollleftPercentage=0,i.prevColumnScrollIndex=0,i.columnStyles="",i.viewportAdjusters=[],i.hasHScrollbar=!1,i.hasVScrollbar=!1,i.canvasHeightShouldUpdate=!0,i.$$canvasHeight=0,t&&angular.isObject(t)&&angular.extend(i,t),r.registerStyleComputation({priority:5,func:function(){return i.updateColumnWidths(),i.columnStyles}})}return e.prototype.reset=function(){this.visibleColumnCache.length=0,this.visibleRowCache.length=0,this.renderedRows.length=0,this.renderedColumns.length=0},e.prototype.containsColumn=function(e){return-1!==this.visibleColumnCache.indexOf(e)},e.prototype.minRowsToRender=function(){for(var e=0,r=0,t=this.getViewportHeight(),i=this.visibleRowCache.length-1;r<t&&0<=i;i--)r+=this.visibleRowCache[i].height,e++;return e},e.prototype.minColumnsToRender=function(){for(var e=this.getViewportWidth(),r=0,t=0,i=0;i<this.visibleColumnCache.length;i++){var n=this.visibleColumnCache[i];if(t<e)t+=n.drawnWidth?n.drawnWidth:0,r++;else{for(var o=0,l=i;i-r<=l;l--)o+=this.visibleColumnCache[l].drawnWidth?this.visibleColumnCache[l].drawnWidth:0;o<e&&r++}}return r},e.prototype.getVisibleRowCount=function(){return this.visibleRowCache.length},e.prototype.registerViewportAdjuster=function(e){this.viewportAdjusters.push(e)},e.prototype.removeViewportAdjuster=function(e){var r=this.viewportAdjusters.indexOf(e);-1<r&&this.viewportAdjusters.splice(r,1)},e.prototype.getViewportAdjustment=function(){var r={height:0,width:0};return this.viewportAdjusters.forEach(function(e){r=e.call(this,r)}),r},e.prototype.getMargin=function(t){var i=0;return this.viewportAdjusters.forEach(function(e){var r=e.call(this,{height:0,width:0});r.side&&r.side===t&&(i+=-1*r.width)}),i},e.prototype.getViewportHeight=function(){var e=this,r=e.headerHeight?e.headerHeight:e.grid.headerHeight,t=e.grid.gridHeight-r-e.grid.footerHeight;return t+=e.getViewportAdjustment().height},e.prototype.getViewportWidth=function(){var e=this.grid.gridWidth;return e+=this.getViewportAdjustment().width},e.prototype.getHeaderViewportWidth=function(){return this.getViewportWidth()},e.prototype.getCanvasHeight=function(){var r=this;if(!r.canvasHeightShouldUpdate)return r.$$canvasHeight;var e=r.$$canvasHeight;return r.$$canvasHeight=0,r.visibleRowCache.forEach(function(e){r.$$canvasHeight+=e.height}),r.canvasHeightShouldUpdate=!1,r.grid.api.core.raise.canvasHeightChanged(e,r.$$canvasHeight),r.$$canvasHeight},e.prototype.getVerticalScrollLength=function(){return this.getCanvasHeight()-this.getViewportHeight()+this.grid.scrollbarHeight!==0?this.getCanvasHeight()-this.getViewportHeight()+this.grid.scrollbarHeight:-1},e.prototype.getHorizontalScrollLength=function(){return this.getCanvasWidth()-this.getViewportWidth()+this.grid.scrollbarWidth!==0?this.getCanvasWidth()-this.getViewportWidth()+this.grid.scrollbarWidth:-1},e.prototype.getCanvasWidth=function(){return this.canvasWidth},e.prototype.setRenderedRows=function(e){this.renderedRows.length=e.length;for(var r=0;r<e.length;r++)this.renderedRows[r]=e[r]},e.prototype.setRenderedColumns=function(e){this.renderedColumns.length=e.length;for(var r=0;r<e.length;r++)this.renderedColumns[r]=e[r];this.updateColumnOffset()},e.prototype.updateColumnOffset=function(){for(var e=0,r=0;r<this.currentFirstColumn;r++)e+=this.visibleColumnCache[r].drawnWidth;this.columnOffset=e},e.prototype.scrollVertical=function(e){var r=-1;if(e!==this.prevScrollTop){var t=e-this.prevScrollTop;return 0<t&&(this.grid.scrollDirection=n.scrollDirection.DOWN),t<0&&(this.grid.scrollDirection=n.scrollDirection.UP),1<(r=e/this.getVerticalScrollLength())&&(r=1),r<0&&(r=0),this.adjustScrollVertical(e,r),r}},e.prototype.scrollHorizontal=function(e){var r=-1;if(e!==this.prevScrollLeft){var t=e-this.prevScrollLeft;0<t&&(this.grid.scrollDirection=n.scrollDirection.RIGHT),t<0&&(this.grid.scrollDirection=n.scrollDirection.LEFT);var i=this.getHorizontalScrollLength();return r=0!==i?e/i:0,this.adjustScrollHorizontal(e,r),r}},e.prototype.adjustScrollVertical=function(e,r,t){(this.prevScrollTop!==e||t)&&(void 0!==e&&null!=e||(e=(this.getCanvasHeight()-this.getViewportHeight())*r),this.adjustRows(e,r,!1),this.prevScrollTop=e,this.prevScrolltopPercentage=r,this.grid.queueRefresh())},e.prototype.adjustScrollHorizontal=function(e,r,t){(this.prevScrollLeft!==e||t)&&(void 0!==e&&null!=e||(e=(this.getCanvasWidth()-this.getViewportWidth())*r),this.adjustColumns(e,r),this.prevScrollLeft=e,this.prevScrollleftPercentage=r,this.grid.queueRefresh())},e.prototype.adjustRows=function(e,r,t){var i=this,n=i.minRowsToRender(),o=i.visibleRowCache,l=o.length-n;null==r&&e&&(r=e/i.getVerticalScrollLength());var a=Math.ceil(Math.min(l,l*r));l<a&&(a=l);var s=[];if(o.length>i.grid.options.virtualizationThreshold){if(null!=e){if(!i.grid.suppressParentScrollDown&&i.prevScrollTop<e&&a<i.prevRowScrollIndex+i.grid.options.scrollThreshold&&a<l)return;if(!i.grid.suppressParentScrollUp&&i.prevScrollTop>e&&a>i.prevRowScrollIndex-i.grid.options.scrollThreshold&&a<l)return}s=[Math.max(0,a-i.grid.options.excessRows),Math.min(o.length,a+n+i.grid.options.excessRows)]}else{var d=i.visibleRowCache.length;s=[0,Math.max(d,n+i.grid.options.excessRows)]}i.updateViewableRowRange(s),i.prevRowScrollIndex=a},e.prototype.adjustColumns=function(e,r){var t=this,i=t.minColumnsToRender(),n=t.visibleColumnCache,o=n.length-i;null==r&&e&&(r=e/t.getHorizontalScrollLength());var l=Math.ceil(Math.min(o,o*r));o<l&&(l=o);var a=[];if(n.length>t.grid.options.columnVirtualizationThreshold&&t.getCanvasWidth()>t.getViewportWidth())a=[Math.max(0,l-t.grid.options.excessColumns),Math.min(n.length,l+i+t.grid.options.excessColumns)];else{var s=t.visibleColumnCache.length;a=[0,Math.max(s,i+t.grid.options.excessColumns)]}t.updateViewableColumnRange(a),t.prevColumnScrollIndex=l},e.prototype.updateViewableRowRange=function(e){var r=this.visibleRowCache.slice(e[0],e[1]);this.currentTopRow=e[0],this.setRenderedRows(r)},e.prototype.updateViewableColumnRange=function(e){var r=this.visibleColumnCache.slice(e[0],e[1]);this.currentFirstColumn=e[0],this.setRenderedColumns(r)},e.prototype.headerCellWrapperStyle=function(){if(0!==this.currentFirstColumn){var e=this.columnOffset;return this.grid.isRTL()?{"margin-right":e+"px"}:{"margin-left":e+"px"}}return null},e.prototype.updateColumnWidths=function(){var i=this,n=[],o=0,l=0,r="",a=!1,s=[],d=[],c=0,u=i.grid.getViewportWidth()-i.grid.scrollbarWidth,t=[];angular.forEach(i.grid.renderContainers,function(e){t=t.concat(e.visibleColumnCache)}),t.forEach(function(e){var r=0;if(e.visible)if(a&&(u+=i.grid.scrollbarWidth),!a&&e.colDef.pinnedRight&&(a=!0),angular.isNumber(e.width))r=parseInt(e.width,10),l+=r,e.drawnWidth=r,s.push(e);else if(y.endsWith(e.width,"%")){var t=parseInt(e.width.replace(/%/g,""),10);(r=parseInt(t/100*u))>e.maxWidth&&(r=e.maxWidth),r<e.minWidth&&(r=e.minWidth),l+=r,e.drawnWidth=r,c+=t,d.push(e)}else angular.isString(e.width)&&-1!==e.width.indexOf("*")&&(o+=e.width.length,n.push(e))});var e,g=u-l;if(0<n.length){var h=g/o;n.forEach(function(e){var r=parseInt(e.width.length*h,10);r>e.maxWidth&&(r=e.maxWidth),r<e.minWidth&&(r=e.minWidth),l+=r,e.drawnWidth=r})}if(0<n.length?e=n:0<d.length&&0===s.length&&100===c&&(e=d),!angular.isUndefined(e)){for(var p=function(e){e.drawnWidth<e.maxWidth&&0<f&&(e.drawnWidth++,l++,f--,m=!0)},f=u-l,m=!0;0<f&&m;)m=!1,e.forEach(p);var v=function(e){e.drawnWidth>e.minWidth&&0<C&&(e.drawnWidth--,l--,C--,m=!0)},C=l-u;for(m=!0;0<C&&m;)m=!1,e.forEach(v)}var w=0;i.visibleColumnCache.forEach(function(e){e.visible&&(w+=e.drawnWidth)}),t.forEach(function(e){r+=e.getColClassDefinition()}),i.canvasWidth=w,this.columnStyles=r},e.prototype.needsHScrollbarPlaceholder=function(){var e;return("left"===this.name||"right"===this.name&&!this.hasHScrollbar&&!this.grid.disableScrolling)&&(this.grid.options.enableHorizontalScrollbar===n.scrollbars.ALWAYS||(e=this.grid.element[0].querySelector(".ui-grid-render-container-body .ui-grid-viewport")).scrollWidth>e.offsetWidth)},e.prototype.getViewportStyle=function(){var e=this,r={},t={};return t[n.scrollbars.ALWAYS]="scroll",t[n.scrollbars.WHEN_NEEDED]="auto",e.hasHScrollbar=!1,e.hasVScrollbar=!1,e.grid.disableScrolling?(r["overflow-x"]="hidden",r["overflow-y"]="hidden"):("body"===e.name?(e.hasHScrollbar=e.grid.options.enableHorizontalScrollbar!==n.scrollbars.NEVER,e.grid.isRTL()?e.grid.hasLeftContainerColumns()||(e.hasVScrollbar=e.grid.options.enableVerticalScrollbar!==n.scrollbars.NEVER):e.grid.hasRightContainerColumns()||(e.hasVScrollbar=e.grid.options.enableVerticalScrollbar!==n.scrollbars.NEVER)):"left"===e.name?e.hasVScrollbar=!!e.grid.isRTL()&&e.grid.options.enableVerticalScrollbar!==n.scrollbars.NEVER:e.hasVScrollbar=!e.grid.isRTL()&&e.grid.options.enableVerticalScrollbar!==n.scrollbars.NEVER,r["overflow-x"]=e.hasHScrollbar?t[e.grid.options.enableHorizontalScrollbar]:"hidden",r["overflow-y"]=e.hasVScrollbar?t[e.grid.options.enableVerticalScrollbar]:"hidden"),r},e}]),angular.module("ui.grid").factory("GridRow",["gridUtil","uiGridConstants",function(i,r){function e(e,r,t){this.grid=t,this.entity=e,this.uid=i.nextUid(),this.visible=!0,this.isSelected=!1,this.$$height=t.options.rowHeight}return Object.defineProperty(e.prototype,"height",{get:function(){return this.$$height},set:function(e){e!==this.$$height&&(this.grid.updateCanvasHeight(),this.$$height=e)}}),e.prototype.getQualifiedColField=function(e){return"row."+this.getEntityQualifiedColField(e)},e.prototype.getEntityQualifiedColField=function(e){return e.field===r.ENTITY_BINDING?"entity":i.preEval("entity."+e.field)},e.prototype.setRowInvisible=function(e){e&&e.setThisRowInvisible&&e.setThisRowInvisible("user")},e.prototype.clearRowInvisible=function(e){e&&e.clearThisRowInvisible&&e.clearThisRowInvisible("user")},e.prototype.setThisRowInvisible=function(e,r){this.invisibleReason||(this.invisibleReason={}),this.invisibleReason[e]=!0,this.evaluateRowVisibility(r)},e.prototype.clearThisRowInvisible=function(e,r){void 0!==this.invisibleReason&&delete this.invisibleReason[e],this.evaluateRowVisibility(r)},e.prototype.evaluateRowVisibility=function(e){var t=!0;void 0!==this.invisibleReason&&angular.forEach(this.invisibleReason,function(e,r){e&&(t=!1)}),void 0!==this.visible&&this.visible===t||(this.visible=t,e||(this.grid.queueGridRefresh(),this.grid.api.core.raise.rowsVisibleChanged(this)))},e}]),function(){"use strict";angular.module("ui.grid").factory("GridRowColumn",["$parse","$filter",function(e,r){var t=function e(r,t){if(!(this instanceof e))throw"Using GridRowColumn as a function insead of as a constructor. Must be called with `new` keyword";this.row=r,this.col=t};return t.prototype.getIntersectionValueRaw=function(){return e(this.row.getEntityQualifiedColField(this.col))(this.row)},t}])}(),angular.module("ui.grid").factory("ScrollEvent",["gridUtil",function(l){function e(e,r,t,i){var n=this;if(!e)throw new Error("grid argument is required");n.grid=e,n.source=i,n.withDelay=!0,n.sourceRowContainer=r,n.sourceColContainer=t,n.newScrollLeft=null,n.newScrollTop=null,n.x=null,n.y=null,n.verticalScrollLength=-9999999,n.horizontalScrollLength=-999999,n.fireThrottledScrollingEvent=l.throttle(function(e){n.grid.scrollContainers(e,n)},n.grid.options.wheelScrollThrottle,{trailing:!0})}return e.prototype.getNewScrollLeft=function(e,r){var t=this;if(!t.newScrollLeft){var i,n=e.getCanvasWidth()-e.getViewportWidth(),o=l.normalizeScrollLeft(r,t.grid);if(void 0!==t.x.percentage&&void 0!==t.x.percentage)i=t.x.percentage;else{if(void 0===t.x.pixels||void 0===t.x.pixels)throw new Error("No percentage or pixel value provided for scroll event X axis");i=t.x.percentage=(o+t.x.pixels)/n}return Math.max(0,i*n)}return t.newScrollLeft},e.prototype.getNewScrollTop=function(e,r){var t=this;if(!t.newScrollTop){var i,n=e.getVerticalScrollLength(),o=r[0].scrollTop;if(void 0!==t.y.percentage&&void 0!==t.y.percentage)i=t.y.percentage;else{if(void 0===t.y.pixels||void 0===t.y.pixels)throw new Error("No percentage or pixel value provided for scroll event Y axis");i=t.y.percentage=(o+t.y.pixels)/n}return Math.max(0,i*n)}return t.newScrollTop},e.prototype.atTop=function(e){return this.y&&(0===this.y.percentage||this.verticalScrollLength<0)&&0===e},e.prototype.atBottom=function(e){return this.y&&(1===this.y.percentage||0===this.verticalScrollLength)&&0<e},e.prototype.atLeft=function(e){return this.x&&(0===this.x.percentage||this.horizontalScrollLength<0)&&0===e},e.prototype.atRight=function(e){return this.x&&(1===this.x.percentage||0===this.horizontalScrollLength)&&0<e},e.Sources={ViewPortScroll:"ViewPortScroll",RenderContainerMouseWheel:"RenderContainerMouseWheel",RenderContainerTouchMove:"RenderContainerTouchMove",Other:99},e}]),function(){"use strict";angular.module("ui.grid").service("gridClassFactory",["gridUtil","$q","$compile","$templateCache","uiGridConstants","Grid","GridColumn","GridRow",function(d,i,n,e,c,o,r,t){var l={createGrid:function(e){(e=void 0!==e?e:{}).id=d.newId();var r=new o(e);if(r.options.rowTemplate){var t=i.defer();r.getRowTemplateFn=t.promise,d.getTemplate(r.options.rowTemplate).then(function(e){var r=n(e);t.resolve(r)},function(e){throw new Error("Couldn't fetch/use row template '"+r.options.rowTemplate+"'")}).catch(angular.noop)}return r.registerColumnBuilder(l.defaultColumnBuilder),r.registerRowBuilder(l.rowTemplateAssigner),r.registerRowsProcessor(function(e){return e.forEach(function(e){e.evaluateRowVisibility(!0)}),e},50),r.registerColumnsProcessor(function(e){return e.forEach(function(e){e.visible=!angular.isDefined(e.colDef.visible)||e.colDef.visible}),e},50),r.registerRowsProcessor(r.searchRows,100),r.options.externalSort&&angular.isFunction(r.options.externalSort)?r.registerRowsProcessor(r.options.externalSort,200):r.registerRowsProcessor(r.sortByColumn,200),r},defaultColumnBuilder:function(l,a,e){var s=[],r=function(t,e,r,i,n){l[t]?a[e]=l[t]:a[e]=r;var o=d.getTemplate(a[e]).then(function(e){angular.isFunction(e)&&(e=e());var r="cellTooltip"===n?"col.cellTooltip(row,col)":"col.headerTooltip(col)";n&&!1===a[n]?e=e.replace(c.TOOLTIP,""):n&&a[n]&&(e=e.replace(c.TOOLTIP,'title="{{'+r+' CUSTOM_FILTERS }}"')),a[t]=i?e.replace(c.CUSTOM_FILTERS,function(){return a[i]?"|"+a[i]:""}):e},function(e){throw new Error("Couldn't fetch/use colDef."+t+" '"+l[t]+"'")}).catch(angular.noop);return s.push(o),o};return a.cellTemplatePromise=r("cellTemplate","providedCellTemplate","ui-grid/uiGridCell","cellFilter","cellTooltip"),a.headerCellTemplatePromise=r("headerCellTemplate","providedHeaderCellTemplate","ui-grid/uiGridHeaderCell","headerCellFilter","headerTooltip"),a.footerCellTemplatePromise=r("footerCellTemplate","providedFooterCellTemplate","ui-grid/uiGridFooterCell","footerCellFilter"),a.filterHeaderTemplatePromise=r("filterHeaderTemplate","providedFilterHeaderTemplate","ui-grid/ui-grid-filter"),a.compiledElementFnDefer=i.defer(),i.all(s)},rowTemplateAssigner:function(r){if(r.rowTemplate){var t=i.defer();r.getRowTemplateFn=t.promise,d.getTemplate(r.rowTemplate).then(function(e){var r=n(e);t.resolve(r)},function(e){throw new Error("Couldn't fetch/use row template '"+r.rowTemplate+"'")})}else r.rowTemplate=this.options.rowTemplate,r.getRowTemplateFn=this.getRowTemplateFn;return r.getRowTemplateFn}};return l}])}(),angular.module("ui.grid").service("rowSearcher",["gridUtil","uiGridConstants",function(u,s){var n=s.filter.CONTAINS,g={getTerm:function(e){if(void 0===e.term)return e.term;var r=e.term;return"string"==typeof r&&(r=r.trim()),r},stripTerm:function(e){var r=g.getTerm(e);return"string"==typeof r?r.replace(/(^\*|\*$)/g,"").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"):r},guessCondition:function(e){if(void 0===e.term||!e.term)return n;var r=g.getTerm(e);if(/\*/.test(r)){var t="";e.flags&&e.flags.caseSensitive||(t+="i");var i=r.replace(/(\\)?\*/g,function(e,r){return r?e:"[\\s\\S]*?"});return new RegExp("^"+i+"$",t)}return n},setupFilters:function(e){for(var r=[],t=e.length,i=0;i<t;i++){var n=e[i];if(n.noTerm||!u.isNullOrUndefined(n.term)){var o={},l="";n.flags&&n.flags.caseSensitive||(l+="i"),u.isNullOrUndefined(n.term)||(n.rawTerm?o.term=n.term:o.term=g.stripTerm(n)),o.noTerm=n.noTerm,n.condition?o.condition=n.condition:o.condition=g.guessCondition(n),o.flags=angular.extend({caseSensitive:!1,date:!1},n.flags),o.condition===s.filter.STARTS_WITH&&(o.startswithRE=new RegExp("^"+o.term,l)),o.condition===s.filter.ENDS_WITH&&(o.endswithRE=new RegExp(o.term+"$",l)),o.condition===s.filter.CONTAINS&&(o.containsRE=new RegExp(o.term,l)),o.condition===s.filter.EXACT&&(o.exactRE=new RegExp("^"+o.term+"$",l)),r.push(o)}}return r},runColumnFilter:function(e,r,t,i){var n,o=typeof i.condition,l=i.term;if(n=t.filterCellFiltered?e.getCellDisplayValue(r,t):e.getCellValue(r,t),i.condition instanceof RegExp)return i.condition.test(n);if("function"===o)return i.condition(l,n,r,t);if(i.startswithRE)return i.startswithRE.test(n);if(i.endswithRE)return i.endswithRE.test(n);if(i.containsRE)return i.containsRE.test(n);if(i.exactRE)return i.exactRE.test(n);if(i.condition===s.filter.NOT_EQUAL)return!new RegExp("^"+l+"$").exec(n);if("number"==typeof n&&"string"==typeof l){var a=parseFloat(l.replace(/\\\./,".").replace(/\\\-/,"-"));isNaN(a)||(l=a)}return!0===i.flags.date&&(n=new Date(n),l=new Date(l.replace(/\\/g,""))),i.condition===s.filter.GREATER_THAN?l<n:i.condition===s.filter.GREATER_THAN_OR_EQUAL?l<=n:i.condition===s.filter.LESS_THAN?n<l:i.condition!==s.filter.LESS_THAN_OR_EQUAL||n<=l},searchColumn:function(e,r,t,i){if(e.options.useExternalFiltering)return!0;for(var n=i.length,o=0;o<n;o++){var l=i[o];if((!u.isNullOrUndefined(l.term)&&""!==l.term||l.noTerm)&&!g.runColumnFilter(e,r,t,l))return!1}return!0},search:function(e,s,r){if(s){if(!e.options.enableFiltering)return s;for(var t=[],i=r.length,n=function(e){var r=!1;return e.forEach(function(e){(!u.isNullOrUndefined(e.term)&&""!==e.term||e.noTerm)&&(r=!0)}),r},o=0;o<i;o++){var l=r[o];void 0!==l.filters&&n(l.filters)&&t.push({col:l,filters:g.setupFilters(l.filters)})}if(0<t.length){for(var a=function(e,r){for(var t,i,n,o,l=s.length,a=0;a<l;a++)t=e,i=s[a],n=r.col,o=r.filters,i.visible&&!g.searchColumn(t,i,n,o)&&(i.visible=!1)},d=t.length,c=0;c<d;c++)a(e,t[c]);e.api.core.raise.rowsVisibleChanged&&e.api.core.raise.rowsVisibleChanged()}return s}}};return g}]),angular.module("ui.grid").service("rowSorter",["$parse","uiGridConstants",function(e,g){var r="("+g.CURRENCY_SYMBOLS.map(function(e){return"\\"+e}).join("|")+")?",h=(new RegExp("^[-+]?"+r+"[\\d,.]+"+r+"%?$"),{colSortFnCache:{},guessSortFn:function(e){switch(e){case"number":return h.sortNumber;case"numberStr":return h.sortNumberStr;case"boolean":return h.sortBool;case"string":return h.sortAlpha;case"date":return h.sortDate;case"object":return h.basicSort;default:throw new Error("No sorting function found for type:"+e)}},handleNulls:function(e,r){if(!e&&0!==e&&!1!==e||!r&&0!==r&&!1!==r){if(!e&&0!==e&&!1!==e&&!r&&0!==r&&!1!==r)return 0;if(!e&&0!==e&&!1!==e)return 1;if(!r&&0!==r&&!1!==r)return-1}return null},basicSort:function(e,r){var t=h.handleNulls(e,r);return null!==t?t:e===r?0:e<r?-1:1},sortNumber:function(e,r){var t=h.handleNulls(e,r);return null!==t?t:e-r},sortNumberStr:function(e,r){var t=h.handleNulls(e,r);if(null!==t)return t;var i,n,o=!1,l=!1;return i=parseFloat(e.replace(/[^0-9.-]/g,"")),isNaN(i)&&(o=!0),n=parseFloat(r.replace(/[^0-9.-]/g,"")),isNaN(n)&&(l=!0),o&&l?0:o?1:l?-1:i-n},sortAlpha:function(e,r){var t=h.handleNulls(e,r);if(null!==t)return t;var i=e.toString().toLowerCase(),n=r.toString().toLowerCase();return i===n?0:i.localeCompare(n)},sortDate:function(e,r){var t=h.handleNulls(e,r);if(null!==t)return t;e instanceof Date||(e=new Date(e)),r instanceof Date||(r=new Date(r));var i=e.getTime(),n=r.getTime();return i===n?0:i<n?-1:1},sortBool:function(e,r){var t=h.handleNulls(e,r);return null!==t?t:e&&r?0:e||r?e?1:-1:0},getSortFn:function(e,r,t){var i;return h.colSortFnCache[r.colDef.name]?i=h.colSortFnCache[r.colDef.name]:void 0!==r.sortingAlgorithm?(i=r.sortingAlgorithm,h.colSortFnCache[r.colDef.name]=r.sortingAlgorithm):r.sortCellFiltered&&r.cellFilter?(i=h.sortAlpha,h.colSortFnCache[r.colDef.name]=i):(i=h.guessSortFn(r.colDef.type))?h.colSortFnCache[r.colDef.name]=i:i=h.sortAlpha,i},prioritySort:function(e,r){return void 0!==e.sort.priority&&void 0!==r.sort.priority?e.sort.priority<r.sort.priority?-1:e.sort.priority===r.sort.priority?0:1:void 0!==e.sort.priority?-1:void 0!==r.sort.priority?1:0},sort:function(a,e,r){if(e){if(a.options.useExternalSorting)return e;var s,d,c=[],t=[];if(r.forEach(function(e){!e.sort||e.sort.ignoreSort||!e.sort.direction||e.sort.direction!==g.ASC&&e.sort.direction!==g.DESC?e.defaultSort&&e.defaultSort.direction&&(e.defaultSort.direction===g.ASC||e.defaultSort.direction===g.DESC)&&t.push({col:e,sort:e.defaultSort}):c.push({col:e,sort:e.sort})}),c=c.sort(h.prioritySort),t=t.sort(h.prioritySort),0===(c=c.concat(t)).length)return e;e.forEach(function(e,r){e.entity.$$uiGridIndex=r});var u=e.slice(0),i=e.sort(function(e,r){for(var t,i=0,n=0;0===i&&n<c.length;){var o,l;s=c[n].col,d=c[n].sort.direction,t=h.getSortFn(a,s,u),s.sortCellFiltered?(o=a.getCellDisplayValue(e,s),l=a.getCellDisplayValue(r,s)):(o=a.getCellValue(e,s),l=a.getCellValue(r,s)),i=t(o,l,e,r,d,s),n++}return 0===i?e.entity.$$uiGridIndex-r.entity.$$uiGridIndex:d===g.ASC?i:0-i});return e.forEach(function(e,r){delete e.entity.$$uiGridIndex}),i}}});return h}]),function(){var C,e=angular.module("ui.grid");function w(e){var r=e;return void 0!==r.length&&r.length&&(r=e[0]),r.ownerDocument.defaultView.getComputedStyle(r,null)}"function"!=typeof Function.prototype.bind&&(C=function(){var i=Array.prototype.slice;return function(e){var r=this,t=i.call(arguments,1);return t.length?function(){return arguments.length?r.apply(e,t.concat(i.call(arguments))):r.apply(e,t)}:function(){return arguments.length?r.apply(e,arguments):r.call(e)}}});var a=new RegExp("^("+/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source+")(?!px)[a-z%]+$","i"),y=/^(block|none|table(?!-c[ea]).+)/,b={position:"absolute",visibility:"hidden",display:"block"};function S(e,r,t,i,n){for(var o=t===(i?"border":"content")?4:"width"===r?1:0,l=0,a=["Top","Right","Bottom","Left"];o<4;o+=2){var s=a[o];if("margin"===t){var d=parseFloat(n[t+s]);isNaN(d)||(l+=d)}if(i){if("content"===t){var c=parseFloat(n["padding"+s]);isNaN(c)||(l-=c)}if("margin"!==t){var u=parseFloat(n["border"+s+"Width"]);isNaN(u)||(l-=u)}}else{var g=parseFloat(n["padding"+s]);if(isNaN(g)||(l+=g),"padding"!==t){var h=parseFloat(n["border"+s+"Width"]);isNaN(h)||(l+=h)}}}return l}function E(e,r,t){var i,n=!0,o=w(e),l="border-box"===o.boxSizing;if(i<=0||null==i){if(((i=o[r])<0||null==i)&&(i=e.style[r]),a.test(i))return i;n=l&&!0,i=parseFloat(i)||0}return i+S(0,r,t||(l?"border":"content"),n,o)}var T=["0","0","0","0"],R="uiGrid-";e.service("gridUtil",["$log","$window","$document","$http","$templateCache","$timeout","$interval","$injector","$q","$interpolate","uiGridConstants",function(r,n,t,e,i,s,d,o,l,a,c){var u,g={augmentWidthOrHeight:S,getStyles:w,createBoundedWrapper:function(e,r){return function(){return r.apply(e,arguments)}},readableColumnName:function(e){return void 0===e||null==e?e:("string"!=typeof e&&(e=String(e)),e.replace(/_+/g," ").replace(/^[A-Z]+$/,function(e){return angular.lowercase(angular.uppercase(e.charAt(0))+e.slice(1))}).replace(/([\w\u00C0-\u017F]+)/g,function(e){return angular.uppercase(e.charAt(0))+e.slice(1)}).replace(/(\w+?(?=[A-Z]))/g,"$1 "))},getColumnsFromData:function(e,t){var i=[];if(!e||void 0===e[0]||void 0===e[0])return[];angular.isUndefined(t)&&(t=[]);var r=e[0];return angular.forEach(r,function(e,r){-1===t.indexOf(r)&&i.push({name:r})}),i},newId:(u=(new Date).getTime(),function(){return u+=1}),getTemplate:function(t){if(i.get(t))return g.postProcessTemplate(i.get(t));if(angular.isFunction(t.then))return t.then(g.postProcessTemplate).catch(angular.noop);try{if(0<angular.element(t).length)return l.when(t).then(g.postProcessTemplate).catch(angular.noop)}catch(e){}return e({method:"GET",url:t}).then(function(e){var r=e.data.trim();return i.put(t,r),r},function(e){throw new Error("Could not get template "+t+": "+e)}).then(g.postProcessTemplate).catch(angular.noop)},postProcessTemplate:function(e){var r=a.startSymbol(),t=a.endSymbol();return"{{"===r&&"}}"===t||(e=(e=e.replace(/\{\{/g,r)).replace(/\}\}/g,t)),l.when(e)},guessType:function(e){var r=typeof e;switch(r){case"number":case"boolean":case"string":return r;default:return angular.isDate(e)?"date":"object"}},elementWidth:function(e){},elementHeight:function(e){},getScrollbarWidth:function(){var e=document.createElement("div");e.style.visibility="hidden",e.style.width="100px",e.style.msOverflowStyle="scrollbar",document.body.appendChild(e);var r=e.offsetWidth;e.style.overflow="scroll";var t=document.createElement("div");t.style.width="100%",e.appendChild(t);var i=t.offsetWidth;return e.parentNode.removeChild(e),r-i},swap:function(e,r,t,i){var n,o,l={};for(o in r)l[o]=e.style[o],e.style[o]=r[o];for(o in n=t.apply(e,i||[]),r)e.style[o]=l[o];return n},fakeElement:function(e,r,t,i){var n,o,l=angular.element(e).clone()[0];for(o in r)l.style[o]=r[o];return angular.element(document.body).append(l),n=t.call(l,l),angular.element(l).remove(),n},normalizeWheelEvent:function(e){var r,t,i,n,o,l=e||window.event,a=([].slice.call(arguments,1),0),s=0,d=0;return l.originalEvent&&(l=l.originalEvent),l.wheelDelta&&(a=l.wheelDelta),l.detail&&(a=-1*l.detail),d=a,void 0!==l.axis&&l.axis===l.HORIZONTAL_AXIS&&(d=0,s=-1*a),l.deltaY&&(a=d=-1*l.deltaY),l.deltaX&&(a=-1*(s=l.deltaX)),void 0!==l.wheelDeltaY&&(d=l.wheelDeltaY),void 0!==l.wheelDeltaX&&(s=l.wheelDeltaX),i=Math.abs(a),(!r||i<r)&&(r=i),n=Math.max(Math.abs(d),Math.abs(s)),(!t||n<t)&&(t=n),o=0<a?"floor":"ceil",{delta:a=Math[o](a/r),deltaX:s=Math[o](s/t),deltaY:d=Math[o](d/t)}},isTouchEnabled:function(){var e;return("ontouchstart"in n||n.DocumentTouch&&t instanceof DocumentTouch)&&(e=!0),e},isNullOrUndefined:function(e){return null==e},endsWith:function(e,r){return!(!e||!r||"string"!=typeof e)&&-1!==e.indexOf(r,e.length-r.length)},arrayContainsObjectWithProperty:function(e,r,t){var i=!1;return angular.forEach(e,function(e){e[r]===t&&(i=!0)}),i},numericAndNullSort:function(e,r){return null===e?1:null===r?-1:null===e&&null===r?0:e-r},disableAnimations:function(e){var r;try{r=o.get("$animate"),1<angular.version.major||1===angular.version.major&&4<=angular.version.minor?r.enabled(e,!1):r.enabled(!1,e)}catch(e){}},enableAnimations:function(e){var r;try{return r=o.get("$animate"),1<angular.version.major||1===angular.version.major&&4<=angular.version.minor?r.enabled(e,!0):r.enabled(!0,e),r}catch(e){}},nextUid:function(){for(var e,r=T.length;r;){if(57===(e=T[--r].charCodeAt(0)))return T[r]="A",R+T.join("");if(90!==e)return T[r]=String.fromCharCode(e+1),R+T.join("");T[r]="0"}return T.unshift("0"),R+T.join("")},hashKey:function(e){var r,t=typeof e;return"object"===t&&null!==e?"function"==typeof(r=e.$$hashKey)?r=e.$$hashKey():void 0!==e.$$hashKey&&e.$$hashKey?r=e.$$hashKey:void 0===r&&(r=e.$$hashKey=g.nextUid()):r=e,t+":"+r},resetUids:function(){T=["0","0","0"]},logError:function(e){c.LOG_ERROR_MESSAGES&&r.error(e)},logWarn:function(e){c.LOG_WARN_MESSAGES&&r.warn(e)},logDebug:function(){c.LOG_DEBUG_MESSAGES&&r.debug.apply(r,arguments)}};g.focus={queue:[],byId:function(t,i){this._purgeQueue();var e=s(function(){var e=(i&&i.id?i.id+"-":"")+t,r=n.document.getElementById(e);r?r.focus():g.logWarn("[focus.byId] Element id "+e+" was not found.")},0,!1);return this.queue.push(e),e},byElement:function(e){if(!angular.isElement(e))return g.logWarn("Trying to focus on an element that isn't an element."),l.reject("not-element");e=angular.element(e),this._purgeQueue();var r=s(function(){e&&e[0].focus()},0,!1);return this.queue.push(r),r},bySelector:function(r,t,e){var i=this;if(!angular.isElement(r))throw new Error("The parent element is not an element.");r=angular.element(r);var n=function(){var e=r[0].querySelector(t);return i.byElement(e)};if(this._purgeQueue(),e){var o=s(n,0,!1);return this.queue.push(o),o}return n()},_purgeQueue:function(){this.queue.forEach(function(e){s.cancel(e)}),this.queue=[]}},["width","height"].forEach(function(n){var t=angular.uppercase(n.charAt(0))+n.substr(1);g["element"+t]=function(e,r){var t=e;if(t&&void 0!==t.length&&t.length&&(t=e[0]),t&&null!==t){var i=w(t);return 0===t.offsetWidth&&y.test(i.display)?g.swap(t,b,function(){return E(t,n,r)}):E(t,n,r)}return null},g["outerElement"+t]=function(e,r){return e?g["element"+t].call(this,e,r?"margin":"border"):null}}),g.closestElm=function(e,r){var t,i;for(void 0!==e.length&&e.length&&(e=e[0]),["matches","webkitMatchesSelector","mozMatchesSelector","msMatchesSelector","oMatchesSelector"].some(function(e){return"function"==typeof document.body[e]&&(t=e,!0)});null!==e;){if(null!==(i=e.parentElement)&&i[t](r))return i;e=i}return null},g.type=function(e){return Function.prototype.toString.call(e.constructor).match(/function (.*?)\(/)[1]},g.getBorderSize=function(e,r){void 0!==e.length&&e.length&&(e=e[0]);var t=w(e);r=r?"border"+r.charAt(0).toUpperCase()+r.slice(1):"border",r+="Width";var i=parseInt(t[r],10);return isNaN(i)?0:i},g.detectBrowser=function(){var e=n.navigator.userAgent,r={chrome:/chrome/i,safari:/safari/i,firefox:/firefox/i,ie:/internet explorer|trident\//i};for(var t in r)if(r[t].test(e))return t;return"unknown"},g.rtlScrollType=function e(){if(e.type)return e.type;var r=angular.element('<div dir="rtl" style="font-size: 14px; width: 1px; height: 1px; position: absolute; top: -1000px; overflow: scroll">A</div>')[0],t="reverse";return document.body.appendChild(r),0<r.scrollLeft?t="default":(r.scrollLeft=1,0===r.scrollLeft&&(t="negative")),angular.element(r).remove(),e.type=t},g.normalizeScrollLeft=function(e,r){void 0!==e.length&&e.length&&(e=e[0]);var t=e.scrollLeft;if(r.isRTL())switch(g.rtlScrollType()){case"default":return e.scrollWidth-t-e.clientWidth;case"negative":return Math.abs(t);case"reverse":return t}return t},g.denormalizeScrollLeft=function(e,r,t){if(void 0!==e.length&&e.length&&(e=e[0]),t.isRTL())switch(g.rtlScrollType()){case"default":return e.scrollWidth-e.clientWidth-r;case"negative":return-1*r;case"reverse":return r}return r},g.preEval=function(e){var r=c.BRACKET_REGEXP.exec(e);if(r)return(r[1]?g.preEval(r[1]):r[1])+r[2]+(r[3]?g.preEval(r[3]):r[3]);var t=(e=e.replace(c.APOS_REGEXP,"\\'")).split(c.DOT_REGEXP),i=[t.shift()];return angular.forEach(t,function(e){i.push(e.replace(c.FUNC_REGEXP,"']$1"))}),i.join("['")},g.debounce=function(r,t,i){var n,o,l,a;function e(){l=this,o=arguments;var e=i&&!n;return n&&s.cancel(n),n=s(function(){n=null,i||(a=r.apply(l,o))},t,!1),e&&(a=r.apply(l,o)),a}return e.cancel=function(){s.cancel(n),n=null},e},g.throttle=function(r,t,i){i=i||{};var n,o,l=0,a=null;function s(e){l=+new Date,r.apply(n,o),d(function(){a=null},0,1,!1)}return function(){if(n=this,o=arguments,null===a){var e=+new Date-l;t<e?s():i.trailing&&(a=d(s,t-e,1,!1))}}},g.on={},g.off={},g._events={},g.addOff=function(i){g.off[i]=function(e,r){var t=g._events[i].indexOf(r);0<t&&g._events[i].removeAt(t)}};var h,p,f="onwheel"in document||9<=document.documentMode?["wheel"]:["mousewheel","DomMouseScroll","MozMousePixelScroll"];function m(e,r){var t,i=angular.element(this),n=0,o=0,l=0;if(r.originalEvent&&(r=r.originalEvent),"detail"in r&&(l=-1*r.detail),"wheelDelta"in r&&(l=r.wheelDelta),"wheelDeltaY"in r&&(l=r.wheelDeltaY),"wheelDeltaX"in r&&(o=-1*r.wheelDeltaX),"axis"in r&&r.axis===r.HORIZONTAL_AXIS&&(o=-1*l,l=0),n=0===l?o:l,"deltaY"in r&&(n=l=-1*r.deltaY),"deltaX"in r&&(o=r.deltaX,0===l&&(n=-1*o)),0!==l||0!==o){if(1===r.deltaMode){var a=i.data("mousewheel-line-height");n*=a,l*=a,o*=a}else if(2===r.deltaMode){var s=i.data("mousewheel-page-height");n*=s,l*=s,o*=s}var d;t=Math.max(Math.abs(l),Math.abs(o)),(!p||t<p)&&(d=p=t,"mousewheel"===r.type&&d%120==0&&(p/=40)),n=Math[1<=n?"floor":"ceil"](n/p),o=Math[1<=o?"floor":"ceil"](o/p),l=Math[1<=l?"floor":"ceil"](l/p);var c={originalEvent:r,deltaX:o,deltaY:l,deltaFactor:p,preventDefault:function(){r.preventDefault()},stopPropagation:function(){r.stopPropagation()}};h&&clearTimeout(h),h=setTimeout(v,200),e.call(i[0],c)}}function v(){p=null}return g.on.mousewheel=function(e,r){if(e&&r){var t,i,n=angular.element(e);n.data("mousewheel-line-height",(t=n,(i=(t=angular.element(t)[0]).parentElement)||(i=document.getElementsByTagName("body")[0]),parseInt(w(i).fontSize)||parseInt(w(t).fontSize)||16)),n.data("mousewheel-page-height",g.elementHeight(n)),n.data("mousewheel-callbacks")||n.data("mousewheel-callbacks",{});var o=n.data("mousewheel-callbacks");o[r]=(Function.prototype.bind||C).call(m,n[0],r);for(var l=f.length;l;)n.on(f[--l],o[r]);n.on("$destroy",function(){for(var e=f.length;e;)n.off(f[--e],o[r])})}},g.off.mousewheel=function(e,r){var t=angular.element(e),i=t.data("mousewheel-callbacks"),n=i[r];if(n)for(var o=f.length;o;)t.off(f[--o],n);delete i[r],0===Object.keys(i).length&&(t.removeData("mousewheel-line-height"),t.removeData("mousewheel-page-height"),t.removeData("mousewheel-callbacks"))},g}]),e.filter("px",function(){return function(e){return e.match(/^[\d\.]+$/)?e+"px":e}})}(),function(){var p=["uiT","uiTranslate"],r=angular.module("ui.grid.i18n");r.constant("i18nConstants",{MISSING:"[MISSING]",UPDATE_EVENT:"$uiI18n",LOCALE_DIRECTIVE_ALIAS:"uiI18n",DEFAULT_LANG:"en"}),r.service("i18nService",["$log","i18nConstants","$rootScope",function(e,a,r){var s={_langs:{},current:null,get:function(e){return this._langs[e.toLowerCase()]},add:function(e,r){var t=e.toLowerCase();this._langs[t]||(this._langs[t]={}),angular.merge(this._langs[t],r)},getAllLangs:function(){var e=[];if(!this._langs)return e;for(var r in this._langs)e.push(r);return e},setCurrent:function(e){this.current=e.toLowerCase()},getCurrentLang:function(){return this.current}},d={add:function(e,r){"object"==typeof e?angular.forEach(e,function(e){e&&s.add(e,r)}):s.add(e,r)},getAllLangs:function(){return s.getAllLangs()},get:function(e){var r=e||d.getCurrentLang();return s.get(r)},getSafeText:function(e,r){var t=r||d.getCurrentLang(),i=s.get(t);if(!i)return a.MISSING;for(var n=e.split("."),o=i,l=0;l<n.length;++l){if(void 0===o[n[l]]||null===o[n[l]])return a.MISSING;o=o[n[l]]}return o},setCurrentLang:function(e){e&&(s.setCurrent(e),r.$broadcast(a.UPDATE_EVENT))},getCurrentLang:function(){var e=s.getCurrentLang();return e||(e=a.DEFAULT_LANG,s.setCurrent(e)),e}};return d}]);r.directive("uiI18n",["i18nService","i18nConstants",function(o,l){return{compile:function(){return{pre:function(e,r,t){var i=l.LOCALE_DIRECTIVE_ALIAS,n=e.$eval(t[i]);n?e.$watch(t[i],function(){o.setCurrentLang(n)}):t.$$observers&&t.$observe(i,function(){o.setCurrentLang(t[i]||l.DEFAULT_LANG)})}}}}}]);var t=function(u,g,h){return{restrict:"EA",compile:function(){return{pre:function(e,r,t){var i,n=p[0],o=p[1],l=t[n]||t[o]||r.html(),a=h.MISSING+l;if(t.$$observers){var s=t[n]?n:o;i=t.$observe(s,function(e){e&&r.html(u(e)(g.getCurrentLang())||a)})}var d=u(l),c=e.$on(h.UPDATE_EVENT,function(e){i?i(t[n]||t[o]):r.html(d(g.get())||a)});e.$on("$destroy",c),r.html(d(g.get())||a)}}}}};angular.forEach(p,function(e){r.directive(e,["$parse","i18nService","i18nConstants",t])});var i=function(r,t,i){return function(e){return r(e)(t.get())||i.MISSING+e}};angular.forEach(["t","uiTranslate"],function(e){r.filter(e,["$parse","i18nService","i18nConstants",i])})}(),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("en",{headerCell:{aria:{defaultFilterLabel:"Filter for column",removeFilter:"Remove Filter",columnMenuButtonLabel:"Column Menu",column:"Column"},priority:"Priority:",filterLabel:"Filter for column: "},aggregate:{label:"items"},groupPanel:{description:"Drag a column header here and drop it to group by that column."},search:{aria:{selected:"Row selected",notSelected:"Row not selected"},placeholder:"Search...",showingItems:"Showing Items:",selectedItems:"Selected Items:",totalItems:"Total Items:",size:"Page Size:",first:"First Page",next:"Next Page",previous:"Previous Page",last:"Last Page"},menu:{text:"Choose Columns:"},sort:{ascending:"Sort Ascending",descending:"Sort Descending",none:"Sort None",remove:"Remove Sort"},column:{hide:"Hide Column"},aggregation:{count:"total rows: ",sum:"total: ",avg:"avg: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Pin Left",pinRight:"Pin Right",unpin:"Unpin"},columnMenu:{close:"Close"},gridMenu:{aria:{buttonLabel:"Grid Menu"},columns:"Columns:",importerTitle:"Import file",exporterAllAsCsv:"Export all data as csv",exporterVisibleAsCsv:"Export visible data as csv",exporterSelectedAsCsv:"Export selected data as csv",exporterAllAsPdf:"Export all data as pdf",exporterVisibleAsPdf:"Export visible data as pdf",exporterSelectedAsPdf:"Export selected data as pdf",exporterAllAsExcel:"Export all data as excel",exporterVisibleAsExcel:"Export visible data as excel",exporterSelectedAsExcel:"Export selected data as excel",clearAllFilters:"Clear all filters"},importer:{noHeaders:"Column names were unable to be derived, does the file have a header?",noObjects:"Objects were not able to be derived, was there data in the file other than headers?",invalidCsv:"File was unable to be processed, is it valid CSV?",invalidJson:"File was unable to be processed, is it valid Json?",jsonNotArray:"Imported json file must contain an array, aborting."},pagination:{aria:{pageToFirst:"Page to first",pageBack:"Page back",pageSelected:"Selected page",pageForward:"Page forward",pageToLast:"Page to last"},sizes:"items per page",totalItems:"items",through:"through",of:"of"},grouping:{group:"Group",ungroup:"Ungroup",aggregate_count:"Agg: Count",aggregate_sum:"Agg: Sum",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Avg",aggregate_remove:"Agg: Remove"},validate:{error:"Error:",minLength:"Value should be at least THRESHOLD characters long.",maxLength:"Value should be at most THRESHOLD characters long.",required:"A value is needed."}}),e}])}]),angular.module("ui.grid").run(["$templateCache",function(e){"use strict";e.put("ui-grid/ui-grid-filter",'<div class="ui-grid-filter-container" ng-style="col.extraStyle" ng-repeat="colFilter in col.filters" ng-class="{\'ui-grid-filter-cancel-button-hidden\' : colFilter.disableCancelFilterButton === true }"><div ng-if="colFilter.type !== \'select\'"><input type="text" class="ui-grid-filter-input ui-grid-filter-input-{{$index}}" ng-model="colFilter.term" ng-attr-placeholder="{{colFilter.placeholder || \'\'}}" aria-label="{{colFilter.ariaLabel || aria.defaultFilterLabel}}"><div role="button" class="ui-grid-filter-button" ng-click="removeFilter(colFilter, $index)" ng-if="!colFilter.disableCancelFilterButton" ng-disabled="colFilter.term === undefined || colFilter.term === null || colFilter.term === \'\'" ng-show="colFilter.term !== undefined && colFilter.term !== null && colFilter.term !== \'\'"><i class="ui-grid-icon-cancel" ui-grid-one-bind-aria-label="aria.removeFilter">&nbsp;</i></div></div><div ng-if="colFilter.type === \'select\'"><select class="ui-grid-filter-select ui-grid-filter-input-{{$index}}" ng-model="colFilter.term" ng-show="colFilter.selectOptions.length > 0" ng-attr-placeholder="{{colFilter.placeholder || aria.defaultFilterLabel}}" aria-label="{{colFilter.ariaLabel || \'\'}}" ng-options="option.value as option.label for option in colFilter.selectOptions"><option value=""></option></select><div role="button" class="ui-grid-filter-button-select" ng-click="removeFilter(colFilter, $index)" ng-if="!colFilter.disableCancelFilterButton" ng-disabled="colFilter.term === undefined || colFilter.term === null || colFilter.term === \'\'" ng-show="colFilter.term !== undefined && colFilter.term != null"><i class="ui-grid-icon-cancel" ui-grid-one-bind-aria-label="aria.removeFilter">&nbsp;</i></div></div></div>'),e.put("ui-grid/ui-grid-footer",'<div class="ui-grid-footer-panel ui-grid-footer-aggregates-row">\x3c!-- tfooter --\x3e<div class="ui-grid-footer ui-grid-footer-viewport"><div class="ui-grid-footer-canvas"><div class="ui-grid-footer-cell-wrapper" ng-style="colContainer.headerCellWrapperStyle()"><div role="row" class="ui-grid-footer-cell-row"><div ui-grid-footer-cell role="gridcell" ng-repeat="col in colContainer.renderedColumns track by col.uid" col="col" render-index="$index" class="ui-grid-footer-cell ui-grid-clearfix"></div></div></div></div></div></div>'),e.put("ui-grid/ui-grid-grid-footer",'<div class="ui-grid-footer-info ui-grid-grid-footer"><span>{{\'search.totalItems\' | t}} {{grid.rows.length}}</span> <span ng-if="grid.renderContainers.body.visibleRowCache.length !== grid.rows.length" class="ngLabel">({{"search.showingItems" | t}} {{grid.renderContainers.body.visibleRowCache.length}})</span></div>'),e.put("ui-grid/ui-grid-header",'<div role="rowgroup" class="ui-grid-header">\x3c!-- theader --\x3e<div class="ui-grid-top-panel"><div class="ui-grid-header-viewport"><div class="ui-grid-header-canvas"><div class="ui-grid-header-cell-wrapper" ng-style="colContainer.headerCellWrapperStyle()"><div role="row" class="ui-grid-header-cell-row"><div class="ui-grid-header-cell ui-grid-clearfix" ng-repeat="col in colContainer.renderedColumns track by col.uid" ui-grid-header-cell col="col" render-index="$index"></div></div></div></div></div></div></div>'),e.put("ui-grid/ui-grid-menu-button",'<div class="ui-grid-menu-button"><div role="button" ui-grid-one-bind-id-grid="\'grid-menu\'" class="ui-grid-icon-container" ng-click="toggleMenu()" aria-haspopup="true"><i class="ui-grid-icon-menu" ui-grid-one-bind-aria-label="i18n.aria.buttonLabel">&nbsp;</i></div><div ui-grid-menu menu-items="menuItems"></div></div>'),e.put("ui-grid/ui-grid-no-header",'<div class="ui-grid-top-panel"></div>'),e.put("ui-grid/ui-grid-row","<div ng-repeat=\"(colRenderIndex, col) in colContainer.renderedColumns track by col.uid\" ui-grid-one-bind-id-grid=\"rowRenderIndex + '-' + col.uid + '-cell'\" class=\"ui-grid-cell\" ng-class=\"{ 'ui-grid-row-header-cell': col.isRowHeader }\" role=\"{{col.isRowHeader ? 'rowheader' : 'gridcell'}}\" ui-grid-cell></div>"),e.put("ui-grid/ui-grid",'<div ui-i18n="en" class="ui-grid">\x3c!-- TODO (c0bra): add "scoped" attr here, eventually? --\x3e<style ui-grid-style>.grid{{ grid.id }} {\n      /* Styles for the grid */\n    }\n\n    .grid{{ grid.id }} .ui-grid-row, .grid{{ grid.id }} .ui-grid-cell, .grid{{ grid.id }} .ui-grid-cell .ui-grid-vertical-bar {\n      height: {{ grid.options.rowHeight }}px;\n    }\n\n    .grid{{ grid.id }} .ui-grid-row:last-child .ui-grid-cell {\n      border-bottom-width: {{ (((grid.getVisibleRowCount() * grid.options.rowHeight) < grid.getViewportHeight()) && \'1\') || \'0\' }}px;\n    }\n\n    {{ grid.verticalScrollbarStyles }}\n    {{ grid.horizontalScrollbarStyles }}\n\n    /*\n    .ui-grid[dir=rtl] .ui-grid-viewport {\n      padding-left: {{ grid.verticalScrollbarWidth }}px;\n    }\n    */\n\n    {{ grid.customStyles }}</style><div class="ui-grid-contents-wrapper" role="grid"><div ui-grid-menu-button ng-if="grid.options.enableGridMenu"></div><div ng-if="grid.hasLeftContainer()" style="width: 0" ui-grid-pinned-container="\'left\'"></div><div ui-grid-render-container container-id="\'body\'" col-container-name="\'body\'" row-container-name="\'body\'" bind-scroll-horizontal="true" bind-scroll-vertical="true" enable-horizontal-scrollbar="grid.options.enableHorizontalScrollbar" enable-vertical-scrollbar="grid.options.enableVerticalScrollbar"></div><div ng-if="grid.hasRightContainer()" style="width: 0" ui-grid-pinned-container="\'right\'"></div><div ui-grid-grid-footer ng-if="grid.options.showGridFooter"></div><div ui-grid-column-menu ng-if="grid.options.enableColumnMenus"></div><div ng-transclude></div></div></div>'),e.put("ui-grid/uiGridCell",'<div class="ui-grid-cell-contents" title="TOOLTIP">{{COL_FIELD CUSTOM_FILTERS}}</div>'),e.put("ui-grid/uiGridColumnMenu",'<div class="ui-grid-column-menu"><div ui-grid-menu menu-items="menuItems">\x3c!-- <div class="ui-grid-column-menu">\n    <div class="inner" ng-show="menuShown">\n      <ul>\n        <div ng-show="grid.options.enableSorting">\n          <li ng-click="sortColumn($event, asc)" ng-class="{ \'selected\' : col.sort.direction == asc }"><i class="ui-grid-icon-sort-alt-up"></i> Sort Ascending</li>\n          <li ng-click="sortColumn($event, desc)" ng-class="{ \'selected\' : col.sort.direction == desc }"><i class="ui-grid-icon-sort-alt-down"></i> Sort Descending</li>\n          <li ng-show="col.sort.direction" ng-click="unsortColumn()"><i class="ui-grid-icon-cancel"></i> Remove Sort</li>\n        </div>\n      </ul>\n    </div>\n  </div> --\x3e</div></div>'),e.put("ui-grid/uiGridFooterCell",'<div class="ui-grid-cell-contents" col-index="renderIndex"><div>{{ col.getAggregationText() + ( col.getAggregationValue() CUSTOM_FILTERS ) }}</div></div>'),e.put("ui-grid/uiGridHeaderCell",'<div role="columnheader" ng-class="{ \'sortable\': sortable, \'ui-grid-header-cell-last-col\': isLastCol }" ui-grid-one-bind-aria-labelledby-grid="col.uid + \'-header-text \' + col.uid + \'-sortdir-text\'" aria-sort="{{col.sort.direction == asc ? \'ascending\' : ( col.sort.direction == desc ? \'descending\' : (!col.sort.direction ? \'none\' : \'other\'))}}"><div role="button" tabindex="0" ng-keydown="handleKeyDown($event)" class="ui-grid-cell-contents ui-grid-header-cell-primary-focus" col-index="renderIndex" title="TOOLTIP"><span class="ui-grid-header-cell-label" ui-grid-one-bind-id-grid="col.uid + \'-header-text\'">{{ col.displayName CUSTOM_FILTERS }} </span><span ui-grid-one-bind-id-grid="col.uid + \'-sortdir-text\'" ui-grid-visible="col.sort.direction" aria-label="{{getSortDirectionAriaLabel()}}"><i ng-class="{ \'ui-grid-icon-up-dir\': col.sort.direction == asc, \'ui-grid-icon-down-dir\': col.sort.direction == desc, \'ui-grid-icon-blank\': !col.sort.direction }" title="{{isSortPriorityVisible() ? i18n.headerCell.priority + \' \' + ( col.sort.priority + 1 )  : null}}" aria-hidden="true"></i> <sub ui-grid-visible="isSortPriorityVisible()" class="ui-grid-sort-priority-number">{{col.sort.priority + 1}}</sub></span></div><div role="button" tabindex="0" ui-grid-one-bind-id-grid="col.uid + \'-menu-button\'" class="ui-grid-column-menu-button" ng-if="grid.options.enableColumnMenus && !col.isRowHeader  && col.colDef.enableColumnMenu !== false" ng-click="toggleMenu($event)" ng-keydown="headerCellArrowKeyDown($event)" ui-grid-one-bind-aria-label="i18n.headerCell.aria.columnMenuButtonLabel" aria-haspopup="true"><i class="ui-grid-icon-angle-down" aria-hidden="true">&nbsp;</i></div><div ui-grid-filter></div></div>'),e.put("ui-grid/uiGridMenu",'<div class="ui-grid-menu" ng-show="shown"><style ui-grid-style>{{dynamicStyles}}</style><div class="ui-grid-menu-mid" ng-show="shownMid"><div class="ui-grid-menu-inner" ng-if="shown"><ul role="menu" class="ui-grid-menu-items"><li ng-repeat="item in menuItems" role="menuitem" ui-grid-menu-item ui-grid-one-bind-id="\'menuitem-\'+$index" action="item.action" name="item.title" active="item.active" icon="item.icon" shown="item.shown" context="item.context" template-url="item.templateUrl" leave-open="item.leaveOpen" screen-reader-only="item.screenReaderOnly"></li></ul></div></div></div>'),e.put("ui-grid/uiGridMenuItem",'<button type="button" class="ui-grid-menu-item" ng-click="itemAction($event, title)" ng-show="itemShown()" ng-class="{ \'ui-grid-menu-item-active\': active(), \'ui-grid-sr-only\': (!focus && screenReaderOnly) }" aria-pressed="{{active()}}" tabindex="0" ng-focus="focus=true" ng-blur="focus=false"><i ng-class="icon" aria-hidden="true">&nbsp; </i>{{ label() }}</button>'),e.put("ui-grid/uiGridRenderContainer","<div role=\"presentation\" ui-grid-one-bind-id-grid=\"containerId + '-grid-container'\" class=\"ui-grid-render-container\" ng-style=\"{ 'margin-left': colContainer.getMargin('left') + 'px', 'margin-right': colContainer.getMargin('right') + 'px' }\">\x3c!-- All of these dom elements are replaced in place --\x3e<div ui-grid-header></div><div ui-grid-viewport></div><div ng-if=\"colContainer.needsHScrollbarPlaceholder()\" class=\"ui-grid-scrollbar-placeholder\" ng-style=\"{height:colContainer.grid.scrollbarHeight + 'px'}\"></div><ui-grid-footer ng-if=\"grid.options.showColumnFooter\"></ui-grid-footer></div>"),e.put("ui-grid/uiGridViewport",'<div role="rowgroup" class="ui-grid-viewport" ng-style="colContainer.getViewportStyle()">\x3c!-- tbody --\x3e<div class="ui-grid-canvas"><div ng-repeat="(rowRenderIndex, row) in rowContainer.renderedRows track by $index" class="ui-grid-row" ng-style="Viewport.rowStyle(rowRenderIndex)"><div role="row" ui-grid-row="row" row-render-index="rowRenderIndex"></div></div></div></div>'),e.put("ui-grid/cellEditor",'<div><form name="inputForm"><input type="INPUT_TYPE" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'),e.put("ui-grid/dropdownEditor",'<div><form name="inputForm"><select ng-class="\'colt\' + col.uid" ui-grid-edit-dropdown ng-model="MODEL_COL_FIELD" ng-options="field[editDropdownIdLabel] as field[editDropdownValueLabel] CUSTOM_FILTERS for field in editDropdownOptionsArray"></select></form></div>'),e.put("ui-grid/fileChooserEditor",'<div><form name="inputForm"><input ng-class="\'colt\' + col.uid" ui-grid-edit-file-chooser type="file" id="files" name="files[]" ng-model="MODEL_COL_FIELD"></form></div>'),e.put("ui-grid/emptyBaseLayerContainer",'<div class="ui-grid-empty-base-layer-container ui-grid-canvas"><div class="ui-grid-row" ng-repeat="(rowRenderIndex, row) in grid.baseLayer.emptyRows track by $index" ng-style="Viewport.rowStyle(rowRenderIndex)"><div><div><div ng-repeat="(colRenderIndex, col) in colContainer.renderedColumns track by col.colDef.name" class="ui-grid-cell {{ col.getColClass(false) }}"></div></div></div></div></div>'),e.put("ui-grid/expandableRow",'<div ui-grid-expandable-row ng-if="expandableRow.shouldRenderExpand()" class="expandableRow" style="float:left; margin-top: 1px; margin-bottom: 1px" ng-style="{width: (grid.renderContainers.body.getCanvasWidth()) + \'px\', height: row.expandedRowHeight + \'px\'}"></div>'),e.put("ui-grid/expandableRowHeader",'<div class="ui-grid-row-header-cell ui-grid-expandable-buttons-cell"><div class="ui-grid-cell-contents"><i ng-if="!(row.groupHeader==true || row.entity.subGridOptions.disableRowExpandable)" ng-class="{ \'ui-grid-icon-plus-squared\' : !row.isExpanded, \'ui-grid-icon-minus-squared\' : row.isExpanded }" ng-click="grid.api.expandable.toggleRowExpansion(row.entity)"></i></div></div>'),e.put("ui-grid/expandableScrollFiller","<div ng-if=\"expandableRow.shouldRenderFiller()\" ng-class=\"{scrollFiller:true, scrollFillerClass:(colContainer.name === 'body')}\" ng-style=\"{ width: (grid.getViewportWidth()) + 'px', height: row.expandedRowHeight + 2 + 'px', 'margin-left': grid.options.rowHeader.rowHeaderWidth + 'px' }\"><i class=\"ui-grid-icon-spin5 ui-grid-animate-spin\" ng-style=\"{'margin-top': ( row.expandedRowHeight/2 - 5) + 'px', 'margin-left' : ((grid.getViewportWidth() - grid.options.rowHeader.rowHeaderWidth)/2 - 5) + 'px'}\"></i></div>"),e.put("ui-grid/expandableTopRowHeader",'<div class="ui-grid-row-header-cell ui-grid-expandable-buttons-cell"><div class="ui-grid-cell-contents"><span class="ui-grid-cell-empty" ng-if="!grid.options.showExpandAllButton"></span> <button type="button" class="ui-grid-icon-button" ng-if="grid.options.showExpandAllButton" ng-class="{ \'ui-grid-icon-plus-squared\' : !grid.expandable.expandedAll, \'ui-grid-icon-minus-squared\' : grid.expandable.expandedAll }" ng-click="grid.api.expandable.toggleAllRows()"></button></div></div>'),e.put("ui-grid/csvLink",'<span class="ui-grid-exporter-csv-link-span"><a href="data:text/csv;charset=UTF-8,CSV_CONTENT" download="FILE_NAME">LINK_LABEL</a></span>'),e.put("ui-grid/importerMenuItem",'<li class="ui-grid-menu-item"><form><input class="ui-grid-importer-file-chooser" type="file" id="files" name="files[]"></form></li>'),e.put("ui-grid/importerMenuItemContainer","<div ui-grid-importer-menu-item></div>"),e.put("ui-grid/pagination",'<div class="ui-grid-pager-panel" ui-grid-pager ng-show="grid.options.enablePaginationControls"><div role="navigation" class="ui-grid-pager-container"><div class="ui-grid-pager-control"><button type="button" class="ui-grid-pager-first" ui-grid-one-bind-title="aria.pageToFirst" ui-grid-one-bind-aria-label="aria.pageToFirst" ng-click="pageFirstPageClick()" ng-disabled="cantPageBackward()"><div ng-class="grid.isRTL() ? \'last-triangle\' : \'first-triangle\'"><div ng-class="grid.isRTL() ? \'last-bar-rtl\' : \'first-bar\'"></div></div></button> <button type="button" class="ui-grid-pager-previous" ui-grid-one-bind-title="aria.pageBack" ui-grid-one-bind-aria-label="aria.pageBack" ng-click="pagePreviousPageClick()" ng-disabled="cantPageBackward()"><div ng-class="grid.isRTL() ? \'last-triangle prev-triangle\' : \'first-triangle prev-triangle\'"></div></button> <input type="number" ui-grid-one-bind-title="aria.pageSelected" ui-grid-one-bind-aria-label="aria.pageSelected" class="ui-grid-pager-control-input" ng-model="grid.options.paginationCurrentPage" min="1" max="{{ paginationApi.getTotalPages() }}" step="1" required> <span class="ui-grid-pager-max-pages-number" ng-show="paginationApi.getTotalPages() > 0"><abbr ui-grid-one-bind-title="paginationOf">/ </abbr>{{ paginationApi.getTotalPages() }} </span><button type="button" class="ui-grid-pager-next" ui-grid-one-bind-title="aria.pageForward" ui-grid-one-bind-aria-label="aria.pageForward" ng-click="pageNextPageClick()" ng-disabled="cantPageForward()"><div ng-class="grid.isRTL() ? \'first-triangle next-triangle\' : \'last-triangle next-triangle\'"></div></button> <button type="button" class="ui-grid-pager-last" ui-grid-one-bind-title="aria.pageToLast" ui-grid-one-bind-aria-label="aria.pageToLast" ng-click="pageLastPageClick()" ng-disabled="cantPageToLast()"><div ng-class="grid.isRTL() ? \'first-triangle\' : \'last-triangle\'"><div ng-class="grid.isRTL() ? \'first-bar-rtl\' : \'last-bar\'"></div></div></button></div><div class="ui-grid-pager-row-count-picker" ng-if="grid.options.paginationPageSizes.length > 1 && !grid.options.useCustomPagination"><select ui-grid-one-bind-aria-labelledby-grid="\'items-per-page-label\'" ng-model="grid.options.paginationPageSize" ng-options="o as o for o in grid.options.paginationPageSizes"></select><span ui-grid-one-bind-id-grid="\'items-per-page-label\'" class="ui-grid-pager-row-count-label">&nbsp;{{sizesLabel}}</span></div><span ng-if="grid.options.paginationPageSizes.length <= 1" class="ui-grid-pager-row-count-label">{{grid.options.paginationPageSize}}&nbsp;{{sizesLabel}}</span></div><div class="ui-grid-pager-count-container"><div class="ui-grid-pager-count"><span ng-show="grid.options.totalItems > 0">{{ 1 + paginationApi.getFirstRowIndex() }} <abbr ui-grid-one-bind-title="paginationThrough">- </abbr>{{ 1 + paginationApi.getLastRowIndex() }} {{paginationOf}} {{grid.options.totalItems}} {{totalItemsLabel}}</span></div></div></div>'),e.put("ui-grid/columnResizer",'<div ui-grid-column-resizer ng-if="grid.options.enableColumnResizing" class="ui-grid-column-resizer" col="col" position="right" render-index="renderIndex" unselectable="on"></div>'),e.put("ui-grid/gridFooterSelectedItems",'<span ng-if="grid.selection.selectedCount !== 0 && grid.options.enableFooterTotalSelected">({{"search.selectedItems" | t}} {{grid.selection.selectedCount}})</span>'),e.put("ui-grid/selectionHeaderCell",'<div>\x3c!-- <div class="ui-grid-vertical-bar">&nbsp;</div> --\x3e<div class="ui-grid-cell-contents" col-index="renderIndex"><ui-grid-selection-select-all-buttons ng-if="grid.options.enableSelectAll" role="checkbox" ng-model="grid.selection.selectAll"></ui-grid-selection-select-all-buttons></div></div>'),e.put("ui-grid/selectionRowHeader",'<div class="ui-grid-cell-contents ui-grid-disable-selection"><ui-grid-selection-row-header-buttons></ui-grid-selection-row-header-buttons></div>'),e.put("ui-grid/selectionRowHeaderButtons",'<div class="ui-grid-selection-row-header-buttons ui-grid-icon-ok" ng-class="{\'ui-grid-row-selected\': row.isSelected}" ng-click="selectButtonClick(row, $event)" ng-keydown="selectButtonKeyDown(row, $event)" role="checkbox" ng-model="row.isSelected">&nbsp;</div>'),e.put("ui-grid/selectionSelectAllButtons",'<div role="button" class="ui-grid-selection-row-header-buttons ui-grid-icon-ok" ng-class="{\'ui-grid-all-selected\': grid.selection.selectAll}" ng-click="headerButtonClick($event)" ng-keydown="headerButtonKeyDown($event)"></div>'),e.put("ui-grid/treeBaseExpandAllButtons",'<div class="ui-grid-tree-base-row-header-buttons" ng-class="headerButtonClass()" ng-click="headerButtonClick($event)"></div>'),e.put("ui-grid/treeBaseHeaderCell",'<div><div class="ui-grid-cell-contents" col-index="renderIndex"><ui-grid-tree-base-expand-all-buttons ng-if="grid.options.enableExpandAll"></ui-grid-tree-base-expand-all-buttons></div></div>'),e.put("ui-grid/treeBaseRowHeader",'<div class="ui-grid-cell-contents"><ui-grid-tree-base-row-header-buttons></ui-grid-tree-base-row-header-buttons></div>'),e.put("ui-grid/treeBaseRowHeaderButtons",'<div class="ui-grid-tree-base-row-header-buttons" ng-class="{\'ui-grid-tree-base-header\': row.treeLevel > -1 }" ng-click="treeButtonClick(row, $event)"><i ng-class="treeButtonClass(row)" ng-style="{\'padding-left\': grid.options.treeIndent * row.treeLevel + \'px\'}"></i> &nbsp;</div>'),e.put("ui-grid/cellTitleValidator",'<div class="ui-grid-cell-contents" ng-class="{invalid:grid.validate.isInvalid(row.entity,col.colDef)}" title="{{grid.validate.getTitleFormattedErrors(row.entity,col.colDef)}}">{{COL_FIELD CUSTOM_FILTERS}}</div>'),e.put("ui-grid/cellTooltipValidator",'<div class="ui-grid-cell-contents" ng-class="{invalid:grid.validate.isInvalid(row.entity,col.colDef)}" tooltip-html-unsafe="{{grid.validate.getFormattedErrors(row.entity,col.colDef)}}" tooltip-enable="grid.validate.isInvalid(row.entity,col.colDef)" tooltip-append-to-body="true" tooltip-placement="top" title="TOOLTIP">{{COL_FIELD CUSTOM_FILTERS}}</div>')}]);