/**
 * @license Angular UI Tree v2.11.0
 * (c) 2010-2015. https://github.com/angular-ui-tree/angular-ui-tree
 * License: MIT
 */
!function(){"use strict";angular.module("ui.tree",[]).constant("treeConfig",{treeClass:"angular-ui-tree",emptyTreeClass:"angular-ui-tree-empty",hiddenClass:"angular-ui-tree-hidden",nodesClass:"angular-ui-tree-nodes",nodeClass:"angular-ui-tree-node",handleClass:"angular-ui-tree-handle",placeholderClass:"angular-ui-tree-placeholder",dragClass:"angular-ui-tree-drag",dragThreshold:3,levelThreshold:30})}(),function(){"use strict";angular.module("ui.tree").controller("TreeHandleController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodeScope=null,e.$type="uiTreeHandle"}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodeController",["$scope","$element",function(e,n){function t(e){var n,o,l,r=0,i=e.childNodes();if(!i||0===i.length)return 0;for(l=i.length-1;l>=0;l--)n=i[l],o=1+t(n),r=Math.max(r,o);return r}this.scope=e,e.$element=n,e.$modelValue=null,e.$parentNodeScope=null,e.$childNodesScope=null,e.$parentNodesScope=null,e.$treeScope=null,e.$handleScope=null,e.$type="uiTreeNode",e.$$apply=!1,e.collapsed=!1,e.init=function(t){var o=t[0];e.$treeScope=t[1]?t[1].scope:null,e.$parentNodeScope=o.scope.$nodeScope,e.$modelValue=o.scope.$modelValue[e.$index],e.$parentNodesScope=o.scope,o.scope.initSubNode(e),n.on("$destroy",function(){o.scope.destroySubNode(e)})},e.index=function(){return e.$parentNodesScope.$modelValue.indexOf(e.$modelValue)},e.dragEnabled=function(){return!(e.$treeScope&&!e.$treeScope.dragEnabled)},e.isSibling=function(n){return e.$parentNodesScope==n.$parentNodesScope},e.isChild=function(n){var t=e.childNodes();return t&&t.indexOf(n)>-1},e.prev=function(){var n=e.index();return n>0?e.siblings()[n-1]:null},e.siblings=function(){return e.$parentNodesScope.childNodes()},e.childNodesCount=function(){return e.childNodes()?e.childNodes().length:0},e.hasChild=function(){return e.childNodesCount()>0},e.childNodes=function(){return e.$childNodesScope&&e.$childNodesScope.$modelValue?e.$childNodesScope.childNodes():null},e.accept=function(n,t){return e.$childNodesScope&&e.$childNodesScope.$modelValue&&e.$childNodesScope.accept(n,t)},e.removeNode=function(){var n=e.remove();return e.$callbacks.removed(n),n},e.remove=function(){return e.$parentNodesScope.removeNode(e)},e.toggle=function(){e.collapsed=!e.collapsed},e.collapse=function(){e.collapsed=!0},e.expand=function(){e.collapsed=!1},e.depth=function(){var n=e.$parentNodeScope;return n?n.depth()+1:1},e.maxSubDepth=function(){return e.$childNodesScope?t(e.$childNodesScope):0}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodesController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$modelValue=null,e.$nodeScope=null,e.$treeScope=null,e.$type="uiTreeNodes",e.$nodesMap={},e.nodropEnabled=!1,e.maxDepth=0,e.cloneEnabled=!1,e.initSubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=n):null},e.destroySubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=null):null},e.accept=function(n,t){return e.$treeScope.$callbacks.accept(n,e,t)},e.beforeDrag=function(n){return e.$treeScope.$callbacks.beforeDrag(n)},e.isParent=function(n){return n.$parentNodesScope==e},e.hasChild=function(){return e.$modelValue.length>0},e.safeApply=function(e){var n=this.$root.$$phase;"$apply"==n||"$digest"==n?e&&"function"==typeof e&&e():this.$apply(e)},e.removeNode=function(n){var t=e.$modelValue.indexOf(n.$modelValue);return t>-1?(e.safeApply(function(){e.$modelValue.splice(t,1)[0]}),n):null},e.insertNode=function(n,t){e.safeApply(function(){e.$modelValue.splice(n,0,t)})},e.childNodes=function(){var n,t=[];if(e.$modelValue)for(n=0;n<e.$modelValue.length;n++)t.push(e.$nodesMap[e.$modelValue[n].$$hashKey]);return t},e.depth=function(){return e.$nodeScope?e.$nodeScope.depth():0},e.outOfDepth=function(n){var t=e.maxDepth||e.$treeScope.maxDepth;return t>0?e.depth()+n.maxSubDepth()+1>t:!1}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodesScope=null,e.$type="uiTree",e.$emptyElm=null,e.$callbacks=null,e.dragEnabled=!0,e.emptyPlaceholderEnabled=!0,e.maxDepth=0,e.dragDelay=0,e.cloneEnabled=!1,e.nodropEnabled=!1,e.isEmpty=function(){return e.$nodesScope&&e.$nodesScope.$modelValue&&0===e.$nodesScope.$modelValue.length},e.place=function(n){e.$nodesScope.$element.append(n),e.$emptyElm.remove()},this.resetEmptyElement=function(){e.$nodesScope.$modelValue&&0!==e.$nodesScope.$modelValue.length||!e.emptyPlaceholderEnabled?e.$emptyElm.remove():n.append(e.$emptyElm)},e.resetEmptyElement=this.resetEmptyElement;var t=function(e,n){var o,l,r=e.childNodes();for(o=0;o<r.length;o++)n?r[o].collapse():r[o].expand(),l=r[o].$childNodesScope,l&&t(l,n)};e.collapseAll=function(){t(e.$nodesScope,!0)},e.expandAll=function(){t(e.$nodesScope,!1)}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTree",["treeConfig","$window",function(e,n){return{restrict:"A",scope:!0,controller:"TreeController",link:function(t,o,l,r){var i,a,d,c={accept:null,beforeDrag:null},s={};angular.extend(s,e),s.treeClass&&o.addClass(s.treeClass),"table"===o.prop("tagName").toLowerCase()?(t.$emptyElm=angular.element(n.document.createElement("tr")),a=o.find("tr"),d=a.length>0?angular.element(a).children().length:1e6,i=angular.element(n.document.createElement("td")).attr("colspan",d),t.$emptyElm.append(i)):t.$emptyElm=angular.element(n.document.createElement("div")),s.emptyTreeClass&&t.$emptyElm.addClass(s.emptyTreeClass),t.$watch("$nodesScope.$modelValue.length",function(e){angular.isNumber(e)&&r.resetEmptyElement()},!0),t.$watch(l.dragEnabled,function(e){"boolean"==typeof e&&(t.dragEnabled=e)}),t.$watch(l.emptyPlaceholderEnabled,function(e){"boolean"==typeof e&&(t.emptyPlaceholderEnabled=e,r.resetEmptyElement())}),t.$watch(l.nodropEnabled,function(e){"boolean"==typeof e&&(t.nodropEnabled=e)}),t.$watch(l.cloneEnabled,function(e){"boolean"==typeof e&&(t.cloneEnabled=e)}),t.$watch(l.maxDepth,function(e){"number"==typeof e&&(t.maxDepth=e)}),t.$watch(l.dragDelay,function(e){"number"==typeof e&&(t.dragDelay=e)}),c.accept=function(e,n,t){return!(n.nodropEnabled||n.outOfDepth(e))},c.beforeDrag=function(e){return!0},c.removed=function(e){},c.dropped=function(e){},c.dragStart=function(e){},c.dragMove=function(e){},c.dragStop=function(e){},c.beforeDrop=function(e){},t.$watch(l.uiTree,function(e,n){angular.forEach(e,function(e,n){c[n]&&"function"==typeof e&&(c[n]=e)}),t.$callbacks=c},!0)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeHandle",["treeConfig",function(e){return{require:"^uiTreeNode",restrict:"A",scope:!0,controller:"TreeHandleController",link:function(n,t,o,l){var r={};angular.extend(r,e),r.handleClass&&t.addClass(r.handleClass),n!=l.scope&&(n.$nodeScope=l.scope,l.scope.$handleScope=n)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNode",["treeConfig","UiTreeHelper","$window","$document","$timeout","$rootElement",function(e,n,t,o,l,r){return{require:["^uiTreeNodes","^uiTree"],restrict:"A",controller:"TreeNodeController",link:function(i,a,d,c){var s,u,p,f,h,m,$,g,b,y,v,S,N,E,x,C,T,w,X,D,Y={},A="ontouchstart"in window,V=null,H=document.body,k=document.documentElement;angular.extend(Y,e),Y.nodeClass&&a.addClass(Y.nodeClass),i.init(c),i.collapsed=!!n.getNodeAttribute(i,"collapsed"),i.sourceOnly=i.nodropEnabled||i.$treeScope.nodropEnabled,i.$watch(d.collapsed,function(e){"boolean"==typeof e&&(i.collapsed=e)}),i.$watch("collapsed",function(e){n.setNodeAttribute(i,"collapsed",e),d.$set("collapsed",e)}),y=function(e){if((A||2!=e.button&&3!=e.which)&&!(e.uiTreeDragging||e.originalEvent&&e.originalEvent.uiTreeDragging)){var l,d,c,y,v,S=angular.element(e.target),N=S.scope(),T=a.clone();if(N&&N.$type&&!("uiTreeNode"!=N.$type&&"uiTreeHandle"!=N.$type||"uiTreeNode"==N.$type&&N.$handleScope||(l=S.prop("tagName").toLowerCase(),"input"==l||"textarea"==l||"button"==l||"select"==l))){for(;S&&S[0]&&S[0]!=a;){if(n.nodrag(S))return;S=S.parent()}i.beforeDrag(i)&&(e.uiTreeDragging=!0,e.originalEvent&&(e.originalEvent.uiTreeDragging=!0),e.preventDefault(),c=n.eventObj(e),s=!0,u=n.dragInfo(i),d=a.prop("tagName"),"tr"===d.toLowerCase()?(f=angular.element(t.document.createElement(d)),y=angular.element(t.document.createElement("td")).addClass(Y.placeholderClass).attr("colspan",a[0].children.length),f.append(y)):f=angular.element(t.document.createElement(d)).addClass(Y.placeholderClass),h=angular.element(t.document.createElement(d)),Y.hiddenClass&&h.addClass(Y.hiddenClass),p=n.positionStarted(c,a),f.css("height",n.height(a)+"px"),m=angular.element(t.document.createElement(i.$parentNodesScope.$element.prop("tagName"))).addClass(i.$parentNodesScope.$element.attr("class")).addClass(Y.dragClass),m.css("width",n.width(a)+"px"),m.css("z-index",9999),v=(a[0].querySelector(".angular-ui-tree-handle")||a[0]).currentStyle,v&&(document.body.setAttribute("ui-tree-cursor",o.find("body").css("cursor")||""),o.find("body").css({cursor:v.cursor+"!important"})),i.sourceOnly&&f.css("display","none"),a.after(f),a.after(h),u.isClone()&&i.sourceOnly?m.append(T):m.append(a),r.append(m),m.css({left:c.pageX-p.offsetX+"px",top:c.pageY-p.offsetY+"px"}),$={placeholder:f,dragging:m},i.$apply(function(){i.$treeScope.$callbacks.dragStart(u.eventArgs($,p))}),angular.element(o).bind("touchend",x),angular.element(o).bind("touchcancel",x),angular.element(o).bind("touchmove",E),angular.element(o).bind("mouseup",x),angular.element(o).bind("mousemove",E),angular.element(o).bind("mouseleave",C),g=Math.max(H.scrollHeight,H.offsetHeight,k.clientHeight,k.scrollHeight,k.offsetHeight),b=Math.max(H.scrollWidth,H.offsetWidth,k.clientWidth,k.scrollWidth,k.offsetWidth))}}},v=function(e){var o,l,r,a,d,c,h,y,v,S,N,E,x,C,T,w,X=n.eventObj(e);if(m){if(e.preventDefault(),t.getSelection?t.getSelection().removeAllRanges():t.document.selection&&t.document.selection.empty(),r=X.pageX-p.offsetX,a=X.pageY-p.offsetY,0>r&&(r=0),0>a&&(a=0),a+10>g&&(a=g-10),r+10>b&&(r=b-10),m.css({left:r+"px",top:a+"px"}),d=window.pageYOffset||t.document.documentElement.scrollTop,c=d+(window.innerHeight||t.document.clientHeight||t.document.clientHeight),c<X.pageY&&g>=c&&window.scrollBy(0,10),d>X.pageY&&window.scrollBy(0,-10),n.positionMoved(e,p,s),s)return void(s=!1);if(y=n.offset(m).left-n.offset(f).left>=Y.threshold,v=X.pageX-(t.pageXOffset||t.document.body.scrollLeft||t.document.documentElement.scrollLeft)-(t.document.documentElement.clientLeft||0),S=X.pageY-(t.pageYOffset||t.document.body.scrollTop||t.document.documentElement.scrollTop)-(t.document.documentElement.clientTop||0),angular.isFunction(m.hide)?m.hide():(N=m[0].style.display,m[0].style.display="none"),t.document.elementFromPoint(v,S),x=angular.element(t.document.elementFromPoint(v,S)),angular.isFunction(m.show)?m.show():m[0].style.display=N,D=!x.scope()||!x.scope().$type,D&&(f.remove(),V&&(V.resetEmptyElement(),V=null)),p.dirAx&&p.distAxX>=Y.levelThreshold&&(p.distAxX=0,p.distX>0&&(o=u.prev(),o&&!o.collapsed&&o.accept(i,o.childNodesCount())&&(o.$childNodesScope.$element.append(f),u.moveTo(o.$childNodesScope,o.childNodes(),o.childNodesCount()))),p.distX<0&&(l=u.next(),l||(h=u.parentNode(),h&&h.$parentNodesScope.accept(i,h.index()+1)&&(h.$element.after(f),u.moveTo(h.$parentNodesScope,h.siblings(),h.index()+1))))),!p.dirAx){if(E=x.scope(),C=!1,!E)return;if(!E.$treeScope||E.$parent.nodropEnabled||E.$treeScope.nodropEnabled||f.css("display",""),"uiTree"==E.$type&&E.dragEnabled&&(C=E.isEmpty()),"uiTreeHandle"==E.$type&&(E=E.$nodeScope),"uiTreeNode"!=E.$type&&!C)return;V&&f.parent()[0]!=V.$element[0]&&(V.resetEmptyElement(),V=null),C?(V=E,E.$nodesScope.accept(i,0)&&(E.place(f),u.moveTo(E.$nodesScope,E.$nodesScope.childNodes(),0))):E.dragEnabled()&&(x=E.$element,T=n.offset(x),w=E.horizontal?X.pageX<T.left+n.width(x)/2:X.pageY<T.top+n.height(x)/2,E.$parentNodesScope.accept(i,E.index())?w?(x[0].parentNode.insertBefore(f[0],x[0]),u.moveTo(E.$parentNodesScope,E.siblings(),E.index())):(x.after(f),u.moveTo(E.$parentNodesScope,E.siblings(),E.index()+1)):!w&&E.accept(i,E.childNodesCount())?(E.$childNodesScope.$element.append(f),u.moveTo(E.$childNodesScope,E.childNodes(),E.childNodesCount())):D=!0)}i.$apply(function(){i.$treeScope.$callbacks.dragMove(u.eventArgs($,p))})}},S=function(e){e.preventDefault(),m&&(i.$treeScope.$apply(function(){i.$treeScope.$callbacks.beforeDrop(u.eventArgs($,p))}),h.replaceWith(a),f.remove(),m.remove(),m=null,i.$$apply&&!D?i.$treeScope.$apply(function(){u.apply(),i.$treeScope.$callbacks.dropped(u.eventArgs($,p))}):w(),i.$treeScope.$apply(function(){i.$treeScope.$callbacks.dragStop(u.eventArgs($,p))}),i.$$apply=!1,u=null);var n=document.body.getAttribute("ui-tree-cursor");null!==n&&(o.find("body").css({cursor:n}),document.body.removeAttribute("ui-tree-cursor")),angular.element(o).unbind("touchend",x),angular.element(o).unbind("touchcancel",x),angular.element(o).unbind("touchmove",E),angular.element(o).unbind("mouseup",x),angular.element(o).unbind("mousemove",E),angular.element(t.document.body).unbind("mouseleave",C)},N=function(e){i.dragEnabled()&&y(e)},E=function(e){v(e)},x=function(e){i.$$apply=!0,S(e)},C=function(e){S(e)},T=function(){var e;return{exec:function(n,t){t||(t=0),this.cancel(),e=l(n,t)},cancel:function(){l.cancel(e)}}}(),w=function(){a.bind("touchstart mousedown",function(e){T.exec(function(){N(e)},i.dragDelay||0)}),a.bind("touchend touchcancel mouseup",function(){T.cancel()})},w(),X=function(e){27==e.keyCode&&(i.$$apply=!1,S(e))},angular.element(t.document.body).bind("keydown",X),i.$on("$destroy",function(){angular.element(t.document.body).unbind("keydown",X)})}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNodes",["treeConfig","$window",function(e){return{require:["ngModel","?^uiTreeNode","^uiTree"],restrict:"A",scope:!0,controller:"TreeNodesController",link:function(n,t,o,l){var r={},i=l[0],a=l[1],d=l[2];angular.extend(r,e),r.nodesClass&&t.addClass(r.nodesClass),a?(a.scope.$childNodesScope=n,n.$nodeScope=a.scope):d.scope.$nodesScope=n,n.$treeScope=d.scope,i&&(i.$render=function(){n.$modelValue=i.$modelValue}),n.$watch(o.maxDepth,function(e){"number"==typeof e&&(n.maxDepth=e)}),n.$watch(function(){return o.nodropEnabled},function(e){"undefined"!=typeof e&&(n.nodropEnabled=!0)},!0),o.$observe("horizontal",function(e){n.horizontal="undefined"!=typeof e})}}}])}(),function(){"use strict";angular.module("ui.tree").factory("UiTreeHelper",["$document","$window",function(e,n){return{nodesData:{},setNodeAttribute:function(e,n,t){if(!e.$modelValue)return null;var o=this.nodesData[e.$modelValue.$$hashKey];o||(o={},this.nodesData[e.$modelValue.$$hashKey]=o),o[n]=t},getNodeAttribute:function(e,n){if(!e.$modelValue)return null;var t=this.nodesData[e.$modelValue.$$hashKey];return t?t[n]:null},nodrag:function(e){return"undefined"!=typeof e.attr("data-nodrag")?"false"!==e.attr("data-nodrag"):!1},eventObj:function(e){var n=e;return void 0!==e.targetTouches?n=e.targetTouches.item(0):void 0!==e.originalEvent&&void 0!==e.originalEvent.targetTouches&&(n=e.originalEvent.targetTouches.item(0)),n},dragInfo:function(e){return{source:e,sourceInfo:{cloneModel:e.$treeScope.cloneEnabled===!0?angular.copy(e.$modelValue):void 0,nodeScope:e,index:e.index(),nodesScope:e.$parentNodesScope},index:e.index(),siblings:e.siblings().slice(0),parent:e.$parentNodesScope,moveTo:function(e,n,t){this.parent=e,this.siblings=n.slice(0);var o=this.siblings.indexOf(this.source);o>-1&&(this.siblings.splice(o,1),this.source.index()<t&&t--),this.siblings.splice(t,0,this.source),this.index=t},parentNode:function(){return this.parent.$nodeScope},prev:function(){return this.index>0?this.siblings[this.index-1]:null},next:function(){return this.index<this.siblings.length-1?this.siblings[this.index+1]:null},isClone:function(){return this.source.$treeScope.cloneEnabled===!0},clonedNode:function(e){return angular.copy(e)},isDirty:function(){return this.source.$parentNodesScope!=this.parent||this.source.index()!=this.index},isForeign:function(){return this.source.$treeScope!==this.parent.$treeScope},eventArgs:function(e,n){return{source:this.sourceInfo,dest:{index:this.index,nodesScope:this.parent},elements:e,pos:n}},apply:function(){var e=this.source.$modelValue;this.parent.nodropEnabled||this.parent.$treeScope.nodropEnabled||this.isDirty()&&(this.isClone()&&this.isForeign()?this.parent.insertNode(this.index,angular.copy(e)):(this.source.remove(),this.parent.insertNode(this.index,e)))}}},height:function(e){return e.prop("scrollHeight")},width:function(e){return e.prop("scrollWidth")},offset:function(t){var o=t[0].getBoundingClientRect();return{width:t.prop("offsetWidth"),height:t.prop("offsetHeight"),top:o.top+(n.pageYOffset||e[0].body.scrollTop||e[0].documentElement.scrollTop),left:o.left+(n.pageXOffset||e[0].body.scrollLeft||e[0].documentElement.scrollLeft)}},positionStarted:function(e,n){var t={},o=e.pageX,l=e.pageY;return e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(o=e.originalEvent.touches[0].pageX,l=e.originalEvent.touches[0].pageY),t.offsetX=o-this.offset(n).left,t.offsetY=l-this.offset(n).top,t.startX=t.lastX=o,t.startY=t.lastY=l,t.nowX=t.nowY=t.distX=t.distY=t.dirAx=0,t.dirX=t.dirY=t.lastDirX=t.lastDirY=t.distAxX=t.distAxY=0,t},positionMoved:function(e,n,t){var o,l=e.pageX,r=e.pageY;return e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(l=e.originalEvent.touches[0].pageX,r=e.originalEvent.touches[0].pageY),n.lastX=n.nowX,n.lastY=n.nowY,n.nowX=l,n.nowY=r,n.distX=n.nowX-n.lastX,n.distY=n.nowY-n.lastY,n.lastDirX=n.dirX,n.lastDirY=n.dirY,n.dirX=0===n.distX?0:n.distX>0?1:-1,n.dirY=0===n.distY?0:n.distY>0?1:-1,o=Math.abs(n.distX)>Math.abs(n.distY)?1:0,t?(n.dirAx=o,void(n.moving=!0)):(n.dirAx!==o?(n.distAxX=0,n.distAxY=0):(n.distAxX+=Math.abs(n.distX),0!==n.dirX&&n.dirX!==n.lastDirX&&(n.distAxX=0),n.distAxY+=Math.abs(n.distY),0!==n.dirY&&n.dirY!==n.lastDirY&&(n.distAxY=0)),void(n.dirAx=o))}}}])}();