/**
 * @license Angular UI Tree v2.2.0
 * (c) 2010-2014. https://github.com/JimLiu/angular-ui-tree
 * License: MIT
 */
!function(){"use strict";angular.module("ui.tree",[]).constant("treeConfig",{treeClass:"angular-ui-tree",emptyTreeClass:"angular-ui-tree-empty",hiddenClass:"angular-ui-tree-hidden",nodesClass:"angular-ui-tree-nodes",nodeClass:"angular-ui-tree-node",handleClass:"angular-ui-tree-handle",placeHoldersWrapperClass:"angular-ui-tree-placeholders-wrapper",placeHolderClass:"angular-ui-tree-placeholder",dragClass:"angular-ui-tree-drag",dragWrapperClass:"angular-ui-tree-drag-wrapper",dragUpThreshold:10,dir:"ltr",levelThreshold:30}).constant("keys",{space:32,enter:13,tab:9,esc:27,escape:27,backspace:8,back:8,shift:16,maj:16,ctrl:17,control:17,alt:18,left:37,leftarrow:37,up:38,uparrow:38,right:39,rightarrow:39,down:40,downarrow:40,ins:45,insert:45,del:46,"delete":46,home:36,end:35,pgup:33,pageup:33,pgdown:34,pagedown:34,f1:112,f2:113,f3:114,f4:115,f5:116,f6:117,f7:118,f8:119,f9:120,f10:121,f11:122,f12:123})}(),function(){"use strict";angular.module("ui.tree").controller("TreeHandleController",["$scope","$element","$attrs","treeConfig",function(e,t){this.scope=e,e.$element=t,e.$handleElement=t,e.$nodeScope=void 0,e.$type="uiTreeHandle"}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodeController",["$scope","$element","$attrs","treeConfig",function(e,t){this.scope=e,e.$element=t,e.$nodeElement=t,e.$modelValue=void 0,e.$parentNodeScope=void 0,e.$childNodesScope=void 0,e.$parentNodesScope=void 0,e.$treeScope=void 0,e.$handleScope=void 0,e.$type="uiTreeNode",e.$$apply=!1,e.$dragInfo=void 0,e.collapsed=!1,e.expandOnHover=!1,e.selected=!1,e.init=function(n){var o=n[0];e.$treeScope=n[1]?n[1].scope:void 0,e.$parentNodeScope=o.scope.$nodeScope,e.$modelValue=o.scope.$modelValue[e.$index],e.$parentNodesScope=o.scope,o.scope.initSubNode(e),t.on("$destroy",function(){o.scope.destroySubNode(e)})},e.toggleSelected=function(){e.selected?e.unselect():e.select()},e.select=function(){!e.selected&&e.$treeScope.$callbacks.select(e)&&(e.selected=!0,e.$treeScope.$selecteds.push(e.$element))},e.unselect=function(){if(e.selected&&e.$treeScope.$callbacks.unselect(e)){e.selected=!1;var t=e.$treeScope.$selecteds.indexOf(e.$element);angular.isDefined(t)&&t>-1&&e.$treeScope.$selecteds.splice(t,1)}},e.index=function(){return e.$parentNodesScope.$modelValue.indexOf(e.$modelValue)},e.dragEnabled=function(){return!(e.$treeScope&&!e.$treeScope.dragEnabled)},e.isSibling=function(t){return e.$parentNodesScope===t.$parentNodesScope},e.isChild=function(t){var n=e.childNodes();return n&&n.indexOf(t)>-1},e.prev=function(){var t=e.index();return t>0?e.siblings()[t-1]:void 0},e.siblings=function(){return e.$parentNodesScope.childNodes()},e.childNodesCount=function(){return angular.isDefined(e.childNodes())?e.childNodes().length:0},e.hasChild=function(){return e.childNodesCount()>0},e.childNodes=function(){return angular.isDefined(e.$childNodesScope)&&angular.isDefined(e.$childNodesScope.$modelValue)?e.$childNodesScope.childNodes():void 0},e.accept=function(t,n){return angular.isDefined(e.$childNodesScope)&&angular.isDefined(e.$childNodesScope.$modelValue)&&e.$childNodesScope.accept(t,n)},e.removeNode=function(){if(e.$treeScope.$callbacks.remove(t)){var t=e.remove();return t}return void 0},e.remove=function(){return e.$parentNodesScope.removeNode(e)},e.toggle=function(){e.collapsed=!e.collapsed},e.collapse=function(t){e.collapsed=e.$treeScope.$callbacks.collapse(e,t)},e.expand=function(t){e.collapsed=!e.$treeScope.$callbacks.expand(e,t)},e.depth=function(){var t=e.$parentNodeScope;return t?t.depth()+1:1};var n=0,o=function(e){for(var t=0,r=e.childNodes(),a=0;a<r.length;a++){var l=r[a].$childNodesScope;l&&(t=1,o(l))}n+=t};e.maxSubDepth=function(){return n=0,e.$childNodesScope&&o(e.$childNodesScope),n}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodesController",["$scope","$element","$q","treeConfig",function(e,t,n){this.scope=e,e.$element=t,e.$nodesElement=t,e.$modelValue=void 0,e.$nodeScope=void 0,e.$treeScope=void 0,e.$type="uiTreeNodes",e.$nodesMap={},e.nodrop=!1,e.maxDepth=0,e.expandOnHover=void 0,e.initSubNode=function(t){return t.$modelValue?void(e.$nodesMap[t.$modelValue.$$hashKey]=t):void 0},e.destroySubNode=function(t){return t.$modelValue?void(e.$nodesMap[t.$modelValue.$$hashKey]=void 0):void 0},e.accept=function(t,n){return e.$treeScope.$callbacks.accept(t,e,n)},e.beforeDrag=function(t,n){return e.$treeScope.$callbacks.beforeDrag(t,n)},e.isParent=function(t){return t.$parentNodesScope==e},e.hasChild=function(){return e.$modelValue.length>0},e.safeApply=function(e){var t=this.$root.$$phase;"$apply"==t||"$digest"==t?e&&"function"==typeof e&&e():this.$apply(e)},e.removeNode=function(t){var o=n.defer(),r=e.$modelValue.indexOf(t.$modelValue);return r>-1?e.safeApply(function(){e.$modelValue.splice(r,1)[0],o.resolve(t)}):o.reject("not found"),o.promise},e.insertNode=function(t,o){var r=n.defer();return e.safeApply(function(){e.$modelValue.splice(t,0,o),r.resolve("inserted")}),r.promise},e.childNodes=function(){var t=[];if(e.$modelValue)for(var n=0;n<e.$modelValue.length;n++)t.push(e.$nodesMap[e.$modelValue[n].$$hashKey]);return t},e.depth=function(){return e.$nodeScope?e.$nodeScope.depth():0},e.outOfDepth=function(t){var n=e.maxDepth||e.$treeScope.maxDepth;return n>0?e.depth()+t.maxSubDepth()+1>n:!1}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeController",["$scope","$element","$window","$attrs","treeConfig","keys",function(e,t,n,o,r,a){this.scope=e,e.$element=t,e.$treeElement=t,e.$nodesScope=void 0,e.$type="uiTree",e.$emptyElm=void 0,e.$callbacks=void 0,e.$selecteds=[],e.dragEnabled=angular.isUndefined(e.dragEnabled)?!0:e.dragEnabled,e.emptyPlaceholderEnabled=angular.isUndefined(e.emptyPlaceholderEnabled)?!1:e.emptyPlaceholderEnabled,e.maxDepth=angular.isUndefined(e.maxDepth)?10:e.maxDepth,e.dragDelay=angular.isUndefined(e.dragDelay)?0:e.dragDelay,e.dragDistance=angular.isUndefined(e.dragDistance)?0:e.dragDistance,e.cancelKey=a.escape,e.lockXKey=void 0,e.lockX=!1,e.lockYKey=void 0,e.lockY=!1,e.boundTo=angular.isUndefined(e.boundTo)?"":e.boundTo,e.collideWith="bottom",e.coverage=.5,e.spacing=angular.isUndefined(e.spacing)?50:e.spacing,e.spacingThreshold=Math.floor(e.spacing/4),e.copyKey=void 0,e.copy=!1,e.multiSelectKey=void 0,e.multiSelect=!1,e.expandOnHover=angular.isUndefined(e.expandOnHover)?500:e.expandOnHover,e.$watch("callbacks",function(t){angular.forEach(t,function(t,n){e.$callbacks[n]&&angular.isFunction(t)&&(e.$callbacks[n]=t)})},!0),e.$watch("$nodesScope.$modelValue.length",function(t){"undefined"!=typeof t&&e.$nodesScope.$modelValue&&e.resetEmptyElement()},!0),e.$watch("lockXKeyString",function(t){angular.isString(t)&&(t=t.toLowerCase(),t.length>0&&(e.lockXKey=angular.isDefined(a[t])?a[t]:1===t.length?t.charCodeAt(0)-32:void 0)),e.lockX=angular.isUndefined(e.lockXKey)&&"boolean"==typeof t?t:!1}),e.$watch("lockYKeyString",function(t){angular.isString(t)&&(t=t.toLowerCase(),t.length>0&&(e.lockYKey=angular.isDefined(a[t])?a[t]:1===t.length?t.charCodeAt(0)-32:void 0)),e.lockY=angular.isUndefined(e.lockXKey)&&"boolean"==typeof t?t:!1}),e.$watch("boundToString",function(t){if(angular.isString(t)&&t.length>0)try{e.boundTo=angular.element(n.document.querySelectorAll(t))}catch(o){e.boundTo=""}}),e.$watch("spacing",function(t){angular.isNumber(t)&&t>0&&(e.spacingThreshold=Math.floor(e.spacing/4))}),e.$watch("coveragePercent",function(t){angular.isNumber(t)&&t>=-100&&100>=t&&(e.collideWith=0>t?"top":"bottom",e.coverage=Math.abs(t/100))}),e.$watch("cancelKeyString",function(t){angular.isString(t)&&(t=t.toLowerCase(),t.length>0&&(e.cancelKey=angular.isDefined(a[t])?a[t]:t.charCodeAt(0)-32))}),e.$watch("copyKeyString",function(t){angular.isString(t)&&(t=t.toLowerCase(),t.length>0&&(e.copyKey=angular.isDefined(a[t])?a[t]:t.charCodeAt(0)-32))}),e.$watch("selectKeyString",function(t){angular.isString(t)&&(t=t.toLowerCase(),t.length>0&&(e.multiSelectKey=angular.isDefined(a[t])?a[t]:t.charCodeAt(0)-32))}),e.isEmpty=function(){return e.$nodesScope&&e.$nodesScope.$modelValue&&0===e.$nodesScope.$modelValue.length},e.place=function(t){e.$nodesScope.$element.append(t),e.$emptyElm.remove()},e.resetEmptyElement=function(){0===e.$nodesScope.$modelValue.length&&e.emptyPlaceholderEnabled?t.append(e.$emptyElm):e.$emptyElm.remove()};var l=function(e,t){for(var n=e.childNodes(),o=0;o<n.length;o++)if(n[o]){t?n[o].collapse(!0):n[o].expand(!0);var r=n[o].$childNodesScope;r&&l(r,t)}};e.collapseAll=function(){l(e.$nodesScope,!0)},e.$on("collapseAll",e.collapseAll),e.expandAll=function(){l(e.$nodesScope,!1)},e.$on("expandAll",e.expandAll)}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTree",["treeConfig","keys","$window",function(e,t,n){return{restrict:"EA",scope:{callbacks:"=?",dragEnabled:"=?",emptyPlaceholderEnabled:"=?",maxDepth:"=?",dragDelay:"=?",dragDistance:"=?",lockXKeyString:"=?lockX",lockYKeyString:"=?lockY",boundToString:"=?boundTo",spacing:"=?",coveragePercent:"=?coverage",cancelKeyString:"=?cancelKey",copyKeyString:"=?copyKey",selectKeyString:"=?selectKey",expandOnHover:"=?"},controller:"TreeController",link:function(t,o,r){var a={accept:void 0,beforeDrag:void 0},l={};r.uiTreeDir&&(e.dir=r.uiTreeDir),angular.extend(l,e),l.treeClass&&o.addClass(l.treeClass),t.$emptyElm=angular.element(n.document.createElement("div")),l.emptyTreeClass&&t.$emptyElm.addClass(l.emptyTreeClass),a.accept=function(e,t){return t.nodrop||t.outOfDepth(e)?!1:!0},a.collapse=function(){return!0},a.expand=function(){return!0},a.beforeDrag=function(){return!0},a.expandTimeoutStart=function(){},a.expandTimeoutCancel=function(){},a.expandTimeoutEnd=function(){return!0},a.remove=function(){return!0},a.dropped=function(){},a.droppedInto=function(){},a.dragStart=function(){},a.dragMove=function(){},a.placeholderMove=function(){},a.dragCancel=function(){},a.dragStop=function(){},a.beforeDrop=function(){return!0},a.lock=function(){return!0},a.unlock=function(){return!0},a.startCopy=function(){return!0},a.endCopy=function(){},a.startSelect=function(){return!0},a.select=function(){return!0},a.unselect=function(){return!0},a.endSelect=function(){},t.$callbacks=a}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeHandle",["treeConfig",function(e){return{require:"^uiTreeNode",restrict:"A",scope:!0,controller:"TreeHandleController",link:function(t,n,o,r){var a={};angular.extend(a,e),a.handleClass&&n.addClass(a.handleClass),t!=r.scope&&(t.$nodeScope=r.scope,r.scope.$handleScope=t)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNode",["treeConfig","$uiTreeHelper","$window","$document","$timeout","$filter",function(e,t,n,o,r,a){return{require:["^uiTreeNodes","^uiTree"],restrict:"EA",controller:"TreeNodeController",link:function(l,i,c,d){var s={};angular.extend(s,e),s.nodeClass&&i.addClass(s.nodeClass),l.init(d),l.collapsed=!!t.getNodeAttribute(l,"collapsed"),c&&c.collapsed&&l.$watch(c.collapsed,function(e){"boolean"==typeof e&&(l.collapsed=e)}),l.$watch("collapsed",function(e){t.setNodeAttribute(l,"collapsed",e),c.$set("collapsed",e)}),l.selected=!!t.getNodeAttribute(l,"selected"),c&&c.selected&&l.$watch(c.selected,function(e){"boolean"==typeof e&&(l.selected=e)}),l.$watch("selected",function(e){t.setNodeAttribute(l,"selected",e),c.$set("selected",e)}),c&&c.expandOnHover&&l.$watch(c.expandOnHover,function(e){l.expandOnHover=e});var u,p,f,g,$,h,m,S,v,y,b="ontouchstart"in window,N=!0,C=!1,D=document.body,x=document.documentElement,E=function(e){e.preventDefault(),e.stopPropagation(),k(l),w(l)||l.$apply(l.toggleSelected)},w=function(e,t){e=angular.isUndefined(e)?l:e,t=angular.isUndefined(t)?0:t;var n=!1;return null!==e&&(n=!1,!n&&angular.isDefined(e.$parent)&&(n=w(e.$parent,t+1)),!n&&t>0&&(n=angular.isDefined(e.selected)?e.selected:!1)),n},k=function(e){e=angular.isUndefined(e)?l:e,e.hasChild()&&angular.forEach(e.childNodes(),function(e){e.$apply(e.unselect),k(e)})},T=function(e){if(l.$treeScope.dragDistance>0){var n=t.eventObj(e);p=t.positionStarted(n,l.$element);var r=function(t){t.preventDefault();var n=Math.floor(Math.sqrt(Math.pow(t.pageX-p.startX,2)+Math.pow(t.pageY-p.startY,2)));n>=l.$treeScope.dragDistance&&(angular.element(o).unbind("touchmove",r),angular.element(o).unbind("mousemove",r),angular.element(o).unbind("touchend",a),angular.element(o).unbind("touchcancel",a),angular.element(o).unbind("mouseup",a),X(e))};angular.element(o).bind("touchmove",r),angular.element(o).bind("mousemove",r);var a=function(e){e.preventDefault(),angular.element(o).unbind("touchmove",r),angular.element(o).unbind("mousemove",r),angular.element(o).unbind("touchend",a),angular.element(o).unbind("touchcancel",a),angular.element(o).unbind("mouseup",a),V(e)};angular.element(o).bind("touchend",a),angular.element(o).bind("touchcancel",a),angular.element(o).bind("mouseup",a)}else X(e)},X=function(e,r){if(l.$treeScope.dragEvent=angular.isDefined(e)&&!r?e:l.$treeScope.dragEvent,angular.isDefined(l.$treeScope.dragEvent)){{t.offset(l.$element)}if(!b&&(2==l.$treeScope.dragEvent.button||3==l.$treeScope.dragEvent.which))return;if((l.$treeScope.dragEvent.uiTreeDragging||l.$treeScope.dragEvent.originalEvent&&l.$treeScope.dragEvent.originalEvent.uiTreeDragging)&&!r)return;var c=angular.element(l.$treeScope.dragEvent.target),d=c.scope();if(!d||!d.$type)return;if("uiTreeNode"!=d.$type&&"uiTreeHandle"!=d.$type)return;if("uiTreeNode"==d.$type&&d.$handleScope)return;var h=c.prop("tagName").toLowerCase();if("input"==h||"textarea"==h||"button"==h||"select"==h)return;for(;c&&c[0]&&c[0]!=i;){if(t.nodrag(c))return;c=c.parent()}if(!l.$parentNodesScope.beforeDrag(l,l.$treeScope.dragEvent)&&!r)return;l.$treeScope.dragEvent.uiTreeDragging=!0,l.$treeScope.dragEvent.originalEvent&&(l.$treeScope.dragEvent.originalEvent.uiTreeDragging=!0),l.$treeScope.dragEvent.preventDefault(),n.getSelection?n.getSelection().removeAllRanges():n.document.selection&&n.document.selection.empty();var S=t.eventObj(l.$treeScope.dragEvent);if(r)angular.forEach(l.$treeScope.$selecteds,function(e){e=angular.element(e),l.$treeScope.copy?e.removeClass(s.hiddenClass):e.addClass(s.hiddenClass)});else{if(u=!0,(angular.isUndefined(l.$treeScope.$selecteds)||0===l.$treeScope.$selecteds.length)&&(l.$treeScope.$selecteds=[l.$element]),l.selected||(angular.forEach(l.$treeScope.$selecteds,function(e){var t=angular.element(e).scope();t.$apply(function(){t.selected=!1})}),l.$treeScope.$selecteds=[l.$element]),l.$treeScope.$selecteds.length>1&&(l.$treeScope.$selecteds=a("orderBy")(l.$treeScope.$selecteds,function(e){return t.offset(angular.element(e)).top},!1)),angular.isDefined(l.$treeScope.$selecteds)&&l.$treeScope.$selecteds.length>0){f=angular.element(n.document.createElement("div")).addClass(s.placeHoldersWrapperClass),g=angular.element(n.document.createElement("div")),$=angular.element(n.document.createElement("div")).addClass(s.dragWrapperClass),p=t.positionStarted(S,angular.element(l.$treeScope.$selecteds[0]));var N=angular.element(l.$treeScope.$selecteds[0]),C=angular.copy(t.offset(N));angular.forEach(l.$treeScope.$selecteds,function(e){var r=angular.element(e),a=r.scope();a.$dragInfo=t.dragInfo(a);var i,c=t.height(r),d=t.width(r),u=r.prop("tagName");if("tr"===u.toLowerCase()){i=angular.element(n.document.createElement(u));var p=angular.element(n.document.createElement("td")).addClass(s.placeHolderClass);i.append(p)}else i=angular.element(n.document.createElement(u)).addClass(s.placeHolderClass);i.css("height",c+"px"),f.append(i);var h=angular.element(n.document.createElement(u));s.hiddenClass&&h.addClass(s.hiddenClass),g.append(h);var m=angular.element(n.document.createElement(a.$parentNodesScope.$element.prop("tagName"))).addClass(a.$parentNodesScope.$element.attr("class"));m.css("width",d+"px");var S=r.clone();m.append(S),l.$treeScope.copy||r.addClass(s.hiddenClass),$.append(m);var v=(l.$element[0].querySelector(".angular-ui-tree-handle")||l.$element[0]).currentStyle;v&&(document.body.setAttribute("ui-tree-cursor",o.find("body").css("cursor")||""),o.find("body").css({cursor:v.cursor+"!important"})),a.$apply(function(){a.selected=!1,a.original=!0})}),$.css("z-index",9999).addClass(s.dragClass),N.parent()[0].insertBefore(f[0],N[0]),N.parent()[0].insertBefore(g[0],N[0]),o.find("body").append($),$.css({left:C.left+"px",top:C.top+"px"}),m={placeholder:f,dragging:$},angular.element(o).bind("touchend",V),angular.element(o).bind("touchcancel",V),angular.element(o).bind("touchmove",I),angular.element(o).bind("mouseup",V),angular.element(o).bind("mousemove",I),angular.element(o).bind("mouseleave",O)}v=Math.max(D.scrollHeight,D.offsetHeight,x.clientHeight,x.scrollHeight,x.offsetHeight),y=Math.max(D.scrollWidth,D.offsetWidth,x.clientWidth,x.scrollWidth,x.offsetWidth)}}},Y=function(e){e.preventDefault(),l.$treeScope.$selecteds.length>0&&X(void 0,!0)},A=function(e){if(!C)return void(N||(C=!0,angular.forEach(l.$treeScope.$selecteds,function(e){e=angular.element(e);var t=e.scope();t.$apply(function(){l.$treeScope.$callbacks.dragStart(t.$dragInfo.eventArgs(m,p))})})));var o,a=t.eventObj(e),i={},c={},d={},g={};if(e.preventDefault(),n.getSelection?n.getSelection().removeAllRanges():n.document.selection&&n.document.selection.empty(),$){c=t.offset($),i.left=a.pageX-p.offsetX,i.width=c.width,i.right=i.left+i.width,i.top=a.pageY-p.offsetY,i.height=c.height,i.bottom=i.top+i.height,o=l.$element.find(s.handleClass);var S;if(angular.isDefined(o)&&o.length>0?(S=t.offset(o),d.left=S.left,d.width=S.width,d.top=S.top,d.height=S.height,d.offset=o.position().top):(d.left=i.left,d.width=i.width,d.top=i.top),d.right=d.left+d.width,d.bottom=d.top+d.height,angular.isDefined(l.$treeScope.boundTo)&&l.$treeScope.boundTo.length>0){var b=t.offset(l.$treeScope.boundTo);g.left=b.left,g.width=b.width,g.top=b.top,g.height=b.height}else g.left=0,g.width=y,g.top=0,g.height=v;g.right=g.left+g.width,g.bottom=g.top+g.height,i.left<g.left&&(i.left=g.left),i.top<g.top&&(i.top=g.top),i.left>g.right&&(i.left=g.right),i.top>g.bottom&&(i.top=g.bottom),l.$treeScope.lockY&&(i.top=c.top),l.$treeScope.lockX&&(i.left=c.left),$.css({left:i.left+"px",top:i.top+"px"});var D=window.pageYOffset||n.document.documentElement.scrollTop,x=D+(window.innerHeight||n.document.clientHeight||n.document.clientHeight);if(x<a.pageY&&v>=x&&window.scrollBy(0,10),D>a.pageY&&window.scrollBy(0,-10),t.positionMoved(e,p,u),u)return void(u=!1);var E,w=i.left+i.width/2,k=i.top+i.height*l.$treeScope.coverage;angular.isFunction($.hide)?$.hide():(E=$[0].style.display,$[0].style.display="none");var T;angular.isFunction(f.hide)?f.hide():(T=f[0].style.display,f[0].style.display="none"),n.document.elementFromPoint(w,k);var X=angular.element(n.document.elementFromPoint(w,k));angular.isFunction(f.show)?f.show():f[0].style.display=T,angular.isFunction($.show)?$.show():$[0].style.display=E;var Y,A,K,H,I,V,O=X.scope();angular.isDefined(O)&&angular.isDefined(O.$nodeScope)?O=O.$nodeScope:angular.isDefined(O)&&angular.isDefined(O.$nodesScope)&&(O=O.$nodesScope),V=angular.isDefined(O)&&angular.isDefined(O.$treeScope)&&angular.isDefined(O.$treeScope.$treeElement)&&angular.isDefined(O.$treeScope.$treeElement.children())?O:l;var M=V.$treeScope.$treeElement.children(),U=angular.isUndefined(l.previousTreeId)||0===l.previousTreeId.length||angular.isUndefined(V.$treeScope)||l.previousTreeId!==V.$treeScope.$id;l.previousTreeId=angular.isDefined(V.$treeScope)?V.$treeScope.$id:void 0;var W=U?1:p.dirAx?p.dirX:p.dirY,z=t.findIntersect(i,M,l.$treeScope.collideWith,W,l.$parentNodesScope.horizontal);if(angular.isDefined(z)&&(A=angular.element(z)),p.moving||U){var P=angular.element(l.$treeScope.$selecteds[0]).scope().$dragInfo,F=P.prev(),L=P.parentNode();if(angular.isDefined(F)&&!F.collapsed&&angular.isDefined(F.$childNodesScope)){var q=t.offset(F.$element);i.left>=q.left+l.$treeScope.spacing-l.$treeScope.spacingThreshold&&(F.accept(l,F.childNodesCount())&&F.$childNodesScope.$element.append(f),angular.forEach(l.$treeScope.$selecteds,function(e,t){var n=angular.element(e).scope();n.moved=n.$dragInfo.moveTo(F.$childNodesScope,F.childNodes(),F.childNodesCount()+t)}),l.asChild=!0)}if(L=P.parentNode(),angular.isDefined(L)){var B=t.offset(L.$element);i.left<=B.left+l.$treeScope.spacingThreshold&&(P.next()||(L.accept(l,L.index()+1)&&L.$element.after(f),angular.forEach(l.$treeScope.$selecteds,function(e,t){var n=angular.element(e).scope();n.moved=n.$dragInfo.moveTo(L.$parentNodesScope,L.siblings(),L.index()+1+t)}),l.asChild=!1))}if(angular.isUndefined(A))return;if(Y=A.scope(),!Y)return;if(K=!1,H=!1,"uiTree"==Y.$type&&Y.dragEnabled&&(K=Y.isEmpty()),"uiTreeHandle"==Y.$type&&(Y=Y.$nodeScope),"uiTreeNode"!=Y.$type&&!K){if("uiTree"!=Y.$type)return;H=!0}if(A=Y.$element,I=t.offset(A),h&&f.parent()[0]!=h.$element[0]&&(h.resetEmptyElement(),h=void 0),K)h=Y,Y.accept(l,0)&&Y.place(f),angular.forEach(l.$treeScope.$selecteds,function(e,t){var n=angular.element(e).scope();n.moved=n.$dragInfo.moveTo(Y.$parentNodesScope,Y.$parentNodesScope.childNodes(),t)});else if(H)Y.accept(l,Y.$parentNodesScope.childNodes().length+1)&&Y.place(f),angular.forEach(l.$treeScope.$selecteds,function(e,t){var n=angular.element(e).scope();n.moved=n.$dragInfo.moveTo(Y.$parentNodesScope,Y.$parentNodesScope.childNodes(),Y.$parentNodesScope.childNodes().length+1+t)});else if(Y.dragEnabled()){if(angular.forEach(l.$treeScope.$selecteds,function(e){var t=angular.element(e).scope();angular.isDefined(t.expandTimeoutOn)&&t.expandTimeoutOn!==Y.id&&(r.cancel(t.expandTimeout),delete t.expandTimeout,delete t.expandTimeoutOn,Y.$apply(function(){l.$treeScope.$callbacks.expandTimeoutCancel()}))}),Y.collapsed){var j=Y.expandOnHover||Y.$parentNodesScope.expandOnHover||Y.$treeScope.expandOnHover;j===!0||angular.isNumber(j)&&0===j?Y.collapsed=!1:j!==!1&&angular.isNumber(j)&&j>0&&angular.forEach(l.$treeScope.$selecteds,function(e){var t=angular.element(e).scope();angular.isUndefined(t.expandTimeoutOn)&&(t.expandTimeoutOn=Y.$id,Y.$apply(function(){Y.$treeScope.$callbacks.expandTimeoutStart()}),t.expandTimeout=r(function(){Y.$apply(function(){Y.collapsed=!Y.$treeScope.$callbacks.expandTimeoutEnd()})},j))})}var R=Y.hasChild()?t.offset(Y.$childNodesScope.$element).height:0;if(!l.$parentNodesScope.horizontal&&p.dirY>0||l.$parentNodesScope.horizontal&&p.dirX>0||U){var G="top"===l.$treeScope.collideWith?l.$parentNodesScope.horizontal?i.right:i.top:l.$parentNodesScope.horizontal?i.left:i.bottom,J=l.$parentNodesScope.horizontal?I.left-i.left+I.width*l.$treeScope.coverage:I.top+(I.height-R)*l.$treeScope.coverage;if(G>=J)if(!Y.collapsed&&Y.hasChild()||l.asChild){var Q=Y.childNodesCount()>0?Y.childNodes()[0]:void 0,Z=angular.isDefined(Q)?t.offset(Q.$element):void 0,_=angular.isDefined(Q)&&Q.hasChild()?t.offset(Q.$childNodesScope.$element).height:0;(angular.isUndefined(Q)||angular.isDefined(Q)&&G<Z.top+(Z.height-_)*l.$treeScope.coverage)&&(Y.accept(l,0)&&Y.$childNodesScope.$element.prepend(f),angular.forEach(l.$treeScope.$selecteds,function(e,t){var n=angular.element(e).scope(),o=Y;if(!o.$childNodesScope)for(;"undefined"==typeof o.$childNodesScope;)o=o.$parent;n.moved=n.$dragInfo.moveTo(o.$childNodesScope,o.childNodes(),t)}))}else Y.accept(l,Y.index()+1)&&A.after(f),angular.forEach(l.$treeScope.$selecteds,function(e,t){var n=angular.element(e).scope();n.moved=n.$dragInfo.moveTo(Y.$parentNodesScope,Y.siblings(),Y.index()+1+t)})}if((!l.$parentNodesScope.horizontal&&p.dirY<0||l.$parentNodesScope.horizontal&&p.dirX<0)&&(!l.$parentNodesScope.horizontal&&p.distAxY>s.dragUpThreshold||!l.$parentNodesScope.horizontal&&p.distAxX>8)||U){var et="top"===l.$treeScope.collideWith?l.$parentNodesScope.horizontal?i.left:i.bottom:l.$parentNodesScope.horizontal?i.right:i.top,tt=l.$parentNodesScope.horizontal?I.left-i.left+I.width-I.width*l.$treeScope.coverage:I.top+I.height-R-(I.height-R)*l.$treeScope.coverage;tt>=et&&(Y.accept(l,Y.index())&&A[0].parentNode.insertBefore(f[0],A[0]),angular.forEach(l.$treeScope.$selecteds,function(e,t){var n=angular.element(e).scope();n.moved=n.$dragInfo.moveTo(Y.$parentNodesScope,Y.siblings(),Y.index()+t)}))}angular.forEach(l.$treeScope.$selecteds,function(e){var t=angular.element(e).scope();if(t.moved){var n=t.$dragInfo.eventArgs(m,p);angular.isDefined(n)&&angular.isDefined(n.dest)&&(angular.isUndefined(t.dragInfoEventsArgs)||angular.isUndefined(t.dragInfoEventsArgs.dest)||!angular.equals(t.dragInfoEventsArgs.dest,n.dest))&&(t.$apply(function(){l.$treeScope.$callbacks.placeholderMove(n)}),t.dragInfoEventsArgs=n)}})}}}angular.forEach(l.$treeScope.$selecteds,function(e){var t=angular.element(e).scope();t.$apply(function(){l.$treeScope.$callbacks.dragMove(t.$dragInfo.eventArgs(m,p))})})},K=function(e,t){if(angular.isDefined(e)&&e.preventDefault(),r.cancel(l.expandTimeout),angular.isDefined($)&&angular.isDefined(e)){{angular.copy(l.$treeScope.$selecteds.length)}angular.forEach(l.$treeScope.$selecteds,function(e){var n=angular.element(e).scope();if(angular.isDefined(n)){var o=n.$dragInfo.eventArgs(m,p);n.$apply(function(){n.$$apply=l.$treeScope.$callbacks.beforeDrop(o)}),n.$$apply&&!t?(n.$dragInfo.apply(l.$treeScope.copy),l.$treeScope.$apply(function(){l.$treeScope.$callbacks.dropped(o)}),o.dest.nodesScope.$apply(function(){l.$treeScope.$callbacks.droppedInto(o)})):(n.$element.removeClass(s.hiddenClass),n.$apply(function(){l.$treeScope.$callbacks.dragCancel(o)})),n.$apply(function(){l.$treeScope.$callbacks.dragStop(o)}),n.$dragInfo=void 0,n.$apply(function(){delete n.original})}}),angular.isDefined(f)&&(f.remove(),f=void 0),angular.isDefined(g)&&(g.remove(),g=void 0),angular.isDefined($)&&($.remove(),$=void 0),l.$treeScope.$selecteds=[]}var n=document.body.getAttribute("ui-tree-cursor");null!==n&&(o.find("body").css({cursor:n}),document.body.removeAttribute("ui-tree-cursor")),angular.element(o).unbind("touchend",V),angular.element(o).unbind("touchcancel",V),angular.element(o).unbind("touchmove",I),angular.element(o).unbind("mouseup",V),angular.element(o).unbind("mousemove",I),angular.element(o).unbind("mouseleave",O)},H=function(e){l.dragEnabled()&&T(e)},I=function(e){A(e)},V=function(e){angular.forEach(l.$treeScope.$selecteds,function(e){var t=angular.element(e);if(angular.isDefined(t)){var n=t.scope();angular.isDefined(n)&&(n.$$apply=!0)}}),K(e)},O=function(e){angular.forEach(l.$treeScope.$selecteds,function(e){var t=angular.element(e);if(angular.isDefined(t)){var n=t.scope();angular.isDefined(n)&&(n.$$apply=!1)}}),K(e,!0)},M=function(){i.bind("touchstart mousedown",function(e){l.$treeScope.multiSelect?E(e):(N=!0,C=!1,S=r(function(){H(e),N=!1},l.$treeScope.dragDelay))}),i.bind("touchend touchcancel mouseup",function(){r.cancel(S)})},U=function(){K(),angular.element(o).unbind("keydown").unbind("keyup")};M(),angular.element(o).bind("keydown",function(e){e.keyCode===l.$treeScope.cancelKey&&O(e),angular.isDefined(l.$treeScope.lockXKey)&&e.keyCode===l.$treeScope.lockXKey&&l.$treeScope.$apply(function(){l.$treeScope.lockX=l.$treeScope.$callbacks.lock("X")}),angular.isDefined(l.$treeScope.lockYKey)&&e.keyCode===l.$treeScope.lockYKey&&l.$treeScope.$apply(function(){l.$treeScope.lockY=l.$treeScope.$callbacks.lock("Y")}),e.keyCode===l.$treeScope.copyKey?l.$treeScope.copy||(l.$treeScope.$apply(function(){l.$treeScope.copy=l.$treeScope.$callbacks.startCopy()}),Y(e)):e.keyCode===l.$treeScope.multiSelectKey&&(l.$treeScope.multiSelect||l.$treeScope.$apply(function(){l.$treeScope.multiSelect=l.$treeScope.$callbacks.startSelect()}))}),angular.element(o).bind("keyup",function(e){angular.isDefined(l.$treeScope.lockXKey)&&e.keyCode===l.$treeScope.lockXKey&&l.$treeScope.$apply(function(){l.$treeScope.lockX=!l.$treeScope.$callbacks.unlock("X")}),angular.isDefined(l.$treeScope.lockYKey)&&e.keyCode===l.$treeScope.lockYKey&&l.$treeScope.$apply(function(){l.$treeScope.lockY=!l.$treeScope.$callbacks.unlock("Y")}),e.keyCode===l.$treeScope.copyKey?l.$treeScope.copy&&(l.$treeScope.$apply(function(){l.$treeScope.copy=!l.$treeScope.$callbacks.endCopy()}),Y(e)):e.keyCode===l.$treeScope.multiSelectKey&&l.$treeScope.multiSelect&&l.$treeScope.$apply(function(){l.$treeScope.multiSelect=!l.$treeScope.$callbacks.endSelect()})}),l.$on("$destroy",U)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNodes",["treeConfig",function(e){return{require:["ngModel","?^uiTreeNode","^uiTree"],restrict:"EA",scope:{maxDepth:"=?",expandOnHover:"=?",noDrop:"=?",horizontal:"=?"},controller:"TreeNodesController",link:function(t,n,o,r){var a={};angular.extend(a,e),a.nodesClass&&n.addClass(a.nodesClass);var l=r[0],i=r[1],c=r[2];i?(i.scope.$childNodesScope=t,t.$nodeScope=i.scope):c.scope.$nodesScope=t,t.$treeScope=c.scope,l&&(l.$render=function(){l.$modelValue&&angular.isArray(l.$modelValue)||(t.$modelValue=[]),t.$modelValue=l.$modelValue})}}}])}(),function(){"use strict";angular.module("ui.tree").factory("$uiTreeHelper",["$document","$window","treeConfig",function(e,t,n){return{nodesData:{},setNodeAttribute:function(e,t,n){if(!e.$modelValue)return void 0;var o=this.nodesData[e.$modelValue.$$hashKey];o||(o={},this.nodesData[e.$modelValue.$$hashKey]=o),o[t]=n},getNodeAttribute:function(e,t){if(!e.$modelValue)return void 0;var n=this.nodesData[e.$modelValue.$$hashKey];return n?n[t]:void 0},nodrag:function(e){return"undefined"!=typeof e.attr("nodrag")},eventObj:function(e){var t=e;return void 0!==e.targetTouches?t=e.targetTouches.item(0):void 0!==e.originalEvent&&void 0!==e.originalEvent.targetTouches&&(t=e.originalEvent.targetTouches.item(0)),t},dragInfo:function(e){return angular.isDefined(e)?{source:e,sourceInfo:{nodeScope:e,index:angular.isFunction(e.index)?e.index():0,nodesScope:e.$parentNodesScope},index:angular.isFunction(e.index)?e.index():0,siblings:angular.isFunction(e.siblings)?e.siblings().slice(0):[],parent:e.$parentNodesScope,moveTo:function(t,n,o){if(t.accept(e,o)===!0){this.parent=t,this.siblings=n.slice(0);var r=this.siblings.indexOf(this.source);return r>-1&&(this.siblings.splice(r,1),this.source.index()<o&&o--),this.siblings.splice(o,0,this.source),this.index=o,!0}return!1},parentNode:function(){return this.parent.$nodeScope},prev:function(){return this.index>0?this.siblings[this.index-1]:void 0},next:function(){return this.index<this.siblings.length-1?this.siblings[this.index+1]:void 0},isDirty:function(){return this.source.$parentNodesScope!=this.parent||this.source.index()!=this.index},eventArgs:function(e,t){return{source:this.sourceInfo,dest:{index:this.index,nodesScope:this.parent},elements:e,pos:t}},apply:function(e){var t=this.source.$modelValue;if(e||this.source.remove(),angular.isDefined(this.parent)){var n=e?angular.copy(t):t,o=this.index;e&&this.sourceInfo.index<this.index&&this.sourceInfo.nodesScope===this.parent&&(o=this.index+1),this.parent.insertNode(o,n)}}}:void 0},height:function(e){return e.prop("scrollHeight")},width:function(e){return e.prop("scrollWidth")},offset:function(n){var o=n[0].getBoundingClientRect();return{width:n.prop("offsetWidth"),height:n.prop("offsetHeight"),top:o.top+(t.pageYOffset||e[0].body.scrollTop||e[0].documentElement.scrollTop),left:o.left+(t.pageXOffset||e[0].body.scrollLeft||e[0].documentElement.scrollLeft)}},positionStarted:function(e,t){var n={};return n.offsetX=e.pageX-this.offset(t).left,n.offsetY=e.pageY-this.offset(t).top,n.startX=n.lastX=e.pageX,n.startY=n.lastY=e.pageY,n.nowX=n.nowY=n.distX=n.distY=n.dirAx=0,n.dirX=n.dirY=n.lastDirX=n.lastDirY=n.distAxX=n.distAxY=0,n},positionMoved:function(e,t,o){t.lastX=t.nowX,t.lastY=t.nowY,t.nowX=e.pageX,t.nowY=e.pageY,t.distX="rtl"==n.dir?t.lastX-t.nowX:t.nowX-t.lastX,t.distY=t.nowY-t.lastY,t.lastDirX=t.dirX,t.lastDirY=t.dirY,t.dirX=0===t.distX?0:t.distX>0?1:-1,t.dirY=0===t.distY?0:t.distY>0?1:-1;var r=Math.abs(t.distX)>Math.abs(t.distY)?1:0;return o?(t.dirAx=r,void(t.moving=!0)):(t.dirAx!==r?(t.distAxX=0,t.distAxY=0):(t.distAxX+=Math.abs(t.distX),0!==t.dirX&&t.dirX!==t.lastDirX&&(t.distAxX=0),t.distAxY+=Math.abs(t.distY),0!==t.dirY&&t.dirY!==t.lastDirY&&(t.distAxY=0)),void(t.dirAx=r))},findIntersect:function(e,t,n,o,r){for(var a,l=this,i=0;i<t.length;i++){var c,d=angular.element(t[i]);
if(angular.isDefined(d[0]))if(d.hasClass("angular-ui-tree-node"))if(c=l.findIntersect(e,d.children(),n,o,r),angular.isUndefined(c)){var s,u,p=l.offset(d),f={left:p.left,width:p.width,right:p.left+p.width,top:p.top,height:p.height,bottom:p.top+p.height};r&&(0>o?s="bottom"===n?e.left<=f.right&&e.right>=f.left:e.right<=f.right&&e.right>=f.left:o>0&&(s="bottom"===n?e.right>=f.left&&e.left<=f.right:e.left>=f.left&&e.left<=f.right)),0>o?u="bottom"===n?e.top<=f.bottom&&e.bottom>=f.top:e.bottom<=f.bottom&&e.bottom>=f.top:o>0&&(u="bottom"===n?e.bottom>=f.top&&e.top<=f.bottom:e.top>=f.top&&e.top<=f.bottom),(r&&s&&u||!r&&u)&&(a=t[i])}else a=c;else angular.isDefined(d.children())&&d.children().length>0&&(a=l.findIntersect(e,d.children(),n,o,r));if(angular.isDefined(a))break}return a}}}])}();