/**
 * @license Angular UI Tree v2.9.0
 * (c) 2010-2015. https://github.com/angular-ui-tree/angular-ui-tree
 * License: MIT
 */
!function(){"use strict";angular.module("ui.tree",[]).constant("treeConfig",{treeClass:"angular-ui-tree",emptyTreeClass:"angular-ui-tree-empty",hiddenClass:"angular-ui-tree-hidden",nodesClass:"angular-ui-tree-nodes",nodeClass:"angular-ui-tree-node",handleClass:"angular-ui-tree-handle",placeholderClass:"angular-ui-tree-placeholder",dragClass:"angular-ui-tree-drag",dragThreshold:3,levelThreshold:30})}(),function(){"use strict";angular.module("ui.tree").controller("TreeHandleController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodeScope=null,e.$type="uiTreeHandle"}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodeController",["$scope","$element",function(e,n){function t(e){var n,l,r=0,i=e.childNodes();for(n=0;n<i.length;n++)l=i[n].$childNodesScope,l&&l.childNodesCount()>0&&(r=1,t(l));o+=r}this.scope=e,e.$element=n,e.$modelValue=null,e.$parentNodeScope=null,e.$childNodesScope=null,e.$parentNodesScope=null,e.$treeScope=null,e.$handleScope=null,e.$type="uiTreeNode",e.$$apply=!1,e.collapsed=!1,e.init=function(t){var o=t[0];e.$treeScope=t[1]?t[1].scope:null,e.$parentNodeScope=o.scope.$nodeScope,e.$modelValue=o.scope.$modelValue[e.$index],e.$parentNodesScope=o.scope,o.scope.initSubNode(e),n.on("$destroy",function(){o.scope.destroySubNode(e)})},e.index=function(){return e.$parentNodesScope.$modelValue.indexOf(e.$modelValue)},e.dragEnabled=function(){return!(e.$treeScope&&!e.$treeScope.dragEnabled)},e.isSibling=function(n){return e.$parentNodesScope==n.$parentNodesScope},e.isChild=function(n){var t=e.childNodes();return t&&t.indexOf(n)>-1},e.prev=function(){var n=e.index();return n>0?e.siblings()[n-1]:null},e.siblings=function(){return e.$parentNodesScope.childNodes()},e.childNodesCount=function(){return e.childNodes()?e.childNodes().length:0},e.hasChild=function(){return e.childNodesCount()>0},e.childNodes=function(){return e.$childNodesScope&&e.$childNodesScope.$modelValue?e.$childNodesScope.childNodes():null},e.accept=function(n,t){return e.$childNodesScope&&e.$childNodesScope.$modelValue&&e.$childNodesScope.accept(n,t)},e.removeNode=function(){var n=e.remove();return e.$callbacks.removed(n),n},e.remove=function(){return e.$parentNodesScope.removeNode(e)},e.toggle=function(){e.collapsed=!e.collapsed},e.collapse=function(){e.collapsed=!0},e.expand=function(){e.collapsed=!1},e.depth=function(){var n=e.$parentNodeScope;return n?n.depth()+1:1};var o=0;e.maxSubDepth=function(){return o=0,e.$childNodesScope&&t(e.$childNodesScope),o}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodesController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$modelValue=null,e.$nodeScope=null,e.$treeScope=null,e.$type="uiTreeNodes",e.$nodesMap={},e.nodropEnabled=!1,e.maxDepth=0,e.cloneEnabled=!1,e.initSubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=n):null},e.destroySubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=null):null},e.accept=function(n,t){return e.$treeScope.$callbacks.accept(n,e,t)},e.beforeDrag=function(n){return e.$treeScope.$callbacks.beforeDrag(n)},e.isParent=function(n){return n.$parentNodesScope==e},e.hasChild=function(){return e.$modelValue.length>0},e.safeApply=function(e){var n=this.$root.$$phase;"$apply"==n||"$digest"==n?e&&"function"==typeof e&&e():this.$apply(e)},e.removeNode=function(n){var t=e.$modelValue.indexOf(n.$modelValue);return t>-1?(e.safeApply(function(){e.$modelValue.splice(t,1)[0]}),n):null},e.insertNode=function(n,t){e.safeApply(function(){e.$modelValue.splice(n,0,t)})},e.childNodes=function(){var n,t=[];if(e.$modelValue)for(n=0;n<e.$modelValue.length;n++)t.push(e.$nodesMap[e.$modelValue[n].$$hashKey]);return t},e.depth=function(){return e.$nodeScope?e.$nodeScope.depth():0},e.outOfDepth=function(n){var t=e.maxDepth||e.$treeScope.maxDepth;return t>0?e.depth()+n.maxSubDepth()+1>t:!1}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodesScope=null,e.$type="uiTree",e.$emptyElm=null,e.$callbacks=null,e.dragEnabled=!0,e.emptyPlaceholderEnabled=!0,e.maxDepth=0,e.dragDelay=0,e.cloneEnabled=!1,e.nodropEnabled=!1,e.isEmpty=function(){return e.$nodesScope&&e.$nodesScope.$modelValue&&0===e.$nodesScope.$modelValue.length},e.place=function(n){e.$nodesScope.$element.append(n),e.$emptyElm.remove()},this.resetEmptyElement=function(){e.$nodesScope.$modelValue&&0!==e.$nodesScope.$modelValue.length||!e.emptyPlaceholderEnabled?e.$emptyElm.remove():n.append(e.$emptyElm)},e.resetEmptyElement=this.resetEmptyElement;var t=function(e,n){var o,l,r=e.childNodes();for(o=0;o<r.length;o++)n?r[o].collapse():r[o].expand(),l=r[o].$childNodesScope,l&&t(l,n)};e.collapseAll=function(){t(e.$nodesScope,!0)},e.expandAll=function(){t(e.$nodesScope,!1)}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTree",["treeConfig","$window",function(e,n){return{restrict:"A",scope:!0,controller:"TreeController",link:function(t,o,l,r){var i={accept:null,beforeDrag:null},a={};angular.extend(a,e),a.treeClass&&o.addClass(a.treeClass),t.$emptyElm=angular.element(n.document.createElement("div")),a.emptyTreeClass&&t.$emptyElm.addClass(a.emptyTreeClass),t.$watch("$nodesScope.$modelValue.length",function(){t.$nodesScope.$modelValue&&r.resetEmptyElement()},!0),t.$watch(l.dragEnabled,function(e){"boolean"==typeof e&&(t.dragEnabled=e)}),t.$watch(l.emptyPlaceholderEnabled,function(e){"boolean"==typeof e&&(t.emptyPlaceholderEnabled=e,r.resetEmptyElement())}),t.$watch(l.nodropEnabled,function(e){"boolean"==typeof e&&(t.nodropEnabled=e)}),t.$watch(l.cloneEnabled,function(e){"boolean"==typeof e&&(t.cloneEnabled=e)}),t.$watch(l.maxDepth,function(e){"number"==typeof e&&(t.maxDepth=e)}),t.$watch(l.dragDelay,function(e){"number"==typeof e&&(t.dragDelay=e)}),i.accept=function(e,n,t){return!(n.nodropEnabled||n.outOfDepth(e))},i.beforeDrag=function(e){return!0},i.removed=function(e){},i.dropped=function(e){},i.dragStart=function(e){},i.dragMove=function(e){},i.dragStop=function(e){},i.beforeDrop=function(e){},t.$watch(l.uiTree,function(e,n){angular.forEach(e,function(e,n){i[n]&&"function"==typeof e&&(i[n]=e)}),t.$callbacks=i},!0)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeHandle",["treeConfig",function(e){return{require:"^uiTreeNode",restrict:"A",scope:!0,controller:"TreeHandleController",link:function(n,t,o,l){var r={};angular.extend(r,e),r.handleClass&&t.addClass(r.handleClass),n!=l.scope&&(n.$nodeScope=l.scope,l.scope.$handleScope=n)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNode",["treeConfig","UiTreeHelper","$window","$document","$timeout",function(e,n,t,o,l){return{require:["^uiTreeNodes","^uiTree"],restrict:"A",controller:"TreeNodeController",link:function(r,i,a,d){var c,s,u,p,f,h,$,m,g,b,y,v,S,N,E,x,C,w,T,D,X={},Y="ontouchstart"in window,A=null,V=document.body,k=document.documentElement;angular.extend(X,e),X.nodeClass&&i.addClass(X.nodeClass),r.init(d),r.collapsed=!!n.getNodeAttribute(r,"collapsed"),r.sourceOnly=r.nodropEnabled||r.$treeScope.nodropEnabled,r.$watch(a.collapsed,function(e){"boolean"==typeof e&&(r.collapsed=e)}),r.$watch("collapsed",function(e){n.setNodeAttribute(r,"collapsed",e),a.$set("collapsed",e)}),b=function(e){if((Y||2!=e.button&&3!=e.which)&&!(e.uiTreeDragging||e.originalEvent&&e.originalEvent.uiTreeDragging)){var l,a,d,b,y,v=angular.element(e.target),S=v.scope(),C=i.clone();if(S&&S.$type&&!("uiTreeNode"!=S.$type&&"uiTreeHandle"!=S.$type||"uiTreeNode"==S.$type&&S.$handleScope||(l=v.prop("tagName").toLowerCase(),"input"==l||"textarea"==l||"button"==l||"select"==l))){for(;v&&v[0]&&v[0]!=i;){if(n.nodrag(v))return;v=v.parent()}r.beforeDrag(r)&&(e.uiTreeDragging=!0,e.originalEvent&&(e.originalEvent.uiTreeDragging=!0),e.preventDefault(),d=n.eventObj(e),c=!0,s=n.dragInfo(r),r.$apply(function(){r.$treeScope.$callbacks.dragStart(s.eventArgs($,u))}),a=r.$element.prop("tagName"),"tr"===a.toLowerCase()?(p=angular.element(t.document.createElement(a)),b=angular.element(t.document.createElement("td")).addClass(X.placeholderClass),p.append(b)):p=angular.element(t.document.createElement(a)).addClass(X.placeholderClass),f=angular.element(t.document.createElement(a)),X.hiddenClass&&f.addClass(X.hiddenClass),u=n.positionStarted(d,r.$element),p.css("height",n.height(r.$element)+"px"),p.css("width",n.width(r.$element)+"px"),h=angular.element(t.document.createElement(r.$parentNodesScope.$element.prop("tagName"))).addClass(r.$parentNodesScope.$element.attr("class")).addClass(X.dragClass),h.css("width",n.width(r.$element)+"px"),h.css("z-index",9999),y=(r.$element[0].querySelector(".angular-ui-tree-handle")||r.$element[0]).currentStyle,y&&(document.body.setAttribute("ui-tree-cursor",o.find("body").css("cursor")||""),o.find("body").css({cursor:y.cursor+"!important"})),r.sourceOnly&&p.css("display","none"),r.$element.after(p),r.$element.after(f),h.append(s.isClone()&&r.sourceOnly?C:r.$element),o.find("body").append(h),h.css({left:d.pageX-u.offsetX+"px",top:d.pageY-u.offsetY+"px"}),$={placeholder:p,dragging:h},angular.element(o).bind("touchend",E),angular.element(o).bind("touchcancel",E),angular.element(o).bind("touchmove",N),angular.element(o).bind("mouseup",E),angular.element(o).bind("mousemove",N),angular.element(o).bind("mouseleave",x),m=Math.max(V.scrollHeight,V.offsetHeight,k.clientHeight,k.scrollHeight,k.offsetHeight),g=Math.max(V.scrollWidth,V.offsetWidth,k.clientWidth,k.scrollWidth,k.offsetWidth))}}},y=function(e){var o,l,i,a,d,f,b,y,v,S,N,E,x,C,w,T,Y=n.eventObj(e);if(h){if(e.preventDefault(),t.getSelection?t.getSelection().removeAllRanges():t.document.selection&&t.document.selection.empty(),i=Y.pageX-u.offsetX,a=Y.pageY-u.offsetY,0>i&&(i=0),0>a&&(a=0),a+10>m&&(a=m-10),i+10>g&&(i=g-10),h.css({left:i+"px",top:a+"px"}),d=window.pageYOffset||t.document.documentElement.scrollTop,f=d+(window.innerHeight||t.document.clientHeight||t.document.clientHeight),f<Y.pageY&&m>=f&&window.scrollBy(0,10),d>Y.pageY&&window.scrollBy(0,-10),n.positionMoved(e,u,c),c)return void(c=!1);if(y=n.offset(h).left-n.offset(p).left>=X.threshold,v=Y.pageX-t.document.body.scrollLeft,S=Y.pageY-(window.pageYOffset||t.document.documentElement.scrollTop),angular.isFunction(h.hide)?h.hide():(N=h[0].style.display,h[0].style.display="none"),t.document.elementFromPoint(v,S),x=angular.element(t.document.elementFromPoint(v,S)),angular.isFunction(h.show)?h.show():h[0].style.display=N,D=!x.scope().$type,D&&(p.remove(),A&&(A.resetEmptyElement(),A=null)),u.dirAx&&u.distAxX>=X.levelThreshold&&(u.distAxX=0,u.distX>0&&(o=s.prev(),o&&!o.collapsed&&o.accept(r,o.childNodesCount())&&(o.$childNodesScope.$element.append(p),s.moveTo(o.$childNodesScope,o.childNodes(),o.childNodesCount()))),u.distX<0&&(l=s.next(),l||(b=s.parentNode(),b&&b.$parentNodesScope.accept(r,b.index()+1)&&(b.$element.after(p),s.moveTo(b.$parentNodesScope,b.siblings(),b.index()+1))))),!u.dirAx){if(E=x.scope(),C=!1,!E)return;if(!E.$treeScope||E.$parent.nodropEnabled||E.$treeScope.nodropEnabled||p.css("display","block"),"uiTree"==E.$type&&E.dragEnabled&&(C=E.isEmpty()),"uiTreeHandle"==E.$type&&(E=E.$nodeScope),"uiTreeNode"!=E.$type&&!C)return;A&&p.parent()[0]!=A.$element[0]&&(A.resetEmptyElement(),A=null),C?(A=E,E.$nodesScope.accept(r,0)&&(E.place(p),s.moveTo(E.$nodesScope,E.$nodesScope.childNodes(),0))):E.dragEnabled()&&(x=E.$element,w=n.offset(x),T=E.horizontal?Y.pageX<w.left+n.width(x)/2:Y.pageY<w.top+n.height(x)/2,E.$parentNodesScope.accept(r,E.index())?T?(x[0].parentNode.insertBefore(p[0],x[0]),s.moveTo(E.$parentNodesScope,E.siblings(),E.index())):(x.after(p),s.moveTo(E.$parentNodesScope,E.siblings(),E.index()+1)):!T&&E.accept(r,E.childNodesCount())?(E.$childNodesScope.$element.append(p),s.moveTo(E.$childNodesScope,E.childNodes(),E.childNodesCount())):D=!0)}r.$apply(function(){r.$treeScope.$callbacks.dragMove(s.eventArgs($,u))})}},v=function(e){e.preventDefault(),h&&(r.$treeScope.$apply(function(){r.$treeScope.$callbacks.beforeDrop(s.eventArgs($,u))}),f.replaceWith(r.$element),p.remove(),h.remove(),h=null,r.$$apply&&!D?r.$treeScope.$apply(function(){s.apply(),r.$treeScope.$callbacks.dropped(s.eventArgs($,u))}):w(),r.$treeScope.$apply(function(){r.$treeScope.$callbacks.dragStop(s.eventArgs($,u))}),r.$$apply=!1,s=null);var n=document.body.getAttribute("ui-tree-cursor");null!==n&&(o.find("body").css({cursor:n}),document.body.removeAttribute("ui-tree-cursor")),angular.element(o).unbind("touchend",E),angular.element(o).unbind("touchcancel",E),angular.element(o).unbind("touchmove",N),angular.element(o).unbind("mouseup",E),angular.element(o).unbind("mousemove",N),angular.element(t.document.body).unbind("mouseleave",x)},S=function(e){r.dragEnabled()&&b(e)},N=function(e){y(e)},E=function(e){r.$$apply=!0,v(e)},x=function(e){v(e)},C=function(){var e;return{exec:function(n,t){t||(t=0),this.cancel(),e=l(n,t)},cancel:function(){l.cancel(e)}}}(),w=function(){i.bind("touchstart mousedown",function(e){C.exec(function(){S(e)},r.dragDelay||0)}),i.bind("touchend touchcancel mouseup",function(){C.cancel()})},w(),T=function(e){27==e.keyCode&&(r.$$apply=!1,v(e))},angular.element(t.document.body).bind("keydown",T),r.$on("$destroy",function(){angular.element(t.document.body).unbind("keydown",T)})}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNodes",["treeConfig","$window",function(e){return{require:["ngModel","?^uiTreeNode","^uiTree"],restrict:"A",scope:!0,controller:"TreeNodesController",link:function(n,t,o,l){var r={},i=l[0],a=l[1],d=l[2];angular.extend(r,e),r.nodesClass&&t.addClass(r.nodesClass),a?(a.scope.$childNodesScope=n,n.$nodeScope=a.scope):d.scope.$nodesScope=n,n.$treeScope=d.scope,i&&(i.$render=function(){n.$modelValue=i.$modelValue}),n.$watch(o.maxDepth,function(e){"number"==typeof e&&(n.maxDepth=e)}),n.$watch(function(){return o.nodropEnabled},function(e){"undefined"!=typeof e&&(n.nodropEnabled=!0)},!0),o.$observe("horizontal",function(e){n.horizontal="undefined"!=typeof e})}}}])}(),function(){"use strict";angular.module("ui.tree").factory("UiTreeHelper",["$document","$window",function(e,n){return{nodesData:{},setNodeAttribute:function(e,n,t){if(!e.$modelValue)return null;var o=this.nodesData[e.$modelValue.$$hashKey];o||(o={},this.nodesData[e.$modelValue.$$hashKey]=o),o[n]=t},getNodeAttribute:function(e,n){if(!e.$modelValue)return null;var t=this.nodesData[e.$modelValue.$$hashKey];return t?t[n]:null},nodrag:function(e){return"undefined"!=typeof e.attr("data-nodrag")?"false"!==e.attr("data-nodrag"):!1},eventObj:function(e){var n=e;return void 0!==e.targetTouches?n=e.targetTouches.item(0):void 0!==e.originalEvent&&void 0!==e.originalEvent.targetTouches&&(n=e.originalEvent.targetTouches.item(0)),n},dragInfo:function(e){return{source:e,sourceInfo:{cloneModel:e.$treeScope.cloneEnabled===!0?angular.copy(e.$modelValue):void 0,nodeScope:e,index:e.index(),nodesScope:e.$parentNodesScope},index:e.index(),siblings:e.siblings().slice(0),parent:e.$parentNodesScope,moveTo:function(e,n,t){this.parent=e,this.siblings=n.slice(0);var o=this.siblings.indexOf(this.source);o>-1&&(this.siblings.splice(o,1),this.source.index()<t&&t--),this.siblings.splice(t,0,this.source),this.index=t},parentNode:function(){return this.parent.$nodeScope},prev:function(){return this.index>0?this.siblings[this.index-1]:null},next:function(){return this.index<this.siblings.length-1?this.siblings[this.index+1]:null},isClone:function(){return this.source.$treeScope.cloneEnabled===!0},clonedNode:function(e){return angular.copy(e)},isDirty:function(){return this.source.$parentNodesScope!=this.parent||this.source.index()!=this.index},isForeign:function(){return this.source.$treeScope!==this.parent.$treeScope},eventArgs:function(e,n){return{source:this.sourceInfo,dest:{index:this.index,nodesScope:this.parent},elements:e,pos:n}},apply:function(){var e=this.source.$modelValue;this.parent.nodropEnabled||this.parent.$treeScope.nodropEnabled||this.isDirty()&&(this.isClone()&&this.isForeign()?this.parent.insertNode(this.index,angular.copy(e)):(this.source.remove(),this.parent.insertNode(this.index,e)))}}},height:function(e){return e.prop("scrollHeight")},width:function(e){return e.prop("scrollWidth")},offset:function(t){var o=t[0].getBoundingClientRect();return{width:t.prop("offsetWidth"),height:t.prop("offsetHeight"),top:o.top+(n.pageYOffset||e[0].body.scrollTop||e[0].documentElement.scrollTop),left:o.left+(n.pageXOffset||e[0].body.scrollLeft||e[0].documentElement.scrollLeft)}},positionStarted:function(e,n){var t={},o=e.pageX,l=e.pageY;return e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(o=e.originalEvent.touches[0].pageX,l=e.originalEvent.touches[0].pageY),t.offsetX=o-this.offset(n).left,t.offsetY=l-this.offset(n).top,t.startX=t.lastX=o,t.startY=t.lastY=l,t.nowX=t.nowY=t.distX=t.distY=t.dirAx=0,t.dirX=t.dirY=t.lastDirX=t.lastDirY=t.distAxX=t.distAxY=0,t},positionMoved:function(e,n,t){var o,l=e.pageX,r=e.pageY;return e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(l=e.originalEvent.touches[0].pageX,r=e.originalEvent.touches[0].pageY),n.lastX=n.nowX,n.lastY=n.nowY,n.nowX=l,n.nowY=r,n.distX=n.nowX-n.lastX,n.distY=n.nowY-n.lastY,n.lastDirX=n.dirX,n.lastDirY=n.dirY,n.dirX=0===n.distX?0:n.distX>0?1:-1,n.dirY=0===n.distY?0:n.distY>0?1:-1,o=Math.abs(n.distX)>Math.abs(n.distY)?1:0,t?(n.dirAx=o,void(n.moving=!0)):(n.dirAx!==o?(n.distAxX=0,n.distAxY=0):(n.distAxX+=Math.abs(n.distX),0!==n.dirX&&n.dirX!==n.lastDirX&&(n.distAxX=0),n.distAxY+=Math.abs(n.distY),0!==n.dirY&&n.dirY!==n.lastDirY&&(n.distAxY=0)),void(n.dirAx=o))}}}])}();