/*
 * Copyright 2014 Jeanfrancois Arcand
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Atmosphere.js
 * https://github.com/Atmosphere/atmosphere-javascript
 * 
 * API reference
 * https://github.com/Atmosphere/atmosphere/wiki/jQuery.atmosphere.js-API
 * 
 * Highly inspired by 
 * - Portal by Donghwan Kim http://flowersinthesand.github.io/portal/
 */
(function(d,I){"function"===typeof define&&define.amd?define(I):d.atmosphere=I()})(this,function(){var d={},I=!1,n=[],F=[],X=0,aa=Object.prototype.hasOwnProperty,d={onError:function(d){},onClose:function(d){},onOpen:function(d){},onReopen:function(d){},onMessage:function(d){},onReconnect:function(d,l){},onMessagePublished:function(d){},onTransportFailure:function(d,l){},onLocalMessage:function(d){},onFailureToReconnect:function(d,l){},onClientTimeout:function(d){},onOpenAfterResume:function(d){},
WebsocketApiAdapter:function(e){var l,g;e.onMessage=function(d){g.onmessage({data:d.responseBody})};e.onMessagePublished=function(d){g.onmessage({data:d.responseBody})};e.onOpen=function(d){g.onopen(d)};g={close:function(){l.close()},send:function(d){l.push(d)},onmessage:function(d){},onopen:function(d){},onclose:function(d){},onerror:function(d){}};l=new d.subscribe(e);return g},AtmosphereRequest:function(e){function l(){ba=!0;G=!1;z=0;B=K=x=r=null}function g(b){return"debug"==b?"debug"===c.logLevel:
"info"==b?"info"===c.logLevel||"debug"===c.logLevel:"warn"==b?"warn"===c.logLevel||"info"===c.logLevel||"debug"===c.logLevel:"error"==b?"error"===c.logLevel||"warn"===c.logLevel||"info"===c.logLevel||"debug"===c.logLevel:!1}function h(b){g("debug")&&d.util.debug(new Date+" Atmosphere: "+b)}function p(b,a){return""===f.partialMessage&&"streaming"===a.transport&&b.responseText.length>a.maxStreamingLength?!0:!1}function ca(){if(c.enableProtocol&&!c.firstMessage){var b="X-Atmosphere-Transport=close&X-Atmosphere-tracking-id="+
c.uuid;d.util.each(c.headers,function(a,k){var e=d.util.isFunction(k)?k.call(this,c,c,f):k;null!=e&&(b+="&"+encodeURIComponent(a)+"="+encodeURIComponent(e))});var a=c.url.replace(/([?&])_=[^&]*/,b),a=a+(a===c.url?(/\?/.test(c.url)?"&":"?")+b:""),k=new d.AtmosphereRequest({connected:!1});k.attachHeadersAsQueryString=!1;k.dropHeaders=!0;k.url=a;k.contentType="text/plain";k.transport="polling";k.method="GET";k.data="";c.enableXDR&&(k.enableXDR=c.enableXDR);k.async=c.closeAsync;sa("",k)}}function u(){g("debug")&&
d.util.debug("Closing");G=!0;c.reconnectId&&(clearTimeout(c.reconnectId),delete c.reconnectId);c.heartbeatTimer&&clearTimeout(c.heartbeatTimer);c.reconnect=!1;f.request=c;f.state="unsubscribe";f.responseBody="";f.status=408;f.partialMessage="";y();ca();q()}function q(){f.partialMessage="";c.id&&clearTimeout(c.id);c.heartbeatTimer&&clearTimeout(c.heartbeatTimer);null!=B&&(B.close(),B=null);null!=C&&(C.abort(),C=null);null!=K&&(K.abort(),K=null);null!=r&&(r.canSendMessage&&r.close(),r=null);null!=x&&
(x.close(),x=null);null!=D&&(clearInterval(Y),document.cookie=da+"=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/",D.signal("close",{reason:"",heir:G?(D.get("children")||[])[0]:A}),D.close());null!=w&&w.close()}function n(b){q();l();c=d.util.extend(c,b);c.mrequest=c.reconnect;c.reconnect||(c.reconnect=!0)}function L(){if(c.shared){w=ta(c);if(null!=w&&(g("debug")&&d.util.debug("Storage service available. All communication will be local"),w.open(c)))return;g("debug")&&d.util.debug("No Storage service available.");
w=null}c.firstMessage=0==X?!0:!1;c.isOpen=!1;c.ctime=d.util.now();0===c.uuid&&(c.uuid=X);f.closedByClientTimeout=!1;if("websocket"!==c.transport&&"sse"!==c.transport)P(c);else if("websocket"===c.transport)null!=c.webSocketImpl||window.WebSocket||window.MozWebSocket?ea(!1):M("Websocket is not supported, using request.fallbackTransport ("+c.fallbackTransport+")");else if("sse"===c.transport){var b=d.util.getAbsoluteURL(c.url.toLowerCase()),b=/^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+))?)?/.exec(b),
b=!(!b||b[1]==window.location.protocol&&b[2]==window.location.hostname&&(b[3]||("http:"===b[1]?80:443))==(window.location.port||("http:"===window.location.protocol?80:443)));!window.EventSource||b&&d.util.browser.safari&&!(7<=d.util.browser.vmajor)?M("Server Side Events(SSE) is not supported, using request.fallbackTransport ("+c.fallbackTransport+")"):fa(!1)}}function ta(b){function a(a,b){var c,d=a.length;for(c=0;c<d;c++)a[c]===b&&a.splice(c,1);return d!==a.length}function k(a){a=d.util.parseJSON(a);
var k=a.data;if("c"===a.target)switch(a.type){case "open":m("opening","local",c);break;case "close":ga||(ga=!0,"aborted"===k.reason?u():k.heir===A?L():setTimeout(function(){L()},100));break;case "message":N(k,"messageReceived",200,b.transport);break;case "localMessage":la(k)}}function f(){var a=(new RegExp("(?:^|; )("+encodeURIComponent(t)+")=([^;]*)")).exec(document.cookie);if(a)return d.util.parseJSON(decodeURIComponent(a[2]))}var e,g,ga,t="atmosphere-"+b.url,l={storage:function(){function c(a){a.key===
t&&a.newValue&&k(a.newValue)}if(d.util.storage){var f=window.localStorage,e=function(a){return d.util.parseJSON(f.getItem(t+"-"+a))};return{init:function(){var a=e("children").concat([A]);f.setItem(t+"-children",d.util.stringifyJSON(a));d.util.on(window,"storage",c);return e("opened")},signal:function(a,b){f.setItem(t,d.util.stringifyJSON({target:"p",type:a,data:b}))},close:function(){var k=e("children");d.util.off(window,"storage",c);k&&a(k,b.id)&&f.setItem(t+"-children",d.util.stringifyJSON(k))}}}},
windowref:function(){var b=window.open("",t.replace(/\W/g,""));if(b&&!b.closed&&b.callbacks)return{init:function(){b.callbacks.push(k);b.children.push(A);return b.opened},signal:function(a,c){!b.closed&&b.fire&&b.fire(d.util.stringifyJSON({target:"p",type:a,data:c}))},close:function(){ga||(a(b.callbacks,k),a(b.children,A))}}}};if((e=f())&&!(1E3<d.util.now()-e.ts)&&(g=l.storage()||l.windowref()))return{open:function(){var a;Y=setInterval(function(){var a=e;(e=f())&&a.ts!==e.ts||k(d.util.stringifyJSON({target:"c",
type:"close",data:{reason:"error",heir:a.heir}}))},1E3);(a=g.init())&&setTimeout(function(){m("opening","local",b)},50);return a},send:function(a){g.signal("send",a)},localSend:function(a){g.signal("localSend",d.util.stringifyJSON({id:A,event:a}))},close:function(){G||(clearInterval(Y),g.signal("close"),g.close())}}}function ua(){function b(a){a=d.util.parseJSON(a);var b=a.data;if("p"===a.target)switch(a.type){case "send":Q(b);break;case "localSend":la(b);break;case "close":u()}}function a(){document.cookie=
da+"="+encodeURIComponent(d.util.stringifyJSON({ts:d.util.now()+1,heir:(k.get("children")||[])[0]}))+"; path=/"}var k,f="atmosphere-"+c.url,e={storage:function(){function a(c){c.key===f&&c.newValue&&b(c.newValue)}if(d.util.storage){var c=window.localStorage;return{init:function(){d.util.on(window,"storage",a)},signal:function(a,b){c.setItem(f,d.util.stringifyJSON({target:"c",type:a,data:b}))},get:function(a){return d.util.parseJSON(c.getItem(f+"-"+a))},set:function(a,b){c.setItem(f+"-"+a,d.util.stringifyJSON(b))},
close:function(){d.util.off(window,"storage",a);c.removeItem(f);c.removeItem(f+"-opened");c.removeItem(f+"-children")}}}},windowref:function(){var a=f.replace(/\W/g,""),c=document.getElementById(a),k;c||(c=document.createElement("div"),c.id=a,c.style.display="none",c.innerHTML='<iframe name="'+a+'" />',document.body.appendChild(c));k=c.firstChild.contentWindow;return{init:function(){k.callbacks=[b];k.fire=function(a){var b;for(b=0;b<k.callbacks.length;b++)k.callbacks[b](a)}},signal:function(a,b){!k.closed&&
k.fire&&k.fire(d.util.stringifyJSON({target:"c",type:a,data:b}))},get:function(a){return k.closed?null:k[a]},set:function(a,b){k.closed||(k[a]=b)},close:function(){}}}};R=function(a){k.signal("message",a)};k=e.storage()||e.windowref();k.init();g("debug")&&d.util.debug("Installed StorageService "+k);k.set("children",[]);null==k.get("opened")||k.get("opened")||k.set("opened",!1);da=encodeURIComponent(f);a();Y=setInterval(a,1E3);D=k}function m(b,a,k){c.shared&&"local"!==a&&ua();null!=D&&D.set("opened",
!0);k.close=function(){u()};0<z&&"re-connecting"===b?(k.isReopen=!0,va(f)):null==f.error&&(f.request=k,k=f.state,f.state=b,b=f.transport,f.transport=a,a=f.responseBody,y(),f.responseBody=a,f.state=k,f.transport=b)}function ma(b){b.transport="jsonp";var a=c,k;null!=b&&"undefined"!==typeof b&&(a=b);C={open:function(){function e(){a.lastIndex=0;a.openId&&clearTimeout(a.openId);a.heartbeatTimer&&clearTimeout(a.heartbeatTimer);a.reconnect&&z++<a.maxReconnectOnClose?(m("re-connecting",a.transport,a),J(C,
a,b.reconnectInterval),a.openId=setTimeout(function(){S(a)},a.reconnectInterval+1E3)):v(0,"maxReconnectOnClose reached")}function g(){var c=a.url;null!=a.dispatchUrl&&(c+=a.dispatchUrl);var d=a.data;a.attachHeadersAsQueryString&&(c=O(a),""!==d&&(c+="&X-Atmosphere-Post-Body="+encodeURIComponent(d)),d="");d=document.head||document.getElementsByTagName("head")[0]||document.documentElement;k=document.createElement("script");k.src=c+"&jsonpTransport="+l;k.clean=function(){k.clean=k.onerror=k.onload=k.onreadystatechange=
null;k.parentNode&&k.parentNode.removeChild(k);2===++b.scriptCount&&(b.scriptCount=1,e())};k.onload=k.onreadystatechange=function(){h("jsonp.onload");k.readyState&&!/loaded|complete/.test(k.readyState)||k.clean()};k.onerror=function(){h("jsonp.onerror");b.scriptCount=1;k.clean()};d.insertBefore(k,d.firstChild)}var l="atmosphere"+ ++A;window[l]=function(k){h("jsonp.window");b.scriptCount=0;if(a.reconnect&&-1===a.maxRequest||a.requestCount++<a.maxRequest){a.executeCallbackBeforeReconnect||J(C,a,a.pollingInterval);
if(null!=k&&"string"!==typeof k)try{k=k.message}catch(e){}H(k,a,f)||N(f.responseBody,"messageReceived",200,a.transport);a.executeCallbackBeforeReconnect&&J(C,a,a.pollingInterval);E(a)}else d.util.log(c.logLevel,["JSONP reconnect maximum try reached "+c.requestCount]),v(0,"maxRequest reached")};setTimeout(function(){g()},50)},abort:function(){k&&k.clean&&k.clean()}};C.open()}function aa(b){return null!=c.webSocketImpl?c.webSocketImpl:window.WebSocket?new WebSocket(b):new MozWebSocket(b)}function fa(b){f.transport=
"sse";var a=O(c);g("debug")&&(d.util.debug("Invoking executeSSE"),d.util.debug("Using URL: "+a));if(b&&!c.reconnect)null!=x&&q();else{try{x=new EventSource(a,{withCredentials:c.withCredentials})}catch(k){v(0,k);M("SSE failed. Downgrading to fallback transport and resending");return}0<c.connectTimeout&&(c.id=setTimeout(function(){b||q()},c.connectTimeout));x.onopen=function(a){h("sse.onopen");E(c);g("debug")&&d.util.debug("SSE successfully opened");c.enableProtocol?c.isReopen&&(c.isReopen=!1,m("re-opening",
c.transport,c)):b?m("re-opening","sse",c):m("opening","sse",c);b=!0;"POST"===c.method&&(f.state="messageReceived",x.send(c.data))};x.onmessage=function(a){h("sse.onmessage");E(c);!c.enableXDR&&a.origin&&a.origin!==window.location.protocol+"//"+window.location.host?d.util.log(c.logLevel,["Origin was not "+window.location.protocol+"//"+window.location.host]):(f.state="messageReceived",f.status=200,a=a.data,H(a,c,f)||(y(),f.responseBody="",f.messages=[]))};x.onerror=function(a){h("sse.onerror");clearTimeout(c.id);
c.heartbeatTimer&&clearTimeout(c.heartbeatTimer);f.closedByClientTimeout||((T(b),q(),G)?d.util.log(c.logLevel,["SSE closed normally"]):b?c.reconnect&&"sse"===f.transport&&(z++<c.maxReconnectOnClose?(m("re-connecting",c.transport,c),0<c.reconnectInterval?c.reconnectId=setTimeout(function(){fa(!0)},c.reconnectInterval):fa(!0),f.responseBody="",f.messages=[]):(d.util.log(c.logLevel,["SSE reconnect maximum try reached "+z]),v(0,"maxReconnectOnClose reached"))):M("SSE failed. Downgrading to fallback transport and resending"))}}}
function ea(b){f.transport="websocket";var a=O(c,d.util.getAbsoluteURL(c.webSocketUrl||c.url)).replace(/^http/,"ws");g("debug")&&(d.util.debug("Invoking executeWebSocket"),d.util.debug("Using URL: "+a));if(b&&!c.reconnect)null!=r&&q();else if(r=aa(a),null!=c.webSocketBinaryType&&(r.binaryType=c.webSocketBinaryType),0<c.connectTimeout&&(c.id=setTimeout(function(){if(!b){r.onclose({code:1002,reason:"",wasClean:!1});try{q()}catch(a){}}},c.connectTimeout)),r.onopen=function(a){h("websocket.onopen");E(c);
I=!1;g("debug")&&d.util.debug("Websocket successfully opened");a=b;null!=r&&(r.canSendMessage=!0);c.enableProtocol||(b=!0,a?m("re-opening","websocket",c):m("opening","websocket",c));null!=r&&"POST"===c.method&&(f.state="messageReceived",r.send(c.data))},r.onmessage=function(a){h("websocket.onmessage");E(c);c.enableProtocol&&(b=!0);f.state="messageReceived";f.status=200;a=a.data;"string"===typeof a?H(a,c,f)||(y(),f.responseBody="",f.messages=[]):(a=na(c,a),""!==a&&(f.responseBody=a,y(),f.responseBody=
null))},r.onerror=function(a){h("websocket.onerror");clearTimeout(c.id);c.heartbeatTimer&&clearTimeout(c.heartbeatTimer)},r.onclose=function(a){h("websocket.onclose");clearTimeout(c.id);if("closed"!==f.state){var e=a.reason;if(""===e)switch(a.code){case 1E3:e="Normal closure; the connection successfully completed whatever purpose for which it was created.";break;case 1001:e="The endpoint is going away, either because of a server failure or because the browser is navigating away from the page that opened the connection.";
break;case 1002:e="The endpoint is terminating the connection due to a protocol error.";break;case 1003:e="The connection is being terminated because the endpoint received data of a type it cannot accept (for example, a text-only endpoint received binary data).";break;case 1004:e="The endpoint is terminating the connection because a data frame was received that is too large.";break;case 1005:e="Unknown: no status code was provided even though one was expected.";break;case 1006:e="Connection was closed abnormally (that is, with no close frame being sent)."}g("warn")&&
(d.util.warn("Websocket closed, reason: "+e),d.util.warn("Websocket closed, wasClean: "+a.wasClean));f.closedByClientTimeout||I?c.reconnectId&&(clearTimeout(c.reconnectId),delete c.reconnectId):(T(b),f.state="closed",G)?d.util.log(c.logLevel,["Websocket closed normally"]):b?c.reconnect&&"websocket"===f.transport&&1001!==a.code&&(q(),z++<c.maxReconnectOnClose?(m("re-connecting",c.transport,c),0<c.reconnectInterval?c.reconnectId=setTimeout(function(){f.responseBody="";f.messages=[];ea(!0)},c.reconnectInterval):
(f.responseBody="",f.messages=[],ea(!0))):(d.util.log(c.logLevel,["Websocket reconnect maximum try reached "+c.requestCount]),g("warn")&&d.util.warn("Websocket error, reason: "+a.reason),v(0,"maxReconnectOnClose reached"))):M("Websocket failed. Downgrading to Comet and resending")}},-1<navigator.userAgent.toLowerCase().indexOf("android")&&void 0===r.url)r.onclose({reason:"Android 4.1 does not support websockets.",wasClean:!1})}function na(b,a){var k=a;if("polling"===b.transport)return k;if(b.enableProtocol&&
b.firstMessage&&0!==d.util.trim(a).length){var f=b.trackMessageLength?1:0,e=a.split(b.messageDelimiter);if(e.length<=f+1)return k;b.firstMessage=!1;b.uuid=d.util.trim(e[f]);e.length<=f+2&&d.util.log("error",["Protocol data not sent by the server. If you enable protocol on client side, be sure to install JavascriptProtocol interceptor on server side.Also note that atmosphere-runtime 2.2+ should be used."]);U=parseInt(d.util.trim(e[f+1]),10);ha=e[f+2];"long-polling"!==b.transport&&S(b);X=b.uuid;k="";
f=b.trackMessageLength?4:3;if(e.length>f+1)for(;f<e.length;f++)k+=e[f],f+1!==e.length&&(k+=b.messageDelimiter);0!==b.ackInterval&&setTimeout(function(){Q("...ACK...")},b.ackInterval)}else b.enableProtocol&&b.firstMessage&&d.util.browser.msie&&10>+d.util.browser.version.split(".")[0]?d.util.log(c.logLevel,["Receiving unexpected data from IE"]):S(b);return k}function E(b){clearTimeout(b.id);0<b.timeout&&"polling"!==b.transport&&(b.id=setTimeout(function(){f.closedByClientTimeout=!0;f.state="closedByClient";
f.responseBody="";f.status=408;f.messages=[];y();ca();q()},b.timeout))}function v(b,a){q();clearTimeout(c.id);f.state="error";f.reasonPhrase=a;f.responseBody="";f.status=b;f.messages=[];y()}function H(b,a,c){b=na(a,b);if(0===b.length)return!0;c.responseBody=b;if(a.trackMessageLength){b=c.partialMessage+b;var d=[],f=b.indexOf(a.messageDelimiter);if(-1!=f){for(;-1!==f;){var e=b.substring(0,f),g=+e;if(isNaN(g))throw Error('message length "'+e+'" is not a number');f+=a.messageDelimiter.length;f+g>b.length?
f=-1:(d.push(b.substring(f,f+g)),b=b.substring(f+g,b.length),f=b.indexOf(a.messageDelimiter))}c.partialMessage=b;if(0!==d.length)return c.responseBody=d.join(a.messageDelimiter),c.messages=d,!1;c.responseBody="";c.messages=[];return!0}}c.responseBody=b;c.messages=[b];return!1}function M(b){d.util.log(c.logLevel,[b]);if("undefined"!==typeof c.onTransportFailure)c.onTransportFailure(b,c);else if("undefined"!==typeof d.util.onTransportFailure)d.util.onTransportFailure(b,c);c.transport=c.fallbackTransport;
b=-1===c.connectTimeout?0:c.connectTimeout;c.reconnect&&"none"!==c.transport||null==c.transport?(c.method=c.fallbackMethod,f.transport=c.fallbackTransport,c.fallbackTransport="none",0<b?c.reconnectId=setTimeout(function(){L()},b):L()):v(500,"Unable to reconnect with fallback transport")}function O(b,a){var e=c;null!=b&&"undefined"!==typeof b&&(e=b);null==a&&(a=e.url);if(!e.attachHeadersAsQueryString||-1!==a.indexOf("X-Atmosphere-Framework"))return a;a+=-1!==a.indexOf("?")?"&":"?";a+="X-Atmosphere-tracking-id="+
e.uuid;a+="&X-Atmosphere-Framework=2.2.7-javascript";a+="&X-Atmosphere-Transport="+e.transport;e.trackMessageLength&&(a+="&X-Atmosphere-TrackMessageSize=true");null!==e.heartbeat&&null!==e.heartbeat.server&&(a+="&X-Heartbeat-Server="+e.heartbeat.server);""!==e.contentType&&(a+="&Content-Type="+("websocket"===e.transport?e.contentType:encodeURIComponent(e.contentType)));e.enableProtocol&&(a+="&X-atmo-protocol=true");d.util.each(e.headers,function(c,g){var l=d.util.isFunction(g)?g.call(this,e,b,f):
g;null!=l&&(a+="&"+encodeURIComponent(c)+"="+encodeURIComponent(l))});return a}function S(b){if(b.isOpen)if(b.isReopen)b.isReopen=!1,m("re-opening",b.transport,b);else{if("messageReceived"!==f.state||"jsonp"!==b.transport&&"long-polling"!==b.transport)return;var a=f;a.state="openAfterResume";ia(a);a.state="messageReceived"}else b.isOpen=!0,m("opening",b.transport,b);wa(b)}function wa(b){null!=b.heartbeatTimer&&clearTimeout(b.heartbeatTimer);if(!isNaN(U)&&0<U){var a=function(){g("debug")&&d.util.debug("Sending heartbeat");
Q(ha);b.heartbeatTimer=setTimeout(a,U)};b.heartbeatTimer=setTimeout(a,U)}}function P(b){var a=c;if(null!=b||"undefined"!==typeof b)a=b;a.lastIndex=0;a.readyState=0;if("jsonp"===a.transport||a.enableXDR&&d.util.checkCORSSupport())ma(a);else{if(d.util.browser.msie&&10>+d.util.browser.version.split(".")[0]){if("streaming"===a.transport){a.enableXDR&&window.XDomainRequest?V(a):W(a);return}if(a.enableXDR&&window.XDomainRequest){V(a);return}}var e=function(c){a.lastIndex=0;c||a.reconnect&&z++<a.maxReconnectOnClose?
(f.ffTryingReconnect=!0,m("re-connecting",b.transport,b),J(g,a,b.reconnectInterval)):v(0,"maxReconnectOnClose reached")};if(a.force||a.reconnect&&(-1===a.maxRequest||a.requestCount++<a.maxRequest)){a.force=!1;var g=d.util.xhr();g.hasData=!1;xa(g,a,!0);a.suspend&&(K=g);"polling"!==a.transport&&(f.transport=a.transport,g.onabort=function(){h("ajaxrequest.onabort");T(!0)},g.onerror=function(){h("ajaxrequest.onerror");f.error=!0;f.ffTryingReconnect=!0;try{f.status=XMLHttpRequest.status}catch(a){f.status=
500}f.status||(f.status=500);f.errorHandled||(q(),e(!1))});g.onreadystatechange=function(){h("ajaxRequest.onreadystatechange, new state: "+g.readyState);if(!G){f.error=null;var l=!1,m=!1;if("streaming"===a.transport&&2<a.readyState&&4===g.readyState)q(),e(!1);else{a.readyState=g.readyState;"streaming"===a.transport&&3<=g.readyState?m=!0:"long-polling"===a.transport&&4===g.readyState&&(m=!0);E(c);if("polling"!==a.transport){var t=200;4===g.readyState&&(t=1E3<g.status?0:g.status);if(!a.reconnectOnServerError&&
300<=t&&600>t){v(t,g.statusText);return}if(300<=t||0===t){f.errorHandled=!0;q();e(!1);return}a.enableProtocol&&b.firstMessage||2!==g.readyState||(d.util.browser.mozilla&&f.ffTryingReconnect?(f.ffTryingReconnect=!1,setTimeout(function(){f.ffTryingReconnect||S(a)},500)):S(a))}else 4===g.readyState&&(m=!0);if(m)if(m=g.responseText,f.errorHandled=!1,"long-polling"===a.transport&&0===d.util.trim(m).length)g.hasData?g.hasData=!1:e(!0);else{g.hasData=!0;ja(g,c);if("streaming"===a.transport)if(d.util.browser.opera)d.util.iterate(function(){if(500!==
f.status&&g.responseText.length>a.lastIndex){try{f.status=g.status,f.headers=d.util.parseHeaders(g.getAllResponseHeaders()),ja(g,c)}catch(b){f.status=404}E(c);f.state="messageReceived";var e=g.responseText.substring(a.lastIndex);a.lastIndex=g.responseText.length;(l=H(e,a,f))||y();p(g,a)&&oa(g,a)}else if(400<f.status)return a.lastIndex=g.responseText.length,!1},0);else{if(t=m.substring(a.lastIndex,m.length),l=H(t,a,f),a.lastIndex=m.length,l)return}else l=H(m,a,f);m=p(g,a);try{f.status=g.status,f.headers=
d.util.parseHeaders(g.getAllResponseHeaders()),ja(g,a)}catch(u){f.status=404}f.state=a.suspend?0===f.status?"closed":"messageReceived":"messagePublished";(t=!m&&"streaming"!==b.transport&&"polling"!==b.transport)&&!a.executeCallbackBeforeReconnect&&J(g,a,a.pollingInterval);0===f.responseBody.length||l||y();t&&a.executeCallbackBeforeReconnect&&J(g,a,a.pollingInterval);m&&oa(g,a)}}}};try{g.send(a.data),ba=!0}catch(l){d.util.log(a.logLevel,["Unable to connect to "+a.url]),v(0,l)}}else"debug"===a.logLevel&&
d.util.log(a.logLevel,["Max re-connection reached."]),v(0,"maxRequest reached")}}function oa(b,a){f.messages=[];a.isReopen=!0;u();G=!1;J(b,a,500)}function xa(b,a,e){var g=a.url;null!=a.dispatchUrl&&"POST"===a.method&&(g+=a.dispatchUrl);g=O(a,g);g=d.util.prepareURL(g);e&&(b.open(a.method,g,a.async),0<a.connectTimeout&&(a.id=setTimeout(function(){0===a.requestCount&&(q(),N("Connect timeout","closed",200,a.transport))},a.connectTimeout)));c.withCredentials&&"websocket"!==c.transport&&"withCredentials"in
b&&(b.withCredentials=!0);c.dropHeaders||(b.setRequestHeader("X-Atmosphere-Framework",d.util.version),b.setRequestHeader("X-Atmosphere-Transport",a.transport),null!==a.heartbeat&&null!==a.heartbeat.server&&b.setRequestHeader("X-Heartbeat-Server",b.heartbeat.server),a.trackMessageLength&&b.setRequestHeader("X-Atmosphere-TrackMessageSize","true"),b.setRequestHeader("X-Atmosphere-tracking-id",a.uuid),d.util.each(a.headers,function(c,g){var l=d.util.isFunction(g)?g.call(this,b,a,e,f):g;null!=l&&b.setRequestHeader(c,
l)}));""!==a.contentType&&b.setRequestHeader("Content-Type",a.contentType)}function J(b,a,e){if(!f.closedByClientTimeout&&(a.reconnect||a.suspend&&ba)){var d=0;b&&1<b.readyState&&(d=1E3<b.status?0:b.status);f.status=0===d?204:d;f.reason=0===d?"Server resumed the connection or down.":"OK";clearTimeout(a.id);a.reconnectId&&(clearTimeout(a.reconnectId),delete a.reconnectId);0<e?c.reconnectId=setTimeout(function(){P(a)},e):P(a)}}function va(b){b.state="re-connecting";ia(b)}function V(b){"polling"!==b.transport?
(B=pa(b),B.open()):pa(b).open()}function pa(b){var a=c;null!=b&&"undefined"!==typeof b&&(a=b);var e=a.transport,g=0,l=new window.XDomainRequest,h=function(){"long-polling"===a.transport&&a.reconnect&&(-1===a.maxRequest||a.requestCount++<a.maxRequest)&&(l.status=200,V(a))},u=a.rewriteURL||function(a){var b=/(?:^|;\s*)(JSESSIONID|PHPSESSID)=([^;]*)/.exec(document.cookie);switch(b&&b[1]){case "JSESSIONID":return a.replace(/;jsessionid=[^\?]*|(\?)|$/,";jsessionid="+b[2]+"$1");case "PHPSESSID":return a.replace(/\?PHPSESSID=[^&]*&?|\?|$/,
"?PHPSESSID="+b[2]+"&").replace(/&$/,"")}return a};l.onprogress=function(){clearTimeout(a.id);var b=l.responseText,b=b.substring(g);g+=b.length;if("polling"!==e){E(a);var c=H(b,a,f);if("long-polling"!==e||0!==d.util.trim(b).length)a.executeCallbackBeforeReconnect&&h(),c||N(f.responseBody,"messageReceived",200,e),a.executeCallbackBeforeReconnect||h()}};l.onerror=function(){"polling"!==a.transport&&(q(),z++<a.maxReconnectOnClose?0<a.reconnectInterval?a.reconnectId=setTimeout(function(){m("re-connecting",
b.transport,b);V(a)},a.reconnectInterval):(m("re-connecting",b.transport,b),V(a)):v(0,"maxReconnectOnClose reached"))};l.onload=function(){};return{open:function(){var b=a.url;null!=a.dispatchUrl&&(b+=a.dispatchUrl);b=O(a,b);l.open(a.method,u(b));"GET"===a.method?l.send():l.send(a.data);0<a.connectTimeout&&(a.id=setTimeout(function(){0===a.requestCount&&(q(),N("Connect timeout","closed",200,a.transport))},a.connectTimeout))},close:function(){l.abort()}}}function W(b){B=ya(b);B.open()}function ya(b){var a=
c;null!=b&&"undefined"!==typeof b&&(a=b);var e,g=new window.ActiveXObject("htmlfile");g.open();g.close();var l=a.url;null!=a.dispatchUrl&&(l+=a.dispatchUrl);"polling"!==a.transport&&(f.transport=a.transport);return{open:function(){var b=g.createElement("iframe");l=O(a);""!==a.data&&(l+="&X-Atmosphere-Post-Body="+encodeURIComponent(a.data));l=d.util.prepareURL(l);b.src=l;g.body.appendChild(b);var h=b.contentDocument||b.contentWindow.document;e=d.util.iterate(function(){try{if(h.firstChild){var b=h.body?
h.body.lastChild:h,l=function(){var a=b.cloneNode(!0);a.appendChild(h.createTextNode("."));a=a.innerText;return a=a.substring(0,a.length-1)};if(!h.body||!h.body.firstChild||"pre"!==h.body.firstChild.nodeName.toLowerCase()){var u=h.head||h.getElementsByTagName("head")[0]||h.documentElement||h,q=h.createElement("script");q.text="document.write('<plaintext>')";u.insertBefore(q,u.firstChild);u.removeChild(q);b=h.body.lastChild}a.closed&&(a.isReopen=!0);e=d.util.iterate(function(){var e=l();if(e.length>
a.lastIndex){E(c);f.status=200;f.error=null;b.innerText="";if(H(e,a,f))return"";N(f.responseBody,"messageReceived",200,a.transport)}a.lastIndex=0;if("complete"===h.readyState)return T(!0),m("re-connecting",a.transport,a),0<a.reconnectInterval?a.reconnectId=setTimeout(function(){W(a)},a.reconnectInterval):W(a),!1},null);return!1}}catch(p){return f.error=!0,m("re-connecting",a.transport,a),z++<a.maxReconnectOnClose?0<a.reconnectInterval?a.reconnectId=setTimeout(function(){W(a)},a.reconnectInterval):
W(a):v(0,"maxReconnectOnClose reached"),g.execCommand("Stop"),g.close(),!1}})},close:function(){e&&e();g.execCommand("Stop");T(!0)}}}function Q(b){null!=w?w.send(b):null!=K||null!=x?Z(b):null!=B?c.enableXDR&&d.util.checkCORSSupport()?(b=ka(b),b.reconnect=!1,ma(b)):Z(b):null!=C?Z(b):null!=r?za(b):(v(0,"No suspended connection available"),d.util.error("No suspended connection available. Make sure atmosphere.subscribe has been called and request.onOpen invoked before trying to push data"))}function sa(b,
a){a||(a=ka(b));a.transport="polling";a.method="GET";a.withCredentials=!1;a.reconnect=!1;a.force=!0;a.suspend=!1;a.timeout=1E3;P(a)}function Z(b){b=ka(b);P(b)}function qa(b){var a=b;"object"===typeof a&&(a=b.data);return a}function ka(b){var a=qa(b),a={connected:!1,timeout:6E4,method:"POST",url:c.url,contentType:c.contentType,headers:c.headers,reconnect:!0,callback:null,data:a,suspend:!1,maxRequest:-1,logLevel:"info",requestCount:0,withCredentials:c.withCredentials,async:c.async,transport:"polling",
isOpen:!0,attachHeadersAsQueryString:!0,enableXDR:c.enableXDR,uuid:c.uuid,dispatchUrl:c.dispatchUrl,enableProtocol:!1,messageDelimiter:"|",trackMessageLength:c.trackMessageLength,maxReconnectOnClose:c.maxReconnectOnClose,heartbeatTimer:c.heartbeatTimer,heartbeat:c.heartbeat};"object"===typeof b&&(a=d.util.extend(a,b));return a}function za(b){var a=d.util.isBinary(b)?b:qa(b),e;try{e=null!=c.dispatchUrl?c.webSocketPathDelimiter+c.dispatchUrl+c.webSocketPathDelimiter+a:a,r.canSendMessage?r.send(e):d.util.error("WebSocket not connected.")}catch(f){r.onclose=
function(a){},q(),M("Websocket failed. Downgrading to Comet and resending "+b),Z(b)}}function la(b){b=d.util.parseJSON(b);if(b.id!==A)if("undefined"!==typeof c.onLocalMessage)c.onLocalMessage(b.event);else if("undefined"!==typeof d.util.onLocalMessage)d.util.onLocalMessage(b.event)}function N(b,a,c,e){f.responseBody=b;f.transport=e;f.status=c;f.state=a;y()}function ja(b,a){if(a.readResponsesHeaders)try{var c=b.getResponseHeader("X-Atmosphere-tracking-id");c&&null!=c&&(a.uuid=c.split(" ").pop())}catch(e){}else a.enableProtocol||
(a.uuid=A)}function ia(b){ra(b,c);ra(b,d.util)}function ra(b,a){switch(b.state){case "messageReceived":h("Firing onMessage");z=0;if("undefined"!==typeof a.onMessage)a.onMessage(b);if("undefined"!==typeof a.onmessage)a.onmessage(b);break;case "error":h("Firing onError");if("undefined"!==typeof a.onError)a.onError(b);if("undefined"!==typeof a.onerror)a.onerror(b);break;case "opening":delete c.closed;h("Firing onOpen");if("undefined"!==typeof a.onOpen)a.onOpen(b);if("undefined"!==typeof a.onopen)a.onopen(b);
break;case "messagePublished":h("Firing messagePublished");if("undefined"!==typeof a.onMessagePublished)a.onMessagePublished(b);break;case "re-connecting":h("Firing onReconnect");if("undefined"!==typeof a.onReconnect)a.onReconnect(c,b);break;case "closedByClient":h("Firing closedByClient");if("undefined"!==typeof a.onClientTimeout)a.onClientTimeout(c);break;case "re-opening":delete c.closed;h("Firing onReopen");if("undefined"!==typeof a.onReopen)a.onReopen(c,b);break;case "fail-to-reconnect":h("Firing onFailureToReconnect");
if("undefined"!==typeof a.onFailureToReconnect)a.onFailureToReconnect(c,b);break;case "unsubscribe":case "closed":if("undefined"!==typeof c.closed&&c.closed)h("Closed but not firing onClose");else{h("Firing onClose");if("undefined"!==typeof a.onClose)a.onClose(b);if("undefined"!==typeof a.onclose)a.onclose(b)}c.closed=!0;break;case "openAfterResume":if("undefined"!==typeof a.onOpenAfterResume)a.onOpenAfterResume(c)}}function T(b){"closed"!==f.state&&(f.state="closed",f.responseBody="",f.messages=
[],f.status=b?200:501,y())}function y(){var b=function(a,b){b(f)};null==w&&null!=R&&R(f.responseBody);c.reconnect=c.mrequest;for(var a="string"===typeof f.responseBody,e=a&&c.trackMessageLength?0<f.messages.length?f.messages:[""]:Array(f.responseBody),l=0;l<e.length;l++)if(!(1<e.length&&0===e[l].length||(f.responseBody=a?d.util.trim(e[l]):e[l],null==w&&null!=R&&R(f.responseBody),(0===f.responseBody.length||a&&ha===f.responseBody)&&"messageReceived"===f.state))){ia(f);if(0<F.length){g("debug")&&d.util.debug("Invoking "+
F.length+" global callbacks: "+f.state);try{d.util.each(F,b)}catch(h){d.util.log(c.logLevel,["Callback exception"+h])}}if("function"===typeof c.callback){g("debug")&&d.util.debug("Invoking request callbacks");try{c.callback(f)}catch(m){d.util.log(c.logLevel,["Callback exception"+m])}}}}var c={timeout:3E5,method:"GET",headers:{},contentType:"",callback:null,url:"",data:"",suspend:!0,maxRequest:-1,reconnect:!0,maxStreamingLength:1E7,lastIndex:0,logLevel:"info",requestCount:0,fallbackMethod:"GET",fallbackTransport:"streaming",
transport:"long-polling",webSocketImpl:null,webSocketBinaryType:null,dispatchUrl:null,webSocketPathDelimiter:"@@",enableXDR:!1,rewriteURL:!1,attachHeadersAsQueryString:!0,executeCallbackBeforeReconnect:!1,readyState:0,withCredentials:!1,trackMessageLength:!1,messageDelimiter:"|",connectTimeout:-1,reconnectInterval:0,dropHeaders:!0,uuid:0,async:!0,shared:!1,readResponsesHeaders:!1,maxReconnectOnClose:5,enableProtocol:!0,pollingInterval:0,heartbeat:{client:null,server:null},ackInterval:0,closeAsync:!1,
reconnectOnServerError:!0,onError:function(b){},onClose:function(b){},onOpen:function(b){},onMessage:function(b){},onReopen:function(b,a){},onReconnect:function(b,a){},onMessagePublished:function(b){},onTransportFailure:function(b,a){},onLocalMessage:function(b){},onFailureToReconnect:function(b,a){},onClientTimeout:function(b){},onOpenAfterResume:function(b){}},f={status:200,reasonPhrase:"OK",responseBody:"",messages:[],headers:[],state:"messageReceived",transport:"polling",error:null,request:null,
partialMessage:"",errorHandled:!1,closedByClientTimeout:!1,ffTryingReconnect:!1},r=null,x=null,K=null,B=null,C=null,ba=!0,z=0,U=0,ha=" ",G=!1,R=null,D,w=null,A=d.util.now(),Y,da;n(e);this.subscribe=function(b){n(b);L()};this.execute=function(){L()};this.close=function(){u()};this.disconnect=function(){ca()};this.getUrl=function(){return c.url};this.push=function(b,a){if(null!=a){var e=c.dispatchUrl;c.dispatchUrl=a;Q(b);c.dispatchUrl=e}else Q(b)};this.getUUID=function(){return c.uuid};this.pushLocal=
function(b){if(0!==b.length)try{w?w.localSend(b):D&&D.signal("localMessage",d.util.stringifyJSON({id:A,event:b}))}catch(a){d.util.error(a)}};this.enableProtocol=function(b){return c.enableProtocol};this.init=function(){l()};this.request=c;this.response=f},subscribe:function(e,l,g){"function"===typeof l&&d.addCallback(l);"string"!==typeof e?g=e:g.url=e;X="undefined"!==typeof g&&"undefined"!==typeof g.uuid?g.uuid:0;e=new d.AtmosphereRequest(g);e.execute();return n[n.length]=e},unsubscribe:function(){if(0<
n.length)for(var e=[].concat(n),d=0;d<e.length;d++){var g=e[d];g.close();clearTimeout(g.response.request.id);g.heartbeatTimer&&clearTimeout(g.heartbeatTimer)}n=[];F=[]},unsubscribeUrl:function(e){var d=-1;if(0<n.length)for(var g=0;g<n.length;g++){var h=n[g];if(h.getUrl()===e){h.close();clearTimeout(h.response.request.id);h.heartbeatTimer&&clearTimeout(h.heartbeatTimer);d=g;break}}0<=d&&n.splice(d,1)},addCallback:function(e){-1===d.util.inArray(e,F)&&F.push(e)},removeCallback:function(e){e=d.util.inArray(e,
F);-1!==e&&F.splice(e,1)},util:{browser:{},parseHeaders:function(e){for(var d,g=/^(.*?):[ \t]*([^\r\n]*)\r?$/mg,h={};d=g.exec(e);)h[d[1]]=d[2];return h},now:function(){return(new Date).getTime()},isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)},inArray:function(e,d){if(!Array.prototype.indexOf){for(var g=d.length,h=0;h<g;++h)if(d[h]===e)return h;return-1}return d.indexOf(e)},isBinary:function(e){return/^\[object\s(?:Blob|ArrayBuffer|.+Array)\]$/.test(Object.prototype.toString.call(e))},
isFunction:function(e){return"[object Function]"===Object.prototype.toString.call(e)},getAbsoluteURL:function(e){var d=document.createElement("div");d.innerHTML='<a href="'+e+'"/>';return encodeURI(decodeURI(d.firstChild.href))},prepareURL:function(e){var l=d.util.now(),g=e.replace(/([?&])_=[^&]*/,"$1_="+l);return g+(g===e?(/\?/.test(e)?"&":"?")+"_="+l:"")},trim:function(e){return String.prototype.trim?e.toString().trim():e.toString().replace(/(?:(?:^|\n)\s+|\s+(?:$|\n))/g,"").replace(/\s+/g," ")},
param:function(e){function l(e,g){g=d.util.isFunction(g)?g():null==g?"":g;p.push(encodeURIComponent(e)+"="+encodeURIComponent(g))}function g(e,h){var q;if(d.util.isArray(h))d.util.each(h,function(d,h){/\[\]$/.test(e)?l(e,h):g(e+"["+("object"===typeof h?d:"")+"]",h)});else if("[object Object]"===Object.prototype.toString.call(h))for(q in h)g(e+"["+q+"]",h[q]);else l(e,h)}var h,p=[];for(h in e)g(h,e[h]);return p.join("&").replace(/%20/g,"+")},storage:function(){try{return!(!window.localStorage||!window.StorageEvent)}catch(e){return!1}},
iterate:function(e,d){var g;d=d||0;(function p(){g=setTimeout(function(){!1!==e()&&p()},d)})();return function(){clearTimeout(g)}},each:function(e,l,g){if(e){var h,p=0,n=e.length;h=d.util.isArray(e);if(g)if(h)for(;p<n&&(h=l.apply(e[p],g),!1!==h);p++);else for(p in e){if(h=l.apply(e[p],g),!1===h)break}else if(h)for(;p<n&&(h=l.call(e[p],p,e[p]),!1!==h);p++);else for(p in e)if(h=l.call(e[p],p,e[p]),!1===h)break;return e}},extend:function(e){var d,g,h;for(d=1;d<arguments.length;d++)if(null!=(g=arguments[d]))for(h in g)e[h]=
g[h];return e},on:function(e,d,g){e.addEventListener?e.addEventListener(d,g,!1):e.attachEvent&&e.attachEvent("on"+d,g)},off:function(e,d,g){e.removeEventListener?e.removeEventListener(d,g,!1):e.detachEvent&&e.detachEvent("on"+d,g)},log:function(d,l){if(window.console){var g=window.console[d];"function"===typeof g&&g.apply(window.console,l)}},warn:function(){d.util.log("warn",arguments)},info:function(){d.util.log("info",arguments)},debug:function(){d.util.log("debug",arguments)},error:function(){d.util.log("error",
arguments)},xhr:function(){try{return new window.XMLHttpRequest}catch(d){try{return new window.ActiveXObject("Microsoft.XMLHTTP")}catch(l){}}},parseJSON:function(d){return d?window.JSON&&window.JSON.parse?window.JSON.parse(d):(new Function("return "+d))():null},stringifyJSON:function(d){function l(d){return'"'+d.replace(h,function(d){var e=p[d];return"string"===typeof e?e:"\\u"+("0000"+d.charCodeAt(0).toString(16)).slice(-4)})+'"'}function g(d){return 10>d?"0"+d:d}var h=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
p={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"};return window.JSON&&window.JSON.stringify?window.JSON.stringify(d):function u(d,e){var h,p,n,m=e[d];n=typeof m;m&&"object"===typeof m&&"function"===typeof m.toJSON&&(m=m.toJSON(d),n=typeof m);switch(n){case "string":return l(m);case "number":return isFinite(m)?String(m):"null";case "boolean":return String(m);case "object":if(!m)return"null";switch(Object.prototype.toString.call(m)){case "[object Date]":return isFinite(m.valueOf())?
'"'+m.getUTCFullYear()+"-"+g(m.getUTCMonth()+1)+"-"+g(m.getUTCDate())+"T"+g(m.getUTCHours())+":"+g(m.getUTCMinutes())+":"+g(m.getUTCSeconds())+'Z"':"null";case "[object Array]":p=m.length;n=[];for(h=0;h<p;h++)n.push(u(h,m)||"null");return"["+n.join(",")+"]";default:n=[];for(h in m)aa.call(m,h)&&(p=u(h,m))&&n.push(l(h)+":"+p);return"{"+n.join(",")+"}"}}}("",{"":d})},checkCORSSupport:function(){return d.util.browser.msie&&!window.XDomainRequest&&11>+d.util.browser.version.split(".")[0]||d.util.browser.opera&&
12>+d.util.browser.version.split(".")||"KreaTVWebKit/531"===d.util.trim(navigator.userAgent).slice(0,16)||"kreatel"===d.util.trim(navigator.userAgent).slice(-7).toLowerCase()?!0:-1<navigator.userAgent.toLowerCase().indexOf("android")?!0:!1}}};d.util.now();(function(){var e=navigator.userAgent.toLowerCase(),e=/(chrome)[ \/]([\w.]+)/.exec(e)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(e)||/(msie) ([\w.]+)/.exec(e)||/(trident)(?:.*? rv:([\w.]+)|)/.exec(e)||0>e.indexOf("android")&&/version\/(.+) (safari)/.exec(e)||
0>e.indexOf("compatible")&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(e)||[];"safari"===e[2]&&(e[2]=e[1],e[1]="safari");d.util.browser[e[1]||""]=!0;d.util.browser.version=e[2]||"0";d.util.browser.vmajor=d.util.browser.version.split(".")[0];d.util.browser.trident&&(d.util.browser.msie=!0);if(d.util.browser.msie||d.util.browser.mozilla&&1===+d.util.browser.version.split(".")[0])d.util.storage=!1})();d.util.on(window,"unload",function(e){d.util.debug(new Date+" Atmosphere: unload event");d.unsubscribe()});
d.util.on(window,"beforeunload",function(e){d.util.debug(new Date+" Atmosphere: beforeunload event");d.unsubscribe()});d.util.on(window,"keypress",function(d){(27===d.charCode||27===d.keyCode)&&d.preventDefault&&d.preventDefault()});d.util.on(window,"offline",function(){I=!0;if(0<n.length)for(var d=[].concat(n),l=0;l<d.length;l++){var g=d[l];g.close();clearTimeout(g.response.request.id);g.heartbeatTimer&&clearTimeout(g.heartbeatTimer)}});d.util.on(window,"online",function(){if(0<n.length)for(var d=
0;d<n.length;d++)n[d].init(),n[d].execute();I=!1});return d});