### Examples

**Note**: You can login with username: `hello@bye.com` and password: `hello` in all the examples listed below.

The following examples offer a good starting point for including Auth0 in your AngularJS application:

 * [Custom Login](custom-login): Custom login form that uses Auth0 to authenticate.
 * [Custom Signup](custom-signup): Custom signup plus extra fields added to the user profile on creation.
 * [Widget](widget): A simple angular app doing auth with social and username/password using the Login Widget.
 * [API Authentication](widget-with-api): Call your protected API in the technology you want (Java, .NET, [Node.js](api-authentication/nodejs) using Auth0 generated tokens.

Advanced scenarios:
 * [UI Router](ui-router): A full featured example of ui-router with auth0-angular.
 * [Widget + UI Router](ui-router): Similar to the UI Router example, but using the Login Widget instead of a custom login form.
 * [Delegation Token](delegation-token): Call two different APIs (with different client ids) from a single Angular App.
 * [RequireJS](requirejs): An example of how to integrate auth0-angular with RequireJS.
 * [Redirect Mode](redirect): An example of how to do redirect-based social authentication (instead of popup).
 * [Widget with Redirect Mode](widget-redirect): Example of Auth0Login Widget with redirect mode.
