---
id: api-reference
title: API Reference
redirect_from: "/docs/api/index.html"
---


<div class="api-reference-menu">
<markdown>

- [Core](api/core.html)
    - [new Promise](api/new-promise.html)
    - [.then](api/then.html)
    - [.spread](api/spread.html)
    - [.catch](api/catch.html)
    - [.error](api/error.html)
    - [.finally](api/finally.html)
    - [.bind](api/bind.html)
    - [Promise.join](api/promise.join.html)
    - [Promise.try](api/promise.try.html)
    - [Promise.method](api/promise.method.html)
    - [Promise.resolve](api/promise.resolve.html)
    - [Promise.reject](api/promise.reject.html)
- [Synchronous inspection](api/synchronous-inspection.html)
    - [PromiseInspection](api/promiseinspection.html)
    - [.isFulfilled](api/isfulfilled.html)
    - [.isRejected](api/isrejected.html)
    - [.isPending](api/ispending.html)
    - [.isCancelled](api/iscancelled.html)
    - [.value](api/value.html)
    - [.reason](api/reason.html)
- [Collections](api/collections.html)
    - [Promise.all](api/promise.all.html)
    - [Promise.props](api/promise.props.html)
    - [Promise.any](api/promise.any.html)
    - [Promise.some](api/promise.some.html)
    - [Promise.map](api/promise.map.html)
    - [Promise.reduce](api/promise.reduce.html)
    - [Promise.filter](api/promise.filter.html)
    - [Promise.each](api/promise.each.html)
    - [Promise.mapSeries](api/promise.mapseries.html)
    - [Promise.race](api/promise.race.html)
    - [.all](api/all.html)
    - [.props](api/props.html)
    - [.any](api/any.html)
    - [.some](api/some.html)
    - [.map](api/map.html)
    - [.reduce](api/reduce.html)
    - [.filter](api/filter.html)
    - [.each](api/each.html)
    - [.mapSeries](api/mapseries.html)
- [Resource management](api/resource-management.html)
    - [Promise.using](api/promise.using.html)
    - [.disposer](api/disposer.html)
- [Promisification](api/promisification.html)
    - [Promise.promisify](api/promise.promisify.html)
    - [Promise.promisifyAll](api/promise.promisifyall.html)
    - [Promise.fromCallback](api/promise.fromcallback.html)
    - [.asCallback](api/ascallback.html)
- [Timers](api/timers.html)
    - [.delay](api/delay.html)
    - [.timeout](api/timeout.html)
- [Cancellation](api/cancellation.html)
    - [.cancel](api/cancel.html)
- [Generators](api/generators.html)
    - [Promise.coroutine](api/promise.coroutine.html)
    - [Promise.coroutine.addYieldHandler](api/promise.coroutine.addyieldhandler.html)
- [Utility](api/utility.html)
    - [.tap](api/tap.html)
    - [.call](api/call.html)
    - [.get](api/get.html)
    - [.return](api/return.html)
    - [.throw](api/throw.html)
    - [.catchReturn](api/catchreturn.html)
    - [.catchThrow](api/catchthrow.html)
    - [.reflect](api/reflect.html)
    - [Promise.noConflict](api/promise.noconflict.html)
    - [Promise.setScheduler](api/promise.setscheduler.html)
- [Built-in error types](api/built-in-error-types.html)
    - [OperationalError](api/operationalerror.html)
    - [TimeoutError](api/timeouterror.html)
    - [CancellationError](api/cancellationerror.html)
    - [AggregateError](api/aggregateerror.html)
- [Configuration](api/error-management-configuration.html)
    - [Rejection events](api/error-management-configuration.html#global-rejection-events)
    - [Promise.config](api/promise.config.html)
    - [.suppressUnhandledRejections](api/suppressunhandledrejections.html)
    - [.done](api/done.html)
- [Progression migration](api/progression-migration.html)
- [Deferred migration](api/deferred-migration.html)
- [Environment variables](api/environment-variables.html)

</markdown>
</div>
