---
layout: docs
title: Orange brand guidelines
group: about
---

Have a need for Boosted's brand resources? Great! We have a few guidelines we follow, and in turn ask you to follow as well. These guidelines were published by Orange SA [Orange Brand Assets](http://brand.orange.com/).

## Orange logo

<p>The Orange logo is the strongest association people have with the brand, so we have to use it correctly.</p>
<p><br>Our logo is made up of the orange block, the logotype and the TM sign. When using the Orange logo never try to recreate it. Instead, download our original logo artwork and make sure you follow our top rules:</p>
<ul>
<li>always exactly square the orange block and make sure it contains the Orange logotype</li>
<li>the logotype appears in the orange block, never on its own</li>
<li>characters are based on Helvetica Neue</li>
</ul>
<p><br>To find out how you can use our mark to make yours, read the core guideline.</p>

### space and position
  
<img src="{{ site.baseurl }}/assets/brand/orange-space-position.jpg" alt="">
<p><strong>space</strong></p>
<p>The logo should have as much space around it as possible, to help it stand out and protect it from typography or other graphic elements appearing too close to it. In simple terms, the minimum exclusion zone is equal to half the width of the logo itself, so if the logo is 20mm x 20mm, the clear space would be 10mm on all sides.</p>
<p><strong>position</strong></p>
<p>It is important to position the logo correctly to help achieve brand recognition and consistency. On most communications, the logo should be positioned bottom right using the clear space rules.</p>

## minimum size


<p>To maintain clarity and legibility, we have a minimum size for the Orange mark and the clear space around it. <br><br>Print - 10 mm with 6 mm clear space<br>Digital - 29 pixels with 19 pixels clear space.</p>


