---
layout: docs
title: Overview
description: Components and options for laying out your Boosted project, including wrapping containers, a powerful grid system, a flexible media object, and responsive utility classes.
group: layout
redirect_from: "/layout/"
---

Boosted includes several components and options for laying out your project, including wrapping containers, a powerful flexbox grid system, a flexible media object, and responsive utility classes.

## Contents

* Will be replaced with the ToC, excluding the "Contents" header
{:toc}

## Containers

Containers are the most basic layout element in Bootstrap and are **required when using our default grid system**. Choose from a responsive, fixed-width container (meaning its `max-width` changes at each breakpoint) or fluid-width (meaning it's `100%` wide all the time).

While containers *can* be nested, most layouts do not require a nested container.

<div class="bd-example">
  <div class="bd-example-container">
    <div class="bd-example-container-header"></div>
    <div class="bd-example-container-sidebar"></div>
    <div class="bd-example-container-body"></div>
  </div>
</div>

{% highlight html %}
<div class="container">
  <!-- Content here -->
</div>
{% endhighlight %}

Use `.container-fluid` for a full width container, spanning the entire width of the viewport.

<div class="bd-example">
  <div class="bd-example-container bd-example-container-fluid">
    <div class="bd-example-container-header"></div>
    <div class="bd-example-container-sidebar"></div>
    <div class="bd-example-container-body"></div>
  </div>
</div>

{% highlight html %}
<div class="container-fluid">
  ...
</div>
{% endhighlight %}


## Responsive breakpoints

Since Boosted is developed to be mobile first, we use a handful of [media queries](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Using_media_queries) to create sensible breakpoints for our layouts and interfaces. These breakpoints are mostly based on minimum viewport widths and allow us to scale up elements as the viewport changes.

Boosted primarily uses the following media query ranges—or breakpoints—in our source Sass files for our layout, grid system, and components.

{% highlight scss %}
// Extra small devices (portrait phones, less than 480px)
// No media query since this is the default in Boosted

// Small devices (landscape phones, 480px and up)
@media (min-width: 480px) { ... }

// Medium devices (tablets, 768px and up)
@media (min-width: 768px) { ... }

// Large devices (desktops, 980px and up)
@media (min-width: 980px) { ... }

// Extra large devices (large desktops, 1220px and up)
@media (min-width: 1220px) { ... }

// Extra extra large devices (large desktops, 1380px and up)
@media (min-width: 1380px) { ... }
{% endhighlight %}

Since we write our source CSS in Sass, all our media queries are available via Sass mixins:

{% highlight scss %}
@include media-breakpoint-up(xs) { ... }
@include media-breakpoint-up(sm) { ... }
@include media-breakpoint-up(md) { ... }
@include media-breakpoint-up(lg) { ... }
@include media-breakpoint-up(xl) { ... }
@include media-breakpoint-up(xxl) { ... }
// Example usage:
@include media-breakpoint-up(sm) {
  .some-class {
    display: block;
  }
}
{% endhighlight %}

We occasionally use media queries that go in the other direction (the given screen size *or smaller*):

{% highlight scss %}
// Extra small devices (portrait phones, less than 480px)
@media (max-width: 479px) { ... }

// Small devices (landscape phones, less than 768px)
@media (max-width: 767px) { ... }

// Medium devices (tablets, less than 960px)
@media (max-width: 959px) { ... }

// Large devices (desktops, less than 1220px)
@media (max-width: 1219px) { ... }

// Extra large devices (desktops, less than 1380px)
@media (max-width: 1379px) { ... }

// Extra extra large devices (large desktops)
// No media query since the extra-extra-large breakpoint has no upper bound on its width
{% endhighlight %}

Once again, these media queries are also available via Sass mixins:

{% highlight scss %}
@include media-breakpoint-down(xs) { ... }
@include media-breakpoint-down(sm) { ... }
@include media-breakpoint-down(md) { ... }
@include media-breakpoint-down(lg) { ... }
@include media-breakpoint-down(xl) { ... }
{% endhighlight %}

There are also media queries and mixins for targeting a single segment of screen sizes using the minimum and maximum breakpoint widths.

{% highlight scss %}
// Extra small devices (portrait phones, less than 480px)
@media (max-width: 479px) { ... }

// Small devices (landscape phones, 480px and up)
@media (min-width: 480px) and (max-width: 767px) { ... }

// Medium devices (tablets, 768px and up)
@media (min-width: 768px) and (max-width: 959px) { ... }

// Large devices (desktops, 960px and up)
@media (min-width: 960px) and (max-width: 1219px) { ... }

// Extra large devices (desktops, 1220px and up)
@media (min-width: 1220px) and (max-width: 1379px) { ... }

// Extra extra large devices (large desktops, 1380px and up)
@media (min-width: 1380px) { ... }
{% endhighlight %}

These media queries are also available via Sass mixins:

{% highlight scss %}
@include media-breakpoint-only(xs) { ... }
@include media-breakpoint-only(sm) { ... }
@include media-breakpoint-only(md) { ... }
@include media-breakpoint-only(lg) { ... }
@include media-breakpoint-only(xl) { ... }
@include media-breakpoint-only(xxl) { ... }
{% endhighlight %}

Similarly, media queries may span multiple breakpoint widths:

{% highlight scss %}
// Example
// Apply styles starting from medium devices (tablets, 768px and up) and  Large devices (desktops, 960px and up)
@media (min-width: 768px) and (max-width: 959px) { ... }
{% endhighlight %}

The Sass mixin for targeting the same screen size range would be:

{% highlight scss %}
@include media-breakpoint-between(md, xl) { ... }
{% endhighlight %}

## Z-index

Several Bootstrap components utilize `z-index`, the CSS property that helps control layout by providing a third axis to arrange content. We utilize a default z-index scale in Bootstrap that's been designed to properly layer navigation, tooltips and popovers, modals, and more.

We don't encourage customization of these values; should you change one, you likely need to change them all.

```scss
$zindex-dropdown-backdrop:  990 !default;
$zindex-dropdown:          1000 !default;
$zindex-fixed:             1030 !default;
$zindex-sticky:            1030 !default;
$zindex-modal-backdrop:    1040 !default;
$zindex-modal:             1050 !default;
$zindex-popover:           1060 !default;
$zindex-tooltip:           1070 !default;
```

Background elements—like the backdrops that allow click-dismissing—tend to reside on a lower `z-index`s, while navigation and popovers utilize higher `z-index`s to ensure they overlay surrounding content.
