/**
 * Bootstrap Table Spanish (Argentina) translation
 * Author: Felix Vera (felix.vera@gmail.com)
 */
(function ($) {
    'use strict';

    $.extend($.fn.bootstrapTable.defaults, {
        formatLoadingMessage: function() {
            return 'Cargando, espere por favor...';
        },
        formatRecordsPerPage: function(pageNumber) {
            return pageNumber + ' registros por página';
        },
        formatShowingRows: function(pageFrom, pageTo, totalRows) {
            return 'Mostrando ' + pageFrom + ' a ' + pageTo + ' de ' + totalRows + ' filas';
        },
        formatSearch: function() {
            return 'Buscar'
        },
        formatNoMatches: function() {
            return 'No se encontraron registros';
        }
    });
})(jQuery);