/**
 * Bootstrap Table Vietnamese translation
 * Author: Duc N. PHAM <pngduc@gmail.com>
 */
(function ($) {
    'use strict';

    $.extend($.fn.bootstrapTable.defaults, {
        formatLoadingMessage: function() {
            return 'Đang tải...';
        },
        formatRecordsPerPage: function(pageNumber) {
            return pageNumber + ' bản ghi mỗi trang';
        },
        formatShowingRows: function(pageFrom, pageTo, totalRows) {
            return 'Hiển thị từ trang ' + pageFrom + ' đến ' + pageTo + ' của ' + totalRows + ' bảng ghi';
        },
        formatSearch: function() {
            return 'Tìm kiếm'
        },
        formatNoMatches: function() {
            return 'Không có dữ liệu';
        }
    });
})(jQuery);