#include <zlib.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

#define WBITS 16+MAX_WBITS

#define CHUNK 4000

int main() {
	z_stream strmUncompress;
	
	strmUncompress.zalloc=Z_NULL;
	strmUncompress.zfree=Z_NULL;
	strmUncompress.opaque=Z_NULL;
	strmUncompress.avail_in = 0;
	strmUncompress.next_in = Z_NULL;
	
	int rci = inflateInit2(&strmUncompress, WBITS);

	if (rci != Z_OK) {
		printf("zlib initialization error.\n");
		exit(1);
	}
	
	FILE *fin = fopen("./test.gz", "r");
	char *in = malloc(20000);
	size_t readBytes = fread(in, 1, 20000, fin);
	printf("Read %d bytes\n", readBytes);
	
	strmUncompress.avail_in = readBytes;
	strmUncompress.next_in = in;
	
	int ret;
	int totalHave=0;
	
	char *out = NULL;
	uint32_t malloc_size=0;
	uint32_t currentPosition=0;
	
	do {
		unsigned char tmp[CHUNK];
		
		strmUncompress.avail_out = CHUNK;
		strmUncompress.next_out = tmp;
		
		ret = inflate(&strmUncompress, Z_NO_FLUSH);
		assert(ret != Z_STREAM_ERROR); 
		switch (ret) {
			case Z_NEED_DICT:
				ret = Z_DATA_ERROR;     /* and fall through */
			case Z_DATA_ERROR:
			case Z_MEM_ERROR:
				(void)inflateEnd(&strmUncompress);
				return 1;
		}

		uint32_t have = CHUNK - strmUncompress.avail_out;
		totalHave+=have;
		
		if (totalHave > malloc_size) {
			out = realloc(out, totalHave);
			malloc_size=totalHave;
		}
		
//		printf("Have = %d, total=%d\n", have, totalHave);
		
		memcpy(out+currentPosition, tmp, have);
		currentPosition+=have;
	} while (strmUncompress.avail_out == 0 && ret != Z_STREAM_END);
	
	(void)inflateEnd(&strmUncompress);
	
	if (ret == Z_STREAM_END) { 
		printf("ok\n");
	}
	
	FILE *fout = fopen("./test.csv", "w");
	fwrite(out, 1, totalHave, fout);
	fclose(fout);
}
