/*!
 Copyright 2014-2015 the original author or authors.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
define(["jQuery","lodash","angular","angular-spinner","angular-ui-select2","angular-ui-router","angular-ui-bootstrap"],function($,_,angular){"use strict";function catAutofocusDirectiveFactory($timeout){var catAutofocusLink=function(scope,element){$timeout(function(){_.isUndefined(element.data("select2"))?element[0].focus():element.select2("open")},100)};return{restrict:"A",link:catAutofocusLink}}function catBreadcrumbsDirectiveFactory(catBreadcrumbsConfig,catBreadcrumbs){var catAutofocusLink=function(scope){catBreadcrumbsConfig.homeState&&(scope.homeState=catBreadcrumbsConfig.homeState),scope.breadcrumbs=catBreadcrumbs,scope.showHome=function(){return!!catBreadcrumbsConfig.homeState}};return{restrict:"A",templateUrl:"template/cat-breadcrumbs.tpl.html",link:catAutofocusLink}}function catCheckboxDirectiveFactory(){var catCheckboxLink=function(scope,element){scope.checked?element.addClass("glyphicon glyphicon-check"):element.addClass("glyphicon glyphicon-unchecked")};return{replace:!0,restrict:"E",scope:{checked:"="},link:catCheckboxLink}}function catConfirmClickDirectiveFactory(){var catConfirmClickLink=function(scope,element,attr){var msg=attr.catConfirmClick||"Are you sure?",clickAction=attr.catOnConfirm;element.bind("click",function(){window.confirm(msg)&&scope.$eval(clickAction)})};return{restrict:"A",link:catConfirmClickLink}}function catElementVisibleDirectiveFactory(catElementVisibilityService){var catElementVisibleLink=function(scope,element){catElementVisibilityService.isVisible(scope.identifier,scope.data)||element.hide()};return{restrict:"A",scope:{identifier:"@catElementVisible",data:"=?catElementData"},link:catElementVisibleLink}}function catFacetsDirectiveFactory(){function _initDefaults(scope){_.isUndefined(scope.listData)&&(scope.listData=scope.$parent.listData)}function _checkConditions(scope){if(_.isUndefined(scope.listData))throw new Error("listData was not defined and couldn't be found with default value");if(_.isUndefined(scope.listData.facets))throw new Error("No facets are available within given listData")}var catFacetsLink=function(scope,element,attrs,catPaginatedController){_initDefaults(scope),_checkConditions(scope),scope.catPaginatedController=catPaginatedController};return{replace:!0,restrict:"E",scope:{listData:"=?",names:"="},require:"^catPaginated",templateUrl:"template/cat-facets.tpl.html",link:catFacetsLink,controller:["$scope",CatFacetsController]}}function catFieldErrorsInfoDirectiveFactory(){var catFieldErrorsLink=function(scope,elem,attr,_a){var catFieldErrors=_a[0],catValidationGroup=_a[1];elem.addClass("cat-field-errors-info"),catValidationGroup&&(catFieldErrors.contextId=catValidationGroup.getContextId())};return{replace:!0,restrict:"EA",scope:!0,bindToController:!0,controllerAs:"catFieldErrorsInfo",require:["catFieldErrorsInfo","?^^catValidationGroup"],link:catFieldErrorsLink,controller:CatFieldErrorsInfoController,templateUrl:"template/cat-field-errors-info.tpl.html"}}function catFieldErrorsDirectiveFactory(){var catFieldErrorsLink=function(scope,elem,attr,_a){var catFieldErrorsController=_a[0],catValidationGroupController=_a[1];elem.addClass("cat-field-errors"),catValidationGroupController&&(catFieldErrorsController.contextId=catValidationGroupController.getContextId())};return{replace:"true",restrict:"EA",scope:{name:"@"},bindToController:!0,controllerAs:"catFieldErrors",require:["catFieldErrors","?^^catValidationGroup"],link:catFieldErrorsLink,controller:CatFieldErrorsController,templateUrl:"template/cat-field-errors.tpl.html"}}function catGlobalErrorsDirectiveFactory(){var catGlobalErrorsLink=function(scope,elem,attr,_a){var catGlobalErrors=_a[0],catValidationGroup=_a[1];elem.addClass("cat-global-errors"),catValidationGroup&&(catGlobalErrors.contextId=catValidationGroup.getContextId())};return{replace:!0,restrict:"EA",scope:!0,bindToController:!0,controllerAs:"catGlobalErrors",require:["catGlobalErrors","?^^catValidationGroup"],link:catGlobalErrorsLink,controller:CatGlobalErrorsController,templateUrl:"template/cat-global-errors.tpl.html"}}function catI18nDirectiveFactory($log,$rootScope,catI18nService,catI18nResponseHandler){function _translate(scope,element){return scope.key?void catI18nService.translate(scope.key,scope.params).then(function(message){catI18nResponseHandler.handleTranslationSuccess(message,scope,element)},function(reason){catI18nResponseHandler.handleTranslationError(reason,scope,element)}):void $log.warn("No key was given for cat-i18n!")}var catI18nLink=function(scope,element){_translate(scope,element),scope.params&&scope.watchParams===!0&&scope.$watch("params",function(){_translate(scope,element)},!0),$rootScope.$on("cat-i18n-refresh",function(){_translate(scope,element)})};return{restrict:"A",scope:{key:"@catI18n",params:"=?i18nParams",watchParams:"=?i18nWatchParams"},link:catI18nLink}}function catIconDirectiveFactory(){return{restrict:"A",replace:!0,template:'<span class="{{iconClass}}" title="{{title}}"></span>',scope:{icon:"@catIcon",title:"@",size:"@"},controller:[CatIconController]}}function catInputGroupDirectiveFactory(catValidationService){var catInputGroupLink=function(scope,element,attr,catValidationGroupCtrl){catValidationGroupCtrl&&catValidationService&&catValidationService.getContext(catValidationGroupCtrl.getContextId()).registerField(scope.name),element.addClass("form-group")};return{restrict:"A",transclude:!0,scope:{label:"@",name:"@",catI18nKey:"@"},require:"?^^catValidationGroup",link:catInputGroupLink,templateUrl:"template/cat-input.tpl.html"}}function catInputDirectiveFactory(){var catInputLink=function(scope,element,attrs,ctrl){ctrl&&scope.$on("fieldErrors",function(event,fieldErrors){if(fieldErrors&&attrs.id){var valid=!fieldErrors[attrs.id];ctrl.$setValidity(attrs.id,valid)}})};return{require:"?ngModel",restrict:"E",link:catInputLink}}function catLoadMoreDirectiveFactory(){var catLoadMoreLink=function(scope,element,attrs){var initialCount=parseInt(attrs.catLoadMore);if(scope.$parent.elementsCount=scope.$parent.elementsCount||initialCount,scope.$parent.elements=scope.$parent.elements||[],scope.$parent.elements.push(element),scope.$parent.elements.length>scope.$parent.elementsCount&&element.addClass("hidden"),!element.parent().next().length&&scope.$parent.elements.length>scope.$parent.elementsCount){var elt=$('<a href="#">Show more</a>');elt.on({click:function(){return scope.$parent.elementsCount+=initialCount,scope.$parent.elements.length<=scope.$parent.elementsCount&&elt.addClass("hidden"),scope.$parent.elements.forEach(function(elt,ind){ind<scope.$parent.elementsCount&&elt.removeClass("hidden")}),!1}}),element.parent().after(elt)}};return{replace:!0,restrict:"A",link:catLoadMoreLink}}function catMainMenuDirectiveFactory($mainMenu,catElementVisibilityService,$location){var catMainMenuLink=function(scope){scope.getMenus=$mainMenu.getMenus,scope.isVisible=function(entry){var visible=!1;return entry.isMenu()||entry.isGroup()?(_.forEach(entry.getEntries(),function(subEntry){visible=visible||scope.isVisible(subEntry)}),entry.isMenu()&&_.forEach(entry.getGroups(),function(groups){visible=visible||scope.isVisible(groups)}),visible):catElementVisibilityService.isVisible("cat.menu.entry",entry)},scope.isActive=function(path){return $location.path().substr(0,path.length)===path}};return{restrict:"E",scope:{},link:catMainMenuLink,templateUrl:"template/cat-main-menu.tpl.html"}}function catMessagesDirectiveFactory(){var catMessagesLink=function(scope,elem,attr,catValidationGroupCtrl){catValidationGroupCtrl&&(scope.contextId=catValidationGroupCtrl.getContextId())};return{restrict:"A",templateUrl:"template/cat-messages.tpl.html",scope:{type:"=?"},require:"?^^catValidationGroup",link:catMessagesLink,controller:["$scope","catValidationService",CatMessagesController]}}function catPaginatedDirectiveFactory(catI18nService){var SEARCH_PROP_KEY="cc.catalysts.cat-paginated.search.prop",catPaginatedLink=function(scope,element,attrs){attrs.searchProps&&(scope.searchProps=_.filter(attrs.searchProps.split(","),function(prop){return!!prop}),scope.searchPropertyPlaceholders={},_.forEach(scope.searchProps,function(searchProp){scope.searchPropertyPlaceholders[searchProp]="Search by "+searchProp,catI18nService.translate(SEARCH_PROP_KEY,{prop:searchProp}).then(function(message){scope.searchPropertyPlaceholders[searchProp]=message})}))};return{replace:!0,restrict:"E",transclude:!0,scope:{listData:"=?",syncLocation:"=?"},templateUrl:"template/cat-paginated.tpl.html",link:catPaginatedLink,controllerAs:"catPaginatedController",controller:["$scope","$location","$timeout","$rootScope","catListDataLoadingService","catI18nService","catSearchService",CatPaginatedController]}}function catSelectDirectiveFactory(){var catSelectLink=function(scope,element,attrs,ngModel){element.addClass("form-control"),ngModel.$formatters=[]};return{restrict:"EA",replace:!0,priority:1,require:"ngModel",scope:{options:"=?",id:"@",config:"@?"},link:catSelectLink,controller:["$scope","$log","catApiService","catSelectConfigService",CatSelectController],template:'<input type="text" ui-select2="selectOptions">'}}function catSortableDirectiveFactory($compile){var catSortableLink=function(scope,element,attrs,catPaginatedController){var title=element.text(),property=attrs.catSortable||title.toLowerCase().trim(),i18n="cc.catalysts.cat-sortable.sort."+property;attrs.catI18nKey&&(i18n=attrs.catI18nKey),scope.sort=scope.listData.searchRequest.sort(),scope.catPaginatedController=catPaginatedController;var icon="glyphicon-sort-by-attributes";attrs.sortMode&&("numeric"===attrs.sortMode?icon="glyphicon-sort-by-order":"alphabet"===attrs.sortMode&&(icon="glyphicon-sort-by-alphabet")),element.text(""),element.append($compile('\n<a class="sort-link" href="" ng-click="toggleSort(\''+property+'\')">\n    <span cat-i18n="'+i18n+'">'+title+'</span>\n    <span class="glyphicon"\n          ng-class="{\n            \''+icon+"': sort.property == '"+property+"' && !sort.isDesc,\n            '"+icon+"-alt': sort.property == '"+property+"' && sort.isDesc\n          }\">\n    </span>\n</a>")(scope))};return{restrict:"AC",require:"^catPaginated",link:catSortableLink,controller:CatSortableController}}function catValidationGroupDirectiveFactory(){return{restrict:"A",controllerAs:"catValidationGroupCtrl",bindToController:!0,controller:["$scope","catValidationService",CatValidationGroupController]}}function catFormDirectiveFactory($timeout){var catFormLink=function(scope,element,attrs,formCtrl){var warningMessage=attrs.eocsWarnOnNavIfDirty||"You have unsaved changes. Leave the page?";$timeout(function(){formCtrl.$setPristine()},50),scope.$on("formReset",function(){formCtrl.$setPristine()}),scope.$on("formDirty",function(){formCtrl.$setDirty()}),scope.$on("$locationChangeStart",function(event){formCtrl.$dirty&&(window.confirm(warningMessage)||event.preventDefault())}),$(window).on("beforeunload",function(){return formCtrl.$dirty?warningMessage:void 0}),scope.$on("$destroy",function(){$(window).unbind("beforeunload")})};return{restrict:"E",scope:!0,require:"form",link:catFormLink}}function catNumbersOnlyDirectiveFactory(){var catNumbersOnlyLink=function(scope,element,attrs,modelCtrl){modelCtrl.$parsers.push(function(inputValue){if(!inputValue)return"";var pattern="[^0-9]";attrs.hasOwnProperty("allowFraction")&&(pattern="[^0-9,.]");var transformedInput=inputValue.replace(new RegExp(pattern,"g"),"");return transformedInput!==inputValue&&(modelCtrl.$setViewValue(transformedInput),modelCtrl.$render()),transformedInput})};return{require:"ngModel",link:catNumbersOnlyLink}}function catReplaceTextFilterFactory(){return function(text,pattern,options,replacement){return void 0===pattern&&(pattern="\n"),void 0===options&&(options="g"),void 0===replacement&&(replacement=", "),text?String(text).replace(new RegExp(pattern,options),replacement):text}}function _convertToClientModel(data,context){return!_.isUndefined(context)&&_.isFunction(context.model)?new context.model(data):data}function _convertToClientData(serverData,context){if(!_.isUndefined(serverData)){if(_.isArray(serverData))return _.map(serverData,function(data){return _convertToClientModel(data,context)});if(_.isNumber(serverData.totalCount)){var copy=_.clone(serverData),facets=[];serverData.facets&&(facets=_.map(serverData.facets,function(facet){return new window.cat.Facet(facet)}));var result={totalCount:serverData.totalCount,facets:facets,elements:_.map(serverData.elements,function(elem){return _convertToClientData(elem,context)})};return delete copy.totalCount,delete copy.elements,delete copy.facets,_.assign(result,copy)}return _.isUndefined(context)?serverData:_convertToClientModel(serverData,context)}}function assignDeep(target,source){return _.assign(target,source,function(targetProperty,sourceProperty){return _.isObject(targetProperty)&&_.isObject(sourceProperty)?assignDeep(targetProperty,sourceProperty):sourceProperty})}window.cat=window.cat||{};var FacetTerm=function(){function FacetTerm(data){void 0===data&&(data={}),this.id=data.id,this.name=data.name,this.count=data.count}return FacetTerm}(),Facet=function(){function Facet(data){void 0===data&&(data={}),this.name=data.name,this.terms=_.map(data.facets,function(facet){return new FacetTerm(facet)})}return Facet}();window.cat=window.cat||{},window.cat.Facet=Facet,window.cat.FacetTerm=FacetTerm;var SearchRequest=function(){function SearchRequest(searchUrlParams){var _this=this;void 0===searchUrlParams&&(searchUrlParams={}),this._pagination={page:1,size:100},this._sort={},this._search={},this._dirty=!1,_.isEmpty(searchUrlParams)||(this._pagination.page=searchUrlParams.page||this._pagination.page,this._pagination.size=searchUrlParams.size||this._pagination.size,this._sort.property=searchUrlParams.sort||this._sort.property,this._sort.isDesc=searchUrlParams.rev||this._sort.isDesc,_.forEach(_.keys(searchUrlParams),function(param){param.indexOf("search.")>-1&&param.length>7&&(_this._search[param.substring(7)]=searchUrlParams[param])}))}return SearchRequest.prototype._encodeSort=function(){var _sort=this._sort;return _sort.property?"sort="+_sort.property+":"+(_sort.isDesc===!0||"true"===_sort.isDesc?"desc":"asc"):""},SearchRequest.prototype._encodePagination=function(){var _pagination=this._pagination;return"page="+(_pagination.page?Math.max(0,_pagination.page-1):0)+"&size="+_pagination.size||100},SearchRequest._concatenate=function(result,next){return result?next?result+"&"+next:result:next},SearchRequest.prototype._encodeSearch=function(){return this._search&&!_.isEmpty(this._search)?$.param(this._search,!0):""},SearchRequest.prototype._urlEndoded=function(){return _([this._encodePagination(),this._encodeSort(),this._encodeSearch()]).reduce(SearchRequest._concatenate)},SearchRequest.prototype.pagination=function(pagination){return void 0===pagination?this._pagination:(this._pagination=pagination,this._dirty=!0,this._pagination)},SearchRequest.prototype.sort=function(sort){return void 0===sort?this._sort:(this._sort=sort,this._dirty=!0,this._sort)},SearchRequest.prototype.search=function(search){return void 0===search?this._search:(this._search=search,this._dirty=!0,this._search)},SearchRequest.prototype.urlEncoded=function(){return this.lastEncoded=this._urlEndoded(),this.lastEncoded},SearchRequest.prototype.isDirty=function(){return this._dirty},SearchRequest.prototype.setPristine=function(){this._dirty=!1},SearchRequest.prototype.setSearch=function($location){var _this=this,ret={};ret.page=this._pagination.page,ret.size=this._pagination.size,this._sort.property&&(ret.sort=this._sort.property,ret.rev=this._sort.isDesc||!1),_.forEach(_.keys(this._search),function(s){ret["search."+s]=_this._search[s]}),$location.search(ret)},SearchRequest}();window.cat=window.cat||{},window.cat.SearchRequest=SearchRequest,angular.module("cat.config.messages",[]).constant("catMessagesConfig",{knownFieldsActive:!1});var CatBaseDetailController=function(){function CatBaseDetailController($scope,$state,$stateParams,$location,$window,$globalMessages,$controller,$log,catValidationService,catBreadcrumbsService,config){this.$scope=$scope,this.$state=$state,this.$stateParams=$stateParams,this.$location=$location,this.$window=$window,this.$globalMessages=$globalMessages,this.$controller=$controller,this.$log=$log,this.catValidationService=catValidationService,this.catBreadcrumbsService=catBreadcrumbsService,this.config=config,$scope.detail=config.detail,$scope.editDetail=void 0,$scope.config=config;var endpoint=config.endpoint,templateUrls=config.templateUrls,Model=config.Model;$scope.uiStack=catBreadcrumbsService.generateFromConfig(config),"new"===$stateParams.id?catBreadcrumbsService.push({title:"New",key:"cc.catalysts.general.new"}):catBreadcrumbsService.push({}),$scope.editTemplate=templateUrls.edit,_.isObject(templateUrls.view)?($scope.mainViewTemplate=templateUrls.view.main,$scope.additionalViewTemplate=templateUrls.view.additional):$scope.mainViewTemplate=""+templateUrls.view,$scope.title=function(){var data=$scope.detail;return _.isUndefined(data)?"":data.breadcrumbTitle?data.breadcrumbTitle():data.name?data.name:data.id};var update=function(){catBreadcrumbsService.replaceLast({title:$scope.title()})};$scope.reloadDetails=function(){endpoint.get($stateParams.id).then(function(data){$scope.detail=data,update()})},$scope.exists=!!$stateParams.id&&"new"!==$stateParams.id,$scope.add=function(){$scope.editDetail=new Model,_.isFunction($scope.editDetail.setParent)&&$scope.editDetail.setParent(config.parents[0])},$scope.edit=function(){_.isFunction($scope.detail.setParent)&&$scope.detail.setParent(config.parents[0]),$scope.editDetail=angular.copy($scope.detail)},$scope.cancelEdit=function(){catValidationService.clearValidationErrors(),$scope.$broadcast("formReset"),$scope.exists?($scope.editDetail=void 0,$globalMessages.clearMessages()):$window.history.back()},$scope.copy=function(){endpoint.copy($scope.detail.id).then(function(data){$state.go(".",{id:data.id})})},$scope.remove=function(){endpoint.remove($scope.detail.id).then(function(){if(_.isEmpty($scope.uiStack))$state.go("^.list");else{var url=$state.href("^.^");$location.url(url.substring(1,url.length)),$location.search("tab",endpoint.getEndpointName())}})},$scope.save=function(stayInEdit){endpoint.save(angular.copy($scope.editDetail)).then(function(data){$globalMessages.clearMessages(),catValidationService.clearValidationErrors(),stayInEdit?($scope.editDetail=data,$scope.reloadDetails()):$scope.exists?($scope.editDetail=void 0,$scope.detail=data,update()):($scope.$broadcast("formReset"),$state.go(".",{id:data.id}))})},$scope.baseTabsController=["$scope",function($tabsScope){$controller("CatBaseTabsController",{$scope:$tabsScope,config:config})}];try{$controller(config.controller,{$scope:$scope,detail:config.detail,parents:config.parents,config:config})}catch(unused){$log.info("Couldn't instantiate controller with name "+config.controller)}$scope.exists?update():$scope.edit()}return CatBaseDetailController}();angular.module("cat.controller.base.detail",["cat.service.breadcrumbs","cat.controller.base.tabs"]).controller("CatBaseDetailController",["$scope","$state","$stateParams","$location","$window","$globalMessages","$controller","$log","catValidationService","catBreadcrumbsService","config",CatBaseDetailController]);var CatBaseListController=function(){function CatBaseListController($scope,$state,$controller,$log,catBreadcrumbsService,catListDataLoadingService,config){this.$scope=$scope,this.$state=$state,this.$log=$log,this.catListDataLoadingService=catListDataLoadingService,this.config=config,_.isUndefined(config.listData)?$log.warn("No listData available!"):(this.titleKey="cc.catalysts.cat-breadcrumbs.entry."+config.listData.endpoint.getEndpointName(),catBreadcrumbsService.set([{title:config.title,key:this.titleKey}]),$scope.listData=config.listData),this.title=config.title,this.searchProps=config.searchProps,this.config=config;try{$controller(config.controller,{$scope:$scope,listData:config.listData,config:config})}catch(unused){$log.info("Couldn't instantiate controller with name "+config.controller)}}return CatBaseListController.prototype.getUrlForId=function(id){return this.$log.warn("use ui-sref directly - this method will be removed in the near future"),this.$state.href("^.detail",{id:id})},CatBaseListController.prototype.getUrlForNewPage=function(){return this.getUrlForId("new")},CatBaseListController.prototype.remove=function(id){var _this=this,endpoint=this.config.listData.endpoint;endpoint.remove(id).then(function(){return _this.catListDataLoadingService.load(_this.config.listData.endpoint,_this.config.listData.searchRequest)}).then(function(data){return _.assign(_this.$scope.listData,data)})},CatBaseListController}();angular.module("cat.controller.base.list",["cat.service.breadcrumbs"]).controller("CatBaseListController",["$scope","$state","$controller","$log","catBreadcrumbsService","catListDataLoadingService","config",CatBaseListController]);var CatBaseTabsController=function(){function CatBaseTabsController($scope,$controller,$stateParams,$location,catElementVisibilityService,config,urlResolverService){var endpoint=config.endpoint;$scope.tabs=_.filter(config.tabs,function(tab){return catElementVisibilityService.isVisible("cat.base.tab",tab)}),$scope.tabNames=_.map($scope.tabs,"name"),$scope.activeTab={},$scope.activateTab=function(tab){$scope.$broadcast("tab-"+tab+"-active"),_.forEach($scope.tabs,function(currentTab){$scope.activeTab[currentTab.name]=!1}),$scope.activeTab[tab]=!0},$scope.selectTab=function(tabName){_.isUndefined($location.search().tab)&&tabName===$scope.tabNames[0]||$location.search("tab",tabName)};var isTabActive=function(tab){return tab.name===$scope.tabNames[0]&&_.isUndefined($stateParams.tab)?!0:$stateParams.tab===tab.name};$scope.$watchCollection(function(){return $location.search()},function(newValue){_.isString(newValue.tab)?$scope.activateTab(newValue.tab):_.isUndefined(newValue.tab)&&$scope.activateTab($scope.tabNames[0])}),$scope.getTabName=function(tab){return window.cat.util.pluralize(window.cat.util.capitalize(tab))},_.forEach($scope.tabs,function(tab){$scope.activeTab[tab.name]=isTabActive(tab)}),$scope.getTabTemplate=function(tab){return urlResolverService.getTabTemplate(tab,config)},$scope.getTabKey=function(tabName){for(var key="cc.catalysts.general.tab."+endpoint.getEndpointName(),parentEndpoint=endpoint.parentEndpoint;parentEndpoint;)key+=".",key+=parentEndpoint.getEndpointName(),parentEndpoint=parentEndpoint.parentEndpoint;return key+"."+tabName};var _getDefaultTabControllerName=function(tab){for(var name=window.cat.util.capitalize(endpoint.getEndpointName()),parentEndpoint=endpoint.parentEndpoint;parentEndpoint;)name=window.cat.util.capitalize(parentEndpoint.getEndpointName())+name,parentEndpoint=parentEndpoint.parentEndpoint;return name+window.cat.util.capitalize(tab.name)+"Controller"},_getTabControllerName=function(tab){return tab.controller?tab.controller:_getDefaultTabControllerName(tab)},tabIndex=0;$scope.tabController=["$scope","catListDataLoadingService",function($tabScope,catListDataLoadingService){var activeTab=$scope.tabs[tabIndex++],tabControllerName=_getTabControllerName(activeTab);$tabScope.getSearchRequest=function(){return new window.cat.SearchRequest},$tabScope.getEndpoint=function(){return config.detail[activeTab.name]},$tabScope.loadListData=function(){catListDataLoadingService.load($tabScope.getEndpoint(),$tabScope.getSearchRequest()).then(function(data){$tabScope.listData=data})},$tabScope.$on("tab-"+activeTab.name+"-active",function(){_.isUndefined($tabScope.listData)&&$tabScope.loadListData()}),$controller(tabControllerName,{$scope:$tabScope,detail:config.detail,parents:config.parents,config:config}),$scope.activeTab[activeTab.name]===!0&&$scope.activateTab(activeTab.name)}]}return CatBaseTabsController.$inject=["$scope","$controller","$stateParams","$location","catElementVisibilityService","config","urlResolverService"],CatBaseTabsController}();angular.module("cat.controller.base.tabs",["cat.service.elementVisibility","cat.url.resolver.service"]).controller("CatBaseTabsController",CatBaseTabsController),angular.module("cat.directives.autofocus",[]).directive("catAutofocus",["$timeout",catAutofocusDirectiveFactory]),catBreadcrumbsDirectiveFactory.$inject=["catBreadcrumbsConfig","catBreadcrumbs"],angular.module("cat.directives.breadcrumbs",["cat.service.breadcrumbs"]).constant("catBreadcrumbsConfig",{homeState:"dashboard"}).directive("catBreadcrumbs",catBreadcrumbsDirectiveFactory),angular.module("cat.directives.checkbox",[]).directive("catCheckbox",[catCheckboxDirectiveFactory]),angular.module("cat.directives.confirmClick",[]).directive("catConfirmClick",[catConfirmClickDirectiveFactory]),angular.module("cat.directives.elementVisible",["cat.service.elementVisibility"]).directive("catElementVisible",["catElementVisibilityService",catElementVisibleDirectiveFactory]);var CatFacetsController=function(){function CatFacetsController($scope){$scope.isActive=function(facet){return!!$scope.catPaginatedController.getSearch()[facet.name]},$scope.facetName=function(facet){return void 0!==$scope.names&&void 0!==$scope.names[facet.name]?$scope.names[facet.name]:facet.name},$scope.facets={};var _search=function(search){return $scope.catPaginatedController.getSearchRequest().search(search)};$scope.facetChanged=function(facet){var search=_search(),value=$scope.facets[facet.name];value?search[facet.name]=value:delete search[facet.name]},$scope.initFacets=function(){_.forEach($scope.listData.facets,function(facet){$scope.isActive(facet)&&($scope.facets[facet.name]=$scope.catPaginatedController.getSearch()[facet.name])})},$scope.facetSelectOptions={allowClear:!0}}return CatFacetsController}();angular.module("cat.directives.facets",["cat.directives.paginated"]).directive("catFacets",[catFacetsDirectiveFactory]);var CatFieldErrorsInfoController=function(){function CatFieldErrorsInfoController(catValidationService){this.catValidationService=catValidationService}return CatFieldErrorsInfoController.prototype.hasErrors=function(){return this.catValidationService.hasAnyFieldErrors(this.contextId)},CatFieldErrorsInfoController}();angular.module("cat.directives.fieldErrors.info",["cat.service.validation"]).directive("catFieldErrorsInfo",[catFieldErrorsInfoDirectiveFactory]);var CatFieldErrorsController=function(){function CatFieldErrorsController(catValidationService){this.catValidationService=catValidationService}return CatFieldErrorsController.prototype.hasErrors=function(){return this.catValidationService.hasFieldErrors(this.name,this.contextId)},CatFieldErrorsController.prototype.getErrors=function(){return this.catValidationService.getFieldErrors(this.name,this.contextId)},CatFieldErrorsController}();angular.module("cat.directives.fieldErrors",["cat.service.validation"]).directive("catFieldErrors",[catFieldErrorsDirectiveFactory]);var CatGlobalErrorsController=function(){function CatGlobalErrorsController(catValidationService){this.catValidationService=catValidationService}return CatGlobalErrorsController.prototype.hasErrors=function(){return this.catValidationService.hasGlobalErrors(this.contextId)},CatGlobalErrorsController.prototype.getErrors=function(){return this.catValidationService.getGlobalErrors(this.contextId)},CatGlobalErrorsController}();angular.module("cat.directives.globalErrors",["cat.service.validation"]).directive("catGlobalErrors",[catGlobalErrorsDirectiveFactory]),angular.module("cat.directives.i18n",["cat.service.i18n"]).directive("catI18n",["$log","$rootScope","catI18nService","catI18nResponseHandler",catI18nDirectiveFactory]);var CatIconController=function(){function CatIconController($scope,catIconConfig){var icons=catIconConfig.icons,iconClasses=[];$scope.size&&"xs"===$scope.size&&catIconConfig.xsClass&&iconClasses.push(catIconConfig.xsClass),iconClasses.push(icons[$scope.icon]),$scope.iconClass=iconClasses.join(" ")}return CatIconController}();angular.module("cat.directives.icon",[]).constant("catIconConfig",{icons:{config:{xsClass:void 0},create:"glyphicon glyphicon-plus",edit:"glyphicon glyphicon-edit",remove:"glyphicon glyphicon-remove",save:"glyphicon glyphicon-floppy-disk"}}).directive("catIcon",[catIconDirectiveFactory]),angular.module("cat.directives.inputGroup",[]).directive("catInputGroup",[catInputGroupDirectiveFactory]),angular.module("cat.directives.input",[]).directive("input",[catInputDirectiveFactory]),angular.module("cat.directives.loadMore",[]).directive("catLoadMore",[catLoadMoreDirectiveFactory]),angular.module("cat.directives.menu",["cat.service.menu","cat.service.elementVisibility"]).directive("catMainMenu",["$mainMenu","catElementVisibilityService","$location",catMainMenuDirectiveFactory]);var CatMessagesController=function(){function CatMessagesController($scope,catValidationService){$scope.type||($scope.type="error"),$scope.hasMessages=function(){return catValidationService.hasGlobalErrors($scope.contextId)},$scope.getMessages=function(){return catValidationService.getGlobalErrors($scope.contextId)}}return CatMessagesController}();angular.module("cat.directives.messages",["cat.config.messages","cat.service.validation"]).directive("catMessages",[catMessagesDirectiveFactory]);var CatPaginatedController=function(){function CatPaginatedController($scope,$location,$timeout,$rootScope,catListDataLoadingService,catI18nService,catSearchService){this.$scope=$scope,this.$location=$location,this.$timeout=$timeout,this.$rootScope=$rootScope,this.catListDataLoadingService=catListDataLoadingService,this.catI18nService=catI18nService,this.catSearchService=catSearchService,this.searchTimeout=null,this.initScopeProperties(),this.registerScopeEventHandlers(),this.registerScopeWatches()}return CatPaginatedController.prototype.initScopeProperties=function(){if(_.isUndefined(this.$scope.listData)&&(this.$scope.listData=this.$scope.$parent.listData,_.isUndefined(this.$scope.listData)))throw new Error("listData was not defined and couldn't be found with default value");_.isUndefined(this.$scope.syncLocation)&&(this.$scope.syncLocation=_.isUndefined(this.$scope.$parent.detail)),this.$scope.paginationText={previous:"Previous",next:"Next",first:"First",last:"Last"},this._loadPaginationTranslations(),this.$scope.listData.search=this.$scope.listData.search||this.$scope.listData.searchRequest.search()||{},this.searchRequest=this.$scope.listData.searchRequest},CatPaginatedController.prototype.registerScopeWatches=function(){var _this=this;this.$scope.$watch("listData.sort",function(newVal){newVal&&(console.log("broadcasting sort changed: "+angular.toJson(newVal)),_this.$scope.$parent.$broadcast("SortChanged",newVal))},!0),this.$scope.$watch("listData.search",this.updateSearch,!0),this.$scope.$watch("listData.pagination",function(newVal,oldVal){angular.equals(newVal,oldVal)||(_this.searchRequest.pagination(_this.$scope.listData.pagination),_this.updateLocation(),_this.reload())},!0)},CatPaginatedController.prototype.registerScopeEventHandlers=function(){var _this=this;this.$rootScope.$on("cat-i18n-refresh",function(){_this._loadPaginationTranslations()}),this.$scope.$on("cat-paginated-refresh",function(){_this.reload(0,!0)}),this.$scope.$on("SortChanged",function(event,value){_this.sort(value)})},CatPaginatedController.prototype.handlePaginationTextResponse=function(prop){var _this=this;return function(message){_this.$scope.paginationText[prop]=message}},CatPaginatedController.prototype._loadPaginationTranslations=function(){this.catI18nService.translate(CatPaginatedController.PAGINATION_PREVIOUS_KEY).then(this.handlePaginationTextResponse("previous")),this.catI18nService.translate(CatPaginatedController.PAGINATION_NEXT_KEY).then(this.handlePaginationTextResponse("next")),this.catI18nService.translate(CatPaginatedController.PAGINATION_FIRST_KEY).then(this.handlePaginationTextResponse("first")),this.catI18nService.translate(CatPaginatedController.PAGINATION_LAST_KEY).then(this.handlePaginationTextResponse("last"));
},CatPaginatedController.prototype.reload=function(delay,force){var _this=this;void 0===delay&&(delay=0),void 0===force&&(force=!1),this.$timeout.cancel(this.searchTimeout),this.searchTimeout=this.$timeout(function(){(_this.searchRequest.isDirty()||force)&&_this.catListDataLoadingService.load(_this.$scope.listData.endpoint,_this.searchRequest).then(function(data){_this.searchRequest.setPristine(),_.assign(_this.$scope.listData,data)})},delay)},CatPaginatedController.prototype.updateLocation=function(){this.$scope.syncLocation!==!1&&(this.catSearchService.updateLocation(this.searchRequest),this.$location.replace())},CatPaginatedController.prototype.searchChanged=function(value,delay){this.searchRequest.search(value),this.updateLocation(),this.$scope.listData.pagination.page=1,this.reload(delay)},CatPaginatedController.prototype.updateSearch=function(newVal,oldVal){if(!angular.equals(newVal,oldVal)){var search=this.searchRequest.search();_.assign(search,newVal),this.searchChanged(newVal,CatPaginatedController.DELAY_ON_SEARCH)}},CatPaginatedController.prototype.sort=function(newVal,oldVal){angular.equals(newVal,oldVal)||(this.searchRequest.sort(newVal),this.updateLocation(),this.$scope.listData.pagination.page=1,this.reload())},CatPaginatedController.prototype.getSearch=function(){return this.searchRequest.search()},CatPaginatedController.prototype.getSearchRequest=function(){return this.searchRequest},CatPaginatedController.DELAY_ON_SEARCH=500,CatPaginatedController.PAGINATION_PREVIOUS_KEY="cc.catalysts.cat-paginated.pagination.previous",CatPaginatedController.PAGINATION_NEXT_KEY="cc.catalysts.cat-paginated.pagination.next",CatPaginatedController.PAGINATION_FIRST_KEY="cc.catalysts.cat-paginated.pagination.first",CatPaginatedController.PAGINATION_LAST_KEY="cc.catalysts.cat-paginated.pagination.last",CatPaginatedController}();angular.module("cat.directives.paginated",["ui.bootstrap.pagination","cat.service.listDataLoading","cat.service.i18n","cat.service.search"]).directive("catPaginated",["catI18nService",catPaginatedDirectiveFactory]);var CatSelectController=function(){function CatSelectController($scope,$log,catApiService,catSelectConfigService){this.$log=$log;var options=catSelectConfigService.getConfig($scope.config,$scope.options);if(_.isUndefined(options))throw new Error('At least one of "config" or "options" has to be specified');var transport,quietMillis,searchRequestAdapter=options.searchRequestAdapter||{},searchRequestFunc=options.search||function(term,page){return{"search.name":term,page:page}},filterFunc=options.filter||function(term){return!0},endpoint=options.endpoint;if(_.isArray(endpoint))transport=function(queryParams){return queryParams.success({elements:options.endpoint})},quietMillis=0;else if(_.isFunction(endpoint))transport=endpoint,quietMillis=500;else if(_.isObject(endpoint))transport=this.fetchElements(endpoint,options.sort,searchRequestAdapter),quietMillis=500;else{if(!_.isString(endpoint))return $log.error("The given endpoint has to be one of the following types: array, object, string or function - but was "+typeof endpoint),void($scope.elements=[]);var api=catApiService[""+endpoint];if(!api)return $log.error('No api endpoint "'+endpoint+'" defined'),void($scope.elements=[]);transport=this.fetchElements(api,options.sort,searchRequestAdapter),quietMillis=500}$scope.selectOptions=_.assign({placeholder:" ",minimumInputLength:0,adaptDropdownCssClass:function(cssClass){return _.contains(["ng-valid","ng-invalid","ng-pristine","ng-dirty"],cssClass)?cssClass:null},ajax:{data:searchRequestFunc,quietMillis:quietMillis,transport:transport,results:function(data,page){var more=page*(options.size||100)<data.totalCount;return{results:_.filter(data.elements,filterFunc),more:more}}},formatResult:function(element){return element.name},formatSelection:function(element){return element.name}},options["ui-select2"])}return CatSelectController.prototype.fetchElements=function(endpoint,sort,searchRequestAdapter){var _this=this;return function(queryParams){var searchRequest=new window.cat.SearchRequest(queryParams.data);return searchRequest.sort(sort||{property:"name",isDesc:!1}),_.isFunction(searchRequestAdapter)?searchRequest=searchRequestAdapter(searchRequest):_.isObject(searchRequestAdapter)?_.assign(searchRequest,searchRequestAdapter):_this.$log.warn("searchRequestAdapter has to be either a function or an object but was "+typeof searchRequestAdapter),endpoint.list(searchRequest).then(queryParams.success)}},CatSelectController}();angular.module("cat.directives.select",["ui.select2","cat.service.api","cat.service.selectConfig"]).directive("catSelect",[catSelectDirectiveFactory]);var CatSortableController=function(){function CatSortableController($scope){$scope.toggleSort=function(property){$scope.sort.property===property?$scope.sort.isDesc=!$scope.sort.isDesc:($scope.sort.property=property,$scope.sort.isDesc=!1),$scope.catPaginatedController.sort($scope.sort)},$scope.$on("SortChanged",function(event,value){$scope.sort=value})}return CatSortableController}();angular.module("cat.directives.sortable",["cat.directives.paginated"]).directive("catSortable",[catSortableDirectiveFactory]);var CatValidationGroupController=function(){function CatValidationGroupController($scope,catValidationService){var _this=this;this.contextId=catValidationService.createContext(),$scope.$on("$destroy",function(){catValidationService.destroyContext(_this.contextId)})}return CatValidationGroupController.prototype.getContextId=function(){return this.contextId},CatValidationGroupController}();angular.module("cat.directives.validation",["cat.service.validation"]).directive("catValidationGroup",[catValidationGroupDirectiveFactory]),angular.module("cat.directives.form",[]).directive("form",["$timeout",catFormDirectiveFactory]),angular.module("cat.directives.numbersOnly",[]).directive("numbersOnly",[catNumbersOnlyDirectiveFactory]),angular.module("cat.filters.replaceText",[]).filter("replaceText",[catReplaceTextFilterFactory]),window.cat.i18n=window.cat.i18n||{},window.cat.i18n.de=_.assign({"cc.catalysts.cat-paginated.itemsFound":"{{count}} Einträge gefunden. Einträge {{firstResult}}-{{lastResult}}","cc.catalysts.cat-paginated.noItemsFound":"Keine Einträge gefunden","cc.catalysts.general.new":"Neu","cc.catalysts.general.edit":"Bearbeiten","cc.catalysts.general.delete":"Löschen","cc.catalysts.general.copy":"Kopieren","cc.catalysts.general.save":"Speichern","cc.catalysts.general.cancel":"Abbrechen","cc.catalysts.cat-breadcrumbs.entry.home":"Zuhause","cc.catalysts.cat-breadcrumbs.entry.edit":"Bearbeiten","cc.catalysts.cat-field-errors-info.text":"Beim speichern ist ein Fehler aufgetreten. Bitte überprüfen Sie Ihre Eingabe.","cc.catalysts.cat-validation-service.networkError":"Es ist ein Netzwerkfehler aufgetreten."},window.cat.i18n.de),window.cat.i18n=window.cat.i18n||{},window.cat.i18n.en=_.assign({"cc.catalysts.cat-paginated.itemsFound":"{{count}} entries found. Entries {{firstResult}}-{{lastResult}}","cc.catalysts.cat-paginated.noItemsFound":"No entries found","cc.catalysts.general.new":"New","cc.catalysts.general.edit":"Edit","cc.catalysts.general.delete":"Delete","cc.catalysts.general.copy":"Copy","cc.catalysts.general.save":"Save","cc.catalysts.general.cancel":"Cancel","cc.catalysts.cat-breadcrumbs.entry.home":"Home","cc.catalysts.cat-breadcrumbs.entry.edit":"Edit","cc.catalysts.cat-field-errors-info.text":"Errors occured during save. Please verify your input.","cc.catalysts.cat-validation-service.networkError":"A network error occurred."},window.cat.i18n.en),window.cat=window.cat||{},window.cat.models=window.cat.models||{},window.cat.util=window.cat.util||{pluralize:function(string){if(_.isUndefined(string)||0===string.length)return"";var lastChar=string[string.length-1];switch(lastChar){case"y":return string.substring(0,string.length-1)+"ies";case"s":return string+"es";default:return string+"s"}},capitalize:function(string){return _.isUndefined(string)||0===string.length?"":string.substring(0,1).toUpperCase()+string.substring(1,string.length)},generateUUID:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=16*Math.random()|0,v="x"===c?r:3&r|8;return v.toString(16)})},defaultModelResolver:function(name){return window.cat.models[name]}};var CatApiEndpoint=function(){function CatApiEndpoint(url,endpointConfig,$http,catConversionService,catSearchService){var _this=this;this.$http=$http,this.catConversionService=catConversionService,this.catSearchService=catSearchService,this._res=_.memoize(function(id){var url=_this._endpointUrl+"/"+id+"/",ret={};return _.forEach(_.keys(_this._childEndpointSettings),function(path){ret[path]=new CatApiEndpoint(url,_this._childEndpointSettings[path],_this.$http,_this.catConversionService,_this.catSearchService),ret[path].parentEndpoint=_this,ret[path].parentId=id,ret[path].parentInfo=function(){return _this.info(id)}}),ret}),this.config=endpointConfig.config,this._endpointName=endpointConfig.name,this._endpointUrl=""+url+(this.config.url||endpointConfig.name),this._childEndpointSettings=endpointConfig.children,this._endpointListConfig=this.config.list||{};var get=function(url,searchRequest){return _this.$http.get([_this._endpointUrl,url].join("/")+_this._getSearchQuery(searchRequest))},post=function(url,object){return _this.$http.post([_this._endpointUrl,url].join("/"),object)},put=function(url,object){return _this.$http.put([_this._endpointUrl,url].join("/"),object)};this.custom={get:get,put:put,post:post}}return CatApiEndpoint.prototype._addChildEndpoints=function(data){_.merge(data,this._res(data.id))},CatApiEndpoint.prototype._mapResponse=function(data){var _this=this,object=this.catConversionService.toClient(data,this.config);return _.isUndefined(object.id)||this._addChildEndpoints(object),_.isArray(object)&&_.forEach(object,function(item){return _this._addChildEndpoints(item)}),_.isArray(object.elements)&&_.forEach(object.elements,function(item){return _this._addChildEndpoints(item)}),object},CatApiEndpoint.prototype._removeEndpoints=function(object){var endpoints=this._res(object.id);return _.forEach(_.keys(endpoints),function(key){delete object[key]}),object},CatApiEndpoint.prototype._getSearchQuery=function(searchRequest){return searchRequest&&searchRequest instanceof window.cat.SearchRequest?"?"+this.catSearchService.encodeAsUrl(searchRequest):""},CatApiEndpoint.prototype.res=function(id){return this._res(id)},CatApiEndpoint.prototype.getEndpointUrl=function(){return this._endpointUrl},CatApiEndpoint.prototype.getEndpointName=function(){return this._endpointName},CatApiEndpoint.prototype.list=function(searchRequest){var _this=this,url=this._endpointListConfig.endpoint?this._endpointListConfig.endpoint:"";return this.$http.get(this._endpointUrl+url+this._getSearchQuery(searchRequest)).then(function(response){return _this._mapResponse(response.data)})},CatApiEndpoint.prototype.all=function(){var _this=this;return this.$http.get(this._endpointUrl+"/all").then(function(response){return _.map(response.data,function(elem){return _this._mapResponse(elem)})})},CatApiEndpoint.prototype.get=function(id){var _this=this;return this.$http.get(this._endpointUrl+"/"+id).then(function(response){return _this._mapResponse(response.data)})},CatApiEndpoint.prototype.copy=function(id){var _this=this;return this.$http.get(this._endpointUrl+"/copy/"+id).then(function(response){return _this._mapResponse(response.data)})},CatApiEndpoint.prototype.info=function(id){return this.$http.get(this._endpointUrl+"/"+id+"?info").then(function(response){return response.data})},CatApiEndpoint.prototype.save=function(object){var _this=this;_([34,342]).value();return object.id?this.$http.put(this._endpointUrl+"/"+object.id,this._removeEndpoints(object)).then(function(response){return _this._mapResponse(response.data)}):this.$http.post(this._endpointUrl,this._removeEndpoints(object)).then(function(response){return _this._mapResponse(response.data)})},CatApiEndpoint.prototype.remove=function(url){return this.$http({method:"DELETE",url:this._endpointUrl+"/"+url})},CatApiEndpoint}(),EndpointConfig=function(){function EndpointConfig(name,config){var _this=this;if(void 0===config&&(config={}),this.name=name,this.config=config,this.children={},!_.isUndefined(config.children)){var childrenConfig=config.children;delete config.children,_.forEach(_.keys(childrenConfig),function(childName){_this.child(childName,childrenConfig[childName])})}}return EndpointConfig.prototype.child=function(childName,childConfig){return _.isUndefined(childConfig)||(this.children[childName]=new EndpointConfig(childName,childConfig),this.children[childName].parent=this),this.children[childName]},EndpointConfig}(),CatApiServiceProvider=function(){function CatApiServiceProvider(){this._endpoints={},this.$get=["$http","catConversionService","catSearchService","CAT_API_SERVICE_DEFAULTS",this.$getCatApiService]}return CatApiServiceProvider.prototype.endpoint=function(name,settings){return _.isUndefined(settings)||(this._endpoints[name]=new EndpointConfig(name,settings)),this._endpoints[name]},CatApiServiceProvider.prototype.$getCatApiService=function($http,catConversionService,catSearchService,CAT_API_SERVICE_DEFAULTS){var _this=this,catApiService={},dynamicEndpoints={};return catApiService.dynamicEndpoint=function(name,settings){if("object"==typeof name&&_.isUndefined(settings)&&(settings=name,name=settings.url),_.isUndefined(dynamicEndpoints[name])){if(_.isUndefined(settings))throw new Error("Undefined dynamic endpoint settings");dynamicEndpoints[name]=new CatApiEndpoint(CAT_API_SERVICE_DEFAULTS.endpointUrlPrefix,new EndpointConfig(name,settings),$http,catConversionService,catSearchService)}return dynamicEndpoints[name]},_.forEach(_.keys(this._endpoints),function(path){catApiService[path]=new CatApiEndpoint(CAT_API_SERVICE_DEFAULTS.endpointUrlPrefix,_this._endpoints[path],$http,catConversionService,catSearchService)}),catApiService},CatApiServiceProvider}();angular.module("cat.service.api",["cat.service.conversion","cat.service.search"]).constant("CAT_API_SERVICE_DEFAULTS",{endpointUrlPrefix:"api/"}).provider("catApiService",[CatApiServiceProvider]),angular.module("cat.service.api").provider("$api",[CatApiServiceProvider]);var CatBreadcrumbsService=function(){function CatBreadcrumbsService(catBreadcrumbs,$state){this.catBreadcrumbs=catBreadcrumbs,this.$state=$state}return CatBreadcrumbsService.prototype.clear=function(){this.catBreadcrumbs.length=0},CatBreadcrumbsService.prototype.set=function(bcs){var _this=this;this.clear(),_.forEach(bcs,function(bc){_this.catBreadcrumbs.push(bc)})},CatBreadcrumbsService.prototype.get=function(){return this.catBreadcrumbs},CatBreadcrumbsService.prototype.addFirst=function(entry){this.catBreadcrumbs.unshift(entry)},CatBreadcrumbsService.prototype.removeFirst=function(){return this.catBreadcrumbs.shift()},CatBreadcrumbsService.prototype.push=function(entry){this.catBreadcrumbs.push(entry)},CatBreadcrumbsService.prototype.pop=function(){return this.catBreadcrumbs.pop()},CatBreadcrumbsService.prototype.length=function(){return this.catBreadcrumbs.length},CatBreadcrumbsService.prototype.replaceLast=function(newVal){this.catBreadcrumbs[this.catBreadcrumbs.length-1]=newVal},CatBreadcrumbsService.prototype.generateFromConfig=function(config){this.clear();for(var uiStack=[],currentState=this.$state.$current.parent,currentEndpoint=config.endpoint,count=0,parents="^";currentState&&currentState.parent;){var stateName=currentState.name;if(!/\.tab$/g.test(stateName)){var href=this.$state.href(parents),breadcrumb=void 0;if(config.parents.length>count){var parent_1=config.parents[count++],regex=new RegExp("/"+window.cat.util.pluralize(currentEndpoint.getEndpointName())+"$");href=href.replace(regex,"?tab="+currentEndpoint.getEndpointName()),breadcrumb={url:href,title:parent_1.name},uiStack.unshift(breadcrumb)}else breadcrumb={title:window.cat.util.capitalize(window.cat.util.pluralize(currentEndpoint.getEndpointName())),key:"cc.catalysts.cat-breadcrumbs.entry."+currentEndpoint.getEndpointName(),url:href};this.addFirst(breadcrumb),currentEndpoint=currentEndpoint.parentEndpoint}currentState=currentState.parent,parents+=".^"}return uiStack},CatBreadcrumbsService}();angular.module("cat.service.breadcrumbs",[]).value("catBreadcrumbs",[]).service("catBreadcrumbsService",["catBreadcrumbs","$state",CatBreadcrumbsService]);var CatConversionService=function(){function CatConversionService(catConversionFunctions){this.catConversionFunctions=catConversionFunctions}return CatConversionService.prototype.toClient=function(serverData,context){return this.catConversionFunctions.toClient(serverData,context)},CatConversionService.prototype.toServer=function(clientData){return this.catConversionFunctions.toServer(clientData)},CatConversionService}();angular.module("cat.service.conversion",[]).value("catConversionFunctions",{toClient:_convertToClientData,toServer:function(clientData,context){return clientData}}).service("catConversionService",["catConversionFunctions",CatConversionService]);var CatElementVisibilityService=function(){function CatElementVisibilityService(){}return CatElementVisibilityService.prototype.isVisible=function(){return!0},CatElementVisibilityService}();angular.module("cat.service.elementVisibility",[]).service("catElementVisibilityService",[CatElementVisibilityService]);var CatI18nLocaleService=function(){function CatI18nLocaleService($locale,CAT_I18N_DEFAULT_LOCALE){this.$locale=$locale,this.CAT_I18N_DEFAULT_LOCALE=CAT_I18N_DEFAULT_LOCALE}return CatI18nLocaleService.prototype.getLanguageOfLocale=function(locale){return _.isUndefined(locale)?void 0:-1!==locale.indexOf("-")?locale.split("-")[0]:locale},CatI18nLocaleService.prototype.getCurrentLocale=function(){return this.$locale.id},CatI18nLocaleService.prototype.getDefaultLocale=function(){return this.CAT_I18N_DEFAULT_LOCALE},CatI18nLocaleService}();angular.module("cat.service.i18n.locale",[]).constant("CAT_I18N_DEFAULT_LOCALE","de").service("catI18nLocaleService",["$locale","CAT_I18N_DEFAULT_LOCALE",CatI18nLocaleService]);var CatI18nMessageSourceService=function(){function CatI18nMessageSourceService($q,catI18nLocaleService,CAT_I18N_DEFAULT_LOCALE){this.$q=$q,this.catI18nLocaleService=catI18nLocaleService,this.CAT_I18N_DEFAULT_LOCALE=CAT_I18N_DEFAULT_LOCALE}return CatI18nMessageSourceService.prototype._getLocale=function(locale){return locale||this.catI18nLocaleService.getDefaultLocale()},CatI18nMessageSourceService.prototype._getMessages=function(locale){var localeId=this._getLocale(locale),messages=window.cat.i18n[localeId];return _.isUndefined(messages)&&(messages=this._getMessages(this.catI18nLocaleService.getDefaultLocale())),localeId!==this.CAT_I18N_DEFAULT_LOCALE&&_.isUndefined(messages)&&(messages=this._getMessages(this.CAT_I18N_DEFAULT_LOCALE)),messages},CatI18nMessageSourceService.prototype.getMessages=function(locale){return this.$q.when(this._getMessages(locale))},CatI18nMessageSourceService.prototype.getMessage=function(key,locale){var bundle=this._getMessages(locale);return _.isUndefined(bundle)||_.isUndefined(bundle[key])?this.$q.reject("No message found for key '"+key+"' and the given locale '"+this._getLocale(locale)+"'"):this.$q.when(bundle[key])},CatI18nMessageSourceService.prototype.hasMessage=function(key,locale){var bundle=this._getMessages(locale);return this.$q.when(!_.isUndefined(bundle)&&!_.isUndefined(bundle[key]))},CatI18nMessageSourceService}();angular.module("cat.service.i18n.message",["cat.service.i18n.locale"]).service("catI18nMessageSourceService",["$q","catI18nLocaleService","CAT_I18N_DEFAULT_LOCALE",CatI18nMessageSourceService]);var CatI18nResponseHandler=function(){function CatI18nResponseHandler(){}return CatI18nResponseHandler.prototype.handleTranslationSuccess=function(translation,scope,element){element.text(translation)},CatI18nResponseHandler.prototype.handleTranslationError=function(reason,scope,element){element.text("##missingkey: "+scope.key)},CatI18nResponseHandler}();angular.module("cat.service.i18n.responseHandler",[]).service("catI18nResponseHandler",[CatI18nResponseHandler]);var CatI18nService=function(){function CatI18nService($q,$log,catI18nMessageSourceService,catI18nMessageParameterResolver){this.$q=$q,this.$log=$log,this.catI18nMessageSourceService=catI18nMessageSourceService,this.catI18nMessageParameterResolver=catI18nMessageParameterResolver}return CatI18nService.prototype.translate=function(key,parameters,locale){var _this=this,model=parameters;return _.isArray(parameters)&&parameters.forEach(function(value,idx){model["p"+idx]=value}),this.canTranslate(key,locale).then(function(canTranslate){if(canTranslate)return _this.catI18nMessageSourceService.getMessage(key,locale);var reason="No translation for key '"+key+"' available!";return _this.$q.reject(reason)}).then(function(message){var translation=_this.catI18nMessageParameterResolver(message,model);return _.isString(translation)?translation:(_this.$log.warn("Didn't get a string from catI18nMessageParameterResolver"),_this.$q.reject(translation))}).then(void 0,function(reason){return _this.$log.warn(reason),_this.$q.reject(reason)})},CatI18nService.prototype.canTranslate=function(key,locale){return this.catI18nMessageSourceService.getMessages(locale).then(function(messages){return!_.isUndefined(messages)&&!_.isUndefined(messages[key])})},CatI18nService}();angular.module("cat.service.i18n",["cat.service.i18n.message","cat.service.i18n.responseHandler"]).value("catI18nMessageParameterResolver",function(message,parameters){return _.template(message,{interpolate:/{{([\s\S\d]+?)}}/g})(parameters||{})}).service("catI18nService",["$q","$log","catI18nMessageSourceService","catI18nMessageParameterResolver",CatI18nService]);var CatListDataLoadingService=function(){function CatListDataLoadingService($location,$q,catApiService,catSearchService){this.$location=$location,this.$q=$q,this.catApiService=catApiService,this.catSearchService=catSearchService}return CatListDataLoadingService.prototype.load=function(endpoint,searchRequest){return endpoint.list(searchRequest).then(function(data){var pagination=searchRequest.pagination(),result={count:data.totalCount,collection:data.elements,pagination:pagination,firstResult:(pagination.page-1)*pagination.size+1,lastResult:Math.min(pagination.page*pagination.size,data.totalCount),facets:data.facets,isSinglePageList:data.totalCount<=pagination.size,endpoint:endpoint,searchRequest:searchRequest};return delete data.totalCount,delete data.elements,delete data.facets,_.assign(result,data)})},CatListDataLoadingService.prototype.resolve=function(endpointName,defaultSort){void 0===defaultSort&&(defaultSort={property:"name",isDesc:!1});var searchRequest=this.catSearchService.fromLocation();return this.$location.search().sort||searchRequest.sort(defaultSort),this.load(this.catApiService[endpointName],searchRequest)},CatListDataLoadingService}();angular.module("cat.service.listDataLoading",["cat.service.api","ui.router"]).service("catListDataLoadingService",["$location","$q","catApiService","catSearchService",CatListDataLoadingService]);var CatRouteServiceProvider=function(){function CatRouteServiceProvider($stateProvider){var _this=this;this.$stateProvider=$stateProvider,this.viewNames=[],this.$get=[function(){return _this.viewNames}]}return CatRouteServiceProvider.$inject=["$stateProvider"],CatRouteServiceProvider._getListUrl=function(baseUrl,name,config){var listUrl=baseUrl+"/"+window.cat.util.pluralize(name.toLowerCase());return config&&config.url&&(listUrl=baseUrl+"/"+config.url),listUrl},CatRouteServiceProvider.prototype._registerAbstractState=function(url,name){this.$stateProvider.state(name,{"abstract":!0,template:"<ui-view></ui-view>",url:url})},CatRouteServiceProvider._getStateName=function(name,config){return config&&config.parent?config.parent+"."+name:name},CatRouteServiceProvider.prototype._registerDetailState=function(config,name){var stateName=CatRouteServiceProvider._getStateName(name,config),detailConfig=this._getDetailConfig(config,name);this.$stateProvider.state(stateName+".detail",detailConfig),config&&"tabs"===config.additionalViewTemplate&&this.$stateProvider.state(stateName+".tab",{"abstract":!0,template:"<ui-view></ui-view>",url:"/:"+name.toLowerCase()+"Id"})},CatRouteServiceProvider.prototype._registerListState=function(config,name){var stateName=CatRouteServiceProvider._getStateName(name,config),listConfig=this._getListConfig(config,name);this.$stateProvider.state(stateName+".list",listConfig)},CatRouteServiceProvider.prototype._getDetailConfig=function(config,name){var _config=_.assign({name:name},config);return{url:_config.url||"/:id",templateUrl:_config.templateUrl||"template/cat-base-detail.tpl.html",controller:"CatBaseDetailController",reloadOnSearch:_config.reloadOnSearch,resolve:{config:function($stateParams,catViewConfigService){return catViewConfigService.getDetailConfig(_config,$stateParams)}}}},CatRouteServiceProvider.prototype._getListConfig=function(config,name){var _config=_.assign({name:name},config);return{url:_config.url||"",reloadOnSearch:!1,controller:"CatBaseListController",controllerAs:"catBaseListController",templateUrl:_config.templateUrl||"template/cat-base-list.tpl.html",resolve:{config:function(catViewConfigService){return catViewConfigService.getListConfig(_config)}}}},CatRouteServiceProvider.prototype.detailRoute=function(baseUrl,name,config){var stateName=CatRouteServiceProvider._getStateName(name,config),viewData={viewData:config?config.viewData||{}:{}};this.viewNames.push(stateName);var listUrl=CatRouteServiceProvider._getListUrl(baseUrl,name,config);this._registerAbstractState(listUrl,stateName),this._registerDetailState(_.assign({},config,viewData),name)},CatRouteServiceProvider.prototype.listAndDetailRoute=function(baseUrl,name,config){void 0===config&&(config={});var stateName=CatRouteServiceProvider._getStateName(name,config),viewData={viewData:config.viewData||{}};this.viewNames.push(stateName);var listUrl=CatRouteServiceProvider._getListUrl(baseUrl,name,config);this._registerAbstractState(listUrl,stateName),this._registerDetailState(_.assign({},config.details,viewData),name),this._registerListState(_.assign({},config.list,viewData),name)},CatRouteServiceProvider}();angular.module("cat.service.route",["ui.router","cat.service.message","cat.service.breadcrumbs","cat.service.validation"]).provider("catRouteService",CatRouteServiceProvider).run(["$rootScope","$log","$globalMessages","catBreadcrumbsService","catValidationService",function($rootScope,$log,$globalMessages,catBreadcrumbsService,catValidationService){$rootScope.$on("$stateChangeError",function(){var exception=arguments[arguments.length-1];$globalMessages.addMessage("warning",exception),$log.warn(exception)}),$rootScope.$on("$stateChangeSuccess",function(){catBreadcrumbsService.clear(),catValidationService.clearValidationErrors()})}]);var CatUrlEncodingService=function(){function CatUrlEncodingService(){}return CatUrlEncodingService.prototype.encodeAsUrl=function(params){return params&&!_.isEmpty(params)?$.param(params):""},CatUrlEncodingService}(),CatSearchService=function(){function CatSearchService($location,catUrlEncodingService){this.$location=$location,this.catUrlEncodingService=catUrlEncodingService}return CatSearchService._encodeSort=function(_sort){return _sort.property?"sort="+_sort.property+":"+(_sort.isDesc===!0||"true"===_sort.isDesc?"desc":"asc"):""},CatSearchService._encodePagination=function(_pagination){return"page="+(_pagination.page?Math.max(0,_pagination.page-1):0)+"&size="+_pagination.size||100},CatSearchService.prototype._encodeSearch=function(_search){return this.catUrlEncodingService.encodeAsUrl(_search)},CatSearchService.prototype.urlEndoded=function(searchRequest){return _([CatSearchService._encodePagination(searchRequest.pagination()),CatSearchService._encodeSort(searchRequest.sort()),this._encodeSearch(searchRequest.search())]).reduce(CatSearchService._concatenate)},CatSearchService._concatenate=function(result,next){return result?next?result+"&"+next:result:next},CatSearchService.prototype.encodeAsUrl=function(searchRequest){return searchRequest?this.urlEndoded(searchRequest):""},CatSearchService.prototype.updateLocation=function(searchRequest){if(searchRequest){var pagination=searchRequest.pagination(),sort=searchRequest.sort(),search=searchRequest.search(),ret={};ret.page=pagination.page,ret.size=pagination.size,sort.property&&(ret.sort=sort.property,ret.rev=sort.isDesc||!1),_.forEach(_.keys(search),function(s){ret["search."+s]=search[s]}),this.$location.search(ret)}},CatSearchService.prototype.fromLocation=function(){return new window.cat.SearchRequest(this.$location.search())},CatSearchService}();angular.module("cat.service.search",[]).service("catUrlEncodingService",[CatUrlEncodingService]).service("catSearchService",["$location","catUrlEncodingService",CatSearchService]);var CatSelectConfigService=function(){function CatSelectConfigService(configs){this.configs=configs}return CatSelectConfigService.prototype.getConfig=function(name,options){var config=this.configs[name];if(!_.isUndefined(config)||!_.isUndefined(options))return assignDeep(_.clone(config)||{},options)},CatSelectConfigService}(),CatSelectConfigServiceProvider=function(){function CatSelectConfigServiceProvider(){var _this=this;this.configs={},this.$get=[function(){return new CatSelectConfigService(_this.configs)}]}return CatSelectConfigServiceProvider.prototype.config=function(name,config){return _.isUndefined(config)||(this.configs[name]=config),this.configs[name]},CatSelectConfigServiceProvider}();angular.module("cat.service.selectConfig",[]).provider("catSelectConfigService",[CatSelectConfigServiceProvider]);var CatUrlResolverService=function(){function CatUrlResolverService(){}return CatUrlResolverService.prototype.getTabTemplate=function(tab,config){for(var parentUrl=config.endpoint.getEndpointName(),parentTemplateNamePrefix=config.endpoint.getEndpointName(),currentEndpoint=config.endpoint;!_.isUndefined(currentEndpoint.parentEndpoint);){currentEndpoint=config.endpoint.parentEndpoint;var parentEndpointName=currentEndpoint.getEndpointName();parentUrl=parentEndpointName+"/"+parentUrl,parentTemplateNamePrefix=parentEndpointName+"-"+parentTemplateNamePrefix}return parentUrl+"/"+tab+"/"+parentTemplateNamePrefix+"-"+tab+"-list.tpl.html"},CatUrlResolverService}();angular.module("cat.url.resolver.service",[]).service("urlResolverService",[CatUrlResolverService]);var ValidationContext=function(){function ValidationContext(uuid){this.uuid=uuid,this.fieldErrors={},this.knownFields=[]}return ValidationContext.prototype.registerField=function(name){-1===this.knownFields.indexOf(name)&&this.knownFields.push(name)},ValidationContext}(),CatValidationService=function(){function CatValidationService($log,$globalMessages,catValidations,catValidationContexts,catMessagesConfig,catI18nService){this.$log=$log,this.$globalMessages=$globalMessages,this.catValidations=catValidations,this.catValidationContexts=catValidationContexts,this.catMessagesConfig=catMessagesConfig,this.catI18nService=catI18nService}return CatValidationService.prototype.getContext=function(contextId){if(void 0!==contextId){var validations=this.catValidationContexts[contextId];if(void 0===validations)throw new Error("Unknown contextId: "+contextId);return validations}return this.catValidations},CatValidationService.prototype.createContext=function(){var uuid=window.cat.util.generateUUID();return this.catValidationContexts[uuid]=new ValidationContext(uuid),uuid},CatValidationService.prototype.destroyContext=function(contextId){delete this.catValidationContexts[contextId]},CatValidationService.prototype.updateFromRejection=function(rejection){var contextId,_this=this;rejection.config&&(contextId=rejection.config.catValidationContextId);var context=this.getContext(contextId),fieldErrors=context.fieldErrors={},rejectionData=rejection.data;return context.global=void 0,
rejectionData?(rejectionData.fieldErrors&&rejectionData.fieldErrors.forEach(function(fieldError){_this.catMessagesConfig.knownFieldsActive===!0?-1!==context.knownFields.indexOf(fieldError.field)?(fieldErrors[fieldError.field]=fieldErrors[fieldError.field]||[],fieldErrors[fieldError.field].push(fieldError.message)):(rejection.data.globalErrors=rejection.data.globalErrors||[],rejection.data.globalErrors.push(fieldError.message)):(fieldErrors[fieldError.field]=fieldErrors[fieldError.field]||[],fieldErrors[fieldError.field].push(fieldError.message))}),void(rejectionData.globalErrors&&(context.global=rejection.data.globalErrors,this.$globalMessages.addMessages("error",rejection.data.globalErrors)))):(this.$log.warn("Network error occurred"),this.$log.warn(rejection),void this.catI18nService.translate("cc.catalysts.cat-validation-service.networkError").then(function(message){context.global=[message]}))},CatValidationService.prototype.clearValidationErrors=function(contextId){var context=this.getContext(contextId);context.global=void 0,context.fieldErrors={}},CatValidationService.prototype.hasGlobalErrors=function(contextId){var globalErrors=this.getContext(contextId).global;return!!globalErrors&&globalErrors.length>0},CatValidationService.prototype.getGlobalErrors=function(contextId){return this.getContext(contextId).global},CatValidationService.prototype.hasFieldErrors=function(fieldName,contextId){var fieldErrors=this.getContext(contextId).fieldErrors[fieldName];return!!fieldErrors&&fieldErrors.length>0},CatValidationService.prototype.hasAnyFieldErrors=function(contextId){var fieldErrors=this.getContext(contextId).fieldErrors;return!_.isEmpty(fieldErrors)},CatValidationService.prototype.getFieldErrors=function(fieldName,contextId){return this.getContext(contextId).fieldErrors[fieldName]},CatValidationService.prototype.hasErrors=function(contextId){var hasGlobalErrors=this.hasGlobalErrors(contextId),hasFieldErrors=this.hasAnyFieldErrors(contextId);return hasGlobalErrors||hasFieldErrors},CatValidationService.prototype.prepareConfig=function(contextId,config){return _.assign(config||{},{catValidationContextId:contextId})},CatValidationService}();angular.module("cat.service.validation",["cat.service.message","cat.service.i18n"]).value("catValidations",new ValidationContext).value("catValidationContexts",{}).service("catValidationService",["$log","$globalMessages","catValidations","catValidationContexts","catMessagesConfig","catI18nService",CatValidationService.prototype.constructor]);var CatViewConfigService=function(){function CatViewConfigService($q,catApiService,catListDataLoadingService){this.$q=$q,this.catApiService=catApiService,this.catListDataLoadingService=catListDataLoadingService}return CatViewConfigService.toLowerCaseName=function(name){return name?name.toLowerCase():""},CatViewConfigService.prototype.getDetailData=function($stateParams,Model,endpoint){var detailPromise,detailId=$stateParams.id;return detailPromise="new"===detailId?this.$q.when(new Model):endpoint.get(detailId)},CatViewConfigService.prototype.getEndpoint=function(endpointName,parentEndpointNames,$stateParams){var _this=this,endpoint=this.catApiService[endpointName];return _.isArray(parentEndpointNames)&&(_.forEach(parentEndpointNames,function(parentEndpointName,idx){var currentEndpoint;currentEndpoint=0===idx?_this.catApiService[parentEndpointName]:endpoint[parentEndpointName],endpoint=currentEndpoint.res($stateParams[parentEndpointName+"Id"])}),endpoint=endpoint[endpointName]),endpoint},CatViewConfigService.prototype.getParentInfo=function(endpoint){var _this=this;if(_.isUndefined(endpoint)||_.isUndefined(endpoint.parentInfo))return this.$q.when([]);var parents=[];return endpoint.parentInfo().then(function(parent){return parents.push(parent),_this.getParentInfo(endpoint.parentEndpoint)}).then(function(response){return parents.push(response),parents=_.flatten(parents)})},CatViewConfigService.prototype.getDetailConfig=function(config,$stateParams){var endpointName,parentEndpointNames;_.isString(config.endpoint)?endpointName=config.endpoint:_.isObject(config.endpoint)?(parentEndpointNames=config.endpoint.parents,endpointName=config.endpoint.name):endpointName=CatViewConfigService.toLowerCaseName(config.name);var Model=config.model||window.cat.util.defaultModelResolver(config.name),parentUrl="",parentTemplateNamePrefix="";_.isArray(parentEndpointNames)&&_.forEach(parentEndpointNames,function(parentEndpointName){parentUrl+=parentEndpointName,parentUrl+="/",parentTemplateNamePrefix+=parentEndpointName,parentTemplateNamePrefix+="-"});var tabs,defaultViewUrl=parentUrl+endpointName+"/"+parentTemplateNamePrefix+endpointName+"-details-view.tpl.html",templateUrls={edit:parentUrl+endpointName+"/"+parentTemplateNamePrefix+endpointName+"-details-edit.tpl.html",view:defaultViewUrl};config.additionalViewTemplate===!0?templateUrls.view={main:defaultViewUrl,additional:parentUrl+endpointName+"/"+parentTemplateNamePrefix+endpointName+"-additional-details-view.tpl.html"}:"tabs"===config.additionalViewTemplate&&(templateUrls.view={main:defaultViewUrl,additional:"template/cat-base-additional-details-tabs-view.tpl.html"},tabs=config.additionalViewTemplateTabs);var deferred=this.$q.defer(),endpoint=this.getEndpoint(endpointName,parentEndpointNames,$stateParams),resolvedConfig={viewData:config.viewData,name:config.name,controller:config.controller||config.name+"DetailsController",endpoint:endpoint,Model:Model,templateUrls:templateUrls,tabs:tabs},detailPromise=this.getDetailData($stateParams,Model,endpoint);detailPromise.then(function(data){resolvedConfig.detail=data});var parentsPromise=this.getParentInfo(endpoint);return parentsPromise.then(function(parents){resolvedConfig.parents=parents}),this.$q.all([detailPromise,parentsPromise]).then(function(){deferred.resolve(resolvedConfig)},function(reason){deferred.reject(reason)}),deferred.promise},CatViewConfigService.prototype.getListDataPromise=function(config,name){return this.catListDataLoadingService.resolve(config.endpoint||name,config.defaultSort)},CatViewConfigService.prototype.getListConfig=function(config){var name=CatViewConfigService.toLowerCaseName(config.name),deferredConfig=this.$q.defer(),resolvedConfig={listData:void 0,viewData:config.viewData,name:config.name,controller:config.controller||config.name+"Controller",title:window.cat.util.pluralize(config.name),searchProps:config.searchProps||window.cat.util.defaultListSearchProps,listTemplateUrl:config.listTemplateUrl||name+"/"+name+"-list.tpl.html"};return this.getListDataPromise(config,name).then(function(listData){resolvedConfig.listData=listData,deferredConfig.resolve(resolvedConfig)}),deferredConfig.promise},CatViewConfigService}();angular.module("cat.service.view.config",["cat.service.api","cat.service.listDataLoading"]).service("catViewConfigService",["$q","catApiService","catListDataLoadingService",CatViewConfigService]);var CatViewServiceProvider=function(){function CatViewServiceProvider(catRouteServiceProvider,catApiServiceProvider){var _this=this;this.catRouteServiceProvider=catRouteServiceProvider,this.catApiServiceProvider=catApiServiceProvider,this.viewNames=[],this.endpointNames=[],this.$get=[function(){return{views:_this.viewNames,endpoints:_this.endpointNames}}]}return CatViewServiceProvider.prototype.listAndDetailView=function(baseUrl,name,config){var endpointName=name.toLowerCase(),url=window.cat.util.pluralize(endpointName);config&&(url=config.url||url);var endpoint={model:window.cat.util.defaultModelResolver(name),url:url};config&&(endpoint=_.assign(endpoint,config.endpoint)),this.viewNames.push(name),this.endpointNames.push(endpointName),this.catApiServiceProvider.endpoint(name.toLowerCase(),endpoint),this.catRouteServiceProvider.listAndDetailRoute(baseUrl,name,config)},CatViewServiceProvider}();angular.module("cat.service.view",["cat.service.api","cat.service.route","cat.service.view.config"]).provider("catViewService",["catRouteServiceProvider","catApiServiceProvider",CatViewServiceProvider]);var CatErrorHttpInterceptor=function(){function CatErrorHttpInterceptor($q,loadingService,catValidationMessageHandler){this.$q=$q,this.loadingService=loadingService,this.catValidationMessageHandler=catValidationMessageHandler}return CatErrorHttpInterceptor.prototype.request=function(config){return this.loadingService.start(),config},CatErrorHttpInterceptor.prototype.requestError=function(rejection){return this.loadingService.stop(),this.$q.reject(rejection)},CatErrorHttpInterceptor.prototype.response=function(success){return this.loadingService.stop(),success},CatErrorHttpInterceptor.prototype.responseError=function(rejection){return this.loadingService.stop(),this.catValidationMessageHandler.handleRejectedResponse(rejection),this.$q.reject(rejection)},CatErrorHttpInterceptor}();angular.module("cat.service.httpIntercept",["cat.service.loading","cat.service.validation"]).service("errorHttpInterceptor",["$q","loadingService","catValidationMessageHandler",CatErrorHttpInterceptor]).config(["$httpProvider",function($httpProvider){$httpProvider.interceptors.push("errorHttpInterceptor")}]);var CatLoadingService=function(){function CatLoadingService($rootScope,$timeout,usSpinnerService,CAT_LOADING_SERVICE_DEFAULTS){var _this=this;this.$rootScope=$rootScope,this.$timeout=$timeout,this.usSpinnerService=usSpinnerService,this.CAT_LOADING_SERVICE_DEFAULTS=CAT_LOADING_SERVICE_DEFAULTS,this.activeCount=0;var stateChangeInProgress=!1;$rootScope.$on("$stateChangeStart",function(){stateChangeInProgress||(_this.start(),stateChangeInProgress=!0)}),$rootScope.$on("$stateChangeSuccess",function(){_this.stop(),stateChangeInProgress=!1}),$rootScope.$on("$stateChangeError",function(){_this.stop(),stateChangeInProgress=!1})}return CatLoadingService.prototype.start=function(){var _this=this;this.activeCount||this.startTimer||(this.stopTimer&&(this.$timeout.cancel(this.stopTimer),this.stopTimer=void 0),this.startTimer=this.$timeout(function(){_this.usSpinnerService.spin("loading-spinner"),_this.$rootScope.loading=!0,_this.startTime=(new Date).getTime()},this.CAT_LOADING_SERVICE_DEFAULTS.timeout)),this.activeCount++},CatLoadingService.prototype.stop=function(){var _this=this;if(this.activeCount--,!this.activeCount&&!this.stopTimer){this.startTimer&&(this.$timeout.cancel(this.startTimer),this.startTimer=void 0);var now=(new Date).getTime(),stopTimeout=this.CAT_LOADING_SERVICE_DEFAULTS.timeout+Math.max(this.CAT_LOADING_SERVICE_DEFAULTS.animationDuration-(now-this.startTime),0);this.stopTimer=this.$timeout(function(){_this.usSpinnerService.stop("loading-spinner"),_this.$rootScope.loading=!1},stopTimeout)}},CatLoadingService}();angular.module("cat.service.loading",["angularSpinner"]).constant("CAT_LOADING_SERVICE_DEFAULTS",{timeout:50,animationDuration:200}).service("loadingService",["$rootScope","$timeout","usSpinnerService","CAT_LOADING_SERVICE_DEFAULTS",CatLoadingService]);var MenuEntry=function(){function MenuEntry(id,options,parent){this.id=id,this.options=options,this.completeId=parent.completeId+"."+id}return MenuEntry.prototype.getOptions=function(){return this.options},MenuEntry.prototype.isGroup=function(){return!1},MenuEntry.prototype.isMenu=function(){return!1},MenuEntry}(),MenuGroup=function(){function MenuGroup(id,options,parent){this.id=id,this.options=options,this.menuEntries=[],this.completeId=parent.completeId+"."+id}return MenuGroup.prototype.addMenuEntry=function(menuEntryId,options){this.menuEntries.push(new MenuEntry(menuEntryId,options,this))},MenuGroup.prototype.getOptions=function(){return this.options},MenuGroup.prototype.getEntries=function(){return _.sortBy(this.menuEntries,function(entry){return entry.getOptions().sortOrder||1e4})},MenuGroup.prototype.isGroup=function(){return!0},MenuGroup.prototype.isMenu=function(){return!1},MenuGroup.prototype.isSubMenu=function(){return this.options.displayAsSubMenu===!0},MenuGroup}(),Menu=function(){function Menu(id,options){this.id=id,this.options=options,this.menuEntries=[],this.menuGroups={},this.completeId=id}return Menu.prototype.addMenuGroup=function(groupId,options){this.menuGroups[groupId]=new MenuGroup(groupId,options,this)},Menu.prototype.addMenuEntry=function(groupId,menuEntryId,options){_.isUndefined(groupId)?this.menuEntries.push(new MenuEntry(menuEntryId,options,this)):this.menuGroups[groupId].addMenuEntry(menuEntryId,options)},Menu.prototype.getGroups=function(){return _.sortBy(_.map(this.menuGroups,function(menuGroup){return menuGroup}),function(menuGroup){return menuGroup.getOptions().sortOrder||1e4})},Menu.prototype.getEntries=function(groupId){return _.isUndefined(groupId)?_.sortBy(this.menuEntries,function(entry){return entry.getOptions().sortOrder||1e4}):this.menuGroups[groupId].getEntries()},Menu.prototype.getFlattened=function(){return _.flatten([this.menuEntries,_.map(this.getGroups(),function(group){return group.getOptions().displayAsSubMenu===!0?(group.subEntries=group.getEntries(),[group]):[group,group.getEntries()]})],!!_.flattenDeep)},Menu.prototype.isMenu=function(){return!0},Menu.prototype.isGroup=function(){return!1},Menu.prototype.getOptions=function(){return this.options},Menu}(),MenuBar=function(){function MenuBar(id,options){this.id=id,this.options=options,this.menus={}}return MenuBar.prototype.addMenu=function(menuId,options){this.menus[menuId]=new Menu(menuId,options)},MenuBar.prototype.addMenuGroup=function(menuId,groupId,options){this.menus[menuId].addMenuGroup(groupId,options)},MenuBar.prototype.addMenuEntry=function(menuId,groupId,menuEntryId,options){this.menus[menuId].addMenuEntry(groupId,menuEntryId,options)},MenuBar.prototype.getMenus=function(){return _.map(this.menus,function(menu){return menu})},MenuBar.prototype.getOptions=function(){return this.options},MenuBar}(),MainMenuProvider=function(){function MainMenuProvider(){this.mainMenu=new MenuBar("main.menu",{}),this.menus=[],this._groups=[],this._entries=[]}return MainMenuProvider.prototype.menu=function(moduleId,options){this.menus.push({menuId:moduleId,options:options})},MainMenuProvider.prototype.menuGroup=function(moduleId,groupId,options){this._groups.push({menuId:moduleId,groupId:groupId,options:options})},MainMenuProvider.prototype.menuEntry=function(moduleId,groupId,entryId,options){_.isUndefined(options)&&(options=entryId,entryId=groupId,groupId=void 0),this._entries.push({menuId:moduleId,groupId:groupId,entryId:entryId,options:options})},MainMenuProvider.prototype.$get=function(){var _this=this;return _.forEach(this.menus,function(menu){_this.mainMenu.addMenu(menu.menuId,menu.options)}),_.forEach(this._groups,function(group){_this.mainMenu.addMenuGroup(group.menuId,group.groupId,group.options)}),_.forEach(this._entries,function(entry){_this.mainMenu.addMenuEntry(entry.menuId,entry.groupId,entry.entryId,entry.options)}),this.mainMenu},MainMenuProvider}();angular.module("cat.service.menu",[]).provider("$mainMenu",[MainMenuProvider]);var Message=function(){function Message(data){void 0===data&&(data={}),this.text=data.text||"",this.type=data.type,this.timeToLive=data.timeToLive||0}return Message}(),CatMessageService=function(){function CatMessageService($rootScope){var _this=this;this.messages={},$rootScope.$on("$stateChangeSuccess",function(){_this.clearDeadMessages(),_this.decreaseTimeToLive()})}return CatMessageService.prototype.getMessages=function(type){return type?_.map(this.messages[type],function(message){return message.text}):[]},CatMessageService.prototype.hasMessages=function(type){return type?!!this.messages[type]&&0!==this.messages[type].length:!1},CatMessageService.prototype.clearMessages=function(type){return type?void(this.messages[type]=[]):void(this.messages={})},CatMessageService.prototype.clearDeadMessages=function(){for(var type in this.messages)this.messages[type]=_.filter(this.messages[type],function(message){return message.timeToLive>0})},CatMessageService.prototype.addMessage=function(type,message,flash){void 0===flash&&(flash=!1),type&&(this.messages[type]||this.clearMessages(type),this.messages[type].push(new Message({text:message,type:type,timeToLive:flash?1:0})))},CatMessageService.prototype.decreaseTimeToLive=function(){for(var type in this.messages)_.forEach(this.messages[type],function(message){message.timeToLive--})},CatMessageService.prototype.addMessages=function(type,messages){var _this=this;type&&_.forEach(messages,function(message){_this.addMessage(type,message)})},CatMessageService.prototype.setMessages=function(type,messages){type&&(this.clearMessages(type),messages&&this.addMessages(type,messages))},CatMessageService}(),CatValidationMessageHandler=function(){function CatValidationMessageHandler($globalMessages,catValidationService){this.$globalMessages=$globalMessages,this.catValidationService=catValidationService}return CatValidationMessageHandler.prototype.handleRejectedResponse=function(rejection){if(this.$globalMessages.clearMessages("error"),rejection.data&&rejection.data.error){var error="["+rejection.status+" - "+rejection.statusText+"] "+rejection.data.error;rejection.data.cause&&(error+="\n"+rejection.data.cause),this.$globalMessages.addMessage("error",error)}this.catValidationService.updateFromRejection(rejection)},CatValidationMessageHandler}();return angular.module("cat.service.message",["cat.config.messages"]).service("catValidationMessageHandler",["$globalMessages","catValidationService",CatValidationMessageHandler]).service("$globalMessages",["$rootScope",CatMessageService]),angular.module("cat.filters",["cat.filters.replaceText"]),angular.module("cat.service",["cat.service.conversion","cat.service.api","cat.service.breadcrumbs","cat.service.elementVisibility","cat.service.i18n","cat.service.listDataLoading","cat.service.route","cat.service.selectConfig","cat.service.view","cat.service.loading","cat.service.httpIntercept","cat.service.menu","cat.service.message","cat.service.search"]),angular.module("cat.controller",["cat.controller.base.detail","cat.controller.base.list"]),angular.module("cat.directives",["cat.directives.autofocus","cat.directives.checkbox","cat.directives.confirmClick","cat.directives.elementVisible","cat.directives.fieldErrors","cat.directives.fieldErrors.info","cat.directives.globalErrors","cat.directives.input","cat.directives.inputGroup","cat.directives.loadMore","cat.directives.menu","cat.directives.select","cat.directives.i18n","cat.directives.paginated","cat.directives.facets","cat.directives.sortable","cat.directives.form","cat.directives.numbersOnly","cat.directives.breadcrumbs"]),angular.module("cat",["cat.service","cat.directives","cat.filters","cat.controller","ui.bootstrap"]),"cat"});
//# sourceMappingURL=cat-angular-require.min.js.map
