/*!
 The MIT License (MIT)

 Copyright (c) 2014-2015 Catalysts

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
 */
!function(window){"use strict";function catLog4Angular(angular){return angular.module("cat.service.log",[]).constant("ROOT_LOGGER_NAME","ROOT").constant("DEFAULT_LEVEL","info").constant("LOG_LEVEL_ORDER",{debug:1,info:2,warn:3,error:4}).constant("CONSOLE_APPENDER",{report:function(level,group,message){"object"==typeof console&&(message instanceof Error?(console[level](group+" "+message.message),console.log(message.stack)):console[level](group+" "+message))}}).provider("catLogService",["ROOT_LOGGER_NAME","DEFAULT_LEVEL","LOG_LEVEL_ORDER",function(ROOT_LOGGER_NAME,DEFAULT_LEVEL,LOG_LEVEL_ORDER){var providerSelf=this,config={};config[ROOT_LOGGER_NAME]=DEFAULT_LEVEL;var dumpMemorySizes=!1,appenderList=[],configureLogLevel=function(group,level){if(group===ROOT_LOGGER_NAME&&void 0===level)throw new Error("Cannot undefine the log level of the root logger.");return config[group]=level,this};this.configure=configureLogLevel,this.appender=function(appender){return appenderList.push(appender),this},this.enableMemorySizes=function(){return dumpMemorySizes=!0,this},this.disableMemorySizes=function(){return dumpMemorySizes=!1,this},this.$get=function(){var rootLogger={parent:void 0,group:ROOT_LOGGER_NAME,resolveLevel:function(){return config[ROOT_LOGGER_NAME]},setLevel:function(newLevel){configureLogLevel(this.group,newLevel)}},resolveLevel=function(){if(angular.isDefined(config[this.group]))return config[this.group];if(angular.isDefined(this.parent))return this.parent.resolveLevel();throw new Error('Neither log level nor parent set for this logger: "'+this.group+'".')},loggify=function(logger){angular.forEach(["debug","info","warn","error"],function(level){var methodLvlNumber=LOG_LEVEL_ORDER[level],log=function(message){LOG_LEVEL_ORDER[logger.resolveLevel()]<=methodLvlNumber&&angular.forEach(appenderList,function(appender){var memorySizes;dumpMemorySizes&&window.performance&&window.performance.memory&&(memorySizes=window.performance.memory),appender.report(level,logger.group,message,memorySizes)})};logger[level]=function(message,func){if("undefined"==typeof func)log(message);else{var start=(new Date).getTime();log("BEFORE: "+message),func();var elapsed=(new Date).getTime()-start;log("AFTER: "+message+" took "+elapsed+" ms")}}})};return loggify(rootLogger),{Logger:function(group,parent){if(angular.isUndefined(group))return rootLogger;angular.isUndefined(parent)&&(parent=rootLogger);var logger={parent:parent,group:group,resolveLevel:resolveLevel,setLevel:function(newLevel){configureLogLevel(this.group,newLevel)}};return loggify(logger),logger},appender:providerSelf.appender}}}]).config(["$provide",function($provide){$provide.decorator("$log",["$delegate","catLogService","ROOT_LOGGER_NAME",function($delegate,catLogService,ROOT_LOGGER_NAME){var rootLogger=catLogService.Logger();return angular.forEach(["debug","info","warn","error"],function(level){$delegate[level]=rootLogger[level]}),$delegate.Logger=catLogService.Logger,$delegate.setLevel=rootLogger.setLevel,$delegate.group=ROOT_LOGGER_NAME,$delegate}])}]),angular.module("cat.service.log").constant("HTTP_LOGGER_NAME","catHttpLogAppender").provider("catHttpLogAppender",function(){var postUrl,intervalInSeconds=10,minLevel="info";this.interval=function(_intervalInSeconds){return intervalInSeconds=_intervalInSeconds,this},this.postUrl=function(_postUrl){return postUrl=_postUrl,this},this.minUploadLevel=function(_minLevel){return minLevel=_minLevel,this},this.$get=["$http","$interval","$log","HTTP_LOGGER_NAME","LOG_LEVEL_ORDER",function($http,$interval,$log,HTTP_LOGGER_NAME,LOG_LEVEL_ORDER){var logger=$log.Logger(HTTP_LOGGER_NAME);if("undefined"==typeof postUrl)throw new Error("catHttpLogAppenderProvider requires definition of postUrl");var logs=[],appender={report:function(level,group,message,memorySizes){logs.push({level:level,group:group,message:"string"==typeof message?message:message.toString(),memorySizes:memorySizes,timestamp:(new Date).getTime()})},flush:function(){var minLevelOrder=LOG_LEVEL_ORDER[minLevel],logsToSend=[];return angular.forEach(logs,function(logEntry){LOG_LEVEL_ORDER[logEntry.level]>=minLevelOrder&&logsToSend.push(logEntry)}),logs.length=0,logsToSend.length>0?$http.post(postUrl,logsToSend).success(function(){logger.debug("Successfully uploaded logs.")}).error(function(data,status,headers,config,statusText){logger.debug("Error uploading logs: "+status+" "+statusText)}):void logger.debug("No logs to upload - skipping upload request.")}};return $interval(appender.flush,1e3*intervalInSeconds,0,!1),appender}]}),"cat.service.log"}window.require&&window.define?window.define(["angular"],catLog4Angular):catLog4Angular(window.angular)}(window);
//# sourceMappingURL=cat-log4angular.min.js.map