/*!
 * cmmn-js - cmmn-modeler v0.5.3

 * Copyright 2014, 2015 camunda Services GmbH and other contributors
 *
 * Released under the bpmn.io license
 * http://bpmn.io/license
 *
 * Source Code: https://github.com/bpmn-io/cmmn-js
 *
 * Date: 2016-07-26
 */
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.CmmnJS = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var Ids = _dereq_(256);

var Viewer = _dereq_(3);

var NavigatedViewer = _dereq_(2);

var initialDiagram = '<?xml version="1.0" encoding="UTF-8"?>' +
  '<cmmn:definitions xmlns:dc="http://www.omg.org/spec/CMMN/20151109/DC" ' +
                    'xmlns:di="http://www.omg.org/spec/CMMN/20151109/DI" ' +
                    'xmlns:cmmndi="http://www.omg.org/spec/CMMN/20151109/CMMNDI" ' +
                    'xmlns:cmmn="http://www.omg.org/spec/CMMN/20151109/MODEL" ' +
                    'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" id="Test" ' +
                    'targetNamespace="http://bpmn.io/schema/cmmn">' +
    '<cmmn:case id="Case_1">' +
      '<cmmn:casePlanModel id="CasePlanModel_1" name="A CasePlanModel">' +
        '<cmmn:planItem id="PlanItem_1" definitionRef="Task_1" />' +
        '<cmmn:task id="Task_1" />' +
      '</cmmn:casePlanModel>' +
    '</cmmn:case>' +
    '<cmmndi:CMMNDI>' +
      '<cmmndi:CMMNDiagram id="CMMNDiagram_1">' +
        '<cmmndi:Size xsi:type="dc:Dimension" width="500" height="500" />' +
        '<cmmndi:CMMNShape id="DI_CasePlanModel_1" cmmnElementRef="CasePlanModel_1">' +
          '<dc:Bounds x="114" y="63" width="534" height="389" />' +
          '<cmmndi:CMMNLabel />' +
        '</cmmndi:CMMNShape>' +
        '<cmmndi:CMMNShape id="PlanItem_1_di" cmmnElementRef="PlanItem_1">' +
          '<dc:Bounds x="150" y="96" width="100" height="80" />' +
          '<cmmndi:CMMNLabel />' +
        '</cmmndi:CMMNShape>' +
      '</cmmndi:CMMNDiagram>' +
    '</cmmndi:CMMNDI>' +
  '</cmmn:definitions>';

/**
 * A modeler for CMMN 1.1 diagrams.
 *
 * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include
 * additional features.

 *
 * ## Extending the Modeler
 *
 * In order to extend the viewer pass extension modules to bootstrap via the
 * `additionalModules` option. An extension module is an object that exposes
 * named services.
 *
 * The following example depicts the integration of a simple
 * logging component that integrates with interaction events:
 *
 *
 * ```javascript
 *
 * // logging component
 * function InteractionLogger(eventBus) {
 *   eventBus.on('element.hover', function(event) {
 *     console.log()
 *   })
 * }
 *
 * InteractionLogger.$inject = [ 'eventBus' ]; // minification save
 *
 * // extension module
 * var extensionModule = {
 *   __init__: [ 'interactionLogger' ],
 *   interactionLogger: [ 'type', InteractionLogger ]
 * };
 *
 * // extend the viewer
 * var cmmnModeler = new Modeler({ additionalModules: [ extensionModule ] });
 * cmmnModeler.importXML(...);
 * ```
 *
 *
 * ## Customizing / Replacing Components
 *
 * You can replace individual diagram components by redefining them in override modules.
 * This works for all components, including those defined in the core.
 *
 * Pass in override modules via the `options.additionalModules` flag like this:
 *
 * ```javascript
 * function CustomContextPadProvider(contextPad) {
 *
 *   contextPad.registerProvider(this);
 *
 *   this.getContextPadEntries = function(element) {
 *     // no entries, effectively disable the context pad
 *     return {};
 *   };
 * }
 *
 * CustomContextPadProvider.$inject = [ 'contextPad' ];
 *
 * var overrideModule = {
 *   contextPadProvider: [ 'type', CustomContextPadProvider ]
 * };
 *
 * var cmmnModeler = new Modeler({ additionalModules: [ overrideModule ]});
 * ```
 *
 * @param {Object} [options] configuration options to pass to the viewer
 * @param {DOMElement} [options.container] the container to render the viewer in, defaults to body.
 * @param {String|Number} [options.width] the width of the viewer
 * @param {String|Number} [options.height] the height of the viewer
 * @param {Object} [options.moddleExtensions] extension packages to provide
 * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules
 * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules
 */
function Modeler(options) {
  Viewer.call(this, options);

  // hook ID collection into the modeler
  this.on('import.parse.complete', function(event) {
    if (!event.error) {
      this._collectIds(event.definitions, event.context);
    }
  }, this);

  this.on('diagram.destroy', function() {
    this.moddle.ids.clear();
  }, this);
}

inherits(Modeler, Viewer);

module.exports = Modeler;

module.exports.Viewer = Viewer;

module.exports.NavigatedViewer = NavigatedViewer;

/**
 * Create a new diagram to start modeling.
 *
 * @param {Function} [done]
 */
Modeler.prototype.createDiagram = function(done) {
  return this.importXML(initialDiagram, done);
};

/**
 * Create a moddle instance, attaching ids to it.
 *
 * @param {Object} options
 */
Modeler.prototype._createModdle = function(options) {
  var moddle = Viewer.prototype._createModdle.call(this, options);

  // attach ids to moddle to be able to track
  // and validated ids in the CMMN 1.1 XML document
  // tree
  moddle.ids = new Ids([ 32, 36, 1 ]);

  return moddle;
};

/**
 * Collect ids processed during parsing of the
 * definitions object.
 *
 * @param {ModdleElement} definitions
 * @param {Context} context
 */
Modeler.prototype._collectIds = function(definitions, context) {

  var moddle = definitions.$model,
      ids = moddle.ids,
      id;

  // remove references from previous import
  ids.clear();

  for (id in context.elementsById) {
    ids.claim(id, context.elementsById[id]);
  }
};


Modeler.prototype._interactionModules = [
  // non-modeling components
  _dereq_(121),
  _dereq_(226),
  _dereq_(229),
  _dereq_(50)
];

Modeler.prototype._modelingModules = [
  // modeling components
  _dereq_(127),
  _dereq_(144),
  _dereq_(185),
  _dereq_(201),
  _dereq_(10),
  _dereq_(12),
  _dereq_(16),
  _dereq_(20),
  _dereq_(44),
  _dereq_(52),
  _dereq_(66),
  _dereq_(56)
];


// modules the modeler is composed of
//
// - viewer modules
// - interaction modules
// - modeling modules

Modeler.prototype._modules = [].concat(
  Modeler.prototype._modules,
  Modeler.prototype._interactionModules,
  Modeler.prototype._modelingModules);
},{"10":10,"12":12,"121":121,"127":127,"144":144,"16":16,"185":185,"2":2,"20":20,"201":201,"226":226,"229":229,"256":256,"257":257,"3":3,"44":44,"50":50,"52":52,"56":56,"66":66}],2:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var Viewer = _dereq_(3);


/**
 * A viewer that includes mouse navigation facilities
 *
 * @param {Object} options
 */
function NavigatedViewer(options) {
  Viewer.call(this, options);
}

inherits(NavigatedViewer, Viewer);

module.exports = NavigatedViewer;

NavigatedViewer.prototype._navigationModules = [
  _dereq_(229),
  _dereq_(226)
];

NavigatedViewer.prototype._modules = [].concat(
  NavigatedViewer.prototype._modules,
  NavigatedViewer.prototype._navigationModules);
},{"226":226,"229":229,"257":257,"3":3}],3:[function(_dereq_,module,exports){
/**
 * The code in the <project-logo></project-logo> area
 * must not be changed.
 *
 * @see http://bpmn.io/license for more information.
 */
'use strict';

var assign = _dereq_(398),
    omit = _dereq_(402),
    isString = _dereq_(395),
    isNumber = _dereq_(392);

var inherits = _dereq_(257);

var domify = _dereq_(415),
    domQuery = _dereq_(418),
    domRemove = _dereq_(419);

var Diagram = _dereq_(100),
    CmmnModdle = _dereq_(76);

var Importer = _dereq_(69);


function checkValidationError(err) {

  // check if we can help the user by indicating wrong CMMN 1.1 xml
  // (in case he or the exporting tool did not get that right)

  var pattern = /unparsable content <([^>]+)> detected([\s\S]*)$/;
  var match = pattern.exec(err.message);

  if (match) {
    err.message =
      'unparsable content <' + match[1] + '> detected; ' +
      'this may indicate an invalid CMMN 1.1 diagram file' + match[2];
  }

  return err;
}

var DEFAULT_OPTIONS = {
  width: '100%',
  height: '100%',
  position: 'relative',
  container: 'body'
};


/**
 * Ensure the passed argument is a proper unit (defaulting to px)
 */
function ensureUnit(val) {
  return val + (isNumber(val) ? 'px' : '');
}

/**
 * A viewer for CMMN 1.1 diagrams.
 *
 * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include
 * additional features.
 *
 *
 * ## Extending the Viewer
 *
 * In order to extend the viewer pass extension modules to bootstrap via the
 * `additionalModules` option. An extension module is an object that exposes
 * named services.
 *
 * The following example depicts the integration of a simple
 * logging component that integrates with interaction events:
 *
 *
 * ```javascript
 *
 * // logging component
 * function InteractionLogger(eventBus) {
 *   eventBus.on('element.hover', function(event) {
 *     console.log()
 *   })
 * }
 *
 * InteractionLogger.$inject = [ 'eventBus' ]; // minification save
 *
 * // extension module
 * var extensionModule = {
 *   __init__: [ 'interactionLogger' ],
 *   interactionLogger: [ 'type', InteractionLogger ]
 * };
 *
 * // extend the viewer
 * var cmmnViewer = new Viewer({ additionalModules: [ extensionModule ] });
 * cmmnViewer.importXML(...);
 * ```
 *
 * @param {Object} [options] configuration options to pass to the viewer
 * @param {DOMElement} [options.container] the container to render the viewer in, defaults to body.
 * @param {String|Number} [options.width] the width of the viewer
 * @param {String|Number} [options.height] the height of the viewer
 * @param {Object} [options.moddleExtensions] extension packages to provide
 * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules
 * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules
 */
function Viewer(options) {

  options = assign({}, DEFAULT_OPTIONS, options);

  this.moddle = this._createModdle(options);

  this.container = this._createContainer(options);

  /* <project-logo> */

  addProjectLogo(this.container);

  /* </project-logo> */

  this._init(this.container, this.moddle, options);
}

inherits(Viewer, Diagram);

module.exports = Viewer;


/**
 * Parse and render a CMMN 1.1 diagram.
 *
 * Once finished the viewer reports back the result to the
 * provided callback function with (err, warnings).
 *
 * ## Life-Cycle Events
 *
 * During import the viewer will fire life-cycle events:
 *
 *   * import.parse.start (about to read model from xml)
 *   * import.parse.complete (model read; may have worked or not)
 *   * import.render.start (graphical import start)
 *   * import.render.complete (graphical import finished)
 *   * import.done (everything done)
 *
 * You can use these events to hook into the life-cycle.
 *
 * @param {String} xml the CMMN 1.1 xml
 * @param {Function} [done] invoked with (err, warnings=[])
 */
Viewer.prototype.importXML = function(xml, done) {

  // done is optional
  done = done || function() {};

  var self = this;

  // hook in pre-parse listeners +
  // allow xml manipulation
  xml = this._emit('import.parse.start', { xml: xml }) || xml;

  this.moddle.fromXML(xml, 'cmmn:Definitions', function(err, definitions, context) {

    // hook in post parse listeners +
    // allow definitions manipulation
    definitions = self._emit('import.parse.complete', {
      error: err,
      definitions: definitions,
      context: context
    }) || definitions;

    if (err) {
      err = checkValidationError(err);

      self._emit('import.done', { error: err });

      return done(err);
    }

    var parseWarnings = context.warnings;

    self.importDefinitions(definitions, function(err, importWarnings) {
      var allWarnings = [].concat(parseWarnings, importWarnings || []);

      self._emit('import.done', { error: err, warnings: allWarnings });

      done(err, allWarnings);
    });
  });
};

/**
 * Export the currently displayed CMMN 1.1 diagram as
 * a CMMN 1.1 XML document.
 *
 * @param {Object} [options] export options
 * @param {Boolean} [options.format=false] output formated XML
 * @param {Boolean} [options.preamble=true] output preamble
 *
 * @param {Function} done invoked with (err, xml)
 */
Viewer.prototype.saveXML = function(options, done) {

  if (!done) {
    done = options;
    options = {};
  }

  var definitions = this.definitions;

  if (!definitions) {
    return done(new Error('no definitions loaded'));
  }

  this.moddle.toXML(definitions, options, done);
};

Viewer.prototype.saveSVG = function(options, done) {

  if (!done) {
    done = options;
    options = {};
  }

  var canvas = this.get('canvas');

  var contentNode = canvas.getDefaultLayer(),
      defsNode = canvas._svg.select('defs');

  var contents = contentNode.innerSVG(),
      defs = (defsNode && defsNode.outerSVG()) || '';

  var bbox = contentNode.getBBox();

  var svg =
    '<?xml version="1.0" encoding="utf-8"?>\n' +
    '<!-- created with cmmn-js / http://bpmn.io -->\n' +
    '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n' +
    '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" ' +
         'width="' + bbox.width + '" height="' + bbox.height + '" ' +
         'viewBox="' + bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height + '" version="1.1">' +
      defs + contents +
    '</svg>';

  done(null, svg);
};

Viewer.prototype.importDefinitions = function(definitions, done) {

  // use try/catch to not swallow synchronous exceptions
  // that may be raised during model parsing
  try {

    if (this.definitions) {
      // clear existing rendered diagram
      this.clear();
    }

    // update definitions
    this.definitions = definitions;

    // perform graphical import
    Importer.importCmmnDiagram(this, definitions, done);
  } catch (e) {

    // handle synchronous errors
    done(e);
  }
};

Viewer.prototype.getModules = function() {
  return this._modules;
};

/**
 * Destroy the viewer instance and remove all its
 * remainders from the document tree.
 */
Viewer.prototype.destroy = function() {

  // diagram destroy
  Diagram.prototype.destroy.call(this);

  // dom detach
  domRemove(this.container);
};

/**
 * Register an event listener
 *
 * Remove a previously added listener via {@link #off(event, callback)}.
 *
 * @param {String} event
 * @param {Number} [priority]
 * @param {Function} callback
 * @param {Object} [that]
 */
Viewer.prototype.on = function(event, priority, callback, target) {
  return this.get('eventBus').on(event, priority, callback, target);
};

/**
 * De-register an event listener
 *
 * @param {String} event
 * @param {Function} callback
 */
Viewer.prototype.off = function(event, callback) {
  this.get('eventBus').off(event, callback);
};


Viewer.prototype._init = function(container, moddle, options) {

  var baseModules = options.modules || this.getModules(),
      additionalModules = options.additionalModules || [],
      staticModules = [
        {
          cmmnjs: [ 'value', this ],
          moddle: [ 'value', moddle ]
        }
      ];

  var diagramModules = [].concat(staticModules, baseModules, additionalModules);

  var diagramOptions = assign(omit(options, 'additionalModules'), {
    canvas: assign({}, options.canvas, { container: container }),
    modules: diagramModules
  });

  // invoke diagram constructor
  Diagram.call(this, diagramOptions);
};

/**
 * Emit an event on the underlying {@link EventBus}
 *
 * @param  {String} type
 * @param  {Object} event
 *
 * @return {Object} event processing result (if any)
 */
Viewer.prototype._emit = function(type, event) {
  return this.get('eventBus').fire(type, event);
};

Viewer.prototype._createContainer = function(options) {

  var parent = options.container,
      container;

  // support jquery element
  // unwrap it if passed
  if (parent.get) {
    parent = parent.get(0);
  }

  // support selector
  if (isString(parent)) {
    parent = domQuery(parent);
  }

  container = domify('<div class="cjs-container"></div>');

  assign(container.style, {
    width: ensureUnit(options.width),
    height: ensureUnit(options.height),
    position: options.position
  });

  parent.appendChild(container);

  return container;
};

Viewer.prototype._createModdle = function(options) {
  var moddleOptions = assign({}, this._moddleExtensions, options.moddleExtensions);

  return new CmmnModdle(moddleOptions);
};


// modules the viewer is composed of
Viewer.prototype._modules = [
  _dereq_(5),
  _dereq_(210),
  _dereq_(190)
];


/* <project-logo> */

var PoweredBy = _dereq_(75),
    domEvent = _dereq_(416);

/**
 * Adds the project logo to the diagram container as
 * required by the bpmn.io license.
 *
 * @see http://bpmn.io/license
 *
 * @param {Element} container
 */
function addProjectLogo(container) {
  var logoData = PoweredBy.BPMNIO_LOGO;

  var linkMarkup =
    '<a href="http://bpmn.io" ' +
       'target="_blank" ' +
       'class="cjs-powered-by" ' +
       'title="Powered by bpmn.io" ' +
       'style="position: absolute; bottom: 15px; right: 15px; z-index: 100">' +
        '<img src="data:image/png;base64,' + logoData + '">' +
    '</a>';

  var linkElement = domify(linkMarkup);

  container.appendChild(linkElement);

  domEvent.bind(linkElement, 'click', function(event) {
    PoweredBy.open();

    event.preventDefault();
  });
}

/* </project-logo> */

},{"100":100,"190":190,"210":210,"257":257,"392":392,"395":395,"398":398,"402":402,"415":415,"416":416,"418":418,"419":419,"5":5,"69":69,"75":75,"76":76}],4:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(74),
    getDefinition = ModelUtil.getDefinition,
    getSentry = ModelUtil.getSentry;

var isAny = _dereq_(45).isAny;

var forEach = _dereq_(271),
    isArray = _dereq_(389);


/**
 * @class
 *
 * A registry that keeps track of all items in the model.
 */
function ItemRegistry(elementRegistry, eventBus) {
  this._items = {};
  this._referencedBy = {};

  this._elementRegistry = elementRegistry;
  this._eventBus = eventBus;

  this._init();
}

ItemRegistry.$inject = [ 'elementRegistry', 'eventBus' ];

module.exports = ItemRegistry;


ItemRegistry.prototype._init = function(config) {

  var eventBus = this._eventBus;

  eventBus.on('diagram.destroy', 500, this._clear, this);
  eventBus.on('diagram.clear', 500, this._clear, this);
};

ItemRegistry.prototype._clear = function() {
  this._items = {};
  this._referencedBy = {};
};

/**
 * Register a given item.
 *
 * @param {ModdleElement} item
 */
ItemRegistry.prototype.add = function(item) {

  var items = this._items,
      id = item.id,
      definitions = this._referencedBy,
      definition = getReference(item),
      definitionId = definition && definition.id;

  items[id] = item;

  if (definition) {
    definitions[definitionId] = definitions[definitionId] || [];

    if (definitions[definitionId].indexOf(item) === -1) {
      definitions[definitionId].push(item);
    }

  }

};


/**
 * Removes an item from the registry.
 *
 * @param {ModdleElement} item
 */
ItemRegistry.prototype.remove = function(item) {

  var items = this._items,
      id = item.id,
      definitions = this._referencedBy,
      definition = getReference(item),
      definitionId = definition && definition.id;

  delete items[id];

  if (definition) {

    var referencingItems = definitions[definitionId] || [],
        idx = referencingItems.indexOf(item);

    if (idx !== -1) {
      referencingItems.splice(idx, 1);
    }

    if (!referencingItems.length) {
      delete definitions[definitionId];
    }

  }

};


/**
 * Update the registration with the new id.
 *
 * @param {ModdleElement} item
 * @param {String} newId
 */
ItemRegistry.prototype.updateId = function(element, newId) {

  var items,
      item;

  if (typeof element === 'string') {
    element = this.get(element);
  }

  if (isDefinition(element)) {
    items = this._referencedBy;
  }
  else {
    items = this._items;
  }

  if (element) {

    item = items[element.id];

    delete items[element.id];

    items[newId] = item;

  }

};


/**
 * Update the registration.
 *
 * @param {ModdleElement} item
 * @param {ModdleElement} newReference
 */
ItemRegistry.prototype.updateReference = function(item, newReference) {

  var definitions = this._referencedBy,
      oldDefinition = getReference(item),
      oldDefinitionId = oldDefinition && oldDefinition.id;

  if (oldDefinition) {

    var referencingItems = definitions[oldDefinitionId] || [],
        idx = referencingItems.indexOf(item);

    if (idx !== -1) {
      referencingItems.splice(idx, 1);
    }

    if (!referencingItems.length) {
      delete definitions[oldDefinitionId];
    }

  }

  if (newReference) {

    var newReferenceId = newReference.id;
    if (newReferenceId) {

      definitions[newReferenceId] = definitions[newReferenceId] || [];

      if (definitions[newReferenceId].indexOf(item) === -1) {
        definitions[newReferenceId].push(item);
      }

    }

  }

};


/**
 * Return the item for a given id.
 *
 * @param {String} id for selecting the item
 *
 * @return {ModdleElement}
 */
ItemRegistry.prototype.get = function(id) {
  return this._items[id];
};


/**
 * Return all items that match a given filter function.
 *
 * @param {Function} fn
 *
 * @return {Array<ModdleElement>}
 */
ItemRegistry.prototype.filter = function(fn) {

  var filtered = [];

  this.forEach(function(element, definition) {
    if (fn(element, definition)) {
      filtered.push(element);
    }
  });

  return filtered;

};


/**
 * Return all items.
 *
 * @return {Array<ModdleElement>}
 */
ItemRegistry.prototype.getAll = function() {
  return this.filter(function(e) { return e; });
};


/**
 * Iterate over all items.
 *
 * @param {Function} fn
 */
ItemRegistry.prototype.forEach = function(fn) {

  var items = this._items;

  forEach(items, function(item) {
    return fn(item, getReference(item));
  });

};


/**
 * Return for given definition all referenced items.
 *
 * @param {String|ModdleElement} filter
 */
ItemRegistry.prototype.getReferences = function(filter) {
  var id = filter.id || filter;
  return (this._referencedBy[id] || []).slice();
};


/**
 * Return for a given item id the shape element.
 *
 * @param {String|ModdleElement} filter
 */
ItemRegistry.prototype.getShape = function(filter) {
  var id = filter.id || filter;
  return this._elementRegistry && this._elementRegistry.get(id);
};


/**
 * Return for a given filter all shapes.
 *
 * @param {Array<String>|String|ModdleElement} filter
 */
ItemRegistry.prototype.getShapes = function(filter) {

  var shapes = [],
      self = this;

  function add(shape) {
    shape && shapes.push(shape);
  }

  if (isArray(filter)) {

    forEach(filter, function(f) {
      add(self.getShape(f));
    });

  }
  else if (isDefinition(filter)) {

    var referencedBy = self.getReferences(filter);
    forEach(referencedBy, function(reference) {
      add(self.getShape(reference));
    });

  }
  else {
    add(self.getShape(filter));
  }

  return shapes;

};


function getReference(item) {
  return getDefinition(item) || getSentry(item);
}

function isDefinition(item) {
  return isAny(item, [
    'cmmn:PlanItemDefinition',
    'cmmn:Sentry',
    'cmmn:CaseFileItemDefinition'
  ]);
}
},{"271":271,"389":389,"45":45,"74":74}],5:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(8),
    _dereq_(71)
  ],
  itemRegistry: [ 'type', _dereq_(4) ]
};
},{"4":4,"71":71,"8":8}],6:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257),
    isArray = _dereq_(389),
    isObject = _dereq_(393),
    assign = _dereq_(398);

var BaseRenderer = _dereq_(111),
    TextUtil = _dereq_(247),
    DiUtil = _dereq_(72),
    ModelUtil = _dereq_(74);

var isStandardEventVisible = DiUtil.isStandardEventVisible;
var isPlanningTableCollapsed = DiUtil.isPlanningTableCollapsed;
var isCollapsed = DiUtil.isCollapsed;

var isCasePlanModel = ModelUtil.isCasePlanModel;
var getBusinessObject = ModelUtil.getBusinessObject;
var getDefinition = ModelUtil.getDefinition;
var isRequired = ModelUtil.isRequired;
var isRepeatable = ModelUtil.isRepeatable;
var isManualActivation = ModelUtil.isManualActivation;
var isAutoComplete = ModelUtil.isAutoComplete;
var hasPlanningTable = ModelUtil.hasPlanningTable;
var getName = ModelUtil.getName;
var is = ModelUtil.is;
var getStandardEvent = ModelUtil.getStandardEvent;

var createLine = _dereq_(246).createLine;

function CmmnRenderer(eventBus, styles, pathMap) {

  BaseRenderer.call(this, eventBus);

  var TASK_BORDER_RADIUS = 10;
  var MILESTONE_BORDER_RADIUS = 24;
  var STAGE_EDGE_OFFSET = 20;

  var LABEL_STYLE = {
    fontFamily: 'Arial, sans-serif',
    fontSize: '12px'
  };

  var textUtil = new TextUtil({
    style: LABEL_STYLE,
    size: { width: 100 }
  });

  var markers = {};

  function addMarker(id, element) {
    markers[id] = element;
  }

  function marker(id) {
    return markers[id];
  }

  function initMarkers(svg) {

    function createMarker(id, options) {
      var attrs = assign({
        fill: 'black',
        strokeWidth: 1,
        strokeLinecap: 'round',
        strokeDasharray: 'none'
      }, options.attrs);

      var ref = options.ref || { x: 0, y: 0 };

      var scale = options.scale || 1;

      // fix for safari / chrome / firefox bug not correctly
      // resetting stroke dash array
      if (attrs.strokeDasharray === 'none') {
        attrs.strokeDasharray = [10000, 1];
      }

      var marker = options.element
                     .attr(attrs)
                     .marker(0, 0, 20, 20, ref.x, ref.y)
                     .attr({
                       markerWidth: 20 * scale,
                       markerHeight: 20 * scale
                     });

      return addMarker(id, marker);
    }

    createMarker('association-start', {
      element: svg.path('M 11 5 L 1 10 L 11 15'),
      attrs: {
        fill: 'none',
        stroke: 'black',
        strokeWidth: 1.5
      },
      ref: { x: 1, y: 10 },
      scale: 0.5
    });

    createMarker('association-end', {
      element: svg.path('M 1 5 L 11 10 L 1 15'),
      attrs: {
        fill: 'none',
        stroke: 'black',
        strokeWidth: 1.5
      },
      ref: { x: 12, y: 10 },
      scale: 0.5
    });

  }

  // draw shape //////////////////////////////////////////////////////////////

  function computeStyle(custom, traits, defaultStyles) {
    if (!isArray(traits)) {
      defaultStyles = traits;
      traits = [];
    }

    return styles.style(traits || [], assign(defaultStyles, custom || {}));
  }

  function drawCircle(p, width, height, offset, attrs) {

    if (isObject(offset)) {
      attrs = offset;
      offset = 0;
    }

    offset = offset || 0;

    attrs = computeStyle(attrs, {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'white'
    });

    var cx = width / 2,
        cy = height / 2;

    return p.circle(cx, cy, Math.round((width + height) / 4 - offset)).attr(attrs);
  }

  function drawRect(p, width, height, r, offset, attrs) {

    if (isObject(offset)) {
      attrs = offset;
      offset = 0;
    }

    offset = offset || 0;

    attrs = computeStyle(attrs, {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'white'
    });

    return p.rect(offset, offset, width - offset * 2, height - offset * 2, r).attr(attrs);
  }

  function drawDiamond(p, width, height, attrs) {

    var x_2 = width / 2;
    var y_2 = height / 2;

    var points = [x_2, 0, width, y_2, x_2, height, 0, y_2 ];

    attrs = computeStyle(attrs, {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'white'
    });

    return p.polygon(points).attr(attrs);
  }

  function drawPath(p, d, attrs) {

    attrs = computeStyle(attrs, [ 'no-fill' ], {
      strokeWidth: 2,
      stroke: 'black'
    });

    return p.path(d).attr(attrs);
  }

  function drawOctagon(p, width, height, offset, attrs) {
    offset = offset || 20;

    var x1 = offset;
    var y1 = height;

    var x2 = 0;
    var y2 = height - offset;

    var x3 = 0;
    var y3 = offset;

    var x4 = offset;
    var y4 = 0;

    var x5 = width - offset;
    var y5 = 0;

    var x6 = width;
    var y6 = offset;

    var x7 = width;
    var y7 = height - offset;

    var x8 = width - offset;
    var y8 = height;

    var points = [ x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6, x7, y7, x8, y8 ];

    attrs = attrs || {};
    attrs.fill = 'white';
    attrs.stroke = 'black';
    attrs.strokeWidth = 2;

    return drawPolygon(p, points, attrs);
  }

  function drawPolygon(p, points, attrs) {
    return p.polygon(points).attr(attrs);
  }

  // draw connection ////////////////////////////////////////////

  function drawLine(p, waypoints, attrs) {
    attrs = computeStyle(attrs, [ 'no-fill' ], {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'none'
    });

    return createLine(waypoints, attrs).appendTo(p);
  }

  function createPathFromConnection(connection) {
    var waypoints = connection.waypoints;

    var pathData = 'm  ' + waypoints[0].x + ',' + waypoints[0].y;
    for (var i = 1; i < waypoints.length; i++) {
      pathData += 'L' + waypoints[i].x + ',' + waypoints[i].y + ' ';
    }
    return pathData;
  }

  // render label //////////////////////////////////////////////

  function renderLabel(p, label, options) {
    return textUtil.createText(p, label || '', options).addClass('djs-label');
  }

  function renderEmbeddedLabel(p, element, align) {
    var name = getName(element);
    return renderLabel(p, name, { box: element, align: align, padding: 5 });
  }

  function renderExpandedStageLabel(p, element, align) {
    var name = getName(element);
    var textbox = renderLabel(p, name, { box: element, align: align, padding: 5 });

    // reset the position of the text box
    textbox.transform(
      'translate(' + STAGE_EDGE_OFFSET + ',' + 0 + ')'
    );

    return textbox;
  }

  function renderCasePlanModelLabel(p, element) {
    var bo = getBusinessObject(element);

    // default maximum textbox dimensions
    var height = 18;
    var width = (element.width / 2) - 60;

    var label = bo.name;

    // create text box
    var textBox = renderLabel(p, label, {
      box: { height: height, width: width },
      align: 'left-top'
    });

    var minWidth = 60,
        padding = 40,
        textBoxWidth = textBox.getBBox().width;

    // set polygon width based on actual textbox size
    var polygonWidth = textBoxWidth + padding;

    if (textBoxWidth < minWidth) {
      polygonWidth = minWidth + padding;
    }

    var polygonPoints = [ 10, 0, 20, -height, polygonWidth, -height, (polygonWidth + 10), 0 ];

    // The pointer-events attribute is needed to allow clicks on the polygon
    // which otherwise would be prevented by the parent node ('djs-visual').
    var polygon = drawPolygon(p, polygonPoints, {
      fill: 'white',
      stroke: 'black',
      strokeWidth: 2,
      fillOpacity: 0.95,
      'pointer-events': 'all'
    });

    // make sure the textbox is visually on top of the polygon
    textBox.before(polygon);

    // reset the position of the text box
    textBox.transform(
      'translate(' + 25 + ',' + (-height - 1)   + ')'
    );

    return textBox;
  }

  function renderExternalLabel(p, element, align) {
    var name = getName(element),
        hide = false;

    var standardEvent = getStandardEvent(element);

    if (standardEvent) {

      var standardEventVisible = isStandardEventVisible(element);
      standardEvent = '[' + standardEvent + ']';

      if (!name) {
        name = standardEvent;
        element.hidden = hide = !standardEventVisible;
      }
      else {
        if (standardEventVisible) {
          name = name + ' ' + standardEvent;
        }
      }

    }

    element.hidden = element.labelTarget.hidden || hide || !name;

    return renderLabel(p, name, { box: element, align: align, style: { fontSize: '11px' } });
  }

  // render elements //////////////////////////////////////////

  function renderer(type) {
    return handlers[type];
  }

  var handlers = {
    'cmmn:PlanItem': function(p, element) {
      var definition = getDefinition(element);
      return renderer(definition.$type)(p, element);
    },

    'cmmn:DiscretionaryItem': function(p, element) {
      var definition = getDefinition(element);

      var attrs = {
        strokeDasharray: '10, 12'
      };

      if (is(definition, 'cmmn:Task')) {
        assign(attrs, {
          strokeDasharray: '12, 12.4',
          strokeDashoffset: 13.6
        });
      }

      return renderer(definition.$type)(p, element, attrs);
    },

    // STAGE
    'cmmn:Stage': function(p, element, attrs) {

      attrs = assign({ fillOpacity: 0.95 }, attrs);

      var rect;
      if (isCasePlanModel(element)) {
        return handlers['cmmn:CasePlanModel'](p, element);
      }

      rect = drawOctagon(p, element.width, element.height, STAGE_EDGE_OFFSET, attrs);

      if (!isCollapsed(element)) {
        renderExpandedStageLabel(p, element, 'left-top');
      }
      else {
        renderEmbeddedLabel(p, element, 'center-middle');
      }

      attachPlanningTableMarker(p, element);
      attachStageMarkers(p, element);
      return rect;
    },

    // STAGE
    'cmmn:PlanFragment': function(p, element, attrs) {

      var rect = drawRect(p, element.width, element.height, TASK_BORDER_RADIUS, {
        strokeDasharray: '10, 12',
        fillOpacity: 0.95
      });

      renderEmbeddedLabel(p, element, isCollapsed(element) ? 'center-middle' : 'left-top');

      attachStageMarkers(p, element);
      return rect;
    },

    'cmmn:CasePlanModel': function(p, element) {
      var rect = drawRect(p, element.width, element.height, null, {
        fillOpacity: 0.95
      });
      renderCasePlanModelLabel(p, element);
      attachPlanningTableMarker(p, element);
      attachCasePlanModelMarkers(p, element);
      return rect;
    },

    // MILESTONE
    'cmmn:Milestone': function(p, element, attrs) {
      var rect = drawRect(p, element.width, element.height, MILESTONE_BORDER_RADIUS, attrs);
      renderEmbeddedLabel(p, element, 'center-middle');
      attachTaskMarkers(p, element);
      return rect;
    },

    // EVENT LISTENER
    'cmmn:EventListener': function(p, element, attrs) {
      var outerCircle = drawCircle(p, element.width, element.height,  attrs);

      attrs = attrs || {};
      attrs.strokeWidth = 2;

      drawCircle(p, element.width, element.height, 0.1 * element.height, attrs);
      return outerCircle;
    },

    'cmmn:TimerEventListener': function(p, element, attrs) {
      var circle = renderer('cmmn:EventListener')(p, element, attrs);

      var pathData = pathMap.getScaledPath('EVENT_TIMER_WH', {
        xScaleFactor: 0.75,
        yScaleFactor: 0.75,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: 0.5,
          my: 0.5
        }
      });

      drawPath(p, pathData, {
        strokeWidth: 2,
        strokeLinecap: 'square'
      });

      for (var i = 0;i < 12;i++) {

        var linePathData = pathMap.getScaledPath('EVENT_TIMER_LINE', {
          xScaleFactor: 0.75,
          yScaleFactor: 0.75,
          containerWidth: element.width,
          containerHeight: element.height,
          position: {
            mx: 0.5,
            my: 0.5
          }
        });

        var width = element.width / 2;
        var height = element.height / 2;

        drawPath(p, linePathData, {
          strokeWidth: 1,
          strokeLinecap: 'square',
          transform: 'rotate(' + (i * 30) + ',' + height + ',' + width + ')'
        });
      }


      return circle;
    },

    'cmmn:UserEventListener': function(p, element, attrs) {
      var circle = renderer('cmmn:EventListener')(p, element, attrs);

      // TODO: The user event decorator has to be
      // scaled correctly!
      var x = 20;
      var y = 15;

      var pathData = pathMap.getScaledPath('TASK_TYPE_USER_1', {
        abspos: {
          x: x,
          y: y
        }
      });

      /* user path */ drawPath(p, pathData, {
        strokeWidth: 0.5,
        fill: 'none'
      });

      var pathData2 = pathMap.getScaledPath('TASK_TYPE_USER_2', {
        abspos: {
          x: x,
          y: y
        }
      });

      /* user2 path */ drawPath(p, pathData2, {
        strokeWidth: 0.5,
        fill: 'none'
      });

      var pathData3 = pathMap.getScaledPath('TASK_TYPE_USER_3', {
        abspos: {
          x: x,
          y: y
        }
      });

      /* user3 path */ drawPath(p, pathData3, {
        strokeWidth: 0.5,
        fill: 'black'
      });

      return circle;
    },

    // TASK
    'cmmn:Task': function(p, element, attrs) {
      var rect = drawRect(p, element.width, element.height, TASK_BORDER_RADIUS, attrs);
      renderEmbeddedLabel(p, element, 'center-middle');
      attachTaskMarkers(p, element);
      return rect;
    },

    'cmmn:HumanTask': function(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var bo = element.businessObject;
      var definition = bo.definitionRef;

      if (definition.isBlocking) {
        var x = 15;
        var y = 12;

        var pathData1 = pathMap.getScaledPath('TASK_TYPE_USER_1', {
          abspos: {
            x: x,
            y: y
          }
        });

        /* user path */ drawPath(p, pathData1, {
          strokeWidth: 0.5,
          fill: 'none'
        });

        var pathData2 = pathMap.getScaledPath('TASK_TYPE_USER_2', {
          abspos: {
            x: x,
            y: y
          }
        });

        /* user2 path */ drawPath(p, pathData2, {
          strokeWidth: 0.5,
          fill: 'none'
        });

        var pathData3 = pathMap.getScaledPath('TASK_TYPE_USER_3', {
          abspos: {
            x: x,
            y: y
          }
        });

        /* user3 path */ drawPath(p, pathData3, {
          strokeWidth: 0.5,
          fill: 'black'
        });
      }

      else {
        var pathData = pathMap.getScaledPath('TASK_TYPE_MANUAL', {
          abspos: {
            x: 17,
            y: 15
          }
        });

        /* manual path */ drawPath(p, pathData, {
          strokeWidth: 1.25,
          fill: 'white',
          stroke: 'black'
        });
      }

      attachPlanningTableMarker(p, element);

      return task;
    },

    'cmmn:CaseTask': function(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var pathData = pathMap.getScaledPath('TASK_TYPE_FOLDER', {
        abspos: {
          x: 7,
          y: 7
        }
      });

      /* manual path */ drawPath(p, pathData, {
        strokeWidth: 1.25,
        fill: 'white',
        stroke: 'black'
      });

      return task;
    },

    'cmmn:ProcessTask': function(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var pathData = pathMap.getScaledPath('TASK_TYPE_CHEVRON', {
        abspos: {
          x: 5,
          y: 5
        }
      });

      /* manual path */ drawPath(p, pathData, {
        strokeWidth: 1.25,
        fill: 'white',
        stroke: 'black'
      });

      return task;
    },

    'cmmn:DecisionTask': function(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var headerPathData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_HEADER', {
        abspos: {
          x: 8,
          y: 8
        }
      });

      var businessHeaderPath = drawPath(p, headerPathData);
      businessHeaderPath.attr({
        strokeWidth: 1,
        fill: 'AAA'
      });

      var headerData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_MAIN', {
        abspos: {
          x: 8,
          y: 8
        }
      });

      var businessPath = drawPath(p, headerData);
      businessPath.attr({
        strokeWidth: 1
      });

      return task;
    },

    'cmmn:CaseFileItem': function(p, element, attrs) {
      var pathData = pathMap.getScaledPath('DATA_OBJECT_PATH', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: 0.474,
          my: 0.296
        }
      });

      return drawPath(p, pathData, { fill: 'white' });
    },

    // ARTIFACTS
    'cmmn:TextAnnotation': function(p, element) {
      var style = {
        'fill': 'none',
        'stroke': 'none'
      };
      var textElement = drawRect(p, element.width, element.height, 0, 0, style);
      var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: 0.0,
          my: 0.0
        }
      });
      drawPath(p, textPathData);

      var text = getBusinessObject(element).text || '';
      renderLabel(p, text, { box: element, align: 'left-middle', padding: 5 });

      return textElement;
    },

    'cmmn:Association': function(p, element, attrs) {

      var semantic = getBusinessObject(element);

      attrs = assign({
        strokeDasharray: '0.5, 5',
        strokeLinecap: 'round',
        strokeLinejoin: 'round'
      }, attrs || {});

      if (semantic.associationDirection === 'One' ||
          semantic.associationDirection === 'Both') {
        attrs.markerEnd = marker('association-end');
      }

      if (semantic.associationDirection === 'Both') {
        attrs.markerStart = marker('association-start');
      }

      return drawLine(p, element.waypoints, attrs);
    },

    // MARKERS
    'StageMarker': function(p, element) {
      var markerRect = drawRect(p, 14, 14, 0, {
        strokeWidth: 1,
        stroke: 'black'
      });

      markerRect.transform('translate(' + (element.width / 2 - 7) + ',' + (element.height - 17) + ')');

      var path = isCollapsed(element) ? 'MARKER_STAGE_COLLAPSED' : 'MARKER_STAGE_EXPANDED';

      var stagePath = pathMap.getScaledPath(path, {
        xScaleFactor: 1.5,
        yScaleFactor: 1.5,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: (element.width / 2 - 7) / element.width,
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, stagePath);
    },

    'RequiredMarker': function(p, element, position) {
      var path = pathMap.getScaledPath('MARKER_REQUIRED', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: ((element.width / 2 + position) / element.width),
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, path, { strokeWidth: 3 });
    },

    'AutoCompleteMarker': function(p, element, position) {
      var markerRect = drawRect(p, 11, 14, 0, {
        strokeWidth: 1,
        stroke: 'black',
        fill: 'black'
      });
      markerRect.transform('translate(' + (element.width / 2 + position + 2) + ',' + (element.height - 17) + ')');
    },

    'ManualActivationMarker': function(p, element, position) {
      var path = pathMap.getScaledPath('MARKER_MANUAL_ACTIVATION', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: ((element.width / 2 + position) / element.width),
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, path, { strokeWidth: 1 });
    },

    'RepetitionMarker': function(p, element, position) {
      var path = pathMap.getScaledPath('MARKER_REPEATABLE', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: ((element.width / 2 + position) / element.width),
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, path);
    },

    'PlanningTableMarker': function(p, element, position) {
      var planningTableRect = drawRect(p, 30, 24, 0, {
        strokeWidth: 1.5,
        stroke: 'black'
      });

      planningTableRect.transform('translate(' + (element.width / 2 - 15) + ',' + (- 17) + ')');

      var isCollapsed = isPlanningTableCollapsed(element);

      var marker = isCollapsed ? 'MARKER_PLANNING_TABLE_COLLAPSED' : 'MARKER_PLANNING_TABLE_EXPANDED';

      var stagePath = pathMap.getScaledPath(marker, {
        xScaleFactor: 1.5,
        yScaleFactor: 1.5,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: (element.width / 2 - 15) / element.width,
          my: (-17) / element.height
        }
      });

      drawPath(p, stagePath, {
        strokeWidth: 1.5
      });
    },

    'cmmn:OnPart': function(p, element) {
      var pathData = createPathFromConnection(element);

      var path = drawPath(p, pathData, {
        strokeDasharray: '10, 5, 2, 5, 2, 5',
        strokeWidth: 1.5
      });

      return path;
    },
    'cmmn:PlanItemOnPart': function(p, element) {
      return renderer('cmmn:OnPart')(p, element);
    },
    'cmmn:CaseFileItemOnPart': function(p, element) {
      return renderer('cmmn:OnPart')(p, element);
    },
    'cmmn:EntryCriterion': function(p, element) {
      return drawDiamond(p, element.width, element.height, {
        fill: 'white'
      });
    },
    'cmmn:ExitCriterion': function(p, element) {
      return drawDiamond(p, element.width, element.height, {
        fill: 'black'
      });
    },

    'cmmndi:CMMNEdge': function(p, element) {

      var bo = getBusinessObject(element);

      if (bo.cmmnElementRef) {
        return renderer(bo.cmmnElementRef.$type)(p, element);
      }

      var pathData = createPathFromConnection(element);

      var path = drawPath(p, pathData, {
        strokeDasharray: '3, 5',
        strokeWidth: 1
      });

      return path;
    },

    'label': function(p, element) {
      return renderExternalLabel(p, element, '');
    }
  };

  // attach markers /////////////////////////

  function attachTaskMarkers(p, element) {
    var obj = getBusinessObject(element);
    var padding = 6;

    var markers = [];

    if (isRequired(obj)) {
      markers.push({ marker: 'RequiredMarker', width: 1 });
    }

    if (isManualActivation(obj)) {
      markers.push({ marker: 'ManualActivationMarker', width: 14 });
    }

    if (isRepeatable(obj)) {
      markers.push({ marker: 'RepetitionMarker', width: 14 });
    }

    if (markers.length) {

      if (markers.length === 1) {
        // align marker in the middle of the element
        drawMarker(markers[0].marker, p, element, (markers[0].width / 2) * (-1));
      }

      else if (markers.length === 2) {
        /* align marker:
         *
         *      |             |
         *      +-------------+
         *             ^
         *             |
         *         +-+   +-+
         *         |0|   |1| <-- markers
         *         +-+   +-+
         * (leftMarker)  (rightMarker)
         */
        drawMarker(markers[0].marker, p, element, (markers[0].width * (-1)) - (padding /2));
        drawMarker(markers[1].marker, p, element, padding / 2);
      }

      else if (markers.length === 3) {
        /* align marker:
         *
         *      |             |
         *      +-------------+
         *             ^
         *             |
         *      +-+   +-+   +-+
         *      |0|   |1|   |2| <-- markers
         *      +-+   +-+   +-+
         */

        /* 1 */ drawMarker(markers[1].marker, p, element, markers[1].width / 2 * (-1));
        /* 0 */ drawMarker(markers[0].marker, p, element, (markers[1].width / 2 * (-1)) - padding - markers[0].width);
        /* 2 */ drawMarker(markers[2].marker, p, element, (markers[1].width / 2) + padding);
      }
    }
  }

  function attachCasePlanModelMarkers(p, element) {
    var obj = getBusinessObject(element);

    if (isAutoComplete(obj)) {
      drawMarker('AutoCompleteMarker', p, element, -7);
    }
  }

  function attachStageMarkers(p, element, stage) {
    var obj = getBusinessObject(element);
    var padding = 6;

    drawMarker('StageMarker', p, element, -7);

    var leftMarkers = [];

    if (isRequired(obj)) {
      leftMarkers.push({ marker: 'RequiredMarker', width: 1 });
    }

    if (isAutoComplete(obj)) {
      leftMarkers.push({ marker: 'AutoCompleteMarker', width: 14 });
    }

    if (leftMarkers.length) {

      if (leftMarkers.length === 1) {
        drawMarker(leftMarkers[0].marker, p, element, (leftMarkers[0].width * (-1) - 7 - padding));
      }

      else if (leftMarkers.length === 2) {
        drawMarker(
          leftMarkers[0].marker,
          p,
          element,
          ((leftMarkers[1].width * (-1)) - 7 - padding) - (leftMarkers[0].width * (-1)) - padding
        );

        drawMarker(leftMarkers[1].marker, p, element, (leftMarkers[1].width * (-1)) - 7 - padding);
      }

    }

    var rightMarkers = [];

    if (isManualActivation(obj)) {
      rightMarkers.push({ marker: 'ManualActivationMarker', width: 14 });
    }

    if (isRepeatable(obj)) {
      rightMarkers.push({ marker: 'RepetitionMarker', width: 14 });
    }

    if (rightMarkers.length) {

      if (rightMarkers.length === 1) {
        drawMarker(rightMarkers[0].marker, p, element, 7 + padding);
      }

      else if (rightMarkers.length === 2) {
        drawMarker(rightMarkers[0].marker, p, element, 7 + padding);
        drawMarker(rightMarkers[1].marker, p, element, 7 + padding + rightMarkers[0].width + padding);
      }

    }
  }

  function attachPlanningTableMarker(p, element) {
    if (hasPlanningTable(element)) {
      drawMarker('PlanningTableMarker', p, element);
    }
  }

  function drawMarker(marker, parent, element, position) {
    renderer(marker)(parent, element, position);
  }

  // draw shape and connection ////////////////////////////////////

  function drawShape(parent, element) {
    var h = handlers[element.type];

    /* jshint -W040 */
    if (!h) {
      return BaseRenderer.prototype.drawShape.apply(this, [ parent, element ]);
    } else {
      return h(parent, element);
    }
  }

  function drawConnection(parent, element) {
    var type = element.type;
    var h = handlers[type];

    /* jshint -W040 */
    if (!h) {
      return BaseRenderer.prototype.drawConnection.apply(this, [ parent, element ]);
    } else {
      return h(parent, element);
    }
  }

  this.canRender = function(element) {
    return is(element, 'cmmn:CMMNElement') || is(element, 'cmmndi:CMMNEdge');
  };

  this.drawShape = drawShape;
  this.drawConnection = drawConnection;

  // hook onto canvas init event to initialize
  // connection start/end markers on svg
  eventBus.on('canvas.init', function(event) {
    initMarkers(event.svg);
  });

}

inherits(CmmnRenderer, BaseRenderer);

CmmnRenderer.$inject = [ 'eventBus', 'styles', 'pathMap' ];

module.exports = CmmnRenderer;

},{"111":111,"246":246,"247":247,"257":257,"389":389,"393":393,"398":398,"72":72,"74":74}],7:[function(_dereq_,module,exports){
'use strict';

var Snap = _dereq_(248);

/**
 * Map containing SVG paths needed by CmmnRenderer.
 */

function PathMap() {

  var PATH_USER_TYPE_1 = 'm {mx},{my} c 0.909,-0.845 1.594,-2.049 1.594,-3.385 0,-2.554 -1.805,-4.62199999 ' +
                         '-4.357,-4.62199999 -2.55199998,0 -4.28799998,2.06799999 -4.28799998,4.62199999 0,1.348 ' +
                         '0.974,2.562 1.89599998,3.405 -0.52899998,0.187 -5.669,2.097 -5.794,4.7560005 v 6.718 ' +
                         'h 17 v -6.718 c 0,-2.2980005 -5.5279996,-4.5950005 -6.0509996,-4.7760005 z' +
                         'm -8,6 l 0,5.5 m 11,0 l 0,-5';

  var PATH_USER_TYPE_2 = 'm {mx},{my} m 2.162,1.009 c 0,2.4470005 -2.158,4.4310005 -4.821,4.4310005 ' +
                         '-2.66499998,0 -4.822,-1.981 -4.822,-4.4310005';

  var PATH_USER_TYPE_3 = 'm {mx},{my} m -6.9,-3.80 c 0,0 2.25099998,-2.358 4.27399998,-1.177 2.024,1.181 4.221,1.537 ' +
                         '4.124,0.965 -0.098,-0.57 -0.117,-3.79099999 -4.191,-4.13599999 -3.57499998,0.001 ' +
                         '-4.20799998,3.36699999 -4.20699998,4.34799999 z';

  /**
   * Contains a map of path elements
   *
   * <h1>Path definition</h1>
   * A parameterized path is defined like this:
   * <pre>
   * 'EVENT_TIMER_WH': {
   *   d: 'M {mx},{my} l {e.x0},-{e.y0} m -{e.x0},{e.y0} l {e.x1},{e.y1} ',
   *   height: 17.5,
   *   width:  17.5,
   *   heightElements: [2.5, 7.5],
   *   widthElements: [2.5, 7.5]
   * }
   * </pre>
   * <p>It's important to specify a correct <b>height and width</b> for the path as the scaling
   * is based on the ratio between the specified height and width in this object and the
   * height and width that is set as scale target (Note x,y coordinates will be scaled with
   * individual ratios).</p>
   * <p>The '<b>heightElements</b>' and '<b>widthElements</b>' array must contain the values that will be scaled.
   * The scaling is based on the computed ratios.
   * Coordinates on the y axis should be in the <b>heightElement</b>'s array, they will be scaled using
   * the computed ratio coefficient.
   * In the parameterized path the scaled values can be accessed through the 'e' object in {} brackets.
   *   <ul>
   *    <li>The values for the y axis can be accessed in the path string using {e.y0}, {e.y1}, ....</li>
   *    <li>The values for the x axis can be accessed in the path string using {e.x0}, {e.x1}, ....</li>
   *   </ul>
   *   The numbers x0, x1 respectively y0, y1, ... map to the corresponding array index.
   * </p>
   */
  this.pathMap = {

    // TASK DECORATOR

    'TASK_TYPE_FOLDER': {
      d: 'm {mx},{my} l18,0 l0,12 l-18,0 l0,-12 m 2,0 l3,-4 l5,0 l3,4'
    },
    'TASK_TYPE_CHEVRON': {
      d: 'm {mx},{my} l15,0 l6,6 l-6,6 l-15,0 l6,-6 l-6,-6'
    },
    'TASK_TYPE_USER_1': {
      d: PATH_USER_TYPE_1
    },
    'TASK_TYPE_USER_2': {
      d: PATH_USER_TYPE_2
    },
    'TASK_TYPE_USER_3': {
      d: PATH_USER_TYPE_3
    },
    'TASK_TYPE_MANUAL': {
      d: 'm {mx},{my} c 0.234,-0.01 5.604,0.008 8.029,0.004 0.808,0 1.271,-0.172 1.417,-0.752 0.227,-0.898 ' +
        '-0.334,-1.314 -1.338,-1.316 -2.467,-0.01 -7.886,-0.004 -8.108,-0.004 -0.014,-0.079 0.016,-0.533 0,-0.61 ' +
        '0.195,-0.042 8.507,0.006 9.616,0.002 0.877,-0.007 1.35,-0.438 1.353,-1.208 0.003,-0.768 -0.479,-1.09 ' +
        '-1.35,-1.091 -2.968,-0.002 -9.619,-0.013 -9.619,-0.013 v -0.591 c 0,0 5.052,-0.016 7.225,-0.016 ' +
        '0.888,-0.002 1.354,-0.416 1.351,-1.193 -0.006,-0.761 -0.492,-1.196 -1.361,-1.196 -3.473,-0.005 ' +
        '-10.86,-0.003 -11.0829995,-0.003 -0.022,-0.047 -0.045,-0.094 -0.069,-0.139 0.3939995,-0.319 ' +
        '2.0409995,-1.626 2.4149995,-2.017 0.469,-0.4870005 0.519,-1.1650005 0.162,-1.6040005 -0.414,-0.511 ' +
        '-0.973,-0.5 -1.48,-0.236 -1.4609995,0.764 -6.5999995,3.6430005 -7.7329995,4.2710005 -0.9,0.499 ' +
        '-1.516,1.253 -1.882,2.19 -0.37000002,0.95 -0.17,2.01 -0.166,2.979 0.004,0.718 -0.27300002,1.345 ' +
        '-0.055,2.063 0.629,2.087 2.425,3.312 4.859,3.318 4.6179995,0.014 9.2379995,-0.139 13.8569995,-0.158 ' +
        '0.755,-0.004 1.171,-0.301 1.182,-1.033 0.012,-0.754 -0.423,-0.969 -1.183,-0.973 -1.778,-0.01 ' +
        '-5.824,-0.004 -6.04,-0.004 10e-4,-0.084 0.003,-0.586 10e-4,-0.67 z'
    },

    'TASK_TYPE_BUSINESS_RULE_HEADER': {
      d: 'm {mx},{my} 0,4 20,0 0,-4 z'
    },
    'TASK_TYPE_BUSINESS_RULE_MAIN': {
      d: 'm {mx},{my} 0,12 20,0 0,-12 z' +
        'm 0,8 l 20,0 ' +
        'm -13,-4 l 0,8'
    },

    // EVENT LISTENER DECORATOR

    'EVENT_TIMER_WH': {
      d: 'M {mx},{my} l {e.x0},-{e.y0} m -{e.x0},{e.y0} l {e.x1},{e.y1} ',
      height: 36,
      width:  36,
      heightElements: [10, 2],
      widthElements: [3, 7]
    },
    'EVENT_TIMER_LINE': {
      d:  'M {mx},{my} ' +
          'm {e.x0},{e.y0} l -{e.x1},{e.y1} ',
      height: 36,
      width:  36,
      heightElements: [10, 3],
      widthElements: [0, 0]
    },

    'EVENT_USER_1': {
      d: PATH_USER_TYPE_1,
      height: 36,
      width:  36,
      heightElements: [],
      widthElements: []

    },
    'EVENT_USER_2': {
      d: PATH_USER_TYPE_2,
      height: 36,
      width:  36,
      heightElements: [],
      widthElements: []
    },
    'EVENT_USER_3': {
      d: PATH_USER_TYPE_3,
      height: 36,
      width:  36,
      heightElements: [],
      widthElements: []
    },

    // MARKERS

    'MARKER_STAGE_EXPANDED': {
      d: 'm{mx},{my} m 2,7 l 10,0',
      height: 10,
      width: 10,
      heightElements: [],
      widthElements: []
    },
    'MARKER_STAGE_COLLAPSED': {
      d: 'm{mx},{my} m 2,7 l 10,0 m -5,-5 l 0,10',
      height: 10,
      width: 10,
      heightElements: [],
      widthElements: []
    },
    'MARKER_REQUIRED': {
      d: 'm{mx},{my} l 0,9 m 0,2 l0,3',
      height: 14,
      width: 3,
      heightElements: [],
      widthElements: []
    },

    'MARKER_MANUAL_ACTIVATION': {
      d: 'm{mx}, {my} l 14,7 l -14,7 l 0,-14 z',
      height: 14,
      width: 14,
      heightElements: [],
      widthElements: []
    },

    'MARKER_REPEATABLE': {
      d: 'm{mx},{my} m 3,0 l 0,14 m 6,-14 l 0,14 m -10,-10 l 14,0 m -14,6 l 14,0',
      height: 14,
      width: 14,
      heightElements: [],
      widthElements: []
    },

    'MARKER_PLANNING_TABLE_EXPANDED': {
      d: 'm{mx},{my} m 0,12 l 30,0 m -20,-12 l 0, 24 m 10, -24 l 0, 24 m -10, -6 l 10,0',
      height: 24,
      width: 30,
      heightElements: [],
      widthElements: []
    },
    'MARKER_PLANNING_TABLE_COLLAPSED': {
      d: 'm{mx},{my} m 0,12 l 30,0 m -20,-12 l 0, 24 m 10, -24 l 0, 24 m -10, -6 l 10,0 m -5, -6 l 0,12',
      height: 10,
      width: 10,
      heightElements: [],
      widthElements: []
    },

    'DATA_OBJECT_PATH': {
      d:'m 0,0 {e.x1},0 {e.x0},{e.y0} 0,{e.y1} -{e.x2},0 0,-{e.y2} {e.x1},0 0,{e.y0} {e.x0},0',
      height: 61,
      width:  51,
      heightElements: [10, 50, 60],
      widthElements: [10, 40, 50, 60]
    },

    'TEXT_ANNOTATION': {
      d: 'm {mx}, {my} m 10,0 l -10,0 l 0,{e.y0} l 10,0',
      height: 30,
      width: 10,
      heightElements: [30],
      widthElements: [10]
    }
  };

  this.getRawPath = function getRawPath(pathId) {
    return this.pathMap[pathId].d;
  };

  /**
   * Scales the path to the given height and width.
   * <h1>Use case</h1>
   * <p>Use case is to scale the content of elements (event) based
   * on the element bounding box's size.
   * </p>
   * <h1>Why not transform</h1>
   * <p>Scaling a path with transform() will also scale the stroke and IE does not support
   * the option 'non-scaling-stroke' to prevent this.
   * Also there are use cases where only some parts of a path should be
   * scaled.</p>
   *
   * @param {String} pathId The ID of the path.
   * @param {Object} param <p>
   *   Example param object scales the path to 60% size of the container (data.width, data.height).
   *   <pre>
   *   {
   *     xScaleFactor: 0.6,
   *     yScaleFactor:0.6,
   *     containerWidth: data.width,
   *     containerHeight: data.height,
   *     position: {
   *       mx: 0.46,
   *       my: 0.2,
   *     }
   *   }
   *   </pre>
   *   <ul>
   *    <li>targetpathwidth = xScaleFactor * containerWidth</li>
   *    <li>targetpathheight = yScaleFactor * containerHeight</li>
   *    <li>Position is used to set the starting coordinate of the path. M is computed:
    *    <ul>
    *      <li>position.x * containerWidth</li>
    *      <li>position.y * containerHeight</li>
    *    </ul>
    *    Center of the container <pre> position: {
   *       mx: 0.5,
   *       my: 0.5,
   *     }</pre>
   *     Upper left corner of the container
   *     <pre> position: {
   *       mx: 0.0,
   *       my: 0.0,
   *     }</pre>
   *    </li>
   *   </ul>
   * </p>
   *
   */
  this.getScaledPath = function getScaledPath(pathId, param) {
    var rawPath = this.pathMap[pathId];

    // positioning
    // compute the start point of the path
    var mx, my;

    if (param.abspos) {
      mx = param.abspos.x;
      my = param.abspos.y;
    } else {
      mx = param.containerWidth * param.position.mx;
      my = param.containerHeight * param.position.my;
    }

    var coordinates = {}; //map for the scaled coordinates
    if (param.position) {

      // path
      var heightRatio = (param.containerHeight / rawPath.height) * param.yScaleFactor;
      var widthRatio = (param.containerWidth / rawPath.width) * param.xScaleFactor;


      //Apply height ratio
      for (var heightIndex = 0; heightIndex < rawPath.heightElements.length; heightIndex++) {
        coordinates['y' + heightIndex] = rawPath.heightElements[heightIndex] * heightRatio;
      }

      //Apply width ratio
      for (var widthIndex = 0; widthIndex < rawPath.widthElements.length; widthIndex++) {
        coordinates['x' + widthIndex] = rawPath.widthElements[widthIndex] * widthRatio;
      }
    }

    //Apply value to raw path
    var path = Snap.format(
      rawPath.d, {
        mx: mx,
        my: my,
        e: coordinates
      }
    );
    return path;
  };
}

module.exports = PathMap;

},{"248":248}],8:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'cmmnRenderer' ],
  cmmnRenderer: [ 'type', _dereq_(6) ],
  pathMap: [ 'type', _dereq_(7) ]
};
},{"6":6,"7":7}],9:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(74).is,
    getDefinition = _dereq_(74).getDefinition;

var inherits = _dereq_(257);

var forEach = _dereq_(271);

var AutoResizeProvider = _dereq_(118);

/**
 * This module provides a CMMN specific check if an element
 * can be resized.
 */
function CmmnAutoResizeProvider(eventBus) {
  AutoResizeProvider.call(this, eventBus);
}

inherits(CmmnAutoResizeProvider, AutoResizeProvider);

CmmnAutoResizeProvider.$inject = [ 'eventBus' ];

module.exports = CmmnAutoResizeProvider;

/**
 * Check if the given shape can be expanded
 *
 * @param  {Array<djs.model.Shape>} elements
 * @param  {djs.model.Shape} target
 *
 * @return {boolean}
 */
CmmnAutoResizeProvider.prototype.canResize = function(elements, target) {

  if (!is(target, 'cmmn:CMMNElement')) {
    return;
  }

  var criterionsOnly = true;

  forEach(elements, function(element) {
    if (!is(element, 'cmmn:Criterion')) {
      criterionsOnly = false;
      return;
    }
  });

  // prevent auto expand if the selected elements are exclusively criterions
  if (criterionsOnly) {
    return;
  }

  var definition = getDefinition(target);

  return is(definition, 'cmmn:PlanFragment');
};

},{"118":118,"257":257,"271":271,"74":74}],10:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'cmmnAutoResizeProvider' ],
  __depends__: [
    _dereq_(119)
  ],
  cmmnAutoResizeProvider: [ 'type', _dereq_(9) ]
};

},{"119":119,"9":9}],11:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    isArray = _dereq_(389);

var isAny = _dereq_(45).isAny;

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition;

/**
 * A provider for CMMN 1.1 elements context pad
 */
function ContextPadProvider(
  contextPad,
  connect,
  create,
  elementFactory,
  modeling,
  rules,
  popupMenu,
  canvas
) {

  contextPad.registerProvider(this);

  this._contextPad = contextPad;
  this._connect = connect;
  this._create = create;
  this._elementFactory = elementFactory;
  this._modeling = modeling;
  this._rules = rules;
  this._popupMenu = popupMenu;
  this._canvas = canvas;
}

ContextPadProvider.$inject = [
  'contextPad',
  'connect',
  'create',
  'elementFactory',
  'modeling',
  'rules',
  'popupMenu',
  'canvas'
];

module.exports = ContextPadProvider;


ContextPadProvider.prototype.getContextPadEntries = function(element) {

  var contextPad = this._contextPad,
      connect = this._connect,
      create = this._create,
      elementFactory = this._elementFactory,
      modeling = this._modeling,
      canvas = this._canvas,
      rules = this._rules,
      popupMenu = this._popupMenu;

  var actions = {};

  if (element.type === 'label') {
    return actions;
  }


  function removeElement(e) {
    modeling.removeElements([ element ]);
  }

  function getReplaceMenuPosition(element) {

    var Y_OFFSET = 5;

    var diagramContainer = canvas.getContainer(),
        pad = contextPad.getPad(element).html;

    var diagramRect = diagramContainer.getBoundingClientRect(),
        padRect = pad.getBoundingClientRect();

    var top = padRect.top - diagramRect.top;
    var left = padRect.left - diagramRect.left;

    var pos = {
      x: left,
      y: top + padRect.height + Y_OFFSET
    };

    return pos;
  }

  function startConnect(event, element, autoActivate) {
    connect.start(event, element, autoActivate);
  }


  function appendCriterionAction(className, title, options) {

    function appendListener(event, element) {
      var shape = elementFactory.createCriterionShape('cmmn:EntryCriterion');
      create.start(event, shape, element);
    }

    return appendAction('cmmn:EntryCriterion', className, title, options, appendListener);
  }

  function appendDiscretionaryItemAction(className, title, options) {

    function appendListener(event, element) {
      var shape = elementFactory.createDiscretionaryItemShape('cmmn:Task');
      create.start(event, shape, element);
    }

    return appendAction('cmmn:DiscretionaryItem', className, title, options, appendListener);
  }

  function appendAction(type, className, title, options, listener) {

    if (typeof title !== 'string') {
      options = title;
      title = 'Append ' + type.replace(/^cmmn\:/, '');
    }

    function appendListener(event, element) {
      var shape = elementFactory.createShape(assign({ type: type }, options));
      create.start(event, shape, element);
    }

    return {
      group: 'model',
      className: className,
      title: title,
      action: {
        dragstart: listener || appendListener,
        click: listener || appendListener
      }
    };
  }


  if (isAny(element, [ 'cmmn:PlanItem', 'cmmn:CaseFileItem' ])) {
    assign(actions, {
      'append.entryCriterion': appendCriterionAction('cmmn-icon-entry-criterion', 'Append Criterion')
    });
  }

  if (isBlockingHumanTask(element)) {
    assign(actions, {
      'append.discretionaryItem': appendDiscretionaryItemAction(
        'cmmn-icon-task-discretionary',
        'Append DiscretionaryItem'
      )
    });
  }


  var replaceMenu;
  if (popupMenu._providers['cmmn-replace']) {
    replaceMenu = popupMenu.create('cmmn-replace', element);
  }

  if (replaceMenu && !replaceMenu.isEmpty()) {

    // Replace menu entry
    assign(actions, {
      'replace': {
        group: 'edit',
        className: 'cmmn-icon-screw-wrench',
        title: 'Change type',
        action: {
          click: function(event, element) {
            replaceMenu.open(assign(getReplaceMenuPosition(element), {
              cursor: { x: event.x, y: event.y }
            }), element);
          }
        }
      }
    });
  }


  if (!isAny(element, [ 'cmmndi:CMMNEdge', 'cmmn:TextAnnotation' ]) ) {
    assign(actions, {
      'append.text-annotation': appendAction('cmmn:TextAnnotation', 'cmmn-icon-text-annotation')
    });
  }


  if (isAny(element, [
    'cmmn:PlanItem',
    'cmmn:DiscretionaryItem',
    'cmmn:CaseFileItem',
    'cmmn:Criterion'
  ]) ) {

    assign(actions, {

      'connect': {
        group: 'connect',
        className: 'cmmn-icon-connection',
        title: 'Connect using Discretionary/OnPart or Association',
        action: {
          click: startConnect,
          dragstart: startConnect
        }
      }
    });
  }


  // delete element entry, only show if allowed by rules
  var deleteAllowed = rules.allowed('elements.delete', { elements: [ element ] });

  if (isArray(deleteAllowed)) {
    // was the element returned as a deletion candidate?
    deleteAllowed = deleteAllowed[0] === element;
  }

  if (deleteAllowed) {
    assign(actions, {
      'delete': {
        group: 'edit',
        className: 'cmmn-icon-trash',
        title: 'Remove',
        action: {
          click: removeElement,
          dragstart: removeElement
        }
      }
    });
  }

  return actions;
};


function isBlockingHumanTask(element) {
  var definition = getDefinition(element);
  return is(definition, 'cmmn:HumanTask') && definition.isBlocking;
}
},{"389":389,"398":398,"45":45,"74":74}],12:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(133),
    _dereq_(135),
    _dereq_(139),
    _dereq_(210),
    _dereq_(54)
  ],
  __init__: [ 'contextPadProvider' ],
  contextPadProvider: [ 'type', _dereq_(11) ]
};
},{"11":11,"133":133,"135":135,"139":139,"210":210,"54":54}],13:[function(_dereq_,module,exports){
'use strict';

var isAny = _dereq_(45).isAny;

/**
 * Extention of GlobalConnect tool that implements CMMN specific rules about
 * connection start elements.
 */
function CmmnGlobalConnect(globalConnect) {
  globalConnect.registerProvider(this);
}

CmmnGlobalConnect.$inject = [ 'globalConnect' ];

module.exports = CmmnGlobalConnect;


/**
 * Checks if given element can be used for starting connection.
 *
 * @param  {Element} source
 * @return {Boolean}
 */
CmmnGlobalConnect.prototype.canStartConnect = function(source) {

  if (nonExistantOrLabel(source)) {
    return null;
  }

  var businessObject = source.businessObject;

  return isAny(businessObject, [
    'cmmn:CaseFileItem',
    'cmmn:Criterion',
    'cmmn:DiscretionaryItem',
    'cmmn:PlanItem'
  ]);
};


function nonExistantOrLabel(element) {
  return !element || isLabel(element);
}

function isLabel(element) {
  return element.labelTarget;
}



},{"45":45}],14:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(146)
  ],
  __init__: [ 'cmmnGlobalConnect' ],
  cmmnGlobalConnect: [ 'type', _dereq_(13) ]
};

},{"13":13,"146":146}],15:[function(_dereq_,module,exports){
'use strict';

function CmmnKeyBindings(
  canvas,
  directEditing,
  editorActions,
  elementRegistry,
  globalConnect,
  handTool,
  keyboard,
  lassoTool,
  selection,
  searchPad,
  spaceTool
) {

  var actions = {
    selectElements: function() {
      // select all elements except for the invisible
      // root element
      var rootElement = canvas.getRootElement();

      var elements = elementRegistry.filter(function(element) {
        return element != rootElement;
      });

      selection.select(elements);
    },
    spaceTool: function() {
      spaceTool.toggle();
    },
    lassoTool: function() {
      lassoTool.toggle();
    },
    handTool: function() {
      handTool.toggle();
    },
    globalConnectTool: function() {
      globalConnect.toggle();
    },
    directEditing: function() {
      var currentSelection = selection.get();

      if (currentSelection.length) {
        directEditing.activate(currentSelection[0]);
      }
    },
    find: function() {
      searchPad.toggle();
    }
  };

  editorActions.register(actions);

  keyboard.addListener(function(key, modifiers) {

    // ctrl + a -> select all elements
    if (key === 65 && keyboard.isCmd(modifiers)) {
      editorActions.trigger('selectElements');

      return true;
    }

    // ctrl + f -> search labels
    if (key === 70 && keyboard.isCmd(modifiers)) {
      editorActions.trigger('find');

      return true;
    }

    if (keyboard.hasModifier(modifiers)) {
      return;
    }

    // s -> activate space tool
    if (key === 83) {
      editorActions.trigger('spaceTool');

      return true;
    }

    // l -> activate lasso tool
    if (key === 76) {
      editorActions.trigger('lassoTool');

      return true;
    }

    // h -> activate hand tool
    if (key === 72) {
      editorActions.trigger('handTool');

      return true;
    }

    // c -> activate global connect tool
    if (key === 67) {
      editorActions.trigger('globalConnectTool');

      return true;
    }

    // e -> activate direct editing
    if (key === 69) {
      editorActions.trigger('directEditing');

      return true;
    }
  });
}

CmmnKeyBindings.$inject = [
  'canvas',
  'directEditing',
  'editorActions',
  'elementRegistry',
  'globalConnect',
  'handTool',
  'keyboard',
  'lassoTool',
  'selection',
  'searchPad',
  'spaceTool'
];

module.exports = CmmnKeyBindings;

},{}],16:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(148),
    _dereq_(152),
    _dereq_(156),
    _dereq_(217),
    _dereq_(90),
    _dereq_(14),
    _dereq_(63)
  ],
  __init__: [ 'cmmnKeyBindings' ],
  cmmnKeyBindings: [ 'type', _dereq_(15) ]
};

},{"14":14,"148":148,"15":15,"152":152,"156":156,"217":217,"63":63,"90":90}],17:[function(_dereq_,module,exports){
'use strict';

var UpdateLabelHandler = _dereq_(19);

var LabelUtil = _dereq_(18);

var isCasePlanModel = _dereq_(74).isCasePlanModel,
    is = _dereq_(74).is,
    getDefinition = _dereq_(74).getDefinition;


// default mininum bounds
var MIN_BOUNDS = {
  width: 150,
  height: 50
};

function LabelEditingProvider(eventBus, canvas, directEditing, commandStack) {

  directEditing.registerProvider(this);
  commandStack.registerHandler('element.updateLabel', UpdateLabelHandler);

  // listen to dblclick on non-root elements
  eventBus.on('element.dblclick', function(event) {
    directEditing.activate(event.element);
  });

  // complete on followup canvas operation
  eventBus.on([ 'element.mousedown', 'drag.init', 'canvas.viewbox.changed' ], function(event) {
    directEditing.complete();
  });

  // cancel on command stack changes
  eventBus.on([ 'commandStack.changed' ], function() {
    directEditing.cancel();
  });

  if ('ontouchstart' in document.documentElement) {
    // we deactivate automatic label editing on mobile devices
    // as it breaks the user interaction workflow

    // TODO(nre): we should temporarily focus the edited element here
    // and release the focused viewport after the direct edit operation is finished
  } else {
    eventBus.on('create.end', 500, function(e) {

      var element = e.shape,
          canExecute = e.context.canExecute;

      if (!canExecute) {
        return;
      }

      directEditing.activate(element);

    });
  }

  this._canvas = canvas;
  this._commandStack = commandStack;
}

LabelEditingProvider.$inject = [ 'eventBus', 'canvas', 'directEditing', 'commandStack' ];

module.exports = LabelEditingProvider;


LabelEditingProvider.prototype.activate = function(element) {

  var text = LabelUtil.getLabel(element);

  if (text === undefined) {
    return;
  }

  // don't activate for root element
  if (!element.parent) {
    return;
  }

  var definition = getDefinition(element);

  var bbox = this.getEditingBBox(element);

  // adjust bbox for case plan models
  if (isCasePlanModel(element)) {
    bbox.height = 50;
    bbox.width = 200;
    bbox.y -= 30;
  }

  // set smaller height for Stages and Plan Fragments
  if (is(definition, 'cmmn:PlanFragment')) {
    bbox.height = 50;
  }

  var minWidth = MIN_BOUNDS.width,
      minHeight = MIN_BOUNDS.height;

  // reduce min width for tasks
  if (is(definition, 'cmmn:Task')) {
    minWidth = 100;
  }

  // set min width
  if (bbox.width < minWidth) {
    bbox.x += bbox.width / 2 - minWidth / 2;
    bbox.width = minWidth;
  }

  // set min height
  if (bbox.height < minHeight) {
    bbox.height = minHeight;
  }

  return { bounds: bbox, text: text };
};


LabelEditingProvider.prototype.getEditingBBox = function(element, maxBounds) {

  var target = element.label || element;

  var bbox = this._canvas.getAbsoluteBBox(target);

  return bbox;
};


LabelEditingProvider.prototype.update = function(element, newLabel) {
  this._commandStack.execute('element.updateLabel', {
    element: element,
    newLabel: newLabel
  });
};

},{"18":18,"19":19,"74":74}],18:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(74).is;
var isAny = _dereq_(45).isAny;

var getBusinessObject = _dereq_(74).getBusinessObject;

function getLabelAttr(element) {
  if (is(element, 'cmmn:TextAnnotation')) {
    return 'text';
  }

  return 'name';
}

function getSemantic(element) {
  var bo = getBusinessObject(element);

  if (is(bo, 'cmmndi:CMMNEdge') && bo.cmmnElementRef) {
    bo = bo.cmmnElementRef;
  }

  return bo;
}

/**
 * Check if the given element is of a type which has a reference to a definition.
 * This could be either plan items or discretionary items or case file items.
 *
 * @param {djs.model.Base} element
 *
 * @return {Boolean}
 */
var isReferencing = function(element) {
  return isAny(element, [
    'cmmn:PlanItem',
    'cmmn:DiscretionaryItem',
    'cmmn:CaseFileItem'
  ]);
};

function hasEditableLabel(element) {
  return !isAny(element, [
    'cmmn:Association',
    'cmmn:Criterion',
    'cmmndi:CMMNEdge'
  ]);
}

var getLabel = function(element) {

  var semantic = getSemantic(element),
      attr = getLabelAttr(semantic);

  if (!hasEditableLabel(semantic)) {
    return;
  }

  // Get definition as semantic if
  // * the element has no name property set
  // * the element type has a reference to a definition
  if (!semantic[attr] && isReferencing(element)) {
    semantic = semantic.definitionRef;
  }

  return semantic[attr] || '';
};

module.exports.getLabel = getLabel;


var setLabel = function(element, text, isExternal, isExclusiveRef) {

  var semantic = getSemantic(element),
      attr = getLabelAttr(semantic);

  // Get definition as semantic if
  // * the element has no name property set
  // * the element type has a reference to a definition
  // * the element is the only reference to a defition
  if (!semantic[attr] && isReferencing(element) && isExclusiveRef) {
    semantic = semantic.definitionRef;
  }

  semantic[attr] = text;

  // show external label if not empty
  if (isExternal) {
    element.hidden = !text;
  }

  return element;
};

module.exports.setLabel = setLabel;

},{"45":45,"74":74}],19:[function(_dereq_,module,exports){
'use strict';

var LabelUtil = _dereq_(18);

var getDefinition = _dereq_(74).getDefinition;

/**
 * A handler that updates the text of a CMMN element.
 */
function UpdateLabelHandler(itemRegistry) {

  /**
   * Set the label and return the changed elements.
   *
   * Element parameter can be label itself or connection (i.e. sequence flow).
   *
   * @param {djs.model.Base} element
   * @param {String} text
   */
  function setText(element, text) {

    // external label if present
    var label = element.label || element;

    var labelTarget = element.labelTarget || element;

    LabelUtil.setLabel(label, text, labelTarget !== label, isExclusiveRef(element));

    return [ label, labelTarget ];
  }

  /**
   * Return a function which checks if the element is the only reference to a definition
   *
   * @param  {djs.model.Base} element
   *
   * @return {Function}
   */
  function isExclusiveRef(element) {
    var definition = getDefinition(element);
    return definition ? itemRegistry.getReferences(definition).length === 1 : true;
  }


  function execute(ctx) {
    ctx.oldLabel = LabelUtil.getLabel(ctx.element);
    return setText(ctx.element, ctx.newLabel);
  }

  function revert(ctx) {
    return setText(ctx.element, ctx.oldLabel);
  }

  // API

  this.execute = execute;
  this.revert = revert;
}


UpdateLabelHandler.$inject = [ 'itemRegistry' ];

module.exports = UpdateLabelHandler;

},{"18":18,"74":74}],20:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(104),
    _dereq_(129),
    _dereq_(90)
  ],
  __init__: [ 'labelEditingProvider' ],
  labelEditingProvider: [ 'type', _dereq_(17) ]
};

},{"104":104,"129":129,"17":17,"90":90}],21:[function(_dereq_,module,exports){
'use strict';

var map = _dereq_(273),
    assign = _dereq_(398),
    pick = _dereq_(404);

var isAny = _dereq_(45).isAny;

function CmmnFactory(moddle) {
  this._model = moddle;
}

CmmnFactory.$inject = [ 'moddle' ];


CmmnFactory.prototype._needsId = function(element) {
  return isAny(element, [
    'cmmn:CMMNElement',
    'cmmndi:CMMNShape',
    'cmmndi:CMMNEdge',
    'cmmndi:CMMNStyle',
    'cmmndi:CMMNDiagram'
  ]);
};

CmmnFactory.prototype._ensureId = function(element) {
  // generate semantic ids for elements
  var prefix = (element.$type || '').replace(/^[^:]*:/g, '') + '_';

  if (!element.id && this._needsId(element)) {
    element.id = this._model.ids.nextPrefixed(prefix, element);
  }
};


CmmnFactory.prototype.create = function(type, attrs) {
  var element = this._model.create(type, attrs || {});

  this._ensureId(element);

  return element;
};


CmmnFactory.prototype.createDiLabel = function() {
  return this.create('cmmndi:CMMNLabel');
};


CmmnFactory.prototype.createDiShape = function(semantic, bounds, attrs) {
  return this.create('cmmndi:CMMNShape', assign({
    cmmnElementRef: semantic,
    bounds: this.createDiBounds(bounds),
    label: this.createDiLabel()
  }, attrs));
};


CmmnFactory.prototype.createDiEdge = function(semantic, waypoints, attrs) {
  return this.create('cmmndi:CMMNEdge', assign({
    cmmnElementRef: semantic,
    label: this.createDiLabel()
  }, attrs));
};


CmmnFactory.prototype.createDiBounds = function(bounds) {
  return this.create('dc:Bounds', bounds);
};


CmmnFactory.prototype.createDiWaypoints = function(waypoints) {
  return map(waypoints, function(pos) {
    return this.createDiWaypoint(pos);
  }, this);
};


CmmnFactory.prototype.createDiWaypoint = function(point) {
  return this.create('dc:Point', pick(point, [ 'x', 'y' ]));
};


CmmnFactory.prototype.createItem = function(itemType, definitionType) {

  var definition = this.create(definitionType);

  return this.create(itemType, {
    definitionRef: definition
  });
};


CmmnFactory.prototype.createCriterion = function(criterionType, attrs) {

  attrs = attrs || {};

  if (!attrs.sentryRef) {
    attrs = assign({
      sentryRef: this.createSentry()
    }, attrs);
  }

  return this.create(criterionType, attrs);
};


CmmnFactory.prototype.createSentry = function(attrs) {
  return this.create('cmmn:Sentry', attrs);
};


CmmnFactory.prototype.createCasePlanModel = function() {

  var casePlanModel = this.create('cmmn:Stage');

  // overwrite generated id to 'CasePlanModel_...'
  this._model.ids.unclaim(casePlanModel.id);
  casePlanModel.id = this._model.ids.nextPrefixed('CasePlanModel_', casePlanModel);

  var _case = this.create('cmmn:Case', {
    casePlanModel: casePlanModel
  });

  casePlanModel.$parent = _case;

  return casePlanModel;

};


CmmnFactory.prototype.createCaseFileModel = function(_case) {

  var caseFileModel = this.create('cmmn:CaseFile');

  // overwrite generated id to 'CaseFileModel_...'
  this._model.ids.unclaim(caseFileModel.id);
  caseFileModel.id = this._model.ids.nextPrefixed('CaseFileModel_', caseFileModel);

  caseFileModel.$parent = _case;

  return caseFileModel;

};


CmmnFactory.prototype.createCaseFileItem = function(attrs) {

  attrs = attrs || {};

  if (!attrs.definitionRef) {

    attrs = assign({
      definitionRef: this.create('cmmn:CaseFileItemDefinition')
    }, attrs);

  }

  return this.create('cmmn:CaseFileItem', attrs);

};

module.exports = CmmnFactory;

},{"273":273,"398":398,"404":404,"45":45}],22:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var BaseLayouter = _dereq_(220),
    ManhattanLayout = _dereq_(223);

var getMid = _dereq_(222).getMid;


function CmmnLayouter() {}

inherits(CmmnLayouter, BaseLayouter);

module.exports = CmmnLayouter;


CmmnLayouter.prototype.layoutConnection = function(connection, hints) {

  hints = hints || {};

  var source = connection.source,
      target = connection.target,
      waypoints = connection.waypoints,
      start = hints.connectionStart,
      end = hints.connectionEnd;


  if (!start) {
    start = getConnectionDocking(waypoints && waypoints[0], source);
  }

  if (!end) {
    end = getConnectionDocking(waypoints && waypoints[waypoints.length - 1], target);
  }

  var updatedWaypoints =
    ManhattanLayout.repairConnection(
      source, target,
      start, end,
      waypoints,
      hints);

  return updatedWaypoints || [ start, end ];
};

function getConnectionDocking(point, shape) {
  return point ? (point.original || point) : getMid(shape);
}
},{"220":220,"222":222,"223":223,"257":257}],23:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

var Collections = _dereq_(232);

var getBusinessObject = _dereq_(74).getBusinessObject,
    is = _dereq_(74).is,
    isCasePlanModel = _dereq_(74).isCasePlanModel;

var getParent = _dereq_(45).getParent,
    isLabel = _dereq_(45).isLabel;

var isAny = _dereq_(45).isAny;

/**
 * A handler responsible for updating the underlying CMMN 1.1 XML + DI
 * once changes on the diagram happen
 */
function CmmnUpdater(eventBus, cmmnFactory, itemRegistry, connectionDocking) {

  CommandInterceptor.call(this, eventBus);

  this._cmmnFactory = cmmnFactory;
  this._itemRegistry = itemRegistry;

  var self = this;


  ////// connection cropping /////////////////////////

  // crop connection ends during create/update
  function cropConnection(e) {
    var context = e.context,
        connection;

    if (!context.cropped) {
      connection = context.connection;
      connection.waypoints = connectionDocking.getCroppedWaypoints(connection);
      context.cropped = true;
    }
  }

  this.executed([
    'connection.layout',
    'connection.create',
    'connection.reconnectEnd',
    'connection.reconnectStart'
  ], cropConnection);

  this.reverted([
    'connection.layout',
    'connection.create',
    'connection.reconnectEnd',
    'connection.reconnectStart'
  ], function(e) {
    delete e.context.cropped;
  });

  ////// CMMN + DI update /////////////////////////

  function updateParent(e) {
    var context = e.context;

    self.updateParent(context.shape || context.connection, context.oldParent);
  }

  function reverseUpdateParent(e) {

    var context = e.context;

    var element = context.shape || context.connection,
        // oldParent is the (old) new parent, because we are undoing
        oldParent = context.parent || context.newParent;

    self.updateParent(element, oldParent);
  }

  this.executed([
    'shape.create',
    'shape.move',
    'shape.delete',
    'connection.delete',
    'connection.create'
  ], ifCmmn(updateParent));
  this.reverted([
    'shape.create',
    'shape.move',
    'shape.delete',
    'connection.delete',
    'connection.create'
  ], ifCmmn(reverseUpdateParent));


  // update bounds
  function updateBounds(e) {
    var shape = e.context.shape;
    self.updateBounds(shape);
  }

  this.executed([
    'shape.create',
    'shape.move',
    'shape.resize'
  ], ifCmmn(updateBounds));
  this.reverted([
    'shape.create',
    'shape.move',
    'shape.resize'
  ], ifCmmn(updateBounds));

  // attach / detach connection
  function updateConnection(e) {
    self.updateConnection(e.context);
  }

  this.executed([
    'connection.create',
    'connection.move',
    'connection.delete',
    'connection.reconnectEnd',
    'connection.reconnectStart'
  ], ifCmmn(updateConnection));

  this.reverted([
    'connection.create',
    'connection.move',
    'connection.delete',
    'connection.reconnectEnd',
    'connection.reconnectStart'
  ], ifCmmn(updateConnection));


  // update waypoints
  function updateConnectionWaypoints(e) {
    self.updateConnectionWaypoints(e.context.connection);
  }

  this.executed([
    'connection.create',
    'connection.layout',
    'connection.move',
    'connection.reconnectStart',
    'connection.reconnectEnd',
    'connection.updateWaypoints'
  ], ifCmmn(updateConnectionWaypoints));

  this.reverted([
    'connection.create',
    'connection.layout',
    'connection.move',
    'connection.reconnectStart',
    'connection.reconnectEnd',
    'connection.updateWaypoints'
  ], ifCmmn(updateConnectionWaypoints));

  // update attachments
  function updateAttachment(e) {
    self.updateAttachment(e.context);
  }

  this.executed([ 'element.updateAttachment' ], ifCmmn(updateAttachment));
  this.reverted([ 'element.updateAttachment' ], ifCmmn(updateAttachment));


  // update item registry

  function addItem(e) {
    var context = e.context,
        shape = context.shape,
        bo = getBusinessObject(shape);

    itemRegistry.add(bo);
  }

  function removeItem(e) {

    var context = e.context,
        shape = context.shape;

    if (isLabel(shape)) {
      return;
    }

    var bo = getBusinessObject(shape);
    itemRegistry.remove(bo);
  }

  this.executed('shape.create', ifCmmn(addItem));
  this.reverted('shape.create', ifCmmn(removeItem));

  this.executed('shape.delete', ifCmmn(removeItem));
  this.reverted('shape.delete', ifCmmn(addItem));

}

inherits(CmmnUpdater, CommandInterceptor);

module.exports = CmmnUpdater;

CmmnUpdater.$inject = [ 'eventBus', 'cmmnFactory', 'itemRegistry', 'connectionDocking' ];


/////// implementation //////////////////////////////////


CmmnUpdater.prototype.updateAttachment = function(context) {
  var shape = context.shape,
      businessObject = getBusinessObject(shape),
      host = shape.host,
      businessObjectHost = host && getBusinessObject(host);

  this.updateSemanticParent(businessObject, businessObjectHost);
};


CmmnUpdater.prototype.updateParent = function(element, oldParent) {
  // do not update CMMN 1.1 label parent
  if (isLabel(element)) {
    return;
  }

  var businessObject = getBusinessObject(element),
      parentBusinessObject = getBusinessObject(element.parent),
      businessObjectDi = businessObject.di || businessObject,
      parentDi = parentBusinessObject && parentBusinessObject.di;

  if (isAssociation(businessObject)) {
    businessObject = businessObject.cmmnElementRef;
  }

  if (shouldUpdateSemanticParent(businessObject)) {
    this.updateSemanticParent(businessObject, parentBusinessObject);
  }

  if (is(parentBusinessObject, 'cmmndi:CMMNDiagram')) {
    parentDi = parentBusinessObject;
  }

  this.updateDiParent(businessObjectDi, parentDi);
};


/**
 * Update the semantic parent
 *
 * - add/remove the business object to/from the parent's containment(s)
 * - set/unset the $parent property of the business object
 *
 * @param  {ModdleElement} businessObject
 * @param  {ModdleElement} newParent
 */
CmmnUpdater.prototype.updateSemanticParent = function(businessObject, newParent) {

  var containment;

  if (businessObject.$parent === newParent) {
    return;
  }

  if (is(businessObject, 'cmmn:PlanItem')) {
    containment = 'planItems';

    if (newParent && !isCasePlanModel(newParent)) {
      newParent = newParent.definitionRef;
    }

  } else

  if (isCasePlanModel(businessObject)) {
    containment = 'cases';
    businessObject = businessObject.$parent;
    newParent = newParent && getDefinitions(newParent);
  } else

  if (is(businessObject, 'cmmn:EntryCriterion')) {

    if (isCasePlanModel(newParent)) {
      newParent = null;
    }

    containment = 'entryCriteria';
  } else

  if (is(businessObject, 'cmmn:ExitCriterion')) {
    containment = 'exitCriteria';
  } else

  if (is(businessObject, 'cmmn:Artifact')) {
    newParent = newParent && getDefinitions(newParent);
    containment = 'artifacts';
  }

  if (!containment) {
    throw new Error('no parent for ', businessObject, newParent);
  }

  var children;

  if (businessObject.$parent) {
    // remove from old parent
    children = businessObject.$parent.get(containment);
    Collections.remove(children, businessObject);
  }

  if (newParent) {
    // add to new parent
    children = newParent.get(containment);
    children.push(businessObject);
    businessObject.$parent = newParent;
  } else {
    businessObject.$parent = null;
  }

};


/**
 * Upate the parent of an DI element
 *
 * - Add/remove DI element to the root element's diagramElements conainment
 * - Set/unset the $parent property of the DI element
 *
 * @param  {ModdleElement} di
 * @param  {ModdleElement} parentDi
 */
CmmnUpdater.prototype.updateDiParent = function(di, parentDi) {
  if (parentDi && !is(parentDi, 'cmmndi:CMMNDiagram')) {
    parentDi = parentDi.$parent;
  }

  if (di.$parent === parentDi) {
    return;
  }

  var diagramElements = (parentDi || di.$parent).get('diagramElements');

  if (parentDi) {
    diagramElements.push(di);
    di.$parent = parentDi;
  }
  else {
    Collections.remove(diagramElements, di);
    di.$parent = null;
  }
};


CmmnUpdater.prototype.updateBounds = function(shape) {
  var di = shape.businessObject.di || shape.businessObject;

  var bounds = isLabel(shape) ? this._getLabel(di).bounds : di.bounds;

  assign(bounds, {
    x: shape.x,
    y: shape.y,
    width: shape.width,
    height: shape.height
  });
};


CmmnUpdater.prototype.updateConnectionWaypoints = function(connection) {
  var di = connection.businessObject;
  di.set('waypoint', this._cmmnFactory.createDiWaypoints(connection.waypoints));
};


CmmnUpdater.prototype.updateConnection = function(context) {

  var connection = context.connection,
      businessObject = getBusinessObject(connection),
      newSource = getBusinessObject(connection.source),
      newTarget = getBusinessObject(connection.target),
      cmmnElement = businessObject.cmmnElementRef,
      sourceElem,
      targetElem,
      sourceAttr,
      targetAttr;


  if (is(cmmnElement, 'cmmn:Association')) {
    sourceElem = cmmnElement;
    targetElem = cmmnElement;

    sourceAttr = 'sourceRef';
    targetAttr = 'targetRef';
  }
  else {
    targetElem = businessObject;
    targetAttr = 'targetCMMNElementRef';

    if (is(cmmnElement, 'cmmn:OnPart')) {

      sourceElem = cmmnElement;
      sourceAttr = 'sourceRef';

      var newExitCriterionRef;
      if (is(newSource, 'cmmn:ExitCriterion')) {
        newExitCriterionRef = newSource;
        newSource = getParent(newExitCriterionRef);
      }

      if (cmmnElement.exitCriterionRef !== newExitCriterionRef) {
        cmmnElement.exitCriterionRef = newExitCriterionRef;
      }

    }
    else {
      sourceElem = businessObject;
      sourceAttr = 'sourceCMMNElementRef';
    }

  }

  if (sourceAttr && sourceElem[sourceAttr] !== newSource) {
    sourceElem[sourceAttr] = newSource;
  }

  if (targetAttr && targetElem[targetAttr] !== newTarget) {
    targetElem[targetAttr] = newTarget;
  }

  this.updateConnectionWaypoints(connection);
};

/////// helpers /////////////////////////////////////////

CmmnUpdater.prototype._getLabel = function(di) {

  if (!di.label) {
    di.label = this._cmmnFactory.createDiLabel();
  }

  if (!di.label.bounds) {
    di.label.bounds = this._cmmnFactory.createDiBounds();
  }

  return di.label;
};


/**
 * Make sure the event listener is only called
 * if the touched element is a CMMN element.
 *
 * @param  {Function} fn
 * @return {Function} guarded function
 */
function ifCmmn(fn) {

  return function(event) {

    var context = event.context,
        element = context.shape || context.connection;

    if (is(element, 'cmmn:CMMNElement') || is(element, 'cmmndi:CMMNDiagramElement')) {
      fn(event);
    }
  };
}

/**
 * Returns the cmmn:Definitions element for a given element.
 */
function getDefinitions(element) {
  return getParent(element, 'cmmn:Definitions');
}

function shouldUpdateSemanticParent(element) {
  return !isAny(element, [
    'cmmn:CaseFileItem',
    'cmmn:Criterion',
    'cmmn:DiscretionaryItem',
    'cmmn:OnPart',
    'cmmndi:CMMNEdge'
  ]);
}

function isAssociation(connection) {
  connection = connection.businessObject || connection;
  return !!(connection.cmmnElementRef && is(connection.cmmnElementRef, 'cmmn:Association'));
}

},{"102":102,"232":232,"257":257,"398":398,"45":45,"74":74}],24:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    inherits = _dereq_(257);

var BaseElementFactory = _dereq_(106),
    LabelUtil = _dereq_(73);

var is = _dereq_(74).is,
    getDefinition = _dereq_(74).getDefinition,
    isCasePlanModel = _dereq_(74).isCasePlanModel;

var isCollapsed = _dereq_(72).isCollapsed;

/**
 * A cmmn-aware factory for diagram-js shapes
 */
function ElementFactory(cmmnFactory, moddle) {
  BaseElementFactory.call(this);

  this._cmmnFactory = cmmnFactory;
  this._moddle = moddle;
}

inherits(ElementFactory, BaseElementFactory);


ElementFactory.$inject = [ 'cmmnFactory', 'moddle' ];

module.exports = ElementFactory;

ElementFactory.prototype.baseCreate = BaseElementFactory.prototype.create;

ElementFactory.prototype.create = function(elementType, attrs) {
  // no special magic for labels,
  // we assume their businessObjects have already been created
  // and wired via attrs
  if (elementType === 'label') {
    return this.baseCreate(elementType, assign({ type: 'label' }, LabelUtil.DEFAULT_LABEL_SIZE, attrs));
  }

  if (elementType === 'root') {
    return this.baseCreate(elementType, attrs);
  }

  return this.createCmmnElement(elementType, attrs);
};


ElementFactory.prototype.createCmmnElement = function(elementType, attrs) {
  var size;

  attrs = attrs || {};

  var businessObject = attrs.businessObject;

  if (!businessObject) {
    if (!attrs.type) {
      throw new Error('no shape type specified');
    }

    var props = {};

    if (attrs.name) {
      assign(props, {
        name: attrs.name
      });
    }

    businessObject = this._cmmnFactory.create(attrs.type, props);
  }


  if (elementType === 'connection') {

    if (!is(businessObject, 'cmmndi:CMMNEdge')) {
      businessObject = this._cmmnFactory.createDiEdge(businessObject, [], {
        id: businessObject.id + '_di'
      });
    }

    if (!businessObject.label) {
      businessObject.label = this._cmmnFactory.createDiLabel();
    }

    attrs.type = 'cmmndi:CMMNEdge';
  }

  if (attrs.definitionType) {
    var definition = this._cmmnFactory.create(attrs.definitionType);
    businessObject.definitionRef = definition;
  }

  if (attrs.sentryRef) {
    businessObject.sentryRef = attrs.sentryRef;
  }

  if (elementType === 'shape' && !businessObject.di) {
    businessObject.di = this._cmmnFactory.createDiShape(businessObject, {}, {
      id: businessObject.id + '_di'
    });
  }

  if (attrs.isCollapsed) {
    businessObject.di.isCollapsed = attrs.isCollapsed;
  }

  if (attrs.isPlanningTableCollapsed) {
    businessObject.di.isPlanningTableCollapsed = attrs.isPlanningTableCollapsed;
  }

  if (attrs.isStandardEventVisible) {
    businessObject.isStandardEventVisible = attrs.isStandardEventVisible;
  }

  if (attrs.isBlocking !== undefined) {
    businessObject.definitionRef.isBlocking = attrs.isBlocking;
  }

  if (attrs.autoComplete) {
    businessObject.definitionRef.autoComplete = true;
  }

  size = this._getDefaultSize(businessObject);

  attrs = assign({
    businessObject: businessObject,
    id: businessObject.id
  }, size, attrs);

  return this.baseCreate(elementType, attrs);
};


ElementFactory.prototype._getDefaultSize = function(semantic) {

  var definition = getDefinition(semantic);

  // CasePlanModel (type of semantic is 'cmmn:Stage')
  if (isCasePlanModel(semantic)) {
    return { width: 400, height: 250 };
  }

  if (is(definition, 'cmmn:PlanFragment')) {
    if (isCollapsed(semantic)) {
      return { width: 100, height: 80 };
    }
    else {
      return { width: 350, height: 200 };
    }
  }

  if (is(definition, 'cmmn:Milestone')) {
    return { width: 100, height: 40 };
  }

  if (is(definition, 'cmmn:EventListener')) {
    return { width: 36, height: 36 };
  }

  if (is(semantic, 'cmmn:Criterion')) {
    return { width: 20, height: 28 };
  }

  if (is(semantic, 'cmmn:TextAnnotation')) {
    return { width: 100, height: 30 };
  }

  if (is(semantic, 'cmmn:CaseFileItem')) {
    return { width: 36, height: 50 };
  }

  return { width: 100, height: 80 };
};


ElementFactory.prototype.createPlanItemShape = function(type) {
  return this.createShape({
    type: 'cmmn:PlanItem',
    businessObject: this._cmmnFactory.createItem('cmmn:PlanItem', type)
  });
};


ElementFactory.prototype.createDiscretionaryItemShape = function(type) {
  return this.createShape({
    type: 'cmmn:DiscretionaryItem',
    businessObject: this._cmmnFactory.createItem('cmmn:DiscretionaryItem', type)
  });
};


ElementFactory.prototype.createCasePlanModelShape = function() {
  return this.createShape({
    type: 'cmmn:Stage',
    businessObject: this._cmmnFactory.createCasePlanModel()
  });
};


ElementFactory.prototype.createCriterionShape = function(type) {
  return this.createShape({
    type: type,
    businessObject: this._cmmnFactory.createCriterion(type)
  });
};


ElementFactory.prototype.createCaseFileItemShape = function() {
  return this.createShape({
    type: 'cmmn:CaseFileItem',
    businessObject: this._cmmnFactory.createCaseFileItem()
  });
};

},{"106":106,"257":257,"398":398,"72":72,"73":73,"74":74}],25:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var assign = _dereq_(398);

var BaseModeling = _dereq_(157);

var AppendShapeHandler = _dereq_(37);
var ReconnectConnectionHandler = _dereq_(39);
var ReplaceShapeHandler = _dereq_(40);

var UpdatePropertiesHandler = _dereq_(42);
var UpdateSemanticParentHandler = _dereq_(43);
var UpdateControlsHandler = _dereq_(41);

var IdClaimHandler = _dereq_(38);

/**
 * CMMN 1.1 modeling features activator
 *
 * @param {EventBus} eventBus
 * @param {ElementFactory} elementFactory
 * @param {CommandStack} commandStack
 */
function Modeling(eventBus, elementFactory, commandStack, cmmnRules, rules) {
  BaseModeling.call(this, eventBus, elementFactory, commandStack);

  this._cmmnRules = cmmnRules;
  this._rules = rules;
}

inherits(Modeling, BaseModeling);

Modeling.$inject = [ 'eventBus', 'elementFactory', 'commandStack', 'cmmnRules', 'rules' ];

module.exports = Modeling;


Modeling.prototype.getHandlers = function() {
  var handlers = BaseModeling.prototype.getHandlers.call(this);

  handlers['shape.append'] = AppendShapeHandler;
  handlers['shape.replace'] = ReplaceShapeHandler;
  handlers['connection.reconnectStart'] = ReconnectConnectionHandler;
  handlers['connection.reconnectEnd'] = ReconnectConnectionHandler;

  handlers['element.updateProperties'] = UpdatePropertiesHandler;
  handlers['element.updateSemanticParent'] = UpdateSemanticParentHandler;

  handlers['element.updateControls'] = UpdateControlsHandler;

  handlers['id.updateClaim'] = IdClaimHandler;

  return handlers;
};


Modeling.prototype.connect = function(source, target, attrs) {

  var rules = this._rules;

  if (!attrs) {
    attrs = rules.allowed('connection.create', {
      source: source,
      target: target
    }) || { type: 'cmmn:Association' };
  }

  if (attrs.reverse) {
    return this.createConnection(target, source, attrs, target.parent);
  }

  return this.createConnection(source, target, attrs, source.parent);
};


Modeling.prototype.createConnection = function(source, target, targetIndex, connection, parent) {

  // Overwrite existing createConnection() method to provide additional
  // information in the context. This must be done to enable the replacement
  // of the target element, if necessary.

  if (typeof targetIndex === 'object') {
    parent = connection;
    connection = targetIndex;
    targetIndex = undefined;
  }

  var context = {
    source: source,
    target: target,
    parent: parent,
    parentIndex: targetIndex,
    canExecute: connection
  };

  connection = this._create('connection', connection);

  assign(context, {
    connection: connection
  });

  this._commandStack.execute('connection.create', context);

  return context.connection;
};


Modeling.prototype.reconnectStart = function(connection, newSource, dockingOrPoints, hints) {
  var context = {
    connection: connection,
    newSource: newSource,
    dockingOrPoints: dockingOrPoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.reconnectStart', context);
};


Modeling.prototype.reconnectEnd = function(connection, newTarget, dockingOrPoints, hints) {
  var context = {
    connection: connection,
    newTarget: newTarget,
    dockingOrPoints: dockingOrPoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.reconnectEnd', context);
};


Modeling.prototype.updateProperties = function(element, properties, shape) {
  this._commandStack.execute('element.updateProperties', {
    element: element,
    properties: properties,
    shape: shape
  });
};


Modeling.prototype.updateSemanticParent = function(element, newParent, containment, shape) {
  this._commandStack.execute('element.updateSemanticParent', {
    element: element,
    newParent: newParent,
    containment: containment,
    shape: shape
  });
};


Modeling.prototype.updateControls = function(element, values) {
  this._commandStack.execute('element.updateControls', {
    element: element,
    values: values
  });
};


Modeling.prototype.claimId = function(id, moddleElement) {
  this._commandStack.execute('id.updateClaim', {
    id: id,
    element: moddleElement,
    claiming: true
  });
};


Modeling.prototype.unclaimId = function(id, moddleElement) {
  this._commandStack.execute('id.updateClaim', {
    id: id,
    element: moddleElement
  });
};

},{"157":157,"257":257,"37":37,"38":38,"39":39,"398":398,"40":40,"41":41,"42":42,"43":43}],26:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel;

/*
 * If a criterion is (re-)attached to a case plan model,
 * then the (visual) parent must be the case plan model itself,
 * and not the root element.
 */
function AttachCriterionBehavior(eventBus) {

  CommandInterceptor.call(this, eventBus);

  this.preExecute([ 'shape.create', 'elements.move' ], function(context) {

    var shape = context.shape,
        shapes = context.shapes,
        parent = context.parent || context.newParent,
        host = context.host || context.newHost;

    if (!parent) {
      return;
    }

    if (!host || !isCasePlanModel(host)) {
      return;
    }

    if (shapes && shapes.length > 1) {
      return;
    }

    shape = shape || shapes[0];

    if (!is(shape, 'cmmn:Criterion')) {
      return;
    }

    context.parent = context.parent && host;
    context.newParent = context.newParent && host;

  }, true);



}

AttachCriterionBehavior.$inject = [ 'eventBus' ];

inherits(AttachCriterionBehavior, CommandInterceptor);

module.exports = AttachCriterionBehavior;

},{"102":102,"257":257,"74":74}],27:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

var forEach = _dereq_(271);
var filter = _dereq_(269);
var reduce = _dereq_(274);

var ModelUtil = _dereq_(74),
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject,
    is = ModelUtil.is;

var ModelingUtil = _dereq_(45),
    getCase = ModelingUtil.getCase,
    getParent = ModelingUtil.getParent,
    isSameCase = ModelingUtil.isSameCase,
    isLabel = ModelingUtil.isLabel;


function CaseFileItemUpdater(
  eventBus,
  itemRegistry,
  cmmnFactory,
  modeling
) {

  this._cmmnFactory = cmmnFactory;
  this._modeling = modeling;

  CommandInterceptor.call(this, eventBus);

  var containment = 'caseFileItems';


  this.preExecuted('shape.create', function(context) {

    var shape = context.shape,
        parent = context.parent,
        parentBusinessObject = getBusinessObject(parent),
        definitions,
        caseFileItemDefinition,
        caseFileModel;


    if (!isCaseFileItem(shape)) {
      return;
    }

    caseFileItemDefinition = getDefinition(shape);

    if (caseFileItemDefinition) {
      definitions = getDefinitions(parentBusinessObject);
      modeling.updateSemanticParent(caseFileItemDefinition, definitions, 'caseFileItemDefinitions');
    }

    caseFileModel = createCaseFileModel(parent);

    modeling.updateSemanticParent(shape, caseFileModel, containment);

  }, true);




  this.preExecuted('elements.move', function(context) {

    var newParent = context.newParent,
        hints = context.hints,
        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,
        closure = context.closure || {},
        shapes = closure.allShapes,
        caseFileModel;


    if (!newParent || oldParent === newParent) {
      return;
    }


    shapes = filter(shapes, function(shape) {
      return isCaseFileItem(shape) && !isLabel(shape) && !isSameCase(shape.parent, newParent);
    });

    if (shapes && shapes.length) {

      caseFileModel = createCaseFileModel(newParent);

      shapes = toMap(shapes);

      forEach(shapes, function(shape) {

        var caseFileItem = getBusinessObject(shape),
            oldCaseFileModel = getParentCaseFile(caseFileItem),
            oldSemanticParent = getParent(caseFileItem);

        if (isCaseFileModel(oldSemanticParent)) {

          modeling.updateSemanticParent(shape, caseFileModel, containment);

        }
        else {

          var parentCaseFileItem = getParent(caseFileItem, 'cmmn:CaseFileItem');
          if (!shapes[parentCaseFileItem.id]) {
            modeling.updateSemanticParent(shape, caseFileModel, containment);
          }

        }

        var source = caseFileItem.sourceRef;
        if (source && !shapes[source.id]) {
          clearSourceRef(caseFileItem);
        }

        clearTargetRefs(caseFileItem, function(target) {
          return !shapes[target.id];
        });


        moveChildren(caseFileItem, oldCaseFileModel, function(child) {
          return !shapes[child.id];
        });

        clearCaseFileItemContainer(oldSemanticParent);

      });

    }

  }, true);


  this.postExecuted('shape.delete', function(context) {

    var shape = context.shape,
        bo = getBusinessObject(shape),
        caseFileItemDefinition;

    if (!isCaseFileItem(shape) || isLabel(shape)) {
      return;
    }

    var oldSemanticParent = getParent(bo),
        caseFileModel = getParentCaseFile(bo);

    modeling.updateSemanticParent(shape, null, containment);

    clearSourceRef(shape);
    clearTargetRefs(shape);
    moveChildren(bo, caseFileModel);

    clearCaseFileItemContainer(oldSemanticParent);

    if (isExlusiveRef(shape)) {
      caseFileItemDefinition = getDefinition(shape);
      modeling.updateSemanticParent(caseFileItemDefinition, null, 'caseFileItemDefinitions');
    }

  }, true);



  function createCaseFileModel(element) {
    var _case = getCase(element),
        caseFileModel = _case.caseFileModel;

    if (!caseFileModel) {
      caseFileModel = cmmnFactory.createCaseFileModel(_case);
      modeling.updateProperties(_case, { caseFileModel: caseFileModel });
    }

    return caseFileModel;
  }


  function clearCaseFileItemContainer(container) {
    var items = container && container.get(containment);

    if (items && !items.length) {

      var prop = 'caseFileModel',
          parent = container.$parent;

      if (!isCaseFileModel(container)) {
        prop = 'children';
      }

      var update = {};
      update[prop] = undefined;

      modeling.updateProperties(parent, update);
      modeling.updateSemanticParent(container);
    }

  }


  function clearSourceRef(target) {
    target = getBusinessObject(target);

    var source = target.sourceRef;

    if (source) {
      clearTargetRefs(source, function(elem) {
        return target === elem;
      });

      modeling.updateProperties(target, { sourceRef: undefined });
    }

  }


  function clearTargetRefs(source, canRemoveFilter) {
    source = getBusinessObject(source);

    var targets = source && source.get('targetRefs'),
        copy;

    if (targets && targets.length) {

      copy = targets.slice();

      forEach(targets, function(target) {

        var canRemove = !canRemoveFilter || canRemoveFilter(target);

        if (canRemove) {

          if (target.sourceRef === source) {
            modeling.updateProperties(target, { sourceRef: undefined });
          }

          var idx = copy.indexOf(target);
          if (idx !== -1) {
            copy.splice(idx, 1);
          }

        }

      });

      if (targets.length !== copy.length) {
        modeling.updateProperties(source, { targetRefs: copy });
      }

    }

  }


  function moveChildren(caseFileItem, newParent, canMoveFilter) {
    caseFileItem = getBusinessObject(caseFileItem);

    var childrenElement = caseFileItem.children,
        children = childrenElement && childrenElement.get(containment);

    if (children && children.length) {

      forEach(children, function(child) {

        var canMove = !canMoveFilter || canMoveFilter(child);

        if (canMove) {
          modeling.updateSemanticParent(child, newParent, containment);
        }

      });

      clearCaseFileItemContainer(childrenElement);

    }

  }


  function isExlusiveRef(element) {
    var definition = getDefinition(element);
    return definition && itemRegistry.getReferences(definition).length === 1;
  }

}

CaseFileItemUpdater.$inject = [
  'eventBus',
  'itemRegistry',
  'cmmnFactory',
  'modeling'
];

inherits(CaseFileItemUpdater, CommandInterceptor);

module.exports = CaseFileItemUpdater;


function getDefinitions(element) {
  return getParent(element, 'cmmn:Definitions');
}


function isCaseFileItem(element) {
  return is(element, 'cmmn:CaseFileItem');
}


function isCaseFileModel(element) {
  return is(element, 'cmmn:CaseFile');
}


function toMap(elements) {
  return reduce(elements, function(result, value) {
    result[value.id] = value;
    return result;
  }, {});
}


function getParentCaseFile(element) {
  return getParent(getBusinessObject(element), 'cmmn:CaseFile');
}
},{"102":102,"257":257,"269":269,"271":271,"274":274,"45":45,"74":74}],28:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    inherits = _dereq_(257);

var LabelUtil = _dereq_(73),
    ModelUtil = _dereq_(74),
    DiUtil = _dereq_(72),
    ModelingUtil = _dereq_(45);

var getBusinessObject = ModelUtil.getBusinessObject,
    getName = ModelUtil.getName;

var hasExternalLabel = LabelUtil.hasExternalLabel,
    getExternalLabelMid = LabelUtil.getExternalLabelMid;

var isStandardEventVisible = DiUtil.isStandardEventVisible;

var isAny = ModelingUtil.isAny;

var CommandInterceptor = _dereq_(102);


/**
 * A component that makes sure that external labels are added
 * together with respective elements and properly updated (DI wise)
 * during move.
 *
 * @param {EventBus} eventBus
 * @param {Modeling} modeling
 * @param {cmmnFactory} cmmnFactory
 */
function LabelBehavior(eventBus, modeling, cmmnFactory) {

  CommandInterceptor.call(this, eventBus);

  // create external labels on shape creation

  this.postExecuted([ 'shape.create', 'connection.create' ], 200, function(e) {
    var context = e.context;

    var element = context.shape || context.connection,
        businessObject = element.businessObject;

    var position;

    if (hasExternalLabel(businessObject)) {
      position = getExternalLabelMid(element);

      modeling.createLabel(element, position, {
        id: businessObject.id + '_label',
        hidden: !getName(element) && !isStandardEventVisible(businessObject),
        businessObject: businessObject
      });
    }
  });


  // update label position on waypoints change if still hidden
  this.postExecute([ 'connection.updateWaypoints' ], function(e) {
    var context = e.context,
        connection = context.connection,
        label = connection.label;

    if (!label) {
      return;
    }

    if (label.hidden) {
      var position = getExternalLabelMid(connection);

      var delta = {
        x: position.x - label.x - label.width / 2,
        y: position.y - label.y - label.height / 2
      };

      modeling.moveShape(label, delta);
    }
  });


  this.postExecute([ 'shape.replace' ], function(e) {
    var context = e.context,
        newShape = context.newShape,
        oldShape = context.oldShape;

    var businessObject = getBusinessObject(newShape);

    if (businessObject && hasExternalLabel(businessObject)) {
      newShape.label.x = oldShape.label.x;
      newShape.label.y = oldShape.label.y;
    }
  });


  // update di information on label creation
  this.executed([ 'label.create' ], function(e) {

    var element = e.context.shape,
        businessObject,
        di;

    // we want to trigger on real labels only
    if (!element.labelTarget) {
      return;
    }

    // we want to trigger on CMMN elements only
    if (!isAny(element.labelTarget || element, [ 'cmmn:CMMNElement', 'cmmndi:CMMNDiagramElement' ])) {
      return;
    }

    businessObject = element.businessObject,
    di = businessObject.di || businessObject;


    if (!di.label) {
      di.label = cmmnFactory.createDiLabel();
    }

    if (!di.label.bounds) {
      di.label.bounds = cmmnFactory.createDiBounds();
    }

    assign(di.label.bounds, {
      x: element.x,
      y: element.y,
      width: element.width,
      height: element.height
    });
  });

}

inherits(LabelBehavior, CommandInterceptor);

LabelBehavior.$inject = [ 'eventBus', 'modeling', 'cmmnFactory' ];

module.exports = LabelBehavior;

},{"102":102,"257":257,"398":398,"45":45,"72":72,"73":73,"74":74}],29:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var forEach = _dereq_(271),
    intersection = _dereq_(260),
    union = _dereq_(262),
    filter = _dereq_(269);

var CommandInterceptor = _dereq_(102);

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var ModelingUtil = _dereq_(45),
    getParents = ModelingUtil.getParents,
    getParent = ModelingUtil.getParent,
    getCase = ModelingUtil.getCase,
    isLabel = ModelingUtil.isLabel;

var PlanItemDefinitionUtil = _dereq_(46),
    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,
    getDirectItemCapables = PlanItemDefinitionUtil.getDirectItemCapables,
    isItemCapable = PlanItemDefinitionUtil.isItemCapable,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask;

var LOW_PRIORITY = 400;

/**
 * A handler responsible for updating the parent relation of a plan item definition
 * to the underlying CMMN 1.1 XML once changes on the diagram happen.
 */
function PlanItemDefinitionUpdater(
  eventBus,
  modeling,
  cmmnReplace,
  itemRegistry
) {

  this._modeling = modeling;
  this._cmmnReplace = cmmnReplace;
  this._itemRegistry = itemRegistry;

  var self = this;

  CommandInterceptor.call(this, eventBus);

  var containment = 'planItemDefinitions';


  // CREATION //////////////////////////////////////////////////////////

  this.postExecuted('shape.create', function(context) {

    var shape = context.shape;

    if (!isItemCapable(shape)) {
      return;
    }

    var item = getBusinessObject(shape),
        definition = getDefinition(item),
        parent = getParentStage(item);

    if (!getParent(definition)) {
      modeling.updateSemanticParent(definition, parent, containment);
    }

  }, true);


  this.postExecuted('shape.replace', function(context) {

    var newShape = context.newShape;

    if (!isItemCapable(newShape)) {
      return;
    }

    self.updatePlanItemDefinitions([ newShape ]);

  }, true);


  // DELETION //////////////////////////////////////////////////////////

  this.postExecuted('shape.delete', function(context) {

    var shape = context.shape,
        definition,
        update = {};

    if (!isItemCapable(shape) || isLabel(shape)) {
      return;
    }

    definition = getDefinition(shape);
    update[definition.id] = definition;
    self.deletePlanItemDefinitions(update);

  }, true);


  this.preExecuted('shape.delete', function(context) {

    var shape = context.shape,
        definition = getDefinition(shape);

    if (!isHumanTask(definition) || definition.$parent) {
      return;
    }

    // get remaining discretionary items
    context.discretionaryItems = context.discretionaryItems || getAllDiscretionaryItems(definition);

  }, true);


  this.postExecuted('shape.delete', LOW_PRIORITY, function(context) {

    var discretionaryItems = context.discretionaryItems,
        shapes = [];

    forEach(discretionaryItems, function(item) {
      var shapeItem = itemRegistry.getShape(item.id);

      if (shapeItem) {
        shapes.push(shapeItem);
      }

    });

    if (shapes && shapes.length) {
      self.updatePlanItemDefinitions(shapes);
    }

  }, true);


  // MOVING //////////////////////////////////////////////////////////////

  this.preExecuted('elements.move', function(context) {

    var allShapes = context.closure.allShapes,
        newParent = context.newParent,
        hints = context.hints,
        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,
        replacements = {},
        shapes, // array of moved item capables
        movedItemCapables = {}, // grouped by definition
        newTargetCase;

    if (!newParent || oldParent === newParent) {
      return;
    }

    newTargetCase = getCase(newParent);

    shapes = filter(allShapes, function(shape) {

      if (isItemCapable(shape) && !isLabel(shape) && getCase(shape) !== newTargetCase) {

        var definition = getDefinition(shape);
        movedItemCapables[definition.id] = movedItemCapables[definition.id] || [];
        movedItemCapables[definition.id].push(shape);

        return true;
      }

      return false;
    });


    forEach(shapes, function(shape) {

      var definition = getDefinition(shape),
          referencedBy,
          movedShapes,
          newDefinition;

      if (replacements[definition.id]) {
        newDefinition = replacements[definition.id];
      }

      else {

        referencedBy = itemRegistry.getReferences(definition.id);
        movedShapes = movedItemCapables[definition.id];

        if (referencedBy.length > movedShapes.length) {
          newDefinition = replacements[definition.id] = cmmnReplace.replacePlanItemDefinition(definition);
        }

      }

      if (newDefinition && newDefinition !== definition) {
        modeling.updateProperties(shape, {
          definitionRef: newDefinition
        });
      }

    });

    // remember replacement of definitions
    context.definitionReplacements = replacements;

  }, true);


  this.postExecuted('elements.move', LOW_PRIORITY, function(context) {

    var shapes = context.shapes,
        newParent = context.newParent,
        oldParent = (context.hints && context.hints.oldParent);

    if (!newParent || oldParent === newParent) {
      return;
    }

    shapes = filter(shapes, function(shape) {
      return isItemCapable(shape) && !isLabel(shape);
    });

    if (shapes && shapes.length) {
      self.updatePlanItemDefinitions(shapes);
    }

  }, true);


  // CONNECTIONS //////////////////////////////////////////////////////////////

  this.postExecuted([
    'connection.create',
    'connection.delete',
    'connection.reconnectEnd',
    'connection.reconnectStart'
  ], LOW_PRIORITY, function(context) {

    var connection = context.connection,
        source = context.newSource || context.source || connection.source,
        target = context.newTarget || context.target || connection.target,
        shapes = [];

    if (!isDiscretionaryConnection(connection, source, target)) {
      return;
    }

    if (connection.target) {
      shapes.push(connection.target);
    }

    if (!connection.target && context.target) {
      shapes.push(context.target);
    }

    if (context.oldTarget) {
      shapes.push(context.oldTarget);
    }

    if (shapes && shapes.length) {
      self.updatePlanItemDefinitions(shapes);
    }

  }, true);


  // API ////////////////////////////////////////////////////////

  /**
   * Deletes the given plan item definitions.
   *
   * A plan item definition is deleted when it is not
   * referenced by a plan item or a discretionary item.
   *
   * @param {Array<ModdleElement>} definitions to delete
   */
  this.deletePlanItemDefinitions = function(definitions) {
    var references;

    forEach(definitions, function(definition) {
      references = itemRegistry.getReferences(definition);
      if (!references.length) {
        modeling.updateSemanticParent(definition, null, containment);
      }
    });
  };



  /**
   * Rearrange the plan item definitions of the given shapes.
   *
   * @param {Array<djs.model.Base>} shapes
   */
  this.updatePlanItemDefinitions = function(shapes) {

    handleEachItemCapable(shapes, function(shape) {

      var item = getBusinessObject(shape),
          definition = getDefinition(item),
          references = itemRegistry.getReferences(definition),
          sharedParent = getSharedParent(references);

      if (!sharedParent) {
        sharedParent = getCasePlanModel(item);
      }

      if (sharedParent && sharedParent !== definition.$parent) {
        modeling.updateSemanticParent(definition, sharedParent, containment);
      }

      var itemCapables = getDirectItemCapables(definition),
          children = [];

      if (is(definition, 'cmmn:PlanFragment') && shape.children && shape.children.length) {
        forEach(shape.children, function(child) {
          var bo = getBusinessObject(child);
          if (isItemCapable(bo) && !isLabel(bo) && itemCapables.indexOf(bo) === -1) {
            children.push(bo);
          }
        });

      }

      return union(itemCapables, children);

    });

  };


  // UTILITIES ///////////////////////////////////////////////////////////////


  function handleEachItemCapable(elements, fn) {

    var handledElements = {};

    function handled(element) {
      handledElements[element.id] = element;
    }

    function isHandled(element) {
      return !!handledElements[element.id];
    }

    function eachElement(elements, isRoot) {
      forEach(elements, function(element) {

        if (!isHandled(element)) {
          handled(element);

          element = itemRegistry.getShape(element.id) || element;
          var children = fn(element);

          if (children && children.length) {
            eachElement(children);
          }
        }

        if (isRoot) {
          handledElements = {};
        }

      });
    }

    eachElement(elements, true);
  }

}

PlanItemDefinitionUpdater.$inject = [
  'eventBus',
  'modeling',
  'cmmnReplace',
  'itemRegistry'
];

inherits(PlanItemDefinitionUpdater, CommandInterceptor);

module.exports = PlanItemDefinitionUpdater;


/**
 * Utilities
 */

function getSharedParent(elements) {

  var sharedParent,
      first;

  if (elements.length) {

    first = elements.splice(0, 1)[0];

    if (!elements.length) {
      sharedParent = getParentStage(first);
    }
    else {
      var candidates = getParentStages(first);
      forEach(elements, function(e) {
        candidates = intersection(candidates, getParentStages(e));
      });

      sharedParent = candidates[0];
    }

  }

  return sharedParent;

}


function getParentStage(element) {
  element = getBusinessObject(element);
  return getParent(element, 'cmmn:Stage');
}


function getParentStages(element) {
  element = getBusinessObject(element);
  return getParents(element, 'cmmn:Stage');
}


function getCasePlanModel(element) {
  var _case = getParent(element, 'cmmn:Case');
  return _case && _case.casePlanModel;
}


function isDiscretionaryConnection(connection, source, target) {
  return !connection.businessObject.cmmnElementRef;
}
},{"102":102,"257":257,"260":260,"262":262,"269":269,"271":271,"45":45,"46":46,"74":74}],30:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

var any = _dereq_(267);
var forEach = _dereq_(271);

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var getParent = _dereq_(45).getParent,
    isLabel = _dereq_(45).isLabel,
    getParents = _dereq_(45).getParents;

var PlanItemDefinitionUtil = _dereq_(46),
    isDiscretionaryToHumanTask = PlanItemDefinitionUtil.isDiscretionaryToHumanTask,
    isDiscretionaryItem = PlanItemDefinitionUtil.isDiscretionaryItem,
    isPlanFragment = PlanItemDefinitionUtil.isPlanFragment,
    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask;


/**
 * A handler responsible for adding, moving and deleting discretionary items
 * and adding them to planning table. These changes are reflected to
 * the underlying CMMN 1.1 XML.
 */
function PlanningTableUpdater(eventBus, cmmnFactory, modeling, itemRegistry) {

  this._cmmnFactory = cmmnFactory;
  this._modeling = modeling;
  this._itemRegistry = itemRegistry;

  var self = this;

  CommandInterceptor.call(this, eventBus);

  var containment = 'tableItems';

  // CONNECTION /////////////////////////////////////////////


  // delete + reconnectEnd //////////////////////////////////


  this.preExecuted([ 'connection.delete', 'connection.reconnectEnd', 'connection.reconnectStart' ], function(event) {

    var context = event.context,
        isReconnectStart = (event.command === 'connection.reconnectStart'),
        connection = context.connection,
        target = connection.target;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    if (isReconnectStart) {

      if (context.newSource && context.newTarget) {
        target = context.newSource;
        context.oldPlanningTable = getParentPlanningTable(target);
      }
      else {
        return;
      }

    }

    // (1) remember current 
    context.planningTable = getParentPlanningTable(target);

    // (2) if the target did not change, then do nothing (in case of reconnectEnd)
    if (target === context.newTarget) {
      return;
    }

    // (3) is there at least another discretionary connection referencing
    // this target.
    // note: there could be multiple plan items (with the same definition -
    // human task) referencing the same discretionary item. in such case
    // the deletion/reconnection of a discretionary connection does not trigger
    // the deletion of the other discretionary connections. As a result, the
    // the discretionary item remains in its current planning table.
    if (isReferencedByAnotherDiscretionaryConnection(target, connection)) {
      return;
    }

    // (4) get new target definition of discretionary item
    var definition = getTargetDefinition(target.parent);

    // (5) create a planning table if necessary
    var planningTable = self.createPlanningTable(definition);

    // (6) move (current target) discretionary item from current planning table
    // to the new planning table
    modeling.updateSemanticParent(target, planningTable, containment);

  });


  this.postExecuted('connection.delete', function(context) {

    if (!isDiscretionaryConnection(context.connection)) {
      return;
    }

    // triggers deletion of planning table if it is empty
    self.deletePlanningTable(context.planningTable);

  }, true);


  this.postExecuted('connection.reconnectEnd', function(context) {

    var connection = context.connection,
        target = connection.target;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    // (1) remember old planning table of new target
    var oldPlanningTable = getParentPlanningTable(target);

    // (2) add new target as discretionary item into the planning table of the source element
    modeling.updateSemanticParent(target, context.planningTable, containment);

    // (3) remove old planning table if its empty
    self.deletePlanningTable(oldPlanningTable);

  }, true);


  this.postExecuted('connection.reconnectStart', function(context) {

    var connection = context.connection;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    if (!context.newSource || !context.newTarget) {
      return;
    }

    self.deletePlanningTable(context.oldPlanningTable);

  }, true);

  // create + reconnectStart ////////////////////////////////////////

  this.preExecuted([ 'connection.create', 'connection.reconnectStart' ], function(context) {

    var connection = context.connection,
        source = context.newSource || context.source,
        target = context.target || context.newTarget || connection.target;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    // (1) remember planning table of target discretionary item
    context.planningTable = getParentPlanningTable(target);

    var definition = getDefinition(source);

    if (connection.source) {
      var oldDefinition = getDefinition(connection.source);
      if (oldDefinition === definition) {
        return;
      }
    }

    // (2) create a planning table if necessary
    var planningTable = self.createPlanningTable(definition);

    // (3) add target discretionary item to planning table
    modeling.updateSemanticParent(target, planningTable, containment);

  }, true);


  this.postExecuted([ 'connection.create', 'connection.reconnectStart' ], function(context) {

    var connection = context.connection;
    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    // remove planning table if its empty
    self.deletePlanningTable(context.planningTable);

  }, true);


  // SHAPE /////////////////////////////////////////////////////////////////////////////

  this.preExecuted('elements.move', 500, function(context) {

    var allShapes = context.closure.allShapes,
        newParent = context.newParent,
        hints = context.hints,
        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,
        replacements = context.definitionReplacements,
        replacedPlanningTableArray = [],
        planningTableReplacedBy = {};


    function clonePlanningTable(planningTable) {
      var newPlanningTable = cmmnFactory.create('cmmn:PlanningTable', {
        applicabilityRules: planningTable.applicabilityRules
      });
      var idx = replacedPlanningTableArray.push(planningTable);
      planningTableReplacedBy[idx-1] = newPlanningTable;

      return newPlanningTable;
    }


    if (!newParent || oldParent === newParent) {
      return;
    }


    forEach(allShapes, function(shape) {

      var bo = getBusinessObject(shape),
          newPlanningTables = [],
          discretionaryTo,
          replacedBy,
          items,
          planningTables,
          previousPlanningTable;


      if (!isDiscretionaryItem(shape) || isLabel(shape)) {
        return;
      }

      discretionaryTo = getParent(bo, 'cmmn:PlanItemDefinition');
      if (!is(discretionaryTo, 'cmmn:HumanTask')) {
        return;
      }

      replacedBy = replacements[discretionaryTo.id];
      if (!replacedBy) {
        return;
      }

      // discretionary item is already contained by replacement
      if ((getAllDiscretionaryItems(replacedBy) || []).indexOf(bo) !== -1) {
        return;
      }

      // have been all contained discretionary items moved?
      items = getAllDiscretionaryItems(discretionaryTo);
      var allMoved = !any(items, function(item) {
        return !allShapes[item.id];
      });


      if (allMoved) {

        // if yes, then just move planning table to replacement

        var planningTable = discretionaryTo.planningTable;

        modeling.updateProperties(replacedBy, {
          planningTable: planningTable
        }, itemRegistry.getShapes(replacedBy));

        modeling.updateSemanticParent(planningTable, replacedBy);

        modeling.updateProperties(discretionaryTo, {
          planningTable: undefined
        }, itemRegistry.getShapes(discretionaryTo));

        return;
      }


      planningTables = getParents(bo, 'cmmn:PlanningTable');

      if (planningTables && planningTables.length) {

        forEach(planningTables, function(planningTable) {

          var idx = replacedPlanningTableArray.indexOf(planningTable),
              newPlanningTable;

          if (idx === -1) {
            newPlanningTable = clonePlanningTable(planningTable);
          }
          else {
            newPlanningTable = planningTableReplacedBy[idx];
          }

          if (previousPlanningTable && !previousPlanningTable.$parent) {
            modeling.updateSemanticParent(previousPlanningTable, newPlanningTable, 'tableItems');
          }

          previousPlanningTable = newPlanningTable;
          newPlanningTables.push(newPlanningTable);

        });

        if (!replacedBy.planningTable) {

          modeling.updateProperties(replacedBy, {
            planningTable: previousPlanningTable
          }, itemRegistry.getShapes(replacedBy));
          modeling.updateSemanticParent(previousPlanningTable, replacedBy);

        }

        var first = newPlanningTables.splice(0, 1)[0],
            oldPlanningTable = getParentPlanningTable(bo);

        modeling.updateSemanticParent(bo, first, 'tableItems');

        self.deletePlanningTable(oldPlanningTable);
      }

    });

  }, true);


  this.preExecuted([ 'shape.create', 'shape.move' ], function(context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    // (1) if is discretionary to human task, then there is nothing to do
    // in case of 'shape.move'
    if (isDiscretionaryToHumanTask(shape)) {
      return;
    }

    // remember old planning table
    context.planningTable = getParentPlanningTable(shape);

    var newParent = context.parent || context.newParent;

    if (newParent) {

      // (2) parent changed

      var definition = getTargetDefinition(newParent);

      // (3) create new planning table if necessary
      var planningTable = self.createPlanningTable(definition);

      // (4) add discretionary item to planning table
      modeling.updateSemanticParent(shape, planningTable, containment);
    }

  }, true);


  this.postExecuted('shape.move', function(context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    // if an item which is discretionary to a human task is moved,
    // then no update is necessary
    if (isDiscretionaryToHumanTask(shape)) {
      return;
    }

    self.deletePlanningTable(context.planningTable);

  }, true);


  this.preExecuted('shape.delete', function(context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    // remember old planning table
    context.planningTable = getParentPlanningTable(shape);

    // remove discretionary item from planning table
    modeling.updateSemanticParent(shape, null, containment);

  }, true);


  this.postExecuted('shape.delete', function(context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    self.deletePlanningTable(context.planningTable);

  }, true);


  this.postExecuted('shape.delete', 500, function(context) {

    var shape = context.shape;

    var definition = getDefinition(shape);

    if (!isHumanTask(definition) || definition.$parent) {
      return;
    }

    var discretionaryItems = getAllDiscretionaryItems(definition);

    // repair the model
    forEach(discretionaryItems, function(item) {
      var shapeItem = itemRegistry.getShape(item.id);

      if (shapeItem) {
        // get new target definition of discretionary item
        var definition = getTargetDefinition(shapeItem.parent);

        // create a planning table if necessary
        var planningTable = self.createPlanningTable(definition);

        // move (current target) discretionary item from current planning table
        // to the new planning table
        modeling.updateSemanticParent(shapeItem, planningTable, containment);
      }

    });

    if (definition.planningTable) {
      self.deletePlanningTable(definition.planningTable);
    }

  }, true);

  // API ////////////////////////////////////////////////////////

  /**
   * Creates a new planning table for the given definition, if necessary.
   *
   * If the given definition already contains a planning table, this
   * planning table is returned.
   *
   * @param {ModdleElement} definition where the planning table is added
   *
   * @return {ModdleElement} the create planning table
   */
  this.createPlanningTable = function(definition) {

    var planningTable = definition.planningTable;

    if (!planningTable) {

      // (1) create new planning table
      planningTable = self._cmmnFactory.create('cmmn:PlanningTable');

      // (2) filter all items which are affected by adding a planning
      // table to its definition
      var shapes = itemRegistry.getShapes(definition);

      // (3) set planning table
      modeling.updateProperties(definition, {
        planningTable: planningTable
      }, shapes);

      // (4) set parent of planning table to definition
      modeling.updateSemanticParent(planningTable, definition);
    }


    return planningTable;
  };


  /**
   * Deletes a given planning table from the definition. If the planning
   * table is nested inside other planning tables, then the plannings tables
   * are also deleted, if they do not contain any element.
   *
   * @param {ModdleElement} planningTable to delete
   *
   */
  this.deletePlanningTable = function(planningTable) {

    // According to spec: a planning table must contain at least one element.
    // if it does not contain any element, then the planning table is deleted.

    // (1) cannot delete planning table if contains at least one element
    if (planningTable.get(containment).length > 0) {
      return;
    }

    // (2) if planning table does not contain any element, then remove it
    var oldParent = planningTable.$parent;
    while (is(oldParent, 'cmmn:PlanningTable') && !planningTable.get(containment).length) {
      modeling.updateSemanticParent(planningTable, null, containment);
      planningTable = oldParent;
      oldParent = oldParent.$parent;
    }

    if (is(oldParent, 'cmmn:PlanItemDefinition')) {

      if (planningTable && !planningTable.get(containment).length) {

        // (3) get definition containing this planning table
        var definition = getParent(planningTable, 'cmmn:PlanItemDefinition');

        // (4) filter all items which are affected by removing this planning
        // table from its definition
        var shapes = itemRegistry.getShapes(definition);

        // (5) set planning table attribute to undefined
        modeling.updateProperties(definition, {
          planningTable: undefined
        }, shapes);

        // (6) set planning tables parent to null
        modeling.updateSemanticParent(planningTable, null, null);
      }
    }
  };


  /**
   * Returns true, if there is another incoming discretionary connection
   * apart the given connection.
   *
   * @param {djs.mode.Base} shape
   * @param {djs.mode.Base} connection
   *
   * @return {boolean} if there is another incoming discretionary connection
   */
  function isReferencedByAnotherDiscretionaryConnection(shape, connection) {
    return any(shape.incoming, function(con) {
      return con !== connection && isDiscretionaryConnection(con);
    });
  }


  function isDiscretionaryConnection(connection) {
    return !connection.businessObject.cmmnElementRef;
  }

}

PlanningTableUpdater.$inject = [
  'eventBus',
  'cmmnFactory',
  'modeling',
  'itemRegistry'
];

inherits(PlanningTableUpdater, CommandInterceptor);

module.exports = PlanningTableUpdater;


function getTargetDefinition(shape) {
  var target = fixTarget(shape);
  return getDefinition(target) || getBusinessObject(target);
}

/**
 * Fixes the target.
 * A discretionary item cannot be added to plan fragment,
 * in that case the discretionary item is added to the visual
 * surrounding stage.
 *
 * @param {djs.model.Base} target
 *
 * @return {djs.model.Base} the fixed target
 */
function fixTarget(target) {
  if (target && !isCasePlanModel(target)) {

    var definition = getDefinition(target);

    if (isPlanFragment(definition)) {
      target = getParent(target, [
        'cmmn:Stage',
        'cmmn:PlanItem',
        'cmmn:DiscretionaryItem'
      ]);
      target = fixTarget(target);
    }
  }

  return target;
}


/**
 * Returns parent planning table of the given element.
 *
 * @param {ModdleElement} element
 *
 * @param {ModdleElement} the parent planning table
 */
function getParentPlanningTable(element) {
  element = getBusinessObject(element);
  return getParent(element, 'cmmn:PlanningTable');
}

},{"102":102,"257":257,"267":267,"271":271,"45":45,"46":46,"74":74}],31:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    inherits = _dereq_(257),
    assign = _dereq_(398);

var isArray = _dereq_(389);

var CommandInterceptor = _dereq_(102);

var is = _dereq_(74).is;

var LOW_PRIORITY = 200,
    HIGH_PRIORITY = 5000;

function ReplaceConnectionBehavior(eventBus, modeling, cmmnRules, selection, rules) {

  CommandInterceptor.call(this, eventBus);


  function canConnectPlanItemOnPartConnection(source, target) {
    return cmmnRules.canConnectPlanItemOnPartConnection(source, target);
  }


  function canConnectCaseFileItemOnPartConnection(source, target) {
    return cmmnRules.canConnectCaseFileItemOnPartConnection(source, target);
  }


  function canConnectDiscretionaryConnection(source, target, connection) {
    return cmmnRules.canConnectDiscretionaryConnection(source, target, connection);
  }


  function canConnectAssociation(source, target) {
    return cmmnRules.canConnectAssociation(source, target);
  }


  function canReconnect(type, attrs) {
    return rules.allowed(type, attrs);
  }

  function fixConnection(connection, source, target, hints) {

    var parent = connection.parent;

    hints = hints || {};
    source = source || connection.source;
    target = target || connection.target;

    if (!parent) {
      return;
    }

    var remove,
        replacement,
        cmmnElement = getCmmnElement(connection);

    /**
     * Check if incoming or outgoing connections can stay and/or replaced.
     */

    if (cmmnElement) {

      if (is(cmmnElement, 'cmmn:PlanItemOnPart')) {

        if (!canConnectPlanItemOnPartConnection(source, target)) {
          remove = true;
        }

        if (canConnectCaseFileItemOnPartConnection(source, target)) {
          replacement = {
            type: 'cmmn:CaseFileItemOnPart',
            name: cmmnElement.name,
            isStandardEventVisible: isStandardEventVisible(connection)
          };
        }

        if (canConnectDiscretionaryConnection(source, target, connection)) {
          replacement = {
            type: 'cmmndi:CMMNEdge'
          };
        }

      }


      if (is(cmmnElement, 'cmmn:CaseFileItemOnPart')) {

        if (!canConnectCaseFileItemOnPartConnection(source, target)) {
          remove = true;
        }

        if (canConnectPlanItemOnPartConnection(source, target)) {
          replacement = {
            type: 'cmmn:PlanItemOnPart',
            name: cmmnElement.name,
            isStandardEventVisible: isStandardEventVisible(connection)
          };
        }

      }

      if (is(cmmnElement, 'cmmn:Association') && !canConnectAssociation(source, target)) {
        remove = true;
      }

    }
    else {

      if (!canConnectDiscretionaryConnection(source, target, connection)) {
        remove = true;
      }

      if (canConnectPlanItemOnPartConnection(source, target)) {
        replacement = {
          type: 'cmmn:PlanItemOnPart',
          isStandardEventVisible: true
        };
      }

    }

    if (remove) {

      if (!replacement && (isTextAnnotation(source) || isTextAnnotation(target))) {

        replacement = {
          type: 'cmmn:Association'
        };
      }

      modeling.removeConnection(connection);
    }

    if (replacement) {

      var attrs = assign({
        waypoints: connection.waypoints.slice()
      }, replacement);

      var newConnection = modeling.connect(source, target, attrs);

      if (hints.select !== false) {
        selection.select(newConnection);
      }

      return newConnection;

    }

  }


  this.postExecuted('elements.move', LOW_PRIORITY, function(context) {

    var closure = context.closure,
        allConnections = closure.allConnections;

    forEach(allConnections, function(connection) {
      fixConnection(connection, null, null, {
        select: false
      });
    });

  }, true);


  this.preExecute([
    'connection.reconnectEnd',
    'connection.reconnectStart'
  ], HIGH_PRIORITY + LOW_PRIORITY, function(event) {

    var type = event.command,
        isReconnectStart = (type === 'connection.reconnectStart'),
        context = event.context,
        connection = context.connection,
        source = context.newSource || connection.source,
        target = context.newTarget || connection.target,
        dockingOrPoints = context.dockingOrPoints,
        canExecute = context.canExecute;

    if (context.hints && context.hints.nested) {
      return;
    }

    if (canExecute === undefined) {

      var attrs = {
        connection: connection
      };

      attrs[ isReconnectStart ? 'hover' : 'source' ] = source;
      attrs[ !isReconnectStart ? 'hover' : 'target' ] = target;

      canExecute = canReconnect(type, attrs);

    }

    if (canExecute && canExecute.reverse) {

      if (!isArray(dockingOrPoints)) {
        var waypoints = connection.waypoints.slice();
        waypoints.splice(isReconnectStart ? 0 : -1, 1, dockingOrPoints);
        dockingOrPoints = waypoints;
      }

      context.newSource = target;
      context.newTarget = source;
      context.dockingOrPoints = dockingOrPoints.reverse();

    }

  });


  this.preExecute([
    'connection.reconnectStart',
    'connection.reconnectEnd'
  ], HIGH_PRIORITY, function(context) {

    var connection = context.connection,
        source = context.newSource || connection.source,
        target = context.newTarget || connection.target,
        hints = context.hints || {};

    context.connection = fixConnection(connection, source, target, {
      select: !hints.nested
    }) || connection;

  }, true);


  this.postExecuted('shape.replace', function(context) {

    var shape = context.newShape,
        bo = shape.businessObject,
        connections = getAttachersOutgoingConnections(shape);

    forEach(connections, function(connection) {

      var source = connection.source,
          target = connection.target,
          cmmnElement = getCmmnElement(connection);

      if (is(cmmnElement, 'cmmn:PlanItemOnPart')) {

        if (canConnectPlanItemOnPartConnection(source, target)) {
          modeling.updateProperties(cmmnElement, { sourceRef: bo }, connection);
        }
        else {
          modeling.removeConnection(connection);
        }

      }

    });

  }, true);


  this.postExecuted('element.updateProperties', function(context) {

    var properties = context.properties,
        changed = context.changed;

    if (properties && properties.isBlocking === false) {

      forEach(changed, function(shape) {

        var connections = shape.outgoing;

        forEach(connections, function(connection) {
          fixConnection(connection, null, null, {
            select: false
          });
        });

      });

    }

  }, true);

}

inherits(ReplaceConnectionBehavior, CommandInterceptor);

ReplaceConnectionBehavior.$inject = [ 'eventBus', 'modeling', 'cmmnRules', 'selection', 'rules' ];

module.exports = ReplaceConnectionBehavior;


function isStandardEventVisible(connection) {
  return connection.businessObject.isStandardEventVisible;
}

function getCmmnElement(connection) {
  return connection.businessObject && connection.businessObject.cmmnElementRef;
}

function getAttachersOutgoingConnections(shape) {

  var attachers = shape.attachers,
      connections = [];

  forEach(attachers, function(attacher) {
    forEach(attacher.outgoing, function(connection) {
      connections.push(connection);
    });
  });

  return connections;
}

function isTextAnnotation(element) {
  return is(element, 'cmmn:TextAnnotation');
}
},{"102":102,"257":257,"271":271,"389":389,"398":398,"74":74}],32:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

var saveClear = _dereq_(245).saveClear;

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    getSentry = ModelUtil.getSentry;

var forEach = _dereq_(271),
    filter = _dereq_(269),
    assign = _dereq_(398);

var HIGH_PRIORITY = 6000,
    LOW_PRIORITY = 500,
    VERY_LOW_PRIORITY = 100;


function ReplaceElementBehavior(
  cmmnReplace,
  cmmnRules,
  elementFactory,
  elementRegistry,
  eventBus,
  modeling,
  selection,
  rules
) {

  CommandInterceptor.call(this, eventBus);

  this._cmmnReplace = cmmnReplace;
  this._cmmnRules = cmmnRules;
  this._elementFactory = elementFactory;
  this._elementRegistry = elementRegistry;
  this._modeling = modeling;
  this._selection = selection;
  this._rules = rules;

  var self = this;


  function canConnect(source, target) {

    return rules.allowed('connection.create', {
      source: source,
      target: target
    });

  }

  function canReconnect(type, attrs) {
    return rules.allowed(type, attrs);
  }


  // SHAPES //////////////////////////////////////////////////////////////////

  this.preExecute([ 'shape.create', 'shape.append' ], HIGH_PRIORITY, function(context) {

    var shape = context.shape,
        source = context.source,
        target = context.parent || (source && source.parent),
        host = context.host,
        position = context.position,
        hints = context.hints || {};

    if (hints.nested) {
      return;
    }

    if (host && isCriterion(shape)) {
      target = host;
    }

    if (!cmmnRules.canCreate(shape, target, source, position)) {

      var canReplace = cmmnRules.canReplace([ shape ], target, position, source);

      if (canReplace && canReplace.replacements) {

        var replacement = canReplace.replacements[0],
            definition = getDefinition(shape),
            sentry = getSentry(shape),
            elementType = replacement.newElementType,
            definitionType = replacement.newDefinitionType || (definition && definition.$type);

        var attrs = assign({}, {
          type: elementType
        });

        if (definitionType) {
          assign(attrs, {
            definitionType: definitionType
          });
        }

        if (sentry) {
          assign(attrs, {
            sentryRef: sentry
          });
        }

        context.shape = elementFactory.createShape(attrs);

      }

    }

  }, true);


  this.postExecuted('elements.move', LOW_PRIORITY, function(context) {

    var target = context.newParent,
        newHost = context.newHost,
        elements = context.shapes.slice();

    if (elements.length === 1 && newHost) {
      target = newHost;
    }
    else {
      elements = filter(elements, function(elem) {
        return !isCriterion(elem);
      });
    }

    if (target && !cmmnRules.canMove(elements, target)) {

      var canReplace = cmmnRules.canReplace(elements, target);

      if (canReplace && canReplace.replacements) {
        self.replaceElements(elements, canReplace.replacements);
      }

    }

  }, true);


  this.postExecuted( [ 'shape.replace' ], 1500, function(e) {
    var context = e.context,
        oldShape = context.oldShape,
        newShape = context.newShape;

    modeling.unclaimId(oldShape.businessObject.id, oldShape.businessObject);
    modeling.updateProperties(newShape, { id: oldShape.id });
  });


  // CONNECTIONS /////////////////////////////////////////////////////////////////////

  this.preExecute('connection.create', HIGH_PRIORITY, function(context) {

    var source = context.source,
        target = context.target,
        canReplace = context.canExecute || canConnect(source, target);

    if (canReplace && canReplace.replacements) {

      var replacements = self.replaceElements([ source, target ], canReplace.replacements, {
        select: false
      });

      context.source = replacements[source.id] || context.source;
      context.target = replacements[target.id] || context.target;

      // remember replaced by element in canReplace object (see 'connect.end')
      assign(canReplace, {
        replacedBy: !canReplace.reverse ? context.target : context.source
      });

    }

  }, true);


  eventBus.on('connect.end', LOW_PRIORITY + VERY_LOW_PRIORITY, function(e) {

    var canExecute = e.context.canExecute,
        replacedBy = canExecute && canExecute.replacedBy;

    // if target shape has been replaced, then select the
    // new element and not the old target.
    if (replacedBy) {
      e.context.target = replacedBy;
    }

  });


  this.preExecute([
    'connection.reconnectStart',
    'connection.reconnectEnd'
  ], HIGH_PRIORITY, function(event) {

    var type = event.command,
        isReconnectStart = (type === 'connection.reconnectStart'),
        context = event.context,
        connection = context.connection,
        source = context.newSource || connection.source,
        target = context.newTarget || connection.target,
        attrs = { connection: connection },
        canReplace;

    if (context.hints && context.hints.nested) {
      return;
    }

    attrs[ isReconnectStart ? 'hover' : 'source' ] = source;
    attrs[ !isReconnectStart ? 'hover' : 'target' ] = target;

    canReplace = canReconnect(type, attrs);

    if (canReplace && canReplace.replacements) {
      var replacements = self.replaceElements([ source, target ], canReplace.replacements, {
        select: false
      });

      context.newSource = replacements[source.id] || context.newSource;
      context.newTarget = replacements[target.id] || context.newTarget;
    }

    // remember result in context, so that this can be re-used
    context.canExecute = canReplace;

  });


  this.preExecute('shape.delete', HIGH_PRIORITY, function(context) {

    var shape = context.shape,
        parent = isCriterion(shape) ? shape.host : shape.parent,
        definition = getDefinition(parent);

    // if the shape to delete is contained by a plan fragment (and not stage)
    // then remove incoming connections. Thereby an additional hint is provided
    // to the context, so that shape delete is not replaced when the connection
    // is deleted.

    if (is(definition, 'cmmn:Stage')) {
      return;
    }

    saveClear(shape.incoming, function(connection) {
      modeling.removeConnection(connection, { nested: true, endChanged: true });
    });

  }, true);


  this.postExecuted([
    'connection.delete',
    'connection.reconnectEnd'
  ], LOW_PRIORITY, function(context) {

    var shape = context.target || context.oldTarget,
        elements = [ shape ],
        target = isCriterion(shape) ? shape.host : shape.parent,
        hints = context.hints || {};

    if (hints.endChanged) {
      return;
    }

    if (target && !cmmnRules.canMove(elements, target)) {

      var canReplace = cmmnRules.canReplace(elements, target);

      if (canReplace && canReplace.replacements) {
        self.replaceElements(elements, canReplace.replacements, { select: false });
      }

    }

  }, true);


  // PROPERTIES /////////////////////////////////////////////////////////////////////

  this.postExecuted('element.updateProperties', function(context) {

    var properties = context.properties,
        changed = context.changed;

    if (properties && properties.isBlocking === false) {

      forEach(changed, function(shape) {

        var attachers = shape.attachers,
            canReplace = cmmnRules.canReplace(attachers, shape);

        if (canReplace) {
          self.replaceElements(attachers, canReplace.replacements, { select: false });
        }
      });

    }

  }, true);


  // API ///////////////////////////////////////////////////////////////////////////

  this.replaceElements = function(elements, newElements, hints) {

    var self = this;

    var elementRegistry = this._elementRegistry,
        selection = this._selection;

    var executedReplacements = {};

    hints = hints || {};

    forEach(newElements, function(replacement) {

      var oldElement = elementRegistry.get(replacement.oldElementId),
          idx = elements.indexOf(oldElement),
          replacedBy;

      if (!oldElement) {
        return;
      }

      replacedBy = self.replaceElement(oldElement, replacement);

      if (idx !== -1) {
        elements[idx] = replacedBy;
      }

      executedReplacements[oldElement.id] = replacedBy;

    });

    if (newElements && hints.select !== false) {
      selection.select(elements);
    }

    return executedReplacements;

  };


  this.replaceElement = function(element, replacement) {

    var cmmnReplace = this._cmmnReplace;

    var definition = getDefinition(element),
        definitionType = replacement.newDefinitionType || (definition && definition.$type);

    if (!element) {
      return;
    }

    var newElement = {
      type: replacement.newElementType
    };

    if (definitionType) {
      assign(newElement, {
        definitionType: definitionType
      });
    }

    return cmmnReplace.replaceElement(element, newElement, { select: false });

  };

}


ReplaceElementBehavior.$inject = [
  'cmmnReplace',
  'cmmnRules',
  'elementFactory',
  'elementRegistry',
  'eventBus',
  'modeling',
  'selection',
  'rules'
];

inherits(ReplaceElementBehavior, CommandInterceptor);

module.exports = ReplaceElementBehavior;


function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

},{"102":102,"245":245,"257":257,"269":269,"271":271,"398":398,"74":74}],33:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(74);

var is = ModelUtil.is,
    getBusinessObject = ModelUtil.getBusinessObject,
    isCasePlanModel = ModelUtil.isCasePlanModel;

var filter = _dereq_(269);
var ResizeUtil = _dereq_(199);
var getBBox = _dereq_(235).getBBox;

var SLIGHTLY_HIGHER_PRIORITY = 1001;

var DEFAULT_MIN_WIDTH = 10;

/**
 * Computes the minimum resize box.
 *
 * Note: it is slightly different than
 * diagram-js/lib/features/resize/Resize#computeMinResizeBox
 */
function computeMinResizeBox(context) {
  var shape = context.shape,
      direction = context.direction,
      minDimensions,
      childrenBounds;

  minDimensions = context.minDimensions || {
    width: DEFAULT_MIN_WIDTH,
    height: DEFAULT_MIN_WIDTH
  };

  // get children bounds
  childrenBounds = computeChildrenBBox(shape, context.childrenBoxPadding);

  // get correct minimum bounds from given resize direction
  // basically ensures that the minBounds is max(childrenBounds, minDimensions)
  return ResizeUtil.getMinResizeBounds(direction, shape, minDimensions, childrenBounds);
}

/**
 * Computes the bbox of the children.
 * 
 * It first determine all relevant children,
 * then it computes the size of the bbox.
 */
function computeChildrenBBox(shape, padding) {
  // grab all the children that are part of the
  // parents children box
  var elements = filter(shape.children, function(element) {
    return isBBoxChild(shape, element);
  });

  if (elements.length) {
    return ResizeUtil.addPadding(getBBox(elements), padding);
  }
}

/**
 * Returns true, if the given element does
 * have any waypoints, is not a label or an
 * exit criterian attached to the given shape.
 */
function isBBoxChild(shape, element) {

  // exclude connections
  if (element.waypoints) {
    return false;
  }

  // exclude labels
  if (element.type === 'label') {
    return false;
  }

  if (is(element, 'cmmn:ExitCriterion')) {
    var bo = getBusinessObject(shape);
    var exitCriteria = bo.get('exitCriteria');
    var exitCriterion = getBusinessObject(element);
    if (exitCriteria.indexOf(exitCriterion) >= 0) {
      return false;
    }
  }

  return true;
}

/**
 * Computes the minimum resize box by excluding
 * attached exit criteria to the case plan model.
 */
function ResizeCasePlanModelBehavior(eventBus, modeling) {

  eventBus.on('resize.start', SLIGHTLY_HIGHER_PRIORITY, function(event) {
    var context = event.context,
        shape = context.shape;

    if (isCasePlanModel(shape)) {
      context.minBounds = computeMinResizeBox(context);
    }
  });

}

ResizeCasePlanModelBehavior.$inject = [ 'eventBus', 'modeling' ];

module.exports = ResizeCasePlanModelBehavior;

},{"199":199,"235":235,"269":269,"74":74}],34:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

var forEach = _dereq_(271),
    flatten = _dereq_(259),
    groupBy = _dereq_(272),
    map = _dereq_(273);

var any = _dereq_(267);

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    getSentry = ModelUtil.getSentry,
    getBusinessObject = ModelUtil.getBusinessObject,
    getDefinition = ModelUtil.getDefinition,
    getStandardEvents = ModelUtil.getStandardEvents;

var getParent = _dereq_(45).getParent;

var PlanItemDefinitionUtil = _dereq_(46),
    isItemCapable = PlanItemDefinitionUtil.isItemCapable,
    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,
    getDirectItemCapables = PlanItemDefinitionUtil.getDirectItemCapables,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask;

var VERY_LOW_PRIORITY = 300;

/**
 * A handler responsible for adding, moving and deleting sentries.
 * These changes are reflected to the underlying CMMN 1.1 XML.
 */
function SentryUpdater(eventBus, modeling, itemRegistry, cmmnReplace, cmmnFactory) {

  var self = this;

  CommandInterceptor.call(this, eventBus);

  var containment = 'sentries';


  // CONNECTIONS ////////////////////////////////////////////////////////////

  this.postExecuted('connection.create', function(context) {

    var connection = context.connection;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        criterion = connection.target,
        host = criterion.host,
        sentry = getSentry(criterion);

    if (!sentry) {
      sentry = createSentry(criterion);
      modeling.updateSemanticParent(sentry, getSentryParent(host), 'sentries');
    }

    modeling.updateSemanticParent(onPart, sentry, 'onParts', connection);

  }, true);


  this.preExecuted('connection.delete', function(context) {

    var connection = context.connection;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var source = connection.source,
        onPart = getOnPart(connection);

    if (existsAnotherConnection(source, connection)) {
      onPart = cloneOnPart(onPart);
      setCmmnElementRef(connection, onPart);
    }

    modeling.updateSemanticParent(onPart, null, 'onParts', connection);

  }, true);


  this.preExecuted('connection.reconnectStart', function(context) {

    var connection = context.connection,
        source = connection.source;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        criterion = connection.target,
        sentry = getSentry(criterion);

    if (existsAnotherConnection(source, connection)) {
      onPart = cloneOnPart(onPart);
      setCmmnElementRef(connection, onPart);
      modeling.updateSemanticParent(onPart, sentry, 'onParts', connection);
    }

  }, true);


  this.preExecuted('connection.reconnectEnd', function(context) {

    var connection = context.connection,
        source = connection.source;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        oldCriterion = connection.target,
        oldSentry = getSentry(oldCriterion),
        newCriterion = context.newTarget,
        newSentry = getSentry(newCriterion);

    if (oldSentry === newSentry) {
      return;
    }

    if (!newSentry) {
      newSentry = createSentry(newCriterion);
      modeling.updateSemanticParent(newSentry, getSentryParent(newCriterion.host), 'sentries');
    }

    if (existsAnotherConnection(source, connection)) {
      onPart = cloneOnPart(onPart);
      setCmmnElementRef(connection, onPart);
    }

    modeling.updateSemanticParent(onPart, newSentry, 'onParts', connection);

  }, true);


  this.postExecuted([ 'connection.create', 'connection.reconnectStart'], function(context) {

    var connection = context.connection;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        standardEvent;

    if (!isValidStandardEvent(connection)) {
      standardEvent = getDefaultStandardEvent(connection);
      modeling.updateProperties(onPart, {
        standardEvent: standardEvent
      }, connection);
    }

  }, true);


  // CREATE //////////////////////////////////////////////////////////////////

  this.postExecuted('element.updateAttachment', function(context) {

    var shape = context.shape;

    if (!isCriterion(shape)) {
      return;
    }

    if (shape.host) {
      self.updateSentriesSemanticParent([ shape ]);
    }
    else {
      self.deleteSentry(shape);
    }

  }, true);


  // DELETE /////////////////////////////////////////////////////////////

  this.preExecuted('shape.delete', function(context) {

    var definition = getDefinition(context.shape);

    if (!isHumanTask(definition)) {
      return;
    }

    // get remaining discretionary items
    context.discretionaryItems = context.discretionaryItems || getAllDiscretionaryItems(definition);

  }, true);


  this.postExecuted('shape.delete', VERY_LOW_PRIORITY, function(context) {

    var discretionaryItems = context.discretionaryItems,
        attachers;

    attachers = getAttachersRecurse(discretionaryItems);

    if (attachers && attachers.length) {
      self.updateSentriesSemanticParent(attachers);
    }

  }, true);


  // MOVING /////////////////////////////////////////////////////////////

  this.postExecuted([
    'connection.create',
    'connection.delete',
    'connection.reconnectEnd',
    'connection.reconnectStart'
  ], VERY_LOW_PRIORITY, function(context) {

    var connection = context.connection,
        source = context.newSource || context.source || connection.source,
        target = context.newTarget || context.target || connection.target,
        shapes = [],
        attachers;

    if (!isDiscretionaryConnection(connection, source, target)) {
      return;
    }

    if (connection.target) {
      shapes.push(connection.target);
    }

    if (!connection.target && context.target) {
      shapes.push(context.target);
    }

    if (context.oldTarget) {
      shapes.push(context.oldTarget);
    }

    attachers = getAttachersRecurse(shapes);

    if (attachers && attachers.length) {
      self.updateSentriesSemanticParent(attachers);
    }

  }, true);


  this.postExecuted('elements.move', VERY_LOW_PRIORITY, function(context) {

    var shapes = context.shapes,
        newParent = context.newParent,
        oldParent = context.hints && context.hints.oldParent,
        attachers;

    if (oldParent === newParent) {
      return;
    }

    attachers = getAttachersRecurse(shapes);

    if (attachers && attachers.length) {
      self.updateSentriesSemanticParent(attachers);
    }

  }, true);


  // API //////////////////////////////////////////////////////


  /**
   * Deletes by given criteria referenced sentries, if the
   * the sentry is not referenced by any other criterion.
   *
   * @param {Object} criteria deleted criteria
   */
  this.deleteSentry = function(criterion) {

    var sentry = getSentry(criterion),
        references;

    if (sentry) {
      references = itemRegistry.getReferences(sentry);
    
      if (references.length <= 1) {
        modeling.updateSemanticParent(sentry, null, containment);
      }
    }

  };


  /**
   * Updates the parent of by given criteria referenced sentries.
   *
   * If the sentry is referenced by multiple criteria and only
   * a part of them has been moved, then the sentry is duplicated.
   *
   * @param {Object} criteria updated criteria
   */
  this.updateSentriesSemanticParent = function(criteria) {

    var groupedCriteria = groupBySentry(criteria),
        replacements = {};

    /**
     * Returns true if the given element is replaced
     */ 
    function isReplaced(elem) {
      return !!replacements[elem.id];
    }

    /**
     * Set the given old element as replaced
     * with the given new element.
     */
    function replace(oldElem, newElem) {
      replacements[oldElem.id] = newElem;
    }

    /**
     * Returns the replacement of the given element.
     * If no replacement is available the given element
     * itself is returned.
     */
    function getReplacement(elem) {
      return replacements[elem.id] || elem;
    }

    /**
     * Returns true if the sentry should be replaced.
     */
    function shouldReplace(sentry, newParent) {
      var references = itemRegistry.getReferences(sentry),
          criteria = (groupedCriteria[sentry.id] || []),
          referencesLength = itemRegistry.getReferences(sentry).length,
          criteriaLength = criteria.length;

      if (referencesLength > criteriaLength) {

        if (!newParent) {
          return true;
        }

        return any(references, function(criterion) {
          var criterionShape = itemRegistry.getShape(criterion);
          return criterionShape && newParent !== getSentryParent(criterionShape.host);
        });

      }

      return false;
    }


    handleEachElement(criteria, function(criterion) {

      var sentry = getSentry(criterion);

      if (sentry) {

        var newParent = getSentryParent(criterion.host);

        if (!newParent) {
          var parent = getParent(getBusinessObject(criterion));
          newParent = parent && getSentryParent(parent);
        }

        if (sentry.$parent === newParent) {
          return;
        }

        if (!isReplaced(sentry) && shouldReplace(sentry, newParent)) {
          var newSentry = cmmnReplace.replaceSentry(sentry);
          replace(sentry, newSentry);

          forEach(criterion.incoming, function(con) {

            var cmmnElement = con.businessObject.cmmnElementRef;
            if (cmmnElement && is(cmmnElement, 'cmmn:OnPart')) {
              replace(cmmnElement, cloneOnPart(cmmnElement));
            }

          });
        }

        sentry = getReplacement(sentry);

        if (getSentry(criterion) !== sentry) {
          setSentryRef(criterion, sentry);
        }

        forEach(criterion.incoming, function(con) {

          var cmmnElement = con.businessObject.cmmnElementRef;
          if (cmmnElement && is(cmmnElement, 'cmmn:OnPart')) {

            var replaceBy = getReplacement(cmmnElement);

            if (replaceBy && cmmnElement !== replaceBy) {
              setCmmnElementRef(con, replaceBy);
              modeling.updateSemanticParent(replaceBy, sentry, 'onParts');
            }

          }

        });

        modeling.updateSemanticParent(sentry, newParent, containment);

      }

    });

  };


  // UTILITIES /////////////////////////////////////////////////////////////////


  function getAttachersRecurse(shapes) {

    var attachers = getAttachers(shapes);

    handleEachElement(shapes, function(shape) {

      var definition = getDefinition(shape);

      if (isHumanTask(definition)) {

        var items = getAllDiscretionaryItems(shape);

        if (items && items.length) {
          attachers = attachers.concat(getAttachers(items));
        }

        return items;
      }

      return getDirectItemCapables(shape);

    });

    return flatten(attachers);
  }


  function handleEachElement(shapes, fn) {

    var handledElements = {};

    function handled(element) {
      handledElements[element.id] = element;
    }

    function isHandled(element) {
      return !!handledElements[element.id];
    }

    function eachElement(elements, isRoot) {
      forEach(elements, function(element) {

        if (!isHandled(element)) {
          handled(element);

          element = itemRegistry.getShape(element.id) || element;

          var children = fn(element);

          if (children && children.length) {
            eachElement(children);
          }
        }

        if (isRoot) {
          handledElements = {};
        }

      });
    }

    eachElement(shapes, true);
  }

  function createSentry(criterion) {
    var sentry = cmmnFactory.createSentry();
    setSentryRef(criterion, sentry);
    return sentry;
  }

  function setSentryRef(criterion, sentry) {
    modeling.updateProperties(criterion, {
      sentryRef: sentry
    });
  }

  function setCmmnElementRef(connection, ref) {
    modeling.updateProperties(connection, {
      cmmnElementRef: ref
    });
  }

  function cloneOnPart(onPart) {
    var attrs = {
      name: onPart.name,
      sourceRef: onPart.sourceRef,
      standardEvent: onPart.standardEvent
    };

    if (is(onPart, 'cmmn:PlanItemOnPart')) {
      attrs.exitCriterionRef = onPart.exitCriterionRef;
    }

    return cmmnFactory.create(onPart.$type, attrs);
  }


  function isOnPartConnection(connection) {
    var cmmnElement = connection.businessObject.cmmnElementRef;
    return is(cmmnElement, 'cmmn:OnPart');
  }

  function isDiscretionaryConnection(connection, source, target) {
    return !connection.businessObject.cmmnElementRef;
  }

}

SentryUpdater.$inject = [
  'eventBus',
  'modeling',
  'itemRegistry',
  'cmmnReplace',
  'cmmnFactory'
];

inherits(SentryUpdater, CommandInterceptor);

module.exports = SentryUpdater;


/**
 * Returns based on the given host the parent
 * for a sentry.
 *
 * @param {djs.model.Base} host
 *
 * @result {ModdleElement} parent
 */
function getSentryParent(host) {

  if (isCasePlanModel(host)) {
    return getBusinessObject(host);
  }

  if (isItemCapable(host)) {
    var bo = getBusinessObject(host);
    return getParent(bo, 'cmmn:PlanFragment');
  }

}


/**
 * Returns all attachers for the given shapes.
 *
 * @param {Array<djs.model.Base>} shapes
 *
 * @result {Array<djs.model.Base>} attachers
 */
function getAttachers(shapes) {
  return flatten(map(shapes, function(s) {
    var attachers = [];

    if (s.attachers) {
      attachers = s.attachers;
    }
    else {
      var bo = getBusinessObject(s);

      var exitCriteria = bo.get('exitCriteria');
      forEach(exitCriteria, function(criterion) {
        attachers.push(criterion);
      });

      var entryCriteria = bo.get('entryCriteria');
      forEach(entryCriteria, function(criterion) {
        attachers.push(criterion);
      });
    }

    return attachers || [];
  }));
}


/**
 * Groups given criteria by sentry.
 *
 * @param {Object} criteria group by id
 *
 * @result {Object} criteria grouped by sentry
 */
function groupBySentry(criteria) {
  return groupBy(criteria, function(criterion) {
    var sentry = getSentry(criterion);
    return sentry && sentry.id;
  });
}


/**
 * Returns true if the given element is a criterion.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean}
 */
function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function existsAnotherConnection(source, connection) {
  var onPart = getOnPart(connection);
  return any(source.outgoing, function(con) {
    return connection !== con && onPart === getOnPart(con);
  });
}

function getOnPart(connection) {
  connection = getBusinessObject(connection);
  return connection.cmmnElementRef;
}

function isValidStandardEvent(connection) {

  var onPart = getOnPart(connection),
      standardEvent = onPart.standardEvent,
      possibleStandardEvents = getStandardEvents(onPart);

  return standardEvent && possibleStandardEvents.indexOf(standardEvent) !== -1;

}

function getDefaultStandardEvent(element) {

  element = getOnPart(element);

  if (is(element.sourceRef, 'cmmn:CaseFileItem')) {
    return 'update';
  }

  if (is(element.exitCriterionRef, 'cmmn:ExitCriterion')) {
    return 'exit';
  }

  if (is(element.sourceRef, 'cmmn:PlanItem')) {

    var definition = getDefinition(element.sourceRef);
    if (is(definition, 'cmmn:EventListener') || is(definition, 'cmmn:Milestone')) {
      return 'occur';
    }
    else {
      return 'complete';
    }

  }

}

},{"102":102,"257":257,"259":259,"267":267,"271":271,"272":272,"273":273,"45":45,"46":46,"74":74}],35:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

function UnclaimIdBehavior(eventBus, modeling) {

  CommandInterceptor.call(this, eventBus);

  this.preExecute('elements.delete', function(event) {
    var context = event.context,
        elements = context.elements;

    forEach(elements, function(element) {
      modeling.unclaimId(element.businessObject.id, element.businessObject);
    });

  });
}

inherits(UnclaimIdBehavior, CommandInterceptor);

UnclaimIdBehavior.$inject = [ 'eventBus', 'modeling' ];

module.exports = UnclaimIdBehavior;

},{"102":102,"257":257,"271":271}],36:[function(_dereq_,module,exports){
module.exports = {
  __init__: [
    'attachCriterionBehavior',
    'caseFileItemUpdater',
    'labelBehavior',
    'planItemDefinitionUpdater',
    'planningTableUpdater',
    'replaceConnectionBehavior',
    'replaceElementBehavior',
    'resizeCasePlanModelBehavior',
    'sentryUpdater',
    'unclaimIdBehavior'
  ],
  attachCriterionBehavior: [ 'type', _dereq_(26) ],
  caseFileItemUpdater: [ 'type', _dereq_(27) ],
  labelBehavior: [ 'type', _dereq_(28) ],
  planItemDefinitionUpdater: [ 'type', _dereq_(29) ],
  planningTableUpdater: [ 'type', _dereq_(30) ],
  replaceConnectionBehavior: [ 'type', _dereq_(31) ],
  replaceElementBehavior: [ 'type', _dereq_(32) ],
  resizeCasePlanModelBehavior: [ 'type', _dereq_(33) ],
  sentryUpdater: [ 'type', _dereq_(34) ],
  unclaimIdBehavior: [ 'type', _dereq_(35) ]
};

},{"26":26,"27":27,"28":28,"29":29,"30":30,"31":31,"32":32,"33":33,"34":34,"35":35}],37:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var is = _dereq_(74).is;


function AppendShapeHandler(modeling, cmmnRules) {
  this._modeling = modeling;
  this._cmmnRules = cmmnRules;
}

inherits(AppendShapeHandler, _dereq_(159));


AppendShapeHandler.$inject = [ 'modeling', 'cmmnRules' ];

module.exports = AppendShapeHandler;


////// api /////////////////////////////////////////////

AppendShapeHandler.prototype.preExecute = function(context) {

  if (!context.source) {
    throw new Error('source required');
  }

  var cmmnRules = this._cmmnRules;

  var shape = context.shape,
      source = context.source,
      parent = context.parent || context.source.parent,
      position = context.position,
      isAttach = false;

  if (isCriterion(shape)) {
    isAttach = cmmnRules.canAttach(shape, parent, source, position) === 'attach';
  }

  context.shape = this._modeling.createShape(shape, position, parent, isAttach, {
    nested: true
  });

};

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}
},{"159":159,"257":257,"74":74}],38:[function(_dereq_,module,exports){
'use strict';


function IdClaimHandler(moddle) {
  this._moddle = moddle;
}

IdClaimHandler.$inject = [ 'moddle' ];

module.exports = IdClaimHandler;


IdClaimHandler.prototype.execute = function(context) {
  var ids = this._moddle.ids,
      id = context.id,
      element = context.element,
      claiming = context.claiming;

  if (claiming) {
    ids.claim(id, element);
  } else {
    ids.unclaim(id);
  }
};


IdClaimHandler.prototype.revert = function(context) {
  var ids = this._moddle.ids,
      id = context.id,
      element = context.element,
      claiming = context.claiming;

  if (claiming) {
    ids.unclaim(id);
  } else {
    ids.claim(id, element);
  }
};

},{}],39:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var isArray = _dereq_(389);

/**
 * Overwrites the behavior of diagram-js/ReconnectConnectionHandler to enable
 * a switch between source and target of a connection on reconnect.
 */
function ReconnectConnectionHandler(rules) {
  this._rules = rules;
}

inherits(ReconnectConnectionHandler, _dereq_(173));

ReconnectConnectionHandler.$inject = [ 'rules' ];

module.exports = ReconnectConnectionHandler;


ReconnectConnectionHandler.prototype.execute = function(context) {

  var newSource = context.newSource,
      newTarget = context.newTarget,
      connection = context.connection,
      dockingOrPoints = context.dockingOrPoints,
      oldWaypoints = connection.waypoints,
      newWaypoints;

  if (!newSource && !newTarget) {
    throw new Error('newSource or newTarget are required');
  }

  context.oldWaypoints = oldWaypoints;

  if (isArray(dockingOrPoints)) {
    newWaypoints = dockingOrPoints;
  } else {
    newWaypoints = oldWaypoints.slice();

    newWaypoints.splice(newSource ? 0 : -1, 1, dockingOrPoints);
  }

  if (newSource) {
    context.oldSource = connection.source;
    connection.source = newSource;
  }

  if (newTarget) {
    context.oldTarget = connection.target;
    connection.target = newTarget;
  }

  connection.waypoints = newWaypoints;

  return connection;
};

},{"173":173,"257":257,"389":389}],40:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

function ReplaceShapeHandler(modeling, rules) {
  this._modeling = modeling;
  this._rules = rules;
}

inherits(ReplaceShapeHandler, _dereq_(174));

ReplaceShapeHandler.$inject = [ 'modeling', 'rules' ];

module.exports = ReplaceShapeHandler;


////// api /////////////////////////////////////////////


ReplaceShapeHandler.prototype.createShape = function(shape, position, target) {
  var modeling = this._modeling;
  return modeling.createShape(shape, position, target, {
    nested: true
  });
};


ReplaceShapeHandler.prototype.reconnectStart = function(connection, newSource, dockingPoint) {
  var modeling = this._modeling;
  modeling.reconnectStart(connection, newSource, dockingPoint, {
    nested: true,
    startChanged: true
  });
};


ReplaceShapeHandler.prototype.reconnectEnd = function(connection, newTarget, dockingPoint) {
  var modeling = this._modeling;
  modeling.reconnectEnd(connection, newTarget, dockingPoint, {
    nested: true,
    endChanged: true
  });
};

},{"174":174,"257":257}],41:[function(_dereq_,module,exports){
'use strict';

var filter = _dereq_(269),
    forEach = _dereq_(271);

var getBusinessObject = _dereq_(74).getBusinessObject,
    getItemControl = _dereq_(74).getItemControl,
    getDefaultControl = _dereq_(74).getDefaultControl,
    getDefinition = _dereq_(74).getDefinition,
    hasPlanningTable = _dereq_(74).hasPlanningTable;

var isPlanningTableCapable = _dereq_(46).isPlanningTableCapable;


function UpdateControlsHandler(itemRegistry, modeling, cmmnReplace, cmmnFactory) {
  this._itemRegistry = itemRegistry;
  this._modeling = modeling;
  this._cmmnReplace = cmmnReplace;
  this._cmmnFactory = cmmnFactory;
}

UpdateControlsHandler.$inject = [ 'itemRegistry', 'modeling', 'cmmnReplace', 'cmmnFactory' ];

module.exports = UpdateControlsHandler;


var PLAN_ITEM_CONTROL_PROPS = [
  'requiredRule',
  'repetitionRule',
  'manualActivationRule'
];

function getUpdate(key, value) {
  var update = {};
  update[key] = value;
  return update;
}


UpdateControlsHandler.prototype.preExecute = function(context) {

  var self = this;

  var element = context.element,
      values = context.values;

  if (!element) {
    throw new Error('element required');
  }

  forEach(values, function(value, key) {

    if (PLAN_ITEM_CONTROL_PROPS.indexOf(key) !== -1) {
      self._updateRule(element, key, value);
    }
    else {
      self._updateDecorator(element, key, value);
    }

  });

};


UpdateControlsHandler.prototype.execute = function() {};

UpdateControlsHandler.prototype.revert = function() {};


// API ////////////////////////////////////////////////


UpdateControlsHandler.prototype._updateDecorator = function(element, key, value) {

  var self = this,
      modeling = self._modeling;

  var definition = getDefinition(element),
      update = getUpdate(key, value),
      changed = [];

  if (definition[key] !== value) {

    changed = self._getReferencingShapes(definition);

    if (changed.length > 1 && canReplaceDefinition(definition)) {
      definition = self._replaceDefinition(element);
      changed = element;
    }

    modeling.updateProperties(definition, update, changed);

  }

};


UpdateControlsHandler.prototype._updateRule = function(element, rule, value) {

  var self = this,
      modeling = self._modeling,
      cmmnFactory = self._cmmnFactory;

  var itemControl = getItemControl(element),
      defaultControl = getDefaultControl(element),
      definition = getDefinition(element),
      update = getUpdate(rule, value);


  !value ? deleteRule() : setRule();


  function deleteRule() {

    var oldValue;

    if (isRulePresent(itemControl, rule)) {
      oldValue = itemControl[rule];
      modeling.updateProperties(itemControl, update, element);
      modeling.updateSemanticParent(oldValue);

      if (canDeletePlanItemControl(itemControl)) {
        modeling.updateProperties(element, { itemControl: undefined });
        modeling.updateSemanticParent(itemControl);
      }

    }

    if (isRulePresent(defaultControl, rule)) {
      oldValue = defaultControl[rule];

      var changed = self._getReferencingShapes(definition);

      if (changed.length > 1 && canReplaceDefinition(definition)) {

        changed = filter(changed, function(elem) {
          var localItemControl = getItemControl(elem),
              localDefaultControl = getDefaultControl(elem);

          return !isRulePresent(localItemControl, rule) &&
                  isRulePresent(localDefaultControl, rule);
        });

        if (changed.length > 1) {
          self._replaceDefinition(element);
          defaultControl = getDefaultControl(element);
          changed = element;
        }

      }

      modeling.updateProperties(defaultControl, update, changed);
      modeling.updateSemanticParent(oldValue);

      if (canDeletePlanItemControl(defaultControl)) {
        modeling.updateProperties(definition, { defaultControl: undefined }, changed);
        modeling.updateSemanticParent(defaultControl);
      }

    }

  }

  function setRule() {

    if (!itemControl) {
      itemControl = createPlanItemControl();
      modeling.updateProperties(element, { itemControl: itemControl });
      modeling.updateSemanticParent(itemControl, getBusinessObject(element));
    }

    modeling.updateProperties(itemControl, update, element);
    modeling.updateSemanticParent(value, itemControl);
  }

  function isRulePresent(control, rule) {
    return control && control[rule];
  }

  function createPlanItemControl() {
    return cmmnFactory.create('cmmn:PlanItemControl');
  }

  function canDeletePlanItemControl(control) {
    return !!(control && !control.repetitionRule && !control.requiredRule && !control.manualActivationRule);
  }

};


UpdateControlsHandler.prototype._replaceDefinition = function(element) {

  var self = this,
      modeling = self._modeling,
      cmmnReplace = self._cmmnReplace;

  var definition = getDefinition(element);

  var newDefinition = cmmnReplace.replacePlanItemDefinition(definition);
  modeling.updateProperties(element, { definitionRef: newDefinition });

  modeling.updateSemanticParent(newDefinition, definition.$parent, 'planItemDefinitions');

  return newDefinition;

};


UpdateControlsHandler.prototype._getReferencingShapes = function(definition) {

  var self = this,
      itemRegistry = self._itemRegistry;

  return itemRegistry.getShapes(definition);

};


function canReplaceDefinition(definition) {
  return !(isPlanningTableCapable(definition) && hasPlanningTable(definition));
}
},{"269":269,"271":271,"46":46,"74":74}],42:[function(_dereq_,module,exports){
'use strict';

var reduce = _dereq_(405),
    keys = _dereq_(399),
    forEach = _dereq_(271),
    assign = _dereq_(398);

var getBusinessObject = _dereq_(74).getBusinessObject;

var NAME = 'name',
    STANDARD_EVENT = 'standardEvent',
    ID = 'id',
    DEFINITION_REF = 'definitionRef',
    SENTRY_REF = 'sentryRef',
    IS_STANDARD_EVENT_VISIBLE = 'isStandardEventVisible';

var flatten = _dereq_(259);

/**
 * A handler that implements a CMMN 1.1 property update.
 *
 * This should be used to set simple properties on elements with
 * an underlying CMMN business object.
 *
 * Use respective diagram-js provided handlers if you would
 * like to perform automated modeling.
 */
function UpdatePropertiesHandler(elementRegistry, itemRegistry, moddle) {
  this._elementRegistry = elementRegistry;
  this._itemRegistry = itemRegistry;
  this._moddle = moddle;
}

UpdatePropertiesHandler.$inject = [ 'elementRegistry', 'itemRegistry', 'moddle' ];

module.exports = UpdatePropertiesHandler;


////// api /////////////////////////////////////////////

UpdatePropertiesHandler.prototype.preExecute = function(context) {

  var element = context.element,
      shape = context.shape;

  if (!element) {
    throw new Error('element required');
  }

  var bo = element.businessObject || element;

  context.businessObject = bo;

  var changed = [];

  if (element.businessObject) {
    changed.push(element);
  }

  if (shape) {
    changed.push(shape);
  }

  context.changed = flatten(changed);
};


/**
 * Updates a CMMN element with a list of new properties
 *
 * @param {Object} context
 * @param {djs.model.Base} context.element the element to update
 * @param {Object} context.properties a list of properties to set on the element's
 *                                    businessObject (the CMMN model element)
 *
 * @return {Array<djs.mode.Base>} the updated element
 */
UpdatePropertiesHandler.prototype.execute = function(context) {

  var elementRegistry = this._elementRegistry,
      itemRegistry = this._itemRegistry,
      ids = this._moddle.ids;

  var changed = context.changed;

  var element = context.element,
      businessObject = context.businessObject,
      properties = unwrapBusinessObjects(context.properties),
      oldProperties = context.oldProperties || getProperties(businessObject, keys(properties));

  if (isIdChange(properties, businessObject)) {
    ids.unclaim(businessObject[ID]);

    itemRegistry.updateId(businessObject, properties[ID]);

    var shape = elementRegistry.get(element.id);

    if (shape) {
      elementRegistry.updateId(shape, properties[ID]);
    }

    ids.claim(properties[ID], businessObject);
  }

  if (isDefinitionRefChange(properties, businessObject)) {
    itemRegistry.updateReference(businessObject, properties[DEFINITION_REF]);
  }

  if (isSentryRefChange(properties, businessObject)) {
    itemRegistry.updateReference(businessObject, properties[SENTRY_REF]);
  }

  if (NAME in properties) {

    forEach(changed, function(changedShape) {
      if (changedShape.label) {
        changed.push(changedShape.label);
      }
    });

  }

  if (STANDARD_EVENT in properties || IS_STANDARD_EVENT_VISIBLE in properties) {

    forEach(changed, function(changedShape) {
      if (changedShape.label) {
        changed.push(changedShape.label);
      }
    });

  }

  // update properties
  setProperties(businessObject, properties);

  // store old values
  context.oldProperties = oldProperties;

  // indicate changed on objects affected by the update
  return changed;
};

/**
 * Reverts the update on a CMMN elements properties.
 *
 * @param  {Object} context
 *
 * @return {djs.mode.Base} the updated element
 */
UpdatePropertiesHandler.prototype.revert = function(context) {

  var properties = context.properties,
      oldProperties = context.oldProperties,
      businessObject = context.businessObject,
      elementRegistry = this._elementRegistry,
      itemRegistry = this._itemRegistry,
      ids = this._moddle.ids;

  if (isIdChange(oldProperties, businessObject)) {
    itemRegistry.updateId(businessObject, oldProperties[ID]);
  }

  if (isDefinitionRefChange(oldProperties, businessObject)) {
    itemRegistry.updateReference(businessObject, oldProperties[DEFINITION_REF]);
  }

  if (isSentryRefChange(oldProperties, businessObject)) {
    itemRegistry.updateReference(businessObject, oldProperties[SENTRY_REF]);
  }

  // update properties
  setProperties(businessObject, oldProperties);

  if (isIdChange(properties, businessObject)) {
    ids.unclaim(properties[ID]);

    var shape = elementRegistry.get(properties[ID]);

    if (shape) {
      elementRegistry.updateId(shape, oldProperties[ID]);
    }

    ids.claim(oldProperties[ID], businessObject);
  }

  return context.changed;
};


function isIdChange(properties, businessObject) {
  return ID in properties && properties[ID] !== businessObject[ID];
}

function isDefinitionRefChange(properties, businessObject) {
  return DEFINITION_REF in properties && properties[DEFINITION_REF] !== businessObject[DEFINITION_REF];
}

function isSentryRefChange(properties, businessObject) {
  return SENTRY_REF in properties && properties[SENTRY_REF] !== businessObject[SENTRY_REF];
}


function getProperties(businessObject, propertyNames) {
  return reduce(propertyNames, function(result, key) {
    result[key] = businessObject.get(key);
    return result;
  }, {});
}


function setProperties(businessObject, properties) {
  forEach(properties, function(value, key) {
    businessObject.set(key, value);
  });
}


var referencePropertyNames = [ 'default' ];

/**
 * Make sure we unwrap the actual business object
 * behind diagram element that may have been
 * passed as arguments.
 *
 * @param  {Object} properties
 *
 * @return {Object} unwrappedProps
 */
function unwrapBusinessObjects(properties) {

  var unwrappedProps = assign({}, properties);

  referencePropertyNames.forEach(function(name) {
    if (name in properties) {
      unwrappedProps[name] = getBusinessObject(unwrappedProps[name]);
    }
  });

  return unwrappedProps;
}
},{"259":259,"271":271,"398":398,"399":399,"405":405,"74":74}],43:[function(_dereq_,module,exports){
'use strict';

var flatten = _dereq_(259);

var Collections = _dereq_(232);


function UpdateSemanticParentHandler() {
}

module.exports = UpdateSemanticParentHandler;


////// api /////////////////////////////////////////////

UpdateSemanticParentHandler.prototype.preExecute = function(context) {
  var element = context.element,
      shape = context.shape;

  if (!element) {
    throw new Error('element required');
  }

  var bo = element.businessObject || element;

  context.businessObject = bo;
  context.oldParent = bo.$parent;

  var changed = [];

  if (element.businessObject) {
    changed.push(element);
  }

  if (shape) {
    changed.push(shape);
  }

  context.changed = flatten(changed);
};

UpdateSemanticParentHandler.prototype.execute = function(context) {

  var businessObject = context.businessObject,
      newParent = context.newParent,
      containment = context.containment;

  this.updateSemanticParent(businessObject, newParent, containment);

  // indicate changed on objects affected by the update
  return context.changed;
};


UpdateSemanticParentHandler.prototype.revert = function(context) {

  var businessObject = context.businessObject,
      newParent = context.oldParent,
      containment = context.containment;

  this.updateSemanticParent(businessObject, newParent, containment);

  return context.changed;
};


UpdateSemanticParentHandler.prototype.updateSemanticParent = function(element, newParent, containment) {

  if (element.$parent === newParent) {
    return;
  }

  var children;

  if (element.$parent && containment) {
    // remove from old parent
    children = element.$parent.get(containment);
    Collections.remove(children, element);
  }

  element.$parent = null;

  if (newParent) {

    if (containment) {
      // add to new parent
      children = newParent.get(containment);
      children.push(element);
    }

    element.$parent = newParent;
  }

};

},{"232":232,"259":259}],44:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'modeling', 'cmmnUpdater' ],
  __depends__: [
    _dereq_(36),
    _dereq_(48),
    _dereq_(59),
    _dereq_(61),
    _dereq_(104),
    _dereq_(210),
    _dereq_(116),
    _dereq_(129)
  ],
  cmmnFactory: [ 'type', _dereq_(21) ],
  cmmnUpdater: [ 'type', _dereq_(23) ],
  elementFactory: [ 'type', _dereq_(24) ],
  modeling: [ 'type', _dereq_(25) ],
  layouter: [ 'type', _dereq_(22) ],
  connectionDocking: [ 'type', _dereq_(221) ]
};

},{"104":104,"116":116,"129":129,"21":21,"210":210,"22":22,"221":221,"23":23,"24":24,"25":25,"36":36,"48":48,"59":59,"61":61}],45:[function(_dereq_,module,exports){
'use strict';

var any = _dereq_(267);

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    getBusinessObject = ModelUtil.getBusinessObject;

var Model = _dereq_(224);

/**
 * Return true if given elements are the same.
 *
 * @param {Object} a
 * @param {Object} b
 *
 * @return {boolean}
 */
function isSame(a, b) {
  return a === b;
}

module.exports.isSame = isSame;


/**
 * Return true if given cases are the same.
 *
 * @param {ModdleElement} a
 * @param {ModdleElement} b
 *
 * @return {boolean}
 */
function isSameCase(a, b) {
  return isSame(getCase(a), getCase(b));
}

module.exports.isSameCase = isSameCase;

function getCase(element) {
  return getParent(getBusinessObject(element), 'cmmn:Case');
}

module.exports.getCase = getCase;


/**
 * Return the parents of the element with any of the given types.
 *
 * @param {ModdleElement} element
 * @param {String|Array<String>} anyType
 *
 * @return {Array<ModdleElement>}
 */
function getParents(element, anyType) {

  var parents = [];

  if (typeof anyType === 'string') {
    anyType = [ anyType ];
  }

  while (element) {
    element = element.$parent || element.parent;

    if (element) {

      if (anyType) {
        if (isAny(element, anyType)) {
          parents.push(element);
        }
      }
      else {
        parents.push(element);
      }

    }

  }

  return parents;
}

module.exports.getParents = getParents;

/**
 * Return the parent of the element with any of the given types.
 *
 * @param {ModdleElement} element
 * @param {String|Array<String>} anyType
 *
 * @return {ModdleElement}
 */
function getParent(element, anyType) {

  if (typeof anyType === 'string') {
    anyType = [ anyType ];
  }

  while ((element = element.$parent || element.parent)) {
    if (anyType) {
      if (isAny(element, anyType)) {
        return element;
      }
    }
    else {
      return element;
    }
  }

  return null;
}

module.exports.getParent = getParent;


/**
 * Return true if element has any of the given types.
 *
 * @param {djs.model.Base} element
 * @param {Array<String>} types
 *
 * @return {Boolean}
 */
function isAny(element, types) {
  return any(types, function(t) {
    return is(element, t);
  });
}

module.exports.isAny = isAny;


function isLabel(element) {
  return element instanceof Model.Label;
}

module.exports.isLabel = isLabel;
},{"224":224,"267":267,"74":74}],46:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var isAny = _dereq_(45).isAny,
    getParent = _dereq_(45).getParent;

var eachElement = _dereq_(235).eachElement;


/**
 * Returns all contained discretionary items.
 *
 * @param {ModdleElement} element
 *
 * @return {Array<ModdleElement>} all discretionary items
 */
function getAllDiscretionaryItems(element) {

  element = getBusinessObject(element);

  if (isItemCapable(element)) {
    element = getDefinition(element);
  }

  var result = [];

  if (isPlanningTableCapable(element)) {
    element = element.planningTable;

    if (element) {

      var items = element.get('tableItems');
      eachElement(items, function(item) {
        if (isDiscretionaryItem(item)) {
          result.push(item);
        }
        else {
          return item.get('tableItems');
        }
      });
    }
  }

  return result;
}

module.exports.getAllDiscretionaryItems = getAllDiscretionaryItems;


/**
 * Returns all directed item capables elements of the given element.
 *
 * @param {ModdleElement} element
 *
 * @return {Array<ModdleElement>} all direct item capables
 */
function getDirectItemCapables(element) {

  element = getBusinessObject(element);

  if (isItemCapable(element)) {
    element = getDefinition(element);
  }

  var result = [];

  function add(item) {
    result.push(item);
  }

  if (element) {

    var items;

    if (is(element, 'cmmn:PlanFragment')) {
      items = element.get('planItems');
      eachElement(items, add);
    }

    if (isPlanningTableCapable(element)) {
      items = getAllDiscretionaryItems(element);
      eachElement(items, add);
    }

  }

  return result;
}

module.exports.getDirectItemCapables = getDirectItemCapables;


/**
 * Returns true if the given element is either a discretionary item
 * or a plan item
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a discretionary item or a plan item
 */
function isItemCapable(element) {
  return isAny(element, [ 'cmmn:DiscretionaryItem', 'cmmn:PlanItem' ]);
}

module.exports.isItemCapable = isItemCapable;


/**
 * Returns true if the given element is either a human task or
 * a stage.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a human task or stage
 */
function isPlanningTableCapable(element) {
  return isAny(element, [ 'cmmn:HumanTask', 'cmmn:Stage' ]);
}

module.exports.isPlanningTableCapable = isPlanningTableCapable;


/**
 * Returns true if the given element is a discretionary item.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a discretionary item
 */
function isDiscretionaryItem(element) {
  return is(element, 'cmmn:DiscretionaryItem');
}

module.exports.isDiscretionaryItem = isDiscretionaryItem;


/**
 * Returns true if the given element is a discretionary to a human task.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is discretionary to a human task
 */
function isDiscretionaryToHumanTask(element) {
  var bo = getBusinessObject(element);
  var parent = getParent(bo, 'cmmn:PlanItemDefinition');
  return is(parent, 'cmmn:HumanTask');
}

module.exports.isDiscretionaryToHumanTask = isDiscretionaryToHumanTask;


/**
 * Returns true if the given element is a human task.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a human task
 */
function isHumanTask(element) {
  return is(element, 'cmmn:HumanTask');
}

module.exports.isHumanTask = isHumanTask;


/**
 * Returns true if the given element is a plan fragment and not
 * a stage.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a plan fragment
 */
function isPlanFragment(element) {
  return is(element, 'cmmn:PlanFragment') && !is(element, 'cmmn:Stage');
}

module.exports.isPlanFragment = isPlanFragment;

},{"235":235,"45":45,"74":74}],47:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var OrderingProvider = _dereq_(186);
var findIndex = _dereq_(258);
var find = _dereq_(270);
var is = _dereq_(74).is;
var isAny = _dereq_(45).isAny;

function CmmnOrderingProvider(eventBus) {

  OrderingProvider.call(this, eventBus);

  var orders = [
    { type: 'label', order: { level: 10 } },
    { type: 'cmmn:Criterion', order: { level: 6 } },
    {
      type: 'cmmn:OnPart',
      order: {
        level: 9,
        containers: [
          'cmmn:Stage'
        ]
      }
    },
    {
      type: 'cmmn:Association',
      order: {
        level: 9,
        containers: [
          'cmmndi:CMMNDiagram'
        ]
      }
    },
    {
      type: 'cmmndi:CMMNEdge',
      order: {
        level: 9,
        containers: [
          'cmmn:PlanItem',
          'cmmn:DiscretionaryItem',
          'cmmn:Stage'
        ]
      }
    }
  ];

  function computeOrder(element) {

    if (isCMMNEdge(element)) {
      element = element.businessObject.cmmnElementRef || element;
    }

    var entry = find(orders, function(o) {
      return is(element, o.type);
    });

    return entry && entry.order || { level: 1 };
  }

  function getOrder(element) {

    var order = element.order;

    if (!order) {
      element.order = order = computeOrder(element);
    }

    return order;
  }

  function findActualParent(element, newParent, containers) {

    var actualParent = newParent;

    if (isCMMNEdge(element) && element.source) {
      actualParent = element.source.parent;
    }

    while (actualParent) {

      if (isAny(actualParent, containers)) {
        break;
      }

      actualParent = actualParent.parent;
    }

    if (!actualParent) {
      throw new Error('no parent for ' + element.id + ' in ' + newParent.id);
    }

    return actualParent;
  }

  this.getOrdering = function(element, newParent) {

    var elementOrder = getOrder(element);

    if (elementOrder.containers) {
      newParent = findActualParent(element, newParent, elementOrder.containers);
    }

    var currentIndex = newParent.children.indexOf(element);

    var insertIndex = findIndex(newParent.children, function(child) {

      // do not compare with labels, they are created
      // in the wrong order (right after elements) during import and
      // mess up the positioning.
      if (!element.labelTarget && child.labelTarget) {
        return false;
      }

      return elementOrder.level < getOrder(child).level;
    });


    // if the element is already in the child list at
    // a smaller index, we need to adjust the insert index.
    // this takes into account that the element is being removed
    // before being re-inserted
    if (insertIndex !== -1) {
      if (currentIndex !== -1 && currentIndex < insertIndex) {
        insertIndex -= 1;
      }
    }

    return {
      index: insertIndex,
      parent: newParent
    };

  };
}

CmmnOrderingProvider.$inject = [ 'eventBus' ];

inherits(CmmnOrderingProvider, OrderingProvider);

module.exports = CmmnOrderingProvider;

function isCMMNEdge(element) {
  return is(element, 'cmmndi:CMMNEdge');
}
},{"186":186,"257":257,"258":258,"270":270,"45":45,"74":74}],48:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'cmmnOrderingProvider' ],
  cmmnOrderingProvider: [ 'type', _dereq_(47) ]
};
},{"47":47}],49:[function(_dereq_,module,exports){
'use strict';

var BaseOutline = _dereq_(187);

var inherits = _dereq_(257);

var isCasePlanModel = _dereq_(74).isCasePlanModel;

/**
 * This is a subclass of the Outline module from diagram-js.
 * It defines outlines which differ from the element size basis.
 *
 * @param {EventBus} eventBus
 * @param {Styles} styles
 * @param {ElementRegistry} elementRegistry
 */
function Outline(eventBus, styles, elementRegistry) {
  BaseOutline.call(this, eventBus, styles, elementRegistry);
}

inherits(Outline, BaseOutline);

Outline.$inject = [ 'eventBus', 'styles', 'elementRegistry' ];

Outline.prototype.baseUpdateShapeOutline = BaseOutline.prototype.updateShapeOutline;

Outline.prototype.updateShapeOutline = function(outline, element) {

  if (!isCasePlanModel(element)) {

    this.baseUpdateShapeOutline(outline, element);
  } else {

    // update outlines for casePlanModels
    outline.attr({
      x: -this.offset,
      y: -this.offset - 18,
      width: element.width + this.offset * 2,
      height: element.height + 18 + this.offset * 2
    });
  }
};

module.exports = Outline;
},{"187":187,"257":257,"74":74}],50:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: [ 'outline' ],
  outline: [ 'type', _dereq_(49) ]
};

},{"49":49}],51:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398);

/**
 * A palette provider for CMMN 1.1 elements.
 */
function PaletteProvider(
  create,
  elementFactory,
  globalConnect,
  handTool,
  lassoTool,
  palette,
  spaceTool
) {

  this._create = create;
  this._elementFactory = elementFactory;
  this._globalConnect = globalConnect;
  this._handTool = handTool;
  this._palette = palette;
  this._lassoTool = lassoTool;
  this._spaceTool = spaceTool;

  palette.registerProvider(this);
}

module.exports = PaletteProvider;

PaletteProvider.$inject = [
  'create',
  'elementFactory',
  'globalConnect',
  'handTool',
  'lassoTool',
  'palette',
  'spaceTool'
];


PaletteProvider.prototype.getPaletteEntries = function(element) {

  var actions  = {},
      create = this._create,
      elementFactory = this._elementFactory,
      spaceTool = this._spaceTool,
      lassoTool = this._lassoTool,
      globalConnect = this._globalConnect,
      handTool = this._handTool;

  function createPlanItem(type, group, className, title) {

    function createListener(event) {
      create.start(event, elementFactory.createPlanItemShape(type));
    }

    var shortType = type.replace(/^cmmn\:/, '');

    return {
      group: group,
      className: className,
      title: title || 'Create ' + shortType,
      action: {
        dragstart: createListener,
        click: createListener
      }
    };
  }

  function createCasePlanModel(event) {
    create.start(event, elementFactory.createCasePlanModelShape());
  }

  function createCriterion(event) {
    create.start(event, elementFactory.createCriterionShape('cmmn:EntryCriterion'));
  }

  function createCaseFileItem(event) {
    create.start(event, elementFactory.createCaseFileItemShape());
  }

  assign(actions, {
    'hand-tool': {
      group: 'tools',
      className: 'cmmn-icon-hand-tool',
      title: 'Activate the hand tool',
      action: {
        click: function(event) {
          handTool.activateHand(event);
        }
      }
    },
    'lasso-tool': {
      group: 'tools',
      className: 'cmmn-icon-lasso-tool',
      title: 'Activate the lasso tool',
      action: {
        click: function(event) {
          lassoTool.activateSelection(event);
        }
      }
    },
    'space-tool': {
      group: 'tools',
      className: 'cmmn-icon-space-tool',
      title: 'Activate the create/remove space tool',
      action: {
        click: function(event) {
          spaceTool.activateSelection(event);
        }
      }
    },
    'global-connect-tool': {
      group: 'tools',
      className: 'cmmn-icon-connection',
      title: 'Activate the global connect tool',
      action: {
        click: function(event) {
          globalConnect.toggle(event);
        }
      }
    },
    'tool-separator': {
      group: 'tools',
      separator: true
    },
    'create.task': createPlanItem(
      'cmmn:Task', 'planItem', 'cmmn-icon-task'
    ),
    'create.stage': createPlanItem(
      'cmmn:Stage', 'planItem', 'cmmn-icon-stage-expanded', 'Create expanded Stage'
    ),
    'create.milestone': createPlanItem(
      'cmmn:Milestone', 'planItem', 'cmmn-icon-milestone'
    ),
    'create.eventListener': createPlanItem(
      'cmmn:EventListener', 'planItem', 'cmmn-icon-event-listener'
    ),
    'create.criterion': {
      group: 'criterion',
      className: 'cmmn-icon-entry-criterion',
      title: 'Create Criterion',
      action: {
        dragstart: createCriterion,
        click: createCriterion
      }
    },
    'create.casePlanModel': {
      group: 'casePlanModel',
      className: 'cmmn-icon-case-plan-model',
      title: 'Create CasePlanModel',
      action: {
        dragstart: createCasePlanModel,
        click: createCasePlanModel
      }
    },
    'create.caseFileItem': {
      group: 'caseFileItem',
      className: 'cmmn-icon-case-file-item',
      title: 'Create Case File Item',
      action: {
        dragstart: createCaseFileItem,
        click: createCaseFileItem
      }
    }

  });

  return actions;
};
},{"398":398}],52:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(192),
    _dereq_(139),
    _dereq_(217),
    _dereq_(156),
    _dereq_(148),
    _dereq_(14)
  ],
  __init__: [ 'paletteProvider' ],
  paletteProvider: [ 'type', _dereq_(51) ]
};

},{"139":139,"14":14,"148":148,"156":156,"192":192,"217":217,"51":51}],53:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    filter = _dereq_(269);

var replaceOptions = _dereq_(58);

var isItemCapable = _dereq_(46).isItemCapable;

var isAny = _dereq_(45).isAny;

var ModelUtil = _dereq_(74),
    getBusinessObject = ModelUtil.getBusinessObject,
    getDefinition = ModelUtil.getDefinition,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    isRequired = ModelUtil.isRequired,
    isRepeatable = ModelUtil.isRepeatable,
    isManualActivation = ModelUtil.isManualActivation,
    is = ModelUtil.is;

var isCollapsed = _dereq_(72).isCollapsed;


/**
 * Returns true, if an element is from a different type.
 * discretionary / non discretionary
 *
 * @param {djs.model.Base} element
 * @param {Object} entry
 *
 * @return {Boolean}
 */
function isDifferentType(element, entry) {

  var businessObject = getBusinessObject(element);

  return businessObject.$type !== entry.target.type;
}


/**
 * Returns true if the definition type is different.
 * e.g. process task / human task
 *
 * @param {djs.model.Base} element
 * @param {Object} entry
 *
 * @return {Boolean}
 */
function isDifferentDefinitionType(element, entry) {

  return getDefinition(element).$type !== entry.target.definitionType;
}


function canReplaceElementByTarget(element, target) {

  var type = target.type,
      definitionType = target.definitionType,
      parent = element.parent,
      definition = getDefinition(element);

  if (isPlanItem(element)) {
    if (type === 'cmmn:DiscretionaryItem' && !isStage(parent)) {
      return false;
    }
  }

  if (definitionType === 'cmmn:HumanTask') {

    if (isPlanFragment(element) && !target.isBlocking) {
      return false;
    }

    if (isTask(element) && definition.isBlocking !== target.isBlocking) {
      return false;
    }

  }

  return true;

}


/**
 * This module is an element agnostic replace menu provider for the popup menu.
 */
function ReplaceMenuProvider(popupMenu, cmmnReplace, cmmnFactory, modeling, rules) {

  this._popupMenu = popupMenu;
  this._cmmnReplace = cmmnReplace;
  this._cmmnFactory = cmmnFactory;
  this._modeling = modeling;
  this._rules = rules;

  this.register();
}

ReplaceMenuProvider.$inject = [ 'popupMenu', 'cmmnReplace', 'cmmnFactory', 'modeling', 'rules' ];


/**
 * Register replace menu provider in the popup menu
 */
ReplaceMenuProvider.prototype.register = function() {
  this._popupMenu.registerProvider('cmmn-replace', this);
};


/**
 * Get all entries from replaceOptions for the given element and apply filters
 * on them. Get for example only elements, which are different from the current one.
 *
 * @param {djs.model.Base} element
 *
 * @return {Array<Object>} a list of menu entry items
 */
ReplaceMenuProvider.prototype.getEntries = function(element) {

  var rules = this._rules;

  var entries,
      definition = getDefinition(element);


  if (!rules.allowed('shape.replace', { element: element })) {
    return [];
  }


  if (isItemCapable(element)) {

    if (isTask(element)) {

      entries = filter(replaceOptions.TASK, function(entry) {

        var target = entry.target;

        if (canReplaceElementByTarget(element, target)) {

          // ^ === XOR
          // returns true if and only of EITHER the type OR the definition type is different
          return isDifferentType(element, entry) ^ isDifferentDefinitionType(element, entry);
        }
      });

      return this._createEntries(element, entries);
    }

    if (isPlanFragment(element)) {

      if (!isCollapsed(element)) {

        entries = filter(replaceOptions.PLAN_FRAGMENT_EXPANDED, function(entry) {

          var target = entry.target;

          if (canReplaceElementByTarget(element, target)) {

            // returns true if the type or the definition type is different (or both)
            return isDifferentType(element, entry) || isDifferentDefinitionType(element, entry);
          }
        });

        return this._createEntries(element, entries);
      }

      if (isCollapsed(element)) {

        entries = filter(replaceOptions.TASK, function(entry) {

          var target = entry.target,
              definitionType = target.definitionType;

          if (!canReplaceElementByTarget(element, target)) {
            return false;
          }

          if (definitionType === definition.$type && !target.isCollapsed) {
            return true;
          }

          // ^ === XOR
          // returns true if and only of EITHER the type OR the definition type is different
          return isDifferentType(element, entry) ^ isDifferentDefinitionType(element, entry);

        });

        return this._createEntries(element, entries);

      }

    }

    if (isEventListener(element)) {

      entries = filter(replaceOptions.EVENT_LISTENER, function(entry) {
        return isDifferentDefinitionType(element, entry);
      });

      return this._createEntries(element, entries);
    }

  }


  if (isCriterion(element)) {

    entries = filter(replaceOptions.CRITERION, function(entry) {
      return isDifferentType(element, entry);
    });

    return this._createEntries(element, entries);
  }

  return [];

};


ReplaceMenuProvider.prototype.getHeaderEntries = function(element) {

  var headerEntries = [];

  if (isTask(element)) {
    headerEntries = headerEntries.concat(this._getBlockingEntry(element));
  }

  if (isStage(element)) {
    headerEntries = headerEntries.concat(this._getAutoCompleteEntry(element));
  }

  if (ensureSupportRules(element)) {
    headerEntries = headerEntries.concat(this._getRuleEntries(element));
  }

  return headerEntries;

};

/**
 * Creates an array of menu entry objects for a given element and filters the replaceOptions
 * according to a filter function.
 *
 * @param  {djs.model.Base} element
 * @param  {Object} replaceOptions
 *
 * @return {Array<Object>} a list of menu items
 */
ReplaceMenuProvider.prototype._createEntries = function(element, replaceOptions) {
  var menuEntries = [];

  var self = this;

  forEach(replaceOptions, function(definition) {
    var entry = self._createMenuEntry(definition, element);

    menuEntries.push(entry);
  });

  return menuEntries;
};


/**
 * Creates and returns a single menu entry item.
 *
 * @param  {Object} definition a single replace options definition object
 * @param  {djs.model.Base} element
 * @param  {Function} [action] an action callback function which gets called when
 *                             the menu entry is being triggered.
 *
 * @return {Object} menu entry item
 */
ReplaceMenuProvider.prototype._createMenuEntry = function(definition, element, action) {

  var replaceElement = this._cmmnReplace.replaceElement;

  var replaceAction = function() {
    return replaceElement(element, definition.target);
  };

  action = action || replaceAction;

  var menuEntry = {
    label: definition.label,
    className: definition.className,
    id: definition.actionName,
    action: action
  };

  return menuEntry;
};


ReplaceMenuProvider.prototype._getBlockingEntry = function(element) {

  var self = this;

  var definition = getDefinition(element);

  function toggleBlockingEntry(event, entry) {
    var blocking = !entry.active;
    self._modeling.updateControls(element, { isBlocking: blocking });
  }

  var isBlocking = definition.isBlocking;
  var entries = [
    {
      id: 'toggle-is-blocking',
      className: 'cmmn-icon-blocking',
      title: 'Blocking',
      active: isBlocking,
      action: toggleBlockingEntry
    }
  ];

  return entries;
};


ReplaceMenuProvider.prototype._getAutoCompleteEntry = function(element) {

  var self = this;

  var definition = getDefinition(element);

  function toggleAutoCompleteEntry(event, entry) {
    var autoComplete = !entry.active;
    self._modeling.updateControls(element, { autoComplete: autoComplete });
  }

  var isAutoComplete = definition.autoComplete;
  var entries = [
    {
      id: 'toggle-auto-complete',
      className: 'cmmn-icon-auto-complete-marker',
      title: 'Auto Complete',
      active: isAutoComplete,
      action: toggleAutoCompleteEntry
    }
  ];

  return entries;
};


ReplaceMenuProvider.prototype._getRuleEntries = function(element) {

  var self = this;

  function toggleControlEntry(control, type) {

    return function(event, entry) {

      var value = {};

      if (entry.active) {
        value[control] = undefined;
      }
      else {
        value[control] = self._cmmnFactory.create(type);
      }

      self._modeling.updateControls(element, value);
    };

  }

  var repeatable = isRepeatable(element),
      required = isRequired(element),
      manualActivation = isManualActivation(element);

  var entries = [
    {
      id: 'toggle-required-rule',
      className: 'cmmn-icon-required-marker',
      title: 'Required Rule',
      active: required,
      action: toggleControlEntry('requiredRule', 'cmmn:RequiredRule')
    }
  ];

  if (!isMilestone(element)) {

    entries.push({
      id: 'toggle-manual-activation-rule',
      className: 'cmmn-icon-manual-activation-marker',
      title: 'Manual Activation Rule',
      active: manualActivation,
      action: toggleControlEntry('manualActivationRule', 'cmmn:ManualActivationRule')
    });

  }

  entries.push({
    id: 'toggle-repetition-rule',
    className: 'cmmn-icon-repetition-marker',
    title: 'Repetition Rule',
    active: repeatable,
    action: toggleControlEntry('repetitionRule', 'cmmn:RepetitionRule')
  });

  return entries;
};

module.exports = ReplaceMenuProvider;


function ensureSupportRules(element) {

  var definition = getDefinition(element);

  return !isCasePlanModel(element) && isAny(definition, [
    'cmmn:Stage',
    'cmmn:Milestone',
    'cmmn:Task'
  ]);
}

function isPlanFragment(element) {
  return is(getDefinition(element), 'cmmn:PlanFragment');
}

function isStage(element) {
  return is(getDefinition(element), 'cmmn:Stage');
}

function isEventListener(element) {
  return is(getDefinition(element), 'cmmn:EventListener');
}

function isMilestone(element) {
  return is(getDefinition(element), 'cmmn:Milestone');
}

function isTask(element) {
  return is(getDefinition(element), 'cmmn:Task');
}

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function isPlanItem(element) {
  return is(element, 'cmmn:PlanItem');
}

},{"269":269,"271":271,"45":45,"46":46,"58":58,"72":72,"74":74}],54:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'replaceMenuProvider' ],
  replaceMenuProvider: [ 'type', _dereq_(53) ]
};
},{"53":53}],55:[function(_dereq_,module,exports){
'use strict';

var CommandInterceptor = _dereq_(102);

var inherits = _dereq_(257);

var assign = _dereq_(398),
    forEach = _dereq_(271);

var getVisual = _dereq_(238).getVisual;

var isItemCapable = _dereq_(46).isItemCapable;

var ModelUtil = _dereq_(74),
    getBusinessObject = ModelUtil.getBusinessObject,
    getDefinition = ModelUtil.getDefinition;

var LOW_PRIORITY = 250;

function CmmnReplacePreview(
  cmmnReplace,
  cmmnRules,
  elementFactory,
  elementRegistry,
  eventBus,
  graphicsFactory
) {

  CommandInterceptor.call(this, eventBus);


  function createShape(element, replacement) {

    var newElement = {
      type: replacement.newElementType,
      x: element.x,
      y: element.y,
      width: element.width,
      height: element.height
    };

    if (isItemCapable(element)) {

      var bo = getBusinessObject(element),
          definition = getDefinition(element),
          newElementType = replacement.newElementType,
          newDefinitionType = replacement.newDefinitionType,
          replaceCandidate;

      if (newDefinitionType) {
        definition = cmmnReplace.replacePlanItemDefinition(definition, newDefinitionType);
      }

      replaceCandidate = cmmnReplace.replaceItemCapable(bo, newElementType, definition);

      assign(newElement, {
        businessObject: replaceCandidate
      });
    }

    return elementFactory.createShape(newElement);
  }


  function initVisualReplacements(context) {
    if (!context.visualReplacements) {
      context.visualReplacements = {};
    }
    return context.visualReplacements;
  }


  function canReplace(event) {
    var context = event.context,
        canExecute = context.canExecute || context.allowed;

    if (canExecute === 'attach') {
      var position = context.position || { x: event.x, y: event.y },
          shapes = context.shapes || [ context.shape ],
          target = context.target;

      canExecute = cmmnRules.canReplace(shapes, target, position, context.source);
    }


    return canExecute;
  }


  /**
   * Replace the visuals to the given shape
   */
  function replaceVisualGraphics(gfx, shape) {

    var visual = gfx && getVisual(gfx);

    if (visual) {
      visual.remove();
      visual = gfx.group().addClass('djs-visual');
      graphicsFactory.drawShape(visual, shape);
    }

  }


  function replaceVisual(context, replacements, gfxSelector) {

    forEach(replacements, function(replacement) {

      var id = replacement.oldElementId,
          shape = elementRegistry.get(id) || context.shape;

      // if the visual of the element is already replaced
      if (context.visualReplacements[id]) {
        return;
      }

      // create a temporary shape
      var tempShape = createShape(shape, replacement);

      // select the original SVG element related to the element and hide it
      var gfx = gfxSelector(shape);

      replaceVisualGraphics(gfx, tempShape);
      context.visualReplacements[id] = shape;

    });

  }

  function restoreVisual(context, gfxSelector) {

    var visualReplacements = context.visualReplacements;

    forEach(visualReplacements, function(shape, id) {

      var gfx = gfxSelector(shape);
      replaceVisualGraphics(gfx, shape);

      delete visualReplacements[id];

    });
  }


  eventBus.on([ 'shape.move.move', 'create.move' ], LOW_PRIORITY, function(event) {

    var context = event.context,
        dragGroup = context.dragGroup,
        visual = context.visual,
        canExecute = canReplace(event),
        replacements = canExecute && canExecute.replacements;

    initVisualReplacements(context);

    var getGfx = function(shape) {
      var selector,
          gfx;

      if (dragGroup) {
        selector = '[data-element-id=' + shape.id + ']';
        gfx = dragGroup;
      }
      else if (visual) {
        selector = '.djs-dragger';
        gfx = visual;
      }

      return gfx && gfx.select(selector);
    };

    if (replacements && replacements.length) {
      replaceVisual(context, replacements, getGfx);
    }
    else {
      restoreVisual(context, getGfx);
    }

  });


  eventBus.on([
    'bendpoint.move.move',
    'connect.move'
  ], LOW_PRIORITY, function(event) {

    var context = event.context,
        canExecute = canReplace(event),
        replacements = canExecute && canExecute.replacements;

    initVisualReplacements(context);

    if (replacements && replacements.length) {
      replaceVisual(context, replacements, function(shape) {
        return elementRegistry.getGraphics(shape);
      });
    }

  });


  eventBus.on([
    'bendpoint.move.cancel',
    'bendpoint.move.cleanup',
    'bendpoint.move.end',
    'bendpoint.move.out',
    'connect.cleanup',
    'connect.end',
    'connect.out'
  ], LOW_PRIORITY, function(event) {

    var context = event.context;

    restoreVisual(context, function(shape) {
      return elementRegistry.getGraphics(shape);
    });

  });

}

CmmnReplacePreview.$inject = [
  'cmmnReplace',
  'cmmnRules',
  'elementFactory',
  'elementRegistry',
  'eventBus',
  'graphicsFactory'
];

inherits(CmmnReplacePreview, CommandInterceptor);

module.exports = CmmnReplacePreview;
},{"102":102,"238":238,"257":257,"271":271,"398":398,"46":46,"74":74}],56:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [ _dereq_(185) ],
  __init__: ['cmmnReplacePreview'],
  cmmnReplacePreview: [ 'type', _dereq_(55) ]
};

},{"185":185,"55":55}],57:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    isAutoComplete = ModelUtil.isAutoComplete;

var isCollapsed = _dereq_(72).isCollapsed,
    isPlanningTableCollapsed = _dereq_(72).isPlanningTableCollapsed;

var isPlanningTableCapable = _dereq_(46).isPlanningTableCapable;
var isItemCapable = _dereq_(46).isItemCapable;

/**
 * This module takes care of replacing CMMN elements
 */
function CmmnReplace(cmmnFactory, replace, selection, cmmnRules) {

  /**
   * Prepares a new business object for the replacement element
   * and triggers the replace operation.
   *
   * @param  {djs.model.Base} element
   * @param  {Object} target
   * @param  {Object} [hints]
   *
   * @return {djs.model.Base} the newly created element
   */
  function replaceElement(element, target, hints) {

    hints = hints || {};

    var type = target.type,
        oldBusinessObject = element.businessObject,
        newBusinessObject;


    // TODO: need also to respect min/max Size
    var newElement = {
      type: type
    };

    if (isCriterion(oldBusinessObject)) {
      newBusinessObject = replaceCriterion(oldBusinessObject, type);
    }


    if (isItemCapable(oldBusinessObject)) {

      var oldDefinition = getDefinition(oldBusinessObject),
          definitionType = target.definitionType,
          newDefinition = oldDefinition;


      // replace plan item definition if necessary
      if (oldDefinition.$type !== definitionType) {
        newDefinition = replacePlanItemDefinition(oldDefinition, definitionType);
      }
      

      // replace plan/discretionary item
      newBusinessObject = replaceItemCapable(oldBusinessObject, type, newDefinition);


      // handle isCollapsed property
      if (isPlanFragment(oldDefinition) && isPlanFragment(newDefinition) && target.isCollapsed !== false) {
        newElement.isCollapsed = isCollapsed(oldBusinessObject);
      }


      // switch collapsed/expanded plan fragment
      if (isTask(oldDefinition) && target.isCollapsed === true) {
        newElement.isCollapsed = true;
      }

      if (isTask(newDefinition) && target.isBlocking === false) {
        newElement.isBlocking = false;
      }


      // handle isPlanningTableCollapsed property
      if (isPlanningTableCapable(oldDefinition) && isPlanningTableCapable(newDefinition)) {
        newElement.isPlanningTableCollapsed = isPlanningTableCollapsed(oldBusinessObject);
      }


      // handle autoComplete property
      if (isStage(oldDefinition) && isStage(newDefinition)) {
        newElement.autoComplete = isAutoComplete(oldBusinessObject);
      }


      // TODO: need also to respect min/max Size
      // copy size, from an expanded plan fragment to an expanded alternative plan fragment
      // except cmmn:Task, because Task is always expanded
      if (!isCollapsed(oldBusinessObject) && !target.isCollapsed &&  !isTask(oldDefinition)) {
        newElement.width = element.width;
        newElement.height = element.height;
      }
    }

    // create new business object if necessary
    newElement.businessObject = newBusinessObject || cmmnFactory.create(type);

    // trigger replacement
    newElement = replace.replaceElement(element, newElement, hints);


    if (hints.select !== false) {
      selection.select(newElement);
    }

    return newElement;
  }

  this.replaceElement = replaceElement;


  function replaceCriterion(criterion, type) {

    var newCriterion;

    if (criterion) {

      type = type || criterion.$type;

      newCriterion = cmmnFactory.createCriterion(type, {
        sentryRef: criterion.sentryRef,
        name: criterion.name
      });

    }

    return newCriterion;

  }

  this.replaceCriterion = replaceCriterion;


  function replaceSentry(sentry) {

    var newSentry;

    if (sentry) {

      newSentry = cmmnFactory.createSentry({
        name: sentry.name
      });

      if (sentry.ifPart) {

        var newIfPart = cmmnFactory.create('cmmn:IfPart');
        setParent(newIfPart, newSentry);
        newSentry.ifPart = newIfPart;

        var condition = replaceCondition(sentry.ifPart.condition);
        setParent(condition, newIfPart);
        newIfPart.condition = condition;

      }

    }

    return newSentry;
  }

  this.replaceSentry = replaceSentry;


  function replacePlanItemDefinition(definition, type) {

    type = type || definition.$type;

    var newDefinition = cmmnFactory.create(type, {
      name: definition.name
    });

    if (isPlanItemControlCapable(newDefinition) && definition.defaultControl) {
      
      var defaultControl = replacePlanItemControl(definition.defaultControl, newDefinition);

      setParent(defaultControl, newDefinition);
      newDefinition.defaultControl = defaultControl;

    }

    if (isStage(newDefinition) && definition.autoComplete) {
      newDefinition.autoComplete = definition.autoComplete;
    }

    if (isTask(definition) && isTask(newDefinition)) {
      newDefinition.isBlocking = definition.isBlocking;
    }

    return newDefinition;

  }

  this.replacePlanItemDefinition = replacePlanItemDefinition;


  function replaceItemCapable(item, type, definition) {

    type = type || item.$type;
    definition = definition || getDefinition(item);

    var newItem = cmmnFactory.create(type, {
      name: item.name,
      definitionRef: definition
    });

    if (isPlanItemControlCapable(newItem) && item.itemControl) {
      
      var itemControl = replacePlanItemControl(item.itemControl, newItem);

      setParent(itemControl, newItem);
      newItem.itemControl = itemControl;

    }

    return newItem;

  }

  this.replaceItemCapable = replaceItemCapable;


  function replacePlanItemControl(control, element) {

    var newControl;

    if (control) {

      newControl = cmmnFactory.create('cmmn:PlanItemControl');

      var repetitionRule = control.repetitionRule;
      if (repetitionRule && (!element || cmmnRules.canSetRepetitionRule(element))) {

        repetitionRule = replaceRule(repetitionRule);

        setParent(repetitionRule, newControl);
        newControl.repetitionRule = repetitionRule;

      }

      var requiredRule = control.requiredRule;
      if (requiredRule && (!element || cmmnRules.canSetRequiredRule(element))) {

        requiredRule = replaceRule(requiredRule);

        setParent(requiredRule, newControl);
        newControl.requiredRule = requiredRule;

      }

      var manualActivationRule = control.manualActivationRule;
      if (manualActivationRule && (!element || cmmnRules.canSetManualActivationRule(element))) {

        manualActivationRule = replaceRule(manualActivationRule);

        setParent(manualActivationRule, newControl);
        newControl.manualActivationRule = manualActivationRule;

      }
      
    }

    return newControl;

  }

  this.replacePlanItemControl = replacePlanItemControl;


  function replaceRule(rule) {

    var newRule;

    if (rule) {

      var type = rule.$type;

      var condition = replaceCondition(rule.condition);
      newRule = cmmnFactory.create(type, {
        condition: condition
      });

      setParent(condition, newRule);

    }

    return newRule;

  }

  this.replaceRule = replaceRule;


  function replaceCondition(condition) {
    var newCondition;

    if (condition) {
      newCondition = cmmnFactory.create('cmmn:Expression', {
        language: condition.language,
        body: condition.body
      });
    }

    return newCondition;
  }

  this.replaceCondition = replaceCondition;


  function setParent(element, parent) {
    if (element) {
      element.$parent = parent;
    }
  }

}

CmmnReplace.$inject = [ 'cmmnFactory', 'replace', 'selection', 'cmmnRules' ];

module.exports = CmmnReplace;

function isInstanceOf(element, type) {
  element = getDefinition(element);
  return is(element, type);
}

function isTask(element) {
  return isInstanceOf(element, 'cmmn:Task');
}

function isMilestone(element) {
  return isInstanceOf(element, 'cmmn:Milestone');
}

function isPlanFragment(element) {
  return isInstanceOf(element, 'cmmn:PlanFragment');
}

function isStage(element) {
  return isInstanceOf(element, 'cmmn:Stage');
}

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function isPlanItemControlCapable(element) {
  return isTask(element) || isStage(element) || isMilestone(element);
}
},{"46":46,"72":72,"74":74}],58:[function(_dereq_,module,exports){
'use strict';


module.exports.TASK = [
  {
    label: 'Task',
    actionName: 'replace-with-task-plan-item',
    className: 'cmmn-icon-task-none',
    target: {
      definitionType: 'cmmn:Task',
      type: 'cmmn:PlanItem'
    }
  },
  {
    label: 'Human Task',
    actionName: 'replace-with-blocking-human-task-plan-item',
    className: 'cmmn-icon-human-blocking-task',
    target: {
      definitionType: 'cmmn:HumanTask',
      type: 'cmmn:PlanItem',
      isBlocking: true
    }
  },
  {
    label: 'Human Task',
    actionName: 'replace-with-non-blocking-human-task-plan-item',
    className: 'cmmn-icon-human-non-blocking-task',
    target: {
      definitionType: 'cmmn:HumanTask',
      type: 'cmmn:PlanItem',
      isBlocking: false
    }
  },
  {
    label: 'Decision Task',
    actionName: 'replace-with-decision-task-plan-item',
    className: 'cmmn-icon-decision-task',
    target: {
      definitionType: 'cmmn:DecisionTask',
      type: 'cmmn:PlanItem'
    }
  },
  {
    label: 'Process Task',
    actionName: 'replace-with-process-task-plan-item',
    className: 'cmmn-icon-process-task',
    target: {
      definitionType: 'cmmn:ProcessTask',
      type: 'cmmn:PlanItem'
    }
  },
  {
    label: 'Case Task',
    actionName: 'replace-with-case-task-plan-item',
    className: 'cmmn-icon-case-task',
    target: {
      definitionType: 'cmmn:CaseTask',
      type: 'cmmn:PlanItem'
    }
  },
  {
    label: 'Stage (collapsed)',
    actionName: 'replace-with-collapsed-stage-plan-item',
    className: 'cmmn-icon-stage-collapsed',
    target: {
      definitionType: 'cmmn:Stage',
      type: 'cmmn:PlanItem',
      isCollapsed: true
    }
  },
  {
    label: 'Stage (expanded)',
    actionName: 'replace-with-expanded-stage-plan-item',
    className: 'cmmn-icon-stage-expanded',
    target: {
      definitionType: 'cmmn:Stage',
      type: 'cmmn:PlanItem',
      isCollapsed: false
    }
  },
  {
    label: 'Discretionary Task',
    actionName: 'replace-with-task-discretionary-item',
    className: 'cmmn-icon-task-discretionary',
    target: {
      definitionType: 'cmmn:Task',
      type: 'cmmn:DiscretionaryItem'
    }
  },
  {
    label: 'Discretionary Human Task',
    actionName: 'replace-with-blocking-human-task-discretionary-item',
    className: 'cmmn-icon-human-blocking-task-discretionary',
    target: {
      definitionType: 'cmmn:HumanTask',
      type: 'cmmn:DiscretionaryItem',
      isBlocking: true
    }
  },
  {
    label: 'Discretionary Human Task',
    actionName: 'replace-with-non-blocking-human-task-discretionary-item',
    className: 'cmmn-icon-human-non-blocking-task-discretionary',
    target: {
      definitionType: 'cmmn:HumanTask',
      type: 'cmmn:DiscretionaryItem',
      isBlocking: false
    }
  },
  {
    label: 'Discretionary Decision Task',
    actionName: 'replace-with-decision-task-discretionary-item',
    className: 'cmmn-icon-decision-task-discretionary',
    target: {
      definitionType: 'cmmn:DecisionTask',
      type: 'cmmn:DiscretionaryItem'
    }
  },
  {
    label: 'Discretionary Process Task',
    actionName: 'replace-with-process-task-discretionary-item',
    className: 'cmmn-icon-process-task-discretionary',
    target: {
      definitionType: 'cmmn:ProcessTask',
      type: 'cmmn:DiscretionaryItem'
    }
  },
  {
    label: 'Discretionary Case Task',
    actionName: 'replace-with-case-task-discretionary-item',
    className: 'cmmn-icon-case-task-discretionary',
    target: {
      definitionType: 'cmmn:CaseTask',
      type: 'cmmn:DiscretionaryItem'
    }
  },
  {
    label: 'Discretionary Stage (collapsed)',
    actionName: 'replace-with-collapsed-stage-discretionary-item',
    className: 'cmmn-icon-stage-collapsed-discretionary',
    target: {
      definitionType: 'cmmn:Stage',
      type: 'cmmn:DiscretionaryItem',
      isCollapsed: true
    }
  },
  {
    label: 'Discretionary Stage (expanded)',
    actionName: 'replace-with-expanded-stage-discretionary-item',
    className: 'cmmn-icon-stage-expanded-discretionary',
    target: {
      definitionType: 'cmmn:Stage',
      type: 'cmmn:DiscretionaryItem',
      isCollapsed: false
    }
  }
];


module.exports.PLAN_FRAGMENT_EXPANDED = [
  {
    label: 'Stage',
    actionName: 'replace-with-stage-plan-item',
    className: 'cmmn-icon-stage-expanded',
    target: {
      definitionType: 'cmmn:Stage',
      type: 'cmmn:PlanItem',
      isCollapsed: false
    }
  },
  {
    label: 'Discretionary Stage',
    actionName: 'replace-with-stage-discretionary-item',
    className: 'cmmn-icon-stage-expanded-discretionary',
    target: {
      definitionType: 'cmmn:Stage',
      type: 'cmmn:DiscretionaryItem',
      isCollapsed: false
    }
  },
  {
    label: 'Discretionary Plan Fragment',
    actionName: 'replace-with-plan-fragment-discretionary-item',
    className: 'cmmn-icon-plan-fragment-expanded-discretionary',
    target: {
      definitionType: 'cmmn:PlanFragment',
      type: 'cmmn:DiscretionaryItem',
      isCollapsed: false
    }
  }
];

module.exports.EVENT_LISTENER = [
  {
    label: 'Event Listener',
    actionName: 'replace-with-event-listener-plan-item',
    className: 'cmmn-icon-event-listener',
    target: {
      definitionType: 'cmmn:EventListener',
      type: 'cmmn:PlanItem'
    }
  },
  {
    label: 'Timer Event Listener',
    actionName: 'replace-with-timer-event-listener-plan-item',
    className: 'cmmn-icon-timer-event-listener',
    target: {
      definitionType: 'cmmn:TimerEventListener',
      type: 'cmmn:PlanItem'
    }
  },
  {
    label: 'User Event Listener',
    actionName: 'replace-with-user-event-listener-plan-item',
    className: 'cmmn-icon-user-event-listener',
    target: {
      definitionType: 'cmmn:UserEventListener',
      type: 'cmmn:PlanItem'
    }
  }
];


module.exports.CRITERION = [
  {
    label: 'Entry Criterion',
    actionName: 'replace-with-entry-criterion',
    className: 'cmmn-icon-entry-criterion',
    target: {
      type: 'cmmn:EntryCriterion'
    }
  },
  {
    label: 'Exit Criterion',
    actionName: 'replace-with-exit-criterion',
    className: 'cmmn-icon-exit-criterion',
    target: {
      type: 'cmmn:ExitCriterion'
    }
  }
];
},{}],59:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(194),
    _dereq_(196),
    _dereq_(210)
  ],
  cmmnReplace: [ 'type', _dereq_(57) ]
};
},{"194":194,"196":196,"210":210,"57":57}],60:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var any = _dereq_(267);
var forEach = _dereq_(271);
var assign = _dereq_(398);

var ModelUtil = _dereq_(74),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var isCollapsed = _dereq_(72).isCollapsed;

var getParents = _dereq_(45).getParents;

var ModelingUtil = _dereq_(45),
    isSame = ModelingUtil.isSame,
    isSameCase = ModelingUtil.isSameCase,
    getParent = ModelingUtil.getParent;

var PlanItemDefinitionUtil = _dereq_(46),
    isDiscretionaryToHumanTask = PlanItemDefinitionUtil.isDiscretionaryToHumanTask,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask,
    isDiscretionaryItem = PlanItemDefinitionUtil.isDiscretionaryItem;

var isCriterionAttachment = _dereq_(65).getCriterionAttachment;

var RuleProvider = _dereq_(202);


/**
 * CMMN specific modeling rule
 */
function CmmnRules(eventBus) {
  RuleProvider.call(this, eventBus);
}

inherits(CmmnRules, RuleProvider);

CmmnRules.$inject = [ 'eventBus' ];

module.exports = CmmnRules;

CmmnRules.prototype.init = function() {

  var self = this;

  this.addRule('connection.create', function(context) {

    var source = context.source,
        target = context.target,
        allowed = false;

    allowed = self.canConnect(source, target) ||
              self.canReplaceConnectionEnd(source, target, 'target');

    if (!allowed) {

      allowed = self.canConnect(target, source) ||
                   self.canReplaceConnectionEnd(target, source, 'source');

      if (allowed) {
        assign(allowed, {
          reverse: true
        });
      }

    }

    return allowed;

  });

  this.addRule('connection.reconnectStart', function(context) {

    var connection = context.connection,
        hover = context.hover,
        source = hover || context.source,
        target = connection.target,
        allowed = false;

    allowed = self.canConnect(source, target, connection);

    if (!allowed && hover) {

      allowed = self.canReplaceConnectionEnd(hover, target, 'source');

      if (!allowed) {

        allowed = self.canConnect(target, hover, connection) ||
                  self.canReplaceConnectionEnd(target, hover, 'target');

        if (allowed) {
          assign(allowed, {
            reverse: true
          });
        }

      }

    }

    return allowed;

  });

  this.addRule('connection.reconnectEnd', function(context) {

    var connection = context.connection,
        source = connection.source,
        hover = context.hover,
        target = hover || context.target,
        allowed = false;

    allowed = self.canConnect(source, target, connection);

    if (!allowed && hover) {

      allowed = self.canReplaceConnectionEnd(source, hover, 'target');

      if (!allowed) {

        allowed = self.canConnect(hover, source, connection) ||
                  self.canReplaceConnectionEnd(hover, source, 'source');

        if (allowed) {
          assign(allowed, {
            reverse: true
          });
        }

      }

    }

    return allowed;

  });

  this.addRule([ 'shape.create', 'shape.append' ], function(context) {

    var target = context.target,
        shape = context.shape,
        source = context.source,
        position = context.position,
        shapes = [ shape ];

    return self.canAttach(shapes, target, source, position) ||
           self.canCreate(shape, target, source, position) ||
           self.canReplace(shapes, target, position, source);

  });

  this.addRule('shape.resize', function(context) {

    var shape = context.shape,
        newBounds = context.newBounds;

    return self.canResize(shape, newBounds);
  });

  this.addRule('elements.move', function(context) {
    var target = context.target,
        shapes = context.shapes,
        position = context.position;

    return self.canAttach(shapes, target, null, position) ||
           self.canMove(shapes, target, position) ||
           self.canReplace(shapes, target, position);
  });

  this.addRule('shape.replace', function(context) {

    var element = context.element,
        host;

    if (isCriterion(element)) {

      host = element.host;

      if (isCasePlanModel(host)) {
        return false;
      }

      if (isTask(host) && !isBlocking(host)) {
        return false;
      }

      if (isMilestone(host) || isEventListener(host)) {
        return false;
      }

    }

  });

};

CmmnRules.prototype.canMove = function(elements, target) {

  var self = this;

  // allow default move check to start move operation
  if (!target) {
    return true;
  }

  return elements.every(function(element) {

    if (isDiscretionaryItem(element)) {
      if (!self.canMoveDiscretionaryItem(element, elements, target)) {
        return false;
      }
    }

    return self.canDrop(element, target);
  });

};


CmmnRules.prototype.canMoveDiscretionaryItem = function(element, elements, target) {

  return !isPlanFragment(target) || any(element.incoming, function(connection) {
    var source = connection.source;
    if (isDiscretionaryConnection(connection)) {
      return isParent(target, source) || elements.indexOf(source) !== -1;
    }
  });

};

CmmnRules.prototype.canCreate = function(shape, target, source, position) {

  var self = this;

  if (!target) {
    return false;
  }

  if (isLabel(target)) {
    return null;
  }

  if (isSame(source, target)) {
    return false;
  }

  // ensure we do not drop the element
  // into source
  if (source && isParent(source, target)) {
    return false;
  }

  if (isDiscretionaryItem(shape)) {
    if (!self.canCreateDiscretionaryItem(shape, target, source)) {
      return false;
    }
  }

  return self.canDrop(shape, target, position);

};

CmmnRules.prototype.canCreateDiscretionaryItem = function(shape, target, source) {
  return !isPlanFragment(target) || isParent(target, source);
};


CmmnRules.prototype.canDrop = function(element, target) {

  // can move labels everywhere
  if (isLabel(element) && !isConnection(target)) {
    return true;
  }

  if (isArtifact(element)) {

    return is(target, 'cmmndi:CMMNDiagram') ||
           isPlanFragment(target, true);
  }

  if (isCriterion(element)) {
    return false;
  }

  if (isCasePlanModel(element)) {
    // allow casePlanModels to drop only on root (CMMNDiagram)
    return is(target, 'cmmndi:CMMNDiagram');
  }

    // allow any other element to drop on a case plan model or on an expanded stage
  if (!isPlanFragment(target, true)) {
    return false;
  }

  return !isCollapsed(target);

};


CmmnRules.prototype.canResize = function(shape, newBounds) {
  if (isPlanFragment(shape, true)) {
    return (!isCollapsed(shape)) && (
          !newBounds || (newBounds.width >= 100 && newBounds.height >= 80)
    );
  }

  if (isTextAnnotation(shape)) {
    return true;
  }

  return false;
};

CmmnRules.prototype.canConnect = function(source, target, connection) {

  if (nonExistantOrLabel(source) || nonExistantOrLabel(target)) {
    return null;
  }

  // Disallow connections with same target and source element.
  if (isSame(source, target)) {
    return false;
  }

  if (this.canConnectPlanItemOnPartConnection(source, target)) {
    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true
    };
  }

  if (this.canConnectCaseFileItemOnPartConnection(source, target)) {
    return {
      type: 'cmmn:CaseFileItemOnPart',
      isStandardEventVisible: true
    };
  }

  if (this.canConnectDiscretionaryConnection(source, target, connection)) {
    return {
      type: 'cmmndi:CMMNEdge'
    };
  }

  if (connection &&
      is(connection.businessObject.cmmnElementRef, 'cmmn:Association') &&
      this.canConnectAssociation(source, target)) {

    return {
      type: 'cmmn:Association'
    };
  }

  if (isTextAnnotation(source) || isTextAnnotation(target)) {

    return {
      type: 'cmmn:Association'
    };
  }

  return false;
};


CmmnRules.prototype.canConnectDiscretionaryConnection = function(source, target, connection) {

  if (!isHumanTask(getDefinition(source))) {
    return false;
  }

  if (!isBlocking(source)) {
    return false;
  }

  if (!isDiscretionaryItem(target)) {
    return false;
  }

  // A HumanTask MUST NOT be discretionary to itself.
  var sourceDefinition = getDefinition(source);
  var targetDefinition = getDefinition(target);

  if (isSame(sourceDefinition, targetDefinition)) {
    return false;
  }

  var sourceParent = getParent(source);
  var targetParent = getParent(target);

  if (!isSame(sourceParent, targetParent)) {
    return false;
  }

  // if the target discretionary item is already
  // part of a human task, then it should not be
  // possible to create a connection to it in some
  // cases.
  if (isDiscretionaryToHumanTask(target)) {

    if (!isUniqueDiscretionaryConnection(source, target, connection)) {
      return false;
    }

    var parent = getParent(getBusinessObject(target), 'cmmn:HumanTask');

    if (!isSame(getDefinition(source), parent)) {
      if (hasIncomingDiscretionaryConnections(target, connection)) {
        return false;
      }
    }

  }

  return true;
};


CmmnRules.prototype.canConnectPlanItemOnPartConnection = function(source, target) {

  if (!isSameCase(source, target)) {
    return false;
  }

  if (isExitCriterion(source)) {
    source = source.host;
  }

  if (isSame(source, target.host)) {
    return false;
  }

  if (isParent(source, target.host)) {
    return false;
  }

  if (isEntryCriterion(target) && isParent(target.host, source)) {
    return false;
  }

  return isPlanItem(source) && isCriterion(target);
};


CmmnRules.prototype.canConnectCaseFileItemOnPartConnection = function(source, target) {
  return !!(isSameCase(source, target) &&
            isCaseFileItem(source) &&
            isCriterion(target));
};

CmmnRules.prototype.canConnectAssociation = function(source, target) {

  // do not connect connections
  if (isConnection(source) || isConnection(target)) {
    return false;
  }

  // connect if different parent
  return !isParent(target, source) &&
         !isParent(source, target);

};

CmmnRules.prototype.canAttach = function(elements, target, source, position) {

  if (isSame(source, target)) {
    return false;
  }


  if (!Array.isArray(elements)) {
    elements = [ elements ];
  }

  // only (re-)attach one element at a time
  if (elements.length !== 1) {
    return false;
  }

  var element = elements[0];

  // do not attach labels
  if (isLabel(element)) {
    return false;
  }

  // only handle entry/exit criterion
  if (!isCriterion(element)) {
    return false;
  }

  // allow default move operation
  if (!target) {
    return true;
  }

  if (!this.canAttachCriterion(element, target, position, source)) {
    return false;
  }

  return 'attach';

};


CmmnRules.prototype.canAttachEntryCriterion = function(element, target, position, source) {

  if (!this.canAttachCriterion(element, target, position, source)) {
    return false;
  }

  if (source && isParent(target, source)) {
    return false;
  }

  // disallow drop entry criterion...

  // ... on case plan model
  if (isCasePlanModel(target)) {
    return false;
  }

  if (isPlanFragment(target, true)) {

    // ... when element has an incoming connection which source
    // is a child of the target
    return !any(element.incoming, function(connection) {
      if (is(connection.businessObject.cmmnElementRef, 'cmmn:PlanItemOnPart')) {
        return isParent(target, connection.source);
      }
    });

  }

  return true;
};


CmmnRules.prototype.canAttachExitCriterion = function(element, target, position, source) {

  if (!this.canAttachCriterion(element, target, position, source)) {
    return false;
  }

  // disallow drop exit criterion...

  // ... on milestone
  if (isMilestone(target)) {
    return false;
  }

  // ... on non blocking task
  if (isTask(target) && !isBlocking(target)) {
    return false;
  }

  return true;

};


CmmnRules.prototype.canAttachCriterion = function(element, target, position, source) {

  if (source && isParent(source, target)) {
    return false;
  }

  // disallow drop criterion...

  // ... on another criterion
  if (isCriterion(target)) {
    return false;
  }

  // ... on event listener
  if (isEventListener(target)) {
    return false;
  }

  // a plan fragment does not have any execution semantic,
  // that why it should not be possible to attach an criterion
  if (isPlanFragment(target)) {
    return false;
  }

  // ... on a text annotation
  if (isTextAnnotation(target)) {
    return false;
  }

  // ... on a case file item
  if (isCaseFileItem(target)) {
    return false;
  }

  // only attach to border
  if (position && !isCriterionAttachment(position, target)) {
    return false;
  }

  return true;

};


CmmnRules.prototype.canReplace = function(elements, target, position, source) {

  if (!target) {
    return false;
  }

  if (isSame(source, target)) {
    return false;
  }

  var canExecute = {
    replacements: []
  };

  var self = this;

  forEach(elements, function(element) {

    if (isEntryCriterion(element) && !self.canAttachEntryCriterion(element, target, position, source)) {
      if (self.canAttachExitCriterion(element, target, position, source)) {
        canExecute.replacements.push({
          oldElementId: element.id,
          newElementType: 'cmmn:ExitCriterion'
        });
      }
    }

    if (isExitCriterion(element) && !self.canAttachExitCriterion(element, target, position, source)) {
      if (self.canAttachEntryCriterion(element, target, position, source)) {
        canExecute.replacements.push({
          oldElementId: element.id,
          newElementType: 'cmmn:EntryCriterion'
        });
      }
    }

    if (isPlanFragment(target) &&
        isDiscretionaryItem(element) &&
        self.canDrop(element, target) &&
        !self.canMoveDiscretionaryItem(element, elements, target)) {

      var replacement = {
        oldElementId: element.id,
        newElementType: 'cmmn:PlanItem'
      };

      if (isPlanFragment(element)) {
        assign(replacement, {
          newDefinitionType: 'cmmn:Stage'
        });
      }

      canExecute.replacements.push(replacement);

    }

  });

  return canExecute.replacements.length ? canExecute : false;
};


CmmnRules.prototype.canReplaceConnectionEnd = function(source, target, side) {

  if (!source || !target) {
    return false;
  }

  if (isSame(source, target)) {
    return false;
  }

  if (!isSameCase(source, target)) {
    return false;
  }

  return side === 'source' ? this.canReplaceSource(source, target) : this.canReplaceTarget(source, target);

};


CmmnRules.prototype.canReplaceSource = function(source, target) {

  if (isDiscretionaryItem(source) && isCriterion(target)) {

    if (isSame(source, target.host)) {
      return false;
    }

    if (isPlanFragment(source)) {
      return false;
    }

    if (isParent(source, target.host)) {
      return false;
    }

    if (isEntryCriterion(target) && isParent(target.host, source)) {
      return false;
    }

    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true,
      replacements: [{
        oldElementId: source.id,
        newElementType: 'cmmn:PlanItem'
      }]
    };

  }


  if (isEntryCriterion(source) && isEntryCriterion(target)) {

    if (isSame(source.host, target.host)) {
      return false;
    }

    if (isParent(target.host, source.host) ||
        isParent(source.host, target.host)) {
      return false;
    }

    if (hasIncomingOnPartConnections(source)) {
      return false;
    }

    if (!this.canAttachExitCriterion(source, source.host)) {
      return false;
    }

    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true,
      replacements: [{
        oldElementId: source.id,
        newElementType: 'cmmn:ExitCriterion'
      }]
    };

  }

  return false;

};


CmmnRules.prototype.canReplaceTarget = function(source, target) {

  if (isHumanTask(getDefinition(source)) && isPlanItem(target)) {

    if (!isBlocking(source)) {
      return false;
    }

    if (isEventListener(target) || isMilestone(target)) {
      return false;
    }

    if (isSameDefinition(source, target)) {
      return false;
    }

    if (!isSameParent(source, target)) {
      return false;
    }

    return {
      type: 'cmmndi:CMMNEdge',
      replacements: [{
        oldElementId: target.id,
        newElementType: 'cmmn:DiscretionaryItem'
      }]
    };

  }

  if ((isPlanItem(source) || isExitCriterion(source)) && isEntryCriterion(target)) {

    if (isSame(source.host || source, target.host)) {
      return false;
    }

    if (!isParent(target.host, source.host || source)) {
      return false;
    }

    if (hasIncomingOnPartConnections(target)) {
      return false;
    }

    if (!this.canAttachExitCriterion(target, target.host)) {
      return false;
    }

    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true,
      replacements: [{
        oldElementId: target.id,
        newElementType: 'cmmn:ExitCriterion'
      }]
    };

  }

  return false;

};


CmmnRules.prototype.canSetRepetitionRule = function(element) {
  return isPlanItemControlCapable(element);
};


CmmnRules.prototype.canSetRequiredRule = function(element) {
  return isPlanItemControlCapable(element);
};


CmmnRules.prototype.canSetManualActivationRule = function(element) {
  if (isMilestone(element)) {
    return false;
  }
  return isPlanItemControlCapable(element);
};


/**
 * Utility functions for rule checking
 */

function isParent(possibleParent, element) {
  var allParents = getParents(element);
  return allParents.indexOf(possibleParent) !== -1;
}

function isPlanItemControlCapable(element) {
  return isTask(element) || isMilestone(element) || is(getDefinition(element), 'cmmn:Stage');
}

function nonExistantOrLabel(element) {
  return !element || isLabel(element);
}

function isLabel(element) {
  return element.labelTarget;
}

function isConnection(element) {
  return element.waypoints;
}

function isUniqueDiscretionaryConnection(source, target, connection) {
  return !any(target.incoming, function(con) {
    return con !== connection &&
        isDiscretionaryConnection(con) &&
        con.source === source &&
        con.target === target;
  });
}

function hasIncomingDiscretionaryConnections(target, connection) {
  return any(target.incoming, function(con) {
    return con !== connection && isDiscretionaryConnection(con);
  });
}

function isDiscretionaryConnection(connection) {
  return !connection.businessObject.cmmnElementRef;
}

function hasIncomingOnPartConnections(target) {
  return any(target.incoming, function(con) {
    return isOnPartConnection(con);
  });
}

function isOnPartConnection(connection) {
  return is(connection.businessObject.cmmnElementRef, 'cmmn:OnPart');
}

function isPlanFragment(element, isStage) {
  var definition = getDefinition(element) || element;

  if (!is(definition, 'cmmn:PlanFragment')) {
    return false;
  }

  if (!isStage && is(definition, 'cmmn:Stage')) {
    return false;
  }

  return true;
}

function isEventListener(element) {
  return is(getDefinition(element), 'cmmn:EventListener');
}

function isMilestone(element) {
  return is(getDefinition(element), 'cmmn:Milestone');
}

function isTask(element) {
  return is(getDefinition(element), 'cmmn:Task');
}

function isBlocking(element) {
  element = getDefinition(element);
  return !!(element && element.isBlocking);
}

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function isEntryCriterion(element) {
  return is(element, 'cmmn:EntryCriterion');
}

function isExitCriterion(element) {
  return is(element, 'cmmn:ExitCriterion');
}

function isArtifact(element) {
  if (isConnection(element)) {
    element = element.businessObject.cmmnElementRef;
  }
  return is(element, 'cmmn:Artifact');
}

function isTextAnnotation(element) {
  return is(element, 'cmmn:TextAnnotation');
}

function isCaseFileItem(element) {
  return is(element, 'cmmn:CaseFileItem');
}

function isPlanItem(element) {
  return is(element, 'cmmn:PlanItem');
}

function isSameParent(a, b) {
  return isSame(getParent(a), getParent(b));
}

function isSameDefinition(a, b) {
  return isSame(getDefinition(a), getDefinition(b));
}

},{"202":202,"257":257,"267":267,"271":271,"398":398,"45":45,"46":46,"65":65,"72":72,"74":74}],61:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(204)
  ],
  __init__: [ 'cmmnRules' ],
  cmmnRules: [ 'type', _dereq_(60) ]
};
},{"204":204,"60":60}],62:[function(_dereq_,module,exports){
'use strict';

var map = _dereq_(273),
    filter = _dereq_(269),
    sortBy = _dereq_(277);

var labelUtil = _dereq_(18);


/**
 * Provides ability to search through CMMN elements
 */
function CmmnSearchProvider(elementRegistry, searchPad, canvas) {

  this._elementRegistry = elementRegistry;
  this._canvas = canvas;

  searchPad.registerProvider(this);
}

module.exports = CmmnSearchProvider;

CmmnSearchProvider.$inject = [
  'elementRegistry',
  'searchPad',
  'canvas'
];


/**
 * Finds all elements that match given pattern
 *
 * <Result> :
 *  {
 *    primaryTokens: <Array<Token>>,
 *    secondaryTokens: <Array<Token>>,
 *    element: <Element>
 *  }
 *
 * <Token> :
 *  {
 *    normal|matched: <String>
 *  }
 *
 * @param  {String} pattern
 * @return {Array<Result>}
 */
CmmnSearchProvider.prototype.find = function(pattern) {
  var rootElement = this._canvas.getRootElement();

  var elements = this._elementRegistry.filter(function(element) {
    if (element.labelTarget) {
      return false;
    }
    return true;
  });

  // do not include root element
  elements = filter(elements, function(element) {
    return element !== rootElement;
  });

  elements = map(elements, function(element) {
    return {
      primaryTokens: matchAndSplit(labelUtil.getLabel(element), pattern),
      secondaryTokens: matchAndSplit(element.id, pattern),
      element: element
    };
  });

  // exclude non-matched elements
  elements = filter(elements, function(element) {
    return hasMatched(element.primaryTokens) || hasMatched(element.secondaryTokens);
  });

  elements = sortBy(elements, function(element) {
    return labelUtil.getLabel(element.element) + element.element.id;
  });

  return elements;
};


function hasMatched(tokens) {
  var matched = filter(tokens, function(t) {
    return !!t.matched;
  });

  return matched.length > 0;
}


function matchAndSplit(text, pattern) {
  var tokens = [],
      originalText = text;

  if (!text) {
    return tokens;
  }

  text = text.toLowerCase();
  pattern = pattern.toLowerCase();

  var i = text.indexOf(pattern);

  if (i > -1) {
    if (i !== 0) {
      tokens.push({
        normal: originalText.substr(0, i)
      });
    }

    tokens.push({
      matched: originalText.substr(i, pattern.length)
    });

    if (pattern.length + i < text.length) {
      tokens.push({
        normal: originalText.substr(pattern.length + i, text.length)
      });
    }
  } else {
    tokens.push({
      normal: originalText
    });
  }

  return tokens;
}
},{"18":18,"269":269,"273":273,"277":277}],63:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(206)
  ],
  __init__: [ 'cmmnSearch'],
  cmmnSearch: [ 'type', _dereq_(62) ]
};

},{"206":206,"62":62}],64:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var is = _dereq_(74).is,
    getDefinition = _dereq_(74).getDefinition,
    isCollapsed = _dereq_(72).isCollapsed;

var Snapping = _dereq_(213),
    SnapUtil = _dereq_(212);

var isSnapped = SnapUtil.isSnapped,
    setSnapped = SnapUtil.setSnapped;

var asTRBL = _dereq_(222).asTRBL;

var SLIGHTLY_HIGHER_PRIORITY = 1001;

var getCriterionAttachment = _dereq_(65).getCriterionAttachment;


function isStage(element) {
  return is(getDefinition(element), 'cmmn:PlanFragment');
}


/**
 * Cmmn specific snapping functionality
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 */
function CmmnSnapping(eventBus, canvas, cmmnRules) {

  // instantiate super
  Snapping.call(this, eventBus, canvas);

  function canAttach(shape, target, position) {
    return cmmnRules.canAttach([ shape ], target, null, position) === 'attach';
  }

  eventBus.on('resize.start', SLIGHTLY_HIGHER_PRIORITY + 500, function(event) {
    var context = event.context,
        shape = context.shape;

    if (isStage(shape) && !isCollapsed(shape)) {
      context.minDimensions = { width: 140, height: 120 };
    }

    if (is(shape, 'cmmn:TextAnnotation')) {
      context.minDimensions = { width: 50, height: 30 };
    }

  });

  eventBus.on([
    'create.move',
    'create.end',
    'shape.move.move',
    'shape.move.end'
  ], 1500, function(event) {

    var context = event.context,
        target = context.target,
        shape = context.shape;

    if (target && !isSnapped(event) && canAttach(shape, target, event)) {
      snapCriterion(event, shape, target);
    }
  });


  function snapCriterion(event, shape, target) {
    var targetTRBL = asTRBL(target);

    var direction = getCriterionAttachment(event, target);

    if (/top/.test(direction)) {
      setSnapped(event, 'y', targetTRBL.top);
    } else
    if (/bottom/.test(direction)) {
      setSnapped(event, 'y', targetTRBL.bottom);
    }

    if (/left/.test(direction)) {
      setSnapped(event, 'x', targetTRBL.left);
    } else
    if (/right/.test(direction)) {
      setSnapped(event, 'x', targetTRBL.right);
    }
  }
}

inherits(CmmnSnapping, Snapping);

CmmnSnapping.$inject = [ 'eventBus', 'canvas', 'cmmnRules' ];

module.exports = CmmnSnapping;

},{"212":212,"213":213,"222":222,"257":257,"65":65,"72":72,"74":74}],65:[function(_dereq_,module,exports){
'use strict';

var getOrientation = _dereq_(222).getOrientation;

var is = _dereq_(74).is,
    getDefinition = _dereq_(74).getDefinition;


/**
 * Get orientation of the given position rectangle in relation to the
 * given target rectangle. When the position is near a corner (respecting
 * the given offet) the string 'corner' is returned.
 *
 * A padding (positive or negative) may be passed to influence
 * horizontal / vertical orientation and intersection.
 *
 * @param {Bounds} position
 * @param {Bounds} target
 * @param {Point|Number} padding
 * @param {Number} offset
 */
function getCornerlessOrientation(position, target, padding, offset) {

  // don't snap to top left corner
  if (position.x - offset < target.x &&
      position.y - offset < target.y) {
    return 'corner';
  }

  // don't snap to top right corner
  if (position.x + offset > target.x + target.width &&
      position.y - offset < target.y) {
    return 'corner';
  }

  // don't snap to bottom left corner
  if (position.x - offset < target.x &&
      position.y + offset > target.y + target.height) {
    return 'corner';
  }

  // don't snap to bottom right corner
  if (position.x + offset > target.x + target.width &&
      position.y + offset > target.y + target.height) {
    return 'corner';
  }

  return getOrientation(position, target, padding);
}


function getCriterionAttachment(position, target) {

  var orientation;

  var definition = getDefinition(target);

  if (is(target, 'cmmn:PlanItem') && is(definition, 'cmmn:Stage')) {
    orientation = getCornerlessOrientation(position, target, -15, 20);

  } else
  if (is(definition, 'cmmn:Milestone')) {
    orientation = getCornerlessOrientation(position, target, -3, 7);

  } else {
    orientation = getOrientation(position, target, -15);
  }

  if (orientation !== 'intersect') {
    return orientation;
  } else {
    return null;
  }
}

module.exports.getCriterionAttachment = getCriterionAttachment;
},{"222":222,"74":74}],66:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'snapping' ],
  snapping: [ 'type', _dereq_(64) ]
};
},{"64":64}],67:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    map = _dereq_(273);

var LabelUtil = _dereq_(73);

var is = _dereq_(74).is;

var hasExternalLabel = LabelUtil.hasExternalLabel,
    getExternalLabelBounds = LabelUtil.getExternalLabelBounds,
    isCollapsed = _dereq_(72).isCollapsed,
    elementToString = _dereq_(70).elementToString;


function elementData(semantic, attrs) {
  return assign({
    id: semantic.id,
    type: semantic.$type,
    businessObject: semantic
  }, attrs);
}

function collectWaypoints(waypoints) {
  return map(waypoints, function(p) {
    return { x: p.x, y: p.y };
  });
}

function notYetDrawn(semantic, refSemantic, property) {
  return new Error(
      'element ' + elementToString(refSemantic) + ' referenced by ' +
      elementToString(semantic) + '#' + property + ' not yet drawn');
}

/**
 * An importer that adds cmmn elements to the canvas
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {ElementFactory} elementFactory
 * @param {ElementRegistry} elementRegistry
 */
function CmmnImporter(eventBus, canvas, elementFactory, elementRegistry) {
  this._eventBus = eventBus;
  this._canvas = canvas;

  this._elementFactory = elementFactory;
  this._elementRegistry = elementRegistry;
}

CmmnImporter.$inject = [ 'eventBus', 'canvas', 'elementFactory', 'elementRegistry' ];

module.exports = CmmnImporter;


/**
 * Set the diagram as root element
 */
CmmnImporter.prototype.root = function(diagram) {
  var element = this._elementFactory.createRoot(elementData(diagram));

  this._canvas.setRootElement(element);

  return element;
};


/**
 * Add cmmn element (semantic) to the canvas onto the
 * specified parent shape.
 */
CmmnImporter.prototype.add = function(semantic, parentElement) {

  var di = semantic.di,
      element,
      hidden;

  // SHAPE
  if (di && is(di, 'cmmndi:CMMNShape') && !this._getElement(semantic)) {

    var collapsed = isCollapsed(semantic);

    hidden = parentElement && (parentElement.hidden || parentElement.collapsed);

    var bounds = semantic.di.bounds;

    element = this._elementFactory.createShape(elementData(semantic, {
      collapsed: collapsed,
      hidden: hidden,
      x: Math.round(bounds.x),
      y: Math.round(bounds.y),
      width: Math.round(bounds.width),
      height: Math.round(bounds.height)
    }));

    if (is(semantic, 'cmmn:Criterion')) {
      this._attachCriterion(semantic, element);
    }

    this._canvas.addShape(element, parentElement);
  }

  // CONNECTION
  else if ((di && is(di, 'cmmndi:CMMNEdge')) || is(semantic, 'cmmndi:CMMNEdge')) {

    var source = this._getSource(semantic),
        target = this._getTarget(semantic);

    hidden = (parentElement && (parentElement.hidden || parentElement.collapsed)) ||
                 (source && source.hidden) ||
                 (target && target.hidden) ;

    var waypoint = (semantic.di || {}).waypoint || semantic.waypoint;

    element = this._elementFactory.createConnection(elementData(semantic, {
      hidden: hidden,
      source: source,
      target: target,
      waypoints: collectWaypoints(waypoint)
    }));

    this._canvas.addConnection(element, parentElement);
  } else {
    throw new Error('unknown di ' + elementToString(di) + ' for element ' + elementToString(semantic));
  }

  // (optional) LABEL
  if (hasExternalLabel(semantic)) {
    this.addLabel(semantic, element);
  }

  this._eventBus.fire('cmmnElement.added', { element: element });

  return element;
};


/**
 * Attach the criterion element to the given host
 *
 * @param {ModdleElement} criterionSemantic
 * @param {djs.model.Base} criterionElement
 */
CmmnImporter.prototype._attachCriterion = function(criterionSemantic, criterionElement) {
  var hostSemantic = criterionSemantic.$parent;

  if (!hostSemantic) {
    throw new Error('missing ' + elementToString(criterionSemantic) + '$parent');
  }

  var host = this._elementRegistry.get(hostSemantic.id),
      attachers = host && host.attachers;

  if (!host) {
    throw notYetDrawn(criterionSemantic, hostSemantic, 'criterion');
  }

  // wire element.host <> host.attachers
  criterionElement.host = host;

  if (!attachers) {
    host.attachers = attachers = [];
  }

  if (attachers.indexOf(criterionElement) === -1) {
    attachers.push(criterionElement);
  }
};


/**
 * add label for an element
 */
CmmnImporter.prototype.addLabel = function(semantic, element) {
  var bounds = getExternalLabelBounds(semantic, element);

  var label = this._elementFactory.createLabel(elementData(semantic, {
    id: semantic.id + '_label',
    labelTarget: element,
    type: 'label',
    hidden: element.hidden,
    x: Math.round(bounds.x),
    y: Math.round(bounds.y),
    width: Math.round(bounds.width),
    height: Math.round(bounds.height)
  }));

  return this._canvas.addShape(label, element.parent);
};

CmmnImporter.prototype._getSource = function(semantic) {
  var cmmnElement = semantic.cmmnElementRef;

  if (cmmnElement) {

    if (is(cmmnElement, 'cmmn:OnPart')) {

      if (cmmnElement.exitCriterionRef) {
        return this._getEnd(cmmnElement, 'exitCriterionRef');
      }

      return this._getEnd(cmmnElement, 'sourceRef');

    }

    if (is(cmmnElement, 'cmmn:Association')) {
      return this._getEnd(cmmnElement, 'sourceRef');
    }

  }

  if (is(semantic, 'cmmndi:CMMNEdge')) {
    return this._getEnd(semantic, 'sourceCMMNElementRef');
  }

};

CmmnImporter.prototype._getTarget = function(semantic) {
  var cmmnElement = semantic.cmmnElementRef;

  if (cmmnElement) {

    if (is(cmmnElement, 'cmmn:Association')) {
      return this._getEnd(cmmnElement, 'targetRef');
    }

  }

  return this._getEnd(semantic, 'targetCMMNElementRef');
};

CmmnImporter.prototype._getEnd = function(semantic, side) {
  var refSemantic = semantic[side];
  var element = refSemantic && this._getElement(refSemantic);

  if (element) {
    return element;
  }

  if (refSemantic) {
    throw notYetDrawn(semantic, refSemantic, side);
  } else {
    throw new Error(elementToString(semantic) + '#' + side + 'Ref not specified');
  }

};

CmmnImporter.prototype._getElement = function(semantic) {
  return this._elementRegistry.get(semantic.id);
};
},{"273":273,"398":398,"70":70,"72":72,"73":73,"74":74}],68:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    filter = _dereq_(269);

var Refs = _dereq_(432);

var elementToString = _dereq_(70).elementToString;
var is = _dereq_(74).is;

var Collections = _dereq_(232);

var diRefs = new Refs({ name: 'cmmnElement', enumerable: true }, { name: 'di' });


function CmmnTreeWalker(handler) {

  // list of elements to handle deferred to ensure
  // prerequisites are drawn
  var deferred = [];

  // list of CMMNEdges which cmmnElementRef is equals null:
  // - it is a connection which does not have a representation
  //   in case plan model
  // - it is a connection between a human (plan item) task and a
  //   discretionary item
  var connections = [];

  var discretionaryConnections = {};

  // list of cases to draw
  var cases = [];

  var handledDiscretionaryItems = {};

  // list of elements (textAnnotations and caseFileItems)
  var elementsWithoutParent = [];

  var associations = [];

  ///// Helpers /////////////////////////////////

  function isDiscretionaryItemHandled(item) {
    return !!handledDiscretionaryItems[item.id];
  }

  function handledDiscretionaryItem(item) {
    handledDiscretionaryItems[item.id] = item;
  }

  /**
   * Returns the surrounding 'cmmn:Case' element
   *
   * @param {ModdleElement} element
   *
   * @return {ModdleElement} the surrounding case
   */
  function getCase(element) {
    while (element && !is(element, 'cmmn:Case')) {
      element = element.$parent;
    }
    return element;
  }

  function visit(element, ctx) {
    // call handler
    return handler.element(element, ctx);
  }

  function visitRoot(element, diagram) {
    return handler.root(element, diagram);
  }

  function visitIfDi(element, ctx) {
    try {
      handler.addItem(element);
      return element.di && visit(element, ctx);
    } catch (e) {
      logError(e.message, { element: element, error: e });

      console.error('failed to import ' + elementToString(element));
      console.error(e);
    }
  }

  function logError(message, context) {
    handler.error(message, context);
  }


  function contextual(fn, ctx) {
    return function(e) {
      fn(e, ctx);
    };
  }

  ////// DI handling ////////////////////////////

  function registerDi(di) {

    var cmmnElement = di.cmmnElementRef;

    if (cmmnElement && !is(di, 'cmmndi:CMMNEdge')) {

      if (cmmnElement.di) {
        logError('multiple DI elements defined for ' + elementToString(cmmnElement), { element: cmmnElement });
      }
      else {

        var _case = getCase(cmmnElement);
        if (_case && cases.indexOf(_case) === -1) {
          // add _case to the list of cases
          // that should be drawn
          cases.push(_case);
        }

        if (is(cmmnElement, 'cmmn:TextAnnotation') || is(cmmnElement, 'cmmn:CaseFileItem')) {
          elementsWithoutParent.push(cmmnElement);
        }

        diRefs.bind(cmmnElement, 'di');
        cmmnElement.di = di;
      }

    }
    else if (is(di, 'cmmndi:CMMNEdge')) {
      var shouldHandle = true;

      if (!isReferencingTarget(di)) {
        shouldHandle = false;
        logError('no target referenced in ' + elementToString(di), { element: di });
      }

      if (!isReferencingSource(di)) {
        shouldHandle = false;
        logError('no source referenced in ' + elementToString(di), { element: di });
      }

      if (shouldHandle) {

        if (is(cmmnElement, 'cmmn:Association')) {
          associations.push(di);
        }
        else if (!cmmnElement) {
          var source = di.sourceCMMNElementRef;
          discretionaryConnections[source.id] = discretionaryConnections[source.id] || [];
          discretionaryConnections[source.id].push(di);
        }
        else {
          connections.push(function(ctx) {
            handleConnection(di, ctx);
          });
        }
      }

    }
    else {
      logError('no cmmnElement referenced in ' + elementToString(di), { element: di });
    }
  }

  function isReferencingTarget(edge) {
    if (is(edge.cmmnElementRef, 'cmmn:Association')) {
      return !!edge.cmmnElementRef.targetRef;
    }

    return !!edge.targetCMMNElementRef;
  }

  function isReferencingSource(edge) {
    if (is(edge.cmmnElementRef, 'cmmn:OnPart')) {
      return !!(edge.cmmnElementRef.exitCriterionRef || edge.cmmnElementRef.sourceRef);
    }

    if (is(edge.cmmnElementRef, 'cmmn:Association')) {
      return !!edge.cmmnElementRef.sourceRef;
    }

    return !!edge.sourceCMMNElementRef;
  }

  function handleConnection(connection, context) {
    visit(connection, context);
  }

  function handleDiagram(diagram) {
    handleDiagramElements(diagram.diagramElements);
  }

  function handleDiagramElements(diagramElements) {
    forEach(diagramElements, handleDiagramElement);
  }

  function handleDiagramElement(diagramElement) {
    registerDi(diagramElement);
  }

  ////// Semantic handling //////////////////////

  function handleDefinitions(definitions, diagram) {
    // make sure we walk the correct cmmnElement

    var cmmndi = definitions.CMMNDI;

    // no di -> nothing to import
    if (!cmmndi) {
      return;
    }

    var diagrams = cmmndi.diagrams;

    if (diagram && diagrams.indexOf(diagram) === -1) {
      throw new Error('diagram not part of cmmn:Definitions');
    }

    if (!diagram && diagrams && diagrams.length) {
      diagram = diagrams[0];
    }

    // handle only the first diagram and ignore others
    handleDiagram(diagram);

    var context = visitRoot(diagram, diagram);

    handleCases(cases, context);

    forEach(elementsWithoutParent, contextual(handleElementWithoutParent));
    forEach(associations, contextual(handleAssociation));
  }

  function handleCases(cases, context) {
    forEach(cases, function(_case) {
      handleCase(_case, context);

      // clear collections for the next iteration
      deferred = [];
      connections = [];
    });
  }

  function handleCase(_case, context) {
    var casePlanModel = _case.casePlanModel;

    var casePlanModelContext;
    if (casePlanModel) {
      casePlanModelContext = handleCasePlanModel(casePlanModel, context);
    }

    handleDeferred(deferred);

    forEach(connections, function(d) { d(casePlanModelContext); });

  }

  function handleCasePlanModel(casePlanModel, context) {
    var newCtx = visitIfDi(casePlanModel, context);

    forEach(casePlanModel.exitCriteria, contextual(handleCriterion, newCtx));

    handlePlanFragment(casePlanModel, newCtx);
    handleElementsWithoutParent(casePlanModel, newCtx);

    return newCtx;
  }

  function handleDeferred(deferred) {
    forEach(deferred, function(d) { d(); });
  }

  function handlePlanFragment(planFragment, context) {
    handlePlanItems(planFragment.planItems, context);

    if (is(planFragment, 'cmmn:Stage')) {
      handleStage(planFragment, context);
    }
  }

  function handleStage(stage, context) {
    handlePlanningTable(stage.planningTable, context);
  }

  function handlePlanningTable(planningTable, context) {
    if (planningTable) {
      forEach(planningTable.tableItems, function(tableItem) {
        if (is(tableItem, 'cmmn:DiscretionaryItem')) {
          handleDiscretionaryItem(tableItem, context);
        }
        else if (is(tableItem, 'cmmn:PlanningTable')) {
          handlePlanningTable(tableItem, context);
        }
      });
    }
  }

  function handleDiscretionaryItem(discretionayItem, context) {
    if (isDiscretionaryItemHandled(discretionayItem)) {
      return;
    }

    handledDiscretionaryItem(discretionayItem);
    handleItem(discretionayItem, context);
  }

  function handlePlanItems(planItems, context) {
    forEach(planItems, contextual(handleItem, context));
  }

  function handleItem(item, context) {
    var newCtx = visitIfDi(item, context);

    forEach(item.exitCriteria, contextual(handleCriterion, context));
    forEach(item.entryCriteria, contextual(handleCriterion, context));

    var definitionRef = item.definitionRef;
    if (is(definitionRef, 'cmmn:PlanFragment')) {
      handlePlanFragment(definitionRef, newCtx);
      handleElementsWithoutParent(item, newCtx);
    }
    else if (is(definitionRef, 'cmmn:HumanTask')) {
      handlePlanningTable(definitionRef.planningTable, context);

      var edges = discretionaryConnections[item.id];
      forEach(edges, contextual(handleDiscretionaryConnection, context));
      delete discretionaryConnections[item.id];

    }
  }

  function handleCriterion(criterion, context) {
    deferred.unshift(function() {
      visitIfDi(criterion, context);
    });
  }

  function handleElementsWithoutParent(container, context) {

    if (container.di && container.di.bounds) {
      var elements = getEnclosedElements(elementsWithoutParent, container);

      forEach(elements, function(e) {
        Collections.remove(elementsWithoutParent, e);
        handleElementWithoutParent(e, context);
      });
    }

  }

  function handleElementWithoutParent(element, context) {
    if (is(element, 'cmmn:TextAnnotation')) {
      handleTextAnnotation(element, context);
    }
    else if (is(element, 'cmmn:CaseFileItem')) {
      handleCaseFileItem(element, context);
    }
  }

  function handleCaseFileItem(caseFileItem, context) {
    visitIfDi(caseFileItem, context);
  }

  function handleTextAnnotation(annotation, context) {
    visitIfDi(annotation, context);
  }

  function handleAssociation(association, context) {
    visit(association, context);
  }

  function handleDiscretionaryConnection(connection, context) {
    deferred.push(function() {
      visit(connection, context);
    });
  }

  function getEnclosedElements(elements, container) {
    var bounds = container.di.bounds;
    return filter(elements, function(e) {
      return e.di.bounds.x > bounds.x &&
             e.di.bounds.x < (bounds.x + bounds.width) &&
             e.di.bounds.y > bounds.y &&
             e.di.bounds.y < (bounds.y + bounds.height);
    });
  }

  ///// API ////////////////////////////////

  return {
    handleDefinitions: handleDefinitions
  };
}

module.exports = CmmnTreeWalker;
},{"232":232,"269":269,"271":271,"432":432,"70":70,"74":74}],69:[function(_dereq_,module,exports){
'use strict';

var CmmnTreeWalker = _dereq_(68);


/**
 * Import the definitions into a diagram.
 *
 * Errors and warnings are reported through the specified callback.
 *
 * @param  {Diagram} diagram
 * @param  {ModdleElement} definitions
 * @param  {Function} done the callback, invoked with (err, [ warning ]) once the import is done
 */
function importCmmnDiagram(diagram, definitions, done) {

  var importer = diagram.get('cmmnImporter'),
      eventBus = diagram.get('eventBus'),
      itemRegistry = diagram.get('itemRegistry');

  var error,
      warnings = [];

  /**
   * Walk the diagram semantically, importing (=drawing)
   * all elements you encounter.
   *
   * @param {ModdleElement} definitions
   */
  function render(definitions) {

    var visitor = {

      root: function(element) {
        return importer.root(element);
      },

      element: function(element, parentShape) {
        return importer.add(element, parentShape);
      },

      error: function(message, context) {
        warnings.push({ message: message, context: context });
      },

      addItem: function(item) {
        itemRegistry.add(item);
      }
    };

    var walker = new CmmnTreeWalker(visitor);

    // import
    walker.handleDefinitions(definitions);
  }

  eventBus.fire('import.render.start', { definitions: definitions });

  try {
    render(definitions);
  } catch (e) {
    error = e;
  }

  eventBus.fire('import.render.complete', {
    error: error,
    warnings: warnings
  });

  done(error, warnings);
}

module.exports.importCmmnDiagram = importCmmnDiagram;
},{"68":68}],70:[function(_dereq_,module,exports){
'use strict';

module.exports.elementToString = function(e) {
  if (!e) {
    return '<null>';
  }

  return '<' + e.$type + (e.id ? ' id="' + e.id : '') + '" />';
};
},{}],71:[function(_dereq_,module,exports){
module.exports = {
  cmmnImporter: [ 'type', _dereq_(67) ]
};
},{"67":67}],72:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(74).is,
    getBusinessObject = _dereq_(74).getBusinessObject,
    isCasePlanModel = _dereq_(74).isCasePlanModel;

module.exports.isCollapsed = function(element) {

  if (!isCasePlanModel(element)) {

    element = getBusinessObject(element);

    var definition = element.definitionRef;
    if (is(definition, 'cmmn:PlanFragment')) {
      return !!(element && element.di && element.di.isCollapsed);
    }
  }

  return false;
};

module.exports.isPlanningTableCollapsed = function(element) {

  element = getBusinessObject(element);

  if (is(element, 'cmmn:Stage') ||
     (element.definitionRef && (is(element.definitionRef, 'cmmn:Stage') ||
      is(element.definitionRef, 'cmmn:HumanTask')))) {
    return element.di && element.di.isPlanningTableCollapsed;
  }

  return false;
};

module.exports.isStandardEventVisible = function(element) {
  element = getBusinessObject(element);
  var cmmnElement = element.cmmnElementRef;
  return !!(is(cmmnElement, 'cmmn:OnPart') && element.isStandardEventVisible);
};
},{"74":74}],73:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(74).is;
var assign = _dereq_(398);

var DEFAULT_LABEL_SIZE = module.exports.DEFAULT_LABEL_SIZE = {
  width: 90,
  height: 20
};


/**
 * Returns true if the given semantic has an external label
 *
 * @param {CmmnElement} semantic
 * @return {Boolean} true if has label
 */
module.exports.hasExternalLabel = function(semantic) {

  if (is(semantic, 'cmmn:PlanItem') || is(semantic, 'cmmn:DiscretionaryItem')) {
    semantic = semantic.definitionRef;
  }

  if (is(semantic, 'cmmndi:CMMNEdge') && semantic.cmmnElementRef) {

    if (is(semantic.cmmnElementRef, 'cmmn:OnPart')) {
      semantic = semantic.cmmnElementRef;
    }

  }

  return is(semantic, 'cmmn:EventListener') ||
         is(semantic, 'cmmn:OnPart') ||
         is(semantic, 'cmmn:CaseFileItem');
};

/**
 * Get the middle of a number of waypoints
 *
 * @param  {Array<Point>} waypoints
 * @return {Point} the mid point
 */
var getWaypointsMid = module.exports.getWaypointsMid = function(waypoints) {

  var mid = waypoints.length / 2 - 1;

  var first = waypoints[Math.floor(mid)];
  var second = waypoints[Math.ceil(mid + 0.01)];

  return {
    x: first.x + (second.x - first.x) / 2,
    y: first.y + (second.y - first.y) / 2
  };
};


var getExternalLabelMid = module.exports.getExternalLabelMid = function(element) {

  var bo = element.businessObject,
      di = bo.di;

  if (!di && is(bo, 'cmmndi:CMMNEdge') && bo.cmmnElementRef) {
    di = bo;
  }

  if (bo && di && di.waypoint) {
    return getWaypointsMid(di.waypoint);
  } else {
    return {
      x: element.x + element.width / 2,
      y: element.y + element.height + DEFAULT_LABEL_SIZE.height / 2
    };
  }
};

/**
 * Returns the bounds of an elements label, parsed from the elements DI or
 * generated from its bounds.
 *
 * @param {CmmnElement} semantic
 * @param {djs.model.Base} element
 */
module.exports.getExternalLabelBounds = function(semantic, element) {

  var mid,
      size,
      bounds,
      di = semantic.di || semantic,
      label = di.label;

  if (label && label.bounds) {
    bounds = label.bounds;

    size = {
      width: Math.max(DEFAULT_LABEL_SIZE.width, bounds.width),
      height: bounds.height
    };

    mid = {
      x: bounds.x + bounds.width / 2,
      y: bounds.y + bounds.height / 2
    };
  } else {

    mid = getExternalLabelMid(element);

    size = DEFAULT_LABEL_SIZE;
  }

  return assign({
    x: mid.x - size.width / 2,
    y: mid.y - size.height / 2
  }, size);
};

var hasLabelBounds = module.exports.hasLabelBounds = function(semantic) {
  return semantic && semantic.di && semantic.di.label && semantic.di.label.bounds;
};

module.exports.getLabelBounds = function(semantic) {
  if (hasLabelBounds(semantic)) {
    return semantic.di.label.bounds;
  }
};
},{"398":398,"74":74}],74:[function(_dereq_,module,exports){
'use strict';

function isInstanceOf(bo, type) {
  return !!(bo && ((typeof bo.$instanceOf === 'function') && bo.$instanceOf(type)));
}

/**
 * Is an element of the given CMMN type?
 *
 * @param  {djs.model.Base|ModdleElement} element
 * @param  {String} type
 *
 * @return {Boolean}
 */
function is(element, type) {
  return isInstanceOf(getBusinessObject(element), type);
}

module.exports.is = is;


/**
 * Return the business object for a given element.
 *
 * @param  {djs.model.Base|ModdleElement} element
 *
 * @return {ModdleElement}
 */
function getBusinessObject(element) {
  return element && element.businessObject ? element.businessObject : element;
}

module.exports.getBusinessObject = getBusinessObject;

function isCasePlanModel(element) {
  element = getBusinessObject(element);
  return is(element, 'cmmn:Stage') && element.$parent && is(element.$parent, 'cmmn:Case');
}

module.exports.isCasePlanModel = isCasePlanModel;

function getDefinition(element) {
  var bo = getBusinessObject(element);

  if (is(element, 'cmmn:PlanItemDefinition') || is(element, 'cmmn:CaseFileItemDefinition')) {
    return bo;
  }

  return bo && bo.definitionRef;
}

module.exports.getDefinition = getDefinition;

function getDefaultControl(element) {
  var definition = getDefinition(element);
  return definition && definition.defaultControl;
}

module.exports.getDefaultControl = getDefaultControl;

function getItemControl(element) {
  element = getBusinessObject(element);
  return element && element.itemControl;
}

module.exports.getItemControl = getItemControl;


function getRule(element, rule) {
  var itemControl = getItemControl(element),
      defaultControl = getDefaultControl(element);

  if (itemControl && itemControl[rule]) {
    return itemControl[rule];
  }

  return defaultControl && defaultControl[rule];
}

function isRequired(element) {
  return !!getRule(element, 'requiredRule');
}

module.exports.isRequired = isRequired;

function isRepeatable(element) {
  return !!getRule(element, 'repetitionRule');
}

module.exports.isRepeatable = isRepeatable;

function isManualActivation(element) {
  return !!getRule(element, 'manualActivationRule');
}

module.exports.isManualActivation = isManualActivation;

function isAutoComplete(element) {
  element = getBusinessObject(element);
  var definition = getDefinition(element);
  return element.autoComplete || (definition && definition.autoComplete);
}

module.exports.isAutoComplete = isAutoComplete;

function hasPlanningTable(element) {
  element = getBusinessObject(element);
  return element.planningTable || (getDefinition(element) && getDefinition(element).planningTable);
}

module.exports.hasPlanningTable = hasPlanningTable;

function getName(element) {
  element = getBusinessObject(element);

  if (is(element, 'cmmndi:CMMNEdge') && element.cmmnElementRef) {
    element = element.cmmnElementRef;
  }

  var name = element.name;
  if (!name) {

    if (element.definitionRef) {
      name = element.definitionRef.name;
    }
  }

  return name;
}

module.exports.getName = getName;


/**
 * Returns the referenced sentry, if present.
 *
 * @param {djs.model.Base} criterion
 *
 * @result {ModdleElement} referenced sentry
 */
function getSentry(element) {
  var bo = getBusinessObject(element);

  if (is(bo, 'cmmn:Sentry')) {
    return bo;
  }

  return bo && bo.sentryRef;
}

module.exports.getSentry = getSentry;


function getStandardEvent(element) {
  element = getBusinessObject(element);
  return element.cmmnElementRef && element.cmmnElementRef.standardEvent;
}

module.exports.getStandardEvent = getStandardEvent;

function getStandardEvents(element) {

  if (is(element, 'cmmndi:CMMNEdge')) {
    element = getBusinessObject(element).cmmnElementRef;
  }

  if (is(element, 'cmmn:OnPart')) {

    if (is(element.exitCriterionRef, 'cmmn:ExitCriterion')) {
      return [ 'exit' ];
    }

    return getTransitions(element.sourceRef);

  }

  return [];

}

module.exports.getStandardEvents = getStandardEvents;


function getTransitions(element) {

  element = getBusinessObject(element);

  if (is(element, 'cmmn:CaseFileItem')) {

    return [
      'addChild',
      'addReference',
      'create',
      'delete',
      'removeChild',
      'removeReference',
      'replace',
      'update'
    ];

  }

  if (is(element, 'cmmn:PlanItem') || is(element, 'cmmn:DiscretionaryItem')) {

    var definition = getDefinition(element);

    if (is(definition, 'cmmn:EventListener') || is(definition, 'cmmn:Milestone')) {

      return [
        'create',
        'occur',
        'resume',
        'suspend',
        'terminate'
      ];

    }

    return [
      'complete',
      'create',
      'disable',
      'enable',
      'exit',
      'fault',
      'manualStart',
      'parentResume',
      'parentSuspend',
      'reactivate',
      'reenable',
      'resume',
      'start',
      'suspend',
      'terminate'
    ];

  }

  if (isCasePlanModel(element)) {

    return [
      'close',
      'complete',
      'create',
      'fault',
      'reactivate',
      'suspend',
      'terminate'
    ];

  }

  return [];

}

module.exports.getTransitions = getTransitions;
},{}],75:[function(_dereq_,module,exports){
/**
 * This file must not be changed or exchanged.
 *
 * @see http://bpmn.io/license for more information.
 */

'use strict';

var domify = _dereq_(415);

var domDelegate = _dereq_(414);

/* jshint -W101 */

// inlined ../resources/bpmnjs.png
var logoData = module.exports.BPMNIO_LOGO = 'iVBORw0KGgoAAAANSUhEUgAAADQAAAA0CAMAAADypuvZAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADBQTFRFiMte9PrwldFwfcZPqtqN0+zEyOe1XLgjvuKncsJAZ70y6fXh3vDT////UrQV////G2zN+AAAABB0Uk5T////////////////////AOAjXRkAAAHDSURBVHjavJZJkoUgDEBJmAX8979tM8u3E6x20VlYJfFFMoL4vBDxATxZcakIOJTWSmxvKWVIkJ8jHvlRv1F2LFrVISCZI+tCtQx+XfewgVTfyY3plPiQEAzI3zWy+kR6NBhFBYeBuscJLOUuA2WVLpCjVIaFzrNQZArxAZKUQm6gsj37L9Cb7dnIBUKxENaaMJQqMpDXvSL+ktxdGRm2IsKgJGGPg7atwUG5CcFUEuSv+CwQqizTrvDTNXdMU2bMiDWZd8d7QIySWVRsb2vBBioxOFt4OinPBapL+neAb5KL5IJ8szOza2/DYoipUCx+CjO0Bpsv0V6mktNZ+k8rlABlWG0FrOpKYVo8DT3dBeLEjUBAj7moDogVii7nSS9QzZnFcOVBp1g2PyBQ3Vr5aIapN91VJy33HTJLC1iX2FY6F8gRdaAeIEfVONgtFCzZTmoLEdOjBDfsIOA6128gw3eu1shAajdZNAORxuQDJN5A5PbEG6gNIu24QJD5iNyRMZIr6bsHbCtCU/OaOaSvgkUyDMdDa1BXGf5HJ1To+/Ym6mCKT02Y+/Sa126ZKyd3jxhzpc1r8zVL6YM1Qy/kR4ABAFJ6iQUnivhAAAAAAElFTkSuQmCC';

/* jshint +W101 */


function css(attrs) {
  return attrs.join(';');
}

var LIGHTBOX_STYLES = css([
  'z-index: 1001',
  'position: fixed',
  'top: 0',
  'left: 0',
  'right: 0',
  'bottom: 0'
]);

var BACKDROP_STYLES = css([
  'width: 100%',
  'height: 100%',
  'background: rgba(0,0,0,0.2)'
]);

var NOTICE_STYLES = css([
  'position: absolute',
  'left: 50%',
  'top: 40%',
  'margin: 0 -130px',
  'width: 260px',
  'padding: 10px',
  'background: white',
  'border: solid 1px #AAA',
  'border-radius: 3px',
  'font-family: Helvetica, Arial, sans-serif',
  'font-size: 14px',
  'line-height: 1.2em'
]);

var LIGHTBOX_MARKUP =
  '<div class="bio-powered-by-lightbox" style="' + LIGHTBOX_STYLES + '">' +
    '<div class="backdrop" style="' + BACKDROP_STYLES + '"></div>' +
    '<div class="notice" style="' + NOTICE_STYLES + '">' +
      '<a href="http://bpmn.io" target="_blank" style="float: left; margin-right: 10px">' +
        '<img src="data:image/png;base64,'+ logoData +'">' +
      '</a>' +
      'Web-based tooling for BPMN, DMN and CMMN diagrams ' +
      'powered by <a href="http://bpmn.io" target="_blank">bpmn.io</a>.' +
    '</div>' +
  '</div>';


var lightbox;

function open() {

  if (!lightbox) {
    lightbox = domify(LIGHTBOX_MARKUP);

    domDelegate.bind(lightbox, '.backdrop', 'click', function(event) {
      document.body.removeChild(lightbox);
    });
  }

  document.body.appendChild(lightbox);
}

module.exports.open = open;
},{"414":414,"415":415}],76:[function(_dereq_,module,exports){
module.exports = _dereq_(78);
},{"78":78}],77:[function(_dereq_,module,exports){
'use strict';

var isString = _dereq_(395),
    isFunction = _dereq_(390),
    assign = _dereq_(398);

var Moddle = _dereq_(423),
    XmlReader = _dereq_(421),
    XmlWriter = _dereq_(422);

/**
 * A sub class of {@link Moddle} with support for import and export of CMMN 1.1 xml files.
 *
 * @class CmmnModdle
 * @extends Moddle
 *
 * @param {Object|Array} packages to use for instantiating the model
 * @param {Object} [options] additional options to pass over
 */
function CmmnModdle(packages, options) {
  Moddle.call(this, packages, options);
}

CmmnModdle.prototype = Object.create(Moddle.prototype);

module.exports = CmmnModdle;


/**
 * Instantiates a CMMN model tree from a given xml string.
 *
 * @param {String}   xmlStr
 * @param {String}   [typeName='cmmn:Definitions'] name of the root element
 * @param {Object}   [options]  options to pass to the underlying reader
 * @param {Function} done       callback that is invoked with (err, result, parseContext)
 *                              once the import completes
 */
CmmnModdle.prototype.fromXML = function(xmlStr, typeName, options, done) {

  if (!isString(typeName)) {
    done = options;
    options = typeName;
    typeName = 'cmmn:Definitions';
  }

  if (isFunction(options)) {
    done = options;
    options = {};
  }

  var reader = new XmlReader(assign({ model: this, lax: true }, options));
  var rootHandler = reader.handler(typeName);

  reader.fromXML(xmlStr, rootHandler, done);
};


/**
 * Serializes a CMMN 1.1 object tree to XML.
 *
 * @param {String}   element    the root element, typically an instance of `cmmn:Definitions`
 * @param {Object}   [options]  to pass to the underlying writer
 * @param {Function} done       callback invoked with (err, xmlStr) once the import completes
 */
CmmnModdle.prototype.toXML = function(element, options, done) {

  if (isFunction(options)) {
    done = options;
    options = {};
  }

  var writer = new XmlWriter(options);
  try {
    var result = writer.toXML(element);
    done(null, result);
  } catch (e) {
    done(e);
  }
};

},{"390":390,"395":395,"398":398,"421":421,"422":422,"423":423}],78:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398);

var CmmnModdle = _dereq_(77);

var packages = {
  cmmn: _dereq_(79),
  cmmndi: _dereq_(80),
  dc: _dereq_(81),
  di: _dereq_(82)
};

module.exports = function(additionalPackages, options) {
  return new CmmnModdle(assign({}, packages, additionalPackages), options);
};
},{"398":398,"77":77,"79":79,"80":80,"81":81,"82":82}],79:[function(_dereq_,module,exports){
module.exports={
  "name": "CMMN",
  "uri": "http://www.omg.org/spec/CMMN/20151109/MODEL",
  "types": [
    {
      "name": "ApplicabilityRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Artifact",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ]
    },
    {
      "name": "Association",
      "superClass": [
        "Artifact"
      ],
      "properties": [
        {
          "name": "associationDirection",
          "type": "AssociationDirection",
          "isAttr": true
        },
        {
          "name": "sourceRef",
          "type": "CMMNElement",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "targetRef",
          "type": "CMMNElement",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "TextAnnotation",
      "superClass": [
        "Artifact"
      ],
      "properties": [
        {
          "name": "text",
          "type": "String"
        },
        {
          "name": "textFormat",
          "default": "text/plain",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "ManualActivationRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Case",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "caseFileModel",
          "type": "CaseFile",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "casePlanModel",
          "type": "Stage",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "caseRoles",
          "type": "CaseRoles"
        },
        {
          "name": "input",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "CaseFile",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "caseFileItems",
          "type": "CaseFileItem",
          "isMany": true
        }
      ]
    },
    {
      "name": "CaseFileItem",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "multiplicity",
          "type": "String",
          "isAttr": true,
          "default": "Unspecified"
        },
        {
          "name": "definitionRef",
          "type": "CaseFileItemDefinition",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "sourceRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "targetRefs",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true,
          "isMany": true
        },
        {
          "name": "children",
          "type": "Children",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "CaseFileItemDefinition",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "definitionType",
          "type": "String",
          "default": "http://www.omg.org/spec/CMMN/DefinitionType/Unspecified",
          "isAttr": true
        },
        {
          "name": "properties",
          "type": "Property",
          "isMany": true
        },
        {
          "name": "structureRef",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "importRef",
          "type": "Import",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "CaseFileItemOnPart",
      "superClass": [
        "OnPart"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String"
        },
        {
          "name": "sourceRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "CaseParameter",
      "superClass": [
        "Parameter"
      ],
      "properties": [
        {
          "name": "bindingRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "bindingRefinement",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "CaseRoles",
      "superClass": [
        "Parameter"
      ],
      "properties": [
        {
          "name": "role",
          "type": "Role",
          "isMany": true
        }
      ]
    },
    {
      "name": "CaseTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "parameterMapping",
          "type": "ParameterMapping",
          "isMany": true
        },
        {
          "name": "caseRefExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "caseRef",
          "type": "String",
          "isAttr": true
        }
      ]
    },
    {
      "name": "Children",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "caseFileItems",
          "type": "CaseFileItem",
          "isMany": true
        }
      ]
    },
    {
      "name": "CMMNElement",
      "isAbstract": true,
      "properties": [
        {
          "name": "id",
          "isAttr": true,
          "type": "String",
          "isId": true
        },
        {
          "name": "documentation",
          "type": "Documentation",
          "isMany": true
        },
        {
          "name": "extensionElements",
          "type": "ExtensionElements"
        },
        {
          "name": "extensionDefinitions",
          "type": "ExtensionDefinition",
          "isReference": true,
          "isMany": true
        }
      ]
    },
    {
      "name": "Definitions",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "targetNamespace",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "expressionLanguage",
          "type": "String",
          "isAttr": true,
          "default": "http://www.w3.org/1999/XPath"
        },
        {
          "name": "exporter",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "exporterVersion",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "author",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "creationDate",
          "type": "DateTime",
          "isAttr": true
        },
        {
          "name": "imports",
          "type": "Import",
          "isMany": true
        },
        {
          "name": "caseFileItemDefinitions",
          "type": "CaseFileItemDefinition",
          "isMany": true
        },
        {
          "name": "cases",
          "type": "Case",
          "isMany": true
        },
        {
          "name": "processes",
          "type": "Process",
          "isMany": true
        },
        {
          "name": "decisions",
          "type": "Decision",
          "isMany": true
        },
        {
          "name": "extensions",
          "type": "Extension",
          "isMany": true
        },
        {
          "name": "relationships",
          "type": "Relationship",
          "isMany": true
        },
        {
          "name": "artifacts",
          "type": "Artifact",
          "isMany": true
        },
        {
          "name": "CMMNDI",
          "type": "cmmndi:CMMNDI"
        }
      ]
    },
    {
      "name": "DiscretionaryItem",
      "superClass": [
        "TableItem"
      ],
      "properties": [
        {
          "name": "itemControl",
          "type": "PlanItemControl",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "definitionRef",
          "type": "PlanItemDefinition",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "entryCriteria",
          "type": "EntryCriterion",
          "isMany": true
        },
        {
          "name": "exitCriteria",
          "type": "ExitCriterion",
          "isMany": true
        }
      ]
    },
    {
      "name": "EventListener",
      "superClass": [
        "PlanItemDefinition"
      ]
    },
    {
      "name": "Expression",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "language",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "body",
          "isBody": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "HumanTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "planningTable",
          "type": "PlanningTable"
        },
        {
          "name": "performerRef",
          "type": "Role",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "IfPart",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "Import",
      "properties": [
        {
          "name": "location",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "namespace",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "importType",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Milestone",
      "superClass": [
        "PlanItemDefinition"
      ]
    },
    {
      "name": "On",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ]
    },
    {
      "name": "OnPart",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Parameter",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "ParameterMapping",
      "properties": [
        {
          "name": "sourceRef",
          "type": "Parameter",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "targetRef",
          "type": "Parameter",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "transformation",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "PlanFragment",
      "superClass": [
        "PlanItemDefinition"
      ],
      "properties": [
        {
          "name": "planItems",
          "type": "PlanItem",
          "isMany": true
        },
        {
          "name": "sentries",
          "type": "Sentry",
          "isMany": true
        }
      ]
    },
    {
      "name": "PlanItem",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "definitionRef",
          "type": "PlanItemDefinition",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "itemControl",
          "type": "PlanItemControl",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "entryCriteria",
          "type": "EntryCriterion",
          "isMany": true
        },
        {
          "name": "exitCriteria",
          "type": "ExitCriterion",
          "isMany": true
        }
      ]
    },
    {
      "name": "PlanItemControl",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "repetitionRule",
          "type": "RepetitionRule"
        },
        {
          "name": "requiredRule",
          "type": "RequiredRule"
        },
        {
          "name": "manualActivationRule",
          "type": "ManualActivationRule"
        }
      ]
    },
    {
      "name": "PlanItemDefinition",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "defaultControl",
          "type": "PlanItemControl",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "PlanItemOnPart",
      "superClass": [
        "OnPart"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String"
        },
        {
          "name": "sourceRef",
          "type": "PlanItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "exitCriterionRef",
          "type": "ExitCriterion",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "PlanningTable",
      "superClass": [
        "TableItem"
      ],
      "properties": [
        {
          "name": "tableItems",
          "type": "TableItem",
          "isMany": true
        },
        {
          "name": "applicabilityRules",
          "type": "ApplicabilityRule",
          "isMany": true
        }
      ]
    },
    {
      "name": "Process",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "implementationType",
          "type": "String",
          "isAttr": true,
          "default": "http://www.omg.org/spec/CMMN/ProcessType/Unspecified"
        },
        {
          "name": "externalRef",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "input",
          "type": "ProcessParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "ProcessParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "ProcessParameter",
      "superClass": [
        "Parameter"
      ]
    },
    {
      "name": "ProcessTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "parameterMapping",
          "type": "ParameterMapping",
          "isMany": true
        },
        {
          "name": "processRefExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "processRef",
          "type": "String",
          "isAttr": true
        }
      ]
    },
    {
      "name": "Property",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "type",
          "type": "String",
          "isAttr": true,
          "default": "http://www.omg.org/spec/CMMN/PropertyType/Unspecified"
        }
      ]
    },
    {
      "name": "RepetitionRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "RequiredRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Role",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Sentry",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "onParts",
          "type": "OnPart",
          "isMany": true
        },
        {
          "name": "ifPart",
          "type": "IfPart"
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Stage",
      "superClass": [
        "PlanFragment"
      ],
      "properties": [
        {
          "name": "planningTable",
          "type": "PlanningTable"
        },
        {
          "name": "planItemDefinitions",
          "type": "PlanItemDefinition",
          "isMany": true
        },
        {
          "name": "autoComplete",
          "isAttr": true,
          "type": "Boolean"
        },
        {
          "name": "exitCriteria",
          "type": "ExitCriterion",
          "isMany": true
        }
      ]
    },
    {
      "name": "TableItem",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "authorizedRoleRefs",
          "type": "Role",
          "isAttr": true,
          "isReference": true,
          "isMany": true
        },
        {
          "name": "applicabilityRuleRefs",
          "type": "ApplicabilityRule",
          "isAttr": true,
          "isReference": true,
          "isMany": true
        }
      ]
    },
    {
      "name": "Task",
      "superClass": [
        "PlanItemDefinition"
      ],
      "properties": [
        {
          "name": "input",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "isBlocking",
          "isAttr": true,
          "default": true,
          "type": "Boolean"
        }
      ]
    },
    {
      "name": "TimerEventListener",
      "superClass": [
        "EventListener"
      ],
      "properties": [
        {
          "name": "timerExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "timerStart",
          "type": "StartTrigger"
        }
      ]
    },
    {
      "name": "UserEventListener",
      "superClass": [
        "EventListener"
      ],
      "properties": [
        {
          "name": "authorizedRoleRefs",
          "type": "Role",
          "isMany": true,
          "isAttr": true
        }
      ]
    },
    {
      "name": "DateTime",
      "superClass": []
    },
    {
      "name": "StartTrigger",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ]
    },
    {
      "name": "PlanItemStartTrigger",
      "superClass": [
        "StartTrigger"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "sourceRef",
          "type": "PlanItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "CaseFileItemStartTrigger",
      "superClass": [
        "StartTrigger"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "sourceRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Extension",
      "properties": [
        {
          "name": "mustUnderstand",
          "default": false,
          "isAttr": true,
          "type": "Boolean"
        },
        {
          "name": "definition",
          "type": "ExtensionDefinition"
        }
      ]
    },
    {
      "name": "ExtensionDefinition",
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "extensionAttributeDefinitions",
          "type": "ExtensionAttributeDefinition",
          "isMany": true
        }
      ]
    },
    {
      "name": "ExtensionAttributeDefinition",
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "type",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "isReference",
          "isAttr": true,
          "default": false,
          "type": "Boolean"
        }
      ]
    },
    {
      "name": "ExtensionElements",
      "properties": [
        {
          "name": "valueRef",
          "isAttr": true,
          "isReference": true,
          "type": "Element"
        },
        {
          "name": "values",
          "type": "Element",
          "isMany": true
        },
        {
          "name": "extensionAttributeDefinition",
          "type": "ExtensionAttributeDefinition",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Relationship",
      "properties": [
        {
          "name": "type",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "direction",
          "type": "RelationshipDirection",
          "isAttr": true
        },
        {
          "name": "source",
          "isMany": true,
          "type": "Element"
        },
        {
          "name": "target",
          "isMany": true,
          "type": "Element"
        }
      ]
    },
    {
      "name": "Documentation",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "text",
          "type": "String",
          "isBody": true
        },
        {
          "name": "textFormat",
          "default": "text/plain",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "DecisionTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "mappings",
          "type": "ParameterMapping",
          "isMany": true
        },
        {
          "name": "decisionRef",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "decisionRefExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "Decision",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "implementationType",
          "type": "String",
          "isAttr": true,
          "default": "http://www.omg.org/spec/CMMN/DecisionType/Unspecified"
        },
        {
          "name": "input",
          "type": "DecisionParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "DecisionParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "externalRef",
          "type": "String",
          "isAttr": true
        }
      ]
    },
    {
      "name": "DecisionParameter",
      "superClass": [
        "Parameter"
      ]
    },
    {
      "name": "Criterion",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "sentryRef",
          "type": "Sentry",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "EntryCriterion",
      "superClass": [
        "Criterion"
      ]
    },
    {
      "name": "ExitCriterion",
      "superClass": [
        "Criterion"
      ]
    }
  ],
  "emumerations": [
    {
      "name": "AssociationDirection",
      "literalValues": [
        {
          "name": "None"
        },
        {
          "name": "One"
        },
        {
          "name": "Both"
        }
      ]
    },
    {
      "name": "CaseFileItemTransition",
      "literalValues": [
        {
          "name": "addChild"
        },
        {
          "name": "addReference"
        },
        {
          "name": "create"
        },
        {
          "name": "delete"
        },
        {
          "name": "removeChild"
        },
        {
          "name": "removeReference"
        },
        {
          "name": "replace"
        },
        {
          "name": "update"
        }
      ]
    },
    {
      "name": "MultiplicityEnum",
      "literalValues": [
        {
          "name": "ZeroOrOne"
        },
        {
          "name": "ZeroOrMore"
        },
        {
          "name": "ExactlyOne"
        },
        {
          "name": "OneOrMore"
        },
        {
          "name": "Unspecified"
        },
        {
          "name": "Unknown"
        }
      ]
    },
    {
      "name": "PlanItemTransition",
      "literalValues": [
        {
          "name": "close"
        },
        {
          "name": "complete"
        },
        {
          "name": "create"
        },
        {
          "name": "disable"
        },
        {
          "name": "enable"
        },
        {
          "name": "exit"
        },
        {
          "name": "fault"
        },
        {
          "name": "manualStart"
        },
        {
          "name": "occur"
        },
        {
          "name": "parentResume"
        },
        {
          "name": "parentSuspend"
        },
        {
          "name": "reactivate"
        },
        {
          "name": "reenable"
        },
        {
          "name": "resume"
        },
        {
          "name": "start"
        },
        {
          "name": "suspend"
        },
        {
          "name": "terminate"
        }
      ]
    },
    {
      "name": "RelationshipDirection",
      "literalValues": [
        {
          "name": "None"
        },
        {
          "name": "Forward"
        },
        {
          "name": "Backward"
        },
        {
          "name": "Both"
        }
      ]
    }
  ],
  "associations": [],
  "xml": {
    "tagAlias": "lowerCase",
    "typePrefix": "t"
  },
  "prefix": "cmmn"
}
},{}],80:[function(_dereq_,module,exports){
module.exports={
  "name": "CMMNDI",
  "uri": "http://www.omg.org/spec/CMMN/20151109/CMMNDI",
  "types": [
  	{
  	  "name": "CMMNDI",
  	  "properties": [
  	    {
  	      "name": "diagrams",
  	      "type": "CMMNDiagram",
  	      "isMany": true
  	    },
  	  	{
  	  	  "name": "styles",
  	  	  "type": "CMMNStyle",
  	  	  "isMany": true
  	  	}
  	  ]
  	},

    {
      "name": "CMMNDiagram",
      "properties": [
        {
          "name": "cmmnElementRef",
          "isAttr": true,
          "type": "cmmn:CMMNElement",
          "isReference": true
        },
        {
          "name": "Size",
          "type": "dc:Dimension",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "diagramElements",
          "type": "CMMNDiagramElement",
          "isMany": true
        }
      ],
      "superClass": [
        "di:Diagram"
      ]
    },

    {
      "name": "CMMNDiagramElement",
      "superClass": [
        "di:DiagramElement"
      ]
    },

    {
      "name": "CMMNShape",
      "properties": [
        {
          "name": "cmmnElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "label",
          "type": "CMMNLabel"
        },
        {
          "name": "isCollapsed",
          "isAttr": true,
          "type": "Boolean"
        },
        {
          "name": "isPlanningTableCollapsed",
          "isAttr": true,
          "type": "Boolean"
        }
      ],
      "superClass": [
        "CMMNDiagramElement", "di:Shape"
      ]
    },
    {
      "name": "CMMNEdge",
      "properties": [
        {
          "name": "label",
          "type": "CMMNLabel"
        },
        {
          "name": "cmmnElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "sourceCMMNElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "targetCMMNElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "isStandardEventVisible",
          "type": "Boolean",
          "isAttr": true
        }
      ],
      "superClass": [
        "CMMNDiagramElement", "di:Edge"
      ]
    },
    {
      "name": "CMMNLabel",
      "superClass": [
        "di:Shape"
      ]
    },
    {
      "name": "CMMNStyle",
      "properties": [
        {
          "name": "FillColor",
          "type": "dc:Color",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "StrokeColor",
          "type": "dc:Color",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "FontColor",
          "type": "dc:Color",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "fontFamily",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "fontSize",
          "type": "Real",
          "isAttr": true
        },
        {
          "name": "fontItalic",
          "type": "Boolean",
          "isAttr": true
        },
        {
          "name": "fontBold",
          "type": "Boolean",
          "isAttr": true
        },
        {
          "name": "fontUnderline",
          "type": "Boolean",
          "isAttr": true
        },
        {
          "name": "fontStrikeThrough",
          "type": "Boolean",
          "isAttr": true
        }
      ],
      "superClass": [
        "di:Style"
      ]
    }
  ],
  "associations": [],
  "prefix": "cmmndi"
}
},{}],81:[function(_dereq_,module,exports){
module.exports={
  "name": "DC",
  "uri": "http://www.omg.org/spec/CMMN/20151109/DC",
  "types": [
    {
      "name": "rgb"
    },
    {
      "name": "Real"
    },
  	{
  	  "name": "Color",
  	  "properties" : [
  	  	{
  	  	  "name": "red",
  	  	  "type": "rgb",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "green",
  	  	  "type": "rgb",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "blue",
  	  	  "type": "rgb",
  	  	  "isAttr": true
  	  	}
  	  ]
  	},
  	
  	{
  	  "name": "Point",
  	  "properties" : [
  	  	{
  	  	  "name": "x",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "y",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	}
  	  ]
  	},
  	
  	{
  	  "name": "Dimension",
  	  "properties" : [
  	  	{
  	  	  "name": "width",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "height",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	}
  	  ]
  	},
  	
  	{
  	  "name": "Bounds",
  	  "properties" : [
  	  	{
  	  	  "name": "x",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "y",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "width",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "height",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	}
  	  ]
  	}
  ],
  "prefix": "dc",
  "associations": []
}
},{}],82:[function(_dereq_,module,exports){
module.exports={
  "name": "DI",
  "uri": "http://www.omg.org/spec/CMMN/20151109/DI",
  "types": [
    {
      "name": "DiagramElement",
      "isAbstract": true,
      "properties": [
        {
          "name": "extension",
          "type": "Extension"
        },
        {
          "name": "style",
          "type": "Style"
        },
        {
          "name": "sharedStyle",
          "type": "Style",
          "isReference": true,
          "isAttr": true
        },
        {
          "name": "id",
          "type": "String",
          "isAttr": true,
          "isId": true
        }
      ]
    },

    {
      "name": "Edge",
      "isAbstract": true,
      "superClass": [
        "DiagramElement"
      ],
      "properties": [
        {
          "name": "waypoint",
          "isMany": true,
          "type": "dc:Point",
          "xml": {
            "serialize": "xsi:type"
          }
        }
      ]
    },
    {
      "name": "Diagram",
      "isAbstract": true,
      "superClass": [
        "DiagramElement"
      ],
      "properties": [
        {
          "name": "name",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "documentation",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "resolution",
          "isAttr": true,
          "default": 300,
          "type": "double"
        }
      ]
    },
    {
      "name": "Shape",
      "isAbstract": true,
      "superClass": [
        "DiagramElement"
      ],
      "properties": [
        {
          "name": "bounds",
          "type": "dc:Bounds"
        }
      ]
    },

    {
      "name": "Style",
      "isAbstract": true,
      "properties": [
        {
          "name": "extension",
          "type": "Extension"
        },
        {
          "name": "id",
          "type": "String",
          "isAttr": true,
          "isId": true
        }
      ]
    },

    {
      "name": "Extension",
      "properties": [
        {
          "name": "values",
          "type": "Element",
          "isMany": true
        }
      ]
    }
  ],
  "associations": [],
  "prefix": "di",
  "xml": {
    "tagAlias": "lowerCase"
  }
}
},{}],83:[function(_dereq_,module,exports){
/**
 * Module dependencies.
 */

try {
  var index = _dereq_(87);
} catch (err) {
  var index = _dereq_(87);
}

/**
 * Whitespace regexp.
 */

var re = /\s+/;

/**
 * toString reference.
 */

var toString = Object.prototype.toString;

/**
 * Wrap `el` in a `ClassList`.
 *
 * @param {Element} el
 * @return {ClassList}
 * @api public
 */

module.exports = function(el){
  return new ClassList(el);
};

/**
 * Initialize a new ClassList for `el`.
 *
 * @param {Element} el
 * @api private
 */

function ClassList(el) {
  if (!el || !el.nodeType) {
    throw new Error('A DOM element reference is required');
  }
  this.el = el;
  this.list = el.classList;
}

/**
 * Add class `name` if not already present.
 *
 * @param {String} name
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.add = function(name){
  // classList
  if (this.list) {
    this.list.add(name);
    return this;
  }

  // fallback
  var arr = this.array();
  var i = index(arr, name);
  if (!~i) arr.push(name);
  this.el.className = arr.join(' ');
  return this;
};

/**
 * Remove class `name` when present, or
 * pass a regular expression to remove
 * any which match.
 *
 * @param {String|RegExp} name
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.remove = function(name){
  if ('[object RegExp]' == toString.call(name)) {
    return this.removeMatching(name);
  }

  // classList
  if (this.list) {
    this.list.remove(name);
    return this;
  }

  // fallback
  var arr = this.array();
  var i = index(arr, name);
  if (~i) arr.splice(i, 1);
  this.el.className = arr.join(' ');
  return this;
};

/**
 * Remove all classes matching `re`.
 *
 * @param {RegExp} re
 * @return {ClassList}
 * @api private
 */

ClassList.prototype.removeMatching = function(re){
  var arr = this.array();
  for (var i = 0; i < arr.length; i++) {
    if (re.test(arr[i])) {
      this.remove(arr[i]);
    }
  }
  return this;
};

/**
 * Toggle class `name`, can force state via `force`.
 *
 * For browsers that support classList, but do not support `force` yet,
 * the mistake will be detected and corrected.
 *
 * @param {String} name
 * @param {Boolean} force
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.toggle = function(name, force){
  // classList
  if (this.list) {
    if ("undefined" !== typeof force) {
      if (force !== this.list.toggle(name, force)) {
        this.list.toggle(name); // toggle again to correct
      }
    } else {
      this.list.toggle(name);
    }
    return this;
  }

  // fallback
  if ("undefined" !== typeof force) {
    if (!force) {
      this.remove(name);
    } else {
      this.add(name);
    }
  } else {
    if (this.has(name)) {
      this.remove(name);
    } else {
      this.add(name);
    }
  }

  return this;
};

/**
 * Return an array of classes.
 *
 * @return {Array}
 * @api public
 */

ClassList.prototype.array = function(){
  var className = this.el.getAttribute('class') || '';
  var str = className.replace(/^\s+|\s+$/g, '');
  var arr = str.split(re);
  if ('' === arr[0]) arr.shift();
  return arr;
};

/**
 * Check if class `name` is present.
 *
 * @param {String} name
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.has =
ClassList.prototype.contains = function(name){
  return this.list
    ? this.list.contains(name)
    : !! ~index(this.array(), name);
};

},{"87":87}],84:[function(_dereq_,module,exports){
var matches = _dereq_(88)

module.exports = function (element, selector, checkYoSelf, root) {
  element = checkYoSelf ? {parentNode: element} : element

  root = root || document

  // Make sure `element !== document` and `element != null`
  // otherwise we get an illegal invocation
  while ((element = element.parentNode) && element !== document) {
    if (matches(element, selector))
      return element
    // After `matches` on the edge case that
    // the selector matches the root
    // (when the root is not the document)
    if (element === root)
      return
  }
}

},{"88":88}],85:[function(_dereq_,module,exports){
/**
 * Module dependencies.
 */

try {
  var closest = _dereq_(84);
} catch(err) {
  var closest = _dereq_(84);
}

try {
  var event = _dereq_(86);
} catch(err) {
  var event = _dereq_(86);
}

/**
 * Delegate event `type` to `selector`
 * and invoke `fn(e)`. A callback function
 * is returned which may be passed to `.unbind()`.
 *
 * @param {Element} el
 * @param {String} selector
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @return {Function}
 * @api public
 */

exports.bind = function(el, selector, type, fn, capture){
  return event.bind(el, type, function(e){
    var target = e.target || e.srcElement;
    e.delegateTarget = closest(target, selector, true, el);
    if (e.delegateTarget) fn.call(el, e);
  }, capture);
};

/**
 * Unbind event `type`'s callback `fn`.
 *
 * @param {Element} el
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @api public
 */

exports.unbind = function(el, type, fn, capture){
  event.unbind(el, type, fn, capture);
};

},{"84":84,"86":86}],86:[function(_dereq_,module,exports){
var bind = window.addEventListener ? 'addEventListener' : 'attachEvent',
    unbind = window.removeEventListener ? 'removeEventListener' : 'detachEvent',
    prefix = bind !== 'addEventListener' ? 'on' : '';

/**
 * Bind `el` event `type` to `fn`.
 *
 * @param {Element} el
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @return {Function}
 * @api public
 */

exports.bind = function(el, type, fn, capture){
  el[bind](prefix + type, fn, capture || false);
  return fn;
};

/**
 * Unbind `el` event `type`'s callback `fn`.
 *
 * @param {Element} el
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @return {Function}
 * @api public
 */

exports.unbind = function(el, type, fn, capture){
  el[unbind](prefix + type, fn, capture || false);
  return fn;
};
},{}],87:[function(_dereq_,module,exports){
module.exports = function(arr, obj){
  if (arr.indexOf) return arr.indexOf(obj);
  for (var i = 0; i < arr.length; ++i) {
    if (arr[i] === obj) return i;
  }
  return -1;
};
},{}],88:[function(_dereq_,module,exports){
/**
 * Module dependencies.
 */

try {
  var query = _dereq_(89);
} catch (err) {
  var query = _dereq_(89);
}

/**
 * Element prototype.
 */

var proto = Element.prototype;

/**
 * Vendor function.
 */

var vendor = proto.matches
  || proto.webkitMatchesSelector
  || proto.mozMatchesSelector
  || proto.msMatchesSelector
  || proto.oMatchesSelector;

/**
 * Expose `match()`.
 */

module.exports = match;

/**
 * Match `el` to `selector`.
 *
 * @param {Element} el
 * @param {String} selector
 * @return {Boolean}
 * @api public
 */

function match(el, selector) {
  if (!el || el.nodeType !== 1) return false;
  if (vendor) return vendor.call(el, selector);
  var nodes = query.all(selector, el.parentNode);
  for (var i = 0; i < nodes.length; ++i) {
    if (nodes[i] == el) return true;
  }
  return false;
}

},{"89":89}],89:[function(_dereq_,module,exports){
function one(selector, el) {
  return el.querySelector(selector);
}

exports = module.exports = function(selector, el){
  el = el || document;
  return one(selector, el);
};

exports.all = function(selector, el){
  el = el || document;
  return el.querySelectorAll(selector);
};

exports.engine = function(obj){
  if (!obj.one) throw new Error('.one callback required');
  if (!obj.all) throw new Error('.all callback required');
  one = obj.one;
  exports.all = obj.all;
  return exports;
};

},{}],90:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [ _dereq_(94) ],
  __init__: [ 'directEditing' ],
  directEditing: [ 'type', _dereq_(91) ]
};
},{"91":91,"94":94}],91:[function(_dereq_,module,exports){
'use strict';

var bind = _dereq_(279),
    find = _dereq_(270);

var TextBox = _dereq_(92);


/**
 * A direct editing component that allows users
 * to edit an elements text directly in the diagram
 *
 * @param {EventBus} eventBus the event bus
 */
function DirectEditing(eventBus, canvas) {

  this._eventBus = eventBus;

  this._providers = [];
  this._textbox = new TextBox({
    container: canvas.getContainer(),
    keyHandler: bind(this._handleKey, this)
  });
}

DirectEditing.$inject = [ 'eventBus', 'canvas' ];


/**
 * Register a direct editing provider

 * @param {Object} provider the provider, must expose an #activate(element) method that returns
 *                          an activation context ({ bounds: {x, y, width, height }, text }) if
 *                          direct editing is available for the given element.
 *                          Additionally the provider must expose a #update(element, value) method
 *                          to receive direct editing updates.
 */
DirectEditing.prototype.registerProvider = function(provider) {
  this._providers.push(provider);
};


/**
 * Returns true if direct editing is currently active
 *
 * @return {Boolean}
 */
DirectEditing.prototype.isActive = function() {
  return !!this._active;
};


/**
 * Cancel direct editing, if it is currently active
 */
DirectEditing.prototype.cancel = function() {
  if (!this._active) {
    return;
  }

  this._fire('cancel');
  this.close();
};


DirectEditing.prototype._fire = function(event) {
  this._eventBus.fire('directEditing.' + event, { active: this._active });
};

DirectEditing.prototype.close = function() {
  this._textbox.destroy();

  this._fire('deactivate');

  this._active = null;
};


DirectEditing.prototype.complete = function() {

  var active = this._active;

  if (!active) {
    return;
  }

  var text = this.getValue();

  if (text !== active.context.text) {
    active.provider.update(active.element, text, active.context.text);
  }

  this._fire('complete');

  this.close();
};


DirectEditing.prototype.getValue = function() {
  return this._textbox.getValue();
};


DirectEditing.prototype._handleKey = function(e) {

  // stop bubble
  e.stopPropagation();

  var key = e.keyCode || e.charCode;

  // ESC
  if (key === 27) {
    e.preventDefault();
    return this.cancel();
  }

  // Enter
  if (key === 13 && !e.shiftKey) {
    e.preventDefault();
    return this.complete();
  }
};


/**
 * Activate direct editing on the given element
 *
 * @param {Object} ElementDescriptor the descriptor for a shape or connection
 * @return {Boolean} true if the activation was possible
 */
DirectEditing.prototype.activate = function(element) {

  if (this.isActive()) {
    this.cancel();
  }

  // the direct editing context
  var context;

  var provider = find(this._providers, function(p) {
    return !!(context = p.activate(element)) ? p : null;
  });

  // check if activation took place
  if (context) {
    this._textbox.create(context.bounds, context.style, context.text);

    this._active = {
      element: element,
      context: context,
      provider: provider
    };

    this._fire('activate');
  }

  return !!context;
};


module.exports = DirectEditing;
},{"270":270,"279":279,"92":92}],92:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    domEvent = _dereq_(416),
    domRemove = _dereq_(419);

function stopPropagation(event) {
  event.stopPropagation();
}

function TextBox(options) {

  this.container = options.container;
  this.textarea = document.createElement('textarea');

  this.keyHandler = options.keyHandler || function() {};
}

module.exports = TextBox;


TextBox.prototype.create = function(bounds, style, value) {

  var textarea = this.textarea,
      container = this.container;

  assign(textarea.style, {
    width: bounds.width + 'px',
    height: bounds.height + 'px',
    left: bounds.x + 'px',
    top: bounds.y + 'px',
    position: 'absolute',
    textAlign: 'center',
    boxSizing: 'border-box'
  }, style || {});

  textarea.value = value;
  textarea.title = 'Press SHIFT+Enter for line feed';

  domEvent.bind(textarea, 'keydown', this.keyHandler);
  domEvent.bind(textarea, 'mousedown', stopPropagation);

  container.appendChild(textarea);

  setTimeout(function() {
    if (textarea.parent) {
      textarea.select();
    }
    textarea.focus();
  }, 100);
};

TextBox.prototype.destroy = function() {
  var textarea = this.textarea;

  textarea.value = '';

  domEvent.unbind(textarea, 'keydown', this.keyHandler);
  domEvent.unbind(textarea, 'mousedown', stopPropagation);

  domRemove(textarea);
};

TextBox.prototype.getValue = function() {
  return this.textarea.value;
};

},{"398":398,"416":416,"419":419}],93:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    domDelegate = _dereq_(414);


var isPrimaryButton = _dereq_(96).isPrimaryButton;

var Snap = _dereq_(99);

var renderUtil = _dereq_(98);

var createLine = renderUtil.createLine,
    updateLine = renderUtil.updateLine;

/**
 * A plugin that provides interaction events for diagram elements.
 *
 * It emits the following events:
 *
 *   * element.hover
 *   * element.out
 *   * element.click
 *   * element.dblclick
 *   * element.mousedown
 *
 * Each event is a tuple { element, gfx, originalEvent }.
 *
 * Canceling the event via Event#preventDefault() prevents the original DOM operation.
 *
 * @param {EventBus} eventBus
 */
function InteractionEvents(eventBus, elementRegistry, styles) {

  var HIT_STYLE = styles.cls('djs-hit', [ 'no-fill', 'no-border' ], {
    stroke: 'white',
    strokeWidth: 15
  });

  /**
   * Fire an interaction event.
   *
   * @param {String} type local event name, e.g. element.click.
   * @param {DOMEvent} event native event
   * @param {djs.model.Base} [element] the diagram element to emit the event on;
   *                                   defaults to the event target
   */
  function fire(type, event, element) {

    // only react on left mouse button interactions
    // for interaction events
    if (!isPrimaryButton(event)) {
      return;
    }

    var target, gfx, returnValue;

    if (!element) {
      target = event.delegateTarget || event.target;

      if (target) {
        gfx = new Snap(target);
        element = elementRegistry.get(gfx);
      }
    } else {
      gfx = elementRegistry.getGraphics(element);
    }

    if (!gfx || !element) {
      return;
    }

    returnValue = eventBus.fire(type, { element: element, gfx: gfx, originalEvent: event });

    if (returnValue === false) {
      event.stopPropagation();
      event.preventDefault();
    }
  }

  // TODO(nikku): document this
  var handlers = {};

  function mouseHandler(type) {

    var fn = handlers[type];

    if (!fn) {
      fn = handlers[type] = function(event) {
        fire(type, event);
      };
    }

    return fn;
  }

  var bindings = {
    mouseover: 'element.hover',
    mouseout: 'element.out',
    click: 'element.click',
    dblclick: 'element.dblclick',
    mousedown: 'element.mousedown',
    mouseup: 'element.mouseup'
  };


  ///// manual event trigger

  /**
   * Trigger an interaction event (based on a native dom event)
   * on the target shape or connection.
   *
   * @param {String} eventName the name of the triggered DOM event
   * @param {MouseEvent} event
   * @param {djs.model.Base} targetElement
   */
  function triggerMouseEvent(eventName, event, targetElement) {

    // i.e. element.mousedown...
    var localEventName = bindings[eventName];

    if (!localEventName) {
      throw new Error('unmapped DOM event name <' + eventName + '>');
    }

    return fire(localEventName, event, targetElement);
  }


  var elementSelector = 'svg, .djs-element';

  ///// event registration

  function registerEvent(node, event, localEvent) {
    var handler = mouseHandler(localEvent);
    handler.$delegate = domDelegate.bind(node, elementSelector, event, handler);
  }

  function unregisterEvent(node, event, localEvent) {
    domDelegate.unbind(node, event, mouseHandler(localEvent).$delegate);
  }

  function registerEvents(svg) {
    forEach(bindings, function(val, key) {
      registerEvent(svg.node, key, val);
    });
  }

  function unregisterEvents(svg) {
    forEach(bindings, function(val, key) {
      unregisterEvent(svg.node, key, val);
    });
  }

  eventBus.on('canvas.destroy', function(event) {
    unregisterEvents(event.svg);
  });

  eventBus.on('canvas.init', function(event) {
    registerEvents(event.svg);
  });


  eventBus.on([ 'shape.added', 'connection.added' ], function(event) {
    var element = event.element,
        gfx = event.gfx,
        hit;

    if (element.waypoints) {
      hit = createLine(element.waypoints);
    } else {
      hit = Snap.create('rect', { x: 0, y: 0, width: element.width, height: element.height });
    }

    hit.attr(HIT_STYLE).appendTo(gfx.node);
  });

  // update djs-hit on change

  eventBus.on('shape.changed', function(event) {

    var element = event.element,
        gfx = event.gfx,
        hit = gfx.select('.djs-hit');

    hit.attr({
      width: element.width,
      height: element.height
    });
  });

  eventBus.on('connection.changed', function(event) {

    var element = event.element,
        gfx = event.gfx,
        hit = gfx.select('.djs-hit');

    updateLine(hit, element.waypoints);
  });


  // API

  this.fire = fire;

  this.triggerMouseEvent = triggerMouseEvent;

  this.mouseHandler = mouseHandler;

  this.registerEvent = registerEvent;
  this.unregisterEvent = unregisterEvent;
}


InteractionEvents.$inject = [ 'eventBus', 'elementRegistry', 'styles' ];

module.exports = InteractionEvents;


/**
 * An event indicating that the mouse hovered over an element
 *
 * @event element.hover
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {Snap<Element>} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has left an element
 *
 * @event element.out
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {Snap<Element>} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has clicked an element
 *
 * @event element.click
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {Snap<Element>} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has double clicked an element
 *
 * @event element.dblclick
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {Snap<Element>} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has gone down on an element.
 *
 * @event element.mousedown
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {Snap<Element>} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has gone up on an element.
 *
 * @event element.mouseup
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {Snap<Element>} gfx
 * @property {Event} originalEvent
 */

},{"271":271,"414":414,"96":96,"98":98,"99":99}],94:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'interactionEvents' ],
  interactionEvents: [ 'type', _dereq_(93) ]
};
},{"93":93}],95:[function(_dereq_,module,exports){
'use strict';

function __preventDefault(event) {
  return event && event.preventDefault();
}

function __stopPropagation(event, immediate) {
  if (!event) {
    return;
  }

  if (event.stopPropagation) {
    event.stopPropagation();
  }

  if (immediate && event.stopImmediatePropagation) {
    event.stopImmediatePropagation();
  }
}


function getOriginal(event) {
  return event.originalEvent || event.srcEvent;
}

module.exports.getOriginal = getOriginal;


function stopEvent(event, immediate) {
  stopPropagation(event, immediate);
  preventDefault(event);
}

module.exports.stopEvent = stopEvent;


function preventDefault(event) {
  __preventDefault(event);
  __preventDefault(getOriginal(event));
}

module.exports.preventDefault = preventDefault;


function stopPropagation(event, immediate) {
  __stopPropagation(event, immediate);
  __stopPropagation(getOriginal(event), immediate);
}

module.exports.stopPropagation = stopPropagation;


function toPoint(event) {

  if (event.pointers && event.pointers.length) {
    event = event.pointers[0];
  }

  if (event.touches && event.touches.length) {
    event = event.touches[0];
  }

  return event ? {
    x: event.clientX,
    y: event.clientY
  } : null;
}

module.exports.toPoint = toPoint;

},{}],96:[function(_dereq_,module,exports){
'use strict';

var getOriginalEvent = _dereq_(95).getOriginal;

var isMac = _dereq_(97).isMac;


function isPrimaryButton(event) {
  // button === 0 -> left áka primary mouse button
  return !(getOriginalEvent(event) || event).button;
}

module.exports.isPrimaryButton = isPrimaryButton;

module.exports.isMac = isMac;

module.exports.hasPrimaryModifier = function(event) {
  var originalEvent = getOriginalEvent(event) || event;

  if (!isPrimaryButton(event)) {
    return false;
  }

  // Use alt as primary modifier key for mac OS
  if (isMac()) {
    return originalEvent.metaKey;
  } else {
    return originalEvent.ctrlKey;
  }
};


module.exports.hasSecondaryModifier = function(event) {
  var originalEvent = getOriginalEvent(event) || event;

  return isPrimaryButton(event) && originalEvent.shiftKey;
};

},{"95":95,"97":97}],97:[function(_dereq_,module,exports){
'use strict';

module.exports.isMac = function isMac() {
  return (/mac/i).test(navigator.platform);
};
},{}],98:[function(_dereq_,module,exports){
'use strict';

var Snap = _dereq_(99);


module.exports.componentsToPath = function(elements) {
  return elements.join(',').replace(/,?([A-z]),?/g, '$1');
};

function toSVGPoints(points) {
  var result = '';

  for (var i = 0, p; (p = points[i]); i++) {
    result += p.x + ',' + p.y + ' ';
  }

  return result;
}

module.exports.toSVGPoints = toSVGPoints;

module.exports.createLine = function(points, attrs) {
  return Snap.create('polyline', { points: toSVGPoints(points) }).attr(attrs || {});
};

module.exports.updateLine = function(gfx, points) {
  return gfx.attr({ points: toSVGPoints(points) });
};

},{"99":99}],99:[function(_dereq_,module,exports){
'use strict';

var snapsvg = module.exports = _dereq_(436);

snapsvg.plugin(function(Snap, Element) {

  /*\
   * Element.children
   [ method ]
   **
   * Returns array of all the children of the element.
   = (array) array of Elements
  \*/
  Element.prototype.children = function () {
      var out = [],
          ch = this.node.childNodes;
      for (var i = 0, ii = ch.length; i < ii; i++) {
          out[i] = new Snap(ch[i]);
      }
      return out;
  };
});


/**
 * @class ClassPlugin
 *
 * Extends snapsvg with methods to add and remove classes
 */
snapsvg.plugin(function (Snap, Element, Paper, global) {

  function split(str) {
    return str.split(/\s+/);
  }

  function join(array) {
    return array.join(' ');
  }

  function getClasses(e) {
    return split(e.attr('class') || '');
  }

  function setClasses(e, classes) {
    e.attr('class', join(classes));
  }

  /**
   * @method snapsvg.Element#addClass
   *
   * @example
   *
   * e.attr('class', 'selector');
   *
   * e.addClass('foo bar'); // adds classes foo and bar
   * e.attr('class'); // -> 'selector foo bar'
   *
   * e.addClass('fooBar');
   * e.attr('class'); // -> 'selector foo bar fooBar'
   *
   * @param {String} cls classes to be added to the element
   *
   * @return {snapsvg.Element} the element (this)
   */
  Element.prototype.addClass = function(cls) {
    var current = getClasses(this),
        add = split(cls),
        i, e;

    for (i = 0, e; !!(e = add[i]); i++) {
      if (current.indexOf(e) === -1) {
        current.push(e);
      }
    }

    setClasses(this, current);

    return this;
  };

  /**
   * @method snapsvg.Element#hasClass
   *
   * @param  {String}  cls the class to query for
   * @return {Boolean} returns true if the element has the given class
   */
  Element.prototype.hasClass = function(cls) {
    if (!cls) {
      throw new Error('[snapsvg] syntax: hasClass(clsStr)');
    }

    return getClasses(this).indexOf(cls) !== -1;
  };

  /**
   * @method snapsvg.Element#removeClass
   *
   * @example
   *
   * e.attr('class', 'foo bar');
   *
   * e.removeClass('foo');
   * e.attr('class'); // -> 'bar'
   *
   * e.removeClass('foo bar'); // removes classes foo and bar
   * e.attr('class'); // -> ''
   *
   * @param {String} cls classes to be removed from element
   *
   * @return {snapsvg.Element} the element (this)
   */
  Element.prototype.removeClass = function(cls) {
    var current = getClasses(this),
        remove = split(cls),
        i, e, idx;

    for (i = 0, e; !!(e = remove[i]); i++) {
      idx = current.indexOf(e);

      if (idx !== -1) {
        // remove element from array
        current.splice(idx, 1);
      }
    }

    setClasses(this, current);

    return this;
  };

});

/**
 * @class TranslatePlugin
 *
 * Extends snapsvg with methods to translate elements
 */
snapsvg.plugin(function (Snap, Element, Paper, global) {

  /*
   * @method snapsvg.Element#translate
   *
   * @example
   *
   * e.translate(10, 20);
   *
   * // sets transform matrix to translate(10, 20)
   *
   * @param {Number} x translation
   * @param {Number} y translation
   *
   * @return {snapsvg.Element} the element (this)
   */
  Element.prototype.translate = function(x, y) {
    var matrix = new Snap.Matrix();
    matrix.translate(x, y);
    return this.transform(matrix);
  };
});


/**
 * @class CreatePlugin
 *
 * Create an svg element without attaching it to the dom
 */
snapsvg.plugin(function(Snap) {

  Snap.create = function(name, attrs) {
    return Snap._.wrap(Snap._.$(name, attrs));
  };
});


/**
 * @class CreatSnapAtPlugin
 *
 * Extends snap.svg with a method to create a SVG element
 * at a specific position in the DOM.
 */
snapsvg.plugin(function(Snap, Element, Paper, global) {

  /*
   * @method snapsvg.createSnapAt
   *
   * @example
   *
   * snapsvg.createSnapAt(parentNode, 200, 200);
   *
   * @param {Number} width of svg
   * @param {Number} height of svg
   * @param {Object} parentNode svg Element will be child of this
   *
   * @return {snapsvg.Element} the newly created wrapped SVG element instance
   */
  Snap.createSnapAt = function(width, height, parentNode) {

    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg.setAttribute('width', width);
    svg.setAttribute('height', height);
    if (!parentNode) {
      parentNode = document.body;
    }
    parentNode.appendChild(svg);

    return new Snap(svg);
  };
});
},{"436":436}],100:[function(_dereq_,module,exports){
module.exports = _dereq_(101);
},{"101":101}],101:[function(_dereq_,module,exports){
'use strict';

var di = _dereq_(250);


/**
 * Bootstrap an injector from a list of modules, instantiating a number of default components
 *
 * @ignore
 * @param {Array<didi.Module>} bootstrapModules
 *
 * @return {didi.Injector} a injector to use to access the components
 */
function bootstrap(bootstrapModules) {

  var modules = [],
      components = [];

  function hasModule(m) {
    return modules.indexOf(m) >= 0;
  }

  function addModule(m) {
    modules.push(m);
  }

  function visit(m) {
    if (hasModule(m)) {
      return;
    }

    (m.__depends__ || []).forEach(visit);

    if (hasModule(m)) {
      return;
    }

    addModule(m);

    (m.__init__ || []).forEach(function(c) {
      components.push(c);
    });
  }

  bootstrapModules.forEach(visit);

  var injector = new di.Injector(modules);

  components.forEach(function(c) {

    try {
      // eagerly resolve component (fn or string)
      injector[typeof c === 'string' ? 'get' : 'invoke'](c);
    } catch (e) {
      console.error('Failed to instantiate component');
      console.error(e.stack);

      throw e;
    }
  });

  return injector;
}

/**
 * Creates an injector from passed options.
 *
 * @ignore
 * @param  {Object} options
 * @return {didi.Injector}
 */
function createInjector(options) {

  options = options || {};

  var configModule = {
    'config': ['value', options]
  };

  var coreModule = _dereq_(110);

  var modules = [ configModule, coreModule ].concat(options.modules || []);

  return bootstrap(modules);
}


/**
 * The main diagram-js entry point that bootstraps the diagram with the given
 * configuration.
 *
 * To register extensions with the diagram, pass them as Array<didi.Module> to the constructor.
 *
 * @class djs.Diagram
 * @memberOf djs
 * @constructor
 *
 * @example
 *
 * <caption>Creating a plug-in that logs whenever a shape is added to the canvas.</caption>
 *
 * // plug-in implemenentation
 * function MyLoggingPlugin(eventBus) {
 *   eventBus.on('shape.added', function(event) {
 *     console.log('shape ', event.shape, ' was added to the diagram');
 *   });
 * }
 *
 * // export as module
 * module.exports = {
 *   __init__: [ 'myLoggingPlugin' ],
 *     myLoggingPlugin: [ 'type', MyLoggingPlugin ]
 * };
 *
 *
 * // instantiate the diagram with the new plug-in
 *
 * var diagram = new Diagram({ modules: [ require('path-to-my-logging-plugin') ] });
 *
 * diagram.invoke([ 'canvas', function(canvas) {
 *   // add shape to drawing canvas
 *   canvas.addShape({ x: 10, y: 10 });
 * });
 *
 * // 'shape ... was added to the diagram' logged to console
 *
 * @param {Object} options
 * @param {Array<didi.Module>} [options.modules] external modules to instantiate with the diagram
 * @param {didi.Injector} [injector] an (optional) injector to bootstrap the diagram with
 */
function Diagram(options, injector) {

  // create injector unless explicitly specified
  this.injector = injector = injector || createInjector(options);

  // API

  /**
   * Resolves a diagram service
   *
   * @method Diagram#get
   *
   * @param {String} name the name of the diagram service to be retrieved
   * @param {Boolean} [strict=true] if false, resolve missing services to null
   */
  this.get = injector.get;

  /**
   * Executes a function into which diagram services are injected
   *
   * @method Diagram#invoke
   *
   * @param {Function|Object[]} fn the function to resolve
   * @param {Object} locals a number of locals to use to resolve certain dependencies
   */
  this.invoke = injector.invoke;

  // init

  // indicate via event


  /**
   * An event indicating that all plug-ins are loaded.
   *
   * Use this event to fire other events to interested plug-ins
   *
   * @memberOf Diagram
   *
   * @event diagram.init
   *
   * @example
   *
   * eventBus.on('diagram.init', function() {
   *   eventBus.fire('my-custom-event', { foo: 'BAR' });
   * });
   *
   * @type {Object}
   */
  this.get('eventBus').fire('diagram.init');
}

module.exports = Diagram;


/**
 * Destroys the diagram
 *
 * @method  Diagram#destroy
 */
Diagram.prototype.destroy = function() {
  this.get('eventBus').fire('diagram.destroy');
};

/**
 * Clear the diagram, removing all contents.
 */
Diagram.prototype.clear = function() {
  this.get('eventBus').fire('diagram.clear');
};
},{"110":110,"250":250}],102:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    isFunction = _dereq_(390),
    isArray = _dereq_(389),
    isNumber = _dereq_(392);


var DEFAULT_PRIORITY = 1000;


function isObject(element) {
  return typeof element === 'object';
}

/**
 * A utility that can be used to plug-in into the command execution for
 * extension and/or validation.
 *
 * @param {EventBus} eventBus
 *
 * @example
 *
 * var inherits = require('inherits');
 *
 * var CommandInterceptor = require('diagram-js/lib/command/CommandInterceptor');
 *
 * function CommandLogger(eventBus) {
 *   CommandInterceptor.call(this, eventBus);
 *
 *   this.preExecute(function(event) {
 *     console.log('command pre-execute', event);
 *   });
 * }
 *
 * inherits(CommandLogger, CommandInterceptor);
 *
 */
function CommandInterceptor(eventBus) {
  this._eventBus = eventBus;
}

CommandInterceptor.$inject = [ 'eventBus' ];

module.exports = CommandInterceptor;

function unwrapEvent(fn, that) {
  return function(event) {
    return fn.call(that || null, event.context, event.command, event);
  };
}

/**
 * Register an interceptor for a command execution
 *
 * @param {String|Array<String>} [events] list of commands to register on
 * @param {String} [hook] command hook, i.e. preExecute, executed to listen on
 * @param {Number} [priority] the priority on which to hook into the execution
 * @param {Function} handlerFn interceptor to be invoked with (event)
 * @param {Boolean} unwrap if true, unwrap the event and pass (context, command, event) to the
 *                          listener instead
 * @param {Object} [that] Pass context (`this`) to the handler function
 */
CommandInterceptor.prototype.on = function(events, hook, priority, handlerFn, unwrap, that) {

  if (isFunction(hook) || isNumber(hook)) {
    that = unwrap;
    unwrap = handlerFn;
    handlerFn = priority;
    priority = hook;
    hook = null;
  }

  if (isFunction(priority)) {
    that = unwrap;
    unwrap = handlerFn;
    handlerFn = priority;
    priority = DEFAULT_PRIORITY;
  }

  if (isObject(unwrap)) {
    that = unwrap;
    unwrap = false;
  }

  if (!isFunction(handlerFn)) {
    throw new Error('handlerFn must be a function');
  }

  if (!isArray(events)) {
    events = [ events ];
  }

  var eventBus = this._eventBus;

  forEach(events, function(event) {
    // concat commandStack(.event)?(.hook)?
    var fullEvent = [ 'commandStack', event, hook ].filter(function(e) { return e; }).join('.');

    eventBus.on(fullEvent, priority, unwrap ? unwrapEvent(handlerFn, that) : handlerFn, that);
  });
};


var hooks = [
  'canExecute',
  'preExecute',
  'preExecuted',
  'execute',
  'executed',
  'postExecute',
  'postExecuted',
  'revert',
  'reverted'
];

/*
 * Install hook shortcuts
 *
 * This will generate the CommandInterceptor#(preExecute|...|reverted) methods
 * which will in term forward to CommandInterceptor#on.
 */
forEach(hooks, function(hook) {

  /**
   * {canExecute|preExecute|preExecuted|execute|executed|postExecute|postExecuted|revert|reverted}
   *
   * A named hook for plugging into the command execution
   *
   * @param {String|Array<String>} [events] list of commands to register on
   * @param {Number} [priority] the priority on which to hook into the execution
   * @param {Function} handlerFn interceptor to be invoked with (event)
   * @param {Boolean} [unwrap=false] if true, unwrap the event and pass (context, command, event) to the
   *                          listener instead
   * @param {Object} [that] Pass context (`this`) to the handler function
   */
  CommandInterceptor.prototype[hook] = function(events, priority, handlerFn, unwrap, that) {

    if (isFunction(events) || isNumber(events)) {
      that = unwrap;
      unwrap = handlerFn;
      handlerFn = priority;
      priority = events;
      events = null;
    }

    this.on(events, hook, priority, handlerFn, unwrap, that);
  };
});

},{"271":271,"389":389,"390":390,"392":392}],103:[function(_dereq_,module,exports){
'use strict';

var unique = _dereq_(264),
    isArray = _dereq_(389),
    assign = _dereq_(398);

var InternalEvent = _dereq_(108).Event;


/**
 * A service that offers un- and redoable execution of commands.
 *
 * The command stack is responsible for executing modeling actions
 * in a un- and redoable manner. To do this it delegates the actual
 * command execution to {@link CommandHandler}s.
 *
 * Command handlers provide {@link CommandHandler#execute(ctx)} and
 * {@link CommandHandler#revert(ctx)} methods to un- and redo a command
 * identified by a command context.
 *
 *
 * ## Life-Cycle events
 *
 * In the process the command stack fires a number of life-cycle events
 * that other components to participate in the command execution.
 *
 *    * preExecute
 *    * preExecuted
 *    * execute
 *    * executed
 *    * postExecute
 *    * postExecuted
 *    * revert
 *    * reverted
 *
 * A special event is used for validating, whether a command can be
 * performed prior to its execution.
 *
 *    * canExecute
 *
 * Each of the events is fired as `commandStack.{eventName}` and
 * `commandStack.{commandName}.{eventName}`, respectively. This gives
 * components fine grained control on where to hook into.
 *
 * The event object fired transports `command`, the name of the
 * command and `context`, the command context.
 *
 *
 * ## Creating Command Handlers
 *
 * Command handlers should provide the {@link CommandHandler#execute(ctx)}
 * and {@link CommandHandler#revert(ctx)} methods to implement
 * redoing and undoing of a command. They must ensure undo is performed
 * properly in order not to break the undo chain.
 *
 * Command handlers may execute other modeling operations (and thus
 * commands) in their `preExecute` and `postExecute` phases. The command
 * stack will properly group all commands together into a logical unit
 * that may be re- and undone atomically.
 *
 * Command handlers must not execute other commands from within their
 * core implementation (`execute`, `revert`).
 *
 *
 * ## Change Tracking
 *
 * During the execution of the CommandStack it will keep track of all
 * elements that have been touched during the command's execution.
 *
 * At the end of the CommandStack execution it will notify interested
 * components via an 'elements.changed' event with all the dirty
 * elements.
 *
 * The event can be picked up by components that are interested in the fact
 * that elements have been changed. One use case for this is updating
 * their graphical representation after moving / resizing or deletion.
 *
 *
 * @param {EventBus} eventBus
 * @param {Injector} injector
 */
function CommandStack(eventBus, injector) {

  /**
   * A map of all registered command handlers.
   *
   * @type {Object}
   */
  this._handlerMap = {};

  /**
   * A stack containing all re/undoable actions on the diagram
   *
   * @type {Array<Object>}
   */
  this._stack = [];

  /**
   * The current index on the stack
   *
   * @type {Number}
   */
  this._stackIdx = -1;

  /**
   * Current active commandStack execution
   *
   * @type {Object}
   */
  this._currentExecution = {
    actions: [],
    dirty: []
  };


  this._injector = injector;
  this._eventBus = eventBus;

  this._uid = 1;

  eventBus.on([ 'diagram.destroy', 'diagram.clear' ], this.clear, this);
}

CommandStack.$inject = [ 'eventBus', 'injector' ];

module.exports = CommandStack;


/**
 * Execute a command
 *
 * @param {String} command the command to execute
 * @param {Object} context the environment to execute the command in
 */
CommandStack.prototype.execute = function(command, context) {
  if (!command) {
    throw new Error('command required');
  }

  var action = { command: command, context: context };

  this._pushAction(action);
  this._internalExecute(action);
  this._popAction(action);
};


/**
 * Ask whether a given command can be executed.
 *
 * Implementors may hook into the mechanism on two ways:
 *
 *   * in event listeners:
 *
 *     Users may prevent the execution via an event listener.
 *     It must prevent the default action for `commandStack.(<command>.)canExecute` events.
 *
 *   * in command handlers:
 *
 *     If the method {@link CommandHandler#canExecute} is implemented in a handler
 *     it will be called to figure out whether the execution is allowed.
 *
 * @param  {String} command the command to execute
 * @param  {Object} context the environment to execute the command in
 *
 * @return {Boolean} true if the command can be executed
 */
CommandStack.prototype.canExecute = function(command, context) {

  var action = { command: command, context: context };

  var handler = this._getHandler(command);

  var result = this._fire(command, 'canExecute', action);

  // handler#canExecute will only be called if no listener
  // decided on a result already
  if (result === undefined) {
    if (!handler) {
      return false;
    }

    if (handler.canExecute) {
      result = handler.canExecute(context);
    }
  }

  return result;
};


/**
 * Clear the command stack, erasing all undo / redo history
 */
CommandStack.prototype.clear = function() {
  this._stack.length = 0;
  this._stackIdx = -1;

  this._fire('changed');
};


/**
 * Undo last command(s)
 */
CommandStack.prototype.undo = function() {
  var action = this._getUndoAction(),
      next;

  if (action) {
    this._pushAction(action);

    while (action) {
      this._internalUndo(action);
      next = this._getUndoAction();

      if (!next || next.id !== action.id) {
        break;
      }

      action = next;
    }

    this._popAction();
  }
};


/**
 * Redo last command(s)
 */
CommandStack.prototype.redo = function() {
  var action = this._getRedoAction(),
      next;

  if (action) {
    this._pushAction(action);

    while (action) {
      this._internalExecute(action, true);
      next = this._getRedoAction();

      if (!next || next.id !== action.id) {
        break;
      }

      action = next;
    }

    this._popAction();
  }
};


/**
 * Register a handler instance with the command stack
 *
 * @param {String} command
 * @param {CommandHandler} handler
 */
CommandStack.prototype.register = function(command, handler) {
  this._setHandler(command, handler);
};


/**
 * Register a handler type with the command stack
 * by instantiating it and injecting its dependencies.
 *
 * @param {String} command
 * @param {Function} a constructor for a {@link CommandHandler}
 */
CommandStack.prototype.registerHandler = function(command, handlerCls) {

  if (!command || !handlerCls) {
    throw new Error('command and handlerCls must be defined');
  }

  var handler = this._injector.instantiate(handlerCls);
  this.register(command, handler);
};

CommandStack.prototype.canUndo = function() {
  return !!this._getUndoAction();
};

CommandStack.prototype.canRedo = function() {
  return !!this._getRedoAction();
};

////// stack access  //////////////////////////////////////

CommandStack.prototype._getRedoAction = function() {
  return this._stack[this._stackIdx + 1];
};


CommandStack.prototype._getUndoAction = function() {
  return this._stack[this._stackIdx];
};


////// internal functionality /////////////////////////////

CommandStack.prototype._internalUndo = function(action) {
  var self = this;

  var command = action.command,
      context = action.context;

  var handler = this._getHandler(command);

  // guard against illegal nested command stack invocations
  this._atomicDo(function() {
    self._fire(command, 'revert', action);

    if (handler.revert) {
      self._markDirty(handler.revert(context));
    }

    self._revertedAction(action);

    self._fire(command, 'reverted', action);
  });
};


CommandStack.prototype._fire = function(command, qualifier, event) {
  if (arguments.length < 3) {
    event = qualifier;
    qualifier = null;
  }

  var names = qualifier ? [ command + '.' + qualifier, qualifier ] : [ command ],
      i, name, result;

  event = assign(new InternalEvent(), event);

  for (i = 0; (name = names[i]); i++) {
    result = this._eventBus.fire('commandStack.' + name, event);

    if (event.cancelBubble) {
      break;
    }
  }

  return result;
};

CommandStack.prototype._createId = function() {
  return this._uid++;
};

CommandStack.prototype._atomicDo = function(fn) {

  var execution = this._currentExecution;

  execution.atomic = true;

  try {
    fn();
  } finally {
    execution.atomic = false;
  }
};

CommandStack.prototype._internalExecute = function(action, redo) {
  var self = this;

  var command = action.command,
      context = action.context;

  var handler = this._getHandler(command);

  if (!handler) {
    throw new Error('no command handler registered for <' + command + '>');
  }

  this._pushAction(action);

  if (!redo) {
    this._fire(command, 'preExecute', action);

    if (handler.preExecute) {
      handler.preExecute(context);
    }

    this._fire(command, 'preExecuted', action);
  }

  // guard against illegal nested command stack invocations
  this._atomicDo(function() {

    self._fire(command, 'execute', action);

    if (handler.execute) {
      // actual execute + mark return results as dirty
      self._markDirty(handler.execute(context));
    }

    // log to stack
    self._executedAction(action, redo);

    self._fire(command, 'executed', action);
  });

  if (!redo) {
    this._fire(command, 'postExecute', action);

    if (handler.postExecute) {
      handler.postExecute(context);
    }

    this._fire(command, 'postExecuted', action);
  }

  this._popAction(action);
};


CommandStack.prototype._pushAction = function(action) {

  var execution = this._currentExecution,
      actions = execution.actions;

  var baseAction = actions[0];

  if (execution.atomic) {
    throw new Error('illegal invocation in <execute> or <revert> phase (action: ' + action.command + ')');
  }

  if (!action.id) {
    action.id = (baseAction && baseAction.id) || this._createId();
  }

  actions.push(action);
};


CommandStack.prototype._popAction = function() {
  var execution = this._currentExecution,
      actions = execution.actions,
      dirty = execution.dirty;

  actions.pop();

  if (!actions.length) {
    this._eventBus.fire('elements.changed', { elements: unique(dirty) });

    dirty.length = 0;

    this._fire('changed');
  }
};


CommandStack.prototype._markDirty = function(elements) {
  var execution = this._currentExecution;

  if (!elements) {
    return;
  }

  elements = isArray(elements) ? elements : [ elements ];

  execution.dirty = execution.dirty.concat(elements);
};


CommandStack.prototype._executedAction = function(action, redo) {
  var stackIdx = ++this._stackIdx;

  if (!redo) {
    this._stack.splice(stackIdx, this._stack.length, action);
  }
};


CommandStack.prototype._revertedAction = function(action) {
  this._stackIdx--;
};


CommandStack.prototype._getHandler = function(command) {
  return this._handlerMap[command];
};

CommandStack.prototype._setHandler = function(command, handler) {
  if (!command || !handler) {
    throw new Error('command and handler required');
  }

  if (this._handlerMap[command]) {
    throw new Error('overriding handler for command <' + command + '>');
  }

  this._handlerMap[command] = handler;
};

},{"108":108,"264":264,"389":389,"398":398}],104:[function(_dereq_,module,exports){
module.exports = {
  commandStack: [ 'type', _dereq_(103) ]
};

},{"103":103}],105:[function(_dereq_,module,exports){
'use strict';

var isNumber = _dereq_(392),
    assign = _dereq_(398),
    forEach = _dereq_(271),
    every = _dereq_(268),
    debounce = _dereq_(280);

var Collections = _dereq_(232),
    Elements = _dereq_(235);

var Snap = _dereq_(248);

function round(number, resolution) {
  return Math.round(number * resolution) / resolution;
}

function ensurePx(number) {
  return isNumber(number) ? number + 'px' : number;
}

/**
 * Creates a HTML container element for a SVG element with
 * the given configuration
 *
 * @param  {Object} options
 * @return {HTMLElement} the container element
 */
function createContainer(options) {

  options = assign({}, { width: '100%', height: '100%' }, options);

  var container = options.container || document.body;

  // create a <div> around the svg element with the respective size
  // this way we can always get the correct container size
  // (this is impossible for <svg> elements at the moment)
  var parent = document.createElement('div');
  parent.setAttribute('class', 'djs-container');

  assign(parent.style, {
    position: 'relative',
    overflow: 'hidden',
    width: ensurePx(options.width),
    height: ensurePx(options.height)
  });

  container.appendChild(parent);

  return parent;
}

function createGroup(parent, cls) {
  return parent.group().attr({ 'class' : cls });
}

var BASE_LAYER = 'base';


var REQUIRED_MODEL_ATTRS = {
  shape: [ 'x', 'y', 'width', 'height' ],
  connection: [ 'waypoints' ]
};

/**
 * The main drawing canvas.
 *
 * @class
 * @constructor
 *
 * @emits Canvas#canvas.init
 *
 * @param {Object} config
 * @param {EventBus} eventBus
 * @param {GraphicsFactory} graphicsFactory
 * @param {ElementRegistry} elementRegistry
 */
function Canvas(config, eventBus, graphicsFactory, elementRegistry) {

  this._eventBus = eventBus;
  this._elementRegistry = elementRegistry;
  this._graphicsFactory = graphicsFactory;

  this._init(config || {});
}

Canvas.$inject = [ 'config.canvas', 'eventBus', 'graphicsFactory', 'elementRegistry' ];

module.exports = Canvas;


Canvas.prototype._init = function(config) {

  var eventBus = this._eventBus;

  // Creates a <svg> element that is wrapped into a <div>.
  // This way we are always able to correctly figure out the size of the svg element
  // by querying the parent node.
  //
  // (It is not possible to get the size of a svg element cross browser @ 2014-04-01)
  //
  // <div class="djs-container" style="width: {desired-width}, height: {desired-height}">
  //   <svg width="100%" height="100%">
  //    ...
  //   </svg>
  // </div>

  // html container
  var container = this._container = createContainer(config),
      svg = this._svg = Snap.createSnapAt('100%', '100%', container),
      viewport = this._viewport = createGroup(svg, 'viewport');

  this._layers = {};

  // debounce canvas.viewbox.changed events
  // for smoother diagram interaction
  if (config.deferUpdate !== false) {
    this._viewboxChanged = debounce(this._viewboxChanged, 300);
  }

  eventBus.on('diagram.init', function() {

    /**
     * An event indicating that the canvas is ready to be drawn on.
     *
     * @memberOf Canvas
     *
     * @event canvas.init
     *
     * @type {Object}
     * @property {Snap<SVGSVGElement>} svg the created svg element
     * @property {Snap<SVGGroup>} viewport the direct parent of diagram elements and shapes
     */
    eventBus.fire('canvas.init', {
      svg: svg,
      viewport: viewport
    });

    // fire this in order for certain components to check
    // if they need to be adjusted due the canvas size
    this.resized();

  }, this);

  eventBus.on('diagram.destroy', 500, this._destroy, this);
  eventBus.on('diagram.clear', 500, this._clear, this);
};

Canvas.prototype._destroy = function(emit) {
  this._eventBus.fire('canvas.destroy', {
    svg: this._svg,
    viewport: this._viewport
  });

  var parent = this._container.parentNode;

  if (parent) {
    parent.removeChild(this._container);
  }

  delete this._svg;
  delete this._container;
  delete this._layers;
  delete this._rootElement;
  delete this._viewport;
};

Canvas.prototype._clear = function() {

  var self = this;

  var allElements = this._elementRegistry.getAll();

  // remove all elements
  allElements.forEach(function(element) {
    var type = Elements.getType(element);

    if (type === 'root') {
      self.setRootElement(null, true);
    } else {
      self._removeElement(element, type);
    }
  });

  // force recomputation of view box
  delete this._cachedViewbox;
};

/**
 * Returns the default layer on which
 * all elements are drawn.
 *
 * @returns {Snap<SVGGroup>}
 */
Canvas.prototype.getDefaultLayer = function() {
  return this.getLayer(BASE_LAYER);
};

/**
 * Returns a layer that is used to draw elements
 * or annotations on it.
 *
 * @param  {String} name
 *
 * @returns {Snap<SVGGroup>}
 */
Canvas.prototype.getLayer = function(name) {

  if (!name) {
    throw new Error('must specify a name');
  }

  var layer = this._layers[name];
  if (!layer) {
    layer = this._layers[name] = createGroup(this._viewport, 'layer-' + name);
  }

  return layer;
};


/**
 * Returns the html element that encloses the
 * drawing canvas.
 *
 * @return {DOMNode}
 */
Canvas.prototype.getContainer = function() {
  return this._container;
};


/////////////// markers ///////////////////////////////////

Canvas.prototype._updateMarker = function(element, marker, add) {
  var container;

  if (!element.id) {
    element = this._elementRegistry.get(element);
  }

  // we need to access all
  container = this._elementRegistry._elements[element.id];

  if (!container) {
    return;
  }

  forEach([ container.gfx, container.secondaryGfx ], function(gfx) {
    if (gfx) {
      // invoke either addClass or removeClass based on mode
      gfx[add ? 'addClass' : 'removeClass'](marker);
    }
  });

  /**
   * An event indicating that a marker has been updated for an element
   *
   * @event element.marker.update
   * @type {Object}
   * @property {djs.model.Element} element the shape
   * @property {Object} gfx the graphical representation of the shape
   * @property {String} marker
   * @property {Boolean} add true if the marker was added, false if it got removed
   */
  this._eventBus.fire('element.marker.update', { element: element, gfx: container.gfx, marker: marker, add: !!add });
};


/**
 * Adds a marker to an element (basically a css class).
 *
 * Fires the element.marker.update event, making it possible to
 * integrate extension into the marker life-cycle, too.
 *
 * @example
 * canvas.addMarker('foo', 'some-marker');
 *
 * var fooGfx = canvas.getGraphics('foo');
 *
 * fooGfx; // <g class="... some-marker"> ... </g>
 *
 * @param {String|djs.model.Base} element
 * @param {String} marker
 */
Canvas.prototype.addMarker = function(element, marker) {
  this._updateMarker(element, marker, true);
};


/**
 * Remove a marker from an element.
 *
 * Fires the element.marker.update event, making it possible to
 * integrate extension into the marker life-cycle, too.
 *
 * @param  {String|djs.model.Base} element
 * @param  {String} marker
 */
Canvas.prototype.removeMarker = function(element, marker) {
  this._updateMarker(element, marker, false);
};

/**
 * Check the existence of a marker on element.
 *
 * @param  {String|djs.model.Base} element
 * @param  {String} marker
 */
Canvas.prototype.hasMarker = function(element, marker) {
  if (!element.id) {
    element = this._elementRegistry.get(element);
  }

  var gfx = this.getGraphics(element);

  return gfx && gfx.hasClass(marker);
};

/**
 * Toggles a marker on an element.
 *
 * Fires the element.marker.update event, making it possible to
 * integrate extension into the marker life-cycle, too.
 *
 * @param  {String|djs.model.Base} element
 * @param  {String} marker
 */
Canvas.prototype.toggleMarker = function(element, marker) {
  if (this.hasMarker(element, marker)) {
    this.removeMarker(element, marker);
  } else {
    this.addMarker(element, marker);
  }
};

Canvas.prototype.getRootElement = function() {
  if (!this._rootElement) {
    this.setRootElement({ id: '__implicitroot', children: [] });
  }

  return this._rootElement;
};



//////////////// root element handling ///////////////////////////

/**
 * Sets a given element as the new root element for the canvas
 * and returns the new root element.
 *
 * @param {Object|djs.model.Root} element
 * @param {Boolean} [override] whether to override the current root element, if any
 *
 * @return {Object|djs.model.Root} new root element
 */
Canvas.prototype.setRootElement = function(element, override) {

  if (element) {
    this._ensureValid('root', element);
  }

  var currentRoot = this._rootElement,
      elementRegistry = this._elementRegistry,
      eventBus = this._eventBus;

  if (currentRoot) {
    if (!override) {
      throw new Error('rootElement already set, need to specify override');
    }

    // simulate element remove event sequence
    eventBus.fire('root.remove', { element: currentRoot });
    eventBus.fire('root.removed', { element: currentRoot });

    elementRegistry.remove(currentRoot);
  }

  if (element) {
    var gfx = this.getDefaultLayer();

    // resemble element add event sequence
    eventBus.fire('root.add', { element: element });

    elementRegistry.add(element, gfx, this._svg);

    eventBus.fire('root.added', { element: element, gfx: gfx });
  }

  this._rootElement = element;

  return element;
};



///////////// add functionality ///////////////////////////////

Canvas.prototype._ensureValid = function(type, element) {
  if (!element.id) {
    throw new Error('element must have an id');
  }

  if (this._elementRegistry.get(element.id)) {
    throw new Error('element with id ' + element.id + ' already exists');
  }

  var requiredAttrs = REQUIRED_MODEL_ATTRS[type];

  var valid = every(requiredAttrs, function(attr) {
    return typeof element[attr] !== 'undefined';
  });

  if (!valid) {
    throw new Error(
      'must supply { ' + requiredAttrs.join(', ') + ' } with ' + type);
  }
};

Canvas.prototype._setParent = function(element, parent, parentIndex) {
  Collections.add(parent.children, element, parentIndex);
  element.parent = parent;
};

/**
 * Adds an element to the canvas.
 *
 * This wires the parent <-> child relationship between the element and
 * a explicitly specified parent or an implicit root element.
 *
 * During add it emits the events
 *
 *  * <{type}.add> (element, parent)
 *  * <{type}.added> (element, gfx)
 *
 * Extensions may hook into these events to perform their magic.
 *
 * @param {String} type
 * @param {Object|djs.model.Base} element
 * @param {Object|djs.model.Base} [parent]
 * @param {Number} [parentIndex]
 *
 * @return {Object|djs.model.Base} the added element
 */
Canvas.prototype._addElement = function(type, element, parent, parentIndex) {

  parent = parent || this.getRootElement();

  var eventBus = this._eventBus,
      graphicsFactory = this._graphicsFactory;

  this._ensureValid(type, element);

  eventBus.fire(type + '.add', { element: element, parent: parent });

  this._setParent(element, parent, parentIndex);

  // create graphics
  var gfx = graphicsFactory.create(type, element);

  this._elementRegistry.add(element, gfx);

  // update its visual
  graphicsFactory.update(type, element, gfx);

  eventBus.fire(type + '.added', { element: element, gfx: gfx });

  return element;
};

/**
 * Adds a shape to the canvas
 *
 * @param {Object|djs.model.Shape} shape to add to the diagram
 * @param {djs.model.Base} [parent]
 * @param {Number} [parentIndex]
 *
 * @return {djs.model.Shape} the added shape
 */
Canvas.prototype.addShape = function(shape, parent, parentIndex) {
  return this._addElement('shape', shape, parent, parentIndex);
};

/**
 * Adds a connection to the canvas
 *
 * @param {Object|djs.model.Connection} connection to add to the diagram
 * @param {djs.model.Base} [parent]
 * @param {Number} [parentIndex]
 *
 * @return {djs.model.Connection} the added connection
 */
Canvas.prototype.addConnection = function(connection, parent, parentIndex) {
  return this._addElement('connection', connection, parent, parentIndex);
};


/**
 * Internal remove element
 */
Canvas.prototype._removeElement = function(element, type) {

  var elementRegistry = this._elementRegistry,
      graphicsFactory = this._graphicsFactory,
      eventBus = this._eventBus;

  element = elementRegistry.get(element.id || element);

  if (!element) {
    // element was removed already
    return;
  }

  eventBus.fire(type + '.remove', { element: element });

  graphicsFactory.remove(element);

  // unset parent <-> child relationship
  Collections.remove(element.parent && element.parent.children, element);
  element.parent = null;

  eventBus.fire(type + '.removed', { element: element });

  elementRegistry.remove(element);

  return element;
};


/**
 * Removes a shape from the canvas
 *
 * @param {String|djs.model.Shape} shape or shape id to be removed
 *
 * @return {djs.model.Shape} the removed shape
 */
Canvas.prototype.removeShape = function(shape) {

  /**
   * An event indicating that a shape is about to be removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event shape.remove
   * @type {Object}
   * @property {djs.model.Shape} element the shape descriptor
   * @property {Object} gfx the graphical representation of the shape
   */

  /**
   * An event indicating that a shape has been removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event shape.removed
   * @type {Object}
   * @property {djs.model.Shape} element the shape descriptor
   * @property {Object} gfx the graphical representation of the shape
   */
  return this._removeElement(shape, 'shape');
};


/**
 * Removes a connection from the canvas
 *
 * @param {String|djs.model.Connection} connection or connection id to be removed
 *
 * @return {djs.model.Connection} the removed connection
 */
Canvas.prototype.removeConnection = function(connection) {

  /**
   * An event indicating that a connection is about to be removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event connection.remove
   * @type {Object}
   * @property {djs.model.Connection} element the connection descriptor
   * @property {Object} gfx the graphical representation of the connection
   */

  /**
   * An event indicating that a connection has been removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event connection.removed
   * @type {Object}
   * @property {djs.model.Connection} element the connection descriptor
   * @property {Object} gfx the graphical representation of the connection
   */
  return this._removeElement(connection, 'connection');
};


/**
 * Return the graphical object underlaying a certain diagram element
 *
 * @param {String|djs.model.Base} element descriptor of the element
 * @param {Boolean} [secondary=false] whether to return the secondary connected element
 *
 * @return {SVGElement}
 */
Canvas.prototype.getGraphics = function(element, secondary) {
  return this._elementRegistry.getGraphics(element, secondary);
};


/**
 * Perform a viewbox update via a given change function.
 *
 * @param {Function} changeFn
 */
Canvas.prototype._changeViewbox = function(changeFn) {

  // notify others of the upcoming viewbox change
  this._eventBus.fire('canvas.viewbox.changing');

  // perform actual change
  changeFn.apply(this);

  // reset the cached viewbox so that
  // a new get operation on viewbox or zoom
  // triggers a viewbox re-computation
  this._cachedViewbox = null;

  // notify others of the change; this step
  // may or may not be debounced
  this._viewboxChanged();
};

Canvas.prototype._viewboxChanged = function() {
  this._eventBus.fire('canvas.viewbox.changed', { viewbox: this.viewbox() });
};


/**
 * Gets or sets the view box of the canvas, i.e. the
 * area that is currently displayed.
 *
 * The getter may return a cached viewbox (if it is currently
 * changing). To force a recomputation, pass `false` as the first argument.
 *
 * @example
 *
 * canvas.viewbox({ x: 100, y: 100, width: 500, height: 500 })
 *
 * // sets the visible area of the diagram to (100|100) -> (600|100)
 * // and and scales it according to the diagram width
 *
 * var viewbox = canvas.viewbox(); // pass `false` to force recomputing the box.
 *
 * console.log(viewbox);
 * // {
 * //   inner: Dimensions,
 * //   outer: Dimensions,
 * //   scale,
 * //   x, y,
 * //   width, height
 * // }
 *
 * @param  {Object} [box] the new view box to set
 * @param  {Number} box.x the top left X coordinate of the canvas visible in view box
 * @param  {Number} box.y the top left Y coordinate of the canvas visible in view box
 * @param  {Number} box.width the visible width
 * @param  {Number} box.height
 *
 * @return {Object} the current view box
 */
Canvas.prototype.viewbox = function(box) {

  if (box === undefined && this._cachedViewbox) {
    return this._cachedViewbox;
  }

  var viewport = this._viewport,
      innerBox,
      outerBox = this.getSize(),
      matrix,
      scale,
      x, y;

  if (!box) {
    // compute the inner box based on the
    // diagrams default layer. This allows us to exclude
    // external components, such as overlays
    innerBox = this.getDefaultLayer().getBBox(true);

    matrix = viewport.transform().localMatrix;
    scale = round(matrix.a, 1000);

    x = round(-matrix.e || 0, 1000);
    y = round(-matrix.f || 0, 1000);

    box = this._cachedViewbox = {
      x: x ? x / scale : 0,
      y: y ? y / scale : 0,
      width: outerBox.width / scale,
      height: outerBox.height / scale,
      scale: scale,
      inner: {
        width: innerBox.width,
        height: innerBox.height,
        x: innerBox.x,
        y: innerBox.y
      },
      outer: outerBox
    };

    return box;
  } else {

    this._changeViewbox(function() {
      scale = Math.min(outerBox.width / box.width, outerBox.height / box.height);

      matrix = new Snap.Matrix().scale(scale).translate(-box.x, -box.y);
      viewport.transform(matrix);
    });
  }

  return box;
};


/**
 * Gets or sets the scroll of the canvas.
 *
 * @param {Object} [delta] the new scroll to apply.
 *
 * @param {Number} [delta.dx]
 * @param {Number} [delta.dy]
 */
Canvas.prototype.scroll = function(delta) {

  var node = this._viewport.node;
  var matrix = node.getCTM();

  if (delta) {
    this._changeViewbox(function() {
      delta = assign({ dx: 0, dy: 0 }, delta || {});

      matrix = this._svg.node.createSVGMatrix().translate(delta.dx, delta.dy).multiply(matrix);

      setCTM(node, matrix);
    });
  }

  return { x: matrix.e, y: matrix.f };
};


/**
 * Gets or sets the current zoom of the canvas, optionally zooming
 * to the specified position.
 *
 * The getter may return a cached zoom level. Call it with `false` as
 * the first argument to force recomputation of the current level.
 *
 * @param {String|Number} [newScale] the new zoom level, either a number, i.e. 0.9,
 *                                   or `fit-viewport` to adjust the size to fit the current viewport
 * @param {String|Point} [center] the reference point { x: .., y: ..} to zoom to, 'auto' to zoom into mid or null
 *
 * @return {Number} the current scale
 */
Canvas.prototype.zoom = function(newScale, center) {

  if (!newScale) {
    return this.viewbox(newScale).scale;
  }

  if (newScale === 'fit-viewport') {
    return this._fitViewport(center);
  }

  var outer,
      matrix;

  this._changeViewbox(function() {

    if (typeof center !== 'object') {
      outer = this.viewbox().outer;

      center = {
        x: outer.width / 2,
        y: outer.height / 2
      };
    }

    matrix = this._setZoom(newScale, center);
  });

  return round(matrix.a, 1000);
};

function setCTM(node, m) {
  var mstr = 'matrix(' + m.a + ',' + m.b + ',' + m.c + ',' + m.d + ',' + m.e + ',' + m.f + ')';
  node.setAttribute('transform', mstr);
}

Canvas.prototype._fitViewport = function(center) {

  var vbox = this.viewbox(),
      outer = vbox.outer,
      inner = vbox.inner,
      newScale,
      newViewbox;

  // display the complete diagram without zooming in.
  // instead of relying on internal zoom, we perform a
  // hard reset on the canvas viewbox to realize this
  //
  // if diagram does not need to be zoomed in, we focus it around
  // the diagram origin instead

  if (inner.x >= 0 &&
      inner.y >= 0 &&
      inner.x + inner.width <= outer.width &&
      inner.y + inner.height <= outer.height &&
      !center) {

    newViewbox = {
      x: 0,
      y: 0,
      width: Math.max(inner.width + inner.x, outer.width),
      height: Math.max(inner.height + inner.y, outer.height)
    };
  } else {

    newScale = Math.min(1, outer.width / inner.width, outer.height / inner.height);
    newViewbox = {
      x: inner.x + (center ? inner.width / 2 - outer.width / newScale / 2 : 0),
      y: inner.y + (center ? inner.height / 2 - outer.height / newScale / 2 : 0),
      width: outer.width / newScale,
      height: outer.height / newScale
    };
  }

  this.viewbox(newViewbox);

  return this.viewbox(false).scale;
};


Canvas.prototype._setZoom = function(scale, center) {

  var svg = this._svg.node,
      viewport = this._viewport.node;

  var matrix = svg.createSVGMatrix();
  var point = svg.createSVGPoint();

  var centerPoint,
      originalPoint,
      currentMatrix,
      scaleMatrix,
      newMatrix;

  currentMatrix = viewport.getCTM();


  var currentScale = currentMatrix.a;

  if (center) {
    centerPoint = assign(point, center);

    // revert applied viewport transformations
    originalPoint = centerPoint.matrixTransform(currentMatrix.inverse());

    // create scale matrix
    scaleMatrix = matrix
                    .translate(originalPoint.x, originalPoint.y)
                    .scale(1 / currentScale * scale)
                    .translate(-originalPoint.x, -originalPoint.y);

    newMatrix = currentMatrix.multiply(scaleMatrix);
  } else {
    newMatrix = matrix.scale(scale);
  }

  setCTM(this._viewport.node, newMatrix);

  return newMatrix;
};


/**
 * Returns the size of the canvas
 *
 * @return {Dimensions}
 */
Canvas.prototype.getSize = function() {
  return {
    width: this._container.clientWidth,
    height: this._container.clientHeight
  };
};


/**
 * Return the absolute bounding box for the given element
 *
 * The absolute bounding box may be used to display overlays in the
 * callers (browser) coordinate system rather than the zoomed in/out
 * canvas coordinates.
 *
 * @param  {ElementDescriptor} element
 * @return {Bounds} the absolute bounding box
 */
Canvas.prototype.getAbsoluteBBox = function(element) {
  var vbox = this.viewbox();
  var bbox;

  // connection
  // use svg bbox
  if (element.waypoints) {
    var gfx = this.getGraphics(element);

    var transformBBox = gfx.getBBox(true);
    bbox = gfx.getBBox();

    bbox.x -= transformBBox.x;
    bbox.y -= transformBBox.y;

    bbox.width += 2 * transformBBox.x;
    bbox.height +=  2 * transformBBox.y;
  }
  // shapes
  // use data
  else {
    bbox = element;
  }

  var x = bbox.x * vbox.scale - vbox.x * vbox.scale;
  var y = bbox.y * vbox.scale - vbox.y * vbox.scale;

  var width = bbox.width * vbox.scale;
  var height = bbox.height * vbox.scale;

  return {
    x: x,
    y: y,
    width: width,
    height: height
  };
};

/**
 * Fires an event in order other modules can react to the
 * canvas resizing
 */
Canvas.prototype.resized = function() {

  // force recomputation of view box
  delete this._cachedViewbox;

  this._eventBus.fire('canvas.resized');
};

},{"232":232,"235":235,"248":248,"268":268,"271":271,"280":280,"392":392,"398":398}],106:[function(_dereq_,module,exports){
'use strict';

var Model = _dereq_(224);

var assign = _dereq_(398);

/**
 * A factory for diagram-js shapes
 */
function ElementFactory() {
  this._uid = 12;
}

module.exports = ElementFactory;


ElementFactory.prototype.createRoot = function(attrs) {
  return this.create('root', attrs);
};

ElementFactory.prototype.createLabel = function(attrs) {
  return this.create('label', attrs);
};

ElementFactory.prototype.createShape = function(attrs) {
  return this.create('shape', attrs);
};

ElementFactory.prototype.createConnection = function(attrs) {
  return this.create('connection', attrs);
};

/**
 * Create a model element with the given type and
 * a number of pre-set attributes.
 *
 * @param  {String} type
 * @param  {Object} attrs
 * @return {djs.model.Base} the newly created model instance
 */
ElementFactory.prototype.create = function(type, attrs) {

  attrs = assign({}, attrs || {});

  if (!attrs.id) {
    attrs.id = type + '_' + (this._uid++);
  }

  return Model.create(type, attrs);
};
},{"224":224,"398":398}],107:[function(_dereq_,module,exports){
'use strict';

var ELEMENT_ID = 'data-element-id';


/**
 * @class
 *
 * A registry that keeps track of all shapes in the diagram.
 */
function ElementRegistry() {
  this._elements = {};
}

module.exports = ElementRegistry;

/**
 * Register a pair of (element, gfx, (secondaryGfx)).
 *
 * @param {djs.model.Base} element
 * @param {Snap<SVGElement>} gfx
 * @param {Snap<SVGElement>} [secondaryGfx] optional other element to register, too
 */
ElementRegistry.prototype.add = function(element, gfx, secondaryGfx) {

  var id = element.id;

  this._validateId(id);

  // associate dom node with element
  gfx.attr(ELEMENT_ID, id);

  if (secondaryGfx) {
    secondaryGfx.attr(ELEMENT_ID, id);
  }

  this._elements[id] = { element: element, gfx: gfx, secondaryGfx: secondaryGfx };
};

/**
 * Removes an element from the registry.
 *
 * @param {djs.model.Base} element
 */
ElementRegistry.prototype.remove = function(element) {
  var elements = this._elements,
      id = element.id || element,
      container = id && elements[id];

  if (container) {

    // unset element id on gfx
    container.gfx.attr(ELEMENT_ID, '');

    if (container.secondaryGfx) {
      container.secondaryGfx.attr(ELEMENT_ID, '');
    }

    delete elements[id];
  }
};

/**
 * Update the id of an element
 *
 * @param {djs.model.Base} element
 * @param {String} newId
 */
ElementRegistry.prototype.updateId = function(element, newId) {

  this._validateId(newId);

  if (typeof element === 'string') {
    element = this.get(element);
  }

  var gfx = this.getGraphics(element),
      secondaryGfx = this.getGraphics(element, true);

  this.remove(element);

  element.id = newId;

  this.add(element, gfx, secondaryGfx);
};

/**
 * Return the model element for a given id or graphics.
 *
 * @example
 *
 * elementRegistry.get('SomeElementId_1');
 * elementRegistry.get(gfx);
 *
 *
 * @param {String|SVGElement} filter for selecting the element
 *
 * @return {djs.model.Base}
 */
ElementRegistry.prototype.get = function(filter) {
  var id;

  if (typeof filter === 'string') {
    id = filter;
  } else {
    id = filter && filter.attr(ELEMENT_ID);
  }

  var container = this._elements[id];
  return container && container.element;
};

/**
 * Return all elements that match a given filter function.
 *
 * @param {Function} fn
 *
 * @return {Array<djs.model.Base>}
 */
ElementRegistry.prototype.filter = function(fn) {

  var filtered = [];

  this.forEach(function(element, gfx) {
    if (fn(element, gfx)) {
      filtered.push(element);
    }
  });

  return filtered;
};

/**
 * Return all rendered model elements.
 *
 * @return {Array<djs.model.Base>}
 */
ElementRegistry.prototype.getAll = function() {
  return this.filter(function(e) { return e; });
};

/**
 * Iterate over all diagram elements.
 *
 * @param {Function} fn
 */
ElementRegistry.prototype.forEach = function(fn) {

  var map = this._elements;

  Object.keys(map).forEach(function(id) {
    var container = map[id],
        element = container.element,
        gfx = container.gfx;

    return fn(element, gfx);
  });
};

/**
 * Return the graphical representation of an element or its id.
 *
 * @example
 * elementRegistry.getGraphics('SomeElementId_1');
 * elementRegistry.getGraphics(rootElement); // <g ...>
 *
 * elementRegistry.getGraphics(rootElement, true); // <svg ...>
 *
 *
 * @param {String|djs.model.Base} filter
 * @param {Boolean} [secondary=false] whether to return the secondary connected element
 *
 * @return {SVGElement}
 */
ElementRegistry.prototype.getGraphics = function(filter, secondary) {
  var id = filter.id || filter;

  var container = this._elements[id];
  return container && (secondary ? container.secondaryGfx : container.gfx);
};

/**
 * Validate the suitability of the given id and signals a problem
 * with an exception.
 *
 * @param {String} id
 *
 * @throws {Error} if id is empty or already assigned
 */
ElementRegistry.prototype._validateId = function(id) {
  if (!id) {
    throw new Error('element must have an id');
  }

  if (this._elements[id]) {
    throw new Error('element with id ' + id + ' already added');
  }
};
},{}],108:[function(_dereq_,module,exports){
'use strict';

var isFunction = _dereq_(390),
    isArray = _dereq_(389),
    isNumber = _dereq_(392),
    bind = _dereq_(279),
    assign = _dereq_(398);

var FN_REF = '__fn';

var DEFAULT_PRIORITY = 1000;

var slice = Array.prototype.slice;

/**
 * A general purpose event bus.
 *
 * This component is used to communicate across a diagram instance.
 * Other parts of a diagram can use it to listen to and broadcast events.
 *
 *
 * ## Registering for Events
 *
 * The event bus provides the {@link EventBus#on} and {@link EventBus#once}
 * methods to register for events. {@link EventBus#off} can be used to
 * remove event registrations. Listeners receive an instance of {@link Event}
 * as the first argument. It allows them to hook into the event execution.
 *
 * ```javascript
 *
 * // listen for event
 * eventBus.on('foo', function(event) {
 *
 *   // access event type
 *   event.type; // 'foo'
 *
 *   // stop propagation to other listeners
 *   event.stopPropagation();
 *
 *   // prevent event default
 *   event.preventDefault();
 * });
 *
 * // listen for event with custom payload
 * eventBus.on('bar', function(event, payload) {
 *   console.log(payload);
 * });
 *
 * // listen for event returning value
 * eventBus.on('foobar', function(event) {
 *
 *   // stop event propagation + prevent default
 *   return false;
 *
 *   // stop event propagation + return custom result
 *   return {
 *     complex: 'listening result'
 *   };
 * });
 *
 *
 * // listen with custom priority (default=1000, higher is better)
 * eventBus.on('priorityfoo', 1500, function(event) {
 *   console.log('invoked first!');
 * });
 *
 *
 * // listen for event and pass the context (`this`)
 * eventBus.on('foobar', function(event) {
 *   this.foo();
 * }, this);
 * ```
 *
 *
 * ## Emitting Events
 *
 * Events can be emitted via the event bus using {@link EventBus#fire}.
 *
 * ```javascript
 *
 * // false indicates that the default action
 * // was prevented by listeners
 * if (eventBus.fire('foo') === false) {
 *   console.log('default has been prevented!');
 * };
 *
 *
 * // custom args + return value listener
 * eventBus.on('sum', function(event, a, b) {
 *   return a + b;
 * });
 *
 * // you can pass custom arguments + retrieve result values.
 * var sum = eventBus.fire('sum', 1, 2);
 * console.log(sum); // 3
 * ```
 */
function EventBus() {
  this._listeners = {};

  // cleanup on destroy on lowest priority to allow
  // message passing until the bitter end
  this.on('diagram.destroy', 1, this._destroy, this);
}

module.exports = EventBus;


/**
 * Register an event listener for events with the given name.
 *
 * The callback will be invoked with `event, ...additionalArguments`
 * that have been passed to {@link EventBus#fire}.
 *
 * Returning false from a listener will prevent the events default action
 * (if any is specified). To stop an event from being processed further in
 * other listeners execute {@link Event#stopPropagation}.
 *
 * Returning anything but `undefined` from a listener will stop the listener propagation.
 *
 * @param {String|Array<String>} events
 * @param {Number} [priority=1000] the priority in which this listener is called, larger is higher
 * @param {Function} callback
 * @param {Object} [that] Pass context (`this`) to the callback
 */
EventBus.prototype.on = function(events, priority, callback, that) {

  events = isArray(events) ? events : [ events ];

  if (isFunction(priority)) {
    that = callback;
    callback = priority;
    priority = DEFAULT_PRIORITY;
  }

  if (!isNumber(priority)) {
    throw new Error('priority must be a number');
  }

  var actualCallback = callback;

  if (that) {
    actualCallback = bind(callback, that);

    // make sure we remember and are able to remove
    // bound callbacks via {@link #off} using the original
    // callback
    actualCallback[FN_REF] = callback[FN_REF] || callback;
  }

  var self = this,
      listener = { priority: priority, callback: actualCallback };

  events.forEach(function(e) {
    self._addListener(e, listener);
  });
};


/**
 * Register an event listener that is executed only once.
 *
 * @param {String} event the event name to register for
 * @param {Function} callback the callback to execute
 * @param {Object} [that] Pass context (`this`) to the callback
 */
EventBus.prototype.once = function(event, priority, callback, that) {
  var self = this;

  if (isFunction(priority)) {
    that = callback;
    callback = priority;
    priority = DEFAULT_PRIORITY;
  }

  if (!isNumber(priority)) {
    throw new Error('priority must be a number');
  }

  function wrappedCallback() {
    self.off(event, wrappedCallback);
    return callback.apply(that, arguments);
  }

  // make sure we remember and are able to remove
  // bound callbacks via {@link #off} using the original
  // callback
  wrappedCallback[FN_REF] = callback;

  this.on(event, priority, wrappedCallback);
};


/**
 * Removes event listeners by event and callback.
 *
 * If no callback is given, all listeners for a given event name are being removed.
 *
 * @param {String} event
 * @param {Function} [callback]
 */
EventBus.prototype.off = function(event, callback) {
  var listeners = this._getListeners(event),
      listener,
      listenerCallback,
      idx;

  if (callback) {

    // move through listeners from back to front
    // and remove matching listeners
    for (idx = listeners.length - 1; (listener = listeners[idx]); idx--) {
      listenerCallback = listener.callback;

      if (listenerCallback === callback || listenerCallback[FN_REF] === callback) {
        listeners.splice(idx, 1);
      }
    }
  } else {
    // clear listeners
    listeners.length = 0;
  }
};


/**
 * Fires a named event.
 *
 * @example
 *
 * // fire event by name
 * events.fire('foo');
 *
 * // fire event object with nested type
 * var event = { type: 'foo' };
 * events.fire(event);
 *
 * // fire event with explicit type
 * var event = { x: 10, y: 20 };
 * events.fire('element.moved', event);
 *
 * // pass additional arguments to the event
 * events.on('foo', function(event, bar) {
 *   alert(bar);
 * });
 *
 * events.fire({ type: 'foo' }, 'I am bar!');
 *
 * @param {String} [name] the optional event name
 * @param {Object} [event] the event object
 * @param {...Object} additional arguments to be passed to the callback functions
 *
 * @return {Boolean} the events return value, if specified or false if the
 *                   default action was prevented by listeners
 */
EventBus.prototype.fire = function(type, data) {

  var event,
      listeners,
      returnValue,
      args;

  args = slice.call(arguments);

  if (typeof type === 'object') {
    event = type;
    type = event.type;
  }

  if (!type) {
    throw new Error('no event type specified');
  }

  listeners = this._listeners[type];

  if (!listeners) {
    return;
  }

  // we make sure we fire instances of our home made
  // events here. We wrap them only once, though
  if (data instanceof Event) {
    // we are fine, we alread have an event
    event = data;
  } else {
    event = new Event();
    event.init(data);
  }

  // ensure we pass the event as the first parameter
  args[0] = event;

  // original event type (in case we delegate)
  var originalType = event.type;

  // update event type before delegation
  if (type !== originalType) {
    event.type = type;
  }

  try {
    returnValue = this._invokeListeners(event, args, listeners);
  } finally {
    // reset event type after delegation
    if (type !== originalType) {
      event.type = originalType;
    }
  }

  // set the return value to false if the event default
  // got prevented and no other return value exists
  if (returnValue === undefined && event.defaultPrevented) {
    returnValue = false;
  }

  return returnValue;
};


EventBus.prototype.handleError = function(error) {
  return this.fire('error', { error: error }) === false;
};


EventBus.prototype._destroy = function() {
  this._listeners = {};
};

EventBus.prototype._invokeListeners = function(event, args, listeners) {

  var idx,
      listener,
      returnValue;

  for (idx = 0; (listener = listeners[idx]); idx++) {

    // handle stopped propagation
    if (event.cancelBubble) {
      break;
    }

    returnValue = this._invokeListener(event, args, listener);
  }

  return returnValue;
};

EventBus.prototype._invokeListener = function(event, args, listener) {

  var returnValue;

  try {
    // returning false prevents the default action
    returnValue = invokeFunction(listener.callback, args);

    // stop propagation on return value
    if (returnValue !== undefined) {
      event.returnValue = returnValue;
      event.stopPropagation();
    }

    // prevent default on return false
    if (returnValue === false) {
      event.preventDefault();
    }
  } catch (e) {
    if (!this.handleError(e)) {
      console.error('unhandled error in event listener');
      console.error(e.stack);

      throw e;
    }
  }

  return returnValue;
};

/*
 * Add new listener with a certain priority to the list
 * of listeners (for the given event).
 *
 * The semantics of listener registration / listener execution are
 * first register, first serve: New listeners will always be inserted
 * after existing listeners with the same priority.
 *
 * Example: Inserting two listeners with priority 1000 and 1300
 *
 *    * before: [ 1500, 1500, 1000, 1000 ]
 *    * after: [ 1500, 1500, (new=1300), 1000, 1000, (new=1000) ]
 *
 * @param {String} event
 * @param {Object} listener { priority, callback }
 */
EventBus.prototype._addListener = function(event, newListener) {

  var listeners = this._getListeners(event),
      existingListener,
      idx;

  // ensure we order listeners by priority from
  // 0 (high) to n > 0 (low)
  for (idx = 0; (existingListener = listeners[idx]); idx++) {
    if (existingListener.priority < newListener.priority) {

      // prepend newListener at before existingListener
      listeners.splice(idx, 0, newListener);
      return;
    }
  }

  listeners.push(newListener);
};


EventBus.prototype._getListeners = function(name) {
  var listeners = this._listeners[name];

  if (!listeners) {
    this._listeners[name] = listeners = [];
  }

  return listeners;
};


/**
 * A event that is emitted via the event bus.
 */
function Event() { }

module.exports.Event = Event;

Event.prototype.stopPropagation = function() {
  this.cancelBubble = true;
};

Event.prototype.preventDefault = function() {
  this.defaultPrevented = true;
};

Event.prototype.init = function(data) {
  assign(this, data || {});
};


/**
 * Invoke function. Be fast...
 *
 * @param {Function} fn
 * @param {Array<Object>} args
 *
 * @return {Any}
 */
function invokeFunction(fn, args) {
  return fn.apply(null, args);
}

},{"279":279,"389":389,"390":390,"392":392,"398":398}],109:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    reduce = _dereq_(274);

var GraphicsUtil = _dereq_(238),
    domClear = _dereq_(412);

/**
 * A factory that creates graphical elements
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 */
function GraphicsFactory(eventBus, elementRegistry) {
  this._eventBus = eventBus;
  this._elementRegistry = elementRegistry;
}

GraphicsFactory.$inject = [ 'eventBus' , 'elementRegistry' ];

module.exports = GraphicsFactory;


GraphicsFactory.prototype._getChildren = function(element) {

  var gfx = this._elementRegistry.getGraphics(element);

  var childrenGfx;

  // root element
  if (!element.parent) {
    childrenGfx = gfx;
  } else {
    childrenGfx = GraphicsUtil.getChildren(gfx);
    if (!childrenGfx) {
      childrenGfx = gfx.parent().group().attr('class', 'djs-children');
    }
  }

  return childrenGfx;
};

/**
 * Clears the graphical representation of the element and returns the
 * cleared visual (the <g class="djs-visual" /> element).
 */
GraphicsFactory.prototype._clear = function(gfx) {
  var visual = GraphicsUtil.getVisual(gfx);

  domClear(visual.node);

  return visual;
};

/**
 * Creates a gfx container for shapes and connections
 *
 * The layout is as follows:
 *
 * <g class="djs-group">
 *
 *   <!-- the gfx -->
 *   <g class="djs-element djs-(shape|connection)">
 *     <g class="djs-visual">
 *       <!-- the renderer draws in here -->
 *     </g>
 *
 *     <!-- extensions (overlays, click box, ...) goes here
 *   </g>
 *
 *   <!-- the gfx child nodes -->
 *   <g class="djs-children"></g>
 * </g>
 *
 * @param {Object} parent
 * @param {String} type the type of the element, i.e. shape | connection
 */
GraphicsFactory.prototype._createContainer = function(type, parentGfx) {
  var outerGfx = parentGfx.group().attr('class', 'djs-group'),
      gfx = outerGfx.group().attr('class', 'djs-element djs-' + type);

  // create visual
  gfx.group().attr('class', 'djs-visual');

  return gfx;
};

GraphicsFactory.prototype.create = function(type, element) {
  var childrenGfx = this._getChildren(element.parent);
  return this._createContainer(type, childrenGfx);
};


GraphicsFactory.prototype.updateContainments = function(elements) {

  var self = this,
      elementRegistry = this._elementRegistry,
      parents;


  parents = reduce(elements, function(map, e) {

    if (e.parent) {
      map[e.parent.id] = e.parent;
    }

    return map;
  }, {});

  // update all parents of changed and reorganized their children
  // in the correct order (as indicated in our model)
  forEach(parents, function(parent) {

    var childGfx = self._getChildren(parent),
        children = parent.children;

    if (!children) {
      return;
    }

    forEach(children.slice().reverse(), function(c) {
      var gfx = elementRegistry.getGraphics(c);
      gfx.parent().prependTo(childGfx);
    });
  });
};

GraphicsFactory.prototype.drawShape = function(visual, element) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.shape', { gfx: visual, element: element });
};

GraphicsFactory.prototype.getShapePath = function(element) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.getShapePath', element);
};

GraphicsFactory.prototype.drawConnection = function(visual, element) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.connection', { gfx: visual, element: element });
};

GraphicsFactory.prototype.getConnectionPath = function(waypoints) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.getConnectionPath', waypoints);
};

GraphicsFactory.prototype.update = function(type, element, gfx) {
  // Do not update root element
  if (!element.parent) {
    return;
  }

  var visual = this._clear(gfx);

  // redraw
  if (type === 'shape') {
    this.drawShape(visual, element);

    // update positioning
    gfx.translate(element.x, element.y);
  } else
  if (type === 'connection') {
    this.drawConnection(visual, element);
  } else {
    throw new Error('unknown type: ' + type);
  }

  gfx.attr('display', element.hidden ? 'none' : 'block');
};

GraphicsFactory.prototype.remove = function(element) {
  var gfx = this._elementRegistry.getGraphics(element);

  // remove
  gfx.parent().remove();
};

},{"238":238,"271":271,"274":274,"412":412}],110:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [ _dereq_(114) ],
  __init__: [ 'canvas' ],
  canvas: [ 'type', _dereq_(105) ],
  elementRegistry: [ 'type', _dereq_(107) ],
  elementFactory: [ 'type', _dereq_(106) ],
  eventBus: [ 'type', _dereq_(108) ],
  graphicsFactory: [ 'type', _dereq_(109) ]
};
},{"105":105,"106":106,"107":107,"108":108,"109":109,"114":114}],111:[function(_dereq_,module,exports){
'use strict';

var DEFAULT_RENDER_PRIORITY = 1000;

/**
 * The base implementation of shape and connection renderers.
 *
 * @param {EventBus} eventBus
 * @param {Number} [renderPriority=1000]
 */
function BaseRenderer(eventBus, renderPriority) {
  var self = this;

  renderPriority = renderPriority || DEFAULT_RENDER_PRIORITY;

  eventBus.on([ 'render.shape', 'render.connection' ], renderPriority, function(evt, context) {
    var type = evt.type,
        element = context.element,
        visuals = context.gfx;

    if (self.canRender(element)) {
      if (type === 'render.shape') {
        return self.drawShape(visuals, element);
      } else {
        return self.drawConnection(visuals, element);
      }
    }
  });

  eventBus.on([ 'render.getShapePath', 'render.getConnectionPath'], renderPriority, function(evt, element) {
    if (self.canRender(element)) {
      if (evt.type === 'render.getShapePath') {
        return self.getShapePath(element);
      } else {
        return self.getConnectionPath(element);
      }
    }
  });
}

/**
 * Should check whether *this* renderer can render
 * the element/connection.
 *
 * @param {element} element
 *
 * @returns {Boolean}
 */
BaseRenderer.prototype.canRender = function() {};

/**
 * Provides the shape's snap svg element to be drawn on the `canvas`.
 *
 * @param {djs.Graphics} visuals
 * @param {Shape} shape
 *
 * @returns {Snap.svg} [returns a Snap.svg paper element ]
 */
BaseRenderer.prototype.drawShape = function() {};

/**
 * Provides the shape's snap svg element to be drawn on the `canvas`.
 *
 * @param {djs.Graphics} visuals
 * @param {Connection} connection
 *
 * @returns {Snap.svg} [returns a Snap.svg paper element ]
 */
BaseRenderer.prototype.drawConnection = function() {};

/**
 * Gets the SVG path of a shape that represents it's visual bounds.
 *
 * @param {Shape} shape
 *
 * @return {string} svg path
 */
BaseRenderer.prototype.getShapePath = function() {};

/**
 * Gets the SVG path of a connection that represents it's visual bounds.
 *
 * @param {Connection} connection
 *
 * @return {string} svg path
 */
BaseRenderer.prototype.getConnectionPath = function() {};

module.exports = BaseRenderer;

},{}],112:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var BaseRenderer = _dereq_(111);

var renderUtil = _dereq_(246);

var componentsToPath = renderUtil.componentsToPath,
    createLine = renderUtil.createLine;

// apply default renderer with lowest possible priority
// so that it only kicks in if noone else could render
var DEFAULT_RENDER_PRIORITY = 1;

/**
 * The default renderer used for shapes and connections.
 *
 * @param {EventBus} eventBus
 * @param {Styles} styles
 */
function DefaultRenderer(eventBus, styles) {
  //
  BaseRenderer.call(this, eventBus, DEFAULT_RENDER_PRIORITY);

  this.CONNECTION_STYLE = styles.style([ 'no-fill' ], { strokeWidth: 5, stroke: 'fuchsia' });
  this.SHAPE_STYLE = styles.style({ fill: 'white', stroke: 'fuchsia', strokeWidth: 2 });
}

inherits(DefaultRenderer, BaseRenderer);


DefaultRenderer.prototype.canRender = function() {
  return true;
};

DefaultRenderer.prototype.drawShape = function drawShape(visuals, element) {
  return visuals.rect(0, 0, element.width || 0, element.height || 0).attr(this.SHAPE_STYLE);
};

DefaultRenderer.prototype.drawConnection = function drawConnection(visuals, connection) {
  return createLine(connection.waypoints, this.CONNECTION_STYLE).appendTo(visuals);
};

DefaultRenderer.prototype.getShapePath = function getShapePath(shape) {

  var x = shape.x,
      y = shape.y,
      width = shape.width,
      height = shape.height;

  var shapePath = [
    ['M', x, y],
    ['l', width, 0],
    ['l', 0, height],
    ['l', -width, 0],
    ['z']
  ];

  return componentsToPath(shapePath);
};

DefaultRenderer.prototype.getConnectionPath = function getConnectionPath(connection) {
  var waypoints = connection.waypoints;

  var idx, point, connectionPath = [];

  for (idx = 0; (point = waypoints[idx]); idx++) {

    // take invisible docking into account
    // when creating the path
    point = point.original || point;

    connectionPath.push([ idx === 0 ? 'M' : 'L', point.x, point.y ]);
  }

  return componentsToPath(connectionPath);
};


DefaultRenderer.$inject = [ 'eventBus', 'styles' ];

module.exports = DefaultRenderer;

},{"111":111,"246":246,"257":257}],113:[function(_dereq_,module,exports){
'use strict';

var isArray = _dereq_(389),
    assign = _dereq_(398),
    reduce = _dereq_(274);


/**
 * A component that manages shape styles
 */
function Styles() {

  var defaultTraits = {

    'no-fill': {
      fill: 'none'
    },
    'no-border': {
      strokeOpacity: 0.0
    },
    'no-events': {
      pointerEvents: 'none'
    }
  };

  var self = this;

  /**
   * Builds a style definition from a className, a list of traits and an object of additional attributes.
   *
   * @param  {String} className
   * @param  {Array<String>} traits
   * @param  {Object} additionalAttrs
   *
   * @return {Object} the style defintion
   */
  this.cls = function(className, traits, additionalAttrs) {
    var attrs = this.style(traits, additionalAttrs);

    return assign(attrs, { 'class': className });
  };

  /**
   * Builds a style definition from a list of traits and an object of additional attributes.
   *
   * @param  {Array<String>} traits
   * @param  {Object} additionalAttrs
   *
   * @return {Object} the style defintion
   */
  this.style = function(traits, additionalAttrs) {

    if (!isArray(traits) && !additionalAttrs) {
      additionalAttrs = traits;
      traits = [];
    }

    var attrs = reduce(traits, function(attrs, t) {
      return assign(attrs, defaultTraits[t] || {});
    }, {});

    return additionalAttrs ? assign(attrs, additionalAttrs) : attrs;
  };

  this.computeStyle = function(custom, traits, defaultStyles) {
    if (!isArray(traits)) {
      defaultStyles = traits;
      traits = [];
    }

    return self.style(traits || [], assign({}, defaultStyles, custom || {}));
  };
}

module.exports = Styles;

},{"274":274,"389":389,"398":398}],114:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'defaultRenderer' ],
  defaultRenderer: [ 'type', _dereq_(112) ],
  styles: [ 'type', _dereq_(113) ]
};

},{"112":112,"113":113}],115:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    flatten = _dereq_(259),
    union = _dereq_(262),
    filter = _dereq_(269),
    groupBy = _dereq_(272),
    map = _dereq_(273);

var saveClear = _dereq_(245).saveClear,
    Collections = _dereq_(232);

var getNewAttachShapeDelta = _dereq_(230).getNewAttachShapeDelta;

var inherits = _dereq_(257);

var HIGH_PRIORITY = 1500;

var CommandInterceptor = _dereq_(102);


function AttachSupport(eventBus, modeling, moveVisuals, rules) {

  CommandInterceptor.call(this, eventBus);


  // remove all the attached elements from the shapes to be validated
  // add all the attached shapes to the overall list of moved shapes
  eventBus.on('shape.move.start', HIGH_PRIORITY, function(e) {

    var context = e.context,
        shapes = context.shapes,
        validatedShapes = context.validatedShapes;

    context.shapes = addAttached(shapes);

    context.validatedShapes = removeAttached(validatedShapes);
  });


  // move all attachments after the other shapes are done moving
  this.postExecuted([ 'elements.move' ], function(event) {

    var context = event.context,
        delta = context.delta,
        newParent = context.newParent,
        closure = context.closure,
        enclosedElements = closure.enclosedElements,
        attachers = getAttachers(enclosedElements);

    // ensure we move all attachers with their hosts
    // if they have not been moved already
    forEach(attachers, function(attacher) {
      if (!enclosedElements[attacher.id]) {
        modeling.moveShape(attacher, delta, newParent);
      }
    });
  });

  // perform the attaching after shapes are done moving
  this.postExecuted([ 'elements.move' ], function(e) {

    var context = e.context,
        shapes = context.shapes,
        newHost = context.newHost,
        attachers;

    // we only support attachment / detachment of one element
    if (shapes.length > 1) {
      return;
    }

    if (newHost) {

      attachers = shapes;
    } else {

      attachers = filter(shapes, function(s) {
        return !!s.host;
      });
    }

    forEach(attachers, function(attacher) {
      modeling.updateAttachment(attacher, newHost);
    });
  });

  // ensure invalid attachment connections are removed
  this.postExecuted([ 'elements.move' ], function(e) {

    var shapes = e.context.shapes;

    forEach(shapes, function(shape) {

      forEach(shape.attachers, function(attacher) {

        // remove invalid outgoing connections
        forEach(attacher.outgoing.slice(), function(connection) {
          var allowed = rules.allowed('connection.reconnectStart', {
            connection: connection,
            source: connection.source,
            target: connection.target
          });

          if (!allowed) {
            modeling.removeConnection(connection);
          }
        });

        // remove invalid incoming connections
        forEach(attacher.incoming.slice(), function(connection) {
          var allowed = rules.allowed('connection.reconnectEnd', {
            connection: connection,
            source: connection.source,
            target: connection.target
          });

          if (!allowed) {
            modeling.removeConnection(connection);
          }
        });
      });
    });
  });

  this.postExecute([ 'shape.create' ], function(e) {
    var context = e.context,
        shape = context.shape,
        host = context.host;

    if (host) {
      modeling.updateAttachment(shape, host);
    }
  });

  // update attachments if the host is replaced
  this.postExecute([ 'shape.replace' ], function(e) {

    var context = e.context,
        oldShape = context.oldShape,
        newShape = context.newShape;

    // move the attachers to the new host
    saveClear(oldShape.attachers, function(attacher) {
      var allowed = rules.allowed('elements.move', {
        target: newShape,
        shapes: [attacher]
      });

      if (allowed === 'attach') {
        modeling.updateAttachment(attacher, newShape);
      } else {
        modeling.removeShape(attacher);
      }
    });

    // move attachers if new host has different size
    if (newShape.attachers.length) {

      forEach(newShape.attachers, function(attacher) {
        var delta = getNewAttachShapeDelta(attacher, oldShape, newShape);
        modeling.moveShape(attacher, delta, attacher.parent);
      });
    }

  });

  // move shape on host resize
  this.postExecute([ 'shape.resize' ], function(event) {
    var context = event.context,
        shape = context.shape,
        oldBounds = context.oldBounds,
        newBounds = context.newBounds,
        attachers = shape.attachers;

    if (!attachers.length) {
      return;
    }

    forEach(attachers, function(attacher) {
      var delta = getNewAttachShapeDelta(attacher, oldBounds, newBounds);

      modeling.moveShape(attacher, delta, attacher.parent);

      if (attacher.label) {
        modeling.moveShape(attacher.label, delta, attacher.label.parent);
      }
    });
  });

  // remove attachments
  this.preExecute([ 'shape.delete' ], function(event) {

    var shape = event.context.shape;

    saveClear(shape.attachers, function(attacher) {
      modeling.removeShape(attacher);
    });

    if (shape.host) {
      modeling.updateAttachment(shape, null);
    }
  });


  // Prevent attachers and their labels from moving, when the space tool is performed.
  // Otherwise the attachers and their labels would be moved twice.
  eventBus.on('spaceTool.move', function(event) {

    var movingShapes = event.context.movingShapes;

    // Collect all attachers which would be moved using the space tool
    var movingAttachers = filter(movingShapes, function(shape) {
      return shape.host && shape.host.id;
    });

    forEach(movingAttachers, function(shape) {
      // Remove all attachers and their labels from the movingShapes, because they
      // already will be moved along with the host.
      Collections.remove(movingShapes, shape);
      if (shape.label) {
        Collections.remove(movingShapes, shape.label);
      }
    });

  });
}

inherits(AttachSupport, CommandInterceptor);

AttachSupport.$inject = [ 'eventBus', 'modeling', 'moveVisuals', 'rules' ];

module.exports = AttachSupport;


/**
 * Return attachers of the given shapes
 *
 * @param {Array<djs.model.Base>} shapes
 * @return {Array<djs.model.Base>}
 */
function getAttachers(shapes) {
  return flatten(map(shapes, function(s) {
    return s.attachers || [];
  }));
}

/**
 * Return a combined list of elements and
 * attachers.
 *
 * @param {Array<djs.model.Base>} elements
 * @return {Array<djs.model.Base>} filtered
 */
function addAttached(elements) {
  var attachers = getAttachers(elements);

  return union(elements, attachers);
}

/**
 * Return a filtered list of elements that do not
 * contain attached elements with hosts being part
 * of the selection.
 *
 * @param  {Array<djs.model.Base>} elements
 *
 * @return {Array<djs.model.Base>} filtered
 */
function removeAttached(elements) {

  var ids = groupBy(elements, 'id');

  return filter(elements, function(element) {
    while (element) {

      // host in selection
      if (element.host && ids[element.host.id]) {
        return false;
      }

      element = element.parent;
    }

    return true;
  });
}

},{"102":102,"230":230,"232":232,"245":245,"257":257,"259":259,"262":262,"269":269,"271":271,"272":272,"273":273}],116:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(185),
    _dereq_(154)
  ],
  __init__: [ 'attachSupport'],
  attachSupport: [ 'type', _dereq_(115) ]
};

},{"115":115,"154":154,"185":185}],117:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var getBoundingBox = _dereq_(235).getBBox;

var asTRBL = _dereq_(222).asTRBL,
    asBounds = _dereq_(222).asBounds;

var assign = _dereq_(398),
    forEach = _dereq_(271),
    values = _dereq_(406),
    flatten = _dereq_(259),
    groupBy = _dereq_(272);

var CommandInterceptor = _dereq_(102);


/**
 * An auto resize component that takes care of expanding a parent element
 * if child elements are created or moved close the parents edge.
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 * @param {Modeling} modeling
 * @param {Rules} rules
 */
function AutoResize(eventBus, elementRegistry, modeling, rules) {

  CommandInterceptor.call(this, eventBus);

  this._elementRegistry = elementRegistry;
  this._modeling = modeling;
  this._rules = rules;

  var self = this;

  this.postExecuted([ 'shape.create' ], function(event) {

    var context = event.context,
        hints = context.hints,
        shape = context.shape,
        parent = context.parent || context.newParent;

    if (hints && hints.root === false) {
      return;
    }

    self._expand([ shape ], parent);
  });

  this.postExecuted([ 'elements.move' ], function(event) {

    var context = event.context,
        elements = flatten(values(context.closure.topLevel));

    var expandings = groupBy(elements, function(element) {
      return element.parent.id;
    });

    forEach(expandings, function(elements, parentId) {
      self._expand(elements, parentId);
    });
  });
}

AutoResize.$inject = [ 'eventBus', 'elementRegistry', 'modeling', 'rules' ];

inherits(AutoResize, CommandInterceptor);

module.exports = AutoResize;


/**
 * Calculate the new bounds of the target shape, given
 * a number of elements have been moved or added into the parent.
 *
 * This method considers the current size, the added elements as well as
 * the provided padding for the new bounds.
 *
 * @param {Array<djs.model.Shape>} elements
 * @param {djs.model.Shape} target
 */
AutoResize.prototype._getOptimalBounds = function(elements, target) {

  var offset = this.getOffset(target),
      padding = this.getPadding(target);

  var elementsTrbl = asTRBL(getBoundingBox(elements)),
      targetTrbl = asTRBL(target);

  var newTrbl = {};

  if (elementsTrbl.top - targetTrbl.top < padding.top) {
    newTrbl.top = elementsTrbl.top - offset.top;
  }

  if (elementsTrbl.left - targetTrbl.left < padding.left) {
    newTrbl.left = elementsTrbl.left - offset.left;
  }

  if (targetTrbl.right - elementsTrbl.right < padding.right) {
    newTrbl.right = elementsTrbl.right + offset.right;
  }

  if (targetTrbl.bottom - elementsTrbl.bottom < padding.bottom) {
    newTrbl.bottom = elementsTrbl.bottom + offset.bottom;
  }

  return asBounds(assign({}, targetTrbl, newTrbl));
};


/**
 * Expand the target shape respecting rules, offset and padding
 *
 * @param {Array<djs.model.Shape>} elements
 * @param {djs.model.Shape|String} target|targetId
 */
AutoResize.prototype._expand = function(elements, target) {

  if (typeof target === 'string') {
    target = this._elementRegistry.get(target);
  }

  var allowed = this._rules.allowed('element.autoResize', {
    elements: elements,
    target: target
  });

  if (!allowed) {
    return;
  }

  // calculate the new bounds
  var newBounds = this._getOptimalBounds(elements, target);

  // resize the parent shape
  this.resize(target, newBounds);

  var parent = target.parent;

  // recursively expand parent elements
  if (parent) {
    this._expand([ target ], parent);
  }
};


/**
 * Get the amount to expand the given shape in each direction.
 *
 * @param {djs.model.Shape} shape
 *
 * @return {Object} {top, bottom, left, right}
 */
AutoResize.prototype.getOffset = function(shape) {
  return { top: 60, bottom: 60, left: 100, right: 100 };
};


/**
 * Get the activation threshold for each side for which
 * resize triggers.
 *
 * @param {djs.model.Shape} shape
 *
 * @return {Object} {top, bottom, left, right}
 */
AutoResize.prototype.getPadding = function(shape) {
  return { top: 2, bottom: 2, left: 15, right: 15 };
};


/**
 * Perform the actual resize operation.
 *
 * @param {djs.model.Shape} target
 * @param {Object} newBounds
 */
AutoResize.prototype.resize = function(target, newBounds) {
  this._modeling.resizeShape(target, newBounds);
};

},{"102":102,"222":222,"235":235,"257":257,"259":259,"271":271,"272":272,"398":398,"406":406}],118:[function(_dereq_,module,exports){
var RuleProvider = _dereq_(202);

var inherits = _dereq_(257);

/**
 * This is a base rule provider for the element.autoResize rule.
 */
function AutoResizeProvider(eventBus) {

  RuleProvider.call(this, eventBus);

  var self = this;

  this.addRule('element.autoResize', function(context) {
    return self.canResize(context.elements, context.target);
  });
}

AutoResizeProvider.$inject = [ 'eventBus' ];

inherits(AutoResizeProvider, RuleProvider);

module.exports = AutoResizeProvider;

/**
 * Needs to be implemented by sub classes to allow actual auto resize
 *
 * @param  {Array<djs.model.Shape>} elements
 * @param  {djs.model.Shape} target
 *
 * @return {Boolean}
 */
AutoResizeProvider.prototype.canResize = function(elements, target) {
  return false;
};
},{"202":202,"257":257}],119:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: [ 'autoResize' ],
  autoResize: [ 'type', _dereq_(117) ]
};

},{"117":117}],120:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398);

var EventUtil = _dereq_(236);


/**
 * Initiates canvas scrolling if current cursor point is close to a border.
 * Cancelled when current point moves back inside the scrolling borders
 * or cancelled manually.
 *
 * Default options :
 *   scrollThresholdIn: [ 20, 20, 20, 20 ],
 *   scrollThresholdOut: [ 0, 0, 0, 0 ],
 *   scrollRepeatTimeout: 15,
 *   scrollStep: 10
 *
 * Threshold order:
 *   [ left, top, right, bottom ]
 */
function AutoScroll(config, eventBus, canvas, mouseTracking) {

  this._canvas = canvas;
  this._mouseTracking = mouseTracking;

  this._opts = assign({
    scrollThresholdIn: [ 20, 20, 20, 20 ],
    scrollThresholdOut: [ 0, 0, 0, 0 ],
    scrollRepeatTimeout: 15,
    scrollStep: 10
  }, config);

  var self = this;

  eventBus.on('drag.move', function(e) {
    var point = self._toBorderPoint(e);

    self.startScroll(point);
  });

  eventBus.on([ 'drag.cleanup' ], function() {
    self.stopScroll();
  });
}

AutoScroll.$inject = [ 'config.autoScroll', 'eventBus', 'canvas', 'mouseTracking'];

module.exports = AutoScroll;


/**
 * Starts scrolling loop.
 * Point is given in global scale in canvas container box plane.
 *
 * @param  {Object} point { x: X, y: Y }
 */
AutoScroll.prototype.startScroll = function(point) {

  var canvas = this._canvas;
  var opts = this._opts;
  var self = this;

  var clientRect = canvas.getContainer().getBoundingClientRect();

  var diff = [
    point.x,
    point.y,
    clientRect.width - point.x,
    clientRect.height - point.y
  ];

  this.stopScroll();

  var dx = 0,
      dy = 0;

  for (var i = 0; i < 4; i++) {
    if (between(diff[i], opts.scrollThresholdOut[i], opts.scrollThresholdIn[i])) {
      if (i === 0) {
        dx = opts.scrollStep;
      } else if (i == 1) {
        dy = opts.scrollStep;
      } else if (i == 2) {
        dx = -opts.scrollStep;
      } else if (i == 3) {
        dy = -opts.scrollStep;
      }
    }
  }

  if (dx !== 0 || dy !== 0) {
    canvas.scroll({ dx: dx, dy: dy });

    this._scrolling = setTimeout(function() {
      self.startScroll(point);
    }, opts.scrollRepeatTimeout);
  }
};

function between(val, start, end) {
  if (start < val && val < end) {
    return true;
  }

  return false;
}


/**
 * Stops scrolling loop.
 */
AutoScroll.prototype.stopScroll = function() {
  clearTimeout(this._scrolling);
};


/**
 * Overrides defaults options.
 *
 * @param  {Object} options
 */
AutoScroll.prototype.setOptions = function(options) {
  this._opts = assign({}, this._opts, options);
};


/**
 * Converts event to a point in canvas container plane in global scale.
 *
 * @param  {Event} event
 * @return {Point}
 */
AutoScroll.prototype._toBorderPoint = function(event) {
  var clientRect = this._canvas._container.getBoundingClientRect();

  var globalPosition = EventUtil.toPoint(event.originalEvent);

  return {
    x: globalPosition.x - clientRect.left,
    y: globalPosition.y - clientRect.top
  };
};
},{"236":236,"398":398}],121:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(142),
    _dereq_(182)
  ],
  __init__: [ 'autoScroll' ],
  autoScroll: [ 'type', _dereq_(120) ]
};
},{"120":120,"142":142,"182":182}],122:[function(_dereq_,module,exports){
'use strict';

var Geometry = _dereq_(237),
    BendpointUtil = _dereq_(124);

var MARKER_OK = 'connect-ok',
    MARKER_NOT_OK = 'connect-not-ok',
    MARKER_CONNECT_HOVER = 'connect-hover',
    MARKER_CONNECT_UPDATING = 'djs-updating';

var COMMAND_BENDPOINT_UPDATE = 'connection.updateWaypoints',
    COMMAND_RECONNECT_START = 'connection.reconnectStart',
    COMMAND_RECONNECT_END = 'connection.reconnectEnd';

var round = Math.round;


/**
 * A component that implements moving of bendpoints
 */
function BendpointMove(injector, eventBus, canvas, dragging, graphicsFactory, rules, modeling) {

  // optional connection docking integration
  var connectionDocking = injector.get('connectionDocking', false);


  // API

  this.start = function(event, connection, bendpointIndex, insert) {

    var type,
        context,
        waypoints = connection.waypoints,
        gfx = canvas.getGraphics(connection);

    if (!insert && bendpointIndex === 0) {
      type = COMMAND_RECONNECT_START;
    } else
    if (!insert && bendpointIndex === waypoints.length - 1) {
      type = COMMAND_RECONNECT_END;
    } else {
      type = COMMAND_BENDPOINT_UPDATE;
    }

    context = {
      connection: connection,
      bendpointIndex: bendpointIndex,
      insert: insert,
      type: type
    };

    dragging.init(event, 'bendpoint.move', {
      data: {
        connection: connection,
        connectionGfx: gfx,
        context: context
      }
    });
  };


  // DRAGGING IMPLEMENTATION


  function redrawConnection(data) {
    graphicsFactory.update('connection', data.connection, data.connectionGfx);
  }

  function filterRedundantWaypoints(waypoints) {

    // alter copy of waypoints, not original
    waypoints = waypoints.slice();

    var idx = 0,
        point,
        previousPoint,
        nextPoint;

    while (waypoints[idx]) {
      point = waypoints[idx];
      previousPoint = waypoints[idx - 1];
      nextPoint = waypoints[idx + 1];

      if (Geometry.pointDistance(point, nextPoint) === 0 ||
          Geometry.pointsOnLine(previousPoint, nextPoint, point)) {

        // remove point, if overlapping with {nextPoint}
        // or on line with {previousPoint} -> {point} -> {nextPoint}
        waypoints.splice(idx, 1);
      } else {
        idx++;
      }
    }

    return waypoints;
  }

  eventBus.on('bendpoint.move.start', function(e) {

    var context = e.context,
        connection = context.connection,
        originalWaypoints = connection.waypoints,
        waypoints = originalWaypoints.slice(),
        insert = context.insert,
        idx = context.bendpointIndex;

    context.originalWaypoints = originalWaypoints;

    if (insert) {
      // insert placeholder for bendpoint to-be-added
      waypoints.splice(idx, 0, null);
    }

    connection.waypoints = waypoints;

    // add dragger gfx
    context.draggerGfx = BendpointUtil.addBendpoint(canvas.getLayer('overlays'));
    context.draggerGfx.addClass('djs-dragging');

    canvas.addMarker(connection, MARKER_CONNECT_UPDATING);
  });

  eventBus.on('bendpoint.move.hover', function(e) {

    e.context.hover = e.hover;
    canvas.addMarker(e.hover, MARKER_CONNECT_HOVER);
  });

  eventBus.on([
    'bendpoint.move.out',
    'bendpoint.move.cleanup'
  ], function(e) {

    // remove connect marker
    // if it was added
    var hover = e.context.hover;

    if (hover) {
      canvas.removeMarker(hover, MARKER_CONNECT_HOVER);
      canvas.removeMarker(hover, e.context.target ? MARKER_OK : MARKER_NOT_OK);
    }
  });

  eventBus.on('bendpoint.move.move', function(e) {

    var context = e.context,
        moveType = context.type,
        connection = e.connection,
        source, target;

    connection.waypoints[context.bendpointIndex] = { x: e.x, y: e.y };

    if (connectionDocking) {

      if (context.hover) {
        if (moveType === COMMAND_RECONNECT_START) {
          source = context.hover;
        }

        if (moveType === COMMAND_RECONNECT_END) {
          target = context.hover;
        }
      }

      connection.waypoints = connectionDocking.getCroppedWaypoints(connection, source, target);
    }

    // asks whether reconnect / bendpoint move / bendpoint add
    // is allowed at the given position
    var allowed = context.allowed = rules.allowed(context.type, context);

    if (allowed) {

      if (context.hover) {
        canvas.removeMarker(context.hover, MARKER_NOT_OK);
        canvas.addMarker(context.hover, MARKER_OK);

        context.target = context.hover;
      }
    } else
    if (allowed === false) {
      if (context.hover) {
        canvas.removeMarker(context.hover, MARKER_OK);
        canvas.addMarker(context.hover, MARKER_NOT_OK);

        context.target = null;
      }
    }

    // add dragger gfx
    context.draggerGfx.translate(e.x, e.y);

    redrawConnection(e);
  });

  eventBus.on([
    'bendpoint.move.end',
    'bendpoint.move.cancel'
  ], function(e) {

    var context = e.context,
        hover = context.hover,
        connection = context.connection;

    // remove dragger gfx
    context.draggerGfx.remove();
    context.newWaypoints = connection.waypoints.slice();
    connection.waypoints = context.originalWaypoints;
    canvas.removeMarker(connection, MARKER_CONNECT_UPDATING);

    if (hover) {
      canvas.removeMarker(hover, MARKER_OK);
      canvas.removeMarker(hover, MARKER_NOT_OK);
    }
  });

  eventBus.on('bendpoint.move.end', function(e) {

    var context = e.context,
        waypoints = context.newWaypoints,
        bendpointIndex = context.bendpointIndex,
        bendpoint = waypoints[bendpointIndex],
        allowed = context.allowed,
        hints;

    // ensure we have actual pixel values bendpoint
    // coordinates (important when zoom level was > 1 during move)
    bendpoint.x = round(bendpoint.x);
    bendpoint.y = round(bendpoint.y);

    if (allowed && context.type === COMMAND_RECONNECT_START) {
      modeling.reconnectStart(context.connection, context.target, bendpoint);
    } else
    if (allowed && context.type === COMMAND_RECONNECT_END) {
      modeling.reconnectEnd(context.connection, context.target, bendpoint);
    } else
    if (allowed !== false && context.type === COMMAND_BENDPOINT_UPDATE) {

      // pass hints on the actual moved bendpoint
      // this is useful for connection and label layouting
      hints = {
        bendpointMove: {
          insert: e.context.insert,
          bendpointIndex: bendpointIndex
        }
      };

      modeling.updateWaypoints(context.connection, filterRedundantWaypoints(waypoints), hints);
    } else {
      redrawConnection(e);

      return false;
    }
  });

  eventBus.on('bendpoint.move.cancel', function(e) {
    redrawConnection(e);
  });
}

BendpointMove.$inject = [ 'injector', 'eventBus', 'canvas', 'dragging', 'graphicsFactory', 'rules', 'modeling' ];

module.exports = BendpointMove;

},{"124":124,"237":237}],123:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    forEach = _dereq_(271);

var Snap = _dereq_(248);

var round = Math.round;


function BendpointSnapping(eventBus) {

  function snapTo(candidates, point) {
    return Snap.snapTo(candidates, point);
  }

  function mid(element) {
    if (element.width) {
      return {
        x: round(element.width / 2 + element.x),
        y: round(element.height / 2 + element.y)
      };
    }
  }

  ////////// connection segment snapping //////////////////////////////////////

  function getConnectionSegmentSnaps(context) {

    var snapPoints = context.snapPoints,
        connection = context.connection,
        waypoints = connection.waypoints,
        segmentStart = context.segmentStart,
        segmentStartIndex = context.segmentStartIndex,
        segmentEnd = context.segmentEnd,
        segmentEndIndex = context.segmentEndIndex,
        axis = context.axis;

    if (snapPoints) {
      return snapPoints;
    }

    var referenceWaypoints = [
      waypoints[segmentStartIndex - 1],
      segmentStart,
      segmentEnd,
      waypoints[segmentEndIndex + 1]
    ];

    if (segmentStartIndex < 2) {
      referenceWaypoints.unshift(mid(connection.source));
    }

    if (segmentEndIndex > waypoints.length - 3) {
      referenceWaypoints.unshift(mid(connection.target));
    }

    context.snapPoints = snapPoints = { horizontal: [] , vertical: [] };

    forEach(referenceWaypoints, function(p) {
      // we snap on existing bendpoints only,
      // not placeholders that are inserted during add
      if (p) {
        p = p.original || p;

        if (axis === 'y') {
          snapPoints.horizontal.push(p.y);
        }

        if (axis === 'x') {
          snapPoints.vertical.push(p.x);
        }
      }
    });

    return snapPoints;
  }

  eventBus.on('connectionSegment.move.move', 1500, function(event) {
    var context = event.context,
        snapPoints = getConnectionSegmentSnaps(context),
        x = event.x,
        y = event.y,
        sx, sy;

    if (!snapPoints) {
      return;
    }

    // snap
    sx = snapTo(snapPoints.vertical, x);
    sy = snapTo(snapPoints.horizontal, y);


    // correction x/y
    var cx = (x - sx),
        cy = (y - sy);

    // update delta
    assign(event, {
      dx: event.dx - cx,
      dy: event.dy - cy,
      x: sx,
      y: sy
    });
  });


  ///////// bendpoint snapping /////////////////////////////

  function getBendpointSnaps(context) {

    var snapPoints = context.snapPoints,
        waypoints = context.connection.waypoints,
        bendpointIndex = context.bendpointIndex;

    if (snapPoints) {
      return snapPoints;
    }

    var referenceWaypoints = [ waypoints[bendpointIndex - 1], waypoints[bendpointIndex + 1] ];

    context.snapPoints = snapPoints = { horizontal: [] , vertical: [] };

    forEach(referenceWaypoints, function(p) {
      // we snap on existing bendpoints only,
      // not placeholders that are inserted during add
      if (p) {
        p = p.original || p;

        snapPoints.horizontal.push(p.y);
        snapPoints.vertical.push(p.x);
      }
    });

    return snapPoints;
  }


  eventBus.on('bendpoint.move.move', 1500, function(event) {

    var context = event.context,
        snapPoints = getBendpointSnaps(context),
        target = context.target,
        targetMid = target && mid(target),
        x = event.x,
        y = event.y,
        sx, sy;

    if (!snapPoints) {
      return;
    }

    // snap
    sx = snapTo(targetMid ? snapPoints.vertical.concat([ targetMid.x ]) : snapPoints.vertical, x);
    sy = snapTo(targetMid ? snapPoints.horizontal.concat([ targetMid.y ]) : snapPoints.horizontal, y);


    // correction x/y
    var cx = (x - sx),
        cy = (y - sy);

    // update delta
    assign(event, {
      dx: event.dx - cx,
      dy: event.dy - cy,
      x: event.x - cx,
      y: event.y - cy
    });
  });
}


BendpointSnapping.$inject = [ 'eventBus' ];

module.exports = BendpointSnapping;
},{"248":248,"271":271,"398":398}],124:[function(_dereq_,module,exports){
'use strict';

var Events = _dereq_(236),
    Geometry = _dereq_(237);

var Snap = _dereq_(248);

var BENDPOINT_CLS = module.exports.BENDPOINT_CLS = 'djs-bendpoint';
var SEGMENT_DRAGGER_CLS = module.exports.SEGMENT_DRAGGER_CLS = 'djs-segment-dragger';


module.exports.toCanvasCoordinates = function(canvas, event) {

  var position = Events.toPoint(event),
      clientRect = canvas._container.getBoundingClientRect(),
      offset;

  // canvas relative position

  offset = {
    x: clientRect.left,
    y: clientRect.top
  };

  // update actual event payload with canvas relative measures

  var viewbox = canvas.viewbox();

  return {
    x: viewbox.x + (position.x - offset.x) / viewbox.scale,
    y: viewbox.y + (position.y - offset.y) / viewbox.scale
  };
};

module.exports.addBendpoint = function(parentGfx, cls) {
  var groupGfx = parentGfx.group().addClass(BENDPOINT_CLS);

  groupGfx.circle(0, 0, 4).addClass('djs-visual');
  groupGfx.circle(0, 0, 10).addClass('djs-hit');

  if (cls) {
    groupGfx.addClass(cls);
  }

  return groupGfx;
};

function createParallelDragger(parentGfx, position, alignment) {
  var draggerGfx = parentGfx.group();

  var width = 14,
      height = 3,
      padding = 6,
      hitWidth = width + padding,
      hitHeight = height + padding;

  draggerGfx.rect(-width / 2, -height / 2, width, height).addClass('djs-visual');
  draggerGfx.rect(-hitWidth / 2, -hitHeight / 2, hitWidth, hitHeight).addClass('djs-hit');

  var matrix = new Snap.Matrix().rotate(alignment === 'h' ? 90 : 0, 0, 0);

  draggerGfx.transform(matrix);

  return draggerGfx;
}


module.exports.addSegmentDragger = function(parentGfx, segmentStart, segmentEnd) {

  var groupGfx = parentGfx.group(),
      mid = Geometry.getMidPoint(segmentStart, segmentEnd),
      alignment = Geometry.pointsAligned(segmentStart, segmentEnd);

  createParallelDragger(groupGfx, mid, alignment);

  groupGfx.addClass(SEGMENT_DRAGGER_CLS);
  groupGfx.addClass(alignment === 'h' ? 'vertical' : 'horizontal');
  groupGfx.translate(mid.x, mid.y);

  return groupGfx;
};

},{"236":236,"237":237,"248":248}],125:[function(_dereq_,module,exports){
'use strict';

var domEvent = _dereq_(416),
    BendpointUtil = _dereq_(124);

var pointsAligned = _dereq_(237).pointsAligned,
    getMidPoint = _dereq_(237).getMidPoint;

var BENDPOINT_CLS = BendpointUtil.BENDPOINT_CLS,
    SEGMENT_DRAGGER_CLS = BendpointUtil.SEGMENT_DRAGGER_CLS;

var getApproxIntersection = _dereq_(240).getApproxIntersection;


/**
 * A service that adds editable bendpoints to connections.
 */
function Bendpoints(eventBus, canvas, interactionEvents,
                    bendpointMove, connectionSegmentMove) {

  function getConnectionIntersection(waypoints, event) {
    var localPosition = BendpointUtil.toCanvasCoordinates(canvas, event),
        intersection = getApproxIntersection(waypoints, localPosition);

    return intersection;
  }

  function isIntersectionMiddle(intersection, waypoints, treshold) {
    var idx = intersection.index,
        p = intersection.point,
        p0, p1, mid, aligned, xDelta, yDelta;

    if (idx <= 0 || intersection.bendpoint) {
      return false;
    }

    p0 = waypoints[idx - 1];
    p1 = waypoints[idx];
    mid = getMidPoint(p0, p1),
    aligned = pointsAligned(p0, p1);
    xDelta = Math.abs(p.x - mid.x);
    yDelta = Math.abs(p.y - mid.y);

    return aligned && xDelta <= treshold && yDelta <= treshold;
  }

  function activateBendpointMove(event, connection) {
    var waypoints = connection.waypoints,
        intersection = getConnectionIntersection(waypoints, event);

    if (!intersection) {
      return;
    }

    if (isIntersectionMiddle(intersection, waypoints, 10)) {
      connectionSegmentMove.start(event, connection, intersection.index);
    } else {
      bendpointMove.start(event, connection, intersection.index, !intersection.bendpoint);
    }
  }

  function bindInteractionEvents(node, eventName, element) {

    domEvent.bind(node, eventName, function(event) {
      interactionEvents.triggerMouseEvent(eventName, event, element);
      event.stopPropagation();
    });
  }

  function getBendpointsContainer(element, create) {

    var layer = canvas.getLayer('overlays'),
        gfx = layer.select('.djs-bendpoints[data-element-id=' + element.id + ']');

    if (!gfx && create) {
      gfx = layer.group().addClass('djs-bendpoints').attr('data-element-id', element.id);

      bindInteractionEvents(gfx.node, 'mousedown', element);
      bindInteractionEvents(gfx.node, 'click', element);
      bindInteractionEvents(gfx.node, 'dblclick', element);
    }

    return gfx;
  }

  function createBendpoints(gfx, connection) {
    connection.waypoints.forEach(function(p, idx) {
      BendpointUtil.addBendpoint(gfx).translate(p.x, p.y);
    });

    // add floating bendpoint
    BendpointUtil.addBendpoint(gfx, 'floating');
  }

  function createSegmentDraggers(gfx, connection) {

    var waypoints = connection.waypoints;

    var segmentStart,
        segmentEnd;

    for (var i = 1; i < waypoints.length; i++) {

      segmentStart = waypoints[i - 1];
      segmentEnd = waypoints[i];

      if (pointsAligned(segmentStart, segmentEnd)) {
        BendpointUtil.addSegmentDragger(gfx, segmentStart, segmentEnd);
      }
    }
  }

  function clearBendpoints(gfx) {
    gfx.selectAll('.' + BENDPOINT_CLS).forEach(function(s) {
      s.remove();
    });
  }

  function clearSegmentDraggers(gfx) {
    gfx.selectAll('.' + SEGMENT_DRAGGER_CLS).forEach(function(s) {
      s.remove();
    });
  }

  function addHandles(connection) {

    var gfx = getBendpointsContainer(connection);

    if (!gfx) {
      gfx = getBendpointsContainer(connection, true);

      createBendpoints(gfx, connection);
      createSegmentDraggers(gfx, connection);
    }

    return gfx;
  }

  function updateHandles(connection) {

    var gfx = getBendpointsContainer(connection);

    if (gfx) {
      clearSegmentDraggers(gfx);
      clearBendpoints(gfx);
      createSegmentDraggers(gfx, connection);
      createBendpoints(gfx, connection);
    }
  }

  eventBus.on('connection.changed', function(event) {
    updateHandles(event.element);
  });

  eventBus.on('connection.remove', function(event) {
    var gfx = getBendpointsContainer(event.element);

    if (gfx) {
      gfx.remove();
    }
  });

  eventBus.on('element.marker.update', function(event) {

    var element = event.element,
        bendpointsGfx;

    if (!element.waypoints) {
      return;
    }

    bendpointsGfx = addHandles(element);
    bendpointsGfx[event.add ? 'addClass' : 'removeClass'](event.marker);
  });

  eventBus.on('element.mousemove', function(event) {

    var element = event.element,
        waypoints = element.waypoints,
        bendpointsGfx,
        floating,
        intersection;

    if (waypoints) {

      bendpointsGfx = getBendpointsContainer(element, true);
      floating = bendpointsGfx.select('.floating');

      if (!floating) {
        return;
      }

      intersection = getConnectionIntersection(waypoints, event.originalEvent);

      if (intersection) {
        floating.translate(intersection.point.x, intersection.point.y);
      }
    }
  });

  eventBus.on('element.mousedown', function(event) {

    var originalEvent = event.originalEvent,
        element = event.element,
        waypoints = element.waypoints;

    if (!waypoints) {
      return;
    }

    activateBendpointMove(originalEvent, element, waypoints);
  });

  eventBus.on('selection.changed', function(event) {
    var newSelection = event.newSelection,
        primary = newSelection[0];

    if (primary && primary.waypoints) {
      addHandles(primary);
    }
  });

  eventBus.on('element.hover', function(event) {
    var element = event.element;

    if (element.waypoints) {
      addHandles(element);
      interactionEvents.registerEvent(event.gfx.node, 'mousemove', 'element.mousemove');
    }
  });

  eventBus.on('element.out', function(event) {
    interactionEvents.unregisterEvent(event.gfx.node, 'mousemove', 'element.mousemove');
  });

  // API

  this.addHandles = addHandles;
  this.updateHandles = updateHandles;
  this.getBendpointsContainer = getBendpointsContainer;
}

Bendpoints.$inject = [
  'eventBus', 'canvas', 'interactionEvents',
  'bendpointMove', 'connectionSegmentMove'
];

module.exports = Bendpoints;

},{"124":124,"237":237,"240":240,"416":416}],126:[function(_dereq_,module,exports){
'use strict';

var Geometry = _dereq_(237),
    BendpointUtil = _dereq_(124),
    LayoutUtil = _dereq_(222);

var MARKER_CONNECT_HOVER = 'connect-hover',
    MARKER_CONNECT_UPDATING = 'djs-updating';

function axisAdd(point, axis, delta) {
  return axisSet(point, axis, point[axis] + delta);
}

function axisSet(point, axis, value) {
  return {
    x: (axis === 'x' ? value : point.x),
    y: (axis === 'y' ? value : point.y)
  };
}

function axisFenced(position, segmentStart, segmentEnd, axis) {

  var maxValue = Math.max(segmentStart[axis], segmentEnd[axis]),
      minValue = Math.min(segmentStart[axis], segmentEnd[axis]);

  var padding = 20;

  var fencedValue = Math.min(Math.max(minValue + padding, position[axis]), maxValue - padding);

  return axisSet(segmentStart, axis, fencedValue);
}

function flipAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/**
 * Get the docking point on the given element.
 *
 * Compute a reasonable docking, if non exists.
 *
 * @param  {Point} point
 * @param  {djs.model.Shape} referenceElement
 * @param  {String} moveAxis (x|y)
 *
 * @return {Point}
 */
function getDocking(point, referenceElement, moveAxis) {

  var referenceMid,
      inverseAxis;

  if (point.original) {
    return point.original;
  } else {
    referenceMid = LayoutUtil.getMid(referenceElement);
    inverseAxis = flipAxis(moveAxis);

    return axisSet(point, inverseAxis, referenceMid[inverseAxis]);
  }
}

/**
 * A component that implements moving of bendpoints
 */
function ConnectionSegmentMove(injector, eventBus, canvas, dragging, graphicsFactory, rules, modeling) {

  // optional connection docking integration
  var connectionDocking = injector.get('connectionDocking', false);


  // API

  this.start = function(event, connection, idx) {

    var context,
        gfx = canvas.getGraphics(connection),
        segmentStartIndex = idx - 1,
        segmentEndIndex = idx,
        waypoints = connection.waypoints,
        segmentStart = waypoints[segmentStartIndex],
        segmentEnd = waypoints[segmentEndIndex],
        direction,
        axis;

    direction = Geometry.pointsAligned(segmentStart, segmentEnd);

    // do not move diagonal connection
    if (!direction) {
      return;
    }

    // the axis where we are going to move things
    axis = direction === 'v' ? 'y' : 'x';

    if (segmentStartIndex === 0) {
      segmentStart = getDocking(segmentStart, connection.source, axis);
    }

    if (segmentEndIndex === waypoints.length - 1) {
      segmentEnd = getDocking(segmentEnd, connection.target, axis);
    }

    context = {
      connection: connection,
      segmentStartIndex: segmentStartIndex,
      segmentEndIndex: segmentEndIndex,
      segmentStart: segmentStart,
      segmentEnd: segmentEnd,
      axis: axis
    };

    dragging.init(event, {
      x: (segmentStart.x + segmentEnd.x)/2,
      y: (segmentStart.y + segmentEnd.y)/2
    }, 'connectionSegment.move', {
      cursor: axis === 'x' ? 'resize-ew' : 'resize-ns',
      data: {
        connection: connection,
        connectionGfx: gfx,
        context: context
      }
    });
  };

  /**
   * Crop connection if connection cropping is provided.
   *
   * @param {Connection} connection
   * @param {Array<Point>} newWaypoints
   *
   * @return {Array<Point>} cropped connection waypoints
   */
  function cropConnection(connection, newWaypoints) {

    // crop connection, if docking service is provided only
    if (!connectionDocking) {
      return newWaypoints;
    }

    var oldWaypoints = connection.waypoints,
        croppedWaypoints;

    // temporary set new waypoints
    connection.waypoints = newWaypoints;

    croppedWaypoints = connectionDocking.getCroppedWaypoints(connection);

    // restore old waypoints
    connection.waypoints = oldWaypoints;

    return croppedWaypoints;
  }

  // DRAGGING IMPLEMENTATION

  function redrawConnection(data) {
    graphicsFactory.update('connection', data.connection, data.connectionGfx);
  }

  function updateDragger(context, segmentOffset, event) {

    var newWaypoints = context.newWaypoints,
        segmentStartIndex = context.segmentStartIndex + segmentOffset,
        segmentStart = newWaypoints[segmentStartIndex],
        segmentEndIndex = context.segmentEndIndex + segmentOffset,
        segmentEnd = newWaypoints[segmentEndIndex],
        axis = flipAxis(context.axis);

    // make sure the dragger does not move
    // outside the connection
    var draggerPosition = axisFenced(event, segmentStart, segmentEnd, axis);

    // update dragger
    context.draggerGfx.translate(draggerPosition.x, draggerPosition.y);
  }

  /**
   * Filter waypoints for redundant ones (i.e. on the same axis).
   * Returns the filtered waypoints and the offset related to the segment move.
   *
   * @param {Array<Point>} waypoints
   * @param {Integer} segmentStartIndex of moved segment start
   *
   * @return {Object} { filteredWaypoints, segmentOffset }
   */
  function filterRedundantWaypoints(waypoints, segmentStartIndex) {

    var segmentOffset = 0;

    var filteredWaypoints = waypoints.filter(function(r, idx) {
      if (Geometry.pointsOnLine(waypoints[idx - 1], waypoints[idx + 1], r)) {

        // remove point and increment offset
        segmentOffset = idx <= segmentStartIndex ? segmentOffset - 1 : segmentOffset;
        return false;
      }

      // dont remove point
      return true;
    });

    return {
      waypoints: filteredWaypoints,
      segmentOffset: segmentOffset
    };
  }

  eventBus.on('connectionSegment.move.start', function(e) {

    var context = e.context,
        connection = e.connection,
        layer = canvas.getLayer('overlays');

    context.originalWaypoints = connection.waypoints.slice();

    // add dragger gfx
    context.draggerGfx = BendpointUtil.addSegmentDragger(layer, context.segmentStart, context.segmentEnd);
    context.draggerGfx.addClass('djs-dragging');

    canvas.addMarker(connection, MARKER_CONNECT_UPDATING);
  });

  eventBus.on('connectionSegment.move.move', function(e) {

    var context = e.context,
        connection = context.connection,
        segmentStartIndex = context.segmentStartIndex,
        segmentEndIndex = context.segmentEndIndex,
        segmentStart = context.segmentStart,
        segmentEnd = context.segmentEnd,
        axis = context.axis;

    var newWaypoints = context.originalWaypoints.slice(),
        newSegmentStart = axisAdd(segmentStart, axis, e['d' + axis]),
        newSegmentEnd = axisAdd(segmentEnd, axis, e['d' + axis]);

    // original waypoint count and added / removed
    // from start waypoint delta. We use the later
    // to retrieve the updated segmentStartIndex / segmentEndIndex
    var waypointCount = newWaypoints.length,
        segmentOffset = 0;

    // move segment start / end by axis delta
    newWaypoints[segmentStartIndex] = newSegmentStart;
    newWaypoints[segmentEndIndex] = newSegmentEnd;

    var sourceToSegmentOrientation,
        targetToSegmentOrientation;

    // handle first segment
    if (segmentStartIndex < 2) {
      sourceToSegmentOrientation = LayoutUtil.getOrientation(connection.source, newSegmentStart);

      // first bendpoint, remove first segment if intersecting
      if (segmentStartIndex === 1) {

        if (sourceToSegmentOrientation === 'intersect') {
          newWaypoints.shift();
          newWaypoints[0] = newSegmentStart;
          segmentOffset--;
        }
      }

      // docking point, add segment if not intersecting anymore
      else {
        if (sourceToSegmentOrientation !== 'intersect') {
          newWaypoints.unshift(segmentStart);
          segmentOffset++;
        }
      }
    }

    // handle last segment
    if (segmentEndIndex > waypointCount - 3) {
      targetToSegmentOrientation = LayoutUtil.getOrientation(connection.target, newSegmentEnd);

      // last bendpoint, remove last segment if intersecting
      if (segmentEndIndex === waypointCount - 2) {

        if (targetToSegmentOrientation === 'intersect') {
          newWaypoints.pop();
          newWaypoints[newWaypoints.length - 1] = newSegmentEnd;
        }
      }

      // last bendpoint, remove last segment if intersecting
      else {
        if (targetToSegmentOrientation !== 'intersect') {
          newWaypoints.push(segmentEnd);
        }
      }
    }

    // update connection waypoints
    context.newWaypoints = connection.waypoints = cropConnection(connection, newWaypoints);

    // update dragger position
    updateDragger(context, segmentOffset, e);

    // save segmentOffset in context
    context.newSegmentStartIndex = segmentStartIndex + segmentOffset;

    // redraw connection
    redrawConnection(e);
  });

  eventBus.on('connectionSegment.move.hover', function(e) {

    e.context.hover = e.hover;
    canvas.addMarker(e.hover, MARKER_CONNECT_HOVER);
  });

  eventBus.on([
    'connectionSegment.move.out',
    'connectionSegment.move.cleanup'
  ], function(e) {

    // remove connect marker
    // if it was added
    var hover = e.context.hover;

    if (hover) {
      canvas.removeMarker(hover, MARKER_CONNECT_HOVER);
    }
  });

  eventBus.on('connectionSegment.move.cleanup', function(e) {

    var context = e.context,
        connection = context.connection;

    // remove dragger gfx
    if (context.draggerGfx) {
      context.draggerGfx.remove();
    }

    canvas.removeMarker(connection, MARKER_CONNECT_UPDATING);
  });

  eventBus.on([
    'connectionSegment.move.cancel',
    'connectionSegment.move.end'
  ], function(e) {
    var context = e.context,
        connection = context.connection;

    connection.waypoints = context.originalWaypoints;

    redrawConnection(e);
  });

  eventBus.on('connectionSegment.move.end', function(e) {

    var context = e.context,
        connection = context.connection,
        newWaypoints = context.newWaypoints,
        newSegmentStartIndex = context.newSegmentStartIndex;

    // ensure we have actual pixel values bendpoint
    // coordinates (important when zoom level was > 1 during move)
    newWaypoints = newWaypoints.map(function(p) {
      return {
        original: p.original,
        x: Math.round(p.x),
        y: Math.round(p.y)
      };
    });

    // apply filter redunant waypoints
    var filtered = filterRedundantWaypoints(newWaypoints, newSegmentStartIndex);

    // get filtered waypoints
    var filteredWaypoints = filtered.waypoints,
        croppedWaypoints = cropConnection(connection, filteredWaypoints),
        segmentOffset = filtered.segmentOffset;

    var hints = {
      segmentMove: {
        segmentStartIndex: context.segmentStartIndex,
        newSegmentStartIndex: newSegmentStartIndex + segmentOffset
      }
    };

    modeling.updateWaypoints(connection, croppedWaypoints, hints);
  });
}

ConnectionSegmentMove.$inject = [
  'injector', 'eventBus', 'canvas',
  'dragging', 'graphicsFactory', 'rules',
  'modeling'
];

module.exports = ConnectionSegmentMove;

},{"124":124,"222":222,"237":237}],127:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [ _dereq_(142), _dereq_(204) ],
  __init__: [ 'bendpoints', 'bendpointSnapping' ],
  bendpoints: [ 'type', _dereq_(125) ],
  bendpointMove: [ 'type', _dereq_(122) ],
  connectionSegmentMove: [ 'type', _dereq_(126) ],
  bendpointSnapping: [ 'type', _dereq_(123) ]
};

},{"122":122,"123":123,"125":125,"126":126,"142":142,"204":204}],128:[function(_dereq_,module,exports){
'use strict';

var getElementType = _dereq_(235).getType;

/**
 * Adds change support to the diagram, including
 *
 * <ul>
 *   <li>redrawing shapes and connections on change</li>
 * </ul>
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {ElementRegistry} elementRegistry
 * @param {GraphicsFactory} graphicsFactory
 */
function ChangeSupport(eventBus, canvas, elementRegistry, graphicsFactory) {

  // redraw shapes / connections on change

  eventBus.on('element.changed', function(event) {

    var element = event.element;

    // element might have been deleted and replaced by new element with same ID
    // thus check for parent of element except for root element
    if (element.parent || element === canvas.getRootElement()) {
      event.gfx = elementRegistry.getGraphics(element);
    }

    // shape + gfx may have been deleted
    if (!event.gfx) {
      return;
    }

    eventBus.fire(getElementType(element) + '.changed', event);
  });

  eventBus.on('elements.changed', function(event) {

    var elements = event.elements;

    elements.forEach(function(e) {
      eventBus.fire('element.changed', { element: e });
    });

    graphicsFactory.updateContainments(elements);
  });

  eventBus.on('shape.changed', function(event) {
    graphicsFactory.update('shape', event.element, event.gfx);
  });

  eventBus.on('connection.changed', function(event) {
    graphicsFactory.update('connection', event.element, event.gfx);
  });
}

ChangeSupport.$inject = [ 'eventBus', 'canvas', 'elementRegistry', 'graphicsFactory' ];

module.exports = ChangeSupport;

},{"235":235}],129:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'changeSupport'],
  changeSupport: [ 'type', _dereq_(128) ]
};
},{"128":128}],130:[function(_dereq_,module,exports){
'use strict';

/**
 * A clip board stub
 */
function Clipboard() {}

module.exports = Clipboard;


Clipboard.prototype.get = function() {
  return this._data;
};

Clipboard.prototype.set = function(data) {
  this._data = data;
};

Clipboard.prototype.clear = function() {
  var data = this._data;

  delete this._data;

  return data;
};

Clipboard.prototype.isEmpty = function() {
  return !this._data;
};
},{}],131:[function(_dereq_,module,exports){
module.exports = {
  clipboard: [ 'type', _dereq_(130) ]
};

},{"130":130}],132:[function(_dereq_,module,exports){
'use strict';

var LayoutUtil = _dereq_(222);

var MARKER_OK = 'connect-ok',
    MARKER_NOT_OK = 'connect-not-ok';


function Connect(eventBus, dragging, modeling, rules, canvas, graphicsFactory) {

  // TODO(nre): separate UI and events

  // rules

  function canConnect(source, target) {
    return rules.allowed('connection.create', {
      source: source,
      target: target
    });
  }


  // layouting

  function crop(start, end, source, target) {

    var sourcePath = graphicsFactory.getShapePath(source),
        targetPath = target && graphicsFactory.getShapePath(target),
        connectionPath = graphicsFactory.getConnectionPath({ waypoints: [ start, end ] });

    start = LayoutUtil.getElementLineIntersection(sourcePath, connectionPath, true) || start;
    end = (target && LayoutUtil.getElementLineIntersection(targetPath, connectionPath, false)) || end;

    return [ start, end ];
  }


  // event handlers

  eventBus.on('connect.move', function(event) {

    var context = event.context,
        source = context.source,
        target = context.target,
        visual = context.visual,
        sourcePosition = context.sourcePosition,
        endPosition,
        waypoints;

    // update connection visuals during drag

    endPosition = {
      x: event.x,
      y: event.y
    };

    waypoints = crop(sourcePosition, endPosition, source, target);

    visual.attr('points', [ waypoints[0].x, waypoints[0].y, waypoints[1].x, waypoints[1].y ]);
  });

  eventBus.on('connect.hover', function(event) {
    var context = event.context,
        source = context.source,
        hover = event.hover,
        canExecute;

    canExecute = context.canExecute = canConnect(source, hover);

    // simply ignore hover
    if (canExecute === null) {
      return;
    }

    context.target = hover;

    canvas.addMarker(hover, canExecute ? MARKER_OK : MARKER_NOT_OK);
  });

  eventBus.on([ 'connect.out', 'connect.cleanup' ], function(event) {
    var context = event.context;

    if (context.target) {
      canvas.removeMarker(context.target, context.canExecute ? MARKER_OK : MARKER_NOT_OK);
    }

    context.target = null;
  });

  eventBus.on('connect.cleanup', function(event) {
    var context = event.context;

    if (context.visual) {
      context.visual.remove();
    }
  });

  eventBus.on('connect.start', function(event) {
    var context = event.context,
        visual;

    visual = canvas.getDefaultLayer().polyline().attr({
      'stroke': '#333',
      'strokeDasharray': [ 1 ],
      'strokeWidth': 2,
      'pointer-events': 'none'
    });

    context.visual = visual;
  });

  eventBus.on('connect.end', function(event) {

    var context = event.context,
        source = context.source,
        sourcePosition = context.sourcePosition,
        target = context.target,
        targetPosition = {
          x: event.x,
          y: event.y
        },
        canExecute = context.canExecute || canConnect(source, target);

    if (!canExecute) {
      return false;
    }

    var attrs = null,
        hints = {
          connectionStart: sourcePosition,
          connectionEnd: targetPosition
        };

    if (typeof canExecute === 'object') {
      attrs = canExecute;
    }

    modeling.connect(source, target, attrs, hints);
  });


  // API

  /**
   * Start connect operation.
   *
   * @param {DOMEvent} event
   * @param {djs.model.Base} source
   * @param {Point} [sourcePosition]
   * @param {Boolean} [autoActivate=false]
   */
  this.start = function(event, source, sourcePosition, autoActivate) {

    if (typeof sourcePosition !== 'object') {
      autoActivate = sourcePosition;
      sourcePosition = LayoutUtil.getMid(source);
    }

    dragging.init(event, 'connect', {
      autoActivate: autoActivate,
      data: {
        shape: source,
        context: {
          source: source,
          sourcePosition: sourcePosition
        }
      }
    });
  };
}

Connect.$inject = [ 'eventBus', 'dragging', 'modeling', 'rules', 'canvas', 'graphicsFactory' ];

module.exports = Connect;

},{"222":222}],133:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(210),
    _dereq_(204),
    _dereq_(142)
  ],
  connect: [ 'type', _dereq_(132) ]
};

},{"132":132,"142":142,"204":204,"210":210}],134:[function(_dereq_,module,exports){
'use strict';

var isFunction = _dereq_(390),
    forEach = _dereq_(271),

    domDelegate = _dereq_(414),
    domEvent = _dereq_(416),
    domAttr = _dereq_(410),
    domQuery = _dereq_(418),
    domClasses = _dereq_(411),
    domify = _dereq_(415);


var entrySelector = '.entry';


/**
 * A context pad that displays element specific, contextual actions next
 * to a diagram element.
 *
 * @param {EventBus} eventBus
 * @param {Overlays} overlays
 */
function ContextPad(eventBus, overlays) {

  this._providers = [];

  this._eventBus = eventBus;
  this._overlays = overlays;

  this._current = null;

  this._init();
}

ContextPad.$inject = [ 'eventBus', 'overlays' ];

/**
 * Registers events needed for interaction with other components
 */
ContextPad.prototype._init = function() {

  var eventBus = this._eventBus;

  var self = this;

  eventBus.on('selection.changed', function(e) {

    var selection = e.newSelection;

    if (selection.length === 1) {
      self.open(selection[0]);
    } else {
      self.close();
    }
  });

  eventBus.on('elements.delete', function(event) {
    var elements = event.elements;

    forEach(elements, function(e) {
      if (self.isOpen(e)) {
        self.close();
      }
    });
  });

  eventBus.on('element.changed', function(event) {
    var element = event.element,
        current = self._current;

    // force reopen if element for which we are currently opened changed
    if (current && current.element === element) {
      self.open(element, true);
    }
  });
};


/**
 * Register a provider with the context pad
 *
 * @param  {ContextPadProvider} provider
 */
ContextPad.prototype.registerProvider = function(provider) {
  this._providers.push(provider);
};


/**
 * Returns the context pad entries for a given element
 *
 * @param {djs.element.Base} element
 *
 * @return {Array<ContextPadEntryDescriptor>} list of entries
 */
ContextPad.prototype.getEntries = function(element) {
  var entries = {};

  // loop through all providers and their entries.
  // group entries by id so that overriding an entry is possible
  forEach(this._providers, function(provider) {
    var e = provider.getContextPadEntries(element);

    forEach(e, function(entry, id) {
      entries[id] = entry;
    });
  });

  return entries;
};


/**
 * Trigger an action available on the opened context pad
 *
 * @param  {String} action
 * @param  {Event} event
 * @param  {Boolean} [autoActivate=false]
 */
ContextPad.prototype.trigger = function(action, event, autoActivate) {

  var element = this._current.element,
      entries = this._current.entries,
      entry,
      handler,
      originalEvent,
      button = event.delegateTarget || event.target;

  if (!button) {
    return event.preventDefault();
  }

  entry = entries[domAttr(button, 'data-action')];
  handler = entry.action;

  originalEvent = event.originalEvent || event;

  // simple action (via callback function)
  if (isFunction(handler)) {
    if (action === 'click') {
      return handler(originalEvent, element, autoActivate);
    }
  } else {
    if (handler[action]) {
      return handler[action](originalEvent, element, autoActivate);
    }
  }

  // silence other actions
  event.preventDefault();
};


/**
 * Open the context pad for the given element
 *
 * @param {djs.model.Base} element
 * @param {Boolean} force if true, force reopening the context pad
 */
ContextPad.prototype.open = function(element, force) {
  if (!force && this.isOpen(element)) {
    return;
  }

  this.close();
  this._updateAndOpen(element);
};


ContextPad.prototype._updateAndOpen = function(element) {

  var entries = this.getEntries(element),
      pad = this.getPad(element),
      html = pad.html;

  forEach(entries, function(entry, id) {
    var grouping = entry.group || 'default',
        control = domify(entry.html || '<div class="entry" draggable="true"></div>'),
        container;

    domAttr(control, 'data-action', id);

    container = domQuery('[data-group=' + grouping + ']', html);
    if (!container) {
      container = domify('<div class="group" data-group="' + grouping + '"></div>');
      html.appendChild(container);
    }

    container.appendChild(control);

    if (entry.className) {
      domClasses(control).add(entry.className);
    }

    if (entry.title) {
      domAttr(control, 'title', entry.title);
    }

    if (entry.imageUrl) {
      control.appendChild(domify('<img src="' + entry.imageUrl + '">'));
    }
  });

  domClasses(html).add('open');

  this._current = {
    element: element,
    pad: pad,
    entries: entries
  };

  this._eventBus.fire('contextPad.open', { current: this._current });
};


ContextPad.prototype.getPad = function(element) {
  if (this.isOpen()) {
    return this._current.pad;
  }

  var self = this;

  var overlays = this._overlays;

  var html = domify('<div class="djs-context-pad"></div>');

  domDelegate.bind(html, entrySelector, 'click', function(event) {
    self.trigger('click', event);
  });

  domDelegate.bind(html, entrySelector, 'dragstart', function(event) {
    self.trigger('dragstart', event);
  });

  // stop propagation of mouse events
  domEvent.bind(html, 'mousedown', function(event) {
    event.stopPropagation();
  });

  this._overlayId = overlays.add(element, 'context-pad', {
    position: {
      right: -9,
      top: -6
    },
    html: html
  });

  var pad = overlays.get(this._overlayId);

  this._eventBus.fire('contextPad.create', { element: element, pad: pad });

  return pad;
};


/**
 * Close the context pad
 */
ContextPad.prototype.close = function() {
  if (!this.isOpen()) {
    return;
  }

  this._overlays.remove(this._overlayId);

  this._overlayId = null;

  this._eventBus.fire('contextPad.close', { current: this._current });

  this._current = null;
};

/**
 * Check if pad is open. If element is given, will check
 * if pad is opened with given element.
 *
 * @param {Element} element
 * @return {Boolean}
 */
ContextPad.prototype.isOpen = function(element) {
  return !!this._current && (!element ? true : this._current.element === element);
};

module.exports = ContextPad;

},{"271":271,"390":390,"410":410,"411":411,"414":414,"415":415,"416":416,"418":418}],135:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(150),
    _dereq_(190)
  ],
  contextPad: [ 'type', _dereq_(134) ]
};
},{"134":134,"150":150,"190":190}],136:[function(_dereq_,module,exports){
'use strict';

var isArray = _dereq_(389),
    forEach = _dereq_(271),
    map = _dereq_(273),
    find = _dereq_(270),
    findIndex = _dereq_(258),
    sortBy = _dereq_(277),
    reduce = _dereq_(274);

var getBBox = _dereq_(235).getBBox;

var PositionUtil = _dereq_(244);

var CopyPasteUtil = _dereq_(233),
    ElementsUtil = _dereq_(235);



function CopyPaste(eventBus, modeling, elementFactory, rules, clipboard, canvas) {
  this._eventBus = eventBus;
  this._modeling = modeling;
  this._elementFactory = elementFactory;
  this._rules = rules;
  this._canvas = canvas;

  this._clipboard = clipboard;

  this._descriptors = [];


  // Element creation priorities:
  // - 1: Independent shapes
  // - 2: Attached shapes
  // - 3: Connections
  // - 4: labels
  this.registerDescriptor(function(element, descriptor) {
    // Base priority
    descriptor.priority = 1;

    descriptor.id = element.id;

    if (element.parent) {
      descriptor.parent = element.parent.id;
    }

    if (element.labelTarget) {
      // Labels priority
      descriptor.priority = 4;
      descriptor.labelTarget = element.labelTarget.id;
    }

    if (element.host) {
      // Attached shapes priority
      descriptor.priority = 2;
      descriptor.host = element.host.id;
    }

    if (element.x) {
      descriptor.x = element.x;
      descriptor.y = element.y;
    }

    if (element.width) {
      descriptor.width = element.width;
      descriptor.height = element.height;
    }

    if (element.waypoints) {
      // Connections priority
      descriptor.priority = 3;
      descriptor.waypoints = [];

      forEach(element.waypoints, function(waypoint) {
        var wp = {
          x: waypoint.x,
          y: waypoint.y
        };

        if (waypoint.original) {
          wp.original = {
            x: waypoint.original.x,
            y: waypoint.original.y
          };
        }

        descriptor.waypoints.push(wp);
      });
    }

    if (element.source && element.target) {
      descriptor.source = element.source.id;
      descriptor.target = element.target.id;
    }

    return descriptor;
  });
}

CopyPaste.$inject = [
  'eventBus',
  'modeling',
  'elementFactory',
  'rules',
  'clipboard',
  'canvas'
];

module.exports = CopyPaste;

/**
 * Copy a number of elements.
 *
 * @param {djs.model.Base} selectedElements
 *
 * @return {Object} the copied tree
 */
CopyPaste.prototype.copy = function(selectedElements) {
  var clipboard = this._clipboard,
      tree, bbox;

  if (!isArray(selectedElements)) {
    selectedElements = selectedElements ? [ selectedElements ] : [];
  }

  if (!selectedElements.length) {
    return;
  }

  tree = this.createTree(selectedElements);

  bbox = this._bbox = PositionUtil.center(getBBox(tree.allShapes));

  // not needed after computing the center position of the copied elements
  delete tree.allShapes;

  forEach(tree, function(elements) {

    forEach(elements, function(element) {
      var delta, labelTarget;

      // set label's relative position to their label target
      if (element.labelTarget) {
        labelTarget = find(elements, { id: element.labelTarget });

        // just grab the delta from the first waypoint
        if (labelTarget.waypoints) {
          delta = PositionUtil.delta(element, labelTarget.waypoints[0]);
        } else {
          delta = PositionUtil.delta(element, labelTarget);
        }

      } else
      if (element.priority === 3) {
        // connections have priority 3
        delta = [];

        forEach(element.waypoints, function(waypoint) {
          var waypointDelta = PositionUtil.delta(waypoint, bbox);

          delta.push(waypointDelta);
        }, this);
      } else {
        delta = PositionUtil.delta(element, bbox);
      }

      element.delta = delta;
    });
  });

  this._eventBus.fire('elements.copy', { context: { tree: tree } });

  // if tree is empty, means that nothing can be or is allowed to be copied
  if (Object.keys(tree).length === 0) {
    clipboard.clear();
  } else {
    clipboard.set(tree);
  }

  this._eventBus.fire('elements.copied', { context: { tree: tree } });

  return tree;
};


// Allow pasting under the cursor
CopyPaste.prototype.paste = function(context) {
  var clipboard = this._clipboard,
      modeling = this._modeling,
      eventBus = this._eventBus,
      rules = this._rules;

  var tree = clipboard.get(),
      topParent = context.element,
      position = context.point,
      newTree, canPaste;

  if (clipboard.isEmpty()) {
    return;
  }

  newTree = reduce(tree, function(pasteTree, elements, depthStr) {
    var depth = parseInt(depthStr, 10);

    if (isNaN(depth)) {
      return pasteTree;
    }

    pasteTree[depth] = elements;

    return pasteTree;
  }, {}, this);


  canPaste = rules.allowed('elements.paste', {
    tree: newTree,
    target: topParent
  });

  if (!canPaste) {
    eventBus.fire('elements.paste.rejected', {
      context: {
        tree: newTree,
        position: position,
        target: topParent
      }
    });

    return;
  }

  modeling.pasteElements(newTree, topParent, position);
};


CopyPaste.prototype._computeDelta = function(elements, element) {
  var bbox = this._bbox,
      delta = {};

  // set label's relative position to their label target
  if (element.labelTarget) {
    console.log(elements);
    return PositionUtil.delta(element, element.labelTarget);
  }

  // connections have prority 3
  if (element.priority === 3) {
    delta = [];

    forEach(element.waypoints, function(waypoint) {
      var waypointDelta = PositionUtil.delta(waypoint, bbox);

      delta.push(waypointDelta);
    }, this);
  } else {
    delta = PositionUtil.delta(element, bbox);
  }

  return delta;
};


/**
 * Checks if the element in question has a relations to other elements.
 * Possible dependants: connections, labels, attachers
 *
 * @param  {Array} elements
 * @param  {Object} element
 *
 * @return {Boolean}
 */
CopyPaste.prototype.hasRelations = function(elements, element) {
  var source, target, labelTarget;

  if (element.waypoints) {
    source = find(elements, { id: element.source.id });
    target = find(elements, { id: element.target.id });

    if (!source || !target) {
      return false;
    }
  }

  if (element.labelTarget) {
    labelTarget = find(elements, { id: element.labelTarget.id });

    if (!labelTarget) {
      return false;
    }
  }

  return true;
};


CopyPaste.prototype.registerDescriptor = function(descriptor) {
  if (typeof descriptor !== 'function') {
    throw new Error('the descriptor must be a function');
  }

  if (this._descriptors.indexOf(descriptor) !== -1) {
    throw new Error('this descriptor is already registered');
  }

  this._descriptors.push(descriptor);
};


CopyPaste.prototype._executeDescriptors = function(data) {
  if (!data.descriptor) {
    data.descriptor = {};
  }

  forEach(this._descriptors, function(descriptor) {
    data.descriptor = descriptor(data.element, data.descriptor);
  });

  return data;
};

/**
 * Creates a tree like structure from an arbitrary collection of elements
 *
 * @example
 * tree: {
 *	0: [
 *		{ id: 'shape_12da', priority: 1, ... },
 *		{ id: 'shape_01bj', priority: 1, ... },
 *		{ id: 'connection_79fa', source: 'shape_12da', target: 'shape_01bj', priority: 3, ... },
 *	],
 *	1: [ ... ]
 * };
 *
 * @param  {Array} elements
 * @return {Object}
 */
CopyPaste.prototype.createTree = function(elements) {
  var rules = this._rules;

  var tree = {},
      includedElements = [],
      _elements;

  var topLevel = CopyPasteUtil.getTopLevel(elements);

  tree.allShapes = [];

  function canCopy(collection, element) {
    return rules.allowed('element.copy', {
      collection: collection,
      element: element
    });
  }

  function includeElement(data) {
    var idx = findIndex(includedElements, { element: data.element }),
        element;

    if (idx !== -1) {
      element = includedElements[idx];
    } else {
      return includedElements.push(data);
    }

    // makes sure that it has the correct depth
    if (element.depth < data.depth) {
      includedElements.splice(idx, 1);

      includedElements.push(data);
    }
  }


  ElementsUtil.eachElement(topLevel, function(element, i, depth) {
    var nestedChildren = element.children;

    // don't add labels directly
    if (element.labelTarget) {
      return;
    }

    function getNested(lists) {
      forEach(lists, function(list) {
        if (list && list.length) {

          forEach(list, function(elem) {
            // fetch element's label
            if (elem.label) {
              includeElement({
                element: elem.label,
                depth: depth
              });
            }

            includeElement({
              element: elem,
              depth: depth
            });
          });
        }
      });
    }

    // fetch element's label
    if (element.label) {
      includeElement({
        element: element.label,
        depth: depth
      });
    }

    getNested([ element.attachers, element.incoming, element.outgoing ]);

    includeElement({
      element: element,
      depth: depth
    });

    if (nestedChildren) {
      return nestedChildren;
    }
  });

  includedElements = map(includedElements, function(data) {
    // this is where other registered descriptors hook in
    return this._executeDescriptors(data);
  }, this);

  // order the elements to check if the ones dependant on others (by relationship)
  // can be copied. f.ex: label needs it's label target
  includedElements = sortBy(includedElements, function(data) {
    return data.descriptor.priority;
  });

  _elements = map(includedElements, function(data) {
    return data.element;
  });

  forEach(includedElements, function(data) {
    var depth = data.depth;

    if (!this.hasRelations(tree.allShapes, data.element)) {
      return;
    }

    if (!canCopy(_elements, data.element)) {
      return;
    }

    tree.allShapes.push(data.element);

    // create depth branches
    if (!tree[depth]) {
      tree[depth] = [];
    }

    tree[depth].push(data.descriptor);
  }, this);

  return tree;
};

},{"233":233,"235":235,"244":244,"258":258,"270":270,"271":271,"273":273,"274":274,"277":277,"389":389}],137:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(131),
    _dereq_(204),
    _dereq_(182)
  ],
  __init__: [ 'copyPaste' ],
  copyPaste: [ 'type', _dereq_(136) ]
};

},{"131":131,"136":136,"182":182,"204":204}],138:[function(_dereq_,module,exports){
'use strict';

var LOW_PRIORITY = 750;

var MARKER_OK = 'drop-ok',
    MARKER_NOT_OK = 'drop-not-ok',
    MARKER_ATTACH = 'attach-ok',
    MARKER_NEW_PARENT = 'new-parent';


function Create(eventBus, dragging, rules, modeling, canvas, styles, graphicsFactory) {

  // rules

  function canCreate(shape, target, source, position) {

    if (source) {
      return rules.allowed('shape.append', {
        source: source,
        shape: shape,
        target: target,
        position: position
      });
    } else {
      return rules.allowed('shape.create', {
        shape: shape,
        target: target,
        position: position
      });
    }
  }


  /** set drop marker on an element */
  function setMarker(element, marker) {

    [ MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT ].forEach(function(m) {

      if (m === marker) {
        canvas.addMarker(element, m);
      } else {
        canvas.removeMarker(element, m);
      }
    });
  }


  // visual helpers

  function createVisual(shape) {
    var group, preview, visual;

    group = canvas.getDefaultLayer().group().attr(styles.cls('djs-drag-group', [ 'no-events' ]));

    preview = group.group().addClass('djs-dragger');

    preview.translate(shape.width / -2, shape.height / -2);

    visual = preview.group().addClass('djs-visual');

    // hijack renderer to draw preview
    graphicsFactory.drawShape(visual, shape);

    return group;
  }


  // event handlers

  eventBus.on('create.move', function(event) {

    var context = event.context,
        hover = event.hover,
        canExecute;

    var position = {
      x: event.x,
      y: event.y
    };

    canExecute = context.canExecute = hover && canCreate(context.shape, hover, context.source, position);

    // ignore hover visually if canExecute is null
    if (hover && canExecute !== null) {
      context.target = hover;

      if (canExecute === 'attach') {
        setMarker(hover, MARKER_ATTACH);
      } else {
        setMarker(hover, context.canExecute ? MARKER_NEW_PARENT : MARKER_NOT_OK);
      }
    }
  });

  eventBus.on('create.move', LOW_PRIORITY, function(event) {

    var context = event.context,
        shape = context.shape,
        visual = context.visual;

    // lazy init drag visual once we received the first real
    // drag move event (this allows us to get the proper canvas local coordinates)
    if (!visual) {
      visual = context.visual = createVisual(shape);
    }

    visual.translate(event.x, event.y);
  });


  eventBus.on([ 'create.end', 'create.out', 'create.cleanup' ], function(event) {
    var context = event.context,
        target = context.target;

    if (target) {
      setMarker(target, null);
    }
  });

  eventBus.on('create.end', function(event) {
    var context = event.context,
        source = context.source,
        shape = context.shape,
        target = context.target,
        canExecute = context.canExecute,
        isAttach,
        position = {
          x: event.x,
          y: event.y
        };

    if (!canExecute) {
      return false;
    }

    if (source) {
      shape = modeling.appendShape(source, shape, position, target);
    } else {
      isAttach = canExecute === 'attach';

      shape = modeling.createShape(shape, position, target, isAttach);
    }

    // make sure we provide the actual attached
    // shape with the context so that selection and
    // other components can use it right after the create
    // operation ends
    context.shape = shape;
  });


  eventBus.on('create.cleanup', function(event) {
    var context = event.context;

    if (context.visual) {
      context.visual.remove();
    }
  });

  // API

  this.start = function(event, shape, source) {

    dragging.init(event, 'create', {
      cursor: 'grabbing',
      autoActivate: true,
      data: {
        shape: shape,
        context: {
          shape: shape,
          source: source
        }
      }
    });
  };
}

Create.$inject = [ 'eventBus', 'dragging', 'rules', 'modeling', 'canvas', 'styles', 'graphicsFactory' ];

module.exports = Create;

},{}],139:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(142),
    _dereq_(210),
    _dereq_(204)
  ],
  create: [ 'type', _dereq_(138) ]
};

},{"138":138,"142":142,"204":204,"210":210}],140:[function(_dereq_,module,exports){
'use strict';

/* global TouchEvent */

var round = Math.round;

var assign = _dereq_(398);

var domEvent = _dereq_(416),
    Event = _dereq_(236),
    ClickTrap = _dereq_(231),
    Cursor = _dereq_(234);

var EventBusEvent = _dereq_(108).Event;

var DRAG_ACTIVE_CLS = 'djs-drag-active';


function suppressEvent(event) {
  if (event instanceof MouseEvent) {
    Event.stopEvent(event, true);
  } else {
    Event.preventDefault(event);
  }
}

function getLength(point) {
  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));
}

function substract(p1, p2) {
  return {
    x: p1.x - p2.x,
    y: p1.y - p2.y
  };
}

/**
 * A helper that fires canvas localized drag events and realizes
 * the general "drag-and-drop" look and feel.
 *
 * Calling {@link Dragging#activate} activates dragging on a canvas.
 *
 * It provides the following:
 *
 *   * emits life cycle events, namespaced with a prefix assigned
 *     during dragging activation
 *   * sets and restores the cursor
 *   * sets and restores the selection
 *   * ensures there can be only one drag operation active at a time
 *
 * Dragging may be canceled manually by calling {@link Dragging#cancel}
 * or by pressing ESC.
 *
 *
 * ## Life-cycle events
 *
 * Dragging can be in three different states, off, initialized
 * and active.
 *
 * (1) off: no dragging operation is in progress
 * (2) initialized: a new drag operation got initialized but not yet
 *                  started (i.e. because of no initial move)
 * (3) started: dragging is in progress
 *
 * Eventually dragging will be off again after a drag operation has
 * been ended or canceled via user click or ESC key press.
 *
 * To indicate transitions between these states dragging emits generic
 * life-cycle events with the `drag.` prefix _and_ events namespaced
 * to a prefix choosen by a user during drag initialization.
 *
 * The following events are emitted (appropriately prefixed) via
 * the {@link EventBus}.
 *
 * * `init`
 * * `start`
 * * `move`
 * * `end`
 * * `ended` (dragging already in off state)
 * * `cancel` (only if previously started)
 * * `canceled` (dragging already in off state, only if previously started)
 * * `cleanup`
 *
 *
 * @example
 *
 * function MyDragComponent(eventBus, dragging) {
 *
 *   eventBus.on('mydrag.start', function(event) {
 *     console.log('yes, we start dragging');
 *   });
 *
 *   eventBus.on('mydrag.move', function(event) {
 *     console.log('canvas local coordinates', event.x, event.y, event.dx, event.dy);
 *
 *     // local drag data is passed with the event
 *     event.context.foo; // "BAR"
 *
 *     // the original mouse event, too
 *     event.originalEvent; // MouseEvent(...)
 *   });
 *
 *   eventBus.on('element.click', function(event) {
 *     dragging.init(event, 'mydrag', {
 *       cursor: 'grabbing',
 *       data: {
 *         context: {
 *           foo: "BAR"
 *         }
 *       }
 *     });
 *   });
 * }
 */
function Dragging(eventBus, canvas, selection) {

  var defaultOptions = {
    threshold: 5,
    trapClick: true
  };

  // the currently active drag operation
  // dragging is active as soon as this context exists.
  //
  // it is visually _active_ only when a context.active flag is set to true.
  var context;

  /* convert a global event into local coordinates */
  function toLocalPoint(globalPosition) {

    var viewbox = canvas.viewbox();

    var clientRect = canvas._container.getBoundingClientRect();

    return {
      x: viewbox.x + round((globalPosition.x - clientRect.left) / viewbox.scale),
      y: viewbox.y + round((globalPosition.y - clientRect.top) / viewbox.scale)
    };
  }

  // helpers

  function fire(type, dragContext) {
    dragContext = dragContext || context;

    var event = assign(new EventBusEvent(), dragContext.payload, dragContext.data);

    // default integration
    if (eventBus.fire('drag.' + type, event) === false) {
      return false;
    }

    return eventBus.fire(dragContext.prefix + '.' + type, event);
  }

  // event listeners

  function move(event, activate) {
    var payload = context.payload,
        displacement = context.displacement;

    var globalStart = context.globalStart,
        globalCurrent = Event.toPoint(event),
        globalDelta = substract(globalCurrent, globalStart);

    var localStart = context.localStart,
        localCurrent = toLocalPoint(globalCurrent),
        localDelta = substract(localCurrent, localStart);

    // activate context explicitly or once threshold is reached
    if (!context.active && (activate || getLength(globalDelta) > context.threshold)) {

      // fire start event with original
      // starting coordinates

      assign(payload, {
        x: localStart.x + displacement.x,
        y: localStart.y + displacement.y,
        dx: 0,
        dy: 0
      }, { originalEvent: event });

      if (false === fire('start')) {
        return cancel();
      }

      context.active = true;

      // unset selection and remember old selection
      // the previous (old) selection will always passed
      // with the event via the event.previousSelection property
      if (!context.keepSelection) {
        payload.previousSelection = selection.get();
        selection.select(null);
      }

      // allow custom cursor
      if (context.cursor) {
        Cursor.set(context.cursor);
      }

      // indicate dragging via marker on root element
      canvas.addMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);
    }

    suppressEvent(event);

    if (context.active) {

      // update payload with actual coordinates
      assign(payload, {
        x: localCurrent.x + displacement.x,
        y: localCurrent.y + displacement.y,
        dx: localDelta.x,
        dy: localDelta.y
      }, { originalEvent: event });

      // emit move event
      fire('move');
    }
  }

  function end(event) {
    var previousContext,
        returnValue = true;

    if (context.active) {

      if (event) {
        context.payload.originalEvent = event;

        // suppress original event (click, ...)
        // because we just ended a drag operation
        suppressEvent(event);
      }

      // implementations may stop restoring the
      // original state (selections, ...) by preventing the
      // end events default action
      returnValue = fire('end');
    }

    if (returnValue === false) {
      fire('rejected');
    }

    previousContext = cleanup(returnValue !== true);

    // last event to be fired when all drag operations are done
    // at this point in time no drag operation is in progress anymore
    fire('ended', previousContext);
  }


  // cancel active drag operation if the user presses
  // the ESC key on the keyboard

  function checkCancel(event) {

    if (event.which === 27) {
      event.preventDefault();

      cancel();
    }
  }


  // prevent ghost click that might occur after a finished
  // drag and drop session

  function trapClickAndEnd(event) {

    var untrap;

    // trap the click in case we are part of an active
    // drag operation. This will effectively prevent
    // the ghost click that cannot be canceled otherwise.
    if (context.active) {
      untrap = ClickTrap.install();
      setTimeout(untrap, 400);
    }

    end(event);
  }

  function trapTouch(event) {
    move(event);
  }

  // update the drag events hover (djs.model.Base) and hoverGfx (Snap<SVGElement>)
  // properties during hover and out and fire {prefix}.hover and {prefix}.out properties
  // respectively

  function hover(event) {
    var payload = context.payload;

    payload.hoverGfx = event.gfx;
    payload.hover = event.element;

    fire('hover');
  }

  function out(event) {
    fire('out');

    var payload = context.payload;

    payload.hoverGfx = null;
    payload.hover = null;
  }


  // life-cycle methods

  function cancel(restore) {
    var previousContext;

    if (!context) {
      return;
    }

    var wasActive = context.active;

    if (wasActive) {
      fire('cancel');
    }

    previousContext = cleanup(restore);

    if (wasActive) {
      // last event to be fired when all drag operations are done
      // at this point in time no drag operation is in progress anymore
      fire('canceled', previousContext);
    }
  }

  function cleanup(restore) {
    var previousContext,
        endDrag;

    fire('cleanup');

    // reset cursor
    Cursor.unset();

    if (context.trapClick) {
      endDrag = trapClickAndEnd;
    } else {
      endDrag = end;
    }

    // reset dom listeners
    domEvent.unbind(document, 'mousemove', move);

    domEvent.unbind(document, 'mousedown', endDrag, true);
    domEvent.unbind(document, 'mouseup', endDrag, true);

    domEvent.unbind(document, 'keyup', checkCancel);

    domEvent.unbind(document, 'touchstart', trapTouch, true);
    domEvent.unbind(document, 'touchcancel', cancel, true);
    domEvent.unbind(document, 'touchmove', move, true);
    domEvent.unbind(document, 'touchend', end, true);

    eventBus.off('element.hover', hover);
    eventBus.off('element.out', out);

    // remove drag marker on root element
    canvas.removeMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);

    // restore selection, unless it has changed
    var previousSelection = context.payload.previousSelection;

    if (restore !== false && previousSelection && !selection.get().length) {
      selection.select(previousSelection);
    }

    previousContext = context;

    context = null;

    return previousContext;
  }

  /**
   * Initialize a drag operation.
   *
   * If `localPosition` is given, drag events will be emitted
   * relative to it.
   *
   * @param {MouseEvent|TouchEvent} [event]
   * @param {Point} [localPosition] actual diagram local position this drag operation should start at
   * @param {String} prefix
   * @param {Object} [options]
   */
  function init(event, relativeTo, prefix, options) {

    // only one drag operation may be active, at a time
    if (context) {
      cancel(false);
    }

    if (typeof relativeTo === 'string') {
      options = prefix;
      prefix = relativeTo;
      relativeTo = null;
    }

    options = assign({}, defaultOptions, options || {});

    var data = options.data || {},
        originalEvent,
        globalStart,
        endDrag;

    if (options.trapClick) {
      endDrag = trapClickAndEnd;
    } else {
      endDrag = end;
    }

    if (event) {
      originalEvent = Event.getOriginal(event) || event;
      globalStart = Event.toPoint(event);

      suppressEvent(event);
    } else {
      originalEvent = null;
      globalStart = { x: 0, y: 0 };
    }

    var localStart = toLocalPoint(globalStart);

    if (!relativeTo) {
      relativeTo = localStart;
    }

    context = assign({
      prefix: prefix,
      data: data,
      payload: {},
      globalStart: globalStart,
      displacement: substract(relativeTo, localStart),
      localStart: localStart
    }, options);

    // skip dom registration if trigger
    // is set to manual (during testing)
    if (!options.manual) {

      // add dom listeners

      // fixes TouchEvent not being available on desktop Firefox
      if (typeof TouchEvent !== 'undefined' && originalEvent instanceof TouchEvent) {
        domEvent.bind(document, 'touchstart', trapTouch, true);
        domEvent.bind(document, 'touchcancel', cancel, true);
        domEvent.bind(document, 'touchmove', move, true);
        domEvent.bind(document, 'touchend', end, true);
      } else {
        // assume we use the mouse to interact per default
        domEvent.bind(document, 'mousemove', move);

        domEvent.bind(document, 'mousedown', endDrag, true);
        domEvent.bind(document, 'mouseup', endDrag, true);
      }

      domEvent.bind(document, 'keyup', checkCancel);

      eventBus.on('element.hover', hover);
      eventBus.on('element.out', out);
    }

    fire('init');

    if (options.autoActivate) {
      move(event, true);
    }
  }

  // cancel on diagram destruction
  eventBus.on('diagram.destroy', cancel);


  // API

  this.init = init;
  this.move = move;
  this.hover = hover;
  this.out = out;
  this.end = end;

  this.cancel = cancel;

  // for introspection

  this.context = function() {
    return context;
  };

  this.setOptions = function(options) {
    assign(defaultOptions, options);
  };
}

Dragging.$inject = [ 'eventBus', 'canvas', 'selection' ];

module.exports = Dragging;

},{"108":108,"231":231,"234":234,"236":236,"398":398,"416":416}],141:[function(_dereq_,module,exports){
'use strict';

var domClosest = _dereq_(413);

var Snap = _dereq_(248);

var Event = _dereq_(236);

function getGfx(target) {
  var node = domClosest(target, 'svg, .djs-element', true);
  return node && new Snap(node);
}


/**
 * Browsers may swallow the hover event if users are to
 * fast with the mouse.
 *
 * @see http://stackoverflow.com/questions/7448468/why-cant-i-reliably-capture-a-mouseout-event
 *
 * The fix implemented in this component ensure that we
 * have a hover state after a successive drag.move event.
 *
 * @param {EventBus} eventBus
 * @param {Dragging} dragging
 * @param {ElementRegistry} elementRegistry
 */
function HoverFix(eventBus, dragging, elementRegistry) {

  var self = this;

  // we wait for a specific sequence of events before
  // emitting a fake drag.hover event.
  //
  // Event Sequence:
  //
  // drag.start
  // drag.move
  // drag.move >> ensure we are hovering
  //
  eventBus.on('drag.start', function(event) {

    eventBus.once('drag.move', function() {

      eventBus.once('drag.move', function(event) {

        self.ensureHover(event);
      });
    });
  });

  /**
   * Make sure we are god damn hovering!
   *
   * @param {Event} dragging event
   */
  this.ensureHover = function(event) {

    if (event.hover) {
      return;
    }

    var originalEvent = event.originalEvent,
        position,
        target,
        element,
        gfx;

    if (!(originalEvent instanceof MouseEvent)) {
      return;
    }

    position = Event.toPoint(originalEvent);

    // damn expensive operation, ouch!
    target = document.elementFromPoint(position.x, position.y);

    gfx = getGfx(target);

    if (gfx) {
      element = elementRegistry.get(gfx);

      dragging.hover({ element: element, gfx: gfx });
    }
  };

}

HoverFix.$inject = [ 'eventBus', 'dragging', 'elementRegistry' ];

module.exports = HoverFix;
},{"236":236,"248":248,"413":413}],142:[function(_dereq_,module,exports){
module.exports = {
  __init__: [
    'hoverFix'
  ],
  __depends__: [
    _dereq_(210)
  ],
  dragging: [ 'type', _dereq_(140) ],
  hoverFix: [ 'type', _dereq_(141) ]
};
},{"140":140,"141":141,"210":210}],143:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    isArray = _dereq_(389);

var NOT_REGISTERED_ERROR = 'is not a registered action',
    IS_REGISTERED_ERROR = 'is already registered';


/**
 * An interface that provides access to modeling actions by decoupling
 * the one who requests the action to be triggered and the trigger itself.
 *
 * It's possible to add new actions by registering them with ´registerAction´ and likewise
 * unregister existing ones with ´unregisterAction´.
 *
 */
function EditorActions(eventBus, commandStack, modeling, selection,
  zoomScroll, copyPaste, canvas, rules, mouseTracking) {

  this._actions = {
    undo: function() {
      commandStack.undo();
    },
    redo: function() {
      commandStack.redo();
    },
    copy: function() {
      var selectedElements = selection.get();

      copyPaste.copy(selectedElements);
    },
    paste: function() {
      var context = mouseTracking.getHoverContext();

      copyPaste.paste(context);
    },
    stepZoom: function(opts) {
      zoomScroll.stepZoom(opts.value);
    },
    zoom: function(opts) {
      canvas.zoom(opts.value);
    },
    removeSelection: function() {
      var selectedElements = selection.get();

      if (selectedElements.length) {
        var allowed = rules.allowed('elements.delete', { elements: selectedElements }),
            removableElements;

        if (allowed === false) {
          return;
        }
        else if (isArray(allowed)) {
          removableElements = allowed;
        }
        else {
          removableElements = selectedElements;
        }

        if (removableElements.length) {
          modeling.removeElements(removableElements.slice());
        }
      }
    },
    moveCanvas: function(opts) {
      var dx = 0,
          dy = 0,
          invertY = opts.invertY,
          speed = opts.speed;

      var actualSpeed = speed / Math.min(Math.sqrt(canvas.viewbox().scale), 1);

      switch (opts.direction) {
      case 'left':    // Left
        dx = actualSpeed;
        break;
      case 'up':    // Up
        dy = actualSpeed;
        break;
      case 'right':    // Right
        dx = -actualSpeed;
        break;
      case 'down':    // Down
        dy = -actualSpeed;
        break;
      }

      if (dy && invertY) {
        dy = -dy;
      }

      canvas.scroll({ dx: dx, dy: dy });
    }
  };
}

EditorActions.$inject = [
  'eventBus',
  'commandStack',
  'modeling',
  'selection',
  'zoomScroll',
  'copyPaste',
  'canvas',
  'rules',
  'mouseTracking'
];

module.exports = EditorActions;


/**
 * Triggers a registered action
 *
 * @param  {String} action
 * @param  {Object} opts
 *
 * @return {Unknown} Returns what the registered listener returns
 */
EditorActions.prototype.trigger = function(action, opts) {
  if (!this._actions[action]) {
    throw error(action, NOT_REGISTERED_ERROR);
  }

  return this._actions[action](opts);
};


/**
 * Registers a collections of actions.
 * The key of the object will be the name of the action.
 *
 * @example
 * ´´´
 * var actions = {
 *   spaceTool: function() {
 *     spaceTool.activateSelection();
 *   },
 *   lassoTool: function() {
 *     lassoTool.activateSelection();
 *   }
 * ];
 *
 * editorActions.register(actions);
 *
 * editorActions.isRegistered('spaceTool'); // true
 * ´´´
 *
 * @param  {Object} actions
 */
EditorActions.prototype.register = function(actions, listener) {
  if (typeof actions === 'string') {
    return this._registerAction(actions, listener);
  }

  forEach(actions, function(listener, action) {
    this._registerAction(action, listener);
  }, this);
};

/**
 * Registers a listener to an action key
 *
 * @param  {String} action
 * @param  {Function} listener
 */
EditorActions.prototype._registerAction = function(action, listener) {
  if (this.isRegistered(action)) {
    throw error(action, IS_REGISTERED_ERROR);
  }

  this._actions[action] = listener;
};

/**
 * Unregister an existing action
 *
 * @param {String} action
 */
EditorActions.prototype.unregister = function(action) {
  if (!this.isRegistered(action)) {
    throw error(action, NOT_REGISTERED_ERROR);
  }

  this._actions[action] = undefined;
};

/**
 * Returns the number of actions that are currently registered
 *
 * @return {Number}
 */
EditorActions.prototype.length = function() {
  return Object.keys(this._actions).length;
};

/**
 * Checks wether the given action is registered
 *
 * @param {String} action
 *
 * @return {Boolean}
 */
EditorActions.prototype.isRegistered = function(action) {
  return !!this._actions[action];
};


function error(action, message) {
  return new Error(action + ' ' + message);
}

},{"271":271,"389":389}],144:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(210),
    _dereq_(137),
    _dereq_(229)
  ],
  __init__: [ 'editorActions' ],
  editorActions: [ 'type', _dereq_(143) ]
};

},{"137":137,"143":143,"210":210,"229":229}],145:[function(_dereq_,module,exports){
'use strict';

var MARKER_OK = 'connect-ok',
    MARKER_NOT_OK = 'connect-not-ok';


function GlobalConnect(eventBus, dragging, connect, canvas, toolManager) {
  var self = this;

  this._dragging = dragging;

  toolManager.registerTool('global-connect', {
    tool: 'global-connect',
    dragging: 'global-connect.drag'
  });

  eventBus.on('global-connect.hover', function(event) {
    var context = event.context,
        startTarget = event.hover;

    var canStartConnect = context.canStartConnect = self.canStartConnect(startTarget);

    // simply ignore hover
    if (canStartConnect === null) {
      return;
    }

    context.startTarget = startTarget;

    canvas.addMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);
  });


  eventBus.on([ 'global-connect.out', 'global-connect.cleanup' ], function(event) {
    var startTarget = event.context.startTarget,
        canStartConnect = event.context.canStartConnect;

    if (startTarget) {
      canvas.removeMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);
    }
  });


  eventBus.on([ 'global-connect.ended' ], function(event) {
    var context = event.context,
        startTarget = context.startTarget,
        startPosition = {
          x: event.x,
          y: event.y
        };

    var canStartConnect = self.canStartConnect(startTarget);

    if (!canStartConnect) {
      return;
    }

    eventBus.once('element.out', function() {
      eventBus.once([ 'connect.ended', 'connect.canceled' ], function() {
        eventBus.fire('global-connect.drag.ended');
      });

      connect.start(null, startTarget, startPosition);
    });

    return false;
  });
}

GlobalConnect.$inject = [ 'eventBus', 'dragging', 'connect', 'canvas', 'toolManager' ];

module.exports = GlobalConnect;


/**
 * Initiates tool activity.
 */
GlobalConnect.prototype.start = function(event) {
  this._dragging.init(event, 'global-connect', {
    trapClick: false,
    data: {
      context: {}
    }
  });
};


GlobalConnect.prototype.toggle = function() {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.start();
  }
};

GlobalConnect.prototype.isActive = function() {
  var context = this._dragging.context();

  return context && /^global-connect/.test(context.prefix);
};


GlobalConnect.prototype.registerProvider = function(provider) {
  this._provider = provider;
};


/**
 * Check if source shape can initiate connection.
 *
 * @param  {Shape} startTarget
 * @return {Boolean}
 */
GlobalConnect.prototype.canStartConnect = function(startTarget) {
  return this._provider.canStartConnect(startTarget);
};

},{}],146:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(133),
    _dereq_(204),
    _dereq_(142),
    _dereq_(219)
  ],
  globalConnect: [ 'type', _dereq_(145) ]
};

},{"133":133,"142":142,"145":145,"204":204,"219":219}],147:[function(_dereq_,module,exports){
'use strict';

var hasPrimaryModifier = _dereq_(242).hasPrimaryModifier;


var HIGH_PRIORITY = 1500;
var HAND_CURSOR = 'grab';

function HandTool(eventBus, canvas, dragging, toolManager) {
  this._dragging = dragging;


  toolManager.registerTool('hand', {
    tool: 'hand',
    dragging: 'hand.move'
  });

  eventBus.on('element.mousedown', HIGH_PRIORITY, function(event) {
    if (hasPrimaryModifier(event)) {
      this.activateMove(event.originalEvent);

      return false;
    }
  }, this);


  eventBus.on('hand.end', function(event) {
    var target = event.originalEvent.target;

    // only reactive on diagram click
    // on some occasions, event.hover is not set and we have to check if the target is an svg
    if (!event.hover && !(target instanceof SVGElement)) {
      return false;
    }

    eventBus.once('hand.ended', function() {
      this.activateMove(event.originalEvent, { reactivate: true });
    }, this);

  }, this);


  eventBus.on('hand.move.move', function(event) {
    var scale = canvas.viewbox().scale;

    canvas.scroll({
      dx: event.dx * scale,
      dy: event.dy * scale
    });
  });

  eventBus.on('hand.move.end', function(event) {
    var context = event.context,
        reactivate = context.reactivate;

    // Don't reactivate if the user is using the keyboard keybinding
    if (!hasPrimaryModifier(event) && reactivate) {

      eventBus.once('hand.move.ended', function(event) {
        this.activateHand(event.originalEvent, true, true);
      }, this);

    }

    return false;
  }, this);

}

HandTool.$inject = [
  'eventBus',
  'canvas',
  'dragging',
  'toolManager'
];

module.exports = HandTool;


HandTool.prototype.activateMove = function(event, autoActivate, context) {
  if (typeof autoActivate === 'object') {
    context = autoActivate;
    autoActivate = false;
  }

  this._dragging.init(event, 'hand.move', {
    autoActivate: autoActivate,
    cursor: HAND_CURSOR,
    data: {
      context: context || {}
    }
  });
};

HandTool.prototype.activateHand = function(event, autoActivate, reactivate) {
  this._dragging.init(event, 'hand', {
    trapClick: false,
    autoActivate: autoActivate,
    cursor: HAND_CURSOR,
    data: {
      context: {
        reactivate: reactivate
      }
    }
  });
};

HandTool.prototype.toggle = function() {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.activateHand();
  }
};

HandTool.prototype.isActive = function() {
  var context = this._dragging.context();

  return context && /^hand/.test(context.prefix);
};

},{"242":242}],148:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [ _dereq_(219) ],
  __init__: [ 'handTool' ],
  handTool: [ 'type', _dereq_(147) ]
};

},{"147":147,"219":219}],149:[function(_dereq_,module,exports){
arguments[4][93][0].apply(exports,arguments)
},{"242":242,"246":246,"248":248,"271":271,"414":414,"93":93}],150:[function(_dereq_,module,exports){
arguments[4][94][0].apply(exports,arguments)
},{"149":149,"94":94}],151:[function(_dereq_,module,exports){
'use strict';

var domEvent = _dereq_(416),
    domMatches = _dereq_(417);

/**
 * A keyboard abstraction that may be activated and
 * deactivated by users at will, consuming key events
 * and triggering diagram actions.
 *
 * The implementation fires the following key events that allow
 * other components to hook into key handling:
 *
 *  - keyboard.bind
 *  - keyboard.unbind
 *  - keyboard.init
 *  - keyboard.destroy
 *
 * All events contain the fields (node, listeners).
 *
 * A default binding for the keyboard may be specified via the
 * `keyboard.bindTo` configuration option.
 *
 * @param {Config} config
 * @param {EventBus} eventBus
 * @param {EditorActions} editorActions
 */
function Keyboard(config, eventBus, editorActions) {
  var self = this;

  this._config = config || {};
  this._eventBus = eventBus;
  this._editorActions = editorActions;

  this._listeners = [];

  // our key handler is a singleton that passes
  // (keycode, modifiers) to each listener.
  //
  // listeners must indicate that they handled a key event
  // by returning true. This stops the event propagation.
  //
  this._keyHandler = function(event) {

    var i, l,
        target = event.target,
        listeners = self._listeners,
        code = event.keyCode || event.charCode || -1;

    if (domMatches(target, 'input, textarea')) {
      return;
    }

    for (i = 0; (l = listeners[i]); i++) {
      if (l(code, event)) {
        event.preventDefault();
        event.stopPropagation();
      }
    }
  };

  // properly clean dom registrations
  eventBus.on('diagram.destroy', function() {
    self._fire('destroy');

    self.unbind();
    self._listeners = null;
  });

  eventBus.on('diagram.init', function() {
    self._fire('init');

    if (config && config.bindTo) {
      self.bind(config.bindTo);
    }
  });

  this._init();
}

Keyboard.$inject = [
  'config.keyboard',
  'eventBus',
  'editorActions'
];

module.exports = Keyboard;


Keyboard.prototype.bind = function(node) {
  // make sure that the keyboard is only bound once to the DOM
  this.unbind();

  this._node = node;

  // bind key events
  domEvent.bind(node, 'keydown', this._keyHandler, true);

  this._fire('bind');
};

Keyboard.prototype.getBinding = function() {
  return this._node;
};

Keyboard.prototype.unbind = function() {
  var node = this._node;

  if (node) {
    this._fire('unbind');

    // unbind key events
    domEvent.unbind(node, 'keydown', this._keyHandler, true);
  }

  this._node = null;
};

Keyboard.prototype._fire = function(event) {
  this._eventBus.fire('keyboard.' + event, { node: this._node, listeners: this._listeners });
};

Keyboard.prototype._init = function() {

  var listeners = this._listeners;

  var editorActions = this._editorActions,
      config = this._config;

  // init default listeners

  // undo
  // (CTRL|CMD) + Z
  function undo(key, modifiers) {

    if (isCmd(modifiers) && !isShift(modifiers) && key === 90) {
      editorActions.trigger('undo');

      return true;
    }
  }

  // redo
  // CTRL + Y
  // CMD + SHIFT + Z
  function redo(key, modifiers) {

    if (isCmd(modifiers) && (key === 89 || (key === 90 && isShift(modifiers)))) {
      editorActions.trigger('redo');

      return true;
    }
  }

  // copy
  // CTRL/CMD + C
  function copy(key, modifiers) {

    if (isCmd(modifiers) && (key === 67)) {
      editorActions.trigger('copy');

      return true;
    }
  }

  // paste
  // CTRL/CMD + V
  function paste(key, modifiers) {

    if (isCmd(modifiers) && (key === 86)) {
      editorActions.trigger('paste');

      return true;
    }
  }

  /**
   * zoom in one step
   * CTRL + +
   *
   * 107 = numpad plus
   * 187 = regular plus
   * 171 = regular plus in Firefox (german keyboard layout)
   *  61 = regular plus in Firefox (US keyboard layout)
   */
  function zoomIn(key, modifiers) {

    if ((key === 107 || key === 187 || key === 171 || key === 61) && isCmd(modifiers)) {
      editorActions.trigger('stepZoom', { value: 1 });

      return true;
    }
  }

  /**
   * zoom out one step
   * CTRL + -
   *
   * 109 = numpad minus
   * 189 = regular minus
   * 173 = regular minus in Firefox (US and german keyboard layout)
   */
  function zoomOut(key, modifiers) {

    if ((key === 109 || key === 189 || key === 173)  && isCmd(modifiers)) {
      editorActions.trigger('stepZoom', { value: -1 });

      return true;
    }
  }

  /**
   * zoom to the default level
   * CTRL + 0
   *
   * 96 = numpad zero
   * 48 = regular zero
   */
  function zoomDefault(key, modifiers) {

    if ((key === 96 || key === 48) && isCmd(modifiers)) {
      editorActions.trigger('zoom', { value: 1 });

      return true;
    }
  }

  // delete selected element
  // DEL
  function removeSelection(key, modifiers) {

    if (key === 46) {
      editorActions.trigger('removeSelection');

      return true;
    }
  }

  // move canvas left
  // left arrow
  //
  // 37 = Left
  // 38 = Up
  // 39 = Right
  // 40 = Down
  function moveCanvas(key, modifiers) {

    if ([37, 38, 39, 40].indexOf(key) >= 0) {

      var opts = {
        invertY: config.invertY,
        speed: (config.speed || 50)
      };

      switch (key) {
      case 37:    // Left
        opts.direction = 'left';
        break;
      case 38:    // Up
        opts.direction = 'up';
        break;
      case 39:    // Right
        opts.direction = 'right';
        break;
      case 40:    // Down
        opts.direction = 'down';
        break;
      }

      editorActions.trigger('moveCanvas', opts);

      return true;
    }
  }

  listeners.push(undo);
  listeners.push(redo);
  listeners.push(copy);
  listeners.push(paste);
  listeners.push(removeSelection);
  listeners.push(zoomIn);
  listeners.push(zoomOut);
  listeners.push(zoomDefault);
  listeners.push(moveCanvas);
};


/**
 * Add a listener function that is notified with (key, modifiers) whenever
 * the keyboard is bound and the user presses a key.
 *
 * @param {Function} listenerFn
 */
Keyboard.prototype.addListener = function(listenerFn) {
  this._listeners.push(listenerFn);
};

Keyboard.prototype.hasModifier = hasModifier;
Keyboard.prototype.isCmd = isCmd;
Keyboard.prototype.isShift = isShift;


function hasModifier(modifiers) {
  return (modifiers.ctrlKey || modifiers.metaKey || modifiers.shiftKey || modifiers.altKey);
}

function isCmd(modifiers) {
  return modifiers.ctrlKey || modifiers.metaKey;
}

function isShift(modifiers) {
  return modifiers.shiftKey;
}

},{"416":416,"417":417}],152:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'keyboard' ],
  keyboard: [ 'type', _dereq_(151) ]
};

},{"151":151}],153:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    filter = _dereq_(269),
    inherits = _dereq_(257);

var LOW_PRIORITY = 250,
    HIGH_PRIORITY = 1400;

var CommandInterceptor = _dereq_(102);


/**
 * A handler that makes sure labels are properly moved with
 * their label targets.
 */
function LabelSupport(eventBus, modeling, moveVisuals) {

  CommandInterceptor.call(this, eventBus);

  // remove labels from the collection that are being
  // moved with other elements anyway
  eventBus.on('shape.move.start', HIGH_PRIORITY, function(e) {

    var context = e.context,
        shapes = context.shapes,
        validatedShapes = context.validatedShapes;

    context.shapes = removeLabels(shapes);
    context.validatedShapes = removeLabels(validatedShapes);
  });


  // add labels to visual's group
  eventBus.on('shape.move.start', LOW_PRIORITY, function(e) {

    var context = e.context,
        shapes = context.shapes;

    var labels = [];

    forEach(shapes, function(element) {
      var label = element.label;

      if (label && !label.hidden && context.shapes.indexOf(label) === -1) {
        labels.push(label);
      }

      if (element.labelTarget) {
        labels.push(element);
      }
    });

    forEach(labels, function(label) {
      moveVisuals.makeDraggable(context, label, true);
    });

  });

  // move labels after the other shapes are done moving
  this.postExecuted([ 'elements.move' ], function(e) {
    var context = e.context,
        closure = context.closure,
        enclosedElements = closure.enclosedElements;

    // ensure we move all labels with their respective elements
    // if they have not been moved already

    forEach(enclosedElements, function(e) {
      if (e.label && !enclosedElements[e.label.id]) {
        modeling.moveShape(e.label, context.delta, e.parent);
      }
    });

  });

}

inherits(LabelSupport, CommandInterceptor);

LabelSupport.$inject = [ 'eventBus', 'modeling', 'moveVisuals' ];

module.exports = LabelSupport;


/**
 * Return a filtered list of elements that do not
 * contain attached elements with hosts being part
 * of the selection.
 *
 * @param  {Array<djs.model.Base>} elements
 *
 * @return {Array<djs.model.Base>} filtered
 */
function removeLabels(elements) {

  return filter(elements, function(element) {

    // filter out labels that are move together
    // with their label targets
    return elements.indexOf(element.labelTarget) === -1;
  });
}

},{"102":102,"257":257,"269":269,"271":271}],154:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(185)
  ],
  __init__: [ 'labelSupport'],
  labelSupport: [ 'type', _dereq_(153) ]
};

},{"153":153,"185":185}],155:[function(_dereq_,module,exports){
'use strict';

var values = _dereq_(406);

var getEnclosedElements = _dereq_(235).getEnclosedElements;

var hasSecondaryModifier = _dereq_(242).hasSecondaryModifier;

var Snap = _dereq_(248);

var LASSO_TOOL_CURSOR = 'crosshair';


function LassoTool(eventBus, canvas, dragging, elementRegistry, selection, toolManager) {

  this._selection = selection;
  this._dragging = dragging;

  var self = this;

  // lasso visuals implementation

  /**
  * A helper that realizes the selection box visual
  */
  var visuals = {

    create: function(context) {
      var container = canvas.getDefaultLayer(),
          frame;

      frame = context.frame = Snap.create('rect', {
        class: 'djs-lasso-overlay',
        width:  1,
        height: 1,
        x: 0,
        y: 0
      });

      frame.appendTo(container);
    },

    update: function(context) {
      var frame = context.frame,
          bbox  = context.bbox;

      frame.attr({
        x: bbox.x,
        y: bbox.y,
        width: bbox.width,
        height: bbox.height
      });
    },

    remove: function(context) {

      if (context.frame) {
        context.frame.remove();
      }
    }
  };

  toolManager.registerTool('lasso', {
    tool: 'lasso.selection',
    dragging: 'lasso'
  });

  eventBus.on('lasso.selection.end', function(event) {
    var target = event.originalEvent.target;

    // only reactive on diagram click
    // on some occasions, event.hover is not set and we have to check if the target is an svg
    if (!event.hover && !(target instanceof SVGElement)) {
      return;
    }

    eventBus.once('lasso.selection.ended', function() {
      self.activateLasso(event.originalEvent, true);
    });
  });

  // lasso interaction implementation

  eventBus.on('lasso.end', function(event) {

    var bbox = toBBox(event);

    var elements = elementRegistry.filter(function(element) {
      return element;
    });

    self.select(elements, bbox);
  });

  eventBus.on('lasso.start', function(event) {

    var context = event.context;

    context.bbox = toBBox(event);
    visuals.create(context);
  });

  eventBus.on('lasso.move', function(event) {

    var context = event.context;

    context.bbox = toBBox(event);
    visuals.update(context);
  });

  eventBus.on('lasso.end', function(event) {

    var context = event.context;

    visuals.remove(context);
  });

  eventBus.on('lasso.cleanup', function(event) {

    var context = event.context;

    visuals.remove(context);
  });


  // event integration

  eventBus.on('element.mousedown', 1500, function(event) {

    if (hasSecondaryModifier(event)) {
      self.activateLasso(event.originalEvent);

      event.stopPropagation();
    }
  });
}

LassoTool.$inject = [
  'eventBus',
  'canvas',
  'dragging',
  'elementRegistry',
  'selection',
  'toolManager'
];

module.exports = LassoTool;


LassoTool.prototype.activateLasso = function(event, autoActivate) {

  this._dragging.init(event, 'lasso', {
    autoActivate: autoActivate,
    cursor: LASSO_TOOL_CURSOR,
    data: {
      context: {}
    }
  });
};

LassoTool.prototype.activateSelection = function(event) {

  this._dragging.init(event, 'lasso.selection', {
    trapClick: false,
    cursor: LASSO_TOOL_CURSOR,
    data: {
      context: {}
    }
  });
};

LassoTool.prototype.select = function(elements, bbox) {
  var selectedElements = getEnclosedElements(elements, bbox);

  this._selection.select(values(selectedElements));
};

LassoTool.prototype.toggle = function() {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.activateSelection();
  }
};

LassoTool.prototype.isActive = function() {
  var context = this._dragging.context();

  return context && /^lasso/.test(context.prefix);
};



function toBBox(event) {

  var start = {

    x: event.x - event.dx,
    y: event.y - event.dy
  };

  var end = {
    x: event.x,
    y: event.y
  };

  var bbox;

  if ((start.x <= end.x && start.y < end.y) ||
      (start.x < end.x && start.y <= end.y)) {

    bbox = {
      x: start.x,
      y: start.y,
      width:  end.x - start.x,
      height: end.y - start.y
    };
  } else if ((start.x >= end.x && start.y < end.y) ||
             (start.x > end.x && start.y <= end.y)) {

    bbox = {
      x: end.x,
      y: start.y,
      width:  start.x - end.x,
      height: end.y - start.y
    };
  } else if ((start.x <= end.x && start.y > end.y) ||
             (start.x < end.x && start.y >= end.y)) {

    bbox = {
      x: start.x,
      y: end.y,
      width:  end.x - start.x,
      height: start.y - end.y
    };
  } else if ((start.x >= end.x && start.y > end.y) ||
             (start.x > end.x && start.y >= end.y)) {

    bbox = {
      x: end.x,
      y: end.y,
      width:  start.x - end.x,
      height: start.y - end.y
    };
  } else {

    bbox = {
      x: end.x,
      y: end.y,
      width:  0,
      height: 0
    };
  }
  return bbox;
}

},{"235":235,"242":242,"248":248,"406":406}],156:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [ _dereq_(219) ],
  __init__: [ 'lassoTool' ],
  lassoTool: [ 'type', _dereq_(155) ]
};

},{"155":155,"219":219}],157:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var model = _dereq_(224);


/**
 * The basic modeling entry point.
 *
 * @param {EventBus} eventBus
 * @param {ElementFactory} elementFactory
 * @param {CommandStack} commandStack
 */
function Modeling(eventBus, elementFactory, commandStack) {
  this._eventBus = eventBus;
  this._elementFactory = elementFactory;
  this._commandStack = commandStack;

  var self = this;

  eventBus.on('diagram.init', function() {
    // register modeling handlers
    self.registerHandlers(commandStack);
  });
}

Modeling.$inject = [ 'eventBus', 'elementFactory', 'commandStack' ];

module.exports = Modeling;


Modeling.prototype.getHandlers = function() {
  return {
    'shape.append': _dereq_(159),
    'shape.create': _dereq_(162),
    'shape.delete': _dereq_(165),
    'shape.move': _dereq_(170),
    'shape.resize': _dereq_(175),
    'shape.replace': _dereq_(174),

    'spaceTool': _dereq_(176),

    'label.create': _dereq_(161),

    'connection.create': _dereq_(160),
    'connection.delete': _dereq_(163),
    'connection.move': _dereq_(168),
    'connection.layout': _dereq_(167),

    'connection.updateWaypoints': _dereq_(178),

    'connection.reconnectStart': _dereq_(173),
    'connection.reconnectEnd': _dereq_(173),

    'elements.move': _dereq_(169),
    'elements.delete': _dereq_(164),

    'elements.distribute': _dereq_(166),
    'elements.align': _dereq_(158),

    'element.updateAttachment': _dereq_(177),

    'elements.paste': _dereq_(172)
  };
};

/**
 * Register handlers with the command stack
 *
 * @param {CommandStack} commandStack
 */
Modeling.prototype.registerHandlers = function(commandStack) {
  forEach(this.getHandlers(), function(handler, id) {
    commandStack.registerHandler(id, handler);
  });
};


///// modeling helpers /////////////////////////////////////////

Modeling.prototype.moveShape = function(shape, delta, newParent, newParentIndex, hints) {

  if (typeof newParentIndex === 'object') {
    hints = newParentIndex;
    newParentIndex = null;
  }

  var context = {
    shape: shape,
    delta:  delta,
    newParent: newParent,
    newParentIndex: newParentIndex,
    hints: hints || {}
  };

  this._commandStack.execute('shape.move', context);
};


/**
 * Update the attachment of the given shape.
 *
 * @param  {djs.mode.Base} shape
 * @param  {djs.model.Base} [newHost]
 */
Modeling.prototype.updateAttachment = function(shape, newHost) {
  var context = {
    shape: shape,
    newHost: newHost
  };

  this._commandStack.execute('element.updateAttachment', context);
};

/**
 * Move a number of shapes to a new target, either setting it as
 * the new parent or attaching it.
 *
 * @param {Array<djs.mode.Base>} shapes
 * @param {Point} delta
 * @param {djs.model.Base} [target]
 * @param {Boolean} [isAttach=false]
 * @param {Object} [hints]
 */
Modeling.prototype.moveElements = function(shapes, delta, target, isAttach, hints) {
  if (typeof isAttach === 'object') {
    hints = isAttach;
    isAttach = undefined;
  }

  var newParent = target,
      newHost;

  if (isAttach === true) {
    newHost = target;
    newParent = target.parent;
  }

  if (isAttach === false) {
    newHost = null;
  }

  var context = {
    shapes: shapes,
    delta: delta,
    newParent: newParent,
    newHost: newHost,
    hints: hints || {}
  };

  this._commandStack.execute('elements.move', context);
};

Modeling.prototype.moveConnection = function(connection, delta, newParent, newParentIndex, hints) {

  if (typeof newParentIndex === 'object') {
    hints = newParentIndex;
    newParentIndex = undefined;
  }

  var context = {
    connection: connection,
    delta: delta,
    newParent: newParent,
    newParentIndex: newParentIndex,
    hints: hints || {}
  };

  this._commandStack.execute('connection.move', context);
};


Modeling.prototype.layoutConnection = function(connection, hints) {
  var context = {
    connection: connection,
    hints: hints || {}
  };

  this._commandStack.execute('connection.layout', context);
};

/**
 * Create connection.
 *
 * @param {djs.model.Base} source
 * @param {djs.model.Base} target
 * @param {Number} [targetIndex]
 * @param {Object|djs.model.Connection} connection
 * @param {djs.model.Base} parent
 * @param {Object} hints
 *
 * @return {djs.model.Connection} the created connection.
 */
Modeling.prototype.createConnection = function(source, target, targetIndex, connection, parent, hints) {

  if (typeof targetIndex === 'object') {
    hints = parent;
    parent = connection;
    connection = targetIndex;
    targetIndex = undefined;
  }

  connection = this._create('connection', connection);

  var context = {
    source: source,
    target: target,
    parent: parent,
    parentIndex: targetIndex,
    connection: connection,
    hints: hints
  };

  this._commandStack.execute('connection.create', context);

  return context.connection;
};

Modeling.prototype.createShape = function(shape, position, target, targetIndex, isAttach, hints) {

  if (typeof targetIndex !== 'number') {
    hints = isAttach;
    isAttach = targetIndex;
  }

  if (typeof isAttach !== 'boolean') {
    hints = isAttach;
    isAttach = false;
  }

  shape = this._create('shape', shape);

  var context = {
    position: position,
    shape: shape,
    parent: target,
    parentIndex: targetIndex,
    host: shape.host,
    hints: hints || {}
  };

  if (isAttach) {
    context.parent = target.parent;
    context.host = target;
  }

  this._commandStack.execute('shape.create', context);

  return context.shape;
};


Modeling.prototype.createLabel = function(labelTarget, position, label, parent) {

  label = this._create('label', label);

  var context = {
    labelTarget: labelTarget,
    position: position,
    parent: parent || labelTarget.parent,
    shape: label
  };

  this._commandStack.execute('label.create', context);

  return context.shape;
};


Modeling.prototype.appendShape = function(source, shape, position, parent, connection, connectionParent) {

  shape = this._create('shape', shape);

  var context = {
    source: source,
    position: position,
    parent: parent,
    shape: shape,
    connection: connection,
    connectionParent: connectionParent
  };

  this._commandStack.execute('shape.append', context);

  return context.shape;
};


Modeling.prototype.removeElements = function(elements) {
  var context = {
    elements: elements
  };

  this._commandStack.execute('elements.delete', context);
};


Modeling.prototype.distributeElements = function(groups, axis, dimension) {
  var context = {
    groups: groups,
    axis: axis,
    dimension: dimension
  };

  this._commandStack.execute('elements.distribute', context);
};


Modeling.prototype.removeShape = function(shape, hints) {
  var context = {
    shape: shape,
    hints: hints || {}
  };

  this._commandStack.execute('shape.delete', context);
};


Modeling.prototype.removeConnection = function(connection, hints) {
  var context = {
    connection: connection,
    hints: hints || {}
  };

  this._commandStack.execute('connection.delete', context);
};

Modeling.prototype.replaceShape = function(oldShape, newShape, hints) {
  var context = {
    oldShape: oldShape,
    newData: newShape,
    hints: hints || {}
  };

  this._commandStack.execute('shape.replace', context);

  return context.newShape;
};

Modeling.prototype.pasteElements = function(tree, topParent, position) {
  var context = {
    tree: tree,
    topParent: topParent,
    position: position
  };

  this._commandStack.execute('elements.paste', context);
};

Modeling.prototype.alignElements = function(elements, alignment) {
  var context = {
    elements: elements,
    alignment: alignment
  };

  this._commandStack.execute('elements.align', context);
};

Modeling.prototype.resizeShape = function(shape, newBounds) {
  var context = {
    shape: shape,
    newBounds: newBounds
  };

  this._commandStack.execute('shape.resize', context);
};

Modeling.prototype.createSpace = function(movingShapes, resizingShapes, delta, direction) {
  var context = {
    movingShapes: movingShapes,
    resizingShapes: resizingShapes,
    delta: delta,
    direction: direction
  };

  this._commandStack.execute('spaceTool', context);
};

Modeling.prototype.updateWaypoints = function(connection, newWaypoints, hints) {
  var context = {
    connection: connection,
    newWaypoints: newWaypoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.updateWaypoints', context);
};

Modeling.prototype.reconnectStart = function(connection, newSource, dockingOrPoints) {
  var context = {
    connection: connection,
    newSource: newSource,
    dockingOrPoints: dockingOrPoints
  };

  this._commandStack.execute('connection.reconnectStart', context);
};

Modeling.prototype.reconnectEnd = function(connection, newTarget, dockingOrPoints) {
  var context = {
    connection: connection,
    newTarget: newTarget,
    dockingOrPoints: dockingOrPoints
  };

  this._commandStack.execute('connection.reconnectEnd', context);
};

Modeling.prototype.connect = function(source, target, attrs, hints) {
  return this.createConnection(source, target, attrs || {}, source.parent, hints);
};

Modeling.prototype._create = function(type, attrs) {
  if (attrs instanceof model.Base) {
    return attrs;
  } else {
    return this._elementFactory.create(type, attrs);
  }
};

},{"158":158,"159":159,"160":160,"161":161,"162":162,"163":163,"164":164,"165":165,"166":166,"167":167,"168":168,"169":169,"170":170,"172":172,"173":173,"174":174,"175":175,"176":176,"177":177,"178":178,"224":224,"271":271}],158:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

/**
 * A handler that align elements in a certain way.
 *
 */
function AlignElements(modeling, canvas) {
  this._modeling = modeling;
  this._canvas = canvas;
}

AlignElements.$inject = [ 'modeling', 'canvas' ];

module.exports = AlignElements;


AlignElements.prototype.preExecute = function(context) {
  var modeling = this._modeling;

  var elements = context.elements,
      alignment = context.alignment;


  forEach(elements, function(element) {
    var delta = {
      x: 0,
      y: 0
    };

    if (alignment.left) {
      delta.x = alignment.left - element.x;

    } else if (alignment.right) {
      delta.x = (alignment.right - element.width) - element.x;

    } else if (alignment.center) {
      delta.x = (alignment.center - Math.round(element.width / 2)) - element.x;

    } else if (alignment.top) {
      delta.y = alignment.top - element.y;

    } else if (alignment.bottom) {
      delta.y = (alignment.bottom - element.height) - element.y;

    } else if (alignment.middle) {
      delta.y = (alignment.middle - Math.round(element.height / 2)) - element.y;
    }

    modeling.moveElements([ element ], delta, element.parent);
  });
};

AlignElements.prototype.postExecute = function(context) {

};

},{"271":271}],159:[function(_dereq_,module,exports){
'use strict';

var any = _dereq_(267);

var inherits = _dereq_(257);


/**
 * A handler that implements reversible appending of shapes
 * to a source shape.
 *
 * @param {canvas} Canvas
 * @param {elementFactory} ElementFactory
 * @param {modeling} Modeling
 */
function AppendShapeHandler(modeling) {
  this._modeling = modeling;
}

inherits(AppendShapeHandler, _dereq_(171));


AppendShapeHandler.$inject = [ 'modeling' ];

module.exports = AppendShapeHandler;


////// api /////////////////////////////////////////////

/**
 * Creates a new shape
 *
 * @param {Object} context
 * @param {ElementDescriptor} context.shape the new shape
 * @param {ElementDescriptor} context.source the source object
 * @param {ElementDescriptor} context.parent the parent object
 * @param {Point} context.position position of the new element
 */
AppendShapeHandler.prototype.preExecute = function(context) {

  if (!context.source) {
    throw new Error('source required');
  }

  var parent = context.parent || context.source.parent,
      shape = this._modeling.createShape(context.shape, context.position, parent);

  context.shape = shape;
};

AppendShapeHandler.prototype.postExecute = function(context) {
  var parent = context.connectionParent || context.shape.parent;

  if (!existsConnection(context.source, context.shape)) {

    // create connection
    this._modeling.connect(context.source, context.shape, context.connection, parent);
  }
};


function existsConnection(source, target) {
  return any(source.outgoing, function(c) {
    return c.target === target;
  });
}
},{"171":171,"257":257,"267":267}],160:[function(_dereq_,module,exports){
'use strict';


function CreateConnectionHandler(canvas, layouter) {
  this._canvas = canvas;
  this._layouter = layouter;
}

CreateConnectionHandler.$inject = [ 'canvas', 'layouter' ];

module.exports = CreateConnectionHandler;



////// api /////////////////////////////////////////

/**
 * Appends a shape to a target shape
 *
 * @param {Object} context
 * @param {djs.element.Base} context.source the source object
 * @param {djs.element.Base} context.target the parent object
 * @param {Point} context.position position of the new element
 */
CreateConnectionHandler.prototype.execute = function(context) {

  var connection = context.connection,
      source = context.source,
      target = context.target,
      parent = context.parent,
      hints = context.hints;

  if (!source || !target) {
    throw new Error('source and target required');
  }

  if (!parent) {
    throw new Error('parent required');
  }

  connection.source = source;
  connection.target = target;

  if (!connection.waypoints) {
    connection.waypoints = this._layouter.layoutConnection(connection, hints);
  }

  // add connection
  this._canvas.addConnection(connection, parent);

  return connection;
};

CreateConnectionHandler.prototype.revert = function(context) {
  var connection = context.connection;

  this._canvas.removeConnection(connection);

  connection.source = null;
  connection.target = null;
};
},{}],161:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var CreateShapeHandler = _dereq_(162);


/**
 * A handler that attaches a label to a given target shape.
 *
 * @param {canvas} Canvas
 */
function CreateLabelHandler(canvas) {
  CreateShapeHandler.call(this, canvas);
}

inherits(CreateLabelHandler, CreateShapeHandler);

CreateLabelHandler.$inject = [ 'canvas' ];

module.exports = CreateLabelHandler;



////// api /////////////////////////////////////////


var originalExecute = CreateShapeHandler.prototype.execute;

/**
 * Appends a label to a target shape.
 *
 * @method CreateLabelHandler#execute
 *
 * @param {Object} context
 * @param {ElementDescriptor} context.target the element the label is attached to
 * @param {ElementDescriptor} context.parent the parent object
 * @param {Point} context.position position of the new element
 */
CreateLabelHandler.prototype.execute = function(context) {

  var label = context.shape;

  ensureValidDimensions(label);

  label.labelTarget = context.labelTarget;

  return originalExecute.call(this, context);
};

var originalRevert = CreateShapeHandler.prototype.revert;

/**
 * Undo append by removing the shape
 */
CreateLabelHandler.prototype.revert = function(context) {
  context.shape.labelTarget = null;

  return originalRevert.call(this, context);
};


////// helpers /////////////////////////////////////////

function ensureValidDimensions(label) {
  // make sure a label has valid { width, height } dimensions
  [ 'width', 'height' ].forEach(function(prop) {
    if (typeof label[prop] === 'undefined') {
      label[prop] = 0;
    }
  });
}
},{"162":162,"257":257}],162:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398);

var round = Math.round;


/**
 * A handler that implements reversible addition of shapes.
 *
 * @param {canvas} Canvas
 */
function CreateShapeHandler(canvas) {
  this._canvas = canvas;
}

CreateShapeHandler.$inject = [ 'canvas' ];

module.exports = CreateShapeHandler;



////// api /////////////////////////////////////////


/**
 * Appends a shape to a target shape
 *
 * @param {Object} context
 * @param {djs.model.Base} context.parent the parent object
 * @param {Point} context.position position of the new element
 */
CreateShapeHandler.prototype.execute = function(context) {

  var shape = context.shape,
      positionOrBounds = context.position,
      parent = context.parent,
      parentIndex = context.parentIndex;

  if (!parent) {
    throw new Error('parent required');
  }

  if (!positionOrBounds) {
    throw new Error('position required');
  }

  // (1) add at event center position _or_ at given bounds
  if (positionOrBounds.width !== undefined) {
    assign(shape, positionOrBounds);
  } else {
    assign(shape, {
      x: positionOrBounds.x - round(shape.width / 2),
      y: positionOrBounds.y - round(shape.height / 2)
    });
  }

  // (2) add to canvas
  this._canvas.addShape(shape, parent, parentIndex);

  return shape;
};


/**
 * Undo append by removing the shape
 */
CreateShapeHandler.prototype.revert = function(context) {

  // (3) remove form canvas
  this._canvas.removeShape(context.shape);
};
},{"398":398}],163:[function(_dereq_,module,exports){
'use strict';

var Collections = _dereq_(232);


/**
 * A handler that implements reversible deletion of Connections.
 *
 */
function DeleteConnectionHandler(canvas, modeling) {
  this._canvas = canvas;
  this._modeling = modeling;
}

DeleteConnectionHandler.$inject = [ 'canvas', 'modeling' ];

module.exports = DeleteConnectionHandler;


/**
 * - Remove attached label
 */
DeleteConnectionHandler.prototype.preExecute = function(context) {

  var connection = context.connection;

  // Remove label
  if (connection.label) {
    this._modeling.removeShape(connection.label);
  }
};

DeleteConnectionHandler.prototype.execute = function(context) {

  var connection = context.connection,
      parent = connection.parent;

  context.parent = parent;
  context.parentIndex = Collections.indexOf(parent.children, connection);

  context.source = connection.source;
  context.target = connection.target;

  this._canvas.removeConnection(connection);

  connection.source = null;
  connection.target = null;
  connection.label  = null;

  return connection;
};

/**
 * Command revert implementation.
 */
DeleteConnectionHandler.prototype.revert = function(context) {

  var connection = context.connection,
      parent = context.parent,
      parentIndex = context.parentIndex;

  connection.source = context.source;
  connection.target = context.target;

  // restore previous location in old parent
  Collections.add(parent.children, connection, parentIndex);

  this._canvas.addConnection(connection, parent);

  return connection;
};

},{"232":232}],164:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    inherits = _dereq_(257);


function DeleteElementsHandler(modeling, elementRegistry) {
  this._modeling = modeling;
  this._elementRegistry = elementRegistry;
}

inherits(DeleteElementsHandler, _dereq_(171));

DeleteElementsHandler.$inject = [ 'modeling', 'elementRegistry' ];

module.exports = DeleteElementsHandler;


DeleteElementsHandler.prototype.postExecute = function(context) {

  var modeling = this._modeling,
      elementRegistry = this._elementRegistry,
      elements = context.elements;

  forEach(elements, function(element) {

    // element may have been removed with previous
    // remove operations already (e.g. in case of nesting)
    if (!elementRegistry.get(element.id)) {
      return;
    }

    if (element.waypoints) {
      modeling.removeConnection(element);
    } else {
      modeling.removeShape(element);
    }
  });
};
},{"171":171,"257":257,"271":271}],165:[function(_dereq_,module,exports){
'use strict';

var Collections = _dereq_(232);

var saveClear = _dereq_(245).saveClear;


/**
 * A handler that implements reversible deletion of shapes.
 *
 */
function DeleteShapeHandler(canvas, modeling) {
  this._canvas = canvas;
  this._modeling = modeling;
}

DeleteShapeHandler.$inject = [ 'canvas', 'modeling' ];

module.exports = DeleteShapeHandler;


/**
 * - Remove connections
 * - Remove all direct children
 */
DeleteShapeHandler.prototype.preExecute = function(context) {

  var modeling = this._modeling;

  var shape = context.shape,
      label = shape.label;

  // Clean up on removeShape(label)
  if (shape.labelTarget) {
    context.labelTarget = shape.labelTarget;
    shape.labelTarget = null;
  }

  // Remove label
  if (label) {
    this._modeling.removeShape(label, { nested: true });
  }

  // remove connections
  saveClear(shape.incoming, function(connection) {
    // To make sure that the connection isn't removed twice
    // For example if a container is removed
    modeling.removeConnection(connection, { nested: true });
  });

  saveClear(shape.outgoing, function(connection) {
    modeling.removeConnection(connection, { nested: true });
  });


  // remove children
  saveClear(shape.children, function(e) {
    modeling.removeShape(e, { nested: true });
  });
};

/**
 * Remove shape and remember the parent
 */
DeleteShapeHandler.prototype.execute = function(context) {
  var canvas = this._canvas;

  var shape = context.shape,
      oldParent = shape.parent;

  context.oldParent = oldParent;
  context.oldParentIndex = Collections.indexOf(oldParent.children, shape);

  shape.label = null;

  canvas.removeShape(shape);

  return shape;
};


/**
 * Command revert implementation
 */
DeleteShapeHandler.prototype.revert = function(context) {

  var canvas = this._canvas;

  var shape = context.shape,
      oldParent = context.oldParent,
      oldParentIndex = context.oldParentIndex,
      labelTarget = context.labelTarget;

  // restore previous location in old oldParent
  Collections.add(oldParent.children, shape, oldParentIndex);

  if (labelTarget) {
    labelTarget.label = shape;
  }

  canvas.addShape(shape, oldParent);

  return shape;
};

},{"232":232,"245":245}],166:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    sortBy = _dereq_(277);

/**
 * A handler that distributes elements evenly.
 */
function DistributeElements(modeling) {
  this._modeling = modeling;
}

DistributeElements.$inject = [ 'modeling' ];

module.exports = DistributeElements;

var OFF_AXIS = {
  x: 'y',
  y: 'x'
};

DistributeElements.prototype.preExecute = function(context) {
  var modeling = this._modeling;

  var groups = context.groups,
      axis = context.axis,
      dimension = context.dimension;

  function updateRange(group, element) {
    group.range.min = Math.min(element[axis], group.range.min);
    group.range.max = Math.max(element[axis] + element[dimension], group.range.max);
  }

  function center(element) {
    return element[axis] + element[dimension] / 2;
  }

  function lastIdx(arr) {
    return arr.length - 1;
  }

  function rangeDiff(range) {
    return range.max - range.min;
  }

  function centerElement(refCenter, element) {
    var delta = { y: 0 };

    delta[axis] = refCenter - center(element);

    if (delta[axis]) {

      delta[OFF_AXIS[axis]] = 0;

      modeling.moveElements([ element ], delta, element.parent);
    }
  }

  var firstGroup = groups[0],
      lastGroupIdx = lastIdx(groups),
      lastGroup = groups[ lastGroupIdx ];

  var margin,
      spaceInBetween,
      groupsSize = 0; // the size of each range

  forEach(groups, function(group, idx) {
    var sortedElements,
        refElem,
        refCenter;

    if (group.elements.length < 2) {
      if (idx && idx !== groups.length - 1) {
        updateRange(group, group.elements[0]);

        groupsSize += rangeDiff(group.range);
      }
      return;
    }

    sortedElements = sortBy(group.elements, axis);

    refElem = sortedElements[0];

    if (idx === lastGroupIdx) {
      refElem = sortedElements[lastIdx(sortedElements)];
    }

    refCenter = center(refElem);

    // wanna update the ranges after the shapes have been centered
    group.range = null;

    forEach(sortedElements, function(element) {

      centerElement(refCenter, element);

      if (group.range === null) {
        group.range = {
          min: element[axis],
          max: element[axis] + element[dimension]
        };

        return;
      }

      // update group's range after centering the range elements
      updateRange(group, element);
    });

    if (idx && idx !== groups.length - 1) {
      groupsSize += rangeDiff(group.range);
    }
  });

  spaceInBetween = Math.abs(lastGroup.range.min - firstGroup.range.max);

  margin = Math.round((spaceInBetween - groupsSize) / (groups.length - 1));

  if (margin < groups.length - 1) {
    return;
  }

  forEach(groups, function(group, groupIdx) {
    var delta = {},
        prevGroup;

    if (group === firstGroup || group === lastGroup) {
      return;
    }

    prevGroup = groups[groupIdx - 1];

    group.range.max = 0;

    forEach(group.elements, function(element, idx) {
      delta[OFF_AXIS[axis]] = 0;
      delta[axis] = (prevGroup.range.max - element[axis]) + margin;

      if (group.range.min !== element[axis]) {
        delta[axis] += element[axis] - group.range.min;
      }

      if (delta[axis]) {
        modeling.moveElements([ element ], delta, element.parent);
      }

      group.range.max = Math.max(element[axis] + element[dimension], idx ? group.range.max : 0);
    });
  });
};

DistributeElements.prototype.postExecute = function(context) {

};

},{"271":271,"277":277}],167:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398);


/**
 * A handler that implements reversible moving of shapes.
 */
function LayoutConnectionHandler(layouter, canvas) {
  this._layouter = layouter;
  this._canvas = canvas;
}

LayoutConnectionHandler.$inject = [ 'layouter', 'canvas' ];

module.exports = LayoutConnectionHandler;

LayoutConnectionHandler.prototype.execute = function(context) {

  var connection = context.connection,
      parent = connection.parent,
      connectionSiblings = parent.children;

  var oldIndex = connectionSiblings.indexOf(connection);

  var oldWaypoints = connection.waypoints;

  assign(context, {
    oldWaypoints: oldWaypoints,
    oldIndex: oldIndex
  });

  sendToFront(connection);

  connection.waypoints = this._layouter.layoutConnection(connection, context.hints);

  return connection;
};

LayoutConnectionHandler.prototype.revert = function(context) {

  var connection = context.connection,
      parent = connection.parent,
      connectionSiblings = parent.children,
      currentIndex = connectionSiblings.indexOf(connection),
      oldIndex = context.oldIndex;

  connection.waypoints = context.oldWaypoints;

  if (oldIndex !== currentIndex) {

    // change position of connection in shape
    connectionSiblings.splice(currentIndex, 1);
    connectionSiblings.splice(oldIndex, 0, connection);
  }

  return connection;
};


////////////// helpers /////////////////////////////////////


// connections should have a higher z-order as there source and targets
function sendToFront(connection) {

  var connectionSiblings = connection.parent.children;

  var connectionIdx = connectionSiblings.indexOf(connection),
      sourceIdx = findIndex(connectionSiblings, connection.source),
      targetIdx = findIndex(connectionSiblings, connection.target),

      // ensure we do not send the connection back
      // if it is already in front
      insertIndex = Math.max(sourceIdx + 1, targetIdx + 1, connectionIdx);

  if (connectionIdx < insertIndex) {
    connectionSiblings.splice(insertIndex, 0, connection); // add to new position
    connectionSiblings.splice(connectionIdx, 1); // remove from old position
  }

  function findIndex(array, obj) {

    var index = array.indexOf(obj);
    if (index < 0 && obj) {
      var parent = obj.parent;
      index = findIndex(array, parent);
    }
    return index;
  }

  return insertIndex;
}

},{"398":398}],168:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var Collections = _dereq_(232);


/**
 * A handler that implements reversible moving of connections.
 *
 * The handler differs from the layout connection handler in a sense
 * that it preserves the connection layout.
 */
function MoveConnectionHandler() { }

module.exports = MoveConnectionHandler;


MoveConnectionHandler.prototype.execute = function(context) {

  var connection = context.connection,
      delta = context.delta;

  var newParent = context.newParent || connection.parent,
      newParentIndex = context.newParentIndex,
      oldParent = connection.parent;

  // save old parent in context
  context.oldParent = oldParent;
  context.oldParentIndex = Collections.remove(oldParent.children, connection);

  // add to new parent at position
  Collections.add(newParent.children, connection, newParentIndex);

  // update parent
  connection.parent = newParent;

  // update waypoint positions
  forEach(connection.waypoints, function(p) {
    p.x += delta.x;
    p.y += delta.y;

    if (p.original) {
      p.original.x += delta.x;
      p.original.y += delta.y;
    }
  });

  return connection;
};

MoveConnectionHandler.prototype.revert = function(context) {

  var connection = context.connection,
      newParent = connection.parent,
      oldParent = context.oldParent,
      oldParentIndex = context.oldParentIndex,
      delta = context.delta;

  // remove from newParent
  Collections.remove(newParent.children, connection);

  // restore previous location in old parent
  Collections.add(oldParent.children, connection, oldParentIndex);

  // restore parent
  connection.parent = oldParent;

  // revert to old waypoint positions
  forEach(connection.waypoints, function(p) {
    p.x -= delta.x;
    p.y -= delta.y;

    if (p.original) {
      p.original.x -= delta.x;
      p.original.y -= delta.y;
    }
  });

  return connection;
};
},{"232":232,"271":271}],169:[function(_dereq_,module,exports){
'use strict';

var MoveHelper = _dereq_(180);


/**
 * A handler that implements reversible moving of shapes.
 */
function MoveElementsHandler(modeling) {
  this._helper = new MoveHelper(modeling);
}

MoveElementsHandler.$inject = [ 'modeling' ];

module.exports = MoveElementsHandler;

MoveElementsHandler.prototype.preExecute = function(context) {
  context.closure = this._helper.getClosure(context.shapes);
};

MoveElementsHandler.prototype.postExecute = function(context) {

  var hints = context.hints,
      primaryShape;

  if (hints && hints.primaryShape) {
    primaryShape = hints.primaryShape;
    hints.oldParent = primaryShape.parent;
  }

  this._helper.moveClosure(context.closure, context.delta, context.newParent, context.newHost, primaryShape);
};


MoveElementsHandler.prototype.execute = function(context) { };
MoveElementsHandler.prototype.revert = function(context) { };

},{"180":180}],170:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    forEach = _dereq_(271),
    pick = _dereq_(404);

var MoveHelper = _dereq_(180),
    Collections = _dereq_(232);

var getMovedSourceAnchor = _dereq_(179).getMovedSourceAnchor,
    getMovedTargetAnchor = _dereq_(179).getMovedTargetAnchor;


/**
 * A handler that implements reversible moving of shapes.
 */
function MoveShapeHandler(modeling) {
  this._modeling = modeling;

  this._helper = new MoveHelper(modeling);
}

MoveShapeHandler.$inject = [ 'modeling' ];

module.exports = MoveShapeHandler;


MoveShapeHandler.prototype.execute = function(context) {

  var shape = context.shape,
      delta = context.delta,
      newParent = context.newParent || shape.parent,
      newParentIndex = context.newParentIndex,
      oldParent = shape.parent;

  context.oldBounds = pick(shape, [ 'x', 'y', 'width', 'height']);

  // save old parent in context
  context.oldParent = oldParent;
  context.oldParentIndex = Collections.remove(oldParent.children, shape);

  // add to new parent at position
  Collections.add(newParent.children, shape, newParentIndex);

  // update shape parent + position
  assign(shape, {
    parent: newParent,
    x: shape.x + delta.x,
    y: shape.y + delta.y
  });

  return shape;
};

MoveShapeHandler.prototype.postExecute = function(context) {

  var shape = context.shape,
      delta = context.delta,
      hints = context.hints;

  var modeling = this._modeling;

  if (hints.layout !== false) {

    forEach(shape.incoming, function(c) {
      modeling.layoutConnection(c, {
        connectionEnd: getMovedTargetAnchor(c, shape, delta)
      });
    });

    forEach(shape.outgoing, function(c) {
      modeling.layoutConnection(c, {
        connectionStart: getMovedSourceAnchor(c, shape, delta)
      });
    });
  }

  if (hints.recurse !== false) {
    this.moveChildren(context);
  }
};

MoveShapeHandler.prototype.revert = function(context) {

  var shape = context.shape,
      oldParent = context.oldParent,
      oldParentIndex = context.oldParentIndex,
      delta = context.delta;

  // restore previous location in old parent
  Collections.add(oldParent.children, shape, oldParentIndex);

  // revert to old position and parent
  assign(shape, {
    parent: oldParent,
    x: shape.x - delta.x,
    y: shape.y - delta.y
  });

  return shape;
};

MoveShapeHandler.prototype.moveChildren = function(context) {

  var delta = context.delta,
      shape = context.shape;

  this._helper.moveRecursive(shape.children, delta, null);
};

MoveShapeHandler.prototype.getNewParent = function(context) {
  return context.newParent || context.shape.parent;
};

},{"179":179,"180":180,"232":232,"271":271,"398":398,"404":404}],171:[function(_dereq_,module,exports){
'use strict';

function NoopHandler() {}

module.exports = NoopHandler;

NoopHandler.prototype.execute = function() {};
NoopHandler.prototype.revert = function() {};
},{}],172:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    map = _dereq_(273),
    sortBy = _dereq_(277),
    clone = _dereq_(387);

var inherits = _dereq_(257);



function removeProperties(element, properties) {
  forEach(properties, function(prop) {
    if (element[prop]) {
      delete element[prop];
    }
  });
}

/**
 * A handler that implements pasting of elements onto the diagram.
 *
 * @param {eventBus} EventBus
 * @param {canvas} Canvas
 * @param {selection} Selection
 * @param {elementFactory} ElementFactory
 * @param {modeling} Modeling
 * @param {rules} Rules
 */
function PasteHandler(eventBus, canvas, selection, elementFactory, modeling, rules) {
  this._eventBus = eventBus;
  this._canvas = canvas;
  this._selection = selection;
  this._elementFactory = elementFactory;
  this._modeling = modeling;
  this._rules = rules;
}

inherits(PasteHandler, _dereq_(171));


PasteHandler.$inject = [
  'eventBus',
  'canvas',
  'selection',
  'elementFactory',
  'modeling',
  'rules'
];

module.exports = PasteHandler;


////// api /////////////////////////////////////////////

/**
 * Creates a new shape
 *
 * @param {Object} context
 * @param {Object} context.tree the new shape
 * @param {Element} context.topParent the paste target
 */
PasteHandler.prototype.preExecute = function(context) {
  var eventBus = this._eventBus;

  var tree = context.tree,
      topParent = context.topParent,
      position = context.position;

  tree.createdElements = {};

  tree.labels = [];

  forEach(tree, function(elements, depthStr) {
    var depth = parseInt(depthStr, 10);

    if (isNaN(depth)) {
      return;
    }

    // set the parent on the top level elements
    if (!depth) {
      elements = map(elements, function(descriptor) {
        descriptor.parent = topParent;

        return descriptor;
      });
    }

    // Order by priority for element creation
    elements = sortBy(elements, 'priority');

    forEach(elements, function(descriptor) {
      var id = descriptor.id,
          parent = descriptor.parent,
          isAttach = false,
          hints,
          newPosition;

      var element = clone(descriptor);

      if (depth) {
        element.parent = this._getCreatedElement(parent, tree);
      }

      // this happens when shapes have not been created due to rules
      if (!parent) {
        return;
      }

      eventBus.fire('element.paste', {
        createdElements: tree.createdElements,
        descriptor: element
      });

      // in case the parent changed during 'element.paste'
      parent = element.parent;

      if (element.waypoints) {
        element = this._createConnection(element, parent, position, tree);

        if (element) {
          tree.createdElements[id] = {
            element: element,
            descriptor: descriptor
          };
        }

        return;
      }

      // supply not-root information as hint
      if (element.parent !== topParent) {
        hints = { root: false };
      }

      // set host
      if (element.host) {
        isAttach = true;

        parent = this._getCreatedElement(element.host, tree);
      }

      // handle labels
      if (element.labelTarget) {
        return tree.labels.push(element);
      }

      newPosition = {
        x: Math.round(position.x + element.delta.x + (element.width / 2)),
        y: Math.round(position.y + element.delta.y + (element.height / 2))
      };

      removeProperties(element, [ 'id', 'parent', 'delta', 'host', 'priority' ]);

      element = this._createShape(element, parent, newPosition, isAttach, hints);

      if (element) {
        tree.createdElements[id] = {
          element: element,
          descriptor: descriptor
        };
      }
    }, this);
  }, this);
};

// move label's to their relative position
PasteHandler.prototype.postExecute = function(context) {
  var modeling = this._modeling,
      selection = this._selection;

  var tree = context.tree,
      labels = tree.labels,
      topLevelElements = [];

  forEach(labels, function(labelDescriptor) {
    var labelTarget = this._getCreatedElement(labelDescriptor.labelTarget, tree),
        label, labelTargetPos, newPosition;

    if (!labelTarget) {
      return;
    }

    label = labelTarget.label;

    if (!label) {
      return;
    }

    labelTargetPos = {
      x: labelTarget.x,
      y: labelTarget.y
    };

    if (labelTarget.waypoints) {
      labelTargetPos = labelTarget.waypoints[0];
    }

    newPosition = {
      x: Math.round((labelTargetPos.x - label.x) + labelDescriptor.delta.x),
      y: Math.round((labelTargetPos.y - label.y) + labelDescriptor.delta.y)
    };

    modeling.moveShape(label, newPosition, labelTarget.parent);
  }, this);

  forEach(tree[0], function(descriptor) {
    var id = descriptor.id,
        toplevel = tree.createdElements[id];

    if (toplevel) {
      topLevelElements.push(toplevel.element);
    }
  });

  selection.select(topLevelElements);
};


PasteHandler.prototype._createConnection = function(element, parent, parentCenter, tree) {
  var modeling = this._modeling,
      rules = this._rules;

  var connection, source, target, canPaste;

  element.waypoints = map(element.waypoints, function(waypoint, idx) {
    return {
      x: Math.round(parentCenter.x + element.delta[idx].x),
      y: Math.round(parentCenter.y + element.delta[idx].y)
    };
  });

  source = this._getCreatedElement(element.source, tree);
  target = this._getCreatedElement(element.target, tree);

  if (!source || !target) {
    return null;
  }

  canPaste = rules.allowed('element.paste', {
    source: source,
    target: target
  });

  if (!canPaste) {
    return null;
  }

  removeProperties(element, [ 'id', 'parent', 'delta', 'source', 'target', 'width', 'height', 'priority' ]);

  connection = modeling.createConnection(source, target, element, parent);

  return connection;
};


PasteHandler.prototype._createShape = function(element, parent, position, isAttach, hints) {
  var modeling = this._modeling,
      elementFactory = this._elementFactory,
      rules = this._rules;

  var canPaste = rules.allowed('element.paste', {
    element: element,
    position: position,
    parent: parent
  });

  if (!canPaste) {
    return null;
  }

  var shape = elementFactory.createShape(element);

  modeling.createShape(shape, position, parent, isAttach, hints);

  return shape;
};


PasteHandler.prototype._getCreatedElement = function(id, tree) {
  return tree.createdElements[id] && tree.createdElements[id].element;
};

},{"171":171,"257":257,"271":271,"273":273,"277":277,"387":387}],173:[function(_dereq_,module,exports){
'use strict';

var isArray = _dereq_(389);


/**
 * Reconnect connection handler
 */
function ReconnectConnectionHandler() { }

ReconnectConnectionHandler.$inject = [ ];

module.exports = ReconnectConnectionHandler;

ReconnectConnectionHandler.prototype.execute = function(context) {

  var newSource = context.newSource,
      newTarget = context.newTarget,
      connection = context.connection,
      dockingOrPoints = context.dockingOrPoints,
      oldWaypoints = connection.waypoints,
      newWaypoints;

  if (!newSource && !newTarget) {
    throw new Error('newSource or newTarget are required');
  }

  if (newSource && newTarget) {
    throw new Error('must specify either newSource or newTarget');
  }

  context.oldWaypoints = oldWaypoints;

  if (isArray(dockingOrPoints)) {
    newWaypoints = dockingOrPoints;
  } else {
    newWaypoints = oldWaypoints.slice();

    newWaypoints.splice(newSource ? 0 : -1, 1, dockingOrPoints);
  }

  if (newSource) {
    context.oldSource = connection.source;
    connection.source = newSource;
  }

  if (newTarget) {
    context.oldTarget = connection.target;
    connection.target = newTarget;
  }

  connection.waypoints = newWaypoints;

  return connection;
};

ReconnectConnectionHandler.prototype.revert = function(context) {

  var newSource = context.newSource,
      newTarget = context.newTarget,
      connection = context.connection;

  if (newSource) {
    connection.source = context.oldSource;
  }

  if (newTarget) {
    connection.target = context.oldTarget;
  }

  connection.waypoints = context.oldWaypoints;

  return connection;
};
},{"389":389}],174:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);


/**
 * A handler that implements reversible replacing of shapes.
 * Internally the old shape will be removed and the new shape will be added.
 *
 *
 * @class
 * @constructor
 *
 * @param {canvas} Canvas
 */
function ReplaceShapeHandler(modeling, rules) {
  this._modeling = modeling;
  this._rules = rules;
}

ReplaceShapeHandler.$inject = [ 'modeling', 'rules' ];

module.exports = ReplaceShapeHandler;



////// api /////////////////////////////////////////


/**
 * Replaces a shape with an replacement Element.
 *
 * The newData object should contain type, x, y.
 *
 * If possible also the incoming/outgoing connection
 * will be restored.
 *
 * @param {Object} context
 */
ReplaceShapeHandler.prototype.preExecute = function(context) {

  var self = this,
      modeling = this._modeling,
      rules = this._rules;

  var oldShape = context.oldShape,
      newData = context.newData,
      hints = context.hints,
      newShape;

  function canReconnect(type, source, target, connection) {
    return rules.allowed(type, {
      source: source,
      target: target,
      connection: connection
    });
  }


  // (1) place a new shape at the given position

  var position = {
    x: newData.x,
    y: newData.y
  };

  newShape = context.newShape = context.newShape || self.createShape(newData, position, oldShape.parent);


  // (2) update the host

  if (oldShape.host) {
    modeling.updateAttachment(newShape, oldShape.host);
  }


  // (3) adopt all children from the old shape

  var children;

  if (hints.moveChildren !== false) {
    children = oldShape.children.slice();

    modeling.moveElements(children, { x: 0, y: 0 }, newShape);
  }

  // (4) reconnect connections to the new shape (where allowed)

  var incoming = oldShape.incoming.slice(),
      outgoing = oldShape.outgoing.slice();

  forEach(incoming, function(connection) {
    var waypoints = connection.waypoints,
        docking = waypoints[waypoints.length - 1],
        source = connection.source,
        allowed = canReconnect('connection.reconnectEnd', source, newShape, connection);

    if (allowed) {
      self.reconnectEnd(connection, newShape, docking);
    }
  });

  forEach(outgoing, function(connection) {
    var waypoints = connection.waypoints,
        docking = waypoints[0],
        target = connection.target,
        allowed = canReconnect('connection.reconnectStart', newShape, target, connection);

    if (allowed) {
      self.reconnectStart(connection, newShape, docking);
    }

  });
};


ReplaceShapeHandler.prototype.postExecute = function(context) {
  var modeling = this._modeling;

  var oldShape = context.oldShape,
      newShape = context.newShape;

  // if an element gets resized on replace, layout the connection again
  forEach(newShape.incoming, function(c) {
    modeling.layoutConnection(c, { endChanged: true });
  });

  forEach(newShape.outgoing, function(c) {
    modeling.layoutConnection(c, { startChanged: true });
  });

  modeling.removeShape(oldShape);
};


ReplaceShapeHandler.prototype.execute = function(context) {};

ReplaceShapeHandler.prototype.revert = function(context) {};


ReplaceShapeHandler.prototype.createShape = function(shape, position, target) {
  var modeling = this._modeling;
  return modeling.createShape(shape, position, target);
};


ReplaceShapeHandler.prototype.reconnectStart = function(connection, newSource, dockingPoint) {
  var modeling = this._modeling;
  modeling.reconnectStart(connection, newSource, dockingPoint);
};


ReplaceShapeHandler.prototype.reconnectEnd = function(connection, newTarget, dockingPoint) {
  var modeling = this._modeling;
  modeling.reconnectEnd(connection, newTarget, dockingPoint);
};

},{"271":271}],175:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    forEach = _dereq_(271);

var getResizedSourceAnchor = _dereq_(179).getResizedSourceAnchor,
    getResizedTargetAnchor = _dereq_(179).getResizedTargetAnchor;

/**
 * A handler that implements reversible resizing of shapes.
 *
 * @param {Modeling} modeling
 */
function ResizeShapeHandler(modeling) {
  this._modeling = modeling;
}

ResizeShapeHandler.$inject = [ 'modeling' ];

module.exports = ResizeShapeHandler;

/**
 * {
 *   shape: {....}
 *   newBounds: {
 *     width:  20,
 *     height: 40,
 *     x:       5,
 *     y:      10
 *   }
 *
 * }
 */
ResizeShapeHandler.prototype.execute = function(context) {

  var shape = context.shape,
      newBounds = context.newBounds;

  if (newBounds.x === undefined || newBounds.y === undefined ||
      newBounds.width === undefined || newBounds.height === undefined) {
    throw new Error('newBounds must have {x, y, width, height} properties');
  }

  if (newBounds.width < 10 || newBounds.height < 10) {
    throw new Error('width and height cannot be less than 10px');
  }

  // save old bbox in context
  context.oldBounds = {
    width:  shape.width,
    height: shape.height,
    x:      shape.x,
    y:      shape.y
  };

  // update shape
  assign(shape, {
    width:  newBounds.width,
    height: newBounds.height,
    x:      newBounds.x,
    y:      newBounds.y
  });

  return shape;
};

ResizeShapeHandler.prototype.postExecute = function(context) {

  var shape = context.shape,
      oldBounds = context.oldBounds;

  var modeling = this._modeling;

  forEach(shape.incoming, function(c) {
    modeling.layoutConnection(c, {
      connectionEnd: getResizedTargetAnchor(c, shape, oldBounds)
    });
  });

  forEach(shape.outgoing, function(c) {
    modeling.layoutConnection(c, {
      connectionStart: getResizedSourceAnchor(c, shape, oldBounds)
    });
  });

};

ResizeShapeHandler.prototype.revert = function(context) {

  var shape = context.shape,
      oldBounds = context.oldBounds;

  // restore previous bbox
  assign(shape, {
    width:  oldBounds.width,
    height: oldBounds.height,
    x:      oldBounds.x,
    y:      oldBounds.y
  });

  return shape;
};

},{"179":179,"271":271,"398":398}],176:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var SpaceUtil = _dereq_(216);

/**
 * A handler that implements reversible creating and removing of space.
 *
 * It executes in two phases:
 *
 *  (1) resize all affected resizeShapes
 *  (2) move all affected moveElements
 */
function SpaceToolHandler(modeling) {
  this._modeling = modeling;
}

SpaceToolHandler.$inject = [ 'modeling' ];

module.exports = SpaceToolHandler;


SpaceToolHandler.prototype.preExecute = function(context) {

  // resize
  var modeling = this._modeling,
      resizingShapes = context.resizingShapes,
      delta = context.delta,
      direction = context.direction;

  forEach(resizingShapes, function(shape) {
    var newBounds = SpaceUtil.resizeBounds(shape, direction, delta);

    modeling.resizeShape(shape, newBounds);
  });
};

SpaceToolHandler.prototype.postExecute = function(context) {
  // move
  var modeling = this._modeling,
      movingShapes = context.movingShapes,
      delta = context.delta;

  modeling.moveElements(movingShapes, delta);
};

SpaceToolHandler.prototype.execute = function(context) {};
SpaceToolHandler.prototype.revert = function(context) {};

},{"216":216,"271":271}],177:[function(_dereq_,module,exports){
'use strict';

var Collections = _dereq_(232);

/**
 * A handler that implements reversible attaching/detaching of shapes.
 */
function UpdateAttachmentHandler(modeling) {
  this._modeling = modeling;
}

module.exports = UpdateAttachmentHandler;

UpdateAttachmentHandler.$inject = [ 'modeling' ];


UpdateAttachmentHandler.prototype.execute = function(context) {
  var shape = context.shape,
      newHost = context.newHost,
      oldHost = shape.host;

  // (0) detach from old host
  context.oldHost = oldHost;
  context.attacherIdx = removeAttacher(oldHost, shape);

  // (1) attach to new host
  addAttacher(newHost, shape);

  // (2) update host
  shape.host = newHost;

  return shape;
};

UpdateAttachmentHandler.prototype.revert = function(context) {
  var shape = context.shape,
      newHost = context.newHost,
      oldHost = context.oldHost,
      attacherIdx = context.attacherIdx;

  // (2) update host
  shape.host = oldHost;

  // (1) attach to new host
  removeAttacher(newHost, shape);

  // (0) detach from old host
  addAttacher(oldHost, shape, attacherIdx);

  return shape;
};


function removeAttacher(host, attacher) {
  // remove attacher from host
  return Collections.remove(host && host.attachers, attacher);
}

function addAttacher(host, attacher, idx) {

  if (!host) {
    return;
  }

  var attachers = host.attachers;

  if (!attachers) {
    host.attachers = attachers = [];
  }

  Collections.add(attachers, attacher, idx);
}

},{"232":232}],178:[function(_dereq_,module,exports){
'use strict';

function UpdateWaypointsHandler() { }

module.exports = UpdateWaypointsHandler;

UpdateWaypointsHandler.prototype.execute = function(context) {

  var connection = context.connection,
      newWaypoints = context.newWaypoints;

  context.oldWaypoints = connection.waypoints;

  connection.waypoints = newWaypoints;

  return connection;
};

UpdateWaypointsHandler.prototype.revert = function(context) {

  var connection = context.connection,
      oldWaypoints = context.oldWaypoints;

  connection.waypoints = oldWaypoints;

  return connection;
};
},{}],179:[function(_dereq_,module,exports){
'use strict';

var getNewAttachPoint = _dereq_(230).getNewAttachPoint;

function getResizedSourceAnchor(connection, shape, oldBounds) {

  var waypoints = safeGetWaypoints(connection),
      oldAnchor = waypoints[0];

  return getNewAttachPoint(oldAnchor.original || oldAnchor, oldBounds, shape);
}

module.exports.getResizedSourceAnchor = getResizedSourceAnchor;


function getResizedTargetAnchor(connection, shape, oldBounds) {

  var waypoints = safeGetWaypoints(connection),
      oldAnchor = waypoints[waypoints.length - 1];

  return getNewAttachPoint(oldAnchor.original || oldAnchor, oldBounds, shape);
}

module.exports.getResizedTargetAnchor = getResizedTargetAnchor;


function getMovedSourceAnchor(connection, source, moveDelta) {
  return getResizedSourceAnchor(connection, source, substractPosition(source, moveDelta));
}

module.exports.getMovedSourceAnchor = getMovedSourceAnchor;


function getMovedTargetAnchor(connection, target, moveDelta) {
  return getResizedTargetAnchor(connection, target, substractPosition(target, moveDelta));
}

module.exports.getMovedTargetAnchor = getMovedTargetAnchor;


//////// helpers ////////////////////////////////////

function substractPosition(bounds, delta) {
  return {
    x: bounds.x - delta.x,
    y: bounds.y - delta.y,
    width: bounds.width,
    height: bounds.height
  };
}


/**
 * Return waypoints of given connection; throw if non exists (should not happen!!).
 *
 * @param {Connection} connection
 *
 * @return {Array<Point>}
 */
function safeGetWaypoints(connection) {

  var waypoints = connection.waypoints;

  if (!waypoints.length) {
    throw new Error('connection#' + connection.id + ': no waypoints');
  }

  return waypoints;
}

},{"230":230}],180:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var Elements = _dereq_(235);

var getMovedSourceAnchor = _dereq_(179).getMovedSourceAnchor,
    getMovedTargetAnchor = _dereq_(179).getMovedTargetAnchor;

/**
 * A helper that is able to carry out serialized move operations on multiple elements.
 *
 * @param {Modeling} modeling
 */
function MoveHelper(modeling) {
  this._modeling = modeling;
}

module.exports = MoveHelper;

/**
 * Move the specified elements and all children by the given delta.
 *
 * This moves all enclosed connections, too and layouts all affected
 * external connections.
 *
 * @param  {Array<djs.model.Base>} elements
 * @param  {Point} delta
 * @param  {djs.model.Base} newParent applied to the first level of shapes
 *
 * @return {Array<djs.model.Base>} list of touched elements
 */
MoveHelper.prototype.moveRecursive = function(elements, delta, newParent) {
  if (!elements) {
    return [];
  } else {
    return this.moveClosure(this.getClosure(elements), delta, newParent);
  }
};

/**
 * Move the given closure of elmements.
 *
 * @param {Object} closure
 * @param {Point} delta
 * @param {djs.model.Base} [newParent]
 * @param {djs.model.Base} [newHost]
 */
MoveHelper.prototype.moveClosure = function(closure, delta, newParent, newHost, primaryShape) {
  var modeling = this._modeling;

  var allShapes = closure.allShapes,
      allConnections = closure.allConnections,
      enclosedConnections = closure.enclosedConnections,
      topLevel = closure.topLevel,
      keepParent = false;

  if (primaryShape && primaryShape.parent === newParent) {
    keepParent = true;
  }

  // move all shapes
  forEach(allShapes, function(shape) {

    // move the element according to the given delta
    modeling.moveShape(shape, delta, topLevel[shape.id] && !keepParent && newParent, {
      recurse: false,
      layout: false
    });
  });

  // move all child connections / layout external connections
  forEach(allConnections, function(c) {

    var sourceMoved = !!allShapes[c.source.id],
        targetMoved = !!allShapes[c.target.id];

    if (enclosedConnections[c.id] && sourceMoved && targetMoved) {
      modeling.moveConnection(c, delta, topLevel[c.id] && !keepParent && newParent);
    } else {
      modeling.layoutConnection(c, {
        connectionStart: sourceMoved && getMovedSourceAnchor(c, c.source, delta),
        connectionEnd: targetMoved && getMovedTargetAnchor(c, c.target, delta)
      });
    }
  });
};

/**
 * Returns the closure for the selected elements
 *
 * @param  {Array<djs.model.Base>} elements
 * @return {Object} closure
 */
MoveHelper.prototype.getClosure = function(elements) {
  return Elements.getClosure(elements);
};

},{"179":179,"235":235,"271":271}],181:[function(_dereq_,module,exports){
'use strict';

var bind = _dereq_(279);


function MouseTracking(eventBus, canvas) {
  this._eventBus = eventBus;
  this._canvas = canvas;

  this._init();
}

MouseTracking.$inject = [
  'eventBus',
  'canvas'
];

module.exports = MouseTracking;


MouseTracking.prototype.getHoverContext = function() {
  var viewbox = this._canvas.viewbox();

  return {
    element: this._hoverElement,
    point: {
      x: viewbox.x + Math.round(this._mouseX / viewbox.scale),
      y: viewbox.y + Math.round(this._mouseY / viewbox.scale)
    }
  };
};

MouseTracking.prototype._init = function() {
  var eventBus = this._eventBus,
      canvas = this._canvas;

  var container = canvas.getContainer();

  this._setMousePosition = bind(this._setMousePosition, this);

  container.addEventListener('mousemove', this._setMousePosition);

  eventBus.on('diagram.destroy', function() {
    container.removeEventListener('mousemove', this._setMousePosition);
  }, this);

  eventBus.on('element.hover', this._setHoverElement, this);
};


MouseTracking.prototype._setHoverElement = function(event) {
  this._hoverElement = event.element;
};


MouseTracking.prototype._setMousePosition = function(event) {
  this._mouseX = event.layerX;
  this._mouseY = event.layerY;
};

},{"279":279}],182:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: [ 'mouseTracking' ],
  mouseTracking: [ 'type', _dereq_(181) ]
};

},{"181":181}],183:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    filter = _dereq_(269),
    groupBy = _dereq_(272);

var LOW_PRIORITY = 500,
    MEDIUM_PRIORITY = 1250,
    HIGH_PRIORITY = 1500;

var getOriginalEvent = _dereq_(236).getOriginal;

var round = Math.round;

function mid(element) {
  return {
    x: element.x + round(element.width / 2),
    y: element.y + round(element.height / 2)
  };
}

/**
 * A plugin that makes shapes draggable / droppable.
 *
 * @param {EventBus} eventBus
 * @param {Dragging} dragging
 * @param {Modeling} modeling
 * @param {Selection} selection
 * @param {Rules} rules
 */
function MoveEvents(eventBus, dragging, modeling, selection, rules) {

  // rules

  function canMove(shapes, delta, position, target) {

    return rules.allowed('elements.move', {
      shapes: shapes,
      delta: delta,
      position: position,
      target: target
    });
  }


  // move events

  // assign a high priority to this handler to setup the environment
  // others may hook up later, e.g. at default priority and modify
  // the move environment.
  //
  // This sets up the context with
  //
  // * shape: the primary shape being moved
  // * shapes: a list of shapes to be moved
  // * validatedShapes: a list of shapes that are being checked
  //                    against the rules before and during move
  //
  eventBus.on('shape.move.start', HIGH_PRIORITY, function(event) {

    var context = event.context,
        shape = event.shape,
        shapes = selection.get().slice();

    // move only single shape if the dragged element
    // is not part of the current selection
    if (shapes.indexOf(shape) === -1) {
      shapes = [ shape ];
    }

    // ensure we remove nested elements in the collection
    // and add attachers for a proper dragger
    shapes = removeNested(shapes);

    // attach shapes to drag context
    assign(context, {
      shapes: shapes,
      validatedShapes: shapes,
      shape: shape
    });
  });


  // assign a high priority to this handler to setup the environment
  // others may hook up later, e.g. at default priority and modify
  // the move environment
  //
  eventBus.on('shape.move.start', MEDIUM_PRIORITY, function(event) {

    var context = event.context,
        validatedShapes = context.validatedShapes,
        canExecute;

    canExecute = context.canExecute = canMove(validatedShapes);

    // check if we can move the elements
    if (!canExecute) {
      // suppress move operation
      event.stopPropagation();

      return false;
    }
  });

  // assign a low priority to this handler
  // to let others modify the move event before we update
  // the context
  //
  eventBus.on('shape.move.move', LOW_PRIORITY, function(event) {

    var context = event.context,
        validatedShapes = context.validatedShapes,
        hover = event.hover,
        delta = { x: event.dx, y: event.dy },
        position = { x: event.x, y: event.y },
        canExecute;

    // check if we can move the elements
    canExecute = canMove(validatedShapes, delta, position, hover);

    context.delta = delta;
    context.canExecute = canExecute;

    // simply ignore move over
    if (canExecute === null) {
      context.target = null;

      return;
    }

    context.target = hover;
  });

  eventBus.on('shape.move.end', function(event) {

    var context = event.context;

    var delta = context.delta,
        canExecute = context.canExecute,
        isAttach = canExecute === 'attach',
        shapes = context.shapes;

    if (!canExecute) {
      return false;
    }

    // ensure we have actual pixel values deltas
    // (important when zoom level was > 1 during move)
    delta.x = round(delta.x);
    delta.y = round(delta.y);

    modeling.moveElements(shapes, delta, context.target, isAttach, { primaryShape: context.shape });
  });


  // move activation

  eventBus.on('element.mousedown', function(event) {

    var originalEvent = getOriginalEvent(event);

    if (!originalEvent) {
      throw new Error('must supply DOM mousedown event');
    }

    start(originalEvent, event.element);
  });


  function start(event, element, activate) {

    // do not move connections or the root element
    if (element.waypoints || !element.parent) {
      return;
    }

    var referencePoint = mid(element);

    dragging.init(event, referencePoint, 'shape.move', {
      cursor: 'grabbing',
      autoActivate: activate,
      data: {
        shape: element,
        context: {}
      }
    });
  }

  // API

  this.start = start;
}

MoveEvents.$inject = [ 'eventBus', 'dragging', 'modeling', 'selection', 'rules' ];

module.exports = MoveEvents;


/**
 * Return a filtered list of elements that do not contain
 * those nested into others.
 *
 * @param  {Array<djs.model.Base>} elements
 *
 * @return {Array<djs.model.Base>} filtered
 */
function removeNested(elements) {

  var ids = groupBy(elements, 'id');

  return filter(elements, function(element) {
    while ((element = element.parent)) {

      // parent in selection
      if (ids[element.id]) {
        return false;
      }
    }

    return true;
  });
}

},{"236":236,"269":269,"272":272,"398":398}],184:[function(_dereq_,module,exports){
'use strict';

var flatten = _dereq_(259),
    forEach = _dereq_(271),
    filter = _dereq_(269),
    find = _dereq_(270),
    size = _dereq_(275),
    groupBy = _dereq_(272),
    map = _dereq_(273);

var Elements = _dereq_(235);

var LOW_PRIORITY = 500;

var MARKER_DRAGGING = 'djs-dragging',
    MARKER_OK = 'drop-ok',
    MARKER_NOT_OK = 'drop-not-ok',
    MARKER_NEW_PARENT = 'new-parent',
    MARKER_ATTACH = 'attach-ok';


/**
 * A plugin that makes shapes draggable / droppable.
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 * @param {Canvas} canvas
 * @param {Styles} styles
 */
function MoveVisuals(eventBus, elementRegistry, canvas, styles) {

  function getGfx(e) {
    return elementRegistry.getGraphics(e);
  }

  function getVisualDragShapes(shapes) {
    var elements = getAllDraggedElements(shapes);

    var filteredElements = removeEdges(elements);

    return filteredElements;
  }

  function getAllDraggedElements(shapes) {
    var allShapes = Elements.selfAndAllChildren(shapes, true);

    var allConnections = map(allShapes, function(shape) {
      return (shape.incoming || []).concat(shape.outgoing || []);
    });

    return flatten(allShapes.concat(allConnections), true);
  }

  /** set drop marker on an element */
  function setMarker(element, marker) {

    [ MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT ].forEach(function(m) {

      if (m === marker) {
        canvas.addMarker(element, m);
      } else {
        canvas.removeMarker(element, m);
      }
    });
  }

  /**
   * Add a dragger for the given shape in the specific
   * move context.
   *
   * @param {Object} context
   * @param {djs.model.Base} element
   */
  function addDragger(context, element) {

    var dragGroup = context.dragGroup;

    if (!dragGroup) {
      dragGroup = context.dragGroup =
        canvas.getDefaultLayer()
          .group()
            .attr(styles.cls('djs-drag-group', [ 'no-events' ]));
    }

    var gfx = getGfx(element),
        dragger = gfx.clone(),
        bbox = gfx.getBBox();

    dragger.attr(styles.cls('djs-dragger', [], {
      x: bbox.x,
      y: bbox.y
    }));

    dragGroup.add(dragger);

    return dragger;
  }

  this.addDragger = addDragger;

  function makeDraggable(context, element, addMarker) {

    addDragger(context, element);

    if (addMarker) {
      canvas.addMarker(element, MARKER_DRAGGING);
    }

    if (context.allDraggedElements) {
      context.allDraggedElements.push(element);
    } else {
      context.allDraggedElements = [ element ];
    }
  }

  // expose to other components
  // that plug into the drag behavior
  this.makeDraggable = makeDraggable;


  // assign a low priority to this handler
  // to let others modify the move context before
  // we draw things
  //
  eventBus.on('shape.move.start', LOW_PRIORITY, function(event) {

    var context = event.context,
        dragShapes = context.shapes,
        allDraggedElements = context.allDraggedElements;

    var visuallyDraggedShapes = getVisualDragShapes(dragShapes);

    visuallyDraggedShapes.forEach(function(shape) {
      addDragger(context, shape);
    });

    // cache all dragged elements / gfx
    // so that we can quickly undo their state changes later
    if (!allDraggedElements) {
      allDraggedElements = getAllDraggedElements(dragShapes);
    } else {
      allDraggedElements = flatten(allDraggedElements, getAllDraggedElements(dragShapes));
    }

    // add dragging marker
    forEach(allDraggedElements, function(e) {
      canvas.addMarker(e, MARKER_DRAGGING);
    });

    context.allDraggedElements = allDraggedElements;

    // determine, if any of the dragged elements have different parents
    context.differentParents = haveDifferentParents(dragShapes);
  });

  // assign a low priority to this handler
  // to let others modify the move context before
  // we draw things
  //
  eventBus.on('shape.move.move', LOW_PRIORITY, function(event) {

    var context = event.context,
        dragGroup = context.dragGroup,
        target = context.target,
        parent = context.shape.parent,
        canExecute = context.canExecute;

    if (target) {
      if (canExecute === 'attach') {
        setMarker(target, MARKER_ATTACH);
      } else if (context.canExecute && target && target.id !== parent.id) {
        setMarker(target, MARKER_NEW_PARENT);
      } else {
        setMarker(target, context.canExecute ? MARKER_OK : MARKER_NOT_OK);
      }
    }

    dragGroup.translate(event.dx, event.dy);
  });

  eventBus.on([ 'shape.move.out', 'shape.move.cleanup' ], function(event) {
    var context = event.context,
        target = context.target;

    if (target) {
      setMarker(target, null);
    }
  });

  eventBus.on('shape.move.cleanup', function(event) {

    var context = event.context,
        allDraggedElements = context.allDraggedElements,
        dragGroup = context.dragGroup;


    // remove dragging marker
    forEach(allDraggedElements, function(e) {
      canvas.removeMarker(e, MARKER_DRAGGING);
    });

    if (dragGroup) {
      dragGroup.remove();
    }
  });
}

// returns elements minus all connections
// where source or target is not elements
function removeEdges(elements) {

  var filteredElements = filter(elements, function(element) {

    if (!element.waypoints) { // shapes
      return true;
    } else {                  // connections
      var srcFound = find(elements, element.source);
      var targetFound = find(elements, element.target);

      return srcFound && targetFound;
    }
  });

  return filteredElements;
}

function haveDifferentParents(elements) {
  return size(groupBy(elements, function(e) { return e.parent && e.parent.id; })) !== 1;
}

MoveVisuals.$inject = [ 'eventBus', 'elementRegistry', 'canvas', 'styles' ];

module.exports = MoveVisuals;

},{"235":235,"259":259,"269":269,"270":270,"271":271,"272":272,"273":273,"275":275}],185:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(150),
    _dereq_(210),
    _dereq_(188),
    _dereq_(204),
    _dereq_(142)
  ],
  __init__: [ 'move', 'moveVisuals' ],
  move: [ 'type', _dereq_(183) ],
  moveVisuals: [ 'type', _dereq_(184) ]
};

},{"142":142,"150":150,"183":183,"184":184,"188":188,"204":204,"210":210}],186:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);


/**
 * An abstract provider that allows modelers to implement a custom
 * ordering of diagram elements on the canvas.
 *
 * It makes sure that the order is always preserved during element
 * creation and move operations.
 *
 * In order to use this behavior, inherit from it and override
 * the method {@link OrderingProvider#getOrdering}.
 *
 * @example
 *
 * ```javascript
 * function CustomOrderingProvider(eventBus) {
 *   OrderingProvider.call(this, eventBus);
 *
 *   this.getOrdering = function(element, newParent) {
 *     // always insert elements at the front
 *     // when moving
 *     return {
 *       index: 0,
 *       parent: newParent
 *     };
 *   };
 * }
 * ```
 *
 * @param {EventBus} eventBus
 */
function OrderingProvider(eventBus) {

  CommandInterceptor.call(this, eventBus);


  var self = this;

  this.preExecute([ 'shape.create', 'connection.create' ], function(event) {

    var context = event.context,
        element = context.shape || context.connection,
        parent = context.parent;

    var ordering = self.getOrdering(element, parent);

    if (ordering) {

      if (ordering.parent !== undefined) {
        context.parent = ordering.parent;
      }

      context.parentIndex = ordering.index;
    }
  });

  this.preExecute([ 'shape.move', 'connection.move' ], function(event) {

    var context = event.context,
        element = context.shape || context.connection,
        parent = context.newParent || element.parent;

    var ordering = self.getOrdering(element, parent);

    if (ordering) {

      if (ordering.parent !== undefined) {
        context.newParent = ordering.parent;
      }

      context.newParentIndex = ordering.index;
    }
  });
}

/**
 * Return a custom ordering of the element, both in terms
 * of parent element and index in the new parent.
 *
 * Implementors of this method must return an object with
 * `parent` _and_ `index` in it.
 *
 * @param {djs.model.Base} element
 * @param {djs.model.Shape} newParent
 *
 * @return {Object} ordering descriptor
 */
OrderingProvider.prototype.getOrdering = function(element, newParent) {
  return null;
};

inherits(OrderingProvider, CommandInterceptor);

module.exports = OrderingProvider;
},{"102":102,"257":257}],187:[function(_dereq_,module,exports){
'use strict';

var getBBox = _dereq_(235).getBBox;


/**
 * @class
 *
 * A plugin that adds an outline to shapes and connections that may be activated and styled
 * via CSS classes.
 *
 * @param {EventBus} eventBus
 * @param {Styles} styles
 * @param {ElementRegistry} elementRegistry
 */
function Outline(eventBus, styles, elementRegistry) {

  this.offset = 6;

  var OUTLINE_STYLE = styles.cls('djs-outline', [ 'no-fill' ]);

  var self = this;

  function createOutline(gfx, bounds) {
    return gfx.rect(10, 10, 0, 0).attr(OUTLINE_STYLE);
  }

  eventBus.on([ 'shape.added', 'shape.changed' ], function(event) {
    var element = event.element,
        gfx     = event.gfx;

    var outline = gfx.select('.djs-outline');

    if (!outline) {
      outline = createOutline(gfx, element);
    }

    self.updateShapeOutline(outline, element);
  });

  eventBus.on([ 'connection.added', 'connection.changed' ], function(event) {
    var element = event.element,
        gfx     = event.gfx;

    var outline = gfx.select('.djs-outline');

    if (!outline) {
      outline = createOutline(gfx, element);
    }

    self.updateConnectionOutline(outline, element);
  });
}


/**
 * Updates the outline of a shape respecting the dimension of the
 * element and an outline offset.
 *
 * @param  {SVGElement} outline
 * @param  {djs.model.Base} element
 */
Outline.prototype.updateShapeOutline = function(outline, element) {

  outline.attr({
    x: -this.offset,
    y: -this.offset,
    width: element.width + this.offset * 2,
    height: element.height + this.offset * 2
  });

};


/**
 * Updates the outline of a connection respecting the bounding box of
 * the connection and an outline offset.
 *
 * @param  {SVGElement} outline
 * @param  {djs.model.Base} element
 */
Outline.prototype.updateConnectionOutline = function(outline, connection) {

  var bbox = getBBox(connection);

  outline.attr({
    x: bbox.x - this.offset,
    y: bbox.y - this.offset,
    width: bbox.width + this.offset * 2,
    height: bbox.height + this.offset * 2
  });

};


Outline.$inject = ['eventBus', 'styles', 'elementRegistry'];

module.exports = Outline;

},{"235":235}],188:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: [ 'outline' ],
  outline: [ 'type', _dereq_(187) ]
};
},{"187":187}],189:[function(_dereq_,module,exports){
'use strict';

var isArray = _dereq_(389),
    isString = _dereq_(395),
    isObject = _dereq_(393),
    assign = _dereq_(398),
    forEach = _dereq_(271),
    find = _dereq_(270),
    filter = _dereq_(269);

var domify = _dereq_(415),
    domClasses = _dereq_(411),
    domAttr = _dereq_(410),
    domRemove = _dereq_(419),
    domClear = _dereq_(412);

var getBBox = _dereq_(235).getBBox;

// document wide unique overlay ids
var ids = new (_dereq_(239))('ov');


function createRoot(parent) {
  var root = domify('<div class="djs-overlay-container" style="position: absolute; width: 0; height: 0;" />');
  parent.insertBefore(root, parent.firstChild);

  return root;
}


function setPosition(el, x, y) {
  assign(el.style, { left: x + 'px', top: y + 'px' });
}

function setVisible(el, visible) {
  el.style.display = visible === false ? 'none' : '';
}

/**
 * A service that allows users to attach overlays to diagram elements.
 *
 * The overlay service will take care of overlay positioning during updates.
 *
 * @example
 *
 * // add a pink badge on the top left of the shape
 * overlays.add(someShape, {
 *   position: {
 *     top: -5,
 *     left: -5
 *   },
 *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
 * });
 *
 * // or add via shape id
 *
 * overlays.add('some-element-id', {
 *   position: {
 *     top: -5,
 *     left: -5
 *   }
 *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
 * });
 *
 * // or add with optional type
 *
 * overlays.add(someShape, 'badge', {
 *   position: {
 *     top: -5,
 *     left: -5
 *   }
 *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
 * });
 *
 *
 * // remove an overlay
 *
 * var id = overlays.add(...);
 * overlays.remove(id);
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {ElementRegistry} elementRegistry
 */
function Overlays(eventBus, canvas, elementRegistry) {

  this._eventBus = eventBus;
  this._canvas = canvas;
  this._elementRegistry = elementRegistry;

  this._ids = ids;

  this._overlayDefaults = {
    show: {
      minZoom: 0.7,
      maxZoom: 5.0
    }
  };

  /**
   * Mapping overlayId -> overlay
   */
  this._overlays = {};

  /**
   * Mapping elementId -> overlay container
   */
  this._overlayContainers = [];

  // root html element for all overlays
  this._overlayRoot = createRoot(canvas.getContainer());

  this._init();
}


Overlays.$inject = [ 'eventBus', 'canvas', 'elementRegistry' ];

module.exports = Overlays;


/**
 * Returns the overlay with the specified id or a list of overlays
 * for an element with a given type.
 *
 * @example
 *
 * // return the single overlay with the given id
 * overlays.get('some-id');
 *
 * // return all overlays for the shape
 * overlays.get({ element: someShape });
 *
 * // return all overlays on shape with type 'badge'
 * overlays.get({ element: someShape, type: 'badge' });
 *
 * // shape can also be specified as id
 * overlays.get({ element: 'element-id', type: 'badge' });
 *
 *
 * @param {Object} search
 * @param {String} [search.id]
 * @param {String|djs.model.Base} [search.element]
 * @param {String} [search.type]
 *
 * @return {Object|Array<Object>} the overlay(s)
 */
Overlays.prototype.get = function(search) {

  if (isString(search)) {
    search = { id: search };
  }

  if (isString(search.element)) {
    search.element = this._elementRegistry.get(search.element);
  }

  if (search.element) {
    var container = this._getOverlayContainer(search.element, true);

    // return a list of overlays when searching by element (+type)
    if (container) {
      return search.type ? filter(container.overlays, { type: search.type }) : container.overlays.slice();
    } else {
      return [];
    }
  } else
  if (search.type) {
    return filter(this._overlays, { type: search.type });
  } else {
    // return single element when searching by id
    return search.id ? this._overlays[search.id] : null;
  }
};

/**
 * Adds a HTML overlay to an element.
 *
 * @param {String|djs.model.Base}   element   attach overlay to this shape
 * @param {String}                  [type]    optional type to assign to the overlay
 * @param {Object}                  overlay   the overlay configuration
 *
 * @param {String|DOMElement}       overlay.html                 html element to use as an overlay
 * @param {Object}                  [overlay.show]               show configuration
 * @param {Number}                  [overlay.show.minZoom]       minimal zoom level to show the overlay
 * @param {Number}                  [overlay.show.maxZoom]       maximum zoom level to show the overlay
 * @param {Object}                  overlay.position             where to attach the overlay
 * @param {Number}                  [overlay.position.left]      relative to element bbox left attachment
 * @param {Number}                  [overlay.position.top]       relative to element bbox top attachment
 * @param {Number}                  [overlay.position.bottom]    relative to element bbox bottom attachment
 * @param {Number}                  [overlay.position.right]     relative to element bbox right attachment
 *
 * @return {String}                 id that may be used to reference the overlay for update or removal
 */
Overlays.prototype.add = function(element, type, overlay) {

  if (isObject(type)) {
    overlay = type;
    type = null;
  }

  if (!element.id) {
    element = this._elementRegistry.get(element);
  }

  if (!overlay.position) {
    throw new Error('must specifiy overlay position');
  }

  if (!overlay.html) {
    throw new Error('must specifiy overlay html');
  }

  if (!element) {
    throw new Error('invalid element specified');
  }

  var id = this._ids.next();

  overlay = assign({}, this._overlayDefaults, overlay, {
    id: id,
    type: type,
    element: element,
    html: overlay.html
  });

  this._addOverlay(overlay);

  return id;
};


/**
 * Remove an overlay with the given id or all overlays matching the given filter.
 *
 * @see Overlays#get for filter options.
 *
 * @param {String} [id]
 * @param {Object} [filter]
 */
Overlays.prototype.remove = function(filter) {

  var overlays = this.get(filter) || [];

  if (!isArray(overlays)) {
    overlays = [ overlays ];
  }

  var self = this;

  forEach(overlays, function(overlay) {

    var container = self._getOverlayContainer(overlay.element, true);

    if (overlay) {
      domRemove(overlay.html);
      domRemove(overlay.htmlContainer);

      delete overlay.htmlContainer;
      delete overlay.element;

      delete self._overlays[overlay.id];
    }

    if (container) {
      var idx = container.overlays.indexOf(overlay);
      if (idx !== -1) {
        container.overlays.splice(idx, 1);
      }
    }
  });

};


Overlays.prototype.show = function() {
  setVisible(this._overlayRoot);
};


Overlays.prototype.hide = function() {
  setVisible(this._overlayRoot, false);
};

Overlays.prototype.clear = function() {
  this._overlays = {};

  this._overlayContainers = [];

  domClear(this._overlayRoot);
};

Overlays.prototype._updateOverlayContainer = function(container) {
  var element = container.element,
      html = container.html;

  // update container left,top according to the elements x,y coordinates
  // this ensures we can attach child elements relative to this container

  var x = element.x,
      y = element.y;

  if (element.waypoints) {
    var bbox = getBBox(element);
    x = bbox.x;
    y = bbox.y;
  }

  setPosition(html, x, y);

  domAttr(container.html, 'data-container-id', element.id);
};


Overlays.prototype._updateOverlay = function(overlay) {

  var position = overlay.position,
      htmlContainer = overlay.htmlContainer,
      element = overlay.element;

  // update overlay html relative to shape because
  // it is already positioned on the element

  // update relative
  var left = position.left,
      top = position.top;

  if (position.right !== undefined) {

    var width;

    if (element.waypoints) {
      width = getBBox(element).width;
    } else {
      width = element.width;
    }

    left = position.right * -1 + width;
  }

  if (position.bottom !== undefined) {

    var height;

    if (element.waypoints) {
      height = getBBox(element).height;
    } else {
      height = element.height;
    }

    top = position.bottom * -1 + height;
  }

  setPosition(htmlContainer, left || 0, top || 0);
};

Overlays.prototype._createOverlayContainer = function(element) {
  var html = domify('<div class="djs-overlays" style="position: absolute" />');

  this._overlayRoot.appendChild(html);

  var container = {
    html: html,
    element: element,
    overlays: []
  };

  this._updateOverlayContainer(container);

  this._overlayContainers.push(container);

  return container;
};


Overlays.prototype._updateRoot = function(viewbox) {
  var a = viewbox.scale || 1;
  var d = viewbox.scale || 1;

  var matrix = 'matrix(' + a + ',0,0,' + d + ',' + (-1 * viewbox.x * a) + ',' + (-1 * viewbox.y * d) + ')';

  this._overlayRoot.style.transform = matrix;
  this._overlayRoot.style['-ms-transform'] = matrix;
  this._overlayRoot.style['-webkit-transform'] = matrix;
};


Overlays.prototype._getOverlayContainer = function(element, raw) {
  var container = find(this._overlayContainers, function(c) {
    return c.element === element;
  });


  if (!container && !raw) {
    return this._createOverlayContainer(element);
  }

  return container;
};





Overlays.prototype._addOverlay = function(overlay) {

  var id = overlay.id,
      element = overlay.element,
      html = overlay.html,
      htmlContainer,
      overlayContainer;

  // unwrap jquery (for those who need it)
  if (html.get) {
    html = html.get(0);
  }

  // create proper html elements from
  // overlay HTML strings
  if (isString(html)) {
    html = domify(html);
  }

  overlayContainer = this._getOverlayContainer(element);

  htmlContainer = domify('<div class="djs-overlay" data-overlay-id="' + id + '" style="position: absolute">');

  htmlContainer.appendChild(html);

  if (overlay.type) {
    domClasses(htmlContainer).add('djs-overlay-' + overlay.type);
  }

  overlay.htmlContainer = htmlContainer;

  overlayContainer.overlays.push(overlay);
  overlayContainer.html.appendChild(htmlContainer);

  this._overlays[id] = overlay;

  this._updateOverlay(overlay);
  this._updateOverlayVisibilty(overlay, this._canvas.viewbox());
};

Overlays.prototype._updateOverlayVisibilty = function(overlay, viewbox) {
  var show = overlay.show,
      htmlContainer = overlay.htmlContainer,
      visible = true;

  if (show) {
    if (show.minZoom > viewbox.scale ||
        show.maxZoom < viewbox.scale) {
      visible = false;
    }

    setVisible(htmlContainer, visible);
  }
};

Overlays.prototype._updateOverlaysVisibilty = function(viewbox) {

  var self = this;

  forEach(this._overlays, function(overlay) {
    self._updateOverlayVisibilty(overlay, viewbox);
  });
};


Overlays.prototype._init = function() {

  var eventBus = this._eventBus;

  var self = this;


  // scroll/zoom integration

  function updateViewbox(viewbox) {
    self._updateRoot(viewbox);
    self._updateOverlaysVisibilty(viewbox);

    self.show();
  }

  eventBus.on('canvas.viewbox.changing', function(event) {
    self.hide();
  });

  eventBus.on('canvas.viewbox.changed', function(event) {
    updateViewbox(event.viewbox);
  });


  // remove integration

  eventBus.on([ 'shape.remove', 'connection.remove' ], function(e) {
    var element = e.element;
    var overlays = self.get({ element: element });

    forEach(overlays, function(o) {
      self.remove(o.id);
    });

    var container = self._getOverlayContainer(element);

    if (container) {
      domRemove(container.html);
      var i = self._overlayContainers.indexOf(container);
      if (i !== -1) {
        self._overlayContainers.splice(i, 1);
      }
    }
  });


  // move integration

  eventBus.on([
    'element.changed'
  ], function(e) {
    var element = e.element;

    var container = self._getOverlayContainer(element, true);

    if (container) {
      forEach(container.overlays, function(overlay) {
        self._updateOverlay(overlay);
      });

      self._updateOverlayContainer(container);
    }
  });


  // marker integration, simply add them on the overlays as classes, too.

  eventBus.on('element.marker.update', function(e) {
    var container = self._getOverlayContainer(e.element, true);
    if (container) {
      domClasses(container.html)[e.add ? 'add' : 'remove'](e.marker);
    }
  });


  // clear overlays with diagram

  eventBus.on('diagram.clear', this.clear, this);
};

},{"235":235,"239":239,"269":269,"270":270,"271":271,"389":389,"393":393,"395":395,"398":398,"410":410,"411":411,"412":412,"415":415,"419":419}],190:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'overlays' ],
  overlays: [ 'type', _dereq_(189) ]
};
},{"189":189}],191:[function(_dereq_,module,exports){
'use strict';

var isFunction = _dereq_(390),
    forEach = _dereq_(271);

var domify = _dereq_(415),
    domQuery = _dereq_(418),
    domAttr = _dereq_(410),
    domClear = _dereq_(412),
    domClasses = _dereq_(411),
    domMatches = _dereq_(417),
    domDelegate = _dereq_(414),
    domEvent = _dereq_(416);


var toggleSelector = '.djs-palette-toggle',
    entrySelector = '.entry',
    elementSelector = toggleSelector + ', ' + entrySelector;


/**
 * A palette containing modeling elements.
 */
function Palette(eventBus, canvas, dragging) {

  this._eventBus = eventBus;
  this._canvas = canvas;
  this._dragging = dragging;

  this._providers = [];

  var self = this;

  eventBus.on('tool-manager.update', function(event) {
    var tool = event.tool;

    self.updateToolHighlight(tool);
  });

  eventBus.on('i18n.changed', function() {
    self._update();
  });
}

Palette.$inject = [ 'eventBus', 'canvas', 'dragging' ];

module.exports = Palette;


/**
 * Register a provider with the palette
 *
 * @param  {PaletteProvider} provider
 */
Palette.prototype.registerProvider = function(provider) {
  this._providers.push(provider);

  if (!this._container) {
    this._init();
  }

  this._update();
};


/**
 * Returns the palette entries for a given element
 *
 * @return {Array<PaletteEntryDescriptor>} list of entries
 */
Palette.prototype.getEntries = function() {

  var entries = {};

  // loop through all providers and their entries.
  // group entries by id so that overriding an entry is possible
  forEach(this._providers, function(provider) {
    var e = provider.getPaletteEntries();

    forEach(e, function(entry, id) {
      entries[id] = entry;
    });
  });

  return entries;
};


/**
 * Initialize
 */
Palette.prototype._init = function() {
  var canvas = this._canvas,
      eventBus = this._eventBus;

  var parent = canvas.getContainer(),
      container = this._container = domify(Palette.HTML_MARKUP),
      self = this;

  parent.appendChild(container);

  domDelegate.bind(container, elementSelector, 'click', function(event) {

    var target = event.delegateTarget;

    if (domMatches(target, toggleSelector)) {
      return self.toggle();
    }

    self.trigger('click', event);
  });

  // prevent drag propagation
  domEvent.bind(container, 'mousedown', function(event) {
    event.stopPropagation();
  });

  // prevent drag propagation
  domDelegate.bind(container, entrySelector, 'dragstart', function(event) {
    self.trigger('dragstart', event);
  });

  eventBus.fire('palette.create', {
    html: container
  });

  eventBus.on('canvas.resized', function() {
    if (parent.clientHeight < 650) {
      domClasses(container).add('two-column');
    } else {
      domClasses(container).remove('two-column');
    }
  });
};


Palette.prototype._update = function() {

  var entriesContainer = domQuery('.djs-palette-entries', this._container),
      entries = this._entries = this.getEntries();

  domClear(entriesContainer);

  forEach(entries, function(entry, id) {

    var grouping = entry.group || 'default';

    var container = domQuery('[data-group=' + grouping + ']', entriesContainer);
    if (!container) {
      container = domify('<div class="group" data-group="' + grouping + '"></div>');
      entriesContainer.appendChild(container);
    }

    var html = entry.html || (
      entry.separator ?
        '<hr class="separator" />' :
        '<div class="entry" draggable="true"></div>');


    var control = domify(html);
    container.appendChild(control);

    if (!entry.separator) {
      domAttr(control, 'data-action', id);

      if (entry.title) {
        domAttr(control, 'title', entry.title);
      }

      if (entry.className) {
        domClasses(control).add(entry.className);
      }

      if (entry.imageUrl) {
        control.appendChild(domify('<img src="' + entry.imageUrl + '">'));
      }
    }
  });

  // open after update
  this.open(true);
};


/**
 * Trigger an action available on the palette
 *
 * @param  {String} action
 * @param  {Event} event
 */
Palette.prototype.trigger = function(action, event, autoActivate) {
  var entries = this._entries,
      entry,
      handler,
      originalEvent,
      button = event.delegateTarget || event.target;

  if (!button) {
    return event.preventDefault();
  }

  entry = entries[domAttr(button, 'data-action')];

  // when user clicks on the palette and not on an action
  if (!entry) {
    return;
  }

  handler = entry.action;

  originalEvent = event.originalEvent || event;

  // simple action (via callback function)
  if (isFunction(handler)) {
    if (action === 'click') {
      handler(originalEvent, autoActivate);
    }
  } else {
    if (handler[action]) {
      handler[action](originalEvent, autoActivate);
    }
  }

  // silence other actions
  event.preventDefault();
};


/**
 * Close the palette
 */
Palette.prototype.close = function() {
  domClasses(this._container).remove('open');
};


/**
 * Open the palette
 */
Palette.prototype.open = function() {
  domClasses(this._container).add('open');
};


Palette.prototype.toggle = function(open) {
  if (this.isOpen()) {
    this.close();
  } else {
    this.open();
  }
};

Palette.prototype.isActiveTool = function(tool) {
  return tool && this._activeTool === tool;
};

Palette.prototype.updateToolHighlight = function(name) {
  var entriesContainer,
      toolsContainer;

  if (!this._toolsContainer) {
    entriesContainer = domQuery('.djs-palette-entries', this._container);

    this._toolsContainer = domQuery('[data-group=tools]', entriesContainer);
  }

  toolsContainer = this._toolsContainer;

  forEach(toolsContainer.children, function(tool) {
    var actionName = tool.getAttribute('data-action');

    if (!actionName) {
      return;
    }

    actionName = actionName.replace('-tool', '');

    if (tool.classList.contains('entry') && actionName === name) {
      domClasses(tool).add('highlighted-entry');
    } else {
      domClasses(tool).remove('highlighted-entry');
    }
  });
};


/**
 * Return true if the palette is opened.
 *
 * @example
 *
 * palette.open();
 *
 * if (palette.isOpen()) {
 *   // yes, we are open
 * }
 *
 * @return {boolean} true if palette is opened
 */
Palette.prototype.isOpen = function() {
  return this._container && domClasses(this._container).has('open');
};


/* markup definition */

Palette.HTML_MARKUP =
  '<div class="djs-palette">' +
    '<div class="djs-palette-entries"></div>' +
    '<div class="djs-palette-toggle"></div>' +
  '</div>';

},{"271":271,"390":390,"410":410,"411":411,"412":412,"414":414,"415":415,"416":416,"417":417,"418":418}],192:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [ _dereq_(219) ],
  __init__: [ 'palette' ],
  palette: [ 'type', _dereq_(191) ]
};

},{"191":191,"219":219}],193:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271),
    assign = _dereq_(398),
    find = _dereq_(270);

var domDelegate = _dereq_(414),
    domify = _dereq_(415),
    domClasses = _dereq_(411),
    domAttr = _dereq_(410),
    domRemove = _dereq_(419);

var DATA_REF = 'data-id';

/**
 * A popup menu that can be used to display a list of actions anywhere in the canvas.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 *
 * @class
 * @constructor
 */
function PopupMenu(eventBus, canvas) {

  this._eventBus = eventBus;
  this._canvas  = canvas;
  this._providers = {};
}

PopupMenu.$inject = [ 'eventBus', 'canvas' ];

/**
 * Registers a popup menu provider
 *
 * @param  {String} id
 * @param  {Object} provider
 *
 * @example
 * popupMenu.registerProvider('myMenuID', {
 *   getEntries: function(element) {
 *     return [
 *       {
 *          id: 'entry-1',
 *          label: 'My Entry',
 *          action: 'alert("I have been clicked!")'
 *        }
 *      ];
 *    }
 *  });
 * })
 */
PopupMenu.prototype.registerProvider = function(id, provider) {
  this._providers[id] = provider;
};


/**
 * Create a popup menu according to a given element. The id refers to the ID
 * of the provider that must be registered before.
 *
 * @param  {String} id provider id
 * @param  {Object} element
 *
 * @return {PopupMenu} popup menu instance
 */
PopupMenu.prototype.create = function(id, element) {

  var provider = this._providers[id];

  if (!provider) {
    throw new Error('Provider is not registered: ' + id);
  }

  if (!element) {
    throw new Error('Element is missing');
  }

  var current = this._current = {
    provider: provider,
    className: id,
    element: element
  };

  if (provider.getHeaderEntries) {
    current.headerEntries = provider.getHeaderEntries(element);
  }

  current.entries = provider.getEntries(element);

  return this;
};


/**
 * Determine if the popup menu has entries.
 *
 * @return {Boolean} true if empty
 */
PopupMenu.prototype.isEmpty = function() {

  var current = this._current;

  return current.entries.length === 0 && current.headerEntries && current.headerEntries.length === 0;
};


/**
 * Open popup menu at given position
 *
 * @param {Object} position
 *
 * @return {Object} popup menu instance
 */
PopupMenu.prototype.open = function(position) {

  if (!position) {
    throw new Error('the position argument is missing');
  }

  // make sure, only one popup menu is open at a time
  if (this.isOpen()) {
    this.close();
  }

  var current = this._current,
      canvas = this._canvas,
      parent = canvas.getContainer();

  current.position = position;

  current.container = this._createContainer();

  if (current.headerEntries) {
    var headerEntriesContainer = this._createEntries(current.headerEntries, 'djs-popup-header');

    current.container.appendChild(headerEntriesContainer);
  }

  if (current.entries) {
    var entriesContainer = this._createEntries(current.entries, 'djs-popup-body');

    current.container.appendChild(entriesContainer);
  }

  this._attachContainer(current.container, parent, position.cursor);

  return this;
};


/**
 * Removes the popup menu and unbinds the event handlers.
 */
PopupMenu.prototype.close = function() {

  if (!this.isOpen()) {
    return;
  }

  this._unbindHandlers();
  domRemove(this._current.container);
  this._current.container = null;
};


/**
 * Determine if an open popup menu exist.
 *
 * @return {Boolean} true if open
 */
PopupMenu.prototype.isOpen = function() {
  return !!this._current.container;
};


/**
 * Trigger an action associated with an entry.
 *
 * @param {Object} event
 *
 * @return the result of the action callback, if any
 */
PopupMenu.prototype.trigger = function(event) {

  // silence other actions
  event.preventDefault();

  var element = event.delegateTarget || event.target,
      entryId = domAttr(element, DATA_REF);

  var entry = this._getEntry(entryId);

  if (entry.action) {
    return entry.action.call(null, event, entry);
  }
};

/**
 * Gets an entry instance (either entry or headerEntry) by id.
 *
 * @param  {String} entryId
 *
 * @return {Object} entry instance
 */
PopupMenu.prototype._getEntry = function(entryId) {

  var search = { id: entryId };

  var entry = find(this._current.entries, search) || find(this._current.headerEntries, search);

  if (!entry) {
    throw new Error('entry not found');
  }

  return entry;
};


/**
 * Creates the popup menu container.
 *
 * @return {Object} a DOM container
 */
PopupMenu.prototype._createContainer = function() {
  var container = domify('<div class="djs-popup">'),
      position = this._current.position,
      className = this._current.className;

  assign(container.style, {
    position: 'absolute',
    left: position.x + 'px',
    top: position.y + 'px',
    visibility: 'hidden'
  });

  domClasses(container).add(className);

  return container;
};


/**
 * Attaches the container to the DOM and binds the event handlers.
 *
 * @param {Object} container
 * @param {Object} parent
 */
PopupMenu.prototype._attachContainer = function(container, parent, cursor) {
  var self = this;

   // Event handler
  domDelegate.bind(container, '.entry' ,'click', function(event) {
    self.trigger(event);
  });

  // apply canvas zoom level
  var zoom = this._canvas.zoom();

  container.style.transformOrigin = 'top left';
  container.style.transform = 'scale(' + zoom + ')';

  // Attach to DOM
  parent.appendChild(container);

  if (cursor) {
    this._assureIsInbounds(container, cursor);
  }

  // Add Handler
  this._bindHandlers();
};


/**
 * Make sure that the menu is always fully shown
 *
 * @method function
 *
 * @param  {Object} container
 * @param  {Position} cursor {x, y}
 */
PopupMenu.prototype._assureIsInbounds = function(container, cursor) {
  var canvas = this._canvas,
      clientRect = canvas._container.getBoundingClientRect();

  var containerX = container.offsetLeft,
      containerY = container.offsetTop,
      containerWidth = container.scrollWidth,
      containerHeight = container.scrollHeight,
      overAxis = {},
      left, top;

  var cursorPosition = {
    x: cursor.x - clientRect.left,
    y: cursor.y - clientRect.top
  };

  if (containerX + containerWidth > clientRect.width) {
    overAxis.x = true;
  }

  if (containerY + containerHeight > clientRect.height) {
    overAxis.y = true;
  }

  if (overAxis.x && overAxis.y) {
    left = cursorPosition.x - containerWidth + 'px';
    top = cursorPosition.y - containerHeight + 'px';
  } else if (overAxis.x) {
    left = cursorPosition.x - containerWidth + 'px';
    top = cursorPosition.y + 'px';
  } else if (overAxis.y && cursorPosition.y < containerHeight) {
    left = cursorPosition.x + 'px';
    top = 10 + 'px';
  } else if (overAxis.y) {
    left = cursorPosition.x + 'px';
    top = cursorPosition.y - containerHeight + 'px';
  }

  assign(container.style, { left: left, top: top }, { visibility: 'visible', 'z-index': 1000 });
};


/**
 * Creates a list of entries and returns them as a DOM container.
 *
 * @param {Array<Object>} entries an array of entry objects
 * @param {String} className the class name of the entry container
 *
 * @return {Object} a DOM container
 */
PopupMenu.prototype._createEntries = function(entries, className) {

  var entriesContainer = domify('<div>'),
      self = this;

  domClasses(entriesContainer).add(className);

  forEach(entries, function(entry) {
    var entryContainer = self._createEntry(entry, entriesContainer);
    entriesContainer.appendChild(entryContainer);
  });

  return entriesContainer;
};


/**
 * Creates a single entry and returns it as a DOM container.
 *
 * @param  {Object} entry
 *
 * @return {Object} a DOM container
 */
PopupMenu.prototype._createEntry = function(entry) {

  if (!entry.id) {
    throw new Error ('every entry must have the id property set');
  }

  var entryContainer = domify('<div>'),
      entryClasses = domClasses(entryContainer);

  entryClasses.add('entry');

  if (entry.className) {
    entryClasses.add(entry.className);
  }

  domAttr(entryContainer, DATA_REF, entry.id);

  if (entry.label) {
    var label = domify('<span>');
    label.textContent = entry.label;
    entryContainer.appendChild(label);
  }

  if (entry.imageUrl) {
    entryContainer.appendChild(domify('<img src="' + entry.imageUrl + '" />'));
  }

  if (entry.active === true) {
    entryClasses.add('active');
  }

  if (entry.disabled === true) {
    entryClasses.add('disabled');
  }

  if (entry.title) {
    entryContainer.title = entry.title;
  }

  return entryContainer;
};


/**
 * Binds the `close` method to 'contextPad.close' & 'canvas.viewbox.changed'.
 */
PopupMenu.prototype._bindHandlers = function() {

  var eventBus = this._eventBus,
      self = this;

  function close() {
    self.close();
  }

  eventBus.once('contextPad.close', close);
  eventBus.once('canvas.viewbox.changing', close);
  eventBus.once('commandStack.changed', close);
};


/**
 * Unbinds the `close` method to 'contextPad.close' & 'canvas.viewbox.changing'.
 */
PopupMenu.prototype._unbindHandlers = function() {

  var eventBus = this._eventBus,
      self = this;

  function close() {
    self.close();
  }

  eventBus.off('contextPad.close', close);
  eventBus.off('canvas.viewbox.changed', close);
  eventBus.off('commandStack.changed', close);
};

module.exports = PopupMenu;

},{"270":270,"271":271,"398":398,"410":410,"411":411,"414":414,"415":415,"419":419}],194:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: [ 'popupMenu' ],
  popupMenu: [ 'type', _dereq_(193) ]
};

},{"193":193}],195:[function(_dereq_,module,exports){
'use strict';


/**
 * Service that allow replacing of elements.
 *
 *
 * @class
 * @constructor
 */
function Replace(modeling) {

  this._modeling = modeling;
}

module.exports = Replace;

Replace.$inject = [ 'modeling' ];

/**
 * @param {Element} oldElement - Element to be replaced
 * @param {Object}  newElementData - Containing information about the new Element, for example height, width, type.
 * @param {Object}  options - Custom options that will be attached to the context. It can be used to inject data
 *                            that is needed in the command chain. For example it could be used in
 *                            eventbus.on('commandStack.shape.replace.postExecute') to change shape attributes after
 *                            shape creation.
 */
Replace.prototype.replaceElement = function(oldElement, newElementData, options) {

  var modeling = this._modeling;

  var newElement = null;

  if (oldElement.waypoints) {
    // TODO
    // modeling.replaceConnection
  } else {
    // set center of element for modeling API
    // if no new width / height is given use old elements size
    newElementData.x = Math.ceil(oldElement.x + (newElementData.width || oldElement.width) / 2);
    newElementData.y = Math.ceil(oldElement.y + (newElementData.height || oldElement.height) / 2);

    newElement = modeling.replaceShape(oldElement, newElementData, options);
  }

  return newElement;
};

},{}],196:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: [ 'replace' ],
  replace: [ 'type', _dereq_(195) ]
};

},{"195":195}],197:[function(_dereq_,module,exports){
'use strict';

var pick = _dereq_(404),
    assign = _dereq_(398);

var ResizeUtil = _dereq_(199);

var asTRBL = _dereq_(222).asTRBL,
    roundBounds = _dereq_(222).roundBounds;

var DEFAULT_MIN_WIDTH = 10;


/**
 * A component that provides resizing of shapes on the canvas.
 *
 * The following components are part of shape resize:
 *
 *  * adding resize handles,
 *  * creating a visual during resize
 *  * checking resize rules
 *  * committing a change once finished
 *
 *
 * ## Customizing
 *
 * It's possible to customize the resizing behaviour by intercepting 'resize.start'
 * and providing the following parameters through the 'context':
 *
 *   * minDimensions ({ width, height }): minimum shape dimensions
 *
 *   * childrenBoxPadding ({ left, top, bottom, right } || number):
 *     gap between the minimum bounding box and the container
 *
 * f.ex:
 *
 * ```javascript
 * eventBus.on('resize.start', 1500, function(event) {
 *   var context = event.context,
 *
 *  context.minDimensions = { width: 140, height: 120 };
 *
 *  // Passing general padding
 *  context.childrenBoxPadding = 30;
 *
 *  // Passing padding to a specific side
 *  context.childrenBoxPadding.left = 20;
 * });
 * ```
 */
function Resize(eventBus, rules, modeling, dragging) {

  this._dragging = dragging;
  this._rules = rules;

  var self = this;

  eventBus.on('resize.start', function(event) {

    var context = event.context,
        resizeConstraints = context.resizeConstraints,
        // evaluate minBounds for backwards compatibility
        minBounds = context.minBounds;

    if (resizeConstraints === undefined) {

      if (minBounds === undefined) {
        minBounds = self.computeMinResizeBox(context);
      }

      context.resizeConstraints = {
        min: asTRBL(minBounds)
      };
    }
  });

  eventBus.on('resize.move', function(event) {

    var context = event.context,
        shape = context.shape,
        direction = context.direction,
        resizeConstraints = context.resizeConstraints,
        delta,
        newBounds;

    delta = {
      x: event.dx,
      y: event.dy
    };

    context.delta = delta;

    newBounds = ResizeUtil.resizeBounds(shape, direction, delta);

    // ensure constraints during resize
    context.newBounds = ResizeUtil.ensureConstraints(newBounds, resizeConstraints);

    // update + cache executable state
    context.canExecute = self.canResize(context);
  });

  eventBus.on('resize.end', function(event) {
    var context = event.context,
        shape = context.shape,
        canExecute = context.canExecute,
        newBounds = context.newBounds;

    if (canExecute) {
      // ensure we have actual pixel values for new bounds
      // (important when zoom level was > 1 during move)
      newBounds = roundBounds(newBounds);

      // perform the actual resize
      modeling.resizeShape(shape, newBounds);
    }
  });
}


Resize.prototype.canResize = function(context) {
  var rules = this._rules;

  var ctx = pick(context, [ 'newBounds', 'shape', 'delta', 'direction' ]);

  return rules.allowed('shape.resize', ctx);
};

/**
 * Activate a resize operation
 *
 * You may specify additional contextual information and must specify a
 * resize direction during activation of the resize event.
 *
 * @param {MouseEvent} event
 * @param {djs.model.Shape} shape
 * @param {Object|String} contextOrDirection
 */
Resize.prototype.activate = function(event, shape, contextOrDirection) {
  var dragging = this._dragging,
      context,
      direction;

  if (typeof contextOrDirection === 'string') {
    contextOrDirection = {
      direction: contextOrDirection
    };
  }

  context = assign({ shape: shape }, contextOrDirection);

  direction = context.direction;

  if (!direction) {
    throw new Error('must provide a direction (nw|se|ne|sw)');
  }

  dragging.init(event, 'resize', {
    autoActivate: true,
    cursor: 'resize-' + (/nw|se/.test(direction) ? 'nwse' : 'nesw'),
    data: {
      shape: shape,
      context: context
    }
  });
};

Resize.prototype.computeMinResizeBox = function(context) {
  var shape = context.shape,
      direction = context.direction,
      minDimensions,
      childrenBounds;

  minDimensions = context.minDimensions || {
    width: DEFAULT_MIN_WIDTH,
    height: DEFAULT_MIN_WIDTH
  };

  // get children bounds
  childrenBounds = ResizeUtil.computeChildrenBBox(shape, context.childrenBoxPadding);

  // get correct minimum bounds from given resize direction
  // basically ensures that the minBounds is max(childrenBounds, minDimensions)
  return ResizeUtil.getMinResizeBounds(direction, shape, minDimensions, childrenBounds);
};


Resize.$inject = [ 'eventBus', 'rules', 'modeling', 'dragging' ];

module.exports = Resize;

},{"199":199,"222":222,"398":398,"404":404}],198:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var Snap = _dereq_(248);

var HANDLE_OFFSET = -2,
    HANDLE_SIZE  = 5,
    HANDLE_HIT_SIZE = 20;

var CLS_RESIZER   = 'djs-resizer';

var domEvent = _dereq_(416);

var isPrimaryButton = _dereq_(242).isPrimaryButton;

var asTRBL = _dereq_(222).asTRBL;


/**
 * This component is responsible for adding resize handles.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {Selection} selection
 * @param {Resize} resize
 * @param {ResizeVisuals} resizeVisuals
 */
function ResizeHandles(eventBus, canvas, selection, resize) {

  this._resize = resize;
  this._canvas = canvas;

  var self = this;

  eventBus.on('selection.changed', function(e) {
    var newSelection = e.newSelection;

    // remove old selection markers
    self.removeResizers();

    // add new selection markers ONLY if single selection
    if (newSelection.length === 1) {
      forEach(newSelection, self.addResizer, self);
    }
  });

  eventBus.on('shape.changed', function(e) {
    var shape = e.element;

    if (selection.isSelected(shape)) {
      self.removeResizers();

      self.addResizer(shape);
    }
  });
}


ResizeHandles.prototype.makeDraggable = function(element, gfx, direction) {
  var resize = this._resize;

  function startResize(event) {
    // only trigger on left mouse button
    if (isPrimaryButton(event)) {
      resize.activate(event, element, direction);
    }
  }

  domEvent.bind(gfx.node, 'mousedown', startResize);
  domEvent.bind(gfx.node, 'touchstart', startResize);
};


ResizeHandles.prototype._createResizer = function(element, x, y, rotation, direction) {
  var resizersParent = this._getResizersParent();

  var group = resizersParent.group()
                  .addClass(CLS_RESIZER)
                  .addClass(CLS_RESIZER + '-' + element.id)
                  .addClass(CLS_RESIZER + '-' + direction);

  var origin = -HANDLE_SIZE + HANDLE_OFFSET;

  // Create four drag indicators on the outline
  group.rect(origin, origin, HANDLE_SIZE, HANDLE_SIZE).addClass(CLS_RESIZER + '-visual');
  group.rect(origin, origin, HANDLE_HIT_SIZE, HANDLE_HIT_SIZE).addClass(CLS_RESIZER + '-hit');

  var matrix = new Snap.Matrix().translate(x, y).rotate(rotation, 0, 0);

  group.transform(matrix);

  return group;
};

ResizeHandles.prototype.createResizer = function(element, direction) {
  var resizer;

  var trbl = asTRBL(element);

  if (direction === 'nw') {
    resizer = this._createResizer(element, trbl.left, trbl.top, 0, direction);
  } else if (direction === 'ne') {
    resizer = this._createResizer(element, trbl.right, trbl.top, 90, direction);
  } else if (direction === 'se') {
    resizer = this._createResizer(element, trbl.right, trbl.bottom, 180, direction);
  } else {
    resizer = this._createResizer(element, trbl.left, trbl.bottom, 270, direction);
  }

  this.makeDraggable(element, resizer, direction);
};

// resize handles implementation ///////////////////////////////

/**
 * Add resizers for a given element.
 *
 * @param {djs.model.Shape} shape
 */
ResizeHandles.prototype.addResizer = function(shape) {
  var resize = this._resize;

  if (!resize.canResize({ shape: shape })) {
    return;
  }

  this.createResizer(shape, 'nw');
  this.createResizer(shape, 'ne');
  this.createResizer(shape, 'se');
  this.createResizer(shape, 'sw');
};

/**
 * Remove all resizers
 */
ResizeHandles.prototype.removeResizers = function() {

  var resizersParent = this._getResizersParent();

  var resizers = resizersParent.selectAll('.' + CLS_RESIZER);

  forEach(resizers, function(resizer) {
    resizer.remove();
  });
};

ResizeHandles.prototype._getResizersParent = function() {
  return this._canvas.getLayer('resizers');
};

ResizeHandles.$inject = [ 'eventBus', 'canvas', 'selection', 'resize' ];

module.exports = ResizeHandles;

},{"222":222,"242":242,"248":248,"271":271,"416":416}],199:[function(_dereq_,module,exports){
'use strict';

var filter = _dereq_(269);

var max = Math.max,
    min = Math.min;

var DEFAULT_CHILD_BOX_PADDING = 20;

var getBBox = _dereq_(235).getBBox;


var asTRBL = _dereq_(222).asTRBL,
    asBounds = _dereq_(222).asBounds;

function isNumber(a) {
  return typeof a === 'number';
}

/**
 * Substract a TRBL from another
 *
 * @param  {TRBL} trblA
 * @param  {TRBL} trblB
 *
 * @return {TRBL}
 */
module.exports.substractTRBL = function(trblA, trblB) {
  return {
    top: trblA.top - trblB.top,
    right: trblA.right - trblB.right,
    bottom: trblA.bottom - trblB.bottom,
    left: trblA.left - trblB.left
  };
};

/**
 * Resize the given bounds by the specified delta from a given anchor point.
 *
 * @param {Bounds} bounds the bounding box that should be resized
 * @param {String} direction in which the element is resized (nw, ne, se, sw)
 * @param {Point} delta of the resize operation
 *
 * @return {Bounds} resized bounding box
 */
module.exports.resizeBounds = function(bounds, direction, delta) {

  var dx = delta.x,
      dy = delta.y;

  switch (direction) {

  case 'nw':
    return {
      x: bounds.x + dx,
      y: bounds.y + dy,
      width: bounds.width - dx,
      height: bounds.height - dy
    };

  case 'sw':
    return {
      x: bounds.x + dx,
      y: bounds.y,
      width: bounds.width - dx,
      height: bounds.height + dy
    };

  case 'ne':
    return {
      x: bounds.x,
      y: bounds.y + dy,
      width: bounds.width + dx,
      height: bounds.height - dy
    };

  case 'se':
    return {
      x: bounds.x,
      y: bounds.y,
      width: bounds.width + dx,
      height: bounds.height + dy
    };

  default:
    throw new Error('unrecognized direction: ' + direction);
  }
};


/**
 * Resize the given bounds by applying the passed
 * { top, right, bottom, left } delta.
 *
 * @param {Bounds} bounds
 * @param {TRBL} trblResize
 *
 * @return {Bounds}
 */
module.exports.resizeTRBL = function(bounds, resize) {
  return {
    x: bounds.x + (resize.left || 0),
    y: bounds.y + (resize.top || 0),
    width: bounds.width - (resize.left || 0) + (resize.right || 0),
    height: bounds.height - (resize.top || 0) + (resize.bottom || 0)
  };
};


module.exports.reattachPoint = function(bounds, newBounds, point) {

  var sx = bounds.width / newBounds.width,
      sy = bounds.height / newBounds.height;

  return {
    x: Math.round((newBounds.x + newBounds.width / 2)) - Math.floor(((bounds.x + bounds.width / 2) - point.x) / sx),
    y: Math.round((newBounds.y + newBounds.height / 2)) - Math.floor(((bounds.y + bounds.height / 2) - point.y) / sy)
  };
};


function applyConstraints(attr, trbl, resizeConstraints) {

  var value = trbl[attr],
      minValue = resizeConstraints.min && resizeConstraints.min[attr],
      maxValue = resizeConstraints.max && resizeConstraints.max[attr];

  if (isNumber(minValue)) {
    value = (/top|left/.test(attr) ? min : max)(value, minValue);
  }

  if (isNumber(maxValue)) {
    value = (/top|left/.test(attr) ? max : min)(value, maxValue);
  }

  return value;
}

module.exports.ensureConstraints = function(currentBounds, resizeConstraints) {

  if (!resizeConstraints) {
    return currentBounds;
  }

  var currentTrbl = asTRBL(currentBounds);

  return asBounds({
    top: applyConstraints('top', currentTrbl, resizeConstraints),
    right: applyConstraints('right', currentTrbl, resizeConstraints),
    bottom: applyConstraints('bottom', currentTrbl, resizeConstraints),
    left: applyConstraints('left', currentTrbl, resizeConstraints)
  });
};


module.exports.getMinResizeBounds = function(direction, currentBounds, minDimensions, childrenBounds) {

  var currentBox = asTRBL(currentBounds);

  var minBox = {
    top: /n/.test(direction) ? currentBox.bottom - minDimensions.height : currentBox.top,
    left: /w/.test(direction) ? currentBox.right - minDimensions.width : currentBox.left,
    bottom: /s/.test(direction) ? currentBox.top + minDimensions.height : currentBox.bottom,
    right: /e/.test(direction) ? currentBox.left + minDimensions.width : currentBox.right
  };

  var childrenBox = childrenBounds ? asTRBL(childrenBounds) : minBox;

  var combinedBox = {
    top: min(minBox.top, childrenBox.top),
    left: min(minBox.left, childrenBox.left),
    bottom: max(minBox.bottom, childrenBox.bottom),
    right: max(minBox.right, childrenBox.right)
  };

  return asBounds(combinedBox);
};

function asPadding(mayBePadding, defaultValue) {
  if (typeof mayBePadding !== 'undefined') {
    return mayBePadding;
  } else {
    return DEFAULT_CHILD_BOX_PADDING;
  }
}

function addPadding(bbox, padding) {
  var left, right, top, bottom;

  if (typeof padding === 'object') {
    left = asPadding(padding.left);
    right = asPadding(padding.right);
    top = asPadding(padding.top);
    bottom = asPadding(padding.bottom);
  } else {
    left = right = top = bottom = asPadding(padding);
  }

  return {
    x: bbox.x - left,
    y: bbox.y - top,
    width: bbox.width + left + right,
    height: bbox.height + top + bottom
  };
}

module.exports.addPadding = addPadding;


/**
 * Is the given element part of the resize
 * targets min boundary box?
 *
 * This is the default implementation which excludes
 * connections and labels.
 *
 * @param {djs.model.Base} element
 */
function isBBoxChild(element) {

  // exclude connections
  if (element.waypoints) {
    return false;
  }

  // exclude labels
  if (element.type === 'label') {
    return false;
  }

  return true;
}

/**
 * Return children bounding computed from a shapes children
 * or a list of prefiltered children.
 *
 * @param  {djs.model.Shape|Array<djs.model.Shape>} shapeOrChildren
 * @param  {Number|Object} padding
 *
 * @return {Bounds}
 */
function computeChildrenBBox(shapeOrChildren, padding) {

  var elements;

  // compute based on shape
  if (shapeOrChildren.length === undefined) {
    // grab all the children that are part of the
    // parents children box
    elements = filter(shapeOrChildren.children, isBBoxChild);

  } else {
    elements = shapeOrChildren;
  }

  if (elements.length) {
    return addPadding(getBBox(elements), padding);
  }
}

module.exports.computeChildrenBBox = computeChildrenBBox;

},{"222":222,"235":235,"269":269}],200:[function(_dereq_,module,exports){
'use strict';

var Snap = _dereq_(248);

var MARKER_RESIZING = 'djs-resizing',
    MARKER_RESIZE_NOT_OK = 'resize-not-ok';

var LOW_PRIORITY = 500;


/**
 * This component is responsible for creating a visual during resize.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 */
function ResizeVisuals(eventBus, canvas) {

  this._canvas = canvas;

  var self = this;

  eventBus.on('resize.start', LOW_PRIORITY, function(event) {
    var context = event.context,
        shape = context.shape;

    // add resizable indicator
    canvas.addMarker(shape, MARKER_RESIZING);

    self.create(context);
  });


  eventBus.on('resize.move', LOW_PRIORITY, function(event) {
    var context = event.context;

    // update resize frame visuals
    self.update(context);
  });


  eventBus.on('resize.cleanup', function(event) {
    var context = event.context,
        shape = context.shape;

    // remove resizable indicator
    canvas.removeMarker(shape, MARKER_RESIZING);

    // remove frame + destroy context
    self.remove(context);
  });
}

/**
 * A helper that realizes the resize visuals
 */
ResizeVisuals.prototype.create = function(context) {
  var container = this._canvas.getDefaultLayer(),
      shape = context.shape,
      frame;

  frame = context.frame = Snap.create('rect', {
    class: 'djs-resize-overlay',
    width:  shape.width + 10,
    height: shape.height + 10,
    x: shape.x -5,
    y: shape.y -5
  });

  frame.appendTo(container);
};

ResizeVisuals.prototype.update = function(context) {
  var frame = context.frame,
      bounds = context.newBounds;

  if (bounds.width > 5) {
    frame.attr({
      x: bounds.x,
      width: bounds.width
    });
  }

  if (bounds.height > 5) {
    frame.attr({
      y: bounds.y,
      height: bounds.height
    });
  }

  frame[context.canExecute ? 'removeClass' : 'addClass'](MARKER_RESIZE_NOT_OK);
};

ResizeVisuals.prototype.remove = function(context) {
  if (context.frame) {
    context.frame.remove();
  }
};

ResizeVisuals.$inject = [ 'eventBus', 'canvas' ];

module.exports = ResizeVisuals;

},{"248":248}],201:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(204),
    _dereq_(142)
  ],
  __init__: [ 'resize', 'resizeVisuals', 'resizeHandles' ],
  resize: [ 'type', _dereq_(197) ],
  resizeVisuals: [ 'type', _dereq_(200) ],
  resizeHandles: [ 'type', _dereq_(198) ]
};

},{"142":142,"197":197,"198":198,"200":200,"204":204}],202:[function(_dereq_,module,exports){

'use strict';

var inherits = _dereq_(257);

var CommandInterceptor = _dereq_(102);

/**
 * A basic provider that may be extended to implement modeling rules.
 *
 * Extensions should implement the init method to actually add their custom
 * modeling checks. Checks may be added via the #addRule(action, fn) method.
 *
 * @param {EventBus} eventBus
 */
function RuleProvider(eventBus) {
  CommandInterceptor.call(this, eventBus);

  this.init();
}

RuleProvider.$inject = [ 'eventBus' ];

inherits(RuleProvider, CommandInterceptor);

module.exports = RuleProvider;


/**
 * Adds a modeling rule for the given action, implemented through
 * a callback function.
 *
 * The function will receive the modeling specific action context
 * to perform its check. It must return `false` to disallow the
 * action from happening or `true` to allow the action.
 *
 * A rule provider may pass over the evaluation to lower priority
 * rules by returning return nothing (or <code>undefined</code>).
 *
 * @example
 *
 * ResizableRules.prototype.init = function() {
 *
 *   \/**
 *    * Return `true`, `false` or nothing to denote
 *    * _allowed_, _not allowed_ and _continue evaluating_.
 *    *\/
 *   this.addRule('shape.resize', function(context) {
 *
 *     var shape = context.shape;
 *
 *     if (!context.newBounds) {
 *       // check general resizability
 *       if (!shape.resizable) {
 *         return false;
 *       }
 *
 *       // not returning anything (read: undefined)
 *       // will continue the evaluation of other rules
 *       // (with lower priority)
 *       return;
 *     } else {
 *       // element must have minimum size of 10*10 points
 *       return context.newBounds.width > 10 && context.newBounds.height > 10;
 *     }
 *   });
 * };
 *
 * @param {String|Array<String>} actions the identifier for the modeling action to check
 * @param {Number} [priority] the priority at which this rule is being applied
 * @param {Function} fn the callback function that performs the actual check
 */
RuleProvider.prototype.addRule = function(actions, priority, fn) {

  var self = this;

  if (typeof actions === 'string') {
    actions = [ actions ];
  }

  actions.forEach(function(action) {

    self.canExecute(action, priority, function(context, action, event) {
      return fn(context);
    }, true);
  });
};

/**
 * Implement this method to add new rules during provider initialization.
 */
RuleProvider.prototype.init = function() {};
},{"102":102,"257":257}],203:[function(_dereq_,module,exports){
'use strict';

/**
 * A service that provides rules for certain diagram actions.
 *
 * The default implementation will hook into the {@link CommandStack}
 * to perform the actual rule evaluation. Make sure to provide the
 * `commandStack` service with this module if you plan to use it.
 *
 * Together with this implementation you may use the {@link RuleProvider}
 * to implement your own rule checkers.
 *
 * This module is ment to be easily replaced, thus the tiny foot print.
 *
 * @param {Injector} injector
 */
function Rules(injector) {
  this._commandStack = injector.get('commandStack', false);
}

Rules.$inject = [ 'injector' ];

module.exports = Rules;


/**
 * Returns whether or not a given modeling action can be executed
 * in the specified context.
 *
 * This implementation will respond with allow unless anyone
 * objects.
 *
 * @param {String} action the action to be checked
 * @param {Object} [context] the context to check the action in
 *
 * @return {Boolean} returns true, false or null depending on whether the
 *                   operation is allowed, not allowed or should be ignored.
 */
Rules.prototype.allowed = function(action, context) {
  var allowed = true;

  var commandStack = this._commandStack;

  if (commandStack) {
    allowed = commandStack.canExecute(action, context);
  }

  // map undefined to true, i.e. no rules
  return allowed === undefined ? true : allowed;
};
},{}],204:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'rules' ],
  rules: [ 'type', _dereq_(203) ]
};

},{"203":203}],205:[function(_dereq_,module,exports){
'use strict';

var domClear = _dereq_(412),
    domDelegate = _dereq_(414),
    domQuery = _dereq_(418),
    domClasses = _dereq_(411),
    domAttr = _dereq_(410),
    domify = _dereq_(415);

var getBoundingBox = _dereq_(235).getBBox;


/**
 * Provides searching infrastructure
 */
function SearchPad(canvas, eventBus, overlays, selection) {
  this._open = false;
  this._results = [];
  this._eventMaps = [];

  this._canvas = canvas;
  this._eventBus = eventBus;
  this._overlays = overlays;
  this._selection = selection;

  // setup elements
  this._container = domify(SearchPad.BOX_HTML);
  this._searchInput = domQuery(SearchPad.INPUT_SELECTOR, this._container);
  this._resultsContainer = domQuery(SearchPad.RESULTS_CONTAINER_SELECTOR, this._container);

  // attach search pad
  this._canvas.getContainer().appendChild(this._container);

  // cleanup on destroy
  eventBus.on([ 'canvas.destroy', 'diagram.destroy' ], this.close, this);
}


SearchPad.$inject = [
  'canvas',
  'eventBus',
  'overlays',
  'selection'
];


/**
 * Binds and keeps track of all event listereners
 */
SearchPad.prototype._bindEvents = function() {
  var self = this;

  function listen(el, selector, type, fn) {
    self._eventMaps.push({
      el: el,
      type: type,
      listener: domDelegate.bind(el, selector, type, fn)
    });
  }

  // close search on clicking anywhere outside
  listen(document, 'html', 'click', function(e) {
    self.close();
  }, true);

  // stop event from propagating and closing search
  // focus on input
  listen(this._container, SearchPad.INPUT_SELECTOR, 'click', function(e) {
    e.stopPropagation();
    e.delegateTarget.focus();
  });

  // preselect result on hover
  listen(this._container, SearchPad.RESULT_SELECTOR, 'mouseover', function(e) {
    e.stopPropagation();
    self._scrollToNode(e.delegateTarget);
    self._preselect(e.delegateTarget);
  });

  // selects desired result on mouse click
  listen(this._container, SearchPad.RESULT_SELECTOR, 'click', function(e) {
    e.stopPropagation();
    self._select(e.delegateTarget);
  });

  // prevent cursor in input from going left and right when using up/down to
  // navigate results
  listen(this._container, SearchPad.INPUT_SELECTOR, 'keydown', function(e) {
    // up
    if (e.keyCode === 38) {
      e.preventDefault();
    }

    // down
    if (e.keyCode === 40) {
      e.preventDefault();
    }
  });

  // handle keyboard input
  listen(this._container, SearchPad.INPUT_SELECTOR, 'keyup', function(e) {
    // escape
    if (e.keyCode === 27) {
      return self.close();
    }

    // enter
    if (e.keyCode === 13) {
      var selected = self._getCurrentResult();

      return selected ? self._select(selected) : self.close();
    }

    // up
    if (e.keyCode === 38) {
      return self._scrollToDirection(true);
    }

    // down
    if (e.keyCode === 40) {
      return self._scrollToDirection();
    }

    // left && right
    // do not search while navigating text input
    if (e.keyCode === 37 || e.keyCode === 39) {
      return;
    }

    // anything else
    self._search(e.delegateTarget.value);
  });
};


/**
 * Unbinds all previously established listeners
 */
SearchPad.prototype._unbindEvents = function() {
  this._eventMaps.forEach(function(m) {
    domDelegate.unbind(m.el, m.type, m.listener);
  });
};


/**
 * Performs a search for the given pattern.
 *
 * @param  {String} pattern
 */
SearchPad.prototype._search = function(pattern) {
  var self = this;

  this._clearResults();

  // do not search on empty query
  if (!pattern || pattern === '') {
    return;
  }

  var searchResults = this._searchProvider.find(pattern);

  if (!searchResults.length) {
    return;
  }

  // append new results
  searchResults.forEach(function(result) {
    var id = result.element.id;
    var node = self._createResultNode(result, id);
    self._results[id] = {
      element: result.element,
      node: node
    };
  });

  // preselect first result
  var node = domQuery(SearchPad.RESULT_SELECTOR, this._resultsContainer);
  this._scrollToNode(node);
  this._preselect(node);
};


/**
 * Navigate to the previous/next result. Defaults to next result.
 * @param  {Boolean} previous
 */
SearchPad.prototype._scrollToDirection = function(previous) {
  var selected = this._getCurrentResult();
  if (!selected) {
    return;
  }

  var node = previous ? selected.previousElementSibling : selected.nextElementSibling;
  if (node) {
    this._scrollToNode(node);
    this._preselect(node);
  }
};


/**
 * Scroll to the node if it is not visible.
 *
 * @param  {Element} node
 */
SearchPad.prototype._scrollToNode = function(node) {
  if (!node || node === this._getCurrentResult()) {
    return;
  }

  var nodeOffset = node.offsetTop;
  var containerScroll = this._resultsContainer.scrollTop;

  var bottomScroll = nodeOffset - this._resultsContainer.clientHeight + node.clientHeight;

  if (nodeOffset < containerScroll) {
    this._resultsContainer.scrollTop = nodeOffset;
  } else if (containerScroll < bottomScroll) {
    this._resultsContainer.scrollTop = bottomScroll;
  }
};


/**
 * Clears all results data.
 */
SearchPad.prototype._clearResults = function() {
  domClear(this._resultsContainer);

  this._results = [];

  this._resetOverlay();

  this._eventBus.fire('searchPad.cleared');
};


/**
 * Get currently selected result.
 *
 * @return {Element}
 */
SearchPad.prototype._getCurrentResult = function() {
  return domQuery(SearchPad.RESULT_SELECTED_SELECTOR, this._resultsContainer);
};


/**
 * Create result DOM element within results container
 * that corresponds to a search result.
 *
 * 'result' : one of the elements returned by SearchProvider
 * 'id' : id attribute value to assign to the new DOM node
 * return : created DOM element
 *
 * @param  {SearchResult} result
 * @param  {String} id
 * @return {Element}
 */
SearchPad.prototype._createResultNode = function(result, id) {
  var node = domify(SearchPad.RESULT_HTML);

  // create only if available
  if (result.primaryTokens.length > 0) {
    createInnerTextNode(node, result.primaryTokens, SearchPad.RESULT_PRIMARY_HTML);
  }

  // secondary tokens (represent element ID) are allways available
  createInnerTextNode(node, result.secondaryTokens, SearchPad.RESULT_SECONDARY_HTML);

  domAttr(node, SearchPad.RESULT_ID_ATTRIBUTE, id);

  this._resultsContainer.appendChild(node);

  return node;
};


/**
 * Register search element provider.
 *
 * SearchProvider.find - provides search function over own elements
 *  (pattern) => [{ text: <String>, element: <Element>}, ...]
 *
 * @param  {SearchProvider} provider
 */
SearchPad.prototype.registerProvider = function(provider) {
  this._searchProvider = provider;
};


/**
 * Open search pad.
 */
SearchPad.prototype.open = function() {
  if (!this._searchProvider) {
    throw new Error('no search provider registered');
  }

  if (this.isOpen()) {
    return;
  }

  this._bindEvents();

  this._open = true;

  domClasses(this._container).add('open');

  this._searchInput.focus();

  this._eventBus.fire('searchPad.opened');
};


/**
 * Close search pad.
 */
SearchPad.prototype.close = function() {
  if (!this.isOpen()) {
    return;
  }

  this._unbindEvents();

  this._open = false;

  domClasses(this._container).remove('open');

  this._clearResults();

  this._searchInput.value = '';
  this._searchInput.blur();

  this._resetOverlay();

  this._eventBus.fire('searchPad.closed');
};


/**
 * Toggles search pad on/off.
 */
SearchPad.prototype.toggle = function() {
  this.isOpen() ? this.close() : this.open();
};


/**
 * Report state of search pad.
 */
SearchPad.prototype.isOpen = function() {
  return this._open;
};


/**
 * Preselect result entry.
 *
 * @param  {Element} element
 */
SearchPad.prototype._preselect = function(node) {
  var selectedNode = this._getCurrentResult();

  // already selected
  if (node === selectedNode) {
    return;
  }

  // removing preselection from current node
  if (selectedNode) {
    domClasses(selectedNode).remove(SearchPad.RESULT_SELECTED_CLASS);
  }

  var id = domAttr(node, SearchPad.RESULT_ID_ATTRIBUTE);
  var element = this._results[id].element;

  domClasses(node).add(SearchPad.RESULT_SELECTED_CLASS);

  this._resetOverlay(element);

  this._centerViewbox(element);

  this._selection.select(element);

  this._eventBus.fire('searchPad.preselected', element);
};


/**
 * Select result node.
 *
 * @param  {Element} element
 */
SearchPad.prototype._select = function(node) {
  var id = domAttr(node, SearchPad.RESULT_ID_ATTRIBUTE);
  var element = this._results[id].element;

  this.close();

  this._resetOverlay();

  this._centerViewbox(element);

  this._selection.select(element);

  this._eventBus.fire('searchPad.selected', element);
};


/**
 * Center viewbox on the element middle point.
 *
 * @param  {Element} element
 */
SearchPad.prototype._centerViewbox = function(element) {
  var viewbox = this._canvas.viewbox();

  var box = getBoundingBox(element);

  var newViewbox = {
    x: (box.x + box.width/2) - viewbox.outer.width/2,
    y: (box.y + box.height/2) - viewbox.outer.height/2,
    width: viewbox.outer.width,
    height: viewbox.outer.height
  };

  this._canvas.viewbox(newViewbox);

  this._canvas.zoom(viewbox.scale);
};


/**
 * Reset overlay removes and, optionally, set
 * overlay to a new element.
 *
 * @param  {Element} element
 */
SearchPad.prototype._resetOverlay = function(element) {
  if (this._overlayId) {
    this._overlays.remove(this._overlayId);
  }

  if (element) {
    var box = getBoundingBox(element);
    var overlay = constructOverlay(box);
    this._overlayId = this._overlays.add(element, overlay);
  }
};


module.exports = SearchPad;

/**
 * Construct overlay object for the given bounding box.
 *
 * @param  {BoundingBox} box
 * @return {Object}
 */
function constructOverlay(box) {

  var offset = 6;
  var w = box.width + offset * 2;
  var h = box.height + offset * 2;

  var styles = [
    'width: '+ w +'px',
    'height: '+ h + 'px'
  ].join('; ');

  return {
    position: {
      bottom: h - offset,
      right: w - offset
    },
    show: true,
    html: '<div style="' + styles + '" class="' + SearchPad.OVERLAY_CLASS + '"></div>'
  };
}


/**
 * Creates and appends child node from result tokens and HTML template.
 *
 * @param  {Element} node
 * @param  {Array<Object>} tokens
 * @param  {String} template
 */
function createInnerTextNode(parentNode, tokens, template) {
  var text = createHtmlText(tokens);
  var childNode = domify(template);
  childNode.innerHTML = text;
  parentNode.appendChild(childNode);
}

/**
 * Create internal HTML markup from result tokens.
 * Caters for highlighting pattern matched tokens.
 *
 * @param  {Array<Object>} tokens
 * @return {String}
 */
function createHtmlText(tokens) {
  var htmlText = '';

  tokens.forEach(function(t) {
    if (t.matched) {
      htmlText += '<strong class="' + SearchPad.RESULT_HIGHLIGHT_CLASS + '">' + t.matched + '</strong>';
    } else {
      htmlText += t.normal;
    }
  });

  return htmlText !== '' ? htmlText : null;
}


/**
 * CONSTANTS
 */
SearchPad.CONTAINER_SELECTOR = '.djs-search-container';
SearchPad.INPUT_SELECTOR = '.djs-search-input input';
SearchPad.RESULTS_CONTAINER_SELECTOR = '.djs-search-results';
SearchPad.RESULT_SELECTOR = '.djs-search-result';
SearchPad.RESULT_SELECTED_CLASS = 'djs-search-result-selected';
SearchPad.RESULT_SELECTED_SELECTOR = '.' + SearchPad.RESULT_SELECTED_CLASS;
SearchPad.RESULT_ID_ATTRIBUTE = 'data-result-id';
SearchPad.RESULT_HIGHLIGHT_CLASS = 'djs-search-highlight';
SearchPad.OVERLAY_CLASS = 'djs-search-overlay';

SearchPad.BOX_HTML =
  '<div class="djs-search-container djs-draggable djs-scrollable">' +
    '<div class="djs-search-input">' +
      '<input type="text"/>' +
    '</div>' +
    '<div class="djs-search-results"></div>' +
  '</div>';

SearchPad.RESULT_HTML =
  '<div class="djs-search-result"></div>';

SearchPad.RESULT_PRIMARY_HTML =
  '<div class="djs-search-result-primary"></div>';

SearchPad.RESULT_SECONDARY_HTML =
  '<p class="djs-search-result-secondary"></p>';

},{"235":235,"410":410,"411":411,"412":412,"414":414,"415":415,"418":418}],206:[function(_dereq_,module,exports){
module.exports = {
  __depends__: [
    _dereq_(190),
    _dereq_(210)
  ],
  searchPad: [ 'type', _dereq_(205) ]
};

},{"190":190,"205":205,"210":210}],207:[function(_dereq_,module,exports){
'use strict';

var isArray = _dereq_(389),
    forEach = _dereq_(271);


/**
 * A service that offers the current selection in a diagram.
 * Offers the api to control the selection, too.
 *
 * @class
 *
 * @param {EventBus} eventBus the event bus
 */
function Selection(eventBus) {

  this._eventBus = eventBus;

  this._selectedElements = [];

  var self = this;

  eventBus.on([ 'shape.remove', 'connection.remove' ], function(e) {
    var element = e.element;
    self.deselect(element);
  });

  eventBus.on([ 'diagram.clear' ], function(e) {
    self.select(null);
  });
}

Selection.$inject = [ 'eventBus' ];

module.exports = Selection;


Selection.prototype.deselect = function(element) {
  var selectedElements = this._selectedElements;

  var idx = selectedElements.indexOf(element);

  if (idx !== -1) {
    var oldSelection = selectedElements.slice();

    selectedElements.splice(idx, 1);

    this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });
  }
};


Selection.prototype.get = function() {
  return this._selectedElements;
};

Selection.prototype.isSelected = function(element) {
  return this._selectedElements.indexOf(element) !== -1;
};


/**
 * This method selects one or more elements on the diagram.
 *
 * By passing an additional add parameter you can decide whether or not the element(s)
 * should be added to the already existing selection or not.
 *
 * @method Selection#select
 *
 * @param  {Object|Object[]} elements element or array of elements to be selected
 * @param  {boolean} [add] whether the element(s) should be appended to the current selection, defaults to false
 */
Selection.prototype.select = function(elements, add) {
  var selectedElements = this._selectedElements,
      oldSelection = selectedElements.slice();

  if (!isArray(elements)) {
    elements = elements ? [ elements ] : [];
  }

  // selection may be cleared by passing an empty array or null
  // to the method
  if (add) {
    forEach(elements, function(element) {
      if (selectedElements.indexOf(element) !== -1) {
        // already selected
        return;
      } else {
        selectedElements.push(element);
      }
    });
  } else {
    this._selectedElements = selectedElements = elements.slice();
  }

  this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });
};

},{"271":271,"389":389}],208:[function(_dereq_,module,exports){
'use strict';

var hasPrimaryModifier = _dereq_(242).hasPrimaryModifier;

var find = _dereq_(270);


function SelectionBehavior(eventBus, selection, canvas, elementRegistry) {

  eventBus.on('create.end', 500, function(e) {

    // select the created shape after a
    // successful create operation
    if (e.context.canExecute) {
      selection.select(e.context.shape);
    }
  });

  eventBus.on('connect.end', 500, function(e) {

    // select the connect end target
    // after a connect operation
    if (e.context.canExecute && e.context.target) {
      selection.select(e.context.target);
    }
  });

  eventBus.on('shape.move.end', 500, function(e) {
    var previousSelection = e.previousSelection || [];

    var shape = elementRegistry.get(e.context.shape.id);

    // make sure at least the main moved element is being
    // selected after a move operation
    var inSelection = find(previousSelection, function(selectedShape) {
      return shape.id === selectedShape.id;
    });

    if (!inSelection) {
      selection.select(shape);
    }
  });

  // Shift + click selection
  eventBus.on('element.click', function(event) {

    var element = event.element;

    // do not select the root element
    // or connections
    if (element === canvas.getRootElement()) {
      element = null;
    }

    var isSelected = selection.isSelected(element),
        isMultiSelect = selection.get().length > 1;

    // mouse-event: SELECTION_KEY
    var add = hasPrimaryModifier(event);

    // select OR deselect element in multi selection
    if (isSelected && isMultiSelect) {
      if (add) {
        return selection.deselect(element);
      } else {
        return selection.select(element);
      }
    } else
    if (!isSelected) {
      selection.select(element, add);
    } else {
      selection.deselect(element);
    }
  });
}

SelectionBehavior.$inject = [ 'eventBus', 'selection', 'canvas', 'elementRegistry' ];
module.exports = SelectionBehavior;

},{"242":242,"270":270}],209:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var MARKER_HOVER = 'hover',
    MARKER_SELECTED = 'selected';


/**
 * A plugin that adds a visible selection UI to shapes and connections
 * by appending the <code>hover</code> and <code>selected</code> classes to them.
 *
 * @class
 *
 * Makes elements selectable, too.
 *
 * @param {EventBus} events
 * @param {SelectionService} selection
 * @param {Canvas} canvas
 */
function SelectionVisuals(events, canvas, selection, graphicsFactory, styles) {

  this._multiSelectionBox = null;

  function addMarker(e, cls) {
    canvas.addMarker(e, cls);
  }

  function removeMarker(e, cls) {
    canvas.removeMarker(e, cls);
  }

  events.on('element.hover', function(event) {
    addMarker(event.element, MARKER_HOVER);
  });

  events.on('element.out', function(event) {
    removeMarker(event.element, MARKER_HOVER);
  });

  events.on('selection.changed', function(event) {

    function deselect(s) {
      removeMarker(s, MARKER_SELECTED);
    }

    function select(s) {
      addMarker(s, MARKER_SELECTED);
    }

    var oldSelection = event.oldSelection,
        newSelection = event.newSelection;

    forEach(oldSelection, function(e) {
      if (newSelection.indexOf(e) === -1) {
        deselect(e);
      }
    });

    forEach(newSelection, function(e) {
      if (oldSelection.indexOf(e) === -1) {
        select(e);
      }
    });
  });
}

SelectionVisuals.$inject = [
  'eventBus',
  'canvas',
  'selection',
  'graphicsFactory',
  'styles'
];

module.exports = SelectionVisuals;

},{"271":271}],210:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'selectionVisuals', 'selectionBehavior' ],
  __depends__: [
    _dereq_(150),
    _dereq_(188)
  ],
  selection: [ 'type', _dereq_(207) ],
  selectionVisuals: [ 'type', _dereq_(209) ],
  selectionBehavior: [ 'type', _dereq_(208) ]
};

},{"150":150,"188":188,"207":207,"208":208,"209":209}],211:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var snapTo = _dereq_(212).snapTo;


/**
 * A snap context, containing the (possibly incomplete)
 * mappings of drop targets (to identify the snapping)
 * to computed snap points.
 */
function SnapContext() {

  /**
   * Map<String, SnapPoints> mapping drop targets to
   * a list of possible snappings.
   *
   * @type {Object}
   */
  this._targets = {};

  /**
   * Map<String, Point> initial positioning of element
   * regarding various snap directions.
   *
   * @type {Object}
   */
  this._snapOrigins = {};

  /**
   * List of snap locations
   *
   * @type {Array<String>}
   */
  this._snapLocations = [];

  /**
   * Map<String, Array<Point>> of default snapping locations
   *
   * @type {Object}
   */
  this._defaultSnaps = {};
}


SnapContext.prototype.getSnapOrigin = function(snapLocation) {
  return this._snapOrigins[snapLocation];
};


SnapContext.prototype.setSnapOrigin = function(snapLocation, initialValue) {
  this._snapOrigins[snapLocation] = initialValue;

  if (this._snapLocations.indexOf(snapLocation) === -1) {
    this._snapLocations.push(snapLocation);
  }
};


SnapContext.prototype.addDefaultSnap = function(type, point) {

  var snapValues = this._defaultSnaps[type];

  if (!snapValues) {
    snapValues = this._defaultSnaps[type] = [];
  }

  snapValues.push(point);
};

/**
 * Return a number of initialized snaps, i.e. snap locations such as
 * top-left, mid, bottom-right and so forth.
 *
 * @return {Array<String>} snapLocations
 */
SnapContext.prototype.getSnapLocations = function() {
  return this._snapLocations;
};

/**
 * Set the snap locations for this context.
 *
 * The order of locations determines precedence.
 *
 * @param {Array<String>} snapLocations
 */
SnapContext.prototype.setSnapLocations = function(snapLocations) {
  this._snapLocations = snapLocations;
};

/**
 * Get snap points for a given target
 *
 * @param {Element|String} target
 */
SnapContext.prototype.pointsForTarget = function(target) {

  var targetId = target.id || target;

  var snapPoints = this._targets[targetId];

  if (!snapPoints) {
    snapPoints = this._targets[targetId] = new SnapPoints();
    snapPoints.initDefaults(this._defaultSnaps);
  }

  return snapPoints;
};

module.exports = SnapContext;


/**
 * Creates the snap points and initializes them with the
 * given default values.
 *
 * @param {Object<String, Array<Point>>} [defaultPoints]
 */
function SnapPoints(defaultSnaps) {

  /**
   * Map<String, Map<(x|y), Array<Number>>> mapping snap locations,
   * i.e. top-left, bottom-right, center to actual snap values.
   *
   * @type {Object}
   */
  this._snapValues = {};
}

SnapPoints.prototype.add = function(snapLocation, point) {

  var snapValues = this._snapValues[snapLocation];

  if (!snapValues) {
    snapValues = this._snapValues[snapLocation] = { x: [], y: [] };
  }

  if (snapValues.x.indexOf(point.x) === -1) {
    snapValues.x.push(point.x);
  }

  if (snapValues.y.indexOf(point.y) === -1) {
    snapValues.y.push(point.y);
  }
};


SnapPoints.prototype.snap = function(point, snapLocation, axis, tolerance) {
  var snappingValues = this._snapValues[snapLocation];
  
  return snappingValues && snapTo(point[axis], snappingValues[axis], tolerance);
};

/**
 * Initialize a number of default snapping points.
 *
 * @param  {Object} defaultSnaps
 */
SnapPoints.prototype.initDefaults = function(defaultSnaps) {

  var self = this;

  forEach(defaultSnaps || {}, function(snapPoints, snapLocation) {
    forEach(snapPoints, function(point) {
      self.add(snapLocation, point);
    });
  });
};
},{"212":212,"271":271}],212:[function(_dereq_,module,exports){
'use strict';

var abs = Math.abs,
    round = Math.round;


/**
 * Snap value to a collection of reference values.
 *
 * @param  {Number} value
 * @param  {Array<Number>} values
 * @param  {Number} [tolerance=10]
 *
 * @return {Number} the value we snapped to or null, if none snapped
 */
function snapTo(value, values, tolerance) {
  tolerance = tolerance === undefined ? 10 : tolerance;

  var idx, snapValue;

  for (idx = 0; idx < values.length; idx++) {
    snapValue = values[idx];

    if (abs(snapValue - value) <= tolerance) {
      return snapValue;
    }
  }
}

module.exports.snapTo = snapTo;


function topLeft(bounds) {
  return {
    x: bounds.x,
    y: bounds.y
  };
}

module.exports.topLeft = topLeft;


function mid(bounds, defaultValue) {

  if (!bounds || isNaN(bounds.x) || isNaN(bounds.y)) {
    return defaultValue;
  }

  return {
    x: round(bounds.x + bounds.width / 2),
    y: round(bounds.y + bounds.height / 2)
  };
}

module.exports.mid = mid;


function bottomRight(bounds) {
  return {
    x: bounds.x + bounds.width,
    y: bounds.y + bounds.height
  };
}

module.exports.bottomRight = bottomRight;


/**
 * Retrieve the snap state of the given event.
 *
 * @param  {Event} event
 * @param  {String} axis
 *
 * @return {Boolean} the snapped state
 *
 */
module.exports.isSnapped = function(event, axis) {
  var snapped = event.snapped;

  if (!snapped) {
    return false;
  }

  if (typeof axis === 'string') {
    return snapped[axis];
  }

  return snapped.x && snapped.y;
};

/**
 * Set the given event as snapped.
 *
 * This method may change the x and/or y position of the shape
 * from the given event!
 *
 * @param {Event} event
 * @param {String} axis
 * @param {Number|Boolean} value
 *
 * @return {Number} old value
 */
module.exports.setSnapped = function(event, axis, value) {
  if (typeof axis !== 'string') {
    throw new Error('axis must be in [x, y]');
  }

  if (typeof value !== 'number' && value !== false) {
    throw new Error('value must be Number or false');
  }

  var delta,
      previousValue = event[axis];

  var snapped = event.snapped = (event.snapped || {});


  if (value === false) {
    snapped[axis] = false;
  } else {
    snapped[axis] = true;

    delta = value - previousValue;

    event[axis] += delta;
    event['d' + axis] += delta;
  }

  return previousValue;
};
},{}],213:[function(_dereq_,module,exports){
'use strict';

var filter = _dereq_(269),
    forEach = _dereq_(271),
    debounce = _dereq_(280);


var mid = _dereq_(212).mid;

var SnapContext = _dereq_(211);

var SnapUtil = _dereq_(212);

var HIGHER_PRIORITY = 1250;

var isSnapped = SnapUtil.isSnapped,
    setSnapped = SnapUtil.setSnapped;


/**
 * A general purpose snapping component for diagram elements.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 */
function Snapping(eventBus, canvas) {

  this._canvas = canvas;

  var self = this;

  eventBus.on([ 'shape.move.start', 'create.start' ], function(event) {
    self.initSnap(event);
  });

  eventBus.on([ 'shape.move.move', 'shape.move.end', 'create.move', 'create.end' ], HIGHER_PRIORITY, function(event) {

    if (event.originalEvent && event.originalEvent.ctrlKey) {
      return;
    }

    if (isSnapped(event)) {
      return;
    }

    self.snap(event);
  });

  eventBus.on([ 'shape.move.cleanup', 'create.cleanup' ], function(event) {
    self.hide();
  });

  // delay hide by 1000 seconds since last match
  this._asyncHide = debounce(this.hide, 1000);
}

Snapping.$inject = [ 'eventBus', 'canvas' ];

module.exports = Snapping;


Snapping.prototype.initSnap = function(event) {

  var context = event.context,
      shape = context.shape,
      snapContext = context.snapContext;

  if (!snapContext) {
    snapContext = context.snapContext = new SnapContext();
  }

  var snapMid = mid(shape, event);

  snapContext.setSnapOrigin('mid', {
    x: snapMid.x - event.x,
    y: snapMid.y - event.y
  });

  return snapContext;
};


Snapping.prototype.snap = function(event) {

  var context = event.context,
      snapContext = context.snapContext,
      shape = context.shape,
      target = context.target,
      snapLocations = snapContext.getSnapLocations();

  if (!target) {
    return;
  }

  var snapPoints = snapContext.pointsForTarget(target);

  if (!snapPoints.initialized) {
    this.addTargetSnaps(snapPoints, shape, target);

    snapPoints.initialized = true;
  }


  var snapping = {
    x: isSnapped(event, 'x'),
    y: isSnapped(event, 'y')
  };


  forEach(snapLocations, function(location) {

    var snapOrigin = snapContext.getSnapOrigin(location);

    var snapCurrent = {
      x: event.x + snapOrigin.x,
      y: event.y + snapOrigin.y
    };

    // snap on both axis, if not snapped already
    forEach([ 'x', 'y' ], function(axis) {
      var locationSnapping;

      if (!snapping[axis]) {
        locationSnapping = snapPoints.snap(snapCurrent, location, axis, 7);

        if (locationSnapping !== undefined) {
          snapping[axis] = {
            value: locationSnapping,
            originValue: locationSnapping - snapOrigin[axis]
          };
        }
      }
    });

    // no more need to snap, drop out of interation
    if (snapping.x && snapping.y) {
      return false;
    }
  });


  // show snap visuals

  this.showSnapLine('vertical', snapping.x && snapping.x.value);
  this.showSnapLine('horizontal', snapping.y && snapping.y.value);


  // adjust event { x, y, dx, dy } and mark as snapping
  forEach([ 'x', 'y' ], function(axis) {

    var axisSnapping = snapping[axis];

    if (typeof axisSnapping === 'object') {
      // set as snapped and adjust the x and/or y position of the event
      setSnapped(event, axis, axisSnapping.originValue);
    }
  });
};


Snapping.prototype._createLine = function(orientation) {

  var root = this._canvas.getLayer('snap');

  var line = root.path('M0,0 L0,0').addClass('djs-snap-line');

  return {
    update: function(position) {

      if (typeof position !== 'number') {
        line.attr({ display: 'none' });
      } else {
        if (orientation === 'horizontal') {
          line.attr({
            path: 'M-100000,' + position + ' L+100000,' + position,
            display: ''
          });
        } else {
          line.attr({
            path: 'M ' + position + ',-100000 L ' + position + ', +100000',
            display: ''
          });
        }
      }
    }
  };
};


Snapping.prototype._createSnapLines = function() {

  this._snapLines = {
    horizontal: this._createLine('horizontal'),
    vertical: this._createLine('vertical')
  };
};

Snapping.prototype.showSnapLine = function(orientation, position) {

  var line = this.getSnapLine(orientation);

  if (line) {
    line.update(position);
  }

  this._asyncHide();
};

Snapping.prototype.getSnapLine = function(orientation) {
  if (!this._snapLines) {
    this._createSnapLines();
  }

  return this._snapLines[orientation];
};

Snapping.prototype.hide = function() {
  forEach(this._snapLines, function(l) {
    l.update();
  });
};

Snapping.prototype.addTargetSnaps = function(snapPoints, shape, target) {

  var siblings = this.getSiblings(shape, target);

  forEach(siblings, function(s) {
    snapPoints.add('mid', mid(s));
  });

};

Snapping.prototype.getSiblings = function(element, target) {

  // snap to all non connection siblings
  return target && filter(target.children, function(e) {
    return !e.hidden && !e.labelTarget && !e.waypoints && e.host !== element && e !== element;
  });
};
},{"211":211,"212":212,"269":269,"271":271,"280":280}],214:[function(_dereq_,module,exports){
'use strict';

var SpaceUtil = _dereq_(216);

var Cursor = _dereq_(234);

var hasPrimaryModifier = _dereq_(242).hasPrimaryModifier;

var abs = Math.abs,
    round = Math.round;

var HIGH_PRIORITY = 1500,
    SPACE_TOOL_CURSOR = 'crosshair';

var AXIS_TO_DIMENSION = { x: 'width', y: 'height' },
    AXIS_INVERTED = { x: 'y', y: 'x' };

var getAllChildren = _dereq_(235).selfAndAllChildren;

var assign = _dereq_(398),
    forEach = _dereq_(271);


/**
 * A tool that allows users to create and remove space in a diagram.
 *
 * The tool needs to be activated manually via {@link SpaceTool#activate(MouseEvent)}.
 */
function SpaceTool(eventBus, dragging, canvas, modeling, rules, toolManager) {

  this._canvas = canvas;
  this._dragging = dragging;
  this._modeling = modeling;
  this._rules = rules;
  this._toolManager = toolManager;

  var self = this;

  toolManager.registerTool('space', {
    tool: 'spaceTool.selection',
    dragging: 'spaceTool'
  });

  eventBus.on('spaceTool.selection.end', function(event) {
    var target = event.originalEvent.target;

    // only reactive on diagram click
    // on some occasions, event.hover is not set and we have to check if the target is an svg
    if (!event.hover && !(target instanceof SVGElement)) {
      return;
    }

    eventBus.once('spaceTool.selection.ended', function() {
      self.activateMakeSpace(event.originalEvent);
    });
  });


  eventBus.on('spaceTool.move', HIGH_PRIORITY , function(event) {

    var context = event.context;

    if (!context.initialized) {
      context.initialized = self.initializeMakeSpace(event, context);
    }
  });


  eventBus.on('spaceTool.end', function(event) {

    var context = event.context,
        axis = context.axis,
        direction = context.direction,
        movingShapes = context.movingShapes,
        resizingShapes = context.resizingShapes;

    // skip if create space has not been initialized yet
    if (!context.initialized) {
      return;
    }

    var delta = { x: round(event.dx), y: round(event.dy) };
    delta[ AXIS_INVERTED[ axis ] ] = 0;

    var insideBounds = true;

    // check if the space tool cursor is inside of bounds of
    // any of the shapes that would be resized.
    forEach(resizingShapes, function(shape) {

      if ((direction === 'w' && event.x > shape.x + shape.width) ||
          (direction === 'e' && event.x < shape.x) ||
          (direction === 'n' && event.y > shape.y + shape.height) ||
          (direction === 's' && event.y < shape.y)) {

        insideBounds = false;
        return;
      }
    });

    if (insideBounds) {
      // make space only if the cursor is inside bounds
      self.makeSpace(movingShapes, resizingShapes, delta, direction);
    }

    eventBus.once('spaceTool.ended', function(event) {
      // reactivate space tool after usage
      self.activateSelection(event.originalEvent, true, true);
    });

  });
}

SpaceTool.$inject = [ 'eventBus', 'dragging', 'canvas', 'modeling', 'rules', 'toolManager' ];

module.exports = SpaceTool;


/**
 * Activate space tool selection
 *
 * @param  {MouseEvent} event
 * @param  {Boolean} autoActivate
 */
SpaceTool.prototype.activateSelection = function(event, autoActivate, reactivate) {
  this._dragging.init(event, 'spaceTool.selection', {
    trapClick: false,
    cursor: SPACE_TOOL_CURSOR,
    autoActivate: autoActivate,
    data: {
      context: {
        reactivate: reactivate
      }
    }
  });
};

/**
 * Activate make space
 *
 * @param  {MouseEvent} event
 */
SpaceTool.prototype.activateMakeSpace = function(event) {
  this._dragging.init(event, 'spaceTool', {
    autoActivate: true,
    cursor: SPACE_TOOL_CURSOR,
    data: {
      context: {}
    }
  });
};

/**
 * Actually make space on the diagram
 *
 * @param  {Array<djs.model.Shape>} movingShapes
 * @param  {Array<djs.model.Shape>} resizingShapes
 * @param  {Point} delta
 * @param  {String} direction
 */
SpaceTool.prototype.makeSpace = function(movingShapes, resizingShapes, delta, direction) {
  return this._modeling.createSpace(movingShapes, resizingShapes, delta, direction);
};

/**
 * Initialize make space and return true if that was successful.
 *
 * @param {Event} event
 * @param {Object} context
 *
 * @return {Boolean} true, if successful
 */
SpaceTool.prototype.initializeMakeSpace = function(event, context) {

  var axis = abs(event.dx) > abs(event.dy) ? 'x' : 'y',
      offset = event['d' + axis],
      // start point of create space operation
      spacePos = event[axis] - offset;

  if (abs(offset) < 5) {
    return false;
  }

  // invert the offset in order to remove space when moving left
  if (offset < 0) {
    offset *= -1;
  }

  // inverts the offset to choose the shapes
  // on the opposite side of the resizer if
  // a key modifier is pressed
  if (hasPrimaryModifier(event)) {
    offset *= -1;
  }

  var rootShape = this._canvas.getRootElement();

  var allShapes = getAllChildren(rootShape, true);

  var adjustments = this.calculateAdjustments(allShapes, axis, offset, spacePos);

  // store data in context
  assign(context, adjustments, {
    axis: axis,
    direction: SpaceUtil.getDirection(axis, offset)
  });

  Cursor.set('resize-' + (axis === 'x' ? 'ew' : 'ns'));

  return true;
};

/**
 * Calculate adjustments needed when making space
 *
 * @param  {Array<djs.model.Shape>} elements
 * @param  {String} axis
 * @param  {Number} offset
 * @param  {Number} spacePos
 *
 * @return {Object}
 */
SpaceTool.prototype.calculateAdjustments = function(elements, axis, offset, spacePos) {

  var movingShapes = [],
      resizingShapes = [];

  var rules = this._rules;

  // collect all elements that need to be moved _AND_
  // resized given on the initial create space position
  elements.forEach(function(shape) {

    var shapeStart = shape[axis],
        shapeEnd = shapeStart + shape[AXIS_TO_DIMENSION[axis]];

    // checking if it's root
    if (!shape.parent) {
      return;
    }

    // checking if it's a shape
    if (shape.waypoints) {
      return;
    }

    // shape after spacePos
    if (offset > 0 && shapeStart > spacePos) {
      return movingShapes.push(shape);
    }

    // shape before spacePos
    if (offset < 0 && shapeEnd < spacePos) {
      return movingShapes.push(shape);
    }

    // shape on top of spacePos, resize only if allowed
    if (shapeStart < spacePos &&
        shapeEnd > spacePos &&
        rules.allowed('shape.resize', { shape: shape })) {

      return resizingShapes.push(shape);
    }
  });

  return {
    movingShapes: movingShapes,
    resizingShapes: resizingShapes
  };
};

SpaceTool.prototype.toggle = function() {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.activateSelection();
  }
};

SpaceTool.prototype.isActive = function() {
  var context = this._dragging.context();

  return context && /^spaceTool/.test(context.prefix);
};

},{"216":216,"234":234,"235":235,"242":242,"271":271,"398":398}],215:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var MARKER_DRAGGING = 'djs-dragging';

var LOW_PRIORITY = 250;

/**
 * A plugin that makes shapes draggable / droppable.
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 * @param {Canvas} canvas
 * @param {Styles} styles
 */

function SpaceToolVisuals(eventBus, elementRegistry, canvas, styles) {

  function getGfx(e) {
    return elementRegistry.getGraphics(e);
  }

  function addDragger(shape, dragGroup) {
    var gfx = getGfx(shape);
    var dragger = gfx.clone();
    var bbox = gfx.getBBox();

    dragger.attr(styles.cls('djs-dragger', [], {
      x: bbox.x,
      y: bbox.y
    }));

    dragGroup.add(dragger);
  }

  eventBus.on('spaceTool.selection.start', function(event) {
    var space = canvas.getLayer('space'),
        context = event.context;

    var orientation = {
      x: 'M 0,-10000 L 0,10000',
      y: 'M -10000,0 L 10000,0'
    };

    var crosshairGroup = space.group().attr(styles.cls('djs-crosshair-group', [ 'no-events' ]));

    crosshairGroup.path(orientation.x).addClass('djs-crosshair');
    crosshairGroup.path(orientation.y).addClass('djs-crosshair');

    context.crosshairGroup = crosshairGroup;
  });

  eventBus.on('spaceTool.selection.move', function(event) {
    var crosshairGroup = event.context.crosshairGroup;

    crosshairGroup.translate(event.x, event.y);
  });

  eventBus.on('spaceTool.selection.cleanup', function(event) {
    var context = event.context,
        crosshairGroup = context.crosshairGroup;

    if (crosshairGroup) {
      crosshairGroup.remove();
    }
  });


  // assign a low priority to this handler
  // to let others modify the move context before
  // we draw things
  eventBus.on('spaceTool.move', LOW_PRIORITY, function(event) {
    /*
      TODO (Ricardo): extend connections while adding space
    */

    var context = event.context,
        line = context.line,
        axis = context.axis,
        dragShapes = context.movingShapes;

    if (!context.initialized) {
      return;
    }

    if (!context.dragGroup) {
      var spaceLayer = canvas.getLayer('space');
      line = spaceLayer.path('M0,0 L0,0').addClass('djs-crosshair');

      context.line  = line;
      var dragGroup = canvas.getDefaultLayer().group().attr(styles.cls('djs-drag-group', [ 'no-events' ]));


      forEach(dragShapes, function(shape) {
        addDragger(shape, dragGroup);
        canvas.addMarker(shape, MARKER_DRAGGING);
      });

      context.dragGroup = dragGroup;
    }

    var orientation = {
      x: 'M' + event.x + ', -10000 L' + event.x + ', 10000',
      y: 'M -10000, ' + event.y + ' L 10000, ' + event.y
    };

    line.attr({
      path: orientation[ axis ],
      display: ''
    });

    var opposite = { x: 'y', y: 'x' };
    var delta = { x: event.dx, y: event.dy };
    delta[ opposite[ context.axis ] ] = 0;

    context.dragGroup.translate(delta.x, delta.y);
  });

  eventBus.on('spaceTool.cleanup', function(event) {

    var context = event.context,
        shapes = context.movingShapes,
        line = context.line,
        dragGroup = context.dragGroup;

    // remove dragging marker
    forEach(shapes, function(e) {
      canvas.removeMarker(e, MARKER_DRAGGING);
    });

    if (dragGroup) {
      line.remove();
      dragGroup.remove();
    }
  });
}

SpaceToolVisuals.$inject = [ 'eventBus', 'elementRegistry', 'canvas', 'styles' ];

module.exports = SpaceToolVisuals;

},{"271":271}],216:[function(_dereq_,module,exports){
'use strict';

/**
 * Get Resize direction given axis + offset
 *
 * @param {String} axis (x|y)
 * @param {Number} offset
 *
 * @return {String} (e|w|n|s)
 */
function getDirection(axis, offset) {

  if (axis === 'x') {
    if (offset > 0) {
      return 'e';
    }

    if (offset < 0) {
      return 'w';
    }
  }

  if (axis === 'y') {
    if (offset > 0) {
      return 's';
    }

    if (offset < 0) {
      return 'n';
    }
  }

  return null;
}

module.exports.getDirection = getDirection;

/**
 * Resize the given bounds by the specified delta from a given anchor point.
 *
 * @param {Bounds} bounds the bounding box that should be resized
 * @param {String} direction in which the element is resized (n, s, e, w)
 * @param {Point} delta of the resize operation
 *
 * @return {Bounds} resized bounding box
 */
module.exports.resizeBounds = function(bounds, direction, delta) {

  var dx = delta.x,
      dy = delta.y;

  switch (direction) {

  case 'n':
    return {
      x: bounds.x,
      y: bounds.y + dy,
      width: bounds.width,
      height: bounds.height - dy
    };

  case 's':
    return {
      x: bounds.x,
      y: bounds.y,
      width: bounds.width,
      height: bounds.height + dy
    };

  case 'w':
    return {
      x: bounds.x + dx,
      y: bounds.y,
      width: bounds.width - dx,
      height: bounds.height
    };

  case 'e':
    return {
      x: bounds.x,
      y: bounds.y,
      width: bounds.width + dx,
      height: bounds.height
    };

  default:
    throw new Error('unrecognized direction: ' + direction);
  }
};
},{}],217:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['spaceToolVisuals'],
  __depends__: [
    _dereq_(142),
    _dereq_(204),
    _dereq_(219)
  ],
  spaceTool: ['type', _dereq_(214)],
  spaceToolVisuals: ['type', _dereq_(215) ]
};

},{"142":142,"204":204,"214":214,"215":215,"219":219}],218:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

var LOW_PRIORITY = 250;

/**
 * The tool manager acts as middle-man between the available tool's and the Palette,
 * it takes care of making sure that the correct active state is set.
 *
 * @param  {Object}    eventBus
 * @param  {Object}    dragging
 */
function ToolManager(eventBus, dragging) {
  this._eventBus = eventBus;
  this._dragging = dragging;

  this._tools = [];
  this._active = null;
}

ToolManager.$inject = [ 'eventBus', 'dragging' ];

module.exports = ToolManager;

ToolManager.prototype.registerTool = function(name, events) {
  var tools = this._tools;

  if (!events) {
    throw new Error('A tool has to be registered with it\'s "events"');
  }

  tools.push(name);

  this.bindEvents(name, events);
};

ToolManager.prototype.isActive = function(tool) {
  return tool && this._active === tool;
};

ToolManager.prototype.length = function(tool) {
  return this._tools.length;
};

ToolManager.prototype.setActive = function(tool) {
  var eventBus = this._eventBus;

  if (this._active !== tool) {
    this._active = tool;

    eventBus.fire('tool-manager.update', { tool: tool });
  }
};

ToolManager.prototype.bindEvents = function(name, events) {
  var eventBus = this._eventBus,
      dragging = this._dragging;

  var eventsToRegister = [];

  eventBus.on(events.tool + '.init', function(event) {
    var context = event.context;

    // Active tools that want to reactivate themselves must do this explicitly
    if (!context.reactivate && this.isActive(name)) {
      this.setActive(null);

      dragging.cancel();
      return;
    }

    this.setActive(name);

  }, this);

  // Todo[ricardo]: add test cases
  forEach(events, function(event) {
    eventsToRegister.push(event + '.ended');
    eventsToRegister.push(event + '.canceled');
  });

  eventBus.on(eventsToRegister, LOW_PRIORITY, function(event) {
    var originalEvent = event.originalEvent;

    // We defer the de-activation of the tool to the .activate phase,
    // so we're able to check if we want to toggle off the current active tool or switch to a new one
    if (!this._active ||
        (originalEvent && originalEvent.target.parentElement.getAttribute('data-group') === 'tools')) {
      return;
    }

    this.setActive(null);
  }, this);
};

},{"271":271}],219:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [ _dereq_(142) ],
  __init__: [ 'toolManager' ],
  toolManager: [ 'type', _dereq_(218) ]
};

},{"142":142,"218":218}],220:[function(_dereq_,module,exports){
'use strict';

var getMid = _dereq_(222).getMid;


/**
 * A base connection layouter implementation
 * that layouts the connection by directly connecting
 * mid(source) + mid(target).
 */
function BaseLayouter() {}

module.exports = BaseLayouter;


/**
 * Return the new layouted waypoints for the given connection.
 *
 * The connection passed is still unchanged; you may figure out about
 * the new connection start / end via the layout hints provided.
 *
 * @param {djs.model.Connection} connection
 * @param {Object} [hints]
 * @param {Point} [hints.connectionStart]
 * @param {Point} [hints.connectionEnd]
 *
 * @return {Array<Point>} the layouted connection waypoints
 */
BaseLayouter.prototype.layoutConnection = function(connection, hints) {

  hints = hints || {};

  return [
    hints.connectionStart || getMid(connection.source),
    hints.connectionEnd || getMid(connection.target)
  ];
};

},{"222":222}],221:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398);

var LayoutUtil = _dereq_(222);


function dockingToPoint(docking) {
  // use the dockings actual point and
  // retain the original docking
  return assign({ original: docking.point.original || docking.point }, docking.actual);
}


/**
 * A {@link ConnectionDocking} that crops connection waypoints based on
 * the path(s) of the connection source and target.
 *
 * @param {djs.core.ElementRegistry} elementRegistry
 */
function CroppingConnectionDocking(elementRegistry, graphicsFactory) {
  this._elementRegistry = elementRegistry;
  this._graphicsFactory = graphicsFactory;
}

CroppingConnectionDocking.$inject = [ 'elementRegistry', 'graphicsFactory' ];

module.exports = CroppingConnectionDocking;


/**
 * @inheritDoc ConnectionDocking#getCroppedWaypoints
 */
CroppingConnectionDocking.prototype.getCroppedWaypoints = function(connection, source, target) {

  source = source || connection.source;
  target = target || connection.target;

  var sourceDocking = this.getDockingPoint(connection, source, true),
      targetDocking = this.getDockingPoint(connection, target);

  var croppedWaypoints = connection.waypoints.slice(sourceDocking.idx + 1, targetDocking.idx);

  croppedWaypoints.unshift(dockingToPoint(sourceDocking));
  croppedWaypoints.push(dockingToPoint(targetDocking));

  return croppedWaypoints;
};

/**
 * Return the connection docking point on the specified shape
 *
 * @inheritDoc ConnectionDocking#getDockingPoint
 */
CroppingConnectionDocking.prototype.getDockingPoint = function(connection, shape, dockStart) {

  var waypoints = connection.waypoints,
      dockingIdx,
      dockingPoint,
      croppedPoint;

  dockingIdx = dockStart ? 0 : waypoints.length - 1;
  dockingPoint = waypoints[dockingIdx];

  croppedPoint = this._getIntersection(shape, connection, dockStart);

  return {
    point: dockingPoint,
    actual: croppedPoint || dockingPoint,
    idx: dockingIdx
  };
};


////// helper methods ///////////////////////////////////////////////////

CroppingConnectionDocking.prototype._getIntersection = function(shape, connection, takeFirst) {

  var shapePath = this._getShapePath(shape),
      connectionPath = this._getConnectionPath(connection);

  return LayoutUtil.getElementLineIntersection(shapePath, connectionPath, takeFirst);
};

CroppingConnectionDocking.prototype._getConnectionPath = function(connection) {
  return this._graphicsFactory.getConnectionPath(connection);
};

CroppingConnectionDocking.prototype._getShapePath = function(shape) {
  return this._graphicsFactory.getShapePath(shape);
};

CroppingConnectionDocking.prototype._getGfx = function(element) {
  return this._elementRegistry.getGraphics(element);
};

},{"222":222,"398":398}],222:[function(_dereq_,module,exports){
'use strict';

var isObject = _dereq_(393),
    sortBy = _dereq_(277),
    pointDistance = _dereq_(237).pointDistance;

var Snap = _dereq_(248);


function roundBounds(bounds) {
  return {
    x: Math.round(bounds.x),
    y: Math.round(bounds.y),
    width: Math.round(bounds.width),
    height: Math.round(bounds.height)
  };
}

module.exports.roundBounds = roundBounds;


function roundPoint(point) {

  return {
    x: Math.round(point.x),
    y: Math.round(point.y)
  };
}

module.exports.roundPoint = roundPoint;


/**
 * Convert the given bounds to a { top, left, bottom, right } descriptor.
 *
 * @param {Bounds|Point} bounds
 *
 * @return {Object}
 */
function asTRBL(bounds) {
  return {
    top: bounds.y,
    right: bounds.x + (bounds.width || 0),
    bottom: bounds.y + (bounds.height || 0),
    left: bounds.x
  };
}

module.exports.asTRBL = asTRBL;

/**
 * Convert a { top, left, bottom, right } to an objects bounds.
 *
 * @param {Object} trbl
 *
 * @return {Bounds}
 */
function asBounds(trbl) {
  return {
    x: trbl.left,
    y: trbl.top,
    width: trbl.right - trbl.left,
    height: trbl.bottom - trbl.top
  };
}

module.exports.asBounds = asBounds;


/**
 * Get the mid of the given bounds or point.
 *
 * @param {Bounds|Point} bounds
 *
 * @return {Point}
 */
function getMid(bounds) {
  return roundPoint({
    x: bounds.x + (bounds.width || 0) / 2,
    y: bounds.y + (bounds.height || 0) / 2
  });
}

module.exports.getMid = getMid;


////// orientation utils //////////////////////////////

/**
 * Get orientation of the given rectangle with respect to
 * the reference rectangle.
 *
 * A padding (positive or negative) may be passed to influence
 * horizontal / vertical orientation and intersection.
 *
 * @param {Bounds} rect
 * @param {Bounds} reference
 * @param {Point|Number} padding
 *
 * @return {String} the orientation; one of top, top-left, left, ..., bottom, right or intersect.
 */
function getOrientation(rect, reference, padding) {

  padding = padding || 0;

  // make sure we can use an object, too
  // for individual { x, y } padding
  if (!isObject(padding)) {
    padding = { x: padding, y: padding };
  }


  var rectOrientation = asTRBL(rect),
      referenceOrientation = asTRBL(reference);

  var top = rectOrientation.bottom + padding.y <= referenceOrientation.top,
      right = rectOrientation.left - padding.x >= referenceOrientation.right,
      bottom = rectOrientation.top - padding.y >= referenceOrientation.bottom,
      left = rectOrientation.right + padding.x <= referenceOrientation.left;

  var vertical = top ? 'top' : (bottom ? 'bottom' : null),
      horizontal = left ? 'left' : (right ? 'right' : null);

  if (horizontal && vertical) {
    return vertical + '-' + horizontal;
  } else {
    return horizontal || vertical || 'intersect';
  }
}

module.exports.getOrientation = getOrientation;


////// intersection utils //////////////////////////////

/**
 * Get intersection between an element and a line path.
 *
 * @param {PathDef} elementPath
 * @param {PathDef} linePath
 * @param {Boolean} cropStart crop from start or end
 *
 * @return {Point}
 */
function getElementLineIntersection(elementPath, linePath, cropStart) {

  var intersections = getIntersections(elementPath, linePath);

  // recognize intersections
  // only one -> choose
  // two close together -> choose first
  // two or more distinct -> pull out appropriate one
  // none -> ok (fallback to point itself)
  if (intersections.length === 1) {
    return roundPoint(intersections[0]);
  } else if (intersections.length === 2 && pointDistance(intersections[0], intersections[1]) < 1) {
    return roundPoint(intersections[0]);
  } else if (intersections.length > 1) {

    // sort by intersections based on connection segment +
    // distance from start
    intersections = sortBy(intersections, function(i) {
      var distance = Math.floor(i.t2 * 100) || 1;

      distance = 100 - distance;

      distance = (distance < 10 ? '0' : '') + distance;

      // create a sort string that makes sure we sort
      // line segment ASC + line segment position DESC (for cropStart)
      // line segment ASC + line segment position ASC (for cropEnd)
      return i.segment2 + '#' + distance;
    });

    return roundPoint(intersections[cropStart ? 0 : intersections.length - 1]);
  }

  return null;
}

module.exports.getElementLineIntersection = getElementLineIntersection;


function getIntersections(a, b) {
  return Snap.path.intersection(a, b);
}

module.exports.getIntersections = getIntersections;

},{"237":237,"248":248,"277":277,"393":393}],223:[function(_dereq_,module,exports){
'use strict';

var isArray = _dereq_(389),
    find = _dereq_(270),
    without = _dereq_(265),
    assign = _dereq_(398);

var LayoutUtil = _dereq_(222),
    Geometry = _dereq_(237);

var getOrientation = LayoutUtil.getOrientation,
    getMid = LayoutUtil.getMid,
    pointsAligned = Geometry.pointsAligned;

var pointInRect = Geometry.pointInRect,
    pointDistance = Geometry.pointDistance;

var INTERSECTION_THRESHOLD = 20,
    ORIENTATION_THRESHOLD = {
      'h:h': 20,
      'v:v': 20,
      'h:v': -10,
      'v:h': -10
    };


/**
 * Returns the mid points for a manhattan connection between two points.
 *
 * @example
 *
 * [a]----[x]
 *         |
 *        [x]----[b]
 *
 * @example
 *
 * [a]----[x]
 *         |
 *        [b]
 *
 * @param  {Point} a
 * @param  {Point} b
 * @param  {String} directions
 *
 * @return {Array<Point>}
 */
module.exports.getBendpoints = function(a, b, directions) {

  directions = directions || 'h:h';

  var xmid, ymid;

  // one point, next to a
  if (directions === 'h:v') {
    return [ { x: b.x, y: a.y } ];
  } else
  // one point, above a
  if (directions === 'v:h') {
    return [ { x: a.x, y: b.y } ];
  } else
  // vertical edge xmid
  if (directions === 'h:h') {
    xmid = Math.round((b.x - a.x) / 2 + a.x);

    return [
      { x: xmid, y: a.y },
      { x: xmid, y: b.y }
    ];
  } else
  // horizontal edge ymid
  if (directions === 'v:v') {
    ymid = Math.round((b.y - a.y) / 2 + a.y);

    return [
      { x: a.x, y: ymid },
      { x: b.x, y: ymid }
    ];
  } else {
    throw new Error(
      'unknown directions: <' + directions + '>: ' +
      'directions must be specified as {a direction}:{b direction} (direction in h|v)');
  }
};


/**
 * Create a connection between the two points according
 * to the manhattan layout (only horizontal and vertical) edges.
 *
 * @param {Point} a
 * @param {Point} b
 *
 * @param {String} [directions='h:h'] specifies manhattan directions for each point as {adirection}:{bdirection}.
                   A directionfor a point is either `h` (horizontal) or `v` (vertical)
 *
 * @return {Array<Point>}
 */
module.exports.connectPoints = function(a, b, directions) {

  var points = [];

  if (!pointsAligned(a, b)) {
    points = this.getBendpoints(a, b, directions);
  }

  points.unshift(a);
  points.push(b);

  return points;
};


/**
 * Connect two rectangles using a manhattan layouted connection.
 *
 * @param {Bounds} source source rectangle
 * @param {Bounds} target target rectangle
 * @param {Point} [start] source docking
 * @param {Point} [end] target docking
 *
 * @param {Object} [hints]
 * @param {String} [hints.preserveDocking=source] preserve docking on selected side
 * @param {Array<String>} [hints.preferredLayouts]
 * @param {Point|Boolean} [hints.connectionStart] whether the start changed
 * @param {Point|Boolean} [hints.connectionEnd] whether the end changed
 *
 * @return {Array<Point>} connection points
 */
module.exports.connectRectangles = function(source, target, start, end, hints) {

  var preferredLayouts = hints && hints.preferredLayouts || [];

  var preferredLayout = without(preferredLayouts, 'straight')[0] || 'h:h';

  var threshold = ORIENTATION_THRESHOLD[preferredLayout] || 0;

  var orientation = getOrientation(source, target, threshold);

  var directions = getDirections(orientation, preferredLayout);

  start = start || getMid(source);
  end = end || getMid(target);

  // overlapping elements
  if (!directions) {
    return;
  }

  if (directions === 'h:h') {

    switch (orientation) {
    case 'top-right':
    case 'right':
    case 'bottom-right':
      start = { original: start, x: source.x, y: start.y };
      end = { original: end, x: target.x + target.width, y: end.y };
      break;
    case 'top-left':
    case 'left':
    case 'bottom-left':
      start = { original: start, x: source.x + source.width, y: start.y };
      end = { original: end, x: target.x, y: end.y };
      break;
    }
  }

  if (directions === 'v:v') {

    switch (orientation) {
    case 'top-left':
    case 'top':
    case 'top-right':
      start = { original: start, x: start.x, y: source.y + source.height };
      end = { original: end, x: end.x, y: target.y };
      break;
    case 'bottom-left':
    case 'bottom':
    case 'bottom-right':
      start = { original: start, x: start.x, y: source.y };
      end = { original: end, x: end.x, y: target.y + target.height };
      break;
    }
  }

  return this.connectPoints(start, end, directions);
};

/**
 * Repair the connection between two rectangles, of which one has been updated.
 *
 * @param {Bounds} source
 * @param {Bounds} target
 * @param {Point} [start]
 * @param {Point} [end]
 * @param {Array<Point>} waypoints
 * @param {Object} [hints]
 * @param {Array<String>} [hints.preferredLayouts] list of preferred layouts
 * @param {Boolean} [hints.connectionStart]
 * @param {Boolean} [hints.connectionEnd]
 *
 * @return {Array<Point>} repaired waypoints
 */
module.exports.repairConnection = function(source, target, start, end, waypoints, hints) {

  if (isArray(start)) {
    waypoints = start;
    hints = end;

    start = getMid(source);
    end = getMid(target);
  }

  hints = assign({ preferredLayouts: [] }, hints);
  waypoints = waypoints || [];

  var preferredLayouts = hints.preferredLayouts,
      layoutStraight = preferredLayouts.indexOf('straight') !== -1,
      repairedWaypoints;

  // just layout non-existing or simple connections
  // attempt to render straight lines, if required

  if (layoutStraight) {
    // attempt to layout a straight line
    repairedWaypoints = this.layoutStraight(source, target, start, end, hints);
  }

  if (!repairedWaypoints) {
    // check if we layout from start or end
    if (hints.connectionEnd) {
      repairedWaypoints = this._repairConnectionSide(target, source, end, waypoints.slice().reverse());
      repairedWaypoints = repairedWaypoints && repairedWaypoints.reverse();
    } else
    if (hints.connectionStart) {
      repairedWaypoints = this._repairConnectionSide(source, target, start, waypoints);
    } else
    // or whether nothing seems to have changed
    if (waypoints && waypoints.length) {
      repairedWaypoints = waypoints;
    }
  }

  // simply reconnect if nothing else worked
  if (!repairedWaypoints) {
    repairedWaypoints = this.connectRectangles(source, target, start, end, hints);
  }

  return repairedWaypoints;
};


function inRange(a, start, end) {
  return a >= start && a <= end;
}

function isInRange(axis, a, b) {
  var size = {
    x: 'width',
    y: 'height'
  };

  return inRange(a[axis], b[axis], b[axis] + b[size[axis]]);
}

/**
 * Layout a straight connection
 *
 * @param {Bounds} source
 * @param {Bounds} target
 * @param {Point} start
 * @param {Point} end
 * @param {Object} [hints]
 *
 * @return {Array<Point>} waypoints if straight layout worked
 */
module.exports.layoutStraight = function(source, target, start, end, hints) {
  var axis = {},
      primaryAxis,
      orientation;

  orientation = getOrientation(source, target);

  // We're only interested in layouting a straight connection
  // if the shapes are horizontally or vertically aligned
  if (!/^(top|bottom|left|right)$/.test(orientation)) {
    return null;
  }

  if (/top|bottom/.test(orientation)) {
    primaryAxis = 'x';
  }

  if (/left|right/.test(orientation)) {
    primaryAxis = 'y';
  }

  if (hints.preserveDocking === 'target') {

    if (!isInRange(primaryAxis, end, source)) {
      return null;
    }

    axis[primaryAxis] = end[primaryAxis];

    return [
      {
        x: axis.x !== undefined ? axis.x : start.x,
        y: axis.y !== undefined ? axis.y : start.y,
        original: {
          x: axis.x !== undefined ? axis.x : start.x,
          y: axis.y !== undefined ? axis.y : start.y
        }
      },
      {
        x: end.x,
        y: end.y
      }
    ];

  } else {

    if (!isInRange(primaryAxis, start, target)) {
      return null;
    }

    axis[primaryAxis] = start[primaryAxis];

    return [
      {
        x: start.x,
        y: start.y
      },
      {
        x: axis.x !== undefined ? axis.x : end.x,
        y: axis.y !== undefined ? axis.y : end.y,
        original: {
          x: axis.x !== undefined ? axis.x : end.x,
          y: axis.y !== undefined ? axis.y : end.y
        }
      }
    ];
  }

};

/**
 * Repair a connection from one side that moved.
 *
 * @param {Bounds} moved
 * @param {Bounds} other
 * @param {Point} newDocking
 * @param {Array<Point>} points originalPoints from moved to other
 *
 * @return {Array<Point>} the repaired points between the two rectangles
 */
module.exports._repairConnectionSide = function(moved, other, newDocking, points) {

  function needsRelayout(moved, other, points) {

    if (points.length < 3) {
      return true;
    }

    if (points.length > 4) {
      return false;
    }

    // relayout if two points overlap
    // this is most likely due to
    return !!find(points, function(p, idx) {
      var q = points[idx - 1];

      return q && pointDistance(p, q) < 3;
    });
  }

  function repairBendpoint(candidate, oldPeer, newPeer) {

    var alignment = pointsAligned(oldPeer, candidate);

    switch (alignment) {
    case 'v':
        // repair vertical alignment
      return { x: candidate.x, y: newPeer.y };
    case 'h':
        // repair horizontal alignment
      return { x: newPeer.x, y: candidate.y };
    }

    return { x: candidate.x, y: candidate. y };
  }

  function removeOverlapping(points, a, b) {
    var i;

    for (i = points.length - 2; i !== 0; i--) {

      // intersects (?) break, remove all bendpoints up to this one and relayout
      if (pointInRect(points[i], a, INTERSECTION_THRESHOLD) ||
          pointInRect(points[i], b, INTERSECTION_THRESHOLD)) {

        // return sliced old connection
        return points.slice(i);
      }
    }

    return points;
  }


  // (0) only repair what has layoutable bendpoints

  // (1) if only one bendpoint and on shape moved onto other shapes axis
  //     (horizontally / vertically), relayout

  if (needsRelayout(moved, other, points)) {
    return null;
  }

  var oldDocking = points[0],
      newPoints = points.slice(),
      slicedPoints;

  // (2) repair only last line segment and only if it was layouted before

  newPoints[0] = newDocking;
  newPoints[1] = repairBendpoint(newPoints[1], oldDocking, newDocking);


  // (3) if shape intersects with any bendpoint after repair,
  //     remove all segments up to this bendpoint and repair from there

  slicedPoints = removeOverlapping(newPoints, moved, other);

  if (slicedPoints !== newPoints) {
    return this._repairConnectionSide(moved, other, newDocking, slicedPoints);
  }

  return newPoints;
};

/**
 * Returns the manhattan directions connecting two rectangles
 * with the given orientation.
 *
 * @example
 *
 * getDirections('top'); // -> 'v:v'
 *
 * getDirections('top-right', 'v:h'); // -> 'v:h'
 * getDirections('top-right', 'h:h'); // -> 'h:h'
 *
 *
 * @param {String} orientation
 * @param {String} defaultLayout
 *
 * @return {String}
 */
function getDirections(orientation, defaultLayout) {

  switch (orientation) {
  case 'intersect':
    return null;

  case 'top':
  case 'bottom':
    return 'v:v';

  case 'left':
  case 'right':
    return 'h:h';

    // 'top-left'
    // 'top-right'
    // 'bottom-left'
    // 'bottom-right'
  default:
    return defaultLayout;
  }
}

},{"222":222,"237":237,"265":265,"270":270,"389":389,"398":398}],224:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(398),
    inherits = _dereq_(257);

var Refs = _dereq_(432);

var parentRefs = new Refs({ name: 'children', enumerable: true, collection: true }, { name: 'parent' }),
    labelRefs = new Refs({ name: 'label', enumerable: true }, { name: 'labelTarget' }),
    attacherRefs = new Refs({ name: 'attachers', collection: true }, { name: 'host' }),
    outgoingRefs = new Refs({ name: 'outgoing', collection: true }, { name: 'source' }),
    incomingRefs = new Refs({ name: 'incoming', collection: true }, { name: 'target' });

/**
 * @namespace djs.model
 */

/**
 * @memberOf djs.model
 */

/**
 * The basic graphical representation
 *
 * @class
 *
 * @abstract
 */
function Base() {

  /**
   * The object that backs up the shape
   *
   * @name Base#businessObject
   * @type Object
   */
  Object.defineProperty(this, 'businessObject', {
    writable: true
  });

  /**
   * The parent shape
   *
   * @name Base#parent
   * @type Shape
   */
  parentRefs.bind(this, 'parent');

  /**
   * @name Base#label
   * @type Label
   */
  labelRefs.bind(this, 'label');

  /**
   * The list of outgoing connections
   *
   * @name Base#outgoing
   * @type Array<Connection>
   */
  outgoingRefs.bind(this, 'outgoing');

  /**
   * The list of incoming connections
   *
   * @name Base#incoming
   * @type Array<Connection>
   */
  incomingRefs.bind(this, 'incoming');
}


/**
 * A graphical object
 *
 * @class
 * @constructor
 *
 * @extends Base
 */
function Shape() {
  Base.call(this);

  /**
   * The list of children
   *
   * @name Shape#children
   * @type Array<Base>
   */
  parentRefs.bind(this, 'children');

  /**
   * @name Shape#host
   * @type Shape
   */
  attacherRefs.bind(this, 'host');

  /**
   * @name Shape#attachers
   * @type Shape
   */
  attacherRefs.bind(this, 'attachers');
}

inherits(Shape, Base);


/**
 * A root graphical object
 *
 * @class
 * @constructor
 *
 * @extends Shape
 */
function Root() {
  Shape.call(this);
}

inherits(Root, Shape);


/**
 * A label for an element
 *
 * @class
 * @constructor
 *
 * @extends Shape
 */
function Label() {
  Shape.call(this);

  /**
   * The labeled element
   *
   * @name Label#labelTarget
   * @type Base
   */
  labelRefs.bind(this, 'labelTarget');
}

inherits(Label, Shape);


/**
 * A connection between two elements
 *
 * @class
 * @constructor
 *
 * @extends Base
 */
function Connection() {
  Base.call(this);

  /**
   * The element this connection originates from
   *
   * @name Connection#source
   * @type Base
   */
  outgoingRefs.bind(this, 'source');

  /**
   * The element this connection points to
   *
   * @name Connection#target
   * @type Base
   */
  incomingRefs.bind(this, 'target');
}

inherits(Connection, Base);


var types = {
  connection: Connection,
  shape: Shape,
  label: Label,
  root: Root
};

/**
 * Creates a new model element of the specified type
 *
 * @method create
 *
 * @example
 *
 * var shape1 = Model.create('shape', { x: 10, y: 10, width: 100, height: 100 });
 * var shape2 = Model.create('shape', { x: 210, y: 210, width: 100, height: 100 });
 *
 * var connection = Model.create('connection', { waypoints: [ { x: 110, y: 55 }, {x: 210, y: 55 } ] });
 *
 * @param  {String} type lower-cased model name
 * @param  {Object} attrs attributes to initialize the new model instance with
 *
 * @return {Base} the new model instance
 */
module.exports.create = function(type, attrs) {
  var Type = types[type];
  if (!Type) {
    throw new Error('unknown type: <' + type + '>');
  }
  return assign(new Type(), attrs);
};


module.exports.Base = Base;
module.exports.Root = Root;
module.exports.Shape = Shape;
module.exports.Connection = Connection;
module.exports.Label = Label;

},{"257":257,"398":398,"432":432}],225:[function(_dereq_,module,exports){
'use strict';

var Cursor = _dereq_(234),
    ClickTrap = _dereq_(231),
    substract = _dereq_(241).substract,
    domEvent = _dereq_(416),
    domClosest = _dereq_(413),
    EventUtil = _dereq_(236);


function length(point) {
  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));
}


var THRESHOLD = 15;


function MoveCanvas(eventBus, canvas) {

  var container = canvas._container,
      context;


  function handleMove(event) {

    var start = context.start,
        position = EventUtil.toPoint(event),
        delta = substract(position, start);

    if (!context.dragging && length(delta) > THRESHOLD) {
      context.dragging = true;

      // prevent mouse click in this
      // interaction sequence
      ClickTrap.install();

      Cursor.set('grab');
    }

    if (context.dragging) {

      var lastPosition = context.last || context.start;

      delta = substract(position, lastPosition);

      canvas.scroll({
        dx: delta.x,
        dy: delta.y
      });

      context.last = position;
    }

    // prevent select
    event.preventDefault();
  }


  function handleEnd(event) {
    domEvent.unbind(document, 'mousemove', handleMove);
    domEvent.unbind(document, 'mouseup', handleEnd);

    context = null;

    Cursor.unset();

    // prevent select
    EventUtil.stopEvent(event);
  }

  function handleStart(event) {
    // event is already handled by '.djs-draggable'
    if (domClosest(event.target, '.djs-draggable')) {
      return;
    }


    // reject non-left left mouse button or modifier key
    if (event.button || event.ctrlKey || event.shiftKey || event.altKey) {
      return;
    }

    context = {
      start: EventUtil.toPoint(event)
    };

    domEvent.bind(document, 'mousemove', handleMove);
    domEvent.bind(document, 'mouseup', handleEnd);

    // prevent select
    EventUtil.stopEvent(event);
  }

  domEvent.bind(container, 'mousedown', handleStart);
}


MoveCanvas.$inject = [ 'eventBus', 'canvas' ];

module.exports = MoveCanvas;

},{"231":231,"234":234,"236":236,"241":241,"413":413,"416":416}],226:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'moveCanvas' ],
  moveCanvas: [ 'type', _dereq_(225) ]
};
},{"225":225}],227:[function(_dereq_,module,exports){
'use strict';

var domEvent = _dereq_(416),
    domClosest = _dereq_(413);

var hasPrimaryModifier = _dereq_(242).hasPrimaryModifier,
    hasSecondaryModifier = _dereq_(242).hasSecondaryModifier;

var isMac = _dereq_(243).isMac;

var getStepRange = _dereq_(228).getStepRange,
    cap = _dereq_(228).cap;

var log10 = _dereq_(241).log10;

var bind = _dereq_(279);

var RANGE = { min: 0.2, max: 4 },
    NUM_STEPS = 10;


/**
 * An implementation of zooming and scrolling within the
 * {@link Canvas} via the mouse wheel.
 *
 * Mouse wheel zooming / scrolling may be disabled using
 * the {@link toggle(enabled)} method.
 *
 * Additionally users can define the initial enabled state
 * by passing `{ zoomScroll: { enabled: false } }` at diagram
 * initialization.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {Object} config
 */
function ZoomScroll(eventBus, canvas, config) {

  this._enabled = false;

  this._canvas = canvas;
  this._container = canvas._container;

  this._handleWheel = bind(this._handleWheel, this);

  var newEnabled = !config || config.enabled !== false;

  var self = this;

  eventBus.on('canvas.init', function(e) {
    self._init(newEnabled);
  });
}

ZoomScroll.$inject = [ 'eventBus', 'canvas', 'config.zoomScroll' ];

module.exports = ZoomScroll;

ZoomScroll.prototype.scroll = function scroll(delta) {
  this._canvas.scroll(delta);
};


ZoomScroll.prototype.reset = function reset() {
  this._canvas.zoom('fit-viewport');
};


ZoomScroll.prototype.zoom = function zoom(direction, position) {
  var canvas = this._canvas;
  var currentZoom = canvas.zoom(false);

  var factor = Math.pow(1 + Math.abs(direction) , direction > 0 ? 1 : -1);

  canvas.zoom(cap(RANGE, currentZoom * factor), position);
};


ZoomScroll.prototype._handleWheel = function handleWheel(event) {
  // event is already handled by '.djs-scrollable'
  if (domClosest(event.target, '.djs-scrollable', true)) {
    return;
  }

  var element = this._container;

  event.preventDefault();

  // mouse-event: SELECTION_KEY
  // mouse-event: AND_KEY
  var isVerticalScroll = hasPrimaryModifier(event),
      isHorizontalScroll = hasSecondaryModifier(event);

  var factor;

  if (isVerticalScroll || isHorizontalScroll) {

    if (isMac) {
      factor = event.deltaMode === 0 ? 1.25 : 50;
    } else {
      factor = event.deltaMode === 0 ? 1/40 : 1/2;
    }

    var delta = {};

    if (isHorizontalScroll) {
      delta.dx = (factor * (event.deltaX || event.deltaY));
    } else {
      delta.dy = (factor * event.deltaY);
    }
    this.scroll(delta);
  } else {
    factor = (event.deltaMode === 0 ? 1/40 : 1/2);

    var elementRect = element.getBoundingClientRect();

    var offset =  {
      x: event.clientX - elementRect.left,
      y: event.clientY - elementRect.top
    };

    // zoom in relative to diagram {x,y} coordinates
    this.zoom(event.deltaY * factor / (-5), offset);
  }
};

/**
 * Zoom along fixed zoom steps
 *
 * @param {Integer} direction zoom direction (1 for zooming in, -1 for out)
 */
ZoomScroll.prototype.stepZoom = function stepZoom(direction, position) {

  var canvas = this._canvas,
      stepRange = getStepRange(RANGE, NUM_STEPS);

  direction = direction > 0 ? 1 : -1;

  var currentLinearZoomLevel = log10(canvas.zoom());

  // snap to a proximate zoom step
  var newLinearZoomLevel = Math.round(currentLinearZoomLevel / stepRange) * stepRange;

  // increase or decrease one zoom step in the given direction
  newLinearZoomLevel += stepRange * direction;

  // calculate the absolute logarithmic zoom level based on the linear zoom level
  // (e.g. 2 for an absolute x2 zoom)
  var newLogZoomLevel = Math.pow(10, newLinearZoomLevel);

  canvas.zoom(cap(RANGE, newLogZoomLevel), position);
};


/**
 * Toggle the zoom scroll ability via mouse wheel.
 *
 * @param  {Boolean} [newEnabled] new enabled state
 */
ZoomScroll.prototype.toggle = function toggle(newEnabled) {

  var element = this._container;
  var handleWheel = this._handleWheel;

  var oldEnabled = this._enabled;

  if (typeof newEnabled === 'undefined') {
    newEnabled = !oldEnabled;
  }

  // only react on actual changes
  if (oldEnabled !== newEnabled) {

    // add or remove wheel listener based on
    // changed enabled state
    domEvent[newEnabled ? 'bind' : 'unbind'](element, 'wheel', handleWheel, false);
  }

  this._enabled = newEnabled;

  return newEnabled;
};


ZoomScroll.prototype._init = function(newEnabled) {
  this.toggle(newEnabled);
};

},{"228":228,"241":241,"242":242,"243":243,"279":279,"413":413,"416":416}],228:[function(_dereq_,module,exports){
'use strict';


var log10 = _dereq_(241).log10;

/**
 * Get the linear range between two zoom steps based on the
 * total number of zoom steps (defined as NUM_STEPS)
 */
module.exports.getStepRange = function(range, steps) {

  var minLinearRange = log10(range.min),
      maxLinearRange = log10(range.max);

  var absoluteLinearRange = Math.abs(minLinearRange) + Math.abs(maxLinearRange);

  return absoluteLinearRange / steps;
};

module.exports.cap = function(range, scale) {
  return Math.max(range.min, Math.min(range.max, scale));
};

},{"241":241}],229:[function(_dereq_,module,exports){
module.exports = {
  __init__: [ 'zoomScroll' ],
  zoomScroll: [ 'type', _dereq_(227) ]
};
},{"227":227}],230:[function(_dereq_,module,exports){
'use strict';

var roundPoint = _dereq_(222).roundPoint;

var center = _dereq_(244).center,
    delta = _dereq_(244).delta;


/**
 * Calculates the absolute point relative to the new element's position
 *
 * @param {point} point [absolute]
 * @param {bounds} oldBounds
 * @param {bounds} newBounds
 *
 * @return {point} point [absolute]
 */
function getNewAttachPoint(point, oldBounds, newBounds) {
  var oldCenter = center(oldBounds),
      newCenter = center(newBounds),
      oldDelta = delta(point, oldCenter);

  var newDelta = {
    x: oldDelta.x * (newBounds.width / oldBounds.width),
    y: oldDelta.y * (newBounds.height / oldBounds.height)
  };

  return roundPoint({
    x: newCenter.x + newDelta.x,
    y: newCenter.y + newDelta.y
  });
}

module.exports.getNewAttachPoint = getNewAttachPoint;


/**
 * Calculates the shape's delta relative to a new position
 * of a certain element's bounds
 *
 * @param {djs.model.Shape} point [absolute]
 * @param {bounds} oldBounds
 * @param {bounds} newBounds
 *
 * @return {delta} delta
 */
function getNewAttachShapeDelta(shape, oldBounds, newBounds) {
  var shapeCenter = center(shape),
      oldCenter = center(oldBounds),
      newCenter = center(newBounds),
      shapeDelta = delta(shape, shapeCenter),
      oldCenterDelta = delta(shapeCenter, oldCenter);

  var newCenterDelta = {
    x: oldCenterDelta.x * (newBounds.width / oldBounds.width),
    y: oldCenterDelta.y * (newBounds.height / oldBounds.height)
  };

  var newShapeCenter = {
    x: newCenter.x + newCenterDelta.x,
    y: newCenter.y + newCenterDelta.y
  };

  return roundPoint({
    x: newShapeCenter.x + shapeDelta.x - shape.x,
    y: newShapeCenter.y + shapeDelta.y - shape.y
  });
}

module.exports.getNewAttachShapeDelta = getNewAttachShapeDelta;

},{"222":222,"244":244}],231:[function(_dereq_,module,exports){
'use strict';

var domEvent = _dereq_(416),
    stopEvent = _dereq_(236).stopEvent;

function trap(event) {
  stopEvent(event);

  toggle(false);
}

function toggle(active) {
  domEvent[active ? 'bind' : 'unbind'](document.body, 'click', trap, true);
}

/**
 * Installs a click trap that prevents a ghost click following a dragging operation.
 *
 * @return {Function} a function to immediately remove the installed trap.
 */
function install() {

  toggle(true);

  return function() {
    toggle(false);
  };
}

module.exports.install = install;
},{"236":236,"416":416}],232:[function(_dereq_,module,exports){
'use strict';

/**
 * Failsafe remove an element from a collection
 *
 * @param  {Array<Object>} [collection]
 * @param  {Object} [element]
 *
 * @return {Number} the previous index of the element
 */
module.exports.remove = function(collection, element) {

  if (!collection || !element) {
    return -1;
  }

  var idx = collection.indexOf(element);

  if (idx !== -1) {
    collection.splice(idx, 1);
  }

  return idx;
};

/**
 * Fail save add an element to the given connection, ensuring
 * it does not yet exist.
 *
 * @param {Array<Object>} collection
 * @param {Object} element
 * @param {Number} idx
 */
module.exports.add = function(collection, element, idx) {

  if (!collection || !element) {
    return;
  }

  if (typeof idx !== 'number') {
    idx = -1;
  }

  var currentIdx = collection.indexOf(element);

  if (currentIdx !== -1) {

    if (currentIdx === idx) {
      // nothing to do, position has not changed
      return;
    } else {

      if (idx !== -1) {
        // remove from current position
        collection.splice(currentIdx, 1);
      } else {
        // already exists in collection
        return;
      }
    }
  }

  if (idx !== -1) {
    // insert at specified position
    collection.splice(idx, 0, element);
  } else {
    // push to end
    collection.push(element);
  }
};


/**
 * Fail save get the index of an element in a collection.
 *
 * @param {Array<Object>} collection
 * @param {Object} element
 *
 * @return {Number} the index or -1 if collection or element do
 *                  not exist or the element is not contained.
 */
module.exports.indexOf = function(collection, element) {

  if (!collection || !element) {
    return -1;
  }

  return collection.indexOf(element);
};

},{}],233:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(271);

function getTopLevel(elements) {
  var topLevel = {},
      parents = [],
      result = [],
      clearedParents = [];

  forEach(elements, function(element) {
    var parent = element.parent;

    if (!topLevel[parent.id]) {
      topLevel[parent.id] = [];
    }

    if (parents.indexOf(parent.id) === -1) {
      parents.push(parent.id);
    }

    topLevel[parent.id].push(element);
  });

  forEach(parents, function(parent) {
    forEach(topLevel[parent], function(element) {
      if (topLevel[element.id]) {
        clearedParents.push(element.id);
      }
    });
  });

  forEach(parents, function(parent) {
    var idx = clearedParents.indexOf(parent);

    if (idx === -1) {
      result = result.concat(topLevel[parent]);
    }
  });

  return result;
}

module.exports.getTopLevel = getTopLevel;

},{"271":271}],234:[function(_dereq_,module,exports){
'use strict';

var domClasses = _dereq_(411);

var CURSOR_CLS_PATTERN = /^djs-cursor-.*$/;


module.exports.set = function(mode) {
  var classes = domClasses(document.body);

  classes.removeMatching(CURSOR_CLS_PATTERN);

  if (mode) {
    classes.add('djs-cursor-' + mode);
  }
};

module.exports.unset = function() {
  this.set(null);
};

module.exports.has = function(mode) {
  var classes = domClasses(document.body);

  return classes.has('djs-cursor-' + mode);
};

},{"411":411}],235:[function(_dereq_,module,exports){
'use strict';

var isArray = _dereq_(389),
    isNumber = _dereq_(392),
    groupBy = _dereq_(272),
    forEach = _dereq_(271);

/**
 * Adds an element to a collection and returns true if the
 * element was added.
 *
 * @param {Array<Object>} elements
 * @param {Object} e
 * @param {Boolean} unique
 */
function add(elements, e, unique) {
  var canAdd = !unique || elements.indexOf(e) === -1;

  if (canAdd) {
    elements.push(e);
  }

  return canAdd;
}

/**
 * Iterate over each element in a collection, calling the iterator function `fn`
 * with (element, index, recursionDepth).
 *
 * Recurse into all elements that are returned by `fn`.
 *
 * @param  {Object|Array<Object>} elements
 * @param  {Function} fn iterator function called with (element, index, recursionDepth)
 * @param  {Number} [depth] maximum recursion depth
 */
function eachElement(elements, fn, depth) {

  depth = depth || 0;

  if (!isArray(elements)) {
    elements = [ elements ];
  }

  forEach(elements, function(s, i) {
    var filter = fn(s, i, depth);

    if (isArray(filter) && filter.length) {
      eachElement(filter, fn, depth + 1);
    }
  });
}

/**
 * Collects self + child elements up to a given depth from a list of elements.
 *
 * @param  {djs.model.Base|Array<djs.model.Base>} elements the elements to select the children from
 * @param  {Boolean} unique whether to return a unique result set (no duplicates)
 * @param  {Number} maxDepth the depth to search through or -1 for infinite
 *
 * @return {Array<djs.model.Base>} found elements
 */
function selfAndChildren(elements, unique, maxDepth) {
  var result = [],
      processedChildren = [];

  eachElement(elements, function(element, i, depth) {
    add(result, element, unique);

    var children = element.children;

    // max traversal depth not reached yet
    if (maxDepth === -1 || depth < maxDepth) {

      // children exist && children not yet processed
      if (children && add(processedChildren, children, unique)) {
        return children;
      }
    }
  });

  return result;
}

/**
 * Return self + direct children for a number of elements
 *
 * @param  {Array<djs.model.Base>} elements to query
 * @param  {Boolean} allowDuplicates to allow duplicates in the result set
 *
 * @return {Array<djs.model.Base>} the collected elements
 */
function selfAndDirectChildren(elements, allowDuplicates) {
  return selfAndChildren(elements, !allowDuplicates, 1);
}

/**
 * Return self + ALL children for a number of elements
 *
 * @param  {Array<djs.model.Base>} elements to query
 * @param  {Boolean} allowDuplicates to allow duplicates in the result set
 *
 * @return {Array<djs.model.Base>} the collected elements
 */
function selfAndAllChildren(elements, allowDuplicates) {
  return selfAndChildren(elements, !allowDuplicates, -1);
}

/**
 * Gets the the closure for all selected elements,
 * their connections and their attachment's connections
 *
 * @param {Array<djs.model.Base>} elements
 * @return {Object} enclosure
 */
function getClosure(elements) {

  // original elements passed to this function
  var topLevel = groupBy(elements, function(e) { return e.id; });

  var allShapes = {},
      allConnections = {},
      enclosedElements = {},
      enclosedConnections = {};

  function handleConnection(c) {
    if (topLevel[c.source.id] && topLevel[c.target.id]) {
      topLevel[c.id] = c;
    }

    // not enclosed as a child, but maybe logically
    // (connecting two moved elements?)
    if (allShapes[c.source.id] && allShapes[c.target.id]) {
      enclosedConnections[c.id] = enclosedElements[c.id] = c;
    }

    allConnections[c.id] = c;
  }

  function handleElement(element) {

    enclosedElements[element.id] = element;

    if (element.waypoints) {
      // remember connection
      enclosedConnections[element.id] = allConnections[element.id] = element;
    } else {
      // remember shape
      allShapes[element.id] = element;

      // remember all connections
      forEach(element.incoming, handleConnection);

      forEach(element.outgoing, handleConnection);

      // recurse into children
      return element.children;
    }
  }

  eachElement(elements, handleElement);

  return {
    allShapes: allShapes,
    allConnections: allConnections,
    topLevel: topLevel,
    enclosedConnections: enclosedConnections,
    enclosedElements: enclosedElements
  };
}

/**
 * Returns the surrounding bbox for all elements in
 * the array or the element primitive.
 *
 * @param {Array<djs.model.Shape>|djs.model.Shape} elements
 * @param {Boolean} stopRecursion
 */
function getBBox(elements, stopRecursion) {

  stopRecursion = !!stopRecursion;
  if (!isArray(elements)) {
    elements = [elements];
  }

  var minX,
      minY,
      maxX,
      maxY;

  forEach(elements, function(element) {

    // If element is a connection the bbox must be computed first
    var bbox = element;
    if (element.waypoints && !stopRecursion) {
      bbox = getBBox(element.waypoints, true);
    }

    var x = bbox.x,
        y = bbox.y,
        height = bbox.height || 0,
        width  = bbox.width  || 0;

    if (x < minX || minX === undefined) {
      minX = x;
    }
    if (y < minY || minY === undefined) {
      minY = y;
    }

    if ((x + width) > maxX || maxX === undefined) {
      maxX = x + width;
    }
    if ((y + height) > maxY || maxY === undefined) {
      maxY = y + height;
    }
  });

  return {
    x: minX,
    y: minY,
    height: maxY - minY,
    width: maxX - minX
  };
}


/**
 * Returns all elements that are enclosed from the bounding box.
 *
 *   * If bbox.(width|height) is not specified the method returns
 *     all elements with element.x/y > bbox.x/y
 *   * If only bbox.x or bbox.y is specified, method return all elements with
 *     e.x > bbox.x or e.y > bbox.y
 *
 * @param {Array<djs.model.Shape>} elements List of Elements to search through
 * @param {djs.model.Shape} bbox the enclosing bbox.
 *
 * @return {Array<djs.model.Shape>} enclosed elements
 */
function getEnclosedElements(elements, bbox) {

  var filteredElements = {};

  forEach(elements, function(element) {

    var e = element;

    if (e.waypoints) {
      e = getBBox(e);
    }

    if (!isNumber(bbox.y) && (e.x > bbox.x)) {
      filteredElements[element.id] = element;
    }
    if (!isNumber(bbox.x) && (e.y > bbox.y)) {
      filteredElements[element.id] = element;
    }
    if (e.x > bbox.x && e.y > bbox.y) {
      if (isNumber(bbox.width) && isNumber(bbox.height) &&
          e.width  + e.x < bbox.width  + bbox.x &&
          e.height + e.y < bbox.height + bbox.y) {

        filteredElements[element.id] = element;
      } else if (!isNumber(bbox.width) || !isNumber(bbox.height)) {
        filteredElements[element.id] = element;
      }
    }
  });

  return filteredElements;
}


module.exports.add = add;
module.exports.eachElement = eachElement;
module.exports.selfAndDirectChildren = selfAndDirectChildren;
module.exports.selfAndAllChildren = selfAndAllChildren;
module.exports.getBBox = getBBox;
module.exports.getEnclosedElements = getEnclosedElements;

module.exports.getClosure = getClosure;


function getElementType(element) {

  if ('waypoints' in element) {
    return 'connection';
  }

  if ('x' in element) {
    return 'shape';
  }

  return 'root';
}

module.exports.getType = getElementType;
},{"271":271,"272":272,"389":389,"392":392}],236:[function(_dereq_,module,exports){
arguments[4][95][0].apply(exports,arguments)
},{"95":95}],237:[function(_dereq_,module,exports){
'use strict';

/**
 * Computes the distance between two points
 *
 * @param  {Point}  p
 * @param  {Point}  q
 *
 * @return {Number}  distance
 */
function pointDistance(a, b) {
  if (!a || !b) {
    return -1;
  }

  return Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));
}

module.exports.pointDistance = pointDistance;


/**
 * Returns true if the point r is on the line between p and y
 *
 * @param  {Point}  p
 * @param  {Point}  q
 * @param  {Point}  r
 *
 * @return {Boolean}
 */
module.exports.pointsOnLine = function(p, q, r) {

  if (!p || !q || !r) {
    return false;
  }

  var val = (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x),
      dist = pointDistance(p, q);

  // @see http://stackoverflow.com/a/907491/412190
  return Math.abs(val / dist) < 5;
};


var ALIGNED_THRESHOLD = 2;

/**
 * Returns whether two points are in a horizontal or vertical line.
 *
 * @param {Point} a
 * @param {Point} b
 *
 * @return {String|Boolean} returns false if the points are not
 *                          aligned or 'h|v' if they are aligned
 *                          horizontally / vertically.
 */
function pointsAligned(a, b) {
  if (Math.abs(a.x - b.x) <= ALIGNED_THRESHOLD) {
    return 'h';
  }

  if (Math.abs(a.y - b.y) <= ALIGNED_THRESHOLD) {
    return 'v';
  }

  return false;
}

module.exports.pointsAligned = pointsAligned;


/**
 * Returns true if the point p is inside the rectangle rect
 *
 * @param  {Point}  p
 * @param  {Rect}   rect
 * @param  {Number} tolerance
 *
 * @return {Boolean}
 */
module.exports.pointInRect = function(p, rect, tolerance) {
  tolerance = tolerance || 0;

  return p.x > rect.x - tolerance &&
         p.y > rect.y - tolerance &&
         p.x < rect.x + rect.width + tolerance &&
         p.y < rect.y + rect.height + tolerance;
};

/**
 * Returns a point in the middle of points p and q
 *
 * @param  {Point}  p
 * @param  {Point}  q
 *
 * @return {Point} middle point
 */
module.exports.getMidPoint = function(p, q) {
  return {
    x: Math.round(p.x + ((q.x - p.x) / 2.0)),
    y: Math.round(p.y + ((q.y - p.y) / 2.0))
  };
};

},{}],238:[function(_dereq_,module,exports){
'use strict';

/**
 * SVGs for elements are generated by the {@link GraphicsFactory}.
 *
 * This utility gives quick access to the important semantic
 * parts of an element.
 */

/**
 * Returns the visual part of a diagram element
 *
 * @param {Snap<SVGElement>} gfx
 *
 * @return {Snap<SVGElement>}
 */
function getVisual(gfx) {
  return gfx.select('.djs-visual');
}

/**
 * Returns the children for a given diagram element.
 *
 * @param {Snap<SVGElement>} gfx
 * @return {Snap<SVGElement>}
 */
function getChildren(gfx) {
  return gfx.parent().children()[1];
}

/**
 * Returns the visual bbox of an element
 *
 * @param {Snap<SVGElement>} gfx
 *
 * @return {Bounds}
 */
function getBBox(gfx) {
  return getVisual(gfx).select('*').getBBox();
}


module.exports.getVisual = getVisual;
module.exports.getChildren = getChildren;
module.exports.getBBox = getBBox;
},{}],239:[function(_dereq_,module,exports){
'use strict';

/**
 * Util that provides unique IDs.
 *
 * @class djs.util.IdGenerator
 * @constructor
 * @memberOf djs.util
 *
 * The ids can be customized via a given prefix and contain a random value to avoid collisions.
 *
 * @param {String} prefix a prefix to prepend to generated ids (for better readability)
 */
function IdGenerator(prefix) {

  this._counter = 0;
  this._prefix = (prefix ? prefix + '-' : '') + Math.floor(Math.random() * 1000000000) + '-';
}

module.exports = IdGenerator;

/**
 * Returns a next unique ID.
 *
 * @method djs.util.IdGenerator#next
 *
 * @returns {String} the id
 */
IdGenerator.prototype.next = function() {
  return this._prefix + (++this._counter);
};

},{}],240:[function(_dereq_,module,exports){
'use strict';

var pointDistance = _dereq_(237).pointDistance;

var Snap = _dereq_(248);

var round = Math.round,
    max = Math.max;


function circlePath(center, r) {
  var x = center.x,
      y = center.y;

  return [
    ['M', x, y],
    ['m', 0, -r],
    ['a', r, r, 0, 1, 1, 0, 2 * r],
    ['a', r, r, 0, 1, 1, 0, -2 * r],
    ['z']
  ];
}

function linePath(points) {
  var segments = [];

  points.forEach(function(p, idx) {
    segments.push([ idx === 0 ? 'M' : 'L', p.x, p.y ]);
  });

  return segments;
}


var INTERSECTION_THRESHOLD = 10;

function getBendpointIntersection(waypoints, reference) {

  var i, w;

  for (i = 0; (w = waypoints[i]); i++) {

    if (pointDistance(w, reference) <= INTERSECTION_THRESHOLD) {
      return {
        point: waypoints[i],
        bendpoint: true,
        index: i
      };
    }
  }

  return null;
}

function getPathIntersection(waypoints, reference) {

  var intersections = Snap.path.intersection(circlePath(reference, INTERSECTION_THRESHOLD), linePath(waypoints));

  var a = intersections[0],
      b = intersections[intersections.length - 1],
      idx;

  if (!a) {
    // no intersection
    return null;
  }

  if (a !== b) {

    if (a.segment2 !== b.segment2) {
      // we use the bendpoint in between both segments
      // as the intersection point

      idx = max(a.segment2, b.segment2) - 1;

      return {
        point: waypoints[idx],
        bendpoint: true,
        index: idx
      };
    }

    return {
      point: {
        x: (round(a.x + b.x) / 2),
        y: (round(a.y + b.y) / 2)
      },
      index: a.segment2
    };
  }

  return {
    point: {
      x: round(a.x),
      y: round(a.y)
    },
    index: a.segment2
  };
}

/**
 * Returns the closest point on the connection towards a given reference point.
 *
 * @param  {Array<Point>} waypoints
 * @param  {Point} reference
 *
 * @return {Object} intersection data (segment, point)
 */
module.exports.getApproxIntersection = function(waypoints, reference) {
  return getBendpointIntersection(waypoints, reference) || getPathIntersection(waypoints, reference);
};
},{"237":237,"248":248}],241:[function(_dereq_,module,exports){
'use strict';

/**
 * Get the logarithm of x with base 10
 * @param  {Integer} value
 */
function log10(x) {
  return Math.log(x) / Math.log(10);
}

module.exports.log10 = log10;


function substract(p1, p2) {
  return {
    x: p1.x - p2.x,
    y: p1.y - p2.y
  };
}

module.exports.substract = substract;

},{}],242:[function(_dereq_,module,exports){
arguments[4][96][0].apply(exports,arguments)
},{"236":236,"243":243,"96":96}],243:[function(_dereq_,module,exports){
arguments[4][97][0].apply(exports,arguments)
},{"97":97}],244:[function(_dereq_,module,exports){
'use strict';

function center(bounds) {
  return {
    x: bounds.x + (bounds.width / 2),
    y: bounds.y + (bounds.height / 2)
  };
}

module.exports.center = center;


function delta(a, b) {
  return {
    x: a.x - b.x,
    y: a.y - b.y
  };
}

module.exports.delta = delta;

},{}],245:[function(_dereq_,module,exports){
'use strict';


/**
 * Remove from the beginning of a collection until it is empty.
 *
 * This is a null-safe operation that ensures elements
 * are being removed from the given collection until the
 * collection is empty.
 *
 * The implementation deals with the fact that a remove operation
 * may touch, i.e. remove multiple elements in the collection
 * at a time.
 *
 * @param {Array<Object>} [collection]
 * @param {Function} removeFn
 *
 * @return {Array<Object>} the cleared collection
 */
module.exports.saveClear = function(collection, removeFn) {

  if (typeof removeFn !== 'function') {
    throw new Error('removeFn iterator must be a function');
  }

  if (!collection) {
    return;
  }

  var e;

  while ((e = collection[0])) {
    removeFn(e);
  }

  return collection;
};

},{}],246:[function(_dereq_,module,exports){
arguments[4][98][0].apply(exports,arguments)
},{"248":248,"98":98}],247:[function(_dereq_,module,exports){
'use strict';

var isObject = _dereq_(393),
    assign = _dereq_(398),
    pick = _dereq_(404),
    forEach = _dereq_(271),
    reduce = _dereq_(274),
    merge = _dereq_(401);

var Snap = _dereq_(248);

var DEFAULT_BOX_PADDING = 0;

var DEFAULT_LABEL_SIZE = {
  width: 150,
  height: 50
};


function parseAlign(align) {

  var parts = align.split('-');

  return {
    horizontal: parts[0] || 'center',
    vertical: parts[1] || 'top'
  };
}

function parsePadding(padding) {

  if (isObject(padding)) {
    return assign({ top: 0, left: 0, right: 0, bottom: 0 }, padding);
  } else {
    return {
      top: padding,
      left: padding,
      right: padding,
      bottom: padding
    };
  }
}

function getTextBBox(text, fakeText) {
  fakeText.textContent = text;
  return pick(fakeText.getBBox(), [ 'width', 'height' ]);
}


/**
 * Layout the next line and return the layouted element.
 *
 * Alters the lines passed.
 *
 * @param  {Array<String>} lines
 * @return {Object} the line descriptor, an object { width, height, text }
 */
function layoutNext(lines, maxWidth, fakeText) {

  var originalLine = lines.shift(),
      fitLine = originalLine;

  var textBBox;

  for (;;) {
    textBBox = getTextBBox(fitLine, fakeText);

    textBBox.width = fitLine ? textBBox.width : 0;

    // try to fit
    if (fitLine === ' ' || fitLine === '' || textBBox.width < Math.round(maxWidth) || fitLine.length < 4) {
      return fit(lines, fitLine, originalLine, textBBox);
    }

    fitLine = shortenLine(fitLine, textBBox.width, maxWidth);
  }
}

function fit(lines, fitLine, originalLine, textBBox) {
  if (fitLine.length < originalLine.length) {
    var nextLine = lines[0] || '',
        remainder = originalLine.slice(fitLine.length).trim();

    if (/-\s*$/.test(remainder)) {
      nextLine = remainder + nextLine.replace(/^\s+/, '');
    } else {
      nextLine = remainder + ' ' + nextLine;
    }

    lines[0] = nextLine;
  }
  return { width: textBBox.width, height: textBBox.height, text: fitLine };
}


/**
 * Shortens a line based on spacing and hyphens.
 * Returns the shortened result on success.
 *
 * @param  {String} line
 * @param  {Number} maxLength the maximum characters of the string
 * @return {String} the shortened string
 */
function semanticShorten(line, maxLength) {
  var parts = line.split(/(\s|-)/g),
      part,
      shortenedParts = [],
      length = 0;

  // try to shorten via spaces + hyphens
  if (parts.length > 1) {
    while ((part = parts.shift())) {
      if (part.length + length < maxLength) {
        shortenedParts.push(part);
        length += part.length;
      } else {
        // remove previous part, too if hyphen does not fit anymore
        if (part === '-') {
          shortenedParts.pop();
        }

        break;
      }
    }
  }

  return shortenedParts.join('');
}


function shortenLine(line, width, maxWidth) {
  var length = Math.max(line.length * (maxWidth / width), 1);

  // try to shorten semantically (i.e. based on spaces and hyphens)
  var shortenedLine = semanticShorten(line, length);

  if (!shortenedLine) {

    // force shorten by cutting the long word
    shortenedLine = line.slice(0, Math.max(Math.round(length - 1), 1));
  }

  return shortenedLine;
}


/**
 * Creates a new label utility
 *
 * @param {Object} config
 * @param {Dimensions} config.size
 * @param {Number} config.padding
 * @param {Object} config.style
 * @param {String} config.align
 */
function Text(config) {

  this._config = assign({}, {
    size: DEFAULT_LABEL_SIZE,
    padding: DEFAULT_BOX_PADDING,
    style: {},
    align: 'center-top'
  }, config || {});
}


/**
 * Create a label in the parent node.
 *
 * @method Text#createText
 *
 * @param {SVGElement} parent the parent to draw the label on
 * @param {String} text the text to render on the label
 * @param {Object} options
 * @param {String} options.align how to align in the bounding box.
 *                             Any of { 'center-middle', 'center-top' }, defaults to 'center-top'.
 * @param {String} options.style style to be applied to the text
 *
 * @return {SVGText} the text element created
 */
Text.prototype.createText = function(parent, text, options) {

  var box = merge({}, this._config.size, options.box || {}),
      style = merge({}, this._config.style, options.style || {}),
      align = parseAlign(options.align || this._config.align),
      padding = parsePadding(options.padding !== undefined ? options.padding : this._config.padding);

  var lines = text.split(/\r?\n/g),
      layouted = [];

  var maxWidth = box.width - padding.left - padding.right;

  // FF regression: ensure text is shown during rendering
  // by attaching it directly to the body
  var fakeText = parent.paper.text(0, 0, '').attr(style).node;

  while (lines.length) {
    layouted.push(layoutNext(lines, maxWidth, fakeText));
  }

  var totalHeight = reduce(layouted, function(sum, line, idx) {
    return sum + line.height;
  }, 0);

  // the y position of the next line
  var y, x;

  switch (align.vertical) {
  case 'middle':
    y = (box.height - totalHeight) / 2 - layouted[0].height / 4;
    break;

  default:
    y = padding.top;
  }

  var textElement = parent.text().attr(style);

  forEach(layouted, function(line) {
    y += line.height;

    switch (align.horizontal) {
    case 'left':
      x = padding.left;
      break;

    case 'right':
      x = (maxWidth - padding.right - line.width);
      break;

    default:
        // aka center
      x = Math.max(((maxWidth - line.width) / 2 + padding.left), 0);
    }


    var tspan = Snap.create('tspan', { x: x, y: y }).node;
    tspan.textContent = line.text;

    textElement.append(tspan);
  });

  // remove fake text
  fakeText.parentNode.removeChild(fakeText);

  return textElement;
};


module.exports = Text;

},{"248":248,"271":271,"274":274,"393":393,"398":398,"401":401,"404":404}],248:[function(_dereq_,module,exports){
arguments[4][99][0].apply(exports,arguments)
},{"436":436,"99":99}],249:[function(_dereq_,module,exports){

var isArray = function(obj) {
  return Object.prototype.toString.call(obj) === '[object Array]';
};

var annotate = function() {
  var args = Array.prototype.slice.call(arguments);
  
  if (args.length === 1 && isArray(args[0])) {
    args = args[0];
  }

  var fn = args.pop();

  fn.$inject = args;

  return fn;
};


// Current limitations:
// - can't put into "function arg" comments
// function /* (no parenthesis like this) */ (){}
// function abc( /* xx (no parenthesis like this) */ a, b) {}
//
// Just put the comment before function or inside:
// /* (((this is fine))) */ function(a, b) {}
// function abc(a) { /* (((this is fine))) */}

var FN_ARGS = /^function\s*[^\(]*\(\s*([^\)]*)\)/m;
var FN_ARG = /\/\*([^\*]*)\*\//m;

var parse = function(fn) {
  if (typeof fn !== 'function') {
    throw new Error('Cannot annotate "' + fn + '". Expected a function!');
  }

  var match = fn.toString().match(FN_ARGS);
  return match[1] && match[1].split(',').map(function(arg) {
    match = arg.match(FN_ARG);
    return match ? match[1].trim() : arg.trim();
  }) || [];
};


exports.annotate = annotate;
exports.parse = parse;
exports.isArray = isArray;

},{}],250:[function(_dereq_,module,exports){
module.exports = {
  annotate: _dereq_(249).annotate,
  Module: _dereq_(252),
  Injector: _dereq_(251)
};

},{"249":249,"251":251,"252":252}],251:[function(_dereq_,module,exports){
var Module = _dereq_(252);
var autoAnnotate = _dereq_(249).parse;
var annotate = _dereq_(249).annotate;
var isArray = _dereq_(249).isArray;


var Injector = function(modules, parent) {
  parent = parent || {
    get: function(name, strict) {
      currentlyResolving.push(name);

      if (strict === false) {
        return null;
      } else {
        throw error('No provider for "' + name + '"!');
      }
    }
  };

  var currentlyResolving = [];
  var providers = this._providers = Object.create(parent._providers || null);
  var instances = this._instances = Object.create(null);

  var self = instances.injector = this;

  var error = function(msg) {
    var stack = currentlyResolving.join(' -> ');
    currentlyResolving.length = 0;
    return new Error(stack ? msg + ' (Resolving: ' + stack + ')' : msg);
  };

  /**
   * Return a named service.
   *
   * @param {String} name
   * @param {Boolean} [strict=true] if false, resolve missing services to null
   *
   * @return {Object}
   */
  var get = function(name, strict) {
    if (!providers[name] && name.indexOf('.') !== -1) {
      var parts = name.split('.');
      var pivot = get(parts.shift());

      while(parts.length) {
        pivot = pivot[parts.shift()];
      }

      return pivot;
    }

    if (Object.hasOwnProperty.call(instances, name)) {
      return instances[name];
    }

    if (Object.hasOwnProperty.call(providers, name)) {
      if (currentlyResolving.indexOf(name) !== -1) {
        currentlyResolving.push(name);
        throw error('Cannot resolve circular dependency!');
      }

      currentlyResolving.push(name);
      instances[name] = providers[name][0](providers[name][1]);
      currentlyResolving.pop();

      return instances[name];
    }

    return parent.get(name, strict);
  };

  var instantiate = function(Type) {
    var instance = Object.create(Type.prototype);
    var returned = invoke(Type, instance);

    return typeof returned === 'object' ? returned : instance;
  };

  var invoke = function(fn, context) {
    if (typeof fn !== 'function') {
      if (isArray(fn)) {
        fn = annotate(fn.slice());
      } else {
        throw new Error('Cannot invoke "' + fn + '". Expected a function!');
      }
    }

    var inject = fn.$inject && fn.$inject || autoAnnotate(fn);
    var dependencies = inject.map(function(dep) {
      return get(dep);
    });

    // TODO(vojta): optimize without apply
    return fn.apply(context, dependencies);
  };


  var createPrivateInjectorFactory = function(privateChildInjector) {
    return annotate(function(key) {
      return privateChildInjector.get(key);
    });
  };

  var createChild = function(modules, forceNewInstances) {
    if (forceNewInstances && forceNewInstances.length) {
      var fromParentModule = Object.create(null);
      var matchedScopes = Object.create(null);

      var privateInjectorsCache = [];
      var privateChildInjectors = [];
      var privateChildFactories = [];

      var provider;
      var cacheIdx;
      var privateChildInjector;
      var privateChildInjectorFactory;
      for (var name in providers) {
        provider = providers[name];

        if (forceNewInstances.indexOf(name) !== -1) {
          if (provider[2] === 'private') {
            cacheIdx = privateInjectorsCache.indexOf(provider[3]);
            if (cacheIdx === -1) {
              privateChildInjector = provider[3].createChild([], forceNewInstances);
              privateChildInjectorFactory = createPrivateInjectorFactory(privateChildInjector);
              privateInjectorsCache.push(provider[3]);
              privateChildInjectors.push(privateChildInjector);
              privateChildFactories.push(privateChildInjectorFactory);
              fromParentModule[name] = [privateChildInjectorFactory, name, 'private', privateChildInjector];
            } else {
              fromParentModule[name] = [privateChildFactories[cacheIdx], name, 'private', privateChildInjectors[cacheIdx]];
            }
          } else {
            fromParentModule[name] = [provider[2], provider[1]];
          }
          matchedScopes[name] = true;
        }

        if ((provider[2] === 'factory' || provider[2] === 'type') && provider[1].$scope) {
          /*jshint -W083 */
          forceNewInstances.forEach(function(scope) {
            if (provider[1].$scope.indexOf(scope) !== -1) {
              fromParentModule[name] = [provider[2], provider[1]];
              matchedScopes[scope] = true;
            }
          });
        }
      }

      forceNewInstances.forEach(function(scope) {
        if (!matchedScopes[scope]) {
          throw new Error('No provider for "' + scope + '". Cannot use provider from the parent!');
        }
      });

      modules.unshift(fromParentModule);
    }

    return new Injector(modules, self);
  };

  var factoryMap = {
    factory: invoke,
    type: instantiate,
    value: function(value) {
      return value;
    }
  };

  modules.forEach(function(module) {

    function arrayUnwrap(type, value) {
      if (type !== 'value' && isArray(value)) {
        value = annotate(value.slice());
      }

      return value;
    }

    // TODO(vojta): handle wrong inputs (modules)
    if (module instanceof Module) {
      module.forEach(function(provider) {
        var name = provider[0];
        var type = provider[1];
        var value = provider[2];

        providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
      });
    } else if (typeof module === 'object') {
      if (module.__exports__) {
        var clonedModule = Object.keys(module).reduce(function(m, key) {
          if (key.substring(0, 2) !== '__') {
            m[key] = module[key];
          }
          return m;
        }, Object.create(null));

        var privateInjector = new Injector((module.__modules__ || []).concat([clonedModule]), self);
        var getFromPrivateInjector = annotate(function(key) {
          return privateInjector.get(key);
        });
        module.__exports__.forEach(function(key) {
          providers[key] = [getFromPrivateInjector, key, 'private', privateInjector];
        });
      } else {
        Object.keys(module).forEach(function(name) {
          if (module[name][2] === 'private') {
            providers[name] = module[name];
            return;
          }

          var type = module[name][0];
          var value = module[name][1];

          providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
        });
      }
    }
  });

  // public API
  this.get = get;
  this.invoke = invoke;
  this.instantiate = instantiate;
  this.createChild = createChild;
};

module.exports = Injector;

},{"249":249,"252":252}],252:[function(_dereq_,module,exports){
var Module = function() {
  var providers = [];

  this.factory = function(name, factory) {
    providers.push([name, 'factory', factory]);
    return this;
  };

  this.value = function(name, value) {
    providers.push([name, 'value', value]);
    return this;
  };

  this.type = function(name, type) {
    providers.push([name, 'type', type]);
    return this;
  };

  this.forEach = function(iterator) {
    providers.forEach(iterator);
  };
};

module.exports = Module;

},{}],253:[function(_dereq_,module,exports){

/**
 * Expose `parse`.
 */

module.exports = parse;

/**
 * Tests for browser support.
 */

var innerHTMLBug = false;
var bugTestDiv;
if (typeof document !== 'undefined') {
  bugTestDiv = document.createElement('div');
  // Setup
  bugTestDiv.innerHTML = '  <link/><table></table><a href="/a">a</a><input type="checkbox"/>';
  // Make sure that link elements get serialized correctly by innerHTML
  // This requires a wrapper element in IE
  innerHTMLBug = !bugTestDiv.getElementsByTagName('link').length;
  bugTestDiv = undefined;
}

/**
 * Wrap map from jquery.
 */

var map = {
  legend: [1, '<fieldset>', '</fieldset>'],
  tr: [2, '<table><tbody>', '</tbody></table>'],
  col: [2, '<table><tbody></tbody><colgroup>', '</colgroup></table>'],
  // for script/link/style tags to work in IE6-8, you have to wrap
  // in a div with a non-whitespace character in front, ha!
  _default: innerHTMLBug ? [1, 'X<div>', '</div>'] : [0, '', '']
};

map.td =
map.th = [3, '<table><tbody><tr>', '</tr></tbody></table>'];

map.option =
map.optgroup = [1, '<select multiple="multiple">', '</select>'];

map.thead =
map.tbody =
map.colgroup =
map.caption =
map.tfoot = [1, '<table>', '</table>'];

map.polyline =
map.ellipse =
map.polygon =
map.circle =
map.text =
map.line =
map.path =
map.rect =
map.g = [1, '<svg xmlns="http://www.w3.org/2000/svg" version="1.1">','</svg>'];

/**
 * Parse `html` and return a DOM Node instance, which could be a TextNode,
 * HTML DOM Node of some kind (<div> for example), or a DocumentFragment
 * instance, depending on the contents of the `html` string.
 *
 * @param {String} html - HTML string to "domify"
 * @param {Document} doc - The `document` instance to create the Node for
 * @return {DOMNode} the TextNode, DOM Node, or DocumentFragment instance
 * @api private
 */

function parse(html, doc) {
  if ('string' != typeof html) throw new TypeError('String expected');

  // default to the global `document` object
  if (!doc) doc = document;

  // tag name
  var m = /<([\w:]+)/.exec(html);
  if (!m) return doc.createTextNode(html);

  html = html.replace(/^\s+|\s+$/g, ''); // Remove leading/trailing whitespace

  var tag = m[1];

  // body support
  if (tag == 'body') {
    var el = doc.createElement('html');
    el.innerHTML = html;
    return el.removeChild(el.lastChild);
  }

  // wrap map
  var wrap = map[tag] || map._default;
  var depth = wrap[0];
  var prefix = wrap[1];
  var suffix = wrap[2];
  var el = doc.createElement('div');
  el.innerHTML = prefix + html + suffix;
  while (depth--) el = el.lastChild;

  // one element
  if (el.firstChild == el.lastChild) {
    return el.removeChild(el.firstChild);
  }

  // several elements
  var fragment = doc.createDocumentFragment();
  while (el.firstChild) {
    fragment.appendChild(el.removeChild(el.firstChild));
  }

  return fragment;
}

},{}],254:[function(_dereq_,module,exports){
// Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ┌────────────────────────────────────────────────────────────┐ \\
// │ Eve 0.4.2 - JavaScript Events Library                      │ \\
// ├────────────────────────────────────────────────────────────┤ \\
// │ Author Dmitry Baranovskiy (http://dmitry.baranovskiy.com/) │ \\
// └────────────────────────────────────────────────────────────┘ \\

(function (glob) {
    var version = "0.4.2",
        has = "hasOwnProperty",
        separator = /[\.\/]/,
        comaseparator = /\s*,\s*/,
        wildcard = "*",
        fun = function () {},
        numsort = function (a, b) {
            return a - b;
        },
        current_event,
        stop,
        events = {n: {}},
        firstDefined = function () {
            for (var i = 0, ii = this.length; i < ii; i++) {
                if (typeof this[i] != "undefined") {
                    return this[i];
                }
            }
        },
        lastDefined = function () {
            var i = this.length;
            while (--i) {
                if (typeof this[i] != "undefined") {
                    return this[i];
                }
            }
        },
    /*\
     * eve
     [ method ]

     * Fires event with given `name`, given scope and other parameters.

     > Arguments

     - name (string) name of the *event*, dot (`.`) or slash (`/`) separated
     - scope (object) context for the event handlers
     - varargs (...) the rest of arguments will be sent to event handlers

     = (object) array of returned values from the listeners. Array has two methods `.firstDefined()` and `.lastDefined()` to get first or last not `undefined` value.
    \*/
        eve = function (name, scope) {
            name = String(name);
            var e = events,
                oldstop = stop,
                args = Array.prototype.slice.call(arguments, 2),
                listeners = eve.listeners(name),
                z = 0,
                f = false,
                l,
                indexed = [],
                queue = {},
                out = [],
                ce = current_event,
                errors = [];
            out.firstDefined = firstDefined;
            out.lastDefined = lastDefined;
            current_event = name;
            stop = 0;
            for (var i = 0, ii = listeners.length; i < ii; i++) if ("zIndex" in listeners[i]) {
                indexed.push(listeners[i].zIndex);
                if (listeners[i].zIndex < 0) {
                    queue[listeners[i].zIndex] = listeners[i];
                }
            }
            indexed.sort(numsort);
            while (indexed[z] < 0) {
                l = queue[indexed[z++]];
                out.push(l.apply(scope, args));
                if (stop) {
                    stop = oldstop;
                    return out;
                }
            }
            for (i = 0; i < ii; i++) {
                l = listeners[i];
                if ("zIndex" in l) {
                    if (l.zIndex == indexed[z]) {
                        out.push(l.apply(scope, args));
                        if (stop) {
                            break;
                        }
                        do {
                            z++;
                            l = queue[indexed[z]];
                            l && out.push(l.apply(scope, args));
                            if (stop) {
                                break;
                            }
                        } while (l)
                    } else {
                        queue[l.zIndex] = l;
                    }
                } else {
                    out.push(l.apply(scope, args));
                    if (stop) {
                        break;
                    }
                }
            }
            stop = oldstop;
            current_event = ce;
            return out;
        };
        // Undocumented. Debug only.
        eve._events = events;
    /*\
     * eve.listeners
     [ method ]

     * Internal method which gives you array of all event handlers that will be triggered by the given `name`.

     > Arguments

     - name (string) name of the event, dot (`.`) or slash (`/`) separated

     = (array) array of event handlers
    \*/
    eve.listeners = function (name) {
        var names = name.split(separator),
            e = events,
            item,
            items,
            k,
            i,
            ii,
            j,
            jj,
            nes,
            es = [e],
            out = [];
        for (i = 0, ii = names.length; i < ii; i++) {
            nes = [];
            for (j = 0, jj = es.length; j < jj; j++) {
                e = es[j].n;
                items = [e[names[i]], e[wildcard]];
                k = 2;
                while (k--) {
                    item = items[k];
                    if (item) {
                        nes.push(item);
                        out = out.concat(item.f || []);
                    }
                }
            }
            es = nes;
        }
        return out;
    };
    
    /*\
     * eve.on
     [ method ]
     **
     * Binds given event handler with a given name. You can use wildcards “`*`” for the names:
     | eve.on("*.under.*", f);
     | eve("mouse.under.floor"); // triggers f
     * Use @eve to trigger the listener.
     **
     > Arguments
     **
     - name (string) name of the event, dot (`.`) or slash (`/`) separated, with optional wildcards
     - f (function) event handler function
     **
     = (function) returned function accepts a single numeric parameter that represents z-index of the handler. It is an optional feature and only used when you need to ensure that some subset of handlers will be invoked in a given order, despite of the order of assignment. 
     > Example:
     | eve.on("mouse", eatIt)(2);
     | eve.on("mouse", scream);
     | eve.on("mouse", catchIt)(1);
     * This will ensure that `catchIt` function will be called before `eatIt`.
     *
     * If you want to put your handler before non-indexed handlers, specify a negative value.
     * Note: I assume most of the time you don’t need to worry about z-index, but it’s nice to have this feature “just in case”.
    \*/
    eve.on = function (name, f) {
        name = String(name);
        if (typeof f != "function") {
            return function () {};
        }
        var names = name.split(comaseparator);
        for (var i = 0, ii = names.length; i < ii; i++) {
            (function (name) {
                var names = name.split(separator),
                    e = events,
                    exist;
                for (var i = 0, ii = names.length; i < ii; i++) {
                    e = e.n;
                    e = e.hasOwnProperty(names[i]) && e[names[i]] || (e[names[i]] = {n: {}});
                }
                e.f = e.f || [];
                for (i = 0, ii = e.f.length; i < ii; i++) if (e.f[i] == f) {
                    exist = true;
                    break;
                }
                !exist && e.f.push(f);
            }(names[i]));
        }
        return function (zIndex) {
            if (+zIndex == +zIndex) {
                f.zIndex = +zIndex;
            }
        };
    };
    /*\
     * eve.f
     [ method ]
     **
     * Returns function that will fire given event with optional arguments.
     * Arguments that will be passed to the result function will be also
     * concated to the list of final arguments.
     | el.onclick = eve.f("click", 1, 2);
     | eve.on("click", function (a, b, c) {
     |     console.log(a, b, c); // 1, 2, [event object]
     | });
     > Arguments
     - event (string) event name
     - varargs (…) and any other arguments
     = (function) possible event handler function
    \*/
    eve.f = function (event) {
        var attrs = [].slice.call(arguments, 1);
        return function () {
            eve.apply(null, [event, null].concat(attrs).concat([].slice.call(arguments, 0)));
        };
    };
    /*\
     * eve.stop
     [ method ]
     **
     * Is used inside an event handler to stop the event, preventing any subsequent listeners from firing.
    \*/
    eve.stop = function () {
        stop = 1;
    };
    /*\
     * eve.nt
     [ method ]
     **
     * Could be used inside event handler to figure out actual name of the event.
     **
     > Arguments
     **
     - subname (string) #optional subname of the event
     **
     = (string) name of the event, if `subname` is not specified
     * or
     = (boolean) `true`, if current event’s name contains `subname`
    \*/
    eve.nt = function (subname) {
        if (subname) {
            return new RegExp("(?:\\.|\\/|^)" + subname + "(?:\\.|\\/|$)").test(current_event);
        }
        return current_event;
    };
    /*\
     * eve.nts
     [ method ]
     **
     * Could be used inside event handler to figure out actual name of the event.
     **
     **
     = (array) names of the event
    \*/
    eve.nts = function () {
        return current_event.split(separator);
    };
    /*\
     * eve.off
     [ method ]
     **
     * Removes given function from the list of event listeners assigned to given name.
     * If no arguments specified all the events will be cleared.
     **
     > Arguments
     **
     - name (string) name of the event, dot (`.`) or slash (`/`) separated, with optional wildcards
     - f (function) event handler function
    \*/
    /*\
     * eve.unbind
     [ method ]
     **
     * See @eve.off
    \*/
    eve.off = eve.unbind = function (name, f) {
        if (!name) {
            eve._events = events = {n: {}};
            return;
        }
        var names = name.split(comaseparator);
        if (names.length > 1) {
            for (var i = 0, ii = names.length; i < ii; i++) {
                eve.off(names[i], f);
            }
            return;
        }
        names = name.split(separator);
        var e,
            key,
            splice,
            i, ii, j, jj,
            cur = [events];
        for (i = 0, ii = names.length; i < ii; i++) {
            for (j = 0; j < cur.length; j += splice.length - 2) {
                splice = [j, 1];
                e = cur[j].n;
                if (names[i] != wildcard) {
                    if (e[names[i]]) {
                        splice.push(e[names[i]]);
                    }
                } else {
                    for (key in e) if (e[has](key)) {
                        splice.push(e[key]);
                    }
                }
                cur.splice.apply(cur, splice);
            }
        }
        for (i = 0, ii = cur.length; i < ii; i++) {
            e = cur[i];
            while (e.n) {
                if (f) {
                    if (e.f) {
                        for (j = 0, jj = e.f.length; j < jj; j++) if (e.f[j] == f) {
                            e.f.splice(j, 1);
                            break;
                        }
                        !e.f.length && delete e.f;
                    }
                    for (key in e.n) if (e.n[has](key) && e.n[key].f) {
                        var funcs = e.n[key].f;
                        for (j = 0, jj = funcs.length; j < jj; j++) if (funcs[j] == f) {
                            funcs.splice(j, 1);
                            break;
                        }
                        !funcs.length && delete e.n[key].f;
                    }
                } else {
                    delete e.f;
                    for (key in e.n) if (e.n[has](key) && e.n[key].f) {
                        delete e.n[key].f;
                    }
                }
                e = e.n;
            }
        }
    };
    /*\
     * eve.once
     [ method ]
     **
     * Binds given event handler with a given name to only run once then unbind itself.
     | eve.once("login", f);
     | eve("login"); // triggers f
     | eve("login"); // no listeners
     * Use @eve to trigger the listener.
     **
     > Arguments
     **
     - name (string) name of the event, dot (`.`) or slash (`/`) separated, with optional wildcards
     - f (function) event handler function
     **
     = (function) same return function as @eve.on
    \*/
    eve.once = function (name, f) {
        var f2 = function () {
            eve.unbind(name, f2);
            return f.apply(this, arguments);
        };
        return eve.on(name, f2);
    };
    /*\
     * eve.version
     [ property (string) ]
     **
     * Current version of the library.
    \*/
    eve.version = version;
    eve.toString = function () {
        return "You are running Eve " + version;
    };
    (typeof module != "undefined" && module.exports) ? (module.exports = eve) : (typeof define === "function" && define.amd ? (define("eve", [], function() { return eve; })) : (glob.eve = eve));
})(this);

},{}],255:[function(_dereq_,module,exports){
var hat = module.exports = function (bits, base) {
    if (!base) base = 16;
    if (bits === undefined) bits = 128;
    if (bits <= 0) return '0';
    
    var digits = Math.log(Math.pow(2, bits)) / Math.log(base);
    for (var i = 2; digits === Infinity; i *= 2) {
        digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
    }
    
    var rem = digits - Math.floor(digits);
    
    var res = '';
    
    for (var i = 0; i < Math.floor(digits); i++) {
        var x = Math.floor(Math.random() * base).toString(base);
        res = x + res;
    }
    
    if (rem) {
        var b = Math.pow(base, rem);
        var x = Math.floor(Math.random() * b).toString(base);
        res = x + res;
    }
    
    var parsed = parseInt(res, base);
    if (parsed !== Infinity && parsed >= Math.pow(2, bits)) {
        return hat(bits, base)
    }
    else return res;
};

hat.rack = function (bits, base, expandBy) {
    var fn = function (data) {
        var iters = 0;
        do {
            if (iters ++ > 10) {
                if (expandBy) bits += expandBy;
                else throw new Error('too many ID collisions, use more bits')
            }
            
            var id = hat(bits, base);
        } while (Object.hasOwnProperty.call(hats, id));
        
        hats[id] = data;
        return id;
    };
    var hats = fn.hats = {};
    
    fn.get = function (id) {
        return fn.hats[id];
    };
    
    fn.set = function (id, value) {
        fn.hats[id] = value;
        return fn;
    };
    
    fn.bits = bits || 128;
    fn.base = base || 16;
    return fn;
};

},{}],256:[function(_dereq_,module,exports){
'use strict';

var hat = _dereq_(255);


/**
 * Create a new id generator / cache instance.
 *
 * You may optionally provide a seed that is used internally.
 *
 * @param {Seed} seed
 */
function Ids(seed) {

  if (!(this instanceof Ids)) {
    return new Ids(seed);
  }

  seed = seed || [ 128, 36, 1 ];
  this._seed = seed.length ? hat.rack(seed[0], seed[1], seed[2]) : seed;
}

module.exports = Ids;

/**
 * Generate a next id.
 *
 * @param {Object} [element] element to bind the id to
 *
 * @return {String} id
 */
Ids.prototype.next = function(element) {
  return this._seed(element || true);
};

/**
 * Generate a next id with a given prefix.
 *
 * @param {Object} [element] element to bind the id to
 *
 * @return {String} id
 */
Ids.prototype.nextPrefixed = function(prefix, element) {
  var id;

  do {
    id = prefix + this.next(true);
  } while (this.assigned(id));

  // claim {prefix}{random}
  this.claim(id, element);

  // return
  return id;
};

/**
 * Manually claim an existing id.
 *
 * @param {String} id
 * @param {String} [element] element the id is claimed by
 */
Ids.prototype.claim = function(id, element) {
  this._seed.set(id, element || true);
};

/**
 * Returns true if the given id has already been assigned.
 *
 * @param  {String} id
 * @return {Boolean}
 */
Ids.prototype.assigned = function(id) {
  return this._seed.get(id) || false;
};

/**
 * Unclaim an id.
 *
 * @param  {String} id the id to unclaim
 */
Ids.prototype.unclaim = function(id) {
  delete this._seed.hats[id];
};


/**
 * Clear all claimed ids.
 */
Ids.prototype.clear = function() {

  var hats = this._seed.hats,
      id;

  for (id in hats) {
    this.unclaim(id);
  }
};
},{"255":255}],257:[function(_dereq_,module,exports){
if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}

},{}],258:[function(_dereq_,module,exports){
var createFindIndex = _dereq_(348);

/**
 * This method is like `_.find` except that it returns the index of the first
 * element `predicate` returns truthy for instead of the element itself.
 *
 * If a property name is provided for `predicate` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `predicate` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @category Array
 * @param {Array} array The array to search.
 * @param {Function|Object|string} [predicate=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `predicate`.
 * @returns {number} Returns the index of the found element, else `-1`.
 * @example
 *
 * var users = [
 *   { 'user': 'barney',  'active': false },
 *   { 'user': 'fred',    'active': false },
 *   { 'user': 'pebbles', 'active': true }
 * ];
 *
 * _.findIndex(users, function(chr) {
 *   return chr.user == 'barney';
 * });
 * // => 0
 *
 * // using the `_.matches` callback shorthand
 * _.findIndex(users, { 'user': 'fred', 'active': false });
 * // => 1
 *
 * // using the `_.matchesProperty` callback shorthand
 * _.findIndex(users, 'active', false);
 * // => 0
 *
 * // using the `_.property` callback shorthand
 * _.findIndex(users, 'active');
 * // => 2
 */
var findIndex = createFindIndex();

module.exports = findIndex;

},{"348":348}],259:[function(_dereq_,module,exports){
var baseFlatten = _dereq_(308),
    isIterateeCall = _dereq_(368);

/**
 * Flattens a nested array. If `isDeep` is `true` the array is recursively
 * flattened, otherwise it's only flattened a single level.
 *
 * @static
 * @memberOf _
 * @category Array
 * @param {Array} array The array to flatten.
 * @param {boolean} [isDeep] Specify a deep flatten.
 * @param- {Object} [guard] Enables use as a callback for functions like `_.map`.
 * @returns {Array} Returns the new flattened array.
 * @example
 *
 * _.flatten([1, [2, 3, [4]]]);
 * // => [1, 2, 3, [4]]
 *
 * // using `isDeep`
 * _.flatten([1, [2, 3, [4]]], true);
 * // => [1, 2, 3, 4]
 */
function flatten(array, isDeep, guard) {
  var length = array ? array.length : 0;
  if (guard && isIterateeCall(array, isDeep, guard)) {
    isDeep = false;
  }
  return length ? baseFlatten(array, isDeep) : [];
}

module.exports = flatten;

},{"308":308,"368":368}],260:[function(_dereq_,module,exports){
var baseIndexOf = _dereq_(313),
    cacheIndexOf = _dereq_(335),
    createCache = _dereq_(345),
    isArrayLike = _dereq_(366),
    restParam = _dereq_(282);

/**
 * Creates an array of unique values that are included in all of the provided
 * arrays using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @static
 * @memberOf _
 * @category Array
 * @param {...Array} [arrays] The arrays to inspect.
 * @returns {Array} Returns the new array of shared values.
 * @example
 * _.intersection([1, 2], [4, 2], [2, 1]);
 * // => [2]
 */
var intersection = restParam(function(arrays) {
  var othLength = arrays.length,
      othIndex = othLength,
      caches = Array(length),
      indexOf = baseIndexOf,
      isCommon = true,
      result = [];

  while (othIndex--) {
    var value = arrays[othIndex] = isArrayLike(value = arrays[othIndex]) ? value : [];
    caches[othIndex] = (isCommon && value.length >= 120) ? createCache(othIndex && value) : null;
  }
  var array = arrays[0],
      index = -1,
      length = array ? array.length : 0,
      seen = caches[0];

  outer:
  while (++index < length) {
    value = array[index];
    if ((seen ? cacheIndexOf(seen, value) : indexOf(result, value, 0)) < 0) {
      var othIndex = othLength;
      while (--othIndex) {
        var cache = caches[othIndex];
        if ((cache ? cacheIndexOf(cache, value) : indexOf(arrays[othIndex], value, 0)) < 0) {
          continue outer;
        }
      }
      if (seen) {
        seen.push(value);
      }
      result.push(value);
    }
  }
  return result;
});

module.exports = intersection;

},{"282":282,"313":313,"335":335,"345":345,"366":366}],261:[function(_dereq_,module,exports){
/**
 * Gets the last element of `array`.
 *
 * @static
 * @memberOf _
 * @category Array
 * @param {Array} array The array to query.
 * @returns {*} Returns the last element of `array`.
 * @example
 *
 * _.last([1, 2, 3]);
 * // => 3
 */
function last(array) {
  var length = array ? array.length : 0;
  return length ? array[length - 1] : undefined;
}

module.exports = last;

},{}],262:[function(_dereq_,module,exports){
var baseFlatten = _dereq_(308),
    baseUniq = _dereq_(331),
    restParam = _dereq_(282);

/**
 * Creates an array of unique values, in order, from all of the provided arrays
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @static
 * @memberOf _
 * @category Array
 * @param {...Array} [arrays] The arrays to inspect.
 * @returns {Array} Returns the new array of combined values.
 * @example
 *
 * _.union([1, 2], [4, 2], [2, 1]);
 * // => [1, 2, 4]
 */
var union = restParam(function(arrays) {
  return baseUniq(baseFlatten(arrays, false, true));
});

module.exports = union;

},{"282":282,"308":308,"331":331}],263:[function(_dereq_,module,exports){
var baseCallback = _dereq_(296),
    baseUniq = _dereq_(331),
    isIterateeCall = _dereq_(368),
    sortedUniq = _dereq_(383);

/**
 * Creates a duplicate-free version of an array, using
 * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
 * for equality comparisons, in which only the first occurence of each element
 * is kept. Providing `true` for `isSorted` performs a faster search algorithm
 * for sorted arrays. If an iteratee function is provided it's invoked for
 * each element in the array to generate the criterion by which uniqueness
 * is computed. The `iteratee` is bound to `thisArg` and invoked with three
 * arguments: (value, index, array).
 *
 * If a property name is provided for `iteratee` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `iteratee` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @alias unique
 * @category Array
 * @param {Array} array The array to inspect.
 * @param {boolean} [isSorted] Specify the array is sorted.
 * @param {Function|Object|string} [iteratee] The function invoked per iteration.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {Array} Returns the new duplicate-value-free array.
 * @example
 *
 * _.uniq([2, 1, 2]);
 * // => [2, 1]
 *
 * // using `isSorted`
 * _.uniq([1, 1, 2], true);
 * // => [1, 2]
 *
 * // using an iteratee function
 * _.uniq([1, 2.5, 1.5, 2], function(n) {
 *   return this.floor(n);
 * }, Math);
 * // => [1, 2.5]
 *
 * // using the `_.property` callback shorthand
 * _.uniq([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
 * // => [{ 'x': 1 }, { 'x': 2 }]
 */
function uniq(array, isSorted, iteratee, thisArg) {
  var length = array ? array.length : 0;
  if (!length) {
    return [];
  }
  if (isSorted != null && typeof isSorted != 'boolean') {
    thisArg = iteratee;
    iteratee = isIterateeCall(array, isSorted, thisArg) ? undefined : isSorted;
    isSorted = false;
  }
  iteratee = iteratee == null ? iteratee : baseCallback(iteratee, thisArg, 3);
  return (isSorted)
    ? sortedUniq(array, iteratee)
    : baseUniq(array, iteratee);
}

module.exports = uniq;

},{"296":296,"331":331,"368":368,"383":383}],264:[function(_dereq_,module,exports){
module.exports = _dereq_(263);

},{"263":263}],265:[function(_dereq_,module,exports){
var baseDifference = _dereq_(302),
    isArrayLike = _dereq_(366),
    restParam = _dereq_(282);

/**
 * Creates an array excluding all provided values using
 * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @static
 * @memberOf _
 * @category Array
 * @param {Array} array The array to filter.
 * @param {...*} [values] The values to exclude.
 * @returns {Array} Returns the new array of filtered values.
 * @example
 *
 * _.without([1, 2, 1, 3], 1, 2);
 * // => [3]
 */
var without = restParam(function(array, values) {
  return isArrayLike(array)
    ? baseDifference(array, values)
    : [];
});

module.exports = without;

},{"282":282,"302":302,"366":366}],266:[function(_dereq_,module,exports){
var LazyWrapper = _dereq_(283),
    LodashWrapper = _dereq_(284),
    baseLodash = _dereq_(317),
    isArray = _dereq_(389),
    isObjectLike = _dereq_(372),
    wrapperClone = _dereq_(386);

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates a `lodash` object which wraps `value` to enable implicit chaining.
 * Methods that operate on and return arrays, collections, and functions can
 * be chained together. Methods that retrieve a single value or may return a
 * primitive value will automatically end the chain returning the unwrapped
 * value. Explicit chaining may be enabled using `_.chain`. The execution of
 * chained methods is lazy, that is, execution is deferred until `_#value`
 * is implicitly or explicitly called.
 *
 * Lazy evaluation allows several methods to support shortcut fusion. Shortcut
 * fusion is an optimization strategy which merge iteratee calls; this can help
 * to avoid the creation of intermediate data structures and greatly reduce the
 * number of iteratee executions.
 *
 * Chaining is supported in custom builds as long as the `_#value` method is
 * directly or indirectly included in the build.
 *
 * In addition to lodash methods, wrappers have `Array` and `String` methods.
 *
 * The wrapper `Array` methods are:
 * `concat`, `join`, `pop`, `push`, `reverse`, `shift`, `slice`, `sort`,
 * `splice`, and `unshift`
 *
 * The wrapper `String` methods are:
 * `replace` and `split`
 *
 * The wrapper methods that support shortcut fusion are:
 * `compact`, `drop`, `dropRight`, `dropRightWhile`, `dropWhile`, `filter`,
 * `first`, `initial`, `last`, `map`, `pluck`, `reject`, `rest`, `reverse`,
 * `slice`, `take`, `takeRight`, `takeRightWhile`, `takeWhile`, `toArray`,
 * and `where`
 *
 * The chainable wrapper methods are:
 * `after`, `ary`, `assign`, `at`, `before`, `bind`, `bindAll`, `bindKey`,
 * `callback`, `chain`, `chunk`, `commit`, `compact`, `concat`, `constant`,
 * `countBy`, `create`, `curry`, `debounce`, `defaults`, `defaultsDeep`,
 * `defer`, `delay`, `difference`, `drop`, `dropRight`, `dropRightWhile`,
 * `dropWhile`, `fill`, `filter`, `flatten`, `flattenDeep`, `flow`, `flowRight`,
 * `forEach`, `forEachRight`, `forIn`, `forInRight`, `forOwn`, `forOwnRight`,
 * `functions`, `groupBy`, `indexBy`, `initial`, `intersection`, `invert`,
 * `invoke`, `keys`, `keysIn`, `map`, `mapKeys`, `mapValues`, `matches`,
 * `matchesProperty`, `memoize`, `merge`, `method`, `methodOf`, `mixin`,
 * `modArgs`, `negate`, `omit`, `once`, `pairs`, `partial`, `partialRight`,
 * `partition`, `pick`, `plant`, `pluck`, `property`, `propertyOf`, `pull`,
 * `pullAt`, `push`, `range`, `rearg`, `reject`, `remove`, `rest`, `restParam`,
 * `reverse`, `set`, `shuffle`, `slice`, `sort`, `sortBy`, `sortByAll`,
 * `sortByOrder`, `splice`, `spread`, `take`, `takeRight`, `takeRightWhile`,
 * `takeWhile`, `tap`, `throttle`, `thru`, `times`, `toArray`, `toPlainObject`,
 * `transform`, `union`, `uniq`, `unshift`, `unzip`, `unzipWith`, `values`,
 * `valuesIn`, `where`, `without`, `wrap`, `xor`, `zip`, `zipObject`, `zipWith`
 *
 * The wrapper methods that are **not** chainable by default are:
 * `add`, `attempt`, `camelCase`, `capitalize`, `ceil`, `clone`, `cloneDeep`,
 * `deburr`, `endsWith`, `escape`, `escapeRegExp`, `every`, `find`, `findIndex`,
 * `findKey`, `findLast`, `findLastIndex`, `findLastKey`, `findWhere`, `first`,
 * `floor`, `get`, `gt`, `gte`, `has`, `identity`, `includes`, `indexOf`,
 * `inRange`, `isArguments`, `isArray`, `isBoolean`, `isDate`, `isElement`,
 * `isEmpty`, `isEqual`, `isError`, `isFinite` `isFunction`, `isMatch`,
 * `isNative`, `isNaN`, `isNull`, `isNumber`, `isObject`, `isPlainObject`,
 * `isRegExp`, `isString`, `isUndefined`, `isTypedArray`, `join`, `kebabCase`,
 * `last`, `lastIndexOf`, `lt`, `lte`, `max`, `min`, `noConflict`, `noop`,
 * `now`, `pad`, `padLeft`, `padRight`, `parseInt`, `pop`, `random`, `reduce`,
 * `reduceRight`, `repeat`, `result`, `round`, `runInContext`, `shift`, `size`,
 * `snakeCase`, `some`, `sortedIndex`, `sortedLastIndex`, `startCase`,
 * `startsWith`, `sum`, `template`, `trim`, `trimLeft`, `trimRight`, `trunc`,
 * `unescape`, `uniqueId`, `value`, and `words`
 *
 * The wrapper method `sample` will return a wrapped value when `n` is provided,
 * otherwise an unwrapped value is returned.
 *
 * @name _
 * @constructor
 * @category Chain
 * @param {*} value The value to wrap in a `lodash` instance.
 * @returns {Object} Returns the new `lodash` wrapper instance.
 * @example
 *
 * var wrapped = _([1, 2, 3]);
 *
 * // returns an unwrapped value
 * wrapped.reduce(function(total, n) {
 *   return total + n;
 * });
 * // => 6
 *
 * // returns a wrapped value
 * var squares = wrapped.map(function(n) {
 *   return n * n;
 * });
 *
 * _.isArray(squares);
 * // => false
 *
 * _.isArray(squares.value());
 * // => true
 */
function lodash(value) {
  if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
    if (value instanceof LodashWrapper) {
      return value;
    }
    if (hasOwnProperty.call(value, '__chain__') && hasOwnProperty.call(value, '__wrapped__')) {
      return wrapperClone(value);
    }
  }
  return new LodashWrapper(value);
}

// Ensure wrappers are instances of `baseLodash`.
lodash.prototype = baseLodash.prototype;

module.exports = lodash;

},{"283":283,"284":284,"317":317,"372":372,"386":386,"389":389}],267:[function(_dereq_,module,exports){
module.exports = _dereq_(276);

},{"276":276}],268:[function(_dereq_,module,exports){
var arrayEvery = _dereq_(288),
    baseCallback = _dereq_(296),
    baseEvery = _dereq_(304),
    isArray = _dereq_(389),
    isIterateeCall = _dereq_(368);

/**
 * Checks if `predicate` returns truthy for **all** elements of `collection`.
 * The predicate is bound to `thisArg` and invoked with three arguments:
 * (value, index|key, collection).
 *
 * If a property name is provided for `predicate` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `predicate` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @alias all
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function|Object|string} [predicate=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `predicate`.
 * @returns {boolean} Returns `true` if all elements pass the predicate check,
 *  else `false`.
 * @example
 *
 * _.every([true, 1, null, 'yes'], Boolean);
 * // => false
 *
 * var users = [
 *   { 'user': 'barney', 'active': false },
 *   { 'user': 'fred',   'active': false }
 * ];
 *
 * // using the `_.matches` callback shorthand
 * _.every(users, { 'user': 'barney', 'active': false });
 * // => false
 *
 * // using the `_.matchesProperty` callback shorthand
 * _.every(users, 'active', false);
 * // => true
 *
 * // using the `_.property` callback shorthand
 * _.every(users, 'active');
 * // => false
 */
function every(collection, predicate, thisArg) {
  var func = isArray(collection) ? arrayEvery : baseEvery;
  if (thisArg && isIterateeCall(collection, predicate, thisArg)) {
    predicate = undefined;
  }
  if (typeof predicate != 'function' || thisArg !== undefined) {
    predicate = baseCallback(predicate, thisArg, 3);
  }
  return func(collection, predicate);
}

module.exports = every;

},{"288":288,"296":296,"304":304,"368":368,"389":389}],269:[function(_dereq_,module,exports){
var arrayFilter = _dereq_(289),
    baseCallback = _dereq_(296),
    baseFilter = _dereq_(305),
    isArray = _dereq_(389);

/**
 * Iterates over elements of `collection`, returning an array of all elements
 * `predicate` returns truthy for. The predicate is bound to `thisArg` and
 * invoked with three arguments: (value, index|key, collection).
 *
 * If a property name is provided for `predicate` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `predicate` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @alias select
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function|Object|string} [predicate=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `predicate`.
 * @returns {Array} Returns the new filtered array.
 * @example
 *
 * _.filter([4, 5, 6], function(n) {
 *   return n % 2 == 0;
 * });
 * // => [4, 6]
 *
 * var users = [
 *   { 'user': 'barney', 'age': 36, 'active': true },
 *   { 'user': 'fred',   'age': 40, 'active': false }
 * ];
 *
 * // using the `_.matches` callback shorthand
 * _.pluck(_.filter(users, { 'age': 36, 'active': true }), 'user');
 * // => ['barney']
 *
 * // using the `_.matchesProperty` callback shorthand
 * _.pluck(_.filter(users, 'active', false), 'user');
 * // => ['fred']
 *
 * // using the `_.property` callback shorthand
 * _.pluck(_.filter(users, 'active'), 'user');
 * // => ['barney']
 */
function filter(collection, predicate, thisArg) {
  var func = isArray(collection) ? arrayFilter : baseFilter;
  predicate = baseCallback(predicate, thisArg, 3);
  return func(collection, predicate);
}

module.exports = filter;

},{"289":289,"296":296,"305":305,"389":389}],270:[function(_dereq_,module,exports){
var baseEach = _dereq_(303),
    createFind = _dereq_(347);

/**
 * Iterates over elements of `collection`, returning the first element
 * `predicate` returns truthy for. The predicate is bound to `thisArg` and
 * invoked with three arguments: (value, index|key, collection).
 *
 * If a property name is provided for `predicate` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `predicate` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @alias detect
 * @category Collection
 * @param {Array|Object|string} collection The collection to search.
 * @param {Function|Object|string} [predicate=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `predicate`.
 * @returns {*} Returns the matched element, else `undefined`.
 * @example
 *
 * var users = [
 *   { 'user': 'barney',  'age': 36, 'active': true },
 *   { 'user': 'fred',    'age': 40, 'active': false },
 *   { 'user': 'pebbles', 'age': 1,  'active': true }
 * ];
 *
 * _.result(_.find(users, function(chr) {
 *   return chr.age < 40;
 * }), 'user');
 * // => 'barney'
 *
 * // using the `_.matches` callback shorthand
 * _.result(_.find(users, { 'age': 1, 'active': true }), 'user');
 * // => 'pebbles'
 *
 * // using the `_.matchesProperty` callback shorthand
 * _.result(_.find(users, 'active', false), 'user');
 * // => 'fred'
 *
 * // using the `_.property` callback shorthand
 * _.result(_.find(users, 'active'), 'user');
 * // => 'barney'
 */
var find = createFind(baseEach);

module.exports = find;

},{"303":303,"347":347}],271:[function(_dereq_,module,exports){
var arrayEach = _dereq_(287),
    baseEach = _dereq_(303),
    createForEach = _dereq_(349);

/**
 * Iterates over elements of `collection` invoking `iteratee` for each element.
 * The `iteratee` is bound to `thisArg` and invoked with three arguments:
 * (value, index|key, collection). Iteratee functions may exit iteration early
 * by explicitly returning `false`.
 *
 * **Note:** As with other "Collections" methods, objects with a "length" property
 * are iterated like arrays. To avoid this behavior `_.forIn` or `_.forOwn`
 * may be used for object iteration.
 *
 * @static
 * @memberOf _
 * @alias each
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {Array|Object|string} Returns `collection`.
 * @example
 *
 * _([1, 2]).forEach(function(n) {
 *   console.log(n);
 * }).value();
 * // => logs each value from left to right and returns the array
 *
 * _.forEach({ 'a': 1, 'b': 2 }, function(n, key) {
 *   console.log(n, key);
 * });
 * // => logs each value-key pair and returns the object (iteration order is not guaranteed)
 */
var forEach = createForEach(arrayEach, baseEach);

module.exports = forEach;

},{"287":287,"303":303,"349":349}],272:[function(_dereq_,module,exports){
var createAggregator = _dereq_(340);

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an object composed of keys generated from the results of running
 * each element of `collection` through `iteratee`. The corresponding value
 * of each key is an array of the elements responsible for generating the key.
 * The `iteratee` is bound to `thisArg` and invoked with three arguments:
 * (value, index|key, collection).
 *
 * If a property name is provided for `iteratee` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `iteratee` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function|Object|string} [iteratee=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {Object} Returns the composed aggregate object.
 * @example
 *
 * _.groupBy([4.2, 6.1, 6.4], function(n) {
 *   return Math.floor(n);
 * });
 * // => { '4': [4.2], '6': [6.1, 6.4] }
 *
 * _.groupBy([4.2, 6.1, 6.4], function(n) {
 *   return this.floor(n);
 * }, Math);
 * // => { '4': [4.2], '6': [6.1, 6.4] }
 *
 * // using the `_.property` callback shorthand
 * _.groupBy(['one', 'two', 'three'], 'length');
 * // => { '3': ['one', 'two'], '5': ['three'] }
 */
var groupBy = createAggregator(function(result, value, key) {
  if (hasOwnProperty.call(result, key)) {
    result[key].push(value);
  } else {
    result[key] = [value];
  }
});

module.exports = groupBy;

},{"340":340}],273:[function(_dereq_,module,exports){
var arrayMap = _dereq_(290),
    baseCallback = _dereq_(296),
    baseMap = _dereq_(318),
    isArray = _dereq_(389);

/**
 * Creates an array of values by running each element in `collection` through
 * `iteratee`. The `iteratee` is bound to `thisArg` and invoked with three
 * arguments: (value, index|key, collection).
 *
 * If a property name is provided for `iteratee` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `iteratee` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * Many lodash methods are guarded to work as iteratees for methods like
 * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
 *
 * The guarded methods are:
 * `ary`, `callback`, `chunk`, `clone`, `create`, `curry`, `curryRight`,
 * `drop`, `dropRight`, `every`, `fill`, `flatten`, `invert`, `max`, `min`,
 * `parseInt`, `slice`, `sortBy`, `take`, `takeRight`, `template`, `trim`,
 * `trimLeft`, `trimRight`, `trunc`, `random`, `range`, `sample`, `some`,
 * `sum`, `uniq`, and `words`
 *
 * @static
 * @memberOf _
 * @alias collect
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function|Object|string} [iteratee=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {Array} Returns the new mapped array.
 * @example
 *
 * function timesThree(n) {
 *   return n * 3;
 * }
 *
 * _.map([1, 2], timesThree);
 * // => [3, 6]
 *
 * _.map({ 'a': 1, 'b': 2 }, timesThree);
 * // => [3, 6] (iteration order is not guaranteed)
 *
 * var users = [
 *   { 'user': 'barney' },
 *   { 'user': 'fred' }
 * ];
 *
 * // using the `_.property` callback shorthand
 * _.map(users, 'user');
 * // => ['barney', 'fred']
 */
function map(collection, iteratee, thisArg) {
  var func = isArray(collection) ? arrayMap : baseMap;
  iteratee = baseCallback(iteratee, thisArg, 3);
  return func(collection, iteratee);
}

module.exports = map;

},{"290":290,"296":296,"318":318,"389":389}],274:[function(_dereq_,module,exports){
var arrayReduce = _dereq_(292),
    baseEach = _dereq_(303),
    createReduce = _dereq_(352);

/**
 * Reduces `collection` to a value which is the accumulated result of running
 * each element in `collection` through `iteratee`, where each successive
 * invocation is supplied the return value of the previous. If `accumulator`
 * is not provided the first element of `collection` is used as the initial
 * value. The `iteratee` is bound to `thisArg` and invoked with four arguments:
 * (accumulator, value, index|key, collection).
 *
 * Many lodash methods are guarded to work as iteratees for methods like
 * `_.reduce`, `_.reduceRight`, and `_.transform`.
 *
 * The guarded methods are:
 * `assign`, `defaults`, `defaultsDeep`, `includes`, `merge`, `sortByAll`,
 * and `sortByOrder`
 *
 * @static
 * @memberOf _
 * @alias foldl, inject
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {*} Returns the accumulated value.
 * @example
 *
 * _.reduce([1, 2], function(total, n) {
 *   return total + n;
 * });
 * // => 3
 *
 * _.reduce({ 'a': 1, 'b': 2 }, function(result, n, key) {
 *   result[key] = n * 3;
 *   return result;
 * }, {});
 * // => { 'a': 3, 'b': 6 } (iteration order is not guaranteed)
 */
var reduce = createReduce(arrayReduce, baseEach);

module.exports = reduce;

},{"292":292,"303":303,"352":352}],275:[function(_dereq_,module,exports){
var getLength = _dereq_(359),
    isLength = _dereq_(371),
    keys = _dereq_(399);

/**
 * Gets the size of `collection` by returning its length for array-like
 * values or the number of own enumerable properties for objects.
 *
 * @static
 * @memberOf _
 * @category Collection
 * @param {Array|Object|string} collection The collection to inspect.
 * @returns {number} Returns the size of `collection`.
 * @example
 *
 * _.size([1, 2, 3]);
 * // => 3
 *
 * _.size({ 'a': 1, 'b': 2 });
 * // => 2
 *
 * _.size('pebbles');
 * // => 7
 */
function size(collection) {
  var length = collection ? getLength(collection) : 0;
  return isLength(length) ? length : keys(collection).length;
}

module.exports = size;

},{"359":359,"371":371,"399":399}],276:[function(_dereq_,module,exports){
var arraySome = _dereq_(293),
    baseCallback = _dereq_(296),
    baseSome = _dereq_(328),
    isArray = _dereq_(389),
    isIterateeCall = _dereq_(368);

/**
 * Checks if `predicate` returns truthy for **any** element of `collection`.
 * The function returns as soon as it finds a passing value and does not iterate
 * over the entire collection. The predicate is bound to `thisArg` and invoked
 * with three arguments: (value, index|key, collection).
 *
 * If a property name is provided for `predicate` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `predicate` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @alias any
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function|Object|string} [predicate=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `predicate`.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 * @example
 *
 * _.some([null, 0, 'yes', false], Boolean);
 * // => true
 *
 * var users = [
 *   { 'user': 'barney', 'active': true },
 *   { 'user': 'fred',   'active': false }
 * ];
 *
 * // using the `_.matches` callback shorthand
 * _.some(users, { 'user': 'barney', 'active': false });
 * // => false
 *
 * // using the `_.matchesProperty` callback shorthand
 * _.some(users, 'active', false);
 * // => true
 *
 * // using the `_.property` callback shorthand
 * _.some(users, 'active');
 * // => true
 */
function some(collection, predicate, thisArg) {
  var func = isArray(collection) ? arraySome : baseSome;
  if (thisArg && isIterateeCall(collection, predicate, thisArg)) {
    predicate = undefined;
  }
  if (typeof predicate != 'function' || thisArg !== undefined) {
    predicate = baseCallback(predicate, thisArg, 3);
  }
  return func(collection, predicate);
}

module.exports = some;

},{"293":293,"296":296,"328":328,"368":368,"389":389}],277:[function(_dereq_,module,exports){
var baseCallback = _dereq_(296),
    baseMap = _dereq_(318),
    baseSortBy = _dereq_(329),
    compareAscending = _dereq_(337),
    isIterateeCall = _dereq_(368);

/**
 * Creates an array of elements, sorted in ascending order by the results of
 * running each element in a collection through `iteratee`. This method performs
 * a stable sort, that is, it preserves the original sort order of equal elements.
 * The `iteratee` is bound to `thisArg` and invoked with three arguments:
 * (value, index|key, collection).
 *
 * If a property name is provided for `iteratee` the created `_.property`
 * style callback returns the property value of the given element.
 *
 * If a value is also provided for `thisArg` the created `_.matchesProperty`
 * style callback returns `true` for elements that have a matching property
 * value, else `false`.
 *
 * If an object is provided for `iteratee` the created `_.matches` style
 * callback returns `true` for elements that have the properties of the given
 * object, else `false`.
 *
 * @static
 * @memberOf _
 * @category Collection
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function|Object|string} [iteratee=_.identity] The function invoked
 *  per iteration.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {Array} Returns the new sorted array.
 * @example
 *
 * _.sortBy([1, 2, 3], function(n) {
 *   return Math.sin(n);
 * });
 * // => [3, 1, 2]
 *
 * _.sortBy([1, 2, 3], function(n) {
 *   return this.sin(n);
 * }, Math);
 * // => [3, 1, 2]
 *
 * var users = [
 *   { 'user': 'fred' },
 *   { 'user': 'pebbles' },
 *   { 'user': 'barney' }
 * ];
 *
 * // using the `_.property` callback shorthand
 * _.pluck(_.sortBy(users, 'user'), 'user');
 * // => ['barney', 'fred', 'pebbles']
 */
function sortBy(collection, iteratee, thisArg) {
  if (collection == null) {
    return [];
  }
  if (thisArg && isIterateeCall(collection, iteratee, thisArg)) {
    iteratee = undefined;
  }
  var index = -1;
  iteratee = baseCallback(iteratee, thisArg, 3);

  var result = baseMap(collection, function(value, key, collection) {
    return { 'criteria': iteratee(value, key, collection), 'index': ++index, 'value': value };
  });
  return baseSortBy(result, compareAscending);
}

module.exports = sortBy;

},{"296":296,"318":318,"329":329,"337":337,"368":368}],278:[function(_dereq_,module,exports){
var getNative = _dereq_(361);

/* Native method references for those with the same name as other `lodash` methods. */
var nativeNow = getNative(Date, 'now');

/**
 * Gets the number of milliseconds that have elapsed since the Unix epoch
 * (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @category Date
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => logs the number of milliseconds it took for the deferred function to be invoked
 */
var now = nativeNow || function() {
  return new Date().getTime();
};

module.exports = now;

},{"361":361}],279:[function(_dereq_,module,exports){
var createWrapper = _dereq_(353),
    replaceHolders = _dereq_(380),
    restParam = _dereq_(282);

/** Used to compose bitmasks for wrapper metadata. */
var BIND_FLAG = 1,
    PARTIAL_FLAG = 32;

/**
 * Creates a function that invokes `func` with the `this` binding of `thisArg`
 * and prepends any additional `_.bind` arguments to those provided to the
 * bound function.
 *
 * The `_.bind.placeholder` value, which defaults to `_` in monolithic builds,
 * may be used as a placeholder for partially applied arguments.
 *
 * **Note:** Unlike native `Function#bind` this method does not set the "length"
 * property of bound functions.
 *
 * @static
 * @memberOf _
 * @category Function
 * @param {Function} func The function to bind.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {...*} [partials] The arguments to be partially applied.
 * @returns {Function} Returns the new bound function.
 * @example
 *
 * var greet = function(greeting, punctuation) {
 *   return greeting + ' ' + this.user + punctuation;
 * };
 *
 * var object = { 'user': 'fred' };
 *
 * var bound = _.bind(greet, object, 'hi');
 * bound('!');
 * // => 'hi fred!'
 *
 * // using placeholders
 * var bound = _.bind(greet, object, _, '!');
 * bound('hi');
 * // => 'hi fred!'
 */
var bind = restParam(function(func, thisArg, partials) {
  var bitmask = BIND_FLAG;
  if (partials.length) {
    var holders = replaceHolders(partials, bind.placeholder);
    bitmask |= PARTIAL_FLAG;
  }
  return createWrapper(func, bitmask, thisArg, partials, holders);
});

// Assign default placeholders.
bind.placeholder = {};

module.exports = bind;

},{"282":282,"353":353,"380":380}],280:[function(_dereq_,module,exports){
var isObject = _dereq_(393),
    now = _dereq_(278);

/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/* Native method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed invocations. Provide an options object to indicate that `func`
 * should be invoked on the leading and/or trailing edge of the `wait` timeout.
 * Subsequent calls to the debounced function return the result of the last
 * `func` invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is invoked
 * on the trailing edge of the timeout only if the the debounced function is
 * invoked more than once during the `wait` timeout.
 *
 * See [David Corbacho's article](http://drupalmotion.com/article/debounce-and-throttle-visual-explanation)
 * for details over the differences between `_.debounce` and `_.throttle`.
 *
 * @static
 * @memberOf _
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options] The options object.
 * @param {boolean} [options.leading=false] Specify invoking on the leading
 *  edge of the timeout.
 * @param {number} [options.maxWait] The maximum time `func` is allowed to be
 *  delayed before it's invoked.
 * @param {boolean} [options.trailing=true] Specify invoking on the trailing
 *  edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // avoid costly calculations while the window size is in flux
 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
 *
 * // invoke `sendMail` when the click event is fired, debouncing subsequent calls
 * jQuery('#postbox').on('click', _.debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }));
 *
 * // ensure `batchLog` is invoked once after 1 second of debounced calls
 * var source = new EventSource('/stream');
 * jQuery(source).on('message', _.debounce(batchLog, 250, {
 *   'maxWait': 1000
 * }));
 *
 * // cancel a debounced call
 * var todoChanges = _.debounce(batchLog, 1000);
 * Object.observe(models.todo, todoChanges);
 *
 * Object.observe(models, function(changes) {
 *   if (_.find(changes, { 'user': 'todo', 'type': 'delete'})) {
 *     todoChanges.cancel();
 *   }
 * }, ['delete']);
 *
 * // ...at some point `models.todo` is changed
 * models.todo.completed = true;
 *
 * // ...before 1 second has passed `models.todo` is deleted
 * // which cancels the debounced `todoChanges` call
 * delete models.todo;
 */
function debounce(func, wait, options) {
  var args,
      maxTimeoutId,
      result,
      stamp,
      thisArg,
      timeoutId,
      trailingCall,
      lastCalled = 0,
      maxWait = false,
      trailing = true;

  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = wait < 0 ? 0 : (+wait || 0);
  if (options === true) {
    var leading = true;
    trailing = false;
  } else if (isObject(options)) {
    leading = !!options.leading;
    maxWait = 'maxWait' in options && nativeMax(+options.maxWait || 0, wait);
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }

  function cancel() {
    if (timeoutId) {
      clearTimeout(timeoutId);
    }
    if (maxTimeoutId) {
      clearTimeout(maxTimeoutId);
    }
    lastCalled = 0;
    maxTimeoutId = timeoutId = trailingCall = undefined;
  }

  function complete(isCalled, id) {
    if (id) {
      clearTimeout(id);
    }
    maxTimeoutId = timeoutId = trailingCall = undefined;
    if (isCalled) {
      lastCalled = now();
      result = func.apply(thisArg, args);
      if (!timeoutId && !maxTimeoutId) {
        args = thisArg = undefined;
      }
    }
  }

  function delayed() {
    var remaining = wait - (now() - stamp);
    if (remaining <= 0 || remaining > wait) {
      complete(trailingCall, maxTimeoutId);
    } else {
      timeoutId = setTimeout(delayed, remaining);
    }
  }

  function maxDelayed() {
    complete(trailing, timeoutId);
  }

  function debounced() {
    args = arguments;
    stamp = now();
    thisArg = this;
    trailingCall = trailing && (timeoutId || !leading);

    if (maxWait === false) {
      var leadingCall = leading && !timeoutId;
    } else {
      if (!maxTimeoutId && !leading) {
        lastCalled = stamp;
      }
      var remaining = maxWait - (stamp - lastCalled),
          isCalled = remaining <= 0 || remaining > maxWait;

      if (isCalled) {
        if (maxTimeoutId) {
          maxTimeoutId = clearTimeout(maxTimeoutId);
        }
        lastCalled = stamp;
        result = func.apply(thisArg, args);
      }
      else if (!maxTimeoutId) {
        maxTimeoutId = setTimeout(maxDelayed, remaining);
      }
    }
    if (isCalled && timeoutId) {
      timeoutId = clearTimeout(timeoutId);
    }
    else if (!timeoutId && wait !== maxWait) {
      timeoutId = setTimeout(delayed, wait);
    }
    if (leadingCall) {
      isCalled = true;
      result = func.apply(thisArg, args);
    }
    if (isCalled && !timeoutId && !maxTimeoutId) {
      args = thisArg = undefined;
    }
    return result;
  }
  debounced.cancel = cancel;
  return debounced;
}

module.exports = debounce;

},{"278":278,"393":393}],281:[function(_dereq_,module,exports){
var baseDelay = _dereq_(301),
    restParam = _dereq_(282);

/**
 * Defers invoking the `func` until the current call stack has cleared. Any
 * additional arguments are provided to `func` when it's invoked.
 *
 * @static
 * @memberOf _
 * @category Function
 * @param {Function} func The function to defer.
 * @param {...*} [args] The arguments to invoke the function with.
 * @returns {number} Returns the timer id.
 * @example
 *
 * _.defer(function(text) {
 *   console.log(text);
 * }, 'deferred');
 * // logs 'deferred' after one or more milliseconds
 */
var defer = restParam(function(func, args) {
  return baseDelay(func, 1, args);
});

module.exports = defer;

},{"282":282,"301":301}],282:[function(_dereq_,module,exports){
/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/* Native method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * Creates a function that invokes `func` with the `this` binding of the
 * created function and arguments from `start` and beyond provided as an array.
 *
 * **Note:** This method is based on the [rest parameter](https://developer.mozilla.org/Web/JavaScript/Reference/Functions/rest_parameters).
 *
 * @static
 * @memberOf _
 * @category Function
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 * @example
 *
 * var say = _.restParam(function(what, names) {
 *   return what + ' ' + _.initial(names).join(', ') +
 *     (_.size(names) > 1 ? ', & ' : '') + _.last(names);
 * });
 *
 * say('hello', 'fred', 'barney', 'pebbles');
 * // => 'hello fred, barney, & pebbles'
 */
function restParam(func, start) {
  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  start = nativeMax(start === undefined ? (func.length - 1) : (+start || 0), 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        rest = Array(length);

    while (++index < length) {
      rest[index] = args[start + index];
    }
    switch (start) {
      case 0: return func.call(this, rest);
      case 1: return func.call(this, args[0], rest);
      case 2: return func.call(this, args[0], args[1], rest);
    }
    var otherArgs = Array(start + 1);
    index = -1;
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = rest;
    return func.apply(this, otherArgs);
  };
}

module.exports = restParam;

},{}],283:[function(_dereq_,module,exports){
var baseCreate = _dereq_(300),
    baseLodash = _dereq_(317);

/** Used as references for `-Infinity` and `Infinity`. */
var POSITIVE_INFINITY = Number.POSITIVE_INFINITY;

/**
 * Creates a lazy wrapper object which wraps `value` to enable lazy evaluation.
 *
 * @private
 * @param {*} value The value to wrap.
 */
function LazyWrapper(value) {
  this.__wrapped__ = value;
  this.__actions__ = [];
  this.__dir__ = 1;
  this.__filtered__ = false;
  this.__iteratees__ = [];
  this.__takeCount__ = POSITIVE_INFINITY;
  this.__views__ = [];
}

LazyWrapper.prototype = baseCreate(baseLodash.prototype);
LazyWrapper.prototype.constructor = LazyWrapper;

module.exports = LazyWrapper;

},{"300":300,"317":317}],284:[function(_dereq_,module,exports){
var baseCreate = _dereq_(300),
    baseLodash = _dereq_(317);

/**
 * The base constructor for creating `lodash` wrapper objects.
 *
 * @private
 * @param {*} value The value to wrap.
 * @param {boolean} [chainAll] Enable chaining for all wrapper methods.
 * @param {Array} [actions=[]] Actions to peform to resolve the unwrapped value.
 */
function LodashWrapper(value, chainAll, actions) {
  this.__wrapped__ = value;
  this.__actions__ = actions || [];
  this.__chain__ = !!chainAll;
}

LodashWrapper.prototype = baseCreate(baseLodash.prototype);
LodashWrapper.prototype.constructor = LodashWrapper;

module.exports = LodashWrapper;

},{"300":300,"317":317}],285:[function(_dereq_,module,exports){
(function (global){
var cachePush = _dereq_(336),
    getNative = _dereq_(361);

/** Native method references. */
var Set = getNative(global, 'Set');

/* Native method references for those with the same name as other `lodash` methods. */
var nativeCreate = getNative(Object, 'create');

/**
 *
 * Creates a cache object to store unique values.
 *
 * @private
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var length = values ? values.length : 0;

  this.data = { 'hash': nativeCreate(null), 'set': new Set };
  while (length--) {
    this.push(values[length]);
  }
}

// Add functions to the `Set` cache.
SetCache.prototype.push = cachePush;

module.exports = SetCache;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{"336":336,"361":361}],286:[function(_dereq_,module,exports){
/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function arrayCopy(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

module.exports = arrayCopy;

},{}],287:[function(_dereq_,module,exports){
/**
 * A specialized version of `_.forEach` for arrays without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array.length;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

module.exports = arrayEach;

},{}],288:[function(_dereq_,module,exports){
/**
 * A specialized version of `_.every` for arrays without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if all elements pass the predicate check,
 *  else `false`.
 */
function arrayEvery(array, predicate) {
  var index = -1,
      length = array.length;

  while (++index < length) {
    if (!predicate(array[index], index, array)) {
      return false;
    }
  }
  return true;
}

module.exports = arrayEvery;

},{}],289:[function(_dereq_,module,exports){
/**
 * A specialized version of `_.filter` for arrays without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array.length,
      resIndex = -1,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[++resIndex] = value;
    }
  }
  return result;
}

module.exports = arrayFilter;

},{}],290:[function(_dereq_,module,exports){
/**
 * A specialized version of `_.map` for arrays without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;

},{}],291:[function(_dereq_,module,exports){
/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;

},{}],292:[function(_dereq_,module,exports){
/**
 * A specialized version of `_.reduce` for arrays without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initFromArray] Specify using the first element of `array`
 *  as the initial value.
 * @returns {*} Returns the accumulated value.
 */
function arrayReduce(array, iteratee, accumulator, initFromArray) {
  var index = -1,
      length = array.length;

  if (initFromArray && length) {
    accumulator = array[++index];
  }
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}

module.exports = arrayReduce;

},{}],293:[function(_dereq_,module,exports){
/**
 * A specialized version of `_.some` for arrays without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;

},{}],294:[function(_dereq_,module,exports){
var keys = _dereq_(399);

/**
 * A specialized version of `_.assign` for customizing assigned values without
 * support for argument juggling, multiple sources, and `this` binding `customizer`
 * functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {Function} customizer The function to customize assigned values.
 * @returns {Object} Returns `object`.
 */
function assignWith(object, source, customizer) {
  var index = -1,
      props = keys(source),
      length = props.length;

  while (++index < length) {
    var key = props[index],
        value = object[key],
        result = customizer(value, source[key], key, object, source);

    if ((result === result ? (result !== value) : (value === value)) ||
        (value === undefined && !(key in object))) {
      object[key] = result;
    }
  }
  return object;
}

module.exports = assignWith;

},{"399":399}],295:[function(_dereq_,module,exports){
var baseCopy = _dereq_(299),
    keys = _dereq_(399);

/**
 * The base implementation of `_.assign` without support for argument juggling,
 * multiple sources, and `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssign(object, source) {
  return source == null
    ? object
    : baseCopy(source, keys(source), object);
}

module.exports = baseAssign;

},{"299":299,"399":399}],296:[function(_dereq_,module,exports){
var baseMatches = _dereq_(319),
    baseMatchesProperty = _dereq_(320),
    bindCallback = _dereq_(333),
    identity = _dereq_(407),
    property = _dereq_(409);

/**
 * The base implementation of `_.callback` which supports specifying the
 * number of arguments to provide to `func`.
 *
 * @private
 * @param {*} [func=_.identity] The value to convert to a callback.
 * @param {*} [thisArg] The `this` binding of `func`.
 * @param {number} [argCount] The number of arguments to provide to `func`.
 * @returns {Function} Returns the callback.
 */
function baseCallback(func, thisArg, argCount) {
  var type = typeof func;
  if (type == 'function') {
    return thisArg === undefined
      ? func
      : bindCallback(func, thisArg, argCount);
  }
  if (func == null) {
    return identity;
  }
  if (type == 'object') {
    return baseMatches(func);
  }
  return thisArg === undefined
    ? property(func)
    : baseMatchesProperty(func, thisArg);
}

module.exports = baseCallback;

},{"319":319,"320":320,"333":333,"407":407,"409":409}],297:[function(_dereq_,module,exports){
var arrayCopy = _dereq_(286),
    arrayEach = _dereq_(287),
    baseAssign = _dereq_(295),
    baseForOwn = _dereq_(311),
    initCloneArray = _dereq_(363),
    initCloneByTag = _dereq_(364),
    initCloneObject = _dereq_(365),
    isArray = _dereq_(389),
    isObject = _dereq_(393);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values supported by `_.clone`. */
var cloneableTags = {};
cloneableTags[argsTag] = cloneableTags[arrayTag] =
cloneableTags[arrayBufferTag] = cloneableTags[boolTag] =
cloneableTags[dateTag] = cloneableTags[float32Tag] =
cloneableTags[float64Tag] = cloneableTags[int8Tag] =
cloneableTags[int16Tag] = cloneableTags[int32Tag] =
cloneableTags[numberTag] = cloneableTags[objectTag] =
cloneableTags[regexpTag] = cloneableTags[stringTag] =
cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
cloneableTags[errorTag] = cloneableTags[funcTag] =
cloneableTags[mapTag] = cloneableTags[setTag] =
cloneableTags[weakMapTag] = false;

/** Used for native method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/**
 * The base implementation of `_.clone` without support for argument juggling
 * and `this` binding `customizer` functions.
 *
 * @private
 * @param {*} value The value to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @param {Function} [customizer] The function to customize cloning values.
 * @param {string} [key] The key of `value`.
 * @param {Object} [object] The object `value` belongs to.
 * @param {Array} [stackA=[]] Tracks traversed source objects.
 * @param {Array} [stackB=[]] Associates clones with source counterparts.
 * @returns {*} Returns the cloned value.
 */
function baseClone(value, isDeep, customizer, key, object, stackA, stackB) {
  var result;
  if (customizer) {
    result = object ? customizer(value, key, object) : customizer(value);
  }
  if (result !== undefined) {
    return result;
  }
  if (!isObject(value)) {
    return value;
  }
  var isArr = isArray(value);
  if (isArr) {
    result = initCloneArray(value);
    if (!isDeep) {
      return arrayCopy(value, result);
    }
  } else {
    var tag = objToString.call(value),
        isFunc = tag == funcTag;

    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
      result = initCloneObject(isFunc ? {} : value);
      if (!isDeep) {
        return baseAssign(result, value);
      }
    } else {
      return cloneableTags[tag]
        ? initCloneByTag(value, tag, isDeep)
        : (object ? value : {});
    }
  }
  // Check for circular references and return its corresponding clone.
  stackA || (stackA = []);
  stackB || (stackB = []);

  var length = stackA.length;
  while (length--) {
    if (stackA[length] == value) {
      return stackB[length];
    }
  }
  // Add the source value to the stack of traversed objects and associate it with its clone.
  stackA.push(value);
  stackB.push(result);

  // Recursively populate clone (susceptible to call stack limits).
  (isArr ? arrayEach : baseForOwn)(value, function(subValue, key) {
    result[key] = baseClone(subValue, isDeep, customizer, key, value, stackA, stackB);
  });
  return result;
}

module.exports = baseClone;

},{"286":286,"287":287,"295":295,"311":311,"363":363,"364":364,"365":365,"389":389,"393":393}],298:[function(_dereq_,module,exports){
/**
 * The base implementation of `compareAscending` which compares values and
 * sorts them in ascending order without guaranteeing a stable sort.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {number} Returns the sort order indicator for `value`.
 */
function baseCompareAscending(value, other) {
  if (value !== other) {
    var valIsNull = value === null,
        valIsUndef = value === undefined,
        valIsReflexive = value === value;

    var othIsNull = other === null,
        othIsUndef = other === undefined,
        othIsReflexive = other === other;

    if ((value > other && !othIsNull) || !valIsReflexive ||
        (valIsNull && !othIsUndef && othIsReflexive) ||
        (valIsUndef && othIsReflexive)) {
      return 1;
    }
    if ((value < other && !valIsNull) || !othIsReflexive ||
        (othIsNull && !valIsUndef && valIsReflexive) ||
        (othIsUndef && valIsReflexive)) {
      return -1;
    }
  }
  return 0;
}

module.exports = baseCompareAscending;

},{}],299:[function(_dereq_,module,exports){
/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property names to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @returns {Object} Returns `object`.
 */
function baseCopy(source, props, object) {
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];
    object[key] = source[key];
  }
  return object;
}

module.exports = baseCopy;

},{}],300:[function(_dereq_,module,exports){
var isObject = _dereq_(393);

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} prototype The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(prototype) {
    if (isObject(prototype)) {
      object.prototype = prototype;
      var result = new object;
      object.prototype = undefined;
    }
    return result || {};
  };
}());

module.exports = baseCreate;

},{"393":393}],301:[function(_dereq_,module,exports){
/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * The base implementation of `_.delay` and `_.defer` which accepts an index
 * of where to slice the arguments to provide to `func`.
 *
 * @private
 * @param {Function} func The function to delay.
 * @param {number} wait The number of milliseconds to delay invocation.
 * @param {Object} args The arguments provide to `func`.
 * @returns {number} Returns the timer id.
 */
function baseDelay(func, wait, args) {
  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  return setTimeout(function() { func.apply(undefined, args); }, wait);
}

module.exports = baseDelay;

},{}],302:[function(_dereq_,module,exports){
var baseIndexOf = _dereq_(313),
    cacheIndexOf = _dereq_(335),
    createCache = _dereq_(345);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.difference` which accepts a single array
 * of values to exclude.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Array} values The values to exclude.
 * @returns {Array} Returns the new array of filtered values.
 */
function baseDifference(array, values) {
  var length = array ? array.length : 0,
      result = [];

  if (!length) {
    return result;
  }
  var index = -1,
      indexOf = baseIndexOf,
      isCommon = true,
      cache = (isCommon && values.length >= LARGE_ARRAY_SIZE) ? createCache(values) : null,
      valuesLength = values.length;

  if (cache) {
    indexOf = cacheIndexOf;
    isCommon = false;
    values = cache;
  }
  outer:
  while (++index < length) {
    var value = array[index];

    if (isCommon && value === value) {
      var valuesIndex = valuesLength;
      while (valuesIndex--) {
        if (values[valuesIndex] === value) {
          continue outer;
        }
      }
      result.push(value);
    }
    else if (indexOf(values, value, 0) < 0) {
      result.push(value);
    }
  }
  return result;
}

module.exports = baseDifference;

},{"313":313,"335":335,"345":345}],303:[function(_dereq_,module,exports){
var baseForOwn = _dereq_(311),
    createBaseEach = _dereq_(342);

/**
 * The base implementation of `_.forEach` without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array|Object|string} Returns `collection`.
 */
var baseEach = createBaseEach(baseForOwn);

module.exports = baseEach;

},{"311":311,"342":342}],304:[function(_dereq_,module,exports){
var baseEach = _dereq_(303);

/**
 * The base implementation of `_.every` without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if all elements pass the predicate check,
 *  else `false`
 */
function baseEvery(collection, predicate) {
  var result = true;
  baseEach(collection, function(value, index, collection) {
    result = !!predicate(value, index, collection);
    return result;
  });
  return result;
}

module.exports = baseEvery;

},{"303":303}],305:[function(_dereq_,module,exports){
var baseEach = _dereq_(303);

/**
 * The base implementation of `_.filter` without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function baseFilter(collection, predicate) {
  var result = [];
  baseEach(collection, function(value, index, collection) {
    if (predicate(value, index, collection)) {
      result.push(value);
    }
  });
  return result;
}

module.exports = baseFilter;

},{"303":303}],306:[function(_dereq_,module,exports){
/**
 * The base implementation of `_.find`, `_.findLast`, `_.findKey`, and `_.findLastKey`,
 * without support for callback shorthands and `this` binding, which iterates
 * over `collection` using the provided `eachFunc`.
 *
 * @private
 * @param {Array|Object|string} collection The collection to search.
 * @param {Function} predicate The function invoked per iteration.
 * @param {Function} eachFunc The function to iterate over `collection`.
 * @param {boolean} [retKey] Specify returning the key of the found element
 *  instead of the element itself.
 * @returns {*} Returns the found element or its key, else `undefined`.
 */
function baseFind(collection, predicate, eachFunc, retKey) {
  var result;
  eachFunc(collection, function(value, key, collection) {
    if (predicate(value, key, collection)) {
      result = retKey ? key : value;
      return false;
    }
  });
  return result;
}

module.exports = baseFind;

},{}],307:[function(_dereq_,module,exports){
/**
 * The base implementation of `_.findIndex` and `_.findLastIndex` without
 * support for callback shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to search.
 * @param {Function} predicate The function invoked per iteration.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseFindIndex(array, predicate, fromRight) {
  var length = array.length,
      index = fromRight ? length : -1;

  while ((fromRight ? index-- : ++index < length)) {
    if (predicate(array[index], index, array)) {
      return index;
    }
  }
  return -1;
}

module.exports = baseFindIndex;

},{}],308:[function(_dereq_,module,exports){
var arrayPush = _dereq_(291),
    isArguments = _dereq_(388),
    isArray = _dereq_(389),
    isArrayLike = _dereq_(366),
    isObjectLike = _dereq_(372);

/**
 * The base implementation of `_.flatten` with added support for restricting
 * flattening and specifying the start index.
 *
 * @private
 * @param {Array} array The array to flatten.
 * @param {boolean} [isDeep] Specify a deep flatten.
 * @param {boolean} [isStrict] Restrict flattening to arrays-like objects.
 * @param {Array} [result=[]] The initial result value.
 * @returns {Array} Returns the new flattened array.
 */
function baseFlatten(array, isDeep, isStrict, result) {
  result || (result = []);

  var index = -1,
      length = array.length;

  while (++index < length) {
    var value = array[index];
    if (isObjectLike(value) && isArrayLike(value) &&
        (isStrict || isArray(value) || isArguments(value))) {
      if (isDeep) {
        // Recursively flatten arrays (susceptible to call stack limits).
        baseFlatten(value, isDeep, isStrict, result);
      } else {
        arrayPush(result, value);
      }
    } else if (!isStrict) {
      result[result.length] = value;
    }
  }
  return result;
}

module.exports = baseFlatten;

},{"291":291,"366":366,"372":372,"388":388,"389":389}],309:[function(_dereq_,module,exports){
var createBaseFor = _dereq_(343);

/**
 * The base implementation of `baseForIn` and `baseForOwn` which iterates
 * over `object` properties returned by `keysFunc` invoking `iteratee` for
 * each property. Iteratee functions may exit iteration early by explicitly
 * returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

module.exports = baseFor;

},{"343":343}],310:[function(_dereq_,module,exports){
var baseFor = _dereq_(309),
    keysIn = _dereq_(400);

/**
 * The base implementation of `_.forIn` without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForIn(object, iteratee) {
  return baseFor(object, iteratee, keysIn);
}

module.exports = baseForIn;

},{"309":309,"400":400}],311:[function(_dereq_,module,exports){
var baseFor = _dereq_(309),
    keys = _dereq_(399);

/**
 * The base implementation of `_.forOwn` without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return baseFor(object, iteratee, keys);
}

module.exports = baseForOwn;

},{"309":309,"399":399}],312:[function(_dereq_,module,exports){
var toObject = _dereq_(384);

/**
 * The base implementation of `get` without support for string paths
 * and default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array} path The path of the property to get.
 * @param {string} [pathKey] The key representation of path.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path, pathKey) {
  if (object == null) {
    return;
  }
  if (pathKey !== undefined && pathKey in toObject(object)) {
    path = [pathKey];
  }
  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[path[index++]];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;

},{"384":384}],313:[function(_dereq_,module,exports){
var indexOfNaN = _dereq_(362);

/**
 * The base implementation of `_.indexOf` without support for binary searches.
 *
 * @private
 * @param {Array} array The array to search.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOf(array, value, fromIndex) {
  if (value !== value) {
    return indexOfNaN(array, fromIndex);
  }
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}

module.exports = baseIndexOf;

},{"362":362}],314:[function(_dereq_,module,exports){
var baseIsEqualDeep = _dereq_(315),
    isObject = _dereq_(393),
    isObjectLike = _dereq_(372);

/**
 * The base implementation of `_.isEqual` without support for `this` binding
 * `customizer` functions.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {Function} [customizer] The function to customize comparing values.
 * @param {boolean} [isLoose] Specify performing partial comparisons.
 * @param {Array} [stackA] Tracks traversed `value` objects.
 * @param {Array} [stackB] Tracks traversed `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, customizer, isLoose, stackA, stackB) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObject(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, baseIsEqual, customizer, isLoose, stackA, stackB);
}

module.exports = baseIsEqual;

},{"315":315,"372":372,"393":393}],315:[function(_dereq_,module,exports){
var equalArrays = _dereq_(354),
    equalByTag = _dereq_(355),
    equalObjects = _dereq_(356),
    isArray = _dereq_(389),
    isTypedArray = _dereq_(396);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Function} [customizer] The function to customize comparing objects.
 * @param {boolean} [isLoose] Specify performing partial comparisons.
 * @param {Array} [stackA=[]] Tracks traversed `value` objects.
 * @param {Array} [stackB=[]] Tracks traversed `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = arrayTag,
      othTag = arrayTag;

  if (!objIsArr) {
    objTag = objToString.call(object);
    if (objTag == argsTag) {
      objTag = objectTag;
    } else if (objTag != objectTag) {
      objIsArr = isTypedArray(object);
    }
  }
  if (!othIsArr) {
    othTag = objToString.call(other);
    if (othTag == argsTag) {
      othTag = objectTag;
    } else if (othTag != objectTag) {
      othIsArr = isTypedArray(other);
    }
  }
  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && !(objIsArr || objIsObj)) {
    return equalByTag(object, other, objTag);
  }
  if (!isLoose) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      return equalFunc(objIsWrapped ? object.value() : object, othIsWrapped ? other.value() : other, customizer, isLoose, stackA, stackB);
    }
  }
  if (!isSameTag) {
    return false;
  }
  // Assume cyclic values are equal.
  // For more information on detecting circular references see https://es5.github.io/#JO.
  stackA || (stackA = []);
  stackB || (stackB = []);

  var length = stackA.length;
  while (length--) {
    if (stackA[length] == object) {
      return stackB[length] == other;
    }
  }
  // Add `object` and `other` to the stack of traversed objects.
  stackA.push(object);
  stackB.push(other);

  var result = (objIsArr ? equalArrays : equalObjects)(object, other, equalFunc, customizer, isLoose, stackA, stackB);

  stackA.pop();
  stackB.pop();

  return result;
}

module.exports = baseIsEqualDeep;

},{"354":354,"355":355,"356":356,"389":389,"396":396}],316:[function(_dereq_,module,exports){
var baseIsEqual = _dereq_(314),
    toObject = _dereq_(384);

/**
 * The base implementation of `_.isMatch` without support for callback
 * shorthands and `this` binding.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Array} matchData The propery names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparing objects.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = toObject(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var result = customizer ? customizer(objValue, srcValue, key) : undefined;
      if (!(result === undefined ? baseIsEqual(srcValue, objValue, customizer, true) : result)) {
        return false;
      }
    }
  }
  return true;
}

module.exports = baseIsMatch;

},{"314":314,"384":384}],317:[function(_dereq_,module,exports){
/**
 * The function whose prototype all chaining wrappers inherit from.
 *
 * @private
 */
function baseLodash() {
  // No operation performed.
}

module.exports = baseLodash;

},{}],318:[function(_dereq_,module,exports){
var baseEach = _dereq_(303),
    isArrayLike = _dereq_(366);

/**
 * The base implementation of `_.map` without support for callback shorthands
 * and `this` binding.
 *
 * @private
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function baseMap(collection, iteratee) {
  var index = -1,
      result = isArrayLike(collection) ? Array(collection.length) : [];

  baseEach(collection, function(value, key, collection) {
    result[++index] = iteratee(value, key, collection);
  });
  return result;
}

module.exports = baseMap;

},{"303":303,"366":366}],319:[function(_dereq_,module,exports){
var baseIsMatch = _dereq_(316),
    getMatchData = _dereq_(360),
    toObject = _dereq_(384);

/**
 * The base implementation of `_.matches` which does not clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new function.
 */
function baseMatches(source) {
  var matchData = getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    var key = matchData[0][0],
        value = matchData[0][1];

    return function(object) {
      if (object == null) {
        return false;
      }
      return object[key] === value && (value !== undefined || (key in toObject(object)));
    };
  }
  return function(object) {
    return baseIsMatch(object, matchData);
  };
}

module.exports = baseMatches;

},{"316":316,"360":360,"384":384}],320:[function(_dereq_,module,exports){
var baseGet = _dereq_(312),
    baseIsEqual = _dereq_(314),
    baseSlice = _dereq_(327),
    isArray = _dereq_(389),
    isKey = _dereq_(369),
    isStrictComparable = _dereq_(373),
    last = _dereq_(261),
    toObject = _dereq_(384),
    toPath = _dereq_(385);

/**
 * The base implementation of `_.matchesProperty` which does not clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to compare.
 * @returns {Function} Returns the new function.
 */
function baseMatchesProperty(path, srcValue) {
  var isArr = isArray(path),
      isCommon = isKey(path) && isStrictComparable(srcValue),
      pathKey = (path + '');

  path = toPath(path);
  return function(object) {
    if (object == null) {
      return false;
    }
    var key = pathKey;
    object = toObject(object);
    if ((isArr || !isCommon) && !(key in object)) {
      object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
      if (object == null) {
        return false;
      }
      key = last(path);
      object = toObject(object);
    }
    return object[key] === srcValue
      ? (srcValue !== undefined || (key in object))
      : baseIsEqual(srcValue, object[key], undefined, true);
  };
}

module.exports = baseMatchesProperty;

},{"261":261,"312":312,"314":314,"327":327,"369":369,"373":373,"384":384,"385":385,"389":389}],321:[function(_dereq_,module,exports){
var arrayEach = _dereq_(287),
    baseMergeDeep = _dereq_(322),
    isArray = _dereq_(389),
    isArrayLike = _dereq_(366),
    isObject = _dereq_(393),
    isObjectLike = _dereq_(372),
    isTypedArray = _dereq_(396),
    keys = _dereq_(399);

/**
 * The base implementation of `_.merge` without support for argument juggling,
 * multiple sources, and `this` binding `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Array} [stackA=[]] Tracks traversed source objects.
 * @param {Array} [stackB=[]] Associates values with source counterparts.
 * @returns {Object} Returns `object`.
 */
function baseMerge(object, source, customizer, stackA, stackB) {
  if (!isObject(object)) {
    return object;
  }
  var isSrcArr = isArrayLike(source) && (isArray(source) || isTypedArray(source)),
      props = isSrcArr ? undefined : keys(source);

  arrayEach(props || source, function(srcValue, key) {
    if (props) {
      key = srcValue;
      srcValue = source[key];
    }
    if (isObjectLike(srcValue)) {
      stackA || (stackA = []);
      stackB || (stackB = []);
      baseMergeDeep(object, source, key, baseMerge, customizer, stackA, stackB);
    }
    else {
      var value = object[key],
          result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
          isCommon = result === undefined;

      if (isCommon) {
        result = srcValue;
      }
      if ((result !== undefined || (isSrcArr && !(key in object))) &&
          (isCommon || (result === result ? (result !== value) : (value === value)))) {
        object[key] = result;
      }
    }
  });
  return object;
}

module.exports = baseMerge;

},{"287":287,"322":322,"366":366,"372":372,"389":389,"393":393,"396":396,"399":399}],322:[function(_dereq_,module,exports){
var arrayCopy = _dereq_(286),
    isArguments = _dereq_(388),
    isArray = _dereq_(389),
    isArrayLike = _dereq_(366),
    isPlainObject = _dereq_(394),
    isTypedArray = _dereq_(396),
    toPlainObject = _dereq_(397);

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Array} [stackA=[]] Tracks traversed source objects.
 * @param {Array} [stackB=[]] Associates values with source counterparts.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseMergeDeep(object, source, key, mergeFunc, customizer, stackA, stackB) {
  var length = stackA.length,
      srcValue = source[key];

  while (length--) {
    if (stackA[length] == srcValue) {
      object[key] = stackB[length];
      return;
    }
  }
  var value = object[key],
      result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
      isCommon = result === undefined;

  if (isCommon) {
    result = srcValue;
    if (isArrayLike(srcValue) && (isArray(srcValue) || isTypedArray(srcValue))) {
      result = isArray(value)
        ? value
        : (isArrayLike(value) ? arrayCopy(value) : []);
    }
    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
      result = isArguments(value)
        ? toPlainObject(value)
        : (isPlainObject(value) ? value : {});
    }
    else {
      isCommon = false;
    }
  }
  // Add the source value to the stack of traversed objects and associate
  // it with its merged value.
  stackA.push(srcValue);
  stackB.push(result);

  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    object[key] = mergeFunc(result, srcValue, customizer, stackA, stackB);
  } else if (result === result ? (result !== value) : (value === value)) {
    object[key] = result;
  }
}

module.exports = baseMergeDeep;

},{"286":286,"366":366,"388":388,"389":389,"394":394,"396":396,"397":397}],323:[function(_dereq_,module,exports){
/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

module.exports = baseProperty;

},{}],324:[function(_dereq_,module,exports){
var baseGet = _dereq_(312),
    toPath = _dereq_(385);

/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new function.
 */
function basePropertyDeep(path) {
  var pathKey = (path + '');
  path = toPath(path);
  return function(object) {
    return baseGet(object, path, pathKey);
  };
}

module.exports = basePropertyDeep;

},{"312":312,"385":385}],325:[function(_dereq_,module,exports){
/**
 * The base implementation of `_.reduce` and `_.reduceRight` without support
 * for callback shorthands and `this` binding, which iterates over `collection`
 * using the provided `eachFunc`.
 *
 * @private
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} accumulator The initial value.
 * @param {boolean} initFromCollection Specify using the first or last element
 *  of `collection` as the initial value.
 * @param {Function} eachFunc The function to iterate over `collection`.
 * @returns {*} Returns the accumulated value.
 */
function baseReduce(collection, iteratee, accumulator, initFromCollection, eachFunc) {
  eachFunc(collection, function(value, index, collection) {
    accumulator = initFromCollection
      ? (initFromCollection = false, value)
      : iteratee(accumulator, value, index, collection);
  });
  return accumulator;
}

module.exports = baseReduce;

},{}],326:[function(_dereq_,module,exports){
var identity = _dereq_(407),
    metaMap = _dereq_(375);

/**
 * The base implementation of `setData` without support for hot loop detection.
 *
 * @private
 * @param {Function} func The function to associate metadata with.
 * @param {*} data The metadata.
 * @returns {Function} Returns `func`.
 */
var baseSetData = !metaMap ? identity : function(func, data) {
  metaMap.set(func, data);
  return func;
};

module.exports = baseSetData;

},{"375":375,"407":407}],327:[function(_dereq_,module,exports){
/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  start = start == null ? 0 : (+start || 0);
  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = (end === undefined || end > length) ? length : (+end || 0);
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

module.exports = baseSlice;

},{}],328:[function(_dereq_,module,exports){
var baseEach = _dereq_(303);

/**
 * The base implementation of `_.some` without support for callback shorthands
 * and `this` binding.
 *
 * @private
 * @param {Array|Object|string} collection The collection to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function baseSome(collection, predicate) {
  var result;

  baseEach(collection, function(value, index, collection) {
    result = predicate(value, index, collection);
    return !result;
  });
  return !!result;
}

module.exports = baseSome;

},{"303":303}],329:[function(_dereq_,module,exports){
/**
 * The base implementation of `_.sortBy` which uses `comparer` to define
 * the sort order of `array` and replaces criteria objects with their
 * corresponding values.
 *
 * @private
 * @param {Array} array The array to sort.
 * @param {Function} comparer The function to define sort order.
 * @returns {Array} Returns `array`.
 */
function baseSortBy(array, comparer) {
  var length = array.length;

  array.sort(comparer);
  while (length--) {
    array[length] = array[length].value;
  }
  return array;
}

module.exports = baseSortBy;

},{}],330:[function(_dereq_,module,exports){
/**
 * Converts `value` to a string if it's not one. An empty string is returned
 * for `null` or `undefined` values.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  return value == null ? '' : (value + '');
}

module.exports = baseToString;

},{}],331:[function(_dereq_,module,exports){
var baseIndexOf = _dereq_(313),
    cacheIndexOf = _dereq_(335),
    createCache = _dereq_(345);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.uniq` without support for callback shorthands
 * and `this` binding.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The function invoked per iteration.
 * @returns {Array} Returns the new duplicate free array.
 */
function baseUniq(array, iteratee) {
  var index = -1,
      indexOf = baseIndexOf,
      length = array.length,
      isCommon = true,
      isLarge = isCommon && length >= LARGE_ARRAY_SIZE,
      seen = isLarge ? createCache() : null,
      result = [];

  if (seen) {
    indexOf = cacheIndexOf;
    isCommon = false;
  } else {
    isLarge = false;
    seen = iteratee ? [] : result;
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee ? iteratee(value, index, array) : value;

    if (isCommon && value === value) {
      var seenIndex = seen.length;
      while (seenIndex--) {
        if (seen[seenIndex] === computed) {
          continue outer;
        }
      }
      if (iteratee) {
        seen.push(computed);
      }
      result.push(value);
    }
    else if (indexOf(seen, computed, 0) < 0) {
      if (iteratee || isLarge) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}

module.exports = baseUniq;

},{"313":313,"335":335,"345":345}],332:[function(_dereq_,module,exports){
/**
 * The base implementation of `_.values` and `_.valuesIn` which creates an
 * array of `object` property values corresponding to the property names
 * of `props`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array} props The property names to get values for.
 * @returns {Object} Returns the array of property values.
 */
function baseValues(object, props) {
  var index = -1,
      length = props.length,
      result = Array(length);

  while (++index < length) {
    result[index] = object[props[index]];
  }
  return result;
}

module.exports = baseValues;

},{}],333:[function(_dereq_,module,exports){
var identity = _dereq_(407);

/**
 * A specialized version of `baseCallback` which only supports `this` binding
 * and specifying the number of arguments to provide to `func`.
 *
 * @private
 * @param {Function} func The function to bind.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {number} [argCount] The number of arguments to provide to `func`.
 * @returns {Function} Returns the callback.
 */
function bindCallback(func, thisArg, argCount) {
  if (typeof func != 'function') {
    return identity;
  }
  if (thisArg === undefined) {
    return func;
  }
  switch (argCount) {
    case 1: return function(value) {
      return func.call(thisArg, value);
    };
    case 3: return function(value, index, collection) {
      return func.call(thisArg, value, index, collection);
    };
    case 4: return function(accumulator, value, index, collection) {
      return func.call(thisArg, accumulator, value, index, collection);
    };
    case 5: return function(value, other, key, object, source) {
      return func.call(thisArg, value, other, key, object, source);
    };
  }
  return function() {
    return func.apply(thisArg, arguments);
  };
}

module.exports = bindCallback;

},{"407":407}],334:[function(_dereq_,module,exports){
(function (global){
/** Native method references. */
var ArrayBuffer = global.ArrayBuffer,
    Uint8Array = global.Uint8Array;

/**
 * Creates a clone of the given array buffer.
 *
 * @private
 * @param {ArrayBuffer} buffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function bufferClone(buffer) {
  var result = new ArrayBuffer(buffer.byteLength),
      view = new Uint8Array(result);

  view.set(new Uint8Array(buffer));
  return result;
}

module.exports = bufferClone;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{}],335:[function(_dereq_,module,exports){
var isObject = _dereq_(393);

/**
 * Checks if `value` is in `cache` mimicking the return signature of
 * `_.indexOf` by returning `0` if the value is found, else `-1`.
 *
 * @private
 * @param {Object} cache The cache to search.
 * @param {*} value The value to search for.
 * @returns {number} Returns `0` if `value` is found, else `-1`.
 */
function cacheIndexOf(cache, value) {
  var data = cache.data,
      result = (typeof value == 'string' || isObject(value)) ? data.set.has(value) : data.hash[value];

  return result ? 0 : -1;
}

module.exports = cacheIndexOf;

},{"393":393}],336:[function(_dereq_,module,exports){
var isObject = _dereq_(393);

/**
 * Adds `value` to the cache.
 *
 * @private
 * @name push
 * @memberOf SetCache
 * @param {*} value The value to cache.
 */
function cachePush(value) {
  var data = this.data;
  if (typeof value == 'string' || isObject(value)) {
    data.set.add(value);
  } else {
    data.hash[value] = true;
  }
}

module.exports = cachePush;

},{"393":393}],337:[function(_dereq_,module,exports){
var baseCompareAscending = _dereq_(298);

/**
 * Used by `_.sortBy` to compare transformed elements of a collection and stable
 * sort them in ascending order.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @returns {number} Returns the sort order indicator for `object`.
 */
function compareAscending(object, other) {
  return baseCompareAscending(object.criteria, other.criteria) || (object.index - other.index);
}

module.exports = compareAscending;

},{"298":298}],338:[function(_dereq_,module,exports){
/* Native method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * Creates an array that is the composition of partially applied arguments,
 * placeholders, and provided arguments into a single array of arguments.
 *
 * @private
 * @param {Array|Object} args The provided arguments.
 * @param {Array} partials The arguments to prepend to those provided.
 * @param {Array} holders The `partials` placeholder indexes.
 * @returns {Array} Returns the new array of composed arguments.
 */
function composeArgs(args, partials, holders) {
  var holdersLength = holders.length,
      argsIndex = -1,
      argsLength = nativeMax(args.length - holdersLength, 0),
      leftIndex = -1,
      leftLength = partials.length,
      result = Array(leftLength + argsLength);

  while (++leftIndex < leftLength) {
    result[leftIndex] = partials[leftIndex];
  }
  while (++argsIndex < holdersLength) {
    result[holders[argsIndex]] = args[argsIndex];
  }
  while (argsLength--) {
    result[leftIndex++] = args[argsIndex++];
  }
  return result;
}

module.exports = composeArgs;

},{}],339:[function(_dereq_,module,exports){
/* Native method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * This function is like `composeArgs` except that the arguments composition
 * is tailored for `_.partialRight`.
 *
 * @private
 * @param {Array|Object} args The provided arguments.
 * @param {Array} partials The arguments to append to those provided.
 * @param {Array} holders The `partials` placeholder indexes.
 * @returns {Array} Returns the new array of composed arguments.
 */
function composeArgsRight(args, partials, holders) {
  var holdersIndex = -1,
      holdersLength = holders.length,
      argsIndex = -1,
      argsLength = nativeMax(args.length - holdersLength, 0),
      rightIndex = -1,
      rightLength = partials.length,
      result = Array(argsLength + rightLength);

  while (++argsIndex < argsLength) {
    result[argsIndex] = args[argsIndex];
  }
  var offset = argsIndex;
  while (++rightIndex < rightLength) {
    result[offset + rightIndex] = partials[rightIndex];
  }
  while (++holdersIndex < holdersLength) {
    result[offset + holders[holdersIndex]] = args[argsIndex++];
  }
  return result;
}

module.exports = composeArgsRight;

},{}],340:[function(_dereq_,module,exports){
var baseCallback = _dereq_(296),
    baseEach = _dereq_(303),
    isArray = _dereq_(389);

/**
 * Creates a `_.countBy`, `_.groupBy`, `_.indexBy`, or `_.partition` function.
 *
 * @private
 * @param {Function} setter The function to set keys and values of the accumulator object.
 * @param {Function} [initializer] The function to initialize the accumulator object.
 * @returns {Function} Returns the new aggregator function.
 */
function createAggregator(setter, initializer) {
  return function(collection, iteratee, thisArg) {
    var result = initializer ? initializer() : {};
    iteratee = baseCallback(iteratee, thisArg, 3);

    if (isArray(collection)) {
      var index = -1,
          length = collection.length;

      while (++index < length) {
        var value = collection[index];
        setter(result, value, iteratee(value, index, collection), collection);
      }
    } else {
      baseEach(collection, function(value, key, collection) {
        setter(result, value, iteratee(value, key, collection), collection);
      });
    }
    return result;
  };
}

module.exports = createAggregator;

},{"296":296,"303":303,"389":389}],341:[function(_dereq_,module,exports){
var bindCallback = _dereq_(333),
    isIterateeCall = _dereq_(368),
    restParam = _dereq_(282);

/**
 * Creates a `_.assign`, `_.defaults`, or `_.merge` function.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return restParam(function(object, sources) {
    var index = -1,
        length = object == null ? 0 : sources.length,
        customizer = length > 2 ? sources[length - 2] : undefined,
        guard = length > 2 ? sources[2] : undefined,
        thisArg = length > 1 ? sources[length - 1] : undefined;

    if (typeof customizer == 'function') {
      customizer = bindCallback(customizer, thisArg, 5);
      length -= 2;
    } else {
      customizer = typeof thisArg == 'function' ? thisArg : undefined;
      length -= (customizer ? 1 : 0);
    }
    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, customizer);
      }
    }
    return object;
  });
}

module.exports = createAssigner;

},{"282":282,"333":333,"368":368}],342:[function(_dereq_,module,exports){
var getLength = _dereq_(359),
    isLength = _dereq_(371),
    toObject = _dereq_(384);

/**
 * Creates a `baseEach` or `baseEachRight` function.
 *
 * @private
 * @param {Function} eachFunc The function to iterate over a collection.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseEach(eachFunc, fromRight) {
  return function(collection, iteratee) {
    var length = collection ? getLength(collection) : 0;
    if (!isLength(length)) {
      return eachFunc(collection, iteratee);
    }
    var index = fromRight ? length : -1,
        iterable = toObject(collection);

    while ((fromRight ? index-- : ++index < length)) {
      if (iteratee(iterable[index], index, iterable) === false) {
        break;
      }
    }
    return collection;
  };
}

module.exports = createBaseEach;

},{"359":359,"371":371,"384":384}],343:[function(_dereq_,module,exports){
var toObject = _dereq_(384);

/**
 * Creates a base function for `_.forIn` or `_.forInRight`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var iterable = toObject(object),
        props = keysFunc(object),
        length = props.length,
        index = fromRight ? length : -1;

    while ((fromRight ? index-- : ++index < length)) {
      var key = props[index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

module.exports = createBaseFor;

},{"384":384}],344:[function(_dereq_,module,exports){
(function (global){
var createCtorWrapper = _dereq_(346);

/**
 * Creates a function that wraps `func` and invokes it with the `this`
 * binding of `thisArg`.
 *
 * @private
 * @param {Function} func The function to bind.
 * @param {*} [thisArg] The `this` binding of `func`.
 * @returns {Function} Returns the new bound function.
 */
function createBindWrapper(func, thisArg) {
  var Ctor = createCtorWrapper(func);

  function wrapper() {
    var fn = (this && this !== global && this instanceof wrapper) ? Ctor : func;
    return fn.apply(thisArg, arguments);
  }
  return wrapper;
}

module.exports = createBindWrapper;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{"346":346}],345:[function(_dereq_,module,exports){
(function (global){
var SetCache = _dereq_(285),
    getNative = _dereq_(361);

/** Native method references. */
var Set = getNative(global, 'Set');

/* Native method references for those with the same name as other `lodash` methods. */
var nativeCreate = getNative(Object, 'create');

/**
 * Creates a `Set` cache object to optimize linear searches of large arrays.
 *
 * @private
 * @param {Array} [values] The values to cache.
 * @returns {null|Object} Returns the new cache object if `Set` is supported, else `null`.
 */
function createCache(values) {
  return (nativeCreate && Set) ? new SetCache(values) : null;
}

module.exports = createCache;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{"285":285,"361":361}],346:[function(_dereq_,module,exports){
var baseCreate = _dereq_(300),
    isObject = _dereq_(393);

/**
 * Creates a function that produces an instance of `Ctor` regardless of
 * whether it was invoked as part of a `new` expression or by `call` or `apply`.
 *
 * @private
 * @param {Function} Ctor The constructor to wrap.
 * @returns {Function} Returns the new wrapped function.
 */
function createCtorWrapper(Ctor) {
  return function() {
    // Use a `switch` statement to work with class constructors.
    // See http://ecma-international.org/ecma-262/6.0/#sec-ecmascript-function-objects-call-thisargument-argumentslist
    // for more details.
    var args = arguments;
    switch (args.length) {
      case 0: return new Ctor;
      case 1: return new Ctor(args[0]);
      case 2: return new Ctor(args[0], args[1]);
      case 3: return new Ctor(args[0], args[1], args[2]);
      case 4: return new Ctor(args[0], args[1], args[2], args[3]);
      case 5: return new Ctor(args[0], args[1], args[2], args[3], args[4]);
      case 6: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
      case 7: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
    }
    var thisBinding = baseCreate(Ctor.prototype),
        result = Ctor.apply(thisBinding, args);

    // Mimic the constructor's `return` behavior.
    // See https://es5.github.io/#x13.2.2 for more details.
    return isObject(result) ? result : thisBinding;
  };
}

module.exports = createCtorWrapper;

},{"300":300,"393":393}],347:[function(_dereq_,module,exports){
var baseCallback = _dereq_(296),
    baseFind = _dereq_(306),
    baseFindIndex = _dereq_(307),
    isArray = _dereq_(389);

/**
 * Creates a `_.find` or `_.findLast` function.
 *
 * @private
 * @param {Function} eachFunc The function to iterate over a collection.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new find function.
 */
function createFind(eachFunc, fromRight) {
  return function(collection, predicate, thisArg) {
    predicate = baseCallback(predicate, thisArg, 3);
    if (isArray(collection)) {
      var index = baseFindIndex(collection, predicate, fromRight);
      return index > -1 ? collection[index] : undefined;
    }
    return baseFind(collection, predicate, eachFunc);
  };
}

module.exports = createFind;

},{"296":296,"306":306,"307":307,"389":389}],348:[function(_dereq_,module,exports){
var baseCallback = _dereq_(296),
    baseFindIndex = _dereq_(307);

/**
 * Creates a `_.findIndex` or `_.findLastIndex` function.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new find function.
 */
function createFindIndex(fromRight) {
  return function(array, predicate, thisArg) {
    if (!(array && array.length)) {
      return -1;
    }
    predicate = baseCallback(predicate, thisArg, 3);
    return baseFindIndex(array, predicate, fromRight);
  };
}

module.exports = createFindIndex;

},{"296":296,"307":307}],349:[function(_dereq_,module,exports){
var bindCallback = _dereq_(333),
    isArray = _dereq_(389);

/**
 * Creates a function for `_.forEach` or `_.forEachRight`.
 *
 * @private
 * @param {Function} arrayFunc The function to iterate over an array.
 * @param {Function} eachFunc The function to iterate over a collection.
 * @returns {Function} Returns the new each function.
 */
function createForEach(arrayFunc, eachFunc) {
  return function(collection, iteratee, thisArg) {
    return (typeof iteratee == 'function' && thisArg === undefined && isArray(collection))
      ? arrayFunc(collection, iteratee)
      : eachFunc(collection, bindCallback(iteratee, thisArg, 3));
  };
}

module.exports = createForEach;

},{"333":333,"389":389}],350:[function(_dereq_,module,exports){
(function (global){
var arrayCopy = _dereq_(286),
    composeArgs = _dereq_(338),
    composeArgsRight = _dereq_(339),
    createCtorWrapper = _dereq_(346),
    isLaziable = _dereq_(370),
    reorder = _dereq_(379),
    replaceHolders = _dereq_(380),
    setData = _dereq_(381);

/** Used to compose bitmasks for wrapper metadata. */
var BIND_FLAG = 1,
    BIND_KEY_FLAG = 2,
    CURRY_BOUND_FLAG = 4,
    CURRY_FLAG = 8,
    CURRY_RIGHT_FLAG = 16,
    PARTIAL_FLAG = 32,
    PARTIAL_RIGHT_FLAG = 64,
    ARY_FLAG = 128;

/* Native method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * Creates a function that wraps `func` and invokes it with optional `this`
 * binding of, partial application, and currying.
 *
 * @private
 * @param {Function|string} func The function or method name to reference.
 * @param {number} bitmask The bitmask of flags. See `createWrapper` for more details.
 * @param {*} [thisArg] The `this` binding of `func`.
 * @param {Array} [partials] The arguments to prepend to those provided to the new function.
 * @param {Array} [holders] The `partials` placeholder indexes.
 * @param {Array} [partialsRight] The arguments to append to those provided to the new function.
 * @param {Array} [holdersRight] The `partialsRight` placeholder indexes.
 * @param {Array} [argPos] The argument positions of the new function.
 * @param {number} [ary] The arity cap of `func`.
 * @param {number} [arity] The arity of `func`.
 * @returns {Function} Returns the new wrapped function.
 */
function createHybridWrapper(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
  var isAry = bitmask & ARY_FLAG,
      isBind = bitmask & BIND_FLAG,
      isBindKey = bitmask & BIND_KEY_FLAG,
      isCurry = bitmask & CURRY_FLAG,
      isCurryBound = bitmask & CURRY_BOUND_FLAG,
      isCurryRight = bitmask & CURRY_RIGHT_FLAG,
      Ctor = isBindKey ? undefined : createCtorWrapper(func);

  function wrapper() {
    // Avoid `arguments` object use disqualifying optimizations by
    // converting it to an array before providing it to other functions.
    var length = arguments.length,
        index = length,
        args = Array(length);

    while (index--) {
      args[index] = arguments[index];
    }
    if (partials) {
      args = composeArgs(args, partials, holders);
    }
    if (partialsRight) {
      args = composeArgsRight(args, partialsRight, holdersRight);
    }
    if (isCurry || isCurryRight) {
      var placeholder = wrapper.placeholder,
          argsHolders = replaceHolders(args, placeholder);

      length -= argsHolders.length;
      if (length < arity) {
        var newArgPos = argPos ? arrayCopy(argPos) : undefined,
            newArity = nativeMax(arity - length, 0),
            newsHolders = isCurry ? argsHolders : undefined,
            newHoldersRight = isCurry ? undefined : argsHolders,
            newPartials = isCurry ? args : undefined,
            newPartialsRight = isCurry ? undefined : args;

        bitmask |= (isCurry ? PARTIAL_FLAG : PARTIAL_RIGHT_FLAG);
        bitmask &= ~(isCurry ? PARTIAL_RIGHT_FLAG : PARTIAL_FLAG);

        if (!isCurryBound) {
          bitmask &= ~(BIND_FLAG | BIND_KEY_FLAG);
        }
        var newData = [func, bitmask, thisArg, newPartials, newsHolders, newPartialsRight, newHoldersRight, newArgPos, ary, newArity],
            result = createHybridWrapper.apply(undefined, newData);

        if (isLaziable(func)) {
          setData(result, newData);
        }
        result.placeholder = placeholder;
        return result;
      }
    }
    var thisBinding = isBind ? thisArg : this,
        fn = isBindKey ? thisBinding[func] : func;

    if (argPos) {
      args = reorder(args, argPos);
    }
    if (isAry && ary < args.length) {
      args.length = ary;
    }
    if (this && this !== global && this instanceof wrapper) {
      fn = Ctor || createCtorWrapper(func);
    }
    return fn.apply(thisBinding, args);
  }
  return wrapper;
}

module.exports = createHybridWrapper;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{"286":286,"338":338,"339":339,"346":346,"370":370,"379":379,"380":380,"381":381}],351:[function(_dereq_,module,exports){
(function (global){
var createCtorWrapper = _dereq_(346);

/** Used to compose bitmasks for wrapper metadata. */
var BIND_FLAG = 1;

/**
 * Creates a function that wraps `func` and invokes it with the optional `this`
 * binding of `thisArg` and the `partials` prepended to those provided to
 * the wrapper.
 *
 * @private
 * @param {Function} func The function to partially apply arguments to.
 * @param {number} bitmask The bitmask of flags. See `createWrapper` for more details.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} partials The arguments to prepend to those provided to the new function.
 * @returns {Function} Returns the new bound function.
 */
function createPartialWrapper(func, bitmask, thisArg, partials) {
  var isBind = bitmask & BIND_FLAG,
      Ctor = createCtorWrapper(func);

  function wrapper() {
    // Avoid `arguments` object use disqualifying optimizations by
    // converting it to an array before providing it `func`.
    var argsIndex = -1,
        argsLength = arguments.length,
        leftIndex = -1,
        leftLength = partials.length,
        args = Array(leftLength + argsLength);

    while (++leftIndex < leftLength) {
      args[leftIndex] = partials[leftIndex];
    }
    while (argsLength--) {
      args[leftIndex++] = arguments[++argsIndex];
    }
    var fn = (this && this !== global && this instanceof wrapper) ? Ctor : func;
    return fn.apply(isBind ? thisArg : this, args);
  }
  return wrapper;
}

module.exports = createPartialWrapper;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{"346":346}],352:[function(_dereq_,module,exports){
var baseCallback = _dereq_(296),
    baseReduce = _dereq_(325),
    isArray = _dereq_(389);

/**
 * Creates a function for `_.reduce` or `_.reduceRight`.
 *
 * @private
 * @param {Function} arrayFunc The function to iterate over an array.
 * @param {Function} eachFunc The function to iterate over a collection.
 * @returns {Function} Returns the new each function.
 */
function createReduce(arrayFunc, eachFunc) {
  return function(collection, iteratee, accumulator, thisArg) {
    var initFromArray = arguments.length < 3;
    return (typeof iteratee == 'function' && thisArg === undefined && isArray(collection))
      ? arrayFunc(collection, iteratee, accumulator, initFromArray)
      : baseReduce(collection, baseCallback(iteratee, thisArg, 4), accumulator, initFromArray, eachFunc);
  };
}

module.exports = createReduce;

},{"296":296,"325":325,"389":389}],353:[function(_dereq_,module,exports){
var baseSetData = _dereq_(326),
    createBindWrapper = _dereq_(344),
    createHybridWrapper = _dereq_(350),
    createPartialWrapper = _dereq_(351),
    getData = _dereq_(357),
    mergeData = _dereq_(374),
    setData = _dereq_(381);

/** Used to compose bitmasks for wrapper metadata. */
var BIND_FLAG = 1,
    BIND_KEY_FLAG = 2,
    PARTIAL_FLAG = 32,
    PARTIAL_RIGHT_FLAG = 64;

/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/* Native method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * Creates a function that either curries or invokes `func` with optional
 * `this` binding and partially applied arguments.
 *
 * @private
 * @param {Function|string} func The function or method name to reference.
 * @param {number} bitmask The bitmask of flags.
 *  The bitmask may be composed of the following flags:
 *     1 - `_.bind`
 *     2 - `_.bindKey`
 *     4 - `_.curry` or `_.curryRight` of a bound function
 *     8 - `_.curry`
 *    16 - `_.curryRight`
 *    32 - `_.partial`
 *    64 - `_.partialRight`
 *   128 - `_.rearg`
 *   256 - `_.ary`
 * @param {*} [thisArg] The `this` binding of `func`.
 * @param {Array} [partials] The arguments to be partially applied.
 * @param {Array} [holders] The `partials` placeholder indexes.
 * @param {Array} [argPos] The argument positions of the new function.
 * @param {number} [ary] The arity cap of `func`.
 * @param {number} [arity] The arity of `func`.
 * @returns {Function} Returns the new wrapped function.
 */
function createWrapper(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
  var isBindKey = bitmask & BIND_KEY_FLAG;
  if (!isBindKey && typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var length = partials ? partials.length : 0;
  if (!length) {
    bitmask &= ~(PARTIAL_FLAG | PARTIAL_RIGHT_FLAG);
    partials = holders = undefined;
  }
  length -= (holders ? holders.length : 0);
  if (bitmask & PARTIAL_RIGHT_FLAG) {
    var partialsRight = partials,
        holdersRight = holders;

    partials = holders = undefined;
  }
  var data = isBindKey ? undefined : getData(func),
      newData = [func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity];

  if (data) {
    mergeData(newData, data);
    bitmask = newData[1];
    arity = newData[9];
  }
  newData[9] = arity == null
    ? (isBindKey ? 0 : func.length)
    : (nativeMax(arity - length, 0) || 0);

  if (bitmask == BIND_FLAG) {
    var result = createBindWrapper(newData[0], newData[2]);
  } else if ((bitmask == PARTIAL_FLAG || bitmask == (BIND_FLAG | PARTIAL_FLAG)) && !newData[4].length) {
    result = createPartialWrapper.apply(undefined, newData);
  } else {
    result = createHybridWrapper.apply(undefined, newData);
  }
  var setter = data ? baseSetData : setData;
  return setter(result, newData);
}

module.exports = createWrapper;

},{"326":326,"344":344,"350":350,"351":351,"357":357,"374":374,"381":381}],354:[function(_dereq_,module,exports){
var arraySome = _dereq_(293);

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Function} [customizer] The function to customize comparing arrays.
 * @param {boolean} [isLoose] Specify performing partial comparisons.
 * @param {Array} [stackA] Tracks traversed `value` objects.
 * @param {Array} [stackB] Tracks traversed `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, equalFunc, customizer, isLoose, stackA, stackB) {
  var index = -1,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isLoose && othLength > arrLength)) {
    return false;
  }
  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index],
        result = customizer ? customizer(isLoose ? othValue : arrValue, isLoose ? arrValue : othValue, index) : undefined;

    if (result !== undefined) {
      if (result) {
        continue;
      }
      return false;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (isLoose) {
      if (!arraySome(other, function(othValue) {
            return arrValue === othValue || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB);
          })) {
        return false;
      }
    } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB))) {
      return false;
    }
  }
  return true;
}

module.exports = equalArrays;

},{"293":293}],355:[function(_dereq_,module,exports){
/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    stringTag = '[object String]';

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag) {
  switch (tag) {
    case boolTag:
    case dateTag:
      // Coerce dates and booleans to numbers, dates to milliseconds and booleans
      // to `1` or `0` treating invalid dates coerced to `NaN` as not equal.
      return +object == +other;

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case numberTag:
      // Treat `NaN` vs. `NaN` as equal.
      return (object != +object)
        ? other != +other
        : object == +other;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings primitives and string
      // objects as equal. See https://es5.github.io/#x15.10.6.4 for more details.
      return object == (other + '');
  }
  return false;
}

module.exports = equalByTag;

},{}],356:[function(_dereq_,module,exports){
var keys = _dereq_(399);

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Function} [customizer] The function to customize comparing values.
 * @param {boolean} [isLoose] Specify performing partial comparisons.
 * @param {Array} [stackA] Tracks traversed `value` objects.
 * @param {Array} [stackB] Tracks traversed `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
  var objProps = keys(object),
      objLength = objProps.length,
      othProps = keys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isLoose) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isLoose ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  var skipCtor = isLoose;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key],
        result = customizer ? customizer(isLoose ? othValue : objValue, isLoose? objValue : othValue, key) : undefined;

    // Recursively compare objects (susceptible to call stack limits).
    if (!(result === undefined ? equalFunc(objValue, othValue, customizer, isLoose, stackA, stackB) : result)) {
      return false;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (!skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      return false;
    }
  }
  return true;
}

module.exports = equalObjects;

},{"399":399}],357:[function(_dereq_,module,exports){
var metaMap = _dereq_(375),
    noop = _dereq_(408);

/**
 * Gets metadata for `func`.
 *
 * @private
 * @param {Function} func The function to query.
 * @returns {*} Returns the metadata for `func`.
 */
var getData = !metaMap ? noop : function(func) {
  return metaMap.get(func);
};

module.exports = getData;

},{"375":375,"408":408}],358:[function(_dereq_,module,exports){
var realNames = _dereq_(378);

/**
 * Gets the name of `func`.
 *
 * @private
 * @param {Function} func The function to query.
 * @returns {string} Returns the function name.
 */
function getFuncName(func) {
  var result = (func.name + ''),
      array = realNames[result],
      length = array ? array.length : 0;

  while (length--) {
    var data = array[length],
        otherFunc = data.func;
    if (otherFunc == null || otherFunc == func) {
      return data.name;
    }
  }
  return result;
}

module.exports = getFuncName;

},{"378":378}],359:[function(_dereq_,module,exports){
var baseProperty = _dereq_(323);

/**
 * Gets the "length" property value of `object`.
 *
 * **Note:** This function is used to avoid a [JIT bug](https://bugs.webkit.org/show_bug.cgi?id=142792)
 * that affects Safari on at least iOS 8.1-8.3 ARM64.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {*} Returns the "length" value.
 */
var getLength = baseProperty('length');

module.exports = getLength;

},{"323":323}],360:[function(_dereq_,module,exports){
var isStrictComparable = _dereq_(373),
    pairs = _dereq_(403);

/**
 * Gets the propery names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = pairs(object),
      length = result.length;

  while (length--) {
    result[length][2] = isStrictComparable(result[length][1]);
  }
  return result;
}

module.exports = getMatchData;

},{"373":373,"403":403}],361:[function(_dereq_,module,exports){
var isNative = _dereq_(391);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = object == null ? undefined : object[key];
  return isNative(value) ? value : undefined;
}

module.exports = getNative;

},{"391":391}],362:[function(_dereq_,module,exports){
/**
 * Gets the index at which the first occurrence of `NaN` is found in `array`.
 *
 * @private
 * @param {Array} array The array to search.
 * @param {number} fromIndex The index to search from.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched `NaN`, else `-1`.
 */
function indexOfNaN(array, fromIndex, fromRight) {
  var length = array.length,
      index = fromIndex + (fromRight ? 0 : -1);

  while ((fromRight ? index-- : ++index < length)) {
    var other = array[index];
    if (other !== other) {
      return index;
    }
  }
  return -1;
}

module.exports = indexOfNaN;

},{}],363:[function(_dereq_,module,exports){
/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Initializes an array clone.
 *
 * @private
 * @param {Array} array The array to clone.
 * @returns {Array} Returns the initialized clone.
 */
function initCloneArray(array) {
  var length = array.length,
      result = new array.constructor(length);

  // Add array properties assigned by `RegExp#exec`.
  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
    result.index = array.index;
    result.input = array.input;
  }
  return result;
}

module.exports = initCloneArray;

},{}],364:[function(_dereq_,module,exports){
var bufferClone = _dereq_(334);

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    stringTag = '[object String]';

var arrayBufferTag = '[object ArrayBuffer]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to match `RegExp` flags from their coerced string values. */
var reFlags = /\w*$/;

/**
 * Initializes an object clone based on its `toStringTag`.
 *
 * **Note:** This function only supports cloning values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to clone.
 * @param {string} tag The `toStringTag` of the object to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneByTag(object, tag, isDeep) {
  var Ctor = object.constructor;
  switch (tag) {
    case arrayBufferTag:
      return bufferClone(object);

    case boolTag:
    case dateTag:
      return new Ctor(+object);

    case float32Tag: case float64Tag:
    case int8Tag: case int16Tag: case int32Tag:
    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
      var buffer = object.buffer;
      return new Ctor(isDeep ? bufferClone(buffer) : buffer, object.byteOffset, object.length);

    case numberTag:
    case stringTag:
      return new Ctor(object);

    case regexpTag:
      var result = new Ctor(object.source, reFlags.exec(object));
      result.lastIndex = object.lastIndex;
  }
  return result;
}

module.exports = initCloneByTag;

},{"334":334}],365:[function(_dereq_,module,exports){
/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  var Ctor = object.constructor;
  if (!(typeof Ctor == 'function' && Ctor instanceof Ctor)) {
    Ctor = Object;
  }
  return new Ctor;
}

module.exports = initCloneObject;

},{}],366:[function(_dereq_,module,exports){
var getLength = _dereq_(359),
    isLength = _dereq_(371);

/**
 * Checks if `value` is array-like.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 */
function isArrayLike(value) {
  return value != null && isLength(getLength(value));
}

module.exports = isArrayLike;

},{"359":359,"371":371}],367:[function(_dereq_,module,exports){
/** Used to detect unsigned integer values. */
var reIsUint = /^\d+$/;

/**
 * Used as the [maximum length](http://ecma-international.org/ecma-262/6.0/#sec-number.max_safe_integer)
 * of an array-like value.
 */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  value = (typeof value == 'number' || reIsUint.test(value)) ? +value : -1;
  length = length == null ? MAX_SAFE_INTEGER : length;
  return value > -1 && value % 1 == 0 && value < length;
}

module.exports = isIndex;

},{}],368:[function(_dereq_,module,exports){
var isArrayLike = _dereq_(366),
    isIndex = _dereq_(367),
    isObject = _dereq_(393);

/**
 * Checks if the provided arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call, else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
      ? (isArrayLike(object) && isIndex(index, object.length))
      : (type == 'string' && index in object)) {
    var other = object[index];
    return value === value ? (value === other) : (other !== other);
  }
  return false;
}

module.exports = isIterateeCall;

},{"366":366,"367":367,"393":393}],369:[function(_dereq_,module,exports){
var isArray = _dereq_(389),
    toObject = _dereq_(384);

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\n\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  var type = typeof value;
  if ((type == 'string' && reIsPlainProp.test(value)) || type == 'number') {
    return true;
  }
  if (isArray(value)) {
    return false;
  }
  var result = !reIsDeepProp.test(value);
  return result || (object != null && value in toObject(object));
}

module.exports = isKey;

},{"384":384,"389":389}],370:[function(_dereq_,module,exports){
var LazyWrapper = _dereq_(283),
    getData = _dereq_(357),
    getFuncName = _dereq_(358),
    lodash = _dereq_(266);

/**
 * Checks if `func` has a lazy counterpart.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` has a lazy counterpart, else `false`.
 */
function isLaziable(func) {
  var funcName = getFuncName(func),
      other = lodash[funcName];

  if (typeof other != 'function' || !(funcName in LazyWrapper.prototype)) {
    return false;
  }
  if (func === other) {
    return true;
  }
  var data = getData(other);
  return !!data && func === data[0];
}

module.exports = isLaziable;

},{"266":266,"283":283,"357":357,"358":358}],371:[function(_dereq_,module,exports){
/**
 * Used as the [maximum length](http://ecma-international.org/ecma-262/6.0/#sec-number.max_safe_integer)
 * of an array-like value.
 */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This function is based on [`ToLength`](http://ecma-international.org/ecma-262/6.0/#sec-tolength).
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 */
function isLength(value) {
  return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;

},{}],372:[function(_dereq_,module,exports){
/**
 * Checks if `value` is object-like.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

module.exports = isObjectLike;

},{}],373:[function(_dereq_,module,exports){
var isObject = _dereq_(393);

/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !isObject(value);
}

module.exports = isStrictComparable;

},{"393":393}],374:[function(_dereq_,module,exports){
var arrayCopy = _dereq_(286),
    composeArgs = _dereq_(338),
    composeArgsRight = _dereq_(339),
    replaceHolders = _dereq_(380);

/** Used to compose bitmasks for wrapper metadata. */
var BIND_FLAG = 1,
    CURRY_BOUND_FLAG = 4,
    CURRY_FLAG = 8,
    ARY_FLAG = 128,
    REARG_FLAG = 256;

/** Used as the internal argument placeholder. */
var PLACEHOLDER = '__lodash_placeholder__';

/* Native method references for those with the same name as other `lodash` methods. */
var nativeMin = Math.min;

/**
 * Merges the function metadata of `source` into `data`.
 *
 * Merging metadata reduces the number of wrappers required to invoke a function.
 * This is possible because methods like `_.bind`, `_.curry`, and `_.partial`
 * may be applied regardless of execution order. Methods like `_.ary` and `_.rearg`
 * augment function arguments, making the order in which they are executed important,
 * preventing the merging of metadata. However, we make an exception for a safe
 * common case where curried functions have `_.ary` and or `_.rearg` applied.
 *
 * @private
 * @param {Array} data The destination metadata.
 * @param {Array} source The source metadata.
 * @returns {Array} Returns `data`.
 */
function mergeData(data, source) {
  var bitmask = data[1],
      srcBitmask = source[1],
      newBitmask = bitmask | srcBitmask,
      isCommon = newBitmask < ARY_FLAG;

  var isCombo =
    (srcBitmask == ARY_FLAG && bitmask == CURRY_FLAG) ||
    (srcBitmask == ARY_FLAG && bitmask == REARG_FLAG && data[7].length <= source[8]) ||
    (srcBitmask == (ARY_FLAG | REARG_FLAG) && bitmask == CURRY_FLAG);

  // Exit early if metadata can't be merged.
  if (!(isCommon || isCombo)) {
    return data;
  }
  // Use source `thisArg` if available.
  if (srcBitmask & BIND_FLAG) {
    data[2] = source[2];
    // Set when currying a bound function.
    newBitmask |= (bitmask & BIND_FLAG) ? 0 : CURRY_BOUND_FLAG;
  }
  // Compose partial arguments.
  var value = source[3];
  if (value) {
    var partials = data[3];
    data[3] = partials ? composeArgs(partials, value, source[4]) : arrayCopy(value);
    data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : arrayCopy(source[4]);
  }
  // Compose partial right arguments.
  value = source[5];
  if (value) {
    partials = data[5];
    data[5] = partials ? composeArgsRight(partials, value, source[6]) : arrayCopy(value);
    data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : arrayCopy(source[6]);
  }
  // Use source `argPos` if available.
  value = source[7];
  if (value) {
    data[7] = arrayCopy(value);
  }
  // Use source `ary` if it's smaller.
  if (srcBitmask & ARY_FLAG) {
    data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
  }
  // Use source `arity` if one is not provided.
  if (data[9] == null) {
    data[9] = source[9];
  }
  // Use source `func` and merge bitmasks.
  data[0] = source[0];
  data[1] = newBitmask;

  return data;
}

module.exports = mergeData;

},{"286":286,"338":338,"339":339,"380":380}],375:[function(_dereq_,module,exports){
(function (global){
var getNative = _dereq_(361);

/** Native method references. */
var WeakMap = getNative(global, 'WeakMap');

/** Used to store function metadata. */
var metaMap = WeakMap && new WeakMap;

module.exports = metaMap;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{"361":361}],376:[function(_dereq_,module,exports){
var toObject = _dereq_(384);

/**
 * A specialized version of `_.pick` which picks `object` properties specified
 * by `props`.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} props The property names to pick.
 * @returns {Object} Returns the new object.
 */
function pickByArray(object, props) {
  object = toObject(object);

  var index = -1,
      length = props.length,
      result = {};

  while (++index < length) {
    var key = props[index];
    if (key in object) {
      result[key] = object[key];
    }
  }
  return result;
}

module.exports = pickByArray;

},{"384":384}],377:[function(_dereq_,module,exports){
var baseForIn = _dereq_(310);

/**
 * A specialized version of `_.pick` which picks `object` properties `predicate`
 * returns truthy for.
 *
 * @private
 * @param {Object} object The source object.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Object} Returns the new object.
 */
function pickByCallback(object, predicate) {
  var result = {};
  baseForIn(object, function(value, key, object) {
    if (predicate(value, key, object)) {
      result[key] = value;
    }
  });
  return result;
}

module.exports = pickByCallback;

},{"310":310}],378:[function(_dereq_,module,exports){
/** Used to lookup unminified function names. */
var realNames = {};

module.exports = realNames;

},{}],379:[function(_dereq_,module,exports){
var arrayCopy = _dereq_(286),
    isIndex = _dereq_(367);

/* Native method references for those with the same name as other `lodash` methods. */
var nativeMin = Math.min;

/**
 * Reorder `array` according to the specified indexes where the element at
 * the first index is assigned as the first element, the element at
 * the second index is assigned as the second element, and so on.
 *
 * @private
 * @param {Array} array The array to reorder.
 * @param {Array} indexes The arranged array indexes.
 * @returns {Array} Returns `array`.
 */
function reorder(array, indexes) {
  var arrLength = array.length,
      length = nativeMin(indexes.length, arrLength),
      oldArray = arrayCopy(array);

  while (length--) {
    var index = indexes[length];
    array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined;
  }
  return array;
}

module.exports = reorder;

},{"286":286,"367":367}],380:[function(_dereq_,module,exports){
/** Used as the internal argument placeholder. */
var PLACEHOLDER = '__lodash_placeholder__';

/**
 * Replaces all `placeholder` elements in `array` with an internal placeholder
 * and returns an array of their indexes.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {*} placeholder The placeholder to replace.
 * @returns {Array} Returns the new array of placeholder indexes.
 */
function replaceHolders(array, placeholder) {
  var index = -1,
      length = array.length,
      resIndex = -1,
      result = [];

  while (++index < length) {
    if (array[index] === placeholder) {
      array[index] = PLACEHOLDER;
      result[++resIndex] = index;
    }
  }
  return result;
}

module.exports = replaceHolders;

},{}],381:[function(_dereq_,module,exports){
var baseSetData = _dereq_(326),
    now = _dereq_(278);

/** Used to detect when a function becomes hot. */
var HOT_COUNT = 150,
    HOT_SPAN = 16;

/**
 * Sets metadata for `func`.
 *
 * **Note:** If this function becomes hot, i.e. is invoked a lot in a short
 * period of time, it will trip its breaker and transition to an identity function
 * to avoid garbage collection pauses in V8. See [V8 issue 2070](https://code.google.com/p/v8/issues/detail?id=2070)
 * for more details.
 *
 * @private
 * @param {Function} func The function to associate metadata with.
 * @param {*} data The metadata.
 * @returns {Function} Returns `func`.
 */
var setData = (function() {
  var count = 0,
      lastCalled = 0;

  return function(key, value) {
    var stamp = now(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return key;
      }
    } else {
      count = 0;
    }
    return baseSetData(key, value);
  };
}());

module.exports = setData;

},{"278":278,"326":326}],382:[function(_dereq_,module,exports){
var isArguments = _dereq_(388),
    isArray = _dereq_(389),
    isIndex = _dereq_(367),
    isLength = _dereq_(371),
    keysIn = _dereq_(400);

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A fallback implementation of `Object.keys` which creates an array of the
 * own enumerable property names of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function shimKeys(object) {
  var props = keysIn(object),
      propsLength = props.length,
      length = propsLength && object.length;

  var allowIndexes = !!length && isLength(length) &&
    (isArray(object) || isArguments(object));

  var index = -1,
      result = [];

  while (++index < propsLength) {
    var key = props[index];
    if ((allowIndexes && isIndex(key, length)) || hasOwnProperty.call(object, key)) {
      result.push(key);
    }
  }
  return result;
}

module.exports = shimKeys;

},{"367":367,"371":371,"388":388,"389":389,"400":400}],383:[function(_dereq_,module,exports){
/**
 * An implementation of `_.uniq` optimized for sorted arrays without support
 * for callback shorthands and `this` binding.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The function invoked per iteration.
 * @returns {Array} Returns the new duplicate free array.
 */
function sortedUniq(array, iteratee) {
  var seen,
      index = -1,
      length = array.length,
      resIndex = -1,
      result = [];

  while (++index < length) {
    var value = array[index],
        computed = iteratee ? iteratee(value, index, array) : value;

    if (!index || seen !== computed) {
      seen = computed;
      result[++resIndex] = value;
    }
  }
  return result;
}

module.exports = sortedUniq;

},{}],384:[function(_dereq_,module,exports){
var isObject = _dereq_(393);

/**
 * Converts `value` to an object if it's not one.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {Object} Returns the object.
 */
function toObject(value) {
  return isObject(value) ? value : Object(value);
}

module.exports = toObject;

},{"393":393}],385:[function(_dereq_,module,exports){
var baseToString = _dereq_(330),
    isArray = _dereq_(389);

/** Used to match property names within property paths. */
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\n\\]|\\.)*?)\2)\]/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `value` to property path array if it's not one.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {Array} Returns the property path array.
 */
function toPath(value) {
  if (isArray(value)) {
    return value;
  }
  var result = [];
  baseToString(value).replace(rePropName, function(match, number, quote, string) {
    result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
}

module.exports = toPath;

},{"330":330,"389":389}],386:[function(_dereq_,module,exports){
var LazyWrapper = _dereq_(283),
    LodashWrapper = _dereq_(284),
    arrayCopy = _dereq_(286);

/**
 * Creates a clone of `wrapper`.
 *
 * @private
 * @param {Object} wrapper The wrapper to clone.
 * @returns {Object} Returns the cloned wrapper.
 */
function wrapperClone(wrapper) {
  return wrapper instanceof LazyWrapper
    ? wrapper.clone()
    : new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__, arrayCopy(wrapper.__actions__));
}

module.exports = wrapperClone;

},{"283":283,"284":284,"286":286}],387:[function(_dereq_,module,exports){
var baseClone = _dereq_(297),
    bindCallback = _dereq_(333),
    isIterateeCall = _dereq_(368);

/**
 * Creates a clone of `value`. If `isDeep` is `true` nested objects are cloned,
 * otherwise they are assigned by reference. If `customizer` is provided it's
 * invoked to produce the cloned values. If `customizer` returns `undefined`
 * cloning is handled by the method instead. The `customizer` is bound to
 * `thisArg` and invoked with up to three argument; (value [, index|key, object]).
 *
 * **Note:** This method is loosely based on the
 * [structured clone algorithm](http://www.w3.org/TR/html5/infrastructure.html#internal-structured-cloning-algorithm).
 * The enumerable properties of `arguments` objects and objects created by
 * constructors other than `Object` are cloned to plain `Object` objects. An
 * empty object is returned for uncloneable values such as functions, DOM nodes,
 * Maps, Sets, and WeakMaps.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @param {Function} [customizer] The function to customize cloning values.
 * @param {*} [thisArg] The `this` binding of `customizer`.
 * @returns {*} Returns the cloned value.
 * @example
 *
 * var users = [
 *   { 'user': 'barney' },
 *   { 'user': 'fred' }
 * ];
 *
 * var shallow = _.clone(users);
 * shallow[0] === users[0];
 * // => true
 *
 * var deep = _.clone(users, true);
 * deep[0] === users[0];
 * // => false
 *
 * // using a customizer callback
 * var el = _.clone(document.body, function(value) {
 *   if (_.isElement(value)) {
 *     return value.cloneNode(false);
 *   }
 * });
 *
 * el === document.body
 * // => false
 * el.nodeName
 * // => BODY
 * el.childNodes.length;
 * // => 0
 */
function clone(value, isDeep, customizer, thisArg) {
  if (isDeep && typeof isDeep != 'boolean' && isIterateeCall(value, isDeep, customizer)) {
    isDeep = false;
  }
  else if (typeof isDeep == 'function') {
    thisArg = customizer;
    customizer = isDeep;
    isDeep = false;
  }
  return typeof customizer == 'function'
    ? baseClone(value, isDeep, bindCallback(customizer, thisArg, 3))
    : baseClone(value, isDeep);
}

module.exports = clone;

},{"297":297,"333":333,"368":368}],388:[function(_dereq_,module,exports){
var isArrayLike = _dereq_(366),
    isObjectLike = _dereq_(372);

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Native method references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is classified as an `arguments` object.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
function isArguments(value) {
  return isObjectLike(value) && isArrayLike(value) &&
    hasOwnProperty.call(value, 'callee') && !propertyIsEnumerable.call(value, 'callee');
}

module.exports = isArguments;

},{"366":366,"372":372}],389:[function(_dereq_,module,exports){
var getNative = _dereq_(361),
    isLength = _dereq_(371),
    isObjectLike = _dereq_(372);

/** `Object#toString` result references. */
var arrayTag = '[object Array]';

/** Used for native method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/* Native method references for those with the same name as other `lodash` methods. */
var nativeIsArray = getNative(Array, 'isArray');

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(function() { return arguments; }());
 * // => false
 */
var isArray = nativeIsArray || function(value) {
  return isObjectLike(value) && isLength(value.length) && objToString.call(value) == arrayTag;
};

module.exports = isArray;

},{"361":361,"371":371,"372":372}],390:[function(_dereq_,module,exports){
var isObject = _dereq_(393);

/** `Object#toString` result references. */
var funcTag = '[object Function]';

/** Used for native method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in older versions of Chrome and Safari which return 'function' for regexes
  // and Safari 8 which returns 'object' for typed array constructors.
  return isObject(value) && objToString.call(value) == funcTag;
}

module.exports = isFunction;

},{"393":393}],391:[function(_dereq_,module,exports){
var isFunction = _dereq_(390),
    isObjectLike = _dereq_(372);

/** Used to detect host constructors (Safari > 5). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var fnToString = Function.prototype.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  fnToString.call(hasOwnProperty).replace(/[\\^$.*+?()[\]{}|]/g, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * Checks if `value` is a native function.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function, else `false`.
 * @example
 *
 * _.isNative(Array.prototype.push);
 * // => true
 *
 * _.isNative(_);
 * // => false
 */
function isNative(value) {
  if (value == null) {
    return false;
  }
  if (isFunction(value)) {
    return reIsNative.test(fnToString.call(value));
  }
  return isObjectLike(value) && reIsHostCtor.test(value);
}

module.exports = isNative;

},{"372":372,"390":390}],392:[function(_dereq_,module,exports){
var isObjectLike = _dereq_(372);

/** `Object#toString` result references. */
var numberTag = '[object Number]';

/** Used for native method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/**
 * Checks if `value` is classified as a `Number` primitive or object.
 *
 * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are classified
 * as numbers, use the `_.isFinite` method.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
 * @example
 *
 * _.isNumber(8.4);
 * // => true
 *
 * _.isNumber(NaN);
 * // => true
 *
 * _.isNumber('8.4');
 * // => false
 */
function isNumber(value) {
  return typeof value == 'number' || (isObjectLike(value) && objToString.call(value) == numberTag);
}

module.exports = isNumber;

},{"372":372}],393:[function(_dereq_,module,exports){
/**
 * Checks if `value` is the [language type](https://es5.github.io/#x8) of `Object`.
 * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(1);
 * // => false
 */
function isObject(value) {
  // Avoid a V8 JIT bug in Chrome 19-20.
  // See https://code.google.com/p/v8/issues/detail?id=2291 for more details.
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

module.exports = isObject;

},{}],394:[function(_dereq_,module,exports){
var baseForIn = _dereq_(310),
    isArguments = _dereq_(388),
    isObjectLike = _dereq_(372);

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * **Note:** This method assumes objects created by the `Object` constructor
 * have no inherited enumerable properties.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  var Ctor;

  // Exit early for non `Object` objects.
  if (!(isObjectLike(value) && objToString.call(value) == objectTag && !isArguments(value)) ||
      (!hasOwnProperty.call(value, 'constructor') && (Ctor = value.constructor, typeof Ctor == 'function' && !(Ctor instanceof Ctor)))) {
    return false;
  }
  // IE < 9 iterates inherited properties before own properties. If the first
  // iterated property is an object's own property then there are no inherited
  // enumerable properties.
  var result;
  // In most environments an object's own properties are iterated before
  // its inherited properties. If the last iterated property is an object's
  // own property then there are no inherited enumerable properties.
  baseForIn(value, function(subValue, key) {
    result = key;
  });
  return result === undefined || hasOwnProperty.call(value, result);
}

module.exports = isPlainObject;

},{"310":310,"372":372,"388":388}],395:[function(_dereq_,module,exports){
var isObjectLike = _dereq_(372);

/** `Object#toString` result references. */
var stringTag = '[object String]';

/** Used for native method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/**
 * Checks if `value` is classified as a `String` primitive or object.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
 * @example
 *
 * _.isString('abc');
 * // => true
 *
 * _.isString(1);
 * // => false
 */
function isString(value) {
  return typeof value == 'string' || (isObjectLike(value) && objToString.call(value) == stringTag);
}

module.exports = isString;

},{"372":372}],396:[function(_dereq_,module,exports){
var isLength = _dereq_(371),
    isObjectLike = _dereq_(372);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dateTag] = typedArrayTags[errorTag] =
typedArrayTags[funcTag] = typedArrayTags[mapTag] =
typedArrayTags[numberTag] = typedArrayTags[objectTag] =
typedArrayTags[regexpTag] = typedArrayTags[setTag] =
typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;

/** Used for native method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objToString = objectProto.toString;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
function isTypedArray(value) {
  return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[objToString.call(value)];
}

module.exports = isTypedArray;

},{"371":371,"372":372}],397:[function(_dereq_,module,exports){
var baseCopy = _dereq_(299),
    keysIn = _dereq_(400);

/**
 * Converts `value` to a plain object flattening inherited enumerable
 * properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return baseCopy(value, keysIn(value));
}

module.exports = toPlainObject;

},{"299":299,"400":400}],398:[function(_dereq_,module,exports){
var assignWith = _dereq_(294),
    baseAssign = _dereq_(295),
    createAssigner = _dereq_(341);

/**
 * Assigns own enumerable properties of source object(s) to the destination
 * object. Subsequent sources overwrite property assignments of previous sources.
 * If `customizer` is provided it's invoked to produce the assigned values.
 * The `customizer` is bound to `thisArg` and invoked with five arguments:
 * (objectValue, sourceValue, key, object, source).
 *
 * **Note:** This method mutates `object` and is based on
 * [`Object.assign`](http://ecma-international.org/ecma-262/6.0/#sec-object.assign).
 *
 * @static
 * @memberOf _
 * @alias extend
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {*} [thisArg] The `this` binding of `customizer`.
 * @returns {Object} Returns `object`.
 * @example
 *
 * _.assign({ 'user': 'barney' }, { 'age': 40 }, { 'user': 'fred' });
 * // => { 'user': 'fred', 'age': 40 }
 *
 * // using a customizer callback
 * var defaults = _.partialRight(_.assign, function(value, other) {
 *   return _.isUndefined(value) ? other : value;
 * });
 *
 * defaults({ 'user': 'barney' }, { 'age': 36 }, { 'user': 'fred' });
 * // => { 'user': 'barney', 'age': 36 }
 */
var assign = createAssigner(function(object, source, customizer) {
  return customizer
    ? assignWith(object, source, customizer)
    : baseAssign(object, source);
});

module.exports = assign;

},{"294":294,"295":295,"341":341}],399:[function(_dereq_,module,exports){
var getNative = _dereq_(361),
    isArrayLike = _dereq_(366),
    isObject = _dereq_(393),
    shimKeys = _dereq_(382);

/* Native method references for those with the same name as other `lodash` methods. */
var nativeKeys = getNative(Object, 'keys');

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/6.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
var keys = !nativeKeys ? shimKeys : function(object) {
  var Ctor = object == null ? undefined : object.constructor;
  if ((typeof Ctor == 'function' && Ctor.prototype === object) ||
      (typeof object != 'function' && isArrayLike(object))) {
    return shimKeys(object);
  }
  return isObject(object) ? nativeKeys(object) : [];
};

module.exports = keys;

},{"361":361,"366":366,"382":382,"393":393}],400:[function(_dereq_,module,exports){
var isArguments = _dereq_(388),
    isArray = _dereq_(389),
    isIndex = _dereq_(367),
    isLength = _dereq_(371),
    isObject = _dereq_(393);

/** Used for native method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  if (object == null) {
    return [];
  }
  if (!isObject(object)) {
    object = Object(object);
  }
  var length = object.length;
  length = (length && isLength(length) &&
    (isArray(object) || isArguments(object)) && length) || 0;

  var Ctor = object.constructor,
      index = -1,
      isProto = typeof Ctor == 'function' && Ctor.prototype === object,
      result = Array(length),
      skipIndexes = length > 0;

  while (++index < length) {
    result[index] = (index + '');
  }
  for (var key in object) {
    if (!(skipIndexes && isIndex(key, length)) &&
        !(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = keysIn;

},{"367":367,"371":371,"388":388,"389":389,"393":393}],401:[function(_dereq_,module,exports){
var baseMerge = _dereq_(321),
    createAssigner = _dereq_(341);

/**
 * Recursively merges own enumerable properties of the source object(s), that
 * don't resolve to `undefined` into the destination object. Subsequent sources
 * overwrite property assignments of previous sources. If `customizer` is
 * provided it's invoked to produce the merged values of the destination and
 * source properties. If `customizer` returns `undefined` merging is handled
 * by the method instead. The `customizer` is bound to `thisArg` and invoked
 * with five arguments: (objectValue, sourceValue, key, object, source).
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {*} [thisArg] The `this` binding of `customizer`.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var users = {
 *   'data': [{ 'user': 'barney' }, { 'user': 'fred' }]
 * };
 *
 * var ages = {
 *   'data': [{ 'age': 36 }, { 'age': 40 }]
 * };
 *
 * _.merge(users, ages);
 * // => { 'data': [{ 'user': 'barney', 'age': 36 }, { 'user': 'fred', 'age': 40 }] }
 *
 * // using a customizer callback
 * var object = {
 *   'fruits': ['apple'],
 *   'vegetables': ['beet']
 * };
 *
 * var other = {
 *   'fruits': ['banana'],
 *   'vegetables': ['carrot']
 * };
 *
 * _.merge(object, other, function(a, b) {
 *   if (_.isArray(a)) {
 *     return a.concat(b);
 *   }
 * });
 * // => { 'fruits': ['apple', 'banana'], 'vegetables': ['beet', 'carrot'] }
 */
var merge = createAssigner(baseMerge);

module.exports = merge;

},{"321":321,"341":341}],402:[function(_dereq_,module,exports){
var arrayMap = _dereq_(290),
    baseDifference = _dereq_(302),
    baseFlatten = _dereq_(308),
    bindCallback = _dereq_(333),
    keysIn = _dereq_(400),
    pickByArray = _dereq_(376),
    pickByCallback = _dereq_(377),
    restParam = _dereq_(282);

/**
 * The opposite of `_.pick`; this method creates an object composed of the
 * own and inherited enumerable properties of `object` that are not omitted.
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {Function|...(string|string[])} [predicate] The function invoked per
 *  iteration or property names to omit, specified as individual property
 *  names or arrays of property names.
 * @param {*} [thisArg] The `this` binding of `predicate`.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'user': 'fred', 'age': 40 };
 *
 * _.omit(object, 'age');
 * // => { 'user': 'fred' }
 *
 * _.omit(object, _.isNumber);
 * // => { 'user': 'fred' }
 */
var omit = restParam(function(object, props) {
  if (object == null) {
    return {};
  }
  if (typeof props[0] != 'function') {
    var props = arrayMap(baseFlatten(props), String);
    return pickByArray(object, baseDifference(keysIn(object), props));
  }
  var predicate = bindCallback(props[0], props[1], 3);
  return pickByCallback(object, function(value, key, object) {
    return !predicate(value, key, object);
  });
});

module.exports = omit;

},{"282":282,"290":290,"302":302,"308":308,"333":333,"376":376,"377":377,"400":400}],403:[function(_dereq_,module,exports){
var keys = _dereq_(399),
    toObject = _dereq_(384);

/**
 * Creates a two dimensional array of the key-value pairs for `object`,
 * e.g. `[[key1, value1], [key2, value2]]`.
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the new array of key-value pairs.
 * @example
 *
 * _.pairs({ 'barney': 36, 'fred': 40 });
 * // => [['barney', 36], ['fred', 40]] (iteration order is not guaranteed)
 */
function pairs(object) {
  object = toObject(object);

  var index = -1,
      props = keys(object),
      length = props.length,
      result = Array(length);

  while (++index < length) {
    var key = props[index];
    result[index] = [key, object[key]];
  }
  return result;
}

module.exports = pairs;

},{"384":384,"399":399}],404:[function(_dereq_,module,exports){
var baseFlatten = _dereq_(308),
    bindCallback = _dereq_(333),
    pickByArray = _dereq_(376),
    pickByCallback = _dereq_(377),
    restParam = _dereq_(282);

/**
 * Creates an object composed of the picked `object` properties. Property
 * names may be specified as individual arguments or as arrays of property
 * names. If `predicate` is provided it's invoked for each property of `object`
 * picking the properties `predicate` returns truthy for. The predicate is
 * bound to `thisArg` and invoked with three arguments: (value, key, object).
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {Function|...(string|string[])} [predicate] The function invoked per
 *  iteration or property names to pick, specified as individual property
 *  names or arrays of property names.
 * @param {*} [thisArg] The `this` binding of `predicate`.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'user': 'fred', 'age': 40 };
 *
 * _.pick(object, 'user');
 * // => { 'user': 'fred' }
 *
 * _.pick(object, _.isString);
 * // => { 'user': 'fred' }
 */
var pick = restParam(function(object, props) {
  if (object == null) {
    return {};
  }
  return typeof props[0] == 'function'
    ? pickByCallback(object, bindCallback(props[0], props[1], 3))
    : pickByArray(object, baseFlatten(props));
});

module.exports = pick;

},{"282":282,"308":308,"333":333,"376":376,"377":377}],405:[function(_dereq_,module,exports){
var arrayEach = _dereq_(287),
    baseCallback = _dereq_(296),
    baseCreate = _dereq_(300),
    baseForOwn = _dereq_(311),
    isArray = _dereq_(389),
    isFunction = _dereq_(390),
    isObject = _dereq_(393),
    isTypedArray = _dereq_(396);

/**
 * An alternative to `_.reduce`; this method transforms `object` to a new
 * `accumulator` object which is the result of running each of its own enumerable
 * properties through `iteratee`, with each invocation potentially mutating
 * the `accumulator` object. The `iteratee` is bound to `thisArg` and invoked
 * with four arguments: (accumulator, value, key, object). Iteratee functions
 * may exit iteration early by explicitly returning `false`.
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Array|Object} object The object to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @param {*} [accumulator] The custom accumulator value.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {*} Returns the accumulated value.
 * @example
 *
 * _.transform([2, 3, 4], function(result, n) {
 *   result.push(n *= n);
 *   return n % 2 == 0;
 * });
 * // => [4, 9]
 *
 * _.transform({ 'a': 1, 'b': 2 }, function(result, n, key) {
 *   result[key] = n * 3;
 * });
 * // => { 'a': 3, 'b': 6 }
 */
function transform(object, iteratee, accumulator, thisArg) {
  var isArr = isArray(object) || isTypedArray(object);
  iteratee = baseCallback(iteratee, thisArg, 4);

  if (accumulator == null) {
    if (isArr || isObject(object)) {
      var Ctor = object.constructor;
      if (isArr) {
        accumulator = isArray(object) ? new Ctor : [];
      } else {
        accumulator = baseCreate(isFunction(Ctor) ? Ctor.prototype : undefined);
      }
    } else {
      accumulator = {};
    }
  }
  (isArr ? arrayEach : baseForOwn)(object, function(value, index, object) {
    return iteratee(accumulator, value, index, object);
  });
  return accumulator;
}

module.exports = transform;

},{"287":287,"296":296,"300":300,"311":311,"389":389,"390":390,"393":393,"396":396}],406:[function(_dereq_,module,exports){
var baseValues = _dereq_(332),
    keys = _dereq_(399);

/**
 * Creates an array of the own enumerable property values of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property values.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.values(new Foo);
 * // => [1, 2] (iteration order is not guaranteed)
 *
 * _.values('hi');
 * // => ['h', 'i']
 */
function values(object) {
  return baseValues(object, keys(object));
}

module.exports = values;

},{"332":332,"399":399}],407:[function(_dereq_,module,exports){
/**
 * This method returns the first argument provided to it.
 *
 * @static
 * @memberOf _
 * @category Utility
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'user': 'fred' };
 *
 * _.identity(object) === object;
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;

},{}],408:[function(_dereq_,module,exports){
/**
 * A no-operation function that returns `undefined` regardless of the
 * arguments it receives.
 *
 * @static
 * @memberOf _
 * @category Utility
 * @example
 *
 * var object = { 'user': 'fred' };
 *
 * _.noop(object) === undefined;
 * // => true
 */
function noop() {
  // No operation performed.
}

module.exports = noop;

},{}],409:[function(_dereq_,module,exports){
var baseProperty = _dereq_(323),
    basePropertyDeep = _dereq_(324),
    isKey = _dereq_(369);

/**
 * Creates a function that returns the property value at `path` on a
 * given object.
 *
 * @static
 * @memberOf _
 * @category Utility
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new function.
 * @example
 *
 * var objects = [
 *   { 'a': { 'b': { 'c': 2 } } },
 *   { 'a': { 'b': { 'c': 1 } } }
 * ];
 *
 * _.map(objects, _.property('a.b.c'));
 * // => [2, 1]
 *
 * _.pluck(_.sortBy(objects, _.property(['a', 'b', 'c'])), 'a.b.c');
 * // => [1, 2]
 */
function property(path) {
  return isKey(path) ? baseProperty(path) : basePropertyDeep(path);
}

module.exports = property;

},{"323":323,"324":324,"369":369}],410:[function(_dereq_,module,exports){
/**
 * Set attribute `name` to `val`, or get attr `name`.
 *
 * @param {Element} el
 * @param {String} name
 * @param {String} [val]
 * @api public
 */

module.exports = function(el, name, val) {
  // get
  if (arguments.length == 2) {
    return el.getAttribute(name);
  }

  // remove
  if (val === null) {
    return el.removeAttribute(name);
  }

  // set
  el.setAttribute(name, val);

  return el;
};
},{}],411:[function(_dereq_,module,exports){
module.exports = _dereq_(83);
},{"83":83}],412:[function(_dereq_,module,exports){
module.exports = function(el) {

  var c;

  while (el.childNodes.length) {
    c = el.childNodes[0];
    el.removeChild(c);
  }

  return el;
};
},{}],413:[function(_dereq_,module,exports){
module.exports = _dereq_(84);
},{"84":84}],414:[function(_dereq_,module,exports){
module.exports = _dereq_(85);
},{"85":85}],415:[function(_dereq_,module,exports){
module.exports = _dereq_(253);
},{"253":253}],416:[function(_dereq_,module,exports){
module.exports = _dereq_(86);
},{"86":86}],417:[function(_dereq_,module,exports){
module.exports = _dereq_(88);
},{"88":88}],418:[function(_dereq_,module,exports){
module.exports = _dereq_(89);
},{"89":89}],419:[function(_dereq_,module,exports){
module.exports = function(el) {
  el.parentNode && el.parentNode.removeChild(el);
};
},{}],420:[function(_dereq_,module,exports){
'use strict';

function capitalize(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
}

function lower(string) {
  return string.charAt(0).toLowerCase() + string.slice(1);
}

function hasLowerCaseAlias(pkg) {
  return pkg.xml && pkg.xml.tagAlias === 'lowerCase';
}


module.exports.aliasToName = function(alias, pkg) {
  if (hasLowerCaseAlias(pkg)) {
    return capitalize(alias);
  } else {
    return alias;
  }
};

module.exports.nameToAlias = function(name, pkg) {
  if (hasLowerCaseAlias(pkg)) {
    return lower(name);
  } else {
    return name;
  }
};

module.exports.DEFAULT_NS_MAP = {
  'xsi': 'http://www.w3.org/2001/XMLSchema-instance'
};

var XSI_TYPE = module.exports.XSI_TYPE = 'xsi:type';

function serializeFormat(element) {
  return element.xml && element.xml.serialize;
}

module.exports.serializeAsType = function(element) {
  return serializeFormat(element) === XSI_TYPE;
};

module.exports.serializeAsProperty = function(element) {
  return serializeFormat(element) === 'property';
};
},{}],421:[function(_dereq_,module,exports){
'use strict';

var reduce = _dereq_(274),
    forEach = _dereq_(271),
    find = _dereq_(270),
    assign = _dereq_(398),
    defer = _dereq_(281);

var Stack = _dereq_(437),
    SaxParser = _dereq_(435).parser,
    Moddle = _dereq_(423),
    parseNameNs = _dereq_(428).parseName,
    Types = _dereq_(431),
    coerceType = Types.coerceType,
    isSimpleType = Types.isSimple,
    common = _dereq_(420),
    XSI_TYPE = common.XSI_TYPE,
    XSI_URI = common.DEFAULT_NS_MAP.xsi,
    serializeAsType = common.serializeAsType,
    aliasToName = common.aliasToName;

function parseNodeAttributes(node) {
  var nodeAttrs = node.attributes;

  return reduce(nodeAttrs, function(result, v, k) {
    var name, ns;

    if (!v.local) {
      name = v.prefix;
    } else {
      ns = parseNameNs(v.name, v.prefix);
      name = ns.name;
    }

    result[name] = v.value;
    return result;
  }, {});
}

function normalizeType(node, attr, model) {
  var nameNs = parseNameNs(attr.value);

  var uri = node.ns[nameNs.prefix || ''],
      localName = nameNs.localName,
      pkg = uri && model.getPackage(uri),
      typePrefix;

  if (pkg) {
    typePrefix = pkg.xml && pkg.xml.typePrefix;

    if (typePrefix && localName.indexOf(typePrefix) === 0) {
      localName = localName.slice(typePrefix.length);
    }

    attr.value = pkg.prefix + ':' + localName;
  }
}

/**
 * Normalizes namespaces for a node given an optional default namespace and a
 * number of mappings from uris to default prefixes.
 *
 * @param  {XmlNode} node
 * @param  {Model} model the model containing all registered namespaces
 * @param  {Uri} defaultNsUri
 */
function normalizeNamespaces(node, model, defaultNsUri) {
  var uri, prefix;

  uri = node.uri || defaultNsUri;

  if (uri) {
    var pkg = model.getPackage(uri);

    if (pkg) {
      prefix = pkg.prefix;
    } else {
      prefix = node.prefix;
    }

    node.prefix = prefix;
    node.uri = uri;
  }

  forEach(node.attributes, function(attr) {

    // normalize xsi:type attributes because the
    // assigned t