/*!
 * dc-addons v0.13.5
 *
 * 2016-08-17 08:09:00
 *
 */
!function(){"use strict";/**
    ## Paired Row Chart
    Includes: [Cap Mixin](#cap-mixin), [Margin Mixin](#margin-mixin), [Color Mixin](#color-mixin), [Base Mixin](#base-mixin)

    Concrete paired row chart implementation.
    #### dc.pairedRowChart(parent[, chartGroup])
    Create a paired row chart instance and attach it to the given parent element.

    Parameters:

    * parent : string | node | selection - any valid
     [d3 single selector](https://github.com/mbostock/d3/wiki/Selections#selecting-elements) specifying
     a dom block element such as a div; or a dom element or d3 selection.

    * chartGroup : string (optional) - name of the chart group this chart instance should be placed in.
     Interaction with a chart will only trigger events and redraws within the chart's group.

    Returns:
    A newly created paired row chart instance

    ```js
    // create a paired row chart under #chart-container1 element using the default global chart group
    var chart1 = dc.pairedRowChart('#chart-container1');
    // create a paired row chart under #chart-container2 element using chart group A
    var chart2 = dc.pairedRowChart('#chart-container2', 'chartGroupA');
    ```
    **/
return dc.pairedRowChart?!1:void(dc.pairedRowChart=function(a,b){function c(a){e[a]=function(b){return arguments.length?(h[a](b),i[a](b),e):[h[a](),i[a]()]}}function d(a){e[a]=function(){return h[a](),i[a](),e}}var e=dc.capMixin(dc.marginMixin(dc.colorMixin(dc.baseMixin({})))),f=d3.select(a).append("div"),g=d3.select(a).append("div"),h=dc.rowChart(f[0][0],b),i=dc.rowChart(g[0][0],b);h.useRightYAxis&&h.useRightYAxis(!0);
// data filtering
// we need a way to know which data belongs on the left chart and which data belongs on the right
var j=function(a){return a.key[0]},k=function(a){return a.key[0]};/**
        #### .leftKeyFilter([value]) - **mandatory**
        Set or get the left key filter attribute of a chart.

        For example
        function (d) {
            return d.key[0] === 'Male';
        }

        If a value is given, then it will be used as the new left key filter. If no value is specified then
        the current left key filter will be returned.

        **/
e.leftKeyFilter=function(a){return arguments.length?(j=a,e):j},/**
        #### .rightKeyFilter([value]) - **mandatory**
        Set or get the right key filter attribute of a chart.

        For example
        function (d) {
            return d.key[0] === 'Female';
        }

        If a value is given, then it will be used as the new right key filter. If no value is specified then
        the current right key filter will be returned.

        **/
e.rightKeyFilter=function(a){return arguments.length?(k=a,e):k},
// when trying to get the data for the left chart then filter all data using the leftKeyFilter function
h.data(function(a){var b=h.cap(),c=a.all().filter(function(a){return e.leftKeyFilter()(a)});return b===1/0?c:c.slice(0,b)}),
// when trying to get the data for the right chart then filter all data using the rightKeyFilter function
i.data(function(a){var b=i.cap(),c=a.all().filter(function(a){return e.rightKeyFilter()(a)});return b===1/0?c:c.slice(0,b)}),
// chart filtering
// on clicking either chart then filter both
h.onClick=i.onClick=function(a){var b=h.keyAccessor()(a);dc.events.trigger(function(){h.filter(b),i.filter(b),h.redrawGroup()})};
// width and margins
// the margins between the charts need to be set to 0 so that they sit together
var l=e.margins();// get the default margins
l.right=l.left,e.margins=function(a){
// set left chart margins
// set right chart margins
return arguments.length?(l=a,h.margins({top:a.top,right:0,bottom:a.bottom,left:a.left}),i.margins({top:a.top,right:a.right,bottom:a.bottom,left:0}),e):l},e.margins(l);// set the new margins
// the width needs to be halved
var m=0;// get the default width
e.width=function(a){
// set left chart width
// set right chart width
return arguments.length?(m=a,h.width(dc.utils.isNumber(a)?a/2:a),i.width(dc.utils.isNumber(a)?a/2:a),e):m};
// the minWidth needs to be halved
var n=e.minWidth();// get the default minWidth
e.minWidth=function(a){
// set left chart minWidth
// set right chart minWidth
return arguments.length?(n=a,h.minWidth(dc.utils.isNumber(a)?a/2:a),i.minWidth(dc.utils.isNumber(a)?a/2:a),e):n},e.minWidth(n),// set the new minWidth
// svg
// return an array of both the sub chart svgs
e.svg=function(){return d3.selectAll([h.svg()[0][0],i.svg()[0][0]])},
// data - we need to make sure that the extent is the same for both charts
// this way we need a new function that is overridable
h.calculateAxisScaleData?h.calculateAxisScaleData=i.calculateAxisScaleData=function(){return h.data().concat(i.data())}:e.group=function(a){if(!arguments.length)return h.group();h.group(a),i.group(a);
// set the new x axis scale
var b=d3.extent(a.all(),e.cappedValueAccessor);return b[0]>0&&(b[0]=0),h.x(d3.scale.linear().domain(b).range([h.effectiveWidth(),0])),i.x(d3.scale.linear().domain(b).range([0,i.effectiveWidth()])),e},
// get the charts - mainly used for testing
e.leftChart=function(){return h},e.rightChart=function(){return i};for(var o=[
// display
"height","minHeight","renderTitleLabel","fixedBarHeight","gap","othersLabel","transitionDuration","label","renderLabel","title","renderTitle","chartGroup","legend",
//colors
"colors","ordinalColors","linearColors","colorAccessor","colorDomain","getColor","colorCalculator",
// x axis
"x","elasticX","valueAccessor","labelOffsetX","titleLabelOffsetx","xAxis",
// y axis
"keyAccessor","labelOffsetY","yAxis",
// data
"cap","ordering","dimension","group","othersGrouper","data"],p=0;p<o.length;p++)c(o[p]);var q=["_doRedraw","redraw","_doRender","render","calculateColorDomain","filterAll","resetSvg","expireCache"];for(p=0;p<q.length;p++)d(q[p]);return e.anchor(a,b)})}();