Contribution guidelines
=======================

## For end-users

If you are experiencing problems, and need help, please start with [the support web site](http://www.dcljs.org/support/).

## For contributors

* Please search the [issue tracker](https://github.com/uhop/dcl/issues) before submitting new issues
  to avoid duplicates.
* For any non-trivial contributions (new features, etc.), please create a new issue in the issue tracker
  to track discussion prior to submitting a [pull request](http://help.github.com/send-pull-requests).
* For the time being, you must have a signed [Dojo Foundation CLA](http://dojofoundation.org/about/claForm)
  for any non-trivial patches to be accepted.
* Any submitted code should conform to the project’s code style guidelines.
* If appropriate, a test case should be part of the pull request.
* Thank you for your contribution!

## For committers

* Provide rigorous code review for contributors.
* When in doubt, ask for a second review; don’t commit code that smells wrong just because it exists.
* Squash all pull requests into a single commit.
* Put `[ci skip]` at the end of commit messages for commits that do not modify any code
  (readme changes, etc.)
