(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('河南', {"type":"FeatureCollection","features":[{"id":"410100","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@bEV@JANAZBLA`UJOPGN@NPH`DR@ZEHCVST]POLCtE`D|LRHvXPD\\GvATHNJHHDNRVrlFHFFFDJDLATMZO^ALDRAVHVLTDR@PGTMTGZQHAP@^J\\FBCDIJMZM@IAOC[MGUIQCOAAUKGAOB]D_AaEMGAEFIRUxkNMHKAECCMCMGIKIMKGCEFeHIZSDE@GCWFiAEMGECBEHYASHIAEIIAG@EJGGEG@EBANCDO@CCEMAQCU@S_YCEEKKgIwAM@QAESQGCG@IFGJIHYLUNGBW_UMIGBOBARCDCDMAWAAKEICECSAKCM@OFO@KAO@GCCABbCFEBIBAACEEMGCKAE@KDEPCBE@K@COQSCKKOKYDSAIFQBIFG@G@ECEEMAEBCFCDCBCB@BCAYBC@GAACAIDI@SAECYBCIA@I@GBK@MFEFODGFMFICGEGA@CDCCASQGAACeASDEDKBEAEEDC@AMCCGOAEEEADK@CAC[CACJCBCAKGECBGFGDQDGAKIKCCAKBKJKDENGBK@ADGJGJAHCB[NO@[LOBS@ICGGIESDSFIDMHONDLABMNE@IEIAWJG@ECEGGMC@OHI@KJIAABAD[PE@KEWBA@DHABIFFHAB@DHPBFBDGFM@SCGBMFEEE@EBOD@DHN@DOFGFKBGPODMCQ@CC@EACGACEAEHKBCCGKMBGCMHOACKAIBC@KASDICGBAAAOOKe@QDI@WIAE@MGEOQAAIAQBEACIIIAGCC@IIII@BGACECKAGKGEKCEFGBCFG@kKQGOASDQDMVM@EB@BFDEJA@EGEAUAM@GBSRIAABABIPEDS@UGKBuBMHcMK@MBGAICC@OFQBCBCFI@SAGCGBYF_IEHFHBNJDNDBBOHUREHG@K@EBQLE@ICKIGCK@ABAD@R@BIBM@IDGAK@AFALCDEBQEQEE@AHGJDFBP@JABEDIBAHBDDFJBJFAHFNALINDFJFJXDZCLFdAVGLBH\\FHAJ@HDPLBAx_DCBEVALDJCVAXBL@FCLEND`@RBROFAHHXL@BEH@FHXFFCVFH@PDHHDLBPFJ@JCH@\\BJFJJcFQJKBo@ICU@_DM@OLGNCPUTKNAFDF_CEDEHAD@DJRBF@FCPEDE@CFNFBFBHFJCJYVCDLPADGNCRAPDF\\JHBNJJDF@JDNCJA^UPATTJPHBXABBHPFHCBKBmXGJGRDFJFARDJCJCDKFWDGGCAMDqAIBMFIAMGYBEDAHA\\DTDFFDVLVM`AFFT`NFLdDDFBdAZIp_J@XLlVTJFFHPHBPAXERK^YRGXAVDND~FPFHNXBRGTMLQF@JBb\\THRJPLXLJJBFDPRdDP@\\F^HLTLND\\B`CZKZIL@PBJDTLRPVXRPdNfJXCPGDM@M@KjGxEfDhNbDX@REXQVKRQRO"],"encodeOffsets":[[116319,35773]]},"properties":{"cp":[113.665412,34.757975],"name":"郑州市","childNum":1}},{"id":"410200","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@LKJCXMH²CTBPJTN`dJFL@N@NGTIdYPGU|Q`DXDjNtNVA\\EP@`GJCNANCPAHBNFFDBFHBb]\\C^MJ@JF\\@TDHB\\VHLBFALCJGHIFYV[TCF@JDHDHJJPNTDXRZZNJPJ\\LLEDCvMDBHACCBATA@DCBK@BFGBBFJAHRD@@AB@@JC@@BHACHP@@CNA@GBA@GAECBCOB@@ABA@CVM^EFEFQDEJIFCHDPVRLNFhBXCv@JQFELGFAH@FDLP^HVRXLX@`@RBLFX@JIBMEQFCZCJIFKFCAQNAXJTKbKHLFDNDH@DEBK@KCEA@CBCEGDQcIFAAC@ACA@GULA@CXAAIVCDPP@BBZAVEDCEYQSAEBsFKFCTEPUBK@GCCYSSIQEOAwH]GIEQ[IIKCEBONMJK@QCKEKKGKKIOAO@WF_@m@WCsWI@EBCDEBOE[@GAEEOCKGECECGA[DaTaNYTEDG@EAAMEAyAGAECCKDENC@MJCPAVEBEAGIIGIQKAEXEHCBEBK@SDCHCH@\\PLDbBHATK^IJIBG@ECESGaAMCMGEK@EFELIBE@EIOH[AGGM@GPaDUFM@KBKN_BICeESAEBIFUAEAEQUMKOGIAIEUEMIGGAQK[@OHOJIPOJMDOAG_kEQAOBGBIJCDIJQBUBAJALCJIVSBCF@E]CGCAOBgJmTIBKBCAEGKSEACAyE[EQGGECCGYACIEWGUIA@EBCDGRGFIFQDu@EDKHE@c@IHOPQE[DKLWPEBMB_EUBYRWFMRCF@PKNGBEGC@[@EDEHIREFCBiDqNGOCWCIGGBGDAHCXCNELEBGOMISKIME[AEAACGUGGQ@KEKA]B]FWHGHWXGBu@URI@IAEAGGG]AEYYoAM@MFKAOMCGAUAEEAm@WCAACOCEKAMAMEA@M@@DEBCFCBS@EDCJDH@DADKFADBBHDBDGHIRGDM@@L@@GBG@SICHEBEIEAUFCCAMEAgHY@ABAHKL@LAHGDKEE@@LBFDF@BGDW@ABCJCDC@KAAFFJCD_JWBALABGEE@YAIKCAI@AFAHKDFZADGBBJABQFFD@HADBZADA@ADCDED@JFNDF@F@HEHAJERBJCTLZLPDLRTDPL@F@DAFOLCF@LBHDFNDFBBJAFADEAaDBHDP@LBP@PEJARHR@FDJDLFBBBXCNCDQDABAPJHVNX`HAVMZKJGHIJEH@HDTRBF@RBNJxLhFLDF`Z@TDVBRFNDDP@DCBMFAH@HFIH@FBHJJBFGJBTGZAFFDNHBFEjDX@HCFYTGJEfDFLHJNJLNHNDDDBFGLMNwlQVEJBFFFND\\D`B^CPAHBVLXzDTNBZ"],"encodeOffsets":[[116963,35758]]},"properties":{"cp":[114.341447,34.797049],"name":"开封市","childNum":1}},{"id":"410300","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@AGE@IAA@AHAB@D@BD@FAH@FC"],["@@@GGOBABCLED@HFD@PED@hBNDNANCFDJALEXI|MVMHIRUTeJGhG^Q`YJELAJDRXLJNDD@XSPIREVC\\BLC\\ILGTA`KHIDAj@VFV@jEREpUHCHKFATFPCHEFAF@VBDDEBBLOJCFDBD@NIB@ADAD@DFHADIDGRCBK@GAIQA@QDIA@BBFDBDRHLB@JELFDAROFAD@VNL@JDFLLFLTD@BC@OLEDYBEJGKhA@mHA@KAGIG@C@_DUH@\\GfKRIhEdYzMXDNFNJTDPG\\DJDZEJM[OCECYBUDIHCV@NHJBNEJArBNCDBHHXCLEDCDICIBQIECEHQHInWLADAEGGOAAWBGAIOSSOB]VIBMDICE@ICMIGA[ICEBODQHMBCKODCZUDIEIAGAEMEDEF@FCDO@EAEIQ@CBCFGFC`DCEBELMVSDOHMPKN@`CV@JDp@LARIdEIIIE[AG@IDI@OEKAGCCG@OEGDUEEGW@EFG@AWKGGEBQPQA_@MCKFEDK@WAUBIDKCUBAFCDw`ABOKGCI@GB[EAGHKBUEcDKASIYACIECEJMBKEMBGIEIACEAC@GPCDC@IAOCEHIBGB@H@NFRFFADCBKBEL@HBNCOISQCAI@IDKBI@KEE@eJQ@YQSCQ@WGAFFTSPuG_MEMCEi[SQAKCOaQBIHMdSDOGKOQKMHSNKdqFU@QDIFEbIJGFKI[O_KsBSCMMGQCOGCI@QEIaKIBGLCT@JCDCHCJIJCECEAMBGAICECAEDEFA@IEIOWA_BIOSSG]GQGAILQZKlIJE@MOWik[@[BUGYSKSmsUI[@aZihGDI@YKwKOIKMQKOCO@KIKEAEHIBCAAEESEGEAG@CFEJEGu@EEESMAA@MBGwEQCYQaMKJAXSNSCQMIUEUU]UQ_MYGOAUGCIBOHMPGFUJK@KIGG@SHOBMEOLYXMDMCSQEUBKBBD@BGD@BBFHBBFCBGBAIAGIsEcE}OaEQ@IBGFEHUT]PWFQ@MC[AUFEDCJ@PBNA\\GZGLUHIBuRSJwVWLSBSCqSWROTirYLYH]@[CUFYHuASLOFOCQQWKU@]XOF_FYHULWPYNQFUAcG[AOFG@GAMEEAI@EBEDORQDSHSAIDEHMVA\\BZAFgbMXCF[L@BBRADCDOFIHBNBDD@DEAEJCFFNDHABDNJBFAHOX@HFNDFPLFBN@TGF@PDNFF@D@BABKDAJAXBBBBHDRFLFFRPHLHF`NNPJHDFGRDPAVCNELMNAF@fDNHHDJBLFNLJLDBBBDQ^]@CDCDKFe@EBGFCFAFDPENEFIDE@E@UMABAB@JAFSAE@IDMHCDCNSPIREBWAGBCDGPALCFEByVMNUN@FFDJBRAHBDBJXBHBJKLAFDRAZDLJJFXM\\QNILCJEVCDIHeDABCF@DFP@NJJ@NDFHHJF^@dHDDBBCTBLRD\\VBDAJDRJXDDJ@dKpKJ@BD@FEZ@F@Df`LHJAFUDEDAHA\\AhBJBXNFANMLARBTRHDhN`LLlRLJJPFFTRND`BFAHEHANBD@PPTNDHFDP@BCHKJAHBBDBHDD`EVKrMdKTENKHCRAD@BD@DWXGVAHKN@FD@^@LBHFLRDDRHRFPHTF\\GJBDRDDDBH@VAFDHFNRTPJFHDPAFBDDBD@HAL@BBB\\CdBPCHCFEHM^aDANFJAncHCJBFFCNBDLPBRLHJL\\HFFBJRD@BAFGJCLDLDFLHBFBF@DEFADDDVADFBFAFGTAFDFFF\\HFJ@DCHKHMN@HLBPADBDDHR@JCFNBFHDBHACFDJAHAFAFCAEDQHCFAH@DBBLBBDCHIHYPIHEJOFCFAF@FDFLJ@DEDM@]KQAQB@DDLAHOLSLSRSB[BIHEBI@CBADDTCLBDLRNJRHRDNFLNRPPAN@dL\\NDDBB@HCFCBEBQ@GBGFIL@FBBFDND^B@BEFAF\\L@DqR_PWRAHBD`PFH@V@HDBZLDAFCXDbGFBFDNBFC@EFIJELCDEDIAA"]],"encodeOffsets":[[[114719,35618]],[[114728,35887]]]},"properties":{"cp":[112.434468,34.663041],"name":"洛阳市","childNum":2}},{"id":"410400","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@IGCIIOAKACAKAYDGNGfGTKDOGSAIDKRYFAFMXUBGGOFCBC@KLAJIJ@HUHEHCTCV@NXKJSP@LFBNANJHNDHAN]BAH@VDBABSDEL@DCVC`UNAHCHKIEKIAIBGHCFGN[J@LDBVFFLBXERBVCLEHIJeBUJMNQACQMGOESOIaGKW_ISDS\\eDGJEDGBE@GGMAWJ[DEF@DAAEGCM@QO@ABATEPIRCFCTGNGNCLFF@NCHCDEDIB[XBxJ^LH@FCNBVHPBHBDDDADGFEDAR@FBLFD@DABOFQFEF@HCBGGKEKBIPKAGEIAWBWLYLOn[JCFEBGEKGGaMICm]AA@EABCACEC@@DGA@EA@AFWGBCBB@AA@@ACAD@BEC@BAB@AAAABIB@@AF@L@BEAC@CE@@CE@@CB@BEG@@DE@B@B@@BC@@ACB@CA@D@ACF@@AHA@AEA@ACB@AG@@AA@@CC@BEGKC[B@@EC@@CAA@CA@@CC@@AC@@IFO@BBIKAGHEHA@C@ECCB@@KBAFE@@EE@AIO@@AC@ABS@A@EH@IDOHCAE@EWiBgAEIEAA@WBCDA^AXINCH@HDFKJGFDBF@HBDDBFBX@NKBMDAJDZ@P@REL@HFHJ\\@JCF@D@JJNBPJJ@PEHJBBXGLBFCFBDABQDCDAG]EIAEEMECECcGOMCIIG@CFG@ECK@aIIOMCEEQGQK{Kg@INuNSBELYDAHDX@HC@EQWISQSECICEB[\\EDCGGCMAY@[JCC@MAEMSCAMHQTSBQRG@MGGEA@OBQCYDKAEBOFMB[G[BIA_MCECEAKGSIDGJAHLNERBFHNAF@DWTGHCDHAH@FDJV@TNhHFHDHH@LEX@REPITMXAHBFXHNDDD@FGFAD@DDDHHBDANGHIFQBIDMD[BqTG@oUE@CDILKDMBMCK@IPABO@ABGLKDOCGRGEC@EBADAFBXYNCFCJIDEJQTAJGJOHQDQCW@[OKAODADABATA@cNQA[FS@aIOGI@CDCJCR@TDRHJJHFH@DGF@JAXGJAHHT@JGHIBADAB@PABKAG@BPGLoREA@CAAIDEFAJCBKDKLGAK@QLIDCHAFGLAHgCI@IB[PKBAIACEAQ@UHAECCUECQ@EBGAGOMEAW@UCGDCFCB]OSEWOEAC@C@IHAD@FABCBSAGFEJ]LIFM@IBCEC@WDO@IH_JGDEDAJGBUEWOaDGDCFAF@NABKHSDC@GCY]QKMKECK@ABCJMIQCEBGJEBDL@HABOJINOLGJKXGBYESDKBEBIHUZIDQRGDKNM@IC_Q_BAAQIK@CBEJEFK@UCG@EBQTMHCDCVGHSFMHQLeAE@IHGHAH@NBBTNFF@FHvIFEF@HBDDDXHFFBBADGJBFDDHBLJP@PDRLLNPJxLZLJ@HCjgbY\\@VJntLTZTVH\\A\\@jlPX@NIFkJYLKRBJRH^HTHPTAJB`PXFJ@JEBCFBFFDJDHBNALDIFIJGDCDIDS@KDAHLJbFJ@RDJPHRDNHDNATLtP`J\\ELIHaJEFCJ@REVcrMLGTLNPRHLCPcTGNAJbRDPBLTRj\\DFFN`NvHTOESBEXHR@TDZRR@fIF@LFJ@LAJCJ@DB^XFDJ@H@BC@QBCBAL@XPLBRKFAL@H@FGVQNEBAAAMCICAMEGFG`JZEHAHDTBJ@DEDARAPED@JDHBNAL@dNNGvALAVHT@FCJOBABAJBTQHAN@VBFBFHB@FIEC@AFAN@NU"],"encodeOffsets":[[115797,35089]]},"properties":{"cp":[113.307718,33.735241],"name":"平顶山市","childNum":1}},{"id":"410500","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@D@BAEG@APEHDCJBFPDJAHMDCFAPAJJD@DEGI@CX@PEFEFMLBJKJAH@PDLBfIH@DB@DEDKDCF@PDDVFjDLCBCDKTMPe@EFAhJDD@NDHAFBBHDF@XEHBBD@FDD@BGDQ@EHBFBDNFH@NIFKDGAGJGJKHWXGBFEJ@JDFPBBD@DCDKBADBJEDE@CEC@E@CBGTBHHBJA\\OHINEFDBBBFAHBBHDL@JEFK@MCGIKBIB@BDTBNCLJJADCBOFCGGAAEBCCGC@ADCACI@MADCHBBECEDC@AD@DBBCRO@EDGBCNGHAP@BA@ADABBD@BFH@BFABD@@BJEVA@CBDHAJDHCB@@BD@AB@DJCCBBBAB@BF@@@AB@BFAADB@BEDAB@@BJB@CD@@CJC@AB@@CDBHCBCBBDAFAD@@C@@DJD@B@AEJ@JC@CAGCECAB@@AB@AGBCEEABAEB@BB@@@AB@@DBBBAA@DCFBACD@DBD@HJFARA@ADAFBHPABAHDHB@DFAFFJH@BCP@@EPOHOHAJDFDFFDHHDVIFEHCTCNE@CRCDBR@ADBDJDNCDCJ@BPL@TA@ED@@MB@BAFA@AD@@CB@@GB@@E@@@GNEBFHA@GRADANANALDVBHMBMHI\\El@PCLEPULKNIRETA\\@dGROFGJCAADA@@DABB@@@CB@@DTA@EH@@EHA@CF@@AF@@@JA@G@@@GBAF@BCEA@CC@CBCMFAFCFDBABDJA@DB@@BFBFEBBB@@ABJDB@CBB@DH@@CJ@@EFABDHA@BF@@FLB@DB@@JFBBBN@@DLA@BB@@BnA@CH@@DTADPJ@BFH@AETA@AD@AEPABHF@@FDB@BH@JNNA@CNCACDA@AD@ACDACC@AD@ACLC@ALAAEFAAKNABHL@BJH@J@@AH@ACJA@DL@@DD@@CFAAAH@@CL@JC@AJABDDA@FF@BFHABDFA@AD@@DJA@CXABRC@BBA@DNF@H@ABF@BDPABFDA@IF@BDNAB@@@B@BBB@@CB@A@AE^@@BJA@@DAC@KmHEFKRIDGDK@GI]Mm@CbMXINCTAJAbMBA@AD@AME@@CEGEAAMDAAIH@DHAGFFB@ACBCHE@EGM@CLW@I@EGICIEI@KOcBIHOBK@EM]AQMQCSMIMGUACCCE@EBMASDAPAFAFGAOG]QQ[UEMK@CKCAUAGAGGCG@EB]LMPGJKP[@EII@EPSBoEEKACCACAKAAMCQAEAGQOQAIBAFCJIAQBGDEJE\\QJCILEHMF]BYDMBgCUEEUESKEGCM@E@AHCJAfFJ@BCEIAKAWKUBEBCLETCFCHge_EKYYMFIBMBM@cFUFOAUE[@GBI@SK[WQIOKKEAE@GAEGCqC_DKAIEE@WFU@GAM@MCWACEACBCFCBIEU@QGMKIOGY@[BWJ_BKCUE[OUEmKMKOQEWIOECWI[EQISOEGCQCA[PQDIBUEECIKBAEAE@GDAD@FDHCNSBIJcEECCGEDAB@FBDFBJ@DFBFJF@DEFS@@BBBCJCFANFHBDJDJDFD@BAJCDCJOJ@HBDLBJCB@RVBD@FCHEDQFBJEFDDLCJHJBLDFFAJDHILWNCD@HDNNLFFBF@JENCNALCD@NCBKHCJAFNT\\THHBF@RAHAHSNQTGTOREJ@FHRFJHDFBPJFFFJHFRFNH\\NjNLFHJGPBHHBVADBBB@NKNBHDHFBD@jGFAP@RCP\\H@JCXFL@DBDFVRlJFDFVHFnJNAREN@HDDBFNDXFJJFHLLDRBFJNDN@HDD@HHJNL^T^BHBX@NCFMDaVOFUR[@iKC@IFIHIFmFQFKHONENDJAD]FAFENKLGAOGIBABFH@BCDGAEAGGGOECI@ODgHcFSCM@O@KMCAcDCAGICIOAUDUAODWGmBSB]EKEKIKGICmKOAGCQSU_IUCACFGTQ`Kd[tG\\BJ@DJPFHJFDH@JBFJDZDNDJDLJBDAFSNAFBNHLDTHDRDFDDJAJPFJLFH@F@BGDM@MGECGKG@AJBP@NANC@WCKAQDKDWTSHKJCFAXADEDiLIDELERGNGHIDOBq_[IMKGGASMWBIHGBC@CAAOCOBIKCAGDM@CCEMAEA@C@]LMDQ@I@CA@EBOAK@GDEPEBQZINKPCJCTKDCACOM@kEQCAOAICQMSGeAKKAE@CDELKJSBANEFCAISSEIAKBAD@\\LD@LIDAF@HDLHJBLBNC@C@CIQAMAGIGFOAMKKOOWBUWQGMM_CCAAEE_UGKGKIGCOBG@ILGHQFMBAACECKBECKCECAEAW@MGGBOJGBW@aKOAgGYA]DUJETFTP^BZ@ZIVSLiriALCDCBIAG@CBADEDEACCSEEFELHL@BEDEBEBmAk@MZKLGJETXLRA\\ATEZENBNODENBZJHLBhGVGNBPLBFBHINIHIJ\\FHHGJqFSJBPNNNHVFDF@D@DIDADFF@HAJIN@VGHG@CF@BJ@APCHEACBCHCDMH@BFDJ@JBD@@EFAB@DFD@@A@CBATBHAPDDFB@BEB@FFH@BHC@C@CDEA@JADAB@BHHADMBABADEBG@MCAAA@ELBFIBAB[FGFIL@BFBTCBB@FPCpLDBBB@BADURADHDDF@@FEDBDDNCEL@FGLMDOBCAMKA@CDDF@FBDDDJBTHTNDH@JCFAH@FDHBBF@FBBFLBBFAJGTA\\EJHJDBRBDBBJLNJNCNKTBN@NDR"],"encodeOffsets":[[116462,37237]]},"properties":{"cp":[114.352482,36.103442],"name":"安阳市","childNum":1}},{"id":"410600","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@FDFR@lPN@D_TODMLYJAROFCF@HBLAP@FDBJ@R@NC^KD@B@BFFNDDN@HCDBJLPAPDBB@DADGHAJNXBTHHNL\\Jr`PAJCLMDGFQFKJCjKFCBCBWDELITGXSLCRCLBXDD@BM@MAOBIH@HLFDNHN@HC@A@EEGIKOEBICIECQCGCCSGKAMBETMBEACKIICMCYCICAE@ICGIEEGIO@CAIH[\\sLcR_HSDEDBJVV`RTHDPBnLJDLHLJLF^FTAnAXHPCVBVCPBDJHJDBdCDBLNP@N@TDdEhGPCJ@FDHPHHFBHBDC@AEGBAJAPHHBLKFMBE^EBCCIFMPMLGREnEJEJGJED@jL\\@VQPEbUNCDE@MAWAGS]K]IMGGC@GCM@MCEIQAKCGKIEEICWEMCAGCM@QFMBmIGEEUECkIUQCECAK@WEIDG@O[QDO@EBiHIACGAGLM@MAACAUBGAAGHOGIKEiM[MMGQEGEEIEEOIEAGCEIGQ@EFIPQFMqgiOIBE@ucK@K@KDIHQPIDQ@GDIFEFAJBFFJAPBBTHFFBJ[@_HVSBKJIFOAICG@ODQ@EDUFULOHeZIDuDIDGDEDAXAFEHWREFCJH`@FCN@F@DLLBHGXCTObWNGDUBCF@LEFSFWLE@F`BFDB`DNNRHVXTAFBVVDDBNEPJHBHBNJR@D@DMDKAIAKGGCE@CBKJC@[KC@ABBLFJTTBJEDMFABITKLCF@DBFLLfBTHRNJDN@"],"encodeOffsets":[[116807,36734]]},"properties":{"cp":[114.295444,35.748236],"name":"鹤壁市","childNum":1}},{"id":"410700","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@l@nBFAFAFC@AGKFKFETFDDFBFCBCDAH@JBDADCBKjjqTKJU@YAYO]ESFSVI^CZBxJbLX@HAPIHANHX@FBDBDFDLAFDLDFBBNAREHGJKH@NCJFLJLHVHF@XKTEFE@KDEVAHCXMPaDSHWAGKK@C@EDM@EG[@GJKXQFGBEBWFCRGvCJCfYPGVKVEFCR@PCH@JDPBJELITAU`G\\@AIEESGAABOEIAEBIFEJEHCR@JCROJGLCL@L@vdF@JAjPrhBERSTMBGBG@QAEGG[SMSBEDILGDA@MDCBKDMFM@IAEEEMKCM@GDCXMJKCGBIEEKCIAIGKDCCFEAIREFCDG@EACQUA@IDKACEBEPIDIDCBG@CECGAKEGKBMDEDIAA@AP@D@FE@CIEAECEK@CCAGHEDHFDdFJITADMCG@EBCHCF@FBABJLFDVFJAPC`OBBDRFHTPRJ\\FXJFDJPFXPRNLnLVF\\PVFLD`AXINAf@FBLFLJHN@RFVAJEDADBDDFXBNDN@HBV@XEF@JFLB`CrDHDBF@HBFLFPLRJ\\XTLJ@HA\\@VFPBdGVCN@XCNERUHSDGDCZE[EgO@GCkiEI[_IOCMEI]EMCEC@mDwACECe@eE]EMEOGKGKKQYAGBIh[XUPSFM@M@GMO_QsKGEKQMYJKVGdADEBGAGEGQMWKKCKFeQSMYYWQSCOMMQCG@IDE\\SZUJEJMDOAEGK[UGA[CS@IEI@]N[Da^GAAEECMEGAOBMDMBID_HO@[FUBsMiMWC_C{RVOHcZSJMHM@K@IE_cSMOISA±DGWNIDKLYNINCJAD[E]IO@GBYRSHSNOHQ@SCUKUGQBKC]BYPSNKBICECEEEGqkQUCMGGMISGuB[HOCuWQG{K_CsFKDOPS^UTGDYFQ@_COGMM@OHIP_VKBYAMBIBU@aFDP@ZBNFLT^FFJLDBLFVFNFFH@BABG@KFEFAFBDF@VBDFBBCL@V@DY\\IFCJINK`O^EZGRKVEBOAQGGAIBA@AD@FBFAFGDQBIBGFONAHARIRCPGPAH@^@HNRLDNLBF@FETKTSTET@HAXG@ELA@Q@WCGB@BClAFGDCJDV@FKFOPHFCHCD@JFBNAFDFHCLILIHKNCJ@NGTUfibQHQNKDIJGDCDADA\\GLGFHRDDFDV@ZRDAHENDLKDAJBTHHANHPBNDTFLI^@DH@FSTJPFPCH@LDPNPTPNLFNJ@HDBBALHJDTFBLBDDAFELARKTBJAFBBPHFAFQBCBEDCPBBMBEFE\\ChBLCLBBB@jAJEDADALJHAFORULUFAB@FNHFNAJSbGRANLVHJFV@JINAPKEE@ED@FDFNDFBV@BFCBGBIHOA@B@FFHADGBCD@HFH\\EPBbPLAJKNCRHJHDL"],"encodeOffsets":[[116385,36697]]},"properties":{"cp":[113.883991,35.302616],"name":"新乡市","childNum":1}},{"id":"410800","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@HEHKB[BCDCHCJILCRMRGjaVeHS@MDILMJGJKDKEGECMBEA@IDCDGGEPOLE@ECUDIHCBEDk@AHAXDR@B@FKH@BW@GFSTSLSFS@EAEMKKCMQ@G@]BGHODOJQBQBGPMHEJARAHCBEAE@EBCB@JAHBRHPBFALUHQFYP]L_JMDIJEZ[@C@UDKAACEUAE@ACBEFELEH@BA@AEGMEUEKECAIKEES]EKAM@YCOQPQRULWRQFW@aCgMeCwFiH@L@NCNOHWDeIcMQOUWQOSKICOAK@YJYL_D[AMCSKGKE]@[COQcCOAEIIWKOKQISGa[IAE@KRSNQHWAGMOE}EMCUCWBQH]ZQLWFOBGAGOEESIkUWKI@o`YJcBEACCKcMES_EEK@SBUNINYFIC[COHMAEAMIMEWCyNcZgFQJeL[HG@CV@`@DJHBH@LGB@ngBLIHAFCZKF@PADC@RXHD^AHBLBJJFDVCjBJFDJFFXCTLDFN`FHVNZLVFJFPRBbPJDFDLDNHL@XTLFFBF@FCTAJDTEFB\\@DCDD`FTAJCHML@JBDJAH@LHFHHPJHBDBFCF@HJFRBNNLFDDDLHD`EN@REHDBABIBAVGb@DFRDRCJA`NBDHFHHHV@DEH@HDFXBHDRHLDD@LGLAFAJDHN@B@JELAFC@ABBJAlDDNJBDGRJF@DBBJ@NGD@TCPFVD`KNELDHGFAPOVEJALFJ@ZKDCH@LFJ@DDBF@BEJ@DPDD@D@APBLCDBDBFF@DAB@BRAFD@DGBBDDCDBDJFBAHB@@CB@BFDDBBFD@BD@BE@DDABAAEGCDEFFBABBDAB@BCBCBDDCFBBBBFC@ELHPEBCBAFF@BCBFD@BGBAF@HJADBEF@DDBBHALBJ@DC@@BBBZ@LCHBLDHDPDHAD@DEJ@DARQRBDC@CBCFAVBNCZKJABBBDEJIJ@JDLHDFH@JFBFGFKRD@HCHYJ]B@DBDbTNCJODCnAFDHNFDN@LBZ^"],"encodeOffsets":[[116105,36347]]},"properties":{"cp":[113.238266,35.23904],"name":"焦作市","childNum":1}},{"id":"410900","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@BQA]CEAE@GCGAAAICGAGIK@AAOE@@ABA@EG@@BEBGSB@@CF@@KGB@ECBAAA@BBC@AEGA@EGBAGD@BID@@DBB@ED@B_CS@SIEoIoYEECCAQCECA_BKCCAKcG_FGPKFGBIEm@GEGCUCAAOC@@AWF@CG@AKHA@AB@AANACYC@@@AIE@DEBEGOI_@WAGBCv_DANR`TVLRLDDfzZ\\XRtZRFfV|J`HpLDRBRDXC\\AJER@FFFLHFRHVDHFLHDVHJABD@PJfJ^GlFTBH@NF@PXTI@CDBBFFbVbJRCT@D@RKPCL@HDDFHNvVF@^KL@HDZTZJ`JtHHDn\\ZXzLDJBACADIGA@ADAAABAAOC@ACC@@AA@BOIABGC@BIB@DKI@AGC@AEA@@AV@KGMB@BEB@CB@@GFC@MAEA@AOEKUFOgESCmCMAAGCO@N_@wKOBCCA@GC@@QCBHW@EEGECIAWAYECAEID@@IZA@GHMKE@_EB@ECB@IA@@DA@@IAWGAB^E@@GI@CYEC@HeA@MQ@UFCME@@CQB@FM@yLOUAIW@BKe@AKCBGWOBCKD@EOUFCS@OQ@@KFA@[E@@GC@@SyEQC[KOASAAAC@@AW@kACMECmRA@AAEKGCgHI@CCAICAYB[OWQW[Y_Qi[cMG[WCGCQEUCEMIQSGQM@@QYDAUE@@FOFAUE@EEMBBK^GCIIDGUJaFM@OAC¥aUMSQI@MKGC@ADI@C_YgYKCM@SDK@WEOJcBeCaEUE@SEAAOI@@fA@CA@[Q@GDGFCF@DCDEBACCEC@CCBEDGBI@IOSIOCABSEEKCWCc\\YFCDCHGTQVZZFLf`GhEDSDKFADAFLV@RDRFJABCBkEIBGD@HDNFHTLVFFFDVAhCNAZE^GNKFJID[RIFCFAHBRIJEDABBJPRHRFBRBNDBBBLBDDDLBFFApOT@FJJ@FO\\ILOHKNA^@FDHHHHBVBDBDLL@FN\\VRRH^BPEHEBOBCBBTAN@FDFDDVBNHNJDTNRBRN^@FALGPAJPd@LFJDJHJ@F@JKX@DHN@FGFADBDA@EEBHCGG@BJCBBNFBFH@DF@BNC@@BABaNIBSBMDmTXDDLJDFHFBJ@FHDBH@TFNG^ARHZTBJETJhCR@FBFX\\FFFBH@|OH@DBBDBTH`DHFFHDJDfANCHCFGAKBAFCVCPDH@BDBADBFBBFD@@DFA@FD@@FDB@BC@@FB@BBFB@E@BBAL@K@FAE@@C@EPBFATKPCVIPIV]HYDGV]FCJE\\EFCBE@IESCG@ILQJIJCLAJATHPED@LFbRHHFLDXDNDBZ@DBFLD@@FBDB@BDA@BDGF@BB@D@BHBDB@DLD@CGDA@CB@@CACFAECCC@CDB@CB@@CF@DAFAJBFDPRFBZAFBBD@XBLFDHBLABABWBCFGREJA"],["@@GEGAMJCH@FDDHBJFLDDABCDEBCAACCEI"]],"encodeOffsets":[[[118256,37017]],[[118278,36761]]]},"properties":{"cp":[115.041299,35.768234],"name":"濮阳市","childNum":2}},{"id":"411000","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@REBAAIHABCEYLCBGBEJ@DBJLZBF@HFBABKXA`IDCEIBELBD@DCDIBAX@HC@ACEAE@KF@LFHCBG@KLKBGBAZ@hGFBBNDDVEFBFJFADGTJH@HA@@@KN@HCJQHGACGCAABCLEBC@CCGDIFCL@LADEFA@CP@NFXBFHDPFDTBn@FBBFBVDHPNF@FBNEN@pBVIHEJMJU@KEcAY\\@IEQEIKICEAICCOEACPBQBCJ@FCDGH]LeDIDA\\CDCBCCODWCEEA@KHQAEMAEMFwDDGJIH@BCKQJKCEBEEABC@CACUA@Q@AT@DG@AD@B@@GPABKCC@GDE@ECCKGACEM@YEK[IEGKCM@QHmHEDCBCRCBE@MEWBGBKJKJA@GEA@CFMDECMA@LCBA@@ECCA@EDECI@ACCBEFCHBJHHIPIVGPCDMHILQJMFCDAFDHHJPNBFETBN@DEHBFBJCFEJADG@CFMA@AE@BKE@@FI@BDHA@JJDEHS@KAABEJ@FAFCFIHG@OEKDCBAFBBAJAFHBCFEVMFSH_B[AQGm@_KSCSIaQEEISCE@BG@@HUABCEADEO@IBCJMAKBIG@DE@@BKBBMC@BACAFOC@@CFBBECA@GHBN]WC@YDB@WCKMIKAiFC^B@@DGB@AE@BACI@BG@AAA@@@I@@CBEA@CBCAC@CDCBAEA@MDKCKHWC@ADA@CF@@CH@@CGA@CM@@ED@@EGAAF[A@DUA@AD@BCC@@CE@AC@AF@@CAAC@@AG@@AG@@DAOCCH@HEAI@EDC`KZCBCBcOa@W@EAKEBAKKB@IA@ACEABGEEA@@EB@@EB@@ILBBGNB@AD@AAJA@EF@@EFBBMA@@EE@@IC@@AG@@AG@DCI@E@CAACDIAEQMIAGBENIPC@EAACEMAMCCA@gD]LqGENEBCABMAEGEGAOJIDG@]OATXXu@ABAJFLHLAHGDE@EFERAPCBC@KEEAQ@CBEFCHCBCCGAOAUGMAEDG@]KwIWAA\\CJCFGDMDE@KEMDMHSHEDQDOJSFAB@BRPN@HDBFCBE@CFI\\BXHN@HAFCHIFCH[fCTJTX`HLJbTPPFNHDRBMRINAVIfGJKFUDQAWFKAEEAUKCI@M\\EHGDAHBJLJJFGLGDMB_VUDCDK@CFATABUCG@ABM^GBMCIGBMAMKEO@ITWLMU@SDCBKHGVI@IJKB@LADEDHPAHWVENEBQZCLBJHTCPSLeHMHCHBZBLBDBLJPDJFFDB`GF@PBRHLBZHNBDEHAFELDJHFJLBFDBDAHJ@JJ@JDDBHJJDJFBRAJBBBPRHF@NBFXJJ@RCf@PLBPBBHAJDTCLBD@JALBBDGPDNAHLNDHCHCDAHDFLH@FDDDBNANDPCHOLAHEPE@CGM@CPCLAFFNEDAXDN@FABCACAEGO@CBAEGJEBACGB@XALFF@\\OBCBAJBLIJ@PGD@HNFHFDH@XIJBJFF@NMBACKPMNG^INAJ@RLFDN@VA\\KP@`OBGHIHIBCL@HAFMD@TMD@HAJBRNHBRCHCHEF@FDBLADIDBD\\DBD@DCLFBFFPBDHND@BCDFFFBLAFCTCfBBDHBTRDBCD@DHBHFJDNEHEPCFENEL@HAJ@B@DJZAFDTBJ@JC"],["@@D]]HDJE@BDB@D@@CHB@BA@DJJA"]],"encodeOffsets":[[[116619,35152]],[[116557,34704]]]},"properties":{"cp":[113.826063,34.022956],"name":"许昌市","childNum":2}},{"id":"411100","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@ACF@CI^G`CJALBNJDL@XCA@ZXDM^GA@HDBAFEA@DD@EPDBABD@ANLA@AF@@CJHLANBDIJAP@CFFBADVB@GH@@ADFJTFFbRTJTD`Ln@RH\\B`ATGNEFUDEGABEBIAABEDALCPFH@JGDEBE@EFIBALBT@FGIC@IGBACJ@@EF@ALF@@BPBBEH@HMDEAIAEFG@CAMFSAEOMGICGBEDCNERINMJELSJUJOEECGGDE@MEKAC]DEFEDG@YDGIDI@kEY@AA@IDCHAB@@MFG@MGKQKAC@ICGBSJU@IBOJ@PDJ@@GBMDEEaBEJBH@ZCX@HB@DCJBHJJJFFCHGH@LNJ@FD@BAHBHTRPDTCJLVBZHNFDIAMDEPS@CBaFMBgBGDCTOBCBG@WAAKEMCAE@C\\oDQDCVCBABCASEW@MCGQS@EFOGO@EBEFGBWcUGAW@GAaOKA[F]IAAE]BGCIADi`@DBDPFBB@HCFEDGBYEQJADFJMFGBS@ADAB@FBBAHF@BD@DEHBHMAOGAAQ@ABCD@BBD@DAFNDNBDD@DEHUGBAOCA@AJADIACB[PcHCDGJKDOAIKEAEASBEACUACCAODC@AA@IAGG@AKCEKECIAACAW@AA@GQEI@SQA@SBKFGFMF@DEBWBaAiBK@ICOSUKYAQSKAEGEQGCyBGG¥@E@ACE[G@UDGAAAEQCBCD@PABI@EDKAUHCAGIOFI@OIMAIIC@E@ID[@GIGEK@QFO@Y@ICCBANGFCDMBM@GCCQECIHELGCG@MDUHWBGBCBA\\BBJFBFAhXj@FBFGDCP@JFGB@T@BAD@@BP@BJF@@FF@BELA@@DAFDD@B@FGHGLBAJ@AEP@JD@@BD@@DB@@DBB@DD@@FA@D\\HLAFD@@DB@@BH@@BDA@BFB@BGB@BE@BDC@B@@DDA@BD@@AA@A@F@@CH@AFA@@DF@@DF@@DBDAFK@E@@BA@AJBBBBA@ABD@AFC@DB@BB@@BAAADXHBEB@@FHB@CD@DFDBBA@FBBn^JDbNHHFLAHEFIDm\\KPKZAXBXFJBHMJv@WWBS^PH@JCPIHBHFBFANDBFAFMrH^KhCB@DDBNFNBDFBD@JOFMHAJBJFHHBFCJBDDBF@J@CDH@@BH@@BD@@JF@@FB@ANEA@FE@@FIBBBC@@BMAAHKA@JA@@FA@@FB@FFAHFBBDB@@JLABLFABL@F@XPbAdADYD_LCD@FBJGFG@DDBP@CH@@BH@@BD@BB@DE@@BBDF@@DD@ADC@@BVB@C\\BBEHB@FC@@FN@@DHB@DG@@DE@@DCB@BXDLGLDNCB@BFDADCD@DBDAB@AF@DJ@@@"],["@@IBABF@@BH@@EA@"],["@@B@@AGA@BCB@BJ@@A"]],"encodeOffsets":[[[116544,34700]],[[116557,34704]],[[116550,34700]]]},"properties":{"cp":[114.026405,33.575855],"name":"漯河市","childNum":3}},{"id":"411200","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@YKCA@G@UEG_OACBGXQ`OrQ@C[KBEFE@A]AMCECAA@EJKHEHAR@FADADE@GAACC[McKM@OBQOKMMEQCQGMIKQACDKCSBCDAJ@FAJG\\ATATQTKPKBGCK@CRARB^LN@FC@CKICE@EBEDEPEFIJGZOJGDGACKAAA@CBGDERGFCDBDM@EC@EDQB@EBABGB@JBF@DADEGBCAEGMADE@IGQCCCAOBKA@GNMLGDG@CEI[GEECEBEHSBEAECEUBCCBCFE@CAEAEKGCECKN[ACOAAIEE[GIKKGAQKOACDMEEIAGDmdIBMECB]bGNEFGDODcA[DAA@ABK@GACCCEAOBGCIESOMQGEECUBG@CACCCQIA[HSEOGQEQGCCKQGEKA]@C@@ELMBGHUXW@CACC@QBGDMLSFcLqNUL_FCCAGACGAIBGLADO@ECCGSMOOC@MAGBGFEB_AMCSQEEIOKIkQKK_gMGCSQQAKBMNEBWMIAgA[BGBCBCFEVIBKGe_@C@EFY@EACI@oLcLI@CCIWCQBIAC[UQCAKDSAACCcG]@QMCE@MII@MEO@CDEBAfCJGDCFUDIJKRMN[EWIICKBYCQBELKAIAGIWCAGAQBIAEC@EVMNMzUFADEBKHODCHAXBFAJQTODMDCNGJCF@TBBE@IBABAVNF@F@JCFEFMCOBEDEHEFAf@LEDCDC^@R]ACAAKCKIEMAKCIGGCM@eBENMFKDMBUCOHQCEIGMO_MGEGKQOEEEKCQAGAAWAIBCBALABC@E@MEOCE@SHM@EAOKCEEM@GPWBGAEMIACGBMCEEIDBFCFC@ACAMJGPEDCBCAQ@A\\KDENWhaBEAYB[EBIBUCCBKHC@K@IGIQMICCK[MUAWD[AEBQAGAEEIKGESCOACWEiFECGGM@A@@KBGLOLEHEBEBO@CEGIKSKAEBWU]GKI[CCSEKIMEACCACBSFKAGEGIGEEAYAWEQBWRCLIZOJEHYRKNIJEBGBSCGHOP}PG@MLOBOAKBip]JIHGLALEFIFEL@FLRALHHBFADIFIPGNAH@\\ADQHGRENAFQBCBGJBLCDCLOBQCIBMFICMB_TCRADIHKVABGBSBKBMBMNMDGLI@GAQKIAQFE@IEEFGBQDAFBP@NYFAHCHOJCFFXDDRFTHV@LBBDAFGLFJDBJBNLVJ^BHBDDLR@BGJAJ@H@DeFGDBRAZW\\AF@FEHGBEFBFFB@BIJCHIDGACEDE@EGC_@G@GACDDHBT@BKDCBPDCFFB@FIBJF@FCB@DDBDHBABABB@PCbEPBJFFFBPFRJJVHBJJBD@BEFADTNJLDJBJCDGLCBQFGJ[AG@OFQA@HFNAB]DMAIFK@ADEHBDALCJCDIBGDO@UFQGE@CBMLMJIHcFGF[FQBKDCD@BJP@BADMNANCDKFDXJFPARDJFDFJNJDBBDHFJBD@FDFRGF@X@DBBFAHFNAVEJSJEFAPAFEPGHANEJ@HDRBFABEBK@GEIGEAWFYJkXAD@DBHMHBDEDDBCD@FDHEFAFGD@FCF@JMJELEDAFCFBD@BC@BBCBABCB@BGBAD@JCFCP@DELBH@JFLFHHDBHDFH@TL\\JFB@DANIEWAUBKDGD@FHLHXJZzURCRBJFPN`dLDNBPA^MZOj[VKPCNDVH`bHBEjAFBpzPLJLBJFDJDN@fIdYPMNIZBZNTFpBZL`h\\pJZ@`CTBFFHJBV@VINKX[DCJ@JDtdR^L`J¬JHFDDJfNXNTLLNLJDH@HCTQJCXBRALAHEJKDCFAJ@RDFDTjFHLFF@NE\\QPEJDXNTHNBLFTPJBJADAFIJENCN@HATCHCDBHARFLLLHF@HARFFDBDFHBBXCDAZQH@LAJ@NFV@JBJLBHNBPNJFLBPDN@LAJC@EDCLEHBHHNHDD@DHFDHBLD\\DHXNN@FBDDHX@N@FFBFAJRLJNPPDNAH@\\PHF@FCHCH@NCHEHON@FDDFBdBPTD@P@NJHBFAnBBF@HLJPBXCLFHH@LFDF@VENBNJFNDRCZ@DFFLFLFDhMFBTPJBDARKJCLJFHDFJBfAPCNENO"],["@@AICBBHD@"]],"encodeOffsets":[[[114661,35912]],[[114721,35618]]]},"properties":{"cp":[111.194099,34.777338],"name":"三门峡市","childNum":2}},{"id":"411300","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@ACABANDBFECG"],["@@CACCG@ACGAIBBDNJDFFBBFFDHCBCCE@ACE"],["@@CAI@CBCHPDB@@CFEAA"],["@@CAGKI@CDCNCBE@OIKHGBQEOJEC@CJI@AGEC@CBCFK@EKII@IEKACEGICMI@_AEECIAKDGHGDGBIAAA@CBGVEDE@EYBGCGLEAGDBKHMKCCCC@G@IDEACIIGGCBEBCHAFMDSECICEAEHATFZG@GCC@EFOBIECGOI]K[QMIICGDCAIKKC{gKCE@INKDWBCFCNMLWHUGUBMF]d[FCHBH`T@FCFMHKF]DKFEL@PCFIBSNKL[LmbEFGPCNCBKBIHGDE@KCaQ[@IEQO@GBKG[@MKGKDIAiCGJEXGNS@UCKEE@gVELKNEFWBIFEBEACEMEGAWAKKKUF_@KGKUEMDS\\KFM@FQC[YSCCJB\\CHKBSCs]]GaIgWGGIBGMBEIGICQBKBMJMFBLCRIASGKQY@OHMBIDAB@FADEBGBiAMD]XSDQJW@sFCBCFMFCDGCQLGBECACFGAGIOOMQLC@QEI@QECEE@EBOLIAEKEGUC[UAC@EDIHG@AA@KBQJ_LEDCHCF]LODCKACQDUDOCCACOKMYCOOAECKBQAAGBKNGC]NCHKFEHMHIDCBKBADKHK@CDENABODCDKDGFCJ@FCBC@QDUJWCCAE@QGOA@FD@BFF@BDADCBBDG@CB@BBB@JDD@BCCC@AB@DIDCCCAADEAEDG@GE@AC@@ADABEDAFAHD@CFBFCCIDCCAAAE@DJA@A@CEDEKE@ERDBDJEGKGCSJGHCFGBCDEJCLC@ACECSFKFGLKJKFQBGF@BBFJJ@FCDE@MBCDIDABAFFRBPGLCNICGAMFIEIAIMOGOMGCIBCAADCHEFUCCDBBC@@BHFBF_HCBAL@DGFAJCNILAHEFCJEBADCBQBSCaOaEQAQFQLUhOHWCa@mTe\\QLQDSJSPOZe\\OFQ@ULoPMCIGGKQEGLALDTCNMB_O]cMIgWIB[NojKNIfDNQTIVCDKHQHSPMFCDAJQL@DHDBJADIACBAHEBOAYBIDUP@BBDF@JCDELIBBD@ADEFAD@FH@BAHGFCJEFABBFJLN@FALBJJFDFAFILGJCDC@AC@GDEAACCGAGBIAACBE@AGGKAQDGCCBEFMFER@FMNDH@FGHGNCBETIPETINKDOHOFwHUJIJ[LE@KFEDAFDXCNBRIRKHGAECEEIMSOK@EH@RHRARM`BNDNPXRHLHLRI`SfWTMHCNFLAJEFIFQBFK@aKOCIF@NFHNJXNZDVJBNEPKNOP@LFLAFULE@EFG@MFUNSP@PEH@BFF@FQIAFGDKBIFQZGFKDO@OCUKMMSSIAEHjnCTIPcPABCJIJMDGJCLCDKDQHW`LAHGDHKNORBDNFBBAH@BHDFJ@FAPDFL@HDANE@IFCLFJFBXBVJHL@FGJEJ@LHVATEJKJIRAJ@RIRCFObFHlVLfAXDXCZM`EHYPAFDLAH@FLTBDPMHCFATBPDR@NDHFHJHFLBTEDADBBDNFLJTFDDJ\\HLV^AXBFTLJLFH@DAPAFGFKFKPAH@LB@N@HHFDjERDHFDPFTLHFJBFBHARBFC\\BXNVL\\DDNJJRDDFDL@D@LGDAVDJAFANUFGFCJ@NBTGRCPQFCFAJ@FBNFHBH@PE\\BdHVBREZMXOVKZG`EPE^WV@XLRRPDPETKvBZGVE\\D^@ZGZKjqPSXQrTTDTAXKxUTIvQJAVGHKHYB[AM@ODIFCVE\\BNDR@XE^OVSFGHEJAR@bF~PdFtFHJJBABAHEDAAEGAAC@AHC@AAALFVTRNDNCZWPKNFPATGH@JH@LILEVOHGNAPDJVHPBZH`NVRV^FVJVRNTDTMBWLIbNZRRDxFHGJGF@fBRKNGTEHGDUDCNGRSFAH@VDL@FEFIDAL@RJBB`A`RJDN@LMHCRQJCVYJGFALATCZFHALWHIPKJMPIBA@GCKFAHIFARDNJDIBAL@FDNLRLZ^HDD@TCLGBA@MBEDEHCbCXPVFHABIFCHC`IJGP@XCD@DFJAN@JE^KFIHETBDABA@EBCJGD@D@FBXPTF^PDADEHCVDX@FBPNBHAH@FDRVFDDBFVGR@FBBDBJLA\\OJAJ@hDBGHKBEDGJCRKL@HBLKLCDABIFEJCBB@DFBpQHKAOH@LBBA@OBABCJAHG@IGSBGHIBW@IHE@CEGIGGICQ@SDQDIDCJ@PHbJT@\\ERBdMB@BSBABCPCLB\\PX@RDRCPGHIBIRSFIJCDIDEZMAOBMBCFAD@HFHQPDLCHKBAP@BAJOL@NDNALCJKDCF@pVH@rS\\ANCJCRAFADCHI@OGGCC@CBCHE@C@CCAMCQCECAEBGNWJSFO@QFW@KGGGCGEMg@SIUECG@GBDCHGXS@CBEGMAEFQKMBGHIJC@GAICKCIKEKCSQECECWCWEOMUGIBSFuBQFK@C@MKCAW@cWYLQ@ICGECMEGIEUCEACCACAMYUMU]MIKCEI]M[IaKSBCDAFCL@DMHCrEHDDPBBRIFIFGZEPGXAJBLCHCGQAG@KEO@AJGMOIC@CDCQIS]EAEAEECKAEDEBANCHGBGLEBAAEOWBCLGBCCKBGCEMOBEnqDI@MAAMIAA@IAI@ID@LFJAFC@ODEHGLAX@LEHMAIECAA@CJAJBPANENUDKACIKG@IRCHGBIDKJCJMHMDCASIGIAMGMGGMCEECKBCFGDIRADAAiGGCKHKBG@OACAA@CLIAGBAFAbBNBTJFDL^DDPAFBF@LCTFJG`IDAJODBLRD@F@LUXIHIJHJDLAPELNNV\\bJLHFFBFALGLADADCFIHARSJEJCPDD@BUBATHF@NC\\QR@PDHD@PX^F@PGNAPHPLNHJVDVLHPPFJBTD@HAFBBDADILXJ\\BBFE^BNKFCF@B@FJVDDD@FKDAHCPBNENLDAJMRGHGJBNCLFHBL@NI^MNSJIfO\\QHALHHALCDEDGDAJA@CKUBGDCVIBILKFKJEQEGEAGUIOiIIOCIKAE@CDGDELCBCKECEACAIIYBOFSBI@SCSECMGEBEHIGCUCAA@@JCFCBCCAYIWKOQKPI"]],"encodeOffsets":[[[113686,34275]],[[113699,33975]],[[115440,33134]],[[116448,33196]]]},"properties":{"cp":[112.540918,32.999082],"name":"南阳市","childNum":4}},{"id":"411400","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@BGACBC@IASGOAQPW@CJE@UIEQQWABWECEMCCG@ACBEAEIKFIVSH]XKPKNELKJKBI@EOK@EHIXIVEH@`DNAPC^OJKFQRQZKLATKfK`MFEDGJ_EKOYBEBGPEBDHHbH@CLB@EB@@HJBBED@BD@@@CB@@CD@@DBGD@BCB@@D@CBB@BB@BA@@@BB@@ALF@CHDBCB@CPDFBADBA@DB@D@AB@@BBB@BPFH@DCGKNMBITDHFHHJFJJLJ\\LZ@lINEPA^EDAHELEBAFC@G@IEAAESUQEEIECQ@CCDGAGFGACECAGBK@EHIGEHGAIHEBGFCL@BOJI@GOIYGMKEG@EMaAU@IFQFCFC`CLEJIJOBKAGFI@BD@@AF@BCBA@AFB@CE@ACJK@GJGBIRKJYFG@GAGE@@ADACBBAAADAAAFAAAHAAI@AbWAEB@@CPAACD@@AF@AGPBDADEFAHUCEIIIKDQFEBMCGGGCI@MJ[@ICCKCO@_N]RUHIB]AE@CCGGAQCID@@ADAAE@CWBAKICAB@ACBAD@LGBACC@ACG@AKEGQFMAGOKBUHEGOIQBACG@COCCEAAC_ABE@IGWAWHWAECCCEKDGCEFIJKDEKCBGOKKBAAEU@AEEAMBECIBGEQBEDSCQECOKBKHCAAGKQGC_GOEQQCIMIcAGDM@mGGAGBGAICMGGGOKEAYAKBKNGPCH@FCHBHGFELEHqNIJCJENFF@DAFa@MCEBEF@FFH@DQF@B@FUJBHF@DFBF@BEBAJYB@BBJDDH@@GRCDD@LBLDPABOHABDHBPEBE@GBAFKNG@GC@NKFIBUB@VABCFUDOAI@IRBLHXDFH\\FHHZBJCJGJafURSJQAmDMFOCMBGDCFCRCJOHI@KG@OBcKBKAQBGAEBCDELBbADYPGHIFOPGLcFEHMFGHEBCCMGKASBUJMHEAOISGAEQGAB@FIDE@EAQBIAOMICEBKHIAEDELARAFGJOFM@KGKAQFO@K@MCKBMDyAC@@AHSFwAKCGKKKSECEAa@EACAICODM@GAUMUCAAEaAEAAc@KBUFiHOFQLUH[TKFMAQGCCGK[CEACCCKkBEBAHBFLV@FABK@aA[EIE@EB]@QCEKIKEMAG@kXIFGHECAEBEHCFIBG@CCCKIMMIEI@GIYCMBO@EDGNCB_HI@ICGIGM@ABM@GACA@eEcFQFK@EDCD@NDFHDBBDRLHBD@FGJBFFJHJ\\Z@DCFORADDHDBNBtCZFFFHPPRHJ@F@FCDWPIJEj@NJHFFAFCJ@HGH@B@DJJBFD`LNBJC\\UVCHAFBJJNDPEBG@OEC@WRIFKD[D]@MDEDCFENCNAFOBiLI@SEK@GBCDINAFCBCBKEIAGB_RQTCBC@O@Y@IDQBCDUTIJKDGBCBCZITKHCRBPFR`lBHCPINWXIR@FBNJXBRHHNJVFJFJBPHNLNRDDDLEVAJBFFTDfAJM`AL@LENCVOb@HHNBHG\\JP@FAFKJEF@FFLNHNDbBTHDF@FAHIJ]JSLGBaAKC[OG@GDCD@TALAFGDWFBFRLHJJJBHAFUFOBID@NMDCFDLFDHB`BRANDBNFBH@FCZSbMbS\\CHBFDFDLHPDFFHB\\@PFFADCFAJ@tXXDn@`@XEP@PBLJHLLLLFRDL@NIPMFALDJJR\\JF^HxGbHTJ^X@HALOVFDJJFDPBVEH@bPP@FAZOjMNMHCVCHGHANFP@^KDCAGDCFCDEEC@EFCVADEDMHIBKBOFSDE@EHQCMIMI[FIJIFIDK@KEU@SBGJSRQFU@ODALBHANGJOBODENQ^]LONGTG`E@CBAN@NHL@RCH@NBLBPAT@NFH@^GDAD@AB@BJGLENCFEREX@HCDBBFHDNP@L@hBJJBPANOLCV@L@RAZA^IRAVEFC@AFExSLTJBTjBPHBbLX`Djk\\QdDxZfCbaNaTYLCFEHCTBdTZJRL"],"encodeOffsets":[[118985,35405]]},"properties":{"cp":[115.650497,34.437054],"name":"商丘市","childNum":1}},{"id":"411500","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@@BB@@ADDEC"],["@@KLIFEA@CFOBIQGIJAH@DJPjTAc"],["@@@IDGB@HB@DED@DJ@FB@H@DCDBdHBBD@DADIFCNADKFKLAJ@FBLJTZNBFAHCHGBGAGQEAEBOR@J@BLBBFFJAHADE@CFK@EFAD@PCJKDSHQLRLLPJX@VBFDBDADE@IB@DBDVJHFGFANHFDDT@TAJETAPJZBJBDDFLFADKDCFCH@DBFJLPDJJPjVJBHHFRFFAFBBTANDFJDTCPDNIRDJHHBHC\\_FAHAjFJCHWLUJIPE@OEYPYDE@QLGBYPQFCH@PBJATBNDDFFAHARTfDJFLAJ@HD@VDLDDDBD@BEHE@SJKBG@GCIL]BALEHI@GEAI@A@@EDmDEFATBD@NGJ@H@TJ^TB@PC\\CJD@BATFN@NBD\\JVBDADADGBgFCHBHDD@@KAGQIAA@CBEFELAH@HBHDFNRBPHF@BCHMCCDCBKEE@GDCFB@AACBEDCJEBEFEAKN@HDJD@D@FRDD@AGGIGMBQDCB@DODQCE@EJKFARHL@DBDFFBPGPCL@LEDCDMDQ@UBMAIBCJAFEDAB@NEDCDOCGFKDCFAjBJAVOJIFADDHLFFJBHCPOD@D@FBVRNHF@VQHCFF@XBDFBH@XA^ETWLAHB\\THTDBXFNAMPBFFBXBDBDJNDLR@N@FBDDBZF@FEP@FBDDDXDLDJFDT[ZSNiXSHcFEFGLDJFHPFDJBJAHEDQJEFBNHV@DAFGF@VBFZLlANGF@dRXPLDPBNADAFEHMFC\\ATDDBDFBJERBFDDRJNDFABEF[FQBANA^NJ@DCDKZONARBJJBJCHMDADAFGLDNFHFFNHJ@RNBF@F@HCNKPABMAEBCTAP@JDHDDFBVGNBDD@JDFFDF@rATCFHFBNANILCTBBDHRJLBHCP@FLHF@H@LGHAL@lRJF~@vMJCZCjQTSFAD@VH^HHAHEBCAQBEZWJCPDXIHC@IEU@CFEL@TVXPLJDBHBZELIDKB@R@B@DGDAH@FFP@DCAEKGBCDAHBDJNHDHFBJAJFJCDCBCCCK@@CRKFCZLFDBDEFBBRABC@IFEHDBBBJD@FCBEEIIC@EHARCBAICIBIK@APOJCF@XFBDGL@BB@B@NE¶TFAAGB@D@DLNDHHH@FE@GBE@OCGCMDAFBFHFALCNDDE@EBADBDDD@DCBEAGACGA@CBCJCJEbOJ@FDHABCAIBCDAJBDA@AEGBCBAHB@CAEBCPIJSPeFKBKBCNCDAAKBALCJ@F@HELWDA\\AJAFACKIEGAKDCA@EBAFAPGDBj`LFZHD@DADKTOHKDAhZPXDBDA@CC]@EFCJ@FDJNF^LRDJANM\\DBjBFDDDADQP@HBJRLFARKLEbMLED@\\HJHJR@XBBDBDARQJMBGBKAGKQDAD@HF`b^TJND@VEJB@BCX@PBHBFJHLFTFDDpzHRFBJBbCJELKFAOCIFG@CAUUmYCA@C@QEKgSKMEIBCBANFZBPABMNEDKCK@UG@GCQOCCDCZ@JCBA@WA@AADGA@CBAABCAC@EJCJKAKBIFK@CHQFI@OAU@UBEAOBMLID[CKDQ@CMIAEBARCBADM@QHGLOAGCEGSC_@UNcHM@WDGLGFGP]GW@CDI@CGcGQ@MAEECCCLiVMBEGQCEYKAABAEKF@ACAADCAAFEAABC@AC@BCC@@AE@BCC@@CACHE@ABCB@@DFAACBACCBA@AHCCABCCBAIFCAED@BAD@@CA@BAEGGDEACGACDG@CCKIII]EEAQBGPMAIBEDEDIEUM]MWKE@ABMEIAEBCA_AMAC@IBAFCNAFGNKBO@GCGAMAICAKBICCEGEEIEEQCQDUEEFCLAHC@KGCIGGC@EHC@IKGCMOIDEFADBB@FICODOPE@OFQHIIO@MAKBAACKK@ACBGEABCJA@CAAK@UFEBKHGAGCE@EBIFCJC@MDE@EC]__EOEIMYSUIOCMMQGAIEGMCSAOMAGEGI@SFMBQIEEIOeQAACKEIIC@SCCMG@ABEHGR[@IEMEEEASCQKGE]IIGCQIGIS@EHIEIAKKYIOSMUIGIGEWGKO@GFIAGFQBGZg@CECCG@SAM@KQSCIMAMEMC_HA@GIIO[OMAKDMVQHGBGAICOOCAEASJ@DRXBH@FORQDOFEBQCGBGTGHCLBRHNDBBJ@HAVIP@FLRBF@FAPBDJNHTFJALBHJNABCBMCUAEBADCJADA@KAQBADBHADIBONCL@\\CDCBQF_A[CSEAEHUAMYKOIEGAG@GBCFAHAIM@E@CDELIBCOOICQC@CBCJACGACCBEACBAAG@ABE@AB[@CFACOFEACD@DA@MAGBOJ@LABK@AAEMQ]AAOEAEROBCACOEAMCICCGBGJGBEDEJAPADCBGBG@GAIIKEIGMGCEAIACEBSREBI@EEEA_ESIC@OBAPKBeECCOWCCECM@EPEHURODKASBMHAFDH@DQNAD@XJJ@DO@QDIHQEOHUIOECBABAJEDUEGAGBAF@HJRAJCBSES@G@GFU\\EDALEHEDK@@HCH]FICKDIMEAGAO@C@CQIMWACA@GAAYNADKlAVEVAH@JAVFDDL@DGRJJFL\\JHDBPANT@BADABOBCF@DFDEP@JDFFHEN@HDNHJBBCNCDKBIEA@CJKESHG@CEDMAIMADKCCKEIACBETGNERABO@EAAEIUBELI@ECCcIC@QJMBGCGIGCEBIHC@A@AQEAIBGBMJC@EGG@EDCLAFYJG@GGEAEAIBWF_LIHEB]A[BMGSFMEG@CDCJEHSRGJCNMHET[\\@FADMPGJALBJ@HC@AAKOCAI@GFQNOFOLYFSAECGI@IMCM@OHG@G@KKAC@M@EIMASACAAC@IBIEWUAIIGAEaFMACCAKACECG@MBG@EAEEC@ODYAKGaWCEEAE@MFGHEL@RGL@HADCDOFEDCFAHDTANINAF@FJPJLBF@REHk\\@D@BDH@B@DGDGAMAKCOQUgCCC@MAOGCAEAMJIGE@GDONIDGJ@FBTEFEDAJH\\CJDR@HCLADCBMBOFGHGBEFDdJRHHBF@DABG@QJIDS@WNMCGFGHEBCF@HDNBFNPFLDBH@FBJPJHDFBDCHCHKJ_JCDa^ENMDSJ@bKrBBJAREFQF@PHTVJNBHCpZfNLCVEF@LADABCAOGCBKLMLAHE^EHGFABCZBDTFDBARAFRH"]],"encodeOffsets":[[[118283,33248]],[[116499,33059]],[[116489,33052]]]},"properties":{"cp":[114.075031,32.123274],"name":"信阳市","childNum":3}},{"id":"411600","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@NAJCZ@P@D@DARS`QHAJBLFDADABEJMDCHAL@TFJ@jKPABEDMFMDEFCNC^@\\CLCJEXQD@PFH@FACOIMAIBEDGVUD[AIKMC_AEII@C@AHG@GDIBEEEIG@MFiJIXODC@E@EGIOQGOEEYEsDMACACGBCPQDE@C[YGIEIAEHI@EACKGCQAAGCCE@MFEPAREdEfFB@BD@HAN@BHNHJJDJ@`GDAHMFCP@NAZDHJJ@JFNNLJDD@DAHEJGDAFBFFDHGJElWH@NBLFLJDF@RA^@FJF\\FbBL@BA@EKUAEBGFAlADLDDFB\\DHLDDRHNBLE\\SVGRKPEjGVELAd@BBBFFbBBVDVNHBN@PCJDDBFBb@FBFDLTLLDHBLExGV~BNCLANDL@P@RELBLHN@PEHIBEBQFKFC@MKMDSOG]@KECBADGBMEKIAEFEFKAE[CI[EAAABINECECMQEC]DOAAKAEEBYIECECO@CBAA@BAAAAB@AJEHCAEACO@CACCAEJE@EACEEKDC@CWBEVBB@BIJ@PJPBJEFGHC\\CLJN@DHBBDCB@DEH@HG@CCAFYDEBMAASIA[OCCCBCNICCAGBSEQCMEI_LODOJC@ICAECCMAEQNM@GFMJGLELQLKDKHMBEKS@KHKDABEHEOAAI@GBEFKAWR]PUPO^mEaGCAQAEGEC@KHQ@MEM@KGIACAIGEBIJCJABMCQGUCCBCBIPC@G@IIC@M@oIKKEYCCGAACBIACIEHMEOKMCB@FABGDAE@B@@@FSLM@@HKHAC@@GIUOGICCBEB@@ABA@KFAAEA@AGEB@CA@@CJC@OCM@[AAUCKNIFCGDCAEIAEB@CFC@C@GEO@KBI@CNQJKBGACCEMMMU@EBCDCtBFCJmAOHCTBDABAKs@EDEBG@ACCK@IDKBICACCBC[FCHUBQACKIIK@GDSACCCGIMECE@E@AVE@A@EECOACCYCEEC@AGCOD@@CDA@CEM@GDIHMCQDA@CFACOAACAEFE@AOAEE@GF[FEICAI@SHG@A@GMCCEAY@GCOMEGAFGDGBGDCA_MMKEIAG@MAGAA[EaAc@OAaBQD_BMEGACBCPABE@OICAeHYP[DIDAB@FB`IBGFCHCBM@ED@B@FAJEBBBCBDA@HEDGCAD@BsH@EDACGCCC@CIaEEEIG@E@ADADI@EEUKQAG@YSCYAUCK@@QEWCCI@KBQJKBS@WEG@CBCNEHG@]AIDCD@b@BGDCJCRGD]ACNOBCNUJAF@LEDBLAFEDQB@F@LAHOBCBEJEDOBbvBXBBLLXNDPHLBRJLDV@LEVDJ@FAHMLAHBDSBM@SEMCGBCDADBLDF@FIBIAA@CECAE@ABADDDDJABKDCDADAPAFKNCBGBIAOEOAODCBOTEHEDYFEFARCBOBCD@DFJBF@DKLBVCFMRAJQHE@CEC@K@GDWME@C@JDZAFQLEBGAMKEACBCD@H@TEDMHCHCBMBkGUAEAEEQCU@EAIKGCCBCLCDEAMEE@ED@JAF_PKJePIBGG]KAXEHAF@FHPEP@FRTDH@NFXBTADABUDCDCR[p@DBFNDLFBB@XAHADSPCDAHAhENAb@DOTCFBNCJMEYGUAIKSDOCSQAGBG@AECI@KMG@GHEDIEIIAKDECEC@W@YDG@IAAFFbCFAN@HI@OCI@AP@JIVATDH@LDDPJDFDJ@JEH@NA@GBCDBLZ@lFJ@JCCH@ZCHEFCFD\\@DL@JFJ@HC@CDGFEDABDJ@FDFCB@DD@FB@DA@KNBFDNCDEB@HFB@LILIHAXANFF@DADQDAFCnGRGHALDLJ\\JFL@ZFNBDLHDD@FCF@HDFAJOB@HA@C@@BCHS@@B@RVBBD@DADFBAFDFILLRADG@IJCHCExFNNBBFGR@LFBDFCXDPADCD[DCBCJKfG^CHEDI@ADAROBDPFDDBJDFLJFJFR@P[BZFd@LIVINGFUJ\\`H^HHFBJBJ@VQv@HAXWHGXG^E^ALBLFR@HHHVBDFB\\BNFLJJTPNAHKFMFWDGDCBAHHHDJDXFNDBpMjCDAFEJQFGFC\\@D@FHHALM@ODENQXEZQVA`FNAFAXOLK\\CRFPOJGd@F@LGFCv@RCJEHEHQDCFAB@VJXHJFBDHZDDHFRH\\FzFDBFBLTFHDBLAJAnSxKDBDHF^"],"encodeOffsets":[[117660,35108]]},"properties":{"cp":[114.649653,33.620357],"name":"周口市","childNum":1}},{"id":"411700","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@^LHHJAfOLI`OBE@IFCF@NFFBDCDKDAHDJLFBV@RDFFFBVBlHNADADGNGFC@S@GDCDAFBNLHBFARKBECY@IDF@XNHCL@D@DFF@RGBINQDEAULK@CAEEI@CDCPADABQFEZEFCFGPSDAPCPBPFJBHADALMBEBOBCDCLCBACICCBCBAF@DBDFB@JBJA@ECEAKBCDCHANDTFN@TAACBGNKBG@ECIFU@KCUIKAQGKCOWMKKAAAWauPAFCFIDAPABG@K@ERAFCBEAKFC@KBEVIDMPADM^BHCDQDIHC@A@aDCJC^BH@FGDMDAH@XFT@LARIFAJ@F@DDFX@RL@VDZBNBFB@LRBFEJCFGBIBABGEIACACPW@QBGDABAFABCHAFGGAEACGC@AEA@QAoHAERUDI@AaOCC@MFIHIHAJCd@LUDCNCJGL]DEDAL@RLD@bBf@XApSLQ@ECCUGAEDCFAbANA\\CdBVOFAFAHBJFLDrCFEBCCK@EHELAFEBEAOBCHENETEH@VDHADADCFOBGCAU@AA@KNK@CGKCK@IJKDCTIDEHKAEI@QBOHIAECAKBEBCHEDABI@ECEKgEEAOBKHEBEAOEKAIHMAE@EGI@AJABCBCCWFAFDH@FDBDAFKJCDBDF@TKHG@WCK@CLBDB@HD@LAEKCAKC@ABOJ@@CKEGDCDBHADKACE@UDAFFDABA@MCEAETK@A@AICAEEDE@GEA@AA@AQDO@OKWOSUK@EF@DFV@JGDWJOCIDYXAFBRADGFGB]GUGC@EBSTiRYDIDuNy@yWK@GBKHEBGAKG@EDKAKIKGQACEAM@KDIHKBI@GGSDqBE@ECCE@IACEAI@OHG@GECGBYBMBEBAD@HBF@BALODM@G@EAEQMI@MGEEEGCMHKBEBCNCDGAIIIQAMBYPCLCDI@]MMBABERE\\AFEBMCQICCAEFQAICECASC[BEDGNEFCBMBOAKCWOcQE@MHkBYMAYHEBE@CGUAMFERIFCBGAICIOEEGCIHKFEdETGjWTMZUBEAE@ICESEWCCCAC@EFO@EYECAAC@E@MKQMCCICAWAEAAENOMBWECAGSQMMGKBC@SX]FWBG@EAAC@WEEGDURE@MGUQEAC@C@OPGDIAEEGKCCEBIJUPIBiAEBCDELDHCPCDMFA@CBEFIBADBJAN@VCRCNCDKFK@ODOHEACECAK@QGEBIL@FDFCRCPA@CDARHNHJBHC@QC@E@CICGCM@BLEFAFIFCDAFBD@BEACD@HFFALCDDDGNADE@OGQAEMGCGAG@KBEFAF@DBBRJBH@LC@GCGAEDAhCHCBCBUA[IAC@MEMBS@AIC[DODA@]SSIG@I@MHC@SAEBCFCn@FB@J@FB@HGJKFABK^DJ@HAHIL@TGFAFC@CACCCK@UGCI@KBIEeCQSGBEBCEMCSAIBOAG@EDORAZKH@RCFOZFZ@POFIJKVEVCDGBiEGBEB[`GDGAIGQCMJOCSDICCE@_ACIBIFELKLAJUJCDAHLVBBCDG@CBCHCFSFKGGB[RePIJMT]NMJK@GAKEMDIAGHQHINCBMKMFOAGDCBELC@CCIU@E@ADELEAMF]AE[AWIJKBCACEAGBC@ASEIOOKGCUIUMGOKOGMBOHE@W]@OGCOCMAGDWPMDE@SGABAVC@OCIDIFQTGBEJCDCBKBKHEBEAGEIK[aMUKMOFKBICIGGJWJKVE@C@KQCAIPCB_JIHSEKDE@EAOBCCK]ECSIMAaAEBABBHKJ@DBBBD@PAHGLDLHHBjCBQBCJEHADDLFFNDHHHNBNHJTJDBNCNGDILIJCHADGJQH@JLBDCLMVMFOBIAIB@DBBFDBJGNKFW@KBGHCF@PEDIBKEC@@JBJ@JBBNJBB@NCJmrAFNPDFAHDLADKHADPXBFABKFAHGHMDABCFBFDLFFFBFBT^RJCD@DJDNPIH@BFP@LBHHRGDKDIAWBOHYFEHEJQJAACOGCqFGDCNK@IFADLTJbN\\J^NR^NNVZVBNFH\\FDBJHHTPHR@ZKdXX@DBNLD@L@REvATEJAVHPNXFXDLHTRLDLFDJFV@HHTBLDFDF`NJB\\ARFRBFAPEFALBZCRDPAB@HFNHH@RQTARSNGDBNTBF@NDD\\IZ@NBHDDHFC\\[BAHBLFRTJTRX@FGDS@MACDK\\MTCPIjLnL|HRHVXTDF@bDL@FEH@DJHDJPNdHJFHPBFFJNpDD\\CH@F\\BDNBAHHzAHDFRFHLBRTZBVLPTJDL@jAbBXAFA@CNEHELETAB@TRJ@PFB@@HBBX@DBBBDJLFDFBLH@BH@JBBD@PCDBBDDVFBTAFBFBJLHBH@HADAHIDCdG\\ODAJBBCBIB@PDABVHFG@CCCMAMCBE@CAC@ADCBAR@BBPHNBAGFG@CACE@BGAA@EBABCT@HANEEIBCRIZFHAFCDE@GAAOEAC@Cj_BCDJAHF^BB^J\\ELBbPHBX@HBdV"],"encodeOffsets":[[117028,34276]]},"properties":{"cp":[114.024736,32.980169],"name":"驻马店市","childNum":1}},{"id":"419001","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@DFJFJLJDD@BAAQDOD@HXDBF@HABCF[JADCRGDET@BE@GXQFAR@BEIIAON]F@FTJTLFHBL@RIFAJADBH@AC@INKDGBIESC_DC@CA[FECSBIDS@EAEEESK@WGKCMCKCEOIAaOQIEUEYKUMEGM_CEKGGCWDEECIIEiAUDECIIKAGAWBI@U[IQECGCEKEAOAUMC@EBQPCBKEIFA@GKCQCAAE@AJBRCB@JRHBL@DAHQJCBCEG@CBCBCA@MJC@CADEPIAKFACC]AIFQFQEC@EDEJGDeR[JiFU@UEi@CBGJ_LSBKH[JKD[AUDQFOJWTC@MCKIQWICKBIF_Z]RgHIHSfQVGJUN{NWJKFIBECMDMBMCgAC@OFC@GEC@KFADABHP@HNBHEHBRXBHAPBP@FMVAHBJV@DI@CFBDJJ@LELUdUZAH@HDFLHVDRPVJFD@FCHBVAHQhEFYL@DFFBHPCRAXFNAVGVC@CIA@ADCBADADABBLDVHnI`CdOTC\\@FAHMACEE@CDALAdENFXFlBFDRRDBJ@FCCKUgCECEBEB@J@ZHH@TCTDJCL@dDRARH^^JFL@VEXAWDBJHH@HALELEJJDBJENCVMD@HDRDTBF@RKTIRABNBBJDR@hD`EfLDDGVWDIDADAN"],"encodeOffsets":[[115320,36098]]},"properties":{"cp":[112.590047,35.090378],"name":"济源市","childNum":1}}],"UTF8Encoding":true});
}));