(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('四川', {"type":"FeatureCollection","features":[{"id":"510100","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@A@B@"],["@@@CGDH@"],["@@HBHBFDFH@FFDPBjT`@DBPLPJN@LATKNEZMNEBAFAJFLNHXDFJBJHNJR`LFHDH@JCTDJATMHAHALBPCJBNDNAHDFDF@LQBAHCLCLBH@JIFIDMPEF@`RRNPAHPHNTXPBLFTJJF`@VD`^D@LANJHBPPDLDLAjDNRV\\Rp\\FLDBRBD@BF@@EFAPDPFHBJ@NETAVEHQHAFJRHLHFFLBHAXHJHHBDEL@JHFDPFBPVFNDPJNFDDDBDAFJNF^HBLHPRBDAdKPHdBZOXIHBZR\\BFING\\@HBJETBPDDDBNA^DJFHLB@HAHGR@LCBBFFFDTFJ@NERFLFHLJJFJTNLLHNHBT@NFP@HDLDFHDN@JLJHD`JJFVJF@HEN@BAD@FDBFF@NEDSVSDANFNCRBPHLHD@JIFCNBNLJADE@CCMFIBGHGJO@KBAHEPO@EAGPIBGCKACEAIAKEKIWWCK@S@KBEFELELSJCDI\\KHIBEACIEACBIPSAEIK@EBCJML@LIK@@A@AH@D@@AFBBACC@ECA@EBCDAJBDCBBD@DF@BDBFGFFD@FCAEHB@CFAF@BEHEAEDADBFEJIBEDGJ@BBB@DG@CHIBCAAGABECODCD@@EHALGCEAEBADEAABCAA@ABBBAACDEECAIGCBAHAFBJCACIAGE@CLBFC@AC@@CF@CCF@BCFERE@AAAAADA@GNENABGBBBA@MACB@@CXCNI@IACLGBCFAAADCCC@AJABEFAVCABB@BADBC@@DD@BA@ABAA@BAL@J@@EGACC@GDED@BBD@PGZEDG@AJACEF@BFD@DEHCDENKBKEAACHKBMCEAGGGFI@EKAAKACA@G@AC@WCAMAAA@EHAFQPAFJH@HBDCDEDCF@FDNGPFPBBAFC@CAEBAJBDKFCB@DFDBLIDCB@FF\\APHFHFBDCBGDAD@JFXAND\\GLAJGPCHFJLLBBA@CB@LFBHFADCBADNJFCHDHNVBHJHDADAFEHAFMFADBDLDFBLBDH@HID@\\JNDPEFDFALAFBBHFADFD@BDPBDELAFCHAHB@CLGHADEHDPEJDPQXKBCG[@QAEGCGG@GBCL@^ENGlKLGTETDB@FGNIBKFCN@RHH@DEHMJG\\CZGTADCBCHCF@FATBHCBA@CEEAEBIPQBELeAEGD@A@IFCJBHFDFHDHABCFYFKBCJGBA@CEKAEJEDCCIDEDALBF@DCB@FBD@BAAE@GBAHDHBNALBJABC@CIIAGBOAKBCBAF@TABADIJGBCBKJOBEFUAMFCF@FLP@JD@ELK@IAIIKIEAIGI@EAAE@AA@EGCGIBCCCBA@EAACBAABAAABAAADAAEDCCCHADDFADB@BHFJCDDDA@NJEDBDIBDDBBDHB@CBA@ABCFCDEB@BODEFCBCHCBCAIBCFAFHFBHBFIBSEGAGOWBKGACAAIUB[KKHQFOAOAO@IECCBKBI@CA@E@CCCBAAC@EACBAAEBCACDIGA@CCUAED@BNJABKBBBDD@BK@BFEDBFQHWFMDBXCDALELEBUFOHWHKFEFAJDXBJNHBBLRBFADG@IFQD@BCDC@@DC@CC@B@BABBBC@A@A@EEAD@B@BC@ABA@C@@EEBACEA@BABBFE@EBEB@DGAADA@EFCCADCCC@@CCAC@@DBDEBABIBAABCAAGB@DCAA@@@BDCBEBKPGFC@OEC@KRAH@BC@MGACAMAEAAEBYJCAAFEE@AFCCCEACDCC@AEBAD@@D@@BI@CB@GBAFAAAIBACCBFE@ACADEICE@E@GKOI@GAAE@KFAA@GACEBMCGDGB]KQ@A@GHUEMJYDGAEAIGAKCGAGBOJOIQAcEC@EDGFEHCHBFCBE@CCGCA_OACDK@EAGGECAaHM@AAEICAOBGCOAAB@FHFBDERKXIJIDCCAIBAN@BC@AEIHKCCGAYASPGBCHIBAAAIEE]QUCGACCEEAEBCJG@CUGEEACBAHEFBNDPCBAACSaSUAADG@CGAM@GAKKAEBMAKCAMCACBOAQOOEISSAGDK@GMSGAEIGGEC@CBEIYKM@ICICEKIEMGGAGAaCCMKKEGAECEEMAGBEFAJIDODEDGNABCBMCCDBHEDA@GCGBEHENC@GGGBCD@FCDC@]KC@@BCLCBKGEBC@QIO@EBINKJCLMHCHAJDP@FMHENEFSFUTAHMXBHLJ@BI@WFICICCE@CHIBIACICB@CCAKAAODG@UEEB@FCFAHGLEF@PCACICAYCMECA_D_AQ@OFC@SIcSGIDM@CAAC@EDC@MACCASEBICEFCBM@EC@GTW@GAEE@IDE@GGIAGKIMCAI@GBABB@FBEBGACG@@OFA@AA@KJE@IJCACB@CA@CBCDCQIMCmEGAEKAI@AJIAIFK@KACE@QJIDINCDA@EOOWECIACDDFDF@BYDKCI@IIC@GBSGGCCIEA_ISEDKNSB@BCCEQU[KIECOACAAGDEAMMYcCAAPCHCDGFABDLALKCC@GHM@IC@CFKDCNELIDK@CCICEGEEAG@IBCDAFIPAFFHAD@DHBDDCDGFAAMCBGFACE@IACECE@A@GNE@EEICW[ECG@EBGFCNOHADADIJBHKREDE@CD@FPHFN@DEJFPCFQFCD@FBDFFDF@DGJ@HJFHJALHHBH@JCTKBEFOBMHGCKD[IGBADDTCNGNCDWFM@OAOBu[UMGQESEGBGAEEGMEGBEDCHBNCJCNEFCFEDC@IGABUVCBGCGOOQUcEEMEW@GACDEFIDP@DDJ@FAHKNBNA\\MBCDAFAFDNLdMP@HDHDDLDNVD@DCFBLFVVv|@HCHEDKDADDJFTADEJBREFJJDNGP@BDLDBD@LGJAH@DH@BADQHIHADBDJFPRFJJFRFDCBEH@@D@BFHBHFDBHLNDNJJFF@DGPCB@DBDUAKBKDAFNbDTCLEFMLEHAP@DEBUEMHCHCH@FBD@VBFJNDJCXBVAJCFKLCNIHS@KDIFEHGV[TAFDREFCBI@yYIAE@AB@FDZ@BGLSTOHMNOZELAJ@JAH"]],"encodeOffsets":[[[106606,31777]],[[105927,30843]],[[105465,31518]]]},"properties":{"cp":[104.065735,30.659462],"name":"成都市","childNum":3}},{"id":"510300","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@@A@B@@"],["@@@CADB@"],["@@A@B@"],["@@PIDOAAFIA@G@G@@EFCRH\\MH@LDHABCAGFMFAPADAFIJELcNGFB@FBBPJNBHFHJNDFDFJEF@HEFBPDDHJDFJHTARMD@NHB@BC@EB@H@FCFIBGJBHCDDDA@DHBNHXDHAFGPCHCJOAKBGIIAMDIMC@ALMBGBCHAN@JIJGP[NIFEBECEFI@GBQ@IFGEKBCL@BCAIBGGKAMBCJAHEBEAAE@IHEDC@QHQBG@@CHYDCJCFCJWBML@HDTD@FQH@BFJ@JHDD@DACGBEPEBDBFNDFFBCBFBCDC@CJE@AAADA@CBAFBDCDEFDFABFE@@BDBADD@BAF@DABDD@BDBCJCBDEFB@@FDBADD@@DDBBBFABDBCDA@ABCACDCACHBBCD@BCDD@GHBB@CCBEEAACDCB@B@DFFA@INC@ACEBAD@FDBABAACBCBB@BFCDDBAACHEBBCF@DDDBA@GBGBAH@BACA@CAADCBCG@AEDAHBHA@CE@ACBCD@@ED@DBBACEDBJJCDFBCDDBBABGFBCGF@DA@EBAD@AFDFBAFGJDBKA@CDA@ACFGCAEB@ADCHB@CFEFFH@DCNFNCLEHDDDEL@JCFEJDBR@JQFCFB@LFHADGBHJ@FAFHHDLCBGACABEACGAEB@DFDFJCFC@CAAGCAIH@B@BHAF@@JDFADEECBDHADGJBBFDBDABCAGEEB@DDBLFBNBDBDADDDH@DHFBLI@MH@JFDCDBHLDBDBBBDAJEDBHJRCBAAGJGBINDFABE@MRIBBBDANJDBDDPDFAH@FHLDBHAJDJAHJLABACS@CLGLBBCAEBCbCDCAIFEHCLAFAPDHBDNDDF@FCRQHUJKJCHFDLDFN@PNLFHBPCFGFFLFTBDADBBDCHIPBLFBRANFDBADEFDDBFGABCAAMFDJPABB@HF@JIBE@EEEBCLBHINCFG@CCGEQ@AFCDKFA@JDBHIAEBELCDC@CEGAOACCAE@IFEJC@ECM@IEG@EGACC_GGA@JCFENBBGAGBCEAXEHAACBENIDGACKMDGBAHALDNCBAGIBEBANAPOTC@EIC@EJAN@FCBE@EEIGE@KJCR@LCBCAAEEEADEJEBC@CGEBEDAFADF@HDBJAVIJHDINIPCL@FIDATALIDGAEQUCQBCBADBFF@FFBJGHIDCPELADDDFABI@AFDBD@FDH@HCJULID@FDHAFEAGH@BEB@CKAAO@AEBGZGBEEA@ABCD@B@BC@EuoAABGJUEIMKQ[a[KUYIEKCCCAAEDU@CIIDUBARAHMRAFCDBFNHBFADEDBDFFFHAHCNAHA@AAAGE@CDCJ@L@HADFD@@ABIGMBCHA@ACODGCKACIEKGG@CEQKCE@C@CDGFCDAPAJILABABEGMSIEFMRCAEGEAQBABAFDJIHBJIHG@ECE@GEBWCCECDE@CECOAGEE@GNG@MCEBBNIRCDCBMBGEDCIAGGA@@DGAG@CA@FC@CA@DABCAQEBCIAAGCBGFEBUEWHC@GGMLMHGHQFCDAHFL@DECCAU@ABAHABWFCBMVELIBGHGBEA@GE@ALBDFF@BK@YJADANEBG@KBKAGDGLAL@JCLFL@LALMDMACEEBAIACM@E@EFGECGIDGEMHAF@FGC@AAEDUAMCKAECA_EACBQGKM@EBEEEAMBEFA@ACCAQBAABECCAEGACCGHIDGFUHCCCAI@IAEB@CAAE@CBKAECCBEAEAIGGBEDeHCB@HBDDBDDADIHCNBL@BGF@HIT@HDFFBDB@DAFDFDDF@DBDBDFLHDDHBBB@HANA@YCEBEHCJAH@JCHCBG@QKC@IFCJDHJBFJC@EDBFFHEDCHEFEJATGFADDDH@DBBJHNAPKDEDBBDB@BDDCB@DCBB@DFDFB@@BDBEDFBADA@M@WKGAK@YDIJKF[BEAGE@CBCAACAQ@KKC@AACABCCCBAACCBAED@AAFGCBEAC@AAA@BADA@CE@AAGBAEC@BGCAG@ACG@@@@CGCGAEBEG@AFACC@AEBGGE@ACFCCAMDYXMFC@ICG@IDCFELQTEPYRMXEDAPGPGASIYJFZJJ@DGDGBICAABEACYBCLEFEAGE]@KEG@CBCDEAABED@FABI@GIGBCBSA@AHI@GUKGJFFBHABBBADCFG@EIGAKBIDEAE@KD@BC@GCEAED@FLDDDCDQLE@EAIBOACBEJSBEAAEDECMDGFKRMFG@GAKGIIGICKAQEGAIDGFOROLEDKDKTCDCAEG@@J@H_AACAKCMKCUAGQAQGIBGDCJ@PEFF^DFCVAZCHCFEBG@CAECMSCACGEGECEBCFAFHXBPDFLBFDFDFJDDFBPHDFBFADURBJFJ@DEBG@OCUFC@GEC@CFAHABGBKCCBKHGBA@EF@L@BLLBFAFEJBBH@FCHEVCHEF@JBJFB@BA@EB@LJBBBADEFCBB@LBRHDD@BIFGDAAEBEHAJDHCBJGFCLMF@DDDNCLJADGBCDDFHF@D@FCDMACAEGEAIB@HEH@FJ@BB@DKFEFADDLADACIEGACEGEUCOOC@CFIFCHFP@LCFBPHDNGD@BBBNKP@F@BEFCAIDE@]QIIGAKDCDAL@VAD@HAFBDEDFJCDNNHDLCFBH@FCBIB@BDDAAABCL@HF@JBDBBHADFHF@DPNJ@FDFPDDFABC@CD@BAACG@@EF@DDF@FEBGPIBOBDJ@DDDFFF@JDF@DG@@BHDBBDB@D@@@BBBCBACGFAHFFABIAIGE@@DBFJHBFINCBYEAB@JBBBBNDB@FCFHCDDHTHLP@RABEBADBLEHWJCLKNAFBBDCD@@@BFBDJELHR@DBBLDHLHFJEPDF@HHDFAHKHBPEBMBAHAFCLCB@BFDBRAJ@HDN@@BAFPBBDGD@NABKCCH@DPAF@@CDATDJEF@"]],"encodeOffsets":[[[106667,30205]],[[106650,30180]],[[106633,30106]],[[106772,30344]]]},"properties":{"cp":[104.773447,29.352765],"name":"自贡市","childNum":4}},{"id":"510400","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@EM@EDEHGLQBODC@CCCIB]LCBACBMECGFG@uFBDFAFE"],["@@LBFFBP@TJhABQBCBELCJHHNBJDJjCJEPADBDJLFJBFAT@JHLNLBABCDK@KHGPIBE@GIEASKGDCREDCCEIGB[HKTMBIBKFGPOLYAECACCM@CCP]BSFSF@FBLFJDFFJFRPH@ZIJEJQDQJ@LFF@RIVgDAD@HDPLBDDRVNFHJNDJLPFLDXFJZHNLRHPZTFF@NCJPTDHAJGBE@]LUDOHMJEZBPCBCLWFEFAPAFALKL@DBLOBEACOOAEBgACCE[QECCC@IFKLcDED[OaAIKGBEJC@CMQACBARKHGDEBMACIK@GDCACEAECMBCAGIAGHQJYAKACCOBQAOKIFCFCBC@EAAE@EFGDABBvI@E@AEAIDEXOFABC@CCECACAM@CGAIBAJGHCBGLAFA@CCEDGECAELIMQKICGKACQLQAGCEMKMEIAAEBKACEEEA_ECACC@CHYBWAEEGcGABBF@B]BGHEJGDEBCFGAI@KBAB@DHHBTIHI@@FKTGDBFFLBZFDBDALCHGHAHKHGBEECMISBIA@EAEBOFOAIBE@ACDOAEEKGACDIDOBKJCLJNBLAP@D@BEBOA@AG]EKGGKAGCM@[MGBIDI@EBAL@Z_EYFWDUAEHOJKJKNCJ@REJCBGBIEGFAFAL@XGPqjaTUJPCBADG\\CFMPOTInALHn@LAFAFGDCDBJpZnZzlBBCV@FDHDFRNH\\Z\\FHJlDTCLDLnzFDRDhD"],["@@BFHDDFLR@LCJGLCN@D\\bRF@JCL@ROJAV@RD@B@RJXDPDFAJDHLNRBHDNVPHHPTVDLPJALDF`NPCNAH@LJXABCAK@KTEDABEAEAEBCB@PHHCFOAIFOBKEOEWIO@ICEQQLSBMBGAGGKAC@ALEDCTsHGJMNSFKBINKHEHK\\MD@NFRCHBNILAFBNLHDH@PCxYNG\\YMOCG@CDKCSIkEGY[G[QMCECG@EDUAAykmYoYAIDCHCBEBQGmBKJmBC`eH[BCDAOVIbSriHO@WBKBEHEJFHADAFI@QDILMLIPIFGVBXCZE`F@aBCFAE]AQFDKFGNCL@HFDFJ¾FNH@HDLBHHFLFZBFPBFA@A@W@GIMDKLIPAJCEMCCBGDCCGDCAWCCBCCEEAFEFABA@GACE@OUDCDA\\@@SLEDIDeDAd@FKHMBYA_G]BIBGJGDE@I@QBCPGBCBIEIGIGEAOEIIECQ@GEKAI@GDSAEGKCCEACFWHOBGBANCFGJKRCFCBE@KCMBCAOGKAGE[{PGDIGYCqGKCKBMHEBCDsESKQCIAM@KCIBMAMEGGQCGIEKM@CBOCGAQDEPQBCAYEE[EiOmAA@IJMBG@EESOSCIDGLKDE@CESDOO@ODIFQRIJMPEL@LBlDJPTBD@BMAgRQB@DHLBHABC@CAEGEAETgtOTGBKAKHa@ABCDGXCDEBE@eSG@[FGA]QEACBY^AD@PAFCDQJK@E@CDHXADCDSF@D@DNJCHFDHR`RFBJ@|ORBDB@D@DaLGD@B@JBBTDLRHVCFMJaFGDAB@NNlBFAFGD]@@BFNAH_RIHWJCDOXONIPCBKAC@MJAFKJQ@G@CBADCJMRKHALELASBOGYZKHALBFFJDFIREBUME@EDAF@DABCAC@HRADADGCUQEFADJBDDDPKACDEFA@@FHFDF@LId@JDLBBBBF@hGH@B@HBHDD@H@LEJ@TLDDDRAFBFBJIN@LTTBD@PFDHRDDCFMHENIAG@MJAJDPFFJBFFF@BBFRBBdNTL@DON@HLTDBNEF@FL@LAHKDKCE@SJOLGDG@MHI@SIEECIDIJIDOJQAaAAQDMFKLC@KCIGCC@E@GCEEAKD]EE@EDABDFBTEJBPAFCBMGC@ADAJGFINCBEAE@CDABDFPHZVBRQJBDNHRVBLRXDH@DEHKHELGLUNKTAJADSDIDE@OCIFSACBINIHCHG@GGIAICG@EBMHYDGHANADMRFXDJLR@DCHWCc@C@GHCFAJFbEHSLEFKCI@KFSL[NWDQF_RADBZJJHTCLDF@DCJ@HDFLFJT@TIDML@DHPDPJFBDAD@DADLT@HCBBFABJHJVN@LFNHJLJJJ@NKNFBFD@LIRAXDPNFFDBRBHARPH@JKJCHBJFJ@LFFBJGFORKR@PBJFBBBATWRKVQBIDGLGLLRJHJDDBHAP"]],"encodeOffsets":[[[104658,27497]],[[104310,27780]],[[103849,27827]]]},"properties":{"cp":[101.716007,26.580446],"name":"攀枝花市","childNum":3}},{"id":"510500","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@DBB@BCC@@CLIPGFBHHJFF@BD@BADIFAB@DDBP@FD@D@DKF@HHBFADEBADFD@BDBADBJ@FB@CBCJJJFLDL@NCB@DFDPF@RMBEAK@CD@J@BCACKACA@CBC@GDA@AEEICA@ACDAN@NGDCAC\\C`NJBHCBCIM@GFGLEJBLJVFLBPCFDABDHTGH@RIH@ZJFANBDADAAOAM@ED@FBBDL\\RLFFHAFALI@EISDENITCRBHJBHADKLAD@FDFHCFATB@PHLHFLJJDHBVGDEACaCIACGAIDURgLUE]FED@DAIWEIDK@YEG@EDEFAF@L@FCJSHKAABCAIDABACK@KDCDAH@LLDBFAFADE@GcMEIEW@GBEVUBEBGDKLEJADE@EA@ACAA@AGODCECACGCDEE@CGD@BAF@ACBACABAH@@CACF@@CDC@CPIACD@FG@MEEDEEO@AHAJKJAFGTCJQHGHMDALAIQC@KDECAGFIDEFAFBPJHBRANFTMHKRGHBfLJAJCFG@KCMFILALCJIHCHBDF@HKPAFBDNDDDBJHHVBFHLBNNRNFPDDLFF@DCDGDAJHJBBFAFKDI@CDDFHDFBF@HCLAJENSRUHCHALHJDNAFCDK@EMECKFCFADEDA@AACA@A@AFCBEAAA@AF@BA@CCCAGDKNIH@LHBHHHPBDAFGTGD@@HB@BGCK@ALELCN@PDNFLAPDNEJ@HBFJFBN@LHHFBH@BbQDEDADBFADEDBF@BAFOLIVCBAAEBETUBIJBFCNADC@GFKPMCGAICIKGKACCBGPIGCIDCE@EFGBQDGDSRALIAGBIFCBG@WD[DAF@FELCBC@EPKDE@IJGFI@CAE@KDEBIAO@IFEPGJGEEQCKSDEBGHELET@FC@EGG@EASLUFENEBC@EAEJEBIAUKML@@G[QLGBIAKHKB@BBNNDAHCPUF@BCBAFFD@BAAGDCCIBGFCFCGE@ADE@AGBCGJI@IDI@CCAICMFQCGDCCCGC@EHEFK@IBAFGD@HCHMBWRAJED@JEHALGDAJ@JI@CBO@AABGCAKHODABAHCAGEGJAFIJABCAEBCDAJIDEFIDAD@FIBE@ACIBEGA@EJIBGHINEF@DBPAHY\\ENDNCFGJCAEBCBCFA@CECAEFAHEDECACIAEBGAEFGDEAEBACNI@E@CWAGFGBERCTYFEDBDHDFLCDCB@FCDBDABBBCFGFODKHACDGAAOBABAFSFE@IGKFCFJVIBK@EDABDFL@GF@BHDGDMB@HIDCJCD@FGFA@EFEAS@CFOBOZEDCC@ECYCGFGECGIGGBEAGDC@CK@ICGCCIE@GE@KHMBECIEEGCMDeSI@OFCCFMAIBORCII@MECBWGCFAFIH@LG@EAEIAEBG@GIGKE@GDAHADSCMEEHGFEBMAGCGGIDS@GDIEG@IDAHC@CEA@EHGBCDGBEGEOQIYG@@@L@LOPAJGDMEAA@GKECCQ[ECGCMDMHG@EGAM@SBG@CAAQMAGAKBIFQC@GBKBGACGBGGGC@AACB@AC@A@E@CACBACA@CAEAACADCACBEAAFGAC@GCFGDKEG@SCICC@ECAEBCAIU@CH@LOACGACEE[FIPELAJEJFFALI@EFIAEDKAIGKAGNQFaPOKCAUCQO]IIAC@GDMBCD@DBDLFFPONBLCDIVSLUHCVENDNI^IDBJHCJBJEHHH@FEDDHFDlJDCHBh@GFMDABAFGD@PDHPJJ@FCBEHE@KDA@EDA@CBCACH@@ENCFBZADCPkLQN]HKLGNCDFF@FFH@@EBMD@ZM@CEKAKIYUSKoGMAGBEFC@ACAACFMJITO@CCI@GBGDAJ@PEFAJHHLHDJFP@HFHFBACGBAFALAFDABDFCHLBHA\\GNIDCJoHCLD@PDDDBJEJ@ZHB@NI@IDCXADBBFITADEDALBBH@DBHLL@RFRDLHJH^RDDH@BBhBTHHAVGT@VIJGD@NGLAJKTKHAFARADGAKFKHAVCBA@SDIFCZEJEDCFM@GFELEHMAIAWCECAIDGQIGGMCMHQDCLEJAVGL@PHRCFCDG@EDENMXOCIDMHEHCHIAIGKMIEEIAA@D_AGBECEMCACFODCVBRABAFMJE@CCEICACJEFBJCDQAGIO[YGG@CFITKH@LFH@BCCMQIWKIBABIA]MSQWMMKECQGMKMEGBOAEAEI]FGAGIQGEDKDKHEBGAMBABcRSDSHMBOCMDC@cEIB@ACAIDUAGGACDIFACCOIaG]OE@IAWBMFU@cQGAGC]KYEACCBEHEXCFA@IAK@K@EGUKKBEDC@ICMG@KMICCBGSMEECAE@OBGFcDABKBEBE@E@GFSDCAIBMEC@ADC@MCQEYC@AMAOGCG@ICIBIBCIGaGC@ADEBCCM@MJMDMAIEIGCKCAEGCGEECAG@ODKL@HCLBJCJGFOHAHGHALBBBPEDSDEDIAGBEBQCQ@CBAFIBEDAFCDAHA@BJMNALSFIDINGBGDS@IFED_DSCEGKAEBCFIFMBCAACAEACG@EKA@AB@FGDE@GCMAM@EEEBGC@ADECI@AAAI@AB@FADABC@ICI@EECEAAAB@BA@GACCKBC@GIGQEIOGMBGI@EEEACIEGKC@EFMAEFIDBhGVDHHJ@DEJCJBDHF@DEFOHGFELCTJDFCJBDHAH@FHD^FDCJBDDBHCFOBEA[GEDG@OAGBIFEFEHSCIEA@@HEDADRXBFINBNAJKHDPEH@LKJ@FFNZZHDF@PEJFHRHFHDJL@NERBXEPMLEFAH@JFTYHOBCBCDBHABIAIKIBAAMKCGGCG@GBsHCBILMRIT@FFHLLFJJD@BAHFJBHCFKJCJVHbFNNHDDFFNPDCJCBFDHBBHHAJJF@BFAJBBRBDBJNDDRBLF`@XFl@FDFLDBF@FCFADEDAD@FFHNBBDH@HENQ\\AJ@FHpCJEHGD@FJRADCDI@ABCLA\\LpCFEBCDANDJ@LDJBJAHKNWLMN@FHP@DADKDALCFSJOFHB`@BDAFFDFED@@NDBDFF@BBENML@BBFFFLDBHFFABGAABBPAFADA@AGE@CDGDIBAB@NEBGAACA@ABFVABADiAQF[Ci@@FABAA@A@CSBcIU@CF@JBFB@FBDAHGDFJBDNFHHDBDFBR`LJERBFDFH`ILCNIJABIAGCE@CD@LCBEGCAALJHBB@DEBI@AJFLHDBF@BEDMBEDAB@JORABCEAAKDAB@DJD@BCHKJAD@JDZKfAJBFPL\\RBDAHL@LBJJFH@RDLENIL@DJFLEHBBHAZBFCNGFQF@FBDFAFDT\\T@JHHHBFQDCD@BDHIJADBBFFGN@LIF@FKL@F@BNFBFEDM@ABB\\DFABIBABAFBFDFHB@FEHEBE@EB@BBJ@BFD@F@DGF@FBPGAMBMFSRAH@H@DKDCBCLUDCDAHCDIJDDHBCDHFRCDCJQAMFANDH@HMF@HFPBFD@DCFFDDDAXHFF@FDH@JGAIJGCIBEBARAFBFHDBNQFETJHNAFABKBIJOBCBEDCH@D@DDFRLDFH@LHJFBDDLCHDP@BGBADHNAJ@BC@CEGBK@I@CD@DHFBB@BGBMBGDGBEECECACFEBGAEMCAEDQBGNQBABCVHHBFCZJHFLZJLVb\\R\\NLFJIVAHBBvp@FADA@C@AD@BFBAFYHAH@DBBP@BBDLBBJ@RAHDDNA`BJPPFHFHTjLPlfBBLAJDNDNN"],["@@A@BB@A"],["@@CB@@@BB@BC"],["@@@B@A"],["@@ABFDCE"],["@@@@@@AC@DFBCA"],["@@@AC@@DDA"],["@@AABBBGMEHN@BDA"]],"encodeOffsets":[[[107893,29995]],[[107894,29997]],[[107918,29991]],[[107898,29990]],[[107916,29988]],[[107914,29987]],[[107757,29134]],[[107752,28774]]]},"properties":{"cp":[105.443348,28.889138],"name":"泸州市","childNum":8}},{"id":"510600","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@BCAB@B"],["@@BACBB@"],["@@DEAACFBB"],["@@AAAACDDBDA"],["@@AC@FBA"],["@@JCPUHO@IFEPCTGDBJDJBHCFEFGDGR[JETAVIV]LAAECGDKHGTQNIPJF@FCHOVELBHD@LDBNGP@VGLAFAHGFLCFJHBAAC@AFCD@LFHBFBNEDDDADB@BBBJ@PFH@BBDHJ@DB@DADMHEDAFBFBBH@BFD@D@HBHGB@LHBF@JBHNHG@DDABC@@BABD@LGD@BBIHBD@DB@@GHEBBCF@DDDFAB@DLPEHEJMHGZGFCFGDMHAV@HGDECIBQHMDKKU@CDIHELCTCNIJEhIZIJ@DCDIBIEMBEJGHIHEDGBCGGAEHIDIDIAIBAB@bBFL^GLJHEFADBFNBDDBPALEDCFGAOMSEK@MDQACMACAAKWCEACEJ]HKBCGCCEDSAM@UFCJCB@BJDDJBHEDBDFJOLEDUACD@@AFCECDKFATDH@NELABADG@MAGGIWUAABE@ARQNEJKNEJMXALSDKBKAOEOBGJIPIBASUEKFUPCLAHENOFQAI[YBGFARLDDDADCDAHDFAD@@KFADC@C@CDDABJHLCDG@@DDDCDDBADBBDCFFFHCDEBBCFDBF@PANBHBH@BERaJSBGEO@MB@LA^ABACUBMM]BKDOFCBBLT@FNFNPJ@BC@[AGGQHcDOLWFGNE@C@ED@DBD@DGJC@CAEJELDH@@CAE@ANLBAAIDAHDB@@CAGBARDFCBFFABC@AGGAABAD@LJDDD@BIHEAAAC@ANGD@BHD@NBDEHDDEGE@CDAJFDDD@DCD@AFBDBBFADC@EBGHBDADA@EJ@FELD@CCG@AB@DBFDBEBEHID@FDD@@CCGHAAG@IJA@EAGC@CDCC@CDAR@FAHCAEFCAAECAEGA@GBCCAAQACEC[EGC@CDABCACEGACDCLEHKBGK@ACAAAEEDCA@ME@MGDGACEAIHCBCA@AFKGGBIACAAEBCA@KGDCEGCK@@AFEIMLI@CIKIAAGGADG@AICACDKEKEAA@EHABA@@CCE@CAA@EMIK@GBKZSFA@CEA@G@ADA@ICACJKAKAEEAMFCA@GMCUFS@CBQ`GTOX@DFHCNBDBDHH@BOTAJAD@FABMEA@ABFF@HABCAGEOAAA@GBEACA@KDABDTABCCCBDBFJEDDBABGDEHIECBCDCACACKGCACKBIAAAAGDKCACAELAXCPADE@CEDOACEAGBC@BE@AGGAAMDAA@MHOBQAEEAAB@BAB@DC@CAACCAACCJCAIF@MCBCCIDGE@ACAEBCCGBDDCDBFCBBBABBBABBBDABB@FABDDADBDB@DFHD@FBBF@BB@FHJBJJFJLBJ@FAFIJ@FICO@EKE@EDBNEVAFIPALADIHCJABSBE@ABADBLATLN@DADIBKAMBGAGCAB@HBFABC@EAA@CDE@KACBCFDJCDIFBFFL@DABIHADELEZADGBGCCEGEIAED@J@BHCBFKfAFORAJBFFF@DABGDSAEBE@GDADCDSBYH[DIHGNCFG@QGM@EDALMJEHA@SCSFKHkLMH]FK@AD@HHHHDBF@RH\\ADWLORICOFGCCFGBKH@DGAGBEDKBCFOAACC@CEEBAGEAKBEBECOFMC[IC@GJG@ACAKCECKCAEBENGBEFCBCBIGAGMUCGDGIECMABCDEBAGKEA@@DABKAIKGEODIHKB[HMCWBIEC@CBAHCDEAEGOG[BEEA@CDKJCACEA@EDCLIAABBF@DEDABOAOEMHECE@CDCFCDGAG@EIOBERGB@FBBNBDB@XBDH@B@BDBLLB@FEJHHBHDFANGLBDFBALMLCFGDCFC@AEE@DFIB@BCHYFOHC@AAC@CF@HDDHB@FI@K@ABB@AB@BABC@@ACABAUDEBAFIB@BDDCDBBEBADKHBD@JMJWD@DA@BD@NABAAAHMBMF@HCBBBBB@BQFEFADE@DDE@@DD@@BEDKA@DHFJBBDIDEAGBABHDBJFDCFBDABAA@BBBADBBCFABBFDFKHGB@FC@CDDPAFHBBBADGJ@DCHA@AAI@CHAFIJEFCACBBFGFAFE@EB@DGABFEDC@EEEHCA@ACEC@AACDIACBAD@FDB@FDDABEA@BC@G@@B@BL@KJK@INAD@FJLBFOTAJBDJFBDAFGJ[LCJIDKTKFEFAF@L@TDLXXLJLFJBFBBDDLAHOJBH@FOPGFAB@LIPGHAHEJDN@DCFIBMKMAEDIJC@KGOGQAMDKEC@WVANAFCBIDC@EGCA@BCHBH@HCFEDBNDJGN@HBFLRNLVPHHBLFHPBNBFZJRJJDBB@JKJCFGJBHAJILGHGDAH@BHDBJBFTFHNHBBCAABEBABDFGF@FCHAN@FC@@FDLDHAB@BLPDTJRAHIJBBBBARBFVPAFCDBBdJPDDHHNFHJLHDBT@^IJFVVHHJDJBF@FCLAR@dOHBJHDBD@hSBOCEMKCCGMEQAAHU@IBEFGPGJGHI@GREBCEMHGLEHIFQ@YFCHALEDEAIOSL]CQPCNGJLNDJ@\\IFAJOAKHCLAAI"]],"encodeOffsets":[[[107271,31894]],[[106606,31777]],[[107423,31687]],[[107413,31680]],[[107394,31680]],[[106718,32249]]]},"properties":{"cp":[104.398651,31.127991],"name":"德阳市","childNum":6}},{"id":"510700","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@A@@BB@@A"],["@@@A@B"],["@@@@@@"],["@@@CBEJGDMJMBODS@MDEAGBCH@DIPDPGPAPERBTCT@HCD@BIJE@GAGN@NGHGVIBGHGfKFCBEGK@AL@NETCFANOFK`@lP^CDA@GFKDALB@IJUHENB^NFBbIFCBCNEDCBIAKLUFGFCZEVMLKHCLMK[AGBGAIKGEICK@KHOAEGIBGJETCJCJMRQHQBUDCFAPAVHZCREN@z_TEHEFGDA@CCGBC@EEQAGFGFAHMOSFE@ACCBGCMCCNM@EHI@EDAGEAE@AFCGCAAFBBGH@DMPIBCDICUBIBEHEH@@EDEfWJCT@FABCBIDCLILCFI`LLBrEHGFKRSTShFNJT@RCL@B@BBNBHBDEFA@CDC@CCCKDMC@CAEGQ@IDKBCHCNAFCDEBEFADABIRMB@DABIKUBOF@HDVRhNDDAPBJJLJDx@FA@GB@F@HBJLCFBJBNDDFBLAJBFDH@HD`AbGLDZGJBPERFRDN@F@H@JJLHTFfDFGHKDG@IACcYLOLGDEFAZLB@FAEQFC@EGIAI[cRMBGCCIAOGKOFAAGEABCHABCFDJBJEF@FCCE@ANABFDECKUWOIACRQJITBFECE@EHEHABCBAIIBGCCO@OCCAAA@CHCN@FGVEFCCGc[SMMKFgCCGA@GEGHGBM@CAC@I@@BDDCJDF@FGAMBKAEGBECBKD@BEEA@GEE@CHG@AMOEDANAFINEPEJ@DAAO@AGAAAFC@AFAHA@@IAGCA@CBAAA@AA@@ACBIC@JBBADGB@AG@@ACB@A@ADAACD@BAAED@EAACIDCAAABAAADCAA@AEFSB@DGACBA@DCACFCVUCEFG@GEEAGJIDMJGHADAJACCBC@CK@AMACIC@GIIKSAIFGD@@DRDB@FCH@@CHGBKVGHGBCCCICCEA]EKEEAA@ECUBEDCJ@NHJCPAJEJCJIHM@Q@IOE@KLKPIBIFCBBDN@JHJHBDGFAJBFDHAFIFADCEIDIFCTEH[@SAIC@EDCBkKAA@ADGBIECCEKEEGIBGAGMGC@CBCJAJIHBHFD@H@LCF@HFRLJHPHBBF@BIDG@CCI@@RMFMNEHIHEBAAKFU@COGCSKO@GBELALG\\IHKJBBHFFB@ZAPEFCBCBKKWHSA]BIBCAGFADD@BC@@FB@BCRGDCJ@DQEEDGFAJDN@BCAEBAH@DCL@JGHADEJC@CA@BQCAFADCEEEAAAHABADMEGSMCCC@AEGB@EH@@CDAXEFFHD@FJBBDDABID@FDDADGDIHMHEBCH@HG@CEKECEAAABKACA@A@ENC@AA@KECDGEG@ABCFCHEHAAACCLKHMDAHAPIZIDDAJBBLFLML@FADEDDBNDDBBLEB@JHB@FMEMHMDCNBBBBJFDLNJCXFDCD@LJFJDBFADCJQHADDHA@E@MBEDECI@EG@AMIECEEGACH@BFJA@AKCAC@GIGKAMGKDCAAMBAHABECEIGCKAGIMAEDGAG@CDAFAJNHBDAHBDAFCDEHAF@FENGLQ@CAGDG@GDCDAVBLITDJC@CKCEOGEAEDGFCFK@KFGAODICGFAJDLGIIKBC@C@C@ACBCDEBCAAEA@IDGFAD@DFPEDBJAFDBABEFCDBDDDA@IDEFCBGHEFEEC@CHGBKAEKCAAFI@IBIBAHABCCOGIE@AB@DBJADA@AAEKBGNMFKAGKOCAG@CABCNEFECEGA@@DgAEKEAIKGMACICEE@GBIDEDOAGA@CFICGHCBACEGCIAYFYBMGACCESE@GHCDEAIOAKCE@KECBQVOFKFIVCLBJOAWFAHKHCJEBQAIBICIDKAADDNADA@GBIBKEABMREVGJ@FWAOEIDKJUACDAHCFEDE@OIE@CBAFBJCPKJ@HKFANMJAD@NDHQRAJ@HDHANCDEAE@CH_FC@CE@K@CGEAEIKAGBCFEBACEIBSFCRCBCCGSBCHEBEACECICOBEEGBA@GMKCM@IHGAGEKCMAWFMCEFS@GFEAECMQGAG@GDAACGECAE@CNI@E@CEKEMKSGCGAGCCCDMCIBCLCBOJMAOFULKAGBMAKBSGCOBEAEE@GHQFERYBGEEFC@CBGXIFEAGEEWKBEJOHGF@BDD@LIDBBHFBBC@C@CDAJADQACDEAIAKDMPOHMDAPDDABCHMDaDKBEFGBCE_HQ@CEG@C@AJGBACEIGEIC@GDA@GCGEEICOE@UJOBMF@CHGBAAAMAQLEAQKGAGGG@CBIDEE@GCK@GU@CFBDB@DCB@DB@F@FIB@JBHGBBDBFCBECC@GJAFAFECCAA@@BDH@DKCEFI@@FCBCBGAAH@FCDEBAAACBEC@CDC@CCIECB@DHFCFGCCFMAC@AGC@MH@BBDBBGFAJC@CCKIC@ABBBHH@BADEBAEEDQCABBH@DA@GCCBBJABMK@BBF@DG@KCIFBF@DIDCHC@CAC@@F@DMFEHKXCPGdHRBH@\\ADI@MOME@EKSAAEDCPALN^ANDVAB]BKBA@@NFPAHITQbAFG@GAMAOBE@GCEDEEDEACCAEDGEABAFKDGEA@EDEBALGBGCIHWOEBAH\\ZBJERMPGFKBODEVFLTVABOJIJAHFPBPALCLKTWBINMFILMFQR@BAFBBXVHJBH@NCHABKBMFG@SCEBCLFDEDE\\KFIPCECAGFIACCAIA@IDED@VBNCTDFHDADGLI^DFFBXDBLDBNBBDCR@NFLNTBLCJEFEDIBKBCAACEMCAEBGFKI]HEKaAA@ABBJCJCJGJBFHHADCHGFGJIHAFDL@FAJCHVIFMJSDKDGFCJ@DLVCLGNARDJGJGDQ@GBCNEHEDYHUXSJCKA@EBCC@CDGIF@HA@@CACJGAAC@KHC@BA@AD@BACCH@MGAG@ICGKEGHGAE@CEG@AAAEBEFCNGBC@CCAI@CGAAG@OEI@AA@ACACBCCMFEAGAKEC@ED@BBDABIGDEEKGHEBKBUHO@MHCA@KGCKAUFGPEDE@OIKHKLONEL@DFH@DKBU^UJSBIFQ\\CHEHEFGDIAICCASHODEF@JGPOVIDBJKBGDBLKP[JMBMCIKMHODDRK^PTBJCFKFGBED@ZERGJKFGHFNADQF@HGJIHOHEHAF@JGVBBFRHNDDNLDF@DADBFCDcPEBLHFJBFAJTBFCFCF@HDHFP@LFFJBJDFPB^FDPCZBFCH@DBBHHBDABGBCBBH@HIHFHI@CBDFCDQB@BBFJBAFE@CDANBBF@DBDLABIEC@ELCBCA@ADIACE@KFGAABCFEF@HAFMDS@GFEBa@EFE@[OKCGHCDCREFIHUEG@EBQHADAPABUC[BWGICEFE`CHGFM@ATFRAHUHCNBLKDQTG@IPCFC@KMYIUAMEEEEMI@S@KFCBO@GBOPQJOJIBS@YJcDSAQJIFADHHDHBL@NFLBF@NAJFJLLRJBDCLBBBDJDFRFDNBBF@LHDTHNBDPNTAHKTCLGPDXJDPFAJBTBDH@bENCFHDNAHOjF@NA\\ETCLCRDTM\\KH@\\HVCNGHC\\DBANMLSPILBLFHBJ@TJfFH@TEZAVCTFNEB@BNBB\\LXBHAXIHMLC@FC@@DCFBDCFCDIPBBTHJLDdHJNHJBDFDHHHFDbJBL@rCEVENE\\AHEFOHMNKFINGFELEFBFHNADCDiJOLGCEEIIAEFS@CKQAICMIG@EFMAAKIWGKECEEM@ECCCFCBQ@_LI@EBOAA@MJG@CFENCBcBWAK@IDEJETCD[NAHALGJIHOHMRkAIFWDQNEBWAIVCFQRMFJFBHADCBCHILC@CDAFFP@NFNDHHHBD@PHZAHJJLPAFIZCRBLEHAFDT@HELAJJ\\CFYRU\\GJM^OHKJKPIPCN@JFNFZDHDBL@HBZLRPDFDNHB`DZKDArJHAJ@JDNHZBRDZEJGF@TDXNHDHCLM`QJIHO@GCM@QHEDUTgRUwFGFOBOCEAEDCBABB@AAAIG@ABIAAKEC@AAGC@IACKCaQB@ZBBARDdDLBDDFH@PBLLPNTHDCN@F@DHFBDBBLB@DCLANC\\AnHR@PLXAfFJALBNAHDPDNAJIRCNGHMBCFKV@NADKFILQPKDFFBFAPNLNP@LKN@FBHCBIAGBSnC@QAEBCD@RGPFJ@J@VEPGFIDMBKHE@ECKSGEUGKBOEGCEGAIBGAAI@E@kMEBKFQTQLIL@DJTPFJDHHBJATBHgPMCSHADFJ@FCDI@BLDF@FEFADFFLBHD@FK^FHPFEFCHCDNP@DENBFRNBF@BEHDLCJAJDBHB@B@DFTEDAFRVF@FCD@DDBHFDH@HAHBZOJCFIL@DAJORKJCFAJKB@R@VGNAFBDHDBXI@GBGJIHCLAHO\\KDCBGLCDGDCPEDA@MBCFGNGFGHIHODCFAPDF@DERMBEAGDIFAHATIDCDIDCFAFENJLADBJB@H@BTF"]],"encodeOffsets":[[[107271,31892]],[[107425,31684]],[[107393,31677]],[[106780,33681]]]},"properties":{"cp":[104.741722,31.46402],"name":"绵阳市","childNum":4}},{"id":"510800","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@@DBHJDLLBGAGKIKE@D"],["@@ADB@B@@AAA"],["@@BLPA@CAKOF"],["@@CD@B@FADE@EFEAAGCE@AABAACCDINMFH@DPEAIGGIEQAAC@CDEDAV@BABEGIMEGCEKFUEQBQFKDCHEBAAEKKEK@SACEAGCKBSIKLDH@FCNCHBDKJE@CCC@EBCD@LDJAFIDGBEAMCMDEC@CAGBCIK@ECACCGCSBOOCGBCACE@CDCGAAEDGNC@C@KEIAAAFEBOBEEU@GEAAE@EAAIAGJE@AFGBC@GE@GCCG@IFKBIAOMC@CBCDCLOFIHERANBFHHDFBPADEBK@[MOBOIKIADCBDDADIBICG@CFCRGLDJCBCCCC@OACECCECIDIAAICBECIEKF@FCNF@AEC@AFACEJI@GDI@ECACCMCKGAIEIDG@CCAM@@EDE@CII_W[KAC@ADAXIBAAEGCS@SDM@EAEIECG@OGGB_GI@EACEAGSEBGBEACMHGCCGM@EBEPGDGAQIUG_BAACMBANGDGCIQOAQEAI@YPCDITCFIBEA@IE@AAACBEFCBEFADA@AYIGBAA@MCEA@KHALK@CBDF@D@BMBAD@LK@A@@DLFCDGBAFFBHCDBBD@BGDCFBFBBJDAFC@C@GEEACBCFEBE@ICEBEHBLC@EAEDCLIHGHKZUBGBBDDD@DIPIH@TCDUMIQCAC@OFIHC@QBCEAG@ILQBIAEKEACBEDGAECGACLKAICGKDE@CC@AHIEG@CCCEDI@ACI@@ECACI@GCGAEGIAMAIFCLCJIBGBM@GCCA@ALEJCBGEABCFAPQECBCABCACUCGD@NCFCDEBAA@GEGMAMGCE@A@CHAHE@GAAMBQEAE@ECGFEBICGEQAAIBEEA@GJ@NEPADBJ@DEBQ@OECE@MACGAKDMBGCIGE@IFIBCCGBEDALADMAEJGDAA@GA@EBAFGII@GDA@BEHE@KACGAAGC@EDC@DGBEFGACQFEEICAABC@ACAG@@ADGAAGGIAIC@AIDCFGBIHK@CDG@ABBFADM@MCEHFHCRI@CDQHADA@@ED@@ACCEBBHADAJB^GTLXALADEDOFYBA@EEAGIAGL[JKHKBAF@HLPDTPH@DEVBLABGFGJMFENQN@@DJ@DCHAJE@AAOGIGQKGEE@KDG@C@GEGAIJKBAFBBHDHNHBJAFHLFDFFDAJCH@DFB`HHBDAFCD@BJ@TG\\SFEDCJFJCDEBEJGBECM@A@CHGAGIBEEQC@CBAJOJKL@LPF@D@XGNEFADKDIFOBIDMGI@CDAFDV@FBBFFFLB^DFJDDDADGHUHALGH@DG@EDA@QC@CC@EHBJLTJJ@HJDBDBNL@@DADDDIBCBGBIHCNIJBHFF@HEHDFUVEDBDCB@BFAHB@CTAFE@BBBCDBBABBBDBJCBDFBC@BFABC@BDCB@B@BDA@BH@@BHABCAA@IJDDA@BB@@BBBAB@DDBBH@JB@BGBED@BEBBBHP@BB@CFIFOJMBE@KHENP@BGH@DFF@HFBAFC@ALFDHABFALBJ@FEFE@ICCDAC@@@JBD@DANGHFH@HHBDDEhNLTNd\\DHEDUFEHM@GD@DBBDBPDP@DDAHJJABADGBGF@FDFEFSAIJQRBDPJVXDLCFAEMB@BDFEDE@IFIAECADIDFDBHEBLPPHJBDDAHQN\\dBJHJ@FEDFRCBC@YKEBCFKHKPdZBDBFAFKRCFCBcCWGQOG@E@M@QCQEOFIAYHKCaHYBG@ECG@OEO@ECAMAIDEIKGAE@A@@HEBm@I@GAEEEGAIBOCCgMUQGCE@APLVAJCBA@QNAJCBEBAFCFEDMBGDADCL@JHRBF@DNDLCDD@DCD@DEBCFGAMAAAA@K@QDS@MIgESTQTELGHqFKA_KEJKDKJCDAJADEBS@IDeXCF@FG@GFAFAJDVCJADOJCNG@AHEABBHDED@BBFHFCB@FGJ@FMNDDDNAHDD@BEFPTGNEBEHBHFR@FADDH@DCBEHGFSFy`M@QFYDUGOBEBCDAVGRQRINIDSDGDCD@FHJBDAFCFAJ@HDLFJLHBJAHBHL\\NKFAH@PDXAPDRFLHLDLCTURYVKJIFCJBTJNHJ@VCVBPAdPHHFPJBJAVMLCFMNQVMDCJMBCAO@EJIFGB@HDFAFBZ@LBPHN@FBHLBB\\JNDVLPJN@JADBNJFBHAHBFANBPJJLHBPCREP@NALIHCL@FAJSDAHOFEHSNIHIFCLDxJBBDFDBNBHD\\HBBDHPABBDPbDADAD@BTDHFBRAXHRFBJAN@RDLERQLGJ@VHXCJBJHBFPR^@DLTDJ@NHBD@FDDHL@DDFFBNRFDFBHG\\JJ@VLXJRRN@^CDBDDJD@BAD@RJHCRELGBCC@ECEC@CJBJADEBQ@KDDL@HEBCNGTCBGTOR@FIHMFCHDBBAH@B@BBABC@CDDHED@DE@ABBBD@ADF@DABDCBBFG@GF@BHB@DDDIFAFA@ADE@AFC@ADBDBAJBLJHAH@NFAJJfBRDFDFRNTDVAVBVEPIH@PGJID@DEHCAEGCAA@WAEAKHWDGTONABAFONG@[FGJUAECGCOJYFED@HDHFHAFDFABCCaDIBCRCBCDGAESIEM@KBQFGJEFAXDNFB@BC@IHKBMHSNBV@JBN@DDHJJBJADBDDHNHFLAVNR@B@FNHFDFBFRADBXZPHJAXILRLJFBJGF@JFL@FADGLWDALH\\LNTFFJBD@JEEbEHJPHJ@BEHAH@BDHDRL@PIN@DCFAFDFHBHHAHFJBFBFDRBPHJCFED@NARAJCHGF@NHH@TLJFJNJHF@XOH@RS@CFCLBDBP@DJ@HFFJDBBBH@HAL@BHARKB@BB@HLDCLF@B@BEHIACCC@AFINGJOTMBCCA@CZBHBFCH@COHI@CEIFGAG@CCCMBECEK[CCCCKAOBAVB@AASRMFGFBDALQVCHGDQBAHCHA`FFCN@FEBIJMVHJBDADEBGAEBCPEXDL@LCFB@DFBPIZAHDHBFEHARDBABEDCHEBMDEJGHAH@HDTBFBLLB@FAhKZ@VCDBHGVMTSRIBCCOJC@IDGLIPGD@HDZELFjfFB@BALBRBJBBFANMJCdC\\@BFBHDJVHJHNBRD|HVFDDF@@DB@HJDBFBRGNBRGZ@FAFDRHBQ@]DS@WDIHMRODQAICEGGAABWDIH_@EGK@E@EHGEO@OASHG@C@EQU@CHKHANKTIFEDCESBCBCNIFGDIACCACGCKBM@CFAAICEBEA@BCLAFBBADACADEAC@EEAAE@@F@CGBEAEBIAI@KAQFEDGAEIICG@EFGFAXHF@RIPIPWCGD@@AAADA@EFAFDCD@@D@BBFFNG@CFABA@EBBBBBJHDH@ACCA@CCBAG@EBCHAFAFAFEDICCU@ACCCIAAABGAACBIFOFQBGDKAGBIQDCD@FCAYCCMCIDQEGFGAABABDB@DABAFC@EGKDG_MQ_EU@KCwIOASE_GMGCIGqBSGUBCNKBCCQJy@CMEMKAOUAGACGAKBEFCLIFARCDG@CIGKCEBUJE@OSKEACCK@E@CFCDGIAO@GBC@@ABICKBCBC@KLC@CASCK@CQDECAKEKIMCQAEAAIBIFGBC@EEGAIBGFIABE\\]JODQEGG@GJKACACCACKOECOQCB"]],"encodeOffsets":[[[108623,33546]],[[108027,32308]],[[108974,32684]],[[108981,32690]]]},"properties":{"cp":[105.829757,32.433668],"name":"广元市","childNum":4}},{"id":"510900","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@@EBCF@L@BKJGR_HEDATABABEAG@MCAAGFIHCNBBBCDAFBFJ@JDBDAH@DD@DEB@LFB@BCBKDGTKAKDENCJ@TBHCLSLIBOFC@CCAWACCAAFMDGN@BA@ACIFCD@JJDADEICEA@CF@JBHABIGGBENCVQVKBEAGCGDGDARADA@EACEIIG@EACGAAC@GDODGLQ@CIBECCG@G@AFGDAH@BA@EBGDCCEAC@cDCNC@CAIFGISBCDCBKBADBBA@EEAACJMJQDGEKGKFEAECKBAJCNAHC@CCSBIBCNKHOFEFMDAD@H@HEDGBMBANBREHGFIAKKQGUEGCWEAQEGEEOFKHGDANCFPFHDBHAHEJBHDFEBGBECKBEGGQG@CJGLKF@FBBJD@BCVEFHFALJH@B@DLEN@FBHFFHCBCICBEDCFBLHHAPI@B@XAHEBS@CHC@AAAIAAABCBEJIFADCJBLFBB@LKH@B@CJDDBBFEHMFGLGFADB@FGHELBBHADBFAHQHIBGJMAO@CJIDIEUACCCIAUDEEEIBKFILGLQJ@AJDDD@PG@IBKHIFDD@BAAKFGACOA@CFGB@XFDA@CAAOG@ADAL@DACGBKAICCGACBIHEDMCKAADBHA@CBWI]ECDAFFD@BMFSFALKJA@MIIACECAGLBFHDF@DJCJCAAIA@AFADMAEBCA@IACEBCHIAAGRCDCACGCCEEACBCDCH@HDDBD@BK@@@BDFDDFOCGHAABEUM@CBGECG@GFED@FFNBDFB@BQJADEBAJBDCD@DKNKDCA_QKDAAECACBADCBGGOKKECMBK@EICABCAGCC@AF@KE@CPGDGUWKEAC@IHOCIIEWCGC@EHMFGBEE@IDGGGB@DCDEBEBGAEMDGHEBAAIE@GBEC@ADAHABC@AEA@ADM@ABACCAABCF@FD@ABGFCD@HDFAH@BCACIMDEFC@CE@CBIJC@CC@ADIBEGE@DCAE@ABBDEDCCABC@CBCAEDMCEAA@KCM@GACBADCRADCACAE@CFCBI@IJA@[AEHG@ECAG@MAASK@EPADGAIDCEC@ILCHGBENKLCLBJDB@NODEEGQDE@CCCGBOAICGQCE@MDG@C@GIKEIBOJICIKECEAIBCBELEDKBCDDFGNJB@BCHG@CBCFCDCJMBMNE@CAGK@GCGCCCAMJKFEFG@EJMECBMP@JBHAFAD@DMHAJEFIBMHG@ECE@CAEH@F@FBFGDEAAICEE@EAEDGLAJCDHDDHCBIACBBHDF@FIBGJCACGEAIECCKCI@IKMDGCCD@DCD@@ADE@A@HB@DB@BBQTBDCJBFKA@CACQICDDNIBGHEEG@BG@CU@CACEAAEAK@IGKB@CBGACKDCEG@GBEFC@EAK@CIEA@CGBCAM@ADG@IJCBAAACFGGCABIFIJ@TCPCBYCGBCDAD@DAAQBMFIHA@EEIDKFGFINAFGFBFL@@BCB[@MFKEIFAF@D@LIFKTAH@REBG@CDBDAB@BABABDHCBADADEC@BAAE@FFD@C@CFICEDQBBDFFDDBHLADBBFDBAN@BGDGAIFE@IFAFJNB@FCF@B@HHJADF@BEJ@FBJADGFQb@BLLBFBHADCDCCE@CLGF@DID@FCFBFCFEDADBBHABDDBBDBHCDFD@FBB@DDD@FB@BAFGB@HD@FDDCLBDJD@BCHHBBHJBJL@DKJJNEF@BL@HDDFHC@LDBFABBBDAJHHEL@BDBDAJGFBBDCHNHF@@NDBFCBFBBBDL@AHGLKFCDBDFHBDADCB@DHD\\FHHBRDBAD@HHBBFHFABCB@FGF@HDL@HFFJCDAH@HHHBRLFBRKNBBBABGH@DNEPAVIF@DPFJHFHDB@HCD@FJJHDFABIH@B@DFH@DGRF`ADEHAFCLCbGNADCBOCCBGNOPCNBLBJCFBDCRIBCB@D@DADEAAGCAKJC@ACE@GHIPAFXLFFBHEFWJAH@DEDFFAHQZEFGR@HFFFBPAHDATBLANBHKLEVBPINAPKDADDJCNDDHDHBHDLTFNFL@D@FMJ@DBFFDDHBBHCH@HBNRFDFBHET@FENDXENBLDHFHBJGN@LDHNB@HAFFPAJDFDBDAFGFADHTDDDADQTEJADFABEFADBHJLBFHF@D@LDFD@`EDGF@FBDCBMCG@GBIRQCG@MBCNIBMLE@GLIDOAIBEDAF@PJF@FCDEBGDCVBLIJCPFXB@EHIFUNQBALFTCBCCON@JCJDJARBFADILGBGXEPBAIDKJULEPERUDALFF@LDPB"],["@@ACEAE@ED@DHBH@DC"],["@@K@KFCDAFCHFBHAH@DAJM@EAA"],["@@A@B@"],["@@@A@B"],["@@AABD@A"],["@@@B@A"],["@@@CABBB"]],"encodeOffsets":[[[108154,31722]],[[108467,31225]],[[108459,31201]],[[107597,31173]],[[107602,31143]],[[107617,31126]],[[107618,31125]],[[107723,31040]]]},"properties":{"cp":[105.571331,30.513311],"name":"遂宁市","childNum":8}},{"id":"511000","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@AGIDFHFC"],["@@AC@DB@"],["@@ABBBADHBAECC"],["@@@AAABD"],["@@@CCDD@"],["@@BAECDF"],["@@@@@@"],["@@LFDKDAVILABE@E@AD@ADFAAGDA@EDCACDEAIEBACJE@ACAACFCCECA@AC@ACA@@DCBAAAEEABG@EBGCEBARAAFCD@DNDDLDBB@FEBDP@BADEFCLUFAHFDLD@P@HCJBDHJHDJHHH@HAFKNMBKGEDGF@FFFEFC@CMGEAAABCPEHMAGDGF@@@DHFEHABFDPCHDHTFLJFDBFCDAFCBUAIEMFI@CBCJJRFDCPBBFBD@HGAGHCJDHBNKJBHENBJAFALKBCACACGAQ@KCEEDGDENCBBAD@BRBDFHBDDF@@CBOHKAODCLDPABCEKLGDAAGB@JAF@BA@CKAAE@CD@LBDDD@LA@C@@FBLE@CKCEIEB@IKIBIDADBDHBBB@BEAODEFAFBLAFBFJGDWVAFBBLDDFDDDA@CCGDAFBJDH@DDFBFCBEDCJ@NCDB@@KHCHILAF@BLFHABHPFFEFANALDB@@CEC@AHCD@@FAJGHADBDDBDDHDRRD@BAAIBAR@DA@AECOEACFCBAFBFLJCFFJCBAD@DFCDC@EDADCBADBFRHRDFDBLLL@DOFKABEEQAAM@CBBHAFHBDBGFAFDBFBDFLCTFETABE@ADJDNEFBBDEJ@FDBFABBENDBJCBDLFADG@@DFDDAH@BAB@BFC@ADDFdFLCTWPIJATDJ@H@NEHCFGNMPGHUHGTCRFFA@CAIICIM@KhONENMDIBGAGAAFOCKGAG@MRC@CCDIDC@EBGEADEBEBAJQJK`QTADEDGL@LDFAFBVP\\FPHDADC^CR@XFF@RKLKACAEBCJCBEDMACGE@KP@JAJKDAJDZEXHLADHAPBFFDDHDDP@LAPDF@LIJKLAFCFATJCNBJHJFLB@LIJEJODSHEBSVBJAFAFG@EGoCMKUHMFIXSDGF@@AACDGCEAKJBBA@GGIBANO@AG@KGGEIKIGWJ@ACABGIADCACBAHEDMDGAAIEA@OECCBOFKAGACGAIACDCJEDEAKCMKEKAKKABAFEKO@CBCAAEBBFADKAC@@DJF@DKLABC@AQOIAEFIFGBKECKBWKAIEKDICAACCBACJeVCCEFCDAV[DIFWGU@GBIJELALO@KAEGCKCCC@ADEPGD@NDDJHBFAFIDAHBBB@TBDFBPBHABB@ADA@ABBB@BEB@@DF@B@BB@ABB@AB@@ACABCDABCD@ACF@GCJAACDEEAKDC@AADI@C[IGEBAA@DAACpFNCFAD@DA@ADADBBHFBTIDEFQVO@CAAAEFI@CECCBAA@AEAEGBELI@GGGaUAE@GFKBKDKEK@OEAI@CAABACC@CEABCFEBGA@GLE@C@CECO@CA@CBAJEBC@AACE@CACFA@@A@@DAECBAEA@CAAEAA@SL@DC@AD@BD@EHAEMMMCICKBAAkeKOSiEGEGOOAIB_CMGCQBI@AAA@AFG@BHEFGBECC@KJIVGDG@ECC@CABEJ@BACECCKBOFCDGJIHEA@EEECAABADDRRVBFCHKJSBCBEJK@ODMJCJIGUJIBCA@GCEEBCBAFHF@DADIFCFFBFFBBADKDQ@ID@LHFFJ@FAFEDM@IB@FJD@FSDOPMBABAFHJABMDKCGBABCHLNBDCHMJAFBDGBWFFBADBHAHMAEFIDB@HHD`BDFHH@JFN@FDD@FIJEF@DBBDBPFH@DCDKDAFBFGJCA@IEBCLED@BFRDH@DEHMDGJKAADFF@HKNCBAA@GAAOBCIRGDEBCCAMEQBEAAKJODGACCACBSAKEEEEHODGAKEOMM@CECKGEIDILGVQREDE@CCCMGAOCEBKBGDEFBJCDaDADBFADKAKH@DDTABKBGIIBICGBCAGK@EBGCECOACICBMACAAQJ@NAFEBMCAJIHBHABQDGICAIFCBAACACAGKCACDIEG@@NKJEACGG@CCBCACACAMKECA@CFAHFDBBAACECAAHIBCCGDAFFBCCE@IE@GB@A@AJGDBBHDBD@DEEIEC@CFAHBBDAFDBHBDACKGGBE@EGIHABCEG@KEAEDIRQ@CAFIDE@IFKCCGCKFMDMECDG@EEEF@DGACD@BFADBEHBDB@DCB@ALICEHABCEBEC@AB@FCBE@DHEAAHABCADCEADCIICADFABCAC@@FC@ADBDF@@DGBGACBBFH@ADCDBB@DDBABG@ABAH@HABCC@CDEAAGFBDABCCED@AAAADBDABABECC@ABDF@BMD@JEBCEA@A@CDBDFBAFDDA@GA@HCCADC@ADGABDCDBDAD@BCBADACEBAACA@CC@BCCA@EA@FEACIDADACC@ACCBE@ABC@BCCA@AF@AEEBECCFCDEAAB@DCBBB@BIF@DCDADAEADEEMCAEACOFAFDHCBC@GC@IEI@ARG@ESCGCK@ANIXEDIDCDGZ@DH@RARGD@FCJGF@BBAFGFIBADBNHLAHBJADK@ADFLEH@JAR@HEJDFAFEFMJO\\IHIJM@GBADAHKN@BNDCJBNJJAHBLGPCBUFEHGBWCMGGA@CCBCCGDIAAHEJEDG@A@@FADA@MGC@QNSBIGCEGICCAOFE@GFEEIECMCGIGEMAOIAA@ECAKDCDKdIFEJCBOBEBENBHADGBKCG@[NQGCBABAFJ@H@B@EJBBCPOJLHDJAHBBHFDPFH@FAHB@FCD@DHJHBJFDBJHJBJJFBHJFDJJ@HEJKFCHALBHF@JAFYP@H@BHDFBDBD@DBDD@FLB@FDDD@FEB@DDDBDADCB@HLL@^PF@DCLWJADCF@JFHAJDLCJ@DLTJDDBDCVBFHPR^BBNCFBDFFAD@FDFJF@BDDJJJ@DIFI@OGQJFH@FDF@HELALBDFLDVPVPDFH@BGBCDCLBH@FLHDH@DIJSFADFNCNIBGNML@DDBJABBBFCHCDSDA@BHABA@IEAD@JDDBLBDBHJHFLDJHB@DKJGDKDGEE@CDCB@BFDF^FF@BEDAFDHPNDCAK\\EdADDGL@FFHHDHAJCBEDKFAHBFEBC@CEKJKDKDGDAFBHL"]],"encodeOffsets":[[[107424,30623]],[[106991,30571]],[[107560,30176]],[[107894,29997]],[[107898,29991]],[[107918,29991]],[[107914,29987]],[[107051,30726]]]},"properties":{"cp":[105.066138,29.58708],"name":"内江市","childNum":8}},{"id":"511100","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@CK@K@ETMBCEE@APCFA@CECKAIIMAIG@AJC@AAOACHO@EEEMEGEAKFG@AYSCEAEBMGE@EHOAAIBAADEFGDKCECCABCACEBUEK@EDG@AMACCGYEE@@@CEKBI@SDOASCGKGIMCAODEHCDiNEDO@EC@EBMVgD]FCJABGSIUSUCMO_GES@EFK@EFOC@IIEABCAGC@MHODGDE@EEFYKCC@GDEBMM@ABANADCBABiFIJEACICABIJA@CCCGCAOEQBMECGBKCEQOMEEAEDILEDODSXEDK@CBENaXILQLINIJMDGDKHKLEBoSGMWMEAIAMHE@ICECCKDMLK@EAEIECECQKIGSEEMAKCEEEBE@YCEC@ICEKABCNGF@HCPgBK@GKEACFGFC@COBUCCC@GJCRDD@HCFEBE@CAAQGKQMIWWCCEWCAODI@KCMMSEK@QAiSAACG@UBCGDGFCFCHIHKDI@KA[IKCOHmBCEFWEMS_IIIGIKYKEGSEUAMCOAaMOIEIGQAG@ETOPEHOAECEBIBICMMcGEGCKAGE[[QICEECQ@QFEF@FOJENI@CACBABMDCBGJGTAHUbILCRGJGNARGNIHMNIBUJKDWBEJIHAh@FEjDF`PZRFJLXDTHbJHHRT\\DLF\\JLJHRLHJDLBN@HCHOPMHYR[^UbILMLSHi@CB@FQOICKJIDK@EDSVKHEBCCKC[DYHICWIK@MKUKCAEY@uGMIEEEUMCEKMGCEGAQBIBEBGCUIaS]IISEKAE@MLK@GDSBSLEAEMCACBGFOBGHQB@DBDIVEVUdM`@JDPH\\CNKHIRETENAPDTNbPhBJGZObCLBLDJ^\\DJALGZUpIL[vGZATDHDHFFNJhLTJLHVTDFEJUZU\\KJILGLCPANBNDNJ\\HLBPAPJ\\HFt|@HGHC^KLBHFDJ@RIVC|BFBDBCF@HLVFT@FCBQFCDCBMAEAG@KPMXUX@DHF@BEXAHBFLNHPLLDJEVADULIJGLCNLNJNVLJHHJHNPPJDPAXIHBRDFANMPGDEFCZIF@PJVFJAFBBB@HFDL@PCPMLETEP@RDLF@JHfDjHNFBXDlE^BNEJAN@RFHDJBL\\RLFHIDWBKCI@KDCBBFFHFRJH@BCFMZIPADHVBDFDLDDDALDHCLEJRLL@XEJBBD@LDBTDHLFDNBDFHRLDBBEVDNNDdPLJ@DFDHBHCAHCHCBGAGCG@AHEFAJEHDJCDEDG@CAAABEHEBCCSIIKEG@EJKDEHND@BCD[E@EFEECGAIBABDF@LMJEHBDHJHHIR@XFJHJPHFD@JMJNX@BCCBRLLJDHFDJ@JBDNADJbBHCBCDAB@BDDAJ@LEHDJHJNBBDADGPAFE@AGAEEAABCLO@ID@FFD@BA@EBCH@DCHBDE@GBGBAFADFFRAHGFGRHPAHBJAHBDCFBPNAPBl@H@XMDDHLFDNBDABBDFHH@DFPBBHBVGB@HBBFBLATALCDQD@DHF@BABQ@CD@FHFJBDADEHADCACBCJBD@DGJ@D@DANCB@FHVAJJLDDF@DCBCBADBFI@AFED@BHFFEDBTLFF@LMNBBFBRGFCAAHCFAH@B@@FRLH@HCXBPHBBCLF@TCFAJETEBC@MEMJABAAEBAJAFDF@@CEEBCH@DCCEDIB@TAFCBACEAELEBAJGHKACMCEIRENDDA@EGGBEBCJEBGIMAK@EDCFAP@@CCMBAJAFC@ECCBICAMAII@@DQ@CC@MJGBADSIGBIEG@KFC@ECAEDMCGBCHGFILGHO@IDKECACBMBCJBJDH@JJPBBBBDAFCDHBLELOR@FGLQVIADF@BLBBLBRFFAF@JDb\\TDHAP@HHPFBPBBJ@NER@LAV@FFFJ@TFPBBFBLEDHAJABM@ABAFBFHBJDXJBNJJJBADKLCHBL@FBDPBJFHADEFAL@NB@F@BMJCHED@DBDNFDDDJFCDHNEJGD@D@JHLDJLBDJNHBRELBFFFBJEBCF@@CJEHBBFHB@C@EJEBIAQCCIMEACAAKBAF@FDFCDARBJAJCDCBUDAB@FDH@DA@QAAKAACKQAMCCOAAAAEBAHEDCHCBMBELKBCF@DCHQHAHFD@JCF@BACIBALCF@HIDOBAFEPEFIPBHGD@DB@NBBHBF@TANCFCBCDAHBDADEAEEMAQBAH@JDDJDBFA@ECCEG@EDC@GHCBECGBARBHABBANH@JFF@JEBE@AEG@GBCHA@AD@DA@CIE@ABCRABCIA@C@AJEL@BAECSBAADILDBA@MHCACOABE@AM@GCI@QBCAAEA@KDEDGBABANOFGAGLEBGC@GCEFOEIKGCGAKCAQ@KGIFACAE@@C@CDAABELMDKXIFGAKBCFABA@QKOSGCGDCEGEDA@MCAAAA@IBAZFDAJMAEIGAE@CF@JHJBBAEEBGHEBDDAAA@ECAAAGC@AH@@ACG@IEEAEECK@AD@HOJAHEFE@CCE@@FH@BDABC@@DADEBCCEOECI@OM@CGECEGBAAAC@IGEK@ADBBCBACA@AJEDG@EAKDGCKKAADEEGFCACBE@GBC@UBKDCLCHBJJ^RF@JCDBFE@A@ELOAMAAC@MHGCAODE@KEODGJEDED@PPVDHFDFHBDBHAAEHILE@CAAI@@EFG@GJAFBFHDBNBDC@E@CGECEDCHABCKIMDCC@CNEDKHEAIGDICGBAFBFCBEHAJC@GCAQ@KAAEDCFABAAKIA@@FABA@IEIAE@GFUDIHIBCAFIBEEIGG@MFEB@HALGDALDHABABGDED@HFD@VEPDH@FA@CEIAIVQBCAECEOGEACCEIECECKACEAOGWBEDEFAFDFHDHDBNTJFH@FADEDGBYDUCEEYBCDE@SDEHCJARHRB"],["@@BAFC@AACA@@CC@C@@FGBAA@BC@CF@BJDBADD@BFBAABC@C"],["@@A@B@"],["@@FDBD@A@GGB"]],"encodeOffsets":[[[106678,29897]],[[106002,30575]],[[106650,30178]],[[106631,30106]]]},"properties":{"cp":[103.761263,29.582024],"name":"乐山市","childNum":4}},{"id":"511300","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@BA@@AB"],["@@A@FFCE"],["@@DABBBJBBD@DGT@FABG@W@AOJGBKGEACDAFJDADGDEEAG@EFI@EEII@ADBB@JGHEDNTDAF@BBBDFB"],["@@CJCHD@FCD@BHHBBD@LGFAFB@HCJ@HJBEHA@HBBHCFIJBDADMFCHADDJAJEF@JHHDNALCHBBD@NDFPFR@FA@CAIBCFO@MHIB@FFLAFTDHAJEFDH@FBFRFNABB@HGFGB@D@BDFNHNBFH@HBBFADCDE@MHCVDBDADDBDARF@MFGBAHFD@DEBEBK@@B@DLANAHIJKDEDBJBNHJBFDH@HDJDB@FJ@BDJ@FCDD@DFHGJ@BDDF@LCDHBJIJADFJBFELBFLFBFAHIPAF@LBDDFTALGPED@DBJRVNDA@C@QJGJO@CCCACHAVALYHGJGDKFCFBD@AKFGFAJDF@FADEDAFBHFD@D@BEICAAAEDEHC@AACCAGDEABEHADCKE@CB@L@@KBCNA@A@CCCBCN@BKLGB@DF@NBBHAZJ@BCBEBAFEDAFBDBBF@@JDBF@FADEJSDCNILEJ@FBBRRPDJCHMHABDNBB`AVHRJHBHCFOFAN@DHHDNGBDAFAHTFBHDFFBJ@`HHAPHH@FDFJFBN@TCT@HDBFABWJCB@BBD\\L`XJJ@DCF@FN@DB@DCHFJBJLHNDDDDB@FCJ@HIJDFEB@BFD@BMEEDE@FLDJAFJDBBCJDJDFFDBD@PFFF@CIHKDQDEH@JDJABCCCDABCLJPJPA\\NL@FABCAOCEGGAEBMFQJGPEDKDCDAD@PNJBLAJEH@DD@HHFD@HABEF@HIJBBB@FBFFB@HFVAFAPEFDBHBLFD@D@HMFCBBDHDCD@DDADDHPPTAHDDDBBBFJLADBH@DFDPCLDN@HADC@CCI@MJCD@DDF@LIACDGDM@ECGBCJGVJBADC@EBELKGEFCBCDOJMJGHKFEBC@AA@QBI@C@EGBGJE@GAEGGBICEAAEACDCDG@EDIAABAHE@CABIFI@EGGCGEA@EAAIAECAEBGDANCJGPEH@RKDCAADCAA@CAEBAJADABCAAAEDEH@@EDBFBBFDBBAAEJC@CPCFBFDD@HKLGDIEGBAJCBADS@CECAGFG@MAGGIBAJCAEFGLAHCHAF@LDB@DKFEBIBEHAJBJGLBJFBNDBRCDEDADDB@H@DEHCLGDGNEDEDKJCAGCGFGBCACGKDGJEHATBTK^IZHLB@NBDJ@@BEHBBNHDPHFBBBFCBKPAPGLBJLJBHFF@JBBHDBAFEJC@ADCLB@BBFNDHAFEBEIAKDC@A@@EJIDMD@JBD@BA@EDEHCJ@DJDDdJHABCDMDADFJAPDLCLFHBNEHHHCBDAJBBJIDI@GCAEEG@CCJWIIBED@D@JDJBBABEDEF@FDJDBDFDNFJBLHFABDBCDA@CBCGCBCAA@ACCG@AG@CCE@CFEAEDCH@D@FFF@BACEACBALCNKF@BWDGEE@ULGBEE@CABEACDIMAAEFGB@D@NHDADCJYJFHCDCAKDGDAPCDC@AIKUOEKJAHADE@KHEF@HHDBJOB@JBF@FGTCFC@AECACBALCHONO@KBCDCD@FELAHACUKGESGK@CDCJGBQDGJAJFNJFADCAAik@EDEDAJ@NOJE@CEG@CBCBEEOCG@WE@ABAHC@AIGKICCA@QEEDKCUBC@AZY@CCGECAEBKQM@GDECAGBC@@MHQ@AEICAKB_GCCEGCOACGECCI@OGU@WWSEMEGGCIMGFQGEEKEEAGGO@EBMKECMCCG@CCAAAGE@CBADF@ABEBACAAI@ABA@CMFABCICDE@EAKAAICKASLM@GDK@]CBEJKJI@ICCAEMESAIWAKIEIUO@KHQBOFGAEEGK@G^ULODKAMCCMEGMBEFGAQIG@A@GDA@EEDG@ACDE@AQKWFCAMGCEQEKLIBC@ACFE@EEQ@OHILKBEGOEQ@IAC[IOA[GCGJQBGC@SDKDIBIECGI@GDEBCDC@AC@GAAGCEBGCA@CLEHSJAJ@LKDAD@H@NCJHH@DMDKBKDCAEICEMGIQIKECSCKG@KGKE]CAQEQYACHMAQEAC@EFSBEAIGGQCCE@MLAFBDADCBGCGBMJEHCD@D@BNL@BWRK@CAAEOI@GAASAKFIAECCC@CLHD@@AEC@AFBHCBA@EC@ABABMCFK@CECK@AECAIBMJM^SDCFABGCCAIBADDLKPAA@EEG@KA@CBANABGCA@@JAJABC@AA@M@AC@C@ADGBA@EEEDCACCKJEBG@@A@AHCBCDG@KFID@DFB@HIB@BBAJDDFCLACCAIBCDAAABCAIBEIACRCBE@@CBECEKBG@AA@GHI@CQAKEGMUKWSE@GHGC@CBBD@EEBCB@BCDCD@DIFEBE@[VEDEAQGIKGKDIJEBC@GAGGG_CCE@IGGMBGAACAKGBCAA@IACGEEAAA@ABCAQIECEAEDOAGCOCCGCIAOFCBECCMCECBCFC@GEGB@ABAACK@ABCDBLEAEBK@CB@DDD@JE@IBIEC@@DBDHADFIHCBGCAACCBEE@@EECBCFA@IBCC@CCBECABEACECBAQHE@GAC@AJGDC@IKA@WFE@MSECED@DBPINAHGJGREBCAGBAANWCCC@EDKJIREFAACCDIA@AAEBGHEDCAACAGBEDGJEHKEACDE@IA@CFAMSG@KBAADGBEDCLEL@BCGGAAEBEGUFADC@AIEAE@GJMJ@BBBLFLH@DADDLCNGFECIAGFGBECCEEOMDIFEHAHBJDFDDHDNDFBDXFHHVLRBLCHIJGDIBMAABANCHGFG@C@CBENEFGPMLADAJDT@DGDMBIDABDLBFEFHLFLCHIRINBDFB@FABCAABALCDADJTEHBJ@DMDCD@dBDDFCDAH@FABG@CBEH@B@HDHFDJA@DKRCHCP@HBDHBBD@FJHFJBD@FCBQBCBCHDHBHAFULURMDAFHHAJGBIAE@@DFBJDCFCBIIC@EDDJ@BABM@CHENBBDDXBDB@DEDAPKJKTGDSAI@MDCFBLSLCHALADA@KEA@CFC@@CBGACICI@AEBEDCAAMAGDEJBHDB@NBHAFEDO@CBGFO^KJALK@E@ADBPCFGF@FTFDFBDNHZAZEJBHDDFABGDDHEJ@DHBPBFCJCHAF@DFDJNBLHBJLFBFCh@@HBDFEFMFADDBH@DBLPBHELMNAHFLBBB@BCAI@CBAF@HJDPADGBABAJ@JEJBBLDBFALGH@DFDEFGFAHEDCF@JCBCCCAEDAFABECIBCAOFCEC@EBCH@JFBBBADCFADBDD@D@D@LAJJKHICEBDHCJBPEH@LELEDCHBFHFFPLD@DIDSCKJUACBCD@HCHBH@DKRMHEFE@GBCFEDCBGACBGAIMEBCB@DBHCHBFJNBHDLJHDFAFGBABBNDBLCNHLBJH@HBDLD@BIBAEG@BDFHDFJFBNH@@FDJCFAF@N@FGBCCGBIRCDEBCAEIKIC@CDWEIDKMECAIAAMACDGNFNENA@IGA@KFAACCAMCCCFEBK@KNKEAABICCYJOJGBCBGNKLDDBBGBGFEDAD@BFHCHFD@LBBD@FMB@B@BDALBBFBFDFL@DGHG@ADGFGNCJCHCBECC@AJCBACIA@EGCEEWFCB@DE@AD@BHADFB@@@DDTNFHCNABGBBBFBFFCDEBDBARBB@DXFFJCHBBF@DB@BADBBJDFFREBDABBBABAA"]],"encodeOffsets":[[[108026,32309]],[[109515,32016]],[[108470,31226]],[[108026,32309]]]},"properties":{"cp":[106.082974,30.795281],"name":"南充市","childNum":4}},{"id":"511400","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@BGAGBAJEHHF@BGHGAAEGEAKI@EBCBALCJKJBRELBBANU@IAGFGBAJFHBTSNGN@JMH@TFHBBADEDAFE^C\\QDCCEC@QBACBAHKREHEZCFGDIFcACCGLMDAFAVBBABGJIBGBGDGIC@CNMLGLBD@AHDF@DBFNEJDFC@ELI@EBAPANFLADCBCACKEACD@JAB@@CGIEAOAACBKVSBEG@KDKBEACCEMBGDAPBBASQAE@CBAFC@AEEE]EC@ADADCF@HFFANELI@CGACIEKIGAGACAKCC@IBCJFB@BAAGB@TCDCDGAEAAIBCA@CNKHMJADMEMBCTEJI@CCGKG@EAGDKDCHA@AEGOCOWC@@CB@AOEKACBKFK@GCE@EEGRIPHJ@HCDCKKCIACE@EIECC@EBCEEAMDAAQ]GOAKDOCEUK@AAGCAG@KDICGBIEE@CDIBKXCDC@EAYMK@GKA@CDCBCACCA@GFCAAGKA@ECCCAC@CAEAGE@GZODGAGKGG@GBEDILGFI@CIIEAGIEAIGIAIECAIIGCGC@EDA@BG@EEGCOGEAABGCIGEGAKFSCABABFFABK@IF@B@DJB@DCBO@AD@BJF@DCBC@@BGBAD@HDFBDCHGDE@IEG@BMAAGBQAABDHAFGD@HCD@FFHDD@FEBCACIICG@ABBRFNBFCFCBGACBADEDMDSBE@GAAA@MCAC@GHOAEJOFEFABCPGJE@KDABDJABE@IDC@GEGBGRCDE@ADKLAFANGDCDGFABBFBBPBDDBNLRBDLBBB@RCBG@ECA@CBAVCDIDIBQACBEDECE@ABBLDBFBJNDDBRAJIF@F@DGAAEGAIF@DE@ADIFEAEEKAQFGAIMACIKKCIGC@C@IHMFCGEDCICCMEAC@CFCDGNI@A@EMAK@EBCFGBIEOAAC@EAKDGLKBCIAIIAMWIICGAAEBEBAN@BABICGKFEAAAEO@SEIEEU@KBQ@MFI@AAAOOEGGO@GBSCa[ICE@EBQEKAAAAKE@BCUJKREHQ@KPKFGADCBGEEM@IIG@ICEAEBAF@JBDFDCL@JGPKHEJGHADDHCLBHFDPEH@JFHATJBCHANID@@DCRJJNBB@BDAHDD@FEDIBABDNADM@EBCD@FBLJNAHIFADAFHH@FCBMCQFFJNDBDGLIHABKFBFDF@@GFSBEJDDADKD@DFF@BE@ECIBABBFABIBFN@NADSFIFEBWDAADIAAOGWAGDG@QK@EA@G@EBGDBBEDQHEAAANM@KEESKCAEFGE@AFCBEJ@AEBCDADA@CCEKCIIUBEGKBGDK@A@ADCDKAADBDCDGBCHI@ECEE@EDATA@AGE@ADCPCDIaE@DADBBEA@ACCABIC@ADED@@ABBD@DA@EF@@MC@GAEQ@CGGEGIBGAECIMC@ULG@k@OAMBAODEACBGAIBGGOHQHEBGEQCEEBABAH@HCFGACDG@AD@FABC@EEC@@JKPADBBFFHB@BEFOBEHC@IMIGGCKFI@CBACA@CBADGDaACIKBAAAKCIGEICKKAQDD@AMWLGDGCESIKMAI@SJQGGGIACBADENI@KAC@CJAHBFDEF@F\\FDC@AMC@AFELCDGDARFJJDTADGFAFBBDBH@FCDCCIFGBIFEBGH@HDHBDADGBGGDGAEC@CKIcOMCCMFUAAKCGQCEMAECGKSCCA@KACIAWFK@QKFIDKCGBKCCKCECACGUBCJONYDE@AIGEQEGAEDALCJ@LDXAJCEGQKK[IAGCQEM@IBMF]AkFWCEAGMCiGe@IKEQCO@SFKFONODK@EC@GAAEAIBUEOIE@YJEDCFOHMNEBQCGAWJOBICOOGMGIIGUKIMKMDMGDcDQ@YA\\KB[VWX]^GDQNGH@FBHPV`\\BDDNTXLRHH^RfNJFTPFLDJAlVz@NEVBLLDDBDCHGFALFNCNADCDAFHDL@lRD@HIVMFAVAJ@FBFFFJDNBBFB@@NBFCFMLCFI@CEIDEHAP@DAFEBEFC@OCC@EFGJ@HHVJFBHE\\BJLDJD@DCHKDAH@FAJKVQHALAJ@FDBFEHAJIJ@FDNCH@HTRFB@F@DIJCHEHPDHBDDJDALBFEDaLAHBFFBZLNDBJANM`KNGNShAJK^M\\cXKFGHKP@JDJX\\HDZJ|NPFVRDFJHX@DABEF@DF@JCF@HGLADBDD@PAN@JDBBHDR@DDBD@DAJDDDJDBDBBDIFID@DDBTDDFHPIHDDBHHBFVFNFJPRbZDBLBFBDFBJFJLJHABABCEI@APKF@RFZAFBDF@LHHHVH@FWDALFDAHIBABPHLFBFEHAJBHDLAFDX\\JDFFF@HMB@F@FDBD@LBDB@FADC@CEC@CLSBEDCJAH@FBHFDFDJ@DCLKJMFCDEL@DJDN@HGD@LDBKCKBAHEDCDGBODBZdNNFBHCBBBDDPJF\\LRVDFADA@MTCLTF`JFBDJHDTHHAD@JJJ@HD^C@ACECEDCJBFDPXFPB@DCJMJCRIF@BD@LELBJIJ@BBJFLHBnFNDRJCDAD@DDBA@BDID@JIF@LBBB@PE@@DHHBFAEAA@BAHAJ@DBJNHLJBHHF@JCF@BF@HSX@HFDN@DAFEJDFABTDDNBD@FCD@BB@DCNHJdTTJD@PER@`B`CDBNFZDDBDJDB@OFEHKBGDE@EFAVFH@PCBBBLDDA@JDBDAJGJ@DDFJDJDXEJ@@AKIAGNWBGVSTEFEFMNG@ECOBIDGNGDKLIJMFAP@RJD@FALHDADK@AD@^LD@DC@EDCHAHHD@FMFGHAHDB@FCAGDCNDDABAHMFCPCHADEBIHCRBJHPFXRBD@LB\\HHFNLJDFDJ@JLJDHFVAF@DFDHHHLF@D@DIFCFKFALHFBdKFCBGGIBK@KKM@C"],["@@B@@ACBB@"],["@@K@ABAHNDBBBAFCDEKC"],["@@BWAOECC@UH@NBB@BB@BB@BEFABbF"],["@@AC@BBB"]],"encodeOffsets":[[[106728,31011]],[[106735,31009]],[[105927,30843]],[[106019,30578]],[[106992,30571]]]},"properties":{"cp":[103.831788,30.048318],"name":"眉山市","childNum":5}},{"id":"511500","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@AD@VDHBBjTRBL@TFNNLDJ@PCDBFXDDXXNJLRRHBB@DAFEFGDC@QCID@HDDVDPA@DEDEHBDLF@HALOhGDE@MHADLBDF@JFDZDF@FAFFLDNBFFHTLJDRDFJFBF@FKLCNDLFDJDF@NGJBFBXNHNpTFALKLGHCNCJIJMRKJKbWFMDAL@FCTWPCFCJKFCFBNFRPDFALDHNFRAPFDBDHDDB@JIBALF@BIFEJAjABCDMBAB@BNNFAHCD@LDEZFFF@HCPCNGD@BHADFBJJD@EP@FEL@FFT`HNPVDVTTJAHIBEDC^UhAN@FFDP@FCjMDCFGPCDBJNLHDHBTCP@TAJFL@D@@FFHZDDNB@BCH@FFLAVDFDBBADDDFCLEHCFBBJABBGP@FHFANBFDFZT@BEHBLHFNFFF@FGPBDBP@BID@BJHNBJJLBFD@DEBOD@BFFADQNAF@LFTBTPNLDDBBBG`I@@@FHDBDALWJAFARMPQHEJCfJJDJHHJBLAJGJOLEPBPCFBFFBTAFIDAPBJAFBF@RKDCCCKC@EFCFBHDD@@ALCF@FBJCLAHBFJH@DEBCAABAAGEEHIVL@HGJ@BTBDAHAHJJ@BA@EFCBAFBDCDAH@LF^@HFFBFEDKZABDAFBBJDLCDCIKEYZITJHBHOBOFCNWZQFORSFKDEJCH@JDD@NEZWNCDBEDBDF@HHFA@BDDEB@BFHFAHBHD@D@@H@BDH@DBAHD@BFHABBF@@DCBABB@BBD@FBDAEHBBC@BFDABDABDDADDBBBD@LLR@DBBBAD@DHFFB\\ALEJIZCL@HBXLN@B@BCEAFCCA@AA@CECEA@DA@CDACC@ACAAAFCLCBOGMAICAG@CCBCHEBSFIFEDGFCEGAEFCD@EIIACGDIJED@RLH@DADG@IBGDIFGFAZDB@BM@GAAGACCKGCECACAE@CCCEBE@CCAEACE@GJS@GHE@AAKDMJGBCCCCAAC@GBAFAH@FATCFCHAJHFBFBDAFDLBDAF@BB@DFAJBJ@DBDDVGHEJCHGDDHBBFDDAFBBRADBBDB@FENAFBFFFAL@JLARBD`FFDDPBNCVBF@BHD@EBENGHFJCDHHFFEF@N@BDBJFADDHDNAFABK@KEG@CDK@KHSJELBLAH@FABMBCZIL@@AEEACBKF@@HFBHAHGJAFKNUDAXEBABGBAV@DBFD@CEKBGDCREHGNGNKHHD@XGVFFAHEDABHJBADRFDBBA@CDBD@BAACB@BBH@HB@CB@FDJIDCBGDCVCDKDALC@C@GBGTQNENAHBAO@EHE@C@EEC@AAI@AFAF@FAFG@EGACEAEBEBAJABACEA[BAN@FCAEME@A@ELK@EJE@KHMEEAABCJICG@ADCRCIMIGS@S[ECEBAC@EREHEDMAEBYAGGAKFIE@CJKFMCK@QEGIIKAK@BGACWOSMAC@ENkCY@IBCLIDG@AIC@CBALCBBDFBAPQ@IBAFCNAFC@AAEGCEKBIJ@FA@CAAIGBKDBFHDA@KDCF@HDJBBAJIDMJKG_CEAEFQKIQ_EAACGCEGCMIACEGHCBEAA@AE@IDEV@VHRBTAj@\\DREjBBCBAEUBAB@BDHBFA@MBAJAHCDCF@BHB@BCBEAOBAHBBAEEAGKCEEAE@ANKFMAAE@CECA@MC@EFECBEAC_@GAPETIDEBKLCBC@CGO@ENMXKLMBGAICI@KCIBMDCFADEKoB[DKBAJ@DCBCIQ@EHCFGDIGo@EBIDGNSDEBG@GCGAAGMEEE@GJMDEAEKECk@WE_@KEQACCIMCAQAAABIAEE@IIGBAGGAAAEGKWCEGCMMaEMCMEE@CFAFC@WEGCE@K@SHYBGFCFKHSBSHSECBAFEDK@GDCFBFEBSBGACCCMCEi]ICEEQEkAGCAE@OGa@IFOCGECQCEUWOCM@CFG@ASBIFEBAAMQEMECK@KECGBUR@F@JOBAECWASCOICEBI@OAECAYKOAKCMAIAM@IHEAEGEASBCBABK@OCA@ADC@GGCEaGEC@EGCOBODCHBB@HDD@HA@O@MEUC]KQIOCGAKBKCyiWMKGA@ABINOAGBMA[OEAKCIIGCI@EDCD@NOBCBBHCJ@FDD@BKJAHCCE@CLKLOFI@ECIMECKAEBEHCFIXKBAFC@OBUHADDDADG@]`UDEDCHEDKBIHOTMDMAGDKVIDCBFL@DWVCF@BBBJA@FEHKJCDCLSPEDEACDE@ID[FCHCBKBQJSN@DBFFBJFXD`@NHJAJENAXCNBPRDBL@FDHLCJBFDDAPDHZNPANFBFHDAPDBZAFBBFBNBF@DELGDAD@PFP@FEJBDXF@B@DCFGDKEOEK@IBSBIHC@GACHFJ@DKVAJBF^BBHDBVBL@NDFFHJDHCLDLRDDJCFQPKHCFDHFHBFCBUDIB]IQBEDBJIPOJADDLBFML@VENANCBOFIFO@IDEECCCAGBG@IGMMEKEIECGAIGO@SDEJGB@BPPJNEBUHEHBJI@ADCBCTGXGLAFBJJNBDCDQAEBGHEPBLHLLDFFARMZCR@FFHPLBF@DQ^ALBHLLBDEDKBULCH@LBNDHZNJBhIF@BDRLfCLFDJBLFLFDH@NGNANBDDBPBFHHBHDFBNNRZHF@`CPADBBBAJHV@NDFFB@DQLONQDOBIBYLaG[GSKS[GEKEMAEBEDADBR@DEDEDGBE@YEIBKL[lGFE@GEACDO@EEMCCME]DK@YGIASHMDEFEBQGSBUCO@OAGAGCIQCK@KACMKMEMBKFADCNCDMFIJCBIB]CEAyIIA_MQ@OEUAIEIGK@IBEBABADAZEHmRI@CCIMECGAO@KDOJCFCJH\\AJQ\\EBMBGAEEGIGS@EFS@E@CQSAcJY@IAEg]]MEEAE@CJGC[CGSKMACCWEQ@SEKEKGAUOYCGASGGIACBADERoZGBADFNBZBDRHDDLXHDFF@PAHMNIFOCGDSTEHCRGLIHWLI@GDKDOCECG@E@OG"],["@@CDBBBA@C"],["@@AABB"],["@@B@@ACA@BBB"]],"encodeOffsets":[[[106101,29284]],[[107757,29134]],[[107752,28774]],[[107753,28770]]]},"properties":{"cp":[104.630825,28.760189],"name":"宜宾市","childNum":4}},{"id":"511600","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@DCEBBB"],["@@BCF@BBCFLFRBMN@DLABDB@BING@CGCACBAAAIAAJE@EKI@FGACGCCDCJCBFF"],["@@AAC@GDIBCBADDFAFGBEG@DCBJHFAF@BCBBBCBAACNIDC@A"],["@@CAABDFBC@A"],["@@ACE@IHDFJID@"],["@@L@DADEQKA@CDB@@BEB@BA@BBCAABDDJD"],["@@BCMAAB@BNB"],["@@FAJIACAC@IGEBCHE@CA@I@CB@JBF@BGD@NBDADHD"],["@@BCDDDEKC@JB@"],["@@AA@BB@"],["@@DBABG@BBPBFEDALATTBF@DELERAJBDPFJFLCTMKIY_GMCQEOECCGcd"],["@@CBECFAHABBdcO]G]IWS_IMCIC@IIEMSYKIQSOKEISOKQUScYOQMICOAECC[KIDC@EAAEBIFA@GOOACBGEACBAHCBW@EAMW@CHCACCA@CBARM@A@AQQ@GAA_MG@EDCPGDC@C@IODIHIAEUAODEBADIXABQBGFEHIZQZEBCFCAEDBKOCCCUYKEBALC@MCCCAEIAICECAA@AJC@]KSCCACQG@CDGHC@MBIAABADABC@KEOAICIAADDH@BQFCDCFGDEJGBAAAGAA@EKG@ABCEAAEK@CAIFAECACBCACDE@C@@@CMAAIAKIIFC@C@IGC@CB@NCDEAIKE@]NSBCHGF@HCLDPBFAFYTUJEFADDVCXDL@NFL[@CDBH@B[EEB@DBN@RDNELJJ@DABGBGEE@EHDLCDMEGEE@@@@FJDAJCDQBEDPV@DK@MECCEBDJFBALEBAEC@EHCFHDEDBFFBDFFB@BEDCCCDC@FHEDBB@BCBAEC@AB@HMCADA@AACFBBDB@DXBBFNDBFDBTBBB@BIPETEBECCB@DDDAFABGA@REBAFEB@BC@@DC@BBC@ADM@CAABEAIBEDADBDA@AFCDWBEDWREBEAICCECEAUIDEDQCAHA@IC@CDGGBIAEC@A@CC@IBICAD@JIFC@IEEBCDCHEFADAACICCI@QFAACGE@GDDJJ@DDIB@BO@EBIKROAICAKLC@EAEEBCFEFIBGAAE@ODGA@BA@KGKBDEFADELBBCAGDCL@DCCMW@CABCEMQCEBGNEDEFEBIA@CHGFG@AAAEBAB@DABCCUFCCICBE@@K@CBAAOFEECGCAEDEA@CBGCGACIBIFKAABCHKFGDK@AADEACFCFI[KAA@EJWEA@CGDIC@IAAIA@LBJ@HGDGAA@AFEBI@@ADGGCADCCFG@MEAGFCAG@CABEFG@AGGAADG@AGEAB@JAFM@CD@DBDLFADD@BHELKNE@YQGAKDCBALCDIAIHRV@BADDDABA@KCODK@FNGB@PK@ED@DDBLHBBBHABDDAJBDABECC@@DBDHFKFFF@BK@@B@DD@B@BFCHDDEBGEAFHRECCDC@CCAA@BDDADGBB@DB@BIFEACECAABBFEDA@EEKHAA@EE@ABFDADCNOBAADEAEHCFIFCAICCI@ADDDA@E@AB@BBFAFABAAGBADE@AADCI@AABCEACJAAGHBBBAD@BDABG@AFCACB@@CAABG@ADF@BLBF@DCH@HADQCGQGAADEDDDBBABA@CCEBAA@CE@@BBD@BEFA@ABA@IJCBA@ECA@AHAHABIBCDALAHAFE@KEG@GBWHC@ALDHCBK@CD@BPFBB@DCBWEA@EH@DPBBDEHBLABC@ECGJAL@JOHC@CCBII@KRKHEJALFJFF\\CHFHZCJCFFDNTF@XEB@JLD@HCBID@HBF@RGABFDBDAFDBAFDDD@AD@JEBADFD@FF@AFDDBBFDFAJGCEGBAC@CD@JFJAF@@ICC@CDAL@FAFBAKDCBAL@BDAB@BHAHFD@DEDADFDNFDDAPEJBHDDDDPBHCPBFDFJFBRAD@BBBFBHFBD@JBBADLHDBBBAHHNJHF@DDH`HHHBD@FAJILCLHHJBRCFUF@\\AFEFCJC@CDADA@ADFFC@AA@DHDHGF@XTVLHNLFRB@DGJ@HBBH@LADFAF@DF@DADQJBAFBJADBBCBADBJDDKBEDCCBIAAA@GJA@CEC@EJ@LCHADGD@B@BH@FALIDDDBFCFFB@HABCD@D@@B@NBBD@BABI@IB@HDBABMDAB@@LFH@FBBLOCKBCJADBHDBADETCN]NIJADBBFL@FD@DELNDBABAD@@FABGDEA@BFD@BC@KG@DDDFDJBLETBBB@HPJBFDBL@XQ@AMK@A@CDCFGNIHAHDDABCACBENKF@DDHRJHFBTAFED@FBBRGNBDRZRFDBF^HL@LLHTDFDJLJRNHDFFJDBLCLANC@CGGDI@M@GBCLC@KBITIFGDKD@FDFAHDBB@HBDD@DCFAHCJ@DHJFlIB@AHIRDH\\HPB\\JBD@JFRHPAFKLGJ@PFR@FEF@BDBLALKRFDFNHDBXERL@BCFBDH@LCHMHCJDRARJXAJCL@DICE@EP[FADDHDTE@EGKDMJADERBNIJCFGNAFBPEFICSLDF@DCNETA@CGA@CBCBAHKFAHGDADAF@BBF@BCFCFADABBB@FFF@@BDABD@EDADBDAB@BBDAFE@CEA@CFC@AECBEDEHBBABBABB@DCAAF@DHB@NIDAACD@FCF@DCL@BEHBDFJDACHAL@HFLCOYMKOGG@QLKPIHM@KIAEFMPQF]FIHEZEBEFCBCFBF@B@@BDBLC@CBELEAGLADFFABFB@@DF@@DHDLILBBCDEDAHBVCJHHBL@LHLBHCHAB@FALDEYGIAEAKEGBQI]AQCCCAAC@aEOAEIEIAKAMBQFCABIACMECAACAEFOAODGJI@EACDCLFDFF@FAHBBBDNLNBBL@JFH@VKBACC@AHBDCLAXBNFF@PCBCFKEG@ADCDIN@MMBCPBHAB@JBNFDAAIDCHBHFBADEAGBCFAAEFCVAJ@B@@DABENOPIDSRWFQLAFBDJH@LHDH@BFF@FQJEJ@DD@FGBAB@FDBJC^EZUVCPIHDDNDBLFDDCLBJILABFBHAHBFMPIDE@ICE@CNEDCBICEKGUEU[IGCGOIMAAA@CHIHCPGJBFA@ICE@ERQX@FBJHHBF@NEBCAMECMCAC@GQAAC@ABCVCBGAKAAE@ECAAAEDCJC@GDAL@FCEEABBCAABAB@DEB@DCAWJACGI@IM@CREHBBDBAA@FABAA@DAB@CAD@BAAAB@TNLOFOOA@ABAAA"],["@@FBBCA@DIC@BAE@EFAFACCBDFFAB@"]],"encodeOffsets":[[[109607,31250]],[[109800,31110]],[[109853,31101]],[[109815,31079]],[[109846,31074]],[[109816,31077]],[[109835,31057]],[[108815,30935]],[[109545,30811]],[[109625,30762]],[[109830,31051]],[[109827,31053]],[[109801,31151]]]},"properties":{"cp":[106.633369,30.456398],"name":"广安市","childNum":13}},{"id":"511700","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@CAA@BDDA"],["@@TQECOEAAC\\F@BB"],["@@DKOAC@ABEFXF"],["@@BCEC@FDB"],["@@EB@BF@@@AAB@@A"],["@@D@@AEBB@"],["@@C@DB@A"],["@@AAA@DB"],["@@CB@BB@BC"],["@@A@CFA@ABBBADFCDI"],["@@H@BAECIBCBFDDA"],["@@QKQAEEIMECICSBQAQHKHIBGDG@GGCAcRC@KCUMKKEGEAI@C@@EDCbY@CEEEBAACB@AHCL@DA@EN@RMLM@IDELIFGBCAA@CFCDIFGPMFCTCBEAEBICKCEG@@A@AUMGCIBKDMLE@@AKAI@GCEBKLMFIDEAMIGCIAE@EDEAEEAEDGFCJAPGFK@SEEIGKCIAIIQCCCBAFAJOZMLCJC@CFAJK@C@AGEOIMO[VWFQLEHIFC@SQE@GBICCC@KCAC@EBMJE@CGDM@CCEI@ACLENKHAHIBGJSBGGcDEJGD@BDBAL@JCHGVYLODGFCJCBMPSVI\\CFAD@FDHBNC@A@A@@CGFEFI@QDERIlSHG`CDFPDLBHAHG@EAESWACFKHCHAL@JCFAVFAGBC@EDDB@^OLCHEHBLAFGN@ACKEGGe[ACBATGHE@IHSDOAEIAGCAEBCLG@CLC@GFCXIHOAAE@QJIGS@CACOEAKDCAEEBCKACACGAECCQCKBEAEEAC@UAECCC@EFIRIDQBAAOGSMEIBCEGOIOCIGKMEIAEBEHGBC_KTMB@DE@KEQAAGCGAgFKAGDAAC@AGME@ADE@KDCFCBEAKCGIGIBYMGBIFYEG@IBGDIBIK]BG@IGE@C@CFUJE@QABGECUKQAW@AACE@KBCHI@QL@FEDADBJHVEDEBSAEUQEEBGJM@_CCEIEKGEEAaCIAGGAKEEICEDGAECGIHGBGACBA`IJGBECG@AJGFEAGIOECYECCCKOGQOiSIAAEKAIEKIACKC@EBEEEWIC@KBK@MMgCICOGQE@ADCN@HI@CEOAIBEFCHBH@bLRHXHBABA@EEEMA@EBCF@PBBAJQFGBGI]CCIDQQCG@CH@BAEC]YACFIBECAEAOBGCIGEGDMGAEGCE@GIEGCGFIK@CFEDOHEHAFG@GDGACBOBEGEBEHA\\@LALILE@AAEKK@EKCGEIAGDMEGACECCEAAAGCQDAEAGGOCMKMCOIKKAK@MFYBOFCCAWGO@WAGDGBOCILA@GDAACBGHKL@FBVMHAVDHCJAFCAICAIAGCIG]OOI@CBIAE[QSGe]cWIGEMEGqcOOECUDMHQCIBGFWZGDKBIFK@MGEBGAEDC@AH@DCFABEBCBFFCB@DDDABEA@DFDCFC@AFBLDDDB@B@FFF@DCBCAGFCCARCDC@EDCD@FADkHEAQ[CAGBGDE@CA_cIGIMYYGOEEECQEG@EBIFMJAHBLCFQDKFIBOACAAEC@EHEHC@AAC@CBECADC@EDEEEAA@CDAAEBECQDCC@CE@@GCAC@EDBDABCHKLEBICCGQA_SE@BALGFBDABGEI@E@AL@GING@CCAMDGCBAF@F@BICAEDMGGACABK@AGA@IMAIBA@@CDCBCDCBEECAEGFIACBAFCBADCABOEKECAC@EBCF@DCKEAGA@O@GBCMDEHEBIHGBGb_LC@ABIAAACBCFBD@AACABC@GIID@BC@@BAN@DCFC@IJKXAVGNIFENEBICCMM]aCMEGCKCGMKGAMI@KCCGCAA@GOCCGUQIKMCAADEROJCBAEGMM[OKDGFCBGKCIMQMWMICIIECIKKEKIIGQGM@IAEKO@G@IGGDM@GCICE@M_eOMGCMIYRE@CASR@BCDMJBDCDA@ADE@EBIGDA@CFHHABECEBCDAJAFCD[@ABGWEABCEJGF@BDPBHS@CAESSKBGDIXOVGBG@AD@B@DC@AEBGGAAEGAQF@DJNJ@DHABG@ABDV@BHBBBEJJ@FLF@BIJBBBABBDHD@DMHAJA@ACKB@CNMQAKEDEAAA@EBEFK@CB@HIDCDBFBBFDF@BBBHAJVPFCADD@CJB@ABE@CHBBBB@LADMFE@GAIGEAW@QR@FDF@JEBIAOHGDGJ@DBBNBPJDHJHV\\VFLHDFAJCDMF@DDF@JCFOJENGAGBEABAJKAIDKCCKECACMGCOJUDYV]FIDCA@EBAHA@ECCI@IFERE@AEG@GC@KIGACBERKXETQJCPOFMBA@CA@I@UBEDBFEBADBHCFABGEGACDBJCBMEIAA@GBOAADNNM@CJCD@BFHELADODE@ME[AGBIJOHEDG@IEK@AAKMCMAAGAEBE@CEKECDBD@FIJCHBPEPBFBDDBNFBDAJDBRENALBJBJFBFFP@bBDDBDDBRJ^ARFHBLBFHJFZKCEBA@GBGDKAKGK@GAIGUDGACBCFADKAKJGC@CE@@CA@AEEBCEG@CB@BBFKFAF@DKDCA@AA@E@EAADEDAFYFEDEFGdQTCL@FPJL@JGLORKH@PHNLPZKDGEK@GBBDICCEG@ADK@CDE@EDC@BDCBMJA@CGC@A@BBCDA@BAAAABG@CDAFFD@BED@DFB@DEFCBAAA@CBCACB@FACCB@AE@EEA@AACBEBEDADE@AAE@CBCBGHGDEJCD@FHB@DSBMFCDE@KCDTEJOFEAMBEHIDMJQACFIBCNHL@FSFGCCCEBO\\@FDFCJK@IDWBQIOBKCC@CFGJEB@FCB@H@BJHBRGH@FBDFJNFFN@FCJKP[TAF@DLPJDPERALGP@JVJFBLJXTBNFBFDD@JIJILAF^DL@HCN@TKLBJDBBBL@FCFJDADEB@DDB@FBBBAJ@BBBDFABAC@ACFAHB@FBDDBH@DDDNLFAN@FHPBHFFFLHFERNHHNLHZHXXV@PHJ@LJDJBJFHDD`HLADBFJ@BGR@ND@HADBCF@HRNALBFFDDH@DYZ@BADDVCLFF@RDBJDHLDJB@BGBAF@@XDHFPAFAD@DFHF@HDDBFAHID@N^DBHCJLHDAHEL@BXNFJCLFLHBVOLCH@@DALDHMT@DDHJBLHF@DCFB@B@ZMHAHLNHNLDHGH@F\\DBHGHCDECE@AHCAGBCDCLABCBGHGAEBCD@JDD@FCNCVHFFADBDBBNBHDFDDFBN@NBJKJ@FPTFJDJHDBL@HDDLLDD@HDHBBDBLAPBL@LAPEJFHBLJDPCNHBJBFF@DEH@FBDFBFAHGJEFKLM@ANDLNDF@JR\\BVDHFDrCPDHDHLBNFP@JCN@FBDDBHAB@BBCDBBHBDDNGD@@F@DEFADHJFBFKHCDLNAHDDF@HB@BEBBHFLPFDNA@KDAD@F@DFDBCH@FD@DEF@BFHABDF@DFF@LCAJBDDB@LDHDDLBPODBHBFBBFPNTDTAHFFJC\\HNPJFJRFHZFFFDFFELFVANDDCDGBICECC@IPQJCD@^QJ@B@DDDAFCBCECACBNNDABCDAD@AFBDbHHCBI@AJADCDCFA@B@HGFADTJBFI^ABBL\\JNHFZBTLV@PPJHNAFEJ@JEDQBGBMNS@OLqTIBKHABBDFDF@FKD@@VFBHAFBIN@DDDLBJADA@MNC`\\DHAFEDSDIPULCFELCDNHLAJBNIL@IFCHAL@FDDDBNBJCDBDHDDD@RANJBHDDJH@F@FEFSLEFDD@HBBFDVBFHCFCD@BFDHDBDJCDBDDLBLJFAFDFBhMXBDFB@HCFGB@BFJ@FADC@CDD@DDDKBBFAHFADGDADBD@@DDDZLFFDHDBBAFBRDLJHDF@BBDABBBFFHBFN@HDLRRRCNIREFGFCHEBAAABABDFCDOB@Bg^KCCCEJQNADEB@DEFCBMLGBOCG@QFMEADGCCCADDD@@SE@BFDHHGBMHCDAFAHFPBFED@DBJFD@F@LCF@FDHNDZNVBLDFG@CBMF@LCBDCNKVHBDFLDFAFCDB@DGF@DCDAF@HIJ@F@FEDF@AFVRJNLF@FCHNJEHALFD@BAbAFBHFDJFJLHBP@PH\\HLBBC@KJKBIXWFKJUNWFEJCPQNaloFEP@DCAIBAF@NERQBEFDZ@TXDCF@DEFCJ@FEFAFIF@DCFBFALONKLKTQDIREJIPQFAXBJ@DDJHFPFHZTFFAJGBAB@BDFEHDFLL@DCHGDAFRJHHHBHIJAD@HDBFBDD@DELBDFFNJFD@JED@VHPENKNCN@LIJBHAHBHAHFHVHJHDRIJAFALSLAHDJFAJBH^PHJBJAJBBFBFAD@HFJB@B@FBBJFFHFBL@HCNKHMFEPEPGJ@DARKJMLCJELFPCH@D@HHFNFFFDFJDBlALFL@JLJBF@NCTMFCJNDBZFFCN@NCPHLBDBFJFBJGLKBCAKDERIRDJCDOFK@QDGAEKGAGBGDE"],["@@A@EBCC@ADABB@BB@AEHCUOCBQDAD@BBDRBBLDBNDDG"]],"encodeOffsets":[[[109608,31248]],[[109853,31101]],[[109852,31081]],[[109815,31079]],[[109812,31071]],[[109813,31070]],[[109815,31068]],[[109817,31067]],[[109829,31054]],[[109801,31101]],[[109827,31053]],[[111114,32975]],[[109801,31151]]]},"properties":{"cp":[107.502262,31.209484],"name":"达州市","childNum":13}},{"id":"511800","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@BG@IBIFKPYNMPGTSHK@ACY@EBAF@JBzZJ@DAFECQBE\\SHUFGJELCT@JGDMLKDEBIAUDWCIIMAE@UAC@EDGDGNGVFFA@CBOFGNKFEDKCSMaBELCLAVBAC@CDAHO@CEEIICMKMAGECAGEG@A@CG@AFCDQEIEEIOQIEACBCJGRGBC@ACGG@IBKHC@CACK@AHOCMIIFEAQFIBCESCIBCLCFCDG@Gu{UUKEEACDC@MUKCCCCG@GNOKcCMBEBEDCNAB[AMLMBG@ECI@COJCFEDCHBX@NFFFVdPRHPHDDAVUBAJHD@FCDEFEDMDIAMDGFCHANFFHBFAHFHFTHRVNv\\PAPBN@XEDCHMDMCSBCHA\\JLCHDNGPAFELADS@IAGGGBKGIIE@GHI@CCEEEAC@EDCREDEEOFI@CEMOG@EDCF@FCLQAGJIDGRGBMJEGCIAGBEFEAGK@MAAILCBKECBEXG@GUGG@ICGIAUBSGCBOL@BFLCDGBKIEIAICEEAKACAaYOQEIEMEUGAAGCCJGGOCESCCA@CJCJEACCACACICCBI@CACCCQ@GCAAICM@OBCA@EHK@GDE@ICEE@AFCBW@IGCEUQOE{MYIGCW[CI@ILOHGLEdWN[L]BITgHMLMFIJ]@IAEMCYKEAAEBGbKFCAEBKICCCGAOCFGDGJI@C@EEASQ@GDGCM@EJIBIFGAEECI@KBGBURILEBG@CBGLCDC@CIIK[AGFEAUIGGI@EH@FDD@PEDAFEFCBO@GBCFFJ@DEJKDENEDMA@@EAAACMEIEEEAI@UBEBUNGJC@kQK@GCBEDCBCDMEMBKHEDGACCCKKAFU@MUyBkCIEKSOIEeM]QGGKQSWCMAC_[OUAG@EHGRMHC^]XW\\ULA [ZBR@dCHCHKJIVKDKDM@EEGECCCGOKMAEBGFW@AGE@CVWNWLOCAGD[F[RMB_DMAICIGI]KIQYIkB[@GCEQICEGGWGSAo@QDCFCdBNALMHE@SLSAOKGCK@IE@CDK@EAEEEIEGKK]@MDILIHIDGM[CCEAOFG@OCCCICIAIDULkNI@WKGAIBMJEDMBMJAFDLFJ@DADE@CBCLINIJEDGAMCG@eOEEKMAG@KFKNI@AKUA@sBIAKGIG@ARG@UAEGCCEAMCEGCWAKICAGDC@MeT_GMEEAGBKN[BOEGCCOBECEGSmQUMAUOCKEQBIJ[VcBKCMUgQWEQEGCEQGKQGUCEGC_L[FeD}AKBURIJIJKRaZIDODgAGEO@KFGJELQrQdOVYXU^WjIHPX@DaRMBKDCFANBJVh@DUVCPGL@HLZFT@JMZKHKLKFIHCTBHAFMLYFO@KEOQMCW@M@GBEF@FDD|pNJ`NTNFTBNAFGDYbSXONeVKFcJE@OIIAMBEBEHw@MD[RIDIJINCFGhDNJbJJNJHJFlRf@HKHMB]HGFGRD`EVWzHBLBP@JELKJEJCF@LDF@ZA\\@lRN@TGFAVJJBNI^B`HBBHJXHV@DAFGPA@DClBJPDZADIBKEMFEF@JBDABQCI@IDM@EKMAEDIDG\\DH@CIPOHBld^PØªFRDTC`CFIJs^IJCJAHBXNhX¢FNNTh^VLCLKV@JDBNDJLLJJPBHALCLMVKFKDKJCN@VAPWAEBc\\@`SLOTEP@HHLJJFJATFVRTHDBDBFGPBD@DJJDHGX@PG\\ELQTILGP@RD\\ERE`E\\PVNNHBJ@FDBFGRB\\BJN\\T`X`N^JLRNLDDDRJ\\TPHLB`TFLNDrBJLhZBZAJIJENBRFNJlBLCLSZGNBPBLE@LAXF`FRP¤N`LLNJDDPNPHHHHjGNBHRLHHBJCXBFDHLJBHCFKFA@@BFF@DEXDHAHY^AJGJXLZ`ZDVBHBHFFHDPDFLFLF\\DPFJHJPZXHDZDFCtBlD\\@RHHFN~HZNPVNrDNA^@\\FTHfVLDH@H@ZKLCVHFDTFTCTMHI\\mDYCmQiBKYkKU@IBGPUDGXWZMT@dFhBR@RBnJPH"],"encodeOffsets":[[105465,31518]]},"properties":{"cp":[103.001033,29.987722],"name":"雅安市","childNum":1}},{"id":"511900","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@B@@CCDB@"],["@@@GNC@ACADIJABB@BABBBB@FEPDBDHJLCBDHAJ[P_FGNKZGPBRJXJH@LDFALDDBEBBB@DDB@DF@BADBB@BBDA@DD@ZLJ@PIHANB^ANJLFDARQLGJCF@JBDAHWNKHKBKCI@GL]JGBC@GBCFCNEIKIEECAE@ABEBa@AECBKFGMIDG@EKEIMUQBEE@FC@E@EJI@GBEDC@CHE@CCAEDEBKCCEGALUDMACKDE@AN@DEHKCUAYMMCCG@EDE@K@EECAI@CFCAEEOBGBEDCNGHAGGEC@ATF@@CCBCDDHDBCNFREH@PDHANKDAFE@CFABCRMFIDDLDh]@APADCCEBABABBFADGHEFEJQDMQQKQGCM@AEEGAEAACBAAE@GCKIQCEAABCACGEEYKCC@CC@CACBCHEBBGAELACC@CCC@DCDEBI@AEA@EHGDA@CEWAgNEAECEBKIKACCCAIDACGCEC@ADCDEEGUAECAA@GCCFETKFE@E@EIGCCAGMIQBC@CCCGCAIDMACACC@EBKDGJEK@MJIAKBMGDCFKDEVKJOTCFCBECG_[MD@NCBIBKACC@CJMEAGBEA@UC@ELE@ECACBALGJArSPKT@NMHARAFC@IFIBEGMOI@OKUASEYMG[IAKBAJ]AESIBCHE@G@AEBCDCDIB@BAJGDaGACBEC@CBADCBMMDADBDFDABECC@C@ARI@]DCRIJOD@FDJDHADCCCBMEUFKEEECEEGYQEEIOIGMD[EIGESBSCOMAEEAGACAOPKACCCG@KCAACBIKDE@CEE@ACGBAEE@CFC@@EDGCACEE@C@CB@LMBECKOGEAAAFA@@GCEGCMBCKGDELEAGIBCFE@C@EC@MHCCGAAADCAAA@GBCAAC@EDM@IEOAMGKGCOCqDECCGAUQ[@ICEKMMC@BKNELIFGHEBEAAC@EFG@CEEIAGADMCOKIGAIEOFKBK@OAKBCAAACG@GCCKKCC@GAKGCCIEIOS@ELIAI@MAMCEECGCMAAAACBCAAUIG@OFC@ICC@ADBFGHAHADKBCDADBHGD@BDFCFGDGHA@AAE[G@GHGACAGMKMBGNG@Y@AEACDE@GECAIAACAGNSCGBK@CG@KDUPEAAAEIBGBAEKWM@AFKBGGCIKGDCAM]C@GJEBCAGCE@@DIFMPI@DJGECDADJLbbBBABEDA@SMCAIBCHARIHCD@DHLFTLHDVGBKBEFC@CDAD@LMPGPKDABBDFD@BEDSDEHE@IAA@IPCAGGE@GF@LCFGBIBFLVPJL@BCDODCBCHBLCDGDIEIZCDCBMGC@A@EHBFNBCJBDAFDBF@AFKH@VFFCHAXE@MLKDABBDDFABE@EEC@G@CDBFEF@DDF@DBHJBDFABBBFDAD@DCB@DCCEBKGIAMEECACICECE@CFAFABIAICC@C@AFJJIXDDH@FFDB@HCJIJAABIACGDGGMFGAKEKDOCIBCECBCNADGBcICCCII@GDCF@FABC@IAC@CNIJ@FB@D@LCJBAFEFGBMCAE@AKACD@BIDEFABGCAA@IEEAGKIAIHKBOLODA@ACEGECOMGAAFG@AI@AC@MKAYG]JSLSAGBIFCHHLBDADEHDHBFADGBCLCFMFCHKHGDCFG@A@CCCBCFQDCAAMIEKAIHIAGBAFAJEFCLA@KCE@GBGDKBEHBFIDABHJBH@NEHBHFD@DCTABIDABFHCJKHGLC@ECEAOD@DIDBFABCAAEEACA@FG@CFBFBBADCBIBABBF@DBBCDBBCDQLG@OFIHMDCBAHBFFDJBBB@FFBDHHH@FEJAJDBF@BGBAJBFCH@DCDCFBBBDFAJHHBF@HIFAHFHD@J@RAB@@BADEFGLIHGJADCPADEDHFKLAF@FCDH@NFBD@TFLNPADGFCDELARFREVFLHDNFHJAFABU@CBCH@DBBVDLHDHBVPRFDLPBDDDDBLBHIH@FHCRIP[^AFJBHEJAHBFFD@HAJEJABBFLAHLRFLBLFDRC@DDLBVCDGB@LAFBNAJ@BD@HAP@JBCHED@D@FDLBDLFPTF@VIFALDJH@DCHQDEBKJEDAFBLDHHBVBBPNLNF@DIzDRADMLADHVATHrDJNH`HTFPBxJLDV@`FNRH`LCFHD@BEBA@CCABABAHBHERFJCNDDDBZEDC@CDJRHALBHCRAPEJEDABBAHBBJBDDBDV@DDCJEFEBEBGBAD@FBHDA@DDBBDG@GCAIAAAA@FABEB@DMHEEAAC@@@DCECEB@FCBBB@BC@DHOXOJQJE@WGEBEH@FDHJJBFCHEFBR@LBJAJBFAFDHE@@@BFFB@FBDCFDBCBABEAKBADB@AFDFBJEB@DANDLDHDBBDCJEHMJADADFTCDEFSJMLGBGL@DRV@F@DGHBT@PFPGH@F@FHL@FG`CJAXBBHHDFBJCRQPGNCJ@XCT@^ARJDPAVFNHJLJHHJXHVPHHJFHDPBDHHJRELAlBVBHC@EGKDS@EAE@CDMACFEBAFDBF@BDH@JDBHALBRAJCBCFAHADBJJL@HDDDFLDBNDVBNBJGH@JCPFDBNCBA@MRSFAD@HFLBZBJDFJBBJ@H@NBlKF@FJHDbFJCN@FAFKFAHAHDH@LCNDLAHEEKAMESBQHIHCHAHBVEJKNW@KAEAO@KReDOSy@IEQEMQMEEDC@IFKFEHAHEDEHAFChFA\\GBARB@ABCHBNCFFJAHCJALEJEDIHEHIVoJKLITIZI\\MNCLHBLAHDHHFPVDV@TDFXLB`DFXPnPjRPTDF@DHHJPDLJD\\@TALCJCLA\\I@EAIDMCGGICIDEFOCQBGBAFBDACCBE@EBGD@HG@DCB@BN@@C@CPEFIBECIDCBEG@AICCICAC"],["@@K@AOEGMNCJDDBBBA@BDFBHFBFEF@BC@E@ADC"]],"encodeOffsets":[[[109514,32016]],[[110029,33209]],[[108981,32690]]]},"properties":{"cp":[106.753669,31.858809],"name":"巴中市","childNum":3}},{"id":"512000","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@NT@HCLBHTTFJPPBRAPBDNDDBBLANBFLLHBN@HB@DCHBBTVVd@DQDMCEAEBCFBDFFVH@DIHADBFFFLFTDHB\\TDF@FBBJADGHATOZBHBDDGLFJ@BADM@ABBJDDJCJILWFQACGE@EBAPBHDPADBFJBBN@bGDBHFBLCNBD`PFFBHAFCBI@GDEFCH@FFDBdJRIPAPBHDJBHJJLDZCDAHEDAVFHGB@R@^LHAHCNDFABD@HBBLEF@BB@HPJHLF@F@JDCFDB@BEFDABDJABBEBAB@HDAJ@@AC@@@BCFA@BDDDCFBDDED@BFFBEDBZIFABBBFBNBDNHD@@ABGLQD@PFD@HELOFADAAC@@B@DB@CHABBADBBJABAFAAC@CD@DB@DD@DDBCDDFEB@BCHB@CFAFAF@AEBA@AFBBDFA@FD@B@BAD@@A@ABCFFB@B@D@AABA@A@ADDD@@CD@DC@ARCJEH@BCAEKQAAMGAICWBIFELEXGPGVEFAFKBKDCAWNCXERGAEFCAEL@@ACCAALABACCGEAAFCR@FBBDB@JHDCDBFABBDAFBD@BBDADDF@B@@DAJALDDJFP@PBPBRELG\\LVABJDBHBALPXBHDF@V@DGFC@GCEGEBADBFAHGDADEDCFAPA@CFED@BFBBFARGP@NBBNCBBHH@BAFD@HAFBBDCPDFD@DCDOD]DEDBDBCLBHBBJBLABDHDDLDBDBDCDAJFFGHCBACAFCEICADADDBACSBALCB@BDAF@HBBPBHFDBBA@GEEBAB@NFBA@EBCBIPS@AGGACACDMEG@CPWHSR_DAT@VEND@HDBJCF@FDBNGJ@FLDBCJ@DFB@TEJUDEJAFBJFDC@CCGCAACGBACBAFCDEAEDE@EJC@CHEDKF@DDDCBCAGAEKK@ARaHEBCAI@EFG@CCEIBGGG@GDIMBEJEF@JEHBHC@ABMCAAECAKBAC@@@CCCEEACRAFCJDDED@C@EEF@BBAAB@@ADADDBCDACGBABA@ABAACDCH@FA@QBGLSJE@K@CBEJELFNE\\@DA@AK@AEHEBEJMHELEJCFFB@JGNERAFGBAHAZDDADO@SJIJEBAHDEHBDBBDAJIH@BCN@DBHA@DFBDJL@FBD@FEHAH@DFLCBDAH@DLAJHL@FBBBDFDBV@@DAHH@FFHGJACMDCRJBD@DLBAEDIACRSAAA@@CGAB@F@BC@@DC@CDCHDNCJLJ@LDDDJFFBDHDBHIJA@ECEAGDAJBDACGGCDCBIFKHCFBF@DFBJFBHCAE@E@EFGDBF@FDH@NGJAFEBING@CBCBEAG@INODANFFIH@FELEPIFFDH@HDJDBDBF@NMNADIDCDGD@FBBADIAAE@EE@ABIIOE@@DA@GOIKCEBMCABAACBAHCFDDADBBFBA@EEE@AREB@BDBJJDDFFBFHJ@FCFFD@FCHBFEF@BCCOCGSECEAAOACAACJECKHAH@FAFCJMNKH@JBDALAJGF@FDD@FCAAHCJBHA@EIIDM@SBEFALDFAFIJEHBLHDBFAFKAQFCFAB@HS@IHFJCHHB@BIHEB@LBNLD@HIBGBIDCH@NLNDBC@CAAEEPIACFCCC@GAAI@DEBCAC@CC@A@BBCACBCECB@AACI@AE@ABB@CE@@GAEGEAQBADADKBADSCAGIIABCGGBCACDA@CECCA@GEACACBGEACVUACF@BKCCE@ACBCFCDEBAD@BAR@HBLECCAAC@CAHGCCBCAIBEACACBCFCBAECG@ICE@GC@GBE@AGCEECA@CEAGDADC@ECEBGFCLK@CBGBOGAABCAEG@GGCBADEBGEOAEGUFIBGD@D@BEBCEEEAEEA@EDGCACBCCFEBCACIGMDMFADAAACEAAADGAC@IAGE[FEF@BE]]CG@CBEJGCKBKCCMAECDACC@CDEBCBCCIA@GDEBGHINIGCC@KLCDA@AQICIE@MIFKLG@EMAGCCDEHCHADkNIPCDE@MCGGEEEK@EFMFAD@BA@EAIFMECECMBICQDMCKDOBOJGL@B@BMN@DFL@DABIABLDFCHBDEBCHWTEJGNLVDNHp@FEHEBIBUA@RABGFCTIPIFGHCBA@EKGIAIDMGEKCEBEDKBILKJE@OCKBK@EACGGEAEBOCGKBWGYFKCKNIBO@@LHFBDCNAFIDADBFBDKLQLE@WEQ@]DCDCBOG[EUOEAEBKCK@CHCFSB_RILIRABAFCFFBAH@FCDCJDDD@NQH@HBDLEPBBBHAHCJMNMFgP@LJNJDBJ@DEBQESDGHGVOHMNEHGDMFG@I@SCIBOJSXKDcECEBCD@AEA@ABG@CBEC@CH@BCKEACIDCAFMAAEBCA@EFIACEAMFICBCF@BAFSSEKDCEEACABEHECAGABEAGDAN@BBFRAFLBLCDA@CKKAKECQCQGAGHEGMCAIDEKEACBCDBDPFFD@BCBQ@ABBJEBCAMOGCCCCAACBCHGBI@EC@GD@BFD@DA@KCMBEBEFOEAGGBKE@ABEJKDGLGAAYDCDAFEDEACCG@ICEACBDH@DABEACGKCAA@AZYHC@AEGEAUBCBADBPAFA@AACGCACBAJLJ@JFAFJLD@DKFEA@@@DKBC@CCKAC@@DBFLB@DABE@IBA@BHCBKHFLADOBKCCDBPGLAP@DE@CCGACEQA@ABCAAMDCFCHFFLDR@HBBDBDADKLEBIBMAGFIAMLGAICGDBHGHC@EAAADOECIQDIDAJ@NEJFVBDABEDCAEECKISECGDGCOAEGBEFCGE@ADADBHGNOFADBBFBNH@DEDEFEEE@CHHFALMNELGBG@GGCIIGCGIAGDO@C@CKGEEBKVEDCFABO@ACEFA@CACKMC@CDCBEQBABDFAH@FAHFBBFBBDA@CB@BDD@@BDBDFEDBDDB@BIFBDFABJEFDDCD@HC@BHEBBCC@@H@FMBUJCBCLKEGKEACBCHCLILFL@DADEFGAEBCLAFMFKCEG@EHKCCcB[FBLCDBDMAEBCB@FFNDDJBHALCH@AFUTALBDPBFBHJ@DA@IBC@BDLFBDADCDKBMEOBAB@FKJ@FEDICMFAE@CCEBGC@KAKHMN@DJDCHAHAHIJAHABUAEBCBKNDHBDEdCJEHYDGFQFGLABBDRAD@DFCD[R]DEFCBCFABGASEG@INM@MHSTGAIEABEHBH@JMVABKAQFIAILKDCF@FLJFBHHADEFAHE@GGEDED@DPFABMD@DLN@LALHJAHEDcLEAKGEBELEDCJC@"],["@@@@@@"],["@@AABB"],["@@CA@B@AAB@BAAFDBC"],["@@@@@@"],["@@A@BAMEBDAHNC"],["@@DCQIA@JPFA"],["@@ABCAA@DFFCAA"],["@@D@BCAEC@A@BJ"]],"encodeOffsets":[[[106693,31058]],[[107596,31173]],[[107603,31143]],[[107620,31126]],[[107624,31115]],[[106735,31009]],[[108093,30911]],[[108117,30851]],[[107424,30623]]]},"properties":{"cp":[104.641917,30.122211],"name":"资阳市","childNum":9}},{"id":"513200","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@A@CBCBIAGFA@YIIE_IGCKI@ICMEGKCGCO@MES@IAAICCKKSMEIIIGKKEQEMFI@SEECEEAAKDQ@GHGBA@GKIE]CMBCACCAOFSAI@GH[JMAEQ[AYJGPWAYGcLOBcACOQKGGAE]IMBEACCCECIMCOEMOUEACOGE@IFKACGGGIBWAGEKGEGKIQBERGFGBUFS@MAIEGCOBOFE@@AEC@QACAEKo[[QQUCMBiCKCKOOGAMIKBC@_]UC_@IESIKEOASWGMGOOBQM_QE@OFCNEJIJG@KAKDIFKRE@ECGCMBMCIAODKAGBGBSNIBSCIDG@GCKEQ_MIIGIACEGWKMIEEBABMFYNMFSLKBM@OIOKCA_@iSOACAAIGGKCWImIQAQ@gAcEMAMFQJWXCHOVAH@JLVZlALRjDnCZ[nGJSNSDSEECUGKDYLO@KCKEYOSG[E]@MBqCUMMOGYM}GEQG[@kCsAEDYCGCYWIOIGOE[CKEKECECOEGGEGAUAYCY_]QCEDMTcAaF[@UAICECAW@IIECEAEBqZODWRWNK@]GKAOBMAEC][KACAGQEEC@QDEGCAGBE@AIAEi]EKDYCAMAQSQCIFSFGF@NEDOFG@GKaMOC@[ECASCKCCCBIHQRGDSBGDWXc\\Sh_RoDE@]MEP@DBDRPBF@PCNCFYJ@F^vF@`GBB@FEJu`GFAHDRLNPNLFJHDL@jBRExCTBLFF^\\JFLFhJrBL@ND\\BD@JKJ@JBJDRNNHBFAJSZCHAFBJJP@FAHU\\Gb]R@LBVCH@PDHFDBDIRALIHABDDL@FD@DEJFHCNCfBHNHBDBJABINAFBN@DGFGTABGDEAMI[IY]KEKCSOQMSWcQKAGAODCEEAC@GHCNIN@JGVG`CJ@HCJ@NAHCDGBEHIDSBIDEFQfY@IGsKCCC@GKAMSOGDSNKFMDABAfGVMLMFCDGRBJJXAFKHAB@FDDDHABINAHDNBJKPGDG@GHGDaFI@KAMCOGIAU@SDIH@FCPBDHDBFBNCDC@IAIGQEOCeQKACHAbAHADSFAFADIDABAVK`ADSHeVCDEPABUDKCIJMEOBGA[S@C@IMIKOKGCIEEA@CBMRDJBHAFAHcX]CGCQBGIQDoGCECEGQKGCCEFQCO@@AJIN@NCFSCEG@EIKCIM@EBCRFDBBCAIGGIQEAIDEPGH@^GJ@LMX@BHTELCHDJDFRHDFNXF@HCDBH\\HN@JELGHCBAHAFAB_HKFAAEEQ@E@ECEG@GFIAECKAMEQGAWDEAIGSMCGQECIGGQAMCG@AB@D@VADEBE@SKEIMGCE@IACAAGAIHIPKJY@KHC@OABJ@DUNAFAHFh^tBjEPMpSbCHGJIFMNKHIKCEAKCKEIECEAG@G@KFE@MEGAUGEQGSMMSMCC@CDILAHBLABWFOFGVIRETHL@JCLILGFAF@NDTJHRH@BY\\IBEDGZBFHHNTBH@DULKBU@QHCDENKLzCFEZ@PFNAFCFEDQDETGNYZA@E@GAOM[IKA@KJMXAH@LDLJTDLJHJBPENJJJVFTJHAplJVNP@LAHBHBDlLbAF@DDFHBJBJANBVADSRAF@NBHFP^THHBJCRGLURCFADCDKBECOFGAG@EAADAJIDC@iGgM[MKCU@EAMQG@aLEJMHAFOBCLCJCDMBKJEBEAGECA_\\GHBFJPHdJT@F@BGBOEC@ENMRSHADC`ABM@SREBWFEBO`EHQHSRM^ALDDHHHDJBXEJBJDHLADSZABIAODWDSAA@CDQ`M^CDABM@EBIFSPGBKMQAMBEJEDE@KCCBQTOZ@LDFLJ@HILIAGBADMIEAEAMJCFDD@HGJ@BHDBDANIDGJED@DADEFGBAJCB@DBDCHDJABIL@BLVJFBDADIHCJ@JBLLT\\`VTdLP@LBBDFPJHHFRBFFDPTbHFBD@FADIDMVAFBJBDTJxNHDHHBFABB@@DUh@JFPCZDV@JCZF`DJFHFFN@RIJC\\SHAJBDDFHBJ@NCLGVEJ]\\SPAD@DFDJ@TIP@LGTMZIRCNIJHDJDDHFDBBCB]BGFEFCF@HBRPDHFFB@FAHKJCNDDAHCD@THD@RGDGVEFED@JBF@JEXADADADQJKLCPFF@LKJQFCD@DBJFhbNHF@JCFBTFR@JBNPVP`dXN`TTHRDDE@ELIDAHDBEBCHDDHD@BC@GBCND@BCDBBFBDADMCAAICG@GBKDGAIHEJC@DDDEFAD@VFFHHJDH@f@JBLHJPPNHDH@LJV\\HLZXLPJ|AREPBDBFNLBD@DILAFHVDJH\\@FCDQJIH@HD\\EJKHUFCDMRQJQTCBODKHMFmDSJ@DBFHNFJ@HEJ@BJXBHAFGLFPGbBJJ@RGPB\\Eh@DDQVBHKNALBJFLNHARFJEFADU@BLSJA@IAGDGAEDDDDVIT@FBDHHFHFBJCD@FFJBBJAJALEJADQHCDCJ@DJJ@FFHAHEFU@DHGFBJOBIJ@JAFNLBJIDWC@FCFEFBDLLAFLREF@FFFRDJHHBDHP@DD@DCHEDFFFBL@JADBDDAFBDCFBFDDJDJJD@H@NCPDBE@KDEAEB@HBJADBBHJTJDDEJCVIJ@FDJALHBCD@FBFDB@FETALEJBDEFCLSDERCJ@HGBEAECCDA@KBAH@FEHGBKFEDGBCJCDGHC@C@KDINONADAFQFMDCBAVJClBHFHGVBHAFIF@BJHJPJJHBb@DBHFHBHATGPAVBREF@THD@FCJIPYRGDGBMDCFAJ@DCBEBIBAH@HANEFITEDCDILK\\ORWLILGFKNCFKTKDKHAFBDBBJHJRRBJDHJHJDAL@PK\\TDHFPJTRDHCHIT@FVJLDNJN@B@BHNJDPLVBNCJBFBBJDFHHHBFIVEFSJMBABAHIHEB_@SAE@QPEBMHIJIN@JDTDHDXFPDHDdBFJDJJBJDHHHNVLPDPDJHDRDLDNAHBDFDBDAFBJABAD@BADBD@DDD@DBLADDJBDDD@@CBB@BD@@DBBD@@A@DGBED@RDVFPDPAl@JFHBJAF@HADEFI@@JBDHDTTHCT@DBDAHMLCDFRHTD@HFLADEHDHCHBFFJBLJFDDDJLINOJCRIXEDCBCEOBEHEVEJKBGFM@EESIMAIBGLKGQ@KDKHKDELCVEFEBGAIGUBEJGbCAEACMAGGGDG@IGKKFKG[ECE@ECAICCKCKIIKGS@M@KMU@GBKEWBEHIAIQEQBCAMWWMMCCCAOKUUZGJBIAAGE]@KOUEG@CKFCBE@ECKBCHGVSBEDC@EFHNFFEXSbKBC@IDGDKFGHIBGG]DQ@ACE@QACCKCEKEIAACHYVGLI`EHGHADBBBJHFHDHBLDFHRLFLHDHDBH@NBJFJHP\\HXBJDFVANHDEF@fPHHNDRC\\MXC@\\FPJDA@CBAD@DBBB@F@DAF@BDBFAB@AH@BF@BBCF@BLDBBADKB@DDDABEB@BZL@DCFFBCD@HED@BLJ@HJBDDADGAABBBD@DB@BEDBHE@ADDBABG@ABDDHB@BAD@BRJ@BGDBHEDBFDEB@JB@EE@@CA@@ALEAGLCDCFCJCLADAJ@@EFEJQAGBCTYZML@D@DEP@DAFGFEF@DDH@NRAJAHFLIbBJCPCHDNCFEDAFEJ@XFNC@MFEF@DGB@AEA@LDBFH\\PVFHFFLBHJJFPFVDFBBRFPHJ@DBEP@LBFDHDBFAROHAJBRJH@JEHIHMHCR@LBJDPRNBFCFKJINEHAFDBF@FKPFHHBH@JIDGRADBBBDRHDBNDDNDTRZFFJFLDHLBRCLEJBBD@HMFMDEDAD@DFFHDJALIHMDANCDBBDCHaVWT@JDJLPBFADELMJCFGT@BFFFBJ@TKJ@FBFFBJ@JCFED[JEBCDK\\GHIDgDSFGDYVGDGJSH_AUFKDIJAD@TCTERajELFN@LNX@HJTJNPPBHAFKNKBGAIEGOKOEEIGC@GFWJALBNDFPLFB^BNFFDDRCFONMPCHBDMJYFQ@OB]AYBIDEHADDHNNXRLPBLAdObSNSDCBEJQROZIHCFKFGJIFGLIFANIFMLEBKBCD@DEBINQHEDCDAHFLNJ^HLFD@JGHBDA@GCCGEBCB@FBFDBD@JBBJAV@B@@AGA@CNMVB@EGCACBALCDDBDEJABDBB@LIBA\\@DB@DSBABBDB@LCDBHFBFCNBDLFHEFIACCCGA@ANMF@F@BDGJ@FLTDFRFFCTWBAFBDBBHDADBFDFFBJFDPABCFIJA@CACQFCAEWDIBABBBDEF@BBBT@FPDDD@FEBAACGC@CRBHIDAF@DFBFBDHDF@BADKLCFBFF@FDBDABEH@FCJ@FADDBhHPDdLTBLHFJFDFDLHPJbLNHPB@JCTCDABIBAHDLIHAHBLFZDZHJHLB^AdDLFD@RCHRJBVDn@PAPMJEH@LGLALKPDFHIzMJORIFE@]JgTAFTZJDZJJBTADDRG@@@FGVFDLBD@BDBJDFHBPCBFD@H@JFTDNCCLAN@BFDRBFDFJRNDLFHDBAPADBDRDDBDAJ@HPFDDJTD@NDNCJAH@PDREd@BLNNALDH@BABGFABBDDFTFNJN@PBZADBF@\\MRELETQHIBGD[DCHGFCXQDEBOIgCaDKDAFBDGTM\\GN@TFJ@REHBVRD@NCDCVK^A\\CRIXSHKAWDIBSFGHAAAKGGIAOBCZUHFJBLA\\Y`U@ACCEOGEkEeHCKCOAEGEEUBCHATJRAJADE@MFSDEHGDGEOAC[SCQCEECQCEEE_@GFMLOJGTALBR@LAHCFEPcDKGYIMCKGYAGBE@EGMCQMe@KHGJERC^AbOZAX@B@BHHHNJHFLHNCN@DANCNELGDM@MACGCACCI@GPCFE\\KTMHAFE\\IbGJ@dFR@JBhAJALB`HDDNXFVJHHHJXNPRHZDjDRCFANOHODUFEDEJOICBW@AK@BENKF@PECSCI@MGIEIQSEMBGMOAEB@XEDEDA`@NdBLHJBBJDP@FBBLBDNHHBEVBBLDFA@AASRCHERDCRDDJBLED@@CGMAEBCF@FCB@BD@HDBB@FMF@FHALHFB@FKB@F@NHBAAEFEACQEIIIC@G@AB@FFDBHCFDH@@MCA@AFIB@LF@FFBBAJIBAF@DD@D@HD@RGBANCLGJER@LEFEJAJEPADAFMVER@RFJDRNPFdDNT@VCXATA^BR@OLA\\@JFH@bLPHRDjBH@LALERAZIrYlgFCFGj[ZSDAFEFMHGBECU@CFAFCBEAAACSECCAYKGIKAG@EHKBC@IHQJMDIDMBGH]BGDKPYNKNCPEFEJOBKFGGK@CFS@MDCH@HCXLHBFALEHKFENAFCBMAAFOFGL[RmFGJAF@TDTAJBzRXFL@VEVGXKHATINBTI@ASDGAKA]MKAGEFC@EDA@OTMD@FCDGCEGBIFSTOFWDs@GHQTEBGBEAWOKCIAACFEFE@GAETMFMFMAOJIBE@OBQCCBUH_DKVgJ[BUJOJU\\iFU@CaOCQBEBAFBHAFC@CKAEEEGAKMOGG@CMEEECE@IDEPKJCTCTBTHXDVEVGRIJKBGAEIEUEGAOI_IGOBeAUAGOOGCkGOLKDIBKEC@MDKHE@CAIEAGAAK@CCC[@QIWCICGBMSE@A@GIACAKBMIEFEBABIPSJGBEBCJBHAFQNCFE@OCEBCDGPGJEHMHEHAD@NCBOFCDCHKDAHCD[LGPKBGDIJAH@HWJCACGEAMBUHQ@A@ILEBIDQLIPCBK@EJIDYPGAGBG@ECAGCCC@EDE@QUBEFCES@C@AGACABIDICKFG@AAEQMAEFM@CMODCDGFEOEEGL]@EGCKAEEBCFE@ECEAKJ@DC@EEIBCTGNDhOAGBSAIGGICOEIS@CJKRKRSLEFAlNF@J@BBAHBJFHHDPFLAVHHFLTFDF@LGNAJCHEFO@U@IEIHO@QDCFARBD@TmHAJBDAAG@ELM@KMOMKBOAEEELCROJKLEBC@MLUDENAHGDMJQBICMCOBGAMBKEIBeKW@OGQBmD[BMDK@CKAAAACGE@C@EDMGCMSKOAK@OEGCCKAcCQCABYAA@bRLDBD@JHDBBD@LFBBAJ@BJHBB@BAAABCDBFDFAPEPEHxQVShCVGF@RDN@HGPIJ_RKNGDGCWMSCE@IHYFQCYAMGICI@GBqICBYL_CGACMCEQOYKGAK@CACGEYEM@IDMJOLOLIPGN]HIV[ZQDEI[BIFK@GCSBEFGAKDQJYBEKOIIBGGY@OACGGCGEM@MEOBEDCD@JKDGDABCAGIENERQDEJUXBFARMXCJElBNQPGJGHIBKBG\\MDCFSFIJCL@XBdADAFMDEH@NIB@PBFAJ@`KR@DADEDD@FFNDFLFXHLJBBEN@FJHDNBJLR@DETBFJJFFHDPKjIDCBCGMAEFEFKHEJMLENMPGFEBGF[FMFUqDK@IAaECGGCGCEIAMGGICcIKSGAAJODCDEACDE@CD@@EKDGNWJGBWA[KAAAMA@MFSEUDYBSFG@eESII@GAKEKAOJKTMNAB[CGDMHUD[GG@[LSNQCKDSD[FQBA@@APg@QAGECA@OF]DG@ACAEBWOEICCWHODKLSBGMSCOMASGGC@KAEMAECEQICACAADKACQIKKEIBI@MAEEK@MAKCGGGBCJERITBdCZIT@JAPIRIPOHAP@DALET@J@FNFFNFVBZJLND@DEJOH@RSLCAKDMVGBGEQBSN@HEDGF_FEJDXH\\AVDBABOBCRGFAH@VFJGFEDQDCHGLD\\PF@FEb@FAHET@NCBE@GFEDEBAHBLEF@BDCJ@BDBDAFKD@JFBACKCAE@AABMDCF@BEIAAE@ARADCCEDAJ@EGJG@GAGDAHABCIIAA@CDGAEDYCO]EOACEAIEIECGAM@GEKEMJSABIAEEIIGGCEEEAGB_NQ@KBEDE@IAICGGUUIE]JS@CAKGGIMEGGCCIOcAADCBEUOAEBQAAAAJIBGIQCSKO@ABACGCK@ED@@EBMDG@EHECEBAFABADBAAMGEGESIACAAGC@GBGHKHIJGBIAEHIDILA@CAIIIQEYMAOAEGAKGGUOOOIMAE@GHMCIAMFCDE@GAIDG"],"encodeOffsets":[[106294,32185]]},"properties":{"cp":[102.221374,31.899792],"name":"阿坝藏族羌族自治州","childNum":1}},{"id":"513300","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@LMACBE@EDABC@GFKBIHALMJBPN@DEVBBFHPJFH@DHJHDBD@JFH@BAZDHLL@DGNDDBJCL@FB@LNBJATJPJFFFBHANLVAFIJANBH@DMR@FAHGFMBGBABFFHF@B@DED@B@DFNJNHDNFFAVSHIDAHBLANNNFHBFALMHAHAHBBDHRBFAJ@HBFLN@FADPRLJ@HAJHH@DBJAJDNET@HABBD@DCDFBHDHCBEHFTBHIBCAGBCAOBEBEFEJAJSFEPEAGFCJGLCFEBQ@MBGHMBODIHCLCFGDANBP@RCPHLGHGFAPCNDPEBA@OK_IGAEDCBAB@LDNBRIFGD@NJDBDAJEDIBCF@D@D@COBEHIDIBANHD@VIFE@ACCACDQHETKGO@[CSAGFM@SDQFIDEDCBMJSDSBMDSAECMG@KBA@CEBAKGEOQMCMCCM@ECAOGI@CBANADCNMJO@SXDBAF@FMHA^FZKZAdDDA@GLKAI@E\\KJBDFGLBBHDFHBFCLHLL\\BJCLBDBDCN@LBDFD@DCT@DLTBJDHANDDLBRBLDBDGV@FL@hOXEDCLCNAV@FAVOJBNPLBFBLJRHHLFDVDDBJHJDBDDABECGBEHEGEEACIGK@GCIIKGOIEBGPEL@JZZZLNJHDENEAENEDEBIHG@KPII@ACBAJABBLND@LKJAFCDKAGBGFEAGDAHADCHAB@BGFGBCHA@EDADE@CPQBKNCAAIEC@EBCADGJCHBDC@CACOE@C@CFANDHAFBBC@KPAEEGCCCAA@EFCB@TNDABCAAGEAEHIL@BA@CCC@EBGPBDCDGHDDFF@BADIJAHC@AGEAABEDAFBBFJBHDDCAKJAFBFFH@@CCGBC\\ABCAGDCD@DFD@JEDEDAN@HCDG@ADAXAJEDDD@@EGGGCwMSIACAIBENUJCBC@EACGESaCOEEQAGEIGEOACKAO@cKUS[_GKES@IDIJGBCACIEIOAGJKBACIDGAEDCBINEBC@EFCHIJCBMACGC@AHK@ECABCPMFBFBNJBCHAJBHGDEAEKICE@KPYRSDALDF@FCFINARBLNHATOJEFAN@BADCN]R_DCB@TBXCPCJBBATYBCGKICIAWFIAOKCCBKN]TQRGFGP_FAXEFATQJBFCD_BCTGNQFMD@PFHA@A@EISGcIOAEHG`[DBHFFBFALINADCDIDKPABENGFIbKH@NRFBV@LD\\NhNjHD@JCBIBCFBH@HBPEJDJCDGLINIFIFUAIGG]SEOAG@MBETQBCAUBMAIAIEGCCE@aBkKACAGBG@KMOIUokGBSIUEIIMIOFIAIGCKISCK@KBGNWLI@LB\\JPNHBF@B@ZYHMFSRCFCDEBEEM@OFYDE yLKFMDCRGV@LAVK@CAGMSGGAEHYFCJAZ[@AQGIGCSAIDIHEJKDK@IGKFSJQHUPEXEBAAKBGJKDCJBHBDDJPTNRHHFVHBNFF@LEH@H@FBFDFJDLBLDFJLLGNMJEHIDGTaNoFOAi]sEgBGBEVM@CAIPBD@LGZ@LIJOJGHBBBBD@JDFNHFJTLF@FABC@U@CBAH@NDRBHHDJRFDHTNJHFBXCHBFRBNDLBFEJ@HFHFDF@R@FFBBLE`GBABEBGDAHGFK@IGMG[CAGDE@MWCEQGCECIDGFKGS@ANW@KHI@]HGFOJCFBJRHHBJADCAQEAD@FJNLDFJH@DFETMDM@IJ@BP@RDFEDDLHHRDFDFpHRCHJRAHD^DdWBGBEAGCINQDAB@FFDJLHLPNJ@J@D\\THBPANFJILDVCBAFODCfUTGBCL_BUBAJCBCBETEBCBGBaDGLBfRPDRFJHJBD@DCAMAEGCACDO@EJGTCV@JBPHNDLBJ@bEHCHGH@HCLOAICMBGJMBACGCC@EBALGBEIWAIHQDCNENKHUBeBANCLETMHCTPBNHLD@DDtLJHZ@ReFEJCTAJCFGHADCBG@MDI@GDIH_HU@IJMDMHGD@FBDFPCHBLBdRTXRNTPLDLFZ^\\JNJFBHCBAHSHE@CAMBEJMBAAIACMGAGDeDMEGFI@CECK@CCBAJGBKJQACECCG@ODGAU@K^QHaV[BG@EIOAIBEDGTYBIAEMGQMICIAI@ILC@[AMCK@qAgIKEIE][EEAKDSFwAQ@iCKIGKEOMKMCQBGHEv_FI@EAA_HE@]u@EZIDEDM@OAEQOAC@CFO^NF@pC`QTgd[XWHCTAHCRQJGDADDDLBTFD@\\PDbNHLH@PEFC@MHETEJERDRTNBDBCZFLj^BFBJF@HADBFHRCD@FFHRDBLB^\\FDNBPALB^HL@XMXQPCrYFAFBFDJJX@DBDFBJ@VE\\BbSdCNDFFFHIBIZ]BGCGFW@CEE@AB@LEDEAGKICGAEDWAIGGQKAGHMGiGGOGOMCCMIKKM_O£EQE_BW@KFAKAOHMTYDKAKIkEMAQFMJIBIAYYKgAICqMEK_SKAOG[SQICCKCQMIKM]W_S_M[AIA[HQAEECI@GAMMOUF[F_FQC[@QHOJKRSFKH[@OHWCGII@CACHOAEACGCQSEUBSEIIIGK@GFOPSTK@_d[FAXBBO@UDMLILCLENUDKBKAGIOKIIKMCCA@ILUDKUKg]MSEMW¡MgAWBGDIJIt]JIDED_CSEQ×©]OkcGAOPDJG@[CCHCJBFLN@FCN@JDJARCBIAE@EFFNALCJYBOCAIDk@COBEHCBU@WGGIAA_G]AMJIAUIEBSHM@kQ[@YBE@KCE@IDIFKLIFO@KAGAXyFUC_HQHE^GNALG@GQeEkGIMIIIIaCMHgNSJIJC\\QNCx@FGFANAJBPJF@dILEfUPMTWZaHCBEAMESSM_MMI{oCC@EFEHAN@X@NDPRLFP@ZENKBEAGDSJGLELKLGNY@IESKY@GHKDOVU@CUgAI@EFMLC_K]]ICemIIMKOI_Me_CGIa@YECoSGAKFE@KEMMCIMICECQD]EMmsCKBE^WZO@IASBK@GNQBiNSTMRU@EIKGE{QOIKQe_KCO_CQGCIGCIGIEQASQCGEICQDWLKAICUMuSYUaQWUKEQKEIcWEI@GDQ@KCUHUACK_EcCI[gAE@_@IQ[OcEC_KKOSOSCECFOfEBeSUMMOmakSQEmKwHEFGnBjCVGP@PEJBRAFGFQ@GTBHEHGRCTBNCJGJDH@JOH@DBF@DONA@GGYGOKSGcUABEHCHBDbVbrLLLPDBDCLQFE@CDALDF@ZCRBXAFCDGK\\EPGHGP@lQN@RARDnXXFB@B@KPBHAFMJ@JBDHFGRFPADWFSNMPaxO@MDU^CBICKGMESCG@GDCBEVWXMXQHOBwKIFCTGJOFWASIUMUEaAABHV@HAFKLOZCBEDI@G@UGQBMBULG@G@YKOCO@YDg@MAw[G@ABJNBN@dJJBL@JQbAFDXCTLXAD]N[hENFZ@FINH^GVBJJdJLDHBTHLHR@FOBCBCF@JJt@JCJGFCB[AGFAF[ANHLJJDJ@FAHAFGDIFEDAB@`CJaVKNCN@PFjBLCRCFQTQ\\IHKFgLCDEPIEA[KMGCOAGCBIACGAM@OEGCa_kWIAG@AJHLHbCHKJKDFbE^KTYLSFUE_SQQk][GkAOEOI[UCgDKJGRCrB\\EPAZsBM@COMckIEICQ@IDU`MJcDYAEKGAIDIFS@QGSOM@OFMVEFEDSHIBW@ACNQBIWMECCEMG_yIIICeG[IQ@ODGHWHWIWACI@ELMHCDQPCHEBCGUDaLUNQHQLyPK^KHEDG@IA@GDE@CKEQDKJSHEHC@CEC@G@KFQ@UiDMFGBECGE@ECAK@QG[UIGKQGGCAWLC@OEM@QEEG@G@CFCb@DC`YRELGFG@]DG@SEO@OEG@MFiPY@S_[MaCgUgIGgOCCIKOKMGGOCSGS]COKAMJIDGBGGGSKMKGKKUsFWFARALGHGHMBIGUSYIGUKOKOWKBOJKPYBGDWBuFYVoFOH{DMNULcLUDOCKCGIGM@]@MFEFQJI@MGI@YJIBEACKCAgD]CIEGGCEG[IGMUKKOCMEULMBGFQ`IBUEQAUFIFIDU\\IHSNSJYJmbULEH]fSPAHBFKAKCCF@FABCH@JABENED@DCBGPBBA@@B@B@FCHGHE@C@ADC@@DEBAFEDABBBCFFFANBHTZADCLFHPAJCH@XXD@NILCFIN@DCHDDNLHAF@DHHTDV@TFbBHBJFTTBF@BKRBDPDPRLHDD@BEHUNIREBQBEDKNAJDHJDVBFBHrHHEFIBEBICCBCHMLUDCF@JEHI@EDIDGCUJMBIHEBgFMFE@KCABABALXr@DID@BV^FJKJGHEPALC@IAQAILGBICA@MNGBQJUDMNEJ@JENBHAFCFEHABLL@F@PCNELIFOAIHAF@ZAFAFADECG@CHBRILCBOBCFGJWLAHCBOAGHG@EBI@KFK@KHCDBLGJBF@F@FCDWDGAKGICU@@DHLJHABMBADHLFD@B@JIDMPCDIDKPKJMNCDKBCD@FABQCQDgBCJKN_N@FBHFRCJIHIPEL@LDdA\\CH@FFTAHCNARAJ@RADECCKMAKCEGEMGM@CCCICMCCBCDCB]@WDMEG@QDACAEBSAEACWSCGESHOBAEQNSBCACGEOCCAFE@CCCEE}WA@GFEBCGIEESEMKGCEECKI@CRIDEDE@KAECG@CBUESFKCEKEACIGIAK@OJEBE@OEAC@EBQAEEEWIOMMKCC@CFSEIAABQACKDK@KCCBEHABY@ICGGCAIDE@KIDQ@GCCOMJIFKACGAAC@IAUFEPGHGFIDODADSPICCUESIBUPYFGT@JAJKBO@EGKSMCIAYCGQIEEAEDE@SBSCKUIECHKNYLCFEBEBGDGBS@OACC@CBCAIE@EUiAQMgAOFYACBAAGBCFABKJK@GFEHI@GCCQJCF@L@BKLGDMPCBG@KCEBADCJOL@LCDEFIFGBCBEPEBGGG@ADBHADMDKHADBRALCFKLDJADEBIEGAGBCDABBLDDFBDJBVIRGHkJUTSHEJ@PKR@XCBG@MDEDCLKFG@CB@DDPCFOJEHMVMHABAFDLCLGHCBEHDFHFVFJLEV@dAFJVBPFF@DEZEFGFCF@FBFCL@HEHCNCF@DHJ@BCHE@@BANLNBJFJFJBFABGFUDCBCB@FBBPPAJGHCBMDADBHJJAFAD[HCBADAHFVCFKL@HDL@FEJUTAFAFHHHL@FEPBDFJ@JIRKPIHEPCD@HF\\O`E\\EJFL@DAJBVCDAFFNDVLTBH@HCNLFHFHP@LDJBPI^DRDHFJGJGFBRFN@FGJ@NCRJ^@RGRIJ@lE^CHFdALDJ@BIPBPAJDH@JGFCJDJHDBDANCFKFCDDJDBDADDBLALBHAHNTAHADKLALDHFH@R@JAHKRIHENMJ@JDH@DQXGFMDMFCDAD@HJHHNENEJCTBNEPBPEXAJ@HFF@HCFElEHBFLDDB@JCD@FCBEL@DFFBFAHADGF@BADBF@JHLBLCFMLABGA@LDPBPERIJDJ@LJ^BFAHEF@DFHBFEHKFELEFCNGLa^EN@FBHCPEFELMLADAFHJADKBCJ@FHL@DEH@HHLBJAHDPEHBBDFBL@FAD@DDF@XNVH|DFHJDNAPIZ@LJJBDFHDP@TBDRNBF@FDF@JJ\\DDTR@V@DHHBXPDFHAHGBQHEHAFH`IhAB@F@FHHEFEDEH@F@NBFAHABOFAD@FDLJRIZ@HLZDZWXM\\GDOTGJ@LJPAFGLIJUBKDELBFHL@FAFKFCH@HJ^LPBPCFSPGFEFCP@HDJAFIJBLPJFLHHDJAFILAHBJCLBHD^GHSPAFDNHL@FKTBPALDDFBDDBVAPORE^@LDD@D@d@Di|CRFJ@JCHKLCLCFCHALFL@FFJBPEFKFARCLFFNLJNDJALGHMBQPCPJL@DC^OXEbM`AP@FFJLBNFVBHDFJALFFHBP@JDLFBFBHCNCJElEFCDUDmRS@IDEDINIHCFGDEACBEXBLAJKJQ@MDCRGTCDmXGHCJUFYLa\\CH@LCFCD@BFLFXVXHPBFFhNXBR@JADMNALEJGBIFOHCDCPMFK@E@C@kbENFJ@DCFOFSPGL@FBDCZCLCB@FBFDFADIHCFKFEFGDCHGDEHKVCDODMP]HAFBDIJU@M@K@UJEFAFBDPDLFJNFdEJCDS@CBEP@FAPBNADHXDH@JDFJZ@XT\\BJDFJNHHNDL@NAFEF@FHD@VG^CHGBCLIFIPS@EHEJCBCHEHGDADM@GJMBEDGHCNAHEHCPBFCBECEBAFAHFFLBDNL`\\FPBdFLFHDBBDBDXJLPLLTDDDLDFPHJJFHLLFJNADOLMTMRMJMFMLAHFH@HCHEFGHKDIB[LCFGFQLE@@D@DCPKJQFQACDCFKJIBGFUHSRGDGHGBI@EH@FKLILGDAB@JBFGJMJCD@DEDG@YXQFIN@F_R@DADEBQCGBCJANEDIBQNAFIJKLBJCDCDID]TKHIL@HHVBFEFGBGF@DBDLBFB@DABUPCF@HDFDF@FAFCDE@CAIGKDWBAB@DDDDNCHGDCBCNCBBHAJEHWXABI@MDCDBJ@DEFUAMBGN@DDFHDBDCFGDSFIJGL@DBFHL@BEDQAEDM@IACBADFFBFABCD@FFJLHDHGDGBABAFCDCHBHADCTMNIH@FHNBJPFPDLJHDF@DH@JBD@HIBIBGFBFHB@FC@@DBFPJBBELBPCFCB@FBHFDBDELCB@DNHBFAJKJSFADAFSFE@CFALDNDFAFodORIFGDEHEJCDY@AFDFAFGFGFMACHBD@BED[BAJDRABA@MGCDER@JGN@LEHCDELCDCLGFCPEFC@ABCPAHQZCDKDCDGNGFCFGBI@G@QLFPBNEJ@FDDLFFDAHINKTUBLNN@FFNCDK@OFEHAHCJEBIEGBGPQJMBCBADQCGBWJ@JEHMBEFDLAFE@IIKGIAIHKPA@EEMAIDGBGHALLHABCBKAWDAFMNYACDCPKFGJBFAHABQCM@GFEFE@CBINU@IJGBE@GAG@EASDCBAFCBGNEFSAEFcFIEMDYE[LGD@JABSBOAEDMFGCECIACBM@IAGBEBELBLAFEFEDC@GAKBSGIBCFCJGHGBUAMEG@SDSB_JEFAJADiFSN@HABEDKBQJIJEHIDGCEDEHOJKTEbCFGBE@MECGEACDAJEBKBM@OHUCE@GDCFAPKLIBEC@ABCAAC@KHAB@LCFEDYCGBIFOFCDCJBHEBMCABIRMHGJKH@DIDANCBGAODKL@BBBJH@DCLETSPAD@HKHCJGHO`GJGJATEFAPDFEHBDC`BDHBH@JBAP@D@LEHMN@FBDJDBB@DCDUFGH@BHHFHADCDE@Y@IBIFEJDRXFCLBJFJFBFF@DO\\BDHNNJHBT@RHNAJBDDHJHFXDLFLBN@TGP@PLHFD@DABCF@`DRF^LAHIFEHSJINER@DJANFNEDBRPRDLFBDIXADBH@HELGFCTGPCFIJAJSAKBKFON@HJNCJP\\ADWPH^AHCFBBNALLJ@NJFBBBDDBLLH@FDHDHFFHBF@LEH@HFFJDDLDPJHBDBALDN`V@LBBLNNFDH@HE\\BHR^LFFRFHDDBXG`@LBHADB@DAHCJBJTJH@@A@C@@JDPCBBEHBBBBJAFD@DCFBFCB@BDBDADED@BBCHFBFLDBPANDBBFJRFBDCHBDH@FADAAHEF]FaRO@GJCBKDQ@ODIFIAC@IH@DDB@FGHGBK@IDMAIDEHKDGHGBMEC@CBCBCAKOE@A@CDCHQFEJEHCBGAIGEAMBICID@D@DFF@DQNCHCP[PONENKJ@DBHLN@FCP@FDHDL@LAJHJBJ]N_DKFE@CCMDG@WKK@IBCBGPKFCLCBIA]LEPKLBJCD@DFFNFBNNZBLBFHDBHAH@HBDJD@DGPAHADIHCTJJBNUPBHC`LHBFEFEJOJ@DFHGLEXBHKRGDQ@EB@JMJCACBGFCHHJBHCN@FHDnHDDAFMR@BHNAJKL@LBDJB`MTJD@LATDT@VAD@BNBDFHFD^IHHPBFBFHBHFDNEN@BABGDCF@PBJDRRD@V@hJJDJH\\JTCfQH@HDHHBDB`HHJ@FDBFFJBF@FAH@FDLELCRGRDRHJFDL@PENHJDPVPRBfALQRADDJCBSFABERMRQ`AFFH@JVHFDN@FAPDD@BBBDDB@BBBFBBBF@DDDADDDABDFBD@DBJBFDBDDCBFHABBAB@DP@BDJAJBBDHCDB@BBBCBBDFAH@DFF@DDFB@DB@BCBBABD@CJD@@DD@BB@DAFB@@DBDHD@DCBD@@FBFDAB@ADCBHB@CDBDCDFFDADFFHCJDFAFBLEBDF@ADB@DAFBBAF@NCP@FDJEPDDADBDADBFCFBBADDF@@DD@@AB@DDBADBBA@AD@BAH@DCD@@CH@BAB@BCDABDBAD@BCBDFCJ@BAFBF@DBBCFCAEF@BCH@@AAEDCJCDCCABAJ@FGFAJILA@AAAHIFBFCFE@EDBJEF@HEBCDA@ADA@CD@@GJG@CDAACFA@CHGD@FDFABABGHBDEHADADBBFLBFB\\CLBBBADBBN@HCLBDAJAFEH@FAJGL@BA@EHCF@JBDEDAHFDBN@FABGHBFEHCDCT@DENCN@BIPG@EBCF@HDHBVJTGD@HDJAN@H@HFHAFFJ@LEHDFAFDHALDPCNDDDLDF@J@H@FB@BIZANCF@FC@AEBEA@ADAB@ACECBEEAC@CABCHBDA@AIGBG@EEA@EB@DD@EDCD@HABACABAHAACBAF@@EDABGF@FAFABCE@ACBAHB@ABCFBBAAEDCFQNaDKA]EMEECIACEA[GAC@KGMAODO\\WDGBEI]CGOMK_LITIJEJKFIDAJAPBDBNJHBBAHKNKHOLYFWLQ@CKYBIHIDCHAHFNDPBD@JELKDUFEJGZGTINAJETEVSFIC]DGDEJINIBETGh]BIBCVCHGBEACQGWEWAMCACBQH[BEVERIVMDGF]@CEGAMIGAWDGDCHAF@JHF@DAFEDIBIHGAGFCP@LKDAL@PMLCLBHC@CAGCKBG@GDALAFCDGN@@C@KBICIDMCMCWEIEiHERCB@HKBEBMHILIPEPIBEAQ@KDIFG@AOEGC@A@GHKAAGAKCACBGJUHKEKWMCIBKBCPANALDJ@HEFCVAJKHWFC@CKIDKEGBEEMAKHEFKAEVGJAFEDG@WAEDCd_HOFEJER@JOHCRANEFEHGDGJCPADAJEF@VEN@\\FTEDEAKDGBGXKJCJ@HCFADGDCXAHBBB@HFDFJBBHADAFGHEHCNAJFN@BGDENGH@^HDADABOFIJERFFAFIBKNMJ@JH`@dIXAHGLGLADGNKJM@EEE@CPKD]BCD@LDJELIACCGAGDW@MVAJCDEBAKKDMCOFILMJOPmAIDCbNPARBNKhDFHFRLDHALMJEXNVPR@VMJCBCF@HCHBNGDGB@FEJBJADC@CDADELCFCBCDAJBNEJ@HCPAHEB@HGF@HB@BF@HCDBDCLCN@TBHCHILDH@RGDADKFENEX[LSAWBAHEJDPMHEHBHDN@TRJ@FCBCL[DCDAJFBDHBJAHMHEN@JDD@LCN@DCF@"],"encodeOffsets":[[102098,33552]]},"properties":{"cp":[101.963815,30.050663],"name":"甘孜藏族自治州","childNum":1}},{"id":"513400","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@BE@AKGCBEL@FHDD@DADE"],["@@J@JCHAZNH@EQI¹CEGEK@MDEHCLEBRF^"],["@@H@FBNBDADCREDA@EESKU@GDEIC{AUDQJI@ECAGLKD]HG@Gs{GEI[BOAOMYG[AMBMDOHKJKLIV[VYFICEUSKGSIgKMIEECGCGBSHY\\uJKVoHYBKCI][CIAKDKPaHYAIOgMaCSBOFMFSJQLGDMG[CO@IN_VcFUJUAC@CRAHGPAHEDADBFNFBTKTAHCL@NKF@LBTFJJT^HTFdAHAFAJBRFHHDLNDFVNFFJFHN@vFZDBVLNLL@XJJDZG\\CLDDDFALGTUFCL@JCLIJDRP@EDAj@TGNKPSPY\\]ZQNGPODG@GAMCKGIQKIGIKE[CKS[GQIGGaCSKWEIYQ_OCEFi@EBgJGFIXALCVIJANMJGHMBQHMHIDQJKVaBGHSLKJAJEDBJ@FMPI@EFERER@FDDFRJ\\\\HFLBHDHFNdDNAJAJDFBFGPOFSP@FBHHRFJPJbNPBNDVBTFFHZLJLJHJJT`FNEXDFnAPGLD\\JLBJ@LCJGDGDEHEHCRHL@JFNBRGJ@XKJGHKDQFGTSHCPDJENMBG@OEEGCKWCCQGACAYEMBCHApY@EHODAJBHHBTDHPZBVRLRFHBR@XFBELMHKd[ZoFEHQBGCaBGXeTULWFW@OK]AMFKbgFMDKAKCGGI_OSMQCMBAAOWMMUEcQQaIGG@S@YFC@OEKKG_IUGEKCIBIBKNCHAFDX@FEJED]L}jKBKAWSAA@GCCSIOIGEI@QACS]CKEEGCGEACCMKKWOMGIGGEEMGCQCKEGESUIAUDEAEMBKFGLE@IEICKAAMMSGEGAMCKBKAKBEHMXWJAFEFAD@NHDJFDVDH@HCJKDE@KES@EJiJIDKTOJ@P@JAJBHBHJRNFBF@FABC@WEKCCGCYAGCGGQOISUOMU@SAC@]AICEFYDIAGBKJI@GU{QU@GSOMEQGEEGOAMIMGEKACGCEUAMG[_ECCGEGAECGEAOFG@C@SGCEGKIKGSIKQGE@CCAEKGYQMKGIQMCCAECAG@EDC@GECE@IFMNKHCNQBGAECC@ECEAGD[AEKGS@YFCFE@IBM@[D[IGGAOCI@GCGEECKGGSEMIEGIUAI@IECKEECAIMMIUGECIIQBmCKEE]MKKOKWGUDQCA@OVCBODMA[]_YQGE@QGOCOGIAIDGHGFS\\EPAPELEBI@ECEIMcWaAGAGS]GUIWEQGMIMOKAKFUAKCIBYHW\\QFSBsEOFQHMGWDGFSDG@EDM@KEWAMAGSi@aEGKIIMIeCEIMCGBG^WJIFMASDWAGCM@GCICC@IBSHKDEAOFKAE@IFIVKDMLQJSJGDGRQR]RGFBFALGDG@GCEAEJQJGHK@CA]HKNIBCEIIE@AJOBKFGDQBCJADE@ICCGABGFKHCFCDIBOECAABICI@QBCLCFEPIJG@EAMBG@EGI@ADG@EFM@ECKDIBUCEQI@EBEPQDIBEBMJSJALDH@DCFQCG@CFWAGGSOCCK@KU[IAKEK@YDYC@CBON[BQAEEMEQAWCO@OFOHcFK@CKKCK@MKMSIcA[@YEGEMLCBW@WEGDGL@FFL@FIFEJC@ISIMESIIOKGOKGOGEKA@QCY@MCG@_GGEOIEEIQGIKAOAOEAABECGOKOYCIB]CKCECCMEGAEBCHE@UKYEGBOHCPCFADIFUHOHUNCJW@QH@BDJHLD^DNfbNJDHCTCJERCJQNUBKFUDYNSNIB]CECEEC]CGUKkKICWAOI[KGAWIcMKAaBUCCAM@EAQMCKIOQQKQWYCAMCOIIAYIEIYAMGQCW@SBMASIAACG@[EOIGGIKGOGaWECUAEAAESMKOCIMSIMAGEGCAMDKEGSCC@QEAS@EAEGCMEG@EoEQBQF]NcXEHIHKB_ICBACE@SCCAEBGBWIMCOD]\\IJWJK@OESKGI]k_eCCKEIAcECL@JNPBDERDH@FCRFTAHMNCHDJPTFT@FAHIN@JDDvbLJjP\\FFFBZADORCFBRDHAP@DLNJFDHHRFHBNANDJ@LBNDJLRFTCtADGFANDLHLDrHZCJOHVpFLDDPDJFJDNALDF@DADELQHIDEBMHAPAXGDEFBDDHLBFCT@HBJFL@HDRJFFJBPHFHJFJAJADOHAD@L@PCFIHAHAJH^B`AZGNELc@CBCfCJKF@T[@CBCDPVF@BD@HABEBEFFBDFADDDBXCDDHCDAHDDFNDCJFFNCRDBNAPBPEFAFBB@AJJTDNFFHADAHEDIJIBIAIECAYEKAEHCLS@EJ@JGASGG@CBALAJ@HBDEFAHCFIHG\\ABAAGF@`HDBBF@^GZ@DDDDB`FFBFFBDALBFJBNFNLDFBHKRDRLBDHBDJFNP@BKJBFFDCHDF@DEBKBAHGDIHABBJBFBBN@DBHF@F_VCF@DBFDFV@FEB@FDANBDDA^KHADBBBCNAJKRGHCF@FDJDFJHBPARH\\AHCHCNGRBHHJDBNAFDFBBDCD@HJL@RKNQLABBDNR@DIDAFLHBJPbC\\CFKdEP@FDDbVDFBDAhBFPPBDAFKPCAK@KLEBOBEBEFKXADODYAIFGNCPKV@^AFIHGBSCIOMDE@SEOYQGMKYGEICWEKKOCIIMEGUMCQACOKGCC@CBUhQJE@KEI@CRIRIFYJG@QOIEEEICKEEAE@ETATO^DDN@DDDBBFKZOPEHALAJSNGLA\\JHDFCDQFCDLHBTJF@HAFOJGH@LCLADABMKGK@IBSAEEIIKACBCFODIIiICMAGGDIFKDARABAIg@SAOCCAAsEQCECMOQY[ZMHwZODG@GCMKEAKBMJGAQDMEGBWLGLGFMLAJELMTINGHStCDKF@DJNBHAHANKTRRDF@JJPBJDNFP@FEPAFBJEPGDOGA@ADBFBFAFCBSFBZEBQDCAIIC@QBOD_MCEBKOICKSUGOOGMUGCQAKMCGBICECOIW@Q@AQCU@IBQPK@IDE@aQ[@CDMHKDI@KKQKK@SAGCCGIQIKKKHCHAJURQLSXABAAIEOAQ@QLEPIHEAKEI@IEGAIDILG@QOGBQACAEEOMWCQBKJC@AEMEMLI@IIIKMGKEM@@JDDABBDEH@DDDAFBHBD@HEFBBKC[@CBADC@EDQDEAKDEFC@CACAIAOBGGEAC@ACC@GAGGGAIBKDODGFBJALOFKLG\\BBJDANar@HHR@JAPGNaXDJFLPRADCDAD@DDF@DEDGBMAKFGL@TIROJINGVCBKDGFAF@LS\\AH@FLNCJINGPIFEHCD@DQBGBKACACICCAEGEC@EEC@HfANELBBNR@FFLBXANENIFINMZIDBF@JEJEJU^GNGDG@KDAHFhAHGBGACKIGQAGDLVJFDPTHDDADGFKAIDGDAH@DBHLFHHDB@BD@BBBB@DGHIHGDKDUB_CQAIDOTGnCpAJGLQLIV@DADCAIFUDGFAHEBCFA@@DIBAFC@ABCB@DEDA@GBCFEXCDBHFjDFLHFLDD@HKHQHIFAFBDHNBNCDOLCJANCFSHBP@DABAACCEASAEACAIMG@KHUBAACOMKGMEMMSCAAIDI@IAECE[OKOQEGECGYMGEEMMIEDM\\MBMGG@OJCXCHALAHGAECEIKHIHCFIFGD_DOFODUCCCFC@ECOECC@EGC@CCGAEMCMBIDCCIGICMUUCKOKEEC@EEDKAGCIAMQDIFE@OECEBGIG@CASMQKC@CGAWBGFMXCBGADJLP@LCPGPFX@RADUHIJCJBLFJZVFBFDBHGLBJGFJLDJ@DCDIBIJEBUIWJKAOGMHEBY@[PKBCAG@EBKLIDCHMDILE@I@ICCB@HBNRNFLTVJH@DGJ@JCB@DEHCBKDINC@EDIJADKJCFKL@FCDIBGFEFS`IJGBCDODEDE@CBC@KFE@EDGNIHCJBDCDAFCFCBBFEHBDCBAJA@@BADBFGJLDJBBMTO^eFGVKnaZITITMJGV[JCJEVERBVFJAR_HENAVKNFPDLLNVJHH\\DFHHJF^DhCDBDLFBJAZIJ@NHJ@RIFENE^@N@JHHTCPKVKdMVCNG|EPUpEZAvCXAHOZILAPLPXPLVLJHTZHVAJGNGHKHQBEBEXVtLLLHLNHTHAHCHIJBNPL^DHTDTHPNHPLJLDDhPJHVhDhNb`\\@TOZEj@NFH@PFP@TCH@^EHKHQF_ZCDa@ED@D@HFHRFN@PFD@XKDBHHLRJH\\VRHL@DB@FHFFDHANEjC@VER@L@HFD@DGDGFITCLFRDLF@HCB@@JCHGF]LOLKzGRMRKVCbHVADGFODCRGDKN@FDJXBXJXGHGPCR@\\JfHJDJJ`zNHDFFDXNAJMRBDX@JATGFCFENUPEN@TPRHT@JEJCHBFLZBdCNIV_JCR@JDJFdlPN@DANYtOB[FqAQDIHCLDh\\VPJPFlB\\Hl^RR`TVFTEZKLSF]EaLCLIDGGaGKBIH@JBlXb`HDPFN@HBBDAJHDPBHDLNB\\JFFODChKLEJGR[RSDEDQAKEi@ODMLMbUDI@_BAFCJEHCBEBG@ECIIIGKBM\\BEHE\\BDAHEDI@IIs@IDEDAPA@EGQGKASCGIKIcAIHUG]JM@EEYFM\\g^MBCKWDSCWBERa@IAKII@cAMIMBAH@x\\NBh@ZCP@PDZLH@H@VKNARAVHH@J@FCDAPYLKBE@GGUBAbBVFVNTJXBPEHIDSJExLPARGNWXWFUDAHCH@TDNFLHJDDAV]NCP@bwNOTMXEBCEOHQGEAC@INIBEAGLOA@A@WEmWQCQBM@kRO@GHOH[FLCHEDWBQAYDE@KCCB@DEFKRCDCAKOKKaqaUACDGFGBAdVTHPLZHHHB@PM@CAE@CPG@ICGHIDIAMDSHQFGAGHSR@HEBEAQFI@OHODUAiHmFExGnL~ZnbNPVNfTFAPeEFDTDTPLP`LFDPdR\\@J@`BF\\hDJFdL`BDGVDV@LCR@HFJdXFJRLLFXVbRZVvTVNJDLBXKRCJDHFRDBTFRHJDJJHHDDRP`LDf`LRPJ|RHFJL@FQVSNMTAjMR@HALBT@JYP]XAFDLntFNC^DRDFNJDJNNLFF@LEHBpTFD@ZJbDHf``NPJNLJJfnJD^^`LF@HAbQ@COWJGXiV]ZWPURcRqFKHILEP@HFhBPCJCbYLQJIJIVQLA~BfC\\E`KHDDFHVLRRHJNFRRXVhDNALUdI\\AJBHHVVPNBRVTnFHFDPADDFHAPM\\ALBHFFHNS`NfD@HCDBLJXBHDDFBNDFHDBF@VQH@BJHLHJBtAB@LV@BMJEL@LBHLNFFfPH@NDHBFCJIJMDKDAF@BC@CEICKBENINAFCNIJAHBXLJ@lMVKJCJBJDDDPDH@PEFBDDN\\CHGJKJCJ@NL^HLJFFFBF@FCL@DJFL@HDPLTBTKF@NGBKAMDcDERCp@TBXHHHDFRJDF@HA\\JlRZLJJ^JHJDNB`CNA\\Q\\EHCDB"]],"encodeOffsets":[[[104612,27500]],[[104363,27345]],[[105476,29991]]]},"properties":{"cp":[102.258746,27.886762],"name":"凉山彝族自治州","childNum":3}}],"UTF8Encoding":true});
}));