;(function() {
/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2016 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   2.10.0-beta.3
 */

var enifed, requireModule, require, Ember;
var mainContext = this;

(function() {
  var isNode = typeof window === 'undefined' &&
    typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

  if (!isNode) {
    Ember = this.Ember = this.Ember || {};
  }

  if (typeof Ember === 'undefined') { Ember = {}; }

  if (typeof Ember.__loader === 'undefined') {
    var registry = {};
    var seen = {};

    enifed = function(name, deps, callback) {
      var value = { };

      if (!callback) {
        value.deps = [];
        value.callback = deps;
      } else {
        value.deps = deps;
        value.callback = callback;
      }

      registry[name] = value;
    };

    require = requireModule = function(name) {
      return internalRequire(name, null);
    };

    // setup `require` module
    require['default'] = require;

    require.has = function registryHas(moduleName) {
      return !!registry[moduleName] || !!registry[moduleName + '/index'];
    };

    function missingModule(name, referrerName) {
      if (referrerName) {
        throw new Error('Could not find module ' + name + ' required by: ' + referrerName);
      } else {
        throw new Error('Could not find module ' + name);
      }
    }

    function internalRequire(_name, referrerName) {
      var name = _name;
      var mod = registry[name];

      if (!mod) {
        name = name + '/index';
        mod = registry[name];
      }

      var exports = seen[name];

      if (exports !== undefined) {
        return exports;
      }

      exports = seen[name] = {};

      if (!mod) {
        missingModule(_name, referrerName);
      }

      var deps = mod.deps;
      var callback = mod.callback;
      var reified = new Array(deps.length);

      for (var i = 0; i < deps.length; i++) {
        if (deps[i] === 'exports') {
          reified[i] = exports;
        } else if (deps[i] === 'require') {
          reified[i] = require;
        } else {
          reified[i] = internalRequire(deps[i], name);
        }
      }

      callback.apply(this, reified);

      return exports;
    }

    requireModule._eak_seen = registry;

    Ember.__loader = {
      define: enifed,
      require: require,
      registry: registry
    };
  } else {
    enifed = Ember.__loader.define;
    require = requireModule = Ember.__loader.require;
  }
})();

var babelHelpers;

function classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError('Cannot call a class as a function');
  }
}

function inherits(subClass, superClass) {
  if (typeof superClass !== 'function' && superClass !== null) {
    throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : defaults(subClass, superClass);
}

function taggedTemplateLiteralLoose(strings, raw) {
  strings.raw = raw;
  return strings;
}

function defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ('value' in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function createClass(Constructor, protoProps, staticProps) {
  if (protoProps) defineProperties(Constructor.prototype, protoProps);
  if (staticProps) defineProperties(Constructor, staticProps);
  return Constructor;
}

function interopExportWildcard(obj, defaults) {
  var newObj = defaults({}, obj);
  delete newObj['default'];
  return newObj;
}

function defaults(obj, defaults) {
  var keys = Object.getOwnPropertyNames(defaults);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var value = Object.getOwnPropertyDescriptor(defaults, key);
    if (value && value.configurable && obj[key] === undefined) {
      Object.defineProperty(obj, key, value);
    }
  }
  return obj;
}

babelHelpers = {
  classCallCheck: classCallCheck,
  inherits: inherits,
  taggedTemplateLiteralLoose: taggedTemplateLiteralLoose,
  slice: Array.prototype.slice,
  createClass: createClass,
  interopExportWildcard: interopExportWildcard,
  defaults: defaults
};

enifed('backburner', ['exports'], function (exports) { 'use strict';

var NUMBER = /\d+/;

function each(collection, callback) {
  for (var i = 0; i < collection.length; i++) {
    callback(collection[i]);
  }
}

function isString(suspect) {
  return typeof suspect === 'string';
}

function isFunction(suspect) {
  return typeof suspect === 'function';
}

function isNumber(suspect) {
  return typeof suspect === 'number';
}

function isCoercableNumber(number) {
  return isNumber(number) || NUMBER.test(number);
}

function binarySearch(time, timers) {
  var start = 0;
  var end = timers.length - 2;
  var middle, l;

  while (start < end) {
    // since timers is an array of pairs 'l' will always
    // be an integer
    l = (end - start) / 2;

    // compensate for the index in case even number
    // of pairs inside timers
    middle = start + l - (l % 2);

    if (time >= timers[middle]) {
      start = middle + 2;
    } else {
      end = middle;
    }
  }

  return (time >= timers[start]) ? start + 2 : start;
}

function Queue(name, options, globalOptions) {
  this.name = name;
  this.globalOptions = globalOptions || {};
  this.options = options;
  this._queue = [];
  this.targetQueues = {};
  this._queueBeingFlushed = undefined;
}

Queue.prototype = {
  push: function(target, method, args, stack) {
    var queue = this._queue;
    queue.push(target, method, args, stack);

    return {
      queue: this,
      target: target,
      method: method
    };
  },

  pushUniqueWithoutGuid: function(target, method, args, stack) {
    var queue = this._queue;

    for (var i = 0, l = queue.length; i < l; i += 4) {
      var currentTarget = queue[i];
      var currentMethod = queue[i+1];

      if (currentTarget === target && currentMethod === method) {
        queue[i+2] = args;  // replace args
        queue[i+3] = stack; // replace stack
        return;
      }
    }

    queue.push(target, method, args, stack);
  },

  targetQueue: function(targetQueue, target, method, args, stack) {
    var queue = this._queue;

    for (var i = 0, l = targetQueue.length; i < l; i += 2) {
      var currentMethod = targetQueue[i];
      var currentIndex  = targetQueue[i + 1];

      if (currentMethod === method) {
        queue[currentIndex + 2] = args;  // replace args
        queue[currentIndex + 3] = stack; // replace stack
        return;
      }
    }

    targetQueue.push(
      method,
      queue.push(target, method, args, stack) - 4
    );
  },

  pushUniqueWithGuid: function(guid, target, method, args, stack) {
    var hasLocalQueue = this.targetQueues[guid];

    if (hasLocalQueue) {
      this.targetQueue(hasLocalQueue, target, method, args, stack);
    } else {
      this.targetQueues[guid] = [
        method,
        this._queue.push(target, method, args, stack) - 4
      ];
    }

    return {
      queue: this,
      target: target,
      method: method
    };
  },

  pushUnique: function(target, method, args, stack) {
    var KEY = this.globalOptions.GUID_KEY;

    if (target && KEY) {
      var guid = target[KEY];
      if (guid) {
        return this.pushUniqueWithGuid(guid, target, method, args, stack);
      }
    }

    this.pushUniqueWithoutGuid(target, method, args, stack);

    return {
      queue: this,
      target: target,
      method: method
    };
  },

  invoke: function(target, method, args /*, onError, errorRecordedForStack */) {
    if (args && args.length > 0) {
      method.apply(target, args);
    } else {
      method.call(target);
    }
  },

  invokeWithOnError: function(target, method, args, onError, errorRecordedForStack) {
    try {
      if (args && args.length > 0) {
        method.apply(target, args);
      } else {
        method.call(target);
      }
    } catch(error) {
      onError(error, errorRecordedForStack);
    }
  },

  flush: function(sync) {
    var queue = this._queue;
    var length = queue.length;

    if (length === 0) {
      return;
    }

    var globalOptions = this.globalOptions;
    var options = this.options;
    var before = options && options.before;
    var after = options && options.after;
    var onError = globalOptions.onError || (globalOptions.onErrorTarget &&
                                            globalOptions.onErrorTarget[globalOptions.onErrorMethod]);
    var target, method, args, errorRecordedForStack;
    var invoke = onError ? this.invokeWithOnError : this.invoke;

    this.targetQueues = Object.create(null);
    var queueItems = this._queueBeingFlushed = this._queue.slice();
    this._queue = [];

    if (before) {
      before();
    }

    for (var i = 0; i < length; i += 4) {
      target                = queueItems[i];
      method                = queueItems[i+1];
      args                  = queueItems[i+2];
      errorRecordedForStack = queueItems[i+3]; // Debugging assistance

      if (isString(method)) {
        method = target[method];
      }

      // method could have been nullified / canceled during flush
      if (method) {
        //
        //    ** Attention intrepid developer **
        //
        //    To find out the stack of this task when it was scheduled onto
        //    the run loop, add the following to your app.js:
        //
        //    Ember.run.backburner.DEBUG = true; // NOTE: This slows your app, don't leave it on in production.
        //
        //    Once that is in place, when you are at a breakpoint and navigate
        //    here in the stack explorer, you can look at `errorRecordedForStack.stack`,
        //    which will be the captured stack when this job was scheduled.
        //
        //    One possible long-term solution is the following Chrome issue:
        //       https://bugs.chromium.org/p/chromium/issues/detail?id=332624
        //
        invoke(target, method, args, onError, errorRecordedForStack);
      }
    }

    if (after) {
      after();
    }

    this._queueBeingFlushed = undefined;

    if (sync !== false &&
        this._queue.length > 0) {
      // check if new items have been added
      this.flush(true);
    }
  },

  cancel: function(actionToCancel) {
    var queue = this._queue, currentTarget, currentMethod, i, l;
    var target = actionToCancel.target;
    var method = actionToCancel.method;
    var GUID_KEY = this.globalOptions.GUID_KEY;

    if (GUID_KEY && this.targetQueues && target) {
      var targetQueue = this.targetQueues[target[GUID_KEY]];

      if (targetQueue) {
        for (i = 0, l = targetQueue.length; i < l; i++) {
          if (targetQueue[i] === method) {
            targetQueue.splice(i, 1);
          }
        }
      }
    }

    for (i = 0, l = queue.length; i < l; i += 4) {
      currentTarget = queue[i];
      currentMethod = queue[i+1];

      if (currentTarget === target &&
          currentMethod === method) {
        queue.splice(i, 4);
        return true;
      }
    }

    // if not found in current queue
    // could be in the queue that is being flushed
    queue = this._queueBeingFlushed;

    if (!queue) {
      return;
    }

    for (i = 0, l = queue.length; i < l; i += 4) {
      currentTarget = queue[i];
      currentMethod = queue[i+1];

      if (currentTarget === target &&
          currentMethod === method) {
        // don't mess with array during flush
        // just nullify the method
        queue[i+1] = null;
        return true;
      }
    }
  }
};

function DeferredActionQueues(queueNames, options) {
  var queues = this.queues = {};
  this.queueNames = queueNames = queueNames || [];

  this.options = options;

  each(queueNames, function(queueName) {
    queues[queueName] = new Queue(queueName, options[queueName], options);
  });
}

function noSuchQueue(name) {
  throw new Error('You attempted to schedule an action in a queue (' + name + ') that doesn\'t exist');
}

function noSuchMethod(name) {
  throw new Error('You attempted to schedule an action in a queue (' + name + ') for a method that doesn\'t exist');
}

DeferredActionQueues.prototype = {
  schedule: function(name, target, method, args, onceFlag, stack) {
    var queues = this.queues;
    var queue = queues[name];

    if (!queue) {
      noSuchQueue(name);
    }

    if (!method) {
      noSuchMethod(name);
    }

    if (onceFlag) {
      return queue.pushUnique(target, method, args, stack);
    } else {
      return queue.push(target, method, args, stack);
    }
  },

  flush: function() {
    var queues = this.queues;
    var queueNames = this.queueNames;
    var queueName, queue;
    var queueNameIndex = 0;
    var numberOfQueues = queueNames.length;

    while (queueNameIndex < numberOfQueues) {
      queueName = queueNames[queueNameIndex];
      queue = queues[queueName];

      var numberOfQueueItems = queue._queue.length;

      if (numberOfQueueItems === 0) {
        queueNameIndex++;
      } else {
        queue.flush(false /* async */);
        queueNameIndex = 0;
      }
    }
  }
};

function Backburner(queueNames, options) {
  this.queueNames = queueNames;
  this.options = options || {};
  if (!this.options.defaultQueue) {
    this.options.defaultQueue = queueNames[0];
  }
  this.instanceStack = [];
  this._debouncees = [];
  this._throttlers = [];
  this._eventCallbacks = {
    end: [],
    begin: []
  };

  var _this = this;
  this._boundClearItems = function() {
    clearItems();
  };

  this._timerTimeoutId = undefined;
  this._timers = [];

  this._platform = this.options._platform || {
    setTimeout: function (fn, ms) {
      return setTimeout(fn, ms);
    },
    clearTimeout: function (id) {
      clearTimeout(id);
    }
  };

  this._boundRunExpiredTimers = function () {
    _this._runExpiredTimers();
  };
}

Backburner.prototype = {
  begin: function() {
    var options = this.options;
    var onBegin = options && options.onBegin;
    var previousInstance = this.currentInstance;

    if (previousInstance) {
      this.instanceStack.push(previousInstance);
    }

    this.currentInstance = new DeferredActionQueues(this.queueNames, options);
    this._trigger('begin', this.currentInstance, previousInstance);
    if (onBegin) {
      onBegin(this.currentInstance, previousInstance);
    }
  },

  end: function() {
    var options = this.options;
    var onEnd = options && options.onEnd;
    var currentInstance = this.currentInstance;
    var nextInstance = null;

    // Prevent double-finally bug in Safari 6.0.2 and iOS 6
    // This bug appears to be resolved in Safari 6.0.5 and iOS 7
    var finallyAlreadyCalled = false;
    try {
      currentInstance.flush();
    } finally {
      if (!finallyAlreadyCalled) {
        finallyAlreadyCalled = true;

        this.currentInstance = null;

        if (this.instanceStack.length) {
          nextInstance = this.instanceStack.pop();
          this.currentInstance = nextInstance;
        }
        this._trigger('end', currentInstance, nextInstance);
        if (onEnd) {
          onEnd(currentInstance, nextInstance);
        }
      }
    }
  },

  /**
   Trigger an event. Supports up to two arguments. Designed around
   triggering transition events from one run loop instance to the
   next, which requires an argument for the first instance and then
   an argument for the next instance.

   @private
   @method _trigger
   @param {String} eventName
   @param {any} arg1
   @param {any} arg2
   */
  _trigger: function(eventName, arg1, arg2) {
    var callbacks = this._eventCallbacks[eventName];
    if (callbacks) {
      for (var i = 0; i < callbacks.length; i++) {
        callbacks[i](arg1, arg2);
      }
    }
  },

  on: function(eventName, callback) {
    if (typeof callback !== 'function') {
      throw new TypeError('Callback must be a function');
    }
    var callbacks = this._eventCallbacks[eventName];
    if (callbacks) {
      callbacks.push(callback);
    } else {
      throw new TypeError('Cannot on() event "' + eventName + '" because it does not exist');
    }
  },

  off: function(eventName, callback) {
    if (eventName) {
      var callbacks = this._eventCallbacks[eventName];
      var callbackFound = false;
      if (!callbacks) return;
      if (callback) {
        for (var i = 0; i < callbacks.length; i++) {
          if (callbacks[i] === callback) {
            callbackFound = true;
            callbacks.splice(i, 1);
            i--;
          }
        }
      }
      if (!callbackFound) {
        throw new TypeError('Cannot off() callback that does not exist');
      }
    } else {
      throw new TypeError('Cannot off() event "' + eventName + '" because it does not exist');
    }
  },

  run: function(/* target, method, args */) {
    var length = arguments.length;
    var method, target, args;

    if (length === 1) {
      method = arguments[0];
      target = null;
    } else {
      target = arguments[0];
      method = arguments[1];
    }

    if (isString(method)) {
      method = target[method];
    }

    if (length > 2) {
      args = new Array(length - 2);
      for (var i = 0, l = length - 2; i < l; i++) {
        args[i] = arguments[i + 2];
      }
    } else {
      args = [];
    }

    var onError = getOnError(this.options);

    this.begin();

    // guard against Safari 6's double-finally bug
    var didFinally = false;

    if (onError) {
      try {
        return method.apply(target, args);
      } catch(error) {
        onError(error);
      } finally {
        if (!didFinally) {
          didFinally = true;
          this.end();
        }
      }
    } else {
      try {
        return method.apply(target, args);
      } finally {
        if (!didFinally) {
          didFinally = true;
          this.end();
        }
      }
    }
  },

  /*
    Join the passed method with an existing queue and execute immediately,
    if there isn't one use `Backburner#run`.

    The join method is like the run method except that it will schedule into
    an existing queue if one already exists. In either case, the join method will
    immediately execute the passed in function and return its result.

    @method join
    @param {Object} target
    @param {Function} method The method to be executed
    @param {any} args The method arguments
    @return method result
  */
  join: function(/* target, method, args */) {
    if (!this.currentInstance) {
      return this.run.apply(this, arguments);
    }

    var length = arguments.length;
    var method, target;

    if (length === 1) {
      method = arguments[0];
      target = null;
    } else {
      target = arguments[0];
      method = arguments[1];
    }

    if (isString(method)) {
      method = target[method];
    }

    if (length === 1) {
      return method();
    } else if (length === 2) {
      return method.call(target);
    } else {
      var args = new Array(length - 2);
      for (var i = 0, l = length - 2; i < l; i++) {
        args[i] = arguments[i + 2];
      }
      return method.apply(target, args);
    }
  },


  /*
    Defer the passed function to run inside the specified queue.

    @method defer
    @param {String} queueName
    @param {Object} target
    @param {Function|String} method The method or method name to be executed
    @param {any} args The method arguments
    @return method result
  */
  defer: function(queueName /* , target, method, args */) {
    var length = arguments.length;
    var method, target, args;

    if (length === 2) {
      method = arguments[1];
      target = null;
    } else {
      target = arguments[1];
      method = arguments[2];
    }

    if (isString(method)) {
      method = target[method];
    }

    var stack = this.DEBUG ? new Error() : undefined;

    if (length > 3) {
      args = new Array(length - 3);
      for (var i = 3; i < length; i++) {
        args[i-3] = arguments[i];
      }
    } else {
      args = undefined;
    }

    if (!this.currentInstance) { createAutorun(this); }
    return this.currentInstance.schedule(queueName, target, method, args, false, stack);
  },

  deferOnce: function(queueName /* , target, method, args */) {
    var length = arguments.length;
    var method, target, args;

    if (length === 2) {
      method = arguments[1];
      target = null;
    } else {
      target = arguments[1];
      method = arguments[2];
    }

    if (isString(method)) {
      method = target[method];
    }

    var stack = this.DEBUG ? new Error() : undefined;

    if (length > 3) {
      args = new Array(length - 3);
      for (var i = 3; i < length; i++) {
        args[i-3] = arguments[i];
      }
    } else {
      args = undefined;
    }

    if (!this.currentInstance) {
      createAutorun(this);
    }
    return this.currentInstance.schedule(queueName, target, method, args, true, stack);
  },

  setTimeout: function() {
    var l = arguments.length;
    var args = new Array(l);

    for (var x = 0; x < l; x++) {
      args[x] = arguments[x];
    }

    var length = args.length,
        method, wait, target,
        methodOrTarget, methodOrWait, methodOrArgs;

    if (length === 0) {
      return;
    } else if (length === 1) {
      method = args.shift();
      wait = 0;
    } else if (length === 2) {
      methodOrTarget = args[0];
      methodOrWait = args[1];

      if (isFunction(methodOrWait) || isFunction(methodOrTarget[methodOrWait])) {
        target = args.shift();
        method = args.shift();
        wait = 0;
      } else if (isCoercableNumber(methodOrWait)) {
        method = args.shift();
        wait = args.shift();
      } else {
        method = args.shift();
        wait =  0;
      }
    } else {
      var last = args[args.length - 1];

      if (isCoercableNumber(last)) {
        wait = args.pop();
      } else {
        wait = 0;
      }

      methodOrTarget = args[0];
      methodOrArgs = args[1];

      if (isFunction(methodOrArgs) || (isString(methodOrArgs) &&
                                      methodOrTarget !== null &&
                                      methodOrArgs in methodOrTarget)) {
        target = args.shift();
        method = args.shift();
      } else {
        method = args.shift();
      }
    }

    var executeAt = Date.now() + parseInt(wait !== wait ? 0 : wait, 10);

    if (isString(method)) {
      method = target[method];
    }

    var onError = getOnError(this.options);

    function fn() {
      if (onError) {
        try {
          method.apply(target, args);
        } catch (e) {
          onError(e);
        }
      } else {
        method.apply(target, args);
      }
    }

    return this._setTimeout(fn, executeAt);
  },

  _setTimeout: function (fn, executeAt) {
    if (this._timers.length === 0) {
      this._timers.push(executeAt, fn);
      this._installTimerTimeout();
      return fn;
    }

    // find position to insert
    var i = binarySearch(executeAt, this._timers);

    this._timers.splice(i, 0, executeAt, fn);

    // we should be the new earliest timer if i == 0
    if (i === 0) {
      this._reinstallTimerTimeout();
    }

    return fn;
  },

  throttle: function(target, method /* , args, wait, [immediate] */) {
    var backburner = this;
    var args = new Array(arguments.length);
    for (var i = 0; i < arguments.length; i++) {
      args[i] = arguments[i];
    }
    var immediate = args.pop();
    var wait, throttler, index, timer;

    if (isNumber(immediate) || isString(immediate)) {
      wait = immediate;
      immediate = true;
    } else {
      wait = args.pop();
    }

    wait = parseInt(wait, 10);

    index = findThrottler(target, method, this._throttlers);
    if (index > -1) { return this._throttlers[index]; } // throttled

    timer = this._platform.setTimeout(function() {
      if (!immediate) {
        backburner.run.apply(backburner, args);
      }
      var index = findThrottler(target, method, backburner._throttlers);
      if (index > -1) {
        backburner._throttlers.splice(index, 1);
      }
    }, wait);

    if (immediate) {
      this.run.apply(this, args);
    }

    throttler = [target, method, timer];

    this._throttlers.push(throttler);

    return throttler;
  },

  debounce: function(target, method /* , args, wait, [immediate] */) {
    var backburner = this;
    var args = new Array(arguments.length);
    for (var i = 0; i < arguments.length; i++) {
      args[i] = arguments[i];
    }

    var immediate = args.pop();
    var wait, index, debouncee, timer;

    if (isNumber(immediate) || isString(immediate)) {
      wait = immediate;
      immediate = false;
    } else {
      wait = args.pop();
    }

    wait = parseInt(wait, 10);
    // Remove debouncee
    index = findDebouncee(target, method, this._debouncees);

    if (index > -1) {
      debouncee = this._debouncees[index];
      this._debouncees.splice(index, 1);
      this._platform.clearTimeout(debouncee[2]);
    }

    timer = this._platform.setTimeout(function() {
      if (!immediate) {
        backburner.run.apply(backburner, args);
      }
      var index = findDebouncee(target, method, backburner._debouncees);
      if (index > -1) {
        backburner._debouncees.splice(index, 1);
      }
    }, wait);

    if (immediate && index === -1) {
      backburner.run.apply(backburner, args);
    }

    debouncee = [
      target,
      method,
      timer
    ];

    backburner._debouncees.push(debouncee);

    return debouncee;
  },

  cancelTimers: function() {
    each(this._throttlers, this._boundClearItems);
    this._throttlers = [];

    each(this._debouncees, this._boundClearItems);
    this._debouncees = [];

    this._clearTimerTimeout();
    this._timers = [];

    if (this._autorun) {
      this._platform.clearTimeout(this._autorun);
      this._autorun = null;
    }
  },

  hasTimers: function() {
    return !!this._timers.length || !!this._debouncees.length || !!this._throttlers.length || this._autorun;
  },

  cancel: function (timer) {
    var timerType = typeof timer;

    if (timer && timerType === 'object' && timer.queue && timer.method) { // we're cancelling a deferOnce
      return timer.queue.cancel(timer);
    } else if (timerType === 'function') { // we're cancelling a setTimeout
      for (var i = 0, l = this._timers.length; i < l; i += 2) {
        if (this._timers[i + 1] === timer) {
          this._timers.splice(i, 2); // remove the two elements
          if (i === 0) {
            this._reinstallTimerTimeout();
          }
          return true;
        }
      }
    } else if (Object.prototype.toString.call(timer) === '[object Array]'){ // we're cancelling a throttle or debounce
      return this._cancelItem(findThrottler, this._throttlers, timer) ||
               this._cancelItem(findDebouncee, this._debouncees, timer);
    } else {
      return; // timer was null or not a timer
    }
  },

  _cancelItem: function(findMethod, array, timer){
    var item, index;

    if (timer.length < 3) { return false; }

    index = findMethod(timer[0], timer[1], array);

    if (index > -1) {

      item = array[index];

      if (item[2] === timer[2]) {
        array.splice(index, 1);
        this._platform.clearTimeout(timer[2]);
        return true;
      }
    }

    return false;
  },

  _runExpiredTimers: function () {
    this._timerTimeoutId = undefined;
    this.run(this, this._scheduleExpiredTimers);
  },

  _scheduleExpiredTimers: function () {
    var n = Date.now();
    var timers = this._timers;
    var i = 0;
    var l = timers.length;
    for (; i < l; i += 2) {
      var executeAt = timers[i];
      var fn = timers[i+1];
      if (executeAt <= n) {
        this.schedule(this.options.defaultQueue, null, fn);
      } else {
        break;
      }
    }
    timers.splice(0, i);
    this._installTimerTimeout();
  },

  _reinstallTimerTimeout: function () {
    this._clearTimerTimeout();
    this._installTimerTimeout();
  },

  _clearTimerTimeout: function () {
    if (!this._timerTimeoutId) {
      return;
    }
    this._platform.clearTimeout(this._timerTimeoutId);
    this._timerTimeoutId = undefined;
  },

  _installTimerTimeout: function () {
    if (!this._timers.length) {
      return;
    }
    var minExpiresAt = this._timers[0];
    var n = Date.now();
    var wait = Math.max(0, minExpiresAt - n);
    this._timerTimeoutId = this._platform.setTimeout(this._boundRunExpiredTimers, wait);
  }
};

Backburner.prototype.schedule = Backburner.prototype.defer;
Backburner.prototype.scheduleOnce = Backburner.prototype.deferOnce;
Backburner.prototype.later = Backburner.prototype.setTimeout;

function getOnError(options) {
  return options.onError || (options.onErrorTarget && options.onErrorTarget[options.onErrorMethod]);
}

function createAutorun(backburner) {
  var setTimeout = backburner._platform.setTimeout;
  backburner.begin();
  backburner._autorun = setTimeout(function() {
    backburner._autorun = null;
    backburner.end();
  }, 0);
}

function findDebouncee(target, method, debouncees) {
  return findItem(target, method, debouncees);
}

function findThrottler(target, method, throttlers) {
  return findItem(target, method, throttlers);
}

function findItem(target, method, collection) {
  var item;
  var index = -1;

  for (var i = 0, l = collection.length; i < l; i++) {
    item = collection[i];
    if (item[0] === target && item[1] === method) {
      index = i;
      break;
    }
  }

  return index;
}

function clearItems(item) {
  this._platform.clearTimeout(item[2]);
}

exports['default'] = Backburner;

Object.defineProperty(exports, '__esModule', { value: true });

});
enifed('ember-console/index', ['exports', 'ember-environment'], function (exports, _emberEnvironment) {
  'use strict';

  function K() {}

  function consoleMethod(name) {
    var consoleObj = undefined;
    if (_emberEnvironment.context.imports.console) {
      consoleObj = _emberEnvironment.context.imports.console;
    } else if (typeof console !== 'undefined') {
      consoleObj = console;
    }

    var method = typeof consoleObj === 'object' ? consoleObj[name] : null;

    if (typeof method !== 'function') {
      return;
    }

    if (typeof method.bind === 'function') {
      return method.bind(consoleObj);
    }

    return function () {
      method.apply(consoleObj, arguments);
    };
  }

  function assertPolyfill(test, message) {
    if (!test) {
      try {
        // attempt to preserve the stack
        throw new Error('assertion failed: ' + message);
      } catch (error) {
        setTimeout(function () {
          throw error;
        }, 0);
      }
    }
  }

  /**
    Inside Ember-Metal, simply uses the methods from `imports.console`.
    Override this to provide more robust logging functionality.
  
    @class Logger
    @namespace Ember
    @public
  */
  exports.default = {
    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.log('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method log
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    log: consoleMethod('log') || K,

    /**
     Prints the arguments to the console with a warning icon.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.warn('Something happened!');
      // "Something happened!" will be printed to the console with a warning icon.
      ```
      @method warn
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    warn: consoleMethod('warn') || K,

    /**
     Prints the arguments to the console with an error icon, red text and a stack trace.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.error('Danger! Danger!');
      // "Danger! Danger!" will be printed to the console in red text.
      ```
      @method error
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    error: consoleMethod('error') || K,

    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.info('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method info
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    info: consoleMethod('info') || K,

    /**
     Logs the arguments to the console in blue text.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.debug('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method debug
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    debug: consoleMethod('debug') || consoleMethod('info') || K,

    /**
     If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.
       ```javascript
      Ember.Logger.assert(true); // undefined
      Ember.Logger.assert(true === false); // Throws an Assertion failed error.
      Ember.Logger.assert(true === false, 'Something invalid'); // Throws an Assertion failed error with message.
      ```
      @method assert
     @for Ember.Logger
     @param {Boolean} bool Value to test
     @param {String} message Assertion message on failed
     @public
    */
    assert: consoleMethod('assert') || assertPolyfill
  };
});
enifed('ember-debug/deprecate', ['exports', 'ember-metal', 'ember-console', 'ember-environment', 'ember-debug/handlers'], function (exports, _emberMetal, _emberConsole, _emberEnvironment, _emberDebugHandlers) {
  /*global __fail__*/

  'use strict';

  exports.registerHandler = registerHandler;
  exports.default = deprecate;

  function registerHandler(handler) {
    _emberDebugHandlers.registerHandler('deprecate', handler);
  }

  function formatMessage(_message, options) {
    var message = _message;

    if (options && options.id) {
      message = message + (' [deprecation id: ' + options.id + ']');
    }

    if (options && options.url) {
      message += ' See ' + options.url + ' for more details.';
    }

    return message;
  }

  registerHandler(function logDeprecationToConsole(message, options) {
    var updatedMessage = formatMessage(message, options);

    _emberConsole.default.warn('DEPRECATION: ' + updatedMessage);
  });

  var captureErrorForStack = undefined;

  if (new Error().stack) {
    captureErrorForStack = function () {
      return new Error();
    };
  } else {
    captureErrorForStack = function () {
      try {
        __fail__.fail();
      } catch (e) {
        return e;
      }
    };
  }

  registerHandler(function logDeprecationStackTrace(message, options, next) {
    if (_emberEnvironment.ENV.LOG_STACKTRACE_ON_DEPRECATION) {
      var stackStr = '';
      var error = captureErrorForStack();
      var stack = undefined;

      if (error.stack) {
        if (error['arguments']) {
          // Chrome
          stack = error.stack.replace(/^\s+at\s+/gm, '').replace(/^([^\(]+?)([\n$])/gm, '{anonymous}($1)$2').replace(/^Object.<anonymous>\s*\(([^\)]+)\)/gm, '{anonymous}($1)').split('\n');
          stack.shift();
        } else {
          // Firefox
          stack = error.stack.replace(/(?:\n@:0)?\s+$/m, '').replace(/^\(/gm, '{anonymous}(').split('\n');
        }

        stackStr = '\n    ' + stack.slice(2).join('\n    ');
      }

      var updatedMessage = formatMessage(message, options);

      _emberConsole.default.warn('DEPRECATION: ' + updatedMessage + stackStr);
    } else {
      next.apply(undefined, arguments);
    }
  });

  registerHandler(function raiseOnDeprecation(message, options, next) {
    if (_emberEnvironment.ENV.RAISE_ON_DEPRECATION) {
      var updatedMessage = formatMessage(message);

      throw new _emberMetal.Error(updatedMessage);
    } else {
      next.apply(undefined, arguments);
    }
  });

  var missingOptionsDeprecation = 'When calling `Ember.deprecate` you ' + 'must provide an `options` hash as the third parameter.  ' + '`options` should include `id` and `until` properties.';
  exports.missingOptionsDeprecation = missingOptionsDeprecation;
  var missingOptionsIdDeprecation = 'When calling `Ember.deprecate` you must provide `id` in options.';
  exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation;
  var missingOptionsUntilDeprecation = 'When calling `Ember.deprecate` you must provide `until` in options.';

  exports.missingOptionsUntilDeprecation = missingOptionsUntilDeprecation;
  /**
  @module ember
  @submodule ember-debug
  */

  /**
    Display a deprecation warning with the provided message and a stack trace
    (Chrome and Firefox only).
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    @method deprecate
    @param {String} message A description of the deprecation.
    @param {Boolean} test A boolean. If falsy, the deprecation will be displayed.
    @param {Object} options
    @param {String} options.id A unique id for this deprecation. The id can be
      used by Ember debugging tools to change the behavior (raise, log or silence)
      for that specific deprecation. The id should be namespaced by dots, e.g.
      "view.helper.select".
    @param {string} options.until The version of Ember when this deprecation
      warning will be removed.
    @param {String} [options.url] An optional url to the transition guide on the
      emberjs.com website.
    @for Ember
    @public
  */

  function deprecate(message, test, options) {
    if (!options || !options.id && !options.until) {
      deprecate(missingOptionsDeprecation, false, {
        id: 'ember-debug.deprecate-options-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    if (options && !options.id) {
      deprecate(missingOptionsIdDeprecation, false, {
        id: 'ember-debug.deprecate-id-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    if (options && !options.until) {
      deprecate(missingOptionsUntilDeprecation, options && options.until, {
        id: 'ember-debug.deprecate-until-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    _emberDebugHandlers.invoke.apply(undefined, ['deprecate'].concat(babelHelpers.slice.call(arguments)));
  }
});
enifed("ember-debug/handlers", ["exports"], function (exports) {
  "use strict";

  exports.registerHandler = registerHandler;
  exports.invoke = invoke;
  var HANDLERS = {};

  exports.HANDLERS = HANDLERS;

  function registerHandler(type, callback) {
    var nextHandler = HANDLERS[type] || function () {};

    HANDLERS[type] = function (message, options) {
      callback(message, options, nextHandler);
    };
  }

  function invoke(type, message, test, options) {
    if (test) {
      return;
    }

    var handlerForType = HANDLERS[type];

    if (!handlerForType) {
      return;
    }

    if (handlerForType) {
      handlerForType(message, options);
    }
  }
});
enifed('ember-debug/index', ['exports', 'ember-metal', 'ember-environment', 'ember-console', 'ember-debug/deprecate', 'ember-debug/warn'], function (exports, _emberMetal, _emberEnvironment, _emberConsole, _emberDebugDeprecate, _emberDebugWarn) {
  'use strict';

  exports._warnIfUsingStrippedFeatureFlags = _warnIfUsingStrippedFeatureFlags;

  /**
  @module ember
  @submodule ember-debug
  */

  /**
  @class Ember
  @public
  */

  /**
    Define an assertion that will throw an exception if the condition is not met.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    ```javascript
    // Test for truthiness
    Ember.assert('Must pass a valid object', obj);
  
    // Fail unconditionally
    Ember.assert('This code path should never be run');
    ```
  
    @method assert
    @param {String} desc A description of the assertion. This will become
      the text of the Error thrown if the assertion fails.
    @param {Boolean} test Must be truthy for the assertion to pass. If
      falsy, an exception will be thrown.
    @public
  */
  _emberMetal.setDebugFunction('assert', function assert(desc, test) {
    if (!test) {
      throw new _emberMetal.Error('Assertion Failed: ' + desc);
    }
  });

  /**
    Display a debug notice.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    ```javascript
    Ember.debug('I\'m a debug notice!');
    ```
  
    @method debug
    @param {String} message A debug message to display.
    @public
  */
  _emberMetal.setDebugFunction('debug', function debug(message) {
    _emberConsole.default.debug('DEBUG: ' + message);
  });

  /**
    Display an info notice.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    @method info
    @private
  */
  _emberMetal.setDebugFunction('info', function info() {
    _emberConsole.default.info.apply(undefined, arguments);
  });

  /**
    Alias an old, deprecated method with its new counterpart.
  
    Display a deprecation warning with the provided message and a stack trace
    (Chrome and Firefox only) when the assigned method is called.
  
    * In a production build, this method is defined as an empty function (NOP).
  
    ```javascript
    Ember.oldMethod = Ember.deprecateFunc('Please use the new, updated method', Ember.newMethod);
    ```
  
    @method deprecateFunc
    @param {String} message A description of the deprecation.
    @param {Object} [options] The options object for Ember.deprecate.
    @param {Function} func The new function called to replace its deprecated counterpart.
    @return {Function} A new function that wraps the original function with a deprecation warning
    @private
  */
  _emberMetal.setDebugFunction('deprecateFunc', function deprecateFunc() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    if (args.length === 3) {
      var _ret = (function () {
        var message = args[0];
        var options = args[1];
        var func = args[2];

        return {
          v: function () {
            _emberMetal.deprecate(message, false, options);
            return func.apply(this, arguments);
          }
        };
      })();

      if (typeof _ret === 'object') return _ret.v;
    } else {
      var _ret2 = (function () {
        var message = args[0];
        var func = args[1];

        return {
          v: function () {
            _emberMetal.deprecate(message);
            return func.apply(this, arguments);
          }
        };
      })();

      if (typeof _ret2 === 'object') return _ret2.v;
    }
  });

  /**
    Run a function meant for debugging.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    ```javascript
    Ember.runInDebug(() => {
      Ember.Component.reopen({
        didInsertElement() {
          console.log("I'm happy");
        }
      });
    });
    ```
  
    @method runInDebug
    @param {Function} func The function to be executed.
    @since 1.5.0
    @public
  */
  _emberMetal.setDebugFunction('runInDebug', function runInDebug(func) {
    func();
  });

  _emberMetal.setDebugFunction('debugSeal', function debugSeal(obj) {
    Object.seal(obj);
  });

  _emberMetal.setDebugFunction('debugFreeze', function debugFreeze(obj) {
    Object.freeze(obj);
  });

  _emberMetal.setDebugFunction('deprecate', _emberDebugDeprecate.default);

  _emberMetal.setDebugFunction('warn', _emberDebugWarn.default);

  /**
    Will call `Ember.warn()` if ENABLE_OPTIONAL_FEATURES or
    any specific FEATURES flag is truthy.
  
    This method is called automatically in debug canary builds.
  
    @private
    @method _warnIfUsingStrippedFeatureFlags
    @return {void}
  */

  function _warnIfUsingStrippedFeatureFlags(FEATURES, knownFeatures, featuresWereStripped) {
    if (featuresWereStripped) {
      _emberMetal.warn('Ember.ENV.ENABLE_OPTIONAL_FEATURES is only available in canary builds.', !_emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES, { id: 'ember-debug.feature-flag-with-features-stripped' });

      var keys = Object.keys(FEATURES || {});
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        if (key === 'isEnabled' || !(key in knownFeatures)) {
          continue;
        }

        _emberMetal.warn('FEATURE["' + key + '"] is set as enabled, but FEATURE flags are only available in canary builds.', !FEATURES[key], { id: 'ember-debug.feature-flag-with-features-stripped' });
      }
    }
  }

  if (!_emberMetal.isTesting()) {
    (function () {
      // Complain if they're using FEATURE flags in builds other than canary
      _emberMetal.FEATURES['features-stripped-test'] = true;
      var featuresWereStripped = true;

      if (false) {
        featuresWereStripped = false;
      }

      delete _emberMetal.FEATURES['features-stripped-test'];
      _warnIfUsingStrippedFeatureFlags(_emberEnvironment.ENV.FEATURES, _emberMetal.DEFAULT_FEATURES, featuresWereStripped);

      // Inform the developer about the Ember Inspector if not installed.
      var isFirefox = _emberEnvironment.environment.isFirefox;
      var isChrome = _emberEnvironment.environment.isChrome;

      if (typeof window !== 'undefined' && (isFirefox || isChrome) && window.addEventListener) {
        window.addEventListener('load', function () {
          if (document.documentElement && document.documentElement.dataset && !document.documentElement.dataset.emberExtension) {
            var downloadURL;

            if (isChrome) {
              downloadURL = 'https://chrome.google.com/webstore/detail/ember-inspector/bmdblncegkenkacieihfhpjfppoconhi';
            } else if (isFirefox) {
              downloadURL = 'https://addons.mozilla.org/en-US/firefox/addon/ember-inspector/';
            }

            _emberMetal.debug('For more advanced debugging, install the Ember Inspector from ' + downloadURL);
          }
        }, false);
      }
    })();
  }
  /**
    @public
    @class Ember.Debug
  */
  _emberMetal.default.Debug = {};

  /**
    Allows for runtime registration of handler functions that override the default deprecation behavior.
    Deprecations are invoked by calls to [Ember.deprecate](http://emberjs.com/api/classes/Ember.html#method_deprecate).
    The following example demonstrates its usage by registering a handler that throws an error if the
    message contains the word "should", otherwise defers to the default handler.
  
    ```javascript
    Ember.Debug.registerDeprecationHandler((message, options, next) => {
      if (message.indexOf('should') !== -1) {
        throw new Error(`Deprecation message with should: ${message}`);
      } else {
        // defer to whatever handler was registered before this one
        next(message, options);
      }
    });
    ```
  
    The handler function takes the following arguments:
  
    <ul>
      <li> <code>message</code> - The message received from the deprecation call.</li>
      <li> <code>options</code> - An object passed in with the deprecation call containing additional information including:</li>
        <ul>
          <li> <code>id</code> - An id of the deprecation in the form of <code>package-name.specific-deprecation</code>.</li>
          <li> <code>until</code> - The Ember version number the feature and deprecation will be removed in.</li>
        </ul>
      <li> <code>next</code> - A function that calls into the previously registered handler.</li>
    </ul>
  
    @public
    @static
    @method registerDeprecationHandler
    @param handler {Function} A function to handle deprecation calls.
    @since 2.1.0
  */
  _emberMetal.default.Debug.registerDeprecationHandler = _emberDebugDeprecate.registerHandler;
  /**
    Allows for runtime registration of handler functions that override the default warning behavior.
    Warnings are invoked by calls made to [Ember.warn](http://emberjs.com/api/classes/Ember.html#method_warn).
    The following example demonstrates its usage by registering a handler that does nothing overriding Ember's
    default warning behavior.
  
    ```javascript
    // next is not called, so no warnings get the default behavior
    Ember.Debug.registerWarnHandler(() => {});
    ```
  
    The handler function takes the following arguments:
  
    <ul>
      <li> <code>message</code> - The message received from the warn call. </li>
      <li> <code>options</code> - An object passed in with the warn call containing additional information including:</li>
        <ul>
          <li> <code>id</code> - An id of the warning in the form of <code>package-name.specific-warning</code>.</li>
        </ul>
      <li> <code>next</code> - A function that calls into the previously registered handler.</li>
    </ul>
  
    @public
    @static
    @method registerWarnHandler
    @param handler {Function} A function to handle warnings.
    @since 2.1.0
  */
  _emberMetal.default.Debug.registerWarnHandler = _emberDebugWarn.registerHandler;

  /*
    We are transitioning away from `ember.js` to `ember.debug.js` to make
    it much clearer that it is only for local development purposes.
  
    This flag value is changed by the tooling (by a simple string replacement)
    so that if `ember.js` (which must be output for backwards compat reasons) is
    used a nice helpful warning message will be printed out.
  */
  var runningNonEmberDebugJS = false;
  exports.runningNonEmberDebugJS = runningNonEmberDebugJS;
  if (runningNonEmberDebugJS) {
    _emberMetal.warn('Please use `ember.debug.js` instead of `ember.js` for development and debugging.');
  }
});
// reexports
enifed('ember-debug/warn', ['exports', 'ember-console', 'ember-metal', 'ember-debug/handlers'], function (exports, _emberConsole, _emberMetal, _emberDebugHandlers) {
  'use strict';

  exports.registerHandler = registerHandler;
  exports.default = warn;

  function registerHandler(handler) {
    _emberDebugHandlers.registerHandler('warn', handler);
  }

  registerHandler(function logWarning(message, options) {
    _emberConsole.default.warn('WARNING: ' + message);
    if ('trace' in _emberConsole.default) {
      _emberConsole.default.trace();
    }
  });

  var missingOptionsDeprecation = 'When calling `Ember.warn` you ' + 'must provide an `options` hash as the third parameter.  ' + '`options` should include an `id` property.';
  exports.missingOptionsDeprecation = missingOptionsDeprecation;
  var missingOptionsIdDeprecation = 'When calling `Ember.warn` you must provide `id` in options.';

  exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation;
  /**
  @module ember
  @submodule ember-debug
  */

  /**
    Display a warning with the provided message.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    @method warn
    @param {String} message A warning to display.
    @param {Boolean} test An optional boolean. If falsy, the warning
      will be displayed.
    @param {Object} options An object that can be used to pass a unique
      `id` for this warning.  The `id` can be used by Ember debugging tools
      to change the behavior (raise, log, or silence) for that specific warning.
      The `id` should be namespaced by dots, e.g. "ember-debug.feature-flag-with-features-stripped"
    @for Ember
    @public
  */

  function warn(message, test, options) {
    if (!options) {
      _emberMetal.deprecate(missingOptionsDeprecation, false, {
        id: 'ember-debug.warn-options-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    if (options && !options.id) {
      _emberMetal.deprecate(missingOptionsIdDeprecation, false, {
        id: 'ember-debug.warn-id-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    _emberDebugHandlers.invoke.apply(undefined, ['warn'].concat(babelHelpers.slice.call(arguments)));
  }
});
enifed('ember-environment/global', ['exports'], function (exports) {
  /* globals global, window, self, mainContext */

  // from lodash to catch fake globals
  'use strict';

  function checkGlobal(value) {
    return value && value.Object === Object ? value : undefined;
  }

  // element ids can ruin global miss checks
  function checkElementIdShadowing(value) {
    return value && value.nodeType === undefined ? value : undefined;
  }

  // export real global
  exports.default = checkGlobal(checkElementIdShadowing(typeof global === 'object' && global)) || checkGlobal(typeof self === 'object' && self) || checkGlobal(typeof window === 'object' && window) || mainContext || // set before strict mode in Ember loader/wrapper
  new Function('return this')();
  // eval outside of strict mode
});
enifed('ember-environment/index', ['exports', 'ember-environment/global', 'ember-environment/utils'], function (exports, _emberEnvironmentGlobal, _emberEnvironmentUtils) {
  /* globals module */
  'use strict';

  /**
    The hash of environment variables used to control various configuration
    settings. To specify your own or override default settings, add the
    desired properties to a global hash named `EmberENV` (or `ENV` for
    backwards compatibility with earlier versions of Ember). The `EmberENV`
    hash must be created before loading Ember.
  
    @class EmberENV
    @type Object
    @public
  */
  var ENV = typeof _emberEnvironmentGlobal.default.EmberENV === 'object' && _emberEnvironmentGlobal.default.EmberENV || typeof _emberEnvironmentGlobal.default.ENV === 'object' && _emberEnvironmentGlobal.default.ENV || {};

  exports.ENV = ENV;
  // ENABLE_ALL_FEATURES was documented, but you can't actually enable non optional features.
  if (ENV.ENABLE_ALL_FEATURES) {
    ENV.ENABLE_OPTIONAL_FEATURES = true;
  }

  /**
    Determines whether Ember should add to `Array`, `Function`, and `String`
    native object prototypes, a few extra methods in order to provide a more
    friendly API.
  
    We generally recommend leaving this option set to true however, if you need
    to turn it off, you can add the configuration property
    `EXTEND_PROTOTYPES` to `EmberENV` and set it to `false`.
  
    Note, when disabled (the default configuration for Ember Addons), you will
    instead have to access all methods and functions from the Ember
    namespace.
  
    @property EXTEND_PROTOTYPES
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.EXTEND_PROTOTYPES = _emberEnvironmentUtils.normalizeExtendPrototypes(ENV.EXTEND_PROTOTYPES);

  /**
    The `LOG_STACKTRACE_ON_DEPRECATION` property, when true, tells Ember to log
    a full stack trace during deprecation warnings.
  
    @property LOG_STACKTRACE_ON_DEPRECATION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_STACKTRACE_ON_DEPRECATION = _emberEnvironmentUtils.defaultTrue(ENV.LOG_STACKTRACE_ON_DEPRECATION);

  /**
    The `LOG_VERSION` property, when true, tells Ember to log versions of all
    dependent libraries in use.
  
    @property LOG_VERSION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_VERSION = _emberEnvironmentUtils.defaultTrue(ENV.LOG_VERSION);

  // default false
  ENV.MODEL_FACTORY_INJECTIONS = _emberEnvironmentUtils.defaultFalse(ENV.MODEL_FACTORY_INJECTIONS);

  /**
    Debug parameter you can turn on. This will log all bindings that fire to
    the console. This should be disabled in production code. Note that you
    can also enable this from the console or temporarily.
  
    @property LOG_BINDINGS
    @for EmberENV
    @type Boolean
    @default false
    @public
  */
  ENV.LOG_BINDINGS = _emberEnvironmentUtils.defaultFalse(ENV.LOG_BINDINGS);

  ENV.RAISE_ON_DEPRECATION = _emberEnvironmentUtils.defaultFalse(ENV.RAISE_ON_DEPRECATION);

  // check if window exists and actually is the global
  var hasDOM = typeof window !== 'undefined' && window === _emberEnvironmentGlobal.default && window.document && window.document.createElement && !ENV.disableBrowserEnvironment; // is this a public thing?

  // legacy imports/exports/lookup stuff (should we keep this??)
  var originalContext = _emberEnvironmentGlobal.default.Ember || {};

  var context = {
    // import jQuery
    imports: originalContext.imports || _emberEnvironmentGlobal.default,
    // export Ember
    exports: originalContext.exports || _emberEnvironmentGlobal.default,
    // search for Namespaces
    lookup: originalContext.lookup || _emberEnvironmentGlobal.default
  };

  exports.context = context;
  // TODO: cleanup single source of truth issues with this stuff
  var environment = hasDOM ? {
    hasDOM: true,
    isChrome: !!window.chrome && !window.opera,
    isFirefox: typeof InstallTrigger !== 'undefined',
    isPhantom: !!window.callPhantom,
    location: window.location,
    history: window.history,
    userAgent: window.navigator.userAgent,
    window: window
  } : {
    hasDOM: false,
    isChrome: false,
    isFirefox: false,
    isPhantom: false,
    location: null,
    history: null,
    userAgent: 'Lynx (textmode)',
    window: null
  };
  exports.environment = environment;
});
enifed("ember-environment/utils", ["exports"], function (exports) {
  "use strict";

  exports.defaultTrue = defaultTrue;
  exports.defaultFalse = defaultFalse;
  exports.normalizeExtendPrototypes = normalizeExtendPrototypes;

  function defaultTrue(v) {
    return v === false ? false : true;
  }

  function defaultFalse(v) {
    return v === true ? true : false;
  }

  function normalizeExtendPrototypes(obj) {
    if (obj === false) {
      return { String: false, Array: false, Function: false };
    } else if (!obj || obj === true) {
      return { String: true, Array: true, Function: true };
    } else {
      return {
        String: defaultTrue(obj.String),
        Array: defaultTrue(obj.Array),
        Function: defaultTrue(obj.Function)
      };
    }
  }
});
enifed('ember-metal/alias', ['exports', 'ember-utils', 'ember-metal/debug', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/error', 'ember-metal/properties', 'ember-metal/computed', 'ember-metal/meta', 'ember-metal/dependent_keys'], function (exports, _emberUtils, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalError, _emberMetalProperties, _emberMetalComputed, _emberMetalMeta, _emberMetalDependent_keys) {
  'use strict';

  exports.default = alias;
  exports.AliasedProperty = AliasedProperty;

  function alias(altKey) {
    return new AliasedProperty(altKey);
  }

  function AliasedProperty(altKey) {
    this.isDescriptor = true;
    this.altKey = altKey;
    this._dependentKeys = [altKey];
  }

  AliasedProperty.prototype = Object.create(_emberMetalProperties.Descriptor.prototype);

  AliasedProperty.prototype.setup = function (obj, keyName) {
    _emberMetalDebug.assert('Setting alias \'' + keyName + '\' on self', this.altKey !== keyName);
    var meta = _emberMetalMeta.meta(obj);
    if (meta.peekWatching(keyName)) {
      _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);
    }
  };

  AliasedProperty.prototype._addDependentKeyIfMissing = function (obj, keyName) {
    var meta = _emberMetalMeta.meta(obj);
    if (!meta.peekDeps(this.altKey, keyName)) {
      _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);
    }
  };

  AliasedProperty.prototype._removeDependentKeyIfAdded = function (obj, keyName) {
    var meta = _emberMetalMeta.meta(obj);
    if (meta.peekDeps(this.altKey, keyName)) {
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
    }
  };

  AliasedProperty.prototype.willWatch = AliasedProperty.prototype._addDependentKeyIfMissing;
  AliasedProperty.prototype.didUnwatch = AliasedProperty.prototype._removeDependentKeyIfAdded;
  AliasedProperty.prototype.teardown = AliasedProperty.prototype._removeDependentKeyIfAdded;

  AliasedProperty.prototype.get = function AliasedProperty_get(obj, keyName) {
    this._addDependentKeyIfMissing(obj, keyName);

    return _emberMetalProperty_get.get(obj, this.altKey);
  };

  AliasedProperty.prototype.set = function AliasedProperty_set(obj, keyName, value) {
    return _emberMetalProperty_set.set(obj, this.altKey, value);
  };

  AliasedProperty.prototype.readOnly = function () {
    this.set = AliasedProperty_readOnlySet;
    return this;
  };

  function AliasedProperty_readOnlySet(obj, keyName, value) {
    throw new _emberMetalError.default('Cannot set read-only property \'' + keyName + '\' on object: ' + _emberUtils.inspect(obj));
  }

  AliasedProperty.prototype.oneWay = function () {
    this.set = AliasedProperty_oneWaySet;
    return this;
  };

  function AliasedProperty_oneWaySet(obj, keyName, value) {
    _emberMetalProperties.defineProperty(obj, keyName, null);
    return _emberMetalProperty_set.set(obj, keyName, value);
  }

  // Backwards compatibility with Ember Data.
  AliasedProperty.prototype._meta = undefined;
  AliasedProperty.prototype.meta = _emberMetalComputed.ComputedProperty.prototype.meta;
});
enifed('ember-metal/binding', ['exports', 'ember-utils', 'ember-console', 'ember-environment', 'ember-metal/run_loop', 'ember-metal/debug', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/events', 'ember-metal/observer', 'ember-metal/path_cache'], function (exports, _emberUtils, _emberConsole, _emberEnvironment, _emberMetalRun_loop, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalEvents, _emberMetalObserver, _emberMetalPath_cache) {
  'use strict';

  exports.bind = bind;

  /**
  @module ember
  @submodule ember-metal
  */

  // ..........................................................
  // BINDING
  //

  function Binding(toPath, fromPath) {
    // Configuration
    this._from = fromPath;
    this._to = toPath;
    this._oneWay = undefined;

    // State
    this._direction = undefined;
    this._readyToSync = undefined;
    this._fromObj = undefined;
    this._fromPath = undefined;
    this._toObj = undefined;
  }

  /**
    @class Binding
    @namespace Ember
    @deprecated See http://emberjs.com/deprecations/v2.x#toc_ember-binding
    @public
  */

  Binding.prototype = {
    /**
      This copies the Binding so it can be connected to another object.
       @method copy
      @return {Ember.Binding} `this`
      @public
    */
    copy: function () {
      var copy = new Binding(this._to, this._from);
      if (this._oneWay) {
        copy._oneWay = true;
      }
      return copy;
    },

    // ..........................................................
    // CONFIG
    //

    /**
      This will set `from` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method from
      @param {String} path The property path to connect to.
      @return {Ember.Binding} `this`
      @public
    */
    from: function (path) {
      this._from = path;
      return this;
    },

    /**
      This will set the `to` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method to
      @param {String|Tuple} path A property path or tuple.
      @return {Ember.Binding} `this`
      @public
    */
    to: function (path) {
      this._to = path;
      return this;
    },

    /**
      Configures the binding as one way. A one-way binding will relay changes
      on the `from` side to the `to` side, but not the other way around. This
      means that if you change the `to` side directly, the `from` side may have
      a different value.
       @method oneWay
      @return {Ember.Binding} `this`
      @public
    */
    oneWay: function () {
      this._oneWay = true;
      return this;
    },

    /**
      @method toString
      @return {String} string representation of binding
      @public
    */
    toString: function () {
      var oneWay = this._oneWay ? '[oneWay]' : '';
      return 'Ember.Binding<' + _emberUtils.guidFor(this) + '>(' + this._from + ' -> ' + this._to + ')' + oneWay;
    },

    // ..........................................................
    // CONNECT AND SYNC
    //

    /**
      Attempts to connect this binding instance so that it can receive and relay
      changes. This method will raise an exception if you have not set the
      from/to properties yet.
       @method connect
      @param {Object} obj The root object for this binding.
      @return {Ember.Binding} `this`
      @public
    */
    connect: function (obj) {
      _emberMetalDebug.assert('Must pass a valid object to Ember.Binding.connect()', !!obj);

      var fromObj = undefined,
          fromPath = undefined,
          possibleGlobal = undefined;

      // If the binding's "from" path could be interpreted as a global, verify
      // whether the path refers to a global or not by consulting `Ember.lookup`.
      if (_emberMetalPath_cache.isGlobalPath(this._from)) {
        var _name = _emberMetalPath_cache.getFirstKey(this._from);
        possibleGlobal = _emberEnvironment.context.lookup[_name];

        if (possibleGlobal) {
          fromObj = possibleGlobal;
          fromPath = _emberMetalPath_cache.getTailPath(this._from);
        }
      }

      if (fromObj === undefined) {
        fromObj = obj;
        fromPath = this._from;
      }

      _emberMetalProperty_set.trySet(obj, this._to, _emberMetalProperty_get.get(fromObj, fromPath));

      // Add an observer on the object to be notified when the binding should be updated.
      _emberMetalObserver.addObserver(fromObj, fromPath, this, 'fromDidChange');

      // If the binding is a two-way binding, also set up an observer on the target.
      if (!this._oneWay) {
        _emberMetalObserver.addObserver(obj, this._to, this, 'toDidChange');
      }

      _emberMetalEvents.addListener(obj, 'willDestroy', this, 'disconnect');

      fireDeprecations(obj, this._to, this._from, possibleGlobal, this._oneWay, !possibleGlobal && !this._oneWay);

      this._readyToSync = true;
      this._fromObj = fromObj;
      this._fromPath = fromPath;
      this._toObj = obj;

      return this;
    },

    /**
      Disconnects the binding instance. Changes will no longer be relayed. You
      will not usually need to call this method.
       @method disconnect
      @return {Ember.Binding} `this`
      @public
    */
    disconnect: function () {
      _emberMetalDebug.assert('Must pass a valid object to Ember.Binding.disconnect()', !!this._toObj);

      // Remove an observer on the object so we're no longer notified of
      // changes that should update bindings.
      _emberMetalObserver.removeObserver(this._fromObj, this._fromPath, this, 'fromDidChange');

      // If the binding is two-way, remove the observer from the target as well.
      if (!this._oneWay) {
        _emberMetalObserver.removeObserver(this._toObj, this._to, this, 'toDidChange');
      }

      this._readyToSync = false; // Disable scheduled syncs...
      return this;
    },

    // ..........................................................
    // PRIVATE
    //

    /* Called when the from side changes. */
    fromDidChange: function (target) {
      this._scheduleSync('fwd');
    },

    /* Called when the to side changes. */
    toDidChange: function (target) {
      this._scheduleSync('back');
    },

    _scheduleSync: function (dir) {
      var existingDir = this._direction;

      // If we haven't scheduled the binding yet, schedule it.
      if (existingDir === undefined) {
        _emberMetalRun_loop.default.schedule('sync', this, '_sync');
        this._direction = dir;
      }

      // If both a 'back' and 'fwd' sync have been scheduled on the same object,
      // default to a 'fwd' sync so that it remains deterministic.
      if (existingDir === 'back' && dir === 'fwd') {
        this._direction = 'fwd';
      }
    },

    _sync: function () {
      var log = _emberEnvironment.ENV.LOG_BINDINGS;

      var toObj = this._toObj;

      // Don't synchronize destroyed objects or disconnected bindings.
      if (toObj.isDestroyed || !this._readyToSync) {
        return;
      }

      // Get the direction of the binding for the object we are
      // synchronizing from.
      var direction = this._direction;

      var fromObj = this._fromObj;
      var fromPath = this._fromPath;

      this._direction = undefined;

      // If we're synchronizing from the remote object...
      if (direction === 'fwd') {
        var fromValue = _emberMetalProperty_get.get(fromObj, fromPath);
        if (log) {
          _emberConsole.default.log(' ', this.toString(), '->', fromValue, fromObj);
        }
        if (this._oneWay) {
          _emberMetalProperty_set.trySet(toObj, this._to, fromValue);
        } else {
          _emberMetalObserver._suspendObserver(toObj, this._to, this, 'toDidChange', function () {
            _emberMetalProperty_set.trySet(toObj, this._to, fromValue);
          });
        }
        // If we're synchronizing *to* the remote object.
      } else if (direction === 'back') {
          var toValue = _emberMetalProperty_get.get(toObj, this._to);
          if (log) {
            _emberConsole.default.log(' ', this.toString(), '<-', toValue, toObj);
          }
          _emberMetalObserver._suspendObserver(fromObj, fromPath, this, 'fromDidChange', function () {
            _emberMetalProperty_set.trySet(fromObj, fromPath, toValue);
          });
        }
    }

  };

  function fireDeprecations(obj, toPath, fromPath, deprecateGlobal, deprecateOneWay, deprecateAlias) {
    var deprecateGlobalMessage = '`Ember.Binding` is deprecated. Since you' + ' are binding to a global consider using a service instead.';
    var deprecateOneWayMessage = '`Ember.Binding` is deprecated. Since you' + ' are using a `oneWay` binding consider using a `readOnly` computed' + ' property instead.';
    var deprecateAliasMessage = '`Ember.Binding` is deprecated. Consider' + ' using an `alias` computed property instead.';

    var objectInfo = 'The `' + toPath + '` property of `' + obj + '` is an `Ember.Binding` connected to `' + fromPath + '`, but ';
    _emberMetalDebug.deprecate(objectInfo + deprecateGlobalMessage, !deprecateGlobal, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
    _emberMetalDebug.deprecate(objectInfo + deprecateOneWayMessage, !deprecateOneWay, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
    _emberMetalDebug.deprecate(objectInfo + deprecateAliasMessage, !deprecateAlias, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
  }

  function mixinProperties(to, from) {
    for (var key in from) {
      if (from.hasOwnProperty(key)) {
        to[key] = from[key];
      }
    }
  }

  mixinProperties(Binding, {

    /*
      See `Ember.Binding.from`.
       @method from
      @static
    */
    from: function (from) {
      var C = this;
      return new C(undefined, from);
    },

    /*
      See `Ember.Binding.to`.
       @method to
      @static
    */
    to: function (to) {
      var C = this;
      return new C(to, undefined);
    }
  });
  /**
    An `Ember.Binding` connects the properties of two objects so that whenever
    the value of one property changes, the other property will be changed also.
  
    ## Automatic Creation of Bindings with `/^*Binding/`-named Properties.
  
    You do not usually create Binding objects directly but instead describe
    bindings in your class or object definition using automatic binding
    detection.
  
    Properties ending in a `Binding` suffix will be converted to `Ember.Binding`
    instances. The value of this property should be a string representing a path
    to another object or a custom binding instance created using Binding helpers
    (see "One Way Bindings"):
  
    ```
    valueBinding: "MyApp.someController.title"
    ```
  
    This will create a binding from `MyApp.someController.title` to the `value`
    property of your object instance automatically. Now the two values will be
    kept in sync.
  
    ## One Way Bindings
  
    One especially useful binding customization you can use is the `oneWay()`
    helper. This helper tells Ember that you are only interested in
    receiving changes on the object you are binding from. For example, if you
    are binding to a preference and you want to be notified if the preference
    has changed, but your object will not be changing the preference itself, you
    could do:
  
    ```
    bigTitlesBinding: Ember.Binding.oneWay("MyApp.preferencesController.bigTitles")
    ```
  
    This way if the value of `MyApp.preferencesController.bigTitles` changes the
    `bigTitles` property of your object will change also. However, if you
    change the value of your `bigTitles` property, it will not update the
    `preferencesController`.
  
    One way bindings are almost twice as fast to setup and twice as fast to
    execute because the binding only has to worry about changes to one side.
  
    You should consider using one way bindings anytime you have an object that
    may be created frequently and you do not intend to change a property; only
    to monitor it for changes (such as in the example above).
  
    ## Adding Bindings Manually
  
    All of the examples above show you how to configure a custom binding, but the
    result of these customizations will be a binding template, not a fully active
    Binding instance. The binding will actually become active only when you
    instantiate the object the binding belongs to. It is useful, however, to
    understand what actually happens when the binding is activated.
  
    For a binding to function it must have at least a `from` property and a `to`
    property. The `from` property path points to the object/key that you want to
    bind from while the `to` path points to the object/key you want to bind to.
  
    When you define a custom binding, you are usually describing the property
    you want to bind from (such as `MyApp.someController.value` in the examples
    above). When your object is created, it will automatically assign the value
    you want to bind `to` based on the name of your binding key. In the
    examples above, during init, Ember objects will effectively call
    something like this on your binding:
  
    ```javascript
    binding = Ember.Binding.from("valueBinding").to("value");
    ```
  
    This creates a new binding instance based on the template you provide, and
    sets the to path to the `value` property of the new object. Now that the
    binding is fully configured with a `from` and a `to`, it simply needs to be
    connected to become active. This is done through the `connect()` method:
  
    ```javascript
    binding.connect(this);
    ```
  
    Note that when you connect a binding you pass the object you want it to be
    connected to. This object will be used as the root for both the from and
    to side of the binding when inspecting relative paths. This allows the
    binding to be automatically inherited by subclassed objects as well.
  
    This also allows you to bind between objects using the paths you declare in
    `from` and `to`:
  
    ```javascript
    // Example 1
    binding = Ember.Binding.from("App.someObject.value").to("value");
    binding.connect(this);
  
    // Example 2
    binding = Ember.Binding.from("parentView.value").to("App.someObject.value");
    binding.connect(this);
    ```
  
    Now that the binding is connected, it will observe both the from and to side
    and relay changes.
  
    If you ever needed to do so (you almost never will, but it is useful to
    understand this anyway), you could manually create an active binding by
    using the `Ember.bind()` helper method. (This is the same method used by
    to setup your bindings on objects):
  
    ```javascript
    Ember.bind(MyApp.anotherObject, "value", "MyApp.someController.value");
    ```
  
    Both of these code fragments have the same effect as doing the most friendly
    form of binding creation like so:
  
    ```javascript
    MyApp.anotherObject = Ember.Object.create({
      valueBinding: "MyApp.someController.value",
  
      // OTHER CODE FOR THIS OBJECT...
    });
    ```
  
    Ember's built in binding creation method makes it easy to automatically
    create bindings for you. You should always use the highest-level APIs
    available, even if you understand how it works underneath.
  
    @class Binding
    @namespace Ember
    @since Ember 0.9
    @public
  */
  // Ember.Binding = Binding; ES6TODO: where to put this?

  /**
    Global helper method to create a new binding. Just pass the root object
    along with a `to` and `from` path to create and connect the binding.
  
    @method bind
    @for Ember
    @param {Object} obj The root object of the transform.
    @param {String} to The path to the 'to' side of the binding.
      Must be relative to obj.
    @param {String} from The path to the 'from' side of the binding.
      Must be relative to obj or a global path.
    @return {Ember.Binding} binding instance
    @public
  */

  function bind(obj, to, from) {
    return new Binding(to, from).connect(obj);
  }

  exports.Binding = Binding;
});
enifed('ember-metal/cache', ['exports', 'ember-utils', 'ember-metal/meta'], function (exports, _emberUtils, _emberMetalMeta) {
  'use strict';

  var Cache = (function () {
    function Cache(limit, func, key, store) {
      babelHelpers.classCallCheck(this, Cache);

      this.size = 0;
      this.misses = 0;
      this.hits = 0;
      this.limit = limit;
      this.func = func;
      this.key = key;
      this.store = store || new DefaultStore();
    }

    Cache.prototype.get = function get(obj) {
      var key = this.key === undefined ? obj : this.key(obj);
      var value = this.store.get(key);
      if (value === undefined) {
        this.misses++;
        value = this._set(key, this.func(obj));
      } else if (value === _emberMetalMeta.UNDEFINED) {
        this.hits++;
        value = undefined;
      } else {
        this.hits++;
        // nothing to translate
      }

      return value;
    };

    Cache.prototype.set = function set(obj, value) {
      var key = this.key === undefined ? obj : this.key(obj);
      return this._set(key, value);
    };

    Cache.prototype._set = function _set(key, value) {
      if (this.limit > this.size) {
        this.size++;
        if (value === undefined) {
          this.store.set(key, _emberMetalMeta.UNDEFINED);
        } else {
          this.store.set(key, value);
        }
      }

      return value;
    };

    Cache.prototype.purge = function purge() {
      this.store.clear();
      this.size = 0;
      this.hits = 0;
      this.misses = 0;
    };

    return Cache;
  })();

  exports.default = Cache;

  var DefaultStore = (function () {
    function DefaultStore() {
      babelHelpers.classCallCheck(this, DefaultStore);

      this.data = new _emberUtils.EmptyObject();
    }

    DefaultStore.prototype.get = function get(key) {
      return this.data[key];
    };

    DefaultStore.prototype.set = function set(key, value) {
      this.data[key] = value;
    };

    DefaultStore.prototype.clear = function clear() {
      this.data = new _emberUtils.EmptyObject();
    };

    return DefaultStore;
  })();
});
enifed('ember-metal/chains', ['exports', 'ember-utils', 'ember-metal/property_get', 'ember-metal/meta', 'ember-metal/watch_key', 'ember-metal/watch_path'], function (exports, _emberUtils, _emberMetalProperty_get, _emberMetalMeta, _emberMetalWatch_key, _emberMetalWatch_path) {
  'use strict';

  exports.finishChains = finishChains;

  var FIRST_KEY = /^([^\.]+)/;

  function firstKey(path) {
    return path.match(FIRST_KEY)[0];
  }

  function isObject(obj) {
    return typeof obj === 'object' && obj;
  }

  function isVolatile(obj) {
    return !(isObject(obj) && obj.isDescriptor && obj._volatile === false);
  }

  function ChainWatchers() {
    // chain nodes that reference a key in this obj by key
    // we only create ChainWatchers when we are going to add them
    // so create this upfront
    this.chains = new _emberUtils.EmptyObject();
  }

  ChainWatchers.prototype = {
    add: function (key, node) {
      var nodes = this.chains[key];
      if (nodes === undefined) {
        this.chains[key] = [node];
      } else {
        nodes.push(node);
      }
    },

    remove: function (key, node) {
      var nodes = this.chains[key];
      if (nodes) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            nodes.splice(i, 1);
            break;
          }
        }
      }
    },

    has: function (key, node) {
      var nodes = this.chains[key];
      if (nodes) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            return true;
          }
        }
      }
      return false;
    },

    revalidateAll: function () {
      for (var key in this.chains) {
        this.notify(key, true, undefined);
      }
    },

    revalidate: function (key) {
      this.notify(key, true, undefined);
    },

    // key: the string key that is part of a path changed
    // revalidate: boolean; the chains that are watching this value should revalidate
    // callback: function that will be called with the object and path that
    //           will be/are invalidated by this key change, depending on
    //           whether the revalidate flag is passed
    notify: function (key, revalidate, callback) {
      var nodes = this.chains[key];
      if (nodes === undefined || nodes.length === 0) {
        return;
      }

      var affected = undefined;

      if (callback) {
        affected = [];
      }

      for (var i = 0; i < nodes.length; i++) {
        nodes[i].notify(revalidate, affected);
      }

      if (callback === undefined) {
        return;
      }

      // we gather callbacks so we don't notify them during revalidation
      for (var i = 0; i < affected.length; i += 2) {
        var obj = affected[i];
        var path = affected[i + 1];
        callback(obj, path);
      }
    }
  };

  function makeChainWatcher() {
    return new ChainWatchers();
  }

  function addChainWatcher(obj, keyName, node) {
    var m = _emberMetalMeta.meta(obj);
    m.writableChainWatchers(makeChainWatcher).add(keyName, node);
    _emberMetalWatch_key.watchKey(obj, keyName, m);
  }

  function removeChainWatcher(obj, keyName, node, _meta) {
    if (!isObject(obj)) {
      return;
    }

    var meta = _meta || _emberMetalMeta.peekMeta(obj);

    if (!meta || !meta.readableChainWatchers()) {
      return;
    }

    // make meta writable
    meta = _emberMetalMeta.meta(obj);

    meta.readableChainWatchers().remove(keyName, node);

    _emberMetalWatch_key.unwatchKey(obj, keyName, meta);
  }

  // A ChainNode watches a single key on an object. If you provide a starting
  // value for the key then the node won't actually watch it. For a root node
  // pass null for parent and key and object for value.
  function ChainNode(parent, key, value) {
    this._parent = parent;
    this._key = key;

    // _watching is true when calling get(this._parent, this._key) will
    // return the value of this node.
    //
    // It is false for the root of a chain (because we have no parent)
    // and for global paths (because the parent node is the object with
    // the observer on it)
    this._watching = value === undefined;

    this._chains = undefined;
    this._object = undefined;
    this.count = 0;

    this._value = value;
    this._paths = {};
    if (this._watching) {
      var obj = parent.value();

      if (!isObject(obj)) {
        return;
      }

      this._object = obj;

      addChainWatcher(this._object, this._key, this);
    }
  }

  function lazyGet(obj, key) {
    if (!isObject(obj)) {
      return;
    }

    var meta = _emberMetalMeta.peekMeta(obj);

    // check if object meant only to be a prototype
    if (meta && meta.proto === obj) {
      return;
    }

    // Use `get` if the return value is an EachProxy or an uncacheable value.
    if (isVolatile(obj[key])) {
      return _emberMetalProperty_get.get(obj, key);
      // Otherwise attempt to get the cached value of the computed property
    } else {
        var cache = meta.readableCache();
        if (cache && key in cache) {
          return cache[key];
        }
      }
  }

  ChainNode.prototype = {
    value: function () {
      if (this._value === undefined && this._watching) {
        var obj = this._parent.value();
        this._value = lazyGet(obj, this._key);
      }
      return this._value;
    },

    destroy: function () {
      if (this._watching) {
        var obj = this._object;
        if (obj) {
          removeChainWatcher(obj, this._key, this);
        }
        this._watching = false; // so future calls do nothing
      }
    },

    // copies a top level object only
    copy: function (obj) {
      var ret = new ChainNode(null, null, obj);
      var paths = this._paths;
      var path = undefined;

      for (path in paths) {
        // this check will also catch non-number vals.
        if (paths[path] <= 0) {
          continue;
        }
        ret.add(path);
      }
      return ret;
    },

    // called on the root node of a chain to setup watchers on the specified
    // path.
    add: function (path) {
      var paths = this._paths;
      paths[path] = (paths[path] || 0) + 1;

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.chain(key, tail);
    },

    // called on the root node of a chain to teardown watcher on the specified
    // path
    remove: function (path) {
      var paths = this._paths;
      if (paths[path] > 0) {
        paths[path]--;
      }

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.unchain(key, tail);
    },

    chain: function (key, path) {
      var chains = this._chains;
      var node = undefined;
      if (chains === undefined) {
        chains = this._chains = new _emberUtils.EmptyObject();
      } else {
        node = chains[key];
      }

      if (node === undefined) {
        node = chains[key] = new ChainNode(this, key, undefined);
      }

      node.count++; // count chains...

      // chain rest of path if there is one
      if (path) {
        key = firstKey(path);
        path = path.slice(key.length + 1);
        node.chain(key, path);
      }
    },

    unchain: function (key, path) {
      var chains = this._chains;
      var node = chains[key];

      // unchain rest of path first...
      if (path && path.length > 1) {
        var nextKey = firstKey(path);
        var nextPath = path.slice(nextKey.length + 1);
        node.unchain(nextKey, nextPath);
      }

      // delete node if needed.
      node.count--;
      if (node.count <= 0) {
        chains[node._key] = undefined;
        node.destroy();
      }
    },

    notify: function (revalidate, affected) {
      if (revalidate && this._watching) {
        var parentValue = this._parent.value();

        if (parentValue !== this._object) {
          if (this._object) {
            removeChainWatcher(this._object, this._key, this);
          }

          if (isObject(parentValue)) {
            this._object = parentValue;
            addChainWatcher(parentValue, this._key, this);
          } else {
            this._object = undefined;
          }
        }
        this._value = undefined;
      }

      // then notify chains...
      var chains = this._chains;
      var node = undefined;
      if (chains) {
        for (var key in chains) {
          node = chains[key];
          if (node !== undefined) {
            node.notify(revalidate, affected);
          }
        }
      }

      if (affected && this._parent) {
        this._parent.populateAffected(this._key, 1, affected);
      }
    },

    populateAffected: function (path, depth, affected) {
      if (this._key) {
        path = this._key + '.' + path;
      }

      if (this._parent) {
        this._parent.populateAffected(path, depth + 1, affected);
      } else {
        if (depth > 1) {
          affected.push(this.value(), path);
        }
      }
    }
  };

  function finishChains(obj) {
    // We only create meta if we really have to
    var m = _emberMetalMeta.peekMeta(obj);
    if (m) {
      m = _emberMetalMeta.meta(obj);

      // finish any current chains node watchers that reference obj
      var chainWatchers = m.readableChainWatchers();
      if (chainWatchers) {
        chainWatchers.revalidateAll();
      }
      // ensure that if we have inherited any chains they have been
      // copied onto our own meta.
      if (m.readableChains()) {
        m.writableChains(_emberMetalWatch_path.makeChainNode);
      }
    }
  }

  exports.removeChainWatcher = removeChainWatcher;
  exports.ChainNode = ChainNode;
});
enifed('ember-metal/computed', ['exports', 'ember-utils', 'ember-metal/debug', 'ember-metal/property_set', 'ember-metal/meta', 'ember-metal/expand_properties', 'ember-metal/error', 'ember-metal/properties', 'ember-metal/property_events', 'ember-metal/dependent_keys'], function (exports, _emberUtils, _emberMetalDebug, _emberMetalProperty_set, _emberMetalMeta, _emberMetalExpand_properties, _emberMetalError, _emberMetalProperties, _emberMetalProperty_events, _emberMetalDependent_keys) {
  'use strict';

  exports.default = computed;

  /**
  @module ember
  @submodule ember-metal
  */

  var DEEP_EACH_REGEX = /\.@each\.[^.]+\./;

  /**
    A computed property transforms an object literal with object's accessor function(s) into a property.
  
    By default the function backing the computed property will only be called
    once and the result will be cached. You can specify various properties
    that your computed property depends on. This will force the cached
    result to be recomputed if the dependencies are modified.
  
    In the following example we declare a computed property - `fullName` - by calling
    `.Ember.computed()` with property dependencies (`firstName` and `lastName`) as leading arguments and getter accessor function. The `fullName` getter function
    will be called once (regardless of how many times it is accessed) as long
    as its dependencies have not changed. Once `firstName` or `lastName` are updated
    any future calls (or anything bound) to `fullName` will incorporate the new
    values.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', function() {
        let firstName = this.get('firstName'),
            lastName  = this.get('lastName');
  
        return firstName + ' ' + lastName;
      })
    });
  
    let tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });
  
    tom.get('fullName') // 'Tom Dale'
    ```
  
    You can also define what Ember should do when setting a computed property by providing additional function (`set`) in hash argument.
    If you try to set a computed property, it will try to invoke setter accessor function with the key and
    value you want to set it to as arguments.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName'),
              lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          this.set('firstName', firstName);
          this.set('lastName', lastName);
  
          return value;
        }
      })
    });
  
    let person = Person.create();
  
    person.set('fullName', 'Peter Wagenet');
    person.get('firstName'); // 'Peter'
    person.get('lastName');  // 'Wagenet'
    ```
  
    You can overwrite computed property with normal property (no longer computed), that won't change if dependencies change, if you set computed property and it won't have setter accessor function defined.
  
    You can also mark computed property as `.readOnly()` and block all attempts to set it.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName');
          let lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        }
      }).readOnly()
    });
  
    let person = Person.create();
    person.set('fullName', 'Peter Wagenet'); // Uncaught Error: Cannot set read-only property "fullName" on object: <(...):emberXXX>
    ```
  
    Additional resources:
    - [New CP syntax RFC](https://github.com/emberjs/rfcs/blob/master/text/0011-improved-cp-syntax.md)
    - [New computed syntax explained in "Ember 1.12 released" ](http://emberjs.com/blog/2015/05/13/ember-1-12-released.html#toc_new-computed-syntax)
  
    @class ComputedProperty
    @namespace Ember
    @public
  */
  function ComputedProperty(config, opts) {
    this.isDescriptor = true;
    if (typeof config === 'function') {
      this._getter = config;
    } else {
      _emberMetalDebug.assert('Ember.computed expects a function or an object as last argument.', typeof config === 'object' && !Array.isArray(config));
      _emberMetalDebug.assert('Config object passed to an Ember.computed can only contain `get` or `set` keys.', (function () {
        var keys = Object.keys(config);
        for (var i = 0; i < keys.length; i++) {
          if (keys[i] !== 'get' && keys[i] !== 'set') {
            return false;
          }
        }
        return true;
      })());
      this._getter = config.get;
      this._setter = config.set;
    }
    _emberMetalDebug.assert('Computed properties must receive a getter or a setter, you passed none.', !!this._getter || !!this._setter);
    this._dependentKeys = undefined;
    this._suspended = undefined;
    this._meta = undefined;
    this._volatile = false;
    this._dependentKeys = opts && opts.dependentKeys;
    this._readOnly = false;
  }

  ComputedProperty.prototype = new _emberMetalProperties.Descriptor();
  ComputedProperty.prototype.constructor = ComputedProperty;

  var ComputedPropertyPrototype = ComputedProperty.prototype;

  /**
    Call on a computed property to set it into non-cached mode. When in this
    mode the computed property will not automatically cache the return value.
  
    It also does not automatically fire any change events. You must manually notify
    any changes if you want to observe this property.
  
    Dependency keys have no effect on volatile properties as they are for cache
    invalidation and notification when cached value is invalidated.
  
    ```javascript
    let outsideService = Ember.Object.extend({
      value: Ember.computed(function() {
        return OutsideService.getValue();
      }).volatile()
    }).create();
    ```
  
    @method volatile
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.volatile = function () {
    this._volatile = true;
    return this;
  };

  /**
    Call on a computed property to set it into read-only mode. When in this
    mode the computed property will throw an error when set.
  
    ```javascript
    let Person = Ember.Object.extend({
      guid: Ember.computed(function() {
        return 'guid-guid-guid';
      }).readOnly()
    });
  
    let person = Person.create();
  
    person.set('guid', 'new-guid'); // will throw an exception
    ```
  
    @method readOnly
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.readOnly = function () {
    this._readOnly = true;
    _emberMetalDebug.assert('Computed properties that define a setter using the new syntax cannot be read-only', !(this._readOnly && this._setter && this._setter !== this._getter));
    return this;
  };

  /**
    Sets the dependent keys on this computed property. Pass any number of
    arguments containing key paths that this computed property depends on.
  
    ```javascript
    let President = Ember.Object.extend({
      fullName: Ember.computed(function() {
        return this.get('firstName') + ' ' + this.get('lastName');
  
        // Tell Ember that this computed property depends on firstName
        // and lastName
      }).property('firstName', 'lastName')
    });
  
    let president = President.create({
      firstName: 'Barack',
      lastName: 'Obama'
    });
  
    president.get('fullName'); // 'Barack Obama'
    ```
  
    @method property
    @param {String} path* zero or more property paths
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.property = function () {
    var args = [];

    function addArg(property) {
      _emberMetalDebug.warn('Dependent keys containing @each only work one level deep. ' + 'You cannot use nested forms like todos.@each.owner.name or todos.@each.owner.@each.name. ' + 'Please create an intermediary computed property.', DEEP_EACH_REGEX.test(property) === false, { id: 'ember-metal.computed-deep-each' });
      args.push(property);
    }

    for (var i = 0; i < arguments.length; i++) {
      _emberMetalExpand_properties.default(arguments[i], addArg);
    }

    this._dependentKeys = args;
    return this;
  };

  /**
    In some cases, you may want to annotate computed properties with additional
    metadata about how they function or what values they operate on. For example,
    computed property functions may close over variables that are then no longer
    available for introspection.
  
    You can pass a hash of these values to a computed property like this:
  
    ```
    person: Ember.computed(function() {
      let personId = this.get('personId');
      return App.Person.create({ id: personId });
    }).meta({ type: App.Person })
    ```
  
    The hash that you pass to the `meta()` function will be saved on the
    computed property descriptor under the `_meta` key. Ember runtime
    exposes a public API for retrieving these values from classes,
    via the `metaForProperty()` function.
  
    @method meta
    @param {Object} meta
    @chainable
    @public
  */
  ComputedPropertyPrototype.meta = function (meta) {
    if (arguments.length === 0) {
      return this._meta || {};
    } else {
      this._meta = meta;
      return this;
    }
  };

  // invalidate cache when CP key changes
  ComputedPropertyPrototype.didChange = function (obj, keyName) {
    // _suspended is set via a CP.set to ensure we don't clear
    // the cached value set by the setter
    if (this._volatile || this._suspended === obj) {
      return;
    }

    // don't create objects just to invalidate
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta || meta.source !== obj) {
      return;
    }

    var cache = meta.readableCache();
    if (cache && cache[keyName] !== undefined) {
      cache[keyName] = undefined;
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
    }
  };

  ComputedPropertyPrototype.get = function (obj, keyName) {
    if (this._volatile) {
      return this._getter.call(obj, keyName);
    }

    var meta = _emberMetalMeta.meta(obj);
    var cache = meta.writableCache();

    var result = cache[keyName];
    if (result === _emberMetalMeta.UNDEFINED) {
      return undefined;
    } else if (result !== undefined) {
      return result;
    }

    var ret = this._getter.call(obj, keyName);
    if (ret === undefined) {
      cache[keyName] = _emberMetalMeta.UNDEFINED;
    } else {
      cache[keyName] = ret;
    }

    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.revalidate(keyName);
    }
    _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);

    return ret;
  };

  ComputedPropertyPrototype.set = function computedPropertySetEntry(obj, keyName, value) {
    if (this._readOnly) {
      this._throwReadOnlyError(obj, keyName);
    }

    if (!this._setter) {
      return this.clobberSet(obj, keyName, value);
    }

    if (this._volatile) {
      return this.volatileSet(obj, keyName, value);
    }

    return this.setWithSuspend(obj, keyName, value);
  };

  ComputedPropertyPrototype._throwReadOnlyError = function computedPropertyThrowReadOnlyError(obj, keyName) {
    throw new _emberMetalError.default('Cannot set read-only property "' + keyName + '" on object: ' + _emberUtils.inspect(obj));
  };

  ComputedPropertyPrototype.clobberSet = function computedPropertyClobberSet(obj, keyName, value) {
    var cachedValue = cacheFor(obj, keyName);
    _emberMetalProperties.defineProperty(obj, keyName, null, cachedValue);
    _emberMetalProperty_set.set(obj, keyName, value);
    return value;
  };

  ComputedPropertyPrototype.volatileSet = function computedPropertyVolatileSet(obj, keyName, value) {
    return this._setter.call(obj, keyName, value);
  };

  ComputedPropertyPrototype.setWithSuspend = function computedPropertySetWithSuspend(obj, keyName, value) {
    var oldSuspended = this._suspended;
    this._suspended = obj;
    try {
      return this._set(obj, keyName, value);
    } finally {
      this._suspended = oldSuspended;
    }
  };

  ComputedPropertyPrototype._set = function computedPropertySet(obj, keyName, value) {
    // cache requires own meta
    var meta = _emberMetalMeta.meta(obj);
    // either there is a writable cache or we need one to update
    var cache = meta.writableCache();
    var hadCachedValue = false;
    var cachedValue = undefined;
    if (cache[keyName] !== undefined) {
      if (cache[keyName] !== _emberMetalMeta.UNDEFINED) {
        cachedValue = cache[keyName];
      }
      hadCachedValue = true;
    }

    var ret = this._setter.call(obj, keyName, value, cachedValue);

    // allows setter to return the same value that is cached already
    if (hadCachedValue && cachedValue === ret) {
      return ret;
    }

    _emberMetalProperty_events.propertyWillChange(obj, keyName);

    if (hadCachedValue) {
      cache[keyName] = undefined;
    }

    if (!hadCachedValue) {
      _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);
    }

    if (ret === undefined) {
      cache[keyName] = _emberMetalMeta.UNDEFINED;
    } else {
      cache[keyName] = ret;
    }

    _emberMetalProperty_events.propertyDidChange(obj, keyName);

    return ret;
  };

  /* called before property is overridden */
  ComputedPropertyPrototype.teardown = function (obj, keyName) {
    if (this._volatile) {
      return;
    }
    var meta = _emberMetalMeta.meta(obj);
    var cache = meta.readableCache();
    if (cache && cache[keyName] !== undefined) {
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
      cache[keyName] = undefined;
    }
  };

  /**
    This helper returns a new property descriptor that wraps the passed
    computed property function. You can use this helper to define properties
    with mixins or via `Ember.defineProperty()`.
  
    If you pass a function as an argument, it will be used as a getter. A computed
    property defined in this way might look like this:
  
    ```js
    let Person = Ember.Object.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: Ember.computed('firstName', 'lastName', function() {
        return `${this.get('firstName')} ${this.get('lastName')}`;
      })
    });
  
    let client = Person.create();
  
    client.get('fullName'); // 'Betty Jones'
  
    client.set('lastName', 'Fuller');
    client.get('fullName'); // 'Betty Fuller'
    ```
  
    You can pass a hash with two functions, `get` and `set`, as an
    argument to provide both a getter and setter:
  
    ```js
    let Person = Ember.Object.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          return `${this.get('firstName')} ${this.get('lastName')}`;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(/\s+/);
          this.setProperties({ firstName, lastName });
          return value;
        }
      });
    })
  
    let client = Person.create();
    client.get('firstName'); // 'Betty'
  
    client.set('fullName', 'Carroll Fuller');
    client.get('firstName'); // 'Carroll'
    ```
  
    The `set` function should accept two parameters, `key` and `value`. The value
    returned from `set` will be the new value of the property.
  
    _Note: This is the preferred way to define computed properties when writing third-party
    libraries that depend on or use Ember, since there is no guarantee that the user
    will have [prototype Extensions](http://emberjs.com/guides/configuring-ember/disabling-prototype-extensions/) enabled._
  
    The alternative syntax, with prototype extensions, might look like:
  
    ```js
    fullName: function() {
      return this.get('firstName') + ' ' + this.get('lastName');
    }.property('firstName', 'lastName')
    ```
  
    @class computed
    @namespace Ember
    @constructor
    @static
    @param {String} [dependentKeys*] Optional dependent keys that trigger this computed property.
    @param {Function} func The computed property function.
    @return {Ember.ComputedProperty} property descriptor instance
    @public
  */

  function computed(func) {
    var args = undefined;

    if (arguments.length > 1) {
      args = [].slice.call(arguments);
      func = args.pop();
    }

    var cp = new ComputedProperty(func);

    if (args) {
      cp.property.apply(cp, args);
    }

    return cp;
  }

  /**
    Returns the cached value for a property, if one exists.
    This can be useful for peeking at the value of a computed
    property that is generated lazily, without accidentally causing
    it to be created.
  
    @method cacheFor
    @for Ember
    @param {Object} obj the object whose property you want to check
    @param {String} key the name of the property whose cached value you want
      to return
    @return {Object} the cached value
    @public
  */
  function cacheFor(obj, key) {
    var meta = _emberMetalMeta.peekMeta(obj);
    var cache = meta && meta.source === obj && meta.readableCache();
    var ret = cache && cache[key];

    if (ret === _emberMetalMeta.UNDEFINED) {
      return undefined;
    }
    return ret;
  }

  cacheFor.set = function (cache, key, value) {
    if (value === undefined) {
      cache[key] = _emberMetalMeta.UNDEFINED;
    } else {
      cache[key] = value;
    }
  };

  cacheFor.get = function (cache, key) {
    var ret = cache[key];
    if (ret === _emberMetalMeta.UNDEFINED) {
      return undefined;
    }
    return ret;
  };

  cacheFor.remove = function (cache, key) {
    cache[key] = undefined;
  };

  exports.ComputedProperty = ComputedProperty;
  exports.computed = computed;
  exports.cacheFor = cacheFor;
});
enifed('ember-metal/core', ['exports', 'ember-environment'], function (exports, _emberEnvironment) {
  'use strict';

  /**
  @module ember
  @submodule ember-metal
  */

  /**
    This namespace contains all Ember methods and functions. Future versions of
    Ember may overwrite this namespace and therefore, you should avoid adding any
    new properties.
  
    At the heart of Ember is Ember-Runtime, a set of core functions that provide
    cross-platform compatibility and object property observing.  Ember-Runtime is
    small and performance-focused so you can use it alongside other
    cross-platform libraries such as jQuery. For more details, see
    [Ember-Runtime](http://emberjs.com/api/modules/ember-runtime.html).
  
    @class Ember
    @static
    @public
  */
  var Ember = typeof _emberEnvironment.context.imports.Ember === 'object' && _emberEnvironment.context.imports.Ember || {};

  // Make sure these are set whether Ember was already defined or not
  Ember.isNamespace = true;
  Ember.toString = function () {
    return 'Ember';
  };

  // ..........................................................
  // BOOTSTRAP
  //

  exports.default = Ember;
});
enifed("ember-metal/debug", ["exports"], function (exports) {
  "use strict";

  exports.getDebugFunction = getDebugFunction;
  exports.setDebugFunction = setDebugFunction;
  exports.assert = assert;
  exports.info = info;
  exports.warn = warn;
  exports.debug = debug;
  exports.deprecate = deprecate;
  exports.deprecateFunc = deprecateFunc;
  exports.runInDebug = runInDebug;
  exports.debugSeal = debugSeal;
  exports.debugFreeze = debugFreeze;
  var debugFunctions = {
    assert: function () {},
    info: function () {},
    warn: function () {},
    debug: function () {},
    deprecate: function () {},
    deprecateFunc: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return args[args.length - 1];
    },
    runInDebug: function () {},
    debugSeal: function () {},
    debugFreeze: function () {}
  };

  exports.debugFunctions = debugFunctions;

  function getDebugFunction(name) {
    return debugFunctions[name];
  }

  function setDebugFunction(name, fn) {
    debugFunctions[name] = fn;
  }

  function assert() {
    return debugFunctions.assert.apply(undefined, arguments);
  }

  function info() {
    return debugFunctions.info.apply(undefined, arguments);
  }

  function warn() {
    return debugFunctions.warn.apply(undefined, arguments);
  }

  function debug() {
    return debugFunctions.debug.apply(undefined, arguments);
  }

  function deprecate() {
    return debugFunctions.deprecate.apply(undefined, arguments);
  }

  function deprecateFunc() {
    return debugFunctions.deprecateFunc.apply(undefined, arguments);
  }

  function runInDebug() {
    return debugFunctions.runInDebug.apply(undefined, arguments);
  }

  function debugSeal() {
    return debugFunctions.debugSeal.apply(undefined, arguments);
  }

  function debugFreeze() {
    return debugFunctions.debugFreeze.apply(undefined, arguments);
  }
});
enifed('ember-metal/dependent_keys', ['exports', 'ember-metal/watching'], function (exports, _emberMetalWatching) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  exports.addDependentKeys = addDependentKeys;
  exports.removeDependentKeys = removeDependentKeys;

  /**
  @module ember
  @submodule ember-metal
  */

  // ..........................................................
  // DEPENDENT KEYS
  //

  function addDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // add all of its dependent keys.
    var idx = undefined,
        depKey = undefined;
    var depKeys = desc._dependentKeys;
    if (!depKeys) {
      return;
    }

    for (idx = 0; idx < depKeys.length; idx++) {
      depKey = depKeys[idx];
      // Increment the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) + 1);
      // Watch the depKey
      _emberMetalWatching.watch(obj, depKey, meta);
    }
  }

  function removeDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // remove all of its dependent keys.
    var depKeys = desc._dependentKeys;
    if (!depKeys) {
      return;
    }

    for (var idx = 0; idx < depKeys.length; idx++) {
      var depKey = depKeys[idx];
      // Decrement the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) - 1);
      // Unwatch the depKey
      _emberMetalWatching.unwatch(obj, depKey, meta);
    }
  }
});
enifed('ember-metal/deprecate_property', ['exports', 'ember-metal/debug', 'ember-metal/property_get', 'ember-metal/property_set'], function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set) {
  /**
  @module ember
  @submodule ember-metal
  */

  'use strict';

  exports.deprecateProperty = deprecateProperty;

  /**
    Used internally to allow changing properties in a backwards compatible way, and print a helpful
    deprecation warning.
  
    @method deprecateProperty
    @param {Object} object The object to add the deprecated property to.
    @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
    @param {String} newKey The property that will be aliased.
    @private
    @since 1.7.0
  */

  function deprecateProperty(object, deprecatedKey, newKey, options) {
    function _deprecate() {
      _emberMetalDebug.deprecate('Usage of `' + deprecatedKey + '` is deprecated, use `' + newKey + '` instead.', false, options);
    }

    Object.defineProperty(object, deprecatedKey, {
      configurable: true,
      enumerable: false,
      set: function (value) {
        _deprecate();
        _emberMetalProperty_set.set(this, newKey, value);
      },
      get: function () {
        _deprecate();
        return _emberMetalProperty_get.get(this, newKey);
      }
    });
  }
});
enifed('ember-metal/descriptor', ['exports', 'ember-metal/properties'], function (exports, _emberMetalProperties) {
  'use strict';

  exports.default = descriptor;

  function descriptor(desc) {
    return new Descriptor(desc);
  }

  /**
    A wrapper for a native ES5 descriptor. In an ideal world, we wouldn't need
    this at all, however, the way we currently flatten/merge our mixins require
    a special value to denote a descriptor.
  
    @class Descriptor
    @private
  */

  var Descriptor = (function (_EmberDescriptor) {
    babelHelpers.inherits(Descriptor, _EmberDescriptor);

    function Descriptor(desc) {
      babelHelpers.classCallCheck(this, Descriptor);

      _EmberDescriptor.call(this);
      this.desc = desc;
    }

    Descriptor.prototype.setup = function setup(obj, key) {
      Object.defineProperty(obj, key, this.desc);
    };

    Descriptor.prototype.teardown = function teardown(obj, key) {};

    return Descriptor;
  })(_emberMetalProperties.Descriptor);
});
enifed("ember-metal/error", ["exports"], function (exports) {

  /**
    A subclass of the JavaScript Error object for use in Ember.
  
    @class Error
    @namespace Ember
    @extends Error
    @constructor
    @public
  */
  "use strict";

  exports.default = EmberError;

  function EmberError(message) {
    if (!(this instanceof EmberError)) {
      return new EmberError(message);
    }

    var error = Error.call(this, message);

    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, EmberError);
    } else {
      this.stack = error.stack;
    }

    this.description = error.description;
    this.fileName = error.fileName;
    this.lineNumber = error.lineNumber;
    this.message = error.message;
    this.name = error.name;
    this.number = error.number;
    this.code = error.code;
  }

  EmberError.prototype = Object.create(Error.prototype);
});
enifed('ember-metal/error_handler', ['exports', 'ember-console', 'ember-metal/testing'], function (exports, _emberConsole, _emberMetalTesting) {
  'use strict';

  exports.getOnerror = getOnerror;
  exports.setOnerror = setOnerror;
  exports.dispatchError = dispatchError;
  exports.setDispatchOverride = setDispatchOverride;

  // To maintain stacktrace consistency across browsers
  var getStack = function (error) {
    var stack = error.stack;
    var message = error.message;

    if (stack && stack.indexOf(message) === -1) {
      stack = message + '\n' + stack;
    }

    return stack;
  };

  var onerror = undefined;
  // Ember.onerror getter

  function getOnerror() {
    return onerror;
  }

  // Ember.onerror setter

  function setOnerror(handler) {
    onerror = handler;
  }

  var dispatchOverride = undefined;
  // dispatch error

  function dispatchError(error) {
    if (dispatchOverride) {
      dispatchOverride(error);
    } else {
      defaultDispatch(error);
    }
  }

  // allows testing adapter to override dispatch

  function setDispatchOverride(handler) {
    dispatchOverride = handler;
  }

  function defaultDispatch(error) {
    if (_emberMetalTesting.isTesting()) {
      throw error;
    }
    if (onerror) {
      onerror(error);
    } else {
      _emberConsole.default.error(getStack(error));
    }
  }
});
enifed('ember-metal/events', ['exports', 'ember-utils', 'ember-metal/debug', 'ember-metal/meta', 'ember-metal/meta_listeners'], function (exports, _emberUtils, _emberMetalDebug, _emberMetalMeta, _emberMetalMeta_listeners) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  /**
  @module ember
  @submodule ember-metal
  */
  exports.accumulateListeners = accumulateListeners;
  exports.addListener = addListener;
  exports.removeListener = removeListener;
  exports.suspendListener = suspendListener;
  exports.suspendListeners = suspendListeners;
  exports.watchedEvents = watchedEvents;
  exports.sendEvent = sendEvent;
  exports.hasListeners = hasListeners;
  exports.listenersFor = listenersFor;
  exports.on = on;

  /*
    The event system uses a series of nested hashes to store listeners on an
    object. When a listener is registered, or when an event arrives, these
    hashes are consulted to determine which target and action pair to invoke.
  
    The hashes are stored in the object's meta hash, and look like this:
  
        // Object's meta hash
        {
          listeners: {       // variable name: `listenerSet`
            "foo:changed": [ // variable name: `actions`
              target, method, flags
            ]
          }
        }
  
  */

  function indexOf(array, target, method) {
    var index = -1;
    // hashes are added to the end of the event array
    // so it makes sense to start searching at the end
    // of the array and search in reverse
    for (var i = array.length - 3; i >= 0; i -= 3) {
      if (target === array[i] && method === array[i + 1]) {
        index = i;
        break;
      }
    }
    return index;
  }

  function accumulateListeners(obj, eventName, otherActions) {
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta) {
      return;
    }
    var actions = meta.matchingListeners(eventName);
    var newActions = [];

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];
      var actionIndex = indexOf(otherActions, target, method);

      if (actionIndex === -1) {
        otherActions.push(target, method, flags);
        newActions.push(target, method, flags);
      }
    }

    return newActions;
  }

  /**
    Add an event listener
  
    @method addListener
    @for Ember
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Boolean} once A flag whether a function should only be called once
    @public
  */

  function addListener(obj, eventName, target, method, once) {
    _emberMetalDebug.assert('You must pass at least an object and event name to Ember.addListener', !!obj && !!eventName);

    _emberMetalDebug.deprecate('didInitAttrs called in ' + (obj && obj.toString && obj.toString()) + '.', eventName !== 'didInitAttrs', {
      id: 'ember-views.did-init-attrs',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-component-didinitattrs'
    });

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    var flags = 0;
    if (once) {
      flags |= _emberMetalMeta_listeners.ONCE;
    }

    _emberMetalMeta.meta(obj).addToListeners(eventName, target, method, flags);

    if ('function' === typeof obj.didAddListener) {
      obj.didAddListener(eventName, target, method);
    }
  }

  /**
    Remove an event listener
  
    Arguments should match those passed to `Ember.addListener`.
  
    @method removeListener
    @for Ember
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @public
  */

  function removeListener(obj, eventName, target, method) {
    _emberMetalDebug.assert('You must pass at least an object and event name to Ember.removeListener', !!obj && !!eventName);

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    _emberMetalMeta.meta(obj).removeFromListeners(eventName, target, method, function () {
      if ('function' === typeof obj.didRemoveListener) {
        obj.didRemoveListener.apply(obj, arguments);
      }
    });
  }

  /**
    Suspend listener during callback.
  
    This should only be used by the target of the event listener
    when it is taking an action that would cause the event, e.g.
    an object might suspend its property change listener while it is
    setting that property.
  
    @method suspendListener
    @for Ember
  
    @private
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */

  function suspendListener(obj, eventName, target, method, callback) {
    return suspendListeners(obj, [eventName], target, method, callback);
  }

  /**
    Suspends multiple listeners during a callback.
  
    @method suspendListeners
    @for Ember
  
    @private
    @param obj
    @param {Array} eventNames Array of event names
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */

  function suspendListeners(obj, eventNames, target, method, callback) {
    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }
    return _emberMetalMeta.meta(obj).suspendListeners(eventNames, target, method, callback);
  }

  /**
    Return a list of currently watched events
  
    @private
    @method watchedEvents
    @for Ember
    @param obj
  */

  function watchedEvents(obj) {
    return _emberMetalMeta.meta(obj).watchedEvents();
  }

  /**
    Send an event. The execution of suspended listeners
    is skipped, and once listeners are removed. A listener without
    a target is executed on the passed object. If an array of actions
    is not passed, the actions stored on the passed object are invoked.
  
    @method sendEvent
    @for Ember
    @param obj
    @param {String} eventName
    @param {Array} params Optional parameters for each listener.
    @param {Array} actions Optional array of actions (listeners).
    @return true
    @public
  */

  function sendEvent(obj, eventName, params, actions) {
    if (!actions) {
      var meta = _emberMetalMeta.peekMeta(obj);
      actions = meta && meta.matchingListeners(eventName);
    }

    if (!actions || actions.length === 0) {
      return;
    }

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      // looping in reverse for once listeners
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];

      if (!method) {
        continue;
      }
      if (flags & _emberMetalMeta_listeners.SUSPENDED) {
        continue;
      }
      if (flags & _emberMetalMeta_listeners.ONCE) {
        removeListener(obj, eventName, target, method);
      }
      if (!target) {
        target = obj;
      }
      if ('string' === typeof method) {
        if (params) {
          _emberUtils.applyStr(target, method, params);
        } else {
          target[method]();
        }
      } else {
        if (params) {
          method.apply(target, params);
        } else {
          method.call(target);
        }
      }
    }
    return true;
  }

  /**
    @private
    @method hasListeners
    @for Ember
    @param obj
    @param {String} eventName
  */

  function hasListeners(obj, eventName) {
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta) {
      return false;
    }
    return meta.matchingListeners(eventName).length > 0;
  }

  /**
    @private
    @method listenersFor
    @for Ember
    @param obj
    @param {String} eventName
  */

  function listenersFor(obj, eventName) {
    var ret = [];
    var meta = _emberMetalMeta.peekMeta(obj);
    var actions = meta && meta.matchingListeners(eventName);

    if (!actions) {
      return ret;
    }

    for (var i = 0; i < actions.length; i += 3) {
      var target = actions[i];
      var method = actions[i + 1];
      ret.push([target, method]);
    }

    return ret;
  }

  /**
    Define a property as a function that should be executed when
    a specified event or events are triggered.
  
  
    ``` javascript
    let Job = Ember.Object.extend({
      logCompleted: Ember.on('completed', function() {
        console.log('Job completed!');
      })
    });
  
    let job = Job.create();
  
    Ember.sendEvent(job, 'completed'); // Logs 'Job completed!'
   ```
  
    @method on
    @for Ember
    @param {String} eventNames*
    @param {Function} func
    @return func
    @public
  */

  function on() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var func = args.pop();
    var events = args;
    func.__ember_listens__ = events;
    return func;
  }
});
enifed('ember-metal/expand_properties', ['exports', 'ember-metal/debug'], function (exports, _emberMetalDebug) {
  'use strict';

  exports.default = expandProperties;

  /**
  @module ember
  @submodule ember-metal
  */

  var SPLIT_REGEX = /\{|\}/;
  var END_WITH_EACH_REGEX = /\.@each$/;

  /**
    Expands `pattern`, invoking `callback` for each expansion.
  
    The only pattern supported is brace-expansion, anything else will be passed
    once to `callback` directly.
  
    Example
  
    ```js
    function echo(arg){ console.log(arg); }
  
    Ember.expandProperties('foo.bar', echo);              //=> 'foo.bar'
    Ember.expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
    Ember.expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
    Ember.expandProperties('{foo,bar}.baz', echo);        //=> 'foo.baz', 'bar.baz'
    Ember.expandProperties('foo.{bar,baz}.[]', echo)      //=> 'foo.bar.[]', 'foo.baz.[]'
    Ember.expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
    Ember.expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
    ```
  
    @method expandProperties
    @for Ember
    @private
    @param {String} pattern The property pattern to expand.
    @param {Function} callback The callback to invoke.  It is invoked once per
    expansion, and is passed the expansion.
  */

  function expandProperties(pattern, callback) {
    _emberMetalDebug.assert('A computed property key must be a string', typeof pattern === 'string');
    _emberMetalDebug.assert('Brace expanded properties cannot contain spaces, e.g. "user.{firstName, lastName}" should be "user.{firstName,lastName}"', pattern.indexOf(' ') === -1);

    var parts = pattern.split(SPLIT_REGEX);
    var properties = [parts];

    for (var i = 0; i < parts.length; i++) {
      var part = parts[i];
      if (part.indexOf(',') >= 0) {
        properties = duplicateAndReplace(properties, part.split(','), i);
      }
    }

    for (var i = 0; i < properties.length; i++) {
      callback(properties[i].join('').replace(END_WITH_EACH_REGEX, '.[]'));
    }
  }

  function duplicateAndReplace(properties, currentParts, index) {
    var all = [];

    properties.forEach(function (property) {
      currentParts.forEach(function (part) {
        var current = property.slice(0);
        current[index] = part;
        all.push(current);
      });
    });

    return all;
  }
});
enifed('ember-metal/features', ['exports', 'ember-utils', 'ember-environment', 'ember/features'], function (exports, _emberUtils, _emberEnvironment, _emberFeatures) {
  'use strict';

  exports.default = isEnabled;

  /**
    The hash of enabled Canary features. Add to this, any canary features
    before creating your application.
  
    Alternatively (and recommended), you can also define `EmberENV.FEATURES`
    if you need to enable features flagged at runtime.
  
    @class FEATURES
    @namespace Ember
    @static
    @since 1.1.0
    @public
  */
  var FEATURES = _emberUtils.assign(_emberFeatures.default, _emberEnvironment.ENV.FEATURES);

  exports.FEATURES = FEATURES;
  /**
    Determine whether the specified `feature` is enabled. Used by Ember's
    build tools to exclude experimental features from beta/stable builds.
  
    You can define the following configuration options:
  
    * `EmberENV.ENABLE_OPTIONAL_FEATURES` - enable any features that have not been explicitly
      enabled/disabled.
  
    @method isEnabled
    @param {String} feature The feature to check
    @return {Boolean}
    @for Ember.FEATURES
    @since 1.1.0
    @public
  */

  function isEnabled(feature) {
    var featureValue = FEATURES[feature];

    if (featureValue === true || featureValue === false || featureValue === undefined) {
      return featureValue;
    } else if (_emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES) {
      return true;
    } else {
      return false;
    }
  }

  exports.DEFAULT_FEATURES = _emberFeatures.default;
});
enifed('ember-metal/get_properties', ['exports', 'ember-metal/property_get'], function (exports, _emberMetalProperty_get) {
  'use strict';

  exports.default = getProperties;

  /**
    To get multiple properties at once, call `Ember.getProperties`
    with an object followed by a list of strings or an array:
  
    ```javascript
    Ember.getProperties(record, 'firstName', 'lastName', 'zipCode');
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    is equivalent to:
  
    ```javascript
    Ember.getProperties(record, ['firstName', 'lastName', 'zipCode']);
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    @method getProperties
    @for Ember
    @param {Object} obj
    @param {String...|Array} list of keys to get
    @return {Object}
    @public
  */

  function getProperties(obj) {
    var ret = {};
    var propertyNames = arguments;
    var i = 1;

    if (arguments.length === 2 && Array.isArray(arguments[1])) {
      i = 0;
      propertyNames = arguments[1];
    }
    for (; i < propertyNames.length; i++) {
      ret[propertyNames[i]] = _emberMetalProperty_get.get(obj, propertyNames[i]);
    }
    return ret;
  }
});
enifed('ember-metal/index', ['exports', 'require', 'ember-metal/core', 'ember-metal/computed', 'ember-metal/alias', 'ember-metal/merge', 'ember-metal/debug', 'ember-metal/instrumentation', 'ember-metal/testing', 'ember-metal/error_handler', 'ember-metal/meta', 'ember-metal/error', 'ember-metal/cache', 'ember-metal/features', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/weak_map', 'ember-metal/events', 'ember-metal/is_none', 'ember-metal/is_empty', 'ember-metal/is_blank', 'ember-metal/is_present', 'ember-metal/run_loop', 'ember-metal/observer_set', 'ember-metal/property_events', 'ember-metal/properties', 'ember-metal/watch_key', 'ember-metal/chains', 'ember-metal/watch_path', 'ember-metal/watching', 'ember-metal/libraries', 'ember-metal/map', 'ember-metal/get_properties', 'ember-metal/set_properties', 'ember-metal/expand_properties', 'ember-metal/observer', 'ember-metal/mixin', 'ember-metal/binding', 'ember-metal/path_cache', 'ember-metal/injected_property', 'ember-metal/tags', 'ember-metal/replace', 'ember-metal/transaction', 'ember-metal/is_proxy', 'ember-metal/descriptor'], function (exports, _require, _emberMetalCore, _emberMetalComputed, _emberMetalAlias, _emberMetalMerge, _emberMetalDebug, _emberMetalInstrumentation, _emberMetalTesting, _emberMetalError_handler, _emberMetalMeta, _emberMetalError, _emberMetalCache, _emberMetalFeatures, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalWeak_map, _emberMetalEvents, _emberMetalIs_none, _emberMetalIs_empty, _emberMetalIs_blank, _emberMetalIs_present, _emberMetalRun_loop, _emberMetalObserver_set, _emberMetalProperty_events, _emberMetalProperties, _emberMetalWatch_key, _emberMetalChains, _emberMetalWatch_path, _emberMetalWatching, _emberMetalLibraries, _emberMetalMap, _emberMetalGet_properties, _emberMetalSet_properties, _emberMetalExpand_properties, _emberMetalObserver, _emberMetalMixin, _emberMetalBinding, _emberMetalPath_cache, _emberMetalInjected_property, _emberMetalTags, _emberMetalReplace, _emberMetalTransaction, _emberMetalIs_proxy, _emberMetalDescriptor) {
  /**
  @module ember
  @submodule ember-metal
  */

  'use strict';

  exports.default = _emberMetalCore.default;
  // reexports
  exports.computed = _emberMetalComputed.default;
  exports.cacheFor = _emberMetalComputed.cacheFor;
  exports.ComputedProperty = _emberMetalComputed.ComputedProperty;
  exports.alias = _emberMetalAlias.default;
  exports.merge = _emberMetalMerge.default;
  exports.assert = _emberMetalDebug.assert;
  exports.info = _emberMetalDebug.info;
  exports.warn = _emberMetalDebug.warn;
  exports.debug = _emberMetalDebug.debug;
  exports.deprecate = _emberMetalDebug.deprecate;
  exports.deprecateFunc = _emberMetalDebug.deprecateFunc;
  exports.runInDebug = _emberMetalDebug.runInDebug;
  exports.setDebugFunction = _emberMetalDebug.setDebugFunction;
  exports.getDebugFunction = _emberMetalDebug.getDebugFunction;
  exports.debugSeal = _emberMetalDebug.debugSeal;
  exports.debugFreeze = _emberMetalDebug.debugFreeze;
  exports.instrument = _emberMetalInstrumentation.instrument;
  exports.flaggedInstrument = _emberMetalInstrumentation.flaggedInstrument;
  exports._instrumentStart = _emberMetalInstrumentation._instrumentStart;
  exports.instrumentationReset = _emberMetalInstrumentation.reset;
  exports.instrumentationSubscribe = _emberMetalInstrumentation.subscribe;
  exports.instrumentationUnsubscribe = _emberMetalInstrumentation.unsubscribe;
  exports.isTesting = _emberMetalTesting.isTesting;
  exports.setTesting = _emberMetalTesting.setTesting;
  exports.getOnerror = _emberMetalError_handler.getOnerror;
  exports.setOnerror = _emberMetalError_handler.setOnerror;
  exports.dispatchError = _emberMetalError_handler.dispatchError;
  exports.setDispatchOverride = _emberMetalError_handler.setDispatchOverride;
  exports.META_DESC = _emberMetalMeta.META_DESC;
  exports.meta = _emberMetalMeta.meta;
  exports.peekMeta = _emberMetalMeta.peekMeta;
  exports.Error = _emberMetalError.default;
  exports.Cache = _emberMetalCache.default;
  exports.isFeatureEnabled = _emberMetalFeatures.default;
  exports.FEATURES = _emberMetalFeatures.FEATURES;
  exports.DEFAULT_FEATURES = _emberMetalFeatures.DEFAULT_FEATURES;
  exports._getPath = _emberMetalProperty_get._getPath;
  exports.get = _emberMetalProperty_get.get;
  exports.getWithDefault = _emberMetalProperty_get.getWithDefault;
  exports.set = _emberMetalProperty_set.set;
  exports.trySet = _emberMetalProperty_set.trySet;
  exports.WeakMap = _emberMetalWeak_map.default;
  exports.accumulateListeners = _emberMetalEvents.accumulateListeners;
  exports.addListener = _emberMetalEvents.addListener;
  exports.hasListeners = _emberMetalEvents.hasListeners;
  exports.listenersFor = _emberMetalEvents.listenersFor;
  exports.on = _emberMetalEvents.on;
  exports.removeListener = _emberMetalEvents.removeListener;
  exports.sendEvent = _emberMetalEvents.sendEvent;
  exports.suspendListener = _emberMetalEvents.suspendListener;
  exports.suspendListeners = _emberMetalEvents.suspendListeners;
  exports.watchedEvents = _emberMetalEvents.watchedEvents;
  exports.isNone = _emberMetalIs_none.default;
  exports.isEmpty = _emberMetalIs_empty.default;
  exports.isBlank = _emberMetalIs_blank.default;
  exports.isPresent = _emberMetalIs_present.default;
  exports.run = _emberMetalRun_loop.default;
  exports.ObserverSet = _emberMetalObserver_set.default;
  exports.beginPropertyChanges = _emberMetalProperty_events.beginPropertyChanges;
  exports.changeProperties = _emberMetalProperty_events.changeProperties;
  exports.endPropertyChanges = _emberMetalProperty_events.endPropertyChanges;
  exports.overrideChains = _emberMetalProperty_events.overrideChains;
  exports.propertyDidChange = _emberMetalProperty_events.propertyDidChange;
  exports.propertyWillChange = _emberMetalProperty_events.propertyWillChange;
  exports.PROPERTY_DID_CHANGE = _emberMetalProperty_events.PROPERTY_DID_CHANGE;
  exports.defineProperty = _emberMetalProperties.defineProperty;
  exports.Descriptor = _emberMetalProperties.Descriptor;
  exports.watchKey = _emberMetalWatch_key.watchKey;
  exports.unwatchKey = _emberMetalWatch_key.unwatchKey;
  exports.ChainNode = _emberMetalChains.ChainNode;
  exports.finishChains = _emberMetalChains.finishChains;
  exports.removeChainWatcher = _emberMetalChains.removeChainWatcher;
  exports.watchPath = _emberMetalWatch_path.watchPath;
  exports.unwatchPath = _emberMetalWatch_path.unwatchPath;
  exports.destroy = _emberMetalWatching.destroy;
  exports.isWatching = _emberMetalWatching.isWatching;
  exports.unwatch = _emberMetalWatching.unwatch;
  exports.watch = _emberMetalWatching.watch;
  exports.watcherCount = _emberMetalWatching.watcherCount;
  exports.libraries = _emberMetalLibraries.default;
  exports.Map = _emberMetalMap.Map;
  exports.MapWithDefault = _emberMetalMap.MapWithDefault;
  exports.OrderedSet = _emberMetalMap.OrderedSet;
  exports.getProperties = _emberMetalGet_properties.default;
  exports.setProperties = _emberMetalSet_properties.default;
  exports.expandProperties = _emberMetalExpand_properties.default;
  exports._suspendObserver = _emberMetalObserver._suspendObserver;
  exports._suspendObservers = _emberMetalObserver._suspendObservers;
  exports.addObserver = _emberMetalObserver.addObserver;
  exports.observersFor = _emberMetalObserver.observersFor;
  exports.removeObserver = _emberMetalObserver.removeObserver;
  exports._addBeforeObserver = _emberMetalObserver._addBeforeObserver;
  exports._removeBeforeObserver = _emberMetalObserver._removeBeforeObserver;
  exports.NAME_KEY = _emberMetalMixin.NAME_KEY;
  exports.Mixin = _emberMetalMixin.Mixin;
  exports.aliasMethod = _emberMetalMixin.aliasMethod;
  exports._immediateObserver = _emberMetalMixin._immediateObserver;
  exports._beforeObserver = _emberMetalMixin._beforeObserver;
  exports.mixin = _emberMetalMixin.mixin;
  exports.observer = _emberMetalMixin.observer;
  exports.required = _emberMetalMixin.required;
  exports.REQUIRED = _emberMetalMixin.REQUIRED;
  exports.hasUnprocessedMixins = _emberMetalMixin.hasUnprocessedMixins;
  exports.clearUnprocessedMixins = _emberMetalMixin.clearUnprocessedMixins;
  exports.detectBinding = _emberMetalMixin.detectBinding;
  exports.Binding = _emberMetalBinding.Binding;
  exports.bind = _emberMetalBinding.bind;
  exports.isGlobalPath = _emberMetalPath_cache.isGlobalPath;
  exports.InjectedProperty = _emberMetalInjected_property.default;
  exports.setHasViews = _emberMetalTags.setHasViews;
  exports.tagForProperty = _emberMetalTags.tagForProperty;
  exports.tagFor = _emberMetalTags.tagFor;
  exports.markObjectAsDirty = _emberMetalTags.markObjectAsDirty;
  exports.replace = _emberMetalReplace.default;
  exports.runInTransaction = _emberMetalTransaction.default;
  exports.didRender = _emberMetalTransaction.didRender;
  exports.assertNotRendered = _emberMetalTransaction.assertNotRendered;
  exports.isProxy = _emberMetalIs_proxy.isProxy;
  exports.descriptor = _emberMetalDescriptor.default;

  // TODO: this needs to be deleted once we refactor the build tooling
  // do this for side-effects of updating Ember.assert, warn, etc when
  // ember-debug is present
  // This needs to be called before any deprecateFunc

  if (_require.has('ember-debug')) {
    _require.default('ember-debug');
  }
});
enifed('ember-metal/injected_property', ['exports', 'ember-utils', 'ember-metal/debug', 'ember-metal/computed', 'ember-metal/alias', 'ember-metal/properties'], function (exports, _emberUtils, _emberMetalDebug, _emberMetalComputed, _emberMetalAlias, _emberMetalProperties) {
  'use strict';

  exports.default = InjectedProperty;

  /**
    Read-only property that returns the result of a container lookup.
  
    @class InjectedProperty
    @namespace Ember
    @constructor
    @param {String} type The container type the property will lookup
    @param {String} name (optional) The name the property will lookup, defaults
           to the property's name
    @private
  */

  function InjectedProperty(type, name) {
    this.type = type;
    this.name = name;

    this._super$Constructor(injectedPropertyGet);
    AliasedPropertyPrototype.oneWay.call(this);
  }

  function injectedPropertyGet(keyName) {
    var desc = this[keyName];
    var owner = _emberUtils.getOwner(this) || this.container; // fallback to `container` for backwards compat

    _emberMetalDebug.assert('InjectedProperties should be defined with the Ember.inject computed property macros.', desc && desc.isDescriptor && desc.type);
    _emberMetalDebug.assert('Attempting to lookup an injected property on an object without a container, ensure that the object was instantiated via a container.', owner);

    return owner.lookup(desc.type + ':' + (desc.name || keyName));
  }

  InjectedProperty.prototype = Object.create(_emberMetalProperties.Descriptor.prototype);

  var InjectedPropertyPrototype = InjectedProperty.prototype;
  var ComputedPropertyPrototype = _emberMetalComputed.ComputedProperty.prototype;
  var AliasedPropertyPrototype = _emberMetalAlias.AliasedProperty.prototype;

  InjectedPropertyPrototype._super$Constructor = _emberMetalComputed.ComputedProperty;

  InjectedPropertyPrototype.get = ComputedPropertyPrototype.get;
  InjectedPropertyPrototype.readOnly = ComputedPropertyPrototype.readOnly;
  InjectedPropertyPrototype.teardown = ComputedPropertyPrototype.teardown;
});
enifed('ember-metal/instrumentation', ['exports', 'ember-environment', 'ember-metal/features'], function (exports, _emberEnvironment, _emberMetalFeatures) {
  'use strict';

  exports.instrument = instrument;
  exports._instrumentStart = _instrumentStart;
  exports.subscribe = subscribe;
  exports.unsubscribe = unsubscribe;
  exports.reset = reset;

  /**
    The purpose of the Ember Instrumentation module is
    to provide efficient, general-purpose instrumentation
    for Ember.
  
    Subscribe to a listener by using `Ember.subscribe`:
  
    ```javascript
    Ember.subscribe("render", {
      before(name, timestamp, payload) {
  
      },
  
      after(name, timestamp, payload) {
  
      }
    });
    ```
  
    If you return a value from the `before` callback, that same
    value will be passed as a fourth parameter to the `after`
    callback.
  
    Instrument a block of code by using `Ember.instrument`:
  
    ```javascript
    Ember.instrument("render.handlebars", payload, function() {
      // rendering logic
    }, binding);
    ```
  
    Event names passed to `Ember.instrument` are namespaced
    by periods, from more general to more specific. Subscribers
    can listen for events by whatever level of granularity they
    are interested in.
  
    In the above example, the event is `render.handlebars`,
    and the subscriber listened for all events beginning with
    `render`. It would receive callbacks for events named
    `render`, `render.handlebars`, `render.container`, or
    even `render.handlebars.layout`.
  
    @class Instrumentation
    @namespace Ember
    @static
    @private
  */
  var subscribers = [];
  exports.subscribers = subscribers;
  var cache = {};

  function populateListeners(name) {
    var listeners = [];
    var subscriber = undefined;

    for (var i = 0; i < subscribers.length; i++) {
      subscriber = subscribers[i];
      if (subscriber.regex.test(name)) {
        listeners.push(subscriber.object);
      }
    }

    cache[name] = listeners;
    return listeners;
  }

  var time = (function () {
    var perf = 'undefined' !== typeof window ? window.performance || {} : {};
    var fn = perf.now || perf.mozNow || perf.webkitNow || perf.msNow || perf.oNow;
    // fn.bind will be available in all the browsers that support the advanced window.performance... ;-)
    return fn ? fn.bind(perf) : function () {
      return +new Date();
    };
  })();

  /**
    Notifies event's subscribers, calls `before` and `after` hooks.
  
    @method instrument
    @namespace Ember.Instrumentation
  
    @param {String} [name] Namespaced event name.
    @param {Object} _payload
    @param {Function} callback Function that you're instrumenting.
    @param {Object} binding Context that instrument function is called with.
    @private
  */

  function instrument(name, _payload, callback, binding) {
    if (arguments.length <= 3 && typeof _payload === 'function') {
      binding = callback;
      callback = _payload;
      _payload = undefined;
    }
    if (subscribers.length === 0) {
      return callback.call(binding);
    }
    var payload = _payload || {};
    var finalizer = _instrumentStart(name, function () {
      return payload;
    });

    if (finalizer) {
      return withFinalizer(callback, finalizer, payload, binding);
    } else {
      return callback.call(binding);
    }
  }

  var flaggedInstrument = undefined;
  if (false) {
    exports.flaggedInstrument = flaggedInstrument = instrument;
  } else {
    exports.flaggedInstrument = flaggedInstrument = function (name, payload, callback) {
      return callback();
    };
  }
  exports.flaggedInstrument = flaggedInstrument;

  function withFinalizer(callback, finalizer, payload, binding) {
    var result = undefined;
    try {
      result = callback.call(binding);
    } catch (e) {
      payload.exception = e;
      result = payload;
    } finally {
      finalizer();
      return result;
    }
  }

  function NOOP() {}

  // private for now

  function _instrumentStart(name, _payload, _payloadParam) {
    if (subscribers.length === 0) {
      return NOOP;
    }

    var listeners = cache[name];

    if (!listeners) {
      listeners = populateListeners(name);
    }

    if (listeners.length === 0) {
      return NOOP;
    }

    var payload = _payload(_payloadParam);

    var STRUCTURED_PROFILE = _emberEnvironment.ENV.STRUCTURED_PROFILE;
    var timeName = undefined;
    if (STRUCTURED_PROFILE) {
      timeName = name + ': ' + payload.object;
      console.time(timeName);
    }

    var beforeValues = new Array(listeners.length);
    var i = undefined,
        listener = undefined;
    var timestamp = time();
    for (i = 0; i < listeners.length; i++) {
      listener = listeners[i];
      beforeValues[i] = listener.before(name, timestamp, payload);
    }

    return function _instrumentEnd() {
      var i = undefined,
          listener = undefined;
      var timestamp = time();
      for (i = 0; i < listeners.length; i++) {
        listener = listeners[i];
        if (typeof listener.after === 'function') {
          listener.after(name, timestamp, payload, beforeValues[i]);
        }
      }

      if (STRUCTURED_PROFILE) {
        console.timeEnd(timeName);
      }
    };
  }

  /**
    Subscribes to a particular event or instrumented block of code.
  
    @method subscribe
    @namespace Ember.Instrumentation
  
    @param {String} [pattern] Namespaced event name.
    @param {Object} [object] Before and After hooks.
  
    @return {Subscriber}
    @private
  */

  function subscribe(pattern, object) {
    var paths = pattern.split('.');
    var path = undefined;
    var regex = [];

    for (var i = 0; i < paths.length; i++) {
      path = paths[i];
      if (path === '*') {
        regex.push('[^\\.]*');
      } else {
        regex.push(path);
      }
    }

    regex = regex.join('\\.');
    regex = regex + '(\\..*)?';

    var subscriber = {
      pattern: pattern,
      regex: new RegExp('^' + regex + '$'),
      object: object
    };

    subscribers.push(subscriber);
    cache = {};

    return subscriber;
  }

  /**
    Unsubscribes from a particular event or instrumented block of code.
  
    @method unsubscribe
    @namespace Ember.Instrumentation
  
    @param {Object} [subscriber]
    @private
  */

  function unsubscribe(subscriber) {
    var index = undefined;

    for (var i = 0; i < subscribers.length; i++) {
      if (subscribers[i] === subscriber) {
        index = i;
      }
    }

    subscribers.splice(index, 1);
    cache = {};
  }

  /**
    Resets `Ember.Instrumentation` by flushing list of subscribers.
  
    @method reset
    @namespace Ember.Instrumentation
    @private
  */

  function reset() {
    subscribers.length = 0;
    cache = {};
  }
});
enifed('ember-metal/is_blank', ['exports', 'ember-metal/is_empty'], function (exports, _emberMetalIs_empty) {
  'use strict';

  exports.default = isBlank;

  /**
    A value is blank if it is empty or a whitespace string.
  
    ```javascript
    Ember.isBlank();                // true
    Ember.isBlank(null);            // true
    Ember.isBlank(undefined);       // true
    Ember.isBlank('');              // true
    Ember.isBlank([]);              // true
    Ember.isBlank('\n\t');          // true
    Ember.isBlank('  ');            // true
    Ember.isBlank({});              // false
    Ember.isBlank('\n\t Hello');    // false
    Ember.isBlank('Hello world');   // false
    Ember.isBlank([1,2,3]);         // false
    ```
  
    @method isBlank
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.5.0
    @public
  */

  function isBlank(obj) {
    return _emberMetalIs_empty.default(obj) || typeof obj === 'string' && obj.match(/\S/) === null;
  }
});
enifed('ember-metal/is_empty', ['exports', 'ember-metal/property_get', 'ember-metal/is_none'], function (exports, _emberMetalProperty_get, _emberMetalIs_none) {
  'use strict';

  exports.default = isEmpty;

  /**
    Verifies that a value is `null` or an empty string, empty array,
    or empty function.
  
    Constrains the rules on `Ember.isNone` by returning true for empty
    string and empty arrays.
  
    ```javascript
    Ember.isEmpty();                // true
    Ember.isEmpty(null);            // true
    Ember.isEmpty(undefined);       // true
    Ember.isEmpty('');              // true
    Ember.isEmpty([]);              // true
    Ember.isEmpty({});              // false
    Ember.isEmpty('Adam Hawkins');  // false
    Ember.isEmpty([0,1,2]);         // false
    Ember.isEmpty('\n\t');          // false
    Ember.isEmpty('  ');            // false
    ```
  
    @method isEmpty
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */

  function isEmpty(obj) {
    var none = _emberMetalIs_none.default(obj);
    if (none) {
      return none;
    }

    if (typeof obj.size === 'number') {
      return !obj.size;
    }

    var objectType = typeof obj;

    if (objectType === 'object') {
      var size = _emberMetalProperty_get.get(obj, 'size');
      if (typeof size === 'number') {
        return !size;
      }
    }

    if (typeof obj.length === 'number' && objectType !== 'function') {
      return !obj.length;
    }

    if (objectType === 'object') {
      var _length = _emberMetalProperty_get.get(obj, 'length');
      if (typeof _length === 'number') {
        return !_length;
      }
    }

    return false;
  }
});
enifed("ember-metal/is_none", ["exports"], function (exports) {
  /**
    Returns true if the passed value is null or undefined. This avoids errors
    from JSLint complaining about use of ==, which can be technically
    confusing.
  
    ```javascript
    Ember.isNone();              // true
    Ember.isNone(null);          // true
    Ember.isNone(undefined);     // true
    Ember.isNone('');            // false
    Ember.isNone([]);            // false
    Ember.isNone(function() {}); // false
    ```
  
    @method isNone
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */
  "use strict";

  exports.default = isNone;

  function isNone(obj) {
    return obj === null || obj === undefined;
  }
});
enifed('ember-metal/is_present', ['exports', 'ember-metal/is_blank'], function (exports, _emberMetalIs_blank) {
  'use strict';

  exports.default = isPresent;

  /**
    A value is present if it not `isBlank`.
  
    ```javascript
    Ember.isPresent();                // false
    Ember.isPresent(null);            // false
    Ember.isPresent(undefined);       // false
    Ember.isPresent('');              // false
    Ember.isPresent('  ');            // false
    Ember.isPresent('\n\t');          // false
    Ember.isPresent([]);              // false
    Ember.isPresent({ length: 0 })    // false
    Ember.isPresent(false);           // true
    Ember.isPresent(true);            // true
    Ember.isPresent('string');        // true
    Ember.isPresent(0);               // true
    Ember.isPresent(function() {})    // true
    Ember.isPresent({});              // true
    Ember.isPresent(false);           // true
    Ember.isPresent('\n\t Hello');    // true
    Ember.isPresent([1,2,3]);         // true
    ```
  
    @method isPresent
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.8.0
    @public
  */

  function isPresent(obj) {
    return !_emberMetalIs_blank.default(obj);
  }
});
enifed('ember-metal/is_proxy', ['exports', 'ember-metal/meta'], function (exports, _emberMetalMeta) {
  'use strict';

  exports.isProxy = isProxy;

  function isProxy(value) {
    if (typeof value === 'object' && value) {
      var meta = _emberMetalMeta.peekMeta(value);
      return meta && meta.isProxy();
    }

    return false;
  }
});
enifed('ember-metal/libraries', ['exports', 'ember-metal/debug', 'ember-metal/features'], function (exports, _emberMetalDebug, _emberMetalFeatures) {
  'use strict';

  exports.Libraries = Libraries;

  /**
    Helper class that allows you to register your library with Ember.
  
    Singleton created at `Ember.libraries`.
  
    @class Libraries
    @constructor
    @private
  */

  function Libraries() {
    this._registry = [];
    this._coreLibIndex = 0;
  }

  Libraries.prototype = {
    constructor: Libraries,

    _getLibraryByName: function (name) {
      var libs = this._registry;
      var count = libs.length;

      for (var i = 0; i < count; i++) {
        if (libs[i].name === name) {
          return libs[i];
        }
      }
    },

    register: function (name, version, isCoreLibrary) {
      var index = this._registry.length;

      if (!this._getLibraryByName(name)) {
        if (isCoreLibrary) {
          index = this._coreLibIndex++;
        }
        this._registry.splice(index, 0, { name: name, version: version });
      } else {
        _emberMetalDebug.warn('Library "' + name + '" is already registered with Ember.', false, { id: 'ember-metal.libraries-register' });
      }
    },

    registerCoreLibrary: function (name, version) {
      this.register(name, version, true);
    },

    deRegister: function (name) {
      var lib = this._getLibraryByName(name);
      var index = undefined;

      if (lib) {
        index = this._registry.indexOf(lib);
        this._registry.splice(index, 1);
      }
    }
  };

  if (false) {
    Libraries.prototype.isRegistered = function (name) {
      return !!this._getLibraryByName(name);
    };
  }

  exports.default = new Libraries();
});
enifed('ember-metal/map', ['exports', 'ember-utils'], function (exports, _emberUtils) {
  /**
  @module ember
  @submodule ember-metal
  */

  /*
    JavaScript (before ES6) does not have a Map implementation. Objects,
    which are often used as dictionaries, may only have Strings as keys.
  
    Because Ember has a way to get a unique identifier for every object
    via `Ember.guidFor`, we can implement a performant Map with arbitrary
    keys. Because it is commonly used in low-level bookkeeping, Map is
    implemented as a pure JavaScript object for performance.
  
    This implementation follows the current iteration of the ES6 proposal for
    maps (http://wiki.ecmascript.org/doku.php?id=harmony:simple_maps_and_sets),
    with one exception:  as we do not have the luxury of in-VM iteration, we implement a
    forEach method for iteration.
  
    Map is mocked out to look like an Ember object, so you can do
    `Ember.Map.create()` for symmetry with other Ember classes.
  */
  'use strict';

  function missingFunction(fn) {
    throw new TypeError(Object.prototype.toString.call(fn) + ' is not a function');
  }

  function missingNew(name) {
    throw new TypeError('Constructor ' + name + ' requires \'new\'');
  }

  function copyNull(obj) {
    var output = new _emberUtils.EmptyObject();

    for (var prop in obj) {
      // hasOwnPropery is not needed because obj is new EmptyObject();
      output[prop] = obj[prop];
    }

    return output;
  }

  function copyMap(original, newObject) {
    var keys = original._keys.copy();
    var values = copyNull(original._values);

    newObject._keys = keys;
    newObject._values = values;
    newObject.size = original.size;

    return newObject;
  }

  /**
    This class is used internally by Ember and Ember Data.
    Please do not use it at this time. We plan to clean it up
    and add many tests soon.
  
    @class OrderedSet
    @namespace Ember
    @constructor
    @private
  */
  function OrderedSet() {
    if (this instanceof OrderedSet) {
      this.clear();
      this._silenceRemoveDeprecation = false;
    } else {
      missingNew('OrderedSet');
    }
  }

  /**
    @method create
    @static
    @return {Ember.OrderedSet}
    @private
  */
  OrderedSet.create = function () {
    var Constructor = this;

    return new Constructor();
  };

  OrderedSet.prototype = {
    constructor: OrderedSet,
    /**
      @method clear
      @private
    */
    clear: function () {
      this.presenceSet = new _emberUtils.EmptyObject();
      this.list = [];
      this.size = 0;
    },

    /**
      @method add
      @param obj
      @param guid (optional, and for internal use)
      @return {Ember.OrderedSet}
      @private
    */
    add: function (obj, _guid) {
      var guid = _guid || _emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] !== true) {
        presenceSet[guid] = true;
        this.size = list.push(obj);
      }

      return this;
    },

    /**
      @since 1.8.0
      @method delete
      @param obj
      @param _guid (optional and for internal use only)
      @return {Boolean}
      @private
    */
    delete: function (obj, _guid) {
      var guid = _guid || _emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] === true) {
        delete presenceSet[guid];
        var index = list.indexOf(obj);
        if (index > -1) {
          list.splice(index, 1);
        }
        this.size = list.length;
        return true;
      } else {
        return false;
      }
    },

    /**
      @method isEmpty
      @return {Boolean}
      @private
    */
    isEmpty: function () {
      return this.size === 0;
    },

    /**
      @method has
      @param obj
      @return {Boolean}
      @private
    */
    has: function (obj) {
      if (this.size === 0) {
        return false;
      }

      var guid = _emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;

      return presenceSet[guid] === true;
    },

    /**
      @method forEach
      @param {Function} fn
      @param self
      @private
    */
    forEach: function (fn /*, ...thisArg*/) {
      if (typeof fn !== 'function') {
        missingFunction(fn);
      }

      if (this.size === 0) {
        return;
      }

      var list = this.list;

      if (arguments.length === 2) {
        for (var i = 0; i < list.length; i++) {
          fn.call(arguments[1], list[i]);
        }
      } else {
        for (var i = 0; i < list.length; i++) {
          fn(list[i]);
        }
      }
    },

    /**
      @method toArray
      @return {Array}
      @private
    */
    toArray: function () {
      return this.list.slice();
    },

    /**
      @method copy
      @return {Ember.OrderedSet}
      @private
    */
    copy: function () {
      var Constructor = this.constructor;
      var set = new Constructor();

      set._silenceRemoveDeprecation = this._silenceRemoveDeprecation;
      set.presenceSet = copyNull(this.presenceSet);
      set.list = this.toArray();
      set.size = this.size;

      return set;
    }
  };

  /**
    A Map stores values indexed by keys. Unlike JavaScript's
    default Objects, the keys of a Map can be any JavaScript
    object.
  
    Internally, a Map has two data structures:
  
    1. `keys`: an OrderedSet of all of the existing keys
    2. `values`: a JavaScript Object indexed by the `Ember.guidFor(key)`
  
    When a key/value pair is added for the first time, we
    add the key to the `keys` OrderedSet, and create or
    replace an entry in `values`. When an entry is deleted,
    we delete its entry in `keys` and `values`.
  
    @class Map
    @namespace Ember
    @private
    @constructor
  */
  function Map() {
    if (this instanceof Map) {
      this._keys = OrderedSet.create();
      this._keys._silenceRemoveDeprecation = true;
      this._values = new _emberUtils.EmptyObject();
      this.size = 0;
    } else {
      missingNew('Map');
    }
  }

  /**
    @method create
    @static
    @private
  */
  Map.create = function () {
    var Constructor = this;
    return new Constructor();
  };

  Map.prototype = {
    constructor: Map,

    /**
      This property will change as the number of objects in the map changes.
       @since 1.8.0
      @property size
      @type number
      @default 0
      @private
    */
    size: 0,

    /**
      Retrieve the value associated with a given key.
       @method get
      @param {*} key
      @return {*} the value associated with the key, or `undefined`
      @private
    */
    get: function (key) {
      if (this.size === 0) {
        return;
      }

      var values = this._values;
      var guid = _emberUtils.guidFor(key);

      return values[guid];
    },

    /**
      Adds a value to the map. If a value for the given key has already been
      provided, the new value will replace the old value.
       @method set
      @param {*} key
      @param {*} value
      @return {Ember.Map}
      @private
    */
    set: function (key, value) {
      var keys = this._keys;
      var values = this._values;
      var guid = _emberUtils.guidFor(key);

      // ensure we don't store -0
      var k = key === -0 ? 0 : key;

      keys.add(k, guid);

      values[guid] = value;

      this.size = keys.size;

      return this;
    },

    /**
      Removes a value from the map for an associated key.
       @since 1.8.0
      @method delete
      @param {*} key
      @return {Boolean} true if an item was removed, false otherwise
      @private
    */
    delete: function (key) {
      if (this.size === 0) {
        return false;
      }
      // don't use ES6 "delete" because it will be annoying
      // to use in browsers that are not ES6 friendly;
      var keys = this._keys;
      var values = this._values;
      var guid = _emberUtils.guidFor(key);

      if (keys.delete(key, guid)) {
        delete values[guid];
        this.size = keys.size;
        return true;
      } else {
        return false;
      }
    },

    /**
      Check whether a key is present.
       @method has
      @param {*} key
      @return {Boolean} true if the item was present, false otherwise
      @private
    */
    has: function (key) {
      return this._keys.has(key);
    },

    /**
      Iterate over all the keys and values. Calls the function once
      for each key, passing in value, key, and the map being iterated over,
      in that order.
       The keys are guaranteed to be iterated over in insertion order.
       @method forEach
      @param {Function} callback
      @param {*} self if passed, the `this` value inside the
        callback. By default, `this` is the map.
      @private
    */
    forEach: function (callback /*, ...thisArg*/) {
      if (typeof callback !== 'function') {
        missingFunction(callback);
      }

      if (this.size === 0) {
        return;
      }

      var map = this;
      var cb = undefined,
          thisArg = undefined;

      if (arguments.length === 2) {
        thisArg = arguments[1];
        cb = function (key) {
          return callback.call(thisArg, map.get(key), key, map);
        };
      } else {
        cb = function (key) {
          return callback(map.get(key), key, map);
        };
      }

      this._keys.forEach(cb);
    },

    /**
      @method clear
      @private
    */
    clear: function () {
      this._keys.clear();
      this._values = new _emberUtils.EmptyObject();
      this.size = 0;
    },

    /**
      @method copy
      @return {Ember.Map}
      @private
    */
    copy: function () {
      return copyMap(this, new Map());
    }
  };

  /**
    @class MapWithDefault
    @namespace Ember
    @extends Ember.Map
    @private
    @constructor
    @param [options]
      @param {*} [options.defaultValue]
  */
  function MapWithDefault(options) {
    this._super$constructor();
    this.defaultValue = options.defaultValue;
  }

  /**
    @method create
    @static
    @param [options]
      @param {*} [options.defaultValue]
    @return {Ember.MapWithDefault|Ember.Map} If options are passed, returns
      `Ember.MapWithDefault` otherwise returns `Ember.Map`
    @private
  */
  MapWithDefault.create = function (options) {
    if (options) {
      return new MapWithDefault(options);
    } else {
      return new Map();
    }
  };

  MapWithDefault.prototype = Object.create(Map.prototype);
  MapWithDefault.prototype.constructor = MapWithDefault;
  MapWithDefault.prototype._super$constructor = Map;
  MapWithDefault.prototype._super$get = Map.prototype.get;

  /**
    Retrieve the value associated with a given key.
  
    @method get
    @param {*} key
    @return {*} the value associated with the key, or the default value
    @private
  */
  MapWithDefault.prototype.get = function (key) {
    var hasValue = this.has(key);

    if (hasValue) {
      return this._super$get(key);
    } else {
      var defaultValue = this.defaultValue(key);
      this.set(key, defaultValue);
      return defaultValue;
    }
  };

  /**
    @method copy
    @return {Ember.MapWithDefault}
    @private
  */
  MapWithDefault.prototype.copy = function () {
    var Constructor = this.constructor;
    return copyMap(this, new Constructor({
      defaultValue: this.defaultValue
    }));
  };

  exports.default = Map;
  exports.OrderedSet = OrderedSet;
  exports.Map = Map;
  exports.MapWithDefault = MapWithDefault;
});
enifed('ember-metal/merge', ['exports'], function (exports) {
  /**
    Merge the contents of two objects together into the first object.
  
    ```javascript
    Ember.merge({ first: 'Tom' }, { last: 'Dale' }); // { first: 'Tom', last: 'Dale' }
    var a = { first: 'Yehuda' };
    var b = { last: 'Katz' };
    Ember.merge(a, b); // a == { first: 'Yehuda', last: 'Katz' }, b == { last: 'Katz' }
    ```
  
    @method merge
    @for Ember
    @param {Object} original The object to merge into
    @param {Object} updates The object to copy properties from
    @return {Object}
    @public
  */
  'use strict';

  exports.default = merge;

  function merge(original, updates) {
    if (!updates || typeof updates !== 'object') {
      return original;
    }

    var props = Object.keys(updates);
    var prop = undefined;

    for (var i = 0; i < props.length; i++) {
      prop = props[i];
      original[prop] = updates[prop];
    }

    return original;
  }
});
enifed('ember-metal/meta', ['exports', 'ember-utils', 'ember-metal/features', 'ember-metal/meta_listeners', 'ember-metal/debug', 'ember-metal/chains'], function (exports, _emberUtils, _emberMetalFeatures, _emberMetalMeta_listeners, _emberMetalDebug, _emberMetalChains) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  exports.Meta = Meta;
  exports.deleteMeta = deleteMeta;
  exports.meta = meta;

  var counters = {
    peekCalls: 0,
    peekParentCalls: 0,
    peekPrototypeWalks: 0,
    setCalls: 0,
    deleteCalls: 0,
    metaCalls: 0,
    metaInstantiated: 0
  };

  /**
  @module ember-metal
  */

  /*
   This declares several meta-programmed members on the Meta class. Such
   meta!
  
   In general, the `readable` variants will give you an object (if it
   already exists) that you can read but should not modify. The
   `writable` variants will give you a mutable object, and they will
   create it if it didn't already exist.
  
   The following methods will get generated metaprogrammatically, and
   I'm including them here for greppability:
  
   writableCache, readableCache, writeWatching,
   peekWatching, clearWatching, writeMixins,
   peekMixins, clearMixins, writeBindings,
   peekBindings, clearBindings, writeValues,
   peekValues, clearValues, writeDeps, forEachInDeps
   writableChainWatchers, readableChainWatchers, writableChains,
   readableChains, writableTag, readableTag, writableTags,
   readableTags
  */
  var members = {
    cache: ownMap,
    weak: ownMap,
    watching: inheritedMap,
    mixins: inheritedMap,
    bindings: inheritedMap,
    values: inheritedMap,
    chainWatchers: ownCustomObject,
    chains: inheritedCustomObject,
    tag: ownCustomObject,
    tags: ownMap
  };

  // FLAGS
  var SOURCE_DESTROYING = 1 << 1;
  var SOURCE_DESTROYED = 1 << 2;
  var META_DESTROYED = 1 << 3;
  var IS_PROXY = 1 << 4;

  if (true || false) {
    members.lastRendered = ownMap;
    members.lastRenderedFrom = ownMap; // FIXME: not used in production, remove me from prod builds
  }

  var memberNames = Object.keys(members);
  var META_FIELD = '__ember_meta__';

  function Meta(obj, parentMeta) {
    _emberMetalDebug.runInDebug(function () {
      return counters.metaInstantiated++;
    });

    this._cache = undefined;
    this._weak = undefined;
    this._watching = undefined;
    this._mixins = undefined;
    this._bindings = undefined;
    this._values = undefined;
    this._deps = undefined;
    this._chainWatchers = undefined;
    this._chains = undefined;
    this._tag = undefined;
    this._tags = undefined;

    // initial value for all flags right now is false
    // see FLAGS const for detailed list of flags used
    this._flags = 0;

    // used only internally
    this.source = obj;

    // when meta(obj).proto === obj, the object is intended to be only a
    // prototype and doesn't need to actually be observable itself
    this.proto = undefined;

    // The next meta in our inheritance chain. We (will) track this
    // explicitly instead of using prototypical inheritance because we
    // have detailed knowledge of how each property should really be
    // inherited, and we can optimize it much better than JS runtimes.
    this.parent = parentMeta;

    if (true || false) {
      this._lastRendered = undefined;
      this._lastRenderedFrom = undefined; // FIXME: not used in production, remove me from prod builds
    }

    this._initializeListeners();
  }

  Meta.prototype.isInitialized = function (obj) {
    return this.proto !== obj;
  };

  var NODE_STACK = [];

  Meta.prototype.destroy = function () {
    if (this.isMetaDestroyed()) {
      return;
    }

    // remove chainWatchers to remove circular references that would prevent GC
    var node = undefined,
        nodes = undefined,
        key = undefined,
        nodeObject = undefined;
    node = this.readableChains();
    if (node) {
      NODE_STACK.push(node);
      // process tree
      while (NODE_STACK.length > 0) {
        node = NODE_STACK.pop();
        // push children
        nodes = node._chains;
        if (nodes) {
          for (key in nodes) {
            if (nodes[key] !== undefined) {
              NODE_STACK.push(nodes[key]);
            }
          }
        }

        // remove chainWatcher in node object
        if (node._watching) {
          nodeObject = node._object;
          if (nodeObject) {
            var foreignMeta = peekMeta(nodeObject);
            // avoid cleaning up chain watchers when both current and
            // foreign objects are being destroyed
            // if both are being destroyed manual cleanup is not needed
            // as they will be GC'ed and no non-destroyed references will
            // be remaining
            if (foreignMeta && !foreignMeta.isSourceDestroying()) {
              _emberMetalChains.removeChainWatcher(nodeObject, node._key, node, foreignMeta);
            }
          }
        }
      }
    }

    this.setMetaDestroyed();
  };

  for (var _name in _emberMetalMeta_listeners.protoMethods) {
    Meta.prototype[_name] = _emberMetalMeta_listeners.protoMethods[_name];
  }
  memberNames.forEach(function (name) {
    return members[name](name, Meta);
  });

  Meta.prototype.isSourceDestroying = function isSourceDestroying() {
    return (this._flags & SOURCE_DESTROYING) !== 0;
  };

  Meta.prototype.setSourceDestroying = function setSourceDestroying() {
    this._flags |= SOURCE_DESTROYING;
  };

  Meta.prototype.isSourceDestroyed = function isSourceDestroyed() {
    return (this._flags & SOURCE_DESTROYED) !== 0;
  };

  Meta.prototype.setSourceDestroyed = function setSourceDestroyed() {
    this._flags |= SOURCE_DESTROYED;
  };

  Meta.prototype.isMetaDestroyed = function isMetaDestroyed() {
    return (this._flags & META_DESTROYED) !== 0;
  };

  Meta.prototype.setMetaDestroyed = function setMetaDestroyed() {
    this._flags |= META_DESTROYED;
  };

  Meta.prototype.isProxy = function isProxy() {
    return (this._flags & IS_PROXY) !== 0;
  };

  Meta.prototype.setProxy = function setProxy() {
    this._flags |= IS_PROXY;
  };

  // Implements a member that is a lazily created, non-inheritable
  // POJO.
  function ownMap(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function () {
      return this._getOrCreateOwnMap(key);
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this[key];
    };
  }

  Meta.prototype._getOrCreateOwnMap = function (key) {
    var ret = this[key];
    if (!ret) {
      ret = this[key] = new _emberUtils.EmptyObject();
    }
    return ret;
  };

  // Implements a member that is a lazily created POJO with inheritable
  // values.
  function inheritedMap(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);

    Meta.prototype['write' + capitalized] = function (subkey, value) {
      _emberMetalDebug.assert('Cannot call write' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      var map = this._getOrCreateOwnMap(key);
      map[subkey] = value;
    };

    Meta.prototype['peek' + capitalized] = function (subkey) {
      return this._findInherited(key, subkey);
    };

    Meta.prototype['forEach' + capitalized] = function (fn) {
      var pointer = this;
      var seen = new _emberUtils.EmptyObject();
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map) {
          for (var _key in map) {
            if (!seen[_key]) {
              seen[_key] = true;
              fn(_key, map[_key]);
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype['clear' + capitalized] = function () {
      _emberMetalDebug.assert('Cannot call clear' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      this[key] = undefined;
    };

    Meta.prototype['deleteFrom' + capitalized] = function (subkey) {
      delete this._getOrCreateOwnMap(key)[subkey];
    };

    Meta.prototype['hasIn' + capitalized] = function (subkey) {
      return this._findInherited(key, subkey) !== undefined;
    };
  }

  Meta.prototype._getInherited = function (key) {
    var pointer = this;
    while (pointer !== undefined) {
      if (pointer[key]) {
        return pointer[key];
      }
      pointer = pointer.parent;
    }
  };

  Meta.prototype._findInherited = function (key, subkey) {
    var pointer = this;
    while (pointer !== undefined) {
      var map = pointer[key];
      if (map) {
        var value = map[subkey];
        if (value !== undefined) {
          return value;
        }
      }
      pointer = pointer.parent;
    }
  };

  var UNDEFINED = _emberUtils.symbol('undefined');

  exports.UNDEFINED = UNDEFINED;
  // Implements a member that provides a lazily created map of maps,
  // with inheritance at both levels.
  Meta.prototype.writeDeps = function writeDeps(subkey, itemkey, value) {
    _emberMetalDebug.assert('Cannot call writeDeps after the object is destroyed.', !this.isMetaDestroyed());

    var outerMap = this._getOrCreateOwnMap('_deps');
    var innerMap = outerMap[subkey];
    if (!innerMap) {
      innerMap = outerMap[subkey] = new _emberUtils.EmptyObject();
    }
    innerMap[itemkey] = value;
  };

  Meta.prototype.peekDeps = function peekDeps(subkey, itemkey) {
    var pointer = this;
    while (pointer !== undefined) {
      var map = pointer._deps;
      if (map) {
        var value = map[subkey];
        if (value) {
          if (value[itemkey] !== undefined) {
            return value[itemkey];
          }
        }
      }
      pointer = pointer.parent;
    }
  };

  Meta.prototype.hasDeps = function hasDeps(subkey) {
    var pointer = this;
    while (pointer !== undefined) {
      if (pointer._deps && pointer._deps[subkey]) {
        return true;
      }
      pointer = pointer.parent;
    }
    return false;
  };

  Meta.prototype.forEachInDeps = function forEachInDeps(subkey, fn) {
    return this._forEachIn('_deps', subkey, fn);
  };

  Meta.prototype._forEachIn = function (key, subkey, fn) {
    var pointer = this;
    var seen = new _emberUtils.EmptyObject();
    var calls = [];
    while (pointer !== undefined) {
      var map = pointer[key];
      if (map) {
        var innerMap = map[subkey];
        if (innerMap) {
          for (var innerKey in innerMap) {
            if (!seen[innerKey]) {
              seen[innerKey] = true;
              calls.push([innerKey, innerMap[innerKey]]);
            }
          }
        }
      }
      pointer = pointer.parent;
    }
    for (var i = 0; i < calls.length; i++) {
      var _calls$i = calls[i];
      var innerKey = _calls$i[0];
      var value = _calls$i[1];

      fn(innerKey, value);
    }
  };

  // Implements a member that provides a non-heritable, lazily-created
  // object using the method you provide.
  function ownCustomObject(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function (create) {
      _emberMetalDebug.assert('Cannot call writable' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      var ret = this[key];
      if (!ret) {
        ret = this[key] = create(this.source);
      }
      return ret;
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this[key];
    };
  }

  // Implements a member that provides an inheritable, lazily-created
  // object using the method you provide. We will derived children from
  // their parents by calling your object's `copy()` method.
  function inheritedCustomObject(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function (create) {
      _emberMetalDebug.assert('Cannot call writable' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      var ret = this[key];
      if (!ret) {
        if (this.parent) {
          ret = this[key] = this.parent['writable' + capitalized](create).copy(this.source);
        } else {
          ret = this[key] = create(this.source);
        }
      }
      return ret;
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this._getInherited(key);
    };
  }

  function memberProperty(name) {
    return '_' + name;
  }

  // there's a more general-purpose capitalize in ember-runtime, but we
  // don't want to make ember-metal depend on ember-runtime.
  function capitalize(name) {
    return name.replace(/^\w/, function (m) {
      return m.toUpperCase();
    });
  }

  var META_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  exports.META_DESC = META_DESC;
  var EMBER_META_PROPERTY = {
    name: META_FIELD,
    descriptor: META_DESC
  };

  if (true) {
    Meta.prototype.readInheritedValue = function (key, subkey) {
      var internalKey = '_' + key;

      var pointer = this;

      while (pointer !== undefined) {
        var map = pointer[internalKey];
        if (map) {
          var value = map[subkey];
          if (value !== undefined || subkey in map) {
            return map[subkey];
          }
        }
        pointer = pointer.parent;
      }

      return UNDEFINED;
    };

    Meta.prototype.writeValue = function (obj, key, value) {
      var descriptor = _emberUtils.lookupDescriptor(obj, key);
      var isMandatorySetter = descriptor && descriptor.set && descriptor.set.isMandatorySetter;

      if (isMandatorySetter) {
        this.writeValues(key, value);
      } else {
        obj[key] = value;
      }
    };
  }

  var HAS_NATIVE_WEAKMAP = (function () {
    // detect if `WeakMap` is even present
    var hasWeakMap = typeof WeakMap === 'function';
    if (!hasWeakMap) {
      return false;
    }

    var instance = new WeakMap();
    // use `Object`'s `.toString` directly to prevent us from detecting
    // polyfills as native weakmaps
    return Object.prototype.toString.call(instance) === '[object WeakMap]';
  })();

  var setMeta = undefined,
      peekMeta = undefined;

  // choose the one appropriate for given platform
  if (HAS_NATIVE_WEAKMAP) {
    (function () {
      var getPrototypeOf = Object.getPrototypeOf;
      var metaStore = new WeakMap();

      exports.setMeta = setMeta = function WeakMap_setMeta(obj, meta) {
        _emberMetalDebug.runInDebug(function () {
          return counters.setCalls++;
        });
        metaStore.set(obj, meta);
      };

      exports.peekMeta = peekMeta = function WeakMap_peekMeta(obj) {
        _emberMetalDebug.runInDebug(function () {
          return counters.peekCalls++;
        });

        return metaStore.get(obj);
      };

      exports.peekMeta = peekMeta = function WeakMap_peekParentMeta(obj) {
        var pointer = obj;
        var meta = undefined;
        while (pointer) {
          meta = metaStore.get(pointer);
          // jshint loopfunc:true
          _emberMetalDebug.runInDebug(function () {
            return counters.peekCalls++;
          });
          // stop if we find a `null` value, since
          // that means the meta was deleted
          // any other truthy value is a "real" meta
          if (meta === null || meta) {
            return meta;
          }

          pointer = getPrototypeOf(pointer);
          _emberMetalDebug.runInDebug(function () {
            return counters.peakPrototypeWalks++;
          });
        }
      };
    })();
  } else {
    exports.setMeta = setMeta = function Fallback_setMeta(obj, meta) {
      // if `null` already, just set it to the new value
      // otherwise define property first
      if (obj[META_FIELD] !== null) {
        if (obj.__defineNonEnumerable) {
          obj.__defineNonEnumerable(EMBER_META_PROPERTY);
        } else {
          Object.defineProperty(obj, META_FIELD, META_DESC);
        }
      }

      obj[META_FIELD] = meta;
    };

    exports.peekMeta = peekMeta = function Fallback_peekMeta(obj) {
      return obj[META_FIELD];
    };
  }

  function deleteMeta(obj) {
    _emberMetalDebug.runInDebug(function () {
      return counters.deleteCalls++;
    });

    var meta = peekMeta(obj);
    if (meta) {
      meta.destroy();
    }
  }

  /**
    Retrieves the meta hash for an object. If `writable` is true ensures the
    hash is writable for this object as well.
  
    The meta object contains information about computed property descriptors as
    well as any watched properties and other information. You generally will
    not access this information directly but instead work with higher level
    methods that manipulate this hash indirectly.
  
    @method meta
    @for Ember
    @private
  
    @param {Object} obj The object to retrieve meta for
    @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
      the meta hash, allowing the method to avoid making an unnecessary copy.
    @return {Object} the meta hash for an object
  */

  function meta(obj) {
    _emberMetalDebug.runInDebug(function () {
      return counters.metaCalls++;
    });

    var maybeMeta = peekMeta(obj);
    var parent = undefined;

    // remove this code, in-favor of explicit parent
    if (maybeMeta) {
      if (maybeMeta.source === obj) {
        return maybeMeta;
      }
      parent = maybeMeta;
    }

    var newMeta = new Meta(obj, parent);
    setMeta(obj, newMeta);
    return newMeta;
  }

  exports.peekMeta = peekMeta;
  exports.setMeta = setMeta;
  exports.counters = counters;
});
enifed('ember-metal/meta_listeners', ['exports'], function (exports) {
  /*
   When we render a rich template hierarchy, the set of events that
   *might* happen tends to be much larger than the set of events that
   actually happen. This implies that we should make listener creation &
   destruction cheap, even at the cost of making event dispatch more
   expensive.
  
   Thus we store a new listener with a single push and no new
   allocations, without even bothering to do deduplication -- we can
   save that for dispatch time, if an event actually happens.
   */

  /* listener flags */
  'use strict';

  var ONCE = 1;
  exports.ONCE = ONCE;
  var SUSPENDED = 2;

  exports.SUSPENDED = SUSPENDED;
  var protoMethods = {

    addToListeners: function (eventName, target, method, flags) {
      if (!this._listeners) {
        this._listeners = [];
      }
      this._listeners.push(eventName, target, method, flags);
    },

    _finalizeListeners: function () {
      if (this._listenersFinalized) {
        return;
      }
      if (!this._listeners) {
        this._listeners = [];
      }
      var pointer = this.parent;
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          this._listeners = this._listeners.concat(listeners);
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      this._listenersFinalized = true;
    },

    removeFromListeners: function (eventName, target, method, didRemove) {
      var pointer = this;
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = listeners.length - 4; index >= 0; index -= 4) {
            if (listeners[index] === eventName && (!method || listeners[index + 1] === target && listeners[index + 2] === method)) {
              if (pointer === this) {
                // we are modifying our own list, so we edit directly
                if (typeof didRemove === 'function') {
                  didRemove(eventName, target, listeners[index + 2]);
                }
                listeners.splice(index, 4);
              } else {
                // we are trying to remove an inherited listener, so we do
                // just-in-time copying to detach our own listeners from
                // our inheritance chain.
                this._finalizeListeners();
                return this.removeFromListeners(eventName, target, method);
              }
            }
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
    },

    matchingListeners: function (eventName) {
      var pointer = this;
      var result = [];
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = 0; index < listeners.length - 3; index += 4) {
            if (listeners[index] === eventName) {
              pushUniqueListener(result, listeners, index);
            }
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      var sus = this._suspendedListeners;
      if (sus) {
        for (var susIndex = 0; susIndex < sus.length - 2; susIndex += 3) {
          if (eventName === sus[susIndex]) {
            for (var resultIndex = 0; resultIndex < result.length - 2; resultIndex += 3) {
              if (result[resultIndex] === sus[susIndex + 1] && result[resultIndex + 1] === sus[susIndex + 2]) {
                result[resultIndex + 2] |= SUSPENDED;
              }
            }
          }
        }
      }
      return result;
    },

    suspendListeners: function (eventNames, target, method, callback) {
      var sus = this._suspendedListeners;
      if (!sus) {
        sus = this._suspendedListeners = [];
      }
      for (var i = 0; i < eventNames.length; i++) {
        sus.push(eventNames[i], target, method);
      }
      try {
        return callback.call(target);
      } finally {
        if (sus.length === eventNames.length) {
          this._suspendedListeners = undefined;
        } else {
          for (var i = sus.length - 3; i >= 0; i -= 3) {
            if (sus[i + 1] === target && sus[i + 2] === method && eventNames.indexOf(sus[i]) !== -1) {
              sus.splice(i, 3);
            }
          }
        }
      }
    },

    watchedEvents: function () {
      var pointer = this;
      var names = {};
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = 0; index < listeners.length - 3; index += 4) {
            names[listeners[index]] = true;
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      return Object.keys(names);
    },

    _initializeListeners: function () {
      this._listeners = undefined;
      this._listenersFinalized = undefined;
      this._suspendedListeners = undefined;
    }
  };

  exports.protoMethods = protoMethods;
  function pushUniqueListener(destination, source, index) {
    var target = source[index + 1];
    var method = source[index + 2];
    for (var destinationIndex = 0; destinationIndex < destination.length - 2; destinationIndex += 3) {
      if (destination[destinationIndex] === target && destination[destinationIndex + 1] === method) {
        return;
      }
    }
    destination.push(target, method, source[index + 3]);
  }
});
enifed('ember-metal/mixin', ['exports', 'ember-utils', 'ember-metal/error', 'ember-metal/debug', 'ember-metal/meta', 'ember-metal/expand_properties', 'ember-metal/properties', 'ember-metal/computed', 'ember-metal/binding', 'ember-metal/observer', 'ember-metal/events'], function (exports, _emberUtils, _emberMetalError, _emberMetalDebug, _emberMetalMeta, _emberMetalExpand_properties, _emberMetalProperties, _emberMetalComputed, _emberMetalBinding, _emberMetalObserver, _emberMetalEvents) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  /**
  @module ember
  @submodule ember-metal
  */
  exports.detectBinding = detectBinding;
  exports.mixin = mixin;
  exports.default = Mixin;
  exports.hasUnprocessedMixins = hasUnprocessedMixins;
  exports.clearUnprocessedMixins = clearUnprocessedMixins;
  exports.required = required;
  exports.aliasMethod = aliasMethod;
  exports.observer = observer;
  exports._immediateObserver = _immediateObserver;
  exports._beforeObserver = _beforeObserver;

  function ROOT() {}
  ROOT.__hasSuper = false;

  var a_slice = [].slice;

  function isMethod(obj) {
    return 'function' === typeof obj && obj.isMethod !== false && obj !== Boolean && obj !== Object && obj !== Number && obj !== Array && obj !== Date && obj !== String;
  }

  var CONTINUE = {};

  function mixinProperties(mixinsMeta, mixin) {
    var guid = undefined;

    if (mixin instanceof Mixin) {
      guid = _emberUtils.guidFor(mixin);
      if (mixinsMeta.peekMixins(guid)) {
        return CONTINUE;
      }
      mixinsMeta.writeMixins(guid, mixin);
      return mixin.properties;
    } else {
      return mixin; // apply anonymous mixin properties
    }
  }

  function concatenatedMixinProperties(concatProp, props, values, base) {
    var concats = undefined;

    // reset before adding each new mixin to pickup concats from previous
    concats = values[concatProp] || base[concatProp];
    if (props[concatProp]) {
      concats = concats ? concats.concat(props[concatProp]) : props[concatProp];
    }

    return concats;
  }

  function giveDescriptorSuper(meta, key, property, values, descs, base) {
    var superProperty = undefined;

    // Computed properties override methods, and do not call super to them
    if (values[key] === undefined) {
      // Find the original descriptor in a parent mixin
      superProperty = descs[key];
    }

    // If we didn't find the original descriptor in a parent mixin, find
    // it on the original object.
    if (!superProperty) {
      var possibleDesc = base[key];
      var superDesc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      superProperty = superDesc;
    }

    if (superProperty === undefined || !(superProperty instanceof _emberMetalComputed.ComputedProperty)) {
      return property;
    }

    // Since multiple mixins may inherit from the same parent, we need
    // to clone the computed property so that other mixins do not receive
    // the wrapped version.
    property = Object.create(property);
    property._getter = _emberUtils.wrap(property._getter, superProperty._getter);
    if (superProperty._setter) {
      if (property._setter) {
        property._setter = _emberUtils.wrap(property._setter, superProperty._setter);
      } else {
        property._setter = superProperty._setter;
      }
    }

    return property;
  }

  function giveMethodSuper(obj, key, method, values, descs) {
    var superMethod = undefined;

    // Methods overwrite computed properties, and do not call super to them.
    if (descs[key] === undefined) {
      // Find the original method in a parent mixin
      superMethod = values[key];
    }

    // If we didn't find the original value in a parent mixin, find it in
    // the original object
    superMethod = superMethod || obj[key];

    // Only wrap the new method if the original method was a function
    if (superMethod === undefined || 'function' !== typeof superMethod) {
      return method;
    }

    return _emberUtils.wrap(method, superMethod);
  }

  function applyConcatenatedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    if (baseValue) {
      if ('function' === typeof baseValue.concat) {
        if (value === null || value === undefined) {
          return baseValue;
        } else {
          return baseValue.concat(value);
        }
      } else {
        return _emberUtils.makeArray(baseValue).concat(value);
      }
    } else {
      return _emberUtils.makeArray(value);
    }
  }

  function applyMergedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    _emberMetalDebug.runInDebug(function () {
      if (Array.isArray(value)) {
        // use conditional to avoid stringifying every time
        _emberMetalDebug.assert('You passed in `' + JSON.stringify(value) + '` as the value for `' + key + '` but `' + key + '` cannot be an Array', false);
      }
    });

    if (!baseValue) {
      return value;
    }

    var newBase = _emberUtils.assign({}, baseValue);
    var hasFunction = false;

    for (var prop in value) {
      if (!value.hasOwnProperty(prop)) {
        continue;
      }

      var propValue = value[prop];
      if (isMethod(propValue)) {
        // TODO: support for Computed Properties, etc?
        hasFunction = true;
        newBase[prop] = giveMethodSuper(obj, prop, propValue, baseValue, {});
      } else {
        newBase[prop] = propValue;
      }
    }

    if (hasFunction) {
      newBase._super = ROOT;
    }

    return newBase;
  }

  function addNormalizedProperty(base, key, value, meta, descs, values, concats, mergings) {
    if (value instanceof _emberMetalProperties.Descriptor) {
      if (value === REQUIRED && descs[key]) {
        return CONTINUE;
      }

      // Wrap descriptor function to implement
      // _super() if needed
      if (value._getter) {
        value = giveDescriptorSuper(meta, key, value, values, descs, base);
      }

      descs[key] = value;
      values[key] = undefined;
    } else {
      if (concats && concats.indexOf(key) >= 0 || key === 'concatenatedProperties' || key === 'mergedProperties') {
        value = applyConcatenatedProperties(base, key, value, values);
      } else if (mergings && mergings.indexOf(key) >= 0) {
        value = applyMergedProperties(base, key, value, values);
      } else if (isMethod(value)) {
        value = giveMethodSuper(base, key, value, values, descs);
      }

      descs[key] = undefined;
      values[key] = value;
    }
  }

  function mergeMixins(mixins, m, descs, values, base, keys) {
    var currentMixin = undefined,
        props = undefined,
        key = undefined,
        concats = undefined,
        mergings = undefined;

    function removeKeys(keyName) {
      delete descs[keyName];
      delete values[keyName];
    }

    for (var i = 0; i < mixins.length; i++) {
      currentMixin = mixins[i];
      _emberMetalDebug.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]');

      props = mixinProperties(m, currentMixin);
      if (props === CONTINUE) {
        continue;
      }

      if (props) {
        if (base.willMergeMixin) {
          base.willMergeMixin(props);
        }
        concats = concatenatedMixinProperties('concatenatedProperties', props, values, base);
        mergings = concatenatedMixinProperties('mergedProperties', props, values, base);

        for (key in props) {
          if (!props.hasOwnProperty(key)) {
            continue;
          }
          keys.push(key);
          addNormalizedProperty(base, key, props[key], m, descs, values, concats, mergings);
        }

        // manually copy toString() because some JS engines do not enumerate it
        if (props.hasOwnProperty('toString')) {
          base.toString = props.toString;
        }
      } else if (currentMixin.mixins) {
        mergeMixins(currentMixin.mixins, m, descs, values, base, keys);
        if (currentMixin._without) {
          currentMixin._without.forEach(removeKeys);
        }
      }
    }
  }

  function detectBinding(key) {
    var length = key.length;

    return length > 7 && key.charCodeAt(length - 7) === 66 && key.indexOf('inding', length - 6) !== -1;
  }

  // warm both paths of above function
  detectBinding('notbound');
  detectBinding('fooBinding');

  function connectBindings(obj, m) {
    // TODO Mixin.apply(instance) should disconnect binding if exists
    m.forEachBindings(function (key, binding) {
      if (binding) {
        var to = key.slice(0, -7); // strip Binding off end
        if (binding instanceof _emberMetalBinding.Binding) {
          binding = binding.copy(); // copy prototypes' instance
          binding.to(to);
        } else {
          // binding is string path
          binding = new _emberMetalBinding.Binding(to, binding);
        }
        binding.connect(obj);
        obj[key] = binding;
      }
    });
    // mark as applied
    m.clearBindings();
  }

  function finishPartial(obj, m) {
    connectBindings(obj, m || _emberMetalMeta.meta(obj));
    return obj;
  }

  function followAlias(obj, desc, m, descs, values) {
    var altKey = desc.methodName;
    var value = undefined;
    var possibleDesc = undefined;
    if (descs[altKey] || values[altKey]) {
      value = values[altKey];
      desc = descs[altKey];
    } else if ((possibleDesc = obj[altKey]) && possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor) {
      desc = possibleDesc;
      value = undefined;
    } else {
      desc = undefined;
      value = obj[altKey];
    }

    return { desc: desc, value: value };
  }

  function updateObserversAndListeners(obj, key, observerOrListener, pathsKey, updateMethod) {
    var paths = observerOrListener[pathsKey];

    if (paths) {
      for (var i = 0; i < paths.length; i++) {
        updateMethod(obj, paths[i], null, key);
      }
    }
  }

  function replaceObserversAndListeners(obj, key, observerOrListener) {
    var prev = obj[key];

    if ('function' === typeof prev) {
      updateObserversAndListeners(obj, key, prev, '__ember_observesBefore__', _emberMetalObserver._removeBeforeObserver);
      updateObserversAndListeners(obj, key, prev, '__ember_observes__', _emberMetalObserver.removeObserver);
      updateObserversAndListeners(obj, key, prev, '__ember_listens__', _emberMetalEvents.removeListener);
    }

    if ('function' === typeof observerOrListener) {
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_observesBefore__', _emberMetalObserver._addBeforeObserver);
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_observes__', _emberMetalObserver.addObserver);
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_listens__', _emberMetalEvents.addListener);
    }
  }

  function applyMixin(obj, mixins, partial) {
    var descs = {};
    var values = {};
    var m = _emberMetalMeta.meta(obj);
    var keys = [];
    var key = undefined,
        value = undefined,
        desc = undefined;

    obj._super = ROOT;

    // Go through all mixins and hashes passed in, and:
    //
    // * Handle concatenated properties
    // * Handle merged properties
    // * Set up _super wrapping if necessary
    // * Set up computed property descriptors
    // * Copying `toString` in broken browsers
    mergeMixins(mixins, m, descs, values, obj, keys);

    for (var i = 0; i < keys.length; i++) {
      key = keys[i];
      if (key === 'constructor' || !values.hasOwnProperty(key)) {
        continue;
      }

      desc = descs[key];
      value = values[key];

      if (desc === REQUIRED) {
        continue;
      }

      while (desc && desc instanceof Alias) {
        var followed = followAlias(obj, desc, m, descs, values);
        desc = followed.desc;
        value = followed.value;
      }

      if (desc === undefined && value === undefined) {
        continue;
      }

      replaceObserversAndListeners(obj, key, value);

      if (detectBinding(key)) {
        m.writeBindings(key, value);
      }

      _emberMetalProperties.defineProperty(obj, key, desc, value, m);
    }

    if (!partial) {
      // don't apply to prototype
      finishPartial(obj, m);
    }

    return obj;
  }

  /**
    @method mixin
    @for Ember
    @param obj
    @param mixins*
    @return obj
    @private
  */

  function mixin(obj) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    applyMixin(obj, args, false);
    return obj;
  }

  var NAME_KEY = _emberUtils.GUID_KEY + '_name';

  exports.NAME_KEY = NAME_KEY;
  /**
    The `Ember.Mixin` class allows you to create mixins, whose properties can be
    added to other classes. For instance,
  
    ```javascript
    const EditableMixin = Ember.Mixin.create({
      edit() {
        console.log('starting to edit');
        this.set('isEditing', true);
      },
      isEditing: false
    });
  
    // Mix mixins into classes by passing them as the first arguments to
    // `.extend.`
    const Comment = Ember.Object.extend(EditableMixin, {
      post: null
    });
  
    let comment = Comment.create(post: somePost);
    comment.edit(); // outputs 'starting to edit'
    ```
  
    Note that Mixins are created with `Ember.Mixin.create`, not
    `Ember.Mixin.extend`.
  
    Note that mixins extend a constructor's prototype so arrays and object literals
    defined as properties will be shared amongst objects that implement the mixin.
    If you want to define a property in a mixin that is not shared, you can define
    it either as a computed property or have it be created on initialization of the object.
  
    ```javascript
    // filters array will be shared amongst any object implementing mixin
    const FilterableMixin = Ember.Mixin.create({
      filters: Ember.A()
    });
  
    // filters will be a separate array for every object implementing the mixin
    const FilterableMixin = Ember.Mixin.create({
      filters: Ember.computed(function() {
        return Ember.A();
      })
    });
  
    // filters will be created as a separate array during the object's initialization
    const Filterable = Ember.Mixin.create({
      init() {
        this._super(...arguments);
        this.set("filters", Ember.A());
      }
    });
    ```
  
    @class Mixin
    @namespace Ember
    @public
  */

  function Mixin(args, properties) {
    this.properties = properties;

    var length = args && args.length;

    if (length > 0) {
      var m = new Array(length);

      for (var i = 0; i < length; i++) {
        var x = args[i];
        if (x instanceof Mixin) {
          m[i] = x;
        } else {
          m[i] = new Mixin(undefined, x);
        }
      }

      this.mixins = m;
    } else {
      this.mixins = undefined;
    }
    this.ownerConstructor = undefined;
    this._without = undefined;
    this[_emberUtils.GUID_KEY] = null;
    this[NAME_KEY] = null;
    _emberMetalDebug.debugSeal(this);
  }

  Mixin._apply = applyMixin;

  Mixin.applyPartial = function (obj) {
    var args = a_slice.call(arguments, 1);
    return applyMixin(obj, args, true);
  };

  Mixin.finishPartial = finishPartial;

  var unprocessedFlag = false;

  function hasUnprocessedMixins() {
    return unprocessedFlag;
  }

  function clearUnprocessedMixins() {
    unprocessedFlag = false;
  }

  /**
    @method create
    @static
    @param arguments*
    @public
  */
  Mixin.create = function () {
    // ES6TODO: this relies on a global state?
    unprocessedFlag = true;
    var M = this;

    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return new M(args, undefined);
  };

  var MixinPrototype = Mixin.prototype;

  /**
    @method reopen
    @param arguments*
    @private
  */
  MixinPrototype.reopen = function () {
    var currentMixin = undefined;

    if (this.properties) {
      currentMixin = new Mixin(undefined, this.properties);
      this.properties = undefined;
      this.mixins = [currentMixin];
    } else if (!this.mixins) {
      this.mixins = [];
    }

    var mixins = this.mixins;
    var idx = undefined;

    for (idx = 0; idx < arguments.length; idx++) {
      currentMixin = arguments[idx];
      _emberMetalDebug.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]');

      if (currentMixin instanceof Mixin) {
        mixins.push(currentMixin);
      } else {
        mixins.push(new Mixin(undefined, currentMixin));
      }
    }

    return this;
  };

  /**
    @method apply
    @param obj
    @return applied object
    @private
  */
  MixinPrototype.apply = function (obj) {
    return applyMixin(obj, [this], false);
  };

  MixinPrototype.applyPartial = function (obj) {
    return applyMixin(obj, [this], true);
  };

  MixinPrototype.toString = Object.toString;

  function _detect(curMixin, targetMixin, seen) {
    var guid = _emberUtils.guidFor(curMixin);

    if (seen[guid]) {
      return false;
    }
    seen[guid] = true;

    if (curMixin === targetMixin) {
      return true;
    }
    var mixins = curMixin.mixins;
    var loc = mixins ? mixins.length : 0;
    while (--loc >= 0) {
      if (_detect(mixins[loc], targetMixin, seen)) {
        return true;
      }
    }
    return false;
  }

  /**
    @method detect
    @param obj
    @return {Boolean}
    @private
  */
  MixinPrototype.detect = function (obj) {
    if (typeof obj !== 'object' || obj === null) {
      return false;
    }
    if (obj instanceof Mixin) {
      return _detect(obj, this, {});
    }
    var m = _emberMetalMeta.peekMeta(obj);
    if (!m) {
      return false;
    }
    return !!m.peekMixins(_emberUtils.guidFor(this));
  };

  MixinPrototype.without = function () {
    var ret = new Mixin([this]);

    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    ret._without = args;
    return ret;
  };

  function _keys(ret, mixin, seen) {
    if (seen[_emberUtils.guidFor(mixin)]) {
      return;
    }
    seen[_emberUtils.guidFor(mixin)] = true;

    if (mixin.properties) {
      var props = Object.keys(mixin.properties);
      for (var i = 0; i < props.length; i++) {
        var key = props[i];
        ret[key] = true;
      }
    } else if (mixin.mixins) {
      mixin.mixins.forEach(function (x) {
        return _keys(ret, x, seen);
      });
    }
  }

  MixinPrototype.keys = function () {
    var keys = {};
    var seen = {};

    _keys(keys, this, seen);
    var ret = Object.keys(keys);
    return ret;
  };

  _emberMetalDebug.debugSeal(MixinPrototype);

  // returns the mixins currently applied to the specified object
  // TODO: Make Ember.mixin
  Mixin.mixins = function (obj) {
    var m = _emberMetalMeta.peekMeta(obj);
    var ret = [];
    if (!m) {
      return ret;
    }

    m.forEachMixins(function (key, currentMixin) {
      // skip primitive mixins since these are always anonymous
      if (!currentMixin.properties) {
        ret.push(currentMixin);
      }
    });

    return ret;
  };

  var REQUIRED = new _emberMetalProperties.Descriptor();
  REQUIRED.toString = function () {
    return '(Required Property)';
  };

  /**
    Denotes a required property for a mixin
  
    @method required
    @for Ember
    @private
  */

  function required() {
    _emberMetalDebug.deprecate('Ember.required is deprecated as its behavior is inconsistent and unreliable.', false, { id: 'ember-metal.required', until: '3.0.0' });
    return REQUIRED;
  }

  function Alias(methodName) {
    this.isDescriptor = true;
    this.methodName = methodName;
  }

  Alias.prototype = new _emberMetalProperties.Descriptor();

  /**
    Makes a method available via an additional name.
  
    ```javascript
    App.Person = Ember.Object.extend({
      name: function() {
        return 'Tomhuda Katzdale';
      },
      moniker: Ember.aliasMethod('name')
    });
  
    let goodGuy = App.Person.create();
  
    goodGuy.name();    // 'Tomhuda Katzdale'
    goodGuy.moniker(); // 'Tomhuda Katzdale'
    ```
  
    @method aliasMethod
    @for Ember
    @param {String} methodName name of the method to alias
    @public
  */

  function aliasMethod(methodName) {
    return new Alias(methodName);
  }

  // ..........................................................
  // OBSERVER HELPER
  //

  /**
    Specify a method that observes property changes.
  
    ```javascript
    Ember.Object.extend({
      valueObserver: Ember.observer('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    Also available as `Function.prototype.observes` if prototype extensions are
    enabled.
  
    @method observer
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @return func
    @public
  */

  function observer() {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    var func = args.slice(-1)[0];
    var paths = undefined;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };
    var _paths = args.slice(0, -1);

    if (typeof func !== 'function') {
      // revert to old, soft-deprecated argument ordering
      _emberMetalDebug.deprecate('Passing the dependentKeys after the callback function in Ember.observer is deprecated. Ensure the callback function is the last argument.', false, { id: 'ember-metal.observer-argument-order', until: '3.0.0' });

      func = args[0];
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      _emberMetalExpand_properties.default(_paths[i], addWatchedProperty);
    }

    if (typeof func !== 'function') {
      throw new _emberMetalError.default('Ember.observer called without a function');
    }

    func.__ember_observes__ = paths;
    return func;
  }

  /**
    Specify a method that observes property changes.
  
    ```javascript
    Ember.Object.extend({
      valueObserver: Ember.immediateObserver('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    In the future, `Ember.observer` may become asynchronous. In this event,
    `Ember.immediateObserver` will maintain the synchronous behavior.
  
    Also available as `Function.prototype.observesImmediately` if prototype extensions are
    enabled.
  
    @method _immediateObserver
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @deprecated Use `Ember.observer` instead.
    @return func
    @private
  */

  function _immediateObserver() {
    _emberMetalDebug.deprecate('Usage of `Ember.immediateObserver` is deprecated, use `Ember.observer` instead.', false, { id: 'ember-metal.immediate-observer', until: '3.0.0' });

    for (var i = 0; i < arguments.length; i++) {
      var arg = arguments[i];
      _emberMetalDebug.assert('Immediate observers must observe internal properties only, not properties on other objects.', typeof arg !== 'string' || arg.indexOf('.') === -1);
    }

    return observer.apply(this, arguments);
  }

  /**
    When observers fire, they are called with the arguments `obj`, `keyName`.
  
    Note, `@each.property` observer is called per each add or replace of an element
    and it's not called with a specific enumeration item.
  
    A `_beforeObserver` fires before a property changes.
  
    @method beforeObserver
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @return func
    @deprecated
    @private
  */

  function _beforeObserver() {
    for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      args[_key5] = arguments[_key5];
    }

    var func = args.slice(-1)[0];
    var paths = undefined;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };

    var _paths = args.slice(0, -1);

    if (typeof func !== 'function') {
      // revert to old, soft-deprecated argument ordering

      func = args[0];
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      _emberMetalExpand_properties.default(_paths[i], addWatchedProperty);
    }

    if (typeof func !== 'function') {
      throw new _emberMetalError.default('_beforeObserver called without a function');
    }

    func.__ember_observesBefore__ = paths;
    return func;
  }

  exports.Mixin = Mixin;
  exports.required = required;
  exports.REQUIRED = REQUIRED;
});
enifed('ember-metal/observer', ['exports', 'ember-metal/watching', 'ember-metal/events'], function (exports, _emberMetalWatching, _emberMetalEvents) {
  'use strict';

  exports.addObserver = addObserver;
  exports.observersFor = observersFor;
  exports.removeObserver = removeObserver;
  exports._addBeforeObserver = _addBeforeObserver;
  exports._suspendObserver = _suspendObserver;
  exports._suspendObservers = _suspendObservers;
  exports._removeBeforeObserver = _removeBeforeObserver;

  /**
  @module ember-metal
  */

  var AFTER_OBSERVERS = ':change';
  var BEFORE_OBSERVERS = ':before';

  function changeEvent(keyName) {
    return keyName + AFTER_OBSERVERS;
  }

  function beforeEvent(keyName) {
    return keyName + BEFORE_OBSERVERS;
  }

  /**
    @method addObserver
    @for Ember
    @param obj
    @param {String} _path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function addObserver(obj, _path, target, method) {
    _emberMetalEvents.addListener(obj, changeEvent(_path), target, method);
    _emberMetalWatching.watch(obj, _path);

    return this;
  }

  function observersFor(obj, path) {
    return _emberMetalEvents.listenersFor(obj, changeEvent(path));
  }

  /**
    @method removeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function removeObserver(obj, path, target, method) {
    _emberMetalWatching.unwatch(obj, path);
    _emberMetalEvents.removeListener(obj, changeEvent(path), target, method);

    return this;
  }

  /**
    @method _addBeforeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */

  function _addBeforeObserver(obj, path, target, method) {
    _emberMetalEvents.addListener(obj, beforeEvent(path), target, method);
    _emberMetalWatching.watch(obj, path);

    return this;
  }

  // Suspend observer during callback.
  //
  // This should only be used by the target of the observer
  // while it is setting the observed path.

  function _suspendObserver(obj, path, target, method, callback) {
    return _emberMetalEvents.suspendListener(obj, changeEvent(path), target, method, callback);
  }

  function _suspendObservers(obj, paths, target, method, callback) {
    var events = paths.map(changeEvent);
    return _emberMetalEvents.suspendListeners(obj, events, target, method, callback);
  }

  /**
    @method removeBeforeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */

  function _removeBeforeObserver(obj, path, target, method) {
    _emberMetalWatching.unwatch(obj, path);
    _emberMetalEvents.removeListener(obj, beforeEvent(path), target, method);

    return this;
  }
});
enifed('ember-metal/observer_set', ['exports', 'ember-utils', 'ember-metal/events'], function (exports, _emberUtils, _emberMetalEvents) {
  'use strict';

  exports.default = ObserverSet;

  /*
    this.observerSet = {
      [senderGuid]: { // variable name: `keySet`
        [keyName]: listIndex
      }
    },
    this.observers = [
      {
        sender: obj,
        keyName: keyName,
        eventName: eventName,
        listeners: [
          [target, method, flags]
        ]
      },
      ...
    ]
  */

  function ObserverSet() {
    this.clear();
  }

  ObserverSet.prototype.add = function (sender, keyName, eventName) {
    var observerSet = this.observerSet;
    var observers = this.observers;
    var senderGuid = _emberUtils.guidFor(sender);
    var keySet = observerSet[senderGuid];
    var index = undefined;

    if (!keySet) {
      observerSet[senderGuid] = keySet = {};
    }
    index = keySet[keyName];
    if (index === undefined) {
      index = observers.push({
        sender: sender,
        keyName: keyName,
        eventName: eventName,
        listeners: []
      }) - 1;
      keySet[keyName] = index;
    }
    return observers[index].listeners;
  };

  ObserverSet.prototype.flush = function () {
    var observers = this.observers;
    var i = undefined,
        observer = undefined,
        sender = undefined;
    this.clear();
    for (i = 0; i < observers.length; ++i) {
      observer = observers[i];
      sender = observer.sender;
      if (sender.isDestroying || sender.isDestroyed) {
        continue;
      }
      _emberMetalEvents.sendEvent(sender, observer.eventName, [sender, observer.keyName], observer.listeners);
    }
  };

  ObserverSet.prototype.clear = function () {
    this.observerSet = {};
    this.observers = [];
  };
});
enifed('ember-metal/path_cache', ['exports', 'ember-metal/cache'], function (exports, _emberMetalCache) {
  'use strict';

  exports.isGlobal = isGlobal;
  exports.isGlobalPath = isGlobalPath;
  exports.hasThis = hasThis;
  exports.isPath = isPath;
  exports.getFirstKey = getFirstKey;
  exports.getTailPath = getTailPath;

  var IS_GLOBAL = /^[A-Z$]/;
  var IS_GLOBAL_PATH = /^[A-Z$].*[\.]/;
  var HAS_THIS = 'this.';

  var isGlobalCache = new _emberMetalCache.default(1000, function (key) {
    return IS_GLOBAL.test(key);
  });
  var isGlobalPathCache = new _emberMetalCache.default(1000, function (key) {
    return IS_GLOBAL_PATH.test(key);
  });
  var hasThisCache = new _emberMetalCache.default(1000, function (key) {
    return key.lastIndexOf(HAS_THIS, 0) === 0;
  });
  var firstDotIndexCache = new _emberMetalCache.default(1000, function (key) {
    return key.indexOf('.');
  });

  var firstKeyCache = new _emberMetalCache.default(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index === -1) {
      return path;
    } else {
      return path.slice(0, index);
    }
  });

  var tailPathCache = new _emberMetalCache.default(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index !== -1) {
      return path.slice(index + 1);
    }
  });

  var caches = {
    isGlobalCache: isGlobalCache,
    isGlobalPathCache: isGlobalPathCache,
    hasThisCache: hasThisCache,
    firstDotIndexCache: firstDotIndexCache,
    firstKeyCache: firstKeyCache,
    tailPathCache: tailPathCache
  };

  exports.caches = caches;

  function isGlobal(path) {
    return isGlobalCache.get(path);
  }

  function isGlobalPath(path) {
    return isGlobalPathCache.get(path);
  }

  function hasThis(path) {
    return hasThisCache.get(path);
  }

  function isPath(path) {
    return firstDotIndexCache.get(path) !== -1;
  }

  function getFirstKey(path) {
    return firstKeyCache.get(path);
  }

  function getTailPath(path) {
    return tailPathCache.get(path);
  }
});
enifed('ember-metal/properties', ['exports', 'ember-metal/debug', 'ember-metal/features', 'ember-metal/meta', 'ember-metal/property_events'], function (exports, _emberMetalDebug, _emberMetalFeatures, _emberMetalMeta, _emberMetalProperty_events) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.Descriptor = Descriptor;
  exports.MANDATORY_SETTER_FUNCTION = MANDATORY_SETTER_FUNCTION;
  exports.DEFAULT_GETTER_FUNCTION = DEFAULT_GETTER_FUNCTION;
  exports.INHERITING_GETTER_FUNCTION = INHERITING_GETTER_FUNCTION;
  exports.defineProperty = defineProperty;

  // ..........................................................
  // DESCRIPTOR
  //

  /**
    Objects of this type can implement an interface to respond to requests to
    get and set. The default implementation handles simple properties.
  
    @class Descriptor
    @private
  */

  function Descriptor() {
    this.isDescriptor = true;
  }

  var REDEFINE_SUPPORTED = (function () {
    // https://github.com/spalger/kibana/commit/b7e35e6737df585585332857a4c397dc206e7ff9
    var a = Object.create(Object.prototype, {
      prop: {
        configurable: true,
        value: 1
      }
    });

    Object.defineProperty(a, 'prop', {
      configurable: true,
      value: 2
    });

    return a.prop === 2;
  })();
  // ..........................................................
  // DEFINING PROPERTIES API
  //

  function MANDATORY_SETTER_FUNCTION(name) {
    function SETTER_FUNCTION(value) {
      var m = _emberMetalMeta.peekMeta(this);
      if (!m.isInitialized(this)) {
        m.writeValues(name, value);
      } else {
        _emberMetalDebug.assert('You must use Ember.set() to set the `' + name + '` property (of ' + this + ') to `' + value + '`.', false);
      }
    }

    SETTER_FUNCTION.isMandatorySetter = true;
    return SETTER_FUNCTION;
  }

  function DEFAULT_GETTER_FUNCTION(name) {
    return function GETTER_FUNCTION() {
      var meta = _emberMetalMeta.peekMeta(this);
      return meta && meta.peekValues(name);
    };
  }

  function INHERITING_GETTER_FUNCTION(name) {
    function IGETTER_FUNCTION() {
      var meta = _emberMetalMeta.peekMeta(this);
      var val = meta && meta.readInheritedValue('values', name);

      if (val === _emberMetalMeta.UNDEFINED) {
        var proto = Object.getPrototypeOf(this);
        return proto && proto[name];
      } else {
        return val;
      }
    }

    IGETTER_FUNCTION.isInheritingGetter = true;
    return IGETTER_FUNCTION;
  }

  /**
    NOTE: This is a low-level method used by other parts of the API. You almost
    never want to call this method directly. Instead you should use
    `Ember.mixin()` to define new properties.
  
    Defines a property on an object. This method works much like the ES5
    `Object.defineProperty()` method except that it can also accept computed
    properties and other special descriptors.
  
    Normally this method takes only three parameters. However if you pass an
    instance of `Descriptor` as the third param then you can pass an
    optional value as the fourth parameter. This is often more efficient than
    creating new descriptor hashes for each property.
  
    ## Examples
  
    ```javascript
    // ES5 compatible mode
    Ember.defineProperty(contact, 'firstName', {
      writable: true,
      configurable: false,
      enumerable: true,
      value: 'Charles'
    });
  
    // define a simple property
    Ember.defineProperty(contact, 'lastName', undefined, 'Jolley');
  
    // define a computed property
    Ember.defineProperty(contact, 'fullName', Ember.computed('firstName', 'lastName', function() {
      return this.firstName+' '+this.lastName;
    }));
    ```
  
    @private
    @method defineProperty
    @for Ember
    @param {Object} obj the object to define this property on. This may be a prototype.
    @param {String} keyName the name of the property
    @param {Descriptor} [desc] an instance of `Descriptor` (typically a
      computed property) or an ES5 descriptor.
      You must provide this or `data` but not both.
    @param {*} [data] something other than a descriptor, that will
      become the explicit value of this property.
  */

  function defineProperty(obj, keyName, desc, data, meta) {
    var possibleDesc = undefined,
        existingDesc = undefined,
        watching = undefined,
        value = undefined;

    if (!meta) {
      meta = _emberMetalMeta.meta(obj);
    }
    var watchEntry = meta.peekWatching(keyName);
    possibleDesc = obj[keyName];
    existingDesc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    watching = watchEntry !== undefined && watchEntry > 0;

    if (existingDesc) {
      existingDesc.teardown(obj, keyName);
    }

    if (desc instanceof Descriptor) {
      value = desc;
      if (true) {
        if (watching) {
          Object.defineProperty(obj, keyName, {
            configurable: true,
            enumerable: true,
            writable: true,
            value: value
          });
        } else {
          obj[keyName] = value;
        }
      } else {
        obj[keyName] = value;
      }
      if (desc.setup) {
        desc.setup(obj, keyName);
      }
    } else {
      if (desc == null) {
        value = data;

        if (true) {
          if (watching) {
            meta.writeValues(keyName, data);

            var defaultDescriptor = {
              configurable: true,
              enumerable: true,
              set: MANDATORY_SETTER_FUNCTION(keyName),
              get: DEFAULT_GETTER_FUNCTION(keyName)
            };

            if (REDEFINE_SUPPORTED) {
              Object.defineProperty(obj, keyName, defaultDescriptor);
            } else {
              handleBrokenPhantomDefineProperty(obj, keyName, defaultDescriptor);
            }
          } else {
            obj[keyName] = data;
          }
        } else {
          obj[keyName] = data;
        }
      } else {
        value = desc;

        // fallback to ES5
        Object.defineProperty(obj, keyName, desc);
      }
    }

    // if key is being watched, override chains that
    // were initialized with the prototype
    if (watching) {
      _emberMetalProperty_events.overrideChains(obj, keyName, meta);
    }

    // The `value` passed to the `didDefineProperty` hook is
    // either the descriptor or data, whichever was passed.
    if (obj.didDefineProperty) {
      obj.didDefineProperty(obj, keyName, value);
    }

    return this;
  }

  function handleBrokenPhantomDefineProperty(obj, keyName, desc) {
    // https://github.com/ariya/phantomjs/issues/11856
    Object.defineProperty(obj, keyName, { configurable: true, writable: true, value: 'iCry' });
    Object.defineProperty(obj, keyName, desc);
  }
});
enifed('ember-metal/property_events', ['exports', 'ember-utils', 'ember-metal/meta', 'ember-metal/events', 'ember-metal/tags', 'ember-metal/observer_set', 'ember-metal/features', 'ember-metal/transaction'], function (exports, _emberUtils, _emberMetalMeta, _emberMetalEvents, _emberMetalTags, _emberMetalObserver_set, _emberMetalFeatures, _emberMetalTransaction) {
  'use strict';

  var PROPERTY_DID_CHANGE = _emberUtils.symbol('PROPERTY_DID_CHANGE');

  exports.PROPERTY_DID_CHANGE = PROPERTY_DID_CHANGE;
  var beforeObserverSet = new _emberMetalObserver_set.default();
  var observerSet = new _emberMetalObserver_set.default();
  var deferred = 0;

  // ..........................................................
  // PROPERTY CHANGES
  //

  /**
    This function is called just before an object property is about to change.
    It will notify any before observers and prepare caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyDidChange()` which you should call just
    after the property value changes.
  
    @method propertyWillChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @return {void}
    @private
  */
  function propertyWillChange(obj, keyName, _meta) {
    var meta = _meta || _emberMetalMeta.peekMeta(obj);

    if (meta && !meta.isInitialized(obj)) {
      return;
    }

    var watching = meta && meta.peekWatching(keyName) > 0;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    if (desc && desc.willChange) {
      desc.willChange(obj, keyName);
    }

    if (watching) {
      dependentKeysWillChange(obj, keyName, meta);
      chainsWillChange(obj, keyName, meta);
      notifyBeforeObservers(obj, keyName, meta);
    }
  }

  /**
    This function is called just after an object property has changed.
    It will notify any observers and clear caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyWillChange()` which you should call just
    before the property value changes.
  
    @method propertyDidChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @param {Meta} meta The objects meta.
    @return {void}
    @private
  */
  function propertyDidChange(obj, keyName, _meta) {
    var meta = _meta || _emberMetalMeta.peekMeta(obj);

    if (meta && !meta.isInitialized(obj)) {
      return;
    }

    var watching = meta && meta.peekWatching(keyName) > 0;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    // shouldn't this mean that we're watching this key?
    if (desc && desc.didChange) {
      desc.didChange(obj, keyName);
    }

    if (watching) {
      if (meta.hasDeps(keyName)) {
        dependentKeysDidChange(obj, keyName, meta);
      }

      chainsDidChange(obj, keyName, meta, false);
      notifyObservers(obj, keyName, meta);
    }

    if (obj[PROPERTY_DID_CHANGE]) {
      obj[PROPERTY_DID_CHANGE](keyName);
    }

    if (meta && meta.isSourceDestroying()) {
      return;
    }

    _emberMetalTags.markObjectAsDirty(meta, keyName);

    if (true || false) {
      _emberMetalTransaction.assertNotRendered(obj, keyName, meta);
    }
  }

  var WILL_SEEN = undefined,
      DID_SEEN = undefined;
  // called whenever a property is about to change to clear the cache of any dependent keys (and notify those properties of changes, etc...)
  function dependentKeysWillChange(obj, depKey, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    if (meta && meta.hasDeps(depKey)) {
      var seen = WILL_SEEN;
      var _top = !seen;

      if (_top) {
        seen = WILL_SEEN = {};
      }

      iterDeps(propertyWillChange, obj, depKey, seen, meta);

      if (_top) {
        WILL_SEEN = null;
      }
    }
  }

  // called whenever a property has just changed to update dependent keys
  function dependentKeysDidChange(obj, depKey, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    if (meta && meta.hasDeps(depKey)) {
      var seen = DID_SEEN;
      var _top2 = !seen;

      if (_top2) {
        seen = DID_SEEN = {};
      }

      iterDeps(propertyDidChange, obj, depKey, seen, meta);

      if (_top2) {
        DID_SEEN = null;
      }
    }
  }

  function iterDeps(method, obj, depKey, seen, meta) {
    var possibleDesc = undefined,
        desc = undefined;
    var guid = _emberUtils.guidFor(obj);
    var current = seen[guid];

    if (!current) {
      current = seen[guid] = {};
    }

    if (current[depKey]) {
      return;
    }

    current[depKey] = true;

    meta.forEachInDeps(depKey, function (key, value) {
      if (!value) {
        return;
      }

      possibleDesc = obj[key];
      desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      if (desc && desc._suspended === obj) {
        return;
      }

      method(obj, key, meta);
    });
  }

  function chainsWillChange(obj, keyName, meta) {
    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.notify(keyName, false, propertyWillChange);
    }
  }

  function chainsDidChange(obj, keyName, meta) {
    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.notify(keyName, true, propertyDidChange);
    }
  }

  function overrideChains(obj, keyName, meta) {
    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.revalidate(keyName);
    }
  }

  /**
    @method beginPropertyChanges
    @chainable
    @private
  */
  function beginPropertyChanges() {
    deferred++;
  }

  /**
    @method endPropertyChanges
    @private
  */
  function endPropertyChanges() {
    deferred--;
    if (deferred <= 0) {
      beforeObserverSet.clear();
      observerSet.flush();
    }
  }

  /**
    Make a series of property changes together in an
    exception-safe way.
  
    ```javascript
    Ember.changeProperties(function() {
      obj1.set('foo', mayBlowUpWhenSet);
      obj2.set('bar', baz);
    });
    ```
  
    @method changeProperties
    @param {Function} callback
    @param [binding]
    @private
  */
  function changeProperties(callback, binding) {
    beginPropertyChanges();
    try {
      callback.call(binding);
    } finally {
      endPropertyChanges.call(binding);
    }
  }

  function notifyBeforeObservers(obj, keyName, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    var eventName = keyName + ':before';
    var listeners = undefined,
        added = undefined;
    if (deferred) {
      listeners = beforeObserverSet.add(obj, keyName, eventName);
      added = _emberMetalEvents.accumulateListeners(obj, eventName, listeners);
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName], added);
    } else {
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  function notifyObservers(obj, keyName, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    var eventName = keyName + ':change';
    var listeners = undefined;
    if (deferred) {
      listeners = observerSet.add(obj, keyName, eventName);
      _emberMetalEvents.accumulateListeners(obj, eventName, listeners);
    } else {
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  exports.propertyWillChange = propertyWillChange;
  exports.propertyDidChange = propertyDidChange;
  exports.overrideChains = overrideChains;
  exports.beginPropertyChanges = beginPropertyChanges;
  exports.endPropertyChanges = endPropertyChanges;
  exports.changeProperties = changeProperties;
});
enifed('ember-metal/property_get', ['exports', 'ember-metal/debug', 'ember-metal/path_cache'], function (exports, _emberMetalDebug, _emberMetalPath_cache) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.get = get;
  exports._getPath = _getPath;
  exports.getWithDefault = getWithDefault;

  var ALLOWABLE_TYPES = {
    object: true,
    function: true,
    string: true
  };

  // ..........................................................
  // GET AND SET
  //
  // If we are on a platform that supports accessors we can use those.
  // Otherwise simulate accessors by looking up the property directly on the
  // object.

  /**
    Gets the value of a property on an object. If the property is computed,
    the function will be invoked. If the property is not defined but the
    object implements the `unknownProperty` method then that will be invoked.
  
    ```javascript
    Ember.get(obj, "name");
    ```
  
    If you plan to run on IE8 and older browsers then you should use this
    method anytime you want to retrieve a property on an object that you don't
    know for sure is private. (Properties beginning with an underscore '_'
    are considered private.)
  
    On all newer browsers, you only need to use this method to retrieve
    properties if the property might not be defined on the object and you want
    to respect the `unknownProperty` handler. Otherwise you can ignore this
    method.
  
    Note that if the object itself is `undefined`, this method will throw
    an error.
  
    @method get
    @for Ember
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The property key to retrieve
    @return {Object} the property value or `null`.
    @public
  */

  function get(obj, keyName) {
    _emberMetalDebug.assert('Get must be called with two arguments; an object and a property key', arguments.length === 2);
    _emberMetalDebug.assert('Cannot call get with \'' + keyName + '\' on an undefined object.', obj !== undefined && obj !== null);
    _emberMetalDebug.assert('The key provided to get must be a string, you passed ' + keyName, typeof keyName === 'string');
    _emberMetalDebug.assert('\'this\' in paths is not supported', !_emberMetalPath_cache.hasThis(keyName));

    var value = obj[keyName];
    var desc = value !== null && typeof value === 'object' && value.isDescriptor ? value : undefined;
    var ret = undefined;

    if (desc === undefined && _emberMetalPath_cache.isPath(keyName)) {
      return _getPath(obj, keyName);
    }

    if (desc) {
      return desc.get(obj, keyName);
    } else {
      ret = value;

      if (ret === undefined && 'object' === typeof obj && !(keyName in obj) && 'function' === typeof obj.unknownProperty) {
        return obj.unknownProperty(keyName);
      }

      return ret;
    }
  }

  function _getPath(root, path) {
    var obj = root;
    var parts = path.split('.');

    for (var i = 0; i < parts.length; i++) {
      if (!isGettable(obj)) {
        return undefined;
      }

      obj = get(obj, parts[i]);

      if (obj && obj.isDestroyed) {
        return undefined;
      }
    }

    return obj;
  }

  function isGettable(obj) {
    if (obj == null) {
      return false;
    }

    return ALLOWABLE_TYPES[typeof obj];
  }

  /**
    Retrieves the value of a property from an Object, or a default value in the
    case that the property returns `undefined`.
  
    ```javascript
    Ember.getWithDefault(person, 'lastName', 'Doe');
    ```
  
    @method getWithDefault
    @for Ember
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The name of the property to retrieve
    @param {Object} defaultValue The value to return if the property value is undefined
    @return {Object} The property value or the defaultValue.
    @public
  */

  function getWithDefault(root, key, defaultValue) {
    var value = get(root, key);

    if (value === undefined) {
      return defaultValue;
    }
    return value;
  }

  exports.default = get;
});
enifed('ember-metal/property_set', ['exports', 'ember-utils', 'ember-metal/debug', 'ember-metal/features', 'ember-metal/property_get', 'ember-metal/property_events', 'ember-metal/error', 'ember-metal/path_cache', 'ember-metal/meta'], function (exports, _emberUtils, _emberMetalDebug, _emberMetalFeatures, _emberMetalProperty_get, _emberMetalProperty_events, _emberMetalError, _emberMetalPath_cache, _emberMetalMeta) {
  'use strict';

  exports.set = set;
  exports.trySet = trySet;

  /**
    Sets the value of a property on an object, respecting computed properties
    and notifying observers and other listeners of the change. If the
    property is not defined but the object implements the `setUnknownProperty`
    method then that will be invoked as well.
  
    ```javascript
    Ember.set(obj, "name", value);
    ```
  
    @method set
    @for Ember
    @param {Object} obj The object to modify.
    @param {String} keyName The property key to set
    @param {Object} value The value to set
    @return {Object} the passed value.
    @public
  */

  function set(obj, keyName, value, tolerant) {
    _emberMetalDebug.assert('Set must be called with three or four arguments; an object, a property key, a value and tolerant true/false', arguments.length === 3 || arguments.length === 4);
    _emberMetalDebug.assert('Cannot call set with \'' + keyName + '\' on an undefined object.', obj && typeof obj === 'object' || typeof obj === 'function');
    _emberMetalDebug.assert('The key provided to set must be a string, you passed ' + keyName, typeof keyName === 'string');
    _emberMetalDebug.assert('\'this\' in paths is not supported', !_emberMetalPath_cache.hasThis(keyName));
    _emberMetalDebug.assert('calling set on destroyed object: ' + _emberUtils.toString(obj) + '.' + keyName + ' = ' + _emberUtils.toString(value), !obj.isDestroyed);

    if (_emberMetalPath_cache.isPath(keyName)) {
      return setPath(obj, keyName, value, tolerant);
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    var possibleDesc = obj[keyName];

    var desc = undefined,
        currentValue = undefined;
    if (possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor) {
      desc = possibleDesc;
    } else {
      currentValue = possibleDesc;
    }

    if (desc) {
      /* computed property */
      desc.set(obj, keyName, value);
    } else if (obj.setUnknownProperty && currentValue === undefined && !(keyName in obj)) {
      /* unknown property */
      _emberMetalDebug.assert('setUnknownProperty must be a function', typeof obj.setUnknownProperty === 'function');
      obj.setUnknownProperty(keyName, value);
    } else if (currentValue === value) {
      /* no change */
      return value;
    } else {
      _emberMetalProperty_events.propertyWillChange(obj, keyName);

      if (true) {
        setWithMandatorySetter(meta, obj, keyName, value);
      } else {
        obj[keyName] = value;
      }

      _emberMetalProperty_events.propertyDidChange(obj, keyName);
    }

    return value;
  }

  if (true) {
    var setWithMandatorySetter = function (meta, obj, keyName, value) {
      if (meta && meta.peekWatching(keyName) > 0) {
        makeEnumerable(obj, keyName);
        meta.writeValue(obj, keyName, value);
      } else {
        obj[keyName] = value;
      }
    };

    var makeEnumerable = function (obj, key) {
      var desc = Object.getOwnPropertyDescriptor(obj, key);

      if (desc && desc.set && desc.set.isMandatorySetter) {
        desc.enumerable = true;
        Object.defineProperty(obj, key, desc);
      }
    };
  }

  function setPath(root, path, value, tolerant) {
    // get the last part of the path
    var keyName = path.slice(path.lastIndexOf('.') + 1);

    // get the first part of the part
    path = path === keyName ? keyName : path.slice(0, path.length - (keyName.length + 1));

    // unless the path is this, look up the first part to
    // get the root
    if (path !== 'this') {
      root = _emberMetalProperty_get._getPath(root, path);
    }

    if (!keyName || keyName.length === 0) {
      throw new _emberMetalError.default('Property set failed: You passed an empty path');
    }

    if (!root) {
      if (tolerant) {
        return;
      } else {
        throw new _emberMetalError.default('Property set failed: object in path "' + path + '" could not be found or was destroyed.');
      }
    }

    return set(root, keyName, value);
  }

  /**
    Error-tolerant form of `Ember.set`. Will not blow up if any part of the
    chain is `undefined`, `null`, or destroyed.
  
    This is primarily used when syncing bindings, which may try to update after
    an object has been destroyed.
  
    @method trySet
    @for Ember
    @param {Object} root The object to modify.
    @param {String} path The property path to set
    @param {Object} value The value to set
    @public
  */

  function trySet(root, path, value) {
    return set(root, path, value, true);
  }
});
enifed("ember-metal/replace", ["exports"], function (exports) {
  "use strict";

  exports.default = replace;
  var splice = Array.prototype.splice;

  function replace(array, idx, amt, objects) {
    var args = [].concat(objects);
    var ret = [];
    // https://code.google.com/p/chromium/issues/detail?id=56588
    var size = 60000;
    var start = idx;
    var ends = amt;
    var count = undefined,
        chunk = undefined;

    while (args.length) {
      count = ends > size ? size : ends;
      if (count <= 0) {
        count = 0;
      }

      chunk = args.splice(0, size);
      chunk = [start, count].concat(chunk);

      start += size;
      ends -= count;

      ret = ret.concat(splice.apply(array, chunk));
    }
    return ret;
  }
});
enifed('ember-metal/run_loop', ['exports', 'ember-utils', 'ember-metal/debug', 'ember-metal/testing', 'ember-metal/error_handler', 'ember-metal/property_events', 'backburner'], function (exports, _emberUtils, _emberMetalDebug, _emberMetalTesting, _emberMetalError_handler, _emberMetalProperty_events, _backburner) {
  'use strict';

  exports.default = run;

  function onBegin(current) {
    run.currentRunLoop = current;
  }

  function onEnd(current, next) {
    run.currentRunLoop = next;
  }

  var onErrorTarget = {
    get onerror() {
      return _emberMetalError_handler.getOnerror();
    },
    set onerror(handler) {
      return _emberMetalError_handler.setOnerror(handler);
    }
  };

  var backburner = new _backburner.default(['sync', 'actions', 'destroy'], {
    GUID_KEY: _emberUtils.GUID_KEY,
    sync: {
      before: _emberMetalProperty_events.beginPropertyChanges,
      after: _emberMetalProperty_events.endPropertyChanges
    },
    defaultQueue: 'actions',
    onBegin: onBegin,
    onEnd: onEnd,
    onErrorTarget: onErrorTarget,
    onErrorMethod: 'onerror'
  });

  // ..........................................................
  // run - this is ideally the only public API the dev sees
  //

  /**
    Runs the passed target and method inside of a RunLoop, ensuring any
    deferred actions including bindings and views updates are flushed at the
    end.
  
    Normally you should not need to invoke this method yourself. However if
    you are implementing raw event handlers when interfacing with other
    libraries or plugins, you should probably wrap all of your code inside this
    call.
  
    ```javascript
    run(function() {
      // code to be executed within a RunLoop
    });
    ```
  
    @class run
    @namespace Ember
    @static
    @constructor
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} return value from invoking the passed function.
    @public
  */

  function run() {
    return backburner.run.apply(backburner, arguments);
  }

  /**
    If no run-loop is present, it creates a new one. If a run loop is
    present it will queue itself to run on the existing run-loops action
    queue.
  
    Please note: This is not for normal usage, and should be used sparingly.
  
    If invoked when not within a run loop:
  
    ```javascript
    run.join(function() {
      // creates a new run-loop
    });
    ```
  
    Alternatively, if called within an existing run loop:
  
    ```javascript
    run(function() {
      // creates a new run-loop
      run.join(function() {
        // joins with the existing run-loop, and queues for invocation on
        // the existing run-loops action queue.
      });
    });
    ```
  
    @method join
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} Return value from invoking the passed function. Please note,
    when called within an existing loop, no return value is possible.
    @public
  */
  run.join = function () {
    return backburner.join.apply(backburner, arguments);
  };

  /**
    Allows you to specify which context to call the specified function in while
    adding the execution of that function to the Ember run loop. This ability
    makes this method a great way to asynchronously integrate third-party libraries
    into your Ember application.
  
    `run.bind` takes two main arguments, the desired context and the function to
    invoke in that context. Any additional arguments will be supplied as arguments
    to the function that is passed in.
  
    Let's use the creation of a TinyMCE component as an example. Currently,
    TinyMCE provides a setup configuration option we can use to do some processing
    after the TinyMCE instance is initialized but before it is actually rendered.
    We can use that setup option to do some additional setup for our component.
    The component itself could look something like the following:
  
    ```javascript
    App.RichTextEditorComponent = Ember.Component.extend({
      initializeTinyMCE: Ember.on('didInsertElement', function() {
        tinymce.init({
          selector: '#' + this.$().prop('id'),
          setup: Ember.run.bind(this, this.setupEditor)
        });
      }),
  
      setupEditor: function(editor) {
        this.set('editor', editor);
  
        editor.on('change', function() {
          console.log('content changed!');
        });
      }
    });
    ```
  
    In this example, we use Ember.run.bind to bind the setupEditor method to the
    context of the App.RichTextEditorComponent and to have the invocation of that
    method be safely handled and executed by the Ember run loop.
  
    @method bind
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Function} returns a new function that will always have a particular context
    @since 1.4.0
    @public
  */
  run.bind = function () {
    for (var _len = arguments.length, curried = Array(_len), _key = 0; _key < _len; _key++) {
      curried[_key] = arguments[_key];
    }

    return function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return run.join.apply(run, curried.concat(args));
    };
  };

  run.backburner = backburner;
  run.currentRunLoop = null;
  run.queues = backburner.queueNames;

  /**
    Begins a new RunLoop. Any deferred actions invoked after the begin will
    be buffered until you invoke a matching call to `run.end()`. This is
    a lower-level way to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method begin
    @return {void}
    @public
  */
  run.begin = function () {
    backburner.begin();
  };

  /**
    Ends a RunLoop. This must be called sometime after you call
    `run.begin()` to flush any deferred actions. This is a lower-level way
    to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method end
    @return {void}
    @public
  */
  run.end = function () {
    backburner.end();
  };

  /**
    Array of named queues. This array determines the order in which queues
    are flushed at the end of the RunLoop. You can define your own queues by
    simply adding the queue name to this array. Normally you should not need
    to inspect or modify this property.
  
    @property queues
    @type Array
    @default ['sync', 'actions', 'destroy']
    @private
  */

  /**
    Adds the passed target/method and any optional arguments to the named
    queue to be executed at the end of the RunLoop. If you have not already
    started a RunLoop when calling this method one will be started for you
    automatically.
  
    At the end of a RunLoop, any methods scheduled in this way will be invoked.
    Methods will be invoked in an order matching the named queues defined in
    the `run.queues` property.
  
    ```javascript
    run.schedule('sync', this, function() {
      // this will be executed in the first RunLoop queue, when bindings are synced
      console.log('scheduled on sync queue');
    });
  
    run.schedule('actions', this, function() {
      // this will be executed in the 'actions' queue, after bindings have synced.
      console.log('scheduled on actions queue');
    });
  
    // Note the functions will be run in order based on the run queues order.
    // Output would be:
    //   scheduled on sync queue
    //   scheduled on actions queue
    ```
  
    @method schedule
    @param {String} queue The name of the queue to schedule against.
      Default queues are 'sync' and 'actions'
    @param {Object} [target] target object to use as the context when invoking a method.
    @param {String|Function} method The method to invoke. If you pass a string it
      will be resolved on the target object at the time the scheduled item is
      invoked allowing you to change the target function.
    @param {Object} [arguments*] Optional arguments to be passed to the queued method.
    @return {*} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.schedule = function () /* queue, target, method */{
    _emberMetalDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !_emberMetalTesting.isTesting());

    return backburner.schedule.apply(backburner, arguments);
  };

  // Used by global test teardown
  run.hasScheduledTimers = function () {
    return backburner.hasTimers();
  };

  // Used by global test teardown
  run.cancelTimers = function () {
    backburner.cancelTimers();
  };

  /**
    Immediately flushes any events scheduled in the 'sync' queue. Bindings
    use this queue so this method is a useful way to immediately force all
    bindings in the application to sync.
  
    You should call this method anytime you need any changed state to propagate
    throughout the app immediately without repainting the UI (which happens
    in the later 'render' queue added by the `ember-views` package).
  
    ```javascript
    run.sync();
    ```
  
    @method sync
    @return {void}
    @private
  */
  run.sync = function () {
    if (backburner.currentInstance) {
      backburner.currentInstance.queues.sync.flush();
    }
  };

  /**
    Invokes the passed target/method and optional arguments after a specified
    period of time. The last parameter of this method must always be a number
    of milliseconds.
  
    You should use this method whenever you need to run some action after a
    period of time instead of using `setTimeout()`. This method will ensure that
    items that expire during the same script execution cycle all execute
    together, which is often more efficient than using a real setTimeout.
  
    ```javascript
    run.later(myContext, function() {
      // code here will execute within a RunLoop in about 500ms with this == myContext
    }, 500);
    ```
  
    @method later
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @return {*} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.later = function () /*target, method*/{
    return backburner.later.apply(backburner, arguments);
  };

  /**
    Schedule a function to run one time during the current RunLoop. This is equivalent
    to calling `scheduleOnce` with the "actions" queue.
  
    @method once
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.once = function () {
    _emberMetalDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !_emberMetalTesting.isTesting());

    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    args.unshift('actions');
    return backburner.scheduleOnce.apply(backburner, args);
  };

  /**
    Schedules a function to run one time in a given queue of the current RunLoop.
    Calling this method with the same queue/target/method combination will have
    no effect (past the initial call).
  
    Note that although you can pass optional arguments these will not be
    considered when looking for duplicates. New arguments will replace previous
    calls.
  
    ```javascript
    function sayHi() {
      console.log('hi');
    }
  
    run(function() {
      run.scheduleOnce('afterRender', myContext, sayHi);
      run.scheduleOnce('afterRender', myContext, sayHi);
      // sayHi will only be executed once, in the afterRender queue of the RunLoop
    });
    ```
  
    Also note that passing an anonymous function to `run.scheduleOnce` will
    not prevent additional calls with an identical anonymous function from
    scheduling the items multiple times, e.g.:
  
    ```javascript
    function scheduleIt() {
      run.scheduleOnce('actions', myContext, function() {
        console.log('Closure');
      });
    }
  
    scheduleIt();
    scheduleIt();
  
    // "Closure" will print twice, even though we're using `run.scheduleOnce`,
    // because the function we pass to it is anonymous and won't match the
    // previously scheduled operation.
    ```
  
    Available queues, and their order, can be found at `run.queues`
  
    @method scheduleOnce
    @param {String} [queue] The name of the queue to schedule against. Default queues are 'sync' and 'actions'.
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.scheduleOnce = function () /*queue, target, method*/{
    _emberMetalDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !_emberMetalTesting.isTesting());
    return backburner.scheduleOnce.apply(backburner, arguments);
  };

  /**
    Schedules an item to run from within a separate run loop, after
    control has been returned to the system. This is equivalent to calling
    `run.later` with a wait time of 1ms.
  
    ```javascript
    run.next(myContext, function() {
      // code to be executed in the next run loop,
      // which will be scheduled after the current one
    });
    ```
  
    Multiple operations scheduled with `run.next` will coalesce
    into the same later run loop, along with any other operations
    scheduled by `run.later` that expire right around the same
    time that `run.next` operations will fire.
  
    Note that there are often alternatives to using `run.next`.
    For instance, if you'd like to schedule an operation to happen
    after all DOM element operations have completed within the current
    run loop, you can make use of the `afterRender` run loop queue (added
    by the `ember-views` package, along with the preceding `render` queue
    where all the DOM element operations happen).
  
    Example:
  
    ```javascript
    export default Ember.Component.extend({
      didInsertElement() {
        this._super(...arguments);
        run.scheduleOnce('afterRender', this, 'processChildElements');
      },
  
      processChildElements() {
        // ... do something with component's child component
        // elements after they've finished rendering, which
        // can't be done within this component's
        // `didInsertElement` hook because that gets run
        // before the child elements have been added to the DOM.
      }
    });
    ```
  
    One benefit of the above approach compared to using `run.next` is
    that you will be able to perform DOM/CSS operations before unprocessed
    elements are rendered to the screen, which may prevent flickering or
    other artifacts caused by delaying processing until after rendering.
  
    The other major benefit to the above approach is that `run.next`
    introduces an element of non-determinism, which can make things much
    harder to test, due to its reliance on `setTimeout`; it's much harder
    to guarantee the order of scheduled operations when they are scheduled
    outside of the current run loop, i.e. with `run.next`.
  
    @method next
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.next = function () {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    args.push(1);
    return backburner.later.apply(backburner, args);
  };

  /**
    Cancels a scheduled item. Must be a value returned by `run.later()`,
    `run.once()`, `run.scheduleOnce()`, `run.next()`, `run.debounce()`, or
    `run.throttle()`.
  
    ```javascript
    let runNext = run.next(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runNext);
  
    let runLater = run.later(myContext, function() {
      // will not be executed
    }, 500);
  
    run.cancel(runLater);
  
    let runScheduleOnce = run.scheduleOnce('afterRender', myContext, function() {
      // will not be executed
    });
  
    run.cancel(runScheduleOnce);
  
    let runOnce = run.once(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runOnce);
  
    let throttle = run.throttle(myContext, function() {
      // will not be executed
    }, 1, false);
  
    run.cancel(throttle);
  
    let debounce = run.debounce(myContext, function() {
      // will not be executed
    }, 1);
  
    run.cancel(debounce);
  
    let debounceImmediate = run.debounce(myContext, function() {
      // will be executed since we passed in true (immediate)
    }, 100, true);
  
    // the 100ms delay until this method can be called again will be cancelled
    run.cancel(debounceImmediate);
    ```
  
    @method cancel
    @param {Object} timer Timer object to cancel
    @return {Boolean} true if cancelled or false/undefined if it wasn't found
    @public
  */
  run.cancel = function (timer) {
    return backburner.cancel(timer);
  };

  /**
    Delay calling the target method until the debounce period has elapsed
    with no additional debounce calls. If `debounce` is called again before
    the specified time has elapsed, the timer is reset and the entire period
    must pass again before the target method is called.
  
    This method should be used when an event may be called multiple times
    but the action should only be called once when the event is done firing.
    A common example is for scroll events where you only want updates to
    happen once scrolling has ceased.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150);
  
    // less than 150ms passes
    run.debounce(myContext, whoRan, 150);
  
    // 150ms passes
    // whoRan is invoked with context myContext
    // console logs 'debounce ran.' one time.
    ```
  
    Immediate allows you to run the function immediately, but debounce
    other calls for this function until the wait time has elapsed. If
    `debounce` is called again before the specified time has elapsed,
    the timer is reset and the entire period must pass again before
    the method can be called again.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 100ms passes
    run.debounce(myContext, whoRan, 150, true);
  
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
  
    ```
  
    @method debounce
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to false.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.debounce = function () {
    return backburner.debounce.apply(backburner, arguments);
  };

  /**
    Ensure that the target method is never called more frequently than
    the specified spacing period. The target method is called immediately.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'throttle' };
  
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 150ms passes
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
    ```
  
    @method throttle
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} spacing Number of milliseconds to space out requests.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to true.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.throttle = function () {
    return backburner.throttle.apply(backburner, arguments);
  };

  /**
    Add a new named queue after the specified queue.
  
    The queue to add will only be added once.
  
    @method _addQueue
    @param {String} name the name of the queue to add.
    @param {String} after the name of the queue to add after.
    @private
  */
  run._addQueue = function (name, after) {
    if (run.queues.indexOf(name) === -1) {
      run.queues.splice(run.queues.indexOf(after) + 1, 0, name);
    }
  };
});
enifed('ember-metal/set_properties', ['exports', 'ember-metal/property_events', 'ember-metal/property_set'], function (exports, _emberMetalProperty_events, _emberMetalProperty_set) {
  'use strict';

  exports.default = setProperties;

  /**
    Set a list of properties on an object. These properties are set inside
    a single `beginPropertyChanges` and `endPropertyChanges` batch, so
    observers will be buffered.
  
    ```javascript
    let anObject = Ember.Object.create();
  
    anObject.setProperties({
      firstName: 'Stanley',
      lastName: 'Stuart',
      age: 21
    });
    ```
  
    @method setProperties
    @param obj
    @param {Object} properties
    @return properties
    @public
  */

  function setProperties(obj, properties) {
    if (!properties || typeof properties !== 'object') {
      return properties;
    }
    _emberMetalProperty_events.changeProperties(function () {
      var props = Object.keys(properties);
      var propertyName = undefined;

      for (var i = 0; i < props.length; i++) {
        propertyName = props[i];

        _emberMetalProperty_set.set(obj, propertyName, properties[propertyName]);
      }
    });
    return properties;
  }
});
enifed('ember-metal/tags', ['exports', 'glimmer-reference', 'ember-metal/meta', 'require', 'ember-metal/is_proxy'], function (exports, _glimmerReference, _emberMetalMeta, _require, _emberMetalIs_proxy) {
  'use strict';

  exports.setHasViews = setHasViews;
  exports.tagForProperty = tagForProperty;
  exports.tagFor = tagFor;
  exports.markObjectAsDirty = markObjectAsDirty;

  var hasViews = function () {
    return false;
  };

  function setHasViews(fn) {
    hasViews = fn;
  }

  function makeTag() {
    return new _glimmerReference.DirtyableTag();
  }

  function tagForProperty(object, propertyKey, _meta) {
    if (_emberMetalIs_proxy.isProxy(object)) {
      return tagFor(object, _meta);
    }

    if (typeof object === 'object' && object) {
      var meta = _meta || _emberMetalMeta.meta(object);
      var tags = meta.writableTags();
      var tag = tags[propertyKey];
      if (tag) {
        return tag;
      }

      return tags[propertyKey] = makeTag();
    } else {
      return _glimmerReference.CONSTANT_TAG;
    }
  }

  function tagFor(object, _meta) {
    if (typeof object === 'object' && object) {
      var meta = _meta || _emberMetalMeta.meta(object);
      return meta.writableTag(makeTag);
    } else {
      return _glimmerReference.CONSTANT_TAG;
    }
  }

  function markObjectAsDirty(meta, propertyKey) {
    var objectTag = meta && meta.readableTag();

    if (objectTag) {
      objectTag.dirty();
    }

    var tags = meta && meta.readableTags();
    var propertyTag = tags && tags[propertyKey];

    if (propertyTag) {
      propertyTag.dirty();
    }

    if (objectTag || propertyTag) {
      ensureRunloop();
    }
  }

  var run = undefined;

  function K() {}

  function ensureRunloop() {
    if (!run) {
      run = _require.default('ember-metal/run_loop').default;
    }

    if (hasViews() && !run.backburner.currentInstance) {
      run.schedule('actions', K);
    }
  }
});
enifed("ember-metal/testing", ["exports"], function (exports) {
  "use strict";

  exports.isTesting = isTesting;
  exports.setTesting = setTesting;
  var testing = false;

  function isTesting() {
    return testing;
  }

  function setTesting(value) {
    testing = !!value;
  }
});
enifed('ember-metal/transaction', ['exports', 'ember-metal/meta', 'ember-metal/debug', 'ember-metal/features'], function (exports, _emberMetalMeta, _emberMetalDebug, _emberMetalFeatures) {
  'use strict';

  var runInTransaction = undefined,
      didRender = undefined,
      assertNotRendered = undefined;

  var raise = _emberMetalDebug.assert;
  if (false) {
    raise = function (message, test) {
      _emberMetalDebug.deprecate(message, test, { id: 'ember-views.render-double-modify', until: '3.0.0' });
    };
  }

  var implication = undefined;
  if (false) {
    implication = 'will be removed in Ember 3.0.';
  } else if (true) {
    implication = 'is no longer supported. See https://github.com/emberjs/ember.js/issues/13948 for more details.';
  }

  if (true || false) {
    (function () {
      var counter = 0;
      var inTransaction = false;
      var shouldReflush = undefined;

      exports.default = runInTransaction = function (context, methodName) {
        shouldReflush = false;
        inTransaction = true;
        context[methodName]();
        inTransaction = false;
        counter++;
        return shouldReflush;
      };

      exports.didRender = didRender = function (object, key, reference) {
        if (!inTransaction) {
          return;
        }
        var meta = _emberMetalMeta.meta(object);
        var lastRendered = meta.writableLastRendered();
        lastRendered[key] = counter;

        _emberMetalDebug.runInDebug(function () {
          var lastRenderedFrom = meta.writableLastRenderedFrom();
          lastRenderedFrom[key] = reference;
        });
      };

      exports.assertNotRendered = assertNotRendered = function (object, key, _meta) {
        var meta = _meta || _emberMetalMeta.meta(object);
        var lastRendered = meta.readableLastRendered();

        if (lastRendered && lastRendered[key] === counter) {
          raise((function () {
            var ref = meta.readableLastRenderedFrom();
            var parts = [];
            var lastRef = ref[key];

            var label = undefined;

            if (lastRef) {
              while (lastRef && lastRef._propertyKey) {
                parts.unshift(lastRef._propertyKey);
                lastRef = lastRef._parentReference;
              }

              label = parts.join();
            } else {
              label = 'the same value';
            }

            return 'You modified ' + parts.join('.') + ' twice on ' + object + ' in a single render. This was unreliable and slow in Ember 1.x and ' + implication;
          })(), false);

          shouldReflush = true;
        }
      };
    })();
  } else {
    exports.default = runInTransaction = function () {
      throw new Error('Cannot call runInTransaction without Glimmer');
    };

    exports.didRender = didRender = function () {
      throw new Error('Cannot call didRender without Glimmer');
    };

    exports.assertNotRendered = assertNotRendered = function () {
      throw new Error('Cannot call assertNotRendered without Glimmer');
    };
  }

  exports.default = runInTransaction;
  exports.didRender = didRender;
  exports.assertNotRendered = assertNotRendered;
});
enifed('ember-metal/watch_key', ['exports', 'ember-utils', 'ember-metal/features', 'ember-metal/meta', 'ember-metal/properties'], function (exports, _emberUtils, _emberMetalFeatures, _emberMetalMeta, _emberMetalProperties) {
  'use strict';

  exports.watchKey = watchKey;
  exports.unwatchKey = unwatchKey;

  var handleMandatorySetter = undefined;

  function watchKey(obj, keyName, meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta || _emberMetalMeta.meta(obj);

    // activate watching first time
    if (!m.peekWatching(keyName)) {
      m.writeWatching(keyName, 1);

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;
      if (desc && desc.willWatch) {
        desc.willWatch(obj, keyName);
      }

      if ('function' === typeof obj.willWatchProperty) {
        obj.willWatchProperty(keyName);
      }

      if (true) {
        // NOTE: this is dropped for prod + minified builds
        handleMandatorySetter(m, obj, keyName);
      }
    } else {
      m.writeWatching(keyName, (m.peekWatching(keyName) || 0) + 1);
    }
  }

  if (true) {
    (function () {
      var hasOwnProperty = function (obj, key) {
        return Object.prototype.hasOwnProperty.call(obj, key);
      };

      var propertyIsEnumerable = function (obj, key) {
        return Object.prototype.propertyIsEnumerable.call(obj, key);
      };

      // Future traveler, although this code looks scary. It merely exists in
      // development to aid in development asertions. Production builds of
      // ember strip this entire block out
      handleMandatorySetter = function handleMandatorySetter(m, obj, keyName) {
        var descriptor = _emberUtils.lookupDescriptor(obj, keyName);
        var configurable = descriptor ? descriptor.configurable : true;
        var isWritable = descriptor ? descriptor.writable : true;
        var hasValue = descriptor ? 'value' in descriptor : true;
        var possibleDesc = descriptor && descriptor.value;
        var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

        if (isDescriptor) {
          return;
        }

        // this x in Y deopts, so keeping it in this function is better;
        if (configurable && isWritable && hasValue && keyName in obj) {
          var desc = {
            configurable: true,
            set: _emberMetalProperties.MANDATORY_SETTER_FUNCTION(keyName),
            enumerable: propertyIsEnumerable(obj, keyName),
            get: undefined
          };

          if (hasOwnProperty(obj, keyName)) {
            m.writeValues(keyName, obj[keyName]);
            desc.get = _emberMetalProperties.DEFAULT_GETTER_FUNCTION(keyName);
          } else {
            desc.get = _emberMetalProperties.INHERITING_GETTER_FUNCTION(keyName);
          }

          Object.defineProperty(obj, keyName, desc);
        }
      };
    })();
  }

  function unwatchKey(obj, keyName, _meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var meta = _meta || _emberMetalMeta.meta(obj);

    // do nothing of this object has already been destroyed
    if (meta.isSourceDestroyed()) {
      return;
    }

    var count = meta.peekWatching(keyName);
    if (count === 1) {
      meta.writeWatching(keyName, 0);

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      if (desc && desc.didUnwatch) {
        desc.didUnwatch(obj, keyName);
      }

      if ('function' === typeof obj.didUnwatchProperty) {
        obj.didUnwatchProperty(keyName);
      }

      if (true) {
        // It is true, the following code looks quite WAT. But have no fear, It
        // exists purely to improve development ergonomics and is removed from
        // ember.min.js and ember.prod.js builds.
        //
        // Some further context: Once a property is watched by ember, bypassing `set`
        // for mutation, will bypass observation. This code exists to assert when
        // that occurs, and attempt to provide more helpful feedback. The alternative
        // is tricky to debug partially observable properties.
        if (!desc && keyName in obj) {
          var maybeMandatoryDescriptor = _emberUtils.lookupDescriptor(obj, keyName);

          if (maybeMandatoryDescriptor.set && maybeMandatoryDescriptor.set.isMandatorySetter) {
            if (maybeMandatoryDescriptor.get && maybeMandatoryDescriptor.get.isInheritingGetter) {
              var possibleValue = meta.readInheritedValue('values', keyName);
              if (possibleValue === _emberMetalMeta.UNDEFINED) {
                delete obj[keyName];
                return;
              }
            }

            Object.defineProperty(obj, keyName, {
              configurable: true,
              enumerable: Object.prototype.propertyIsEnumerable.call(obj, keyName),
              writable: true,
              value: meta.peekValues(keyName)
            });
            meta.deleteFromValues(keyName);
          }
        }
      }
    } else if (count > 1) {
      meta.writeWatching(keyName, count - 1);
    }
  }
});
enifed('ember-metal/watch_path', ['exports', 'ember-metal/meta', 'ember-metal/chains'], function (exports, _emberMetalMeta, _emberMetalChains) {
  'use strict';

  exports.makeChainNode = makeChainNode;
  exports.watchPath = watchPath;
  exports.unwatchPath = unwatchPath;

  // get the chains for the current object. If the current object has
  // chains inherited from the proto they will be cloned and reconfigured for
  // the current object.
  function chainsFor(obj, meta) {
    return (meta || _emberMetalMeta.meta(obj)).writableChains(makeChainNode);
  }

  function makeChainNode(obj) {
    return new _emberMetalChains.ChainNode(null, null, obj);
  }

  function watchPath(obj, keyPath, meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta || _emberMetalMeta.meta(obj);
    var counter = m.peekWatching(keyPath) || 0;
    if (!counter) {
      // activate watching first time
      m.writeWatching(keyPath, 1);
      chainsFor(obj, m).add(keyPath);
    } else {
      m.writeWatching(keyPath, counter + 1);
    }
  }

  function unwatchPath(obj, keyPath, meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta || _emberMetalMeta.meta(obj);
    var counter = m.peekWatching(keyPath) || 0;

    if (counter === 1) {
      m.writeWatching(keyPath, 0);
      chainsFor(obj, m).remove(keyPath);
    } else if (counter > 1) {
      m.writeWatching(keyPath, counter - 1);
    }
  }
});
enifed('ember-metal/watching', ['exports', 'ember-metal/watch_key', 'ember-metal/watch_path', 'ember-metal/path_cache', 'ember-metal/meta'], function (exports, _emberMetalWatch_key, _emberMetalWatch_path, _emberMetalPath_cache, _emberMetalMeta) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.isWatching = isWatching;
  exports.watcherCount = watcherCount;
  exports.unwatch = unwatch;
  exports.destroy = destroy;

  /**
    Starts watching a property on an object. Whenever the property changes,
    invokes `Ember.propertyWillChange` and `Ember.propertyDidChange`. This is the
    primitive used by observers and dependent keys; usually you will never call
    this method directly but instead use higher level methods like
    `Ember.addObserver()`
  
    @private
    @method watch
    @for Ember
    @param obj
    @param {String} _keyPath
  */
  function watch(obj, _keyPath, m) {
    if (!_emberMetalPath_cache.isPath(_keyPath)) {
      _emberMetalWatch_key.watchKey(obj, _keyPath, m);
    } else {
      _emberMetalWatch_path.watchPath(obj, _keyPath, m);
    }
  }

  exports.watch = watch;

  function isWatching(obj, key) {
    if (typeof obj !== 'object' || obj === null) {
      return false;
    }
    var meta = _emberMetalMeta.peekMeta(obj);
    return (meta && meta.peekWatching(key)) > 0;
  }

  function watcherCount(obj, key) {
    var meta = _emberMetalMeta.peekMeta(obj);
    return meta && meta.peekWatching(key) || 0;
  }

  function unwatch(obj, _keyPath, m) {
    if (!_emberMetalPath_cache.isPath(_keyPath)) {
      _emberMetalWatch_key.unwatchKey(obj, _keyPath, m);
    } else {
      _emberMetalWatch_path.unwatchPath(obj, _keyPath, m);
    }
  }

  /**
    Tears down the meta on an object so that it can be garbage collected.
    Multiple calls will have no effect.
  
    @method destroy
    @for Ember
    @param {Object} obj  the object to destroy
    @return {void}
    @private
  */

  function destroy(obj) {
    _emberMetalMeta.deleteMeta(obj);
  }
});
enifed('ember-metal/weak_map', ['exports', 'ember-utils', 'ember-metal/meta'], function (exports, _emberUtils, _emberMetalMeta) {
  'use strict';

  exports.default = WeakMap;

  var id = 0;

  // Returns whether Type(value) is Object according to the terminology in the spec
  function isObject(value) {
    return typeof value === 'object' && value !== null || typeof value === 'function';
  }

  /*
   * @class Ember.WeakMap
   * @public
   * @category ember-metal-weakmap
   *
   * A partial polyfill for [WeakMap](http://www.ecma-international.org/ecma-262/6.0/#sec-weakmap-objects).
   *
   * There is a small but important caveat. This implementation assumes that the
   * weak map will live longer (in the sense of garbage collection) than all of its
   * keys, otherwise it is possible to leak the values stored in the weak map. In
   * practice, most use cases satisfy this limitation which is why it is included
   * in ember-metal.
   */

  function WeakMap(iterable) {
    if (!(this instanceof WeakMap)) {
      throw new TypeError('Constructor WeakMap requires \'new\'');
    }

    this._id = _emberUtils.GUID_KEY + id++;

    if (iterable === null || iterable === undefined) {
      return;
    } else if (Array.isArray(iterable)) {
      for (var i = 0; i < iterable.length; i++) {
        var _iterable$i = iterable[i];
        var key = _iterable$i[0];
        var value = _iterable$i[1];

        this.set(key, value);
      }
    } else {
      throw new TypeError('The weak map constructor polyfill only supports an array argument');
    }
  }

  /*
   * @method get
   * @param key {Object | Function}
   * @return {Any} stored value
   */
  WeakMap.prototype.get = function (obj) {
    if (!isObject(obj)) {
      return undefined;
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    if (meta) {
      var map = meta.readableWeak();
      if (map) {
        if (map[this._id] === _emberMetalMeta.UNDEFINED) {
          return undefined;
        }

        return map[this._id];
      }
    }
  };

  /*
   * @method set
   * @param key {Object | Function}
   * @param value {Any}
   * @return {WeakMap} the weak map
   */
  WeakMap.prototype.set = function (obj, value) {
    if (!isObject(obj)) {
      throw new TypeError('Invalid value used as weak map key');
    }

    if (value === undefined) {
      value = _emberMetalMeta.UNDEFINED;
    }

    _emberMetalMeta.meta(obj).writableWeak()[this._id] = value;

    return this;
  };

  /*
   * @method has
   * @param key {Object | Function}
   * @return {boolean} if the key exists
   */
  WeakMap.prototype.has = function (obj) {
    if (!isObject(obj)) {
      return false;
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    if (meta) {
      var map = meta.readableWeak();
      if (map) {
        return map[this._id] !== undefined;
      }
    }

    return false;
  };

  /*
   * @method delete
   * @param key {Object | Function}
   * @return {boolean} if the key was deleted
   */
  WeakMap.prototype.delete = function (obj) {
    if (this.has(obj)) {
      delete _emberMetalMeta.meta(obj).writableWeak()[this._id];
      return true;
    } else {
      return false;
    }
  };

  /*
   * @method toString
   * @return {String}
   */
  WeakMap.prototype.toString = function () {
    return '[object WeakMap]';
  };
});
enifed('ember-template-compiler/compat', ['exports', 'ember-metal', 'ember-template-compiler/system/precompile', 'ember-template-compiler/system/compile', 'ember-template-compiler/system/compile-options'], function (exports, _emberMetal, _emberTemplateCompilerSystemPrecompile, _emberTemplateCompilerSystemCompile, _emberTemplateCompilerSystemCompileOptions) {
  'use strict';

  var EmberHandlebars = _emberMetal.default.Handlebars = _emberMetal.default.Handlebars || {};
  var EmberHTMLBars = _emberMetal.default.HTMLBars = _emberMetal.default.HTMLBars || {};

  EmberHTMLBars.precompile = EmberHandlebars.precompile = _emberTemplateCompilerSystemPrecompile.default;
  EmberHTMLBars.compile = EmberHandlebars.compile = _emberTemplateCompilerSystemCompile.default;
  EmberHTMLBars.registerPlugin = _emberTemplateCompilerSystemCompileOptions.registerPlugin;
});
// reexports
enifed('ember-template-compiler/index', ['exports', 'ember-metal', 'ember-environment', 'ember/version', 'ember-template-compiler/compat', 'ember-template-compiler/system/bootstrap', 'ember-template-compiler/system/precompile', 'ember-template-compiler/system/compile', 'ember-template-compiler/system/compile-options', 'ember-template-compiler/plugins'], function (exports, _emberMetal, _emberEnvironment, _emberVersion, _emberTemplateCompilerCompat, _emberTemplateCompilerSystemBootstrap, _emberTemplateCompilerSystemPrecompile, _emberTemplateCompilerSystemCompile, _emberTemplateCompilerSystemCompileOptions, _emberTemplateCompilerPlugins) {
  'use strict';

  // private API used by ember-cli-htmlbars to setup ENV and FEATURES
  if (!_emberMetal.default.ENV) {
    _emberMetal.default.ENV = _emberEnvironment.ENV;
  }
  if (!_emberMetal.default.FEATURES) {
    _emberMetal.default.FEATURES = _emberMetal.FEATURES;
  }
  if (!_emberMetal.default.VERSION) {
    _emberMetal.default.VERSION = _emberVersion.default;
  }

  exports._Ember = _emberMetal.default;
  exports.precompile = _emberTemplateCompilerSystemPrecompile.default;
  exports.compile = _emberTemplateCompilerSystemCompile.default;
  exports.compileOptions = _emberTemplateCompilerSystemCompileOptions.default;
  exports.registerPlugin = _emberTemplateCompilerSystemCompileOptions.registerPlugin;
  exports.defaultPlugins = _emberTemplateCompilerPlugins.default;

  // used for adding Ember.Handlebars.compile for backwards compat
});

// used to bootstrap templates
enifed('ember-template-compiler/plugins/assert-reserved-named-arguments', ['exports', 'ember-metal', 'ember-template-compiler/system/calculate-location-display'], function (exports, _emberMetal, _emberTemplateCompilerSystemCalculateLocationDisplay) {
  'use strict';

  exports.default = AssertReservedNamedArguments;

  function AssertReservedNamedArguments(options) {
    this.syntax = null;
    this.options = options;
  }

  AssertReservedNamedArguments.prototype.transform = function AssertReservedNamedArguments_transform(ast) {
    var moduleName = this.options.meta.moduleName;

    this.syntax.traverse(ast, {
      PathExpression: function (node) {
        if (node.original[0] === '@') {
          _emberMetal.assert(assertMessage(moduleName, node));
        }
      }
    });

    return ast;
  };

  function assertMessage(moduleName, node) {
    var path = node.original;
    var source = _emberTemplateCompilerSystemCalculateLocationDisplay.default(moduleName, node.loc);

    return '\'' + path + '\' is not a valid path. ' + source;
  }
});
enifed('ember-template-compiler/plugins/deprecate-render-model', ['exports', 'ember-metal', 'ember-template-compiler/system/calculate-location-display'], function (exports, _emberMetal, _emberTemplateCompilerSystemCalculateLocationDisplay) {
  'use strict';

  exports.default = DeprecateRenderModel;

  function DeprecateRenderModel(options) {
    this.syntax = null;
    this.options = options;
  }

  DeprecateRenderModel.prototype.transform = function DeprecateRenderModel_transform(ast) {
    var moduleName = this.options.meta.moduleName;
    var walker = new this.syntax.Walker();

    walker.visit(ast, function (node) {
      if (!validate(node)) {
        return;
      }

      each(node.params, function (param) {
        if (param.type !== 'PathExpression') {
          return;
        }

        _emberMetal.deprecate(deprecationMessage(moduleName, node, param), false, {
          id: 'ember-template-compiler.deprecate-render-model',
          until: '3.0.0',
          url: 'http://emberjs.com/deprecations/v2.x#toc_model-param-in-code-render-code-helper'
        });
      });
    });

    return ast;
  };

  function validate(node) {
    return node.type === 'MustacheStatement' && node.path.original === 'render' && node.params.length > 1;
  }

  function each(list, callback) {
    for (var i = 0, l = list.length; i < l; i++) {
      callback(list[i]);
    }
  }

  function deprecationMessage(moduleName, node, param) {
    var sourceInformation = _emberTemplateCompilerSystemCalculateLocationDisplay.default(moduleName, node.loc);
    var componentName = node.params[0].original;
    var modelName = param.original;
    var original = '{{render "' + componentName + '" ' + modelName + '}}';
    var preferred = '{{' + componentName + ' model=' + modelName + '}}';

    return 'Please refactor `' + original + '` to a component and invoke via' + (' `' + preferred + '`. ' + sourceInformation);
  }
});
enifed('ember-template-compiler/plugins/index', ['exports', 'ember-template-compiler/plugins/transform-old-binding-syntax', 'ember-template-compiler/plugins/transform-item-class', 'ember-template-compiler/plugins/transform-angle-bracket-components', 'ember-template-compiler/plugins/transform-input-on-to-onEvent', 'ember-template-compiler/plugins/transform-top-level-components', 'ember-template-compiler/plugins/transform-inline-link-to', 'ember-template-compiler/plugins/transform-old-class-binding-syntax', 'ember-template-compiler/plugins/deprecate-render-model', 'ember-template-compiler/plugins/assert-reserved-named-arguments', 'ember-template-compiler/plugins/transform-action-syntax', 'ember-template-compiler/plugins/transform-input-type-syntax', 'ember-template-compiler/plugins/transform-attrs-into-args', 'ember-template-compiler/plugins/transform-each-in-into-each', 'ember-template-compiler/plugins/transform-has-block-syntax'], function (exports, _emberTemplateCompilerPluginsTransformOldBindingSyntax, _emberTemplateCompilerPluginsTransformItemClass, _emberTemplateCompilerPluginsTransformAngleBracketComponents, _emberTemplateCompilerPluginsTransformInputOnToOnEvent, _emberTemplateCompilerPluginsTransformTopLevelComponents, _emberTemplateCompilerPluginsTransformInlineLinkTo, _emberTemplateCompilerPluginsTransformOldClassBindingSyntax, _emberTemplateCompilerPluginsDeprecateRenderModel, _emberTemplateCompilerPluginsAssertReservedNamedArguments, _emberTemplateCompilerPluginsTransformActionSyntax, _emberTemplateCompilerPluginsTransformInputTypeSyntax, _emberTemplateCompilerPluginsTransformAttrsIntoArgs, _emberTemplateCompilerPluginsTransformEachInIntoEach, _emberTemplateCompilerPluginsTransformHasBlockSyntax) {
  'use strict';

  exports.default = Object.freeze([_emberTemplateCompilerPluginsTransformOldBindingSyntax.default, _emberTemplateCompilerPluginsTransformItemClass.default, _emberTemplateCompilerPluginsTransformAngleBracketComponents.default, _emberTemplateCompilerPluginsTransformInputOnToOnEvent.default, _emberTemplateCompilerPluginsTransformTopLevelComponents.default, _emberTemplateCompilerPluginsTransformInlineLinkTo.default, _emberTemplateCompilerPluginsTransformOldClassBindingSyntax.default, _emberTemplateCompilerPluginsDeprecateRenderModel.default, _emberTemplateCompilerPluginsAssertReservedNamedArguments.default, _emberTemplateCompilerPluginsTransformActionSyntax.default, _emberTemplateCompilerPluginsTransformInputTypeSyntax.default, _emberTemplateCompilerPluginsTransformAttrsIntoArgs.default, _emberTemplateCompilerPluginsTransformEachInIntoEach.default, _emberTemplateCompilerPluginsTransformHasBlockSyntax.default]);
});
enifed('ember-template-compiler/plugins/transform-action-syntax', ['exports'], function (exports) {
  /**
   @module ember
   @submodule ember-glimmer
  */

  /**
    A Glimmer2 AST transformation that replaces all instances of
  
    ```handlebars
   <button {{action 'foo'}}>
   <button onblur={{action 'foo'}}>
   <button onblur={{action (action 'foo') 'bar'}}>
    ```
  
    with
  
    ```handlebars
   <button {{action this 'foo'}}>
   <button onblur={{action this 'foo'}}>
   <button onblur={{action this (action this 'foo') 'bar'}}>
    ```
  
    @private
    @class TransformActionSyntax
  */

  'use strict';

  exports.default = TransformActionSyntax;

  function TransformActionSyntax() {
    // set later within Glimmer2 to the syntax package
    this.syntax = null;
  }

  /**
    @private
    @method transform
    @param {AST} ast The AST to be transformed.
  */
  TransformActionSyntax.prototype.transform = function TransformActionSyntax_transform(ast) {
    var _syntax = this.syntax;
    var traverse = _syntax.traverse;
    var b = _syntax.builders;

    traverse(ast, {
      ElementModifierStatement: function (node) {
        if (isAction(node)) {
          insertThisAsFirstParam(node, b);
        }
      },
      MustacheStatement: function (node) {
        if (isAction(node)) {
          insertThisAsFirstParam(node, b);
        }
      },
      SubExpression: function (node) {
        if (isAction(node)) {
          insertThisAsFirstParam(node, b);
        }
      }
    });

    return ast;
  };

  function isAction(node) {
    return node.path.original === 'action';
  }

  function insertThisAsFirstParam(node, builders) {
    node.params.unshift(builders.path('this'));
  }
});
enifed('ember-template-compiler/plugins/transform-angle-bracket-components', ['exports'], function (exports) {
  'use strict';

  exports.default = TransformAngleBracketComponents;

  function TransformAngleBracketComponents() {
    // set later within HTMLBars to the syntax package
    this.syntax = null;
  }

  /**
    @private
    @method transform
    @param {AST} ast The AST to be transformed.
  */
  TransformAngleBracketComponents.prototype.transform = function TransformAngleBracketComponents_transform(ast) {
    var walker = new this.syntax.Walker();

    walker.visit(ast, function (node) {
      if (!validate(node)) {
        return;
      }

      node.tag = '<' + node.tag + '>';
    });

    return ast;
  };

  function validate(node) {
    return node.type === 'ComponentNode';
  }
});
enifed('ember-template-compiler/plugins/transform-attrs-into-args', ['exports'], function (exports) {
  /**
   @module ember
   @submodule ember-glimmer
  */

  /**
    A Glimmer2 AST transformation that replaces all instances of
  
    ```handlebars
   {{attrs.foo.bar}}
    ```
  
    to
  
    ```handlebars
   {{@foo.bar}}
    ```
  
    as well as `{{#if attrs.foo}}`, `{{deeply (nested attrs.foobar.baz)}}` etc
  
    @private
    @class TransformAttrsToProps
  */

  'use strict';

  exports.default = TransformAttrsToProps;

  function TransformAttrsToProps() {
    // set later within Glimmer2 to the syntax package
    this.syntax = null;
  }

  function isAttrs(node) {
    if (node.parts[0] === 'attrs') {
      return true;
    }

    var _this = node.parts[0];
    var attrs = node.parts[1];

    if (_this === null && attrs === 'attrs') {
      node.parts.shift();
      node.original = node.original.slice(5);
      return true;
    }
  }

  /**
    @private
    @method transform
    @param {AST} ast The AST to be transformed.
  */
  TransformAttrsToProps.prototype.transform = function TransformAttrsToProps_transform(ast) {
    var _syntax = this.syntax;
    var traverse = _syntax.traverse;
    var b = _syntax.builders;

    traverse(ast, {
      PathExpression: function (node) {
        if (isAttrs(node)) {
          var path = b.path(node.original.substr(6));
          path.original = '@' + path.original;
          path.data = true;
          return path;
        }
      }
    });

    return ast;
  };
});
enifed('ember-template-compiler/plugins/transform-each-in-into-each', ['exports'], function (exports) {
  /**
   @module ember
   @submodule ember-glimmer
  */

  /**
    A Glimmer2 AST transformation that replaces all instances of
  
    ```handlebars
   {{#each-in iterableThing as |key value|}}
    ```
  
    with
  
    ```handlebars
   {{#each (-each-in iterableThing) as |key value|}}
    ```
  
    @private
    @class TransformHasBlockSyntax
  */

  'use strict';

  exports.default = TransformEachInIntoEach;

  function TransformEachInIntoEach() {
    // set later within Glimmer2 to the syntax package
    this.syntax = null;
  }

  /**
    @private
    @method transform
    @param {AST} ast The AST to be transformed.
  */
  TransformEachInIntoEach.prototype.transform = function TransformEachInIntoEach_transform(ast) {
    var _syntax = this.syntax;
    var traverse = _syntax.traverse;
    var b = _syntax.builders;

    traverse(ast, {
      BlockStatement: function (node) {
        if (node.path.original === 'each-in') {
          node.params[0] = b.sexpr(b.path('-each-in'), [node.params[0]]);
          return b.block(b.path('each'), node.params, node.hash, node.program, node.inverse, node.loc);
        }
      }
    });

    return ast;
  };
});
enifed('ember-template-compiler/plugins/transform-has-block-syntax', ['exports'], function (exports) {
  /**
   @module ember
   @submodule ember-glimmer
  */

  /**
    A Glimmer2 AST transformation that replaces all instances of
  
    ```handlebars
   {{hasBlock}}
    ```
  
    with
  
    ```handlebars
   {{has-block}}
    ```
  
    @private
    @class TransformHasBlockSyntax
  */

  'use strict';

  exports.default = TransformHasBlockSyntax;

  function TransformHasBlockSyntax() {
    // set later within Glimmer2 to the syntax package
    this.syntax = null;
  }

  var TRANSFORMATIONS = {
    hasBlock: 'has-block',
    hasBlockParams: 'has-block-params'
  };

  /**
    @private
    @method transform
    @param {AST} ast The AST to be transformed.
  */
  TransformHasBlockSyntax.prototype.transform = function TransformHasBlockSyntax_transform(ast) {
    var _syntax = this.syntax;
    var traverse = _syntax.traverse;
    var b = _syntax.builders;

    traverse(ast, {
      PathExpression: function (node) {
        if (TRANSFORMATIONS[node.original]) {
          return b.sexpr(b.path(TRANSFORMATIONS[node.original]));
        }
      },
      MustacheStatement: function (node) {
        if (TRANSFORMATIONS[node.path.original]) {
          return b.mustache(b.path(TRANSFORMATIONS[node.path.original]), node.params, node.hash, null, node.loc);
        }
      },
      SubExpression: function (node) {
        if (TRANSFORMATIONS[node.path.original]) {
          return b.sexpr(b.path(TRANSFORMATIONS[node.path.original]), node.params, node.hash);
        }
      }
    });

    return ast;
  };
});
enifed('ember-template-compiler/plugins/transform-inline-link-to', ['exports'], function (exports) {
  'use strict';

  exports.default = TransformInlineLinkTo;

  function TransformInlineLinkTo(options) {
    this.options = options;
    this.syntax = null;
  }

  TransformInlineLinkTo.prototype.transform = function TransformInlineLinkTo_transform(ast) {
    var _syntax = this.syntax;
    var traverse = _syntax.traverse;
    var b = _syntax.builders;

    function buildProgram(content, loc) {
      return b.program([buildStatement(content, loc)], null, loc);
    }

    function buildStatement(content, loc) {
      switch (content.type) {
        case 'PathExpression':
          return b.mustache(content, null, null, null, loc);

        case 'SubExpression':
          return b.mustache(content.path, content.params, content.hash, null, loc);

        // The default case handles literals.
        default:
          return b.text('' + content.value, loc);
      }
    }

    function unsafeHtml(expr) {
      return b.sexpr('-html-safe', [expr]);
    }

    traverse(ast, {
      MustacheStatement: function (node) {
        if (node.path.original === 'link-to') {
          var content = node.escaped ? node.params[0] : unsafeHtml(node.params[0]);
          return b.block('link-to', node.params.slice(1), node.hash, buildProgram(content, node.loc), null, node.loc);
        }
      }
    });

    return ast;
  };
});
enifed('ember-template-compiler/plugins/transform-input-on-to-onEvent', ['exports', 'ember-metal', 'ember-template-compiler/system/calculate-location-display'], function (exports, _emberMetal, _emberTemplateCompilerSystemCalculateLocationDisplay) {
  'use strict';

  exports.default = TransformInputOnToOnEvent;

  /**
   @module ember
   @submodule ember-htmlbars
  */

  /**
    An HTMLBars AST transformation that replaces all instances of
  
    ```handlebars
   {{input on="enter" action="doStuff"}}
   {{input on="key-press" action="doStuff"}}
    ```
  
    with
  
    ```handlebars
   {{input enter="doStuff"}}
   {{input key-press="doStuff"}}
    ```
  
    @private
    @class TransformInputOnToOnEvent
  */

  function TransformInputOnToOnEvent() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    // set later within HTMLBars to the syntax package
    this.syntax = null;
    this.options = options;
  }

  /**
    @private
    @method transform
    @param {AST} ast The AST to be transformed.
  */
  TransformInputOnToOnEvent.prototype.transform = function TransformInputOnToOnEvent_transform(ast) {
    var pluginContext = this;
    var b = pluginContext.syntax.builders;
    var walker = new pluginContext.syntax.Walker();
    var moduleName = pluginContext.options.meta.moduleName;

    walker.visit(ast, function (node) {
      if (pluginContext.validate(node)) {
        var action = hashPairForKey(node.hash, 'action');
        var on = hashPairForKey(node.hash, 'on');
        var onEvent = hashPairForKey(node.hash, 'onEvent');
        var normalizedOn = on || onEvent;
        var moduleInfo = _emberTemplateCompilerSystemCalculateLocationDisplay.default(moduleName, node.loc);

        if (normalizedOn && normalizedOn.value.type !== 'StringLiteral') {
          _emberMetal.deprecate('Using a dynamic value for \'#{normalizedOn.key}=\' with the \'{{input}}\' helper ' + moduleInfo + 'is deprecated.', false, { id: 'ember-template-compiler.transform-input-on-to-onEvent.dynamic-value', until: '3.0.0' });

          normalizedOn.key = 'onEvent';
          return; // exit early, as we cannot transform further
        }

        removeFromHash(node.hash, normalizedOn);
        removeFromHash(node.hash, action);

        if (!action) {
          _emberMetal.deprecate('Using \'{{input ' + normalizedOn.key + '="' + normalizedOn.value.value + '" ...}}\' without specifying an action ' + moduleInfo + 'will do nothing.', false, { id: 'ember-template-compiler.transform-input-on-to-onEvent.no-action', until: '3.0.0' });

          return; // exit early, if no action was available there is nothing to do
        }

        var specifiedOn = normalizedOn ? normalizedOn.key + '="' + normalizedOn.value.value + '" ' : '';
        if (normalizedOn && normalizedOn.value.value === 'keyPress') {
          // using `keyPress` in the root of the component will
          // clobber the keyPress event handler
          normalizedOn.value.value = 'key-press';
        }

        var expected = (normalizedOn ? normalizedOn.value.value : 'enter') + '="' + action.value.original + '"';

        _emberMetal.deprecate('Using \'{{input ' + specifiedOn + 'action="' + action.value.original + '"}}\' ' + moduleInfo + 'is deprecated. Please use \'{{input ' + expected + '}}\' instead.', false, { id: 'ember-template-compiler.transform-input-on-to-onEvent.normalized-on', until: '3.0.0' });
        if (!normalizedOn) {
          normalizedOn = b.pair('onEvent', b.string('enter'));
        }

        node.hash.pairs.push(b.pair(normalizedOn.value.value, action.value));
      }
    });

    return ast;
  };

  TransformInputOnToOnEvent.prototype.validate = function TransformWithAsToHash_validate(node) {
    return node.type === 'MustacheStatement' && node.path.original === 'input' && (hashPairForKey(node.hash, 'action') || hashPairForKey(node.hash, 'on') || hashPairForKey(node.hash, 'onEvent'));
  };

  function hashPairForKey(hash, key) {
    for (var i = 0; i < hash.pairs.length; i++) {
      var pair = hash.pairs[i];
      if (pair.key === key) {
        return pair;
      }
    }

    return false;
  }

  function removeFromHash(hash, pairToRemove) {
    var newPairs = [];
    for (var i = 0; i < hash.pairs.length; i++) {
      var pair = hash.pairs[i];

      if (pair !== pairToRemove) {
        newPairs.push(pair);
      }
    }

    hash.pairs = newPairs;
  }
});
enifed('ember-template-compiler/plugins/transform-input-type-syntax', ['exports'], function (exports) {
  /**
   @module ember
   @submodule ember-glimmer
  */

  /**
    A Glimmer2 AST transformation that replaces all instances of
  
    ```handlebars
   {{input type=boundType}}
    ```
  
    with
  
    ```handlebars
   {{input (-input-type boundType) type=boundType}}
    ```
  
    Note that the type parameters is not removed as the -input-type helpers
    is only used to select the component class. The component still needs
    the type parameter to function.
  
    @private
    @class TransformInputTypeSyntax
  */

  'use strict';

  exports.default = TransformInputTypeSyntax;

  function TransformInputTypeSyntax() {
    // set later within Glimmer2 to the syntax package
    this.syntax = null;
  }

  /**
    @private
    @method transform
    @param {AST} ast The AST to be transformed.
  */
  TransformInputTypeSyntax.prototype.transform = function TransformInputTypeSyntax_transform(ast) {
    var _syntax = this.syntax;
    var traverse = _syntax.traverse;
    var b = _syntax.builders;

    traverse(ast, {
      MustacheStatement: function (node) {
        if (isInput(node)) {
          insertTypeHelperParameter(node, b);
        }
      }
    });

    return ast;
  };

  function isInput(node) {
    return node.path.original === 'input';
  }

  function insertTypeHelperParameter(node, builders) {
    var pairs = node.hash.pairs;
    var pair = null;
    for (var i = 0; i < pairs.length; i++) {
      if (pairs[i].key === 'type') {
        pair = pairs[i];
        break;
      }
    }
    if (pair && pair.value.type !== 'StringLiteral') {
      node.params.unshift(builders.sexpr('-input-type', [builders.path(pair.value.original, pair.loc)], null, pair.loc));
    }
  }
});
enifed('ember-template-compiler/plugins/transform-item-class', ['exports'], function (exports) {
  'use strict';

  exports.default = TransformItemClass;

  function TransformItemClass() {
    this.syntax = null;
  }

  TransformItemClass.prototype.transform = function TransformItemClass_transform(ast) {
    var b = this.syntax.builders;
    var walker = new this.syntax.Walker();

    walker.visit(ast, function (node) {
      if (!validate(node)) {
        return;
      }

      for (var i = 0; i < node.hash.pairs.length; i++) {
        var pair = node.hash.pairs[i];
        var key = pair.key;
        var value = pair.value;

        if (key !== 'itemClass') {
          return;
        }
        if (value.type === 'StringLiteral') {
          return;
        }

        var propName = value.original;
        var params = [value];
        var sexprParams = [b.string(propName), b.path(propName)];

        params.push(b.sexpr(b.string('-normalize-class'), sexprParams));
        var sexpr = b.sexpr(b.string('if'), params);

        pair.value = sexpr;
      }
    });

    return ast;
  };

  function validate(node) {
    return (node.type === 'BlockStatement' || node.type === 'MustacheStatement') && node.path.original === 'collection';
  }
});
enifed('ember-template-compiler/plugins/transform-old-binding-syntax', ['exports', 'ember-metal', 'ember-template-compiler/system/calculate-location-display'], function (exports, _emberMetal, _emberTemplateCompilerSystemCalculateLocationDisplay) {
  'use strict';

  exports.default = TransformOldBindingSyntax;

  function TransformOldBindingSyntax(options) {
    this.syntax = null;
    this.options = options;
  }

  TransformOldBindingSyntax.prototype.transform = function TransformOldBindingSyntax_transform(ast) {
    var moduleName = this.options.meta.moduleName;
    var b = this.syntax.builders;
    var walker = new this.syntax.Walker();

    walker.visit(ast, function (node) {
      if (!validate(node)) {
        return;
      }

      for (var i = 0; i < node.hash.pairs.length; i++) {
        var pair = node.hash.pairs[i];
        var key = pair.key;
        var value = pair.value;

        var sourceInformation = _emberTemplateCompilerSystemCalculateLocationDisplay.default(moduleName, pair.loc);

        if (key === 'classBinding') {
          return;
        }

        _emberMetal.assert('Setting \'attributeBindings\' via template helpers is not allowed ' + sourceInformation, key !== 'attributeBindings');

        if (key.substr(-7) === 'Binding') {
          var newKey = key.slice(0, -7);

          _emberMetal.deprecate('You\'re using legacy binding syntax: ' + key + '=' + exprToString(value) + ' ' + sourceInformation + '. Please replace with ' + newKey + '=' + value.original, false, { id: 'ember-template-compiler.transform-old-binding-syntax', until: '3.0.0' });

          pair.key = newKey;
          if (value.type === 'StringLiteral') {
            pair.value = b.path(value.original);
          }
        }
      }
    });

    return ast;
  };

  function validate(node) {
    return node.type === 'BlockStatement' || node.type === 'MustacheStatement';
  }

  function exprToString(expr) {
    switch (expr.type) {
      case 'StringLiteral':
        return '"' + expr.original + '"';
      case 'PathExpression':
        return expr.original;
    }
  }
});
enifed('ember-template-compiler/plugins/transform-old-class-binding-syntax', ['exports'], function (exports) {
  'use strict';

  exports.default = TransformOldClassBindingSyntax;

  function TransformOldClassBindingSyntax(options) {
    this.syntax = null;
    this.options = options;
  }

  TransformOldClassBindingSyntax.prototype.transform = function TransformOldClassBindingSyntax_transform(ast) {
    var b = this.syntax.builders;
    var walker = new this.syntax.Walker();

    walker.visit(ast, function (node) {
      if (!validate(node)) {
        return;
      }

      var allOfTheMicrosyntaxes = [];
      var allOfTheMicrosyntaxIndexes = [];
      var classPair = undefined;

      each(node.hash.pairs, function (pair, index) {
        var key = pair.key;

        if (key === 'classBinding' || key === 'classNameBindings') {
          allOfTheMicrosyntaxIndexes.push(index);
          allOfTheMicrosyntaxes.push(pair);
        } else if (key === 'class') {
          classPair = pair;
        }
      });

      if (allOfTheMicrosyntaxes.length === 0) {
        return;
      }

      var classValue = [];

      if (classPair) {
        classValue.push(classPair.value);
        classValue.push(b.string(' '));
      } else {
        classPair = b.pair('class', null);
        node.hash.pairs.push(classPair);
      }

      each(allOfTheMicrosyntaxIndexes, function (index) {
        node.hash.pairs.splice(index, 1);
      });

      each(allOfTheMicrosyntaxes, function (_ref) {
        var value = _ref.value;
        var loc = _ref.loc;

        var sexprs = [];
        // TODO: add helpful deprecation when both `classNames` and `classNameBindings` can
        // be removed.

        if (value.type === 'StringLiteral') {
          var microsyntax = parseMicrosyntax(value.original);

          buildSexprs(microsyntax, sexprs, b);

          classValue.push.apply(classValue, sexprs);
        }
      });

      var hash = b.hash();
      classPair.value = b.sexpr(b.path('concat'), classValue, hash);
    });

    return ast;
  };

  function buildSexprs(microsyntax, sexprs, b) {
    for (var i = 0; i < microsyntax.length; i++) {
      var _microsyntax$i = microsyntax[i];
      var propName = _microsyntax$i[0];
      var activeClass = _microsyntax$i[1];
      var inactiveClass = _microsyntax$i[2];

      var sexpr = undefined;

      // :my-class-name microsyntax for static values
      if (propName === '') {
        sexpr = b.string(activeClass);
      } else {
        var params = [b.path(propName)];

        if (activeClass || activeClass === '') {
          params.push(b.string(activeClass));
        } else {
          var sexprParams = [b.string(propName), b.path(propName)];

          var hash = b.hash();
          if (activeClass !== undefined) {
            hash.pairs.push(b.pair('activeClass', b.string(activeClass)));
          }

          if (inactiveClass !== undefined) {
            hash.pairs.push(b.pair('inactiveClass', b.string(inactiveClass)));
          }

          params.push(b.sexpr(b.path('-normalize-class'), sexprParams, hash));
        }

        if (inactiveClass || inactiveClass === '') {
          params.push(b.string(inactiveClass));
        }

        sexpr = b.sexpr(b.path('if'), params);
      }

      sexprs.push(sexpr);
      sexprs.push(b.string(' '));
    }
  }

  function validate(node) {
    return node.type === 'BlockStatement' || node.type === 'MustacheStatement';
  }

  function each(list, callback) {
    for (var i = 0; i < list.length; i++) {
      callback(list[i], i);
    }
  }

  function parseMicrosyntax(string) {
    var segments = string.split(' ');

    for (var i = 0; i < segments.length; i++) {
      segments[i] = segments[i].split(':');
    }

    return segments;
  }
});
enifed('ember-template-compiler/plugins/transform-top-level-components', ['exports'], function (exports) {
  'use strict';

  exports.default = TransformTopLevelComponents;

  function TransformTopLevelComponents() {
    // set later within HTMLBars to the syntax package
    this.syntax = null;
  }

  /**
    @private
    @method transform
    @param {AST} The AST to be transformed.
  */
  TransformTopLevelComponents.prototype.transform = function TransformTopLevelComponents_transform(ast) {
    hasSingleComponentNode(ast, function (component) {
      component.tag = '@' + component.tag;
      component.isStatic = true;
    });

    return ast;
  };

  function hasSingleComponentNode(program, componentCallback) {
    var loc = program.loc;
    var body = program.body;

    if (!loc || loc.start.line !== 1 || loc.start.column !== 0) {
      return;
    }

    var lastComponentNode = undefined;
    var lastIndex = undefined;
    var nodeCount = 0;

    for (var i = 0; i < body.length; i++) {
      var curr = body[i];

      // text node with whitespace only
      if (curr.type === 'TextNode' && /^[\s]*$/.test(curr.chars)) {
        continue;
      }

      // has multiple root elements if we've been here before
      if (nodeCount++ > 0) {
        return false;
      }

      if (curr.type === 'ComponentNode' || curr.type === 'ElementNode') {
        lastComponentNode = curr;
        lastIndex = i;
      }
    }

    if (!lastComponentNode) {
      return;
    }

    if (lastComponentNode.type === 'ComponentNode') {
      componentCallback(lastComponentNode);
    }
  }
});
enifed('ember-template-compiler/system/bootstrap', ['exports', 'ember-metal', 'ember-template-compiler/system/compile'], function (exports, _emberMetal, _emberTemplateCompilerSystemCompile) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  /**
    Find templates stored in the head tag as script tags and make them available
    to `Ember.CoreView` in the global `Ember.TEMPLATES` object.
  
    Script tags with `text/x-handlebars` will be compiled
    with Ember's template compiler and are suitable for use as a view's template.
  
    @private
    @method bootstrap
    @for Ember.HTMLBars
    @static
    @param ctx
  */
  function bootstrap(_ref) {
    var context = _ref.context;
    var hasTemplate = _ref.hasTemplate;
    var setTemplate = _ref.setTemplate;

    if (!context) {
      context = document;
    }

    var selector = 'script[type="text/x-handlebars"]';

    var elements = context.querySelectorAll(selector);

    for (var i = 0; i < elements.length; i++) {
      var script = elements[i];

      // Get the name of the script
      // First look for data-template-name attribute, then fall back to its
      // id if no name is found.
      var templateName = script.getAttribute('data-template-name') || script.getAttribute('id') || 'application';
      var template = undefined;

      template = _emberTemplateCompilerSystemCompile.default(script.innerHTML, {
        moduleName: templateName
      });

      // Check if template of same name already exists.
      if (hasTemplate(templateName)) {
        throw new _emberMetal.Error('Template named "' + templateName + '" already exists.');
      }

      // For templates which have a name, we save them and then remove them from the DOM.
      setTemplate(templateName, template);

      // Remove script tag from DOM.
      script.parentNode.removeChild(script);
    }
  }

  exports.default = bootstrap;
});
enifed('ember-template-compiler/system/calculate-location-display', ['exports'], function (exports) {
  'use strict';

  exports.default = calculateLocationDisplay;

  function calculateLocationDisplay(moduleName, _loc) {
    var loc = _loc || {};

    var _ref = loc.start || {};

    var column = _ref.column;
    var line = _ref.line;

    var moduleInfo = '';
    if (moduleName) {
      moduleInfo += '\'' + moduleName + '\' ';
    }

    if (line !== undefined && column !== undefined) {
      if (moduleName) {
        // only prepend @ if the moduleName was present
        moduleInfo += '@ ';
      }
      moduleInfo += 'L' + line + ':C' + column;
    }

    if (moduleInfo) {
      moduleInfo = '(' + moduleInfo + ') ';
    }

    return moduleInfo;
  }
});
enifed('ember-template-compiler/system/compile-options', ['exports', 'ember-utils', 'ember-template-compiler/plugins'], function (exports, _emberUtils, _emberTemplateCompilerPlugins) {
  'use strict';

  exports.default = compileOptions;
  exports.registerPlugin = registerPlugin;
  exports.removePlugin = removePlugin;

  var USER_PLUGINS = [];

  function compileOptions(_options) {
    var options = _emberUtils.assign({ meta: {} }, _options);

    // move `moduleName` into `meta` property
    if (options.moduleName) {
      var meta = options.meta;
      meta.moduleName = options.moduleName;
    }

    if (!options.plugins) {
      options.plugins = { ast: [].concat(USER_PLUGINS, _emberTemplateCompilerPlugins.default) };
    } else {
      var potententialPugins = [].concat(USER_PLUGINS, _emberTemplateCompilerPlugins.default);
      var pluginsToAdd = potententialPugins.filter(function (plugin) {
        return options.plugins.ast.indexOf(plugin) === -1;
      });
      options.plugins.ast = options.plugins.ast.slice().concat(pluginsToAdd);
    }

    return options;
  }

  function registerPlugin(type, PluginClass) {
    if (type !== 'ast') {
      throw new Error('Attempting to register ' + PluginClass + ' as "' + type + '" which is not a valid Glimmer plugin type.');
    }

    if (USER_PLUGINS.indexOf(PluginClass) === -1) {
      USER_PLUGINS = [PluginClass].concat(USER_PLUGINS);
    }
  }

  function removePlugin(type, PluginClass) {
    if (type !== 'ast') {
      throw new Error('Attempting to unregister ' + PluginClass + ' as "' + type + '" which is not a valid Glimmer plugin type.');
    }

    USER_PLUGINS = USER_PLUGINS.filter(function (plugin) {
      return plugin !== PluginClass;
    });
  }
});
enifed('ember-template-compiler/system/compile', ['exports', 'require', 'ember-template-compiler/system/precompile'], function (exports, _require, _emberTemplateCompilerSystemPrecompile) {
  /**
  @module ember
  @submodule ember-template-compiler
  */
  'use strict';

  exports.default = compile;

  var template = undefined;

  /**
    Uses HTMLBars `compile` function to process a string into a compiled template.
  
    This is not present in production builds.
  
    @private
    @method compile
    @param {String} templateString This is the string to be compiled by HTMLBars.
    @param {Object} options This is an options hash to augment the compiler options.
  */

  function compile(templateString, options) {
    if (!template && _require.has('ember-glimmer')) {
      template = _require.default('ember-glimmer').template;
    }

    if (!template) {
      throw new Error('Cannot call `compile` with only the template compiler loaded. Please load `ember.debug.js` or `ember.prod.js` prior to calling `compile`.');
    }

    var precompiledTemplateString = _emberTemplateCompilerSystemPrecompile.default(templateString, options);
    var templateJS = new Function('return ' + precompiledTemplateString)();
    return template(templateJS);
  }
});
enifed('ember-template-compiler/system/precompile', ['exports', 'ember-template-compiler/system/compile-options', 'require'], function (exports, _emberTemplateCompilerSystemCompileOptions, _require) {
  /**
  @module ember
  @submodule ember-template-compiler
  */

  'use strict';

  exports.default = precompile;

  var glimmerPrecompile = undefined;

  /**
    Uses HTMLBars `compile` function to process a string into a compiled template string.
    The returned string must be passed through `Ember.HTMLBars.template`.
  
    This is not present in production builds.
  
    @private
    @method precompile
    @param {String} templateString This is the string to be compiled by HTMLBars.
  */

  function precompile(templateString, options) {
    if (!glimmerPrecompile && _require.has('glimmer-compiler')) {
      glimmerPrecompile = _require.default('glimmer-compiler').precompile;
    }

    if (!glimmerPrecompile) {
      throw new Error('Cannot call `compile` without the template compiler loaded. Please load `ember-template-compiler.js` prior to calling `compile`.');
    }

    return glimmerPrecompile(templateString, _emberTemplateCompilerSystemCompileOptions.default(options));
  }
});
enifed("ember-utils/apply-str", ["exports"], function (exports) {
  /**
   @param {Object} t target
   @param {String} m method
   @param {Array} a args
   @private
   */
  "use strict";

  exports.default = applyStr;

  function applyStr(t, m, a) {
    var l = a && a.length;
    if (!a || !l) {
      return t[m]();
    }
    switch (l) {
      case 1:
        return t[m](a[0]);
      case 2:
        return t[m](a[0], a[1]);
      case 3:
        return t[m](a[0], a[1], a[2]);
      case 4:
        return t[m](a[0], a[1], a[2], a[3]);
      case 5:
        return t[m](a[0], a[1], a[2], a[3], a[4]);
      default:
        return t[m].apply(t, a);
    }
  }
});
enifed("ember-utils/assign", ["exports"], function (exports) {
  /**
    Copy properties from a source object to a target object.
  
    ```javascript
    var a = { first: 'Yehuda' };
    var b = { last: 'Katz' };
    var c = { company: 'Tilde Inc.' };
    Ember.assign(a, b, c); // a === { first: 'Yehuda', last: 'Katz', company: 'Tilde Inc.' }, b === { last: 'Katz' }, c === { company: 'Tilde Inc.' }
    ```
  
    @method assign
    @for Ember
    @param {Object} original The object to assign into
    @param {Object} ...args The objects to copy properties from
    @return {Object}
    @public
  */
  "use strict";

  exports.default = assign;

  function assign(original) {
    for (var i = 1; i < arguments.length; i++) {
      var arg = arguments[i];
      if (!arg) {
        continue;
      }

      var updates = Object.keys(arg);

      for (var _i = 0; _i < updates.length; _i++) {
        var prop = updates[_i];
        original[prop] = arg[prop];
      }
    }

    return original;
  }
});
enifed('ember-utils/dictionary', ['exports', 'ember-utils/empty-object'], function (exports, _emberUtilsEmptyObject) {
  'use strict';

  exports.default = makeDictionary;

  // the delete is meant to hint at runtimes that this object should remain in
  // dictionary mode. This is clearly a runtime specific hack, but currently it
  // appears worthwhile in some usecases. Please note, these deletes do increase
  // the cost of creation dramatically over a plain Object.create. And as this
  // only makes sense for long-lived dictionaries that aren't instantiated often.

  function makeDictionary(parent) {
    var dict = undefined;
    if (parent === null) {
      dict = new _emberUtilsEmptyObject.default();
    } else {
      dict = Object.create(parent);
    }
    dict['_dict'] = null;
    delete dict['_dict'];
    return dict;
  }
});
enifed("ember-utils/empty-object", ["exports"], function (exports) {
  // This exists because `Object.create(null)` is absurdly slow compared
  // to `new EmptyObject()`. In either case, you want a null prototype
  // when you're treating the object instances as arbitrary dictionaries
  // and don't want your keys colliding with build-in methods on the
  // default object prototype.

  "use strict";

  var proto = Object.create(null, {
    // without this, we will always still end up with (new
    // EmptyObject()).constructor === Object
    constructor: {
      value: undefined,
      enumerable: false,
      writable: true
    }
  });

  function EmptyObject() {}
  EmptyObject.prototype = proto;
  exports.default = EmptyObject;
});
enifed('ember-utils/guid', ['exports', 'ember-utils/intern'], function (exports, _emberUtilsIntern) {
  'use strict';

  exports.uuid = uuid;
  exports.generateGuid = generateGuid;
  exports.guidFor = guidFor;

  /**
   Previously we used `Ember.$.uuid`, however `$.uuid` has been removed from
   jQuery master. We'll just bootstrap our own uuid now.
  
   @private
   @return {Number} the uuid
   */
  var _uuid = 0;

  /**
   Generates a universally unique identifier. This method
   is used internally by Ember for assisting with
   the generation of GUID's and other unique identifiers.
  
   @public
   @return {Number} [description]
   */

  function uuid() {
    return ++_uuid;
  }

  /**
   Prefix used for guids through out Ember.
   @private
   @property GUID_PREFIX
   @for Ember
   @type String
   @final
   */
  var GUID_PREFIX = 'ember';

  // Used for guid generation...
  var numberCache = [];
  var stringCache = {};

  /**
    A unique key used to assign guids and other private metadata to objects.
    If you inspect an object in your browser debugger you will often see these.
    They can be safely ignored.
  
    On browsers that support it, these properties are added with enumeration
    disabled so they won't show up when you iterate over your properties.
  
    @private
    @property GUID_KEY
    @for Ember
    @type String
    @final
  */
  var GUID_KEY = _emberUtilsIntern.default('__ember' + +new Date());

  exports.GUID_KEY = GUID_KEY;
  var GUID_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  exports.GUID_DESC = GUID_DESC;
  var nullDescriptor = {
    configurable: true,
    writable: true,
    enumerable: false,
    value: null
  };

  var GUID_KEY_PROPERTY = {
    name: GUID_KEY,
    descriptor: nullDescriptor
  };

  exports.GUID_KEY_PROPERTY = GUID_KEY_PROPERTY;
  /**
    Generates a new guid, optionally saving the guid to the object that you
    pass in. You will rarely need to use this method. Instead you should
    call `Ember.guidFor(obj)`, which return an existing guid if available.
  
    @private
    @method generateGuid
    @for Ember
    @param {Object} [obj] Object the guid will be used for. If passed in, the guid will
      be saved on the object and reused whenever you pass the same object
      again.
  
      If no object is passed, just generate a new guid.
    @param {String} [prefix] Prefix to place in front of the guid. Useful when you want to
      separate the guid into separate namespaces.
    @return {String} the guid
  */

  function generateGuid(obj, prefix) {
    if (!prefix) {
      prefix = GUID_PREFIX;
    }

    var ret = prefix + uuid();
    if (obj) {
      if (obj[GUID_KEY] === null) {
        obj[GUID_KEY] = ret;
      } else {
        GUID_DESC.value = ret;
        if (obj.__defineNonEnumerable) {
          obj.__defineNonEnumerable(GUID_KEY_PROPERTY);
        } else {
          Object.defineProperty(obj, GUID_KEY, GUID_DESC);
        }
      }
    }
    return ret;
  }

  /**
    Returns a unique id for the object. If the object does not yet have a guid,
    one will be assigned to it. You can call this on any object,
    `Ember.Object`-based or not, but be aware that it will add a `_guid`
    property.
  
    You can also use this method on DOM Element objects.
  
    @public
    @method guidFor
    @for Ember
    @param {Object} obj any object, string, number, Element, or primitive
    @return {String} the unique guid for this instance.
  */

  function guidFor(obj) {
    var type = typeof obj;
    var isObject = type === 'object' && obj !== null;
    var isFunction = type === 'function';

    if ((isObject || isFunction) && obj[GUID_KEY]) {
      return obj[GUID_KEY];
    }

    // special cases where we don't want to add a key to object
    if (obj === undefined) {
      return '(undefined)';
    }

    if (obj === null) {
      return '(null)';
    }

    var ret = undefined;

    // Don't allow prototype changes to String etc. to change the guidFor
    switch (type) {
      case 'number':
        ret = numberCache[obj];

        if (!ret) {
          ret = numberCache[obj] = 'nu' + obj;
        }

        return ret;

      case 'string':
        ret = stringCache[obj];

        if (!ret) {
          ret = stringCache[obj] = 'st' + uuid();
        }

        return ret;

      case 'boolean':
        return obj ? '(true)' : '(false)';

      default:
        if (obj === Object) {
          return '(Object)';
        }

        if (obj === Array) {
          return '(Array)';
        }

        ret = GUID_PREFIX + uuid();

        if (obj[GUID_KEY] === null) {
          obj[GUID_KEY] = ret;
        } else {
          GUID_DESC.value = ret;

          if (obj.__defineNonEnumerable) {
            obj.__defineNonEnumerable(GUID_KEY_PROPERTY);
          } else {
            Object.defineProperty(obj, GUID_KEY, GUID_DESC);
          }
        }
        return ret;
    }
  }
});
enifed('ember-utils/index', ['exports', 'ember-utils/symbol', 'ember-utils/owner', 'ember-utils/assign', 'ember-utils/empty-object', 'ember-utils/dictionary', 'ember-utils/guid', 'ember-utils/intern', 'ember-utils/super', 'ember-utils/inspect', 'ember-utils/lookup-descriptor', 'ember-utils/invoke', 'ember-utils/make-array', 'ember-utils/apply-str', 'ember-utils/to-string'], function (exports, _emberUtilsSymbol, _emberUtilsOwner, _emberUtilsAssign, _emberUtilsEmptyObject, _emberUtilsDictionary, _emberUtilsGuid, _emberUtilsIntern, _emberUtilsSuper, _emberUtilsInspect, _emberUtilsLookupDescriptor, _emberUtilsInvoke, _emberUtilsMakeArray, _emberUtilsApplyStr, _emberUtilsToString) {
  /*
   This package will be eagerly parsed and should have no dependencies on external
   packages.
  
   It is intended to be used to share utility methods that will be needed
   by every Ember application (and is **not** a dumping ground of useful utilities).
  
   Utility methods that are needed in < 80% of cases should be placed
   elsewhere (so they can be lazily evaluated / parsed).
  */
  'use strict';

  exports.symbol = _emberUtilsSymbol.default;
  exports.getOwner = _emberUtilsOwner.getOwner;
  exports.setOwner = _emberUtilsOwner.setOwner;
  exports.OWNER = _emberUtilsOwner.OWNER;
  exports.assign = _emberUtilsAssign.default;
  exports.EmptyObject = _emberUtilsEmptyObject.default;
  exports.dictionary = _emberUtilsDictionary.default;
  exports.uuid = _emberUtilsGuid.uuid;
  exports.GUID_KEY = _emberUtilsGuid.GUID_KEY;
  exports.GUID_DESC = _emberUtilsGuid.GUID_DESC;
  exports.GUID_KEY_PROPERTY = _emberUtilsGuid.GUID_KEY_PROPERTY;
  exports.generateGuid = _emberUtilsGuid.generateGuid;
  exports.guidFor = _emberUtilsGuid.guidFor;
  exports.intern = _emberUtilsIntern.default;
  exports.checkHasSuper = _emberUtilsSuper.checkHasSuper;
  exports.ROOT = _emberUtilsSuper.ROOT;
  exports.wrap = _emberUtilsSuper.wrap;
  exports.inspect = _emberUtilsInspect.default;
  exports.lookupDescriptor = _emberUtilsLookupDescriptor.default;
  exports.canInvoke = _emberUtilsInvoke.canInvoke;
  exports.tryInvoke = _emberUtilsInvoke.tryInvoke;
  exports.makeArray = _emberUtilsMakeArray.default;
  exports.applyStr = _emberUtilsApplyStr.default;
  exports.toString = _emberUtilsToString.default;
});
enifed('ember-utils/inspect', ['exports'], function (exports) {
  'use strict';

  exports.default = inspect;
  var objectToString = Object.prototype.toString;

  /**
    Convenience method to inspect an object. This method will attempt to
    convert the object into a useful string description.
  
    It is a pretty simple implementation. If you want something more robust,
    use something like JSDump: https://github.com/NV/jsDump
  
    @method inspect
    @for Ember
    @param {Object} obj The object you want to inspect.
    @return {String} A description of the object
    @since 1.4.0
    @private
  */

  function inspect(obj) {
    if (obj === null) {
      return 'null';
    }
    if (obj === undefined) {
      return 'undefined';
    }
    if (Array.isArray(obj)) {
      return '[' + obj + ']';
    }
    // for non objects
    var type = typeof obj;
    if (type !== 'object' && type !== 'symbol') {
      return '' + obj;
    }
    // overridden toString
    if (typeof obj.toString === 'function' && obj.toString !== objectToString) {
      return obj.toString();
    }

    // Object.prototype.toString === {}.toString
    var v = undefined;
    var ret = [];
    for (var key in obj) {
      if (obj.hasOwnProperty(key)) {
        v = obj[key];
        if (v === 'toString') {
          continue;
        } // ignore useless items
        if (typeof v === 'function') {
          v = 'function() { ... }';
        }

        if (v && typeof v.toString !== 'function') {
          ret.push(key + ': ' + objectToString.call(v));
        } else {
          ret.push(key + ': ' + v);
        }
      }
    }
    return '{' + ret.join(', ') + '}';
  }
});
enifed("ember-utils/intern", ["exports"], function (exports) {
  /**
    Strongly hint runtimes to intern the provided string.
  
    When do I need to use this function?
  
    For the most part, never. Pre-mature optimization is bad, and often the
    runtime does exactly what you need it to, and more often the trade-off isn't
    worth it.
  
    Why?
  
    Runtimes store strings in at least 2 different representations:
    Ropes and Symbols (interned strings). The Rope provides a memory efficient
    data-structure for strings created from concatenation or some other string
    manipulation like splitting.
  
    Unfortunately checking equality of different ropes can be quite costly as
    runtimes must resort to clever string comparison algorithms. These
    algorithms typically cost in proportion to the length of the string.
    Luckily, this is where the Symbols (interned strings) shine. As Symbols are
    unique by their string content, equality checks can be done by pointer
    comparison.
  
    How do I know if my string is a rope or symbol?
  
    Typically (warning general sweeping statement, but truthy in runtimes at
    present) static strings created as part of the JS source are interned.
    Strings often used for comparisons can be interned at runtime if some
    criteria are met.  One of these criteria can be the size of the entire rope.
    For example, in chrome 38 a rope longer then 12 characters will not
    intern, nor will segments of that rope.
  
    Some numbers: http://jsperf.com/eval-vs-keys/8
  
    Known Trick™
  
    @private
    @return {String} interned version of the provided string
  */
  "use strict";

  exports.default = intern;

  function intern(str) {
    var obj = {};
    obj[str] = 1;
    for (var key in obj) {
      if (key === str) {
        return key;
      }
    }
    return str;
  }
});
enifed('ember-utils/invoke', ['exports', 'ember-utils/apply-str'], function (exports, _emberUtilsApplyStr) {
  'use strict';

  exports.canInvoke = canInvoke;
  exports.tryInvoke = tryInvoke;

  /**
    Checks to see if the `methodName` exists on the `obj`.
  
    ```javascript
    let foo = { bar: function() { return 'bar'; }, baz: null };
  
    Ember.canInvoke(foo, 'bar'); // true
    Ember.canInvoke(foo, 'baz'); // false
    Ember.canInvoke(foo, 'bat'); // false
    ```
  
    @method canInvoke
    @for Ember
    @param {Object} obj The object to check for the method
    @param {String} methodName The method name to check for
    @return {Boolean}
    @private
  */

  function canInvoke(obj, methodName) {
    return !!(obj && typeof obj[methodName] === 'function');
  }

  /**
    Checks to see if the `methodName` exists on the `obj`,
    and if it does, invokes it with the arguments passed.
  
    ```javascript
    let d = new Date('03/15/2013');
  
    Ember.tryInvoke(d, 'getTime');              // 1363320000000
    Ember.tryInvoke(d, 'setFullYear', [2014]);  // 1394856000000
    Ember.tryInvoke(d, 'noSuchMethod', [2014]); // undefined
    ```
  
    @method tryInvoke
    @for Ember
    @param {Object} obj The object to check for the method
    @param {String} methodName The method name to check for
    @param {Array} [args] The arguments to pass to the method
    @return {*} the return value of the invoked method or undefined if it cannot be invoked
    @public
  */

  function tryInvoke(obj, methodName, args) {
    if (canInvoke(obj, methodName)) {
      return args ? _emberUtilsApplyStr.default(obj, methodName, args) : _emberUtilsApplyStr.default(obj, methodName);
    }
  }
});
enifed("ember-utils/lookup-descriptor", ["exports"], function (exports) {
  "use strict";

  exports.default = lookupDescriptor;

  function lookupDescriptor(obj, keyName) {
    var current = obj;
    while (current) {
      var descriptor = Object.getOwnPropertyDescriptor(current, keyName);

      if (descriptor) {
        return descriptor;
      }

      current = Object.getPrototypeOf(current);
    }

    return null;
  }
});
enifed("ember-utils/make-array", ["exports"], function (exports) {
  /**
   Forces the passed object to be part of an array. If the object is already
   an array, it will return the object. Otherwise, it will add the object to
   an array. If obj is `null` or `undefined`, it will return an empty array.
  
   ```javascript
   Ember.makeArray();            // []
   Ember.makeArray(null);        // []
   Ember.makeArray(undefined);   // []
   Ember.makeArray('lindsay');   // ['lindsay']
   Ember.makeArray([1, 2, 42]);  // [1, 2, 42]
  
   let controller = Ember.ArrayProxy.create({ content: [] });
  
   Ember.makeArray(controller) === controller;  // true
   ```
  
   @method makeArray
   @for Ember
   @param {Object} obj the object
   @return {Array}
   @private
   */
  "use strict";

  exports.default = makeArray;

  function makeArray(obj) {
    if (obj === null || obj === undefined) {
      return [];
    }
    return Array.isArray(obj) ? obj : [obj];
  }
});
enifed('ember-utils/owner', ['exports', 'ember-utils/symbol'], function (exports, _emberUtilsSymbol) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  exports.getOwner = getOwner;
  exports.setOwner = setOwner;
  var OWNER = _emberUtilsSymbol.default('OWNER');

  exports.OWNER = OWNER;
  /**
    Framework objects in an Ember application (components, services, routes, etc.)
    are created via a factory and dependency injection system. Each of these
    objects is the responsibility of an "owner", which handled its
    instantiation and manages its lifetime.
  
    `getOwner` fetches the owner object responsible for an instance. This can
    be used to lookup or resolve other class instances, or register new factories
    into the owner.
  
    For example, this component dynamically looks up a service based on the
    `audioType` passed as an attribute:
  
    ```
    // app/components/play-audio.js
    import Ember from 'ember';
  
    // Usage:
    //
    //   {{play-audio audioType=model.audioType audioFile=model.file}}
    //
    export default Ember.Component.extend({
      audioService: Ember.computed('audioType', function() {
        let owner = Ember.getOwner(this);
        return owner.lookup(`service:${this.get('audioType')}`);
      }),
      click() {
        let player = this.get('audioService');
        player.play(this.get('audioFile'));
      }
    });
    ```
  
    @method getOwner
    @for Ember
    @param {Object} object An object with an owner.
    @return {Object} An owner object.
    @since 2.3.0
    @public
  */

  function getOwner(object) {
    return object[OWNER];
  }

  /**
    `setOwner` forces a new owner on a given object instance. This is primarily
    useful in some testing cases.
  
    @method setOwner
    @for Ember
    @param {Object} object An object with an owner.
    @return {Object} An owner object.
    @since 2.3.0
    @public
  */

  function setOwner(object, owner) {
    object[OWNER] = owner;
  }
});
enifed('ember-utils/super', ['exports'], function (exports) {
  'use strict';

  exports.wrap = wrap;
  var HAS_SUPER_PATTERN = /\.(_super|call\(this|apply\(this)/;
  var fnToString = Function.prototype.toString;

  var checkHasSuper = (function () {
    var sourceAvailable = fnToString.call(function () {
      return this;
    }).indexOf('return this') > -1;

    if (sourceAvailable) {
      return function checkHasSuper(func) {
        return HAS_SUPER_PATTERN.test(fnToString.call(func));
      };
    }

    return function checkHasSuper() {
      return true;
    };
  })();

  exports.checkHasSuper = checkHasSuper;
  function ROOT() {}
  ROOT.__hasSuper = false;

  function hasSuper(func) {
    if (func.__hasSuper === undefined) {
      func.__hasSuper = checkHasSuper(func);
    }
    return func.__hasSuper;
  }

  /**
    Wraps the passed function so that `this._super` will point to the superFunc
    when the function is invoked. This is the primitive we use to implement
    calls to super.
  
    @private
    @method wrap
    @for Ember
    @param {Function} func The function to call
    @param {Function} superFunc The super function.
    @return {Function} wrapped function.
  */

  function wrap(func, superFunc) {
    if (!hasSuper(func)) {
      return func;
    }
    // ensure an unwrapped super that calls _super is wrapped with a terminal _super
    if (!superFunc.wrappedFunction && hasSuper(superFunc)) {
      return _wrap(func, _wrap(superFunc, ROOT));
    }
    return _wrap(func, superFunc);
  }

  function _wrap(func, superFunc) {
    function superWrapper() {
      var orig = this._super;
      this._super = superFunc;
      var ret = func.apply(this, arguments);
      this._super = orig;
      return ret;
    }

    superWrapper.wrappedFunction = func;
    superWrapper.__ember_observes__ = func.__ember_observes__;
    superWrapper.__ember_observesBefore__ = func.__ember_observesBefore__;
    superWrapper.__ember_listens__ = func.__ember_listens__;

    return superWrapper;
  }
});
enifed('ember-utils/symbol', ['exports', 'ember-utils/guid', 'ember-utils/intern'], function (exports, _emberUtilsGuid, _emberUtilsIntern) {
  'use strict';

  exports.default = symbol;

  function symbol(debugName) {
    // TODO: Investigate using platform symbols, but we do not
    // want to require non-enumerability for this API, which
    // would introduce a large cost.

    return _emberUtilsIntern.default(debugName + ' [id=' + _emberUtilsGuid.GUID_KEY + Math.floor(Math.random() * new Date()) + ']');
  }
});
enifed("ember-utils/to-string", ["exports"], function (exports) {
  "use strict";

  exports.default = toString;
  var objectToString = Object.prototype.toString;

  /*
   A `toString` util function that supports objects without a `toString`
   method, e.g. an object created with `Object.create(null)`.
  */

  function toString(obj) {
    if (obj && obj.toString) {
      return obj.toString();
    } else {
      return objectToString.call(obj);
    }
  }
});
enifed("ember/features", ["exports"], function (exports) {
  "use strict";

  exports.default = { "features-stripped-test": false, "ember-libraries-isregistered": false, "ember-runtime-computed-uniq-by": true, "ember-improved-instrumentation": false, "ember-runtime-enumerable-includes": true, "ember-string-ishtmlsafe": true, "ember-testing-check-waiters": true, "ember-metal-weakmap": false, "ember-glimmer-allow-backtracking-rerender": false, "ember-testing-resume-test": false, "mandatory-setter": true, "ember-glimmer-detect-backtracking-rerender": true };
});
enifed("ember/version", ["exports"], function (exports) {
  "use strict";

  exports.default = "2.10.0-beta.3";
});
enifed("glimmer-compiler/index", ["exports", "glimmer-compiler/lib/compiler", "glimmer-compiler/lib/template-visitor"], function (exports, _glimmerCompilerLibCompiler, _glimmerCompilerLibTemplateVisitor) {
  "use strict";

  exports.precompile = _glimmerCompilerLibCompiler.precompile;
  exports.PrecompileOptions = _glimmerCompilerLibCompiler.PrecompileOptions;

  // exported only for tests
  exports.TemplateVisitor = _glimmerCompilerLibTemplateVisitor.default;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItY29tcGlsZXIvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O1VBQ0UsVUFBVSwrQkFBVixVQUFVO1VBQUUsaUJBQWlCLCtCQUFqQixpQkFBaUI7OztVQUlYLGVBQWUsc0NBQTFCLE9BQU8iLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQge1xuICBwcmVjb21waWxlLCBQcmVjb21waWxlT3B0aW9uc1xufSBmcm9tIFwiLi9saWIvY29tcGlsZXJcIjtcblxuLy8gZXhwb3J0ZWQgb25seSBmb3IgdGVzdHNcbmV4cG9ydCB7IGRlZmF1bHQgYXMgVGVtcGxhdGVWaXNpdG9yIH0gZnJvbSAnLi9saWIvdGVtcGxhdGUtdmlzaXRvcic7XG4iXX0=
enifed("glimmer-compiler/lib/compiler", ["exports", "glimmer-syntax", "glimmer-compiler/lib/template-compiler"], function (exports, _glimmerSyntax, _glimmerCompilerLibTemplateCompiler) {
    "use strict";

    exports.precompile = precompile;

    var defaultId = (function () {
        var idFn = undefined;
        return function () {
            if (!idFn) {
                if (typeof require === 'function') {
                    try {
                        (function () {
                            /* tslint:disable:no-require-imports */
                            var crypto = require('crypto');
                            /* tslint:enable:no-require-imports */
                            idFn = function (src) {
                                var hash = crypto.createHash('sha1');
                                hash.update(src, 'utf8');
                                // trim to 6 bytes of data (2^48 - 1)
                                return hash.digest('base64').substring(0, 8);
                            };
                            idFn("test");
                        })();
                    } catch (e) {
                        idFn = null;
                    }
                }
                if (!idFn) {
                    idFn = function () {
                        return null;
                    };
                }
            }
            return idFn;
        };
    })();

    function precompile(string, options) {
        var opts = options || {
            id: defaultId(),
            meta: {}
        };
        var ast = _glimmerSyntax.preprocess(string, opts);

        var _TemplateCompiler$compile = _glimmerCompilerLibTemplateCompiler.default.compile(opts, ast);

        var block = _TemplateCompiler$compile.block;
        var meta = _TemplateCompiler$compile.meta;

        var idFn = opts.id || defaultId();
        var blockJSON = JSON.stringify(block.toJSON());
        var templateJSONObject = {
            id: idFn(JSON.stringify(meta) + blockJSON),
            block: blockJSON,
            meta: meta
        };
        // JSON is javascript
        return JSON.stringify(templateJSONObject);
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed("glimmer-compiler/lib/javascript-compiler", ["exports", "glimmer-util"], function (exports, _glimmerUtil) {
    "use strict";

    var Block = (function () {
        function Block() {
            this.statements = [];
            this.positionals = [];
        }

        Block.prototype.toJSON = function toJSON() {
            return {
                statements: this.statements,
                locals: this.positionals
            };
        };

        Block.prototype.push = function push(statement) {
            this.statements.push(statement);
        };

        return Block;
    })();

    exports.Block = Block;

    var TemplateBlock = (function (_Block) {
        babelHelpers.inherits(TemplateBlock, _Block);

        function TemplateBlock() {
            _Block.apply(this, arguments);
            this.yields = new _glimmerUtil.DictSet();
            this.named = new _glimmerUtil.DictSet();
            this.blocks = [];
            this.hasPartials = false;
        }

        TemplateBlock.prototype.toJSON = function toJSON() {
            return {
                statements: this.statements,
                locals: this.positionals,
                named: this.named.toArray(),
                yields: this.yields.toArray(),
                blocks: this.blocks.map(function (b) {
                    return b.toJSON();
                }),
                hasPartials: this.hasPartials
            };
        };

        return TemplateBlock;
    })(Block);

    exports.TemplateBlock = TemplateBlock;

    var Template = (function () {
        function Template(meta) {
            this.meta = meta;
            this.block = new TemplateBlock();
        }

        Template.prototype.toJSON = function toJSON() {
            return {
                block: this.block.toJSON(),
                meta: this.meta
            };
        };

        return Template;
    })();

    exports.Template = Template;

    var JavaScriptCompiler = (function () {
        function JavaScriptCompiler(opcodes, meta) {
            this.blocks = new _glimmerUtil.Stack();
            this.values = [];
            this.opcodes = opcodes;
            this.template = new Template(meta);
        }

        JavaScriptCompiler.process = function process(opcodes, meta) {
            var compiler = new JavaScriptCompiler(opcodes, meta);
            return compiler.process();
        };

        JavaScriptCompiler.prototype.process = function process() {
            var _this = this;

            this.opcodes.forEach(function (_ref) {
                var opcode = _ref[0];

                var args = _ref.slice(1);

                if (!_this[opcode]) {
                    throw new Error("unimplemented " + opcode + " on JavaScriptCompiler");
                }
                _this[opcode].apply(_this, args);
            });
            return this.template;
        };

        /// Nesting

        JavaScriptCompiler.prototype.startBlock = function startBlock(_ref2) {
            var program = _ref2[0];

            var block = new Block();
            block.positionals = program.blockParams;
            this.blocks.push(block);
        };

        JavaScriptCompiler.prototype.endBlock = function endBlock() {
            var template = this.template;
            var blocks = this.blocks;

            template.block.blocks.push(blocks.pop());
        };

        JavaScriptCompiler.prototype.startProgram = function startProgram() {
            this.blocks.push(this.template.block);
        };

        JavaScriptCompiler.prototype.endProgram = function endProgram() {};

        /// Statements

        JavaScriptCompiler.prototype.text = function text(content) {
            this.push(['text', content]);
        };

        JavaScriptCompiler.prototype.append = function append(trusted) {
            this.push(['append', this.popValue(), trusted]);
        };

        JavaScriptCompiler.prototype.comment = function comment(value) {
            this.push(['comment', value]);
        };

        JavaScriptCompiler.prototype.modifier = function modifier(path) {
            var params = this.popValue();
            var hash = this.popValue();
            this.push(['modifier', path, params, hash]);
        };

        JavaScriptCompiler.prototype.block = function block(path, template, inverse) {
            var params = this.popValue();
            var hash = this.popValue();
            this.push(['block', path, params, hash, template, inverse]);
        };

        JavaScriptCompiler.prototype.openElement = function openElement(tag, blockParams) {
            this.push(['open-element', tag, blockParams]);
        };

        JavaScriptCompiler.prototype.flushElement = function flushElement() {
            this.push(['flush-element']);
        };

        JavaScriptCompiler.prototype.closeElement = function closeElement() {
            this.push(['close-element']);
        };

        JavaScriptCompiler.prototype.staticAttr = function staticAttr(name, namespace) {
            var value = this.popValue();
            this.push(['static-attr', name, value, namespace]);
        };

        JavaScriptCompiler.prototype.dynamicAttr = function dynamicAttr(name, namespace) {
            var value = this.popValue();
            this.push(['dynamic-attr', name, value, namespace]);
        };

        JavaScriptCompiler.prototype.trustingAttr = function trustingAttr(name, namespace) {
            var value = this.popValue();
            this.push(['trusting-attr', name, value, namespace]);
        };

        JavaScriptCompiler.prototype.staticArg = function staticArg(name) {
            var value = this.popValue();
            this.push(['static-arg', name.slice(1), value]);
        };

        JavaScriptCompiler.prototype.dynamicArg = function dynamicArg(name) {
            var value = this.popValue();
            this.push(['dynamic-arg', name.slice(1), value]);
        };

        JavaScriptCompiler.prototype.yield = function _yield(to) {
            var params = this.popValue();
            this.push(['yield', to, params]);
            this.template.block.yields.add(to);
        };

        JavaScriptCompiler.prototype.hasBlock = function hasBlock(name) {
            this.pushValue(['has-block', name]);
            this.template.block.yields.add(name);
        };

        JavaScriptCompiler.prototype.hasBlockParams = function hasBlockParams(name) {
            this.pushValue(['has-block-params', name]);
            this.template.block.yields.add(name);
        };

        JavaScriptCompiler.prototype.partial = function partial() {
            var params = this.popValue();
            this.push(['partial', params[0]]);
            this.template.block.hasPartials = true;
        };

        /// Expressions

        JavaScriptCompiler.prototype.literal = function literal(value) {
            if (value === undefined) {
                this.pushValue(['undefined']);
            } else {
                this.pushValue(value);
            }
        };

        JavaScriptCompiler.prototype.unknown = function unknown(path) {
            this.pushValue(['unknown', path]);
        };

        JavaScriptCompiler.prototype.arg = function arg(path) {
            this.template.block.named.add(path[0]);
            this.pushValue(['arg', path]);
        };

        JavaScriptCompiler.prototype.get = function get(path) {
            this.pushValue(['get', path]);
        };

        JavaScriptCompiler.prototype.concat = function concat() {
            this.pushValue(['concat', this.popValue()]);
        };

        JavaScriptCompiler.prototype.helper = function helper(path) {
            var params = this.popValue();
            var hash = this.popValue();
            this.pushValue(['helper', path, params, hash]);
        };

        /// Stack Management Opcodes

        JavaScriptCompiler.prototype.prepareArray = function prepareArray(size) {
            var values = [];
            for (var i = 0; i < size; i++) {
                values.push(this.popValue());
            }
            this.pushValue(values);
        };

        JavaScriptCompiler.prototype.prepareObject = function prepareObject(size) {
            _glimmerUtil.assert(this.values.length >= size, "Expected " + size + " values on the stack, found " + this.values.length);
            var keys = new Array(size);
            var values = new Array(size);
            for (var i = 0; i < size; i++) {
                keys[i] = this.popValue();
                values[i] = this.popValue();
            }
            this.pushValue([keys, values]);
        };

        /// Utilities

        JavaScriptCompiler.prototype.push = function push(args) {
            while (args[args.length - 1] === null) {
                args.pop();
            }
            this.blocks.current.push(args);
        };

        JavaScriptCompiler.prototype.pushValue = function pushValue(val) {
            this.values.push(val);
        };

        JavaScriptCompiler.prototype.popValue = function popValue() {
            _glimmerUtil.assert(this.values.length, "No expression found on stack");
            return this.values.pop();
        };

        return JavaScriptCompiler;
    })();

    exports.default = JavaScriptCompiler;
});
//# sourceMappingURL=data:application/json;base64,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
enifed("glimmer-compiler/lib/template-compiler", ["exports", "glimmer-compiler/lib/template-visitor", "glimmer-compiler/lib/javascript-compiler", "glimmer-util"], function (exports, _glimmerCompilerLibTemplateVisitor, _glimmerCompilerLibJavascriptCompiler, _glimmerUtil) {
    "use strict";

    function isTrustedValue(value) {
        return value.escaped !== undefined && !value.escaped;
    }

    var TemplateCompiler = (function () {
        function TemplateCompiler(options) {
            this.templateId = 0;
            this.templateIds = [];
            this.symbols = null;
            this.opcodes = [];
            this.includeMeta = false;
            this.options = options || {};
        }

        TemplateCompiler.compile = function compile(options, ast) {
            var templateVisitor = new _glimmerCompilerLibTemplateVisitor.default();
            templateVisitor.visit(ast);
            var compiler = new TemplateCompiler(options);
            var opcodes = compiler.process(templateVisitor.actions);
            return _glimmerCompilerLibJavascriptCompiler.default.process(opcodes, options.meta);
        };

        TemplateCompiler.prototype.process = function process(actions) {
            var _this = this;

            actions.forEach(function (_ref) {
                var name = _ref[0];

                var args = _ref.slice(1);

                if (!_this[name]) {
                    throw new Error("Unimplemented " + name + " on TemplateCompiler");
                }
                _this[name].apply(_this, args);
            });
            return this.opcodes;
        };

        TemplateCompiler.prototype.startProgram = function startProgram(program) {
            this.opcode('startProgram', program, program);
        };

        TemplateCompiler.prototype.endProgram = function endProgram() {
            this.opcode('endProgram', null);
        };

        TemplateCompiler.prototype.startBlock = function startBlock(program) {
            this.symbols = program[0].symbols;
            this.templateId++;
            this.opcode('startBlock', program, program);
        };

        TemplateCompiler.prototype.endBlock = function endBlock() {
            this.symbols = null;
            this.templateIds.push(this.templateId - 1);
            this.opcode('endBlock', null);
        };

        TemplateCompiler.prototype.text = function text(_ref2) {
            var action = _ref2[0];

            this.opcode('text', action, action.chars);
        };

        TemplateCompiler.prototype.comment = function comment(_ref3) {
            var action = _ref3[0];

            this.opcode('comment', action, action.value);
        };

        TemplateCompiler.prototype.openElement = function openElement(_ref4) {
            var action = _ref4[0];

            this.opcode('openElement', action, action.tag, action.blockParams);
            for (var i = 0; i < action.attributes.length; i++) {
                this.attribute([action.attributes[i]]);
            }
            for (var i = 0; i < action.modifiers.length; i++) {
                this.modifier([action.modifiers[i]]);
            }
            this.opcode('flushElement', null);
        };

        TemplateCompiler.prototype.closeElement = function closeElement() {
            this.opcode('closeElement', null);
        };

        TemplateCompiler.prototype.attribute = function attribute(_ref5) {
            var action = _ref5[0];
            var name = action.name;
            var value = action.value;

            var namespace = _glimmerUtil.getAttrNamespace(name);
            var isStatic = this.prepareAttributeValue(value);
            if (name.charAt(0) === '@') {
                // Arguments
                if (isStatic) {
                    this.opcode('staticArg', action, name);
                } else if (action.value.type === 'MustacheStatement') {
                    this.opcode('dynamicArg', action, name);
                } else {
                    this.opcode('dynamicArg', action, name);
                }
            } else {
                var isTrusting = isTrustedValue(value);
                if (isStatic) {
                    this.opcode('staticAttr', action, name, namespace);
                } else if (isTrusting) {
                    this.opcode('trustingAttr', action, name, namespace);
                } else if (action.value.type === 'MustacheStatement') {
                    this.opcode('dynamicAttr', action, name);
                } else {
                    this.opcode('dynamicAttr', action, name, namespace);
                }
            }
        };

        TemplateCompiler.prototype.modifier = function modifier(_ref6) {
            var action = _ref6[0];
            var parts = action.path.parts;

            this.prepareHelper(action);
            this.opcode('modifier', action, parts);
        };

        TemplateCompiler.prototype.mustache = function mustache(_ref7) {
            var action = _ref7[0];

            if (isYield(action)) {
                var to = assertValidYield(action);
                this.yield(to, action);
            } else if (isPartial(action)) {
                var params = assertValidPartial(action);
                this.partial(params, action);
            } else {
                this.mustacheExpression(action);
                this.opcode('append', action, !action.escaped);
            }
        };

        TemplateCompiler.prototype.block = function block(_ref8) /*, index, count*/{
            var action = _ref8[0];

            this.prepareHelper(action);
            var templateId = this.templateIds.pop();
            var inverseId = action.inverse === null ? null : this.templateIds.pop();
            this.opcode('block', action, action.path.parts, templateId, inverseId);
        };

        /// Internal actions, not found in the original processed actions

        TemplateCompiler.prototype.arg = function arg(_ref9) {
            var path = _ref9[0];
            var parts = path.parts;

            this.opcode('arg', path, parts);
        };

        TemplateCompiler.prototype.mustacheExpression = function mustacheExpression(expr) {
            if (isBuiltInHelper(expr)) {
                this.builtInHelper(expr);
            } else if (isLiteral(expr)) {
                this.opcode('literal', expr, expr.path.value);
            } else if (isArg(expr)) {
                this.arg([expr.path]);
            } else if (isHelperInvocation(expr)) {
                this.prepareHelper(expr);
                this.opcode('helper', expr, expr.path.parts);
            } else if (isLocalVariable(expr, this.symbols)) {
                this.opcode('get', expr, expr.path.parts);
            } else {
                this.opcode('unknown', expr, expr.path.parts);
            }
        };

        /// Internal Syntax

        TemplateCompiler.prototype.yield = function _yield(to, action) {
            this.prepareParams(action.params);
            this.opcode('yield', action, to);
        };

        TemplateCompiler.prototype.hasBlock = function hasBlock(name, action) {
            this.opcode('hasBlock', action, name);
        };

        TemplateCompiler.prototype.hasBlockParams = function hasBlockParams(name, action) {
            this.opcode('hasBlockParams', action, name);
        };

        TemplateCompiler.prototype.partial = function partial(params, action) {
            this.prepareParams(action.params);
            this.opcode('partial', action);
        };

        TemplateCompiler.prototype.builtInHelper = function builtInHelper(expr) {
            if (isHasBlock(expr)) {
                var _name = assertValidHasBlockUsage(expr.path.original, expr);
                this.hasBlock(_name, expr);
            } else if (isHasBlockParams(expr)) {
                var _name2 = assertValidHasBlockUsage(expr.path.original, expr);
                this.hasBlockParams(_name2, expr);
            }
        };

        /// Expressions, invoked recursively from prepareParams and prepareHash

        TemplateCompiler.prototype.SubExpression = function SubExpression(expr) {
            if (isBuiltInHelper(expr)) {
                this.builtInHelper(expr);
            } else {
                this.prepareHelper(expr);
                this.opcode('helper', expr, expr.path.parts);
            }
        };

        TemplateCompiler.prototype.PathExpression = function PathExpression(expr) {
            if (expr.data) {
                this.arg([expr]);
            } else {
                this.opcode('get', expr, expr.parts);
            }
        };

        TemplateCompiler.prototype.StringLiteral = function StringLiteral(action) {
            this.opcode('literal', null, action.value);
        };

        TemplateCompiler.prototype.BooleanLiteral = function BooleanLiteral(action) {
            this.opcode('literal', null, action.value);
        };

        TemplateCompiler.prototype.NumberLiteral = function NumberLiteral(action) {
            this.opcode('literal', null, action.value);
        };

        TemplateCompiler.prototype.NullLiteral = function NullLiteral(action) {
            this.opcode('literal', null, action.value);
        };

        TemplateCompiler.prototype.UndefinedLiteral = function UndefinedLiteral(action) {
            this.opcode('literal', null, action.value);
        };

        /// Utilities

        TemplateCompiler.prototype.opcode = function opcode(name, action) {
            for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
                args[_key - 2] = arguments[_key];
            }

            var opcode = [name].concat(args);
            if (this.includeMeta && action) {
                opcode.push(this.meta(action));
            }
            this.opcodes.push(opcode);
        };

        TemplateCompiler.prototype.prepareHelper = function prepareHelper(_ref10) {
            var params = _ref10.params;
            var hash = _ref10.hash;

            this.prepareHash(hash);
            this.prepareParams(params);
        };

        TemplateCompiler.prototype.preparePath = function preparePath(path) {
            this.opcode('literal', path, path.parts);
        };

        TemplateCompiler.prototype.prepareParams = function prepareParams(params) {
            if (!params.length) {
                this.opcode('literal', null, null);
                return;
            }
            for (var i = params.length - 1; i >= 0; i--) {
                var param = params[i];
                _glimmerUtil.assert(this[param.type], "Unimplemented " + param.type + " on TemplateCompiler");
                this[param.type](param);
            }
            this.opcode('prepareArray', null, params.length);
        };

        TemplateCompiler.prototype.prepareHash = function prepareHash(hash) {
            var pairs = hash.pairs;
            if (!pairs.length) {
                this.opcode('literal', null, null);
                return;
            }
            for (var i = pairs.length - 1; i >= 0; i--) {
                var _pairs$i = pairs[i];
                var key = _pairs$i.key;
                var value = _pairs$i.value;

                _glimmerUtil.assert(this[value.type], "Unimplemented " + value.type + " on TemplateCompiler");
                this[value.type](value);
                this.opcode('literal', null, key);
            }
            this.opcode('prepareObject', null, pairs.length);
        };

        TemplateCompiler.prototype.prepareAttributeValue = function prepareAttributeValue(value) {
            // returns the static value if the value is static
            switch (value.type) {
                case 'TextNode':
                    this.opcode('literal', value, value.chars);
                    return true;
                case 'MustacheStatement':
                    this.attributeMustache([value]);
                    return false;
                case 'ConcatStatement':
                    this.prepareConcatParts(value.parts);
                    this.opcode('concat', value);
                    return false;
            }
        };

        TemplateCompiler.prototype.prepareConcatParts = function prepareConcatParts(parts) {
            for (var i = parts.length - 1; i >= 0; i--) {
                var part = parts[i];
                if (part.type === 'MustacheStatement') {
                    this.attributeMustache([part]);
                } else if (part.type === 'TextNode') {
                    this.opcode('literal', null, part.chars);
                }
            }
            this.opcode('prepareArray', null, parts.length);
        };

        TemplateCompiler.prototype.attributeMustache = function attributeMustache(_ref11) {
            var action = _ref11[0];

            this.mustacheExpression(action);
        };

        TemplateCompiler.prototype.meta = function meta(node) {
            var loc = node.loc;
            if (!loc) {
                return [];
            }
            var source = loc.source;
            var start = loc.start;
            var end = loc.end;

            return ['loc', [source || null, [start.line, start.column], [end.line, end.column]]];
        };

        return TemplateCompiler;
    })();

    exports.default = TemplateCompiler;

    function isHelperInvocation(mustache) {
        return mustache.params && mustache.params.length > 0 || mustache.hash && mustache.hash.pairs.length > 0;
    }
    function isLocalVariable(mustache, symbols) {
        var parts = mustache.path.parts;

        return parts.length === 1 && symbols && symbols.hasLocalVariable(parts[0]);
    }
    function isYield(_ref12) {
        var path = _ref12.path;

        return path.original === 'yield';
    }
    function isPartial(_ref13) {
        var path = _ref13.path;

        return path.original === 'partial';
    }
    function isArg(_ref14) {
        var path = _ref14.path;

        return path.data;
    }
    function isLiteral(_ref15) {
        var path = _ref15.path;

        return path.type === 'StringLiteral' || path.type === 'BooleanLiteral' || path.type === 'NumberLiteral' || path.type === 'NullLiteral' || path.type === 'UndefinedLiteral';
    }
    function isHasBlock(_ref16) {
        var path = _ref16.path;

        return path.original === 'has-block';
    }
    function isHasBlockParams(_ref17) {
        var path = _ref17.path;

        return path.original === 'has-block-params';
    }
    function isBuiltInHelper(expr) {
        return isHasBlock(expr) || isHasBlockParams(expr);
    }
    function assertValidYield(_ref18) {
        var hash = _ref18.hash;

        var pairs = hash.pairs;
        if (pairs.length === 1 && pairs[0].key !== 'to' || pairs.length > 1) {
            throw new Error("yield only takes a single named argument: 'to'");
        } else if (pairs.length === 1 && pairs[0].value.type !== 'StringLiteral') {
            throw new Error("you can only yield to a literal value");
        } else if (pairs.length === 0) {
            return 'default';
        } else {
            return pairs[0].value.value;
        }
    }
    function assertValidPartial(_ref19) {
        var params = _ref19.params;
        var hash = _ref19.hash;
        var escaped = _ref19.escaped;
        var loc = _ref19.loc;

        if (params && params.length !== 1) {
            throw new Error("Partial found with no arguments. You must specify a template name. (on line " + loc.start.line + ")");
        } else if (hash && hash.pairs.length > 0) {
            throw new Error("partial does not take any named arguments (on line " + loc.start.line + ")");
        } else if (!escaped) {
            throw new Error("{{{partial ...}}} is not supported, please use {{partial ...}} instead (on line " + loc.start.line + ")");
        }
        return params;
    }
    function assertValidHasBlockUsage(type, _ref20) {
        var params = _ref20.params;
        var hash = _ref20.hash;
        var loc = _ref20.loc;

        if (hash && hash.pairs.length > 0) {
            throw new Error(type + " does not take any named arguments");
        }
        if (params.length === 0) {
            return 'default';
        } else if (params.length === 1) {
            if (params[0].type === 'StringLiteral') {
                return params[0].value;
            } else {
                throw new Error("you can only yield to a literal value (on line " + loc.start.line + ")");
            }
        } else {
            throw new Error(type + " only takes a single positional argument (on line " + loc.start.line + ")");
        }
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-compiler/lib/template-visitor', ['exports'], function (exports) {
    'use strict';

    var push = Array.prototype.push;

    var Frame = function Frame() {
        this.parentNode = null;
        this.children = null;
        this.childIndex = null;
        this.childCount = null;
        this.childTemplateCount = 0;
        this.mustacheCount = 0;
        this.actions = [];
        this.blankChildTextNodes = null;
        this.symbols = null;
    };

    var SymbolTable = (function () {
        function SymbolTable(symbols) {
            var parent = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

            this.symbols = symbols;
            this.parent = parent;
        }

        /**
         * Takes in an AST and outputs a list of actions to be consumed
         * by a compiler. For example, the template
         *
         *     foo{{bar}}<div>baz</div>
         *
         * produces the actions
         *
         *     [['startProgram', [programNode, 0]],
         *      ['text', [textNode, 0, 3]],
         *      ['mustache', [mustacheNode, 1, 3]],
         *      ['openElement', [elementNode, 2, 3, 0]],
         *      ['text', [textNode, 0, 1]],
         *      ['closeElement', [elementNode, 2, 3],
         *      ['endProgram', [programNode]]]
         *
         * This visitor walks the AST depth first and backwards. As
         * a result the bottom-most child template will appear at the
         * top of the actions list whereas the root template will appear
         * at the bottom of the list. For example,
         *
         *     <div>{{#if}}foo{{else}}bar<b></b>{{/if}}</div>
         *
         * produces the actions
         *
         *     [['startProgram', [programNode, 0]],
         *      ['text', [textNode, 0, 2, 0]],
         *      ['openElement', [elementNode, 1, 2, 0]],
         *      ['closeElement', [elementNode, 1, 2]],
         *      ['endProgram', [programNode]],
         *      ['startProgram', [programNode, 0]],
         *      ['text', [textNode, 0, 1]],
         *      ['endProgram', [programNode]],
         *      ['startProgram', [programNode, 2]],
         *      ['openElement', [elementNode, 0, 1, 1]],
         *      ['block', [blockNode, 0, 1]],
         *      ['closeElement', [elementNode, 0, 1]],
         *      ['endProgram', [programNode]]]
         *
         * The state of the traversal is maintained by a stack of frames.
         * Whenever a node with children is entered (either a ProgramNode
         * or an ElementNode) a frame is pushed onto the stack. The frame
         * contains information about the state of the traversal of that
         * node. For example,
         *
         *   - index of the current child node being visited
         *   - the number of mustaches contained within its child nodes
         *   - the list of actions generated by its child nodes
         */

        SymbolTable.prototype.hasLocalVariable = function hasLocalVariable(name) {
            var symbols = this.symbols;
            var parent = this.parent;

            return symbols.indexOf(name) >= 0 || parent && parent.hasLocalVariable(name);
        };

        return SymbolTable;
    })();

    exports.SymbolTable = SymbolTable;
    function TemplateVisitor() {
        this.frameStack = [];
        this.actions = [];
        this.programDepth = -1;
    }
    // Traversal methods
    TemplateVisitor.prototype.visit = function (node) {
        this[node.type](node);
    };
    TemplateVisitor.prototype.Program = function (program) {
        this.programDepth++;
        var parentFrame = this.getCurrentFrame();
        var programFrame = this.pushFrame();
        if (parentFrame) {
            program.symbols = new SymbolTable(program.blockParams, parentFrame.symbols);
        } else {
            program.symbols = new SymbolTable(program.blockParams);
        }
        var startType = undefined,
            endType = undefined;
        if (this.programDepth === 0) {
            startType = 'startProgram';
            endType = 'endProgram';
        } else {
            startType = 'startBlock';
            endType = 'endBlock';
        }
        programFrame.parentNode = program;
        programFrame.children = program.body;
        programFrame.childCount = program.body.length;
        programFrame.blankChildTextNodes = [];
        programFrame.actions.push([endType, [program, this.programDepth]]);
        programFrame.symbols = program.symbols;
        for (var i = program.body.length - 1; i >= 0; i--) {
            programFrame.childIndex = i;
            this.visit(program.body[i]);
        }
        programFrame.actions.push([startType, [program, programFrame.childTemplateCount, programFrame.blankChildTextNodes.reverse()]]);
        this.popFrame();
        this.programDepth--;
        // Push the completed template into the global actions list
        if (parentFrame) {
            parentFrame.childTemplateCount++;
        }
        push.apply(this.actions, programFrame.actions.reverse());
    };
    TemplateVisitor.prototype.ElementNode = function (element) {
        var parentFrame = this.getCurrentFrame();
        var elementFrame = this.pushFrame();
        elementFrame.parentNode = element;
        elementFrame.children = element.children;
        elementFrame.childCount = element.children.length;
        elementFrame.mustacheCount += element.modifiers.length;
        elementFrame.blankChildTextNodes = [];
        elementFrame.symbols = parentFrame.symbols;
        var actionArgs = [element, parentFrame.childIndex, parentFrame.childCount];
        elementFrame.actions.push(['closeElement', actionArgs]);
        for (var i = element.attributes.length - 1; i >= 0; i--) {
            this.visit(element.attributes[i]);
        }
        for (var i = element.children.length - 1; i >= 0; i--) {
            elementFrame.childIndex = i;
            this.visit(element.children[i]);
        }
        elementFrame.actions.push(['openElement', actionArgs.concat([elementFrame.mustacheCount, elementFrame.blankChildTextNodes.reverse()])]);
        this.popFrame();
        // Propagate the element's frame state to the parent frame
        if (elementFrame.mustacheCount > 0) {
            parentFrame.mustacheCount++;
        }
        parentFrame.childTemplateCount += elementFrame.childTemplateCount;
        push.apply(parentFrame.actions, elementFrame.actions);
    };
    TemplateVisitor.prototype.AttrNode = function (attr) {
        if (attr.value.type !== 'TextNode') {
            this.getCurrentFrame().mustacheCount++;
        }
    };
    TemplateVisitor.prototype.TextNode = function (text) {
        var frame = this.getCurrentFrame();
        if (text.chars === '') {
            frame.blankChildTextNodes.push(domIndexOf(frame.children, text));
        }
        frame.actions.push(['text', [text, frame.childIndex, frame.childCount]]);
    };
    TemplateVisitor.prototype.BlockStatement = function (node) {
        var frame = this.getCurrentFrame();
        frame.mustacheCount++;
        frame.actions.push(['block', [node, frame.childIndex, frame.childCount]]);
        if (node.inverse) {
            this.visit(node.inverse);
        }
        if (node.program) {
            this.visit(node.program);
        }
    };
    TemplateVisitor.prototype.PartialStatement = function (node) {
        var frame = this.getCurrentFrame();
        frame.mustacheCount++;
        frame.actions.push(['mustache', [node, frame.childIndex, frame.childCount]]);
    };
    TemplateVisitor.prototype.CommentStatement = function (text) {
        var frame = this.getCurrentFrame();
        frame.actions.push(['comment', [text, frame.childIndex, frame.childCount]]);
    };
    TemplateVisitor.prototype.MustacheStatement = function (mustache) {
        var frame = this.getCurrentFrame();
        frame.mustacheCount++;
        frame.actions.push(['mustache', [mustache, frame.childIndex, frame.childCount]]);
    };
    // Frame helpers
    TemplateVisitor.prototype.getCurrentFrame = function () {
        return this.frameStack[this.frameStack.length - 1];
    };
    TemplateVisitor.prototype.pushFrame = function () {
        var frame = new Frame();
        this.frameStack.push(frame);
        return frame;
    };
    TemplateVisitor.prototype.popFrame = function () {
        return this.frameStack.pop();
    };
    exports.default = TemplateVisitor;

    // Returns the index of `domNode` in the `nodes` array, skipping
    // over any nodes which do not represent DOM nodes.
    function domIndexOf(nodes, domNode) {
        var index = -1;
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            if (node.type !== 'TextNode' && node.type !== 'ElementNode') {
                continue;
            } else {
                index++;
            }
            if (node === domNode) {
                return index;
            }
        }
        return -1;
    }
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItY29tcGlsZXIvbGliL3RlbXBsYXRlLXZpc2l0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsUUFBSSxJQUFJLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUM7O1FBRWhDLEtBQUEsR0FBQSxTQUFBLEtBQUEsR0FBQTtBQUNTLFlBQUEsQ0FBQSxVQUFVLEdBQVcsSUFBSSxDQUFDO0FBQzFCLFlBQUEsQ0FBQSxRQUFRLEdBQVcsSUFBSSxDQUFDO0FBQ3hCLFlBQUEsQ0FBQSxVQUFVLEdBQVcsSUFBSSxDQUFDO0FBQzFCLFlBQUEsQ0FBQSxVQUFVLEdBQVcsSUFBSSxDQUFDO0FBQzFCLFlBQUEsQ0FBQSxrQkFBa0IsR0FBVyxDQUFDLENBQUM7QUFDL0IsWUFBQSxDQUFBLGFBQWEsR0FBVyxDQUFDLENBQUM7QUFDMUIsWUFBQSxDQUFBLE9BQU8sR0FBVSxFQUFFLENBQUM7QUFDcEIsWUFBQSxDQUFBLG1CQUFtQixHQUFhLElBQUksQ0FBQztBQUNyQyxZQUFBLENBQUEsT0FBTyxHQUFnQixJQUFJLENBQUM7S0FDcEM7O1FBRUQsV0FBQTtBQUNFLGlCQURGLFdBQUEsQ0FFWSxPQUFpQixFQUNTO2dCQUExQixNQUFNLHlEQUFnQixJQUFJOztBQUQxQixnQkFBQSxDQUFBLE9BQU8sR0FBUCxPQUFPLENBQVU7QUFDakIsZ0JBQUEsQ0FBQSxNQUFNLEdBQU4sTUFBTSxDQUFvQjtTQUNoQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUpOLG1CQUFBLFdBTUUsZ0JBQWdCLEdBQUEsMEJBQUMsSUFBWSxFQUFBO2dCQUNyQixPQUFPLEdBQWEsSUFBSSxDQUF4QixPQUFPO2dCQUFFLE1BQU0sR0FBSyxJQUFJLENBQWYsTUFBTTs7QUFDckIsbUJBQU8sT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUssTUFBTSxJQUFJLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsQUFBQyxDQUFDO1NBQ2hGOztlQVRILFdBQUE7Ozs7QUE4REEsYUFBQSxlQUFBLEdBQUE7QUFDRSxZQUFJLENBQUMsVUFBVSxHQUFHLEVBQUUsQ0FBQztBQUNyQixZQUFJLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztBQUNsQixZQUFJLENBQUMsWUFBWSxHQUFHLENBQUMsQ0FBQyxDQUFDO0tBQ3hCOztBQUlELG1CQUFlLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxVQUFTLElBQUksRUFBQTtBQUM3QyxZQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ3ZCLENBQUM7QUFFRixtQkFBZSxDQUFDLFNBQVMsQ0FBQyxPQUFPLEdBQUcsVUFBUyxPQUFPLEVBQUE7QUFDbEQsWUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO0FBRXBCLFlBQUksV0FBVyxHQUFHLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUN6QyxZQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7QUFFcEMsWUFBSSxXQUFXLEVBQUU7QUFDZixtQkFBTyxDQUFDLE9BQU8sR0FBRyxJQUFJLFdBQVcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQztTQUM3RSxNQUFNO0FBQ0wsbUJBQU8sQ0FBQyxPQUFPLEdBQUcsSUFBSSxXQUFXLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1NBQ3hEO0FBRUQsWUFBSSxTQUFTLFlBQUE7WUFBRSxPQUFPLFlBQUEsQ0FBQztBQUV2QixZQUFJLElBQUksQ0FBQyxZQUFZLEtBQUssQ0FBQyxFQUFFO0FBQzNCLHFCQUFTLEdBQUcsY0FBYyxDQUFDO0FBQzNCLG1CQUFPLEdBQUcsWUFBWSxDQUFDO1NBQ3hCLE1BQU07QUFDTCxxQkFBUyxHQUFHLFlBQVksQ0FBQztBQUN6QixtQkFBTyxHQUFHLFVBQVUsQ0FBQztTQUN0QjtBQUVELG9CQUFZLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQztBQUNsQyxvQkFBWSxDQUFDLFFBQVEsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDO0FBQ3JDLG9CQUFZLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO0FBQzlDLG9CQUFZLENBQUMsbUJBQW1CLEdBQUcsRUFBRSxDQUFDO0FBQ3RDLG9CQUFZLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ25FLG9CQUFZLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUM7QUFFdkMsYUFBSyxJQUFJLENBQUMsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtBQUNqRCx3QkFBWSxDQUFDLFVBQVUsR0FBRyxDQUFDLENBQUM7QUFDNUIsZ0JBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQzdCO0FBRUQsb0JBQVksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxFQUFFLENBQ3BDLE9BQU8sRUFBRSxZQUFZLENBQUMsa0JBQWtCLEVBQ3hDLFlBQVksQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsQ0FDM0MsQ0FBQyxDQUFDLENBQUM7QUFDSixZQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7QUFFaEIsWUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDOztBQUdwQixZQUFJLFdBQVcsRUFBRTtBQUFFLHVCQUFXLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztTQUFFO0FBQ3RELFlBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxZQUFZLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7S0FDMUQsQ0FBQztBQUVGLG1CQUFlLENBQUMsU0FBUyxDQUFDLFdBQVcsR0FBRyxVQUFTLE9BQU8sRUFBQTtBQUN0RCxZQUFJLFdBQVcsR0FBRyxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7QUFDekMsWUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO0FBRXBDLG9CQUFZLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQztBQUNsQyxvQkFBWSxDQUFDLFFBQVEsR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDO0FBQ3pDLG9CQUFZLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDO0FBQ2xELG9CQUFZLENBQUMsYUFBYSxJQUFJLE9BQU8sQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDO0FBQ3ZELG9CQUFZLENBQUMsbUJBQW1CLEdBQUcsRUFBRSxDQUFDO0FBQ3RDLG9CQUFZLENBQUMsT0FBTyxHQUFHLFdBQVcsQ0FBQyxPQUFPLENBQUM7QUFFM0MsWUFBSSxVQUFVLEdBQUcsQ0FDZixPQUFPLEVBQ1AsV0FBVyxDQUFDLFVBQVUsRUFDdEIsV0FBVyxDQUFDLFVBQVUsQ0FDdkIsQ0FBQztBQUVGLG9CQUFZLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLGNBQWMsRUFBRSxVQUFVLENBQUMsQ0FBQyxDQUFDO0FBRXhELGFBQUssSUFBSSxDQUFDLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUU7QUFDdkQsZ0JBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ25DO0FBRUQsYUFBSyxJQUFJLENBQUMsR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtBQUNyRCx3QkFBWSxDQUFDLFVBQVUsR0FBRyxDQUFDLENBQUM7QUFDNUIsZ0JBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ2pDO0FBRUQsb0JBQVksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsYUFBYSxFQUFFLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FDMUQsWUFBWSxDQUFDLGFBQWEsRUFBRSxZQUFZLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLENBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUM5RSxZQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7O0FBR2hCLFlBQUksWUFBWSxDQUFDLGFBQWEsR0FBRyxDQUFDLEVBQUU7QUFBRSx1QkFBVyxDQUFDLGFBQWEsRUFBRSxDQUFDO1NBQUU7QUFDcEUsbUJBQVcsQ0FBQyxrQkFBa0IsSUFBSSxZQUFZLENBQUMsa0JBQWtCLENBQUM7QUFDbEUsWUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsT0FBTyxFQUFFLFlBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUN2RCxDQUFDO0FBRUYsbUJBQWUsQ0FBQyxTQUFTLENBQUMsUUFBUSxHQUFHLFVBQVMsSUFBSSxFQUFBO0FBQ2hELFlBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssVUFBVSxFQUFFO0FBQ2xDLGdCQUFJLENBQUMsZUFBZSxFQUFFLENBQUMsYUFBYSxFQUFFLENBQUM7U0FDeEM7S0FDRixDQUFDO0FBRUYsbUJBQWUsQ0FBQyxTQUFTLENBQUMsUUFBUSxHQUFHLFVBQVMsSUFBSSxFQUFBO0FBQ2hELFlBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUNuQyxZQUFJLElBQUksQ0FBQyxLQUFLLEtBQUssRUFBRSxFQUFFO0FBQ3JCLGlCQUFLLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUM7U0FDbEU7QUFDRCxhQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sRUFBRSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDMUUsQ0FBQztBQUVGLG1CQUFlLENBQUMsU0FBUyxDQUFDLGNBQWMsR0FBRyxVQUFTLElBQUksRUFBQTtBQUN0RCxZQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7QUFFbkMsYUFBSyxDQUFDLGFBQWEsRUFBRSxDQUFDO0FBQ3RCLGFBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUUxRSxZQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFBRSxnQkFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7U0FBRTtBQUMvQyxZQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFBRSxnQkFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7U0FBRTtLQUNoRCxDQUFDO0FBRUYsbUJBQWUsQ0FBQyxTQUFTLENBQUMsZ0JBQWdCLEdBQUcsVUFBUyxJQUFJLEVBQUE7QUFDeEQsWUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO0FBQ25DLGFBQUssQ0FBQyxhQUFhLEVBQUUsQ0FBQztBQUN0QixhQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsRUFBRSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDOUUsQ0FBQztBQUVGLG1CQUFlLENBQUMsU0FBUyxDQUFDLGdCQUFnQixHQUFHLFVBQVMsSUFBSSxFQUFBO0FBQ3hELFlBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUNuQyxhQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsRUFBRSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDN0UsQ0FBQztBQUVGLG1CQUFlLENBQUMsU0FBUyxDQUFDLGlCQUFpQixHQUFHLFVBQVMsUUFBUSxFQUFBO0FBQzdELFlBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUNuQyxhQUFLLENBQUMsYUFBYSxFQUFFLENBQUM7QUFDdEIsYUFBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxVQUFVLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ2xGLENBQUM7O0FBSUYsbUJBQWUsQ0FBQyxTQUFTLENBQUMsZUFBZSxHQUFHLFlBQUE7QUFDMUMsZUFBTyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO0tBQ3BELENBQUM7QUFFRixtQkFBZSxDQUFDLFNBQVMsQ0FBQyxTQUFTLEdBQUcsWUFBQTtBQUNwQyxZQUFJLEtBQUssR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO0FBQ3hCLFlBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQzVCLGVBQU8sS0FBSyxDQUFDO0tBQ2QsQ0FBQztBQUVGLG1CQUFlLENBQUMsU0FBUyxDQUFDLFFBQVEsR0FBRyxZQUFBO0FBQ25DLGVBQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQztLQUM5QixDQUFDO3NCQUVhLGVBQWU7Ozs7QUFJOUIsYUFBQSxVQUFBLENBQW9CLEtBQUssRUFBRSxPQUFPLEVBQUE7QUFDaEMsWUFBSSxLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUM7QUFFZixhQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtBQUNyQyxnQkFBSSxJQUFJLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBRXBCLGdCQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssVUFBVSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssYUFBYSxFQUFFO0FBQzNELHlCQUFTO2FBQ1YsTUFBTTtBQUNMLHFCQUFLLEVBQUUsQ0FBQzthQUNUO0FBRUQsZ0JBQUksSUFBSSxLQUFLLE9BQU8sRUFBRTtBQUNwQix1QkFBTyxLQUFLLENBQUM7YUFDZDtTQUNGO0FBRUQsZUFBTyxDQUFDLENBQUMsQ0FBQztLQUNYIiwiZmlsZSI6InRlbXBsYXRlLXZpc2l0b3IuanMiLCJzb3VyY2VzQ29udGVudCI6WyJsZXQgcHVzaCA9IEFycmF5LnByb3RvdHlwZS5wdXNoO1xuXG5jbGFzcyBGcmFtZSB7XG4gIHB1YmxpYyBwYXJlbnROb2RlOiBPYmplY3QgPSBudWxsO1xuICBwdWJsaWMgY2hpbGRyZW46IE9iamVjdCA9IG51bGw7XG4gIHB1YmxpYyBjaGlsZEluZGV4OiBudW1iZXIgPSBudWxsO1xuICBwdWJsaWMgY2hpbGRDb3VudDogbnVtYmVyID0gbnVsbDtcbiAgcHVibGljIGNoaWxkVGVtcGxhdGVDb3VudDogbnVtYmVyID0gMDtcbiAgcHVibGljIG11c3RhY2hlQ291bnQ6IG51bWJlciA9IDA7XG4gIHB1YmxpYyBhY3Rpb25zOiBhbnlbXSA9IFtdO1xuICBwdWJsaWMgYmxhbmtDaGlsZFRleHROb2RlczogbnVtYmVyW10gPSBudWxsO1xuICBwdWJsaWMgc3ltYm9sczogU3ltYm9sVGFibGUgPSBudWxsO1xufVxuXG5leHBvcnQgY2xhc3MgU3ltYm9sVGFibGUge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHN5bWJvbHM6IHN0cmluZ1tdLFxuICAgIHByaXZhdGUgcGFyZW50OiBTeW1ib2xUYWJsZSA9IG51bGxcbiAgKSB7fVxuXG4gIGhhc0xvY2FsVmFyaWFibGUobmFtZTogc3RyaW5nKTogYm9vbGVhbiB7XG4gICAgbGV0IHsgc3ltYm9scywgcGFyZW50IH0gPSB0aGlzO1xuICAgIHJldHVybiBzeW1ib2xzLmluZGV4T2YobmFtZSkgPj0gMCB8fCAocGFyZW50ICYmIHBhcmVudC5oYXNMb2NhbFZhcmlhYmxlKG5hbWUpKTtcbiAgfVxufVxuXG4vKipcbiAqIFRha2VzIGluIGFuIEFTVCBhbmQgb3V0cHV0cyBhIGxpc3Qgb2YgYWN0aW9ucyB0byBiZSBjb25zdW1lZFxuICogYnkgYSBjb21waWxlci4gRm9yIGV4YW1wbGUsIHRoZSB0ZW1wbGF0ZVxuICpcbiAqICAgICBmb297e2Jhcn19PGRpdj5iYXo8L2Rpdj5cbiAqXG4gKiBwcm9kdWNlcyB0aGUgYWN0aW9uc1xuICpcbiAqICAgICBbWydzdGFydFByb2dyYW0nLCBbcHJvZ3JhbU5vZGUsIDBdXSxcbiAqICAgICAgWyd0ZXh0JywgW3RleHROb2RlLCAwLCAzXV0sXG4gKiAgICAgIFsnbXVzdGFjaGUnLCBbbXVzdGFjaGVOb2RlLCAxLCAzXV0sXG4gKiAgICAgIFsnb3BlbkVsZW1lbnQnLCBbZWxlbWVudE5vZGUsIDIsIDMsIDBdXSxcbiAqICAgICAgWyd0ZXh0JywgW3RleHROb2RlLCAwLCAxXV0sXG4gKiAgICAgIFsnY2xvc2VFbGVtZW50JywgW2VsZW1lbnROb2RlLCAyLCAzXSxcbiAqICAgICAgWydlbmRQcm9ncmFtJywgW3Byb2dyYW1Ob2RlXV1dXG4gKlxuICogVGhpcyB2aXNpdG9yIHdhbGtzIHRoZSBBU1QgZGVwdGggZmlyc3QgYW5kIGJhY2t3YXJkcy4gQXNcbiAqIGEgcmVzdWx0IHRoZSBib3R0b20tbW9zdCBjaGlsZCB0ZW1wbGF0ZSB3aWxsIGFwcGVhciBhdCB0aGVcbiAqIHRvcCBvZiB0aGUgYWN0aW9ucyBsaXN0IHdoZXJlYXMgdGhlIHJvb3QgdGVtcGxhdGUgd2lsbCBhcHBlYXJcbiAqIGF0IHRoZSBib3R0b20gb2YgdGhlIGxpc3QuIEZvciBleGFtcGxlLFxuICpcbiAqICAgICA8ZGl2Pnt7I2lmfX1mb297e2Vsc2V9fWJhcjxiPjwvYj57ey9pZn19PC9kaXY+XG4gKlxuICogcHJvZHVjZXMgdGhlIGFjdGlvbnNcbiAqXG4gKiAgICAgW1snc3RhcnRQcm9ncmFtJywgW3Byb2dyYW1Ob2RlLCAwXV0sXG4gKiAgICAgIFsndGV4dCcsIFt0ZXh0Tm9kZSwgMCwgMiwgMF1dLFxuICogICAgICBbJ29wZW5FbGVtZW50JywgW2VsZW1lbnROb2RlLCAxLCAyLCAwXV0sXG4gKiAgICAgIFsnY2xvc2VFbGVtZW50JywgW2VsZW1lbnROb2RlLCAxLCAyXV0sXG4gKiAgICAgIFsnZW5kUHJvZ3JhbScsIFtwcm9ncmFtTm9kZV1dLFxuICogICAgICBbJ3N0YXJ0UHJvZ3JhbScsIFtwcm9ncmFtTm9kZSwgMF1dLFxuICogICAgICBbJ3RleHQnLCBbdGV4dE5vZGUsIDAsIDFdXSxcbiAqICAgICAgWydlbmRQcm9ncmFtJywgW3Byb2dyYW1Ob2RlXV0sXG4gKiAgICAgIFsnc3RhcnRQcm9ncmFtJywgW3Byb2dyYW1Ob2RlLCAyXV0sXG4gKiAgICAgIFsnb3BlbkVsZW1lbnQnLCBbZWxlbWVudE5vZGUsIDAsIDEsIDFdXSxcbiAqICAgICAgWydibG9jaycsIFtibG9ja05vZGUsIDAsIDFdXSxcbiAqICAgICAgWydjbG9zZUVsZW1lbnQnLCBbZWxlbWVudE5vZGUsIDAsIDFdXSxcbiAqICAgICAgWydlbmRQcm9ncmFtJywgW3Byb2dyYW1Ob2RlXV1dXG4gKlxuICogVGhlIHN0YXRlIG9mIHRoZSB0cmF2ZXJzYWwgaXMgbWFpbnRhaW5lZCBieSBhIHN0YWNrIG9mIGZyYW1lcy5cbiAqIFdoZW5ldmVyIGEgbm9kZSB3aXRoIGNoaWxkcmVuIGlzIGVudGVyZWQgKGVpdGhlciBhIFByb2dyYW1Ob2RlXG4gKiBvciBhbiBFbGVtZW50Tm9kZSkgYSBmcmFtZSBpcyBwdXNoZWQgb250byB0aGUgc3RhY2suIFRoZSBmcmFtZVxuICogY29udGFpbnMgaW5mb3JtYXRpb24gYWJvdXQgdGhlIHN0YXRlIG9mIHRoZSB0cmF2ZXJzYWwgb2YgdGhhdFxuICogbm9kZS4gRm9yIGV4YW1wbGUsXG4gKlxuICogICAtIGluZGV4IG9mIHRoZSBjdXJyZW50IGNoaWxkIG5vZGUgYmVpbmcgdmlzaXRlZFxuICogICAtIHRoZSBudW1iZXIgb2YgbXVzdGFjaGVzIGNvbnRhaW5lZCB3aXRoaW4gaXRzIGNoaWxkIG5vZGVzXG4gKiAgIC0gdGhlIGxpc3Qgb2YgYWN0aW9ucyBnZW5lcmF0ZWQgYnkgaXRzIGNoaWxkIG5vZGVzXG4gKi9cblxuZnVuY3Rpb24gVGVtcGxhdGVWaXNpdG9yKCkge1xuICB0aGlzLmZyYW1lU3RhY2sgPSBbXTtcbiAgdGhpcy5hY3Rpb25zID0gW107XG4gIHRoaXMucHJvZ3JhbURlcHRoID0gLTE7XG59XG5cbi8vIFRyYXZlcnNhbCBtZXRob2RzXG5cblRlbXBsYXRlVmlzaXRvci5wcm90b3R5cGUudmlzaXQgPSBmdW5jdGlvbihub2RlKSB7XG4gIHRoaXNbbm9kZS50eXBlXShub2RlKTtcbn07XG5cblRlbXBsYXRlVmlzaXRvci5wcm90b3R5cGUuUHJvZ3JhbSA9IGZ1bmN0aW9uKHByb2dyYW0pIHtcbiAgdGhpcy5wcm9ncmFtRGVwdGgrKztcblxuICBsZXQgcGFyZW50RnJhbWUgPSB0aGlzLmdldEN1cnJlbnRGcmFtZSgpO1xuICBsZXQgcHJvZ3JhbUZyYW1lID0gdGhpcy5wdXNoRnJhbWUoKTtcblxuICBpZiAocGFyZW50RnJhbWUpIHtcbiAgICBwcm9ncmFtLnN5bWJvbHMgPSBuZXcgU3ltYm9sVGFibGUocHJvZ3JhbS5ibG9ja1BhcmFtcywgcGFyZW50RnJhbWUuc3ltYm9scyk7XG4gIH0gZWxzZSB7XG4gICAgcHJvZ3JhbS5zeW1ib2xzID0gbmV3IFN5bWJvbFRhYmxlKHByb2dyYW0uYmxvY2tQYXJhbXMpO1xuICB9XG5cbiAgbGV0IHN0YXJ0VHlwZSwgZW5kVHlwZTtcblxuICBpZiAodGhpcy5wcm9ncmFtRGVwdGggPT09IDApIHtcbiAgICBzdGFydFR5cGUgPSAnc3RhcnRQcm9ncmFtJztcbiAgICBlbmRUeXBlID0gJ2VuZFByb2dyYW0nO1xuICB9IGVsc2Uge1xuICAgIHN0YXJ0VHlwZSA9ICdzdGFydEJsb2NrJztcbiAgICBlbmRUeXBlID0gJ2VuZEJsb2NrJztcbiAgfVxuXG4gIHByb2dyYW1GcmFtZS5wYXJlbnROb2RlID0gcHJvZ3JhbTtcbiAgcHJvZ3JhbUZyYW1lLmNoaWxkcmVuID0gcHJvZ3JhbS5ib2R5O1xuICBwcm9ncmFtRnJhbWUuY2hpbGRDb3VudCA9IHByb2dyYW0uYm9keS5sZW5ndGg7XG4gIHByb2dyYW1GcmFtZS5ibGFua0NoaWxkVGV4dE5vZGVzID0gW107XG4gIHByb2dyYW1GcmFtZS5hY3Rpb25zLnB1c2goW2VuZFR5cGUsIFtwcm9ncmFtLCB0aGlzLnByb2dyYW1EZXB0aF1dKTtcbiAgcHJvZ3JhbUZyYW1lLnN5bWJvbHMgPSBwcm9ncmFtLnN5bWJvbHM7XG5cbiAgZm9yIChsZXQgaSA9IHByb2dyYW0uYm9keS5sZW5ndGggLSAxOyBpID49IDA7IGktLSkge1xuICAgIHByb2dyYW1GcmFtZS5jaGlsZEluZGV4ID0gaTtcbiAgICB0aGlzLnZpc2l0KHByb2dyYW0uYm9keVtpXSk7XG4gIH1cblxuICBwcm9ncmFtRnJhbWUuYWN0aW9ucy5wdXNoKFtzdGFydFR5cGUsIFtcbiAgICBwcm9ncmFtLCBwcm9ncmFtRnJhbWUuY2hpbGRUZW1wbGF0ZUNvdW50LFxuICAgIHByb2dyYW1GcmFtZS5ibGFua0NoaWxkVGV4dE5vZGVzLnJldmVyc2UoKVxuICBdXSk7XG4gIHRoaXMucG9wRnJhbWUoKTtcblxuICB0aGlzLnByb2dyYW1EZXB0aC0tO1xuXG4gIC8vIFB1c2ggdGhlIGNvbXBsZXRlZCB0ZW1wbGF0ZSBpbnRvIHRoZSBnbG9iYWwgYWN0aW9ucyBsaXN0XG4gIGlmIChwYXJlbnRGcmFtZSkgeyBwYXJlbnRGcmFtZS5jaGlsZFRlbXBsYXRlQ291bnQrKzsgfVxuICBwdXNoLmFwcGx5KHRoaXMuYWN0aW9ucywgcHJvZ3JhbUZyYW1lLmFjdGlvbnMucmV2ZXJzZSgpKTtcbn07XG5cblRlbXBsYXRlVmlzaXRvci5wcm90b3R5cGUuRWxlbWVudE5vZGUgPSBmdW5jdGlvbihlbGVtZW50KSB7XG4gIGxldCBwYXJlbnRGcmFtZSA9IHRoaXMuZ2V0Q3VycmVudEZyYW1lKCk7XG4gIGxldCBlbGVtZW50RnJhbWUgPSB0aGlzLnB1c2hGcmFtZSgpO1xuXG4gIGVsZW1lbnRGcmFtZS5wYXJlbnROb2RlID0gZWxlbWVudDtcbiAgZWxlbWVudEZyYW1lLmNoaWxkcmVuID0gZWxlbWVudC5jaGlsZHJlbjtcbiAgZWxlbWVudEZyYW1lLmNoaWxkQ291bnQgPSBlbGVtZW50LmNoaWxkcmVuLmxlbmd0aDtcbiAgZWxlbWVudEZyYW1lLm11c3RhY2hlQ291bnQgKz0gZWxlbWVudC5tb2RpZmllcnMubGVuZ3RoO1xuICBlbGVtZW50RnJhbWUuYmxhbmtDaGlsZFRleHROb2RlcyA9IFtdO1xuICBlbGVtZW50RnJhbWUuc3ltYm9scyA9IHBhcmVudEZyYW1lLnN5bWJvbHM7XG5cbiAgbGV0IGFjdGlvbkFyZ3MgPSBbXG4gICAgZWxlbWVudCxcbiAgICBwYXJlbnRGcmFtZS5jaGlsZEluZGV4LFxuICAgIHBhcmVudEZyYW1lLmNoaWxkQ291bnRcbiAgXTtcblxuICBlbGVtZW50RnJhbWUuYWN0aW9ucy5wdXNoKFsnY2xvc2VFbGVtZW50JywgYWN0aW9uQXJnc10pO1xuXG4gIGZvciAobGV0IGkgPSBlbGVtZW50LmF0dHJpYnV0ZXMubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcbiAgICB0aGlzLnZpc2l0KGVsZW1lbnQuYXR0cmlidXRlc1tpXSk7XG4gIH1cblxuICBmb3IgKGxldCBpID0gZWxlbWVudC5jaGlsZHJlbi5sZW5ndGggLSAxOyBpID49IDA7IGktLSkge1xuICAgIGVsZW1lbnRGcmFtZS5jaGlsZEluZGV4ID0gaTtcbiAgICB0aGlzLnZpc2l0KGVsZW1lbnQuY2hpbGRyZW5baV0pO1xuICB9XG5cbiAgZWxlbWVudEZyYW1lLmFjdGlvbnMucHVzaChbJ29wZW5FbGVtZW50JywgYWN0aW9uQXJncy5jb25jYXQoW1xuICAgIGVsZW1lbnRGcmFtZS5tdXN0YWNoZUNvdW50LCBlbGVtZW50RnJhbWUuYmxhbmtDaGlsZFRleHROb2Rlcy5yZXZlcnNlKCkgXSldKTtcbiAgdGhpcy5wb3BGcmFtZSgpO1xuXG4gIC8vIFByb3BhZ2F0ZSB0aGUgZWxlbWVudCdzIGZyYW1lIHN0YXRlIHRvIHRoZSBwYXJlbnQgZnJhbWVcbiAgaWYgKGVsZW1lbnRGcmFtZS5tdXN0YWNoZUNvdW50ID4gMCkgeyBwYXJlbnRGcmFtZS5tdXN0YWNoZUNvdW50Kys7IH1cbiAgcGFyZW50RnJhbWUuY2hpbGRUZW1wbGF0ZUNvdW50ICs9IGVsZW1lbnRGcmFtZS5jaGlsZFRlbXBsYXRlQ291bnQ7XG4gIHB1c2guYXBwbHkocGFyZW50RnJhbWUuYWN0aW9ucywgZWxlbWVudEZyYW1lLmFjdGlvbnMpO1xufTtcblxuVGVtcGxhdGVWaXNpdG9yLnByb3RvdHlwZS5BdHRyTm9kZSA9IGZ1bmN0aW9uKGF0dHIpIHtcbiAgaWYgKGF0dHIudmFsdWUudHlwZSAhPT0gJ1RleHROb2RlJykge1xuICAgIHRoaXMuZ2V0Q3VycmVudEZyYW1lKCkubXVzdGFjaGVDb3VudCsrO1xuICB9XG59O1xuXG5UZW1wbGF0ZVZpc2l0b3IucHJvdG90eXBlLlRleHROb2RlID0gZnVuY3Rpb24odGV4dCkge1xuICBsZXQgZnJhbWUgPSB0aGlzLmdldEN1cnJlbnRGcmFtZSgpO1xuICBpZiAodGV4dC5jaGFycyA9PT0gJycpIHtcbiAgICBmcmFtZS5ibGFua0NoaWxkVGV4dE5vZGVzLnB1c2goZG9tSW5kZXhPZihmcmFtZS5jaGlsZHJlbiwgdGV4dCkpO1xuICB9XG4gIGZyYW1lLmFjdGlvbnMucHVzaChbJ3RleHQnLCBbdGV4dCwgZnJhbWUuY2hpbGRJbmRleCwgZnJhbWUuY2hpbGRDb3VudF1dKTtcbn07XG5cblRlbXBsYXRlVmlzaXRvci5wcm90b3R5cGUuQmxvY2tTdGF0ZW1lbnQgPSBmdW5jdGlvbihub2RlKSB7XG4gIGxldCBmcmFtZSA9IHRoaXMuZ2V0Q3VycmVudEZyYW1lKCk7XG5cbiAgZnJhbWUubXVzdGFjaGVDb3VudCsrO1xuICBmcmFtZS5hY3Rpb25zLnB1c2goWydibG9jaycsIFtub2RlLCBmcmFtZS5jaGlsZEluZGV4LCBmcmFtZS5jaGlsZENvdW50XV0pO1xuXG4gIGlmIChub2RlLmludmVyc2UpIHsgdGhpcy52aXNpdChub2RlLmludmVyc2UpOyB9XG4gIGlmIChub2RlLnByb2dyYW0pIHsgdGhpcy52aXNpdChub2RlLnByb2dyYW0pOyB9XG59O1xuXG5UZW1wbGF0ZVZpc2l0b3IucHJvdG90eXBlLlBhcnRpYWxTdGF0ZW1lbnQgPSBmdW5jdGlvbihub2RlKSB7XG4gIGxldCBmcmFtZSA9IHRoaXMuZ2V0Q3VycmVudEZyYW1lKCk7XG4gIGZyYW1lLm11c3RhY2hlQ291bnQrKztcbiAgZnJhbWUuYWN0aW9ucy5wdXNoKFsnbXVzdGFjaGUnLCBbbm9kZSwgZnJhbWUuY2hpbGRJbmRleCwgZnJhbWUuY2hpbGRDb3VudF1dKTtcbn07XG5cblRlbXBsYXRlVmlzaXRvci5wcm90b3R5cGUuQ29tbWVudFN0YXRlbWVudCA9IGZ1bmN0aW9uKHRleHQpIHtcbiAgbGV0IGZyYW1lID0gdGhpcy5nZXRDdXJyZW50RnJhbWUoKTtcbiAgZnJhbWUuYWN0aW9ucy5wdXNoKFsnY29tbWVudCcsIFt0ZXh0LCBmcmFtZS5jaGlsZEluZGV4LCBmcmFtZS5jaGlsZENvdW50XV0pO1xufTtcblxuVGVtcGxhdGVWaXNpdG9yLnByb3RvdHlwZS5NdXN0YWNoZVN0YXRlbWVudCA9IGZ1bmN0aW9uKG11c3RhY2hlKSB7XG4gIGxldCBmcmFtZSA9IHRoaXMuZ2V0Q3VycmVudEZyYW1lKCk7XG4gIGZyYW1lLm11c3RhY2hlQ291bnQrKztcbiAgZnJhbWUuYWN0aW9ucy5wdXNoKFsnbXVzdGFjaGUnLCBbbXVzdGFjaGUsIGZyYW1lLmNoaWxkSW5kZXgsIGZyYW1lLmNoaWxkQ291bnRdXSk7XG59O1xuXG4vLyBGcmFtZSBoZWxwZXJzXG5cblRlbXBsYXRlVmlzaXRvci5wcm90b3R5cGUuZ2V0Q3VycmVudEZyYW1lID0gZnVuY3Rpb24oKSB7XG4gIHJldHVybiB0aGlzLmZyYW1lU3RhY2tbdGhpcy5mcmFtZVN0YWNrLmxlbmd0aCAtIDFdO1xufTtcblxuVGVtcGxhdGVWaXNpdG9yLnByb3RvdHlwZS5wdXNoRnJhbWUgPSBmdW5jdGlvbigpIHtcbiAgbGV0IGZyYW1lID0gbmV3IEZyYW1lKCk7XG4gIHRoaXMuZnJhbWVTdGFjay5wdXNoKGZyYW1lKTtcbiAgcmV0dXJuIGZyYW1lO1xufTtcblxuVGVtcGxhdGVWaXNpdG9yLnByb3RvdHlwZS5wb3BGcmFtZSA9IGZ1bmN0aW9uKCkge1xuICByZXR1cm4gdGhpcy5mcmFtZVN0YWNrLnBvcCgpO1xufTtcblxuZXhwb3J0IGRlZmF1bHQgVGVtcGxhdGVWaXNpdG9yO1xuXG4vLyBSZXR1cm5zIHRoZSBpbmRleCBvZiBgZG9tTm9kZWAgaW4gdGhlIGBub2Rlc2AgYXJyYXksIHNraXBwaW5nXG4vLyBvdmVyIGFueSBub2RlcyB3aGljaCBkbyBub3QgcmVwcmVzZW50IERPTSBub2Rlcy5cbmZ1bmN0aW9uIGRvbUluZGV4T2Yobm9kZXMsIGRvbU5vZGUpIHtcbiAgbGV0IGluZGV4ID0gLTE7XG5cbiAgZm9yIChsZXQgaSA9IDA7IGkgPCBub2Rlcy5sZW5ndGg7IGkrKykge1xuICAgIGxldCBub2RlID0gbm9kZXNbaV07XG5cbiAgICBpZiAobm9kZS50eXBlICE9PSAnVGV4dE5vZGUnICYmIG5vZGUudHlwZSAhPT0gJ0VsZW1lbnROb2RlJykge1xuICAgICAgY29udGludWU7XG4gICAgfSBlbHNlIHtcbiAgICAgIGluZGV4Kys7XG4gICAgfVxuXG4gICAgaWYgKG5vZGUgPT09IGRvbU5vZGUpIHtcbiAgICAgIHJldHVybiBpbmRleDtcbiAgICB9XG4gIH1cblxuICByZXR1cm4gLTE7XG59XG4iXX0=
enifed("glimmer-compiler/lib/utils", ["exports"], function (exports) {
    "use strict";

    exports.processOpcodes = processOpcodes;

    function processOpcodes(compiler, opcodes) {
        for (var i = 0, l = opcodes.length; i < l; i++) {
            var method = opcodes[i][0];
            var params = opcodes[i][1];
            if (params) {
                compiler[method].apply(compiler, params);
            } else {
                compiler[method].call(compiler);
            }
        }
    }
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItY29tcGlsZXIvbGliL3V0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsYUFBQSxjQUFBLENBQStCLFFBQVEsRUFBRSxPQUFPLEVBQUE7QUFDOUMsYUFBSyxJQUFJLENBQUMsR0FBQyxDQUFDLEVBQUUsQ0FBQyxHQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtBQUN4QyxnQkFBSSxNQUFNLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzNCLGdCQUFJLE1BQU0sR0FBRyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDM0IsZ0JBQUksTUFBTSxFQUFFO0FBQ1Ysd0JBQVEsQ0FBQyxNQUFNLENBQUMsQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO2FBQzFDLE1BQU07QUFDTCx3QkFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQzthQUNqQztTQUNGO0tBQ0YiLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gcHJvY2Vzc09wY29kZXMoY29tcGlsZXIsIG9wY29kZXMpIHtcbiAgZm9yIChsZXQgaT0wLCBsPW9wY29kZXMubGVuZ3RoOyBpPGw7IGkrKykge1xuICAgIGxldCBtZXRob2QgPSBvcGNvZGVzW2ldWzBdO1xuICAgIGxldCBwYXJhbXMgPSBvcGNvZGVzW2ldWzFdO1xuICAgIGlmIChwYXJhbXMpIHtcbiAgICAgIGNvbXBpbGVyW21ldGhvZF0uYXBwbHkoY29tcGlsZXIsIHBhcmFtcyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbXBpbGVyW21ldGhvZF0uY2FsbChjb21waWxlcik7XG4gICAgfVxuICB9XG59Il19
enifed('glimmer-reference/index', ['exports', 'glimmer-reference/lib/reference', 'glimmer-reference/lib/const', 'glimmer-reference/lib/validators', 'glimmer-reference/lib/utils', 'glimmer-reference/lib/iterable'], function (exports, _glimmerReferenceLibReference, _glimmerReferenceLibConst, _glimmerReferenceLibValidators, _glimmerReferenceLibUtils, _glimmerReferenceLibIterable) {
  'use strict';

  exports.BasicReference = _glimmerReferenceLibReference.Reference;
  exports.BasicPathReference = _glimmerReferenceLibReference.PathReference;
  exports.ConstReference = _glimmerReferenceLibConst.ConstReference;
  exports.isConst = _glimmerReferenceLibConst.isConst;
  babelHelpers.defaults(exports, babelHelpers.interopExportWildcard(_glimmerReferenceLibValidators, babelHelpers.defaults));
  exports.Reference = _glimmerReferenceLibValidators.VersionedReference;
  exports.PathReference = _glimmerReferenceLibValidators.VersionedPathReference;
  exports.referenceFromParts = _glimmerReferenceLibUtils.referenceFromParts;
  exports.IterationItem = _glimmerReferenceLibIterable.IterationItem;
  exports.Iterator = _glimmerReferenceLibIterable.Iterator;
  exports.Iterable = _glimmerReferenceLibIterable.Iterable;
  exports.OpaqueIterator = _glimmerReferenceLibIterable.OpaqueIterator;
  exports.OpaqueIterable = _glimmerReferenceLibIterable.OpaqueIterable;
  exports.AbstractIterator = _glimmerReferenceLibIterable.AbstractIterator;
  exports.AbstractIterable = _glimmerReferenceLibIterable.AbstractIterable;
  exports.IterationArtifacts = _glimmerReferenceLibIterable.IterationArtifacts;
  exports.ReferenceIterator = _glimmerReferenceLibIterable.ReferenceIterator;
  exports.IteratorSynchronizer = _glimmerReferenceLibIterable.IteratorSynchronizer;
  exports.IteratorSynchronizerDelegate = _glimmerReferenceLibIterable.IteratorSynchronizerDelegate;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcmVmZXJlbmNlL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztVQUNlLGNBQWMsaUNBQTNCLFNBQVM7VUFDUSxrQkFBa0IsaUNBQW5DLGFBQWE7VUFJYixjQUFjLDZCQUFkLGNBQWM7VUFDZCxPQUFPLDZCQUFQLE9BQU87O1VBTWUsU0FBUyxrQ0FBL0Isa0JBQWtCO1VBQ1EsYUFBYSxrQ0FBdkMsc0JBQXNCO1VBSXRCLGtCQUFrQiw2QkFBbEIsa0JBQWtCO1VBSWxCLGFBQWEsZ0NBQWIsYUFBYTtVQUNiLFFBQVEsZ0NBQVIsUUFBUTtVQUNSLFFBQVEsZ0NBQVIsUUFBUTtVQUNSLGNBQWMsZ0NBQWQsY0FBYztVQUNkLGNBQWMsZ0NBQWQsY0FBYztVQUNkLGdCQUFnQixnQ0FBaEIsZ0JBQWdCO1VBQ2hCLGdCQUFnQixnQ0FBaEIsZ0JBQWdCO1VBQ2hCLGtCQUFrQixnQ0FBbEIsa0JBQWtCO1VBQ2xCLGlCQUFpQixnQ0FBakIsaUJBQWlCO1VBQ2pCLG9CQUFvQixnQ0FBcEIsb0JBQW9CO1VBQ3BCLDRCQUE0QixnQ0FBNUIsNEJBQTRCIiwiZmlsZSI6ImluZGV4LmpzIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IHtcbiAgUmVmZXJlbmNlIGFzIEJhc2ljUmVmZXJlbmNlLFxuICBQYXRoUmVmZXJlbmNlIGFzIEJhc2ljUGF0aFJlZmVyZW5jZVxufSBmcm9tICcuL2xpYi9yZWZlcmVuY2UnO1xuXG5leHBvcnQge1xuICBDb25zdFJlZmVyZW5jZSxcbiAgaXNDb25zdFxufSBmcm9tICcuL2xpYi9jb25zdCc7XG5cbmV4cG9ydCAqIGZyb20gJy4vbGliL3ZhbGlkYXRvcnMnO1xuXG5leHBvcnQge1xuICBWZXJzaW9uZWRSZWZlcmVuY2UgYXMgUmVmZXJlbmNlLFxuICBWZXJzaW9uZWRQYXRoUmVmZXJlbmNlIGFzIFBhdGhSZWZlcmVuY2Vcbn0gZnJvbSAnLi9saWIvdmFsaWRhdG9ycyc7XG5cbmV4cG9ydCB7XG4gIHJlZmVyZW5jZUZyb21QYXJ0c1xufSBmcm9tICcuL2xpYi91dGlscyc7XG5cbmV4cG9ydCB7XG4gIEl0ZXJhdGlvbkl0ZW0sXG4gIEl0ZXJhdG9yLFxuICBJdGVyYWJsZSxcbiAgT3BhcXVlSXRlcmF0b3IsXG4gIE9wYXF1ZUl0ZXJhYmxlLFxuICBBYnN0cmFjdEl0ZXJhdG9yLFxuICBBYnN0cmFjdEl0ZXJhYmxlLFxuICBJdGVyYXRpb25BcnRpZmFjdHMsXG4gIFJlZmVyZW5jZUl0ZXJhdG9yLFxuICBJdGVyYXRvclN5bmNocm9uaXplcixcbiAgSXRlcmF0b3JTeW5jaHJvbml6ZXJEZWxlZ2F0ZVxufSBmcm9tICcuL2xpYi9pdGVyYWJsZSc7XG4iXX0=
enifed('glimmer-reference/lib/const', ['exports', 'glimmer-reference/lib/validators'], function (exports, _glimmerReferenceLibValidators) {
    'use strict';

    exports.isConst = isConst;

    var ConstReference = (function () {
        function ConstReference(inner) {
            this.inner = inner;
            this.tag = _glimmerReferenceLibValidators.CONSTANT_TAG;
        }

        ConstReference.prototype.value = function value() {
            return this.inner;
        };

        return ConstReference;
    })();

    exports.ConstReference = ConstReference;

    function isConst(reference) {
        return reference.tag === _glimmerReferenceLibValidators.CONSTANT_TAG;
    }
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcmVmZXJlbmNlL2xpYi9jb25zdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztRQUdBLGNBQUE7QUFHRSxpQkFIRixjQUFBLENBR3dCLEtBQVEsRUFBQTtBQUFSLGdCQUFBLENBQUEsS0FBSyxHQUFMLEtBQUssQ0FBRztBQUZ2QixnQkFBQSxDQUFBLEdBQUcsa0NBSkgsWUFBWSxBQUltQixDQUFDO1NBRUo7O0FBSHJDLHNCQUFBLFdBS0UsS0FBSyxHQUFBLGlCQUFBO0FBQVEsbUJBQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztTQUFFOztlQUxuQyxjQUFBOzs7OztBQVFBLGFBQUEsT0FBQSxDQUF3QixTQUFxQyxFQUFBO0FBQzNELGVBQU8sU0FBUyxDQUFDLEdBQUcsb0NBWmIsWUFBWSxBQVlrQixDQUFDO0tBQ3ZDIiwiZmlsZSI6ImNvbnN0LmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ09OU1RBTlRfVEFHLCBWZXJzaW9uZWRSZWZlcmVuY2UsIFJldmlzaW9uVGFnIH0gZnJvbSAnLi92YWxpZGF0b3JzJztcbmltcG9ydCB7IE9wYXF1ZSB9IGZyb20gJ2dsaW1tZXItdXRpbCc7XG5cbmV4cG9ydCBjbGFzcyBDb25zdFJlZmVyZW5jZTxUPiBpbXBsZW1lbnRzIFZlcnNpb25lZFJlZmVyZW5jZTxUPiB7XG4gIHB1YmxpYyB0YWc6IFJldmlzaW9uVGFnID0gQ09OU1RBTlRfVEFHO1xuXG4gIGNvbnN0cnVjdG9yKHByb3RlY3RlZCBpbm5lcjogVCkgeyB9XG5cbiAgdmFsdWUoKTogVCB7IHJldHVybiB0aGlzLmlubmVyOyB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0NvbnN0KHJlZmVyZW5jZTogVmVyc2lvbmVkUmVmZXJlbmNlPE9wYXF1ZT4pOiBib29sZWFuIHtcbiAgcmV0dXJuIHJlZmVyZW5jZS50YWcgPT09IENPTlNUQU5UX1RBRztcbn1cbiJdfQ==
enifed("glimmer-reference/lib/iterable", ["exports", "glimmer-util"], function (exports, _glimmerUtil) {
    "use strict";

    var ListItem = (function (_ListNode) {
        babelHelpers.inherits(ListItem, _ListNode);

        function ListItem(iterable, result) {
            _ListNode.call(this, iterable.valueReferenceFor(result));
            this.retained = false;
            this.seen = false;
            this.key = result.key;
            this.iterable = iterable;
            this.memo = iterable.memoReferenceFor(result);
        }

        ListItem.prototype.update = function update(item) {
            this.retained = true;
            this.iterable.updateValueReference(this.value, item);
            this.iterable.updateMemoReference(this.memo, item);
        };

        ListItem.prototype.shouldRemove = function shouldRemove() {
            return !this.retained;
        };

        ListItem.prototype.reset = function reset() {
            this.retained = false;
            this.seen = false;
        };

        return ListItem;
    })(_glimmerUtil.ListNode);

    exports.ListItem = ListItem;

    var IterationArtifacts = (function () {
        function IterationArtifacts(iterable) {
            this.map = _glimmerUtil.dict();
            this.list = new _glimmerUtil.LinkedList();
            this.tag = iterable.tag;
            this.iterable = iterable;
        }

        IterationArtifacts.prototype.isEmpty = function isEmpty() {
            var iterator = this.iterator = this.iterable.iterate();
            return iterator.isEmpty();
        };

        IterationArtifacts.prototype.iterate = function iterate() {
            var iterator = this.iterator || this.iterable.iterate();
            this.iterator = null;
            return iterator;
        };

        IterationArtifacts.prototype.has = function has(key) {
            return !!this.map[key];
        };

        IterationArtifacts.prototype.get = function get(key) {
            return this.map[key];
        };

        IterationArtifacts.prototype.wasSeen = function wasSeen(key) {
            var node = this.map[key];
            return node && node.seen;
        };

        IterationArtifacts.prototype.append = function append(item) {
            var map = this.map;
            var list = this.list;
            var iterable = this.iterable;

            var node = map[item.key] = new ListItem(iterable, item);
            list.append(node);
            return node;
        };

        IterationArtifacts.prototype.insertBefore = function insertBefore(item, reference) {
            var map = this.map;
            var list = this.list;
            var iterable = this.iterable;

            var node = map[item.key] = new ListItem(iterable, item);
            node.retained = true;
            list.insertBefore(node, reference);
            return node;
        };

        IterationArtifacts.prototype.move = function move(item, reference) {
            var list = this.list;

            item.retained = true;
            list.remove(item);
            list.insertBefore(item, reference);
        };

        IterationArtifacts.prototype.remove = function remove(item) {
            var list = this.list;

            list.remove(item);
            delete this.map[item.key];
        };

        IterationArtifacts.prototype.nextNode = function nextNode(item) {
            return this.list.nextNode(item);
        };

        IterationArtifacts.prototype.head = function head() {
            return this.list.head();
        };

        return IterationArtifacts;
    })();

    exports.IterationArtifacts = IterationArtifacts;

    var ReferenceIterator = (function () {
        // if anyone needs to construct this object with something other than
        // an iterable, let @wycats know.

        function ReferenceIterator(iterable) {
            this.iterator = null;
            var artifacts = new IterationArtifacts(iterable);
            this.artifacts = artifacts;
        }

        ReferenceIterator.prototype.next = function next() {
            var artifacts = this.artifacts;

            var iterator = this.iterator = this.iterator || artifacts.iterate();
            var item = iterator.next();
            if (!item) return null;
            return artifacts.append(item);
        };

        return ReferenceIterator;
    })();

    exports.ReferenceIterator = ReferenceIterator;

    var Phase;
    (function (Phase) {
        Phase[Phase["Append"] = 0] = "Append";
        Phase[Phase["Prune"] = 1] = "Prune";
        Phase[Phase["Done"] = 2] = "Done";
    })(Phase || (Phase = {}));

    var IteratorSynchronizer = (function () {
        function IteratorSynchronizer(_ref) {
            var target = _ref.target;
            var artifacts = _ref.artifacts;

            this.target = target;
            this.artifacts = artifacts;
            this.iterator = artifacts.iterate();
            this.current = artifacts.head();
        }

        IteratorSynchronizer.prototype.sync = function sync() {
            var phase = Phase.Append;
            while (true) {
                switch (phase) {
                    case Phase.Append:
                        phase = this.nextAppend();
                        break;
                    case Phase.Prune:
                        phase = this.nextPrune();
                        break;
                    case Phase.Done:
                        this.nextDone();
                        return;
                }
            }
        };

        IteratorSynchronizer.prototype.advanceToKey = function advanceToKey(key) {
            var current = this.current;
            var artifacts = this.artifacts;

            var seek = current;
            while (seek && seek.key !== key) {
                seek.seen = true;
                seek = artifacts.nextNode(seek);
            }
            this.current = seek && artifacts.nextNode(seek);
        };

        IteratorSynchronizer.prototype.nextAppend = function nextAppend() {
            var iterator = this.iterator;
            var current = this.current;
            var artifacts = this.artifacts;

            var item = iterator.next();
            if (item === null) {
                return this.startPrune();
            }
            var key = item.key;

            if (current && current.key === key) {
                this.nextRetain(item);
            } else if (artifacts.has(key)) {
                this.nextMove(item);
            } else {
                this.nextInsert(item);
            }
            return Phase.Append;
        };

        IteratorSynchronizer.prototype.nextRetain = function nextRetain(item) {
            var artifacts = this.artifacts;
            var current = this.current;

            current.update(item);
            this.current = artifacts.nextNode(current);
            this.target.retain(item.key, current.value, current.memo);
        };

        IteratorSynchronizer.prototype.nextMove = function nextMove(item) {
            var current = this.current;
            var artifacts = this.artifacts;
            var target = this.target;
            var key = item.key;

            var found = artifacts.get(item.key);
            found.update(item);
            if (artifacts.wasSeen(item.key)) {
                artifacts.move(found, current);
                target.move(found.key, found.value, found.memo, current ? current.key : null);
            } else {
                this.advanceToKey(key);
            }
        };

        IteratorSynchronizer.prototype.nextInsert = function nextInsert(item) {
            var artifacts = this.artifacts;
            var target = this.target;
            var current = this.current;

            var node = artifacts.insertBefore(item, current);
            target.insert(node.key, node.value, node.memo, current ? current.key : null);
        };

        IteratorSynchronizer.prototype.startPrune = function startPrune() {
            this.current = this.artifacts.head();
            return Phase.Prune;
        };

        IteratorSynchronizer.prototype.nextPrune = function nextPrune() {
            var artifacts = this.artifacts;
            var target = this.target;
            var current = this.current;

            if (current === null) {
                return Phase.Done;
            }
            var node = current;
            this.current = artifacts.nextNode(node);
            if (node.shouldRemove()) {
                artifacts.remove(node);
                target.delete(node.key);
            } else {
                node.reset();
            }
            return Phase.Prune;
        };

        IteratorSynchronizer.prototype.nextDone = function nextDone() {
            this.target.done();
        };

        return IteratorSynchronizer;
    })();

    exports.IteratorSynchronizer = IteratorSynchronizer;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcmVmZXJlbmNlL2xpYi9pdGVyYWJsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7UUFrQ0EsUUFBQTs4QkFBQSxRQUFBOztBQU9FLGlCQVBGLFFBQUEsQ0FPYyxRQUF3QixFQUFFLE1BQTJCLEVBQUE7QUFDL0QsaUNBQU0sUUFBUSxDQUFDLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7QUFMckMsZ0JBQUEsQ0FBQSxRQUFRLEdBQVksS0FBSyxDQUFDO0FBQzFCLGdCQUFBLENBQUEsSUFBSSxHQUFZLEtBQUssQ0FBQztBQUszQixnQkFBSSxDQUFDLEdBQUcsR0FBRyxNQUFNLENBQUMsR0FBRyxDQUFDO0FBQ3RCLGdCQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztBQUN6QixnQkFBSSxDQUFDLElBQUksR0FBRyxRQUFRLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLENBQUM7U0FDL0M7O0FBWkgsZ0JBQUEsV0FjRSxNQUFNLEdBQUEsZ0JBQUMsSUFBeUIsRUFBQTtBQUM5QixnQkFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7QUFDckIsZ0JBQUksQ0FBQyxRQUFRLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNyRCxnQkFBSSxDQUFDLFFBQVEsQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO1NBQ3BEOztBQWxCSCxnQkFBQSxXQW9CRSxZQUFZLEdBQUEsd0JBQUE7QUFDVixtQkFBTyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7U0FDdkI7O0FBdEJILGdCQUFBLFdBd0JFLEtBQUssR0FBQSxpQkFBQTtBQUNILGdCQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztBQUN0QixnQkFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUM7U0FDbkI7O2VBM0JILFFBQUE7b0JBbENxQixRQUFROzs7O1FBZ0U3QixrQkFBQTtBQVFFLGlCQVJGLGtCQUFBLENBUWMsUUFBd0IsRUFBQTtBQUg1QixnQkFBQSxDQUFBLEdBQUcsR0FBRyxhQXJFdUIsSUFBSSxFQXFFWCxDQUFDO0FBQ3ZCLGdCQUFBLENBQUEsSUFBSSxHQUFHLGlCQXRFUixVQUFVLEVBc0V3QixDQUFDO0FBR3hDLGdCQUFJLENBQUMsR0FBRyxHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7QUFDeEIsZ0JBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1NBQzFCOztBQVhILDBCQUFBLFdBYUUsT0FBTyxHQUFBLG1CQUFBO0FBQ0wsZ0JBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLEVBQUUsQ0FBQztBQUN2RCxtQkFBTyxRQUFRLENBQUMsT0FBTyxFQUFFLENBQUM7U0FDM0I7O0FBaEJILDBCQUFBLFdBa0JFLE9BQU8sR0FBQSxtQkFBQTtBQUNMLGdCQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxFQUFFLENBQUM7QUFDeEQsZ0JBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO0FBRXJCLG1CQUFPLFFBQVEsQ0FBQztTQUNqQjs7QUF2QkgsMEJBQUEsV0F5QkUsR0FBRyxHQUFBLGFBQUMsR0FBVyxFQUFBO0FBQ2IsbUJBQU8sQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7U0FDeEI7O0FBM0JILDBCQUFBLFdBNkJFLEdBQUcsR0FBQSxhQUFDLEdBQVcsRUFBQTtBQUNiLG1CQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7U0FDdEI7O0FBL0JILDBCQUFBLFdBaUNFLE9BQU8sR0FBQSxpQkFBQyxHQUFXLEVBQUE7QUFDakIsZ0JBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDekIsbUJBQU8sSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUM7U0FDMUI7O0FBcENILDBCQUFBLFdBc0NFLE1BQU0sR0FBQSxnQkFBQyxJQUF5QixFQUFBO2dCQUN4QixHQUFHLEdBQXFCLElBQUksQ0FBNUIsR0FBRztnQkFBRSxJQUFJLEdBQWUsSUFBSSxDQUF2QixJQUFJO2dCQUFFLFFBQVEsR0FBSyxJQUFJLENBQWpCLFFBQVE7O0FBQ3pCLGdCQUFJLElBQUksR0FBRyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLElBQUksUUFBUSxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUV4RCxnQkFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUNsQixtQkFBTyxJQUFJLENBQUM7U0FDYjs7QUE1Q0gsMEJBQUEsV0E4Q0UsWUFBWSxHQUFBLHNCQUFDLElBQXlCLEVBQUUsU0FBbUIsRUFBQTtnQkFDbkQsR0FBRyxHQUFxQixJQUFJLENBQTVCLEdBQUc7Z0JBQUUsSUFBSSxHQUFlLElBQUksQ0FBdkIsSUFBSTtnQkFBRSxRQUFRLEdBQUssSUFBSSxDQUFqQixRQUFROztBQUV6QixnQkFBSSxJQUFJLEdBQUcsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxJQUFJLFFBQVEsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDeEQsZ0JBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO0FBQ3JCLGdCQUFJLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxTQUFTLENBQUMsQ0FBQztBQUNuQyxtQkFBTyxJQUFJLENBQUM7U0FDYjs7QUFyREgsMEJBQUEsV0F1REUsSUFBSSxHQUFBLGNBQUMsSUFBYyxFQUFFLFNBQW1CLEVBQUE7Z0JBQ2hDLElBQUksR0FBSyxJQUFJLENBQWIsSUFBSTs7QUFFVixnQkFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7QUFDckIsZ0JBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDbEIsZ0JBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLFNBQVMsQ0FBQyxDQUFDO1NBQ3BDOztBQTdESCwwQkFBQSxXQStERSxNQUFNLEdBQUEsZ0JBQUMsSUFBYyxFQUFBO2dCQUNiLElBQUksR0FBSyxJQUFJLENBQWIsSUFBSTs7QUFFVixnQkFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUNsQixtQkFBTyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUMzQjs7QUFwRUgsMEJBQUEsV0FzRUUsUUFBUSxHQUFBLGtCQUFDLElBQWMsRUFBQTtBQUNyQixtQkFBTyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUNqQzs7QUF4RUgsMEJBQUEsV0EwRUUsSUFBSSxHQUFBLGdCQUFBO0FBQ0YsbUJBQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztTQUN6Qjs7ZUE1RUgsa0JBQUE7Ozs7O1FBK0VBLGlCQUFBOzs7O0FBTUUsaUJBTkYsaUJBQUEsQ0FNYyxRQUF3QixFQUFBO0FBSjVCLGdCQUFBLENBQUEsUUFBUSxHQUFtQixJQUFJLENBQUM7QUFLdEMsZ0JBQUksU0FBUyxHQUFHLElBQUksa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7QUFDakQsZ0JBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO1NBQzVCOztBQVRILHlCQUFBLFdBV0UsSUFBSSxHQUFBLGdCQUFBO2dCQUNJLFNBQVMsR0FBSyxJQUFJLENBQWxCLFNBQVM7O0FBRWYsZ0JBQUksUUFBUSxHQUFJLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsSUFBSSxTQUFTLENBQUMsT0FBTyxFQUFFLEFBQUMsQ0FBQztBQUV0RSxnQkFBSSxJQUFJLEdBQUcsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDO0FBRTNCLGdCQUFJLENBQUMsSUFBSSxFQUFFLE9BQU8sSUFBSSxDQUFDO0FBRXZCLG1CQUFPLFNBQVMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDL0I7O2VBckJILGlCQUFBOzs7OztBQXFDQSxRQUFLLEtBSUosQ0FBQTtBQUpELEtBQUEsVUFBSyxLQUFLLEVBQUE7QUFDUixhQUFBLENBQUEsS0FBQSxDQUFBLFFBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxHQUFBLFFBQU0sQ0FBQTtBQUNOLGFBQUEsQ0FBQSxLQUFBLENBQUEsT0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLEdBQUEsT0FBSyxDQUFBO0FBQ0wsYUFBQSxDQUFBLEtBQUEsQ0FBQSxNQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsR0FBQSxNQUFJLENBQUE7S0FDTCxDQUFBLENBSkksS0FBSyxLQUFMLEtBQUssR0FBQSxFQUFBLENBQUEsQ0FBQSxDQUlUOztRQUVELG9CQUFBO0FBTUUsaUJBTkYsb0JBQUEsQ0FNYyxJQUFrRCxFQUFBO2dCQUFoRCxNQUFNLEdBQVIsSUFBa0QsQ0FBaEQsTUFBTTtnQkFBRSxTQUFTLEdBQW5CLElBQWtELENBQXhDLFNBQVM7O0FBQzdCLGdCQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztBQUNyQixnQkFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7QUFDM0IsZ0JBQUksQ0FBQyxRQUFRLEdBQUcsU0FBUyxDQUFDLE9BQU8sRUFBRSxDQUFDO0FBQ3BDLGdCQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztTQUNqQzs7QUFYSCw0QkFBQSxXQWFFLElBQUksR0FBQSxnQkFBQTtBQUNGLGdCQUFJLEtBQUssR0FBVSxLQUFLLENBQUMsTUFBTSxDQUFDO0FBRWhDLG1CQUFPLElBQUksRUFBRTtBQUNYLHdCQUFRLEtBQUs7QUFDWCx5QkFBSyxLQUFLLENBQUMsTUFBTTtBQUFFLDZCQUFLLEdBQUcsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDO0FBQUMsOEJBQU07QUFBQSxBQUNwRCx5QkFBSyxLQUFLLENBQUMsS0FBSztBQUFFLDZCQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO0FBQUMsOEJBQU07QUFBQSxBQUNsRCx5QkFBSyxLQUFLLENBQUMsSUFBSTtBQUFFLDRCQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7QUFBQywrQkFBTztBQUFBLGlCQUMxQzthQUNGO1NBQ0Y7O0FBdkJILDRCQUFBLFdBeUJVLFlBQVksR0FBQSxzQkFBQyxHQUFXLEVBQUE7Z0JBQ3hCLE9BQU8sR0FBZ0IsSUFBSSxDQUEzQixPQUFPO2dCQUFFLFNBQVMsR0FBSyxJQUFJLENBQWxCLFNBQVM7O0FBRXhCLGdCQUFJLElBQUksR0FBRyxPQUFPLENBQUM7QUFFbkIsbUJBQU8sSUFBSSxJQUFJLElBQUksQ0FBQyxHQUFHLEtBQUssR0FBRyxFQUFFO0FBQy9CLG9CQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztBQUNqQixvQkFBSSxHQUFHLFNBQVMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7YUFDakM7QUFFRCxnQkFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLElBQUksU0FBUyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUNqRDs7QUFwQ0gsNEJBQUEsV0FzQ1UsVUFBVSxHQUFBLHNCQUFBO2dCQUNWLFFBQVEsR0FBeUIsSUFBSSxDQUFyQyxRQUFRO2dCQUFFLE9BQU8sR0FBZ0IsSUFBSSxDQUEzQixPQUFPO2dCQUFFLFNBQVMsR0FBSyxJQUFJLENBQWxCLFNBQVM7O0FBRWxDLGdCQUFJLElBQUksR0FBRyxRQUFRLENBQUMsSUFBSSxFQUFFLENBQUM7QUFFM0IsZ0JBQUksSUFBSSxLQUFLLElBQUksRUFBRTtBQUNqQix1QkFBTyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7YUFDMUI7Z0JBRUssR0FBRyxHQUFLLElBQUksQ0FBWixHQUFHOztBQUVULGdCQUFJLE9BQU8sSUFBSSxPQUFPLENBQUMsR0FBRyxLQUFLLEdBQUcsRUFBRTtBQUNsQyxvQkFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQzthQUN2QixNQUFNLElBQUksU0FBUyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsRUFBRTtBQUM3QixvQkFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQzthQUNyQixNQUFNO0FBQ0wsb0JBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUM7YUFDdkI7QUFFRCxtQkFBTyxLQUFLLENBQUMsTUFBTSxDQUFDO1NBQ3JCOztBQTFESCw0QkFBQSxXQTREVSxVQUFVLEdBQUEsb0JBQUMsSUFBeUIsRUFBQTtnQkFDcEMsU0FBUyxHQUFjLElBQUksQ0FBM0IsU0FBUztnQkFBRSxPQUFPLEdBQUssSUFBSSxDQUFoQixPQUFPOztBQUV4QixtQkFBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUNyQixnQkFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQzNDLGdCQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1NBQzNEOztBQWxFSCw0QkFBQSxXQW9FVSxRQUFRLEdBQUEsa0JBQUMsSUFBeUIsRUFBQTtnQkFDbEMsT0FBTyxHQUF3QixJQUFJLENBQW5DLE9BQU87Z0JBQUUsU0FBUyxHQUFhLElBQUksQ0FBMUIsU0FBUztnQkFBRSxNQUFNLEdBQUssSUFBSSxDQUFmLE1BQU07Z0JBQzFCLEdBQUcsR0FBSyxJQUFJLENBQVosR0FBRzs7QUFFVCxnQkFBSSxLQUFLLEdBQUcsU0FBUyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDcEMsaUJBQUssQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7QUFFbkIsZ0JBQUksU0FBUyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUU7QUFDL0IseUJBQVMsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQy9CLHNCQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLE9BQU8sR0FBRyxPQUFPLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxDQUFDO2FBQy9FLE1BQU07QUFDTCxvQkFBSSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQzthQUN4QjtTQUNGOztBQWpGSCw0QkFBQSxXQW1GVSxVQUFVLEdBQUEsb0JBQUMsSUFBeUIsRUFBQTtnQkFDcEMsU0FBUyxHQUFzQixJQUFJLENBQW5DLFNBQVM7Z0JBQUUsTUFBTSxHQUFjLElBQUksQ0FBeEIsTUFBTTtnQkFBRSxPQUFPLEdBQUssSUFBSSxDQUFoQixPQUFPOztBQUVoQyxnQkFBSSxJQUFJLEdBQUcsU0FBUyxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDakQsa0JBQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLEVBQUUsT0FBTyxHQUFHLE9BQU8sQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLENBQUM7U0FDOUU7O0FBeEZILDRCQUFBLFdBMEZVLFVBQVUsR0FBQSxzQkFBQTtBQUNoQixnQkFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxDQUFDO0FBQ3JDLG1CQUFPLEtBQUssQ0FBQyxLQUFLLENBQUM7U0FDcEI7O0FBN0ZILDRCQUFBLFdBK0ZVLFNBQVMsR0FBQSxxQkFBQTtnQkFDVCxTQUFTLEdBQXNCLElBQUksQ0FBbkMsU0FBUztnQkFBRSxNQUFNLEdBQWMsSUFBSSxDQUF4QixNQUFNO2dCQUFFLE9BQU8sR0FBSyxJQUFJLENBQWhCLE9BQU87O0FBRWhDLGdCQUFJLE9BQU8sS0FBSyxJQUFJLEVBQUU7QUFDcEIsdUJBQU8sS0FBSyxDQUFDLElBQUksQ0FBQzthQUNuQjtBQUVELGdCQUFJLElBQUksR0FBRyxPQUFPLENBQUM7QUFDbkIsZ0JBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUV4QyxnQkFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLEVBQUU7QUFDdkIseUJBQVMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDdkIsc0JBQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2FBQ3pCLE1BQU07QUFDTCxvQkFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO2FBQ2Q7QUFFRCxtQkFBTyxLQUFLLENBQUMsS0FBSyxDQUFDO1NBQ3BCOztBQWpISCw0QkFBQSxXQW1IVSxRQUFRLEdBQUEsb0JBQUE7QUFDZCxnQkFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FBQztTQUNwQjs7ZUFySEgsb0JBQUEiLCJmaWxlIjoiaXRlcmFibGUuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBMaW5rZWRMaXN0LCBMaXN0Tm9kZSwgT3BhcXVlLCBkaWN0IH0gZnJvbSAnZ2xpbW1lci11dGlsJztcbmltcG9ydCB7IFZlcnNpb25lZFBhdGhSZWZlcmVuY2UgYXMgUGF0aFJlZmVyZW5jZSwgUmV2aXNpb25UYWcgfSBmcm9tICcuL3ZhbGlkYXRvcnMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEl0ZXJhdGlvbkl0ZW08VCwgVT4ge1xuICBrZXk6IHN0cmluZztcbiAgdmFsdWU6IFQ7XG4gIG1lbW86IFU7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWJzdHJhY3RJdGVyYXRvcjxULCBVLCBWIGV4dGVuZHMgSXRlcmF0aW9uSXRlbTxULCBVPj4ge1xuICBpc0VtcHR5KCk6IGJvb2xlYW47XG4gIG5leHQoKTogVjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBYnN0cmFjdEl0ZXJhYmxlPFQsIFUsIEl0ZW1UeXBlIGV4dGVuZHMgSXRlcmF0aW9uSXRlbTxULCBVPiwgVmFsdWVSZWZlcmVuY2VUeXBlIGV4dGVuZHMgUGF0aFJlZmVyZW5jZTxUPiwgTWVtb1JlZmVyZW5jZVR5cGUgZXh0ZW5kcyBQYXRoUmVmZXJlbmNlPFU+PiB7XG4gIHRhZzogUmV2aXNpb25UYWc7XG4gIGl0ZXJhdGUoKTogQWJzdHJhY3RJdGVyYXRvcjxULCBVLCBJdGVtVHlwZT47XG5cbiAgdmFsdWVSZWZlcmVuY2VGb3IoaXRlbTogSXRlbVR5cGUpOiBWYWx1ZVJlZmVyZW5jZVR5cGU7XG4gIHVwZGF0ZVZhbHVlUmVmZXJlbmNlKHJlZmVyZW5jZTogVmFsdWVSZWZlcmVuY2VUeXBlLCBpdGVtOiBJdGVtVHlwZSk7XG5cbiAgbWVtb1JlZmVyZW5jZUZvcihpdGVtOiBJdGVtVHlwZSk6IE1lbW9SZWZlcmVuY2VUeXBlO1xuICB1cGRhdGVNZW1vUmVmZXJlbmNlKHJlZmVyZW5jZTogTWVtb1JlZmVyZW5jZVR5cGUsIGl0ZW06IEl0ZW1UeXBlKTtcbn1cblxuZXhwb3J0IHR5cGUgSXRlcmF0b3I8VCwgVT4gPSBBYnN0cmFjdEl0ZXJhdG9yPFQsIFUsIEl0ZXJhdGlvbkl0ZW08VCwgVT4+O1xuZXhwb3J0IHR5cGUgSXRlcmFibGU8VCwgVT4gPSBBYnN0cmFjdEl0ZXJhYmxlPFQsIFUsIEl0ZXJhdGlvbkl0ZW08VCwgVT4sIFBhdGhSZWZlcmVuY2U8VD4sIFBhdGhSZWZlcmVuY2U8VT4+O1xuXG5leHBvcnQgdHlwZSBPcGFxdWVJdGVyYXRpb25JdGVtID0gSXRlcmF0aW9uSXRlbTxPcGFxdWUsIE9wYXF1ZT47XG5leHBvcnQgdHlwZSBPcGFxdWVJdGVyYXRvciA9IEFic3RyYWN0SXRlcmF0b3I8T3BhcXVlLCBPcGFxdWUsIE9wYXF1ZUl0ZXJhdGlvbkl0ZW0+O1xuZXhwb3J0IHR5cGUgT3BhcXVlUGF0aFJlZmVyZW5jZSA9IFBhdGhSZWZlcmVuY2U8T3BhcXVlPjtcbmV4cG9ydCB0eXBlIE9wYXF1ZUl0ZXJhYmxlID0gQWJzdHJhY3RJdGVyYWJsZTxPcGFxdWUsIE9wYXF1ZSwgT3BhcXVlSXRlcmF0aW9uSXRlbSwgT3BhcXVlUGF0aFJlZmVyZW5jZSwgT3BhcXVlUGF0aFJlZmVyZW5jZT47XG5leHBvcnQgdHlwZSBPcGFxdWVQYXRoUmVmZXJlbmNlSXRlcmF0aW9uSXRlbSA9IEl0ZXJhdGlvbkl0ZW08T3BhcXVlUGF0aFJlZmVyZW5jZSwgT3BhcXVlUGF0aFJlZmVyZW5jZT47XG5cbmV4cG9ydCBjbGFzcyBMaXN0SXRlbSBleHRlbmRzIExpc3ROb2RlPE9wYXF1ZVBhdGhSZWZlcmVuY2U+IGltcGxlbWVudHMgT3BhcXVlSXRlcmF0aW9uSXRlbSB7XG4gIHB1YmxpYyBrZXk6IHN0cmluZztcbiAgcHVibGljIG1lbW86IE9wYXF1ZVBhdGhSZWZlcmVuY2U7XG4gIHB1YmxpYyByZXRhaW5lZDogYm9vbGVhbiA9IGZhbHNlO1xuICBwdWJsaWMgc2VlbjogYm9vbGVhbiA9IGZhbHNlO1xuICBwcml2YXRlIGl0ZXJhYmxlOiBPcGFxdWVJdGVyYWJsZTtcblxuICBjb25zdHJ1Y3RvcihpdGVyYWJsZTogT3BhcXVlSXRlcmFibGUsIHJlc3VsdDogT3BhcXVlSXRlcmF0aW9uSXRlbSkge1xuICAgIHN1cGVyKGl0ZXJhYmxlLnZhbHVlUmVmZXJlbmNlRm9yKHJlc3VsdCkpO1xuICAgIHRoaXMua2V5ID0gcmVzdWx0LmtleTtcbiAgICB0aGlzLml0ZXJhYmxlID0gaXRlcmFibGU7XG4gICAgdGhpcy5tZW1vID0gaXRlcmFibGUubWVtb1JlZmVyZW5jZUZvcihyZXN1bHQpO1xuICB9XG5cbiAgdXBkYXRlKGl0ZW06IE9wYXF1ZUl0ZXJhdGlvbkl0ZW0pIHtcbiAgICB0aGlzLnJldGFpbmVkID0gdHJ1ZTtcbiAgICB0aGlzLml0ZXJhYmxlLnVwZGF0ZVZhbHVlUmVmZXJlbmNlKHRoaXMudmFsdWUsIGl0ZW0pO1xuICAgIHRoaXMuaXRlcmFibGUudXBkYXRlTWVtb1JlZmVyZW5jZSh0aGlzLm1lbW8sIGl0ZW0pO1xuICB9XG5cbiAgc2hvdWxkUmVtb3ZlKCk6IGJvb2xlYW4ge1xuICAgIHJldHVybiAhdGhpcy5yZXRhaW5lZDtcbiAgfVxuXG4gIHJlc2V0KCkge1xuICAgIHRoaXMucmV0YWluZWQgPSBmYWxzZTtcbiAgICB0aGlzLnNlZW4gPSBmYWxzZTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgSXRlcmF0aW9uQXJ0aWZhY3RzIHtcbiAgcHVibGljIHRhZzogUmV2aXNpb25UYWc7XG5cbiAgcHJpdmF0ZSBpdGVyYWJsZTogT3BhcXVlSXRlcmFibGU7XG4gIHByaXZhdGUgaXRlcmF0b3I6IE9wYXF1ZUl0ZXJhdG9yO1xuICBwcml2YXRlIG1hcCA9IGRpY3Q8TGlzdEl0ZW0+KCk7XG4gIHByaXZhdGUgbGlzdCA9IG5ldyBMaW5rZWRMaXN0PExpc3RJdGVtPigpO1xuXG4gIGNvbnN0cnVjdG9yKGl0ZXJhYmxlOiBPcGFxdWVJdGVyYWJsZSkge1xuICAgIHRoaXMudGFnID0gaXRlcmFibGUudGFnO1xuICAgIHRoaXMuaXRlcmFibGUgPSBpdGVyYWJsZTtcbiAgfVxuXG4gIGlzRW1wdHkoKTogYm9vbGVhbiB7XG4gICAgbGV0IGl0ZXJhdG9yID0gdGhpcy5pdGVyYXRvciA9IHRoaXMuaXRlcmFibGUuaXRlcmF0ZSgpO1xuICAgIHJldHVybiBpdGVyYXRvci5pc0VtcHR5KCk7XG4gIH1cblxuICBpdGVyYXRlKCk6IE9wYXF1ZUl0ZXJhdG9yIHtcbiAgICBsZXQgaXRlcmF0b3IgPSB0aGlzLml0ZXJhdG9yIHx8IHRoaXMuaXRlcmFibGUuaXRlcmF0ZSgpO1xuICAgIHRoaXMuaXRlcmF0b3IgPSBudWxsO1xuXG4gICAgcmV0dXJuIGl0ZXJhdG9yO1xuICB9XG5cbiAgaGFzKGtleTogc3RyaW5nKTogYm9vbGVhbiB7XG4gICAgcmV0dXJuICEhdGhpcy5tYXBba2V5XTtcbiAgfVxuXG4gIGdldChrZXk6IHN0cmluZyk6IExpc3RJdGVtIHtcbiAgICByZXR1cm4gdGhpcy5tYXBba2V5XTtcbiAgfVxuXG4gIHdhc1NlZW4oa2V5OiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICBsZXQgbm9kZSA9IHRoaXMubWFwW2tleV07XG4gICAgcmV0dXJuIG5vZGUgJiYgbm9kZS5zZWVuO1xuICB9XG5cbiAgYXBwZW5kKGl0ZW06IE9wYXF1ZUl0ZXJhdGlvbkl0ZW0pOiBMaXN0SXRlbSB7XG4gICAgbGV0IHsgbWFwLCBsaXN0LCBpdGVyYWJsZSB9ID0gdGhpcztcbiAgICBsZXQgbm9kZSA9IG1hcFtpdGVtLmtleV0gPSBuZXcgTGlzdEl0ZW0oaXRlcmFibGUsIGl0ZW0pO1xuXG4gICAgbGlzdC5hcHBlbmQobm9kZSk7XG4gICAgcmV0dXJuIG5vZGU7XG4gIH1cblxuICBpbnNlcnRCZWZvcmUoaXRlbTogT3BhcXVlSXRlcmF0aW9uSXRlbSwgcmVmZXJlbmNlOiBMaXN0SXRlbSk6IExpc3RJdGVtIHtcbiAgICBsZXQgeyBtYXAsIGxpc3QsIGl0ZXJhYmxlIH0gPSB0aGlzO1xuXG4gICAgbGV0IG5vZGUgPSBtYXBbaXRlbS5rZXldID0gbmV3IExpc3RJdGVtKGl0ZXJhYmxlLCBpdGVtKTtcbiAgICBub2RlLnJldGFpbmVkID0gdHJ1ZTtcbiAgICBsaXN0Lmluc2VydEJlZm9yZShub2RlLCByZWZlcmVuY2UpO1xuICAgIHJldHVybiBub2RlO1xuICB9XG5cbiAgbW92ZShpdGVtOiBMaXN0SXRlbSwgcmVmZXJlbmNlOiBMaXN0SXRlbSk6IHZvaWQge1xuICAgIGxldCB7IGxpc3QgfSA9IHRoaXM7XG5cbiAgICBpdGVtLnJldGFpbmVkID0gdHJ1ZTtcbiAgICBsaXN0LnJlbW92ZShpdGVtKTtcbiAgICBsaXN0Lmluc2VydEJlZm9yZShpdGVtLCByZWZlcmVuY2UpO1xuICB9XG5cbiAgcmVtb3ZlKGl0ZW06IExpc3RJdGVtKTogdm9pZCB7XG4gICAgbGV0IHsgbGlzdCB9ID0gdGhpcztcblxuICAgIGxpc3QucmVtb3ZlKGl0ZW0pO1xuICAgIGRlbGV0ZSB0aGlzLm1hcFtpdGVtLmtleV07XG4gIH1cblxuICBuZXh0Tm9kZShpdGVtOiBMaXN0SXRlbSk6IExpc3RJdGVtIHtcbiAgICByZXR1cm4gdGhpcy5saXN0Lm5leHROb2RlKGl0ZW0pO1xuICB9XG5cbiAgaGVhZCgpOiBMaXN0SXRlbSB7XG4gICAgcmV0dXJuIHRoaXMubGlzdC5oZWFkKCk7XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFJlZmVyZW5jZUl0ZXJhdG9yIHtcbiAgcHVibGljIGFydGlmYWN0czogSXRlcmF0aW9uQXJ0aWZhY3RzO1xuICBwcml2YXRlIGl0ZXJhdG9yOiBPcGFxdWVJdGVyYXRvciA9IG51bGw7XG5cbiAgLy8gaWYgYW55b25lIG5lZWRzIHRvIGNvbnN0cnVjdCB0aGlzIG9iamVjdCB3aXRoIHNvbWV0aGluZyBvdGhlciB0aGFuXG4gIC8vIGFuIGl0ZXJhYmxlLCBsZXQgQHd5Y2F0cyBrbm93LlxuICBjb25zdHJ1Y3RvcihpdGVyYWJsZTogT3BhcXVlSXRlcmFibGUpIHtcbiAgICBsZXQgYXJ0aWZhY3RzID0gbmV3IEl0ZXJhdGlvbkFydGlmYWN0cyhpdGVyYWJsZSk7XG4gICAgdGhpcy5hcnRpZmFjdHMgPSBhcnRpZmFjdHM7XG4gIH1cblxuICBuZXh0KCk6IExpc3RJdGVtIHtcbiAgICBsZXQgeyBhcnRpZmFjdHMgfSA9IHRoaXM7XG5cbiAgICBsZXQgaXRlcmF0b3IgPSAodGhpcy5pdGVyYXRvciA9IHRoaXMuaXRlcmF0b3IgfHwgYXJ0aWZhY3RzLml0ZXJhdGUoKSk7XG5cbiAgICBsZXQgaXRlbSA9IGl0ZXJhdG9yLm5leHQoKTtcblxuICAgIGlmICghaXRlbSkgcmV0dXJuIG51bGw7XG5cbiAgICByZXR1cm4gYXJ0aWZhY3RzLmFwcGVuZChpdGVtKTtcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEl0ZXJhdG9yU3luY2hyb25pemVyRGVsZWdhdGUge1xuICByZXRhaW4oa2V5OiBzdHJpbmcsIGl0ZW06IFBhdGhSZWZlcmVuY2U8T3BhcXVlPiwgbWVtbzogUGF0aFJlZmVyZW5jZTxPcGFxdWU+KTtcbiAgaW5zZXJ0KGtleTogc3RyaW5nLCBpdGVtOiBQYXRoUmVmZXJlbmNlPE9wYXF1ZT4sIG1lbW86IFBhdGhSZWZlcmVuY2U8T3BhcXVlPiwgYmVmb3JlOiBzdHJpbmcpO1xuICBtb3ZlKGtleTogc3RyaW5nLCBpdGVtOiBQYXRoUmVmZXJlbmNlPE9wYXF1ZT4sIG1lbW86IFBhdGhSZWZlcmVuY2U8T3BhcXVlPiwgYmVmb3JlOiBzdHJpbmcpO1xuICBkZWxldGUoa2V5OiBzdHJpbmcpO1xuICBkb25lKCk7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSXRlcmF0b3JTeW5jaHJvbml6ZXJPcHRpb25zIHtcbiAgdGFyZ2V0OiBJdGVyYXRvclN5bmNocm9uaXplckRlbGVnYXRlO1xuICBhcnRpZmFjdHM6IEl0ZXJhdGlvbkFydGlmYWN0cztcbn1cblxuZW51bSBQaGFzZSB7XG4gIEFwcGVuZCxcbiAgUHJ1bmUsXG4gIERvbmVcbn1cblxuZXhwb3J0IGNsYXNzIEl0ZXJhdG9yU3luY2hyb25pemVyIHtcbiAgcHJpdmF0ZSB0YXJnZXQ6IEl0ZXJhdG9yU3luY2hyb25pemVyRGVsZWdhdGU7XG4gIHByaXZhdGUgaXRlcmF0b3I6IE9wYXF1ZUl0ZXJhdG9yO1xuICBwcml2YXRlIGN1cnJlbnQ6IExpc3RJdGVtO1xuICBwcml2YXRlIGFydGlmYWN0czogSXRlcmF0aW9uQXJ0aWZhY3RzO1xuXG4gIGNvbnN0cnVjdG9yKHsgdGFyZ2V0LCBhcnRpZmFjdHMgfTogSXRlcmF0b3JTeW5jaHJvbml6ZXJPcHRpb25zKSB7XG4gICAgdGhpcy50YXJnZXQgPSB0YXJnZXQ7XG4gICAgdGhpcy5hcnRpZmFjdHMgPSBhcnRpZmFjdHM7XG4gICAgdGhpcy5pdGVyYXRvciA9IGFydGlmYWN0cy5pdGVyYXRlKCk7XG4gICAgdGhpcy5jdXJyZW50ID0gYXJ0aWZhY3RzLmhlYWQoKTtcbiAgfVxuXG4gIHN5bmMoKSB7XG4gICAgbGV0IHBoYXNlOiBQaGFzZSA9IFBoYXNlLkFwcGVuZDtcblxuICAgIHdoaWxlICh0cnVlKSB7XG4gICAgICBzd2l0Y2ggKHBoYXNlKSB7XG4gICAgICAgIGNhc2UgUGhhc2UuQXBwZW5kOiBwaGFzZSA9IHRoaXMubmV4dEFwcGVuZCgpOyBicmVhaztcbiAgICAgICAgY2FzZSBQaGFzZS5QcnVuZTogcGhhc2UgPSB0aGlzLm5leHRQcnVuZSgpOyBicmVhaztcbiAgICAgICAgY2FzZSBQaGFzZS5Eb25lOiB0aGlzLm5leHREb25lKCk7IHJldHVybjtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGFkdmFuY2VUb0tleShrZXk6IHN0cmluZykge1xuICAgIGxldCB7IGN1cnJlbnQsIGFydGlmYWN0cyB9ID0gdGhpcztcblxuICAgIGxldCBzZWVrID0gY3VycmVudDtcblxuICAgIHdoaWxlIChzZWVrICYmIHNlZWsua2V5ICE9PSBrZXkpIHtcbiAgICAgIHNlZWsuc2VlbiA9IHRydWU7XG4gICAgICBzZWVrID0gYXJ0aWZhY3RzLm5leHROb2RlKHNlZWspO1xuICAgIH1cblxuICAgIHRoaXMuY3VycmVudCA9IHNlZWsgJiYgYXJ0aWZhY3RzLm5leHROb2RlKHNlZWspO1xuICB9XG5cbiAgcHJpdmF0ZSBuZXh0QXBwZW5kKCk6IFBoYXNlIHtcbiAgICBsZXQgeyBpdGVyYXRvciwgY3VycmVudCwgYXJ0aWZhY3RzIH0gPSB0aGlzO1xuXG4gICAgbGV0IGl0ZW0gPSBpdGVyYXRvci5uZXh0KCk7XG5cbiAgICBpZiAoaXRlbSA9PT0gbnVsbCkge1xuICAgICAgcmV0dXJuIHRoaXMuc3RhcnRQcnVuZSgpO1xuICAgIH1cblxuICAgIGxldCB7IGtleSB9ID0gaXRlbTtcblxuICAgIGlmIChjdXJyZW50ICYmIGN1cnJlbnQua2V5ID09PSBrZXkpIHtcbiAgICAgIHRoaXMubmV4dFJldGFpbihpdGVtKTtcbiAgICB9IGVsc2UgaWYgKGFydGlmYWN0cy5oYXMoa2V5KSkge1xuICAgICAgdGhpcy5uZXh0TW92ZShpdGVtKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5uZXh0SW5zZXJ0KGl0ZW0pO1xuICAgIH1cblxuICAgIHJldHVybiBQaGFzZS5BcHBlbmQ7XG4gIH1cblxuICBwcml2YXRlIG5leHRSZXRhaW4oaXRlbTogT3BhcXVlSXRlcmF0aW9uSXRlbSkge1xuICAgIGxldCB7IGFydGlmYWN0cywgY3VycmVudCB9ID0gdGhpcztcblxuICAgIGN1cnJlbnQudXBkYXRlKGl0ZW0pO1xuICAgIHRoaXMuY3VycmVudCA9IGFydGlmYWN0cy5uZXh0Tm9kZShjdXJyZW50KTtcbiAgICB0aGlzLnRhcmdldC5yZXRhaW4oaXRlbS5rZXksIGN1cnJlbnQudmFsdWUsIGN1cnJlbnQubWVtbyk7XG4gIH1cblxuICBwcml2YXRlIG5leHRNb3ZlKGl0ZW06IE9wYXF1ZUl0ZXJhdGlvbkl0ZW0pIHtcbiAgICBsZXQgeyBjdXJyZW50LCBhcnRpZmFjdHMsIHRhcmdldCB9ID0gdGhpcztcbiAgICBsZXQgeyBrZXkgfSA9IGl0ZW07XG5cbiAgICBsZXQgZm91bmQgPSBhcnRpZmFjdHMuZ2V0KGl0ZW0ua2V5KTtcbiAgICBmb3VuZC51cGRhdGUoaXRlbSk7XG5cbiAgICBpZiAoYXJ0aWZhY3RzLndhc1NlZW4oaXRlbS5rZXkpKSB7XG4gICAgICBhcnRpZmFjdHMubW92ZShmb3VuZCwgY3VycmVudCk7XG4gICAgICB0YXJnZXQubW92ZShmb3VuZC5rZXksIGZvdW5kLnZhbHVlLCBmb3VuZC5tZW1vLCBjdXJyZW50ID8gY3VycmVudC5rZXkgOiBudWxsKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5hZHZhbmNlVG9LZXkoa2V5KTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIG5leHRJbnNlcnQoaXRlbTogT3BhcXVlSXRlcmF0aW9uSXRlbSkge1xuICAgIGxldCB7IGFydGlmYWN0cywgdGFyZ2V0LCBjdXJyZW50IH0gPSB0aGlzO1xuXG4gICAgbGV0IG5vZGUgPSBhcnRpZmFjdHMuaW5zZXJ0QmVmb3JlKGl0ZW0sIGN1cnJlbnQpO1xuICAgIHRhcmdldC5pbnNlcnQobm9kZS5rZXksIG5vZGUudmFsdWUsIG5vZGUubWVtbywgY3VycmVudCA/IGN1cnJlbnQua2V5IDogbnVsbCk7XG4gIH1cblxuICBwcml2YXRlIHN0YXJ0UHJ1bmUoKTogUGhhc2Uge1xuICAgIHRoaXMuY3VycmVudCA9IHRoaXMuYXJ0aWZhY3RzLmhlYWQoKTtcbiAgICByZXR1cm4gUGhhc2UuUHJ1bmU7XG4gIH1cblxuICBwcml2YXRlIG5leHRQcnVuZSgpOiBQaGFzZSB7XG4gICAgbGV0IHsgYXJ0aWZhY3RzLCB0YXJnZXQsIGN1cnJlbnQgfSA9IHRoaXM7XG5cbiAgICBpZiAoY3VycmVudCA9PT0gbnVsbCkge1xuICAgICAgcmV0dXJuIFBoYXNlLkRvbmU7XG4gICAgfVxuXG4gICAgbGV0IG5vZGUgPSBjdXJyZW50O1xuICAgIHRoaXMuY3VycmVudCA9IGFydGlmYWN0cy5uZXh0Tm9kZShub2RlKTtcblxuICAgIGlmIChub2RlLnNob3VsZFJlbW92ZSgpKSB7XG4gICAgICBhcnRpZmFjdHMucmVtb3ZlKG5vZGUpO1xuICAgICAgdGFyZ2V0LmRlbGV0ZShub2RlLmtleSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIG5vZGUucmVzZXQoKTtcbiAgICB9XG5cbiAgICByZXR1cm4gUGhhc2UuUHJ1bmU7XG4gIH1cblxuICBwcml2YXRlIG5leHREb25lKCkge1xuICAgIHRoaXMudGFyZ2V0LmRvbmUoKTtcbiAgfVxufVxuIl19
enifed("glimmer-reference/lib/reference", ["exports"], function (exports) {
  "use strict";
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcmVmZXJlbmNlL2xpYi9yZWZlcmVuY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJyZWZlcmVuY2UuanMiLCJzb3VyY2VzQ29udGVudCI6W119
enifed("glimmer-reference/lib/utils", ["exports"], function (exports) {
    "use strict";

    exports.referenceFromParts = referenceFromParts;

    function referenceFromParts(root, parts) {
        var reference = root;
        for (var i = 0; i < parts.length; i++) {
            reference = reference.get(parts[i]);
        }
        return reference;
    }
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcmVmZXJlbmNlL2xpYi91dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLGFBQUEsa0JBQUEsQ0FBbUMsSUFBb0MsRUFBRSxLQUFlLEVBQUE7QUFDdEYsWUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDO0FBRXJCLGFBQUssSUFBSSxDQUFDLEdBQUMsQ0FBQyxFQUFFLENBQUMsR0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFO0FBQ2pDLHFCQUFTLEdBQUcsU0FBUyxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztTQUNyQztBQUVELGVBQU8sU0FBUyxDQUFDO0tBQ2xCIiwiZmlsZSI6InV0aWxzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVmVyc2lvbmVkUGF0aFJlZmVyZW5jZSB9IGZyb20gJy4vdmFsaWRhdG9ycyc7XG5pbXBvcnQgeyBPcGFxdWUgfSBmcm9tICdnbGltbWVyLXV0aWwnO1xuXG5leHBvcnQgZnVuY3Rpb24gcmVmZXJlbmNlRnJvbVBhcnRzKHJvb3Q6IFZlcnNpb25lZFBhdGhSZWZlcmVuY2U8T3BhcXVlPiwgcGFydHM6IHN0cmluZ1tdKTogVmVyc2lvbmVkUGF0aFJlZmVyZW5jZTxPcGFxdWU+IHtcbiAgbGV0IHJlZmVyZW5jZSA9IHJvb3Q7XG5cbiAgZm9yIChsZXQgaT0wOyBpPHBhcnRzLmxlbmd0aDsgaSsrKSB7XG4gICAgcmVmZXJlbmNlID0gcmVmZXJlbmNlLmdldChwYXJ0c1tpXSk7XG4gIH1cblxuICByZXR1cm4gcmVmZXJlbmNlO1xufVxuIl19
enifed("glimmer-reference/lib/validators", ["exports"], function (exports) {
    "use strict";

    exports.combineTagged = combineTagged;
    exports.combineSlice = combineSlice;
    exports.combine = combine;
    exports.map = map;
    exports.isModified = isModified;
    var CONSTANT = 0;
    exports.CONSTANT = CONSTANT;
    var INITIAL = 1;
    exports.INITIAL = INITIAL;
    var VOLATILE = NaN;
    exports.VOLATILE = VOLATILE;

    var RevisionTag = (function () {
        function RevisionTag() {}

        RevisionTag.prototype.validate = function validate(snapshot) {
            return this.value() === snapshot;
        };

        return RevisionTag;
    })();

    exports.RevisionTag = RevisionTag;

    var $REVISION = INITIAL;

    var DirtyableTag = (function (_RevisionTag) {
        babelHelpers.inherits(DirtyableTag, _RevisionTag);

        function DirtyableTag() {
            var revision = arguments.length <= 0 || arguments[0] === undefined ? $REVISION : arguments[0];

            _RevisionTag.call(this);
            this.revision = revision;
        }

        DirtyableTag.prototype.value = function value() {
            return this.revision;
        };

        DirtyableTag.prototype.dirty = function dirty() {
            this.revision = ++$REVISION;
        };

        return DirtyableTag;
    })(RevisionTag);

    exports.DirtyableTag = DirtyableTag;

    function combineTagged(tagged) {
        var optimized = [];
        for (var i = 0, l = tagged.length; i < l; i++) {
            var tag = tagged[i].tag;
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag === CONSTANT_TAG) continue;
            optimized.push(tag);
        }
        return _combine(optimized);
    }

    function combineSlice(slice) {
        var optimized = [];
        var node = slice.head();
        while (node !== null) {
            var tag = node.tag;
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag !== CONSTANT_TAG) optimized.push(tag);
            node = slice.nextNode(node);
        }
        return _combine(optimized);
    }

    function combine(tags) {
        var optimized = [];
        for (var i = 0, l = tags.length; i < l; i++) {
            var tag = tags[i];
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag === CONSTANT_TAG) continue;
            optimized.push(tag);
        }
        return _combine(optimized);
    }

    function _combine(tags) {
        switch (tags.length) {
            case 0:
                return CONSTANT_TAG;
            case 1:
                return tags[0];
            case 2:
                return new TagsPair(tags[0], tags[1]);
            default:
                return new TagsCombinator(tags);
        }
        ;
    }

    var CachedTag = (function (_RevisionTag2) {
        babelHelpers.inherits(CachedTag, _RevisionTag2);

        function CachedTag() {
            _RevisionTag2.apply(this, arguments);
            this.lastChecked = null;
            this.lastValue = null;
        }

        CachedTag.prototype.value = function value() {
            var lastChecked = this.lastChecked;
            var lastValue = this.lastValue;

            if (lastChecked !== $REVISION) {
                this.lastChecked = $REVISION;
                this.lastValue = lastValue = this.compute();
            }
            return this.lastValue;
        };

        CachedTag.prototype.invalidate = function invalidate() {
            this.lastChecked = null;
        };

        return CachedTag;
    })(RevisionTag);

    exports.CachedTag = CachedTag;

    var TagsPair = (function (_CachedTag) {
        babelHelpers.inherits(TagsPair, _CachedTag);

        function TagsPair(first, second) {
            _CachedTag.call(this);
            this.first = first;
            this.second = second;
        }

        TagsPair.prototype.compute = function compute() {
            return Math.max(this.first.value(), this.second.value());
        };

        return TagsPair;
    })(CachedTag);

    var TagsCombinator = (function (_CachedTag2) {
        babelHelpers.inherits(TagsCombinator, _CachedTag2);

        function TagsCombinator(tags) {
            _CachedTag2.call(this);
            this.tags = tags;
        }

        TagsCombinator.prototype.compute = function compute() {
            var tags = this.tags;

            var max = -1;
            for (var i = 0; i < tags.length; i++) {
                var value = tags[i].value();
                max = Math.max(value, max);
            }
            return max;
        };

        return TagsCombinator;
    })(CachedTag);

    var UpdatableTag = (function (_CachedTag3) {
        babelHelpers.inherits(UpdatableTag, _CachedTag3);

        function UpdatableTag(tag) {
            _CachedTag3.call(this);
            this.tag = tag;
            this.lastUpdated = INITIAL;
        }

        //////////

        UpdatableTag.prototype.compute = function compute() {
            return Math.max(this.lastUpdated, this.tag.value());
        };

        UpdatableTag.prototype.update = function update(tag) {
            if (tag !== this.tag) {
                this.tag = tag;
                this.lastUpdated = $REVISION;
                this.invalidate();
            }
        };

        return UpdatableTag;
    })(CachedTag);

    exports.UpdatableTag = UpdatableTag;
    var CONSTANT_TAG = new ((function (_RevisionTag3) {
        babelHelpers.inherits(ConstantTag, _RevisionTag3);

        function ConstantTag() {
            _RevisionTag3.apply(this, arguments);
        }

        ConstantTag.prototype.value = function value() {
            return CONSTANT;
        };

        return ConstantTag;
    })(RevisionTag))();
    exports.CONSTANT_TAG = CONSTANT_TAG;
    var VOLATILE_TAG = new ((function (_RevisionTag4) {
        babelHelpers.inherits(VolatileTag, _RevisionTag4);

        function VolatileTag() {
            _RevisionTag4.apply(this, arguments);
        }

        VolatileTag.prototype.value = function value() {
            return VOLATILE;
        };

        return VolatileTag;
    })(RevisionTag))();
    exports.VOLATILE_TAG = VOLATILE_TAG;
    var CURRENT_TAG = new ((function (_DirtyableTag) {
        babelHelpers.inherits(CurrentTag, _DirtyableTag);

        function CurrentTag() {
            _DirtyableTag.apply(this, arguments);
        }

        CurrentTag.prototype.value = function value() {
            return $REVISION;
        };

        return CurrentTag;
    })(DirtyableTag))();
    exports.CURRENT_TAG = CURRENT_TAG;

    var CachedReference = (function () {
        function CachedReference() {
            this.lastRevision = null;
            this.lastValue = null;
        }

        CachedReference.prototype.value = function value() {
            var tag = this.tag;
            var lastRevision = this.lastRevision;
            var lastValue = this.lastValue;

            if (!lastRevision || !tag.validate(lastRevision)) {
                lastValue = this.lastValue = this.compute();
                this.lastRevision = tag.value();
            }
            return lastValue;
        };

        CachedReference.prototype.invalidate = function invalidate() {
            this.lastRevision = null;
        };

        return CachedReference;
    })();

    exports.CachedReference = CachedReference;

    var MapperReference = (function (_CachedReference) {
        babelHelpers.inherits(MapperReference, _CachedReference);

        function MapperReference(reference, mapper) {
            _CachedReference.call(this);
            this.tag = reference.tag;
            this.reference = reference;
            this.mapper = mapper;
        }

        MapperReference.prototype.compute = function compute() {
            var reference = this.reference;
            var mapper = this.mapper;

            return mapper(reference.value());
        };

        return MapperReference;
    })(CachedReference);

    function map(reference, mapper) {
        return new MapperReference(reference, mapper);
    }

    //////////

    var ReferenceCache = (function () {
        function ReferenceCache(reference) {
            this.lastValue = null;
            this.lastRevision = null;
            this.initialized = false;
            this.tag = reference.tag;
            this.reference = reference;
        }

        ReferenceCache.prototype.peek = function peek() {
            if (!this.initialized) {
                return this.initialize();
            }
            return this.lastValue;
        };

        ReferenceCache.prototype.revalidate = function revalidate() {
            if (!this.initialized) {
                return this.initialize();
            }
            var reference = this.reference;
            var lastRevision = this.lastRevision;

            var tag = reference.tag;
            if (tag.validate(lastRevision)) return NOT_MODIFIED;
            this.lastRevision = tag.value();
            var lastValue = this.lastValue;

            var value = reference.value();
            if (value === lastValue) return NOT_MODIFIED;
            this.lastValue = value;
            return value;
        };

        ReferenceCache.prototype.initialize = function initialize() {
            var reference = this.reference;

            var value = this.lastValue = reference.value();
            this.lastRevision = reference.tag.value();
            this.initialized = true;
            return value;
        };

        return ReferenceCache;
    })();

    exports.ReferenceCache = ReferenceCache;

    var NOT_MODIFIED = "adb3b78e-3d22-4e4b-877a-6317c2c5c145";

    function isModified(value) {
        return value !== NOT_MODIFIED;
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/index', ['exports', 'glimmer-runtime/lib/dom/interfaces', 'glimmer-runtime/lib/syntax', 'glimmer-runtime/lib/template', 'glimmer-runtime/lib/symbol-table', 'glimmer-runtime/lib/references', 'glimmer-runtime/lib/syntax/core', 'glimmer-runtime/lib/compiled/opcodes/builder', 'glimmer-runtime/lib/compiler', 'glimmer-runtime/lib/opcode-builder', 'glimmer-runtime/lib/compiled/blocks', 'glimmer-runtime/lib/dom/attribute-managers', 'glimmer-runtime/lib/compiled/opcodes/content', 'glimmer-runtime/lib/compiled/expressions', 'glimmer-runtime/lib/compiled/expressions/args', 'glimmer-runtime/lib/compiled/expressions/value', 'glimmer-runtime/lib/compiled/expressions/function', 'glimmer-runtime/lib/helpers/get-dynamic-var', 'glimmer-runtime/lib/syntax/builtins/with-dynamic-vars', 'glimmer-runtime/lib/syntax/builtins/in-element', 'glimmer-runtime/lib/vm', 'glimmer-runtime/lib/upsert', 'glimmer-runtime/lib/environment', 'glimmer-runtime/lib/partial', 'glimmer-runtime/lib/component/interfaces', 'glimmer-runtime/lib/modifier/interfaces', 'glimmer-runtime/lib/dom/helper', 'glimmer-runtime/lib/builder', 'glimmer-runtime/lib/bounds'], function (exports, _glimmerRuntimeLibDomInterfaces, _glimmerRuntimeLibSyntax, _glimmerRuntimeLibTemplate, _glimmerRuntimeLibSymbolTable, _glimmerRuntimeLibReferences, _glimmerRuntimeLibSyntaxCore, _glimmerRuntimeLibCompiledOpcodesBuilder, _glimmerRuntimeLibCompiler, _glimmerRuntimeLibOpcodeBuilder, _glimmerRuntimeLibCompiledBlocks, _glimmerRuntimeLibDomAttributeManagers, _glimmerRuntimeLibCompiledOpcodesContent, _glimmerRuntimeLibCompiledExpressions, _glimmerRuntimeLibCompiledExpressionsArgs, _glimmerRuntimeLibCompiledExpressionsValue, _glimmerRuntimeLibCompiledExpressionsFunction, _glimmerRuntimeLibHelpersGetDynamicVar, _glimmerRuntimeLibSyntaxBuiltinsWithDynamicVars, _glimmerRuntimeLibSyntaxBuiltinsInElement, _glimmerRuntimeLibVm, _glimmerRuntimeLibUpsert, _glimmerRuntimeLibEnvironment, _glimmerRuntimeLibPartial, _glimmerRuntimeLibComponentInterfaces, _glimmerRuntimeLibModifierInterfaces, _glimmerRuntimeLibDomHelper, _glimmerRuntimeLibBuilder, _glimmerRuntimeLibBounds) {
  'use strict';

  exports.ATTRIBUTE_SYNTAX = _glimmerRuntimeLibSyntax.ATTRIBUTE;
  exports.StatementSyntax = _glimmerRuntimeLibSyntax.Statement;
  exports.ExpressionSyntax = _glimmerRuntimeLibSyntax.Expression;
  exports.AttributeSyntax = _glimmerRuntimeLibSyntax.Attribute;
  exports.StatementCompilationBuffer = _glimmerRuntimeLibSyntax.StatementCompilationBuffer;
  exports.SymbolLookup = _glimmerRuntimeLibSyntax.SymbolLookup;
  exports.CompileInto = _glimmerRuntimeLibSyntax.CompileInto;
  exports.isAttribute = _glimmerRuntimeLibSyntax.isAttribute;
  exports.templateFactory = _glimmerRuntimeLibTemplate.default;
  exports.TemplateFactory = _glimmerRuntimeLibTemplate.TemplateFactory;
  exports.Template = _glimmerRuntimeLibTemplate.Template;
  exports.SymbolTable = _glimmerRuntimeLibSymbolTable.default;
  exports.ConditionalReference = _glimmerRuntimeLibReferences.ConditionalReference;
  exports.NULL_REFERENCE = _glimmerRuntimeLibReferences.NULL_REFERENCE;
  exports.UNDEFINED_REFERENCE = _glimmerRuntimeLibReferences.UNDEFINED_REFERENCE;
  exports.Templates = _glimmerRuntimeLibSyntaxCore.Templates;
  exports.OptimizedAppend = _glimmerRuntimeLibSyntaxCore.OptimizedAppend;
  exports.UnoptimizedAppend = _glimmerRuntimeLibSyntaxCore.UnoptimizedAppend;
  exports.Unknown = _glimmerRuntimeLibSyntaxCore.Unknown;
  exports.StaticAttr = _glimmerRuntimeLibSyntaxCore.StaticAttr;
  exports.DynamicAttr = _glimmerRuntimeLibSyntaxCore.DynamicAttr;
  exports.ArgsSyntax = _glimmerRuntimeLibSyntaxCore.Args;
  exports.NamedArgsSyntax = _glimmerRuntimeLibSyntaxCore.NamedArgs;
  exports.PositionalArgsSyntax = _glimmerRuntimeLibSyntaxCore.PositionalArgs;
  exports.RefSyntax = _glimmerRuntimeLibSyntaxCore.Ref;
  exports.GetNamedParameterSyntax = _glimmerRuntimeLibSyntaxCore.GetArgument;
  exports.GetSyntax = _glimmerRuntimeLibSyntaxCore.Get;
  exports.ValueSyntax = _glimmerRuntimeLibSyntaxCore.Value;
  exports.OpenElement = _glimmerRuntimeLibSyntaxCore.OpenElement;
  exports.HelperSyntax = _glimmerRuntimeLibSyntaxCore.Helper;
  exports.BlockSyntax = _glimmerRuntimeLibSyntaxCore.Block;
  exports.OpenPrimitiveElementSyntax = _glimmerRuntimeLibSyntaxCore.OpenPrimitiveElement;
  exports.CloseElementSyntax = _glimmerRuntimeLibSyntaxCore.CloseElement;
  exports.OpcodeBuilderDSL = _glimmerRuntimeLibCompiledOpcodesBuilder.default;
  exports.Compiler = _glimmerRuntimeLibCompiler.default;
  exports.Compilable = _glimmerRuntimeLibCompiler.Compilable;
  exports.CompileIntoList = _glimmerRuntimeLibCompiler.CompileIntoList;
  exports.compileLayout = _glimmerRuntimeLibCompiler.compileLayout;
  exports.ComponentBuilder = _glimmerRuntimeLibOpcodeBuilder.ComponentBuilder;
  exports.StaticDefinition = _glimmerRuntimeLibOpcodeBuilder.StaticDefinition;
  exports.DynamicDefinition = _glimmerRuntimeLibOpcodeBuilder.DynamicDefinition;
  exports.Block = _glimmerRuntimeLibCompiledBlocks.Block;
  exports.CompiledBlock = _glimmerRuntimeLibCompiledBlocks.CompiledBlock;
  exports.Layout = _glimmerRuntimeLibCompiledBlocks.Layout;
  exports.InlineBlock = _glimmerRuntimeLibCompiledBlocks.InlineBlock;
  exports.EntryPoint = _glimmerRuntimeLibCompiledBlocks.EntryPoint;
  exports.IAttributeManager = _glimmerRuntimeLibDomAttributeManagers.AttributeManager;
  exports.AttributeManager = _glimmerRuntimeLibDomAttributeManagers.AttributeManager;
  exports.PropertyManager = _glimmerRuntimeLibDomAttributeManagers.PropertyManager;
  exports.INPUT_VALUE_PROPERTY_MANAGER = _glimmerRuntimeLibDomAttributeManagers.INPUT_VALUE_PROPERTY_MANAGER;
  exports.defaultManagers = _glimmerRuntimeLibDomAttributeManagers.defaultManagers;
  exports.defaultAttributeManagers = _glimmerRuntimeLibDomAttributeManagers.defaultAttributeManagers;
  exports.defaultPropertyManagers = _glimmerRuntimeLibDomAttributeManagers.defaultPropertyManagers;
  exports.readDOMAttr = _glimmerRuntimeLibDomAttributeManagers.readDOMAttr;
  exports.normalizeTextValue = _glimmerRuntimeLibCompiledOpcodesContent.normalizeTextValue;
  exports.CompiledExpression = _glimmerRuntimeLibCompiledExpressions.CompiledExpression;
  exports.CompiledArgs = _glimmerRuntimeLibCompiledExpressionsArgs.CompiledArgs;
  exports.CompiledNamedArgs = _glimmerRuntimeLibCompiledExpressionsArgs.CompiledNamedArgs;
  exports.CompiledPositionalArgs = _glimmerRuntimeLibCompiledExpressionsArgs.CompiledPositionalArgs;
  exports.EvaluatedArgs = _glimmerRuntimeLibCompiledExpressionsArgs.EvaluatedArgs;
  exports.EvaluatedNamedArgs = _glimmerRuntimeLibCompiledExpressionsArgs.EvaluatedNamedArgs;
  exports.EvaluatedPositionalArgs = _glimmerRuntimeLibCompiledExpressionsArgs.EvaluatedPositionalArgs;
  exports.ValueReference = _glimmerRuntimeLibCompiledExpressionsValue.ValueReference;
  exports.FunctionExpression = _glimmerRuntimeLibCompiledExpressionsFunction.FunctionExpression;
  exports.getDynamicVar = _glimmerRuntimeLibHelpersGetDynamicVar.default;
  exports.WithDynamicVarsSyntax = _glimmerRuntimeLibSyntaxBuiltinsWithDynamicVars.default;
  exports.InElementSyntax = _glimmerRuntimeLibSyntaxBuiltinsInElement.default;
  exports.VM = _glimmerRuntimeLibVm.PublicVM;
  exports.UpdatingVM = _glimmerRuntimeLibVm.UpdatingVM;
  exports.RenderResult = _glimmerRuntimeLibVm.RenderResult;
  exports.SafeString = _glimmerRuntimeLibUpsert.SafeString;
  exports.isSafeString = _glimmerRuntimeLibUpsert.isSafeString;
  exports.Scope = _glimmerRuntimeLibEnvironment.Scope;
  exports.Environment = _glimmerRuntimeLibEnvironment.default;
  exports.Helper = _glimmerRuntimeLibEnvironment.Helper;
  exports.ParsedStatement = _glimmerRuntimeLibEnvironment.ParsedStatement;
  exports.DynamicScope = _glimmerRuntimeLibEnvironment.DynamicScope;
  exports.PartialDefinition = _glimmerRuntimeLibPartial.PartialDefinition;
  exports.Component = _glimmerRuntimeLibComponentInterfaces.Component;
  exports.ComponentClass = _glimmerRuntimeLibComponentInterfaces.ComponentClass;
  exports.ComponentManager = _glimmerRuntimeLibComponentInterfaces.ComponentManager;
  exports.ComponentDefinition = _glimmerRuntimeLibComponentInterfaces.ComponentDefinition;
  exports.ComponentLayoutBuilder = _glimmerRuntimeLibComponentInterfaces.ComponentLayoutBuilder;
  exports.ComponentAttrsBuilder = _glimmerRuntimeLibComponentInterfaces.ComponentAttrsBuilder;
  exports.isComponentDefinition = _glimmerRuntimeLibComponentInterfaces.isComponentDefinition;
  exports.ModifierManager = _glimmerRuntimeLibModifierInterfaces.ModifierManager;
  exports.DOMChanges = _glimmerRuntimeLibDomHelper.default;
  exports.IDOMChanges = _glimmerRuntimeLibDomHelper.DOMChanges;
  exports.DOMTreeConstruction = _glimmerRuntimeLibDomHelper.DOMTreeConstruction;
  exports.isWhitespace = _glimmerRuntimeLibDomHelper.isWhitespace;
  exports.insertHTMLBefore = _glimmerRuntimeLibDomHelper.insertHTMLBefore;
  exports.Simple = _glimmerRuntimeLibDomInterfaces;
  exports.ElementStack = _glimmerRuntimeLibBuilder.ElementStack;
  exports.ElementOperations = _glimmerRuntimeLibBuilder.ElementOperations;
  exports.Bounds = _glimmerRuntimeLibBounds.default;
  exports.ConcreteBounds = _glimmerRuntimeLibBounds.ConcreteBounds;
});
//# sourceMappingURL=data:application/json;base64,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
enifed("glimmer-runtime/lib/bounds", ["exports"], function (exports) {
    "use strict";

    exports.bounds = bounds;
    exports.single = single;
    exports.move = move;
    exports.clear = clear;

    var Cursor = function Cursor(element, nextSibling) {
        this.element = element;
        this.nextSibling = nextSibling;
    };

    exports.Cursor = Cursor;

    var RealDOMBounds = (function () {
        function RealDOMBounds(bounds) {
            this.bounds = bounds;
        }

        RealDOMBounds.prototype.parentElement = function parentElement() {
            return this.bounds.parentElement();
        };

        RealDOMBounds.prototype.firstNode = function firstNode() {
            return this.bounds.firstNode();
        };

        RealDOMBounds.prototype.lastNode = function lastNode() {
            return this.bounds.lastNode();
        };

        return RealDOMBounds;
    })();

    exports.RealDOMBounds = RealDOMBounds;

    var ConcreteBounds = (function () {
        function ConcreteBounds(parentNode, first, last) {
            this.parentNode = parentNode;
            this.first = first;
            this.last = last;
        }

        ConcreteBounds.prototype.parentElement = function parentElement() {
            return this.parentNode;
        };

        ConcreteBounds.prototype.firstNode = function firstNode() {
            return this.first;
        };

        ConcreteBounds.prototype.lastNode = function lastNode() {
            return this.last;
        };

        return ConcreteBounds;
    })();

    exports.ConcreteBounds = ConcreteBounds;

    var SingleNodeBounds = (function () {
        function SingleNodeBounds(parentNode, node) {
            this.parentNode = parentNode;
            this.node = node;
        }

        SingleNodeBounds.prototype.parentElement = function parentElement() {
            return this.parentNode;
        };

        SingleNodeBounds.prototype.firstNode = function firstNode() {
            return this.node;
        };

        SingleNodeBounds.prototype.lastNode = function lastNode() {
            return this.node;
        };

        return SingleNodeBounds;
    })();

    exports.SingleNodeBounds = SingleNodeBounds;

    function bounds(parent, first, last) {
        return new ConcreteBounds(parent, first, last);
    }

    function single(parent, node) {
        return new SingleNodeBounds(parent, node);
    }

    function move(bounds, reference) {
        var parent = bounds.parentElement();
        var first = bounds.firstNode();
        var last = bounds.lastNode();
        var node = first;
        while (node) {
            var next = node.nextSibling;
            parent.insertBefore(node, reference);
            if (node === last) return next;
            node = next;
        }
        return null;
    }

    function clear(bounds) {
        var parent = bounds.parentElement();
        var first = bounds.firstNode();
        var last = bounds.lastNode();
        var node = first;
        while (node) {
            var next = node.nextSibling;
            parent.removeChild(node);
            if (node === last) return next;
            node = next;
        }
        return null;
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/builder', ['exports', 'glimmer-runtime/lib/bounds', 'glimmer-util', 'glimmer-runtime/lib/compiled/opcodes/dom'], function (exports, _glimmerRuntimeLibBounds, _glimmerUtil, _glimmerRuntimeLibCompiledOpcodesDom) {
    'use strict';

    var First = (function () {
        function First(node) {
            this.node = node;
        }

        First.prototype.firstNode = function firstNode() {
            return this.node;
        };

        return First;
    })();

    var Last = (function () {
        function Last(node) {
            this.node = node;
        }

        Last.prototype.lastNode = function lastNode() {
            return this.node;
        };

        return Last;
    })();

    var Fragment = (function () {
        function Fragment(bounds) {
            this.bounds = bounds;
        }

        Fragment.prototype.parentElement = function parentElement() {
            return this.bounds.parentElement();
        };

        Fragment.prototype.firstNode = function firstNode() {
            return this.bounds.firstNode();
        };

        Fragment.prototype.lastNode = function lastNode() {
            return this.bounds.lastNode();
        };

        Fragment.prototype.update = function update(bounds) {
            this.bounds = bounds;
        };

        return Fragment;
    })();

    exports.Fragment = Fragment;

    var ElementStack = (function () {
        function ElementStack(env, parentNode, nextSibling) {
            this.constructing = null;
            this.operations = null;
            this.elementStack = new _glimmerUtil.Stack();
            this.nextSiblingStack = new _glimmerUtil.Stack();
            this.blockStack = new _glimmerUtil.Stack();
            this.env = env;
            this.dom = env.getAppendOperations();
            this.updateOperations = env.getDOM();
            this.element = parentNode;
            this.nextSibling = nextSibling;
            this.defaultOperations = new _glimmerRuntimeLibCompiledOpcodesDom.SimpleElementOperations(env);
            this.elementStack.push(this.element);
            this.nextSiblingStack.push(this.nextSibling);
        }

        ElementStack.forInitialRender = function forInitialRender(env, parentNode, nextSibling) {
            return new ElementStack(env, parentNode, nextSibling);
        };

        ElementStack.resume = function resume(env, tracker, nextSibling) {
            var parentNode = tracker.parentElement();
            var stack = new ElementStack(env, parentNode, nextSibling);
            stack.pushBlockTracker(tracker);
            return stack;
        };

        ElementStack.prototype.block = function block() {
            return this.blockStack.current;
        };

        ElementStack.prototype.popElement = function popElement() {
            var elementStack = this.elementStack;
            var nextSiblingStack = this.nextSiblingStack;

            var topElement = elementStack.pop();
            nextSiblingStack.pop();
            this.element = elementStack.current;
            this.nextSibling = nextSiblingStack.current;
            return topElement;
        };

        ElementStack.prototype.pushSimpleBlock = function pushSimpleBlock() {
            var tracker = new SimpleBlockTracker(this.element);
            this.pushBlockTracker(tracker);
            return tracker;
        };

        ElementStack.prototype.pushUpdatableBlock = function pushUpdatableBlock() {
            var tracker = new UpdatableBlockTracker(this.element);
            this.pushBlockTracker(tracker);
            return tracker;
        };

        ElementStack.prototype.pushBlockTracker = function pushBlockTracker(tracker) {
            var isRemote = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];

            var current = this.blockStack.current;
            if (current !== null) {
                current.newDestroyable(tracker);
                if (!isRemote) {
                    current.newBounds(tracker);
                }
            }
            this.blockStack.push(tracker);
            return tracker;
        };

        ElementStack.prototype.pushBlockList = function pushBlockList(list) {
            var tracker = new BlockListTracker(this.element, list);
            var current = this.blockStack.current;
            if (current !== null) {
                current.newDestroyable(tracker);
                current.newBounds(tracker);
            }
            this.blockStack.push(tracker);
            return tracker;
        };

        ElementStack.prototype.popBlock = function popBlock() {
            this.blockStack.current.finalize(this);
            return this.blockStack.pop();
        };

        ElementStack.prototype.openElement = function openElement(tag) {
            var operations = arguments.length <= 1 || arguments[1] === undefined ? this.defaultOperations : arguments[1];

            var element = this.dom.createElement(tag, this.element);
            this.constructing = element;
            this.operations = operations;
            return element;
        };

        ElementStack.prototype.flushElement = function flushElement() {
            var parent = this.element;
            var element = this.constructing;
            this.dom.insertBefore(parent, element, this.nextSibling);
            this.constructing = null;
            this.operations = null;
            this.pushElement(element);
            this.blockStack.current.openElement(element);
        };

        ElementStack.prototype.pushRemoteElement = function pushRemoteElement(element) {
            this.pushElement(element);
            var tracker = new RemoteBlockTracker(element);
            this.pushBlockTracker(tracker, true);
        };

        ElementStack.prototype.popRemoteElement = function popRemoteElement() {
            this.popBlock();
            this.popElement();
        };

        ElementStack.prototype.pushElement = function pushElement(element) {
            this.element = element;
            this.elementStack.push(element);
            this.nextSibling = null;
            this.nextSiblingStack.push(null);
        };

        ElementStack.prototype.newDestroyable = function newDestroyable(d) {
            this.blockStack.current.newDestroyable(d);
        };

        ElementStack.prototype.newBounds = function newBounds(bounds) {
            this.blockStack.current.newBounds(bounds);
        };

        ElementStack.prototype.appendText = function appendText(string) {
            var dom = this.dom;

            var text = dom.createTextNode(string);
            dom.insertBefore(this.element, text, this.nextSibling);
            this.blockStack.current.newNode(text);
            return text;
        };

        ElementStack.prototype.appendComment = function appendComment(string) {
            var dom = this.dom;

            var comment = dom.createComment(string);
            dom.insertBefore(this.element, comment, this.nextSibling);
            this.blockStack.current.newNode(comment);
            return comment;
        };

        ElementStack.prototype.setStaticAttribute = function setStaticAttribute(name, value) {
            this.operations.addStaticAttribute(this.constructing, name, value);
        };

        ElementStack.prototype.setStaticAttributeNS = function setStaticAttributeNS(namespace, name, value) {
            this.operations.addStaticAttributeNS(this.constructing, namespace, name, value);
        };

        ElementStack.prototype.setDynamicAttribute = function setDynamicAttribute(name, reference, isTrusting) {
            this.operations.addDynamicAttribute(this.constructing, name, reference, isTrusting);
        };

        ElementStack.prototype.setDynamicAttributeNS = function setDynamicAttributeNS(namespace, name, reference, isTrusting) {
            this.operations.addDynamicAttributeNS(this.constructing, namespace, name, reference, isTrusting);
        };

        ElementStack.prototype.closeElement = function closeElement() {
            this.blockStack.current.closeElement();
            this.popElement();
        };

        return ElementStack;
    })();

    exports.ElementStack = ElementStack;

    var SimpleBlockTracker = (function () {
        function SimpleBlockTracker(parent) {
            this.parent = parent;
            this.first = null;
            this.last = null;
            this.destroyables = null;
            this.nesting = 0;
        }

        SimpleBlockTracker.prototype.destroy = function destroy() {
            var destroyables = this.destroyables;

            if (destroyables && destroyables.length) {
                for (var i = 0; i < destroyables.length; i++) {
                    destroyables[i].destroy();
                }
            }
        };

        SimpleBlockTracker.prototype.parentElement = function parentElement() {
            return this.parent;
        };

        SimpleBlockTracker.prototype.firstNode = function firstNode() {
            return this.first && this.first.firstNode();
        };

        SimpleBlockTracker.prototype.lastNode = function lastNode() {
            return this.last && this.last.lastNode();
        };

        SimpleBlockTracker.prototype.openElement = function openElement(element) {
            this.newNode(element);
            this.nesting++;
        };

        SimpleBlockTracker.prototype.closeElement = function closeElement() {
            this.nesting--;
        };

        SimpleBlockTracker.prototype.newNode = function newNode(node) {
            if (this.nesting !== 0) return;
            if (!this.first) {
                this.first = new First(node);
            }
            this.last = new Last(node);
        };

        SimpleBlockTracker.prototype.newBounds = function newBounds(bounds) {
            if (this.nesting !== 0) return;
            if (!this.first) {
                this.first = bounds;
            }
            this.last = bounds;
        };

        SimpleBlockTracker.prototype.newDestroyable = function newDestroyable(d) {
            this.destroyables = this.destroyables || [];
            this.destroyables.push(d);
        };

        SimpleBlockTracker.prototype.finalize = function finalize(stack) {
            if (!this.first) {
                stack.appendComment('');
            }
        };

        return SimpleBlockTracker;
    })();

    exports.SimpleBlockTracker = SimpleBlockTracker;

    var RemoteBlockTracker = (function (_SimpleBlockTracker) {
        babelHelpers.inherits(RemoteBlockTracker, _SimpleBlockTracker);

        function RemoteBlockTracker() {
            _SimpleBlockTracker.apply(this, arguments);
        }

        RemoteBlockTracker.prototype.destroy = function destroy() {
            _SimpleBlockTracker.prototype.destroy.call(this);
            _glimmerRuntimeLibBounds.clear(this);
        };

        return RemoteBlockTracker;
    })(SimpleBlockTracker);

    var UpdatableBlockTracker = (function (_SimpleBlockTracker2) {
        babelHelpers.inherits(UpdatableBlockTracker, _SimpleBlockTracker2);

        function UpdatableBlockTracker() {
            _SimpleBlockTracker2.apply(this, arguments);
        }

        UpdatableBlockTracker.prototype.reset = function reset(env) {
            var destroyables = this.destroyables;

            if (destroyables && destroyables.length) {
                for (var i = 0; i < destroyables.length; i++) {
                    env.didDestroy(destroyables[i]);
                }
            }
            var nextSibling = _glimmerRuntimeLibBounds.clear(this);
            this.destroyables = null;
            this.first = null;
            this.last = null;
            return nextSibling;
        };

        return UpdatableBlockTracker;
    })(SimpleBlockTracker);

    exports.UpdatableBlockTracker = UpdatableBlockTracker;

    var BlockListTracker = (function () {
        function BlockListTracker(parent, boundList) {
            this.parent = parent;
            this.boundList = boundList;
            this.parent = parent;
            this.boundList = boundList;
        }

        BlockListTracker.prototype.destroy = function destroy() {
            this.boundList.forEachNode(function (node) {
                return node.destroy();
            });
        };

        BlockListTracker.prototype.parentElement = function parentElement() {
            return this.parent;
        };

        BlockListTracker.prototype.firstNode = function firstNode() {
            return this.boundList.head().firstNode();
        };

        BlockListTracker.prototype.lastNode = function lastNode() {
            return this.boundList.tail().lastNode();
        };

        BlockListTracker.prototype.openElement = function openElement(element) {
            _glimmerUtil.assert(false, 'Cannot openElement directly inside a block list');
        };

        BlockListTracker.prototype.closeElement = function closeElement() {
            _glimmerUtil.assert(false, 'Cannot closeElement directly inside a block list');
        };

        BlockListTracker.prototype.newNode = function newNode(node) {
            _glimmerUtil.assert(false, 'Cannot create a new node directly inside a block list');
        };

        BlockListTracker.prototype.newBounds = function newBounds(bounds) {};

        BlockListTracker.prototype.newDestroyable = function newDestroyable(d) {};

        BlockListTracker.prototype.finalize = function finalize(stack) {};

        return BlockListTracker;
    })();
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compat/inner-html-fix', ['exports', 'glimmer-runtime/lib/bounds', 'glimmer-runtime/lib/dom/helper'], function (exports, _glimmerRuntimeLibBounds, _glimmerRuntimeLibDomHelper) {
    'use strict';

    exports.domChanges = domChanges;
    exports.treeConstruction = treeConstruction;

    var innerHTMLWrapper = {
        colgroup: { depth: 2, before: '<table><colgroup>', after: '</colgroup></table>' },
        table: { depth: 1, before: '<table>', after: '</table>' },
        tbody: { depth: 2, before: '<table><tbody>', after: '</tbody></table>' },
        tfoot: { depth: 2, before: '<table><tfoot>', after: '</tfoot></table>' },
        thead: { depth: 2, before: '<table><thead>', after: '</thead></table>' },
        tr: { depth: 3, before: '<table><tbody><tr>', after: '</tr></tbody></table>' }
    };
    // Patch:    innerHTML Fix
    // Browsers: IE9
    // Reason:   IE9 don't allow us to set innerHTML on col, colgroup, frameset,
    //           html, style, table, tbody, tfoot, thead, title, tr.
    // Fix:      Wrap the innerHTML we are about to set in its parents, apply the
    //           wrapped innerHTML on a div, then move the unwrapped nodes into the
    //           target position.

    function domChanges(document, DOMChangesClass) {
        if (!document) return DOMChangesClass;
        if (!shouldApplyFix(document)) {
            return DOMChangesClass;
        }
        var div = document.createElement('div');
        return (function (_DOMChangesClass) {
            babelHelpers.inherits(DOMChangesWithInnerHTMLFix, _DOMChangesClass);

            function DOMChangesWithInnerHTMLFix() {
                _DOMChangesClass.apply(this, arguments);
            }

            DOMChangesWithInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, nextSibling, html) {
                if (html === null || html === '') {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                var parentTag = parent.tagName.toLowerCase();
                var wrapper = innerHTMLWrapper[parentTag];
                if (wrapper === undefined) {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                return fixInnerHTML(parent, wrapper, div, html, nextSibling);
            };

            return DOMChangesWithInnerHTMLFix;
        })(DOMChangesClass);
    }

    function treeConstruction(document, DOMTreeConstructionClass) {
        if (!document) return DOMTreeConstructionClass;
        if (!shouldApplyFix(document)) {
            return DOMTreeConstructionClass;
        }
        var div = document.createElement('div');
        return (function (_DOMTreeConstructionClass) {
            babelHelpers.inherits(DOMTreeConstructionWithInnerHTMLFix, _DOMTreeConstructionClass);

            function DOMTreeConstructionWithInnerHTMLFix() {
                _DOMTreeConstructionClass.apply(this, arguments);
            }

            DOMTreeConstructionWithInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, html, reference) {
                if (html === null || html === '') {
                    return _DOMTreeConstructionClass.prototype.insertHTMLBefore.call(this, parent, html, reference);
                }
                var parentTag = parent.tagName.toLowerCase();
                var wrapper = innerHTMLWrapper[parentTag];
                if (wrapper === undefined) {
                    return _DOMTreeConstructionClass.prototype.insertHTMLBefore.call(this, parent, html, reference);
                }
                return fixInnerHTML(parent, wrapper, div, html, reference);
            };

            return DOMTreeConstructionWithInnerHTMLFix;
        })(DOMTreeConstructionClass);
    }

    function fixInnerHTML(parent, wrapper, div, html, reference) {
        var wrappedHtml = wrapper.before + html + wrapper.after;
        div.innerHTML = wrappedHtml;
        var parentNode = div;
        for (var i = 0; i < wrapper.depth; i++) {
            parentNode = parentNode.childNodes[0];
        }

        var _moveNodesBefore = _glimmerRuntimeLibDomHelper.moveNodesBefore(parentNode, parent, reference);

        var first = _moveNodesBefore[0];
        var last = _moveNodesBefore[1];

        return new _glimmerRuntimeLibBounds.ConcreteBounds(parent, first, last);
    }
    function shouldApplyFix(document) {
        var table = document.createElement('table');
        try {
            table.innerHTML = '<tbody></tbody>';
        } catch (e) {} finally {
            if (table.childNodes.length !== 0) {
                // It worked as expected, no fix required
                return false;
            }
        }
        return true;
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compat/svg-inner-html-fix', ['exports', 'glimmer-runtime/lib/bounds', 'glimmer-runtime/lib/dom/helper'], function (exports, _glimmerRuntimeLibBounds, _glimmerRuntimeLibDomHelper) {
    'use strict';

    exports.domChanges = domChanges;
    exports.treeConstruction = treeConstruction;

    var SVG_NAMESPACE = 'http://www.w3.org/2000/svg';
    // Patch:    insertAdjacentHTML on SVG Fix
    // Browsers: Safari, IE, Edge, Firefox ~33-34
    // Reason:   insertAdjacentHTML does not exist on SVG elements in Safari. It is
    //           present but throws an exception on IE and Edge. Old versions of
    //           Firefox create nodes in the incorrect namespace.
    // Fix:      Since IE and Edge silently fail to create SVG nodes using
    //           innerHTML, and because Firefox may create nodes in the incorrect
    //           namespace using innerHTML on SVG elements, an HTML-string wrapping
    //           approach is used. A pre/post SVG tag is added to the string, then
    //           that whole string is added to a div. The created nodes are plucked
    //           out and applied to the target location on DOM.

    function domChanges(document, DOMChangesClass, svgNamespace) {
        if (!document) return DOMChangesClass;
        if (!shouldApplyFix(document, svgNamespace)) {
            return DOMChangesClass;
        }
        var div = document.createElement('div');
        return (function (_DOMChangesClass) {
            babelHelpers.inherits(DOMChangesWithSVGInnerHTMLFix, _DOMChangesClass);

            function DOMChangesWithSVGInnerHTMLFix() {
                _DOMChangesClass.apply(this, arguments);
            }

            DOMChangesWithSVGInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, nextSibling, html) {
                if (html === null || html === '') {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                if (parent.namespaceURI !== svgNamespace) {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                return fixSVG(parent, div, html, nextSibling);
            };

            return DOMChangesWithSVGInnerHTMLFix;
        })(DOMChangesClass);
    }

    function treeConstruction(document, TreeConstructionClass, svgNamespace) {
        if (!document) return TreeConstructionClass;
        if (!shouldApplyFix(document, svgNamespace)) {
            return TreeConstructionClass;
        }
        var div = document.createElement('div');
        return (function (_TreeConstructionClass) {
            babelHelpers.inherits(TreeConstructionWithSVGInnerHTMLFix, _TreeConstructionClass);

            function TreeConstructionWithSVGInnerHTMLFix() {
                _TreeConstructionClass.apply(this, arguments);
            }

            TreeConstructionWithSVGInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, html, reference) {
                if (html === null || html === '') {
                    return _TreeConstructionClass.prototype.insertHTMLBefore.call(this, parent, html, reference);
                }
                if (parent.namespaceURI !== svgNamespace) {
                    return _TreeConstructionClass.prototype.insertHTMLBefore.call(this, parent, html, reference);
                }
                return fixSVG(parent, div, html, reference);
            };

            return TreeConstructionWithSVGInnerHTMLFix;
        })(TreeConstructionClass);
    }

    function fixSVG(parent, div, html, reference) {
        // IE, Edge: also do not correctly support using `innerHTML` on SVG
        // namespaced elements. So here a wrapper is used.
        var wrappedHtml = '<svg>' + html + '</svg>';
        div.innerHTML = wrappedHtml;

        var _moveNodesBefore = _glimmerRuntimeLibDomHelper.moveNodesBefore(div.firstChild, parent, reference);

        var first = _moveNodesBefore[0];
        var last = _moveNodesBefore[1];

        return new _glimmerRuntimeLibBounds.ConcreteBounds(parent, first, last);
    }
    function shouldApplyFix(document, svgNamespace) {
        var svg = document.createElementNS(svgNamespace, 'svg');
        try {
            svg['insertAdjacentHTML']('beforeEnd', '<circle></circle>');
        } catch (e) {} finally {
            // FF: Old versions will create a node in the wrong namespace
            if (svg.childNodes.length === 1 && svg.firstChild.namespaceURI === SVG_NAMESPACE) {
                // The test worked as expected, no fix required
                return false;
            }
            svg = null;
            return true;
        }
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compat/text-node-merging-fix', ['exports'], function (exports) {
    // Patch:    Adjacent text node merging fix
    // Browsers: IE, Edge, Firefox w/o inspector open
    // Reason:   These browsers will merge adjacent text nodes. For exmaple given
    //           <div>Hello</div> with div.insertAdjacentHTML(' world') browsers
    //           with proper behavior will populate div.childNodes with two items.
    //           These browsers will populate it with one merged node instead.
    // Fix:      Add these nodes to a wrapper element, then iterate the childNodes
    //           of that wrapper and move the nodes to their target location. Note
    //           that potential SVG bugs will have been handled before this fix.
    //           Note that this fix must only apply to the previous text node, as
    //           the base implementation of `insertHTMLBefore` already handles
    //           following text nodes correctly.
    'use strict';

    exports.domChanges = domChanges;
    exports.treeConstruction = treeConstruction;

    function domChanges(document, DOMChangesClass) {
        if (!document) return DOMChangesClass;
        if (!shouldApplyFix(document)) {
            return DOMChangesClass;
        }
        return (function (_DOMChangesClass) {
            babelHelpers.inherits(DOMChangesWithTextNodeMergingFix, _DOMChangesClass);

            function DOMChangesWithTextNodeMergingFix(document) {
                _DOMChangesClass.call(this, document);
                this.uselessComment = document.createComment('');
            }

            DOMChangesWithTextNodeMergingFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, nextSibling, html) {
                if (html === null) {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                var didSetUselessComment = false;
                var nextPrevious = nextSibling ? nextSibling.previousSibling : parent.lastChild;
                if (nextPrevious && nextPrevious instanceof Text) {
                    didSetUselessComment = true;
                    parent.insertBefore(this.uselessComment, nextSibling);
                }
                var bounds = _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                if (didSetUselessComment) {
                    parent.removeChild(this.uselessComment);
                }
                return bounds;
            };

            return DOMChangesWithTextNodeMergingFix;
        })(DOMChangesClass);
    }

    function treeConstruction(document, TreeConstructionClass) {
        if (!document) return TreeConstructionClass;
        if (!shouldApplyFix(document)) {
            return TreeConstructionClass;
        }
        return (function (_TreeConstructionClass) {
            babelHelpers.inherits(TreeConstructionWithTextNodeMergingFix, _TreeConstructionClass);

            function TreeConstructionWithTextNodeMergingFix(document) {
                _TreeConstructionClass.call(this, document);
                this.uselessComment = this.createComment('');
            }

            TreeConstructionWithTextNodeMergingFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, html, reference) {
                if (html === null) {
                    return _TreeConstructionClass.prototype.insertHTMLBefore.call(this, parent, html, reference);
                }
                var didSetUselessComment = false;
                var nextPrevious = reference ? reference.previousSibling : parent.lastChild;
                if (nextPrevious && nextPrevious instanceof Text) {
                    didSetUselessComment = true;
                    parent.insertBefore(this.uselessComment, reference);
                }
                var bounds = _TreeConstructionClass.prototype.insertHTMLBefore.call(this, parent, html, reference);
                if (didSetUselessComment) {
                    parent.removeChild(this.uselessComment);
                }
                return bounds;
            };

            return TreeConstructionWithTextNodeMergingFix;
        })(TreeConstructionClass);
    }

    function shouldApplyFix(document) {
        var mergingTextDiv = document.createElement('div');
        mergingTextDiv.innerHTML = 'first';
        mergingTextDiv.insertAdjacentHTML('beforeEnd', 'second');
        if (mergingTextDiv.childNodes.length === 2) {
            mergingTextDiv = null;
            // It worked as expected, no fix required
            return false;
        }
        mergingTextDiv = null;
        return true;
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/blocks', ['exports', 'glimmer-runtime/lib/utils', 'glimmer-runtime/lib/compiler'], function (exports, _glimmerRuntimeLibUtils, _glimmerRuntimeLibCompiler) {
    'use strict';

    var CompiledBlock = function CompiledBlock(ops, symbols) {
        this.ops = ops;
        this.symbols = symbols;
    };

    exports.CompiledBlock = CompiledBlock;

    var Block = function Block(program, symbolTable) {
        this.program = program;
        this.symbolTable = symbolTable;
        this.compiled = null;
    };

    exports.Block = Block;

    var InlineBlock = (function (_Block) {
        babelHelpers.inherits(InlineBlock, _Block);

        function InlineBlock(program, symbolTable) {
            var locals = arguments.length <= 2 || arguments[2] === undefined ? _glimmerRuntimeLibUtils.EMPTY_ARRAY : arguments[2];

            _Block.call(this, program, symbolTable);
            this.locals = locals;
        }

        InlineBlock.prototype.hasPositionalParameters = function hasPositionalParameters() {
            return !!this.locals.length;
        };

        InlineBlock.prototype.compile = function compile(env) {
            var compiled = this.compiled;
            if (compiled) return compiled;
            var ops = new _glimmerRuntimeLibCompiler.InlineBlockCompiler(this, env).compile();
            return this.compiled = new CompiledBlock(ops, this.symbolTable.size);
        };

        return InlineBlock;
    })(Block);

    exports.InlineBlock = InlineBlock;

    var PartialBlock = (function (_InlineBlock) {
        babelHelpers.inherits(PartialBlock, _InlineBlock);

        function PartialBlock() {
            _InlineBlock.apply(this, arguments);
        }

        return PartialBlock;
    })(InlineBlock);

    exports.PartialBlock = PartialBlock;

    var TopLevelTemplate = (function (_Block2) {
        babelHelpers.inherits(TopLevelTemplate, _Block2);

        function TopLevelTemplate() {
            _Block2.apply(this, arguments);
        }

        return TopLevelTemplate;
    })(Block);

    exports.TopLevelTemplate = TopLevelTemplate;

    var EntryPoint = (function (_TopLevelTemplate) {
        babelHelpers.inherits(EntryPoint, _TopLevelTemplate);

        function EntryPoint() {
            _TopLevelTemplate.apply(this, arguments);
        }

        EntryPoint.prototype.compile = function compile(env) {
            var compiled = this.compiled;
            if (compiled) return compiled;
            var ops = new _glimmerRuntimeLibCompiler.EntryPointCompiler(this, env).compile();
            return this.compiled = new CompiledBlock(ops, this.symbolTable.size);
        };

        return EntryPoint;
    })(TopLevelTemplate);

    exports.EntryPoint = EntryPoint;

    var Layout = (function (_TopLevelTemplate2) {
        babelHelpers.inherits(Layout, _TopLevelTemplate2);

        function Layout(program, symbolTable, named, yields, hasPartials) {
            _TopLevelTemplate2.call(this, program, symbolTable);
            this.named = named;
            this.yields = yields;
            this.hasPartials = hasPartials;
            this.hasNamedParameters = !!this.named.length;
            this.hasYields = !!this.yields.length;
            ;
        }

        return Layout;
    })(TopLevelTemplate);

    exports.Layout = Layout;
});
//# sourceMappingURL=data:application/json;base64,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
enifed("glimmer-runtime/lib/compiled/expressions", ["exports"], function (exports) {
    "use strict";

    var CompiledExpression = (function () {
        function CompiledExpression() {}

        CompiledExpression.prototype.toJSON = function toJSON() {
            return "UNIMPL: " + this.type.toUpperCase();
        };

        return CompiledExpression;
    })();

    exports.CompiledExpression = CompiledExpression;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcnVudGltZS9saWIvY29tcGlsZWQvZXhwcmVzc2lvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O1FBR0Esa0JBQUE7aUJBQUEsa0JBQUE7O0FBQUEsMEJBQUEsV0FJRSxNQUFNLEdBQUEsa0JBQUE7QUFDSixnQ0FBa0IsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBRztTQUM3Qzs7ZUFOSCxrQkFBQSIsImZpbGUiOiJleHByZXNzaW9ucy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBWTSBmcm9tICcuLi92bS9hcHBlbmQnO1xuaW1wb3J0IHsgUGF0aFJlZmVyZW5jZSB9IGZyb20gJ2dsaW1tZXItcmVmZXJlbmNlJztcblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIENvbXBpbGVkRXhwcmVzc2lvbjxUPiB7XG4gIHR5cGU6IHN0cmluZztcbiAgYWJzdHJhY3QgZXZhbHVhdGUodm06IFZNKTogUGF0aFJlZmVyZW5jZTxUPjtcblxuICB0b0pTT04oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYFVOSU1QTDogJHt0aGlzLnR5cGUudG9VcHBlckNhc2UoKX1gO1xuICB9XG59XG4iXX0=
enifed('glimmer-runtime/lib/compiled/expressions/args', ['exports', 'glimmer-runtime/lib/compiled/expressions/positional-args', 'glimmer-runtime/lib/compiled/expressions/named-args', 'glimmer-reference'], function (exports, _glimmerRuntimeLibCompiledExpressionsPositionalArgs, _glimmerRuntimeLibCompiledExpressionsNamedArgs, _glimmerReference) {
    'use strict';

    var CompiledArgs = (function () {
        function CompiledArgs(positional, named) {
            this.positional = positional;
            this.named = named;
        }

        CompiledArgs.create = function create(positional, named) {
            if (positional === _glimmerRuntimeLibCompiledExpressionsPositionalArgs.COMPILED_EMPTY_POSITIONAL_ARGS && named === _glimmerRuntimeLibCompiledExpressionsNamedArgs.COMPILED_EMPTY_NAMED_ARGS) {
                return this.empty();
            } else {
                return new this(positional, named);
            }
        };

        CompiledArgs.empty = function empty() {
            return COMPILED_EMPTY_ARGS;
        };

        CompiledArgs.prototype.evaluate = function evaluate(vm) {
            return EvaluatedArgs.create(this.positional.evaluate(vm), this.named.evaluate(vm));
        };

        return CompiledArgs;
    })();

    exports.CompiledArgs = CompiledArgs;

    var COMPILED_EMPTY_ARGS = new ((function (_CompiledArgs) {
        babelHelpers.inherits(_class, _CompiledArgs);

        function _class() {
            _CompiledArgs.call(this, _glimmerRuntimeLibCompiledExpressionsPositionalArgs.COMPILED_EMPTY_POSITIONAL_ARGS, _glimmerRuntimeLibCompiledExpressionsNamedArgs.COMPILED_EMPTY_NAMED_ARGS);
        }

        _class.prototype.evaluate = function evaluate(vm) {
            return EMPTY_EVALUATED_ARGS;
        };

        return _class;
    })(CompiledArgs))();

    var EvaluatedArgs = (function () {
        function EvaluatedArgs(positional, named) {
            this.positional = positional;
            this.named = named;
            this.tag = _glimmerReference.combineTagged([positional, named]);
        }

        EvaluatedArgs.empty = function empty() {
            return EMPTY_EVALUATED_ARGS;
        };

        EvaluatedArgs.create = function create(positional, named) {
            return new this(positional, named);
        };

        EvaluatedArgs.positional = function positional(values) {
            return new this(_glimmerRuntimeLibCompiledExpressionsPositionalArgs.EvaluatedPositionalArgs.create(values), _glimmerRuntimeLibCompiledExpressionsNamedArgs.EVALUATED_EMPTY_NAMED_ARGS);
        };

        EvaluatedArgs.named = function named(map) {
            return new this(_glimmerRuntimeLibCompiledExpressionsPositionalArgs.EVALUATED_EMPTY_POSITIONAL_ARGS, _glimmerRuntimeLibCompiledExpressionsNamedArgs.EvaluatedNamedArgs.create(map));
        };

        return EvaluatedArgs;
    })();

    exports.EvaluatedArgs = EvaluatedArgs;

    var EMPTY_EVALUATED_ARGS = new EvaluatedArgs(_glimmerRuntimeLibCompiledExpressionsPositionalArgs.EVALUATED_EMPTY_POSITIONAL_ARGS, _glimmerRuntimeLibCompiledExpressionsNamedArgs.EVALUATED_EMPTY_NAMED_ARGS);
    exports.CompiledPositionalArgs = _glimmerRuntimeLibCompiledExpressionsPositionalArgs.CompiledPositionalArgs;
    exports.EvaluatedPositionalArgs = _glimmerRuntimeLibCompiledExpressionsPositionalArgs.EvaluatedPositionalArgs;
    exports.CompiledNamedArgs = _glimmerRuntimeLibCompiledExpressionsNamedArgs.CompiledNamedArgs;
    exports.EvaluatedNamedArgs = _glimmerRuntimeLibCompiledExpressionsNamedArgs.EvaluatedNamedArgs;
});
//# sourceMappingURL=data:application/json;base64,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
enifed("glimmer-runtime/lib/compiled/expressions/concat", ["exports", "glimmer-reference"], function (exports, _glimmerReference) {
    "use strict";

    var CompiledConcat = (function () {
        function CompiledConcat(parts) {
            this.parts = parts;
            this.type = "concat";
        }

        CompiledConcat.prototype.evaluate = function evaluate(vm) {
            var parts = new Array(this.parts.length);
            for (var i = 0; i < this.parts.length; i++) {
                parts[i] = this.parts[i].evaluate(vm);
            }
            return new ConcatReference(parts);
        };

        CompiledConcat.prototype.toJSON = function toJSON() {
            return "concat(" + this.parts.map(function (expr) {
                return expr.toJSON();
            }).join(", ") + ")";
        };

        return CompiledConcat;
    })();

    exports.default = CompiledConcat;

    var ConcatReference = (function (_CachedReference) {
        babelHelpers.inherits(ConcatReference, _CachedReference);

        function ConcatReference(parts) {
            _CachedReference.call(this);
            this.parts = parts;
            this.tag = _glimmerReference.combineTagged(parts);
        }

        ConcatReference.prototype.compute = function compute() {
            var parts = new Array();
            for (var i = 0; i < this.parts.length; i++) {
                var value = this.parts[i].value();
                if (value !== null && value !== undefined) {
                    parts[i] = castToString(this.parts[i].value());
                }
            }
            if (parts.length > 0) {
                return parts.join('');
            }
            return null;
        };

        return ConcatReference;
    })(_glimmerReference.CachedReference);

    function castToString(value) {
        if (typeof value['toString'] !== 'function') {
            return '';
        }
        return String(value);
    }
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/expressions/function', ['exports', 'glimmer-runtime/lib/syntax', 'glimmer-runtime/lib/compiled/expressions'], function (exports, _glimmerRuntimeLibSyntax, _glimmerRuntimeLibCompiledExpressions) {
    'use strict';

    exports.default = make;

    function make(func) {
        return new FunctionExpressionSyntax(func);
    }

    var FunctionExpressionSyntax = (function (_ExpressionSyntax) {
        babelHelpers.inherits(FunctionExpressionSyntax, _ExpressionSyntax);

        function FunctionExpressionSyntax(func) {
            _ExpressionSyntax.call(this);
            this.type = "function-expression";
            this.func = func;
        }

        FunctionExpressionSyntax.prototype.compile = function compile(lookup, env, symbolTable) {
            return new CompiledFunctionExpression(this.func, symbolTable);
        };

        return FunctionExpressionSyntax;
    })(_glimmerRuntimeLibSyntax.Expression);

    var CompiledFunctionExpression = (function (_CompiledExpression) {
        babelHelpers.inherits(CompiledFunctionExpression, _CompiledExpression);

        function CompiledFunctionExpression(func, symbolTable) {
            _CompiledExpression.call(this);
            this.func = func;
            this.symbolTable = symbolTable;
            this.type = "function";
            this.func = func;
        }

        CompiledFunctionExpression.prototype.evaluate = function evaluate(vm) {
            var func = this.func;
            var symbolTable = this.symbolTable;

            return func(vm, symbolTable);
        };

        CompiledFunctionExpression.prototype.toJSON = function toJSON() {
            var func = this.func;

            if (func.name) {
                return '`' + func.name + '(...)`';
            } else {
                return "`func(...)`";
            }
        };

        return CompiledFunctionExpression;
    })(_glimmerRuntimeLibCompiledExpressions.CompiledExpression);
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/expressions/has-block-params', ['exports', 'glimmer-runtime/lib/compiled/expressions', 'glimmer-runtime/lib/compiled/expressions/value'], function (exports, _glimmerRuntimeLibCompiledExpressions, _glimmerRuntimeLibCompiledExpressionsValue) {
    'use strict';

    var CompiledHasBlockParams = (function (_CompiledExpression) {
        babelHelpers.inherits(CompiledHasBlockParams, _CompiledExpression);

        function CompiledHasBlockParams(blockName, blockSymbol) {
            _CompiledExpression.call(this);
            this.blockName = blockName;
            this.blockSymbol = blockSymbol;
            this.type = "has-block-params";
        }

        CompiledHasBlockParams.prototype.evaluate = function evaluate(vm) {
            var blockRef = vm.scope().getBlock(this.blockSymbol);
            return new _glimmerRuntimeLibCompiledExpressionsValue.ValueReference(!!(blockRef && blockRef.locals.length > 0));
        };

        CompiledHasBlockParams.prototype.toJSON = function toJSON() {
            return 'has-block-params(' + this.blockName + ')';
        };

        return CompiledHasBlockParams;
    })(_glimmerRuntimeLibCompiledExpressions.CompiledExpression);

    exports.default = CompiledHasBlockParams;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcnVudGltZS9saWIvY29tcGlsZWQvZXhwcmVzc2lvbnMvaGFzLWJsb2NrLXBhcmFtcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7UUFJQSxzQkFBQTs4QkFBQSxzQkFBQTs7QUFHRSxpQkFIRixzQkFBQSxDQUdxQixTQUFpQixFQUFTLFdBQW1CLEVBQUE7QUFDOUQsMENBQU8sQ0FBQztBQURTLGdCQUFBLENBQUEsU0FBUyxHQUFULFNBQVMsQ0FBUTtBQUFTLGdCQUFBLENBQUEsV0FBVyxHQUFYLFdBQVcsQ0FBUTtBQUZ6RCxnQkFBQSxDQUFBLElBQUksR0FBRyxrQkFBa0IsQ0FBQztTQUloQzs7QUFMSCw4QkFBQSxXQU9FLFFBQVEsR0FBQSxrQkFBQyxFQUFNLEVBQUE7QUFDYixnQkFBSSxRQUFRLEdBQUcsRUFBRSxDQUFDLEtBQUssRUFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7QUFDckQsbUJBQU8sK0NBWEYsY0FBYyxDQVdPLENBQUMsRUFBRSxRQUFRLElBQUksUUFBUSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFBLEFBQUMsQ0FBQyxDQUFDO1NBQ3ZFOztBQVZILDhCQUFBLFdBWUUsTUFBTSxHQUFBLGtCQUFBO0FBQ0oseUNBQTJCLElBQUksQ0FBQyxTQUFTLE9BQUk7U0FDOUM7O2VBZEgsc0JBQUE7NkNBSFMsa0JBQWtCOztzQkFHM0Isc0JBQUEiLCJmaWxlIjoiaGFzLWJsb2NrLXBhcmFtcy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBWTSBmcm9tICcuLi8uLi92bS9hcHBlbmQnO1xuaW1wb3J0IHsgQ29tcGlsZWRFeHByZXNzaW9uIH0gZnJvbSAnLi4vZXhwcmVzc2lvbnMnO1xuaW1wb3J0IHsgVmFsdWVSZWZlcmVuY2UgfSBmcm9tICcuL3ZhbHVlJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQ29tcGlsZWRIYXNCbG9ja1BhcmFtcyBleHRlbmRzIENvbXBpbGVkRXhwcmVzc2lvbjxib29sZWFuPiB7XG4gIHB1YmxpYyB0eXBlID0gXCJoYXMtYmxvY2stcGFyYW1zXCI7XG5cbiAgY29uc3RydWN0b3IocHVibGljIGJsb2NrTmFtZTogc3RyaW5nLCBwdWJsaWMgYmxvY2tTeW1ib2w6IG51bWJlcikge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBldmFsdWF0ZSh2bTogVk0pOiBWYWx1ZVJlZmVyZW5jZTxib29sZWFuPiB7XG4gICAgbGV0IGJsb2NrUmVmID0gdm0uc2NvcGUoKS5nZXRCbG9jayh0aGlzLmJsb2NrU3ltYm9sKTtcbiAgICByZXR1cm4gbmV3IFZhbHVlUmVmZXJlbmNlKCEhKGJsb2NrUmVmICYmIGJsb2NrUmVmLmxvY2Fscy5sZW5ndGggPiAwKSk7XG4gIH1cblxuICB0b0pTT04oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYGhhcy1ibG9jay1wYXJhbXMoJHt0aGlzLmJsb2NrTmFtZX0pYDtcbiAgfVxufVxuIl19
enifed('glimmer-runtime/lib/compiled/expressions/has-block', ['exports', 'glimmer-runtime/lib/compiled/expressions', 'glimmer-runtime/lib/compiled/expressions/value'], function (exports, _glimmerRuntimeLibCompiledExpressions, _glimmerRuntimeLibCompiledExpressionsValue) {
    'use strict';

    var CompiledHasBlock = (function (_CompiledExpression) {
        babelHelpers.inherits(CompiledHasBlock, _CompiledExpression);

        function CompiledHasBlock(blockName, blockSymbol) {
            _CompiledExpression.call(this);
            this.blockName = blockName;
            this.blockSymbol = blockSymbol;
            this.type = "has-block";
        }

        CompiledHasBlock.prototype.evaluate = function evaluate(vm) {
            var blockRef = vm.scope().getBlock(this.blockSymbol);
            return new _glimmerRuntimeLibCompiledExpressionsValue.ValueReference(!!blockRef);
        };

        CompiledHasBlock.prototype.toJSON = function toJSON() {
            return 'has-block(' + this.blockName + ')';
        };

        return CompiledHasBlock;
    })(_glimmerRuntimeLibCompiledExpressions.CompiledExpression);

    exports.default = CompiledHasBlock;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdsaW1tZXItcnVudGltZS9saWIvY29tcGlsZWQvZXhwcmVzc2lvbnMvaGFzLWJsb2NrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztRQUlBLGdCQUFBOzhCQUFBLGdCQUFBOztBQUdFLGlCQUhGLGdCQUFBLENBR3FCLFNBQWlCLEVBQVMsV0FBbUIsRUFBQTtBQUM5RCwwQ0FBTyxDQUFDO0FBRFMsZ0JBQUEsQ0FBQSxTQUFTLEdBQVQsU0FBUyxDQUFRO0FBQVMsZ0JBQUEsQ0FBQSxXQUFXLEdBQVgsV0FBVyxDQUFRO0FBRnpELGdCQUFBLENBQUEsSUFBSSxHQUFHLFdBQVcsQ0FBQztTQUl6Qjs7QUFMSCx3QkFBQSxXQU9FLFFBQVEsR0FBQSxrQkFBQyxFQUFNLEVBQUE7QUFDYixnQkFBSSxRQUFRLEdBQUcsRUFBRSxDQUFDLEtBQUssRUFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7QUFDckQsbUJBQU8sK0NBWEYsY0FBYyxDQVdPLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUN2Qzs7QUFWSCx3QkFBQSxXQVlFLE1BQU0sR0FBQSxrQkFBQTtBQUNKLGtDQUFvQixJQUFJLENBQUMsU0FBUyxPQUFJO1NBQ3ZDOztlQWRILGdCQUFBOzZDQUhTLGtCQUFrQjs7c0JBRzNCLGdCQUFBIiwiZmlsZSI6Imhhcy1ibG9jay5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBWTSBmcm9tICcuLi8uLi92bS9hcHBlbmQnO1xuaW1wb3J0IHsgQ29tcGlsZWRFeHByZXNzaW9uIH0gZnJvbSAnLi4vZXhwcmVzc2lvbnMnO1xuaW1wb3J0IHsgVmFsdWVSZWZlcmVuY2UgfSBmcm9tICcuL3ZhbHVlJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQ29tcGlsZWRIYXNCbG9jayBleHRlbmRzIENvbXBpbGVkRXhwcmVzc2lvbjxib29sZWFuPiB7XG4gIHB1YmxpYyB0eXBlID0gXCJoYXMtYmxvY2tcIjtcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgYmxvY2tOYW1lOiBzdHJpbmcsIHB1YmxpYyBibG9ja1N5bWJvbDogbnVtYmVyKSB7XG4gICAgc3VwZXIoKTtcbiAgfVxuXG4gIGV2YWx1YXRlKHZtOiBWTSk6IFZhbHVlUmVmZXJlbmNlPGJvb2xlYW4+IHtcbiAgICBsZXQgYmxvY2tSZWYgPSB2bS5zY29wZSgpLmdldEJsb2NrKHRoaXMuYmxvY2tTeW1ib2wpO1xuICAgIHJldHVybiBuZXcgVmFsdWVSZWZlcmVuY2UoISFibG9ja1JlZik7XG4gIH1cblxuICB0b0pTT04oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYGhhcy1ibG9jaygke3RoaXMuYmxvY2tOYW1lfSlgO1xuICB9XG59XG4iXX0=
enifed('glimmer-runtime/lib/compiled/expressions/helper', ['exports', 'glimmer-runtime/lib/compiled/expressions'], function (exports, _glimmerRuntimeLibCompiledExpressions) {
    'use strict';

    var CompiledHelper = (function (_CompiledExpression) {
        babelHelpers.inherits(CompiledHelper, _CompiledExpression);

        function CompiledHelper(name, helper, args, symbolTable) {
            _CompiledExpression.call(this);
            this.name = name;
            this.helper = helper;
            this.args = args;
            this.symbolTable = symbolTable;
            this.type = "helper";
        }

        CompiledHelper.prototype.evaluate = function evaluate(vm) {
            var helper = this.helper;

            return helper(vm, this.args.evaluate(vm), this.symbolTable);
        };

        CompiledHelper.prototype.toJSON = function toJSON() {
            return '`' + this.name.join('.') + '($ARGS)`';
        };

        return CompiledHelper;
    })(_glimmerRuntimeLibCompiledExpressions.CompiledExpression);

    exports.default = CompiledHelper;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/expressions/lookups', ['exports', 'glimmer-runtime/lib/compiled/expressions', 'glimmer-reference'], function (exports, _glimmerRuntimeLibCompiledExpressions, _glimmerReference) {
    'use strict';

    var CompiledLocalLookup = (function (_CompiledExpression) {
        babelHelpers.inherits(CompiledLocalLookup, _CompiledExpression);

        function CompiledLocalLookup(symbol, path, debug) {
            _CompiledExpression.call(this);
            this.symbol = symbol;
            this.path = path;
            this.debug = debug;
            this.type = "local-lookup";
        }

        CompiledLocalLookup.prototype.evaluate = function evaluate(vm) {
            var base = vm.referenceForSymbol(this.symbol);
            return _glimmerReference.referenceFromParts(base, this.path);
        };

        CompiledLocalLookup.prototype.toJSON = function toJSON() {
            var debug = this.debug;
            var symbol = this.symbol;
            var path = this.path;

            if (path.length) {
                return '$' + symbol + '(' + debug + ').' + path.join('.');
            } else {
                return '$' + symbol + '(' + debug + ')';
            }
        };

        return CompiledLocalLookup;
    })(_glimmerRuntimeLibCompiledExpressions.CompiledExpression);

    exports.CompiledLocalLookup = CompiledLocalLookup;

    var CompiledSelfLookup = (function (_CompiledExpression2) {
        babelHelpers.inherits(CompiledSelfLookup, _CompiledExpression2);

        function CompiledSelfLookup(parts) {
            _CompiledExpression2.call(this);
            this.parts = parts;
            this.type = "self-lookup";
        }

        CompiledSelfLookup.prototype.evaluate = function evaluate(vm) {
            return _glimmerReference.referenceFromParts(vm.getSelf(), this.parts);
        };

        CompiledSelfLookup.prototype.toJSON = function toJSON() {
            var path = ['self'];
            path.push.apply(path, this.parts);
            return path.join('.');
        };

        return CompiledSelfLookup;
    })(_glimmerRuntimeLibCompiledExpressions.CompiledExpression);

    exports.CompiledSelfLookup = CompiledSelfLookup;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/expressions/named-args', ['exports', 'glimmer-runtime/lib/references', 'glimmer-runtime/lib/utils', 'glimmer-reference', 'glimmer-util'], function (exports, _glimmerRuntimeLibReferences, _glimmerRuntimeLibUtils, _glimmerReference, _glimmerUtil) {
    'use strict';

    var CompiledNamedArgs = (function () {
        function CompiledNamedArgs(keys, values) {
            this.keys = keys;
            this.values = values;
            this.length = keys.length;
            _glimmerUtil.assert(keys.length === values.length, 'Keys and values do not have the same length');
        }

        CompiledNamedArgs.empty = function empty() {
            return COMPILED_EMPTY_NAMED_ARGS;
        };

        CompiledNamedArgs.create = function create(map) {
            var keys = Object.keys(map);
            var length = keys.length;
            if (length > 0) {
                var values = [];
                for (var i = 0; i < length; i++) {
                    values[i] = map[keys[i]];
                }
                return new this(keys, values);
            } else {
                return COMPILED_EMPTY_NAMED_ARGS;
            }
        };

        CompiledNamedArgs.prototype.evaluate = function evaluate(vm) {
            var keys = this.keys;
            var values = this.values;
            var length = this.length;

            var evaluated = new Array(length);
            for (var i = 0; i < length; i++) {
                evaluated[i] = values[i].evaluate(vm);
            }
            return new EvaluatedNamedArgs(keys, evaluated);
        };

        CompiledNamedArgs.prototype.toJSON = function toJSON() {
            var keys = this.keys;
            var values = this.values;

            var inner = keys.map(function (key, i) {
                return key + ': ' + values[i].toJSON();
            }).join(", ");
            return '{' + inner + '}';
        };

        return CompiledNamedArgs;
    })();

    exports.CompiledNamedArgs = CompiledNamedArgs;
    var COMPILED_EMPTY_NAMED_ARGS = new ((function (_CompiledNamedArgs) {
        babelHelpers.inherits(_class, _CompiledNamedArgs);

        function _class() {
            _CompiledNamedArgs.call(this, _glimmerRuntimeLibUtils.EMPTY_ARRAY, _glimmerRuntimeLibUtils.EMPTY_ARRAY);
        }

        _class.prototype.evaluate = function evaluate(vm) {
            return EVALUATED_EMPTY_NAMED_ARGS;
        };

        _class.prototype.toJSON = function toJSON() {
            return '<EMPTY>';
        };

        return _class;
    })(CompiledNamedArgs))();
    exports.COMPILED_EMPTY_NAMED_ARGS = COMPILED_EMPTY_NAMED_ARGS;

    var EvaluatedNamedArgs = (function () {
        function EvaluatedNamedArgs(keys, values) {
            var _map = arguments.length <= 2 || arguments[2] === undefined ? undefined : arguments[2];

            this.keys = keys;
            this.values = values;
            this._map = _map;
            this.tag = _glimmerReference.combineTagged(values);
            this.length = keys.length;
            _glimmerUtil.assert(keys.length === values.length, 'Keys and values do not have the same length');
        }

        EvaluatedNamedArgs.create = function create(map) {
            var keys = Object.keys(map);
            var length = keys.length;
            if (length > 0) {
                var values = new Array(length);
                for (var i = 0; i < length; i++) {
                    values[i] = map[keys[i]];
                }
                return new this(keys, values, map);
            } else {
                return EVALUATED_EMPTY_NAMED_ARGS;
            }
        };

        EvaluatedNamedArgs.empty = function empty() {
            return EVALUATED_EMPTY_NAMED_ARGS;
        };

        EvaluatedNamedArgs.prototype.get = function get(key) {
            var keys = this.keys;
            var values = this.values;

            var index = keys.indexOf(key);
            return index === -1 ? _glimmerRuntimeLibReferences.UNDEFINED_REFERENCE : values[index];
        };

        EvaluatedNamedArgs.prototype.has = function has(key) {
            return this.keys.indexOf(key) !== -1;
        };

        EvaluatedNamedArgs.prototype.value = function value() {
            var keys = this.keys;
            var values = this.values;

            var out = _glimmerUtil.dict();
            for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                var ref = values[i];
                out[key] = ref.value();
            }
            return out;
        };

        babelHelpers.createClass(EvaluatedNamedArgs, [{
            key: 'map',
            get: function () {
                var map = this._map;

                if (map) {
                    return map;
                }
                map = this._map = _glimmerUtil.dict();
                var keys = this.keys;
                var values = this.values;
                var length = this.length;

                for (var i = 0; i < length; i++) {
                    map[keys[i]] = values[i];
                }
                return map;
            }
        }]);
        return EvaluatedNamedArgs;
    })();

    exports.EvaluatedNamedArgs = EvaluatedNamedArgs;
    var EVALUATED_EMPTY_NAMED_ARGS = new ((function (_EvaluatedNamedArgs) {
        babelHelpers.inherits(_class2, _EvaluatedNamedArgs);

        function _class2() {
            _EvaluatedNamedArgs.call(this, _glimmerRuntimeLibUtils.EMPTY_ARRAY, _glimmerRuntimeLibUtils.EMPTY_ARRAY, _glimmerRuntimeLibUtils.EMPTY_DICT);
        }

        _class2.prototype.get = function get() {
            return _glimmerRuntimeLibReferences.UNDEFINED_REFERENCE;
        };

        _class2.prototype.has = function has(key) {
            return false;
        };

        _class2.prototype.value = function value() {
            return _glimmerRuntimeLibUtils.EMPTY_DICT;
        };

        return _class2;
    })(EvaluatedNamedArgs))();
    exports.EVALUATED_EMPTY_NAMED_ARGS = EVALUATED_EMPTY_NAMED_ARGS;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/expressions/positional-args', ['exports', 'glimmer-runtime/lib/references', 'glimmer-runtime/lib/utils', 'glimmer-reference'], function (exports, _glimmerRuntimeLibReferences, _glimmerRuntimeLibUtils, _glimmerReference) {
    'use strict';

    var CompiledPositionalArgs = (function () {
        function CompiledPositionalArgs(values) {
            this.values = values;
            this.length = values.length;
        }

        CompiledPositionalArgs.create = function create(values) {
            if (values.length) {
                return new this(values);
            } else {
                return COMPILED_EMPTY_POSITIONAL_ARGS;
            }
        };

        CompiledPositionalArgs.empty = function empty() {
            return COMPILED_EMPTY_POSITIONAL_ARGS;
        };

        CompiledPositionalArgs.prototype.evaluate = function evaluate(vm) {
            var values = this.values;
            var length = this.length;

            var references = new Array(length);
            for (var i = 0; i < length; i++) {
                references[i] = values[i].evaluate(vm);
            }
            return EvaluatedPositionalArgs.create(references);
        };

        CompiledPositionalArgs.prototype.toJSON = function toJSON() {
            return '[' + this.values.map(function (value) {
                return value.toJSON();
            }).join(", ") + ']';
        };

        return CompiledPositionalArgs;
    })();

    exports.CompiledPositionalArgs = CompiledPositionalArgs;
    var COMPILED_EMPTY_POSITIONAL_ARGS = new ((function (_CompiledPositionalArgs) {
        babelHelpers.inherits(_class, _CompiledPositionalArgs);

        function _class() {
            _CompiledPositionalArgs.call(this, _glimmerRuntimeLibUtils.EMPTY_ARRAY);
        }

        _class.prototype.evaluate = function evaluate(vm) {
            return EVALUATED_EMPTY_POSITIONAL_ARGS;
        };

        _class.prototype.toJSON = function toJSON() {
            return '<EMPTY>';
        };

        return _class;
    })(CompiledPositionalArgs))();
    exports.COMPILED_EMPTY_POSITIONAL_ARGS = COMPILED_EMPTY_POSITIONAL_ARGS;

    var EvaluatedPositionalArgs = (function () {
        function EvaluatedPositionalArgs(values) {
            this.values = values;
            this.tag = _glimmerReference.combineTagged(values);
            this.length = values.length;
        }

        EvaluatedPositionalArgs.create = function create(values) {
            return new this(values);
        };

        EvaluatedPositionalArgs.empty = function empty() {
            return EVALUATED_EMPTY_POSITIONAL_ARGS;
        };

        EvaluatedPositionalArgs.prototype.at = function at(index) {
            var values = this.values;
            var length = this.length;

            return index < length ? values[index] : _glimmerRuntimeLibReferences.UNDEFINED_REFERENCE;
        };

        EvaluatedPositionalArgs.prototype.value = function value() {
            var values = this.values;
            var length = this.length;

            var ret = new Array(length);
            for (var i = 0; i < length; i++) {
                ret[i] = values[i].value();
            }
            return ret;
        };

        return EvaluatedPositionalArgs;
    })();

    exports.EvaluatedPositionalArgs = EvaluatedPositionalArgs;
    var EVALUATED_EMPTY_POSITIONAL_ARGS = new ((function (_EvaluatedPositionalArgs) {
        babelHelpers.inherits(_class2, _EvaluatedPositionalArgs);

        function _class2() {
            _EvaluatedPositionalArgs.call(this, _glimmerRuntimeLibUtils.EMPTY_ARRAY);
        }

        _class2.prototype.at = function at() {
            return _glimmerRuntimeLibReferences.UNDEFINED_REFERENCE;
        };

        _class2.prototype.value = function value() {
            return this.values;
        };

        return _class2;
    })(EvaluatedPositionalArgs))();
    exports.EVALUATED_EMPTY_POSITIONAL_ARGS = EVALUATED_EMPTY_POSITIONAL_ARGS;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/expressions/value', ['exports', 'glimmer-runtime/lib/compiled/expressions', 'glimmer-reference', 'glimmer-util'], function (exports, _glimmerRuntimeLibCompiledExpressions, _glimmerReference, _glimmerUtil) {
    'use strict';

    var CompiledValue = (function (_CompiledExpression) {
        babelHelpers.inherits(CompiledValue, _CompiledExpression);

        function CompiledValue(value) {
            _CompiledExpression.call(this);
            this.type = "value";
            this.reference = new ValueReference(value);
        }

        CompiledValue.prototype.evaluate = function evaluate(vm) {
            return this.reference;
        };

        CompiledValue.prototype.toJSON = function toJSON() {
            return JSON.stringify(this.reference.value());
        };

        return CompiledValue;
    })(_glimmerRuntimeLibCompiledExpressions.CompiledExpression);

    exports.default = CompiledValue;

    var ValueReference = (function (_ConstReference) {
        babelHelpers.inherits(ValueReference, _ConstReference);

        function ValueReference() {
            _ConstReference.apply(this, arguments);
            this.children = _glimmerUtil.dict();
        }

        ValueReference.prototype.get = function get(key) {
            var children = this.children;

            var child = children[key];
            if (!child) {
                child = children[key] = new ValueReference(this.inner[key]);
            }
            return child;
        };

        ValueReference.prototype.value = function value() {
            return this.inner;
        };

        return ValueReference;
    })(_glimmerReference.ConstReference);

    exports.ValueReference = ValueReference;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/opcodes/builder', ['exports', 'glimmer-runtime/lib/compiled/opcodes/component', 'glimmer-runtime/lib/compiled/opcodes/partial', 'glimmer-runtime/lib/compiled/opcodes/content', 'glimmer-runtime/lib/compiled/opcodes/dom', 'glimmer-runtime/lib/compiled/opcodes/lists', 'glimmer-runtime/lib/compiled/opcodes/vm', 'glimmer-util', 'glimmer-runtime/lib/utils'], function (exports, _glimmerRuntimeLibCompiledOpcodesComponent, _glimmerRuntimeLibCompiledOpcodesPartial, _glimmerRuntimeLibCompiledOpcodesContent, _glimmerRuntimeLibCompiledOpcodesDom, _glimmerRuntimeLibCompiledOpcodesLists, _glimmerRuntimeLibCompiledOpcodesVm, _glimmerUtil, _glimmerRuntimeLibUtils) {
    'use strict';

    var StatementCompilationBufferProxy = (function () {
        function StatementCompilationBufferProxy(inner) {
            this.inner = inner;
        }

        StatementCompilationBufferProxy.prototype.toOpSeq = function toOpSeq() {
            return this.inner.toOpSeq();
        };

        StatementCompilationBufferProxy.prototype.append = function append(opcode) {
            this.inner.append(opcode);
        };

        StatementCompilationBufferProxy.prototype.getLocalSymbol = function getLocalSymbol(name) {
            return this.inner.getLocalSymbol(name);
        };

        StatementCompilationBufferProxy.prototype.hasLocalSymbol = function hasLocalSymbol(name) {
            return this.inner.hasLocalSymbol(name);
        };

        StatementCompilationBufferProxy.prototype.getNamedSymbol = function getNamedSymbol(name) {
            return this.inner.getNamedSymbol(name);
        };

        StatementCompilationBufferProxy.prototype.hasNamedSymbol = function hasNamedSymbol(name) {
            return this.inner.hasNamedSymbol(name);
        };

        StatementCompilationBufferProxy.prototype.getBlockSymbol = function getBlockSymbol(name) {
            return this.inner.getBlockSymbol(name);
        };

        StatementCompilationBufferProxy.prototype.hasBlockSymbol = function hasBlockSymbol(name) {
            return this.inner.hasBlockSymbol(name);
        };

        StatementCompilationBufferProxy.prototype.getPartialArgsSymbol = function getPartialArgsSymbol() {
            return this.inner.getPartialArgsSymbol();
        };

        StatementCompilationBufferProxy.prototype.hasPartialArgsSymbol = function hasPartialArgsSymbol() {
            return this.inner.hasPartialArgsSymbol();
        };

        babelHelpers.createClass(StatementCompilationBufferProxy, [{
            key: 'component',
            get: function () {
                return this.inner.component;
            }
        }]);
        return StatementCompilationBufferProxy;
    })();

    exports.StatementCompilationBufferProxy = StatementCompilationBufferProxy;

    var BasicOpcodeBuilder = (function (_StatementCompilationBufferProxy) {
        babelHelpers.inherits(BasicOpcodeBuilder, _StatementCompilationBufferProxy);

        function BasicOpcodeBuilder(inner, symbolTable, env) {
            _StatementCompilationBufferProxy.call(this, inner);
            this.symbolTable = symbolTable;
            this.env = env;
            this.labelsStack = new _glimmerUtil.Stack();
            this.templatesStack = new _glimmerUtil.Stack();
        }

        // helpers

        BasicOpcodeBuilder.prototype.startBlock = function startBlock(templates) {
            this.templatesStack.push(templates);
        };

        BasicOpcodeBuilder.prototype.endBlock = function endBlock() {
            this.templatesStack.pop();
        };

        BasicOpcodeBuilder.prototype.startLabels = function startLabels() {
            this.labelsStack.push(_glimmerUtil.dict());
        };

        BasicOpcodeBuilder.prototype.stopLabels = function stopLabels() {
            this.labelsStack.pop();
        };

        BasicOpcodeBuilder.prototype.labelFor = function labelFor(name) {
            var labels = this.labels;
            var label = labels[name];
            if (!label) {
                label = labels[name] = new _glimmerRuntimeLibCompiledOpcodesVm.LabelOpcode(name);
            }
            return label;
        };

        // partials

        BasicOpcodeBuilder.prototype.putPartialDefinition = function putPartialDefinition(definition) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesPartial.PutPartialDefinitionOpcode(definition));
        };

        BasicOpcodeBuilder.prototype.putDynamicPartialDefinition = function putDynamicPartialDefinition() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesPartial.PutDynamicPartialDefinitionOpcode(this.symbolTable));
        };

        BasicOpcodeBuilder.prototype.evaluatePartial = function evaluatePartial() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesPartial.EvaluatePartialOpcode(this.symbolTable));
        };

        // components

        BasicOpcodeBuilder.prototype.putComponentDefinition = function putComponentDefinition(definition) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesComponent.PutComponentDefinitionOpcode(definition));
        };

        BasicOpcodeBuilder.prototype.putDynamicComponentDefinition = function putDynamicComponentDefinition() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesComponent.PutDynamicComponentDefinitionOpcode());
        };

        BasicOpcodeBuilder.prototype.openComponent = function openComponent(args) {
            var shadow = arguments.length <= 1 || arguments[1] === undefined ? _glimmerRuntimeLibUtils.EMPTY_ARRAY : arguments[1];

            this.append(new _glimmerRuntimeLibCompiledOpcodesComponent.OpenComponentOpcode(this.compile(args), shadow, this.templates));
        };

        BasicOpcodeBuilder.prototype.didCreateElement = function didCreateElement() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesComponent.DidCreateElementOpcode());
        };

        BasicOpcodeBuilder.prototype.shadowAttributes = function shadowAttributes() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesComponent.ShadowAttributesOpcode());
        };

        BasicOpcodeBuilder.prototype.didRenderLayout = function didRenderLayout() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesComponent.DidRenderLayoutOpcode());
        };

        BasicOpcodeBuilder.prototype.closeComponent = function closeComponent() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesComponent.CloseComponentOpcode());
        };

        // content

        BasicOpcodeBuilder.prototype.cautiousAppend = function cautiousAppend() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesContent.OptimizedCautiousAppendOpcode());
        };

        BasicOpcodeBuilder.prototype.trustingAppend = function trustingAppend() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesContent.OptimizedTrustingAppendOpcode());
        };

        // dom

        BasicOpcodeBuilder.prototype.text = function text(_text) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.TextOpcode(_text));
        };

        BasicOpcodeBuilder.prototype.openPrimitiveElement = function openPrimitiveElement(tag) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.OpenPrimitiveElementOpcode(tag));
        };

        BasicOpcodeBuilder.prototype.openComponentElement = function openComponentElement(tag) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.OpenComponentElementOpcode(tag));
        };

        BasicOpcodeBuilder.prototype.openDynamicPrimitiveElement = function openDynamicPrimitiveElement() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.OpenDynamicPrimitiveElementOpcode());
        };

        BasicOpcodeBuilder.prototype.flushElement = function flushElement() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.FlushElementOpcode());
        };

        BasicOpcodeBuilder.prototype.closeElement = function closeElement() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.CloseElementOpcode());
        };

        BasicOpcodeBuilder.prototype.staticAttr = function staticAttr(name, namespace, value) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.StaticAttrOpcode(name, namespace, value));
        };

        BasicOpcodeBuilder.prototype.dynamicAttrNS = function dynamicAttrNS(name, namespace, isTrusting) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.DynamicAttrNSOpcode(name, namespace, isTrusting));
        };

        BasicOpcodeBuilder.prototype.dynamicAttr = function dynamicAttr(name, isTrusting) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.DynamicAttrOpcode(name, isTrusting));
        };

        BasicOpcodeBuilder.prototype.comment = function comment(_comment) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.CommentOpcode(_comment));
        };

        // lists

        BasicOpcodeBuilder.prototype.putIterator = function putIterator() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesLists.PutIteratorOpcode());
        };

        BasicOpcodeBuilder.prototype.enterList = function enterList(start, end) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesLists.EnterListOpcode(this.labelFor(start), this.labelFor(end)));
        };

        BasicOpcodeBuilder.prototype.exitList = function exitList() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesLists.ExitListOpcode());
        };

        BasicOpcodeBuilder.prototype.enterWithKey = function enterWithKey(start, end) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesLists.EnterWithKeyOpcode(this.labelFor(start), this.labelFor(end)));
        };

        BasicOpcodeBuilder.prototype.nextIter = function nextIter(end) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesLists.NextIterOpcode(this.labelFor(end)));
        };

        // vm

        BasicOpcodeBuilder.prototype.pushRemoteElement = function pushRemoteElement() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.PushRemoteElementOpcode());
        };

        BasicOpcodeBuilder.prototype.popRemoteElement = function popRemoteElement() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.PopRemoteElementOpcode());
        };

        BasicOpcodeBuilder.prototype.popElement = function popElement() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesDom.PopElementOpcode());
        };

        BasicOpcodeBuilder.prototype.label = function label(name) {
            this.append(this.labelFor(name));
        };

        BasicOpcodeBuilder.prototype.pushChildScope = function pushChildScope() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.PushChildScopeOpcode());
        };

        BasicOpcodeBuilder.prototype.popScope = function popScope() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.PopScopeOpcode());
        };

        BasicOpcodeBuilder.prototype.pushDynamicScope = function pushDynamicScope() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.PushDynamicScopeOpcode());
        };

        BasicOpcodeBuilder.prototype.popDynamicScope = function popDynamicScope() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.PopDynamicScopeOpcode());
        };

        BasicOpcodeBuilder.prototype.putNull = function putNull() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.PutNullOpcode());
        };

        BasicOpcodeBuilder.prototype.putValue = function putValue(expression) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.PutValueOpcode(this.compile(expression)));
        };

        BasicOpcodeBuilder.prototype.putArgs = function putArgs(args) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.PutArgsOpcode(this.compile(args)));
        };

        BasicOpcodeBuilder.prototype.bindDynamicScope = function bindDynamicScope(names) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.BindDynamicScopeOpcode(names));
        };

        BasicOpcodeBuilder.prototype.bindPositionalArgs = function bindPositionalArgs(names, symbols) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.BindPositionalArgsOpcode(names, symbols));
        };

        BasicOpcodeBuilder.prototype.bindNamedArgs = function bindNamedArgs(names, symbols) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.BindNamedArgsOpcode(names, symbols));
        };

        BasicOpcodeBuilder.prototype.bindBlocks = function bindBlocks(names, symbols) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.BindBlocksOpcode(names, symbols));
        };

        BasicOpcodeBuilder.prototype.enter = function enter(_enter, exit) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.EnterOpcode(this.labelFor(_enter), this.labelFor(exit)));
        };

        BasicOpcodeBuilder.prototype.exit = function exit() {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.ExitOpcode());
        };

        BasicOpcodeBuilder.prototype.evaluate = function evaluate(name) {
            var block = arguments.length <= 1 || arguments[1] === undefined ? this.templates[name] : arguments[1];
            return (function () {
                this.append(new _glimmerRuntimeLibCompiledOpcodesVm.EvaluateOpcode(name, block));
            }).apply(this, arguments);
        };

        BasicOpcodeBuilder.prototype.test = function test(testFunc) {
            if (testFunc === 'const') {
                this.append(new _glimmerRuntimeLibCompiledOpcodesVm.TestOpcode(_glimmerRuntimeLibCompiledOpcodesVm.ConstTest));
            } else if (testFunc === 'simple') {
                this.append(new _glimmerRuntimeLibCompiledOpcodesVm.TestOpcode(_glimmerRuntimeLibCompiledOpcodesVm.SimpleTest));
            } else if (testFunc === 'environment') {
                this.append(new _glimmerRuntimeLibCompiledOpcodesVm.TestOpcode(_glimmerRuntimeLibCompiledOpcodesVm.EnvironmentTest));
            } else if (typeof testFunc === 'function') {
                this.append(new _glimmerRuntimeLibCompiledOpcodesVm.TestOpcode(testFunc));
            } else {
                throw new Error('unreachable');
            }
        };

        BasicOpcodeBuilder.prototype.jump = function jump(target) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.JumpOpcode(this.labelFor(target)));
        };

        BasicOpcodeBuilder.prototype.jumpIf = function jumpIf(target) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.JumpIfOpcode(this.labelFor(target)));
        };

        BasicOpcodeBuilder.prototype.jumpUnless = function jumpUnless(target) {
            this.append(new _glimmerRuntimeLibCompiledOpcodesVm.JumpUnlessOpcode(this.labelFor(target)));
        };

        babelHelpers.createClass(BasicOpcodeBuilder, [{
            key: 'labels',
            get: function () {
                return this.labelsStack.current;
            }
        }, {
            key: 'templates',
            get: function () {
                return this.templatesStack.current;
            }
        }]);
        return BasicOpcodeBuilder;
    })(StatementCompilationBufferProxy);

    exports.BasicOpcodeBuilder = BasicOpcodeBuilder;

    function isCompilableExpression(expr) {
        return expr && typeof expr['compile'] === 'function';
    }
    var SIMPLE_BLOCK = { templates: null };

    var OpcodeBuilder = (function (_BasicOpcodeBuilder) {
        babelHelpers.inherits(OpcodeBuilder, _BasicOpcodeBuilder);

        function OpcodeBuilder() {
            _BasicOpcodeBuilder.apply(this, arguments);
        }

        OpcodeBuilder.prototype.compile = function compile(expr) {
            if (isCompilableExpression(expr)) {
                return expr.compile(this, this.env, this.symbolTable);
            } else {
                return expr;
            }
        };

        OpcodeBuilder.prototype.bindPositionalArgsForBlock = function bindPositionalArgsForBlock(block) {
            this.append(_glimmerRuntimeLibCompiledOpcodesVm.BindPositionalArgsOpcode.create(block));
        };

        OpcodeBuilder.prototype.bindNamedArgsForLayout = function bindNamedArgsForLayout(layout) {
            this.append(_glimmerRuntimeLibCompiledOpcodesVm.BindNamedArgsOpcode.create(layout));
        };

        OpcodeBuilder.prototype.bindBlocksForLayout = function bindBlocksForLayout(layout) {
            this.append(_glimmerRuntimeLibCompiledOpcodesVm.BindBlocksOpcode.create(layout));
        };

        OpcodeBuilder.prototype.bindPartialArgsForLayout = function bindPartialArgsForLayout(layout) {
            this.append(_glimmerRuntimeLibCompiledOpcodesVm.BindPartialArgsOpcode.create(layout));
        };

        OpcodeBuilder.prototype.simpleBlock = function simpleBlock(callback) {
            this.block(SIMPLE_BLOCK, callback);
        };

        // TODO
        // come back to this

        OpcodeBuilder.prototype.block = function block(_ref, callback) {
            var templates = _ref.templates;
            var args = _ref.args;

            if (args) this.putArgs(args);
            this.startLabels();
            this.startBlock(templates);
            this.enter('BEGIN', 'END');
            this.label('BEGIN');
            callback(this, 'BEGIN', 'END');
            this.label('END');
            this.exit();
            this.endBlock();
            this.stopLabels();
        };

        // TODO
        // come back to this

        OpcodeBuilder.prototype.iter = function iter(_ref2, callback) {
            var templates = _ref2.templates;

            this.startLabels();
            this.startBlock(templates);
            this.enterList('BEGIN', 'END');
            this.label('ITER');
            this.nextIter('BREAK');
            this.enterWithKey('BEGIN', 'END');
            this.label('BEGIN');
            callback(this, 'BEGIN', 'END');
            this.label('END');
            this.exit();
            this.jump('ITER');
            this.label('BREAK');
            this.exitList();
            this.endBlock();
            this.stopLabels();
        };

        // TODO
        // come back to this

        OpcodeBuilder.prototype.unit = function unit(_ref3, callback) {
            var templates = _ref3.templates;

            this.startLabels();
            this.startBlock(templates);
            callback(this);
            this.endBlock();
            this.stopLabels();
        };

        return OpcodeBuilder;
    })(BasicOpcodeBuilder);

    exports.default = OpcodeBuilder;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/opcodes/component', ['exports', 'glimmer-runtime/lib/opcodes', 'glimmer-runtime/lib/compiled/opcodes/vm', 'glimmer-reference'], function (exports, _glimmerRuntimeLibOpcodes, _glimmerRuntimeLibCompiledOpcodesVm, _glimmerReference) {
    'use strict';

    var PutDynamicComponentDefinitionOpcode = (function (_Opcode) {
        babelHelpers.inherits(PutDynamicComponentDefinitionOpcode, _Opcode);

        function PutDynamicComponentDefinitionOpcode() {
            _Opcode.apply(this, arguments);
            this.type = "put-dynamic-component-definition";
        }

        PutDynamicComponentDefinitionOpcode.prototype.evaluate = function evaluate(vm) {
            var reference = vm.frame.getOperand();
            var cache = _glimmerReference.isConst(reference) ? undefined : new _glimmerReference.ReferenceCache(reference);
            var definition = cache ? cache.peek() : reference.value();
            vm.frame.setImmediate(definition);
            if (cache) {
                vm.updateWith(new _glimmerRuntimeLibCompiledOpcodesVm.Assert(cache));
            }
        };

        PutDynamicComponentDefinitionOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$OPERAND"]
            };
        };

        return PutDynamicComponentDefinitionOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutDynamicComponentDefinitionOpcode = PutDynamicComponentDefinitionOpcode;

    var PutComponentDefinitionOpcode = (function (_Opcode2) {
        babelHelpers.inherits(PutComponentDefinitionOpcode, _Opcode2);

        function PutComponentDefinitionOpcode(definition) {
            _Opcode2.call(this);
            this.definition = definition;
            this.type = "put-component-definition";
        }

        PutComponentDefinitionOpcode.prototype.evaluate = function evaluate(vm) {
            vm.frame.setImmediate(this.definition);
        };

        PutComponentDefinitionOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.definition.name)]
            };
        };

        return PutComponentDefinitionOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutComponentDefinitionOpcode = PutComponentDefinitionOpcode;

    var OpenComponentOpcode = (function (_Opcode3) {
        babelHelpers.inherits(OpenComponentOpcode, _Opcode3);

        function OpenComponentOpcode(args, shadow, templates) {
            _Opcode3.call(this);
            this.args = args;
            this.shadow = shadow;
            this.templates = templates;
            this.type = "open-component";
        }

        OpenComponentOpcode.prototype.evaluate = function evaluate(vm) {
            var rawArgs = this.args;
            var shadow = this.shadow;
            var templates = this.templates;

            var definition = vm.frame.getImmediate();
            var dynamicScope = vm.pushDynamicScope();
            var callerScope = vm.scope();
            var manager = definition.manager;
            var hasDefaultBlock = templates && !!templates.default; // TODO Cleanup?
            var args = manager.prepareArgs(definition, rawArgs.evaluate(vm), dynamicScope);
            var component = manager.create(vm.env, definition, args, dynamicScope, vm.getSelf(), hasDefaultBlock);
            var destructor = manager.getDestructor(component);
            if (destructor) vm.newDestroyable(destructor);
            var layout = manager.layoutFor(definition, component, vm.env);
            var selfRef = manager.getSelf(component);
            vm.beginCacheGroup();
            vm.stack().pushSimpleBlock();
            vm.pushRootScope(selfRef, layout.symbols);
            vm.invokeLayout(args, layout, templates, callerScope, component, manager, shadow);
            vm.updateWith(new UpdateComponentOpcode(definition.name, component, manager, args, dynamicScope));
        };

        OpenComponentOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$OPERAND"]
            };
        };

        return OpenComponentOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.OpenComponentOpcode = OpenComponentOpcode;

    var UpdateComponentOpcode = (function (_UpdatingOpcode) {
        babelHelpers.inherits(UpdateComponentOpcode, _UpdatingOpcode);

        function UpdateComponentOpcode(name, component, manager, args, dynamicScope) {
            _UpdatingOpcode.call(this);
            this.name = name;
            this.component = component;
            this.manager = manager;
            this.args = args;
            this.dynamicScope = dynamicScope;
            this.type = "update-component";
            var componentTag = manager.getTag(component);
            if (componentTag) {
                this.tag = _glimmerReference.combine([args.tag, componentTag]);
            } else {
                this.tag = args.tag;
            }
        }

        UpdateComponentOpcode.prototype.evaluate = function evaluate(vm) {
            var component = this.component;
            var manager = this.manager;
            var args = this.args;
            var dynamicScope = this.dynamicScope;

            manager.update(component, args, dynamicScope);
        };

        UpdateComponentOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.name)]
            };
        };

        return UpdateComponentOpcode;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    exports.UpdateComponentOpcode = UpdateComponentOpcode;

    var DidCreateElementOpcode = (function (_Opcode4) {
        babelHelpers.inherits(DidCreateElementOpcode, _Opcode4);

        function DidCreateElementOpcode() {
            _Opcode4.apply(this, arguments);
            this.type = "did-create-element";
        }

        // Slow path for non-specialized component invocations. Uses an internal
        // named lookup on the args.

        DidCreateElementOpcode.prototype.evaluate = function evaluate(vm) {
            var manager = vm.frame.getManager();
            var component = vm.frame.getComponent();
            manager.didCreateElement(component, vm.stack().constructing, vm.stack().operations);
        };

        DidCreateElementOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$ARGS"]
            };
        };

        return DidCreateElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.DidCreateElementOpcode = DidCreateElementOpcode;

    var ShadowAttributesOpcode = (function (_Opcode5) {
        babelHelpers.inherits(ShadowAttributesOpcode, _Opcode5);

        function ShadowAttributesOpcode() {
            _Opcode5.apply(this, arguments);
            this.type = "shadow-attributes";
        }

        ShadowAttributesOpcode.prototype.evaluate = function evaluate(vm) {
            var shadow = vm.frame.getShadow();
            if (!shadow) return;

            var _vm$frame$getArgs = vm.frame.getArgs();

            var named = _vm$frame$getArgs.named;

            shadow.forEach(function (name) {
                vm.stack().setDynamicAttribute(name, named.get(name), false);
            });
        };

        ShadowAttributesOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$ARGS"]
            };
        };

        return ShadowAttributesOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.ShadowAttributesOpcode = ShadowAttributesOpcode;

    var DidRenderLayoutOpcode = (function (_Opcode6) {
        babelHelpers.inherits(DidRenderLayoutOpcode, _Opcode6);

        function DidRenderLayoutOpcode() {
            _Opcode6.apply(this, arguments);
            this.type = "did-render-layout";
        }

        DidRenderLayoutOpcode.prototype.evaluate = function evaluate(vm) {
            var manager = vm.frame.getManager();
            var component = vm.frame.getComponent();
            var bounds = vm.stack().popBlock();
            manager.didRenderLayout(component, bounds);
            vm.env.didCreate(component, manager);
            vm.updateWith(new DidUpdateLayoutOpcode(manager, component, bounds));
        };

        return DidRenderLayoutOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.DidRenderLayoutOpcode = DidRenderLayoutOpcode;

    var DidUpdateLayoutOpcode = (function (_UpdatingOpcode2) {
        babelHelpers.inherits(DidUpdateLayoutOpcode, _UpdatingOpcode2);

        function DidUpdateLayoutOpcode(manager, component, bounds) {
            _UpdatingOpcode2.call(this);
            this.manager = manager;
            this.component = component;
            this.bounds = bounds;
            this.type = "did-update-layout";
            this.tag = _glimmerReference.CONSTANT_TAG;
        }

        DidUpdateLayoutOpcode.prototype.evaluate = function evaluate(vm) {
            var manager = this.manager;
            var component = this.component;
            var bounds = this.bounds;

            manager.didUpdateLayout(component, bounds);
            vm.env.didUpdate(component, manager);
        };

        return DidUpdateLayoutOpcode;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    exports.DidUpdateLayoutOpcode = DidUpdateLayoutOpcode;

    var CloseComponentOpcode = (function (_Opcode7) {
        babelHelpers.inherits(CloseComponentOpcode, _Opcode7);

        function CloseComponentOpcode() {
            _Opcode7.apply(this, arguments);
            this.type = "close-component";
        }

        CloseComponentOpcode.prototype.evaluate = function evaluate(vm) {
            vm.popScope();
            vm.popDynamicScope();
            vm.commitCacheGroup();
        };

        return CloseComponentOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.CloseComponentOpcode = CloseComponentOpcode;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/opcodes/content', ['exports', 'glimmer-runtime/lib/upsert', 'glimmer-runtime/lib/component/interfaces', 'glimmer-runtime/lib/opcodes', 'glimmer-runtime/lib/vm/update', 'glimmer-reference', 'glimmer-util', 'glimmer-runtime/lib/bounds', 'glimmer-runtime/lib/builder', 'glimmer-runtime/lib/compiler', 'glimmer-runtime/lib/compiled/opcodes/builder', 'glimmer-runtime/lib/references', 'glimmer-runtime/lib/syntax/core'], function (exports, _glimmerRuntimeLibUpsert, _glimmerRuntimeLibComponentInterfaces, _glimmerRuntimeLibOpcodes, _glimmerRuntimeLibVmUpdate, _glimmerReference, _glimmerUtil, _glimmerRuntimeLibBounds, _glimmerRuntimeLibBuilder, _glimmerRuntimeLibCompiler, _glimmerRuntimeLibCompiledOpcodesBuilder, _glimmerRuntimeLibReferences, _glimmerRuntimeLibSyntaxCore) {
    'use strict';

    exports.normalizeTextValue = normalizeTextValue;

    function isEmpty(value) {
        return value === null || value === undefined || typeof value['toString'] !== 'function';
    }

    function normalizeTextValue(value) {
        if (isEmpty(value)) {
            return '';
        }
        return String(value);
    }

    function normalizeTrustedValue(value) {
        if (isEmpty(value)) {
            return '';
        }
        if (_glimmerRuntimeLibUpsert.isString(value)) {
            return value;
        }
        if (_glimmerRuntimeLibUpsert.isSafeString(value)) {
            return value.toHTML();
        }
        if (_glimmerRuntimeLibUpsert.isNode(value)) {
            return value;
        }
        return String(value);
    }
    function normalizeValue(value) {
        if (isEmpty(value)) {
            return '';
        }
        if (_glimmerRuntimeLibUpsert.isString(value)) {
            return value;
        }
        if (_glimmerRuntimeLibUpsert.isSafeString(value) || _glimmerRuntimeLibUpsert.isNode(value)) {
            return value;
        }
        return String(value);
    }

    var AppendOpcode = (function (_Opcode) {
        babelHelpers.inherits(AppendOpcode, _Opcode);

        function AppendOpcode() {
            _Opcode.apply(this, arguments);
        }

        AppendOpcode.prototype.evaluate = function evaluate(vm) {
            var reference = vm.frame.getOperand();
            var normalized = this.normalize(reference);
            var value = undefined,
                cache = undefined;
            if (_glimmerReference.isConst(reference)) {
                value = normalized.value();
            } else {
                cache = new _glimmerReference.ReferenceCache(normalized);
                value = cache.peek();
            }
            var stack = vm.stack();
            var upsert = this.insert(vm.env.getAppendOperations(), stack, value);
            var bounds = new _glimmerRuntimeLibBuilder.Fragment(upsert.bounds);
            stack.newBounds(bounds);
            if (cache /* i.e. !isConst(reference) */) {
                    vm.updateWith(this.updateWith(vm, reference, cache, bounds, upsert));
                }
        };

        AppendOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$OPERAND"]
            };
        };

        return AppendOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.AppendOpcode = AppendOpcode;

    var GuardedAppendOpcode = (function (_AppendOpcode) {
        babelHelpers.inherits(GuardedAppendOpcode, _AppendOpcode);

        function GuardedAppendOpcode(expression, symbolTable) {
            _AppendOpcode.call(this);
            this.expression = expression;
            this.symbolTable = symbolTable;
            this.deopted = null;
        }

        GuardedAppendOpcode.prototype.evaluate = function evaluate(vm) {
            if (this.deopted) {
                vm.pushEvalFrame(this.deopted);
            } else {
                vm.evaluateOperand(this.expression);
                var value = vm.frame.getOperand().value();
                if (_glimmerRuntimeLibComponentInterfaces.isComponentDefinition(value)) {
                    vm.pushEvalFrame(this.deopt(vm.env));
                } else {
                    _AppendOpcode.prototype.evaluate.call(this, vm);
                }
            }
        };

        GuardedAppendOpcode.prototype.deopt = function deopt(env) {
            var _this = this;

            // At compile time, we determined that this append callsite might refer
            // to a local variable/property lookup that resolves to a component
            // definition at runtime.
            //
            // We could have eagerly compiled this callsite into something like this:
            //
            //   {{#if (is-component-definition foo)}}
            //     {{component foo}}
            //   {{else}}
            //     {{foo}}
            //   {{/if}}
            //
            // However, in practice, there might be a large amout of these callsites
            // and most of them would resolve to a simple value lookup. Therefore, we
            // tried to be optimistic and assumed that the callsite will resolve to
            // appending a simple value.
            //
            // However, we have reached here because at runtime, the guard conditional
            // have detected that this callsite is indeed referring to a component
            // definition object. Since this is likely going to be true for other
            // instances of the same callsite, it is now appropiate to deopt into the
            // expanded version that handles both cases. The compilation would look
            // like this:
            //
            //               PutValue(expression)
            //               Test(is-component-definition)
            //               Enter(BEGIN, END)
            //   BEGIN:      Noop
            //               JumpUnless(VALUE)
            //               PutDynamicComponentDefinitionOpcode
            //               OpenComponent
            //               CloseComponent
            //               Jump(END)
            //   VALUE:      Noop
            //               OptimizedAppend
            //   END:        Noop
            //               Exit
            //
            // Keep in mind that even if we *don't* reach here at initial render time,
            // it is still possible (although quite rare) that the simple value we
            // encounter during initial render could later change into a component
            // definition object at update time. That is handled by the "lazy deopt"
            // code on the update side (scroll down for the next big block of comment).
            var buffer = new _glimmerRuntimeLibCompiler.CompileIntoList(env, null);
            var dsl = new _glimmerRuntimeLibCompiledOpcodesBuilder.default(buffer, this.symbolTable, env);
            dsl.putValue(this.expression);
            dsl.test(IsComponentDefinitionReference.create);
            dsl.simpleBlock(function (dsl, BEGIN, END) {
                dsl.jumpUnless('VALUE');
                dsl.putDynamicComponentDefinition();
                dsl.openComponent(_glimmerRuntimeLibSyntaxCore.Args.empty());
                dsl.closeComponent();
                dsl.jump(END);
                dsl.label('VALUE');
                dsl.append(new _this.AppendOpcode());
            });
            var deopted = this.deopted = dsl.toOpSeq();
            // From this point on, we have essentially replaced ourselve with a new set
            // of opcodes. Since we will always be executing the new/deopted code, it's
            // a good idea (as a pattern) to null out any unneeded fields here to avoid
            // holding on to unneeded/stale objects:
            this.expression = null;
            return deopted;
        };

        GuardedAppendOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var deopted = this.deopted;

            if (deopted) {
                return {
                    guid: guid,
                    type: type,
                    deopted: true,
                    children: deopted.toArray().map(function (op) {
                        return op.toJSON();
                    })
                };
            } else {
                return {
                    guid: guid,
                    type: type,
                    args: [this.expression.toJSON()]
                };
            }
        };

        return GuardedAppendOpcode;
    })(AppendOpcode);

    exports.GuardedAppendOpcode = GuardedAppendOpcode;

    var IsComponentDefinitionReference = (function (_ConditionalReference) {
        babelHelpers.inherits(IsComponentDefinitionReference, _ConditionalReference);

        function IsComponentDefinitionReference() {
            _ConditionalReference.apply(this, arguments);
        }

        IsComponentDefinitionReference.create = function create(inner) {
            return new IsComponentDefinitionReference(inner);
        };

        IsComponentDefinitionReference.prototype.toBool = function toBool(value) {
            return _glimmerRuntimeLibComponentInterfaces.isComponentDefinition(value);
        };

        return IsComponentDefinitionReference;
    })(_glimmerRuntimeLibReferences.ConditionalReference);

    var UpdateOpcode = (function (_UpdatingOpcode) {
        babelHelpers.inherits(UpdateOpcode, _UpdatingOpcode);

        function UpdateOpcode(cache, bounds, upsert) {
            _UpdatingOpcode.call(this);
            this.cache = cache;
            this.bounds = bounds;
            this.upsert = upsert;
            this.tag = cache.tag;
        }

        UpdateOpcode.prototype.evaluate = function evaluate(vm) {
            var value = this.cache.revalidate();
            if (_glimmerReference.isModified(value)) {
                var bounds = this.bounds;
                var upsert = this.upsert;
                var dom = vm.dom;

                if (!this.upsert.update(dom, value)) {
                    var cursor = new _glimmerRuntimeLibBounds.Cursor(bounds.parentElement(), _glimmerRuntimeLibBounds.clear(bounds));
                    upsert = this.upsert = this.insert(vm.env.getAppendOperations(), cursor, value);
                }
                bounds.update(upsert.bounds);
            }
        };

        UpdateOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var cache = this.cache;

            return {
                guid: guid,
                type: type,
                details: { lastValue: JSON.stringify(cache.peek()) }
            };
        };

        return UpdateOpcode;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    var GuardedUpdateOpcode = (function (_UpdateOpcode) {
        babelHelpers.inherits(GuardedUpdateOpcode, _UpdateOpcode);

        function GuardedUpdateOpcode(reference, cache, bounds, upsert, appendOpcode, state) {
            _UpdateOpcode.call(this, cache, bounds, upsert);
            this.reference = reference;
            this.appendOpcode = appendOpcode;
            this.state = state;
            this.deopted = null;
            this.tag = this._tag = new _glimmerReference.UpdatableTag(this.tag);
        }

        GuardedUpdateOpcode.prototype.evaluate = function evaluate(vm) {
            if (this.deopted) {
                vm.evaluateOpcode(this.deopted);
            } else {
                if (_glimmerRuntimeLibComponentInterfaces.isComponentDefinition(this.reference.value())) {
                    this.lazyDeopt(vm);
                } else {
                    _UpdateOpcode.prototype.evaluate.call(this, vm);
                }
            }
        };

        GuardedUpdateOpcode.prototype.lazyDeopt = function lazyDeopt(vm) {
            // Durign initial render, we know that the reference does not contain a
            // component definition, so we optimistically assumed that this append
            // is just a normal append. However, at update time, we discovered that
            // the reference has switched into containing a component definition, so
            // we need to do a "lazy deopt", simulating what would have happened if
            // we had decided to perform the deopt in the first place during initial
            // render.
            //
            // More concretely, we would have expanded the curly into a if/else, and
            // based on whether the value is a component definition or not, we would
            // have entered either the dynamic component branch or the simple value
            // branch.
            //
            // Since we rendered a simple value during initial render (and all the
            // updates up until this point), we need to pretend that the result is
            // produced by the "VALUE" branch of the deopted append opcode:
            //
            //   Try(BEGIN, END)
            //     Assert(IsComponentDefinition, expected=false)
            //     OptimizedUpdate
            //
            // In this case, because the reference has switched from being a simple
            // value into a component definition, what would have happened is that
            // the assert would throw, causing the Try opcode to teardown the bounds
            // and rerun the original append opcode.
            //
            // Since the Try opcode would have nuked the updating opcodes anyway, we
            // wouldn't have to worry about simulating those. All we have to do is to
            // execute the Try opcode and immediately throw.
            var bounds = this.bounds;
            var appendOpcode = this.appendOpcode;
            var state = this.state;

            var appendOps = appendOpcode.deopt(vm.env);
            var enter = appendOps.head().next.next;
            var ops = enter.slice;
            var tracker = new _glimmerRuntimeLibBuilder.UpdatableBlockTracker(bounds.parentElement());
            tracker.newBounds(this.bounds);
            var children = new _glimmerUtil.LinkedList();
            state.frame['condition'] = IsComponentDefinitionReference.create(state.frame['operand']);
            var deopted = this.deopted = new _glimmerRuntimeLibVmUpdate.TryOpcode(ops, state, tracker, children);
            this._tag.update(deopted.tag);
            vm.evaluateOpcode(deopted);
            vm.throw();
            // From this point on, we have essentially replaced ourselve with a new
            // opcode. Since we will always be executing the new/deopted code, it's a
            // good idea (as a pattern) to null out any unneeded fields here to avoid
            // holding on to unneeded/stale objects:
            this._tag = null;
            this.reference = null;
            this.cache = null;
            this.bounds = null;
            this.upsert = null;
            this.appendOpcode = null;
            this.state = null;
        };

        GuardedUpdateOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var deopted = this.deopted;

            if (deopted) {
                return {
                    guid: guid,
                    type: type,
                    deopted: true,
                    children: [deopted.toJSON()]
                };
            } else {
                return _UpdateOpcode.prototype.toJSON.call(this);
            }
        };

        return GuardedUpdateOpcode;
    })(UpdateOpcode);

    var OptimizedCautiousAppendOpcode = (function (_AppendOpcode2) {
        babelHelpers.inherits(OptimizedCautiousAppendOpcode, _AppendOpcode2);

        function OptimizedCautiousAppendOpcode() {
            _AppendOpcode2.apply(this, arguments);
            this.type = 'optimized-cautious-append';
        }

        OptimizedCautiousAppendOpcode.prototype.normalize = function normalize(reference) {
            return _glimmerReference.map(reference, normalizeValue);
        };

        OptimizedCautiousAppendOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.cautiousInsert(dom, cursor, value);
        };

        OptimizedCautiousAppendOpcode.prototype.updateWith = function updateWith(vm, reference, cache, bounds, upsert) {
            return new OptimizedCautiousUpdateOpcode(cache, bounds, upsert);
        };

        return OptimizedCautiousAppendOpcode;
    })(AppendOpcode);

    exports.OptimizedCautiousAppendOpcode = OptimizedCautiousAppendOpcode;

    var OptimizedCautiousUpdateOpcode = (function (_UpdateOpcode2) {
        babelHelpers.inherits(OptimizedCautiousUpdateOpcode, _UpdateOpcode2);

        function OptimizedCautiousUpdateOpcode() {
            _UpdateOpcode2.apply(this, arguments);
            this.type = 'optimized-cautious-update';
        }

        OptimizedCautiousUpdateOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.cautiousInsert(dom, cursor, value);
        };

        return OptimizedCautiousUpdateOpcode;
    })(UpdateOpcode);

    var GuardedCautiousAppendOpcode = (function (_GuardedAppendOpcode) {
        babelHelpers.inherits(GuardedCautiousAppendOpcode, _GuardedAppendOpcode);

        function GuardedCautiousAppendOpcode() {
            _GuardedAppendOpcode.apply(this, arguments);
            this.type = 'guarded-cautious-append';
            this.AppendOpcode = OptimizedCautiousAppendOpcode;
        }

        GuardedCautiousAppendOpcode.prototype.normalize = function normalize(reference) {
            return _glimmerReference.map(reference, normalizeValue);
        };

        GuardedCautiousAppendOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.cautiousInsert(dom, cursor, value);
        };

        GuardedCautiousAppendOpcode.prototype.updateWith = function updateWith(vm, reference, cache, bounds, upsert) {
            return new GuardedCautiousUpdateOpcode(reference, cache, bounds, upsert, this, vm.capture());
        };

        return GuardedCautiousAppendOpcode;
    })(GuardedAppendOpcode);

    exports.GuardedCautiousAppendOpcode = GuardedCautiousAppendOpcode;

    var GuardedCautiousUpdateOpcode = (function (_GuardedUpdateOpcode) {
        babelHelpers.inherits(GuardedCautiousUpdateOpcode, _GuardedUpdateOpcode);

        function GuardedCautiousUpdateOpcode() {
            _GuardedUpdateOpcode.apply(this, arguments);
            this.type = 'guarded-cautious-update';
        }

        GuardedCautiousUpdateOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.cautiousInsert(dom, cursor, value);
        };

        return GuardedCautiousUpdateOpcode;
    })(GuardedUpdateOpcode);

    var OptimizedTrustingAppendOpcode = (function (_AppendOpcode3) {
        babelHelpers.inherits(OptimizedTrustingAppendOpcode, _AppendOpcode3);

        function OptimizedTrustingAppendOpcode() {
            _AppendOpcode3.apply(this, arguments);
            this.type = 'optimized-trusting-append';
        }

        OptimizedTrustingAppendOpcode.prototype.normalize = function normalize(reference) {
            return _glimmerReference.map(reference, normalizeTrustedValue);
        };

        OptimizedTrustingAppendOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.trustingInsert(dom, cursor, value);
        };

        OptimizedTrustingAppendOpcode.prototype.updateWith = function updateWith(vm, reference, cache, bounds, upsert) {
            return new OptimizedTrustingUpdateOpcode(cache, bounds, upsert);
        };

        return OptimizedTrustingAppendOpcode;
    })(AppendOpcode);

    exports.OptimizedTrustingAppendOpcode = OptimizedTrustingAppendOpcode;

    var OptimizedTrustingUpdateOpcode = (function (_UpdateOpcode3) {
        babelHelpers.inherits(OptimizedTrustingUpdateOpcode, _UpdateOpcode3);

        function OptimizedTrustingUpdateOpcode() {
            _UpdateOpcode3.apply(this, arguments);
            this.type = 'optimized-trusting-update';
        }

        OptimizedTrustingUpdateOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.trustingInsert(dom, cursor, value);
        };

        return OptimizedTrustingUpdateOpcode;
    })(UpdateOpcode);

    var GuardedTrustingAppendOpcode = (function (_GuardedAppendOpcode2) {
        babelHelpers.inherits(GuardedTrustingAppendOpcode, _GuardedAppendOpcode2);

        function GuardedTrustingAppendOpcode() {
            _GuardedAppendOpcode2.apply(this, arguments);
            this.type = 'guarded-trusting-append';
            this.AppendOpcode = OptimizedTrustingAppendOpcode;
        }

        GuardedTrustingAppendOpcode.prototype.normalize = function normalize(reference) {
            return _glimmerReference.map(reference, normalizeTrustedValue);
        };

        GuardedTrustingAppendOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.trustingInsert(dom, cursor, value);
        };

        GuardedTrustingAppendOpcode.prototype.updateWith = function updateWith(vm, reference, cache, bounds, upsert) {
            return new GuardedTrustingUpdateOpcode(reference, cache, bounds, upsert, this, vm.capture());
        };

        return GuardedTrustingAppendOpcode;
    })(GuardedAppendOpcode);

    exports.GuardedTrustingAppendOpcode = GuardedTrustingAppendOpcode;

    var GuardedTrustingUpdateOpcode = (function (_GuardedUpdateOpcode2) {
        babelHelpers.inherits(GuardedTrustingUpdateOpcode, _GuardedUpdateOpcode2);

        function GuardedTrustingUpdateOpcode() {
            _GuardedUpdateOpcode2.apply(this, arguments);
            this.type = 'trusting-update';
        }

        GuardedTrustingUpdateOpcode.prototype.insert = function insert(dom, cursor, value) {
            return _glimmerRuntimeLibUpsert.trustingInsert(dom, cursor, value);
        };

        return GuardedTrustingUpdateOpcode;
    })(GuardedUpdateOpcode);
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/opcodes/dom', ['exports', 'glimmer-runtime/lib/opcodes', 'glimmer-util', 'glimmer-reference', 'glimmer-runtime/lib/references', 'glimmer-runtime/lib/compiled/expressions/value', 'glimmer-runtime/lib/compiled/opcodes/vm'], function (exports, _glimmerRuntimeLibOpcodes, _glimmerUtil, _glimmerReference, _glimmerRuntimeLibReferences, _glimmerRuntimeLibCompiledExpressionsValue, _glimmerRuntimeLibCompiledOpcodesVm) {
    'use strict';

    var TextOpcode = (function (_Opcode) {
        babelHelpers.inherits(TextOpcode, _Opcode);

        function TextOpcode(text) {
            _Opcode.call(this);
            this.text = text;
            this.type = "text";
        }

        TextOpcode.prototype.evaluate = function evaluate(vm) {
            vm.stack().appendText(this.text);
        };

        TextOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.text)]
            };
        };

        return TextOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.TextOpcode = TextOpcode;

    var OpenPrimitiveElementOpcode = (function (_Opcode2) {
        babelHelpers.inherits(OpenPrimitiveElementOpcode, _Opcode2);

        function OpenPrimitiveElementOpcode(tag) {
            _Opcode2.call(this);
            this.tag = tag;
            this.type = "open-primitive-element";
        }

        OpenPrimitiveElementOpcode.prototype.evaluate = function evaluate(vm) {
            vm.stack().openElement(this.tag);
        };

        OpenPrimitiveElementOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.tag)]
            };
        };

        return OpenPrimitiveElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.OpenPrimitiveElementOpcode = OpenPrimitiveElementOpcode;

    var PushRemoteElementOpcode = (function (_Opcode3) {
        babelHelpers.inherits(PushRemoteElementOpcode, _Opcode3);

        function PushRemoteElementOpcode() {
            _Opcode3.apply(this, arguments);
            this.type = "push-remote-element";
        }

        PushRemoteElementOpcode.prototype.evaluate = function evaluate(vm) {
            var reference = vm.frame.getOperand();
            var cache = _glimmerReference.isConst(reference) ? undefined : new _glimmerReference.ReferenceCache(reference);
            var element = cache ? cache.peek() : reference.value();
            vm.stack().pushRemoteElement(element);
            if (cache) {
                vm.updateWith(new _glimmerRuntimeLibCompiledOpcodesVm.Assert(cache));
            }
        };

        PushRemoteElementOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ['$OPERAND']
            };
        };

        return PushRemoteElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PushRemoteElementOpcode = PushRemoteElementOpcode;

    var PopRemoteElementOpcode = (function (_Opcode4) {
        babelHelpers.inherits(PopRemoteElementOpcode, _Opcode4);

        function PopRemoteElementOpcode() {
            _Opcode4.apply(this, arguments);
            this.type = "pop-remote-element";
        }

        PopRemoteElementOpcode.prototype.evaluate = function evaluate(vm) {
            vm.stack().popRemoteElement();
        };

        return PopRemoteElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PopRemoteElementOpcode = PopRemoteElementOpcode;

    var OpenComponentElementOpcode = (function (_Opcode5) {
        babelHelpers.inherits(OpenComponentElementOpcode, _Opcode5);

        function OpenComponentElementOpcode(tag) {
            _Opcode5.call(this);
            this.tag = tag;
            this.type = "open-component-element";
        }

        OpenComponentElementOpcode.prototype.evaluate = function evaluate(vm) {
            vm.stack().openElement(this.tag, new ComponentElementOperations(vm.env));
        };

        OpenComponentElementOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.tag)]
            };
        };

        return OpenComponentElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.OpenComponentElementOpcode = OpenComponentElementOpcode;

    var OpenDynamicPrimitiveElementOpcode = (function (_Opcode6) {
        babelHelpers.inherits(OpenDynamicPrimitiveElementOpcode, _Opcode6);

        function OpenDynamicPrimitiveElementOpcode() {
            _Opcode6.apply(this, arguments);
            this.type = "open-dynamic-primitive-element";
        }

        OpenDynamicPrimitiveElementOpcode.prototype.evaluate = function evaluate(vm) {
            var tagName = vm.frame.getOperand().value();
            vm.stack().openElement(tagName);
        };

        OpenDynamicPrimitiveElementOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$OPERAND"]
            };
        };

        return OpenDynamicPrimitiveElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.OpenDynamicPrimitiveElementOpcode = OpenDynamicPrimitiveElementOpcode;

    var ClassList = (function () {
        function ClassList() {
            this.list = null;
            this.isConst = true;
        }

        ClassList.prototype.append = function append(reference) {
            var list = this.list;
            var isConst = this.isConst;

            if (list === null) list = this.list = [];
            list.push(reference);
            this.isConst = isConst && _glimmerReference.isConst(reference);
        };

        ClassList.prototype.toReference = function toReference() {
            var list = this.list;
            var isConst = this.isConst;

            if (!list) return _glimmerRuntimeLibReferences.NULL_REFERENCE;
            if (isConst) return new _glimmerRuntimeLibCompiledExpressionsValue.ValueReference(toClassName(list));
            return new ClassListReference(list);
        };

        return ClassList;
    })();

    var ClassListReference = (function (_CachedReference) {
        babelHelpers.inherits(ClassListReference, _CachedReference);

        function ClassListReference(list) {
            _CachedReference.call(this);
            this.list = [];
            this.tag = _glimmerReference.combineTagged(list);
            this.list = list;
        }

        ClassListReference.prototype.compute = function compute() {
            return toClassName(this.list);
        };

        return ClassListReference;
    })(_glimmerReference.CachedReference);

    function toClassName(list) {
        var ret = [];
        for (var i = 0; i < list.length; i++) {
            var value = list[i].value();
            if (value !== false && value !== null && value !== undefined) ret.push(value);
        }
        return ret.length === 0 ? null : ret.join(' ');
    }

    var SimpleElementOperations = (function () {
        function SimpleElementOperations(env) {
            this.env = env;
            this.opcodes = null;
            this.classList = null;
        }

        SimpleElementOperations.prototype.addStaticAttribute = function addStaticAttribute(element, name, value) {
            if (name === 'class') {
                this.addClass(new _glimmerRuntimeLibCompiledExpressionsValue.ValueReference(value));
            } else {
                this.env.getAppendOperations().setAttribute(element, name, value);
            }
        };

        SimpleElementOperations.prototype.addStaticAttributeNS = function addStaticAttributeNS(element, namespace, name, value) {
            this.env.getAppendOperations().setAttribute(element, name, value, namespace);
        };

        SimpleElementOperations.prototype.addDynamicAttribute = function addDynamicAttribute(element, name, reference, isTrusting) {
            if (name === 'class') {
                this.addClass(reference);
            } else {
                var attributeManager = this.env.attributeFor(element, name, isTrusting);
                var attribute = new DynamicAttribute(element, attributeManager, name, reference);
                this.addAttribute(attribute);
            }
        };

        SimpleElementOperations.prototype.addDynamicAttributeNS = function addDynamicAttributeNS(element, namespace, name, reference, isTrusting) {
            var attributeManager = this.env.attributeFor(element, name, isTrusting, namespace);
            var nsAttribute = new DynamicAttribute(element, attributeManager, name, reference, namespace);
            this.addAttribute(nsAttribute);
        };

        SimpleElementOperations.prototype.flush = function flush(element, vm) {
            var env = vm.env;
            var opcodes = this.opcodes;
            var classList = this.classList;

            for (var i = 0; opcodes && i < opcodes.length; i++) {
                vm.updateWith(opcodes[i]);
            }
            if (classList) {
                var attributeManager = env.attributeFor(element, 'class', false);
                var attribute = new DynamicAttribute(element, attributeManager, 'class', classList.toReference());
                var opcode = attribute.flush(env);
                if (opcode) {
                    vm.updateWith(opcode);
                }
            }
            this.opcodes = null;
            this.classList = null;
        };

        SimpleElementOperations.prototype.addClass = function addClass(reference) {
            var classList = this.classList;

            if (!classList) {
                classList = this.classList = new ClassList();
            }
            classList.append(reference);
        };

        SimpleElementOperations.prototype.addAttribute = function addAttribute(attribute) {
            var opcode = attribute.flush(this.env);
            if (opcode) {
                var opcodes = this.opcodes;

                if (!opcodes) {
                    opcodes = this.opcodes = [];
                }
                opcodes.push(opcode);
            }
        };

        return SimpleElementOperations;
    })();

    exports.SimpleElementOperations = SimpleElementOperations;

    var ComponentElementOperations = (function () {
        function ComponentElementOperations(env) {
            this.env = env;
            this.attributeNames = null;
            this.attributes = null;
            this.classList = null;
        }

        ComponentElementOperations.prototype.addStaticAttribute = function addStaticAttribute(element, name, value) {
            if (name === 'class') {
                this.addClass(new _glimmerRuntimeLibCompiledExpressionsValue.ValueReference(value));
            } else if (this.shouldAddAttribute(name)) {
                this.addAttribute(name, new StaticAttribute(element, name, value));
            }
        };

        ComponentElementOperations.prototype.addStaticAttributeNS = function addStaticAttributeNS(element, namespace, name, value) {
            if (this.shouldAddAttribute(name)) {
                this.addAttribute(name, new StaticAttribute(element, name, value, namespace));
            }
        };

        ComponentElementOperations.prototype.addDynamicAttribute = function addDynamicAttribute(element, name, reference, isTrusting) {
            if (name === 'class') {
                this.addClass(reference);
            } else if (this.shouldAddAttribute(name)) {
                var attributeManager = this.env.attributeFor(element, name, isTrusting);
                var attribute = new DynamicAttribute(element, attributeManager, name, reference);
                this.addAttribute(name, attribute);
            }
        };

        ComponentElementOperations.prototype.addDynamicAttributeNS = function addDynamicAttributeNS(element, namespace, name, reference, isTrusting) {
            if (this.shouldAddAttribute(name)) {
                var attributeManager = this.env.attributeFor(element, name, isTrusting, namespace);
                var nsAttribute = new DynamicAttribute(element, attributeManager, name, reference, namespace);
                this.addAttribute(name, nsAttribute);
            }
        };

        ComponentElementOperations.prototype.flush = function flush(element, vm) {
            var env = this.env;
            var attributes = this.attributes;
            var classList = this.classList;

            for (var i = 0; attributes && i < attributes.length; i++) {
                var opcode = attributes[i].flush(env);
                if (opcode) {
                    vm.updateWith(opcode);
                }
            }
            if (classList) {
                var attributeManager = env.attributeFor(element, 'class', false);
                var attribute = new DynamicAttribute(element, attributeManager, 'class', classList.toReference());
                var opcode = attribute.flush(env);
                if (opcode) {
                    vm.updateWith(opcode);
                }
            }
        };

        ComponentElementOperations.prototype.shouldAddAttribute = function shouldAddAttribute(name) {
            return !this.attributeNames || this.attributeNames.indexOf(name) === -1;
        };

        ComponentElementOperations.prototype.addClass = function addClass(reference) {
            var classList = this.classList;

            if (!classList) {
                classList = this.classList = new ClassList();
            }
            classList.append(reference);
        };

        ComponentElementOperations.prototype.addAttribute = function addAttribute(name, attribute) {
            var attributeNames = this.attributeNames;
            var attributes = this.attributes;

            if (!attributeNames) {
                attributeNames = this.attributeNames = [];
                attributes = this.attributes = [];
            }
            attributeNames.push(name);
            attributes.push(attribute);
        };

        return ComponentElementOperations;
    })();

    exports.ComponentElementOperations = ComponentElementOperations;

    var FlushElementOpcode = (function (_Opcode7) {
        babelHelpers.inherits(FlushElementOpcode, _Opcode7);

        function FlushElementOpcode() {
            _Opcode7.apply(this, arguments);
            this.type = "flush-element";
        }

        FlushElementOpcode.prototype.evaluate = function evaluate(vm) {
            var stack = vm.stack();
            stack.operations.flush(stack.constructing, vm);
            stack.flushElement();
        };

        return FlushElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.FlushElementOpcode = FlushElementOpcode;

    var CloseElementOpcode = (function (_Opcode8) {
        babelHelpers.inherits(CloseElementOpcode, _Opcode8);

        function CloseElementOpcode() {
            _Opcode8.apply(this, arguments);
            this.type = "close-element";
        }

        CloseElementOpcode.prototype.evaluate = function evaluate(vm) {
            vm.stack().closeElement();
        };

        return CloseElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.CloseElementOpcode = CloseElementOpcode;

    var PopElementOpcode = (function (_Opcode9) {
        babelHelpers.inherits(PopElementOpcode, _Opcode9);

        function PopElementOpcode() {
            _Opcode9.apply(this, arguments);
            this.type = "pop-element";
        }

        PopElementOpcode.prototype.evaluate = function evaluate(vm) {
            vm.stack().popElement();
        };

        return PopElementOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PopElementOpcode = PopElementOpcode;

    var StaticAttrOpcode = (function (_Opcode10) {
        babelHelpers.inherits(StaticAttrOpcode, _Opcode10);

        function StaticAttrOpcode(namespace, name, value) {
            _Opcode10.call(this);
            this.namespace = namespace;
            this.name = name;
            this.value = value;
            this.type = "static-attr";
        }

        StaticAttrOpcode.prototype.evaluate = function evaluate(vm) {
            var name = this.name;
            var value = this.value;
            var namespace = this.namespace;

            if (namespace) {
                vm.stack().setStaticAttributeNS(namespace, name, value);
            } else {
                vm.stack().setStaticAttribute(name, value);
            }
        };

        StaticAttrOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var namespace = this.namespace;
            var name = this.name;
            var value = this.value;

            var details = _glimmerUtil.dict();
            if (namespace) {
                details["namespace"] = JSON.stringify(namespace);
            }
            details["name"] = JSON.stringify(name);
            details["value"] = JSON.stringify(value);
            return { guid: guid, type: type, details: details };
        };

        return StaticAttrOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.StaticAttrOpcode = StaticAttrOpcode;

    var ModifierOpcode = (function (_Opcode11) {
        babelHelpers.inherits(ModifierOpcode, _Opcode11);

        function ModifierOpcode(name, manager, args) {
            _Opcode11.call(this);
            this.name = name;
            this.manager = manager;
            this.args = args;
            this.type = "modifier";
        }

        ModifierOpcode.prototype.evaluate = function evaluate(vm) {
            var manager = this.manager;

            var stack = vm.stack();
            var element = stack.constructing;
            var updateOperations = stack.updateOperations;

            var args = this.args.evaluate(vm);
            var dynamicScope = vm.dynamicScope();
            var modifier = manager.create(element, args, dynamicScope, updateOperations);
            vm.env.scheduleInstallModifier(modifier, manager);
            var destructor = manager.getDestructor(modifier);
            if (destructor) {
                vm.newDestroyable(destructor);
            }
            vm.updateWith(new UpdateModifierOpcode(manager, modifier, args));
        };

        ModifierOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var name = this.name;
            var args = this.args;

            var details = _glimmerUtil.dict();
            details["type"] = JSON.stringify(type);
            details["name"] = JSON.stringify(name);
            details["args"] = JSON.stringify(args);
            return { guid: guid, type: type, details: details };
        };

        return ModifierOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.ModifierOpcode = ModifierOpcode;

    var UpdateModifierOpcode = (function (_UpdatingOpcode) {
        babelHelpers.inherits(UpdateModifierOpcode, _UpdatingOpcode);

        function UpdateModifierOpcode(manager, modifier, args) {
            _UpdatingOpcode.call(this);
            this.manager = manager;
            this.modifier = modifier;
            this.args = args;
            this.type = "update-modifier";
            this.tag = args.tag;
            this.lastUpdated = args.tag.value();
        }

        UpdateModifierOpcode.prototype.evaluate = function evaluate(vm) {
            var manager = this.manager;
            var modifier = this.modifier;
            var tag = this.tag;
            var lastUpdated = this.lastUpdated;

            if (!tag.validate(lastUpdated)) {
                vm.env.scheduleUpdateModifier(modifier, manager);
                this.lastUpdated = tag.value();
            }
        };

        UpdateModifierOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.args)]
            };
        };

        return UpdateModifierOpcode;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    exports.UpdateModifierOpcode = UpdateModifierOpcode;

    var StaticAttribute = (function () {
        function StaticAttribute(element, name, value, namespace) {
            this.element = element;
            this.name = name;
            this.value = value;
            this.namespace = namespace;
        }

        StaticAttribute.prototype.flush = function flush(env) {
            env.getAppendOperations().setAttribute(this.element, this.name, this.value, this.namespace);
            return null;
        };

        return StaticAttribute;
    })();

    exports.StaticAttribute = StaticAttribute;

    var DynamicAttribute = (function () {
        function DynamicAttribute(element, attributeManager, name, reference, namespace) {
            this.element = element;
            this.attributeManager = attributeManager;
            this.name = name;
            this.reference = reference;
            this.namespace = namespace;
            this.tag = reference.tag;
            this.cache = null;
        }

        DynamicAttribute.prototype.patch = function patch(env) {
            var element = this.element;
            var cache = this.cache;

            var value = cache.revalidate();
            if (_glimmerReference.isModified(value)) {
                this.attributeManager.updateAttribute(env, element, value, this.namespace);
            }
        };

        DynamicAttribute.prototype.flush = function flush(env) {
            var reference = this.reference;
            var element = this.element;

            if (_glimmerReference.isConst(reference)) {
                var value = reference.value();
                this.attributeManager.setAttribute(env, element, value, this.namespace);
                return null;
            } else {
                var cache = this.cache = new _glimmerReference.ReferenceCache(reference);
                var value = cache.peek();
                this.attributeManager.setAttribute(env, element, value, this.namespace);
                return new PatchElementOpcode(this);
            }
        };

        DynamicAttribute.prototype.toJSON = function toJSON() {
            var element = this.element;
            var namespace = this.namespace;
            var name = this.name;
            var cache = this.cache;

            var formattedElement = formatElement(element);
            var lastValue = cache.peek();
            if (namespace) {
                return {
                    element: formattedElement,
                    type: 'attribute',
                    namespace: namespace,
                    name: name,
                    lastValue: lastValue
                };
            }
            return {
                element: formattedElement,
                type: 'attribute',
                namespace: namespace,
                name: name,
                lastValue: lastValue
            };
        };

        return DynamicAttribute;
    })();

    exports.DynamicAttribute = DynamicAttribute;

    function formatElement(element) {
        return JSON.stringify('<' + element.tagName.toLowerCase() + ' />');
    }

    var DynamicAttrNSOpcode = (function (_Opcode12) {
        babelHelpers.inherits(DynamicAttrNSOpcode, _Opcode12);

        function DynamicAttrNSOpcode(name, namespace, isTrusting) {
            _Opcode12.call(this);
            this.name = name;
            this.namespace = namespace;
            this.isTrusting = isTrusting;
            this.type = "dynamic-attr";
        }

        DynamicAttrNSOpcode.prototype.evaluate = function evaluate(vm) {
            var name = this.name;
            var namespace = this.namespace;
            var isTrusting = this.isTrusting;

            var reference = vm.frame.getOperand();
            vm.stack().setDynamicAttributeNS(namespace, name, reference, isTrusting);
        };

        DynamicAttrNSOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var name = this.name;
            var namespace = this.namespace;

            var details = _glimmerUtil.dict();
            details["name"] = JSON.stringify(name);
            details["value"] = "$OPERAND";
            if (namespace) {
                details["namespace"] = JSON.stringify(namespace);
            }
            return { guid: guid, type: type, details: details };
        };

        return DynamicAttrNSOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.DynamicAttrNSOpcode = DynamicAttrNSOpcode;

    var DynamicAttrOpcode = (function (_Opcode13) {
        babelHelpers.inherits(DynamicAttrOpcode, _Opcode13);

        function DynamicAttrOpcode(name, isTrusting) {
            _Opcode13.call(this);
            this.name = name;
            this.isTrusting = isTrusting;
            this.type = "dynamic-attr";
        }

        DynamicAttrOpcode.prototype.evaluate = function evaluate(vm) {
            var name = this.name;
            var isTrusting = this.isTrusting;

            var reference = vm.frame.getOperand();
            vm.stack().setDynamicAttribute(name, reference, isTrusting);
        };

        DynamicAttrOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var name = this.name;

            var details = _glimmerUtil.dict();
            details["name"] = JSON.stringify(name);
            details["value"] = "$OPERAND";
            return { guid: guid, type: type, details: details };
        };

        return DynamicAttrOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.DynamicAttrOpcode = DynamicAttrOpcode;

    var PatchElementOpcode = (function (_UpdatingOpcode2) {
        babelHelpers.inherits(PatchElementOpcode, _UpdatingOpcode2);

        function PatchElementOpcode(operation) {
            _UpdatingOpcode2.call(this);
            this.type = "patch-element";
            this.tag = operation.tag;
            this.operation = operation;
        }

        PatchElementOpcode.prototype.evaluate = function evaluate(vm) {
            this.operation.patch(vm.env);
        };

        PatchElementOpcode.prototype.toJSON = function toJSON() {
            var _guid = this._guid;
            var type = this.type;
            var operation = this.operation;

            return {
                guid: _guid,
                type: type,
                details: operation.toJSON()
            };
        };

        return PatchElementOpcode;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    exports.PatchElementOpcode = PatchElementOpcode;

    var CommentOpcode = (function (_Opcode14) {
        babelHelpers.inherits(CommentOpcode, _Opcode14);

        function CommentOpcode(comment) {
            _Opcode14.call(this);
            this.comment = comment;
            this.type = "comment";
        }

        CommentOpcode.prototype.evaluate = function evaluate(vm) {
            vm.stack().appendComment(this.comment);
        };

        CommentOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.comment)]
            };
        };

        return CommentOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.CommentOpcode = CommentOpcode;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/opcodes/lists', ['exports', 'glimmer-runtime/lib/opcodes', 'glimmer-runtime/lib/compiled/expressions/args', 'glimmer-util', 'glimmer-reference'], function (exports, _glimmerRuntimeLibOpcodes, _glimmerRuntimeLibCompiledExpressionsArgs, _glimmerUtil, _glimmerReference) {
    'use strict';

    var IterablePresenceReference = (function () {
        function IterablePresenceReference(artifacts) {
            this.tag = artifacts.tag;
            this.artifacts = artifacts;
        }

        IterablePresenceReference.prototype.value = function value() {
            return !this.artifacts.isEmpty();
        };

        return IterablePresenceReference;
    })();

    var PutIteratorOpcode = (function (_Opcode) {
        babelHelpers.inherits(PutIteratorOpcode, _Opcode);

        function PutIteratorOpcode() {
            _Opcode.apply(this, arguments);
            this.type = "put-iterator";
        }

        PutIteratorOpcode.prototype.evaluate = function evaluate(vm) {
            var listRef = vm.frame.getOperand();
            var args = vm.frame.getArgs();
            var iterable = vm.env.iterableFor(listRef, args);
            var iterator = new _glimmerReference.ReferenceIterator(iterable);
            vm.frame.setIterator(iterator);
            vm.frame.setCondition(new IterablePresenceReference(iterator.artifacts));
        };

        return PutIteratorOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutIteratorOpcode = PutIteratorOpcode;

    var EnterListOpcode = (function (_Opcode2) {
        babelHelpers.inherits(EnterListOpcode, _Opcode2);

        function EnterListOpcode(start, end) {
            _Opcode2.call(this);
            this.type = "enter-list";
            this.slice = new _glimmerUtil.ListSlice(start, end);
        }

        EnterListOpcode.prototype.evaluate = function evaluate(vm) {
            vm.enterList(this.slice);
        };

        EnterListOpcode.prototype.toJSON = function toJSON() {
            var slice = this.slice;
            var type = this.type;
            var _guid = this._guid;

            var begin = slice.head();
            var end = slice.tail();
            return {
                guid: _guid,
                type: type,
                args: [JSON.stringify(begin.inspect()), JSON.stringify(end.inspect())]
            };
        };

        return EnterListOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.EnterListOpcode = EnterListOpcode;

    var ExitListOpcode = (function (_Opcode3) {
        babelHelpers.inherits(ExitListOpcode, _Opcode3);

        function ExitListOpcode() {
            _Opcode3.apply(this, arguments);
            this.type = "exit-list";
        }

        ExitListOpcode.prototype.evaluate = function evaluate(vm) {
            vm.exitList();
        };

        return ExitListOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.ExitListOpcode = ExitListOpcode;

    var EnterWithKeyOpcode = (function (_Opcode4) {
        babelHelpers.inherits(EnterWithKeyOpcode, _Opcode4);

        function EnterWithKeyOpcode(start, end) {
            _Opcode4.call(this);
            this.type = "enter-with-key";
            this.slice = new _glimmerUtil.ListSlice(start, end);
        }

        EnterWithKeyOpcode.prototype.evaluate = function evaluate(vm) {
            vm.enterWithKey(vm.frame.getKey(), this.slice);
        };

        EnterWithKeyOpcode.prototype.toJSON = function toJSON() {
            var slice = this.slice;
            var _guid = this._guid;
            var type = this.type;

            var begin = slice.head();
            var end = slice.tail();
            return {
                guid: _guid,
                type: type,
                args: [JSON.stringify(begin.inspect()), JSON.stringify(end.inspect())]
            };
        };

        return EnterWithKeyOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.EnterWithKeyOpcode = EnterWithKeyOpcode;

    var TRUE_REF = new _glimmerReference.ConstReference(true);
    var FALSE_REF = new _glimmerReference.ConstReference(false);

    var NextIterOpcode = (function (_Opcode5) {
        babelHelpers.inherits(NextIterOpcode, _Opcode5);

        function NextIterOpcode(end) {
            _Opcode5.call(this);
            this.type = "next-iter";
            this.end = end;
        }

        NextIterOpcode.prototype.evaluate = function evaluate(vm) {
            var item = vm.frame.getIterator().next();
            if (item) {
                vm.frame.setCondition(TRUE_REF);
                vm.frame.setKey(item.key);
                vm.frame.setOperand(item.value);
                vm.frame.setArgs(_glimmerRuntimeLibCompiledExpressionsArgs.EvaluatedArgs.positional([item.value, item.memo]));
            } else {
                vm.frame.setCondition(FALSE_REF);
                vm.goto(this.end);
            }
        };

        return NextIterOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.NextIterOpcode = NextIterOpcode;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/opcodes/partial', ['exports', 'glimmer-util', 'glimmer-reference', 'glimmer-runtime/lib/opcodes', 'glimmer-runtime/lib/compiled/opcodes/vm'], function (exports, _glimmerUtil, _glimmerReference, _glimmerRuntimeLibOpcodes, _glimmerRuntimeLibCompiledOpcodesVm) {
    'use strict';

    var PutDynamicPartialDefinitionOpcode = (function (_Opcode) {
        babelHelpers.inherits(PutDynamicPartialDefinitionOpcode, _Opcode);

        function PutDynamicPartialDefinitionOpcode(symbolTable) {
            _Opcode.call(this);
            this.symbolTable = symbolTable;
            this.type = "put-dynamic-partial-definition";
        }

        PutDynamicPartialDefinitionOpcode.prototype.evaluate = function evaluate(vm) {
            var env = vm.env;
            var symbolTable = this.symbolTable;

            function lookupPartial(name) {
                var normalized = String(name);
                if (!env.hasPartial(normalized, symbolTable)) {
                    throw new Error('Could not find a partial named "' + normalized + '"');
                }
                return env.lookupPartial(normalized, symbolTable);
            }
            var reference = _glimmerReference.map(vm.frame.getOperand(), lookupPartial);
            var cache = _glimmerReference.isConst(reference) ? undefined : new _glimmerReference.ReferenceCache(reference);
            var definition = cache ? cache.peek() : reference.value();
            vm.frame.setImmediate(definition);
            if (cache) {
                vm.updateWith(new _glimmerRuntimeLibCompiledOpcodesVm.Assert(cache));
            }
        };

        PutDynamicPartialDefinitionOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$OPERAND"]
            };
        };

        return PutDynamicPartialDefinitionOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutDynamicPartialDefinitionOpcode = PutDynamicPartialDefinitionOpcode;

    var PutPartialDefinitionOpcode = (function (_Opcode2) {
        babelHelpers.inherits(PutPartialDefinitionOpcode, _Opcode2);

        function PutPartialDefinitionOpcode(definition) {
            _Opcode2.call(this);
            this.definition = definition;
            this.type = "put-partial-definition";
        }

        PutPartialDefinitionOpcode.prototype.evaluate = function evaluate(vm) {
            vm.frame.setImmediate(this.definition);
        };

        PutPartialDefinitionOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.definition.name)]
            };
        };

        return PutPartialDefinitionOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutPartialDefinitionOpcode = PutPartialDefinitionOpcode;

    var EvaluatePartialOpcode = (function (_Opcode3) {
        babelHelpers.inherits(EvaluatePartialOpcode, _Opcode3);

        function EvaluatePartialOpcode(symbolTable) {
            _Opcode3.call(this);
            this.symbolTable = symbolTable;
            this.type = "evaluate-partial";
            this.cache = _glimmerUtil.dict();
        }

        EvaluatePartialOpcode.prototype.evaluate = function evaluate(vm) {
            var _vm$frame$getImmediate = vm.frame.getImmediate();

            var template = _vm$frame$getImmediate.template;

            var block = this.cache[template.id];
            if (!block) {
                block = template.asPartial(this.symbolTable);
            }
            vm.invokePartial(block);
        };

        EvaluatePartialOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$OPERAND"]
            };
        };

        return EvaluatePartialOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.EvaluatePartialOpcode = EvaluatePartialOpcode;
});
//# sourceMappingURL=data:application/json;base64,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
enifed('glimmer-runtime/lib/compiled/opcodes/vm', ['exports', 'glimmer-runtime/lib/opcodes', 'glimmer-runtime/lib/references', 'glimmer-reference', 'glimmer-util'], function (exports, _glimmerRuntimeLibOpcodes, _glimmerRuntimeLibReferences, _glimmerReference, _glimmerUtil) {
    'use strict';

    var PushChildScopeOpcode = (function (_Opcode) {
        babelHelpers.inherits(PushChildScopeOpcode, _Opcode);

        function PushChildScopeOpcode() {
            _Opcode.apply(this, arguments);
            this.type = "push-child-scope";
        }

        PushChildScopeOpcode.prototype.evaluate = function evaluate(vm) {
            vm.pushChildScope();
        };

        return PushChildScopeOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PushChildScopeOpcode = PushChildScopeOpcode;

    var PopScopeOpcode = (function (_Opcode2) {
        babelHelpers.inherits(PopScopeOpcode, _Opcode2);

        function PopScopeOpcode() {
            _Opcode2.apply(this, arguments);
            this.type = "pop-scope";
        }

        PopScopeOpcode.prototype.evaluate = function evaluate(vm) {
            vm.popScope();
        };

        return PopScopeOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PopScopeOpcode = PopScopeOpcode;

    var PushDynamicScopeOpcode = (function (_Opcode3) {
        babelHelpers.inherits(PushDynamicScopeOpcode, _Opcode3);

        function PushDynamicScopeOpcode() {
            _Opcode3.apply(this, arguments);
            this.type = "push-dynamic-scope";
        }

        PushDynamicScopeOpcode.prototype.evaluate = function evaluate(vm) {
            vm.pushDynamicScope();
        };

        return PushDynamicScopeOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PushDynamicScopeOpcode = PushDynamicScopeOpcode;

    var PopDynamicScopeOpcode = (function (_Opcode4) {
        babelHelpers.inherits(PopDynamicScopeOpcode, _Opcode4);

        function PopDynamicScopeOpcode() {
            _Opcode4.apply(this, arguments);
            this.type = "pop-dynamic-scope";
        }

        PopDynamicScopeOpcode.prototype.evaluate = function evaluate(vm) {
            vm.popDynamicScope();
        };

        return PopDynamicScopeOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PopDynamicScopeOpcode = PopDynamicScopeOpcode;

    var PutNullOpcode = (function (_Opcode5) {
        babelHelpers.inherits(PutNullOpcode, _Opcode5);

        function PutNullOpcode() {
            _Opcode5.apply(this, arguments);
            this.type = "put-null";
        }

        PutNullOpcode.prototype.evaluate = function evaluate(vm) {
            vm.frame.setOperand(_glimmerRuntimeLibReferences.NULL_REFERENCE);
        };

        return PutNullOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutNullOpcode = PutNullOpcode;

    var PutValueOpcode = (function (_Opcode6) {
        babelHelpers.inherits(PutValueOpcode, _Opcode6);

        function PutValueOpcode(expression) {
            _Opcode6.call(this);
            this.expression = expression;
            this.type = "put-value";
        }

        PutValueOpcode.prototype.evaluate = function evaluate(vm) {
            vm.evaluateOperand(this.expression);
        };

        PutValueOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [this.expression.toJSON()]
            };
        };

        return PutValueOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutValueOpcode = PutValueOpcode;

    var PutArgsOpcode = (function (_Opcode7) {
        babelHelpers.inherits(PutArgsOpcode, _Opcode7);

        function PutArgsOpcode(args) {
            _Opcode7.call(this);
            this.args = args;
            this.type = "put-args";
        }

        PutArgsOpcode.prototype.evaluate = function evaluate(vm) {
            vm.evaluateArgs(this.args);
        };

        PutArgsOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                details: {
                    "positional": this.args.positional.toJSON(),
                    "named": this.args.named.toJSON()
                }
            };
        };

        return PutArgsOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.PutArgsOpcode = PutArgsOpcode;

    var BindPositionalArgsOpcode = (function (_Opcode8) {
        babelHelpers.inherits(BindPositionalArgsOpcode, _Opcode8);

        function BindPositionalArgsOpcode(names, symbols) {
            _Opcode8.call(this);
            this.names = names;
            this.symbols = symbols;
            this.type = "bind-positional-args";
        }

        BindPositionalArgsOpcode.create = function create(block) {
            var names = block.locals;
            var symbols = names.map(function (name) {
                return block.symbolTable.getLocal(name);
            });
            return new this(names, symbols);
        };

        BindPositionalArgsOpcode.prototype.evaluate = function evaluate(vm) {
            vm.bindPositionalArgs(this.symbols);
        };

        BindPositionalArgsOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ['[' + this.names.map(function (name) {
                    return JSON.stringify(name);
                }).join(", ") + ']']
            };
        };

        return BindPositionalArgsOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.BindPositionalArgsOpcode = BindPositionalArgsOpcode;

    var BindNamedArgsOpcode = (function (_Opcode9) {
        babelHelpers.inherits(BindNamedArgsOpcode, _Opcode9);

        function BindNamedArgsOpcode(names, symbols) {
            _Opcode9.call(this);
            this.names = names;
            this.symbols = symbols;
            this.type = "bind-named-args";
        }

        BindNamedArgsOpcode.create = function create(layout) {
            var names = layout.named;
            var symbols = names.map(function (name) {
                return layout.symbolTable.getNamed(name);
            });
            return new this(names, symbols);
        };

        BindNamedArgsOpcode.prototype.evaluate = function evaluate(vm) {
            vm.bindNamedArgs(this.names, this.symbols);
        };

        BindNamedArgsOpcode.prototype.toJSON = function toJSON() {
            var names = this.names;
            var symbols = this.symbols;

            var args = names.map(function (name, i) {
                return '$' + symbols[i] + ': $ARGS[' + name + ']';
            });
            return {
                guid: this._guid,
                type: this.type,
                args: args
            };
        };

        return BindNamedArgsOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.BindNamedArgsOpcode = BindNamedArgsOpcode;

    var BindBlocksOpcode = (function (_Opcode10) {
        babelHelpers.inherits(BindBlocksOpcode, _Opcode10);

        function BindBlocksOpcode(names, symbols) {
            _Opcode10.call(this);
            this.names = names;
            this.symbols = symbols;
            this.type = "bind-blocks";
        }

        BindBlocksOpcode.create = function create(layout) {
            var names = layout.yields;
            var symbols = names.map(function (name) {
                return layout.symbolTable.getYield(name);
            });
            return new this(names, symbols);
        };

        BindBlocksOpcode.prototype.evaluate = function evaluate(vm) {
            vm.bindBlocks(this.names, this.symbols);
        };

        BindBlocksOpcode.prototype.toJSON = function toJSON() {
            var names = this.names;
            var symbols = this.symbols;

            var args = names.map(function (name, i) {
                return '$' + symbols[i] + ': $BLOCKS[' + name + ']';
            });
            return {
                guid: this._guid,
                type: this.type,
                args: args
            };
        };

        return BindBlocksOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.BindBlocksOpcode = BindBlocksOpcode;

    var BindPartialArgsOpcode = (function (_Opcode11) {
        babelHelpers.inherits(BindPartialArgsOpcode, _Opcode11);

        function BindPartialArgsOpcode(symbol) {
            _Opcode11.call(this);
            this.symbol = symbol;
            this.type = "bind-partial-args";
        }

        BindPartialArgsOpcode.create = function create(layout) {
            return new this(layout.symbolTable.getPartialArgs());
        };

        BindPartialArgsOpcode.prototype.evaluate = function evaluate(vm) {
            vm.bindPartialArgs(this.symbol);
        };

        return BindPartialArgsOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.BindPartialArgsOpcode = BindPartialArgsOpcode;

    var BindDynamicScopeOpcode = (function (_Opcode12) {
        babelHelpers.inherits(BindDynamicScopeOpcode, _Opcode12);

        function BindDynamicScopeOpcode(names) {
            _Opcode12.call(this);
            this.names = names;
            this.type = "bind-dynamic-scope";
        }

        BindDynamicScopeOpcode.prototype.evaluate = function evaluate(vm) {
            vm.bindDynamicScope(this.names);
        };

        return BindDynamicScopeOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.BindDynamicScopeOpcode = BindDynamicScopeOpcode;

    var EnterOpcode = (function (_Opcode13) {
        babelHelpers.inherits(EnterOpcode, _Opcode13);

        function EnterOpcode(begin, end) {
            _Opcode13.call(this);
            this.type = "enter";
            this.slice = new _glimmerUtil.ListSlice(begin, end);
        }

        EnterOpcode.prototype.evaluate = function evaluate(vm) {
            vm.enter(this.slice);
        };

        EnterOpcode.prototype.toJSON = function toJSON() {
            var slice = this.slice;
            var type = this.type;
            var _guid = this._guid;

            var begin = slice.head();
            var end = slice.tail();
            return {
                guid: _guid,
                type: type,
                args: [JSON.stringify(begin.inspect()), JSON.stringify(end.inspect())]
            };
        };

        return EnterOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.EnterOpcode = EnterOpcode;

    var ExitOpcode = (function (_Opcode14) {
        babelHelpers.inherits(ExitOpcode, _Opcode14);

        function ExitOpcode() {
            _Opcode14.apply(this, arguments);
            this.type = "exit";
        }

        ExitOpcode.prototype.evaluate = function evaluate(vm) {
            vm.exit();
        };

        return ExitOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.ExitOpcode = ExitOpcode;

    var LabelOpcode = (function (_Opcode15) {
        babelHelpers.inherits(LabelOpcode, _Opcode15);

        function LabelOpcode(label) {
            _Opcode15.call(this);
            this.tag = _glimmerReference.CONSTANT_TAG;
            this.type = "label";
            this.label = null;
            this.prev = null;
            this.next = null;
            if (label) this.label = label;
        }

        LabelOpcode.prototype.evaluate = function evaluate() {};

        LabelOpcode.prototype.inspect = function inspect() {
            return this.label + ' [' + this._guid + ']';
        };

        LabelOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.inspect())]
            };
        };

        return LabelOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.LabelOpcode = LabelOpcode;

    var EvaluateOpcode = (function (_Opcode16) {
        babelHelpers.inherits(EvaluateOpcode, _Opcode16);

        function EvaluateOpcode(debug, block) {
            _Opcode16.call(this);
            this.debug = debug;
            this.block = block;
            this.type = "evaluate";
        }

        EvaluateOpcode.prototype.evaluate = function evaluate(vm) {
            vm.invokeBlock(this.block, vm.frame.getArgs());
        };

        EvaluateOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid;
            var type = this.type;
            var debug = this.debug;
            var block = this.block;

            var compiled = block['compiled'];
            var children = undefined;
            if (compiled) {
                children = compiled.ops.toArray().map(function (op) {
                    return op.toJSON();
                });
            } else {
                children = [{ guid: null, type: '[ UNCOMPILED BLOCK ]' }];
            }
            return {
                guid: guid,
                type: type,
                args: [debug],
                children: children
            };
        };

        return EvaluateOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.EvaluateOpcode = EvaluateOpcode;
    var ConstTest = function (ref, env) {
        return new _glimmerReference.ConstReference(!!ref.value());
    };
    exports.ConstTest = ConstTest;
    var SimpleTest = function (ref, env) {
        return ref;
    };
    exports.SimpleTest = SimpleTest;
    var EnvironmentTest = function (ref, env) {
        return env.toConditionalReference(ref);
    };
    exports.EnvironmentTest = EnvironmentTest;

    var TestOpcode = (function (_Opcode17) {
        babelHelpers.inherits(TestOpcode, _Opcode17);

        function TestOpcode(testFunc) {
            _Opcode17.call(this);
            this.testFunc = testFunc;
            this.type = "test";
        }

        TestOpcode.prototype.evaluate = function evaluate(vm) {
            vm.frame.setCondition(this.testFunc(vm.frame.getOperand(), vm.env));
        };

        TestOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: ["$OPERAND", this.testFunc.name]
            };
        };

        return TestOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.TestOpcode = TestOpcode;

    var JumpOpcode = (function (_Opcode18) {
        babelHelpers.inherits(JumpOpcode, _Opcode18);

        function JumpOpcode(target) {
            _Opcode18.call(this);
            this.target = target;
            this.type = "jump";
        }

        JumpOpcode.prototype.evaluate = function evaluate(vm) {
            vm.goto(this.target);
        };

        JumpOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.target.inspect())]
            };
        };

        return JumpOpcode;
    })(_glimmerRuntimeLibOpcodes.Opcode);

    exports.JumpOpcode = JumpOpcode;

    var JumpIfOpcode = (function (_JumpOpcode) {
        babelHelpers.inherits(JumpIfOpcode, _JumpOpcode);

        function JumpIfOpcode() {
            _JumpOpcode.apply(this, arguments);
            this.type = "jump-if";
        }

        JumpIfOpcode.prototype.evaluate = function evaluate(vm) {
            var reference = vm.frame.getCondition();
            if (_glimmerReference.isConst(reference)) {
                if (reference.value()) {
                    _JumpOpcode.prototype.evaluate.call(this, vm);
                }
            } else {
                var cache = new _glimmerReference.ReferenceCache(reference);
                if (cache.peek()) {
                    _JumpOpcode.prototype.evaluate.call(this, vm);
                }
                vm.updateWith(new Assert(cache));
            }
        };

        return JumpIfOpcode;
    })(JumpOpcode);

    exports.JumpIfOpcode = JumpIfOpcode;

    var JumpUnlessOpcode = (function (_JumpOpcode2) {
        babelHelpers.inherits(JumpUnlessOpcode, _JumpOpcode2);

        function JumpUnlessOpcode() {
            _JumpOpcode2.apply(this, arguments);
            this.type = "jump-unless";
        }

        JumpUnlessOpcode.prototype.evaluate = function evaluate(vm) {
            var reference = vm.frame.getCondition();
            if (_glimmerReference.isConst(reference)) {
                if (!reference.value()) {
                    _JumpOpcode2.prototype.evaluate.call(this, vm);
                }
            } else {
                var cache = new _glimmerReference.ReferenceCache(reference);
                if (!cache.peek()) {
                    _JumpOpcode2.prototype.evaluate.call(this, vm);
                }
                vm.updateWith(new Assert(cache));
            }
        };

        return JumpUnlessOpcode;
    })(JumpOpcode);

    exports.JumpUnlessOpcode = JumpUnlessOpcode;

    var Assert = (function (_UpdatingOpcode) {
        babelHelpers.inherits(Assert, _UpdatingOpcode);

        function Assert(cache) {
            _UpdatingOpcode.call(this);
            this.type = "assert";
            this.tag = cache.tag;
            this.cache = cache;
        }

        Assert.prototype.evaluate = function evaluate(vm) {
            var cache = this.cache;

            if (_glimmerReference.isModified(cache.revalidate())) {
                vm.throw();
            }
        };

        Assert.prototype.toJSON = function toJSON() {
            var type = this.type;
            var _guid = this._guid;
            var cache = this.cache;

            var expected = undefined;
            try {
                expected = JSON.stringify(cache.peek());
            } catch (e) {
                expected = String(cache.peek());
            }
            return {
                guid: _guid,
                type: type,
                args: [],
                details: { expected: expected }
            };
        };

        return Assert;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    exports.Assert = Assert;

    var JumpIfNotModifiedOpcode = (function (_UpdatingOpcode2) {
        babelHelpers.inherits(JumpIfNotModifiedOpcode, _UpdatingOpcode2);

        function JumpIfNotModifiedOpcode(tag, target) {
            _UpdatingOpcode2.call(this);
            this.target = target;
            this.type = "jump-if-not-modified";
            this.tag = tag;
            this.lastRevision = tag.value();
        }

        JumpIfNotModifiedOpcode.prototype.evaluate = function evaluate(vm) {
            var tag = this.tag;
            var target = this.target;
            var lastRevision = this.lastRevision;

            if (!vm.alwaysRevalidate && tag.validate(lastRevision)) {
                vm.goto(target);
            }
        };

        JumpIfNotModifiedOpcode.prototype.didModify = function didModify() {
            this.lastRevision = this.tag.value();
        };

        JumpIfNotModifiedOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type,
                args: [JSON.stringify(this.target.inspect())]
            };
        };

        return JumpIfNotModifiedOpcode;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    exports.JumpIfNotModifiedOpcode = JumpIfNotModifiedOpcode;

    var DidModifyOpcode = (function (_UpdatingOpcode3) {
        babelHelpers.inherits(DidModifyOpcode, _UpdatingOpcode3);

        function DidModifyOpcode(target) {
            _UpdatingOpcode3.call(this);
            this.target = target;
            this.type = "did-modify";
            this.tag = _glimmerReference.CONSTANT_TAG;
        }

        DidModifyOpcode.prototype.evaluate = function evaluate() {
            this.target.didModify();
        };

        return DidModifyOpcode;
    })(_glimmerRuntimeLibOpcodes.UpdatingOpcode);

    exports.DidModifyOpcode = DidModifyOpcode;
});
//# sourceMappingURL=data:application/json;base64,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