# Contributing to FixedDataTable
We want to make contributing to this project as easy and transparent as possible.

## Our Development Process
Some of the core team will be working directly on GitHub. These changes will be public from the beginning. Other changesets will come via a bridge with Facebook's internal source control. This is a necessity as it allows engineers at Facebook outside of the core team to move fast and contribute from an environment they are comfortable in.

## Pull Requests

We actively welcome your pull requests - however, before you begin a pull request, please create an issue so we can determine whether or not the work that you are planning to do is either already being worked on or out of the scope of this project.

1.  Fork the repo and create your branch from `master`.

2. If you've added code that should be tested, add tests (tests coming soon).

3. Ensure the test suite passes (coming soon).

4. Make sure your code lints (coming soon).

5.  Do not commit anything to the `dist` folder.

6. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues
We use GitHub issues to track public bugs. Please ensure your description is clear and has sufficient instructions to be able to reproduce the issue.

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe disclosure of security bugs. In those cases, please go through the process outlined on that page and do not file a public issue.

## Coding Style
* Use semicolons;
* Commas last,
* 2 spaces for indentation (no tabs)
* Prefer `'` over `"`
* `"use strict";`
* 80 character line length
* "Attractive"
* Do not use the optional parameters of `setTimeout` and `setInterval`

## License
By contributing to FixedDataTable, you agree that your contributions will be licensed under its BSD license.
