/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule cancelAnimationFramePolyfill
 */

/**
 * Here is the native and polyfill version of cancelAnimationFrame.
 * Please don't use it directly and use cancelAnimationFrame module instead.
 */
var cancelAnimationFrame =
  global.cancelAnimationFrame       ||
  global.webkitCancelAnimationFrame ||
  global.mozCancelAnimationFrame    ||
  global.oCancelAnimationFrame      ||
  global.msCancelAnimationFrame     ||
  global.clearTimeout;

module.exports = cancelAnimationFrame;
