/*** This file is dynamically generated ***
█████▄ ▄████▄   █████▄ ▄████▄ ██████   ███████▄ ▄████▄ █████▄ ██ ██████ ██  ██
██  ██ ██  ██   ██  ██ ██  ██   ██     ██ ██ ██ ██  ██ ██  ██ ██ ██     ██  ██
██  ██ ██  ██   ██  ██ ██  ██   ██     ██ ██ ██ ██  ██ ██  ██ ██ ██▀▀   ▀▀▀▀██
█████▀ ▀████▀   ██  ██ ▀████▀   ██     ██ ██ ██ ▀████▀ █████▀ ██ ██     █████▀
*/
/*! jQuery UI Virtual Keyboard - Microsoft Generated Layouts */
/* Albanian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdal.html
 */
jQuery.keyboard.layouts['ms-Albanian'] = {
	name: "ms-Albanian",
	lang: ["sq"],
	"normal": [
		"\\ 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t z u i o p \u00e7 @",
		"a s d f g h j k l \u00eb [ ] {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	shift: [
		'| ! " # $ % ^ & * ( ) _ + {bksp}',
		"{tab} Q W E R T Z U I O P \u00c7 '",
		"A S D F G H J K L \u00cb { } {enter}",
		"{shift} > Y X C V B N M ; : ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	alt: [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \\ | {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 \u00d7",
		"{empty} \u0111 \u0110 [ ] {empty} {empty} \u0142 \u0141 $ \u00df \u00a4 {enter}",
		"{shift} {empty} {empty} {empty} {empty} @ { } \u00a7 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Arabic (101) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbda1.html
 */
jQuery.keyboard.layouts['ms-Arabic (101)'] = {
	"name" : "ms-Arabic (101)",
	"lang" : ["ar"],
	"normal" : [
		"\u0630 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0636 \u0635 \u062B \u0642 \u0641 \u063A \u0639 \u0647 \u062E \u062D \u062C \u062F \\",
		"\u0634 \u0633 \u064A \u0628 \u0644 \u0627 \u062A \u0646 \u0645 \u0643 \u0637 {enter}",
		"{shift} \u0626 \u0621 \u0624 \u0631 \u0644\u0627 \u0649 \u0629 \u0648 \u0632 \u0638 {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0651 ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} \u064E \u064B \u064F \u064C \u0644\u0625 \u0625 \u2018 \u00F7 \u00D7 \u061B < > |",
		"\u0650 \u064D ] [ \u0644\u0623 \u0623 \u0640 \u060C / : \" {enter}",
		"{shift} ~ \u0652 } { \u0644\u0622 \u0622 \u2019 , . \u061F {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Arabic (102) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbda2.html
 */
jQuery.keyboard.layouts['ms-Arabic (102)'] = {
	"name" : "ms-Arabic (102)",
	"lang" : ["ar"],
	"normal" : [
		"> 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0636 \u0635 \u062B \u0642 \u0641 \u063A \u0639 \u0647 \u062E \u062D \u062C \u062F {enter}",
		"\u0634 \u0633 \u064A \u0628 \u0644 \u0627 \u062A \u0646 \u0645 \u0643 \u0637 \u0630 ",
		"{shift} \u0640 \u0626 \u0621 \u0624 \u0631 \u0644\u0627 \u0649 \u0629 \u0648 \u0632 \u0638 {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"< ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} \u064E \u064B \u064F \u064C \u0644\u0625 \u0625 \u2018 \u00F7 \u00D7 \u061B } { {enter}",
		"\\ {empty} ] [ \u0644\u0623 \u0623 \u0640 \u060C / : \" \u0651 ",
		"{shift} | ~ \u0652 \u0650 \u064D \u0644\u0622 \u0622 \u2019 , . \u061F {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} \u00A4 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} \u0651\u064E \u0651\u064B \u0651\u064F \u0651\u064C {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ",
		"{shift} {empty} {empty} {empty} \u0651\u0650 \u0651\u064D {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Arabic (102) AZERTY Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbda3.html
 */
jQuery.keyboard.layouts['ms-Arabic (102) AZERTY'] = {
	"name" : "ms-Arabic (102) AZERTY",
	"lang" : ["ar"],
	"normal" : [
		"> & \u00E9 \" ' ( - \u00E8 _ \u00E7 \u00E0 ) = {bksp}",
		"{tab} \u0636 \u0635 \u062B \u0642 \u0641 \u063A \u0639 \u0647 \u062E \u062D \u062C \u062F {enter}",
		"\u0634 \u0633 \u064A \u0628 \u0644 \u0627 \u062A \u0646 \u0645 \u0643 \u0637 \u0630 ",
		"{shift} \\ \u0626 \u0621 \u0624 \u0631 \u0644\u0627 \u0649 \u0629 \u0648 \u0632 \u0638 {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"< 1 2 3 4 5 6 7 8 9 0 \u00B0 + {bksp}",
		"{tab} \u064E \u064B \u064F \u064C \u0644\u0625 \u0625 \u2018 \u00F7 \u00D7 \u061B } { {enter}",
		"\\ {empty} ] [ \u0644\u0623 \u0623 \u0640 \u060C / : \" \u0651 ",
		"{shift} | ~ \u0652 \u0650 \u064D \u0644\u0622 \u0622 \u2019 , . \u061F {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} \u00A4 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} \u0651\u064E \u0651\u064B \u0651\u064F \u0651\u064C {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ",
		"{shift} {empty} {empty} {empty} \u0651\u0650 \u0651\u064D {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Armenian Eastern Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdarme.html
 */
jQuery.keyboard.layouts['ms-Armenian Eastern'] = {
	"name" : "ms-Armenian Eastern",
	"lang" : ["hy-e"],
	"normal" : [
		"\u055d : \u0571 \u0575 \u055b , - . \u00ab \u00bb \u0585 \u057c \u056a {bksp}",
		"{tab} \u056d \u0582 \u0567 \u0580 \u057f \u0565 \u0568 \u056b \u0578 \u057a \u0579 \u057b '",
		"\u0561 \u057d \u0564 \u0586 \u0584 \u0570 \u0573 \u056f \u056c \u0569 \u0583 {enter}",
		"{shift} ' \u0566 \u0581 \u0563 \u057e \u0562 \u0576 \u0574 \u0577 \u0572 / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u055c 1 \u0541 \u0545 3 4 9 \u0587 ( ) \u0555 \u054c \u053a {bksp}",
		"{tab} \u053d \u0552 \u0537 \u0550 \u054f \u0535 \u0538 \u053b \u0548 \u054a \u0549 \u054b \u055e",
		"\u0531 \u054d \u0534 \u0556 \u0554 \u0540 \u0543 \u053f \u053c \u0539 \u0553 {enter}",
		"{shift} \u055e \u0536 \u0551 \u0533 \u054e \u0532 \u0546 \u0544 \u0547 \u0542 / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Armenian Western Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdarmw.html
 */
jQuery.keyboard.layouts['ms-Armenian Western'] = {
	"name" : "ms-Armenian Western",
	"lang" : ["hy-w"],
	"normal" : [
		"\u055d : \u0571 \u0575 \u055b , - . \u00ab \u00bb \u0585 \u057c \u056a {bksp}",
		"{tab} \u056d \u057e \u0567 \u0580 \u0564 \u0565 \u0568 \u056b \u0578 \u0562 \u0579 \u057b '",
		"\u0561 \u057d \u057f \u0586 \u056f \u0570 \u0573 \u0584 \u056c \u0569 \u0583 {enter}",
		"{shift} ' \u0566 \u0581 \u0563 \u0582 \u057a \u0576 \u0574 \u0577 \u0572 / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u055c 1 \u0541 \u0545 3 4 9 \u0587 ( ) \u0555 \u054c \u053a {bksp}",
		"{tab} \u053d \u054e \u0537 \u0550 \u0534 \u0535 \u0538 \u053b \u0548 \u0532 \u0549 \u054b \u055e",
		"\u0531 \u054d \u054f \u0556 \u053f \u0540 \u0543 \u0554 \u053c \u0539 \u0553 {enter}",
		"{shift} \u055e \u0536 \u0551 \u0533 \u0552 \u054a \u0546 \u0544 \u0547 \u0542 / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Assamese - INSCRIPT Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinasa.html
 */
jQuery.keyboard.layouts['ms-Assamese-INSCRIPT'] = {
	"name" : "ms-Assamese-INSCRIPT",
	"lang" : ["as"],
	"normal" : [
		"\u0965 \u09e7 \u09e8 \u09e9 \u09ea \u09eb \u09ec \u09ed \u09ee \u09ef \u09e6 - \u09c3 {bksp}",
		"{tab} \u09cc \u09c8 \u09be \u09c0 \u09c2 \u09ac \u09b9 \u0997 \u09a6 \u099c \u09a1 \u09bc {empty}",
		"\u09cb \u09c7 \u09cd \u09bf \u09c1 \u09aa \u09f0 \u0995 \u09a4 \u099a \u099f {enter}",
		"{shift} {empty} {empty} \u0982 \u09ae \u09a8 \u09f1 \u09b2 \u09b8 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"{empty} ! @ \u09cd\u09f0 \u09f0\u09cd \u099c\u09cd\u099e \u09a4\u09cd\u09f0 \u0995\u09cd\u09b7 \u09b6\u09cd\u09f0 ( ) \u0983 \u098b {bksp}",
		"{tab} \u0994 \u0990 \u0986 \u0988 \u098a \u09ad \u0999 \u0998 \u09a7 \u099d \u09a2 \u099e {empty}",
		"\u0993 \u098f \u0985 \u0987 \u0989 \u09ab {empty} \u0996 \u09a5 \u099b \u09a0 {enter}",
		"{shift} {empty} {empty} \u0981 \u09a3 {empty} {empty} {empty} \u09b6 \u09b7 \u0964 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	'alt' : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	'alt-shift' : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		'A S D F G H J K L : " {enter}',
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Azeri Cyrillic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdaze.html
 */
jQuery.keyboard.layouts['ms-Azeri Cyrillic'] = {
	"name" : "ms-Azeri Cyrillic",
	"lang" : ["az"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0458 \u04af \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u04bb \u0437 \u0445 \u04b9 \\",
		"\u0444 \u044b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u049d {enter}",
		"{shift} \\ \u04d9 \u0447 \u0441 \u043c \u0438 \u0442 \u0493 \u0431 \u04e9 / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! \" \u2116 ; % : ? * ( ) _ + {bksp}",
		"{tab} \u0408 \u04ae \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u04ba \u0417 \u0425 \u04b8 /",
		"\u0424 \u042b \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u049c {enter}",
		"{shift} | \u04d8 \u0427 \u0421 \u041c \u0418 \u0422 \u0492 \u0411 \u04e8 / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Azeri Latin Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdazel.html
 */
jQuery.keyboard.layouts['ms-Azeri Latin'] = {
	"name" : "ms-Azeri Latin",
	"lang" : ["az"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q \u00fc e r t y u i o p \u00f6 \u011f \\",
		"a s d f g h j k l \u0131 \u0259 {enter}",
		"{shift} \\ z x c v b n m \u00e7 \u015f / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! \" \u2166 ; % : ? * ( ) _ + {bksp}",
		"{tab} Q \u00dc E R T Y U \u0130 O P \u00d6 \u011e /",
		"A S D F G H J K L I \u018f {enter}",
		"{shift} / Z X C V B N M \u00c7 \u015e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Bashkir Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbash.html
 */
jQuery.keyboard.layouts['ms-Bashkir'] = {
	"name" : "ms-Bashkir",
	"lang" : ["ba"],
	"normal" : [
		"\u04d9 ! \u04e9 \u04a1 \u0493 \u04ab : \u0499 \u04bb ? \u2116 - \u04af {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u0449 \u0437 \u0445 \u044a \u04a3",
		"\u0444 \u044b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u04d8 \" \u04e8 \u04a0 \u0492 \u04aa ; \u0498 \u04ba ( ) % \u04ae {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u0429 \u0417 \u0425 \u042a \u04a2",
		"\u0424 \u042b \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Bosnian (Cyrillic) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbhc.html
 */
jQuery.keyboard.layouts['ms-Bosnian (Cyrillic)'] = {
	"name" : "ms-Bosnian (Cyrillic)",
	"lang" : ["bs"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 ' + {bksp}",
		"{tab} \u0459 \u045a \u0435 \u0440 \u0442 \u0437 \u0443 \u0438 \u043e \u043f \u0448 \u0452 \u0436",
		"\u0430 \u0441 \u0434 \u0444 \u0433 \u0445 \u0458 \u043a \u043b \u0447 \u045b {enter}",
		"{shift} < \u0455 \u045f \u0446 \u0432 \u0431 \u043d \u043c , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! \" # $ % & / ( ) = ? * {bksp}",
		"{tab} \u0409 \u040a \u0415 \u0420 \u0422 \u0417 \u0423 \u0418 \u041e \u041f \u0428 \u0402 \u0416",
		"\u0410 \u0421 \u0414 \u0424 \u0413 \u0425 \u0408 \u041a \u041b \u0427 \u040b {enter}",
		"{shift} > \u0405 \u040f \u0426 \u0412 \u0411 \u041d \u041c ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} ^ {empty} \u00b0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} \\ | \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} [ ] {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} @ { } \u00a7 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Belarusian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdblr.html
 */
jQuery.keyboard.layouts['ms-Belarusian'] = {
	"name" : "ms-Belarusian",
	"lang" : ["be"],
	"normal" : [
		"\u0451 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u045e \u0437 \u0445 ' \\",
		"\u0444 \u044b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} \\ \u044f \u0447 \u0441 \u043c \u0456 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0401 ! \" \u2116 ; % : ? * ( ) _ + {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u040e \u0417 \u0425 ' /",
		"\u0424 \u042b \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} / \u042f \u0427 \u0421 \u041c \u0406 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Belgian (Comma) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbene.html
 */
jQuery.keyboard.layouts['ms-Belgian (Comma)'] = {
	"name" : "ms-Belgian (Comma)",
	"lang" : ["nl", "fr", "de"],
	"normal" : [
		"\u00b2 & \u00e9 \" ' ( \u00a7 \u00e8 ! \u00e7 \u00e0 ) - {bksp}",
		"{tab} a z e r t y u i o p ^ $ \u00b5",
		"q s d f g h j k l m \u00f9 {enter}",
		"{shift} < w x c v b n , ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b3 1 2 3 4 5 6 7 8 9 0 \u00b0 _ {bksp}",
		"{tab} A Z E R T Y U I O P \u00a8 * \u00a3",
		"Q S D F G H J K L M % {enter}",
		"{shift} > W X C V B N ? . / / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} | @ # { [ ^ {empty} {empty} { } {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ] {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00b4 {enter}",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Belgian French Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbe.html
 */
jQuery.keyboard.layouts['ms-Belgian French'] = {
	"name" : "ms-Belgian French",
	"lang" : ["nl-fr", "fr"],
	"normal" : [
		"\u00b2 & \u00e9 \" ' ( \u00a7 \u00e8 ! \u00e7 \u00e0 ) - {bksp}",
		"{tab} a z e r t y u i o p ^ $ \u00b5",
		"q s d f g h j k l m \u00f9 {enter}",
		"{shift} < w x c v b n , ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b3 1 2 3 4 5 6 7 8 9 0 \u00b0 _ {bksp}",
		"{tab} A Z E R T Y U I O P \u00a8 * \u00a3",
		"Q S D F G H J K L M % {enter}",
		"{shift} > W X C V B N ? . / / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} | @ # { [ ^ {empty} {empty} { } {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ] {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00b4 {enter}",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Bengali Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinben.html
 */
jQuery.keyboard.layouts['ms-Bengali'] = {
	"name" : "ms-Bengali",
	"lang" : ["bn"],
	"normal" : [
		"1 2 3 4 5 6 7 8 9 0 - \u09c3 {bksp}",
		"{tab} \u09cc \u09c8 \u09be \u09c0 \u09c2 \u09ac \u09b9 \u0997 \u09a6 \u099c \u09a1 \u09bc",
		"\u09cb \u09c7 \u09cd \u09bf \u09c1 \u09aa \u09b0 \u0995 \u09a4 \u099a \u099f {enter}",
		"{shift} \u0982 \u09ae \u09a8 \u09ac \u09b2 \u09b8 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"{empty} {empty} \u09cd\u09b0 \u09b0\u09cd \u099c\u09cd\u09b0 \u09a4\u09cd\u09b7 \u0995\u09cd\u09b0 \u09b6\u09cd\u09b0 ( ) \u0983 \u098b {bksp}",
		"{tab} \u0994 \u0990 \u0986 \u0988 \u098a \u09ad \u0999 \u0998 \u09a7 \u099d \u09a2 \u099e",
		"\u0993 \u098f \u0985 \u0987 \u0989 \u09ab {empty} \u0996 \u09a5 \u099b \u09a0 {enter}",
		"{shift} \u0981 \u09a3 {empty} {empty} {empty} \u09b6 \u09b7 { / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u09e7 \u09e8 \u09e9 \u09ea \u09eb \u09ec \u09ed \u09ee \u09ef \u09e6 {empty} \u09e2 {bksp}",
		"{tab} \u09d7 {empty} {empty} \u09e3 {empty} {empty} {empty} {empty} {empty} {empty} \u09dc {empty}",
		"\u09f4 \u09f6 \u09f8 \u09e2 {empty} {empty} \u09f0 {empty} {empty} {empty} {empty} {enter}",
		"{shift} \u09fa {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift":[
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u09e0 {bksp}",
		"{tab} {empty} {empty} {empty} \u09e1 {empty} {empty} {empty} {empty} {empty} {empty} \u09dd {empty}",
		"\u09f5 \u09f7 \u09f9 \u098c {empty} {empty} \u09f1 {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Bengali - INSCRIPT (Legacy) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinbe1.html
 */
jQuery.keyboard.layouts['ms-Bengali - INSCRIPT (Legacy)'] = {
	"name" : "ms-Bengali - INSCRIPT (Legacy)",
	"lang" : ["bn"],
	"normal" : [
		"\u09e7 \u09e8 \u09e9 \u09ea \u09eb \u09ec \u09ed \u09ee \u09ef \u09e6 - \u09c3 {bksp}",
		"{tab} \u09cc \u09c8 \u09be \u09c0 \u09c2 \u09ac \u09b9 \u0997 \u09a6 \u099c \u09a1 \u09bc",
		"\u09cb \u09c7 \u09cd \u09bf \u09c1 \u09aa \u09b0 \u0995 \u09a4 \u099a \u099f {enter}",
		"{shift} \u0982 \u09ae \u09a8 \u09ac \u09b2 \u09b8 , . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"! @ {empty} \u09b0\u09cd \u099c\u09cd\u099e \u09a4\u09cd\u09b0 \u0995\u09cd\u09b7 \u09b6\u09cd\u09b0 ( ) \u0983 \u098b {bksp}",
		"{tab} \u0994 \u0990 \u0986 \u0988 \u098a \u09ad \u0999 \u0998 \u09a7 \u099d \u09a2 \u099e",
		"\u0993 \u098f \u0985 \u0987 \u0989 \u09ab {empty} \u0996 \u09a5 \u099b \u09a0 {enter}",
		"{shift} \u0981 \u09a3 {empty} {empty} {empty} \u09b6 \u09b7 {empty} / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Bulgarian (Phonetic Traditional) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbgph1.html
 */
jQuery.keyboard.layouts['ms-Bulgarian (Phonetic Traditional)'] = {
	"name" : "ms-Bulgarian (Phonetic Traditional)",
	"lang" : ["bg"],
	"normal" : [
		"\u0447 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u044f \u0432 \u0435 \u0440 \u0442 \u044a \u0443 \u0438 \u043e \u043f \u0448 \u0449 \u044e",
		"\u0430 \u0441 \u0434 \u0444 \u0433 \u0445 \u0439 \u043a \u043b ; ' {enter}",
		"{shift} \u044e \u0437 \u044c \u0446 \u0436 \u0431 \u043d \u043c , . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0427 ! @ \u2116 $ % \u20ac \u00a7 * ( ) _ + {bksp}",
		"{tab} \u042f \u0412 \u0415 \u0420 \u0422 \u042a \u0423 \u0418 \u041e \u041f \u0428 \u0429 \u042e",
		"\u0410 \u0421 \u0414 \u0424 \u0413 \u0425 \u0419 \u041a \u041b : \" {enter}",
		"{shift} \u042e \u0417 \u045d \u0426 \u0416 \u0411 \u041d \u041c < > / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Bulgarian (Phonetic) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbgph.html
 */
jQuery.keyboard.layouts['ms-Bulgarian (Phonetic)'] = {
	"name" : "ms-Bulgarian (Phonetic)",
	"lang" : ["bg"],
	"normal" : [
		"\u044e 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0447 \u0448 \u0435 \u0440 \u0442 \u044a \u0443 \u0438 \u043e \u043f \u044f \u0449 \u044c",
		"\u0430 \u0441 \u0434 \u0444 \u0433 \u0445 \u0439 \u043a \u043b ; ' {enter}",
		"{shift} \u045d \u0437 \u0436 \u0446 \u0432 \u0431 \u043d \u043c , . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u042e ! @ \u2116 $ % \u20ac \u00a7 * ( ) \u2013 + {bksp}",
		"{tab} \u0427 \u0428 \u0415 \u0420 \u0422 \u042a \u0423 \u0418 \u041e \u041f \u042f \u0429 \u045d",
		"\u0410 \u0421 \u0414 \u0424 \u0413 \u0425 \u0419 \u041a \u041b : \" {enter}",
		"{shift} \u040d \u0417 \u0416 \u0426 \u0412 \u0411 \u041d \u041c \u201e \u201c / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Bulgarian (Typewriter) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbu.html
 */
jQuery.keyboard.layouts['ms-Bulgarian (Typewriter)'] = {
	"name" : "ms-Bulgarian (Typewriter)",
	"lang" : ["bg"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - . {bksp}",
		"{tab} , \u0443 \u0435 \u0438 \u0448 \u0449 \u043a \u0441 \u0434 \u0437 \u0446 ; (",
		"\u044c \u044f \u0430 \u043e \u0436 \u0433 \u0442 \u043d \u0432 \u043c \u0447 {enter}",
		"{shift} \\ \u044e \u0439 \u044a \u044d \u0444 \u0445 \u043f \u0440 \u043b / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! ? + \" % = : / _ \u2116 \u0406 V {bksp}",
		"{tab} \u044b \u0423 \u0415 \u0418 \u0428 \u0429 \u041a \u0421 \u0414 \u0417 \u0426 \u00a7 )",
		"\u042c \u042f \u0410 \u041e \u0416 \u0413 \u0422 \u041d \u0412 \u041c \u0427 {enter}",
		"{shift} | \u042e \u0419 \u042a \u042d \u0424 \u0425 \u041f \u0420 \u041b / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Canadian French Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdca.html
 */
jQuery.keyboard.layouts['ms-Canadian French'] = {
	"name" : "ms-Canadian French",
	"lang" : ["fr-ca"],
	"normal" : [
		"# 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p ^ \u00b8 <",
		"a s d f g h j k l ; ` {enter}",
		"{shift} \u00ab z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"| ! \" / $ % ? & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P ^ \u00a8 >",
		"A S D F G H J K L : ` {enter}",
		"{shift} \u00bb Z X C V B N M ' . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\\ \u00b1 @ \u00a3 \u00a2 \u00a4 \u00ac \u00a6 \u00b2 \u00b3 \u00bc \u00bd \u00be {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00a7 \u00b6 [ ] }",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~ { {enter}",
		"{shift} \u00b0 {empty} {empty} {empty} {empty} {empty} {empty} \u00b5 \u00af \u00ad {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Canadian French (Legacy) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdfc.html
 */
jQuery.keyboard.layouts['ms-Canadian French (Legacy)'] = {
	"name" : "ms-Canadian French (Legacy)",
	"lang" : ["fr-ca"],
	"normal" : [
		"\u00b0 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p ^ \u00e7 \u00e0",
		"a s d f g h j k l ; \u00e8 {enter}",
		"{shift} \u00f9 z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 ! \" # $ % ? & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P ^ \u00c7 \u00c0",
		"A S D F G H J K L : \u00c8 {enter}",
		"{shift} \u00d9 Z X C V B N M ' . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00ac \u00b9 @ \u00b3 \u00bc \u00bd \u00be { [ ] } | \u00b8 {bksp}",
		"{tab} {empty} {empty} {empty} \u00b6 {empty} \u00a5 {empty} {empty} \u00f8 \u00fe \u00b0 ~ {empty}",
		"\u00e6 \u00df \u00f0 \u00aa {empty} {empty} {empty} {empty} {empty} \u00b4 {empty} {enter}",
		"{shift} \\ \u00ab \u00bb \u00a2 {empty} {empty} {empty} \u00b5 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} \u00a1 \u00b2 \u00a3 \u00a4 {empty} {empty} {empty} {empty} \u00b1 {empty} \u00bf {empty} {bksp}",
		"{tab} {empty} {empty} {empty} \u00ae {empty} {empty} {empty} {empty} \u00d8 \u00de {empty} \u00a8 {empty}",
		"\u00c6 \u00a7 \u00d0 {empty} {empty} {empty} {empty} {empty} {empty} \u00b4 {empty} {enter}",
		"{shift} | {empty} {empty} \u00a9 {empty} {empty} {empty} \u00ba {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Canadian Multilingual Standard Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdcan.html
 */
jQuery.keyboard.layouts['ms-Canadian Multilingual Standard'] = {
	"name" : "ms-Canadian Multilingual Standard",
	"lang" : ["en-ca"],
	"normal" : [
		"/ 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p ^ \u00E7 {enter}",
		"a s d f g h j k l ; \u00E8 \u00E0 ",
		"{shift} \u00F9 z x c v b n m , . \u00E9 {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\\ ! @ # $ % ? & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P \u00A8 \u00C7 {enter}",
		"A S D F G H J K L : \u00C8 \u00C0 ",
		"{shift} \u00D9 Z X C V B N M ' \" \u00C9 {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"| {empty} {empty} {empty} {empty} {empty} {empty} { } [ ] {empty} \u00AC {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ` ~ {enter}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00B0 {empty} {empty} ",
		"{shift} {empty} \u00AB \u00BB {empty} {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Chinese Bopomofo IME Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdTCBO.html
 */
jQuery.keyboard.layouts['ms-Chinese Bopomofo IME'] = {
	"name" : "ms-Chinese Bopomofo IME",
	"lang" : ["zh"],
	"normal" : [
		"\u20AC \u3105 \u3109 \u02C7 \u02CB \u3113 \u02CA \u02D9 \u311A \u311E \u3122 \u3126 = {bksp}",
		"{tab} \u3106 \u310A \u310D \u3110 \u3114 \u3117 \u3127 \u311B \u311F \u3123 [ ] \\",
		"\u3107 \u310B \u310E \u3111 \u3115 \u3118 \u3128 \u311C \u3120 \u3124 ' {enter}",
		"\u3108 \u310C \u310F \u3112 \u3116 \u3119 \u3129 \u311D \u3121 \u3125",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	'alt' : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	'alt-shift' : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		'A S D F G H J K L : " {enter}',
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Chinese ChaJei IME Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdTCCJ.html
 */
jQuery.keyboard.layouts['ms-Chinese ChaJei IME'] = {
	"name" : "ms-Chinese ChaJei IME",
	"lang" : ["zh"],
	"normal" : [
		"\u20AC 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u624B \u7530 \u6C34 \u53E3 \u5EFF \u535C \u5C71 \u6208 \u4EBA \u5FC3 [ ] \\",
		"\u65E5 \u5C38 \u6728 \u706B \u571F \u7AF9 \u5341 \u5927 \u4E2D ; ' {enter}",
		"\uFF3A \u96E3 \u91D1 \u5973 \u6708 \u5F13 \u4E00 , . /",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	'alt' : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	'alt-shift' : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		'A S D F G H J K L : " {enter}',
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Czech Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdcz.html
 */
jQuery.keyboard.layouts['ms-Czech'] = {
	"name" : "ms-Czech",
	"lang" : ["cs"],
	"normal" : [
		"; + \u011b \u0161 \u010d \u0159 \u017e \u00fd \u00e1 \u00ed \u00e9 = \u00b4 {bksp}",
		"{tab} q w e r t z u i o p \u00fa ) {empty}",
		"a s d f g h j k l \u016f \u00a7 {enter}",
		"{shift} \\ y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 1 2 3 4 5 6 7 8 9 0 % \u02c7 {bksp}",
		"{tab} Q W E R T Z U I O P / ( '",
		"A S D F G H J K L \" ! {enter}",
		"{shift} | Y X C V B N M ? : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \\ | \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 \u00d7 \u00a4",
		"{empty} \u0111 \u0110 [ ] {empty} {empty} \u0142 \u0141 $ \u00df {enter}",
		"{shift} {empty} {empty} # & @ { } {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Czech (QWERTY) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdcz1.html
 */
jQuery.keyboard.layouts['ms-Czech (QWERTY)'] = {
	"name" : "ms-Czech (QWERTY)",
	"lang" : ["cs"],
	"normal" : [
		"; + \u011b \u0161 \u010d \u0159 \u017e \u00fd \u00e1 \u00ed \u00e9 = \u00b4 {bksp}",
		"{tab} q w e r t y u i o p \u00fa ) {empty}",
		"a s d f g h j k l \u016f \u00a7 {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 1 2 3 4 5 6 7 8 9 0 % \u02c7 {bksp}",
		"{tab} Q W E R T Y U I O P / ( '",
		"A S D F G H J K L \" ! {enter}",
		"{shift} | Z X C V B N M ? : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` ! @ # $ % ^ & * ( ) - = {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ] \\",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ; \u00a4 {enter}",
		"{shift} \u00df {empty} {empty} {empty} {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} _ + {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } |",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} : ^ {enter}",
		"{shift} \u02dd {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00d7 \u00f7 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Czech Programmers Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdcz2.html
 */
jQuery.keyboard.layouts['ms-Czech Programmers'] = {
	"name" : "ms-Czech Programmers",
	"lang" : ["cs"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"; + \u011b \u0161 \u010d \u0159 \u017e \u00fd \u00e1 \u00ed \u00e9 = \u00b4 {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00fa ) {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u016f \u00a7 {enter}",
		"{shift} \u00df {empty} {empty} {empty} {empty} {empty} {empty} {empty} ? : {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"\u00b0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} % \u02c7 {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} / ( {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \" ! {enter}",
		"{shift} \u02dd {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00d7 \u00f7 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Danish Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdda.html
 */
jQuery.keyboard.layouts['ms-Danish'] = {
	"name" : "ms-Danish",
	"lang" : ["da"],
	"normal" : [
		"\u00BD 1 2 3 4 5 6 7 8 9 0 + \u00B4 {bksp}",
		"{tab} q w e r t y u i o p \u00E5 \u00A8",
		"a s d f g h j k l \u00E6 \u00F8 '  {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00A7 ! \" # \u00A4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00C5 ^",
		"A S D F G H J K L \u00C6 \u00D8 *  {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00A3 $ \u20AC {empty} { [ ] } {empty} | {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Devanagari - INSCRIPT Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdindev.html
 */
jQuery.keyboard.layouts["ms-Devanagari - INSCRIPT"] = {
	name: "ms-Devanagari - INSCRIPT",
	lang: ["hi", "ne", "mr", "kok", "bodo", "mai"],
	"normal": [
		"\u094a 1 2 3 4 5 6 7 8 9 0 - \u0943 {bksp}",
		"{tab} \u094c \u0948 \u093e \u0940 \u0942 \u092c \u0939 \u0917 \u0926 \u091c \u0921 \u093c \u0949",
		"\u094b \u0947 \u094d \u093f \u0941 \u092a \u0930 \u0915 \u0924 \u091a \u091f {enter}",
		"{shift} \u0949 \u0946 \u0902 \u092e \u0928 \u0935 \u0932 \u0938 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	shift: [
		"\u0912 \u090d \u0945 \u094d\u0930 \u0930\u094d \u091c\u094d\u091e \u0924\u094d\u0930 \u0915\u094d\u0937 \u0936\u094d\u0930 ( ) \u0903 \u090b {bksp}",
		"{tab} \u0914 \u0910 \u0906 \u0908 \u090a \u092d \u0919 \u0918 \u0927 \u091d \u0922 \u091e \u0911",
		"\u0913 \u090f \u0905 \u0907 \u0909 \u092b \u0931 \u0916 \u0925 \u091b \u0920 {enter}",
		"{shift} \u0911 \u090e \u0901 \u0923 \u0929 \u0934 \u0933 \u0936 \u0937 \u0964 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	alt: [
		"{empty} \u0967 \u0968 \u0969 \u096a \u096b \u096c \u096d \u096e \u096f \u0966 {empty} \u0944 {bksp}",
		"{tab} {empty} {empty} {empty} \u0963 {empty} {empty} {empty} \u095a {empty} \u095b \u095c {empty} {empty}",
		"{empty} {empty} {empty} \u0962 {empty} {empty} {empty} \u0958 {empty} \u0952 {empty} {enter}",
		"{shift} {empty} \u0953 {empty} \u0954 {empty} {empty} {empty} {empty} \u0970 \u0965 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift": [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0960 {bksp}",
		"{tab} {empty} {empty} {empty} \u0961 {empty} {empty} {empty} {empty} {empty} {empty} \u095d {empty} {empty}",
		"{empty} {empty} {empty} \u090c {empty} \u095e {empty} \u0959 {empty} {empty} \u0951 {enter}",
		"{shift} {empty} {empty} \u0950 {empty} {empty} {empty} {empty} {empty} {empty} \u093d {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Divehi Phonetic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbddiv1.html
 */
jQuery.keyboard.layouts['ms-Divehi Phonetic'] = {
	"name" : "ms-Divehi Phonetic",
	"lang" : ["dv"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u07b0 \u0787 \u07ac \u0783 \u078c \u0794 \u07aa \u07a8 \u07ae \u0795 ] [ \\",
		"\u07a6 \u0790 \u078b \u078a \u078e \u0780 \u0796 \u0786 \u078d \u061b ' {enter}",
		"{shift} \\ \u0792 \u00d7 \u0797 \u0788 \u0784 \u0782 \u0789 \u060c . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} \u07a4 \u07a2 \u07ad \u079c \u0793 \u07a0 \u07ab \u07a9 \u07af \u00f7 } { |",
		"\u07a7 \u0781 \u0791 \ufdf2 \u07a3 \u0799 \u079b \u079a \u0785 : \" {enter}",
		"{shift} | \u07a1 \u0798 \u079d \u07a5 \u079e \u078f \u079f > < / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ; {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {ZWJ} {ZWNJ} {LRM} {RLM} , {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Divehi Typewriter Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbddiv2.html
 */
jQuery.keyboard.layouts['ms-Divehi Typewriter'] = {
	"name" : "ms-Divehi Typewriter",
	"lang" : ["dv"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u07ab \u07ae \u07a7 \u07a9 \u07ad \u078e \u0783 \u0789 \u078c \u0780 \u078d [ ]",
		"\u07a8 \u07aa \u07b0 \u07a6 \u07ac \u0788 \u0787 \u0782 \u0786 \u078a \ufdf2 {enter}",
		"{shift} \\ \u0792 \u0791 \u0790 \u0794 \u0785 \u078b \u0784 \u0781 \u0793 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} \u00d7 \u2019 \u201c / : \u07a4 \u079c \u07a3 \u07a0 \u0799 \u00f7 { }",
		"< > . \u060c \" \u07a5 \u07a2 \u0798 \u079a \u07a1 \u061b {enter}",
		"{shift} | \u0796 \u0795 \u078f \u0797 \u079f \u079b \u079d \\ \u079e / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} , {empty} {empty} {empty} {empty} {empty} {empty} ; {enter}",
		"{shift} {empty} {empty} {empty} {empty} {ZWJ} {ZWNJ} {LRM} {RLM} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Dutch Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdne.html
 */
jQuery.keyboard.layouts['ms-Dutch'] = {
	"name" : "ms-Dutch",
	"lang" : ["nl"],
	"normal" : [
		"@ 1 2 3 4 5 6 7 8 9 0 / \u00B0 {bksp}",
		"{tab} q w e r t y u i o p \u00A8 * {enter}",
		"a s d f g h j k l + \u00B4 < ",
		"{shift} ] z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00A7 ! \" # $ % & _ ( ) ' ? ~ {bksp}",
		"{tab} Q W E R T Y U I O P ^ | {enter}",
		"A S D F G H J K L \u00B1 ` > ",
		"{shift} [ Z X C V B N M ; : = {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00AC \u00B9 \u00B2 \u00B3 \u00BC \u00BD \u00BE \u00A3 { } {empty} \\ \u00B8 {bksp}",
		"{tab} {empty} {empty} \u20AC \u00B6 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{empty} \u00DF {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ",
		"{shift} \u00A6 \u00AB \u00BB \u00A2 {empty} {empty} {empty} \u00B5 {empty} \u00B7 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Estonian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdest.html
 */
jQuery.keyboard.layouts['ms-Estonian'] = {
	"name" : "ms-Estonian",
	"lang" : ["et"],
	"normal" : [
		"\u02c7 1 2 3 4 5 6 7 8 9 0 + \u00b4 {bksp}",
		"{tab} q w e r t y u i o p \u00fc \u00f5 '",
		"a s d f g h j k l \u00f6 \u00e4 {enter}",
		"{shift} < z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! \" # \u00a4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00dc \u00d5 *",
		"A S D F G H J K L \u00d6 \u00c4 {enter}",
		"{shift} > Z X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00a3 $ \u20ac {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00a7 \u00bd",
		"{empty} \u0161 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ^ {enter}",
		"{shift} | \u017e {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} @ \u00a3 $ {empty} {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00a7 \u00bd",
		"{empty} \u0160 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ^ {enter}",
		"{shift} | \u017d {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Faeroese Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdfo.html
 */
jQuery.keyboard.layouts['ms-Faroese'] = {
	"name" : "ms-Faroese",
	"lang" : ["fo"],
	"normal" : [
		"\u00BD 1 2 3 4 5 6 7 8 9 0 + \u00B4 {bksp}",
		"{tab} q w e r t y u i o p \u00E5 \u00F0 {enter}",
		"a s d f g h j k l \u00E6 \u00F8 ' ",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00A7 ! \" # \u00A4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00C5 \u00D0 {enter}",
		"A S D F G H J K L \u00C6 \u00D8 * ",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00A3 $ \u20AC {empty} { [ ] } {empty} | {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00A8 ~ {enter}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ^ {empty} ",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Finnish Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdfi.html
 */
jQuery.keyboard.layouts['ms-Finnish'] = {
	"name" : "ms-Finnish",
	"lang" : ["fi"],
	"normal" : [
		"\u00A7 1 2 3 4 5 6 7 8 9 0 + \u00B4 {bksp}",
		"{tab} q w e r t y u i o p \u00E5 \u00A8 {enter}",
		"a s d f g h j k l \u00F6 \u00E4 ' ",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00BD ! \" # \u00A4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00C5 ^ {enter}",
		"A S D F G H J K L \u00D6 \u00C4 * ",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00A3 $ \u20AC {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~ {enter}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* French Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdfr.html
 */
jQuery.keyboard.layouts['ms-French'] = {
	"name" : "ms-French",
	"lang" : ["fr"],
	"normal" : [
		"\u00B2 & \u00E9 \" ' ( - \u00E8 _ \u00E7 \u00E0 ) = {bksp}",
		"{tab} a z e r t y u i o p ^ $",
		"q s d f g h j k l m \u00F9 * {enter}",
		"{shift} < w x c v b n , ; : ! {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"{empty} 1 2 3 4 5 6 7 8 9 0 \u00B0 + {bksp}",
		"{tab} A Z E R T Y U I O P \u00A8 \u00A3",
		"Q S D F G H J K L M % \u00B5 {enter}",
		"{shift} > W X C V B N ? . / \u00A7 {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} ~ # { [ | ` \\ ^ @ ] } {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00A4",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Gaelic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgae.html
 */
jQuery.keyboard.layouts['ms-Gaelic'] = {
	"name" : "ms-Gaelic",
	"lang" : ["gd"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ]",
		"a s d f g h j k l ; ' # {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"` ! \" \u00A3 $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { }",
		"A S D F G H J K L : @ ~ {enter}",
		"{shift} | Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00A6 {empty} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00E9 {empty} {empty} \u00FD \u00FA \u00ED \u00F3 {empty} {empty} {empty}",
		"\u00E1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ' {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"\u00AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00C9 {empty} {empty} \u00DD \u00DA \u00CD \u00D3 {empty} {empty} {empty}",
		"\u00C1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Georgian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgeo.html
 */
jQuery.keyboard.layouts['ms-Georgian'] = {
	"name" : "ms-Georgian",
	"lang" : ["ka"],
	"normal" : [
		"\u201e ! ? \u2116 \u00a7 % : . ; , / \u2013 = {bksp}",
		"{tab} \u10e6 \u10ef \u10e3 \u10d9 \u10d4 \u10dc \u10d2 \u10e8 \u10ec \u10d6 \u10ee \u10ea (",
		"\u10e4 \u10eb \u10d5 \u10d7 \u10d0 \u10de \u10e0 \u10dd \u10da \u10d3 \u10df {enter}",
		"{shift} ( \u10ed \u10e9 \u10e7 \u10e1 \u10db \u10d8 \u10e2 \u10e5 \u10d1 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u201c 1 2 3 4 5 6 7 8 9 0 - + {bksp}",
		"{tab} \u10e6 \u10ef \u10e3 \u10d9 \u10d4 \u10dc \u10d2 \u10e8 \u10ec \u10d6 \u10ee \u10ea )",
		"\u10e4 \u10eb \u10d5 \u10d7 \u10d0 \u10de \u10e0 \u10dd \u10da \u10d3 \u10df {enter}",
		"{shift} ) \u10ed \u10e9 \u10e7 \u10e1 \u10db \u10d8 \u10e2 \u10e5 \u10d1 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} \u10f1 {empty} {empty} {empty} {empty} {empty} \u10f4 {empty} {empty}",
		"\u10f6 {empty} \u10f3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} \u10f2 {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Georgian (Ergonomic) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgeoer.html
 */
jQuery.keyboard.layouts['ms-Georgian (Ergonomic)'] = {
	"name" : "ms-Georgian (Ergonomic)",
	"lang" : ["ka"],
	"normal" : [
		"\u201e ! \u2116 , ; % : ? . ( ) - \u201c {bksp}",
		"{tab} \u10e9 \u10de \u10e3 \u10eb \u10ed \u10e2 \u10d7 \u10dc \u10d5 \u10e8 \u10d9 \u10e5 /",
		"\u10ee \u10d8 \u10d0 \u10d4 \u10dd \u10d3 \u10db \u10e1 \u10e0 \u10d1 \u10d2 {enter}",
		"{shift} \\ \u10ef \u10f0 \u10e7 \u10e6 \u10df \u10d6 \u10ea \u10da \u10e4 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"' 1 2 3 4 5 6 7 8 9 0 + = {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00a7",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} / {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` ! @ # $ \u20ac ^ & * ( ) \u2014 = {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u10fc \u10f3 {empty} [ ] \\",
		"\u10f4 \u10f2 \u10fa \u10f1 {empty} {empty} {empty} {empty} {empty} {empty} \u10f9 {enter}",
		"{shift} {empty} {empty} \u10f5 \u10f8 \u10f7 {empty} {empty} {empty} {empty} \u10f6 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ {empty} {empty} \u00a7 {empty} {empty} {empty} {empty} \u00b0 \u00ab \u00bb _ {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} I {empty} {empty} { } |",
		"{empty} {empty} D {empty} {empty} {empty} {empty} {empty} L {empty} \" {enter}",
		"{shift} {empty} {empty} X C V {empty} {empty} M < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Georgian (QWERTY) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgeoqw.html
 */
jQuery.keyboard.layouts['ms-Georgian (QWERTY)'] = {
	"name" : "ms-Georgian (QWERTY)",
	"lang" : ["ka"],
	"normal" : [
		"\u201e 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u10e5 \u10ec \u10d4 \u10e0 \u10e2 \u10e7 \u10e3 \u10d8 \u10dd \u10de [ ] ~",
		"\u10d0 \u10e1 \u10d3 \u10e4 \u10d2 \u10f0 \u10ef \u10d9 \u10da ; ' {enter}",
		"{shift} \\ \u10d6 \u10ee \u10ea \u10d5 \u10d1 \u10dc \u10db , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u201c ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} {empty} \u10ed {empty} \u10e6 \u10d7 {empty} {empty} {empty} {empty} {empty} { } |",
		"{empty} \u10e8 {empty} {empty} {empty} {empty} \u10df {empty} {empty} : \" {enter}",
		"{shift} {empty} \u10eb {empty} \u10e9 {empty} {empty} N {empty} < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} \u201e \u201c {empty} \u20ac {empty} {empty} \u00b0 {empty} {empty} \u2014 \u2013 {bksp}",
		"{tab} {empty} {empty} \u10f1 \u00ae {empty} \u10f8 {empty} \u10f2 {empty} {empty} {empty} {empty} {empty}",
		"\u10fa {empty} {empty} \u10f6 \u10f9 \u10f5 \u10f7 {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} \u10f4 \u00a9 \u10f3 {empty} \u10fc {empty} \u00ab \u00bb {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* German Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgr.html
 */
jQuery.keyboard.layouts['ms-German'] = {
	"name" : "ms-German",
	"lang" : ["de"],
	"normal" : [
		"^ 1 2 3 4 5 6 7 8 9 0 \u00DF \u00B4 {bksp}",
		"{tab} q w e r t z u i o p \u00FC +",
		"a s d f g h j k l \u00F6 \u00E4 # {enter}",
		"{shift} < y x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B0 ! \" \u00A7 $ % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Z U I O P \u00DC *",
		"A S D F G H J K L \u00D6 \u00C4 ' {enter}",
		"{shift} > Y X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} \u00B2 \u00B3 {empty} {empty} {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} @ {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* German (IBM) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgr1.html
 */
jQuery.keyboard.layouts['ms-German (IBM)'] = {
	"name" : "ms-German (IBM)",
	"lang" : ["de"],
	"normal" : [
		"^ 1 2 3 4 5 6 7 8 9 0 \u00DF \u00B4 {bksp}",
		"{tab} q w e r t z u i o p \u00FC +",
		"a s d f g h j k l \u00F6 \u00E4 # {enter}",
		"{shift} < y x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B0 ! \" \u00A7 $ % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Z U I O P \u00DC *",
		"A S D F G H J K L \u00D6 \u00C4 ' {enter}",
		"{shift} > Y X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} \u00B2 \u00B3 {empty} {empty} {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} @ {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greek Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhe.html
 */
jQuery.keyboard.layouts['ms-Greek'] = {
	"name" : "ms-Greek",
	"lang" : ["el"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} ; \u03C2 \u03B5 \u03C1 \u03C4 \u03C5 \u03B8 \u03B9 \u03BF \u03C0 [ ]",
		"\u03B1 \u03C3 \u03B4 \u03C6 \u03B3 \u03B7 \u03BE \u03BA \u03BB \u0384 ' \\ {enter}",
		"{shift} < \u03B6 \u03C7 \u03C8 \u03C9 \u03B2 \u03BD \u03BC , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} : \u0385 \u0395 \u03A1 \u03A4 \u03A5 \u0398 \u0399 \u039F \u03A0 { }",
		"\u0391 \u03A3 \u0394 \u03A6 \u0393 \u0397 \u039E \u039A \u039B \u00A8 \" | {enter}",
		"{shift} > \u0396 \u03A7 \u03A8 \u03A9 \u0392 \u039D \u039C < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} \u00B2 \u00B3 \u00A3 \u00A7 \u00B6 {empty} \u00A4 \u00A6 \u00B0 \u00B1 \u00BD {bksp}",
		"{tab} {empty} {empty} \u20AC \u00AE {empty} \u00A5 {empty} {empty} {empty} {empty} \u00AB \u00BB",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0385 {empty} \u00AC {enter}",
		"{shift} {empty} {empty} {empty} \u00A9 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greek (220) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhe220.html
 */
jQuery.keyboard.layouts['ms-Greek (220)'] = {
	"name" : "ms-Greek (220)",
	"lang" : ["el"],
	"normal" : [
		"\u00BD 1 2 3 4 5 6 7 8 9 0 ' ] {bksp}",
		"{tab} \u037E \u03C2 \u03B5 \u03C1 \u03C4 \u03C5 \u03B8 \u03B9 \u03BF \u03C0 + }",
		"\u03B1 \u03C3 \u03B4 \u03C6 \u03B3 \u03B7 \u03BE \u03BA \u03BB \u0384 \u00A8 # {enter}",
		"{shift} < \u03B6 \u03C7 \u03C8 \u03C9 \u03B2 \u03BD \u03BC , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B1 ! \" \u00A3 $ % & / ( ) = ? [ {bksp}",
		"{tab} : ~ \u0395 \u03A1 \u03A4 \u03A5 \u0398 \u0399 \u039F \u03A0 * {",
		"\u0391 \u03A3 \u0394 \u03A6 \u0393 \u0397 \u039E \u039A \u039B \u00A8 \u0385 @ {enter}",
		"{shift} > \u0396 \u03A7 \u03A8 \u03A9 \u0392 \u039D \u039C ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} \u00B2 \u00B3 \u00A3 \u00A7 \u00B6 {empty} \u00A4 \u00A6 \u00B0 \u00B1 \u00BD {bksp}",
		"{tab} {empty} {empty} \u20AC \u00AE {empty} \u00A5 {empty} {empty} {empty} {empty} \u00AB \u00BB",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0385 \u0385 \u00AC {enter}",
		"{shift} {empty} {empty} {empty} \u00A9 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greek (220) Latin Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhela2.html
 */
jQuery.keyboard.layouts['ms-Greek (220) Latin'] = {
	"name" : "ms-Greek (220) Latin",
	"lang" : ["el"],
	"normal" : [
		"\\ 1 2 3 4 5 6 7 8 9 0 ' ] {bksp}",
		"{tab} q w e r t y u i o p + }",
		"a s d f g h j k l \u0384 \u00A8 # {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"| ! \" # $ % & / ( ) = ? [ {bksp}",
		"{tab} Q W E R T Y U I O P * {",
		"A S D F G H J K L \u00A8 \u0385 @ {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} \u00B2 \u00B3 \u00A3 \u00A7 \u00B6 {empty} \u00A4 \u00A6 \u00B0 \u00B1 \u00BD {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00AB \u00BB",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0385 \u0385 \u00AC {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greek (319) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhe319.html
 */
jQuery.keyboard.layouts['ms-Greek (319)'] = {
	"name" : "ms-Greek (319)",
	"lang" : ["el"],
	"normal" : [
		"\u00BD 1 2 3 4 5 6 7 8 9 0 ' + {bksp}",
		"{tab} \u00B7 \u03C2 \u03B5 \u03C1 \u03C4 \u03C5 \u03B8 \u03B9 \u03BF \u03C0 [ ]",
		"\u03B1 \u03C3 \u03B4 \u03C6 \u03B3 \u03B7 \u03BE \u03BA \u03BB \u0384 \u2019 \u00B2 {enter}",
		"{shift} \u00A7 \u03B6 \u03C7 \u03C8 \u03C9 \u03B2 \u03BD \u03BC , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B1 ! \" \u00A3 $ % \u00AC / ( ) = \u00B0 * {bksp}",
		"{tab} \u2015 \u00A6 \u0395 \u03A1 \u03A4 \u03A5 \u0398 \u0399 \u039F \u03A0 \u00AB \u00BB",
		"\u0391 \u03A3 \u0394 \u03A6 \u0393 \u0397 \u039E \u039A \u039B \u00A8 \u2018 \u00B3 {enter}",
		"{shift} \u00A9 \u0396 \u03A7 \u03A8 \u03A9 \u0392 \u039D \u039C ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0385 {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greek (319) Latin Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhela3.html
 */
jQuery.keyboard.layouts['ms-Greek (319) Latin'] = {
	"name" : "ms-Greek (319) Latin",
	"lang" : ["el"],
	"normal" : [
		"\\ 1 2 3 4 5 6 7 8 9 0 ' + {bksp}",
		"{tab} q w e r t y u i o p [ ]",
		"a s d f g h j k l \u00B4 ^ ` {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"| ! \" # $ % & / ( ) = ? * {bksp}",
		"{tab} Q W E R T Y U I O P { }",
		"A S D F G H J K L \u00A8 ~ @ {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greek Latin Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgkl.html
 */
jQuery.keyboard.layouts['ms-Greek Latin'] = {
	"name" : "ms-Greek Latin",
	"lang" : ["el"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ]",
		"a s d f g h j k l ; ' \\ {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { }",
		"A S D F G H J K L : \" | {enter}",
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00A1 \u00B2 \u00B3 \u00A4 \u20AC \u00BC \u00BD \u00BE \u2018 \u2019 \u00A5 \u00D7 {bksp}",
		"{tab} \u00E4 \u00E5 \u00E9 \u00AE \u00FE \u00FC \u00FA \u00ED \u00F3 \u00F6 \u00AB \u00BB",
		"\u00E1 \u00DF \u00F0 {empty} {empty} {empty} {empty} {empty} \u00F8 \u00B6 \u00B4 \u00AC {enter}",
		"{shift} \u00E6 {empty} \u00A9 {empty} {empty} \u00F1 \u00B5 \u00E7 {empty} \u00BF {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} \u00B9 {empty} {empty} \u00A3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00F7 {bksp}",
		"{tab} \u00C4 \u00C5 \u00C9 {empty} \u00DE \u00DC \u00DA \u00CD \u00D3 \u00D6 {empty} {empty}",
		"\u00C1 \u00A7 \u00D0 {empty} {empty} {empty} {empty} {empty} \u00D8 \u00B0 \u00A8 \u00A6 {enter}",
		"{shift} \u00C6 {empty} \u00A2 {empty} {empty} \u00D1 {empty} \u00C7 {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greek Polytonic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhept.html
 */
jQuery.keyboard.layouts['ms-Greek Polytonic'] = {
	"name" : "ms-Greek Polytonic",
	"lang" : ["el"],
	"normal" : [
		"~ 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} ; \u03C2 \u03B5 \u03C1 \u03C4 \u03C5 \u03B8 \u03B9 \u03BF \u03C0 [ ]",
		"\u03B1 \u03C3 \u03B4 \u03C6 \u03B3 \u03B7 \u03BE \u03BA \u03BB \u0384 ' \\ {enter}",
		"{shift} \u03B6 \u03C7 \u03C8 \u03C9 \u03B2 \u03BD \u03BC , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"` ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} : \u0385 \u0395 \u03A1 \u03A4 \u03A5 \u0398 \u0399 \u039F \u03A0 { }",
		"\u0391 \u03A3 \u0394 \u03A6 \u0393 \u0397 \u039E \u039A \u039B \u00A8 \" | {enter}",
		"{shift} \u0396 \u03A7 \u03A8 \u03A9 \u0392 \u039D \u039C < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u1FC1 \u03DA \u03DE \u03E0 \u00A3 \u00A7 \u00B6 {empty} \u00A4 \u00A6 \u00B0 \u00B1 \u00BD {bksp}",
		"{tab} \u1FFD {empty} \u20AC \u00AE {empty} \u00A5 {empty} {empty} {empty} {empty} \u00AB \u00BB",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0385 \u1FBF \u00AC {enter}",
		"{shift} {empty} {empty} \u00A9 {empty} {empty} {empty} {empty} {empty} {empty} \u1FBE {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} \u00B2 \u00B3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u1FDF {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0387",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u1FFE \u1FDD {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u1FDE {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Greenlandic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdgrlnd.html
 */
jQuery.keyboard.layouts['ms-Greenlandic'] = {
	"name" : "ms-Greenlandic",
	"lang" : ["kl"],
	"normal" : [
		"\u00bd 1 2 3 4 5 6 7 8 9 0 + \u00b4 {bksp}",
		"{tab} q w e r t y u i o p \u00e5 \u00a8 '",
		"a s d f g h j k l \u00e6 \u00f8 {enter}",
		"{shift} < z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00a7 ! \" # \u00a4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00c5 ^ *",
		"A S D F G H J K L \u00c6 \u00d8 {enter}",
		"{shift} > Z X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00a3 $ \u20ac {empty} { [ ] } {empty} | {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} \u00fe {empty} ~ {empty}",
		"{empty} \u00df \u00f0 {empty} {empty} {empty} {empty} \u0138 {empty} {empty} {empty} {enter}",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} \u00b5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00de {empty} {empty} {empty}",
		"{empty} {empty} \u00d0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Gujarati Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinguj.html
 */
jQuery.keyboard.layouts['ms-Gujarati'] = {
	"name" : "ms-Gujarati",
	"lang" : ["gu"],
	"normal" : [
		"{empty} 1 2 3 4 5 6 7 8 9 0 - \u0ac3 {bksp}",
		"{tab} \u0acc \u0ac8 \u0abe \u0ac0 \u0ac2 \u0aac \u0ab9 \u0a97 \u0aa6 \u0a9c \u0aa1 \u0abc \u0ac9",
		"\u0acb \u0ac7 \u0acd \u0abf \u0ac1 \u0aaa \u0ab0 \u0a95 \u0aa4 \u0a9a \u0a9f {enter}",
		"{shift} \u0a82 \u0aae \u0aa8 \u0ab5 \u0ab2 \u0ab8 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"{empty} \u0a8d \u0ac5 \u0acd\u0ab0 \u0ab0\u0acd \u0a9c\u0acd\u0a9e \u0aa4\u0acd\u0ab0 \u0a95\u0acd\u0ab7 \u0ab6\u0acd\u0ab0 ( ) \u0a83 \u0a8b {bksp}",
		"{tab} \u0a94 \u0a90 \u0a86 \u0a88 \u0a8a \u0aad \u0a99 \u0a98 \u0aa7 \u0a9d \u0aa2 \u0a9e \u0a91",
		"\u0a93 \u0a8f \u0a85 \u0a87 \u0a89 \u0aab {empty} \u0a96 \u0aa5 \u0a9b \u0aa0 {enter}",
		"{shift} \u0a81 \u0aa3 {empty} {empty} \u0ab3 \u0ab6 \u0ab7 \u0964 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u0ae7 \u0ae8 \u0ae9 \u0aea \u0aeb \u0aec \u0aed \u0aee \u0aef \u0ae6 {empty} \u0ac4 {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0965 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0ae0 {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} \u0ad0 {empty} {empty} {empty} {empty} {empty} {empty} \u0abd {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// gu = ISO 639-1 code for Gujarati
// ***********************
jQuery.keyboard.language.gu = {
	display : {
		'a'      : '\u2714:Accept (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Accept:Accept (Shift+Enter)',
		'alt'    : 'AltGr:Alternate Graphemes',
		'b'      : '\u2190:Backspace',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Backspace',
		'c'      : '\u2716:Cancel (Esc)', // big X, close - same action as cancel
		'cancel' : 'Cancel:Cancel (Esc)',
		'clear'  : 'C:Clear',             // clear num pad
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : '.:Decimal',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Enter',        // down, then left arrow - enter symbol
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Shift',        // thick hollow up arrow
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:Change Sign',  // +/- sign for num pad
		'space'  : '&nbsp;:Space',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Use mousewheel to see other keys',
};

/* Hausa Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhau.html
 */
jQuery.keyboard.layouts['ms-Hausa'] = {
	"name" : "ms-Hausa",
	"lang" : ["ha"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} \u20ac {empty} {empty} {empty} \u2018 \u2019 {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} \u01b4 {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} \u0257 {empty} {empty} {empty} {empty} \u0199 {empty} \u00b6 \u2019 {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} \u0253 {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} \u01b3 {empty} {empty} {empty} {empty} {empty} {empty} \u00a6",
		"{empty} {empty} \u018a {empty} {empty} {empty} {empty} \u0198 {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} \u0181 {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Hebrew Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdheb.html
 */
jQuery.keyboard.layouts['ms-Hebrew'] = {
	"name" : "ms-Hebrew",
	"lang" : ["he"],
	"normal" : [
		"; 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} / ' \u05e7 \u05e8 \u05d0 \u05d8 \u05d5 \u05df \u05dd \u05e4 ] [ \\",
		"\u05e9 \u05d3 \u05d2 \u05db \u05e2 \u05d9 \u05d7 \u05dc \u05da \u05e3 , {enter}",
		"{shift} \\ \u05d6 \u05e1 \u05d1 \u05d4 \u05e0 \u05de \u05e6 \u05ea \u05e5 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} Q W E R T Y U I O P } { |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M > < / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} \u20aa {empty} {empty} {empty} {empty} {empty} {empty} \u05bf {empty} {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} \u05f0 {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} \u05f2 \u05f1 {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Hindi Traditional Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinhin.html
 */
jQuery.keyboard.layouts['ms-Hindi Traditional'] = {
	"name" : "ms-Hindi Traditional",
	"lang" : ["hi"],
	"normal" : [
		"{empty} 1 2 3 4 5 6 7 8 9 0 - \u0943 {bksp}",
		"{tab} \u094c \u0948 \u093e \u0940 \u0942 \u092c \u0939 \u0917 \u0926 \u091c \u0921 \u093c \u0949",
		"\u094b \u0947 \u094d \u093f \u0941 \u092a \u0930 \u0915 \u0924 \u091a \u091f {enter}",
		"{shift} \u0949 \u0902 \u092e \u0928 \u0935 \u0932 \u0938 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"{empty} \u090d \u0945 \u094d\u0930 \u0930\u094d \u091c\u094d\u091e \u0924\u094d\u0930 \u0915\u094d\u0937 \u0936\u094d\u0930 ( ) \u0903 \u090b {bksp}",
		"{tab} \u0914 \u0910 \u0906 \u0908 \u090a \u092d \u0919 \u0918 \u0927 \u091d \u0922 \u091e \u0911",
		"\u0913 \u090f \u0905 \u0907 \u0909 \u092b \u0931 \u0916 \u0925 \u091b \u0920 {enter}",
		"{shift} \u0911 \u0901 \u0923 {empty} {empty} \u0933 \u0936 \u0937 \u0964 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` \u0967 \u0968 \u0969 \u096a \u096b \u096c \u096d \u096e \u096f \u0966 - = {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ] \\",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ; ' {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} , . {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } |",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} : \" {enter}",
		"{shift} {empty} \u0950 {empty} {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Hungarian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhu.html
 */
jQuery.keyboard.layouts['ms-Hungarian'] = {
	"name" : "ms-Hungarian",
	"lang" : ["hu"],
	"normal" : [
		"0 1 2 3 4 5 6 7 8 9 \u00F6 \u00FC \u00F3 {bksp}",
		"{tab} q w e r t z u i o p \u0151 \u00FA",
		"a s d f g h j k l \u00E9 \u00E1 \u0171 {enter}",
		"{shift} \u00ED y x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00A7 ' \" + ! % / = ( ) \u00D6 \u00DC \u00D3 {bksp}",
		"{tab} Q W E R T Z U I O P \u0150 \u00DA",
		"A S D F G H J K L \u00C9 \u00C1 \u0170 {enter}",
		"{shift} \u00CD Y X C V B N M ? : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02C7 ^ \u02D8 \u00B0 \u02DB ` \u02D9 \u00B4 \u02DD \u00A8 \u00B8 {bksp}",
		"{tab} \\ | \u00C4 {empty} {empty} {empty} \u20AC \u00CD {empty} {empty} \u00F7 \u00D7",
		"\u00E4 \u0111 \u0110 [ ] {empty} \u00ED \u0142 \u0141 $ \u00DF \u00A4 {enter}",
		"{shift} < > # & @ { } < ; > * {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Hungarian 101-key Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdhu1.html
 */
jQuery.keyboard.layouts['ms-Hungarian 101-key'] = {
	"name" : "ms-Hungarian 101-key",
	"lang" : ["hu"],
	"normal" : [
		"\u00ED 1 2 3 4 5 6 7 8 9 \u00F6 \u00FC \u00F3 {bksp}",
		"{tab} q w e r t y u i o p \u0151 \u00FA",
		"a s d f g h j k l \u00E9 \u00E1 \u0171 {enter}",
		"{shift} \u00ED z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00CD ' \" + ! % / = ( ) \u00D6 \u00DC \u00D3 {bksp}",
		"{tab} Q W E R T Y U I O P \u0150 \u00DA",
		"A S D F G H J K L \u00C9 \u00C1 \u0170 {enter}",
		"{shift} \u00CD Z X C V B N M ? : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"0 ~ \u02C7 ^ \u02D8 \u00B0 \u02DB ` \u02D9 \u00B4 \u02DD {empty} {empty} {bksp}",
		"{tab} \\ | \u00C4 \u00A7 \u00A4 {empty} \u20AC \u00CD {empty} {empty} \u00F7 \u00D7",
		"\u00E4 \u0111 \u0110 [ ] {empty} \u00ED \u0142 \u0141 $ \u00DF \\ {enter}",
		"{shift} < > # & @ { } < ; > * {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Icelandic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdic.html
 */
jQuery.keyboard.layouts['ms-Icelandic'] = {
	"name" : "ms-Icelandic",
	"lang" : ["is"],
	"normal" : [
		"\u00B0 1 2 3 4 5 6 7 8 9 0 \u00F6 - {bksp}",
		"{tab} q w e r t y u i o p \u00F0 '",
		"a s d f g h j k l \u00E6 \u00B4 + {enter}",
		"{shift} < z x c v b n m , . \u00FE {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00A8 ! \" # $ % & / ( ) = \u00D6 _ {bksp}",
		"{tab} Q W E R T Y U I O P \u00D0 ?",
		"A S D F G H J K L \u00C6 ' * {enter}",
		"{shift} > Z X C V B N M ; : \u00DE {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00B0 {empty} {empty} {empty} {empty} \u20AC {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} @ {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ^ ` {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Igbo Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdibo.html
 */
jQuery.keyboard.layouts['ms-Igbo'] = {
	"name" : "ms-Igbo",
	"lang" : ["ig"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} \u20ac {empty} {empty} {empty} \u2018 \u2019 {empty} {empty} {bksp}",
		"{tab} \u1ecb\u0301 \u1ecb\u0300 \u1ecb\u0304 {empty} {empty} {empty} \u1ee5 \u1ecb \u1ecd {empty} {empty} {empty} {empty}",
		"\u1ecd\u0301 \u1ecd\u0300 \u1ecd\u0304 \u1ee5\u0301 \u1ee5\u0300 \u1ee5\u0304 {empty} {empty} {empty} \u00b6 \u00b4 {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} \u1e45 m\u0300 m\u0304 n\u0304 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} \u1eca\u0301 \u1eca\u0300 \u1eca\u0304 {empty} {empty} {empty} \u1ee4 \u1eca \u1ecc {empty} {empty} {empty} \u00a6",
		"\u1ecc\u0301 \u1ecc\u0300 \u1ecc\u0304 \u1ee4\u0301 \u1ee4\u0300 \u1ee4\u0304 {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} \u1e44 M\u0300 M\u0304 N\u0304 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Inuktitut - Latin Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdiulat.html
 */
jQuery.keyboard.layouts['ms-Inuktitut - Latin'] = {
	"name" : "ms-Inuktitut - Latin",
	"lang" : ["iu"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ 1 2 3 4 5 6 7 8 9 0 _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ! @ # $ % * & \u2022 [ ] {empty} = {bksp}",
		"{tab} \u1590 \u1404 \u1580 \u146e \u144f \u14f0 \u14a6 \u14c3 \u14d6 \u1529 \u201c \u2018 {empty}",
		"\u1592 \u1406 \u1582 \u1470 \u1451 \u14f2 \u14a8 \u14c5 \u14d8 \u2026 \u0142 {enter}",
		"{shift} {empty} \u1594 \u140b \u1584 \u1473 \u1456 \u14f5 \u14ab {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ \u00a2 \u00ae \u00bc \u00bd \u00be ^ \u2154 \u00a9 \u00f7 + {empty} {empty} {bksp}",
		"{tab} \u148c \u1432 \u1547 {empty} \u1672 \u1674 \u1676 \u15a5 \u15a1 {empty} \u201d \u2019 |",
		"\u148e \u1434 \u1549 \u1556 {empty} {empty} \u152b \u1558 \u15a3 {empty} \u0141 {enter}",
		"{shift} | \u1491 \u1439 \u154c { } \u14c8 \u14db {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Inuktitut - Naqittaut Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinuk2.html
 */
jQuery.keyboard.layouts['ms-Inuktitut - Naqittaut'] = {
	"name" : "ms-Inuktitut - Naqittaut",
	"lang" : ["iu"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { [ |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ! @ # $ % * & \u2022 [ ] {empty} = {bksp}",
		"{tab} \u1590 \u1404 \u1580 \u146e \u144f \u14f0 \u14a6 \u14c3 \u14d6 \u1529 \u201c \u2018 {empty}",
		"\u1592 \u1406 \u1582 \u1470 \u1451 \u14f2 \u14a8 \u14c5 \u14d8 \u014b \u0142 {enter}",
		"{shift} {empty} \u1594 \u140b \u1584 \u1473 \u1456 \u14f5 \u14ab {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ \u00a2 \u00ae \u00bc \u00bd \u00be ^ \u2154 \u00a9 \u00f7 + {empty} {empty} {bksp}",
		"{tab} \u148c \u1432 \u1547 {empty} \u1672 \u1674 \u1676 \u15a5 \u15a1 {empty} \u201d \u2019 |",
		"\u148e \u1434 \u1549 \u1556 {empty} {empty} \u152b \u1558 \u15a3 {empty} \u0141 {enter}",
		"{shift} | \u1491 \u1439 \u154c { } \u14c8 \u14db {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Irish Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdir.html
 */
jQuery.keyboard.layouts['ms-Irish'] = {
	"name" : "ms-Irish",
	"lang" : ["ga"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] #",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00ac ! \" \u00a3 $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } ~",
		"A S D F G H J K L : @ {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00a6 {empty} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00e9 {empty} {empty} {empty} \u00fa \u00ed \u00f3 {empty} {empty} {empty} {empty}",
		"\u00e1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00b4 {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"\u00a6 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00c9 {empty} {empty} {empty} \u00da \u00cd \u00d3 {empty} {empty} {empty} {empty}",
		"\u00c1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ` {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Italian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdit.html
 */
jQuery.keyboard.layouts['ms-Italian'] = {
	"name" : "ms-Italian",
	"lang" : ["it"],
	"normal" : [
		"\\ 1 2 3 4 5 6 7 8 9 0 ' \u00EC {bksp}",
		"{tab} q w e r t y u i o p \u00E8 +",
		"a s d f g h j k l \u00F2 \u00E0 \u00F9 {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"| ! \" \u00A3 $ % & / ( ) = ? ^ {bksp}",
		"{tab} Q W E R T Y U I O P \u00E9 *",
		"A S D F G H J K L \u00E7 \u00B0 \u00A7 {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ]",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} @ # {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { }",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Italian (142) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdit142.html
 */
jQuery.keyboard.layouts['ms-Italian (142)'] = {
	"name" : "ms-Italian (142)",
	"lang" : ["it"],
	"normal" : [
		"\\ 1 2 3 4 5 6 7 8 9 0 ' \u00EC {bksp}",
		"{tab} q w e r t y u i o p \u00E8 +",
		"a s d f g h j k l \u00F2 \u00E0 \u00F9 {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"| ! \" \u00A3 $ % & / ( ) = ? ^ {bksp}",
		"{tab} Q W E R T Y U I O P \u00E9 *",
		"A S D F G H J K L \u00E7 \u00B0 \u00A7 {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} # {empty} \u20AC {empty} { [ ] } {empty} {empty} {bksp}",
		"{tab} @ {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ` {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Japanese Hiragana Keyboard Layout
* from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdJapan.html
*/
jQuery.keyboard.layouts["ms-Japanese Hiragana"] = {
	"name" : "ms-Japanese Hiragana",
	"lang" : ["ja"],

	// Hiragana
	"normal" : [
		"\u308d:Ro \u306c:Nu \u3075:Hu \u3042:A \u3046:U \u3048:E \u304a:O \u3084:Ya \u3086:Yu \u3088:Yo \u308f:Wa \u307b:Ho \u3078:He {bksp}",
		"{tab} \u305f:Ta \u3066:Te \u3044:I \u3059:Su \u304b:Ka \u3093:N \u306a:Na \u306b:Ni \u3089:Ra \u305b:Se \u309b \u309c \u3080:Mu",
		"\u3061:Ti \u3068:To \u3057:Si \u306f:Ha \u304D:Ki \u304f:Ku \u307e:Ma \u306e:No \u308a:Ri \u308c:Re \u3051:Ke {enter}",
		"{shift} \u3064:Tu \u3055:Sa \u305d:So \u3072:Hi \u3053:Ko \u307f:Mi \u3082:Mo \u306d:Ne \u308b:Ru \u3081:Me {shift}",
		"{accept} {space} {meta3} {meta1:Kana} {cancel}"
	],
	"shift" : [
		"\u308d:Ro \u306c:Nu \u3075:Hu \u3041:a \u3045:u \u3047:e \u3049:o \u3083:ya \u3085:yu \u3087:yo \u3092:Wo \u30fc \u3078:He {bksp}",
		"{tab} \u305f:Ta \u3066:Te \u3043:i \u3059:Su \u304b:Ka \u3093:N \u306a:Na \u306b:Ni \u3089:Ra \u305b:Se \u300c \u300d \u3080:Mu",
		"\u3061:Ti \u3068:To \u3057:Si \u306f:Ha \u304D:Ki \u304f:Ku \u307e:Ma \u306e:No \u308a:Ri \u308c:Re \u3051:Ke {enter}",
		"{shift} \u3063:tu \u3055:Sa \u305d:So \u3072:Hi \u3053:Ko \u307f:Mi \u3082:Mo \u3001 \u3002 \u30fb {shift}",
		"{accept} {space} {meta3} {meta1:Kana} {cancel}"
	],
	// English - half width (normal)
	// \u5168 全 = full width active; switch to half width
	// \u534a 半 = half width active; switch to full width
	"meta1" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; : {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {space} {default:Eng} {meta2:\u534a:full} {cancel}"
	],
	"meta1-shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L + * {enter}",
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {space} {default:Eng} {meta2:\u534a:full} {cancel}"
	],
	// English - full width
	"meta2" : [
		"\uff40 \uff11 \uff12 \uff13 \uff14 \uff15 \uff16 \uff17 \uff18 \uff19 \uff10 \uff0d \uff1d {bksp}",
		"{tab} \uff51 \uff57 \uff45 \uff52 \uff54 \uff59 \uff55 \uff49 \uff4f \uff50 \uff3b \uff3d \uffe5",
		"\uff41 \uff53 \uff44 \uff46 \uff47 \uff48 \uff4a \uff4b \uff4c \uff1b \uff07 {enter}",
		"{shift} \uff5a \uff58 \uff43 \uff56 \uff42 \uff4e \uff4d \uff0c \uff0e \uff0f {shift}",
		"{accept} {space} {default:Eng} {meta1:\u5168:half} {cancel}"
	],
	"meta2-shift" : [
		"\uff5e \uff01 \uff20 \uff03 \uff04 \uff05 \uff3e \uff06 \uff0a \uff08 \uff09 \uff3f \uff0b {bksp}",
		"{tab} \uff31 \uff37 \uff25 \uff32 \uff34 \uff39 \uff35 \uff29 \uff2f \uff30 \uff5b \uff5d \uff5c",
		"\uff21 \uff33 \uff24 \uff26 \uff27 \uff28 \uff2a \uff2b \uff2c \uff1a \uff02 {enter}",
		"{shift} \uff3a \uff38 \uff23 \uff36 \uff22 \uff2e \uff2d \uff1c \uff1e \uff1f {shift}",
		"{accept} {space} {meta3:Eng} {meta1:\u5168:half} {cancel}"
	],
	// Katakana full width
	"meta3" : [
		"\u30ed:Ro \u30cc:Nu \u30d5:Hu \u30a2:A \u30a6:U \u30a8:E \u30aa:O \u30e4:Ya \u30e6:Yu \u30e8:Yo \u30ef:Wa \u30db:Ho \u30d8:He {bksp}",
		"{tab} \u30bf:Ta \u30c6:Te \u30a4:I \u30b9:Su \u30ab:Ka \u30f3:N \u30ca:Na \u30cb:Ni \u30e9:Ra \u30bb:Se \u309b \u309c \u30e0:Mu",
		"\u30c1:Ti \u30c8:To \u30b7:Si \u30cf:Ha \u30ad:Ki \u30af:Ku \u30de:Ma \u30ce:No \u30ea:Ri \u30ec:Re \u30b1:Ke {enter}",
		"{shift} \u30c4:Tu \u30b5:Sa \u30bd:So \u30d2:Hi \u30b3:Ko \u30df:Mi \u30e2:Mo \u30cd:Ne \u30eb:Ru \u30e1:Me {shift}",
		"{accept} {space} {default} {meta2} {meta4:\u5168:half} {cancel}"
	],
	"meta3-shift" : [
		"\u30ed:Ro \u30cc:Nu \u30d5:Hu \u30a1:a \u30a5:u \u30a7:e \u30a9:o \u30e3:ya \u30e5:yu \u30e7:yo \u30f2:Wo \u30fc \u30d8:He {bksp}",
		"{tab} \u30bf:Ta \u30c6:Te \u30a3:i \u30b9:Su \u30ab:Ka \u30f3:N \u30ca:Na \u30cb:Ni \u30e9:Ra \u30bb:Se \u300c \u300d \u30e0:Mu",
		"\u30c1:Ti \u30c8:To \u30b7:Si \u30cf:Ha \u30ad:Ki \u30af:Ku \u30de:Ma \u30ce:No \u30ea:Ri \u30ec:Re \u30b1:Ke {enter}",
		"{shift} \u30c3:tu \u30b5:Sa \u30bd:So \u30d2:Hi \u30b3:Ko \u30df:Mi \u30e2:Mo \u3001 \u3002 \u30fb {shift}",
		"{accept} {space} {default} {meta2} {meta4:\u5168:half} {cancel}"
	],
	// Katakana half width
	"meta4" : [
		"\uff9b:Ro \uff87:Nu \uff8c:Hu \uff71:A \uff73:U \uff74:E \uff75:O \uff94:Ya \uff95:Yu \uff96:Yo \uff9c:Wa \uff8e:Ho \uff8d:He {bksp}",
		"{tab} \uff80:Ta \uff83:Te \uff72:I \uff7d:Su \uff76:Ka \uff9d:N \uff85:Na \uff86:Ni \uff97:Ra \uff7e:Se \uff9e \uff9f \uff91:Mu",
		"\uff81:Ti \uff84:To \uff7c:Si \uff8a:Ha \uff77:Ki \uff78:Ku \uff8f:Ma \uff89:No \uff98:Ri \uff9a:Re \uff79:Ke {enter}",
		"{shift} \uff82:Tu \uff7b:Sa \uff7f:So \uff8b:Hi \uff7a:Ko \uff90:Mi \uff93:Mo \uff88:Ne \uff99:Ru \uff92:Me {shift}",
		"{accept} {space} {default} {meta1} {meta3:\u534a:full} {cancel}"
	],
	"meta4-shift" : [
		"\uff9b:Ro \uff87:Nu \uff8c:Hu \uff67:a \uff69:u \uff6a:e \uff6b:o \uff6c:ya \uff6d:yu \uff6e:yo \uff66:Wo \uff70 \uff8d:He {bksp}",
		"{tab} \uff80:Ta \uff83:Te \uff68:i \uff7d:Su \uff76:Ka \uff9d:N \uff85:Na \uff86:Ni \uff97:Ra \uff7e:Se \u300c \u300d \uff91:Mu",
		"\uff81:Ti \uff84:To \uff7c:Si \uff8a:Ha \uff77:Ki \uff78:Ku \uff8f:Ma \uff89:No \uff98:Ri \uff9a:Re \uff79:Ke {enter}",
		"{shift} \uff6f:tu \uff7b:Sa \uff7f:So \uff8b:Hi \uff7a:Ko \uff90:Mi \uff93:Mo \u3001 \u3002 \u30fb {shift}",
		"{accept} {space} {default} {meta1} {meta3:\u534a:full} {cancel}"
	]
};

/* Kannada Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinkan.html
 */
jQuery.keyboard.layouts['ms-Kannada'] = {
	"name" : "ms-Kannada",
	"lang" : ["kn"],
	"normal" : [
		"\u0cca 1 2 3 4 5 6 7 8 9 0 - \u0cc3 {bksp}",
		"{tab} \u0ccc \u0cc8 \u0cbe \u0cc0 \u0cc2 \u0cac \u0cb9 \u0c97 \u0ca6 \u0c9c \u0ca1 {empty}",
		"\u0ccb \u0cc7 \u0ccd \u0cbf \u0cc1 \u0caa \u0cb0 \u0c95 \u0ca4 \u0c9a \u0c9f {enter}",
		"{shift} \u0cc6 \u0c82 \u0cae \u0ca8 \u0cb5 \u0cb2 \u0cb8 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0c92 {empty} {empty} \u0ccd\u0cb0 \u0cb0\u0ccd \u0c9c\u0ccd\u0c9e \u0ca4\u0ccd\u0cb0 \u0c95\u0ccd\u0cb7 \u0cb6\u0ccd\u0cb0 ( ) \u0c83 \u0c8b {bksp}",
		"{tab} \u0c94 \u0c90 \u0c86 \u0c88 \u0c8a \u0cad \u0c99 \u0c98 \u0ca7 \u0c9d \u0ca2 \u0c9e",
		"\u0c93 \u0c8f \u0c85 \u0c87 \u0c89 \u0cab \u0cb1 \u0c96 \u0ca5 \u0c9b \u0ca0 {enter}",
		"{shift} \u0c8e {empty} \u0ca3 {empty} {empty} \u0cb3 \u0cb6 \u0cb7 | / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u0ce7 \u0ce8 \u0ce9 \u0cea \u0ceb \u0cec \u0ced \u0cee \u0cef \u0ce6 {empty} \u0cc4 {bksp}",
		"{tab} {empty} \u0cd6 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} \u0cd5 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0ce0 {bksp}",
		"{tab} {empty} {empty} {empty} \u0ce1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} \u0c8c {empty} \u0cde {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Kazakh Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdkaz.html
 */
jQuery.keyboard.layouts['ms-Kazakh'] = {
	"name" : "ms-Kazakh",
	"lang" : ["kk"],
	"normal" : [
		"( \" \u04D9 \u0456 \u04A3 \u0493 , . \u04AF \u04B1 \u049B \u04E9 \u04BB {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043A \u0435 \u043D \u0433 \u0448 \u0449 \u0437 \u0445 \u044A \\",
		"\u0444 \u044B \u0432 \u0430 \u043F \u0440 \u043E \u043B \u0434 \u0436 \u044D {enter}",
		"{shift} \\ \u044F \u0447 \u0441 \u043C \u0438 \u0442 \u044C \u0431 \u044E \u2116 {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		") ! \u04D8 \u0406 \u04A2 \u0492 ; : \u04AE \u04B0 \u049A \u04E8 \u04BA {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041A \u0415 \u041D \u0413 \u0428 \u0429 \u0417 \u0425 \u042A /",
		"\u0424 \u042B \u0412 \u0410 \u041F \u0420 \u041E \u041B \u0414 \u0416 \u042D {enter}",
		"{shift} | \u042F \u0427 \u0421 \u041C \u0418 \u0422 \u042C \u0411 \u042E ? {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Korean Keyboard Layout
 * generated from file : ///D : /Repos/Keyboard/tmp/Layouts/Korean/Korean Keyboard Layout.htm
 */
jQuery.keyboard.layouts["ms-Korean"] = {
	"name" : "ms-Korean",
	"lang" : ["ko"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u1107 \u110c \u1103 \u1100 \u1109 \u116d \u1167 \u1163 \u1162 \u1166 [ ] \u20a9",
		"\u1106 \u1102 \u110b \u1105 \u1112 \u1169 \u1165 \u1161 \u1175 ; ' {enter}",
		"{shift} \u110f \u1110 \u110e \u1111 \u1172 \u116e \u1173 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} \u1108 \u110d \u1104 \u1101 \u110a \u116d \u1167 \u1163 \u1164 \u1168 { } |",
		'\u1106 \u1102 \u110b \u1105 \u1112 \u1169 \u1165 \u1161 \u1175 : " {enter}',
		"{shift} \u110f \u1110 \u110e \u1111 \u1172 \u116e \u1173 < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \u20a9",
		"a s d f g h j k l ; ' {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		'A S D F G H J K L : " {enter}',
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Kyrgyz Cyrillic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdKyr.html
 */
jQuery.keyboard.layouts['ms-Kyrgyz Cyrillic'] = {
	"name" : "ms-Kyrgyz Cyrillic",
	"lang" : ["ky"],
	"normal" : [
		"\u0451 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u0449 \u0437 \u0445 \u044a \\",
		"\u0444 \u044b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} \\ \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0401 ! \" \u2116 ; % : ? * ( ) _ + {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u0429 \u0417 \u0425 \u042a /",
		"\u0424 \u042b \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} / \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u04af {empty} {empty} \u04a3 {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} \u04e9 {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u04ae {empty} {empty} \u04a2 {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} \u04e8 {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Lao Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdlao.html
 */
jQuery.keyboard.layouts['ms-Lao'] = {
	"name" : "ms-Lao",
	"lang" : ["lo"],
	"normal" : [
		"\" \u0ea2 \u0e9f \u0ec2 \u0e96 \u0eb8 \u0eb9 \u0e84 \u0e95 \u0e88 \u0e82 \u0e8a \u0ecd {bksp}",
		"{tab} \u0ebb \u0ec4 \u0eb3 \u0e9e \u0eb0 \u0eb4 \u0eb5 \u0eae \u0e99 \u0e8d \u0e9a \u0ea5 /",
		"\u0eb1 \u0eab \u0e81 \u0e94 \u0ec0 \u0ec9 \u0ec8 \u0eb2 \u0eaa \u0ea7 \u0e87 {enter}",
		"{shift} \u0e9c \u0e9b \u0ec1 \u0ead \u0eb6 \u0eb7 \u0e97 \u0ea1 \u0ec3 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"' 1 2 3 4 \u0ecc \u0ebc 5 6 7 8 9 \u0ecd\u0ec8 {bksp}",
		"{tab} \u0ebb\u0ec9 0 * _ + \u0eb4\u0ec9 \u0eb5\u0ec9 \u0ea3 \u0edc \u0ebd - \u0eab\u0ebc \\",
		"\u0eb1\u0ec9 ; . , : \u0eca \u0ecb ! ? % = {enter}",
		"{shift} \u20ad ( \u0eaf x \u0eb6\u0ec9 \u0eb7\u0ec9 \u0ec6 \u0edd $ / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u0ed1 \u0ed2 \u0ed3 \u0ed4 \u0ed5 \u0ed6 \u0ed7 \u0ed8 \u0ed9 \u0ed0 {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Latin American Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdla.html
 */
jQuery.keyboard.layouts['ms-Latin American'] = {
	"name" : "ms-Latin American",
	"lang" : ["es"],
	"normal" : [
		"| 1 2 3 4 5 6 7 8 9 0 ' \u00BF {bksp}",
		"{tab} q w e r t y u i o p \u00B4 +",
		"a s d f g h j k l \u00F1 { } {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B0 ! \" # $ % & / ( ) = ? \u00A1 {bksp}",
		"{tab} Q W E R T Y U I O P \u00A8 *",
		"A S D F G H J K L \u00D1 [ ] {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \\ {empty} {bksp}",
		"{tab} @ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ^ ` {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Latvian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdlv.html
 */
jQuery.keyboard.layouts['ms-Latvian'] = {
	"name" : "ms-Latvian",
	"lang" : ["lv"],
	"normal" : [
		"\u00ad 1 2 3 4 5 6 7 8 9 0 - f {bksp}",
		"{tab} \u016b g j r m v n z \u0113 \u010d \u017e h \u0137",
		"\u0161 u s i l d a t e c \u00b4 {enter}",
		"{shift} \u0123 \u0146 b \u012b k p o \u0101 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"? ! \u00ab \u00bb $ % / & \u00d7 ( ) _ F {bksp}",
		"{tab} \u016a G J R M V N Z \u0112 \u010c \u017d H \u0136",
		"\u0160 U S I L D A T E C \u00b0 {enter}",
		"{shift} \u0122 \u0145 B \u012a K P O \u0100 ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00ab {empty} {empty} \u20ac \" \u2019 {empty} : {empty} {empty} \u2013 = {bksp}",
		"{tab} q \u0123 {empty} \u0157 w y {empty} {empty} {empty} {empty} [ ] {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u20ac {empty} \u00b4 {enter}",
		"{shift} \\ {empty} x {empty} \u0137 {empty} \u00f5 {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} @ # $ ~ ^ \u00b1 {empty} {empty} {empty} \u2014 ; {bksp}",
		"{tab} Q \u0122 {empty} \u0156 W Y {empty} {empty} {empty} {empty} { } {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00a8 {enter}",
		"{shift} | {empty} X {empty} \u0136 {empty} \u00d5 {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Latvian (QWERTY) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdlv1.html
 */
jQuery.keyboard.layouts['ms-Latvian (QWERTY)'] = {
	"name" : "ms-Latvian (QWERTY)",
	"lang" : ["lv"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] {empty}",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00ad {empty} \u00ab \u00bb \u20ac {empty} \u2019 {empty} {empty} {empty} {empty} \u2013 {empty} {bksp}",
		"{tab} {empty} {empty} \u0113 \u0157 {empty} {empty} \u016b \u012b \u00f5 {empty} {empty} {empty} {empty}",
		"\u0101 \u0161 {empty} {empty} \u0123 {empty} {empty} \u0137 \u013c {empty} \u00b4 {enter}",
		"{shift} {empty} \u017e {empty} \u010d {empty} {empty} \u0146 {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} \u00a7 \u00b0 {empty} \u00b1 \u00d7 {empty} {empty} \u2014 {empty} {bksp}",
		"{tab} {empty} {empty} \u0112 \u0156 {empty} {empty} \u016a \u012a \u00d5 {empty} {empty} {empty} {empty}",
		"\u0100 \u0160 {empty} {empty} \u0122 {empty} {empty} \u0136 \u013b {empty} \u00a8 {enter}",
		"{shift} {empty} \u017d {empty} \u010c {empty} {empty} \u0145 {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Lithuanian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdlt1.html
 */
jQuery.keyboard.layouts['ms-Lithuanian'] = {
	"name" : "ms-Lithuanian",
	"lang" : ["lt"],
	"normal" : [
		"` \u0105 \u010d \u0119 \u0117 \u012f \u0161 \u0173 \u016b 9 0 - \u017e {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ \u0104 \u010c \u0118 \u0116 \u012e \u0160 \u0172 \u016a ( ) _ \u017d {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} 1 2 3 4 5 6 7 8 9 0 {empty} = {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} ! @ # $ % ^ & * {empty} {empty} {empty} + {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Lithuanian IBM Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdlt.html
 */
jQuery.keyboard.layouts['ms-Lithuanian IBM'] = {
	"name" : "ms-Lithuanian IBM",
	"lang" : ["lt"],
	"normal" : [
		"` ! \" / ; : , . ? ( ) _ + {bksp}",
		"{tab} \u0105 \u017e e r t y u i o p \u012f \u201c |",
		"a s d f g h j k l \u0173 \u0117 {enter}",
		"{shift} \\ z \u016b c v b n m \u010d \u0161 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0104 \u017d E R T Y U I O P \u012e \u201d \\",
		"A S D F G H J K L \u0172 \u0116 {enter}",
		"{shift} | Z \u016a C V B N M \u010c \u0160 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} { [ ] } {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Lithuanian Standard Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdlt2.html
 */
jQuery.keyboard.layouts['ms-Lithuanian Standard'] = {
	"name" : "ms-Lithuanian Standard",
	"lang" : ["lt"],
	"normal" : [
		"` ! - / ; : , . = ( ) ? x {bksp}",
		"{tab} \u0105 \u017e e r t y u i o p \u012f w q",
		"a s d \u0161 g h j k l \u0173 \u0117 {enter}",
		"{shift} < z \u016b c v b n m \u010d f / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ 1 2 3 4 5 6 7 8 9 0 + X {bksp}",
		"{tab} \u0104 \u017d E R T Y U I O P \u012e W Q",
		"A S D \u0160 G H J K L \u0172 \u0116 {enter}",
		"{shift} > Z \u016a C V B N M \u010c F / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00b4 @ _ # $ \u00a7 ^ & * [ ] ' % {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } |",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \" {enter}",
		"{shift} \u2013 {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u201e \u201c {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Luxembourgish Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsf.html
 */
jQuery.keyboard.layouts['ms-Luxembourgish'] = {
	"name" : "ms-Luxembourgish",
	"lang" : ["lb"],
	"normal" : [
		"\u00a7 1 2 3 4 5 6 7 8 9 0 ' ^ {bksp}",
		"{tab} q w e r t z u i o p \u00e8 \u00a8 $",
		"a s d f g h j k l \u00e9 \u00e0 {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 + \" * \u00e7 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Z U I O P \u00fc ! \u00a3",
		"A S D F G H J K L \u00f6 \u00e4 {enter}",
		"{shift} > Y X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00a6 @ # \u00b0 \u00a7 \u00ac | \u00a2 {empty} {empty} \u00b4 ~ {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ] }",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { {enter}",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Macedonian (FYROM) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdmac.html
 */
jQuery.keyboard.layouts['ms-Macedonian (FYROM)'] = {
	"name" : "ms-Macedonian (FYROM)",
	"lang" : ["mk"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0459 \u045a \u0435 \u0440 \u0442 \u0455 \u0443 \u0438 \u043e \u043f \u0448 \u0453 \u0436",
		"\u0430 \u0441 \u0434 \u0444 \u0433 \u0445 \u0458 \u043a \u043b \u0447 \u045c {enter}",
		"{shift} \u0451 \u0437 \u045f \u0446 \u0432 \u0431 \u043d \u043c , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! \u201e \u201c \u2019 % \u2018 & * ( ) _ + {bksp}",
		"{tab} \u0409 \u040a \u0415 \u0420 \u0422 \u0405 \u0423 \u0418 \u041e \u041f \u0428 \u0403 \u0416",
		"\u0410 \u0421 \u0414 \u0424 \u0413 \u0425 \u0408 \u041a \u041b \u0427 \u040c {enter}",
		"{shift} \u0401 \u0417 \u040f \u0426 \u0412 \u0411 \u041d \u041c ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0402 \u0452 {empty}",
		"{empty} {empty} {empty} [ ] {empty} {empty} {empty} {empty} \u040b \u045b {enter}",
		"{shift} {empty} {empty} {empty} {empty} @ { } \u00a7 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Macedonian (FYROM) - Standard Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdmacst.html
 */
jQuery.keyboard.layouts['ms-Macedonian (FYROM) - Standard'] = {
	"name" : "ms-Macedonian (FYROM) - Standard",
	"lang" : ["mk"],
	"normal" : [
		"\u045d 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0459 \u045a \u0435 \u0440 \u0442 \u0455 \u0443 \u0438 \u043e \u043f \u0448 \u0453 \u0436",
		"\u0430 \u0441 \u0434 \u0444 \u0433 \u0445 \u0458 \u043a \u043b \u0447 \u045c {enter}",
		"{shift} \u0450 \u0437 \u045f \u0446 \u0432 \u0431 \u043d \u043c , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u040d ! \u201e \u201c ' % \u201a \u2018 * ( ) - + {bksp}",
		"{tab} \u0409 \u040a \u0415 \u0420 \u0422 \u0405 \u0423 \u0418 \u041e \u041f \u0428 \u0403 \u0416",
		"\u0410 \u0421 \u0414 \u0424 \u0413 \u0425 \u0408 \u041a \u041b \u0427 \u040c {enter}",
		"{shift} \u0400 \u0417 \u040f \u0426 \u0412 \u0411 \u041d \u041c ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00b0 @ # $ {empty} ^ & \u2026 { } \u2014 \u0301 {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ] |",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Malayalam Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinmal.html
 */
jQuery.keyboard.layouts['ms-Malayalam'] = {
	"name" : "ms-Malayalam",
	"lang" : ["ml"],
	"normal" : [
		"\u0d4a 1 2 3 4 5 6 7 8 9 0 - \u0d43 {bksp}",
		"{tab} \u0d4c \u0d48 \u0d3e \u0d40 \u0d42 \u0d2c \u0d39 \u0d17 \u0d26 \u0d1c \u0d21 {empty}",
		"\u0d4b \u0d47 \u0d4d \u0d3f \u0d41 \u0d2a \u0d30 \u0d15 \u0d24 \u0d1a \u0d1f {enter}",
		"{shift} \u0d46 \u0d02 \u0d2e \u0d28 \u0d35 \u0d32 \u0d38 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0d12 {empty} {empty} \u0d4d\u0d30 {empty} {empty} {empty} \u0d15\u0d4d\u0d37 {empty} ( ) \u0d03 \u0d0b {bksp}",
		"{tab} \u0d14 \u0d10 \u0d06 \u0d08 \u0d0a \u0d2d \u0d19 \u0d18 \u0d27 \u0d1d \u0d22 \u0d1e",
		"\u0d13 \u0d0f \u0d05 \u0d07 \u0d09 \u0d2b \u0d31 \u0d16 \u0d25 \u0d1b \u0d20 {enter}",
		"{shift} \u0d0e {empty} \u0d23 {empty} \u0d34 \u0d33 \u0d36 \u0d37 {empty} / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u0d67 \u0d68 \u0d69 \u0d6a \u0d6b \u0d6c \u0d6d \u0d6e \u0d6f \u0d66 {empty} {empty} {bksp}",
		"{tab} \u0d57 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0d60 {bksp}",
		"{tab} {empty} {empty} {empty} \u0d61 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} \u0d0c {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Maltese 47-Key Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdmlt47.html
 */
jQuery.keyboard.layouts['ms-Maltese 47-Key'] = {
	"name" : "ms-Maltese 47-Key",
	"lang" : ["mt"],
	"normal" : [
		"\u010b 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p \u0121 \u0127 \u017c",
		"a s d f g h j k l ; ' {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u010a ! @ \u20ac $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P \u0120 \u0126 \u017b",
		"A S D F G H J K L : \" {enter}",
		"{shift} Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` {empty} {empty} \u00a3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00e8 {empty} {empty} {empty} \u00f9 \u00ec \u00f2 {empty} [ ] \\",
		"\u00e0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00c8 {empty} {empty} {empty} \u00d9 \u00cc \u00d2 {empty} { } |",
		"\u00c0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Maltese 48-Key Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdmlt48.html
 */
jQuery.keyboard.layouts['ms-Maltese 48-Key'] = {
	"name" : "ms-Maltese 48-Key",
	"lang" : ["mt"],
	"normal" : [
		"\u010b 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p \u0121 \u0127 #",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u017c z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u010a ! \" \u20ac $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P \u0120 \u0126 ~",
		"A S D F G H J K L : @ {enter}",
		"{shift} \u017b Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` {empty} {empty} \u00a3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00e8 {empty} {empty} {empty} \u00f9 \u00ec \u00f2 {empty} [ ] {empty}",
		"\u00e0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"\u00ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00c8 {empty} {empty} {empty} \u00d9 \u00cc \u00d2 {empty} { } {empty}",
		"\u00c0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Maori Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdmaori.html
 */
jQuery.keyboard.layouts['ms-Maori'] = {
	name : "ms-Maori",
	lang : ["mi"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {space} {cancel}"
	],
	shift : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		'A S D F G H J K L : " {enter}',
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Marathi Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinmar.html
 */
jQuery.keyboard.layouts['ms-Marathi'] = {
	"name" : "ms-Marathi",
	"lang" : ["mr"],
	"normal" : [
		"{empty} \u0967 \u0968 \u0969 \u096a \u096b \u096c \u096d \u096e \u096f \u0966 - \u0943 {bksp}",
		"{tab} \u094c \u0948 \u093e \u0940 \u0942 \u092c \u0939 \u0917 \u0926 \u091c \u0921 \u093c \u0949",
		"\u094b \u0947 \u094d \u093f \u0941 \u092a \u0930 \u0915 \u0924 \u091a \u091f {enter}",
		"{shift} \u0949 \u0902 \u092e \u0928 \u0935 \u0932 \u0938 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"{empty} \u090d \u0945 \u094d\u0930 \u0930\u094d \u091c\u094d\u091e \u0924\u094d\u0930 \u0915\u094d\u0937 \u0936\u094d\u0930 ( ) \u0903 \u090b {bksp}",
		"{tab} \u0914 \u0910 \u0906 \u0908 \u090a \u092d \u0919 \u0918 \u0927 \u091d \u0922 \u091e \u0911",
		"\u0913 \u090f \u0905 \u0907 \u0909 \u092b \u0931 \u0916 \u0925 \u091b \u0920 {enter}",
		"{shift} \u0911 \u0901 \u0923 {empty} {empty} \u0933 \u0936 \u0937 \u0964 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ] \\",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ; ' {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} , . {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } |",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} : \" {enter}",
		"{shift} {empty} \u093d \u0950 {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Mongolian Cyrillic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdmon.html
 */
jQuery.keyboard.layouts['ms-Mongolian Cyrillic'] = {
	"name" : "ms-Mongolian Cyrillic",
	"lang" : ["mn"],
	"normal" : [
		"= \u2116 - \" \u20ae : . _ , % ? \u0435 \u0449 {bksp}",
		"{tab} \u0444 \u0446 \u0443 \u0436 \u044d \u043d \u0433 \u0448 \u04af \u0437 \u043a \u044a \\",
		"\u0439 \u044b \u0431 \u04e9 \u0430 \u0445 \u0440 \u043e \u043b \u0434 \u043f {enter}",
		"{shift} \\ \u044f \u0447 \u0451 \u0441 \u043c \u0438 \u0442 \u044c \u0432 / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"+ 1 2 3 4 5 6 7 8 9 0 \u0415 \u0429 {bksp}",
		"{tab} \u0424 \u0426 \u0423 \u0416 \u042d \u041d \u0413 \u0428 \u04ae \u0417 \u041a \u042a |",
		"\u0419 \u042b \u0411 \u04e8 \u0410 \u0425 \u0420 \u041e \u041b \u0414 \u041f {enter}",
		"{shift} | \u042f \u0427 \u0401 \u0421 \u041c \u0418 \u0422 \u042c \u0412 / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Mongolian (Mongolian Script) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdmonmo.html
 */
jQuery.keyboard.layouts['ms-Mongolian (Mongolian Script)'] = {
	"name" : "ms-Mongolian (Mongolian Script)",
	"lang" : ["mn"],
	"normal" : [
		"\u180d 1 2 3 4 5 6 7 8 9 0 \u202f = {bksp}",
		"{tab} \u1834 \u1823 \u1821 \u1837 \u1832 \u1836 \u1826 \u1822 \u1825 \u182b \u3014 \u3015 \u1801",
		"\u1820 \u1830 \u1833 \u1839 \u182d \u182c \u1835 \u183a \u182f ; \u180b {enter}",
		"{shift} {empty} \u183d \u1831 \u183c \u1824 \u182a \u1828 \u182e \u1802 \u1803 / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! \u2048 \u2049 \u2014 % {ZWNJ} \u180a {ZWJ} ( ) \u180e + {bksp}",
		"{tab} {empty} \u1838 \u1827 \u183f {empty} {empty} {empty} {empty} {empty} {empty} \u3008 \u3009 |",
		"{empty} {empty} {empty} {empty} {empty} \u183e {empty} \u183b \u1840 \u1804 \u180c {enter}",
		"{shift} {empty} \u1841 {empty} \u1842 {empty} {empty} \u1829 {empty} \u300a \u300b / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Nepali Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdnepr.html
 */
jQuery.keyboard.layouts['ms-Nepali'] = {
	"name" : "ms-Nepali",
	"lang" : ["ne"],
	"normal" : [
		"\u091e \u091c\u094d\u091e \u0918 \u0919 \u091d \u091b \u091f \u0920 \u0921 \u0922 \u0923 ( . {bksp}",
		"{tab} \u0924\u094d\u0930 \u0927 \u092d \u091a \u0924 \u0925 \u0917 \u0937 \u092f \u0909 \u0943 \u0947 \u094d\u0930",
		"\u092c \u0915 \u092e \u093e \u0928 \u091c \u0935 \u092a \u093f \u0938 \u0941 {enter}",
		"{shift} \u0936 \u0939 \u0905 \u0916 \u0926 \u0932 \u092b , \u0964 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u091e\u094d \u0967 \u0968 \u0969 \u096a \u096b \u096c \u096d \u096e \u096f \u0966 ) \u0902 {bksp}",
		"{tab} \u094b \u0927\u094d \u092d\u094d \u091a\u094d \u0924\u094d \u0925\u094d \u0917\u094d \u0915\u094d\u0937 \u0907 \u090f \u0930\u094d \u0948 \u094d",
		"\u092c\u094d \u0915\u094d \u092e\u094d \u0901 \u0928\u094d \u091c\u094d \u0935\u094d \u092a\u094d \u0940 \u0938\u094d \u0942 {enter}",
		"{shift} \u0936\u094d \u0939\u094d \u090b \u0916\u094d \u0926\u094d \u0932\u094d \u0903 ? \u0936\u094d\u0930 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} 1 2 3 4 5 6 7 8 9 0 {empty} + {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u090a {empty} \u0914 {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} \u0906 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Norwegian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdno.html
 */
jQuery.keyboard.layouts['ms-Norwegian'] = {
	"name" : "ms-Norwegian",
	"lang" : ["no"],
	"normal" : [
		"| 1 2 3 4 5 6 7 8 9 0 + \\ {bksp}",
		"{tab} q w e r t y u i o p \u00E5 \u00A8",
		"a s d f g h j k l \u00F8 \u00E6 ' {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00A7 ! \" # \u00A4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00C5 ^",
		"A S D F G H J K L \u00D8 \u00C6 * {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00A3 $ \u20AC {empty} { [ ] } {empty} \u00B4 {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Norwegian with Sami Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdno1.html
 */
jQuery.keyboard.layouts['ms-Norwegian with Sami'] = {
	"name" : "ms-Norwegian with Sami",
	"lang" : ["no"],
	"normal" : [
		"| 1 2 3 4 5 6 7 8 9 0 + \\ {bksp}",
		"{tab} q w e r t y u i o p \u00e5 \u00a8 '",
		"a s d f g h j k l \u00f8 \u00e6 {enter}",
		"{shift} < z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00a7 ! \" # \u00a4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00c5 ^ *",
		"A S D F G H J K L \u00d8 \u00c6 {enter}",
		"{shift} > Z X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00a3 $ \u20ac {empty} { [ ] } {empty} \u00b4 {bksp}",
		"{tab} \u00e2 {empty} \u20ac {empty} \u0167 {empty} {empty} \u00ef \u00f5 {empty} {empty} ~ {empty}",
		"\u00e1 \u0161 \u0111 \u01e5 \u01e7 \u021f {empty} \u01e9 {empty} \u00f6 \u00e4 {enter}",
		"{shift} {empty} \u017e {empty} \u010d \u01ef \u0292 \u014b \u00b5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} \u00c2 {empty} {empty} {empty} \u0166 {empty} {empty} \u00cf \u00d5 {empty} {empty} {empty} {empty}",
		"\u00c1 \u0160 \u0110 \u01e4 \u01e6 \u021e {empty} \u01e8 {empty} \u00d6 \u00c4 {enter}",
		"{shift} {empty} \u017d {empty} \u010c \u01ee \u01b7 \u014a {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Oriya Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinori.html
 */
jQuery.keyboard.layouts['ms-Oriya'] = {
	"name" : "ms-Oriya",
	"lang" : ["or"],
	"normal" : [
		"1 2 3 4 5 6 7 8 9 0 0 \u0b43 {bksp}",
		"{tab} \u0b4c \u0b48 \u0b3e \u0b40 \u0b42 \u0b2c \u0b39 \u0b17 \u0b26 \u0b1c \u0b21 \u0b3c",
		"\u0b4b \u0b47 \u0b4d \u0b3f \u0b41 \u0b2a \u0b30 \u0b15 \u0b24 \u0b1a \u0b1f {enter}",
		"{shift} \u0b5f \u0b02 \u0b2e \u0b28 \u0b2c \u0b32 \u0b38 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"{empty} {empty} \u0b4d\u0b30 \u0b30\u0b4d \u0b1c\u0b4d\u0b1e \u0b24\u0b4d\u0b30 \u0b15\u0b4d\u0b37 \u0b36\u0b4d\u0b30 ( ) \u0b03 \u0b0b {bksp}",
		"{tab} \u0b14 \u0b10 \u0b06 \u0b08 \u0b0a \u0b2d \u0b19 \u0b18 \u0b27 \u0b1d \u0b22 \u0b1e",
		"\u0b13 \u0b0f \u0b05 \u0b07 \u0b09 \u0b2b {empty} \u0b16 \u0b25 \u0b1b \u0b20 {enter}",
		"{shift} \u0b71 \u0b01 \u0b23 {empty} {empty} \u0b33 \u0b36 \u0b37 {empty} / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u0b67 \u0b68 \u0b69 \u0b6a \u0b6b \u0b6c \u0b6d \u0b6e \u0b6f \u0b66 {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0b5c {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0b60 {bksp}",
		"{tab} {empty} {empty} {empty} \u0b61 {empty} {empty} {empty} {empty} {empty} {empty} \u0b5d {empty}",
		"{empty} {empty} {empty} \u0b0c {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0b3d {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Pashto (Afghanistan) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdpash.html
 */
jQuery.keyboard.layouts['ms-Pashto (Afghanistan)'] = {
	"name" : "ms-Pashto (Afghanistan)",
	"lang" : ["ps"],
	"normal" : [
		"{ZWJ} \u06f1 \u06f2 \u06f3 \u06f4 \u06f5 \u06f6 \u06f7 \u06f8 \u06f9 \u06f0 - = {bksp}",
		"{tab} \u0636 \u0635 \u062b \u0642 \u0641 \u063a \u0639 \u0647 \u062e \u062d \u062c \u0686 \\",
		"\u0634 \u0633 \u06cc \u0628 \u0644 \u0627 \u062a \u0646 \u0645 \u06a9 \u06ab {enter}",
		"{shift} \u0638 \u0637 \u0632 \u0631 \u0630 \u062f \u0693 \u0648 \u0696 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0654 ! \u066c \u066b \u060b \u066a \u00d7 \u00bb \u00ab ) ( \u0640 + {bksp}",
		"{tab} \u0652 \u064c \u064d \u064b \u064f \u0650 \u064e \u0651 \u0681 \u0685 ] [ *",
		"\u069a \u06cd \u064a \u067e \u0623 \u0622 \u067c \u06bc \u0629 : \u061b {enter}",
		"{shift} \u0626 \u06d0 \u0698 \u0621 {ZWNJ} \u0689 \u0624 \u060c . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` ~ @ # $ % ^ & \u066d \u2022 \u00b0 _ \u00f7 {bksp}",
		"{tab} \u20ac \u0671 \u0649 {LRM} {RLM} \u0653 \u0659 \u0670 ' \" } { |",
		"{empty} {empty} \u06d2 \u06ba \u06b7 \u0625 \u0679 > < \u0643 \u06af {enter}",
		"{shift} ? ; {empty} {empty} {empty} \u0688 \u0691 , \u06c7 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Persian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdfa.html
 */
jQuery.keyboard.layouts['ms-Persian'] = {
	"name" : "ms-Persian",
	"lang" : ["fa"],
	"normal" : [
		"\u00f7 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0636 \u0635 \u062b \u0642 \u0641 \u063a \u0639 \u0647 \u062e \u062d \u062c \u0686 \u067e",
		"\u0634 \u0633 \u06cc \u0628 \u0644 \u0627 \u062a \u0646 \u0645 \u06a9 \u06af {enter}",
		"{shift} \u067e \u0638 \u0637 \u0632 \u0631 \u0630 \u062f \u0626 \u0648 . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u00d7 ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} \u064b \u064c \u064d \u0631\u064a\u0627\u0644 \u060c \u061b , ] [ \\ } { |",
		"\u064e \u064f \u0650 \u0651 \u06c0 \u0622 \u0640 \u00ab \u00bb : \" {enter}",
		"{shift} | \u0629 \u064a \u0698 \u0624 \u0625 \u0623 \u0621 < > / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Polish (214) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdpl.html
 */
jQuery.keyboard.layouts['ms-Polish (214)'] = {
	"name" : "ms-Polish (214)",
	"lang" : ["pl"],
	"normal" : [
		"\u02DB 1 2 3 4 5 6 7 8 9 0 + ' {bksp}",
		"{tab} q w e r t z u i o p \u017C \u015B",
		"a s d f g h j k l \u0142 \u0105 \u00F3 {enter}",
		"{shift} < y x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B7 ! \" # \u00A4 % & / ( ) = ? * {bksp}",
		"{tab} Q W E R T Z U I O P \u0144 \u0107",
		"A S D F G H J K L \u0141 \u0119 \u017A {enter}",
		"{shift} > Y X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02C7 ^ \u02D8 \u00B0 \u02DB ` \u00B7 \u00B4 \u02DD \u00A8 \u00B8 {bksp}",
		"{tab} \\ \u00A6 {empty} {empty} {empty} {empty} \u20AC {empty} {empty} {empty} \u00F7 \u00D7",
		"{empty} \u0111 \u0110 {empty} {empty} {empty} {empty} {empty} {empty} $ \u00DF {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} @ { } \u00A7 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Polish (Programmers) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdpl1.html
 */
jQuery.keyboard.layouts['ms-Polish (Programmers)'] = {
	"name" : "ms-Polish (Programmers)",
	"lang" : ["pl"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ]",
		"a s d f g h j k l ; ' \\ {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { }",
		"A S D F G H J K L : \" | {enter}",
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u0119 {empty} {empty} {empty} \u20AC {empty} \u00F3 {empty} {empty} {empty}",
		"\u0105 \u015B {empty} {empty} {empty} {empty} {empty} {empty} \u0142 {empty} {empty} {empty} {enter}",
		"{shift} \u017C \u017A \u0107 {empty} {empty} \u0144 {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u0118 {empty} {empty} {empty} {empty} {empty} \u00D3 {empty} {empty} {empty}",
		"\u0104 \u015A {empty} {empty} {empty} {empty} {empty} {empty} \u0141 {empty} {empty} {empty} {enter}",
		"{shift} \u017B \u0179 \u0106 {empty} {empty} \u0143 {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Portuguese Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdpo.html
 */
jQuery.keyboard.layouts['ms-Portuguese'] = {
	"name" : "ms-Portuguese",
	"lang" : ["pt"],
	"normal" : [
		"\\ 1 2 3 4 5 6 7 8 9 0 ' \u00AB {bksp}",
		"{tab} q w e r t y u i o p + \u00B4",
		"a s d f g h j k l \u00E7 \u00BA ~ {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"| ! \" # $ % & / ( ) = ? \u00BB {bksp}",
		"{tab} Q W E R T Y U I O P * `",
		"A S D F G H J K L \u00C7 \u00AA ^ {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00A3 \u00A7 \u20AC {empty} { [ ] } {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00A8 ]",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Portuguese (Brazilian ABNT) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdbr.html
 */
jQuery.keyboard.layouts['ms-Portuguese (Brazilian ABNT)'] = {
	"name" : "ms-Portuguese (Brazilian ABNT)",
	"lang" : ["pt"],
	"normal" : [
		"' 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p \u00B4 [",
		"a s d f g h j k l \u00E7 ~ ] {enter}",
		"{shift} \\ z x c v b n m , . ; / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\" ! @ # $ % \u00A8 & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P ` {",
		"A S D F G H J K L \u00C7 ^ } {enter}",
		"{shift} | Z X C V B N M < > : ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00B9 \u00B2 \u00B3 \u00A3 \u00A2 \u00AC {empty} {empty} {empty} {empty} {empty} \u00A7 {bksp}",
		"{tab} / ? \u00B0 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00AA",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00BA {enter}",
		"{shift} {empty} {empty} {empty} \u20A2 {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00B0 {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Punjabi Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdinpun.html
 */
jQuery.keyboard.layouts['ms-Punjabi'] = {
	"name" : "ms-Punjabi",
	"lang" : ["pa"],
	"normal" : [
		"{empty} 1 2 3 4 5 6 7 8 9 0 - {empty} {bksp}",
		"{tab} \u0a4c \u0a48 \u0a3e \u0a40 \u0a42 \u0a2c \u0a39 \u0a17 \u0a26 \u0a1c \u0a21 \u0a3c",
		"\u0a4b \u0a47 \u0a4d \u0a3f \u0a41 \u0a2a \u0a30 \u0a15 \u0a24 \u0a1a \u0a1f {enter}",
		"{shift} \u0a70 \u0a2e \u0a28 \u0a35 \u0a32 \u0a38 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0a4d\u0a39 \u0a4d\u0a35 \u0a4d\u0a2f \u0a4d\u0a30 \u0a71 {empty} {empty} {empty} {empty} ( ) {empty} {empty} {bksp}",
		"{tab} \u0a14 \u0a10 \u0a06 \u0a08 \u0a0a \u0a2d \u0a19 \u0a18 \u0a27 \u0a1d \u0a22 \u0a1e",
		"\u0a13 \u0a0f \u0a05 \u0a07 \u0a09 \u0a2b \u0a5c \u0a16 \u0a25 \u0a1b \u0a20 {enter}",
		"{shift} \u0a02 \u0a23 {empty} \u0a72 \u0a33 \u0a36 {empty} \u0964 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u0a67 \u0a68 \u0a69 \u0a6a \u0a6b \u0a6c \u0a6d \u0a6e \u0a6f \u0a66 {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0a5a {empty} \u0a5b \u0a5c {empty}",
		"{empty} {empty} {empty} {empty} {empty} \u0a5e {empty} \u0a59 {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} \u0a73 {empty} {empty} {empty} \u0965 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} \u0a74 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Romanian (Legacy) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdro.html
 */
jQuery.keyboard.layouts['ms-Romanian (Legacy)'] = {
	"name" : "ms-Romanian (Legacy)",
	"lang" : ["ro"],
	"normal" : [
		"] 1 2 3 4 5 6 7 8 9 0 + ' {bksp}",
		"{tab} q w e r t z u i o p \u0103 \u00ee \u00e2",
		"a s d f g h j k l \u015f \u0163 {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"[ ! \" # \u00a4 % & / ( ) = ? * {bksp}",
		"{tab} Q W E R T Z U I O P \u0102 \u00ce \u00c2",
		"A S D F G H J K L \u015e \u0162 {enter}",
		"{shift} > Y X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u00b7 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \\ | {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 \u00d7 {empty}",
		"{empty} \u0111 \u0110 {empty} {empty} {empty} {empty} \u0142 \u0141 $ \u00df {enter}",
		"{shift} \u001c {empty} {empty} {empty} @ { } \u00a7 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Romanian (Programmers) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdropr.html
 */
jQuery.keyboard.layouts['ms-Romanian (Programmers)'] = {
	"name" : "ms-Romanian (Programmers)",
	"lang" : ["ro"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \u00e2 \u00df \u20ac {empty} \u021b {empty} {empty} \u00ee {empty} \u00a7 \u201e \u201d {empty}",
		"\u0103 \u0219 \u0111 {empty} {empty} {empty} {empty} {empty} \u0142 {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} \u00a9 {empty} {empty} {empty} {empty} \u00ab \u00bb {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u2013 \u00b1 {bksp}",
		"{tab} \u00c2 {empty} {empty} {empty} \u021a {empty} {empty} \u00ce {empty} {empty} {empty} {empty} {empty}",
		"\u0102 \u0218 \u0110 {empty} {empty} {empty} {empty} {empty} \u0141 {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Romanian (Standard) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdrost.html
 */
jQuery.keyboard.layouts['ms-Romanian (Standard)'] = {
	"name" : "ms-Romanian (Standard)",
	"lang" : ["ro"],
	"normal" : [
		"\u201e 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p \u0103 \u00ee \u00e2",
		"a s d f g h j k l \u0219 \u021b {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u201d ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P \u0102 \u00ce \u00c2",
		"A S D F G H J K L \u0218 \u021a {enter}",
		"{shift} | Z X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} \u00a7 [ ] \\",
		"{empty} \u00df \u0111 {empty} {empty} {empty} {empty} {empty} \u0142 ; ' {enter}",
		"{shift} {empty} {empty} {empty} \u00a9 {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u2013 \u00b1 {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } |",
		"{empty} {empty} \u0110 {empty} {empty} {empty} {empty} {empty} \u0141 : \" {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00ab \u00bb {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Russian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdru.html
 */
jQuery.keyboard.layouts['ms-Russian'] = {
	"name" : "ms-Russian",
	"lang" : ["ru"],
	"normal" : [
		"\u0451 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u0449 \u0437 \u0445 \u044a \\",
		"\u0444 \u044b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} \\ \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0401 ! \" \u2116 ; % : ? * ( ) _ + {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u0429 \u0417 \u0425 \u042a /",
		"\u0424 \u042b \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} / \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Russian (Typewriter) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdru1.html
 */
jQuery.keyboard.layouts['ms-Russian (Typewriter)'] = {
	"name" : "ms-Russian (Typewriter)",
	"lang" : ["ru"],
	"normal" : [
		"| \u2116 - / \" : , . _ ? % ! ; {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u0449 \u0437 \u0445 \u044a )",
		"\u0444 \u044b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} ) \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"+ 1 2 3 4 5 6 7 8 9 0 = \\ {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u0429 \u0417 \u0425 \u042a (",
		"\u0424 \u042b \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} ( \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Sami Extended Finland-Sweden Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsmsfi.html
 */
jQuery.keyboard.layouts['ms-Sami Extended Finland-Sweden'] = {
	"name" : "ms-Sami Extended Finland-Sweden",
	"lang" : ["se"],
	"normal" : [
		"\u00a7 1 2 3 4 5 6 7 8 9 0 + \u00b4 {bksp}",
		"{tab} \u00e1 \u0161 e r t \u0167 u i o p \u00e5 \u014b \u0111",
		"a s d f g h j k l \u00f6 \u00e4 {enter}",
		"{shift} \u017e z \u010d c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00bd ! \" # \u00a4 % & / ( ) = ? ` {bksp}",
		"{tab} \u00c1 \u0160 E R T \u0166 U I O P \u00c5 \u014a \u0110",
		"A S D F G H J K L \u00d6 \u00c4 {enter}",
		"{shift} \u017d Z \u010c C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"| {empty} @ \u00a3 $ \u20ac {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} q w \u20ac {empty} {empty} y {empty} \u00ef \u00f5 {empty} \u00a8 ~ '",
		"\u00e2 {empty} {empty} {empty} \u01e7 \u01e5 {empty} \u01e9 {empty} \u00f8 \u00e6 {enter}",
		"{shift} \u01ef \u0292 x {empty} {empty} {empty} {empty} \u00b5 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} Q W {empty} {empty} {empty} Y {empty} \u00cf \u00d5 {empty} ^ \u02c7 *",
		"\u00c2 {empty} {empty} {empty} \u01e6 \u01e4 {empty} \u01e8 {empty} \u00d8 \u00c6 {enter}",
		"{shift} \u01ee \u01b7 X {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Sami Extended Norway Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsmsno.html
 */
jQuery.keyboard.layouts['ms-Sami Extended Norway'] = {
	"name" : "ms-Sami Extended Norway",
	"lang" : ["se"],
	"normal" : [
		"| 1 2 3 4 5 6 7 8 9 0 + \\ {bksp}",
		"{tab} \u00e1 \u0161 e r t \u0167 u i o p \u00e5 \u014b \u0111",
		"a s d f g h j k l \u00f8 \u00e6 {enter}",
		"{shift} \u017e z \u010d c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00a7 ! \" # \u00a4 % & / ( ) = ? ` {bksp}",
		"{tab} \u00c1 \u0160 E R T \u0166 U I O P \u00c5 \u014a \u0110",
		"A S D F G H J K L \u00d8 \u00c6 {enter}",
		"{shift} \u017d Z \u010c C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00a3 $ \u20ac {empty} { [ ] } {empty} \u00b4 {bksp}",
		"{tab} q w \u20ac {empty} {empty} y {empty} \u00ef \u00f5 {empty} \u00a8 ~ '",
		"\u00e2 {empty} {empty} {empty} \u01e7 \u01e5 {empty} \u01e9 {empty} \u00f6 \u00e4 {enter}",
		"{shift} \u01ef \u0292 x {empty} {empty} {empty} {empty} \u00b5 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} Q W {empty} {empty} {empty} Y {empty} \u00cf \u00d5 {empty} ^ \u02c7 *",
		"\u00c2 {empty} {empty} {empty} \u01e6 \u01e4 {empty} \u01e8 {empty} \u00d6 \u00c4 {enter}",
		"{shift} \u01ee \u01b7 X {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Serbian (Latin) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdycl.html
 */
jQuery.keyboard.layouts['ms-Serbian (Latin)'] = {
	"name" : "ms-Serbian (Latin)",
	"lang" : ["sr"],
	"normal" : [
		"\u201a 1 2 3 4 5 6 7 8 9 0 ' + {bksp}",
		"{tab} q w e r t z u i o p \u0161 \u0111 \u017e",
		"a s d f g h j k l \u010d \u0107 {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! \" # $ % & / ( ) = ? * {bksp}",
		"{tab} Q W E R T Z U I O P \u0160 \u0110 \u017d",
		"A S D F G H J K L \u010c \u0106 {enter}",
		"{shift} > Y X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \\ | \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 \u00d7 \u00a4",
		"{empty} {empty} {empty} [ ] {empty} {empty} \u0142 \u0141 {empty} \u00df {enter}",
		"{shift} {empty} {empty} {empty} {empty} @ { } \u00a7 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Serbian (Cyrillic) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdycc.html
 */
jQuery.keyboard.layouts['ms-Serbian (Cyrillic)'] = {
	"name" : "ms-erbian (Cyrillic)",
	"lang" : ["sr"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 ' + {bksp}",
		"{tab} \u0459 \u045a \u0435 \u0440 \u0442 \u0437 \u0443 \u0438 \u043e \u043f \u0448 \u0452 \u0436",
		"\u0430 \u0441 \u0434 \u0444 \u0433 \u0445 \u0458 \u043a \u043b \u0447 \u045b {enter}",
		"{shift} < \u0455 \u045f \u0446 \u0432 \u0431 \u043d \u043c , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! \" # $ % & / ( ) = ? * {bksp}",
		"{tab} \u0409 \u040a \u0415 \u0420 \u0422 \u0417 \u0423 \u0418 \u041e \u041f \u0428 \u0402 \u0416",
		"\u0410 \u0421 \u0414 \u0424 \u0413 \u0425 \u0408 \u041a \u041b \u0427 \u040b {enter}",
		"{shift} > \u0405 \u040f \u0426 \u0412 \u0411 \u041d \u041c ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Setswana Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdnso.html
 */
jQuery.keyboard.layouts['ms-Setswana'] = {
	"name" : "ms-Setswana",
	"lang" : ["tn"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \\ z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00a1 \u00b2 \u00b3 \u00a4 \u20ac \u00bc \u00bd \u00be \u2018 \u2019 \u00a5 \u00d7 {bksp}",
		"{tab} \u00e4 \u00e5 \u00e9 \u00ae \u00fe \u00fc \u00fa \u00ed \u00f3 \u00f6 \u00ab \u00bb \u00ac",
		"\u00e1 \u00df \u00f0 {empty} {empty} {empty} {empty} {empty} \u00f8 \u00b6 \u00b4 {enter}",
		"{shift} {empty} \u00e6 {empty} \u00a9 {empty} {empty} \u00f1 \u00b5 \u00e7 \u0161 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} \u00b9 {empty} {empty} \u00a3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 {bksp}",
		"{tab} \u00c4 \u00c5 \u00c9 {empty} \u00de \u00dc \u00da \u00cd \u00d3 \u00d6 {empty} {empty} \u00a6",
		"\u00c1 \u00a7 \u00d0 {empty} {empty} {empty} {empty} {empty} \u00d8 \u00b0 \u00a8 {enter}",
		"{shift} {empty} \u00c6 {empty} \u00a2 {empty} {empty} \u00d1 {empty} \u00c7 \u0160 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};


/* Setswana Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdnso1.html
 */
jQuery.keyboard.layouts['ms-Setswana (Sesotho sa Leboa)'] = {
	"name" : "ms-Setswana (Sesotho sa Leboa)",
	"lang" : ["tn"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \\",
		"a s d f g h j k l ; ' {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \" {enter}",
		"{shift} Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00a1 \u00b2 \u00b3 \u00a4 \u20ac \u00bc \u00bd \u00be \u2018 \u2019 \u00a5 \u00d7 {bksp}",
		"{tab} \u00e4 \u00e5 \u00e9 \u00ae \u00fe \u00fc \u00fa \u00ed \u00f3 \u00f6 \u00ab \u00bb \u00ac",
		"\u00e1 \u00df \u00f0 {empty} {empty} {empty} {empty} {empty} \u00f8 \u00b6 \u00b4 {enter}",
		"{shift} \u00e6 {empty} \u00a9 {empty} {empty} \u00f1 \u00b5 \u00e7 \u0161 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} \u00b9 {empty} {empty} \u00a3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 {bksp}",
		"{tab} \u00c4 \u00c5 \u00c9 {empty} \u00de \u00dc \u00da \u00cd \u00d3 \u00d6 {empty} {empty} \u00a6",
		"\u00c1 \u00a7 \u00d0 {empty} {empty} {empty} {empty} {empty} \u00d8 \u00b0 \u00a8 {enter}",
		"{shift} \u00c6 {empty} \u00a2 {empty} {empty} \u00d1 {empty} \u00c7 \u0160 {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Sinhala Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsn1.html
 */
jQuery.keyboard.layouts['ms-Sinhala'] = {
	"name" : "ms-Sinhala",
	"lang" : ["si"],
	"normal" : [
		"\u0dca{ZWJ}\u0dbb 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0dd4 \u0d85 \u0dd0 \u0dbb \u0d92 \u0dc4 \u0db8 \u0dc3 \u0daf \u0da0 \u0da4 ; {ZWJ}",
		"\u0dca \u0dd2 \u0dcf \u0dd9 \u0da7 \u0dba \u0dc0 \u0db1 \u0d9a \u0dad . {enter}",
		"{shift} {ZWJ} ' \u0d82 \u0da2 \u0da9 \u0d89 \u0db6 \u0db4 \u0dbd \u0d9c / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0dbb\u0dca{ZWJ} ! @ $ $ % ^ & * ( ) _ + {bksp}",
		"{tab} \u0dd6 \u0d8b \u0dd1 \u0d8d \u0d94 \u0dc1 \u0db9 \u0dc2 \u0db0 \u0da1 \u0da5 : {empty}",
		"\u0ddf \u0dd3 \u0dd8 \u0dc6 \u0da8 \u0dca{ZWJ}\u0dba \u0dc5\u0dd4 \u0dab \u0d9b \u0dae , {enter}",
		"{shift} {empty} \" \u0d83 \u0da3 \u0daa \u0d8a \u0db7 \u0db5 \u0dc5 \u0d9d / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"\u0df3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0df4 {enter}",
		"{shift} {empty} {empty} \u0d9e \u0da6 \u0dac {empty} {empty} {empty} \u0d8f \u0d9f {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Sinhala - Wij 9 Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsw09.html
 */
jQuery.keyboard.layouts['ms-Sinhala - Wij 9'] = {
	"name" : "ms-Sinhala - Wij 9",
	"lang" : ["si"],
	"normal" : [
		"\u0dca{ZWJ}\u0dbb 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0dd4 \u0d85 \u0dd0 \u0dbb \u0d91 \u0dc4 \u0db8 \u0dc3 \u0daf \u0da0 \u0da4 ; \u0dca{ZWJ}",
		"\u0dca \u0dd2 \u0dcf \u0dd9 \u0da7 \u0dba \u0dc0 \u0db1 \u0d9a \u0dad . {enter}",
		"{shift} ' \u0d82 \u0da2 \u0da9 \u0d89 \u0db6 \u0db4 \u0dbd \u0d9c / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0dbb\u0dca{ZWJ} ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} \u0dd6 \u0d8b \u0dd1 \u0d8d \u0d94 \u0dc1 \u0db9 \u0dc2 \u0db0 \u0da1 \u0da5 : {empty}",
		"\u0ddf \u0dd3 \u0dd8 \u0dc6 \u0da8 \u0dca{ZWJ}\u0dba \u0dc5\u0dd4 \u0dab \u0d9b \u0dae , {enter}",
		"{shift} \" \u0d83 \u0da3 \u0daa \u0d8a \u0db7 \u0db5 \u0dc5 \u0d9d / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` \u00a1 \u00b2 \u00b3 \u00a4 \u20ac \u00bc \u00bd \u00be \u2018 \u2019 \u00a5 \u00d7 {bksp}",
		"{tab} \u0dde \u0ddc \u0ddb \u0dda {empty} {empty} {empty} {empty} \u0db3 {empty} [ ] \\",
		"\u0df3 \u0ddd {empty} {empty} {empty} {empty} {ZWJ} {empty} {empty} {empty} \u0df4 {enter}",
		"{shift} {empty} \u0d9e \u0da6 \u0dac {empty} {ZWNJ} {empty} \u0d8f \u0d9f {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ \u00b9 {empty} {empty} \u00a3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } |",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Slovak Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsl.html
 */
jQuery.keyboard.layouts['ms-Slovak'] = {
	"name" : "ms-Slovak",
	"lang" : ["sk"],
	"normal" : [
		"; + \u013e \u0161 \u010d \u0165 \u017e \u00fd \u00e1 \u00ed \u00e9 = \u00b4 {bksp}",
		"{tab} q w e r t z u i o p \u00fa \u00e4 \u0148",
		"a s d f g h j k l \u00f4 \u00a7 {enter}",
		"{shift} & y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 1 2 3 4 5 6 7 8 9 0 % \u02c7 {bksp}",
		"{tab} Q W E R T Z U I O P / ( )",
		"A S D F G H J K L \" ! {enter}",
		"{shift} * Y X C V B N M ? : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \\ | \u20ac {empty} {empty} {empty} {empty} {empty} {empty} ' \u00f7 \u00d7 \u00a4",
		"{empty} \u0111 \u0110 [ ] {empty} {empty} \u0142 \u0141 $ \u00df {enter}",
		"{shift} < > # & @ { } {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Slovak (QWERTY) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsl1.html
 */
jQuery.keyboard.layouts['ms-Slovak (QWERTY)'] = {
	"name" : "ms-Slovak (QWERTY)",
	"lang" : ["sk"],
	"normal" : [
		"; + \u013e \u0161 \u010d \u0165 \u017e \u00fd \u00e1 \u00ed \u00e9 = \u00b4 {bksp}",
		"{tab} q w e r t y u i o p \u00fa \u00e4 \u0148",
		"a s d f g h j k l \u00f4 \u00a7 {enter}",
		"{shift} & z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 1 2 3 4 5 6 7 8 9 0 % \u02c7 {bksp}",
		"{tab} Q W E R T Y U I O P / ( )",
		"A S D F G H J K L \" ! {enter}",
		"{shift} * Z X C V B N M ? : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \\ | \u20ac {empty} {empty} {empty} {empty} {empty} {empty} ' \u00f7 \u00d7 \u00a4",
		"{empty} \u0111 \u0110 [ ] {empty} {empty} \u0142 \u0141 $ \u00df {enter}",
		"{shift} < > # & @ { } {empty} < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Slovenian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdcr.html
 */
jQuery.keyboard.layouts['ms-Slovenian'] = {
	"name" : "ms-Slovenian",
	"lang" : ["sl"],
	"normal" : [
		"\u00b8 1 2 3 4 5 6 7 8 9 0 ' + {bksp}",
		"{tab} q w e r t z u i o p \u0161 \u0111 \u017e",
		"a s d f g h j k l \u010d \u0107 {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00a8 ! \" # $ % & / ( ) = ? * {bksp}",
		"{tab} Q W E R T Z U I O P \u0160 \u0110 \u017d",
		"A S D F G H J K L \u010c \u0106 {enter}",
		"{shift} > Y X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} ~ \u02c7 ^ \u02d8 \u00b0 \u02db ` \u02d9 \u00b4 \u02dd \u00a8 \u00b8 {bksp}",
		"{tab} \\ | \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00f7 \u00d7 \u00a4",
		"{empty} {empty} {empty} [ ] {empty} {empty} \u0142 \u0141 {empty} \u00df {enter}",
		"{shift} {empty} {empty} {empty} {empty} @ { } \u00a7 < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Sorbian Standard Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsors1.html
 */
jQuery.keyboard.layouts['ms-Sorbian Standard'] = {
	"name" : "ms-Sorbian Standard",
	"lang" : ["wen", "dsb", "hsb"],
	"normal" : [
		"^ 1 2 3 4 5 6 7 8 9 0 \u00df \u00b4 {bksp}",
		"{tab} q w e r t z u i o p \u00fc + #",
		"a s d f g h j k l \u00f6 \u00e4 {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 ! \" \u00a7 $ % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Z U I O P \u00dc * '",
		"A S D F G H J K L \u00d6 \u00c4 {enter}",
		"{shift} > Y X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} \u00b2 \u00b3 {empty} {empty} {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} @ {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~ {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} \u00b5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Sorbian Extended Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsorex.html
 */
jQuery.keyboard.layouts['ms-Sorbian Extended'] = {
	"name" : "ms-Sorbian Extended",
	"lang" : ["wen", "dsb", "hsb"],
	"normal" : [
		"^ 1 2 3 4 5 6 7 8 9 0 \u00df \u00b4 {bksp}",
		"{tab} q w e r t z u i o p \u00fc + \u0142",
		"a s d f g h j k l \u00f6 \u00e4 {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 ! \" \u00a7 $ % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Z U I O P \u00dc * \u0141",
		"A S D F G H J K L \u00d6 \u00c4 {enter}",
		"{shift} > Y X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00bb \u00ab \u201e \u201a \u2018 \u201c { [ ] } \\ {empty} {bksp}",
		"{tab} @ {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~ #",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Sorbian Standard (Legacy) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsorst.html
 */
jQuery.keyboard.layouts['ms-Sorbian Standard (Legacy)'] = {
	"name" : "ms-Sorbian Standard (Legacy)",
	"lang" : ["wen", "dsb", "hsb"],
	"normal" : [
		"^ 1 2 3 4 5 6 7 8 9 0 \u00df \u00b4 {bksp}",
		"{tab} q w e r t z u i o p \u00fc + \u0142",
		"a s d f g h j k l \u00f6 \u00e4 {enter}",
		"{shift} < y x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00b0 ! \" \u00a7 $ % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Z U I O P \u00dc * \u0141",
		"A S D F G H J K L \u00d6 \u00c4 {enter}",
		"{shift} > Y X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00bb \u00ab \u201e \u201a \u2018 \u201c { [ ] } \\ {empty} {bksp}",
		"{tab} @ {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~ #",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} \u00b5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Spanish Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsp.html
 */
jQuery.keyboard.layouts['ms-Spanish'] = {
	"name" : "ms-Spanish",
	"lang" : ["es"],
	"normal" : [
		"\u00BA 1 2 3 4 5 6 7 8 9 0 ' \u00A1 {bksp}",
		"{tab} q w e r t y u i o p ` +",
		"a s d f g h j k l \u00F1 \u00B4 \u00E7 {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00AA ! \" \u00B7 $ % & / ( ) = ? \u00BF {bksp}",
		"{tab} Q W E R T Y U I O P ^ *",
		"A S D F G H J K L \u00D1 \u00A8 \u00C7 {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\\ | @ # ~ \u20AC \u00AC {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ]",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Spanish Variation Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdes.html
 */
jQuery.keyboard.layouts['ms-Spanish Variation'] = {
	"name" : "ms-Spanish Variation",
	"lang" : ["es"],
	"normal" : [
		"' 1 2 3 4 5 6 7 8 9 0 - \u00A8 {bksp}",
		"{tab} q w e r t y u i o p \u00F7 `",
		"a s d f g h j k l \u00F1 \u00E7 \u00B4 {enter}",
		"{shift} < z x c v b n m , . = {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B7 \u00AA \" / ( ) \u00A1 ! \u00BF ? \u20A7 + \u00A8 {bksp}",
		"{tab} Q W E R T Y U I O P \u00D7 `",
		"A S D F G H J K L \u00D1 \u00C7 \u00B4 {enter}",
		"{shift} > Z X C V B N M ; : % {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\\ | @ # \u00BC \u00BD \u00AC _ # \u00A7 \\ * ~ {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ]",
		"$ & @ [ ] | \u00A3 \u00B1 {empty} ~ { } {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ^ {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Swedish with Sami Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdfi1.html
 */
jQuery.keyboard.layouts['ms-Swedish with Sami'] = {
	"name" : "ms-Swedish with Sami",
	"lang" : ["sv", "se"],
	"normal" : [
		"\u00a7 1 2 3 4 5 6 7 8 9 0 + \u00b4 {bksp}",
		"{tab} q w e r t y u i o p \u00e5 \u00a8 '",
		"a s d f g h j k l \u00f6 \u00e4 {enter}",
		"{shift} < z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00bd ! \" # \u00a4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00c5 ^ *",
		"A S D F G H J K L \u00d6 \u00c4 {enter}",
		"{shift} > Z X C V B N M ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00a3 $ \u20ac {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} \u00e2 {empty} \u20ac {empty} \u0167 {empty} {empty} \u00ef \u00f5 {empty} {empty} ~ {empty}",
		"\u00e1 \u0161 \u0111 \u01e5 \u01e7 \u021f {empty} \u01e9 {empty} \u00f8 \u00e6 {enter}",
		"{shift} | \u017e {empty} \u010d \u01ef \u0292 \u014b \u00b5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} \u00c2 {empty} {empty} {empty} \u0166 {empty} {empty} \u00cf \u00d5 {empty} {empty} {empty} {empty}",
		"\u00c1 \u0160 \u0110 \u01e4 \u01e6 \u021e {empty} \u01e8 {empty} \u00d8 \u00c6 {enter}",
		"{shift} {empty} \u017d {empty} \u010c \u01ee \u01b7 \u014a {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Swedish Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsw.html
 */
jQuery.keyboard.layouts['ms-Swedish'] = {
	"name" : "ms-Swedish",
	"lang" : ["sv"],
	"normal" : [
		"\u00A7 1 2 3 4 5 6 7 8 9 0 + \u00B4 {bksp}",
		"{tab} q w e r t y u i o p \u00E5 \u00A8",
		"a s d f g h j k l \u00F6 \u00E4 ' {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00BD ! \" # \u00A4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00C5 ^",
		"A S D F G H J K L \u00D6 \u00C4 * {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00A3 $ \u20AC {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ~",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Swedish with Sami Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsw1.html
 */
jQuery.keyboard.layouts['ms-Swedish with Sami'] = {
	"name" : "ms-Swedish with Sami",
	"lang" : ["sv"],
	"normal" : [
		"\u00a7 1 2 3 4 5 6 7 8 9 0 + \u00B4 {bksp}",
		"{tab} q w e r t y u i o p \u00E5 \u00A8",
		"a s d f g h j k l \u00F6 \u00E4 ' {enter}",
		"{shift} < z x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00BD ! \" # \u00A4 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Y U I O P \u00C5 ^",
		"A S D F G H J K L \u00D6 \u00C4 * {enter}",
		"{shift} > Z X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} @ \u00A3 $ \u20AC {empty} { [ ] } \\ {empty} {bksp}",
		"{tab} \u00E2 {empty} \u20AC {empty} \u0167 {empty} {empty} \u00ef \u00f5 {empty} {empty} ~",
		"\u00E1 \u0161 \u0111 \u01e5 \u01E7 \u021F {empty} \u01e9 {empty} \u00F8 \u00E6 {empty} {enter}",
		"{shift} | \u017E {empty} \u010d \u01EF \u0292 \u014B \u00B5 {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} \u00C2 {empty} {empty} {empty} \u0166 {empty} {empty} \u00CF \u00D5 {empty} {empty} {empty}",
		"\u00C1 \u0160 \u0110 \u01E4 \u01E6 \u021e {empty} \u01E8 {empty} \u00D8 \u00C6 {empty} {enter}",
		"{shift} {empty} \u017D {empty} \u010C \u01EE \u01B7 \u014A {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Swiss German Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsg.html
 */
jQuery.keyboard.layouts['ms-Swiss German'] = {
	"name" : "ms-Swiss German",
	"lang" : ["de", "sv"],
	"normal" : [
		"\u00A7 1 2 3 4 5 6 7 8 9 0 ' ^ {bksp}",
		"{tab} q w e r t z u i o p \u00FC \u00A8",
		"a s d f g h j k l \u00F6 \u00E4 $ {enter}",
		"{shift} < y x c v b n m , . - {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00B0 + \" * \u00E7 % & / ( ) = ? ` {bksp}",
		"{tab} Q W E R T Z U I O P \u00E8 !",
		"A S D F G H J K L \u00E9 \u00E0 \u00A3 {enter}",
		"{shift} > Y X C V B N M ; : _ {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00A6 @ # \u00B0 \u00A7 \u00AC | \u00A2 {empty} {empty} \u00B4 ~ {bksp}",
		"{tab} {empty} {empty} \u20AC {empty} {empty} {empty} {empty} {empty} {empty} {empty} [ ]",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} { } {enter}",
		"{shift} \\ {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Syriac Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsyr1.html
 */
jQuery.keyboard.layouts['ms-Syriac'] = {
	"name" : "ms-Syriac",
	"lang" : ["syr"],
	"normal" : [
		"\u070f 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0714 \u0728 \u0716 \u0729 \u0726 \u071c \u0725 \u0717 \u071e \u071a \u0713 \u0715 \u0706",
		"\u072b \u0723 \u071d \u0712 \u0720 \u0710 \u072c \u0722 \u0721 \u071f \u071b {enter}",
		"{shift} \u0706 ] [ \u0724 \u072a \u0727 \u0700 . \u0718 \u0719 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u032e ! \u030a \u0325 \u0749 \u2670 \u2671 \u070a \u00bb ) ( \u00ab + {bksp}",
		"{tab} \u0730 \u0733 \u0736 \u073a \u073d \u0740 \u0741 \u0308 \u0304 \u0307 \u0303 \u074a :",
		"\u0731 \u0734 \u0737 \u073b \u073e \u0711 \u0640 \u0324 \u0331 \u0323 \u0330 {enter}",
		"{shift} : \u0732 \u0735 \u0738 \u073c \u073f \u0739 \u0742 \u060c \u061b / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u0651 \u0701 \u0702 \u0703 \u0704 \u0705 \u0708 \u0709 \u070b \u070c \u070d \u250c \u2510 {bksp}",
		"{tab} \u064e \u064b \u064f \u064c \u0653 \u0654 \u0747 \u0743 \u0745 \u032d {empty} {empty} {empty}",
		"\u0650 \u064d {empty} \u0621 \u0655 \u0670 \u0748 \u0744 \u0746 {empty} {empty} {enter}",
		"{shift} {empty} {empty} \u0652 {empty} {ZWJ} {ZWNJ} {LRM} {RLM} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Syriac Phonetic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdsyr2.html
 */
jQuery.keyboard.layouts['ms-Syriac Phonetic'] = {
	"name" : "ms-Syriac Phonetic",
	"lang" : ["syr"],
	"normal" : [
		"\u070f 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0729 \u0718 \u0716 \u072a \u072c \u071d \u071c \u0725 \u0727 \u0726 ] [ \u0706",
		"\u0710 \u0723 \u0715 \u0714 \u0713 \u0717 \u071b \u071f \u0720 \u071a \u071e {enter}",
		"{shift} \u0706 \u0719 \u0728 \u0724 \u072b \u0712 \u0722 \u0721 \u0700 . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u032e ! \u030a \u0325 \u0749 \u2670 \u2671 \u070a \u00bb ) ( \u00ab + {bksp}",
		"{tab} \u0730 \u0733 \u0736 \u073a \u073d \u0740 \u0741 \u0308 \u0304 \u0307 \u0303 \u074a :",
		"\u0731 \u0734 \u0737 \u073b \u073e \u0711 \u0640 \u0324 \u0331 \u0323 \u0330 {enter}",
		"{shift} : \u0732 \u0735 \u0738 \u073c \u073f \u0739 \u0742 \u060c \u061b / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u0651 \u0701 \u0702 \u0703 \u0704 \u0705 \u0708 \u0709 \u070b \u070c \u070d \u250c \u2510 {bksp}",
		"{tab} \u064e \u064b \u064f \u064c \u0653 \u0654 \u0747 \u0743 \u0745 \u032d {empty} {empty} {empty}",
		"\u0650 \u064d {empty} \u0621 \u0655 \u0670 \u0748 \u0744 \u0746 {empty} {empty} {enter}",
		"{shift} {empty} {empty} \u0652 {empty} {ZWJ} {ZWNJ} {LRM} {RLM} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Tajik Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdtajik.html
 */
jQuery.keyboard.layouts['ms-Tajik'] = {
	"name" : "ms-Tajik",
	"lang" : ["tg"],
	"normal" : [
		"\u0451 1 2 3 4 5 6 7 8 9 0 \u0493 \u04ef {bksp}",
		"{tab} \u0439 \u049b \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u04b3 \u0437 \u0445 \u044a \\",
		"\u0444 \u04b7 \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} \\ \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u04e3 \u0431 \u044e / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0401 ! \" \u2116 ; % : ? * ( ) \u0492 \u04ee {bksp}",
		"{tab} \u0419 \u049a \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u04b2 \u0417 \u0425 \u042a /",
		"\u0424 \u04b6 \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} / \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u04e2 \u0411 \u042e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Tamil Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdintam.html
 */
jQuery.keyboard.layouts['ms-Tamil'] = {
	"name" : "ms-Tamil",
	"lang" : ["ta"],
	"normal" : [
		"\u0bca 1 2 3 4 5 6 7 8 9 0 - {empty} {bksp}",
		"{tab} \u0bcc \u0bc8 \u0bbe \u0bc0 \u0bc2 \u0baa \u0bb9 \u0b95 \u0ba4 \u0b9c \u0b9f \u0b9e",
		"\u0bcb \u0bc7 \u0bcd \u0bbf \u0bc1 \u0baa \u0bb0 \u0b95 \u0ba4 \u0b9a \u0b9f {enter}",
		"{shift} \u0bc6 {empty} \u0bae \u0ba8 \u0bb5 \u0bb2 \u0bb8 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0b92 {empty} {empty} {empty} {empty} {empty} \u0ba4\u0bcd\u0bb0 \u0b95\u0bcd\u0bb7 \u0bb7\u0bcd\u0bb0 {empty} {empty} \u0b83 {empty} {bksp}",
		"{tab} \u0b94 \u0b90 \u0b86 \u0b88 \u0b8a \u0baa \u0b99 \u0b95 \u0ba4 \u0b9a \u0b9f \u0b9e",
		"\u0b93 \u0b8f \u0b85 \u0b87 \u0b89 \u0baa \u0bb1 \u0b95 \u0ba4 \u0b9a \u0b9f {enter}",
		"{shift} \u0b8e {empty} \u0ba3 \u0ba9 \u0bb4 \u0bb3 \u0bb7 \u0bb7 \u0bb8\u0bcd\u0bb0\u0bc0 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u0be7 \u0be8 \u0be9 \u0bea \u0beb \u0bec \u0bed \u0bee \u0bef \u0bf0 \u0bf1 \u0bf2 {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Tatar Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdtat.html
 */
jQuery.keyboard.layouts['ms-Tatar'] = {
	"name" : "ms-Tatar",
	"lang" : ["tt"],
	"normal" : [
		"\u04BB 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0439 \u04E9 \u0443 \u043A \u0435 \u043D \u0433 \u0448 \u04D9 \u0437 \u0445 \u04AF",
		"\u0444 \u044B \u0432 \u0430 \u043F \u0440 \u043E \u043B \u0434 \u04A3 \u044D \\ {enter}",
		"{shift} \u0491 \u044F \u0447 \u0441 \u043C \u0438 \u0442 \u0497 \u0431 \u044E . {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u04BA ! \" \u2116 ; % : ? * ( ) _ + {bksp}",
		"{tab} \u0419 \u04E8 \u0423 \u041A \u0415 \u041D \u0413 \u0428 \u04D8 \u0417 \u0425 \u04AE",
		"\u0424 \u042B \u0412 \u0410 \u041F \u0420 \u041E \u041B \u0414 \u04A2 \u042D / {enter}",
		"{shift} \u0490 \u042F \u0427 \u0421 \u041C \u0418 \u0422 \u0496 \u0411 \u042E , {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u0451 {empty} @ # $ {empty} {empty} [ ] { } {empty} {empty} {bksp}",
		"{tab} {empty} \u0446 {empty} {empty} {empty} {empty} {empty} {empty} \u0449 {empty} {empty} \u044A",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0436 ' {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u044C < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"\u0401 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} \u0426 {empty} {empty} {empty} {empty} {empty} {empty} \u0429 {empty} {empty} \u042A",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0416 {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u042C {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Telugu Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdintel.html
 */
jQuery.keyboard.layouts['ms-Telugu'] = {
	"name" : "ms-Telugu",
	"lang" : ["te"],
	"normal" : [
		"\u0c4a 1 2 3 4 5 6 7 8 9 0 - \u0c43 {bksp}",
		"{tab} \u0c4c \u0c48 \u0c3e \u0c40 \u0c42 \u0c2c \u0c39 \u0c17 \u0c26 \u0c1c \u0c21 {empty}",
		"\u0c4b \u0c47 \u0c4d \u0c3f \u0c41 \u0c2a \u0c30 \u0c15 \u0c24 \u0c1a \u0c1f {enter}",
		"{shift} \u0c46 \u0c02 \u0c2e \u0c28 \u0c35 \u0c32 \u0c38 , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0c12 {empty} {empty} \u0c4d\u0c30 {empty} \u0c1c\u0c4d\u0c1e \u0c24\u0c4d\u0c30 \u0c15\u0c4d\u0c37 \u0c36\u0c4d\u0c30 ( ) \u0c03 \u0c0b {bksp}",
		"{tab} \u0c14 \u0c10 \u0c06 \u0c08 \u0c0a \u0c2d \u0c19 \u0c18 \u0c27 \u0c1d \u0c22 \u0c1e",
		"\u0c13 \u0c0f \u0c05 \u0c07 \u0c09 \u0c2b \u0c31 \u0c16 \u0c25 \u0c1b \u0c20 {enter}",
		"{shift} \u0c0e \u0c01 \u0c23 \u0c28 {empty} \u0c33 \u0c36 \u0c37 {empty} / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u0c67 \u0c68 \u0c69 \u0c6a \u0c6b \u0c6c \u0c6d \u0c6e \u0c6f \u0c66 {empty} \u0c44 {bksp}",
		"{tab} {empty} \u0c56 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} \u0c55 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0c60 {bksp}",
		"{tab} {empty} {empty} {empty} \u0c61 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} \u0c0c {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Thai Kedmanee Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdth0.html
 */
jQuery.keyboard.layouts['ms-Thai Kedmanee'] = {
	"name" : "ms-Thai Kedmanee",
	"lang" : ["th"],
	"normal" : [
		"_ \u0E45 / - \u0E20 \u0E16 \u0E38 \u0E36 \u0E04 \u0E15 \u0E08 \u0E02 \u0E0A {bksp}",
		"{tab} \u0E46 \u0E44 \u0E33 \u0E1E \u0E30 \u0E31 \u0E35 \u0E23 \u0E19 \u0E22 \u0E1A \u0E25 \u0E03",
		"\u0E1F \u0E2B \u0E01 \u0E14 \u0E40 \u0E49 \u0E48 \u0E32 \u0E2A \u0E27 \u0E07 {enter}",
		"{shift} \u0E1C \u0E1B \u0E41 \u0E2D \u0E34 \u0E37 \u0E17 \u0E21 \u0E43 \u0E1D {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"% + \u0E51 \u0E52 \u0E53 \u0E54 \u0E39 \u0E3F \u0E55 \u0E56 \u0E57 \u0E58 \u0E59 {bksp}",
		"{tab} \u0E50 \u0022 \u0E0E \u0E11 \u0E18 \u0E4D \u0E4A \u0E13 \u0E2F \u0E0D \u0E10 , \u0E05",
		"\u0E24 \u0E06 \u0E0F \u0E42 \u0E0C \u0E47 \u0E4B \u0E29 \u0E28 \u0E0B . {enter}",
		"{shift} ( ) \u0E09 \u0E2E \u0E3A \u0E4C ? \u0E12 \u0E2C \u0E26 {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Thai Kedmanee (non-ShiftLock) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdth2.html
 */
jQuery.keyboard.layouts['ms-Thai Kedmanee (non-ShiftLock)'] = {
	"name" : "ms-Thai Kedmanee (non-ShiftLock)",
	"lang" : ["th"],
	"normal" : [
		"_ \u0E45 / - \u0E20 \u0E16 \u0E38 \u0E36 \u0E04 \u0E15 \u0E08 \u0E02 \u0E0A {bksp}",
		"{tab} \u0E46 \u0E44 \u0E33 \u0E1E \u0E30 \u0E31 \u0E35 \u0E23 \u0E19 \u0E22 \u0E1A \u0E25 \u0E03",
		"\u0E1F \u0E2B \u0E01 \u0E14 \u0E40 \u0E49 \u0E48 \u0E32 \u0E2A \u0E27 \u0E07 {enter}",
		"{shift} \u0E1C \u0E1B \u0E41 \u0E2D \u0E34 \u0E37 \u0E17 \u0E21 \u0E43 \u0E1D {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"% + \u0E51 \u0E52 \u0E53 \u0E54 \u0E39 \u0E3F \u0E55 \u0E56 \u0E57 \u0E58 \u0E59 {bksp}",
		"{tab} \u0E50 \u0022 \u0E0E \u0E11 \u0E18 \u0E4D \u0E4A \u0E13 \u0E2F \u0E0D \u0E10 , \u0E05",
		"\u0E24 \u0E06 \u0E0F \u0E42 \u0E0C \u0E47 \u0E4B \u0E29 \u0E28 \u0E0B . {enter}",
		"{shift} ( ) \u0E09 \u0E2E \u0E3A \u0E4C ? \u0E12 \u0E2C \u0E26 {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Thai Pattachote Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdth1.html
 */
jQuery.keyboard.layouts['ms-Thai Pattachote'] = {
	"name" : "ms-Thai Pattachote",
	"lang" : ["th"],
	"normal" : [
		"_ = \u0E52 \u0E53 \u0E54 \u0E55 \u0E39 \u0E57 \u0E58 \u0E59 \u0E50 \u0E51 \u0E56 {bksp}",
		"{tab} \u0E47 \u0E15 \u0E22 \u0E2D \u0E23 \u0E48 \u0E14 \u0E21 \u0E27 \u0E41 \u0E43 \u0E0C \uF8C7",
		"\u0E49 \u0E17 \u0E07 \u0E01 \u0E31 \u0E35 \u0E32 \u0E19 \u0E40 \u0E44 \u0E02 {enter}",
		"{shift} \u0E1A \u0E1B \u0E25 \u0E2B \u0E34 \u0E04 \u0E2A \u0E30 \u0E08 \u0E1E {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0E3F + \u0022 / , ? \u0E38 _ . ( ) - % {bksp}",
		"{tab} \u0E4A \u0E24 \u0E46 \u0E0D \u0E29 \u0E36 \u0E1D \u0E0B \u0E16 \u0E12 \u0E2F \u0E26 \u0E4D",
		"\u0E4B \u0E18 \u0E33 \u0E13 \u0E4C \u0E37 \u0E1C \u0E0A \u0E42 \u0E06 \u0E11 {enter}",
		"{shift} \u0E0E \u0E0F \u0E10 \u0E20 \u0E31 \u0E28 \u0E2E \u0E1F \u0E09 \u0E2C {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Thai Pattachote (non-ShiftLock) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdth3.html
 */
jQuery.keyboard.layouts['ms-Thai Pattachote (non-ShiftLock)'] = {
	"name" : "ms-Thai Pattachote (non-ShiftLock)",
	"lang" : ["th"],
	"normal" : [
		"_ = \u0E52 \u0E53 \u0E54 \u0E55 \u0E39 \u0E57 \u0E58 \u0E59 \u0E50 \u0E51 \u0E56 {bksp}",
		"{tab} \u0E47 \u0E15 \u0E22 \u0E2D \u0E23 \u0E48 \u0E14 \u0E21 \u0E27 \u0E41 \u0E43 \u0E0C \uF8C7",
		"\u0E49 \u0E17 \u0E07 \u0E01 \u0E31 \u0E35 \u0E32 \u0E19 \u0E40 \u0E44 \u0E02 {enter}",
		"{shift} \u0E1A \u0E1B \u0E25 \u0E2B \u0E34 \u0E04 \u0E2A \u0E30 \u0E08 \u0E1E {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0E3F + \u0022 / , ? \u0E38 _ . ( ) - % {bksp}",
		"{tab} \u0E4A \u0E24 \u0E46 \u0E0D \u0E29 \u0E36 \u0E1D \u0E0B \u0E16 \u0E12 \u0E2F \u0E26 \u0E4D",
		"\u0E4B \u0E18 \u0E33 \u0E13 \u0E4C \u0E37 \u0E1C \u0E0A \u0E42 \u0E06 \u0E11 {enter}",
		"{shift} \u0E0E \u0E0F \u0E10 \u0E20 \u0E31 \u0E28 \u0E2E \u0E1F \u0E09 \u0E2C {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Tibetan (PRC) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdtiprc.html
 */
jQuery.keyboard.layouts['ms-Tibetan (PRC)'] = {
	"name" : "ms-Tibetan (PRC)",
	"lang" : ["bo"],
	"normal" : [
		"\u0f68 \u0f21 \u0f22 \u0f23 \u0f24 \u0f25 \u0f26 \u0f27 \u0f28 \u0f29 \u0f20 \u0f67 \u0f5d {bksp}",
		"{tab} \u0f45 \u0f46 \u0f7a \u0f62 \u0f4f \u0f61 \u0f74 \u0f72 \u0f7c \u0f55 \u0f59 \u0f5a \u0f5b",
		"\u0f60 \u0f66 \u0f51 \u0f56 \u0f44 \u0f58 \u0f0b \u0f42 \u0f63 \u0f5e \u0f0d {enter}",
		"{shift} \u0f5f \u0f64 \u0f40 \u0f41 \u0f54 \u0f53 m \u0f50 \u0f47 / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0f01 \u0f2a \u0f2b \u0f2c \u0f2d \u0f2e \u0f2f \u0f30 \u0f31 \u0f32 \u0f33 \u0f3c \u0f3d {bksp}",
		"{tab} \u0f15 \u0f16 \u0f17 \u0fbc \u0f4a \u0fbb \u0f18 \u0f19 \u0f1a \u0f1b \u0f1c \u0f1d \u0f1e",
		"\u0f71 \u0f1f \u0f4c \u0f3e \u0f3f \u0fcf \u0f02 \u0f03 \u0f06 \u0f07 \u0f38 {enter}",
		"{shift} \u0f34 \u0f65 \u0f69 \u0f87 \u0f86 \u0f4e M \u0f4b \u0f3a / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"\u0f00 \u0f76 \u0f77 \u0f78 \u0f79 \u0f73 \u0f09 \u0f0a \u0f0f \u0f10 \u0f12 \u0f0c \u0f13 {bksp}",
		"{tab} \u0f89 \u0f88 \u0fbe \u0f6a \u0f9a \u0fbf \u0f75 \u0f73 \u0fc0 \u0fc1 \u0fc2 \u0fc3 \u0f5c",
		"\u0fc4 \u0fc5 \u0f9c \u0f57 \u0fc6 \u0fc7 \u0fc8 \u0f43 \u0fc9 \u0fca \u0fcb {enter}",
		"{shift} \u0fcc \u0fb5 \u0fb9 \u0f36 \u0f82 \u0f9e \u0f52 \u0f9b \u0f8b {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Turkish F Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdtuf.html
 */
jQuery.keyboard.layouts['ms-Turkish F'] = {
	"name" : "ms-Turkish F",
	"lang" : ["tr"],
	"normal" : [
		"+ 1 2 3 4 5 6 7 8 9 0 / - {bksp}",
		"{tab} f g \u011F \u0131 o d r n h p q w",
		"u i e a \u00FC t k m l y \u015F x {enter}",
		"{shift} < j \u00F6 v c \u00E7 z s b . , {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"* ! \u0022 ^ $ % & ' ( ) = ? _ {bksp}",
		"{tab} F G \u011E I O D R N H P Q W",
		"U \u0130 E A \u00DC T K M L Y \u015E X {enter}",
		"{shift} > J \u00D6 V C \u00C7 Z S B : ; {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00AC \u00B9 \u00B2 # \u00BC \u00BD \u00BE { [ ] } \u005C | {bksp}",
		"{tab} @ {empty} {empty} \u00B6 {empty} \u00A5 {empty} {empty} \u00F8 \u00A3 \u00A8 ~",
		"\u00E6 \u00DF \u20AC {empty} {empty} {empty} {empty} {empty} {empty} \u00B4 {empty} ` {enter}",
		"{shift} | \u00AB \u00BB \u00A2 {empty} {empty} {empty} \u00B5 \u00D7 \u00F7 \u00AD {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} \u00A1 {empty} \u00B3 \u00A4 {empty} {empty} {empty} {empty} {empty} {empty} \u00BF {empty} {bksp}",
		"{tab} {empty} {empty} {empty} \u00AE {empty} {empty} {empty} {empty} \u00D8 {empty} {empty} {empty}",
		"\u00C6 \u00A7 {empty} \u00AA {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} \u00A6 < > \u00A9 {empty} {empty} {empty} \u00BA {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Turkish Q Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdtuq.html
 */
jQuery.keyboard.layouts['ms-Turkish Q'] = {
	"name" : "ms-Turkish Q",
	"lang" : ["tr"],
	"normal" : [
		"\u0022 1 2 3 4 5 6 7 8 9 0 * - {bksp}",
		"{tab} q w e r t y u \u0131 o p \u011F \u00FC",
		"a s d f g h j k l \u015F i , {enter}",
		"{shift} < z x c v b n m \u00F6 \u00E7 . {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00E9 ! ' ^ + % & / ( ) = ? _ {bksp}",
		"{tab} Q W E R T Y U I O P \u011E \u00DC",
		"A S D F G H J K L \u015E \u0130 ; {enter}",
		"{shift} > Z X C V B N M \u00D6 \u00C7 : {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"< > \u00A3 # $ \u00BD {empty} { [ ] } \u005C | {bksp}",
		"{tab} @ {empty} \u20AC {empty} {empty} {empty} {empty} i {empty} {empty} \u00A8 ~",
		"\u00E6 \u00DF {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00B4 {empty} ` {enter}",
		"{shift} | {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u0130 {empty} {empty} {empty} {empty}",
		"\u00C6 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Turkmen Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdturme.html
 */
jQuery.keyboard.layouts['ms-Turkmen'] = {
	"name" : "ms-Turkmen",
	"lang" : ["tk"],
	"normal" : [
		"\u017e 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u00e4 w e r t y u i o p \u0148 \u00f6 \u015f",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005c z \u00fc \u00e7 \u00fd b n m , . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u017d ! @ # $ % \u2116 & * ( ) _ + {bksp}",
		"{tab} \u00c4 W E R T Y U I O P \u0147 \u00d6 \u015e",
		"A S D F G H J K L : \u0022 {enter}",
		"{shift} | Z \u00dc \u00c7 \u00dd B N M < > / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Ukrainian Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdur.html
 */
jQuery.keyboard.layouts['ms-Ukrainian'] = {
	"name" : "ms-Ukrainian",
	"lang" : ["uk"],
	"normal" : [
		"\u0451 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u0449 \u0437 \u0445 \u0457 \u005c",
		"\u0444 \u0456 \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u0454 {enter}",
		"{shift} \u0491 \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u0401 ! \u0022 \u2116 ; % : ? * ( ) _ + {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u0429 \u0417 \u0425 \u0407 /",
		"\u0424 \u0406 \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u0404 {enter}",
		"{shift} \u0490 \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} \u0491 {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} \u0490 {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Ukrainian (Enhanced) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdur1.html
 */
jQuery.keyboard.layouts['ms-Ukrainian (Enhanced)'] = {
	"name" : "ms-Ukrainian (Enhanced)",
	"lang" : ["uk"],
	"normal" : [
		"' 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u0449 \u0437 \u0445 \u0457 \u005c",
		"\u0444 \u0456 \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u0454 {enter}",
		"{shift} \u0491 \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u20b4 ! \u0022 \u2116 ; % : ? * ( ) _ + {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u0429 \u0417 \u0425 \u0407 /",
		"\u0424 \u0406 \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u0404 {enter}",
		"{shift} \u0490 \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} \u0491 {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} \u0490 {empty} {empty} {empty} {empty} {empty} {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* United Kingdom Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbduk.html
 */
jQuery.keyboard.layouts['ms-United Kingdom'] = {
	"name" : "ms-United Kingdom",
	"lang" : ["en-uk"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] #",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005c z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00ac ! \u0022 \u00a3 $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } ~",
		"A S D F G H J K L : @ {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00a6 {empty} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00e9 {empty} {empty} {empty} \u00fa \u00ed \u00f3 {empty} {empty} {empty} {empty}",
		"\u00e1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} \u00c9 {empty} {empty} {empty} \u00da \u00cd \u00d3 {empty} {empty} {empty} {empty}",
		"\u00c1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* United Kingdom Extended Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdukx.html
 */
jQuery.keyboard.layouts['ms-United Kingdom Extended'] = {
	"name" : "ms-United Kingdom Extended",
	"lang" : ["en-uk"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] #",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005c z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00ac ! \u0022 \u00a3 $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } ~",
		"A S D F G H J K L : @ {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"\u00a6 {empty} \u00a8 {empty} \u20ac {empty} ^ {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} \u1e83 \u00e9 {empty} {empty} \u00fd \u00fa \u00ed \u00f3 {empty} {empty} {empty} ~",
		"\u00e1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00b4 {enter}",
		"{shift} {empty} {empty} {empty} \u00e7 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} \u1e82 \u00c9 {empty} {empty} \u00dd \u00da \u00cd \u00d3 {empty} {empty} {empty} {empty}",
		"\u00c1 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} ` {enter}",
		"{shift} {empty} {empty} {empty} \u00c7 {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Urdu Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdurdu.html
 */
jQuery.keyboard.layouts['ms-Urdu'] = {
	"name" : "ms-Urdu",
	"lang" : ["ur"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0637 \u0635 \u06be \u062f \u0679 \u067e \u062a \u0628 \u062c \u062d ] [ \\",
		"\u0645 \u0648 \u0631 \u0646 \u0644 \u06c1 \u0627 \u06a9 \u06cc \u061b ' {enter}",
		"{shift} \\ \u0642 \u0641 \u06d2 \u0633 \u0634 \u063a \u0639 \u060c \u06d4 / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ \u066a ^ \u06d6 \u066d ) ( _ + {bksp}",
		"{tab} \u0638 \u0636 \u0630 \u0688 \u062b \u0651 \u06c3 \u0640 \u0686 \u062e } { |",
		"\u0698 \u0632 \u0691 \u06ba \u06c2 \u0621 \u0622 \u06af \u064a : \" {enter}",
		"{shift} | {ZWJ} {ZWNJ} \u06d3 {LRM} \u0624 \u0626 {RLM} > < / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* US-Dvorak Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbddv.html
 */
jQuery.keyboard.layouts['ms-US-Dvorak'] = {
	"name" : "ms-US-Dvorak",
	"lang" : ["en"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 [ ] {bksp}",
		"{tab} ' , . p y f g c r l / = \u005C",
		"a o e u i d h t n s - {enter}",
		"{shift} ; q j k x b m w v z {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) { } {bksp}",
		"{tab} \u0022 < > P Y F G C R L ? + |",
		"A O E U I D H T N S _ {enter}",
		"{shift} : Q J K X B M W V Z {shift}",
		"{accept} {space} {cancel}"
	]
};

/* US-Dvorak for left hand Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdusl.html
 */
jQuery.keyboard.layouts['ms-US-Dvorak for left hand'] = {
	"name" : "ms-US-Dvorak for left hand",
	"lang" : ["en"],
	"normal" : [
		"` [ ] / p f m l j 4 3 2 1 {bksp}",
		"{tab} ; q b y u r s o . 6 5 = \u005C",
		"- k c d t h e a z 8 7 {enter}",
		"{shift} ' x g v w n i , 0 9 {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ { } ? P F M L J $ # @ ! {bksp}",
		"{tab} : Q B Y U R S O > ^ % + |",
		"_ K C D T H E A Z * & {enter}",
		"{shift} \u0022 X G V W N I < ) ( {shift}",
		"{accept} {space} {cancel}"
	]
};

/* US-Dvorak for right hand Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdusr.html
 */
jQuery.keyboard.layouts['ms-US-Dvorak for right hand'] = {
	"name" : "ms-US-Dvorak for right hand",
	"lang" : ["en"],
	"normal" : [
		"` 1 2 3 4 j l m f p / [ ] {bksp}",
		"{tab} 5 6 q . o r s u y b ; = \u005C",
		"7 8 z a e h t d c k - {enter}",
		"{shift} 9 0 x , i n w v g ' {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ J L M F P ? { } {bksp}",
		"{tab} % ^ Q > O R S U Y B : + |",
		"& * Z A E H T D C K _ {enter}",
		"{shift} ( ) X < I N W V G \u0022 {shift}",
		"{accept} {space} {cancel}"
	]
};

/* US English (Latin) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdus.html
 */
jQuery.keyboard.layouts['ms-US English (Latin)'] = {
	"name" : "ms-US English (Latin)",
	"lang" : ["en"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \u005c",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005c z x c v b n m , . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \u0022 {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* US English (IBM Arabic 238_L) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdusa.html
 */
jQuery.keyboard.layouts['ms-US English (IBM Arabic 238_L)'] = {
	"name" : "ms-US English (IBM Arabic 238_L)",
	"lang" : ["en"],
	"normal" : [
		"< 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] `",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005C z x c v b n m , . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"> ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } ~",
		"A S D F G H J K L : \u0022 {enter}",
		"{shift} | Z X C V B N M , . ? {shift}",
		"{accept} {space} {cancel}"
	]
};

/* US-International Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdusx.html
 */
jQuery.keyboard.layouts['ms-US-International'] = {
	"name" : "ms-US-International",
	"lang" : ["en"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ]",
		"a s d f g h j k l ; ' \u005C {enter}",
		"{shift} z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { }",
		"A S D F G H J K L : \u0022 | {enter}",
		"{shift} Z X C V B N M < > ? {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} \u00A1 \u00B2 \u00B3 \u00A4 \u20AC \u00BC \u00BD \u00BE \u2018 \u2019 \u00A5 \u00D7 {bksp}",
		"{tab} \u00E4 \u00E5 \u00E9 \u00AE \u00FE \u00FC \u00FA \u00ED \u00F3 \u00F6 \u00AB \u00BB",
		"\u00E1 \u00DF \u00F0 {empty} {empty} {empty} {empty} {empty} \u00F8 \u00B6 \u00B4 \u00AC {enter}",
		"{shift} \u00E6 {empty} \u00A9 {empty} {empty} \u00F1 \u00B5 \u00E7 {empty} \u00BF {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} \u00B9 {empty} {empty} \u00A3 {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00F7 {bksp}",
		"{tab} \u00C4 \u00C5 \u00C9 {empty} \u00DE \u00DC \u00DA \u00CD \u00D3 \u00D6 {empty} {empty}",
		"\u00C1 \u00A7 \u00D0 {empty} {empty} {empty} {empty} {empty} \u00D8 \u00B0 \u00A8 \u00A6 {enter}",
		"{shift} \u00C6 {empty} \u00A2 {empty} {empty} \u00D1 {empty} \u00C7 {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Uyghur Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdughr1.html
 */
jQuery.keyboard.layouts['ms-Uyghur'] = {
	"name" : "ms-Uyghur",
	"lang" : ["ug"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0686 \u06cb \u06d0 \u0631 \u062a \u064a \u06c7 \u06ad \u0648 \u067e ] [ \u005c",
		"\u06be \u0633 \u062f \u0627 \u06d5 \u0649 \u0642 \u0643 \u0644 \u061b ' {enter}",
		"{shift} \u0632 \u0634 \u063a \u06c8 \u0628 \u0646 \u0645 \u060c . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00bb \u00ab |",
		"{empty} {empty} \u0698 \u0641 \u06af \u062e \u062c \u06c6 \u0644\u0627 : \u0022 {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} > < / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Uyghur (Legacy) Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdughr.html
 */
jQuery.keyboard.layouts['ms-Uyghur (Legacy)'] = {
	"name" : "ms-Uyghur (Legacy)",
	"lang" : ["ug"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} \u0686 \u06cb \u06d0 \u0631 \u062a \u064a \u06c7 \u06ad \u0648 \u067e ] [ \u005c",
		"\u06be \u0633 \u062f \u0627 \u06d5 \u0649 \u0642 \u0643 \u0644 \u061b ' {enter}",
		"{shift} \u0632 \u0634 \u063a \u06c8 \u0628 \u0646 \u0645 \u060c . / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ) ( _ + {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00bb \u00ab |",
		"{empty} {empty} \u0698 \u06a7 \u06af \u062e \u062c \u06c6 \u0644\u0627 : \u0022 {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} > < / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Uzbek Cyrillic Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbduzb.html
 */
jQuery.keyboard.layouts['ms-Uzbek Cyrillic'] = {
	"name" : "ms-Uzbek Cyrillic",
	"lang" : ["uz"],
	"normal" : [
		"\u0451 1 2 3 4 5 6 7 8 9 0 \u0493 \u04b3 {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u045e \u0437 \u0445 \u044a \u005c",
		"\u0444 \u049b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} \u005c \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u0401 ! \u0022 \u2116 ; % : ? * ( ) \u0492 \u04b2 {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u040e \u0417 \u0425 \u042a /",
		"\u0424 \u049a \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} / \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Vietnamese Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdvntc.html
 */
jQuery.keyboard.layouts['ms-Vietnamese'] = {
	"name" : "ms-Vietnamese",
	"lang" : ["vi"],
	"normal" : [
		"` \u0103 \u00e2 \u00ea \u00f4 \u0300 \u0309 \u0303 \u0301 \u0323 \u0111 - \u20ab {bksp}",
		"{tab} q w e r t y u i o p \u01b0 \u01a1 \u005c",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005c z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ \u0102 \u00c2 \u00ca \u00d4 \u0300 \u0309 \u0303 \u0301 \u0323 \u0110 _ + {bksp}",
		"{tab} Q W E R T Y U I O P \u01af \u01a0 |",
		"A S D F G H J K L : \u0022 {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] \u005c",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005c z x c v b n m , . {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \u0022 {enter}",
		"{shift} | Z X C V B N M < > {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Wolof Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdwol.html
 */
jQuery.keyboard.layouts['ms-Wolof'] = {
	"name" : "ms-Wolof",
	"lang" : ["wo"],
	"normal" : [
		"\u00e3 & \u00e9 \u0022 ' ( - \u00f1 _ \u014b \u00e0 ) = {bksp}",
		"{tab} a z e r t y u i o p ^ \u00f3 *",
		"q s d f g h j k l m \u00f9 {enter}",
		"{shift} < w x c v b n , ; : / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"\u00c3 1 2 3 4 5 6 7 8 9 0 \u00c9 + {bksp}",
		"{tab} A Z E R T Y U I O P \u00a8 \u00d3 \u00d1",
		"Q S D F G H J K L M \u00c0 {enter}",
		"{shift} > W X C V B N ? . / / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} ~ # { [ | ` \u005c ^ @ ] } {bksp}",
		"{tab} {empty} {empty} \u20ac {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00a4 {empty}",
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

/* Yakut Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdyak.html
 */
jQuery.keyboard.layouts['ms-Yakut'] = {
	"name" : "ms-Yakut",
	"lang" : ["sah"],
	"normal" : [
		"\u0022 ! \u043d\u044c \u0434\u044c \u04a5 \u0495 \u04e9 \u04bb \u04af ; : - = {bksp}",
		"{tab} \u0439 \u0446 \u0443 \u043a \u0435 \u043d \u0433 \u0448 \u0449 \u0437 \u0445 \u044a \u005c",
		"\u0444 \u044b \u0432 \u0430 \u043f \u0440 \u043e \u043b \u0434 \u0436 \u044d {enter}",
		"{shift} \u0022 \u044f \u0447 \u0441 \u043c \u0438 \u0442 \u044c \u0431 \u044e / {shift}",
		"{accept} {space} {cancel}"
	],
	"shift" : [
		"\u2116 ? \u041d\u044c \u0414\u044c \u04a4 \u0494 \u04e8 \u04ba \u04ae ( ) _ + {bksp}",
		"{tab} \u0419 \u0426 \u0423 \u041a \u0415 \u041d \u0413 \u0428 \u0429 \u0417 \u0425 \u042a /",
		"\u0424 \u042b \u0412 \u0410 \u041f \u0420 \u041e \u041b \u0414 \u0416 \u042d {enter}",
		"{shift} \u2116 \u042f \u0427 \u0421 \u041c \u0418 \u0422 \u042c \u0411 \u042e / {shift}",
		"{accept} {space} {cancel}"
	]
};

/* Yoruba Keyboard Layout
 * generated from http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdyba.html
 */
jQuery.keyboard.layouts['ms-Yoruba'] = {
	"name" : "ms-Yoruba",
	"lang" : ["yo"],
	"normal" : [
		"` 1 2 3 4 5 6 7 8 9 0 - = {bksp}",
		"{tab} q w e r t y u i o p [ ] {empty}",
		"a s d f g h j k l ; ' {enter}",
		"{shift} \u005c z x c v b n m , . / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"shift" : [
		"~ ! @ # $ % ^ & * ( ) _ + {bksp}",
		"{tab} Q W E R T Y U I O P { } |",
		"A S D F G H J K L : \u0022 {enter}",
		"{shift} | Z X C V B N M < > / {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt" : [
		"{empty} {empty} {empty} {empty} {empty} \u20ac {empty} {empty} {empty} \u2018 \u2019 {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty}",
		"\u1ecd\u0301 \u1ecd\u0300 {empty} {empty} {empty} {empty} {empty} \u1eb9\u0301 \u1eb9\u0300 \u00b6 {empty} {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	],
	"alt-shift" : [
		"{empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {bksp}",
		"{tab} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} \u00a6",
		"\u1ecc\u0301 \u1ecc\u0300 {empty} {empty} {empty} {empty} {empty} \u1eb8\u0301 \u1eb8\u0300 {empty} \u00a8 {enter}",
		"{shift} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {empty} {shift}",
		"{accept} {alt} {space} {alt} {cancel}"
	]
};

// Keyboard Language
// Ethiopic kezboard to support Amahric and Gǝʿǝz made by Pietro Liuzzo and Solomon Gebreyes Beyene.
// ***********************
jQuery.keyboard.language.amh = {
	language: 'ፊደል (Fidal) Amharic and Gǝʿǝz',
	display: {
		'a': '\u2714:መቀበል (Shift+Enter)', // check mark - same action as accept
		'accept': 'Accept:መቀበል (Shift+Enter)',
		'alt': 'AltGr:ተለዋጭ፡ ፊደል፡',
		'b': '\u2190:ማጥፊያ', // Left arrow (same as &larr;)
		'bksp': 'Bksp:ማጥፊያ',
		'c': '\u2716:መሠረዝ', // big X, close - same action as cancel
		'cancel': 'Cancel:መሠረዝ',
		'clear': 'C:ማፅዳት', // clear num pad
		'combo': '\u00f6:Toggle Combo Keys',
		'dec': '.:የአሀዝ፡ ቁጥር', // decimal point for num pad (optional), change '.' to ',' for European format
		'e': '\u21b5:መጀመር', // down, then left arrow - enter symbol
		'enter': 'Enter:መጀመር',
		'lock': '\u21ea Lock:አሮጌ፡ ለውጥ', // caps lock
		's': '\u21e7:መለወጥ', // thick hollow up arrow
		'shift': 'Shift:መለወጥ',
		'sign': '\u00b1:የሒሣብ፡ ምልክት፡ መቀየር', // +/- sign for num pad
		'space': '&nbsp;:ክፍት፡ቦታ',
		't': '\u21e5:መግፊያ', // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab': '\u21e5 Tab:መግፊያ' // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage: 'Use mousewheel to see other keys',

	comboRegex: /([`\'~\^\"a-z0-9\{\}\[\]\|<>])([a-z0-9_\-\.\|`\'~\^\"!,=])/mig,
	combos: {
		a: {
			a: '\u02be', '.': '\u1ea1', 1: "\u00e0", 2: "\u00e1", 3: "\u00e3", '=': "\u00e2", 9: "\u00e4", '-': "\u0101", ',': '\u1360'
		},
		A: {
			A: '\u02bf', '-': "\u0100", 1: "\u00c0", 2: "\u00c1", 3: "\u00c3", 9: "\u00c4", '=': "\u00c2"
		},
		e: {
			e: '\u01dd', '-': "\u0113", ',': '\u1367', 1: "\u00e8", 2: "\u00e9", 3: "\u1ebd", 9: "\u00eb", '=': "\u00ea"
		},
		E: {
			E: '\u018e', '-': "\u0112", 1: "\u00c8", 2: "\u00c9", 3: "\u1ebc", 9: "\u00cb", '=': "\u00ca"
		},
		i: {
			1: "\u00ec", 2: "\u00ed", 3: "\u0129", 9: "\u00ef", 9: "\u00f6", '=': "\u00ee"
		},
		I: {
			1: "\u00cc", 2: "\u00cd", 3: "\u0128", 9: "\u00cf", '=': "\u00ce"
		},
		o: {
			1: "\u00f2", 2: "\u00f3", 3: "\u00f5", '=': "\u00f4"
		},
		O: {
			1: "\u00d2", 2: "\u00d3", 3: "\u00d5", 9: "\u00d6", '=': "\u00d4"
		},
		u: {
			1: "\u00f9", 2: "\u00fa", 3: "\u0169", 9: "\u00fc", '=': "\u00fb"
		},
		U: {
			1: "\u00d9", 2: "\u00da", 3: "\u0168", 9: "\u00dc", '=': "\u00db"
		},
		'h': {
			a: "\u1200", u: "\u1201", i: "\u1202", A: "\u1203", E: "\u1204", e: "\u1205", o: "\u1206", '!': '\u1207', '_': '\u1e2b', '.': '\u1e25'
		},
		"l": {
			a: "\u1208", u: "\u1209", i: "\u120a", A: "\u120b", E: "\u120c", e: "\u120d", o: "\u120e", '!': '\u120F'
		},
		"H": {
			a: "\u1210", u: "\u1211", i: "\u1212", A: "\u1213", E: "\u1214", e: "\u1215", o: "\u1216", '!': '\u1217', '_': '\u1e2a'
		},
		"m": {
			a: "\u1218", u: "\u1219", i: "\u121a", A: "\u121b", E: "\u121c", e: "\u121d", o: "\u121e", '!': '\u121F'
		},
		"S": {
			a: "\u1220", u: "\u1221", i: "\u1222", A: "\u1223", E: "\u1224", e: "\u1225", o: "\u1226", '!': '\u1227', '.': '\u1e62', '|': '\u0160', 6: "\u015A"
		},
		"r": {
			a: "\u1228", u: "\u1229", i: "\u122a", A: "\u122b", E: "\u122c", e: "\u122d", o: "\u122e", '!': '\u122F'
		},
		"s": {
			a: "\u1230", u: "\u1231", i: "\u1232", A: "\u1233", E: "\u1234", e: "\u1235", o: "\u1236", '!': '\u1237', '.': '\u1e63', '|': '\u0161', 6: "\u015b"
		},
		"v": {
			a: "\u1238", u: "\u1239", i: "\u123a", A: "\u123b", E: "\u123c", e: "\u123d", o: "\u123e", '!': '\u123F'
		},
		"q": {
			a: "\u1240", u: "\u1241", i: "\u1242", A: "\u1243", E: "\u1244", e: "\u1245", o: "\u1246", '!': '\u1247'
		},
		"b": {
			a: "\u1260", u: "\u1261", i: "\u1262", A: "\u1263", E: "\u1264", e: "\u1265", o: "\u1266", '!': '\u1267', ',': '\u1363'
		},
		"B": {
			a: "\u1268", u: "\u1269", i: "\u126A", A: "\u126B", E: "\u126C", e: "\u126D", o: "\u126E", '!': '\u126F'
		},
		"t": {
			a: "\u1270", u: "\u1271", i: "\u1272", A: "\u1273", E: "\u1274", e: "\u1275", o: "\u1276", '!': '\u1277', '.': '\u1e6d'
		},
		"c": {
			a: "\u1278", u: "\u1279", i: "\u127a", A: "\u127b", E: "\u127c", e: "\u127d", o: "\u127e", '!': '\u127F', '_': '\u010d\u0323', '|': '\u010d', ',': '\u1364'
		},
		"x": {
			a: "\u1280", u: "\u1281", i: "\u1282", A: "\u1283", E: "\u1284", e: "\u1285", o: "\u1286", '!': '\u1287'
		},
		"n": {
			a: "\u1290", u: "\u1291", i: "\u1292", A: "\u1293", E: "\u1294", e: "\u1295", o: "\u1296", '!': '\u1297', 3: "\u00f1"
		},
		"N": {
			a: "\u1298", u: "\u1299", i: "\u129a", A: "\u129b", E: "\u129c", e: "\u129d", o: "\u129e", '!': '\u129F', 3: "\u00d1"
		},
		"'": {
			a: "\u12a0", u: "\u12a1", i: "\u12a2", A: "\u12a3", E: "\u12a4", e: "\u12a5", o: "\u12a6", '!': '\u12A7'
		},
		"k": {
			a: "\u12a8", u: "\u12a9", i: "\u12aa", A: "\u12ab", E: "\u12ac", e: "\u12ad", o: "\u12ae", '!': '\u12AF'
		},
		"K": {
			a: "\u12b8", u: "\u12b9", i: "\u12ba", A: "\u12bb", E: "\u12bc", e: "\u12bd", o: "\u12be"
		},
		"w": {
			a: "\u12c8", u: "\u12c9", i: "\u12ca", A: "\u12cb", E: "\u12cc", e: "\u12cd", o: "\u12ce", '!': '\u12CF', '=': "\u02b7"
		},
		"W": {
			a: "\u12d0", u: "\u12d1", i: "\u12d2", A: "\u12d3", E: "\u12d4", e: "\u12d5", o: "\u12d6"
		},
		"z": {
			a: "\u12d8", u: "\u12d9", i: "\u12da", A: "\u12db", E: "\u12dc", e: "\u12dd", o: "\u12de", '!': '\u12DF', '|': '\u017e'
		},
		"Z": {
			a: "\u12e0", u: "\u12e1", i: "\u12e2", A: "\u12e3", E: "\u12e4", e: "\u12e5", o: "\u12e6", '!': '\u12E7', '|': '\u017d'
		},
		"y": {
			a: "\u12e8", u: "\u12e9", i: "\u12ea", A: "\u12eb", E: "\u12ec", e: "\u12ed", o: "\u12ee", '!': '\u12EF', 1: "\u1ef3", 2: "\u00fd", 3: "\u1ef9", 9: "\u00ff", '=': "\u0177"
		},
		"d": {
			a: "\u12f0", u: "\u12f1", i: "\u12f2", A: "\u12f3", E: "\u12f4", e: "\u12f5", o: "\u12f6", '!': '\u12F7', '.': '\u1e0d', ',': '\u1366'
		},
		"L": {
			a: "\u12F8", u: "\u12F9", i: "\u12FA", A: "\u12FB", E: "\u12FC", e: "\u12FD", o: "\u12FE", '!': '\u12FF'
		},
		"D": {
			a: "\u1300", u: "\u1301", i: "\u1302", A: "\u1303", E: "\u1304", e: "\u1305", o: "\u1306", '!': '\u1307', '.': '\u1e0c'
		},
		"g": {
			a: "\u1308", u: "\u1309", i: "\u130a", A: "\u130b", E: "\u130c", e: "\u130d", o: "\u130e", '!': '\u130F', '|': '\u01e7'
		},
		"G": {
			a: "\u1318", u: "\u1319", i: "\u131a", A: "\u131b", E: "\u131c", e: "\u131d", o: "\u131e", '!': '\u131F', '|': '\u01e6'
		},
		"T": {
			a: "\u1320", u: "\u1321", i: "\u1322", A: "\u1323", E: "\u1324", e: "\u1325", o: "\u1326", '!': '\u1327', '.': '\u1e6c'
		},
		"C": {
			a: "\u1328", u: "\u1329", i: "\u132a", A: "\u132b", E: "\u132c", e: "\u132d", o: "\u132e", '!': '\u132F'
		},
		"p": {
			a: "\u1330", u: "\u1331", i: "\u1332", A: "\u1333", E: "\u1334", e: "\u1335", o: "\u1336", '!': '\u1337', 6: "\u1e57"
		},
		"j": {
			a: "\u1338", u: "\u1339", i: "\u133a", A: "\u133b", E: "\u133c", e: "\u133d", o: "\u133e", '!': '\u133F'
		},
		"J": {
			a: "\u1340", u: "\u1341", i: "\u1342", A: "\u1343", E: "\u1344", e: "\u1345", o: "\u1346", '!': '\u1347'
		},
		"f": {
			a: "\u1348", u: "\u1349", i: "\u134a", A: "\u134b", E: "\u134c", e: "\u134d", o: "\u134e", '!': '\u134F', ',': '\u1368'
		},
		"P": {
			a: "\u1350", u: "\u1351", i: "\u1352", A: "\u1353", E: "\u1354", e: "\u1355", o: "\u1356", '!': '\u1357', 6: "\u1E56"
		},
		"Q": {
			a: "\u1250", u: "\u1251", i: "\u1252", A: "\u1253", E: "\u1254", e: "\u1255", o: "\u1256"
		},
		"[": {
			a: "\u1248", i: "\u124a", A: "\u124b", E: "\u124c", e: "\u124d"
		},
		"]": {
			a: "\u1288", i: "\u128a", A: "\u128b", E: "\u128c", e: "\u128d"
		},
		"}": {
			a: "\u12b0", i: "\u12b2", A: "\u12b3", E: "\u12b4", e: "\u12b5"
		},
		"{": {
			a: "\u1310", i: "\u1312", A: "\u1313", E: "\u1314", e: "\u1315"
		},
		"M": {
			a: "\u1380", i: "\u1381", E: "\u1382", e: "\u1383"
		},
		"|": {
			a: "\u1384", i: "\u1385", E: "\u1386", e: "\u1387"
		},
		"<": {
			a: "\u1388", i: "\u1389", E: "\u138A", e: "\u138B"
		},
		">": {
			a: "\u138C", i: "\u138D", E: "\u138E", e: "\u138F"
		},
		'Y': {
			1: "\u1ef2", 2: "\u00dd", 3: "\u1ef8", 9: "\u0178", '=': "\u0176"
		}
	},
	// language direction
	rtl: false
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// de = ISO 639-1 code for German
// ***********************
jQuery.keyboard.language.de = {
	language: 'Deutsch (German)',
	display : {
		'a'      : '\u2714:\u00dcbernehmen (Umschalt+Enter)', // check mark - same action as accept
		'accept' : '\u00dcbernehmen:\u00dcbernehmen (Umschalt+Enter)',
		'alt'    : 'AltGr:Alt Graph',
		'b'      : '\u2190:R\u00fccktaste', // Left arrow (same as &larr;)
		'bksp'   : 'R\u00fcck:R\u00fccktaste',
		'c'      : '\u2716:Abbrechen (Esc)', // big X, close - same action as cancel
		'cancel' : 'Abbrechen:Abbrechen (Esc)',
		'clear'  : 'C:L\u00f6schen', // clear num pad
		'combo'  : '\u00f6:Tottasten umschalten',
		'dec'    : ',:Dezimal', // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Eingabe', // down, then left arrow - enter symbol
		'enter'  : 'Enter:Eingabe',
		'lock'   : '\u21E9:Feststelltaste', // caps lock
		's'      : '\u21e7:Umschalttaste', // thick hollow up arrow
		'shift'  : 'Umschalt:Umschalttaste',
		'sign'   : '\u00b1:Vorzeichen wechseln', // +/- sign for num pad
		'space'  : '&nbsp;:Leertaste',
		't'      : '\u21e5:Tabulatortaste', // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tabulatortaste' // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Mausrad benutzen, um weitere Tasten zu sehen',
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// es = ISO 639-1 code for Spanish
// ***********************
jQuery.keyboard.language.es = {
	language: 'Espa\u00f1ol (Spanish)',
	display : {
		'a'      : '\u2714:Acceptar (Cambio+Inscribir)', // check mark - same action as accept
		'accept' : 'Acceptar:Acceptar (Cambio+Inscribir)',
		'alt'    : 'AltGr:Grafemas Alternativos',
		'b'      : '\u2190:Retroceso',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Retroceso',
		'c'      : '\u2716:Cancelar (Esc)', // big X, close - same action as cancel
		'cancel' : 'Cancelar:Cancelar (Esc)',
		'clear'  : 'C:Vaciar',             // clear num pad
		'combo'  : '\u00f6:Alternar las Teclas Combinados',
		'dec'    : ',:Decimal',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Inscribir',        // down, then left arrow - enter symbol
		'enter'  : 'Inscribir:Inscribir',
		'lock'   : '\u21ea Bloq:Mayús', // caps lock
		's'      : '\u21e7:Cambio',        // thick hollow up arrow
		'shift'  : 'Cambio:Cambio',
		'sign'   : '\u00b1:Cambiar Signo',  // +/- sign for num pad
		'space'  : '&nbsp;:Espacio',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	wheelMessage : 'Utilice la rueda del mouse para ver otras teclas'
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// fa = ISO 639-1 code for Farsi
// ***********************
jQuery.keyboard.language.fa = {
	language: '\u0641\u0627\u0631\u0633\u06cc (Farsi)',
	display: {
		'a'      : '\u2714:\u062a\u0623\u06cc\u06cc\u062f (Shift+Enter)',
		'accept' : '\u062a\u0623\u06cc\u06cc\u062f:\u062a\u0623\u06cc\u06cc\u062f (Shift+Enter)',
		'alt'    : 'Lng:Alternate Graphemes',
		'b'      : '\u2190:\u2b05 Backspace',
		'bksp'   : '\u2b05 Bksp:\u2b05 Backspace',
		'c'      : '\u2716:\u0627\u0646\u0635\u0631\u0627\u0641 (Esc)',
		'cancel' : '\u0627\u0646\u0635\u0631\u0627\u0641:\u0627\u0646\u0635\u0631\u0627\u0641 (Esc)',
		'clear'  : 'C:Clear',
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : '.:Decimal',
		'e'      : '\u21b5:Enter',
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock',
		's'      : '\u21e7:Shift',
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:Change Sign',
		'space'  : '&nbsp;:Space',
		't'      : '\u21e5:Tab',
		'tab'    : '\u21e5 Tab:Tab'
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage: 'Use mousewheel to see other keys',
	rtl: true

	// uncomment, then include changes to the comboRegex here
	//, comboRegex: /([`\'~\^\"ao])([a-z])/mig,
	// uncomment, then include any changes to the combos option here
	/*
	, combos : {
	// grave
	'`' : { a:"\u00e0", A:"\u00c0", e:"\u00e8", E:"\u00c8", i:"\u00ec", I:"\u00cc", o:"\u00f2", O:"\u00d2",
	u:"\u00f9", U:"\u00d9", y:"\u1ef3", Y:"\u1ef2" },
	// acute & cedilla
	"'" : { a:"\u00e1", A:"\u00c1", e:"\u00e9", E:"\u00c9", i:"\u00ed", I:"\u00cd", o:"\u00f3", O:"\u00d3",
	u:"\u00fa", U:"\u00da", y:"\u00fd", Y:"\u00dd" },
	// umlaut/trema
	'"' : { a:"\u00e4", A:"\u00c4", e:"\u00eb", E:"\u00cb", i:"\u00ef", I:"\u00cf", o:"\u00f6", O:"\u00d6",
	u:"\u00fc", U:"\u00dc", y:"\u00ff", Y:"\u0178" },
	// circumflex
	'^' : { a:"\u00e2", A:"\u00c2", e:"\u00ea", E:"\u00ca", i:"\u00ee", I:"\u00ce", o:"\u00f4", O:"\u00d4",
	u:"\u00fb", U:"\u00db", y:"\u0177", Y:"\u0176" },
	// tilde
	'~' : { a:"\u00e3", A:"\u00c3", e:"\u1ebd", E:"\u1ebc", i:"\u0129", I:"\u0128", o:"\u00f5", O:"\u00d5",
	u:"\u0169", U:"\u0168", y:"\u1ef9", Y:"\u1ef8", n:"\u00f1", N:"\u00d1" }
	}
	*/
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// fr = ISO 639-1 code for French
// ***********************
jQuery.keyboard.language.fr = {
	language: 'Fran\u00e7ais (French)',
	display : {
		'a'      : '\u2714:Valider (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Valider:Valider (Shift+Enter)',
		'alt'    : 'AltGr:Charact\u00e8re alternatif',
		'b'      : '\u2190:Suppr arri\u00e8re', // Left arrow (same as &larr;)
		'bksp'   : '\u2190Suppr:Suppr arri\u00e8re',
		'c'      : '\u2716:Annuler', // big X, close - same action as cancel
		'cancel' : 'Annuler:Annuler (\u00c9chap)',
		'clear'  : 'C:Effacer', // clear num pad
		'combo'  : '\u00f6:Bacsuler les touches combo',
		'dec'    : '.:Decimal', // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Entr\u00e9e', // down, then left arrow - enter symbol
		'enter'  : 'Entr\u00e9e:Entr\u00e9e',
		'lock'   : '\u21ea Verr Mag:Verouillage majuscule', // caps lock
		's'      : '\u21e7:Majuscule', // thick hollow up arrow
		'shift'  : 'Maj:Majuscule',
		'sign'   : '\u00b1:Change de signe', // +/- sign for num pad
		'space'  : '&nbsp;:Espace',
		't'      : '\u21e5:Tabulation', // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tabulation' // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Utiliser la molette de la souris pour voir les autres lettres',
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// he = ISO 639-1 code for Hebrew
// ***********************
jQuery.keyboard.language.he = {
	language: '\u05e2\u05d1\u05e8\u05d9\u05ea (Hebrew)',
	display : {
		'a'      : '\u2714:אישור (Shift+Enter)', // check mark - same action as accept
		'accept' : 'אישור:אישור (Shift+Enter)',
		'alt'    : 'Alt:תווים נוספים',
		'b'      : '\u2190:Backspace',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Backspace',
		'c'      : '\u2716:ביטול (Esc)', // big X, close - same action as cancel
		'cancel' : 'ביטול:ביטול (Esc)',
		'clear'  : 'C:ניקוי',             // clear num pad
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : '.:נקודה עשרונית',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Enter',        // down, then left arrow - enter symbol
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Shift',        // thick hollow up arrow
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:שינוי סימן',  // +/- sign for num pad
		'space'  : '&nbsp;:רווח',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'ניתן להשתמש בגלגלת העכבר כדי לראות מקשים נוספים',
	// language direction
	rtl : true
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// hu = ISO 639-1 code for Hungarian
// ***********************
jQuery.keyboard.language.hu = {
	language: 'Magyar (Hungarian)',
	display : {
		'a'      : '\u2714:Rendben (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Rendben:Rendben (Shift+Enter)',
		'alt'    : 'AltGr:Alternate Graphemes',
		'b'      : '\u2190:Backspace',    // Left arrow (same as &larr;)
		'bksp'   : 'T\u00f6r\u00f6l:Backspace',
		'c'      : '\u2716:Cancel (Esc)', // big X, close - same action as cancel
		'cancel' : 'M\u00e9gsem:Cancel (Esc)',
		'clear'  : 'C:Clear',             // clear num pad
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : '.:Decimal',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Enter',        // down, then left arrow - enter symbol
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Shift',        // thick hollow up arrow
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:Change Sign',  // +/- sign for num pad
		'space'  : '&nbsp;:Space',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Haszn\u00e1ld az eg\u00e9r g\u00f6rget\u0151t a t\u00f6bbi billenty\u0171 \u00e1tv\u00e1lt\u00e1shoz',
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// "all" is used here for example purposes, by convention it should be the ISO 639-1 code for the specified language
// ***********************
jQuery.keyboard.language.it = {
	language: 'Italiano (Italian)', // e.g. 'Русский (Russian)'
	display : {
		'a'      : '\u2714:Accetta (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Accetta:Accetta (Shift+Enter)',
		'alt'    : 'AltGr:Grafemi Alternativi',
		'b'      : '\u2190:Cancella',    // Left arrow (same as &larr;)
		'bksp'   : 'Canc:Cancella',
		'c'      : '\u2716:Annulla (Esc)', // big X, close - same action as cancel
		'cancel' : 'Annulla:Annulla (Esc)',
		'clear'  : 'C:Pulisci',             // clear num pad
		'combo'  : '\u00f6:Tasti Combinati',
		'dec'    : ',:Decimale',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Invio',        // down, then left arrow - enter symbol
		'enter'  : 'Invio:Invio',
		'lock'   : '\u21ea Bloc:Bloc Maiusc', // caps lock
		's'      : '\u21e7:Maiusc',        // thick hollow up arrow
		'shift'  : 'Maiusc:Maiusc',
		'sign'   : '\u00b1:Cambia Segno',  // +/- sign for num pad
		'space'  : '&nbsp;:Spazio',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Usa la rotella del mouse per vedere altri tasti'

	// uncomment, then include changes to the comboRegex here
	/*
	, comboRegex : /([`\'~\^\"ao])([a-z])/mig,
	*/

	// uncomment, then include any changes to the combos option here
	/*
	, combos : {
		// grave
		'`' : { a:"\u00e0", A:"\u00c0", e:"\u00e8", E:"\u00c8", i:"\u00ec", I:"\u00cc", o:"\u00f2", O:"\u00d2",
				u:"\u00f9", U:"\u00d9", y:"\u1ef3", Y:"\u1ef2" },
		// acute & cedilla
		"'" : { a:"\u00e1", A:"\u00c1", e:"\u00e9", E:"\u00c9", i:"\u00ed", I:"\u00cd", o:"\u00f3", O:"\u00d3",
				u:"\u00fa", U:"\u00da", y:"\u00fd", Y:"\u00dd" },
		// umlaut/trema
		'"' : { a:"\u00e4", A:"\u00c4", e:"\u00eb", E:"\u00cb", i:"\u00ef", I:"\u00cf", o:"\u00f6", O:"\u00d6",
				u:"\u00fc", U:"\u00dc", y:"\u00ff", Y:"\u0178" },
		// circumflex
		'^' : { a:"\u00e2", A:"\u00c2", e:"\u00ea", E:"\u00ca", i:"\u00ee", I:"\u00ce", o:"\u00f4", O:"\u00d4",
				u:"\u00fb", U:"\u00db", y:"\u0177", Y:"\u0176" },
		// tilde
		'~' : { a:"\u00e3", A:"\u00c3", e:"\u1ebd", E:"\u1ebc", i:"\u0129", I:"\u0128", o:"\u00f5", O:"\u00d5",
				u:"\u0169", U:"\u0168", y:"\u1ef9", Y:"\u1ef8", n:"\u00f1", N:"\u00d1" }
	},
	// language direction
	rtl : false
	*/
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// lv = ISO 639-1 code for Latvian
// ***********************
jQuery.keyboard.language.lv = {
	language: 'Latvie\u0161u (Latvian)',
	display : {
		'a'      : '\u2714:Pie\u0146emt (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Pie\u0146emt:Pie\u0146emt (Shift+Enter)',
		'alt'    : 'AltGr:Altern\u0113\u0161anas tausti\u0146\u0161',
		'b'      : '\u2190:Atpaka\u013Catk\u0101pe',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Atpaka\u013Catk\u0101pe',
		'c'      : '\u2716:Atcelt (Esc)', // big X, close - same action as cancel
		'cancel' : 'Atcelt:Atcelt (Esc)',
		'clear'  : 'C:Clear',             // clear num pad
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : '.:Decimal',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Enter',        // down, then left arrow - enter symbol
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Shift',        // thick hollow up arrow
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:Change Sign',  // +/- sign for num pad
		'space'  : '&nbsp;:Space',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Izmanto peles riten\u012Bti, lai apskat\u012Btu citus tausti\u0146us',
	// New combos using specific accents
	combos : {
		// duplicated from regular combos, used specific accents here instead
		// acute & cedilla c C é É n N ó Ó s S z Z
		"'" : { c:"\u0107", C:"\u0106", e:"\u00e9", E:"\u00c9", n:"\u0144", N:"\u0143", o:"\u00f3", O:"\u00d3", s:"\u015b", S:"\u015a", z:"\u017a", Z:"\u0179" },
		// diaeresis: ä Ä ö Ö ü Ü
		'\u00a8' : { a:"\u00e4", A:"\u00c4", o:"\u00f6", O:"\u00d6", u:"\u00fc", U:"\u00dc" },
		// degree sign å Å e E g z Z
		'\u00b0' : { a:"\u00e5", A:"\u00c5", e:"\u0117", E:"\u0116", g:"\u0121", z:"\u017c", Z:"\u017b" },
	},
	comboRegex : /([`\'~\^\"ao\u00a8\u00b0])([a-z])/mig
};

/**
 * Burmese Keyboard Language
 * please update this section to match this language and email me with corrections!
 * my = ISO 639-1 code for Burmese
 * thanks to @laminko (https://github.com/laminko);
 * see https://github.com/Mottie/Keyboard/pull/507
 * license for this file: WTFPL
 */
jQuery.keyboard.language.my = {
	language: '\u1017\u1019\u102c (Burmese)', // e.g. 'Русский (Russian)'
	display : {
		'a'      : '\u2714:Accept (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Accept:Accept (Shift+Enter)',
		'alt'    : 'AltGr:Alternate Graphemes',
		'b'      : '\u2190:Backspace',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Backspace',
		'c'      : '\u2716:Cancel (Esc)', // big X, close - same action as cancel
		'cancel' : 'Cancel:Cancel (Esc)',
		'clear'  : 'C:\u101b\u103e\u1004\u103a\u1038\u101c\u1004\u103a\u1038\u101b\u1014\u103a', // clear num pad
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : '.:\u1012\u101e\u1019',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Enter',        // down, then left arrow - enter symbol
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Shift',        // thick hollow up arrow
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:Change Sign',  // +/- sign for num pad
		'space'  : '&nbsp;:Space',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : '\u1021\u1001\u103c\u102c\u1038\u1001\u101c\u102f\u1010\u103a\u1019\u103b\u102c\u1038\u1000\u102d\u102f \u1019\u103c\u1004\u103a\u101b\u1005\u1031\u101b\u1014\u103a \u1019\u1031\u102c\u1000\u103a\u1005\u103a\u101d\u103e\u102e\u1038\u101c\u103a\u1000\u102d\u102f \u1021\u101e\u102f\u1036\u1038\u1015\u103c\u102f\u1015\u102b'

	// uncomment, then include changes to the comboRegex here
	/*
	, comboRegex : /([`\'~\^\"ao])([a-z])/mig,
	*/

	// uncomment, then include any changes to the combos option here
	/*
	, combos : {
		// grave
		'`' : { a:"\u00e0", A:"\u00c0", e:"\u00e8", E:"\u00c8", i:"\u00ec", I:"\u00cc", o:"\u00f2", O:"\u00d2",
				u:"\u00f9", U:"\u00d9", y:"\u1ef3", Y:"\u1ef2" },
		// acute & cedilla
		"'" : { a:"\u00e1", A:"\u00c1", e:"\u00e9", E:"\u00c9", i:"\u00ed", I:"\u00cd", o:"\u00f3", O:"\u00d3",
				u:"\u00fa", U:"\u00da", y:"\u00fd", Y:"\u00dd" },
		// umlaut/trema
		'"' : { a:"\u00e4", A:"\u00c4", e:"\u00eb", E:"\u00cb", i:"\u00ef", I:"\u00cf", o:"\u00f6", O:"\u00d6",
				u:"\u00fc", U:"\u00dc", y:"\u00ff", Y:"\u0178" },
		// circumflex
		'^' : { a:"\u00e2", A:"\u00c2", e:"\u00ea", E:"\u00ca", i:"\u00ee", I:"\u00ce", o:"\u00f4", O:"\u00d4",
				u:"\u00fb", U:"\u00db", y:"\u0177", Y:"\u0176" },
		// tilde
		'~' : { a:"\u00e3", A:"\u00c3", e:"\u1ebd", E:"\u1ebc", i:"\u0129", I:"\u0128", o:"\u00f5", O:"\u00d5",
				u:"\u0169", U:"\u0168", y:"\u1ef9", Y:"\u1ef8", n:"\u00f1", N:"\u00d1" }
	},
	// language direction
	rtl : false
	*/
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// pl = ISO 639-1 code for Polish
// ***********************
jQuery.keyboard.language.pl = {
	language: 'Polski (Polish)',
	display : {
		'a'      : '\u2714:Akceptuj (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Accept:Akceptuj (Shift+Enter)',
		'alt'    : 'AltGr:Polskie znaki',
		'b'      : '\u2190:Cofnij',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Cofnij',
		'c'      : '\u2716:Anuluj (Esc)', // big X, close - same action as cancel
		'cancel' : 'Cancel:Anuluj (Esc)',
		'clear'  : 'C:Czyść',             // clear num pad
		'combo'  : '\u00f6:Klawisze kombo',
		'dec'    : '.:Dziesiętny',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Enter',        // down, then left arrow - enter symbol
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Shift',        // thick hollow up arrow
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:Zmień znak',  // +/- sign for num pad
		'space'  : '&nbsp;:Spacja',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Użyj rolki aby zobaczyć pozozstałe klawisze',
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// pt = ISO 639-1 code for Portuguese
// ***********************
jQuery.keyboard.language.pt = {
	language: 'Portugu\u00eas (Portuguese)',
	display : {
		'a'      : '\u2714:Aceitar (Shift+Enter)',           // ALTERNATE accept button - unicode for check mark symbol
		'accept' : 'Aceitar:Concluir (Shift+Enter)',         // Accept button text
		'alt'    : 'AltGr:Carateres Adicionais/CTRL+ALT',    // Alt button text (AltGr is for international key sets)
		'b'      : '\u2190:Retroceder',                      // ALTERNATE backspace button - unicode for left arrow. Same as ← ( &larr; ) - Left arrow
		'bksp'   : '\u2190 Bksp:Retroceder',                 // Backspace button text
		'c'      : '\u2716:Cancelar/Escape (Esc)',           // ALTERNATE cancel button - unicode for big X
		'cancel' : 'Cancel:Cancelar/Escape(Esc)',            // Cancel button text
		'clear'  : 'C:Limpar',                               // Clear window content (used in num pad)
		'combo'  : '\u00f6:Acentuação Automática',        // (Toggle combo (diacritic) key
		'dec'    : '.:Decimal',                              // Decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Introduzir/Mudar de Linha',       // ALTERNATE enter button - unicode for down, then left arrow (enter symbol)
		'enter'  : 'Enter\u21b5:Introduzir/Mudar de Linha',  // Enter button text
		'lock'   : '\u21ea Lock:CapsLock/Maiúsculas',       // Caps lock button - unicode for double lined up arrow
		's'      : '\u21e7:Shift/Maiúsculas',               // ALTERNATE shift button - unicode for a thick up arrow
		'shift'  : '\u21ea Shift:Maiúsculas-Minúsculas',   // Shift button text
		'sign'   : '\u00b1:Mudar Sinal',                     // Change sign (used in num pad) - unicode for a +- symbol
		'space'  : '&nbsp;:Espaço',                         // Space button text
		't'      : '\u21e5:Tab/Tabela/Avançar',             // ALTERNATE tab button - unicode for right arrow to bar (used since only one directional tabs available)
		'tab'    : '\u21e5 Tab:Tabela/Avançar'              // Tab button text (Note: \u21b9 is the true tab symbol (left & right arrows) but not used here)
	},
	wheelMessage : 'Use a roda do rato/navegador para ver mais teclas',

	// Update regex for the combos above
	comboRegex : /([`\'~\^\"ao\u00b4])([a-z])/mig,
	// New combos using specific accents
	combos : {
		"\u00b4" : { a:"\u00e1", A:"\u00c1", e:"\u00e9", E:"\u00c9", i:"\u00ed", I:"\u00cd", o:"\u00f3", O:"\u00d3", u:"\u00fa", U:"\u00da", y:"\u00fd", Y:"\u00dd" }, // acute & cedilla
		// remove apostrophe combo
		"'" : {}
	}

};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// ro = ISO 639-1 code for Romanian
// ***********************
jQuery.keyboard.language.ro = {
	language: 'Rom\u00e2n\u0103 (Romanian)',
	display : {
		'a'      : '\u2714:Accept (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Accept:Accept (Shift+Enter)',
		'alt'    : 'AltGr:Alternate Graphemes',
		'b'      : '\u2190:Backspace',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Backspace',
		'c'      : '\u2716:Cancel (Esc)', // big X, close - same action as cancel
		'cancel' : 'Cancel:Cancel (Esc)',
		'clear'  : 'C:Clear',             // clear num pad
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : ',:Decimal',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Enter',        // down, then left arrow - enter symbol
		'enter'  : 'Enter:Enter',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Shift',        // thick hollow up arrow
		'shift'  : 'Shift:Shift',
		'sign'   : '\u00b1:Schimba semnul',  // +/- sign for num pad
		'space'  : '&nbsp;:Spatiu',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Foloseste rotita mouse-ului pentru a vedea si celelalte caractere',
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// ru = ISO 639-1 code for Russian
// ***********************
jQuery.keyboard.language.ru = {
	language: '\u0420\u0443\u0441\u0441\u043a\u0438\u0439 (Russian)',
	display : {
		'a'      : '\u2714:Сохранить (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Сохранить:Сохранить (Shift+Enter)',
		'alt'    : 'РУС:Русская клавиатура',
		'b'      : '\u2190:Удалить символ слева',    // Left arrow (same as &larr;)
		'bksp'   : '\u21e6:Удалить символ слева',
		'c'      : '\u2716:Отменить (Esc)', // big X, close - same action as cancel
		'cancel' : 'Отменить:Отменить (Esc)',
		'clear'  : 'C:Очистить',             // clear num pad
		'combo'  : '\u00f6:Toggle Combo Keys',
		'dec'    : ',:Decimal',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Ввод',        // down, then left arrow - enter symbol
		'enter'  : 'Ввод:Перевод строки',
		'lock'   : '\u21ea Lock:Caps Lock', // caps lock
		's'      : '\u21e7:Верхний регистр',        // thick hollow up arrow
		'shift'  : '\u21e7:Верхний регистр',
		'sign'   : '\u00b1:Сменить знак',  // +/- sign for num pad
		'space'  : 'Пробел:',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'Use mousewheel to see other keys',
};

// Keyboard Language
// please update this section to match this language and email me with corrections!
// sq = ISO 639-1 code for Albanian
// ***********************
jQuery.keyboard.language.sq = {
	language : 'Shqip (Albanian)',
	display : {
		'a'      : '\u2714:Prano (Shift+Enter)', // check mark - same action as accept
		'accept' : 'Prano:Prano (Shift+Enter)',
		'alt'    : 'Alt:Alternativ',
		'b'      : '\u2190:Hap\u00ebsir\u00ebn Mbrapa',    // Left arrow (same as &larr;)
		'bksp'   : 'Bksp:Hap\u00ebsir\u00ebn Mbrapa',
		'c'      : '\u2716:Anuloj (Arratisjes)', // big X, close - same action as cancel
		'cancel' : 'Anuloj:Anuloj (Arratisjes)',
		'clear'  : 'C:Qart\u00eb',             // clear num pad
		'combo'  : '\u00f6:Kombinimi',
		'dec'    : '.:Decimal',           // decimal point for num pad (optional), change '.' to ',' for European format
		'e'      : '\u21b5:Shkruani',        // down, then left arrow - enter symbol
		'enter'  : 'Shkruani:Shkruani',
		'lock'   : '\u21ea Bllokoj:Caps Lock', // caps lock
		'next'   : 'Next \u21e8',
		'prev'   : '\u21e6 Prev',
		's'      : '\u21e7:Ndryshim',        // thick hollow up arrow
		'shift'  : 'Ndryshim:Ndryshim',
		'sign'   : '\u00b1:Ndryshimi Regjistrohu',  // +/- sign for num pad
		'space'  : '&nbsp;:Hap\u00ebsir\u00eb',
		't'      : '\u21e5:Tab',          // right arrow to bar (used since this virtual keyboard works with one directional tabs)
		'tab'    : '\u21e5 Tab:Tab'       // \u21b9 is the true tab symbol (left & right arrows)
	},
	// Message added to the key title while hovering, if the mousewheel plugin exists
	wheelMessage : 'P\u00ebrdorimi mousewheel p\u00ebr t\u00eb par\u00eb \u00e7el\u00ebsat e tjera',

	// New combos using specific accents
	// Not sure what to do with these accents:  ˇ ˘ ˙ ° ˛ ˝
	comboRegex : /([`\'~\^\"ao\/])([a-z])/gim,
	combos : {
		// new combos below ( forward slash + d, forward slash + l )
		'/' : { d:"\u0111", D:"\u0110", l:"\u0142", L:"\u0141" } // stroke đ Đ ł Ł
	}
};
