// Generated by CoffeeScript 1.7.1
(function() {
  var popup;

  popup = document.URL.split("?")[1];

  if (popup == null) {
    window.open("" + document.URL + "?popup=true", "popupWindow", "width=" + ($(window).width()) + ",height=" + ($(window).height()) + ",scrollbars=yes");
  }

  describe("jQuery.Autohide", function() {
    beforeEach(function() {
      this.body = $("body");
      this.body.height(5000);
      this.container_div = $("<div/>");
      this.body.prepend(this.container_div);
      this.spacer_div = $("<div/>");
      this.spacer_div.width("100%").height(100);
      this.container_div.append(this.spacer_div);
      this.stuck_div = $('<div class="row stuck"></div>');
      this.stuck_div.height(100);
      this.container_div.append(this.stuck_div);
      this.second_stuck_div = $('<div class="row stuck"></div>');
      this.second_stuck_div.height(100);
      this.container_div.append(this.second_stuck_div);
      this.release_container_div = $('<div class="row release-container"></div>');
      this.release_container_div.height(2000);
      this.container_div.append(this.release_container_div);
      this.release_div = $('<div class="columns stuck release"</div>');
      this.release_div.height(100);
      this.release_container_div.append(this.release_div);
      this.row = $('<div class="row"></div>');
      this.column1 = $('<div class="columns medium-6"></div>');
      this.column1.height(1000);
      this.row.append(this.column1);
      this.column2 = $('<div class="columns medium-6 stuck"></div>');
      this.column2.height(100);
      this.row.append(this.column2);
      this.container_div.append(this.row);
      this.html_body = $("html, body");
      this.stuck_plugin = $(window).stuck();
    });
    afterEach(function() {
      if (popup != null) {
        window.resizeTo(1600, 900);
      }
      this.html_body.animate({
        scrollTop: 0
      }, 0);
      this.stuck_plugin.destroy();
      this.spacer_div.remove();
      this.stuck_div.remove();
      this.second_stuck_div.remove();
      this.release_div.remove();
      this.release_container_div.remove();
      this.column1.remove();
      this.column2.remove();
      this.row.remove();
      this.container_div.remove();
      this.body.height("auto");
    });
    if (popup != null) {
      return describe("Resize", function() {
        it("releases the element if it jumps down the page on resize", function(done) {
          var stacked_height;
          stacked_height = this.stuck_div.height() + this.second_stuck_div.height();
          expect(this.column2.position().top).not.toEqual(stacked_height);
          this.html_body.animate({
            scrollTop: this.column2.offset().top + 100
          }, 250).promise().done((function(_this) {
            return function() {
              expect(_this.column2.position().top).toEqual(stacked_height);
              window.resizeTo(300, 900);
              return setTimeout(function() {
                expect(_this.column2.position().top).not.toEqual(stacked_height);
                done();
              }, 250);
            };
          })(this));
        });
        it("stacks the element if it jumps up the page on resize", function(done) {
          var stacked_height;
          stacked_height = this.stuck_div.height() + this.second_stuck_div.height();
          window.resizeTo(300, 900);
          setTimeout((function(_this) {
            return function() {
              _this.html_body.animate({
                scrollTop: _this.column1.offset().top + (_this.column1.height() / 2)
              }, 250).promise().done(function() {
                expect(_this.column2.position().top).not.toEqual(stacked_height);
                window.resizeTo(1600, 900);
                return setTimeout(function() {
                  expect(_this.column2.position().top).toEqual(stacked_height);
                  done();
                }, 250);
              });
            };
          })(this), 250);
        });
        return it("adjusts the element left position and width on window resize after scrolling past it", function(done) {
          window.resizeTo(300, 900);
          setTimeout((function(_this) {
            return function() {
              _this.html_body.animate({
                scrollTop: _this.stuck_div.offset().top + 100
              }, 250).promise().done(function() {
                expect(_this.stuck_div.position().top).toEqual(0);
                expect(_this.stuck_div.position().left).toEqual(0);
                window.resizeTo(1600, 900);
                return setTimeout(function() {
                  expect(_this.stuck_div.position().top).toEqual(0);
                  expect(_this.stuck_div.position().left).not.toEqual(0);
                  done();
                }, 250);
              });
            };
          })(this), 250);
        });
      });
    } else {
      describe("Scroll", function() {
        it("sticks an element to the top of the page after scrolling past it", function(done) {
          expect(this.stuck_div.position().top).not.toEqual(0);
          this.html_body.animate({
            scrollTop: 2000
          }, 250).promise().done((function(_this) {
            return function() {
              expect(_this.stuck_div.position().top).toEqual(0);
              done();
            };
          })(this));
        });
        return it("returns the element to the start position after scrolling past it then back up", function(done) {
          var stuck_top;
          stuck_top = this.stuck_div.position().top;
          expect(stuck_top).not.toEqual(0);
          this.html_body.animate({
            scrollTop: 2000
          }, 250).promise().done((function(_this) {
            return function() {
              return _this.html_body.animate({
                scrollTop: 0
              }, 500).promise().done(function() {
                expect(_this.stuck_div.position().top).toEqual(stuck_top);
                done();
              });
            };
          })(this));
        });
      });
      describe("Stack", function() {
        it("stacks the second div underneath the first div", function(done) {
          this.html_body.animate({
            scrollTop: 2000
          }, 250).promise().done((function(_this) {
            return function() {
              expect(_this.stuck_div.position().top).toEqual(0);
              expect(_this.second_stuck_div.position().top).toEqual(_this.stuck_div.height());
              done();
            };
          })(this));
        });
        return it("returns the second div to the start position after scrolling past it then back up", function(done) {
          var stuck_top;
          stuck_top = this.second_stuck_div.position().top;
          expect(stuck_top).not.toEqual(0);
          this.html_body.animate({
            scrollTop: 2000
          }, 250).promise().done((function(_this) {
            return function() {
              return _this.html_body.animate({
                scrollTop: 0
              }, 500).promise().done(function() {
                expect(_this.second_stuck_div.position().top).toEqual(stuck_top);
                done();
              });
            };
          })(this));
        });
      });
      return describe("Release", function() {
        it("stacks the stuck div underneath the second div after scrolling past it", function(done) {
          this.html_body.animate({
            scrollTop: 1000
          }, 250).promise().done((function(_this) {
            return function() {
              var top_offset;
              top_offset = _this.stuck_div.height() + _this.second_stuck_div.height();
              expect(_this.release_div.position().top).toEqual(top_offset);
              done();
            };
          })(this));
        });
        it("sticks the stuck div to the bottom of the release container after scrolling past the bottom of the container", function(done) {
          this.html_body.animate({
            scrollTop: 3000
          }, 250).promise().done((function(_this) {
            return function() {
              var expected_offset;
              expected_offset = _this.release_container_div.offset().top + _this.release_container_div.height() - _this.release_div.height();
              expect(_this.release_div.offset().top).toEqual(expected_offset);
              done();
            };
          })(this));
        });
        it("stacks the stuck div underneath the second div after scrolling past the bottom of the release container then back up", function(done) {
          var stuck_top;
          stuck_top = this.second_stuck_div.position().top;
          expect(stuck_top).not.toEqual(0);
          this.html_body.animate({
            scrollTop: 3000
          }, 250).promise().done((function(_this) {
            return function() {
              return _this.html_body.animate({
                scrollTop: 1000
              }, 500).promise().done(function() {
                var top_offset;
                top_offset = _this.stuck_div.height() + _this.second_stuck_div.height();
                expect(_this.release_div.position().top).toEqual(top_offset);
                done();
              });
            };
          })(this));
        });
        return it("returns the stuck div to the start position after scrolling past it then back up", function(done) {
          var start_top;
          start_top = this.release_div.position().top;
          expect(start_top).not.toEqual(0);
          this.html_body.animate({
            scrollTop: 3000
          }, 250).promise().done((function(_this) {
            return function() {
              return _this.html_body.animate({
                scrollTop: 0
              }, 500).promise().done(function() {
                expect(_this.release_div.position().top).toEqual(start_top);
                done();
              });
            };
          })(this));
        });
      });
    }
  });

}).call(this);
