Upgrading from ng-grid 2.0.x to ui-grid 3.0

## Module name has changed from nggrid to ui.grid

Directive name has changed from ng-grid to ui-grid. 

Before:
```html
<div ng-grid="{ data: data }"></div>
```
```javascript
angular.module('yourModule', ['ngGrid'];
```

After:
```html
<div ui-grid="{ data: data }"></div>
```
```javascript
angular.module('yourModule', ['ui.grid'];
```

## A string value in options.columnDefs is no longer supported.  

ColumnDefs are now always watched via $watchCollection. 

Before:
```javascript
$scope.myColDefs = {[...]};
$scope.gridOptions.columnDefs = 'myColDefs'
```

After:
```javascript
$scope.gridOptions.columnDefs = $scope.myColDefs = [...];
or 
$scope.gridOptions.columnDefs = [...];
```

## All columns within columnDefs must have a name or a field.

Before:
```javascript
$scope.gridOptions = {
  columnDefs: [
    { displayName: 'Edit' }
  ],
  data: myData
};
```

After:
```javascript
$scope.gridOptions = {
  columnDefs: [
    { name: 'edit', displayName: 'Edit' }
  ],
  data: myData
};
```

## ui-grid uses an isolate scope
You can no longer access data or functions directly on the parent scope.  You must use grid.appScope to get a reference to the parent scope

Before:
```javascript
$scope.gridOptions = {
  columnDefs = [
    { name: 'edit', displayName: 'Edit', cellTemplate: '<button ng-click="edit(row.entity)" >Edit</button>' }
  ],
  data: myData
};

$scope.edit = function( entity ) {
  ...some custom function using entity...
};
```

```html
<div ng-grid="gridOptions" ></div>
```

After:
```javascript
$scope.gridScope = $scope;
$scope.gridOptions = {
  columnDefs = [
    { name: 'edit', displayName: 'Edit', cellTemplate: '<button ng-click="grid.appScope.edit(row.entity)" >Edit</button>' }
  ],
  data: myData
};

$scope.edit = function( entity ) {
  ...some custom function using entity...
};
```

## Some features previously included in the base are now plugins.

Refer to the tutorials and API documentation at http://ui-grid.info/docs/ for more detail, an example provided below is column resizing.  The plugins are available in the base javascript, using them requires only including the appropriate directive in the grid declaration:

After:
```html
<div ui-grid="gridOptions" ui-grid-resize-columns ></div>
```
