"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ava_1 = require("ava");
// inject window, document etc.
require("jsdom-global/register");
var installCE = require("document-register-element/pony");
installCE(global, 'force');
var text_control_1 = require("../src/renderers/controls/text.control");
var data_service_1 = require("../src/core/data.service");
ava_1.default('TextControlTester', function (t) {
    t.is(-1, text_control_1.TextControlTester(undefined));
    t.is(-1, text_control_1.TextControlTester(null));
    t.is(-1, text_control_1.TextControlTester({ type: 'Foo' }));
    t.is(1, text_control_1.TextControlTester({ type: 'Control' }));
});
ava_1.default('TextControl static', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    renderer.setDataService(new data_service_1.DataService(data));
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' } });
    var result = renderer.render();
    t.is(result.className, 'control');
    t.is(result.childNodes.length, 3);
    var label = result.children[0];
    t.is(label.tagName, 'LABEL');
    t.is(label.textContent, 'Name');
    var input = result.children[1];
    t.is(input.tagName, 'INPUT');
    t.is(input.type, 'text');
    t.is(input.value, 'Foo');
    var validation = result.children[2];
    t.is(validation.tagName, 'DIV');
    t.is(validation.children.length, 0);
});
ava_1.default('TextControl static no label', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    renderer.setDataService(new data_service_1.DataService(data));
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' },
        label: false });
    var result = renderer.render();
    t.is(result.className, 'control');
    t.is(result.childNodes.length, 3);
    var label = result.children[0];
    t.is(label.tagName, 'LABEL');
    t.is(label.textContent, '');
    var input = result.children[1];
    t.is(input.tagName, 'INPUT');
    t.is(input.type, 'text');
    t.is(input.value, 'Foo');
    var validation = result.children[2];
    t.is(validation.tagName, 'DIV');
    t.is(validation.children.length, 0);
});
ava_1.default('TextControl inputChange', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    renderer.setDataService(new data_service_1.DataService(data));
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' } });
    var result = renderer.render();
    var input = result.children[1];
    input.value = 'Bar';
    input.oninput(null);
    t.is(data.name, 'Bar');
});
// TODO If I add console log, then I see that the value is set, but cannot verify
ava_1.default.failing('TextControl dataService notification', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' } });
    renderer.connectedCallback();
    var result = renderer.render();
    var input = result.children[1];
    dataService.notifyChange({ type: 'Control', scope: { $ref: '#/properties/name' } }, 'Bar');
    t.is(input.value, 'Bar');
});
ava_1.default('TextControl dataService notification wrong ref', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' } });
    renderer.connectedCallback();
    var result = renderer.render();
    var input = result.children[1];
    dataService.notifyChange({ type: 'Control', scope: { $ref: '#/properties/firstname' } }, 'Bar');
    t.is(input.value, 'Foo');
});
ava_1.default('TextControl dataService notification null ref', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' } });
    renderer.connectedCallback();
    var result = renderer.render();
    var input = result.children[1];
    dataService.notifyChange(null, 'Bar');
    t.is(input.value, 'Foo');
});
ava_1.default('TextControl dataService notification undefined ref', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' } });
    renderer.connectedCallback();
    var result = renderer.render();
    var input = result.children[1];
    dataService.notifyChange(undefined, 'Bar');
    t.is(input.value, 'Foo');
});
ava_1.default('TextControl dataService no notification after disconnect', function (t) {
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    var renderer = new text_control_1.TextControl();
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    renderer.setDataSchema(schema);
    renderer.setUiSchema({ type: 'Control', scope: { $ref: '#/properties/name' } });
    renderer.connectedCallback();
    var result = renderer.render();
    renderer.disconnectedCallback();
    var input = result.children[1];
    dataService.notifyChange({ type: 'Control', scope: { $ref: '#/properties/name' } }, 'Bar');
    t.is(input.value, 'Foo');
});
ava_1.default('TextControl notify visible', function (t) {
    var renderer = new text_control_1.TextControl();
    var controlElement = { type: 'Control', scope: { $ref: '#/properties/name' } };
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    renderer.setDataSchema(schema);
    renderer.setUiSchema(controlElement);
    renderer.connectedCallback();
    var runtime = controlElement['runtime'];
    runtime.visible = false;
    t.is(renderer.hidden, true);
});
ava_1.default('TextControl notify disabled', function (t) {
    var renderer = new text_control_1.TextControl();
    var controlElement = { type: 'Control', scope: { $ref: '#/properties/name' } };
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    renderer.setDataSchema(schema);
    renderer.setUiSchema(controlElement);
    renderer.connectedCallback();
    var runtime = controlElement['runtime'];
    runtime.enabled = false;
    var input = renderer.children[1];
    t.is(input.getAttribute('disabled'), 'true');
    // TODO would be nice
    // t.is(input.disabled, true);
});
ava_1.default('TextControl notify enabled', function (t) {
    var renderer = new text_control_1.TextControl();
    var controlElement = { type: 'Control', scope: { $ref: '#/properties/name' } };
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    renderer.setDataSchema(schema);
    renderer.setUiSchema(controlElement);
    renderer.connectedCallback();
    var runtime = controlElement['runtime'];
    runtime.enabled = true;
    var input = renderer.children[1];
    t.false(input.hasAttribute('disabled'));
});
ava_1.default('TextControl disconnected no notify visible', function (t) {
    var renderer = new text_control_1.TextControl();
    var controlElement = { type: 'Control', scope: { $ref: '#/properties/name' } };
    var data = { 'name': 'Foo' };
    var dataService = new data_service_1.DataService(data);
    renderer.setDataService(dataService);
    var schema = { type: 'object', properties: { name: { type: 'string' } } };
    renderer.setDataSchema(schema);
    renderer.setUiSchema(controlElement);
    renderer.connectedCallback();
    renderer.disconnectedCallback();
    var runtime = controlElement['runtime'];
    runtime.visible = false;
    var input = renderer.children[1];
    t.is(input.hidden, false);
});
//# sourceMappingURL=text.control.test.js.map