/*! leaflet-dvf 08-09-2016 */
/*
 @preserve Leaflet Data Visualization Framework, a JavaScript library for creating thematic maps using Leaflet
 (c) 2013-2015, Scott Fairgrieve, HumanGeo
*/
L.LinearFunction=L.Class.extend({options:{constrainX:!1},initialize:function(a,b,c){this.setOptions(c),this.setRange(a,b)},_calculateParameters:function(a,b){0===this._xRange?(this._slope=0,this._b=a.y):(this._slope=(b.y-a.y)/this._xRange,this._b=a.y-this._slope*a.x)},_arrayToPoint:function(a){return{x:a[0],y:a[1]}},setOptions:function(a){L.Util.setOptions(this,a),this._preProcess=this.options.preProcess,this._postProcess=this.options.postProcess},getBounds:function(){var a=Math.min(this._minPoint.x,this._maxPoint.x),b=Math.max(this._minPoint.x,this._maxPoint.x),c=Math.min(this._minPoint.y,this._maxPoint.y),d=Math.max(this._minPoint.y,this._maxPoint.y);return[new L.Point(a,c),new L.Point(b,d)]},setRange:function(a,b){return a=a instanceof Array?this._arrayToPoint(a):a,b=b instanceof Array?this._arrayToPoint(b):b,this._minPoint=a,this._maxPoint=b,this._xRange=b.x-a.x,this._yRange=b.y-a.y,this._calculateParameters(a,b),this},setMin:function(a){return this.setRange(a,this._maxPoint),this},setMax:function(a){return this.setRange(this._minPoint,a),this},setPreProcess:function(a){return this._preProcess=a,this},setPostProcess:function(a){return this._postProcess=a,this},constrainX:function(a){return a=Number(a),this.options.constrainX&&(a=Math.max(a,this._minPoint.x),a=Math.min(a,this._maxPoint.x)),a},evaluate:function(a){var b;return this._preProcess&&(a=this._preProcess(a)),b=Number((this._slope*a).toFixed(6))+Number(this._b.toFixed(6)),this._postProcess&&(b=this._postProcess(b)),b},random:function(){var a=Math.random()*this._xRange+this._minPoint.x;return this.evaluate(a)},sample:function(a){a=Math.max(a,2);for(var b=a-1,c=this._xRange/b,d=this._minPoint.x,e=[];d<=this._maxPoint.x;)e.push(this.evaluate(d)),d+=c;return e},samplePoints:function(a){a=Math.max(a,2);for(var b=a-1,c=this._xRange/b,d=this._minPoint.x,e=[];d<=this._maxPoint.x;)e.push(new L.Point(d,this.evaluate(d))),d+=c;return e},evaluatePercent:function(a){return this.getPointAtPercent(a).y},getPointAtPercent:function(a){var b=this._xRange*a,c=this._yRange*a,d=this._minPoint.x+b,e=this._minPoint.y+c;return new L.Point(d,e)},getIntersectionPoint:function(a){var b=null;if(this._slope!==a._slope){var c=(this._b-a._b)/(a._slope-this._slope),d=this.evaluate(c);b=new L.Point(c,d)}return b}}),L.ColorFunction=L.LinearFunction.extend({options:{alpha:1,includeAlpha:!1},initialize:function(a,b,c){L.Util.setOptions(this,c),this._parts=[],this._dynamicPart=null,this._outputPrecision=0,this._prefix=null,this._formatOutput=function(a){return a.toFixed(this._outputPrecision)},this._mapOutput=function(a){for(var b=[],c=0;c<this._parts.length;++c){var d=this._parts[c];b.push(a[d])}return this.options.includeAlpha&&b.push(this.options.alpha),b},this._getColorString=function(a){a=this._formatOutput(a),this.options[this._dynamicPart]=a;var b=this._mapOutput(this.options);return this._writeColor(this._prefix,b)},this._writeColor=function(a,b){return this.options.includeAlpha&&(a+="a"),a+"("+b.join(",")+")"},c=this.options;var d=function(a){c&&c.postProcess&&(a=c.postProcess.call(this,a));var b=this._getColorString(a);return(L.Browser.ie&&b.indexOf("hsl")>-1||c.rgb)&&(b=L.hslColor(b).toRGBString()),b};L.LinearFunction.prototype.initialize.call(this,a,b,{preProcess:this.options.preProcess,postProcess:d})}}),L.HSLColorFunction=L.ColorFunction.extend({initialize:function(a,b,c){L.ColorFunction.prototype.initialize.call(this,a,b,c),this._parts=["outputHue","outputSaturation","outputLuminosity"],this._prefix="hsl",this._outputPrecision=2}}),L.RGBColorFunction=L.ColorFunction.extend({initialize:function(a,b,c){L.ColorFunction.prototype.initialize.call(this,a,b,c),this._parts=["outputRed","outputBlue","outputGreen"],this._prefix="rgb",this._outputPrecision=0}}),L.RGBRedFunction=L.LinearFunction.extend({options:{outputGreen:0,outputBlue:0},initialize:function(a,b,c){L.RGBColorFunction.prototype.initialize.call(this,a,b,c),this._dynamicPart="outputRed"}}),L.RGBBlueFunction=L.LinearFunction.extend({options:{outputRed:0,outputGreen:0},initialize:function(a,b,c){L.RGBColorFunction.prototype.initialize.call(this,a,b,c),this._dynamicPart="outputBlue"}}),L.RGBGreenFunction=L.LinearFunction.extend({options:{outputRed:0,outputBlue:0},initialize:function(a,b,c){L.RGBColorFunction.prototype.initialize.call(this,a,b,c),this._dynamicPart="outputGreen"}}),L.RGBColorBlendFunction=L.LinearFunction.extend({initialize:function(a,b,c,d){c=new L.RGBColor(c),d=new L.RGBColor(d);var e=c.r(),f=d.r(),g=c.g(),h=d.g(),i=c.b(),j=d.b();this._minX=a,this._maxX=b,this._redFunction=new L.LinearFunction(new L.Point(a,e),new L.Point(b,f)),this._greenFunction=new L.LinearFunction(new L.Point(a,g),new L.Point(b,h)),this._blueFunction=new L.LinearFunction(new L.Point(a,i),new L.Point(b,j))},getBounds:function(){var a=this._redFunction.getBounds(),b=this._greenFunction.getBounds(),c=this._blueFunction.getBounds(),d=Math.min(a[0].y,b[0].y,c[0].y),e=Math.max(a[0].y,b[0].y,c[0].y);return[new L.Point(a[0].x,d),new L.Point(a[1].x,e)]},evaluate:function(a){return new L.RGBColor([this._redFunction.evaluate(a),this._greenFunction.evaluate(a),this._blueFunction.evaluate(a)]).toRGBString()}}),L.HSLHueFunction=L.HSLColorFunction.extend({options:{outputSaturation:"100%",outputLuminosity:"50%"},initialize:function(a,b,c){L.HSLColorFunction.prototype.initialize.call(this,a,b,c),this._dynamicPart="outputHue"}}),L.HSLSaturationFunction=L.LinearFunction.extend({options:{outputHue:0,outputLuminosity:"50%"},initialize:function(a,b,c){L.HSLColorFunction.prototype.initialize.call(this,a,b,c),this._formatOutput=function(a){return(100*a).toFixed(this._outputPrecision)+"%"},this._dynamicPart="outputSaturation"}}),L.HSLLuminosityFunction=L.LinearFunction.extend({options:{outputHue:0,outputSaturation:"100%"},initialize:function(a,b,c){L.HSLColorFunction.prototype.initialize.call(this,a,b,c),this._formatOutput=function(a){return(100*a).toFixed(this._outputPrecision)+"%"},this._dynamicPart="outputLuminosity"}}),L.HSLColorBlendFunction=L.LinearFunction.extend({initialize:function(a,b,c,d){c=new L.HSLColor(c),d=new L.HSLColor(d);var e=c.h(),f=d.h(),g=c.s(),h=d.s(),i=c.l(),j=d.l();this._minX=a,this._maxX=b,this._hueFunction=new L.LinearFunction(new L.Point(a,e),new L.Point(b,f)),this._saturationFunction=new L.LinearFunction(new L.Point(a,g),new L.Point(b,h)),this._luminosityFunction=new L.LinearFunction(new L.Point(a,i),new L.Point(b,j))},getBounds:function(){var a=this._hueFunction.getBounds(),b=this._saturationFunction.getBounds(),c=this._luminosityFunction.getBounds(),d=Math.min(a[0].y,b[0].y,c[0].y),e=Math.max(a[0].y,b[0].y,c[0].y);return[new L.Point(a[0].x,d),new L.Point(a[1].x,e)]},evaluate:function(a){return new L.HSLColor([this._hueFunction.evaluate(a),this._saturationFunction.evaluate(a),this._luminosityFunction.evaluate(a)]).toHSLString()}}),L.PiecewiseFunction=L.LinearFunction.extend({options:{constrainX:!0},initialize:function(a,b){L.Util.setOptions(this,b),this._functions=a;var c,d;c=a[0].getBounds()[0],d=a[a.length-1].getBounds()[1],L.LinearFunction.prototype.initialize.call(this,c,d,{preProcess:this.options.preProcess,postProcess:this.options.postProcess})},_getFunction:function(a){var b,c,d,e;if(a<this._minPoint.x)e=this._functions[0];else if(a>=this._maxPoint.x)e=this._functions[this._functions.length-1];else for(var f=0;f<this._functions.length&&(e=this._functions[f],b=e.getBounds(),c=b[0],d=b[1],!(a>=c.x&&a<d.x));++f);return e},evaluate:function(a){var b,c=null;return a=this.constrainX(a),this._preProcess&&(a=this._preProcess(a)),b=this._getFunction(a),b&&(c=b.evaluate(a),this._postProcess&&(c=this._postProcess(c))),c}}),L.ColorClassFunction=L.PiecewiseFunction.extend({options:{interpolate:!1},initialize:function(a,b,c){var d,e=[];L.Util.setOptions(this,c);for(var f=0;f<a.length-1;++f){var g=a[f],h=a[f+1],i=b[f],j=this.options.interpolate?b[Math.min(b.length-1,f+1)]:b[f];d=new L.RGBColorBlendFunction(g,h,i,j),e.push(d)}L.PiecewiseFunction.prototype.initialize.call(this,e)}}),L.CustomColorFunction=L.PiecewiseFunction.extend({options:{interpolate:!0},initialize:function(a,b,c,d){L.Util.setOptions(this,d);for(var e,f,g=this.options.interpolate?c.length-1:c.length,h=[],i=new L.LinearFunction([0,a],[g,b]),j=0;g>j;++j)f=j+1,e=this.options.interpolate?new L.RGBColorBlendFunction(i.evaluate(j),i.evaluate(f),c[j],c[f]):new L.RGBColorBlendFunction(i.evaluate(j),i.evaluate(f),c[j],c[j]),h.push(e);i=null,L.PiecewiseFunction.prototype.initialize.call(this,h)}}),L.CategoryFunction=L.Class.extend({initialize:function(a,b){L.Util.setOptions(this,b),this._categoryKeys=Object.keys(a),this._categoryMap=a,this._preProcess=this.options.preProcess,this._postProcess=this.options.postProcess},evaluate:function(a){var b;return this._preProcess&&(a=this._preProcess(a)),b=this._categoryMap[a],this._postProcess&&(b=this._postProcess(b)),b},getCategories:function(){return this._categoryKeys}}),Array.prototype.indexOf||(Array.prototype.indexOf=function(a,b){for(var c=b||0,d=this.length;d>c;c++)if(this[c]===a)return c;return-1}),Object.keys||(Object.keys=function(){var a=Object.prototype.hasOwnProperty,b=!{toString:null}.propertyIsEnumerable("toString"),c=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],d=c.length;return function(e){var f,g,h;if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.keys called on non-object");f=[];for(g in e)a.call(e,g)&&f.push(g);if(b)for(h=0;d>h;h++)a.call(e,c[h])&&f.push(c[h]);return f}}()),L.Util.guid=function(){var a=function(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)};return a()+a()+"-"+a()+"-"+a()+"-"+a()+"-"+a()+a()+a()},L.Util.getProperty=function(a,b,c){return b in a?a[b]:c},L.Util.setFieldValue=function(a,b,c){for(var d,e=b.split("."),f=a,g=0;g<e.length-1;++g)d=e[g],f[d]=f[d]||{},f=f[d];f[e[e.length-1]]=c},L.Util.getFieldValue=function(a,b){var c=null;if(b){for(var d,e,f,g,h,i,j,k=b.split("."),l=a,m=-1,n=0;n<k.length;++n)if(d=k[n],m=d.indexOf("["),m>-1){i=d.substring(m),d=d.substring(0,m),i=i.replace("[","").replace("]",""),e=i.split("="),f=e[0],g=e[1],l=l[d];for(var o=0;o<l.length;++o)h=l[o],j=h[f],j&&j===g&&(l=h)}else{if(!l||!l.hasOwnProperty(d)){l=null;break}l=l[d]}c=l}else c=a;return c},L.Util.getNumericRange=function(a,b){var c=Number.MAX_VALUE,d=Number.MIN_VALUE;for(var e in a)if(a.hasOwnProperty(e)){var f=a[e],g=L.Util.getFieldValue(f,b);c=Math.min(c,g),d=Math.max(d,g)}return[c,d]},L.Util.pointToGeoJSON=function(){var a={type:"Feature",geometry:{type:"Point",coordinates:[this._latlng[1],this._latlng[0]]},properties:{}};for(var b in this.options)if(this.options.hasOwnProperty(b)){var c=this.options[b];"function"!=typeof c&&(a.properties[b]=c)}return a},L.Util.updateLayer=function(a,b){!a.eachLayer||a instanceof L.FeatureGroup?b.call(this,a):a.eachLayer(function(a){L.Util.updateLayer(a,b)})},L.CategoryLegend=L.Class.extend({initialize:function(a){L.Util.setOptions(this,a)},generate:function(a){a=a||{};var b=document.createElement("div"),c=L.DomUtil.create("div","legend",b),d=a.className,e=this.options;d&&L.DomUtil.addClass(c,d),a.title&&(L.DomUtil.create("div","legend-title",c).innerHTML=a.title);for(var f in e){categoryOptions=e[f];var g=categoryOptions.displayName||f,h=L.DomUtil.create("div","data-layer-legend",c),i=L.DomUtil.create("div","legend-box",h);L.DomUtil.create("div","key",h).innerHTML=g,L.StyleConverter.applySVGStyle(i,categoryOptions)}return b.innerHTML}}),L.LegendIcon=L.DivIcon.extend({initialize:function(a,b,c){var d,e=document.createDocumentFragment(),f=document.createElement("div","",e),g=L.DomUtil.create("div","legend",f),h=L.DomUtil.create("div","title",g),i=L.DomUtil.create("div","legend-box",g),j=L.DomUtil.create("div","legend-values",g),k=b.title||b.name;k&&(h.innerHTML=k);for(var l in a)d=a[l],L.DomUtil.create("div","key",j).innerHTML=d.name||l,L.DomUtil.create("div","value",j).innerHTML=d.value;L.StyleConverter.applySVGStyle(i,b),i.style.height="5px",c.html=f.innerHTML,c.className=c.className||"legend-icon",L.DivIcon.prototype.initialize.call(this,c)}}),L.legendIcon=function(a,b,c){return new L.LegendIcon(a,b,c)},L.GeometryUtils={getName:function(a){var b=null;if(a&&a.features)for(var c=0;c<a.features.length;++c){var d=a.features[c];if(d.properties&&d.properties.name){b=d.properties.name;break}}return b},getGeoJSONLocation:function(a,b,c,d){var e=function(a){return L.Util.getFieldValue(a,c)};c&&"function"==typeof c&&(e=c);var f=new L.GeoJSON(a,{pointToLayer:function(a,e){var f={location:e,text:c?L.Util.getFieldValue(b,c):[e.lat.toFixed(3),e.lng.toFixed(3)].join(", "),center:e};return d(f,b)}}),g=null;try{g=L.GeometryUtils.loadCentroid(a)}catch(h){console.log("Error loading centroid for "+JSON.stringify(a))}return{location:f,text:c?L.Util.getFieldValue(b,c):null,center:g}},mergeProperties:function(a,b,c){var d,e,f=b.features,g=L.GeometryUtils.indexFeatureCollection(f,c),h={type:"FeatureCollection",features:[]};for(var i in a)if(a.hasOwnProperty(i)&&(d=a[i],e=d[c])){var j=g[e];for(var k in d)j.properties[k]=d[k];h.features.push(j)}return h},indexFeatureCollection:function(a,b){for(var c,d,e,f=a.features,g={},h=0;h<f.length;++h)if(c=f[h],d=c.properties,e=d[b],e in g){var i=g[e];"GeometryCollection"!==i.geometry.type?g[e]={type:"Feature",geometry:{type:"GeometryCollection",geometries:[c.geometry,i.geometry]}}:i.geometry.geometries.push(c.geometry)}else g[e]=c;return g},arrayToMap:function(a,b,c){for(var d,e,f,g={},h=0;h<a.length;++h)d=a[h],e=d[b],f=c?d[c]:d,g[e]=f;return g},arrayToMaps:function(a,b){for(var c,d,e,f,g,h,i,j=[],k=0;k<b.length;++k)j.push({});for(var l=0;l<a.length;++l){d=a[l];for(var m=0;m<b.length;++m)c=j[m],g=b[m],h=g.from,i=g.to,e=d[h],f=i?d[i]:d,c[e]=f}return j},loadCentroid:function(a){var b,c,d,e=null;if(a.geometry&&"Point"===a.geometry.type)e=new L.LatLng(a.geometry.coordinates[1],a.geometry.coordinates[0]);else if("undefined"!=typeof jsts){var f=new jsts.io.GeoJSONParser,g=f.read(a);if(g.getCentroid)b=g.getCentroid(),c=b.coordinate.x,d=b.coordinate.y;else if(g.features){for(var h=0,i=0,j=0;j<g.features.length;++j)b=g.features[j].geometry.getCentroid(),h+=b.coordinate.x,i+=b.coordinate.y;c=h/g.features.length,d=i/g.features.length}else b=g.geometry.getCentroid(),c=b.coordinate.x,d=b.coordinate.y;e=new L.LatLng(d,c)}return e},loadCentroids:function(a){var b,c={};for(var d in a)b=a[d],c[d]=L.GeometryUtils.loadCentroid(b);return c}},L.SVGPathBuilder=L.Class.extend({initialize:function(a,b,c){this._points=a||[],this._innerPoints=b||[],L.Util.setOptions(this,c)},options:{closePath:!0},_getPathString:function(a,b){var c="";if(a.length>0){var d=a[0];b=null!==b?b:2;var e="M",f="L",g="Z";L.Browser.vml&&(b=0,e="m",f="l",g="xe"),c=e+d.x.toFixed(b)+","+d.y.toFixed(b);for(var h=1;h<a.length;h++)d=a[h],c+=f+d.x.toFixed(b)+","+d.y.toFixed(b);this.options.closePath&&(c+=g)}return c},addPoint:function(a,b){b?this._innerPoints.push(a):this._points.push(a)},build:function(a){a=a||this.options.digits;var b=this._getPathString(this._points,a);return this._innerPoints&&(b+=this._getPathString(this._innerPoints,a)),b}}),L.StyleConverter={keyMap:{fillColor:{property:["background-color"],valueFunction:function(a){return a}},color:{property:["color","border-top-color","border-right-color","border-bottom-color","border-left-color"],valueFunction:function(a){return a}},weight:{property:["border-width"],valueFunction:function(a){return Math.ceil(a)+"px"}},stroke:{property:["border-style"],valueFunction:function(a){return a===!0?"solid":"none"}},dashArray:{property:["border-style"],valueFunction:function(a){var b="solid";return a&&(b="dashed"),b}},barThickness:{property:["height"],valueFunction:function(a){return a+"px"}},radius:{property:["height"],valueFunction:function(a){return 2*a+"px"}},fillOpacity:{property:["opacity"],valueFunction:function(a){return a}}},applySVGStyle:function(a,b,c){var d=L.StyleConverter.keyMap;c&&(d=L.Util.extend(d,c)),a.style.borderStyle="solid";for(var e in b)L.StyleConverter.setCSSProperty(a,e,b[e],d);return a},setCSSProperty:function(a,b,c,d){d=d||L.StyleConverter.keyMap;var e=d[b],f="";if(e)for(var g=e.property,h=0,i=g.length;i>h;++h)f+=g[h]+":"+e.valueFunction(c)+";";return a.style.cssText+=f,a}},L.StylesBuilder=L.Class.extend({initialize:function(a,b){this._categories=a,this._styleFunctionMap=b,this._buildStyles()},_buildStyles:function(){for(var a,b,c,d={},e=0;e<this._categories.length;++e){a=this._categories[e],d[a]={};for(var f in this._styleFunctionMap)b=this._styleFunctionMap[f],c=b.evaluate?b.evaluate(e):"function"==typeof b?b(e):b,d[a][f]=c}this._styleMap=d},getStyles:function(){return this._styleMap}}),L.PaletteBuilder=L.Class.extend({initialize:function(a){this._styleFunctionMap=a},generate:function(a){a=a||{};var b=document.createElement("div"),c=L.DomUtil.create("div","palette",b),d=a.count||10,e=function(a){for(var b=[],c=0;a>c;++c)b.push(c);return b}(d),f=new L.StylesBuilder(e,this._styleFunctionMap),g=f.getStyles();a.className&&L.DomUtil.addClass(c,a.className);for(var h in g){var i=L.DomUtil.create("i","palette-element",c),j=g[h];L.StyleConverter.applySVGStyle(i,j)}return b.innerHTML}}),L.HTMLUtils={buildTable:function(a,b,c){function d(a,b){for(var c=0,d=a.length;d>c;c++)if(a[c]===b)return!0;return!1}b=b||"table table-condensed table-striped table-bordered";for(var e=document.createDocumentFragment(),f=L.DomUtil.create("table",b,e),g=L.DomUtil.create("thead","",f),h=L.DomUtil.create("tbody","",f),i=L.DomUtil.create("tr","",g),j=["Name","Value"],k=0,l=j.length;l>k;k++){var m=L.DomUtil.create("th","",i);m.innerHTML=j[k]}c=c||[];for(var n in a)if(a.hasOwnProperty(n)&&!d(c,n)){var o=a[n];if("object"==typeof o){var p=document.createElement("div");p.appendChild(L.HTMLUtils.buildTable(o,c)),o=p.innerHTML}var q=L.DomUtil.create("tr","",h),r=[n,o];for(k=0,l=r.length;l>k;k++){var s=L.DomUtil.create("td","",q);s.innerHTML=r[k]}}return f}},L.AnimationUtils={animate:function(a,b,c,d){var e=d.delay||0,f=d.frames||30,g=d.duration||500,h={},i=d.easeFunction||function(a){return a},j=d.complete,k=g/f;for(var l in b)"color"!=l&&"fillColor"!=l&&c[l]?h[l]=new L.LinearFunction([0,b[l]],[f-1,c[l]]):("color"==l||"fillColor"==l)&&(h[l]=new L.RGBColorBlendFunction(0,f-1,b[l],c[l]));var m={},n=0,o=function(){for(var b in h)m[b]=h[b].evaluate(n);a.options=L.extend({},a.options,m),a.setStyle(a.options).redraw(),n++,k=i(k),f>n?setTimeout(o,k):j()};setTimeout(o,e)}},L.Color=L.Class.extend({initialize:function(a){this._rgb=[0,0,0],this._hsl=[0,1,.5],this._a=1,a&&this.parseColorDef(a)},parseColorDef:function(){},rgbToHSL:function(a,b,c){a/=255,b/=255,c/=255;var d,e,f=Math.max(a,b,c),g=Math.min(a,b,c),h=(f+g)/2;if(f==g)d=e=0;else{var i=f-g;switch(e=h>.5?i/(2-f-g):i/(f+g),f){case a:d=(b-c)/i+(c>b?6:0);break;case b:d=(c-a)/i+2;break;case c:d=(a-b)/i+4}d/=6}return[d,e,h]},hslToRGB:function(a,b,c){var d,e,f,g=function(a,b,c){return 0>c&&(c+=1),c>1&&(c-=1),1/6>c?a+6*(b-a)*c:.5>c?b:2/3>c?a+(b-a)*(2/3-c)*6:a};if(0===b)d=e=f=c;else{var h=.5>c?c*(1+b):c+b-c*b,i=2*c-h;d=g(i,h,a+1/3),e=g(i,h,a),f=g(i,h,a-1/3)}return[Math.floor(255*d),Math.floor(255*e),Math.floor(255*f)]},setRGB:function(a,b,c){return this._rgb=[a,b,c],this._hsl=this.rgbToHSL(a,b,c),this},setHSL:function(a,b,c){return this._hsl=[a,b,c],this._rgb=this.hslToRGB(a,b,c),this},toHSL:function(){return this._hsl},toHSLString:function(){var a="hsl";return this._a<1&&(a+="a"),a+"("+(360*this._hsl[0]).toFixed(1)+","+(100*this._hsl[1]).toFixed(0)+"%,"+(100*this._hsl[2]).toFixed(0)+"%)"},toRGB:function(){return this._rgb},toRGBString:function(){var a;if(this._a<1)a="rgba("+this._rgb[0].toFixed(0)+","+this._rgb[1].toFixed(0)+","+this._rgb[2].toFixed(0)+","+this._a.toFixed(1)+")";else{for(var b=[this._rgb[0].toString(16),this._rgb[1].toString(16),this._rgb[2].toString(16)],c=0;c<b.length;++c)1===b[c].length&&(b[c]="0"+b[c]);a="#"+b.join("")}return a},r:function(a){return arguments.length?this.setRGB(a,this._rgb[1],this._rgb[2]):this._rgb[0]},g:function(a){return arguments.length?this.setRGB(this._rgb[0],a,this._rgb[2]):this._rgb[1]},b:function(a){return arguments.length?this.setRGB(this._rgb[0],this._rgb[1],a):this._rgb[2]},h:function(a){return arguments.length?this.setHSL(a,this._hsl[1],this._hsl[2]):this._hsl[0]},s:function(a){return arguments.length?this.setHSL(this._hsl[0],a,this._hsl[2]):this._hsl[1]},l:function(a){return arguments.length?this.setHSL(this._hsl[0],this._hsl[1],a):this._hsl[2]},a:function(a){return arguments.length?(this._a=a,this):this._a}}),L.RGBColor=L.Color.extend({initialize:function(a){L.Color.prototype.initialize.call(this,a)},parseColorDef:function(a){var b,c,d,e,f=a instanceof Array,g=0===a.indexOf("#"),h=[];f?(b=Math.floor(a[0]),c=Math.floor(a[1]),d=Math.floor(a[2]),e=4===a.length?a[3]:1):g?(a=a.replace("#",""),b=parseInt(a.substring(0,2),16),c=parseInt(a.substring(2,4),16),d=parseInt(a.substring(4,6),16),e=8===a.length?parseInt(a.substring(6,8),16):1):(h=a.replace("rgb","").replace("a","").replace(/\s+/g,"").replace("(","").replace(")","").split(","),b=parseInt(h[0]),c=parseInt(h[1]),d=parseInt(h[2]),e=4===h.length?parseInt(h[3]):1),this.setRGB(b,c,d),this._a=e}}),L.rgbColor=function(a){return new L.RGBColor(a)},L.HSLColor=L.Color.extend({initialize:function(a){L.Color.prototype.initialize.call(this,a)},parseColorDef:function(a){var b,c,d,e,f=a instanceof Array;if(f)b=a[0],c=a[1],d=a[2],e=4===a.length?a[3]:1;else{var g=a.replace("hsl","").replace("a","").replace("(","").replace(/\s+/g,"").replace(/%/g,"").replace(")","").split(",");b=Number(g[0])/360,c=Number(g[1])/100,d=Number(g[2])/100,e=4===g.length?parseInt(g[3]):1}this.setHSL(b,c,d),this._a=e}}),L.hslColor=function(a){return new L.HSLColor(a)},L.Animation=L.Class.extend({initialize:function(a,b){this._easeFunction=a,this._animateFrame=b},run:function(a,b){this.stop(),this._el=a,this._inProgress=!0,this._duration=b.duration||.25,this._animationOptions=b,this._startTime=+new Date,this.fire("start"),this._animate()},stop:function(){this._inProgress&&(this._step(),this._complete())},_animate:function(){this._animId=L.Util.requestAnimFrame(this._animate,this),this._step()},_step:function(){var a=+new Date-this._startTime,b=1e3*this._duration;b>a?this._runFrame(this._easeFunction(a/b)):(this._runFrame(1),this._complete())},_runFrame:function(a){this._animateFrame(a),this.fire("step")},_complete:function(){L.Util.cancelAnimFrame(this._animId),this._inProgress=!1,this.fire("end")}}),// @preserve This product includes color specifications and designs developed by Cynthia Brewer (http://colorbrewer.org/).
L.ColorBrewer={Sequential:{YlGn:{3:["#f7fcb9","#addd8e","#31a354"],4:["#ffffcc","#c2e699","#78c679","#238443"],5:["#ffffcc","#c2e699","#78c679","#31a354","#006837"],6:["#ffffcc","#d9f0a3","#addd8e","#78c679","#31a354","#006837"],7:["#ffffcc","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],8:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],9:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"]},YlGnBu:{3:["#edf8b1","#7fcdbb","#2c7fb8"],4:["#ffffcc","#a1dab4","#41b6c4","#225ea8"],5:["#ffffcc","#a1dab4","#41b6c4","#2c7fb8","#253494"],6:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#2c7fb8","#253494"],7:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],8:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],9:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"]},GnBu:{3:["#e0f3db","#a8ddb5","#43a2ca"],4:["#f0f9e8","#bae4bc","#7bccc4","#2b8cbe"],5:["#f0f9e8","#bae4bc","#7bccc4","#43a2ca","#0868ac"],6:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#43a2ca","#0868ac"],7:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],8:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],9:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"]},BuGn:{3:["#e5f5f9","#99d8c9","#2ca25f"],4:["#edf8fb","#b2e2e2","#66c2a4","#238b45"],5:["#edf8fb","#b2e2e2","#66c2a4","#2ca25f","#006d2c"],6:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#2ca25f","#006d2c"],7:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],8:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],9:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"]},PuBuGn:{3:["#ece2f0","#a6bddb","#1c9099"],4:["#f6eff7","#bdc9e1","#67a9cf","#02818a"],5:["#f6eff7","#bdc9e1","#67a9cf","#1c9099","#016c59"],6:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#1c9099","#016c59"],7:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],8:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],9:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"]},PuBu:{3:["#ece7f2","#a6bddb","#2b8cbe"],4:["#f1eef6","#bdc9e1","#74a9cf","#0570b0"],5:["#f1eef6","#bdc9e1","#74a9cf","#2b8cbe","#045a8d"],6:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#2b8cbe","#045a8d"],7:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],8:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],9:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"]},BuPu:{3:["#e0ecf4","#9ebcda","#8856a7"],4:["#edf8fb","#b3cde3","#8c96c6","#88419d"],5:["#edf8fb","#b3cde3","#8c96c6","#8856a7","#810f7c"],6:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8856a7","#810f7c"],7:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],8:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],9:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"]},RdPu:{3:["#fde0dd","#fa9fb5","#c51b8a"],4:["#feebe2","#fbb4b9","#f768a1","#ae017e"],5:["#feebe2","#fbb4b9","#f768a1","#c51b8a","#7a0177"],6:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#c51b8a","#7a0177"],7:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],8:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],9:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"]},PuRd:{3:["#e7e1ef","#c994c7","#dd1c77"],4:["#f1eef6","#d7b5d8","#df65b0","#ce1256"],5:["#f1eef6","#d7b5d8","#df65b0","#dd1c77","#980043"],6:["#f1eef6","#d4b9da","#c994c7","#df65b0","#dd1c77","#980043"],7:["#f1eef6","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],8:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],9:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"]},OrRd:{3:["#fee8c8","#fdbb84","#e34a33"],4:["#fef0d9","#fdcc8a","#fc8d59","#d7301f"],5:["#fef0d9","#fdcc8a","#fc8d59","#e34a33","#b30000"],6:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#e34a33","#b30000"],7:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],8:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],9:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"]},YlOrRd:{3:["#ffeda0","#feb24c","#f03b20"],4:["#ffffb2","#fecc5c","#fd8d3c","#e31a1c"],5:["#ffffb2","#fecc5c","#fd8d3c","#f03b20","#bd0026"],6:["#ffffb2","#fed976","#feb24c","#fd8d3c","#f03b20","#bd0026"],7:["#ffffb2","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],8:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],9:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"]},YlOrBr:{3:["#fff7bc","#fec44f","#d95f0e"],4:["#ffffd4","#fed98e","#fe9929","#cc4c02"],5:["#ffffd4","#fed98e","#fe9929","#d95f0e","#993404"],6:["#ffffd4","#fee391","#fec44f","#fe9929","#d95f0e","#993404"],7:["#ffffd4","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],8:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],9:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"]},Purples:{3:["#efedf5","#bcbddc","#756bb1"],4:["#f2f0f7","#cbc9e2","#9e9ac8","#6a51a3"],5:["#f2f0f7","#cbc9e2","#9e9ac8","#756bb1","#54278f"],6:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#756bb1","#54278f"],7:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],8:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],9:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"]},Blues:{3:["#deebf7","#9ecae1","#3182bd"],4:["#eff3ff","#bdd7e7","#6baed6","#2171b5"],5:["#eff3ff","#bdd7e7","#6baed6","#3182bd","#08519c"],6:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#3182bd","#08519c"],7:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],8:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],9:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"]},Greens:{3:["#e5f5e0","#a1d99b","#31a354"],4:["#edf8e9","#bae4b3","#74c476","#238b45"],5:["#edf8e9","#bae4b3","#74c476","#31a354","#006d2c"],6:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#31a354","#006d2c"],7:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],8:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],9:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"]},Oranges:{3:["#fee6ce","#fdae6b","#e6550d"],4:["#feedde","#fdbe85","#fd8d3c","#d94701"],5:["#feedde","#fdbe85","#fd8d3c","#e6550d","#a63603"],6:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#e6550d","#a63603"],7:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],8:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],9:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"]},Reds:{3:["#fee0d2","#fc9272","#de2d26"],4:["#fee5d9","#fcae91","#fb6a4a","#cb181d"],5:["#fee5d9","#fcae91","#fb6a4a","#de2d26","#a50f15"],6:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#de2d26","#a50f15"],7:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],8:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],9:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"]},Greys:{3:["#f0f0f0","#bdbdbd","#636363"],4:["#f7f7f7","#cccccc","#969696","#525252"],5:["#f7f7f7","#cccccc","#969696","#636363","#252525"],6:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#636363","#252525"],7:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],8:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],9:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"]}},Diverging:{PuOr:{3:["#f1a340","#f7f7f7","#998ec3"],4:["#e66101","#fdb863","#b2abd2","#5e3c99"],5:["#e66101","#fdb863","#f7f7f7","#b2abd2","#5e3c99"],6:["#b35806","#f1a340","#fee0b6","#d8daeb","#998ec3","#542788"],7:["#b35806","#f1a340","#fee0b6","#f7f7f7","#d8daeb","#998ec3","#542788"],8:["#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788"],9:["#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788"],10:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],11:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"]},BrBG:{3:["#d8b365","#f5f5f5","#5ab4ac"],4:["#a6611a","#dfc27d","#80cdc1","#018571"],5:["#a6611a","#dfc27d","#f5f5f5","#80cdc1","#018571"],6:["#8c510a","#d8b365","#f6e8c3","#c7eae5","#5ab4ac","#01665e"],7:["#8c510a","#d8b365","#f6e8c3","#f5f5f5","#c7eae5","#5ab4ac","#01665e"],8:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e"],9:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e"],10:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],11:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"]},PRGn:{3:["#af8dc3","#f7f7f7","#7fbf7b"],4:["#7b3294","#c2a5cf","#a6dba0","#008837"],5:["#7b3294","#c2a5cf","#f7f7f7","#a6dba0","#008837"],6:["#762a83","#af8dc3","#e7d4e8","#d9f0d3","#7fbf7b","#1b7837"],7:["#762a83","#af8dc3","#e7d4e8","#f7f7f7","#d9f0d3","#7fbf7b","#1b7837"],8:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837"],9:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837"],10:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],11:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"]},PiYG:{3:["#e9a3c9","#f7f7f7","#a1d76a"],4:["#d01c8b","#f1b6da","#b8e186","#4dac26"],5:["#d01c8b","#f1b6da","#f7f7f7","#b8e186","#4dac26"],6:["#c51b7d","#e9a3c9","#fde0ef","#e6f5d0","#a1d76a","#4d9221"],7:["#c51b7d","#e9a3c9","#fde0ef","#f7f7f7","#e6f5d0","#a1d76a","#4d9221"],8:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221"],9:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221"],10:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],11:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"]},RdBu:{3:["#ef8a62","#f7f7f7","#67a9cf"],4:["#ca0020","#f4a582","#92c5de","#0571b0"],5:["#ca0020","#f4a582","#f7f7f7","#92c5de","#0571b0"],6:["#b2182b","#ef8a62","#fddbc7","#d1e5f0","#67a9cf","#2166ac"],7:["#b2182b","#ef8a62","#fddbc7","#f7f7f7","#d1e5f0","#67a9cf","#2166ac"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"]},RdGy:{3:["#ef8a62","#ffffff","#999999"],4:["#ca0020","#f4a582","#bababa","#404040"],5:["#ca0020","#f4a582","#ffffff","#bababa","#404040"],6:["#b2182b","#ef8a62","#fddbc7","#e0e0e0","#999999","#4d4d4d"],7:["#b2182b","#ef8a62","#fddbc7","#ffffff","#e0e0e0","#999999","#4d4d4d"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"]},RdYlBu:{3:["#fc8d59","#ffffbf","#91bfdb"],4:["#d7191c","#fdae61","#abd9e9","#2c7bb6"],5:["#d7191c","#fdae61","#ffffbf","#abd9e9","#2c7bb6"],6:["#d73027","#fc8d59","#fee090","#e0f3f8","#91bfdb","#4575b4"],7:["#d73027","#fc8d59","#fee090","#ffffbf","#e0f3f8","#91bfdb","#4575b4"],8:["#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4"],9:["#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"]},Spectral:{3:["#fc8d59","#ffffbf","#99d594"],4:["#d7191c","#fdae61","#abdda4","#2b83ba"],5:["#d7191c","#fdae61","#ffffbf","#abdda4","#2b83ba"],6:["#d53e4f","#fc8d59","#fee08b","#e6f598","#99d594","#3288bd"],7:["#d53e4f","#fc8d59","#fee08b","#ffffbf","#e6f598","#99d594","#3288bd"],8:["#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd"],9:["#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd"],10:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],11:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"]},RdYlGn:{3:["#fc8d59","#ffffbf","#91cf60"],4:["#d7191c","#fdae61","#a6d96a","#1a9641"],5:["#d7191c","#fdae61","#ffffbf","#a6d96a","#1a9641"],6:["#d73027","#fc8d59","#fee08b","#d9ef8b","#91cf60","#1a9850"],7:["#d73027","#fc8d59","#fee08b","#ffffbf","#d9ef8b","#91cf60","#1a9850"],8:["#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850"],9:["#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"]}},Qualitative:{Accent:{3:["#7fc97f","#beaed4","#fdc086"],4:["#7fc97f","#beaed4","#fdc086","#ffff99"],5:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0"],6:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f"],7:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17"],8:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"]},Dark2:{3:["#1b9e77","#d95f02","#7570b3"],4:["#1b9e77","#d95f02","#7570b3","#e7298a"],5:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e"],6:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02"],7:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d"],8:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"]},Paired:{3:["#a6cee3","#1f78b4","#b2df8a"],4:["#a6cee3","#1f78b4","#b2df8a","#33a02c"],5:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99"],6:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c"],7:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f"],8:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00"],9:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6"],10:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a"],11:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99"],12:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"]},Pastel1:{3:["#fbb4ae","#b3cde3","#ccebc5"],4:["#fbb4ae","#b3cde3","#ccebc5","#decbe4"],5:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6"],6:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc"],7:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd"],8:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec"],9:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},Pastel2:{3:["#b3e2cd","#fdcdac","#cbd5e8"],4:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4"],5:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9"],6:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae"],7:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc"],8:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"]},Set1:{3:["#e41a1c","#377eb8","#4daf4a"],4:["#e41a1c","#377eb8","#4daf4a","#984ea3"],5:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00"],6:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33"],7:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628"],8:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf"],9:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"]},Set2:{3:["#66c2a5","#fc8d62","#8da0cb"],4:["#66c2a5","#fc8d62","#8da0cb","#e78ac3"],5:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854"],6:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f"],7:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494"],8:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"]},Set3:{3:["#8dd3c7","#ffffb3","#bebada"],4:["#8dd3c7","#ffffb3","#bebada","#fb8072"],5:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3"],6:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462"],7:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69"],8:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5"],9:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9"],10:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd"],11:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5"],12:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"]}}},L.Palettes={huePalette:function(a,b,c,d,e){return new L.HSLHueFunction(new L.Point(a,c),new L.Point(b,d),e)},luminosityPalette:function(a,b,c,d,e){return new L.HSLLuminosityFunction(new L.Point(a,c),new L.Point(b,d),e)},saturationPalette:function(a,b,c,d,e){return new L.HSLSaturationFunction(new L.Point(a,c),new L.Point(b,d),e)},rgbBlendPalette:function(a,b,c,d,e){return new L.RGBColorBlendFunction(a,b,c,d,e)},hslBlendPalette:function(a,b,c,d,e){return new L.HSLColorBlendFunction(a,b,c,d,e)},customColorPalette:function(a,b,c,d){return new L.CustomColorFunction(a,b,c,d)}},L.DynamicColorPalettes={rainbow:{text:"Rainbow",getPalette:function(a,b,c){return L.Palettes.huePalette(a,b,0,300,c)}},greentored:{text:"Green - Red",getPalette:function(a,b,c){return L.Palettes.huePalette(a,b,120,0,c)}},yellowtored:{text:"Yellow - Red",getPalette:function(a,b,c){return L.Palettes.huePalette(a,b,60,0,c)}},orangetored:{text:"Orange - Red",getPalette:function(a,b,c){return L.Palettes.huePalette(a,b,30,0,c)}},redtopurple:{text:"Red - Purple",getPalette:function(a,b,c){return L.Palettes.huePalette(a,b,360,270,c)}},bluetored:{text:"Blue - Red",getPalette:function(a,b,c){return L.Palettes.huePalette(a,b,210,360,c)}},bluetored2:{text:"Blue - Red 2",getPalette:function(a,b,c){return L.Palettes.huePalette(a,b,180,0,c)}},whitetored:{text:"White - Red",getPalette:function(a,b){return L.Palettes.luminosityPalette(a,b,1,.5,L.Util.extend(option,{outputHue:0}))}},whitetoorange:{text:"White - Orange",getPalette:function(a,b){return L.Palettes.luminosityPalette(a,b,1,.5,L.Util.extend(option,{outputHue:30}))}},whitetoyellow:{text:"White - Yellow",getPalette:function(a,b){return L.Palettes.luminosityPalette(a,b,1,.5,L.Util.extend(option,{outputHue:60}))}},whitetogreen:{text:"White - Green",getPalette:function(a,b){return L.Palettes.luminosityPalette(a,b,1,.5,L.Util.extend(option,{outputHue:120}))}},whitetoltblue:{text:"White - Lt. Blue",getPalette:function(a,b){return L.Palettes.luminosityPalette(a,b,1,.5,L.Util.extend(option,{outputHue:180}))}},whitetoblue:{text:"White - Blue",getPalette:function(a,b){return L.Palettes.luminosityPalette(a,b,1,.5,L.Util.extend(option,{outputHue:240}))}},whitetopurple:{text:"White - Purple",getPalette:function(a,b){return L.Palettes.luminosityPalette(a,b,1,.5,L.Util.extend(option,{outputHue:270}))}},graytored:{text:"Gray - Red",getPalette:function(a,b){return L.Palettes.saturationPalette(a,b,0,1,L.Util.extend(option,{outputHue:0}))}},graytoorange:{text:"Gray - Orange",getPalette:function(a,b){return L.Palettes.saturationPalette(a,b,0,1,L.Util.extend(option,{outputHue:30}))}},graytoyellow:{text:"Gray - Yellow",getPalette:function(a,b){return L.Palettes.saturationPalette(a,b,0,1,L.Util.extend(option,{outputHue:60}))}},graytogreen:{text:"Gray - Green",getPalette:function(a,b){return L.Palettes.saturationPalette(a,b,0,1,L.Util.extend(option,{outputHue:120}))}},graytoltblue:{text:"Gray - Lt. Blue",getPalette:function(a,b){return L.Palettes.saturationPalette(a,b,0,1,L.Util.extend(option,{outputHue:180}))}},graytoblue:{text:"Gray - Blue",getPalette:function(a,b){return L.Palettes.saturationPalette(a,b,0,1,L.Util.extend(option,{outputHue:240}))}},graytopurple:{text:"Gray - Purple",getPalette:function(a,b){return L.Palettes.saturationPalette(a,b,0,1,L.Util.extend(option,{outputHue:270}))}}},L.DynamicPaletteElement=L.Class.extend({initialize:function(a,b){this._key=a,this._dynamicPalette=b},generate:function(a){var b=L.DomUtil.create("div","palette"),c=a.count,d=this._dynamicPalette.getPalette(0,c-1),e=a.width,f=!0;a.showText&&(f=a.showText),b.setAttribute("data-palette-key",this._key),this._dynamicPalette.text&&f&&(L.DomUtil.create("div","palette-text",b).innerHTML='<i class="icon-ok hidden"></i>'+this._dynamicPalette.text);var g=e/c;a.className&&L.DomUtil.addClass(b,a.className);for(var h=0;c>h;++h){var i=L.DomUtil.create("i","palette-element");for(var j in d){var k=d[j],l=k.evaluate?k.evaluate(h):k;L.StyleConverter.setCSSProperty(i,j,l)}i.style.width=g+"px",b.appendChild(i)}return b}}),L.RegularPolygon=L.Polygon.extend({statics:{R:6378.137,M_PER_KM:1e3},initialize:function(a,b){this._centerLatLng=a,L.Util.setOptions(this,b),L.Polygon.prototype.initialize.call(this,this._getLatLngs(),b)},options:{fill:!0,radius:1e3,numberOfSides:4,rotation:0,maxDegrees:360},getLatLng:function(){return this._centerLatLng},setRadius:function(a){this.options.radius=a,this._latlngs=this._getLatLngs(),this.redraw()},_getLatLngs:function(){for(var a,b=this.options.maxDegrees||360,c=b/Math.max(this.options.numberOfSides,3),d=b+this.options.rotation,e=this.options.rotation,f=[];d>e;)a=this._getPoint(e),f.push(a),e+=c;return f},_getPoint:function(a){var b=function(a){return a*L.LatLng.DEG_TO_RAD},c=function(a){return a*L.LatLng.RAD_TO_DEG},d=b(a),e=this.options.radius/L.RegularPolygon.M_PER_KM/L.RegularPolygon.R,f=b(this._centerLatLng.lat),g=b(this._centerLatLng.lng),h=Math.asin(Math.sin(f)*Math.cos(e)+Math.cos(f)*Math.sin(e)*Math.cos(d)),i=g+Math.atan2(Math.sin(d)*Math.sin(e)*Math.cos(f),Math.cos(e)-Math.sin(f)*Math.sin(h));return h=c(h),i=c(i),new L.LatLng(h,i)},toGeoJSON:function(){for(var a={type:"Feature",geometry:{type:"Polygon",coordinates:[[],[]]},properties:this.options},b=0;b<this._latlngs.length;++b){var c=this._latlngs[b];a.geometry.coordinates[0].push([c.lng,c.lat])}return a}}),L.regularPolygon=function(a,b){return new L.RegularPolygon(a,b)},L.Path.XLINK_NS="http://www.w3.org/1999/xlink";var TextFunctions=TextFunctions||{__updatePath:L.Path.prototype._updatePath,_updatePath:function(){if(this.__updatePath.call(this),this.options.text&&this._createText(this.options.text),this.options.wordCloud){var a=this.options.wordCloud;if(a.words.length>0){var b=this;setTimeout(function(){b._createWordCloudPattern(a)},0)}}},_initText:function(){this.options.text&&this._createText(this.options.text)},getTextAnchor:function(){return this._point?this._point:void 0},setTextAnchor:function(a){this._text&&(this._text.setAttribute("x",a.x),this._text.setAttribute("y",a.y))},_createText:function(a){this._text&&this._container.removeChild(this._text),this._pathDef&&this._defs.removeChild(this._pathDef);var b=function(a,b){var c="";for(var d in b)c+=d+": "+b[d]+";";return a.setAttribute("style",c),a},c=function(a,b){for(var c in b)a.setAttribute(c,b[c]);return a};this._text=this._createElement("text");var d=document.createTextNode(a.text);if(a.path){var e=a.path,f=L.Util.guid(),g=this._createElement("path");g.setAttribute("d",this._path.getAttribute("d")),g.setAttribute("id",f),this._defs||(this._defs=this._createElement("defs"),this._container.appendChild(this._defs)),this._defs.appendChild(g),this._pathDef=g;var h=this._createElement("textPath");e.startOffset&&h.setAttribute("startOffset",e.startOffset),e.attr&&c(h,e.attr),e.style&&b(h,e.style),h.setAttributeNS(L.Path.XLINK_NS,"xlink:href","#"+f),h.appendChild(d),this._text.appendChild(h)}else{this._text.appendChild(d);var i=this.getTextAnchor();this.setTextAnchor(i)}a.className?this._text.setAttribute("class",a.className):this._text.setAttribute("class","leaflet-svg-text"),a.attr&&c(this._text,a.attr),a.style&&b(this._text,a.style),this._container.appendChild(this._text)}},PathFunctions=PathFunctions||{__updateStyle:L.Path.prototype._updateStyle,_createDefs:function(){this._defs=this._createElement("defs"),this._container.appendChild(this._defs)},_createMarker:function(a,b){this._defs||this._createDefs(),this._markers=this._markers||{},this._markerPath=this._markerPath||{},this._markers[a]&&this._defs.removeChild(this._markers[a]),this._markers[a]=this._createElement("marker");var c=L.Util.guid(),d=b.exaggeration||2,e=2*d;this._markers[a].setAttribute("id",c),this._markers[a].setAttribute("markerWidth",e),this._markers[a].setAttribute("markerHeight",e),this._markers[a].setAttribute("refX",d),this._markers[a].setAttribute("refY",d),this._markers[a].setAttribute("orient","auto"),this._markers[a].setAttribute("markerUnits","strokeWidth"),this._markerPath[a]=this._createElement("path"),b.reverse?this._markerPath[a].setAttribute("d","M0,"+d+" L"+e+","+e+" L"+e+",0 L0,"+d):this._markerPath[a].setAttribute("d","M"+e+","+d+" L0,"+e+" L0,0 L"+e+","+d),this._markerPath[a].setAttribute("style","fill: "+this.options.color+"; opacity: "+this.options.opacity),this._markers[a].appendChild(this._markerPath[a]),this._defs.appendChild(this._markers[a])},_createGradient:function(a){this._defs||this._createDefs(),a=a!==!0?L.extend({},a):{};var b,c=this._gradient,d=a.gradientType||"linear";if(c||(c=this._createElement(d+"Gradient"),c.id=L.stamp(c),this._defs.appendChild(c),this._gradient=c),"radial"===d)b=a.radial||{cx:"50%",cy:"50%",r:"50%",fx:"50%",fy:"50%"};else{var e=a.vector||[["0%","0%"],["100%","100%"]];b={x1:e[0][0],x2:e[1][0],y1:e[0][1],y2:e[1][1]}}b.id=c.id,a.gradientUnits&&c.setAttribute("gradientUnits",a.gradientUnits);var f,g=a.stops||[{offset:"0%",style:{color:"rgb(255, 255, 255)",opacity:1}},{offset:"60%",style:{color:this.options.fillColor||this.options.color,opacity:1}}];for(f in b)c.setAttribute(f,b[f]);for(var h=c.childNodes,i=h.length,j=0,k=g.length;k>j;++j){var l=g[j],m=i>j?h[j]:this._createElement("stop");l.style=l.style||{};for(f in l){var n=l[f];if("style"===f){var o="";n.color=n.color||this.options.fillColor||this.options.color,n.opacity="undefined"==typeof n.opacity?1:n.opacity;for(var p in n)o+="stop-"+p+":"+n[p]+";";n=o}m.setAttribute(f,n)}j>=i&&c.appendChild(m)}return this._gradient=c,b.id},_createDropShadow:function(a){this._defs||this._createDefs(),this._dropShadow&&this._defs.removeChild(this._dropShadow);var b=L.Util.guid(),c=this._createElement("filter"),d=this._createElement("feOffset"),e=this._createElement("feGaussianBlur"),f=this._createElement("feBlend");a=a||{width:"200%",height:"200%"},a.id="filter"+b;var g;for(g in a)c.setAttribute(g,a[g]);var h={result:"offOut","in":"SourceAlpha",dx:"2",dy:"2"},i={result:"blurOut","in":"offOut",stdDeviation:"2"},j={"in":"SourceGraphic",in2:"blurOut",mode:"lighten"};for(g in h)d.setAttribute(g,h[g]);for(g in i)e.setAttribute(g,i[g]);for(g in j)f.setAttribute(g,j[g]);c.appendChild(d),c.appendChild(e),c.appendChild(f),this._dropShadow=c,this._defs.appendChild(c)},_createCustomElement:function(a,b){var c=this._createElement(a);for(var d in b)b.hasOwnProperty(d)&&c.setAttribute(d,b[d]);return c},_createImage:function(a){var b=this._createElement("image");return b.setAttribute("width",a.width),b.setAttribute("height",a.height),b.setAttribute("x",a.x||0),b.setAttribute("y",a.y||0),b.setAttributeNS(L.Path.XLINK_NS,"xlink:href",a.url),b},_createPattern:function(a){this._pattern&&this._defs.removeChild(this._pattern);var b=this._createCustomElement("pattern",a);return this._pattern=b,b},_createWordCloudPattern:function(a){var b="",c=a.patternOptions=a.patternOptions||{};this._defs||this._createDefs(),a.textField=a.textField||"key",a.countField=a.countField||"doc_count";for(var d=0;d<a.words.length;++d){var e=a.words[d];b+=e[a.textField]+"_"+e[a.countField]}if(b!==this._wordCloudGuid){this._wordCloudGuid=b;var f=this._createElement("path");f.setAttribute("d",this._path.getAttribute("d")),f.setAttribute("id",b),c.id=b,c.patternUnits=c.patternUnits||"userSpaceOnUse";var g=this.getBounds(),h=new L.Bounds(this._map.project(g.getNorthWest()),this._map.project(g.getSouthEast())),i=h.getSize().x/h.getSize().y;c.width=c.width||500,c.height=c.height||500*i||500,c.width=Math.min(c.width,c.height),c.height=c.width,this._wordCloud=this._createElement("g"),this._wordPattern=this._createPattern(c),this._wordPattern.appendChild(this._wordCloud),this._defs.appendChild(this._wordPattern),this._createWordCloud(this._wordCloud,a)}var j=this._path.getAttribute("fill");-1===j.indexOf(this._wordCloudGuid)&&this._path.setAttribute("fill","url(#"+this._wordCloudGuid+")")},_createWordCloud:function(a,b){var c=b.patternOptions.width,d=b.patternOptions.height,e=b.words,f=(this.getTextAnchor(),this._createElement("rect")),g=b.countField,h=b.textField,i=b.rotation||function(){return 0};f.setAttribute("width",c),f.setAttribute("height",d),f.style.fill=this.options.fillColor||"#000",f.setAttribute("transform","translate("+-c/2+","+-d/2+")"),a.appendChild(f);var j=function(a,e){return function(a){"svg"+L.Util.guid();d3.select(e).attr("transform","translate("+c/2+","+d/2+")").selectAll("text").data(a).enter().append("text").style("font-size",function(a){return a.size+"px"}).style("font-family",b.fontFamily||"Impact").style("fill",function(a,b){return k(b)}).attr("text-anchor","middle").attr("transform",function(a){return"translate("+[a.x,a.y]+")rotate("+a.rotate+")"}).text(function(a){return a[h]})}},k=b.textFillColor||d3.scale.category20(),l=d3.scale.linear(),m=e[0][g],n=e[e.length-1][g],o=b.fontSize||d3.scale.log().domain([n,m]).range([10,40]);return l.domain([0,10]).range([-60,60]),d3.layout.cloud().size([c,d]).spiral("rectangular").timeInterval(1/0).words(e).padding(5).rotate(i).font(b.fontFamily||"Impact").fontSize(function(a){return o(a[g])}).on("end",j(e,a)).start(),a},_createShape:function(a,b){this._shape&&this._container.removeChild(this._shape);var c=this._createCustomElement(a,b);return c},_applyCustomStyles:function(){},_createFillPattern:function(a){var b=L.Util.guid(),c=a.pattern;c.id=b,c.patternUnits=c.patternUnits||"objectBoundingBox";var d=this._createPattern(c),e=this._createImage(a.image);e.setAttributeNS(L.Path.XLINK_NS,"xlink:href",a.url),d.appendChild(e),this._defs||this._createDefs(),this._defs.appendChild(d),this._path.setAttribute("fill","url(#"+b+")")},_getDefaultDiameter:function(a){return 1.75*a},_createShapeImage:function(a){a=a||{};var b=L.Util.guid(),c=this.options.radius||Math.max(this.options.radiusX,this.options.radiusY),d=this._getDefaultDiameter(c),e=a.imageSize||new L.Point(d,d),f=a.radius||d/2,g=a.shape||{circle:{r:f,cx:0,cy:0}},h=a.pattern||{width:e.x,height:e.y,x:0,y:0},i=Object.keys(g),j=i.length>0?i[0]:"circle";
g[j].fill="url(#"+b+")";var k=this._createShape(j,g[j]);this.options.clickable&&k.setAttribute("class","leaflet-clickable"),h.id=b,h.patternUnits=h.patternUnits||"objectBoundingBox";var l=this._createPattern(h);a=a.image||{width:e.x,height:e.y,x:0,y:0,url:this.options.imageCircleUrl};var m=this._createImage(a);m.setAttributeNS(L.Path.XLINK_NS,"xlink:href",a.url),l.appendChild(m),this._defs.appendChild(l),this._container.insertBefore(k,this._defs),this._shape=k;var n=this;this._shape.addEventListener("mouseover",function(){n.fire("mouseover")}),this._shape.addEventListener("mouseout",function(){n.fire("mouseout")}),this._shape.addEventListener("mousemove",function(){n.fire("mousemove")});var o=this.getTextAnchor();if(this._shape&&o)if("circle"===this._shape.tagName||"ellipse"===this._shape.tagName)this._shape.setAttribute("cx",o.x),this._shape.setAttribute("cy",o.y);else{var p=this._shape.getAttribute("width"),q=this._shape.getAttribute("height");this._shape.setAttribute("x",o.x-Number(p)/2),this._shape.setAttribute("y",o.y-Number(q)/2)}},_updateStyle:function(a){this.__updateStyle.call(this,a);var b=a?a:this;if(b.options.stroke&&(b.options.lineCap&&b._path.setAttribute("stroke-linecap",b.options.lineCap),b.options.lineJoin&&b._path.setAttribute("stroke-linejoin",b.options.lineJoin)),b.options.markers)for(var c in b.options.markers)b.options.markers.hasOwnProperty(c)&&(b._createMarker(c,b.options.markers[c]),b._path.setAttribute("marker-"+c,"url(#"+b._markers[c].getAttribute("id")+")"));if(b.options.gradient){var d=b._createGradient(b.options.gradient);b.options.stroke&&!b.options.fill?b._path.setAttribute("stroke","url(#"+d+")"):b._path.setAttribute("fill","url(#"+d+")")}else b.options.fill||b._path.setAttribute("fill","none");if(b.options.dropShadow?(b._createDropShadow(),b._path.setAttribute("filter","url(#"+b._dropShadow.getAttribute("id")+")")):b._path.removeAttribute("filter"),b.options.fillPattern&&b._createFillPattern(b.options.fillPattern),b.options.wordCloud){var e=b.options.wordCloud;if(e.words.length>0){var f=this;setTimeout(function(){f._createWordCloudPattern(e)},0)}}b._applyCustomStyles()}};if(L.SVG){var SVGStyleFunctions=L.Util.extend(PathFunctions,{__updateStyle:L.SVG.prototype._updateStyle}),SVGTextFunctions=L.Util.extend(TextFunctions,{__updatePath:L.SVG.prototype._updatePath});L.SVG.include(SVGStyleFunctions),L.SVG.include(SVGTextFunctions)}var LineTextFunctions=L.extend({},TextFunctions);LineTextFunctions.__updatePath=L.Polyline.prototype._updatePath,LineTextFunctions.getCenter=function(){var a,b,c,d,e,f,g=this._latlngs,h=g.length;for(a=0,b=h-1,area=0,lat=0,lng=0;h>a;b=a++)c=g[a],d=g[b],e=c.lat*d.lng-d.lat*c.lng,lat+=(c.lat+d.lat)*e,lng+=(c.lng+d.lng)*e,area+=e/2;return f=area?new L.LatLng(lat/(6*area),lng/(6*area)):g[0],f.area=area,f},LineTextFunctions.getTextAnchor=function(){var a=this.getCenter();return this._map.latLngToLayerPoint(a)},L.Polyline.include(LineTextFunctions),L.CircleMarker.include(TextFunctions),L.Path.include(PathFunctions),L.Polygon.include(PathFunctions),L.Polyline.include(PathFunctions),L.CircleMarker.include(PathFunctions),L.CircleMarker=L.CircleMarker.extend({_applyCustomStyles:function(){(this.options.shapeImage||this.options.imageCircleUrl)&&this._createShapeImage(this.options.shapeImage)},getTextAnchor:function(){var a=null;return this._point&&(a=new L.Point(this._point.x,this._point.y)),a}}),L.Point.prototype.rotate=function(a,b){var c=this.distanceTo(b),d=a*L.LatLng.DEG_TO_RAD+Math.atan2(this.y-b.y,this.x-b.x);this.x=b.x+c*Math.cos(d),this.y=b.y+c*Math.sin(d)},L.MapMarker=L.Path.extend({includes:TextFunctions,initialize:function(a,b){L.Path.prototype.initialize.call(this,b),this._latlng=a},options:{fill:!0,fillOpacity:1,opacity:1,radius:15,innerRadius:5,position:{x:0,y:0},rotation:0,numberOfSides:50,color:"#000000",fillColor:"#0000FF",weight:1,gradient:!0,dropShadow:!0,clickable:!0},setLatLng:function(a){return this._latlng=a,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints(),this.options.innerRadius>0&&(this._innerPoints=this._getPoints(!0).reverse())},getBounds:function(){var a=this._map,b=3*this.options.radius,c=a.project(this._latlng),d=new L.Point(c.x-this.options.radius,c.y),e=new L.Point(c.x+this.options.radius,c.y-b),f=a.unproject(d),g=a.unproject(e);return new L.LatLngBounds(f,g)},getLatLng:function(){return this._latlng},setRadius:function(a){return this.options.radius=a,this.redraw()},setInnerRadius:function(a){return this.options.innerRadius=a,this.redraw()},setRotation:function(a){return this.options.rotation=a,this.redraw()},setNumberOfSides:function(a){return this.options.numberOfSides=a,this.redraw()},getPathString:function(){var a=this.getTextAnchor();if(this._shape)if("circle"===this._shape.tagName||"ellipse"===this._shape.tagName)this._shape.setAttribute("cx",a.x),this._shape.setAttribute("cy",a.y);else{var b=this._shape.getAttribute("width"),c=this._shape.getAttribute("height");this._shape.setAttribute("x",a.x-Number(b)/2),this._shape.setAttribute("y",a.y-Number(c)/2)}return this._path.setAttribute("shape-rendering","geometricPrecision"),new L.SVGPathBuilder(this._points,this._innerPoints).build(6)},getTextAnchor:function(){var a=null;return this._point&&(a=new L.Point(this._point.x,this._point.y-2*this.options.radius)),a},_getPoints:function(a){var b,c,d=a?360:210,e=a?d/Math.max(this.options.numberOfSides,3):d/50,f=a?d+this.options.rotation:d,g=a?this.options.rotation:-30,h=[],i=this.options.radius,j=Math.sqrt(.75),k=function(a){return a*L.LatLng.DEG_TO_RAD},l=this._point;for(a||(h.push(l),h.push(new L.Point(l.x+j*i,l.y-1.5*i)));f>g;)c=k(g),b=this._getPoint(c,i,a),h.push(b),g+=e;return a||h.push(new L.Point(l.x-j*i,l.y-1.5*i)),h},_getPoint:function(a,b,c){var d=b;return b=c?this.options.innerRadius:b,new L.Point(this._point.x+this.options.position.x+b*Math.cos(a),this._point.y-2*d+this.options.position.y-b*Math.sin(a))},_applyCustomStyles:function(){(this.options.shapeImage||this.options.imageCircleUrl)&&this._createShapeImage(this.options.shapeImage)},toGeoJSON:function(){return L.Util.pointToGeoJSON.call(this)}}),L.mapMarker=function(a,b){return new L.MapMarker(a,b)},L.RegularPolygonMarker=L.Path.extend({includes:TextFunctions,initialize:function(a,b){L.Path.prototype.initialize.call(this,b),this._latlng=a,this.options.numberOfSides=Math.max(this.options.numberOfSides,3)},options:{fill:!0,radiusX:10,radiusY:10,rotation:0,numberOfSides:3,position:{x:0,y:0},maxDegrees:360,gradient:!0,dropShadow:!1,clickable:!0},setLatLng:function(a){return this._latlng=a,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints(),(this.options.innerRadius||this.options.innerRadiusX&&this.options.innerRadiusY)&&(this._innerPoints=this._getPoints(!0).reverse())},getBounds:function(){var a=this._map,b=this.options.radius||this.options.radiusX,c=this.options.radius||this.options.radiusY,d=b*Math.cos(Math.PI/4),e=c*Math.sin(Math.PI/4),f=a.project(this._latlng),g=new L.Point(f.x-d,f.y+e),h=new L.Point(f.x+d,f.y-e),i=a.unproject(g),j=a.unproject(h);return new L.LatLngBounds(i,j)},setRadius:function(a){return this.options.radius=a,this.redraw()},setRadiusXY:function(a,b){return this.options.radius=null,this.options.radiusX=a,this.options.radiusY=b,this.redraw()},setInnerRadius:function(a){return this.options.innerRadius=a,this.redraw()},setInnerRadiusXY:function(a,b){return this.options.innerRadius=null,this.options.innerRadiusX=a,this.options.innerRadiusY=b,this.redraw()},setRotation:function(a){return this.options.rotation=a,this.redraw()},setNumberOfSides:function(a){return this.options.numberOfSides=a,this.redraw()},getLatLng:function(){return this._latlng},getPathString:function(){var a=this.getTextAnchor();if(this._shape)if("circle"===this._shape.tagName||"ellipse"===this._shape.tagName)this._shape.setAttribute("cx",a.x),this._shape.setAttribute("cy",a.y);else{var b=this._shape.getAttribute("width"),c=this._shape.getAttribute("height");this._shape.setAttribute("x",a.x-Number(b)/2),this._shape.setAttribute("y",a.y-Number(c)/2)}return this._path.setAttribute("shape-rendering","geometricPrecision"),new L.SVGPathBuilder(this._points,this._innerPoints).build(6)},_getPoints:function(a){for(var b,c,d=this.options.maxDegrees||360,e=d/Math.max(this.options.numberOfSides,3),f=d,g=0,h=[],i=a?this.options.innerRadius||this.options.innerRadiusX:this.options.radius||this.options.radiusX,j=a?this.options.innerRadius||this.options.innerRadiusY:this.options.radius||this.options.radiusY,k=function(a){return a*L.LatLng.DEG_TO_RAD};f>g;)c=k(g),b=this._getPoint(c,i,j),h.push(b),g+=e;return h},_getPoint:function(a,b,c){var d=this.options.position?this._point.add(new L.Point(this.options.position.x,this.options.position.y)):this._point,e=new L.Point(d.x+b*Math.cos(a),d.y+c*Math.sin(a));return e.rotate(this.options.rotation,d),e},_getDefaultDiameter:function(a){var b=Math.PI/this.options.numberOfSides,c=a*Math.cos(b);return 1.75*c},_applyCustomStyles:function(){(this.options.shapeImage||this.options.imageCircleUrl)&&this._createShapeImage(this.options.shapeImage)},toGeoJSON:function(){return L.Util.pointToGeoJSON.call(this)}}),L.regularPolygonMarker=function(a,b){return new L.RegularPolygonMarker(a,b)},L.StarMarker=L.RegularPolygonMarker.extend({options:{numberOfPoints:5,rotation:-15,maxDegrees:360,gradient:!0,dropShadow:!0},setNumberOfPoints:function(a){return this.options.numberOfPoints=a,this.redraw()},_getPoints:function(a){for(var b,c,d,e=this.options.maxDegrees||360,f=e/this.options.numberOfPoints,g=e,h=0,i=[],j=a?this.options.innerRadius||this.options.innerRadiusX:this.options.radius||this.options.radiusX,k=a?this.options.innerRadius||this.options.innerRadiusY:this.options.radius||this.options.radiusY,l=function(a){return a*L.LatLng.DEG_TO_RAD};g>h;)d=l(h),b=this._getPoint(d,j,k),c=this._getPoint(d+l(f)/2,j/2,k/2),i.push(b),i.push(c),h+=f;return i}}),L.starMarker=function(a,b){return new L.StarMarker(a,b)},L.TriangleMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:3,rotation:30,radius:5}}),L.triangleMarker=function(a,b){return new L.TriangleMarker(a,b)},L.DiamondMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:4,radiusX:5,radiusY:10}}),L.diamondMarker=function(a,b){return new L.DiamondMarker(a,b)},L.SquareMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:4,rotation:45,radius:5}}),L.squareMarker=function(a,b){return new L.SquareMarker(a,b)},L.PentagonMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:5,rotation:-18,radius:5}}),L.pentagonMarker=function(a,b){return new L.PentagonMarker(a,b)},L.HexagonMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:6,rotation:30,radius:5}}),L.hexagonMarker=function(a,b){return new L.HexagonMarker(a,b)},L.OctagonMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:8,rotation:22.5,radius:5}}),L.octagonMarker=function(a,b){return new L.OctagonMarker(a,b)},L.SVGMarker=L.Path.extend({initialize:function(a,b){L.Path.prototype.initialize.call(this,b),this._svg=b.svg,0===this._svg.indexOf("<")&&(this._data=this._svg),this._latlng=a},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng)},setLatLng:function(a){this._latlng=a,this.redraw()},getLatLng:function(){return this._latlng},getPathString:function(){var a=this,b=function(){for(var b=a._path.parentNode;"g"!==b.nodeName.toLowerCase();)b=b.parentNode;a.options.clickable&&b.setAttribute("class","leaflet-clickable");var c=a._data,d="svg"===c.nodeName.toLowerCase()?c.cloneNode(!0):c.querySelector("svg").cloneNode(!0);a.options.setStyle&&a.options.setStyle.call(a,d);var e=d.getAttribute("width"),f=d.getAttribute("height"),g=e?e.replace("px",""):"100%",h=f?f.replace("px",""):"100%";"100%"===g&&(g=a.options.size.x,h=a.options.size.y,d.setAttribute("width",g+(-1!==String(g).indexOf("%")?"":"px")),d.setAttribute("height",h+(-1!==String(h).indexOf("%")?"":"px")));var i=a.options.size||new L.Point(g,h),j=new L.Point(i.x/g,i.y/h),k=b.getElementsByTagName("svg");k.length>0&&k[0].parentNode.removeChild(k[0]),b.appendChild(d);var l=[],m=a.options.anchor||new L.Point(-i.x/2,-i.y/2),n=a._point.x+m.x,o=a._point.y+m.y;l.push("translate("+n+" "+o+")"),l.push("scale("+j.x+" "+j.y+")"),a.options.rotation&&l.push("rotate("+a.options.rotation+" "+g/2+" "+h/2+")"),b.setAttribute("transform",l.join(" "))};if(this._data)b();else{var c=new XMLHttpRequest;c.onreadystatechange=function(){4==this.readyState&&200==this.status&&(a._data=this.responseXML,b())},c.open("GET",this._svg,!0),c.send(null)}},toGeoJSON:function(){return pointToGeoJSON.call(this)}}),L.MarkerGroup=L.FeatureGroup.extend({initialize:function(a,b){L.FeatureGroup.prototype.initialize.call(this,b),this.setLatLng(a)},setStyle:function(){return this},setLatLng:function(a){return this._latlng=a,this.eachLayer(function(b){b.setLatLng&&b.setLatLng(a)}),this},getLatLng:function(){return this._latlng},toGeoJSON:function(){var a={type:"FeatureCollection",features:[]},b=function(a){return function(b){a.features.push(L.Util.pointToGeoJSON.call(b))}};return this.eachLayer(b(a)),a}}),L.BarMarker=L.Path.extend({initialize:function(a,b){L.Path.prototype.initialize.call(this,b),this._latlng=a},options:{fill:!0,width:2,maxHeight:10,position:{x:0,y:0},weight:1,color:"#000",opacity:1,gradient:!0,dropShadow:!1,lineCap:"square",lineJoin:"miter"},setLatLng:function(a){return this._latlng=a,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints()},getBounds:function(){var a=this._map,b=a.project(this._latlng),c=this.options.width/2,d=new L.Point(b.x-c,b.y),e=new L.Point(b.x+c,b.y-this.options.maxHeight),f=a.unproject(d),g=a.unproject(e);return new L.LatLngBounds(f,g)},getLatLng:function(){return this._latlng},getPathString:function(){return this._path.setAttribute("shape-rendering","crispEdges"),new L.SVGPathBuilder(this._points).build()},_getPoints:function(){var a,b,c,d,e=[],f=this._point.x+this.options.position.x,g=this._point.y+this.options.position.y,h=this.options.width/2,i=this.options.value/this.options.maxValue*this.options.maxHeight;return a=new L.Point(f+h,g),b=new L.Point(f+h,g-i),c=new L.Point(f-h,g-i),d=new L.Point(f-h,g),e=[a,b,c,d]}}),L.barMarker=function(a,b){return new L.BarMarker(a,b)},L.ChartMarker=L.FeatureGroup.extend({initialize:function(a,b){L.Util.setOptions(this,b),this._layers={},this._latlng=a,this._loadComponents()},setLatLng:function(a){return this._latlng=a,this.redraw()},getLatLng:function(){return this._latlng},_loadComponents:function(){},_highlight:function(a){return a.weight&&(a.weight*=2),a},_unhighlight:function(a){return a.weight&&(a.weight/=2),a},_bindMouseEvents:function(a){var b=this,c=this.options.tooltipOptions;a.on("mouseover",function(a){var d,e=this.options,f=e.key,g=e.value,h=a.layerPoint,i=h.x-this._point.x,j=h.y-this._point.y,k=e.iconSize,l=i,m=j,n=5;l=0>i?k.x-i+n:-i-n,m=0>j?k.y-j+n:-j-n,d=new L.Point(l,m);var o={},p=e.displayText?e.displayText(g):g;o[f]={name:e.displayName,value:p};var q=new L.LegendIcon(o,e,{className:"leaflet-div-icon",iconSize:c?c.iconSize:k,iconAnchor:d});e.marker=new L.Marker(b._latlng,{icon:q}),e=b._highlight(e),this.initialize(b._latlng,e),this.redraw(),this.setStyle(e),b.addLayer(e.marker)}),a.on("mouseout",function(){var a=this.options;a=b._unhighlight(a),this.initialize(b._latlng,a),this.redraw(),this.setStyle(a),b.removeLayer(a.marker)})},bindPopup:function(a,b){this.eachLayer(function(c){c.bindPopup(a,b)})},openPopup:function(a){for(var b in this._layers){var c=this._layers[b];a=a||this._latlng,c.openPopup(a);break}},closePopup:function(){for(var a in this._layers){var b=this._layers[a];latlng=latlng||this._latlng,b.closePopup();break}},redraw:function(){this.clearLayers(),this._loadComponents()},toGeoJSON:function(){return L.Util.pointToGeoJSON.call(this)}}),L.BarChartMarker=L.ChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},options:{weight:1,opacity:1,color:"#000",fill:!0,position:{x:0,y:0},width:10,offset:0,iconSize:new L.Point(50,40)},_loadComponents:function(){var a,b,c,d,e,f,g,h=this.options,i=Object.keys(this.options.data),j=i.length,k=this.options.width,l=this.options.offset||0,m=this.options.data,n=this.options.chartOptions;e=-(k*j+l*(j-1))/2+k/2,f=0;for(var o in m)a=m[o],g=n[o],b=g.minValue||0,c=g.maxValue||100,h.fillColor=g.fillColor||this.options.fillColor,h.value=a,h.minValue=b,h.maxValue=c,h.position={x:e,y:f},h.width=k,h.maxHeight=g.maxHeight||10,h.key=o,h.value=a,h.displayName=g.displayName,h.opacity=this.options.opacity||1,h.fillOpacity=this.options.fillOpacity||.7,h.weight=this.options.weight||1,h.color=g.color||this.options.color,h.displayText=g.displayText,d=new L.BarMarker(this._latlng,h),this._bindMouseEvents(d),this.addLayer(d),e+=k+l}}),L.RadialBarMarker=L.Path.extend({initialize:function(a,b){L.Path.prototype.initialize.call(this,b),this._latlng=a},options:{fill:!0,radius:10,rotation:0,numberOfSides:30,position:{x:0,y:0},gradient:!0,dropShadow:!1},setLatLng:function(a){return this._latlng=a,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints()},getBounds:function(){var a=this._map,b=this.options.radiusX||this.options.radius,c=this.options.radiusY||this.options.radius,d=b*Math.cos(Math.PI/4),e=c*Math.sin(Math.PI/4),f=a.project(this._latlng),g=new L.Point(f.x-d,f.y+e),h=new L.Point(f.x+d,f.y-e),i=a.unproject(g),j=a.unproject(h);return new L.LatLngBounds(i,j)},getLatLng:function(){return this._latlng},getPathString:function(){var a=this.options.endAngle-this.options.startAngle,b=a>=180?"1":"0",c=this.options.radiusX||this.options.radius,d=this.options.radiusY||this.options.radius,e="M"+this._points[0].x.toFixed(2)+","+this._points[0].y.toFixed(2)+"A"+c.toFixed(2)+","+d.toFixed(2)+" 0 "+b+",1 "+this._points[1].x.toFixed(2)+","+this._points[1].y.toFixed(2)+"L";return this._innerPoints?(e=e+this._innerPoints[0].x.toFixed(2)+","+this._innerPoints[0].y.toFixed(2),e=e+"A"+(c-this.options.barThickness).toFixed(2)+","+(d-this.options.barThickness).toFixed(2)+" 0 "+b+",0 "+this._innerPoints[1].x.toFixed(2)+","+this._innerPoints[1].y.toFixed(2)+"z"):e=e+this._point.x.toFixed(2)+","+this._point.y.toFixed(2)+"z",L.Browser.vml&&(e=Core.SVG.path(e)),this._path.setAttribute("shape-rendering","geometricPrecision"),e},_getPoints:function(){var a=this.options.endAngle-this.options.startAngle,b=this.options.endAngle+this.options.rotation,c=this.options.startAngle+this.options.rotation,d=[],e="radiusX"in this.options?this.options.radiusX:this.options.radius,f="radiusY"in this.options?this.options.radiusY:this.options.radius,g=function(a){return a*L.LatLng.DEG_TO_RAD};b=b||0,360===a&&(b-=.1);var h=g(c),i=g(b);return d.push(this._getPoint(h,e,f)),d.push(this._getPoint(i,e,f)),this.options.barThickness&&(this._innerPoints=[],this._innerPoints.push(this._getPoint(i,e-this.options.barThickness,f-this.options.barThickness)),this._innerPoints.push(this._getPoint(h,e-this.options.barThickness,f-this.options.barThickness))),d},_getPoint:function(a,b,c){return new L.Point(this._point.x+this.options.position.x+b*Math.cos(a),this._point.y+this.options.position.y+c*Math.sin(a))}}),L.radialBarMarker=function(a,b){return new L.RadialBarMarker(a,b)},L.PieChartMarker=L.ChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:0,numberOfSides:50,mouseOverExaggeration:1.2,maxDegrees:360,iconSize:new L.Point(50,40)},_highlight:function(a){var b=a.radiusX,c=a.radiusY,d=a.barThickness;return a.oldBarThickness=d,a.oldRadiusX=b,a.oldRadiusY=c,a.radiusX*=a.mouseOverExaggeration,a.radiusY*=a.mouseOverExaggeration,a.barThickness=a.radiusX-b+d,a},_unhighlight:function(a){return a.radiusX=a.oldRadiusX,a.radiusY=a.oldRadiusY,a.barThickness=a.oldBarThickness,a},_loadComponents:function(){var a,b,c,d,e=0,f=0,g=0,h=this.options.maxDegrees||360,i=this.options.rotation,j=this.options,k=this.options.data,l=this.options.chartOptions,m=function(a,b){var c=0;return a[b]&&(c=parseFloat(a[b])),c};for(d in k)a=m(k,d),e+=a;if(e>0)for(d in k)a=parseFloat(k[d])||0,c=l[d],g=a/e,f=g*h,j.startAngle=i,j.endAngle=i+f,j.fillColor=c.fillColor,j.color=c.color||"#000",j.radiusX=this.options.radiusX||this.options.radius,j.radiusY=this.options.radiusY||this.options.radius,j.rotation=0,j.key=d,j.value=a,j.displayName=c.displayName,j.displayText=c.displayText,b=new L.RadialBarMarker(this._latlng,j),this._bindMouseEvents(b),i=j.endAngle,this.addLayer(b)}}),L.pieChartMarker=function(a,b){return new L.PieChartMarker(a,b)},L.CoxcombChartMarker=L.PieChartMarker.extend({statics:{SIZE_MODE_RADIUS:"radius",SIZE_MODE_AREA:"area"}}),L.CoxcombChartMarker=L.CoxcombChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.PieChartMarker.prototype.initialize.call(this,a,b)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:0,numberOfSides:50,mouseOverExaggeration:1.2,maxDegrees:360,iconSize:new L.Point(50,40),sizeMode:L.CoxcombChartMarker.SIZE_MODE_AREA},_loadComponents:function(){var a,b,c,d,e,f=0,g=this.options.maxDegrees||360,h=this.options.rotation,i=this.options,j="radiusX"in this.options?this.options.radiusX:this.options.radius,k="radiusY"in this.options?this.options.radiusY:this.options.radius,l=Object.keys(this.options.data),m=l.length,n=this.options.data,o=this.options.chartOptions;f=g/m;var p=function(a){return Math.sqrt(m*a/Math.PI)};for(var q in n){if(a=parseFloat(n[q])||0,e=o[q],b=e.minValue||0,c=e.maxValue,this.options.sizeMode===L.CoxcombChartMarker.SIZE_MODE_RADIUS){var r=new L.LinearFunction(new L.Point(b,0),new L.Point(c,j)),s=new L.LinearFunction(new L.Point(b,0),new L.Point(c,k));i.radiusX=r.evaluate(a),i.radiusY=s.evaluate(a)}else{var t=Math.max(j,k),u=Math.PI*Math.pow(t,2)/m,v=new L.LinearFunction(new L.Point(b,0),new L.Point(c,u),{postProcess:p});i.radiusX=v.evaluate(a),i.radiusY=i.radiusX}i.startAngle=h,i.endAngle=h+f,i.fillColor=e.fillColor,i.color=e.color||"#000",i.rotation=0,i.key=q,i.value=a,i.displayName=e.displayName,i.displayText=e.displayText,d=new L.RadialBarMarker(this._latlng,i),this._bindMouseEvents(d),h=i.endAngle,this.addLayer(d)}}}),L.coxcombChartMarker=function(a,b){return new L.CoxcombChartMarker(a,b)},L.RadialBarChartMarker=L.ChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:0,numberOfSides:30,offset:2,barThickness:5,maxDegrees:360,iconSize:new L.Point(50,40)},_loadComponents:function(){var a,b,c,d,e,f=this.options.rotation,g=this.options.maxDegrees||360,h=this.options,i=this.options.radiusX||this.options.radius,j=this.options.radiusY||this.options.radius,k=this.options.data,l=this.options.chartOptions,m=this.options.barThickness||4,n=this.options.offset||2;for(var o in k){a=parseFloat(k[o]),e=l[o],b=e.minValue||0,c=e.maxValue||100;var p=new L.LinearFunction(new L.Point(b,0),new L.Point(c,g));f=p.evaluate(a),h.startAngle=this.options.rotation,h.endAngle=this.options.rotation+f,h.fillColor=e.fillColor,h.radiusX=i,h.radiusY=j,h.barThickness=m,h.rotation=0,h.key=o,h.value=a,h.displayName=e.displayName,h.displayText=e.displayText,h.weight=this.options.weight||1,d=new L.RadialBarMarker(this._latlng,h),this._bindMouseEvents(d),this.addLayer(d),i+=m+n,j+=m+n}}}),L.radialBarChartMarker=function(a,b){return new L.RadialBarChartMarker(a,b)},L.StackedRegularPolygonMarker=L.ChartMarker.extend({options:{iconSize:new L.Point(50,40)},initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},_loadComponents:function(){var a,b,c,d,e=0,f=0,g=this.options,h=this.options.data,i=this.options.chartOptions,j=[];for(d in h){a=parseFloat(h[d]),c=i[d],minValue=c.minValue||0,maxValue=c.maxValue||100,minRadius=c.minRadius||0,maxRadius=c.maxRadius||10,g.fillColor=c.fillColor||this.options.fillColor,g.value=a,g.minValue=minValue,g.maxValue=maxValue;var k=new L.LinearFunction(new L.Point(minValue,minRadius),new L.Point(maxValue,maxRadius)),l=k.evaluate(a);g.radiusX=e+l,g.radiusY=f+l,g.innerRadiusX=e,g.innerRadiusY=f,g.key=d,g.displayName=c.displayName,g.opacity=this.options.opacity||1,g.fillOpacity=this.options.fillOpacity||.7,g.weight=this.options.weight||1,g.color=c.color||this.options.color,g.displayText=c.displayText,b=new L.RegularPolygonMarker(this._latlng,g),this._bindMouseEvents(b),e=g.radiusX,f=g.radiusY,this.options.drawReverse?j.push(b):this.addLayer(b)}if(this.options.drawReverse)for(var m=j.pop();m;)this.addLayer(m),m=j.pop()}}),L.RadialMeterMarker=L.ChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:180,numberOfSides:30,offset:2,barThickness:5,maxDegrees:180,iconSize:new L.Point(50,40),backgroundStyle:{fill:!0,fillColor:"#707070",fillOpacity:.2,opacity:.8,color:"#505050"}},_loadComponents:function(){var a,b,c,d,e,f,g=this.options.rotation,h=this.options.maxDegrees||360,i=this.options,j=this.options.radiusX||this.options.radius,k=this.options.radiusY||this.options.radius,l=this.options.data,m=this.options.chartOptions,n=this.options.barThickness||4,o=g,p=this.options.numSegments||10,q=h/p;for(var r in l){a=parseFloat(l[r]),e=m[r],f=this.options.displayOptions?this.options.displayOptions[r]:{},b=e.minValue||0,c=e.maxValue||100;for(var s,t,u=c-b,v=h/u*(a-b),w=g+v,x=g+h,y=new L.LinearFunction(new L.Point(g,b),new L.Point(x,c));w>o;){i.startAngle=o,s=Math.min(q,w-o),i.endAngle=o+s,i.fillColor=e.fillColor,i.radiusX=j,i.radiusY=k,i.barThickness=n,i.rotation=0,i.key=r,i.value=a,i.displayName=e.displayName,i.displayText=e.displayText,t=y.evaluate(o+s);for(var z in f)i[z]=f[z].evaluate?f[z].evaluate(t):f[z];d=new L.RadialBarMarker(this._latlng,i),this._bindMouseEvents(d),this.addLayer(d),o+=s}if(this.options.backgroundStyle&&x>o){s=x-o,i.endAngle=o+s,i.radiusX=j,i.radiusY=k,i.barThickness=n,i.rotation=0,i.key=r,i.value=a,i.displayName=e.displayName,i.displayText=e.displayText,i.fillColor=null,i.fill=!1,i.gradient=!1;for(var A in this.options.backgroundStyle)i[A]=this.options.backgroundStyle[A];t=y.evaluate(o+s),d=new L.RadialBarMarker(this._latlng,i),this.addLayer(d)}}}}),L.LocationModes={LATLNG:function(a){var b=function(b,c){var d=L.Util.getFieldValue(a,b),e=L.Util.getFieldValue(a,c),f=null;if(d&&e){var g=new L.LatLng(d,e);f={location:g,text:[g.lat.toFixed(3),g.lng.toFixed(3)].join(", "),center:g}}return f},c=b(this.options.latitudeField,this.options.longitudeField);if(!c&&this.options.fallbackLocationFields)for(var d,e=0;!c&&e<this.options.fallbackLocationFields.length;)d=this.options.fallbackLocationFields[e],c=b(d.latitudeField,d.longitudeField),e++;return c},GEOHASH:function(a,b){var c,d=this.options.geohashField?L.Util.getFieldValue(a,this.options.geohashField):b,e=GeoHash.decodeGeoHash(d);return e.latitude[2]&&e.longitude[2]&&(c=new L.LatLngBounds(new L.LatLng(e.latitude[0],e.longitude[0]),new L.LatLng(e.latitude[1],e.longitude[1]))),{location:c,text:d,center:c.getCenter()}},GWCOUNTRY:function(a,b){var c,d,e=this.options.codeField?L.Util.getFieldValue(a,this.options.codeField):b,f=L.gwNoLookup||{},g=L.countries||{},h=L.countryCentroids||{},i=e.toUpperCase();e=i;var j=i in f;j&&(e=f[i]||e),e?(c=g[e],d=h[e]):console.log("Code not found: "+i);var k=new L.GeoJSON(c);return{location:k,text:L.GeometryUtils.getName(c)||e,center:d}},COUNTRY:function(a,b){var c,d,e=this.options.codeField?L.Util.getFieldValue(a,this.options.codeField):b,f=L.codeLookup||{},g=L.alpha2Lookup||{},h=L.fips2Lookup||{},i=L.countries||{},j=L.countryCentroids||{},k=e.toUpperCase();e=k,2===e.length?e=g[k]||h[k]:3===e.length&&(e=f[k]||e),e?(c=i[e],d=j[e]):console.log("Code not found: "+k);var l=new L.GeoJSON(c);return{location:l,text:L.GeometryUtils.getName(c)||e,center:d}},STATE:function(a,b){var c,d,e=this.options.codeField?L.Util.getFieldValue(a,this.options.codeField):b,f=L.states||{},g=L.stateCentroids||{},h=e.toUpperCase();e=h,c=f[e],d=g[e];var i=new L.GeoJSON(c);return{location:i,text:L.GeometryUtils.getName(c)||e,center:d}},GEOJSON:function(a){var b=this.options.geoJSONField,c=b?L.Util.getFieldValue(a,b):a,d=null;if(c){var e=this,f=function(a,b){return e.recordToLayer(a,b)};d=L.GeometryUtils.getGeoJSONLocation(c,a,this.options.locationTextField,f)}return d},LOOKUP:function(a,b){var c=this.options.codeField?L.Util.getFieldValue(a,this.options.codeField):b;this._lookupIndex=this._lookupIndex||L.GeometryUtils.indexFeatureCollection(this.options.locationLookup,this.options.locationIndexField||this.options.codeField);var d=this._lookupIndex[c],e=null;if(d||0!==c.indexOf("0")||(d=this._lookupIndex[c.substring(1)]),d){var f=this,g=function(a,b){return f.recordToLayer(a,b)};e=L.GeometryUtils.getGeoJSONLocation(d,a,this.options.locationTextField,g)}return e},CUSTOM:function(a){var b,c=this.options.codeField,d=L.Util.getFieldValue(a,c),e={};if(e[d]=a,this.options.getLocation){var f=this,g=function(a,b){f.locationToLayer(b,e[a])};b=this.options.getLocation(e,c,[d],g)}return b}},L.DataLayer=L.LayerGroup.extend({includes:L.Mixin.Events,options:{recordsField:"features",locationMode:L.LocationModes.LATLNG,latitudeField:"geometry.coordinates.1",longitudeField:"geometry.coordinates.0",displayField:null,displayOptions:null,layerOptions:{numberOfSides:4,radius:10,weight:1,color:"#000"},showLegendTooltips:!0,tooltipOptions:{iconSize:new L.Point(60,50),iconAnchor:new L.Point(-5,50),mouseOverExaggeration:2},setHighlight:function(a){return a.weight=a.weight||1,a.fillOpacity=a.fillOpacity||.5,a.weight*=2,a.fillOpacity/=1.5,a},unsetHighlight:function(a){return a.weight=a.weight||1,a.fillOpacity=a.fillOpacity||.25,a.weight/=2,a.fillOpacity*=1.5,a}},initialize:function(a,b){L.Util.setOptions(this,b),L.LayerGroup.prototype.initialize.call(this,b),a=a||{},this._includeFunction=this.options.filter||this.options.includeLayer,this._markerFunction=this.options.getMarker||this._getMarker,this._addChildLayers(),this.addData(a)},_addChildLayers:function(){this._boundaryLayer=new L.LayerGroup,this.addLayer(this._boundaryLayer),this._trackLayer=new L.LayerGroup,this.addLayer(this._trackLayer)},_zoomFunction:function(){var a=this._map,b=this,c=a.getZoom();if(this.options.maxZoom&&c>this.options.maxZoom)this.hiddenLayers=[],this.eachLayer(function(c){b.hiddenLayers.push(c),a.removeLayer(c)});else if(this.hiddenLayers){for(;this.hiddenLayers.length>0;){var d=this.hiddenLayers.pop();a.addLayer(d),this.options.backgroundLayer&&d.bringToBack&&d.bringToBack()}this.hiddenLayers=null}},_addLayer:function(a,b){return function(){a.addLayer(b)}},_removeLayer:function(a,b){return function(){a.removeLayer(b)}},onAdd:function(a){var b=this;this._map=a;for(var c in b._layers)b._layers.hasOwnProperty(c)&&setTimeout(this._addLayer(a,b._layers[c]),0);a.on("zoomend",b._zoomFunction,b)},onRemove:function(a){var b=this;for(var c in b._layers)b._layers.hasOwnProperty(c)&&setTimeout(this._removeLayer(a,b._layers[c]),0);a.off("zoomend",b._zoomFunction,b)},bringToBack:function(){this.invoke("bringToBack"),this._trackLayer&&this._trackLayer.invoke("bringToBack"),this._boundaryLayer&&this._boundaryLayer.invoke("bringToBack")},bringToFront:function(){this._boundaryLayer&&this._boundaryLayer.invoke("bringToFront"),this._trackLayer&&this._trackLayer.invoke("bringToFront"),this.invoke("bringToFront")},getBounds:function(){var a;return this.eachLayer(function(b){b.getBounds&&(a?a.extend(b.getBounds()):a=b.getBounds())}),a},_getLocation:function(a,b){return this.options.locationMode.call(this,a,b)},_processLocation:function(a){var b=a.center;return b},_styleBoundary:function(a,b,c){if(a.setStyle){var d;
this.options.boundaryStyle instanceof Function&&(d=this.options.boundaryStyle.call(this,c,a)),d=d||this.options.boundaryStyle||L.extend({},b,{fillOpacity:.2,clickable:!1}),a.setStyle(d)}return a},_addBoundary:function(a,b,c){var d,e=a.location;return this.options.includeBoundary&&(e instanceof L.LatLngBounds&&(e=new L.Rectangle(e)),e=this._styleBoundary(e,b,c),this._boundaryLayer.addLayer(e),d=e),d},_getLayer:function(a,b,c){var d=this._addBoundary(a,b,c);a=this._processLocation(a);var e;return a&&(this._markerFunction=this.options.getMarker||this._getMarker,e=this._markerFunction.call(this,a,b,c),e.boundaryLayer=d),e},_getMarker:function(a,b){var c;return a&&(c=b.numberOfSides>=30&&!(b.innerRadius||b.innerRadiusX&&b.innerRadiusY)?new L.CircleMarker(a,b):new L.RegularPolygonMarker(a,b)),c},_preProcessRecords:function(a){return a},_shouldLoadRecord:function(a){return this._includeFunction=this.options.filter||this.options.includeLayer,this._includeFunction?this._includeFunction.call(this,a):!0},_loadRecords:function(a){var b;a=this._preProcessRecords(a);for(var c in a)if(a.hasOwnProperty(c)){var d=a[c];d=this.options.deriveProperties?this.options.deriveProperties(d):d;var e=this._shouldLoadRecord(d);if(b=this._getLocation(d,c),e)this.locationToLayer(b,d);else if(this._layerIndex){var f=this.options.getIndexKey.call(this,b,d);f in this._layerIndex&&(this.removeLayer(this._layerIndex[f]),delete this._layerIndex[f])}}},_preloadLocations:function(a){var b=this.options.codeField,c=[],d={};for(var e in a)if(a.hasOwnProperty(e)){var f=a[e],g=L.Util.getFieldValue(f,b);d[g]=f,c.push(g)}if(this.options.getLocation){var h=this,i=function(a,b){h.locationToLayer(b,d[a])};this.options.getLocation(d,b,c,i)}},setDisplayOptions:function(a){return this.options.displayOptions=a,this.reloadData(),this},setDisplayOption:function(a,b){if(this.options.displayOptions=this.options.displayOptions||{},a in this.options.displayOptions){var c=this.options.displayOptions[a];this.options.displayOptions[a]=L.extend({},c,b)}else this.options.displayOptions[a]=b;return this.reloadData(),this},setFilter:function(a){return this.options.filter=a,this.reloadData(),this},setOptions:function(a){return L.Util.setOptions(this,a),this.reloadData(),this},setData:function(a){this._data=a,this.reloadData()},reloadData:function(){return this._layerIndex||(this.clearLayers(),this._addChildLayers()),this._data&&this.addData(this._data),this.fire("legendChanged",this),this},addData:function(a){var b=null!==this.options.recordsField&&this.options.recordsField.length>0?L.Util.getFieldValue(a,this.options.recordsField):a;this.options.getIndexKey&&!this._layerIndex&&(this._layerIndex={},this._boundaryIndex={}),this.options.locationMode===L.LocationModes.CUSTOM&&this.options.preload?this._preloadLocations(b):this._loadRecords(b),this._data=a},locationToLayer:function(a,b){var c=this,d=c.recordToLayer(a,b);d&&c.addLayer(d)},_bindMouseEvents:function(a,b,c){var d=this,e=this.options,f=e.setHighlight,g=e.unsetHighlight,h=e.tooltipOptions,i=function(a){var b=a.target,e=this.options||b.options,g=new L.LegendIcon(c,e,{className:h.className||"leaflet-div-icon",iconSize:h.iconSize,iconAnchor:h.iconAnchor}),i=a.latlng||a.target._latlng,j=new L.Marker(i,{icon:g});d.addLayer(j),d.tooltip&&(d.removeLayer(d.tooltip),d.tooltip=null),d.tooltip=j,f&&(e=f(e)),b.setStyle&&b.setStyle(e),b.isHighlighted=!0},j=function(a){d.tooltip&&d.tooltip.setLatLng(a.latlng)},k=function(a){if(a.target.isHighlighted){a.target.isHighlighted=!1,d.tooltip&&(d.removeLayer(d.tooltip),d.tooltip=null);var b=a.target,c=this.options||b.options;g&&(c=g(c)),b.setStyle&&b.setStyle(c)}},l=function(a){a.off("mouseover"),a.off("mouseout"),a.off("mousemove"),a.on({mouseover:i,mouseout:k,mousemove:j})},m=function(a){a.eachLayer?a.eachLayer(function(a){m(a)}):l(a)};m(a)},_getDynamicOptions:function(a){var b=L.Util.extend({},this.options.layerOptions),c=this.options.displayOptions,d={};if(c)for(var e in c){var f,g=c[e],h=L.Util.getFieldValue(a,e),i=g.displayText?g.displayText(h):h;if(d[e]={name:g.displayName,value:i},g.styles)b=L.Util.extend(b,g.styles[h]),g.styles[h]=b;else for(var j in g)f=g[j],b[j]=f.evaluate?f.evaluate(h):f.call?f.call(this,h):f}return{layerOptions:b,legendDetails:d}},_recursiveLayerUpdate:function(a,b){var c=this;a.eachLayer?a.eachLayer(function(a){c._recursiveLayerUpdate(a,b)}):b.call(c,a)},_getIndexedLayer:function(a,b,c,d){var e=this;if(this.options.getIndexKey){var f=this.options.getIndexKey.call(this,b,d);if(f in a){layer=a[f];var g=function(a){c.radius&&a instanceof L.CircleMarker&&a.setRadius(c.radius),a.setStyle(c),a.setLatLng&&a.getLatLng()!==b.center?a.setLatLng(b.center):e._recursiveLayerUpdate(a,function(a){a.redraw()})};L.Util.updateLayer(layer,g),layer.boundaryLayer&&(layer.boundaryLayer=this._styleBoundary(layer.boundaryLayer,c,d))}else layer=this._getLayer(b,c,d),a[f]=layer;if(this.options.getTrack){var h=!layer.trackLayer;layer.trackLayer=this.options.getTrack.call(this,layer,b,layer.trackLayer),h&&this._trackLayer.addLayer(layer.trackLayer)}}else layer=this._getLayer(b,c,d);return layer},recordToLayer:function(a,b){var c,d=L.Util.extend({},this.options.layerOptions),e={},f=!0;if(this._includeFunction&&(f=this._includeFunction.call(this,b)),f){var g=this._getDynamicOptions(b);d=g.layerOptions,e=g.legendDetails,a&&d&&(d.title=a.text,c=this._getIndexedLayer(this._layerIndex,a,d,b),c&&(this.options.showLegendTooltips&&this._bindMouseEvents(c,d,e),this.options.onEachRecord&&this.options.onEachRecord.call(this,c,b,a,this)))}return c},getLegend:function(a){return this.options.getLegend?this.options.getLegend.call(this,a):this._getLegend(a)},_getLegendElement:function(a){var b,c,d=document.createElement("i"),e=a.displayProperties,f=a.layerOptions,g=a.ignoreProperties,h=a.displayTextFunction,i=a.index,j=a.numSegments,k=a.segmentWidth,l=a.minValue,m=a.maxValue;L.StyleConverter.applySVGStyle(d,f);var n={evaluate:function(b){return a.breaks[b]}};for(var o in e)if(e.hasOwnProperty(o)&&-1===g.indexOf(o)&&(valueFunction=e[o],valueFunction&&(valueFunction.getBounds||e.minValue&&e.maxValue))){var p=valueFunction.getBounds?valueFunction.getBounds():null,q=p?p[0].x:e.minValue,r=p?p[1].x:e.maxValue,s=a.breaks?n:new L.LinearFunction(new L.Point(0,q),new L.Point(j,r));b=q,c=r,h&&(b=h(q),c=h(r)),0===i&&(l.innerHTML=b,m.innerHTML=c);var t=(r-q)/j,u=s.evaluate(i),v=s.evaluate(i+1),w=valueFunction.evaluate?valueFunction.evaluate(u):valueFunction(u),x=valueFunction.evaluate?valueFunction.evaluate(v):valueFunction(v);L.StyleConverter.setCSSProperty(d,o,w),"fillColor"===o&&(d.style.cssText+=a.gradient?"background-image:linear-gradient(left , "+w+" 0%, "+x+" 100%);background-image:-ms-linear-gradient(left , "+w+" 0%, "+x+" 100%);background-image:-moz-linear-gradient(left , "+w+" 0%, "+x+" 100%);background-image:-webkit-linear-gradient(left , "+w+" 0%, "+x+" 100%);":"background-color:"+w+";"),"color"===o&&(d.style.cssText+="border-top-color:"+w+";border-bottom-color:"+x+";border-left-color:"+w+";border-right-color:"+x+";"),"weight"===o&&(d.style.cssText+="border-top-width:"+w+";border-bottom-width:"+x+";border-left-width:"+w+";border-right-width:"+x+";");var y=a.minX||t*i+q,z=a.maxX||y+t;h&&valueFunction&&(y=h(y),z=h(z)),d.setAttribute("title",y+" - "+z)}return d.style.width=k+"px",d},_getLegend:function(a){a=a||this.options.legendOptions||{};var b,c=a.className,d=document.createElement("div"),e=L.DomUtil.create("div","legend",d),f=a.numSegments||10,g=a.width||100,h=this.options.layerOptions||{},i=h.weight||0,j=g/f-2*i,k=this.options.displayOptions||{};c&&L.DomUtil.addClass(e,c),a.title&&(L.DomUtil.create("legend","",e).innerHTML=a.title);var l=function(a){return a};for(var m in k)if(k.hasOwnProperty(m)){var n=k[m];if(!n.excludeFromLegend){var o=n.displayName||m;b=n.displayText;var p=b?b:l,q=n.styles;if(L.DomUtil.create("div","legend-title",e).innerHTML=o,q)e.innerHTML+=new L.CategoryLegend(q).generate();else{var r=L.DomUtil.create("div","data-layer-legend"),s=L.DomUtil.create("div","min-value",r),t=L.DomUtil.create("div","scale-bars",r),u=L.DomUtil.create("div","max-value",r),v=["displayName","displayText","minValue","maxValue"],w=n.breaks,x=[];if(f=a.numSegments||10,w){for(var y=new L.LinearFunction([w[0],0],[w[w.length-1],g]),z=0,A=0,B=1;B<w.length;++B)A=y.evaluate(w[B]),x.push(A-z-2*i),z=A;f=x.length}for(var C=0;f>C;++C){var D={displayProperties:n,layerOptions:h,ignoreProperties:v,displayTextFunction:p,index:C,numSegments:f,segmentWidth:j,minValue:s,maxValue:u,gradient:a.gradient};w&&x.length>0&&(D.segmentWidth=x[C],D.segmentSize=x[C],D.minX=w[C],D.maxX=w[C+1],D.breaks=w);var E=this._getLegendElement(D);t.appendChild(E)}e.appendChild(r)}}}return d.innerHTML}}),L.dataLayer=function(a,b){return new L.DataLayer(a,b)},L.MapMarkerDataLayer=L.DataLayer.extend({_getMarker:function(a,b){return new L.MapMarker(a,b)}}),L.mapMarkerDataLayer=function(a,b){return new L.MapMarkerDataLayer(a,b)},L.MarkerDataLayer=L.DataLayer.extend({initialize:function(a,b){this._markerMap={},L.DataLayer.prototype.initialize.call(this,a,b)},options:{recordsField:"features",locationMode:L.LocationModes.LATLNG,latitudeField:"latitude",longitudeField:"longitude",layerOptions:{icon:null},showLegendTooltips:!1},_getMarker:function(a,b,c){return this.options.setIcon&&(b.icon=this.options.setIcon.call(this,c,b)),new L.Marker(a,b)},_getLegendElement:function(){},_getLegend:function(){return"<span>No legend available</span>"}}),L.markerDataLayer=function(a,b){return new L.MarkerDataLayer(a,b)},L.PanoramioLayer=L.MarkerDataLayer.extend({statics:{UPLOAD_DATE_FORMAT:"DD MMM YYYY",SIZE_BY_DATE:"date",SIZE_BY_POPULARITY:"popularity",SIZE_BY_NONE:"none",SIZES:{square:[60,60],mini_square:[32,32]},NUM_PHOTOS:50}}),L.PanoramioLayer=L.PanoramioLayer.extend({initialize:function(a){L.MarkerDataLayer.prototype.initialize.call(this,{},a),this._from=0,this._to=L.PanoramioLayer.NUM_PHOTOS,this._calls=[]},options:{recordsField:"photos",latitudeField:"latitude",longitudeField:"longitude",locationMode:L.LocationModes.LATLNG,showLegendTooltips:!1,sizeBy:L.PanoramioLayer.SIZE_BY_DATE,layerOptions:{opacity:1},onEachRecord:function(a,b){var c=b.photo_file_url,d=b.photo_title,e=this,f=b.width,g=b.height,h=2e4;a.on("click",function(i){var j=document.createElement("div"),k=L.DomUtil.create("div","",j);L.DomUtil.addClass(k,"panoramio-content");var l=L.DomUtil.create("img","photo",k);l.setAttribute("onload","this.style.opacity=1;"),l.setAttribute("src",c),l.style.width=f+"px";var m=L.DomUtil.create("div","photo-info",k);m.style.width=f-20+"px",m.innerHTML="<span>"+d+'</span><a class="photo-link" target="_blank" href="'+b.photo_url+'"><img src="http://www.panoramio.com/img/glass/components/logo_bar/panoramio.png" style="height: 14px;"/></a>';var n=L.DomUtil.create("a","author-link",k);n.setAttribute("target","_blank"),n.setAttribute("href",b.owner_url),n.innerHTML="by "+b.owner_name;var o=new L.DivIcon({className:"photo-details",html:j.innerHTML,iconAnchor:[f/2,g/2]}),p=new L.Marker(i.target._latlng,{icon:o,zIndexOffset:h});p.on("click",function(a){e.removeLayer(a.target)}),a.viewedImage=p,e.viewedImage=p,e.addLayer(p)}),this.options.onEachPhoto&&this.options.onEachPhoto.call(this,a,b)},setIcon:function(a){var b=L.Util.getFieldValue(a,"photo_title"),c=null;this._sizeFunction&&(c=this._sizeFunction.evaluate(a.index));var d=c?new L.Point(c,c):L.PanoramioLayer.SIZES[this.options.size],e=a.photo_file_url.replace("/medium/","/"+this.options.size+"/"),f=new L.DivIcon({iconSize:d,className:"",html:'<img class="photo" onload="this.style.opacity=1" title="'+b+'" src="'+e+'"/>'});return f},updateInterval:3e5,size:"square",attributionText:'Photos provided by <a href="http://www.panoramio.com"><img src="http://www.panoramio.com/img/glass/components/logo_bar/panoramio.png" style="height: 10px;"/></a>.  Photos provided by <a href="http://www.panoramio.com"><img src="http://www.panoramio.com/img/glass/components/logo_bar/panoramio.png" style="height: 10px;"/></a> are under the copyright of their owners',refreshEvents:"moveend",photoSet:"public"},includes:L.Mixin.Events,onAdd:function(a){L.DataLayer.prototype.onAdd.call(this,a),a.attributionControl&&a.attributionControl.addAttribution(this.options.attributionText);var b=this,c=function(){b._from=0,b._to=L.PanoramioLayer.NUM_PHOTOS,b.fire("requestingPhotos"),b._call&&clearTimeout(b._call);var a=function(){b.requestPhotos()};b._call=setTimeout(a,1e3)};this.requestPhotos(),this._interval=setInterval(c,this.options.updateInterval),this._resetFunction=c,a.on(this.options.refreshEvents,c)},onRemove:function(a){L.DataLayer.prototype.onRemove.call(this,a),a.attributionControl&&a.attributionControl.removeAttribution(this.options.attributionText),this._interval&&(clearInterval(this._interval),this._interval=null),a.off(this.options.refreshEvents,this._resetFunction)},calculateSizeByDate:function(a){for(var b=a.photos,c=[],d=0;d<b.length;++d){var e=b[d],f=moment(e.upload_date,L.PanoramioLayer.UPLOAD_DATE_FORMAT);c.push(f),b[d].index=f}c.sort(function(a,b){return a-b});var g=L.PanoramioLayer.SIZES[this.options.size][0];return this._sizeFunction=new L.LinearFunction([c[0],g/2],[c[c.length-1],g]),a},calculateSizeByPopularity:function(a){for(var b=a.photos,c=0;c<b.length;++c)b[c].index=c;var d=L.PanoramioLayer.SIZES[this.options.size][0];return this._sizeFunction=new L.LinearFunction([0,d/2],[b.length,d]),a},next:function(){this._from=this._to,this._to=this._from+L.PanoramioLayer.NUM_PHOTOS,this.requestPhotos()},previous:function(){this._to=this._from,this._from=this._from-L.PanoramioLayer.NUM_PHOTOS,this.requestPhotos()},requestJsonp:function(a,b,c){var d=this,e="function"+(new Date).getTime(),f=[];b.callback="window.LeafletDvfJsonpCallbacks."+e;for(var g in b)b.hasOwnProperty(g)&&f.push(g+"="+encodeURIComponent(b[g]));return a+=(a.indexOf("?")>0?"&":"?")+f.join("&"),"undefined"==typeof window.LeafletDvfJsonpCallbacks&&(window.LeafletDvfJsonpCallbacks={}),window.LeafletDvfJsonpCallbacks[e]=function(a){c.call(d,a),delete window.LeafletDvfJsonpCallbacks[e]},this.jsonpScript&&(document.head.removeChild(this.jsonpScript),this.jsonpScript=null),this.jsonpScript=document.createElement("script"),this.jsonpScript.setAttribute("type","text/javascript"),this.jsonpScript.setAttribute("async","true"),this.jsonpScript.setAttribute("src",a),document.head.appendChild(this.jsonpScript),{abort:function(){e in window.LeafletDvfJsonpCallbacks&&(window.LeafletDvfJsonpCallbacks[e]=function(){delete window.LeafletDvfJsonpCallbacks[e]})}}},requestPhotos:function(){for(var a=this,b=this._map.getBounds(),c=b.getSouthWest(),d=b.getNorthEast();a._calls.length>0;)a._calls.pop().abort();var e=this.requestJsonp("http://www.panoramio.com/map/get_panoramas.php",{set:this.options.photoSet,from:a._from,to:a._to,minx:c.lng,miny:c.lat,maxx:d.lng,maxy:d.lat,size:"medium",mapfilter:"true"},function(b){a._count=b.count,moment&&a.options.sizeBy===L.PanoramioLayer.SIZE_BY_DATE?b=a.calculateSizeByDate(b):a.options.sizeBy===L.PanoramioLayer.SIZE_BY_POPULARITY&&(b=a.calculateSizeByPopularity(b)),a.fire("photosAvailable",b),a.clearLayers(),a.addData(b)});a._calls.push(e)}}),L.panoramioLayer=function(a){return new L.PanoramioLayer(a)},L.GeohashDataLayer=L.DataLayer.extend({initialize:function(a,b){L.DataLayer.prototype.initialize.call(this,a,b)},options:{recordsField:"features",locationMode:L.LocationModes.GEOHASH,geohashField:"geohash",displayField:null,displayOptions:null,layerOptions:{weight:1,color:"#000"},getIndexKey:function(a){return a.text}},_getLayer:function(a,b){return new L.Rectangle(a.location,b)}}),L.geohashDataLayer=function(a,b){return new L.GeohashDataLayer(a,b)},L.ChoroplethDataLayer=L.DataLayer.extend({initialize:function(a,b){L.DataLayer.prototype.initialize.call(this,a,b)},options:{recordsField:"features",locationMode:L.LocationModes.COUNTRY,codeField:"ISO",displayField:null,displayOptions:null,layerOptions:{weight:1,color:"#000"},maxZoom:16,backgroundLayer:!0},_getLayer:function(a,b,c){return a.location instanceof L.LatLng?a.location=this._markerFunction.call(this,a.location,b,c):a.location instanceof L.LatLngBounds&&(a.location=new L.Rectangle(a.location,b)),a.location.setStyle&&(b.gradient=a.location instanceof L.Polyline?!1:b.gradient,a.location.setStyle(b)),a.location}}),L.choroplethDataLayer=function(a,b){return new L.ChoroplethDataLayer(a,b)},L.ChartDataLayer=L.DataLayer.extend({options:{showLegendTooltips:!1},initialize:function(a,b){L.DataLayer.prototype.initialize.call(this,a,b)},_getLayer:function(a,b,c){var d=this._addBoundary(a,b,c);a=this._processLocation(a);var e=this.options.chartOptions,f=this.options.tooltipOptions,g={};g=b,g.data={},g.chartOptions=e;for(var h in this.options.chartOptions)g.data[h]=this.options.getFieldValue?this.options.getFieldValue.call(this,c,h):L.Util.getFieldValue(c,h);for(h in f)g[h]=f[h];var i;return a&&(this._markerFunction=this.options.getMarker||this._getMarker,i=this._markerFunction.call(this,a,g,c),i.boundaryLayer=d),i},_getMarker:function(){},_getLegend:function(a){var b=(L.DataLayer.prototype._getLegend.call(this,a),new L.CategoryLegend(this.options.chartOptions));return a=a||this.options.legendOptions,b.generate(a)}}),L.BarChartDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_getMarker:function(a,b){return new L.BarChartMarker(a,b)}}),L.barChartDataLayer=function(a,b){return new L.BarChartDataLayer(a,b)},L.RadialBarChartDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_getMarker:function(a,b){return new L.RadialBarChartMarker(a,b)}}),L.radialBarChartDataLayer=function(a,b){return new L.RadialBarChartDataLayer(a,b)},L.PieChartDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_getMarker:function(a,b){return new L.PieChartMarker(a,b)}}),L.pieChartDataLayer=function(a,b){return new L.PieChartDataLayer(a,b)},L.CoxcombChartDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_getMarker:function(a,b){return new L.CoxcombChartMarker(a,b)}}),L.coxcombChartDataLayer=function(a,b){return new L.CoxcombChartDataLayer(a,b)},L.StackedRegularPolygonDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_getMarker:function(a,b){return new L.StackedRegularPolygonMarker(a,b)}}),L.stackedRegularPolygonDataLayer=function(a,b){return new L.StackedRegularPolygonDataLayer(a,b)},L.StackedPieChartDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_getMarker:function(a,b){return new L.StackedPieChartMarker(a,b)}}),L.stackedPieChartDataLayer=function(a,b){return new L.StackedPieChartDataLayer(a,b)},L.RadialMeterMarkerDataLayer=L.DataLayer.extend({options:{showLegendTooltips:!1},initialize:function(a,b){L.DataLayer.prototype.initialize.call(this,a,b)},_getLayer:function(a,b,c){this._addBoundary(a,b),a=this._processLocation(a);var d=this.options.chartOptions,e=this.options.tooltipOptions,f=this.options.displayOptions,g={};g=b,g.data={},g.chartOptions=d,g.displayOptions=f;for(var h in this.options.chartOptions)g.data[h]=L.Util.getFieldValue(c,h);for(h in e)g[h]=e[h];var i;return a&&(i=this._getMarker(a,g)),i},_getMarker:function(a,b){return new L.RadialMeterMarker(a,b)}}),L.radialMeterMarkerDataLayer=function(a,b){return new L.RadialMeterMarkerDataLayer(a,b)},L.CalloutLine=L.Path.extend({statics:{LINESTYLE:{ARC:"arc",ANGLE:"angle",STRAIGHT:"straight"},DIRECTION:{NE:"ne",NW:"nw",SE:"se",SW:"sw"}}}),L.CalloutLine=L.CalloutLine.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.Path.prototype.initialize.call(this,b),this._latlng=a},options:{size:new L.Point(60,30),position:new L.Point(0,0),color:"#FFFFFF",opacity:1,weight:2,fillColor:"#000000",fill:!1,gradient:!1,dropShadow:!1,direction:L.CalloutLine.DIRECTION.NE,lineStyle:L.CalloutLine.LINESTYLE.ANGLE,lineCap:"butt",lineJoin:"miter",arrow:!1},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints()},getEndPoint:function(){return this.projectLatlngs(),this._points[this._points.length-1]},_getPathAngle:function(){return new L.SVGPathBuilder(this._points,[],{closePath:!1}).build(6)},_getPathArc:function(){var a=(this.options.direction||L.CalloutLine.DIRECTION.NE).toLowerCase(),b=a[0],c="n"===b?-1:1,d=this._points[0],e=this._points[this._points.length-1],f=["M",d.x,",",d.y," Q",d.x,",",d.y+c*this.options.size.y," ",e.x,",",e.y];return f.join(" ")},_getPoints:function(){var a=this._point.x+this.options.position.x,b=this._point.y+this.options.position.y,c=this.options.size.x,d=this.options.size.y,e=(this.options.direction||L.CalloutLine.DIRECTION.NE).toLowerCase(),f=[],g=e[1],h=e[0],i="w"===g?-1:1,j="n"===h?-1:1;f.push(new L.Point(a,b));var k=b+j*d,l=c/2,m=Math.atan(d/l);if(this.options.lineStyle===L.CalloutLine.LINESTYLE.ARC?m=Math.atan(Math.pow(d,2)/l):this.options.lineStyle===L.CalloutLine.LINESTYLE.STRAIGHT&&(m=Math.atan(d/c)),this._angle=m,this.options.lineStyle!==L.CalloutLine.LINESTYLE.STRAIGHT){var n=new L.Point(a+i*l,k);f.push(n)}var o=new L.Point(a+i*c,k);return f.push(o),f},getBounds:function(){var a=this._map,b=a.project(this._latlng),c=new L.Point(b.x+this.options.position.x,b.y+this.options.position.y),d=new L.Point(c.x+this.options.size.x,c.y-this.options.size.y),e=a.unproject(c),f=a.unproject(d);return new L.LatLngBounds(e,f)},setLatLng:function(a){this._latlng=a,this.redraw()},getLatLng:function(){return this._latlng},getPathString:function(){this._path.setAttribute("shape-rendering","geometricPrecision");var a=this.options.lineStyle||L.CalloutLine.LINESTYLE.ANGLE,b="";return b+=a===L.CalloutLine.LINESTYLE.ANGLE||a===L.CalloutLine.LINESTYLE.STRAIGHT?this._getPathAngle():this._getPathArc()}}),L.calloutLine=function(a,b){return new L.CalloutLine(a,b)},L.Callout=L.LayerGroup.extend({options:{color:"#FFFFFF",fillColor:"#FFFFFF"},initialize:function(a,b){L.Util.setOptions(this,b),L.LayerGroup.prototype.initialize.call(this,b),this._latlng=a},onAdd:function(a){L.LayerGroup.prototype.onAdd.call(this,a),this.addLayers()},onRemove:function(a){L.LayerGroup.prototype.onRemove.call(this,a),this.clearLayers()},addArrow:function(a,b,c){if(this.options.arrow){a=L.LatLng.RAD_TO_DEG*a;var d=this.options.numberOfSides||3,e=this.options.radius||6,f=180/d,g={se:f+a,sw:180+f-a,nw:180+f+a,ne:f-a},h=g[b],i=new L.RegularPolygonMarker(this._latlng,{position:c,numberOfSides:d,rotation:h,fillColor:this.options.fillColor,color:this.options.color,gradient:this.options.gradient,weight:this.options.weight,opacity:this.options.opacity,fillOpacity:this.options.fillOpacity,radius:e,lineCap:"butt",lineJoin:"miter"});this.addLayer(i)}},addLine:function(){var a={};for(var b in this.options)"icon"!==b&&(a[b]=this.options[b]);var c=new L.CalloutLine(this._latlng,a);return this.addLayer(c),c},addIcon:function(a,b){var c=this.options.size,d=this.options.icon,e=d.options.iconSize,f=a[0],g=a[1],h="w"===g?e.x+c.x-b.x:-1*(c.x+b.x),i="n"===f?e.y/2+c.y-b.y:-1*(-e.y/2+c.y+b.y);d.options.iconAnchor=new L.Point(h,i);var j=new L.Marker(this._latlng,{icon:d});this.addLayer(j)},addLayers:function(){var a,b=(this.options.direction||"ne").toLowerCase(),c=this.options.position||new L.Point(0,0);a=this.addLine(),this.addIcon(b,c),this.addArrow(a._angle,b,c)}}),L.callout=function(a,b){return new L.Callout(a,b)},L.FlowLine=L.DataLayer.extend({statics:{LINE_FUNCTION:function(a,b,c){return new L.Polyline([a,b],c)},LINE_FUNCTION_INTERPOLATED:function(a,b,c){{var d=this._map.latlngToLayerPoint(a),e=this._map.latlngToLayerPoint(b),f=new L.LinearFunction(d,e),g=Math.ceil(d.distanceTo(e)/c.interpolationOptions.segmentLength);f.samplePoints(g)}}}}),L.FlowLine=L.FlowLine.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.DataLayer.prototype.initialize.call(this,a,b)},options:{getLine:L.FlowLine.LINE_FUNCTION,showLegendTooltips:!0,setHighlight:function(a){return a.opacity=a.opacity||1,a.opacity/=1.5,a},unsetHighlight:function(a){return a.opacity=a.opacity||.66,a.opacity*=1.5,a}},onEachSegment:function(a,b,c){var d={};if(this.options.timeField){var e=L.Util.getFieldValue(a,this.options.timeField),f=L.Util.getFieldValue(b,this.options.timeField),g=this.options.timeFormat,h=g?moment(e,g):moment(e),i=g?moment(f,g):moment(f),j=i.valueOf()-h.valueOf();d.time=j}for(var k in this.options.displayOptions){var l=L.Util.getFieldValue(a,k),m=L.Util.getFieldValue(b,k),n=m-l,o=n/l*100;d[k]={from:l,to:m,change:n,percentChange:o},d.time&&(d[k].changeOverTime=n/d.time)}var p,q=c.getLatLngs(),r=q[0].distanceTo(q[1]);d.time&&(p=r/(1e3*d.time)),this.options.onEachSegment&&this.options.onEachSegment.call(this,a,b,c,d,r,p)},_loadRecords:function(a){var b=[];this._lastRecord=null;for(var c in a)if(a.hasOwnProperty(c)){var d=a[c];d=this.options.deriveProperties?this.options.deriveProperties(d):d,b=this._addRecord(d,c,b)}for(;b.length>0;)this.addLayer(b.pop())},addRecord:function(a){return this._addRecord(a),this},_addRecord:function(a,b,c){var d=this._getLocation(a,b),e=this.options.layerOptions;if(d){var f,g=this._getLayer(d,e,a),h=!0;this.options.includeLayer&&(h=this.options.includeLayer(a)),this._lastRecord&&h&&(e=this._getDynamicOptions(this._lastRecord),f=this.options.getLine.call(this,this._lastMarker.getLatLng(),g.getLatLng(),e.layerOptions),this.addLayer(f),this.options.showLegendTooltips&&this._bindMouseEvents(f,e.layerOptions,e.legendDetails),this.onEachSegment(this._lastRecord,a,f)),h&&(this._lastRecord=a,this._lastMarker=g)}return c}}),L.flowLine=function(a,b){return new L.FlowLine(a,b)},L.ArcedFlowLine=L.FlowLine.extend({options:{getLine:function(a,b,c){return new L.ArcedPolyline([a,b],c)}},initialize:function(a,b){L.FlowLine.prototype.initialize.call(this,a,b)}}),L.arcedFlowLine=function(a,b){return new L.ArcedFlowLine(a,b)},L.ArcedPolyline=L.Path.extend({includes:TextFunctions,initialize:function(a,b){L.Path.prototype.initialize.call(this,b),this._latlngs=a},options:{distanceToHeight:new L.LinearFunction([0,5],[1e3,200]),color:"#FFFFFF",opacity:1,weight:1,fillColor:"#000000",fill:!1,gradient:!1,dropShadow:!1,optimizeSpeed:!1,mode:"C"},projectLatlngs:function(){this._points=[];for(var a=0;a<this._latlngs.length;++a)this._points.push(this._map.latLngToLayerPoint(this._latlngs[a]))},getBounds:function(){for(var a=new L.LatLngBounds,b=0;b<this._latlngs.length;++b)a.extend(this._latlngs[b]);return a},setLatLngs:function(a){this._latlngs=a,this.redraw()},getLatLngs:function(){return this._latlngs},drawSegment:function(a,b){var c,d,e=Math.sqrt(Math.pow(b.x-a.x,2)+Math.pow(b.y-a.y,2)),f=this.options.distanceToHeight.evaluate(e),g=a,h=b,i=[];return this._angle=Math.atan(2*f/(.5*e)),"Q"===this.options.mode?(d=new L.LinearFunction(a,b),g=d.getPointAtPercent(.5)):this.options.controlPointOffsets&&(d=new L.LinearFunction(a,b),g=d.getPointAtPercent(this.options.controlPointOffsets.x),h=d.getPointAtPercent(1-this.options.controlPointOffsets.y)),c="C"===this.options.mode?["C",g.x,",",g.y-f,h.x,",",h.y-f]:["Q",g.x,",",g.y-f],i=["M",a.x,",",a.y].concat(c).concat([b.x,",",b.y]),d=null,i.join(" ")},getPathString:function(){this.options.optimizeSpeed&&this._path.setAttribute("shape-rendering","optimizeSpeed");for(var a=[],b=0;b<this._points.length-1;++b)a.push(this.drawSegment(this._points[b],this._points[b+1]));return a.join("")}}),L.arcedPolyline=function(a,b){return new L.ArcedPolyline(a,b)},L.Control.Legend=L.Control.extend({options:{position:"bottomright",autoAdd:!0},onAdd:function(a){var b="leaflet-control-legend",c=L.DomUtil.create("div",b),d=this;return this.options.autoAdd&&(a.on("layeradd",function(a){var b=a.layer;d.addLayer(b)}),a.on("layerremove",function(a){var b=a.layer;d.removeLayer(b)})),this.toggleSize=L.bind(this.toggleSize,this),L.DomEvent.addListener(c,"mouseover",this.toggleSize).addListener(c,"mouseout",this.toggleSize).addListener(c,"touchstart",this.toggleSize).addListener(c,"touchend",this.toggleSize).addListener(c,"mousedown",L.DomEvent.stopPropagation).addListener(c,"mousewheel",L.DomEvent.stopPropagation).addListener(c,"MozMousePixelScroll",L.DomEvent.preventDefault).addListener(c,"click",L.DomEvent.stopPropagation).addListener(c,"click",L.DomEvent.preventDefault),c},clear:function(){this._container.innerHTML=""},toggleSize:function(){L.DomUtil.hasClass(this._container,"larger")?L.DomUtil.removeClass(this._container,"larger"):L.DomUtil.addClass(this._container,"larger")},redrawLayer:function(a){this.removeLayer(a),this.addLayer(a)},addLayer:function(a){var b=L.Util.stamp(a),c=this;a.getLegend&&(this.addLegend(b,a.getLegend()),a.on("legendChanged",function(){c.redrawLayer(a)}))},removeLayer:function(a){var b=L.Util.stamp(a);if(a.getLegend){var c=document.getElementById(b);c&&c.parentNode.removeChild(c),a.off("legendChanged")}},addLegend:function(a,b){var c=this._container,d=document.getElementById(a);d||(d=L.DomUtil.create("div","",c),d.id=a),d.innerHTML=b}}),L.control.legend=function(a){return new L.Control.Legend(a)},L.SeriesMarker=L.Path.extend({initialize:function(a,b){L.Path.prototype.initialize.call(this,b),L.Util.setOptions(this,b),this._latlng=a},options:{fill:!1,size:new L.Point(80,80),position:{x:0,y:0},weight:1,color:"#000",opacity:1},setLatLng:function(a){return this._latlng=a,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints()},getBounds:function(){var a=this._map,b=a.project(this._latlng),c=new L.Point(b.x,b.y),d=new L.Point(b.x+this.options.size.x,b.y-this.options.size.y),e=a.unproject(c),f=a.unproject(d);return new L.LatLngBounds(e,f)},getLatLng:function(){return this._latlng},getPathString:function(){return new L.SVGPathBuilder(this._points,null,{closePath:this.options.fill}).build(6)},getDataPoint:function(a){return _.find(this._seriesPoints,function(b){return b.x===a})},getClosestPathPoint:function(a){var b,c=this._points,d=-1,e=_.find(c,function(b,c){var e=b.x>=a;return e&&(d=c),e});if(e)if(e.x===a)b=e;else if(d>0){var f=c[d-1],g=Math.abs(e.x-a),h=Math.abs(f.x-a);b=h>g?e:f}return b},getClosestPoint:function(a){var b,c=this._seriesPoints,d=-1;a=this._reverseXTransform.evaluate(a);var e=_.find(c,function(b,c){var e=b.x>=a;return e&&(d=c),e});if(e)if(e.x===a)b=e;else if(d>0){var f=c[d-1],g=Math.abs(e.x-a),h=Math.abs(f.x-a);b=h>g?e:f}return b},_getPoints:function(){var a=this.options,b=a.size,c=a.xRange?a.xRange[0]:a.minX,d=a.xRange?a.xRange[1]:a.maxX,e=a.yRange?a.yRange[0]:a.minY,f=a.yRange?a.yRange[1]:a.maxY,g=new L.LinearFunction([c,0],[d,b.x]),h=new L.LinearFunction([e,0],[f,b.y]);this._reverseXTransform=new L.LinearFunction([0,c],[b.x,d]),this._reverseYTransform=new L.LinearFunction([0,e],[b.y,f]);var i,j,k,l=a.xField||"x",m=a.yField||"y",n=[],o=a.value;this._seriesPoints=[];for(var p in o)o.hasOwnProperty(p)&&(i=o[p],j=L.Util.getFieldValue(i,l),k=L.Util.getFieldValue(i,m),j=isNaN(j)?moment(j).unix():Number(j),this._seriesPoints.push(new L.Point(j,k)),j=g.evaluate(j),k=h.evaluate(k),n.push(new L.Point(this._point.x+a.position.x+j-b.x/2,this._point.y+a.position.y-k)));if(this._seriesPoints=_.sortBy(this._seriesPoints,function(a){return a.x}),n=_.sortBy(n,function(a){return a.x}),a.fill){var q=h.evaluate(e);n.unshift(new L.Point(this._point.x+a.position.x+g.evaluate(c)-b.x/2,this._point.y+a.position.y-q)),n.push(new L.Point(this._point.x+a.position.x+g.evaluate(d)-b.x/2,this._point.y+a.position.y-q))}return n}}),L.Line=L.Path.extend({initialize:function(a,b){L.Path.prototype.initialize.call(this,b),this._points=a},getPathString:function(){var a=new L.SVGPathBuilder(this._points,null,{closePath:!1}).build(6);return a}}),L.SparklineMarker=L.ChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},options:{weight:1,opacity:1,dataPointHighlightStyle:{weight:1,opacity:1,color:"#1E90FF",lineCap:"square",dropShadow:!1,dashArray:[5,2]}},_highlight:function(a){return a.weight&&(a.weight*=2),a
},_unhighlight:function(a){return a.weight&&(a.weight/=2),a},_bindMouseEvents:function(a){var b=this,c=this.options.tooltipOptions;a.on("mousemove",function(d){var e,f=this.options,g=f.key,h=f.value,i=d.layerPoint,j=i.x-this._point.x,k=(i.y-this._point.y,f.iconSize),l=5;f.marker&&b.removeLayer(f.marker),f.lines&&_.each(f.lines,function(a){b.removeLayer(a)});{var m=a.getClosestPoint(j+f.position.x+b.options.size.x/2),n=a.getClosestPathPoint(i.x);a.getBounds()}if(m){h={x:m.x,y:m.y},e=new L.Point(-l,k.y+l);var o={},p=function(a){return'<div><div><span class="xvalue">'+a.x+'</span><span class="separator">:</span><span class="yvalue">'+a.y+"</span></div></div>"},q=f.displayText?f.displayText(h):p(h);o[g]={name:f.displayName,value:q};var r=new L.LegendIcon(o,f,{className:"leaflet-div-icon",iconSize:c?c.iconSize:k,iconAnchor:e}),s=b._map.layerPointToLatLng(n);f.marker=new L.Marker(s,{icon:r}),f.lines=[new L.Line([new L.Point(n.x,a._point.y),new L.Point(n.x,n.y)],b.options.dataPointHighlightStyle),new L.Line([new L.Point(n.x,n.y),new L.Point(a._point.x+f.position.x-b.options.size.x/2,n.y)],b.options.dataPointHighlightStyle)],b.addLayer(f.marker),_.each(f.lines,function(a){b.addLayer(a)})}}),a.on("mouseover",function(){var a=this.options;a=b._highlight(a),this.initialize(b._latlng,a),this.redraw(),this.setStyle(a)}),a.on("mouseout",function(){var a=this.options;a=b._unhighlight(a),this.initialize(b._latlng,a),this.redraw(),this.setStyle(a),a.lines&&_.each(a.lines,function(a){b.removeLayer(a)}),b.removeLayer(a.marker)})},_loadComponents:function(){{var a,b,c=this.options.chartOptions,d=this.options.data;this.options.size}for(var e in d)if(d.hasOwnProperty(e)){a=d[e],b=c[e],b=L.Util.extend({},this.options,b),b.xField="0",b.yField="1",b.key=e,b.value=a;var f=new L.SeriesMarker(this._latlng,b);this._bindMouseEvents(f),this.addLayer(f)}}}),L.SparklineDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_preProcessRecords:function(a){var b,c,d,e,f,g,h=[Number.MAX_VALUE,Number.MIN_VALUE],i=[Number.MAX_VALUE,Number.MIN_VALUE],j={},k=[],l=this.options.xField||"x",m=this.options.yField||"y",n=this.options.seriesField,o=this.options.filter||this.options.includeLayer,p={};for(g in a)if(a.hasOwnProperty(g)){b=a[g];var q=o?o.call(this,b):!0;if(q)if(n){c=L.Util.getFieldValue(b,n),_.isObject(c)&&(c=_.pairs(c));for(d in this.options.chartOptions){p={};var r=this.options.chartOptions[d];for(f in c)c.hasOwnProperty(f)&&(e=c[f],w=L.Util.getFieldValue(e,r.xField||l),y=L.Util.getFieldValue(e,r.yField||m),isNaN(w)&&(w=moment(w).unix()),w=Number(w),j[w]=w,h[0]=Math.min(h[0],w),h[1]=Math.max(h[1],w),i[0]=Math.min(i[0],y),i[1]=Math.max(i[1],y),p[w]=y);k[g]=k[g]||b,L.Util.setFieldValue(k[g],d,p)}}else for(d in this.options.chartOptions){c=L.Util.getFieldValue(b,d),_.isObject(c)&&(c=_.pairs(c)),p={};var s=this.options.chartOptions[d];for(f in c)c.hasOwnProperty(f)&&(e=c[f],w=L.Util.getFieldValue(e,s.xField||l),y=L.Util.getFieldValue(e,s.yField||m),e.x?(w=e.x,y=e.y):_.isArray(e)?(w=e[0],y=e[1]):(w=g,y=e),isNaN(w)&&(w=moment(w).unix()),w=Number(w),j[w]=w,h[0]=Math.min(h[0],w),h[1]=Math.max(h[1],w),i[0]=Math.min(i[0],y),i[1]=Math.max(i[1],y),p[w]=y);k[g]=k[g]||b,L.Util.setFieldValue(k[g],d,p)}}j=_.sortBy(_.keys(j),function(a){return a});for(g in k){var t=k[g];for(d in this.options.chartOptions){for(var u=L.Util.getFieldValue(t,d),v=0;v<j.length;++v){var w=j[v];w in u||(u[w]=0)}L.Util.setFieldValue(k[g],d,_.chain(u).pairs().sortBy(function(a){return a}).value())}}return this.options.layerOptions.minX=h[0],this.options.layerOptions.maxX=h[1],this.options.layerOptions.minY=Math.min(0,i[0]),this.options.layerOptions.maxY=i[1],this.options.xField="0",this.options.yField="1",k},_getMarker:function(a,b){return new L.SparklineMarker(a,b)}}),L.sparklineDataLayer=function(a,b){return new L.SparklineDataLayer(a,b)},L.WordCloudMarker=L.ChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},options:{},_loadComponents:function(){}}),L.wordCloudMarker=function(a,b){return new L.WordCloudMarker(a,b)},L.WordCloudDataLayer=L.ChartDataLayer.extend({initialize:function(a,b){L.ChartDataLayer.prototype.initialize.call(this,a,b)},_preProcessRecords:function(a){return a},_getMarker:function(a,b){return new L.WordCloudMarker(a,b)}}),L.wordCloudDataLayer=function(a,b){return new L.WordCloudDataDataLayer(a,b)};var getArrow=function(a,b,c){b=L.LatLng.RAD_TO_DEG*b,c=c||{};var d=c.numberOfSides||3,e=c.radius||6,f=180/d,g={se:f+b,sw:180+f-b,nw:180+f+b,ne:f-b},h=g.se,i=new L.RegularPolygonMarker(a,{numberOfSides:d,rotation:h,fillColor:c.fillColor,color:c.color,gradient:c.gradient,weight:c.weight,opacity:c.opacity,fillOpacity:c.fillOpacity,radius:e,lineCap:"butt",lineJoin:"miter"});return i};L.Graph=L.DataLayer.extend({statics:{EDGESTYLE:{STRAIGHT:function(a,b){return new L.Polyline([a,b])},ARC:function(a,b){return new L.ArcedPolyline([a,b])}}}}),L.Graph=L.Graph.extend({options:{getEdge:L.Graph.EDGESTYLE.STRAIGHT},_getLayer:function(a,b){return a.location.setStyle(b),a.location},_getLocation:function(a){var b,c=this.options.fromField,d=this.options.toField,e=L.Util.getFieldValue(a,c),f=L.Util.getFieldValue(a,d),g=this.options.locationMode.call(this,e,e),h=this.options.locationMode.call(this,f,f);if(g&&h){var i=g.center,j=h.center;if(i&&j){var k=this.options.getEdge.call(this,i,j),l=new L.LatLngBounds(new L.LatLng(Math.min(i.lat,j.lat),Math.min(i.lng,j.lng)),new L.LatLng(Math.max(i.lat,j.lat),Math.max(i.lng,j.lng)));b={center:l.getCenter(),location:k,text:e+" - "+f}}}return b}}),L.WeightedLineSegment=L.Polyline.extend({initialize:function(a,b,c){L.Polyline.prototype.initialize.call(this,c),L.Util.setOptions(this,c),this._weightedPoint1=a,this._weightedPoint2=b,this._latlngs=[]},options:{polygon:!0},getLatLngs:function(){var a=this._weightedPointToPoint(this._weightedPoint1),b=this._weightedPointToPoint(this._weightedPoint2),c=a[1],d=b[1];return[this._map.layerPointToLatLng(c),this._map.layerPointToLatLng(d)]},projectLatlngs:function(){this._points=this._getPoints(),("undefined"!=typeof this.options.fill&&this.options.fill&&this.options.gradient||this.options.stroke&&!this.options.fill&&this.options.gradient)&&this._setGradient()},_setGradient:function(){var a,b=this._points[1],c=this._points[4],d=c.x-b.x,e=c.y-b.y;if(this.options.gradient.gradientUnits=this.options.gradient.gradientUnits||"objectBoundingBox",0!==d||0!==e){if("objectBoundingBox"===this.options.gradient.gradientUnits){{var f=Math.atan(e/d),g=d/Math.abs(d);e/Math.abs(e)}if(b=new L.Point(50+50*Math.cos(f+Math.PI),50+50*Math.sin(f+Math.PI)),c=new L.Point(50+50*Math.cos(f),50+50*Math.sin(f)),0>g){var h=b;b=c,c=h}a=[[b.x.toFixed(2)+"%",b.y.toFixed(2)+"%"],[c.x.toFixed(2)+"%",c.y.toFixed(2)+"%"]]}else a=[[b.x.toFixed(2),b.y.toFixed(2)],[c.x.toFixed(2),c.y.toFixed(2)]];var i=this.options.weightToColor?this.options.weightToColor.evaluate(this._weightedPoint1.lineWeight):this._weightedPoint1.fillColor||this._weightedPoint1.color,j=this.options.weightToColor?this.options.weightToColor.evaluate(this._weightedPoint2.lineWeight):this._weightedPoint2.fillColor||this._weightedPoint2.color,k=this.options.weightToOpacity?this.options.weightToOpacity.evaluate(this._weightedPoint1.lineWeight):1,l=this.options.weightToOpacity?this.options.weightToOpacity.evaluate(this._weightedPoint2.lineWeight):1;this.options.gradient={gradientUnits:this.options.gradient.gradientUnits,vector:a,stops:[{offset:"0%",style:{color:i,opacity:k}},{offset:"100%",style:{color:j,opacity:l}}]},this.setStyle(this.options)}},_weightedPointToPoint:function(a){var b=[];this._latlngs.push(a.latlng);var c=this._map.latLngToLayerPoint(a.latlng),d=a.lineWeight/2,e=a.angle,f=e+Math.PI,g=new L.Point(c.x+Math.cos(e)*d,c.y+Math.sin(e)*d),h=new L.Point(c.x+Math.cos(f)*d,c.y+Math.sin(f)*d);return b=[g,c,h]},_getPoints:function(){var a=[],b=this._weightedPointToPoint(this._weightedPoint1),c=this._weightedPointToPoint(this._weightedPoint2);if(this.options.polygon){var d=new L.LinearFunction(b[0],c[0]),e=new L.LinearFunction(b[1],c[1]),f=new L.LinearFunction(b[2],c[2]),g=f.getIntersectionPoint(d),h=new L.Bounds([].concat(b,c));g?h.contains(g)||(c=c.reverse()):d._slope===f._slope&&(c=c.reverse()),d=null,e=null,f=null,g=null}return a=a.concat(b,c),this._originalPoints=a,a},getBounds:function(){for(var a=new L.LatLngBounds,b=0;b<this._latlngs.length;++b)a.extend(this._latlngs[b]);return a},getPathString:function(){var a=this.options.polygon,b=this._points;return this.options.polygon||(b=[b[1],b[4]]),new L.SVGPathBuilder(b,[],{closePath:a}).build(6)}}),L.WeightedLineSegment.include(LineTextFunctions),L.WeightedFlowLine=L.FlowLine.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.FlowLine.prototype.initialize.call(this,a,b),this._loaded=!1},_getAngle:function(a,b){var c=this._map.latLngToLayerPoint(a),d=this._map.latLngToLayerPoint(b),e=d.x-c.x,f=d.y-c.y,g=Math.atan(f/e);return g},_getAngles:function(a,b){var c=this._getAngle(a,b);isNaN(c)&&(c=0);var d=c+Math.PI/2,e=d+Math.PI;return[d,e]},onAdd:function(a){L.FlowLine.prototype.onAdd.call(this,a),this._data&&!this._loaded&&this._loadRecords(this._data)},_addLineSegment:function(a,b,c,d,e,f){var g=this._getAngles(a,b),h=(this._getDynamicOptions(d[e[f-1]]),this._getDynamicOptions(d[e[f]]));c.push(L.extend({latlng:a,angle:(g[0]+c[c.length-1].angle)/2},h.layerOptions));var i=new L.WeightedLineSegment(c[0],c[1],h.layerOptions);return this.addLayer(i),this.options.showLegendTooltips&&this._bindMouseEvents(i,h.layerOptions,h.legendDetails),this.onEachSegment(d[e[f-1]],d[e[f]],i),c},_loadRecords:function(a){if(this._map){var b=[],c=Object.keys(a);if(c.length>0){c=1===c.length?c.push(c[0]):c;var d=this._getLocation(a[c[0]],c[0]).center,e=this._getLocation(a[c[1]],c[1]).center,f=this._getAngles(d,e),g=this._getDynamicOptions(a[c[0]]);if(f.length>0){b.push(L.extend({latlng:d,angle:f[0]},g.layerOptions));for(var h=1;h<c.length-1;++h)d=e,e=this._getLocation(a[c[h+1]],c[h+1]).center,b=this._addLineSegment(d,e,b,a,c,h),b=b.slice(1);d=e,e=this._getLocation(a[c[c.length-1]]).center,this._addLineSegment(d,e,b,a,c,c.length-1)}this._loaded=!0}}}}),L.WeightedPolyline=L.FeatureGroup.extend({initialize:function(a,b){L.FeatureGroup.prototype.initialize.call(this,b),L.Util.setOptions(this,b),this._latlngs=a},onAdd:function(a){L.LayerGroup.prototype.onAdd.call(this,a),this._loadComponents()},getBounds:function(){var a=new L.LatLngBounds;return this.eachLayer(function(b){a.extend(b.getBounds?b.getBounds():b.getLatLng())}),a},setLatLngs:function(a){this._latlngs=a,this._loaded=!1,this._loadComponents(),this.redraw()},getLatLngs:function(){return this._latlngs},options:{weightToColor:new L.HSLHueFunction([0,120],[20,-30])},_getAngle:function(a,b){var c=this._map.latLngToLayerPoint(a),d=this._map.latLngToLayerPoint(b),e=d.x-c.x,f=d.y-c.y,g=Math.atan(f/e);return g},_getAngles:function(a,b){var c=this._getAngle(a,b);isNaN(c)&&(c=0);var d=c+Math.PI/2,e=d+Math.PI;return[d,e]},_loadComponents:function(){if(!this._loaded){var a=[],b=this._latlngs[0],c=this._latlngs[1],d=this._getAngles(b,c);if(d.length>0){a.push({latlng:b,angle:d[0],lineWeight:b.weight});for(var e=1;e<this._latlngs.length-1;++e)b=this._latlngs[e],c=this._latlngs[e+1],d=this._getAngles(b,c),a.push({latlng:b,angle:d[0],lineWeight:b.weight}),this.addLayer(new L.WeightedLineSegment(a[0],a[1],this.options)),a=a.slice(1);b=L.extend({},c),c=this._latlngs[this._latlngs.length-1],a.push({latlng:b,angle:a[0].angle,lineWeight:c.weight}),this.addLayer(new L.WeightedLineSegment(a[0],a[1],this.options))}this._loaded=!0}}}),L.weightedPolyline=function(a,b){return new L.WeightedPolyline(a,b)},L.StackedPieChartMarker=L.ChartMarker.extend({initialize:function(a,b){L.Util.setOptions(this,b),L.ChartMarker.prototype.initialize.call(this,a,b)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:0,numberOfSides:50,mouseOverExaggeration:1.2,maxDegrees:360,iconSize:new L.Point(50,40)},_loadComponents:function(){var a,b,c,d,e,f,g=0,h=1,i=0,j=0,k=0,l=(this.options.radius,this.options.barThickness),m=this.options.maxDegrees||360,n=0,o=this.options,p=this.options.data,q=this.options.chartOptions,r=function(a,b){var c=0;return a[b]&&(c=parseFloat(a[b])),c},s=0,t=[],u=[];for(d in p){for(a=r(p,d),f=0,e=0;e<p[d].length;++e)a=parseFloat(p[d][e]),f+=a;t.push(f),u.push(o.barThickness/f),g=g>f?g:f,i+=o.values[s],++s}if(h=o.barThickness/g,i>0){circle=new L.CircleMarker(this._latlng,{color:o.color,radius:l,fillColor:o.fillColor,fill:!0,iconSize:new L.Point(50,40)}),this._bindMouseEvents(circle),this.addLayer(circle),s=0;for(d in p){for(f=0,k=o.values[s]/i,j=k*m,o.startAngle=n,o.endAngle=n+j,e=0;e<p[d].length;++e)a=parseFloat(p[d][e]),f+=a,o.radius=f*u[s],o.barThickness=a*u[s],c=q[d],o.fillColor=this.options.fillColors[e],o.fillOpacity="transparent"==o.fillColor?0:1,o.color=c.color||"#000",o.radiusX=o.radius,o.radiusY=o.radius,o.rotation=0,o.key=d+" "+e,o.value=a,o.displayName=c.displayName,o.displayText=c.displayText,b=new L.RadialBarMarker(this._latlng,o),this._bindMouseEvents(b),this.addLayer(b);n=o.endAngle,s++}var v=function(a){return parseInt(100*a)+"%"};for(e=.2;1>e;e+=.2)circle=new L.CircleMarker(this._latlng,{value:e,color:o.color,radius:l*e,weight:1,dashArray:[5,5],fill:!1,iconSize:new L.Point(50,40),displayName:"percent",displayText:v}),this._bindMouseEvents(circle),this.addLayer(circle)}}}),L.stackedPieChartMarker=function(a,b){return new L.StackedPieChartMarker(a,b)},L.LayeredRegularPolygonMarker=L.MarkerGroup.extend({options:{levels:2,numberOfSides:50},setStyle:function(a){a.levels=a.levels||2;var b=a.radiusX||a.radius,c=a.radiusY||a.radius,d=b/(.75*a.levels),e=c/(.75*a.levels),f=L.extend({},a);b+=(a.levels-1)*d,c+=(a.levels-1)*e;var g=a.fillOpacity||.5,h=a.fillOpacity/(1.5*a.levels);g-=a.levels*h;for(var i=0;i<a.levels;++i)f.radius=0,f.radiusX=b,f.radiusY=c,f.fillOpacity=g,this._markers[i].setStyle(f),b-=d,c-=e,g+=h;return this},initialize:function(a,b){L.Util.setOptions(this,b),b.levels=b.levels||2;var c=[],d=b.radiusX||b.radius,e=b.radiusY||b.radius,f=d/(.75*b.levels),g=e/(.75*b.levels),h=L.extend({},b);d+=(b.levels-1)*f,e+=(b.levels-1)*g;var i=b.fillOpacity||.5,j=b.fillOpacity/(1.5*b.levels);i-=b.levels*j;for(var k=0;k<b.levels;++k)h.radius=0,h.radiusX=d,h.radiusY=e,h.fillOpacity=i,c.push(new L.RegularPolygonMarker(a,h)),d-=f,e-=g,i+=j;this._markers=c,L.MarkerGroup.prototype.initialize.call(this,a,c)}}),L.MapillaryLayer=L.PanoramioLayer.extend({options:{recordsField:null,locationMode:L.LocationModes.LATLNG,latitudeField:"lat",longitudeField:"lon",onEachRecord:function(a,b){var c=b.map_image_versions[1].url,d=b.location,e=this,f=640,g=640,h=2e4;a.on("click",function(b){var i=document.createElement("div"),j=L.DomUtil.create("div","",i);L.DomUtil.addClass(j,"panoramio-content");var k=L.DomUtil.create("img","photo",j);k.setAttribute("onload","this.style.opacity=1;"),k.setAttribute("src",c),k.style.width=f+"px";var l=L.DomUtil.create("div","photo-info",j);l.style.width=f-20+"px",l.innerHTML="<span>"+d+'</span><a class="photo-link" target="_blank" href="'+c+'"><img src="https://upload.wikimedia.org/wikipedia/commons/a/a8/Mapillary_logo.png" style="height: 14px;"/></a>';var m=new L.DivIcon({className:"photo-details",html:i.innerHTML,iconAnchor:[f/2,g/2]}),n=new L.Marker(b.target._latlng,{icon:m,zIndexOffset:h});n.on("click",function(a){e.removeLayer(a.target)}),a.viewedImage=n,e.viewedImage=n,e.addLayer(n)}),this.options.onEachPhoto&&this.options.onEachPhoto.call(this,a,b)},setIcon:function(a){var b=a.location,c=new L.Point(40,40),d=a.map_image_versions[0].url,e=new L.DivIcon({iconSize:c,className:"",html:'<img class="photo" onload="this.style.opacity=1" title="'+b+'" src="'+d+'"/>'});return e}},requestPhotos:function(){for(var a=this,b=this._map.getBounds(),c=b.getSouthWest(),d=b.getNorthEast();a._calls.length>0;)a._calls.pop().abort();var e=new XMLHttpRequest;e.onreadystatechange=function(){if(4==this.readyState&&200==this.status){var b=JSON.parse(e.responseText);a._count=b.length,a.fire("photosAvailable",b),a.clearLayers(),a.addData(b)}},e.open("GET","http://api.mapillary.com/v1/im/search?min-lat="+c.lat+"&max-lat="+d.lat+"&min-lon="+c.lng+"&max-lon="+d.lng+"&max-results=50",!0),e.send(null),a._calls.push(e)}});