/*
 @preserve Leaflet Tile Filters, a JavaScript plugin for applying image filters to tile images
 (c) 2014, Scott Fairgrieve, HumanGeo
*/
/*
 @preserve Leaflet Tile Filters, a JavaScript plugin for apply image filters to tile images
 (c) 2014, Scott Fairgrieve, HumanGeo
*/
L.Color=L.Class.extend({initialize:function(e){this._rgb=[0,0,0],this._hsl=[0,1,.5],this._a=1,e&&this.parseColorDef(e)},parseColorDef:function(){},rgbToHSL:function(e,t,n){e/=255,t/=255,n/=255;var i,r,s=Math.max(e,t,n),a=Math.min(e,t,n),l=(s+a)/2;if(s==a)i=r=0;else{var o=s-a;switch(r=l>.5?o/(2-s-a):o/(s+a),s){case e:i=(t-n)/o+(n>t?6:0);break;case t:i=(n-e)/o+2;break;case n:i=(e-t)/o+4}i/=6}return[i,r,l]},hslToRGB:function(e,t,n){function i(e,t,n){return 0>n&&(n+=1),n>1&&(n-=1),1/6>n?e+6*(t-e)*n:.5>n?t:2/3>n?e+(t-e)*(2/3-n)*6:e}var r,s,a;if(0==t)r=s=a=n;else{var l=.5>n?n*(1+t):n+t-n*t,o=2*n-l;r=i(o,l,e+1/3),s=i(o,l,e),a=i(o,l,e-1/3)}return[Math.floor(255*r),Math.floor(255*s),Math.floor(255*a)]},setRGB:function(e,t,n){return this._rgb=[e,t,n],this._hsl=this.rgbToHSL(e,t,n),this},setHSL:function(e,t,n){return this._hsl=[e,t,n],this._rgb=this.hslToRGB(e,t,n),this},toHSL:function(){return this._hsl},toHSLString:function(){var e="hsl";return this._a<1&&(e+="a"),e+"("+(360*this._hsl[0]).toFixed(1)+","+(100*this._hsl[1]).toFixed(0)+"%,"+(100*this._hsl[2]).toFixed(0)+"%)"},toRGB:function(){return this._rgb},toRGBString:function(){var e;if(this._a<1)e="rgba("+this._rgb[0].toFixed(0)+","+this._rgb[1].toFixed(0)+","+this._rgb[2].toFixed(0)+","+this._a.toFixed(1)+")";else{for(var t=[this._rgb[0].toString(16),this._rgb[1].toString(16),this._rgb[2].toString(16)],n=0;n<t.length;++n)1===t[n].length&&(t[n]="0"+t[n]);e="#"+t.join("")}return e},r:function(e){return arguments.length?this.setRGB(e,this._rgb[1],this._rgb[2]):this._rgb[0]},g:function(e){return arguments.length?this.setRGB(this._rgb[0],e,this._rgb[2]):this._rgb[1]},b:function(e){return arguments.length?this.setRGB(this._rgb[0],this._rgb[1],e):this._rgb[2]},h:function(e){return arguments.length?this.setHSL(e,this._hsl[1],this._hsl[2]):this._hsl[0]},s:function(e){return arguments.length?this.setHSL(this._hsl[0],e,this._hsl[2]):this._hsl[1]},l:function(e){return arguments.length?this.setHSL(this._hsl[0],this._hsl[1],e):this._hsl[2]},a:function(e){return arguments.length?(this._a=e,this):this._a}}),L.RGBColor=L.Color.extend({initialize:function(e){L.Color.prototype.initialize.call(this,e)},parseColorDef:function(e){var t,n,i,r,s=e instanceof Array,a=0===e.indexOf("#"),l=[];s?(t=Math.floor(e[0]),n=Math.floor(e[1]),i=Math.floor(e[2]),r=4===e.length?e[3]:1):a?(e=e.replace("#",""),t=parseInt(e.substring(0,2),16),n=parseInt(e.substring(2,4),16),i=parseInt(e.substring(4,6),16),r=8===e.length?parseInt(e.substring(6,8),16):1):(l=e.replace("rgb","").replace("a","").replace(/\s+/g,"").replace("(","").replace(")","").split(","),t=parseInt(l[0]),n=parseInt(l[1]),i=parseInt(l[2]),r=4===l.length?parseInt(l[3]):1),this.setRGB(t,n,i),this._a=r}}),L.rgbColor=function(e){return new L.RGBColor(e)},L.ImageFilter=L.Class.extend({initialize:function(e,t){this._image=e,L.Util.setOptions(this,t)},render:function(){return this}}),L.CanvasFilter=L.ImageFilter.extend({render:function(){var e,t=L.Browser.retina?2:1,n=Math.min(this._image._layer.options.tileSize*t,256);this._image.canvasContext||(e=document.createElement("canvas"),e.width=e.height=n,this._image.canvasContext=e.getContext("2d"));var i=this._image.canvasContext;if(i){var r=this.options.channelFilter||function(e){return e};i.drawImage(this._image,0,0);var s=i.getImageData(0,0,n,n);s=r.call(this._image,s),i.putImageData(s,0,0),this._image.onload=null,this._image.removeAttribute("crossorigin"),this._image._layer.options.canvasFilter?this._image._layer.options.canvasFilter.call(this):this._image.src=e.toDataURL()}return this}}),L.ChannelFilters={},L.AlphaChannelFilter=L.Class.extend({options:{opacity:255},initialize:function(e,t){this._imageData=e,L.Util.setOptions(this,t)},setOpacity:function(e){this.options.opacity=e},updateChannels:function(e){return e[3]=this.options.opacity,e},render:function(){for(var e=this._imageData.data,t=0,n=e.length;n>t;t+=4)for(var i=this.updateChannels([e[t],e[t+1],e[t+2],e[t+3]]),r=0;4>r;++r)e[t+r]=i[r];return this._imageData}}),L.CanvasChannelFilter=L.AlphaChannelFilter.extend({options:{filters:[]},setFilters:function(e){return this.options.filters=e,this},clearFilters:function(){return this.options.filters=[],this},updateChannels:function(e){e=L.AlphaChannelFilter.prototype.updateChannels.call(this,e);for(var t=this.options.filters,n=0;n<t.length;++n)e=t[n].updateChannels(e);return e}}),L.ChannelFilter=L.Class.extend({initialize:function(e){L.Util.setOptions(this,e)},updateChannels:function(e){return e}}),L.ChannelFilters.Grayscale=L.ChannelFilter.extend({options:{channelWeights:[3,4,1]},initialize:function(){this.sumWeights()},sumWeights:function(){for(var e=0,t=0;3>t;++t)e+=this.options.channelWeights[t];this._summedWeight=e},updateChannels:function(e){var t=this.options.channelWeights;return e[0]=e[1]=e[2]=(t[0]*e[0]+t[1]*e[1]+t[2]*e[2])/this._summedWeight,e}}),L.ChannelFilters.Threshold=L.ChannelFilters.Grayscale.extend({options:{channelWeights:[3,4,1],thresholds:[128,128,128,128],trueValues:[255,255,255,255],falseValues:[0,0,0,255]},updateChannels:function(e){e=L.ChannelFilters.Grayscale.updateChannels.call(this,e);for(var t=0;4>t;++t)e[t]=e[t]>=this.options.thresholds[t]?this.options.trueValues[t]:this.options.falseValues[t];return e}}),L.ChannelFilters.Contrast=L.ChannelFilter.extend({options:{contrast:0,factor:function(e){return 255*(255+e)/(255*(255-e))}},initialize:function(){this._factor=this.options.factor.call(this,this.options.contrast)},updateChannels:function(e){for(var t=0;3>t;++t)e[t]=this._factor*(e[t]-128)+128;return e}}),L.ChannelFilters.Invert=L.ChannelFilter.extend({updateChannels:function(e){for(var t=0;3>t;++t)e[t]=255-e[t];return e}}),L.ChannelFilters.ChannelSwap=L.ChannelFilter.extend({options:{positions:[0,1]},updateChannels:function(e){var t=e[this.options.positions[0]];return e[this.options.positions[0]]=e[this.options.positions[1]],e[this.options.positions[1]]=t,e}}),L.ChannelFilters.Matrix=L.ChannelFilter.extend({options:{matrix:[.393,.769,.189,.349,.686,.168,.272,.534,.131]},updateChannels:function(e){for(var t=this.options.matrix,n=e[0],i=e[1],r=e[2],s=0;3>s;++s)e[s]=n*t[3*s]+i*t[3*s+1]+r*t[3*s+2];return e}}),L.ChannelFilters.Sepia=L.ChannelFilters.Matrix.extend({options:{matrix:[.393,.769,.189,.349,.686,.168,.272,.534,.131]}}),L.ChannelFilters.Adjust=L.ChannelFilter.extend({options:{adjustments:[20,20,20]},updateChannels:function(e){for(var t=0;3>t;++t)e[t]=Math.min(Math.max(e[t]+this.options.adjustments[t],0),255);return e}}),L.ChannelFilters.HSLAdjust=L.ChannelFilter.extend({options:{adjustments:[30,0,0]},updateChannels:function(e){var t=new L.RGBColor([e[0],e[1],e[2],e[3]]);t.setHSL((360*t._hsl[0]+this.options.adjustments[0])/360,t._hsl[1]+this.options.adjustments[1],t._hsl[2]+this.options.adjustments[2]);for(var n=0;3>n;++n)e[n]=t._rgb[n];return this.options.adjustments.length>3&&(e[3]+=this.options.adjustments[3]),t=null,e}}),L.ChannelFilters.Colorize=L.ChannelFilter.extend({options:{channel:0,values:[0,0]},updateChannels:function(e){var t=[0,1,2];t.splice(this.options.channel,1);var n=e[0],i=e[1],r=e[2];return e[this.options.channel]=(n+i+r)/3,e[t[0]]=this.options.values[0],e[t[1]]=this.options.values[1],e}}),L.CSSFilter=L.ImageFilter.extend({statics:{prefixes:["-webkit-","-moz-","-ms-","-o-",""]},render:function(){for(var e=0;e<L.CSSFilter.prefixes.length;++e)this._image.style.cssText+=" "+L.CSSFilter.prefixes[e]+"filter: "+this.options.filters.join(" ")+";"}}),L.CombinedFilter=L.ImageFilter.extend({setCanvasFilter:function(e){return this.options.canvasFilter=e,this.render()},setCSSFilter:function(e){return this.options.cssFilter=e,this.render()},render:function(){this.options.canvasFilter&&this.options.canvasFilter.call(this._image),this.options.cssFilter&&this.options.cssFilter.call(this._image)}}),L.ImageFilters={},L.ImageFilters.GenerateCSSFilter=function(e){return function(){return new L.CSSFilter(this,{filters:e}).render()}},L.ImageFilters.GenerateChannelFilter=function(e){return function(){return new L.CanvasFilter(this,{channelFilter:function(t){return new L.CanvasChannelFilter(t,{filters:e}).render()}}).render()}},L.ImageFilters.Presets={CSS:{None:function(){return this},Brightness200:L.ImageFilters.GenerateCSSFilter(["brightness(200%)"]),Brightness180:L.ImageFilters.GenerateCSSFilter(["brightness(180%)"]),Brightness160:L.ImageFilters.GenerateCSSFilter(["brightness(160%)"]),Brightness140:L.ImageFilters.GenerateCSSFilter(["brightness(140%)"]),Brightness120:L.ImageFilters.GenerateCSSFilter(["brightness(120%)"]),Brightness100:L.ImageFilters.GenerateCSSFilter(["brightness(100%)"]),Brightness80:L.ImageFilters.GenerateCSSFilter(["brightness(80%)"]),Brightness60:L.ImageFilters.GenerateCSSFilter(["brightness(60%)"]),Brightness40:L.ImageFilters.GenerateCSSFilter(["brightness(40%)"]),Brightness20:L.ImageFilters.GenerateCSSFilter(["brightness(20%)"]),Contrast200:L.ImageFilters.GenerateCSSFilter(["contrast(200%)"]),Contrast180:L.ImageFilters.GenerateCSSFilter(["contrast(180%)"]),Contrast160:L.ImageFilters.GenerateCSSFilter(["contrast(160%)"]),Contrast140:L.ImageFilters.GenerateCSSFilter(["contrast(140%)"]),Contrast120:L.ImageFilters.GenerateCSSFilter(["contrast(120%)"]),Contrast100:L.ImageFilters.GenerateCSSFilter(["contrast(100%)"]),Contrast80:L.ImageFilters.GenerateCSSFilter(["contrast(80%)"]),Contrast60:L.ImageFilters.GenerateCSSFilter(["contrast(60%)"]),Contrast40:L.ImageFilters.GenerateCSSFilter(["contrast(40%)"]),Contrast20:L.ImageFilters.GenerateCSSFilter(["contrast(20%)"]),Sepia100:L.ImageFilters.GenerateCSSFilter(["sepia(100%)"]),Sepia80:L.ImageFilters.GenerateCSSFilter(["sepia(80%)"]),Sepia60:L.ImageFilters.GenerateCSSFilter(["sepia(60%)"]),Sepia40:L.ImageFilters.GenerateCSSFilter(["sepia(40%)"]),Sepia20:L.ImageFilters.GenerateCSSFilter(["sepia(20%)"]),Saturate200:L.ImageFilters.GenerateCSSFilter(["saturate(200%)"]),Saturate300:L.ImageFilters.GenerateCSSFilter(["saturate(300%)"]),Saturate400:L.ImageFilters.GenerateCSSFilter(["saturate(400%)"]),Saturate500:L.ImageFilters.GenerateCSSFilter(["saturate(500%)"]),Saturate600:L.ImageFilters.GenerateCSSFilter(["saturate(600%)"]),Saturate700:L.ImageFilters.GenerateCSSFilter(["saturate(700%)"]),Invert100:L.ImageFilters.GenerateCSSFilter(["invert(100%)"]),Invert80:L.ImageFilters.GenerateCSSFilter(["invert(80%)"]),Invert60:L.ImageFilters.GenerateCSSFilter(["invert(60%)"]),Invert40:L.ImageFilters.GenerateCSSFilter(["invert(40%)"]),Invert20:L.ImageFilters.GenerateCSSFilter(["invert(20%)"]),HueRotate30:L.ImageFilters.GenerateCSSFilter(["hue-rotate(30deg)"]),HueRotate60:L.ImageFilters.GenerateCSSFilter(["hue-rotate(60deg)"]),HueRotate90:L.ImageFilters.GenerateCSSFilter(["hue-rotate(90deg)"]),HueRotate120:L.ImageFilters.GenerateCSSFilter(["hue-rotate(120deg)"]),HueRotate150:L.ImageFilters.GenerateCSSFilter(["hue-rotate(150deg)"]),HueRotate180:L.ImageFilters.GenerateCSSFilter(["hue-rotate(180deg)"]),HueRotate210:L.ImageFilters.GenerateCSSFilter(["hue-rotate(210deg)"]),HueRotate240:L.ImageFilters.GenerateCSSFilter(["hue-rotate(240deg)"]),HueRotate270:L.ImageFilters.GenerateCSSFilter(["hue-rotate(270deg)"]),HueRotate300:L.ImageFilters.GenerateCSSFilter(["hue-rotate(300deg)"]),HueRotate330:L.ImageFilters.GenerateCSSFilter(["hue-rotate(330deg)"])},CanvasChannel:{None:function(){return this},Grayscale1:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Grayscale]),Grayscale2:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Grayscale({weights:[1,1,1]})]),Grayscale3:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Grayscale({weights:[1,2,3]})]),HueRotate30:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[30,0,0]})]),HueRotate60:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[60,0,0]})]),HueRotate90:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[90,0,0]})]),HueRotate120:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[120,0,0]})]),HueRotate150:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[150,0,0]})]),HueRotate180:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[180,0,0]})]),HueRotate210:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[210,0,0]})]),HueRotate240:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[240,0,0]})]),HueRotate270:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[270,0,0]})]),HueRotate300:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[300,0,0]})]),HueRotate330:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.HSLAdjust({adjustments:[330,0,0]})]),Sepia1:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Sepia]),Invert:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Invert]),ColorizeRed:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Colorize({channel:0,values:[0,0]})]),ColorizeGreen:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Colorize({channel:1,values:[0,0]})]),ColorizeBlue:L.ImageFilters.GenerateChannelFilter([new L.ChannelFilters.Colorize({channel:2,values:[0,0]})])}},L.ImageFilterFunctions={__loadTile:L.TileLayer.prototype._loadTile,__tileOnLoad:L.TileLayer.prototype._tileOnLoad,setFilter:function(e){return this.options.filter=e,this.redraw()},clearFilter:function(){return this.options.filter=null,this.redraw()},_tileOnLoad:function(){var e=this._layer.options.filter;e&&e.call(this),this._layer.__tileOnLoad.call(this)},_loadTile:function(e,t){e.setAttribute("crossorigin","anonymous"),this.__loadTile.call(this,e,t)}},L.TileLayer.include(L.ImageFilterFunctions);