/*! wavesurfer.js 1.0.53
* https://github.com/katspaugh/wavesurfer.js
* @license CC-BY-3.0 */"use strict";WaveSurfer.Spectrogram={init:function(a){this.params=a;var b=this.wavesurfer=a.wavesurfer;if(!this.wavesurfer)throw Error("No WaveSurfer instance provided");this.frequenciesDataUrl=a.frequenciesDataUrl;var c=this.drawer=this.wavesurfer.drawer;if(this.container="string"==typeof a.container?document.querySelector(a.container):a.container,!this.container)throw Error("No container for WaveSurfer spectrogram");this.width=c.width,this.pixelRatio=this.params.pixelRatio||b.params.pixelRatio,this.fftSamples=this.params.fftSamples||b.params.fftSamples||512,this.height=this.fftSamples/2,this.noverlap=a.noverlap,this.windowFunc=a.windowFunc,this.alpha=a.alpha,this.createWrapper(),this.createCanvas(),this.render(),b.drawer.wrapper.onscroll=this.updateScroll.bind(this),b.on("redraw",this.render.bind(this)),b.on("destroy",this.destroy.bind(this))},destroy:function(){this.unAll(),this.wrapper&&(this.wrapper.parentNode.removeChild(this.wrapper),this.wrapper=null)},createWrapper:function(){var a=this.container.querySelector("spectrogram");a&&this.container.removeChild(a);var b=this.wavesurfer.params;this.wrapper=this.container.appendChild(document.createElement("spectrogram")),this.drawer.style(this.wrapper,{display:"block",position:"relative",userSelect:"none",webkitUserSelect:"none",height:this.height+"px"}),(b.fillParent||b.scrollParent)&&this.drawer.style(this.wrapper,{width:"100%",overflowX:"hidden",overflowY:"hidden"});var c=this;this.wrapper.addEventListener("click",function(a){a.preventDefault();var b="offsetX"in a?a.offsetX:a.layerX;c.fireEvent("click",b/c.scrollWidth||0)})},createCanvas:function(){var a=this.canvas=this.wrapper.appendChild(document.createElement("canvas"));this.spectrCc=a.getContext("2d"),this.wavesurfer.drawer.style(a,{position:"absolute",zIndex:4})},render:function(){this.updateCanvasStyle(),this.frequenciesDataUrl?this.loadFrequenciesData(this.frequenciesDataUrl):this.getFrequencies(this.drawSpectrogram)},updateCanvasStyle:function(){var a=Math.round(this.width/this.pixelRatio)+"px";this.canvas.width=this.width,this.canvas.height=this.height,this.canvas.style.width=a},drawSpectrogram:function(a,b){for(var c=(b.spectrCc,b.wavesurfer.backend.getDuration(),b.height),d=b.resample(a),e=b.buffer?2/b.buffer.numberOfChannels:1,f=0;f<d.length;f++)for(var g=0;g<d[f].length;g++){var h=255-d[f][g];b.spectrCc.fillStyle="rgb("+h+", "+h+", "+h+")",b.spectrCc.fillRect(f,c-g*e,1,e)}},getFrequencies:function(a){var b=this.fftSamples,c=this.buffer=this.wavesurfer.backend.buffer,d=c.getChannelData(0),e=c.length,f=c.sampleRate,g=[];if(!c)return void this.fireEvent("error","Web Audio buffer is not available");var h=this.noverlap;if(!h){var i=c.length/this.canvas.width;h=Math.max(0,Math.round(b-i))}for(var j=new WaveSurfer.FFT(b,f,this.windowFunc,this.alpha),k=(Math.floor(e/(b-h)),0);k+b<d.length;){for(var l=d.slice(k,k+b),m=j.calculateSpectrum(l),n=new Uint8Array(b/2),o=0;b/2>o;o++)n[o]=Math.max(-255,45*Math.log10(m[o]));g.push(n),k+=b-h}a(g,this)},loadFrequenciesData:function(a){var b=this,c=WaveSurfer.util.ajax({url:a});return c.on("success",function(a){b.drawSpectrogram(JSON.parse(a),b)}),c.on("error",function(a){b.fireEvent("error","XHR error: "+a.target.statusText)}),c},updateScroll:function(a){this.wrapper.scrollLeft=a.target.scrollLeft},resample:function(a,b){for(var b=this.width,c=[],d=1/a.length,e=1/b,f=0;b>f;f++){for(var g=new Array(a[0].length),h=0;h<a.length;h++){var i=h*d,j=i+d,k=f*e,l=k+e,m=k>=j||i>=l?0:Math.min(Math.max(j,k),Math.max(l,i))-Math.max(Math.min(j,k),Math.min(l,i));if(m>0)for(var n=0;n<a[0].length;n++)null==g[n]&&(g[n]=0),g[n]+=m/e*a[h][n]}for(var o=new Uint8Array(a[0].length),n=0;n<a[0].length;n++)o[n]=g[n];c.push(o)}return c}},WaveSurfer.FFT=function(a,b,c,d){switch(this.bufferSize=a,this.sampleRate=b,this.bandwidth=2/a*b/2,this.sinTable=new Float32Array(a),this.cosTable=new Float32Array(a),this.windowValues=new Float32Array(a),this.reverseTable=new Uint32Array(a),this.peakBand=0,this.peak=0,c){case"bartlett":for(var e=0;a>e;e++)this.windowValues[e]=2/(a-1)*((a-1)/2-Math.abs(e-(a-1)/2));break;case"bartlettHann":for(var e=0;a>e;e++)this.windowValues[e]=.62-.48*Math.abs(e/(a-1)-.5)-.38*Math.cos(2*Math.PI*e/(a-1));break;case"blackman":d=d||.16;for(var e=0;a>e;e++)this.windowValues[e]=(1-d)/2-.5*Math.cos(2*Math.PI*e/(a-1))+d/2*Math.cos(4*Math.PI*e/(a-1));break;case"cosine":for(var e=0;a>e;e++)this.windowValues[e]=Math.cos(Math.PI*e/(a-1)-Math.PI/2);break;case"gauss":d=d||.25;for(var e=0;a>e;e++)this.windowValues[e]=Math.pow(Math.E,-.5*Math.pow((e-(a-1)/2)/(d*(a-1)/2),2));break;case"hamming":for(var e=0;a>e;e++)this.windowValues[e]=.54-.46*Math.cos(2*Math.PI*e/(a-1));break;case"hann":case void 0:for(var e=0;a>e;e++)this.windowValues[e]=.5*(1-Math.cos(2*Math.PI*e/(a-1)));break;case"lanczoz":for(var e=0;a>e;e++)this.windowValues[e]=Math.sin(Math.PI*(2*e/(a-1)-1))/(Math.PI*(2*e/(a-1)-1));break;case"rectangular":for(var e=0;a>e;e++)this.windowValues[e]=1;break;case"triangular":for(var e=0;a>e;e++)this.windowValues[e]=2/a*(a/2-Math.abs(e-(a-1)/2));break;default:throw Error("No such window function '"+c+"'")}for(var e,f=1,g=a>>1;a>f;){for(e=0;f>e;e++)this.reverseTable[e+f]=this.reverseTable[e]+g;f<<=1,g>>=1}for(e=0;a>e;e++)this.sinTable[e]=Math.sin(-Math.PI/e),this.cosTable[e]=Math.cos(-Math.PI/e);this.calculateSpectrum=function(a){var b,c,d,e=this.bufferSize,f=this.cosTable,g=this.sinTable,h=this.reverseTable,i=new Float32Array(e),j=new Float32Array(e),k=2/this.bufferSize,l=Math.sqrt,m=new Float32Array(e/2),n=Math.floor(Math.log(e)/Math.LN2);if(Math.pow(2,n)!==e)throw"Invalid buffer size, must be a power of 2.";if(e!==a.length)throw"Supplied buffer is not the same size as defined FFT. FFT Size: "+e+" Buffer Size: "+a.length;for(var o,p,q,r,s,t,u,v,w=1,x=0;e>x;x++)i[x]=a[h[x]]*this.windowValues[h[x]],j[x]=0;for(;e>w;){o=f[w],p=g[w],q=1,r=0;for(var y=0;w>y;y++){for(var x=y;e>x;)s=x+w,t=q*i[s]-r*j[s],u=q*j[s]+r*i[s],i[s]=i[x]-t,j[s]=j[x]-u,i[x]+=t,j[x]+=u,x+=w<<1;v=q,q=v*o-r*p,r=v*p+r*o}w<<=1}for(var x=0,z=e/2;z>x;x++)b=i[x],c=j[x],d=k*l(b*b+c*c),d>this.peak&&(this.peakBand=x,this.peak=d),m[x]=d;return m}},WaveSurfer.util.extend(WaveSurfer.Spectrogram,WaveSurfer.Observer,WaveSurfer.FFT);