import { PolymerElement, html } from '@polymer/polymer/polymer-element.js';
import '@polymer/paper-button/paper-button.js';
import '@polymer/iron-icon/iron-icon.js';
import '@polymer/iron-iconset-svg/iron-iconset-svg.js';
import '@polymer/iron-a11y-keys/iron-a11y-keys.js';
import '@polymer/paper-tooltip/paper-tooltip.js';
import { WysiwygTool } from '../wysiwyg-tool.js';
import { WysiwygLocalize } from '../wysiwyg-localize.js';

if (document) {
	var iconset = document.createElement('iron-iconset-svg');
	iconset.setAttribute('size', 24);
	iconset.setAttribute('name', 'wysiwyg-tool-indent');

	iconset.innerHTML = `
		<svg>
			<defs>
				<g id="icon">
					<path d="M3 21h18v-2H3v2zM3 8v8l4-4-4-4zm8 9h10v-2H11v2zM3 3v2h18V3H3zm8 6h10V7H11v2zm0 4h10v-2H11v2z"></path>
				</g>
			</defs>
		</svg>
	`;

	document.body.appendChild(iconset);
}

class WysiwygToolIndent extends WysiwygTool {
	static get template() {
		return html`
			${super.template}
			<paper-button disabled="[[disabled]]" id="button" on-tap="indent">
				<iron-icon icon="wysiwyg-tool-indent:icon"></iron-icon>
			</paper-button>
			<paper-tooltip id="tooltip" for="button" position="[[tooltipPosition]]" offset="5">
				<wysiwyg-localize language="[[language]]" resources="[[resources]]" string-key="Indent"></wysiwyg-localize>
				<span> (Tab)</span>
			</paper-tooltip>
			<iron-a11y-keys id="a11y" target="[[target]]" keys="tab" on-keys-pressed="indent"></iron-a11y-keys>
		`;
	}

	ready() {
		super.ready();

		this.resources = {
			'br': {
				'Indent': 'Recuar'
			},
			'en': {
				'Indent': 'Indent'
			},
			'fr': {
				'Indent': 'Augmenter le retrait'
			},
			'de': {
				'Indent': 'Einrücken'
			}
		};

		this.allowedTagNames = ['BLOCKQUOTE'];
	}

	indent(event, detail) {
		if ((detail && detail.keyboardEvent.shiftKey) || this.disabled || !this.range0) return false;
		document.execCommand('indent');
	}

	_computeActive(range0, selectionRoot, canRedo, canUndo, value, commonAncestorPath) {
		if (!range0) return false;
		
		try {
			return document.queryCommandState('indent');
		} catch (ignore) {
			return false;
		}
	}

	_computeDisabled(range0, selectionRoot, canRedo, canUndo, value, commonAncestorPath) {
		if (!range0) return true;
		return !document.queryCommandEnabled('indent');
	}
}

customElements.define('wysiwyg-tool-indent', WysiwygToolIndent);