import { PolymerElement, html } from '@polymer/polymer/polymer-element.js';
import '@polymer/paper-button/paper-button.js';
import '@polymer/iron-icon/iron-icon.js';
import '@polymer/iron-iconset-svg/iron-iconset-svg.js';
import '@polymer/iron-a11y-keys/iron-a11y-keys.js';
import '@polymer/paper-tooltip/paper-tooltip.js';
import { WysiwygTool } from '../wysiwyg-tool.js';
import { WysiwygLocalize } from '../wysiwyg-localize.js';

if (document) {
	var iconset = document.createElement('iron-iconset-svg');
	iconset.setAttribute('size', 24);
	iconset.setAttribute('name', 'wysiwyg-tool-strike');

	iconset.innerHTML = `
		<svg>
			<defs>
				<g id="icon">
					<path d="M10 19h4v-3h-4v3zM5 4v3h5v3h4V7h5V4H5zM3 14h18v-2H3v2z"></path>
				</g>
			</defs>
		</svg>
	`;

	document.body.appendChild(iconset);
}

class WysiwygToolStrike extends WysiwygTool {
	static get template() {
		return html`
			${super.template}
			<paper-button disabled="[[disabled]]" id="button" on-tap="strikeThrough">
				<iron-icon icon="wysiwyg-tool-strike:icon"></iron-icon>
			</paper-button>
			<paper-tooltip id="tooltip" for="button" position="[[tooltipPosition]]" offset="5">
				<wysiwyg-localize language="[[language]]" resources="[[resources]]" string-key="Strikethrough"></wysiwyg-localize>
				<span> (Shift + Alt + D)</span>
			</paper-tooltip>
			<iron-a11y-keys id="a11y" target="[[target]]" keys="shift+alt+d" on-keys-pressed="strikeThrough"></iron-a11y-keys>
		`;
	}

	ready() {
		super.ready();

		this.resources = {
			'br': {
				'Strikethrough': 'Tachado'
			},
			'en': {
				'Strikethrough': 'Strikethrough'
			},
			'fr': {
				'Strikethrough': 'Barrer'
			},
			'de': {
				'Strikethrough': 'Durchgestrichen'
			}
		};

		this.allowedTagNames = ['S'];

		this.replacementTagNames = {
			'STRIKE': 'S'
		};
	}

	strikeThrough() {
		if (this.disabled || !this.range0) return false;
		document.execCommand('strikeThrough');
	}

	_computeActive(range0, selectionRoot, canRedo, canUndo, value, commonAncestorPath) {
		if (!range0) return false;
		
		try {
			return document.queryCommandState('strikeThrough');
		} catch (ignore) {
			return false;
		}
	}

	_computeDisabled(range0, selectionRoot, canRedo, canUndo, value, commonAncestorPath) {
		if (!range0) return true;
		return !document.queryCommandEnabled('strikeThrough');
	}
}

customElements.define('wysiwyg-tool-strike', WysiwygToolStrike);