// Created by Aleksandr Andreev and Mike Kroutikov (aleksandr.andreev (at) gmail.com)
//
// Based on the file: hyph_cu.tex
// See: https://github.com/slavonic/cu-tex/
// Copyright (c) 2016 Aleksandr Andreev and Mike Kroutikov
// License: MIT
Hyphenator.languages["cu"] = {
	leftmin : 1,
	rightmin : 1,
	specialChars : "а̀́̑҆̈веслѡмктꙋріднїѷѷⷠ҇ⷡⷢⷣⷤⷥⷦⷧⷨⷩⷪⷫⷬⷭⷮⷯⷰⷱⷲⷳⷴⷵⷶⷷⷸⷹⷺⷻⷼⷽⷾⷿꙴꙵꙶꙷꙸꙹꙺꙻ꙼꙽бишоѧхпѣчєгыжзю̆йьщцѝуфэѐёѕѯѳѹѻѽѿӓӥӧӭӱӹᲂꙍꙗ̇̾ъ҃ѱᲆⸯ꙾ꙿ︦︮︯",
	patterns : {
		2 : "2й2ы2ѣ8̀8́8̆8̇8̈8̏8̑8̾8ъ8ь8҃8҆8҇8ᲆ8ⷠ8ⷡ8ⷢ8ⷣ8ⷤ8ⷥ8ⷦ8ⷧ8ⷨ8ⷩ8ⷪ8ⷫ8ⷬ8ⷭ8ⷮ8ⷯ8ⷰ8ⷱ8ⷲ8ⷳ8ⷴ8ⷵ8ⷶ8ⷷ8ⷸ8ⷹ8ⷺ8ⷻ8ⷼ8ⷽ8ⷾ8ⷿ8ⸯ8ꙴ8ꙵ8ꙶ8ꙷ8ꙸ8ꙹ8ꙺ8ꙻ8꙼8꙽ѕ2ѱ2ѳ2",
		3 : "1ба1бг1бж1бы1бѐ1бє1бі1бѝ1бѡ1бѣ1бꙋ1вѐ1ві1ге1гє1гѝ1гѡ1гѣ1гѵ1дѐ1дѵ1жы1жѧ1кѵ1мⷣ1пє1пѵ1сл1сщ1сі1сѵ1сѷ1тѵ1тѷ1фе1фо1фї1фѵ1фꙋ1хі1хї1хѝ1хѡ1хѣ1хꙋ1цр1цѐ1чо1чр1чы1чє1чі1чѧ1шы1шѐ1шє1шї1шѝ1шѣ1щы1щѡ1щѣ1ѕл1ѧв1ѯа1ѯе1ѯі1ѱа1ѱі1ѱѡ1ѱѵ1ѳа1ѳл1ѳо1ѳр1ѳс1ѳы1ѳї1ѳѵ1ѳꙋ1ѵы1ѵі1ѹ҆2ав2ат2ах2аⷩ2б_2бц2бч2вв2гⷭ2дⷧ2ен2ец2жъ2жⷭ2зь2й2ик2ир2къ2кⷮ2лв2лг2лд2лж2лк2лм2лн2лп2лч2лѐ2м҃2мⷬ2нб2нк2нр2нт2нч2нѳ2нⷣ2нⷴ2ол2ор2пп2пс2пш2пѐ2пⷬ2пⷭ2рб2рг2рд2рж2рз2рл2рм2рп2рр2рт2рх2с҃2тн2тⷭ2фъ2хн2цк2ц҃2чⷣ2шъ2ш҃2щъ2єн2і̑2їм2їс2ѧб2ѯт2ѯъ2ѳъ2ѵл2ѷм8а_8е_8и_8й_8о_8у_8ы_8э_8ю_8є_8і_8ѡ_8ѣ_8ѧ_8ѵ_8ѹ_8ѻ_8ѿ_8ᲂ_8ꙋ_8ꙍ_8ꙗ_8꙾88ꙿ88︦88︮88︯8_а8_б2_в2_г2_д2_е8_ж2_з2_и8_й8_к2_л2_м2_н2_о8_п2_р2_с2_т2_у8_ф2_х2_ц2_ч2_ш2_ы8_э8_ю8_ѐ8_ё8_є8_ѕ2_і8_ї8_ѝ8_ѣ8_ѧ8_ѳ2_ѵ8_ѻ8_ѽ8_ѿ1_ӓ8_ӥ8_ӧ8_ӭ8_ӱ8_ӹ8_ᲂ8_ꙋ8_ꙍ8_ꙗ8̀1б̀1ж̀2х́1а́1е́1и́1о́1ю́1є́1ї́1ѡ́1ѣ́1ѧ́1ѻ́1ꙋ́ѳ2̈1е̑1ц̑1щ̑2х̑ѵ1̾1е̾1и̾1н̾1ѧ̾1ꙋа1аа1га1ка1ца1ча1ша1іа1ꙋа2̀а2̑а2ⷡа2ⷤа2ⷭа2ⷱб2щбл2бр2б҃2в2ав2ев2жв2ив2кв2ыв2їв2ѣв2ѧв2ꙋв̾2вл2вц2в҃2г2аг2дг2иг2ог҃2д2ад2ед2мд2од2щд2ыд2їд2ѣд2ꙋдв2дл2е1ае1бе1ге1ее1же1ие1ке1ое1ще1юе1єе1ѧе1ѯе1ѱе2́е2ⷡе2ⷣе2ⷦе2ⷫел2ес2ех2е҆1ж2дж2еж2ꙋз1кз1хз1цз1чз2ез2из2ыз2ѣз2ѧзв2зр2и1пи1чи1ши1юи2́и2̑и2ⷤи2ⷨи2ⷯиф2й1тй1цй1чк2ак2вк2лк2ок2пк2тк2ѡк2ꙋкн2кы1л2ал2ел2ил2ол2ыл2юл2єл2їл2ѡл2ѣл2ѧл2ѷл2ꙋм2ам2ем2им2ым2їм2ѧмл2мп2мѷ1н2ан2ен2ин2он2ын2юн2ін2ѣн2ѧн2ꙋнѷ1о1ао1бо1до1оо1по1то1фо1хо1шо1ѐо1єо1іо1ѝо1ѧо1ѯо1ѱо1ѳо1ѹо1ꙋо2̀о2́о2̑о2ⷣо2ⷥо2ⷦо2ⷬо8уо҆1п2ап2еп2ип2оп2тп2ѣп2ѧп2ꙋпл2пн2пѷ1п҃2пⷣ2р2ар2ер2ир2ор2ыр2юр2єр2ір2їр2ѝр2ѡр2ѣр2ѧр2ѷр2ꙋрц2р҃2рⷣ2с2ас2бс2гс2ес2ис2оск2сн2сп2сх2т2ат2вт2ет2ит2мт2от2ыт2їт2ѡт2ѣт2ѧт2ꙋтк2т҃2тⷯ2фи1х2ех2их2оц2ец2єч2цч2ꙋщ2єы1вы1ды1зы1иы1пы1ты1щы2̀ы2́ы2̑ыс2ь1бь1гь1дь1жь1кь1нь1ть1ць1чь1ꙋь2вь2щьс2ю1ею1чю1ѧю2̀ю2́ю2тю̑1є1зє2́є2цєд1єт1єч1ї1аї1иї1ої1хї1цї1чї1ѐї1ѡї1ѳї2ѯїк2ѝ1дѡ1аѡ1зѡ1иѡ1кѡ1пѡ1фѡ1шѡ1іѡ1ѧѡ2́ѣ1бѣ1еѣ1иѣ1кѣ1цѣ1шѣ1щѣ1ѧѣ1ꙋѣ2̀ѣ2́ѣ2̑ѣс2ѧ1гѧ1дѧ1еѧ1рѧ1шѧ1ѧѧ2̀ѧ2́ѳѡ1ѳѷ1ѵ1ѯѵ2́ѵ̑1ѷ1еѷ1зѷ1нѷ1рѷ1хѷк2ѽ1лѿ1бѿ1дѿ1жѿ1иѿ1кѿ1пѿ1рѿ1хѿ1чѿ1шѿ1ѧ҃д2҃з2҃и2҃к2҃л2҃н2҃р2҃с2҃т2҆1а҆1г҆1е҆1к҆1т҆1х҆1ш҆1щ҆1ю҆1є҆1ѕ҆1ѡ҆1ѧ҆1ѯ҆1ѳ҆1ѻ҆2̀҆2́҆2̑҆2ц҆п2҆ч2҇а1҇к2҇л2҇н2҇о1҇р2҇т2҇ч2҇ш2҇ь1҇ї1҇ꙋ1ᲂ8уⷢї1ⷢ҇2ⷣб2ⷣн2ⷣц2ⷣч2ⷧ҇2ⷪ҇2ⷭ҇2ꙋ1иꙋ1мꙋ1нꙋ1фꙋ1цꙋ1чꙋ1шꙋ1іꙋ1ѧꙋ2́ꙋ2̑ꙗ1в",
		4 : "1аге1акі1б2е1б2и1б2о1б2ѧ1бла1бл҃1блꙋ1бща1бще1бщи1бї11в2м1в2т1в2ѷ1вав1вае1вай1вас1ваш1ваю1ваѡ1ваѧ1вѐ1вес1вещ1ви̑1вив1вил1вим1вис1вит1вих1виш1вищ1воа1вог1вой1вок1вол1вон1вос1воч1воѡ1вы́1вы̑1вый1вык1вєд1вїа1вїй1вѡ_1вѡв1вѡм1вѣе1вѣй1вѣс1вѣх1вѧ_1вѧ̀1вѧд1вѧш1г2в1г2м1г2т1г2ї1г2ꙋ1га̀1гаг1гае1гаж1гай1гаѧ1гаѳ1гда1гдѣ1ги_1гѝ1гиб1гим1гих1гла1го_1го̀1гое1гок1гом1гот1гоц1гою1гоѧ1гоѹ1гоѻ1д2и1д2ѝ1д2ѡ1д2ѧ1дав1даг1дае1дак1даш1даю1даѧ1дв҃1дѐ1деб1деж1дей1дем1ден1дец1дма1дми1дмы1дмѝ1до̀1до́1доб1дод1дое1дои1док1дол1дом1доп1дох1доч1доѯ1ды́1дыг1дый1дым1дых1дыѧ1ді̑1дїа1дїи1дїй1дїф1дїц1дїю1дїѐ1дїѝ1дїѡ1дѣ́1дѣ̑1дѣв1дѣд1дѣл1дѣм1дѣн1дѣх1дѣш1дѣѧ1дꙋ̑1дꙋе1дꙋж1дꙋй1дꙋх1дꙋю1дꙋѧ1ейж1екк1емж1емь1епі1епⷭ1ерⷭ1ж2а1ж2и1ж2р1ж2ї1жда1жде1жди1жды1ждє1ждѝ1ждѣ1ждѧ1ждꙋ1же_1жей1жен1жес1жет1жеш1жею1жєн1жєс1жꙋ_1жꙋс1з2а1з2о1з2ю1з2ѐ1з2є1з2і1з2ѝ1з2ѡ1зе_1зѐ1зек1зем1зен1зер1зеш1зѝ1зи́1зид1зы_1зы̀1зы̑1зыл1зѣ̀1зѣм1зѣх1зѧб1зꙋ_1зꙋе1и1ꙋ1иди1идѝ1изб1изг1изм1изс1исч1ихѣ1к2д1к2м1к2ѷ1каж1как1кал1кам1кан1кар1ках1каш1кеа1кеѱ1киб1кла1кле1кло1клѡ1ко̀1ков1ког1код1кой1коц1коѝ1коѧ1коѻ1кра1кро1крі1крѡ1крѣ1крꙋ1кта1кте1кто1ктю1кті1ктѡ1кїа1кїе1кѡ_1кѡн1кꙋ̀1кꙋп1л2ѵ1л2ѻ1лаа1лае1лай1лал1лар1лах1леб1леи1лею1леѯ1леѵ1либ1лив1лид1лил1лит1лич1лищ1лог1лоѳ1лых1люб1лєм1лєс1лєц1лїн1лїо1лїс1лїт1лїч1лїѐ1лїѝ1лїѡ1лѡ̀1лѣе1лѣй1лѣм1лѧй1лѧх1лѧщ1лѷе1лꙋа1лꙋе1лꙋй1лꙋк1лꙋм1лꙋч1лꙋѧ1лꙋⷩ1м2щ1м2ѡ1м2ꙋ1ма_1ман1маш1маі1маѧ1ме_1мел1мен1мет1меш1ми_1миж1мин1мищ1мла1млѐ1млⷭ1мо_1моб1мод1мое1мож1мои1мом1мон1моп1моф1мощ1моѳ1мт҃1мч҃1мы̑1мыв1мый1мым1мыс1мых1мыѧ1мєн1мі̑1мїа1мїе1мїй1мїр1мїѝ1мїѧ1мѣ́1мѣ̑1мѣи1мѣй1мѣм1мѣх1мѧ_1мѧ́1мѧр1н2є1н2ї1н2ѡ1н2ѵ1на_1наа1наг1над1наж1нак1нам1нач1наі1наѧ1наѳ1наꙋ1не_1не̑1неб1неи1нес1неш1нив1нил1нин1нич1ниш1нищ1ниⷯ1но_1ноа1ной1нок1ноф1ноч1нош1нощ1ною1ноѧ1ны̀1ный1ных1ныѧ1ню́1нюе1нюю1нюѧ1нї1нѣе1нѣи1нѣй1нѣх1нѧе1нѧт1нѧю1нѧѧ1нꙋ_1нꙋа1нꙋв1нꙋѧ1окт1онѵ1офѵ1офѷ1охі1п2ф1п2щ1п2ы1п2ї1пак1пар1паф1паѧ1пел1пен1пет1пец1пи́1пиц1пиш1пищ1пию1по_1пои1пок1пол1пор1пот1пою1поѝ1поѧ1пта1пте1птѣ1птѧ1пѣ_1пѣ́1пѣю1пѧт1пꙋ̀1пꙋ́1пꙋс1пꙋщ1раб1раф1рах1раѡ1рею1риц1рою1роѳ1рю_1рют1рєм1рєс1рєѝ1рїд1рїн1рїц1рѡд1рѡн1рѡп1рѡі1рѧ_1рѷн1рѷѱ1рꙋй1рꙋк1рꙋс1рꙋⷯ1с2ї1с2ѧ1с2ѳ1с2ꙋ1саа1сав1саж1саи1сан1саф1саш1сей1си̑1сиб1сив1сим1сит1сиф1сиц1сиш1скв1скї1сма1сме1смо1смы1смѝ1смѣ1снц1со_1со́1сог1сод1сож1сок1сор1соѧ1ст҃1сы_1сы̀1сыл1сып1сыщ1сѡ̀1сѡ́1сѣк1сѣн1сѣх1сѣщ1т2х1т2ѳ1таи1тай1там1таш1твѝ1тел1теш1тиш1тищ1тог1трє1трї1трѡ1трѧ1тєл1тєц1тїй1тїк1тїо1тїф1тїѐ1тїѝ1тѡв1тѡм1тѡн1тѣ̑1тѣш1тѧ̀1тѧ̑1тꙋе1тꙋн1ф2а1ф2л1ф2н1ф2ѡ1фї1фі̑1фѷ11х2в1х2л1ха̀1ха́1ха̑1хаа1хаи1хал1хѝ1хи́1хи̑1хищ1хо_1хое1хом1хоп1хоѻ1ц2в1цам1цѐ1цег1цею1цы̑1цыи1цєм1цї11цѣ́1цѣ̑1цѣй1цѣл1цꙋ̑1ч2а1ч2е1ч2и1ч2л1ч2ї1ч2ѝ1чтѝ1чтⷭ1чѣ11чꙋ̀1чꙋ́1чꙋж1чꙋщ1ш2а1ш2е1ш2и1ш2ꙋ1шї1щ2е1щ2и1щ2ї1щ2ѧ1щ2ꙋ1ща_1ща̀1щаг1щєм1щєс1ю́з1ютс1юще1ющъ1ющь1ющѧ1є́ю1єтн1єѵ11їнъ1їтѝ1їѳа1ѡ1г1ѡ1ч1ѡ́ѳ1ѡак1ѡкр1ѡпа1ѡпр1ѡсл1ѡсщ1ѧ1и1ѧ́в1ѧ́н1ѧ̑н1ѧ̑т1ѧ̑ю1ѧдѐ1ѧжд1ѧйс1ѧл11ѧмъ1ѧнн1ѧсн1ѧсъ1ѧсꙋ1ѯї11ѳї1ѳѧ11ѵ2а1ѵ2и1ѵ2о1ѵ2ꙋ1ѹ1х1ѻ1б1ѻ1к1ѻ1н1ѻ2ц1ѿ1е1ѿ1с1ᲂу҆1ꙋбі1ꙋкр1ꙋма1ꙋмъ1ꙋмѡ1ꙋмꙋ1ꙋсы1ꙋтр2а1е2а1и2а1ю2а1ѡ2а1ѧ2а́е2а́ж2а́з2а́т2а́х2а́ш2а́ю2а́ї2а́ѧ2а́ѵ2аго2адѐ2адѝ2адѧ2азд2азꙋ2амъ2анъ2арь2аст2б1б2б1м2б1х2б1ш2б2ъ2б̾12бвѐ2блъ2бль2бн22бръ2брь2бщн2бь12в1г2в2ъ2ваⷤ2вди2виг2виж2влъ2вль2внш2внъ2внї2внѧ2воѐ2воє2воѝ2воѧ2вс22вь12вѡи2вѣт2вⷣ22г1х2г1ч2гг҃2гдъ2глс2глъ2гль2гнъ2гнь2гⷣ22д1б2д1д2д1к2д1т2д1ч2д2ъ2двѣ2дею2дла2дмь2днс2дню2днї2днѡ2дою2дръ2дс22дх22е1ѡ2е2ⷨ2е́а2е́е2е́ч2екі2елп2елъ2ель2емѡ2емⷣ2еръ2етш2ешл2ж1б2ж1г2ж1к2ж1ц2ж1ш2ж2ь2ждш2ждъ2ждь2з2ъ2заи2звр2звъ2звѣ2зди2здн2здо2здъ2здь2здѝ2злс2злъ2знс2знъ2знь2знѡ2зра2зыг2зыщ2зѧ̀2и́в2и́ж2и́ц2и́ч2ида2итс2ицъ2иши2и҃22клс2клъ2кль2кнъ2кр҃2крⷭ2ктъ2кхъ2л1т2л1ф2л1ц2л1ш2л2ъ2лад2лаж2лач2лащ2лѐ2лео2лиж2лип2лх22люд2люч2лі̑2лѣб2лѧ̑2лѧг2л҃22лⷣ22м1м2м2ъ2мв22мль2мнъ2мнѡ2мок2мпї2мтъ2мча2мчї2мїю2мѣш2мѣщ2мѣѧ2мꙋщ2н1з2н2ъ2наб2нд22неє2нид2нм22ноб2нц22нѣꙋ2н҃22о1е2о1ж2о1и2о1ч2о1ю2о́м2о́р2о́с2о́ц2оде2одн2одѣ2окъ2омс2онт2опи2опо2опі2опѝ2опѣ2осѧ2ото2отꙋ2п1к2п1ц2п1ч2п2ъ2пѐ2плъ2пль2пнѡ2прь2прє2птр2р1н2р1ф2р1ч2р1ѳ2р2ъ2р2ⷭ2рв22реш2рит2рк22рс22рыѧ2рѧд2рѧс2рѷп2с1ч2с2ъ2скъ2слс2слъ2сль2смь2снъ2снь2спл2спр2сс22стс2стъ2схв2схо2сш22сын2сѣ̑2сѣм2т1д2т1т2т2ъ2т2ь2твъ2твь2теп2теф2тиг2тиж2тин2тлш2тоѧ2тръ2трь2тыд2тыж2тєз2тѡп2тѡѧ2тѣм2тꙋк2ф1ѳ2х1ж2х1ш2х2ъ2хаг2хаѧ2ц1т2ц2ъ2цеп2ч1к2ч2ь2чей2чн22чт҃2ч҃22ш1к2ш1ц2ш1ш2щ1н2ю́б2юст2ющѣ2є1ѝ2є́ч2і́а2і́л2їе2їм2їс2ї1е2ї1ю2ї1є2ї1ѝ2ї1ѧ2їа́2їѝ2їим2їих2ѡ́в2ѡнѵ2ѡпе2ѡпы2ѧ̑з2ѧ̑к2ѧзь2ѧзє2ѧсѐ2ѧтс2ѧтъ2ѵ1г2ѵ1д2ѵ1м2ѵ1н2ѵ1п2ѵ1т2ѵ1ф2ѵ1ѱ2ѵ1ѳ2ѵ2ъ2ѵ2ⷢ2ѵ́м2ѷм2ѵк22ѵр22ѵс22ѷ1ѱ2ѷпр2ѷпі2ꙋ1а2ꙋ1е2ꙋ1ю2ꙋ2̀2ꙋ2ⷧ2ꙋ2ⷩ2ꙋ2ⷯ2ꙋ́в2ꙋ́е2ꙋ́ж2ꙋ́п2ꙋ́х2ꙋ́ю2ꙋ́ѧ2ꙋ́ѳ2ꙋбы2ꙋбѡ2ꙋві2ꙋко2ꙋми2ꙋмі2ꙋмѝ2ꙋтс2ꙋтъ2ꙋть2ꙋши8аⷠ_8аⷡ_8аⷢ_8аⷣ_8аⷤ_8аⷥ_8аⷦ_8аⷧ_8аⷨ_8аⷩ_8аⷪ_8аⷫ_8аⷬ_8аⷭ_8аⷮ_8аⷯ_8аⷰ_8аⷱ_8аⷲ_8аⷳ_8аⷴ_8аⷵ_8аⷶ_8аⷷ_8аⷸ_8аⷹ_8аⷺ_8аⷻ_8аⷼ_8аⷽ_8аⷾ_8аⷿ_8аꙴ_8аꙵ_8аꙶ_8аꙷ_8аꙸ_8аꙹ_8аꙺ_8аꙻ_8а꙼_8а꙽_8еⷠ_8еⷡ_8еⷢ_8еⷣ_8еⷤ_8еⷥ_8еⷦ_8еⷧ_8еⷨ_8еⷩ_8еⷪ_8еⷫ_8еⷬ_8еⷭ_8еⷮ_8еⷯ_8еⷰ_8еⷱ_8еⷲ_8еⷳ_8еⷴ_8еⷵ_8еⷶ_8еⷷ_8еⷸ_8еⷹ_8еⷺ_8еⷻ_8еⷼ_8еⷽ_8еⷾ_8еⷿ_8еꙴ_8еꙵ_8еꙶ_8еꙷ_8еꙸ_8еꙹ_8еꙺ_8еꙻ_8е꙼_8е꙽_8й_8иⷠ_8иⷡ_8иⷢ_8иⷣ_8иⷤ_8иⷥ_8иⷦ_8иⷧ_8иⷨ_8иⷩ_8иⷪ_8иⷫ_8иⷬ_8иⷭ_8иⷮ_8иⷯ_8иⷰ_8иⷱ_8иⷲ_8иⷳ_8иⷴ_8иⷵ_8иⷶ_8иⷷ_8иⷸ_8иⷹ_8иⷺ_8иⷻ_8иⷼ_8иⷽ_8иⷾ_8иⷿ_8иꙴ_8иꙵ_8иꙶ_8иꙷ_8иꙸ_8иꙹ_8иꙺ_8иꙻ_8и꙼_8и꙽_8йⷠ_8йⷡ_8йⷢ_8йⷣ_8йⷤ_8йⷥ_8йⷦ_8йⷧ_8йⷨ_8йⷩ_8йⷪ_8йⷫ_8йⷬ_8йⷭ_8йⷮ_8йⷯ_8йⷰ_8йⷱ_8йⷲ_8йⷳ_8йⷴ_8йⷵ_8йⷶ_8йⷷ_8йⷸ_8йⷹ_8йⷺ_8йⷻ_8йⷼ_8йⷽ_8йⷾ_8йⷿ_8йꙴ_8йꙵ_8йꙶ_8йꙷ_8йꙸ_8йꙹ_8йꙺ_8йꙻ_8й꙼_8й꙽_8оⷠ_8оⷡ_8оⷢ_8оⷣ_8оⷤ_8оⷥ_8оⷦ_8оⷧ_8оⷨ_8оⷩ_8оⷪ_8оⷫ_8оⷬ_8оⷭ_8оⷮ_8оⷯ_8оⷰ_8оⷱ_8оⷲ_8оⷳ_8оⷴ_8оⷵ_8оⷶ_8оⷷ_8оⷸ_8оⷹ_8оⷺ_8оⷻ_8оⷼ_8оⷽ_8оⷾ_8оⷿ_8оꙴ_8оꙵ_8оꙶ_8оꙷ_8оꙸ_8оꙹ_8оꙺ_8оꙻ_8о꙼_8о꙽_8уⷠ_8уⷡ_8уⷢ_8уⷣ_8уⷤ_8уⷥ_8уⷦ_8уⷧ_8уⷨ_8уⷩ_8уⷪ_8уⷫ_8уⷬ_8уⷭ_8уⷮ_8уⷯ_8уⷰ_8уⷱ_8уⷲ_8уⷳ_8уⷴ_8уⷵ_8уⷶ_8уⷷ_8уⷸ_8уⷹ_8уⷺ_8уⷻ_8уⷼ_8уⷽ_8уⷾ_8уⷿ_8уꙴ_8уꙵ_8уꙶ_8уꙷ_8уꙸ_8уꙹ_8уꙺ_8уꙻ_8у꙼_8у꙽_8ыⷠ_8ыⷡ_8ыⷢ_8ыⷣ_8ыⷤ_8ыⷥ_8ыⷦ_8ыⷧ_8ыⷨ_8ыⷩ_8ыⷪ_8ыⷫ_8ыⷬ_8ыⷭ_8ыⷮ_8ыⷯ_8ыⷰ_8ыⷱ_8ыⷲ_8ыⷳ_8ыⷴ_8ыⷵ_8ыⷶ_8ыⷷ_8ыⷸ_8ыⷹ_8ыⷺ_8ыⷻ_8ыⷼ_8ыⷽ_8ыⷾ_8ыⷿ_8ыꙴ_8ыꙵ_8ыꙶ_8ыꙷ_8ыꙸ_8ыꙹ_8ыꙺ_8ыꙻ_8ы꙼_8ы꙽_8эⷠ_8эⷡ_8эⷢ_8эⷣ_8эⷤ_8эⷥ_8эⷦ_8эⷧ_8эⷨ_8эⷩ_8эⷪ_8эⷫ_8эⷬ_8эⷭ_8эⷮ_8эⷯ_8эⷰ_8эⷱ_8эⷲ_8эⷳ_8эⷴ_8эⷵ_8эⷶ_8эⷷ_8эⷸ_8эⷹ_8эⷺ_8эⷻ_8эⷼ_8эⷽ_8эⷾ_8эⷿ_8эꙴ_8эꙵ_8эꙶ_8эꙷ_8эꙸ_8эꙹ_8эꙺ_8эꙻ_8э꙼_8э꙽_8юⷠ_8юⷡ_8юⷢ_8юⷣ_8юⷤ_8юⷥ_8юⷦ_8юⷧ_8юⷨ_8юⷩ_8юⷪ_8юⷫ_8юⷬ_8юⷭ_8юⷮ_8юⷯ_8юⷰ_8юⷱ_8юⷲ_8юⷳ_8юⷴ_8юⷵ_8юⷶ_8юⷷ_8юⷸ_8юⷹ_8юⷺ_8юⷻ_8юⷼ_8юⷽ_8юⷾ_8юⷿ_8юꙴ_8юꙵ_8юꙶ_8юꙷ_8юꙸ_8юꙹ_8юꙺ_8юꙻ_8ю꙼_8ю꙽_8ѐ8_8ё8_8єⷠ_8єⷡ_8єⷢ_8єⷣ_8єⷤ_8єⷥ_8єⷦ_8єⷧ_8єⷨ_8єⷩ_8єⷪ_8єⷫ_8єⷬ_8єⷭ_8єⷮ_8єⷯ_8єⷰ_8єⷱ_8єⷲ_8єⷳ_8єⷴ_8єⷵ_8єⷶ_8єⷷ_8єⷸ_8єⷹ_8єⷺ_8єⷻ_8єⷼ_8єⷽ_8єⷾ_8єⷿ_8єꙴ_8єꙵ_8єꙶ_8єꙷ_8єꙸ_8єꙹ_8єꙺ_8єꙻ_8є꙼_8є꙽_8іⷠ_8іⷡ_8іⷢ_8іⷣ_8іⷤ_8іⷥ_8іⷦ_8іⷧ_8іⷨ_8іⷩ_8іⷪ_8іⷫ_8іⷬ_8іⷭ_8іⷮ_8іⷯ_8іⷰ_8іⷱ_8іⷲ_8іⷳ_8іⷴ_8іⷵ_8іⷶ_8іⷷ_8іⷸ_8іⷹ_8іⷺ_8іⷻ_8іⷼ_8іⷽ_8іⷾ_8іⷿ_8іꙴ_8іꙵ_8іꙶ_8іꙷ_8іꙸ_8іꙹ_8іꙺ_8іꙻ_8і꙼_8і꙽_8ї8_8ѝ8_8ѡⷠ_8ѡⷡ_8ѡⷢ_8ѡⷣ_8ѡⷤ_8ѡⷥ_8ѡⷦ_8ѡⷧ_8ѡⷨ_8ѡⷩ_8ѡⷪ_8ѡⷫ_8ѡⷬ_8ѡⷭ_8ѡⷮ_8ѡⷯ_8ѡⷰ_8ѡⷱ_8ѡⷲ_8ѡⷳ_8ѡⷴ_8ѡⷵ_8ѡⷶ_8ѡⷷ_8ѡⷸ_8ѡⷹ_8ѡⷺ_8ѡⷻ_8ѡⷼ_8ѡⷽ_8ѡⷾ_8ѡⷿ_8ѡꙴ_8ѡꙵ_8ѡꙶ_8ѡꙷ_8ѡꙸ_8ѡꙹ_8ѡꙺ_8ѡꙻ_8ѡ꙼_8ѡ꙽_8ѣⷠ_8ѣⷡ_8ѣⷢ_8ѣⷣ_8ѣⷤ_8ѣⷥ_8ѣⷦ_8ѣⷧ_8ѣⷨ_8ѣⷩ_8ѣⷪ_8ѣⷫ_8ѣⷬ_8ѣⷭ_8ѣⷮ_8ѣⷯ_8ѣⷰ_8ѣⷱ_8ѣⷲ_8ѣⷳ_8ѣⷴ_8ѣⷵ_8ѣⷶ_8ѣⷷ_8ѣⷸ_8ѣⷹ_8ѣⷺ_8ѣⷻ_8ѣⷼ_8ѣⷽ_8ѣⷾ_8ѣⷿ_8ѣꙴ_8ѣꙵ_8ѣꙶ_8ѣꙷ_8ѣꙸ_8ѣꙹ_8ѣꙺ_8ѣꙻ_8ѣ꙼_8ѣ꙽_8ѧⷠ_8ѧⷡ_8ѧⷢ_8ѧⷣ_8ѧⷤ_8ѧⷥ_8ѧⷦ_8ѧⷧ_8ѧⷨ_8ѧⷩ_8ѧⷪ_8ѧⷫ_8ѧⷬ_8ѧⷭ_8ѧⷮ_8ѧⷯ_8ѧⷰ_8ѧⷱ_8ѧⷲ_8ѧⷳ_8ѧⷴ_8ѧⷵ_8ѧⷶ_8ѧⷷ_8ѧⷸ_8ѧⷹ_8ѧⷺ_8ѧⷻ_8ѧⷼ_8ѧⷽ_8ѧⷾ_8ѧⷿ_8ѧꙴ_8ѧꙵ_8ѧꙶ_8ѧꙷ_8ѧꙸ_8ѧꙹ_8ѧꙺ_8ѧꙻ_8ѧ꙼_8ѧ꙽_8ѵⷠ_8ѵⷡ_8ѵⷢ_8ѵⷣ_8ѵⷤ_8ѵⷥ_8ѵⷦ_8ѵⷧ_8ѵⷨ_8ѵⷩ_8ѵⷪ_8ѵⷫ_8ѵⷬ_8ѵⷭ_8ѵⷮ_8ѵⷯ_8ѵⷰ_8ѵⷱ_8ѵⷲ_8ѵⷳ_8ѵⷴ_8ѵⷵ_8ѵⷶ_8ѵⷷ_8ѵⷸ_8ѵⷹ_8ѵⷺ_8ѵⷻ_8ѵⷼ_8ѵⷽ_8ѵⷾ_8ѵⷿ_8ѵꙴ_8ѵꙵ_8ѵꙶ_8ѵꙷ_8ѵꙸ_8ѵꙹ_8ѵꙺ_8ѵꙻ_8ѵ꙼_8ѵ꙽_8ѹⷠ_8ѹⷡ_8ѹⷢ_8ѹⷣ_8ѹⷤ_8ѹⷥ_8ѹⷦ_8ѹⷧ_8ѹⷨ_8ѹⷩ_8ѹⷪ_8ѹⷫ_8ѹⷬ_8ѹⷭ_8ѹⷮ_8ѹⷯ_8ѹⷰ_8ѹⷱ_8ѹⷲ_8ѹⷳ_8ѹⷴ_8ѹⷵ_8ѹⷶ_8ѹⷷ_8ѹⷸ_8ѹⷹ_8ѹⷺ_8ѹⷻ_8ѹⷼ_8ѹⷽ_8ѹⷾ_8ѹⷿ_8ѹꙴ_8ѹꙵ_8ѹꙶ_8ѹꙷ_8ѹꙸ_8ѹꙹ_8ѹꙺ_8ѹꙻ_8ѹ꙼_8ѹ꙽_8ѻⷠ_8ѻⷡ_8ѻⷢ_8ѻⷣ_8ѻⷤ_8ѻⷥ_8ѻⷦ_8ѻⷧ_8ѻⷨ_8ѻⷩ_8ѻⷪ_8ѻⷫ_8ѻⷬ_8ѻⷭ_8ѻⷮ_8ѻⷯ_8ѻⷰ_8ѻⷱ_8ѻⷲ_8ѻⷳ_8ѻⷴ_8ѻⷵ_8ѻⷶ_8ѻⷷ_8ѻⷸ_8ѻⷹ_8ѻⷺ_8ѻⷻ_8ѻⷼ_8ѻⷽ_8ѻⷾ_8ѻⷿ_8ѻꙴ_8ѻꙵ_8ѻꙶ_8ѻꙷ_8ѻꙸ_8ѻꙹ_8ѻꙺ_8ѻꙻ_8ѻ꙼_8ѻ꙽_8ѽ8_8ѽⷠ_8ѽⷡ_8ѽⷢ_8ѽⷣ_8ѽⷤ_8ѽⷥ_8ѽⷦ_8ѽⷧ_8ѽⷨ_8ѽⷩ_8ѽⷪ_8ѽⷫ_8ѽⷬ_8ѽⷭ_8ѽⷮ_8ѽⷯ_8ѽⷰ_8ѽⷱ_8ѽⷲ_8ѽⷳ_8ѽⷴ_8ѽⷵ_8ѽⷶ_8ѽⷷ_8ѽⷸ_8ѽⷹ_8ѽⷺ_8ѽⷻ_8ѽⷼ_8ѽⷽ_8ѽⷾ_8ѽⷿ_8ѽꙴ_8ѽꙵ_8ѽꙶ_8ѽꙷ_8ѽꙸ_8ѽꙹ_8ѽꙺ_8ѽꙻ_8ѽ꙼_8ѽ꙽_8ѿⷠ_8ѿⷡ_8ѿⷢ_8ѿⷣ_8ѿⷤ_8ѿⷥ_8ѿⷦ_8ѿⷧ_8ѿⷨ_8ѿⷩ_8ѿⷪ_8ѿⷫ_8ѿⷬ_8ѿⷭ_8ѿⷮ_8ѿⷯ_8ѿⷰ_8ѿⷱ_8ѿⷲ_8ѿⷳ_8ѿⷴ_8ѿⷵ_8ѿⷶ_8ѿⷷ_8ѿⷸ_8ѿⷹ_8ѿⷺ_8ѿⷻ_8ѿⷼ_8ѿⷽ_8ѿⷾ_8ѿⷿ_8ѿꙴ_8ѿꙵ_8ѿꙶ_8ѿꙷ_8ѿꙸ_8ѿꙹ_8ѿꙺ_8ѿꙻ_8ѿ꙼_8ѿ꙽_8ӓ8_8ӥ8_8ӧ8_8ӭ8_8ӱ8_8ӹ8_8ᲂу_8ᲂⷠ_8ᲂⷡ_8ᲂⷢ_8ᲂⷣ_8ᲂⷤ_8ᲂⷥ_8ᲂⷦ_8ᲂⷧ_8ᲂⷨ_8ᲂⷩ_8ᲂⷪ_8ᲂⷫ_8ᲂⷬ_8ᲂⷭ_8ᲂⷮ_8ᲂⷯ_8ᲂⷰ_8ᲂⷱ_8ᲂⷲ_8ᲂⷳ_8ᲂⷴ_8ᲂⷵ_8ᲂⷶ_8ᲂⷷ_8ᲂⷸ_8ᲂⷹ_8ᲂⷺ_8ᲂⷻ_8ᲂⷼ_8ᲂⷽ_8ᲂⷾ_8ᲂⷿ_8ᲂꙴ_8ᲂꙵ_8ᲂꙶ_8ᲂꙷ_8ᲂꙸ_8ᲂꙹ_8ᲂꙺ_8ᲂꙻ_8ᲂ꙼_8ᲂ꙽_8ꙋⷠ_8ꙋⷡ_8ꙋⷢ_8ꙋⷣ_8ꙋⷤ_8ꙋⷥ_8ꙋⷦ_8ꙋⷧ_8ꙋⷨ_8ꙋⷩ_8ꙋⷪ_8ꙋⷫ_8ꙋⷬ_8ꙋⷭ_8ꙋⷮ_8ꙋⷯ_8ꙋⷰ_8ꙋⷱ_8ꙋⷲ_8ꙋⷳ_8ꙋⷴ_8ꙋⷵ_8ꙋⷶ_8ꙋⷷ_8ꙋⷸ_8ꙋⷹ_8ꙋⷺ_8ꙋⷻ_8ꙋⷼ_8ꙋⷽ_8ꙋⷾ_8ꙋⷿ_8ꙋꙴ_8ꙋꙵ_8ꙋꙶ_8ꙋꙷ_8ꙋꙸ_8ꙋꙹ_8ꙋꙺ_8ꙋꙻ_8ꙋ꙼_8ꙋ꙽_8ꙍⷠ_8ꙍⷡ_8ꙍⷢ_8ꙍⷣ_8ꙍⷤ_8ꙍⷥ_8ꙍⷦ_8ꙍⷧ_8ꙍⷨ_8ꙍⷩ_8ꙍⷪ_8ꙍⷫ_8ꙍⷬ_8ꙍⷭ_8ꙍⷮ_8ꙍⷯ_8ꙍⷰ_8ꙍⷱ_8ꙍⷲ_8ꙍⷳ_8ꙍⷴ_8ꙍⷵ_8ꙍⷶ_8ꙍⷷ_8ꙍⷸ_8ꙍⷹ_8ꙍⷺ_8ꙍⷻ_8ꙍⷼ_8ꙍⷽ_8ꙍⷾ_8ꙍⷿ_8ꙍꙴ_8ꙍꙵ_8ꙍꙶ_8ꙍꙷ_8ꙍꙸ_8ꙍꙹ_8ꙍꙺ_8ꙍꙻ_8ꙍ꙼_8ꙍ꙽_8ꙗⷠ_8ꙗⷡ_8ꙗⷢ_8ꙗⷣ_8ꙗⷤ_8ꙗⷥ_8ꙗⷦ_8ꙗⷧ_8ꙗⷨ_8ꙗⷩ_8ꙗⷪ_8ꙗⷫ_8ꙗⷬ_8ꙗⷭ_8ꙗⷮ_8ꙗⷯ_8ꙗⷰ_8ꙗⷱ_8ꙗⷲ_8ꙗⷳ_8ꙗⷴ_8ꙗⷵ_8ꙗⷶ_8ꙗⷷ_8ꙗⷸ_8ꙗⷹ_8ꙗⷺ_8ꙗⷻ_8ꙗⷼ_8ꙗⷽ_8ꙗⷾ_8ꙗⷿ_8ꙗꙴ_8ꙗꙵ_8ꙗꙶ_8ꙗꙷ_8ꙗꙸ_8ꙗꙹ_8ꙗꙺ_8ꙗꙻ_8ꙗ꙼_8ꙗ꙽__а̀8_а́8_а̑8_а҆8_аⷠ8_аⷡ8_аⷢ8_аⷣ8_аⷤ8_аⷥ8_аⷦ8_аⷧ8_аⷨ8_аⷩ8_аⷪ8_аⷫ8_аⷬ8_аⷭ8_аⷮ8_аⷯ8_аⷰ8_аⷱ8_аⷲ8_аⷳ8_аⷴ8_аⷵ8_аⷶ8_аⷷ8_аⷸ8_аⷹ8_аⷺ8_аⷻ8_аⷼ8_аⷽ8_аⷾ8_аⷿ8_аꙴ8_аꙵ8_аꙶ8_аꙷ8_аꙸ8_аꙹ8_аꙺ8_аꙻ8_а꙼8_а꙽8_би2_вн2_вї1_вꙋ1_гї1_др2_дї1_ѐ8_е́8_ё8_е̑8_е҆8_еⷠ8_еⷡ8_еⷢ8_еⷣ8_еⷤ8_еⷥ8_еⷦ8_еⷧ8_еⷨ8_еⷩ8_еⷪ8_еⷫ8_еⷬ8_еⷭ8_еⷮ8_еⷯ8_еⷰ8_еⷱ8_еⷲ8_еⷳ8_еⷴ8_еⷵ8_еⷶ8_еⷷ8_еⷸ8_еⷹ8_еⷺ8_еⷻ8_еⷼ8_еⷽ8_еⷾ8_еⷿ8_еꙴ8_еꙵ8_еꙶ8_еꙷ8_еꙸ8_еꙹ8_еꙺ8_еꙻ8_е꙼8_е꙽8_зо1_зꙋ1_ѝ8_и́8_й8_и̑8_и҆8_иⷠ8_иⷡ8_иⷢ8_иⷣ8_иⷤ8_иⷥ8_иⷦ8_иⷧ8_иⷨ8_иⷩ8_иⷪ8_иⷫ8_иⷬ8_иⷭ8_иⷮ8_иⷯ8_иⷰ8_иⷱ8_иⷲ8_иⷳ8_иⷴ8_иⷵ8_иⷶ8_иⷷ8_иⷸ8_иⷹ8_иⷺ8_иⷻ8_иⷼ8_иⷽ8_иⷾ8_иⷿ8_иꙴ8_иꙵ8_иꙶ8_иꙷ8_иꙸ8_иꙹ8_иꙺ8_иꙻ8_и꙼8_и꙽8_й̀8_й́8_й̈8_й̑8_й҆8_йⷠ8_йⷡ8_йⷢ8_йⷣ8_йⷤ8_йⷥ8_йⷦ8_йⷧ8_йⷨ8_йⷩ8_йⷪ8_йⷫ8_йⷬ8_йⷭ8_йⷮ8_йⷯ8_йⷰ8_йⷱ8_йⷲ8_йⷳ8_йⷴ8_йⷵ8_йⷶ8_йⷷ8_йⷸ8_йⷹ8_йⷺ8_йⷻ8_йⷼ8_йⷽ8_йⷾ8_йⷿ8_йꙴ8_йꙵ8_йꙶ8_йꙷ8_йꙸ8_йꙹ8_йꙺ8_йꙻ8_й꙼8_й꙽8_ки2_кл2_ль2_лї1_лѷ1_не1_ню2_нї1_нꙋ2_о̀8_о́8_о̑8_о҆8_оⷠ8_оⷡ8_оⷢ8_оⷣ8_оⷤ8_оⷥ8_оⷦ8_оⷧ8_оⷨ8_оⷩ8_оⷪ8_оⷫ8_оⷬ8_оⷭ8_оⷮ8_оⷯ8_оⷰ8_оⷱ8_оⷲ8_оⷳ8_оⷴ8_оⷵ8_оⷶ8_оⷷ8_оⷸ8_оⷹ8_оⷺ8_оⷻ8_оⷼ8_оⷽ8_оⷾ8_оⷿ8_оꙴ8_оꙵ8_оꙶ8_оꙷ8_оꙸ8_оꙹ8_оꙺ8_оꙻ8_о꙼8_о꙽8_пї1_ри2_ст2_сє1_тл2_ть2_тї1_тѷ2_у̀8_у́8_у̑8_у҆8_уⷠ8_уⷡ8_уⷢ8_уⷣ8_уⷤ8_уⷥ8_уⷦ8_уⷧ8_уⷨ8_уⷩ8_уⷪ8_уⷫ8_уⷬ8_уⷭ8_уⷮ8_уⷯ8_уⷰ8_уⷱ8_уⷲ8_уⷳ8_уⷴ8_уⷵ8_уⷶ8_уⷷ8_уⷸ8_уⷹ8_уⷺ8_уⷻ8_уⷼ8_уⷽ8_уⷾ8_уⷿ8_уꙴ8_уꙵ8_уꙶ8_уꙷ8_уꙸ8_уꙹ8_уꙺ8_уꙻ8_у꙼8_у꙽8_фо2_фї1_хе1_хѡ1_ша1_щꙋ1_ы̀8_ы́8_ы̑8_ы҆8_ыⷠ8_ыⷡ8_ыⷢ8_ыⷣ8_ыⷤ8_ыⷥ8_ыⷦ8_ыⷧ8_ыⷨ8_ыⷩ8_ыⷪ8_ыⷫ8_ыⷬ8_ыⷭ8_ыⷮ8_ыⷯ8_ыⷰ8_ыⷱ8_ыⷲ8_ыⷳ8_ыⷴ8_ыⷵ8_ыⷶ8_ыⷷ8_ыⷸ8_ыⷹ8_ыⷺ8_ыⷻ8_ыⷼ8_ыⷽ8_ыⷾ8_ыⷿ8_ыꙴ8_ыꙵ8_ыꙶ8_ыꙷ8_ыꙸ8_ыꙹ8_ыꙺ8_ыꙻ8_ы꙼8_ы꙽8_э̀8_э́8_э̑8_э҆8_эⷠ8_эⷡ8_эⷢ8_эⷣ8_эⷤ8_эⷥ8_эⷦ8_эⷧ8_эⷨ8_эⷩ8_эⷪ8_эⷫ8_эⷬ8_эⷭ8_эⷮ8_эⷯ8_эⷰ8_эⷱ8_эⷲ8_эⷳ8_эⷴ8_эⷵ8_эⷶ8_эⷷ8_эⷸ8_эⷹ8_эⷺ8_эⷻ8_эⷼ8_эⷽ8_эⷾ8_эⷿ8_эꙴ8_эꙵ8_эꙶ8_эꙷ8_эꙸ8_эꙹ8_эꙺ8_эꙻ8_э꙼8_э꙽8_ю̀8_ю́8_ю̈8_ю̑8_ю҆8_юⷠ8_юⷡ8_юⷢ8_юⷣ8_юⷤ8_юⷥ8_юⷦ8_юⷧ8_юⷨ8_юⷩ8_юⷪ8_юⷫ8_юⷬ8_юⷭ8_юⷮ8_юⷯ8_юⷰ8_юⷱ8_юⷲ8_юⷳ8_юⷴ8_юⷵ8_юⷶ8_юⷷ8_юⷸ8_юⷹ8_юⷺ8_юⷻ8_юⷼ8_юⷽ8_юⷾ8_юⷿ8_юꙴ8_юꙵ8_юꙶ8_юꙷ8_юꙸ8_юꙹ8_юꙺ8_юꙻ8_ю꙼8_ю꙽8_є̀8_є́8_є̈8_є̑8_є҆8_єⷠ8_єⷡ8_єⷢ8_єⷣ8_єⷤ8_єⷥ8_єⷦ8_єⷧ8_єⷨ8_єⷩ8_єⷪ8_єⷫ8_єⷬ8_єⷭ8_єⷮ8_єⷯ8_єⷰ8_єⷱ8_єⷲ8_єⷳ8_єⷴ8_єⷵ8_єⷶ8_єⷷ8_єⷸ8_єⷹ8_єⷺ8_єⷻ8_єⷼ8_єⷽ8_єⷾ8_єⷿ8_єꙴ8_єꙵ8_єꙶ8_єꙷ8_єꙸ8_єꙹ8_єꙺ8_єꙻ8_є꙼8_є꙽8_і̀8_і́8_ї8_і̑8_і҆8_іⷠ8_іⷡ8_іⷢ8_іⷣ8_іⷤ8_іⷥ8_іⷦ8_іⷧ8_іⷨ8_іⷩ8_іⷪ8_іⷫ8_іⷬ8_іⷭ8_іⷮ8_іⷯ8_іⷰ8_іⷱ8_іⷲ8_іⷳ8_іⷴ8_іⷵ8_іⷶ8_іⷷ8_іⷸ8_іⷹ8_іⷺ8_іⷻ8_іⷼ8_іⷽ8_іⷾ8_іⷿ8_іꙴ8_іꙵ8_іꙶ8_іꙷ8_іꙸ8_іꙹ8_іꙺ8_іꙻ8_і꙼8_і꙽8_ѡ1с_ѣ̀8_ѣ́8_ѣ̈8_ѣ̑8_ѣ҆8_ѣⷠ8_ѣⷡ8_ѣⷢ8_ѣⷣ8_ѣⷤ8_ѣⷥ8_ѣⷦ8_ѣⷧ8_ѣⷨ8_ѣⷩ8_ѣⷪ8_ѣⷫ8_ѣⷬ8_ѣⷭ8_ѣⷮ8_ѣⷯ8_ѣⷰ8_ѣⷱ8_ѣⷲ8_ѣⷳ8_ѣⷴ8_ѣⷵ8_ѣⷶ8_ѣⷷ8_ѣⷸ8_ѣⷹ8_ѣⷺ8_ѣⷻ8_ѣⷼ8_ѣⷽ8_ѣⷾ8_ѣⷿ8_ѣꙴ8_ѣꙵ8_ѣꙶ8_ѣꙷ8_ѣꙸ8_ѣꙹ8_ѣꙺ8_ѣꙻ8_ѣ꙼8_ѣ꙽8_ѧ̀8_ѧ́8_ѧ̈8_ѧ̑8_ѧ҆8_ѧⷠ8_ѧⷡ8_ѧⷢ8_ѧⷣ8_ѧⷤ8_ѧⷥ8_ѧⷦ8_ѧⷧ8_ѧⷨ8_ѧⷩ8_ѧⷪ8_ѧⷫ8_ѧⷬ8_ѧⷭ8_ѧⷮ8_ѧⷯ8_ѧⷰ8_ѧⷱ8_ѧⷲ8_ѧⷳ8_ѧⷴ8_ѧⷵ8_ѧⷶ8_ѧⷷ8_ѧⷸ8_ѧⷹ8_ѧⷺ8_ѧⷻ8_ѧⷼ8_ѧⷽ8_ѧⷾ8_ѧⷿ8_ѧꙴ8_ѧꙵ8_ѧꙶ8_ѧꙷ8_ѧꙸ8_ѧꙹ8_ѧꙺ8_ѧꙻ8_ѧ꙼8_ѧ꙽8_ѳї1_ѵ̀8_ѵ́8_ѵ̈8_ѵ̑8_ѵ҆8_ѵⷠ8_ѵⷡ8_ѵⷢ8_ѵⷣ8_ѵⷤ8_ѵⷥ8_ѵⷦ8_ѵⷧ8_ѵⷨ8_ѵⷩ8_ѵⷪ8_ѵⷫ8_ѵⷬ8_ѵⷭ8_ѵⷮ8_ѵⷯ8_ѵⷰ8_ѵⷱ8_ѵⷲ8_ѵⷳ8_ѵⷴ8_ѵⷵ8_ѵⷶ8_ѵⷷ8_ѵⷸ8_ѵⷹ8_ѵⷺ8_ѵⷻ8_ѵⷼ8_ѵⷽ8_ѵⷾ8_ѵⷿ8_ѵꙴ8_ѵꙵ8_ѵꙶ8_ѵꙷ8_ѵꙸ8_ѵꙹ8_ѵꙺ8_ѵꙻ8_ѵ꙼8_ѵ꙽8_ѻ̀8_ѻ́8_ѻ̈8_ѻ̑8_ѻ҆8_ѻⷠ8_ѻⷡ8_ѻⷢ8_ѻⷣ8_ѻⷤ8_ѻⷥ8_ѻⷦ8_ѻⷧ8_ѻⷨ8_ѻⷩ8_ѻⷪ8_ѻⷫ8_ѻⷬ8_ѻⷭ8_ѻⷮ8_ѻⷯ8_ѻⷰ8_ѻⷱ8_ѻⷲ8_ѻⷳ8_ѻⷴ8_ѻⷵ8_ѻⷶ8_ѻⷷ8_ѻⷸ8_ѻⷹ8_ѻⷺ8_ѻⷻ8_ѻⷼ8_ѻⷽ8_ѻⷾ8_ѻⷿ8_ѻꙴ8_ѻꙵ8_ѻꙶ8_ѻꙷ8_ѻꙸ8_ѻꙹ8_ѻꙺ8_ѻꙻ8_ѻ꙼8_ѻ꙽8_ѽ̀8_ѽ́8_ѽ̈8_ѽ̑8_ѽ҆8_ѽⷠ8_ѽⷡ8_ѽⷢ8_ѽⷣ8_ѽⷤ8_ѽⷥ8_ѽⷦ8_ѽⷧ8_ѽⷨ8_ѽⷩ8_ѽⷪ8_ѽⷫ8_ѽⷬ8_ѽⷭ8_ѽⷮ8_ѽⷯ8_ѽⷰ8_ѽⷱ8_ѽⷲ8_ѽⷳ8_ѽⷴ8_ѽⷵ8_ѽⷶ8_ѽⷷ8_ѽⷸ8_ѽⷹ8_ѽⷺ8_ѽⷻ8_ѽⷼ8_ѽⷽ8_ѽⷾ8_ѽⷿ8_ѽꙴ8_ѽꙵ8_ѽꙶ8_ѽꙷ8_ѽꙸ8_ѽꙹ8_ѽꙺ8_ѽꙻ8_ѽ꙼8_ѽ꙽8_ᲂ̀8_ᲂ́8_ᲂ̈8_ᲂ̑8_ᲂ҆8_ᲂⷠ8_ᲂⷡ8_ᲂⷢ8_ᲂⷣ8_ᲂⷤ8_ᲂⷥ8_ᲂⷦ8_ᲂⷧ8_ᲂⷨ8_ᲂⷩ8_ᲂⷪ8_ᲂⷫ8_ᲂⷬ8_ᲂⷭ8_ᲂⷮ8_ᲂⷯ8_ᲂⷰ8_ᲂⷱ8_ᲂⷲ8_ᲂⷳ8_ᲂⷴ8_ᲂⷵ8_ᲂⷶ8_ᲂⷷ8_ᲂⷸ8_ᲂⷹ8_ᲂⷺ8_ᲂⷻ8_ᲂⷼ8_ᲂⷽ8_ᲂⷾ8_ᲂⷿ8_ᲂꙴ8_ᲂꙵ8_ᲂꙶ8_ᲂꙷ8_ᲂꙸ8_ᲂꙹ8_ᲂꙺ8_ᲂꙻ8_ᲂ꙼8_ᲂ꙽8_ꙋ̀8_ꙋ́8_ꙋ̈8_ꙋ̑8_ꙋ҆8_ꙋⷠ8_ꙋⷡ8_ꙋⷢ8_ꙋⷣ8_ꙋⷤ8_ꙋⷥ8_ꙋⷦ8_ꙋⷧ8_ꙋⷨ8_ꙋⷩ8_ꙋⷪ8_ꙋⷫ8_ꙋⷬ8_ꙋⷭ8_ꙋⷮ8_ꙋⷯ8_ꙋⷰ8_ꙋⷱ8_ꙋⷲ8_ꙋⷳ8_ꙋⷴ8_ꙋⷵ8_ꙋⷶ8_ꙋⷷ8_ꙋⷸ8_ꙋⷹ8_ꙋⷺ8_ꙋⷻ8_ꙋⷼ8_ꙋⷽ8_ꙋⷾ8_ꙋⷿ8_ꙋꙴ8_ꙋꙵ8_ꙋꙶ8_ꙋꙷ8_ꙋꙸ8_ꙋꙹ8_ꙋꙺ8_ꙋꙻ8_ꙋ꙼8_ꙋ꙽8_ꙍ̀8_ꙍ́8_ꙍ̈8_ꙍ̑8_ꙍ҆8_ꙍⷠ8_ꙍⷡ8_ꙍⷢ8_ꙍⷣ8_ꙍⷤ8_ꙍⷥ8_ꙍⷦ8_ꙍⷧ8_ꙍⷨ8_ꙍⷩ8_ꙍⷪ8_ꙍⷫ8_ꙍⷬ8_ꙍⷭ8_ꙍⷮ8_ꙍⷯ8_ꙍⷰ8_ꙍⷱ8_ꙍⷲ8_ꙍⷳ8_ꙍⷴ8_ꙍⷵ8_ꙍⷶ8_ꙍⷷ8_ꙍⷸ8_ꙍⷹ8_ꙍⷺ8_ꙍⷻ8_ꙍⷼ8_ꙍⷽ8_ꙍⷾ8_ꙍⷿ8_ꙍꙴ8_ꙍꙵ8_ꙍꙶ8_ꙍꙷ8_ꙍꙸ8_ꙍꙹ8_ꙍꙺ8_ꙍꙻ8_ꙍ꙼8_ꙍ꙽8_ꙗ̀8_ꙗ́8_ꙗ̈8_ꙗ̑8_ꙗ҆8_ꙗⷠ8_ꙗⷡ8_ꙗⷢ8_ꙗⷣ8_ꙗⷤ8_ꙗⷥ8_ꙗⷦ8_ꙗⷧ8_ꙗⷨ8_ꙗⷩ8_ꙗⷪ8_ꙗⷫ8_ꙗⷬ8_ꙗⷭ8_ꙗⷮ8_ꙗⷯ8_ꙗⷰ8_ꙗⷱ8_ꙗⷲ8_ꙗⷳ8_ꙗⷴ8_ꙗⷵ8_ꙗⷶ8_ꙗⷷ8_ꙗⷸ8_ꙗⷹ8_ꙗⷺ8_ꙗⷻ8_ꙗⷼ8_ꙗⷽ8_ꙗⷾ8_ꙗⷿ8_ꙗꙴ8_ꙗꙵ8_ꙗꙶ8_ꙗꙷ8_ꙗꙸ8_ꙗꙹ8_ꙗꙺ8_ꙗꙻ8_ꙗ꙼8_ꙗ꙽8́1ва́1ве́1ви́1во́1вы́1вє́1вї́1вѡ́1вѣ́1вѧ́1га́1ги́1го́1да́1де́1до́1дї́1дѣ́1дꙋ́1же́1жꙋ́1зе́1зи́1зы́1зѣ́1зѧ́1ка́1ки́1ко́1кр́1кї́1кѡ́1ла́1ле́1ли́1ло́1лы́1лю́1лє́1лї́1лѡ́1лѣ́1лѧ́1лꙋ́1ма́1ме́1мо́1мы́1мє́1мі́1мї́1мѣ́1мѧ́1на́1не́1ни́1но́1ны́1ню́1нѣ́1нѧ́1нꙋ́1па́1пе́1по́1пꙋ́1ра́1ре́1ри́1ро́1ры́1рю́1рї́1рѡ́1рѧ́1рꙋ́1са́1се́1си́1со́1сы́1сѣ́1та́1те́1ти́1то́1ты́1тє́1тї́1тѡ́1тѧ́1ха́1хо́1ца́1цꙋ́1ї́2гѓ2дм́2зл́2й1́2кх́2мт́б1н́б1ц́б1ч́б2р́ба1́бы1́бѣ1́бꙋ1́в1в́в1с́гл2́д1с́д2р́е2с́е2х́еж2́зд2́и1в́й1́ил2́л2д́л2х́н1ќн1ц́н1ч́о2м́п1с́п1ш́п2л́р1р́с1ш́с2ќс2л́с2т́т1н́ть1́хї2́хꙋ1́ч1н́чє1́чї1́шꙋ1́щѧ1́ї2ќїа1́їи1́ѧ1т́ѧв1́ѳо2́ѵ2ќѵ2с́ѵи1̑1вы̑1ги̑1др̑1ды̑1зы̑1и2̑1ки̑1ла̑1ли̑1ны̑1нѧ̑1ра̑1ри̑1ры̑1са̑1см̑1тв̑1ти̑1ю1̑1ѧ2̑2гг̑2й1̑2кл̑в1с̑гꙋ2̑ди1̑жї1̑за2̑й1̑ин1̑м1н̑нї1̑пї1̑р1с̑с1с̑с2л̑с2т̑т1н̑ч1н̑че1̑чи1̑чї1̑ща1̑ѧн1̾1ѡ1̾1ѻ1̾2с2̾и1м̾и́1̾не1̾ꙋ1в̾ꙋ́2а1б2а1ваа1веа1виа1выа1вѡа1вѣа1вѵа1вꙋа1даа1доа1дыа1діа1зеа1зиа1зыа1зѣа1лаа1леа1лиа1лоа1лыа1люа1ліа1лѝа1лѡа1лѣа1лѧа1маа1миа1моа1мыа1міа1мѝа1мѣа1ноа1ныа1нѐа1нѝа1нѣа1нѧа1нꙋа1раа1роа1рыа1рюа1рѐа1рєа1ріа1рѡа1рѣа1саа1сиа1соа1сыа1сѐа1сєа1сѝа1сѡа1сѣа1таа1тва1теа1тиа1тоа1тра1тыа1тіа1тѝа1тѡа1тѣа1тѧа1тꙋа1хаа1хиа1хоа1щ2а1ї1а1ѳ2а́1ца́1ѳа́7ѣа́г2а́к2а̑2ба̑ж2аа̑2абѣ2ав1вавѷ1ае1дае1саз1ваза2азѡ1аи1лаи1май1аи̑2аке1аки1акл2ал1дал1ман1дан1цапї1ар1вар1дар1кар1лар1мар1сар1тас1сафа2афї1ахꙋ1ацѣ2ач1начꙋ2ашꙋ2ащꙋ2аі́1аї1аїа1аѡ1наѳа2аѳо1аѵ1раѵ1са҆а1а҆к2а҆ѵ1б1ниб1нꙋб1цаб1цыб1цꙋб2диба1нба̑2баг2бе1сбе2хбет1бза2би1рби2мби̑1бин2бна1бне2бнї1бо1нбо1рбо1щбое2бож2бос2бша1бшꙋ1бы1мбє́2бі́2бї1бѡ1лбѡ̑1бѣ1дбѣ1лбѣ1сбѣ1тбѧ2тбꙋ1рбꙋ̑1в1вав1выв1вꙋв2вев2дѡв2п2в2сав2сев2сив2сюв2сѐв2сѝв2сѣв2сꙋв2х2в2їв2ѝ1ва1двал2вах2вго1ве1ввжи1вза1взи1ви1рви1фвѝ1вмѣ1вно1во1вво1рвож2воз1впе1вро2врꙋ1вша1вшꙋ1вы1свєн1вї1квї1нвї1свѧ1чв҃о1в҃ы1га1вга1лга1мга̑1ге1дгее2геѡ2гко1го1лгоп2гоꙋ1грї2грѷ1грꙋ1гст2гша1гше1гшї1гї1ггѵ́1г҃о1гꙋ2тгꙋ́1гꙋ̑1гꙋю1д2вед2вєд2вꙋд2лѧд2нѐд2їд̾ꙋ1да1мдбѣ2де1сди1лди1нди1рди1фдис2дка1дко1дна1днꙋ1до1рдоꙋ1дпо1дпꙋ1дша1дшꙋ1дїо1дѡ1ндѡ2мдѧ1хдѧ2тдѧз2дѵ́2дꙋ1бдꙋ2те1вае1вие1вое1вые1вєе1вѡе1вѣе1вѧе1вꙋе1дае1дее1дме1дое1дые1дѣе1зее1зѧе1лае1лее1лое1лые1люе1лєе1лѝе1лѣе1мае1мие1мое1мые1нае1нее1ние1ное1ные1нѐе1ніе1нѝе1нѣе1нѧе1нꙋе1п2е1рае1рее1рое1рые1рюе1ріе1рїе1рѝе1рѧе1рꙋе1сае1сие1сне1сое1спе1сые1сѐе1сєе1сѝе1сѡе1сѣе1тае1тее1тые1тѣе1тꙋе1ф2е1цае1цые1цꙋе1чѐе1чⷭе1ш2е1ѕ2е1ѳ2е1ѻ1е1ѿ1е1ꙋ1е2̑2е2й1е́1ѯе́п2е́ю1е́ѵ2е̑н1еа1меа̑1ебѣ2ев1сега1ед1сед1хедр2ее1сез1ꙋеи1меи1теи́1ей1еиз1ека2екꙋ2ен1мен1цео1непи1епо1ер1бер1вер1гер1кер1сер1херн2есї1ефа2еч1неши1еѡ1деѡ1реѧ́1еѯа2еѳо2еѵ1кеѵ1реѵ1сеѻр2жа1мжа2тжа2хжа̑1жи1вжи̑1жка1жко1жна1жно1жнї1жнѧ1жро2жрꙋ2жша1жше1жїѧ1жꙋ́1з1лиз1лѣз1нѣз1рꙋз1ꙋ̑з̾и1за1вза1дза1лза1мза1сзак2збе1згн2зго1зе1взжи1зза1ззо1зи1рзко1зо1взо2мзои1зос2зпа1зпи2зрѧ2зсе1зсы1зсї1зхо1зцѣ1зши1зшꙋ1зє́2зєм1зї1зѡ1рзѡ́1зѣ̑1и1б2и1веи1вии1вои1выи1вѝи1вѡи1вꙋи1д2и1ж2и1зыи1зѣи1каи1кии1кли1кои1кри1кти1кіи1кѝи1кѡи1кѣи1лаи1леи1лии1лои1лѡи1лѣи1лѧи1лꙋи1маи1мии1мои1мыи1мѣи1неи1нои1ныи1ніи1нѝи1нѣи1нѧи1раи1рои1рєи1ріи1рѝи1рѣи1рѧи1саи1таи1тви1теи1тии1три1тыи1тѐи1тєи1тіи1тѝи1хаи1хои1ц2и1щ2и1ѡ1и1ѳ2ѝ1ди́1фи́1ши́с2й1тй1цй1чи̑1дибо2ив1сидо2идї1из1лиза2изо1ипї1ир1гис1сисї1ифа2их1тихꙋ2ица2ицє1ицѣ2ич1ниш2лише2ишꙋ2ию́1и҆1ли҆1ми҆г2иꙋ́2й1д2й1ж2й1м2й1н2й1с2й1ш2йде2йдꙋ2йне1йно1йню1йнї1йнѧ1йнꙋ1йст2йте1йче1йша1йшꙋ1к2нѧк2р2к2ѷква2кво1ке1ске2лкер1ки1нкка1кша1кше1кє́2кѡ1лкѡ1рл1вал1вел1выл1вѣл1вꙋл1гал1гил1дел1дєл1кил1кіл1кѝл1кѡл1мал1мил1мыл1мѣл1нел1нил1нол1ныл1пел1піл1пѝл1пѡл1пѣл2жал2жил2жѝл2жꙋл2їлак2лам2лас2лв1сле1чле2хлев2ли1клли1лн1цлнї1ло1нло1рло1щлоб2лом2лпї1лфа1лфе2лхї1лцѣ2лч1нлче2лчї1лшꙋ1лє1влѣ2хлѧ2тлѷ1клѻр1л҃о1лꙋ1бм1вам2г2м2з2м2нѐм2нѧм2чⷭм2їма1ѯмаѵ1ме2смеж2ми1мми1рми̑1мма1мот2мро2мрꙋ2мфа1мфе1мфї1мша1мше1мшї1мшꙋ1мщꙋ2мє́2мѡ1лмѡ̑1мѡи1мѣ1нмѷ1мѷг2мꙋ̑1н1дан1ден1дін1дѣн1ман1мен1мин1мѝн1мѣн1рѐн1тан1тин1тін1тїн1тѡн1тѣн1цєн1ѳин1ѳін2кан2кѝн2кѡн2кꙋна1вна1лна1снае1нди2не1вне1лне2хне2цнег2нео1ник2нна1нне1нно1нню1ннѧ1ннꙋ1но1лнож2ноп2нот2нст2нсї1нч1ннче2нша1нше1ншꙋ1нї1кнї1мнї1ннїо1нѣ̑1нѳї2нѷ1о1вао1вио1воо1выо1вєо1вѡо1вѣо1г2о1зио1зыо1зѣо1зѧо1к2о1лао1лео1лио1лоо1лыо1люо1лєо1ліо1лїо1лѝо1лѡо1лѣо1лѧо1лꙋо1мео1мио1мто1мчо1мыо1мѣо1нао1нео1нио1ноо1ныо1нѐо1ніо1нѝо1нѧо1нꙋо1рао1рео1роо1рыо1рюо1рєо1ріо1рѝо1рѡо1рѣо1рѧо1рꙋо1сао1смо1соо1сыо1сѝо1сѣо1ц2о1щао1щєо1щѝо1ї1о1ѡ1о1ѻ1о1ᲂуо2й1о́к2о́ї2о̑л1оа1моб2роби1ого1од1сод2водї1одꙋ2ое1вое1дое1созд2озн2ои1мои1той1ои̑2ол1вол1гол1кол1нол1пол1хол1чон1дон1кон1мон1рон1цон1чонї1оо́2ор1вор1дор1жор1лор1сор1тос1сос2лосї1от1ноть1офа2ох1нохе2охꙋ1оша2ошꙋ2ощї1ощꙋ2оє́1оі́2ої1оѧ1зоѳе2оѹ҆1оꙋ1боꙋ1воꙋ1тоꙋ1хп1пап1пеп2нѝп2сѝпа1хпе1спи1нпит2пка1пки2пко1пкꙋ1по1щпож2поп2пох2поꙋ1при1прї1прꙋ2пцы1пцѣ2пще1пы́2пє́2пї1кпї1лпї1мпѣ1спѣ̑1пѵ́1пѷ1р1вар1влр1вор1выр1гар1гир1гір1дар1дер1дор1дыр1дєр1дір1дѣр1ждр1жер1жєр1жꙋр1зер1зир1кар1квр1кїр1кѡр1кѣр1лир1мар1мер1мир1мор1мѝр1пар1пер1пир1пѝр1пѣр1пѧр1рар1сар1сир1сѣр1тар1тер1тор1тыр1тір1тїр1хар1хир2глр2плр2пⷣр2щ1р2ѷра1дра1лра1мрб1нрбе2рбѣ2ре1лре1срее1реж2реи1рек2рем2рет2реѡ1рза2рзѡ1ри1кри1хри̑1рив2рню1рнѧ1рнꙋ1ро1лро1щрод2рое2рож2роп2рот2рп1српї2рт1нрхї1рхꙋ2рче1ршꙋ1ры̑1рѣ1лрѣ1срѣ1трѧ1нрѳе2рѳо1рѵ́1р҃ї1рꙋ1дрꙋ1зс1скс1сѡс2кѡс2лес2лис2лыс2люс2лєс2лѝс2лѡс2лѣс2лѧс2м2с2сѣс2їса1дса1тса1хсаꙋ2сва1сга1се1все1лсе1мсе1ссе1чсег2си1рсми1смѧ1сне2сно1снї1со1всо1лсое1сои2сом2соꙋ2сри2сро2ссѷ1ст2лсчи1сша1сшї1сю́1сі̑2сї1ксї1нсї1псї1ссїо1сѳе2сꙋ1рсꙋ̑1сꙋе1сꙋм2т1нит1ніт2лют2лѧт2р2т2сѣт2їта1дта1ртаѵ1твї1твѡ1тде1те1сте1чте2хтек2тем1ти1хтнї1то1нто1щтод2том2тос2тот2тох2тст2тха1тхо1тхї2тцѣ2тча2тша2тшы1тще1ты2хть1стю́1тї1лтї1мтї1нтѣ1лтѳе2тꙋ1дтꙋ̑2фа1вфа1мфа1нфе1вфе1лфе1сфла1фло1фнꙋ2фо1вфо2мфра2фре2фрꙋ1фѡ1тфѳо2фѷ1фꙋ́2фꙋ̑2ха1нха1рхво2хо1щход2хож2хре1хри1хро1хрї1хрѷ1хст2хї1мхї1схї2кхѡ1тхꙋ1дхꙋ1лц1киц1кїцто2цы́1цє́2цїо2цⷣе1цꙋ́2ч1нач1ноч1ныч1нѣч2тєч2тꙋч2їча1вча1лча1мче1лче2мчет2чи1вчи1нчи2лчи2хчи̑1чле1чнї1что2чша1чше1чши2чі́1ч҃е1ч҃ї2чꙋ̑2ш1лєш1лѧша1нша2мше1лше1сше1хшее1шет2ши1вши1рши2лши2хшла2шна1шно1шню1шнѧ1шце1шша1шшꙋ1шы2мшїи1шꙋю1ще1сще2хщее1щи1тщнꙋ1щст2щша1щше1щы2мщїи1щꙋ2тщꙋ́1щꙋю1ъ1д2ы1г2ы1ж2ы1коы1л2ы1маы1миы1ниы1нюы1нѣы1реы1риы1рюы1рєы1рѣы1рѧы1скы1соы1сѡы1хаы1ѧ1ы2й1ы́1цы́2вы́к2ы́с2ы̑1бы̑2мы̑ч1ы̑ш1ыдо2ыза2ызы1ый1ыла2ын1мыпа2ыр1мытї1ыш1лыша2ыше2ыщꙋ2ь1з2ь1меь1миь1мѝь1скь1ш2ь2мыь2мѣь2мꙋь2п2ьво2ьде1ьзꙋ1ька1ькї1ькꙋ1ьна1ьно1ьнї1ьнꙋ1ьст2ьте1ьтє1ьтѧ1ьче1ьша1ьшꙋ1ьꙋ́1ю1даю1дею1дмю1дію1с2ю1щ2ю1ю1ю́1жю́2лю́ю1юд1сюче2юща1ющꙋ1ю҆1рє1ває1выє1лиє1мыє1ниє1ныє1с2є́2цєнї1єст2є҆1фє҆г2ѕла2ѕмї1ѕѣ1лѕѣ́2і́1фі́1ці́1чі́2пі́2ѯі́2ѳі́г2і́и1і́к2ї1аї1иї1ої1хї1цї1чї1ѐї1ѡї1ѳї2ѯїк2і̑2кі̑р1і҆г2і҆к2ї1в2ї1гаї1гиї1д2ї1кеї1кої1ктї1кії1кѡї1леї1лиї1лії1маї1неї1ної1раї1реї1саї1сеї1сєї1сѡї1т2ї1ф2ї1ѷ1ї2й1їа1дїа1мїа1нївї1їдї1їе2мїи1нїи1тїй1їи̑2їн1дїн1тїо1мїо1нїп1пїпї1їр1сїс1сїтѷ1їтꙋ2їє́1їѡ1нїѡ1сїѳе2ѝдѣ1ѡ1ваѡ1веѡ1выѡ1вꙋѡ1даѡ1діѡ1лиѡ1лыѡ1ліѡ1лѡѡ1лѣѡ1мыѡ1мѣѡ1мѵѡ1наѡ1неѡ1ниѡ1ныѡ1ніѡ1нꙋѡ1раѡ1роѡ1рыѡ1рꙋѡ1тиѡ1тыѡ1тіѡ1ѷ1ѡ́1пѡ́1чѡ̑1тѡ̑м1ѡбо1ѡбѣ2ѡбꙋ1ѡго2ѡзо2ѡи1сѡи́2ѡр1сѡс1сѡсї1ѡі́1ѡѧ́1ѡ҆1мѡ҆1пѡ҆1рѡ҆1чѡ҆к2ѣ1ваѣ1виѣ1г2ѣ1даѣ1доѣ1дыѣ1ж2ѣ1леѣ1лиѣ1лєѣ1лѝѣ1лѡѣ1лѣѣ1лѧѣ1маѣ1меѣ1миѣ1ниѣ1нѝѣ1нѣѣ1нѧѣ1піѣ1пѝѣ1рєѣ1рѧѣ1сиѣ1снѣ1сѝѣ1сѡѣ1сѣѣ1таѣ1теѣ1тиѣ1тоѣ1тѐѣ1тіѣ1тѝѣ1тꙋѣ1хаѣ1хиѣ1хоѣ1чѐѣ1ю1ѣ2й1ѣ́1цѣ́з2ѣ́с2ѣ́є1ѣ̑1вѣ̑с2ѣ̑ш1ѣбо2ѣго2ѣдѡ2ѣй1ѣка2ѣкꙋ2ѣн1цѣн1чѣнї1ѣсѧ1ѣхꙋ2ѣцѣ2ѣче2ѣша2ѣщꙋ2ѣꙋ́1ѧ1ваѧ1виѧ1ж2ѧ1миѧ1ниѧ1ныѧ1нѝѧ1с2ѧ1таѧ1теѧ1тиѧ1тоѧ1тыѧ1тіѧ1тѝѧ1тѣѧ1тꙋѧ1цаѧ1цыѧ1щ2ѧ1ю1ѧ2̑1ѧ2й1ѧ́1цѧ́1чѧ́1шѧ́1щѧв1сѧго1ѧдо1ѧдꙋ2ѧем1ѧй1ѧре2ѧт1нѧть1ѧч1нѧщї1ѧщѧ1ѧ҆̀1ѯе1нѯї1ѱа́2ѱі́2ѱѵ́1ѳа1вѳа1лѳа1нѳеа1ѳеѡ2ѳле1ѳо1лѳо1нѳо2вѳо́1ѳра2ѳсї1ѳїс2ѳѷ1ѳꙋ́1ѵ1клѵ1кіѵ1лаѵ1леѵ1лꙋѵ1раѵ1рыѵ1ріѵ1рѡѵ1рѣѵ1сеѵ2ктѵ́1сѵ́1фѵ́п2ѷ1еѷ1зѷ1нѷ1рѷ1хѷк2ѵ̑р2ѵа1рѵа́2ѵди1ѵдо1ѵдї1ѵи1нѵно2ѵнї1ѵо́2ѵст2ѵсї1ѵсѷ1ѵтѷ1ѵ҆1пѵ҆а1ѷ1гдѷ1каѷ1кеѷ1ктѷ1л2ѷ1п2ѷе1лѷе́2ѷза2ѷла2ѷм1вѷна1ѷри2ѷро1ѷрї1ѷхї1ѹ҆1лѹ҆1пѹ҆̀1ѹ҆г2ѹ҆с2ѹ҆т2ѻбо1ѻке1ѻнꙋ2ѻте2ѻ҆1нѻ҆1пѻ҆г2ѻ҆к2ѻ҆т2ѿ1в2ѿ1г2ѿ1л2ѿ1м2ѿ1н2ѿ1т2ѿ1ѻ1ѿбѣ1ѿе́2ѿже1ѿи1мѿи1тѿи́1ѿкꙋ2ѿлꙋ1ѿме1ѿмы1ѿне2ѿню2ѿпа1ѿре1ѿри2ѿсе2ѿто2ѿчꙋ1ѿше2҃а1в҃а1т҃а2л҃а2х҃а́1҃а̑1҃го1҃е1с҃ен1҃ер1҃ло2҃лє1҃не2҃нї1҃о1л҃о1н҃о1р҃о1с҃оꙋ1҃ре2҃рї1҃се2҃ст2҃сѡ1҃ше2҃є́2҃і́1҃ѣ́2҃ꙋ́1҆1бщ҆1ве҆1ви҆1вы҆1вѝ҆1вѣ҆1вѧ҆1вѵ҆1д2҆1ж2҆1зи҆1зы҆1ла҆1ле҆1ли҆1ло҆1лі҆1лї҆1лѝ҆1ма҆1ме҆1ми҆1мл҆1мо҆1мы҆1мѣ҆1на҆1не҆1ни҆1но҆1ны҆1ні҆1нѝ҆1нѣ҆1па҆1пе҆1пл҆1по҆1пі҆1пѡ҆1ра҆1ре҆1ри҆1ро҆1рѧ҆1са҆1си҆1см҆1сѝ҆1сѣ҆1фі҆1ї1҆1ꙋ́҆1ꙋс҆2чт҆́1к҆́1т҆́1ш҆́2л҆́б2҆́г2҆́и1҆́с2҆́ю1҆а1д҆а̑1҆б1н҆в1в҆г2г҆г2л҆г2н҆дї1҆е2с҆ер2҆з1в҆з1л҆зо2҆ке1҆кї2҆кѷ1҆л1м҆л1п҆м1в҆н1д҆н1т҆н1ц҆н1ѳ҆нї1҆пї1҆р1д҆р1к҆р1п҆р1с҆р1т҆р1х҆с1с҆с2л҆сї1҆сѷ2҆т2л҆т2ц҆ше1҆шꙋ2҆щѧ2҆є́1҆ѡ1н҆ѡ1р҆ѡ1с҆ѡ́1҆ѯа1҆ѳа1҆ѵ1к҆ѵ1л҆ѵ1р҆ѵ1с҆ѻр1҇е1в҇и́1҇ко2҇лї1҇нї1҇нꙋ1҇ро2҇ть1҇тї1҇ша1҇ше1҇ї1ⷢї1ⷣна1ⷣне2ⷣнї1ⷣтї1ⷣце2ꙋ1брꙋ1выꙋ1г2ꙋ1даꙋ1деꙋ1доꙋ1дыꙋ1діꙋ1дѣꙋ1ж2ꙋ1зиꙋ1к2ꙋ1леꙋ1п2ꙋ1с2ꙋ1тиꙋ1хоꙋ1щ2ꙋ2й1ꙋ́1цꙋ́ф2ꙋ́ї1ꙋ̑1бꙋ̑1кꙋа́1ꙋб1нꙋе́1ꙋи2мꙋи́2ꙋй1ꙋка2ꙋкꙋ2ꙋл1вꙋна2ꙋно2ꙋпа2ꙋпо1ꙋр1вꙋр1гꙋр1тꙋсї1ꙋх1нꙋчꙋ2ꙋша2ꙋшꙋ2ꙋщє1ꙋщї1ꙋщѧ1ꙋщꙋ1ꙋі́2ꙗ҆1пꙗ҆1рꙗ҆̀1",
		5 : "1а1ні1а́мь1а́ню1а̑нѧ1алле1ам1в1амер1анні1анꙋа1арѡ̑1б2дѣ1б2з21б2лѝ1б2ре1б2ри1б2ро1б2ры1б2рѧ1бли́1ближ1блим1блис1блю́1блѧ_1блѧ̀1блѧ̑1блѧг1бра_1бра̀1бра̑1браг1браж1браз1бран1браѧ1брє11брї11брѣ_1брѣй1брѣс1брѣт1брꙋ̀1брꙋю1бщї21в2до1в2ды1в2ді1в2дѣ1в2дꙋ1в2з21в2ла1в2лі1в2лѣ1в2р21в2ча1в2ѷ1ва1т1ва́е1ва́й1ва́м1ва́ю1ва́ѧ1ва̑р1ва̑ю1вагѡ1вай1вак21валъ1вани1ванн1ванї1варс1варъ1вары1варѝ1варѡ1варѧ1вахо1вахꙋ1вда_1ве1л1ве1т1ве1ч1ве́а1ве́д1ве́и1ве́к1ве́м1ве́с1ве́т1ве́ц1ведд1веди1ведо1ведꙋ1вена1вене1вени1венц1вера1верз1вери1верш1веръ1верꙋ1вецъ1ви1н1ви́д1ви́м1ви́н1ви́р1ви́ц1ви́ш1вирї1вича1вичю1вичѣ1вичꙋ1влек1влеч1влещ1вна̀1внег1внѡ́1внѣ̀1внꙋ̀1во́л1во́н1во́т1во́ю1вовѣ1вода1води1воды1водѝ1водѣ1вое_1вожꙋ1возб1возв1возг1возм1возн1возс1возш1вомꙋ1воп21воро1вот21вца́1вче́1вый1выма1вє́с1вї1м1вїй1вѡ́л1вѡ́р1вѡ́т1вѣ́д1вѣ́е1вѣ́ж1вѣ́й1вѣ́м1вѣ́н1вѣ́ц1вѣ̑д1вѣ̑к1вѣ̑с1вѣ̑т1вѣд21вѣй1вѣмъ1вѣрѧ1вѣщє1вѧ1х1вѧ́ш1вѧ́щ1вѧзе1вѧтс1вѧтъ1вѧть1вѧщи1вѧщы1вѧщї1вѵ́п1вꙋ1д1вꙋ1х1вꙋ́_1вꙋ́л1вꙋ́т1вꙋю_1г2гі1г2ли1г2лі1г2лѡ1г2лѣ1г2лѧ1г2но1г2ні1г2нѝ1г2нѣ1г2нѧ1г2р21г2ца1г2ї1га1с1га1т1га́в1га́е1га́й1га́л1га́м1га́н1га́п1га́т1га́ю1га́ѳ1га̑т1гай1гдо21ги1с1ги́б1ги́з1ги̑21глот1гне́1гнед1гнез1гнен1гнеп1гнер1гнец1гниц1гнꙋш1го́_1го́д1го́р1го́х1го́ш1го́ю1гоб21гова1гови1говм1гогл1гогр1годи1годо1годꙋ1гож21гопи1гопл1гопѣ1гори1горо1горч1горї1госв1госѧ1гох21гоча1гоѡч1гоᲂу1гоꙋв1гі́а1гі́е1гі́и1гі́ю1гі̑11д2ви1д2ри1д2ро1д2ры1д2рі1д2рѡ1д2рꙋ1да1д1да1р1да1т1да́й1да́к1да́м1да́р1да̑р1да̑т1дайт1дала1дале1далъ1далї1дама1данъ1данї1дахꙋ1два̀1двор1де1в1де2х1де́а1де́б1де́ж1де́и1де́р1де́с1де́т1де́ц1де́ю1де́є1де́ѡ1дей1дер11деса1десе1десн1десы1десѐ1десѝ1десѣ1десѧ1дета1дете1деѡ́1дме11дмо21дне́1днеа1днеє1днол1днос1дны_1днꙋе1днꙋи1до1н1дове1дово1довы1дож21дос21дот21доꙋм1дра_1дра̀1драг1драж1драѧ1дре_1ды2р1дый1дє́ж1дє́и1дє́й1ді́д1ді́и1ді́м1ді́с1ді́ѳ1дїа1дїи1дїй1дїф1дїц1дїю1дїѐ1дїѝ1дїѡ1дї1г1дїѐ1дїе́1дїѧ̀1дїѧ́1дѣ1с1дѣ1т1дꙋ́е1дꙋ́х1дꙋ́ш1дꙋи21дꙋш21е1рѡ1е́мы1е́мь1е́ѵк1евск1един1езек1ейж1емаѧ1еми_1емою1емїи1ерꙋс1ессе1етас1етес1еꙋго1ж2жи1ж2ї1ждо11же1л1же2м1же́й1же́с1жей1жє́м1жꙋ́с1жꙋт11з2рю1з2рѝ1з2ї11зва̀1зва́1зван1зда̑1здѣ_1зе1с1зе́й1зе́н1зе́ю1зи1т1злат1злащ1зна̀1зна́1знав1знет1знех1знод1знꙋ́1зри_1зрим1зрит1зриш1зрѣ̀1зрѧ̀1зрѧт1зы1к1зы́й1зы́к1зы́ц1зы́ч1зыди1зѧ́б1зѧ́м1зѧ́щ1зꙋ́е1зꙋ́ѧ1зꙋме1зꙋми1зꙋмл1зꙋмѝ1зꙋю21и1лю1и1мѝ1и́мш1и̑мш1идꙋ21илев1илем1иль_1ильт1илѧ_1имен1имѝ1имод1имꙋ̀1имꙋ́1ине_1ини_1инст1инѡв1испѡ1иха_1ичнѡ1ка1в1ка1д1ка1т1ка́в1ка́е1ка́з1ка́й1ка́п1ка́р1ка́ѳ1ка̑в1каго1каѧ́1квї21ке́и1ке́к1ке́с1ки́т1ки́ф1кли́1клис1клиц1клю11клїй1клѧ21ко1л1ко́з1ко́и1ко́л1ко́н1ко́с1ко́х1ко́ш1ко́ѧ1коег1коей1коем1кож21кои11комч1кона1коне1коно1конъ1коны1конє1коні1конꙋ1копѣ1кори1корм1косн1косы1косѣ1коть1коꙋ11крыв1ктє11ктї11кхе21кі́а1кі́и1кі́м1кі́н1кїа1кїе1кі̑й1кѡ́н1кѡ́т1кѡ̑11кѡва1кѡве1кѡвл1кѡво1кѡвꙋ1кꙋ1т1кꙋ́е1кꙋ́и1кꙋ́й1кꙋ́л1кꙋ́м1кꙋ́н1кꙋ́т1кꙋст1кꙋша1ла́_1ла́а1ла́е1ла́й1ла́р1ла́ю1ла́ѣ1ла́ѧ1лавш1лавъ1лай1лакт1лама1лами1ламъ1ланн1ланї1ласѧ1лате1лаю11лаѧй1ле́а1ле́е1ле́и1ле́с1ле́х1леа11легл1лежи1лежѐ1лезв1лемѡ1леса1лесн1лесы1лесѐ1лесє1лесѝ1лесѣ1лете1летс1летѣ1летѧ1леце1лецъ1леѡ21ли2х1ли́в1ли́л1ли́н1ли́с1ли́х1ли́ц1ли́ч1ли́ш1ли̑т1ли̑ч1ли̑щ1лико1лимс1лимт1линг1лини1лины1линѡ1лице1лиши1ло1л1ло́_1ло́г1ло́ж1ло́м1лобы1лова1ловс1ловъ1ловы1лові1ловѣ1ловꙋ1лодъ1ложа1ложи1ложꙋ1ломе1ломѡ1лоро1лорꙋ1лос21лы̑_1лю́_1лю́б1лю́с1лютс1люща1лющи1лющы1лющї1лющꙋ1лє́з1лєны1лі́м1лі́н1лі́п1лїн1лїо1лїс1лїт1лїч1лїѐ1лїѝ1лїѡ1лї1к1лї1л1лї1м1лїа̀1лїан1лїѐ1лїев1лїѝ1лїи́1лїим1лїин1лїпп1лїю̀1лїѧ_1лїѧ̑1лѡ́в1лѡ́г1лѡ́с1лѡть1лѡтї1лѣ1в1лѣ́з1лѣ́л1лѣ́т1лѣ́х1лѣ̑_1лѣ̑з1лѣжа1лѣже1лѣй1лѣпи1лѧ1н1лѧ1ц1лѧ́щ1лѧй1лѧтс1лѷка1лꙋ́е1лꙋ́й1лꙋ́ф1лꙋ́ю1лꙋ́ї1лꙋ̑_1лꙋ̑ч1лꙋй1м2лє1м2лѝ1м2пе1м2р21ма1л1ма1с1ма́_1ма́й1ма́н1ма́р1ма́с1ма́х1ма́ю1ма́ѧ1ма̑11маг21мамъ1мамы1марі1мат21ме1в1ме2м1ме́а1ме́в1ме́е1ме́й1ме́н1ме́т1мерш1мерщ1меръ1меѡ21ми1л1ми́_1ми́в1ми́л1ми́н1ми́х1ми́ш1мира1мирѝ1млѐ1млю̀1млѧ̀1множ1мо́г1мо́ж1мо́л1мо́м1мо́с1мо́щ1мов21мога1моге1мого1могꙋ1мола1моли1молч1молю1молѝ1мос21моты1мотꙋ1мый1мыш11мі́а1мі́и1мі́р1мі́ю1мїа1мїе1мїй1мїр1мїѝ1мїѧ1мї1л1мї1н1мї1с1мїи_1мїѝ1мїй1мїѡ11мѣ1в1мѣне1мѣнѝ1мѧ1н1мѧти1мѧтн1мѧтс1мѧть1мѧтї1мѵ́л1на1н1на1т1на1ѯ1на́д1на́и1на́к1на́р1на́ѳ1на̑11нави1насс1наст1насѧ1не1ѵ1не́_1не́а1не́и1не́н1не́ц1нева1невѣ1него1негъ1неди1неді1недѣ1немо1немп1немс1немꙋ1нени1нено1ненꙋ1непо1неѡ́1неѡп1ни1р1ни́_1ни́м1ни́н1ни́р1ни́х1ни́ч1ни́ш1нико1никѣ1нисі1нисѧ1нитс1нитъ1ниха1нихо1нихс1нихꙋ1ницꙋ1но1н1но1р1но́в1но́с1но́щ1но́ї1нови1новл1новъ1новы1нові1новѝ1новѡ1новѧ1новꙋ1ногд1ногр1ноде1нодꙋ1ное21ножд1ной1нолѣ1нома1номе1номо1номъ1номы1номꙋ1нопи1нопл1нопр1носи1носѧ1нота1нотв1ноєѵ1ны̑_1ны̑м1ный1ныма1ні́г1ні́и1ні́к1ні́л1ні́н1ні́с1ні́ч1нѣ́_1нѣ́м1нѣ́х1нѣми1нѧ1н1нѧ2х1нѧ́е1нѧ́й1нѧ́ю1нѧ́ѧ1нѧго1нѧгѡ1нꙋ1р1нꙋ2л1нꙋ2х1нꙋ́_1нꙋ́е1нꙋ́и1нꙋ́х1нꙋич1нꙋти1нꙋтъ1нꙋю_1о́пѣ1овою1огно1огні1опе́1п2ла1п2ли1п2ло1п2лы1п2лі1п2лѣ1п2р21п2ї1па1в1па1л1па́е1па́л1па́м1па́р1па́т1па́ѵ1па̑11пада1падн1падъ1падѐ1падѝ1падѣ1падꙋ1пе1в1пе1ч1пе́в1пе́л1пе́м1пе́р1пе́щ1перв1пере1перн1перѧ1пи1р1пи1с1пи̑11пино1пины1пинѣ1пинꙋ1питъ1пле_1плет1плещ1плю_1плют1плѧ_1плѧм1пны́1по́й1по́л1по́м1по́н1по́с1побѣ1поді1подѡ1пое21пожр1поч21пто21пі́и1пі́с1пѡ1в1пѡ́в1пѡ́н1пѡ̑21пѣ1л1пѧ́ш1ра́р1ра́ѯ1раві1раек1разл1разр1разс1рала1рапо1рапї1раск1расл1ратр1ре́к1ре́ѳ1рева1ревн1рей_1реко1рекі1рекꙋ1ремї1ренъ1рень1ресь1реті1ретї1рехъ1рецъ1речѐ1речє1рещи1ри́н1ри́х1ри̑_1ри̑г1ри̑м1рина1ро́д1ро́е1ро́ж1роде1роди1родн1родѝ1родѧ1рожд1роно1ронѡ1ропѣ1ропꙋ1ротв1ротѣ1ротꙋ1рохи1ры́г1ры́ѧ1рю́11рє́м1рє́н1рєѝ1рі́а1рі́и1рі́м1рі́ю1рі́ѧ1рїд1рїн1рїц1рї1л1рїин1рїкъ1рїсе1рїсє1рїтѡ1рѡ2с1рѡ́к1рѡ̑11рѡма1рѣ2ч1рѣ́_1рѣ́е1рѣ́й1рѣ̑й1рѧ́д1рѷн1рѷѱ1рѷ1м1рѷ2к1рꙋ1в1рꙋ́л1рꙋ́х1рꙋ́ш1рꙋ́ю1рꙋ́ѳ1рꙋ̑с1рꙋем1рꙋет1рꙋеш1рꙋй1рꙋмы1рꙋче1рꙋющ1рꙋѧ_1рꙋѧй1с2в21с2ка1с2ке1с2ки1с2ко1с2кр1с2кі1с2кѣ1с2нѝ1с2пѝ1с2пѡ1с2р21с2та1с2ти1с2ты1с2тѐ1с2ті1с2тѡ1с2тѣ1с2тѧ1с2тꙋ1с2ха1с2хꙋ1са́_1са́в1са́н1са́ф1са́х1са́ю1са́є1са́ѵ1се́а1се́е1се́и1се́о1се́р1се́є1сей1селѡ1сенъ1серъ1сехъ1сецъ1сеѡ́1си1к1си1х1си2л1си́в1си́л1си́м1си́ш1скꙋ_1скꙋд1скꙋю1смѝ1смꙋ11сна̀1сна́1сней1снех1снец1сниц1сно́1сноб1снож1сноп1снос1снот1снїю1со1н1соб21сове1совѡ1сомꙋ1соп21сот21соч21спа́1спе_1спи́1спод1спож1спѣ̀1спѣш1ства1стве1стви1ствы1ствє1ствї1ствѣ1сте_1стей1стен1стес1стех1стла1сто_1стоб1стов1стод1стое1стож1стои1сток1стол1стом1стон1стот1стоф1стох1стош1стою1стоѡ1стоѧ1стоѱ1стра1стри1стро1стры1стрѐ1стрі1стрѝ1стрѣ1стрѵ1схи_1сцы̀1сы1р1сы́_1сы́п1сє́й1сѡ1т1сѣ1д1сѣ1т1сѣ1ч1сѣ́д1сѣ́к1т2кн1т2лѝ1т2цє1т2цꙋ1т2чѐ1т2чꙋ1т2щ21та1л1та1т1та2х1та́п1та̑ѧ1тава1тавш1тавъ1таго1тана1танн1танꙋ1таре1тарю1тарѝ1тарѧ1таю_1тают1тваг1твар1твер1тви_1твѝ1твор1твос1твый1твым1твых1твыѧ1те́ж1те́п1текꙋ1тера1терб1терг1тере1терз1тери1терн1терс1теры1терь1тері1терї1теск1тецъ1течѐ1ти́р1ти̑_1ти̑л1тила1тлѣ̑1то́п1то́х1то́ш1то́ю1това1тово1товъ1товы1товѣ1тода1тодн1тодї1толѝ1толѧ1толꙋ1тоні1топе1топи1топѝ1топѧ1торж1торн1торѣ1тост1тотв1точа1точи1точє1точѝ1тоща1тощѝ1тоꙋ21тре_1треб1трен1треп1трил1тро_1трок1троп1трос1троф1троц1троч1тры_1трї1трꙋб1трꙋж1тца_1тцы_1тцы̀1тцѣ̀1тча_1тчах1тчее1тчей1тчею1ты́м1ты́х1ты́ѧ1ты̑_1ты̑ѧ1тыма1тє́й1тє́ц1тєск1ті́а1ті́ч1ті́ю1ті́ѡ1тїй1тїк1тїо1тїф1тїѐ1тїѝ1ті̑11тї1п1тїа_1тїѐ1тїе́1тїею1тїѝ1тїй1тїих1тїю̀1тїѧ̀1тїѧг1тїѧм1тїѧх1тѡ́н1тѡлі1тѣ1с1тѣ2р1тѣ́в1тѣ́л1тѣ́м1тѧ1з1тѧ́й1тѧ́ш1тѧже1ф2р21фі́в1фі́и1фі́л1фі́м1фі́н1х2ма1х2р21х2ті1хи2м1хо1в1хо1л1хо1с1хо2р1хо́м1хода1ходв1хот21ца1р1ца2х1ца́_1ца́е1ца́р1ца́х1ца́ѧ1це1в1це1н1це1с1це́в1цемѣ1цє́м1цєва1цї11цѣ2м1цѣ2х1цѣй1ч2ти1ч2ю11что̀1чⷭ҇т1чꙋ1д1ш2ѧ11щ2ї1ща1в1ща1д1ща1м1ща1н1ща2х1ща́в1ща́е1ща́ю1щаѧ11ю1ж21ю́тс1ю́ща1ю́ще1ю́щи1ю́щѧ1ющас1ющаѧ1ющис1ющих1ющыѧ1ющїи1ющїѧ1ющꙋс1ющꙋю1є́нѣ1єма_1і́мв1і́нт1їнъ1їтѝ1їѳа1ї1лѧ1ї1ны1їина1їно_1їтѝ1ѡ1б21ѡ1де1ѡ́дь1ѡа1с1ѡа́д1ѡа́н1ѡа́с1ѡи́л1ѡнаѳ1ѡпи21ѡра́1ѡрꙋ́1ѡрꙋж1ѡстр1ѡсѧ́1ѡсꙋ11ѧ1на1ѧ́2р1ѧ́ла1ѧ́ли1ѧ́са1ѧ́тѣ1ѧ́хо1ѧ́ши1ѧдѐ1ѧнї11ѧса_1ѧша11ѳе1м1ѳе́ю1ѳі́а1ѳі́м1ѳі̑11ѵ2е21ѵ2ї11ѷ1сє1ѷпо11ѻ1г21ѻ1т21ᲂу1х1ꙋ1ве1ꙋ1вѣ1ꙋ1вѧ1ꙋ1дє1ꙋ1ха1ꙋ́зъ1ꙋ́лї1ꙋ́лꙋ1ꙋ́мн1ꙋ́нї1ꙋ́чи1ꙋ̑ди1ꙋ̑мн1ꙋгас1ꙋгот1ꙋдоб1ꙋказ1ꙋкло1ꙋклѡ1ꙋмев1ꙋмо21ꙋмы_1ꙋмѣ_1ꙋмѣв1ꙋсо́1ꙋстї2а1де2а1дѣ2а1ж22а1на2а1ни2а1п22а1ре2а1ри2а1рѝ2а1рѧ2а1ф22а2й12а́1п2а́2ѯ2а́ї2а̑х12адѝ2аз1л2анї12асѧ12б1ви2б1вѝ2б1де2б1лє2б1с22бвѐ2в1ли2в1ны2в1цє2в1ш22внї2воѐ2вчї12вѣ1л2г1к22г1с22г1цѣ2г1ш22г2лы2г2лꙋ2г2ъ12га1р2гн1ц2гн1ч2д1г22д1з22д1нѝ2д1п22д1ц22д1ш22д2̾12д2ь12де1л2днї2др1с2е1ве2е1ді2е1ли2е1лѡ2е1лѧ2е1ме2е1мѝ2е1мѣ2е1се2е1ск2е1тв2е1ти2е1тр2е1тѐ2е1тє2е1ті2е1тѝ2е1тѧ2е1хо2е́1ѳ2е́2ц2е́є22екї12ем1н2емѝ2етѐ2еше22ж1н22ж1с22жд1н2жд1с2з1б22з1ве2з1ви2з1вл2з1во2з1вы2з1вѝ2з1вꙋ2з1г22з1де2з1ж22з1з22з1ле2з1ло2з1лю2з1лѡ2з1м22з1ны2з1п22з1с22з1ш22з2̾12зд2р2здꙋ22зи1м2зы1с2и1ва2и1г22и̑1г2ища22к1к22к1с22к1ш22кен12кно12кꙋ1д2л1л22л1с22л2з12л2ь12лее22лѣ1д2лѣ1н2лѧ1м2лѧ1ч2м1ж22м1на2м1ны2м1ні2м1нꙋ2м1с22м1ф22м1ш22м1ѱ22м2ь12ма2х2мнї12мпї2мчї2мїю2мѣ1с2н1г22н1н22н1с22н1ш22н2ь12неа12нѣ1д2нѧ1з2о1ве2о1вѝ2о1вꙋ2о1ма2о1мо2о1си2о́1ш2овѝ2опї12ос2т2п1лє2п1ни2п1нѣ2пнї12пѣш22р1ца2р1цє2р1цѣ2р1цꙋ2р1ш22р2ь12ри1л2рим22риш22рѡ1т2рѧ1ц2рѧ2т2рѷп2рѷ1с2рꙋ2т2с1пн2с1ца2с1цѣ2с2ь12спы12спї12спѧ22спꙋ12ст1н2сть12сѡ1в2т1кї2т1ло2т1лы2т1лѡ2т1с22т1ш22ти1р2тка22тѡ1д2тѡ2р2тѣ1н2ф1с22х1мѝ2х1с22ч1та2ч1ш22ча2х2чей2ш1ли2ш1н22щ1в22щ1с22щ1ш22щ2ь12ще1в2є1ѝ2єм1н2ї1ю2ї1є2ї1ѝ2ї1ѧ2їа́2їѝ2їим2їих2ї1ка2ї1ки2ї1ла2ї1лї2їлї2їн1б2ѡ1ма2ѧ1зе2ѧ1зѧ2ѧ́2б2ѧ̑с22ѧза22ѧсе22ѧсо12ѷ1ѱ2ѷпр2ѷпі2ѷс1с2ꙋ1ви2ꙋ1те2ꙋ1ті2ꙋ1тѝ2ꙋм2н2ꙋмѧ22ꙋса12ꙋтѝ8а̀8_8а́8_8а̑8_8аⷠ҇_8аⷡ҇_8аⷢ҇_8аⷣ҇_8аⷤ҇_8аⷥ҇_8аⷦ҇_8аⷧ҇_8аⷨ҇_8аⷩ҇_8аⷪ҇_8аⷫ҇_8аⷬ҇_8аⷭ҇_8аⷮ҇_8аⷯ҇_8аⷰ҇_8аⷱ҇_8аⷲ҇_8аⷳ҇_8аⷴ҇_8аⷵ҇_8аⷶ҇_8аⷷ҇_8аⷸ҇_8аⷹ҇_8аⷺ҇_8аⷻ҇_8аⷼ҇_8аⷽ҇_8аⷾ҇_8аⷿ҇_8аꙴ҇_8аꙵ҇_8аꙶ҇_8аꙷ҇_8аꙸ҇_8аꙹ҇_8аꙺ҇_8аꙻ҇_8а꙼҇_8а꙽҇_8ѐ8_8е́8_8ё8_8е̑8_8еⷠ҇_8еⷡ҇_8еⷢ҇_8еⷣ҇_8еⷤ҇_8еⷥ҇_8еⷦ҇_8еⷧ҇_8еⷨ҇_8еⷩ҇_8еⷪ҇_8еⷫ҇_8еⷬ҇_8еⷭ҇_8еⷮ҇_8еⷯ҇_8еⷰ҇_8еⷱ҇_8еⷲ҇_8еⷳ҇_8еⷴ҇_8еⷵ҇_8еⷶ҇_8еⷷ҇_8еⷸ҇_8еⷹ҇_8еⷺ҇_8еⷻ҇_8еⷼ҇_8еⷽ҇_8еⷾ҇_8еⷿ҇_8еꙴ҇_8еꙵ҇_8еꙶ҇_8еꙷ҇_8еꙸ҇_8еꙹ҇_8еꙺ҇_8еꙻ҇_8е꙼҇_8е꙽҇_8ѝ8_8и́8_8йⷠ_8йⷡ_8йⷢ_8йⷣ_8йⷤ_8йⷥ_8йⷦ_8йⷧ_8йⷨ_8йⷩ_8йⷪ_8йⷫ_8йⷬ_8йⷭ_8йⷮ_8йⷯ_8йⷰ_8йⷱ_8йⷲ_8йⷳ_8йⷴ_8йⷵ_8йⷶ_8йⷷ_8йⷸ_8йⷹ_8йⷺ_8йⷻ_8йⷼ_8йⷽ_8йⷾ_8йⷿ_8йꙴ_8йꙵ_8йꙶ_8йꙷ_8йꙸ_8йꙹ_8йꙺ_8йꙻ_8й꙼_8й꙽_8и̑8_8иⷠ҇_8иⷡ҇_8иⷢ҇_8иⷣ҇_8иⷤ҇_8иⷥ҇_8иⷦ҇_8иⷧ҇_8иⷨ҇_8иⷩ҇_8иⷪ҇_8иⷫ҇_8иⷬ҇_8иⷭ҇_8иⷮ҇_8иⷯ҇_8иⷰ҇_8иⷱ҇_8иⷲ҇_8иⷳ҇_8иⷴ҇_8иⷵ҇_8иⷶ҇_8иⷷ҇_8иⷸ҇_8иⷹ҇_8иⷺ҇_8иⷻ҇_8иⷼ҇_8иⷽ҇_8иⷾ҇_8иⷿ҇_8иꙴ҇_8иꙵ҇_8иꙶ҇_8иꙷ҇_8иꙸ҇_8иꙹ҇_8иꙺ҇_8иꙻ҇_8и꙼҇_8и꙽҇_8й̀8_8й́8_8й̈8_8й̑8_8йⷠ҇_8йⷡ҇_8йⷢ҇_8йⷣ҇_8йⷤ҇_8йⷥ҇_8йⷦ҇_8йⷧ҇_8йⷨ҇_8йⷩ҇_8йⷪ҇_8йⷫ҇_8йⷬ҇_8йⷭ҇_8йⷮ҇_8йⷯ҇_8йⷰ҇_8йⷱ҇_8йⷲ҇_8йⷳ҇_8йⷴ҇_8йⷵ҇_8йⷶ҇_8йⷷ҇_8йⷸ҇_8йⷹ҇_8йⷺ҇_8йⷻ҇_8йⷼ҇_8йⷽ҇_8йⷾ҇_8йⷿ҇_8йꙴ҇_8йꙵ҇_8йꙶ҇_8йꙷ҇_8йꙸ҇_8йꙹ҇_8йꙺ҇_8йꙻ҇_8й꙼҇_8й꙽҇_8о̀8_8о́8_8о̑8_8оⷠ҇_8оⷡ҇_8оⷢ҇_8оⷣ҇_8оⷤ҇_8оⷥ҇_8оⷦ҇_8оⷧ҇_8оⷨ҇_8оⷩ҇_8оⷪ҇_8оⷫ҇_8оⷬ҇_8оⷭ҇_8оⷮ҇_8оⷯ҇_8оⷰ҇_8оⷱ҇_8оⷲ҇_8оⷳ҇_8оⷴ҇_8оⷵ҇_8оⷶ҇_8оⷷ҇_8оⷸ҇_8оⷹ҇_8оⷺ҇_8оⷻ҇_8оⷼ҇_8оⷽ҇_8оⷾ҇_8оⷿ҇_8оꙴ҇_8оꙵ҇_8оꙶ҇_8оꙷ҇_8оꙸ҇_8оꙹ҇_8оꙺ҇_8оꙻ҇_8о꙼҇_8о꙽҇_8у̀8_8у́8_8у̑8_8уⷠ҇_8уⷡ҇_8уⷢ҇_8уⷣ҇_8уⷤ҇_8уⷥ҇_8уⷦ҇_8уⷧ҇_8уⷨ҇_8уⷩ҇_8уⷪ҇_8уⷫ҇_8уⷬ҇_8уⷭ҇_8уⷮ҇_8уⷯ҇_8уⷰ҇_8уⷱ҇_8уⷲ҇_8уⷳ҇_8уⷴ҇_8уⷵ҇_8уⷶ҇_8уⷷ҇_8уⷸ҇_8уⷹ҇_8уⷺ҇_8уⷻ҇_8уⷼ҇_8уⷽ҇_8уⷾ҇_8уⷿ҇_8уꙴ҇_8уꙵ҇_8уꙶ҇_8уꙷ҇_8уꙸ҇_8уꙹ҇_8уꙺ҇_8уꙻ҇_8у꙼҇_8у꙽҇_8ы̀8_8ы́8_8ы̑8_8ыⷠ҇_8ыⷡ҇_8ыⷢ҇_8ыⷣ҇_8ыⷤ҇_8ыⷥ҇_8ыⷦ҇_8ыⷧ҇_8ыⷨ҇_8ыⷩ҇_8ыⷪ҇_8ыⷫ҇_8ыⷬ҇_8ыⷭ҇_8ыⷮ҇_8ыⷯ҇_8ыⷰ҇_8ыⷱ҇_8ыⷲ҇_8ыⷳ҇_8ыⷴ҇_8ыⷵ҇_8ыⷶ҇_8ыⷷ҇_8ыⷸ҇_8ыⷹ҇_8ыⷺ҇_8ыⷻ҇_8ыⷼ҇_8ыⷽ҇_8ыⷾ҇_8ыⷿ҇_8ыꙴ҇_8ыꙵ҇_8ыꙶ҇_8ыꙷ҇_8ыꙸ҇_8ыꙹ҇_8ыꙺ҇_8ыꙻ҇_8ы꙼҇_8ы꙽҇_8э̀8_8э́8_8э̑8_8эⷠ҇_8эⷡ҇_8эⷢ҇_8эⷣ҇_8эⷤ҇_8эⷥ҇_8эⷦ҇_8эⷧ҇_8эⷨ҇_8эⷩ҇_8эⷪ҇_8эⷫ҇_8эⷬ҇_8эⷭ҇_8эⷮ҇_8эⷯ҇_8эⷰ҇_8эⷱ҇_8эⷲ҇_8эⷳ҇_8эⷴ҇_8эⷵ҇_8эⷶ҇_8эⷷ҇_8эⷸ҇_8эⷹ҇_8эⷺ҇_8эⷻ҇_8эⷼ҇_8эⷽ҇_8эⷾ҇_8эⷿ҇_8эꙴ҇_8эꙵ҇_8эꙶ҇_8эꙷ҇_8эꙸ҇_8эꙹ҇_8эꙺ҇_8эꙻ҇_8э꙼҇_8э꙽҇_8ю̀8_8ю́8_8ю̈8_8ю̑8_8юⷠ҇_8юⷡ҇_8юⷢ҇_8юⷣ҇_8юⷤ҇_8юⷥ҇_8юⷦ҇_8юⷧ҇_8юⷨ҇_8юⷩ҇_8юⷪ҇_8юⷫ҇_8юⷬ҇_8юⷭ҇_8юⷮ҇_8юⷯ҇_8юⷰ҇_8юⷱ҇_8юⷲ҇_8юⷳ҇_8юⷴ҇_8юⷵ҇_8юⷶ҇_8юⷷ҇_8юⷸ҇_8юⷹ҇_8юⷺ҇_8юⷻ҇_8юⷼ҇_8юⷽ҇_8юⷾ҇_8юⷿ҇_8юꙴ҇_8юꙵ҇_8юꙶ҇_8юꙷ҇_8юꙸ҇_8юꙹ҇_8юꙺ҇_8юꙻ҇_8ю꙼҇_8ю꙽҇_8є̀8_8є́8_8є̈8_8є̑8_8єⷠ҇_8єⷡ҇_8єⷢ҇_8єⷣ҇_8єⷤ҇_8єⷥ҇_8єⷦ҇_8єⷧ҇_8єⷨ҇_8єⷩ҇_8єⷪ҇_8єⷫ҇_8єⷬ҇_8єⷭ҇_8єⷮ҇_8єⷯ҇_8єⷰ҇_8єⷱ҇_8єⷲ҇_8єⷳ҇_8єⷴ҇_8єⷵ҇_8єⷶ҇_8єⷷ҇_8єⷸ҇_8єⷹ҇_8єⷺ҇_8єⷻ҇_8єⷼ҇_8єⷽ҇_8єⷾ҇_8єⷿ҇_8єꙴ҇_8єꙵ҇_8єꙶ҇_8єꙷ҇_8єꙸ҇_8єꙹ҇_8єꙺ҇_8єꙻ҇_8є꙼҇_8є꙽҇_8і̀8_8і́8_8ї8_8і̑8_8іⷠ҇_8іⷡ҇_8іⷢ҇_8іⷣ҇_8іⷤ҇_8іⷥ҇_8іⷦ҇_8іⷧ҇_8іⷨ҇_8іⷩ҇_8іⷪ҇_8іⷫ҇_8іⷬ҇_8іⷭ҇_8іⷮ҇_8іⷯ҇_8іⷰ҇_8іⷱ҇_8іⷲ҇_8іⷳ҇_8іⷴ҇_8іⷵ҇_8іⷶ҇_8іⷷ҇_8іⷸ҇_8іⷹ҇_8іⷺ҇_8іⷻ҇_8іⷼ҇_8іⷽ҇_8іⷾ҇_8іⷿ҇_8іꙴ҇_8іꙵ҇_8іꙶ҇_8іꙷ҇_8іꙸ҇_8іꙹ҇_8іꙺ҇_8іꙻ҇_8і꙼҇_8і꙽҇_8ѡ̀8_8ѡ́8_8ѡ̈8_8ѡ̑8_8ѡⷠ҇_8ѡⷡ҇_8ѡⷢ҇_8ѡⷣ҇_8ѡⷤ҇_8ѡⷥ҇_8ѡⷦ҇_8ѡⷧ҇_8ѡⷨ҇_8ѡⷩ҇_8ѡⷪ҇_8ѡⷫ҇_8ѡⷬ҇_8ѡⷭ҇_8ѡⷮ҇_8ѡⷯ҇_8ѡⷰ҇_8ѡⷱ҇_8ѡⷲ҇_8ѡⷳ҇_8ѡⷴ҇_8ѡⷵ҇_8ѡⷶ҇_8ѡⷷ҇_8ѡⷸ҇_8ѡⷹ҇_8ѡⷺ҇_8ѡⷻ҇_8ѡⷼ҇_8ѡⷽ҇_8ѡⷾ҇_8ѡⷿ҇_8ѡꙴ҇_8ѡꙵ҇_8ѡꙶ҇_8ѡꙷ҇_8ѡꙸ҇_8ѡꙹ҇_8ѡꙺ҇_8ѡꙻ҇_8ѡ꙼҇_8ѡ꙽҇_8ѣ̀8_8ѣ́8_8ѣ̈8_8ѣ̑8_8ѣⷠ҇_8ѣⷡ҇_8ѣⷢ҇_8ѣⷣ҇_8ѣⷤ҇_8ѣⷥ҇_8ѣⷦ҇_8ѣⷧ҇_8ѣⷨ҇_8ѣⷩ҇_8ѣⷪ҇_8ѣⷫ҇_8ѣⷬ҇_8ѣⷭ҇_8ѣⷮ҇_8ѣⷯ҇_8ѣⷰ҇_8ѣⷱ҇_8ѣⷲ҇_8ѣⷳ҇_8ѣⷴ҇_8ѣⷵ҇_8ѣⷶ҇_8ѣⷷ҇_8ѣⷸ҇_8ѣⷹ҇_8ѣⷺ҇_8ѣⷻ҇_8ѣⷼ҇_8ѣⷽ҇_8ѣⷾ҇_8ѣⷿ҇_8ѣꙴ҇_8ѣꙵ҇_8ѣꙶ҇_8ѣꙷ҇_8ѣꙸ҇_8ѣꙹ҇_8ѣꙺ҇_8ѣꙻ҇_8ѣ꙼҇_8ѣ꙽҇_8ѧ̀8_8ѧ́8_8ѧ̈8_8ѧ̑8_8ѧⷠ҇_8ѧⷡ҇_8ѧⷢ҇_8ѧⷣ҇_8ѧⷤ҇_8ѧⷥ҇_8ѧⷦ҇_8ѧⷧ҇_8ѧⷨ҇_8ѧⷩ҇_8ѧⷪ҇_8ѧⷫ҇_8ѧⷬ҇_8ѧⷭ҇_8ѧⷮ҇_8ѧⷯ҇_8ѧⷰ҇_8ѧⷱ҇_8ѧⷲ҇_8ѧⷳ҇_8ѧⷴ҇_8ѧⷵ҇_8ѧⷶ҇_8ѧⷷ҇_8ѧⷸ҇_8ѧⷹ҇_8ѧⷺ҇_8ѧⷻ҇_8ѧⷼ҇_8ѧⷽ҇_8ѧⷾ҇_8ѧⷿ҇_8ѧꙴ҇_8ѧꙵ҇_8ѧꙶ҇_8ѧꙷ҇_8ѧꙸ҇_8ѧꙹ҇_8ѧꙺ҇_8ѧꙻ҇_8ѧ꙼҇_8ѧ꙽҇_8ѵ̀8_8ѵ́8_8ѵ̈8_8ѵ̑8_8ѵⷠ҇_8ѵⷡ҇_8ѵⷢ҇_8ѵⷣ҇_8ѵⷤ҇_8ѵⷥ҇_8ѵⷦ҇_8ѵⷧ҇_8ѵⷨ҇_8ѵⷩ҇_8ѵⷪ҇_8ѵⷫ҇_8ѵⷬ҇_8ѵⷭ҇_8ѵⷮ҇_8ѵⷯ҇_8ѵⷰ҇_8ѵⷱ҇_8ѵⷲ҇_8ѵⷳ҇_8ѵⷴ҇_8ѵⷵ҇_8ѵⷶ҇_8ѵⷷ҇_8ѵⷸ҇_8ѵⷹ҇_8ѵⷺ҇_8ѵⷻ҇_8ѵⷼ҇_8ѵⷽ҇_8ѵⷾ҇_8ѵⷿ҇_8ѵꙴ҇_8ѵꙵ҇_8ѵꙶ҇_8ѵꙷ҇_8ѵꙸ҇_8ѵꙹ҇_8ѵꙺ҇_8ѵꙻ҇_8ѵ꙼҇_8ѵ꙽҇_8ѹ̀8_8ѹ́8_8ѹ̈8_8ѹ̑8_8ѹⷠ҇_8ѹⷡ҇_8ѹⷢ҇_8ѹⷣ҇_8ѹⷤ҇_8ѹⷥ҇_8ѹⷦ҇_8ѹⷧ҇_8ѹⷨ҇_8ѹⷩ҇_8ѹⷪ҇_8ѹⷫ҇_8ѹⷬ҇_8ѹⷭ҇_8ѹⷮ҇_8ѹⷯ҇_8ѹⷰ҇_8ѹⷱ҇_8ѹⷲ҇_8ѹⷳ҇_8ѹⷴ҇_8ѹⷵ҇_8ѹⷶ҇_8ѹⷷ҇_8ѹⷸ҇_8ѹⷹ҇_8ѹⷺ҇_8ѹⷻ҇_8ѹⷼ҇_8ѹⷽ҇_8ѹⷾ҇_8ѹⷿ҇_8ѹꙴ҇_8ѹꙵ҇_8ѹꙶ҇_8ѹꙷ҇_8ѹꙸ҇_8ѹꙹ҇_8ѹꙺ҇_8ѹꙻ҇_8ѹ꙼҇_8ѹ꙽҇_8ѻ̀8_8ѻ́8_8ѻ̈8_8ѻ̑8_8ѻⷠ҇_8ѻⷡ҇_8ѻⷢ҇_8ѻⷣ҇_8ѻⷤ҇_8ѻⷥ҇_8ѻⷦ҇_8ѻⷧ҇_8ѻⷨ҇_8ѻⷩ҇_8ѻⷪ҇_8ѻⷫ҇_8ѻⷬ҇_8ѻⷭ҇_8ѻⷮ҇_8ѻⷯ҇_8ѻⷰ҇_8ѻⷱ҇_8ѻⷲ҇_8ѻⷳ҇_8ѻⷴ҇_8ѻⷵ҇_8ѻⷶ҇_8ѻⷷ҇_8ѻⷸ҇_8ѻⷹ҇_8ѻⷺ҇_8ѻⷻ҇_8ѻⷼ҇_8ѻⷽ҇_8ѻⷾ҇_8ѻⷿ҇_8ѻꙴ҇_8ѻꙵ҇_8ѻꙶ҇_8ѻꙷ҇_8ѻꙸ҇_8ѻꙹ҇_8ѻꙺ҇_8ѻꙻ҇_8ѻ꙼҇_8ѻ꙽҇_8ѽ̀8_8ѽ́8_8ѽ̈8_8ѽ̑8_8ѽⷠ҇_8ѽⷡ҇_8ѽⷢ҇_8ѽⷣ҇_8ѽⷤ҇_8ѽⷥ҇_8ѽⷦ҇_8ѽⷧ҇_8ѽⷨ҇_8ѽⷩ҇_8ѽⷪ҇_8ѽⷫ҇_8ѽⷬ҇_8ѽⷭ҇_8ѽⷮ҇_8ѽⷯ҇_8ѽⷰ҇_8ѽⷱ҇_8ѽⷲ҇_8ѽⷳ҇_8ѽⷴ҇_8ѽⷵ҇_8ѽⷶ҇_8ѽⷷ҇_8ѽⷸ҇_8ѽⷹ҇_8ѽⷺ҇_8ѽⷻ҇_8ѽⷼ҇_8ѽⷽ҇_8ѽⷾ҇_8ѽⷿ҇_8ѽꙴ҇_8ѽꙵ҇_8ѽꙶ҇_8ѽꙷ҇_8ѽꙸ҇_8ѽꙹ҇_8ѽꙺ҇_8ѽꙻ҇_8ѽ꙼҇_8ѽ꙽҇_8ѿ̀8_8ѿ́8_8ѿ̈8_8ѿ̑8_8ѿⷠ҇_8ѿⷡ҇_8ѿⷢ҇_8ѿⷣ҇_8ѿⷤ҇_8ѿⷥ҇_8ѿⷦ҇_8ѿⷧ҇_8ѿⷨ҇_8ѿⷩ҇_8ѿⷪ҇_8ѿⷫ҇_8ѿⷬ҇_8ѿⷭ҇_8ѿⷮ҇_8ѿⷯ҇_8ѿⷰ҇_8ѿⷱ҇_8ѿⷲ҇_8ѿⷳ҇_8ѿⷴ҇_8ѿⷵ҇_8ѿⷶ҇_8ѿⷷ҇_8ѿⷸ҇_8ѿⷹ҇_8ѿⷺ҇_8ѿⷻ҇_8ѿⷼ҇_8ѿⷽ҇_8ѿⷾ҇_8ѿⷿ҇_8ѿꙴ҇_8ѿꙵ҇_8ѿꙶ҇_8ѿꙷ҇_8ѿꙸ҇_8ѿꙹ҇_8ѿꙺ҇_8ѿꙻ҇_8ѿ꙼҇_8ѿ꙽҇_8ᲂ̀8_8ᲂ́8_8ᲂ̈8_8ᲂ̑8_8ᲂу̀_8ᲂу́_8ᲂу̑_8ᲂуⷠ_8ᲂуⷡ_8ᲂуⷢ_8ᲂуⷣ_8ᲂуⷤ_8ᲂуⷥ_8ᲂуⷦ_8ᲂуⷧ_8ᲂуⷨ_8ᲂуⷩ_8ᲂуⷪ_8ᲂуⷫ_8ᲂуⷬ_8ᲂуⷭ_8ᲂуⷮ_8ᲂуⷯ_8ᲂуⷰ_8ᲂуⷱ_8ᲂуⷲ_8ᲂуⷳ_8ᲂуⷴ_8ᲂуⷵ_8ᲂуⷶ_8ᲂуⷷ_8ᲂуⷸ_8ᲂуⷹ_8ᲂуⷺ_8ᲂуⷻ_8ᲂуⷼ_8ᲂуⷽ_8ᲂуⷾ_8ᲂуⷿ_8ᲂуꙴ_8ᲂуꙵ_8ᲂуꙶ_8ᲂуꙷ_8ᲂуꙸ_8ᲂуꙹ_8ᲂуꙺ_8ᲂуꙻ_8ᲂу꙼_8ᲂу꙽_8ᲂⷠ҇_8ᲂⷡ҇_8ᲂⷢ҇_8ᲂⷣ҇_8ᲂⷤ҇_8ᲂⷥ҇_8ᲂⷦ҇_8ᲂⷧ҇_8ᲂⷨ҇_8ᲂⷩ҇_8ᲂⷪ҇_8ᲂⷫ҇_8ᲂⷬ҇_8ᲂⷭ҇_8ᲂⷮ҇_8ᲂⷯ҇_8ᲂⷰ҇_8ᲂⷱ҇_8ᲂⷲ҇_8ᲂⷳ҇_8ᲂⷴ҇_8ᲂⷵ҇_8ᲂⷶ҇_8ᲂⷷ҇_8ᲂⷸ҇_8ᲂⷹ҇_8ᲂⷺ҇_8ᲂⷻ҇_8ᲂⷼ҇_8ᲂⷽ҇_8ᲂⷾ҇_8ᲂⷿ҇_8ᲂꙴ҇_8ᲂꙵ҇_8ᲂꙶ҇_8ᲂꙷ҇_8ᲂꙸ҇_8ᲂꙹ҇_8ᲂꙺ҇_8ᲂꙻ҇_8ᲂ꙼҇_8ᲂ꙽҇_8ꙋ̀8_8ꙋ́8_8ꙋ̈8_8ꙋ̑8_8ꙋⷠ҇_8ꙋⷡ҇_8ꙋⷢ҇_8ꙋⷣ҇_8ꙋⷤ҇_8ꙋⷥ҇_8ꙋⷦ҇_8ꙋⷧ҇_8ꙋⷨ҇_8ꙋⷩ҇_8ꙋⷪ҇_8ꙋⷫ҇_8ꙋⷬ҇_8ꙋⷭ҇_8ꙋⷮ҇_8ꙋⷯ҇_8ꙋⷰ҇_8ꙋⷱ҇_8ꙋⷲ҇_8ꙋⷳ҇_8ꙋⷴ҇_8ꙋⷵ҇_8ꙋⷶ҇_8ꙋⷷ҇_8ꙋⷸ҇_8ꙋⷹ҇_8ꙋⷺ҇_8ꙋⷻ҇_8ꙋⷼ҇_8ꙋⷽ҇_8ꙋⷾ҇_8ꙋⷿ҇_8ꙋꙴ҇_8ꙋꙵ҇_8ꙋꙶ҇_8ꙋꙷ҇_8ꙋꙸ҇_8ꙋꙹ҇_8ꙋꙺ҇_8ꙋꙻ҇_8ꙋ꙼҇_8ꙋ꙽҇_8ꙍ̀8_8ꙍ́8_8ꙍ̈8_8ꙍ̑8_8ꙍⷠ҇_8ꙍⷡ҇_8ꙍⷢ҇_8ꙍⷣ҇_8ꙍⷤ҇_8ꙍⷥ҇_8ꙍⷦ҇_8ꙍⷧ҇_8ꙍⷨ҇_8ꙍⷩ҇_8ꙍⷪ҇_8ꙍⷫ҇_8ꙍⷬ҇_8ꙍⷭ҇_8ꙍⷮ҇_8ꙍⷯ҇_8ꙍⷰ҇_8ꙍⷱ҇_8ꙍⷲ҇_8ꙍⷳ҇_8ꙍⷴ҇_8ꙍⷵ҇_8ꙍⷶ҇_8ꙍⷷ҇_8ꙍⷸ҇_8ꙍⷹ҇_8ꙍⷺ҇_8ꙍⷻ҇_8ꙍⷼ҇_8ꙍⷽ҇_8ꙍⷾ҇_8ꙍⷿ҇_8ꙍꙴ҇_8ꙍꙵ҇_8ꙍꙶ҇_8ꙍꙷ҇_8ꙍꙸ҇_8ꙍꙹ҇_8ꙍꙺ҇_8ꙍꙻ҇_8ꙍ꙼҇_8ꙍ꙽҇_8ꙗ̀8_8ꙗ́8_8ꙗ̈8_8ꙗ̑8_8ꙗⷠ҇_8ꙗⷡ҇_8ꙗⷢ҇_8ꙗⷣ҇_8ꙗⷤ҇_8ꙗⷥ҇_8ꙗⷦ҇_8ꙗⷧ҇_8ꙗⷨ҇_8ꙗⷩ҇_8ꙗⷪ҇_8ꙗⷫ҇_8ꙗⷬ҇_8ꙗⷭ҇_8ꙗⷮ҇_8ꙗⷯ҇_8ꙗⷰ҇_8ꙗⷱ҇_8ꙗⷲ҇_8ꙗⷳ҇_8ꙗⷴ҇_8ꙗⷵ҇_8ꙗⷶ҇_8ꙗⷷ҇_8ꙗⷸ҇_8ꙗⷹ҇_8ꙗⷺ҇_8ꙗⷻ҇_8ꙗⷼ҇_8ꙗⷽ҇_8ꙗⷾ҇_8ꙗⷿ҇_8ꙗꙴ҇_8ꙗꙵ҇_8ꙗꙶ҇_8ꙗꙷ҇_8ꙗꙸ҇_8ꙗꙹ҇_8ꙗꙺ҇_8ꙗꙻ҇_8ꙗ꙼҇_8ꙗ꙽҇__а҆̀8_а҆́8_а҆̈8_а҆̑8_аⷠ҇8_аⷡ҇8_аⷢ҇8_аⷣ҇8_аⷤ҇8_аⷥ҇8_аⷦ҇8_аⷧ҇8_аⷨ҇8_аⷩ҇8_аⷪ҇8_аⷫ҇8_аⷬ҇8_аⷭ҇8_аⷮ҇8_аⷯ҇8_аⷰ҇8_аⷱ҇8_аⷲ҇8_аⷳ҇8_аⷴ҇8_аⷵ҇8_аⷶ҇8_аⷷ҇8_аⷸ҇8_аⷹ҇8_аⷺ҇8_аⷻ҇8_аⷼ҇8_аⷽ҇8_аⷾ҇8_аⷿ҇8_аꙴ҇8_аꙵ҇8_аꙶ҇8_аꙷ҇8_аꙸ҇8_аꙹ҇8_аꙺ҇8_аꙻ҇8_а꙼҇8_а꙽҇8_ба́1_би́1_биш1_бле1_бро1_брѧ1_бѧ́1_ва1в_ва1л_ва1н_ва1х_ва̑1_вдо1_ве1д_ве1н_ви1т_ви́1_ви̑1_вис1_вле1_вое1_врї1_вче1_вє́1_вї1_вїа1_вѣ1р_вѣ1т_ге1л_глꙋ1_грѧ1_гї1_гꙋ1б_да1в_да1л_ди1м_ди1с_до1с_дол1_дох1_дро1_ды1х_дї1_дѡ1р_дѣ1в_дѣ1л_дꙋ1х_е҆̀8_е҆́8_е҆̈8_е҆̑8_еⷠ҇8_еⷡ҇8_еⷢ҇8_еⷣ҇8_еⷤ҇8_еⷥ҇8_еⷦ҇8_еⷧ҇8_еⷨ҇8_еⷩ҇8_еⷪ҇8_еⷫ҇8_еⷬ҇8_еⷭ҇8_еⷮ҇8_еⷯ҇8_еⷰ҇8_еⷱ҇8_еⷲ҇8_еⷳ҇8_еⷴ҇8_еⷵ҇8_еⷶ҇8_еⷷ҇8_еⷸ҇8_еⷹ҇8_еⷺ҇8_еⷻ҇8_еⷼ҇8_еⷽ҇8_еⷾ҇8_еⷿ҇8_еꙴ҇8_еꙵ҇8_еꙶ҇8_еꙷ҇8_еꙸ҇8_еꙹ҇8_еꙺ҇8_еꙻ҇8_е꙼҇8_е꙽҇8_же1н_же1с_жи1л_жи1т_жє1н_за1н_за1х_зер1_й̀8_й́8_й̈8_й̑8_й҆8_йⷠ8_йⷡ8_йⷢ8_йⷣ8_йⷤ8_йⷥ8_йⷦ8_йⷧ8_йⷨ8_йⷩ8_йⷪ8_йⷫ8_йⷬ8_йⷭ8_йⷮ8_йⷯ8_йⷰ8_йⷱ8_йⷲ8_йⷳ8_йⷴ8_йⷵ8_йⷶ8_йⷷ8_йⷸ8_йⷹ8_йⷺ8_йⷻ8_йⷼ8_йⷽ8_йⷾ8_йⷿ8_йꙴ8_йꙵ8_йꙶ8_йꙷ8_йꙸ8_йꙹ8_йꙺ8_йꙻ8_й꙼8_й꙽8_и҆̀8_и҆́8_и҆̈8_и҆̑8_иⷠ҇8_иⷡ҇8_иⷢ҇8_иⷣ҇8_иⷤ҇8_иⷥ҇8_иⷦ҇8_иⷧ҇8_иⷨ҇8_иⷩ҇8_иⷪ҇8_иⷫ҇8_иⷬ҇8_иⷭ҇8_иⷮ҇8_иⷯ҇8_иⷰ҇8_иⷱ҇8_иⷲ҇8_иⷳ҇8_иⷴ҇8_иⷵ҇8_иⷶ҇8_иⷷ҇8_иⷸ҇8_иⷹ҇8_иⷺ҇8_иⷻ҇8_иⷼ҇8_иⷽ҇8_иⷾ҇8_иⷿ҇8_иꙴ҇8_иꙵ҇8_иꙶ҇8_иꙷ҇8_иꙸ҇8_иꙹ҇8_иꙺ҇8_иꙻ҇8_и꙼҇8_и꙽҇8_й҆̀8_й҆́8_й҆̈8_й҆̑8_йⷠ҇8_йⷡ҇8_йⷢ҇8_йⷣ҇8_йⷤ҇8_йⷥ҇8_йⷦ҇8_йⷧ҇8_йⷨ҇8_йⷩ҇8_йⷪ҇8_йⷫ҇8_йⷬ҇8_йⷭ҇8_йⷮ҇8_йⷯ҇8_йⷰ҇8_йⷱ҇8_йⷲ҇8_йⷳ҇8_йⷴ҇8_йⷵ҇8_йⷶ҇8_йⷷ҇8_йⷸ҇8_йⷹ҇8_йⷺ҇8_йⷻ҇8_йⷼ҇8_йⷽ҇8_йⷾ҇8_йⷿ҇8_йꙴ҇8_йꙵ҇8_йꙶ҇8_йꙷ҇8_йꙸ҇8_йꙹ҇8_йꙺ҇8_йꙻ҇8_й꙼҇8_й꙽҇8_ка̑1_ко1в_ко1м_кое1_кѡн1_ла1в_ли̑1_лї1_лѷ1_ма1н_ма1т_мам1_ме1н_ме1т_мер1_мле1_мо1н_мо1с_мо1щ_мор1_мы̑1_мѧ1т_на1м_на1х_неѡ1_ни1в_ни1к_ны́1_ню́1_нї1_нѡ́1_нѣ1м_нѧ́1_о҆̀8_о҆́8_о҆̈8_о҆̑8_оⷠ҇8_оⷡ҇8_оⷢ҇8_оⷣ҇8_оⷤ҇8_оⷥ҇8_оⷦ҇8_оⷧ҇8_оⷨ҇8_оⷩ҇8_оⷪ҇8_оⷫ҇8_оⷬ҇8_оⷭ҇8_оⷮ҇8_оⷯ҇8_оⷰ҇8_оⷱ҇8_оⷲ҇8_оⷳ҇8_оⷴ҇8_оⷵ҇8_оⷶ҇8_оⷷ҇8_оⷸ҇8_оⷹ҇8_оⷺ҇8_оⷻ҇8_оⷼ҇8_оⷽ҇8_оⷾ҇8_оⷿ҇8_оꙴ҇8_оꙵ҇8_оꙶ҇8_оꙷ҇8_оꙸ҇8_оꙹ҇8_оꙺ҇8_оꙻ҇8_о꙼҇8_о꙽҇8_па1д_па1с_пе1л_пе1т_пе1ц_пер1_пи1т_пї1_пѣв1_ра1х_рас1_ро1в_роз1_рѡ1м_рѡс1_рѣ̑1_рꙋ̑1_сен1_слѧ1_сма1_смо1_спо1_сты1_стѡ1_сї1м_сѣ̑1_сѣн1_сѧ́1_та̑1_те1ц_ти1м_то1м_тор1_трї1_трѧ1_ты́1_тї1_тѵ́1_тѷ2_у҆̀8_у҆́8_у҆̈8_у҆̑8_уⷠ҇8_уⷡ҇8_уⷢ҇8_уⷣ҇8_уⷤ҇8_уⷥ҇8_уⷦ҇8_уⷧ҇8_уⷨ҇8_уⷩ҇8_уⷪ҇8_уⷫ҇8_уⷬ҇8_уⷭ҇8_уⷮ҇8_уⷯ҇8_уⷰ҇8_уⷱ҇8_уⷲ҇8_уⷳ҇8_уⷴ҇8_уⷵ҇8_уⷶ҇8_уⷷ҇8_уⷸ҇8_уⷹ҇8_уⷺ҇8_уⷻ҇8_уⷼ҇8_уⷽ҇8_уⷾ҇8_уⷿ҇8_уꙴ҇8_уꙵ҇8_уꙶ҇8_уꙷ҇8_уꙸ҇8_уꙹ҇8_уꙺ҇8_уꙻ҇8_у꙼҇8_у꙽҇8_фор1_фї1_фѡ́1_хал1_че1т_чє́1_шє́1_ы҆̀8_ы҆́8_ы҆̈8_ы҆̑8_ыⷠ҇8_ыⷡ҇8_ыⷢ҇8_ыⷣ҇8_ыⷤ҇8_ыⷥ҇8_ыⷦ҇8_ыⷧ҇8_ыⷨ҇8_ыⷩ҇8_ыⷪ҇8_ыⷫ҇8_ыⷬ҇8_ыⷭ҇8_ыⷮ҇8_ыⷯ҇8_ыⷰ҇8_ыⷱ҇8_ыⷲ҇8_ыⷳ҇8_ыⷴ҇8_ыⷵ҇8_ыⷶ҇8_ыⷷ҇8_ыⷸ҇8_ыⷹ҇8_ыⷺ҇8_ыⷻ҇8_ыⷼ҇8_ыⷽ҇8_ыⷾ҇8_ыⷿ҇8_ыꙴ҇8_ыꙵ҇8_ыꙶ҇8_ыꙷ҇8_ыꙸ҇8_ыꙹ҇8_ыꙺ҇8_ыꙻ҇8_ы꙼҇8_ы꙽҇8_э҆̀8_э҆́8_э҆̈8_э҆̑8_эⷠ҇8_эⷡ҇8_эⷢ҇8_эⷣ҇8_эⷤ҇8_эⷥ҇8_эⷦ҇8_эⷧ҇8_эⷨ҇8_эⷩ҇8_эⷪ҇8_эⷫ҇8_эⷬ҇8_эⷭ҇8_эⷮ҇8_эⷯ҇8_эⷰ҇8_эⷱ҇8_эⷲ҇8_эⷳ҇8_эⷴ҇8_эⷵ҇8_эⷶ҇8_эⷷ҇8_эⷸ҇8_эⷹ҇8_эⷺ҇8_эⷻ҇8_эⷼ҇8_эⷽ҇8_эⷾ҇8_эⷿ҇8_эꙴ҇8_эꙵ҇8_эꙶ҇8_эꙷ҇8_эꙸ҇8_эꙹ҇8_эꙺ҇8_эꙻ҇8_э꙼҇8_э꙽҇8_ю҆̀8_ю҆́8_ю҆̈8_ю҆̑8_юⷠ҇8_юⷡ҇8_юⷢ҇8_юⷣ҇8_юⷤ҇8_юⷥ҇8_юⷦ҇8_юⷧ҇8_юⷨ҇8_юⷩ҇8_юⷪ҇8_юⷫ҇8_юⷬ҇8_юⷭ҇8_юⷮ҇8_юⷯ҇8_юⷰ҇8_юⷱ҇8_юⷲ҇8_юⷳ҇8_юⷴ҇8_юⷵ҇8_юⷶ҇8_юⷷ҇8_юⷸ҇8_юⷹ҇8_юⷺ҇8_юⷻ҇8_юⷼ҇8_юⷽ҇8_юⷾ҇8_юⷿ҇8_юꙴ҇8_юꙵ҇8_юꙶ҇8_юꙷ҇8_юꙸ҇8_юꙹ҇8_юꙺ҇8_юꙻ҇8_ю꙼҇8_ю꙽҇8_є҆̀8_є҆́8_є҆̈8_є҆̑8_єⷠ҇8_єⷡ҇8_єⷢ҇8_єⷣ҇8_єⷤ҇8_єⷥ҇8_єⷦ҇8_єⷧ҇8_єⷨ҇8_єⷩ҇8_єⷪ҇8_єⷫ҇8_єⷬ҇8_єⷭ҇8_єⷮ҇8_єⷯ҇8_єⷰ҇8_єⷱ҇8_єⷲ҇8_єⷳ҇8_єⷴ҇8_єⷵ҇8_єⷶ҇8_єⷷ҇8_єⷸ҇8_єⷹ҇8_єⷺ҇8_єⷻ҇8_єⷼ҇8_єⷽ҇8_єⷾ҇8_єⷿ҇8_єꙴ҇8_єꙵ҇8_єꙶ҇8_єꙷ҇8_єꙸ҇8_єꙹ҇8_єꙺ҇8_єꙻ҇8_є꙼҇8_є꙽҇8_і҆̀8_і҆́8_і҆̈8_і҆̑8_іⷠ҇8_іⷡ҇8_іⷢ҇8_іⷣ҇8_іⷤ҇8_іⷥ҇8_іⷦ҇8_іⷧ҇8_іⷨ҇8_іⷩ҇8_іⷪ҇8_іⷫ҇8_іⷬ҇8_іⷭ҇8_іⷮ҇8_іⷯ҇8_іⷰ҇8_іⷱ҇8_іⷲ҇8_іⷳ҇8_іⷴ҇8_іⷵ҇8_іⷶ҇8_іⷷ҇8_іⷸ҇8_іⷹ҇8_іⷺ҇8_іⷻ҇8_іⷼ҇8_іⷽ҇8_іⷾ҇8_іⷿ҇8_іꙴ҇8_іꙵ҇8_іꙶ҇8_іꙷ҇8_іꙸ҇8_іꙹ҇8_іꙺ҇8_іꙻ҇8_і꙼҇8_і꙽҇8_ѡби1_ѣ҆̀8_ѣ҆́8_ѣ҆̈8_ѣ҆̑8_ѣⷠ҇8_ѣⷡ҇8_ѣⷢ҇8_ѣⷣ҇8_ѣⷤ҇8_ѣⷥ҇8_ѣⷦ҇8_ѣⷧ҇8_ѣⷨ҇8_ѣⷩ҇8_ѣⷪ҇8_ѣⷫ҇8_ѣⷬ҇8_ѣⷭ҇8_ѣⷮ҇8_ѣⷯ҇8_ѣⷰ҇8_ѣⷱ҇8_ѣⷲ҇8_ѣⷳ҇8_ѣⷴ҇8_ѣⷵ҇8_ѣⷶ҇8_ѣⷷ҇8_ѣⷸ҇8_ѣⷹ҇8_ѣⷺ҇8_ѣⷻ҇8_ѣⷼ҇8_ѣⷽ҇8_ѣⷾ҇8_ѣⷿ҇8_ѣꙴ҇8_ѣꙵ҇8_ѣꙶ҇8_ѣꙷ҇8_ѣꙸ҇8_ѣꙹ҇8_ѣꙺ҇8_ѣꙻ҇8_ѣ꙼҇8_ѣ꙽҇8_ѧ҆̀8_ѧ҆́8_ѧ҆̈8_ѧ҆̑8_ѧⷠ҇8_ѧⷡ҇8_ѧⷢ҇8_ѧⷣ҇8_ѧⷤ҇8_ѧⷥ҇8_ѧⷦ҇8_ѧⷧ҇8_ѧⷨ҇8_ѧⷩ҇8_ѧⷪ҇8_ѧⷫ҇8_ѧⷬ҇8_ѧⷭ҇8_ѧⷮ҇8_ѧⷯ҇8_ѧⷰ҇8_ѧⷱ҇8_ѧⷲ҇8_ѧⷳ҇8_ѧⷴ҇8_ѧⷵ҇8_ѧⷶ҇8_ѧⷷ҇8_ѧⷸ҇8_ѧⷹ҇8_ѧⷺ҇8_ѧⷻ҇8_ѧⷼ҇8_ѧⷽ҇8_ѧⷾ҇8_ѧⷿ҇8_ѧꙴ҇8_ѧꙵ҇8_ѧꙶ҇8_ѧꙷ҇8_ѧꙸ҇8_ѧꙹ҇8_ѧꙺ҇8_ѧꙻ҇8_ѧ꙼҇8_ѧ꙽҇8_ѯе́1_ѳї1_ѵ҆̀8_ѵ҆́8_ѵ҆̈8_ѵ҆̑8_ѵⷠ҇8_ѵⷡ҇8_ѵⷢ҇8_ѵⷣ҇8_ѵⷤ҇8_ѵⷥ҇8_ѵⷦ҇8_ѵⷧ҇8_ѵⷨ҇8_ѵⷩ҇8_ѵⷪ҇8_ѵⷫ҇8_ѵⷬ҇8_ѵⷭ҇8_ѵⷮ҇8_ѵⷯ҇8_ѵⷰ҇8_ѵⷱ҇8_ѵⷲ҇8_ѵⷳ҇8_ѵⷴ҇8_ѵⷵ҇8_ѵⷶ҇8_ѵⷷ҇8_ѵⷸ҇8_ѵⷹ҇8_ѵⷺ҇8_ѵⷻ҇8_ѵⷼ҇8_ѵⷽ҇8_ѵⷾ҇8_ѵⷿ҇8_ѵꙴ҇8_ѵꙵ҇8_ѵꙶ҇8_ѵꙷ҇8_ѵꙸ҇8_ѵꙹ҇8_ѵꙺ҇8_ѵꙻ҇8_ѵ꙼҇8_ѵ꙽҇8_ѻ҆̀8_ѻ҆́8_ѻ҆̈8_ѻ҆̑8_ѻⷠ҇8_ѻⷡ҇8_ѻⷢ҇8_ѻⷣ҇8_ѻⷤ҇8_ѻⷥ҇8_ѻⷦ҇8_ѻⷧ҇8_ѻⷨ҇8_ѻⷩ҇8_ѻⷪ҇8_ѻⷫ҇8_ѻⷬ҇8_ѻⷭ҇8_ѻⷮ҇8_ѻⷯ҇8_ѻⷰ҇8_ѻⷱ҇8_ѻⷲ҇8_ѻⷳ҇8_ѻⷴ҇8_ѻⷵ҇8_ѻⷶ҇8_ѻⷷ҇8_ѻⷸ҇8_ѻⷹ҇8_ѻⷺ҇8_ѻⷻ҇8_ѻⷼ҇8_ѻⷽ҇8_ѻⷾ҇8_ѻⷿ҇8_ѻꙴ҇8_ѻꙵ҇8_ѻꙶ҇8_ѻꙷ҇8_ѻꙸ҇8_ѻꙹ҇8_ѻꙺ҇8_ѻꙻ҇8_ѻ꙼҇8_ѻ꙽҇8_ѽ҆̀8_ѽ҆́8_ѽ҆̈8_ѽ҆̑8_ѽⷠ҇8_ѽⷡ҇8_ѽⷢ҇8_ѽⷣ҇8_ѽⷤ҇8_ѽⷥ҇8_ѽⷦ҇8_ѽⷧ҇8_ѽⷨ҇8_ѽⷩ҇8_ѽⷪ҇8_ѽⷫ҇8_ѽⷬ҇8_ѽⷭ҇8_ѽⷮ҇8_ѽⷯ҇8_ѽⷰ҇8_ѽⷱ҇8_ѽⷲ҇8_ѽⷳ҇8_ѽⷴ҇8_ѽⷵ҇8_ѽⷶ҇8_ѽⷷ҇8_ѽⷸ҇8_ѽⷹ҇8_ѽⷺ҇8_ѽⷻ҇8_ѽⷼ҇8_ѽⷽ҇8_ѽⷾ҇8_ѽⷿ҇8_ѽꙴ҇8_ѽꙵ҇8_ѽꙶ҇8_ѽꙷ҇8_ѽꙸ҇8_ѽꙹ҇8_ѽꙺ҇8_ѽꙻ҇8_ѽ꙼҇8_ѽ꙽҇8_ᲂ҆̀8_ᲂ҆́8_ᲂ҆̈8_ᲂ҆̑8_ᲂⷠ҇8_ᲂⷡ҇8_ᲂⷢ҇8_ᲂⷣ҇8_ᲂⷤ҇8_ᲂⷥ҇8_ᲂⷦ҇8_ᲂⷧ҇8_ᲂⷨ҇8_ᲂⷩ҇8_ᲂⷪ҇8_ᲂⷫ҇8_ᲂⷬ҇8_ᲂⷭ҇8_ᲂⷮ҇8_ᲂⷯ҇8_ᲂⷰ҇8_ᲂⷱ҇8_ᲂⷲ҇8_ᲂⷳ҇8_ᲂⷴ҇8_ᲂⷵ҇8_ᲂⷶ҇8_ᲂⷷ҇8_ᲂⷸ҇8_ᲂⷹ҇8_ᲂⷺ҇8_ᲂⷻ҇8_ᲂⷼ҇8_ᲂⷽ҇8_ᲂⷾ҇8_ᲂⷿ҇8_ᲂꙴ҇8_ᲂꙵ҇8_ᲂꙶ҇8_ᲂꙷ҇8_ᲂꙸ҇8_ᲂꙹ҇8_ᲂꙺ҇8_ᲂꙻ҇8_ᲂ꙼҇8_ᲂ꙽҇8_ꙋ҆̀8_ꙋ҆́8_ꙋ҆̈8_ꙋ҆̑8_ꙋⷠ҇8_ꙋⷡ҇8_ꙋⷢ҇8_ꙋⷣ҇8_ꙋⷤ҇8_ꙋⷥ҇8_ꙋⷦ҇8_ꙋⷧ҇8_ꙋⷨ҇8_ꙋⷩ҇8_ꙋⷪ҇8_ꙋⷫ҇8_ꙋⷬ҇8_ꙋⷭ҇8_ꙋⷮ҇8_ꙋⷯ҇8_ꙋⷰ҇8_ꙋⷱ҇8_ꙋⷲ҇8_ꙋⷳ҇8_ꙋⷴ҇8_ꙋⷵ҇8_ꙋⷶ҇8_ꙋⷷ҇8_ꙋⷸ҇8_ꙋⷹ҇8_ꙋⷺ҇8_ꙋⷻ҇8_ꙋⷼ҇8_ꙋⷽ҇8_ꙋⷾ҇8_ꙋⷿ҇8_ꙋꙴ҇8_ꙋꙵ҇8_ꙋꙶ҇8_ꙋꙷ҇8_ꙋꙸ҇8_ꙋꙹ҇8_ꙋꙺ҇8_ꙋꙻ҇8_ꙋ꙼҇8_ꙋ꙽҇8_ꙍ҆̀8_ꙍ҆́8_ꙍ҆̈8_ꙍ҆̑8_ꙍⷠ҇8_ꙍⷡ҇8_ꙍⷢ҇8_ꙍⷣ҇8_ꙍⷤ҇8_ꙍⷥ҇8_ꙍⷦ҇8_ꙍⷧ҇8_ꙍⷨ҇8_ꙍⷩ҇8_ꙍⷪ҇8_ꙍⷫ҇8_ꙍⷬ҇8_ꙍⷭ҇8_ꙍⷮ҇8_ꙍⷯ҇8_ꙍⷰ҇8_ꙍⷱ҇8_ꙍⷲ҇8_ꙍⷳ҇8_ꙍⷴ҇8_ꙍⷵ҇8_ꙍⷶ҇8_ꙍⷷ҇8_ꙍⷸ҇8_ꙍⷹ҇8_ꙍⷺ҇8_ꙍⷻ҇8_ꙍⷼ҇8_ꙍⷽ҇8_ꙍⷾ҇8_ꙍⷿ҇8_ꙍꙴ҇8_ꙍꙵ҇8_ꙍꙶ҇8_ꙍꙷ҇8_ꙍꙸ҇8_ꙍꙹ҇8_ꙍꙺ҇8_ꙍꙻ҇8_ꙍ꙼҇8_ꙍ꙽҇8_ꙗ҆̀8_ꙗ҆́8_ꙗ҆̈8_ꙗ҆̑8_ꙗⷠ҇8_ꙗⷡ҇8_ꙗⷢ҇8_ꙗⷣ҇8_ꙗⷤ҇8_ꙗⷥ҇8_ꙗⷦ҇8_ꙗⷧ҇8_ꙗⷨ҇8_ꙗⷩ҇8_ꙗⷪ҇8_ꙗⷫ҇8_ꙗⷬ҇8_ꙗⷭ҇8_ꙗⷮ҇8_ꙗⷯ҇8_ꙗⷰ҇8_ꙗⷱ҇8_ꙗⷲ҇8_ꙗⷳ҇8_ꙗⷴ҇8_ꙗⷵ҇8_ꙗⷶ҇8_ꙗⷷ҇8_ꙗⷸ҇8_ꙗⷹ҇8_ꙗⷺ҇8_ꙗⷻ҇8_ꙗⷼ҇8_ꙗⷽ҇8_ꙗⷾ҇8_ꙗⷿ҇8_ꙗꙴ҇8_ꙗꙵ҇8_ꙗꙶ҇8_ꙗꙷ҇8_ꙗꙸ҇8_ꙗꙹ҇8_ꙗꙺ҇8_ꙗꙻ҇8_ꙗ꙼҇8_ꙗ꙽҇8̀1ми1́1бли́1бра́1брѣ́1в2д́1вꙋ1́1д2в́1дре́1ды2́1дї́1жє1́1зда́1здѣ́1зри́1зрѧ́1клї́1кї́1кꙋ1́1лї́1ми1́1пи2́1пле́1плю́1пѡ1́1пѣ1́1рє1́1рї́1рѣ2́1рѷ2́1с2х́1спе́1ств́1сте́1сто́1твє́1твѣ́1тре́1тро́1тры́1трѣ́1трꙋ́1тча́1тї́1тѣ2́1тꙋ1́1х2м́1хи2́1це1́1цы1́1цѣ2́1чꙋ1́1ща1́1щє1́1ѳе1́2в1н́2в1ч́2м1н́2м1п́2п1н́2р1ц́2т1ќ2т1л́2т1ц́2ч1т́бно1́бро1́брѧ1́бща1́в1лє́в1ца́ва1с́вае1́вдо1́вед1́влю1́вне1́внѧ1́внꙋ1́во1с́вше1́г1ло́г1нꙋ́гни1́гра1́ди1в́дно1́дѡ1в́ема1́емо1́емꙋ1́ет1н́ете1́жнꙋ1́з1вѣ́з1др́з1нꙋ́з1ра́з1ꙋм́зво1́зе1р́зни1́иче1́иша1́кни1́кры1́крꙋ1́ла1с́ли1н́лє1м́м1ли́м1лѧ́мна1́мно1́мнꙋ1́мѡ1щ́нми1́ннї1́нꙋи1́ово1́пла1́пло1́р1ве́р1дї́рда1́рди1́ре1д́рма1́рна1́рне1́ро1в́рта1́рша1́рше1́рꙋю1́с1но́с1нꙋ́с1пѧ́с1са́с1цы́сав1́сли1́слѣ1́смо1́сни1́стꙋ1́сше1́таи1́тво1́ти1м́тла1́тли1́тна1́тне1́тнꙋ1́то1р́тцы1́тѧ1н́хї2́чат1́че1в́че1с́чи1с́чї1́шне1́щна1́щно1́ї2ќїа1́їи1́ї1л2́ѧти1̑1ва1̑1внѣ̑1да1̑1до1̑1дї1̑1дѣ2̑1дꙋ1̑1зни̑1ка1̑1кї1̑1ло1̑1лы1̑1лї1̑1ма1̑1мы1̑1ни1̑1п2л̑1па2̑1пи1̑1сни̑1та1̑1ты1̑1тї1̑2д1н̑2жд1̑2п1н̑гꙋб1̑даю1̑дни1̑дны1̑днї1̑дѣн1̑жны1̑жї1̑зан1̑зны1̑йши1̑лла1̑мны1̑нї1̑пкї1̑пни1̑пны1̑пї1̑рна1̑тна1̑тны1̑чна1̑чї1̾ꙋ́м1̾ꙋго1̾ꙋмѣ1а1во1а1вї1а1дї1а1дꙋ2а1знаа1лї1а1лꙋ2а1ме1а1мї1а1не2а1ню2а1рї1а1рѷ1а1рꙋ2а1се2а1стра1стѝа1т2ла1т2ча1тї1а1х2та1ѵ́1а2в1да2в1на2г1га2д1на2м1па2м1ча2с1на́1гла́1зра́1кла́в1ца́ва1а́да1а́з1ва́з1ꙋа́ка1а́л1ма́ла1а́лꙋ1а́м1ва́м1ла́мє1а́мꙋ1а́н1ма́н1та́нѧ1а́по1а́р1ва́р1га́с1на́с1па́ти1а́чи1а́ша1а́щꙋ1а́ѵ1ра̑1п2а̑2р1а̑2ч1а̑в1на̑с1наа́1набо1лабы̑1абꙋ́1ав1лєаво́1аврї1авше1авї1авѵ́1авѷ1авꙋ́1агда1аго1раго́1агра1агрѧ1ада̑1ади1вадно1адо1садї1ае2к1ае́1шаеди1аесѣ1аз1драз1дыаз1дѣазах1азди1азо1раи́1таи̑н1аимо1айшї1ака́1ака̑1ако1вако1нако1ракос1акѡ1вала1лала1мала1хали1нали̑1аллї1алю́1алї1ама1рамо1вамо1мамї1амꙋ́1анас1аннї1ано1вано́1ані́1анѡ1нанꙋ́1апе1тапе́1апер1апи́1апре1апі́1апї1ара1сардо1аре1маркї1аро1вартї1арє1марі́1арї1арїи1ас1лоас1пеас1пѧас1твас1тласпи1ассї1асє́1асі́1ата1вата1ната́1ата̑1ате́1ати1лато1сато́1атрї1аты̑1аті́1атї1атꙋ́1афї1афѵ́1аха1лаха́1ахі́1ахѡ́1аче1сачер1ашє́1ашꙋ́1аща́1ающї1аїа1аѧ́1таѧ́ю1аѯа́1аѳі́1а҆1з2а҆1ска҆1ста҆́1ба҆́1ма҆́л1а҆́н1а҆дѡ1а҆кꙋ1а҆ме1а҆мо1а҆ра1аꙋ́1таꙋ́1чб1ла̀б1лекб1ленб1лечб1лю̀б1лющб1немб1нетб1новб1ны_б1нѣ_б1нѣмб1ратб1рꙋ́б1рꙋгба1в2ба́1нба́1сба́1тба́1чба́1шбве́1бви́1бди́1бе1р2бе2з1бза́1бзꙋ́1би1с2би́1дби́1нби́1сби́1цбила1бити1биша1бла1дбле1мблєн1бно1мбнї1бо1з2бо́1збо́1кбо́1цбор1цбою́1бре1мбре1тбро1нбрѧ́1бско1бсто1бхо́1бща́1бще́1бы́1дбы́1шбы̑1нбє́с1бѡ́1гбѡ́р1бѣ́1жбѣ́1лбѣ́1мбѣ́1шбѣдо1бѣто1бѧ́1хбѧще1бꙋ2з1бꙋ́1дв1во_в1да́в1лю̀в1лѧ_в1на1в1неев1ни_в1никв1нихв1ницв1нодв1номв1нѧгв1нꙋюв1ст2в1ца_в1цы̀в2ло1в2сы1ва1ства́1два́1жва́1тва́1шва̑1швати1ваша1ваше1вают1вва́1вве1двве1сввер1вво́1ве1стве2з1ве́1чвеле1венї1вер1дверо1взы́1ви̑н1вила1вима1вимо1вити1вице1виша1вла1двла1свлѣ́1влѧ́1вма́1вмѣ́1вне1мвне́1во2ш1во́з1вод1нвое1мвозо1вона1вор1цвоси1восо1воца1воче1впа1двра1звра̑1вре1двре1мвро́1все1нвсе1рвсе1хвсе1цвсеѡ1вска1вскї1всѧ́1всꙋ́1вто1рвче1рвшаѧ1вше1мвы́1мвы́1нвє́1тві́1квї1квї1мвї1нвї1свї2л1вѣ́1швѣ̑ч1вѣко1вѣто1вѧ1з2вѧче1вѵ́1твѷ2с1в҃и́1вꙋе1мвꙋхо1г1ло_г1немг1нетг1ни_г2лѷ1га́1ггаа́1гама1гда1лгда́1гдо́1гдѣ́1ге2н1ге́р1геде1гер1мги́1нги̑з1гкѵ́1гла1вгла1сгло́1глї1глѧ́1гма́1гнї2го1в2го1с2го́1мгоиз1голꙋ1гона1госꙋ1гочє1гоѧв1гра1нгра̑1гре1мгре́1гро1мгрі́1грї2грѷ1гха́1гшї1гї1ггѡ1с2гѡ́1жгѡ́д1гѡ́р1гꙋб1лд1возд1лагд1лежд1насд1немд1ни_д1ни́д1нихд1ноєд1ны́д1нымд1ню_д1нѣмд1разд1рекд1речд1со2д1ст2д1хо2д2нѐд̾ѧв1да́1гда́1дда́1шда́є1дав1лдако1даро1дати1два1ндва́1две1рдвє́1двѣ1мдгла1дгрѧ1дебе1ди́1сди́1щди̑1мди̑в1див1лдиво1дима1димо1дино1дкло1дла̑1дма́1дми́1дмо́1днев1до1в2до́1вдо́1гдо́1сдоб1лдобо1дои́1дом1ндома1домо1доче1дпи́1дпро1дре1мдро1вдро1мдро1ндрї1дрѡ́1дрѣ́1дска1дско1дте́1дхо́1дше1мдше́1дщє́1ды́1кды́1нды́1шдїо1дѡна1дѣ́1ждѣ́1сдѣ́1тдѣ́1шдѣто1дѧ́1хдꙋ́1лдꙋ́1сдꙋ̑ж1дꙋим1дꙋща1е1вние1вное1дꙋ2е1з2ре1зи1е1зы2е1лї1е1лꙋ1е1мї1е1ню1е1ри2е1рє1е1рѣ1е1стве1стее1стое1стре1хи1е1це2е1цѣ2е1чꙋ2е2з1ве2з1де2з1не2р1це́1зре́1зꙋе́1тве́бе1е́в1ле́ви1е́г1це́дї1е́е1ве́жа1е́з1де́з1не́за1е́зо1е́ко1е́м1ве́н1ме́на1е́но1е́нї1е́нꙋ1е́р1бе́с1не́са1е́те1е́ти1е́ши1е́щї1еа1з2еа́н1еб1лееб1люебе1лебо́1ев1леев1лѧева1сева́1ева̑1еве1деве1реве1севзы1еви̑1ево1невол1евос1евра1евы1мевє́1евѣ1севѧ1тевѧ́1еги́1его́1егра1егре1егрѣ1егѡ́1егꙋ1бед1воед1вѣед1наед1ниед1ныед1нѣед1нꙋед1раеда̑1еди̑1еднї1едо1медо1седох1едѣ1лее́н1еза1хезды1езе́1езна1езне1езо́1езпо1еи1спека́1еко1некї1ела̑1ели̑1ело1велю1белю́1елє1нема́1еме1неми1немо1ремол1емощ1емї1емѡщ1емѧ́1ена1дене1сенеѡ1ени1хено1вено1ментї1енѧ́1ео́1гео́1део́1пео́1фео́н1епе1тепре1епро1епі́1епѣ́1ер1ж2ер1з2ер1твераз1ерво1ерна1ерп1лері́1ерї1керїн1ерѡ1нерѧ́1еско1ескꙋ1еслꙋ1есо1месож1еспа1есса1есї1есѡ́1ета̑1етер1ето́1еты1реты́1етї1етꙋ́1еча1тече1речи1сечна1еще́1ещи́1еѡ1с2еѡ́р1еꙋвѧ1еꙋга1жа́1жжа́1шжа́1щжда1нжда́1ждеѡ1жди1вждшї1ждє́1же2з1же2р1женї1жже́1жжи́1жи1з2жи1с2жи́1нжи́1сжив1лжити1жице1жиша1жне1мжнї1жро́1жска1жско1жє́р1жїѧ1ж҃е́1з1ва_з1вамз1вѣ_з1вѣ̑з1вѣщз1дназ1дныз1днѣз1днꙋз1дꙋ́з1ла̀з1лагз1лꙋ1з1не́з1невз1негз1носз1нꙋтз1расз1ращз1речз1рещз1ринз1рѣшз1ꙋ́мз1ꙋмыз2ꙋ1бз̾ѧ1вза1р2за1т2за́1мза́1сза́1шза́ѧ1за̑1нза̑д1зан1тзапе1запо1захо1заꙋ́1зби́1збла1збле1збо1лзве1дзве1сзвер1зви1тзвла1зво1лзвы́1згнꙋ1згре1здо́1зды1хздѣ1лзе́р1зже1нзи1н2зи́1дзи́1жзи́1сзла́1зла̑1зле1тзли1взма́1зми́1змо1взно1взны1мзо2ч1зото1зпо́1зпро1зска1зско1зсло1зсмо1зсто1зсї1зсѣ́1зсꙋ1дзсꙋ́1зче́1зчи́1зы́1дзы́1тзыко1зѡ1с2зѧ́1сзꙋ̑м1и1вї1и1вѣ1и1вѧ2и1зваи1зи1и1зрѣи1кꙋ2и1лї1и1ме1и1на2и1ни2и1нꙋ2и1ре2и1ри2и1рї1и1с2ки1с2ни1с2ти1со2и1спѣи1то2и1тї1и1тꙋ1и2в1ни2к1ни2м1ти2с1ли2с1хѝдѣ1и́1бли́1зви́1зри́1зꙋи́1ски́1сни́1три́1тчи́бо1и́ва1и́во1и́вї1и́г1ни́зо1и́к1ни́ка1и́ли1и́лї1и́ма1и́н1ми́на1и́ни1и́нї1и́рї1и́си1и́сѧ1и́та1и́тї1и́че1и́ша1и́щꙋ1й1д2й1ж2й1м2й1н2й1с2й1ш2йде2йдꙋ2йне1йно1йню1йнї1йнѧ1йнꙋ1йст2йте1йче1йша1йшꙋ1и̑1р2и̑1с2и̑1т2и̑2ж1иба́1ибо́1ив1люив1лѧива́1иве1диве1сиво1миво1ниво1сившы1ивї1ига́1иги́1игла1иго1рида́1иди́1идї1идѣ́1идꙋ́1ижє́1из1неиз1рииза̑1изла1изло1ика́1икло1ила1сила́1или́1или̑1ило1силѧ́1илꙋ́1ими́1имѣ́1инин1иннї1ино1вино1мині́1инѧ́1ипа1дипа́1ипї1ипїо1ипѣ1вира́1ирен1иро1нирї1ирѧ́1иса̑1исво1исвѧ1исса1исте1исі́1исї1ите1цитро1итрї1итї1ифле1ихо́1ица́1ице1миче1сиче́1ичє́1иши1нище1тиѳа́1и҆1н2и҆́1би҆́1ги҆́1ди҆́1жи҆́1ри҆́1си҆́з1и҆з1ди҆з1ри҆лї1и҆с1пйнї1йска1йско1йскꙋ1ка1з2ка́1гка́1жка́1шкали1ката1квер1кді́1ке́1ѵке́л1кеса1ки1т2ки2р1кибы1ккли1кла1нкле1вклї1пкни1тко2з1ко́1жков1нков1сколє1корѡ1крае1крен1кро1вкро1мкро1нкта́1кте1нкто1мкто́1ктї1ктѡ́1кє́л1кѡ́1скѡ́з1кѡ́р1кѵ́1лкѷ2м1кꙋ́1фкꙋсо1л1вї1л1го1л1же2л1ка2л1ко1л1мї1л1на2л1нѧ2л1нꙋ2л1па2л1пѝл1по2л1пꙋ2л1чꙋ1л2в1нл2п1нла1т2ла2ѵ1ла́1шла́ѵ1ла̑1сла̑в1ла̑д1лав1лладо1лан1тлато1лаща1лвї1лдє́1ле́1пле́1щле́т1леве1лезо1лерї1лзно1лзше1ли́1рлимо1лле́1ллї1нллѵ́1лма1тлна́1лнеч1лни1слно́1лнє́1лнї1лнїи1лнїѧ1лнѧ́1лнѧт1лнꙋ́1ло1з2лов1ллоги1лпни1лпї1лхї1лче́1лчи1тлчє́1лчї1лы́1шлы́в1лі́1влі́1длїко1лїо́1лїса1лѡ́ж1лѣ́1слѣ̑д1лѧ́1длѧще1лѵ́1плѵ́1рлѵ́м1лѷ1кл҃ко1лꙋ́1шлꙋ̑ж1м1ле_м1лемм1летм1лешм1ли_м1лютм1лѧ_м1никм1нѣ_м2нѐм2ню2ма́1гма́1мма́1тмага1мала1мано1мате1мва́1ме́м1мено1мер1тмеч1тми́1жми́1мми́1цмило1мимо1миро1мла1дмла́1мле́1млє́1ммѡ́1мна́1мно́1мні́1мнї1мнѡ́1мнꙋ́1мо1влмо1скмо́1рмое1ммопо1мпе1рмре́1мро́1мрє́1мска1мско1мфї1мшї1мще́1мы́ш1мі́є1мїи́1мїлї1мїса1мїха1мѡ2р1мѡ́ж1мѡ́л1мѣ́1тмѣ́1шмѣ̑1нмѣ̑д1мѣ̑р1мѣѧ́1мѷг2мꙋ1д2мꙋ́1чмꙋ́1ѳмꙋ́и1мꙋси1н1дран1дрен1ды1н1дї1н1дꙋ2н1ко2н1рѐн1те1н1то2н1ца̀н1це́н1цемн1цы̀н1цѣ2н1цꙋ̀н1цꙋ́н2кѝна1з2на1р2на1ѵ2на́1зна́1шна́ч1наа́1навꙋ1нази1наи́1налѧ1напе1нари1наса1нахо1начи1нди́1ндро1ндї1ндꙋ́1не1д2не́1бне́1гне́1рнебы1нев1нневе1нели1нене1нерꙋ1несѣ1нетѣ1ни́1дни́1зни́ж1ниво1нице1ниша1нище1нна́1нни1ннни́1ннꙋю1но1с2но́1зно́1кножи1нона1ноте1ноче1ноще1ноѧв1нска1нско1нскꙋ1нсї1нта́1нтѡ1ннтѡ́1нчи́1нє́ч1нї1кнї1мнї1ннїо1нї2г1нїе1внїка1нїма1нїне1нїѧ1мнѡ́1гнѡ́1жнѣ́1кнѣ́1тнѣ́ч1нѣ́ш1нѧ́1жнѧ́1хнѧти1нѳи́1нѳї2нꙋ́1шо1в2чо1вѧ2о1знао1зрио1зрѣо1зрѧо1лѷ1о1м2ло1м2по1мнѣо1мѧ1о1ню2о1ри2о1рцыо1рї1о1рѷ1о1с2цо1се2о1стео1стло1стоо1стѝо2в1цо2д1ло2ж1жо2з1во2с1но2с1хо2ш1ло́1гно́1дро́1спо́бо1о́бѧ1о́в1ло́в1цо́га1о́з1но́з1ро́ка1о́лч1о́лє1о́лѣ1о́ма1о́мꙋ1о́н1до́р1до́р1жо́р1ло́р1со́ра1о́ри1о́рм1о́рꙋ1о́с1но́с1цо́тї1о́ц1ко́ша1о́щї1о́ї2об1лѧоба́1обо1сов1люов1лєов1лѧов1ноов1нѣов1нꙋова1сове1дове1совер1ови1вово1лово1совто1ові́1огло1ого́1огрѣ1од1наод1ноод1ныод̾и1ода1водво1одо1содох1одро1одрꙋ1оды́1одї1одѣ1водѣ̑1одꙋх1ое́1ное́1шоеди1оже1ноже1соз1дѣоз1дꙋоз1неоз1ниоз1нооз1раозвѣ1озже1ози́1озор1озсо1ои2с1ои́1дои́1соиз1воиз1нока1рокла1око1воко1рокри1окрꙋ1оле1соле1толи1воли̑1оллї1оло1молю1болі́1олїн1олѣ̑1олѧ́1олѷ1ома́1оми1номо1ломо1номо1щомра1омы1сомы́1оню́1онї1онѧ́1онѵ́1оп1лѧопа1допа1ропер1опи1топро1опї1ор1м2орас1ордї1оре1норе1хорто1орє́1орї1орѡ1норѣ́1орѣ̑1ос1клос1плос1пꙋоса́1оси̑1осі́1осї1осꙋ1дотер1отов1отѣ̑1офа́1охі́1оцѣ1лоче1ноче1соче1точи1точно1оша́1оше1ношє́1ощни1ощї1ою́1доѧ́1жоѧ́в1оѧв1лоᲂу҆1оꙋме1п1лю̀п1нымп1пи1п1ст2п2нѝп2сѝп2ше1па1т2па2г1па2м1па2н1па́1жпа́1кпако1пара1пари1пас1лпаѧ́1пе́1ппе́1спела1пелє1пи́1щпла1мпло1мплї1плѡт1пнет1по1з2по́1жпо́1зпо́1ппо́1тпо́1хпо́1чпове1под1нподе1поже1пола1полї1попа1попе1попи1попꙋ1пора1поре1порꙋ1посы1почꙋ1поща1пра1ѯпра̑1пре1зпре1мпре1нпре1тпре1хпри́1про1впро1зпро1мпро1нпрєн1прї1прїѡ1прѣ́1прѧ́1прꙋ́1пта́1пти̑1пфі́1пє́н1пє́р1пї1кпї1лпї1мпї1с2пїо́1пѡ́1тпѡ̑н1пѣ́1тпѣ́ѧ1пѣше1пꙋ1т2р1венр1вї1р1вѣ1р1вꙋ1р1го2р1дꙋ1р1з2ꙋр1зы2р1ко2р1кїр1кꙋ2р1ла1р1м2лр1мї1р1се2р1скꙋр1со1р1стор1твар1твер1твир1твор1твыр1твєр1твїр1твѣр1твꙋр1ти2р1тꙋ1р1хо1р1цы_р2б1лр2г1нр2д1нр2з2лр2м1нр2м1чр2т1кр2це2ра1т2ра̑1вра̑1жра̑1лра̑з1ра̑ш1рав1лраз1нрамо1расѡ1рато1рбѣ́1рбѧ́1рва́1рве́1рвле1рво1зрвї1ргнꙋ1ргі́1рда1лрди1срди1трды́1рдѧ́1ре1в2ре1мнре1р2ре1ч2ре́1жре́1зре́1лре́1пре́1чред1вред1лред1рредо1рела1релю1рене1рже1сржет1рзе́1рзно1рзо́1ри1влри1з2ри1н2ри1с2ри́1дри́1жри́1щризы1рика1рили1рими1ркѵ́1рли́1рлин1рма1нрма́1рмо1лрмꙋ́1рна́1рне1мрншї1ро1зрро1р2ро1с2ро́1лро́1нро́1про́1хробо1ровѣ1рое́1рои́1рока1роли1ролї1ромо1рон1трона1ропо1росо1ротѧ1роче1роѧ́1рп1люрпа1српа́1рпї2рпѧ́1рсе́1ртна1ртно1ртнꙋ1рты1мртѵ́1рфѵ́1рхї1рца́1рчи́1рша́1рше1мры́1сры́1тры́1шрько1рєни1рі́1крі́1хрї1с2рїи1мрѡ́1срѣ1з2рѣ́1жрѣ́1зрѣ́1нрѣ́1срѧ́1мрѧ́1хрѧ́з1рѧ́ю1рѳе́1р҃ї1рꙋ1б2рꙋ́1зрꙋ́1прꙋ̑1прꙋцѣ1с1кꙋшс1ло̀с1лꙋ̀с1нетс1но̀с1нꙋ̀с1нꙋтс1нꙋюс1са_с1се2с1со2с1ст2с1течс1тлѣс1цы_с2лї1са́1тса́1шса́р1са̑д1сава1саи́1сала1сало1санꙋ1сата1саха1саша1сбꙋ́1сви́1свы́1сві́1свѧ1тсвѵ́1се1д2се1з2се́1все́1ссе́1шсебо1сева1севе1сегꙋ1секо1сена1сене1сеца1си́1рси́1тси́1цсице1ска̑1скон1скри1скі̑1сле1зслен1сли1мсли1нслы́1слєн1сма1мсма1рсма́1смер1смо1лснис1снї1со1с2со́1ссо́1цсо́п1соза1созы1соиз1соло1сони1сопо1соче1сочи1соѧ́1спол1спре1спро1спрѧ1спѣ1всра1ссрав1сраи1сре1дсри́1срѧ́1сса́1сска1сскꙋ1ссо́1ссѡ́1ссѣ́1ссѷ1став1стан1сте1цстер1сти̑1стї1схи́1сцѣ1лсча̑1счер1сше1мсшї1сі́1лсі́1мсі́1нсї1ксї1нсї1псї1ссїо1сѡ1с2сѡ́1жсѡ́1зсѡ́1ксѡ́с1сѣ́1всѣ́ю1сѣ̑1тсѧ2ч1сѧ́1дсѧ́з1сѧто1сѧща1сѧще1сꙋ2б1сꙋ́1хсꙋ́1шсꙋ́ю1сꙋще1т1ка̀т1лагт1лаѧт1ли_т1лѣ_т1неет1номт1ню1т1нѣ_т1нѣ̀т1нꙋют1цѣ_т2ле1та1с2та́1дта́1жта́1кта́1тта́1шта̑1нта̑в1тав1лтакѡ1тан1ттаѧ́1тва1мтвен1твич1твї1твꙋ́1те́1бте́1лте́1чтезо1тели1тенї1ти́1жти́1нти́1стива1тино1тити1тихо1тиша1тиши1тка́1тла́1тли1втма́1тмо1ртмо́1тне́1тно́1тны̑1тні́1тнї1тнꙋ́1то́1жто́е1то́т1то́ѧ1тов1нтов1стоже1толю1топо1точ1нтраг1тре1мтрез1три1втрєн1трѡ́1тхї2тча́1ты́1сты́д1ты̑н1ті́1гті́1мтї1лтї1мтї1нтїнї1тѡ́и1тѣ́1стѣ̑1нтѷ2м1т҃о1мтꙋ́1нтꙋ́1чтꙋ́1щтꙋ̑д1тꙋ̑п1фа1л2фа́1вфара1фе1р2фе2ѵ1фе́1сфле́1фнꙋ́1фран1фро́1фрон1фрї1кфска1фі́р1фї1л2фїла1фѡ́1кфѡ́1тфѵ́1рфꙋ2л1фꙋ2р1х1но1х1ти1х2не2ха́1мха́1рха́ю1ха̑1нхана1хара1хва1лхе1в2хе1р2херꙋ1хи́1рхи́1тхи́н1хи́щ1хи̑н1холю1хопа1хра1нхрї1хрѷ1хска1хстѣ1хті́1хї1мхї1схї2кхїсе1хѡ́1мхꙋ́1дц1ка1ц1ко1ц1кїцвѣ1тце2р1це́р1цего1цеса1цїо2цѣ1в2ч1нетч1никч1ницч1нꙋ1ч1то_ча1с2ча́1мча́1нча́1шча̑1тчало1часо1че1з2че́1жче́1шче́з1чево1чело1чено1ченї1чер1тчерм1черї1чи́1счи́щ1чино1чити1чиша1чноа1чнї1чнꙋю1чта̑1чтє́1чюде1чє1н2чє́1лчє́в1чє́р1ч҃ї2чꙋ̑д1чꙋдо1ша1с2ша́1нша́1шша́в1ша́л1ша́є1шаго1шагѡ1ше2в1ше́1сше́в1шело1шемо1шемꙋ1шенї1ши1с2ши́1пши́1сши́р1широ1шити1шлє́1шшым1шє́1сшє́в1шїи1шꙋ́1сшꙋ́ю1шꙋще1ща́1сща́1шща́1щщаго1ще1д2ще́1сщебо1щемꙋ1щенї1щи1с2щи́1сщна́1щно1мщно́1щшаѧ1щє́1рщє́т1щїи1ы1не1ы1но1ы1ро1ы1рї1ы2к1ны́1кны́1щ2ы́2г1ы́2п1ы́б1лы́лї1ы́нї1ы́те1ы́ти1ы́ты1ы́тї1ы́че1ы́чи1ы́ше1ы̑1с2ы̑2в1ыва́1ыва̑1ыдѣ́1ыза́1ыко1выко́1ыла́1ыпа́1ыре1дыре1нысѡ́1ытї1ытꙋ́1ыха̑1ыша́1ыше́1ыща́1ыщи́1ь1ствь2мо2ьбо́1ьво́1ькї1ьмо́1ьнї1ьска1ьскꙋ1ьшаѧ1ьшым1ю1до2ю2б1вю2б1лю́1с2ю́1щ2ю́б1лю́дї1ю́дꙋ1ю́та1ю́то1ю́щꙋ1юбо1мюди́1юдо́1юче́1ю҆́1жю҆́1нє1ма1є́1брє́1ж2є́1п2є́2д1є́2з1є́би1є́лю1є́лї1є́нї1є́р1дє́р1сє́с1нє́че1єва́1єдни1єнни1єнї1єска1єскї1єтна1єчны1єѵрѡ1є҆1в2є҆1з2є҆1с2є҆́1вє҆́1жє҆́л1є҆́м1є҆ка1є҆ре1є҆ѧ́1ѕвѣ̑1ѕла̑1ѕло1вѕмї1і́1смі́н1ді́ни1і́нꙋ1і́р1мі́ро1і́с1сі́то1і́тѧ1і́че1і́є1вї1в2ї1гаї1гиї1д2ї1кеї1кої1ктї1кії1кѡї1леї1лиї1лії1маї1неї1ної1раї1реї1саї1сеї1сєї1сѡї1т2ї1ф2ї1ѷ1ї2й1їа1дїа1мїа1нївї1їдї1їе2мїи1нїи1тїй1їи̑2їн1дїн1тїо1мїо1нїп1пїпї1їр1сїс1сїтѷ1їтꙋ2їє́1їѡ1нїѡ1сїѳе2і̑1с2і҆1м2і҆1с2і҆2з1і҆2н1і҆́1ді҆́н1і҆а́1і҆дѡ1і҆са1ї1кї1ї1ло1ї1лꙋ1ї1ме1ї1мо1ї1мї1ї1на2ї1па2ї1ро1ї1со1ї1стеї1стої1стрї1ѷ1ї2г1гїа́1дїве́1ївї1їги́1їдї1їе1р2їе́1шїи1с2їи́1дїи́1нїи̑м1їка1нїки́1їко1нїко́1їкто1їкї1їл1в2їла1рїле́1їллї1їлїп1їман1їне́1їноа1їнтї1їо1с2їо́1пїпї1їпїо1їс2т2їса1вїсі́1їті́1їтѷ1їфа́1їха́1їхи́1їхи̑1їча́1їѧ1в2їѧ́1сѡ1во2ѡ1вѣ1ѡ1дї1ѡ1ло1ѡ1мо2ѡ1ри2ѡ1то1ѡ1тї1ѡ1ѷ1ѡ́1брѡ́1ждѡ́1здѡ́ва1ѡ́ви1ѡ́га1ѡ́гї1ѡ́же1ѡ́жї1ѡ́з1нѡ́и1хѡ́ин1ѡ́ка1ѡ́л1гѡ́л1нѡ́ли1ѡ́лї1ѡ́мї1ѡ́р1бѡ́р1дѡ́р1сѡ́с1нѡ́с1сѡ́ча1ѡби1тѡби́1ѡбли1ѡбрꙋ1ѡбѣ́1ѡв1люѡв1лѧѡва́1ѡгор1ѡді́1ѡдї1ѡли́1ѡлі́1ѡлѣ́1ѡма́1ѡні́1ѡпи́1ѡпре1ѡре́1ѡри́1ѡров1ѡры́1ѡсвѧ1ѡсї1ѡтї1ѡчи́1ѡ҆1з2ѡ҆1с2ѡ҆́1бѡ҆гꙋ1ѡ҆до1ѡ҆дꙋ1ѡ҆за1ѡ҆ка1ѡ҆мо1ѡ҆па1ѡ҆ро1ѡ҆сѣ1ѣ1в2нѣ1де2ѣ1дї2ѣ1дꙋ2ѣ1з2рѣ1ла2ѣ1ло1ѣ1лꙋ2ѣ1на2ѣ1не2ѣ1но2ѣ1па2ѣ1пи2ѣ1по2ѣ1ре2ѣ1ро1ѣ1со2ѣ1стеѣ1стѝѣ2в1цѣ2д1нѣ2з1дѣ2к1нѣ2п1лѣ2т1лѣ2х1мѣ́1влѣ́1гдѣ́1ктѣ́в1цѣ́ви1ѣ́г1нѣ́до1ѣ́дї1ѣ́дꙋ1ѣ́жи1ѣ́за1ѣ́ка1ѣ́ко1ѣ́ли1ѣ́н1мѣ́пї1ѣ́р1сѣ́ро1ѣ́рї1ѣ́со1ѣ́та1ѣ́чи1ѣ́ще1ѣ̑1снѣ̑2п1ѣ̑ст1ѣви́1ѣга́1ѣдне1ѣдню1ѣдо́1ѣже́1ѣки́1ѣко́1ѣла́1ѣле1сѣло́1ѣлѣ́1ѣлѧ́1ѣнї1ѣнѧ́1ѣпа́1ѣпі́1ѣрѧ́1ѣта́1ѣто1вѣто1лѣто1рѣха́1ѣше1мѣшє́1ѣще1нѧ1не2ѧ1нꙋ2ѧ1тї1ѧ1це1ѧ2б1лѧ2т1кѧ́да1ѧ́до1ѧ́зл1ѧ́ка1ѧ́н1мѧ́т1чѧ́ти1ѧ́то1ѧ́тї1ѧ́че1ѧ́ша1ѧ́ше1ѧба́1ѧбе́1ѧв1леѧва́1ѧви́1ѧги́1ѧда́1ѧдꙋ̑1ѧзꙋ́1ѧни́1ѧны́1ѧса́1ѧсꙋ́1ѧта́1ѧта̑1ѧти̑1ѧтна1ѧті́1ѧтї1ѧца́1ѧче1сѧче́1ѧща́1ѧщен1ѧщї1ѧюще1ѧ҆1з2ѯа2н1ѯа́1рѯакꙋ1ѯапо1ѯено1ѱа́л1ѳа2г1ѳа2д1ѳа2ѵ1ѳала1ѳе1р2ѳео́1ѳера1ѳеѡ́1ѳоло1ѳсї1ѳїс2ѳїфа1ѳѵ́1мѵ1ка2ѵ1ло2ѵ1ре2ѵ1рї1ѵ1стрѵ2ї1ѵ́1птѵ́нї1ѵ́те1ѷ1гдѷ1каѷ1кеѷ1ктѷ1л2ѷ1п2ѷе1лѷе́2ѷза2ѷла2ѷм1вѷна1ѷри2ѷро1ѷрї1ѷхї1ѵа́н1ѵге́1ѵдї1ѵло́1ѵма́1ѵме́1ѵно́1ѵнї1ѵпра1ѵрі́1ѵрї1ѵрѡ́1ѵсе́1ѵсї1ѵсѷ1ѵті́1ѵтѷ1ѵфро1ѵѳа́1ѵѳѵ́1ѵ҆2с1ѵ҆пе1ѵ҆по1ѷ1г2нѷ1ме1ѷ1мї1ѷ2м1пѷзан1ѷка1рѷке́1ѷкто1ѷлі́1ѷмпї1ѷно́1ѷпі́1ѷрї1ѷсо́1ѷхї1ѹ҆1б2ѹ҆1в2ѹ҆1з2ѹ҆1м2ѹ҆1скѹ҆1спѹ҆́1бѹ҆́1нѹ҆́1хѹ҆́1чѹ҆га1ѹ҆ко1ѹ҆не1ѹ҆ни1ѹ҆по1ѹ҆та1ѹ҆то1ѻгне1ѻнꙋ́1ѻр1д2ѻрꙋ́1ѻтро1ѻ҆1в2ѻ҆1з2ѻ҆1с2ѻ҆б1рѻ҆бо1ѻ҆ди1ѻ҆ка1ѿва1лѿвер1ѿвра1ѿго́1ѿе́м1ѿкро1ѿкꙋ́1ѿне́1ѿра1сѿра́1ѿри́1ѿсе́1ѿсто1ѿто́1ѿтꙋ́1ѿхо́1ѿча́1ѿча̑1҃га́1҃е́1с҃и́1в҃и́1с҃и́1ц҃и́1ч҃неч1҃нї1҃о1в2҃о1з2҃о́в1҃оиз1҃олю1҃она1҃оне1҃оѧв1҃рне1҃рни1҃рї1҃тво1҃ше́1҃ща́1҃ще́1҃ы́1н҃є́н1҆1в2д҆1в2н҆1в2ц҆1в2ч҆1во1҆1вї1҆1вꙋ1҆1зе1҆1и1с҆1лѷ2҆1лꙋ1҆1м2н҆1м2п҆1мї1҆1мѧ2҆1нꙋ2҆1пи2҆1пꙋ1҆1рї1҆1рѡ1҆1рꙋ2҆1с2н҆1се2҆1скл҆1со2҆1спа҆1спи҆1сы1҆1чꙋ1҆1ї1҆1ꙋ1в҆1ꙋ1д҆1ꙋ1л҆1ꙋ̑1҆2б1в҆2б1д҆2в1л҆2с1х҆2с1ц҆2т1ч҆́1бл҆́1бр҆́1вц҆́1гц҆́1зр҆́1ск҆́1сн҆́1сп҆́1щ2҆́2ц1҆́ва1҆́ве1҆́во1҆́вї1҆́дї1҆́з1д҆́з1н҆́зе1҆́л1ч҆́мо1҆́мѧ1҆́н1д҆́на1҆́ни1҆́нѡ1҆́нꙋ1҆́р1т҆а1р2҆а2м1҆а́1к҆анꙋ1҆б1рꙋ҆ба́1҆би1т҆бла1҆бли1҆бни1҆бол1҆бре1҆бѡ́1҆вва1҆ве1н҆вї1҆вѣ1р҆глѣ1҆гор1҆гро1҆да1л҆дав1҆до1л҆дє́1҆дї1҆дѡ1л҆дѣ1в҆дѣ́1҆дꙋ́1҆е1з2҆езе1҆еро1҆ерꙋ1҆жи́1҆з1н2҆з1ра҆з1рѧ҆з̾ꙋ1҆зви1҆зже1҆зи́1҆зли1҆змо1҆зне1҆знꙋ1҆зсꙋ1҆зі́1҆ка1л҆кле1҆кло1҆ко1в҆кро1҆крꙋ1҆кте1҆кї2҆кѵ́1҆кѷ1҆л1в2҆ла1р҆ла́1҆лве1҆лез1҆леѵ1҆ли́1҆ли̑1҆лма1҆лїи1҆лїо1҆лѷ2҆ме1н҆мо1в҆мо1н҆мпе1҆мра1҆мѣ̑1҆мѧ́1҆мꙋ́1҆на́1҆нем1҆ни1с҆ни́1҆нтї1҆ні́1҆нї1҆нѵ́1҆нꙋ́1҆па1с҆пе1р҆пи́1҆пле1҆по1р҆по́1҆пол1҆поѧ1҆про1҆прѣ1҆пі́1҆пї1҆р1г2҆р1м2҆ра1в҆ра1з҆рда1҆ре1т҆рпа1҆рѧ́1҆с1по҆с1пꙋ҆с1тл҆с1то҆свѣ1҆свѧ1҆ски1҆смо1҆стꙋ1҆сцѣ1҆сі́1҆сї1҆сѣ1н҆сѣ́1҆сѣк1҆сѷ2҆сѷг1҆сꙋ1д҆сꙋ́1҆та́1҆ти́1҆то1л҆то́1҆тѣ́1҆фе́1҆фрї1҆ха́1҆хі́1҆ча́1҆че1н҆че1с҆чи1с҆чре1҆чє́1҆ши́1҆шꙋ́1҆ще́1҆ѡна1҆ѧ2з1҆ѧ́1ж҆ѧ́з1҆ѵрѡ1҆ꙋ́1д҆ꙋ́1л҆ꙋ́1н҇лі́1҇лї1҇на́1҇но1м҇но́1҇нї1҇рди1҇рдї1҇ро́1҇ти́1҇то1в҇то1м҇тои1҇тї1҇тѡ́1҇че1сᲂу҆1лᲂу҆1пᲂу҆̀1ᲂу҆г2ᲂу҆с2ᲂу҆т2ⷣбно1ⷣнї1ⷣте́1ⷣтї1ꙋ1д2рꙋ1дї1ꙋ1дꙋ2ꙋ1ре1ꙋ1ри2ꙋ1ро2ꙋ1троꙋ2д1нꙋ2з1дꙋ2з1нꙋ2ш1лꙋ́бо1ꙋ́гꙋ1ꙋ́жї1ꙋ́ко1ꙋ́нѧ1ꙋ́р1тꙋ́ре1ꙋ́рж1ꙋ́с1сꙋ́ча1ꙋ́че1ꙋ́ше1ꙋ́щꙋ1ꙋ́ї1ꙋ̑2в1ꙋ̑2н1ꙋ̑2с1ꙋб1люꙋба́1ꙋби1нꙋбны1ꙋбнꙋ1ꙋбо́1ꙋвше1ꙋга́1ꙋда́1ꙋден1ꙋдо1лꙋдро1ꙋдї1ꙋдѣ1вꙋемо1ꙋете1ꙋзі́1ꙋко1вꙋко1нꙋко1сꙋкра1ꙋкі́1ꙋле́1ꙋмі́1ꙋпа́1ꙋров1ꙋсо1мꙋсто1ꙋстѡ1ꙋсї1ꙋтї1ꙋха́1ꙋцѣ1лꙋче1нꙋчє́1ꙋше1тꙋща́1ꙋще́1ꙋщї1ꙋѧ́1мꙍ҆̑1лꙗви́1ꙗ҆1з2ꙗ҆1с2ꙗ҆́1мꙗ҆́1р",
		6 : "1а̑2м11ален11б2лѝ1б2лї11б2рѡ21бле1в1бле1с1блег11блю1д1брї11брѣй1бщї21ва́1г1ва́й1ва́є11ва̑1н1ванї1варѝ1ве́1ш1вед1н1вен1т1ви́1ч1вирї1вле1ц1вы1ш21вє́1л1вє́н11вѡ́1д1вѣ́й1вѧ́1с1вѧ́1х1вѧ́д11вѧщї1вѵ́1л1вꙋ́1щ1вꙋ́р11г2ле11г2лї11г2на21г2нѝ1г2ню21г2нї21га1д21га́1х1га́1ш1га́й1ги́1т1гнеѡ11гни́11го1з21го1н21го́1ж1го́1н1го́1с1го́ф11гопо11горї1д2рї11д2рѣ21да1с21да́й1дайт1далї1данї1де́1к1де́1ш1де́ч11десѝ1длен11дне1с1дно1в1дрен11дє́ч11ді́1т1ді́е11дї1г1дїѐ1дїе́1дїѧ̀1дїѧ́1дꙋ́1г1дꙋ́1з1дꙋ́1щ1дꙋ́ж11емо1м1емы1м1еро1в1еро1м1ет1но1ет1ны1же́й1жє́1с1з2нї11з2рѝ1з2ꙋт11здан11зе2т11зе́й1зре́11зы́б11зы́й1и1лє11и1се21и2с1ц1из1ни1изы́11искꙋ11ка1с21ка́1к1ка́1м1ка́й1ка́ю11ка̑1з1ка̑н11квї21ке1д21ке́1р1ке́м11ки́1р1клик11клїй1ко1ст1ко́1п1кое́11коей1копи11коре11корꙋ11кры1м1кі́1т1кі́с11кїи21кі̑й1кї2л11кї2н11кꙋ2з11кꙋ́1р1кꙋ́1щ1ла́й1ланї1лати11лаѧй1ле1р21ле́1р1ле́1ч1ле́б11ле́ж11лежѐ1лема11лемо11лемꙋ11лен1т1лесѐ1лесѝ1ли́1б1ли́1щ1ли̑1к1ли̑1м1люще11лющї1лє́с11лі́1т1лї1к1лї1л1лї1м1лїа̀1лїан1лїѐ1лїев1лїѝ1лїи́1лїим1лїин1лїпп1лїю̀1лїѧ_1лїѧ̑1лѡ1с21лѡтї1лѣ́1ш1лѣ́ж11лѧ́1с1лѷ2м11лꙋ́1в1лꙋ́1н1лꙋ́й1лꙋ́ч11лꙋ́ї1м2лѝ1ма́1ж1ма́1з1ма́1ш1ма́й1марѧ11ме1д21ме́1л1ме́з11ме́й1ме́ц11мерї11ми1с21ми1т21ми́1с1ми́1т1мирѝ1мли́11мни1т1мо1з21мо́1к1море11мы́н11мє́н11мі́1н1мї1л1мї1н1мї1с1мїи_1мїѝ1мїй1мїѡ11мѣнѝ1мѧтї1не2ж11не́1ж1не́1л1не́ч11нена11ни́1с1ни̑в11нис1п1нити11но́1д1но́1ф1но́ї1ново11нопо11ны́1н1нѣ2ш11нѧ́й1нꙋ́1д1нꙋ́1с1нꙋ́1ф1нꙋ́ѧ11п2лї11п2лѡ21п2лꙋ11п2не21па́1г1па́1ч1па́ю11падѐ1падѝ1пасї11пе́1з1пле1в1пле1м1пле1н1по1в21по1м21по1с21по́й1пі́1н1пі́1т1пѧ́1с1пѧ́л11ра́ї11рапї1реде11рей_1ремї1рена11ренї11речѐ1ри́1ц1ри́ч11ро́1ц1ров1н1ров1с1родо11рі́е11рї1л1рїин1рїкъ1рїсе1рїсє1рїтѡ1рїе1в1рѣ́й1рѣ̑1ч1рѣ̑й1рѷ1м1рѷ2к1рꙋ́т11рꙋ́ч11рꙋѧй1с2нѝ1с2пѝ1с2тѐ1с2тє11с2тї11с2це11са1л21са1р21са1с21са́1с1са́ї11са̑1н1се́1ѵ1сера11си1с21си́1с1склї11сней1снен11сни̑11сны́11снїю1со1з21со1мн1спа1с1спи1т1ствї1стей1сто1с1стрѐ1сы́1т1сє́1н1сє́й1т2лѝ1т2це21т2чѐ1т2чи21та́1г1тарѝ1тве1ц1твый1твѣ́11те1т21тер1м1теро11течѐ1ти1с21ти́1д1ти́1з1ти̑1н1тив1л1тиво11тими11тлан11тли́11то1з21то́1з1тов1л1тодї1толе11толѝ1тона11топ1л1тосо11тощѝ1тре1ц1тчей1тє́1ч1тє́й1ті́е11тї1п1тїа_1тїѐ1тїе́1тїею1тїѝ1тїй1тїих1тїю̀1тїѧ̀1тїѧг1тїѧм1тїѧх1тїлї11тїно11тѡ́1к1тѣ́1т1тѣ́1ш1тѣ́ю11тѧ2т11тѧ́1х1тѧ́й1тꙋ2р11тꙋ́е11тꙋ́ю11хи1т21хо́1щ1хо́в11ходо11ца́1л1ца́1т1ца́1ш1ца́ю11це́1т1цꙋ́з11что́11ща1с21ща́1м1ща́1х1ща́д11щє1н21щє́н11ющїи1ющїѧ1є́мы11ї1лѧ1ї1ны1їина1їно_1їтѝ1ѡ1с2к1ѡ1са11ѡ1сѣ11ѡ́р1г1ѡа2н11ѧ1зы21ѧ2з1в1ѧ́з1в1ѧнї11ѳи́1с1ѳі́1с1ѷ1сє1ѷпо11ѷ1се21ѻ1рꙋ21ꙋ1лї11ꙋ́лї1ꙋ́мї11ꙋ́нї1ꙋмѣ̑11ꙋстї2а2з1р2анї12б1ло12в1ню12ви1з22вчї12вѣ2з12д1ло12д1нѝ2д1нѧ12е1м2л2е1мѧ22е1т2к2е1т2л2е1то22е1тї12е1тѡ12е2м1п2з1д2в2з1дї12з1лї12к1не22ли1с22ли2з12м1не12м1па22м1по12м1ти12не1з22не1р22ни2з12п1на12п1но12п1нꙋ12пе2ѵ12пнї12рѷ1с2с2т1ц2спї12т1ки22т1ко12т1кї2т1кꙋ22т1лї12т1лꙋ12те1з22ты1н22тє1н22х1мѝ2є1мї12ї1ка2ї1ки2ї1ла2ї1лї2їлї2їн1б2ѡ1ре22ѧ1з2ꙋ2ѧ̑2ж12ѷс1с2ѷ1со22ꙋ1тї12ꙋ2м1л8а҆̀8_8а҆́8_8а҆̈8_8а҆̑8_8е҆̀8_8е҆́8_8е҆̈8_8е҆̑8_8й̀8_8й́8_8й̈8_8й̑8_8йⷠ҇_8йⷡ҇_8йⷢ҇_8йⷣ҇_8йⷤ҇_8йⷥ҇_8йⷦ҇_8йⷧ҇_8йⷨ҇_8йⷩ҇_8йⷪ҇_8йⷫ҇_8йⷬ҇_8йⷭ҇_8йⷮ҇_8йⷯ҇_8йⷰ҇_8йⷱ҇_8йⷲ҇_8йⷳ҇_8йⷴ҇_8йⷵ҇_8йⷶ҇_8йⷷ҇_8йⷸ҇_8йⷹ҇_8йⷺ҇_8йⷻ҇_8йⷼ҇_8йⷽ҇_8йⷾ҇_8йⷿ҇_8йꙴ҇_8йꙵ҇_8йꙶ҇_8йꙷ҇_8йꙸ҇_8йꙹ҇_8йꙺ҇_8йꙻ҇_8й꙼҇_8й꙽҇_8и҆̀8_8и҆́8_8и҆̈8_8и҆̑8_8й҆̀8_8й҆́8_8й҆̈8_8й҆̑8_8о҆̀8_8о҆́8_8о҆̈8_8о҆̑8_8ствъ_8у҆̀8_8у҆́8_8у҆̈8_8у҆̑8_8ы҆̀8_8ы҆́8_8ы҆̈8_8ы҆̑8_8э҆̀8_8э҆́8_8э҆̈8_8э҆̑8_8ю҆̀8_8ю҆́8_8ю҆̈8_8ю҆̑8_8є҆̀8_8є҆́8_8є҆̈8_8є҆̑8_8і҆̀8_8і҆́8_8і҆̈8_8і҆̑8_8ѡ҆̀8_8ѡ҆́8_8ѡ҆̈8_8ѡ҆̑8_8ѣ҆̀8_8ѣ҆́8_8ѣ҆̈8_8ѣ҆̑8_8ѧ҆̀8_8ѧ҆́8_8ѧ҆̈8_8ѧ҆̑8_8ѵ҆̀8_8ѵ҆́8_8ѵ҆̈8_8ѵ҆̑8_8ѹ҆̀8_8ѹ҆́8_8ѹ҆̈8_8ѹ҆̑8_8ѻ҆̀8_8ѻ҆́8_8ѻ҆̈8_8ѻ҆̑8_8ѽ҆̀8_8ѽ҆́8_8ѽ҆̈8_8ѽ҆̑8_8ѿ҆̀8_8ѿ҆́8_8ѿ҆̈8_8ѿ҆̑8_8ᲂӱ8_8ᲂу҆̀_8ᲂу҆́_8ᲂу҆̈_8ᲂу҆̑_8ᲂуⷠ҇_8ᲂуⷡ҇_8ᲂуⷢ҇_8ᲂуⷣ҇_8ᲂуⷤ҇_8ᲂуⷥ҇_8ᲂуⷦ҇_8ᲂуⷧ҇_8ᲂуⷨ҇_8ᲂуⷩ҇_8ᲂуⷪ҇_8ᲂуⷫ҇_8ᲂуⷬ҇_8ᲂуⷭ҇_8ᲂуⷮ҇_8ᲂуⷯ҇_8ᲂуⷰ҇_8ᲂуⷱ҇_8ᲂуⷲ҇_8ᲂуⷳ҇_8ᲂуⷴ҇_8ᲂуⷵ҇_8ᲂуⷶ҇_8ᲂуⷷ҇_8ᲂуⷸ҇_8ᲂуⷹ҇_8ᲂуⷺ҇_8ᲂуⷻ҇_8ᲂуⷼ҇_8ᲂуⷽ҇_8ᲂуⷾ҇_8ᲂуⷿ҇_8ᲂуꙴ҇_8ᲂуꙵ҇_8ᲂуꙶ҇_8ᲂуꙷ҇_8ᲂуꙸ҇_8ᲂуꙹ҇_8ᲂуꙺ҇_8ᲂуꙻ҇_8ᲂу꙼҇_8ᲂу꙽҇_8ᲂ҆̀8_8ᲂ҆́8_8ᲂ҆̈8_8ᲂ҆̑8_8ꙋ҆̀8_8ꙋ҆́8_8ꙋ҆̈8_8ꙋ҆̑8_8ꙍ҆̀8_8ꙍ҆́8_8ꙍ҆̈8_8ꙍ҆̑8_8ꙍ҆̑ⷠ_8ꙍ҆̑ⷡ_8ꙍ҆̑ⷢ_8ꙍ҆̑ⷣ_8ꙍ҆̑ⷤ_8ꙍ҆̑ⷥ_8ꙍ҆̑ⷦ_8ꙍ҆̑ⷧ_8ꙍ҆̑ⷨ_8ꙍ҆̑ⷩ_8ꙍ҆̑ⷪ_8ꙍ҆̑ⷫ_8ꙍ҆̑ⷬ_8ꙍ҆̑ⷭ_8ꙍ҆̑ⷮ_8ꙍ҆̑ⷯ_8ꙍ҆̑ⷰ_8ꙍ҆̑ⷱ_8ꙍ҆̑ⷲ_8ꙍ҆̑ⷳ_8ꙍ҆̑ⷴ_8ꙍ҆̑ⷵ_8ꙍ҆̑ⷶ_8ꙍ҆̑ⷷ_8ꙍ҆̑ⷸ_8ꙍ҆̑ⷹ_8ꙍ҆̑ⷺ_8ꙍ҆̑ⷻ_8ꙍ҆̑ⷼ_8ꙍ҆̑ⷽ_8ꙍ҆̑ⷾ_8ꙍ҆̑ⷿ_8ꙍ҆̑ꙴ_8ꙍ҆̑ꙵ_8ꙍ҆̑ꙶ_8ꙍ҆̑ꙷ_8ꙍ҆̑ꙸ_8ꙍ҆̑ꙹ_8ꙍ҆̑ꙺ_8ꙍ҆̑ꙻ_8ꙍ҆̑꙼_8ꙍ҆̑꙽_8ꙗ҆̀8_8ꙗ҆́8_8ꙗ҆̈8_8ꙗ҆̑8__врї1_вїа1_й҆̀8_й҆́8_й҆̈8_й҆̑8_йⷠ҇8_йⷡ҇8_йⷢ҇8_йⷣ҇8_йⷤ҇8_йⷥ҇8_йⷦ҇8_йⷧ҇8_йⷨ҇8_йⷩ҇8_йⷪ҇8_йⷫ҇8_йⷬ҇8_йⷭ҇8_йⷮ҇8_йⷯ҇8_йⷰ҇8_йⷱ҇8_йⷲ҇8_йⷳ҇8_йⷴ҇8_йⷵ҇8_йⷶ҇8_йⷷ҇8_йⷸ҇8_йⷹ҇8_йⷺ҇8_йⷻ҇8_йⷼ҇8_йⷽ҇8_йⷾ҇8_йⷿ҇8_йꙴ҇8_йꙵ҇8_йꙶ҇8_йꙷ҇8_йꙸ҇8_йꙹ҇8_йꙺ҇8_йꙻ҇8_й꙼҇8_й꙽҇8_сї1м_трї1_ꙍ҆̑̀8_ꙍ҆̑́8_ꙍ҆̑̈8_ꙍ҆̑̑8_ꙍ҆̑҆8_ꙍ҆̑ⷠ8_ꙍ҆̑ⷡ8_ꙍ҆̑ⷢ8_ꙍ҆̑ⷣ8_ꙍ҆̑ⷤ8_ꙍ҆̑ⷥ8_ꙍ҆̑ⷦ8_ꙍ҆̑ⷧ8_ꙍ҆̑ⷨ8_ꙍ҆̑ⷩ8_ꙍ҆̑ⷪ8_ꙍ҆̑ⷫ8_ꙍ҆̑ⷬ8_ꙍ҆̑ⷭ8_ꙍ҆̑ⷮ8_ꙍ҆̑ⷯ8_ꙍ҆̑ⷰ8_ꙍ҆̑ⷱ8_ꙍ҆̑ⷲ8_ꙍ҆̑ⷳ8_ꙍ҆̑ⷴ8_ꙍ҆̑ⷵ8_ꙍ҆̑ⷶ8_ꙍ҆̑ⷷ8_ꙍ҆̑ⷸ8_ꙍ҆̑ⷹ8_ꙍ҆̑ⷺ8_ꙍ҆̑ⷻ8_ꙍ҆̑ⷼ8_ꙍ҆̑ⷽ8_ꙍ҆̑ⷾ8_ꙍ҆̑ⷿ8_ꙍ҆̑ꙴ8_ꙍ҆̑ꙵ8_ꙍ҆̑ꙶ8_ꙍ҆̑ꙷ8_ꙍ҆̑ꙸ8_ꙍ҆̑ꙹ8_ꙍ҆̑ꙺ8_ꙍ҆̑ꙻ8_ꙍ҆̑꙼8_ꙍ҆̑꙽8́1блѧ1́1брꙋ1́1дра1́1плѧ1́1рѷ2́1спо1́1три1́2д1н2́б1лю1́з1на1́з1но1́ннї1́с1на1́ї1л2̑1дї1̑1кї1̑1лї1̑1тї1̑в1ни1̑днї1̑з1на1̑йши1̑пкї1̑с1на1а1рѷ1аврї1айшї1айшї1аллї1аннї1аркї1артї1арїи1ас1па1ассї1атрї1ающї1б1ле1цб1лѧ́1бы́7выв1да̑1в1лю́1в1лєн1венї1вскї1вї2л1вѷ2с1г1нꙋ1тг2лѷ1д1ва1рд1на́1д1но1мд1но́1е1дне1е1лї1е́дї1е́нї1е́щї1ед1ва1ед1ла1ед1но1еднї1ентї1ерї1керїн1ждшї1женї1з1да1лз1дне1з1дно1з1ни1кз1ни́1з1нис1з1но1ми1зно1и1лї1и́вї1и́лї1и́нї1и́рї1и́тї1йнї1йска1йско1йскꙋ1иннї1ипїо1итрї1и҆лї1клї1пкѷ2м1л1мї1лерї1ллї1нлнїи1лнїѧ1лїко1лїо́1лїса1лѷ2м1м1но1ммїи́1мїлї1мїса1мїха1мїлї1нї2г1нїе1внїка1нїма1нїне1нїѧ1мо1вне1о1рѷ1о1спи1о2з1л2о́тї1о́щї1оз1до1оз1ды1оллї1олїн1ордї1ос1пе1п1лѧ́1полї1прїѡ1пї1с2пїо́1р1з2н2р1мї1р1твїрншї1ролї1рї1с2рїи1мс1ни1кс1па1дс2лї1тенї1тїнї1тїнї1тѷ2м1фрї1кфї1л2фїла1хїсе1ч1не1мченї1черї1чис7лечис7лѣшенї1щенї1ы1рї1ы́лї1ы́нї1ы́тї1ю́дї1є́лї1є́нї1єскї1ї1кї1ї1ло1ї1лꙋ1ї1ме1ї1мо1ї1мї1ї1на2ї1па2ї1ро1ї1со1ї1стеї1стої1стрї1ѷ1ї2г1гїа́1дїве́1ївї1їги́1їдї1їе1р2їе́1шїи1с2їи́1дїи́1нїи̑м1їка1нїки́1їко1нїко́1їкто1їкї1їл1в2їла1рїле́1їллї1їлїп1їман1їне́1їноа1їнтї1їо1с2їо́1пїпї1їпїо1їс2т2їса1вїсі́1їті́1їтѷ1їфа́1їха́1їхи́1їхи̑1їча́1їѧ1в2їѧ́1сї1мї1їллї1їлїп1їнтї1їпїо1ѡ1с2т2ѡ́гї1ѡ́жї1ѡ́лї1ѡ́мї1ѣ1дї2ѣ1сто1ѣ́дї1ѣ́пї1ѣ́рї1ѧ́тї1ѳїфа1ѵ́нї1ѷ1г2нѷ1ме1ѷ1мї1ѷ2м1пѷзан1ѷка1рѷке́1ѷкто1ѷлі́1ѷмпї1ѷно́1ѷпі́1ѷрї1ѷсо́1ѷхї1ѷ1мї1ѷмпї1ѿ7нн҃ѣ҆1мї1҆1рї1҆1спѣ1҆́вї1҆́дї1҆з1да1҆з1ре1҆з1ри1҆лїи1҆лїо1҆нтї1҆сѷг1҆фрї1҇рдї1ᲂу҆1б2ᲂу҆1в2ᲂу҆1з2ᲂу҆1м2ᲂу҆1скᲂу҆1спᲂу҆́1бᲂу҆́1нᲂу҆́1хᲂу҆́1чᲂу҆га1ᲂу҆ко1ᲂу҆не1ᲂу҆ни1ᲂу҆по1ᲂу҆та1ᲂу҆то1ꙋ1трꙋ1ꙋ́жї1",
		7 : "1б2лї11ет1на11з2нї11из1ре11кї2л11кї2н11мерї11пасї11ра́ї11ренї11рїе1в1са́ї11склї11тїлї11тїно11тїлї11ѷ1се21ꙋ1лї11ꙋ́мї12з1дї12з1лї12т1лї12є1мї12ѷ1со28й҆̀8_8й҆́8_8й҆̈8_8й҆̑8_8ꙍ҆̑̀8_8ꙍ҆̑́8_8ꙍ҆̑̈8_8ꙍ҆̑̑8_8ꙍ҆̑ⷠ҇_8ꙍ҆̑ⷡ҇_8ꙍ҆̑ⷢ҇_8ꙍ҆̑ⷣ҇_8ꙍ҆̑ⷤ҇_8ꙍ҆̑ⷥ҇_8ꙍ҆̑ⷦ҇_8ꙍ҆̑ⷧ҇_8ꙍ҆̑ⷨ҇_8ꙍ҆̑ⷩ҇_8ꙍ҆̑ⷪ҇_8ꙍ҆̑ⷫ҇_8ꙍ҆̑ⷬ҇_8ꙍ҆̑ⷭ҇_8ꙍ҆̑ⷮ҇_8ꙍ҆̑ⷯ҇_8ꙍ҆̑ⷰ҇_8ꙍ҆̑ⷱ҇_8ꙍ҆̑ⷲ҇_8ꙍ҆̑ⷳ҇_8ꙍ҆̑ⷴ҇_8ꙍ҆̑ⷵ҇_8ꙍ҆̑ⷶ҇_8ꙍ҆̑ⷷ҇_8ꙍ҆̑ⷸ҇_8ꙍ҆̑ⷹ҇_8ꙍ҆̑ⷺ҇_8ꙍ҆̑ⷻ҇_8ꙍ҆̑ⷼ҇_8ꙍ҆̑ⷽ҇_8ꙍ҆̑ⷾ҇_8ꙍ҆̑ⷿ҇_8ꙍ҆̑ꙴ҇_8ꙍ҆̑ꙵ҇_8ꙍ҆̑ꙶ҇_8ꙍ҆̑ꙷ҇_8ꙍ҆̑ꙸ҇_8ꙍ҆̑ꙹ҇_8ꙍ҆̑ꙺ҇_8ꙍ҆̑ꙻ҇_8ꙍ҆̑꙼҇_8ꙍ҆̑꙽҇__раз7ꙋм_ꙍ҆̑҆̀8_ꙍ҆̑҆́8_ꙍ҆̑҆̈8_ꙍ҆̑҆̑8_ꙍ҆̑ⷠ҇8_ꙍ҆̑ⷡ҇8_ꙍ҆̑ⷢ҇8_ꙍ҆̑ⷣ҇8_ꙍ҆̑ⷤ҇8_ꙍ҆̑ⷥ҇8_ꙍ҆̑ⷦ҇8_ꙍ҆̑ⷧ҇8_ꙍ҆̑ⷨ҇8_ꙍ҆̑ⷩ҇8_ꙍ҆̑ⷪ҇8_ꙍ҆̑ⷫ҇8_ꙍ҆̑ⷬ҇8_ꙍ҆̑ⷭ҇8_ꙍ҆̑ⷮ҇8_ꙍ҆̑ⷯ҇8_ꙍ҆̑ⷰ҇8_ꙍ҆̑ⷱ҇8_ꙍ҆̑ⷲ҇8_ꙍ҆̑ⷳ҇8_ꙍ҆̑ⷴ҇8_ꙍ҆̑ⷵ҇8_ꙍ҆̑ⷶ҇8_ꙍ҆̑ⷷ҇8_ꙍ҆̑ⷸ҇8_ꙍ҆̑ⷹ҇8_ꙍ҆̑ⷺ҇8_ꙍ҆̑ⷻ҇8_ꙍ҆̑ⷼ҇8_ꙍ҆̑ⷽ҇8_ꙍ҆̑ⷾ҇8_ꙍ҆̑ⷿ҇8_ꙍ҆̑ꙴ҇8_ꙍ҆̑ꙵ҇8_ꙍ҆̑ꙶ҇8_ꙍ҆̑ꙷ҇8_ꙍ҆̑ꙸ҇8_ꙍ҆̑ꙹ҇8_ꙍ҆̑ꙺ҇8_ꙍ҆̑ꙻ҇8_ꙍ҆̑꙼҇8_ꙍ҆̑꙽҇8айшї1во8дна́во8дно́во8дны́вѣст7вожа́7тважа́7твыжа́7твꙋжи́7зниис7полнис7хо́дис7хождис7черпкос7новкос7нꙋ́мїлї1па́7сцѣтїнї1ї1мї1їллї1їлїп1їнтї1їпїо1ѷ1мї1ѷмпї1ꙋка7за́",
		8 : "1тїлї18ꙍ҆̑҆̀8_8ꙍ҆̑҆́8_8ꙍ҆̑҆̈8_8ꙍ҆̑҆̑8__а҆с7сѷр_вос7пѣв_зе́7мле_зе́7млю_и҆с7кꙋс_и҆с7тек_мес7сі́_по7злащ_при7льп_раз7ꙋ́м_ѡ҆б7лещ_ѡ҆б7ращ_ѻ҆́т8ча_ѻ҆́т8че_ѿ7всю́дбоѧ́7знивоз8да́нвѣст7вꙋ́дне8внꙋ́дрѣ́7влеис7цѣ́льис7цѣ̑лькел7сі́йклѧ́т7ваклѧ́т7воклѧ́т7выклѧ́т7вѣклѧ́т7вꙋкос7не́ткос7ни́тне7зра́чне8с7тѝ_нов7ле́нра8с7падра8с7палрас7пнѝтер8п7лѧтре8б7лѧче7с8тѝ_ѡбра7зꙋ́",
		9 : "_а҆кта́7ꙋ_а҆с7сѷр_вос7пѣ́в_вос7трꙋб_и҆с7кꙋ́с_и҆с7те́к_и҆са́7їе_и҆са́7їѧ_по7всю́д_по7чне́т_пѣ́7с8не_пѣ́7с8ни_пѣ́7с8ню_пѣ́7с8нѣ_ра8с7тлѝ_ра8с7тлѧ_ра8с7точ_сла7сте́_со7з8ва́_і҆ес7се́_ѡ҆7бра́з_ѡ҆7брѣ́л_ѡ҆7брѣ́т_ѡ҆б7ле́к_ѡ҆б7ра́т_ѡ҆б7ра́щ_ѡ҆б7рѣ́з_ѵ҆с7сѡ́п_ѹ҆7стрембла́з7ненболѣ́7знеболѣ́7зниве́тхо7мꙋвѣ́8ст7водви́8г7лажи8в7ле́нкел7сі́йклѧ́т7венколос7са́моли́7твамоли́7твомоли́7твымоли́7твѣмоли́7твꙋне8с7ла̀_не8с7ло̀_не8с7тѝ_ра8с7та́ѧра8с7творра8с7терзсла́8в7люсре́7д8неста́в7лю_тер8п7лю̀ца́р7стваца́р7ствоца́р7ствїца́р7ствѣца́р7ствꙋче7с8тѝ_ѹ҆7сте́нъ",
		10 : "_во7с8прѧн_вос7трꙋ́б_гри́7в8на_гри́7в8ны_гри̑7в8ны_гри̑7в8нѣ_и҆с7корен_и҆с8то́тн_и҆са́7їе_и҆са́7їѧ_ме7т8не́н_наза7ре́т_по8д7но́г_по8д7но́ж_по́7ж8нет_по́7ж8нꙋт_по́7м8нит_при́7т8ча_при́7т8че_при́7т8чи_про7з8ва̀_про́7стрꙋ_прїе́м7ле_прїе́м7ли_прїе́м7лю_прїе́м7лѣ_прїе́м7лѧ_ра8с7тлѝ_ра8с7тлѣ́_стра7сте́_че8ст7вов_че8ст7вꙋ́_ѡ҆бра7зꙋ́_ѳес7салон_ѻ҆́т7расл_ᲂу҆7стремве́7тсѣмъ_ло7ви́7твало7ви́7твыло7ви́7твꙋмоли́7твенпра́з7дникпра́з7дницра8с7ка́етра8с7ка́ѧнра8с7простра8с7то́ргра8с7то́ржре́7в8ностсла́8в7ленспа8с7ла̀_спа8с7ло̀_ста́8в7ленстраж7бы̑_сынов8ле́нтре8б7ле́нтре8б7лю̀_ца́р7ствї",
		11 : "_а҆рїа́7д8н_во7с8прѧ́н_вос7трепет_и҆зба́7вле_и҆зба́7влю_и҆с7ка́пав_полꙋ́7д8не_полꙋ́7д8ни_пото8п7лѧ́_пре7ль8ща́_прїе́м7ле_прїе́м7ли_прїе́м7лю_прїе́м7лѣ_прїе́м7лѧ_ѡ҆8т7ве́рг_ѡ҆8т7ве́рж_ѡ҆8т7ры́гн_ѻ҆б7ра́дова҆́нгел7ми_вис7сарїѡ́ндости́8г7лаᲂу҆7сте́нъ",
		12 : "_а҆рїа́7д8н_вос7тре́пет_пото8п7ле́н_пре7ль8сти́_сподо8б7лѧ́_ѡ҆8б7ра́доввис7сарїѡ́нкова́р7ство_мї7ли́с7сенъсїл7ве́7стрꙋє҆ѵел7пі́стъ",
		13 : "_а҆вес7салѡ́м_мел7хїседе́ккле7о7па́7трамї7ли́с7сенъсїл7ве́7стрꙋ",
		14 : "_мел7хїседе́к",
		17 : "пре7вы́7спрєн7нѧѧ"
	},
	patternChars : "_̀́̆̇̈̏̑̾абвгдежзийклмнопрстуфхцчшщъыьэюѐёєѕіїѝѡѣѧѯѱѳѵѷѹѻѽѿ҃҆҇ӓӥӧӭӱӹᲂᲆⷠⷡⷢⷣⷤⷥⷦⷧⷨⷩⷪⷫⷬⷭⷮⷯⷰⷱⷲⷳⷴⷵⷶⷷⷸⷹⷺⷻⷼⷽⷾⷿⸯꙋꙍꙗꙴꙵꙶꙷꙸꙹꙺꙻ꙼꙽꙾ꙿ︦︮︯",
	patternArrayLength : 934205,
	valueStoreLength : 58319
};
