# Material Design CSS Framework

[![MUI](https://www.muicss.com/static/favicons/icon-192x192.png)](https://www.muicss.com)

MUI is a lightweight CSS framework that follows Google's Material Design guidelines.

[![Join the chat at https://gitter.im/muicss/mui](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/muicss/mui?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![Build Status](https://travis-ci.org/muicss/mui.svg?branch=master)](https://travis-ci.org/muicss/mui)
[![Dependency Status](https://david-dm.org/muicss/mui.svg)](https://david-dm.org/muicss/mui)
[![devDependency Status](https://david-dm.org/muicss/mui/dev-status.svg)](https://david-dm.org/muicss/mui#info=devDependencies)

## Features

MUI is designed from the ground up to be fast, small and developer friendly. By design it only includes the basic components you need to build a site that follows Google's Material Design guidelines. Some of the key features of MUI are:

* Small footprint: mui.min.css - 6.6K, mui.min.js - 5.4K (gzipped)
* A responsive grid to make mobile-friendly sites
* No external dependencies
* CSS library that can be customized with your own colors
* JS library can be loaded asyncronously
* Email library for styling HTML emails

To get started using MUI, go to the [MUI website](https://www.muicss.com) to see examples and download boilerplate HTML.

## Browser Support 

MUI is tested and works in:

* IE10+
* Latest Stable: Firefox, Chrome, Safari
* iOS 6+

## Directory Tree

<pre>
muicss:mui/
├── lib
│   ├── css
│   │   └── mui.css
│   └── js
│       └── mui.js
├── LICENSE.txt
├── package.js
└── README.md
</pre>
